/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.ComparableMultiMapSTL;
import generic.stl.IteratorSTL;
import generic.stl.MapIteratorSTL;
import generic.stl.Pair;
import generic.stl.RedBlackNode;
import generic.stl.RedBlackTree;
import generic.stl.ReverseMapIteratorSTL;
import java.util.Comparator;

public class MultiMapSTL<K, V> {
    RedBlackTree<K, V> rbTree;

    public MultiMapSTL(Comparator<K> comparator) {
        this.rbTree = new RedBlackTree(comparator, true);
    }

    public void add(K key, V value) {
        this.rbTree.put(key, value);
    }

    public boolean contains(K key) {
        return this.rbTree.containsKey(key);
    }

    public V remove(K key) {
        return this.rbTree.remove(key);
    }

    public void erase(IteratorSTL<Pair<K, V>> iter) {
        MapIteratorSTL it = (MapIteratorSTL)iter;
        RedBlackNode node = it.node;
        if (node == null) {
            throw new IndexOutOfBoundsException();
        }
        it.node = node.getSuccessor();
        it.erased = true;
        this.rbTree.deleteEntry(node);
    }

    public IteratorSTL<Pair<K, V>> begin() {
        return new MapIteratorSTL<K, V>(this.rbTree, this.rbTree.getFirst());
    }

    public IteratorSTL<Pair<K, V>> end() {
        return new MapIteratorSTL<K, V>(this.rbTree, null);
    }

    public IteratorSTL<Pair<K, V>> rBegin() {
        return new ReverseMapIteratorSTL<K, V>(this.rbTree, this.rbTree.getLast());
    }

    public IteratorSTL<Pair<K, V>> rEnd() {
        return new ReverseMapIteratorSTL<K, V>(this.rbTree, null);
    }

    public IteratorSTL<Pair<K, V>> lower_bound(K key) {
        RedBlackNode<K, V> node = this.rbTree.lowerBound(key);
        return new MapIteratorSTL<K, V>(this.rbTree, node);
    }

    public IteratorSTL<Pair<K, V>> upper_bound(K key) {
        RedBlackNode<K, V> node = this.rbTree.upperBound(key);
        MapIteratorSTL<K, V> it = new MapIteratorSTL<K, V>(this.rbTree, node);
        return it;
    }

    public static void main(String[] args) {
        ComparableMultiMapSTL<Integer, String> set = new ComparableMultiMapSTL<Integer, String>();
        set.add(7, "dog");
        set.add(3, "blue");
        set.add(9, "elf");
        set.add(20, "gate");
        set.add(15, "fog");
        set.add(1, "apple");
        set.add(20, "hog");
        set.add(20, "indian");
        set.add(4, "cat");
        set.add(50, "jump");
    }
}

