/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractReferenceMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class ReferenceSymbolApplier
extends MsSymbolApplier {
    private AbstractReferenceMsSymbol symbol;

    public ReferenceSymbolApplier(DefaultPdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof AbstractReferenceMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (AbstractReferenceMsSymbol)abstractSymbol;
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void apply() throws CancelledException, PdbException {
        SymbolGroup.AbstractMsSymbolIterator refIter = this.getInitializedReferencedSymbolGroupIterator();
        if (refIter == null) {
            throw new PdbException("PDB: Referenced Symbol Error - null refIter");
        }
        this.applicator.procSym(refIter);
    }

    SymbolGroup.AbstractMsSymbolIterator getInitializedReferencedSymbolGroupIterator() {
        SymbolGroup refSymbolGroup = this.getReferencedSymbolGroup();
        if (refSymbolGroup == null) {
            return null;
        }
        SymbolGroup.AbstractMsSymbolIterator refIter = refSymbolGroup.iterator();
        refIter.initGetByOffset(this.getOffsetInReferencedSymbolGroup());
        return refIter;
    }

    SymbolGroup getReferencedSymbolGroup() {
        int refModuleNumber = this.symbol.getModuleIndex();
        return this.applicator.getSymbolGroupForModule(refModuleNumber);
    }

    long getOffsetInReferencedSymbolGroup() {
        return this.symbol.getOffsetActualSymbolInDollarDollarSymbols();
    }
}

