/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractSymbolInternals;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureFlags;

public class ProcedureStartSymbolInternals
extends AbstractSymbolInternals {
    protected long parentPointer;
    protected long endPointer;
    protected long nextPointer;
    protected long procedureLength;
    protected long debugStartOffset;
    protected long debugEndOffset;
    protected RecordNumber typeRecordNumber;
    protected long offset;
    protected int segment;
    protected ProcedureFlags flags;
    protected String name;

    public static ProcedureStartSymbolInternals parse16(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        ProcedureStartSymbolInternals result = new ProcedureStartSymbolInternals(pdb);
        result.parentPointer = reader.parseUnsignedIntVal();
        result.endPointer = reader.parseUnsignedIntVal();
        result.nextPointer = reader.parseUnsignedIntVal();
        result.procedureLength = reader.parseUnsignedShortVal();
        result.debugStartOffset = reader.parseUnsignedShortVal();
        result.debugEndOffset = reader.parseUnsignedShortVal();
        result.offset = reader.parseUnsignedShortVal();
        result.segment = pdb.parseSegment(reader);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        result.flags = new ProcedureFlags(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        reader.align4();
        return result;
    }

    public static ProcedureStartSymbolInternals parse32(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        ProcedureStartSymbolInternals result = new ProcedureStartSymbolInternals(pdb);
        result.parentPointer = reader.parseUnsignedIntVal();
        result.endPointer = reader.parseUnsignedIntVal();
        result.nextPointer = reader.parseUnsignedIntVal();
        result.procedureLength = reader.parseUnsignedIntVal();
        result.debugStartOffset = reader.parseUnsignedIntVal();
        result.debugEndOffset = reader.parseUnsignedIntVal();
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.offset = reader.parseUnsignedIntVal();
        result.segment = pdb.parseSegment(reader);
        result.flags = new ProcedureFlags(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        reader.align4();
        return result;
    }

    public static ProcedureStartSymbolInternals parse3216(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        ProcedureStartSymbolInternals result = new ProcedureStartSymbolInternals(pdb);
        result.parentPointer = reader.parseUnsignedIntVal();
        result.endPointer = reader.parseUnsignedIntVal();
        result.nextPointer = reader.parseUnsignedIntVal();
        result.procedureLength = reader.parseUnsignedIntVal();
        result.debugStartOffset = reader.parseUnsignedIntVal();
        result.debugEndOffset = reader.parseUnsignedIntVal();
        result.offset = reader.parseUnsignedIntVal();
        result.segment = pdb.parseSegment(reader);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        result.flags = new ProcedureFlags(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        reader.align4();
        return result;
    }

    public static ProcedureStartSymbolInternals parse32St(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        ProcedureStartSymbolInternals result = new ProcedureStartSymbolInternals(pdb);
        result.parentPointer = reader.parseUnsignedIntVal();
        result.endPointer = reader.parseUnsignedIntVal();
        result.nextPointer = reader.parseUnsignedIntVal();
        result.procedureLength = reader.parseUnsignedIntVal();
        result.debugStartOffset = reader.parseUnsignedIntVal();
        result.debugEndOffset = reader.parseUnsignedIntVal();
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.offset = reader.parseUnsignedIntVal();
        result.segment = pdb.parseSegment(reader);
        result.flags = new ProcedureFlags(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        reader.align4();
        return result;
    }

    public ProcedureStartSymbolInternals(AbstractPdb pdb) {
        super(pdb);
    }

    public long getParentPointer() {
        return this.parentPointer;
    }

    public long getEndPointer() {
        return this.endPointer;
    }

    public long getNextPointer() {
        return this.nextPointer;
    }

    public long getProcedureLength() {
        return this.procedureLength;
    }

    public long getDebugStartOffset() {
        return this.debugStartOffset;
    }

    public long getDebugEndOffset() {
        return this.debugEndOffset;
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSegment() {
        return this.segment;
    }

    public ProcedureFlags getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        StringBuilder prefixBuilder = new StringBuilder();
        StringBuilder postfixBuilder = new StringBuilder();
        prefixBuilder.append(String.format(": [%04X:%08X], Length: %08X, ", this.segment, this.offset, this.procedureLength));
        postfixBuilder.append(String.format(": %s, %s\n", this.pdb.getTypeRecord(this.typeRecordNumber), this.name));
        postfixBuilder.append(String.format("   Parent: %08X, End: %08X, Next: %08X\n", this.parentPointer, this.endPointer, this.nextPointer));
        postfixBuilder.append(String.format("   Debug start: %08X, Debug end: %08X\n", this.debugStartOffset, this.debugEndOffset));
        postfixBuilder.append(this.flags.toString());
        builder.insert(0, prefixBuilder);
        builder.append((CharSequence)postfixBuilder);
    }
}

