/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.types.hfs.CatKeyRec;
import org.catacombae.hfsexplorer.types.hfs.CdrFilRec;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFile;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogKey;

public abstract class CommonHFSCatalogFileRecord
extends CommonHFSCatalogLeafRecord {
    protected CommonHFSCatalogKey key;
    protected CommonHFSCatalogFile data;

    private CommonHFSCatalogFileRecord(CommonHFSCatalogKey key, CommonHFSCatalogFile data) {
        this.key = key;
        this.data = data;
    }

    public CommonHFSCatalogKey getKey() {
        return this.key;
    }

    public CommonHFSCatalogFile getData() {
        return this.data;
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + CommonHFSCatalogFileRecord.class.getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + "key:");
        this.key.print(ps, prefix + " ");
        ps.println(prefix + "data:");
        this.data.print(ps, prefix + " ");
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(CommonHFSCatalogFileRecord.class.getSimpleName(), "File record");
        db.add("key", this.key.getStructElements(), "Catalog key");
        db.add("data", this.data.getStructElements(), "File data");
        return db.getResult();
    }

    public static CommonHFSCatalogFileRecord create(HFSPlusCatalogKey key, HFSPlusCatalogFile data) {
        return new HFSPlusImplementation(key, data);
    }

    public static CommonHFSCatalogFileRecord create(CatKeyRec key, CdrFilRec data) {
        return new HFSImplementation(key, data);
    }

    public static class HFSPlusImplementation
    extends HFSImplementation {
        public HFSPlusImplementation(HFSPlusCatalogKey key, HFSPlusCatalogFile data) {
            super(CommonHFSCatalogKey.create(key), CommonHFSCatalogFile.create(data));
        }
    }

    public static class HFSImplementation
    extends CommonHFSCatalogFileRecord {
        public HFSImplementation(CatKeyRec key, CdrFilRec data) {
            super(CommonHFSCatalogKey.create(key), CommonHFSCatalogFile.create(data));
        }

        protected HFSImplementation(CommonHFSCatalogKey key, CommonHFSCatalogFile data) {
            super(key, data);
        }

        public int getSize() {
            return this.key.occupiedSize() + this.data.size();
        }

        public byte[] getBytes() {
            byte[] result = new byte[this.getSize()];
            int offset = 0;
            byte[] tempData = this.key.getBytes();
            System.arraycopy(tempData, 0, result, offset, tempData.length);
            offset += tempData.length;
            tempData = this.data.getBytes();
            System.arraycopy(tempData, 0, result, offset, tempData.length);
            offset += tempData.length;
            return result;
        }
    }
}

