--# -path=.:..:../../abstract:../../common:../../api

concrete WordsFin of WordsFinAbs = CatFin ** open StemFin, TagFin, ResFin in {

-- extracted from http://kaino.kotus.fi/sanat/nykysuomi/, licensed under LGPL

flags coding = utf8 ;

oper mkkN : Str -> N = \s -> lin N (mkSNoun s) ;
oper mkkA : Str -> A = \s -> lin A {s = \\_ => (mkSNoun s).s ; h = Back} ;
oper mkkV : Str -> V = \s -> lin V (mkSVerb s ** {sc = SCNom ; p = []}) ;
oper mkkAdv : Str -> Adv = \s -> lin Adv {s = tagWord adverbTag s} ;

lin aakkonen_N = mkkN "aakkonen" ;
lin aakkosellinen_A = mkkA "aakkosellinen" ;
lin aakkosellisesti_Adv = mkkAdv "aakkosellisesti" ;
lin aakkosellisuus_N = mkkN "aakkosellisuus" ;
lin aakkosittain_Adv = mkkAdv "aakkosittain" ;
lin aakkostaa_V = mkkV "aakkostaa" ;
lin aakkosto_N = mkkN "aakkosto" ;
lin aakkostus_N = mkkN "aakkostus" ;
lin aalloittain_Adv = mkkAdv "aalloittain" ;
lin aalloittainen_N = mkkN "aalloittainen" ;
lin aalloittaisuus_N = mkkN "aalloittaisuus" ;
lin aallokas_N = mkkN "aallokas" ;
lin aallokko_N = mkkN "aallokko" ;
lin aallota_V = mkkV "aallota" ;
lin aallotar_N = mkkN "aallotar" ;
lin aallottaa_V = mkkV "aallottaa" ;
lin aallotus_N = mkkN "aallotus" ;
lin aaloe_N = mkkN "aaloe" ;
lin aalto_N = mkkN "aalto" ;
lin aaltoilla_V = mkkV "aaltoilla" ;
lin aaltoilu_N = mkkN "aaltoilu" ;
lin aaltoinen_N = mkkN "aaltoinen" ;
lin aamen_N = mkkN "aamen" ;
lin aamiainen_N = mkkN "aamiainen" ;
lin aamu_N = mkkN "aamu" ;
lin aamuinen_N = mkkN "aamuinen" ;
lin aamuisin_Adv = mkkAdv "aamuisin" ;
lin aamullinen_N = mkkN "aamullinen" ;
lin aamusella_Adv = mkkAdv "aamusella" ;
lin aamutuimaan_Adv = mkkAdv "aamutuimaan" ;
lin aapa_N = mkkN "aapa" ;
lin aapinen_N = mkkN "aapinen" ;
lin aaprotti_N = mkkN "aaprotti" ;
lin aari_N = mkkN "aari" ;
lin aaria_N = mkkN "aaria" ;
lin aarnio_1_N = mkkN "aarnio" ;
lin aarnio_2_N = mkkN "aarnio" ;
lin aarpora_N = mkkN "aarpora" ;
lin aarre_N = mkkN "aarre" ;
lin aarteisto_N = mkkN "aarteisto" ;
lin aasi_N = mkkN "aasi" ;
lin aasimaisesti_Adv = mkkAdv "aasimaisesti" ;
lin aasimaisuus_N = mkkN "aasimaisuus" ;
lin aasinpotku_N = mkkN "aasinpotku" ;
lin aatami_N = mkkN "aatami" ;
lin aate_N = mkkN "aate" ;
lin aateli_N = mkkN "aateli" ;
lin aatelinen_N = mkkN "aatelinen" ;
lin aatelisto_N = mkkN "aatelisto" ;
lin aatelisuus_N = mkkN "aatelisuus" ;
lin aateliton_N = mkkN "aateliton" ;
lin aateloida_V = mkkV "aateloida" ;
lin aatelointi_N = mkkN "aatelointi" ;
lin aateluus_N = mkkN "aateluus" ;
lin aatos_N = mkkN "aatos" ;
lin aatra_N = mkkN "aatra" ;
lin aatteellinen_A = mkkA "aatteellinen" ;
lin aatteellisesti_Adv = mkkAdv "aatteellisesti" ;
lin aatteellisuus_N = mkkN "aatteellisuus" ;
lin aatteinen_N = mkkN "aatteinen" ;
lin aatto_N = mkkN "aatto" ;
lin aava_N = mkkN "aava" ;
lin aave_N = mkkN "aave" ;
lin aavemaisesti_Adv = mkkAdv "aavemaisesti" ;
lin aavemaisuus_N = mkkN "aavemaisuus" ;
lin aavikko_N = mkkN "aavikko" ;
lin aavikoitua_V = mkkV "aavikoitua" ;
lin aavistaa_V = mkkV "aavistaa" ;
lin aavistamaton_N = mkkN "aavistamaton" ;
lin aavistella_V = mkkV "aavistella" ;
lin aavistus_N = mkkN "aavistus" ;
lin abatsi_N = mkkN "abatsi" ;
lin abbedissa_N = mkkN "abbedissa" ;
lin abessiivi_N = mkkN "abessiivi" ;
lin abi_N = mkkN "abi" ;
lin abiturientti_N = mkkN "abiturientti" ;
lin ablatiivi_N = mkkN "ablatiivi" ;
lin abnormi_N = mkkN "abnormi" ;
lin abnormius_N = mkkN "abnormius" ;
lin abo_N = mkkN "abo" ;
lin aboriginaali_N = mkkN "aboriginaali" ;
lin abortoida_V = mkkV "abortoida" ;
lin abortointi_N = mkkN "abortointi" ;
lin abortti_N = mkkN "abortti" ;
lin abrakadabra_N = mkkN "abrakadabra" ;
lin absessi_N = mkkN "absessi" ;
lin absintti_N = mkkN "absintti" ;
lin abskissa_N = mkkN "abskissa" ;
lin absolutismi_N = mkkN "absolutismi" ;
lin absolutisti_N = mkkN "absolutisti" ;
lin absoluutti_N = mkkN "absoluutti" ;
lin absoluuttinen_A = mkkA "absoluuttinen" ;
lin absoluuttisesti_Adv = mkkAdv "absoluuttisesti" ;
lin absoluuttisuus_N = mkkN "absoluuttisuus" ;
lin absorboida_V = mkkV "absorboida" ;
lin absorbointi_N = mkkN "absorbointi" ;
lin absorboitua_V = mkkV "absorboitua" ;
lin absorptio_N = mkkN "absorptio" ;
lin abstinenssi_N = mkkN "abstinenssi" ;
lin abstrahoida_V = mkkV "abstrahoida" ;
lin abstrahointi_N = mkkN "abstrahointi" ;
lin abstrahoitua_V = mkkV "abstrahoitua" ;
lin abstrakti_A = mkkA "abstrakti" ;
lin abstraktinen_A = mkkA "abstraktinen" ;
lin abstraktio_N = mkkN "abstraktio" ;
lin abstraktisesti_Adv = mkkAdv "abstraktisesti" ;
lin abstraktistaa_V = mkkV "abstraktistaa" ;
lin abstraktisti_Adv = mkkAdv "abstraktisti" ;
lin abstraktistua_V = mkkV "abstraktistua" ;
lin abstraktisuus_N = mkkN "abstraktisuus" ;
lin abstraktius_N = mkkN "abstraktius" ;
lin absurdi_A = mkkA "absurdi" ;
lin absurdisti_Adv = mkkAdv "absurdisti" ;
lin absurdius_N = mkkN "absurdius" ;
lin adagio_N = mkkN "adagio" ;
lin adaptaatio_N = mkkN "adaptaatio" ;
lin adapteri_N = mkkN "adapteri" ;
lin adaptoida_V = mkkV "adaptoida" ;
lin adaptointi_N = mkkN "adaptointi" ;
lin adaptoitua_V = mkkV "adaptoitua" ;
lin addikti_N = mkkN "addikti" ;
lin addiktio_N = mkkN "addiktio" ;
lin adekvaatisti_Adv = mkkAdv "adekvaatisti" ;
lin adekvaatti_N = mkkN "adekvaatti" ;
lin adekvaattius_N = mkkN "adekvaattius" ;
lin adenooma_N = mkkN "adenooma" ;
lin adessiivi_N = mkkN "adessiivi" ;
lin adheesio_N = mkkN "adheesio" ;
lin adjektiivi_N = mkkN "adjektiivi" ;
lin adjektiivinen_A = mkkA "adjektiivinen" ;
lin adjektiivisesti_Adv = mkkAdv "adjektiivisesti" ;
lin adjektiivisuus_N = mkkN "adjektiivisuus" ;
lin adjutantti_N = mkkN "adjutantti" ;
lin adonis_N = mkkN "adonis" ;
lin adoptio_N = mkkN "adoptio" ;
lin adoptoida_V = mkkV "adoptoida" ;
lin adoptointi_N = mkkN "adoptointi" ;
lin adrenaliini_N = mkkN "adrenaliini" ;
lin adressi_N = mkkN "adressi" ;
lin adsorboida_V = mkkV "adsorboida" ;
lin adsorbointi_N = mkkN "adsorbointi" ;
lin adsorboitua_V = mkkV "adsorboitua" ;
lin adsorptio_N = mkkN "adsorptio" ;
lin adventismi_N = mkkN "adventismi" ;
lin adventisti_N = mkkN "adventisti" ;
lin adventti_N = mkkN "adventti" ;
lin adventtiaika_N = mkkN "adventtiaika" ;
lin adverbi_N = mkkN "adverbi" ;
lin adverbiaali_N = mkkN "adverbiaali" ;
lin adverbiaalinen_A = mkkA "adverbiaalinen" ;
lin adverbiaalisesti_Adv = mkkAdv "adverbiaalisesti" ;
lin adverbiaalisuus_N = mkkN "adverbiaalisuus" ;
lin adverbinen_A = mkkA "adverbinen" ;
lin adverbisesti_Adv = mkkAdv "adverbisesti" ;
lin adverbisuus_N = mkkN "adverbisuus" ;
lin adversatiivinen_A = mkkA "adversatiivinen" ;
lin adversatiivisesti_Adv = mkkAdv "adversatiivisesti" ;
lin adversatiivisuus_N = mkkN "adversatiivisuus" ;
lin aerobic_N = mkkN "aerobic" ;
lin aerobikata_V = mkkV "aerobikata" ;
lin aerobikkaaja_N = mkkN "aerobikkaaja" ;
lin aerobikkaus_N = mkkN "aerobikkaus" ;
lin aerobikki_N = mkkN "aerobikki" ;
lin aerobinen_N = mkkN "aerobinen" ;
lin aerobiologia_N = mkkN "aerobiologia" ;
lin aerobiologinen_N = mkkN "aerobiologinen" ;
lin aerodynaaminen_N = mkkN "aerodynaaminen" ;
lin aerodynamiikka_N = mkkN "aerodynamiikka" ;
lin aerosoli_N = mkkN "aerosoli" ;
lin afaatikko_N = mkkN "afaatikko" ;
lin afaattinen_N = mkkN "afaattinen" ;
lin afasia_N = mkkN "afasia" ;
lin affekti_N = mkkN "affekti" ;
lin affektiivinen_A = mkkA "affektiivinen" ;
lin affektiivisesti_Adv = mkkAdv "affektiivisesti" ;
lin affektiivisuus_N = mkkN "affektiivisuus" ;
lin affektinen_A = mkkA "affektinen" ;
lin affektisesti_Adv = mkkAdv "affektisesti" ;
lin affektisuus_N = mkkN "affektisuus" ;
lin affisio_N = mkkN "affisio" ;
lin affisioida_V = mkkV "affisioida" ;
lin afgaani_N = mkkN "afgaani" ;
lin aforismi_N = mkkN "aforismi" ;
lin aforistinen_N = mkkN "aforistinen" ;
lin afrikaans_N = mkkN "afrikaans" ;
lin afrikandi_N = mkkN "afrikandi" ;
lin afrikkalainen_N = mkkN "afrikkalainen" ;
lin afrikkalaisuus_N = mkkN "afrikkalaisuus" ;
lin afro_N = mkkN "afro" ;
lin afta_N = mkkN "afta" ;
lin afa'a'ri_N = mkkN "afääri" ;
lin agaatti_N = mkkN "agaatti" ;
lin agaave_N = mkkN "agaave" ;
lin agar_N = mkkN "agar" ;
lin agar_agar_N = mkkN "agar-agar" ;
lin agenda_N = mkkN "agenda" ;
lin agentti_N = mkkN "agentti" ;
lin agentuuri_N = mkkN "agentuuri" ;
lin aggregaatti_N = mkkN "aggregaatti" ;
lin aggressiivinen_A = mkkA "aggressiivinen" ;
lin aggressiivisesti_Adv = mkkAdv "aggressiivisesti" ;
lin aggressiivisuus_N = mkkN "aggressiivisuus" ;
lin aggressio_N = mkkN "aggressio" ;
lin agitaatio_N = mkkN "agitaatio" ;
lin agitaattori_N = mkkN "agitaattori" ;
lin agitatorinen_N = mkkN "agitatorinen" ;
lin agitoida_V = mkkV "agitoida" ;
lin agitointi_N = mkkN "agitointi" ;
lin agnostikko_N = mkkN "agnostikko" ;
lin agnostinen_A = mkkA "agnostinen" ;
lin agnostisesti_Adv = mkkAdv "agnostisesti" ;
lin agnostisismi_N = mkkN "agnostisismi" ;
lin agnostisuus_N = mkkN "agnostisuus" ;
lin agorafobia_N = mkkN "agorafobia" ;
lin agraarinen_N = mkkN "agraarinen" ;
lin agraarisuus_N = mkkN "agraarisuus" ;
lin agrologi_N = mkkN "agrologi" ;
lin agronomi_N = mkkN "agronomi" ;
lin agronomia_N = mkkN "agronomia" ;
lin ah_Adv = mkkAdv "ah" ;
lin ahaa_Adv = mkkAdv "ahaa" ;
lin ahava_N = mkkN "ahava" ;
lin ahavoittaa_V = mkkV "ahavoittaa" ;
lin ahavoitua_V = mkkV "ahavoitua" ;
lin ahdas_N = mkkN "ahdas" ;
lin ahdasmielisesti_Adv = mkkAdv "ahdasmielisesti" ;
lin ahdasna'ko'isesti_Adv = mkkAdv "ahdasnäköisesti" ;
lin ahdasrajaisesti_Adv = mkkAdv "ahdasrajaisesti" ;
lin ahdasrajaisuus_N = mkkN "ahdasrajaisuus" ;
lin ahdata_V = mkkV "ahdata" ;
lin ahde_N = mkkN "ahde" ;
lin ahdin_N = mkkN "ahdin" ;
lin ahdinko_N = mkkN "ahdinko" ;
lin ahdistaa_V = mkkV "ahdistaa" ;
lin ahdistaja_N = mkkN "ahdistaja" ;
lin ahdistelija_N = mkkN "ahdistelija" ;
lin ahdistella_V = mkkV "ahdistella" ;
lin ahdistelu_N = mkkN "ahdistelu" ;
lin ahdistua_V = mkkV "ahdistua" ;
lin ahdistuneesti_Adv = mkkAdv "ahdistuneesti" ;
lin ahdistuneisuus_N = mkkN "ahdistuneisuus" ;
lin ahdistunut_A = mkkA "ahdistunut" ;
lin ahdistus_N = mkkN "ahdistus" ;
lin aherrus_N = mkkN "aherrus" ;
lin ahertaa_V = mkkV "ahertaa" ;
lin ahertaja_N = mkkN "ahertaja" ;
lin ahjo_N = mkkN "ahjo" ;
lin ahkera_A = mkkA "ahkera" ;
lin ahkeraan_Adv = mkkAdv "ahkeraan" ;
lin ahkeraliisa_N = mkkN "ahkeraliisa" ;
lin ahkerasti_Adv = mkkAdv "ahkerasti" ;
lin ahkeroida_V = mkkV "ahkeroida" ;
lin ahkerointi_N = mkkN "ahkerointi" ;
lin ahkeruus_N = mkkN "ahkeruus" ;
lin ahkio_N = mkkN "ahkio" ;
lin ahma_N = mkkN "ahma" ;
lin ahmaista_V = mkkV "ahmaista" ;
lin ahmaisu_N = mkkN "ahmaisu" ;
lin ahmatti_N = mkkN "ahmatti" ;
lin ahmia_V = mkkV "ahmia" ;
lin ahminta_N = mkkN "ahminta" ;
lin ahnaasti_Adv = mkkAdv "ahnaasti" ;
lin ahnas_A = mkkA "ahnas" ;
lin ahnaus_N = mkkN "ahnaus" ;
lin ahne_A = mkkA "ahne" ;
lin ahneesti_Adv = mkkAdv "ahneesti" ;
lin ahnehdinta_N = mkkN "ahnehdinta" ;
lin ahnehtia_V = mkkV "ahnehtia" ;
lin ahnehtija_N = mkkN "ahnehtija" ;
lin ahneus_N = mkkN "ahneus" ;
lin aho_N = mkkN "aho" ;
lin ahrain_N = mkkN "ahrain" ;
lin ahtaa_V = mkkV "ahtaa" ;
lin ahtaaja_N = mkkN "ahtaaja" ;
lin ahtaalla_Adv = mkkAdv "ahtaalla" ;
lin ahtaalle_Adv = mkkAdv "ahtaalle" ;
lin ahtaasti_Adv = mkkAdv "ahtaasti" ;
lin ahtauma_N = mkkN "ahtauma" ;
lin ahtaus_1_N = mkkN "ahtaus" ;
lin ahtaus_2_N = mkkN "ahtaus" ;
lin ahtauttaa_1_V = mkkV "ahtauttaa" ;
lin ahtauttaa_2_V = mkkV "ahtauttaa" ;
lin ahtautua_V = mkkV "ahtautua" ;
lin ahtautuma_N = mkkN "ahtautuma" ;
lin ahteri_N = mkkN "ahteri" ;
lin Ahti_N = mkkN "Ahti" ;
lin ahti_N = mkkN "ahti" ;
lin ahtoutua_V = mkkV "ahtoutua" ;
lin ahven_N = mkkN "ahven" ;
lin ai_Adv = mkkAdv "ai" ;
lin aidanne_N = mkkN "aidanne" ;
lin aidas_N = mkkN "aidas" ;
lin aidata_V = mkkV "aidata" ;
lin aidoittaa_V = mkkV "aidoittaa" ;
lin aidosti_Adv = mkkAdv "aidosti" ;
lin AIDS_N = mkkN "AIDS" ;
lin aie_N = mkkN "aie" ;
lin aiemmin_Adv = mkkAdv "aiemmin" ;
lin aiempi_N = mkkN "aiempi" ;
lin aiennus_N = mkkN "aiennus" ;
lin aientaa_V = mkkV "aientaa" ;
lin aihe_N = mkkN "aihe" ;
lin aiheellinen_A = mkkA "aiheellinen" ;
lin aiheellisesti_Adv = mkkAdv "aiheellisesti" ;
lin aiheellistaa_V = mkkV "aiheellistaa" ;
lin aiheellistua_V = mkkV "aiheellistua" ;
lin aiheellisuus_N = mkkN "aiheellisuus" ;
lin aiheeton_N = mkkN "aiheeton" ;
lin aiheettomasti_Adv = mkkAdv "aiheettomasti" ;
lin aiheettomuus_N = mkkN "aiheettomuus" ;
lin aiheinen_N = mkkN "aiheinen" ;
lin aihelma_N = mkkN "aihelma" ;
lin aiheuttaa_V = mkkV "aiheuttaa" ;
lin aiheuttaja_N = mkkN "aiheuttaja" ;
lin aiheutua_V = mkkV "aiheutua" ;
lin aiheutus_N = mkkN "aiheutus" ;
lin aihio_N = mkkN "aihio" ;
lin aijai_Adv = mkkAdv "aijai" ;
lin aika_1_N = mkkN "aika" ;
lin aika_2_Adv = mkkAdv "aika" ;
lin aikaansaannos_N = mkkN "aikaansaannos" ;
lin aikaansaapa_N = mkkN "aikaansaapa" ;
lin aikaansaava_N = mkkN "aikaansaava" ;
lin aikailla_V = mkkV "aikailla" ;
lin aikailu_N = mkkN "aikailu" ;
lin aikainen_N = mkkN "aikainen" ;
lin aikaisemmin_Adv = mkkAdv "aikaisemmin" ;
lin aikaisin_Adv = mkkAdv "aikaisin" ;
lin aikaisintaan_Adv = mkkAdv "aikaisintaan" ;
lin aikaistaa_V = mkkV "aikaistaa" ;
lin aikaistua_V = mkkV "aikaistua" ;
lin aikaistus_N = mkkN "aikaistus" ;
lin aikaisuus_N = mkkN "aikaisuus" ;
lin aikanaan_Adv = mkkAdv "aikanaan" ;
lin aikansa_Adv = mkkAdv "aikansa" ;
lin aikatauluttaa_V = mkkV "aikatauluttaa" ;
lin aikauttaa_V = mkkV "aikauttaa" ;
lin aikautus_N = mkkN "aikautus" ;
lin aikido_N = mkkN "aikido" ;
lin aikoa_V = mkkV "aikoa" ;
lin aikoinaan_Adv = mkkAdv "aikoinaan" ;
lin aikojaan_Adv = mkkAdv "aikojaan" ;
lin aikomus_N = mkkN "aikomus" ;
lin aikuinen_N = mkkN "aikuinen" ;
lin aikuistua_V = mkkV "aikuistua" ;
lin aikuisuus_N = mkkN "aikuisuus" ;
lin ailahdella_V = mkkV "ailahdella" ;
lin ailahdus_N = mkkN "ailahdus" ;
lin ailahtaa_V = mkkV "ailahtaa" ;
lin ailahtelu_N = mkkN "ailahtelu" ;
lin ailakki_N = mkkN "ailakki" ;
lin aimo_Adv = mkkAdv "aimo" ;
lin aina_1_Adv = mkkAdv "aina" ;
lin aina_2_N = mkkN "aina" ;
lin ainainen_N = mkkN "ainainen" ;
lin ainaiseksi_Adv = mkkAdv "ainaiseksi" ;
lin ainakaan_Adv = mkkAdv "ainakaan" ;
lin ainakin_Adv = mkkAdv "ainakin" ;
lin aine_N = mkkN "aine" ;
lin aineellinen_N = mkkN "aineellinen" ;
lin aineellistaa_V = mkkV "aineellistaa" ;
lin aineellistua_V = mkkV "aineellistua" ;
lin aineellistuma_N = mkkN "aineellistuma" ;
lin aineellisuus_N = mkkN "aineellisuus" ;
lin aineeton_N = mkkN "aineeton" ;
lin aineettomuus_N = mkkN "aineettomuus" ;
lin aineinen_N = mkkN "aineinen" ;
lin aineistaa_V = mkkV "aineistaa" ;
lin aineisto_N = mkkN "aineisto" ;
lin aineistua_V = mkkV "aineistua" ;
lin aineistuma_N = mkkN "aineistuma" ;
lin aineksinen_N = mkkN "aineksinen" ;
lin aines_N = mkkN "aines" ;
lin ainiaaksi_Adv = mkkAdv "ainiaaksi" ;
lin ainiaan_Adv = mkkAdv "ainiaan" ;
lin ainiaksi_Adv = mkkAdv "ainiaksi" ;
lin ainian_Adv = mkkAdv "ainian" ;
lin aino_N = mkkN "aino" ;
lin ainoa_N = mkkN "ainoa" ;
lin ainoastaan_Adv = mkkAdv "ainoastaan" ;
lin ainokainen_N = mkkN "ainokainen" ;
lin ainu_N = mkkN "ainu" ;
lin ainut_Adv = mkkAdv "ainut" ;
lin ainutkertaisuus_N = mkkN "ainutkertaisuus" ;
lin aioli_N = mkkN "aioli" ;
lin airo_N = mkkN "airo" ;
lin aironveto_N = mkkN "aironveto" ;
lin airut_N = mkkN "airut" ;
lin aisa_N = mkkN "aisa" ;
lin aisata_V = mkkV "aisata" ;
lin aisaus_N = mkkN "aisaus" ;
lin aisti_N = mkkN "aisti" ;
lin aistia_V = mkkV "aistia" ;
lin aistikas_A = mkkA "aistikas" ;
lin aistikkaasti_Adv = mkkAdv "aistikkaasti" ;
lin aistikkuus_N = mkkN "aistikkuus" ;
lin aistillinen_A = mkkA "aistillinen" ;
lin aistillisesti_Adv = mkkAdv "aistillisesti" ;
lin aistillisuus_N = mkkN "aistillisuus" ;
lin aistimus_N = mkkN "aistimus" ;
lin aistin_N = mkkN "aistin" ;
lin aistinen_N = mkkN "aistinen" ;
lin aita_N = mkkN "aita" ;
lin aitaus_N = mkkN "aitaus" ;
lin aitio_N = mkkN "aitio" ;
lin aito_N = mkkN "aito" ;
lin aitoa_V = mkkV "aitoa" ;
lin aitous_N = mkkN "aitous" ;
lin aitta_N = mkkN "aitta" ;
lin aituri_N = mkkN "aituri" ;
lin aivan_Adv = mkkAdv "aivan" ;
lin aivastaa_V = mkkV "aivastaa" ;
lin aivastella_V = mkkV "aivastella" ;
lin aivastus_N = mkkN "aivastus" ;
lin aivastuttaa_V = mkkV "aivastuttaa" ;
lin aivina_N = mkkN "aivina" ;
lin aivo_N = mkkN "aivo" ;
lin aivoitus_N = mkkN "aivoitus" ;
lin aivokurkiainen_N = mkkN "aivokurkiainen" ;
lin aivosto_N = mkkN "aivosto" ;
--? lin aivot_NK = {s = d01 "aivot" ;
lin ajaa_V = mkkV "ajaa" ;
lin ajaantua_V = mkkV "ajaantua" ;
lin ajaja_N = mkkN "ajaja" ;
lin ajallaan_Adv = mkkAdv "ajallaan" ;
lin ajallinen_A = mkkA "ajallinen" ;
lin ajallisesti_Adv = mkkAdv "ajallisesti" ;
lin ajallisuus_N = mkkN "ajallisuus" ;
lin ajankohta_N = mkkN "ajankohta" ;
lin ajankohtaistaa_V = mkkV "ajankohtaistaa" ;
lin ajankohtaistua_V = mkkV "ajankohtaistua" ;
lin ajankuluke_N = mkkN "ajankuluke" ;
lin ajan_mittaan_Adv = mkkAdv "ajanC" ;
lin ajanmukaistaa_V = mkkV "ajanmukaistaa" ;
lin ajanmukaistua_V = mkkV "ajanmukaistua" ;
lin ajanmukaisuus_N = mkkN "ajanmukaisuus" ;
lin ajantasaistaa_V = mkkV "ajantasaistaa" ;
lin ajantasaistus_N = mkkN "ajantasaistus" ;
lin ajantasaisuus_N = mkkN "ajantasaisuus" ;
lin ajanviete_N = mkkN "ajanviete" ;
lin ajanvietteellinen_N = mkkN "ajanvietteellinen" ;
lin ajassa_Adv = mkkAdv "ajassa" ;
lin ajassaan_Adv = mkkAdv "ajassaan" ;
lin ajastaa_V = mkkV "ajastaa" ;
lin ajastaika_N = mkkN "ajastaika" ;
lin ajastin_N = mkkN "ajastin" ;
lin ajastus_N = mkkN "ajastus" ;
lin ajatella_V = mkkV "ajatella" ;
lin ajatelma_N = mkkN "ajatelma" ;
lin ajatollah_N = mkkN "ajatollah" ;
lin ajaton_N = mkkN "ajaton" ;
lin ajattaa_V = mkkV "ajattaa" ;
lin ajattelematon_N = mkkN "ajattelematon" ;
lin ajattelemattomasti_Adv = mkkAdv "ajattelemattomasti" ;
lin ajattelemattomuus_N = mkkN "ajattelemattomuus" ;
lin ajattelija_N = mkkN "ajattelija" ;
lin ajattelu_N = mkkN "ajattelu" ;
lin ajatteluttaa_V = mkkV "ajatteluttaa" ;
lin ajattomasti_Adv = mkkAdv "ajattomasti" ;
lin ajattomuus_N = mkkN "ajattomuus" ;
lin ajatuksekas_N = mkkN "ajatuksekas" ;
lin ajatuksellinen_A = mkkA "ajatuksellinen" ;
lin ajatuksellisesti_Adv = mkkAdv "ajatuksellisesti" ;
lin ajatukseton_N = mkkN "ajatukseton" ;
lin ajatuksettomasti_Adv = mkkAdv "ajatuksettomasti" ;
lin ajatuksettomuus_N = mkkN "ajatuksettomuus" ;
lin ajatuksinen_N = mkkN "ajatuksinen" ;
lin ajatus_N = mkkN "ajatus" ;
lin ajautua_V = mkkV "ajautua" ;
lin ajelehtia_V = mkkV "ajelehtia" ;
lin ajella_V = mkkV "ajella" ;
lin ajelu_N = mkkN "ajelu" ;
lin ajeluttaa_V = mkkV "ajeluttaa" ;
lin ajettavuus_N = mkkN "ajettavuus" ;
lin ajettua_V = mkkV "ajettua" ;
lin ajettuma_N = mkkN "ajettuma" ;
lin ajetuksissa_Adv = mkkAdv "ajetuksissa" ;
lin ajo_N = mkkN "ajo" ;
lin ajoaika_N = mkkN "ajoaika" ;
lin ajoissa_Adv = mkkAdv "ajoissa" ;
lin ajoittaa_V = mkkV "ajoittaa" ;
lin ajoittain_Adv = mkkAdv "ajoittain" ;
lin ajoittainen_N = mkkN "ajoittainen" ;
lin ajoittaisuus_N = mkkN "ajoittaisuus" ;
lin ajoittua_V = mkkV "ajoittua" ;
lin ajoitus_N = mkkN "ajoitus" ;
lin ajokas_1_N = mkkN "ajokas" ;
lin ajokki_N = mkkN "ajokki" ;
lin ajos_N = mkkN "ajos" ;
lin ajuri_N = mkkN "ajuri" ;
lin akaatti_N = mkkN "akaatti" ;
lin akallinen_N = mkkN "akallinen" ;
lin akana_N = mkkN "akana" ;
lin akantti_N = mkkN "akantti" ;
lin akasia_N = mkkN "akasia" ;
lin akateemikko_N = mkkN "akateemikko" ;
lin akateeminen_A = mkkA "akateeminen" ;
lin akateemisesti_Adv = mkkAdv "akateemisesti" ;
lin akateemisuus_N = mkkN "akateemisuus" ;
lin akatemia_N = mkkN "akatemia" ;
lin akileija_N = mkkN "akileija" ;
lin akka_N = mkkN "akka" ;
lin akkamaisesti_Adv = mkkAdv "akkamaisesti" ;
lin akkamaisuus_N = mkkN "akkamaisuus" ;
lin akkautua_V = mkkV "akkautua" ;
lin akklimatisaatio_N = mkkN "akklimatisaatio" ;
lin akklimatisoida_V = mkkV "akklimatisoida" ;
lin akklimatisointi_N = mkkN "akklimatisointi" ;
lin akklimatisoitua_V = mkkV "akklimatisoitua" ;
lin akkommodaatio_N = mkkN "akkommodaatio" ;
lin akkreditoida_V = mkkV "akkreditoida" ;
lin akkreditointi_N = mkkN "akkreditointi" ;
lin akku_N = mkkN "akku" ;
lin akkumulaattori_N = mkkN "akkumulaattori" ;
lin akkuna_N = mkkN "akkuna" ;
lin akkusatiivi_N = mkkN "akkusatiivi" ;
lin akne_N = mkkN "akne" ;
lin akoittua_V = mkkV "akoittua" ;
lin akordi_N = mkkN "akordi" ;
lin akrobaatti_N = mkkN "akrobaatti" ;
lin akrobatia_N = mkkN "akrobatia" ;
lin akronyymi_N = mkkN "akronyymi" ;
lin akryylimaalaus_N = mkkN "akryylimaalaus" ;
lin akseli_N = mkkN "akseli" ;
lin akselinen_N = mkkN "akselinen" ;
lin akselisto_N = mkkN "akselisto" ;
lin aksentti_N = mkkN "aksentti" ;
lin akseptantti_N = mkkN "akseptantti" ;
lin akseptata_V = mkkV "akseptata" ;
lin akseptaus_N = mkkN "akseptaus" ;
lin aksepti_N = mkkN "aksepti" ;
lin akseptoida_V = mkkV "akseptoida" ;
lin akseptointi_N = mkkN "akseptointi" ;
lin aksiaalinen_A = mkkA "aksiaalinen" ;
lin aksiaalisesti_Adv = mkkAdv "aksiaalisesti" ;
lin aksiaalisuus_N = mkkN "aksiaalisuus" ;
lin aksiomaattinen_A = mkkA "aksiomaattinen" ;
lin aksiomaattisesti_Adv = mkkAdv "aksiomaattisesti" ;
lin aksiomaattisuus_N = mkkN "aksiomaattisuus" ;
lin aksiomi_N = mkkN "aksiomi" ;
lin aksiooma_N = mkkN "aksiooma" ;
lin akti_N = mkkN "akti" ;
--? lin aktiivat_NK = {s = d13 "aktiivat" ;
lin aktiivi_N = mkkN "aktiivi" ;
lin aktiivinen_A = mkkA "aktiivinen" ;
lin aktiivisesti_Adv = mkkAdv "aktiivisesti" ;
lin aktiivistaa_V = mkkV "aktiivistaa" ;
lin aktiivistua_V = mkkV "aktiivistua" ;
lin aktiivisuus_N = mkkN "aktiivisuus" ;
lin aktio_N = mkkN "aktio" ;
lin aktivismi_N = mkkN "aktivismi" ;
lin aktiviteetti_N = mkkN "aktiviteetti" ;
lin aktivoida_V = mkkV "aktivoida" ;
lin aktivoitua_V = mkkV "aktivoitua" ;
lin aktuaalinen_A = mkkA "aktuaalinen" ;
lin aktuaalisesti_Adv = mkkAdv "aktuaalisesti" ;
lin aktuaalistaa_V = mkkV "aktuaalistaa" ;
lin aktuaalistua_V = mkkV "aktuaalistua" ;
lin aktuaalisuus_N = mkkN "aktuaalisuus" ;
lin aktuaari_N = mkkN "aktuaari" ;
lin aktualisoida_V = mkkV "aktualisoida" ;
lin aktualisointi_N = mkkN "aktualisointi" ;
lin aktualisoitua_V = mkkV "aktualisoitua" ;
lin aktuelli_N = mkkN "aktuelli" ;
lin akupunktuuri_N = mkkN "akupunktuuri" ;
lin akustiikka_N = mkkN "akustiikka" ;
lin akustinen_A = mkkA "akustinen" ;
lin akustisesti_Adv = mkkAdv "akustisesti" ;
lin akusto_N = mkkN "akusto" ;
lin akuutisti_Adv = mkkAdv "akuutisti" ;
lin akuutti_N = mkkN "akuutti" ;
lin akuuttinen_N = mkkN "akuuttinen" ;
lin akvaario_N = mkkN "akvaario" ;
lin akvamariini_N = mkkN "akvamariini" ;
lin akvarelli_N = mkkN "akvarelli" ;
lin akvatinta_N = mkkN "akvatinta" ;
lin akvaviitti_N = mkkN "akvaviitti" ;
lin a''_la_Adv = mkkAdv "àC" ;
lin ala_N = mkkN "ala" ;
lin ala_arvoisesti_Adv = mkkAdv "ala-arvoisesti" ;
lin alabasteri_N = mkkN "alabasteri" ;
lin a''_la_carte_N = mkkN "àC" ;
lin aladobi_N = mkkN "aladobi" ;
lin alaika'raja_N = mkkN "alaikäraja" ;
lin alainen_N = mkkN "alainen" ;
lin alaisuus_N = mkkN "alaisuus" ;
lin alakantissa_Adv = mkkAdv "alakantissa" ;
lin alakanttiin_Adv = mkkAdv "alakanttiin" ;
lin alakkain_Adv = mkkAdv "alakkain" ;
lin alakkainen_N = mkkN "alakkainen" ;
lin alakohta_N = mkkN "alakohta" ;
lin alakulo_N = mkkN "alakulo" ;
lin alakuloinen_A = mkkA "alakuloinen" ;
lin alakuloisesti_Adv = mkkAdv "alakuloisesti" ;
lin alakuloisuus_N = mkkN "alakuloisuus" ;
lin alakynnessa'_Adv = mkkAdv "alakynnessä" ;
lin alakynteen_Adv = mkkAdv "alakynteen" ;
lin alallaan_Adv = mkkAdv "alallaan" ;
lin alalleen_Adv = mkkAdv "alalleen" ;
lin alamainen_A = mkkA "alamainen" ;
lin alamaisesti_Adv = mkkAdv "alamaisesti" ;
lin alamaisuus_N = mkkN "alamaisuus" ;
lin alanko_N = mkkN "alanko" ;
lin alanne_N = mkkN "alanne" ;
lin alaraja_N = mkkN "alaraja" ;
lin alas_Adv = mkkAdv "alas" ;
lin alasin_N = mkkN "alasin" ;
lin alaslaskettava_N = mkkN "alaslaskettava" ;
lin alassuin_Adv = mkkAdv "alassuin" ;
lin alasti_Adv = mkkAdv "alasti" ;
lin alastomuus_N = mkkN "alastomuus" ;
lin alaston_N = mkkN "alaston" ;
lin alati_Adv = mkkAdv "alati" ;
lin alatusten_Adv = mkkAdv "alatusten" ;
lin alatuuleen_Adv = mkkAdv "alatuuleen" ;
lin alatuulessa_Adv = mkkAdv "alatuulessa" ;
lin alava_N = mkkN "alava" ;
lin alavuus_N = mkkN "alavuus" ;
lin alba_N = mkkN "alba" ;
lin albaani_N = mkkN "albaani" ;
lin albania_N = mkkN "albania" ;
lin albatrossi_N = mkkN "albatrossi" ;
lin albiino_N = mkkN "albiino" ;
lin albinismi_N = mkkN "albinismi" ;
lin albumi_N = mkkN "albumi" ;
lin ale_1_N = mkkN "ale" ;
lin ale_2_N = mkkN "ale" ;
lin alekkain_Adv = mkkAdv "alekkain" ;
lin aleksityymikko_N = mkkN "aleksityymikko" ;
lin aleksityyminen_N = mkkN "aleksityyminen" ;
lin alemma_Adv = mkkAdv "alemma" ;
lin alemmaksi_Adv = mkkAdv "alemmaksi" ;
lin alemmas_Adv = mkkAdv "alemmas" ;
lin alemmuus_N = mkkN "alemmuus" ;
lin alempaa_Adv = mkkAdv "alempaa" ;
lin alempana_Adv = mkkAdv "alempana" ;
lin alempi_N = mkkN "alempi" ;
lin alenema_N = mkkN "alenema" ;
lin alennus_N = mkkN "alennus" ;
lin alentaa_V = mkkV "alentaa" ;
lin alentava_N = mkkN "alentava" ;
lin alentua_V = mkkV "alentua" ;
lin alentuva_A = mkkA "alentuva" ;
lin alentuvainen_A = mkkA "alentuvainen" ;
lin alentuvaisesti_Adv = mkkAdv "alentuvaisesti" ;
lin alentuvaisuus_N = mkkN "alentuvaisuus" ;
lin alentuvasti_Adv = mkkAdv "alentuvasti" ;
lin alentuvuus_N = mkkN "alentuvuus" ;
lin aleta_V = mkkV "aleta" ;
lin aletusten_Adv = mkkAdv "aletusten" ;
lin alfa_N = mkkN "alfa" ;
lin alfalfa_N = mkkN "alfalfa" ;
lin algebra_N = mkkN "algebra" ;
lin algebrallinen_N = mkkN "algebrallinen" ;
lin algoritmi_N = mkkN "algoritmi" ;
lin alhaalla_Adv = mkkAdv "alhaalla" ;
lin alhaalle_Adv = mkkAdv "alhaalle" ;
lin alhaalta_Adv = mkkAdv "alhaalta" ;
lin alhainen_A = mkkA "alhainen" ;
lin alhaisesti_Adv = mkkAdv "alhaisesti" ;
lin alhaiso_N = mkkN "alhaiso" ;
lin alhaisuus_N = mkkN "alhaisuus" ;
lin alho_N = mkkN "alho" ;
lin ali_Adv = mkkAdv "ali" ;
lin alias_Adv = mkkAdv "alias" ;
lin alibi_N = mkkN "alibi" ;
lin aliedustettu_N = mkkN "aliedustettu" ;
lin alija'a'ma'inen_N = mkkN "alijäämäinen" ;
lin alikasvos_N = mkkN "alikasvos" ;
lin alimma_Adv = mkkAdv "alimma" ;
lin alimmainen_N = mkkN "alimmainen" ;
lin alimmaksi_Adv = mkkAdv "alimmaksi" ;
lin alimmas_Adv = mkkAdv "alimmas" ;
lin alimpana_Adv = mkkAdv "alimpana" ;
lin alin_N = mkkN "alin" ;
lin alinen_N = mkkN "alinen" ;
lin alinomaa_Adv = mkkAdv "alinomaa" ;
lin aliohjautuva_N = mkkN "aliohjautuva" ;
lin alipalkattu_N = mkkN "alipalkattu" ;
lin aliravittu_N = mkkN "aliravittu" ;
lin alistaa_V = mkkV "alistaa" ;
lin alisteinen_N = mkkN "alisteinen" ;
lin alisteisuus_N = mkkN "alisteisuus" ;
lin alistua_V = mkkV "alistua" ;
lin alistus_N = mkkN "alistus" ;
lin alistuva_N = mkkN "alistuva" ;
lin alistuvainen_N = mkkN "alistuvainen" ;
lin alistuvaisuus_N = mkkN "alistuvaisuus" ;
lin alistuvuus_N = mkkN "alistuvuus" ;
lin alitse_Adv = mkkAdv "alitse" ;
lin alittaa_V = mkkV "alittaa" ;
lin alittua_V = mkkV "alittua" ;
lin alituinen_A = mkkA "alituinen" ;
lin alituiseen_Adv = mkkAdv "alituiseen" ;
lin alituisesti_Adv = mkkAdv "alituisesti" ;
lin alitus_N = mkkN "alitus" ;
lin alitusten_Adv = mkkAdv "alitusten" ;
lin alkaa_V = mkkV "alkaa" ;
lin alkaen_Adv = mkkAdv "alkaen" ;
lin alkaja_N = mkkN "alkaja" ;
--? lin alkajaiset_NK = {s = d38 "alkajaiset" ;
lin alkali_N = mkkN "alkali" ;
lin alkalinen_N = mkkN "alkalinen" ;
lin alkalisuus_N = mkkN "alkalisuus" ;
lin alkaloidi_N = mkkN "alkaloidi" ;
lin alkamisaika_N = mkkN "alkamisaika" ;
lin alkeellinen_A = mkkA "alkeellinen" ;
lin alkeellisesti_Adv = mkkAdv "alkeellisesti" ;
lin alkeellisuus_N = mkkN "alkeellisuus" ;
--? lin alkeet_NK = {s = d48 "alkeet" ;
lin alkeisjuuri_N = mkkN "alkeisjuuri" ;
lin alkemia_N = mkkN "alkemia" ;
lin alkemisti_N = mkkN "alkemisti" ;
lin alkio_N = mkkN "alkio" ;
lin alkiolaisuus_N = mkkN "alkiolaisuus" ;
lin alkoholi_N = mkkN "alkoholi" ;
lin alkoholismi_N = mkkN "alkoholismi" ;
lin alkoholisoitua_V = mkkV "alkoholisoitua" ;
lin alkoholisti_N = mkkN "alkoholisti" ;
lin alkoholiton_N = mkkN "alkoholiton" ;
lin alkometri_N = mkkN "alkometri" ;
lin alkovi_N = mkkN "alkovi" ;
lin alku_N = mkkN "alku" ;
lin alkuaan_Adv = mkkAdv "alkuaan" ;
lin alkuaika_N = mkkN "alkuaika" ;
lin alkuinen_N = mkkN "alkuinen" ;
lin alkuisin_Adv = mkkAdv "alkuisin" ;
lin alkujaan_Adv = mkkAdv "alkujaan" ;
lin alkujuuri_N = mkkN "alkujuuri" ;
lin alkukantaisesti_Adv = mkkAdv "alkukantaisesti" ;
lin alkukohta_N = mkkN "alkukohta" ;
lin alkupera'isesti_Adv = mkkAdv "alkuperäisesti" ;
lin alkuun_Adv = mkkAdv "alkuun" ;
lin alkuunkaan_Adv = mkkAdv "alkuunkaan" ;
lin alkydi_N = mkkN "alkydi" ;
lin alla_Adv = mkkAdv "alla" ;
lin allakka_N = mkkN "allakka" ;
lin alla_mainittu_N = mkkN "allaC" ;
lin allas_N = mkkN "allas" ;
lin allastaa_V = mkkV "allastaa" ;
lin allatiivi_N = mkkN "allatiivi" ;
lin alle_Adv = mkkAdv "alle" ;
lin alleeli_N = mkkN "alleeli" ;
lin allegoria_N = mkkN "allegoria" ;
lin allegorinen_A = mkkA "allegorinen" ;
lin allegorisesti_Adv = mkkAdv "allegorisesti" ;
lin allegorisuus_N = mkkN "allegorisuus" ;
lin allegretto_N = mkkN "allegretto" ;
lin allegro_N = mkkN "allegro" ;
lin allekirjoittanut_N = mkkN "allekirjoittanut" ;
lin allekkain_Adv = mkkAdv "allekkain" ;
lin allekkainen_N = mkkN "allekkainen" ;
lin allergeeni_N = mkkN "allergeeni" ;
lin allergeeninen_N = mkkN "allergeeninen" ;
lin allergeenisuus_N = mkkN "allergeenisuus" ;
lin allergia_N = mkkN "allergia" ;
lin allergikko_N = mkkN "allergikko" ;
lin allerginen_N = mkkN "allerginen" ;
lin allergisoida_V = mkkV "allergisoida" ;
lin allergisoitua_V = mkkV "allergisoitua" ;
lin allergistaa_V = mkkV "allergistaa" ;
lin allergistua_V = mkkV "allergistua" ;
lin allergisuus_N = mkkN "allergisuus" ;
lin alletusten_Adv = mkkAdv "alletusten" ;
lin alli_1_N = mkkN "alli" ;
lin alli_2_N = mkkN "alli" ;
lin allianssi_N = mkkN "allianssi" ;
lin alligaattori_N = mkkN "alligaattori" ;
lin allikko_N = mkkN "allikko" ;
lin allitteraatio_N = mkkN "allitteraatio" ;
lin allokaatio_N = mkkN "allokaatio" ;
lin allokoida_V = mkkV "allokoida" ;
lin allokointi_N = mkkN "allokointi" ;
lin almanakka_N = mkkN "almanakka" ;
lin almu_N = mkkN "almu" ;
lin aloillaan_Adv = mkkAdv "aloillaan" ;
lin aloilleen_Adv = mkkAdv "aloilleen" ;
lin aloite_N = mkkN "aloite" ;
lin aloitella_V = mkkV "aloitella" ;
lin aloittaa_V = mkkV "aloittaa" ;
lin aloittain_Adv = mkkAdv "aloittain" ;
lin aloittainen_N = mkkN "aloittainen" ;
lin aloittaja_N = mkkN "aloittaja" ;
lin aloittamaton_N = mkkN "aloittamaton" ;
lin aloitteellinen_N = mkkN "aloitteellinen" ;
lin aloitteellisuus_N = mkkN "aloitteellisuus" ;
lin aloitteikas_N = mkkN "aloitteikas" ;
lin aloitteinen_N = mkkN "aloitteinen" ;
lin aloittelija_N = mkkN "aloittelija" ;
lin aloitus_N = mkkN "aloitus" ;
lin alokas_N = mkkN "alokas" ;
lin alokasaika_N = mkkN "alokasaika" ;
lin aloke_N = mkkN "aloke" ;
lin alpakka_1_N = mkkN "alpakka" ;
lin alpakka_2_N = mkkN "alpakka" ;
lin alpakkainen_1_N = mkkN "alpakkainen" ;
lin alpakkainen_2_N = mkkN "alpakkainen" ;
lin alpi_N = mkkN "alpi" ;
lin alpiininen_N = mkkN "alpiininen" ;
lin alpinismi_N = mkkN "alpinismi" ;
lin alppi_N = mkkN "alppi" ;
lin alta_Adv = mkkAdv "alta" ;
lin altis_N = mkkN "altis" ;
lin altistaa_V = mkkV "altistaa" ;
lin altiste_N = mkkN "altiste" ;
lin altisti_N = mkkN "altisti" ;
lin altistua_V = mkkV "altistua" ;
lin altistus_N = mkkN "altistus" ;
lin altistusaika_N = mkkN "altistusaika" ;
lin altruismi_N = mkkN "altruismi" ;
lin altruisti_N = mkkN "altruisti" ;
lin altruistinen_A = mkkA "altruistinen" ;
lin altruistisesti_Adv = mkkAdv "altruistisesti" ;
lin alttari_N = mkkN "alttari" ;
lin alttiisti_Adv = mkkAdv "alttiisti" ;
lin alttius_N = mkkN "alttius" ;
lin altto_N = mkkN "altto" ;
lin alue_N = mkkN "alue" ;
lin alueellinen_A = mkkA "alueellinen" ;
lin alueellisesti_Adv = mkkAdv "alueellisesti" ;
lin alueinen_N = mkkN "alueinen" ;
lin alueittain_Adv = mkkAdv "alueittain" ;
lin alueittainen_N = mkkN "alueittainen" ;
lin aluke_N = mkkN "aluke" ;
lin aluksi_Adv = mkkAdv "aluksi" ;
lin alulla_Adv = mkkAdv "alulla" ;
lin alullaan_Adv = mkkAdv "alullaan" ;
lin alumiini_N = mkkN "alumiini" ;
lin alumiininen_N = mkkN "alumiininen" ;
lin aluminoida_V = mkkV "aluminoida" ;
lin aluminointi_N = mkkN "aluminointi" ;
lin alumpana_Adv = mkkAdv "alumpana" ;
lin alun_Adv = mkkAdv "alun" ;
lin aluna_N = mkkN "aluna" ;
lin alun_alkaen_Adv = mkkAdv "aluC" ;
lin alunen_N = mkkN "alunen" ;
lin alun_perin_Adv = mkkAdv "aluC" ;
lin alun_pita'en_Adv = mkkAdv "aluC" ;
lin alus_N = mkkN "alus" ;
lin alussa_mainittu_N = mkkN "alussC" ;
lin alusta_N = mkkN "alusta" ;
lin alustaa_V = mkkV "alustaa" ;
lin alustaja_N = mkkN "alustaja" ;
lin alustava_A = mkkA "alustava" ;
lin alustavasti_Adv = mkkAdv "alustavasti" ;
lin alustus_N = mkkN "alustus" ;
lin alusvaatteisillaan_Adv = mkkAdv "alusvaatteisillaan" ;
lin alusvaatteisilleen_Adv = mkkAdv "alusvaatteisilleen" ;
lin alvariinsa_Adv = mkkAdv "alvariinsa" ;
lin alvejuuri_N = mkkN "alvejuuri" ;
lin amalgaami_N = mkkN "amalgaami" ;
lin amanuenssi_N = mkkN "amanuenssi" ;
lin amaryllis_N = mkkN "amaryllis" ;
lin amatsoni_N = mkkN "amatsoni" ;
lin amato'o'ri_N = mkkN "amatööri" ;
lin amato'o'riys_N = mkkN "amatööriys" ;
lin ambiofonia_N = mkkN "ambiofonia" ;
lin ambiofoninen_N = mkkN "ambiofoninen" ;
lin ambitio_N = mkkN "ambitio" ;
lin ambivalenssi_N = mkkN "ambivalenssi" ;
lin ambivalentti_N = mkkN "ambivalentti" ;
lin ambivalenttinen_N = mkkN "ambivalenttinen" ;
lin ambra_N = mkkN "ambra" ;
lin ambrosia_N = mkkN "ambrosia" ;
lin ambulanssi_N = mkkN "ambulanssi" ;
lin ameba_N = mkkN "ameba" ;
lin amenorrea_N = mkkN "amenorrea" ;
lin amerikkalainen_N = mkkN "amerikkalainen" ;
lin amerikkalaistua_V = mkkV "amerikkalaistua" ;
lin amerikkalaisuus_N = mkkN "amerikkalaisuus" ;
lin ametisti_N = mkkN "ametisti" ;
lin amfetamiini_N = mkkN "amfetamiini" ;
lin amfora_N = mkkN "amfora" ;
lin amiraali_N = mkkN "amiraali" ;
lin ammateittain_Adv = mkkAdv "ammateittain" ;
lin ammateittainen_N = mkkN "ammateittainen" ;
lin ammatillinen_A = mkkA "ammatillinen" ;
lin ammatillisesti_Adv = mkkAdv "ammatillisesti" ;
lin ammatillistaa_V = mkkV "ammatillistaa" ;
lin ammatillistua_V = mkkV "ammatillistua" ;
lin ammatillisuus_N = mkkN "ammatillisuus" ;
lin ammatti_N = mkkN "ammatti" ;
lin ammattilaistaa_V = mkkV "ammattilaistaa" ;
lin ammattilaistua_V = mkkV "ammattilaistua" ;
lin ammattilaisuus_N = mkkN "ammattilaisuus" ;
lin ammattimaisesti_Adv = mkkAdv "ammattimaisesti" ;
lin ammattimaisuus_N = mkkN "ammattimaisuus" ;
lin amme_N = mkkN "amme" ;
lin ammennus_N = mkkN "ammennus" ;
lin ammentaa_V = mkkV "ammentaa" ;
lin ammis_N = mkkN "ammis" ;
lin ammoin_Adv = mkkAdv "ammoin" ;
lin ammoinen_N = mkkN "ammoinen" ;
lin ammolla_Adv = mkkAdv "ammolla" ;
lin ammollaan_Adv = mkkAdv "ammollaan" ;
lin ammolle_Adv = mkkAdv "ammolle" ;
lin ammolleen_Adv = mkkAdv "ammolleen" ;
lin ammoniakki_N = mkkN "ammoniakki" ;
lin ammoniumkloridi_N = mkkN "ammoniumkloridi" ;
lin ammottaa_V = mkkV "ammottaa" ;
lin ammu_N = mkkN "ammu" ;
lin ammua_V = mkkV "ammua" ;
lin ammunta_1_N = mkkN "ammunta" ;
lin ammunta_2_N = mkkN "ammunta" ;
lin ammus_N = mkkN "ammus" ;
lin ammuskelija_N = mkkN "ammuskelija" ;
lin ammuskella_V = mkkV "ammuskella" ;
lin ammuskelu_N = mkkN "ammuskelu" ;
lin ammuttaa_V = mkkV "ammuttaa" ;
lin ammuu_Adv = mkkAdv "ammuu" ;
lin amnesia_N = mkkN "amnesia" ;
lin amnestia_N = mkkN "amnestia" ;
lin amok_N = mkkN "amok" ;
lin amorfinen_N = mkkN "amorfinen" ;
lin amorfisuus_N = mkkN "amorfisuus" ;
lin amoriini_N = mkkN "amoriini" ;
lin ampaista_V = mkkV "ampaista" ;
lin ampeeri_N = mkkN "ampeeri" ;
lin ampiainen_N = mkkN "ampiainen" ;
lin amplitudi_N = mkkN "amplitudi" ;
lin amppeli_N = mkkN "amppeli" ;
lin ampu_N = mkkN "ampu" ;
lin ampua_V = mkkV "ampua" ;
lin ampuilla_V = mkkV "ampuilla" ;
lin ampuja_N = mkkN "ampuja" ;
lin ampulli_N = mkkN "ampulli" ;
lin ampumahaava_N = mkkN "ampumahaava" ;
lin amputaatio_N = mkkN "amputaatio" ;
lin amputoida_V = mkkV "amputoida" ;
lin amputointi_N = mkkN "amputointi" ;
lin amuletti_N = mkkN "amuletti" ;
lin anaalinen_N = mkkN "anaalinen" ;
lin anaboli_N = mkkN "anaboli" ;
lin anabolinen_N = mkkN "anabolinen" ;
lin anaerobinen_N = mkkN "anaerobinen" ;
lin anagrammi_N = mkkN "anagrammi" ;
lin anakoluutti_N = mkkN "anakoluutti" ;
lin anakoluuttinen_N = mkkN "anakoluuttinen" ;
lin anakonda_N = mkkN "anakonda" ;
lin anakronismi_N = mkkN "anakronismi" ;
lin anakronistinen_A = mkkA "anakronistinen" ;
lin anakronistisesti_Adv = mkkAdv "anakronistisesti" ;
lin anakronistisuus_N = mkkN "anakronistisuus" ;
lin analfabeetti_N = mkkN "analfabeetti" ;
lin analgeetti_N = mkkN "analgeetti" ;
lin analgeettinen_A = mkkA "analgeettinen" ;
lin analgeettisesti_Adv = mkkAdv "analgeettisesti" ;
lin analgeettisuus_N = mkkN "analgeettisuus" ;
lin analgesia_N = mkkN "analgesia" ;
lin analogia_N = mkkN "analogia" ;
lin analoginen_A = mkkA "analoginen" ;
lin analogisesti_Adv = mkkAdv "analogisesti" ;
lin analogisuus_N = mkkN "analogisuus" ;
lin analysaattori_N = mkkN "analysaattori" ;
lin analysoida_V = mkkV "analysoida" ;
lin analysointi_N = mkkN "analysointi" ;
lin analytiikka_N = mkkN "analytiikka" ;
lin analyysi_N = mkkN "analyysi" ;
lin analyytikko_N = mkkN "analyytikko" ;
lin analyyttinen_A = mkkA "analyyttinen" ;
lin analyyttisesti_Adv = mkkAdv "analyyttisesti" ;
lin analyyttisuus_N = mkkN "analyyttisuus" ;
lin analyyttisyys_N = mkkN "analyyttisyys" ;
lin anamneesi_N = mkkN "anamneesi" ;
lin anamnestinen_N = mkkN "anamnestinen" ;
lin ananas_N = mkkN "ananas" ;
lin anarkia_N = mkkN "anarkia" ;
lin anarkismi_N = mkkN "anarkismi" ;
lin anarkisti_N = mkkN "anarkisti" ;
lin anarkistinen_A = mkkA "anarkistinen" ;
lin anarkistisesti_Adv = mkkAdv "anarkistisesti" ;
lin anarkistisuus_N = mkkN "anarkistisuus" ;
lin anastaa_V = mkkV "anastaa" ;
lin anastaja_N = mkkN "anastaja" ;
lin anastus_N = mkkN "anastus" ;
lin anatomi_N = mkkN "anatomi" ;
lin anatomia_N = mkkN "anatomia" ;
lin anatominen_A = mkkA "anatominen" ;
lin anatomisesti_Adv = mkkAdv "anatomisesti" ;
lin andante_N = mkkN "andante" ;
lin andantino_N = mkkN "andantino" ;
lin androgeeni_N = mkkN "androgeeni" ;
lin androgeeninen_N = mkkN "androgeeninen" ;
lin androgynia_N = mkkN "androgynia" ;
lin androgyyni_N = mkkN "androgyyni" ;
lin androgyyninen_N = mkkN "androgyyninen" ;
lin andrologi_N = mkkN "andrologi" ;
lin andrologia_N = mkkN "andrologia" ;
lin androloginen_A = mkkA "androloginen" ;
lin andrologisesti_Adv = mkkAdv "andrologisesti" ;
lin ane_N = mkkN "ane" ;
lin aneeminen_A = mkkA "aneeminen" ;
lin aneemisesti_Adv = mkkAdv "aneemisesti" ;
lin aneemisuus_N = mkkN "aneemisuus" ;
lin anekdootti_N = mkkN "anekdootti" ;
lin anella_V = mkkV "anella" ;
lin anemia_N = mkkN "anemia" ;
lin anesteetti_N = mkkN "anesteetti" ;
lin anestesia_N = mkkN "anestesia" ;
lin anestesiologi_N = mkkN "anestesiologi" ;
lin anestesiologia_N = mkkN "anestesiologia" ;
lin anestesiologinen_A = mkkA "anestesiologinen" ;
lin anestesiologisesti_Adv = mkkAdv "anestesiologisesti" ;
lin aneurysma_N = mkkN "aneurysma" ;
lin angervo_N = mkkN "angervo" ;
lin angiina_N = mkkN "angiina" ;
lin angina_pectoris_N = mkkN "anginC" ;
lin angiografia_N = mkkN "angiografia" ;
lin anglikaaninen_N = mkkN "anglikaaninen" ;
lin anglismi_N = mkkN "anglismi" ;
lin anglisti_N = mkkN "anglisti" ;
lin anglistiikka_N = mkkN "anglistiikka" ;
lin anglosaksi_N = mkkN "anglosaksi" ;
lin anglosaksinen_N = mkkN "anglosaksinen" ;
lin angora_N = mkkN "angora" ;
lin ani_Adv = mkkAdv "ani" ;
lin aniitti_N = mkkN "aniitti" ;
lin aniliini_N = mkkN "aniliini" ;
lin animaalisuus_N = mkkN "animaalisuus" ;
lin animaatio_N = mkkN "animaatio" ;
lin animismi_N = mkkN "animismi" ;
lin animistinen_N = mkkN "animistinen" ;
lin anioni_N = mkkN "anioni" ;
lin anis_N = mkkN "anis" ;
lin anjovis_N = mkkN "anjovis" ;
lin ankara_A = mkkA "ankara" ;
lin ankarasti_Adv = mkkAdv "ankarasti" ;
lin ankaruus_N = mkkN "ankaruus" ;
lin ankea_A = mkkA "ankea" ;
lin ankeasti_Adv = mkkAdv "ankeasti" ;
lin ankerias_N = mkkN "ankerias" ;
lin ankeroinen_N = mkkN "ankeroinen" ;
lin ankeus_N = mkkN "ankeus" ;
lin ankka_N = mkkN "ankka" ;
lin ankkuri_N = mkkN "ankkuri" ;
lin ankkuroida_V = mkkV "ankkuroida" ;
lin ankkurointi_N = mkkN "ankkurointi" ;
lin ankkuroitua_V = mkkV "ankkuroitua" ;
lin annella_V = mkkV "annella" ;
lin anniskella_V = mkkV "anniskella" ;
lin anniskelu_N = mkkN "anniskelu" ;
lin annoksinen_N = mkkN "annoksinen" ;
lin annoksittain_Adv = mkkAdv "annoksittain" ;
lin annoona_N = mkkN "annoona" ;
lin annos_N = mkkN "annos" ;
lin annostaa_V = mkkV "annostaa" ;
lin annostella_V = mkkV "annostella" ;
lin annostelu_N = mkkN "annostelu" ;
lin annostus_N = mkkN "annostus" ;
lin annuiteetti_N = mkkN "annuiteetti" ;
lin anoa_V = mkkV "anoa" ;
lin anodi_N = mkkN "anodi" ;
lin anoja_N = mkkN "anoja" ;
lin anomaalinen_A = mkkA "anomaalinen" ;
lin anomaalisesti_Adv = mkkAdv "anomaalisesti" ;
lin anomaalisuus_N = mkkN "anomaalisuus" ;
lin anomalia_N = mkkN "anomalia" ;
lin anomus_N = mkkN "anomus" ;
lin anonymiteetti_N = mkkN "anonymiteetti" ;
lin anonyymi_N = mkkN "anonyymi" ;
lin anonyymius_N = mkkN "anonyymius" ;
lin anonyymiys_N = mkkN "anonyymiys" ;
--? lin anopikset_NK = {s = d39 "anopikset" ;
lin anoppi_N = mkkN "anoppi" ;
lin anoppila_N = mkkN "anoppila" ;
lin anorakki_N = mkkN "anorakki" ;
lin anoreksia_N = mkkN "anoreksia" ;
lin anorektikko_N = mkkN "anorektikko" ;
lin ansa_N = mkkN "ansa" ;
lin ansainta_N = mkkN "ansainta" ;
lin ansaita_V = mkkV "ansaita" ;
lin ansaitsematon_N = mkkN "ansaitsematon" ;
lin ansaitusti_Adv = mkkAdv "ansaitusti" ;
lin ansari_N = mkkN "ansari" ;
lin ansas_N = mkkN "ansas" ;
lin ansatsi_N = mkkN "ansatsi" ;
lin ansio_N = mkkN "ansio" ;
lin ansioitua_V = mkkV "ansioitua" ;
lin ansiokas_A = mkkA "ansiokas" ;
lin ansiokkaasti_Adv = mkkAdv "ansiokkaasti" ;
lin ansiokkuus_N = mkkN "ansiokkuus" ;
lin ansiosta_Adv = mkkAdv "ansiosta" ;
lin ansioton_N = mkkN "ansioton" ;
lin ansiottomasti_Adv = mkkAdv "ansiottomasti" ;
lin ansiottomuus_N = mkkN "ansiottomuus" ;
lin ansoittaa_V = mkkV "ansoittaa" ;
lin ansoitus_N = mkkN "ansoitus" ;
lin antaa_V = mkkV "antaa" ;
lin antagonismi_N = mkkN "antagonismi" ;
lin antagonisti_N = mkkN "antagonisti" ;
lin antagonistinen_N = mkkN "antagonistinen" ;
lin antaja_N = mkkN "antaja" ;
lin antarktinen_N = mkkN "antarktinen" ;
lin antasidi_N = mkkN "antasidi" ;
lin antaumuksellinen_A = mkkA "antaumuksellinen" ;
lin antaumuksellisesti_Adv = mkkAdv "antaumuksellisesti" ;
lin antaumuksellisuus_N = mkkN "antaumuksellisuus" ;
lin antaumus_N = mkkN "antaumus" ;
lin antautua_V = mkkV "antautua" ;
lin anteeksi_Adv = mkkAdv "anteeksi" ;
lin anteeksiannettava_N = mkkN "anteeksiannettava" ;
lin anteeksiantamaton_N = mkkN "anteeksiantamaton" ;
lin anteeksiantamattomasti_Adv = mkkAdv "anteeksiantamattomasti" ;
lin anteeksiantamattomuus_N = mkkN "anteeksiantamattomuus" ;
lin anteeksiantamus_N = mkkN "anteeksiantamus" ;
lin anteeksiantava_N = mkkN "anteeksiantava" ;
lin anteliaasti_Adv = mkkAdv "anteliaasti" ;
lin anteliaisuus_N = mkkN "anteliaisuus" ;
lin antelias_A = mkkA "antelias" ;
lin antenni_N = mkkN "antenni" ;
lin anti_1_N = mkkN "anti" ;
lin antibiootti_N = mkkN "antibiootti" ;
lin antibioottinen_N = mkkN "antibioottinen" ;
lin antidepressiivi_N = mkkN "antidepressiivi" ;
lin antiikki_N = mkkN "antiikki" ;
lin antiikkinen_N = mkkN "antiikkinen" ;
lin antiikva_N = mkkN "antiikva" ;
lin anti_inflammatorinen_N = mkkN "anti-inflammatorinen" ;
lin antikristus_N = mkkN "antikristus" ;
lin antikvaarinen_N = mkkN "antikvaarinen" ;
lin antikvariaatti_N = mkkN "antikvariaatti" ;
lin antilooppi_N = mkkN "antilooppi" ;
--? lin antimet_NK = {s = d33A "antimet" ;
lin antioksidantti_N = mkkN "antioksidantti" ;
lin antipasto_N = mkkN "antipasto" ;
lin antipatia_N = mkkN "antipatia" ;
lin antiperspirantti_N = mkkN "antiperspirantti" ;
lin antisemiitti_N = mkkN "antisemiitti" ;
lin antisemiittinen_A = mkkA "antisemiittinen" ;
lin antisemiittisesti_Adv = mkkAdv "antisemiittisesti" ;
lin antisemitismi_N = mkkN "antisemitismi" ;
lin antisepti_N = mkkN "antisepti" ;
lin anto_N = mkkN "anto" ;
lin antoisa_A = mkkA "antoisa" ;
lin antoisasti_Adv = mkkAdv "antoisasti" ;
lin antoisuus_N = mkkN "antoisuus" ;
lin antologia_N = mkkN "antologia" ;
lin antrasiitti_N = mkkN "antrasiitti" ;
lin antropologi_N = mkkN "antropologi" ;
lin antropologia_N = mkkN "antropologia" ;
lin antropologinen_A = mkkA "antropologinen" ;
lin antropologisesti_Adv = mkkAdv "antropologisesti" ;
lin antroposofi_N = mkkN "antroposofi" ;
lin antroposofia_N = mkkN "antroposofia" ;
lin antura_N = mkkN "antura" ;
lin anturi_N = mkkN "anturi" ;
lin aortta_N = mkkN "aortta" ;
lin apaattinen_A = mkkA "apaattinen" ;
lin apaattisesti_Adv = mkkAdv "apaattisesti" ;
lin apaattisuus_N = mkkN "apaattisuus" ;
lin apaja_N = mkkN "apaja" ;
lin aparaatti_N = mkkN "aparaatti" ;
lin apartamento_N = mkkN "apartamento" ;
lin apartheid_N = mkkN "apartheid" ;
lin apassi_N = mkkN "apassi" ;
lin apatia_N = mkkN "apatia" ;
lin apatiitti_N = mkkN "apatiitti" ;
lin ape_N = mkkN "ape" ;
lin apea_A = mkkA "apea" ;
lin apeasti_Adv = mkkAdv "apeasti" ;
lin apeissaan_Adv = mkkAdv "apeissaan" ;
lin aperitiivi_N = mkkN "aperitiivi" ;
lin apeus_N = mkkN "apeus" ;
lin apeutua_V = mkkV "apeutua" ;
lin apila_N = mkkN "apila" ;
lin apina_N = mkkN "apina" ;
lin apinoida_V = mkkV "apinoida" ;
lin apinointi_N = mkkN "apinointi" ;
lin aplodeerata_V = mkkV "aplodeerata" ;
lin aplodeeraus_N = mkkN "aplodeeraus" ;
lin aplodi_N = mkkN "aplodi" ;
lin apnea_N = mkkN "apnea" ;
lin apokalypsi_N = mkkN "apokalypsi" ;
lin apokalyptinen_N = mkkN "apokalyptinen" ;
lin apokryfi_N = mkkN "apokryfi" ;
lin apokryfinen_A = mkkA "apokryfinen" ;
lin apokryfisesti_Adv = mkkAdv "apokryfisesti" ;
lin apokryfisuus_N = mkkN "apokryfisuus" ;
lin apokryfisyys_N = mkkN "apokryfisyys" ;
lin apologeetta_N = mkkN "apologeetta" ;
lin apologeettinen_N = mkkN "apologeettinen" ;
lin apologia_N = mkkN "apologia" ;
lin apoptoosi_N = mkkN "apoptoosi" ;
lin apostoli_N = mkkN "apostoli" ;
lin apostolinen_N = mkkN "apostolinen" ;
lin apotti_N = mkkN "apotti" ;
lin appaa_V = mkkV "appaa" ;
lin apparaatti_N = mkkN "apparaatti" ;
lin appela_N = mkkN "appela" ;
lin appellatiivi_N = mkkN "appellatiivi" ;
lin appelsiini_N = mkkN "appelsiini" ;
lin appelsiininkuori_N = mkkN "appelsiininkuori" ;
lin appenzeller_N = mkkN "appenzeller" ;
lin appi_N = mkkN "appi" ;
lin applikaatio_N = mkkN "applikaatio" ;
lin applikoida_V = mkkV "applikoida" ;
lin applikointi_N = mkkN "applikointi" ;
lin apposen_Adv = mkkAdv "apposen" ;
--? lin apposet_NK = {s = d38 "apposet" ;
lin appositio_N = mkkN "appositio" ;
lin approbatur_N = mkkN "approbatur" ;
lin aprikoida_V = mkkV "aprikoida" ;
lin aprikointi_N = mkkN "aprikointi" ;
lin aprikoosi_N = mkkN "aprikoosi" ;
lin aprillata_V = mkkV "aprillata" ;
lin aprillaus_N = mkkN "aprillaus" ;
lin aprilli_N = mkkN "aprilli" ;
lin a_priori_Adv = mkkAdv "a priori" ;
lin apriorinen_A = mkkA "apriorinen" ;
lin apriorisesti_Adv = mkkAdv "apriorisesti" ;
lin apriorisuus_N = mkkN "apriorisuus" ;
lin apro_N = mkkN "apro" ;
lin apropoo_Adv = mkkAdv "apropoo" ;
lin apteekkari_N = mkkN "apteekkari" ;
lin apteekki_N = mkkN "apteekki" ;
lin apu_N = mkkN "apu" ;
lin apuri_N = mkkN "apuri" ;
lin arabeski_N = mkkN "arabeski" ;
lin arabi_N = mkkN "arabi" ;
lin arabia_N = mkkN "arabia" ;
lin arabisti_N = mkkN "arabisti" ;
lin arabistiikka_N = mkkN "arabistiikka" ;
lin aralia_N = mkkN "aralia" ;
lin aramea_N = mkkN "aramea" ;
lin arastaa_V = mkkV "arastaa" ;
lin arastella_V = mkkV "arastella" ;
lin arastelu_N = mkkN "arastelu" ;
lin arasti_Adv = mkkAdv "arasti" ;
lin araukaria_N = mkkN "araukaria" ;
lin arava_N = mkkN "arava" ;
lin arboretum_N = mkkN "arboretum" ;
lin arboristi_N = mkkN "arboristi" ;
lin arbuusi_N = mkkN "arbuusi" ;
lin areena_N = mkkN "areena" ;
lin arenti_N = mkkN "arenti" ;
lin aresti_N = mkkN "aresti" ;
lin argon_N = mkkN "argon" ;
lin argumentaatio_N = mkkN "argumentaatio" ;
lin argumentoida_V = mkkV "argumentoida" ;
lin argumentointi_N = mkkN "argumentointi" ;
lin argumentti_N = mkkN "argumentti" ;
lin arho_N = mkkN "arho" ;
lin arina_N = mkkN "arina" ;
lin aristaa_V = mkkV "aristaa" ;
lin aristella_V = mkkV "aristella" ;
lin aristokraatti_N = mkkN "aristokraatti" ;
lin aristokraattinen_A = mkkA "aristokraattinen" ;
lin aristokraattisesti_Adv = mkkAdv "aristokraattisesti" ;
lin aristokraattisuus_N = mkkN "aristokraattisuus" ;
lin aristokratia_N = mkkN "aristokratia" ;
lin aristua_V = mkkV "aristua" ;
lin aristus_N = mkkN "aristus" ;
lin aritmeettinen_N = mkkN "aritmeettinen" ;
lin aritmetiikka_N = mkkN "aritmetiikka" ;
lin arjalainen_N = mkkN "arjalainen" ;
lin arka_N = mkkN "arka" ;
lin arkaainen_N = mkkN "arkaainen" ;
lin arkailla_V = mkkV "arkailla" ;
lin arkaistinen_A = mkkA "arkaistinen" ;
lin arkaistisesti_Adv = mkkAdv "arkaistisesti" ;
lin arkaistisuus_N = mkkN "arkaistisuus" ;
lin arkala_N = mkkN "arkala" ;
lin arkeittain_Adv = mkkAdv "arkeittain" ;
lin arkeologi_N = mkkN "arkeologi" ;
lin arkeologia_N = mkkN "arkeologia" ;
lin arkeologinen_A = mkkA "arkeologinen" ;
lin arkeologisesti_Adv = mkkAdv "arkeologisesti" ;
lin arki_N = mkkN "arki" ;
lin arkinen_A = mkkA "arkinen" ;
lin arkipa'iva'istya'_V = mkkV "arkipäiväistyä" ;
lin arkipa'iva'ista'a'_V = mkkV "arkipäiväistää" ;
lin arkisesti_Adv = mkkAdv "arkisesti" ;
lin arkisin_Adv = mkkAdv "arkisin" ;
lin arkisto_N = mkkN "arkisto" ;
lin arkistoida_V = mkkV "arkistoida" ;
lin arkistointi_N = mkkN "arkistointi" ;
lin arkistua_V = mkkV "arkistua" ;
lin arkisuus_N = mkkN "arkisuus" ;
lin arkittain_Adv = mkkAdv "arkittain" ;
lin arkki_1_N = mkkN "arkki" ;
lin arkki_2_N = mkkN "arkki" ;
lin arkkiatri_N = mkkN "arkkiatri" ;
lin arkkimandriitta_N = mkkN "arkkimandriitta" ;
lin arkkitehti_N = mkkN "arkkitehti" ;
lin arkkitehtoninen_A = mkkA "arkkitehtoninen" ;
lin arkkitehtonisesti_Adv = mkkAdv "arkkitehtonisesti" ;
lin arkkitehtuuri_N = mkkN "arkkitehtuuri" ;
lin arkku_N = mkkN "arkku" ;
lin arktinen_N = mkkN "arktinen" ;
lin arkullinen_N = mkkN "arkullinen" ;
lin arkuus_N = mkkN "arkuus" ;
lin armada_N = mkkN "armada" ;
lin armagnac_N = mkkN "armagnac" ;
lin armahainen_N = mkkN "armahainen" ;
lin armahdus_N = mkkN "armahdus" ;
lin armahtaa_V = mkkV "armahtaa" ;
lin armahtava_N = mkkN "armahtava" ;
lin armahtavainen_N = mkkN "armahtavainen" ;
lin armainen_N = mkkN "armainen" ;
lin armanjakki_N = mkkN "armanjakki" ;
lin armas_N = mkkN "armas" ;
lin armastella_V = mkkV "armastella" ;
lin armeija_N = mkkN "armeija" ;
lin armeliaasti_Adv = mkkAdv "armeliaasti" ;
lin armeliaisuus_N = mkkN "armeliaisuus" ;
lin armelias_A = mkkA "armelias" ;
lin armias_N = mkkN "armias" ;
lin armo_N = mkkN "armo" ;
lin armoinen_N = mkkN "armoinen" ;
lin armoitettu_N = mkkN "armoitettu" ;
lin armollinen_A = mkkA "armollinen" ;
lin armollisesti_Adv = mkkAdv "armollisesti" ;
lin armollisuus_N = mkkN "armollisuus" ;
lin armonaika_N = mkkN "armonaika" ;
lin armoton_N = mkkN "armoton" ;
lin armottomasti_Adv = mkkAdv "armottomasti" ;
lin armottomuus_N = mkkN "armottomuus" ;
lin aro_N = mkkN "aro" ;
lin aromaattinen_N = mkkN "aromaattinen" ;
lin aromi_N = mkkN "aromi" ;
lin aromikas_N = mkkN "aromikas" ;
lin aromikkuus_N = mkkN "aromikkuus" ;
lin arominen_N = mkkN "arominen" ;
lin aronia_N = mkkN "aronia" ;
lin arpa_N = mkkN "arpa" ;
--? lin arpajaiset_NK = {s = d38 "arpajaiset" ;
lin arpeuma_N = mkkN "arpeuma" ;
lin arpeuttaa_V = mkkV "arpeuttaa" ;
lin arpeutua_V = mkkV "arpeutua" ;
lin arpeutuma_N = mkkN "arpeutuma" ;
lin arpi_N = mkkN "arpi" ;
lin arpinen_N = mkkN "arpinen" ;
lin arpisuus_N = mkkN "arpisuus" ;
lin arpoa_V = mkkV "arpoa" ;
lin arrakki_N = mkkN "arrakki" ;
lin arroganssi_N = mkkN "arroganssi" ;
lin arrogantisti_Adv = mkkAdv "arrogantisti" ;
lin arrogantti_N = mkkN "arrogantti" ;
lin arrowjuuri_N = mkkN "arrowjuuri" ;
lin arseeni_N = mkkN "arseeni" ;
lin arsenaali_N = mkkN "arsenaali" ;
lin arsenikki_N = mkkN "arsenikki" ;
lin art_director_N = mkkN "arC" ;
lin arteesinen_N = mkkN "arteesinen" ;
lin artefakti_N = mkkN "artefakti" ;
lin artenomi_N = mkkN "artenomi" ;
lin arteria_N = mkkN "arteria" ;
lin arterioskleroosi_N = mkkN "arterioskleroosi" ;
lin artesaani_N = mkkN "artesaani" ;
lin artikkeli_N = mkkN "artikkeli" ;
lin artikla_N = mkkN "artikla" ;
lin artikulaatio_N = mkkN "artikulaatio" ;
lin artikuloida_V = mkkV "artikuloida" ;
lin artikulointi_N = mkkN "artikulointi" ;
lin artisokka_N = mkkN "artisokka" ;
lin artisti_N = mkkN "artisti" ;
lin artistinen_N = mkkN "artistinen" ;
lin artistisuus_N = mkkN "artistisuus" ;
lin artoteekki_N = mkkN "artoteekki" ;
lin artriitti_N = mkkN "artriitti" ;
lin artroosi_N = mkkN "artroosi" ;
lin arvaamaton_N = mkkN "arvaamaton" ;
lin arvaamattomasti_Adv = mkkAdv "arvaamattomasti" ;
lin arvaamattomuus_N = mkkN "arvaamattomuus" ;
lin arvailla_V = mkkV "arvailla" ;
lin arvailu_N = mkkN "arvailu" ;
lin arvata_V = mkkV "arvata" ;
lin arvatenkaan_Adv = mkkAdv "arvatenkaan" ;
lin arvatenkin_Adv = mkkAdv "arvatenkin" ;
lin arvattavasti_Adv = mkkAdv "arvattavasti" ;
lin arvaus_N = mkkN "arvaus" ;
lin arvauttaa_V = mkkV "arvauttaa" ;
lin arveleva_A = mkkA "arveleva" ;
lin arvelevainen_N = mkkN "arvelevainen" ;
lin arvelevasti_Adv = mkkAdv "arvelevasti" ;
lin arvella_V = mkkV "arvella" ;
lin arvelu_N = mkkN "arvelu" ;
lin arveluttaa_V = mkkV "arveluttaa" ;
lin arveluttava_A = mkkA "arveluttava" ;
lin arveluttavasti_Adv = mkkAdv "arveluttavasti" ;
lin arveluttavuus_N = mkkN "arveluttavuus" ;
lin arvettua_V = mkkV "arvettua" ;
lin arvio_N = mkkN "arvio" ;
lin arvioida_V = mkkV "arvioida" ;
lin arvioija_N = mkkN "arvioija" ;
lin arviointi_N = mkkN "arviointi" ;
lin arvioitsija_N = mkkN "arvioitsija" ;
lin arvioittaa_V = mkkV "arvioittaa" ;
lin arviolta_Adv = mkkAdv "arviolta" ;
lin arvo_N = mkkN "arvo" ;
lin arvoinen_N = mkkN "arvoinen" ;
lin arvoisa_N = mkkN "arvoisa" ;
lin arvoisuus_N = mkkN "arvoisuus" ;
lin arvoituksellinen_A = mkkA "arvoituksellinen" ;
lin arvoituksellisesti_Adv = mkkAdv "arvoituksellisesti" ;
lin arvoituksellisuus_N = mkkN "arvoituksellisuus" ;
lin arvoitus_N = mkkN "arvoitus" ;
lin arvokas_A = mkkA "arvokas" ;
lin arvokkaasti_Adv = mkkAdv "arvokkaasti" ;
lin arvokkuus_N = mkkN "arvokkuus" ;
lin arvollinen_N = mkkN "arvollinen" ;
lin arvomerkinta'inen_N = mkkN "arvomerkintäinen" ;
lin arvonta_N = mkkN "arvonta" ;
lin arvopaperistaa_V = mkkV "arvopaperistaa" ;
lin arvopaperistua_V = mkkV "arvopaperistua" ;
lin arvostaa_V = mkkV "arvostaa" ;
lin arvosteleva_A = mkkA "arvosteleva" ;
lin arvostelevasti_Adv = mkkAdv "arvostelevasti" ;
lin arvostelija_N = mkkN "arvostelija" ;
lin arvostella_V = mkkV "arvostella" ;
lin arvostelma_N = mkkN "arvostelma" ;
lin arvostelu_N = mkkN "arvostelu" ;
lin arvostelukyvytto'ma'sti_Adv = mkkAdv "arvostelukyvyttömästi" ;
lin arvostus_N = mkkN "arvostus" ;
lin arvoton_N = mkkN "arvoton" ;
lin arvottaa_V = mkkV "arvottaa" ;
lin arvottomasti_Adv = mkkAdv "arvottomasti" ;
lin arvottomuus_N = mkkN "arvottomuus" ;
lin arvovaltaisesti_Adv = mkkAdv "arvovaltaisesti" ;
lin arvova'ritteisesti_Adv = mkkAdv "arvoväritteisesti" ;
lin arvova'ritteisyys_N = mkkN "arvoväritteisyys" ;
lin arvuuttaa_V = mkkV "arvuuttaa" ;
lin asbesti_N = mkkN "asbesti" ;
lin asbestoosi_N = mkkN "asbestoosi" ;
lin ase_N = mkkN "ase" ;
lin aseellinen_N = mkkN "aseellinen" ;
lin aseenkanto_N = mkkN "aseenkanto" ;
lin aseeton_N = mkkN "aseeton" ;
lin aseettomuus_N = mkkN "aseettomuus" ;
lin aseinen_N = mkkN "aseinen" ;
lin aseistaa_V = mkkV "aseistaa" ;
lin aseistakielta'ytyminen_N = mkkN "aseistakieltäytyminen" ;
lin aseistautua_V = mkkV "aseistautua" ;
lin aseistus_N = mkkN "aseistus" ;
lin asema_N = mkkN "asema" ;
lin asemasta_Adv = mkkAdv "asemasta" ;
lin asemesta_Adv = mkkAdv "asemesta" ;
lin asemo_N = mkkN "asemo" ;
lin asemoida_V = mkkV "asemoida" ;
lin asemointi_N = mkkN "asemointi" ;
lin asenne_N = mkkN "asenne" ;
lin asennoitua_V = mkkV "asennoitua" ;
lin asennus_N = mkkN "asennus" ;
lin asentaa_V = mkkV "asentaa" ;
lin asentaja_N = mkkN "asentaja" ;
lin asenteellinen_A = mkkA "asenteellinen" ;
lin asenteellisesti_Adv = mkkAdv "asenteellisesti" ;
lin asenteellisuus_N = mkkN "asenteellisuus" ;
lin asenteinen_N = mkkN "asenteinen" ;
lin asento_N = mkkN "asento" ;
lin asentoinen_N = mkkN "asentoinen" ;
lin aseptiikka_N = mkkN "aseptiikka" ;
lin aseptinen_A = mkkA "aseptinen" ;
lin aseptisesti_Adv = mkkAdv "aseptisesti" ;
lin aseptisuus_N = mkkN "aseptisuus" ;
lin asessori_N = mkkN "asessori" ;
lin asetaatti_N = mkkN "asetaatti" ;
lin asetanta_N = mkkN "asetanta" ;
lin asete_N = mkkN "asete" ;
lin asetella_V = mkkV "asetella" ;
lin asetelma_N = mkkN "asetelma" ;
lin asetin_N = mkkN "asetin" ;
lin asetoni_N = mkkN "asetoni" ;
lin asettaa_V = mkkV "asettaa" ;
lin asettaja_N = mkkN "asettaja" ;
lin asettautua_V = mkkV "asettautua" ;
lin asettelu_N = mkkN "asettelu" ;
lin asetti_N = mkkN "asetti" ;
lin asettua_V = mkkV "asettua" ;
lin asetus_N = mkkN "asetus" ;
lin asetyleeni_N = mkkN "asetyleeni" ;
lin asevelvollisuusaika_N = mkkN "asevelvollisuusaika" ;
lin asfaltoida_V = mkkV "asfaltoida" ;
lin asfaltointi_N = mkkN "asfaltointi" ;
lin asfaltti_N = mkkN "asfaltti" ;
lin asfalttinen_N = mkkN "asfalttinen" ;
lin asia_N = mkkN "asia" ;
lin asiakas_N = mkkN "asiakas" ;
lin asiakkuus_N = mkkN "asiakkuus" ;
lin asiallinen_A = mkkA "asiallinen" ;
lin asiallisesti_Adv = mkkAdv "asiallisesti" ;
lin asiallisuus_N = mkkN "asiallisuus" ;
lin asiantunteva_A = mkkA "asiantunteva" ;
lin asiantuntevasti_Adv = mkkAdv "asiantuntevasti" ;
lin asiapainotteisuus_N = mkkN "asiapainotteisuus" ;
lin asiaton_N = mkkN "asiaton" ;
lin asiattomasti_Adv = mkkAdv "asiattomasti" ;
lin asiattomuus_N = mkkN "asiattomuus" ;
lin asioida_V = mkkV "asioida" ;
lin asiointi_N = mkkN "asiointi" ;
lin askar_N = mkkN "askar" ;
lin askare_N = mkkN "askare" ;
lin askaroida_V = mkkV "askaroida" ;
lin askarointi_N = mkkN "askarointi" ;
lin askarrella_V = mkkV "askarrella" ;
lin askarruttaa_V = mkkV "askarruttaa" ;
lin askartelija_N = mkkN "askartelija" ;
lin askartelu_N = mkkN "askartelu" ;
lin askarteluttaa_V = mkkV "askarteluttaa" ;
lin askeesi_N = mkkN "askeesi" ;
lin askeetti_N = mkkN "askeetti" ;
lin askeettinen_A = mkkA "askeettinen" ;
lin askeettisesti_Adv = mkkAdv "askeettisesti" ;
lin askeettisuus_N = mkkN "askeettisuus" ;
lin askel_N = mkkN "askel" ;
lin askele_N = mkkN "askele" ;
lin askelinen_N = mkkN "askelinen" ;
lin askelittain_Adv = mkkAdv "askelittain" ;
lin askelittainen_N = mkkN "askelittainen" ;
lin askellin_N = mkkN "askellin" ;
lin askellus_N = mkkN "askellus" ;
lin askelma_N = mkkN "askelma" ;
lin askelmittain_Adv = mkkAdv "askelmittain" ;
lin askeltaa_V = mkkV "askeltaa" ;
lin asketismi_N = mkkN "asketismi" ;
lin aski_N = mkkN "aski" ;
lin askites_N = mkkN "askites" ;
lin asosiaalinen_N = mkkN "asosiaalinen" ;
lin asosiaalisuus_N = mkkN "asosiaalisuus" ;
lin aspartaami_N = mkkN "aspartaami" ;
lin aspekti_N = mkkN "aspekti" ;
lin aspi_N = mkkN "aspi" ;
lin assimilaatio_N = mkkN "assimilaatio" ;
lin assimiloida_V = mkkV "assimiloida" ;
lin assimilointi_N = mkkN "assimilointi" ;
lin assimiloitua_V = mkkV "assimiloitua" ;
lin assistentti_N = mkkN "assistentti" ;
lin assistentuuri_N = mkkN "assistentuuri" ;
lin assosiaatio_N = mkkN "assosiaatio" ;
lin assosiatiivinen_N = mkkN "assosiatiivinen" ;
lin assosioida_V = mkkV "assosioida" ;
lin assosiointi_N = mkkN "assosiointi" ;
lin assosioitua_V = mkkV "assosioitua" ;
lin assyrialainen_N = mkkN "assyrialainen" ;
lin assyriologi_N = mkkN "assyriologi" ;
lin assyriologia_N = mkkN "assyriologia" ;
lin astaatti_N = mkkN "astaatti" ;
lin astahtaa_V = mkkV "astahtaa" ;
lin astalo_N = mkkN "astalo" ;
lin astatiini_N = mkkN "astatiini" ;
lin aste_N = mkkN "aste" ;
lin asteelainen_N = mkkN "asteelainen" ;
lin asteenikko_N = mkkN "asteenikko" ;
lin asteeninen_N = mkkN "asteeninen" ;
lin asteikko_N = mkkN "asteikko" ;
lin asteikkoinen_N = mkkN "asteikkoinen" ;
lin asteikollinen_N = mkkN "asteikollinen" ;
lin asteinen_N = mkkN "asteinen" ;
lin asteittain_Adv = mkkAdv "asteittain" ;
lin asteittainen_N = mkkN "asteittainen" ;
lin asteittaisuus_N = mkkN "asteittaisuus" ;
lin astella_V = mkkV "astella" ;
lin astelu_N = mkkN "astelu" ;
lin astenia_N = mkkN "astenia" ;
lin asteri_N = mkkN "asteri" ;
lin asteroidi_N = mkkN "asteroidi" ;
lin asti_Adv = mkkAdv "asti" ;
lin astia_N = mkkN "astia" ;
lin astiallinen_N = mkkN "astiallinen" ;
lin astianpesija'_N = mkkN "astianpesijä" ;
lin astiasto_N = mkkN "astiasto" ;
lin astin_N = mkkN "astin" ;
lin astioittain_Adv = mkkAdv "astioittain" ;
lin astma_N = mkkN "astma" ;
lin astmaatikko_N = mkkN "astmaatikko" ;
lin astmaattinen_N = mkkN "astmaattinen" ;
lin astmainen_N = mkkN "astmainen" ;
lin astraalinen_N = mkkN "astraalinen" ;
lin astrakaani_N = mkkN "astrakaani" ;
lin astrologi_N = mkkN "astrologi" ;
lin astrologia_N = mkkN "astrologia" ;
lin astrologinen_A = mkkA "astrologinen" ;
lin astrologisesti_Adv = mkkAdv "astrologisesti" ;
lin astronautiikka_N = mkkN "astronautiikka" ;
lin astronautti_N = mkkN "astronautti" ;
lin astronomi_N = mkkN "astronomi" ;
lin astronomia_N = mkkN "astronomia" ;
lin astronominen_A = mkkA "astronominen" ;
lin astronomisesti_Adv = mkkAdv "astronomisesti" ;
lin astua_V = mkkV "astua" ;
lin astuja_N = mkkN "astuja" ;
lin astunta_N = mkkN "astunta" ;
lin astuttaa_V = mkkV "astuttaa" ;
lin astutus_N = mkkN "astutus" ;
lin asu_N = mkkN "asu" ;
lin asua_V = mkkV "asua" ;
lin asuinen_N = mkkN "asuinen" ;
lin asuja_N = mkkN "asuja" ;
lin asujaimisto_N = mkkN "asujaimisto" ;
lin asujain_N = mkkN "asujain" ;
lin asukas_N = mkkN "asukas" ;
lin asukki_N = mkkN "asukki" ;
lin asuma_N = mkkN "asuma" ;
lin asumaton_N = mkkN "asumaton" ;
lin asumus_N = mkkN "asumus" ;
lin asunnoton_N = mkkN "asunnoton" ;
lin asunnottomuus_N = mkkN "asunnottomuus" ;
lin asunto_N = mkkN "asunto" ;
lin asuntola_N = mkkN "asuntola" ;
lin asuntosa'a'sta'minen_N = mkkN "asuntosäästäminen" ;
lin asustaa_V = mkkV "asustaa" ;
lin asuste_N = mkkN "asuste" ;
lin asustella_V = mkkV "asustella" ;
lin asuttaa_V = mkkV "asuttaa" ;
lin asuttaja_N = mkkN "asuttaja" ;
lin asutus_N = mkkN "asutus" ;
lin asuuri_N = mkkN "asuuri" ;
lin asvaltoida_V = mkkV "asvaltoida" ;
lin asvaltointi_N = mkkN "asvaltointi" ;
lin asvaltti_N = mkkN "asvaltti" ;
lin asvalttinen_N = mkkN "asvalttinen" ;
lin asymmetria_N = mkkN "asymmetria" ;
lin asymmetrinen_N = mkkN "asymmetrinen" ;
lin asymmetrisyys_N = mkkN "asymmetrisyys" ;
lin atari_N = mkkN "atari" ;
lin atavismi_N = mkkN "atavismi" ;
lin atavistinen_A = mkkA "atavistinen" ;
lin atavistisesti_Adv = mkkAdv "atavistisesti" ;
lin atavistisuus_N = mkkN "atavistisuus" ;
lin ateismi_N = mkkN "ateismi" ;
lin ateisti_N = mkkN "ateisti" ;
lin ateistinen_A = mkkA "ateistinen" ;
lin ateistisesti_Adv = mkkAdv "ateistisesti" ;
lin ateistisuus_N = mkkN "ateistisuus" ;
lin ateljee_N = mkkN "ateljee" ;
lin ateria_N = mkkN "ateria" ;
--? lin aterimet_NK = {s = d33 "aterimet" ;
lin aterioida_V = mkkV "aterioida" ;
lin ateriointi_N = mkkN "ateriointi" ;
lin atk_Adv = mkkAdv "atk" ;
lin atlanttinen_N = mkkN "atlanttinen" ;
lin atlas_N = mkkN "atlas" ;
lin atleetikko_N = mkkN "atleetikko" ;
lin atleetti_N = mkkN "atleetti" ;
lin atleettinen_N = mkkN "atleettinen" ;
lin atleettisuus_N = mkkN "atleettisuus" ;
lin atmosfa'a'ri_N = mkkN "atmosfääri" ;
lin atolli_N = mkkN "atolli" ;
lin atomaarinen_N = mkkN "atomaarinen" ;
lin atomi_N = mkkN "atomi" ;
lin atomiaika_N = mkkN "atomiaika" ;
lin atomismi_N = mkkN "atomismi" ;
lin atomistinen_N = mkkN "atomistinen" ;
lin atomistisuus_N = mkkN "atomistisuus" ;
lin atonaalinen_N = mkkN "atonaalinen" ;
lin atonaalisuus_N = mkkN "atonaalisuus" ;
lin atoopikko_N = mkkN "atoopikko" ;
lin atooppinen_N = mkkN "atooppinen" ;
lin atopia_N = mkkN "atopia" ;
lin atrain_N = mkkN "atrain" ;
lin atrium_N = mkkN "atrium" ;
lin atropia_N = mkkN "atropia" ;
lin atsalea_N = mkkN "atsalea" ;
lin atsteekki_N = mkkN "atsteekki" ;
lin attasea_N = mkkN "attasea" ;
lin attentaatti_N = mkkN "attentaatti" ;
lin attraktiivinen_A = mkkA "attraktiivinen" ;
lin attraktiivisesti_Adv = mkkAdv "attraktiivisesti" ;
lin attraktiivisuus_N = mkkN "attraktiivisuus" ;
lin attraktio_N = mkkN "attraktio" ;
lin attribuutti_N = mkkN "attribuutti" ;
--? lin atulat_NK = {s = d12 "atulat" ;
lin aubergiini_N = mkkN "aubergiini" ;
lin audienssi_N = mkkN "audienssi" ;
lin audiofiili_N = mkkN "audiofiili" ;
lin auditiivinen_N = mkkN "auditiivinen" ;
lin auditoida_V = mkkV "auditoida" ;
lin auditoija_N = mkkN "auditoija" ;
lin auditointi_N = mkkN "auditointi" ;
lin auditorio_N = mkkN "auditorio" ;
lin auer_N = mkkN "auer" ;
lin aueta_V = mkkV "aueta" ;
lin aukaisija_N = mkkN "aukaisija" ;
lin aukaisin_N = mkkN "aukaisin" ;
lin aukaista_V = mkkV "aukaista" ;
lin aukaisu_N = mkkN "aukaisu" ;
lin aukea_N = mkkN "aukea" ;
lin aukeama_N = mkkN "aukeama" ;
lin auki_Adv = mkkAdv "auki" ;
lin aukile_N = mkkN "aukile" ;
lin aukio_N = mkkN "aukio" ;
lin aukko_N = mkkN "aukko" ;
lin aukkoinen_N = mkkN "aukkoinen" ;
lin aukkokohta_N = mkkN "aukkokohta" ;
lin aukoa_V = mkkV "aukoa" ;
lin aukoton_N = mkkN "aukoton" ;
lin aukottaa_V = mkkV "aukottaa" ;
lin aukotus_N = mkkN "aukotus" ;
lin auktorisoida_V = mkkV "auktorisoida" ;
lin auktorisointi_N = mkkN "auktorisointi" ;
lin auktoritaarinen_N = mkkN "auktoritaarinen" ;
lin auktoritatiivinen_A = mkkA "auktoritatiivinen" ;
lin auktoritatiivisesti_Adv = mkkAdv "auktoritatiivisesti" ;
lin auktoritatiivisuus_N = mkkN "auktoritatiivisuus" ;
lin auktoriteetti_N = mkkN "auktoriteetti" ;
lin auktoroida_V = mkkV "auktoroida" ;
lin auktorointi_N = mkkN "auktorointi" ;
lin aula_N = mkkN "aula" ;
lin auliisti_Adv = mkkAdv "auliisti" ;
lin aulio_N = mkkN "aulio" ;
lin aulis_N = mkkN "aulis" ;
lin aulius_N = mkkN "aulius" ;
lin auma_N = mkkN "auma" ;
lin aunus_N = mkkN "aunus" ;
lin aura_1_N = mkkN "aura" ;
lin aura_2_N = mkkN "aura" ;
lin aurata_V = mkkV "aurata" ;
lin auraus_N = mkkN "auraus" ;
lin auringonkilo_N = mkkN "auringonkilo" ;
lin auringoton_N = mkkN "auringoton" ;
lin aurinko_N = mkkN "aurinko" ;
lin aurinkoaika_N = mkkN "aurinkoaika" ;
lin aurinkoinen_A = mkkA "aurinkoinen" ;
lin aurinkoisesti_Adv = mkkAdv "aurinkoisesti" ;
lin aurinkoisuus_N = mkkN "aurinkoisuus" ;
lin aurinkokaha_N = mkkN "aurinkokaha" ;
lin auskultaatio_N = mkkN "auskultaatio" ;
lin auskultantti_N = mkkN "auskultantti" ;
lin auskultoida_V = mkkV "auskultoida" ;
lin auskultointi_N = mkkN "auskultointi" ;
lin aussi_N = mkkN "aussi" ;
lin australialainen_N = mkkN "australialainen" ;
lin autella_V = mkkV "autella" ;
lin autenttinen_N = mkkN "autenttinen" ;
lin autenttisuus_N = mkkN "autenttisuus" ;
lin autere_N = mkkN "autere" ;
lin autereinen_N = mkkN "autereinen" ;
lin autio_N = mkkN "autio" ;
lin autioittaa_V = mkkV "autioittaa" ;
lin autioitua_V = mkkV "autioitua" ;
lin autismi_N = mkkN "autismi" ;
lin autistinen_N = mkkN "autistinen" ;
lin autius_N = mkkN "autius" ;
lin auto_N = mkkN "auto" ;
lin autogiro_N = mkkN "autogiro" ;
lin autoilija_N = mkkN "autoilija" ;
lin autoilla_V = mkkV "autoilla" ;
lin autoilu_N = mkkN "autoilu" ;
lin autoistua_V = mkkV "autoistua" ;
lin autokefaalinen_N = mkkN "autokefaalinen" ;
lin automaatio_N = mkkN "automaatio" ;
lin automaatti_N = mkkN "automaatti" ;
lin automaattinen_A = mkkA "automaattinen" ;
lin automaattisesti_Adv = mkkAdv "automaattisesti" ;
lin automaattistaa_V = mkkV "automaattistaa" ;
lin automaattistua_V = mkkV "automaattistua" ;
lin automaattisuus_N = mkkN "automaattisuus" ;
lin automatiikka_N = mkkN "automatiikka" ;
lin automatisoida_V = mkkV "automatisoida" ;
lin automatisointi_N = mkkN "automatisointi" ;
lin automatisoitua_V = mkkV "automatisoitua" ;
lin autonomia_N = mkkN "autonomia" ;
lin autonominen_N = mkkN "autonominen" ;
lin autoritaarinen_A = mkkA "autoritaarinen" ;
lin autoritaarisesti_Adv = mkkAdv "autoritaarisesti" ;
lin autoritaarisuus_N = mkkN "autoritaarisuus" ;
lin autorita'a'rinen_A = mkkA "autoritäärinen" ;
lin autorita'a'risesti_Adv = mkkAdv "autoritäärisesti" ;
lin autorita'a'risyys_N = mkkN "autoritäärisyys" ;
lin autosomi_N = mkkN "autosomi" ;
lin autotypia_N = mkkN "autotypia" ;
lin auttaa_V = mkkV "auttaa" ;
lin auttaja_N = mkkN "auttaja" ;
lin auttamaton_N = mkkN "auttamaton" ;
lin auttamatta_Adv = mkkAdv "auttamatta" ;
lin auttamattomasti_Adv = mkkAdv "auttamattomasti" ;
lin auttava_A = mkkA "auttava" ;
lin auttavainen_N = mkkN "auttavainen" ;
lin auttavaisuus_N = mkkN "auttavaisuus" ;
lin auttavasti_Adv = mkkAdv "auttavasti" ;
lin autuaallinen_A = mkkA "autuaallinen" ;
lin autuaallisesti_Adv = mkkAdv "autuaallisesti" ;
lin autuaallisuus_N = mkkN "autuaallisuus" ;
lin autuaasti_Adv = mkkAdv "autuaasti" ;
lin autuas_A = mkkA "autuas" ;
lin autuus_N = mkkN "autuus" ;
lin autuuttaa_V = mkkV "autuuttaa" ;
lin auvo_N = mkkN "auvo" ;
lin auvoinen_N = mkkN "auvoinen" ;
lin auvoisa_N = mkkN "auvoisa" ;
lin avaaja_N = mkkN "avaaja" ;
lin avain_N = mkkN "avain" ;
--? lin avajaiset_NK = {s = d38 "avajaiset" ;
lin avanne_N = mkkN "avanne" ;
lin avantgardismi_N = mkkN "avantgardismi" ;
lin avantgardisti_N = mkkN "avantgardisti" ;
lin avantgardistinen_N = mkkN "avantgardistinen" ;
lin avanto_N = mkkN "avanto" ;
lin avara_N = mkkN "avara" ;
lin avarakatseisesti_Adv = mkkAdv "avarakatseisesti" ;
lin avaramielisesti_Adv = mkkAdv "avaramielisesti" ;
lin avarrin_N = mkkN "avarrin" ;
lin avarrus_N = mkkN "avarrus" ;
lin avartaa_V = mkkV "avartaa" ;
lin avartua_V = mkkV "avartua" ;
lin avaruudellinen_N = mkkN "avaruudellinen" ;
lin avaruus_N = mkkN "avaruus" ;
lin avaruusaika_N = mkkN "avaruusaika" ;
lin avata_V = mkkV "avata" ;
lin avauma_N = mkkN "avauma" ;
lin avaus_N = mkkN "avaus" ;
lin avautua_V = mkkV "avautua" ;
lin avautuma_N = mkkN "avautuma" ;
lin avec_N = mkkN "avec" ;
lin aviisi_N = mkkN "aviisi" ;
lin avio_N = mkkN "avio" ;
lin avioinen_N = mkkN "avioinen" ;
lin avioisuus_N = mkkN "avioisuus" ;
lin avioitua_V = mkkV "avioitua" ;
lin aviollinen_N = mkkN "aviollinen" ;
lin avioniikka_N = mkkN "avioniikka" ;
lin avioton_N = mkkN "avioton" ;
lin avittaa_V = mkkV "avittaa" ;
lin avitus_N = mkkN "avitus" ;
lin avo_Adv = mkkAdv "avo" ;
lin avohaava_N = mkkN "avohaava" ;
lin avoimesti_Adv = mkkAdv "avoimesti" ;
lin avoimuus_N = mkkN "avoimuus" ;
lin avoin_N = mkkN "avoin" ;
lin avojaloin_Adv = mkkAdv "avojaloin" ;
lin avokado_N = mkkN "avokado" ;
lin avokas_N = mkkN "avokas" ;
lin avokatseisesti_Adv = mkkAdv "avokatseisesti" ;
lin avoka'tisesti_Adv = mkkAdv "avokätisesti" ;
lin avomaankurkku_N = mkkN "avomaankurkku" ;
lin avomielisesti_Adv = mkkAdv "avomielisesti" ;
lin avonaisesti_Adv = mkkAdv "avonaisesti" ;
lin avorioriisi_N = mkkN "avorioriisi" ;
lin avosilmin_Adv = mkkAdv "avosilmin" ;
lin avosuin_Adv = mkkAdv "avosuin" ;
lin avosyda'misesti_Adv = mkkAdv "avosydämisesti" ;
lin avosylin_Adv = mkkAdv "avosylin" ;
lin avu_N = mkkN "avu" ;
lin avuliaasti_Adv = mkkAdv "avuliaasti" ;
lin avuliaisuus_N = mkkN "avuliaisuus" ;
lin avulias_A = mkkA "avulias" ;
lin avustaa_V = mkkV "avustaa" ;
lin avustaja_N = mkkN "avustaja" ;
lin avustajisto_N = mkkN "avustajisto" ;
lin avuste_N = mkkN "avuste" ;
lin avusteinen_N = mkkN "avusteinen" ;
lin avustus_N = mkkN "avustus" ;
lin avuton_N = mkkN "avuton" ;
lin avuttomasti_Adv = mkkAdv "avuttomasti" ;
lin avuttomuus_N = mkkN "avuttomuus" ;
lin azerbaid_ani_N = mkkN "azerbaidžani" ;
lin azeri_N = mkkN "azeri" ;
lin baana_N = mkkN "baana" ;
lin baari_1_N = mkkN "baari" ;
lin baari_2_N = mkkN "baari" ;
lin baba_N = mkkN "baba" ;
lin baby_N = mkkN "baby" ;
lin babylonialainen_N = mkkN "babylonialainen" ;
lin babysitter_N = mkkN "babysitter" ;
lin backgammon_N = mkkN "backgammon" ;
lin bagatelli_N = mkkN "bagatelli" ;
lin bagatellisoida_V = mkkV "bagatellisoida" ;
lin bailata_V = mkkV "bailata" ;
lin bailaus_N = mkkN "bailaus" ;
--? lin bailut_NK = {s = d01 "bailut" ;
lin bakkanaali_N = mkkN "bakkanaali" ;
lin bakteeri_N = mkkN "bakteeri" ;
lin bakteeriton_N = mkkN "bakteeriton" ;
lin bakteerittomuus_N = mkkN "bakteerittomuus" ;
lin bakteriologia_N = mkkN "bakteriologia" ;
lin bakteriologinen_A = mkkA "bakteriologinen" ;
lin bakteriologisesti_Adv = mkkAdv "bakteriologisesti" ;
lin balalaikka_N = mkkN "balalaikka" ;
lin balansoida_V = mkkV "balansoida" ;
lin balansointi_N = mkkN "balansointi" ;
lin balanssi_N = mkkN "balanssi" ;
lin baletti_N = mkkN "baletti" ;
lin balladi_N = mkkN "balladi" ;
lin ballerina_N = mkkN "ballerina" ;
lin ballistiikka_N = mkkN "ballistiikka" ;
lin ballistinen_N = mkkN "ballistinen" ;
lin balsa_N = mkkN "balsa" ;
lin balsami_N = mkkN "balsami" ;
lin balsamoida_V = mkkV "balsamoida" ;
lin balsamointi_N = mkkN "balsamointi" ;
lin baltti_N = mkkN "baltti" ;
lin balttilaisuus_N = mkkN "balttilaisuus" ;
lin bambu_N = mkkN "bambu" ;
lin banaali_A = mkkA "banaali" ;
lin banaalistaa_V = mkkV "banaalistaa" ;
lin banaalisti_Adv = mkkAdv "banaalisti" ;
lin banaalistua_V = mkkV "banaalistua" ;
lin banaalius_N = mkkN "banaalius" ;
lin banaani_N = mkkN "banaani" ;
lin banalisoida_V = mkkV "banalisoida" ;
lin banalisointi_N = mkkN "banalisointi" ;
lin banalisoitua_V = mkkV "banalisoitua" ;
lin banaliteetti_N = mkkN "banaliteetti" ;
lin banderolli_N = mkkN "banderolli" ;
lin bandiitti_N = mkkN "bandiitti" ;
lin banjo_N = mkkN "banjo" ;
lin banketti_1_N = mkkN "banketti" ;
lin banketti_2_N = mkkN "banketti" ;
lin bantu_N = mkkN "bantu" ;
lin bantustan_N = mkkN "bantustan" ;
lin baptismi_N = mkkN "baptismi" ;
lin baptisti_N = mkkN "baptisti" ;
lin barbaari_N = mkkN "barbaari" ;
lin barbaarimaisesti_Adv = mkkAdv "barbaarimaisesti" ;
lin barbaarimaisuus_N = mkkN "barbaarimaisuus" ;
lin barbaarinen_A = mkkA "barbaarinen" ;
lin barbaarisesti_Adv = mkkAdv "barbaarisesti" ;
lin barbaarisuus_N = mkkN "barbaarisuus" ;
lin barbarismi_N = mkkN "barbarismi" ;
lin barbi_N = mkkN "barbi" ;
lin barbituraatti_N = mkkN "barbituraatti" ;
lin bardi_N = mkkN "bardi" ;
lin baretti_N = mkkN "baretti" ;
lin baritoni_N = mkkN "baritoni" ;
lin barium_N = mkkN "barium" ;
lin barokki_N = mkkN "barokki" ;
lin barokkiaika_N = mkkN "barokkiaika" ;
lin barometri_N = mkkN "barometri" ;
lin barrakuda_N = mkkN "barrakuda" ;
lin barreli_N = mkkN "barreli" ;
lin barrikadi_N = mkkN "barrikadi" ;
lin barytoni_N = mkkN "barytoni" ;
lin basaari_N = mkkN "basaari" ;
lin basaltti_N = mkkN "basaltti" ;
lin baseball_N = mkkN "baseball" ;
lin basenji_N = mkkN "basenji" ;
lin basilika_1_N = mkkN "basilika" ;
lin basilika_2_N = mkkN "basilika" ;
lin basilli_N = mkkN "basilli" ;
lin basisti_N = mkkN "basisti" ;
lin baskeri_N = mkkN "baskeri" ;
lin baski_N = mkkN "baski" ;
lin baskilaisuus_N = mkkN "baskilaisuus" ;
lin basmatiriisi_N = mkkN "basmatiriisi" ;
lin bassetti_N = mkkN "bassetti" ;
lin basso_N = mkkN "basso" ;
lin bastardi_N = mkkN "bastardi" ;
lin bastioni_N = mkkN "bastioni" ;
lin bataatti_N = mkkN "bataatti" ;
lin batikki_N = mkkN "batikki" ;
lin batisti_N = mkkN "batisti" ;
lin batistinen_N = mkkN "batistinen" ;
lin batonki_N = mkkN "batonki" ;
lin baudi_N = mkkN "baudi" ;
lin bauksiitti_N = mkkN "bauksiitti" ;
lin bavaroise_N = mkkN "bavaroise" ;
lin beagle_N = mkkN "beagle" ;
lin beat_N = mkkN "beat" ;
lin beaujolaisviini_N = mkkN "beaujolaisviini" ;
lin beauty_box_N = mkkN "beautC" ;
lin b_b__N = mkkN "bébé" ;
lin bebee_N = mkkN "bebee" ;
lin bebop_N = mkkN "bebop" ;
lin becquerel_N = mkkN "becquerel" ;
lin bed_and_breakfast_Adv = mkkAdv "beC" ;
lin beduiini_N = mkkN "beduiini" ;
lin beesi_N = mkkN "beesi" ;
lin beeta_N = mkkN "beeta" ;
lin begonia_N = mkkN "begonia" ;
lin beguine_N = mkkN "beguine" ;
lin behaviorismi_N = mkkN "behaviorismi" ;
lin behavioristi_N = mkkN "behavioristi" ;
lin behavioristinen_N = mkkN "behavioristinen" ;
lin beibi_N = mkkN "beibi" ;
lin beige_N = mkkN "beige" ;
--? lin beignet_NK = {s = d22 "beignet" ;
lin belladonna_N = mkkN "belladonna" ;
lin benediktiini_N = mkkN "benediktiini" ;
lin benigni_N = mkkN "benigni" ;
lin bensa_N = mkkN "bensa" ;
lin bensiini_N = mkkN "bensiini" ;
lin berberi_1_N = mkkN "berberi" ;
lin berberi_2_N = mkkN "berberi" ;
--? lin bermudat_NK = {s = d09 "bermudat" ;
lin bernhardilainen_N = mkkN "bernhardilainen" ;
lin berylli_N = mkkN "berylli" ;
lin beryllium_N = mkkN "beryllium" ;
lin besserwisser_N = mkkN "besserwisser" ;
lin best_man_N = mkkN "besC" ;
lin bestseller_N = mkkN "bestseller" ;
lin betoni_N = mkkN "betoni" ;
lin betoninen_N = mkkN "betoninen" ;
lin betonoida_V = mkkV "betonoida" ;
lin betonointi_N = mkkN "betonointi" ;
lin biblia_N = mkkN "biblia" ;
lin bibliofiili_N = mkkN "bibliofiili" ;
lin bibliofilia_N = mkkN "bibliofilia" ;
lin bibliografi_N = mkkN "bibliografi" ;
lin bibliografia_N = mkkN "bibliografia" ;
lin bibliografinen_N = mkkN "bibliografinen" ;
lin bidee_N = mkkN "bidee" ;
lin biedermeier_N = mkkN "biedermeier" ;
lin biennaali_N = mkkN "biennaali" ;
lin bigaaminen_N = mkkN "bigaaminen" ;
lin bigamia_N = mkkN "bigamia" ;
lin big_band_N = mkkN "biC" ;
lin biisami_N = mkkN "biisami" ;
lin biisi_N = mkkN "biisi" ;
lin biisoni_N = mkkN "biisoni" ;
lin biitti_N = mkkN "biitti" ;
lin bikarbonaatti_N = mkkN "bikarbonaatti" ;
--? lin bikinit_NK = {s = d06 "bikinit" ;
lin bilanssi_N = mkkN "bilanssi" ;
lin bilateraalinen_A = mkkA "bilateraalinen" ;
lin bilateraalisesti_Adv = mkkAdv "bilateraalisesti" ;
lin bilateraalisuus_N = mkkN "bilateraalisuus" ;
--? lin bileet_NK = {s = d20 "bileet" ;
lin biljardi_N = mkkN "biljardi" ;
lin biljoona_N = mkkN "biljoona" ;
lin bilsa_N = mkkN "bilsa" ;
lin bimetallismi_N = mkkN "bimetallismi" ;
lin binaarinen_N = mkkN "binaarinen" ;
lin bingo_N = mkkN "bingo" ;
lin bingota_V = mkkV "bingota" ;
lin binomi_N = mkkN "binomi" ;
lin bina'a'rinen_N = mkkN "binäärinen" ;
lin biodiversiteetti_N = mkkN "biodiversiteetti" ;
lin biodynaaminen_N = mkkN "biodynaaminen" ;
lin biodynaamisuus_N = mkkN "biodynaamisuus" ;
lin biogeeninen_N = mkkN "biogeeninen" ;
lin biogeenisuus_N = mkkN "biogeenisuus" ;
lin biografi_N = mkkN "biografi" ;
lin biografia_N = mkkN "biografia" ;
lin biografinen_N = mkkN "biografinen" ;
lin biokenoosi_N = mkkN "biokenoosi" ;
lin biologi_N = mkkN "biologi" ;
lin biologia_N = mkkN "biologia" ;
lin biologinen_A = mkkA "biologinen" ;
lin biologisesti_Adv = mkkAdv "biologisesti" ;
lin biometrinen_N = mkkN "biometrinen" ;
lin biopsia_N = mkkN "biopsia" ;
lin biosfa'a'ri_N = mkkN "biosfääri" ;
lin biotooppi_N = mkkN "biotooppi" ;
lin bisarri_A = mkkA "bisarri" ;
lin bisarristi_Adv = mkkAdv "bisarristi" ;
lin biseksuaalisuus_N = mkkN "biseksuaalisuus" ;
lin bismarck_N = mkkN "bismarck" ;
lin bisnes_N = mkkN "bisnes" ;
lin bistro_N = mkkN "bistro" ;
lin bitter_N = mkkN "bitter" ;
lin bitti_N = mkkN "bitti" ;
lin bitumi_N = mkkN "bitumi" ;
lin bitumoida_V = mkkV "bitumoida" ;
lin blandata_V = mkkV "blandata" ;
lin blandaus_N = mkkN "blandaus" ;
lin blandinki_N = mkkN "blandinki" ;
lin blandis_N = mkkN "blandis" ;
lin blanketti_N = mkkN "blanketti" ;
lin blanseerata_V = mkkV "blanseerata" ;
lin blastula_N = mkkN "blastula" ;
lin blazer_N = mkkN "blazer" ;
lin bleiseri_N = mkkN "bleiseri" ;
lin blini_N = mkkN "blini" ;
lin blokata_V = mkkV "blokata" ;
lin blokkaus_N = mkkN "blokkaus" ;
lin blokki_N = mkkN "blokki" ;
lin blokkiintua_V = mkkV "blokkiintua" ;
lin blokkiutua_V = mkkV "blokkiutua" ;
lin blondata_V = mkkV "blondata" ;
lin blondi_N = mkkN "blondi" ;
lin blondiini_N = mkkN "blondiini" ;
lin blues_N = mkkN "blues" ;
lin bluffata_V = mkkV "bluffata" ;
lin bluffaus_N = mkkN "bluffaus" ;
lin bluffi_N = mkkN "bluffi" ;
lin boa_N = mkkN "boa" ;
lin bodaaja_N = mkkN "bodaaja" ;
lin bodari_N = mkkN "bodari" ;
lin bodata_V = mkkV "bodata" ;
lin bodaus_N = mkkN "bodaus" ;
lin bodi_N = mkkN "bodi" ;
lin bodybuilding_N = mkkN "bodybuilding" ;
lin body_stocking_N = mkkN "bodC" ;
lin bofori_N = mkkN "bofori" ;
lin boheemi_N = mkkN "boheemi" ;
lin boikotoida_V = mkkV "boikotoida" ;
lin boikotointi_N = mkkN "boikotointi" ;
lin boikotti_N = mkkN "boikotti" ;
lin boileri_N = mkkN "boileri" ;
lin bokseri_N = mkkN "bokseri" ;
lin boksi_1_N = mkkN "boksi" ;
lin boksi_2_N = mkkN "boksi" ;
lin bolero_N = mkkN "bolero" ;
lin bolsevikki_N = mkkN "bolsevikki" ;
lin bol_evikki_N = mkkN "bolševikki" ;
lin bolsevismi_N = mkkN "bolsevismi" ;
lin bol_evismi_N = mkkN "bolševismi" ;
lin bolsevistinen_N = mkkN "bolsevistinen" ;
lin bol_evistinen_N = mkkN "bolševistinen" ;
lin bongari_N = mkkN "bongari" ;
lin bongata_V = mkkV "bongata" ;
lin bongaus_N = mkkN "bongaus" ;
lin bongo_N = mkkN "bongo" ;
lin bonus_N = mkkN "bonus" ;
lin booli_N = mkkN "booli" ;
lin boomi_N = mkkN "boomi" ;
lin boordi_N = mkkN "boordi" ;
lin boori_N = mkkN "boori" ;
lin boosteri_N = mkkN "boosteri" ;
lin bootsi_N = mkkN "bootsi" ;
lin bordeaux_N = mkkN "bordeaux" ;
lin bordelli_N = mkkN "bordelli" ;
lin bordyyri_N = mkkN "bordyyri" ;
lin borrelioosi_N = mkkN "borrelioosi" ;
lin borssi_N = mkkN "borssi" ;
lin bor_t__N = mkkN "borštš" ;
lin bosniahertsegovinalainen_N = mkkN "bosniahertsegovinalainen" ;
lin bosoni_N = mkkN "bosoni" ;
lin bossa_nova_N = mkkN "bossC" ;
lin botaanikko_N = mkkN "botaanikko" ;
lin botaaninen_A = mkkA "botaaninen" ;
lin botaanisesti_Adv = mkkAdv "botaanisesti" ;
lin botaniikka_N = mkkN "botaniikka" ;
lin botanisti_N = mkkN "botanisti" ;
lin botuliini_N = mkkN "botuliini" ;
lin botulismi_N = mkkN "botulismi" ;
lin bougainvillea_N = mkkN "bougainvillea" ;
lin bouillabaisse_N = mkkN "bouillabaisse" ;
--? lin bouquet_NK = {s = d22 "bouquet" ;
lin bourbon_N = mkkN "bourbon" ;
lin bourette_N = mkkN "bourette" ;
lin bourgogne_N = mkkN "bourgogne" ;
lin boutique_N = mkkN "boutique" ;
lin boyfriend_N = mkkN "boyfriend" ;
lin braatvursti_N = mkkN "braatvursti" ;
lin brahma_N = mkkN "brahma" ;
lin brahmaani_N = mkkN "brahmaani" ;
lin brahmalaisuus_N = mkkN "brahmalaisuus" ;
lin brahmanismi_N = mkkN "brahmanismi" ;
lin bramaani_N = mkkN "bramaani" ;
lin bramiini_N = mkkN "bramiini" ;
lin brandy_N = mkkN "brandy" ;
lin brasserie_N = mkkN "brasserie" ;
lin brassi_N = mkkN "brassi" ;
lin bravo_Adv = mkkAdv "bravo" ;
lin bravuuri_N = mkkN "bravuuri" ;
lin breikata_V = mkkV "breikata" ;
lin breikkaus_N = mkkN "breikkaus" ;
lin breikki_N = mkkN "breikki" ;
lin brenkku_N = mkkN "brenkku" ;
lin breseerata_V = mkkV "breseerata" ;
lin bre_nevila'inen_A = mkkA "brežneviläinen" ;
lin bre_nevila'isesti_Adv = mkkAdv "brežneviläisesti" ;
lin bre_nevila'isyys_N = mkkN "brežneviläisyys" ;
lin bridge_N = mkkN "bridge" ;
lin brie_N = mkkN "brie" ;
lin brigado'o'ri_N = mkkN "brigadööri" ;
lin briiffaus_N = mkkN "briiffaus" ;
lin briketti_N = mkkN "briketti" ;
lin briljantti_N = mkkN "briljantti" ;
lin briljeerata_V = mkkV "briljeerata" ;
lin briljeeraus_N = mkkN "briljeeraus" ;
lin briossi_N = mkkN "briossi" ;
lin britti_N = mkkN "britti" ;
lin brittila'inen_N = mkkN "brittiläinen" ;
lin brittila'isyys_N = mkkN "brittiläisyys" ;
lin brodeerata_V = mkkV "brodeerata" ;
lin brodeeraus_N = mkkN "brodeeraus" ;
lin brodyyri_N = mkkN "brodyyri" ;
lin broidi_N = mkkN "broidi" ;
lin broileri_N = mkkN "broileri" ;
lin brokadi_N = mkkN "brokadi" ;
lin brokkoli_N = mkkN "brokkoli" ;
lin bromi_N = mkkN "bromi" ;
lin bronkiitti_N = mkkN "bronkiitti" ;
lin brontosaurus_N = mkkN "brontosaurus" ;
lin brosyyri_N = mkkN "brosyyri" ;
lin brovninki_N = mkkN "brovninki" ;
lin brunch_N = mkkN "brunch" ;
lin brunssi_N = mkkN "brunssi" ;
lin brutaali_N = mkkN "brutaali" ;
lin brutaalius_N = mkkN "brutaalius" ;
lin brutto_N = mkkN "brutto" ;
lin bryssa'_N = mkkN "bryssä" ;
lin bra'ndi_N = mkkN "brändi" ;
lin buddhalainen_N = mkkN "buddhalainen" ;
lin buddhalaisuus_N = mkkN "buddhalaisuus" ;
lin buddhismi_N = mkkN "buddhismi" ;
lin budjetoida_V = mkkV "budjetoida" ;
lin budjetointi_N = mkkN "budjetointi" ;
lin budjetti_N = mkkN "budjetti" ;
lin budo_N = mkkN "budo" ;
lin bufetti_N = mkkN "bufetti" ;
--? lin buffet_NK = {s = d22 "buffet" ;
lin bugi_N = mkkN "bugi" ;
lin bukee_N = mkkN "bukee" ;
lin buklee_N = mkkN "buklee" ;
lin bulevardi_N = mkkN "bulevardi" ;
lin bulgaari_N = mkkN "bulgaari" ;
lin bulgarialainen_N = mkkN "bulgarialainen" ;
lin buliimikko_N = mkkN "buliimikko" ;
lin bulimia_N = mkkN "bulimia" ;
lin bulkki_N = mkkN "bulkki" ;
lin bulla_N = mkkN "bulla" ;
lin bulldoggi_N = mkkN "bulldoggi" ;
lin bulvaani_N = mkkN "bulvaani" ;
lin bumerangi_N = mkkN "bumerangi" ;
lin bungalow_N = mkkN "bungalow" ;
lin bunkkeri_N = mkkN "bunkkeri" ;
lin burnout_N = mkkN "burnout" ;
lin business_N = mkkN "business" ;
lin busmanni_N = mkkN "busmanni" ;
lin bu_manni_N = mkkN "bušmanni" ;
lin bussi_N = mkkN "bussi" ;
lin butaani_N = mkkN "butaani" ;
lin buuata_V = mkkV "buuata" ;
lin buuaus_N = mkkN "buuaus" ;
lin buukata_V = mkkV "buukata" ;
lin buukkaus_N = mkkN "buukkaus" ;
lin buumi_N = mkkN "buumi" ;
lin buuri_N = mkkN "buuri" ;
lin buzuki_N = mkkN "buzuki" ;
lin bygga_N = mkkN "bygga" ;
lin byrokraatti_N = mkkN "byrokraatti" ;
lin byrokraattinen_N = mkkN "byrokraattinen" ;
lin byrokraattisesti_Adv = mkkAdv "byrokraattisesti" ;
lin byrokraattistaa_V = mkkV "byrokraattistaa" ;
lin byrokraattistua_V = mkkV "byrokraattistua" ;
lin byrokraattisuus_N = mkkN "byrokraattisuus" ;
lin byrokratia_N = mkkN "byrokratia" ;
lin byrokratisoida_V = mkkV "byrokratisoida" ;
lin byrokratisointi_N = mkkN "byrokratisointi" ;
lin byrokratisoitua_V = mkkV "byrokratisoitua" ;
lin bysanttilainen_N = mkkN "bysanttilainen" ;
lin bysanttilaisuus_N = mkkN "bysanttilaisuus" ;
lin byte_N = mkkN "byte" ;
lin ba'ndi_N = mkkN "bändi" ;
--? lin ba'net_NK = {s = d08 "bänet" ;
lin ba'nks_N = mkkN "bänks" ;
lin caddie_N = mkkN "caddie" ;
lin cafeteria_N = mkkN "cafeteria" ;
lin calvados_N = mkkN "calvados" ;
lin calypso_N = mkkN "calypso" ;
lin camembert_N = mkkN "camembert" ;
lin camping_N = mkkN "camping" ;
lin campus_N = mkkN "campus" ;
lin canasta_N = mkkN "canasta" ;
lin cancan_N = mkkN "cancan" ;
lin cannelloni_N = mkkN "cannelloni" ;
lin cappuccino_N = mkkN "cappuccino" ;
lin casanova_N = mkkN "casanova" ;
lin catering_N = mkkN "catering" ;
lin CD_Adv = mkkAdv "CD" ;
lin CD_ROM_N = mkkN "CD-ROM" ;
lin cembalo_N = mkkN "cembalo" ;
lin cesium_N = mkkN "cesium" ;
lin cha_cha_cha_N = mkkN "cha-cha-cha" ;
lin chanson_N = mkkN "chanson" ;
lin charleston_N = mkkN "charleston" ;
lin charlotte_russe_N = mkkN "charlottC" ;
lin charmantti_N = mkkN "charmantti" ;
lin charmi_N = mkkN "charmi" ;
lin charmikas_N = mkkN "charmikas" ;
lin charterlento_N = mkkN "charterlento" ;
lin chatata_V = mkkV "chatata" ;
lin chateaubriand_N = mkkN "chateaubriand" ;
lin ch_teauviini_N = mkkN "châteauviini" ;
lin chatti_N = mkkN "chatti" ;
lin cheddar_N = mkkN "cheddar" ;
lin cheerleader_N = mkkN "cheerleader" ;
lin chenille_N = mkkN "chenille" ;
lin chic_N = mkkN "chic" ;
lin chili_N = mkkN "chili" ;
lin chinchilla_N = mkkN "chinchilla" ;
lin chippendale_N = mkkN "chippendale" ;
lin chips_N = mkkN "chips" ;
lin cicero_N = mkkN "cicero" ;
lin cirrus_N = mkkN "cirrus" ;
lin city_N = mkkN "city" ;
lin civis_N = mkkN "civis" ;
lin clearing_N = mkkN "clearing" ;
lin clou_N = mkkN "clou" ;
lin cocktail_N = mkkN "cocktail" ;
lin college_N = mkkN "college" ;
lin collie_N = mkkN "collie" ;
lin come_back_N = mkkN "come-back" ;
lin contra_N = mkkN "contra" ;
lin copy_N = mkkN "copy" ;
lin copyright_N = mkkN "copyright" ;
lin copywriter_N = mkkN "copywriter" ;
lin coulombi_N = mkkN "coulombi" ;
lin country_N = mkkN "country" ;
lin coup__N = mkkN "coupé" ;
lin couscous_N = mkkN "couscous" ;
lin cowboy_N = mkkN "cowboy" ;
lin crack_N = mkkN "crack" ;
lin cr_me_fra_che_N = mkkN "crèmC" ;
lin cr_pe_N = mkkN "crêpe" ;
lin crescendo_N = mkkN "crescendo" ;
lin croissant_N = mkkN "croissant" ;
lin cs_rd_s_N = mkkN "csárdás" ;
lin cum_laude_N = mkkN "cuC" ;
lin cumulus_N = mkkN "cumulus" ;
lin cup_N = mkkN "cup" ;
lin curry_N = mkkN "curry" ;
lin daalia_N = mkkN "daalia" ;
lin daami_N = mkkN "daami" ;
lin dadaismi_N = mkkN "dadaismi" ;
lin dadaisti_N = mkkN "dadaisti" ;
lin dadaistinen_N = mkkN "dadaistinen" ;
lin daktyyli_N = mkkN "daktyyli" ;
lin dalai_lama_N = mkkN "dalai-lama" ;
lin damaski_N = mkkN "damaski" ;
lin damasti_N = mkkN "damasti" ;
lin dandy_N = mkkN "dandy" ;
lin darvinismi_N = mkkN "darvinismi" ;
lin darvinisti_N = mkkN "darvinisti" ;
lin darvinistinen_N = mkkN "darvinistinen" ;
lin data_N = mkkN "data" ;
lin datanomi_N = mkkN "datanomi" ;
lin dateerata_V = mkkV "dateerata" ;
lin dateeraus_N = mkkN "dateeraus" ;
lin datiivi_N = mkkN "datiivi" ;
lin dat_a_N = mkkN "datša" ;
lin deadline_N = mkkN "deadline" ;
lin dealer_N = mkkN "dealer" ;
lin debatti_N = mkkN "debatti" ;
lin debentuuri_N = mkkN "debentuuri" ;
lin debet_N = mkkN "debet" ;
lin debiili_N = mkkN "debiili" ;
lin debytantti_N = mkkN "debytantti" ;
lin debytoida_V = mkkV "debytoida" ;
lin debyytti_N = mkkN "debyytti" ;
lin deduktiivinen_A = mkkA "deduktiivinen" ;
lin deduktiivisesti_Adv = mkkAdv "deduktiivisesti" ;
lin deduktiivisuus_N = mkkN "deduktiivisuus" ;
lin deduktio_N = mkkN "deduktio" ;
lin deekikselle_Adv = mkkAdv "deekikselle" ;
lin deekiksella'_Adv = mkkAdv "deekiksellä" ;
lin deeku_N = mkkN "deeku" ;
lin defekti_N = mkkN "defekti" ;
lin defensiivinen_A = mkkA "defensiivinen" ;
lin defensiivisesti_Adv = mkkAdv "defensiivisesti" ;
lin defensiivisyys_N = mkkN "defensiivisyys" ;
lin definiittinen_A = mkkA "definiittinen" ;
lin definiittisesti_Adv = mkkAdv "definiittisesti" ;
lin definiittisyys_N = mkkN "definiittisyys" ;
lin definioida_V = mkkV "definioida" ;
lin definitiivinen_A = mkkA "definitiivinen" ;
lin definitiivisesti_Adv = mkkAdv "definitiivisesti" ;
lin definitiivisyys_N = mkkN "definitiivisyys" ;
lin definitio_N = mkkN "definitio" ;
lin deflaatio_N = mkkN "deflaatio" ;
lin deformaatio_N = mkkN "deformaatio" ;
lin degeneraatio_N = mkkN "degeneraatio" ;
lin degeneroitua_V = mkkV "degeneroitua" ;
lin deismi_N = mkkN "deismi" ;
lin deisti_N = mkkN "deisti" ;
lin deistinen_N = mkkN "deistinen" ;
lin dekaani_1_N = mkkN "dekaani" ;
lin dekaani_2_N = mkkN "dekaani" ;
lin dekadenssi_N = mkkN "dekadenssi" ;
lin dekadentisti_Adv = mkkAdv "dekadentisti" ;
lin dekadentti_N = mkkN "dekadentti" ;
lin dekantoida_V = mkkV "dekantoida" ;
lin dekantointi_N = mkkN "dekantointi" ;
lin dekantteri_N = mkkN "dekantteri" ;
lin dekkari_N = mkkN "dekkari" ;
lin dekki_N = mkkN "dekki" ;
lin deklinaatio_N = mkkN "deklinaatio" ;
lin dekoltee_N = mkkN "dekoltee" ;
lin dekoodata_V = mkkV "dekoodata" ;
lin dekoodaus_N = mkkN "dekoodaus" ;
lin dekooderi_N = mkkN "dekooderi" ;
lin dekoraatio_N = mkkN "dekoraatio" ;
lin dekoratiivinen_A = mkkA "dekoratiivinen" ;
lin dekoratiivisesti_Adv = mkkAdv "dekoratiivisesti" ;
lin dekoratiivisuus_N = mkkN "dekoratiivisuus" ;
lin delata_V = mkkV "delata" ;
lin delegaatio_N = mkkN "delegaatio" ;
lin delegaatti_N = mkkN "delegaatti" ;
lin delegoida_V = mkkV "delegoida" ;
lin delegointi_N = mkkN "delegointi" ;
lin delfiini_N = mkkN "delfiini" ;
lin delfinaario_N = mkkN "delfinaario" ;
lin delta_N = mkkN "delta" ;
lin demagnetoida_V = mkkV "demagnetoida" ;
lin demagnetointi_N = mkkN "demagnetointi" ;
lin demagogi_N = mkkN "demagogi" ;
lin demagogia_N = mkkN "demagogia" ;
lin demagoginen_A = mkkA "demagoginen" ;
lin demagogisesti_Adv = mkkAdv "demagogisesti" ;
lin demagogisuus_N = mkkN "demagogisuus" ;
lin demari_N = mkkN "demari" ;
lin dementia_N = mkkN "dementia" ;
lin dementikko_N = mkkN "dementikko" ;
lin dementoida_V = mkkV "dementoida" ;
lin dementointi_N = mkkN "dementointi" ;
lin dementoitua_V = mkkV "dementoitua" ;
lin dementti_N = mkkN "dementti" ;
lin demilitarisoida_V = mkkV "demilitarisoida" ;
lin demilitarisointi_N = mkkN "demilitarisointi" ;
lin deminutiivi_N = mkkN "deminutiivi" ;
lin deminutiivinen_N = mkkN "deminutiivinen" ;
lin demo_N = mkkN "demo" ;
lin demobilisaatio_N = mkkN "demobilisaatio" ;
lin demobilisoida_V = mkkV "demobilisoida" ;
lin demobilisointi_N = mkkN "demobilisointi" ;
lin demografi_N = mkkN "demografi" ;
lin demografia_N = mkkN "demografia" ;
lin demografinen_A = mkkA "demografinen" ;
lin demografisesti_Adv = mkkAdv "demografisesti" ;
lin demokraatti_N = mkkN "demokraatti" ;
lin demokraattinen_A = mkkA "demokraattinen" ;
lin demokraattisesti_Adv = mkkAdv "demokraattisesti" ;
lin demokraattistaa_V = mkkV "demokraattistaa" ;
lin demokraattistua_V = mkkV "demokraattistua" ;
lin demokraattisuus_N = mkkN "demokraattisuus" ;
lin demokratia_N = mkkN "demokratia" ;
lin demokratisoida_V = mkkV "demokratisoida" ;
lin demokratisointi_N = mkkN "demokratisointi" ;
lin demokratisoitua_V = mkkV "demokratisoitua" ;
lin demoni_N = mkkN "demoni" ;
lin demoninen_A = mkkA "demoninen" ;
lin demonisesti_Adv = mkkAdv "demonisesti" ;
lin demonisuus_N = mkkN "demonisuus" ;
lin demonstraatio_N = mkkN "demonstraatio" ;
lin demonstratiivinen_A = mkkA "demonstratiivinen" ;
lin demonstratiivisesti_Adv = mkkAdv "demonstratiivisesti" ;
lin demonstratiivisuus_N = mkkN "demonstratiivisuus" ;
lin demonstroida_V = mkkV "demonstroida" ;
lin demonstrointi_N = mkkN "demonstrointi" ;
lin demoralisoida_V = mkkV "demoralisoida" ;
lin demoralisointi_N = mkkN "demoralisointi" ;
lin demoralisoitua_V = mkkV "demoralisoitua" ;
lin denaturoida_V = mkkV "denaturoida" ;
lin denaturointi_N = mkkN "denaturointi" ;
lin denier_N = mkkN "denier" ;
lin denimi_N = mkkN "denimi" ;
lin deodorantti_N = mkkN "deodorantti" ;
lin depis_N = mkkN "depis" ;
lin deponoida_V = mkkV "deponoida" ;
lin deponointi_N = mkkN "deponointi" ;
lin depressiivinen_A = mkkA "depressiivinen" ;
lin depressiivisesti_Adv = mkkAdv "depressiivisesti" ;
lin depressiivisyys_N = mkkN "depressiivisyys" ;
lin depressio_N = mkkN "depressio" ;
lin derivaatta_N = mkkN "derivaatta" ;
lin derivoida_V = mkkV "derivoida" ;
lin derivointi_N = mkkN "derivointi" ;
lin dermatologi_N = mkkN "dermatologi" ;
lin dermatologia_N = mkkN "dermatologia" ;
lin dermatologinen_A = mkkA "dermatologinen" ;
lin dermatologisesti_Adv = mkkAdv "dermatologisesti" ;
lin desantti_N = mkkN "desantti" ;
lin desentralisaatio_N = mkkN "desentralisaatio" ;
lin desentralisoida_V = mkkV "desentralisoida" ;
lin desentralisointi_N = mkkN "desentralisointi" ;
lin desi_N = mkkN "desi" ;
lin desibeli_N = mkkN "desibeli" ;
lin design_N = mkkN "design" ;
lin designer_N = mkkN "designer" ;
lin desinfektio_N = mkkN "desinfektio" ;
lin desinfektoida_V = mkkV "desinfektoida" ;
lin desinfektointi_N = mkkN "desinfektointi" ;
lin desinfioida_V = mkkV "desinfioida" ;
lin desinfiointi_N = mkkN "desinfiointi" ;
lin deskriptiivinen_A = mkkA "deskriptiivinen" ;
lin deskriptiivisesti_Adv = mkkAdv "deskriptiivisesti" ;
lin deskriptiivisyys_N = mkkN "deskriptiivisyys" ;
lin deskriptio_N = mkkN "deskriptio" ;
lin desktop_publishing_N = mkkN "desktoC" ;
lin despootti_N = mkkN "despootti" ;
lin despoottinen_A = mkkA "despoottinen" ;
lin despoottisesti_Adv = mkkAdv "despoottisesti" ;
lin despoottisuus_N = mkkN "despoottisuus" ;
lin despotia_N = mkkN "despotia" ;
lin despotismi_N = mkkN "despotismi" ;
lin detalji_N = mkkN "detalji" ;
lin detektori_N = mkkN "detektori" ;
lin determinismi_N = mkkN "determinismi" ;
lin deterministinen_A = mkkA "deterministinen" ;
lin deterministisesti_Adv = mkkAdv "deterministisesti" ;
lin deuterium_N = mkkN "deuterium" ;
lin devalvaatio_N = mkkN "devalvaatio" ;
lin devalvoida_V = mkkV "devalvoida" ;
lin devalvointi_N = mkkN "devalvointi" ;
lin devalvoitua_V = mkkV "devalvoitua" ;
lin deviaatio_N = mkkN "deviaatio" ;
lin dia_N = mkkN "dia" ;
lin diaari_N = mkkN "diaari" ;
lin diaario_N = mkkN "diaario" ;
lin diabeetikko_N = mkkN "diabeetikko" ;
lin diabetes_N = mkkN "diabetes" ;
lin diadeemi_N = mkkN "diadeemi" ;
lin diagnoosi_N = mkkN "diagnoosi" ;
lin diagnosoida_V = mkkV "diagnosoida" ;
lin diagnosointi_N = mkkN "diagnosointi" ;
lin diagnostiikka_N = mkkN "diagnostiikka" ;
lin diagnostinen_A = mkkA "diagnostinen" ;
lin diagnostisesti_Adv = mkkAdv "diagnostisesti" ;
lin diagnostisuus_N = mkkN "diagnostisuus" ;
lin diagonaali_N = mkkN "diagonaali" ;
lin diagrammi_N = mkkN "diagrammi" ;
lin diakonia_N = mkkN "diakonia" ;
lin diakoninen_N = mkkN "diakoninen" ;
lin diakonissa_N = mkkN "diakonissa" ;
lin dialektiikka_N = mkkN "dialektiikka" ;
lin dialektinen_A = mkkA "dialektinen" ;
lin dialektisesti_Adv = mkkAdv "dialektisesti" ;
lin dialogi_N = mkkN "dialogi" ;
lin dialyysi_N = mkkN "dialyysi" ;
lin diarioida_V = mkkV "diarioida" ;
lin diariointi_N = mkkN "diariointi" ;
lin diastolinen_N = mkkN "diastolinen" ;
lin diatoninen_N = mkkN "diatoninen" ;
lin diatsepaami_N = mkkN "diatsepaami" ;
lin didaktiikka_N = mkkN "didaktiikka" ;
lin didaktinen_A = mkkA "didaktinen" ;
lin didaktisesti_Adv = mkkAdv "didaktisesti" ;
lin dieetti_N = mkkN "dieetti" ;
lin diesel_N = mkkN "diesel" ;
lin dieselo'ida'_V = mkkV "dieselöidä" ;
lin dieselo'inti_N = mkkN "dieselöinti" ;
lin dieteetikko_N = mkkN "dieteetikko" ;
lin dietetiikka_N = mkkN "dietetiikka" ;
lin differentiaali_N = mkkN "differentiaali" ;
lin differentioida_V = mkkV "differentioida" ;
lin differentiointi_N = mkkN "differentiointi" ;
lin differentioitua_V = mkkV "differentioitua" ;
lin diffraktio_N = mkkN "diffraktio" ;
lin diffuusi_N = mkkN "diffuusi" ;
lin diffuusio_N = mkkN "diffuusio" ;
lin diftongi_N = mkkN "diftongi" ;
lin digata_V = mkkV "digata" ;
lin digitaalinen_A = mkkA "digitaalinen" ;
lin digitaalisesti_Adv = mkkAdv "digitaalisesti" ;
lin digitaalistaa_V = mkkV "digitaalistaa" ;
lin digitaalistua_V = mkkV "digitaalistua" ;
lin digitaalisuus_N = mkkN "digitaalisuus" ;
lin digitalis_N = mkkN "digitalis" ;
lin digitalisoida_V = mkkV "digitalisoida" ;
lin digitalisointi_N = mkkN "digitalisointi" ;
lin digitoida_V = mkkV "digitoida" ;
lin diileri_N = mkkN "diileri" ;
lin diiva_N = mkkN "diiva" ;
lin diivailla_V = mkkV "diivailla" ;
lin diivailu_N = mkkN "diivailu" ;
lin diivata_V = mkkV "diivata" ;
lin diktaattori_N = mkkN "diktaattori" ;
lin diktatorinen_A = mkkA "diktatorinen" ;
lin diktatorisesti_Adv = mkkAdv "diktatorisesti" ;
lin diktatorisuus_N = mkkN "diktatorisuus" ;
lin diktatuuri_N = mkkN "diktatuuri" ;
lin dilemma_N = mkkN "dilemma" ;
lin diletantismi_N = mkkN "diletantismi" ;
lin diletantti_N = mkkN "diletantti" ;
lin dimensio_N = mkkN "dimensio" ;
lin diminuendo_N = mkkN "diminuendo" ;
lin diminutiivi_N = mkkN "diminutiivi" ;
lin diminutiivinen_N = mkkN "diminutiivinen" ;
lin dinosaurus_N = mkkN "dinosaurus" ;
lin diodi_N = mkkN "diodi" ;
lin dioksiini_N = mkkN "dioksiini" ;
lin diopteri_N = mkkN "diopteri" ;
lin dioptria_N = mkkN "dioptria" ;
lin dipata_V = mkkV "dipata" ;
lin diploidi_N = mkkN "diploidi" ;
lin diploidinen_N = mkkN "diploidinen" ;
lin diplomaatti_N = mkkN "diplomaatti" ;
lin diplomaattinen_N = mkkN "diplomaattinen" ;
lin diplomaattisuus_N = mkkN "diplomaattisuus" ;
lin diplomatia_N = mkkN "diplomatia" ;
lin diplomi_N = mkkN "diplomi" ;
lin dipoli_N = mkkN "dipoli" ;
lin dippaus_N = mkkN "dippaus" ;
lin dippi_N = mkkN "dippi" ;
lin director_cantus_N = mkkN "directoC" ;
lin director_musices_N = mkkN "directoC" ;
lin direktiivi_N = mkkN "direktiivi" ;
lin direktoraatti_N = mkkN "direktoraatti" ;
lin dirhami_N = mkkN "dirhami" ;
lin disinformaatio_N = mkkN "disinformaatio" ;
lin disjunktiivinen_N = mkkN "disjunktiivinen" ;
lin diskantti_N = mkkN "diskantti" ;
lin diskata_V = mkkV "diskata" ;
lin diskaus_N = mkkN "diskaus" ;
lin disketti_N = mkkN "disketti" ;
lin disko_N = mkkN "disko" ;
lin diskografia_N = mkkN "diskografia" ;
lin diskontata_V = mkkV "diskontata" ;
lin diskonttaus_N = mkkN "diskonttaus" ;
lin diskontto_N = mkkN "diskontto" ;
lin diskota_V = mkkV "diskota" ;
lin diskoteekki_N = mkkN "diskoteekki" ;
lin diskriminaatio_N = mkkN "diskriminaatio" ;
lin diskriminoida_V = mkkV "diskriminoida" ;
lin diskriminointi_N = mkkN "diskriminointi" ;
lin diskurssi_N = mkkN "diskurssi" ;
lin diskvalifioida_V = mkkV "diskvalifioida" ;
lin diskvalifiointi_N = mkkN "diskvalifiointi" ;
lin disponibiliteetti_N = mkkN "disponibiliteetti" ;
lin dispositio_N = mkkN "dispositio" ;
lin dissidentti_N = mkkN "dissidentti" ;
lin dissonanssi_N = mkkN "dissonanssi" ;
lin dissonoida_V = mkkV "dissonoida" ;
lin distikon_N = mkkN "distikon" ;
lin distribuutio_N = mkkN "distribuutio" ;
lin diureetti_N = mkkN "diureetti" ;
lin diureettinen_N = mkkN "diureettinen" ;
lin divaani_N = mkkN "divaani" ;
lin divari_N = mkkN "divari" ;
lin divisioona_N = mkkN "divisioona" ;
lin dixieland_N = mkkN "dixieland" ;
lin DNA_Adv = mkkAdv "DNA" ;
lin dobermanni_N = mkkN "dobermanni" ;
lin dogmaatikko_N = mkkN "dogmaatikko" ;
lin dogmaattinen_A = mkkA "dogmaattinen" ;
lin dogmaattisesti_Adv = mkkAdv "dogmaattisesti" ;
lin dogmaattisuus_N = mkkN "dogmaattisuus" ;
lin dogmatiikka_N = mkkN "dogmatiikka" ;
lin dogmi_N = mkkN "dogmi" ;
lin dokata_V = mkkV "dokata" ;
lin dokaus_N = mkkN "dokaus" ;
lin doktriini_N = mkkN "doktriini" ;
lin doku_N = mkkN "doku" ;
lin dokumentaarinen_N = mkkN "dokumentaarinen" ;
lin dokumentaatio_N = mkkN "dokumentaatio" ;
lin dokumentoida_V = mkkV "dokumentoida" ;
lin dokumentointi_N = mkkN "dokumentointi" ;
lin dokumentti_N = mkkN "dokumentti" ;
lin dollari_N = mkkN "dollari" ;
lin dolomiitti_N = mkkN "dolomiitti" ;
lin dominanssi_N = mkkN "dominanssi" ;
lin dominantisti_Adv = mkkAdv "dominantisti" ;
lin dominantti_N = mkkN "dominantti" ;
lin dominikaani_N = mkkN "dominikaani" ;
lin dominio_N = mkkN "dominio" ;
lin domino_N = mkkN "domino" ;
lin dominoida_V = mkkV "dominoida" ;
lin dominointi_N = mkkN "dominointi" ;
--? lin dongarit_NK = {s = d06 "dongarit" ;
lin donitsi_N = mkkN "donitsi" ;
lin donjuan_N = mkkN "donjuan" ;
lin donkata_V = mkkV "donkata" ;
lin donkkaus_N = mkkN "donkkaus" ;
lin donna_N = mkkN "donna" ;
lin doorilainen_N = mkkN "doorilainen" ;
lin doping_N = mkkN "doping" ;
lin dorka_A = mkkA "dorka" ;
lin dorkasti_Adv = mkkAdv "dorkasti" ;
lin dosentti_N = mkkN "dosentti" ;
lin dosentuuri_N = mkkN "dosentuuri" ;
lin dosetti_N = mkkN "dosetti" ;
lin dosimetri_N = mkkN "dosimetri" ;
lin doula_N = mkkN "doula" ;
lin doupata_V = mkkV "doupata" ;
lin draama_N = mkkN "draama" ;
lin draamallinen_A = mkkA "draamallinen" ;
lin draamallisesti_Adv = mkkAdv "draamallisesti" ;
lin draamallisuus_N = mkkN "draamallisuus" ;
lin drag_racing_N = mkkN "draC" ;
lin dragsteri_N = mkkN "dragsteri" ;
lin drakma_N = mkkN "drakma" ;
lin dralon_N = mkkN "dralon" ;
lin dramaatikko_N = mkkN "dramaatikko" ;
lin dramaattinen_A = mkkA "dramaattinen" ;
lin dramaattisesti_Adv = mkkAdv "dramaattisesti" ;
lin dramaattisuus_N = mkkN "dramaattisuus" ;
lin dramatiikka_N = mkkN "dramatiikka" ;
lin dramatisoida_V = mkkV "dramatisoida" ;
lin dramatisointi_N = mkkN "dramatisointi" ;
lin dramaturgi_N = mkkN "dramaturgi" ;
lin dramaturgia_N = mkkN "dramaturgia" ;
lin drapeerata_V = mkkV "drapeerata" ;
lin drapeeraus_N = mkkN "drapeeraus" ;
lin drastinen_A = mkkA "drastinen" ;
lin drastisesti_Adv = mkkAdv "drastisesti" ;
lin drastisuus_N = mkkN "drastisuus" ;
lin dreeveri_N = mkkN "dreeveri" ;
lin dreija_N = mkkN "dreija" ;
lin dreijata_V = mkkV "dreijata" ;
lin dreijaus_N = mkkN "dreijaus" ;
lin drilli_N = mkkN "drilli" ;
lin drinkki_N = mkkN "drinkki" ;
lin drive_in_N = mkkN "drive-in" ;
lin dromedaari_N = mkkN "dromedaari" ;
lin druidi_N = mkkN "druidi" ;
lin druusi_N = mkkN "druusi" ;
lin dualismi_N = mkkN "dualismi" ;
lin dualistinen_A = mkkA "dualistinen" ;
lin dualistisesti_Adv = mkkAdv "dualistisesti" ;
lin dualistisuus_N = mkkN "dualistisuus" ;
lin dubata_V = mkkV "dubata" ;
lin dubbata_V = mkkV "dubbata" ;
lin dubbaus_N = mkkN "dubbaus" ;
lin dublee_N = mkkN "dublee" ;
lin dubletti_N = mkkN "dubletti" ;
lin duchesse_N = mkkN "duchesse" ;
lin duetto_N = mkkN "duetto" ;
lin duffeli_N = mkkN "duffeli" ;
lin dumpata_V = mkkV "dumpata" ;
lin dumping_N = mkkN "dumping" ;
lin dumppaus_N = mkkN "dumppaus" ;
lin duo_N = mkkN "duo" ;
lin dupletti_N = mkkN "dupletti" ;
lin duplikaatti_N = mkkN "duplikaatti" ;
lin duralumiini_N = mkkN "duralumiini" ;
lin durra_N = mkkN "durra" ;
lin duuma_N = mkkN "duuma" ;
lin duunari_N = mkkN "duunari" ;
lin duunata_V = mkkV "duunata" ;
lin duunaus_N = mkkN "duunaus" ;
lin duuni_N = mkkN "duuni" ;
lin duuri_N = mkkN "duuri" ;
lin dynaaminen_A = mkkA "dynaaminen" ;
lin dynaamisesti_Adv = mkkAdv "dynaamisesti" ;
lin dynaamisuus_N = mkkN "dynaamisuus" ;
lin dynamiikka_N = mkkN "dynamiikka" ;
lin dynamiitti_N = mkkN "dynamiitti" ;
lin dynamo_N = mkkN "dynamo" ;
lin dynastia_N = mkkN "dynastia" ;
lin dysfasia_N = mkkN "dysfasia" ;
lin dyyni_N = mkkN "dyyni" ;
lin d_onkki_N = mkkN "džonkki" ;
lin do'do'_N = mkkN "dödö" ;
lin do'sa'_N = mkkN "dösä" ;
lin eau_de_Cologne_N = mkkN "eaC" ;
lin eboniitti_N = mkkN "eboniitti" ;
lin ecu_N = mkkN "ecu" ;
lin edam_N = mkkN "edam" ;
lin edelle_Adv = mkkAdv "edelle" ;
lin edelleen_Adv = mkkAdv "edelleen" ;
lin edellinen_N = mkkN "edellinen" ;
lin edellytta'a'_V = mkkV "edellyttää" ;
lin edellytys_N = mkkN "edellytys" ;
lin edella'_Adv = mkkAdv "edellä" ;
lin edella'_esitetty_N = mkkN "edellC" ;
lin edella'_mainittu_N = mkkN "edellC" ;
lin edelta'_Adv = mkkAdv "edeltä" ;
lin edelta'ja'_N = mkkN "edeltäjä" ;
lin edelta'a'_V = mkkV "edeltää" ;
lin edelweiss_N = mkkN "edelweiss" ;
lin edemma'_Adv = mkkAdv "edemmä" ;
lin edemma'ksi_Adv = mkkAdv "edemmäksi" ;
lin edemma's_Adv = mkkAdv "edemmäs" ;
lin edempa'na'_Adv = mkkAdv "edempänä" ;
lin edempa'a'_Adv = mkkAdv "edempää" ;
lin edes_Adv = mkkAdv "edes" ;
lin edesottamus_N = mkkN "edesottamus" ;
lin edessa'_Adv = mkkAdv "edessä" ;
lin edesta'_Adv = mkkAdv "edestä" ;
lin edeta'_V = mkkV "edetä" ;
lin edikti_N = mkkN "edikti" ;
lin edistyksellinen_A = mkkA "edistyksellinen" ;
lin edistyksellisesti_Adv = mkkAdv "edistyksellisesti" ;
lin edistyksellisyys_N = mkkN "edistyksellisyys" ;
lin edistyneisyys_N = mkkN "edistyneisyys" ;
lin edistys_N = mkkN "edistys" ;
lin edistya'_V = mkkV "edistyä" ;
lin edista'ja'_N = mkkN "edistäjä" ;
lin edista'a'_V = mkkV "edistää" ;
lin editio_N = mkkN "editio" ;
lin editoida_V = mkkV "editoida" ;
lin editointi_N = mkkN "editointi" ;
lin editori_N = mkkN "editori" ;
lin editse_Adv = mkkAdv "editse" ;
lin edukas_N = mkkN "edukas" ;
lin edullinen_A = mkkA "edullinen" ;
lin edullisesti_Adv = mkkAdv "edullisesti" ;
lin edullisuus_N = mkkN "edullisuus" ;
lin edus_N = mkkN "edus" ;
lin edusta_N = mkkN "edusta" ;
lin edustaa_V = mkkV "edustaa" ;
lin edustaja_N = mkkN "edustaja" ;
lin edustajisto_N = mkkN "edustajisto" ;
lin edustajuus_N = mkkN "edustajuus" ;
lin edustava_A = mkkA "edustava" ;
lin edustavasti_Adv = mkkAdv "edustavasti" ;
lin edustavuus_N = mkkN "edustavuus" ;
lin edusteilla_Adv = mkkAdv "edusteilla" ;
lin edustua_V = mkkV "edustua" ;
lin edustuksellinen_N = mkkN "edustuksellinen" ;
lin edustus_N = mkkN "edustus" ;
lin edustusto_N = mkkN "edustusto" ;
lin eebenholtsi_N = mkkN "eebenholtsi" ;
lin eeden_N = mkkN "eeden" ;
lin eekkeri_N = mkkN "eekkeri" ;
lin eepikko_N = mkkN "eepikko" ;
lin eepos_N = mkkN "eepos" ;
lin eeppinen_N = mkkN "eeppinen" ;
lin eesti_N = mkkN "eesti" ;
lin eestila'inen_N = mkkN "eestiläinen" ;
lin eetteri_N = mkkN "eetteri" ;
lin eettinen_A = mkkA "eettinen" ;
lin eettisesti_Adv = mkkAdv "eettisesti" ;
lin eettisyys_N = mkkN "eettisyys" ;
lin eetvartti_N = mkkN "eetvartti" ;
lin eeva_N = mkkN "eeva" ;
lin efekti_N = mkkN "efekti" ;
lin efektiivinen_A = mkkA "efektiivinen" ;
lin efektiivisesti_Adv = mkkAdv "efektiivisesti" ;
lin efektiivisyys_N = mkkN "efektiivisyys" ;
lin ego_N = mkkN "ego" ;
lin egoisti_N = mkkN "egoisti" ;
lin egoistinen_A = mkkA "egoistinen" ;
lin egoistisesti_Adv = mkkAdv "egoistisesti" ;
lin egoistisuus_N = mkkN "egoistisuus" ;
lin egosentrinen_A = mkkA "egosentrinen" ;
lin egosentrisesti_Adv = mkkAdv "egosentrisesti" ;
lin egosentrisyys_N = mkkN "egosentrisyys" ;
lin egyptila'inen_N = mkkN "egyptiläinen" ;
lin egyptologi_N = mkkN "egyptologi" ;
lin egyptologia_N = mkkN "egyptologia" ;
lin egyptologinen_N = mkkN "egyptologinen" ;
lin ehdoin_tahdoin_Adv = mkkAdv "ehdoiC" ;
lin ehdokas_N = mkkN "ehdokas" ;
lin ehdokkuus_N = mkkN "ehdokkuus" ;
lin ehdollinen_A = mkkA "ehdollinen" ;
lin ehdollisesti_Adv = mkkAdv "ehdollisesti" ;
lin ehdollistaa_V = mkkV "ehdollistaa" ;
lin ehdollistua_V = mkkV "ehdollistua" ;
lin ehdollisuus_N = mkkN "ehdollisuus" ;
lin ehdotella_V = mkkV "ehdotella" ;
lin ehdotelma_N = mkkN "ehdotelma" ;
lin ehdoton_N = mkkN "ehdoton" ;
lin ehdottaa_V = mkkV "ehdottaa" ;
lin ehdottaja_N = mkkN "ehdottaja" ;
lin ehdottomasti_Adv = mkkAdv "ehdottomasti" ;
lin ehdottomuus_N = mkkN "ehdottomuus" ;
lin ehdotus_N = mkkN "ehdotus" ;
lin ehdyksiin_Adv = mkkAdv "ehdyksiin" ;
lin ehdyksissa'_Adv = mkkAdv "ehdyksissä" ;
lin ehdytta'a'_V = mkkV "ehdyttää" ;
lin ehei_Adv = mkkAdv "ehei" ;
lin eheys_N = mkkN "eheys" ;
lin eheytta'a'_V = mkkV "eheyttää" ;
lin eheytys_N = mkkN "eheytys" ;
lin eheytya'_V = mkkV "eheytyä" ;
lin ehea'_A = mkkA "eheä" ;
lin ehea'sti_Adv = mkkAdv "eheästi" ;
lin ehio'_N = mkkN "ehiö" ;
lin ehjyys_N = mkkN "ehjyys" ;
lin ehja'_A = mkkA "ehjä" ;
lin ehja'sti_Adv = mkkAdv "ehjästi" ;
lin ehken_Adv = mkkAdv "ehken" ;
lin ehka'_Adv = mkkAdv "ehkä" ;
lin ehka'isija'_N = mkkN "ehkäisijä" ;
lin ehka'isin_N = mkkN "ehkäisin" ;
lin ehka'istya'_V = mkkV "ehkäistyä" ;
lin ehka'ista'_V = mkkV "ehkäistä" ;
lin ehka'isy_N = mkkN "ehkäisy" ;
lin ehommin_Adv = mkkAdv "ehommin" ;
lin ehompi_N = mkkN "ehompi" ;
lin ehostaa_V = mkkV "ehostaa" ;
lin ehoste_N = mkkN "ehoste" ;
lin ehostus_N = mkkN "ehostus" ;
lin ehta_N = mkkN "ehta" ;
lin ehtimiseen_Adv = mkkAdv "ehtimiseen" ;
lin ehtia'_V = mkkV "ehtiä" ;
lin ehto_N = mkkN "ehto" ;
lin ehtoinen_A = mkkA "ehtoinen" ;
lin ehtoisa_N = mkkN "ehtoisa" ;
lin ehtoisesti_Adv = mkkAdv "ehtoisesti" ;
lin ehtoisuus_N = mkkN "ehtoisuus" ;
lin ehtoo_N = mkkN "ehtoo" ;
lin ehtoollinen_N = mkkN "ehtoollinen" ;
lin ehtoolliskalkki_N = mkkN "ehtoolliskalkki" ;
lin ehtoollisviini_N = mkkN "ehtoollisviini" ;
lin ehtyma'to'n_N = mkkN "ehtymätön" ;
lin ehtya'_V = mkkV "ehtyä" ;
lin ehyt_N = mkkN "ehyt" ;
lin eha'tta'a'_V = mkkV "ehättää" ;
lin ei_Adv = mkkAdv "ei" ;
lin eideetikko_N = mkkN "eideetikko" ;
lin eideettinen_N = mkkN "eideettinen" ;
lin ei_kenenka'a'n_maa_N = mkkN "ei-kenenkään-maa" ;
lin eilen_Adv = mkkAdv "eilen" ;
lin eilinen_N = mkkN "eilinen" ;
lin eine_N = mkkN "eine" ;
lin eines_N = mkkN "eines" ;
lin eioo_Adv = mkkAdv "eioo" ;
lin eitta'ma'tta'_Adv = mkkAdv "eittämättä" ;
lin eitta'ma'to'n_N = mkkN "eittämätön" ;
lin ejakulaatio_N = mkkN "ejakulaatio" ;
lin eka_N = mkkN "eka" ;
lin ekliptika_N = mkkN "ekliptika" ;
lin ekologi_N = mkkN "ekologi" ;
lin ekologia_N = mkkN "ekologia" ;
lin ekologinen_A = mkkA "ekologinen" ;
lin ekologisesti_Adv = mkkAdv "ekologisesti" ;
lin ekonometria_N = mkkN "ekonometria" ;
lin ekonometrinen_A = mkkA "ekonometrinen" ;
lin ekonometrisesti_Adv = mkkAdv "ekonometrisesti" ;
lin ekonomi_N = mkkN "ekonomi" ;
lin ekonomia_N = mkkN "ekonomia" ;
lin ekonominen_A = mkkA "ekonominen" ;
lin ekonomisesti_Adv = mkkAdv "ekonomisesti" ;
lin ekonomisti_N = mkkN "ekonomisti" ;
lin ekonomisuus_N = mkkN "ekonomisuus" ;
lin eksakti_A = mkkA "eksakti" ;
lin eksaktisti_Adv = mkkAdv "eksaktisti" ;
lin eksaktius_N = mkkN "eksaktius" ;
lin ekseema_N = mkkN "ekseema" ;
lin eksegetiikka_N = mkkN "eksegetiikka" ;
lin eksemplaari_N = mkkN "eksemplaari" ;
lin eksentrinen_A = mkkA "eksentrinen" ;
lin eksentrisesti_Adv = mkkAdv "eksentrisesti" ;
lin eksentrisyys_N = mkkN "eksentrisyys" ;
lin ekshibitionismi_N = mkkN "ekshibitionismi" ;
lin ekshibitionisti_N = mkkN "ekshibitionisti" ;
lin ekshibitionistinen_N = mkkN "ekshibitionistinen" ;
lin eksisteerata_V = mkkV "eksisteerata" ;
lin eksistenssi_N = mkkN "eksistenssi" ;
lin eksistentiaalinen_N = mkkN "eksistentiaalinen" ;
lin eksistentialismi_N = mkkN "eksistentialismi" ;
lin eksistentialisti_N = mkkN "eksistentialisti" ;
lin eksistentialistinen_N = mkkN "eksistentialistinen" ;
lin eksistoida_V = mkkV "eksistoida" ;
lin eksklusiivinen_N = mkkN "eksklusiivinen" ;
lin eksklusiivisuus_N = mkkN "eksklusiivisuus" ;
lin ekskursio_N = mkkN "ekskursio" ;
lin ekskurssi_N = mkkN "ekskurssi" ;
lin eksogeeninen_N = mkkN "eksogeeninen" ;
lin eksogeenisuus_N = mkkN "eksogeenisuus" ;
lin eksoottinen_A = mkkA "eksoottinen" ;
lin eksoottisesti_Adv = mkkAdv "eksoottisesti" ;
lin eksoottisuus_N = mkkN "eksoottisuus" ;
lin eksotiikka_N = mkkN "eksotiikka" ;
lin ekspansiivinen_A = mkkA "ekspansiivinen" ;
lin ekspansiivisesti_Adv = mkkAdv "ekspansiivisesti" ;
lin ekspansiivisuus_N = mkkN "ekspansiivisuus" ;
lin ekspansio_N = mkkN "ekspansio" ;
lin ekspatriaatti_N = mkkN "ekspatriaatti" ;
lin eksperimentaalinen_N = mkkN "eksperimentaalinen" ;
lin ekspertti_N = mkkN "ekspertti" ;
lin eksplisiittinen_A = mkkA "eksplisiittinen" ;
lin eksplisiittisesti_Adv = mkkAdv "eksplisiittisesti" ;
lin eksplisiittisyys_N = mkkN "eksplisiittisyys" ;
lin eksponentiaalinen_A = mkkA "eksponentiaalinen" ;
lin eksponentiaalisesti_Adv = mkkAdv "eksponentiaalisesti" ;
lin eksponentiaalisuus_N = mkkN "eksponentiaalisuus" ;
lin eksponentti_N = mkkN "eksponentti" ;
lin ekspressiivinen_A = mkkA "ekspressiivinen" ;
lin ekspressiivisesti_Adv = mkkAdv "ekspressiivisesti" ;
lin ekspressiivisyys_N = mkkN "ekspressiivisyys" ;
lin ekspressionismi_N = mkkN "ekspressionismi" ;
lin ekspressionisti_N = mkkN "ekspressionisti" ;
lin ekspressionistinen_N = mkkN "ekspressionistinen" ;
lin ekstaasi_N = mkkN "ekstaasi" ;
lin ekstaattinen_A = mkkA "ekstaattinen" ;
lin ekstaattisesti_Adv = mkkAdv "ekstaattisesti" ;
lin ekstaattisuus_N = mkkN "ekstaattisuus" ;
lin ekstra_N = mkkN "ekstra" ;
lin ekstrakti_N = mkkN "ekstrakti" ;
lin ekstranet_N = mkkN "ekstranet" ;
lin ekstrovertti_N = mkkN "ekstrovertti" ;
lin eksykki_N = mkkN "eksykki" ;
lin eksyksiin_Adv = mkkAdv "eksyksiin" ;
lin eksyksissa'_Adv = mkkAdv "eksyksissä" ;
lin eksyksista'_Adv = mkkAdv "eksyksistä" ;
lin eksymys_N = mkkN "eksymys" ;
lin eksyma'_N = mkkN "eksymä" ;
lin eksytta'a'_V = mkkV "eksyttää" ;
lin eksytys_N = mkkN "eksytys" ;
lin eksya'_V = mkkV "eksyä" ;
lin ekumeeninen_A = mkkA "ekumeeninen" ;
lin ekumeenisesti_Adv = mkkAdv "ekumeenisesti" ;
lin ekumeenisuus_N = mkkN "ekumeenisuus" ;
lin ekumenia_N = mkkN "ekumenia" ;
lin ekvaattori_N = mkkN "ekvaattori" ;
lin ekvivalenssi_N = mkkN "ekvivalenssi" ;
lin ekvivalentti_N = mkkN "ekvivalentti" ;
lin ekvivalenttinen_N = mkkN "ekvivalenttinen" ;
lin elanto_N = mkkN "elanto" ;
lin elastinen_A = mkkA "elastinen" ;
lin elastisesti_Adv = mkkAdv "elastisesti" ;
lin elastisuus_N = mkkN "elastisuus" ;
lin elatiivi_N = mkkN "elatiivi" ;
lin elatus_N = mkkN "elatus" ;
lin eldorado_N = mkkN "eldorado" ;
lin ele_N = mkkN "ele" ;
lin eleetto'myys_N = mkkN "eleettömyys" ;
lin eleetto'ma'sti_Adv = mkkAdv "eleettömästi" ;
lin eleeto'n_N = mkkN "eleetön" ;
lin elefantti_N = mkkN "elefantti" ;
lin eleganssi_N = mkkN "eleganssi" ;
lin elegantisti_Adv = mkkAdv "elegantisti" ;
lin elegantti_N = mkkN "elegantti" ;
lin eleganttius_N = mkkN "eleganttius" ;
lin elegia_N = mkkN "elegia" ;
lin eleginen_A = mkkA "eleginen" ;
lin elegisesti_Adv = mkkAdv "elegisesti" ;
lin elegisyys_N = mkkN "elegisyys" ;
lin elehdinta'_N = mkkN "elehdintä" ;
lin elehtia'_V = mkkV "elehtiä" ;
lin eleinen_A = mkkA "eleinen" ;
lin eleisesti_Adv = mkkAdv "eleisesti" ;
lin elektrodi_N = mkkN "elektrodi" ;
lin elektroenkefalogrammi_N = mkkN "elektroenkefalogrammi" ;
lin elektrokardiogrammi_N = mkkN "elektrokardiogrammi" ;
lin elektrolyysi_N = mkkN "elektrolyysi" ;
lin elektrolyytti_N = mkkN "elektrolyytti" ;
lin elektrolyyttinen_A = mkkA "elektrolyyttinen" ;
lin elektrolyyttisesti_Adv = mkkAdv "elektrolyyttisesti" ;
lin elektroni_N = mkkN "elektroni" ;
lin elektroniikka_N = mkkN "elektroniikka" ;
lin elektroninen_A = mkkA "elektroninen" ;
lin elektronisesti_Adv = mkkAdv "elektronisesti" ;
lin elektronivoltti_N = mkkN "elektronivoltti" ;
lin elella'_V = mkkV "elellä" ;
lin elementaarinen_A = mkkA "elementaarinen" ;
lin elementaarisesti_Adv = mkkAdv "elementaarisesti" ;
lin elementaarisuus_N = mkkN "elementaarisuus" ;
lin elementti_N = mkkN "elementti" ;
lin elevaattori_N = mkkN "elevaattori" ;
lin eli_Adv = mkkAdv "eli" ;
lin eliitti_N = mkkN "eliitti" ;
lin elikko_N = mkkN "elikko" ;
lin elikka'_Adv = mkkAdv "elikkä" ;
lin eliksiiri_N = mkkN "eliksiiri" ;
lin elimellinen_A = mkkA "elimellinen" ;
lin elimellisesti_Adv = mkkAdv "elimellisesti" ;
lin elimellisyys_N = mkkN "elimellisyys" ;
lin eliminaatio_N = mkkN "eliminaatio" ;
lin eliminoida_V = mkkV "eliminoida" ;
lin eliminointi_N = mkkN "eliminointi" ;
lin eliminoitua_V = mkkV "eliminoitua" ;
lin elimisto'_N = mkkN "elimistö" ;
lin elin_N = mkkN "elin" ;
lin elinaika_N = mkkN "elinaika" ;
lin elinkelpoistaa_V = mkkV "elinkelpoistaa" ;
lin elinkelvottomuus_N = mkkN "elinkelvottomuus" ;
lin elitismi_N = mkkN "elitismi" ;
lin elitistinen_N = mkkN "elitistinen" ;
lin elitistisyys_N = mkkN "elitistisyys" ;
lin elio'_N = mkkN "eliö" ;
lin elio'sto'_N = mkkN "eliöstö" ;
lin elje_N = mkkN "elje" ;
lin ellei_Adv = mkkAdv "ellei" ;
lin ellipsi_N = mkkN "ellipsi" ;
lin elliptinen_N = mkkN "elliptinen" ;
lin elliptisyys_N = mkkN "elliptisyys" ;
lin ellottaa_V = mkkV "ellottaa" ;
lin ellotus_N = mkkN "ellotus" ;
lin elo_N = mkkN "elo" ;
lin eloisa_A = mkkA "eloisa" ;
lin eloisasti_Adv = mkkAdv "eloisasti" ;
lin eloisuus_N = mkkN "eloisuus" ;
lin eloksoida_V = mkkV "eloksoida" ;
lin eloksointi_N = mkkN "eloksointi" ;
lin elollinen_N = mkkN "elollinen" ;
lin elollistaa_V = mkkV "elollistaa" ;
lin elollisuus_N = mkkN "elollisuus" ;
lin eloon_Adv = mkkAdv "eloon" ;
lin elossa_Adv = mkkAdv "elossa" ;
lin elostelija_N = mkkN "elostelija" ;
lin elostella_V = mkkV "elostella" ;
lin elostelu_N = mkkN "elostelu" ;
lin elostua_V = mkkV "elostua" ;
lin elostuttaa_V = mkkV "elostuttaa" ;
lin eloton_N = mkkN "eloton" ;
lin elottomasti_Adv = mkkAdv "elottomasti" ;
lin elottomuus_N = mkkN "elottomuus" ;
lin elpya'_V = mkkV "elpyä" ;
lin eltaantua_V = mkkV "eltaantua" ;
lin elukka_N = mkkN "elukka" ;
lin elvistella'_V = mkkV "elvistellä" ;
lin elvistely_N = mkkN "elvistely" ;
lin elvyke_N = mkkN "elvyke" ;
lin elvytta'a'_V = mkkV "elvyttää" ;
lin elvytys_N = mkkN "elvytys" ;
lin ela'hdytta'a'_V = mkkV "elähdyttää" ;
lin ela'hta'nyt_N = mkkN "elähtänyt" ;
lin ela'imellinen_A = mkkA "eläimellinen" ;
lin ela'imellisesti_Adv = mkkAdv "eläimellisesti" ;
lin ela'imellisyys_N = mkkN "eläimellisyys" ;
lin ela'imisto'_N = mkkN "eläimistö" ;
lin ela'in_N = mkkN "eläin" ;
lin ela'ja'_N = mkkN "eläjä" ;
lin ela'ke_N = mkkN "eläke" ;
lin ela'kela'inen_N = mkkN "eläkeläinen" ;
lin ela'ko'itya'_V = mkkV "eläköityä" ;
lin ela'ko'o'n_Adv = mkkAdv "eläköön" ;
lin ela'mykseka's_N = mkkN "elämyksekäs" ;
lin ela'myksellinen_A = mkkA "elämyksellinen" ;
lin ela'myksellisesti_Adv = mkkAdv "elämyksellisesti" ;
lin ela'myksellisyys_N = mkkN "elämyksellisyys" ;
lin ela'mys_N = mkkN "elämys" ;
lin ela'ma'_N = mkkN "elämä" ;
lin ela'ma'kerturi_N = mkkN "elämäkerturi" ;
lin ela'ma'naika_N = mkkN "elämänaika" ;
lin ela'ma'nkatsomuksellinen_A = mkkA "elämänkatsomuksellinen" ;
lin ela'ma'nkatsomuksellisesti_Adv = mkkAdv "elämänkatsomuksellisesti" ;
lin ela'mo'ida'_V = mkkV "elämöidä" ;
lin ela'mo'inti_N = mkkN "elämöinti" ;
lin ela'tella'_V = mkkV "elätellä" ;
lin ela'tti_N = mkkN "elätti" ;
lin ela'tta'ja'_N = mkkN "elättäjä" ;
lin ela'tta'a'_V = mkkV "elättää" ;
lin ela'vyys_N = mkkN "elävyys" ;
lin ela'va'_A = mkkA "elävä" ;
lin ela'va'lta'_Adv = mkkAdv "elävältä" ;
lin ela'va'sti_Adv = mkkAdv "elävästi" ;
lin ela'vo'itta'a'_V = mkkV "elävöittää" ;
lin ela'vo'itya'_V = mkkV "elävöityä" ;
lin ela'ymys_N = mkkN "eläymys" ;
lin ela'ytya'_V = mkkV "eläytyä" ;
lin ela'a'_V = mkkV "elää" ;
lin emakko_N = mkkN "emakko" ;
lin emali_N = mkkN "emali" ;
lin emaloida_V = mkkV "emaloida" ;
lin emalointi_N = mkkN "emalointi" ;
lin emansipaatio_N = mkkN "emansipaatio" ;
lin emansipoida_V = mkkV "emansipoida" ;
lin emansipoitua_V = mkkV "emansipoitua" ;
lin embargo_N = mkkN "embargo" ;
lin embleemi_N = mkkN "embleemi" ;
lin embryo_N = mkkN "embryo" ;
lin embryologi_N = mkkN "embryologi" ;
lin embryologia_N = mkkN "embryologia" ;
lin embryologinen_A = mkkA "embryologinen" ;
lin embryologisesti_Adv = mkkAdv "embryologisesti" ;
lin emerita_N = mkkN "emerita" ;
lin emeritus_N = mkkN "emeritus" ;
lin emi_N = mkkN "emi" ;
lin emigrantti_N = mkkN "emigrantti" ;
lin emigroitua_V = mkkV "emigroitua" ;
lin emiiri_N = mkkN "emiiri" ;
lin eminenssi_N = mkkN "eminenssi" ;
lin emintima'_N = mkkN "emintimä" ;
lin emissio_N = mkkN "emissio" ;
lin emittoida_V = mkkV "emittoida" ;
lin emittointi_N = mkkN "emittointi" ;
lin emio'_N = mkkN "emiö" ;
lin emmentaali_N = mkkN "emmentaali" ;
lin emmental_N = mkkN "emmental" ;
lin emo_N = mkkN "emo" ;
lin emootio_N = mkkN "emootio" ;
lin emotionaalinen_A = mkkA "emotionaalinen" ;
lin emotionaalisesti_Adv = mkkAdv "emotionaalisesti" ;
lin emotionaalisuus_N = mkkN "emotionaalisuus" ;
lin empaattinen_A = mkkA "empaattinen" ;
lin empaattisesti_Adv = mkkAdv "empaattisesti" ;
lin empaattisuus_N = mkkN "empaattisuus" ;
lin empatia_N = mkkN "empatia" ;
lin empiiri_N = mkkN "empiiri" ;
lin empiirikko_N = mkkN "empiirikko" ;
lin empiirinen_A = mkkA "empiirinen" ;
lin empiirisesti_Adv = mkkAdv "empiirisesti" ;
lin empiirisyys_N = mkkN "empiirisyys" ;
lin empire_N = mkkN "empire" ;
lin empiria_N = mkkN "empiria" ;
lin empirismi_N = mkkN "empirismi" ;
lin empiristi_N = mkkN "empiristi" ;
lin empiristinen_N = mkkN "empiristinen" ;
lin empia'_V = mkkV "empiä" ;
lin emu_N = mkkN "emu" ;
lin emulaattori_N = mkkN "emulaattori" ;
lin emuloida_V = mkkV "emuloida" ;
lin emulointi_N = mkkN "emulointi" ;
lin emulsio_N = mkkN "emulsio" ;
lin ema'_N = mkkN "emä" ;
lin ema'kki_N = mkkN "emäkki" ;
lin ema'ksinen_A = mkkA "emäksinen" ;
lin ema'ksisesti_Adv = mkkAdv "emäksisesti" ;
lin ema'ksisyys_N = mkkN "emäksisyys" ;
lin ema'nnyys_N = mkkN "emännyys" ;
lin ema'nno'ida'_V = mkkV "emännöidä" ;
lin ema'nno'inti_N = mkkN "emännöinti" ;
lin ema'nno'itsija'_N = mkkN "emännöitsijä" ;
lin ema'nta'_N = mkkN "emäntä" ;
lin ema's_N = mkkN "emäs" ;
lin ema'tin_N = mkkN "emätin" ;
lin enchilada_N = mkkN "enchilada" ;
lin endeeminen_A = mkkA "endeeminen" ;
lin endeemisesti_Adv = mkkAdv "endeemisesti" ;
lin endeemisyys_N = mkkN "endeemisyys" ;
lin endiivi_N = mkkN "endiivi" ;
lin endogeeninen_N = mkkN "endogeeninen" ;
lin endogeenisuus_N = mkkN "endogeenisuus" ;
lin endokriininen_N = mkkN "endokriininen" ;
lin endokrinologia_N = mkkN "endokrinologia" ;
lin endokrinologinen_A = mkkA "endokrinologinen" ;
lin endokrinologisesti_Adv = mkkAdv "endokrinologisesti" ;
lin endometrioosi_N = mkkN "endometrioosi" ;
lin endorfiini_N = mkkN "endorfiini" ;
lin endoskooppi_N = mkkN "endoskooppi" ;
lin endoskopia_N = mkkN "endoskopia" ;
lin enemmisto'_N = mkkN "enemmistö" ;
lin enemmisto'inen_N = mkkN "enemmistöinen" ;
lin enemmisto'la'inen_N = mkkN "enemmistöläinen" ;
lin enemmyys_N = mkkN "enemmyys" ;
lin enemma'lti_Adv = mkkAdv "enemmälti" ;
lin enemma'n_Adv = mkkAdv "enemmän" ;
lin enempi_N = mkkN "enempi" ;
lin enempa'a'_Adv = mkkAdv "enempää" ;
lin eneneva'_A = mkkA "enenevä" ;
lin eneneva'sti_Adv = mkkAdv "enenevästi" ;
lin enennys_N = mkkN "enennys" ;
lin enentya'_V = mkkV "enentyä" ;
lin enenta'a'_V = mkkV "enentää" ;
lin energia_N = mkkN "energia" ;
lin energiainen_N = mkkN "energiainen" ;
lin energinen_A = mkkA "energinen" ;
lin energisesti_Adv = mkkAdv "energisesti" ;
lin energisyys_N = mkkN "energisyys" ;
lin eneta'_V = mkkV "enetä" ;
lin engelsmanni_N = mkkN "engelsmanni" ;
lin englanninnos_N = mkkN "englanninnos" ;
lin englannintaa_V = mkkV "englannintaa" ;
lin englanti_N = mkkN "englanti" ;
lin englantilaisuus_N = mkkN "englantilaisuus" ;
lin engrammi_N = mkkN "engrammi" ;
lin enimmin_Adv = mkkAdv "enimmin" ;
lin enimmiten_Adv = mkkAdv "enimmiten" ;
lin enimma'isaika_N = mkkN "enimmäisaika" ;
lin enimma'israja_N = mkkN "enimmäisraja" ;
lin enimma'ista'a'_V = mkkV "enimmäistää" ;
lin enimma'kseen_Adv = mkkAdv "enimmäkseen" ;
lin enimma'lti_Adv = mkkAdv "enimmälti" ;
lin enimma'lta'a'n_Adv = mkkAdv "enimmältään" ;
lin enimma'n_Adv = mkkAdv "enimmän" ;
lin enin_N = mkkN "enin" ;
lin eninta'a'n_Adv = mkkAdv "enintään" ;
lin eniten_Adv = mkkAdv "eniten" ;
lin enkeli_N = mkkN "enkeli" ;
lin ennakko_N = mkkN "ennakko" ;
lin ennakkoilmoittautuminen_N = mkkN "ennakkoilmoittautuminen" ;
lin ennakkoluuloisesti_Adv = mkkAdv "ennakkoluuloisesti" ;
lin ennakkoluuloton_N = mkkN "ennakkoluuloton" ;
lin ennakkoluulottomasti_Adv = mkkAdv "ennakkoluulottomasti" ;
lin ennakkoluulottomuus_N = mkkN "ennakkoluulottomuus" ;
lin ennakkoon_Adv = mkkAdv "ennakkoon" ;
lin ennakkosa'a'sta'minen_N = mkkN "ennakkosäästäminen" ;
lin ennakoida_V = mkkV "ennakoida" ;
lin ennakoimaton_N = mkkN "ennakoimaton" ;
lin ennakointi_N = mkkN "ennakointi" ;
lin ennakolta_Adv = mkkAdv "ennakolta" ;
lin ennakonkanto_N = mkkN "ennakonkanto" ;
lin ennallaan_Adv = mkkAdv "ennallaan" ;
lin ennalleen_Adv = mkkAdv "ennalleen" ;
lin ennallistaa_V = mkkV "ennallistaa" ;
lin ennallistus_N = mkkN "ennallistus" ;
lin ennalta_Adv = mkkAdv "ennalta" ;
lin ennalta_arvattavuus_N = mkkN "ennalta-arvattavuus" ;
lin ennalta_ehka'iseva'_N = mkkN "ennaltC" ;
lin enne_N = mkkN "enne" ;
lin ennemmin_Adv = mkkAdv "ennemmin" ;
lin ennen_Adv = mkkAdv "ennen" ;
lin ennen_aikaan_Adv = mkkAdv "enneC" ;
lin ennenaikaisesti_Adv = mkkAdv "ennenaikaisesti" ;
lin ennen_kaikkea_Adv = mkkAdv "enneC" ;
lin ennen_kuin_Adv = mkkAdv "enneC" ;
lin ennen_muinoin_Adv = mkkAdv "enneC" ;
lin ennenna'kema'tto'ma'sti_Adv = mkkAdv "ennennäkemättömästi" ;
lin ennen_pitka'a'_Adv = mkkAdv "enneC" ;
lin ennen_vanhaan_Adv = mkkAdv "enneC" ;
lin ennesta'a'n_Adv = mkkAdv "ennestään" ;
lin ennustaa_V = mkkV "ennustaa" ;
lin ennustaja_N = mkkN "ennustaja" ;
lin ennustavuus_N = mkkN "ennustavuus" ;
lin ennuste_N = mkkN "ennuste" ;
lin ennusteellinen_N = mkkN "ennusteellinen" ;
lin ennustella_V = mkkV "ennustella" ;
lin ennustus_N = mkkN "ennustus" ;
lin enna'tta'a'_V = mkkV "ennättää" ;
lin enna'tyksellinen_A = mkkA "ennätyksellinen" ;
lin enna'tyksellisesti_Adv = mkkAdv "ennätyksellisesti" ;
lin enna'tyksellisyys_N = mkkN "ennätyksellisyys" ;
lin enna'tys_N = mkkN "ennätys" ;
lin enna'tysaika_N = mkkN "ennätysaika" ;
lin enna'tysma'inen_A = mkkA "ennätysmäinen" ;
lin enna'tysma'isesti_Adv = mkkAdv "ennätysmäisesti" ;
lin eno_1_N = mkkN "eno" ;
lin eno_2_N = mkkN "eno" ;
lin ensemble_N = mkkN "ensemble" ;
lin ensi_Adv = mkkAdv "ensi" ;
lin ensiesiintyminen_N = mkkN "ensiesiintyminen" ;
lin ensikertalainen_N = mkkN "ensikertalainen" ;
lin ensiksi_Adv = mkkAdv "ensiksi" ;
lin ensi_ka'dessa'_Adv = mkkAdv "ensC" ;
lin ensiluokkaisesti_Adv = mkkAdv "ensiluokkaisesti" ;
lin ensimma'inen_N = mkkN "ensimmäinen" ;
lin ensimma'iseksi_Adv = mkkAdv "ensimmäiseksi" ;
lin ensimma'lta'_Adv = mkkAdv "ensimmältä" ;
lin ensin_Adv = mkkAdv "ensin" ;
lin ensinka'a'n_Adv = mkkAdv "ensinkään" ;
lin ensin_mainittu_N = mkkN "ensiC" ;
lin ensinna'_Adv = mkkAdv "ensinnä" ;
lin ensipa'iva'nkuori_N = mkkN "ensipäivänkuori" ;
lin ensisijaisesti_Adv = mkkAdv "ensisijaisesti" ;
lin ensisijaistaa_V = mkkV "ensisijaistaa" ;
lin ensi_sijassa_Adv = mkkAdv "ensC" ;
lin ensyklopedia_N = mkkN "ensyklopedia" ;
lin enteellinen_A = mkkA "enteellinen" ;
lin enteellisesti_Adv = mkkAdv "enteellisesti" ;
lin enteellisyys_N = mkkN "enteellisyys" ;
lin enteilla'_V = mkkV "enteillä" ;
lin enteily_N = mkkN "enteily" ;
lin enteinen_N = mkkN "enteinen" ;
lin entinen_N = mkkN "entinen" ;
lin entisaika_N = mkkN "entisaika" ;
lin entiselleen_Adv = mkkAdv "entiselleen" ;
lin entisella'a'n_Adv = mkkAdv "entisellään" ;
lin entisenlainen_N = mkkN "entisenlainen" ;
lin entisensa'_Adv = mkkAdv "entisensä" ;
lin entisesta'a'n_Adv = mkkAdv "entisestään" ;
lin entistys_N = mkkN "entistys" ;
lin entista'a'_V = mkkV "entistää" ;
lin entisyys_N = mkkN "entisyys" ;
lin entiso'ida'_V = mkkV "entisöidä" ;
lin entiteetti_N = mkkN "entiteetti" ;
lin entrata_1_V = mkkV "entrata" ;
lin entrata_2_V = mkkV "entrata" ;
lin entraus_1_N = mkkN "entraus" ;
lin entraus_2_N = mkkN "entraus" ;
lin entrec_te_N = mkkN "entrecôte" ;
lin entropia_N = mkkN "entropia" ;
lin entsyymi_N = mkkN "entsyymi" ;
lin entusiasmi_N = mkkN "entusiasmi" ;
lin entusiasti_N = mkkN "entusiasti" ;
lin entusiastinen_N = mkkN "entusiastinen" ;
lin entuudestaan_Adv = mkkAdv "entuudestaan" ;
lin enta'_Adv = mkkAdv "entä" ;
lin enta'pa'_Adv = mkkAdv "entäpä" ;
lin enta'pa's_Adv = mkkAdv "entäpäs" ;
lin enta's_Adv = mkkAdv "entäs" ;
lin enta'a'_V = mkkV "entää" ;
lin ena'a'_Adv = mkkAdv "enää" ;
lin epeli_N = mkkN "epeli" ;
lin epideeminen_N = mkkN "epideeminen" ;
lin epidemia_N = mkkN "epidemia" ;
lin epidemiologi_N = mkkN "epidemiologi" ;
lin epidemiologia_N = mkkN "epidemiologia" ;
lin epidemiologinen_A = mkkA "epidemiologinen" ;
lin epidemiologisesti_Adv = mkkAdv "epidemiologisesti" ;
lin epidermi_N = mkkN "epidermi" ;
lin epigrammi_N = mkkN "epigrammi" ;
lin epiikka_N = mkkN "epiikka" ;
lin epikriisi_N = mkkN "epikriisi" ;
lin epikurolainen_N = mkkN "epikurolainen" ;
lin epikurolaisuus_N = mkkN "epikurolaisuus" ;
lin epilepsia_N = mkkN "epilepsia" ;
lin epileptikko_N = mkkN "epileptikko" ;
lin epileptinen_N = mkkN "epileptinen" ;
lin epilogi_N = mkkN "epilogi" ;
lin episkopaalinen_N = mkkN "episkopaalinen" ;
lin episodi_N = mkkN "episodi" ;
lin epistola_N = mkkN "epistola" ;
lin epiteeli_N = mkkN "epiteeli" ;
lin epiteetti_N = mkkN "epiteetti" ;
lin epoksimaali_N = mkkN "epoksimaali" ;
lin epoletti_N = mkkN "epoletti" ;
lin epookki_N = mkkN "epookki" ;
lin epuu_N = mkkN "epuu" ;
lin epuuttaa_V = mkkV "epuuttaa" ;
lin epa'historiallisesti_Adv = mkkAdv "epähistoriallisesti" ;
lin epa'historiallisuus_N = mkkN "epähistoriallisuus" ;
lin epa'huomiossa_Adv = mkkAdv "epähuomiossa" ;
lin epa'ilema'tta'_Adv = mkkAdv "epäilemättä" ;
lin epa'ilevyys_N = mkkN "epäilevyys" ;
lin epa'ileva'_A = mkkA "epäilevä" ;
lin epa'ileva'inen_N = mkkN "epäileväinen" ;
lin epa'ileva'sti_Adv = mkkAdv "epäilevästi" ;
lin epa'ilija'_N = mkkN "epäilijä" ;
lin epa'illa'_V = mkkV "epäillä" ;
lin epa'ilta'va'_N = mkkN "epäiltävä" ;
lin epa'ily_N = mkkN "epäily" ;
lin epa'ilys_N = mkkN "epäilys" ;
lin epa'ilytta'vyys_N = mkkN "epäilyttävyys" ;
lin epa'ilytta'va'_A = mkkA "epäilyttävä" ;
lin epa'ilytta'va'sti_Adv = mkkAdv "epäilyttävästi" ;
lin epa'ilytta'a'_V = mkkV "epäilyttää" ;
lin epa'kelpo_N = mkkN "epäkelpo" ;
lin epa'keskisesti_Adv = mkkAdv "epäkeskisesti" ;
lin epa'keskisyys_N = mkkN "epäkeskisyys" ;
lin epa'kesko_N = mkkN "epäkesko" ;
lin epa'kiitollisesti_Adv = mkkAdv "epäkiitollisesti" ;
lin epa'kohta_N = mkkN "epäkohta" ;
lin epa'ka's_N = mkkN "epäkäs" ;
lin epa'luuloisesti_Adv = mkkAdv "epäluuloisesti" ;
lin epa'ma'a'ra'istya'_V = mkkV "epämääräistyä" ;
lin epa'onnistuja_N = mkkN "epäonnistuja" ;
lin epa'ortodoksisesti_Adv = mkkAdv "epäortodoksisesti" ;
lin epa'pa'teva'sti_Adv = mkkAdv "epäpätevästi" ;
lin epa'ro'ida'_V = mkkV "epäröidä" ;
lin epa'ro'inti_N = mkkN "epäröinti" ;
lin epa'sointuisesti_Adv = mkkAdv "epäsointuisesti" ;
lin epa'sointuisuus_N = mkkN "epäsointuisuus" ;
lin epa'sopuinen_A = mkkA "epäsopuinen" ;
lin epa'sopuisesti_Adv = mkkAdv "epäsopuisesti" ;
lin epa'suhtaisesti_Adv = mkkAdv "epäsuhtaisesti" ;
lin epa'sa'a'tyisyys_N = mkkN "epäsäätyisyys" ;
lin epa'todenna'ko'isesti_Adv = mkkAdv "epätodennäköisesti" ;
lin epa'toivoinen_A = mkkA "epätoivoinen" ;
lin epa'toivoisesti_Adv = mkkAdv "epätoivoisesti" ;
lin epa'toivoissaan_Adv = mkkAdv "epätoivoissaan" ;
lin epa'toivoisuus_N = mkkN "epätoivoisuus" ;
lin epa'tyydytta'vyys_N = mkkN "epätyydyttävyys" ;
lin epa'urheilijamainen_A = mkkA "epäurheilijamainen" ;
lin epa'urheilijamaisesti_Adv = mkkAdv "epäurheilijamaisesti" ;
lin epa'urheilijamaisuus_N = mkkN "epäurheilijamaisuus" ;
lin epa'uskoisesti_Adv = mkkAdv "epäuskoisesti" ;
lin epa'vakainen_A = mkkA "epävakainen" ;
lin epa'vakaisesti_Adv = mkkAdv "epävakaisesti" ;
lin epa'vakaisuus_N = mkkN "epävakaisuus" ;
lin epa'vakaus_N = mkkN "epävakaus" ;
lin epa'vireeseen_Adv = mkkAdv "epävireeseen" ;
lin epa'vireessa'_Adv = mkkAdv "epävireessä" ;
lin epa'vireisesti_Adv = mkkAdv "epävireisesti" ;
lin epa'ys_N = mkkN "epäys" ;
lin epa'a'ma'tto'myys_N = mkkN "epäämättömyys" ;
lin epa'a'ma'tto'ma'sti_Adv = mkkAdv "epäämättömästi" ;
lin epa'a'ma'to'n_N = mkkN "epäämätön" ;
lin erakko_N = mkkN "erakko" ;
lin erakoitua_V = mkkV "erakoitua" ;
lin eranto_N = mkkN "eranto" ;
lin erehdys_N = mkkN "erehdys" ;
lin erehdytta'a'_V = mkkV "erehdyttää" ;
lin erehtyma'tto'myys_N = mkkN "erehtymättömyys" ;
lin erehtyma'to'n_N = mkkN "erehtymätön" ;
lin erehtyva'inen_N = mkkN "erehtyväinen" ;
lin erehtyva'isyys_N = mkkN "erehtyväisyys" ;
lin erehtya'_V = mkkV "erehtyä" ;
lin erektio_N = mkkN "erektio" ;
lin ergometri_N = mkkN "ergometri" ;
lin ergonomia_N = mkkN "ergonomia" ;
lin ergonominen_A = mkkA "ergonominen" ;
lin ergonomisesti_Adv = mkkAdv "ergonomisesti" ;
lin ergonomisuus_N = mkkN "ergonomisuus" ;
lin erhe_N = mkkN "erhe" ;
lin erheellinen_A = mkkA "erheellinen" ;
lin erheellisesti_Adv = mkkAdv "erheellisesti" ;
lin erheellisyys_N = mkkN "erheellisyys" ;
lin eri_Adv = mkkAdv "eri" ;
lin eriaikaisesti_Adv = mkkAdv "eriaikaisesti" ;
lin eriarvoistaa_V = mkkV "eriarvoistaa" ;
lin eriarvoistua_V = mkkV "eriarvoistua" ;
lin eriasteisesti_Adv = mkkAdv "eriasteisesti" ;
lin erikoinen_A = mkkA "erikoinen" ;
lin erikoisesti_Adv = mkkAdv "erikoisesti" ;
lin erikoislaatuisesti_Adv = mkkAdv "erikoislaatuisesti" ;
lin erikoistaa_V = mkkV "erikoistaa" ;
lin erikoistua_V = mkkV "erikoistua" ;
lin erikoisuus_N = mkkN "erikoisuus" ;
lin erikokoisuus_N = mkkN "erikokoisuus" ;
lin erikorkuisuus_N = mkkN "erikorkuisuus" ;
lin erikseen_Adv = mkkAdv "erikseen" ;
lin erilaistaa_V = mkkV "erilaistaa" ;
lin erilaistua_V = mkkV "erilaistua" ;
lin erilaisuus_N = mkkN "erilaisuus" ;
lin erilleen_Adv = mkkAdv "erilleen" ;
lin erillinen_N = mkkN "erillinen" ;
lin erillisyys_N = mkkN "erillisyys" ;
lin erilla'a'n_Adv = mkkAdv "erillään" ;
lin eriluonteisuus_N = mkkN "eriluonteisuus" ;
lin erimielisesti_Adv = mkkAdv "erimielisesti" ;
lin erimunaisuus_N = mkkN "erimunaisuus" ;
lin erimuotoisesti_Adv = mkkAdv "erimuotoisesti" ;
lin erinimisyys_N = mkkN "erinimisyys" ;
lin erinomainen_A = mkkA "erinomainen" ;
lin erinomaisesti_Adv = mkkAdv "erinomaisesti" ;
lin erinomaisuus_N = mkkN "erinomaisuus" ;
lin erina'inen_N = mkkN "erinäinen" ;
lin eriparisuus_N = mkkN "eriparisuus" ;
lin eriperinta'inen_N = mkkN "eriperintäinen" ;
lin eripituisuus_N = mkkN "eripituisuus" ;
lin eripura_N = mkkN "eripura" ;
lin eripurainen_A = mkkA "eripurainen" ;
lin eripuraisesti_Adv = mkkAdv "eripuraisesti" ;
lin eripuraisuus_N = mkkN "eripuraisuus" ;
lin eriseurainen_N = mkkN "eriseurainen" ;
lin eriseuraisuus_N = mkkN "eriseuraisuus" ;
lin erisivuisuus_N = mkkN "erisivuisuus" ;
lin eriskummainen_N = mkkN "eriskummainen" ;
lin eriste_N = mkkN "eriste" ;
lin eristeinen_N = mkkN "eristeinen" ;
lin eristin_N = mkkN "eristin" ;
lin eristyneisyys_N = mkkN "eristyneisyys" ;
lin eristys_N = mkkN "eristys" ;
lin eristya'_V = mkkV "eristyä" ;
lin erista'ja'_N = mkkN "eristäjä" ;
lin erista'ytya'_V = mkkV "eristäytyä" ;
lin erista'a'_V = mkkV "eristää" ;
lin erisuuruisuus_N = mkkN "erisuuruisuus" ;
lin erisa'a'tyisyys_N = mkkN "erisäätyisyys" ;
lin eritasoisesti_Adv = mkkAdv "eritasoisesti" ;
lin eritasoisuus_N = mkkN "eritasoisuus" ;
lin erite_N = mkkN "erite" ;
lin eritella'_V = mkkV "eritellä" ;
lin eritelma'_N = mkkN "eritelmä" ;
lin eritoten_Adv = mkkAdv "eritoten" ;
lin erittelija'_N = mkkN "erittelijä" ;
lin erittely_N = mkkN "erittely" ;
lin erittya'_V = mkkV "erittyä" ;
lin eritta'in_1_Adv = mkkAdv "erittäin" ;
lin eritta'in_2_Adv = mkkAdv "erittäin" ;
lin eritta'inkin_Adv = mkkAdv "erittäinkin" ;
lin eritta'a'_V = mkkV "erittää" ;
lin erityinen_A = mkkA "erityinen" ;
lin erityisesti_Adv = mkkAdv "erityisesti" ;
lin erityiskorvattava_N = mkkN "erityiskorvattava" ;
lin eritys_N = mkkN "eritys" ;
lin erityyppisesti_Adv = mkkAdv "erityyppisesti" ;
lin erityyppisyys_N = mkkN "erityyppisyys" ;
lin erita'_V = mkkV "eritä" ;
lin eriytta'a'_V = mkkV "eriyttää" ;
lin eriytys_N = mkkN "eriytys" ;
lin eriytya'_V = mkkV "eriytyä" ;
lin eria'va'_N = mkkN "eriävä" ;
lin erio'_N = mkkN "eriö" ;
lin erkaantua_V = mkkV "erkaantua" ;
lin erkanee_V = mkkV "erkanee" ;
lin erkautua_V = mkkV "erkautua" ;
lin erkkeri_N = mkkN "erkkeri" ;
lin ero_N = mkkN "ero" ;
lin eroavaisuus_N = mkkN "eroavaisuus" ;
lin eroavuus_N = mkkN "eroavuus" ;
lin erogeeninen_N = mkkN "erogeeninen" ;
--? lin erojaiset_NK = {s = d38 "erojaiset" ;
lin eroon_Adv = mkkAdv "eroon" ;
lin eroottinen_A = mkkA "eroottinen" ;
lin eroottisesti_Adv = mkkAdv "eroottisesti" ;
lin eroottistaa_V = mkkV "eroottistaa" ;
lin eroottistua_V = mkkV "eroottistua" ;
lin eroottisuus_N = mkkN "eroottisuus" ;
lin erossa_Adv = mkkAdv "erossa" ;
lin erota_V = mkkV "erota" ;
lin erotella_V = mkkV "erotella" ;
lin erotiikka_N = mkkN "erotiikka" ;
lin erotin_N = mkkN "erotin" ;
lin erotisoida_V = mkkV "erotisoida" ;
lin erotisointi_N = mkkN "erotisointi" ;
lin erotisoitua_V = mkkV "erotisoitua" ;
lin erotomaani_N = mkkN "erotomaani" ;
lin erotomania_N = mkkN "erotomania" ;
lin erottaa_V = mkkV "erottaa" ;
lin erottamaton_N = mkkN "erottamaton" ;
lin erottamattomasti_Adv = mkkAdv "erottamattomasti" ;
lin erottautua_V = mkkV "erottautua" ;
lin erottelu_N = mkkN "erottelu" ;
lin erottua_V = mkkV "erottua" ;
lin erotus_N = mkkN "erotus" ;
lin ersa'_N = mkkN "ersä" ;
lin eruptiivinen_N = mkkN "eruptiivinen" ;
lin erytropoietiini_N = mkkN "erytropoietiini" ;
lin era'_N = mkkN "erä" ;
lin era's_N = mkkN "eräs" ;
lin era'a'nlainen_N = mkkN "eräänlainen" ;
lin era'a'ntya'_V = mkkV "erääntyä" ;
lin esanssi_N = mkkN "esanssi" ;
lin esiin_Adv = mkkAdv "esiin" ;
lin esiintyja'_N = mkkN "esiintyjä" ;
lin esiintyma'_N = mkkN "esiintymä" ;
lin esiintyvyys_N = mkkN "esiintyvyys" ;
lin esiintya'_V = mkkV "esiintyä" ;
lin esikko_N = mkkN "esikko" ;
lin esikoinen_N = mkkN "esikoinen" ;
lin esille_Adv = mkkAdv "esille" ;
lin esilla'_Adv = mkkAdv "esillä" ;
lin esine_N = mkkN "esine" ;
lin esineellinen_N = mkkN "esineellinen" ;
lin esineellistya'_V = mkkV "esineellistyä" ;
lin esineellista'a'_V = mkkV "esineellistää" ;
lin esineellisyys_N = mkkN "esineellisyys" ;
lin esineistya'_V = mkkV "esineistyä" ;
lin esineista'a'_V = mkkV "esineistää" ;
lin esineisto'_N = mkkN "esineistö" ;
lin esirippu_N = mkkN "esirippu" ;
lin esite_N = mkkN "esite" ;
lin esitella'_V = mkkV "esitellä" ;
lin esitelma'_N = mkkN "esitelmä" ;
lin esitelmo'ida'_V = mkkV "esitelmöidä" ;
lin esitelmo'ija'_N = mkkN "esitelmöijä" ;
lin esitelmo'inti_N = mkkN "esitelmöinti" ;
lin esitelmo'itsija'_N = mkkN "esitelmöitsijä" ;
lin esitteille_Adv = mkkAdv "esitteille" ;
lin esitteilla'_Adv = mkkAdv "esitteillä" ;
lin esittelija'_N = mkkN "esittelijä" ;
lin esittely_N = mkkN "esittely" ;
lin esitta'ja'_N = mkkN "esittäjä" ;
lin esitta'ytya'_V = mkkV "esittäytyä" ;
lin esitta'a'_V = mkkV "esittää" ;
lin esityksellinen_N = mkkN "esityksellinen" ;
lin esitys_N = mkkN "esitys" ;
lin esita'ytetty_N = mkkN "esitäytetty" ;
lin eskaaderi_N = mkkN "eskaaderi" ;
lin eskadroona_N = mkkN "eskadroona" ;
lin eskalaatio_N = mkkN "eskalaatio" ;
lin eskaloida_V = mkkV "eskaloida" ;
lin eskalointi_N = mkkN "eskalointi" ;
lin eskaloitua_V = mkkV "eskaloitua" ;
lin eskapismi_N = mkkN "eskapismi" ;
lin eskapisti_N = mkkN "eskapisti" ;
lin eskapistinen_N = mkkN "eskapistinen" ;
lin eskarilainen_N = mkkN "eskarilainen" ;
lin eskatologia_N = mkkN "eskatologia" ;
lin eskatologinen_N = mkkN "eskatologinen" ;
lin eskimo_N = mkkN "eskimo" ;
lin esoteerinen_N = mkkN "esoteerinen" ;
lin espanja_N = mkkN "espanja" ;
lin espanjalaisuus_N = mkkN "espanjalaisuus" ;
lin espanjatar_N = mkkN "espanjatar" ;
lin esperantisti_N = mkkN "esperantisti" ;
lin esperanto_N = mkkN "esperanto" ;
lin esplanadi_N = mkkN "esplanadi" ;
lin espresso_N = mkkN "espresso" ;
lin essee_N = mkkN "essee" ;
lin esseisti_N = mkkN "esseisti" ;
lin esseistiikka_N = mkkN "esseistiikka" ;
lin essentiaalinen_N = mkkN "essentiaalinen" ;
lin essiivi_N = mkkN "essiivi" ;
lin essu_N = mkkN "essu" ;
lin establishment_N = mkkN "establishment" ;
lin este_N = mkkN "este" ;
lin esteellinen_N = mkkN "esteellinen" ;
lin esteellisyys_N = mkkN "esteellisyys" ;
lin esteetikko_N = mkkN "esteetikko" ;
lin esteettinen_A = mkkA "esteettinen" ;
lin esteettisesti_Adv = mkkAdv "esteettisesti" ;
lin esteettisyys_N = mkkN "esteettisyys" ;
lin esteetto'myys_N = mkkN "esteettömyys" ;
lin esteeto'n_N = mkkN "esteetön" ;
lin esteinen_N = mkkN "esteinen" ;
lin estella'_V = mkkV "estellä" ;
lin estely_N = mkkN "estely" ;
lin esteri_N = mkkN "esteri" ;
lin estetiikka_N = mkkN "estetiikka" ;
lin estimaatti_N = mkkN "estimaatti" ;
lin estimaattori_N = mkkN "estimaattori" ;
lin estimoida_V = mkkV "estimoida" ;
lin estimointi_N = mkkN "estimointi" ;
lin estin_N = mkkN "estin" ;
lin esto_N = mkkN "esto" ;
lin estoinen_N = mkkN "estoinen" ;
lin estoisuus_N = mkkN "estoisuus" ;
lin estoton_N = mkkN "estoton" ;
lin estottomasti_Adv = mkkAdv "estottomasti" ;
lin estottomuus_N = mkkN "estottomuus" ;
lin estradi_N = mkkN "estradi" ;
lin estrogeeni_N = mkkN "estrogeeni" ;
lin estyma'_N = mkkN "estymä" ;
lin estyneisyys_N = mkkN "estyneisyys" ;
lin estya'_V = mkkV "estyä" ;
lin esta'ja'_N = mkkN "estäjä" ;
lin esta'a'_V = mkkV "estää" ;
lin etaani_N = mkkN "etaani" ;
lin etabloitua_V = mkkV "etabloitua" ;
lin etana_N = mkkN "etana" ;
lin etanoli_N = mkkN "etanoli" ;
lin etappi_N = mkkN "etappi" ;
lin eteen_Adv = mkkAdv "eteen" ;
lin eteeni_N = mkkN "eteeni" ;
lin eteerinen_A = mkkA "eteerinen" ;
lin eteerisesti_Adv = mkkAdv "eteerisesti" ;
lin eteerisyys_N = mkkN "eteerisyys" ;
lin eteinen_N = mkkN "eteinen" ;
lin eteishalli_N = mkkN "eteishalli" ;
lin etela'_N = mkkN "etelä" ;
lin etela'inen_N = mkkN "eteläinen" ;
lin etela'mma'ksi_Adv = mkkAdv "etelämmäksi" ;
lin etela'mma's_Adv = mkkAdv "etelämmäs" ;
lin etela'mpa'na'_Adv = mkkAdv "etelämpänä" ;
lin etela'mpa'a'_Adv = mkkAdv "etelämpää" ;
lin etela'valtalainen_N = mkkN "etelävaltalainen" ;
lin etemma'_Adv = mkkAdv "etemmä" ;
lin etemma'ksi_Adv = mkkAdv "etemmäksi" ;
lin etemma's_Adv = mkkAdv "etemmäs" ;
lin etempa'na'_Adv = mkkAdv "etempänä" ;
lin etempa'a'_Adv = mkkAdv "etempää" ;
lin etenema'_N = mkkN "etenemä" ;
lin etenija'_N = mkkN "etenijä" ;
lin etenkin_Adv = mkkAdv "etenkin" ;
lin etenka'a'n_Adv = mkkAdv "etenkään" ;
lin etevyys_N = mkkN "etevyys" ;
lin eteva'_A = mkkA "etevä" ;
lin eteva'mmyys_N = mkkN "etevämmyys" ;
lin eteva'sti_Adv = mkkAdv "etevästi" ;
lin etiikka_N = mkkN "etiikka" ;
lin etiketti_N = mkkN "etiketti" ;
lin etiketo'ida'_V = mkkV "etiketöidä" ;
lin etiketo'inti_N = mkkN "etiketöinti" ;
lin etikka_N = mkkN "etikka" ;
lin etinen_N = mkkN "etinen" ;
lin etiologia_N = mkkN "etiologia" ;
lin etiologinen_A = mkkA "etiologinen" ;
lin etiologisesti_Adv = mkkAdv "etiologisesti" ;
lin etia'inen_N = mkkN "etiäinen" ;
lin etninen_A = mkkA "etninen" ;
lin etnisesti_Adv = mkkAdv "etnisesti" ;
lin etnografi_N = mkkN "etnografi" ;
lin etnografia_N = mkkN "etnografia" ;
lin etnografinen_A = mkkA "etnografinen" ;
lin etnografisesti_Adv = mkkAdv "etnografisesti" ;
lin etnologi_N = mkkN "etnologi" ;
lin etnologia_N = mkkN "etnologia" ;
lin etnologinen_A = mkkA "etnologinen" ;
lin etnologisesti_Adv = mkkAdv "etnologisesti" ;
lin etoa_V = mkkV "etoa" ;
lin etruski_N = mkkN "etruski" ;
lin etsaaja_N = mkkN "etsaaja" ;
lin etsata_V = mkkV "etsata" ;
lin etsaus_N = mkkN "etsaus" ;
lin etsija'_N = mkkN "etsijä" ;
lin etsikko_N = mkkN "etsikko" ;
lin etsikkoaika_N = mkkN "etsikkoaika" ;
lin etsin_N = mkkN "etsin" ;
lin etsinta'_N = mkkN "etsintä" ;
lin etsiskella'_V = mkkV "etsiskellä" ;
lin etsiskely_N = mkkN "etsiskely" ;
lin etsiva'_N = mkkN "etsivä" ;
lin etsiytya'_V = mkkV "etsiytyä" ;
lin etsia'_V = mkkV "etsiä" ;
lin etteiko'_Adv = mkkAdv "etteikö" ;
lin etta'_Adv = mkkAdv "että" ;
lin etu_N = mkkN "etu" ;
lin etuilija_N = mkkN "etuilija" ;
lin etuilla_V = mkkV "etuilla" ;
lin etuilu_N = mkkN "etuilu" ;
lin etuisuus_N = mkkN "etuisuus" ;
lin etukenoinen_N = mkkN "etukenoinen" ;
lin etuka'teen_Adv = mkkAdv "etukäteen" ;
lin etummainen_N = mkkN "etummainen" ;
lin etumus_N = mkkN "etumus" ;
lin etunena'ssa'_Adv = mkkAdv "etunenässä" ;
lin etuoikeuksinen_N = mkkN "etuoikeuksinen" ;
lin etupainotteisesti_Adv = mkkAdv "etupainotteisesti" ;
lin etupainotteisuus_N = mkkN "etupainotteisuus" ;
lin etuperin_Adv = mkkAdv "etuperin" ;
lin etusijaistaa_V = mkkV "etusijaistaa" ;
lin etuus_N = mkkN "etuus" ;
lin etydi_N = mkkN "etydi" ;
lin etyleeni_N = mkkN "etyleeni" ;
lin etymologia_N = mkkN "etymologia" ;
lin etymologinen_A = mkkA "etymologinen" ;
lin etymologisesti_Adv = mkkAdv "etymologisesti" ;
lin eta'inen_A = mkkA "etäinen" ;
lin eta'isesti_Adv = mkkAdv "etäisesti" ;
lin eta'isyys_N = mkkN "etäisyys" ;
lin eta'ytta'a'_V = mkkV "etäyttää" ;
lin eta'a'lle_Adv = mkkAdv "etäälle" ;
lin eta'a'lla'_Adv = mkkAdv "etäällä" ;
lin eta'a'lta'_Adv = mkkAdv "etäältä" ;
lin eta'a'mma'ksi_Adv = mkkAdv "etäämmäksi" ;
lin eta'a'mma's_Adv = mkkAdv "etäämmäs" ;
lin eta'a'mpa'na'_Adv = mkkAdv "etäämpänä" ;
lin eta'a'mpa'a'_Adv = mkkAdv "etäämpää" ;
lin eta'a'nnytta'a'_V = mkkV "etäännyttää" ;
lin eta'a'ntya'_V = mkkV "etääntyä" ;
lin EU_Adv = mkkAdv "EU" ;
lin eufemismi_N = mkkN "eufemismi" ;
lin eufemistinen_A = mkkA "eufemistinen" ;
lin eufemistisesti_Adv = mkkAdv "eufemistisesti" ;
lin euforia_N = mkkN "euforia" ;
lin euforinen_A = mkkA "euforinen" ;
lin euforisesti_Adv = mkkAdv "euforisesti" ;
lin eukalyptus_N = mkkN "eukalyptus" ;
lin eukko_N = mkkN "eukko" ;
lin eukkonen_Adv = mkkAdv "eukkonen" ;
lin euklidinen_N = mkkN "euklidinen" ;
lin eunukki_N = mkkN "eunukki" ;
lin euraasialainen_N = mkkN "euraasialainen" ;
lin euroaika_N = mkkN "euroaika" ;
lin euroatlanttinen_N = mkkN "euroatlanttinen" ;
lin eurokraatti_N = mkkN "eurokraatti" ;
lin eurooppalainen_N = mkkN "eurooppalainen" ;
lin eurooppalaistua_V = mkkV "eurooppalaistua" ;
lin eurooppalaisuus_N = mkkN "eurooppalaisuus" ;
lin europidinen_N = mkkN "europidinen" ;
lin eurosentrismi_N = mkkN "eurosentrismi" ;
lin eurytmia_N = mkkN "eurytmia" ;
lin eutanasia_N = mkkN "eutanasia" ;
lin evakko_N = mkkN "evakko" ;
lin evakkous_N = mkkN "evakkous" ;
lin evakuoida_V = mkkV "evakuoida" ;
lin evakuointi_N = mkkN "evakuointi" ;
lin evaluoida_V = mkkV "evaluoida" ;
lin evaluointi_N = mkkN "evaluointi" ;
lin evankelinen_N = mkkN "evankelinen" ;
lin evankelioida_V = mkkV "evankelioida" ;
lin evankeliointi_N = mkkN "evankeliointi" ;
lin evankelista_N = mkkN "evankelista" ;
lin evankeliumi_N = mkkN "evankeliumi" ;
lin evergreen_N = mkkN "evergreen" ;
lin eversti_N = mkkN "eversti" ;
lin evidenssi_N = mkkN "evidenssi" ;
lin evidentti_N = mkkN "evidentti" ;
lin evoluutio_N = mkkN "evoluutio" ;
lin eva'_N = mkkN "evä" ;
lin eva's_N = mkkN "eväs" ;
lin eva'stella'_V = mkkV "evästellä" ;
lin eva'stys_N = mkkN "evästys" ;
lin eva'sta'a'_V = mkkV "evästää" ;
lin eva'ta'_V = mkkV "evätä" ;
lin exlibris_N = mkkN "exlibris" ;
lin ex_tempore_Adv = mkkAdv "eC" ;
lin faabeli_N = mkkN "faabeli" ;
lin faarao_N = mkkN "faarao" ;
lin faasi_N = mkkN "faasi" ;
lin fabuloida_V = mkkV "fabuloida" ;
lin fabulointi_N = mkkN "fabulointi" ;
lin factoring_N = mkkN "factoring" ;
lin fagosyytti_N = mkkN "fagosyytti" ;
lin fagotisti_N = mkkN "fagotisti" ;
lin fagotti_N = mkkN "fagotti" ;
lin faija_N = mkkN "faija" ;
lin fajanssi_N = mkkN "fajanssi" ;
lin fakiiri_N = mkkN "fakiiri" ;
lin fakki_N = mkkN "fakki" ;
lin fakkiintua_V = mkkV "fakkiintua" ;
lin fakkiutua_V = mkkV "fakkiutua" ;
lin faksata_V = mkkV "faksata" ;
lin faksi_N = mkkN "faksi" ;
lin faksimile_N = mkkN "faksimile" ;
lin fakta_N = mkkN "fakta" ;
lin faktinen_A = mkkA "faktinen" ;
lin faktisesti_Adv = mkkAdv "faktisesti" ;
lin faktori_N = mkkN "faktori" ;
lin faktuura_N = mkkN "faktuura" ;
lin fakultatiivinen_A = mkkA "fakultatiivinen" ;
lin fakultatiivisesti_Adv = mkkAdv "fakultatiivisesti" ;
lin fakultatiivisuus_N = mkkN "fakultatiivisuus" ;
lin falangi_N = mkkN "falangi" ;
lin falangisti_N = mkkN "falangisti" ;
lin fallinen_N = mkkN "fallinen" ;
lin fallos_N = mkkN "fallos" ;
lin falsetti_N = mkkN "falsetti" ;
lin falsifioida_V = mkkV "falsifioida" ;
lin falsifiointi_N = mkkN "falsifiointi" ;
lin falskata_V = mkkV "falskata" ;
lin falski_A = mkkA "falski" ;
lin falskisti_Adv = mkkAdv "falskisti" ;
lin falskius_N = mkkN "falskius" ;
lin fan_N = mkkN "fan" ;
lin fanaatikko_N = mkkN "fanaatikko" ;
lin fanaattinen_A = mkkA "fanaattinen" ;
lin fanaattisesti_Adv = mkkAdv "fanaattisesti" ;
lin fanaattisuus_N = mkkN "fanaattisuus" ;
lin fanatismi_N = mkkN "fanatismi" ;
lin fan_club_N = mkkN "faC" ;
lin faneeri_N = mkkN "faneeri" ;
lin fanfaari_N = mkkN "fanfaari" ;
lin fani_N = mkkN "fani" ;
lin fantasia_N = mkkN "fantasia" ;
lin fantastinen_A = mkkA "fantastinen" ;
lin fantastisesti_Adv = mkkAdv "fantastisesti" ;
lin fantastisuus_N = mkkN "fantastisuus" ;
lin fantisoida_V = mkkV "fantisoida" ;
lin fantisointi_N = mkkN "fantisointi" ;
lin faradi_N = mkkN "faradi" ;
lin farao_N = mkkN "farao" ;
lin farisealainen_N = mkkN "farisealainen" ;
lin farisealaisuus_N = mkkN "farisealaisuus" ;
lin fariseus_N = mkkN "fariseus" ;
lin farkkukangas_N = mkkN "farkkukangas" ;
--? lin farkut_NK = {s = d01A "farkut" ;
lin farmakologia_N = mkkN "farmakologia" ;
lin farmakologinen_A = mkkA "farmakologinen" ;
lin farmakologisesti_Adv = mkkAdv "farmakologisesti" ;
lin farmanomi_N = mkkN "farmanomi" ;
lin farmari_N = mkkN "farmari" ;
lin farmaseutti_N = mkkN "farmaseutti" ;
lin farmasia_N = mkkN "farmasia" ;
lin farmi_N = mkkN "farmi" ;
lin farssi_N = mkkN "farssi" ;
lin fasaani_N = mkkN "fasaani" ;
lin fasadi_N = mkkN "fasadi" ;
lin fasismi_N = mkkN "fasismi" ;
lin fasisti_N = mkkN "fasisti" ;
lin fasistinen_N = mkkN "fasistinen" ;
lin fast_food_N = mkkN "fasC" ;
lin fataali_A = mkkA "fataali" ;
lin fataalinen_A = mkkA "fataalinen" ;
lin fataalisesti_Adv = mkkAdv "fataalisesti" ;
lin fataalisti_Adv = mkkAdv "fataalisti" ;
lin fataalisuus_N = mkkN "fataalisuus" ;
lin fataalius_N = mkkN "fataalius" ;
lin fatalismi_N = mkkN "fatalismi" ;
lin fatalisti_N = mkkN "fatalisti" ;
lin fatalistinen_A = mkkA "fatalistinen" ;
lin fatalistisesti_Adv = mkkAdv "fatalistisesti" ;
lin fatalistisuus_N = mkkN "fatalistisuus" ;
lin fatsi_N = mkkN "fatsi" ;
lin fauna_N = mkkN "fauna" ;
lin fauni_N = mkkN "fauni" ;
lin federaatio_N = mkkN "federaatio" ;
lin federalismi_N = mkkN "federalismi" ;
lin federalistinen_N = mkkN "federalistinen" ;
lin federatiivinen_N = mkkN "federatiivinen" ;
lin feedback_N = mkkN "feedback" ;
lin feeniks_N = mkkN "feeniks" ;
lin feijoa_N = mkkN "feijoa" ;
lin femakko_N = mkkN "femakko" ;
lin feminiini_N = mkkN "feminiini" ;
lin feminiininen_A = mkkA "feminiininen" ;
lin feminiinisesti_Adv = mkkAdv "feminiinisesti" ;
lin feminiinisyys_N = mkkN "feminiinisyys" ;
lin feminismi_N = mkkN "feminismi" ;
lin feministi_N = mkkN "feministi" ;
lin feministinen_A = mkkA "feministinen" ;
lin feministisesti_Adv = mkkAdv "feministisesti" ;
lin fenkoli_1_N = mkkN "fenkoli" ;
lin fenkoli_2_N = mkkN "fenkoli" ;
lin fennismi_N = mkkN "fennismi" ;
lin fennisti_N = mkkN "fennisti" ;
lin fennistiikka_N = mkkN "fennistiikka" ;
lin fennistinen_A = mkkA "fennistinen" ;
lin fennistisesti_Adv = mkkAdv "fennistisesti" ;
lin fennistisyys_N = mkkN "fennistisyys" ;
lin fennofiili_N = mkkN "fennofiili" ;
lin fennomaani_N = mkkN "fennomaani" ;
lin fennomania_N = mkkN "fennomania" ;
lin fennougristi_N = mkkN "fennougristi" ;
lin fennougristiikka_N = mkkN "fennougristiikka" ;
lin fenoli_N = mkkN "fenoli" ;
lin fenomenaalinen_A = mkkA "fenomenaalinen" ;
lin fenomenaalisesti_Adv = mkkAdv "fenomenaalisesti" ;
lin fenomenaalisuus_N = mkkN "fenomenaalisuus" ;
lin fenomenologia_N = mkkN "fenomenologia" ;
lin fenomenologinen_A = mkkA "fenomenologinen" ;
lin fenomenologisesti_Adv = mkkAdv "fenomenologisesti" ;
lin feodaalinen_A = mkkA "feodaalinen" ;
lin feodaalisesti_Adv = mkkAdv "feodaalisesti" ;
lin feodaalisuus_N = mkkN "feodaalisuus" ;
lin feodalismi_N = mkkN "feodalismi" ;
lin feodalistinen_A = mkkA "feodalistinen" ;
lin feodalistisesti_Adv = mkkAdv "feodalistisesti" ;
lin feodalistisuus_N = mkkN "feodalistisuus" ;
lin fermaatti_N = mkkN "fermaatti" ;
lin ferriitti_N = mkkN "ferriitti" ;
lin ferrioksidi_N = mkkN "ferrioksidi" ;
lin ferrokloridi_N = mkkN "ferrokloridi" ;
lin fertiili_N = mkkN "fertiili" ;
lin fertiiliys_N = mkkN "fertiiliys" ;
lin fertiliteetti_N = mkkN "fertiliteetti" ;
lin festari_N = mkkN "festari" ;
lin festivaali_N = mkkN "festivaali" ;
lin feta_N = mkkN "feta" ;
lin fetisismi_N = mkkN "fetisismi" ;
lin fetisisti_N = mkkN "fetisisti" ;
lin fetisistinen_N = mkkN "fetisistinen" ;
lin fetissi_N = mkkN "fetissi" ;
lin fiasko_N = mkkN "fiasko" ;
lin fiba_N = mkkN "fiba" ;
lin fibata_V = mkkV "fibata" ;
lin fibaus_N = mkkN "fibaus" ;
lin fibriini_N = mkkN "fibriini" ;
lin fiesta_N = mkkN "fiesta" ;
lin fifty_fifty_Adv = mkkAdv "fifty-fifty" ;
lin figuratiivinen_A = mkkA "figuratiivinen" ;
lin figuratiivisesti_Adv = mkkAdv "figuratiivisesti" ;
lin figuratiivisuus_N = mkkN "figuratiivisuus" ;
lin figuuri_N = mkkN "figuuri" ;
lin fiiberi_N = mkkN "fiiberi" ;
lin fiikus_N = mkkN "fiikus" ;
lin fiilinki_N = mkkN "fiilinki" ;
lin fiilis_N = mkkN "fiilis" ;
lin fiini_N = mkkN "fiini" ;
lin fikka_N = mkkN "fikka" ;
lin fikkari_N = mkkN "fikkari" ;
lin fiksaatio_N = mkkN "fiksaatio" ;
lin fiksatiivi_N = mkkN "fiksatiivi" ;
lin fikseerata_V = mkkV "fikseerata" ;
lin fikseeraus_N = mkkN "fikseeraus" ;
lin fiksoida_V = mkkV "fiksoida" ;
lin fiksointi_N = mkkN "fiksointi" ;
lin fiksoitua_V = mkkV "fiksoitua" ;
lin fiksu_A = mkkA "fiksu" ;
lin fiksusti_Adv = mkkAdv "fiksusti" ;
lin fiksuus_N = mkkN "fiksuus" ;
lin fiktiivinen_A = mkkA "fiktiivinen" ;
lin fiktiivisesti_Adv = mkkAdv "fiktiivisesti" ;
lin fiktiivisyys_N = mkkN "fiktiivisyys" ;
lin fiktio_N = mkkN "fiktio" ;
lin filamentti_N = mkkN "filamentti" ;
lin filantrooppi_N = mkkN "filantrooppi" ;
lin filantrooppinen_A = mkkA "filantrooppinen" ;
lin filantrooppisesti_Adv = mkkAdv "filantrooppisesti" ;
lin filantropia_N = mkkN "filantropia" ;
lin filateelinen_N = mkkN "filateelinen" ;
lin filatelia_N = mkkN "filatelia" ;
lin filatelisti_N = mkkN "filatelisti" ;
lin filee_N = mkkN "filee" ;
lin fileerata_V = mkkV "fileerata" ;
lin fileeraus_N = mkkN "fileeraus" ;
lin fileoida_V = mkkV "fileoida" ;
lin fileointi_N = mkkN "fileointi" ;
lin filharmonikko_N = mkkN "filharmonikko" ;
lin filharmoninen_N = mkkN "filharmoninen" ;
lin filigraani_N = mkkN "filigraani" ;
lin filistealainen_N = mkkN "filistealainen" ;
lin fillari_N = mkkN "fillari" ;
lin fillaroida_V = mkkV "fillaroida" ;
lin fillarointi_N = mkkN "fillarointi" ;
lin filmaaja_N = mkkN "filmaaja" ;
lin filmaattinen_A = mkkA "filmaattinen" ;
lin filmaattisesti_Adv = mkkAdv "filmaattisesti" ;
lin filmaattisuus_N = mkkN "filmaattisuus" ;
lin filmata_V = mkkV "filmata" ;
lin filmatisoida_V = mkkV "filmatisoida" ;
lin filmatisointi_N = mkkN "filmatisointi" ;
lin filmaus_N = mkkN "filmaus" ;
lin filmi_N = mkkN "filmi" ;
lin filminno's_N = mkkN "filminnös" ;
lin filminta'a'_V = mkkV "filmintää" ;
lin filmografia_N = mkkN "filmografia" ;
lin filologi_N = mkkN "filologi" ;
lin filologia_N = mkkN "filologia" ;
lin filologinen_A = mkkA "filologinen" ;
lin filologisesti_Adv = mkkAdv "filologisesti" ;
lin filosofi_N = mkkN "filosofi" ;
lin filosofia_N = mkkN "filosofia" ;
lin filosofinen_A = mkkA "filosofinen" ;
lin filosofisesti_Adv = mkkAdv "filosofisesti" ;
lin filosofoida_V = mkkV "filosofoida" ;
lin filosofointi_N = mkkN "filosofointi" ;
lin filtrata_V = mkkV "filtrata" ;
lin filtraus_N = mkkN "filtraus" ;
lin filtteri_N = mkkN "filtteri" ;
lin filtti_N = mkkN "filtti" ;
lin filunki_N = mkkN "filunki" ;
lin filuri_N = mkkN "filuri" ;
lin finaali_N = mkkN "finaali" ;
lin finaalinen_A = mkkA "finaalinen" ;
lin finaalisesti_Adv = mkkAdv "finaalisesti" ;
lin finaalisuus_N = mkkN "finaalisuus" ;
lin finalisti_N = mkkN "finalisti" ;
lin finansioida_V = mkkV "finansioida" ;
lin finansiointi_N = mkkN "finansiointi" ;
lin finanssit_N = mkkN "finanssit" ;
lin finessi_N = mkkN "finessi" ;
lin fingelska_N = mkkN "fingelska" ;
lin fingerpori_N = mkkN "fingerpori" ;
lin fingerporillinen_N = mkkN "fingerporillinen" ;
lin fingliska_N = mkkN "fingliska" ;
lin finiittinen_N = mkkN "finiittinen" ;
lin finiittisyys_N = mkkN "finiittisyys" ;
lin finis_Adv = mkkAdv "finis" ;
lin finito_Adv = mkkAdv "finito" ;
lin finni_N = mkkN "finni" ;
lin finninen_N = mkkN "finninen" ;
lin firaabeli_N = mkkN "firaabeli" ;
lin firma_N = mkkN "firma" ;
lin fissio_N = mkkN "fissio" ;
lin fisteli_N = mkkN "fisteli" ;
lin flaami_N = mkkN "flaami" ;
lin flaksi_N = mkkN "flaksi" ;
lin flambeerata_V = mkkV "flambeerata" ;
lin flambeeraus_N = mkkN "flambeeraus" ;
lin flamenco_N = mkkN "flamenco" ;
lin flamingo_N = mkkN "flamingo" ;
lin flanelli_N = mkkN "flanelli" ;
lin flanellinen_N = mkkN "flanellinen" ;
lin flegmaatikko_N = mkkN "flegmaatikko" ;
lin flegmaattinen_A = mkkA "flegmaattinen" ;
lin flegmaattisesti_Adv = mkkAdv "flegmaattisesti" ;
lin flegmaattisuus_N = mkkN "flegmaattisuus" ;
lin flikka_N = mkkN "flikka" ;
lin flipperi_N = mkkN "flipperi" ;
lin flirtata_V = mkkV "flirtata" ;
lin flirttailla_V = mkkV "flirttailla" ;
lin flirttailu_N = mkkN "flirttailu" ;
lin flirttaus_N = mkkN "flirttaus" ;
lin flirtti_N = mkkN "flirtti" ;
lin flokki_N = mkkN "flokki" ;
lin floksi_N = mkkN "floksi" ;
lin floora_N = mkkN "floora" ;
lin flopata_V = mkkV "flopata" ;
lin floppi_N = mkkN "floppi" ;
lin floretti_N = mkkN "floretti" ;
lin floriini_N = mkkN "floriini" ;
lin floristi_N = mkkN "floristi" ;
lin flunssa_N = mkkN "flunssa" ;
lin flunssainen_N = mkkN "flunssainen" ;
lin fluorata_V = mkkV "fluorata" ;
lin fluoraus_N = mkkN "fluoraus" ;
lin fluoresenssi_N = mkkN "fluoresenssi" ;
lin fluoresoida_V = mkkV "fluoresoida" ;
lin fluori_N = mkkN "fluori" ;
lin fluorittaa_V = mkkV "fluorittaa" ;
lin fluoritus_N = mkkN "fluoritus" ;
lin fluoroida_V = mkkV "fluoroida" ;
lin fluorointi_N = mkkN "fluorointi" ;
lin flyygeli_N = mkkN "flyygeli" ;
lin fobia_N = mkkN "fobia" ;
lin foinikialainen_N = mkkN "foinikialainen" ;
lin fokka_N = mkkN "fokka" ;
lin foksi_N = mkkN "foksi" ;
lin fokstrotti_N = mkkN "fokstrotti" ;
lin fokus_N = mkkN "fokus" ;
lin fokusoida_V = mkkV "fokusoida" ;
lin fokusointi_N = mkkN "fokusointi" ;
lin folio_N = mkkN "folio" ;
lin folioida_V = mkkV "folioida" ;
lin foliointi_N = mkkN "foliointi" ;
lin foliokoko_N = mkkN "foliokoko" ;
lin folk_N = mkkN "folk" ;
lin folklore_N = mkkN "folklore" ;
lin folkloristi_N = mkkN "folkloristi" ;
lin folkloristiikka_N = mkkN "folkloristiikka" ;
lin follikkeli_N = mkkN "follikkeli" ;
lin fondue_N = mkkN "fondue" ;
lin fondyy_N = mkkN "fondyy" ;
lin foneemi_N = mkkN "foneemi" ;
lin foneetikko_N = mkkN "foneetikko" ;
lin foneettinen_A = mkkA "foneettinen" ;
lin foneettisesti_Adv = mkkAdv "foneettisesti" ;
lin fonetiikka_N = mkkN "fonetiikka" ;
lin foniatri_N = mkkN "foniatri" ;
lin foniatria_N = mkkN "foniatria" ;
lin foniatrinen_A = mkkA "foniatrinen" ;
lin foniatrisesti_Adv = mkkAdv "foniatrisesti" ;
lin fonologia_N = mkkN "fonologia" ;
lin fonologinen_A = mkkA "fonologinen" ;
lin fonologisesti_Adv = mkkAdv "fonologisesti" ;
lin fontanelli_N = mkkN "fontanelli" ;
lin foorumi_N = mkkN "foorumi" ;
lin force_majeure_N = mkkN "forcC" ;
lin forelli_N = mkkN "forelli" ;
lin formaali_A = mkkA "formaali" ;
lin formaalinen_A = mkkA "formaalinen" ;
lin formaalisesti_Adv = mkkAdv "formaalisesti" ;
lin formaalistaa_V = mkkV "formaalistaa" ;
lin formaalisti_Adv = mkkAdv "formaalisti" ;
lin formaalistus_N = mkkN "formaalistus" ;
lin formaalisuus_N = mkkN "formaalisuus" ;
lin formaalius_N = mkkN "formaalius" ;
lin formaatio_N = mkkN "formaatio" ;
lin formaatti_N = mkkN "formaatti" ;
lin formaldehydi_N = mkkN "formaldehydi" ;
lin formaliini_N = mkkN "formaliini" ;
lin formalismi_N = mkkN "formalismi" ;
lin formalisoida_V = mkkV "formalisoida" ;
lin formalisointi_N = mkkN "formalisointi" ;
lin formalisti_N = mkkN "formalisti" ;
lin formalistinen_A = mkkA "formalistinen" ;
lin formalistisesti_Adv = mkkAdv "formalistisesti" ;
lin formalistisuus_N = mkkN "formalistisuus" ;
lin formatiivinen_N = mkkN "formatiivinen" ;
lin formatoida_V = mkkV "formatoida" ;
lin formatointi_N = mkkN "formatointi" ;
lin formu_N = mkkN "formu" ;
lin formula_N = mkkN "formula" ;
lin formuloida_V = mkkV "formuloida" ;
lin formulointi_N = mkkN "formulointi" ;
lin forte_N = mkkN "forte" ;
lin fortissimo_N = mkkN "fortissimo" ;
lin fortuna_N = mkkN "fortuna" ;
lin fosfaatti_N = mkkN "fosfaatti" ;
lin fosfaattinen_N = mkkN "fosfaattinen" ;
lin fosforesenssi_N = mkkN "fosforesenssi" ;
lin fosforesoida_V = mkkV "fosforesoida" ;
lin fosfori_N = mkkN "fosfori" ;
lin fosforoida_V = mkkV "fosforoida" ;
lin fosforointi_N = mkkN "fosforointi" ;
lin fossiili_N = mkkN "fossiili" ;
lin fossiilinen_N = mkkN "fossiilinen" ;
lin fossiilistua_V = mkkV "fossiilistua" ;
lin fossilisoitua_V = mkkV "fossilisoitua" ;
lin foto_N = mkkN "foto" ;
lin fotoni_N = mkkN "fotoni" ;
lin fototypia_N = mkkN "fototypia" ;
lin fraasi_N = mkkN "fraasi" ;
lin fragmentaarinen_A = mkkA "fragmentaarinen" ;
lin fragmentaarisesti_Adv = mkkAdv "fragmentaarisesti" ;
lin fragmentaarisuus_N = mkkN "fragmentaarisuus" ;
lin fragmentti_N = mkkN "fragmentti" ;
lin frakki_N = mkkN "frakki" ;
lin fraktaali_N = mkkN "fraktaali" ;
lin fraktio_N = mkkN "fraktio" ;
lin fraktioida_V = mkkV "fraktioida" ;
lin fraktiointi_N = mkkN "fraktiointi" ;
lin fraktuura_N = mkkN "fraktuura" ;
lin framilla_Adv = mkkAdv "framilla" ;
lin framille_Adv = mkkAdv "framille" ;
lin franchising_N = mkkN "franchising" ;
lin frangi_N = mkkN "frangi" ;
lin frankeerata_V = mkkV "frankeerata" ;
lin frankeeraus_N = mkkN "frankeeraus" ;
lin frankki_N = mkkN "frankki" ;
lin franseesi_N = mkkN "franseesi" ;
lin fransiskaani_N = mkkN "fransiskaani" ;
lin fraseerata_V = mkkV "fraseerata" ;
lin fraseeraus_N = mkkN "fraseeraus" ;
lin fraseologia_N = mkkN "fraseologia" ;
lin fraseologinen_N = mkkN "fraseologinen" ;
lin freelance_N = mkkN "freelance" ;
lin freelancer_N = mkkN "freelancer" ;
lin freesia_N = mkkN "freesia" ;
lin freestyle_N = mkkN "freestyle" ;
lin fregatti_N = mkkN "fregatti" ;
lin frekvenssi_N = mkkN "frekvenssi" ;
lin frekvenssinen_N = mkkN "frekvenssinen" ;
lin frekventti_N = mkkN "frekventti" ;
lin freoni_N = mkkN "freoni" ;
lin fresko_N = mkkN "fresko" ;
lin freudilainen_N = mkkN "freudilainen" ;
lin freudilaisuus_N = mkkN "freudilaisuus" ;
lin frigidi_N = mkkN "frigidi" ;
lin frigiditeetti_N = mkkN "frigiditeetti" ;
lin frigidiys_N = mkkN "frigidiys" ;
lin friikki_N = mkkN "friikki" ;
lin friisi_1_N = mkkN "friisi" ;
lin friisi_2_N = mkkN "friisi" ;
lin friisila'inen_N = mkkN "friisiläinen" ;
lin frikadelli_N = mkkN "frikadelli" ;
lin frisbee_N = mkkN "frisbee" ;
lin frisyyri_N = mkkN "frisyyri" ;
lin friteerata_V = mkkV "friteerata" ;
lin friteeraus_N = mkkN "friteeraus" ;
lin fritsu_N = mkkN "fritsu" ;
lin frontaalinen_A = mkkA "frontaalinen" ;
lin frontaalisesti_Adv = mkkAdv "frontaalisesti" ;
lin frotee_N = mkkN "frotee" ;
lin froteinen_N = mkkN "froteinen" ;
lin fruktoosi_N = mkkN "fruktoosi" ;
lin frustraatio_N = mkkN "frustraatio" ;
lin frustroida_V = mkkV "frustroida" ;
lin frustroitua_V = mkkV "frustroitua" ;
lin fudata_V = mkkV "fudata" ;
lin fudia_V = mkkV "fudia" ;
lin fudis_N = mkkN "fudis" ;
--? lin fudut_NK = {s = d01 "fudut" ;
lin fuksi_N = mkkN "fuksi" ;
lin fundamentaalinen_A = mkkA "fundamentaalinen" ;
lin fundamentaalisesti_Adv = mkkAdv "fundamentaalisesti" ;
lin fundamentaalisuus_N = mkkN "fundamentaalisuus" ;
lin fundamentalismi_N = mkkN "fundamentalismi" ;
lin fundamentalisti_N = mkkN "fundamentalisti" ;
lin fundamentalistinen_A = mkkA "fundamentalistinen" ;
lin fundamentalistisesti_Adv = mkkAdv "fundamentalistisesti" ;
lin funkis_N = mkkN "funkis" ;
lin funkkis_N = mkkN "funkkis" ;
lin funktio_N = mkkN "funktio" ;
lin funktionaalinen_A = mkkA "funktionaalinen" ;
lin funktionaalisesti_Adv = mkkAdv "funktionaalisesti" ;
lin funktionaalisuus_N = mkkN "funktionaalisuus" ;
lin funktionalismi_N = mkkN "funktionalismi" ;
lin funktionalistinen_A = mkkA "funktionalistinen" ;
lin funktionalistisesti_Adv = mkkAdv "funktionalistisesti" ;
lin funktionalistisuus_N = mkkN "funktionalistisuus" ;
lin funtsata_V = mkkV "funtsata" ;
lin funtsaus_N = mkkN "funtsaus" ;
lin funtsia_V = mkkV "funtsia" ;
lin fuskata_V = mkkV "fuskata" ;
lin fuskaus_N = mkkN "fuskaus" ;
lin fusku_N = mkkN "fusku" ;
lin futaaja_N = mkkN "futaaja" ;
lin futata_V = mkkV "futata" ;
lin futia_V = mkkV "futia" ;
lin futis_N = mkkN "futis" ;
lin futurismi_N = mkkN "futurismi" ;
lin futuristinen_N = mkkN "futuristinen" ;
lin futuristisuus_N = mkkN "futuristisuus" ;
lin futurologi_N = mkkN "futurologi" ;
lin futurologia_N = mkkN "futurologia" ;
lin futurologinen_A = mkkA "futurologinen" ;
lin futurologisesti_Adv = mkkAdv "futurologisesti" ;
lin futuuri_N = mkkN "futuuri" ;
lin fuuga_N = mkkN "fuuga" ;
lin fuusio_N = mkkN "fuusio" ;
lin fuusioida_V = mkkV "fuusioida" ;
lin fuusiointi_N = mkkN "fuusiointi" ;
lin fuusioitua_V = mkkV "fuusioitua" ;
lin fylli_N = mkkN "fylli" ;
lin fylogeneesi_N = mkkN "fylogeneesi" ;
lin fylogeneettisesti_Adv = mkkAdv "fylogeneettisesti" ;
lin fyrkka_N = mkkN "fyrkka" ;
lin fysiatri_N = mkkN "fysiatri" ;
lin fysiatria_N = mkkN "fysiatria" ;
lin fysiatrinen_A = mkkA "fysiatrinen" ;
lin fysiatrisesti_Adv = mkkAdv "fysiatrisesti" ;
lin fysiikka_N = mkkN "fysiikka" ;
lin fysikaalinen_A = mkkA "fysikaalinen" ;
lin fysikaalisesti_Adv = mkkAdv "fysikaalisesti" ;
lin fysiologi_N = mkkN "fysiologi" ;
lin fysiologia_N = mkkN "fysiologia" ;
lin fysiologinen_A = mkkA "fysiologinen" ;
lin fysiologisesti_Adv = mkkAdv "fysiologisesti" ;
lin fysiologisuus_N = mkkN "fysiologisuus" ;
lin fytonomi_N = mkkN "fytonomi" ;
lin fyysikko_N = mkkN "fyysikko" ;
lin fyysinen_A = mkkA "fyysinen" ;
lin fyysisesti_Adv = mkkAdv "fyysisesti" ;
lin fyysisyys_N = mkkN "fyysisyys" ;
lin fa'a'ri_N = mkkN "fääri" ;
lin fo'rskotti_N = mkkN "förskotti" ;
lin fo'o'nata_V = mkkV "föönata" ;
lin fo'o'naus_N = mkkN "föönaus" ;
lin fo'o'ni_N = mkkN "fööni" ;
lin gaala_N = mkkN "gaala" ;
lin gabardiini_N = mkkN "gabardiini" ;
lin gabro_N = mkkN "gabro" ;
lin gaeli_N = mkkN "gaeli" ;
lin galaksi_N = mkkN "galaksi" ;
lin galleria_N = mkkN "galleria" ;
lin galleristi_N = mkkN "galleristi" ;
lin gallialainen_N = mkkN "gallialainen" ;
lin gallialaisuus_N = mkkN "gallialaisuus" ;
lin gallona_N = mkkN "gallona" ;
lin gallup_N = mkkN "gallup" ;
lin gallupoida_V = mkkV "gallupoida" ;
lin gallupointi_N = mkkN "gallupointi" ;
lin galvaaninen_A = mkkA "galvaaninen" ;
lin galvaanisesti_Adv = mkkAdv "galvaanisesti" ;
lin galvanoida_V = mkkV "galvanoida" ;
lin galvanointi_N = mkkN "galvanointi" ;
lin gambiitti_N = mkkN "gambiitti" ;
lin gameetti_N = mkkN "gameetti" ;
lin gamma_N = mkkN "gamma" ;
lin gammaglobuliini_N = mkkN "gammaglobuliini" ;
lin ganglio_N = mkkN "ganglio" ;
lin gangsteri_N = mkkN "gangsteri" ;
lin gangsterismi_N = mkkN "gangsterismi" ;
lin gardenia_N = mkkN "gardenia" ;
lin garderobi_N = mkkN "garderobi" ;
lin gaselli_N = mkkN "gaselli" ;
lin gasti_N = mkkN "gasti" ;
lin gastronomi_N = mkkN "gastronomi" ;
lin gastronomia_N = mkkN "gastronomia" ;
lin gastronominen_A = mkkA "gastronominen" ;
lin gastronomisesti_Adv = mkkAdv "gastronomisesti" ;
lin gastrula_N = mkkN "gastrula" ;
lin gaucho_N = mkkN "gaucho" ;
lin gaullelainen_N = mkkN "gaullelainen" ;
lin gaullismi_N = mkkN "gaullismi" ;
lin gaullisti_N = mkkN "gaullisti" ;
lin gaullistinen_N = mkkN "gaullistinen" ;
lin gay_N = mkkN "gay" ;
lin geeli_N = mkkN "geeli" ;
lin geeni_N = mkkN "geeni" ;
lin geenimuokattu_N = mkkN "geenimuokattu" ;
lin geenisto'_N = mkkN "geenistö" ;
lin geimit_N = mkkN "geimit" ;
lin gei_a_N = mkkN "geiša" ;
lin geisir_N = mkkN "geisir" ;
lin gelatiini_N = mkkN "gelatiini" ;
lin geminaatta_N = mkkN "geminaatta" ;
lin gemmologi_N = mkkN "gemmologi" ;
lin gemmologia_N = mkkN "gemmologia" ;
lin gemmologinen_A = mkkA "gemmologinen" ;
lin gemmologisesti_Adv = mkkAdv "gemmologisesti" ;
lin genealogia_N = mkkN "genealogia" ;
lin geneetikko_N = mkkN "geneetikko" ;
lin geneettinen_A = mkkA "geneettinen" ;
lin geneettisesti_Adv = mkkAdv "geneettisesti" ;
lin generaattori_N = mkkN "generaattori" ;
lin generalissimus_N = mkkN "generalissimus" ;
lin generoida_V = mkkV "generoida" ;
lin generointi_N = mkkN "generointi" ;
lin genetiikka_N = mkkN "genetiikka" ;
lin genetiivi_N = mkkN "genetiivi" ;
lin genever_N = mkkN "genever" ;
lin genitaalinen_N = mkkN "genitaalinen" ;
lin genitaalit_N = mkkN "genitaalit" ;
lin genomi_N = mkkN "genomi" ;
lin genre_N = mkkN "genre" ;
lin gentlemanni_N = mkkN "gentlemanni" ;
lin geodeetti_N = mkkN "geodeetti" ;
lin geodeettinen_A = mkkA "geodeettinen" ;
lin geodeettisesti_Adv = mkkAdv "geodeettisesti" ;
lin geodesia_N = mkkN "geodesia" ;
lin geografia_N = mkkN "geografia" ;
lin geologi_N = mkkN "geologi" ;
lin geologia_N = mkkN "geologia" ;
lin geologinen_A = mkkA "geologinen" ;
lin geologisesti_Adv = mkkAdv "geologisesti" ;
lin geometria_N = mkkN "geometria" ;
lin geometrinen_A = mkkA "geometrinen" ;
lin geometrisesti_Adv = mkkAdv "geometrisesti" ;
lin geometrisuus_N = mkkN "geometrisuus" ;
lin geomorfologisesti_Adv = mkkAdv "geomorfologisesti" ;
lin geosentrinen_N = mkkN "geosentrinen" ;
lin gepardi_N = mkkN "gepardi" ;
lin gerbera_N = mkkN "gerbera" ;
lin gerbiili_N = mkkN "gerbiili" ;
lin gerbilli_N = mkkN "gerbilli" ;
lin geriatria_N = mkkN "geriatria" ;
lin geriatrinen_A = mkkA "geriatrinen" ;
lin geriatrisesti_Adv = mkkAdv "geriatrisesti" ;
lin germaani_N = mkkN "germaani" ;
lin germaaninen_N = mkkN "germaaninen" ;
lin germanisti_N = mkkN "germanisti" ;
lin germanistiikka_N = mkkN "germanistiikka" ;
lin gerontologia_N = mkkN "gerontologia" ;
lin gerontologinen_N = mkkN "gerontologinen" ;
lin getto_N = mkkN "getto" ;
lin gettoistua_V = mkkV "gettoistua" ;
lin gettoutua_V = mkkV "gettoutua" ;
lin geysir_N = mkkN "geysir" ;
lin ghetto_N = mkkN "ghetto" ;
lin ghettoutua_V = mkkV "ghettoutua" ;
lin gibboni_N = mkkN "gibboni" ;
lin giganttinen_A = mkkA "giganttinen" ;
lin giganttisesti_Adv = mkkAdv "giganttisesti" ;
lin giganttisuus_N = mkkN "giganttisuus" ;
lin gigolo_N = mkkN "gigolo" ;
lin giljotiini_N = mkkN "giljotiini" ;
lin gimma_N = mkkN "gimma" ;
lin ginger_ale_N = mkkN "gingeC" ;
lin gini_N = mkkN "gini" ;
lin ginsengjuuri_N = mkkN "ginsengjuuri" ;
lin gladiaattori_N = mkkN "gladiaattori" ;
lin gladiolus_N = mkkN "gladiolus" ;
lin glamour_N = mkkN "glamour" ;
lin glaseerata_V = mkkV "glaseerata" ;
lin glaseeraus_N = mkkN "glaseeraus" ;
lin glasiaalinen_N = mkkN "glasiaalinen" ;
lin glasnost_N = mkkN "glasnost" ;
lin glaukooma_N = mkkN "glaukooma" ;
lin glencheck_N = mkkN "glencheck" ;
lin globaali_A = mkkA "globaali" ;
lin globaalinen_A = mkkA "globaalinen" ;
lin globaalisesti_Adv = mkkAdv "globaalisesti" ;
lin globaalistaa_V = mkkV "globaalistaa" ;
lin globaalisti_Adv = mkkAdv "globaalisti" ;
lin globaalistua_V = mkkV "globaalistua" ;
lin globaalisuus_N = mkkN "globaalisuus" ;
lin globalisoitua_V = mkkV "globalisoitua" ;
lin gloksinia_N = mkkN "gloksinia" ;
lin glooria_N = mkkN "glooria" ;
lin gloria_N = mkkN "gloria" ;
lin glukoosi_N = mkkN "glukoosi" ;
lin gluteeni_N = mkkN "gluteeni" ;
lin gluteeniton_N = mkkN "gluteeniton" ;
lin glyseriini_N = mkkN "glyseriini" ;
lin glyseroli_N = mkkN "glyseroli" ;
lin glo'gi_N = mkkN "glögi" ;
lin gneissi_N = mkkN "gneissi" ;
lin gnostikko_N = mkkN "gnostikko" ;
lin gnostilainen_N = mkkN "gnostilainen" ;
lin gnostilaisuus_N = mkkN "gnostilaisuus" ;
lin gnostisismi_N = mkkN "gnostisismi" ;
lin gnostisistinen_A = mkkA "gnostisistinen" ;
lin gnostisistisesti_Adv = mkkAdv "gnostisistisesti" ;
lin gnuu_N = mkkN "gnuu" ;
lin gobeliini_N = mkkN "gobeliini" ;
lin go_go_N = mkkN "go-go" ;
lin golf_N = mkkN "golf" ;
lin golfaaja_N = mkkN "golfaaja" ;
lin golfata_V = mkkV "golfata" ;
lin golffari_N = mkkN "golffari" ;
lin goljatti_N = mkkN "goljatti" ;
lin gondoli_N = mkkN "gondoli" ;
lin gondolieeri_N = mkkN "gondolieeri" ;
lin gonggongi_N = mkkN "gonggongi" ;
lin gongi_N = mkkN "gongi" ;
lin gonokokki_N = mkkN "gonokokki" ;
lin gonorrea_N = mkkN "gonorrea" ;
lin goodwill_N = mkkN "goodwill" ;
lin gootti_N = mkkN "gootti" ;
lin goottilaisuus_N = mkkN "goottilaisuus" ;
lin gorgonzola_N = mkkN "gorgonzola" ;
lin gorilla_N = mkkN "gorilla" ;
lin gospel_N = mkkN "gospel" ;
lin gotiikka_N = mkkN "gotiikka" ;
lin gouda_N = mkkN "gouda" ;
--? lin gourmet_NK = {s = d22 "gourmet" ;
lin graafikko_N = mkkN "graafikko" ;
lin graafinen_A = mkkA "graafinen" ;
lin graafisesti_Adv = mkkAdv "graafisesti" ;
lin graavata_V = mkkV "graavata" ;
lin graavi_N = mkkN "graavi" ;
lin gradu_N = mkkN "gradu" ;
lin graffiti_N = mkkN "graffiti" ;
lin grafiikka_N = mkkN "grafiikka" ;
lin grafiitti_N = mkkN "grafiitti" ;
lin grafologi_N = mkkN "grafologi" ;
lin grafologia_N = mkkN "grafologia" ;
lin grafologinen_A = mkkA "grafologinen" ;
lin grafologisesti_Adv = mkkAdv "grafologisesti" ;
lin grahamkeksi_N = mkkN "grahamkeksi" ;
lin gramma_N = mkkN "gramma" ;
lin grammaattinen_A = mkkA "grammaattinen" ;
lin grammaattisesti_Adv = mkkAdv "grammaattisesti" ;
lin grammari_N = mkkN "grammari" ;
lin gramofoni_N = mkkN "gramofoni" ;
lin granaatti_N = mkkN "granaatti" ;
lin granadilla_N = mkkN "granadilla" ;
lin graniitti_N = mkkN "graniitti" ;
lin graniittinen_N = mkkN "graniittinen" ;
lin grape_N = mkkN "grape" ;
lin gratiini_N = mkkN "gratiini" ;
lin gratinoida_V = mkkV "gratinoida" ;
lin gratinointi_N = mkkN "gratinointi" ;
lin gratisti_N = mkkN "gratisti" ;
lin gravidi_N = mkkN "gravidi" ;
lin graviditeetti_N = mkkN "graviditeetti" ;
lin gravis_N = mkkN "gravis" ;
lin gravitaatio_N = mkkN "gravitaatio" ;
lin gray_N = mkkN "gray" ;
lin gregoriaaninen_N = mkkN "gregoriaaninen" ;
lin greippi_N = mkkN "greippi" ;
lin griljeerata_V = mkkV "griljeerata" ;
lin grillata_V = mkkV "grillata" ;
lin grillaus_N = mkkN "grillaus" ;
lin grilli_N = mkkN "grilli" ;
lin grogi_N = mkkN "grogi" ;
lin groteski_N = mkkN "groteski" ;
lin gruy_re_N = mkkN "gruyère" ;
lin gryndata_V = mkkV "gryndata" ;
lin gryndaus_N = mkkN "gryndaus" ;
lin grynderi_N = mkkN "grynderi" ;
lin gro'nlanti_N = mkkN "grönlanti" ;
lin guano_N = mkkN "guano" ;
lin guassi_N = mkkN "guassi" ;
lin guava_N = mkkN "guava" ;
lin gulassi_N = mkkN "gulassi" ;
lin guldeni_N = mkkN "guldeni" ;
lin gurmee_N = mkkN "gurmee" ;
lin guru_N = mkkN "guru" ;
lin guttaperkka_N = mkkN "guttaperkka" ;
lin gynekologi_N = mkkN "gynekologi" ;
lin gynekologia_N = mkkN "gynekologia" ;
lin gynekologinen_N = mkkN "gynekologinen" ;
lin gyrokopteri_N = mkkN "gyrokopteri" ;
lin gyroskooppi_N = mkkN "gyroskooppi" ;
lin ga'ngi_N = mkkN "gängi" ;
lin ha_Adv = mkkAdv "ha" ;
lin haa_Adv = mkkAdv "haa" ;
lin haahka_N = mkkN "haahka" ;
lin haahti_N = mkkN "haahti" ;
lin haahuilla_V = mkkV "haahuilla" ;
lin haaksi_N = mkkN "haaksi" ;
lin haaksirikkoinen_N = mkkN "haaksirikkoinen" ;
lin haaksirikkoutua_V = mkkV "haaksirikkoutua" ;
lin haalata_V = mkkV "haalata" ;
lin haalea_N = mkkN "haalea" ;
lin haalentaa_V = mkkV "haalentaa" ;
lin haalentua_V = mkkV "haalentua" ;
lin haaleta_V = mkkV "haaleta" ;
lin haaleus_N = mkkN "haaleus" ;
lin haalia_V = mkkV "haalia" ;
lin haalistaa_V = mkkV "haalistaa" ;
lin haalistua_V = mkkV "haalistua" ;
lin haaltua_V = mkkV "haaltua" ;
lin haamilainen_N = mkkN "haamilainen" ;
lin haamu_N = mkkN "haamu" ;
lin haapa_N = mkkN "haapa" ;
lin haapainen_N = mkkN "haapainen" ;
lin haapana_N = mkkN "haapana" ;
lin haara_N = mkkN "haara" ;
lin haaraantua_V = mkkV "haaraantua" ;
lin haarainen_N = mkkN "haarainen" ;
lin haarake_N = mkkN "haarake" ;
lin haarakkeinen_N = mkkN "haarakkeinen" ;
lin haarallaan_Adv = mkkAdv "haarallaan" ;
lin haarauma_N = mkkN "haarauma" ;
lin haarautua_V = mkkV "haarautua" ;
lin haarautuma_N = mkkN "haarautuma" ;
lin haarautumiskohta_N = mkkN "haarautumiskohta" ;
lin haaremi_N = mkkN "haaremi" ;
lin haarniska_N = mkkN "haarniska" ;
lin haarniskoida_V = mkkV "haarniskoida" ;
lin haaroa_V = mkkV "haaroa" ;
lin haaroittaa_V = mkkV "haaroittaa" ;
lin haaroittua_V = mkkV "haaroittua" ;
lin haaroitus_N = mkkN "haaroitus" ;
lin haarottaa_V = mkkV "haarottaa" ;
lin haarukoida_V = mkkV "haarukoida" ;
lin haarukointi_N = mkkN "haarukointi" ;
lin haasia_N = mkkN "haasia" ;
lin haasioida_V = mkkV "haasioida" ;
lin haaska_N = mkkN "haaska" ;
lin haaskaantua_V = mkkV "haaskaantua" ;
lin haaskata_V = mkkV "haaskata" ;
lin haaskaus_N = mkkN "haaskaus" ;
lin haaskautua_V = mkkV "haaskautua" ;
lin haaskio_N = mkkN "haaskio" ;
lin haaskuu_N = mkkN "haaskuu" ;
lin haastaa_V = mkkV "haastaa" ;
lin haastaja_N = mkkN "haastaja" ;
lin haastatella_V = mkkV "haastatella" ;
lin haastateltava_N = mkkN "haastateltava" ;
lin haastattaa_V = mkkV "haastattaa" ;
lin haastattelija_N = mkkN "haastattelija" ;
lin haastattelu_N = mkkN "haastattelu" ;
lin haastava_N = mkkN "haastava" ;
lin haastavuus_N = mkkN "haastavuus" ;
lin haaste_N = mkkN "haaste" ;
lin haasteaika_N = mkkN "haasteaika" ;
lin haasteellinen_N = mkkN "haasteellinen" ;
lin haastella_V = mkkV "haastella" ;
lin haava_1_N = mkkN "haava" ;
lin haava_2_Adv = mkkAdv "haava" ;
lin haavainen_N = mkkN "haavainen" ;
lin haavakko_N = mkkN "haavakko" ;
lin haavauma_N = mkkN "haavauma" ;
lin haavautua_V = mkkV "haavautua" ;
lin haavautuma_N = mkkN "haavautuma" ;
lin haave_N = mkkN "haave" ;
lin haaveellinen_A = mkkA "haaveellinen" ;
lin haaveellisesti_Adv = mkkAdv "haaveellisesti" ;
lin haaveellisuus_N = mkkN "haaveellisuus" ;
lin haaveilija_N = mkkN "haaveilija" ;
lin haaveilla_V = mkkV "haaveilla" ;
lin haaveilu_N = mkkN "haaveilu" ;
lin haaveksia_V = mkkV "haaveksia" ;
lin haaveksija_N = mkkN "haaveksija" ;
lin haavi_N = mkkN "haavi" ;
lin haavia_V = mkkV "haavia" ;
lin haavikko_N = mkkN "haavikko" ;
lin haavisto_N = mkkN "haavisto" ;
lin haavoittaa_V = mkkV "haavoittaa" ;
lin haavoittua_V = mkkV "haavoittua" ;
lin haavoittuva_N = mkkN "haavoittuva" ;
lin haavoittuvuus_N = mkkN "haavoittuvuus" ;
lin haavuri_N = mkkN "haavuri" ;
lin habitaatti_N = mkkN "habitaatti" ;
lin habitus_N = mkkN "habitus" ;
lin hadroni_N = mkkN "hadroni" ;
lin haennainen_N = mkkN "haennainen" ;
lin haenta_N = mkkN "haenta" ;
lin haeskella_V = mkkV "haeskella" ;
lin haeskelu_N = mkkN "haeskelu" ;
lin haettaa_V = mkkV "haettaa" ;
lin haetuttaa_V = mkkV "haetuttaa" ;
lin hah_Adv = mkkAdv "hah" ;
lin hahattaa_V = mkkV "hahattaa" ;
lin hahlo_N = mkkN "hahlo" ;
lin hahmo_N = mkkN "hahmo" ;
lin hahmotella_V = mkkV "hahmotella" ;
lin hahmotelma_N = mkkN "hahmotelma" ;
lin hahmottaa_V = mkkV "hahmottaa" ;
lin hahmotteilla_Adv = mkkAdv "hahmotteilla" ;
lin hahmotteinen_N = mkkN "hahmotteinen" ;
lin hahmottelu_N = mkkN "hahmottelu" ;
lin hahmottua_V = mkkV "hahmottua" ;
lin hahmotus_N = mkkN "hahmotus" ;
lin hahmoutua_V = mkkV "hahmoutua" ;
lin hahtuva_N = mkkN "hahtuva" ;
lin hai_N = mkkN "hai" ;
lin haihatella_V = mkkV "haihatella" ;
lin haihattelija_N = mkkN "haihattelija" ;
lin haihattelu_N = mkkN "haihattelu" ;
lin haihdutin_N = mkkN "haihdutin" ;
lin haihduttaa_V = mkkV "haihduttaa" ;
lin haihduttamo_N = mkkN "haihduttamo" ;
lin haihdutus_N = mkkN "haihdutus" ;
lin haihtua_V = mkkV "haihtua" ;
lin haikailla_V = mkkV "haikailla" ;
lin haikailu_N = mkkN "haikailu" ;
lin haikea_A = mkkA "haikea" ;
lin haikeasti_Adv = mkkAdv "haikeasti" ;
lin haikeus_N = mkkN "haikeus" ;
lin haiku_1_N = mkkN "haiku" ;
lin haiku_2_N = mkkN "haiku" ;
lin hailakkuus_N = mkkN "hailakkuus" ;
lin hailea_N = mkkN "hailea" ;
lin haili_N = mkkN "haili" ;
lin haima_N = mkkN "haima" ;
lin haipua_V = mkkV "haipua" ;
lin hairahdus_N = mkkN "hairahdus" ;
lin hairahtaa_V = mkkV "hairahtaa" ;
lin hairahtua_V = mkkV "hairahtua" ;
lin hairahtuvainen_N = mkkN "hairahtuvainen" ;
lin haiskahtaa_V = mkkV "haiskahtaa" ;
lin haista_V = mkkV "haista" ;
lin haistaa_V = mkkV "haistaa" ;
lin haistatella_V = mkkV "haistatella" ;
lin haistattaa_V = mkkV "haistattaa" ;
lin haistattelu_N = mkkN "haistattelu" ;
lin haistella_V = mkkV "haistella" ;
lin haistelu_N = mkkN "haistelu" ;
lin haisti_N = mkkN "haisti" ;
lin haisu_N = mkkN "haisu" ;
lin haisuliini_N = mkkN "haisuliini" ;
lin haitallinen_A = mkkA "haitallinen" ;
lin haitallisesti_Adv = mkkAdv "haitallisesti" ;
lin haitallisuus_N = mkkN "haitallisuus" ;
lin haitari_N = mkkN "haitari" ;
lin haitata_V = mkkV "haitata" ;
lin haitattomasti_Adv = mkkAdv "haitattomasti" ;
lin haitattomuus_N = mkkN "haitattomuus" ;
lin haite_N = mkkN "haite" ;
lin haitek_N = mkkN "haitek" ;
lin haitekki_N = mkkN "haitekki" ;
lin haitta_N = mkkN "haitta" ;
lin haituva_N = mkkN "haituva" ;
lin haiven_N = mkkN "haiven" ;
lin haiveninen_N = mkkN "haiveninen" ;
lin hajaannus_N = mkkN "hajaannus" ;
lin hajaannuttaa_V = mkkV "hajaannuttaa" ;
lin hajaantua_V = mkkV "hajaantua" ;
lin hajahtaa_V = mkkV "hajahtaa" ;
lin hajakoko_N = mkkN "hajakoko" ;
lin hajalla_Adv = mkkAdv "hajalla" ;
lin hajallaan_Adv = mkkAdv "hajallaan" ;
lin hajalle_Adv = mkkAdv "hajalle" ;
lin hajalleen_Adv = mkkAdv "hajalleen" ;
lin hajallinen_N = mkkN "hajallinen" ;
lin hajamielisesti_Adv = mkkAdv "hajamielisesti" ;
lin hajanainen_A = mkkA "hajanainen" ;
lin hajanaisesti_Adv = mkkAdv "hajanaisesti" ;
lin hajanaisuus_N = mkkN "hajanaisuus" ;
lin hajareisin_Adv = mkkAdv "hajareisin" ;
lin hajasa'a'rin_Adv = mkkAdv "hajasäärin" ;
lin hajauma_N = mkkN "hajauma" ;
lin hajauttaa_V = mkkV "hajauttaa" ;
lin hajautua_V = mkkV "hajautua" ;
lin hajautuma_N = mkkN "hajautuma" ;
lin hajautus_N = mkkN "hajautus" ;
lin haje_N = mkkN "haje" ;
lin hajonta_N = mkkN "hajonta" ;
lin hajota_V = mkkV "hajota" ;
lin hajottaa_V = mkkV "hajottaa" ;
lin hajottaja_N = mkkN "hajottaja" ;
lin hajottamo_N = mkkN "hajottamo" ;
lin hajotus_N = mkkN "hajotus" ;
lin haju_N = mkkN "haju" ;
lin hajuinen_N = mkkN "hajuinen" ;
lin hajustaa_V = mkkV "hajustaa" ;
lin hajuste_N = mkkN "hajuste" ;
lin hajuton_N = mkkN "hajuton" ;
lin hajuttomasti_Adv = mkkAdv "hajuttomasti" ;
lin hajuttomuus_N = mkkN "hajuttomuus" ;
lin haka_1_N = mkkN "haka" ;
lin haka_2_N = mkkN "haka" ;
lin hakanen_N = mkkN "hakanen" ;
lin hakata_V = mkkV "hakata" ;
lin hakaus_N = mkkN "hakaus" ;
lin hakautua_V = mkkV "hakautua" ;
lin hake_N = mkkN "hake" ;
lin hakea_V = mkkV "hakea" ;
lin hakemisto_N = mkkN "hakemisto" ;
lin hakemus_N = mkkN "hakemus" ;
lin haketin_N = mkkN "haketin" ;
lin hakettaa_V = mkkV "hakettaa" ;
lin hakettamo_N = mkkN "hakettamo" ;
lin haketus_N = mkkN "haketus" ;
lin hakeutua_V = mkkV "hakeutua" ;
lin hakija_N = mkkN "hakija" ;
lin hakkaaja_N = mkkN "hakkaaja" ;
lin hakkaantua_V = mkkV "hakkaantua" ;
lin hakkailla_V = mkkV "hakkailla" ;
lin hakkailu_N = mkkN "hakkailu" ;
lin hakkapeliitta_N = mkkN "hakkapeliitta" ;
lin hakkaus_N = mkkN "hakkaus" ;
lin hakkauttaa_V = mkkV "hakkauttaa" ;
lin hakkautua_V = mkkV "hakkautua" ;
lin hakkelus_N = mkkN "hakkelus" ;
lin hakkeri_N = mkkN "hakkeri" ;
lin hakkeroida_V = mkkV "hakkeroida" ;
lin hakkerointi_N = mkkN "hakkerointi" ;
lin hakku_N = mkkN "hakku" ;
lin hakkuri_N = mkkN "hakkuri" ;
lin hakkuu_N = mkkN "hakkuu" ;
lin hakkuuttaa_V = mkkV "hakkuuttaa" ;
lin hako_N = mkkN "hako" ;
lin hakoteille_Adv = mkkAdv "hakoteille" ;
lin hakoteilla'_Adv = mkkAdv "hakoteillä" ;
lin haksahdus_N = mkkN "haksahdus" ;
lin haksahtaa_V = mkkV "haksahtaa" ;
lin haku_N = mkkN "haku" ;
lin hakuaika_N = mkkN "hakuaika" ;
lin hakuinen_A = mkkA "hakuinen" ;
lin hakuisesti_Adv = mkkAdv "hakuisesti" ;
lin hakuisuus_N = mkkN "hakuisuus" ;
lin hakusassa_Adv = mkkAdv "hakusassa" ;
lin halailla_V = mkkV "halailla" ;
lin halailu_N = mkkN "halailu" ;
lin halaista_V = mkkV "halaista" ;
lin halata_1_V = mkkV "halata" ;
lin halata_2_V = mkkV "halata" ;
lin halatti_N = mkkN "halatti" ;
lin halaus_N = mkkN "halaus" ;
lin halava_N = mkkN "halava" ;
lin halia_V = mkkV "halia" ;
lin halikkain_Adv = mkkAdv "halikkain" ;
lin haljakka_N = mkkN "haljakka" ;
lin haljas_N = mkkN "haljas" ;
lin haljeta_V = mkkV "haljeta" ;
lin halju_N = mkkN "halju" ;
lin halkaisija_N = mkkN "halkaisija" ;
lin halkaista_V = mkkV "halkaista" ;
lin halkaisu_N = mkkN "halkaisu" ;
lin halkeama_N = mkkN "halkeama" ;
lin halkeaminen_N = mkkN "halkeaminen" ;
lin halkeilla_V = mkkV "halkeilla" ;
lin halkeilu_N = mkkN "halkeilu" ;
lin halki_Adv = mkkAdv "halki" ;
lin halkio_N = mkkN "halkio" ;
lin halkioinen_N = mkkN "halkioinen" ;
lin halko_N = mkkN "halko" ;
lin halkoa_V = mkkV "halkoa" ;
lin halkoinen_N = mkkN "halkoinen" ;
lin halla_N = mkkN "halla" ;
lin hallainen_N = mkkN "hallainen" ;
lin hallanvaara_N = mkkN "hallanvaara" ;
lin hallava_N = mkkN "hallava" ;
lin halleluja_Adv = mkkAdv "halleluja" ;
lin halli_1_N = mkkN "halli" ;
lin halli_2_N = mkkN "halli" ;
lin hallinnoida_V = mkkV "hallinnoida" ;
lin hallinnollinen_A = mkkA "hallinnollinen" ;
lin hallinnollisesti_Adv = mkkAdv "hallinnollisesti" ;
lin hallinta_N = mkkN "hallinta" ;
lin hallinto_N = mkkN "hallinto" ;
lin hallita_V = mkkV "hallita" ;
lin hallitseva_N = mkkN "hallitseva" ;
lin hallitsevuus_N = mkkN "hallitsevuus" ;
lin hallitsija_N = mkkN "hallitsija" ;
lin hallittavuus_N = mkkN "hallittavuus" ;
lin hallittu_N = mkkN "hallittu" ;
lin hallitus_N = mkkN "hallitus" ;
lin hallitusaika_N = mkkN "hallitusaika" ;
lin hallitusti_Adv = mkkAdv "hallitusti" ;
lin hallusinaatio_N = mkkN "hallusinaatio" ;
lin hallusinatorinen_N = mkkN "hallusinatorinen" ;
lin hallusinogeeni_N = mkkN "hallusinogeeni" ;
lin hallussa_Adv = mkkAdv "hallussa" ;
lin hallusta_Adv = mkkAdv "hallusta" ;
lin halma_N = mkkN "halma" ;
lin halme_N = mkkN "halme" ;
lin halogeeni_N = mkkN "halogeeni" ;
lin haloo_N = mkkN "haloo" ;
lin halpa_N = mkkN "halpa" ;
lin halpamaisesti_Adv = mkkAdv "halpamaisesti" ;
lin halpamaisuus_N = mkkN "halpamaisuus" ;
lin halpuus_N = mkkN "halpuus" ;
lin halssi_N = mkkN "halssi" ;
lin halstari_N = mkkN "halstari" ;
lin halstaroida_V = mkkV "halstaroida" ;
lin halsteri_N = mkkN "halsteri" ;
lin halsteroida_V = mkkV "halsteroida" ;
lin halstrata_V = mkkV "halstrata" ;
lin haltija_N = mkkN "haltija" ;
lin haltijatar_N = mkkN "haltijatar" ;
lin haltioihinsa_Adv = mkkAdv "haltioihinsa" ;
lin haltioissaan_Adv = mkkAdv "haltioissaan" ;
lin haltioitua_V = mkkV "haltioitua" ;
lin haltuun_Adv = mkkAdv "haltuun" ;
lin halu_N = mkkN "halu" ;
lin haluinen_N = mkkN "haluinen" ;
lin halukas_A = mkkA "halukas" ;
lin halukkaasti_Adv = mkkAdv "halukkaasti" ;
lin halukkuus_N = mkkN "halukkuus" ;
lin halullinen_N = mkkN "halullinen" ;
lin haluta_V = mkkV "haluta" ;
lin haluton_N = mkkN "haluton" ;
lin haluttaa_V = mkkV "haluttaa" ;
lin haluttava_N = mkkN "haluttava" ;
lin haluttomasti_Adv = mkkAdv "haluttomasti" ;
lin haluttomuus_N = mkkN "haluttomuus" ;
lin haluttu_N = mkkN "haluttu" ;
lin halva_N = mkkN "halva" ;
lin halvaannuttaa_V = mkkV "halvaannuttaa" ;
lin halvaantua_V = mkkV "halvaantua" ;
lin halvata_V = mkkV "halvata" ;
lin halvattu_N = mkkN "halvattu" ;
lin halvaus_N = mkkN "halvaus" ;
lin halvauttaa_V = mkkV "halvauttaa" ;
lin halvautua_V = mkkV "halvautua" ;
lin halveerata_V = mkkV "halveerata" ;
lin halveksia_V = mkkV "halveksia" ;
lin halveksinta_N = mkkN "halveksinta" ;
lin halveksua_V = mkkV "halveksua" ;
lin halveksunta_N = mkkN "halveksunta" ;
lin halvennus_N = mkkN "halvennus" ;
lin halventaa_V = mkkV "halventaa" ;
lin halventavasti_Adv = mkkAdv "halventavasti" ;
lin halventua_V = mkkV "halventua" ;
lin halveta_V = mkkV "halveta" ;
lin hamaan_Adv = mkkAdv "hamaan" ;
lin hamara_N = mkkN "hamara" ;
lin hamassa_Adv = mkkAdv "hamassa" ;
lin hamasta_Adv = mkkAdv "hamasta" ;
lin hame_N = mkkN "hame" ;
lin hameinen_N = mkkN "hameinen" ;
lin hammas_N = mkkN "hammas" ;
lin hammastaa_V = mkkV "hammastaa" ;
lin hammaste_N = mkkN "hammaste" ;
lin hammastella_V = mkkV "hammastella" ;
lin hammastua_V = mkkV "hammastua" ;
lin hammastuksinen_N = mkkN "hammastuksinen" ;
lin hammastus_N = mkkN "hammastus" ;
lin hampaallinen_N = mkkN "hampaallinen" ;
lin hampaanjuuri_N = mkkN "hampaanjuuri" ;
lin hampaaton_N = mkkN "hampaaton" ;
lin hampaattomasti_Adv = mkkAdv "hampaattomasti" ;
lin hampaattomuus_N = mkkN "hampaattomuus" ;
lin hampainen_N = mkkN "hampainen" ;
lin hampaisto_N = mkkN "hampaisto" ;
lin hamppari_N = mkkN "hamppari" ;
lin hampparoida_V = mkkV "hampparoida" ;
lin hamppu_N = mkkN "hamppu" ;
lin hampsia_V = mkkV "hampsia" ;
lin hampurilainen_N = mkkN "hampurilainen" ;
lin hampurilaisbaari_N = mkkN "hampurilaisbaari" ;
lin hampuusi_N = mkkN "hampuusi" ;
lin hamsteri_N = mkkN "hamsteri" ;
lin hamstraaja_N = mkkN "hamstraaja" ;
lin hamstrata_V = mkkV "hamstrata" ;
lin hamuilla_V = mkkV "hamuilla" ;
lin hamuta_V = mkkV "hamuta" ;
lin hana_N = mkkN "hana" ;
lin hanakasti_Adv = mkkAdv "hanakasti" ;
lin hanakka_N = mkkN "hanakka" ;
lin hanakkuus_N = mkkN "hanakkuus" ;
lin handicap_N = mkkN "handicap" ;
lin handu_N = mkkN "handu" ;
lin hangata_V = mkkV "hangata" ;
lin hangoitella_V = mkkV "hangoitella" ;
lin hangollinen_N = mkkN "hangollinen" ;
lin hangota_V = mkkV "hangota" ;
lin hanhi_N = mkkN "hanhi" ;
lin hanhikki_N = mkkN "hanhikki" ;
lin hanikka_N = mkkN "hanikka" ;
lin hanka_N = mkkN "hanka" ;
lin hankaantua_V = mkkV "hankaantua" ;
lin hankaiminen_N = mkkN "hankaiminen" ;
lin hankain_N = mkkN "hankain" ;
lin hankainen_N = mkkN "hankainen" ;
lin hankala_N = mkkN "hankala" ;
lin hankaloittaa_V = mkkV "hankaloittaa" ;
lin hankaloitua_V = mkkV "hankaloitua" ;
lin hankaluus_N = mkkN "hankaluus" ;
lin hankauma_N = mkkN "hankauma" ;
lin hankaus_N = mkkN "hankaus" ;
lin hankauskohta_N = mkkN "hankauskohta" ;
lin hankautua_V = mkkV "hankautua" ;
lin hankautuma_N = mkkN "hankautuma" ;
lin hanke_N = mkkN "hanke" ;
lin hanki_N = mkkN "hanki" ;
lin hankiainen_N = mkkN "hankiainen" ;
lin hankinnainen_N = mkkN "hankinnainen" ;
lin hankinta_N = mkkN "hankinta" ;
lin hankinta_aika_N = mkkN "hankinta-aika" ;
lin hankkia_V = mkkV "hankkia" ;
lin hankkija_N = mkkN "hankkija" ;
lin hankkiutua_V = mkkV "hankkiutua" ;
lin hanko_N = mkkN "hanko" ;
lin hansa_N = mkkN "hansa" ;
lin hansikas_N = mkkN "hansikas" ;
lin hanska_N = mkkN "hanska" ;
lin hanslankari_N = mkkN "hanslankari" ;
lin hanti_N = mkkN "hanti" ;
lin hantlankari_N = mkkN "hantlankari" ;
lin hanttapuli_N = mkkN "hanttapuli" ;
lin hantti_N = mkkN "hantti" ;
lin hanttiin_Adv = mkkAdv "hanttiin" ;
lin hanuri_N = mkkN "hanuri" ;
lin hanuristi_N = mkkN "hanuristi" ;
lin hapan_N = mkkN "hapan" ;
lin hapanjuuri_N = mkkN "hapanjuuri" ;
lin hapannuttaa_V = mkkV "hapannuttaa" ;
lin hapantua_V = mkkV "hapantua" ;
lin haparoida_V = mkkV "haparoida" ;
lin haparointi_N = mkkN "haparointi" ;
lin hapata_V = mkkV "hapata" ;
lin hapate_N = mkkN "hapate" ;
lin hapatin_N = mkkN "hapatin" ;
lin hapattaa_V = mkkV "hapattaa" ;
lin hapattamaton_N = mkkN "hapattamaton" ;
lin hapatus_N = mkkN "hapatus" ;
lin hapekas_N = mkkN "hapekas" ;
lin hapera_N = mkkN "hapera" ;
lin hapero_N = mkkN "hapero" ;
lin hapertua_V = mkkV "hapertua" ;
lin hapete_N = mkkN "hapete" ;
lin hapetin_N = mkkN "hapetin" ;
lin hapettaa_V = mkkV "hapettaa" ;
lin hapettua_V = mkkV "hapettua" ;
lin hapettuma_N = mkkN "hapettuma" ;
lin hapetus_N = mkkN "hapetus" ;
lin haploidi_N = mkkN "haploidi" ;
lin haploidinen_N = mkkN "haploidinen" ;
lin hapokas_N = mkkN "hapokas" ;
lin hapoke_N = mkkN "hapoke" ;
lin hapokkuus_N = mkkN "hapokkuus" ;
lin hapottaa_V = mkkV "hapottaa" ;
lin hapottua_V = mkkV "hapottua" ;
lin happamasti_Adv = mkkAdv "happamasti" ;
lin happamaton_N = mkkN "happamaton" ;
lin happamesti_Adv = mkkAdv "happamesti" ;
lin happamoittaa_V = mkkV "happamoittaa" ;
lin happamoitua_V = mkkV "happamoitua" ;
lin happamuus_N = mkkN "happamuus" ;
lin happening_N = mkkN "happening" ;
lin happi_N = mkkN "happi" ;
lin happo_N = mkkN "happo" ;
lin happoinen_N = mkkN "happoinen" ;
lin happoisuus_N = mkkN "happoisuus" ;
lin happy_hour_Adv = mkkAdv "happC" ;
lin hapro_N = mkkN "hapro" ;
lin hapsenkakkiainen_N = mkkN "hapsenkakkiainen" ;
lin hapsi_N = mkkN "hapsi" ;
lin hapsikka_N = mkkN "hapsikka" ;
lin hapsottaa_V = mkkV "hapsottaa" ;
lin hapsu_N = mkkN "hapsu" ;
lin hapsuinen_N = mkkN "hapsuinen" ;
lin hapsullinen_N = mkkN "hapsullinen" ;
lin hapsuttaa_V = mkkV "hapsuttaa" ;
lin hapuilla_V = mkkV "hapuilla" ;
lin hara_N = mkkN "hara" ;
lin harajuuri_N = mkkN "harajuuri" ;
lin harakka_N = mkkN "harakka" ;
lin haralla_Adv = mkkAdv "haralla" ;
lin harallaan_Adv = mkkAdv "harallaan" ;
lin haralle_Adv = mkkAdv "haralle" ;
lin haralleen_Adv = mkkAdv "haralleen" ;
lin harata_V = mkkV "harata" ;
lin haraus_N = mkkN "haraus" ;
lin harava_N = mkkN "harava" ;
lin haravoida_V = mkkV "haravoida" ;
lin hardware_N = mkkN "hardware" ;
lin harha_N = mkkN "harha" ;
lin harhaan_Adv = mkkAdv "harhaan" ;
lin harhaannuttaa_V = mkkV "harhaannuttaa" ;
lin harhaantua_V = mkkV "harhaantua" ;
lin harhaanvieva'_N = mkkN "harhaanvievä" ;
lin harhailla_V = mkkV "harhailla" ;
lin harhailu_N = mkkN "harhailu" ;
lin harhainen_N = mkkN "harhainen" ;
lin harhama_N = mkkN "harhama" ;
lin harhassa_Adv = mkkAdv "harhassa" ;
lin harhateille_Adv = mkkAdv "harhateille" ;
lin harhateilla'_Adv = mkkAdv "harhateillä" ;
lin harhateilta'_Adv = mkkAdv "harhateiltä" ;
lin harhauma_N = mkkN "harhauma" ;
lin harhauttaa_V = mkkV "harhauttaa" ;
lin harhautua_V = mkkV "harhautua" ;
lin harhautuma_N = mkkN "harhautuma" ;
lin harhautus_N = mkkN "harhautus" ;
lin harilla_Adv = mkkAdv "harilla" ;
lin harillaan_Adv = mkkAdv "harillaan" ;
lin harille_Adv = mkkAdv "harille" ;
lin harilleen_Adv = mkkAdv "harilleen" ;
lin harittaa_V = mkkV "harittaa" ;
lin haritus_N = mkkN "haritus" ;
lin harja_N = mkkN "harja" ;
lin harjaannus_N = mkkN "harjaannus" ;
lin harjaannuttaa_V = mkkV "harjaannuttaa" ;
lin harjaantua_V = mkkV "harjaantua" ;
lin harjaantumaton_N = mkkN "harjaantumaton" ;
lin harjaantuneisuus_N = mkkN "harjaantuneisuus" ;
lin harjainen_N = mkkN "harjainen" ;
--? lin harjakaiset_NK = {s = d38 "harjakaiset" ;
lin harjake_N = mkkN "harjake" ;
lin harjaksinen_N = mkkN "harjaksinen" ;
lin harjanne_N = mkkN "harjanne" ;
--? lin harjannostajaiset_NK = {s = d38 "harjannostajaiset" ;
lin harjanteinen_N = mkkN "harjanteinen" ;
lin harjas_N = mkkN "harjas" ;
lin harjata_V = mkkV "harjata" ;
lin harjaus_N = mkkN "harjaus" ;
lin harjava_N = mkkN "harjava" ;
lin harjoite_N = mkkN "harjoite" ;
lin harjoitella_V = mkkV "harjoitella" ;
lin harjoitelma_N = mkkN "harjoitelma" ;
lin harjoittaa_V = mkkV "harjoittaa" ;
lin harjoittaja_N = mkkN "harjoittaja" ;
lin harjoittelija_N = mkkN "harjoittelija" ;
lin harjoittelu_N = mkkN "harjoittelu" ;
lin harjoitteluaika_N = mkkN "harjoitteluaika" ;
lin harjoitus_N = mkkN "harjoitus" ;
lin harjoituttaa_V = mkkV "harjoituttaa" ;
lin harju_N = mkkN "harju" ;
lin harjus_N = mkkN "harjus" ;
lin harkinta_N = mkkN "harkinta" ;
lin harkinta_aika_N = mkkN "harkinta-aika" ;
lin harkita_V = mkkV "harkita" ;
lin harkitsematon_N = mkkN "harkitsematon" ;
lin harkitsemattomasti_Adv = mkkAdv "harkitsemattomasti" ;
lin harkitsemattomuus_N = mkkN "harkitsemattomuus" ;
lin harkitseva_N = mkkN "harkitseva" ;
lin harkitsevainen_N = mkkN "harkitsevainen" ;
lin harkitsevaisuus_N = mkkN "harkitsevaisuus" ;
lin harkitsevuus_N = mkkN "harkitsevuus" ;
lin harkittu_N = mkkN "harkittu" ;
lin harkitusti_Adv = mkkAdv "harkitusti" ;
lin harkko_N = mkkN "harkko" ;
lin harlekiini_N = mkkN "harlekiini" ;
lin harmaa_N = mkkN "harmaa" ;
lin harmaahapsinen_N = mkkN "harmaahapsinen" ;
lin harmaannuttaa_V = mkkV "harmaannuttaa" ;
lin harmaantua_V = mkkV "harmaantua" ;
lin harmahtaa_V = mkkV "harmahtaa" ;
lin harmahtava_N = mkkN "harmahtava" ;
lin harmaus_N = mkkN "harmaus" ;
lin harme_N = mkkN "harme" ;
lin harmentaa_V = mkkV "harmentaa" ;
lin harmentua_V = mkkV "harmentua" ;
lin harmeta_V = mkkV "harmeta" ;
lin harmi_N = mkkN "harmi" ;
lin harmillinen_N = mkkN "harmillinen" ;
lin harmio_N = mkkN "harmio" ;
lin harmissaan_Adv = mkkAdv "harmissaan" ;
lin harmistua_V = mkkV "harmistua" ;
lin harmistuksissaan_Adv = mkkAdv "harmistuksissaan" ;
lin harmitella_V = mkkV "harmitella" ;
lin harmiton_N = mkkN "harmiton" ;
lin harmittaa_V = mkkV "harmittaa" ;
lin harmoni_N = mkkN "harmoni" ;
lin harmonia_N = mkkN "harmonia" ;
lin harmonikka_N = mkkN "harmonikka" ;
lin harmoninen_N = mkkN "harmoninen" ;
lin harmonioida_V = mkkV "harmonioida" ;
lin harmonisoida_V = mkkV "harmonisoida" ;
lin harmonisoitua_V = mkkV "harmonisoitua" ;
lin harmonistaa_V = mkkV "harmonistaa" ;
lin harmonistua_V = mkkV "harmonistua" ;
lin haroa_V = mkkV "haroa" ;
lin harottaa_V = mkkV "harottaa" ;
lin harpata_V = mkkV "harpata" ;
lin harpikko_N = mkkN "harpikko" ;
lin harpisti_N = mkkN "harpisti" ;
lin harppailla_V = mkkV "harppailla" ;
lin harppaus_N = mkkN "harppaus" ;
lin harppi_N = mkkN "harppi" ;
lin harppia_V = mkkV "harppia" ;
lin harppoa_V = mkkV "harppoa" ;
lin harppu_N = mkkN "harppu" ;
lin harppunoida_V = mkkV "harppunoida" ;
lin harppuuna_N = mkkN "harppuuna" ;
lin harras_N = mkkN "harras" ;
lin harrastaa_V = mkkV "harrastaa" ;
lin harrastaja_N = mkkN "harrastaja" ;
lin harraste_N = mkkN "harraste" ;
lin harrastelija_N = mkkN "harrastelija" ;
lin harrastella_V = mkkV "harrastella" ;
lin harrastelu_N = mkkN "harrastelu" ;
lin harrastua_V = mkkV "harrastua" ;
lin harrastuneisuus_N = mkkN "harrastuneisuus" ;
lin harrastus_N = mkkN "harrastus" ;
lin harri_N = mkkN "harri" ;
lin harsia_V = mkkV "harsia" ;
lin harsinta_N = mkkN "harsinta" ;
lin harso_N = mkkN "harso" ;
lin harsu_N = mkkN "harsu" ;
lin harsuuntua_V = mkkV "harsuuntua" ;
lin hartaasti_Adv = mkkAdv "hartaasti" ;
lin hartaus_N = mkkN "hartaus" ;
--? lin harteet_NK = {s = d48 "harteet" ;
lin harteikas_N = mkkN "harteikas" ;
lin harteinen_N = mkkN "harteinen" ;
lin harteva_N = mkkN "harteva" ;
lin hartia_N = mkkN "hartia" ;
lin hartiainen_N = mkkN "hartiainen" ;
lin hartiakas_N = mkkN "hartiakas" ;
lin hartsaantua_V = mkkV "hartsaantua" ;
lin hartsata_V = mkkV "hartsata" ;
lin hartsi_N = mkkN "hartsi" ;
lin hartsiintua_V = mkkV "hartsiintua" ;
lin hartsittaa_V = mkkV "hartsittaa" ;
lin harus_N = mkkN "harus" ;
lin harustaa_V = mkkV "harustaa" ;
lin harva_N = mkkN "harva" ;
lin harvaan_Adv = mkkAdv "harvaan" ;
lin harvakseen_Adv = mkkAdv "harvakseen" ;
lin harvakseltaan_Adv = mkkAdv "harvakseltaan" ;
lin harvassa_Adv = mkkAdv "harvassa" ;
lin harvemmin_Adv = mkkAdv "harvemmin" ;
lin harvempaan_Adv = mkkAdv "harvempaan" ;
lin harvennin_N = mkkN "harvennin" ;
lin harvennus_N = mkkN "harvennus" ;
lin harventaa_V = mkkV "harventaa" ;
lin harventaja_N = mkkN "harventaja" ;
lin harventamaton_N = mkkN "harventamaton" ;
lin harventua_V = mkkV "harventua" ;
lin harventuma_N = mkkN "harventuma" ;
lin harvesteri_N = mkkN "harvesteri" ;
lin harveta_V = mkkV "harveta" ;
lin harvinainen_N = mkkN "harvinainen" ;
lin harvinaistua_V = mkkV "harvinaistua" ;
lin harvinaisuus_N = mkkN "harvinaisuus" ;
lin harvoin_Adv = mkkAdv "harvoin" ;
lin harvuinen_N = mkkN "harvuinen" ;
lin harvuus_N = mkkN "harvuus" ;
lin hasardi_N = mkkN "hasardi" ;
lin hasis_N = mkkN "hasis" ;
lin hassahtanut_N = mkkN "hassahtanut" ;
lin hassahtava_N = mkkN "hassahtava" ;
lin hassata_V = mkkV "hassata" ;
lin hassi_N = mkkN "hassi" ;
lin hassu_A = mkkA "hassu" ;
lin hassunkurinen_N = mkkN "hassunkurinen" ;
lin hassusti_Adv = mkkAdv "hassusti" ;
lin hassutella_V = mkkV "hassutella" ;
lin hassuttaa_V = mkkV "hassuttaa" ;
lin hassuttelu_N = mkkN "hassuttelu" ;
lin hassutus_N = mkkN "hassutus" ;
lin hatara_A = mkkA "hatara" ;
lin hatarasti_Adv = mkkAdv "hatarasti" ;
lin hataruus_N = mkkN "hataruus" ;
lin hatikka_N = mkkN "hatikka" ;
--? lin hatkat_NK = {s = d09 "hatkat" ;
lin hattara_N = mkkN "hattara" ;
lin hattu_N = mkkN "hattu" ;
lin hattuuntua_V = mkkV "hattuuntua" ;
lin hatuttaa_V = mkkV "hatuttaa" ;
lin hau_Adv = mkkAdv "hau" ;
lin haudata_V = mkkV "haudata" ;
lin haude_N = mkkN "haude" ;
lin haudikas_N = mkkN "haudikas" ;
lin haudonta_N = mkkN "haudonta" ;
lin haudonta_aika_N = mkkN "haudonta-aika" ;
lin hauduttaa_V = mkkV "hauduttaa" ;
lin haudutus_N = mkkN "haudutus" ;
lin hauis_N = mkkN "hauis" ;
lin haukahdus_N = mkkN "haukahdus" ;
lin haukahtaa_V = mkkV "haukahtaa" ;
lin haukata_V = mkkV "haukata" ;
lin haukattava_N = mkkN "haukattava" ;
lin hauki_N = mkkN "hauki" ;
lin haukka_N = mkkN "haukka" ;
lin haukkaus_N = mkkN "haukkaus" ;
lin haukkoa_V = mkkV "haukkoa" ;
lin haukku_1_N = mkkN "haukku" ;
lin haukku_2_N = mkkN "haukku" ;
lin haukkua_V = mkkV "haukkua" ;
lin haukotella_V = mkkV "haukotella" ;
lin haukottaa_V = mkkV "haukottaa" ;
lin haukottelu_N = mkkN "haukottelu" ;
lin haukotus_N = mkkN "haukotus" ;
lin haukotuttaa_V = mkkV "haukotuttaa" ;
lin haukuskella_V = mkkV "haukuskella" ;
lin hauli_N = mkkN "hauli" ;
lin haulikko_N = mkkN "haulikko" ;
lin haura_N = mkkN "haura" ;
lin hauras_N = mkkN "hauras" ;
lin haurastua_V = mkkV "haurastua" ;
lin haurastuttaa_V = mkkV "haurastuttaa" ;
lin hauraus_N = mkkN "hauraus" ;
lin haureellinen_N = mkkN "haureellinen" ;
lin haureellisuus_N = mkkN "haureellisuus" ;
lin haureus_N = mkkN "haureus" ;
lin hauska_A = mkkA "hauska" ;
lin hauskasti_Adv = mkkAdv "hauskasti" ;
lin hauskuttaa_V = mkkV "hauskuttaa" ;
lin hauskutus_N = mkkN "hauskutus" ;
lin hauskuus_N = mkkN "hauskuus" ;
lin hauskuuttaa_V = mkkV "hauskuuttaa" ;
lin hauskuutus_N = mkkN "hauskuutus" ;
lin hauta_N = mkkN "hauta" ;
lin hautaantua_V = mkkV "hautaantua" ;
--? lin hautajaiset_NK = {s = d38 "hautajaiset" ;
lin hautautua_V = mkkV "hautautua" ;
lin hautoa_V = mkkV "hautoa" ;
lin hautomo_N = mkkN "hautomo" ;
lin hautoutua_V = mkkV "hautoutua" ;
lin hautua_V = mkkV "hautua" ;
lin hauva_N = mkkN "hauva" ;
lin havahduttaa_V = mkkV "havahduttaa" ;
lin havahtua_V = mkkV "havahtua" ;
lin havainnoida_V = mkkV "havainnoida" ;
lin havainnoija_N = mkkN "havainnoija" ;
lin havainnointi_N = mkkN "havainnointi" ;
lin havainnoitsija_N = mkkN "havainnoitsija" ;
lin havainnollinen_A = mkkA "havainnollinen" ;
lin havainnollisesti_Adv = mkkAdv "havainnollisesti" ;
lin havainnollistaa_V = mkkV "havainnollistaa" ;
lin havainnollistua_V = mkkV "havainnollistua" ;
lin havainnollisuus_N = mkkN "havainnollisuus" ;
lin havainto_N = mkkN "havainto" ;
lin havaita_V = mkkV "havaita" ;
lin havaittavasti_Adv = mkkAdv "havaittavasti" ;
lin havaittavuus_N = mkkN "havaittavuus" ;
lin havas_N = mkkN "havas" ;
lin haveri_N = mkkN "haveri" ;
lin havina_N = mkkN "havina" ;
lin havista_V = mkkV "havista" ;
lin havisuttaa_V = mkkV "havisuttaa" ;
lin havitella_V = mkkV "havitella" ;
lin havittelija_N = mkkN "havittelija" ;
lin havittelu_N = mkkN "havittelu" ;
lin havu_N = mkkN "havu" ;
lin havuttaa_V = mkkV "havuttaa" ;
lin he_2_Adv = mkkAdv "he" ;
lin heavy_N = mkkN "heavy" ;
lin hebrea_N = mkkN "hebrea" ;
lin hede_N = mkkN "hede" ;
lin hedelmisto'_N = mkkN "hedelmistö" ;
lin hedelmys_N = mkkN "hedelmys" ;
lin hedelma'_N = mkkN "hedelmä" ;
lin hedelma'inen_N = mkkN "hedelmäinen" ;
lin hedelma'llinen_A = mkkA "hedelmällinen" ;
lin hedelma'llisesti_Adv = mkkAdv "hedelmällisesti" ;
lin hedelma'llisyys_N = mkkN "hedelmällisyys" ;
lin hedelma'tto'myys_N = mkkN "hedelmättömyys" ;
lin hedelma'to'n_N = mkkN "hedelmätön" ;
lin hedelmo'ida'_V = mkkV "hedelmöidä" ;
lin hedelmo'inti_N = mkkN "hedelmöinti" ;
lin hedelmo'ittya'_V = mkkV "hedelmöittyä" ;
lin hedelmo'itta'a'_V = mkkV "hedelmöittää" ;
lin hedelmo'itys_N = mkkN "hedelmöitys" ;
lin hedelmo'itya'_V = mkkV "hedelmöityä" ;
lin hedoninen_N = mkkN "hedoninen" ;
lin hedonismi_N = mkkN "hedonismi" ;
lin hedonisti_N = mkkN "hedonisti" ;
lin hedonistinen_N = mkkN "hedonistinen" ;
lin heeros_N = mkkN "heeros" ;
lin hefta_N = mkkN "hefta" ;
lin hegemonia_N = mkkN "hegemonia" ;
lin heh_Adv = mkkAdv "heh" ;
lin hehkeys_N = mkkN "hehkeys" ;
lin hehkea'_N = mkkN "hehkeä" ;
lin hehku_N = mkkN "hehku" ;
lin hehkua_V = mkkV "hehkua" ;
lin hehkuttaa_V = mkkV "hehkuttaa" ;
lin hehkuttaja_N = mkkN "hehkuttaja" ;
lin hehkutus_N = mkkN "hehkutus" ;
lin hehtaari_N = mkkN "hehtaari" ;
lin hehto_N = mkkN "hehto" ;
lin hei_Adv = mkkAdv "hei" ;
lin heijari_N = mkkN "heijari" ;
lin heijastaa_V = mkkV "heijastaa" ;
lin heijaste_N = mkkN "heijaste" ;
lin heijasteinen_N = mkkN "heijasteinen" ;
lin heijastella_V = mkkV "heijastella" ;
lin heijastelu_N = mkkN "heijastelu" ;
lin heijastin_N = mkkN "heijastin" ;
lin heijastua_V = mkkV "heijastua" ;
lin heijastuma_N = mkkN "heijastuma" ;
lin heijastus_N = mkkN "heijastus" ;
lin heijata_V = mkkV "heijata" ;
lin heikenne_N = mkkN "heikenne" ;
lin heikennys_N = mkkN "heikennys" ;
lin heikentyma'_N = mkkN "heikentymä" ;
lin heikentya'_V = mkkV "heikentyä" ;
lin heikenta'a'_V = mkkV "heikentää" ;
lin heiketa'_V = mkkV "heiketä" ;
lin heikko_N = mkkN "heikko" ;
lin heikkous_N = mkkN "heikkous" ;
lin heikkovaloinen_N = mkkN "heikkovaloinen" ;
lin heikontaa_V = mkkV "heikontaa" ;
lin heikontua_V = mkkV "heikontua" ;
lin heikosti_Adv = mkkAdv "heikosti" ;
lin heikota_V = mkkV "heikota" ;
lin heikottaa_V = mkkV "heikottaa" ;
lin heikun_keikun_Adv = mkkAdv "heikuC" ;
lin heika'la'inen_N = mkkN "heikäläinen" ;
lin heila_N = mkkN "heila" ;
lin heilahdella_V = mkkV "heilahdella" ;
lin heilahdus_N = mkkN "heilahdus" ;
lin heilahdusaika_N = mkkN "heilahdusaika" ;
lin heilahduttaa_V = mkkV "heilahduttaa" ;
lin heilahtaa_V = mkkV "heilahtaa" ;
lin heilahtelu_N = mkkN "heilahtelu" ;
lin heilastella_V = mkkV "heilastella" ;
lin heilaus_N = mkkN "heilaus" ;
lin heilautella_V = mkkV "heilautella" ;
lin heilauttaa_V = mkkV "heilauttaa" ;
lin heilautus_N = mkkN "heilautus" ;
lin heili_N = mkkN "heili" ;
lin heilimo'ida'_V = mkkV "heilimöidä" ;
lin heilua_V = mkkV "heilua" ;
lin heilunta_N = mkkN "heilunta" ;
lin heiluri_N = mkkN "heiluri" ;
lin heilutella_V = mkkV "heilutella" ;
lin heiluttaa_V = mkkV "heiluttaa" ;
lin heilutus_N = mkkN "heilutus" ;
lin heimo_N = mkkN "heimo" ;
lin heimolaisuus_N = mkkN "heimolaisuus" ;
lin heimous_N = mkkN "heimous" ;
lin heinikko_N = mkkN "heinikko" ;
lin heinikkoinen_N = mkkN "heinikkoinen" ;
lin heinikko'_N = mkkN "heinikkö" ;
lin heinittya'_V = mkkV "heinittyä" ;
lin heinitta'a'_V = mkkV "heinittää" ;
lin heina'_N = mkkN "heinä" ;
lin heina'aika_N = mkkN "heinäaika" ;
lin heina'inen_N = mkkN "heinäinen" ;
lin heippa_Adv = mkkAdv "heippa" ;
lin heisi_N = mkkN "heisi" ;
lin heite_N = mkkN "heite" ;
lin heitella'_V = mkkV "heitellä" ;
lin heitin_N = mkkN "heitin" ;
lin heitteille_Adv = mkkAdv "heitteille" ;
lin heitteilla'_Adv = mkkAdv "heitteillä" ;
lin heitteilta'_Adv = mkkAdv "heitteiltä" ;
lin heittelehtia'_V = mkkV "heittelehtiä" ;
lin heittely_N = mkkN "heittely" ;
lin heittio'_N = mkkN "heittiö" ;
lin heitto_N = mkkN "heitto" ;
lin heittoinen_N = mkkN "heittoinen" ;
lin heittya'_V = mkkV "heittyä" ;
lin heitta'ja'_N = mkkN "heittäjä" ;
lin heitta'ytya'_V = mkkV "heittäytyä" ;
lin heitta'a'_V = mkkV "heittää" ;
lin heita'tta'a'_V = mkkV "heitättää" ;
lin heivata_V = mkkV "heivata" ;
lin heivero'inen_N = mkkN "heiveröinen" ;
lin hekotella_V = mkkV "hekotella" ;
lin hekottaa_V = mkkV "hekottaa" ;
lin hekotus_N = mkkN "hekotus" ;
lin heksaedri_N = mkkN "heksaedri" ;
lin heksagoni_N = mkkN "heksagoni" ;
lin heksagoninen_N = mkkN "heksagoninen" ;
lin heksaklorofeeni_N = mkkN "heksaklorofeeni" ;
lin heksametri_N = mkkN "heksametri" ;
lin hektinen_A = mkkA "hektinen" ;
lin hektisesti_Adv = mkkAdv "hektisesti" ;
lin hektisyys_N = mkkN "hektisyys" ;
lin hekuma_N = mkkN "hekuma" ;
lin hekumallinen_A = mkkA "hekumallinen" ;
lin hekumallisesti_Adv = mkkAdv "hekumallisesti" ;
lin hekumallisuus_N = mkkN "hekumallisuus" ;
lin hekumoida_V = mkkV "hekumoida" ;
lin hela_1_N = mkkN "hela" ;
lin hela_2_Adv = mkkAdv "hela" ;
lin helainen_N = mkkN "helainen" ;
lin helakasti_Adv = mkkAdv "helakasti" ;
lin helakka_N = mkkN "helakka" ;
lin helakkuus_N = mkkN "helakkuus" ;
lin hele_N = mkkN "hele" ;
lin heleys_N = mkkN "heleys" ;
lin helea'_A = mkkA "heleä" ;
lin helea'sti_Adv = mkkAdv "heleästi" ;
lin helibor_N = mkkN "helibor" ;
lin helikopteri_N = mkkN "helikopteri" ;
lin helina'_N = mkkN "helinä" ;
lin heliosentrinen_N = mkkN "heliosentrinen" ;
lin heliotrooppi_N = mkkN "heliotrooppi" ;
lin heliotrooppinen_N = mkkN "heliotrooppinen" ;
lin helistella'_V = mkkV "helistellä" ;
lin helistin_N = mkkN "helistin" ;
lin helista'_V = mkkV "helistä" ;
lin helista'a'_V = mkkV "helistää" ;
lin helisytta'a'_V = mkkV "helisyttää" ;
lin helium_N = mkkN "helium" ;
lin helkatti_N = mkkN "helkatti" ;
lin helke_N = mkkN "helke" ;
lin helkkari_A = mkkA "helkkari" ;
lin helkkarinmoinen_N = mkkN "helkkarinmoinen" ;
lin helkkaristi_Adv = mkkAdv "helkkaristi" ;
lin helkkya'_V = mkkV "helkkyä" ;
lin helkutti_N = mkkN "helkutti" ;
lin helkynta'_N = mkkN "helkyntä" ;
lin helkytella'_V = mkkV "helkytellä" ;
lin helkytta'a'_V = mkkV "helkyttää" ;
lin helkytys_N = mkkN "helkytys" ;
lin hella_N = mkkN "hella" ;
lin hellanlettas_Adv = mkkAdv "hellanlettas" ;
lin helle_N = mkkN "helle" ;
lin helleeni_N = mkkN "helleeni" ;
lin helleeninen_N = mkkN "helleeninen" ;
lin hellenismi_N = mkkN "hellenismi" ;
lin hellenistinen_N = mkkN "hellenistinen" ;
lin hellitella'_V = mkkV "hellitellä" ;
lin hellitta'ma'tto'myys_N = mkkN "hellittämättömyys" ;
lin hellitta'ma'tto'ma'sti_Adv = mkkAdv "hellittämättömästi" ;
lin hellitta'ma'to'n_N = mkkN "hellittämätön" ;
lin hellitta'a'_V = mkkV "hellittää" ;
lin hellita'_V = mkkV "hellitä" ;
lin hellia'_V = mkkV "helliä" ;
lin helluntai_N = mkkN "helluntai" ;
lin helluntailaisuus_N = mkkN "helluntailaisuus" ;
lin hellurei_Adv = mkkAdv "hellurei" ;
lin hellytta'a'_V = mkkV "hellyttää" ;
lin hellyys_N = mkkN "hellyys" ;
lin hella'_A = mkkA "hellä" ;
lin hella'ka'tisesti_Adv = mkkAdv "helläkätisesti" ;
lin hella'sti_Adv = mkkAdv "hellästi" ;
lin hella'ta'_V = mkkV "hellätä" ;
lin hella'varaisesti_Adv = mkkAdv "hellävaraisesti" ;
lin hella'varoen_Adv = mkkAdv "hellävaroen" ;
lin hella'varoin_Adv = mkkAdv "hellävaroin" ;
lin helma_N = mkkN "helma" ;
lin helmainen_N = mkkN "helmainen" ;
lin helmeilla'_V = mkkV "helmeillä" ;
lin helmestys_N = mkkN "helmestys" ;
lin helmesta'a'_V = mkkV "helmestää" ;
lin helmi_N = mkkN "helmi" ;
lin helmikka'_N = mkkN "helmikkä" ;
lin helmia'inen_N = mkkN "helmiäinen" ;
lin helmus_N = mkkN "helmus" ;
lin helmusta_N = mkkN "helmusta" ;
lin helo_N = mkkN "helo" ;
lin heloittaa_V = mkkV "heloittaa" ;
lin heloitus_N = mkkN "heloitus" ;
lin helokki_N = mkkN "helokki" ;
lin helottaa_V = mkkV "helottaa" ;
lin helotus_N = mkkN "helotus" ;
lin helpi_N = mkkN "helpi" ;
lin helpontaa_V = mkkV "helpontaa" ;
lin helpontua_V = mkkV "helpontua" ;
lin helposti_Adv = mkkAdv "helposti" ;
lin helpota_V = mkkV "helpota" ;
lin helpottaa_V = mkkV "helpottaa" ;
lin helpottua_V = mkkV "helpottua" ;
lin helpottuneesti_Adv = mkkAdv "helpottuneesti" ;
lin helpottunut_A = mkkA "helpottunut" ;
lin helpotus_N = mkkN "helpotus" ;
lin helppo_N = mkkN "helppo" ;
lin helppoheikki_N = mkkN "helppoheikki" ;
lin helppolukuisuus_N = mkkN "helppolukuisuus" ;
lin helppotajuistaa_V = mkkV "helppotajuistaa" ;
lin helppoto'isyys_N = mkkN "helppotöisyys" ;
lin helppous_N = mkkN "helppous" ;
lin helske_N = mkkN "helske" ;
lin helskutti_N = mkkN "helskutti" ;
lin helskytella'_V = mkkV "helskytellä" ;
lin helskytta'a'_V = mkkV "helskyttää" ;
lin helskytys_N = mkkN "helskytys" ;
lin helskya'_V = mkkV "helskyä" ;
lin helska'hta'a'_V = mkkV "helskähtää" ;
lin helska'a'_V = mkkV "helskää" ;
lin helteinen_A = mkkA "helteinen" ;
lin helteisesti_Adv = mkkAdv "helteisesti" ;
lin helteisyys_N = mkkN "helteisyys" ;
lin heltta_N = mkkN "heltta" ;
lin heltyma'to'n_N = mkkN "heltymätön" ;
lin heltya'_V = mkkV "heltyä" ;
lin helve_N = mkkN "helve" ;
lin helvetillinen_N = mkkN "helvetillinen" ;
lin helvetinmoinen_N = mkkN "helvetinmoinen" ;
lin helvetisti_Adv = mkkAdv "helvetisti" ;
lin helvetti_N = mkkN "helvetti" ;
lin hely_N = mkkN "hely" ;
lin hela'hdella'_V = mkkV "helähdellä" ;
lin hela'hdys_N = mkkN "helähdys" ;
lin hela'hdytta'a'_V = mkkV "helähdyttää" ;
lin hela'hta'a'_V = mkkV "helähtää" ;
lin hela'ja'a'_V = mkkV "heläjää" ;
lin hela'ytta'a'_V = mkkV "heläyttää" ;
lin hemaiseva_A = mkkA "hemaiseva" ;
lin hemaisevasti_Adv = mkkAdv "hemaisevasti" ;
lin hematiitti_N = mkkN "hematiitti" ;
lin hematologia_N = mkkN "hematologia" ;
lin hemisfa'a'ri_N = mkkN "hemisfääri" ;
lin hemmetinmoinen_N = mkkN "hemmetinmoinen" ;
lin hemmetisti_Adv = mkkAdv "hemmetisti" ;
lin hemmetti_N = mkkN "hemmetti" ;
lin hemmo_N = mkkN "hemmo" ;
lin hemmotella_V = mkkV "hemmotella" ;
lin hemmottelu_N = mkkN "hemmottelu" ;
lin hemofilia_N = mkkN "hemofilia" ;
lin hemoglobiini_N = mkkN "hemoglobiini" ;
lin hemorroidi_N = mkkN "hemorroidi" ;
lin hempeilla'_V = mkkV "hempeillä" ;
lin hempeily_N = mkkN "hempeily" ;
lin hempeys_N = mkkN "hempeys" ;
lin hempea'_A = mkkA "hempeä" ;
lin hempea'sti_Adv = mkkAdv "hempeästi" ;
lin hemppo_N = mkkN "hemppo" ;
lin hempukka_N = mkkN "hempukka" ;
lin hengata_V = mkkV "hengata" ;
lin hengellinen_N = mkkN "hengellinen" ;
lin hengellisyys_N = mkkN "hengellisyys" ;
lin hengenvaara_N = mkkN "hengenvaara" ;
lin hengenveto_N = mkkN "hengenveto" ;
lin hengetto'myys_N = mkkN "hengettömyys" ;
lin hengetto'ma'sti_Adv = mkkAdv "hengettömästi" ;
lin hengeta'r_N = mkkN "hengetär" ;
lin hengeto'n_N = mkkN "hengetön" ;
lin hengissa'_Adv = mkkAdv "hengissä" ;
lin hengitta'a'_V = mkkV "hengittää" ;
lin hengitys_N = mkkN "hengitys" ;
lin henga'hdys_N = mkkN "hengähdys" ;
lin henga'hdysaika_N = mkkN "hengähdysaika" ;
lin henga'hta'a'_V = mkkV "hengähtää" ;
lin henga'stys_N = mkkN "hengästys" ;
lin henga'stytta'a'_V = mkkV "hengästyttää" ;
lin henga'stya'_V = mkkV "hengästyä" ;
lin henkari_N = mkkN "henkari" ;
lin henkevyys_N = mkkN "henkevyys" ;
lin henkeva'_A = mkkA "henkevä" ;
lin henkeva'sti_Adv = mkkAdv "henkevästi" ;
lin henkevo'ida'_V = mkkV "henkevöidä" ;
lin henkevo'itta'a'_V = mkkV "henkevöittää" ;
lin henkevo'itya'_V = mkkV "henkevöityä" ;
lin henkea'salpaava_N = mkkN "henkeäsalpaava" ;
lin henki_N = mkkN "henki" ;
lin henkihieveriin_Adv = mkkAdv "henkihieveriin" ;
lin henkihieverissa'_Adv = mkkAdv "henkihieverissä" ;
lin henkiin_Adv = mkkAdv "henkiin" ;
lin henkilo'_N = mkkN "henkilö" ;
lin henkilo'ida'_V = mkkV "henkilöidä" ;
lin henkilo'inti_N = mkkN "henkilöinti" ;
lin henkilo'ityma'_N = mkkN "henkilöitymä" ;
lin henkilo'itya'_V = mkkV "henkilöityä" ;
lin henkilo'kohtaisesti_Adv = mkkAdv "henkilökohtaisesti" ;
lin henkilo'llisyys_N = mkkN "henkilöllisyys" ;
lin henkilo'sto'_N = mkkN "henkilöstö" ;
lin henkilo'ys_N = mkkN "henkilöys" ;
lin henkinen_A = mkkA "henkinen" ;
lin henkipatto_N = mkkN "henkipatto" ;
lin henkisesti_Adv = mkkAdv "henkisesti" ;
lin henkistya'_V = mkkV "henkistyä" ;
lin henkista'a'_V = mkkV "henkistää" ;
lin henkisyys_N = mkkN "henkisyys" ;
lin henkitoreihin_Adv = mkkAdv "henkitoreihin" ;
lin henkitoreihinsa_Adv = mkkAdv "henkitoreihinsa" ;
lin henkitoreisiin_Adv = mkkAdv "henkitoreisiin" ;
lin henkitoreisiinsa_Adv = mkkAdv "henkitoreisiinsa" ;
lin henkitoreissa_Adv = mkkAdv "henkitoreissa" ;
lin henkitoreissaan_Adv = mkkAdv "henkitoreissaan" ;
lin henkia'_V = mkkV "henkiä" ;
lin henkonen_N = mkkN "henkonen" ;
--? lin henkselit_NK = {s = d06 "henkselit" ;
lin henka'illa'_V = mkkV "henkäillä" ;
lin henka'ista'_V = mkkV "henkäistä" ;
lin henka'isy_N = mkkN "henkäisy" ;
lin henka'ys_N = mkkN "henkäys" ;
lin henna_N = mkkN "henna" ;
lin hennata_V = mkkV "hennata" ;
lin hennoa_V = mkkV "hennoa" ;
lin henry_N = mkkN "henry" ;
lin hento_N = mkkN "hento" ;
lin hentoilla_V = mkkV "hentoilla" ;
lin hentoilu_N = mkkN "hentoilu" ;
lin hentoinen_N = mkkN "hentoinen" ;
lin hentous_N = mkkN "hentous" ;
lin hep_Adv = mkkAdv "hep" ;
lin hepariini_N = mkkN "hepariini" ;
lin hepatiitti_N = mkkN "hepatiitti" ;
lin hepene_N = mkkN "hepene" ;
lin hepo_N = mkkN "hepo" ;
lin heppa_N = mkkN "heppa" ;
lin heppoinen_A = mkkA "heppoinen" ;
lin heppoisesti_Adv = mkkAdv "heppoisesti" ;
lin heppoisuus_N = mkkN "heppoisuus" ;
lin heppu_N = mkkN "heppu" ;
lin heprea_N = mkkN "heprea" ;
lin hepsankeikka_N = mkkN "hepsankeikka" ;
lin hepuli_N = mkkN "hepuli" ;
lin hera_N = mkkN "hera" ;
lin herahdella_V = mkkV "herahdella" ;
lin herahtaa_V = mkkV "herahtaa" ;
lin heraldiikka_N = mkkN "heraldiikka" ;
lin heraldikko_N = mkkN "heraldikko" ;
lin heraldinen_N = mkkN "heraldinen" ;
lin herauttaa_V = mkkV "herauttaa" ;
lin herbaario_N = mkkN "herbaario" ;
lin hereford_N = mkkN "hereford" ;
lin hereille_Adv = mkkAdv "hereille" ;
lin hereilla'_Adv = mkkAdv "hereillä" ;
lin hereys_N = mkkN "hereys" ;
lin herea'_A = mkkA "hereä" ;
lin herea'sti_Adv = mkkAdv "hereästi" ;
lin herhila'inen_N = mkkN "herhiläinen" ;
lin heristella'_V = mkkV "heristellä" ;
lin heristys_N = mkkN "heristys" ;
lin heristya'_V = mkkV "heristyä" ;
lin herista'a'_V = mkkV "heristää" ;
lin herja_N = mkkN "herja" ;
lin herjaaja_N = mkkN "herjaaja" ;
lin herjata_V = mkkV "herjata" ;
lin herjaus_N = mkkN "herjaus" ;
lin herjeta'_V = mkkV "herjetä" ;
lin herkentya'_V = mkkV "herkentyä" ;
lin herkenta'a'_V = mkkV "herkentää" ;
lin herketa'_V = mkkV "herketä" ;
lin herkea'ma'tta'_Adv = mkkAdv "herkeämättä" ;
lin herkea'ma'tto'myys_N = mkkN "herkeämättömyys" ;
lin herkea'ma'tto'ma'sti_Adv = mkkAdv "herkeämättömästi" ;
lin herkea'ma'to'n_N = mkkN "herkeämätön" ;
lin herkiste_N = mkkN "herkiste" ;
lin herkistella'_V = mkkV "herkistellä" ;
lin herkistely_N = mkkN "herkistely" ;
lin herkistyma'_N = mkkN "herkistymä" ;
lin herkistya'_V = mkkV "herkistyä" ;
lin herkista'a'_V = mkkV "herkistää" ;
lin herkku_N = mkkN "herkku" ;
lin herkkyys_N = mkkN "herkkyys" ;
lin herkka'_N = mkkN "herkkä" ;
lin herkullinen_A = mkkA "herkullinen" ;
lin herkullisesti_Adv = mkkAdv "herkullisesti" ;
lin herkullisuus_N = mkkN "herkullisuus" ;
lin herkutella_V = mkkV "herkutella" ;
lin herkuttelija_N = mkkN "herkuttelija" ;
lin herkuttelu_N = mkkN "herkuttelu" ;
lin herka'sti_Adv = mkkAdv "herkästi" ;
lin hermafrodiitti_N = mkkN "hermafrodiitti" ;
lin hermafrodiittinen_N = mkkN "hermafrodiittinen" ;
lin hermeettinen_A = mkkA "hermeettinen" ;
lin hermeettisesti_Adv = mkkAdv "hermeettisesti" ;
lin hermeneutiikka_N = mkkN "hermeneutiikka" ;
lin hermeneuttinen_N = mkkN "hermeneuttinen" ;
lin hermo_N = mkkN "hermo" ;
lin hermoilla_V = mkkV "hermoilla" ;
lin hermoinen_N = mkkN "hermoinen" ;
lin hermoisuus_N = mkkN "hermoisuus" ;
lin hermosto_N = mkkN "hermosto" ;
lin hermostollinen_N = mkkN "hermostollinen" ;
lin hermostua_V = mkkV "hermostua" ;
lin hermostuksissaan_Adv = mkkAdv "hermostuksissaan" ;
lin hermostuneesti_Adv = mkkAdv "hermostuneesti" ;
lin hermostuneisuus_N = mkkN "hermostuneisuus" ;
lin hermostunut_A = mkkA "hermostunut" ;
lin hermostus_N = mkkN "hermostus" ;
lin hermostuttaa_V = mkkV "hermostuttaa" ;
lin hermoton_N = mkkN "hermoton" ;
lin hermottaa_V = mkkV "hermottaa" ;
lin hermottua_V = mkkV "hermottua" ;
lin hermotus_N = mkkN "hermotus" ;
lin herne_N = mkkN "herne" ;
lin heroiini_N = mkkN "heroiini" ;
lin heroinisti_N = mkkN "heroinisti" ;
lin heroismi_N = mkkN "heroismi" ;
lin herooinen_N = mkkN "herooinen" ;
lin herpaannus_N = mkkN "herpaannus" ;
lin herpaannuttaa_V = mkkV "herpaannuttaa" ;
lin herpaantua_V = mkkV "herpaantua" ;
lin herpauttaa_V = mkkV "herpauttaa" ;
lin herpautua_V = mkkV "herpautua" ;
lin herpes_N = mkkN "herpes" ;
lin herra_N = mkkN "herra" ;
lin herrajesta_Adv = mkkAdv "herrajesta" ;
lin herranen_N = mkkN "herranen" ;
lin herranjesta_Adv = mkkAdv "herranjesta" ;
lin herraskainen_N = mkkN "herraskainen" ;
lin herraskaisesti_Adv = mkkAdv "herraskaisesti" ;
lin herrastella_V = mkkV "herrastella" ;
lin herrastelu_N = mkkN "herrastelu" ;
lin herraus_N = mkkN "herraus" ;
lin herrnhutilainen_N = mkkN "herrnhutilainen" ;
lin herrnhutilaisuus_N = mkkN "herrnhutilaisuus" ;
lin herroitella_V = mkkV "herroitella" ;
lin herroittelu_N = mkkN "herroittelu" ;
lin herruus_N = mkkN "herruus" ;
lin hersya'_V = mkkV "hersyä" ;
lin hertsi_N = mkkN "hertsi" ;
lin hertta_N = mkkN "hertta" ;
lin herttainen_N = mkkN "herttainen" ;
lin herttaisesti_Adv = mkkAdv "herttaisesti" ;
lin herttaisuus_N = mkkN "herttaisuus" ;
lin herttamainen_N = mkkN "herttamainen" ;
lin herttaa'ssa'_N = mkkN "herttaässä" ;
lin herttua_N = mkkN "herttua" ;
lin herttuatar_N = mkkN "herttuatar" ;
lin herua_V = mkkV "herua" ;
lin herukka_N = mkkN "herukka" ;
lin heruttaa_V = mkkV "heruttaa" ;
lin herutus_N = mkkN "herutus" ;
lin hervahtaa_V = mkkV "hervahtaa" ;
lin hervota_V = mkkV "hervota" ;
lin hervoton_N = mkkN "hervoton" ;
lin hervottomasti_Adv = mkkAdv "hervottomasti" ;
lin hervottomuus_N = mkkN "hervottomuus" ;
lin hera'illa'_V = mkkV "heräillä" ;
lin hera'nnyt_N = mkkN "herännyt" ;
lin hera'nna'inen_N = mkkN "herännäinen" ;
lin hera'nna'isyys_N = mkkN "herännäisyys" ;
lin hera'te_N = mkkN "heräte" ;
lin hera'tella'_V = mkkV "herätellä" ;
lin hera'tta'ja'_N = mkkN "herättäjä" ;
lin hera'tta'a'_V = mkkV "herättää" ;
lin hera'tys_N = mkkN "herätys" ;
lin hera'ta'_V = mkkV "herätä" ;
lin hera'a'mo'_N = mkkN "heräämö" ;
lin hetaira_N = mkkN "hetaira" ;
lin hetale_N = mkkN "hetale" ;
lin hete_N = mkkN "hete" ;
lin heteinen_N = mkkN "heteinen" ;
lin heteka_N = mkkN "heteka" ;
lin hetero_N = mkkN "hetero" ;
lin heterogamia_N = mkkN "heterogamia" ;
lin heterogeeninen_N = mkkN "heterogeeninen" ;
lin heterogeenisuus_N = mkkN "heterogeenisuus" ;
lin heteroseksuaali_N = mkkN "heteroseksuaali" ;
lin heterotsygootti_N = mkkN "heterotsygootti" ;
lin heterotsygoottinen_N = mkkN "heterotsygoottinen" ;
lin heti_Adv = mkkAdv "heti" ;
lin hetimmiten_Adv = mkkAdv "hetimmiten" ;
lin hetio'_N = mkkN "hetiö" ;
lin hetkahtaa_V = mkkV "hetkahtaa" ;
lin hetkauttaa_V = mkkV "hetkauttaa" ;
lin hetkellinen_N = mkkN "hetkellinen" ;
lin hetkellisesti_Adv = mkkAdv "hetkellisesti" ;
lin hetki_N = mkkN "hetki" ;
lin hetkinen_N = mkkN "hetkinen" ;
lin hetkinen_N = mkkN "hetkinen" ;
lin hetkitta'in_Adv = mkkAdv "hetkittäin" ;
lin hetkitta'inen_N = mkkN "hetkittäinen" ;
lin hetkua_V = mkkV "hetkua" ;
lin hetkutella_V = mkkV "hetkutella" ;
lin hetkuttaa_V = mkkV "hetkuttaa" ;
lin hetkutus_N = mkkN "hetkutus" ;
lin hetteikko'_N = mkkN "hetteikkö" ;
lin hetteinen_N = mkkN "hetteinen" ;
lin hetula_N = mkkN "hetula" ;
lin hevi_N = mkkN "hevi" ;
lin hevilla'_Adv = mkkAdv "hevillä" ;
lin hevin_Adv = mkkAdv "hevin" ;
lin hevonen_N = mkkN "hevonen" ;
lin hevoskuuri_N = mkkN "hevoskuuri" ;
lin hevospari_N = mkkN "hevospari" ;
lin hevostella_V = mkkV "hevostella" ;
lin hi_Adv = mkkAdv "hi" ;
lin hibiskus_N = mkkN "hibiskus" ;
lin hidalgo_N = mkkN "hidalgo" ;
lin hidas_N = mkkN "hidas" ;
lin hidastaa_V = mkkV "hidastaa" ;
lin hidaste_N = mkkN "hidaste" ;
lin hidastella_V = mkkV "hidastella" ;
lin hidastelu_N = mkkN "hidastelu" ;
lin hidastin_N = mkkN "hidastin" ;
lin hidastua_V = mkkV "hidastua" ;
lin hidastus_N = mkkN "hidastus" ;
lin hidastuttaa_V = mkkV "hidastuttaa" ;
lin hidastuvuus_N = mkkN "hidastuvuus" ;
lin hie_N = mkkN "hie" ;
lin hieho_N = mkkN "hieho" ;
lin hiekka_N = mkkN "hiekka" ;
lin hiekkahentunen_N = mkkN "hiekkahentunen" ;
lin hiekkainen_N = mkkN "hiekkainen" ;
lin hiekoitin_N = mkkN "hiekoitin" ;
lin hiekoittaa_V = mkkV "hiekoittaa" ;
lin hieman_Adv = mkkAdv "hieman" ;
lin hieno_A = mkkA "hieno" ;
lin hienoinen_A = mkkA "hienoinen" ;
lin hienoisesti_Adv = mkkAdv "hienoisesti" ;
lin hienokseltaan_Adv = mkkAdv "hienokseltaan" ;
lin hienonnin_N = mkkN "hienonnin" ;
lin hienonnus_N = mkkN "hienonnus" ;
lin hienontaa_V = mkkV "hienontaa" ;
lin hienontua_V = mkkV "hienontua" ;
lin hienostelija_N = mkkN "hienostelija" ;
lin hienostella_V = mkkV "hienostella" ;
lin hienosti_Adv = mkkAdv "hienosti" ;
lin hienostua_V = mkkV "hienostua" ;
lin hienostuneesti_Adv = mkkAdv "hienostuneesti" ;
lin hienostuneisuus_N = mkkN "hienostuneisuus" ;
lin hienostunut_A = mkkA "hienostunut" ;
lin hienota_V = mkkV "hienota" ;
lin hienotunteisesti_Adv = mkkAdv "hienotunteisesti" ;
lin hienous_N = mkkN "hienous" ;
lin hienovaraisesti_Adv = mkkAdv "hienovaraisesti" ;
lin hieraista_V = mkkV "hieraista" ;
lin hierarkia_N = mkkN "hierarkia" ;
lin hierarkkinen_N = mkkN "hierarkkinen" ;
lin hieroa_V = mkkV "hieroa" ;
lin hieroglyfi_N = mkkN "hieroglyfi" ;
lin hieroja_N = mkkN "hieroja" ;
lin hieronta_N = mkkN "hieronta" ;
lin hieroskella_V = mkkV "hieroskella" ;
lin hierottaa_V = mkkV "hierottaa" ;
lin hieroutua_V = mkkV "hieroutua" ;
lin hieroutuma_N = mkkN "hieroutuma" ;
lin hierre_N = mkkN "hierre" ;
lin hierrin_N = mkkN "hierrin" ;
lin hierto_N = mkkN "hierto" ;
lin hiertyma'_N = mkkN "hiertymä" ;
lin hiertya'_V = mkkV "hiertyä" ;
lin hierta'mo'_N = mkkN "hiertämö" ;
lin hierta'a'_V = mkkV "hiertää" ;
lin hiestya'_V = mkkV "hiestyä" ;
lin hiesta'a'_V = mkkV "hiestää" ;
lin hiesu_N = mkkN "hiesu" ;
lin hieta_N = mkkN "hieta" ;
lin hietainen_N = mkkN "hietainen" ;
lin hietikko_N = mkkN "hietikko" ;
lin hietikkoinen_N = mkkN "hietikkoinen" ;
lin hievahdus_N = mkkN "hievahdus" ;
lin hievahtaa_V = mkkV "hievahtaa" ;
lin hievauttaa_V = mkkV "hievauttaa" ;
lin hiffata_V = mkkV "hiffata" ;
lin hifi_N = mkkN "hifi" ;
lin high_tech_N = mkkN "higC" ;
lin hiha_N = mkkN "hiha" ;
lin hihainen_N = mkkN "hihainen" ;
lin hihallinen_N = mkkN "hihallinen" ;
lin hihastin_N = mkkN "hihastin" ;
lin hi_hat_N = mkkN "hi-hat" ;
lin hihaton_N = mkkN "hihaton" ;
lin hihhuli_N = mkkN "hihhuli" ;
lin hihhuloida_V = mkkV "hihhuloida" ;
lin hihitella'_V = mkkV "hihitellä" ;
lin hihitta'a'_V = mkkV "hihittää" ;
lin hihitys_N = mkkN "hihitys" ;
lin hihkaista_V = mkkV "hihkaista" ;
lin hihkaisu_N = mkkN "hihkaisu" ;
lin hihkua_V = mkkV "hihkua" ;
lin hihkunta_N = mkkN "hihkunta" ;
lin hihna_N = mkkN "hihna" ;
lin hihnoittaa_V = mkkV "hihnoittaa" ;
lin hihnoitus_N = mkkN "hihnoitus" ;
lin hiihdella'_V = mkkV "hiihdellä" ;
lin hiihdin_N = mkkN "hiihdin" ;
lin hiihda'nta'_N = mkkN "hiihdäntä" ;
--? lin hiihtarit_NK = {s = d06 "hiihtarit" ;
lin hiihtely_N = mkkN "hiihtely" ;
lin hiihto_N = mkkN "hiihto" ;
lin hiihta'ja'_N = mkkN "hiihtäjä" ;
lin hiihta'a'_V = mkkV "hiihtää" ;
lin hiilettya'_V = mkkV "hiilettyä" ;
lin hiiletta'a'_V = mkkV "hiilettää" ;
lin hiiletys_N = mkkN "hiiletys" ;
lin hiili_N = mkkN "hiili" ;
lin hiilidioksidi_N = mkkN "hiilidioksidi" ;
lin hiilimonoksidi_N = mkkN "hiilimonoksidi" ;
lin hiilinen_N = mkkN "hiilinen" ;
lin hiilisto'_N = mkkN "hiilistö" ;
lin hiilitetrakloridi_N = mkkN "hiilitetrakloridi" ;
lin hiillos_N = mkkN "hiillos" ;
lin hiillostaa_V = mkkV "hiillostaa" ;
lin hiillostua_V = mkkV "hiillostua" ;
lin hiillytta'a'_V = mkkV "hiillyttää" ;
lin hiilto_N = mkkN "hiilto" ;
lin hiiltya'_V = mkkV "hiiltyä" ;
lin hiilta'a'_V = mkkV "hiiltää" ;
lin hiilusta_N = mkkN "hiilusta" ;
lin hiiop_Adv = mkkAdv "hiiop" ;
lin hiipata_V = mkkV "hiipata" ;
lin hiipiva'_A = mkkA "hiipivä" ;
lin hiipiva'sti_Adv = mkkAdv "hiipivästi" ;
lin hiipia'_V = mkkV "hiipiä" ;
lin hiippa_N = mkkN "hiippa" ;
lin hiippailija_N = mkkN "hiippailija" ;
lin hiippailla_V = mkkV "hiippailla" ;
lin hiippailu_N = mkkN "hiippailu" ;
lin hiippari_N = mkkN "hiippari" ;
lin hiipua_V = mkkV "hiipua" ;
lin hiirakko_N = mkkN "hiirakko" ;
lin hiiri_N = mkkN "hiiri" ;
lin hiirulainen_N = mkkN "hiirulainen" ;
lin hiisi_N = mkkN "hiisi" ;
lin hiiskahdus_N = mkkN "hiiskahdus" ;
lin hiiskahtaa_V = mkkV "hiiskahtaa" ;
lin hiiskaus_N = mkkN "hiiskaus" ;
lin hiiskua_V = mkkV "hiiskua" ;
lin hiiskumaton_N = mkkN "hiiskumaton" ;
lin hiitata_V = mkkV "hiitata" ;
lin hiitti_N = mkkN "hiitti" ;
lin hiiva_N = mkkN "hiiva" ;
lin hiivata_V = mkkV "hiivata" ;
lin hiivatinmoinen_N = mkkN "hiivatinmoinen" ;
lin hiivatisti_Adv = mkkAdv "hiivatisti" ;
lin hiivatti_N = mkkN "hiivatti" ;
lin hiivinta'_N = mkkN "hiivintä" ;
lin hiiviskella'_V = mkkV "hiiviskellä" ;
lin hiiviskely_N = mkkN "hiiviskely" ;
lin hikeentya'_V = mkkV "hikeentyä" ;
lin hikevyys_N = mkkN "hikevyys" ;
lin hikeva'_N = mkkN "hikevä" ;
lin hikeytya'_V = mkkV "hikeytyä" ;
lin hiki_N = mkkN "hiki" ;
lin hikinen_N = mkkN "hikinen" ;
lin hikipa'issa'_Adv = mkkAdv "hikipäissä" ;
lin hikisyys_N = mkkN "hikisyys" ;
lin hikka_N = mkkN "hikka" ;
lin hikkori_N = mkkN "hikkori" ;
lin hikoilla_V = mkkV "hikoilla" ;
lin hikoilu_N = mkkN "hikoilu" ;
lin hikoiluttaa_V = mkkV "hikoiluttaa" ;
lin hila_N = mkkN "hila" ;
lin hilata_V = mkkV "hilata" ;
lin hilaus_N = mkkN "hilaus" ;
lin hilautua_V = mkkV "hilautua" ;
lin hilavitkutin_N = mkkN "hilavitkutin" ;
lin hile_N = mkkN "hile" ;
lin hiljaa_Adv = mkkAdv "hiljaa" ;
lin hiljainen_A = mkkA "hiljainen" ;
lin hiljaisesti_Adv = mkkAdv "hiljaisesti" ;
lin hiljaisuus_N = mkkN "hiljaisuus" ;
lin hiljakkoin_Adv = mkkAdv "hiljakkoin" ;
lin hiljakseen_Adv = mkkAdv "hiljakseen" ;
lin hiljalleen_Adv = mkkAdv "hiljalleen" ;
lin hiljan_Adv = mkkAdv "hiljan" ;
lin hiljattain_Adv = mkkAdv "hiljattain" ;
lin hiljennys_N = mkkN "hiljennys" ;
lin hiljentya'_V = mkkV "hiljentyä" ;
lin hiljenta'a'_V = mkkV "hiljentää" ;
lin hiljeta'_V = mkkV "hiljetä" ;
lin hilkka_N = mkkN "hilkka" ;
lin hilkulla_Adv = mkkAdv "hilkulla" ;
lin hilla_N = mkkN "hilla" ;
lin hilleri_N = mkkN "hilleri" ;
lin hillinta'_N = mkkN "hillintä" ;
lin hillitty_N = mkkN "hillitty" ;
lin hillitto'ma'sti_Adv = mkkAdv "hillittömästi" ;
lin hillitysti_Adv = mkkAdv "hillitysti" ;
lin hillita'_V = mkkV "hillitä" ;
lin hillito'n_N = mkkN "hillitön" ;
lin hillo_N = mkkN "hillo" ;
lin hilloke_N = mkkN "hilloke" ;
lin hillota_V = mkkV "hillota" ;
lin hilloutua_V = mkkV "hilloutua" ;
lin hillua_V = mkkV "hillua" ;
lin hilpaista_V = mkkV "hilpaista" ;
lin hilpari_N = mkkN "hilpari" ;
lin hilpeys_N = mkkN "hilpeys" ;
lin hilpea'_A = mkkA "hilpeä" ;
lin hilpea'sti_Adv = mkkAdv "hilpeästi" ;
lin hilse_N = mkkN "hilse" ;
lin hilsehtia'_V = mkkV "hilsehtiä" ;
lin hilseilla'_V = mkkV "hilseillä" ;
lin hilseily_N = mkkN "hilseily" ;
lin hilseinen_N = mkkN "hilseinen" ;
lin hilsettya'_V = mkkV "hilsettyä" ;
--? lin hilut_NK = {s = d01 "hilut" ;
lin hima_N = mkkN "hima" ;
lin himmeli_N = mkkN "himmeli" ;
lin himmennin_N = mkkN "himmennin" ;
lin himmennys_N = mkkN "himmennys" ;
lin himmentya'_V = mkkV "himmentyä" ;
lin himmenta'a'_V = mkkV "himmentää" ;
lin himmeta'_V = mkkV "himmetä" ;
lin himmeys_N = mkkN "himmeys" ;
lin himmea'_A = mkkA "himmeä" ;
lin himmea'sti_Adv = mkkAdv "himmeästi" ;
lin himo_N = mkkN "himo" ;
lin himoinen_N = mkkN "himoinen" ;
lin himoita_V = mkkV "himoita" ;
lin himokas_A = mkkA "himokas" ;
lin himokkaasti_Adv = mkkAdv "himokkaasti" ;
lin himokkuus_N = mkkN "himokkuus" ;
lin himota_V = mkkV "himota" ;
lin himottaa_V = mkkV "himottaa" ;
lin himphamppu_N = mkkN "himphamppu" ;
lin himpun_Adv = mkkAdv "himpun" ;
lin hinaaja_N = mkkN "hinaaja" ;
lin hinata_V = mkkV "hinata" ;
lin hinaus_N = mkkN "hinaus" ;
lin hinauttaa_V = mkkV "hinauttaa" ;
lin hinautua_V = mkkV "hinautua" ;
lin hindi_N = mkkN "hindi" ;
lin hindu_N = mkkN "hindu" ;
lin hindulaisuus_N = mkkN "hindulaisuus" ;
lin hindustani_N = mkkN "hindustani" ;
lin hinkalo_N = mkkN "hinkalo" ;
lin hinkata_V = mkkV "hinkata" ;
lin hinkki_N = mkkN "hinkki" ;
lin hinku_N = mkkN "hinku" ;
lin hinkua_V = mkkV "hinkua" ;
lin hinnakas_N = mkkN "hinnakas" ;
lin hinnasto_N = mkkN "hinnasto" ;
lin hinnoitella_V = mkkV "hinnoitella" ;
lin hinnoittaa_V = mkkV "hinnoittaa" ;
lin hinnoittelu_N = mkkN "hinnoittelu" ;
lin hinnoitus_N = mkkN "hinnoitus" ;
lin hinta_N = mkkN "hinta" ;
lin hintainen_N = mkkN "hintainen" ;
lin hintava_N = mkkN "hintava" ;
lin hintelyys_N = mkkN "hintelyys" ;
lin hintela'_N = mkkN "hintelä" ;
lin hinttari_N = mkkN "hinttari" ;
lin hintti_N = mkkN "hintti" ;
lin hinttiys_N = mkkN "hinttiys" ;
lin hioa_V = mkkV "hioa" ;
lin hioke_N = mkkN "hioke" ;
lin hiomakangas_N = mkkN "hiomakangas" ;
lin hiomaton_N = mkkN "hiomaton" ;
lin hiomo_N = mkkN "hiomo" ;
lin hionta_N = mkkN "hionta" ;
lin hiostaa_V = mkkV "hiostaa" ;
lin hiostua_V = mkkV "hiostua" ;
lin hiostus_N = mkkN "hiostus" ;
lin hiostuttaa_V = mkkV "hiostuttaa" ;
lin hiota_V = mkkV "hiota" ;
lin hiottaa_1_V = mkkV "hiottaa" ;
lin hiottaa_2_V = mkkV "hiottaa" ;
lin hioutua_V = mkkV "hioutua" ;
lin hip_Adv = mkkAdv "hip" ;
lin hipaista_V = mkkV "hipaista" ;
lin hipaisu_N = mkkN "hipaisu" ;
--? lin hipat_NK = {s = d09A "hipat" ;
lin hipelo'ida'_V = mkkV "hipelöidä" ;
lin hiphop_N = mkkN "hiphop" ;
lin hipia'_N = mkkN "hipiä" ;
lin hipoa_V = mkkV "hipoa" ;
lin hippa_N = mkkN "hippa" ;
lin hippasilla_Adv = mkkAdv "hippasilla" ;
lin hippasille_Adv = mkkAdv "hippasille" ;
lin hippi_N = mkkN "hippi" ;
lin hippia'inen_N = mkkN "hippiäinen" ;
lin hippodromi_N = mkkN "hippodromi" ;
lin hippu_N = mkkN "hippu" ;
--? lin hippulat_NK = {s = d12 "hippulat" ;
lin hipsia'_V = mkkV "hipsiä" ;
lin hipsutella_V = mkkV "hipsutella" ;
lin hipsuttaa_V = mkkV "hipsuttaa" ;
lin hipsuttelu_N = mkkN "hipsuttelu" ;
lin hipsutus_N = mkkN "hipsutus" ;
lin hirmu_N = mkkN "hirmu" ;
lin hirmuaika_N = mkkN "hirmuaika" ;
lin hirmuinen_A = mkkA "hirmuinen" ;
lin hirmuisesti_Adv = mkkAdv "hirmuisesti" ;
lin hirmuisuus_N = mkkN "hirmuisuus" ;
lin hirmustua_V = mkkV "hirmustua" ;
lin hirnahdella_V = mkkV "hirnahdella" ;
lin hirnahdus_N = mkkN "hirnahdus" ;
lin hirnahtaa_V = mkkV "hirnahtaa" ;
lin hirnua_V = mkkV "hirnua" ;
lin hirnunta_N = mkkN "hirnunta" ;
lin hirsi_N = mkkN "hirsi" ;
lin hirsinen_N = mkkN "hirsinen" ;
lin hirssi_N = mkkN "hirssi" ;
lin hirtehinen_N = mkkN "hirtehinen" ;
lin hirtto_N = mkkN "hirtto" ;
lin hirttya'_V = mkkV "hirttyä" ;
lin hirtta'ma'to'n_N = mkkN "hirttämätön" ;
lin hirtta'ytya'_V = mkkV "hirttäytyä" ;
lin hirtta'a'_V = mkkV "hirttää" ;
lin hirta'tta'a'_V = mkkV "hirtättää" ;
lin hirvas_N = mkkN "hirvas" ;
lin hirvenjuuri_N = mkkN "hirvenjuuri" ;
lin hirventalja_N = mkkN "hirventalja" ;
lin hirvenvasa_N = mkkN "hirvenvasa" ;
lin hirvestys_N = mkkN "hirvestys" ;
lin hirvesta'a'_V = mkkV "hirvestää" ;
lin hirveta'_V = mkkV "hirvetä" ;
lin hirveys_N = mkkN "hirveys" ;
lin hirvea'_A = mkkA "hirveä" ;
lin hirvea'sti_Adv = mkkAdv "hirveästi" ;
lin hirvi_N = mkkN "hirvi" ;
lin hirvitella'_V = mkkV "hirvitellä" ;
lin hirvitta'vyys_N = mkkN "hirvittävyys" ;
lin hirvitta'va'_A = mkkA "hirvittävä" ;
lin hirvitta'va'sti_Adv = mkkAdv "hirvittävästi" ;
lin hirvitta'a'_V = mkkV "hirvittää" ;
lin hirvita'_V = mkkV "hirvitä" ;
lin hirvio'_N = mkkN "hirviö" ;
lin hisahdus_N = mkkN "hisahdus" ;
lin hisahtaa_V = mkkV "hisahtaa" ;
lin hisaus_N = mkkN "hisaus" ;
lin hissa_N = mkkN "hissa" ;
lin hissata_V = mkkV "hissata" ;
lin hissi_N = mkkN "hissi" ;
lin hissukka_N = mkkN "hissukka" ;
lin hissukseen_Adv = mkkAdv "hissukseen" ;
lin hissuksiin_Adv = mkkAdv "hissuksiin" ;
lin hissun_kissun_Adv = mkkAdv "hissuC" ;
lin hissutella_V = mkkV "hissutella" ;
lin hissuttaa_V = mkkV "hissuttaa" ;
lin hissuttelu_N = mkkN "hissuttelu" ;
lin histamiini_N = mkkN "histamiini" ;
lin histogrammi_N = mkkN "histogrammi" ;
lin histologi_N = mkkN "histologi" ;
lin histologia_N = mkkN "histologia" ;
lin histologinen_N = mkkN "histologinen" ;
lin historia_N = mkkN "historia" ;
lin historiallinen_N = mkkN "historiallinen" ;
lin historiikki_N = mkkN "historiikki" ;
lin historioida_V = mkkV "historioida" ;
lin historioitsija_N = mkkN "historioitsija" ;
lin hitaasti_Adv = mkkAdv "hitaasti" ;
lin hitaus_N = mkkN "hitaus" ;
lin hi_tec_N = mkkN "hi-tec" ;
lin hi_tech_N = mkkN "hi-tech" ;
lin hitonmoinen_N = mkkN "hitonmoinen" ;
lin hitosti_Adv = mkkAdv "hitosti" ;
lin hitsaaja_N = mkkN "hitsaaja" ;
lin hitsaamo_N = mkkN "hitsaamo" ;
lin hitsaantua_V = mkkV "hitsaantua" ;
lin hitsari_N = mkkN "hitsari" ;
lin hitsata_V = mkkV "hitsata" ;
lin hitsaus_N = mkkN "hitsaus" ;
lin hitsautua_V = mkkV "hitsautua" ;
lin hitsi_1_N = mkkN "hitsi" ;
lin hitsi_2_N = mkkN "hitsi" ;
lin hitti_N = mkkN "hitti" ;
lin hitto_N = mkkN "hitto" ;
lin hitu_N = mkkN "hitu" ;
lin hitunen_N = mkkN "hitunen" ;
lin hiuduttaa_V = mkkV "hiuduttaa" ;
lin hiue_N = mkkN "hiue" ;
lin hiuka_N = mkkN "hiuka" ;
lin hiukaista_V = mkkV "hiukaista" ;
lin hiukan_Adv = mkkAdv "hiukan" ;
lin hiukka_N = mkkN "hiukka" ;
lin hiukkanen_N = mkkN "hiukkanen" ;
lin hiukoa_V = mkkV "hiukoa" ;
lin hiuksenhalkominen_N = mkkN "hiuksenhalkominen" ;
lin hiuksinen_N = mkkN "hiuksinen" ;
lin hius_N = mkkN "hius" ;
lin hiusjuuri_N = mkkN "hiusjuuri" ;
lin hiustenhalkoja_N = mkkN "hiustenhalkoja" ;
lin hiustenhalkominen_N = mkkN "hiustenhalkominen" ;
lin hiutale_N = mkkN "hiutale" ;
lin hiutaleinen_N = mkkN "hiutaleinen" ;
lin hiutua_V = mkkV "hiutua" ;
lin hiutuma_N = mkkN "hiutuma" ;
lin HIV_Adv = mkkAdv "HIV" ;
lin hivauttaa_V = mkkV "hivauttaa" ;
lin hivella'_V = mkkV "hivellä" ;
lin hivelta'a'_V = mkkV "hiveltää" ;
lin hiven_N = mkkN "hiven" ;
lin hivuttaa_V = mkkV "hivuttaa" ;
lin hivuttautua_V = mkkV "hivuttautua" ;
lin hivutus_N = mkkN "hivutus" ;
lin hobby_N = mkkN "hobby" ;
lin hodari_N = mkkN "hodari" ;
lin hoennainen_N = mkkN "hoennainen" ;
lin hoenta_N = mkkN "hoenta" ;
lin hohde_N = mkkN "hohde" ;
lin hohdella_V = mkkV "hohdella" ;
lin hohdokas_A = mkkA "hohdokas" ;
lin hohdokkaasti_Adv = mkkAdv "hohdokkaasti" ;
lin hohdokkuus_N = mkkN "hohdokkuus" ;
lin hohhoijaa_Adv = mkkAdv "hohhoijaa" ;
lin hohka_N = mkkN "hohka" ;
lin hohkaa_V = mkkV "hohkaa" ;
lin hohkainen_N = mkkN "hohkainen" ;
lin hohkata_V = mkkV "hohkata" ;
lin hohkua_V = mkkV "hohkua" ;
lin hohottaa_V = mkkV "hohottaa" ;
lin hohotus_N = mkkN "hohotus" ;
lin hohtaa_V = mkkV "hohtaa" ;
lin hohteinen_N = mkkN "hohteinen" ;
--? lin hohtimet_NK = {s = d33A "hohtimet" ;
lin hohto_N = mkkN "hohto" ;
lin hohtoinen_N = mkkN "hohtoinen" ;
lin hoi_Adv = mkkAdv "hoi" ;
lin hoidattaa_V = mkkV "hoidattaa" ;
lin hoide_N = mkkN "hoide" ;
lin hoidella_V = mkkV "hoidella" ;
lin hoidokki_N = mkkN "hoidokki" ;
lin hoidollinen_N = mkkN "hoidollinen" ;
lin hoikentaa_V = mkkV "hoikentaa" ;
lin hoikentua_V = mkkV "hoikentua" ;
lin hoiketa_V = mkkV "hoiketa" ;
lin hoikistaa_V = mkkV "hoikistaa" ;
lin hoikistua_V = mkkV "hoikistua" ;
lin hoikka_N = mkkN "hoikka" ;
lin hoikkuus_N = mkkN "hoikkuus" ;
lin hoilata_V = mkkV "hoilata" ;
lin hoilottaa_V = mkkV "hoilottaa" ;
lin hoilotus_N = mkkN "hoilotus" ;
lin hoiperrella_V = mkkV "hoiperrella" ;
lin hoipertelu_N = mkkN "hoipertelu" ;
lin hoippua_V = mkkV "hoippua" ;
lin hoippuroida_V = mkkV "hoippuroida" ;
lin hoippurointi_N = mkkN "hoippurointi" ;
lin hoitaa_V = mkkV "hoitaa" ;
lin hoitaja_N = mkkN "hoitaja" ;
lin hoitajatar_N = mkkN "hoitajatar" ;
lin hoitelu_N = mkkN "hoitelu" ;
lin hoito_N = mkkN "hoito" ;
lin hoitoisuus_N = mkkN "hoitoisuus" ;
lin hoitua_V = mkkV "hoitua" ;
lin hoituri_N = mkkN "hoituri" ;
lin hoiva_N = mkkN "hoiva" ;
lin hoivailla_V = mkkV "hoivailla" ;
lin hoivata_V = mkkV "hoivata" ;
lin hoivaus_N = mkkN "hoivaus" ;
lin hokea_V = mkkV "hokea" ;
lin hokema_N = mkkN "hokema" ;
lin hokkari_N = mkkN "hokkari" ;
lin hokkuspokkus_N = mkkN "hokkuspokkus" ;
lin hoksaavainen_N = mkkN "hoksaavainen" ;
lin hoksata_V = mkkV "hoksata" ;
--? lin hoksottimet_NK = {s = d33A "hoksottimet" ;
lin hoku_N = mkkN "hoku" ;
lin holahtaa_V = mkkV "holahtaa" ;
lin holauttaa_V = mkkV "holauttaa" ;
lin holhokki_N = mkkN "holhokki" ;
lin holhonta_N = mkkN "holhonta" ;
lin holhooja_N = mkkN "holhooja" ;
lin holhota_V = mkkV "holhota" ;
lin holhotti_N = mkkN "holhotti" ;
lin holhous_N = mkkN "holhous" ;
lin holismi_N = mkkN "holismi" ;
lin holisti_N = mkkN "holisti" ;
lin holistinen_N = mkkN "holistinen" ;
lin holkeri_N = mkkN "holkeri" ;
lin holkki_N = mkkN "holkki" ;
lin hollannikas_N = mkkN "hollannikas" ;
lin hollanti_N = mkkN "hollanti" ;
lin holli_N = mkkN "holli" ;
lin holografia_N = mkkN "holografia" ;
lin hologrammi_N = mkkN "hologrammi" ;
lin holokausti_N = mkkN "holokausti" ;
lin holtiton_N = mkkN "holtiton" ;
lin holtittomasti_Adv = mkkAdv "holtittomasti" ;
lin holtittomuus_N = mkkN "holtittomuus" ;
lin holtti_N = mkkN "holtti" ;
lin holvata_1_V = mkkV "holvata" ;
lin holvata_2_V = mkkV "holvata" ;
lin holvaus_1_N = mkkN "holvaus" ;
lin holvaus_2_N = mkkN "holvaus" ;
lin holvi_N = mkkN "holvi" ;
lin holvinen_N = mkkN "holvinen" ;
lin holvisto_N = mkkN "holvisto" ;
lin holvittaa_V = mkkV "holvittaa" ;
lin home_N = mkkN "home" ;
lin homeerinen_N = mkkN "homeerinen" ;
lin homehduttaa_V = mkkV "homehduttaa" ;
lin homehtua_V = mkkV "homehtua" ;
lin homeinen_N = mkkN "homeinen" ;
lin homeopaattinen_N = mkkN "homeopaattinen" ;
lin homeopatia_N = mkkN "homeopatia" ;
lin homeostaasi_N = mkkN "homeostaasi" ;
lin homeostaattinen_N = mkkN "homeostaattinen" ;
lin hominidi_N = mkkN "hominidi" ;
lin homma_N = mkkN "homma" ;
lin hommailla_V = mkkV "hommailla" ;
lin hommata_V = mkkV "hommata" ;
lin hommautua_V = mkkV "hommautua" ;
lin hommeli_N = mkkN "hommeli" ;
lin homo_N = mkkN "homo" ;
lin homofiili_N = mkkN "homofiili" ;
lin homofiilinen_N = mkkN "homofiilinen" ;
lin homofiilisuus_N = mkkN "homofiilisuus" ;
lin homofiilius_N = mkkN "homofiilius" ;
lin homogeeninen_N = mkkN "homogeeninen" ;
lin homogeenistaa_V = mkkV "homogeenistaa" ;
lin homogeenisuus_N = mkkN "homogeenisuus" ;
lin homogenisoida_V = mkkV "homogenisoida" ;
lin homogenisointi_N = mkkN "homogenisointi" ;
lin homogenoida_V = mkkV "homogenoida" ;
lin homogenointi_N = mkkN "homogenointi" ;
lin homonyymi_N = mkkN "homonyymi" ;
lin homoseksuaali_N = mkkN "homoseksuaali" ;
lin homoseksualismi_N = mkkN "homoseksualismi" ;
lin homoseksualisti_N = mkkN "homoseksualisti" ;
lin homotsygootti_N = mkkN "homotsygootti" ;
lin homotsygoottinen_N = mkkN "homotsygoottinen" ;
lin homous_N = mkkN "homous" ;
lin hompsottaa_V = mkkV "hompsottaa" ;
lin homssantuu_N = mkkN "homssantuu" ;
lin homssu_N = mkkN "homssu" ;
lin homssuinen_N = mkkN "homssuinen" ;
lin hongankolistaja_N = mkkN "hongankolistaja" ;
lin hongikko_N = mkkN "hongikko" ;
lin hongisto_N = mkkN "hongisto" ;
lin honka_N = mkkN "honka" ;
lin honkainen_N = mkkN "honkainen" ;
lin honkkeli_N = mkkN "honkkeli" ;
lin honoris_causa_Adv = mkkAdv "honoriC" ;
lin honottaa_V = mkkV "honottaa" ;
lin honotus_N = mkkN "honotus" ;
lin hontelo_N = mkkN "hontelo" ;
lin hoonata_V = mkkV "hoonata" ;
lin hoonaus_N = mkkN "hoonaus" ;
lin hoopo_N = mkkN "hoopo" ;
lin hoopoilla_V = mkkV "hoopoilla" ;
lin hoosata_V = mkkV "hoosata" ;
lin hoosianna_N = mkkN "hoosianna" ;
lin hopea_N = mkkN "hopea" ;
lin hopeahapsinen_N = mkkN "hopeahapsinen" ;
lin hopeahela_N = mkkN "hopeahela" ;
lin hopeainen_N = mkkN "hopeainen" ;
lin hopeinen_N = mkkN "hopeinen" ;
lin hopeoida_V = mkkV "hopeoida" ;
lin hopeointi_N = mkkN "hopeointi" ;
lin hopeoitua_V = mkkV "hopeoitua" ;
lin hoppu_N = mkkN "hoppu" ;
lin hoppuilla_V = mkkV "hoppuilla" ;
lin hoppuilu_N = mkkN "hoppuilu" ;
lin hoputtaa_V = mkkV "hoputtaa" ;
lin horina_N = mkkN "horina" ;
lin horisko_N = mkkN "horisko" ;
lin horisontaali_N = mkkN "horisontaali" ;
lin horisontaalinen_N = mkkN "horisontaalinen" ;
lin horisontti_N = mkkN "horisontti" ;
lin horista_V = mkkV "horista" ;
lin horjahdella_V = mkkV "horjahdella" ;
lin horjahdus_N = mkkN "horjahdus" ;
lin horjahtaa_V = mkkV "horjahtaa" ;
lin horjahtelu_N = mkkN "horjahtelu" ;
lin horjua_V = mkkV "horjua" ;
lin horjumaton_N = mkkN "horjumaton" ;
lin horjunta_N = mkkN "horjunta" ;
lin horjuttaa_V = mkkV "horjuttaa" ;
lin horjuva_N = mkkN "horjuva" ;
lin horjuvainen_N = mkkN "horjuvainen" ;
lin horjuvaisuus_N = mkkN "horjuvaisuus" ;
lin horjuvuus_N = mkkN "horjuvuus" ;
lin horkka_N = mkkN "horkka" ;
lin hormi_N = mkkN "hormi" ;
lin hormonaalinen_N = mkkN "hormonaalinen" ;
lin hormoni_N = mkkN "hormoni" ;
lin horna_N = mkkN "horna" ;
lin horoskooppi_N = mkkN "horoskooppi" ;
lin horre_N = mkkN "horre" ;
lin horros_N = mkkN "horros" ;
lin horrostaa_V = mkkV "horrostaa" ;
lin horsma_N = mkkN "horsma" ;
lin horsti_N = mkkN "horsti" ;
lin horteessa_Adv = mkkAdv "horteessa" ;
lin horteinen_N = mkkN "horteinen" ;
lin hortensia_N = mkkN "hortensia" ;
lin hortoilla_V = mkkV "hortoilla" ;
lin hortoilu_N = mkkN "hortoilu" ;
lin hortonomi_N = mkkN "hortonomi" ;
lin hospitsi_N = mkkN "hospitsi" ;
lin hosua_V = mkkV "hosua" ;
lin hotaista_V = mkkV "hotaista" ;
lin hotaisu_N = mkkN "hotaisu" ;
lin hot_dog_N = mkkN "hoC" ;
lin hoteisiin_Adv = mkkAdv "hoteisiin" ;
lin hoteissa_Adv = mkkAdv "hoteissa" ;
lin hoteista_Adv = mkkAdv "hoteista" ;
lin hotelli_N = mkkN "hotelli" ;
lin hotkaista_V = mkkV "hotkaista" ;
lin hotkaisu_N = mkkN "hotkaisu" ;
lin hotkia_V = mkkV "hotkia" ;
lin hotsittaa_V = mkkV "hotsittaa" ;
lin hottentotti_N = mkkN "hottentotti" ;
lin houkka_N = mkkN "houkka" ;
lin houkkio_N = mkkN "houkkio" ;
lin houkute_N = mkkN "houkute" ;
lin houkutella_V = mkkV "houkutella" ;
lin houkutin_N = mkkN "houkutin" ;
lin houkuttaa_V = mkkV "houkuttaa" ;
lin houkuttelu_N = mkkN "houkuttelu" ;
lin houkuttua_V = mkkV "houkuttua" ;
lin houkutus_N = mkkN "houkutus" ;
lin hourailla_V = mkkV "hourailla" ;
lin hourailu_N = mkkN "hourailu" ;
lin houre_N = mkkN "houre" ;
lin houreinen_N = mkkN "houreinen" ;
lin houria_V = mkkV "houria" ;
lin hourula_N = mkkN "hourula" ;
lin house_N = mkkN "house" ;
lin housuinen_N = mkkN "housuinen" ;
lin housukangas_N = mkkN "housukangas" ;
lin housuliivi_N = mkkN "housuliivi" ;
lin housunpuntti_N = mkkN "housunpuntti" ;
lin housupari_N = mkkN "housupari" ;
lin housusillaan_Adv = mkkAdv "housusillaan" ;
lin housusilleen_Adv = mkkAdv "housusilleen" ;
--? lin housut_NK = {s = d01 "housut" ;
lin hovi_N = mkkN "hovi" ;
lin hugenotti_N = mkkN "hugenotti" ;
lin huh_Adv = mkkAdv "huh" ;
lin huhkia_V = mkkV "huhkia" ;
lin huhmar_N = mkkN "huhmar" ;
lin huhmare_N = mkkN "huhmare" ;
lin huhta_N = mkkN "huhta" ;
lin huhtoa_V = mkkV "huhtoa" ;
lin huhu_N = mkkN "huhu" ;
lin huhuilla_V = mkkV "huhuilla" ;
lin huhuilu_N = mkkN "huhuilu" ;
lin huhuta_V = mkkV "huhuta" ;
lin hui_Adv = mkkAdv "hui" ;
lin huidella_V = mkkV "huidella" ;
lin hui_hai_Adv = mkkAdv "huC" ;
lin huijari_N = mkkN "huijari" ;
lin huijata_V = mkkV "huijata" ;
lin huijaus_N = mkkN "huijaus" ;
lin huikaista_V = mkkV "huikaista" ;
lin huikaistua_V = mkkV "huikaistua" ;
lin huikata_V = mkkV "huikata" ;
lin huikea_A = mkkA "huikea" ;
lin huikeasti_Adv = mkkAdv "huikeasti" ;
lin huikennella_V = mkkV "huikennella" ;
lin huikenteleva_A = mkkA "huikenteleva" ;
lin huikentelevainen_A = mkkA "huikentelevainen" ;
lin huikentelevaisesti_Adv = mkkAdv "huikentelevaisesti" ;
lin huikentelevaisuus_N = mkkN "huikentelevaisuus" ;
lin huikentelevasti_Adv = mkkAdv "huikentelevasti" ;
lin huikentelevuus_N = mkkN "huikentelevuus" ;
lin huikentelu_N = mkkN "huikentelu" ;
lin huikka_N = mkkN "huikka" ;
lin huikkaus_N = mkkN "huikkaus" ;
lin huilata_V = mkkV "huilata" ;
lin huilia_V = mkkV "huilia" ;
lin huilisti_N = mkkN "huilisti" ;
lin huilu_N = mkkN "huilu" ;
lin huima_A = mkkA "huima" ;
lin huimaava_A = mkkA "huimaava" ;
lin huimaavasti_Adv = mkkAdv "huimaavasti" ;
lin huimaavuus_N = mkkN "huimaavuus" ;
lin huimapa'isesti_Adv = mkkAdv "huimapäisesti" ;
lin huimapa'isyys_N = mkkN "huimapäisyys" ;
lin huimasti_Adv = mkkAdv "huimasti" ;
lin huimata_V = mkkV "huimata" ;
lin huimaus_N = mkkN "huimaus" ;
lin huimeta_V = mkkV "huimeta" ;
lin huimia_V = mkkV "huimia" ;
lin huipata_V = mkkV "huipata" ;
lin huipennus_N = mkkN "huipennus" ;
lin huipentaa_V = mkkV "huipentaa" ;
lin huipentua_V = mkkV "huipentua" ;
lin huipentuma_N = mkkN "huipentuma" ;
lin huipeta_V = mkkV "huipeta" ;
lin huipistaa_V = mkkV "huipistaa" ;
lin huipistua_V = mkkV "huipistua" ;
lin huippu_N = mkkN "huippu" ;
lin huippuinen_N = mkkN "huippuinen" ;
lin huippukohta_N = mkkN "huippukohta" ;
lin huiputtaa_V = mkkV "huiputtaa" ;
lin huiputus_N = mkkN "huiputus" ;
lin huiska_N = mkkN "huiska" ;
lin huiskaa_V = mkkV "huiskaa" ;
lin huiskahtaa_V = mkkV "huiskahtaa" ;
lin huiskaista_V = mkkV "huiskaista" ;
lin huiskale_N = mkkN "huiskale" ;
lin huiskaus_N = mkkN "huiskaus" ;
lin huiskauttaa_V = mkkV "huiskauttaa" ;
lin huiske_N = mkkN "huiske" ;
lin huiskea_N = mkkN "huiskea" ;
lin huiskia_V = mkkV "huiskia" ;
lin huiskilo_N = mkkN "huiskilo" ;
lin huiskina_N = mkkN "huiskina" ;
lin huiskin_haiskin_Adv = mkkAdv "huiskiC" ;
lin huiskinta_N = mkkN "huiskinta" ;
lin huiskis_Adv = mkkAdv "huiskis" ;
lin huisku_N = mkkN "huisku" ;
lin huiskuttaa_V = mkkV "huiskuttaa" ;
lin huiskutus_N = mkkN "huiskutus" ;
lin huit_Adv = mkkAdv "huit" ;
lin huitaista_V = mkkV "huitaista" ;
lin huitaisu_N = mkkN "huitaisu" ;
lin huithapeli_N = mkkN "huithapeli" ;
lin huitoa_V = mkkV "huitoa" ;
lin huitsin_Adv = mkkAdv "huitsin" ;
lin huivi_N = mkkN "huivi" ;
lin hujahdus_N = mkkN "hujahdus" ;
lin hujahtaa_V = mkkV "hujahtaa" ;
lin hujakoilla_Adv = mkkAdv "hujakoilla" ;
lin hujan_hajan_Adv = mkkAdv "hujaC" ;
lin hujaus_N = mkkN "hujaus" ;
lin hujauttaa_V = mkkV "hujauttaa" ;
lin hujellus_N = mkkN "hujellus" ;
lin hujeltaa_V = mkkV "hujeltaa" ;
lin hujoppi_N = mkkN "hujoppi" ;
lin hukassa_Adv = mkkAdv "hukassa" ;
lin hukata_V = mkkV "hukata" ;
lin huki_N = mkkN "huki" ;
lin hukka_N = mkkN "hukka" ;
lin hukka_aika_N = mkkN "hukka-aika" ;
lin hukkaan_Adv = mkkAdv "hukkaan" ;
lin hukkaantua_V = mkkV "hukkaantua" ;
lin hukkateille_Adv = mkkAdv "hukkateille" ;
lin hukkateilla'_Adv = mkkAdv "hukkateillä" ;
lin hukkautua_V = mkkV "hukkautua" ;
lin hukkua_V = mkkV "hukkua" ;
lin hukuksiin_Adv = mkkAdv "hukuksiin" ;
lin hukuksissa_Adv = mkkAdv "hukuksissa" ;
lin hukuttaa_V = mkkV "hukuttaa" ;
lin hukuttautua_V = mkkV "hukuttautua" ;
lin hula_N = mkkN "hula" ;
lin hulahtaa_V = mkkV "hulahtaa" ;
lin hulauttaa_V = mkkV "hulauttaa" ;
lin huligaani_N = mkkN "huligaani" ;
lin huliganismi_N = mkkN "huliganismi" ;
lin hulina_N = mkkN "hulina" ;
lin hulinoida_V = mkkV "hulinoida" ;
lin hulinointi_N = mkkN "hulinointi" ;
lin hulinoitsija_N = mkkN "hulinoitsija" ;
lin hulivili_N = mkkN "hulivili" ;
lin huljahtaa_V = mkkV "huljahtaa" ;
lin huljauttaa_V = mkkV "huljauttaa" ;
lin huljua_V = mkkV "huljua" ;
lin huljutella_V = mkkV "huljutella" ;
lin huljuttaa_V = mkkV "huljuttaa" ;
lin huljuttelu_N = mkkN "huljuttelu" ;
lin huljutus_N = mkkN "huljutus" ;
lin hullaannuttaa_V = mkkV "hullaannuttaa" ;
lin hullaantua_V = mkkV "hullaantua" ;
lin hullu_A = mkkA "hullu" ;
lin hullunkurinen_A = mkkA "hullunkurinen" ;
lin hullunkurisesti_Adv = mkkAdv "hullunkurisesti" ;
lin hullunkurisuus_N = mkkN "hullunkurisuus" ;
lin hullusti_Adv = mkkAdv "hullusti" ;
lin hullutella_V = mkkV "hullutella" ;
lin hulluttelu_N = mkkN "hulluttelu" ;
lin hullutus_N = mkkN "hullutus" ;
lin hulluus_N = mkkN "hulluus" ;
lin hulmahdella_V = mkkV "hulmahdella" ;
lin hulmahdus_N = mkkN "hulmahdus" ;
lin hulmahtaa_V = mkkV "hulmahtaa" ;
lin hulmahtelu_N = mkkN "hulmahtelu" ;
lin hulmauttaa_V = mkkV "hulmauttaa" ;
lin hulmuta_V = mkkV "hulmuta" ;
lin hulpilo_N = mkkN "hulpilo" ;
lin hulpio_N = mkkN "hulpio" ;
lin hulppea_N = mkkN "hulppea" ;
lin hulttio_N = mkkN "hulttio" ;
lin hulvahdus_N = mkkN "hulvahdus" ;
lin hulvahtaa_V = mkkV "hulvahtaa" ;
lin hulvaton_N = mkkN "hulvaton" ;
lin humaani_N = mkkN "humaani" ;
lin humaaninen_N = mkkN "humaaninen" ;
lin humaanistaa_V = mkkV "humaanistaa" ;
lin humaanistua_V = mkkV "humaanistua" ;
lin humaanisuus_N = mkkN "humaanisuus" ;
lin humaanius_N = mkkN "humaanius" ;
lin humahdella_V = mkkV "humahdella" ;
lin humahdus_N = mkkN "humahdus" ;
lin humahtaa_V = mkkV "humahtaa" ;
lin humala_N = mkkN "humala" ;
lin humalainen_N = mkkN "humalainen" ;
lin humalapa'issa'_Adv = mkkAdv "humalapäissä" ;
lin humalikas_N = mkkN "humalikas" ;
lin humalikko_N = mkkN "humalikko" ;
lin humalisto_N = mkkN "humalisto" ;
lin humalluttaa_V = mkkV "humalluttaa" ;
lin humaltua_V = mkkV "humaltua" ;
lin humanismi_N = mkkN "humanismi" ;
lin humanisoida_V = mkkV "humanisoida" ;
lin humanisoitua_V = mkkV "humanisoitua" ;
lin humanisti_N = mkkN "humanisti" ;
lin humanistinen_N = mkkN "humanistinen" ;
lin humanitaarinen_N = mkkN "humanitaarinen" ;
lin humanita'a'rinen_N = mkkN "humanitäärinen" ;
lin humanoidi_N = mkkN "humanoidi" ;
lin humaus_N = mkkN "humaus" ;
lin humauttaa_V = mkkV "humauttaa" ;
lin humina_N = mkkN "humina" ;
lin huminoida_V = mkkV "huminoida" ;
lin humista_V = mkkV "humista" ;
lin humma_N = mkkN "humma" ;
lin hummailla_V = mkkV "hummailla" ;
lin hummailu_N = mkkN "hummailu" ;
lin hummata_V = mkkV "hummata" ;
lin hummaus_N = mkkN "hummaus" ;
lin hummeri_N = mkkN "hummeri" ;
lin humoreski_N = mkkN "humoreski" ;
lin humoristi_N = mkkN "humoristi" ;
lin humoristinen_A = mkkA "humoristinen" ;
lin humoristisesti_Adv = mkkAdv "humoristisesti" ;
lin humoristisuus_N = mkkN "humoristisuus" ;
lin humpata_V = mkkV "humpata" ;
lin humppa_N = mkkN "humppa" ;
lin humpsahtaa_V = mkkV "humpsahtaa" ;
lin humputella_V = mkkV "humputella" ;
lin humpuuki_N = mkkN "humpuuki" ;
lin humu_N = mkkN "humu" ;
lin humus_N = mkkN "humus" ;
lin hunaja_N = mkkN "hunaja" ;
lin hunajainen_A = mkkA "hunajainen" ;
lin hunajaisesti_Adv = mkkAdv "hunajaisesti" ;
lin hunni_N = mkkN "hunni" ;
lin hunningolla_Adv = mkkAdv "hunningolla" ;
lin hunningolle_Adv = mkkAdv "hunningolle" ;
lin hunnuttaa_V = mkkV "hunnuttaa" ;
lin hunsvotti_N = mkkN "hunsvotti" ;
lin huntti_N = mkkN "huntti" ;
lin huntu_N = mkkN "huntu" ;
lin huoahdella_V = mkkV "huoahdella" ;
lin huoahdus_N = mkkN "huoahdus" ;
lin huoahtaa_V = mkkV "huoahtaa" ;
lin huoahtelu_N = mkkN "huoahtelu" ;
lin huoata_V = mkkV "huoata" ;
lin huohottaa_V = mkkV "huohottaa" ;
lin huohotus_N = mkkN "huohotus" ;
lin huoistaa_V = mkkV "huoistaa" ;
lin huoistua_V = mkkV "huoistua" ;
lin huojahdella_V = mkkV "huojahdella" ;
lin huojahtaa_V = mkkV "huojahtaa" ;
lin huojahtelu_N = mkkN "huojahtelu" ;
lin huojennus_N = mkkN "huojennus" ;
lin huojentaa_V = mkkV "huojentaa" ;
lin huojentua_V = mkkV "huojentua" ;
lin huojeta_V = mkkV "huojeta" ;
lin huojistaa_V = mkkV "huojistaa" ;
lin huojistua_V = mkkV "huojistua" ;
lin huojua_V = mkkV "huojua" ;
lin huojunta_N = mkkN "huojunta" ;
lin huojutella_V = mkkV "huojutella" ;
lin huojuttaa_V = mkkV "huojuttaa" ;
lin huokailla_V = mkkV "huokailla" ;
lin huokailu_N = mkkN "huokailu" ;
lin huokaista_V = mkkV "huokaista" ;
lin huokaus_N = mkkN "huokaus" ;
lin huokea_N = mkkN "huokea" ;
lin huokeus_N = mkkN "huokeus" ;
lin huokoinen_N = mkkN "huokoinen" ;
lin huokoistua_V = mkkV "huokoistua" ;
lin huokoisuus_N = mkkN "huokoisuus" ;
lin huokonen_N = mkkN "huokonen" ;
lin huoku_N = mkkN "huoku" ;
lin huokua_V = mkkV "huokua" ;
lin huolehdinta_N = mkkN "huolehdinta" ;
lin huolehtia_V = mkkV "huolehtia" ;
lin huolehtivainen_A = mkkA "huolehtivainen" ;
lin huolehtivaisesti_Adv = mkkAdv "huolehtivaisesti" ;
lin huolehtivaisuus_N = mkkN "huolehtivaisuus" ;
lin huolekas_N = mkkN "huolekas" ;
lin huolellinen_A = mkkA "huolellinen" ;
lin huolellisesti_Adv = mkkAdv "huolellisesti" ;
lin huolellisuus_N = mkkN "huolellisuus" ;
lin huolestua_V = mkkV "huolestua" ;
lin huolestuneisuus_N = mkkN "huolestuneisuus" ;
lin huolestus_N = mkkN "huolestus" ;
lin huolestuttaa_V = mkkV "huolestuttaa" ;
lin huoleti_Adv = mkkAdv "huoleti" ;
lin huoleton_N = mkkN "huoleton" ;
lin huoletta_Adv = mkkAdv "huoletta" ;
lin huolettaa_V = mkkV "huolettaa" ;
lin huolettomasti_Adv = mkkAdv "huolettomasti" ;
lin huolettomuus_N = mkkN "huolettomuus" ;
lin huoli_N = mkkN "huoli" ;
lin huolia_V = mkkV "huolia" ;
lin huolimaton_N = mkkN "huolimaton" ;
lin huolimatta_Adv = mkkAdv "huolimatta" ;
lin huolimattomasti_Adv = mkkAdv "huolimattomasti" ;
lin huolimattomuus_N = mkkN "huolimattomuus" ;
lin huolinta_N = mkkN "huolinta" ;
lin huolissaan_Adv = mkkAdv "huolissaan" ;
lin huolita_V = mkkV "huolita" ;
lin huolitella_V = mkkV "huolitella" ;
lin huolitsija_N = mkkN "huolitsija" ;
lin huolittelu_N = mkkN "huolittelu" ;
lin huollattaa_V = mkkV "huollattaa" ;
lin huoltaa_V = mkkV "huoltaa" ;
lin huoltaja_N = mkkN "huoltaja" ;
lin huoltamo_N = mkkN "huoltamo" ;
lin huolto_N = mkkN "huolto" ;
lin huoltola_N = mkkN "huoltola" ;
lin huomaamaton_N = mkkN "huomaamaton" ;
lin huomaamattomasti_Adv = mkkAdv "huomaamattomasti" ;
lin huomaamattomuus_N = mkkN "huomaamattomuus" ;
lin huomaan_Adv = mkkAdv "huomaan" ;
lin huomaavainen_A = mkkA "huomaavainen" ;
lin huomaavaisesti_Adv = mkkAdv "huomaavaisesti" ;
lin huomaavaisuus_N = mkkN "huomaavaisuus" ;
lin huomassa_Adv = mkkAdv "huomassa" ;
lin huomata_V = mkkV "huomata" ;
lin huomattava_A = mkkA "huomattava" ;
lin huomattavasti_Adv = mkkAdv "huomattavasti" ;
lin huomautella_V = mkkV "huomautella" ;
lin huomauttaa_V = mkkV "huomauttaa" ;
lin huomautus_N = mkkN "huomautus" ;
lin huomen_N = mkkN "huomen" ;
lin huomenissa_Adv = mkkAdv "huomenissa" ;
lin huomenna_Adv = mkkAdv "huomenna" ;
lin huominen_N = mkkN "huominen" ;
lin huomio_N = mkkN "huomio" ;
lin huomioida_V = mkkV "huomioida" ;
lin huomioija_N = mkkN "huomioija" ;
lin huomiointi_N = mkkN "huomiointi" ;
lin huomioitsija_N = mkkN "huomioitsija" ;
lin huomioon_ottaen_Adv = mkkAdv "huomiooC" ;
lin huone_N = mkkN "huone" ;
lin huoneinen_N = mkkN "huoneinen" ;
lin huoneisto_N = mkkN "huoneisto" ;
lin huoneke_N = mkkN "huoneke" ;
lin huono_A = mkkA "huono" ;
lin huonokuuloisuus_N = mkkN "huonokuuloisuus" ;
lin huonommuus_N = mkkN "huonommuus" ;
lin huononnus_N = mkkN "huononnus" ;
lin huonontaa_V = mkkV "huonontaa" ;
lin huonontua_V = mkkV "huonontua" ;
lin huonosti_Adv = mkkAdv "huonosti" ;
lin huonota_V = mkkV "huonota" ;
lin huonous_N = mkkN "huonous" ;
lin huopa_N = mkkN "huopa" ;
lin huopainen_N = mkkN "huopainen" ;
lin huopaus_N = mkkN "huopaus" ;
lin huopauttaa_V = mkkV "huopauttaa" ;
lin huopikas_N = mkkN "huopikas" ;
lin huopua_V = mkkV "huopua" ;
lin huora_N = mkkN "huora" ;
lin huorahtava_N = mkkN "huorahtava" ;
lin huorata_V = mkkV "huorata" ;
lin huorin_Adv = mkkAdv "huorin" ;
lin huoruus_N = mkkN "huoruus" ;
lin huostaan_Adv = mkkAdv "huostaan" ;
lin huostassa_Adv = mkkAdv "huostassa" ;
lin huostasta_Adv = mkkAdv "huostasta" ;
lin huotra_N = mkkN "huotra" ;
lin huounta_N = mkkN "huounta" ;
lin huovata_V = mkkV "huovata" ;
lin huovi_N = mkkN "huovi" ;
lin huovikas_N = mkkN "huovikas" ;
lin huovuttaa_V = mkkV "huovuttaa" ;
lin huovutus_N = mkkN "huovutus" ;
lin hupa_N = mkkN "hupa" ;
lin hupailu_N = mkkN "hupailu" ;
lin hupainen_N = mkkN "hupainen" ;
lin hupaisa_A = mkkA "hupaisa" ;
lin hupaisasti_Adv = mkkAdv "hupaisasti" ;
lin hupakko_N = mkkN "hupakko" ;
lin hupi_N = mkkN "hupi" ;
lin huppari_N = mkkN "huppari" ;
lin huppeli_N = mkkN "huppeli" ;
lin huppu_N = mkkN "huppu" ;
lin hupsahtaa_V = mkkV "hupsahtaa" ;
lin hupsia_V = mkkV "hupsia" ;
lin hupsis_Adv = mkkAdv "hupsis" ;
lin hupsista_Adv = mkkAdv "hupsista" ;
lin hupsu_A = mkkA "hupsu" ;
lin hupsusti_Adv = mkkAdv "hupsusti" ;
lin hupsutella_V = mkkV "hupsutella" ;
lin hupsuttelu_N = mkkN "hupsuttelu" ;
lin hupsutus_N = mkkN "hupsutus" ;
lin hupsuus_N = mkkN "hupsuus" ;
lin hupullinen_N = mkkN "hupullinen" ;
lin huputus_N = mkkN "huputus" ;
lin hurahdella_V = mkkV "hurahdella" ;
lin hurahdus_N = mkkN "hurahdus" ;
lin hurahtaa_V = mkkV "hurahtaa" ;
lin huraus_N = mkkN "huraus" ;
lin hurauttaa_V = mkkV "hurauttaa" ;
lin hurina_N = mkkN "hurina" ;
lin hurista_V = mkkV "hurista" ;
lin huristaa_V = mkkV "huristaa" ;
lin huristella_V = mkkV "huristella" ;
lin hurja_A = mkkA "hurja" ;
lin hurjapa'isyys_N = mkkN "hurjapäisyys" ;
lin hurjastelija_N = mkkN "hurjastelija" ;
lin hurjastella_V = mkkV "hurjastella" ;
lin hurjastelu_N = mkkN "hurjastelu" ;
lin hurjasti_Adv = mkkAdv "hurjasti" ;
lin hurjeta_V = mkkV "hurjeta" ;
lin hurjimus_N = mkkN "hurjimus" ;
lin hurjistaa_V = mkkV "hurjistaa" ;
lin hurjistua_V = mkkV "hurjistua" ;
lin hurjistuttaa_V = mkkV "hurjistuttaa" ;
lin hurjuus_N = mkkN "hurjuus" ;
lin hurlumhei_N = mkkN "hurlumhei" ;
lin hurma_N = mkkN "hurma" ;
lin hurmaaja_N = mkkN "hurmaaja" ;
lin hurmaantua_V = mkkV "hurmaantua" ;
lin hurmaava_A = mkkA "hurmaava" ;
lin hurmaavasti_Adv = mkkAdv "hurmaavasti" ;
lin hurmata_V = mkkV "hurmata" ;
lin hurmaus_N = mkkN "hurmaus" ;
lin hurmautua_V = mkkV "hurmautua" ;
lin hurme_N = mkkN "hurme" ;
lin hurmeinen_N = mkkN "hurmeinen" ;
lin hurmio_N = mkkN "hurmio" ;
lin hurmioitua_V = mkkV "hurmioitua" ;
lin hurmos_N = mkkN "hurmos" ;
lin hurmuri_N = mkkN "hurmuri" ;
lin hurraa_N = mkkN "hurraa" ;
lin hurrata_V = mkkV "hurrata" ;
lin hurri_N = mkkN "hurri" ;
lin hurrikaani_N = mkkN "hurrikaani" ;
lin hurskaasti_Adv = mkkAdv "hurskaasti" ;
lin hurskas_A = mkkA "hurskas" ;
lin hurskastelija_N = mkkN "hurskastelija" ;
lin hurskastella_V = mkkV "hurskastella" ;
lin hurskastelu_N = mkkN "hurskastelu" ;
lin hurskaus_N = mkkN "hurskaus" ;
lin hursti_N = mkkN "hursti" ;
lin hurtta_N = mkkN "hurtta" ;
lin hurtti_N = mkkN "hurtti" ;
lin hurvitella_V = mkkV "hurvitella" ;
lin hurvittelu_N = mkkN "hurvittelu" ;
lin hus_Adv = mkkAdv "hus" ;
lin huseerata_V = mkkV "huseerata" ;
lin hutaista_V = mkkV "hutaista" ;
lin hutera_N = mkkN "hutera" ;
lin huti_N = mkkN "huti" ;
lin hutikka_N = mkkN "hutikka" ;
lin hutiloida_V = mkkV "hutiloida" ;
lin hutiloija_N = mkkN "hutiloija" ;
lin hutilointi_N = mkkN "hutilointi" ;
lin hutilus_N = mkkN "hutilus" ;
lin hutkia_V = mkkV "hutkia" ;
lin hutsu_N = mkkN "hutsu" ;
lin huttu_N = mkkN "huttu" ;
lin hutu_N = mkkN "hutu" ;
lin huudahdella_V = mkkV "huudahdella" ;
lin huudahdus_N = mkkN "huudahdus" ;
lin huudahtaa_V = mkkV "huudahtaa" ;
lin huudattaa_V = mkkV "huudattaa" ;
lin huudella_V = mkkV "huudella" ;
lin huuhaa_N = mkkN "huuhaa" ;
lin huuhde_N = mkkN "huuhde" ;
lin huuhdella_V = mkkV "huuhdella" ;
lin huuhdonta_N = mkkN "huuhdonta" ;
lin huuhkaja_N = mkkN "huuhkaja" ;
lin huuhtaista_V = mkkV "huuhtaista" ;
lin huuhtaisu_N = mkkN "huuhtaisu" ;
lin huuhtelu_N = mkkN "huuhtelu" ;
lin huuhtoa_V = mkkV "huuhtoa" ;
lin huuhtoja_N = mkkN "huuhtoja" ;
lin huuhtoutua_V = mkkV "huuhtoutua" ;
lin huuleilla_V = mkkV "huuleilla" ;
lin huuleilu_N = mkkN "huuleilu" ;
lin huulenheitta'ja'_N = mkkN "huulenheittäjä" ;
lin huuli_N = mkkN "huuli" ;
lin huulinen_N = mkkN "huulinen" ;
lin huulio_N = mkkN "huulio" ;
lin huullos_N = mkkN "huullos" ;
lin huultaa_V = mkkV "huultaa" ;
lin huuma_N = mkkN "huuma" ;
lin huumaannuttaa_V = mkkV "huumaannuttaa" ;
lin huumaantua_V = mkkV "huumaantua" ;
lin huumata_V = mkkV "huumata" ;
lin huumaus_N = mkkN "huumaus" ;
lin huumautua_V = mkkV "huumautua" ;
lin huume_N = mkkN "huume" ;
lin huumori_N = mkkN "huumori" ;
lin huuri_N = mkkN "huuri" ;
lin huurre_N = mkkN "huurre" ;
lin huurruttaa_V = mkkV "huurruttaa" ;
lin huurtaa_V = mkkV "huurtaa" ;
lin huurteinen_N = mkkN "huurteinen" ;
lin huurtua_V = mkkV "huurtua" ;
lin huuru_N = mkkN "huuru" ;
lin huuruinen_N = mkkN "huuruinen" ;
lin huuruta_V = mkkV "huuruta" ;
lin huuruuntua_V = mkkV "huuruuntua" ;
lin huushollata_V = mkkV "huushollata" ;
lin huusholli_N = mkkN "huusholli" ;
lin huusi_N = mkkN "huusi" ;
lin huussi_N = mkkN "huussi" ;
lin huut_Adv = mkkAdv "huut" ;
lin huutaa_V = mkkV "huutaa" ;
lin huutaja_N = mkkN "huutaja" ;
lin huutava_N = mkkN "huutava" ;
lin huutelu_N = mkkN "huutelu" ;
lin huuti_Adv = mkkAdv "huuti" ;
lin huuto_N = mkkN "huuto" ;
lin huventaa_V = mkkV "huventaa" ;
lin huveta_V = mkkV "huveta" ;
lin huvi_N = mkkN "huvi" ;
lin huvikseen_Adv = mkkAdv "huvikseen" ;
lin huvila_N = mkkN "huvila" ;
lin huvitella_V = mkkV "huvitella" ;
lin huvittaa_V = mkkV "huvittaa" ;
lin huvittava_N = mkkN "huvittava" ;
lin huvittavuus_N = mkkN "huvittavuus" ;
lin huvittelu_N = mkkN "huvittelu" ;
lin huvittua_V = mkkV "huvittua" ;
lin huvitus_N = mkkN "huvitus" ;
lin hyasintti_N = mkkN "hyasintti" ;
lin hybridi_N = mkkN "hybridi" ;
lin hybris_N = mkkN "hybris" ;
lin hydraatti_N = mkkN "hydraatti" ;
lin hydrauliikka_N = mkkN "hydrauliikka" ;
lin hydraulinen_A = mkkA "hydraulinen" ;
lin hydraulisesti_Adv = mkkAdv "hydraulisesti" ;
lin hydrokopteri_N = mkkN "hydrokopteri" ;
lin hydroksidi_N = mkkN "hydroksidi" ;
lin hydroksyyli_N = mkkN "hydroksyyli" ;
lin hydrologia_N = mkkN "hydrologia" ;
lin hydrologinen_N = mkkN "hydrologinen" ;
lin hyeena_N = mkkN "hyeena" ;
lin hygieenikko_N = mkkN "hygieenikko" ;
lin hygieeninen_A = mkkA "hygieeninen" ;
lin hygieenisesti_Adv = mkkAdv "hygieenisesti" ;
lin hygieenisyys_N = mkkN "hygieenisyys" ;
lin hygienia_N = mkkN "hygienia" ;
lin hygrometri_N = mkkN "hygrometri" ;
lin hyh_Adv = mkkAdv "hyh" ;
lin hyhmettya'_V = mkkV "hyhmettyä" ;
lin hyhma'_N = mkkN "hyhmä" ;
lin hyhma'inen_N = mkkN "hyhmäinen" ;
lin hyi_Adv = mkkAdv "hyi" ;
lin hyinen_A = mkkA "hyinen" ;
lin hyisesti_Adv = mkkAdv "hyisesti" ;
lin hykerrella'_V = mkkV "hykerrellä" ;
lin hykerrys_N = mkkN "hykerrys" ;
lin hykerrytta'a'_V = mkkV "hykerryttää" ;
lin hykerta'a'_V = mkkV "hykertää" ;
lin hylje_N = mkkN "hylje" ;
lin hyljeksia'_V = mkkV "hyljeksiä" ;
lin hyljinta'_N = mkkN "hyljintä" ;
lin hylja'ta'_V = mkkV "hyljätä" ;
lin hylkia'_V = mkkV "hylkiä" ;
lin hylkio'_N = mkkN "hylkiö" ;
lin hylky_N = mkkN "hylky" ;
lin hylka'ys_N = mkkN "hylkäys" ;
lin hylly_N = mkkN "hylly" ;
lin hyllykko'_N = mkkN "hyllykkö" ;
lin hyllyllinen_N = mkkN "hyllyllinen" ;
lin hyllysto'_N = mkkN "hyllystö" ;
lin hyllytta'a'_1_V = mkkV "hyllyttää" ;
lin hyllytta'a'_2_V = mkkV "hyllyttää" ;
lin hyllya'_V = mkkV "hyllyä" ;
lin hylsy_N = mkkN "hylsy" ;
lin hyla'ta'_V = mkkV "hylätä" ;
lin hymen_N = mkkN "hymen" ;
lin hymina'_N = mkkN "hyminä" ;
lin hymistella'_V = mkkV "hymistellä" ;
lin hymistely_N = mkkN "hymistely" ;
lin hymistys_N = mkkN "hymistys" ;
lin hymista'_V = mkkV "hymistä" ;
lin hymio'_N = mkkN "hymiö" ;
lin hymni_N = mkkN "hymni" ;
lin hymy_N = mkkN "hymy" ;
lin hymyhuulin_Adv = mkkAdv "hymyhuulin" ;
lin hymyilla'_V = mkkV "hymyillä" ;
lin hymyily_N = mkkN "hymyily" ;
lin hymyilytta'a'_V = mkkV "hymyilyttää" ;
lin hymysuin_Adv = mkkAdv "hymysuin" ;
lin hymyta'_V = mkkV "hymytä" ;
lin hyma'hdella'_V = mkkV "hymähdellä" ;
lin hyma'hdys_N = mkkN "hymähdys" ;
lin hyma'hta'a'_V = mkkV "hymähtää" ;
--? lin hyntteet_NK = {s = d48 "hyntteet" ;
--? lin hynttyyt_NK = {s = d17 "hynttyyt" ;
lin hyna'_N = mkkN "hynä" ;
lin hypella'_V = mkkV "hypellä" ;
lin hyperbeli_N = mkkN "hyperbeli" ;
lin hyperbola_N = mkkN "hyperbola" ;
lin hyperbolinen_N = mkkN "hyperbolinen" ;
lin hypertensio_N = mkkN "hypertensio" ;
lin hypertonia_N = mkkN "hypertonia" ;
lin hyperventilaatio_N = mkkN "hyperventilaatio" ;
lin hypistella'_V = mkkV "hypistellä" ;
lin hypistely_N = mkkN "hypistely" ;
lin hypitta'a'_V = mkkV "hypittää" ;
lin hypnologi_N = mkkN "hypnologi" ;
lin hypnoosi_N = mkkN "hypnoosi" ;
lin hypnoottinen_A = mkkA "hypnoottinen" ;
lin hypnoottisesti_Adv = mkkAdv "hypnoottisesti" ;
lin hypnotisoida_V = mkkV "hypnotisoida" ;
lin hypnotisointi_N = mkkN "hypnotisointi" ;
lin hypnotisoitua_V = mkkV "hypnotisoitua" ;
lin hypotaksi_N = mkkN "hypotaksi" ;
lin hypotaktinen_N = mkkN "hypotaktinen" ;
lin hypotalamus_N = mkkN "hypotalamus" ;
lin hypoteekki_N = mkkN "hypoteekki" ;
lin hypoteesi_N = mkkN "hypoteesi" ;
lin hypoteettinen_N = mkkN "hypoteettinen" ;
lin hypotenuusa_N = mkkN "hypotenuusa" ;
lin hypotermia_N = mkkN "hypotermia" ;
lin hyppelehtia'_V = mkkV "hyppelehtiä" ;
lin hyppely_N = mkkN "hyppely" ;
lin hyppia'_V = mkkV "hyppiä" ;
lin hyppy_N = mkkN "hyppy" ;
lin hyppyri_N = mkkN "hyppyri" ;
lin hyppysellinen_N = mkkN "hyppysellinen" ;
--? lin hyppyset_NK = {s = d38 "hyppyset" ;
lin hyppyytta'a'_V = mkkV "hyppyyttää" ;
lin hyppa'yksellinen_N = mkkN "hyppäyksellinen" ;
lin hyppa'yksitta'in_Adv = mkkAdv "hyppäyksittäin" ;
lin hyppa'yksitta'inen_N = mkkN "hyppäyksittäinen" ;
lin hyppa'ys_N = mkkN "hyppäys" ;
lin hyppa'ytta'a'_V = mkkV "hyppäyttää" ;
lin hyppa'a'ja'_N = mkkN "hyppääjä" ;
lin hypa'hdella'_V = mkkV "hypähdellä" ;
lin hypa'hdys_N = mkkN "hypähdys" ;
lin hypa'hta'a'_V = mkkV "hypähtää" ;
lin hypa'ta'_V = mkkV "hypätä" ;
lin hyrina'_N = mkkN "hyrinä" ;
lin hyrista'_V = mkkV "hyristä" ;
lin hyrra'_N = mkkN "hyrrä" ;
lin hyrra'ta'_V = mkkV "hyrrätä" ;
lin hyrske_N = mkkN "hyrske" ;
lin hyrskia'_V = mkkV "hyrskiä" ;
lin hyrsky_N = mkkN "hyrsky" ;
lin hyrskyinen_N = mkkN "hyrskyinen" ;
lin hyrskyta'_V = mkkV "hyrskytä" ;
lin hyrska'hta'a'_V = mkkV "hyrskähtää" ;
lin hyra'hdys_N = mkkN "hyrähdys" ;
lin hyra'hta'a'_V = mkkV "hyrähtää" ;
lin hyra'illa'_V = mkkV "hyräillä" ;
lin hyra'ily_N = mkkN "hyräily" ;
lin hyra'ys_N = mkkN "hyräys" ;
lin hys_Adv = mkkAdv "hys" ;
lin hyssytella'_V = mkkV "hyssytellä" ;
lin hyssyttely_N = mkkN "hyssyttely" ;
lin hyssytta'a'_V = mkkV "hyssyttää" ;
lin hyssytys_N = mkkN "hyssytys" ;
lin hysteerikko_N = mkkN "hysteerikko" ;
lin hysteerinen_A = mkkA "hysteerinen" ;
lin hysteerisesti_Adv = mkkAdv "hysteerisesti" ;
lin hystereesi_N = mkkN "hystereesi" ;
lin hysteria_N = mkkN "hysteria" ;
lin hytina'_N = mkkN "hytinä" ;
lin hytista'_V = mkkV "hytistä" ;
lin hytisytta'a'_V = mkkV "hytisyttää" ;
lin hytkytella'_V = mkkV "hytkytellä" ;
lin hytkytta'a'_V = mkkV "hytkyttää" ;
lin hytkya'_V = mkkV "hytkyä" ;
lin hytka'hdella'_V = mkkV "hytkähdellä" ;
lin hytka'hdytta'a'_V = mkkV "hytkähdyttää" ;
lin hytka'hta'a'_V = mkkV "hytkähtää" ;
lin hytka'ytta'a'_V = mkkV "hytkäyttää" ;
lin hytti_N = mkkN "hytti" ;
lin hyttynen_N = mkkN "hyttynen" ;
lin hyttysparvi_N = mkkN "hyttysparvi" ;
lin hyve_N = mkkN "hyve" ;
lin hyveellinen_A = mkkA "hyveellinen" ;
lin hyveellisesti_Adv = mkkAdv "hyveellisesti" ;
lin hyveellisyys_N = mkkN "hyveellisyys" ;
lin hyvike_N = mkkN "hyvike" ;
lin hyvilleen_Adv = mkkAdv "hyvilleen" ;
lin hyvilla'a'n_Adv = mkkAdv "hyvillään" ;
lin hyvin_Adv = mkkAdv "hyvin" ;
lin hyvinvoiva_N = mkkN "hyvinvoiva" ;
lin hyvite_N = mkkN "hyvite" ;
lin hyvitella'_V = mkkV "hyvitellä" ;
lin hyvittely_N = mkkN "hyvittely" ;
lin hyvitta'a'_V = mkkV "hyvittää" ;
lin hyvitys_N = mkkN "hyvitys" ;
lin hyvyys_N = mkkN "hyvyys" ;
lin hyva'_N = mkkN "hyvä" ;
lin hyva'illa'_V = mkkV "hyväillä" ;
lin hyva'ily_N = mkkN "hyväily" ;
lin hyva'ksyja'_N = mkkN "hyväksyjä" ;
lin hyva'ksymys_N = mkkN "hyväksymys" ;
lin hyva'ksynta'_N = mkkN "hyväksyntä" ;
lin hyva'ksytta'vyys_N = mkkN "hyväksyttävyys" ;
lin hyva'ksytta'va'_A = mkkA "hyväksyttävä" ;
lin hyva'ksytta'va'sti_Adv = mkkAdv "hyväksyttävästi" ;
lin hyva'ksytta'a'_V = mkkV "hyväksyttää" ;
lin hyva'ksya'_V = mkkV "hyväksyä" ;
lin hyva'ka's_N = mkkN "hyväkäs" ;
lin hyva'nen_Adv = mkkAdv "hyvänen" ;
lin hyva'nsuopa_N = mkkN "hyvänsuopa" ;
lin hyva'nsuopuus_N = mkkN "hyvänsuopuus" ;
lin hyva'nsuovasti_Adv = mkkAdv "hyvänsuovasti" ;
lin hyva'nsa'_Adv = mkkAdv "hyvänsä" ;
lin hyva'ntahtoisesti_Adv = mkkAdv "hyväntahtoisesti" ;
lin hyva'ntekeva'isyys_N = mkkN "hyväntekeväisyys" ;
lin hyva'ntuulisesti_Adv = mkkAdv "hyväntuulisesti" ;
lin hyva'stella'_V = mkkV "hyvästellä" ;
lin hyva'stely_N = mkkN "hyvästely" ;
lin hyva'sti_N = mkkN "hyvästi" ;
lin hyva'syda'misesti_Adv = mkkAdv "hyväsydämisesti" ;
lin hyva'uskoisesti_Adv = mkkAdv "hyväuskoisesti" ;
lin hyva'a'_tarkoittava_N = mkkN "hyväC" ;
lin hyyde_N = mkkN "hyyde" ;
lin hyydyke_N = mkkN "hyydyke" ;
lin hyydyte_N = mkkN "hyydyte" ;
lin hyydytta'a'_V = mkkV "hyydyttää" ;
lin hyydytys_N = mkkN "hyydytys" ;
lin hyyhma'_N = mkkN "hyyhmä" ;
lin hyypio'_N = mkkN "hyypiö" ;
lin hyysa'ta'_V = mkkV "hyysätä" ;
lin hyytelo'_N = mkkN "hyytelö" ;
lin hyytelo'ida'_V = mkkV "hyytelöidä" ;
lin hyytelo'itya'_V = mkkV "hyytelöityä" ;
lin hyytyma'_N = mkkN "hyytymä" ;
lin hyytya'_V = mkkV "hyytyä" ;
lin hyyta'a'_V = mkkV "hyytää" ;
lin hyyto'_N = mkkN "hyytö" ;
lin hyo'dyke_N = mkkN "hyödyke" ;
lin hyo'dyka's_N = mkkN "hyödykäs" ;
lin hyo'dyllinen_A = mkkA "hyödyllinen" ;
lin hyo'dyllisesti_Adv = mkkAdv "hyödyllisesti" ;
lin hyo'dyllisyys_N = mkkN "hyödyllisyys" ;
lin hyo'dynta'a'_V = mkkV "hyödyntää" ;
lin hyo'dytta'a'_V = mkkV "hyödyttää" ;
lin hyo'dytto'myys_N = mkkN "hyödyttömyys" ;
lin hyo'dytto'ma'sti_Adv = mkkAdv "hyödyttömästi" ;
lin hyo'dyto'n_N = mkkN "hyödytön" ;
lin hyo'kka'illa'_V = mkkV "hyökkäillä" ;
lin hyo'kka'ily_N = mkkN "hyökkäily" ;
lin hyo'kka'yksellinen_N = mkkN "hyökkäyksellinen" ;
lin hyo'kka'ys_N = mkkN "hyökkäys" ;
lin hyo'kka'a'ja'_N = mkkN "hyökkääjä" ;
lin hyo'kka'a'vyys_N = mkkN "hyökkäävyys" ;
lin hyo'kka'a'va'_A = mkkA "hyökkäävä" ;
lin hyo'kka'a'va'sti_Adv = mkkAdv "hyökkäävästi" ;
lin hyo'ky_N = mkkN "hyöky" ;
lin hyo'kya'_V = mkkV "hyökyä" ;
lin hyo'ka'ta'_V = mkkV "hyökätä" ;
lin hyo'nteinen_N = mkkN "hyönteinen" ;
lin hyo'rinta'_N = mkkN "hyörintä" ;
lin hyo'rina'_N = mkkN "hyörinä" ;
lin hyo'ria'_V = mkkV "hyöriä" ;
lin hyo'ty_N = mkkN "hyöty" ;
lin hyo'tya'_V = mkkV "hyötyä" ;
lin hyo'ta'mo'_N = mkkN "hyötämö" ;
lin hyo'ta'a'_V = mkkV "hyötää" ;
lin hyo'to'_N = mkkN "hyötö" ;
lin ha'_Adv = mkkAdv "hä" ;
lin ha'din_tuskin_Adv = mkkAdv "hädiC" ;
lin ha'dissa'a'n_Adv = mkkAdv "hädissään" ;
lin ha'h_Adv = mkkAdv "häh" ;
lin ha'ha'tta'a'_V = mkkV "hähättää" ;
lin ha'ha'tys_N = mkkN "hähätys" ;
lin ha'ijy_A = mkkA "häijy" ;
lin ha'ijysti_Adv = mkkAdv "häijysti" ;
lin ha'ijyys_N = mkkN "häijyys" ;
lin ha'ikka'_N = mkkN "häikkä" ;
lin ha'ika'ilema'tta'_Adv = mkkAdv "häikäilemättä" ;
lin ha'ika'ilema'tto'myys_N = mkkN "häikäilemättömyys" ;
lin ha'ika'ilema'tto'ma'sti_Adv = mkkAdv "häikäilemättömästi" ;
lin ha'ika'ilema'to'n_N = mkkN "häikäilemätön" ;
lin ha'ika'illa'_V = mkkV "häikäillä" ;
lin ha'ika'istya'_V = mkkV "häikäistyä" ;
lin ha'ika'ista'_V = mkkV "häikäistä" ;
lin ha'ika'isy_N = mkkN "häikäisy" ;
lin ha'ilyvyys_N = mkkN "häilyvyys" ;
lin ha'ilyva'_N = mkkN "häilyvä" ;
lin ha'ilyva'inen_N = mkkN "häilyväinen" ;
lin ha'ilya'_V = mkkV "häilyä" ;
lin ha'ila'hdella'_V = mkkV "häilähdellä" ;
lin ha'ila'hta'a'_V = mkkV "häilähtää" ;
lin ha'ippa'ista'_V = mkkV "häippäistä" ;
lin ha'ipyma'_N = mkkN "häipymä" ;
lin ha'ipya'_V = mkkV "häipyä" ;
lin ha'ipa'ta'_V = mkkV "häipätä" ;
lin ha'iriintynyt_N = mkkN "häiriintynyt" ;
lin ha'iriintya'_V = mkkV "häiriintyä" ;
lin ha'irikko'_N = mkkN "häirikkö" ;
lin ha'iriko'ida'_V = mkkV "häiriköidä" ;
lin ha'irinta'_N = mkkN "häirintä" ;
lin ha'iritsija'_N = mkkN "häiritsijä" ;
lin ha'irita'_V = mkkV "häiritä" ;
lin ha'iriytya'_V = mkkV "häiriytyä" ;
lin ha'irio'_N = mkkN "häiriö" ;
lin ha'irio'inen_N = mkkN "häiriöinen" ;
lin ha'iska'_N = mkkN "häiskä" ;
lin ha'ive_N = mkkN "häive" ;
lin ha'ivytta'a'_V = mkkV "häivyttää" ;
lin ha'ivytys_N = mkkN "häivytys" ;
lin ha'iva'_N = mkkN "häivä" ;
lin ha'iva'hdys_N = mkkN "häivähdys" ;
lin ha'iva'hta'a'_V = mkkV "häivähtää" ;
lin ha'jy_N = mkkN "häjy" ;
lin ha'kellyksiin_Adv = mkkAdv "häkellyksiin" ;
lin ha'kellyksiinsa'_Adv = mkkAdv "häkellyksiinsä" ;
lin ha'kellyksissa'_Adv = mkkAdv "häkellyksissä" ;
lin ha'kellyksissa'a'n_Adv = mkkAdv "häkellyksissään" ;
lin ha'kellys_N = mkkN "häkellys" ;
lin ha'kellytta'a'_V = mkkV "häkellyttää" ;
lin ha'keltya'_V = mkkV "häkeltyä" ;
lin ha'kki_N = mkkN "häkki" ;
lin ha'kkyra'_N = mkkN "häkkyrä" ;
lin ha'ka'_N = mkkN "häkä" ;
lin ha'lina'_N = mkkN "hälinä" ;
lin ha'lino'ida'_V = mkkV "hälinöidä" ;
lin ha'lista'_V = mkkV "hälistä" ;
lin ha'lventya'_V = mkkV "hälventyä" ;
lin ha'lventa'a'_V = mkkV "hälventää" ;
lin ha'lveta'_V = mkkV "hälvetä" ;
lin ha'ly_N = mkkN "häly" ;
lin ha'lytin_N = mkkN "hälytin" ;
lin ha'lyttya'_V = mkkV "hälyttyä" ;
lin ha'lytta'va'_A = mkkA "hälyttävä" ;
lin ha'lytta'va'sti_Adv = mkkAdv "hälyttävästi" ;
lin ha'lytta'a'_V = mkkV "hälyttää" ;
lin ha'lytys_N = mkkN "hälytys" ;
lin ha'lyta'_V = mkkV "hälytä" ;
lin ha'milleen_Adv = mkkAdv "hämilleen" ;
lin ha'millinen_N = mkkN "hämillinen" ;
lin ha'millisyys_N = mkkN "hämillisyys" ;
lin ha'milla'a'n_Adv = mkkAdv "hämillään" ;
lin ha'mmennin_N = mkkN "hämmennin" ;
lin ha'mmennyksiin_Adv = mkkAdv "hämmennyksiin" ;
lin ha'mmennyksissa'_Adv = mkkAdv "hämmennyksissä" ;
lin ha'mmennyksissa'a'n_Adv = mkkAdv "hämmennyksissään" ;
lin ha'mmennys_N = mkkN "hämmennys" ;
lin ha'mmennytta'a'_V = mkkV "hämmennyttää" ;
lin ha'mmentya'_V = mkkV "hämmentyä" ;
lin ha'mmenta'a'_V = mkkV "hämmentää" ;
lin ha'mminki_N = mkkN "hämminki" ;
lin ha'mma'stella'_V = mkkV "hämmästellä" ;
lin ha'mma'stely_N = mkkN "hämmästely" ;
lin ha'mma'styksissa'a'n_Adv = mkkAdv "hämmästyksissään" ;
lin ha'mma'stys_N = mkkN "hämmästys" ;
lin ha'mma'stytta'a'_V = mkkV "hämmästyttää" ;
lin ha'mma'stya'_V = mkkV "hämmästyä" ;
lin ha'my_N = mkkN "hämy" ;
lin ha'myinen_N = mkkN "hämyinen" ;
lin ha'ma'ha'kki_N = mkkN "hämähäkki" ;
lin ha'ma'la'inen_N = mkkN "hämäläinen" ;
lin ha'ma'la'isitta'in_Adv = mkkAdv "hämäläisittäin" ;
lin ha'ma'la'isyys_N = mkkN "hämäläisyys" ;
lin ha'ma'rrytta'a'_V = mkkV "hämärryttää" ;
lin ha'ma'rtya'_V = mkkV "hämärtyä" ;
lin ha'ma'rta'a'_V = mkkV "hämärtää" ;
lin ha'ma'ryys_N = mkkN "hämäryys" ;
lin ha'ma'ra'_A = mkkA "hämärä" ;
lin ha'ma'ra'sti_Adv = mkkAdv "hämärästi" ;
lin ha'ma'ta'_V = mkkV "hämätä" ;
lin ha'ma'ys_N = mkkN "hämäys" ;
lin ha'ma'a'nnyksiin_Adv = mkkAdv "hämäännyksiin" ;
lin ha'ma'a'nnyksissa'_Adv = mkkAdv "hämäännyksissä" ;
lin ha'ma'a'nnyksissa'a'n_Adv = mkkAdv "hämäännyksissään" ;
lin ha'ma'a'nnys_N = mkkN "hämäännys" ;
lin ha'ma'a'nnytta'a'_V = mkkV "hämäännyttää" ;
lin ha'ma'a'ntya'_V = mkkV "hämääntyä" ;
lin ha'nenlaisensa_N = mkkN "hänenlaisensa" ;
lin ha'nnys_N = mkkN "hännys" ;
lin ha'nnystelija'_N = mkkN "hännystelijä" ;
lin ha'nnystella'_V = mkkV "hännystellä" ;
lin ha'nnystely_N = mkkN "hännystely" ;
lin ha'nna'llinen_N = mkkN "hännällinen" ;
lin ha'ntyri_N = mkkN "häntyri" ;
lin ha'nta'_N = mkkN "häntä" ;
lin ha'nta'inen_N = mkkN "häntäinen" ;
lin ha'peilla'_V = mkkV "häpeillä" ;
lin ha'peissa'a'n_Adv = mkkAdv "häpeissään" ;
lin ha'pea'_N = mkkN "häpeä" ;
lin ha'pea'llinen_A = mkkA "häpeällinen" ;
lin ha'pea'llisesti_Adv = mkkAdv "häpeällisesti" ;
lin ha'pea'ma'tto'myys_N = mkkN "häpeämättömyys" ;
lin ha'pea'ma'tto'ma'sti_Adv = mkkAdv "häpeämättömästi" ;
lin ha'pea'ma'to'n_N = mkkN "häpeämätön" ;
lin ha'ppa'_N = mkkN "häppä" ;
lin ha'py_N = mkkN "häpy" ;
lin ha'pa'ista'_V = mkkV "häpäistä" ;
lin ha'pa'isy_N = mkkN "häpäisy" ;
lin ha'rkki_N = mkkN "härkki" ;
lin ha'rkyla'_N = mkkN "härkylä" ;
lin ha'rka'_N = mkkN "härkä" ;
lin ha'rka'nen_N = mkkN "härkänen" ;
lin ha'rka'pa'isesti_Adv = mkkAdv "härkäpäisesti" ;
lin ha'rka'pa'isyys_N = mkkN "härkäpäisyys" ;
lin ha'rme_N = mkkN "härme" ;
lin ha'rmettya'_V = mkkV "härmettyä" ;
lin ha'rmistya'_V = mkkV "härmistyä" ;
lin ha'rmista'a'_V = mkkV "härmistää" ;
lin ha'rma'_N = mkkN "härmä" ;
lin ha'rma'inen_N = mkkN "härmäinen" ;
lin ha'rma'la'inen_N = mkkN "härmäläinen" ;
lin ha'rma'la'isyys_N = mkkN "härmäläisyys" ;
lin ha'rma'a'ntya'_V = mkkV "härmääntyä" ;
lin ha'rna'illa'_V = mkkV "härnäillä" ;
lin ha'rna'ta'_V = mkkV "härnätä" ;
lin ha'rna'ys_N = mkkN "härnäys" ;
lin ha'rski_A = mkkA "härski" ;
lin ha'rskiintya'_V = mkkV "härskiintyä" ;
lin ha'rskisti_Adv = mkkAdv "härskisti" ;
lin ha'rskiys_N = mkkN "härskiys" ;
lin ha'rskiytya'_V = mkkV "härskiytyä" ;
lin ha'rveli_N = mkkN "härveli" ;
lin ha'ssia'_V = mkkV "hässiä" ;
lin ha'ssa'kka'_N = mkkN "hässäkkä" ;
lin ha'tha'ta'a'_Adv = mkkAdv "häthätää" ;
lin ha'tiko'ida'_V = mkkV "hätiköidä" ;
lin ha'tiko'inti_N = mkkN "hätiköinti" ;
lin ha'timmiten_Adv = mkkAdv "hätimmiten" ;
lin ha'tistella'_V = mkkV "hätistellä" ;
lin ha'tista'a'_V = mkkV "hätistää" ;
lin ha'tka'hdella'_V = mkkV "hätkähdellä" ;
lin ha'tka'hdys_N = mkkN "hätkähdys" ;
lin ha'tka'hdytta'a'_V = mkkV "hätkähdyttää" ;
lin ha'tka'hta'a'_V = mkkV "hätkähtää" ;
lin ha'tka'ytta'a'_V = mkkV "hätkäyttää" ;
lin ha'tyytella'_V = mkkV "hätyytellä" ;
lin ha'tyytta'a'_V = mkkV "hätyyttää" ;
lin ha'tyytys_N = mkkN "hätyytys" ;
lin ha'ta'_N = mkkN "hätä" ;
lin ha'ta'housu_N = mkkN "hätähousu" ;
lin ha'ta'illa'_V = mkkV "hätäillä" ;
lin ha'ta'ily_N = mkkN "hätäily" ;
lin ha'ta'inen_A = mkkA "hätäinen" ;
lin ha'ta'isesti_Adv = mkkAdv "hätäisesti" ;
lin ha'ta'a'nnyksissa'_Adv = mkkAdv "hätäännyksissä" ;
lin ha'ta'a'nnyksissa'a'n_Adv = mkkAdv "hätäännyksissään" ;
lin ha'ta'a'nnys_N = mkkN "hätäännys" ;
lin ha'ta'a'nnytta'a'_V = mkkV "hätäännyttää" ;
lin ha'ta'a'ntya'_V = mkkV "hätääntyä" ;
lin ha'velia'isyys_N = mkkN "häveliäisyys" ;
lin ha'velia's_A = mkkA "häveliäs" ;
lin ha'velia'a'sti_Adv = mkkAdv "häveliäästi" ;
lin ha'vetta'a'_V = mkkV "hävettää" ;
lin ha'veta'_V = mkkV "hävetä" ;
lin ha'vikki_N = mkkN "hävikki" ;
lin ha'vite_N = mkkN "hävite" ;
lin ha'vitta'ja'_N = mkkN "hävittäjä" ;
lin ha'vitta'a'_V = mkkV "hävittää" ;
lin ha'vitys_N = mkkN "hävitys" ;
lin ha'vita'_V = mkkV "hävitä" ;
lin ha'via'ja'_N = mkkN "häviäjä" ;
lin ha'via'ma'tto'myys_N = mkkN "häviämättömyys" ;
lin ha'via'ma'to'n_N = mkkN "häviämätön" ;
lin ha'vio'_N = mkkN "häviö" ;
lin ha'vytto'myys_N = mkkN "hävyttömyys" ;
lin ha'vytto'ma'sti_Adv = mkkAdv "hävyttömästi" ;
lin ha'vyto'n_N = mkkN "hävytön" ;
lin ha'va'istys_N = mkkN "häväistys" ;
lin ha'va'ista'_V = mkkV "häväistä" ;
lin ha'a'della'_V = mkkV "häädellä" ;
lin ha'a'lento_N = mkkN "häälento" ;
lin ha'a'lyva'_N = mkkN "häälyvä" ;
lin ha'a'lyva'inen_N = mkkN "häälyväinen" ;
lin ha'a'lya'_V = mkkV "häälyä" ;
lin ha'a'mo'tta'a'_V = mkkV "häämöttää" ;
lin ha'a'mo'tys_N = mkkN "häämötys" ;
lin ha'a'pari_N = mkkN "hääpari" ;
lin ha'a'ppo'inen_N = mkkN "hääppöinen" ;
lin ha'a'rinta'_N = mkkN "häärintä" ;
lin ha'a'rina'_N = mkkN "häärinä" ;
lin ha'a'ria'_V = mkkV "hääriä" ;
lin ha'a'ra'illa'_V = mkkV "hääräillä" ;
lin ha'a'ra'ily_N = mkkN "hääräily" ;
lin ha'a'ra'ta'_V = mkkV "häärätä" ;
--? lin ha'a't_NK = {s = d18 "häät" ;
lin ha'a'ta'a'_V = mkkV "häätää" ;
lin ha'a'to'_N = mkkN "häätö" ;
lin ha'a'vi_A = mkkA "häävi" ;
lin ha'a'visti_Adv = mkkAdv "häävisti" ;
lin ho'hla'_N = mkkN "höhlä" ;
lin ho'kkeli_N = mkkN "hökkeli" ;
lin ho'ko'tys_N = mkkN "hökötys" ;
lin ho'lina'_N = mkkN "hölinä" ;
lin ho'lista'_V = mkkV "hölistä" ;
lin ho'lkka'_N = mkkN "hölkkä" ;
lin ho'lkka'a'ja'_N = mkkN "hölkkääjä" ;
lin ho'lkytella'_V = mkkV "hölkytellä" ;
lin ho'lkytta'a'_V = mkkV "hölkyttää" ;
lin ho'lka'ta'_V = mkkV "hölkätä" ;
lin ho'llennys_N = mkkN "höllennys" ;
lin ho'llentya'_V = mkkV "höllentyä" ;
lin ho'llenta'a'_V = mkkV "höllentää" ;
lin ho'lleta'_V = mkkV "hölletä" ;
lin ho'llyys_N = mkkN "höllyys" ;
lin ho'lla'_A = mkkA "höllä" ;
lin ho'lla'ka'tisesti_Adv = mkkAdv "hölläkätisesti" ;
lin ho'lla'lle_Adv = mkkAdv "höllälle" ;
lin ho'lla'lla'_Adv = mkkAdv "höllällä" ;
lin ho'lla'ssa'_Adv = mkkAdv "höllässä" ;
lin ho'lla'sti_Adv = mkkAdv "höllästi" ;
lin ho'lla'ta'_V = mkkV "höllätä" ;
lin ho'lla'a'n_Adv = mkkAdv "höllään" ;
lin ho'lmistys_N = mkkN "hölmistys" ;
lin ho'lmistytta'a'_V = mkkV "hölmistyttää" ;
lin ho'lmistya'_V = mkkV "hölmistyä" ;
lin ho'lmo'_A = mkkA "hölmö" ;
lin ho'lmo'illa'_V = mkkV "hölmöillä" ;
lin ho'lmo'la'inen_N = mkkN "hölmöläinen" ;
lin ho'lmo'sti_Adv = mkkAdv "hölmösti" ;
lin ho'lmo'ys_N = mkkN "hölmöys" ;
lin ho'lpo'tta'a'_V = mkkV "hölpöttää" ;
lin ho'lskytta'a'_V = mkkV "hölskyttää" ;
lin ho'lskya'_V = mkkV "hölskyä" ;
lin ho'ltya'_V = mkkV "höltyä" ;
lin ho'la'ytta'a'_V = mkkV "höläyttää" ;
lin ho'lo'_N = mkkN "hölö" ;
lin ho'lo'tta'a'_V = mkkV "hölöttää" ;
lin ho'mppa'_N = mkkN "hömppä" ;
lin ho'mpsy_N = mkkN "hömpsy" ;
lin ho'mpso'tta'a'_V = mkkV "hömpsöttää" ;
lin ho'mpso'tys_N = mkkN "hömpsötys" ;
lin ho'mpo'tta'a'_V = mkkV "hömpöttää" ;
lin ho'mpo'tys_N = mkkN "hömpötys" ;
lin ho'nka'ista'_V = mkkV "hönkäistä" ;
lin ho'ntti_N = mkkN "höntti" ;
lin ho'no'_N = mkkN "hönö" ;
lin ho'peryys_N = mkkN "höperyys" ;
lin ho'pero'_A = mkkA "höperö" ;
lin ho'pero'sti_Adv = mkkAdv "höperösti" ;
lin ho'pina'_N = mkkN "höpinä" ;
lin ho'pista'_V = mkkV "höpistä" ;
lin ho'pla'sta'_Adv = mkkAdv "höplästä" ;
lin ho'ppa'na'_N = mkkN "höppänä" ;
lin ho'psis_Adv = mkkAdv "höpsis" ;
lin ho'psista'_Adv = mkkAdv "höpsistä" ;
lin ho'psia'_V = mkkV "höpsiä" ;
lin ho'psa'hta'nyt_N = mkkN "höpsähtänyt" ;
lin ho'psa'hta'va'_N = mkkN "höpsähtävä" ;
lin ho'pso'_N = mkkN "höpsö" ;
lin ho'po'_N = mkkN "höpö" ;
lin ho'po'n_Adv = mkkAdv "höpön" ;
lin ho'po'tta'a'_V = mkkV "höpöttää" ;
lin ho'po'tys_N = mkkN "höpötys" ;
lin ho'rhelo'_N = mkkN "hörhelö" ;
lin ho'rho'_N = mkkN "hörhö" ;
lin ho'ristella'_V = mkkV "höristellä" ;
lin ho'rista'a'_V = mkkV "höristää" ;
lin ho'rppia'_V = mkkV "hörppiä" ;
lin ho'rppy_N = mkkN "hörppy" ;
lin ho'rpa'ta'_V = mkkV "hörpätä" ;
lin ho'rtso'_N = mkkN "hörtsö" ;
lin ho'ra'hdella'_V = mkkV "hörähdellä" ;
lin ho'ra'hdys_N = mkkN "hörähdys" ;
lin ho'ra'hta'a'_V = mkkV "hörähtää" ;
lin ho'ro'lle_Adv = mkkAdv "hörölle" ;
lin ho'ro'lleen_Adv = mkkAdv "hörölleen" ;
lin ho'ro'lla'_Adv = mkkAdv "höröllä" ;
lin ho'ro'lla'a'n_Adv = mkkAdv "höröllään" ;
lin ho'ro'ssa'_Adv = mkkAdv "hörössä" ;
lin ho'ro'tta'a'_V = mkkV "höröttää" ;
lin ho'ro'tys_N = mkkN "hörötys" ;
lin ho'ro'o'n_Adv = mkkAdv "höröön" ;
lin ho'ska'_N = mkkN "höskä" ;
lin ho'sseli_N = mkkN "hösseli" ;
lin ho'ssa'kka'_N = mkkN "hössäkkä" ;
lin ho'sso'tta'a'_V = mkkV "hössöttää" ;
lin ho'sso'tys_N = mkkN "hössötys" ;
lin ho'tkyilla'_V = mkkV "hötkyillä" ;
lin ho'tkyily_N = mkkN "hötkyily" ;
lin ho'tto'_N = mkkN "höttö" ;
lin ho'tto'sissa'a'n_Adv = mkkAdv "höttösissään" ;
lin ho'ta'kka'_N = mkkN "hötäkkä" ;
lin ho'to'_N = mkkN "hötö" ;
lin ho'veli_A = mkkA "höveli" ;
lin ho'velisti_Adv = mkkAdv "hövelisti" ;
lin ho'yde_N = mkkN "höyde" ;
lin ho'yhen_N = mkkN "höyhen" ;
lin ho'yheninen_N = mkkN "höyheninen" ;
lin ho'yhenisto'_N = mkkN "höyhenistö" ;
lin ho'yhennys_N = mkkN "höyhennys" ;
lin ho'yhenta'a'_V = mkkV "höyhentää" ;
lin ho'yhenys_N = mkkN "höyhenys" ;
lin ho'ykky_N = mkkN "höykky" ;
lin ho'ykytta'a'_V = mkkV "höykyttää" ;
lin ho'ykytys_N = mkkN "höykytys" ;
lin ho'yka'nen_Adv = mkkAdv "höykänen" ;
lin ho'yli_A = mkkA "höyli" ;
lin ho'ylisti_Adv = mkkAdv "höylisti" ;
lin ho'yla'_N = mkkN "höylä" ;
lin ho'yla'ta'_V = mkkV "höylätä" ;
lin ho'yla'ys_N = mkkN "höyläys" ;
lin ho'yla'ytya'_V = mkkV "höyläytyä" ;
lin ho'yla'a'mo'_N = mkkN "höyläämö" ;
lin ho'yla'a'ntya'_V = mkkV "höylääntyä" ;
lin ho'yna'_N = mkkN "höynä" ;
lin ho'yna'hta'a'_V = mkkV "höynähtää" ;
lin ho'yna'ytta'a'_V = mkkV "höynäyttää" ;
lin ho'yry_N = mkkN "höyry" ;
lin ho'yryinen_N = mkkN "höyryinen" ;
lin ho'yrystin_N = mkkN "höyrystin" ;
lin ho'yrystys_N = mkkN "höyrystys" ;
lin ho'yrystya'_V = mkkV "höyrystyä" ;
lin ho'yrysta'a'_V = mkkV "höyrystää" ;
lin ho'yrytin_N = mkkN "höyrytin" ;
lin ho'yryttya'_V = mkkV "höyryttyä" ;
lin ho'yrytta'a'_V = mkkV "höyryttää" ;
lin ho'yrytys_N = mkkN "höyrytys" ;
lin ho'yryta'_V = mkkV "höyrytä" ;
lin ho'yryyntya'_V = mkkV "höyryyntyä" ;
lin ho'yra'hta'a'_V = mkkV "höyrähtää" ;
lin ho'yste_N = mkkN "höyste" ;
lin ho'ysta'a'_V = mkkV "höystää" ;
lin ho'ysto'_N = mkkN "höystö" ;
lin ho'yty_N = mkkN "höyty" ;
lin ho'ytyinen_N = mkkN "höytyinen" ;
lin ho'ytyva'_N = mkkN "höytyvä" ;
lin ho'yta'le_N = mkkN "höytäle" ;
lin ho'o'sa'ta'_V = mkkV "höösätä" ;
lin ho'o'sa'ys_N = mkkN "höösäys" ;
lin iankaiken_Adv = mkkAdv "iankaiken" ;
lin iankaikkinen_A = mkkA "iankaikkinen" ;
lin iankaikkisesti_Adv = mkkAdv "iankaikkisesti" ;
lin iankaikkisuus_N = mkkN "iankaikkisuus" ;
lin icing_N = mkkN "icing" ;
lin idea_N = mkkN "idea" ;
lin ideaali_N = mkkN "ideaali" ;
lin ideaalistaa_V = mkkV "ideaalistaa" ;
lin ideaalisuus_N = mkkN "ideaalisuus" ;
lin idealismi_N = mkkN "idealismi" ;
lin idealisoida_V = mkkV "idealisoida" ;
lin idealisti_N = mkkN "idealisti" ;
lin idealistinen_N = mkkN "idealistinen" ;
lin idemma'ksi_Adv = mkkAdv "idemmäksi" ;
lin idemma's_Adv = mkkAdv "idemmäs" ;
lin idempi_N = mkkN "idempi" ;
lin idempa'na'_Adv = mkkAdv "idempänä" ;
lin idempa'a'_Adv = mkkAdv "idempää" ;
lin identifikaatio_N = mkkN "identifikaatio" ;
lin identifioida_V = mkkV "identifioida" ;
lin identifiointi_N = mkkN "identifiointi" ;
lin identifioitua_V = mkkV "identifioitua" ;
lin identiteetti_N = mkkN "identiteetti" ;
lin identtinen_A = mkkA "identtinen" ;
lin identtisesti_Adv = mkkAdv "identtisesti" ;
lin identtisyys_N = mkkN "identtisyys" ;
lin ideoida_V = mkkV "ideoida" ;
lin ideointi_N = mkkN "ideointi" ;
lin ideologi_N = mkkN "ideologi" ;
lin ideologia_N = mkkN "ideologia" ;
lin ideologinen_N = mkkN "ideologinen" ;
lin idiomi_N = mkkN "idiomi" ;
lin idiootti_N = mkkN "idiootti" ;
lin idioottimaisesti_Adv = mkkAdv "idioottimaisesti" ;
lin idioottimaisuus_N = mkkN "idioottimaisuus" ;
lin idis_N = mkkN "idis" ;
lin idoli_N = mkkN "idoli" ;
lin idylli_N = mkkN "idylli" ;
lin idyllinen_A = mkkA "idyllinen" ;
lin idyllisesti_Adv = mkkAdv "idyllisesti" ;
lin idyllisyys_N = mkkN "idyllisyys" ;
lin ida'tella'_V = mkkV "idätellä" ;
lin ida'tta'a'_V = mkkV "idättää" ;
lin ida'tys_N = mkkN "idätys" ;
lin ien_N = mkkN "ien" ;
lin ies_N = mkkN "ies" ;
lin iesta'a'_V = mkkV "iestää" ;
lin iglu_N = mkkN "iglu" ;
lin igumeeni_N = mkkN "igumeeni" ;
lin ihailevasti_Adv = mkkAdv "ihailevasti" ;
lin ihailija_N = mkkN "ihailija" ;
lin ihailla_V = mkkV "ihailla" ;
lin ihailtava_A = mkkA "ihailtava" ;
lin ihailtavasti_Adv = mkkAdv "ihailtavasti" ;
lin ihailu_N = mkkN "ihailu" ;
lin ihan_Adv = mkkAdv "ihan" ;
lin ihana_A = mkkA "ihana" ;
lin ihanasti_Adv = mkkAdv "ihanasti" ;
lin ihanne_N = mkkN "ihanne" ;
lin ihanneaika_N = mkkN "ihanneaika" ;
lin ihannoida_V = mkkV "ihannoida" ;
lin ihannointi_N = mkkN "ihannointi" ;
lin ihanteellinen_A = mkkA "ihanteellinen" ;
lin ihanteellisesti_Adv = mkkAdv "ihanteellisesti" ;
lin ihanteellisuus_N = mkkN "ihanteellisuus" ;
lin ihanuus_N = mkkN "ihanuus" ;
lin ihastella_V = mkkV "ihastella" ;
lin ihastelu_N = mkkN "ihastelu" ;
lin ihastua_V = mkkV "ihastua" ;
lin ihastuksissaan_Adv = mkkAdv "ihastuksissaan" ;
lin ihastus_N = mkkN "ihastus" ;
lin ihastuttaa_V = mkkV "ihastuttaa" ;
lin ihastuttava_A = mkkA "ihastuttava" ;
lin ihastuttavasti_Adv = mkkAdv "ihastuttavasti" ;
lin ihka_Adv = mkkAdv "ihka" ;
lin ihkasen_Adv = mkkAdv "ihkasen" ;
lin ihme_A = mkkA "ihme" ;
lin ihmeellinen_N = mkkN "ihmeellinen" ;
lin ihmeellisesti_Adv = mkkAdv "ihmeellisesti" ;
lin ihmeellisyys_N = mkkN "ihmeellisyys" ;
lin ihmeemmin_Adv = mkkAdv "ihmeemmin" ;
lin ihmeesti_Adv = mkkAdv "ihmeesti" ;
lin ihmeisiinsa'_Adv = mkkAdv "ihmeisiinsä" ;
lin ihmeissa'a'n_Adv = mkkAdv "ihmeissään" ;
lin ihmetella'_V = mkkV "ihmetellä" ;
lin ihmetelta'va'_A = mkkA "ihmeteltävä" ;
lin ihmetelta'va'sti_Adv = mkkAdv "ihmeteltävästi" ;
lin ihmettely_N = mkkN "ihmettely" ;
lin ihmetys_N = mkkN "ihmetys" ;
lin ihmetytta'a'_V = mkkV "ihmetyttää" ;
lin ihminen_N = mkkN "ihminen" ;
lin ihmisma'inen_A = mkkA "ihmismäinen" ;
lin ihmisma'isesti_Adv = mkkAdv "ihmismäisesti" ;
lin ihmisma'istya'_V = mkkV "ihmismäistyä" ;
lin ihmisparka_N = mkkN "ihmisparka" ;
lin ihmistya'_V = mkkV "ihmistyä" ;
lin ihmisyys_N = mkkN "ihmisyys" ;
lin iho_N = mkkN "iho" ;
lin ihoinen_N = mkkN "ihoinen" ;
lin ihokas_N = mkkN "ihokas" ;
lin ihottuma_N = mkkN "ihottuma" ;
lin ihra_N = mkkN "ihra" ;
lin iibis_N = mkkN "iibis" ;
lin iikka_N = mkkN "iikka" ;
lin iilia'inen_N = mkkN "iiliäinen" ;
lin iiri_N = mkkN "iiri" ;
lin iirila'inen_N = mkkN "iiriläinen" ;
lin iiris_N = mkkN "iiris" ;
lin iisi_A = mkkA "iisi" ;
lin iisisti_Adv = mkkAdv "iisisti" ;
lin iisoppi_N = mkkN "iisoppi" ;
lin iivana_N = mkkN "iivana" ;
lin ikebana_N = mkkN "ikebana" ;
lin ikiaika_N = mkkN "ikiaika" ;
lin iki_ihastunut_N = mkkN "iki-ihastunut" ;
lin ikimaailmassa_Adv = mkkAdv "ikimaailmassa" ;
lin ikinen_N = mkkN "ikinen" ;
lin ikina'_Adv = mkkAdv "ikinä" ;
lin ikipa'iviksi_Adv = mkkAdv "ikipäiviksi" ;
lin ikipa'ivina'_Adv = mkkAdv "ikipäivinä" ;
lin ikipa'iva'na'_Adv = mkkAdv "ikipäivänä" ;
lin ikkuna_N = mkkN "ikkuna" ;
lin ikkunainen_N = mkkN "ikkunainen" ;
lin ikkunallinen_N = mkkN "ikkunallinen" ;
lin ikkunanhaka_N = mkkN "ikkunanhaka" ;
lin ikkunanpesija'_N = mkkN "ikkunanpesijä" ;
lin ikkunoida_V = mkkV "ikkunoida" ;
lin ikkunointi_N = mkkN "ikkunointi" ;
lin ikoni_N = mkkN "ikoni" ;
lin ikoninen_N = mkkN "ikoninen" ;
lin ikonisuus_N = mkkN "ikonisuus" ;
lin ikonostaasi_N = mkkN "ikonostaasi" ;
lin iktyonomi_N = mkkN "iktyonomi" ;
lin ikuinen_A = mkkA "ikuinen" ;
lin ikuisesti_Adv = mkkAdv "ikuisesti" ;
lin ikuistaa_V = mkkV "ikuistaa" ;
lin ikuisuus_N = mkkN "ikuisuus" ;
lin ika'_N = mkkN "ikä" ;
lin ika'inen_N = mkkN "ikäinen" ;
lin ika'johtaminen_N = mkkN "ikäjohtaminen" ;
lin ika'na'_Adv = mkkAdv "ikänä" ;
lin ika'vissa'a'n_Adv = mkkAdv "ikävissään" ;
lin ika'vystyneesti_Adv = mkkAdv "ikävystyneesti" ;
lin ika'vystyneisyys_N = mkkN "ikävystyneisyys" ;
lin ika'vystynyt_A = mkkA "ikävystynyt" ;
lin ika'vystytta'vyys_N = mkkN "ikävystyttävyys" ;
lin ika'vystytta'va'_A = mkkA "ikävystyttävä" ;
lin ika'vystytta'va'sti_Adv = mkkAdv "ikävystyttävästi" ;
lin ika'vystytta'a'_V = mkkV "ikävystyttää" ;
lin ika'vystya'_V = mkkV "ikävystyä" ;
lin ika'vyys_N = mkkN "ikävyys" ;
lin ika'va'_A = mkkA "ikävä" ;
lin ika'va'sti_Adv = mkkAdv "ikävästi" ;
lin ika'vo'ida'_V = mkkV "ikävöidä" ;
lin ika'vo'inti_N = mkkN "ikävöinti" ;
lin ika'ys_N = mkkN "ikäys" ;
lin ika'a'n_Adv = mkkAdv "ikään" ;
lin ika'a'n_kuin_Adv = mkkAdv "ikääC" ;
lin ika'a'ntya'_V = mkkV "ikääntyä" ;
lin ilahduttaa_V = mkkV "ilahduttaa" ;
lin ilahtua_V = mkkV "ilahtua" ;
lin ilakoida_V = mkkV "ilakoida" ;
lin ilakointi_N = mkkN "ilakointi" ;
lin iljanko_N = mkkN "iljanko" ;
lin iljankoinen_N = mkkN "iljankoinen" ;
lin iljanne_N = mkkN "iljanne" ;
lin iljanteinen_N = mkkN "iljanteinen" ;
lin iljetta'vyys_N = mkkN "iljettävyys" ;
lin iljetta'va'_A = mkkA "iljettävä" ;
lin iljetta'va'sti_Adv = mkkAdv "iljettävästi" ;
lin iljetta'a'_V = mkkV "iljettää" ;
lin iljetys_N = mkkN "iljetys" ;
lin iljeta'_V = mkkV "iljetä" ;
lin ilkamoida_V = mkkV "ilkamoida" ;
lin ilkamointi_N = mkkN "ilkamointi" ;
lin ilkeilla'_V = mkkV "ilkeillä" ;
lin ilkeily_N = mkkN "ilkeily" ;
lin ilkeys_N = mkkN "ilkeys" ;
lin ilkea'_A = mkkA "ilkeä" ;
lin ilkea'sti_Adv = mkkAdv "ilkeästi" ;
lin ilki_Adv = mkkAdv "ilki" ;
lin ilkikurinen_A = mkkA "ilkikurinen" ;
lin ilkikurisesti_Adv = mkkAdv "ilkikurisesti" ;
lin ilkikurisuus_N = mkkN "ilkikurisuus" ;
lin ilkimys_N = mkkN "ilkimys" ;
lin ilkinen_N = mkkN "ilkinen" ;
lin ilkivaltaisesti_Adv = mkkAdv "ilkivaltaisesti" ;
lin ilkio'_N = mkkN "ilkiö" ;
lin ilkkua_V = mkkV "ilkkua" ;
lin ilkosen_Adv = mkkAdv "ilkosen" ;
lin ilkosillaan_Adv = mkkAdv "ilkosillaan" ;
lin ilkosilleen_Adv = mkkAdv "ilkosilleen" ;
lin illakko_N = mkkN "illakko" ;
lin illallinen_N = mkkN "illallinen" ;
lin illastaa_V = mkkV "illastaa" ;
lin illatiivi_N = mkkN "illatiivi" ;
--? lin illatsut_NK = {s = d02 "illatsut" ;
lin illemmaksi_Adv = mkkAdv "illemmaksi" ;
lin illemmalla_Adv = mkkAdv "illemmalla" ;
lin illempana_Adv = mkkAdv "illempana" ;
lin illusorinen_N = mkkN "illusorinen" ;
lin illustraatio_N = mkkN "illustraatio" ;
lin illustroida_V = mkkV "illustroida" ;
lin illuusio_N = mkkN "illuusio" ;
lin ilma_N = mkkN "ilma" ;
lin ilmaantua_V = mkkV "ilmaantua" ;
lin ilmaantuvuus_N = mkkN "ilmaantuvuus" ;
lin ilmailla_V = mkkV "ilmailla" ;
lin ilmailu_N = mkkN "ilmailu" ;
lin ilmainen_N = mkkN "ilmainen" ;
lin ilmaisanti_N = mkkN "ilmaisanti" ;
lin ilmaiseksi_Adv = mkkAdv "ilmaiseksi" ;
lin ilmaisija_N = mkkN "ilmaisija" ;
lin ilmaisin_N = mkkN "ilmaisin" ;
lin ilmaisosakeanti_N = mkkN "ilmaisosakeanti" ;
lin ilmaista_V = mkkV "ilmaista" ;
lin ilmaisu_N = mkkN "ilmaisu" ;
lin ilmaisullinen_N = mkkN "ilmaisullinen" ;
lin ilmajuuri_N = mkkN "ilmajuuri" ;
lin ilman_Adv = mkkAdv "ilman" ;
lin ilmanpita'va'sti_Adv = mkkAdv "ilmanpitävästi" ;
lin ilmastaa_V = mkkV "ilmastaa" ;
lin ilmaste_N = mkkN "ilmaste" ;
lin ilmastin_N = mkkN "ilmastin" ;
lin ilmasto_N = mkkN "ilmasto" ;
lin ilmastoida_V = mkkV "ilmastoida" ;
lin ilmastoinen_N = mkkN "ilmastoinen" ;
lin ilmastointi_N = mkkN "ilmastointi" ;
lin ilmastollinen_A = mkkA "ilmastollinen" ;
lin ilmastollisesti_Adv = mkkAdv "ilmastollisesti" ;
lin ilmastua_V = mkkV "ilmastua" ;
lin ilmastus_N = mkkN "ilmastus" ;
lin ilmata_V = mkkV "ilmata" ;
lin ilmaton_N = mkkN "ilmaton" ;
lin ilmaus_N = mkkN "ilmaus" ;
lin ilmava_A = mkkA "ilmava" ;
lin ilmavasti_Adv = mkkAdv "ilmavasti" ;
lin ilmavuus_N = mkkN "ilmavuus" ;
lin ilme_N = mkkN "ilme" ;
lin ilmeetto'myys_N = mkkN "ilmeettömyys" ;
lin ilmeetto'ma'sti_Adv = mkkAdv "ilmeettömästi" ;
lin ilmeeto'n_N = mkkN "ilmeetön" ;
lin ilmehdinta'_N = mkkN "ilmehdintä" ;
lin ilmehtia'_V = mkkV "ilmehtiä" ;
lin ilmeikkyys_N = mkkN "ilmeikkyys" ;
lin ilmeikka'a'sti_Adv = mkkAdv "ilmeikkäästi" ;
lin ilmeika's_A = mkkA "ilmeikäs" ;
lin ilmeilla'_V = mkkV "ilmeillä" ;
lin ilmeily_N = mkkN "ilmeily" ;
lin ilmeinen_1_A = mkkA "ilmeinen" ;
lin ilmeinen_2_A = mkkA "ilmeinen" ;
lin ilmeisesti_Adv = mkkAdv "ilmeisesti" ;
lin ilmeitta'a'_V = mkkV "ilmeittää" ;
lin ilmenema'_N = mkkN "ilmenemä" ;
lin ilmennys_N = mkkN "ilmennys" ;
lin ilmentyma'_N = mkkN "ilmentymä" ;
lin ilmentya'_V = mkkV "ilmentyä" ;
lin ilmenta'a'_V = mkkV "ilmentää" ;
lin ilmestymisaika_N = mkkN "ilmestymisaika" ;
lin ilmestys_N = mkkN "ilmestys" ;
lin ilmestya'_V = mkkV "ilmestyä" ;
lin ilmetty_N = mkkN "ilmetty" ;
lin ilmeta'_V = mkkV "ilmetä" ;
lin ilmi_Adv = mkkAdv "ilmi" ;
lin ilmio'_N = mkkN "ilmiö" ;
lin ilmio'ma'inen_A = mkkA "ilmiömäinen" ;
lin ilmio'ma'isesti_Adv = mkkAdv "ilmiömäisesti" ;
lin ilmio'ma'isyys_N = mkkN "ilmiömäisyys" ;
lin ilmoinen_Adv = mkkAdv "ilmoinen" ;
lin ilmoitella_V = mkkV "ilmoitella" ;
lin ilmoitse_Adv = mkkAdv "ilmoitse" ;
lin ilmoittaa_V = mkkV "ilmoittaa" ;
lin ilmoittaja_N = mkkN "ilmoittaja" ;
lin ilmoittautua_V = mkkV "ilmoittautua" ;
lin ilmoittautumisaika_N = mkkN "ilmoittautumisaika" ;
lin ilmoittelu_N = mkkN "ilmoittelu" ;
lin ilmoittua_V = mkkV "ilmoittua" ;
lin ilmoitus_N = mkkN "ilmoitus" ;
lin ilo_N = mkkN "ilo" ;
lin iloinen_A = mkkA "iloinen" ;
lin iloisesti_Adv = mkkAdv "iloisesti" ;
lin iloissaan_Adv = mkkAdv "iloissaan" ;
lin iloisuus_N = mkkN "iloisuus" ;
lin iloita_V = mkkV "iloita" ;
lin ilostua_V = mkkV "ilostua" ;
lin ilostuttaa_V = mkkV "ilostuttaa" ;
lin ilotella_V = mkkV "ilotella" ;
lin iloton_N = mkkN "iloton" ;
lin ilottelu_N = mkkN "ilottelu" ;
lin ilottomasti_Adv = mkkAdv "ilottomasti" ;
lin ilottomuus_N = mkkN "ilottomuus" ;
lin ilta_N = mkkN "ilta" ;
lin iltainen_N = mkkN "iltainen" ;
lin iltaisin_Adv = mkkAdv "iltaisin" ;
lin iltama_N = mkkN "iltama" ;
lin iltanen_N = mkkN "iltanen" ;
lin iltasella_Adv = mkkAdv "iltasella" ;
lin iltti_N = mkkN "iltti" ;
lin ilve_N = mkkN "ilve" ;
lin ilvehtia'_V = mkkV "ilvehtiä" ;
lin ilveilija'_N = mkkN "ilveilijä" ;
lin ilveilla'_V = mkkV "ilveillä" ;
lin ilveily_N = mkkN "ilveily" ;
lin ilves_N = mkkN "ilves" ;
lin imaami_N = mkkN "imaami" ;
lin image_N = mkkN "image" ;
lin imaginaarinen_N = mkkN "imaginaarinen" ;
lin imago_N = mkkN "imago" ;
lin imaista_V = mkkV "imaista" ;
lin imaisu_N = mkkN "imaisu" ;
lin imarre_N = mkkN "imarre" ;
lin imarrella_V = mkkV "imarrella" ;
lin imartelu_N = mkkN "imartelu" ;
lin imbesilli_N = mkkN "imbesilli" ;
lin imeksia'_V = mkkV "imeksiä" ;
lin imelle_N = mkkN "imelle" ;
lin imellys_N = mkkN "imellys" ;
lin imellytta'a'_V = mkkV "imellyttää" ;
lin imeltya'_V = mkkV "imeltyä" ;
lin imelta'a'_V = mkkV "imeltää" ;
lin imelyys_N = mkkN "imelyys" ;
lin imela'_A = mkkA "imelä" ;
lin imela'sti_Adv = mkkAdv "imelästi" ;
lin imelo'itta'a'_V = mkkV "imelöittää" ;
lin imeskella'_V = mkkV "imeskellä" ;
lin imetta'ja'_N = mkkN "imettäjä" ;
lin imetta'va'inen_N = mkkN "imettäväinen" ;
lin imetta'a'_V = mkkV "imettää" ;
lin imetys_N = mkkN "imetys" ;
lin imetysaika_N = mkkN "imetysaika" ;
lin imeva'inen_N = mkkN "imeväinen" ;
lin imeytta'a'_V = mkkV "imeyttää" ;
lin imeytys_N = mkkN "imeytys" ;
lin imeytya'_V = mkkV "imeytyä" ;
lin imea'_V = mkkV "imeä" ;
lin imikka'_N = mkkN "imikkä" ;
lin imitaatio_N = mkkN "imitaatio" ;
lin imitaattori_N = mkkN "imitaattori" ;
lin imitoida_V = mkkV "imitoida" ;
lin imitoija_N = mkkN "imitoija" ;
lin imitointi_N = mkkN "imitointi" ;
lin immateriaalinen_N = mkkN "immateriaalinen" ;
lin immunisaatio_N = mkkN "immunisaatio" ;
lin immunisoida_V = mkkV "immunisoida" ;
lin immunisointi_N = mkkN "immunisointi" ;
lin immunisoitua_V = mkkV "immunisoitua" ;
lin immuniteetti_N = mkkN "immuniteetti" ;
lin immunologia_N = mkkN "immunologia" ;
lin immunologinen_N = mkkN "immunologinen" ;
lin immuuni_N = mkkN "immuuni" ;
lin immuunistaa_V = mkkV "immuunistaa" ;
lin immuunistua_V = mkkV "immuunistua" ;
lin immuunius_N = mkkN "immuunius" ;
lin immyt_N = mkkN "immyt" ;
lin impata_V = mkkV "impata" ;
lin impedanssi_N = mkkN "impedanssi" ;
lin imperatiivi_N = mkkN "imperatiivi" ;
lin imperfekti_N = mkkN "imperfekti" ;
lin imperialismi_N = mkkN "imperialismi" ;
lin imperialisti_N = mkkN "imperialisti" ;
lin imperialistinen_N = mkkN "imperialistinen" ;
lin imperiumi_N = mkkN "imperiumi" ;
lin impi_N = mkkN "impi" ;
lin impivaaralainen_N = mkkN "impivaaralainen" ;
lin impivaaralaisuus_N = mkkN "impivaaralaisuus" ;
lin implantaatio_N = mkkN "implantaatio" ;
lin implantaatti_N = mkkN "implantaatti" ;
lin implantoida_V = mkkV "implantoida" ;
lin implantti_N = mkkN "implantti" ;
lin implikoida_V = mkkV "implikoida" ;
lin implisiittinen_A = mkkA "implisiittinen" ;
lin implisiittisesti_Adv = mkkAdv "implisiittisesti" ;
lin implisiittisyys_N = mkkN "implisiittisyys" ;
lin implisoida_V = mkkV "implisoida" ;
lin imponoida_V = mkkV "imponoida" ;
lin impotenssi_N = mkkN "impotenssi" ;
lin impotentti_N = mkkN "impotentti" ;
lin imppaus_N = mkkN "imppaus" ;
lin impregnoida_V = mkkV "impregnoida" ;
lin impregnointi_N = mkkN "impregnointi" ;
lin impressaari_N = mkkN "impressaari" ;
lin impressaario_N = mkkN "impressaario" ;
lin impressionismi_N = mkkN "impressionismi" ;
lin impressionisti_N = mkkN "impressionisti" ;
lin impressionistinen_N = mkkN "impressionistinen" ;
lin improbatur_N = mkkN "improbatur" ;
lin impromptu_N = mkkN "impromptu" ;
lin improvisaatio_N = mkkN "improvisaatio" ;
lin improvisatorinen_N = mkkN "improvisatorinen" ;
lin improvisoida_V = mkkV "improvisoida" ;
lin improvisointi_N = mkkN "improvisointi" ;
lin impulsiivinen_A = mkkA "impulsiivinen" ;
lin impulsiivisesti_Adv = mkkAdv "impulsiivisesti" ;
lin impulsiivisuus_N = mkkN "impulsiivisuus" ;
lin impulssi_N = mkkN "impulssi" ;
lin imu_N = mkkN "imu" ;
lin imuke_N = mkkN "imuke" ;
lin imuri_N = mkkN "imuri" ;
lin imuroida_V = mkkV "imuroida" ;
lin imurointi_N = mkkN "imurointi" ;
lin in_Adv = mkkAdv "in" ;
lin inahdus_N = mkkN "inahdus" ;
lin inahtaa_V = mkkV "inahtaa" ;
lin indefiniittinen_N = mkkN "indefiniittinen" ;
lin indeksi_N = mkkN "indeksi" ;
lin indeksoida_V = mkkV "indeksoida" ;
lin indifferenssi_N = mkkN "indifferenssi" ;
lin indifferentti_N = mkkN "indifferentti" ;
lin indigo_N = mkkN "indigo" ;
lin indiisi_N = mkkN "indiisi" ;
lin indikaatio_N = mkkN "indikaatio" ;
lin indikaattori_N = mkkN "indikaattori" ;
lin indikatiivi_N = mkkN "indikatiivi" ;
lin indikoida_V = mkkV "indikoida" ;
lin indisio_N = mkkN "indisio" ;
lin indisoida_V = mkkV "indisoida" ;
lin indium_N = mkkN "indium" ;
lin individi_N = mkkN "individi" ;
lin individuaalinen_N = mkkN "individuaalinen" ;
lin individuaalistaa_V = mkkV "individuaalistaa" ;
lin individualismi_N = mkkN "individualismi" ;
lin individualisoida_V = mkkV "individualisoida" ;
lin individualisti_N = mkkN "individualisti" ;
lin individualistinen_A = mkkA "individualistinen" ;
lin individualistisesti_Adv = mkkAdv "individualistisesti" ;
lin indoiranilainen_N = mkkN "indoiranilainen" ;
lin indoktrinaatio_N = mkkN "indoktrinaatio" ;
lin indoktrinoida_V = mkkV "indoktrinoida" ;
lin indoktrinointi_N = mkkN "indoktrinointi" ;
lin induktanssi_N = mkkN "induktanssi" ;
lin induktiivinen_N = mkkN "induktiivinen" ;
lin induktio_N = mkkN "induktio" ;
lin indusoida_V = mkkV "indusoida" ;
lin indusoitua_V = mkkV "indusoitua" ;
lin industrialismi_N = mkkN "industrialismi" ;
lin industrialistinen_N = mkkN "industrialistinen" ;
lin inertia_N = mkkN "inertia" ;
lin inertti_N = mkkN "inertti" ;
lin inessiivi_N = mkkN "inessiivi" ;
lin infantiili_N = mkkN "infantiili" ;
lin infantiilius_N = mkkN "infantiilius" ;
lin infantilismi_N = mkkN "infantilismi" ;
lin infarkti_N = mkkN "infarkti" ;
lin infektio_N = mkkN "infektio" ;
lin infektoida_V = mkkV "infektoida" ;
lin infektoitua_V = mkkV "infektoitua" ;
lin infernaalinen_N = mkkN "infernaalinen" ;
lin infertiili_N = mkkN "infertiili" ;
lin infinitiivi_N = mkkN "infinitiivi" ;
lin inflaatio_N = mkkN "inflaatio" ;
lin inflatorinen_N = mkkN "inflatorinen" ;
lin influenssa_N = mkkN "influenssa" ;
lin info_N = mkkN "info" ;
lin infokratia_N = mkkN "infokratia" ;
lin informaatikko_N = mkkN "informaatikko" ;
lin informaatio_N = mkkN "informaatio" ;
lin informalismi_N = mkkN "informalismi" ;
lin informalisti_N = mkkN "informalisti" ;
lin informalistinen_N = mkkN "informalistinen" ;
lin informatiikka_N = mkkN "informatiikka" ;
lin informatiivinen_N = mkkN "informatiivinen" ;
lin informatorinen_N = mkkN "informatorinen" ;
lin informoida_V = mkkV "informoida" ;
lin informointi_N = mkkN "informointi" ;
lin infuusio_N = mkkN "infuusio" ;
lin ingressi_N = mkkN "ingressi" ;
lin inhalaatio_N = mkkN "inhalaatio" ;
lin inhalaattori_N = mkkN "inhalaattori" ;
lin inhaloida_V = mkkV "inhaloida" ;
lin inhalointi_N = mkkN "inhalointi" ;
lin inhibiittori_N = mkkN "inhibiittori" ;
lin inhibitio_N = mkkN "inhibitio" ;
lin inhibitorinen_N = mkkN "inhibitorinen" ;
lin inhiboida_V = mkkV "inhiboida" ;
lin inhiboitua_V = mkkV "inhiboitua" ;
lin inhimillinen_A = mkkA "inhimillinen" ;
lin inhimillisesti_Adv = mkkAdv "inhimillisesti" ;
lin inhimillistya'_V = mkkV "inhimillistyä" ;
lin inhimillista'a'_V = mkkV "inhimillistää" ;
lin inhimillisyys_N = mkkN "inhimillisyys" ;
lin inho_N = mkkN "inho" ;
lin inhota_V = mkkV "inhota" ;
lin inhottaa_V = mkkV "inhottaa" ;
lin inhottava_A = mkkA "inhottava" ;
lin inhottavasti_Adv = mkkAdv "inhottavasti" ;
lin inhottavuus_N = mkkN "inhottavuus" ;
lin inhotus_N = mkkN "inhotus" ;
lin inina'_N = mkkN "ininä" ;
lin inista'_V = mkkV "inistä" ;
lin initiaatio_N = mkkN "initiaatio" ;
lin injektio_N = mkkN "injektio" ;
lin injektoida_V = mkkV "injektoida" ;
lin inka_N = mkkN "inka" ;
lin inkarnaatio_N = mkkN "inkarnaatio" ;
lin inkarnoitua_V = mkkV "inkarnoitua" ;
lin inkerikko_N = mkkN "inkerikko" ;
lin inkerila'inen_N = mkkN "inkeriläinen" ;
lin inkeroinen_N = mkkN "inkeroinen" ;
lin inkiva'a'ri_N = mkkN "inkivääri" ;
lin inkkari_N = mkkN "inkkari" ;
lin inkognito_Adv = mkkAdv "inkognito" ;
lin inkongruenssi_N = mkkN "inkongruenssi" ;
lin inkontinenssi_N = mkkN "inkontinenssi" ;
lin inkubaatioaika_N = mkkN "inkubaatioaika" ;
lin inkubaattori_N = mkkN "inkubaattori" ;
lin inkvisiittori_N = mkkN "inkvisiittori" ;
lin inkvisitio_N = mkkN "inkvisitio" ;
lin innoissaan_Adv = mkkAdv "innoissaan" ;
lin innoite_N = mkkN "innoite" ;
lin innoittaa_V = mkkV "innoittaa" ;
lin innoittaja_N = mkkN "innoittaja" ;
lin innoittua_V = mkkV "innoittua" ;
lin innoitus_N = mkkN "innoitus" ;
lin innokas_A = mkkA "innokas" ;
lin innokkaasti_Adv = mkkAdv "innokkaasti" ;
lin innokkuus_N = mkkN "innokkuus" ;
lin innostaa_V = mkkV "innostaa" ;
lin innostaja_N = mkkN "innostaja" ;
lin innostua_V = mkkV "innostua" ;
lin innostuksissaan_Adv = mkkAdv "innostuksissaan" ;
lin innostuneesti_Adv = mkkAdv "innostuneesti" ;
lin innostuneisuus_N = mkkN "innostuneisuus" ;
lin innostunut_A = mkkA "innostunut" ;
lin innostus_N = mkkN "innostus" ;
lin innostuttaa_V = mkkV "innostuttaa" ;
lin innota_V = mkkV "innota" ;
lin innoton_N = mkkN "innoton" ;
lin innottomasti_Adv = mkkAdv "innottomasti" ;
lin innottomuus_N = mkkN "innottomuus" ;
lin innovaatio_N = mkkN "innovaatio" ;
lin innovatiivinen_N = mkkN "innovatiivinen" ;
lin innovatiivisuus_N = mkkN "innovatiivisuus" ;
lin innovoida_V = mkkV "innovoida" ;
lin innovointi_N = mkkN "innovointi" ;
lin input_N = mkkN "input" ;
lin insatsi_N = mkkN "insatsi" ;
lin insertti_N = mkkN "insertti" ;
lin insesti_N = mkkN "insesti" ;
lin insidenssi_N = mkkN "insidenssi" ;
lin insino'o'ri_N = mkkN "insinööri" ;
lin inspehtori_N = mkkN "inspehtori" ;
lin inspiraatio_N = mkkN "inspiraatio" ;
lin inspiroida_V = mkkV "inspiroida" ;
lin inspiroitua_V = mkkV "inspiroitua" ;
lin inssi_N = mkkN "inssi" ;
lin installaatio_N = mkkN "installaatio" ;
lin installoida_V = mkkV "installoida" ;
lin installointi_N = mkkN "installointi" ;
lin instanssi_N = mkkN "instanssi" ;
lin institutionaalinen_N = mkkN "institutionaalinen" ;
lin institutionaalistua_V = mkkV "institutionaalistua" ;
lin institutionalisoitua_V = mkkV "institutionalisoitua" ;
lin instituutio_N = mkkN "instituutio" ;
lin instituutti_N = mkkN "instituutti" ;
lin instruktiivi_N = mkkN "instruktiivi" ;
lin instrumentaalinen_N = mkkN "instrumentaalinen" ;
lin instrumentaatio_N = mkkN "instrumentaatio" ;
lin instrumentalisti_N = mkkN "instrumentalisti" ;
lin instrumentoida_V = mkkV "instrumentoida" ;
lin instrumentointi_N = mkkN "instrumentointi" ;
lin instrumentti_N = mkkN "instrumentti" ;
lin insuffisienssi_N = mkkN "insuffisienssi" ;
lin insuliini_N = mkkN "insuliini" ;
lin integraali_N = mkkN "integraali" ;
lin integraatio_N = mkkN "integraatio" ;
lin integroida_V = mkkV "integroida" ;
lin integrointi_N = mkkN "integrointi" ;
lin integroitua_V = mkkV "integroitua" ;
lin intellektuaalinen_N = mkkN "intellektuaalinen" ;
lin intellektualismi_N = mkkN "intellektualismi" ;
lin intellektualisti_N = mkkN "intellektualisti" ;
lin intellektualistinen_N = mkkN "intellektualistinen" ;
lin intellektuelli_N = mkkN "intellektuelli" ;
lin intelligenssi_N = mkkN "intelligenssi" ;
lin intelligentsija_N = mkkN "intelligentsija" ;
lin intelligentti_N = mkkN "intelligentti" ;
lin intendentti_N = mkkN "intendentti" ;
lin intendentuuri_N = mkkN "intendentuuri" ;
lin intensiivinen_A = mkkA "intensiivinen" ;
lin intensiivisesti_Adv = mkkAdv "intensiivisesti" ;
lin intensiivisyys_N = mkkN "intensiivisyys" ;
lin intensiteetti_N = mkkN "intensiteetti" ;
lin intentio_N = mkkN "intentio" ;
lin interferenssi_N = mkkN "interferenssi" ;
lin interferoni_N = mkkN "interferoni" ;
lin interio'o'ri_N = mkkN "interiööri" ;
lin interjektio_N = mkkN "interjektio" ;
lin intermezzo_N = mkkN "intermezzo" ;
lin intermittoiva_N = mkkN "intermittoiva" ;
lin internaatti_N = mkkN "internaatti" ;
lin internationaali_N = mkkN "internationaali" ;
lin internationalismi_N = mkkN "internationalismi" ;
lin internoida_V = mkkV "internoida" ;
lin internointi_N = mkkN "internointi" ;
lin interrailaaja_N = mkkN "interrailaaja" ;
lin interrailata_V = mkkV "interrailata" ;
lin interreilaaja_N = mkkN "interreilaaja" ;
lin interreilata_V = mkkV "interreilata" ;
lin interrogatiivinen_N = mkkN "interrogatiivinen" ;
lin intertekstuaalinen_A = mkkA "intertekstuaalinen" ;
lin intertekstuaalisesti_Adv = mkkAdv "intertekstuaalisesti" ;
lin intertekstuaalisuus_N = mkkN "intertekstuaalisuus" ;
lin intervalli_N = mkkN "intervalli" ;
lin interventio_N = mkkN "interventio" ;
lin intiaani_N = mkkN "intiaani" ;
lin intialainen_N = mkkN "intialainen" ;
lin intianpuuvilla_N = mkkN "intianpuuvilla" ;
lin intiimi_A = mkkA "intiimi" ;
lin intiimisti_Adv = mkkAdv "intiimisti" ;
lin intiimiys_N = mkkN "intiimiys" ;
lin intimiteetti_N = mkkN "intimiteetti" ;
lin into_N = mkkN "into" ;
lin intohimoisesti_Adv = mkkAdv "intohimoisesti" ;
lin intohimoisuus_N = mkkN "intohimoisuus" ;
lin intohimoton_N = mkkN "intohimoton" ;
lin intohimottomasti_Adv = mkkAdv "intohimottomasti" ;
lin intohimottomuus_N = mkkN "intohimottomuus" ;
lin intoilija_N = mkkN "intoilija" ;
lin intoilla_V = mkkV "intoilla" ;
lin intoilu_N = mkkN "intoilu" ;
lin intoinen_N = mkkN "intoinen" ;
lin intomielisesti_Adv = mkkAdv "intomielisesti" ;
lin intonaatio_N = mkkN "intonaatio" ;
lin intos_N = mkkN "intos" ;
lin intoutua_V = mkkV "intoutua" ;
lin intransitiivinen_N = mkkN "intransitiivinen" ;
lin intresantti_N = mkkN "intresantti" ;
lin intressi_N = mkkN "intressi" ;
lin intrigi_N = mkkN "intrigi" ;
lin intrigoida_V = mkkV "intrigoida" ;
lin intrigointi_N = mkkN "intrigointi" ;
lin intro_N = mkkN "intro" ;
lin introduktio_N = mkkN "introduktio" ;
lin introspektio_N = mkkN "introspektio" ;
lin introvertti_N = mkkN "introvertti" ;
lin intti_N = mkkN "intti" ;
lin intta'a'_V = mkkV "inttää" ;
lin intuitiivinen_A = mkkA "intuitiivinen" ;
lin intuitiivisesti_Adv = mkkAdv "intuitiivisesti" ;
lin intuitiivisuus_N = mkkN "intuitiivisuus" ;
lin intuitio_N = mkkN "intuitio" ;
lin inuiitti_N = mkkN "inuiitti" ;
lin inuitti_N = mkkN "inuitti" ;
lin invaasio_N = mkkN "invaasio" ;
lin invalidi_N = mkkN "invalidi" ;
lin invalidisoida_V = mkkV "invalidisoida" ;
lin invalidisoitua_V = mkkV "invalidisoitua" ;
lin invaliditeetti_N = mkkN "invaliditeetti" ;
lin invalidius_N = mkkN "invalidius" ;
lin invalidoida_V = mkkV "invalidoida" ;
lin invalidoitua_V = mkkV "invalidoitua" ;
lin invarianssi_N = mkkN "invarianssi" ;
lin invariantti_N = mkkN "invariantti" ;
lin inventaari_N = mkkN "inventaari" ;
lin inventaario_N = mkkN "inventaario" ;
lin inventoida_V = mkkV "inventoida" ;
lin inventointi_N = mkkN "inventointi" ;
lin investoida_V = mkkV "investoida" ;
lin investointi_N = mkkN "investointi" ;
lin ioni_N = mkkN "ioni" ;
lin ionisaatio_N = mkkN "ionisaatio" ;
lin ionisaattori_N = mkkN "ionisaattori" ;
lin ionisoida_V = mkkV "ionisoida" ;
lin ionisoitua_V = mkkV "ionisoitua" ;
lin ionosfa'a'ri_N = mkkN "ionosfääri" ;
lin ipana_N = mkkN "ipana" ;
lin iridium_N = mkkN "iridium" ;
lin irkata_V = mkkV "irkata" ;
lin irlantilainen_N = mkkN "irlantilainen" ;
lin irokeesi_N = mkkN "irokeesi" ;
lin ironia_N = mkkN "ironia" ;
lin ironikko_N = mkkN "ironikko" ;
lin ironinen_A = mkkA "ironinen" ;
lin ironisesti_Adv = mkkAdv "ironisesti" ;
lin ironisoida_V = mkkV "ironisoida" ;
lin ironisuus_N = mkkN "ironisuus" ;
lin irrallaan_Adv = mkkAdv "irrallaan" ;
lin irralleen_Adv = mkkAdv "irralleen" ;
lin irrallinen_A = mkkA "irrallinen" ;
lin irrallisesti_Adv = mkkAdv "irrallisesti" ;
lin irrallisuus_N = mkkN "irrallisuus" ;
lin irrationaali_N = mkkN "irrationaali" ;
lin irrationaalinen_A = mkkA "irrationaalinen" ;
lin irrationaalisesti_Adv = mkkAdv "irrationaalisesti" ;
lin irrationaalisuus_N = mkkN "irrationaalisuus" ;
lin irreaalinen_N = mkkN "irreaalinen" ;
lin irreaalisuus_N = mkkN "irreaalisuus" ;
lin irrelevantti_N = mkkN "irrelevantti" ;
lin irrota_V = mkkV "irrota" ;
lin irrotella_V = mkkV "irrotella" ;
lin irrottaa_V = mkkV "irrottaa" ;
lin irrottautua_V = mkkV "irrottautua" ;
lin irrottua_V = mkkV "irrottua" ;
lin irrotus_N = mkkN "irrotus" ;
lin irstaasti_Adv = mkkAdv "irstaasti" ;
lin irstailija_N = mkkN "irstailija" ;
lin irstailla_V = mkkV "irstailla" ;
lin irstailu_N = mkkN "irstailu" ;
lin irstainen_N = mkkN "irstainen" ;
lin irstas_A = mkkA "irstas" ;
lin irstaus_N = mkkN "irstaus" ;
lin irtaantua_V = mkkV "irtaantua" ;
lin irtaimisto_N = mkkN "irtaimisto" ;
lin irtain_N = mkkN "irtain" ;
lin irtauma_N = mkkN "irtauma" ;
lin irtautua_V = mkkV "irtautua" ;
lin irtautuma_N = mkkN "irtautuma" ;
lin irti_Adv = mkkAdv "irti" ;
lin irtisanomisaika_N = mkkN "irtisanomisaika" ;
lin irtisanomissuoja_N = mkkN "irtisanomissuoja" ;
lin irtolainen_N = mkkN "irtolainen" ;
lin irtonainen_A = mkkA "irtonainen" ;
lin irtonaisesti_Adv = mkkAdv "irtonaisesti" ;
lin irtonaisuus_N = mkkN "irtonaisuus" ;
lin irtovuori_N = mkkN "irtovuori" ;
lin irvailla_V = mkkV "irvailla" ;
lin irvailu_N = mkkN "irvailu" ;
lin irveen_Adv = mkkAdv "irveen" ;
lin irvessa'_Adv = mkkAdv "irvessä" ;
lin irviin_Adv = mkkAdv "irviin" ;
lin irvissa'_Adv = mkkAdv "irvissä" ;
lin irvistelija'_N = mkkN "irvistelijä" ;
lin irvistella'_V = mkkV "irvistellä" ;
lin irvistely_N = mkkN "irvistely" ;
lin irvistys_N = mkkN "irvistys" ;
lin irvistytta'a'_V = mkkV "irvistyttää" ;
lin irvista'a'_V = mkkV "irvistää" ;
lin irvia'_V = mkkV "irviä" ;
lin irvokas_A = mkkA "irvokas" ;
lin irvokkaasti_Adv = mkkAdv "irvokkaasti" ;
lin irvokkuus_N = mkkN "irvokkuus" ;
lin isi_N = mkkN "isi" ;
lin iskelma'_N = mkkN "iskelmä" ;
lin iskema'_N = mkkN "iskemä" ;
lin iskenta'_N = mkkN "iskentä" ;
lin isketta'a'_V = mkkV "iskettää" ;
lin iskevyys_N = mkkN "iskevyys" ;
lin iskeva'_A = mkkA "iskevä" ;
lin iskeva'sti_Adv = mkkAdv "iskevästi" ;
lin iskeytya'_V = mkkV "iskeytyä" ;
lin iskea'_V = mkkV "iskeä" ;
lin iskias_N = mkkN "iskias" ;
lin iskija'_N = mkkN "iskijä" ;
lin iskostaa_V = mkkV "iskostaa" ;
lin iskostua_V = mkkV "iskostua" ;
lin isku_N = mkkN "isku" ;
lin iskuhaava_N = mkkN "iskuhaava" ;
lin iskuinen_N = mkkN "iskuinen" ;
lin iskullinen_N = mkkN "iskullinen" ;
lin iskuri_N = mkkN "iskuri" ;
lin iskuttaa_V = mkkV "iskuttaa" ;
lin iska'_N = mkkN "iskä" ;
lin islam_N = mkkN "islam" ;
lin islamilainen_N = mkkN "islamilainen" ;
lin islamilaisuus_N = mkkN "islamilaisuus" ;
lin islamisti_N = mkkN "islamisti" ;
lin islamistinen_N = mkkN "islamistinen" ;
lin islanti_N = mkkN "islanti" ;
lin ismi_N = mkkN "ismi" ;
lin iso_1_A = mkkA "iso" ;
lin iso_2_A = mkkA "iso" ;
lin isoinen_N = mkkN "isoinen" ;
lin isolaatio_N = mkkN "isolaatio" ;
lin isoloida_V = mkkV "isoloida" ;
lin isolointi_N = mkkN "isolointi" ;
lin isoloitua_V = mkkV "isoloitua" ;
lin isomorfia_N = mkkN "isomorfia" ;
lin isontaa_V = mkkV "isontaa" ;
lin isontua_V = mkkV "isontua" ;
lin isosti_Adv = mkkAdv "isosti" ;
lin isota_1_V = mkkV "isota" ;
lin isota_2_V = mkkV "isota" ;
lin isotella_V = mkkV "isotella" ;
lin isotooppi_N = mkkN "isotooppi" ;
lin isottelu_N = mkkN "isottelu" ;
lin isous_N = mkkN "isous" ;
lin israelilainen_N = mkkN "israelilainen" ;
lin issikka_1_N = mkkN "issikka" ;
lin issikka_2_N = mkkN "issikka" ;
lin istahtaa_V = mkkV "istahtaa" ;
lin istua_V = mkkV "istua" ;
lin istualla_Adv = mkkAdv "istualla" ;
lin istuallaan_Adv = mkkAdv "istuallaan" ;
lin istualle_Adv = mkkAdv "istualle" ;
lin istualleen_Adv = mkkAdv "istualleen" ;
lin istualta_Adv = mkkAdv "istualta" ;
lin istualtaan_Adv = mkkAdv "istualtaan" ;
lin istuin_N = mkkN "istuin" ;
lin istukallinen_N = mkkN "istukallinen" ;
lin istukas_N = mkkN "istukas" ;
lin istukka_N = mkkN "istukka" ;
lin istuksia_V = mkkV "istuksia" ;
lin istuma_Adv = mkkAdv "istuma" ;
lin istumalla_Adv = mkkAdv "istumalla" ;
lin istumalta_Adv = mkkAdv "istumalta" ;
lin istunta_N = mkkN "istunta" ;
lin istunto_N = mkkN "istunto" ;
lin istuskella_V = mkkV "istuskella" ;
lin istuskelu_N = mkkN "istuskelu" ;
lin istute_N = mkkN "istute" ;
lin istuttaa_V = mkkV "istuttaa" ;
lin istutus_N = mkkN "istutus" ;
lin istutusaika_N = mkkN "istutusaika" ;
lin istuutua_V = mkkV "istuutua" ;
lin istuvilla_Adv = mkkAdv "istuvilla" ;
lin istuvillaan_Adv = mkkAdv "istuvillaan" ;
lin istuville_Adv = mkkAdv "istuville" ;
lin istuvilleen_Adv = mkkAdv "istuvilleen" ;
lin istuvilta_Adv = mkkAdv "istuvilta" ;
lin istuviltaan_Adv = mkkAdv "istuviltaan" ;
lin istuvuus_N = mkkN "istuvuus" ;
lin isukki_N = mkkN "isukki" ;
lin isyys_N = mkkN "isyys" ;
lin isa'_N = mkkN "isä" ;
lin isa'llinen_A = mkkA "isällinen" ;
lin isa'llisesti_Adv = mkkAdv "isällisesti" ;
lin isa'meida'n_Adv = mkkAdv "isämeidän" ;
lin isa'meita'_Adv = mkkAdv "isämeitä" ;
lin isa'nmaallisesti_Adv = mkkAdv "isänmaallisesti" ;
lin isa'nnisto'_N = mkkN "isännistö" ;
lin isa'nnyys_N = mkkN "isännyys" ;
lin isa'nna'to'n_N = mkkN "isännätön" ;
lin isa'nno'ida'_V = mkkV "isännöidä" ;
lin isa'nno'itsija'_N = mkkN "isännöitsijä" ;
lin isa'nta'_N = mkkN "isäntä" ;
lin isa'to'n_N = mkkN "isätön" ;
lin IT_Adv = mkkAdv "IT" ;
lin italia_N = mkkN "italia" ;
lin italiaano_N = mkkN "italiaano" ;
lin italiankumina_N = mkkN "italiankumina" ;
lin itara_N = mkkN "itara" ;
lin itarasti_Adv = mkkAdv "itarasti" ;
lin itaruus_N = mkkN "itaruus" ;
lin itikka_N = mkkN "itikka" ;
lin itio'_N = mkkN "itiö" ;
lin itkeskella'_V = mkkV "itkeskellä" ;
lin itkeskely_N = mkkN "itkeskely" ;
lin itkettynyt_N = mkkN "itkettynyt" ;
lin itketta'a'_V = mkkV "itkettää" ;
lin itkea'_V = mkkV "itkeä" ;
lin itkija'_N = mkkN "itkijä" ;
lin itku_N = mkkN "itku" ;
lin itkuinen_N = mkkN "itkuinen" ;
lin itkusilmin_Adv = mkkAdv "itkusilmin" ;
lin itsari_N = mkkN "itsari" ;
lin itse_N = mkkN "itse" ;
lin itseja'ljenta'va'_N = mkkN "itsejäljentävä" ;
lin itsekantava_N = mkkN "itsekantava" ;
lin itsekiillottuva_N = mkkN "itsekiillottuva" ;
lin itsekiinnittyva'_N = mkkN "itsekiinnittyvä" ;
lin itsekkyys_N = mkkN "itsekkyys" ;
lin itsekka'a'sti_Adv = mkkAdv "itsekkäästi" ;
lin itsekseen_Adv = mkkAdv "itsekseen" ;
lin itse_kukin_Adv = mkkAdv "itsC" ;
lin itseka's_A = mkkA "itsekäs" ;
lin itseliimautuva_N = mkkN "itseliimautuva" ;
lin itsellinen_N = mkkN "itsellinen" ;
lin itseneuvova_N = mkkN "itseneuvova" ;
lin itsensa'paljastaminen_N = mkkN "itsensäpaljastaminen" ;
lin itsena'inen_A = mkkA "itsenäinen" ;
lin itsena'isesti_Adv = mkkAdv "itsenäisesti" ;
lin itsena'istytta'a'_V = mkkV "itsenäistyttää" ;
lin itsena'istya'_V = mkkV "itsenäistyä" ;
lin itsena'ista'a'_V = mkkV "itsenäistää" ;
lin itsena'isyys_N = mkkN "itsenäisyys" ;
lin itseohjaava_N = mkkN "itseohjaava" ;
lin itseohjautuva_N = mkkN "itseohjautuva" ;
lin itsepintaisesti_Adv = mkkAdv "itsepintaisesti" ;
lin itsepa'isesti_Adv = mkkAdv "itsepäisesti" ;
lin itsepa'isyys_N = mkkN "itsepäisyys" ;
lin itserakkaasti_Adv = mkkAdv "itserakkaasti" ;
lin itseriittoinen_A = mkkA "itseriittoinen" ;
lin itseriittoisesti_Adv = mkkAdv "itseriittoisesti" ;
lin itsesilia'va'_N = mkkN "itsesiliävä" ;
lin itsessa'a'n_Adv = mkkAdv "itsessään" ;
lin itsesta'a'n_Adv = mkkAdv "itsestään" ;
lin itsesyttyminen_N = mkkN "itsesyttyminen" ;
lin itsesytynta'_N = mkkN "itsesytyntä" ;
lin itsesa'a'tyva'_N = mkkN "itsesäätyvä" ;
lin itsetuhoinen_N = mkkN "itsetuhoinen" ;
lin itsetypistys_N = mkkN "itsetypistys" ;
lin itsevalaiseva_N = mkkN "itsevalaiseva" ;
lin itsevaltaisesti_Adv = mkkAdv "itsevaltaisesti" ;
lin itsevaltiaasti_Adv = mkkAdv "itsevaltiaasti" ;
lin itsevoiteleva_N = mkkN "itsevoiteleva" ;
lin itu_N = mkkN "itu" ;
lin ita'_N = mkkN "itä" ;
lin ita'inen_N = mkkN "itäinen" ;
lin ita'misaika_N = mkkN "itämisaika" ;
lin ita'valtalainen_N = mkkN "itävaltalainen" ;
lin ita'vyys_N = mkkN "itävyys" ;
lin ita'a'_V = mkkV "itää" ;
lin iva_N = mkkN "iva" ;
lin ivailla_V = mkkV "ivailla" ;
lin ivailu_N = mkkN "ivailu" ;
lin ivallinen_A = mkkA "ivallinen" ;
lin ivallisesti_Adv = mkkAdv "ivallisesti" ;
lin ivata_V = mkkV "ivata" ;
lin ia'inen_A = mkkA "iäinen" ;
lin ia'isesti_Adv = mkkAdv "iäisesti" ;
lin ia'isyys_N = mkkN "iäisyys" ;
lin ia'kkyys_N = mkkN "iäkkyys" ;
lin ia'ksi_Adv = mkkAdv "iäksi" ;
lin ia'ka's_N = mkkN "iäkäs" ;
lin ia'n_kaiken_Adv = mkkAdv "iäC" ;
lin ia'ti_Adv = mkkAdv "iäti" ;
lin ia'ta'_V = mkkV "iätä" ;
lin ia'to'n_N = mkkN "iätön" ;
lin ja_Adv = mkkAdv "ja" ;
lin jaa_Adv = mkkAdv "jaa" ;
lin jaaha_Adv = mkkAdv "jaaha" ;
lin jaala_N = mkkN "jaala" ;
lin jaanata_V = mkkV "jaanata" ;
lin jaardi_N = mkkN "jaardi" ;
lin jaaritella_V = mkkV "jaaritella" ;
lin jaarittelu_N = mkkN "jaarittelu" ;
lin jaaritus_N = mkkN "jaaritus" ;
lin jaarli_N = mkkN "jaarli" ;
lin jacquard_N = mkkN "jacquard" ;
lin jade_N = mkkN "jade" ;
lin jae_N = mkkN "jae" ;
lin jaella_V = mkkV "jaella" ;
lin jaettava_N = mkkN "jaettava" ;
lin jaguaari_N = mkkN "jaguaari" ;
lin jaha_Adv = mkkAdv "jaha" ;
lin jahdata_V = mkkV "jahdata" ;
lin jahka_Adv = mkkAdv "jahka" ;
lin jahkailla_V = mkkV "jahkailla" ;
lin jahkailu_N = mkkN "jahkailu" ;
lin jahkata_V = mkkV "jahkata" ;
lin jahnata_V = mkkV "jahnata" ;
lin jahti_1_N = mkkN "jahti" ;
lin jahti_2_N = mkkN "jahti" ;
lin jakaa_V = mkkV "jakaa" ;
lin jakaantua_V = mkkV "jakaantua" ;
lin jakaja_N = mkkN "jakaja" ;
lin jakamaton_N = mkkN "jakamaton" ;
lin jakamo_N = mkkN "jakamo" ;
lin jakaranda_N = mkkN "jakaranda" ;
lin jakardi_N = mkkN "jakardi" ;
lin jakauma_N = mkkN "jakauma" ;
lin jakaus_N = mkkN "jakaus" ;
lin jakautua_V = mkkV "jakautua" ;
lin jakautuma_N = mkkN "jakautuma" ;
lin jakelija_N = mkkN "jakelija" ;
lin jakelu_N = mkkN "jakelu" ;
lin jakkara_N = mkkN "jakkara" ;
lin jakki_1_N = mkkN "jakki" ;
lin jakki_2_N = mkkN "jakki" ;
lin jakku_N = mkkN "jakku" ;
lin jako_N = mkkN "jako" ;
lin jakobiini_N = mkkN "jakobiini" ;
lin jakoinen_N = mkkN "jakoinen" ;
lin jaksaa_V = mkkV "jaksaa" ;
lin jaksella_V = mkkV "jaksella" ;
lin jakso_N = mkkN "jakso" ;
lin jaksoinen_N = mkkN "jaksoinen" ;
lin jaksoittain_Adv = mkkAdv "jaksoittain" ;
lin jaksoittainen_A = mkkA "jaksoittainen" ;
lin jaksoittaisesti_Adv = mkkAdv "jaksoittaisesti" ;
lin jaksoittaisuus_N = mkkN "jaksoittaisuus" ;
lin jaksollinen_N = mkkN "jaksollinen" ;
lin jaksollisuus_N = mkkN "jaksollisuus" ;
lin jaksonaika_N = mkkN "jaksonaika" ;
lin jaksotella_V = mkkV "jaksotella" ;
lin jaksottaa_V = mkkV "jaksottaa" ;
lin jaksottua_V = mkkV "jaksottua" ;
lin jaksotus_N = mkkN "jaksotus" ;
lin jakuutti_N = mkkN "jakuutti" ;
lin jalake_N = mkkN "jalake" ;
lin jalallinen_N = mkkN "jalallinen" ;
lin jalan_Adv = mkkAdv "jalan" ;
lin jalapeno_N = mkkN "jalapeno" ;
lin jalas_N = mkkN "jalas" ;
lin jalava_N = mkkN "jalava" ;
lin jalka_N = mkkN "jalka" ;
lin jalkainen_N = mkkN "jalkainen" ;
lin jalkaisin_Adv = mkkAdv "jalkaisin" ;
lin jalkapatikka_N = mkkN "jalkapatikka" ;
lin jalkauttaa_V = mkkV "jalkauttaa" ;
lin jalkautua_V = mkkV "jalkautua" ;
lin jalkava_N = mkkN "jalkava" ;
lin jalkavuus_N = mkkN "jalkavuus" ;
lin jalkeilla_Adv = mkkAdv "jalkeilla" ;
lin jalkeille_Adv = mkkAdv "jalkeille" ;
lin jalkine_N = mkkN "jalkine" ;
lin jalkio_N = mkkN "jalkio" ;
lin jallittaa_V = mkkV "jallittaa" ;
lin jallitus_N = mkkN "jallitus" ;
lin jalo_N = mkkN "jalo" ;
lin jaloitella_V = mkkV "jaloitella" ;
lin jaloittelu_N = mkkN "jaloittelu" ;
lin jalokivihioja_N = mkkN "jalokivihioja" ;
lin jalomielisesti_Adv = mkkAdv "jalomielisesti" ;
lin jalonnus_N = mkkN "jalonnus" ;
lin jalontaa_V = mkkV "jalontaa" ;
lin jalostaa_V = mkkV "jalostaa" ;
lin jalostamo_N = mkkN "jalostamo" ;
lin jaloste_N = mkkN "jaloste" ;
lin jalostua_V = mkkV "jalostua" ;
lin jalostus_N = mkkN "jalostus" ;
lin jalus_N = mkkN "jalus" ;
lin jalusta_N = mkkN "jalusta" ;
lin jalustaa_V = mkkV "jalustaa" ;
lin jalustin_N = mkkN "jalustin" ;
lin jamaan_Adv = mkkAdv "jamaan" ;
lin jamassa_Adv = mkkAdv "jamassa" ;
lin jambi_N = mkkN "jambi" ;
lin jamboree_N = mkkN "jamboree" ;
lin jamit_N = mkkN "jamit" ;
lin jammailla_V = mkkV "jammailla" ;
lin jammata_V = mkkV "jammata" ;
lin jam_session_N = mkkN "jaC" ;
lin jamssi_N = mkkN "jamssi" ;
lin jana_N = mkkN "jana" ;
lin janitsaari_N = mkkN "janitsaari" ;
lin jankata_V = mkkV "jankata" ;
lin jankko_N = mkkN "jankko" ;
lin jankkuri_N = mkkN "jankkuri" ;
lin jankuttaa_V = mkkV "jankuttaa" ;
lin jankutus_N = mkkN "jankutus" ;
lin jannu_N = mkkN "jannu" ;
lin jano_N = mkkN "jano" ;
lin janoinen_N = mkkN "janoinen" ;
lin janota_V = mkkV "janota" ;
lin janottaa_V = mkkV "janottaa" ;
lin jaoke_N = mkkN "jaoke" ;
lin jaokkeeton_N = mkkN "jaokkeeton" ;
lin jaokkeinen_N = mkkN "jaokkeinen" ;
lin jaollinen_N = mkkN "jaollinen" ;
lin jaollisuus_N = mkkN "jaollisuus" ;
lin jaos_N = mkkN "jaos" ;
lin jaosto_N = mkkN "jaosto" ;
lin jaotella_V = mkkV "jaotella" ;
lin jaoton_N = mkkN "jaoton" ;
lin jaottaa_V = mkkV "jaottaa" ;
lin jaottelu_N = mkkN "jaottelu" ;
lin jaotus_N = mkkN "jaotus" ;
lin japani_N = mkkN "japani" ;
lin japaninlakka_N = mkkN "japaninlakka" ;
lin japanitar_N = mkkN "japanitar" ;
lin japsi_N = mkkN "japsi" ;
lin jarru_N = mkkN "jarru" ;
lin jarruttaa_V = mkkV "jarruttaa" ;
lin jarrutus_N = mkkN "jarrutus" ;
lin jarruuntua_V = mkkV "jarruuntua" ;
lin jasmiini_N = mkkN "jasmiini" ;
lin jasmike_N = mkkN "jasmike" ;
lin jaspis_N = mkkN "jaspis" ;
lin jassoo_Adv = mkkAdv "jassoo" ;
lin jata_N = mkkN "jata" ;
lin jatkaa_V = mkkV "jatkaa" ;
lin jatkaja_N = mkkN "jatkaja" ;
lin jatkavuus_N = mkkN "jatkavuus" ;
lin jatke_N = mkkN "jatke" ;
lin jatko_N = mkkN "jatko" ;
lin jatkoaika_N = mkkN "jatkoaika" ;
lin jatkokohta_N = mkkN "jatkokohta" ;
lin jatkos_N = mkkN "jatkos" ;
lin jatkua_V = mkkV "jatkua" ;
lin jatkumo_N = mkkN "jatkumo" ;
lin jatkuva_A = mkkA "jatkuva" ;
lin jatkuvajuoninen_N = mkkN "jatkuvajuoninen" ;
lin jatkuvasti_Adv = mkkAdv "jatkuvasti" ;
lin jatkuvuus_N = mkkN "jatkuvuus" ;
lin jatsari_N = mkkN "jatsari" ;
lin jatsi_N = mkkN "jatsi" ;
lin jauhaa_V = mkkV "jauhaa" ;
lin jauhaantua_V = mkkV "jauhaantua" ;
lin jauhattaa_V = mkkV "jauhattaa" ;
lin jauhatus_N = mkkN "jauhatus" ;
lin jauhautua_V = mkkV "jauhautua" ;
lin jauhe_N = mkkN "jauhe" ;
lin jauhennin_N = mkkN "jauhennin" ;
lin jauhentaa_V = mkkV "jauhentaa" ;
lin jauhentua_V = mkkV "jauhentua" ;
lin jauhiainen_N = mkkN "jauhiainen" ;
lin jauhin_N = mkkN "jauhin" ;
lin jauho_N = mkkN "jauho" ;
lin jauhoinen_N = mkkN "jauhoinen" ;
lin jauhottaa_V = mkkV "jauhottaa" ;
lin jazz_N = mkkN "jazz" ;
lin jeeppi_N = mkkN "jeeppi" ;
lin jeesata_V = mkkV "jeesata" ;
lin jeesus_N = mkkN "jeesus" ;
lin jeesustella_V = mkkV "jeesustella" ;
lin jeesustelu_N = mkkN "jeesustelu" ;
lin jeeveli_N = mkkN "jeeveli" ;
lin jehu_N = mkkN "jehu" ;
lin jekku_N = mkkN "jekku" ;
lin jekkuilla_V = mkkV "jekkuilla" ;
lin jellona_N = mkkN "jellona" ;
lin jelpata_V = mkkV "jelpata" ;
lin jelppia'_V = mkkV "jelppiä" ;
lin jemma_N = mkkN "jemma" ;
lin jemmata_V = mkkV "jemmata" ;
lin jengi_N = mkkN "jengi" ;
lin jengila'inen_N = mkkN "jengiläinen" ;
lin jengiytya'_V = mkkV "jengiytyä" ;
lin jeni_N = mkkN "jeni" ;
lin jenka_N = mkkN "jenka" ;
lin jenkka_N = mkkN "jenkka" ;
lin jenkki_N = mkkN "jenkki" ;
lin jenkkila'_N = mkkN "jenkkilä" ;
lin jenkkila'inen_N = mkkN "jenkkiläinen" ;
lin jep_Adv = mkkAdv "jep" ;
lin jepari_N = mkkN "jepari" ;
lin jeppe_N = mkkN "jeppe" ;
lin jeremiadi_N = mkkN "jeremiadi" ;
lin jermu_N = mkkN "jermu" ;
lin jersey_N = mkkN "jersey" ;
lin jessus_Adv = mkkAdv "jessus" ;
lin jestas_Adv = mkkAdv "jestas" ;
lin jesuiitta_N = mkkN "jesuiitta" ;
lin jet_lag_N = mkkN "jeC" ;
lin jet_set_N = mkkN "jeC" ;
lin jetsetti_N = mkkN "jetsetti" ;
lin jetsulleen_Adv = mkkAdv "jetsulleen" ;
lin jetti_N = mkkN "jetti" ;
lin jiddi_N = mkkN "jiddi" ;
lin jiddi__N = mkkN "jiddiš" ;
lin jiirata_V = mkkV "jiirata" ;
lin jiiri_N = mkkN "jiiri" ;
lin jippo_N = mkkN "jippo" ;
lin jippoilla_V = mkkV "jippoilla" ;
lin jippoilu_N = mkkN "jippoilu" ;
lin jiujitsu_N = mkkN "jiujitsu" ;
lin jive_N = mkkN "jive" ;
lin jo_Adv = mkkAdv "jo" ;
lin jobbari_N = mkkN "jobbari" ;
lin jobinposti_N = mkkN "jobinposti" ;
lin jockey_N = mkkN "jockey" ;
lin jodi_N = mkkN "jodi" ;
lin jodidi_N = mkkN "jodidi" ;
lin jodioida_V = mkkV "jodioida" ;
lin jodittaa_V = mkkV "jodittaa" ;
lin jodlata_V = mkkV "jodlata" ;
lin jodlaus_N = mkkN "jodlaus" ;
lin jogurtti_N = mkkN "jogurtti" ;
lin johanniitta_N = mkkN "johanniitta" ;
lin johdannainen_N = mkkN "johdannainen" ;
lin johdanto_N = mkkN "johdanto" ;
lin johdate_N = mkkN "johdate" ;
lin johdatella_V = mkkV "johdatella" ;
lin johdatin_N = mkkN "johdatin" ;
lin johdattaa_V = mkkV "johdattaa" ;
lin johdatus_N = mkkN "johdatus" ;
lin johde_N = mkkN "johde" ;
lin johdin_N = mkkN "johdin" ;
lin johdonmukaistaa_V = mkkV "johdonmukaistaa" ;
lin johdos_N = mkkN "johdos" ;
lin johdosta_Adv = mkkAdv "johdosta" ;
lin johdottaa_V = mkkV "johdottaa" ;
lin johdotus_N = mkkN "johdotus" ;
lin johonkin_Adv = mkkAdv "johonkin" ;
lin johtaa_V = mkkV "johtaa" ;
lin johtaja_N = mkkN "johtaja" ;
lin johtajatar_N = mkkN "johtajatar" ;
lin johtajisto_N = mkkN "johtajisto" ;
lin johtajuus_N = mkkN "johtajuus" ;
lin johtava_N = mkkN "johtava" ;
lin johtavuus_N = mkkN "johtavuus" ;
lin johteinen_N = mkkN "johteinen" ;
lin johto_N = mkkN "johto" ;
lin johtoinen_N = mkkN "johtoinen" ;
lin johtua_V = mkkV "johtua" ;
lin joiata_V = mkkV "joiata" ;
lin joikata_V = mkkV "joikata" ;
lin joikaus_N = mkkN "joikaus" ;
lin joiku_N = mkkN "joiku" ;
lin joikua_V = mkkV "joikua" ;
lin joisto_N = mkkN "joisto" ;
lin joiunta_N = mkkN "joiunta" ;
lin jojo_N = mkkN "jojo" ;
lin jojolaihduttaminen_N = mkkN "jojolaihduttaminen" ;
lin joka_1_Adv = mkkAdv "joka" ;
lin jokainen_N = mkkN "jokainen" ;
lin jokellella_V = mkkV "jokellella" ;
lin jokellus_N = mkkN "jokellus" ;
lin jokeltaa_V = mkkV "jokeltaa" ;
lin jokeri_N = mkkN "jokeri" ;
lin joki_N = mkkN "joki" ;
lin joko_Adv = mkkAdv "joko" ;
lin jokseenkin_Adv = mkkAdv "jokseenkin" ;
lin jokunen_N = mkkN "jokunen" ;
lin jolkutella_V = mkkV "jolkutella" ;
lin jolkuttaa_V = mkkV "jolkuttaa" ;
lin jolla_N = mkkN "jolla" ;
lin jollainen_N = mkkN "jollainen" ;
lin jollei_Adv = mkkAdv "jollei" ;
lin jolloin_Adv = mkkAdv "jolloin" ;
lin jolloinkin_Adv = mkkAdv "jolloinkin" ;
lin jollottaa_V = mkkV "jollottaa" ;
lin jolma_N = mkkN "jolma" ;
lin jolppi_N = mkkN "jolppi" ;
lin joltinen_N = mkkN "joltinen" ;
lin joltinenkin_N = mkkN "joltinenkin" ;
lin joltisestikin_Adv = mkkAdv "joltisestikin" ;
lin jommoinen_N = mkkN "jommoinen" ;
lin jommoinenkin_N = mkkN "jommoinenkin" ;
lin jomottaa_V = mkkV "jomottaa" ;
lin jonglo'o'ri_N = mkkN "jonglööri" ;
lin jonkalainen_N = mkkN "jonkalainen" ;
lin jonkinlainen_N = mkkN "jonkinlainen" ;
lin jonkinmoinen_N = mkkN "jonkinmoinen" ;
lin jonkunlainen_N = mkkN "jonkunlainen" ;
lin jonkunmoinen_N = mkkN "jonkunmoinen" ;
lin jonne_Adv = mkkAdv "jonne" ;
lin jonnekin_Adv = mkkAdv "jonnekin" ;
lin jono_N = mkkN "jono" ;
lin jonottaa_V = mkkV "jonottaa" ;
lin jonotus_N = mkkN "jonotus" ;
lin jonouttaa_V = mkkV "jonouttaa" ;
lin joo_Adv = mkkAdv "joo" ;
lin jooga_N = mkkN "jooga" ;
lin joogata_V = mkkV "joogata" ;
lin joogi_N = mkkN "joogi" ;
lin jooli_N = mkkN "jooli" ;
lin joonialainen_N = mkkN "joonialainen" ;
lin jopa_Adv = mkkAdv "jopa" ;
lin jopi_N = mkkN "jopi" ;
lin jorata_V = mkkV "jorata" ;
lin joriini_N = mkkN "joriini" ;
lin jorina_N = mkkN "jorina" ;
lin jorista_V = mkkV "jorista" ;
lin joro_N = mkkN "joro" ;
lin jorottaa_V = mkkV "jorottaa" ;
lin jorotus_N = mkkN "jorotus" ;
lin jorpakko_N = mkkN "jorpakko" ;
--? lin jortsut_NK = {s = d01 "jortsut" ;
lin jos_Adv = mkkAdv "jos" ;
lin joskaan_Adv = mkkAdv "joskaan" ;
lin joskin_Adv = mkkAdv "joskin" ;
lin joskus_Adv = mkkAdv "joskus" ;
lin jospa_Adv = mkkAdv "jospa" ;
lin jossain_Adv = mkkAdv "jossain" ;
lin jossakin_Adv = mkkAdv "jossakin" ;
lin jossitella_V = mkkV "jossitella" ;
lin jossittelu_N = mkkN "jossittelu" ;
lin jostain_Adv = mkkAdv "jostain" ;
lin jostakin_Adv = mkkAdv "jostakin" ;
lin jota_Adv = mkkAdv "jota" ;
lin jotakuinkin_Adv = mkkAdv "jotakuinkin" ;
lin joten_Adv = mkkAdv "joten" ;
lin jotenkin_Adv = mkkAdv "jotenkin" ;
lin jotensakin_Adv = mkkAdv "jotensakin" ;
lin joteskin_Adv = mkkAdv "joteskin" ;
lin jotos_N = mkkN "jotos" ;
lin jotta_1_Adv = mkkAdv "jotta" ;
lin jotta__2_Adv = mkkAdv "jotta-" ;
lin jouduttaa_V = mkkV "jouduttaa" ;
lin jouhea_A = mkkA "jouhea" ;
lin jouheasti_Adv = mkkAdv "jouheasti" ;
lin jouheus_N = mkkN "jouheus" ;
lin jouhi_N = mkkN "jouhi" ;
lin jouhikko_N = mkkN "jouhikko" ;
lin joukkio_N = mkkN "joukkio" ;
lin joukko_N = mkkN "joukko" ;
lin joukkoeroaminen_N = mkkN "joukkoeroaminen" ;
lin joukkoerottaminen_N = mkkN "joukkoerottaminen" ;
lin joukkoesiintyminen_N = mkkN "joukkoesiintyminen" ;
lin joukkoirtisanominen_N = mkkN "joukkoirtisanominen" ;
lin joukkoirtisanoutuminen_N = mkkN "joukkoirtisanoutuminen" ;
lin joukkotuhonta_N = mkkN "joukkotuhonta" ;
lin joukkue_N = mkkN "joukkue" ;
lin joukkueinen_N = mkkN "joukkueinen" ;
lin joukoittain_Adv = mkkAdv "joukoittain" ;
lin joule_N = mkkN "joule" ;
lin joulu_N = mkkN "joulu" ;
lin jouluaika_N = mkkN "jouluaika" ;
lin jouluinen_N = mkkN "jouluinen" ;
lin joulunaika_N = mkkN "joulunaika" ;
lin journalismi_N = mkkN "journalismi" ;
lin journalisti_N = mkkN "journalisti" ;
lin journalistiikka_N = mkkN "journalistiikka" ;
lin journalistinen_N = mkkN "journalistinen" ;
lin jousi_N = mkkN "jousi" ;
lin jousinen_N = mkkN "jousinen" ;
lin jousisto_N = mkkN "jousisto" ;
lin jousittaa_V = mkkV "jousittaa" ;
lin jousitus_N = mkkN "jousitus" ;
lin joustaa_V = mkkV "joustaa" ;
lin joustamaton_N = mkkN "joustamaton" ;
lin joustava_A = mkkA "joustava" ;
lin joustavasti_Adv = mkkAdv "joustavasti" ;
lin joustavoida_V = mkkV "joustavoida" ;
lin joustavoittaa_V = mkkV "joustavoittaa" ;
lin joustavuus_N = mkkN "joustavuus" ;
lin joustin_N = mkkN "joustin" ;
lin jousto_N = mkkN "jousto" ;
lin joustoaika_N = mkkN "joustoaika" ;
lin joutaa_V = mkkV "joutaa" ;
lin joutava_N = mkkN "joutava" ;
lin jouten_Adv = mkkAdv "jouten" ;
lin joutessa_Adv = mkkAdv "joutessa" ;
lin joutessaan_Adv = mkkAdv "joutessaan" ;
lin joutilaisuus_N = mkkN "joutilaisuus" ;
lin joutilas_N = mkkN "joutilas" ;
lin joutoaika_N = mkkN "joutoaika" ;
lin joutsen_N = mkkN "joutsen" ;
lin joutua_V = mkkV "joutua" ;
lin joutuin_Adv = mkkAdv "joutuin" ;
lin joutuisa_A = mkkA "joutuisa" ;
lin joutuisasti_Adv = mkkAdv "joutuisasti" ;
lin joviaali_N = mkkN "joviaali" ;
lin joystick_N = mkkN "joystick" ;
lin judata_V = mkkV "judata" ;
lin judo_N = mkkN "judo" ;
lin judogi_N = mkkN "judogi" ;
lin judoka_N = mkkN "judoka" ;
lin jugend_N = mkkN "jugend" ;
lin jugoslaavi_N = mkkN "jugoslaavi" ;
lin jugoslavialainen_N = mkkN "jugoslavialainen" ;
lin jugurtti_N = mkkN "jugurtti" ;
lin juhannus_N = mkkN "juhannus" ;
lin juhla_N = mkkN "juhla" ;
lin juhlaliputettu_N = mkkN "juhlaliputettu" ;
lin juhlallinen_A = mkkA "juhlallinen" ;
lin juhlallisesti_Adv = mkkAdv "juhlallisesti" ;
lin juhlallisuus_N = mkkN "juhlallisuus" ;
lin juhlava_A = mkkA "juhlava" ;
lin juhlavalaistu_N = mkkN "juhlavalaistu" ;
lin juhlavasti_Adv = mkkAdv "juhlavasti" ;
lin juhlavuus_N = mkkN "juhlavuus" ;
lin juhlia_V = mkkV "juhlia" ;
lin juhlija_N = mkkN "juhlija" ;
lin juhlinta_N = mkkN "juhlinta" ;
lin juhlistaa_V = mkkV "juhlistaa" ;
lin juhta_N = mkkN "juhta" ;
lin juippi_N = mkkN "juippi" ;
lin juju_N = mkkN "juju" ;
lin jujuttaa_V = mkkV "jujuttaa" ;
lin jukeboksi_N = mkkN "jukeboksi" ;
lin jukebox_N = mkkN "jukebox" ;
lin jukka_N = mkkN "jukka" ;
lin jukolaut_Adv = mkkAdv "jukolaut" ;
lin jukolauta_Adv = mkkAdv "jukolauta" ;
lin jukoliste_Adv = mkkAdv "jukoliste" ;
lin jukra_Adv = mkkAdv "jukra" ;
lin juksata_V = mkkV "juksata" ;
lin juku_Adv = mkkAdv "juku" ;
lin jukurtti_N = mkkN "jukurtti" ;
lin juliaaninen_N = mkkN "juliaaninen" ;
lin julistaa_V = mkkV "julistaa" ;
lin julistaja_N = mkkN "julistaja" ;
lin julistautua_V = mkkV "julistautua" ;
lin juliste_N = mkkN "juliste" ;
lin julistus_N = mkkN "julistus" ;
lin juljeta_V = mkkV "juljeta" ;
lin julkaisematon_N = mkkN "julkaisematon" ;
lin julkaisija_N = mkkN "julkaisija" ;
lin julkaista_V = mkkV "julkaista" ;
lin julkaisu_N = mkkN "julkaisu" ;
lin julkea_A = mkkA "julkea" ;
lin julkeasti_Adv = mkkAdv "julkeasti" ;
lin julkeus_N = mkkN "julkeus" ;
lin julki_Adv = mkkAdv "julki" ;
lin julkimo_N = mkkN "julkimo" ;
lin julkinen_A = mkkA "julkinen" ;
lin julkipanna_V = mkkV "julkipanna" ;
lin julkisesti_Adv = mkkAdv "julkisesti" ;
lin julkistaa_V = mkkV "julkistaa" ;
lin julkisuus_N = mkkN "julkisuus" ;
lin julkkis_N = mkkN "julkkis" ;
lin julkku_N = mkkN "julkku" ;
lin julli_N = mkkN "julli" ;
lin jullikka_N = mkkN "jullikka" ;
lin julma_A = mkkA "julma" ;
lin julmasti_Adv = mkkAdv "julmasti" ;
lin julmettu_N = mkkN "julmettu" ;
lin julmetusti_Adv = mkkAdv "julmetusti" ;
lin julmistella_V = mkkV "julmistella" ;
lin julmistua_V = mkkV "julmistua" ;
lin julmuri_N = mkkN "julmuri" ;
lin julmuus_N = mkkN "julmuus" ;
lin jumala_N = mkkN "jumala" ;
lin jumalaapelka'a'va'_N = mkkN "jumalaapelkäävä" ;
lin jumalainen_A = mkkA "jumalainen" ;
lin jumalaisesti_Adv = mkkAdv "jumalaisesti" ;
lin jumalallinen_N = mkkN "jumalallinen" ;
lin jumalankielta'minen_N = mkkN "jumalankieltäminen" ;
lin jumalanluoma_N = mkkN "jumalanluoma" ;
lin jumalatar_N = mkkN "jumalatar" ;
lin jumalaton_N = mkkN "jumalaton" ;
lin jumalattomasti_Adv = mkkAdv "jumalattomasti" ;
lin jumalaut_Adv = mkkAdv "jumalaut" ;
lin jumalauta_Adv = mkkAdv "jumalauta" ;
lin jumalinen_A = mkkA "jumalinen" ;
lin jumalisesti_Adv = mkkAdv "jumalisesti" ;
lin jumaliste_Adv = mkkAdv "jumaliste" ;
lin jumalisuus_N = mkkN "jumalisuus" ;
lin jumaloida_V = mkkV "jumaloida" ;
lin jumalointi_N = mkkN "jumalointi" ;
lin jumaluus_N = mkkN "jumaluus" ;
lin jumbo_N = mkkN "jumbo" ;
lin jumbokoko_N = mkkN "jumbokoko" ;
lin jumi_N = mkkN "jumi" ;
lin jumiin_Adv = mkkAdv "jumiin" ;
lin jumiintua_V = mkkV "jumiintua" ;
lin jumissa_Adv = mkkAdv "jumissa" ;
lin jumittaa_V = mkkV "jumittaa" ;
lin jumittua_V = mkkV "jumittua" ;
lin jumiuttaa_V = mkkV "jumiuttaa" ;
lin jumiutua_V = mkkV "jumiutua" ;
lin jumpata_V = mkkV "jumpata" ;
lin jumppa_N = mkkN "jumppa" ;
lin jumpperi_N = mkkN "jumpperi" ;
lin jumputtaa_V = mkkV "jumputtaa" ;
lin jumputus_N = mkkN "jumputus" ;
lin juna_N = mkkN "juna" ;
lin junailija_N = mkkN "junailija" ;
lin junailla_V = mkkV "junailla" ;
lin jungmanni_N = mkkN "jungmanni" ;
lin junior_N = mkkN "junior" ;
lin juniori_N = mkkN "juniori" ;
lin junk_food_N = mkkN "junC" ;
lin junkkari_N = mkkN "junkkari" ;
lin junnata_V = mkkV "junnata" ;
lin junnu_N = mkkN "junnu" ;
lin juntata_1_V = mkkV "juntata" ;
lin juntata_2_V = mkkV "juntata" ;
lin juntta_1_N = mkkN "juntta" ;
lin juntta_2_N = mkkN "juntta" ;
lin junttaus_N = mkkN "junttaus" ;
lin juntti_N = mkkN "juntti" ;
lin juntturassa_Adv = mkkAdv "juntturassa" ;
lin juoda_V = mkkV "juoda" ;
lin juohea_A = mkkA "juohea" ;
lin juoheasti_Adv = mkkAdv "juoheasti" ;
lin juoheus_N = mkkN "juoheus" ;
lin juoheva_A = mkkA "juoheva" ;
lin juohevasti_Adv = mkkAdv "juohevasti" ;
lin juohevuus_N = mkkN "juohevuus" ;
lin juohtua_V = mkkV "juohtua" ;
lin juoksennella_V = mkkV "juoksennella" ;
lin juoksete_N = mkkN "juoksete" ;
lin juoksettaa_V = mkkV "juoksettaa" ;
lin juoksettua_V = mkkV "juoksettua" ;
lin juokseva_A = mkkA "juokseva" ;
lin juoksevasti_Adv = mkkAdv "juoksevasti" ;
lin juoksevuus_N = mkkN "juoksevuus" ;
lin juoksija_N = mkkN "juoksija" ;
lin juoksu_N = mkkN "juoksu" ;
lin juoksuaika_N = mkkN "juoksuaika" ;
lin juoksuinen_N = mkkN "juoksuinen" ;
lin juoksujalkaa_Adv = mkkAdv "juoksujalkaa" ;
lin juoksute_N = mkkN "juoksute" ;
lin juoksutin_N = mkkN "juoksutin" ;
lin juoksuttaa_V = mkkV "juoksuttaa" ;
lin juoksutus_N = mkkN "juoksutus" ;
lin juolahtaa_V = mkkV "juolahtaa" ;
lin juolua_N = mkkN "juolua" ;
lin juolukka_N = mkkN "juolukka" ;
lin juoma_N = mkkN "juoma" ;
lin juomari_N = mkkN "juomari" ;
lin juominen_N = mkkN "juominen" ;
lin juomingit_N = mkkN "juomingit" ;
lin juomu_N = mkkN "juomu" ;
lin juomuinen_N = mkkN "juomuinen" ;
lin juonellinen_A = mkkA "juonellinen" ;
lin juonellisesti_Adv = mkkAdv "juonellisesti" ;
lin juoni_N = mkkN "juoni" ;
lin juonia_V = mkkV "juonia" ;
lin juonikas_A = mkkA "juonikas" ;
lin juonikkaasti_Adv = mkkAdv "juonikkaasti" ;
lin juonikkuus_N = mkkN "juonikkuus" ;
lin juonitella_V = mkkV "juonitella" ;
lin juonittelija_N = mkkN "juonittelija" ;
lin juonittelu_N = mkkN "juonittelu" ;
lin juonne_N = mkkN "juonne" ;
lin juontaa_V = mkkV "juontaa" ;
lin juontaja_N = mkkN "juontaja" ;
lin juonteikas_N = mkkN "juonteikas" ;
lin juonti_N = mkkN "juonti" ;
lin juonto_N = mkkN "juonto" ;
lin juontua_V = mkkV "juontua" ;
lin juopa_N = mkkN "juopa" ;
lin juoponnapissa_Adv = mkkAdv "juoponnapissa" ;
lin juoponnappiin_Adv = mkkAdv "juoponnappiin" ;
lin juopotella_V = mkkV "juopotella" ;
lin juopottelu_N = mkkN "juopottelu" ;
lin juoppo_N = mkkN "juoppo" ;
lin juoppolalli_N = mkkN "juoppolalli" ;
lin juoppous_N = mkkN "juoppous" ;
lin juopua_V = mkkV "juopua" ;
lin juopumus_N = mkkN "juopumus" ;
lin juopunut_N = mkkN "juopunut" ;
lin juoru_N = mkkN "juoru" ;
lin juoruilla_V = mkkV "juoruilla" ;
lin juoruilu_N = mkkN "juoruilu" ;
lin juorukki_N = mkkN "juorukki" ;
lin juoruta_V = mkkV "juoruta" ;
lin juosta_V = mkkV "juosta" ;
lin juoste_N = mkkN "juoste" ;
lin juotava_N = mkkN "juotava" ;
lin juote_N = mkkN "juote" ;
lin juotikas_N = mkkN "juotikas" ;
lin juotin_N = mkkN "juotin" ;
lin juotos_N = mkkN "juotos" ;
lin juottaa_V = mkkV "juottaa" ;
lin juotto_N = mkkN "juotto" ;
lin juottola_N = mkkN "juottola" ;
lin juova_N = mkkN "juova" ;
lin juovainen_N = mkkN "juovainen" ;
lin juovikas_N = mkkN "juovikas" ;
lin juovittaa_V = mkkV "juovittaa" ;
lin juovitus_N = mkkN "juovitus" ;
lin juovukkeeseen_Adv = mkkAdv "juovukkeeseen" ;
lin juovukkeessa_Adv = mkkAdv "juovukkeessa" ;
lin juovuksiin_Adv = mkkAdv "juovuksiin" ;
lin juovuksissa_Adv = mkkAdv "juovuksissa" ;
lin juovuspa'issa'_Adv = mkkAdv "juovuspäissä" ;
lin juovuttaa_V = mkkV "juovuttaa" ;
lin jupakka_N = mkkN "jupakka" ;
lin jupina_N = mkkN "jupina" ;
lin jupista_V = mkkV "jupista" ;
lin juppi_N = mkkN "juppi" ;
lin juppiutua_V = mkkV "juppiutua" ;
lin juridiikka_N = mkkN "juridiikka" ;
lin juridinen_A = mkkA "juridinen" ;
lin juridisesti_Adv = mkkAdv "juridisesti" ;
lin juristeria_N = mkkN "juristeria" ;
lin juristi_N = mkkN "juristi" ;
lin jurnuttaa_V = mkkV "jurnuttaa" ;
lin jurnutus_N = mkkN "jurnutus" ;
lin juro_A = mkkA "juro" ;
lin juroa_V = mkkV "juroa" ;
lin jurosti_Adv = mkkAdv "jurosti" ;
lin jurottaa_V = mkkV "jurottaa" ;
lin jurous_N = mkkN "jurous" ;
lin juroutua_V = mkkV "juroutua" ;
lin jurppia_V = mkkV "jurppia" ;
lin jurrata_V = mkkV "jurrata" ;
lin jurri_N = mkkN "jurri" ;
lin jurrikka_N = mkkN "jurrikka" ;
lin jury_N = mkkN "jury" ;
lin Jussi_N = mkkN "Jussi" ;
lin jussi_N = mkkN "jussi" ;
lin just_Adv = mkkAdv "just" ;
lin justeerata_V = mkkV "justeerata" ;
lin justeeraus_N = mkkN "justeeraus" ;
lin justeeri_N = mkkN "justeeri" ;
lin justiin_Adv = mkkAdv "justiin" ;
lin justiinsa_Adv = mkkAdv "justiinsa" ;
lin jutaa_Adv = mkkAdv "jutaa" ;
lin jutella_V = mkkV "jutella" ;
lin jutku_N = mkkN "jutku" ;
lin jutsku_N = mkkN "jutsku" ;
lin juttelu_N = mkkN "juttelu" ;
lin juttu_N = mkkN "juttu" ;
lin juttusilla_Adv = mkkAdv "juttusilla" ;
lin juttusille_Adv = mkkAdv "juttusille" ;
lin jutustaa_V = mkkV "jutustaa" ;
lin jutustella_V = mkkV "jutustella" ;
lin jutustelu_N = mkkN "jutustelu" ;
lin jututtaa_V = mkkV "jututtaa" ;
lin juu_Adv = mkkAdv "juu" ;
lin juudas_N = mkkN "juudas" ;
lin juurehtia_V = mkkV "juurehtia" ;
lin juurekas_N = mkkN "juurekas" ;
lin juures_N = mkkN "juures" ;
lin juureton_N = mkkN "juureton" ;
lin juurettomuus_N = mkkN "juurettomuus" ;
lin juureva_N = mkkN "juureva" ;
lin juurevuus_N = mkkN "juurevuus" ;
lin juuri_1_N = mkkN "juuri" ;
lin juuri_2_Adv = mkkAdv "juuri" ;
lin juuria_V = mkkV "juuria" ;
lin juurinen_N = mkkN "juurinen" ;
lin juuristo_N = mkkN "juuristo" ;
lin juurittaa_V = mkkV "juurittaa" ;
lin juurrettava_N = mkkN "juurrettava" ;
lin juurruttaa_V = mkkV "juurruttaa" ;
lin juurrutus_N = mkkN "juurrutus" ;
lin juurtaa_V = mkkV "juurtaa" ;
lin juurta_jaksaen_Adv = mkkAdv "juurtC" ;
lin juurta_jaksain_Adv = mkkAdv "juurtC" ;
lin juurtua_V = mkkV "juurtua" ;
lin juusto_N = mkkN "juusto" ;
lin juustola_N = mkkN "juustola" ;
lin juustottua_V = mkkV "juustottua" ;
lin juustouma_N = mkkN "juustouma" ;
lin juustouttaa_V = mkkV "juustouttaa" ;
lin juustoutua_V = mkkV "juustoutua" ;
lin juustoutuma_N = mkkN "juustoutuma" ;
lin juutalainen_N = mkkN "juutalainen" ;
lin juutalaisuus_N = mkkN "juutalaisuus" ;
lin juutas_N = mkkN "juutas" ;
lin juutti_1_N = mkkN "juutti" ;
lin juutti_2_N = mkkN "juutti" ;
lin juuttua_V = mkkV "juuttua" ;
lin jyda'ta'_V = mkkV "jydätä" ;
lin jyhkeys_N = mkkN "jyhkeys" ;
lin jyhkea'_A = mkkA "jyhkeä" ;
lin jyhkea'sti_Adv = mkkAdv "jyhkeästi" ;
lin jykerta'a'_V = mkkV "jykertää" ;
lin jykevyys_N = mkkN "jykevyys" ;
lin jykeva'_A = mkkA "jykevä" ;
lin jykeva'sti_Adv = mkkAdv "jykevästi" ;
lin jylheta'_V = mkkV "jylhetä" ;
lin jylhistya'_V = mkkV "jylhistyä" ;
lin jylhyys_N = mkkN "jylhyys" ;
lin jylha'_A = mkkA "jylhä" ;
lin jylha'sti_Adv = mkkAdv "jylhästi" ;
lin jylina'_N = mkkN "jylinä" ;
lin jylista'_V = mkkV "jylistä" ;
lin jylla'ta'_V = mkkV "jyllätä" ;
lin jyly_N = mkkN "jyly" ;
lin jymina'_N = mkkN "jyminä" ;
lin jymista'_V = mkkV "jymistä" ;
lin jymista'a'_V = mkkV "jymistää" ;
lin jymy_N = mkkN "jymy" ;
lin jyma'hdella'_V = mkkV "jymähdellä" ;
lin jyma'hdys_N = mkkN "jymähdys" ;
lin jyma'hta'a'_V = mkkV "jymähtää" ;
lin jyma'ys_N = mkkN "jymäys" ;
lin jyma'ytella'_V = mkkV "jymäytellä" ;
lin jyma'ytta'a'_V = mkkV "jymäyttää" ;
lin jynssa'ta'_V = mkkV "jynssätä" ;
lin jynssa'ys_N = mkkN "jynssäys" ;
lin jyrina'_N = mkkN "jyrinä" ;
lin jyristella'_V = mkkV "jyristellä" ;
lin jyrista'_V = mkkV "jyristä" ;
lin jyrista'a'_V = mkkV "jyristää" ;
lin jyrisytta'a'_V = mkkV "jyrisyttää" ;
lin jyrkentya'_V = mkkV "jyrkentyä" ;
lin jyrkenta'a'_V = mkkV "jyrkentää" ;
lin jyrketa'_V = mkkV "jyrketä" ;
lin jyrkistya'_V = mkkV "jyrkistyä" ;
lin jyrkista'a'_V = mkkV "jyrkistää" ;
lin jyrkkyys_N = mkkN "jyrkkyys" ;
lin jyrkka'_N = mkkN "jyrkkä" ;
lin jyrka'nne_N = mkkN "jyrkänne" ;
lin jyrka'sti_Adv = mkkAdv "jyrkästi" ;
lin jyrra'ta'_V = mkkV "jyrrätä" ;
lin jyrsija'_N = mkkN "jyrsijä" ;
lin jyrsin_N = mkkN "jyrsin" ;
lin jyrsinta'_N = mkkN "jyrsintä" ;
lin jyrsia'_V = mkkV "jyrsiä" ;
lin jyry_N = mkkN "jyry" ;
lin jyryta'_V = mkkV "jyrytä" ;
lin jyryytta'a'_V = mkkV "jyryyttää" ;
lin jyra'_N = mkkN "jyrä" ;
lin jyra'hdella'_V = mkkV "jyrähdellä" ;
lin jyra'hdys_N = mkkN "jyrähdys" ;
lin jyra'htely_N = mkkN "jyrähtely" ;
lin jyra'hta'a'_V = mkkV "jyrähtää" ;
lin jyra'ta'_V = mkkV "jyrätä" ;
lin jyra'ys_1_N = mkkN "jyräys" ;
lin jyra'ys_2_N = mkkN "jyräys" ;
lin jyra'ytta'a'_1_V = mkkV "jyräyttää" ;
lin jyra'ytta'a'_2_V = mkkV "jyräyttää" ;
lin jyske_N = mkkN "jyske" ;
lin jyskina'_N = mkkN "jyskinä" ;
lin jyskia'_V = mkkV "jyskiä" ;
lin jyskytella'_V = mkkV "jyskytellä" ;
lin jyskytta'a'_V = mkkV "jyskyttää" ;
lin jyskytys_N = mkkN "jyskytys" ;
lin jyskya'_V = mkkV "jyskyä" ;
lin jyska'hta'a'_V = mkkV "jyskähtää" ;
lin jyska'a'_V = mkkV "jyskää" ;
lin jysa'hdella'_V = mkkV "jysähdellä" ;
lin jysa'hdys_N = mkkN "jysähdys" ;
lin jysa'hta'a'_V = mkkV "jysähtää" ;
lin jysa'ys_N = mkkN "jysäys" ;
lin jysa'ytta'a'_V = mkkV "jysäyttää" ;
lin jytina'_N = mkkN "jytinä" ;
lin jytista'_V = mkkV "jytistä" ;
lin jytista'a'_V = mkkV "jytistää" ;
lin jytke_N = mkkN "jytke" ;
lin jytkytta'a'_V = mkkV "jytkyttää" ;
lin jytkytys_N = mkkN "jytkytys" ;
lin jytka'hta'a'_V = mkkV "jytkähtää" ;
lin jyty_N = mkkN "jyty" ;
lin jytyytta'a'_V = mkkV "jytyyttää" ;
lin jyta'_N = mkkN "jytä" ;
lin jyta'a'_Adv = mkkAdv "jytää" ;
lin jyvitta'a'_V = mkkV "jyvittää" ;
lin jyvitys_N = mkkN "jyvitys" ;
lin jyva'_N = mkkN "jyvä" ;
lin jyva'inen_N = mkkN "jyväinen" ;
lin jyva'jemmari_N = mkkN "jyväjemmari" ;
lin jyva'nen_N = mkkN "jyvänen" ;
lin jyysta'a'_V = mkkV "jyystää" ;
lin ja'hmettyma'_N = mkkN "jähmettymä" ;
lin ja'hmettya'_V = mkkV "jähmettyä" ;
lin ja'hmetta'a'_V = mkkV "jähmettää" ;
lin ja'hmeta'_V = mkkV "jähmetä" ;
lin ja'hmeys_N = mkkN "jähmeys" ;
lin ja'hmea'_A = mkkA "jähmeä" ;
lin ja'hmea'sti_Adv = mkkAdv "jähmeästi" ;
lin ja'inen_N = mkkN "jäinen" ;
lin ja'itse_Adv = mkkAdv "jäitse" ;
lin ja'kki_N = mkkN "jäkki" ;
lin ja'kka'ra'_N = mkkN "jäkkärä" ;
lin ja'ka'likko'_N = mkkN "jäkälikkö" ;
lin ja'ka'listo'_N = mkkN "jäkälistö" ;
lin ja'ka'la'_N = mkkN "jäkälä" ;
lin ja'ka'la'inen_N = mkkN "jäkäläinen" ;
lin ja'ka'lo'itya'_V = mkkV "jäkälöityä" ;
lin ja'ka'tta'a'_V = mkkV "jäkättää" ;
lin ja'ka'tys_N = mkkN "jäkätys" ;
lin ja'ljekka'in_Adv = mkkAdv "jäljekkäin" ;
lin ja'ljelle_Adv = mkkAdv "jäljelle" ;
lin ja'ljella'_Adv = mkkAdv "jäljellä" ;
lin ja'ljemma'_Adv = mkkAdv "jäljemmä" ;
lin ja'ljemma'ksi_Adv = mkkAdv "jäljemmäksi" ;
lin ja'ljemma's_Adv = mkkAdv "jäljemmäs" ;
lin ja'ljempa'na'_Adv = mkkAdv "jäljempänä" ;
lin ja'ljempa'a'_Adv = mkkAdv "jäljempää" ;
lin ja'ljenne_N = mkkN "jäljenne" ;
lin ja'ljennys_N = mkkN "jäljennys" ;
lin ja'ljenno's_N = mkkN "jäljennös" ;
lin ja'ljentya'_V = mkkV "jäljentyä" ;
lin ja'ljenta'mo'_N = mkkN "jäljentämö" ;
lin ja'ljenta'a'_V = mkkV "jäljentää" ;
lin ja'ljessa'_Adv = mkkAdv "jäljessä" ;
lin ja'ljesta'_Adv = mkkAdv "jäljestä" ;
lin ja'ljesta'a'_V = mkkV "jäljestää" ;
lin ja'ljetysten_Adv = mkkAdv "jäljetysten" ;
lin ja'ljeto'n_N = mkkN "jäljetön" ;
lin ja'ljille_Adv = mkkAdv "jäljille" ;
lin ja'ljilla'_Adv = mkkAdv "jäljillä" ;
lin ja'ljilta'_Adv = mkkAdv "jäljiltä" ;
lin ja'ljitella'_V = mkkV "jäljitellä" ;
lin ja'ljitelma'_N = mkkN "jäljitelmä" ;
lin ja'ljittelema'to'n_N = mkkN "jäljittelemätön" ;
lin ja'ljittely_N = mkkN "jäljittely" ;
lin ja'ljitta'a'_V = mkkV "jäljittää" ;
lin ja'ljitys_N = mkkN "jäljitys" ;
lin ja'lkeen_Adv = mkkAdv "jälkeen" ;
lin ja'lkeenja'a'neisyys_N = mkkN "jälkeenjääneisyys" ;
lin ja'lkeenja'a'nyt_N = mkkN "jälkeenjäänyt" ;
lin ja'lkeinen_N = mkkN "jälkeinen" ;
lin ja'lkela'inen_N = mkkN "jälkeläinen" ;
lin ja'lki_N = mkkN "jälki" ;
lin ja'lkija'tto'inen_N = mkkN "jälkijättöinen" ;
lin ja'lkija'tto'isyys_N = mkkN "jälkijättöisyys" ;
lin ja'lkika'teen_Adv = mkkAdv "jälkikäteen" ;
lin ja'lkimma'inen_N = mkkN "jälkimmäinen" ;
lin ja'lkka'ri_N = mkkN "jälkkäri" ;
lin ja'lleen_Adv = mkkAdv "jälleen" ;
lin ja'lleenna'keminen_N = mkkN "jälleennäkeminen" ;
lin ja'lleensyntyminen_N = mkkN "jälleensyntyminen" ;
lin ja'lsi_N = mkkN "jälsi" ;
lin ja'meryys_N = mkkN "jämeryys" ;
lin ja'mera'_A = mkkA "jämerä" ;
lin ja'mera'sti_Adv = mkkAdv "jämerästi" ;
lin ja'mpti_A = mkkA "jämpti" ;
lin ja'mptisti_Adv = mkkAdv "jämptisti" ;
lin ja'mtti_A = mkkA "jämtti" ;
lin ja'mttisti_Adv = mkkAdv "jämttisti" ;
lin ja'ma'_N = mkkN "jämä" ;
lin ja'ma'hta'a'_V = mkkV "jämähtää" ;
lin ja'ma'kkyys_N = mkkN "jämäkkyys" ;
lin ja'ma'kka'_N = mkkN "jämäkkä" ;
lin ja'ma'ka'sti_Adv = mkkAdv "jämäkästi" ;
lin ja'ma'ko'itya'_V = mkkV "jämäköityä" ;
lin ja'nis_N = mkkN "jänis" ;
lin ja'nishousu_N = mkkN "jänishousu" ;
lin ja'nista'a'_V = mkkV "jänistää" ;
lin ja'nka'_N = mkkN "jänkä" ;
lin ja'nka'sirria'inen_N = mkkN "jänkäsirriäinen" ;
lin ja'nne_N = mkkN "jänne" ;
lin ja'nnite_N = mkkN "jännite" ;
lin ja'nnitteeto'n_N = mkkN "jännitteetön" ;
lin ja'nnitteinen_N = mkkN "jännitteinen" ;
lin ja'nnitteisyys_N = mkkN "jännitteisyys" ;
lin ja'nnittyneisyys_N = mkkN "jännittyneisyys" ;
lin ja'nnittya'_V = mkkV "jännittyä" ;
lin ja'nnitta'ja'_N = mkkN "jännittäjä" ;
lin ja'nnitta'vyys_N = mkkN "jännittävyys" ;
lin ja'nnitta'va'_A = mkkA "jännittävä" ;
lin ja'nnitta'va'sti_Adv = mkkAdv "jännittävästi" ;
lin ja'nnitta'a'_V = mkkV "jännittää" ;
lin ja'nnitys_N = mkkN "jännitys" ;
lin ja'nna'_A = mkkA "jännä" ;
lin ja'nna'ri_N = mkkN "jännäri" ;
lin ja'nna'sti_Adv = mkkAdv "jännästi" ;
lin ja'nna'ta'_V = mkkV "jännätä" ;
lin ja'nska'_A = mkkA "jänskä" ;
lin ja'nska'sti_Adv = mkkAdv "jänskästi" ;
lin ja'nteika's_N = mkkN "jänteikäs" ;
lin ja'nteinen_N = mkkN "jänteinen" ;
lin ja'nteisyys_N = mkkN "jänteisyys" ;
lin ja'ntere_N = mkkN "jäntere" ;
lin ja'ntevyys_N = mkkN "jäntevyys" ;
lin ja'nteva'_A = mkkA "jäntevä" ;
lin ja'nteva'sti_Adv = mkkAdv "jäntevästi" ;
lin ja'ntevo'ida'_V = mkkV "jäntevöidä" ;
lin ja'ntevo'itta'a'_V = mkkV "jäntevöittää" ;
lin ja'ntevo'itya'_V = mkkV "jäntevöityä" ;
lin ja'nteys_N = mkkN "jänteys" ;
lin ja'nttera'_N = mkkN "jäntterä" ;
lin ja'no'_N = mkkN "jänö" ;
lin ja'no'nen_N = mkkN "jänönen" ;
lin ja'reys_N = mkkN "järeys" ;
lin ja'reytya'_V = mkkV "järeytyä" ;
lin ja'rea'_A = mkkA "järeä" ;
lin ja'rea'sti_Adv = mkkAdv "järeästi" ;
lin ja'rin_Adv = mkkAdv "järin" ;
lin ja'rina'_N = mkkN "järinä" ;
lin ja'ristys_N = mkkN "järistys" ;
lin ja'rista'_V = mkkV "järistä" ;
lin ja'risytta'a'_V = mkkV "järisyttää" ;
lin ja'rjellinen_A = mkkA "järjellinen" ;
lin ja'rjellisesti_Adv = mkkAdv "järjellisesti" ;
lin ja'rjellisyys_N = mkkN "järjellisyys" ;
lin ja'rjesteilla'_Adv = mkkAdv "järjesteillä" ;
lin ja'rjestella'_V = mkkV "järjestellä" ;
lin ja'rjestelma'_N = mkkN "järjestelmä" ;
lin ja'rjestelma'llinen_A = mkkA "järjestelmällinen" ;
lin ja'rjestelma'llisesti_Adv = mkkAdv "järjestelmällisesti" ;
lin ja'rjestelma'llista'a'_V = mkkV "järjestelmällistää" ;
lin ja'rjestelma'llisyys_N = mkkN "järjestelmällisyys" ;
lin ja'rjestely_N = mkkN "järjestely" ;
lin ja'rjestyma'to'n_N = mkkN "järjestymätön" ;
lin ja'rjestys_N = mkkN "järjestys" ;
lin ja'rjestya'_V = mkkV "järjestyä" ;
lin ja'rjesta'ja'_N = mkkN "järjestäjä" ;
lin ja'rjesta'ytya'_V = mkkV "järjestäytyä" ;
lin ja'rjesta'a'_V = mkkV "järjestää" ;
lin ja'rjesta'a'n_Adv = mkkAdv "järjestään" ;
lin ja'rjesto'_N = mkkN "järjestö" ;
lin ja'rjesto'llinen_N = mkkN "järjestöllinen" ;
lin ja'rjetto'myys_N = mkkN "järjettömyys" ;
lin ja'rjetto'ma'sti_Adv = mkkAdv "järjettömästi" ;
lin ja'rjeto'n_N = mkkN "järjetön" ;
lin ja'rkeilla'_V = mkkV "järkeillä" ;
lin ja'rkeily_N = mkkN "järkeily" ;
lin ja'rkeistya'_V = mkkV "järkeistyä" ;
lin ja'rkeista'a'_V = mkkV "järkeistää" ;
lin ja'rkevyys_N = mkkN "järkevyys" ;
lin ja'rkeva'_A = mkkA "järkevä" ;
lin ja'rkeva'sti_Adv = mkkAdv "järkevästi" ;
lin ja'rkevo'itya'_V = mkkV "järkevöityä" ;
lin ja'rki_N = mkkN "järki" ;
lin ja'rkiinnytta'a'_V = mkkV "järkiinnyttää" ;
lin ja'rkiintya'_V = mkkV "järkiintyä" ;
lin ja'rkinen_N = mkkN "järkinen" ;
lin ja'rkipera'isesti_Adv = mkkAdv "järkiperäisesti" ;
lin ja'rkipera'istya'_V = mkkV "järkiperäistyä" ;
lin ja'rkipera'ista'a'_V = mkkV "järkiperäistää" ;
lin ja'rkia'a'n_Adv = mkkAdv "järkiään" ;
lin ja'rkky_N = mkkN "järkky" ;
lin ja'rkkyma'tto'myys_N = mkkN "järkkymättömyys" ;
lin ja'rkkyma'tto'ma'sti_Adv = mkkAdv "järkkymättömästi" ;
lin ja'rkkyma'to'n_N = mkkN "järkkymätön" ;
lin ja'rkkya'_V = mkkV "järkkyä" ;
lin ja'rkyttya'_V = mkkV "järkyttyä" ;
lin ja'rkytta'vyys_N = mkkN "järkyttävyys" ;
lin ja'rkytta'va'_A = mkkA "järkyttävä" ;
lin ja'rkytta'va'sti_Adv = mkkAdv "järkyttävästi" ;
lin ja'rkytta'a'_V = mkkV "järkyttää" ;
lin ja'rkytys_N = mkkN "järkytys" ;
lin ja'rka'hta'ma'tto'myys_N = mkkN "järkähtämättömyys" ;
lin ja'rka'hta'ma'tto'ma'sti_Adv = mkkAdv "järkähtämättömästi" ;
lin ja'rka'hta'ma'to'n_N = mkkN "järkähtämätön" ;
lin ja'rka'hta'a'_V = mkkV "järkähtää" ;
lin ja'rka'le_N = mkkN "järkäle" ;
lin ja'rka'ta'_V = mkkV "järkätä" ;
lin ja'rsia'_V = mkkV "järsiä" ;
lin ja'rvi_N = mkkN "järvi" ;
lin ja'rvinen_N = mkkN "järvinen" ;
lin ja'ra'hdella'_V = mkkV "järähdellä" ;
lin ja'ra'htely_N = mkkN "järähtely" ;
lin ja'ra'hta'a'_V = mkkV "järähtää" ;
lin ja'ra'ytta'a'_V = mkkV "järäyttää" ;
lin ja'sen_N = mkkN "jäsen" ;
lin ja'seninen_N = mkkN "jäseninen" ;
lin ja'senisto'_N = mkkN "jäsenistö" ;
lin ja'sennella'_V = mkkV "jäsennellä" ;
lin ja'sennys_N = mkkN "jäsennys" ;
lin ja'sentely_N = mkkN "jäsentely" ;
lin ja'sentya'_V = mkkV "jäsentyä" ;
lin ja'senta'a'_V = mkkV "jäsentää" ;
lin ja'senyys_N = mkkN "jäsenyys" ;
lin ja'ssikka'_N = mkkN "jässikkä" ;
lin ja'te_N = mkkN "jäte" ;
lin ja'tka'_N = mkkN "jätkä" ;
lin ja'tski_N = mkkN "jätski" ;
lin ja'tti_N = mkkN "jätti" ;
lin ja'ttila'inen_N = mkkN "jättiläinen" ;
lin ja'ttila'isma'inen_N = mkkN "jättiläismäinen" ;
lin ja'ttima'inen_N = mkkN "jättimäinen" ;
lin ja'tta'ytya'_V = mkkV "jättäytyä" ;
lin ja'tta'a'_V = mkkV "jättää" ;
lin ja'tto'_N = mkkN "jättö" ;
lin ja'tto'aika_N = mkkN "jättöaika" ;
lin ja'ta'tta'a'_V = mkkV "jätättää" ;
lin ja'to's_N = mkkN "jätös" ;
lin ja'yhyys_N = mkkN "jäyhyys" ;
lin ja'yha'_A = mkkA "jäyhä" ;
lin ja'yha'sti_Adv = mkkAdv "jäyhästi" ;
lin ja'ykentya'_V = mkkV "jäykentyä" ;
lin ja'ykenta'a'_V = mkkV "jäykentää" ;
lin ja'yketa'_V = mkkV "jäyketä" ;
lin ja'ykiste_N = mkkN "jäykiste" ;
lin ja'ykistella'_V = mkkV "jäykistellä" ;
lin ja'ykistely_N = mkkN "jäykistely" ;
lin ja'ykistyma'_N = mkkN "jäykistymä" ;
lin ja'ykistys_N = mkkN "jäykistys" ;
lin ja'ykistya'_V = mkkV "jäykistyä" ;
lin ja'ykista'a'_V = mkkV "jäykistää" ;
lin ja'ykkyys_N = mkkN "jäykkyys" ;
lin ja'ykka'_N = mkkN "jäykkä" ;
lin ja'yka'sti_Adv = mkkAdv "jäykästi" ;
lin ja'yna'_N = mkkN "jäynä" ;
lin ja'ysta'a'_V = mkkV "jäystää" ;
lin ja'yta'a'_V = mkkV "jäytää" ;
lin ja'a'_N = mkkN "jää" ;
lin ja'a'aika_N = mkkN "jääaika" ;
lin ja'a'dyke_N = mkkN "jäädyke" ;
lin ja'a'dytta'mo'_N = mkkN "jäädyttämö" ;
lin ja'a'dytta'a'_V = mkkV "jäädyttää" ;
lin ja'a'dytys_N = mkkN "jäädytys" ;
lin ja'a'da'_V = mkkV "jäädä" ;
lin ja'a'hdyke_N = mkkN "jäähdyke" ;
lin ja'a'hdyte_N = mkkN "jäähdyte" ;
lin ja'a'hdytella'_V = mkkV "jäähdytellä" ;
lin ja'a'hdytin_N = mkkN "jäähdytin" ;
lin ja'a'hdytteinen_N = mkkN "jäähdytteinen" ;
lin ja'a'hdyttely_N = mkkN "jäähdyttely" ;
lin ja'a'hdytta'ja'_N = mkkN "jäähdyttäjä" ;
lin ja'a'hdytta'mo'_N = mkkN "jäähdyttämö" ;
lin ja'a'hdytta'a'_V = mkkV "jäähdyttää" ;
lin ja'a'hdytys_N = mkkN "jäähdytys" ;
lin ja'a'htya'_V = mkkV "jäähtyä" ;
lin ja'a'hy_N = mkkN "jäähy" ;
--? lin ja'a'hyva'iset_NK = {s = d38 "jäähyväiset" ;
lin ja'a'kiekkoilu_N = mkkN "jääkiekkoilu" ;
lin ja'a'ka'ri_N = mkkN "jääkäri" ;
lin ja'a'misto'_N = mkkN "jäämistö" ;
lin ja'a'ma'_N = mkkN "jäämä" ;
lin ja'a'nne_N = mkkN "jäänne" ;
lin ja'a'nno'ksetto'ma'sti_Adv = mkkAdv "jäännöksettömästi" ;
lin ja'a'nno'kseto'n_N = mkkN "jäännöksetön" ;
lin ja'a'nno's_N = mkkN "jäännös" ;
lin ja'a'nti_N = mkkN "jäänti" ;
lin ja'a'ra'_N = mkkN "jäärä" ;
lin ja'a'ra'pa'isesti_Adv = mkkAdv "jääräpäisesti" ;
lin ja'a'ra'pa'isyys_N = mkkN "jääräpäisyys" ;
lin ja'a'telo'_N = mkkN "jäätelö" ;
lin ja'a'tikko'_N = mkkN "jäätikkö" ;
lin ja'a'tikko'inen_N = mkkN "jäätikköinen" ;
lin ja'a'tiko'itya'_V = mkkV "jäätiköityä" ;
lin ja'a'tyma'_N = mkkN "jäätymä" ;
lin ja'a'tya'_V = mkkV "jäätyä" ;
lin ja'a'ta'va'_A = mkkA "jäätävä" ;
lin ja'a'ta'va'sti_Adv = mkkAdv "jäätävästi" ;
lin ja'a'ta'a'_V = mkkV "jäätää" ;
lin ja'a'vahvistettu_N = mkkN "jäävahvistettu" ;
lin ja'a'vi_N = mkkN "jäävi" ;
lin ja'a'vito'n_N = mkkN "jäävitön" ;
lin ja'a'viys_N = mkkN "jääviys" ;
lin ja'a'va'ta'_V = mkkV "jäävätä" ;
lin jo'ko'tta'a'_V = mkkV "jököttää" ;
lin jo'rrikka'_N = mkkN "jörrikkä" ;
lin jo'ro'_N = mkkN "jörö" ;
lin jo'ro'tta'a'_V = mkkV "jöröttää" ;
lin jo'ssikka'_N = mkkN "jössikkä" ;
lin jo'tikka'_N = mkkN "jötikkä" ;
lin jo'o'_N = mkkN "jöö" ;
lin kaadanta_N = mkkN "kaadanta" ;
lin kaadattaa_V = mkkV "kaadattaa" ;
lin kaade_N = mkkN "kaade" ;
lin kaadella_V = mkkV "kaadella" ;
lin kaaderi_N = mkkN "kaaderi" ;
lin kaadin_N = mkkN "kaadin" ;
lin kaahaaja_N = mkkN "kaahaaja" ;
lin kaahailija_N = mkkN "kaahailija" ;
lin kaahailla_V = mkkV "kaahailla" ;
lin kaahailu_N = mkkN "kaahailu" ;
lin kaahari_N = mkkN "kaahari" ;
lin kaahata_V = mkkV "kaahata" ;
lin kaahaus_N = mkkN "kaahaus" ;
lin kaakao_N = mkkN "kaakao" ;
lin kaakaovoi_N = mkkN "kaakaovoi" ;
lin kaakattaa_V = mkkV "kaakattaa" ;
lin kaakatus_N = mkkN "kaakatus" ;
lin kaakeli_N = mkkN "kaakeli" ;
lin kaakeloida_V = mkkV "kaakeloida" ;
lin kaakelointi_N = mkkN "kaakelointi" ;
lin kaakertaa_V = mkkV "kaakertaa" ;
lin kaakki_N = mkkN "kaakki" ;
lin kaakko_N = mkkN "kaakko" ;
lin kaakkoinen_N = mkkN "kaakkoinen" ;
lin kaakkoisraja_N = mkkN "kaakkoisraja" ;
lin kaakku_N = mkkN "kaakku" ;
lin kaakkuri_N = mkkN "kaakkuri" ;
lin kaali_N = mkkN "kaali" ;
lin kaalirapi_N = mkkN "kaalirapi" ;
lin kaamea_A = mkkA "kaamea" ;
lin kaameasti_Adv = mkkAdv "kaameasti" ;
lin kaameus_N = mkkN "kaameus" ;
lin kaamos_N = mkkN "kaamos" ;
lin kaamosaika_N = mkkN "kaamosaika" ;
lin kaanon_N = mkkN "kaanon" ;
lin kaaoksellinen_N = mkkN "kaaoksellinen" ;
lin kaaos_N = mkkN "kaaos" ;
lin kaapaista_V = mkkV "kaapaista" ;
lin kaapata_V = mkkV "kaapata" ;
lin kaapeli_N = mkkN "kaapeli" ;
lin kaapeloida_V = mkkV "kaapeloida" ;
lin kaapia_V = mkkV "kaapia" ;
lin kaapisto_N = mkkN "kaapisto" ;
lin kaappaaja_N = mkkN "kaappaaja" ;
lin kaappari_N = mkkN "kaappari" ;
lin kaappaus_N = mkkN "kaappaus" ;
lin kaappi_N = mkkN "kaappi" ;
lin kaapu_N = mkkN "kaapu" ;
lin kaaputtaa_V = mkkV "kaaputtaa" ;
lin kaaputus_N = mkkN "kaaputus" ;
lin kaara_N = mkkN "kaara" ;
lin kaareke_N = mkkN "kaareke" ;
lin kaareutua_V = mkkV "kaareutua" ;
lin kaareva_A = mkkA "kaareva" ;
lin kaarevasti_Adv = mkkAdv "kaarevasti" ;
lin kaarevuus_N = mkkN "kaarevuus" ;
lin kaari_1_N = mkkN "kaari" ;
lin kaari_2_N = mkkN "kaari" ;
lin kaarinen_N = mkkN "kaarinen" ;
lin kaarna_N = mkkN "kaarna" ;
lin kaarne_N = mkkN "kaarne" ;
lin kaarnikka_N = mkkN "kaarnikka" ;
lin kaarnoittua_V = mkkV "kaarnoittua" ;
lin kaarre_N = mkkN "kaarre" ;
lin kaarrella_V = mkkV "kaarrella" ;
lin kaarroke_N = mkkN "kaarroke" ;
lin kaarros_N = mkkN "kaarros" ;
lin kaartaa_V = mkkV "kaartaa" ;
lin kaarteinen_N = mkkN "kaarteinen" ;
lin kaartelu_N = mkkN "kaartelu" ;
lin kaarti_N = mkkN "kaarti" ;
lin kaarto_N = mkkN "kaarto" ;
lin kaartua_V = mkkV "kaartua" ;
lin kaartuma_N = mkkN "kaartuma" ;
lin kaaso_N = mkkN "kaaso" ;
lin kaasu_N = mkkN "kaasu" ;
lin kaasus_N = mkkN "kaasus" ;
lin kaasute_N = mkkN "kaasute" ;
lin kaasutella_V = mkkV "kaasutella" ;
lin kaasutin_N = mkkN "kaasutin" ;
lin kaasuttaa_V = mkkV "kaasuttaa" ;
lin kaasuttua_V = mkkV "kaasuttua" ;
lin kaasutus_N = mkkN "kaasutus" ;
lin kaasuuntua_V = mkkV "kaasuuntua" ;
lin kaataa_V = mkkV "kaataa" ;
lin kaataja_N = mkkN "kaataja" ;
lin kaateinen_N = mkkN "kaateinen" ;
lin kaato_N = mkkN "kaato" ;
lin kaatua_V = mkkV "kaatua" ;
lin kaava_N = mkkN "kaava" ;
lin kaavaaja_N = mkkN "kaavaaja" ;
lin kaavailla_V = mkkV "kaavailla" ;
lin kaavailu_N = mkkN "kaavailu" ;
lin kaavain_N = mkkN "kaavain" ;
lin kaavake_N = mkkN "kaavake" ;
lin kaavamaisesti_Adv = mkkAdv "kaavamaisesti" ;
lin kaavamaistaa_V = mkkV "kaavamaistaa" ;
lin kaavamaisuus_N = mkkN "kaavamaisuus" ;
lin kaavata_V = mkkV "kaavata" ;
lin kaaviloida_V = mkkV "kaaviloida" ;
lin kaavin_N = mkkN "kaavin" ;
lin kaavinta_N = mkkN "kaavinta" ;
lin kaavio_N = mkkN "kaavio" ;
lin kaavioida_V = mkkV "kaavioida" ;
lin kaaviointi_N = mkkN "kaaviointi" ;
lin kaavoittaa_V = mkkV "kaavoittaa" ;
lin kaavoittua_V = mkkV "kaavoittua" ;
lin kaavoittuma_N = mkkN "kaavoittuma" ;
lin kaavoittuneisuus_N = mkkN "kaavoittuneisuus" ;
lin kaavoitus_N = mkkN "kaavoitus" ;
lin kabaree_N = mkkN "kabaree" ;
lin kabinetti_N = mkkN "kabinetti" ;
lin kabotaasi_N = mkkN "kabotaasi" ;
lin kade_N = mkkN "kade" ;
lin kadehtia_V = mkkV "kadehtia" ;
lin kadehtija_N = mkkN "kadehtija" ;
lin kadenssi_N = mkkN "kadenssi" ;
lin kadetti_N = mkkN "kadetti" ;
lin kadmium_N = mkkN "kadmium" ;
lin kadoksiin_Adv = mkkAdv "kadoksiin" ;
lin kadoksissa_Adv = mkkAdv "kadoksissa" ;
lin kadota_V = mkkV "kadota" ;
lin kadottaa_V = mkkV "kadottaa" ;
lin kadotus_N = mkkN "kadotus" ;
lin kaduttaa_V = mkkV "kaduttaa" ;
lin kafeteria_N = mkkN "kafeteria" ;
lin kaftaani_N = mkkN "kaftaani" ;
lin kahahdus_N = mkkN "kahahdus" ;
lin kahahtaa_V = mkkV "kahahtaa" ;
lin kahakka_N = mkkN "kahakka" ;
lin kahakoida_V = mkkV "kahakoida" ;
lin kahakointi_N = mkkN "kahakointi" ;
lin kahareisin_Adv = mkkAdv "kahareisin" ;
lin kahdeksainen_N = mkkN "kahdeksainen" ;
lin kahdeksan_N = mkkN "kahdeksan" ;
lin kahdeksannes_N = mkkN "kahdeksannes" ;
lin kahdeksas_N = mkkN "kahdeksas" ;
lin kahdeksikko_N = mkkN "kahdeksikko" ;
lin kahdeksisen_Adv = mkkAdv "kahdeksisen" ;
lin kahdeksisenkymmenta'_Adv = mkkAdv "kahdeksisenkymmentä" ;
lin kahden_Adv = mkkAdv "kahden" ;
lin kahdenistuttava_N = mkkN "kahdenistuttava" ;
lin kahden_kesken_Adv = mkkAdv "kahdeC" ;
lin kahdenkeskisesti_Adv = mkkAdv "kahdenkeskisesti" ;
lin kahdenmaattava_N = mkkN "kahdenmaattava" ;
lin kahdennus_N = mkkN "kahdennus" ;
lin kahdentaa_V = mkkV "kahdentaa" ;
lin kahdentua_V = mkkV "kahdentua" ;
lin kahdes_N = mkkN "kahdes" ;
lin kahdestaan_Adv = mkkAdv "kahdestaan" ;
lin kahdesti_Adv = mkkAdv "kahdesti" ;
lin kaheli_N = mkkN "kaheli" ;
lin kahina_N = mkkN "kahina" ;
lin kahinoida_V = mkkV "kahinoida" ;
lin kahinointi_N = mkkN "kahinointi" ;
lin kahista_V = mkkV "kahista" ;
lin kahisuttaa_V = mkkV "kahisuttaa" ;
lin kahjo_N = mkkN "kahjo" ;
lin kahju_N = mkkN "kahju" ;
lin kahlaaja_N = mkkN "kahlaaja" ;
lin kahlaamo_N = mkkN "kahlaamo" ;
lin kahlata_V = mkkV "kahlata" ;
lin kahlaus_N = mkkN "kahlaus" ;
lin kahle_N = mkkN "kahle" ;
lin kahlehtia_V = mkkV "kahlehtia" ;
lin kahlehtimaton_N = mkkN "kahlehtimaton" ;
lin kahlita_V = mkkV "kahlita" ;
lin kahlitsematon_N = mkkN "kahlitsematon" ;
lin kahluu_N = mkkN "kahluu" ;
lin kahmaista_V = mkkV "kahmaista" ;
lin kahmaisu_N = mkkN "kahmaisu" ;
lin kahmalo_N = mkkN "kahmalo" ;
lin kahmalokaupalla_Adv = mkkAdv "kahmalokaupalla" ;
lin kahmalollinen_N = mkkN "kahmalollinen" ;
lin kahmari_N = mkkN "kahmari" ;
lin kahmia_V = mkkV "kahmia" ;
lin kahnaus_N = mkkN "kahnaus" ;
lin kahta_Adv = mkkAdv "kahta" ;
lin kahtaalla_Adv = mkkAdv "kahtaalla" ;
lin kahtaalle_Adv = mkkAdv "kahtaalle" ;
lin kahtaalta_Adv = mkkAdv "kahtaalta" ;
lin kahtaanne_Adv = mkkAdv "kahtaanne" ;
lin kahtaistaittuminen_N = mkkN "kahtaistaittuminen" ;
lin kahtalaisuus_N = mkkN "kahtalaisuus" ;
lin kahtapuolin_Adv = mkkAdv "kahtapuolin" ;
lin kahtia_Adv = mkkAdv "kahtia" ;
lin kahuta'hka'isyys_N = mkkN "kahutähkäisyys" ;
lin kahva_N = mkkN "kahva" ;
lin kahveli_N = mkkN "kahveli" ;
lin kahvi_N = mkkN "kahvi" ;
lin kahviaika_N = mkkN "kahviaika" ;
lin kahvila_N = mkkN "kahvila" ;
lin kahvinjuoja_N = mkkN "kahvinjuoja" ;
lin kahvinporo_N = mkkN "kahvinporo" ;
lin kahvinselvike_N = mkkN "kahvinselvike" ;
lin kahvio_N = mkkN "kahvio" ;
lin kahvitella_V = mkkV "kahvitella" ;
lin kahvittaa_V = mkkV "kahvittaa" ;
lin kahvittelu_N = mkkN "kahvittelu" ;
lin kahvitus_N = mkkN "kahvitus" ;
lin kahvituttaa_V = mkkV "kahvituttaa" ;
lin kai_Adv = mkkAdv "kai" ;
lin kaide_N = mkkN "kaide" ;
lin kaihdella_V = mkkV "kaihdella" ;
lin kaihdin_N = mkkN "kaihdin" ;
lin kaiherrus_N = mkkN "kaiherrus" ;
lin kaihertaa_V = mkkV "kaihertaa" ;
lin kaihi_N = mkkN "kaihi" ;
lin kaiho_N = mkkN "kaiho" ;
lin kaihoisa_A = mkkA "kaihoisa" ;
lin kaihoisasti_Adv = mkkAdv "kaihoisasti" ;
lin kaihota_V = mkkV "kaihota" ;
lin kaihtaa_V = mkkV "kaihtaa" ;
lin kaikaa_V = mkkV "kaikaa" ;
lin kaiken_kaikkiaan_Adv = mkkAdv "kaikeC" ;
lin kaikenlainen_N = mkkN "kaikenlainen" ;
lin kaikenmoinen_N = mkkN "kaikenmoinen" ;
lin kaiketi_Adv = mkkAdv "kaiketi" ;
lin kaikin_Adv = mkkAdv "kaikin" ;
lin kaikista_Adv = mkkAdv "kaikista" ;
lin kaikitenkin_Adv = mkkAdv "kaikitenkin" ;
lin kaikkein_Adv = mkkAdv "kaikkein" ;
lin kaikkeus_N = mkkN "kaikkeus" ;
lin kaikki_N = mkkN "kaikki" ;
lin kaikkiaan_Adv = mkkAdv "kaikkiaan" ;
lin kaikkialla_Adv = mkkAdv "kaikkialla" ;
lin kaikkialle_Adv = mkkAdv "kaikkialle" ;
lin kaikkialta_Adv = mkkAdv "kaikkialta" ;
lin kaikkianne_Adv = mkkAdv "kaikkianne" ;
lin kaikkinieleva'_N = mkkN "kaikkinielevä" ;
lin kaikkivoipuus_N = mkkN "kaikkivoipuus" ;
lin kaikota_V = mkkV "kaikota" ;
lin kaiku_N = mkkN "kaiku" ;
lin kaikua_V = mkkV "kaikua" ;
lin kaikuisa_N = mkkN "kaikuisa" ;
lin kaikuisuus_N = mkkN "kaikuisuus" ;
lin kaikuvasti_Adv = mkkAdv "kaikuvasti" ;
lin kaikuvuus_N = mkkN "kaikuvuus" ;
lin kailottaa_V = mkkV "kailottaa" ;
lin kailotus_N = mkkN "kailotus" ;
lin kaima_N = mkkN "kaima" ;
lin kaimaani_N = mkkN "kaimaani" ;
--? lin kaimakset_NK = {s = d39 "kaimakset" ;
lin kainalo_N = mkkN "kainalo" ;
lin kainaloinen_N = mkkN "kainaloinen" ;
lin kaino_A = mkkA "kaino" ;
lin kainostelematon_N = mkkN "kainostelematon" ;
lin kainostella_V = mkkV "kainostella" ;
lin kainosti_Adv = mkkAdv "kainosti" ;
lin kainostuttaa_V = mkkV "kainostuttaa" ;
lin kainous_N = mkkN "kainous" ;
lin kainulainen_N = mkkN "kainulainen" ;
lin kainuulainen_N = mkkN "kainuulainen" ;
lin kaipailla_V = mkkV "kaipailla" ;
lin kaipaus_N = mkkN "kaipaus" ;
lin kaira_1_N = mkkN "kaira" ;
lin kaira_2_N = mkkN "kaira" ;
lin kairata_V = mkkV "kairata" ;
lin kairaus_N = mkkN "kairaus" ;
lin kaisla_N = mkkN "kaisla" ;
lin kaislikko_N = mkkN "kaislikko" ;
lin kaislikkoinen_N = mkkN "kaislikkoinen" ;
lin kaislisto_N = mkkN "kaislisto" ;
lin kaista_N = mkkN "kaista" ;
lin kaistainen_N = mkkN "kaistainen" ;
lin kaistale_N = mkkN "kaistale" ;
lin kait_Adv = mkkAdv "kait" ;
lin kaita_1_N = mkkN "kaita" ;
lin kaita_2_V = mkkV "kaita" ;
lin kaitainen_N = mkkN "kaitainen" ;
lin kaitsea_V = mkkV "kaitsea" ;
lin kaitselmus_N = mkkN "kaitselmus" ;
lin kaiunta_N = mkkN "kaiunta" ;
lin kaiutella_V = mkkV "kaiutella" ;
lin kaiutin_N = mkkN "kaiutin" ;
lin kaiuton_N = mkkN "kaiuton" ;
lin kaiuttaa_V = mkkV "kaiuttaa" ;
lin kaivaa_V = mkkV "kaivaa" ;
lin kaivannainen_N = mkkN "kaivannainen" ;
lin kaivanto_N = mkkN "kaivanto" ;
lin kaivata_V = mkkV "kaivata" ;
lin kaivattaa_V = mkkV "kaivattaa" ;
lin kaivaus_N = mkkN "kaivaus" ;
lin kaivauttaa_V = mkkV "kaivauttaa" ;
lin kaivautua_V = mkkV "kaivautua" ;
lin kaivella_V = mkkV "kaivella" ;
lin kaiverre_N = mkkN "kaiverre" ;
lin kaiverrin_N = mkkN "kaiverrin" ;
lin kaiverros_N = mkkN "kaiverros" ;
lin kaiverrus_N = mkkN "kaiverrus" ;
lin kaiverruttaa_V = mkkV "kaiverruttaa" ;
lin kaivertaa_V = mkkV "kaivertaa" ;
lin kaivertaja_N = mkkN "kaivertaja" ;
lin kaivin_N = mkkN "kaivin" ;
lin kaivo_N = mkkN "kaivo" ;
lin kaivos_N = mkkN "kaivos" ;
lin kaivu_N = mkkN "kaivu" ;
lin kaivuri_N = mkkN "kaivuri" ;
lin kajaali_N = mkkN "kajaali" ;
lin kajahdella_V = mkkV "kajahdella" ;
lin kajahdus_N = mkkN "kajahdus" ;
lin kajahduttaa_V = mkkV "kajahduttaa" ;
lin kajahtaa_V = mkkV "kajahtaa" ;
lin kajahtelu_N = mkkN "kajahtelu" ;
lin kajakki_N = mkkN "kajakki" ;
lin kajal_N = mkkN "kajal" ;
lin kajastaa_V = mkkV "kajastaa" ;
lin kajastella_V = mkkV "kajastella" ;
lin kajastua_V = mkkV "kajastua" ;
lin kajastus_N = mkkN "kajastus" ;
lin kajaus_N = mkkN "kajaus" ;
lin kajautella_V = mkkV "kajautella" ;
lin kajauttaa_V = mkkV "kajauttaa" ;
lin kajava_N = mkkN "kajava" ;
lin kaje_N = mkkN "kaje" ;
lin kajentaa_V = mkkV "kajentaa" ;
lin kajetto_N = mkkN "kajetto" ;
lin kajo_N = mkkN "kajo" ;
lin kajota_V = mkkV "kajota" ;
lin kajottaa_V = mkkV "kajottaa" ;
lin kajuutallinen_N = mkkN "kajuutallinen" ;
lin kajuutta_N = mkkN "kajuutta" ;
lin kakadu_N = mkkN "kakadu" ;
lin kakaista_V = mkkV "kakaista" ;
lin kakara_N = mkkN "kakara" ;
lin kakata_V = mkkV "kakata" ;
lin kakattaa_V = mkkV "kakattaa" ;
lin kaki_N = mkkN "kaki" ;
lin kakistaa_V = mkkV "kakistaa" ;
lin kakistella_V = mkkV "kakistella" ;
lin kakistelu_N = mkkN "kakistelu" ;
lin kakka_N = mkkN "kakka" ;
lin kakkainen_N = mkkN "kakkainen" ;
lin kakkara_N = mkkN "kakkara" ;
lin kakkia_V = mkkV "kakkia" ;
lin kakkonen_N = mkkN "kakkonen" ;
lin kakku_N = mkkN "kakku" ;
--? lin kakkulat_NK = {s = d12 "kakkulat" ;
lin kakluuni_N = mkkN "kakluuni" ;
lin kakofonia_N = mkkN "kakofonia" ;
lin kakofoninen_N = mkkN "kakofoninen" ;
lin kakru_N = mkkN "kakru" ;
lin kaks_Adv = mkkAdv "kaks" ;
lin kaksari_N = mkkN "kaksari" ;
lin kaksi_N = mkkN "kaksi" ;
lin kaksijakoisuus_N = mkkN "kaksijakoisuus" ;
lin kaksikasvoisuus_N = mkkN "kaksikasvoisuus" ;
lin kaksikielistya'_V = mkkV "kaksikielistyä" ;
lin kaksikko_N = mkkN "kaksikko" ;
lin kaksikotinen_N = mkkN "kaksikotinen" ;
lin kaksikotisuus_N = mkkN "kaksikotisuus" ;
lin kaksika'sitteinen_N = mkkN "kaksikäsitteinen" ;
lin kaksilappeinen_N = mkkN "kaksilappeinen" ;
lin kaksiminuuttinen_N = mkkN "kaksiminuuttinen" ;
lin kaksin_Adv = mkkAdv "kaksin" ;
lin kaksinaamaisuus_N = mkkN "kaksinaamaisuus" ;
lin kaksinapaisesti_Adv = mkkAdv "kaksinapaisesti" ;
lin kaksinen_N = mkkN "kaksinen" ;
lin kaksineuvoisuus_N = mkkN "kaksineuvoisuus" ;
lin kaksinkertaisesti_Adv = mkkAdv "kaksinkertaisesti" ;
lin kaksinkertaistaa_V = mkkV "kaksinkertaistaa" ;
lin kaksinkertaistua_V = mkkV "kaksinkertaistua" ;
lin kaksinnaiminen_N = mkkN "kaksinnaiminen" ;
lin kaksinnus_N = mkkN "kaksinnus" ;
lin kaksintaa_V = mkkV "kaksintaa" ;
lin kaksio_N = mkkN "kaksio" ;
lin kaksistaan_Adv = mkkAdv "kaksistaan" ;
lin kaksisukupuolisuus_N = mkkN "kaksisukupuolisuus" ;
lin kaksittain_Adv = mkkAdv "kaksittain" ;
lin kaksoisvoltti_N = mkkN "kaksoisvoltti" ;
lin kaksonen_N = mkkN "kaksonen" ;
lin kaksospari_N = mkkN "kaksospari" ;
lin kaktus_N = mkkN "kaktus" ;
lin kakuttaa_V = mkkV "kakuttaa" ;
lin kala_N = mkkN "kala" ;
lin kalaasi_N = mkkN "kalaasi" ;
lin kalabaliikki_N = mkkN "kalabaliikki" ;
lin kalahdella_V = mkkV "kalahdella" ;
lin kalahdus_N = mkkN "kalahdus" ;
lin kalahtaa_V = mkkV "kalahtaa" ;
lin kalainen_N = mkkN "kalainen" ;
lin kalaisa_N = mkkN "kalaisa" ;
lin kalaisuus_N = mkkN "kalaisuus" ;
lin kalanteri_N = mkkN "kalanteri" ;
lin kalanteroida_V = mkkV "kalanteroida" ;
lin kalastaa_V = mkkV "kalastaa" ;
lin kalastaja_N = mkkN "kalastaja" ;
lin kalastavuus_N = mkkN "kalastavuus" ;
lin kalastella_V = mkkV "kalastella" ;
lin kalastelu_N = mkkN "kalastelu" ;
lin kalasto_N = mkkN "kalasto" ;
lin kalastus_N = mkkN "kalastus" ;
lin kalauttaa_V = mkkV "kalauttaa" ;
lin kale_N = mkkN "kale" ;
lin kaleeri_N = mkkN "kaleeri" ;
lin kaleidoskooppi_N = mkkN "kaleidoskooppi" ;
lin kalendaarinen_N = mkkN "kalendaarinen" ;
lin kalendaario_N = mkkN "kalendaario" ;
lin kalenteri_N = mkkN "kalenteri" ;
lin kalevalainen_N = mkkN "kalevalainen" ;
lin kalhu_N = mkkN "kalhu" ;
lin kali_N = mkkN "kali" ;
lin kalibroida_V = mkkV "kalibroida" ;
lin kalibrointi_N = mkkN "kalibrointi" ;
lin kalifi_N = mkkN "kalifi" ;
lin kaliiberi_N = mkkN "kaliiberi" ;
lin kaliiberinen_N = mkkN "kaliiberinen" ;
lin kaliiperi_N = mkkN "kaliiperi" ;
lin kaliiperinen_N = mkkN "kaliiperinen" ;
lin kalikka_N = mkkN "kalikka" ;
lin kalina_N = mkkN "kalina" ;
lin kalista_V = mkkV "kalista" ;
lin kalistaa_V = mkkV "kalistaa" ;
lin kalistella_V = mkkV "kalistella" ;
lin kalistin_N = mkkN "kalistin" ;
lin kalisuttaa_V = mkkV "kalisuttaa" ;
lin kalium_N = mkkN "kalium" ;
lin kalja_N = mkkN "kalja" ;
lin kaljaasi_N = mkkN "kaljaasi" ;
lin kaljama_N = mkkN "kaljama" ;
lin kaljoitella_V = mkkV "kaljoitella" ;
lin kalju_N = mkkN "kalju" ;
lin kaljupa'isyys_N = mkkN "kaljupäisyys" ;
lin kaljuuntua_V = mkkV "kaljuuntua" ;
lin kaljuus_N = mkkN "kaljuus" ;
lin kalkattaa_V = mkkV "kalkattaa" ;
lin kalkatus_N = mkkN "kalkatus" ;
lin kalke_N = mkkN "kalke" ;
lin kalkita_V = mkkV "kalkita" ;
lin kalkitus_N = mkkN "kalkitus" ;
lin kalkkaa_V = mkkV "kalkkaa" ;
lin kalkkeuma_N = mkkN "kalkkeuma" ;
lin kalkkeutua_V = mkkV "kalkkeutua" ;
lin kalkkeutuma_N = mkkN "kalkkeutuma" ;
lin kalkki_1_N = mkkN "kalkki" ;
lin kalkki_2_N = mkkN "kalkki" ;
lin kalkkis_N = mkkN "kalkkis" ;
lin kalkkiuma_N = mkkN "kalkkiuma" ;
lin kalkkiutua_V = mkkV "kalkkiutua" ;
lin kalkkiutuma_N = mkkN "kalkkiutuma" ;
lin kalkkuna_N = mkkN "kalkkuna" ;
lin kalkutella_V = mkkV "kalkutella" ;
lin kalkuttaa_V = mkkV "kalkuttaa" ;
lin kalkuttelu_N = mkkN "kalkuttelu" ;
lin kalkutus_N = mkkN "kalkutus" ;
lin kalkyloida_V = mkkV "kalkyloida" ;
lin kalkyyli_N = mkkN "kalkyyli" ;
lin kalla_N = mkkN "kalla" ;
lin kallas_N = mkkN "kallas" ;
lin kalle_N = mkkN "kalle" ;
lin kallellaan_Adv = mkkAdv "kallellaan" ;
lin kallelleen_Adv = mkkAdv "kallelleen" ;
lin kalleus_N = mkkN "kalleus" ;
lin kallio_N = mkkN "kallio" ;
lin kallioinen_N = mkkN "kallioinen" ;
lin kallionlaki_N = mkkN "kallionlaki" ;
lin kallis_N = mkkN "kallis" ;
lin kallistaa_1_V = mkkV "kallistaa" ;
lin kallistaa_2_V = mkkV "kallistaa" ;
lin kallistella_V = mkkV "kallistella" ;
lin kallistelu_N = mkkN "kallistelu" ;
lin kallistua_1_V = mkkV "kallistua" ;
lin kallistua_2_V = mkkV "kallistua" ;
lin kallistus_N = mkkN "kallistus" ;
lin kallistuvakorinen_N = mkkN "kallistuvakorinen" ;
lin kallo_N = mkkN "kallo" ;
lin kalloinen_N = mkkN "kalloinen" ;
lin kallollinen_N = mkkN "kallollinen" ;
lin kallonkutistaja_N = mkkN "kallonkutistaja" ;
lin kalma_N = mkkN "kalma" ;
lin kalmannos_N = mkkN "kalmannos" ;
lin kalmari_N = mkkN "kalmari" ;
lin kalmetoida_V = mkkV "kalmetoida" ;
lin kalmisto_N = mkkN "kalmisto" ;
lin kalmo_N = mkkN "kalmo" ;
lin kalmojuuri_N = mkkN "kalmojuuri" ;
lin kalmukki_N = mkkN "kalmukki" ;
lin kalopsi_N = mkkN "kalopsi" ;
lin kalori_N = mkkN "kalori" ;
lin kalorinen_N = mkkN "kalorinen" ;
lin kaloriton_N = mkkN "kaloriton" ;
lin kalossi_N = mkkN "kalossi" ;
lin kalotti_N = mkkN "kalotti" ;
lin kalpa_N = mkkN "kalpa" ;
lin kalpaten_Adv = mkkAdv "kalpaten" ;
lin kalpea_N = mkkN "kalpea" ;
lin kalpeus_N = mkkN "kalpeus" ;
lin kalppia_V = mkkV "kalppia" ;
lin kalsa_N = mkkN "kalsa" ;
lin kalsareisillaan_Adv = mkkAdv "kalsareisillaan" ;
lin kalsareisilleen_Adv = mkkAdv "kalsareisilleen" ;
lin kalsarisillaan_Adv = mkkAdv "kalsarisillaan" ;
lin kalsarisilleen_Adv = mkkAdv "kalsarisilleen" ;
--? lin kalsarit_NK = {s = d06 "kalsarit" ;
lin kalsea_A = mkkA "kalsea" ;
lin kalseasti_Adv = mkkAdv "kalseasti" ;
lin kalseus_N = mkkN "kalseus" ;
lin kalsium_N = mkkN "kalsium" ;
lin kalsiumkloridi_N = mkkN "kalsiumkloridi" ;
lin kalskahtaa_V = mkkV "kalskahtaa" ;
lin kalske_N = mkkN "kalske" ;
lin kalsongit_N = mkkN "kalsongit" ;
lin kaltainen_N = mkkN "kaltainen" ;
lin kaltaistaa_V = mkkV "kaltaistaa" ;
lin kaltaisuus_N = mkkN "kaltaisuus" ;
lin kaltata_V = mkkV "kaltata" ;
--? lin kalterit_NK = {s = d06 "kalterit" ;
lin kalteva_N = mkkN "kalteva" ;
lin kaltevoida_V = mkkV "kaltevoida" ;
lin kaltevointi_N = mkkN "kaltevointi" ;
lin kaltevuus_N = mkkN "kaltevuus" ;
lin kaltio_N = mkkN "kaltio" ;
lin kaltoin_Adv = mkkAdv "kaltoin" ;
lin kalttaus_N = mkkN "kalttaus" ;
lin kalu_N = mkkN "kalu" ;
lin kalustaa_V = mkkV "kalustaa" ;
lin kalustamaton_N = mkkN "kalustamaton" ;
lin kaluste_N = mkkN "kaluste" ;
lin kalusto_N = mkkN "kalusto" ;
lin kalustus_N = mkkN "kalustus" ;
lin kaluta_V = mkkV "kaluta" ;
lin kaluuna_N = mkkN "kaluuna" ;
lin kalvaa_V = mkkV "kalvaa" ;
lin kalvakka_N = mkkN "kalvakka" ;
lin kalvakkuus_N = mkkN "kalvakkuus" ;
lin kalvas_N = mkkN "kalvas" ;
lin kalventaa_V = mkkV "kalventaa" ;
lin kalveta_V = mkkV "kalveta" ;
lin kalvia_V = mkkV "kalvia" ;
lin kalvin_N = mkkN "kalvin" ;
lin kalvinilainen_N = mkkN "kalvinilainen" ;
lin kalvinilaisuus_N = mkkN "kalvinilaisuus" ;
lin kalvinisti_N = mkkN "kalvinisti" ;
lin kalvinistinen_N = mkkN "kalvinistinen" ;
lin kalvinta_N = mkkN "kalvinta" ;
lin kalvo_N = mkkN "kalvo" ;
lin kalvosin_N = mkkN "kalvosin" ;
lin kama_N = mkkN "kama" ;
lin kamala_A = mkkA "kamala" ;
lin kamalasti_Adv = mkkAdv "kamalasti" ;
lin kamaluus_N = mkkN "kamaluus" ;
lin kamana_N = mkkN "kamana" ;
lin kamara_N = mkkN "kamara" ;
lin kamari_N = mkkN "kamari" ;
lin kamarinen_N = mkkN "kamarinen" ;
lin kambri_N = mkkN "kambri" ;
lin kambrinen_N = mkkN "kambrinen" ;
lin kamee_N = mkkN "kamee" ;
lin kameleontti_N = mkkN "kameleontti" ;
lin kameli_N = mkkN "kameli" ;
lin kamelia_N = mkkN "kamelia" ;
lin kamera_N = mkkN "kamera" ;
lin kamferi_N = mkkN "kamferi" ;
lin kamiina_N = mkkN "kamiina" ;
lin kammata_V = mkkV "kammata" ;
lin kammeta_V = mkkV "kammeta" ;
lin kammio_N = mkkN "kammio" ;
lin kammioinen_N = mkkN "kammioinen" ;
lin kammitsoida_V = mkkV "kammitsoida" ;
lin kammo_N = mkkN "kammo" ;
lin kammoa_V = mkkV "kammoa" ;
lin kammoksua_V = mkkV "kammoksua" ;
lin kammoksuttaa_V = mkkV "kammoksuttaa" ;
lin kammota_V = mkkV "kammota" ;
lin kammottaa_V = mkkV "kammottaa" ;
lin kammottava_A = mkkA "kammottava" ;
lin kammottavasti_Adv = mkkAdv "kammottavasti" ;
lin kammottavuus_N = mkkN "kammottavuus" ;
lin kamomilla_N = mkkN "kamomilla" ;
lin kampa_N = mkkN "kampa" ;
lin kampaaja_N = mkkN "kampaaja" ;
lin kampaamo_N = mkkN "kampaamo" ;
lin kampanja_N = mkkN "kampanja" ;
lin kampanjoida_V = mkkV "kampanjoida" ;
lin kampanjointi_N = mkkN "kampanjointi" ;
lin kampata_V = mkkV "kampata" ;
lin kampaus_N = mkkN "kampaus" ;
lin kampauttaa_V = mkkV "kampauttaa" ;
lin kampe_N = mkkN "kampe" ;
lin kampela_N = mkkN "kampela" ;
lin kampeutua_V = mkkV "kampeutua" ;
lin kampi_N = mkkN "kampi" ;
lin kampittaa_V = mkkV "kampittaa" ;
lin kampitus_N = mkkN "kampitus" ;
lin kamppailla_V = mkkV "kamppailla" ;
lin kamppailu_N = mkkN "kamppailu" ;
lin kamppaus_N = mkkN "kamppaus" ;
--? lin kamppeet_NK = {s = d48A "kamppeet" ;
lin kamppi_N = mkkN "kamppi" ;
--? lin kamppiaiset_NK = {s = d38 "kamppiaiset" ;
--? lin kampsut_NK = {s = d01 "kampsut" ;
lin kampura_N = mkkN "kampura" ;
lin kampus_N = mkkN "kampus" ;
lin kamreeri_N = mkkN "kamreeri" ;
lin kamu_N = mkkN "kamu" ;
lin kana_N = mkkN "kana" ;
lin kanaali_N = mkkN "kanaali" ;
lin kanadalainen_N = mkkN "kanadalainen" ;
lin kanala_N = mkkN "kanala" ;
lin kanalisaatio_N = mkkN "kanalisaatio" ;
lin kanalisoida_V = mkkV "kanalisoida" ;
lin kanalisoitua_V = mkkV "kanalisoitua" ;
lin kanalja_N = mkkN "kanalja" ;
lin kanamaisesti_Adv = mkkAdv "kanamaisesti" ;
lin kanamaisuus_N = mkkN "kanamaisuus" ;
lin kanava_N = mkkN "kanava" ;
lin kanavisto_N = mkkN "kanavisto" ;
lin kanavoida_V = mkkV "kanavoida" ;
lin kanavoitua_V = mkkV "kanavoitua" ;
lin kandeerata_V = mkkV "kandeerata" ;
lin kandela_N = mkkN "kandela" ;
lin kandi_N = mkkN "kandi" ;
lin kandidaatti_N = mkkN "kandidaatti" ;
lin kaneli_N = mkkN "kaneli" ;
lin kanelinkuori_N = mkkN "kanelinkuori" ;
lin kanerva_N = mkkN "kanerva" ;
lin kanervikko_N = mkkN "kanervikko" ;
lin kanervisto_N = mkkN "kanervisto" ;
lin kangas_1_N = mkkN "kangas" ;
lin kangas_2_N = mkkN "kangas" ;
lin kangastaa_V = mkkV "kangastaa" ;
lin kangastella_V = mkkV "kangastella" ;
lin kangastua_V = mkkV "kangastua" ;
lin kangastus_N = mkkN "kangastus" ;
lin kangerrella_V = mkkV "kangerrella" ;
lin kangerrus_N = mkkN "kangerrus" ;
lin kangertaa_V = mkkV "kangertaa" ;
lin kangertelu_N = mkkN "kangertelu" ;
lin kangeta_V = mkkV "kangeta" ;
lin kangistaa_V = mkkV "kangistaa" ;
lin kangistua_V = mkkV "kangistua" ;
lin kangistuttaa_V = mkkV "kangistuttaa" ;
lin kani_1_N = mkkN "kani" ;
lin kani_2_N = mkkN "kani" ;
lin kaniini_N = mkkN "kaniini" ;
lin kanisteri_N = mkkN "kanisteri" ;
lin kanittaa_V = mkkV "kanittaa" ;
lin kanjoni_N = mkkN "kanjoni" ;
lin kankainen_1_N = mkkN "kankainen" ;
lin kankainen_2_N = mkkN "kankainen" ;
lin kankare_N = mkkN "kankare" ;
lin kankea_A = mkkA "kankea" ;
lin kankeasti_Adv = mkkAdv "kankeasti" ;
lin kankeus_N = mkkN "kankeus" ;
lin kankeuttaa_V = mkkV "kankeuttaa" ;
lin kanki_N = mkkN "kanki" ;
lin kankku_N = mkkN "kankku" ;
lin kankkunen_N = mkkN "kankkunen" ;
lin kankuri_N = mkkN "kankuri" ;
lin kanna_1_N = mkkN "kanna" ;
lin kanna_2_N = mkkN "kanna" ;
lin kannabis_N = mkkN "kannabis" ;
lin kannakselainen_N = mkkN "kannakselainen" ;
lin kannalla_Adv = mkkAdv "kannalla" ;
lin kannalle_Adv = mkkAdv "kannalle" ;
lin kannallinen_N = mkkN "kannallinen" ;
lin kannalta_Adv = mkkAdv "kannalta" ;
lin kannas_N = mkkN "kannas" ;
lin kannassa_Adv = mkkAdv "kannassa" ;
lin kannasta_Adv = mkkAdv "kannasta" ;
lin kannate_N = mkkN "kannate" ;
lin kannatella_V = mkkV "kannatella" ;
lin kannatin_N = mkkN "kannatin" ;
lin kannattaa_V = mkkV "kannattaa" ;
lin kannattaja_N = mkkN "kannattaja" ;
lin kannattamaton_N = mkkN "kannattamaton" ;
lin kannattava_N = mkkN "kannattava" ;
lin kannattavuus_N = mkkN "kannattavuus" ;
lin kannatus_N = mkkN "kannatus" ;
lin kanne_N = mkkN "kanne" ;
lin kanneaika_N = mkkN "kanneaika" ;
lin kannel_N = mkkN "kannel" ;
lin kannella_V = mkkV "kannella" ;
lin kannellinen_N = mkkN "kannellinen" ;
lin kanneloni_N = mkkN "kanneloni" ;
lin kannibaali_N = mkkN "kannibaali" ;
lin kannibaalinen_N = mkkN "kannibaalinen" ;
lin kannibalismi_N = mkkN "kannibalismi" ;
lin kannike_N = mkkN "kannike" ;
lin kannikka_N = mkkN "kannikka" ;
lin kannin_N = mkkN "kannin" ;
lin kanniskella_V = mkkV "kanniskella" ;
lin kannoilla_Adv = mkkAdv "kannoilla" ;
lin kannoille_Adv = mkkAdv "kannoille" ;
lin kannoilta_Adv = mkkAdv "kannoilta" ;
lin kannokko_N = mkkN "kannokko" ;
lin kannokkoinen_N = mkkN "kannokkoinen" ;
lin kannu_N = mkkN "kannu" ;
lin kannuittain_Adv = mkkAdv "kannuittain" ;
lin kannullinen_N = mkkN "kannullinen" ;
lin kannus_1_N = mkkN "kannus" ;
lin kannus_2_N = mkkN "kannus" ;
lin kannustaa_V = mkkV "kannustaa" ;
lin kannustaja_N = mkkN "kannustaja" ;
lin kannuste_N = mkkN "kannuste" ;
lin kannustin_N = mkkN "kannustin" ;
lin kannustus_N = mkkN "kannustus" ;
lin kanoninen_N = mkkN "kanoninen" ;
lin kanonisoida_V = mkkV "kanonisoida" ;
lin kanonisoitua_V = mkkV "kanonisoitua" ;
lin kanonistaa_V = mkkV "kanonistaa" ;
lin kanooppi_N = mkkN "kanooppi" ;
lin kanootti_N = mkkN "kanootti" ;
lin kanotisti_N = mkkN "kanotisti" ;
lin kanotoida_V = mkkV "kanotoida" ;
lin kansa_N = mkkN "kansa" ;
lin kansainva'lisesti_Adv = mkkAdv "kansainvälisesti" ;
lin kansainva'listya'_V = mkkV "kansainvälistyä" ;
lin kansainva'lista'a'_V = mkkV "kansainvälistää" ;
lin kansainva'lisyys_N = mkkN "kansainvälisyys" ;
lin kansalaisuudeton_N = mkkN "kansalaisuudeton" ;
lin kansalaisuudettomuus_N = mkkN "kansalaisuudettomuus" ;
lin kansalaisuus_N = mkkN "kansalaisuus" ;
lin kansallinen_A = mkkA "kansallinen" ;
lin kansallisesti_Adv = mkkAdv "kansallisesti" ;
lin kansallistaa_V = mkkV "kansallistaa" ;
lin kansallisuus_N = mkkN "kansallisuus" ;
lin kansanomaisesti_Adv = mkkAdv "kansanomaisesti" ;
lin kansantajuistaa_V = mkkV "kansantajuistaa" ;
lin kansanvaltaisesti_Adv = mkkAdv "kansanvaltaisesti" ;
lin kansanvaltaistaa_V = mkkV "kansanvaltaistaa" ;
lin kansanvaltaistua_V = mkkV "kansanvaltaistua" ;
lin kanserogeeni_N = mkkN "kanserogeeni" ;
lin kanserogeeninen_N = mkkN "kanserogeeninen" ;
lin kansi_N = mkkN "kansi" ;
lin kansinen_N = mkkN "kansinen" ;
lin kansio_N = mkkN "kansio" ;
lin kansioida_V = mkkV "kansioida" ;
lin kansittaa_V = mkkV "kansittaa" ;
lin kansitus_N = mkkN "kansitus" ;
lin kansleri_N = mkkN "kansleri" ;
lin kanslia_N = mkkN "kanslia" ;
lin kanslisti_N = mkkN "kanslisti" ;
lin kansoittaa_V = mkkV "kansoittaa" ;
lin kansoittua_V = mkkV "kansoittua" ;
lin kanssa_Adv = mkkAdv "kanssa" ;
lin kanta_N = mkkN "kanta" ;
lin kantaa_V = mkkV "kantaa" ;
lin kantaan_Adv = mkkAdv "kantaan" ;
lin kantaatti_N = mkkN "kantaatti" ;
lin kantainen_N = mkkN "kantainen" ;
lin kantaisuus_N = mkkN "kantaisuus" ;
lin kantaja_N = mkkN "kantaja" ;
lin kantama_N = mkkN "kantama" ;
lin kantamaton_N = mkkN "kantamaton" ;
lin kantamuksellinen_N = mkkN "kantamuksellinen" ;
lin kantamuksittain_Adv = mkkAdv "kantamuksittain" ;
lin kantamus_N = mkkN "kantamus" ;
lin kantarelli_N = mkkN "kantarelli" ;
lin kantata_V = mkkV "kantata" ;
lin kantautua_V = mkkV "kantautua" ;
lin kantavuus_N = mkkN "kantavuus" ;
lin kantele_N = mkkN "kantele" ;
lin kantelija_N = mkkN "kantelija" ;
lin kantelu_N = mkkN "kantelu" ;
lin kantinen_N = mkkN "kantinen" ;
lin kantio_N = mkkN "kantio" ;
lin kanto_1_N = mkkN "kanto" ;
lin kanto_2_N = mkkN "kanto" ;
lin kantoaika_N = mkkN "kantoaika" ;
lin kantoinen_1_N = mkkN "kantoinen" ;
lin kantoinen_2_N = mkkN "kantoinen" ;
lin kantoisuus_N = mkkN "kantoisuus" ;
lin kantoni_N = mkkN "kantoni" ;
lin kantri_N = mkkN "kantri" ;
lin kanttarelli_N = mkkN "kanttarelli" ;
lin kanttaus_N = mkkN "kanttaus" ;
lin kantti_N = mkkN "kantti" ;
lin kanttiini_N = mkkN "kanttiini" ;
lin kanttori_N = mkkN "kanttori" ;
lin kanttura_N = mkkN "kanttura" ;
lin kanttuvei_Adv = mkkAdv "kanttuvei" ;
lin kanukka_N = mkkN "kanukka" ;
lin kanuuna_N = mkkN "kanuuna" ;
lin kanveesi_N = mkkN "kanveesi" ;
lin kanyloida_V = mkkV "kanyloida" ;
lin kanyyli_N = mkkN "kanyyli" ;
lin kaoliini_N = mkkN "kaoliini" ;
lin kaoottinen_A = mkkA "kaoottinen" ;
lin kaoottisesti_Adv = mkkAdv "kaoottisesti" ;
lin kapaista_V = mkkV "kapaista" ;
lin kapakka_N = mkkN "kapakka" ;
lin kapakoitsija_N = mkkN "kapakoitsija" ;
lin kapallinen_N = mkkN "kapallinen" ;
lin kapalo_N = mkkN "kapalo" ;
lin kapaloida_V = mkkV "kapaloida" ;
lin kapalointi_N = mkkN "kapalointi" ;
lin kapasitanssi_N = mkkN "kapasitanssi" ;
lin kapasiteetti_N = mkkN "kapasiteetti" ;
lin kapea_A = mkkA "kapea" ;
lin kapeasti_Adv = mkkAdv "kapeasti" ;
lin kapeikko_N = mkkN "kapeikko" ;
lin kapeikkoinen_N = mkkN "kapeikkoinen" ;
lin kapeus_N = mkkN "kapeus" ;
lin kapeuttaa_V = mkkV "kapeuttaa" ;
lin kapeutua_V = mkkV "kapeutua" ;
lin kapi_N = mkkN "kapi" ;
lin kapiainen_N = mkkN "kapiainen" ;
lin kapillaari_N = mkkN "kapillaari" ;
lin kapillaarinen_A = mkkA "kapillaarinen" ;
lin kapillaarisesti_Adv = mkkAdv "kapillaarisesti" ;
lin kapillaarisuus_N = mkkN "kapillaarisuus" ;
lin kapina_N = mkkN "kapina" ;
lin kapinallinen_N = mkkN "kapinallinen" ;
lin kapinallisuus_N = mkkN "kapinallisuus" ;
lin kapine_N = mkkN "kapine" ;
lin kapinen_N = mkkN "kapinen" ;
lin kapinoida_V = mkkV "kapinoida" ;
lin kapinoija_N = mkkN "kapinoija" ;
lin kapinointi_N = mkkN "kapinointi" ;
lin kapinoitsija_N = mkkN "kapinoitsija" ;
--? lin kapiot_NK = {s = d03 "kapiot" ;
lin kapistus_N = mkkN "kapistus" ;
lin kapitaali_N = mkkN "kapitaali" ;
lin kapitalismi_N = mkkN "kapitalismi" ;
lin kapitalisoida_V = mkkV "kapitalisoida" ;
lin kapitalisointi_N = mkkN "kapitalisointi" ;
lin kapitalisti_N = mkkN "kapitalisti" ;
lin kapitalistinen_N = mkkN "kapitalistinen" ;
lin kapitaloida_V = mkkV "kapitaloida" ;
lin kapitalointi_N = mkkN "kapitalointi" ;
lin kapiteeli_N = mkkN "kapiteeli" ;
lin kapiteloida_V = mkkV "kapiteloida" ;
lin kapitulantti_N = mkkN "kapitulantti" ;
lin kaplas_N = mkkN "kaplas" ;
lin kaplastaa_V = mkkV "kaplastaa" ;
lin kapoinen_N = mkkN "kapoinen" ;
lin kapoittain_Adv = mkkAdv "kapoittain" ;
lin kapokki_N = mkkN "kapokki" ;
lin kappa_1_N = mkkN "kappa" ;
lin kappa_2_N = mkkN "kappa" ;
lin kappa_3_N = mkkN "kappa" ;
lin kappale_N = mkkN "kappale" ;
lin kappaleittain_Adv = mkkAdv "kappaleittain" ;
lin kappaleittainen_N = mkkN "kappaleittainen" ;
lin kappas_Adv = mkkAdv "kappas" ;
lin kappeli_N = mkkN "kappeli" ;
lin kappi_N = mkkN "kappi" ;
lin kapriisi_N = mkkN "kapriisi" ;
lin kapris_N = mkkN "kapris" ;
lin kapsaa_V = mkkV "kapsaa" ;
lin kapsahdella_V = mkkV "kapsahdella" ;
lin kapsahdus_N = mkkN "kapsahdus" ;
lin kapsahtaa_V = mkkV "kapsahtaa" ;
lin kapsahtelu_N = mkkN "kapsahtelu" ;
lin kapse_N = mkkN "kapse" ;
lin kapsehtia_V = mkkV "kapsehtia" ;
lin kapsekki_N = mkkN "kapsekki" ;
lin kapseli_N = mkkN "kapseli" ;
lin kapseloida_V = mkkV "kapseloida" ;
lin kapseloitua_V = mkkV "kapseloitua" ;
lin kapsyyli_N = mkkN "kapsyyli" ;
lin kapsa'kki_N = mkkN "kapsäkki" ;
lin kapteeni_N = mkkN "kapteeni" ;
lin kapula_N = mkkN "kapula" ;
lin kapuloida_V = mkkV "kapuloida" ;
lin kapusiini_N = mkkN "kapusiini" ;
lin kapusta_N = mkkN "kapusta" ;
lin kaput_Adv = mkkAdv "kaput" ;
lin kara_N = mkkN "kara" ;
lin karaatti_N = mkkN "karaatti" ;
lin karaattinen_N = mkkN "karaattinen" ;
lin karabiini_N = mkkN "karabiini" ;
lin karabinieeri_N = mkkN "karabinieeri" ;
lin karahdella_V = mkkV "karahdella" ;
lin karahdus_N = mkkN "karahdus" ;
lin karahka_N = mkkN "karahka" ;
lin karahtaa_V = mkkV "karahtaa" ;
lin karahteerata_V = mkkV "karahteerata" ;
lin karahvi_N = mkkN "karahvi" ;
lin karaista_1_V = mkkV "karaista" ;
lin karaista_2_V = mkkV "karaista" ;
lin karaistua_V = mkkV "karaistua" ;
lin karaisu_N = mkkN "karaisu" ;
lin karakteri_N = mkkN "karakteri" ;
lin karakterisoida_V = mkkV "karakterisoida" ;
lin karakteristiikka_N = mkkN "karakteristiikka" ;
lin karakteristika_N = mkkN "karakteristika" ;
lin karakteristinen_N = mkkN "karakteristinen" ;
lin karakteristisuus_N = mkkN "karakteristisuus" ;
lin karakta'a'ri_N = mkkN "karaktääri" ;
lin karambola_N = mkkN "karambola" ;
lin karamelli_N = mkkN "karamelli" ;
lin karanteeni_N = mkkN "karanteeni" ;
lin karaoke_N = mkkN "karaoke" ;
lin karata_V = mkkV "karata" ;
lin karate_N = mkkN "karate" ;
lin karateka_N = mkkN "karateka" ;
lin karautella_V = mkkV "karautella" ;
lin karauttaa_V = mkkV "karauttaa" ;
lin karavaanari_N = mkkN "karavaanari" ;
lin karavaani_N = mkkN "karavaani" ;
lin karbidi_N = mkkN "karbidi" ;
lin karbiini_N = mkkN "karbiini" ;
lin karbonaatti_N = mkkN "karbonaatti" ;
lin kardaani_N = mkkN "kardaani" ;
lin kardaaninen_N = mkkN "kardaaninen" ;
lin kardemumma_N = mkkN "kardemumma" ;
lin kardinaali_N = mkkN "kardinaali" ;
lin kardiologi_N = mkkN "kardiologi" ;
lin kardiologia_N = mkkN "kardiologia" ;
lin kardiologinen_N = mkkN "kardiologinen" ;
lin kardoni_N = mkkN "kardoni" ;
lin kare_N = mkkN "kare" ;
lin karehtia_V = mkkV "karehtia" ;
lin kareilla_V = mkkV "kareilla" ;
lin kareilu_N = mkkN "kareilu" ;
lin karelianismi_N = mkkN "karelianismi" ;
lin karenssi_N = mkkN "karenssi" ;
lin karenssiaika_N = mkkN "karenssiaika" ;
lin karhe_N = mkkN "karhe" ;
lin karhea_A = mkkA "karhea" ;
lin karheasti_Adv = mkkAdv "karheasti" ;
lin karheikko_N = mkkN "karheikko" ;
lin karhenne_N = mkkN "karhenne" ;
lin karhennos_N = mkkN "karhennos" ;
lin karhennus_N = mkkN "karhennus" ;
lin karhentaa_V = mkkV "karhentaa" ;
lin karhentua_V = mkkV "karhentua" ;
lin karheta_V = mkkV "karheta" ;
lin karheus_N = mkkN "karheus" ;
lin karheuttaa_V = mkkV "karheuttaa" ;
lin karheutua_V = mkkV "karheutua" ;
lin karhi_N = mkkN "karhi" ;
lin karhiainen_N = mkkN "karhiainen" ;
lin karhinta_N = mkkN "karhinta" ;
lin karhita_V = mkkV "karhita" ;
lin karho_N = mkkN "karho" ;
lin karhu_N = mkkN "karhu" ;
lin karhuaja_N = mkkN "karhuaja" ;
lin karhukainen_N = mkkN "karhukainen" ;
lin karhunkoppi_N = mkkN "karhunkoppi" ;
lin karhuntalja_N = mkkN "karhuntalja" ;
lin karhuta_V = mkkV "karhuta" ;
lin kari_N = mkkN "kari" ;
lin karibu_N = mkkN "karibu" ;
lin karies_N = mkkN "karies" ;
lin karikatyyri_N = mkkN "karikatyyri" ;
lin karike_N = mkkN "karike" ;
lin karikko_N = mkkN "karikko" ;
lin karikkoinen_N = mkkN "karikkoinen" ;
lin karikkoisuus_N = mkkN "karikkoisuus" ;
lin karikoida_V = mkkV "karikoida" ;
lin karinen_N = mkkN "karinen" ;
lin karioitua_V = mkkV "karioitua" ;
lin karioottinen_N = mkkN "karioottinen" ;
lin karioottisuus_N = mkkN "karioottisuus" ;
lin karisma_N = mkkN "karisma" ;
lin karismaattinen_N = mkkN "karismaattinen" ;
lin karista_V = mkkV "karista" ;
lin karistaa_V = mkkV "karistaa" ;
lin kariste_N = mkkN "kariste" ;
lin karistella_V = mkkV "karistella" ;
lin karistelu_N = mkkN "karistelu" ;
lin karistus_N = mkkN "karistus" ;
lin karisuttaa_V = mkkV "karisuttaa" ;
lin karisuus_N = mkkN "karisuus" ;
lin karitsa_N = mkkN "karitsa" ;
lin karitsanvilla_N = mkkN "karitsanvilla" ;
lin karitsoida_V = mkkV "karitsoida" ;
lin karitsoittaa_V = mkkV "karitsoittaa" ;
lin kariuttaa_V = mkkV "kariuttaa" ;
lin kariutua_V = mkkV "kariutua" ;
lin karja_N = mkkN "karja" ;
lin karja_aura_N = mkkN "karja-aura" ;
lin karjahdella_V = mkkV "karjahdella" ;
lin karjahdus_N = mkkN "karjahdus" ;
lin karjahtaa_V = mkkV "karjahtaa" ;
lin karjaista_V = mkkV "karjaista" ;
lin karjaisu_N = mkkN "karjaisu" ;
lin karjakko_N = mkkN "karjakko" ;
lin karjala_N = mkkN "karjala" ;
lin karjalaisittain_Adv = mkkAdv "karjalaisittain" ;
lin karjalaisuus_N = mkkN "karjalaisuus" ;
lin karjaton_N = mkkN "karjaton" ;
lin karjeta_V = mkkV "karjeta" ;
lin karju_N = mkkN "karju" ;
lin karjua_V = mkkV "karjua" ;
lin karjunta_N = mkkN "karjunta" ;
lin karkailla_V = mkkV "karkailla" ;
lin karkailu_N = mkkN "karkailu" ;
lin karkaisematon_N = mkkN "karkaisematon" ;
lin karkaisija_N = mkkN "karkaisija" ;
lin karkaisimo_N = mkkN "karkaisimo" ;
lin karkaista_V = mkkV "karkaista" ;
lin karkaistua_V = mkkV "karkaistua" ;
lin karkaisu_N = mkkN "karkaisu" ;
lin karkaus_N = mkkN "karkaus" ;
lin karkea_A = mkkA "karkea" ;
lin karkeasti_Adv = mkkAdv "karkeasti" ;
lin karkeistaa_V = mkkV "karkeistaa" ;
lin karkeistae_N = mkkN "karkeistae" ;
lin karkeistus_N = mkkN "karkeistus" ;
lin karkelo_N = mkkN "karkelo" ;
lin karkeloida_V = mkkV "karkeloida" ;
lin karkelointi_N = mkkN "karkelointi" ;
lin karkenee_V = mkkV "karkenee" ;
lin karkeus_N = mkkN "karkeus" ;
lin karkeuttaa_V = mkkV "karkeuttaa" ;
lin karkeutua_V = mkkV "karkeutua" ;
lin karkki_N = mkkN "karkki" ;
lin karkota_V = mkkV "karkota" ;
lin karkote_N = mkkN "karkote" ;
lin karkottaa_V = mkkV "karkottaa" ;
lin karkotus_N = mkkN "karkotus" ;
lin karku_Adv = mkkAdv "karku" ;
lin karkuri_N = mkkN "karkuri" ;
lin karkuruus_N = mkkN "karkuruus" ;
lin karkuteille_Adv = mkkAdv "karkuteille" ;
lin karkuteilla'_Adv = mkkAdv "karkuteillä" ;
lin karkuteilta'_Adv = mkkAdv "karkuteiltä" ;
lin karkuun_Adv = mkkAdv "karkuun" ;
lin karma_N = mkkN "karma" ;
lin karmaiseva_N = mkkN "karmaiseva" ;
lin karmaista_V = mkkV "karmaista" ;
lin karmea_A = mkkA "karmea" ;
lin karmeasti_Adv = mkkAdv "karmeasti" ;
lin karmeliitta_N = mkkN "karmeliitta" ;
lin karmeus_N = mkkN "karmeus" ;
lin karmi_N = mkkN "karmi" ;
lin karmia_V = mkkV "karmia" ;
lin karmiini_N = mkkN "karmiini" ;
lin karmiva_N = mkkN "karmiva" ;
lin karneoli_N = mkkN "karneoli" ;
lin karnevaali_N = mkkN "karnevaali" ;
lin karnevaaliaika_N = mkkN "karnevaaliaika" ;
lin karnevalisoida_V = mkkV "karnevalisoida" ;
lin karnevalisointi_N = mkkN "karnevalisointi" ;
lin karnevalisoitua_V = mkkV "karnevalisoitua" ;
lin karoliini_N = mkkN "karoliini" ;
lin karoliininen_N = mkkN "karoliininen" ;
lin karolingi_N = mkkN "karolingi" ;
lin karolinginen_N = mkkN "karolinginen" ;
lin karonkka_N = mkkN "karonkka" ;
lin karoteeni_N = mkkN "karoteeni" ;
lin karpaasi_N = mkkN "karpaasi" ;
lin karpalo_N = mkkN "karpalo" ;
lin karppi_N = mkkN "karppi" ;
lin karrella_Adv = mkkAdv "karrella" ;
lin karrelle_Adv = mkkAdv "karrelle" ;
lin karri_N = mkkN "karri" ;
lin karrieeri_N = mkkN "karrieeri" ;
lin karrieristi_N = mkkN "karrieristi" ;
lin karrikatyyri_N = mkkN "karrikatyyri" ;
lin karrikoida_V = mkkV "karrikoida" ;
lin karrikointi_N = mkkN "karrikointi" ;
lin karsaasti_Adv = mkkAdv "karsaasti" ;
lin karsas_A = mkkA "karsas" ;
lin karsastaa_V = mkkV "karsastaa" ;
lin karsastus_N = mkkN "karsastus" ;
lin karsaus_N = mkkN "karsaus" ;
lin karsea_N = mkkN "karsea" ;
lin karsi_N = mkkN "karsi" ;
lin karsia_V = mkkV "karsia" ;
lin karsiintua_V = mkkV "karsiintua" ;
lin karsija_N = mkkN "karsija" ;
lin karsikko_N = mkkN "karsikko" ;
lin karsina_N = mkkN "karsina" ;
lin karsinogeeni_N = mkkN "karsinogeeni" ;
lin karsinogeeninen_N = mkkN "karsinogeeninen" ;
lin karsinogeenisuus_N = mkkN "karsinogeenisuus" ;
lin karsinoida_V = mkkV "karsinoida" ;
lin karsinointi_N = mkkN "karsinointi" ;
lin karsinoitua_V = mkkV "karsinoitua" ;
lin karsinooma_N = mkkN "karsinooma" ;
lin karsinta_N = mkkN "karsinta" ;
lin karsiutua_V = mkkV "karsiutua" ;
lin karski_A = mkkA "karski" ;
lin karskisti_Adv = mkkAdv "karskisti" ;
lin karskius_N = mkkN "karskius" ;
lin karsta_1_N = mkkN "karsta" ;
lin karsta_2_N = mkkN "karsta" ;
lin karstaaja_N = mkkN "karstaaja" ;
lin karstaamo_N = mkkN "karstaamo" ;
lin karstaantua_1_V = mkkV "karstaantua" ;
lin karstaantua_2_V = mkkV "karstaantua" ;
lin karstainen_N = mkkN "karstainen" ;
lin karstata_V = mkkV "karstata" ;
lin karstaus_N = mkkN "karstaus" ;
lin karstautua_1_V = mkkV "karstautua" ;
lin karstautua_2_V = mkkV "karstautua" ;
lin karsti_N = mkkN "karsti" ;
lin karstoittua_V = mkkV "karstoittua" ;
lin kartano_N = mkkN "kartano" ;
lin kartasto_N = mkkN "kartasto" ;
lin kartella_V = mkkV "kartella" ;
lin kartelli_N = mkkN "kartelli" ;
lin kartelloitua_V = mkkV "kartelloitua" ;
lin karting_N = mkkN "karting" ;
lin kartio_N = mkkN "kartio" ;
lin kartiokas_N = mkkN "kartiokas" ;
lin kartografia_N = mkkN "kartografia" ;
lin kartografinen_A = mkkA "kartografinen" ;
lin kartografisesti_Adv = mkkAdv "kartografisesti" ;
lin kartogrammi_N = mkkN "kartogrammi" ;
lin kartoitin_N = mkkN "kartoitin" ;
lin kartoittaa_V = mkkV "kartoittaa" ;
lin kartoittaja_N = mkkN "kartoittaja" ;
lin kartoitus_N = mkkN "kartoitus" ;
lin kartonki_N = mkkN "kartonki" ;
lin kartta_N = mkkN "kartta" ;
lin karttaa_V = mkkV "karttaa" ;
lin karttelu_N = mkkN "karttelu" ;
lin karttu_N = mkkN "karttu" ;
lin karttua_V = mkkV "karttua" ;
lin karttuisa_N = mkkN "karttuisa" ;
lin kartturi_N = mkkN "kartturi" ;
lin karttusilla_Adv = mkkAdv "karttusilla" ;
lin kartunta_N = mkkN "kartunta" ;
lin kartusiaani_N = mkkN "kartusiaani" ;
lin kartuttaa_V = mkkV "kartuttaa" ;
lin kartutus_N = mkkN "kartutus" ;
lin karu_A = mkkA "karu" ;
lin karukko_N = mkkN "karukko" ;
lin karussa_Adv = mkkAdv "karussa" ;
lin karusti_Adv = mkkAdv "karusti" ;
lin karuuntua_V = mkkV "karuuntua" ;
lin karuus_N = mkkN "karuus" ;
lin karva_N = mkkN "karva" ;
lin karvaasti_Adv = mkkAdv "karvaasti" ;
lin karvainen_N = mkkN "karvainen" ;
lin karvainen_N = mkkN "karvainen" ;
lin karvaisuus_N = mkkN "karvaisuus" ;
lin karvallinen_N = mkkN "karvallinen" ;
lin karvanjuuri_N = mkkN "karvanjuuri" ;
lin karvari_N = mkkN "karvari" ;
lin karvas_A = mkkA "karvas" ;
lin karvastella_V = mkkV "karvastella" ;
lin karvastelu_N = mkkN "karvastelu" ;
lin karvasto_N = mkkN "karvasto" ;
lin karvata_V = mkkV "karvata" ;
lin karvaus_1_N = mkkN "karvaus" ;
lin karvaus_2_N = mkkN "karvaus" ;
lin karve_N = mkkN "karve" ;
lin karviainen_N = mkkN "karviainen" ;
lin karvoa_V = mkkV "karvoa" ;
lin karvoittua_V = mkkV "karvoittua" ;
lin karvoitus_N = mkkN "karvoitus" ;
lin kas_Adv = mkkAdv "kas" ;
lin kasa_N = mkkN "kasa" ;
lin kasaantua_V = mkkV "kasaantua" ;
lin kasaantuma_N = mkkN "kasaantuma" ;
lin kasailla_V = mkkV "kasailla" ;
lin kasapa'issa'_Adv = mkkAdv "kasapäissä" ;
lin kasari_N = mkkN "kasari" ;
lin kasarmi_N = mkkN "kasarmi" ;
lin kasata_V = mkkV "kasata" ;
lin kasauma_N = mkkN "kasauma" ;
lin kasautua_V = mkkV "kasautua" ;
lin kasautuma_N = mkkN "kasautuma" ;
lin kaseerata_V = mkkV "kaseerata" ;
lin kaseeraus_N = mkkN "kaseeraus" ;
lin kaseiini_N = mkkN "kaseiini" ;
lin kasematti_N = mkkN "kasematti" ;
lin kasetoida_V = mkkV "kasetoida" ;
lin kasetointi_N = mkkN "kasetointi" ;
lin kasetti_N = mkkN "kasetti" ;
lin kasi_N = mkkN "kasi" ;
lin kasiainen_N = mkkN "kasiainen" ;
lin kasino_N = mkkN "kasino" ;
lin kaskas_N = mkkN "kaskas" ;
lin kaskelotti_N = mkkN "kaskelotti" ;
lin kasketa_V = mkkV "kasketa" ;
lin kaski_N = mkkN "kaski" ;
lin kasko_N = mkkN "kasko" ;
lin kasku_N = mkkN "kasku" ;
lin kasleri_N = mkkN "kasleri" ;
lin ka_mir_N = mkkN "kašmir" ;
lin ka_miri_N = mkkN "kašmiri" ;
lin ka_mirvilla_N = mkkN "kašmirvilla" ;
lin kasoittain_Adv = mkkAdv "kasoittain" ;
lin kassa_N = mkkN "kassa" ;
lin kassi_N = mkkN "kassi" ;
lin kassler_N = mkkN "kassler" ;
lin kastaa_V = mkkV "kastaa" ;
--? lin kastajaiset_NK = {s = d38 "kastajaiset" ;
lin kastanja_N = mkkN "kastanja" ;
lin kastanjetit_N = mkkN "kastanjetit" ;
lin kastattaa_V = mkkV "kastattaa" ;
lin kastautua_V = mkkV "kastautua" ;
lin kaste_N = mkkN "kaste" ;
lin kastella_V = mkkV "kastella" ;
lin kastelli_N = mkkN "kastelli" ;
lin kastelu_N = mkkN "kastelu" ;
lin kasti_1_N = mkkN "kasti" ;
lin kasti_2_N = mkkN "kasti" ;
lin kastikas_N = mkkN "kastikas" ;
lin kastike_N = mkkN "kastike" ;
lin kastraatio_N = mkkN "kastraatio" ;
lin kastraatti_N = mkkN "kastraatti" ;
lin kastroida_V = mkkV "kastroida" ;
lin kastrointi_N = mkkN "kastrointi" ;
lin kastua_V = mkkV "kastua" ;
lin kasuaari_N = mkkN "kasuaari" ;
lin kasuistiikka_N = mkkN "kasuistiikka" ;
lin kasuistinen_N = mkkN "kasuistinen" ;
lin kasukka_N = mkkN "kasukka" ;
lin kasvaa_V = mkkV "kasvaa" ;
lin kasvain_N = mkkN "kasvain" ;
lin kasvannainen_N = mkkN "kasvannainen" ;
lin kasvanta_N = mkkN "kasvanta" ;
lin kasvattaa_V = mkkV "kasvattaa" ;
lin kasvattaja_N = mkkN "kasvattaja" ;
lin kasvattamo_N = mkkN "kasvattamo" ;
lin kasvatuksellinen_N = mkkN "kasvatuksellinen" ;
lin kasvatus_N = mkkN "kasvatus" ;
lin kasvettua_V = mkkV "kasvettua" ;
lin kasvettuma_N = mkkN "kasvettuma" ;
lin kasvi_N = mkkN "kasvi" ;
lin kasvillisuus_N = mkkN "kasvillisuus" ;
lin kasvio_N = mkkN "kasvio" ;
lin kasvis_N = mkkN "kasvis" ;
lin kasvisto_N = mkkN "kasvisto" ;
lin kasvittaa_V = mkkV "kasvittaa" ;
lin kasvittua_V = mkkV "kasvittua" ;
lin kasvo_N = mkkN "kasvo" ;
lin kasvokkain_Adv = mkkAdv "kasvokkain" ;
--? lin kasvot_NK = {s = d01 "kasvot" ;
lin kasvoton_N = mkkN "kasvoton" ;
lin kasvottomuus_N = mkkN "kasvottomuus" ;
lin kasvotuksin_Adv = mkkAdv "kasvotuksin" ;
lin kasvotusten_Adv = mkkAdv "kasvotusten" ;
lin kasvu_N = mkkN "kasvu" ;
lin kasvuaika_N = mkkN "kasvuaika" ;
lin kasvuinen_N = mkkN "kasvuinen" ;
lin kasvuisuus_N = mkkN "kasvuisuus" ;
lin kasvullinen_N = mkkN "kasvullinen" ;
lin kasvullisuus_N = mkkN "kasvullisuus" ;
lin kasvusto_N = mkkN "kasvusto" ;
lin katafalkki_N = mkkN "katafalkki" ;
lin kataja_N = mkkN "kataja" ;
lin katajainen_N = mkkN "katajainen" ;
lin katajikko_N = mkkN "katajikko" ;
lin katajisto_N = mkkN "katajisto" ;
lin katakombi_N = mkkN "katakombi" ;
lin katala_A = mkkA "katala" ;
lin katalaani_N = mkkN "katalaani" ;
lin katalasti_Adv = mkkAdv "katalasti" ;
lin katalonia_N = mkkN "katalonia" ;
lin kataluus_N = mkkN "kataluus" ;
lin katalysaattori_N = mkkN "katalysaattori" ;
lin katalysoida_V = mkkV "katalysoida" ;
lin katalyysi_N = mkkN "katalyysi" ;
lin katalyytti_N = mkkN "katalyytti" ;
lin katalyyttinen_N = mkkN "katalyyttinen" ;
lin katamaraani_N = mkkN "katamaraani" ;
lin katapultti_N = mkkN "katapultti" ;
lin katarri_N = mkkN "katarri" ;
lin katarsis_N = mkkN "katarsis" ;
lin katastrofaalinen_N = mkkN "katastrofaalinen" ;
lin katastrofi_N = mkkN "katastrofi" ;
lin kate_N = mkkN "kate" ;
lin katedraali_N = mkkN "katedraali" ;
lin kateederi_N = mkkN "kateederi" ;
lin kateeksi_Adv = mkkAdv "kateeksi" ;
lin kateellinen_N = mkkN "kateellinen" ;
lin kateellisuus_N = mkkN "kateellisuus" ;
lin kateetti_N = mkkN "kateetti" ;
lin kategoria_N = mkkN "kategoria" ;
lin kategorinen_A = mkkA "kategorinen" ;
lin kategorisesti_Adv = mkkAdv "kategorisesti" ;
lin kategorisuus_N = mkkN "kategorisuus" ;
lin kateisiin_Adv = mkkAdv "kateisiin" ;
lin kateissa_Adv = mkkAdv "kateissa" ;
lin kateissaan_Adv = mkkAdv "kateissaan" ;
lin katekeetta_N = mkkN "katekeetta" ;
lin katekismus_N = mkkN "katekismus" ;
lin katerpillari_N = mkkN "katerpillari" ;
lin katetri_N = mkkN "katetri" ;
lin katetroida_V = mkkV "katetroida" ;
lin katetrointi_N = mkkN "katetrointi" ;
lin kateus_N = mkkN "kateus" ;
lin katgutti_N = mkkN "katgutti" ;
lin kationi_N = mkkN "kationi" ;
lin katiska_N = mkkN "katiska" ;
lin katka_N = mkkN "katka" ;
lin katkaisija_N = mkkN "katkaisija" ;
lin katkaisin_N = mkkN "katkaisin" ;
lin katkaista_V = mkkV "katkaista" ;
lin katkaisu_N = mkkN "katkaisu" ;
lin katkaisukohta_N = mkkN "katkaisukohta" ;
lin katkeama_N = mkkN "katkeama" ;
lin katkeamaton_N = mkkN "katkeamaton" ;
lin katkeamiskohta_N = mkkN "katkeamiskohta" ;
lin katkeilla_V = mkkV "katkeilla" ;
lin katkelma_N = mkkN "katkelma" ;
lin katkelmallinen_N = mkkN "katkelmallinen" ;
lin katkelmallisuus_N = mkkN "katkelmallisuus" ;
lin katkera_A = mkkA "katkera" ;
lin katkerasti_Adv = mkkAdv "katkerasti" ;
lin katkero_N = mkkN "katkero" ;
lin katkeroittaa_V = mkkV "katkeroittaa" ;
lin katkeroitua_V = mkkV "katkeroitua" ;
lin katkeruus_N = mkkN "katkeruus" ;
lin katketa_V = mkkV "katketa" ;
lin katki_Adv = mkkAdv "katki" ;
lin katkismus_N = mkkN "katkismus" ;
lin katko_1_N = mkkN "katko" ;
lin katko_2_N = mkkN "katko" ;
lin katkoa_V = mkkV "katkoa" ;
lin katkoja_N = mkkN "katkoja" ;
lin katkola_N = mkkN "katkola" ;
lin katkonaisesti_Adv = mkkAdv "katkonaisesti" ;
lin katkonta_N = mkkN "katkonta" ;
lin katkos_N = mkkN "katkos" ;
lin katku_N = mkkN "katku" ;
lin katkuinen_N = mkkN "katkuinen" ;
lin kato_N = mkkN "kato" ;
lin katoamaton_N = mkkN "katoamaton" ;
lin katoamattomuus_N = mkkN "katoamattomuus" ;
lin katoava_N = mkkN "katoava" ;
lin katoavainen_N = mkkN "katoavainen" ;
lin katoavaisuus_N = mkkN "katoavaisuus" ;
lin katoavuus_N = mkkN "katoavuus" ;
lin katodi_N = mkkN "katodi" ;
lin katoksellinen_N = mkkN "katoksellinen" ;
lin katolilainen_N = mkkN "katolilainen" ;
lin katolilaisuus_N = mkkN "katolilaisuus" ;
lin katolinen_N = mkkN "katolinen" ;
lin katolisuus_N = mkkN "katolisuus" ;
lin katollinen_N = mkkN "katollinen" ;
lin katonraja_N = mkkN "katonraja" ;
lin katos_N = mkkN "katos" ;
lin katras_N = mkkN "katras" ;
lin katrilli_N = mkkN "katrilli" ;
lin katsahdus_N = mkkN "katsahdus" ;
lin katsahtaa_V = mkkV "katsahtaa" ;
lin katsanto_N = mkkN "katsanto" ;
lin katsastaa_V = mkkV "katsastaa" ;
lin katsastaja_N = mkkN "katsastaja" ;
lin katsastamaton_N = mkkN "katsastamaton" ;
lin katsastus_N = mkkN "katsastus" ;
lin katsastuttaa_V = mkkV "katsastuttaa" ;
lin katsaus_N = mkkN "katsaus" ;
lin katse_N = mkkN "katse" ;
lin katseinen_N = mkkN "katseinen" ;
lin katseisuus_N = mkkN "katseisuus" ;
lin katselija_N = mkkN "katselija" ;
lin katsella_V = mkkV "katsella" ;
lin katselmus_N = mkkN "katselmus" ;
lin katselu_N = mkkN "katselu" ;
lin katsoa_V = mkkV "katsoa" ;
lin katsoja_N = mkkN "katsoja" ;
--? lin katsojaiset_NK = {s = d38 "katsojaiset" ;
lin katsoma_N = mkkN "katsoma" ;
lin katsomo_N = mkkN "katsomo" ;
lin katsomus_N = mkkN "katsomus" ;
lin katsonta_N = mkkN "katsonta" ;
lin kattaa_V = mkkV "kattaa" ;
lin kattamus_N = mkkN "kattamus" ;
lin kattara_N = mkkN "kattara" ;
lin katteeton_N = mkkN "katteeton" ;
lin katteikko_N = mkkN "katteikko" ;
lin katteinen_N = mkkN "katteinen" ;
lin katti_N = mkkN "katti" ;
lin kattila_N = mkkN "kattila" ;
lin kattilallinen_N = mkkN "kattilallinen" ;
lin katto_N = mkkN "katto" ;
lin kattoinen_N = mkkN "kattoinen" ;
lin katu_N = mkkN "katu" ;
lin katua_V = mkkV "katua" ;
lin katumus_N = mkkN "katumus" ;
lin katuvainen_N = mkkN "katuvainen" ;
lin katve_N = mkkN "katve" ;
lin katveikko_N = mkkN "katveikko" ;
lin katveinen_N = mkkN "katveinen" ;
lin kauaksi_Adv = mkkAdv "kauaksi" ;
lin kauan_Adv = mkkAdv "kauan" ;
lin kauas_Adv = mkkAdv "kauas" ;
lin kauaskantava_N = mkkN "kauaskantava" ;
lin kauemma_Adv = mkkAdv "kauemma" ;
lin kauemmaksi_Adv = mkkAdv "kauemmaksi" ;
lin kauemmas_Adv = mkkAdv "kauemmas" ;
lin kauemmin_Adv = mkkAdv "kauemmin" ;
lin kauempaa_Adv = mkkAdv "kauempaa" ;
lin kauempana_Adv = mkkAdv "kauempana" ;
lin kauha_N = mkkN "kauha" ;
lin kauhallinen_N = mkkN "kauhallinen" ;
lin kauhduttaa_V = mkkV "kauhduttaa" ;
lin kauhea_A = mkkA "kauhea" ;
lin kauheasti_Adv = mkkAdv "kauheasti" ;
lin kauheus_N = mkkN "kauheus" ;
lin kauhistaa_V = mkkV "kauhistaa" ;
lin kauhistella_V = mkkV "kauhistella" ;
lin kauhistua_V = mkkV "kauhistua" ;
lin kauhistus_N = mkkN "kauhistus" ;
lin kauhistuttaa_V = mkkV "kauhistuttaa" ;
lin kauhoa_V = mkkV "kauhoa" ;
lin kauhtana_N = mkkN "kauhtana" ;
lin kauhtua_V = mkkV "kauhtua" ;
lin kauhu_N = mkkN "kauhu" ;
lin kauhuissaan_Adv = mkkAdv "kauhuissaan" ;
lin kauimma_Adv = mkkAdv "kauimma" ;
lin kauimmainen_N = mkkN "kauimmainen" ;
lin kauimmaksi_Adv = mkkAdv "kauimmaksi" ;
lin kauimmas_Adv = mkkAdv "kauimmas" ;
lin kauimmin_Adv = mkkAdv "kauimmin" ;
lin kauimpaa_Adv = mkkAdv "kauimpaa" ;
lin kauimpana_Adv = mkkAdv "kauimpana" ;
lin kauintaan_Adv = mkkAdv "kauintaan" ;
lin kaukaa_Adv = mkkAdv "kaukaa" ;
lin kaukainen_N = mkkN "kaukainen" ;
lin kaukaisuus_N = mkkN "kaukaisuus" ;
lin kaukalo_N = mkkN "kaukalo" ;
lin kaukana_Adv = mkkAdv "kaukana" ;
lin kaukasialainen_N = mkkN "kaukasialainen" ;
lin kaukokantoinen_N = mkkN "kaukokantoinen" ;
lin kaukokatseisuus_N = mkkN "kaukokatseisuus" ;
lin kaukokulkeutuminen_N = mkkN "kaukokulkeutuminen" ;
lin kaukona'ko'isesti_Adv = mkkAdv "kaukonäköisesti" ;
lin kauko_ohjattu_N = mkkN "kauko-ohjattu" ;
lin kaukorakastuminen_N = mkkN "kaukorakastuminen" ;
lin kaula_N = mkkN "kaula" ;
lin kaulailla_V = mkkV "kaulailla" ;
lin kaulailu_N = mkkN "kaulailu" ;
lin kaulain_N = mkkN "kaulain" ;
lin kaulainen_N = mkkN "kaulainen" ;
lin kaulakkain_Adv = mkkAdv "kaulakkain" ;
lin kaulata_V = mkkV "kaulata" ;
lin kaulatuksin_Adv = mkkAdv "kaulatuksin" ;
lin kaulatusten_Adv = mkkAdv "kaulatusten" ;
lin kaulaus_N = mkkN "kaulaus" ;
lin kaulia_V = mkkV "kaulia" ;
lin kaulin_N = mkkN "kaulin" ;
lin kaulita_V = mkkV "kaulita" ;
lin kauluksinen_N = mkkN "kauluksinen" ;
lin kauluri_N = mkkN "kauluri" ;
lin kaulus_N = mkkN "kaulus" ;
lin kauna_N = mkkN "kauna" ;
lin kaunainen_N = mkkN "kaunainen" ;
lin kaunaisuus_N = mkkN "kaunaisuus" ;
lin kauneudellinen_N = mkkN "kauneudellinen" ;
lin kauneus_N = mkkN "kauneus" ;
lin kauniisti_Adv = mkkAdv "kauniisti" ;
lin kaunis_A = mkkA "kaunis" ;
lin kaunistaa_V = mkkV "kaunistaa" ;
lin kaunistautua_V = mkkV "kaunistautua" ;
lin kauniste_N = mkkN "kauniste" ;
lin kaunistelematon_N = mkkN "kaunistelematon" ;
lin kaunistella_V = mkkV "kaunistella" ;
lin kaunistelu_N = mkkN "kaunistelu" ;
lin kaunistua_V = mkkV "kaunistua" ;
lin kaunistus_N = mkkN "kaunistus" ;
lin kaunoinen_N = mkkN "kaunoinen" ;
lin kaunokainen_N = mkkN "kaunokainen" ;
lin kaunokki_N = mkkN "kaunokki" ;
lin kaunopuheisesti_Adv = mkkAdv "kaunopuheisesti" ;
lin kaunopuheisuus_N = mkkN "kaunopuheisuus" ;
lin kaunotar_N = mkkN "kaunotar" ;
lin kaupaksi_ka'yma'to'n_N = mkkN "kaupaksC" ;
lin kaupalla_Adv = mkkAdv "kaupalla" ;
lin kaupallinen_A = mkkA "kaupallinen" ;
lin kaupallisesti_Adv = mkkAdv "kaupallisesti" ;
lin kaupallistaa_V = mkkV "kaupallistaa" ;
lin kaupallistua_V = mkkV "kaupallistua" ;
lin kaupallisuus_N = mkkN "kaupallisuus" ;
lin kaupata_V = mkkV "kaupata" ;
lin kaupinta_N = mkkN "kaupinta" ;
lin kaupita_V = mkkV "kaupita" ;
lin kaupitella_V = mkkV "kaupitella" ;
lin kaupitsija_N = mkkN "kaupitsija" ;
lin kaupittaja_N = mkkN "kaupittaja" ;
lin kaupittelija_N = mkkN "kaupittelija" ;
lin kaupittelu_N = mkkN "kaupittelu" ;
lin kauppa_N = mkkN "kauppa" ;
lin kauppaaja_N = mkkN "kauppaaja" ;
lin kauppala_N = mkkN "kauppala" ;
lin kauppausanssi_N = mkkN "kauppausanssi" ;
lin kauppias_N = mkkN "kauppias" ;
lin kaupungeittain_Adv = mkkAdv "kaupungeittain" ;
lin kaupungistaa_V = mkkV "kaupungistaa" ;
lin kaupungistua_V = mkkV "kaupungistua" ;
lin kaupunki_N = mkkN "kaupunki" ;
lin kaupunkilaisesti_Adv = mkkAdv "kaupunkilaisesti" ;
lin kaupunkilaisittain_Adv = mkkAdv "kaupunkilaisittain" ;
lin kaupunkilaistua_V = mkkV "kaupunkilaistua" ;
lin kaupunkimaistaa_V = mkkV "kaupunkimaistaa" ;
lin kaupunkimaistua_V = mkkV "kaupunkimaistua" ;
lin kaupustelija_N = mkkN "kaupustelija" ;
lin kaupustella_V = mkkV "kaupustella" ;
lin kaupustelu_N = mkkN "kaupustelu" ;
lin kaura_N = mkkN "kaura" ;
lin kauris_N = mkkN "kauris" ;
lin kausaalilaki_N = mkkN "kausaalilaki" ;
lin kausaalinen_N = mkkN "kausaalinen" ;
lin kausaalisuus_N = mkkN "kausaalisuus" ;
lin kausaliteetti_N = mkkN "kausaliteetti" ;
lin kausi_N = mkkN "kausi" ;
lin kausittain_Adv = mkkAdv "kausittain" ;
lin kausittainen_N = mkkN "kausittainen" ;
lin kaustinen_N = mkkN "kaustinen" ;
lin kautinen_N = mkkN "kautinen" ;
lin kautsu_N = mkkN "kautsu" ;
lin kautta_Adv = mkkAdv "kautta" ;
lin kauttaaltaan_Adv = mkkAdv "kauttaaltaan" ;
lin kauttaaltainen_N = mkkN "kauttaaltainen" ;
lin kautta_rantain_Adv = mkkAdv "kauttC" ;
lin kavahtaa_V = mkkV "kavahtaa" ;
lin kavala_A = mkkA "kavala" ;
lin kavalasti_Adv = mkkAdv "kavalasti" ;
lin kavaljeeri_N = mkkN "kavaljeeri" ;
lin kavalkadi_N = mkkN "kavalkadi" ;
lin kavallus_N = mkkN "kavallus" ;
lin kavaltaa_V = mkkV "kavaltaa" ;
lin kavaltaja_N = mkkN "kavaltaja" ;
lin kavaluus_N = mkkN "kavaluus" ;
lin kaveerata_V = mkkV "kaveerata" ;
lin kavennus_N = mkkN "kavennus" ;
lin kaventaa_V = mkkV "kaventaa" ;
lin kaventua_V = mkkV "kaventua" ;
lin kaventuma_N = mkkN "kaventuma" ;
lin kaveri_N = mkkN "kaveri" ;
--? lin kaverukset_NK = {s = d39 "kaverukset" ;
lin kaveta_V = mkkV "kaveta" ;
lin kaviaari_N = mkkN "kaviaari" ;
lin kavio_N = mkkN "kavio" ;
lin kavuta_V = mkkV "kavuta" ;
lin kebab_N = mkkN "kebab" ;
lin keeppi_N = mkkN "keeppi" ;
lin kefalosporiini_N = mkkN "kefalosporiini" ;
lin kefiiri_N = mkkN "kefiiri" ;
lin kehaista_V = mkkV "kehaista" ;
lin kehaisu_N = mkkN "kehaisu" ;
lin kehdata_V = mkkV "kehdata" ;
lin kehikko_N = mkkN "kehikko" ;
lin kehite_N = mkkN "kehite" ;
lin kehitella'_V = mkkV "kehitellä" ;
lin kehitelma'_N = mkkN "kehitelmä" ;
lin kehitin_N = mkkN "kehitin" ;
lin kehitteille_Adv = mkkAdv "kehitteille" ;
lin kehitteilla'_Adv = mkkAdv "kehitteillä" ;
lin kehittelija'_N = mkkN "kehittelijä" ;
lin kehittely_N = mkkN "kehittely" ;
lin kehittyma'_N = mkkN "kehittymä" ;
lin kehittyma'tto'myys_N = mkkN "kehittymättömyys" ;
lin kehittyma'to'n_N = mkkN "kehittymätön" ;
lin kehittyneisyys_N = mkkN "kehittyneisyys" ;
lin kehittynyt_N = mkkN "kehittynyt" ;
lin kehittya'_V = mkkV "kehittyä" ;
lin kehitta'ja'_N = mkkN "kehittäjä" ;
lin kehitta'va'_N = mkkN "kehittävä" ;
lin kehitta'a'_V = mkkV "kehittää" ;
lin kehitys_N = mkkN "kehitys" ;
lin kehitytta'a'_V = mkkV "kehityttää" ;
lin kehia'_V = mkkV "kehiä" ;
lin kehjeta'_V = mkkV "kehjetä" ;
lin kehkeyma'_N = mkkN "kehkeymä" ;
lin kehkeytyma'_N = mkkN "kehkeytymä" ;
lin kehkeytya'_V = mkkV "kehkeytyä" ;
lin kehno_A = mkkA "kehno" ;
lin kehnontaa_V = mkkV "kehnontaa" ;
lin kehnontua_V = mkkV "kehnontua" ;
lin kehnosti_Adv = mkkAdv "kehnosti" ;
lin kehnota_V = mkkV "kehnota" ;
lin kehnous_N = mkkN "kehnous" ;
lin kehna'_N = mkkN "kehnä" ;
lin kehna'ta'_V = mkkV "kehnätä" ;
lin keho_N = mkkN "keho" ;
lin kehollinen_N = mkkN "kehollinen" ;
lin kehotella_V = mkkV "kehotella" ;
lin kehottaa_V = mkkV "kehottaa" ;
lin kehotus_N = mkkN "kehotus" ;
lin kehruu_N = mkkN "kehruu" ;
--? lin kehruukset_NK = {s = d39 "kehruukset" ;
lin kehruuttaa_V = mkkV "kehruuttaa" ;
lin kehra'_N = mkkN "kehrä" ;
lin kehra's_N = mkkN "kehräs" ;
lin kehra'ta'_V = mkkV "kehrätä" ;
lin kehra'ys_N = mkkN "kehräys" ;
lin kehra'ytta'a'_V = mkkV "kehräyttää" ;
lin kehra'a'ja'_N = mkkN "kehrääjä" ;
lin kehra'a'mo'_N = mkkN "kehräämö" ;
lin kehto_N = mkkN "kehto" ;
lin kehu_N = mkkN "kehu" ;
lin kehua_V = mkkV "kehua" ;
lin kehuja_N = mkkN "kehuja" ;
lin kehunta_N = mkkN "kehunta" ;
lin kehuskella_V = mkkV "kehuskella" ;
lin kehuskelu_N = mkkN "kehuskelu" ;
lin kehuttava_A = mkkA "kehuttava" ;
lin kehuttavasti_Adv = mkkAdv "kehuttavasti" ;
lin kehveli_N = mkkN "kehveli" ;
lin kehyksellinen_N = mkkN "kehyksellinen" ;
lin kehykseto'n_N = mkkN "kehyksetön" ;
lin kehyksinen_N = mkkN "kehyksinen" ;
lin kehys_N = mkkN "kehys" ;
lin kehyste_N = mkkN "kehyste" ;
lin kehystys_N = mkkN "kehystys" ;
lin kehysta'mo'_N = mkkN "kehystämö" ;
lin kehysta'a'_V = mkkV "kehystää" ;
lin keha'_N = mkkN "kehä" ;
lin keidas_N = mkkN "keidas" ;
lin keiha's_N = mkkN "keihäs" ;
lin keiha'sma'inen_N = mkkN "keihäsmäinen" ;
lin keiha'stys_N = mkkN "keihästys" ;
lin keiha'sta'a'_V = mkkV "keihästää" ;
lin keija_N = mkkN "keija" ;
lin keiju_N = mkkN "keiju" ;
lin keijukainen_N = mkkN "keijukainen" ;
lin keijusto_N = mkkN "keijusto" ;
lin keikahdus_N = mkkN "keikahdus" ;
lin keikahtaa_V = mkkV "keikahtaa" ;
lin keikailija_N = mkkN "keikailija" ;
lin keikailla_V = mkkV "keikailla" ;
lin keikailu_N = mkkN "keikailu" ;
lin keikari_N = mkkN "keikari" ;
lin keikaroida_V = mkkV "keikaroida" ;
lin keikaroija_N = mkkN "keikaroija" ;
lin keikarointi_N = mkkN "keikarointi" ;
lin keikaus_N = mkkN "keikaus" ;
lin keikauttaa_V = mkkV "keikauttaa" ;
lin keikistella'_V = mkkV "keikistellä" ;
lin keikistely_N = mkkN "keikistely" ;
lin keikista'a'_V = mkkV "keikistää" ;
lin keikka_N = mkkN "keikka" ;
lin keikkailla_V = mkkV "keikkailla" ;
lin keikkailu_N = mkkN "keikkailu" ;
lin keikkua_V = mkkV "keikkua" ;
lin keikunta_N = mkkN "keikunta" ;
lin keikutella_V = mkkV "keikutella" ;
lin keikuttaa_V = mkkV "keikuttaa" ;
lin keikuttelu_N = mkkN "keikuttelu" ;
lin keikutus_N = mkkN "keikutus" ;
lin keila_N = mkkN "keila" ;
lin keilaaja_N = mkkN "keilaaja" ;
lin keilailla_V = mkkV "keilailla" ;
lin keilailu_N = mkkN "keilailu" ;
lin keilata_V = mkkV "keilata" ;
lin keimailija_N = mkkN "keimailija" ;
lin keimailla_V = mkkV "keimailla" ;
lin keimailu_N = mkkN "keimailu" ;
lin keimit_N = mkkN "keimit" ;
lin keinahdella_V = mkkV "keinahdella" ;
lin keinahdus_N = mkkN "keinahdus" ;
lin keinahtaa_V = mkkV "keinahtaa" ;
lin keinauttaa_V = mkkV "keinauttaa" ;
lin keino_N = mkkN "keino" ;
lin keinollinen_N = mkkN "keinollinen" ;
lin keinotekoisesti_Adv = mkkAdv "keinotekoisesti" ;
lin keinotella_V = mkkV "keinotella" ;
lin keinottelija_N = mkkN "keinottelija" ;
lin keinottelu_N = mkkN "keinottelu" ;
lin keinu_N = mkkN "keinu" ;
lin keinua_V = mkkV "keinua" ;
lin keinunta_N = mkkN "keinunta" ;
lin keinutella_V = mkkV "keinutella" ;
lin keinuttaa_V = mkkV "keinuttaa" ;
lin keinutus_N = mkkN "keinutus" ;
lin keisari_N = mkkN "keisari" ;
lin keisariaika_N = mkkN "keisariaika" ;
lin keisarillinen_N = mkkN "keisarillinen" ;
lin keisarinna_N = mkkN "keisarinna" ;
lin keisarius_N = mkkN "keisarius" ;
lin keiso_N = mkkN "keiso" ;
lin keitella'_V = mkkV "keitellä" ;
lin keitin_N = mkkN "keitin" ;
lin keitos_N = mkkN "keitos" ;
lin keitraus_N = mkkN "keitraus" ;
lin keittimo'_N = mkkN "keittimö" ;
lin keittio'_N = mkkN "keittiö" ;
lin keitto_N = mkkN "keitto" ;
lin keittoaika_N = mkkN "keittoaika" ;
lin keittola_N = mkkN "keittola" ;
lin keittya'_V = mkkV "keittyä" ;
lin keitta'ja'_N = mkkN "keittäjä" ;
lin keitta'mo'_N = mkkN "keittämö" ;
lin keitta'a'_V = mkkV "keittää" ;
lin keita'tta'a'_V = mkkV "keitättää" ;
lin kekata_V = mkkV "kekata" ;
lin kekkale_N = mkkN "kekkale" ;
lin kekkaloida_V = mkkV "kekkaloida" ;
--? lin kekkerit_NK = {s = d06 "kekkerit" ;
lin kekkuli_N = mkkN "kekkuli" ;
lin kekkuloida_V = mkkV "kekkuloida" ;
lin keko_N = mkkN "keko" ;
lin kekri_N = mkkN "kekri" ;
lin keksaista_V = mkkV "keksaista" ;
lin kekselia'isyys_N = mkkN "kekseliäisyys" ;
lin kekselia's_A = mkkA "kekseliäs" ;
lin kekselia'a'sti_Adv = mkkAdv "kekseliäästi" ;
lin keksi_1_N = mkkN "keksi" ;
lin keksi_2_N = mkkN "keksi" ;
lin keksija'_N = mkkN "keksijä" ;
lin keksinto'_N = mkkN "keksintö" ;
lin keksia'_V = mkkV "keksiä" ;
lin keka'le_N = mkkN "kekäle" ;
lin kela_N = mkkN "kela" ;
lin kelastaa_V = mkkV "kelastaa" ;
lin kelastus_N = mkkN "kelastus" ;
lin kelata_V = mkkV "kelata" ;
lin kelaus_N = mkkN "kelaus" ;
lin kelautua_V = mkkV "kelautua" ;
lin keli_N = mkkN "keli" ;
lin keliaakikko_N = mkkN "keliaakikko" ;
lin keliakia_N = mkkN "keliakia" ;
lin kelirikkoinen_N = mkkN "kelirikkoinen" ;
lin kelju_A = mkkA "kelju" ;
lin keljuilija_N = mkkN "keljuilija" ;
lin keljuilla_V = mkkV "keljuilla" ;
lin keljuilu_N = mkkN "keljuilu" ;
lin keljumaisuus_N = mkkN "keljumaisuus" ;
lin keljusti_Adv = mkkAdv "keljusti" ;
lin keljuttaa_V = mkkV "keljuttaa" ;
lin keljuus_N = mkkN "keljuus" ;
lin kelkka_N = mkkN "kelkka" ;
lin kelkkailija_N = mkkN "kelkkailija" ;
lin kelkkailla_V = mkkV "kelkkailla" ;
lin kelkkailu_N = mkkN "kelkkailu" ;
lin kellahdella_V = mkkV "kellahdella" ;
lin kellahdus_N = mkkN "kellahdus" ;
lin kellahduttaa_V = mkkV "kellahduttaa" ;
lin kellahtaa_V = mkkV "kellahtaa" ;
lin kellahtava_N = mkkN "kellahtava" ;
lin kellari_N = mkkN "kellari" ;
lin kellaroida_V = mkkV "kellaroida" ;
lin kellarointi_N = mkkN "kellarointi" ;
lin kellastaa_V = mkkV "kellastaa" ;
lin kellastua_V = mkkV "kellastua" ;
lin kellastuttaa_V = mkkV "kellastuttaa" ;
lin kellata_V = mkkV "kellata" ;
lin kellauttaa_V = mkkV "kellauttaa" ;
lin kellelleen_Adv = mkkAdv "kellelleen" ;
lin kellella'a'n_Adv = mkkAdv "kellellään" ;
lin kellertya'_V = mkkV "kellertyä" ;
lin kellerta'va'_N = mkkN "kellertävä" ;
lin kellerta'a'_V = mkkV "kellertää" ;
lin kellerva'_N = mkkN "kellervä" ;
lin kellistya'_V = mkkV "kellistyä" ;
lin kellista'a'_V = mkkV "kellistää" ;
lin kellia'_V = mkkV "kelliä" ;
lin kello_N = mkkN "kello" ;
lin kelloaika_N = mkkN "kelloaika" ;
lin kellokas_N = mkkN "kellokas" ;
lin kellonaika_N = mkkN "kellonaika" ;
lin kellonlyo'ma'_N = mkkN "kellonlyömä" ;
lin kellontikitys_N = mkkN "kellontikitys" ;
lin kellottaa_1_V = mkkV "kellottaa" ;
lin kellottaa_2_V = mkkV "kellottaa" ;
lin kellottaa_3_V = mkkV "kellottaa" ;
lin kellua_V = mkkV "kellua" ;
lin kelluke_N = mkkN "kelluke" ;
lin kellukka_N = mkkN "kellukka" ;
lin kellunta_N = mkkN "kellunta" ;
lin kellute_N = mkkN "kellute" ;
lin kelluttaa_V = mkkV "kelluttaa" ;
lin kellutus_N = mkkN "kellutus" ;
lin kelluvuus_N = mkkN "kelluvuus" ;
lin kelmentya'_V = mkkV "kelmentyä" ;
lin kelmenta'a'_V = mkkV "kelmentää" ;
lin kelmeta'_V = mkkV "kelmetä" ;
lin kelmeys_N = mkkN "kelmeys" ;
lin kelmea'_N = mkkN "kelmeä" ;
lin kelmi_N = mkkN "kelmi" ;
lin kelmu_N = mkkN "kelmu" ;
lin kelo_N = mkkN "kelo" ;
lin kelokko_N = mkkN "kelokko" ;
lin kelottua_V = mkkV "kelottua" ;
lin keloutua_V = mkkV "keloutua" ;
lin kelpo_N = mkkN "kelpo" ;
lin kelpoinen_N = mkkN "kelpoinen" ;
lin kelpoisuus_N = mkkN "kelpoisuus" ;
lin kelpoisuusaika_N = mkkN "kelpoisuusaika" ;
lin kelpuuttaa_V = mkkV "kelpuuttaa" ;
lin kelpuutus_N = mkkN "kelpuutus" ;
lin kelsiturkki_N = mkkN "kelsiturkki" ;
lin kelta_N = mkkN "kelta" ;
lin keltainen_N = mkkN "keltainen" ;
lin keltaisuus_N = mkkN "keltaisuus" ;
lin keltamo_N = mkkN "keltamo" ;
lin keltano_N = mkkN "keltano" ;
lin kelteisilleen_Adv = mkkAdv "kelteisilleen" ;
lin kelteisilla'a'n_Adv = mkkAdv "kelteisillään" ;
lin keltia'inen_N = mkkN "keltiäinen" ;
lin keltti_N = mkkN "keltti" ;
lin kelttila'inen_N = mkkN "kelttiläinen" ;
lin keltuainen_N = mkkN "keltuainen" ;
lin kelvata_V = mkkV "kelvata" ;
lin kelvin_N = mkkN "kelvin" ;
lin kelvokas_N = mkkN "kelvokas" ;
lin kelvollinen_A = mkkA "kelvollinen" ;
lin kelvollisesti_Adv = mkkAdv "kelvollisesti" ;
lin kelvollisuus_N = mkkN "kelvollisuus" ;
lin kelvoton_N = mkkN "kelvoton" ;
lin kelvottomasti_Adv = mkkAdv "kelvottomasti" ;
lin kelvottomuus_N = mkkN "kelvottomuus" ;
lin kemia_N = mkkN "kemia" ;
lin kemiallinen_A = mkkA "kemiallinen" ;
lin kemiallisesti_Adv = mkkAdv "kemiallisesti" ;
lin kemigrafi_N = mkkN "kemigrafi" ;
lin kemigrafia_N = mkkN "kemigrafia" ;
lin kemigrafinen_N = mkkN "kemigrafinen" ;
lin kemikaali_N = mkkN "kemikaali" ;
lin kemisti_N = mkkN "kemisti" ;
lin kemppi_N = mkkN "kemppi" ;
--? lin kemut_NK = {s = d01 "kemut" ;
lin kendo_N = mkkN "kendo" ;
lin kengitta'ja'_N = mkkN "kengittäjä" ;
lin kengitta'a'_V = mkkV "kengittää" ;
lin kengitys_N = mkkN "kengitys" ;
lin kenga'nkiillottaja_N = mkkN "kengänkiillottaja" ;
lin kenkku_N = mkkN "kenkku" ;
lin kenkkuilla_V = mkkV "kenkkuilla" ;
lin kenkuttaa_V = mkkV "kenkuttaa" ;
lin kenka'_N = mkkN "kenkä" ;
lin kenka'in_N = mkkN "kenkäin" ;
lin kenka'inen_N = mkkN "kenkäinen" ;
lin kennel_N = mkkN "kennel" ;
lin kenno_N = mkkN "kenno" ;
lin kenollaan_Adv = mkkAdv "kenollaan" ;
lin kenoon_Adv = mkkAdv "kenoon" ;
lin kenossa_Adv = mkkAdv "kenossa" ;
lin kenotsooinen_N = mkkN "kenotsooinen" ;
lin kenottaa_V = mkkV "kenottaa" ;
lin kenraali_N = mkkN "kenraali" ;
lin kenraalisto_N = mkkN "kenraalisto" ;
lin kenraalitar_N = mkkN "kenraalitar" ;
lin kentauri_N = mkkN "kentauri" ;
lin kenties_Adv = mkkAdv "kenties" ;
lin kentta'_N = mkkN "kenttä" ;
lin kenta'llinen_N = mkkN "kentällinen" ;
lin kepakko_N = mkkN "kepakko" ;
lin kepeys_N = mkkN "kepeys" ;
lin kepea'_A = mkkA "kepeä" ;
lin kepea'sti_Adv = mkkAdv "kepeästi" ;
lin kepitta'a'_V = mkkV "kepittää" ;
lin kepitys_N = mkkN "kepitys" ;
lin keplotella_V = mkkV "keplotella" ;
lin keplottelu_N = mkkN "keplottelu" ;
lin keppana_N = mkkN "keppana" ;
lin keppi_N = mkkN "keppi" ;
lin kepponen_N = mkkN "kepponen" ;
lin kepulainen_N = mkkN "kepulainen" ;
lin kepuli_A = mkkA "kepuli" ;
lin kepulisti_Adv = mkkAdv "kepulisti" ;
lin kera_Adv = mkkAdv "kera" ;
lin keraami_N = mkkN "keraami" ;
lin keraamikko_N = mkkN "keraamikko" ;
lin keraaminen_N = mkkN "keraaminen" ;
lin kerake_N = mkkN "kerake" ;
lin keralla_Adv = mkkAdv "keralla" ;
lin keralle_Adv = mkkAdv "keralle" ;
lin keratiini_N = mkkN "keratiini" ;
lin kerberos_N = mkkN "kerberos" ;
lin kerettila'inen_N = mkkN "kerettiläinen" ;
lin kerettila'isyys_N = mkkN "kerettiläisyys" ;
lin kereta'_V = mkkV "keretä" ;
lin kerho_N = mkkN "kerho" ;
lin kerinta'_1_N = mkkN "kerintä" ;
lin kerinta'_2_N = mkkN "kerintä" ;
lin keripukki_N = mkkN "keripukki" ;
--? lin keritsimet_NK = {s = d33 "keritsimet" ;
lin kerita'_1_V = mkkV "keritä" ;
lin kerita'_2_V = mkkV "keritä" ;
lin keriytya'_V = mkkV "keriytyä" ;
lin keria'_V = mkkV "keriä" ;
lin kerjeta'_V = mkkV "kerjetä" ;
lin kerjuu_N = mkkN "kerjuu" ;
lin kerja'la'inen_N = mkkN "kerjäläinen" ;
lin kerja'la'isyys_N = mkkN "kerjäläisyys" ;
lin kerja'ta'_V = mkkV "kerjätä" ;
lin kerja'ys_N = mkkN "kerjäys" ;
lin kerkeys_N = mkkN "kerkeys" ;
lin kerkea'_A = mkkA "kerkeä" ;
lin kerkea'sti_Adv = mkkAdv "kerkeästi" ;
lin kerkka'_N = mkkN "kerkkä" ;
lin kerma_N = mkkN "kerma" ;
lin kermainen_N = mkkN "kermainen" ;
lin kermakko_N = mkkN "kermakko" ;
lin kermoa_V = mkkV "kermoa" ;
lin kermoittua_V = mkkV "kermoittua" ;
lin kernaasti_Adv = mkkAdv "kernaasti" ;
lin kerni_N = mkkN "kerni" ;
lin kero_N = mkkN "kero" ;
lin kerosiini_N = mkkN "kerosiini" ;
lin kerppu_N = mkkN "kerppu" ;
lin kerrakseen_Adv = mkkAdv "kerrakseen" ;
lin kerralla_Adv = mkkAdv "kerralla" ;
lin kerrallaan_Adv = mkkAdv "kerrallaan" ;
lin kerrallinen_N = mkkN "kerrallinen" ;
lin kerrallisuus_N = mkkN "kerrallisuus" ;
lin kerran_Adv = mkkAdv "kerran" ;
lin kerrassaan_Adv = mkkAdv "kerrassaan" ;
lin kerrasto_N = mkkN "kerrasto" ;
lin kerrata_V = mkkV "kerrata" ;
lin kerroin_1_N = mkkN "kerroin" ;
lin kerroin_2_Adv = mkkAdv "kerroin" ;
lin kerroksellinen_N = mkkN "kerroksellinen" ;
lin kerroksellisuus_N = mkkN "kerroksellisuus" ;
lin kerroksinen_N = mkkN "kerroksinen" ;
lin kerroksisuus_N = mkkN "kerroksisuus" ;
lin kerroksittain_Adv = mkkAdv "kerroksittain" ;
lin kerroksittainen_N = mkkN "kerroksittainen" ;
lin kerronnallinen_N = mkkN "kerronnallinen" ;
lin kerronta_N = mkkN "kerronta" ;
lin kerros_N = mkkN "kerros" ;
lin kerrospukeutuminen_N = mkkN "kerrospukeutuminen" ;
lin kerrostaa_V = mkkV "kerrostaa" ;
lin kerrostaloasuminen_N = mkkN "kerrostaloasuminen" ;
lin kerrosteisuus_N = mkkN "kerrosteisuus" ;
lin kerrostua_V = mkkV "kerrostua" ;
lin kerrottava_N = mkkN "kerrottava" ;
lin kerrotunlainen_N = mkkN "kerrotunlainen" ;
lin kersa_N = mkkN "kersa" ;
lin kersantti_N = mkkN "kersantti" ;
lin kerska_N = mkkN "kerska" ;
lin kerskailija_N = mkkN "kerskailija" ;
lin kerskailla_V = mkkV "kerskailla" ;
lin kerskailu_N = mkkN "kerskailu" ;
lin kerskata_V = mkkV "kerskata" ;
lin kerskua_V = mkkV "kerskua" ;
lin kerskuja_N = mkkN "kerskuja" ;
lin kerskuri_N = mkkN "kerskuri" ;
lin kerta_N = mkkN "kerta" ;
lin kertaakaan_Adv = mkkAdv "kertaakaan" ;
lin kertaalleen_Adv = mkkAdv "kertaalleen" ;
lin kertaantua_V = mkkV "kertaantua" ;
lin kertaheitolla_Adv = mkkAdv "kertaheitolla" ;
lin kertainen_A = mkkA "kertainen" ;
lin kertaisesti_Adv = mkkAdv "kertaisesti" ;
lin kertaistaa_V = mkkV "kertaistaa" ;
lin kertaistua_V = mkkV "kertaistua" ;
lin kerta_kaikkiaan_Adv = mkkAdv "kertC" ;
lin kertakaikkinen_A = mkkA "kertakaikkinen" ;
lin kertakaikkisesti_Adv = mkkAdv "kertakaikkisesti" ;
lin kertauma_N = mkkN "kertauma" ;
lin kertaus_N = mkkN "kertaus" ;
lin kertautua_V = mkkV "kertautua" ;
lin kerto_N = mkkN "kerto" ;
lin kertoa_V = mkkV "kertoa" ;
lin kertoilla_V = mkkV "kertoilla" ;
lin kertoja_N = mkkN "kertoja" ;
lin kertoma_N = mkkN "kertoma" ;
lin kertomus_N = mkkN "kertomus" ;
lin kerttu_N = mkkN "kerttu" ;
lin kerttunen_N = mkkN "kerttunen" ;
lin kertyma'_N = mkkN "kertymä" ;
lin kertya'_V = mkkV "kertyä" ;
lin kerubi_N = mkkN "kerubi" ;
lin keruu_N = mkkN "keruu" ;
lin kera'_N = mkkN "kerä" ;
lin kera'elma'_N = mkkN "keräelmä" ;
lin kera'ilija'_N = mkkN "keräilijä" ;
lin kera'illa'_V = mkkV "keräillä" ;
lin kera'ily_N = mkkN "keräily" ;
lin kera'ta'_V = mkkV "kerätä" ;
lin kera'yma'_N = mkkN "keräymä" ;
lin kera'ys_N = mkkN "keräys" ;
lin kera'ytyma'_N = mkkN "keräytymä" ;
lin kera'ytya'_V = mkkV "keräytyä" ;
lin kera'a'ja'_N = mkkN "kerääjä" ;
lin kera'a'ntya'_V = mkkV "kerääntyä" ;
lin kesakko_N = mkkN "kesakko" ;
lin kesakkoinen_N = mkkN "kesakkoinen" ;
lin kesannoida_V = mkkV "kesannoida" ;
lin kesannointi_N = mkkN "kesannointi" ;
lin kesannoitua_V = mkkV "kesannoitua" ;
lin kesanto_N = mkkN "kesanto" ;
lin kesemma'ksi_Adv = mkkAdv "kesemmäksi" ;
lin kesemma'lle_Adv = mkkAdv "kesemmälle" ;
lin kesemma'lla'_Adv = mkkAdv "kesemmällä" ;
lin kesempa'na'_Adv = mkkAdv "kesempänä" ;
lin kesia'_V = mkkV "kesiä" ;
lin keskari_N = mkkN "keskari" ;
lin keskeen_Adv = mkkAdv "keskeen" ;
lin keskeinen_A = mkkA "keskeinen" ;
lin keskeisesti_Adv = mkkAdv "keskeisesti" ;
lin keskeisyys_N = mkkN "keskeisyys" ;
lin keskelle_Adv = mkkAdv "keskelle" ;
lin keskella'_Adv = mkkAdv "keskellä" ;
lin keskelta'_Adv = mkkAdv "keskeltä" ;
lin keskemma'_Adv = mkkAdv "keskemmä" ;
lin keskemma'ksi_Adv = mkkAdv "keskemmäksi" ;
lin keskemma'lle_Adv = mkkAdv "keskemmälle" ;
lin keskemma'lla'_Adv = mkkAdv "keskemmällä" ;
lin keskemma'lta'_Adv = mkkAdv "keskemmältä" ;
lin keskemma's_Adv = mkkAdv "keskemmäs" ;
lin keskempa'na'_Adv = mkkAdv "keskempänä" ;
lin keskempa'a'_Adv = mkkAdv "keskempää" ;
lin kesken_Adv = mkkAdv "kesken" ;
lin keskenera'inen_N = mkkN "keskeneräinen" ;
lin keskenera'isyys_N = mkkN "keskeneräisyys" ;
lin keskena'a'n_Adv = mkkAdv "keskenään" ;
lin keskessa'_Adv = mkkAdv "keskessä" ;
lin keskesta'_Adv = mkkAdv "keskestä" ;
lin keskeyksiin_Adv = mkkAdv "keskeyksiin" ;
lin keskeyksissa'_Adv = mkkAdv "keskeyksissä" ;
lin keskeyte_N = mkkN "keskeyte" ;
lin keskeytta'a'_V = mkkV "keskeyttää" ;
lin keskeytykseto'n_N = mkkN "keskeytyksetön" ;
lin keskeytyksiin_Adv = mkkAdv "keskeytyksiin" ;
lin keskeytyksissa'_Adv = mkkAdv "keskeytyksissä" ;
lin keskeytyma'to'n_N = mkkN "keskeytymätön" ;
lin keskeytys_N = mkkN "keskeytys" ;
lin keskeytya'_V = mkkV "keskeytyä" ;
lin keskiaika_N = mkkN "keskiaika" ;
lin keskiaurinkoaika_N = mkkN "keskiaurinkoaika" ;
lin keskihakuisesti_Adv = mkkAdv "keskihakuisesti" ;
lin keski_ika'istya'_V = mkkV "keski-ikäistyä" ;
lin keskikohta_N = mkkN "keskikohta" ;
lin keskikoko_N = mkkN "keskikoko" ;
lin keskiluokkaistua_V = mkkV "keskiluokkaistua" ;
lin keskimma'inen_N = mkkN "keskimmäinen" ;
lin keskima'a'rin_Adv = mkkAdv "keskimäärin" ;
lin keskinen_N = mkkN "keskinen" ;
lin keskinkertaisesti_Adv = mkkAdv "keskinkertaisesti" ;
lin keskinkertaisuus_N = mkkN "keskinkertaisuus" ;
lin keskina'inen_A = mkkA "keskinäinen" ;
lin keskina'isesti_Adv = mkkAdv "keskinäisesti" ;
lin keskina'isyys_N = mkkN "keskinäisyys" ;
lin keskipakoinen_A = mkkA "keskipakoinen" ;
lin keskipakoisesti_Adv = mkkAdv "keskipakoisesti" ;
lin keskipakoisuus_N = mkkN "keskipakoisuus" ;
lin keskisarka_N = mkkN "keskisarka" ;
lin keskitse_Adv = mkkAdv "keskitse" ;
lin keskittyma'_N = mkkN "keskittymä" ;
lin keskittya'_V = mkkV "keskittyä" ;
lin keskitta'a'_V = mkkV "keskittää" ;
lin keskitys_N = mkkN "keskitys" ;
lin keskivaiheilla_Adv = mkkAdv "keskivaiheilla" ;
lin keskivaiheille_Adv = mkkAdv "keskivaiheille" ;
lin keskivaiheilta_Adv = mkkAdv "keskivaiheilta" ;
lin keskiviikkoisin_Adv = mkkAdv "keskiviikkoisin" ;
lin keskio'_N = mkkN "keskiö" ;
lin keskonen_N = mkkN "keskonen" ;
lin keskosuus_N = mkkN "keskosuus" ;
lin keskus_N = mkkN "keskus" ;
lin keskusta_N = mkkN "keskusta" ;
lin keskustelija_N = mkkN "keskustelija" ;
lin keskustella_V = mkkV "keskustella" ;
lin keskustelu_N = mkkN "keskustelu" ;
lin keskuudessa_Adv = mkkAdv "keskuudessa" ;
lin keskuudesta_Adv = mkkAdv "keskuudesta" ;
lin keskuuteen_Adv = mkkAdv "keskuuteen" ;
lin kessu_1_N = mkkN "kessu" ;
lin kessu_2_N = mkkN "kessu" ;
lin kessutella_V = mkkV "kessutella" ;
lin kessuttaa_V = mkkV "kessuttaa" ;
lin kesti_N = mkkN "kesti" ;
lin kestitta'a'_V = mkkV "kestittää" ;
lin kestitys_N = mkkN "kestitys" ;
lin kestita'_V = mkkV "kestitä" ;
lin kesto_N = mkkN "kesto" ;
lin kestoaika_N = mkkN "kestoaika" ;
lin kestoinen_N = mkkN "kestoinen" ;
lin kesta'ma'tto'myys_N = mkkN "kestämättömyys" ;
lin kesta'ma'to'n_N = mkkN "kestämätön" ;
lin kesta'vyys_N = mkkN "kestävyys" ;
lin kesta'va'_A = mkkA "kestävä" ;
lin kesta'va'sti_Adv = mkkAdv "kestävästi" ;
lin kesta'vo'ida'_V = mkkV "kestävöidä" ;
lin kesta'vo'inti_N = mkkN "kestävöinti" ;
lin kesta'a'_V = mkkV "kestää" ;
lin kesy_A = mkkA "kesy" ;
lin kesysti_Adv = mkkAdv "kesysti" ;
lin kesyttya'_V = mkkV "kesyttyä" ;
lin kesytta'ja'_N = mkkN "kesyttäjä" ;
lin kesytta'ma'to'n_N = mkkN "kesyttämätön" ;
lin kesytta'a'_V = mkkV "kesyttää" ;
lin kesytto'myys_N = mkkN "kesyttömyys" ;
lin kesytys_N = mkkN "kesytys" ;
lin kesyto'n_N = mkkN "kesytön" ;
lin kesyyntya'_V = mkkV "kesyyntyä" ;
lin kesyys_N = mkkN "kesyys" ;
lin kesa'_N = mkkN "kesä" ;
lin kesa'aika_N = mkkN "kesäaika" ;
lin kesa'asuttava_N = mkkN "kesäasuttava" ;
lin kesa'inen_A = mkkA "kesäinen" ;
lin kesa'isesti_Adv = mkkAdv "kesäisesti" ;
lin kesa'isin_Adv = mkkAdv "kesäisin" ;
lin kesa'llinen_N = mkkN "kesällinen" ;
lin ketale_N = mkkN "ketale" ;
lin ketara_N = mkkN "ketara" ;
lin ketchup_N = mkkN "ketchup" ;
lin ketju_N = mkkN "ketju" ;
lin ketjullinen_N = mkkN "ketjullinen" ;
lin ketjuttaa_V = mkkV "ketjuttaa" ;
lin ketjutus_N = mkkN "ketjutus" ;
lin ketjuuntua_V = mkkV "ketjuuntua" ;
lin ketjuutua_V = mkkV "ketjuutua" ;
lin ketjuva'lityksinen_N = mkkN "ketjuvälityksinen" ;
lin ketkale_N = mkkN "ketkale" ;
lin ketku_N = mkkN "ketku" ;
lin ketlaaja_N = mkkN "ketlaaja" ;
lin ketlata_V = mkkV "ketlata" ;
lin keto_N = mkkN "keto" ;
lin ketoni_N = mkkN "ketoni" ;
lin ketoosi_1_N = mkkN "ketoosi" ;
lin ketoosi_2_N = mkkN "ketoosi" ;
lin ketsi_N = mkkN "ketsi" ;
lin ketsuppi_N = mkkN "ketsuppi" ;
lin ketteryys_N = mkkN "ketteryys" ;
lin kettera'_A = mkkA "ketterä" ;
lin kettera'sti_Adv = mkkAdv "ketterästi" ;
lin kettinki_N = mkkN "kettinki" ;
lin ketto_N = mkkN "ketto" ;
lin kettu_N = mkkN "kettu" ;
lin ketuttaa_V = mkkV "ketuttaa" ;
lin keuhko_N = mkkN "keuhko" ;
lin keula_N = mkkN "keula" ;
lin keulemmaksi_Adv = mkkAdv "keulemmaksi" ;
lin keulemmas_Adv = mkkAdv "keulemmas" ;
lin keulempaa_Adv = mkkAdv "keulempaa" ;
lin keulempana_Adv = mkkAdv "keulempana" ;
lin keulimmainen_N = mkkN "keulimmainen" ;
lin kevennys_N = mkkN "kevennys" ;
lin keventya'_V = mkkV "keventyä" ;
lin keventa'a'_V = mkkV "keventää" ;
lin keveta'_V = mkkV "kevetä" ;
lin keveys_N = mkkN "keveys" ;
lin kevea'_A = mkkA "keveä" ;
lin kevea'sti_Adv = mkkAdv "keveästi" ;
lin kevyesti_Adv = mkkAdv "kevyesti" ;
lin kevyt_N = mkkN "kevyt" ;
lin kevytmielisesti_Adv = mkkAdv "kevytmielisesti" ;
lin keva'in_N = mkkN "keväin" ;
lin keva'inen_A = mkkA "keväinen" ;
lin keva'isesti_Adv = mkkAdv "keväisesti" ;
lin keva'isin_Adv = mkkAdv "keväisin" ;
lin keva'istys_N = mkkN "keväistys" ;
lin keva'ista'a'_V = mkkV "keväistää" ;
--? lin keva't_NK = {s = d44 "kevät" ;
lin keva'taika_N = mkkN "kevätaika" ;
lin keva'a'llinen_N = mkkN "keväällinen" ;
lin keva'a'mma'ksi_Adv = mkkAdv "keväämmäksi" ;
lin keva'a'mma'lle_Adv = mkkAdv "keväämmälle" ;
lin keva'a'mma'lla'_Adv = mkkAdv "keväämmällä" ;
lin keva'a'mma's_Adv = mkkAdv "keväämmäs" ;
lin keva'a'mpa'na'_Adv = mkkAdv "keväämpänä" ;
lin khaki_N = mkkN "khaki" ;
lin khii_N = mkkN "khii" ;
lin khmer_N = mkkN "khmer" ;
lin kibbutsi_N = mkkN "kibbutsi" ;
lin kide_N = mkkN "kide" ;
lin kidnapata_V = mkkV "kidnapata" ;
lin kidnappaaja_N = mkkN "kidnappaaja" ;
lin kidnappaus_N = mkkN "kidnappaus" ;
--? lin kidukset_NK = {s = d39 "kidukset" ;
lin kiduttaa_V = mkkV "kiduttaa" ;
lin kiduttaja_N = mkkN "kiduttaja" ;
lin kidutus_N = mkkN "kidutus" ;
lin kiedonta_N = mkkN "kiedonta" ;
lin kiehahdus_N = mkkN "kiehahdus" ;
lin kiehahtaa_V = mkkV "kiehahtaa" ;
lin kiehauttaa_V = mkkV "kiehauttaa" ;
lin kiehautus_N = mkkN "kiehautus" ;
lin kiehkura_N = mkkN "kiehkura" ;
lin kiehna'ta'_V = mkkV "kiehnätä" ;
lin kiehtoa_V = mkkV "kiehtoa" ;
lin kiehtova_A = mkkA "kiehtova" ;
lin kiehtovasti_Adv = mkkAdv "kiehtovasti" ;
lin kiehtovuus_N = mkkN "kiehtovuus" ;
lin kiehua_V = mkkV "kiehua" ;
lin kiehunta_N = mkkN "kiehunta" ;
lin kiehuttaa_V = mkkV "kiehuttaa" ;
lin kiehutus_N = mkkN "kiehutus" ;
lin kieha'ta'_V = mkkV "kiehätä" ;
lin kiekaista_V = mkkV "kiekaista" ;
lin kiekaisu_N = mkkN "kiekaisu" ;
lin kiekaus_N = mkkN "kiekaus" ;
lin kiekko_N = mkkN "kiekko" ;
lin kiekkoilija_N = mkkN "kiekkoilija" ;
lin kiekkoilla_V = mkkV "kiekkoilla" ;
lin kiekoton_N = mkkN "kiekoton" ;
lin kiekua_V = mkkV "kiekua" ;
lin kiekuja_N = mkkN "kiekuja" ;
lin kiekuna_N = mkkN "kiekuna" ;
lin kiekura_N = mkkN "kiekura" ;
lin kiekurainen_N = mkkN "kiekurainen" ;
lin kieleke_N = mkkN "kieleke" ;
lin kielekkeinen_N = mkkN "kielekkeinen" ;
lin kielellinen_A = mkkA "kielellinen" ;
lin kielellisesti_Adv = mkkAdv "kielellisesti" ;
lin kielenta'a'_V = mkkV "kielentää" ;
lin kieleva'_A = mkkA "kielevä" ;
lin kieleva'sti_Adv = mkkAdv "kielevästi" ;
lin kieli_N = mkkN "kieli" ;
lin kielija'_N = mkkN "kielijä" ;
lin kielima'inen_N = mkkN "kielimäinen" ;
lin kielinen_N = mkkN "kielinen" ;
lin kielisyys_N = mkkN "kielisyys" ;
lin kielia'_V = mkkV "kieliä" ;
lin kiellella'_V = mkkV "kiellellä" ;
lin kielletty_N = mkkN "kielletty" ;
lin kielo_N = mkkN "kielo" ;
lin kielteinen_A = mkkA "kielteinen" ;
lin kielteisesti_Adv = mkkAdv "kielteisesti" ;
lin kielteistya'_V = mkkV "kielteistyä" ;
lin kielteisyys_N = mkkN "kielteisyys" ;
lin kieltely_N = mkkN "kieltely" ;
lin kielto_N = mkkN "kielto" ;
lin kielta'ja'_N = mkkN "kieltäjä" ;
lin kielta'ma'tta'_Adv = mkkAdv "kieltämättä" ;
lin kielta'ma'to'n_N = mkkN "kieltämätön" ;
lin kielta'va'_N = mkkN "kieltävä" ;
lin kielta'ymyksellinen_N = mkkN "kieltäymyksellinen" ;
lin kielta'ymys_N = mkkN "kieltäymys" ;
lin kielta'ytyja'_N = mkkN "kieltäytyjä" ;
lin kielta'ytya'_V = mkkV "kieltäytyä" ;
lin kielta'a'_V = mkkV "kieltää" ;
lin kiemura_N = mkkN "kiemura" ;
lin kiemurainen_N = mkkN "kiemurainen" ;
lin kiemurrella_V = mkkV "kiemurrella" ;
lin kiemurtaa_V = mkkV "kiemurtaa" ;
lin kiemurtelu_N = mkkN "kiemurtelu" ;
lin kiepahdus_N = mkkN "kiepahdus" ;
lin kiepahtaa_V = mkkV "kiepahtaa" ;
lin kiepaus_N = mkkN "kiepaus" ;
lin kiepauttaa_V = mkkV "kiepauttaa" ;
lin kiepautus_N = mkkN "kiepautus" ;
lin kieppeille_Adv = mkkAdv "kieppeille" ;
lin kieppeilla'_Adv = mkkAdv "kieppeillä" ;
lin kieppeissa'_Adv = mkkAdv "kieppeissä" ;
lin kieppi_N = mkkN "kieppi" ;
lin kieppua_V = mkkV "kieppua" ;
lin kiepsahdella_V = mkkV "kiepsahdella" ;
lin kiepsahdus_N = mkkN "kiepsahdus" ;
lin kiepsahtaa_V = mkkV "kiepsahtaa" ;
lin kiepsaus_N = mkkN "kiepsaus" ;
lin kiepsauttaa_V = mkkV "kiepsauttaa" ;
lin kiepunta_N = mkkN "kiepunta" ;
lin kieputella_V = mkkV "kieputella" ;
lin kieputtaa_V = mkkV "kieputtaa" ;
lin kierinta'_N = mkkN "kierintä" ;
lin kieriskella'_V = mkkV "kieriskellä" ;
lin kieritella'_V = mkkV "kieritellä" ;
lin kieritta'a'_V = mkkV "kierittää" ;
lin kieritys_N = mkkN "kieritys" ;
lin kieria'_V = mkkV "kieriä" ;
lin kiero_A = mkkA "kiero" ;
lin kieroilija_N = mkkN "kieroilija" ;
lin kieroilla_V = mkkV "kieroilla" ;
lin kieroilu_N = mkkN "kieroilu" ;
lin kieroontua_V = mkkV "kieroontua" ;
lin kierosti_Adv = mkkAdv "kierosti" ;
lin kierous_N = mkkN "kierous" ;
lin kierouttaa_V = mkkV "kierouttaa" ;
lin kieroutua_V = mkkV "kieroutua" ;
lin kieroutuma_N = mkkN "kieroutuma" ;
lin kieroutuneisuus_N = mkkN "kieroutuneisuus" ;
lin kierre_N = mkkN "kierre" ;
lin kierrella'_V = mkkV "kierrellä" ;
lin kierrin_N = mkkN "kierrin" ;
lin kierroksinen_N = mkkN "kierroksinen" ;
lin kierroksittain_Adv = mkkAdv "kierroksittain" ;
lin kierros_N = mkkN "kierros" ;
lin kierrosaika_N = mkkN "kierrosaika" ;
lin kierryksiin_Adv = mkkAdv "kierryksiin" ;
lin kierryksissa'_Adv = mkkAdv "kierryksissä" ;
lin kierryksista'_Adv = mkkAdv "kierryksistä" ;
lin kierra'nta'_N = mkkN "kierräntä" ;
lin kierra'tta'a'_V = mkkV "kierrättää" ;
lin kierra'tys_N = mkkN "kierrätys" ;
lin kierteellinen_N = mkkN "kierteellinen" ;
lin kierteinen_A = mkkA "kierteinen" ;
lin kierteisesti_Adv = mkkAdv "kierteisesti" ;
lin kierteisyys_N = mkkN "kierteisyys" ;
lin kierteitta'a'_V = mkkV "kierteittää" ;
lin kierteitys_N = mkkN "kierteitys" ;
lin kiertelema'to'n_N = mkkN "kiertelemätön" ;
lin kierteleva'_N = mkkN "kiertelevä" ;
lin kiertelija'_N = mkkN "kiertelijä" ;
lin kiertely_N = mkkN "kiertely" ;
lin kierto_N = mkkN "kierto" ;
lin kiertoaika_N = mkkN "kiertoaika" ;
lin kiertolaisuus_N = mkkN "kiertolaisuus" ;
lin kiertue_N = mkkN "kiertue" ;
lin kiertyma'_N = mkkN "kiertymä" ;
lin kiertya'_V = mkkV "kiertyä" ;
lin kierta'ja'_N = mkkN "kiertäjä" ;
lin kierta'ma'to'n_N = mkkN "kiertämätön" ;
lin kierta'a'_V = mkkV "kiertää" ;
lin kierukka_N = mkkN "kierukka" ;
lin kierukkainen_N = mkkN "kierukkainen" ;
lin kieryys_N = mkkN "kieryys" ;
lin kiera'_N = mkkN "kierä" ;
lin kiera'hdella'_V = mkkV "kierähdellä" ;
lin kiera'hdys_N = mkkN "kierähdys" ;
lin kiera'hta'a'_V = mkkV "kierähtää" ;
lin kiera'ytta'a'_V = mkkV "kieräyttää" ;
lin kiesit_N = mkkN "kiesit" ;
lin kietaista_V = mkkV "kietaista" ;
lin kietaisu_N = mkkN "kietaisu" ;
lin kietoa_V = mkkV "kietoa" ;
lin kietoontua_V = mkkV "kietoontua" ;
lin kietouma_N = mkkN "kietouma" ;
lin kietoutua_V = mkkV "kietoutua" ;
lin kietoutuma_N = mkkN "kietoutuma" ;
lin kieunta_N = mkkN "kieunta" ;
lin kievari_N = mkkN "kievari" ;
lin kihahdus_N = mkkN "kihahdus" ;
lin kihahtaa_1_V = mkkV "kihahtaa" ;
lin kihahtaa_2_V = mkkV "kihahtaa" ;
lin kihara_N = mkkN "kihara" ;
lin kiharaan_Adv = mkkAdv "kiharaan" ;
lin kiharainen_N = mkkN "kiharainen" ;
lin kiharassa_Adv = mkkAdv "kiharassa" ;
lin kiharrin_N = mkkN "kiharrin" ;
lin kihartaa_V = mkkV "kihartaa" ;
lin kihartua_V = mkkV "kihartua" ;
lin kiharuus_N = mkkN "kiharuus" ;
lin kihaus_N = mkkN "kihaus" ;
lin kihdata_V = mkkV "kihdata" ;
lin kihelmo'ida'_V = mkkV "kihelmöidä" ;
lin kihelmo'inti_N = mkkN "kihelmöinti" ;
lin kiherrella'_V = mkkV "kiherrellä" ;
lin kiherrys_N = mkkN "kiherrys" ;
lin kiherta'a'_V = mkkV "kihertää" ;
lin kihina'_N = mkkN "kihinä" ;
lin kihista'_V = mkkV "kihistä" ;
--? lin kihlajaiset_NK = {s = d38 "kihlajaiset" ;
lin kihlapari_N = mkkN "kihlapari" ;
--? lin kihlat_NK = {s = d09 "kihlat" ;
lin kihlata_V = mkkV "kihlata" ;
lin kihlattu_N = mkkN "kihlattu" ;
lin kihlaus_N = mkkN "kihlaus" ;
lin kihlausaika_N = mkkN "kihlausaika" ;
lin kihlautua_V = mkkV "kihlautua" ;
lin kihloihin_Adv = mkkAdv "kihloihin" ;
lin kihloissa_Adv = mkkAdv "kihloissa" ;
lin kihnutella_V = mkkV "kihnutella" ;
lin kihnuttaa_V = mkkV "kihnuttaa" ;
lin kihnutus_N = mkkN "kihnutus" ;
lin kiho_N = mkkN "kiho" ;
lin kihokki_N = mkkN "kihokki" ;
lin kihota_V = mkkV "kihota" ;
lin kihti_N = mkkN "kihti" ;
lin kihu_N = mkkN "kihu" ;
lin kihveli_N = mkkN "kihveli" ;
lin kii_Adv = mkkAdv "kii" ;
lin kiida'tta'a'_V = mkkV "kiidättää" ;
lin kiihdyksiin_Adv = mkkAdv "kiihdyksiin" ;
lin kiihdyksissa'_Adv = mkkAdv "kiihdyksissä" ;
lin kiihdyksissa'a'n_Adv = mkkAdv "kiihdyksissään" ;
lin kiihdytin_N = mkkN "kiihdytin" ;
lin kiihdytta'a'_V = mkkV "kiihdyttää" ;
lin kiihdytys_N = mkkN "kiihdytys" ;
lin kiihkeys_N = mkkN "kiihkeys" ;
lin kiihkea'_A = mkkA "kiihkeä" ;
lin kiihkea'sti_Adv = mkkAdv "kiihkeästi" ;
lin kiihko_N = mkkN "kiihko" ;
lin kiihkoilija_N = mkkN "kiihkoilija" ;
lin kiihkoilla_V = mkkV "kiihkoilla" ;
lin kiihkoilu_N = mkkN "kiihkoilu" ;
lin kiihkoinen_N = mkkN "kiihkoinen" ;
lin kiihkoisa_A = mkkA "kiihkoisa" ;
lin kiihkoisasti_Adv = mkkAdv "kiihkoisasti" ;
lin kiihkoisuus_N = mkkN "kiihkoisuus" ;
lin kiihkota_V = mkkV "kiihkota" ;
lin kiihkoton_N = mkkN "kiihkoton" ;
lin kiihkottomasti_Adv = mkkAdv "kiihkottomasti" ;
lin kiihkottomuus_N = mkkN "kiihkottomuus" ;
lin kiihkoutua_V = mkkV "kiihkoutua" ;
lin kiihoke_N = mkkN "kiihoke" ;
lin kiihote_N = mkkN "kiihote" ;
lin kiihotin_N = mkkN "kiihotin" ;
lin kiihottaa_V = mkkV "kiihottaa" ;
lin kiihottaja_N = mkkN "kiihottaja" ;
lin kiihottua_V = mkkV "kiihottua" ;
lin kiihottuneisuus_N = mkkN "kiihottuneisuus" ;
lin kiihottuvuus_N = mkkN "kiihottuvuus" ;
lin kiihotus_N = mkkN "kiihotus" ;
lin kiihtymys_N = mkkN "kiihtymys" ;
lin kiihtyneisyys_N = mkkN "kiihtyneisyys" ;
lin kiihtyvyys_N = mkkN "kiihtyvyys" ;
lin kiihtya'_V = mkkV "kiihtyä" ;
lin kiikaroida_V = mkkV "kiikaroida" ;
lin kiikarointi_N = mkkN "kiikarointi" ;
lin kiikastaa_V = mkkV "kiikastaa" ;
lin kiikissa'_Adv = mkkAdv "kiikissä" ;
lin kiikista'_Adv = mkkAdv "kiikistä" ;
lin kiikkeryys_N = mkkN "kiikkeryys" ;
lin kiikkera'_N = mkkN "kiikkerä" ;
lin kiikkiin_Adv = mkkAdv "kiikkiin" ;
lin kiikku_N = mkkN "kiikku" ;
lin kiikkua_V = mkkV "kiikkua" ;
lin kiikun_kaakun_Adv = mkkAdv "kiikuC" ;
lin kiikutella_V = mkkV "kiikutella" ;
lin kiikuttaa_V = mkkV "kiikuttaa" ;
lin kiila_N = mkkN "kiila" ;
lin kiilata_V = mkkV "kiilata" ;
lin kiilaus_N = mkkN "kiilaus" ;
lin kiilautua_V = mkkV "kiilautua" ;
lin kiilia'inen_N = mkkN "kiiliäinen" ;
lin kiille_N = mkkN "kiille" ;
lin kiillella'_V = mkkV "kiillellä" ;
lin kiilloke_N = mkkN "kiilloke" ;
lin kiillote_N = mkkN "kiillote" ;
lin kiillotin_N = mkkN "kiillotin" ;
lin kiillottaa_V = mkkV "kiillottaa" ;
lin kiillottua_V = mkkV "kiillottua" ;
lin kiillotus_N = mkkN "kiillotus" ;
lin kiiltely_N = mkkN "kiiltely" ;
lin kiilto_N = mkkN "kiilto" ;
lin kiiltoinen_N = mkkN "kiiltoinen" ;
lin kiilta'vyys_N = mkkN "kiiltävyys" ;
lin kiilta'va'_N = mkkN "kiiltävä" ;
lin kiilta'a'_V = mkkV "kiiltää" ;
lin kiilu_N = mkkN "kiilu" ;
lin kiilua_V = mkkV "kiilua" ;
lin kiilukainen_N = mkkN "kiilukainen" ;
lin kiima_N = mkkN "kiima" ;
lin kiima_aika_N = mkkN "kiima-aika" ;
lin kiimattomuus_N = mkkN "kiimattomuus" ;
lin kiina_N = mkkN "kiina" ;
lin kiinailla_V = mkkV "kiinailla" ;
lin kiinata_V = mkkV "kiinata" ;
lin kiinne_N = mkkN "kiinne" ;
lin kiinnekohta_N = mkkN "kiinnekohta" ;
lin kiinnemma'ksi_Adv = mkkAdv "kiinnemmäksi" ;
lin kiinnemma's_Adv = mkkAdv "kiinnemmäs" ;
lin kiinnempa'na'_Adv = mkkAdv "kiinnempänä" ;
lin kiinneta'_V = mkkV "kiinnetä" ;
lin kiinni_Adv = mkkAdv "kiinni" ;
lin kiinnikasvama_N = mkkN "kiinnikasvama" ;
lin kiinnike_N = mkkN "kiinnike" ;
lin kiinnite_N = mkkN "kiinnite" ;
lin kiinnitin_N = mkkN "kiinnitin" ;
lin kiinnitteinen_N = mkkN "kiinnitteinen" ;
lin kiinnittya'_V = mkkV "kiinnittyä" ;
lin kiinnitta'ytya'_V = mkkV "kiinnittäytyä" ;
lin kiinnitta'a'_V = mkkV "kiinnittää" ;
lin kiinnityksinen_N = mkkN "kiinnityksinen" ;
lin kiinnitys_N = mkkN "kiinnitys" ;
lin kiinnityskohta_N = mkkN "kiinnityskohta" ;
lin kiinnostaa_V = mkkV "kiinnostaa" ;
lin kiinnostava_A = mkkA "kiinnostava" ;
lin kiinnostavasti_Adv = mkkAdv "kiinnostavasti" ;
lin kiinnostavuus_N = mkkN "kiinnostavuus" ;
lin kiinnostua_V = mkkV "kiinnostua" ;
lin kiinnostus_N = mkkN "kiinnostus" ;
lin kiinteisto'_N = mkkN "kiinteistö" ;
lin kiinteys_N = mkkN "kiinteys" ;
lin kiinteytta'a'_V = mkkV "kiinteyttää" ;
lin kiinteytya'_V = mkkV "kiinteytyä" ;
lin kiintea'_A = mkkA "kiinteä" ;
lin kiintea'sti_Adv = mkkAdv "kiinteästi" ;
lin kiintio'_N = mkkN "kiintiö" ;
lin kiintio'ida'_V = mkkV "kiintiöidä" ;
lin kiintio'inti_N = mkkN "kiintiöinti" ;
lin kiintoisa_A = mkkA "kiintoisa" ;
lin kiintoisasti_Adv = mkkAdv "kiintoisasti" ;
lin kiintoisuus_N = mkkN "kiintoisuus" ;
lin kiintonainen_N = mkkN "kiintonainen" ;
lin kiintymys_N = mkkN "kiintymys" ;
lin kiintyneisyys_N = mkkN "kiintyneisyys" ;
lin kiintya'_V = mkkV "kiintyä" ;
lin kiipeilija'_N = mkkN "kiipeilijä" ;
lin kiipeilla'_V = mkkV "kiipeillä" ;
lin kiipeily_N = mkkN "kiipeily" ;
lin kiipija'_N = mkkN "kiipijä" ;
lin kiire_1_A = mkkA "kiire" ;
lin kiire_2_A = mkkA "kiire" ;
lin kiireellinen_A = mkkA "kiireellinen" ;
lin kiireellisesti_Adv = mkkAdv "kiireellisesti" ;
lin kiireellisyys_N = mkkN "kiireellisyys" ;
lin kiireesti_Adv = mkkAdv "kiireesti" ;
lin kiireetto'myys_N = mkkN "kiireettömyys" ;
lin kiireetto'ma'sti_Adv = mkkAdv "kiireettömästi" ;
lin kiireeto'n_N = mkkN "kiireetön" ;
lin kiirehtia'_V = mkkV "kiirehtiä" ;
lin kiirehta'a'_V = mkkV "kiirehtää" ;
lin kiireimmiten_Adv = mkkAdv "kiireimmiten" ;
lin kiireinen_A = mkkA "kiireinen" ;
lin kiireisesti_Adv = mkkAdv "kiireisesti" ;
lin kiireys_N = mkkN "kiireys" ;
lin kiiri_N = mkkN "kiiri" ;
lin kiiria'_V = mkkV "kiiriä" ;
lin kiiru_N = mkkN "kiiru" ;
lin kiiruhtaa_V = mkkV "kiiruhtaa" ;
lin kiiruna_N = mkkN "kiiruna" ;
lin kiiruusti_Adv = mkkAdv "kiiruusti" ;
lin kiiski_N = mkkN "kiiski" ;
lin kiisseli_N = mkkN "kiisseli" ;
lin kiista_N = mkkN "kiista" ;
lin kiistainen_N = mkkN "kiistainen" ;
lin kiistaton_N = mkkN "kiistaton" ;
lin kiistattomasti_Adv = mkkAdv "kiistattomasti" ;
lin kiistattomuus_N = mkkN "kiistattomuus" ;
lin kiistella'_V = mkkV "kiistellä" ;
lin kiistely_N = mkkN "kiistely" ;
lin kiista'ma'tta'_Adv = mkkAdv "kiistämättä" ;
lin kiista'ma'tto'myys_N = mkkN "kiistämättömyys" ;
lin kiista'ma'tto'ma'sti_Adv = mkkAdv "kiistämättömästi" ;
lin kiista'ma'to'n_N = mkkN "kiistämätön" ;
lin kiista'a'_V = mkkV "kiistää" ;
lin kiisu_N = mkkN "kiisu" ;
lin kiitella'_V = mkkV "kiitellä" ;
lin kiitetta'vyys_N = mkkN "kiitettävyys" ;
lin kiitetta'va'_A = mkkA "kiitettävä" ;
lin kiitetta'va'sti_Adv = mkkAdv "kiitettävästi" ;
lin kiito_N = mkkN "kiito" ;
lin kiitollinen_N = mkkN "kiitollinen" ;
lin kiitollisuus_N = mkkN "kiitollisuus" ;
lin kiitos_N = mkkN "kiitos" ;
lin kiitti_Adv = mkkAdv "kiitti" ;
--? lin kiittimet_NK = {s = d33A "kiittimet" ;
lin kiitta'ja'_N = mkkN "kiittäjä" ;
lin kiitta'ma'tto'myys_N = mkkN "kiittämättömyys" ;
lin kiitta'ma'tto'ma'sti_Adv = mkkAdv "kiittämättömästi" ;
lin kiitta'ma'to'n_N = mkkN "kiittämätön" ;
lin kiitta'a'_V = mkkV "kiittää" ;
lin kiita'ja'_N = mkkN "kiitäjä" ;
lin kiita'ja'inen_N = mkkN "kiitäjäinen" ;
lin kiita'a'_V = mkkV "kiitää" ;
lin kiivaasti_Adv = mkkAdv "kiivaasti" ;
lin kiivailija_N = mkkN "kiivailija" ;
lin kiivailla_V = mkkV "kiivailla" ;
lin kiivailu_N = mkkN "kiivailu" ;
lin kiivas_A = mkkA "kiivas" ;
lin kiivastelija_N = mkkN "kiivastelija" ;
lin kiivastella_V = mkkV "kiivastella" ;
lin kiivastua_V = mkkV "kiivastua" ;
lin kiivastuttaa_V = mkkV "kiivastuttaa" ;
lin kiivaus_N = mkkN "kiivaus" ;
lin kiiveta'_V = mkkV "kiivetä" ;
lin kiivi_N = mkkN "kiivi" ;
lin kikatella_V = mkkV "kikatella" ;
lin kikattaa_V = mkkV "kikattaa" ;
lin kikatus_N = mkkN "kikatus" ;
lin kikka_N = mkkN "kikka" ;
lin kikkailla_V = mkkV "kikkailla" ;
lin kikkailu_N = mkkN "kikkailu" ;
lin kikkara_1_N = mkkN "kikkara" ;
lin kikkara_2_N = mkkN "kikkara" ;
lin kikkeli_N = mkkN "kikkeli" ;
lin kiksauttaa_V = mkkV "kiksauttaa" ;
lin kikuju_N = mkkN "kikuju" ;
lin kilahdella_V = mkkV "kilahdella" ;
lin kilahdus_N = mkkN "kilahdus" ;
lin kilahtaa_V = mkkV "kilahtaa" ;
lin kilaus_N = mkkN "kilaus" ;
lin kilauttaa_V = mkkV "kilauttaa" ;
lin kili_N = mkkN "kili" ;
lin kiliasmi_N = mkkN "kiliasmi" ;
lin kiliasti_N = mkkN "kiliasti" ;
lin kiliastinen_N = mkkN "kiliastinen" ;
lin kilina'_N = mkkN "kilinä" ;
lin kilistella'_V = mkkV "kilistellä" ;
lin kilista'_V = mkkV "kilistä" ;
lin kilista'a'_V = mkkV "kilistää" ;
lin kilisytta'a'_V = mkkV "kilisyttää" ;
lin kiljahdella_V = mkkV "kiljahdella" ;
lin kiljahdus_N = mkkN "kiljahdus" ;
lin kiljahtaa_V = mkkV "kiljahtaa" ;
lin kiljaista_V = mkkV "kiljaista" ;
lin kiljaisu_N = mkkN "kiljaisu" ;
lin kiljaus_N = mkkN "kiljaus" ;
lin kiljoona_N = mkkN "kiljoona" ;
lin kilju_N = mkkN "kilju" ;
lin kiljua_V = mkkV "kiljua" ;
lin kiljunta_N = mkkN "kiljunta" ;
lin kiljuva_N = mkkN "kiljuva" ;
lin kilkattaa_V = mkkV "kilkattaa" ;
lin kilkatus_N = mkkN "kilkatus" ;
lin kilke_N = mkkN "kilke" ;
lin kilkka_N = mkkN "kilkka" ;
lin kilkkaa_V = mkkV "kilkkaa" ;
lin kilkki_N = mkkN "kilkki" ;
lin kilkuttaa_V = mkkV "kilkuttaa" ;
lin kilkutus_N = mkkN "kilkutus" ;
lin killilla'a'n_Adv = mkkAdv "killillään" ;
lin killinki_N = mkkN "killinki" ;
lin killistella'_V = mkkV "killistellä" ;
lin killitella'_V = mkkV "killitellä" ;
lin killitta'a'_V = mkkV "killittää" ;
lin killua_V = mkkV "killua" ;
lin killutin_N = mkkN "killutin" ;
lin kilo_1_N = mkkN "kilo" ;
lin kilo_2_N = mkkN "kilo" ;
lin kiloinen_N = mkkN "kiloinen" ;
lin kiloittain_Adv = mkkAdv "kiloittain" ;
lin kilometrinnielija'_N = mkkN "kilometrinnielijä" ;
lin kilottaa_V = mkkV "kilottaa" ;
lin kilpa_N = mkkN "kilpa" ;
lin kilpaa_Adv = mkkAdv "kilpaa" ;
lin kilpa_ammunta_N = mkkN "kilpa-ammunta" ;
lin kilpailija_N = mkkN "kilpailija" ;
lin kilpailla_V = mkkV "kilpailla" ;
lin kilpailu_N = mkkN "kilpailu" ;
lin kilpailuaika_N = mkkN "kilpailuaika" ;
lin kilpailullinen_N = mkkN "kilpailullinen" ;
lin kilpailuttaa_V = mkkV "kilpailuttaa" ;
lin kilpalaulanta_N = mkkN "kilpalaulanta" ;
lin kilpasilla_Adv = mkkAdv "kilpasilla" ;
lin kilpasille_Adv = mkkAdv "kilpasille" ;
lin kilpi_N = mkkN "kilpi" ;
lin kilpistya'_V = mkkV "kilpistyä" ;
lin kilpukka_N = mkkN "kilpukka" ;
lin kilsa_N = mkkN "kilsa" ;
lin kilta_N = mkkN "kilta" ;
lin kiltisti_Adv = mkkAdv "kiltisti" ;
lin kiltsi_N = mkkN "kiltsi" ;
lin kiltteys_N = mkkN "kiltteys" ;
lin kiltti_1_N = mkkN "kiltti" ;
lin kiltti_2_N = mkkN "kiltti" ;
lin kilttiys_N = mkkN "kilttiys" ;
lin kilu_N = mkkN "kilu" ;
lin kilvan_Adv = mkkAdv "kilvan" ;
lin kilvaten_Adv = mkkAdv "kilvaten" ;
lin kilvoitella_V = mkkV "kilvoitella" ;
lin kilvoittelija_N = mkkN "kilvoittelija" ;
lin kilvoittelu_N = mkkN "kilvoittelu" ;
lin kilvoitus_N = mkkN "kilvoitus" ;
lin kimaira_N = mkkN "kimaira" ;
lin kimakasti_Adv = mkkAdv "kimakasti" ;
lin kimakka_N = mkkN "kimakka" ;
lin kimakkuus_N = mkkN "kimakkuus" ;
lin kimalainen_N = mkkN "kimalainen" ;
lin kimalle_N = mkkN "kimalle" ;
lin kimallella_V = mkkV "kimallella" ;
lin kimallus_N = mkkN "kimallus" ;
lin kimaltaa_V = mkkV "kimaltaa" ;
lin kimalteinen_N = mkkN "kimalteinen" ;
lin kimaltelu_N = mkkN "kimaltelu" ;
lin kimara_N = mkkN "kimara" ;
lin kimbri_N = mkkN "kimbri" ;
lin kimeys_N = mkkN "kimeys" ;
lin kimea'_A = mkkA "kimeä" ;
lin kimea'sti_Adv = mkkAdv "kimeästi" ;
lin kimitta'a'_V = mkkV "kimittää" ;
lin kimitys_N = mkkN "kimitys" ;
lin kimma_N = mkkN "kimma" ;
lin kimmahdus_N = mkkN "kimmahdus" ;
lin kimmahduttaa_V = mkkV "kimmahduttaa" ;
lin kimmahtaa_V = mkkV "kimmahtaa" ;
lin kimmastua_V = mkkV "kimmastua" ;
lin kimmastus_N = mkkN "kimmastus" ;
lin kimmastuttaa_V = mkkV "kimmastuttaa" ;
lin kimmauttaa_V = mkkV "kimmauttaa" ;
lin kimmelle_N = mkkN "kimmelle" ;
lin kimmellella'_V = mkkV "kimmellellä" ;
lin kimmellys_N = mkkN "kimmellys" ;
lin kimmeltely_N = mkkN "kimmeltely" ;
lin kimmelta'a'_V = mkkV "kimmeltää" ;
lin kimmoinen_N = mkkN "kimmoinen" ;
lin kimmoisa_A = mkkA "kimmoisa" ;
lin kimmoisasti_Adv = mkkAdv "kimmoisasti" ;
lin kimmoisuus_N = mkkN "kimmoisuus" ;
lin kimmoke_N = mkkN "kimmoke" ;
lin kimmokerroin_N = mkkN "kimmokerroin" ;
lin kimmoraja_N = mkkN "kimmoraja" ;
lin kimmota_V = mkkV "kimmota" ;
lin kimmoton_N = mkkN "kimmoton" ;
lin kimmottomuus_N = mkkN "kimmottomuus" ;
lin kimnaasi_N = mkkN "kimnaasi" ;
lin kimo_N = mkkN "kimo" ;
lin kimono_N = mkkN "kimono" ;
lin kimpaannus_N = mkkN "kimpaannus" ;
lin kimpaantua_V = mkkV "kimpaantua" ;
lin kimpale_N = mkkN "kimpale" ;
lin kimpi_N = mkkN "kimpi" ;
lin kimpoilla_V = mkkV "kimpoilla" ;
lin kimppa_N = mkkN "kimppa" ;
lin kimppu_N = mkkN "kimppu" ;
lin kimppuun_Adv = mkkAdv "kimppuun" ;
lin kimppuuntua_V = mkkV "kimppuuntua" ;
--? lin kimpsut_NK = {s = d01 "kimpsut" ;
lin kimpuittain_Adv = mkkAdv "kimpuittain" ;
lin kimpussa_Adv = mkkAdv "kimpussa" ;
lin kimpusta_Adv = mkkAdv "kimpusta" ;
lin kimputtaa_V = mkkV "kimputtaa" ;
lin kimputus_N = mkkN "kimputus" ;
lin kimro'o'kki_N = mkkN "kimröökki" ;
lin kimuli_N = mkkN "kimuli" ;
lin kimurantti_N = mkkN "kimurantti" ;
lin kina_1_N = mkkN "kina" ;
lin kina_2_N = mkkN "kina" ;
lin kinailla_V = mkkV "kinailla" ;
lin kinailu_N = mkkN "kinailu" ;
lin kinastella_V = mkkV "kinastella" ;
lin kinastelu_N = mkkN "kinastelu" ;
lin kinata_V = mkkV "kinata" ;
lin kineettinen_N = mkkN "kineettinen" ;
lin kinemaattinen_N = mkkN "kinemaattinen" ;
lin kinematiikka_N = mkkN "kinematiikka" ;
lin kinesteettinen_N = mkkN "kinesteettinen" ;
lin kinetiikka_N = mkkN "kinetiikka" ;
lin kingi_N = mkkN "kingi" ;
lin kiniini_N = mkkN "kiniini" ;
lin kinkata_V = mkkV "kinkata" ;
--? lin kinkerit_NK = {s = d06 "kinkerit" ;
lin kinkkinen_N = mkkN "kinkkinen" ;
lin kinkku_N = mkkN "kinkku" ;
lin kinnas_N = mkkN "kinnas" ;
lin kinner_N = mkkN "kinner" ;
lin kino_N = mkkN "kino" ;
lin kinos_N = mkkN "kinos" ;
lin kinostaa_V = mkkV "kinostaa" ;
lin kinostua_V = mkkV "kinostua" ;
lin kintere_N = mkkN "kintere" ;
lin kintereille_Adv = mkkAdv "kintereille" ;
lin kintereilla'_Adv = mkkAdv "kintereillä" ;
lin kintereilta'_Adv = mkkAdv "kintereiltä" ;
lin kinttu_N = mkkN "kinttu" ;
lin kinttuinen_N = mkkN "kinttuinen" ;
lin kinua_V = mkkV "kinua" ;
lin kinuski_N = mkkN "kinuski" ;
lin kinuta_V = mkkV "kinuta" ;
lin kioski_N = mkkN "kioski" ;
lin kipaista_V = mkkV "kipaista" ;
lin kipaisu_N = mkkN "kipaisu" ;
lin kipakasti_Adv = mkkAdv "kipakasti" ;
lin kipakka_N = mkkN "kipakka" ;
lin kipakkuus_N = mkkN "kipakkuus" ;
lin kipale_N = mkkN "kipale" ;
lin kipata_V = mkkV "kipata" ;
lin kipeno'ida'_V = mkkV "kipenöidä" ;
lin kipertya'_V = mkkV "kipertyä" ;
lin kiperta'a'_V = mkkV "kipertää" ;
lin kiperyys_N = mkkN "kiperyys" ;
lin kipera'_A = mkkA "kiperä" ;
lin kipera'sti_Adv = mkkAdv "kiperästi" ;
lin kipeys_N = mkkN "kipeys" ;
lin kipeytta'a'_V = mkkV "kipeyttää" ;
lin kipeytya'_V = mkkV "kipeytyä" ;
lin kipea'_A = mkkA "kipeä" ;
lin kipea'sti_Adv = mkkAdv "kipeästi" ;
lin kipin_kapin_Adv = mkkAdv "kipiC" ;
lin kipina'_N = mkkN "kipinä" ;
lin kipino'ida'_V = mkkV "kipinöidä" ;
lin kipino'inti_N = mkkN "kipinöinti" ;
lin kipitella'_V = mkkV "kipitellä" ;
lin kipitta'a'_V = mkkV "kipittää" ;
lin kipollinen_N = mkkN "kipollinen" ;
lin kippari_N = mkkN "kippari" ;
lin kipparoida_V = mkkV "kipparoida" ;
lin kippi_N = mkkN "kippi" ;
lin kippis_Adv = mkkAdv "kippis" ;
lin kippo_N = mkkN "kippo" ;
lin kippura_N = mkkN "kippura" ;
lin kippuraan_Adv = mkkAdv "kippuraan" ;
lin kippurainen_N = mkkN "kippurainen" ;
lin kippurassa_Adv = mkkAdv "kippurassa" ;
lin kipristella'_V = mkkV "kipristellä" ;
lin kipristya'_V = mkkV "kipristyä" ;
lin kiprista'a'_V = mkkV "kipristää" ;
lin kipsa_N = mkkN "kipsa" ;
lin kipsaantua_V = mkkV "kipsaantua" ;
lin kipsata_V = mkkV "kipsata" ;
lin kipsaus_N = mkkN "kipsaus" ;
lin kipsi_N = mkkN "kipsi" ;
lin kipsinen_N = mkkN "kipsinen" ;
lin kipu_N = mkkN "kipu" ;
lin kipuilla_V = mkkV "kipuilla" ;
lin kipuna_N = mkkN "kipuna" ;
lin kipunoida_V = mkkV "kipunoida" ;
lin kirahdus_N = mkkN "kirahdus" ;
lin kirahtaa_V = mkkV "kirahtaa" ;
lin kirahvi_N = mkkN "kirahvi" ;
lin kiramo_N = mkkN "kiramo" ;
lin kireta'_V = mkkV "kiretä" ;
lin kireys_N = mkkN "kireys" ;
lin kirea'_A = mkkA "kireä" ;
lin kirea'lle_Adv = mkkAdv "kireälle" ;
lin kirea'lla'_Adv = mkkAdv "kireällä" ;
lin kirea'pipoinen_N = mkkN "kireäpipoinen" ;
lin kirea'ssa'_Adv = mkkAdv "kireässä" ;
lin kirea'sti_Adv = mkkAdv "kireästi" ;
lin kirgiisi_N = mkkN "kirgiisi" ;
lin kiri_N = mkkN "kiri" ;
lin kirimoija_N = mkkN "kirimoija" ;
lin kiristeinen_N = mkkN "kiristeinen" ;
lin kiristella'_V = mkkV "kiristellä" ;
lin kiristely_N = mkkN "kiristely" ;
lin kiristin_N = mkkN "kiristin" ;
lin kiristyksissa'_Adv = mkkAdv "kiristyksissä" ;
lin kiristys_N = mkkN "kiristys" ;
lin kiristya'_V = mkkV "kiristyä" ;
lin kirista'ja'_N = mkkN "kiristäjä" ;
lin kirista'a'_V = mkkV "kiristää" ;
lin kiritta'ja'_N = mkkN "kirittäjä" ;
lin kiritta'a'_V = mkkV "kirittää" ;
lin kiria'_V = mkkV "kiriä" ;
lin kirja_N = mkkN "kirja" ;
lin kirjaamo_N = mkkN "kirjaamo" ;
lin kirjailija_N = mkkN "kirjailija" ;
lin kirjailla_V = mkkV "kirjailla" ;
lin kirjailu_N = mkkN "kirjailu" ;
lin kirjaimelleen_Adv = mkkAdv "kirjaimelleen" ;
lin kirjaimellinen_A = mkkA "kirjaimellinen" ;
lin kirjaimellisesti_Adv = mkkAdv "kirjaimellisesti" ;
lin kirjaiminen_N = mkkN "kirjaiminen" ;
lin kirjaimisto_N = mkkN "kirjaimisto" ;
lin kirjain_N = mkkN "kirjain" ;
lin kirjainkoko_N = mkkN "kirjainkoko" ;
lin kirjake_N = mkkN "kirjake" ;
lin kirjallinen_A = mkkA "kirjallinen" ;
lin kirjallisesti_Adv = mkkAdv "kirjallisesti" ;
lin kirjallisuus_N = mkkN "kirjallisuus" ;
lin kirjanen_N = mkkN "kirjanen" ;
lin kirjanpidollinen_A = mkkA "kirjanpidollinen" ;
lin kirjanpidollisesti_Adv = mkkAdv "kirjanpidollisesti" ;
lin kirjasin_N = mkkN "kirjasin" ;
lin kirjasinkoko_N = mkkN "kirjasinkoko" ;
lin kirjasto_N = mkkN "kirjasto" ;
lin kirjata_V = mkkV "kirjata" ;
lin kirjaus_N = mkkN "kirjaus" ;
lin kirjauttaa_V = mkkV "kirjauttaa" ;
lin kirjava_A = mkkA "kirjava" ;
lin kirjavasti_Adv = mkkAdv "kirjavasti" ;
lin kirjavoida_V = mkkV "kirjavoida" ;
lin kirjavoittaa_V = mkkV "kirjavoittaa" ;
lin kirjavoitua_V = mkkV "kirjavoitua" ;
lin kirjavuus_N = mkkN "kirjavuus" ;
lin kirje_N = mkkN "kirje" ;
lin kirjeellinen_A = mkkA "kirjeellinen" ;
lin kirjeellisesti_Adv = mkkAdv "kirjeellisesti" ;
lin kirjeitse_Adv = mkkAdv "kirjeitse" ;
lin kirjelma'_N = mkkN "kirjelmä" ;
lin kirjelmo'ida'_V = mkkV "kirjelmöidä" ;
lin kirjelmo'inti_N = mkkN "kirjelmöinti" ;
lin kirjo_N = mkkN "kirjo" ;
lin kirjoa_V = mkkV "kirjoa" ;
lin kirjoinen_N = mkkN "kirjoinen" ;
lin kirjoite_N = mkkN "kirjoite" ;
lin kirjoitella_V = mkkV "kirjoitella" ;
lin kirjoitelma_N = mkkN "kirjoitelma" ;
lin kirjoitin_N = mkkN "kirjoitin" ;
lin kirjoittaa_V = mkkV "kirjoittaa" ;
lin kirjoittaja_N = mkkN "kirjoittaja" ;
lin kirjoittamaton_N = mkkN "kirjoittamaton" ;
lin kirjoittautua_V = mkkV "kirjoittautua" ;
lin kirjoittelu_N = mkkN "kirjoittelu" ;
lin kirjoittua_V = mkkV "kirjoittua" ;
lin kirjoitus_N = mkkN "kirjoitus" ;
lin kirjoituttaa_V = mkkV "kirjoituttaa" ;
lin kirjomus_N = mkkN "kirjomus" ;
lin kirjonta_N = mkkN "kirjonta" ;
lin kirjontainen_N = mkkN "kirjontainen" ;
lin kirjuri_N = mkkN "kirjuri" ;
lin kirkaista_V = mkkV "kirkaista" ;
lin kirkaisu_N = mkkN "kirkaisu" ;
lin kirkas_A = mkkA "kirkas" ;
lin kirkastaa_V = mkkV "kirkastaa" ;
lin kirkaste_N = mkkN "kirkaste" ;
lin kirkastua_V = mkkV "kirkastua" ;
lin kirkastus_N = mkkN "kirkastus" ;
lin kirkastuttaa_V = mkkV "kirkastuttaa" ;
lin kirkasvaloinen_N = mkkN "kirkasvaloinen" ;
lin kirkkaasti_Adv = mkkAdv "kirkkaasti" ;
lin kirkkaus_N = mkkN "kirkkaus" ;
lin kirkko_N = mkkN "kirkko" ;
lin kirkkoaika_N = mkkN "kirkkoaika" ;
lin kirkollinen_A = mkkA "kirkollinen" ;
lin kirkollisesti_Adv = mkkAdv "kirkollisesti" ;
lin kirkollisuus_N = mkkN "kirkollisuus" ;
lin kirkonaika_N = mkkN "kirkonaika" ;
lin kirkua_V = mkkV "kirkua" ;
lin kirkuna_N = mkkN "kirkuna" ;
lin kirkuva_N = mkkN "kirkuva" ;
lin kirmailla_V = mkkV "kirmailla" ;
lin kirmaista_V = mkkV "kirmaista" ;
lin kirmata_V = mkkV "kirmata" ;
lin kirnu_N = mkkN "kirnu" ;
lin kirnuta_V = mkkV "kirnuta" ;
lin kirnuuntua_V = mkkV "kirnuuntua" ;
lin kirnuutua_V = mkkV "kirnuutua" ;
lin kiro_N = mkkN "kiro" ;
lin kiroilija_N = mkkN "kiroilija" ;
lin kiroilla_V = mkkV "kiroilla" ;
lin kiroilu_N = mkkN "kiroilu" ;
lin kiroiluttaa_V = mkkV "kiroiluttaa" ;
lin kirota_V = mkkV "kirota" ;
lin kirottu_N = mkkN "kirottu" ;
lin kirotusti_Adv = mkkAdv "kirotusti" ;
lin kirous_N = mkkN "kirous" ;
lin kirpaista_V = mkkV "kirpaista" ;
lin kirpaisu_N = mkkN "kirpaisu" ;
lin kirpakka_N = mkkN "kirpakka" ;
lin kirpeys_N = mkkN "kirpeys" ;
lin kirpeytta'a'_V = mkkV "kirpeyttää" ;
lin kirpeytya'_V = mkkV "kirpeytyä" ;
lin kirpea'_A = mkkA "kirpeä" ;
lin kirpea'sti_Adv = mkkAdv "kirpeästi" ;
lin kirppa_N = mkkN "kirppa" ;
lin kirppari_N = mkkN "kirppari" ;
lin kirppis_N = mkkN "kirppis" ;
lin kirppu_N = mkkN "kirppu" ;
lin kirroosi_N = mkkN "kirroosi" ;
lin kirroottinen_N = mkkN "kirroottinen" ;
lin kirsi_N = mkkN "kirsi" ;
lin kirsikka_N = mkkN "kirsikka" ;
lin kirskahdus_N = mkkN "kirskahdus" ;
lin kirskahtaa_V = mkkV "kirskahtaa" ;
lin kirskaus_N = mkkN "kirskaus" ;
lin kirskauttaa_V = mkkV "kirskauttaa" ;
lin kirskua_V = mkkV "kirskua" ;
lin kirskuna_N = mkkN "kirskuna" ;
lin kirskunta_N = mkkN "kirskunta" ;
lin kirskuttaa_V = mkkV "kirskuttaa" ;
lin kirskutus_N = mkkN "kirskutus" ;
lin kirstu_N = mkkN "kirstu" ;
lin kirsu_N = mkkN "kirsu" ;
lin kirurgi_N = mkkN "kirurgi" ;
lin kirurgia_N = mkkN "kirurgia" ;
lin kirurginen_A = mkkA "kirurginen" ;
lin kirurgisesti_Adv = mkkAdv "kirurgisesti" ;
lin kirva_N = mkkN "kirva" ;
lin kirveli_N = mkkN "kirveli" ;
lin kirvellys_N = mkkN "kirvellys" ;
lin kirvella'_V = mkkV "kirvellä" ;
lin kirvelta'a'_V = mkkV "kirveltää" ;
lin kirvely_N = mkkN "kirvely" ;
lin kirves_N = mkkN "kirves" ;
lin kirvinen_N = mkkN "kirvinen" ;
lin kirvoittaa_V = mkkV "kirvoittaa" ;
lin kirvota_V = mkkV "kirvota" ;
lin kis_Adv = mkkAdv "kis" ;
lin kisa_N = mkkN "kisa" ;
lin kisailija_N = mkkN "kisailija" ;
lin kisailla_V = mkkV "kisailla" ;
lin kisailu_N = mkkN "kisailu" ;
lin kisata_V = mkkV "kisata" ;
lin kiska_N = mkkN "kiska" ;
lin kiskaista_V = mkkV "kiskaista" ;
lin kiskaisu_N = mkkN "kiskaisu" ;
lin kisko_N = mkkN "kisko" ;
lin kiskoa_V = mkkV "kiskoa" ;
lin kiskoinen_1_N = mkkN "kiskoinen" ;
lin kiskoinen_2_N = mkkN "kiskoinen" ;
lin kiskoja_N = mkkN "kiskoja" ;
lin kiskonta_N = mkkN "kiskonta" ;
lin kiskotella_V = mkkV "kiskotella" ;
lin kiskottaa_1_V = mkkV "kiskottaa" ;
lin kiskottaa_2_V = mkkV "kiskottaa" ;
lin kiskottelu_N = mkkN "kiskottelu" ;
lin kiskotus_N = mkkN "kiskotus" ;
lin kiskoutua_V = mkkV "kiskoutua" ;
lin kismitta'a'_V = mkkV "kismittää" ;
lin kissa_N = mkkN "kissa" ;
lin kissanha'nna'nveto_N = mkkN "kissanhännänveto" ;
lin kissus_N = mkkN "kissus" ;
lin kisu_N = mkkN "kisu" ;
lin kita_N = mkkN "kita" ;
lin kitara_N = mkkN "kitara" ;
lin kitata_V = mkkV "kitata" ;
lin kiteeto'n_N = mkkN "kiteetön" ;
lin kiteinen_N = mkkN "kiteinen" ;
lin kiteisyys_N = mkkN "kiteisyys" ;
lin kiteyma'_N = mkkN "kiteymä" ;
lin kiteytta'a'_V = mkkV "kiteyttää" ;
lin kiteytyma'_N = mkkN "kiteytymä" ;
lin kiteytys_N = mkkN "kiteytys" ;
lin kiteytya'_V = mkkV "kiteytyä" ;
lin kitiini_N = mkkN "kitiini" ;
lin kitina'_N = mkkN "kitinä" ;
lin kitistya'_V = mkkV "kitistyä" ;
lin kitista'_V = mkkV "kitistä" ;
lin kitka_N = mkkN "kitka" ;
lin kitkainen_N = mkkN "kitkainen" ;
lin kitkakerroin_N = mkkN "kitkakerroin" ;
lin kitkaton_N = mkkN "kitkaton" ;
lin kitkattomasti_Adv = mkkAdv "kitkattomasti" ;
lin kitkenta'_N = mkkN "kitkentä" ;
lin kitkeryys_N = mkkN "kitkeryys" ;
lin kitkera'_A = mkkA "kitkerä" ;
lin kitkera'sti_Adv = mkkAdv "kitkerästi" ;
lin kitkero'_N = mkkN "kitkerö" ;
lin kitkero'itta'a'_V = mkkV "kitkeröittää" ;
lin kitkero'itya'_V = mkkV "kitkeröityä" ;
lin kitkea'_V = mkkV "kitkeä" ;
lin kitku_N = mkkN "kitku" ;
lin kitkutella_V = mkkV "kitkutella" ;
lin kitkuttaa_V = mkkV "kitkuttaa" ;
lin kitkutus_N = mkkN "kitkutus" ;
lin kitsaasti_Adv = mkkAdv "kitsaasti" ;
lin kitsas_A = mkkA "kitsas" ;
lin kitsastella_V = mkkV "kitsastella" ;
lin kitsastelu_N = mkkN "kitsastelu" ;
lin kitsaus_N = mkkN "kitsaus" ;
lin kitsch_N = mkkN "kitsch" ;
lin kitsi_1_N = mkkN "kitsi" ;
lin kitsi_2_N = mkkN "kitsi" ;
lin kittaus_N = mkkN "kittaus" ;
lin kitti_N = mkkN "kitti" ;
lin kitua_V = mkkV "kitua" ;
lin kitukuusi_N = mkkN "kitukuusi" ;
lin kituliaasti_Adv = mkkAdv "kituliaasti" ;
lin kituliaisuus_N = mkkN "kituliaisuus" ;
lin kitulias_A = mkkA "kitulias" ;
lin kitupiikki_N = mkkN "kitupiikki" ;
--? lin kituset_NK = {s = d38 "kituset" ;
lin kituuttaa_V = mkkV "kituuttaa" ;
lin kiuas_N = mkkN "kiuas" ;
lin kiukku_N = mkkN "kiukku" ;
lin kiukkuilla_V = mkkV "kiukkuilla" ;
lin kiukkuinen_A = mkkA "kiukkuinen" ;
lin kiukkuisesti_Adv = mkkAdv "kiukkuisesti" ;
lin kiukuissaan_Adv = mkkAdv "kiukuissaan" ;
lin kiukustua_V = mkkV "kiukustua" ;
lin kiukutella_V = mkkV "kiukutella" ;
lin kiukuttaa_V = mkkV "kiukuttaa" ;
lin kiukuttelija_N = mkkN "kiukuttelija" ;
lin kiukuttelu_N = mkkN "kiukuttelu" ;
lin kiulu_N = mkkN "kiulu" ;
lin kiulukka_N = mkkN "kiulukka" ;
lin kiuru_N = mkkN "kiuru" ;
lin kiusa_N = mkkN "kiusa" ;
lin kiusaaja_N = mkkN "kiusaaja" ;
lin kiusaantua_V = mkkV "kiusaantua" ;
lin kiusallinen_A = mkkA "kiusallinen" ;
lin kiusallisesti_Adv = mkkAdv "kiusallisesti" ;
lin kiusallisuus_N = mkkN "kiusallisuus" ;
lin kiusata_V = mkkV "kiusata" ;
lin kiusaus_N = mkkN "kiusaus" ;
lin kiusoitella_V = mkkV "kiusoitella" ;
lin kiusoittelu_N = mkkN "kiusoittelu" ;
lin kiva_A = mkkA "kiva" ;
lin kivahdus_N = mkkN "kivahdus" ;
lin kivahtaa_V = mkkV "kivahtaa" ;
lin kivasti_Adv = mkkAdv "kivasti" ;
lin kivelio'_N = mkkN "kiveliö" ;
lin kivellinen_N = mkkN "kivellinen" ;
lin kivenhioja_N = mkkN "kivenhioja" ;
lin kivennuoliainen_N = mkkN "kivennuoliainen" ;
lin kivenna'inen_N = mkkN "kivennäinen" ;
lin kivertya'_V = mkkV "kivertyä" ;
lin kiverta'a'_V = mkkV "kivertää" ;
lin kiveryys_N = mkkN "kiveryys" ;
lin kivera'_A = mkkA "kiverä" ;
lin kivera'sti_Adv = mkkAdv "kiverästi" ;
lin kives_N = mkkN "kives" ;
lin kivesta'a'_V = mkkV "kivestää" ;
lin kivettyma'_N = mkkN "kivettymä" ;
lin kivettyneisyys_N = mkkN "kivettyneisyys" ;
lin kivettya'_V = mkkV "kivettyä" ;
lin kivetta'a'_V = mkkV "kivettää" ;
lin kivetys_N = mkkN "kivetys" ;
lin kiveta'_V = mkkV "kivetä" ;
lin kiveyma'_N = mkkN "kiveymä" ;
lin kiveys_N = mkkN "kiveys" ;
lin kiveytyma'_N = mkkN "kiveytymä" ;
lin kivi_N = mkkN "kivi" ;
lin kiwi_N = mkkN "kiwi" ;
lin kivikko_N = mkkN "kivikko" ;
lin kivikkoinen_N = mkkN "kivikkoinen" ;
lin kivikkoisuus_N = mkkN "kivikkoisuus" ;
lin kivinen_N = mkkN "kivinen" ;
lin kivipiira_N = mkkN "kivipiira" ;
lin kivistys_N = mkkN "kivistys" ;
lin kivista'a'_V = mkkV "kivistää" ;
lin kivisyys_N = mkkN "kivisyys" ;
lin kivitta'a'_V = mkkV "kivittää" ;
lin kivitys_N = mkkN "kivitys" ;
lin kivuliaasti_Adv = mkkAdv "kivuliaasti" ;
lin kivulias_A = mkkA "kivulias" ;
lin kivullinen_N = mkkN "kivullinen" ;
lin kivulloinen_N = mkkN "kivulloinen" ;
lin kivulloisuus_N = mkkN "kivulloisuus" ;
lin kivuta_V = mkkV "kivuta" ;
lin kivuton_N = mkkN "kivuton" ;
lin kivuttomasti_Adv = mkkAdv "kivuttomasti" ;
lin kivuttomuus_N = mkkN "kivuttomuus" ;
lin kiva'a'ri_N = mkkN "kivääri" ;
lin klaani_N = mkkN "klaani" ;
lin klaarata_V = mkkV "klaarata" ;
lin klaava_N = mkkN "klaava" ;
lin klaavi_N = mkkN "klaavi" ;
lin klaffi_N = mkkN "klaffi" ;
lin klahvi_N = mkkN "klahvi" ;
lin klamydia_N = mkkN "klamydia" ;
lin klani_N = mkkN "klani" ;
lin klapi_N = mkkN "klapi" ;
lin klappi_N = mkkN "klappi" ;
lin klarinetisti_N = mkkN "klarinetisti" ;
lin klarinetti_N = mkkN "klarinetti" ;
lin klarkia_N = mkkN "klarkia" ;
lin klassifikaatio_N = mkkN "klassifikaatio" ;
lin klassifioida_V = mkkV "klassifioida" ;
lin klassifiointi_N = mkkN "klassifiointi" ;
lin klassikko_N = mkkN "klassikko" ;
lin klassillinen_N = mkkN "klassillinen" ;
lin klassinen_A = mkkA "klassinen" ;
lin klassisesti_Adv = mkkAdv "klassisesti" ;
lin klassisismi_N = mkkN "klassisismi" ;
lin klassisistinen_N = mkkN "klassisistinen" ;
lin klassisuus_N = mkkN "klassisuus" ;
lin klaustrofobia_N = mkkN "klaustrofobia" ;
lin klausuuli_N = mkkN "klausuuli" ;
lin klematis_N = mkkN "klematis" ;
lin klementiini_N = mkkN "klementiini" ;
lin klemmari_N = mkkN "klemmari" ;
lin kleptomaani_N = mkkN "kleptomaani" ;
lin kleptomaaninen_N = mkkN "kleptomaaninen" ;
lin kleptomania_N = mkkN "kleptomania" ;
lin kliimaksi_N = mkkN "kliimaksi" ;
lin kliinikko_N = mkkN "kliinikko" ;
lin kliininen_A = mkkA "kliininen" ;
lin kliinisesti_Adv = mkkAdv "kliinisesti" ;
lin kliivia_N = mkkN "kliivia" ;
lin klikata_V = mkkV "klikata" ;
lin klikki_N = mkkN "klikki" ;
lin klikkiytya'_V = mkkV "klikkiytyä" ;
lin klimakteerinen_N = mkkN "klimakteerinen" ;
lin klimakterium_N = mkkN "klimakterium" ;
lin klimatologia_N = mkkN "klimatologia" ;
lin klimppi_N = mkkN "klimppi" ;
lin klimppiytya'_V = mkkV "klimppiytyä" ;
lin klinikka_N = mkkN "klinikka" ;
lin klinkkeri_N = mkkN "klinkkeri" ;
lin klipsi_N = mkkN "klipsi" ;
lin klisee_N = mkkN "klisee" ;
lin kliseytya'_V = mkkV "kliseytyä" ;
lin klitoris_N = mkkN "klitoris" ;
lin kloaakki_N = mkkN "kloaakki" ;
lin kloonata_V = mkkV "kloonata" ;
lin kloonaus_N = mkkN "kloonaus" ;
lin klooni_N = mkkN "klooni" ;
lin kloorata_V = mkkV "kloorata" ;
lin klooraus_N = mkkN "klooraus" ;
lin kloori_N = mkkN "kloori" ;
lin kloorittaa_V = mkkV "kloorittaa" ;
lin klooritus_N = mkkN "klooritus" ;
lin klootti_N = mkkN "klootti" ;
lin kloppi_N = mkkN "kloppi" ;
lin klorofylli_N = mkkN "klorofylli" ;
lin klosetti_N = mkkN "klosetti" ;
lin klovni_N = mkkN "klovni" ;
lin klubi_N = mkkN "klubi" ;
lin klusteri_N = mkkN "klusteri" ;
lin kluutti_N = mkkN "kluutti" ;
lin klo'ntti_N = mkkN "klöntti" ;
lin knalli_N = mkkN "knalli" ;
lin knesset_N = mkkN "knesset" ;
lin knock_out_N = mkkN "knock-out" ;
lin knoppi_N = mkkN "knoppi" ;
lin knoppologia_N = mkkN "knoppologia" ;
lin knorri_N = mkkN "knorri" ;
lin know_how_N = mkkN "know-how" ;
lin koagulaatio_N = mkkN "koagulaatio" ;
lin koaguloida_V = mkkV "koaguloida" ;
lin koagulointi_N = mkkN "koagulointi" ;
lin koaguloitua_V = mkkV "koaguloitua" ;
lin koaksiaalinen_N = mkkN "koaksiaalinen" ;
lin koala_N = mkkN "koala" ;
lin koalitio_N = mkkN "koalitio" ;
lin koboltti_N = mkkN "koboltti" ;
lin kobra_N = mkkN "kobra" ;
lin kodeiini_N = mkkN "kodeiini" ;
lin kodifikaatio_N = mkkN "kodifikaatio" ;
lin kodifioida_V = mkkV "kodifioida" ;
lin kodifiointi_N = mkkN "kodifiointi" ;
lin kodikas_A = mkkA "kodikas" ;
lin kodikkaasti_Adv = mkkAdv "kodikkaasti" ;
lin kodikkuus_N = mkkN "kodikkuus" ;
lin koditon_N = mkkN "koditon" ;
lin kodittomuus_N = mkkN "kodittomuus" ;
lin koe_N = mkkN "koe" ;
lin koeaika_N = mkkN "koeaika" ;
lin koeffisientti_N = mkkN "koeffisientti" ;
lin koestaa_V = mkkV "koestaa" ;
lin koestus_N = mkkN "koestus" ;
lin koetella_V = mkkV "koetella" ;
lin koetin_N = mkkN "koetin" ;
lin koettaa_V = mkkV "koettaa" ;
lin koetteeksi_Adv = mkkAdv "koetteeksi" ;
lin koetteella_Adv = mkkAdv "koetteella" ;
lin koetteelle_Adv = mkkAdv "koetteelle" ;
lin koetteilla_Adv = mkkAdv "koetteilla" ;
lin koetteille_Adv = mkkAdv "koetteille" ;
lin koettelemus_N = mkkN "koettelemus" ;
lin koettelu_N = mkkN "koettelu" ;
lin koetus_N = mkkN "koetus" ;
lin kofeiini_N = mkkN "kofeiini" ;
lin kognitiivinen_N = mkkN "kognitiivinen" ;
lin kognitio_N = mkkN "kognitio" ;
lin kohahdella_V = mkkV "kohahdella" ;
lin kohahdus_N = mkkN "kohahdus" ;
lin kohahduttaa_V = mkkV "kohahduttaa" ;
lin kohahtaa_V = mkkV "kohahtaa" ;
lin kohaus_N = mkkN "kohaus" ;
lin kohautella_V = mkkV "kohautella" ;
lin kohauttaa_1_V = mkkV "kohauttaa" ;
lin kohauttaa_2_V = mkkV "kohauttaa" ;
lin kohautus_N = mkkN "kohautus" ;
lin kohdakkain_Adv = mkkAdv "kohdakkain" ;
lin kohdakkoin_Adv = mkkAdv "kohdakkoin" ;
lin kohdata_V = mkkV "kohdata" ;
lin kohdatusten_Adv = mkkAdv "kohdatusten" ;
lin kohde_N = mkkN "kohde" ;
lin kohdella_V = mkkV "kohdella" ;
lin kohden_Adv = mkkAdv "kohden" ;
lin kohdentaa_V = mkkV "kohdentaa" ;
lin kohdentua_V = mkkV "kohdentua" ;
lin kohdistaa_V = mkkV "kohdistaa" ;
lin kohdistin_N = mkkN "kohdistin" ;
lin kohdistua_V = mkkV "kohdistua" ;
lin kohdistus_N = mkkN "kohdistus" ;
lin kohdittain_Adv = mkkAdv "kohdittain" ;
lin kohdittainen_N = mkkN "kohdittainen" ;
lin koheesio_N = mkkN "koheesio" ;
lin koheli_N = mkkN "koheli" ;
lin kohelo_N = mkkN "kohelo" ;
lin koheloida_V = mkkV "koheloida" ;
lin koheltaa_V = mkkV "koheltaa" ;
lin kohennella_V = mkkV "kohennella" ;
lin kohennus_N = mkkN "kohennus" ;
lin kohentaa_V = mkkV "kohentaa" ;
lin kohentua_V = mkkV "kohentua" ;
lin koherenssi_N = mkkN "koherenssi" ;
lin koherentti_N = mkkN "koherentti" ;
lin koheta_V = mkkV "koheta" ;
lin kohina_N = mkkN "kohina" ;
lin kohista_V = mkkV "kohista" ;
lin kohmeeseen_Adv = mkkAdv "kohmeeseen" ;
lin kohmeessa_Adv = mkkAdv "kohmeessa" ;
lin kohmeinen_N = mkkN "kohmeinen" ;
lin kohmelo_N = mkkN "kohmelo" ;
lin kohmeloinen_N = mkkN "kohmeloinen" ;
lin kohmettaa_V = mkkV "kohmettaa" ;
lin kohmettua_V = mkkV "kohmettua" ;
lin kohmetus_N = mkkN "kohmetus" ;
lin koho_N = mkkN "koho" ;
lin kohoama_N = mkkN "kohoama" ;
lin kohoilla_V = mkkV "kohoilla" ;
lin kohokas_N = mkkN "kohokas" ;
lin kohokki_N = mkkN "kohokki" ;
lin kohokohta_N = mkkN "kohokohta" ;
lin koholla_Adv = mkkAdv "koholla" ;
lin kohollaan_Adv = mkkAdv "kohollaan" ;
lin koholle_Adv = mkkAdv "koholle" ;
lin koholleen_Adv = mkkAdv "koholleen" ;
lin kohortti_N = mkkN "kohortti" ;
lin kohota_V = mkkV "kohota" ;
lin kohottaa_V = mkkV "kohottaa" ;
lin kohottaja_N = mkkN "kohottaja" ;
lin kohottautua_V = mkkV "kohottautua" ;
lin kohotus_N = mkkN "kohotus" ;
lin kohouma_N = mkkN "kohouma" ;
lin kohoutuma_N = mkkN "kohoutuma" ;
lin kohta_1_N = mkkN "kohta" ;
lin kohta_2_Adv = mkkAdv "kohta" ;
lin kohtaan_Adv = mkkAdv "kohtaan" ;
lin kohtainen_A = mkkA "kohtainen" ;
lin kohtaisesti_Adv = mkkAdv "kohtaisesti" ;
lin kohtaisuus_N = mkkN "kohtaisuus" ;
lin kohtalaisesti_Adv = mkkAdv "kohtalaisesti" ;
lin kohtalo_N = mkkN "kohtalo" ;
lin kohtalokas_A = mkkA "kohtalokas" ;
lin kohtalokkaasti_Adv = mkkAdv "kohtalokkaasti" ;
lin kohtalokkuus_N = mkkN "kohtalokkuus" ;
lin kohtalotar_N = mkkN "kohtalotar" ;
lin kohtapuoliin_Adv = mkkAdv "kohtapuoliin" ;
lin kohtapuolin_Adv = mkkAdv "kohtapuolin" ;
lin kohtauksittain_Adv = mkkAdv "kohtauksittain" ;
lin kohtauksittainen_N = mkkN "kohtauksittainen" ;
lin kohtaus_N = mkkN "kohtaus" ;
lin kohteliaasti_Adv = mkkAdv "kohteliaasti" ;
lin kohteliaisuus_N = mkkN "kohteliaisuus" ;
lin kohtelias_A = mkkA "kohtelias" ;
lin kohtelu_N = mkkN "kohtelu" ;
lin kohti_Adv = mkkAdv "kohti" ;
lin kohtio_N = mkkN "kohtio" ;
lin kohtu_N = mkkN "kohtu" ;
lin kohtuullinen_A = mkkA "kohtuullinen" ;
lin kohtuullisesti_Adv = mkkAdv "kohtuullisesti" ;
lin kohtuullisuus_N = mkkN "kohtuullisuus" ;
lin kohtuus_N = mkkN "kohtuus" ;
lin kohtuuton_N = mkkN "kohtuuton" ;
lin kohtuuttomasti_Adv = mkkAdv "kohtuuttomasti" ;
lin kohtuuttomuus_N = mkkN "kohtuuttomuus" ;
lin kohu_N = mkkN "kohu" ;
lin kohuta_V = mkkV "kohuta" ;
lin kohva_N = mkkN "kohva" ;
lin koi_1_N = mkkN "koi" ;
lin koi_2_N = mkkN "koi" ;
lin koikkelehtia_V = mkkV "koikkelehtia" ;
lin koillinen_N = mkkN "koillinen" ;
lin koilliskolkka_N = mkkN "koilliskolkka" ;
lin koinsyo'ma'_N = mkkN "koinsyömä" ;
lin koipeliini_N = mkkN "koipeliini" ;
lin koipi_N = mkkN "koipi" ;
lin koipinen_N = mkkN "koipinen" ;
lin koira_N = mkkN "koira" ;
lin koirankeksi_N = mkkN "koirankeksi" ;
lin koirankoppi_N = mkkN "koirankoppi" ;
lin koiras_N = mkkN "koiras" ;
lin koiruus_N = mkkN "koiruus" ;
lin koisa_N = mkkN "koisa" ;
lin koisata_V = mkkV "koisata" ;
lin koisia_V = mkkV "koisia" ;
lin koiso_N = mkkN "koiso" ;
lin koite_N = mkkN "koite" ;
lin koitos_N = mkkN "koitos" ;
lin koittaa_V = mkkV "koittaa" ;
lin koitto_N = mkkN "koitto" ;
lin koitua_V = mkkV "koitua" ;
lin koitus_N = mkkN "koitus" ;
lin koivikko_N = mkkN "koivikko" ;
lin koivikkoinen_N = mkkN "koivikkoinen" ;
lin koivisto_N = mkkN "koivisto" ;
lin koivu_N = mkkN "koivu" ;
lin koivuinen_N = mkkN "koivuinen" ;
lin koje_N = mkkN "koje" ;
lin kojeistaa_V = mkkV "kojeistaa" ;
lin kojeisto_N = mkkN "kojeisto" ;
lin kojootti_N = mkkN "kojootti" ;
lin koju_N = mkkN "koju" ;
lin kokaiini_N = mkkN "kokaiini" ;
lin kokainismi_N = mkkN "kokainismi" ;
lin kokainisti_N = mkkN "kokainisti" ;
lin kokardi_N = mkkN "kokardi" ;
lin kokata_V = mkkV "kokata" ;
lin kokea_V = mkkV "kokea" ;
lin kokeeksi_Adv = mkkAdv "kokeeksi" ;
lin kokeellinen_A = mkkA "kokeellinen" ;
lin kokeellisesti_Adv = mkkAdv "kokeellisesti" ;
lin kokeilla_V = mkkV "kokeilla" ;
lin kokeilu_N = mkkN "kokeilu" ;
lin kokelas_N = mkkN "kokelas" ;
lin kokelasaika_N = mkkN "kokelasaika" ;
lin kokematon_N = mkkN "kokematon" ;
lin kokemattomuus_N = mkkN "kokemattomuus" ;
lin kokemus_N = mkkN "kokemus" ;
lin kokemuspera'isesti_Adv = mkkAdv "kokemusperäisesti" ;
lin kokeneesti_Adv = mkkAdv "kokeneesti" ;
lin kokeneisuus_N = mkkN "kokeneisuus" ;
lin kokenut_A = mkkA "kokenut" ;
lin koketeerata_V = mkkV "koketeerata" ;
lin koketteria_N = mkkN "koketteria" ;
lin koketti_N = mkkN "koketti" ;
lin kokka_N = mkkN "kokka" ;
lin kokkaaja_N = mkkN "kokkaaja" ;
lin kokkailla_V = mkkV "kokkailla" ;
lin kokkainen_N = mkkN "kokkainen" ;
lin kokkare_N = mkkN "kokkare" ;
lin kokkareinen_N = mkkN "kokkareinen" ;
--? lin kokkarit_NK = {s = d06 "kokkarit" ;
lin kokkaroitua_V = mkkV "kokkaroitua" ;
lin kokkaus_N = mkkN "kokkaus" ;
lin kokkeli_N = mkkN "kokkeli" ;
lin kokki_1_N = mkkN "kokki" ;
lin kokki_2_N = mkkN "kokki" ;
lin kokko_1_N = mkkN "kokko" ;
lin kokko_2_N = mkkN "kokko" ;
lin koko_1_N = mkkN "koko" ;
lin koko_2_Adv = mkkAdv "koko" ;
lin kokoaja_N = mkkN "kokoaja" ;
lin kokoelma_N = mkkN "kokoelma" ;
lin kokoilla_V = mkkV "kokoilla" ;
lin kokoinen_N = mkkN "kokoinen" ;
lin kokonaan_Adv = mkkAdv "kokonaan" ;
lin kokonaisvaltaisesti_Adv = mkkAdv "kokonaisvaltaisesti" ;
lin kokoomus_N = mkkN "kokoomus" ;
lin kokoon_Adv = mkkAdv "kokoon" ;
lin kokoonpanna_V = mkkV "kokoonpanna" ;
lin kokoonpantava_N = mkkN "kokoonpantava" ;
lin kokoontaitettava_N = mkkN "kokoontaitettava" ;
lin kokoontua_V = mkkV "kokoontua" ;
lin kokopa'iva'toiminen_N = mkkN "kokopäivätoiminen" ;
lin kokotti_N = mkkN "kokotti" ;
lin kokouma_N = mkkN "kokouma" ;
lin kokous_N = mkkN "kokous" ;
lin kokoustaa_V = mkkV "kokoustaa" ;
lin kokoutua_V = mkkV "kokoutua" ;
lin kokoutuma_N = mkkN "kokoutuma" ;
lin koksaamo_N = mkkN "koksaamo" ;
lin koksata_V = mkkV "koksata" ;
lin koksautua_V = mkkV "koksautua" ;
lin koksi_N = mkkN "koksi" ;
lin koksiintua_V = mkkV "koksiintua" ;
lin koksittaa_V = mkkV "koksittaa" ;
lin koksittamo_N = mkkN "koksittamo" ;
lin koksittua_V = mkkV "koksittua" ;
lin koksiutua_V = mkkV "koksiutua" ;
lin koktaili_N = mkkN "koktaili" ;
lin kola_N = mkkN "kola" ;
lin kolahdella_V = mkkV "kolahdella" ;
lin kolahdus_N = mkkN "kolahdus" ;
lin kolahtaa_V = mkkV "kolahtaa" ;
lin kolari_N = mkkN "kolari" ;
lin kolaroida_V = mkkV "kolaroida" ;
lin kolaroimaton_N = mkkN "kolaroimaton" ;
lin kolata_V = mkkV "kolata" ;
lin kolaus_N = mkkN "kolaus" ;
lin kolauttaa_V = mkkV "kolauttaa" ;
lin kolea_A = mkkA "kolea" ;
lin koleasti_Adv = mkkAdv "koleasti" ;
lin koleerikko_N = mkkN "koleerikko" ;
lin koleerinen_N = mkkN "koleerinen" ;
lin kolehti_N = mkkN "kolehti" ;
lin kolera_N = mkkN "kolera" ;
lin kolesteroli_N = mkkN "kolesteroli" ;
lin koleus_N = mkkN "koleus" ;
lin kolhaista_V = mkkV "kolhaista" ;
lin kolhaisu_N = mkkN "kolhaisu" ;
lin kolhia_V = mkkV "kolhia" ;
lin kolhiintua_V = mkkV "kolhiintua" ;
lin kolhiintuma_N = mkkN "kolhiintuma" ;
lin kolhiutua_V = mkkV "kolhiutua" ;
lin kolhiutuma_N = mkkN "kolhiutuma" ;
lin kolho_N = mkkN "kolho" ;
lin kolhoosi_N = mkkN "kolhoosi" ;
lin kolhu_N = mkkN "kolhu" ;
lin kolibri_N = mkkN "kolibri" ;
lin koliikki_N = mkkN "koliikki" ;
lin kolikko_N = mkkN "kolikko" ;
lin kolina_1_N = mkkN "kolina" ;
lin kolina_2_N = mkkN "kolina" ;
lin kolista_V = mkkV "kolista" ;
lin kolistaa_V = mkkV "kolistaa" ;
lin kolistella_V = mkkV "kolistella" ;
lin kolisuttaa_V = mkkV "kolisuttaa" ;
lin kolja_N = mkkN "kolja" ;
lin koljatti_N = mkkN "koljatti" ;
lin kolkata_1_V = mkkV "kolkata" ;
lin kolkata_2_V = mkkV "kolkata" ;
lin kolke_N = mkkN "kolke" ;
lin kolkka_1_N = mkkN "kolkka" ;
lin kolkka_2_N = mkkN "kolkka" ;
lin kolkkaa_V = mkkV "kolkkaa" ;
lin kolkko_N = mkkN "kolkko" ;
lin kolkkous_N = mkkN "kolkkous" ;
lin kolkosti_Adv = mkkAdv "kolkosti" ;
lin kolkutella_V = mkkV "kolkutella" ;
lin kolkutin_N = mkkN "kolkutin" ;
lin kolkuttaa_V = mkkV "kolkuttaa" ;
lin kolkutus_N = mkkN "kolkutus" ;
lin kollaasi_N = mkkN "kollaasi" ;
lin kollageeni_N = mkkN "kollageeni" ;
lin kollapsi_N = mkkN "kollapsi" ;
lin kollata_V = mkkV "kollata" ;
lin kollega_N = mkkN "kollega" ;
lin kollegiaalinen_N = mkkN "kollegiaalinen" ;
lin kolleginen_N = mkkN "kolleginen" ;
lin kollegio_N = mkkN "kollegio" ;
lin kollektiivi_N = mkkN "kollektiivi" ;
lin kollektiivinen_A = mkkA "kollektiivinen" ;
lin kollektiivisesti_Adv = mkkAdv "kollektiivisesti" ;
lin kollektiivisuus_N = mkkN "kollektiivisuus" ;
lin kollektivismi_N = mkkN "kollektivismi" ;
lin kollektivisoida_V = mkkV "kollektivisoida" ;
lin kollektivisti_N = mkkN "kollektivisti" ;
lin kollektivistinen_N = mkkN "kollektivistinen" ;
lin kollektivoida_V = mkkV "kollektivoida" ;
lin kollektori_N = mkkN "kollektori" ;
lin kolli_1_N = mkkN "kolli" ;
lin kolli_2_N = mkkN "kolli" ;
lin kollo_N = mkkN "kollo" ;
lin kolloidi_N = mkkN "kolloidi" ;
lin kolloidinen_N = mkkN "kolloidinen" ;
lin kollokvio_N = mkkN "kollokvio" ;
lin kollokviumi_N = mkkN "kollokviumi" ;
lin kollottaa_V = mkkV "kollottaa" ;
lin kollotus_N = mkkN "kollotus" ;
lin kolmannes_N = mkkN "kolmannes" ;
lin kolmas_N = mkkN "kolmas" ;
lin kolmasti_Adv = mkkAdv "kolmasti" ;
lin kolme_A = mkkA "kolme" ;
lin kolmestaan_Adv = mkkAdv "kolmestaan" ;
lin kolmesti_Adv = mkkAdv "kolmesti" ;
lin kolmia_Adv = mkkAdv "kolmia" ;
lin kolmijakoisuus_N = mkkN "kolmijakoisuus" ;
lin kolmikko_N = mkkN "kolmikko" ;
lin kolmiloikkaaja_N = mkkN "kolmiloikkaaja" ;
lin kolminainen_N = mkkN "kolminainen" ;
lin kolminaisuus_N = mkkN "kolminaisuus" ;
lin kolminapainen_N = mkkN "kolminapainen" ;
lin kolminkertaisesti_Adv = mkkAdv "kolminkertaisesti" ;
lin kolminkertaistaa_V = mkkV "kolminkertaistaa" ;
lin kolminkertaistua_V = mkkV "kolminkertaistua" ;
lin kolmio_N = mkkN "kolmio" ;
lin kolmioida_V = mkkV "kolmioida" ;
lin kolmiointi_N = mkkN "kolmiointi" ;
lin kolmisen_Adv = mkkAdv "kolmisen" ;
lin kolmisenkymmenta'_Adv = mkkAdv "kolmisenkymmentä" ;
lin kolmisin_Adv = mkkAdv "kolmisin" ;
lin kolmistaan_Adv = mkkAdv "kolmistaan" ;
lin kolmittain_Adv = mkkAdv "kolmittain" ;
lin kolmituumainen_N = mkkN "kolmituumainen" ;
lin kolmia'a'nisesti_Adv = mkkAdv "kolmiäänisesti" ;
lin kolmoisvoltti_N = mkkN "kolmoisvoltti" ;
lin kolmonen_N = mkkN "kolmonen" ;
lin kolo_N = mkkN "kolo" ;
lin koloa_V = mkkV "koloa" ;
lin koloinen_N = mkkN "koloinen" ;
lin kolonia_N = mkkN "kolonia" ;
lin kolonialismi_N = mkkN "kolonialismi" ;
lin kolonialisti_N = mkkN "kolonialisti" ;
lin kolonialistinen_N = mkkN "kolonialistinen" ;
lin kolonna_N = mkkN "kolonna" ;
lin kolonni_N = mkkN "kolonni" ;
lin koloratuuri_N = mkkN "koloratuuri" ;
lin kolorismi_N = mkkN "kolorismi" ;
lin koloristinen_N = mkkN "koloristinen" ;
lin kolossaalinen_N = mkkN "kolossaalinen" ;
lin kolossi_N = mkkN "kolossi" ;
lin kolottaa_V = mkkV "kolottaa" ;
lin kolotus_N = mkkN "kolotus" ;
lin kolpakko_N = mkkN "kolpakko" ;
lin kolpakollinen_N = mkkN "kolpakollinen" ;
lin koltiainen_N = mkkN "koltiainen" ;
lin koltta_N = mkkN "koltta" ;
lin kolttonen_N = mkkN "kolttonen" ;
lin kolttu_N = mkkN "kolttu" ;
lin kolumbaario_N = mkkN "kolumbaario" ;
lin kolumni_N = mkkN "kolumni" ;
lin kolumnisti_N = mkkN "kolumnisti" ;
lin koluta_V = mkkV "koluta" ;
lin kolvi_N = mkkN "kolvi" ;
lin kombinaatio_N = mkkN "kombinaatio" ;
lin kombinaatti_N = mkkN "kombinaatti" ;
lin kombinoida_V = mkkV "kombinoida" ;
lin kombinointi_N = mkkN "kombinointi" ;
lin kombinoitua_V = mkkV "kombinoitua" ;
lin komea_A = mkkA "komea" ;
lin komeasti_Adv = mkkAdv "komeasti" ;
lin komedia_N = mkkN "komedia" ;
lin komedienne_N = mkkN "komedienne" ;
lin komeetta_N = mkkN "komeetta" ;
lin komeilla_V = mkkV "komeilla" ;
lin komeilu_N = mkkN "komeilu" ;
lin komendantti_N = mkkN "komendantti" ;
lin komennella_V = mkkV "komennella" ;
lin komennus_N = mkkN "komennus" ;
lin komentaa_V = mkkV "komentaa" ;
lin komentaja_N = mkkN "komentaja" ;
lin komentelu_N = mkkN "komentelu" ;
lin komento_N = mkkN "komento" ;
lin komero_N = mkkN "komero" ;
lin komeus_N = mkkN "komeus" ;
lin komi_N = mkkN "komi" ;
lin komiikka_N = mkkN "komiikka" ;
lin komisario_N = mkkN "komisario" ;
lin komissaari_N = mkkN "komissaari" ;
lin komissio_N = mkkN "komissio" ;
lin komissiona'a'ri_N = mkkN "komissionääri" ;
lin komistaa_V = mkkV "komistaa" ;
lin komistua_V = mkkV "komistua" ;
lin komistus_N = mkkN "komistus" ;
lin komitatiivi_N = mkkN "komitatiivi" ;
lin komitea_N = mkkN "komitea" ;
lin kommari_N = mkkN "kommari" ;
lin kommellus_N = mkkN "kommellus" ;
lin kommentaari_N = mkkN "kommentaari" ;
lin kommentaattori_N = mkkN "kommentaattori" ;
lin kommentoida_V = mkkV "kommentoida" ;
lin kommentoija_N = mkkN "kommentoija" ;
lin kommentti_N = mkkN "kommentti" ;
lin kommervenkki_N = mkkN "kommervenkki" ;
lin kommodori_N = mkkN "kommodori" ;
lin kommunikaatio_N = mkkN "kommunikaatio" ;
lin kommunikea_N = mkkN "kommunikea" ;
lin kommunikoida_V = mkkV "kommunikoida" ;
lin kommunismi_N = mkkN "kommunismi" ;
lin kommunisti_N = mkkN "kommunisti" ;
lin kommunistinen_N = mkkN "kommunistinen" ;
lin kommutaatio_N = mkkN "kommutaatio" ;
lin kommutaattori_N = mkkN "kommutaattori" ;
lin kommutoida_V = mkkV "kommutoida" ;
lin kommuuni_N = mkkN "kommuuni" ;
lin kommuuniasuminen_N = mkkN "kommuuniasuminen" ;
lin kompa_N = mkkN "kompa" ;
lin kompakti_N = mkkN "kompakti" ;
lin komparaatio_N = mkkN "komparaatio" ;
lin komparatiivi_N = mkkN "komparatiivi" ;
lin komparatiivinen_N = mkkN "komparatiivinen" ;
lin komparoida_V = mkkV "komparoida" ;
lin kompassi_N = mkkN "kompassi" ;
lin kompastella_V = mkkV "kompastella" ;
lin kompastelu_N = mkkN "kompastelu" ;
lin kompastua_V = mkkV "kompastua" ;
lin kompastus_N = mkkN "kompastus" ;
lin kompastuttaa_V = mkkV "kompastuttaa" ;
lin kompata_V = mkkV "kompata" ;
lin kompensaatio_N = mkkN "kompensaatio" ;
lin kompensatorinen_N = mkkN "kompensatorinen" ;
lin kompensoida_V = mkkV "kompensoida" ;
lin kompensoitua_V = mkkV "kompensoitua" ;
lin kompetenssi_N = mkkN "kompetenssi" ;
lin kompetentti_N = mkkN "kompetentti" ;
lin kompleksi_N = mkkN "kompleksi" ;
lin kompleksikas_N = mkkN "kompleksikas" ;
lin kompleksinen_N = mkkN "kompleksinen" ;
lin kompleksisuus_N = mkkN "kompleksisuus" ;
lin komplementaarinen_N = mkkN "komplementaarinen" ;
lin komplementti_N = mkkN "komplementti" ;
lin komplikaatio_N = mkkN "komplikaatio" ;
lin komplisoida_V = mkkV "komplisoida" ;
lin komplisoitua_V = mkkV "komplisoitua" ;
lin komponentti_N = mkkN "komponentti" ;
lin kompositio_N = mkkN "kompositio" ;
lin komposti_N = mkkN "komposti" ;
lin kompostoida_V = mkkV "kompostoida" ;
lin kompostointi_N = mkkN "kompostointi" ;
lin kompostori_N = mkkN "kompostori" ;
lin kompotti_N = mkkN "kompotti" ;
lin komppania_N = mkkN "komppania" ;
lin komppi_N = mkkN "komppi" ;
lin kompressi_N = mkkN "kompressi" ;
lin kompressori_N = mkkN "kompressori" ;
lin kompromettoida_V = mkkV "kompromettoida" ;
lin kompromissi_N = mkkN "kompromissi" ;
lin kompura_N = mkkN "kompura" ;
lin kompuroida_V = mkkV "kompuroida" ;
lin kompus_N = mkkN "kompus" ;
lin kondensaatio_N = mkkN "kondensaatio" ;
lin kondensaattori_N = mkkN "kondensaattori" ;
lin kondensoida_V = mkkV "kondensoida" ;
lin kondensoitua_V = mkkV "kondensoitua" ;
lin kondiittori_N = mkkN "kondiittori" ;
lin kondis_N = mkkN "kondis" ;
lin konditionaali_N = mkkN "konditionaali" ;
lin konditionaalinen_N = mkkN "konditionaalinen" ;
lin konditoria_N = mkkN "konditoria" ;
lin kondomi_N = mkkN "kondomi" ;
lin kondori_N = mkkN "kondori" ;
lin kondukto'o'ri_N = mkkN "konduktööri" ;
lin kondylooma_N = mkkN "kondylooma" ;
lin kone_N = mkkN "kone" ;
lin koneellinen_A = mkkA "koneellinen" ;
lin koneellisesti_Adv = mkkAdv "koneellisesti" ;
lin koneellistaa_V = mkkV "koneellistaa" ;
lin koneellistua_V = mkkV "koneellistua" ;
lin koneellisuus_N = mkkN "koneellisuus" ;
lin koneikko_N = mkkN "koneikko" ;
lin koneinen_N = mkkN "koneinen" ;
lin koneistaa_V = mkkV "koneistaa" ;
lin koneistaja_N = mkkN "koneistaja" ;
lin koneisto_N = mkkN "koneisto" ;
lin koneistua_V = mkkV "koneistua" ;
lin koneistus_N = mkkN "koneistus" ;
lin konekoodinen_N = mkkN "konekoodinen" ;
lin koneka'a'nta'minen_N = mkkN "konekääntäminen" ;
lin konemaisesti_Adv = mkkAdv "konemaisesti" ;
lin konferenssi_N = mkkN "konferenssi" ;
lin konfirmaatio_N = mkkN "konfirmaatio" ;
lin konfirmandi_N = mkkN "konfirmandi" ;
lin konfirmoida_V = mkkV "konfirmoida" ;
lin konflikti_N = mkkN "konflikti" ;
lin konfutselainen_N = mkkN "konfutselainen" ;
lin konfutselaisuus_N = mkkN "konfutselaisuus" ;
lin kongressi_N = mkkN "kongressi" ;
lin kongruenssi_N = mkkN "kongruenssi" ;
lin kongruentti_N = mkkN "kongruentti" ;
lin kongruoida_V = mkkV "kongruoida" ;
lin koni_N = mkkN "koni" ;
lin konjakki_N = mkkN "konjakki" ;
lin konjugaatio_N = mkkN "konjugaatio" ;
lin konjugoida_V = mkkV "konjugoida" ;
lin konjugointi_N = mkkN "konjugointi" ;
lin konjunktio_N = mkkN "konjunktio" ;
lin konjunktuuri_N = mkkN "konjunktuuri" ;
lin konkari_N = mkkN "konkari" ;
lin konkata_V = mkkV "konkata" ;
lin konkelo_N = mkkN "konkelo" ;
lin konki_N = mkkN "konki" ;
lin konkistadori_N = mkkN "konkistadori" ;
lin konkka_N = mkkN "konkka" ;
lin konkkaronkka_N = mkkN "konkkaronkka" ;
lin konklaavi_N = mkkN "konklaavi" ;
lin konkordanssi_N = mkkN "konkordanssi" ;
lin konkreettinen_A = mkkA "konkreettinen" ;
lin konkreettisesti_Adv = mkkAdv "konkreettisesti" ;
lin konkreettistaa_V = mkkV "konkreettistaa" ;
lin konkreettistua_V = mkkV "konkreettistua" ;
lin konkreettisuus_N = mkkN "konkreettisuus" ;
lin konkretia_N = mkkN "konkretia" ;
lin konkretismi_N = mkkN "konkretismi" ;
lin konkretisoida_V = mkkV "konkretisoida" ;
lin konkretisoitua_V = mkkV "konkretisoitua" ;
lin konkretisti_N = mkkN "konkretisti" ;
lin konkurrenssi_N = mkkN "konkurrenssi" ;
lin konkurssi_N = mkkN "konkurssi" ;
lin konna_N = mkkN "konna" ;
lin konnari_N = mkkN "konnari" ;
lin konnuus_N = mkkN "konnuus" ;
lin konossementti_N = mkkN "konossementti" ;
lin konsa_Adv = mkkAdv "konsa" ;
lin konsaan_Adv = mkkAdv "konsaan" ;
lin konsanaan_Adv = mkkAdv "konsanaan" ;
lin konsensus_N = mkkN "konsensus" ;
lin konsentraatio_N = mkkN "konsentraatio" ;
lin konsentraatti_N = mkkN "konsentraatti" ;
lin konsentroida_V = mkkV "konsentroida" ;
lin konsentrointi_N = mkkN "konsentrointi" ;
lin konsentroitua_V = mkkV "konsentroitua" ;
lin konsepti_N = mkkN "konsepti" ;
lin konserni_N = mkkN "konserni" ;
lin konsertoida_V = mkkV "konsertoida" ;
lin konsertti_N = mkkN "konsertti" ;
lin konsertto_N = mkkN "konsertto" ;
lin konservaattori_N = mkkN "konservaattori" ;
lin konservatiivi_N = mkkN "konservatiivi" ;
lin konservatiivinen_A = mkkA "konservatiivinen" ;
lin konservatiivisesti_Adv = mkkAdv "konservatiivisesti" ;
lin konservatiivisuus_N = mkkN "konservatiivisuus" ;
lin konservatismi_N = mkkN "konservatismi" ;
lin konservatorio_N = mkkN "konservatorio" ;
lin konservoida_V = mkkV "konservoida" ;
lin konservoija_N = mkkN "konservoija" ;
lin konsiili_N = mkkN "konsiili" ;
lin konsistenssi_N = mkkN "konsistenssi" ;
lin konsistori_N = mkkN "konsistori" ;
lin konsoli_N = mkkN "konsoli" ;
lin konsonantti_N = mkkN "konsonantti" ;
lin konsortio_N = mkkN "konsortio" ;
lin konstaapeli_N = mkkN "konstaapeli" ;
lin konstailija_N = mkkN "konstailija" ;
lin konstailla_V = mkkV "konstailla" ;
lin konstanssi_N = mkkN "konstanssi" ;
lin konstantti_N = mkkN "konstantti" ;
lin konsti_N = mkkN "konsti" ;
lin konstikas_A = mkkA "konstikas" ;
lin konstikkaasti_Adv = mkkAdv "konstikkaasti" ;
lin konstikkuus_N = mkkN "konstikkuus" ;
lin konstitutionaalinen_N = mkkN "konstitutionaalinen" ;
lin konstitutionalismi_N = mkkN "konstitutionalismi" ;
lin konstituutio_N = mkkN "konstituutio" ;
lin konstruktiivinen_N = mkkN "konstruktiivinen" ;
lin konstruktio_N = mkkN "konstruktio" ;
lin konstruktivismi_N = mkkN "konstruktivismi" ;
lin konstruoida_V = mkkV "konstruoida" ;
lin konstruointi_N = mkkN "konstruointi" ;
lin konsulaatti_N = mkkN "konsulaatti" ;
lin konsulentti_N = mkkN "konsulentti" ;
lin konsuli_N = mkkN "konsuli" ;
lin konsultaatio_N = mkkN "konsultaatio" ;
lin konsultatiivinen_N = mkkN "konsultatiivinen" ;
lin konsultoida_V = mkkV "konsultoida" ;
lin konsultointi_N = mkkN "konsultointi" ;
lin konsultti_N = mkkN "konsultti" ;
lin konsumerismi_N = mkkN "konsumerismi" ;
lin konsumeristinen_N = mkkN "konsumeristinen" ;
lin kontakti_N = mkkN "kontakti" ;
lin kontallaan_Adv = mkkAdv "kontallaan" ;
lin kontalleen_Adv = mkkAdv "kontalleen" ;
lin kontata_V = mkkV "kontata" ;
lin konteineri_N = mkkN "konteineri" ;
lin konteksti_N = mkkN "konteksti" ;
lin kontillaan_Adv = mkkAdv "kontillaan" ;
lin kontilleen_Adv = mkkAdv "kontilleen" ;
lin kontingentti_N = mkkN "kontingentti" ;
lin kontinuumi_N = mkkN "kontinuumi" ;
lin kontio_N = mkkN "kontio" ;
lin kontrahti_N = mkkN "kontrahti" ;
lin kontrapunkti_N = mkkN "kontrapunkti" ;
lin kontrapunktinen_N = mkkN "kontrapunktinen" ;
lin kontrasti_N = mkkN "kontrasti" ;
lin kontrastoida_V = mkkV "kontrastoida" ;
lin kontrolli_N = mkkN "kontrolli" ;
lin kontrolloida_V = mkkV "kontrolloida" ;
lin kontrollointi_N = mkkN "kontrollointi" ;
lin konttailla_V = mkkV "konttailla" ;
lin konttaus_N = mkkN "konttaus" ;
lin kontti_1_N = mkkN "kontti" ;
lin kontti_2_N = mkkN "kontti" ;
lin kontti_3_N = mkkN "kontti" ;
lin kontto_N = mkkN "kontto" ;
lin konttori_N = mkkN "konttori" ;
lin konttoristua_V = mkkV "konttoristua" ;
lin kontu_N = mkkN "kontu" ;
lin konvehti_N = mkkN "konvehti" ;
lin konventio_N = mkkN "konventio" ;
lin konventionaalinen_N = mkkN "konventionaalinen" ;
lin konventti_N = mkkN "konventti" ;
lin konvergenssi_N = mkkN "konvergenssi" ;
lin konvergentti_N = mkkN "konvergentti" ;
lin konversio_N = mkkN "konversio" ;
lin koodaaja_N = mkkN "koodaaja" ;
lin koodata_V = mkkV "koodata" ;
lin koodaus_N = mkkN "koodaus" ;
lin koodeksi_N = mkkN "koodeksi" ;
lin koodi_N = mkkN "koodi" ;
lin koodittaa_V = mkkV "koodittaa" ;
lin koodittaja_N = mkkN "koodittaja" ;
lin kooditus_N = mkkN "kooditus" ;
lin kookas_N = mkkN "kookas" ;
lin kookosvoi_N = mkkN "kookosvoi" ;
lin koolata_V = mkkV "koolata" ;
lin koolaus_N = mkkN "koolaus" ;
lin koolinki_N = mkkN "koolinki" ;
lin koolla_Adv = mkkAdv "koolla" ;
lin koolle_Adv = mkkAdv "koolle" ;
lin kooma_N = mkkN "kooma" ;
lin koomikko_N = mkkN "koomikko" ;
lin koominen_A = mkkA "koominen" ;
lin koomisesti_Adv = mkkAdv "koomisesti" ;
lin koomisuus_N = mkkN "koomisuus" ;
lin koommin_Adv = mkkAdv "koommin" ;
lin koonnos_N = mkkN "koonnos" ;
lin koontaa_V = mkkV "koontaa" ;
lin koonti_N = mkkN "koonti" ;
lin kooperaatio_N = mkkN "kooperaatio" ;
lin kooperatiivinen_N = mkkN "kooperatiivinen" ;
lin koordinaatio_N = mkkN "koordinaatio" ;
lin koordinaatisto_N = mkkN "koordinaatisto" ;
lin koordinaatta_N = mkkN "koordinaatta" ;
lin koordinaatti_N = mkkN "koordinaatti" ;
lin koordinaattori_N = mkkN "koordinaattori" ;
lin koordinoida_V = mkkV "koordinoida" ;
lin koordinoija_N = mkkN "koordinoija" ;
lin koordinointi_N = mkkN "koordinointi" ;
lin koossa_Adv = mkkAdv "koossa" ;
lin koostaa_V = mkkV "koostaa" ;
lin kooste_N = mkkN "kooste" ;
lin koosteinen_N = mkkN "koosteinen" ;
lin koostelma_N = mkkN "koostelma" ;
lin koosto_N = mkkN "koosto" ;
lin koostua_V = mkkV "koostua" ;
lin koostumus_N = mkkN "koostumus" ;
lin koota_V = mkkV "koota" ;
lin kop_Adv = mkkAdv "kop" ;
lin kopahdella_V = mkkV "kopahdella" ;
lin kopahdus_N = mkkN "kopahdus" ;
lin kopahtaa_V = mkkV "kopahtaa" ;
lin kopallinen_N = mkkN "kopallinen" ;
lin kopata_V = mkkV "kopata" ;
lin kopaus_N = mkkN "kopaus" ;
lin kopautella_V = mkkV "kopautella" ;
lin kopauttaa_V = mkkV "kopauttaa" ;
lin kopautus_N = mkkN "kopautus" ;
lin kopea_A = mkkA "kopea" ;
lin kopeasti_Adv = mkkAdv "kopeasti" ;
lin kopeekka_N = mkkN "kopeekka" ;
lin kopeilla_V = mkkV "kopeilla" ;
lin kopeloida_V = mkkV "kopeloida" ;
lin kopernikaaninen_N = mkkN "kopernikaaninen" ;
lin kopeus_N = mkkN "kopeus" ;
lin kopina_N = mkkN "kopina" ;
lin kopio_N = mkkN "kopio" ;
lin kopioida_V = mkkV "kopioida" ;
lin kopioija_N = mkkN "kopioija" ;
lin kopiointi_N = mkkN "kopiointi" ;
lin kopista_V = mkkV "kopista" ;
lin kopistaa_V = mkkV "kopistaa" ;
lin kopistella_V = mkkV "kopistella" ;
lin kopisti_N = mkkN "kopisti" ;
lin kopisuttaa_V = mkkV "kopisuttaa" ;
lin kopla_N = mkkN "kopla" ;
lin koplata_V = mkkV "koplata" ;
lin koppa_N = mkkN "koppa" ;
lin koppava_A = mkkA "koppava" ;
lin koppavasti_Adv = mkkAdv "koppavasti" ;
lin koppavuus_N = mkkN "koppavuus" ;
lin koppelo_N = mkkN "koppelo" ;
lin koppero_N = mkkN "koppero" ;
lin koppi_1_N = mkkN "koppi" ;
lin koppi_2_N = mkkN "koppi" ;
lin koppura_N = mkkN "koppura" ;
lin koppurainen_N = mkkN "koppurainen" ;
lin kopra_N = mkkN "kopra" ;
lin kopsaa_V = mkkV "kopsaa" ;
lin kopsahdella_V = mkkV "kopsahdella" ;
lin kopsahdus_N = mkkN "kopsahdus" ;
lin kopsahtaa_V = mkkV "kopsahtaa" ;
lin kopsata_V = mkkV "kopsata" ;
lin kopsaus_1_N = mkkN "kopsaus" ;
lin kopsaus_2_N = mkkN "kopsaus" ;
lin kopsauttaa_V = mkkV "kopsauttaa" ;
lin kopse_N = mkkN "kopse" ;
lin kopsu_1_N = mkkN "kopsu" ;
lin kopsu_2_N = mkkN "kopsu" ;
lin kopteri_N = mkkN "kopteri" ;
lin kopti_N = mkkN "kopti" ;
lin kopukka_N = mkkN "kopukka" ;
lin koputella_V = mkkV "koputella" ;
lin koputtaa_V = mkkV "koputtaa" ;
lin koputtelu_N = mkkN "koputtelu" ;
lin koputus_N = mkkN "koputus" ;
lin koraali_N = mkkN "koraali" ;
lin Koraani_N = mkkN "Koraani" ;
lin korahdella_V = mkkV "korahdella" ;
lin korahdus_N = mkkN "korahdus" ;
lin korahtaa_V = mkkV "korahtaa" ;
lin koralli_N = mkkN "koralli" ;
lin korallinen_N = mkkN "korallinen" ;
lin korea_1_A = mkkA "korea" ;
lin korea_2_A = mkkA "korea" ;
lin koreasti_Adv = mkkAdv "koreasti" ;
lin koreilla_V = mkkV "koreilla" ;
lin koreilu_N = mkkN "koreilu" ;
lin koreittain_Adv = mkkAdv "koreittain" ;
lin korento_N = mkkN "korento" ;
lin koreografi_N = mkkN "koreografi" ;
lin koreografia_N = mkkN "koreografia" ;
lin koreografinen_N = mkkN "koreografinen" ;
lin koreus_N = mkkN "koreus" ;
lin kori_N = mkkN "kori" ;
lin korianteri_N = mkkN "korianteri" ;
lin korillinen_N = mkkN "korillinen" ;
lin korina_N = mkkN "korina" ;
lin korintti_N = mkkN "korintti" ;
lin korinttolainen_N = mkkN "korinttolainen" ;
lin koris_N = mkkN "koris" ;
lin korista_V = mkkV "korista" ;
lin koristaa_V = mkkV "koristaa" ;
lin koristautua_V = mkkV "koristautua" ;
lin koriste_N = mkkN "koriste" ;
lin koristeellinen_A = mkkA "koristeellinen" ;
lin koristeellisesti_Adv = mkkAdv "koristeellisesti" ;
lin koristeellisuus_N = mkkN "koristeellisuus" ;
lin koristella_V = mkkV "koristella" ;
lin koristelu_N = mkkN "koristelu" ;
lin koristus_N = mkkN "koristus" ;
lin korjaaja_N = mkkN "korjaaja" ;
lin korjaamaton_N = mkkN "korjaamaton" ;
lin korjaamattomasti_Adv = mkkAdv "korjaamattomasti" ;
lin korjaamo_N = mkkN "korjaamo" ;
lin korjaantua_V = mkkV "korjaantua" ;
lin korjailla_V = mkkV "korjailla" ;
lin korjailu_N = mkkN "korjailu" ;
lin korjain_N = mkkN "korjain" ;
lin korjata_V = mkkV "korjata" ;
lin korjaus_N = mkkN "korjaus" ;
lin korjauttaa_V = mkkV "korjauttaa" ;
lin korjautua_V = mkkV "korjautua" ;
lin korjussa_Adv = mkkAdv "korjussa" ;
lin korjuu_N = mkkN "korjuu" ;
lin korjuuaika_N = mkkN "korjuuaika" ;
lin korjuun_Adv = mkkAdv "korjuun" ;
lin korjuuseen_Adv = mkkAdv "korjuuseen" ;
lin korjuussa_Adv = mkkAdv "korjuussa" ;
lin korjuuttaa_V = mkkV "korjuuttaa" ;
lin korkata_V = mkkV "korkata" ;
lin korkea_A = mkkA "korkea" ;
lin korkealla_Adv = mkkAdv "korkealla" ;
lin korkealle_Adv = mkkAdv "korkealle" ;
lin korkealta_Adv = mkkAdv "korkealta" ;
lin korkeasti_Adv = mkkAdv "korkeasti" ;
lin korkeimmillaan_Adv = mkkAdv "korkeimmillaan" ;
lin korkeimmilleen_Adv = mkkAdv "korkeimmilleen" ;
lin korkeintaan_Adv = mkkAdv "korkeintaan" ;
lin korkenee_V = mkkV "korkenee" ;
lin korkeus_N = mkkN "korkeus" ;
lin korkillinen_N = mkkN "korkillinen" ;
lin korkita_V = mkkV "korkita" ;
lin korkittaa_V = mkkV "korkittaa" ;
lin korkitus_N = mkkN "korkitus" ;
lin korkkaamaton_N = mkkN "korkkaamaton" ;
lin korkki_N = mkkN "korkki" ;
lin korkkiintua_V = mkkV "korkkiintua" ;
lin korkkinen_N = mkkN "korkkinen" ;
lin korkkiutua_V = mkkV "korkkiutua" ;
lin korko_N = mkkN "korko" ;
lin korkoinen_N = mkkN "korkoinen" ;
lin korkuinen_N = mkkN "korkuinen" ;
lin kornetisti_N = mkkN "kornetisti" ;
lin kornetti_N = mkkN "kornetti" ;
lin korni_N = mkkN "korni" ;
lin korohoro_N = mkkN "korohoro" ;
lin koroke_N = mkkN "koroke" ;
lin korollinen_N = mkkN "korollinen" ;
lin korona_N = mkkN "korona" ;
lin koronkiskominen_N = mkkN "koronkiskominen" ;
lin korostaa_V = mkkV "korostaa" ;
lin koroste_N = mkkN "koroste" ;
lin korosteinen_A = mkkA "korosteinen" ;
lin korosteisesti_Adv = mkkAdv "korosteisesti" ;
lin korosteisuus_N = mkkN "korosteisuus" ;
lin korostua_V = mkkV "korostua" ;
lin korostus_N = mkkN "korostus" ;
lin koroton_N = mkkN "koroton" ;
lin korottaa_V = mkkV "korottaa" ;
lin korotus_N = mkkN "korotus" ;
lin korotuttaa_V = mkkV "korotuttaa" ;
lin korpeentua_V = mkkV "korpeentua" ;
lin korpi_N = mkkN "korpi" ;
lin korporaatio_N = mkkN "korporaatio" ;
lin korporatiivinen_N = mkkN "korporatiivinen" ;
lin korporativismi_N = mkkN "korporativismi" ;
lin korppi_1_N = mkkN "korppi" ;
lin korppi_2_N = mkkN "korppi" ;
lin korppu_N = mkkN "korppu" ;
lin korpraali_N = mkkN "korpraali" ;
lin korpus_N = mkkN "korpus" ;
lin korrehtuuri_N = mkkN "korrehtuuri" ;
lin korrekti_A = mkkA "korrekti" ;
lin korrektisti_Adv = mkkAdv "korrektisti" ;
lin korrektius_N = mkkN "korrektius" ;
lin korrelaatio_N = mkkN "korrelaatio" ;
lin korrelaatiokerroin_N = mkkN "korrelaatiokerroin" ;
lin korrelaatti_N = mkkN "korrelaatti" ;
lin korreloida_V = mkkV "korreloida" ;
lin korreloitua_V = mkkV "korreloitua" ;
lin korrepetiittori_N = mkkN "korrepetiittori" ;
lin korroosio_N = mkkN "korroosio" ;
lin korruptio_N = mkkN "korruptio" ;
lin korruptoitua_V = mkkV "korruptoitua" ;
lin korseletti_N = mkkN "korseletti" ;
lin korsetti_N = mkkN "korsetti" ;
lin korsi_N = mkkN "korsi" ;
lin korsinen_N = mkkN "korsinen" ;
lin korska_N = mkkN "korska" ;
lin korskahdella_V = mkkV "korskahdella" ;
lin korskahdus_N = mkkN "korskahdus" ;
lin korskahtaa_V = mkkV "korskahtaa" ;
lin korskea_A = mkkA "korskea" ;
lin korskeasti_Adv = mkkAdv "korskeasti" ;
lin korskeilla_V = mkkV "korskeilla" ;
lin korskua_V = mkkV "korskua" ;
lin korskuna_N = mkkN "korskuna" ;
lin korskunta_N = mkkN "korskunta" ;
lin korsteeni_N = mkkN "korsteeni" ;
lin korsto_N = mkkN "korsto" ;
lin korsu_N = mkkN "korsu" ;
lin korte_N = mkkN "korte" ;
lin kortinen_N = mkkN "kortinen" ;
lin kortisoni_N = mkkN "kortisoni" ;
lin kortisto_N = mkkN "kortisto" ;
lin kortistoida_V = mkkV "kortistoida" ;
lin kortistointi_N = mkkN "kortistointi" ;
lin kortittaa_V = mkkV "kortittaa" ;
lin kortonki_N = mkkN "kortonki" ;
lin kortteeri_N = mkkN "kortteeri" ;
lin kortteikko_N = mkkN "kortteikko" ;
lin kortteli_N = mkkN "kortteli" ;
lin kortti_N = mkkN "kortti" ;
lin koru_N = mkkN "koru" ;
lin korundi_N = mkkN "korundi" ;
lin koruton_N = mkkN "koruton" ;
lin koruttomasti_Adv = mkkAdv "koruttomasti" ;
lin koruttomuus_N = mkkN "koruttomuus" ;
lin korva_N = mkkN "korva" ;
lin korvaaja_N = mkkN "korvaaja" ;
lin korvaamaton_N = mkkN "korvaamaton" ;
lin korvaantua_V = mkkV "korvaantua" ;
lin korvainen_N = mkkN "korvainen" ;
lin korvake_N = mkkN "korvake" ;
lin korvallinen_N = mkkN "korvallinen" ;
lin korvapuusti_N = mkkN "korvapuusti" ;
lin korvata_V = mkkV "korvata" ;
lin korvatillikka_N = mkkN "korvatillikka" ;
lin korvaus_N = mkkN "korvaus" ;
lin korvautua_V = mkkV "korvautua" ;
lin korvennus_N = mkkN "korvennus" ;
lin korventaa_V = mkkV "korventaa" ;
lin korventua_V = mkkV "korventua" ;
lin korveta_V = mkkV "korveta" ;
lin korvetti_N = mkkN "korvetti" ;
lin korviahuumaava_N = mkkN "korviahuumaava" ;
lin korviasa'rkeva'_N = mkkN "korviasärkevä" ;
lin korviavihlova_N = mkkN "korviavihlova" ;
lin korvike_N = mkkN "korvike" ;
lin korvilla_Adv = mkkAdv "korvilla" ;
lin korville_Adv = mkkAdv "korville" ;
lin korvinkuultava_N = mkkN "korvinkuultava" ;
lin korvis_N = mkkN "korvis" ;
lin korvissa_Adv = mkkAdv "korvissa" ;
lin korvo_N = mkkN "korvo" ;
lin korvus_N = mkkN "korvus" ;
lin kosekantti_N = mkkN "kosekantti" ;
lin ko_er_N = mkkN "košer" ;
lin kosia_V = mkkV "kosia" ;
lin kosija_N = mkkN "kosija" ;
lin kosini_N = mkkN "kosini" ;
lin kosinta_N = mkkN "kosinta" ;
lin kosiskelija_N = mkkN "kosiskelija" ;
lin kosiskella_V = mkkV "kosiskella" ;
lin kosiskelu_N = mkkN "kosiskelu" ;
lin koska_Adv = mkkAdv "koska" ;
lin koskaan_Adv = mkkAdv "koskaan" ;
lin koskea_V = mkkV "koskea" ;
lin koskelo_N = mkkN "koskelo" ;
lin koskematon_N = mkkN "koskematon" ;
lin koskemattomuus_N = mkkN "koskemattomuus" ;
lin kosketella_V = mkkV "kosketella" ;
lin kosketin_N = mkkN "kosketin" ;
lin koskettaa_V = mkkV "koskettaa" ;
lin koskettelu_N = mkkN "koskettelu" ;
lin koskettimisto_N = mkkN "koskettimisto" ;
lin kosketus_N = mkkN "kosketus" ;
lin kosketuskohta_N = mkkN "kosketuskohta" ;
lin koski_N = mkkN "koski" ;
lin koskinen_N = mkkN "koskinen" ;
lin koskisuus_N = mkkN "koskisuus" ;
lin kosmeettinen_N = mkkN "kosmeettinen" ;
lin kosmetiikka_N = mkkN "kosmetiikka" ;
lin kosmetologi_N = mkkN "kosmetologi" ;
lin kosmetologia_N = mkkN "kosmetologia" ;
lin kosminen_N = mkkN "kosminen" ;
lin kosmogonia_N = mkkN "kosmogonia" ;
lin kosmogoninen_N = mkkN "kosmogoninen" ;
lin kosmologia_N = mkkN "kosmologia" ;
lin kosmologinen_N = mkkN "kosmologinen" ;
lin kosmonautti_N = mkkN "kosmonautti" ;
lin kosmopoliitti_N = mkkN "kosmopoliitti" ;
lin kosmopoliittinen_N = mkkN "kosmopoliittinen" ;
lin kosmopoliittisuus_N = mkkN "kosmopoliittisuus" ;
lin kosmos_N = mkkN "kosmos" ;
lin kosolti_Adv = mkkAdv "kosolti" ;
lin kostaa_V = mkkV "kostaa" ;
lin kostaja_N = mkkN "kostaja" ;
lin kostautua_V = mkkV "kostautua" ;
lin koste_N = mkkN "koste" ;
lin kostea_A = mkkA "kostea" ;
lin kosteasti_Adv = mkkAdv "kosteasti" ;
lin kosteikko_N = mkkN "kosteikko" ;
lin kosteus_N = mkkN "kosteus" ;
lin kosteuttaa_V = mkkV "kosteuttaa" ;
lin kosto_N = mkkN "kosto" ;
lin kostua_1_V = mkkV "kostua" ;
lin kostua_2_V = mkkV "kostua" ;
lin kostuke_N = mkkN "kostuke" ;
lin kostute_N = mkkN "kostute" ;
lin kostutin_N = mkkN "kostutin" ;
lin kostuttaa_V = mkkV "kostuttaa" ;
lin kostutus_N = mkkN "kostutus" ;
lin kostyymi_N = mkkN "kostyymi" ;
lin kota_N = mkkN "kota" ;
lin kotangentti_N = mkkN "kotangentti" ;
lin kotelo_N = mkkN "kotelo" ;
lin koteloida_V = mkkV "koteloida" ;
lin koteloitua_V = mkkV "koteloitua" ;
lin koti_N = mkkN "koti" ;
lin kotia_Adv = mkkAdv "kotia" ;
lin kotiin_Adv = mkkAdv "kotiin" ;
lin kotilo_N = mkkN "kotilo" ;
lin kotilonkuori_N = mkkN "kotilonkuori" ;
lin kotimaistaa_V = mkkV "kotimaistaa" ;
lin kotimaistua_V = mkkV "kotimaistua" ;
lin kotimaisuus_N = mkkN "kotimaisuus" ;
lin kotipolttoinen_N = mkkN "kotipolttoinen" ;
lin kotiuttaa_V = mkkV "kotiuttaa" ;
lin kotiuttaja_N = mkkN "kotiuttaja" ;
lin kotiutua_V = mkkV "kotiutua" ;
lin kotka_N = mkkN "kotka" ;
lin kotkata_V = mkkV "kotkata" ;
lin kotkaus_N = mkkN "kotkaus" ;
lin kotkottaa_V = mkkV "kotkottaa" ;
lin kotkotus_N = mkkN "kotkotus" ;
lin kotletti_N = mkkN "kotletti" ;
lin koto_1_N = mkkN "koto" ;
lin koto_2_N = mkkN "koto" ;
lin kotoa_Adv = mkkAdv "kotoa" ;
lin kotoinen_A = mkkA "kotoinen" ;
lin kotoisa_N = mkkN "kotoisa" ;
lin kotoisesti_Adv = mkkAdv "kotoisesti" ;
lin kotoisin_Adv = mkkAdv "kotoisin" ;
lin kotoisuus_N = mkkN "kotoisuus" ;
lin kotona_Adv = mkkAdv "kotona" ;
lin kotosalla_Adv = mkkAdv "kotosalla" ;
lin kotosalle_Adv = mkkAdv "kotosalle" ;
lin kotosalta_Adv = mkkAdv "kotosalta" ;
lin kotsa_N = mkkN "kotsa" ;
lin kottarainen_N = mkkN "kottarainen" ;
lin kottero_N = mkkN "kottero" ;
lin koturni_N = mkkN "koturni" ;
lin kotva_N = mkkN "kotva" ;
lin kotvanen_N = mkkN "kotvanen" ;
lin kouho_N = mkkN "kouho" ;
lin kouhottaa_V = mkkV "kouhottaa" ;
lin koukata_V = mkkV "koukata" ;
lin koukero_N = mkkN "koukero" ;
lin koukeroida_V = mkkV "koukeroida" ;
lin koukeroinen_N = mkkN "koukeroinen" ;
lin koukerrella_V = mkkV "koukerrella" ;
lin koukertelu_N = mkkN "koukertelu" ;
lin koukistaa_V = mkkV "koukistaa" ;
lin koukistaja_N = mkkN "koukistaja" ;
lin koukistua_V = mkkV "koukistua" ;
lin koukistuma_N = mkkN "koukistuma" ;
lin koukistus_N = mkkN "koukistus" ;
lin koukkaus_N = mkkN "koukkaus" ;
lin koukku_N = mkkN "koukku" ;
lin koukkuinen_N = mkkN "koukkuinen" ;
lin koukkuun_Adv = mkkAdv "koukkuun" ;
lin koukussa_Adv = mkkAdv "koukussa" ;
lin koukuta_V = mkkV "koukuta" ;
lin koulata_V = mkkV "koulata" ;
lin koulia_V = mkkV "koulia" ;
lin kouliintua_V = mkkV "kouliintua" ;
lin koulinta_N = mkkN "koulinta" ;
lin kouliutua_V = mkkV "kouliutua" ;
lin koulu_N = mkkN "koulu" ;
lin kouluaika_N = mkkN "kouluaika" ;
lin kouluaka'yma'to'n_N = mkkN "kouluakäymätön" ;
lin koulukiusaaminen_N = mkkN "koulukiusaaminen" ;
lin koulukiusattu_N = mkkN "koulukiusattu" ;
lin koulunka'yma'to'n_N = mkkN "koulunkäymätön" ;
lin koulunka'ynyt_N = mkkN "koulunkäynyt" ;
lin kouluttaa_V = mkkV "kouluttaa" ;
lin kouluttaja_N = mkkN "kouluttaja" ;
lin kouluttamaton_N = mkkN "kouluttamaton" ;
lin kouluttautua_V = mkkV "kouluttautua" ;
lin kouluttua_V = mkkV "kouluttua" ;
lin koulutuksellinen_N = mkkN "koulutuksellinen" ;
lin koulutus_N = mkkN "koulutus" ;
lin koulutusaika_N = mkkN "koulutusaika" ;
lin koura_N = mkkN "koura" ;
lin kourainen_N = mkkN "kourainen" ;
lin kouraista_V = mkkV "kouraista" ;
lin kouraisu_N = mkkN "kouraisu" ;
lin kourallinen_N = mkkN "kourallinen" ;
lin kouria_V = mkkV "kouria" ;
lin kouristaa_V = mkkV "kouristaa" ;
lin kouristeinen_N = mkkN "kouristeinen" ;
lin kouristella_V = mkkV "kouristella" ;
lin kouristelu_N = mkkN "kouristelu" ;
lin kouristua_V = mkkV "kouristua" ;
lin kouristuksellinen_N = mkkN "kouristuksellinen" ;
lin kouristuksenomaisesti_Adv = mkkAdv "kouristuksenomaisesti" ;
lin kouristus_N = mkkN "kouristus" ;
lin kouru_N = mkkN "kouru" ;
lin kouruilla_V = mkkV "kouruilla" ;
lin kouruttaa_V = mkkV "kouruttaa" ;
lin kouruuntua_V = mkkV "kouruuntua" ;
lin koutsi_N = mkkN "koutsi" ;
lin kova_A = mkkA "kova" ;
lin kovaa_Adv = mkkAdv "kovaa" ;
lin kovaan_Adv = mkkAdv "kovaan" ;
lin kovakorvaisuus_N = mkkN "kovakorvaisuus" ;
lin kovakouraisesti_Adv = mkkAdv "kovakouraisesti" ;
lin kovakouraisuus_N = mkkN "kovakouraisuus" ;
lin kovaksikeitetty_N = mkkN "kovaksikeitetty" ;
lin kovaka'tisesti_Adv = mkkAdv "kovakätisesti" ;
lin kovalla_Adv = mkkAdv "kovalla" ;
lin kovalle_Adv = mkkAdv "kovalle" ;
lin kovapanosammunta_N = mkkN "kovapanosammunta" ;
lin kovasin_N = mkkN "kovasin" ;
lin kovassa_Adv = mkkAdv "kovassa" ;
lin kovasti_Adv = mkkAdv "kovasti" ;
lin kovasyda'misesti_Adv = mkkAdv "kovasydämisesti" ;
lin kovaa'a'nisesti_Adv = mkkAdv "kovaäänisesti" ;
lin kovennus_N = mkkN "kovennus" ;
lin koventaa_V = mkkV "koventaa" ;
lin koventua_V = mkkV "koventua" ;
lin kovera_N = mkkN "kovera" ;
lin koverre_N = mkkN "koverre" ;
lin koverrin_N = mkkN "koverrin" ;
lin koverrus_N = mkkN "koverrus" ;
lin kovertaa_V = mkkV "kovertaa" ;
lin kovertua_V = mkkV "kovertua" ;
lin kovertuma_N = mkkN "kovertuma" ;
lin koveruus_N = mkkN "koveruus" ;
lin koveta_V = mkkV "koveta" ;
lin kovete_N = mkkN "kovete" ;
lin kovettaa_V = mkkV "kovettaa" ;
lin kovettua_V = mkkV "kovettua" ;
lin kovettuma_N = mkkN "kovettuma" ;
lin kovetus_N = mkkN "kovetus" ;
lin kovike_N = mkkN "kovike" ;
lin kovilla_Adv = mkkAdv "kovilla" ;
lin koville_Adv = mkkAdv "koville" ;
lin kovin_Adv = mkkAdv "kovin" ;
lin kovis_N = mkkN "kovis" ;
lin kovistaa_V = mkkV "kovistaa" ;
lin kovistella_V = mkkV "kovistella" ;
lin kovite_N = mkkN "kovite" ;
lin kovittaa_V = mkkV "kovittaa" ;
lin kovitus_N = mkkN "kovitus" ;
lin kovuinen_N = mkkN "kovuinen" ;
lin kovuus_N = mkkN "kovuus" ;
lin kraana_N = mkkN "kraana" ;
lin kraatteri_N = mkkN "kraatteri" ;
lin kraavata_V = mkkV "kraavata" ;
lin kraavi_N = mkkN "kraavi" ;
lin kraiveli_N = mkkN "kraiveli" ;
lin krakata_V = mkkV "krakata" ;
lin krakkaamo_N = mkkN "krakkaamo" ;
lin krakkaus_N = mkkN "krakkaus" ;
lin krakkeri_N = mkkN "krakkeri" ;
lin kramppi_N = mkkN "kramppi" ;
lin kranaatti_N = mkkN "kranaatti" ;
lin kranssi_N = mkkN "kranssi" ;
lin kranttu_N = mkkN "kranttu" ;
lin krappi_N = mkkN "krappi" ;
lin krapu_N = mkkN "krapu" ;
lin krapula_N = mkkN "krapula" ;
lin krassi_N = mkkN "krassi" ;
lin kravatti_N = mkkN "kravatti" ;
lin kreatiivinen_N = mkkN "kreatiivinen" ;
lin kreationismi_N = mkkN "kreationismi" ;
lin kreationisti_N = mkkN "kreationisti" ;
lin kreationistinen_N = mkkN "kreationistinen" ;
lin krediitti_N = mkkN "krediitti" ;
lin kredit_N = mkkN "kredit" ;
lin kreditoida_V = mkkV "kreditoida" ;
lin kreemi_N = mkkN "kreemi" ;
lin kreikatar_N = mkkN "kreikatar" ;
lin kreikka_N = mkkN "kreikka" ;
lin kreikkalaisuus_N = mkkN "kreikkalaisuus" ;
lin kreisi_N = mkkN "kreisi" ;
lin kreivi_N = mkkN "kreivi" ;
lin kreivillinen_N = mkkN "kreivillinen" ;
lin kreivita'r_N = mkkN "kreivitär" ;
lin krematoida_V = mkkV "krematoida" ;
lin krematointi_N = mkkN "krematointi" ;
lin krematorio_N = mkkN "krematorio" ;
lin kremlologi_N = mkkN "kremlologi" ;
lin kremlologia_N = mkkN "kremlologia" ;
lin kremppa_N = mkkN "kremppa" ;
lin krenato'o'ri_N = mkkN "krenatööri" ;
lin kreoli_N = mkkN "kreoli" ;
lin krepata_V = mkkV "krepata" ;
lin kreppaus_N = mkkN "kreppaus" ;
lin kreppi_N = mkkN "kreppi" ;
lin krepsi_N = mkkN "krepsi" ;
lin kretliini_N = mkkN "kretliini" ;
lin kretonki_N = mkkN "kretonki" ;
lin kriikuna_N = mkkN "kriikuna" ;
lin kriisi_N = mkkN "kriisi" ;
lin kriisiaika_N = mkkN "kriisiaika" ;
lin kriitikko_N = mkkN "kriitikko" ;
lin kriittinen_A = mkkA "kriittinen" ;
lin kriittisesti_Adv = mkkAdv "kriittisesti" ;
lin kriittisyys_N = mkkN "kriittisyys" ;
lin kriketti_N = mkkN "kriketti" ;
lin krilli_N = mkkN "krilli" ;
lin krimi_N = mkkN "krimi" ;
lin kriminaalinen_N = mkkN "kriminaalinen" ;
lin kriminaalistaa_V = mkkV "kriminaalistaa" ;
lin kriminalisoida_V = mkkV "kriminalisoida" ;
lin kriminalisointi_N = mkkN "kriminalisointi" ;
lin kriminalisti_N = mkkN "kriminalisti" ;
lin kriminalistiikka_N = mkkN "kriminalistiikka" ;
lin kriminologi_N = mkkN "kriminologi" ;
lin kriminologia_N = mkkN "kriminologia" ;
lin kriminologinen_N = mkkN "kriminologinen" ;
lin krinoliini_N = mkkN "krinoliini" ;
lin kristalli_N = mkkN "kristalli" ;
lin kristallinen_N = mkkN "kristallinen" ;
lin kristallisoida_V = mkkV "kristallisoida" ;
lin kristallisoitua_V = mkkV "kristallisoitua" ;
lin kristalloida_V = mkkV "kristalloida" ;
lin kristalloitua_V = mkkV "kristalloitua" ;
lin kristillinen_A = mkkA "kristillinen" ;
lin kristillisesti_Adv = mkkAdv "kristillisesti" ;
lin kristillisyys_N = mkkN "kristillisyys" ;
lin kristitty_N = mkkN "kristitty" ;
lin kristologia_N = mkkN "kristologia" ;
lin kriteeri_N = mkkN "kriteeri" ;
lin kritiikitto'myys_N = mkkN "kritiikittömyys" ;
lin kritiikitto'ma'sti_Adv = mkkAdv "kritiikittömästi" ;
lin kritiikito'n_N = mkkN "kritiikitön" ;
lin kritiikki_N = mkkN "kritiikki" ;
lin kritikoida_V = mkkV "kritikoida" ;
lin kritikointi_N = mkkN "kritikointi" ;
lin kritisoida_V = mkkV "kritisoida" ;
lin kritisointi_N = mkkN "kritisointi" ;
lin kroaatti_N = mkkN "kroaatti" ;
lin kroatia_N = mkkN "kroatia" ;
lin kroisos_N = mkkN "kroisos" ;
lin kroissantti_N = mkkN "kroissantti" ;
lin krokaani_N = mkkN "krokaani" ;
lin kroketti_N = mkkN "kroketti" ;
lin krokotiili_N = mkkN "krokotiili" ;
lin kromaattinen_N = mkkN "kromaattinen" ;
lin kromata_V = mkkV "kromata" ;
lin kromaus_N = mkkN "kromaus" ;
lin kromi_N = mkkN "kromi" ;
lin kromioida_V = mkkV "kromioida" ;
lin kromittaa_V = mkkV "kromittaa" ;
lin kromitus_N = mkkN "kromitus" ;
lin kromosomi_N = mkkN "kromosomi" ;
lin kromosomisto_N = mkkN "kromosomisto" ;
lin kronikka_N = mkkN "kronikka" ;
lin kronikoida_V = mkkV "kronikoida" ;
lin kronikoitsija_N = mkkN "kronikoitsija" ;
lin kronkeli_N = mkkN "kronkeli" ;
lin kronologia_N = mkkN "kronologia" ;
lin kronologinen_A = mkkA "kronologinen" ;
lin kronologisesti_Adv = mkkAdv "kronologisesti" ;
lin kronometri_N = mkkN "kronometri" ;
lin krookus_N = mkkN "krookus" ;
lin kroolata_V = mkkV "kroolata" ;
lin krooli_N = mkkN "krooli" ;
lin kroonikko_N = mkkN "kroonikko" ;
lin krooninen_A = mkkA "krooninen" ;
lin kroonisesti_Adv = mkkAdv "kroonisesti" ;
lin kroonistaa_V = mkkV "kroonistaa" ;
lin kroonistua_V = mkkV "kroonistua" ;
lin kroonisuus_N = mkkN "kroonisuus" ;
lin kroppa_N = mkkN "kroppa" ;
lin krossi_N = mkkN "krossi" ;
lin krouvi_1_N = mkkN "krouvi" ;
lin krouvi_2_N = mkkN "krouvi" ;
lin kruksata_V = mkkV "kruksata" ;
lin kruksi_N = mkkN "kruksi" ;
lin krumeluuri_N = mkkN "krumeluuri" ;
lin krupieeri_N = mkkN "krupieeri" ;
lin krusifiksi_N = mkkN "krusifiksi" ;
lin kruska_N = mkkN "kruska" ;
lin krustadi_N = mkkN "krustadi" ;
lin kruuna_N = mkkN "kruuna" ;
lin kruunaaja_N = mkkN "kruunaaja" ;
lin kruunaamaton_N = mkkN "kruunaamaton" ;
--? lin kruunajaiset_NK = {s = d38 "kruunajaiset" ;
lin kruunata_V = mkkV "kruunata" ;
lin kruunaus_N = mkkN "kruunaus" ;
lin kruunauttaa_V = mkkV "kruunauttaa" ;
lin kruunu_N = mkkN "kruunu" ;
lin kruusailla_V = mkkV "kruusailla" ;
lin kruusailu_N = mkkN "kruusailu" ;
lin kruusata_V = mkkV "kruusata" ;
lin kruusaus_N = mkkN "kruusaus" ;
lin krypta_N = mkkN "krypta" ;
lin kryptata_V = mkkV "kryptata" ;
lin kryptaus_N = mkkN "kryptaus" ;
lin krypto_N = mkkN "krypto" ;
lin krypton_N = mkkN "krypton" ;
lin krysanteemi_N = mkkN "krysanteemi" ;
lin kryssi_N = mkkN "kryssi" ;
lin kra'kki_N = mkkN "kräkki" ;
lin kra'na'_N = mkkN "kränä" ;
lin kra'na'ta'_V = mkkV "kränätä" ;
lin kra'a'sa'_N = mkkN "krääsä" ;
lin ksenon_N = mkkN "ksenon" ;
lin kserografia_N = mkkN "kserografia" ;
lin ksylitoli_N = mkkN "ksylitoli" ;
lin ksylofoni_N = mkkN "ksylofoni" ;
lin kubismi_N = mkkN "kubismi" ;
lin kubisti_N = mkkN "kubisti" ;
lin kubistinen_N = mkkN "kubistinen" ;
lin kude_N = mkkN "kude" ;
lin kudelma_N = mkkN "kudelma" ;
lin kudin_N = mkkN "kudin" ;
lin kudoksinen_N = mkkN "kudoksinen" ;
lin kudonnainen_N = mkkN "kudonnainen" ;
lin kudonta_N = mkkN "kudonta" ;
lin kudontainen_N = mkkN "kudontainen" ;
lin kudos_N = mkkN "kudos" ;
lin kuha_N = mkkN "kuha" ;
lin kuherrella_V = mkkV "kuherrella" ;
lin kuherrus_N = mkkN "kuherrus" ;
lin kuhertaa_V = mkkV "kuhertaa" ;
lin kuhertelu_N = mkkN "kuhertelu" ;
lin kuhilas_N = mkkN "kuhilas" ;
lin kuhina_N = mkkN "kuhina" ;
lin kuhista_V = mkkV "kuhista" ;
lin kuhkia_V = mkkV "kuhkia" ;
lin kuhmu_N = mkkN "kuhmu" ;
lin kuhmuinen_N = mkkN "kuhmuinen" ;
lin kuhmura_N = mkkN "kuhmura" ;
lin kuhmurainen_N = mkkN "kuhmurainen" ;
lin kuhmuuntua_V = mkkV "kuhmuuntua" ;
lin kuhnailija_N = mkkN "kuhnailija" ;
lin kuhnailla_V = mkkV "kuhnailla" ;
lin kuhnailu_N = mkkN "kuhnailu" ;
lin kuhnia_V = mkkV "kuhnia" ;
lin kuhnuri_N = mkkN "kuhnuri" ;
lin kuhnus_N = mkkN "kuhnus" ;
lin kuhnustella_V = mkkV "kuhnustella" ;
lin kuhun_Adv = mkkAdv "kuhun" ;
lin kuhunka_Adv = mkkAdv "kuhunka" ;
lin kuidusto_N = mkkN "kuidusto" ;
lin kuidutin_N = mkkN "kuidutin" ;
lin kuiduttaa_V = mkkV "kuiduttaa" ;
lin kuidutus_N = mkkN "kuidutus" ;
lin kuihduttaa_V = mkkV "kuihduttaa" ;
lin kuihtua_V = mkkV "kuihtua" ;
lin kuihtumaton_N = mkkN "kuihtumaton" ;
lin kuihtumus_N = mkkN "kuihtumus" ;
lin kuikelo_N = mkkN "kuikelo" ;
lin kuikka_N = mkkN "kuikka" ;
lin kuikuilla_V = mkkV "kuikuilla" ;
lin kuikuilu_N = mkkN "kuikuilu" ;
lin kuilu_N = mkkN "kuilu" ;
lin kuin_Adv = mkkAdv "kuin" ;
lin kuinen_N = mkkN "kuinen" ;
lin kuinka_Adv = mkkAdv "kuinka" ;
lin kuinkaan_Adv = mkkAdv "kuinkaan" ;
lin kuiri_N = mkkN "kuiri" ;
lin kuirimo_N = mkkN "kuirimo" ;
lin kuiskaaja_N = mkkN "kuiskaaja" ;
lin kuiskailla_V = mkkV "kuiskailla" ;
lin kuiskailu_N = mkkN "kuiskailu" ;
lin kuiskata_V = mkkV "kuiskata" ;
lin kuiskaus_N = mkkN "kuiskaus" ;
lin kuiske_N = mkkN "kuiske" ;
lin kuiskia_V = mkkV "kuiskia" ;
lin kuiskina_N = mkkN "kuiskina" ;
lin kuiskinta_N = mkkN "kuiskinta" ;
lin kuiskutella_V = mkkV "kuiskutella" ;
lin kuiskuttaa_V = mkkV "kuiskuttaa" ;
lin kuiskuttelu_N = mkkN "kuiskuttelu" ;
lin kuiskutus_N = mkkN "kuiskutus" ;
lin kuisma_N = mkkN "kuisma" ;
lin kuisti_N = mkkN "kuisti" ;
lin kuitata_V = mkkV "kuitata" ;
lin kuitenkaan_Adv = mkkAdv "kuitenkaan" ;
lin kuitenkin_Adv = mkkAdv "kuitenkin" ;
lin kuittaantua_V = mkkV "kuittaantua" ;
lin kuittaus_N = mkkN "kuittaus" ;
lin kuittautua_V = mkkV "kuittautua" ;
lin kuitti_N = mkkN "kuitti" ;
lin kuitu_N = mkkN "kuitu" ;
lin kuituinen_N = mkkN "kuituinen" ;
lin kuiva_A = mkkA "kuiva" ;
lin kuivaa_V = mkkV "kuivaa" ;
lin kuivaaja_N = mkkN "kuivaaja" ;
lin kuivaamo_N = mkkN "kuivaamo" ;
lin kuivahtaa_V = mkkV "kuivahtaa" ;
lin kuivailla_V = mkkV "kuivailla" ;
lin kuivain_N = mkkN "kuivain" ;
lin kuivakas_N = mkkN "kuivakas" ;
lin kuivakiskoisesti_Adv = mkkAdv "kuivakiskoisesti" ;
lin kuivakiskoisuus_N = mkkN "kuivakiskoisuus" ;
lin kuivakka_N = mkkN "kuivakka" ;
lin kuivasti_Adv = mkkAdv "kuivasti" ;
lin kuivata_V = mkkV "kuivata" ;
lin kuivate_N = mkkN "kuivate" ;
lin kuivatella_V = mkkV "kuivatella" ;
lin kuivatin_N = mkkN "kuivatin" ;
lin kuivattaa_V = mkkV "kuivattaa" ;
lin kuivattamo_N = mkkN "kuivattamo" ;
lin kuivatus_N = mkkN "kuivatus" ;
lin kuivaus_N = mkkN "kuivaus" ;
lin kuivettaa_V = mkkV "kuivettaa" ;
lin kuivettua_V = mkkV "kuivettua" ;
lin kuiviin_Adv = mkkAdv "kuiviin" ;
lin kuivike_N = mkkN "kuivike" ;
lin kuivilla_Adv = mkkAdv "kuivilla" ;
lin kuiville_Adv = mkkAdv "kuiville" ;
lin kuiviltaan_Adv = mkkAdv "kuiviltaan" ;
lin kuivio_N = mkkN "kuivio" ;
lin kuivua_V = mkkV "kuivua" ;
lin kuivumisaika_N = mkkN "kuivumisaika" ;
lin kuivuri_N = mkkN "kuivuri" ;
lin kuivuus_N = mkkN "kuivuus" ;
lin kuja_N = mkkN "kuja" ;
lin kujanne_N = mkkN "kujanne" ;
lin kuje_N = mkkN "kuje" ;
lin kujeellinen_A = mkkA "kujeellinen" ;
lin kujeellisesti_Adv = mkkAdv "kujeellisesti" ;
lin kujeilija_N = mkkN "kujeilija" ;
lin kujeilla_V = mkkV "kujeilla" ;
lin kujeilu_N = mkkN "kujeilu" ;
lin kujerrus_N = mkkN "kujerrus" ;
lin kujertaa_V = mkkV "kujertaa" ;
lin kukahdus_N = mkkN "kukahdus" ;
lin kukahtaa_V = mkkV "kukahtaa" ;
lin kukallinen_N = mkkN "kukallinen" ;
lin kukerrus_N = mkkN "kukerrus" ;
lin kukertaa_V = mkkV "kukertaa" ;
lin kukertava_N = mkkN "kukertava" ;
lin kukikas_N = mkkN "kukikas" ;
lin kukinta_N = mkkN "kukinta" ;
lin kukinta_aika_N = mkkN "kukinta-aika" ;
lin kukintainen_N = mkkN "kukintainen" ;
lin kukinto_N = mkkN "kukinto" ;
lin kukistaa_V = mkkV "kukistaa" ;
lin kukistua_V = mkkV "kukistua" ;
lin kukittaa_V = mkkV "kukittaa" ;
lin kukka_N = mkkN "kukka" ;
lin kukkainen_N = mkkN "kukkainen" ;
lin kukkaisa_N = mkkN "kukkaisa" ;
lin kukkanen_N = mkkN "kukkanen" ;
lin kukkaro_N = mkkN "kukkaro" ;
lin kukkea_N = mkkN "kukkea" ;
lin kukkeus_N = mkkN "kukkeus" ;
lin kukkia_V = mkkV "kukkia" ;
lin kukkimisaika_N = mkkN "kukkimisaika" ;
lin kukko_N = mkkN "kukko" ;
lin kukkoilla_V = mkkV "kukkoilla" ;
lin kukkoilu_N = mkkN "kukkoilu" ;
lin kukkonen_N = mkkN "kukkonen" ;
lin kukku_Adv = mkkAdv "kukku" ;
lin kukkua_V = mkkV "kukkua" ;
lin kukkula_N = mkkN "kukkula" ;
lin kukkura_N = mkkN "kukkura" ;
lin kukkurainen_N = mkkN "kukkurainen" ;
lin kukkurallaan_Adv = mkkAdv "kukkurallaan" ;
lin kukkuralleen_Adv = mkkAdv "kukkuralleen" ;
lin kukkuranaan_Adv = mkkAdv "kukkuranaan" ;
lin kukkuroillaan_Adv = mkkAdv "kukkuroillaan" ;
lin kukkuroilleen_Adv = mkkAdv "kukkuroilleen" ;
lin kukkuu_Adv = mkkAdv "kukkuu" ;
lin kukoistaa_V = mkkV "kukoistaa" ;
lin kukoistus_N = mkkN "kukoistus" ;
lin kukoistusaika_N = mkkN "kukoistusaika" ;
lin kuksa_N = mkkN "kuksa" ;
lin kukunta_N = mkkN "kukunta" ;
lin kukuttaa_V = mkkV "kukuttaa" ;
lin kulahtaa_1_V = mkkV "kulahtaa" ;
lin kulahtaa_2_V = mkkV "kulahtaa" ;
lin kulakki_N = mkkN "kulakki" ;
lin kulauksittain_Adv = mkkAdv "kulauksittain" ;
lin kulaus_N = mkkN "kulaus" ;
lin kulautella_V = mkkV "kulautella" ;
lin kulauttaa_V = mkkV "kulauttaa" ;
lin kuleksia_V = mkkV "kuleksia" ;
lin kulho_N = mkkN "kulho" ;
lin kulhollinen_N = mkkN "kulhollinen" ;
lin kuli_N = mkkN "kuli" ;
lin kulinaarinen_N = mkkN "kulinaarinen" ;
lin kulinarismi_N = mkkN "kulinarismi" ;
lin kulinaristi_N = mkkN "kulinaristi" ;
lin kulissi_N = mkkN "kulissi" ;
lin kuljeksia_V = mkkV "kuljeksia" ;
lin kuljeksija_N = mkkN "kuljeksija" ;
lin kuljeksinta_N = mkkN "kuljeksinta" ;
lin kuljeskelija_N = mkkN "kuljeskelija" ;
lin kuljeskella_V = mkkV "kuljeskella" ;
lin kuljeskelu_N = mkkN "kuljeskelu" ;
lin kuljetella_V = mkkV "kuljetella" ;
lin kuljetin_N = mkkN "kuljetin" ;
lin kuljettaa_V = mkkV "kuljettaa" ;
lin kuljettaja_N = mkkN "kuljettaja" ;
lin kuljettajankoppi_N = mkkN "kuljettajankoppi" ;
lin kuljetus_N = mkkN "kuljetus" ;
lin kuljetuttaa_V = mkkV "kuljetuttaa" ;
lin kulju_N = mkkN "kulju" ;
lin kulkea_V = mkkV "kulkea" ;
lin kulkeentua_V = mkkV "kulkeentua" ;
lin kulkeilla_Adv = mkkAdv "kulkeilla" ;
lin kulkeille_Adv = mkkAdv "kulkeille" ;
lin kulkeuma_N = mkkN "kulkeuma" ;
lin kulkeutua_V = mkkV "kulkeutua" ;
lin kulkija_N = mkkN "kulkija" ;
lin kulku_N = mkkN "kulku" ;
lin kulkuaika_N = mkkN "kulkuaika" ;
lin kulkue_N = mkkN "kulkue" ;
lin kulkuinen_N = mkkN "kulkuinen" ;
lin kulkunen_N = mkkN "kulkunen" ;
lin kulkuri_N = mkkN "kulkuri" ;
lin kulkusalla_Adv = mkkAdv "kulkusalla" ;
lin kulkusalle_Adv = mkkAdv "kulkusalle" ;
lin kullastaa_V = mkkV "kullastaa" ;
lin kullata_V = mkkV "kullata" ;
lin kullero_N = mkkN "kullero" ;
lin kulli_N = mkkN "kulli" ;
lin kulloinenkin_N = mkkN "kulloinenkin" ;
lin kulloinkin_Adv = mkkAdv "kulloinkin" ;
lin kulma_N = mkkN "kulma" ;
lin kulmainen_N = mkkN "kulmainen" ;
lin kulmakerroin_N = mkkN "kulmakerroin" ;
lin kulmata_V = mkkV "kulmata" ;
lin kulmatusten_Adv = mkkAdv "kulmatusten" ;
lin kulmaus_N = mkkN "kulmaus" ;
lin kulmikas_A = mkkA "kulmikas" ;
lin kulmikkaasti_Adv = mkkAdv "kulmikkaasti" ;
lin kulmikkuus_N = mkkN "kulmikkuus" ;
lin kulminaatio_N = mkkN "kulminaatio" ;
lin kulminoitua_V = mkkV "kulminoitua" ;
lin kulmio_N = mkkN "kulmio" ;
lin kulmittain_Adv = mkkAdv "kulmittain" ;
lin kulmittainen_N = mkkN "kulmittainen" ;
lin kulmuri_N = mkkN "kulmuri" ;
lin kulo_N = mkkN "kulo" ;
lin kulottaa_V = mkkV "kulottaa" ;
lin kulottua_V = mkkV "kulottua" ;
lin kulotus_N = mkkN "kulotus" ;
lin kuloutua_V = mkkV "kuloutua" ;
lin kulta_N = mkkN "kulta" ;
lin kulta_aika_N = mkkN "kulta-aika" ;
lin kultainen_A = mkkA "kultainen" ;
lin kultaisesti_Adv = mkkAdv "kultaisesti" ;
lin kultaisuus_N = mkkN "kultaisuus" ;
lin kultakutri_N = mkkN "kultakutri" ;
lin kultala_N = mkkN "kultala" ;
lin kultanen_Adv = mkkAdv "kultanen" ;
lin kultaus_N = mkkN "kultaus" ;
lin kultautua_V = mkkV "kultautua" ;
lin kulti_N = mkkN "kulti" ;
lin kultivaattori_N = mkkN "kultivaattori" ;
lin kultivoida_V = mkkV "kultivoida" ;
lin kultivoitua_V = mkkV "kultivoitua" ;
lin kultti_N = mkkN "kultti" ;
lin kulttuuri_N = mkkN "kulttuuri" ;
lin kulttuurillinen_N = mkkN "kulttuurillinen" ;
lin kulttuurinen_A = mkkA "kulttuurinen" ;
lin kulttuurinkarttaja_N = mkkN "kulttuurinkarttaja" ;
lin kulttuurisesti_Adv = mkkAdv "kulttuurisesti" ;
lin kulturelli_N = mkkN "kulturelli" ;
lin kulu_N = mkkN "kulu" ;
lin kulua_V = mkkV "kulua" ;
lin kuluma_N = mkkN "kuluma" ;
lin kulumisvika_N = mkkN "kulumisvika" ;
lin kuluneisuus_N = mkkN "kuluneisuus" ;
lin kulunki_N = mkkN "kulunki" ;
lin kulussa_Adv = mkkAdv "kulussa" ;
lin kuluttaa_V = mkkV "kuluttaa" ;
lin kuluttaja_N = mkkN "kuluttaja" ;
lin kuluttajansuoja_N = mkkN "kuluttajansuoja" ;
lin kulutus_N = mkkN "kulutus" ;
lin kulo'o'ri_N = mkkN "kulööri" ;
lin kumahdella_V = mkkV "kumahdella" ;
lin kumahdus_N = mkkN "kumahdus" ;
lin kumahtaa_V = mkkV "kumahtaa" ;
lin kumajaa_V = mkkV "kumajaa" ;
lin kumara_N = mkkN "kumara" ;
lin kumaraan_Adv = mkkAdv "kumaraan" ;
lin kumarainen_N = mkkN "kumarainen" ;
lin kumarassa_Adv = mkkAdv "kumarassa" ;
lin kumariini_N = mkkN "kumariini" ;
lin kumarrella_V = mkkV "kumarrella" ;
lin kumarruksiin_Adv = mkkAdv "kumarruksiin" ;
lin kumarruksissa_Adv = mkkAdv "kumarruksissa" ;
lin kumarrus_N = mkkN "kumarrus" ;
lin kumartaa_V = mkkV "kumartaa" ;
lin kumartua_V = mkkV "kumartua" ;
lin kumaruus_N = mkkN "kumaruus" ;
lin kumaus_N = mkkN "kumaus" ;
lin kumauttaa_1_V = mkkV "kumauttaa" ;
lin kumauttaa_2_V = mkkV "kumauttaa" ;
lin kumea_A = mkkA "kumea" ;
lin kumeasti_Adv = mkkAdv "kumeasti" ;
lin kumi_N = mkkN "kumi" ;
lin kumina_1_N = mkkN "kumina" ;
lin kumina_2_N = mkkN "kumina" ;
lin kuminen_N = mkkN "kuminen" ;
lin kumissi_N = mkkN "kumissi" ;
lin kumista_V = mkkV "kumista" ;
lin kumistin_N = mkkN "kumistin" ;
lin kumisuttaa_V = mkkV "kumisuttaa" ;
lin kumittaa_V = mkkV "kumittaa" ;
lin kumkvatti_N = mkkN "kumkvatti" ;
lin kumma_A = mkkA "kumma" ;
lin kummajainen_N = mkkN "kummajainen" ;
lin kummaksua_V = mkkV "kummaksua" ;
lin kummallinen_A = mkkA "kummallinen" ;
lin kummallisesti_Adv = mkkAdv "kummallisesti" ;
lin kummallisuus_N = mkkN "kummallisuus" ;
lin kummankinlainen_N = mkkN "kummankinlainen" ;
lin kummanne_Adv = mkkAdv "kummanne" ;
--? lin kummarit_NK = {s = d06 "kummarit" ;
lin kummastella_V = mkkV "kummastella" ;
lin kummastelu_N = mkkN "kummastelu" ;
lin kummasti_Adv = mkkAdv "kummasti" ;
lin kummastua_V = mkkV "kummastua" ;
lin kummastuksissaan_Adv = mkkAdv "kummastuksissaan" ;
lin kummastus_N = mkkN "kummastus" ;
lin kummastuttaa_V = mkkV "kummastuttaa" ;
lin kummata_V = mkkV "kummata" ;
lin kummeksia_V = mkkV "kummeksia" ;
lin kummeksua_V = mkkV "kummeksua" ;
lin kummeksuttaa_V = mkkV "kummeksuttaa" ;
lin kummeli_N = mkkN "kummeli" ;
lin kummeta_V = mkkV "kummeta" ;
lin kummi_N = mkkN "kummi" ;
lin kumminkaan_Adv = mkkAdv "kumminkaan" ;
lin kumminkin_Adv = mkkAdv "kumminkin" ;
lin kummissaan_Adv = mkkAdv "kummissaan" ;
lin kummitella_V = mkkV "kummitella" ;
lin kummittelu_N = mkkN "kummittelu" ;
lin kummitus_N = mkkN "kummitus" ;
lin kummoinen_N = mkkN "kummoinen" ;
lin kummuta_V = mkkV "kummuta" ;
lin kumoamaton_N = mkkN "kumoamaton" ;
lin kumoamattomasti_Adv = mkkAdv "kumoamattomasti" ;
lin kumoamattomuus_N = mkkN "kumoamattomuus" ;
lin kumollaan_Adv = mkkAdv "kumollaan" ;
lin kumolleen_Adv = mkkAdv "kumolleen" ;
lin kumoon_Adv = mkkAdv "kumoon" ;
lin kumossa_Adv = mkkAdv "kumossa" ;
lin kumota_V = mkkV "kumota" ;
lin kumottaa_V = mkkV "kumottaa" ;
lin kumotus_N = mkkN "kumotus" ;
lin kumouksellinen_N = mkkN "kumouksellinen" ;
lin kumouksellisuus_N = mkkN "kumouksellisuus" ;
lin kumous_N = mkkN "kumous" ;
lin kumoutua_V = mkkV "kumoutua" ;
lin kumpainen_N = mkkN "kumpainen" ;
lin kumpainenkaan_N = mkkN "kumpainenkaan" ;
lin kumpainenkin_N = mkkN "kumpainenkin" ;
lin kumpare_N = mkkN "kumpare" ;
lin kumpareikko_N = mkkN "kumpareikko" ;
lin kumpareinen_N = mkkN "kumpareinen" ;
lin kumpeli_N = mkkN "kumpeli" ;
lin kumpi_N = mkkN "kumpi" ;
lin kumpikaan_N = mkkN "kumpikaan" ;
lin kumpikin_N = mkkN "kumpikin" ;
lin kumppani_N = mkkN "kumppani" ;
--? lin kumppanukset_NK = {s = d39 "kumppanukset" ;
lin kumppanuus_N = mkkN "kumppanuus" ;
lin kumpu_N = mkkN "kumpu" ;
lin kumpuilla_V = mkkV "kumpuilla" ;
lin kumpuinen_N = mkkN "kumpuinen" ;
lin kumu_1_N = mkkN "kumu" ;
lin kumu_2_N = mkkN "kumu" ;
lin kumulaatio_N = mkkN "kumulaatio" ;
lin kumulatiivinen_N = mkkN "kumulatiivinen" ;
lin kumuloida_V = mkkV "kumuloida" ;
lin kumuloitua_V = mkkV "kumuloitua" ;
lin kumuri_N = mkkN "kumuri" ;
lin kun_Adv = mkkAdv "kun" ;
lin kundi_N = mkkN "kundi" ;
lin kung_fu_N = mkkN "kung-fu" ;
lin kungfutselainen_N = mkkN "kungfutselainen" ;
lin kungfutselaisuus_N = mkkN "kungfutselaisuus" ;
lin kuningas_N = mkkN "kuningas" ;
lin kuningasaika_N = mkkN "kuningasaika" ;
lin kuningatar_N = mkkN "kuningatar" ;
lin kuninkaallinen_A = mkkA "kuninkaallinen" ;
lin kuninkaallisesti_Adv = mkkAdv "kuninkaallisesti" ;
lin kuninkaallisuus_N = mkkN "kuninkaallisuus" ;
lin kuninkuus_N = mkkN "kuninkuus" ;
lin kunkku_N = mkkN "kunkku" ;
lin kunnallinen_N = mkkN "kunnallinen" ;
lin kunnallistaa_V = mkkV "kunnallistaa" ;
lin kunnari_N = mkkN "kunnari" ;
lin kunnas_N = mkkN "kunnas" ;
lin kunne_Adv = mkkAdv "kunne" ;
lin kunnekaan_Adv = mkkAdv "kunnekaan" ;
lin kunnekin_Adv = mkkAdv "kunnekin" ;
lin kunnes_Adv = mkkAdv "kunnes" ;
lin kunnia_N = mkkN "kunnia" ;
lin kunniakas_A = mkkA "kunniakas" ;
lin kunniakkaasti_Adv = mkkAdv "kunniakkaasti" ;
lin kunniakkuus_N = mkkN "kunniakkuus" ;
lin kunniallinen_A = mkkA "kunniallinen" ;
lin kunniallisesti_Adv = mkkAdv "kunniallisesti" ;
lin kunniallisuus_N = mkkN "kunniallisuus" ;
lin kunnianhimoisesti_Adv = mkkAdv "kunnianhimoisesti" ;
lin kunniaton_N = mkkN "kunniaton" ;
lin kunniattomasti_Adv = mkkAdv "kunniattomasti" ;
lin kunnioitettava_A = mkkA "kunnioitettava" ;
lin kunnioitettavasti_Adv = mkkAdv "kunnioitettavasti" ;
lin kunnioitettavuus_N = mkkN "kunnioitettavuus" ;
lin kunnioittaa_V = mkkV "kunnioittaa" ;
lin kunnioittava_A = mkkA "kunnioittava" ;
lin kunnioittavasti_Adv = mkkAdv "kunnioittavasti" ;
lin kunnioitus_N = mkkN "kunnioitus" ;
lin kunnittain_Adv = mkkAdv "kunnittain" ;
lin kunnittainen_N = mkkN "kunnittainen" ;
lin kunnokas_N = mkkN "kunnokas" ;
lin kunnolla_Adv = mkkAdv "kunnolla" ;
lin kunnollinen_A = mkkA "kunnollinen" ;
lin kunnollisesti_Adv = mkkAdv "kunnollisesti" ;
lin kunnollisuus_N = mkkN "kunnollisuus" ;
lin kunnon_Adv = mkkAdv "kunnon" ;
lin kunnossa_Adv = mkkAdv "kunnossa" ;
lin kunnostaa_V = mkkV "kunnostaa" ;
lin kunnostamo_N = mkkN "kunnostamo" ;
lin kunnostautua_V = mkkV "kunnostautua" ;
lin kunnostus_N = mkkN "kunnostus" ;
lin kunnoton_N = mkkN "kunnoton" ;
lin kunpa_Adv = mkkAdv "kunpa" ;
lin kunta_N = mkkN "kunta" ;
lin kunto_N = mkkN "kunto" ;
lin kuntoilija_N = mkkN "kuntoilija" ;
lin kuntoilla_V = mkkV "kuntoilla" ;
lin kuntoilu_N = mkkN "kuntoilu" ;
lin kuntoisuus_N = mkkN "kuntoisuus" ;
lin kuntoon_Adv = mkkAdv "kuntoon" ;
lin kuntouttaa_V = mkkV "kuntouttaa" ;
lin kuntoutua_V = mkkV "kuntoutua" ;
lin kuntoutus_N = mkkN "kuntoutus" ;
lin kuntta_N = mkkN "kuntta" ;
lin kuoha_N = mkkN "kuoha" ;
lin kuohahdella_V = mkkV "kuohahdella" ;
lin kuohahtaa_V = mkkV "kuohahtaa" ;
lin kuohari_1_N = mkkN "kuohari" ;
lin kuohari_2_N = mkkN "kuohari" ;
lin kuohia_V = mkkV "kuohia" ;
lin kuohilas_N = mkkN "kuohilas" ;
lin kuohinta_N = mkkN "kuohinta" ;
lin kuohita_V = mkkV "kuohita" ;
lin kuohitsija_N = mkkN "kuohitsija" ;
lin kuohkea_N = mkkN "kuohkea" ;
lin kuohketa_V = mkkV "kuohketa" ;
lin kuohkeus_N = mkkN "kuohkeus" ;
lin kuohkeuttaa_V = mkkV "kuohkeuttaa" ;
lin kuohkeutua_V = mkkV "kuohkeutua" ;
lin kuohu_N = mkkN "kuohu" ;
lin kuohua_V = mkkV "kuohua" ;
lin kuohuinen_N = mkkN "kuohuinen" ;
lin kuohuksiin_Adv = mkkAdv "kuohuksiin" ;
lin kuohuksissa_Adv = mkkAdv "kuohuksissa" ;
lin kuohunta_N = mkkN "kuohunta" ;
lin kuohuta_V = mkkV "kuohuta" ;
lin kuohuttaa_V = mkkV "kuohuttaa" ;
lin kuokinta_N = mkkN "kuokinta" ;
lin kuokka_N = mkkN "kuokka" ;
lin kuokkia_V = mkkV "kuokkia" ;
lin kuokkija_N = mkkN "kuokkija" ;
lin kuola_N = mkkN "kuola" ;
--? lin kuolaimet_NK = {s = d33 "kuolaimet" ;
lin kuolainen_N = mkkN "kuolainen" ;
lin kuolata_V = mkkV "kuolata" ;
lin kuoleentua_V = mkkV "kuoleentua" ;
lin kuolema_N = mkkN "kuolema" ;
lin kuolemaantuomittu_N = mkkN "kuolemaantuomittu" ;
lin kuolemanvaara_N = mkkN "kuolemanvaara" ;
lin kuolematon_N = mkkN "kuolematon" ;
lin kuolemattomuus_N = mkkN "kuolemattomuus" ;
lin kuolettaa_V = mkkV "kuolettaa" ;
lin kuolettava_A = mkkA "kuolettava" ;
lin kuolettavasti_Adv = mkkAdv "kuolettavasti" ;
lin kuolettavuus_N = mkkN "kuolettavuus" ;
lin kuoletus_N = mkkN "kuoletus" ;
lin kuoletusaika_N = mkkN "kuoletusaika" ;
lin kuoleutua_V = mkkV "kuoleutua" ;
lin kuolevainen_N = mkkN "kuolevainen" ;
lin kuolevaisuus_N = mkkN "kuolevaisuus" ;
lin kuolevuus_N = mkkN "kuolevuus" ;
lin kuoliaaksi_Adv = mkkAdv "kuoliaaksi" ;
lin kuoliaana_Adv = mkkAdv "kuoliaana" ;
lin kuolinaika_N = mkkN "kuolinaika" ;
lin kuolio_N = mkkN "kuolio" ;
lin kuolioinen_N = mkkN "kuolioinen" ;
lin kuolioitua_V = mkkV "kuolioitua" ;
lin kuolla_V = mkkV "kuolla" ;
lin kuolleeton_N = mkkN "kuolleeton" ;
lin kuolleisuus_N = mkkN "kuolleisuus" ;
lin kuollut_N = mkkN "kuollut" ;
lin kuolo_N = mkkN "kuolo" ;
lin kuolokohta_N = mkkN "kuolokohta" ;
lin kuoma_N = mkkN "kuoma" ;
lin kuomu_N = mkkN "kuomu" ;
lin kuona_N = mkkN "kuona" ;
lin kuonnuttaa_V = mkkV "kuonnuttaa" ;
lin kuono_N = mkkN "kuono" ;
lin kuonoinen_N = mkkN "kuonoinen" ;
lin kuontalo_N = mkkN "kuontalo" ;
lin kuontua_V = mkkV "kuontua" ;
lin kuopaista_V = mkkV "kuopaista" ;
lin kuopake_N = mkkN "kuopake" ;
lin kuopanne_N = mkkN "kuopanne" ;
lin kuopata_V = mkkV "kuopata" ;
lin kuopia_V = mkkV "kuopia" ;
lin kuoppa_N = mkkN "kuoppa" ;
lin kuoppaantua_V = mkkV "kuoppaantua" ;
lin kuoppainen_N = mkkN "kuoppainen" ;
lin kuoppautua_V = mkkV "kuoppautua" ;
lin kuopsuttaa_V = mkkV "kuopsuttaa" ;
lin kuopus_N = mkkN "kuopus" ;
lin kuoputtaa_V = mkkV "kuoputtaa" ;
lin kuore_N = mkkN "kuore" ;
lin kuorettua_V = mkkV "kuorettua" ;
lin kuorettuma_N = mkkN "kuorettuma" ;
lin kuoreutua_V = mkkV "kuoreutua" ;
lin kuoreutuma_N = mkkN "kuoreutuma" ;
lin kuori_1_N = mkkN "kuori" ;
lin kuori_2_N = mkkN "kuori" ;
lin kuoria_V = mkkV "kuoria" ;
lin kuoriainen_N = mkkN "kuoriainen" ;
lin kuorike_N = mkkN "kuorike" ;
lin kuorikko_N = mkkN "kuorikko" ;
lin kuorimo_N = mkkN "kuorimo" ;
lin kuorinen_N = mkkN "kuorinen" ;
lin kuorinta_N = mkkN "kuorinta" ;
lin kuorittaa_V = mkkV "kuorittaa" ;
lin kuoriutua_V = mkkV "kuoriutua" ;
lin kuorma_N = mkkN "kuorma" ;
lin kuormaaja_N = mkkN "kuormaaja" ;
lin kuormain_N = mkkN "kuormain" ;
lin kuormallinen_N = mkkN "kuormallinen" ;
lin kuormasto_N = mkkN "kuormasto" ;
lin kuormata_V = mkkV "kuormata" ;
lin kuormittaa_V = mkkV "kuormittaa" ;
lin kuormittain_Adv = mkkAdv "kuormittain" ;
lin kuormitteinen_N = mkkN "kuormitteinen" ;
lin kuormittua_V = mkkV "kuormittua" ;
lin kuormitus_N = mkkN "kuormitus" ;
lin kuormuri_N = mkkN "kuormuri" ;
lin kuoro_N = mkkN "kuoro" ;
lin kuorrute_N = mkkN "kuorrute" ;
lin kuorruttaa_V = mkkV "kuorruttaa" ;
lin kuorrutus_N = mkkN "kuorrutus" ;
lin kuorsata_V = mkkV "kuorsata" ;
lin kuorsaus_N = mkkN "kuorsaus" ;
lin kuortua_V = mkkV "kuortua" ;
lin kuortuma_N = mkkN "kuortuma" ;
lin kuorukka_N = mkkN "kuorukka" ;
lin kuosi_N = mkkN "kuosi" ;
lin kuosiinkudottu_N = mkkN "kuosiinkudottu" ;
lin kuosiinneulottu_N = mkkN "kuosiinneulottu" ;
lin kuosikas_N = mkkN "kuosikas" ;
lin kuosillinen_N = mkkN "kuosillinen" ;
lin kuosinen_N = mkkN "kuosinen" ;
lin kuosittaa_V = mkkV "kuosittaa" ;
lin kuositus_N = mkkN "kuositus" ;
lin kuovi_N = mkkN "kuovi" ;
lin kupari_N = mkkN "kupari" ;
lin kuparinen_N = mkkN "kuparinen" ;
lin kuparoida_V = mkkV "kuparoida" ;
lin kuparointi_N = mkkN "kuparointi" ;
lin kupata_V = mkkV "kupata" ;
lin kupeella_Adv = mkkAdv "kupeella" ;
lin kupeelle_Adv = mkkAdv "kupeelle" ;
lin kupeelta_Adv = mkkAdv "kupeelta" ;
lin kupeeseen_Adv = mkkAdv "kupeeseen" ;
lin kupeessa_Adv = mkkAdv "kupeessa" ;
lin kupeesta_Adv = mkkAdv "kupeesta" ;
lin kupeinen_N = mkkN "kupeinen" ;
lin kupera_N = mkkN "kupera" ;
lin kuperkeikka_N = mkkN "kuperkeikka" ;
lin kupertaa_V = mkkV "kupertaa" ;
lin kupertua_V = mkkV "kupertua" ;
lin kupillinen_N = mkkN "kupillinen" ;
lin kupla_N = mkkN "kupla" ;
lin kuplainen_N = mkkN "kuplainen" ;
lin kupletti_N = mkkN "kupletti" ;
lin kuplia_V = mkkV "kuplia" ;
lin kupo_N = mkkN "kupo" ;
lin kupoli_N = mkkN "kupoli" ;
lin kupolinen_N = mkkN "kupolinen" ;
lin kuponki_N = mkkN "kuponki" ;
lin kuppa_N = mkkN "kuppa" ;
lin kuppaaja_N = mkkN "kuppaaja" ;
lin kuppainen_N = mkkN "kuppainen" ;
lin kuppari_N = mkkN "kuppari" ;
lin kuppaus_N = mkkN "kuppaus" ;
lin kuppauttaa_V = mkkV "kuppauttaa" ;
lin kuppi_N = mkkN "kuppi" ;
lin kuppikoko_N = mkkN "kuppikoko" ;
lin kuppila_N = mkkN "kuppila" ;
lin kupponen_N = mkkN "kupponen" ;
lin kupriitti_N = mkkN "kupriitti" ;
lin kupristaa_V = mkkV "kupristaa" ;
lin kupristua_V = mkkV "kupristua" ;
lin kupro_N = mkkN "kupro" ;
lin kupru_N = mkkN "kupru" ;
lin kupruilla_V = mkkV "kupruilla" ;
lin kupsahtaa_V = mkkV "kupsahtaa" ;
lin kupu_N = mkkN "kupu" ;
lin kupula_N = mkkN "kupula" ;
lin kupura_N = mkkN "kupura" ;
lin kupurainen_N = mkkN "kupurainen" ;
lin kura_N = mkkN "kura" ;
lin kuraantua_V = mkkV "kuraantua" ;
lin kuraattori_N = mkkN "kuraattori" ;
lin kurainen_N = mkkN "kurainen" ;
lin kurantti_N = mkkN "kurantti" ;
lin kurare_N = mkkN "kurare" ;
lin kurata_V = mkkV "kurata" ;
lin kurdi_N = mkkN "kurdi" ;
lin kure_N = mkkN "kure" ;
lin kureinen_N = mkkN "kureinen" ;
lin kureutua_V = mkkV "kureutua" ;
lin kurho_N = mkkN "kurho" ;
lin kuri_N = mkkN "kuri" ;
lin kuriiri_N = mkkN "kuriiri" ;
lin kurikka_N = mkkN "kurikka" ;
lin kurillaan_Adv = mkkAdv "kurillaan" ;
lin kurillinen_A = mkkA "kurillinen" ;
lin kurillisesti_Adv = mkkAdv "kurillisesti" ;
lin kurimus_N = mkkN "kurimus" ;
lin kurin_Adv = mkkAdv "kurin" ;
lin kurina_N = mkkN "kurina" ;
lin kurinpidollinen_N = mkkN "kurinpidollinen" ;
lin kuriositeetti_N = mkkN "kuriositeetti" ;
lin kurista_V = mkkV "kurista" ;
lin kuristaa_V = mkkV "kuristaa" ;
lin kuristaja_N = mkkN "kuristaja" ;
lin kuristin_N = mkkN "kuristin" ;
lin kuristua_V = mkkV "kuristua" ;
lin kuristus_N = mkkN "kuristus" ;
lin kuriton_N = mkkN "kuriton" ;
lin kurittaa_V = mkkV "kurittaa" ;
lin kurittaja_N = mkkN "kurittaja" ;
lin kurittomasti_Adv = mkkAdv "kurittomasti" ;
lin kurittomuus_N = mkkN "kurittomuus" ;
lin kuritus_N = mkkN "kuritus" ;
lin kurja_A = mkkA "kurja" ;
lin kurjalisto_N = mkkN "kurjalisto" ;
lin kurjasti_Adv = mkkAdv "kurjasti" ;
lin kurjimus_N = mkkN "kurjimus" ;
lin kurjistaa_V = mkkV "kurjistaa" ;
lin kurjistua_V = mkkV "kurjistua" ;
lin kurjuus_N = mkkN "kurjuus" ;
lin kurkata_V = mkkV "kurkata" ;
lin kurki_N = mkkN "kurki" ;
lin kurkistaa_V = mkkV "kurkistaa" ;
lin kurkistelija_N = mkkN "kurkistelija" ;
lin kurkistella_V = mkkV "kurkistella" ;
lin kurkistus_N = mkkN "kurkistus" ;
lin kurkkailla_V = mkkV "kurkkailla" ;
lin kurkkia_V = mkkV "kurkkia" ;
lin kurkku_1_N = mkkN "kurkku" ;
lin kurkku_2_N = mkkN "kurkku" ;
lin kurkkuinen_N = mkkN "kurkkuinen" ;
lin kurko_N = mkkN "kurko" ;
lin kurkotella_V = mkkV "kurkotella" ;
lin kurkottaa_V = mkkV "kurkottaa" ;
lin kurkottautua_V = mkkV "kurkottautua" ;
lin kurkuma_N = mkkN "kurkuma" ;
lin kurlata_V = mkkV "kurlata" ;
lin kurlaus_N = mkkN "kurlaus" ;
lin kurmitsa_N = mkkN "kurmitsa" ;
lin kurnia_V = mkkV "kurnia" ;
lin kurnuttaa_V = mkkV "kurnuttaa" ;
lin kuroa_V = mkkV "kuroa" ;
lin kurotella_V = mkkV "kurotella" ;
lin kurottaa_V = mkkV "kurottaa" ;
lin kurottautua_V = mkkV "kurottautua" ;
lin kurottua_V = mkkV "kurottua" ;
lin kurouma_N = mkkN "kurouma" ;
lin kuroutua_V = mkkV "kuroutua" ;
lin kuroutuma_N = mkkN "kuroutuma" ;
lin kurpitsa_N = mkkN "kurpitsa" ;
lin kurppa_N = mkkN "kurppa" ;
lin kurra_N = mkkN "kurra" ;
lin kurre_N = mkkN "kurre" ;
lin kurri_N = mkkN "kurri" ;
lin kursailematon_N = mkkN "kursailematon" ;
lin kursailla_V = mkkV "kursailla" ;
lin kursailu_N = mkkN "kursailu" ;
lin kursastella_V = mkkV "kursastella" ;
lin kursia_V = mkkV "kursia" ;
lin kursiivi_N = mkkN "kursiivi" ;
lin kursivoida_V = mkkV "kursivoida" ;
lin kursivointi_N = mkkN "kursivointi" ;
lin kursori_N = mkkN "kursori" ;
lin kursorinen_A = mkkA "kursorinen" ;
lin kursorisesti_Adv = mkkAdv "kursorisesti" ;
lin kurssi_N = mkkN "kurssi" ;
lin kurssittaa_V = mkkV "kurssittaa" ;
lin kurtiisi_N = mkkN "kurtiisi" ;
lin kurtisaani_N = mkkN "kurtisaani" ;
lin kurtiseerata_V = mkkV "kurtiseerata" ;
lin kurtistaa_V = mkkV "kurtistaa" ;
lin kurtistua_V = mkkV "kurtistua" ;
lin kurttu_N = mkkN "kurttu" ;
lin kurttuinen_N = mkkN "kurttuinen" ;
lin kuru_N = mkkN "kuru" ;
lin kurva_N = mkkN "kurva" ;
lin kurvailla_V = mkkV "kurvailla" ;
lin kurvainen_N = mkkN "kurvainen" ;
lin kurvata_V = mkkV "kurvata" ;
lin kurvi_N = mkkN "kurvi" ;
lin kurvikas_N = mkkN "kurvikas" ;
lin kurvikkuus_N = mkkN "kurvikkuus" ;
lin kurvinen_N = mkkN "kurvinen" ;
lin kusaista_V = mkkV "kusaista" ;
lin kuseksia_V = mkkV "kuseksia" ;
lin kuseskella_V = mkkV "kuseskella" ;
lin kusettaa_V = mkkV "kusettaa" ;
lin kusettaja_N = mkkN "kusettaja" ;
lin kusi_N = mkkN "kusi" ;
lin kusiainen_N = mkkN "kusiainen" ;
lin kusinen_N = mkkN "kusinen" ;
lin kuskailla_V = mkkV "kuskailla" ;
lin kuskata_V = mkkV "kuskata" ;
lin kuskaus_N = mkkN "kuskaus" ;
lin kuski_N = mkkN "kuski" ;
lin kuskus_N = mkkN "kuskus" ;
lin kussa_Adv = mkkAdv "kussa" ;
lin kusta_1_Adv = mkkAdv "kusta" ;
lin kusta_2_V = mkkV "kusta" ;
lin kustanne_N = mkkN "kustanne" ;
lin kustannus_N = mkkN "kustannus" ;
lin kustantaa_V = mkkV "kustantaa" ;
lin kustantaja_N = mkkN "kustantaja" ;
lin kustantamo_N = mkkN "kustantamo" ;
lin kustavilainen_N = mkkN "kustavilainen" ;
lin kustavilaisaika_N = mkkN "kustavilaisaika" ;
lin kustos_N = mkkN "kustos" ;
lin kuta_Adv = mkkAdv "kuta" ;
lin kutakuinkin_Adv = mkkAdv "kutakuinkin" ;
lin kutale_N = mkkN "kutale" ;
lin kutea_V = mkkV "kutea" ;
lin kuteilla_Adv = mkkAdv "kuteilla" ;
lin kuteille_Adv = mkkAdv "kuteille" ;
lin kuteinen_N = mkkN "kuteinen" ;
lin kuteloida_V = mkkV "kuteloida" ;
lin kuten_Adv = mkkAdv "kuten" ;
lin kuti_1_N = mkkN "kuti" ;
lin kuti_2_Adv = mkkAdv "kuti" ;
lin kuti_3_Adv = mkkAdv "kuti" ;
lin kutiaa_Adv = mkkAdv "kutiaa" ;
lin kutina_N = mkkN "kutina" ;
lin kutista_V = mkkV "kutista" ;
lin kutistaa_V = mkkV "kutistaa" ;
lin kutistua_V = mkkV "kutistua" ;
lin kutistuma_N = mkkN "kutistuma" ;
lin kutistumiskerroin_N = mkkN "kutistumiskerroin" ;
lin kutistus_N = mkkN "kutistus" ;
lin kutistuvuus_N = mkkN "kutistuvuus" ;
lin kutitella_V = mkkV "kutitella" ;
lin kutittaa_V = mkkV "kutittaa" ;
lin kutitus_N = mkkN "kutitus" ;
lin kutka_N = mkkN "kutka" ;
lin kutkuta_V = mkkV "kutkuta" ;
lin kutkutella_V = mkkV "kutkutella" ;
lin kutkuttaa_V = mkkV "kutkuttaa" ;
lin kutoa_V = mkkV "kutoa" ;
lin kutoinen_N = mkkN "kutoinen" ;
lin kutoja_N = mkkN "kutoja" ;
lin kutomo_N = mkkN "kutomo" ;
lin kutonen_N = mkkN "kutonen" ;
lin kutoutua_V = mkkV "kutoutua" ;
lin kutrinen_N = mkkN "kutrinen" ;
lin kutrit_N = mkkN "kutrit" ;
lin kutsu_N = mkkN "kutsu" ;
lin kutsua_V = mkkV "kutsua" ;
lin kutsuja_N = mkkN "kutsuja" ;
lin kutsumaton_N = mkkN "kutsumaton" ;
lin kutsumus_N = mkkN "kutsumus" ;
lin kutsunta_N = mkkN "kutsunta" ;
lin kutsuttaa_V = mkkV "kutsuttaa" ;
lin kutteri_1_N = mkkN "kutteri" ;
lin kutteri_2_N = mkkN "kutteri" ;
lin kuttu_N = mkkN "kuttu" ;
lin kuttula_N = mkkN "kuttula" ;
lin kutu_N = mkkN "kutu" ;
lin kutuaika_N = mkkN "kutuaika" ;
lin kutuinen_N = mkkN "kutuinen" ;
lin kutyymi_N = mkkN "kutyymi" ;
lin kuu_N = mkkN "kuu" ;
lin kuudennes_N = mkkN "kuudennes" ;
lin kuudes_N = mkkN "kuudes" ;
lin kuudesti_Adv = mkkAdv "kuudesti" ;
lin kuudestilaukeava_N = mkkN "kuudestilaukeava" ;
lin kuukahtaa_V = mkkV "kuukahtaa" ;
lin kuukausittain_Adv = mkkAdv "kuukausittain" ;
lin kuukausittainen_N = mkkN "kuukausittainen" ;
lin kuukautissuoja_N = mkkN "kuukautissuoja" ;
lin kuukkeli_N = mkkN "kuukkeli" ;
lin kuukkia_V = mkkV "kuukkia" ;
lin kuukunen_N = mkkN "kuukunen" ;
lin kuula_N = mkkN "kuula" ;
lin kuulakas_N = mkkN "kuulakas" ;
lin kuulakkuus_N = mkkN "kuulakkuus" ;
lin kuulalaakeroida_V = mkkV "kuulalaakeroida" ;
lin kuulas_N = mkkN "kuulas" ;
lin kuulaus_N = mkkN "kuulaus" ;
lin kuulema_Adv = mkkAdv "kuulema" ;
lin kuulematon_N = mkkN "kuulematon" ;
lin kuulemattomuus_N = mkkN "kuulemattomuus" ;
lin kuulemiin_Adv = mkkAdv "kuulemiin" ;
lin kuulemma_Adv = mkkAdv "kuulemma" ;
lin kuuliainen_A = mkkA "kuuliainen" ;
lin kuuliaisesti_Adv = mkkAdv "kuuliaisesti" ;
--? lin kuuliaiset_NK = {s = d38 "kuuliaiset" ;
lin kuuliaisuus_N = mkkN "kuuliaisuus" ;
lin kuulija_N = mkkN "kuulija" ;
lin kuulla_V = mkkV "kuulla" ;
lin kuullottaa_V = mkkV "kuullottaa" ;
lin kuullotus_N = mkkN "kuullotus" ;
lin kuulo_N = mkkN "kuulo" ;
lin kuuloke_N = mkkN "kuuloke" ;
lin kuulonheikkenema'_N = mkkN "kuulonheikkenemä" ;
lin kuulostaa_V = mkkV "kuulostaa" ;
lin kuulostella_V = mkkV "kuulostella" ;
lin kuulostus_N = mkkN "kuulostus" ;
lin kuultaa_V = mkkV "kuultaa" ;
lin kuultava_1_A = mkkA "kuultava" ;
lin kuultava_2_A = mkkA "kuultava" ;
lin kuultavasti_Adv = mkkAdv "kuultavasti" ;
lin kuultavuus_1_N = mkkN "kuultavuus" ;
lin kuultavuus_2_N = mkkN "kuultavuus" ;
lin kuulto_N = mkkN "kuulto" ;
lin kuulu_N = mkkN "kuulu" ;
lin kuulua_V = mkkV "kuulua" ;
lin kuuluisa_N = mkkN "kuuluisa" ;
lin kuuluisuus_N = mkkN "kuuluisuus" ;
lin kuulumaton_N = mkkN "kuulumaton" ;
lin kuulumattomasti_Adv = mkkAdv "kuulumattomasti" ;
lin kuulumattomiin_Adv = mkkAdv "kuulumattomiin" ;
lin kuulumattomissa_Adv = mkkAdv "kuulumattomissa" ;
--? lin kuulumiset_NK = {s = d38 "kuulumiset" ;
lin kuulustelija_N = mkkN "kuulustelija" ;
lin kuulustella_V = mkkV "kuulustella" ;
lin kuulusteltava_N = mkkN "kuulusteltava" ;
lin kuulustelu_N = mkkN "kuulustelu" ;
lin kuuluttaa_V = mkkV "kuuluttaa" ;
lin kuuluttaja_N = mkkN "kuuluttaja" ;
lin kuuluttamo_N = mkkN "kuuluttamo" ;
lin kuulutus_N = mkkN "kuulutus" ;
lin kuuluva_A = mkkA "kuuluva" ;
lin kuuluvasti_Adv = mkkAdv "kuuluvasti" ;
lin kuuluviin_Adv = mkkAdv "kuuluviin" ;
lin kuuluvilla_Adv = mkkAdv "kuuluvilla" ;
lin kuuluville_Adv = mkkAdv "kuuluville" ;
lin kuuluvilta_Adv = mkkAdv "kuuluvilta" ;
lin kuuluvissa_Adv = mkkAdv "kuuluvissa" ;
lin kuuluvista_Adv = mkkAdv "kuuluvista" ;
lin kuuluvuus_N = mkkN "kuuluvuus" ;
lin kuuma_A = mkkA "kuuma" ;
lin kuumasti_Adv = mkkAdv "kuumasti" ;
lin kuumavalssata_V = mkkV "kuumavalssata" ;
lin kuume_N = mkkN "kuume" ;
lin kuumeeton_N = mkkN "kuumeeton" ;
lin kuumeilla_V = mkkV "kuumeilla" ;
lin kuumeilu_N = mkkN "kuumeilu" ;
lin kuumeinen_A = mkkA "kuumeinen" ;
lin kuumeisesti_Adv = mkkAdv "kuumeisesti" ;
lin kuumennin_N = mkkN "kuumennin" ;
lin kuumennus_N = mkkN "kuumennus" ;
lin kuumentaa_V = mkkV "kuumentaa" ;
lin kuumenteinen_N = mkkN "kuumenteinen" ;
lin kuumentua_V = mkkV "kuumentua" ;
lin kuumeta_V = mkkV "kuumeta" ;
lin kuumiltaan_Adv = mkkAdv "kuumiltaan" ;
lin kuumissaan_Adv = mkkAdv "kuumissaan" ;
lin kuumoittaa_V = mkkV "kuumoittaa" ;
lin kuumoitus_N = mkkN "kuumoitus" ;
lin kuumottaa_V = mkkV "kuumottaa" ;
lin kuumua_V = mkkV "kuumua" ;
lin kuumuus_N = mkkN "kuumuus" ;
lin kuunaan_Adv = mkkAdv "kuunaan" ;
lin kuunari_N = mkkN "kuunari" ;
lin kuunnella_V = mkkV "kuunnella" ;
lin kuunnelma_N = mkkN "kuunnelma" ;
lin kuuntelija_N = mkkN "kuuntelija" ;
lin kuuntelu_N = mkkN "kuuntelu" ;
lin kuupallinen_1_N = mkkN "kuupallinen" ;
lin kuupallinen_2_N = mkkN "kuupallinen" ;
lin kuuppa_1_N = mkkN "kuuppa" ;
lin kuuppa_2_N = mkkN "kuuppa" ;
lin kuura_N = mkkN "kuura" ;
lin kuurainen_N = mkkN "kuurainen" ;
lin kuuraus_N = mkkN "kuuraus" ;
lin kuuri_1_N = mkkN "kuuri" ;
lin kuuri_2_N = mkkN "kuuri" ;
lin kuuria_N = mkkN "kuuria" ;
lin kuurna_N = mkkN "kuurna" ;
lin kuurnita_V = mkkV "kuurnita" ;
lin kuurnittaa_V = mkkV "kuurnittaa" ;
lin kuurnitus_N = mkkN "kuurnitus" ;
lin kuuro_1_N = mkkN "kuuro" ;
lin kuuro_2_N = mkkN "kuuro" ;
lin kuuroittain_Adv = mkkAdv "kuuroittain" ;
lin kuuroittainen_N = mkkN "kuuroittainen" ;
lin kuurous_N = mkkN "kuurous" ;
lin kuurouttaa_V = mkkV "kuurouttaa" ;
lin kuuroutua_V = mkkV "kuuroutua" ;
lin kuusettua_V = mkkV "kuusettua" ;
lin kuusi_1_N = mkkN "kuusi" ;
lin kuusi_2_N = mkkN "kuusi" ;
lin kuusikko_1_N = mkkN "kuusikko" ;
lin kuusikko_2_N = mkkN "kuusikko" ;
lin kuusilo_N = mkkN "kuusilo" ;
lin kuusinen_N = mkkN "kuusinen" ;
lin kuusio_1_N = mkkN "kuusio" ;
lin kuusio_2_N = mkkN "kuusio" ;
lin kuusisto_N = mkkN "kuusisto" ;
lin kuutamo_N = mkkN "kuutamo" ;
lin kuutamoinen_N = mkkN "kuutamoinen" ;
lin kuutio_N = mkkN "kuutio" ;
lin kuutioida_V = mkkV "kuutioida" ;
lin kuutioinen_N = mkkN "kuutioinen" ;
lin kuutiointi_N = mkkN "kuutiointi" ;
lin kuutioittain_Adv = mkkAdv "kuutioittain" ;
lin kuutiojuuri_N = mkkN "kuutiojuuri" ;
lin kuutiollinen_A = mkkA "kuutiollinen" ;
lin kuutiollisesti_Adv = mkkAdv "kuutiollisesti" ;
lin kuutiomaisesti_Adv = mkkAdv "kuutiomaisesti" ;
lin kuutiomaisuus_N = mkkN "kuutiomaisuus" ;
lin kuutisen_Adv = mkkAdv "kuutisen" ;
lin kuutisenkymmenta'_Adv = mkkAdv "kuutisenkymmentä" ;
lin kuuton_N = mkkN "kuuton" ;
lin kuutonen_N = mkkN "kuutonen" ;
lin kuutti_1_N = mkkN "kuutti" ;
lin kuutti_2_N = mkkN "kuutti" ;
lin kuva_N = mkkN "kuva" ;
lin kuvaaja_N = mkkN "kuvaaja" ;
lin kuvaamaton_N = mkkN "kuvaamaton" ;
lin kuvaamattomasti_Adv = mkkAdv "kuvaamattomasti" ;
lin kuvaamo_N = mkkN "kuvaamo" ;
lin kuvaannollinen_A = mkkA "kuvaannollinen" ;
lin kuvaannollisesti_Adv = mkkAdv "kuvaannollisesti" ;
lin kuvaava_N = mkkN "kuvaava" ;
lin kuvaelma_N = mkkN "kuvaelma" ;
lin kuvailla_V = mkkV "kuvailla" ;
lin kuvailu_N = mkkN "kuvailu" ;
lin kuvainraastaja_N = mkkN "kuvainraastaja" ;
lin kuvajainen_N = mkkN "kuvajainen" ;
lin kuvake_N = mkkN "kuvake" ;
lin kuvakoko_N = mkkN "kuvakoko" ;
lin kuvallinen_A = mkkA "kuvallinen" ;
lin kuvallisesti_Adv = mkkAdv "kuvallisesti" ;
lin kuvallisuus_N = mkkN "kuvallisuus" ;
lin kuvantaa_V = mkkV "kuvantaa" ;
lin kuvantua_V = mkkV "kuvantua" ;
lin kuvanveista'ja'_N = mkkN "kuvanveistäjä" ;
lin kuvas_N = mkkN "kuvas" ;
lin kuvastaa_V = mkkV "kuvastaa" ;
lin kuvastaja_N = mkkN "kuvastaja" ;
lin kuvastella_V = mkkV "kuvastella" ;
lin kuvastin_N = mkkN "kuvastin" ;
lin kuvasto_N = mkkN "kuvasto" ;
lin kuvastua_V = mkkV "kuvastua" ;
lin kuvastus_N = mkkN "kuvastus" ;
lin kuvata_V = mkkV "kuvata" ;
lin kuvatus_N = mkkN "kuvatus" ;
lin kuvauksellinen_N = mkkN "kuvauksellinen" ;
lin kuvaus_N = mkkN "kuvaus" ;
lin kuvauttaa_V = mkkV "kuvauttaa" ;
lin kuvautua_V = mkkV "kuvautua" ;
lin kuve_N = mkkN "kuve" ;
lin kuvernementti_N = mkkN "kuvernementti" ;
lin kuverno'o'ri_N = mkkN "kuvernööri" ;
lin kuvertti_N = mkkN "kuvertti" ;
lin kuvio_N = mkkN "kuvio" ;
lin kuvioida_V = mkkV "kuvioida" ;
lin kuvioinen_N = mkkN "kuvioinen" ;
lin kuviointi_N = mkkN "kuviointi" ;
lin kuvioitus_N = mkkN "kuvioitus" ;
lin kuviollinen_N = mkkN "kuviollinen" ;
lin kuviopainettu_N = mkkN "kuviopainettu" ;
lin kuvitella_V = mkkV "kuvitella" ;
lin kuvitelma_N = mkkN "kuvitelma" ;
lin kuvittaa_V = mkkV "kuvittaa" ;
lin kuvittaja_N = mkkN "kuvittaja" ;
lin kuvitteellinen_N = mkkN "kuvitteellinen" ;
lin kuvittelu_N = mkkN "kuvittelu" ;
lin kuvitus_N = mkkN "kuvitus" ;
lin kuvottaa_V = mkkV "kuvottaa" ;
lin kuvotus_N = mkkN "kuvotus" ;
lin kvadriljoona_N = mkkN "kvadriljoona" ;
lin kvadrofonia_N = mkkN "kvadrofonia" ;
lin kvalifikaatio_N = mkkN "kvalifikaatio" ;
lin kvalifioida_V = mkkV "kvalifioida" ;
lin kvalifiointi_N = mkkN "kvalifiointi" ;
lin kvalitatiivinen_A = mkkA "kvalitatiivinen" ;
lin kvalitatiivisesti_Adv = mkkAdv "kvalitatiivisesti" ;
lin kvaliteetti_N = mkkN "kvaliteetti" ;
lin kvantifioida_V = mkkV "kvantifioida" ;
lin kvantifiointi_N = mkkN "kvantifiointi" ;
lin kvantitatiivinen_A = mkkA "kvantitatiivinen" ;
lin kvantitatiivisesti_Adv = mkkAdv "kvantitatiivisesti" ;
lin kvantiteetti_N = mkkN "kvantiteetti" ;
lin kvantittua_V = mkkV "kvantittua" ;
lin kvantti_N = mkkN "kvantti" ;
lin kvanttiutua_V = mkkV "kvanttiutua" ;
lin kvarkki_1_N = mkkN "kvarkki" ;
lin kvarkki_2_N = mkkN "kvarkki" ;
lin kvartetti_N = mkkN "kvartetti" ;
lin kvartetto_N = mkkN "kvartetto" ;
lin kvartsi_N = mkkN "kvartsi" ;
lin kvartsiitti_N = mkkN "kvartsiitti" ;
lin kvartsinen_N = mkkN "kvartsinen" ;
lin kvartti_N = mkkN "kvartti" ;
lin kvarta'a'ri_N = mkkN "kvartääri" ;
lin kvarta'a'rinen_N = mkkN "kvartäärinen" ;
lin kvasaari_N = mkkN "kvasaari" ;
lin kveekari_N = mkkN "kveekari" ;
lin kveeni_N = mkkN "kveeni" ;
lin kverulantti_N = mkkN "kverulantti" ;
lin kvintetti_N = mkkN "kvintetti" ;
lin kvintetto_N = mkkN "kvintetto" ;
lin kvintiljoona_N = mkkN "kvintiljoona" ;
lin kvintti_N = mkkN "kvintti" ;
lin kvitteni_N = mkkN "kvitteni" ;
lin kyberneetikko_N = mkkN "kyberneetikko" ;
lin kyberneettinen_N = mkkN "kyberneettinen" ;
lin kybernetiikka_N = mkkN "kybernetiikka" ;
lin kyborgi_N = mkkN "kyborgi" ;
lin kydo'tta'a'_V = mkkV "kydöttää" ;
lin kydo'tys_N = mkkN "kydötys" ;
lin kyeta'_V = mkkV "kyetä" ;
lin kyhjo'tta'a'_V = mkkV "kyhjöttää" ;
lin kyhmy_N = mkkN "kyhmy" ;
lin kyhmyinen_N = mkkN "kyhmyinen" ;
lin kyhnytella'_V = mkkV "kyhnytellä" ;
lin kyhnytta'a'_V = mkkV "kyhnyttää" ;
lin kyha'elma'_N = mkkN "kyhäelmä" ;
lin kyha'illa'_V = mkkV "kyhäillä" ;
lin kyha'ily_N = mkkN "kyhäily" ;
lin kyha'ta'_V = mkkV "kyhätä" ;
lin kyha'ys_N = mkkN "kyhäys" ;
lin kyinen_N = mkkN "kyinen" ;
lin kykenema'tto'myys_N = mkkN "kykenemättömyys" ;
lin kykenema'to'n_N = mkkN "kykenemätön" ;
lin kykenevyys_N = mkkN "kykenevyys" ;
lin kykeneva'_N = mkkN "kykenevä" ;
lin kykkia'_V = mkkV "kykkiä" ;
lin kyklooppi_N = mkkN "kyklooppi" ;
lin kyky_N = mkkN "kyky" ;
lin kykyinen_N = mkkN "kykyinen" ;
lin kyljekka'in_Adv = mkkAdv "kyljekkäin" ;
lin kyljelleen_Adv = mkkAdv "kyljelleen" ;
lin kyljella'a'n_Adv = mkkAdv "kyljellään" ;
lin kyljes_N = mkkN "kyljes" ;
lin kyljitta'in_Adv = mkkAdv "kyljittäin" ;
lin kyljitysten_Adv = mkkAdv "kyljitysten" ;
lin kyljys_N = mkkN "kyljys" ;
lin kylki_N = mkkN "kylki" ;
lin kylkimyyrya'_Adv = mkkAdv "kylkimyyryä" ;
lin kylkinen_N = mkkN "kylkinen" ;
lin kylkia'inen_N = mkkN "kylkiäinen" ;
lin kylliksi_Adv = mkkAdv "kylliksi" ;
lin kyllin_Adv = mkkAdv "kyllin" ;
lin kyllyys_N = mkkN "kyllyys" ;
lin kylla'_Adv = mkkAdv "kyllä" ;
lin kylla'inen_N = mkkN "kylläinen" ;
lin kylla'ste_N = mkkN "kylläste" ;
lin kylla'steinen_N = mkkN "kyllästeinen" ;
lin kylla'stymisraja_N = mkkN "kyllästymisraja" ;
lin kylla'stys_N = mkkN "kyllästys" ;
lin kylla'stytta'a'_V = mkkV "kyllästyttää" ;
lin kylla'stya'_V = mkkV "kyllästyä" ;
lin kylla'sta'mo'_N = mkkN "kyllästämö" ;
lin kylla'sta'a'_V = mkkV "kyllästää" ;
lin kylla'a'nnytta'a'_V = mkkV "kylläännyttää" ;
lin kylla'a'ntya'_V = mkkV "kyllääntyä" ;
lin kylmentya'_V = mkkV "kylmentyä" ;
lin kylmenta'a'_V = mkkV "kylmentää" ;
lin kylmettya'_V = mkkV "kylmettyä" ;
lin kylmetta'a'_V = mkkV "kylmettää" ;
lin kylmetytta'a'_V = mkkV "kylmetyttää" ;
lin kylmeta'_V = mkkV "kylmetä" ;
lin kylmilleen_Adv = mkkAdv "kylmilleen" ;
lin kylmilla'a'n_Adv = mkkAdv "kylmillään" ;
lin kylmilta'a'n_Adv = mkkAdv "kylmiltään" ;
lin kylmissa'a'n_Adv = mkkAdv "kylmissään" ;
lin kylmio'_N = mkkN "kylmiö" ;
lin kylmyys_N = mkkN "kylmyys" ;
lin kylma'_A = mkkA "kylmä" ;
lin kylma'kiskoisesti_Adv = mkkAdv "kylmäkiskoisesti" ;
lin kylma'kiskoisuus_N = mkkN "kylmäkiskoisuus" ;
lin kylma'kko'_N = mkkN "kylmäkkö" ;
lin kylma'pa'isesti_Adv = mkkAdv "kylmäpäisesti" ;
lin kylma'pa'isyys_N = mkkN "kylmäpäisyys" ;
lin kylma'sti_Adv = mkkAdv "kylmästi" ;
lin kylma'syda'misesti_Adv = mkkAdv "kylmäsydämisesti" ;
lin kylma'ta'_V = mkkV "kylmätä" ;
lin kylma'valssata_V = mkkV "kylmävalssata" ;
lin kylpea'_V = mkkV "kylpeä" ;
lin kylpija'_N = mkkN "kylpijä" ;
lin kylppa'ri_N = mkkN "kylppäri" ;
lin kylpy_N = mkkN "kylpy" ;
lin kylpyla'_N = mkkN "kylpylä" ;
lin kyltti_N = mkkN "kyltti" ;
lin kyltyma'tto'myys_N = mkkN "kyltymättömyys" ;
lin kyltyma'to'n_N = mkkN "kyltymätön" ;
lin kyltya'_V = mkkV "kyltyä" ;
lin kylvetta'ja'_N = mkkN "kylvettäjä" ;
lin kylvetta'a'_V = mkkV "kylvettää" ;
lin kylvetys_N = mkkN "kylvetys" ;
lin kylva'ja'_N = mkkN "kylväjä" ;
lin kylva'a'_V = mkkV "kylvää" ;
lin kylvo'_N = mkkN "kylvö" ;
lin kylvo'aika_N = mkkN "kylvöaika" ;
lin kylvo's_N = mkkN "kylvös" ;
lin kyly_N = mkkN "kyly" ;
lin kyla'_N = mkkN "kylä" ;
lin kyla'illa'_V = mkkV "kyläillä" ;
lin kyla'ily_N = mkkN "kyläily" ;
lin kyla'la'inen_N = mkkN "kyläläinen" ;
lin kyla'ssa'_Adv = mkkAdv "kylässä" ;
lin kyla'sta'_Adv = mkkAdv "kylästä" ;
lin kyla'a'n_Adv = mkkAdv "kylään" ;
lin kymi_N = mkkN "kymi" ;
lin kymmen_N = mkkN "kymmen" ;
lin kymmenen_N = mkkN "kymmenen" ;
lin kymmenennes_N = mkkN "kymmenennes" ;
lin kymmenes_1_N = mkkN "kymmenes" ;
lin kymmenes_2_N = mkkN "kymmenes" ;
lin kymmenesti_Adv = mkkAdv "kymmenesti" ;
lin kymmenikko'_N = mkkN "kymmenikkö" ;
lin kymmeninen_N = mkkN "kymmeninen" ;
lin kymmenisen_Adv = mkkAdv "kymmenisen" ;
lin kymmenisentuhatta_Adv = mkkAdv "kymmenisentuhatta" ;
lin kymmenitta'in_Adv = mkkAdv "kymmenittäin" ;
lin kymmenys_N = mkkN "kymmenys" ;
lin kymnaasi_N = mkkN "kymnaasi" ;
lin kymnasisti_N = mkkN "kymnasisti" ;
lin kymppi_N = mkkN "kymppi" ;
lin kymppinen_N = mkkN "kymppinen" ;
lin kymri_N = mkkN "kymri" ;
lin kynia'_V = mkkV "kyniä" ;
lin kynnenjuuri_N = mkkN "kynnenjuuri" ;
lin kynnys_N = mkkN "kynnys" ;
lin kynna's_N = mkkN "kynnäs" ;
lin kynno's_N = mkkN "kynnös" ;
lin kynsi_N = mkkN "kynsi" ;
lin kynsika's_N = mkkN "kynsikäs" ;
lin kynsimo'_N = mkkN "kynsimö" ;
lin kynsia'_V = mkkV "kynsiä" ;
lin kynsa'ista'_V = mkkV "kynsäistä" ;
lin kynte_N = mkkN "kynte" ;
lin kynteli_N = mkkN "kynteli" ;
lin kyntinen_N = mkkN "kyntinen" ;
lin kyntteli_N = mkkN "kyntteli" ;
lin kynttelikko'_N = mkkN "kynttelikkö" ;
lin kynttila'_N = mkkN "kynttilä" ;
lin kyntta'a'_V = mkkV "kynttää" ;
lin kynta'ja'_N = mkkN "kyntäjä" ;
lin kynta'a'_V = mkkV "kyntää" ;
lin kynto'_N = mkkN "kyntö" ;
lin kynto'aika_N = mkkN "kyntöaika" ;
lin kyna'_N = mkkN "kynä" ;
lin kyna'ilija'_N = mkkN "kynäilijä" ;
lin kyna'illa'_V = mkkV "kynäillä" ;
lin kyna'ily_N = mkkN "kynäily" ;
lin kyna'inen_N = mkkN "kynäinen" ;
lin kyna'nveto_N = mkkN "kynänveto" ;
lin kypsennys_N = mkkN "kypsennys" ;
lin kypsentya'_V = mkkV "kypsentyä" ;
lin kypsenta'a'_V = mkkV "kypsentää" ;
lin kypseta'_V = mkkV "kypsetä" ;
lin kypsi_Adv = mkkAdv "kypsi" ;
lin kypsyma'tto'myys_N = mkkN "kypsymättömyys" ;
lin kypsyma'to'n_N = mkkN "kypsymätön" ;
lin kypsytella'_V = mkkV "kypsytellä" ;
lin kypsyttely_N = mkkN "kypsyttely" ;
lin kypsytta'mo'_N = mkkN "kypsyttämö" ;
lin kypsytta'a'_V = mkkV "kypsyttää" ;
lin kypsytys_N = mkkN "kypsytys" ;
lin kypsyys_N = mkkN "kypsyys" ;
lin kypsya'_V = mkkV "kypsyä" ;
lin kypsa'_A = mkkA "kypsä" ;
lin kypsa'sti_Adv = mkkAdv "kypsästi" ;
lin kypa'ra'_N = mkkN "kypärä" ;
lin kyrillinen_N = mkkN "kyrillinen" ;
lin kyrmyssa'_Adv = mkkAdv "kyrmyssä" ;
lin kyrmyyn_Adv = mkkAdv "kyrmyyn" ;
lin kyrpiintya'_V = mkkV "kyrpiintyä" ;
lin kyrpa'_N = mkkN "kyrpä" ;
lin kyrsa'_N = mkkN "kyrsä" ;
lin kyrva'hta'a'_V = mkkV "kyrvähtää" ;
lin kyrva'ytta'a'_V = mkkV "kyrväyttää" ;
lin kyra'illa'_V = mkkV "kyräillä" ;
lin kyra'ily_N = mkkN "kyräily" ;
lin kyse_Adv = mkkAdv "kyse" ;
lin kyseenalaistaa_V = mkkV "kyseenalaistaa" ;
lin kyseenalaistua_V = mkkV "kyseenalaistua" ;
lin kyseinen_N = mkkN "kyseinen" ;
lin kyselija'_N = mkkN "kyselijä" ;
lin kysella'_V = mkkV "kysellä" ;
lin kysely_N = mkkN "kysely" ;
lin kyssa'_N = mkkN "kyssä" ;
lin kysta_N = mkkN "kysta" ;
lin kystiitti_N = mkkN "kystiitti" ;
lin kystoskooppi_N = mkkN "kystoskooppi" ;
lin kystoskopia_N = mkkN "kystoskopia" ;
lin kysta'_Adv = mkkAdv "kystä" ;
lin kysyja'_N = mkkN "kysyjä" ;
lin kysymys_N = mkkN "kysymys" ;
lin kysyma'_N = mkkN "kysymä" ;
lin kysynta'_N = mkkN "kysyntä" ;
lin kysyva'_A = mkkA "kysyvä" ;
lin kysyva'sti_Adv = mkkAdv "kysyvästi" ;
lin kysya'_V = mkkV "kysyä" ;
lin kysa'ista'_V = mkkV "kysäistä" ;
lin kytea'_V = mkkV "kyteä" ;
lin kytis_N = mkkN "kytis" ;
lin kytkenta'_N = mkkN "kytkentä" ;
lin kytkeyma'_N = mkkN "kytkeymä" ;
lin kytkeytya'_V = mkkV "kytkeytyä" ;
lin kytkea'_V = mkkV "kytkeä" ;
lin kytkin_N = mkkN "kytkin" ;
lin kytky_N = mkkN "kytky" ;
lin kytkyt_N = mkkN "kytkyt" ;
lin kytko's_N = mkkN "kytkös" ;
lin kyttyra'_N = mkkN "kyttyrä" ;
lin kyttyra'inen_N = mkkN "kyttyräinen" ;
lin kytta'_N = mkkN "kyttä" ;
lin kytta'illa'_V = mkkV "kyttäillä" ;
lin kytta'ily_N = mkkN "kyttäily" ;
lin kytta'ys_N = mkkN "kyttäys" ;
lin kytta'a'ja'_N = mkkN "kyttääjä" ;
lin kyta'ta'_V = mkkV "kytätä" ;
lin kyto'_N = mkkN "kytö" ;
lin kyvykkyys_N = mkkN "kyvykkyys" ;
lin kyvyka's_N = mkkN "kyvykäs" ;
lin kyvytto'myys_N = mkkN "kyvyttömyys" ;
lin kyvyto'n_N = mkkN "kyvytön" ;
lin kyy_N = mkkN "kyy" ;
lin kyyditsija'_N = mkkN "kyyditsijä" ;
lin kyyditta'a'_V = mkkV "kyydittää" ;
lin kyyditys_N = mkkN "kyyditys" ;
lin kyydita'_V = mkkV "kyyditä" ;
lin kyyhky_N = mkkN "kyyhky" ;
lin kyyhkyla'inen_N = mkkN "kyyhkyläinen" ;
lin kyyhkynen_N = mkkN "kyyhkynen" ;
lin kyyhkyslakka_N = mkkN "kyyhkyslakka" ;
lin kyyhkysparvi_N = mkkN "kyyhkysparvi" ;
lin kyyho'tta'a'_V = mkkV "kyyhöttää" ;
lin kyykistys_N = mkkN "kyykistys" ;
lin kyykistya'_V = mkkV "kyykistyä" ;
lin kyykkia'_V = mkkV "kyykkiä" ;
lin kyykky_N = mkkN "kyykky" ;
lin kyykkysilleen_Adv = mkkAdv "kyykkysilleen" ;
lin kyykkysilla'a'n_Adv = mkkAdv "kyykkysillään" ;
lin kyykkysilta'a'n_Adv = mkkAdv "kyykkysiltään" ;
lin kyykkyyn_Adv = mkkAdv "kyykkyyn" ;
lin kyykka'_N = mkkN "kyykkä" ;
lin kyykylleen_Adv = mkkAdv "kyykylleen" ;
lin kyykylla'a'n_Adv = mkkAdv "kyykyllään" ;
lin kyykylta'a'n_Adv = mkkAdv "kyykyltään" ;
lin kyykyssa'_Adv = mkkAdv "kyykyssä" ;
lin kyykysta'_Adv = mkkAdv "kyykystä" ;
lin kyykytys_N = mkkN "kyykytys" ;
lin kyyko'tta'a'_V = mkkV "kyyköttää" ;
lin kyyla'_N = mkkN "kyylä" ;
lin kyyla'ta'_V = mkkV "kyylätä" ;
lin kyynel_N = mkkN "kyynel" ;
lin kyynele_N = mkkN "kyynele" ;
lin kyynelehtia'_V = mkkV "kyynelehtiä" ;
lin kyyneleinen_N = mkkN "kyyneleinen" ;
lin kyyneltya'_V = mkkV "kyyneltyä" ;
lin kyynelo'ida'_V = mkkV "kyynelöidä" ;
lin kyynelo'itya'_V = mkkV "kyynelöityä" ;
lin kyynikko_N = mkkN "kyynikko" ;
lin kyyninen_A = mkkA "kyyninen" ;
lin kyynisesti_Adv = mkkAdv "kyynisesti" ;
lin kyynisyys_N = mkkN "kyynisyys" ;
lin kyyppari_N = mkkN "kyyppari" ;
lin kyyppi_1_N = mkkN "kyyppi" ;
lin kyyppi_2_N = mkkN "kyyppi" ;
lin kyyristella'_V = mkkV "kyyristellä" ;
lin kyyristely_N = mkkN "kyyristely" ;
lin kyyristya'_V = mkkV "kyyristyä" ;
lin kyyrista'a'_V = mkkV "kyyristää" ;
lin kyyry_N = mkkN "kyyry" ;
lin kyyrylleen_Adv = mkkAdv "kyyrylleen" ;
lin kyyrylla'a'n_Adv = mkkAdv "kyyryllään" ;
lin kyyrylta'a'n_Adv = mkkAdv "kyyryltään" ;
lin kyyryssa'_Adv = mkkAdv "kyyryssä" ;
lin kyyrysta'_Adv = mkkAdv "kyyrystä" ;
lin kyyryyn_Adv = mkkAdv "kyyryyn" ;
lin kyyro'tta'a'_V = mkkV "kyyröttää" ;
lin kyyti_N = mkkN "kyyti" ;
lin kyytia'_V = mkkV "kyytiä" ;
lin kyytto'_N = mkkN "kyyttö" ;
lin kyo'kki_N = mkkN "kyökki" ;
lin kyo'my_N = mkkN "kyömy" ;
lin kyo'peli_N = mkkN "kyöpeli" ;
lin kyo'pelinvuori_N = mkkN "kyöpelinvuori" ;
lin kyo'ra'ta'_V = mkkV "kyörätä" ;
lin ka'dellinen_N = mkkN "kädellinen" ;
lin ka'den_ka'a'nteessa'_Adv = mkkAdv "kädeC" ;
lin ka'deto'n_N = mkkN "kädetön" ;
lin ka'herrys_N = mkkN "käherrys" ;
lin ka'hertya'_V = mkkV "kähertyä" ;
lin ka'herta'a'_V = mkkV "kähertää" ;
lin ka'heta'_V = mkkV "kähetä" ;
lin ka'heys_N = mkkN "käheys" ;
lin ka'heytya'_V = mkkV "käheytyä" ;
lin ka'hea'_A = mkkA "käheä" ;
lin ka'hea'sti_Adv = mkkAdv "käheästi" ;
lin ka'hina'_N = mkkN "kähinä" ;
lin ka'hista'_V = mkkV "kähistä" ;
lin ka'hminta'_N = mkkN "kähmintä" ;
lin ka'hmia'_V = mkkV "kähmiä" ;
lin ka'hvellys_N = mkkN "kähvellys" ;
lin ka'hvelta'a'_V = mkkV "kähveltää" ;
lin ka'ha'hdys_N = mkkN "kähähdys" ;
lin ka'ha'hta'a'_V = mkkV "kähähtää" ;
lin ka'ha'ryys_N = mkkN "kähäryys" ;
lin ka'ha'ra'_N = mkkN "kähärä" ;
lin ka'ha'ra'inen_N = mkkN "kähäräinen" ;
lin ka'ki_N = mkkN "käki" ;
lin ka'kkyra'_N = mkkN "käkkyrä" ;
lin ka'kka'ra'_N = mkkN "käkkärä" ;
lin ka'ka'tta'a'_V = mkkV "käkättää" ;
lin ka'ka'tys_N = mkkN "käkätys" ;
lin ka'ko'_N = mkkN "käkö" ;
lin ka'ko'nen_N = mkkN "käkönen" ;
lin ka'ly_N = mkkN "käly" ;
--? lin ka'lykset_NK = {s = d39 "kälykset" ;
lin ka'mmekka'_N = mkkN "kämmekkä" ;
lin ka'mmen_N = mkkN "kämmen" ;
lin ka'mmenenlevyinen_N = mkkN "kämmenenlevyinen" ;
lin ka'mmenta'a'_V = mkkV "kämmentää" ;
lin ka'mppa'_N = mkkN "kämppä" ;
lin ka'nina'_N = mkkN "käninä" ;
lin ka'nista'_V = mkkV "känistä" ;
lin ka'nni_N = mkkN "känni" ;
lin ka'nninen_N = mkkN "känninen" ;
lin ka'nnipa'issa'_Adv = mkkAdv "kännipäissä" ;
lin ka'nny_N = mkkN "känny" ;
lin ka'nnykka'_N = mkkN "kännykkä" ;
lin ka'nna'ta'_V = mkkV "kännätä" ;
lin ka'nsistya'_V = mkkV "känsistyä" ;
lin ka'nsittya'_V = mkkV "känsittyä" ;
lin ka'nsa'_N = mkkN "känsä" ;
lin ka'nsa'inen_N = mkkN "känsäinen" ;
lin ka'ntty_N = mkkN "käntty" ;
lin ka'na'_N = mkkN "känä" ;
lin ka'pertya'_V = mkkV "käpertyä" ;
lin ka'perta'a'_V = mkkV "käpertää" ;
lin ka'ppyra'_N = mkkN "käppyrä" ;
lin ka'ppyra'inen_N = mkkN "käppyräinen" ;
lin ka'ppa'illa'_V = mkkV "käppäillä" ;
lin ka'ppa'ily_N = mkkN "käppäily" ;
lin ka'ppa'na'_N = mkkN "käppänä" ;
lin ka'pristella'_V = mkkV "käpristellä" ;
lin ka'pristya'_V = mkkV "käpristyä" ;
lin ka'prista'a'_V = mkkV "käpristää" ;
lin ka'psehtia'_V = mkkV "käpsehtiä" ;
lin ka'py_N = mkkN "käpy" ;
lin ka'pykaartilaisuus_N = mkkN "käpykaartilaisuus" ;
lin ka'pa'la'_N = mkkN "käpälä" ;
lin ka'pa'lo'ida'_V = mkkV "käpälöidä" ;
lin ka'pa'lo'inti_N = mkkN "käpälöinti" ;
lin ka'pa'ta'_V = mkkV "käpätä" ;
lin ka'reys_N = mkkN "käreys" ;
lin ka'rea'_N = mkkN "käreä" ;
lin ka'rhi_N = mkkN "kärhi" ;
lin ka'rha'ma'_N = mkkN "kärhämä" ;
lin ka'rha'mo'ida'_V = mkkV "kärhämöidä" ;
lin ka'rha'mo'inti_N = mkkN "kärhämöinti" ;
lin ka'rho'_N = mkkN "kärhö" ;
lin ka'rina'_N = mkkN "kärinä" ;
lin ka'riste_N = mkkN "käriste" ;
lin ka'ristys_N = mkkN "käristys" ;
lin ka'ristya'_V = mkkV "käristyä" ;
lin ka'rista'_V = mkkV "käristä" ;
lin ka'rista'a'_V = mkkV "käristää" ;
lin ka'rjekkyys_N = mkkN "kärjekkyys" ;
lin ka'rjekka'a'sti_Adv = mkkAdv "kärjekkäästi" ;
lin ka'rjeka's_A = mkkA "kärjekäs" ;
lin ka'rjellinen_N = mkkN "kärjellinen" ;
lin ka'rjimma'inen_N = mkkN "kärjimmäinen" ;
lin ka'rjistyma'_N = mkkN "kärjistymä" ;
lin ka'rjistys_N = mkkN "kärjistys" ;
lin ka'rjistya'_V = mkkV "kärjistyä" ;
lin ka'rjista'a'_V = mkkV "kärjistää" ;
lin ka'rkevyys_N = mkkN "kärkevyys" ;
lin ka'rkeva'_A = mkkA "kärkevä" ;
lin ka'rkeva'sti_Adv = mkkAdv "kärkevästi" ;
lin ka'rki_N = mkkN "kärki" ;
lin ka'rkiaika_N = mkkN "kärkiaika" ;
lin ka'rkinen_N = mkkN "kärkinen" ;
lin ka'rkkyja'_N = mkkN "kärkkyjä" ;
lin ka'rkkya'_V = mkkV "kärkkyä" ;
lin ka'rkka'ys_N = mkkN "kärkkäys" ;
lin ka'rkka'a'sti_Adv = mkkAdv "kärkkäästi" ;
lin ka'rkynta'_N = mkkN "kärkyntä" ;
lin ka'rka's_A = mkkA "kärkäs" ;
lin ka'rppa'_N = mkkN "kärppä" ;
lin ka'rppa'ma'inen_N = mkkN "kärppämäinen" ;
lin ka'rpa'nen_N = mkkN "kärpänen" ;
lin ka'rpa'sparvi_N = mkkN "kärpäsparvi" ;
lin ka'rri_N = mkkN "kärri" ;
lin ka'rry_N = mkkN "kärry" ;
lin ka'rra'ri_N = mkkN "kärräri" ;
lin ka'rra'ta'_V = mkkV "kärrätä" ;
lin ka'rra'ys_N = mkkN "kärräys" ;
lin ka'rra'a'ja'_N = mkkN "kärrääjä" ;
lin ka'rsija'_N = mkkN "kärsijä" ;
lin ka'rsimys_N = mkkN "kärsimys" ;
lin ka'rsima'tto'myys_N = mkkN "kärsimättömyys" ;
lin ka'rsima'tto'ma'sti_Adv = mkkAdv "kärsimättömästi" ;
lin ka'rsima'to'n_N = mkkN "kärsimätön" ;
lin ka'rsiva'llinen_A = mkkA "kärsivällinen" ;
lin ka'rsiva'llisesti_Adv = mkkAdv "kärsivällisesti" ;
lin ka'rsiva'llisyys_N = mkkN "kärsivällisyys" ;
lin ka'rsia'_V = mkkV "kärsiä" ;
lin ka'rsa'_N = mkkN "kärsä" ;
lin ka'rsa'ka's_N = mkkN "kärsäkäs" ;
lin ka'rsa'mo'_N = mkkN "kärsämö" ;
lin ka'rttyinen_N = mkkN "kärttyinen" ;
lin ka'rttyisyys_N = mkkN "kärttyisyys" ;
lin ka'rttyisa'_A = mkkA "kärttyisä" ;
lin ka'rttyisa'sti_Adv = mkkAdv "kärttyisästi" ;
lin ka'rtta'a'_V = mkkV "kärttää" ;
lin ka'rtyinen_N = mkkN "kärtyinen" ;
lin ka'rtyisa'_N = mkkN "kärtyisä" ;
lin ka'rvennys_N = mkkN "kärvennys" ;
lin ka'rventya'_V = mkkV "kärventyä" ;
lin ka'rventa'a'_V = mkkV "kärventää" ;
lin ka'rvistella'_V = mkkV "kärvistellä" ;
lin ka'ry_N = mkkN "käry" ;
lin ka'ryinen_N = mkkN "käryinen" ;
lin ka'rytta'a'_V = mkkV "käryttää" ;
lin ka'rytys_N = mkkN "kärytys" ;
lin ka'ryta'_V = mkkV "kärytä" ;
lin ka'ra'hta'a'_V = mkkV "kärähtää" ;
--? lin ka'ra'ja't_NK = {s = d10 "käräjät" ;
lin ka'ra'jo'ida'_V = mkkV "käräjöidä" ;
lin ka'ra'jo'inti_N = mkkN "käräjöinti" ;
lin ka'ra'ytta'a'_V = mkkV "käräyttää" ;
lin ka'si_N = mkkN "käsi" ;
lin ka'siaika_N = mkkN "käsiaika" ;
lin ka'sikaulaa_Adv = mkkAdv "käsikaulaa" ;
lin ka'sikka'in_Adv = mkkAdv "käsikkäin" ;
lin ka'sikopelolla_Adv = mkkAdv "käsikopelolla" ;
lin ka'sikopelolta_Adv = mkkAdv "käsikopelolta" ;
lin ka'siksi_Adv = mkkAdv "käsiksi" ;
lin ka'sikynkka'_Adv = mkkAdv "käsikynkkä" ;
lin ka'sika'hma'_N = mkkN "käsikähmä" ;
lin ka'sille_Adv = mkkAdv "käsille" ;
lin ka'silla'_Adv = mkkAdv "käsillä" ;
lin ka'sin_Adv = mkkAdv "käsin" ;
lin ka'sine_N = mkkN "käsine" ;
lin ka'sinkohonta_N = mkkN "käsinkohonta" ;
lin ka'sipohjaa_Adv = mkkAdv "käsipohjaa" ;
lin ka'sissa'_Adv = mkkAdv "käsissä" ;
lin ka'site_N = mkkN "käsite" ;
lin ka'sitella'_V = mkkV "käsitellä" ;
lin ka'sitelta'vyys_N = mkkN "käsiteltävyys" ;
lin ka'sitetta'vyys_N = mkkN "käsitettävyys" ;
lin ka'sitteellinen_A = mkkA "käsitteellinen" ;
lin ka'sitteellisesti_Adv = mkkAdv "käsitteellisesti" ;
lin ka'sitteellista'a'_V = mkkV "käsitteellistää" ;
lin ka'sitteellisyys_N = mkkN "käsitteellisyys" ;
lin ka'sitteinen_N = mkkN "käsitteinen" ;
lin ka'sitteista'a'_V = mkkV "käsitteistää" ;
lin ka'sitteisto'_N = mkkN "käsitteistö" ;
lin ka'sittelema'to'n_N = mkkN "käsittelemätön" ;
lin ka'sittelija'_N = mkkN "käsittelijä" ;
lin ka'sittely_N = mkkN "käsittely" ;
lin ka'sitta'ma'tto'myys_N = mkkN "käsittämättömyys" ;
lin ka'sitta'ma'tto'ma'sti_Adv = mkkAdv "käsittämättömästi" ;
lin ka'sitta'ma'to'n_N = mkkN "käsittämätön" ;
lin ka'sitta'a'_V = mkkV "käsittää" ;
lin ka'sityksin_Adv = mkkAdv "käsityksin" ;
lin ka'sitys_N = mkkN "käsitys" ;
lin ka'sitysten_Adv = mkkAdv "käsitysten" ;
lin ka'sivaraisesti_Adv = mkkAdv "käsivaraisesti" ;
lin ka'sketta'a'_V = mkkV "käskettää" ;
lin ka'skea'_V = mkkV "käskeä" ;
lin ka'skija'_N = mkkN "käskijä" ;
lin ka'sky_N = mkkN "käsky" ;
lin ka'skyla'inen_N = mkkN "käskyläinen" ;
lin ka'skytta'a'_V = mkkV "käskyttää" ;
lin ka'skytys_N = mkkN "käskytys" ;
lin ka'sna'_N = mkkN "käsnä" ;
lin ka'ssa'ta'_V = mkkV "kässätä" ;
lin ka'teinen_N = mkkN "käteinen" ;
lin ka'tella'_V = mkkV "kätellä" ;
lin ka'tevyys_N = mkkN "kätevyys" ;
lin ka'teva'_A = mkkA "kätevä" ;
lin ka'teva'sti_Adv = mkkAdv "kätevästi" ;
lin ka'tilo'_N = mkkN "kätilö" ;
lin ka'tilo'ida'_V = mkkV "kätilöidä" ;
lin ka'tinen_A = mkkA "kätinen" ;
lin ka'tisesti_Adv = mkkAdv "kätisesti" ;
lin ka'tisyys_N = mkkN "kätisyys" ;
lin ka'tkenta'_N = mkkN "kätkentä" ;
lin ka'tkeytya'_V = mkkV "kätkeytyä" ;
lin ka'tkea'_V = mkkV "kätkeä" ;
lin ka'tkija'_N = mkkN "kätkijä" ;
lin ka'tkyt_N = mkkN "kätkyt" ;
lin ka'tko'_N = mkkN "kätkö" ;
lin ka'ttely_N = mkkN "kättely" ;
lin ka'ttenpa'a'llepaneminen_N = mkkN "kättenpäällepaneminen" ;
lin ka'tyri_N = mkkN "kätyri" ;
lin ka'to'nen_N = mkkN "kätönen" ;
lin ka'veleskella'_V = mkkV "käveleskellä" ;
lin ka'velija'_N = mkkN "kävelijä" ;
lin ka'vella'_V = mkkV "kävellä" ;
lin ka'vely_N = mkkN "kävely" ;
lin ka'velytta'a'_V = mkkV "kävelyttää" ;
lin ka'vija'_N = mkkN "kävijä" ;
lin ka'va'ista'_V = mkkV "käväistä" ;
lin ka'va'isy_N = mkkN "käväisy" ;
lin ka'yda'_V = mkkV "käydä" ;
lin ka'yminen_N = mkkN "käyminen" ;
lin ka'yma'jalkaa_Adv = mkkAdv "käymäjalkaa" ;
lin ka'yma'la'_N = mkkN "käymälä" ;
lin ka'yma'selta'_Adv = mkkAdv "käymäseltä" ;
lin ka'yma'selta'a'n_Adv = mkkAdv "käymäseltään" ;
lin ka'ynniste_N = mkkN "käynniste" ;
lin ka'ynnisteinen_N = mkkN "käynnisteinen" ;
lin ka'ynnistin_N = mkkN "käynnistin" ;
lin ka'ynnistys_N = mkkN "käynnistys" ;
lin ka'ynnistyvyys_N = mkkN "käynnistyvyys" ;
lin ka'ynnistya'_V = mkkV "käynnistyä" ;
lin ka'ynnista'ja'_N = mkkN "käynnistäjä" ;
lin ka'ynnista'a'_V = mkkV "käynnistää" ;
lin ka'ynti_N = mkkN "käynti" ;
lin ka'yntiaika_N = mkkN "käyntiaika" ;
lin ka'yntinen_N = mkkN "käyntinen" ;
lin ka'ypyys_N = mkkN "käypyys" ;
lin ka'ypa'_N = mkkN "käypä" ;
lin ka'yristyma'_N = mkkN "käyristymä" ;
lin ka'yristys_N = mkkN "käyristys" ;
lin ka'yristya'_V = mkkV "käyristyä" ;
lin ka'yrista'a'_V = mkkV "käyristää" ;
lin ka'yryys_N = mkkN "käyryys" ;
lin ka'yra'_N = mkkN "käyrä" ;
lin ka'yra'sto'_N = mkkN "käyrästö" ;
lin ka'yskella'_V = mkkV "käyskellä" ;
lin ka'yskennella'_V = mkkV "käyskennellä" ;
lin ka'yskentely_N = mkkN "käyskentely" ;
lin ka'yte_N = mkkN "käyte" ;
lin ka'ytella'_V = mkkV "käytellä" ;
lin ka'ytetty_N = mkkN "käytetty" ;
lin ka'ytetta'vyys_N = mkkN "käytettävyys" ;
lin ka'yttely_N = mkkN "käyttely" ;
lin ka'ytta'jisto'_N = mkkN "käyttäjistö" ;
lin ka'ytta'ja'_N = mkkN "käyttäjä" ;
lin ka'ytta'ytyminen_N = mkkN "käyttäytyminen" ;
lin ka'ytta'ytyma'_N = mkkN "käyttäytymä" ;
lin ka'ytta'ytya'_V = mkkV "käyttäytyä" ;
lin ka'ytta'a'_V = mkkV "käyttää" ;
lin ka'ytto'_N = mkkN "käyttö" ;
lin ka'ytto'aika_N = mkkN "käyttöaika" ;
lin ka'ytto'inen_N = mkkN "käyttöinen" ;
lin ka'yta'nne_N = mkkN "käytänne" ;
lin ka'yta'nno'llinen_A = mkkA "käytännöllinen" ;
lin ka'yta'nno'llisesti_Adv = mkkAdv "käytännöllisesti" ;
lin ka'yta'nno'llistya'_V = mkkV "käytännöllistyä" ;
lin ka'yta'nno'llista'a'_V = mkkV "käytännöllistää" ;
lin ka'yta'nno'llisyys_N = mkkN "käytännöllisyys" ;
lin ka'yta'nto'_N = mkkN "käytäntö" ;
lin ka'yta'va'_N = mkkN "käytävä" ;
lin ka'yto'ksinen_N = mkkN "käytöksinen" ;
lin ka'yto's_N = mkkN "käytös" ;
lin ka'yvyys_N = mkkN "käyvyys" ;
lin ka'yva'_A = mkkA "käyvä" ;
lin ka'yva'sti_Adv = mkkAdv "käyvästi" ;
--? lin ka'a'dyt_NK = {s = d01A "käädyt" ;
lin ka'a'kka'_N = mkkN "kääkkä" ;
lin ka'a'mi_N = mkkN "käämi" ;
lin ka'a'minta'_N = mkkN "käämintä" ;
lin ka'a'mitys_N = mkkN "käämitys" ;
lin ka'a'mia'_V = mkkV "käämiä" ;
lin ka'a'nne_N = mkkN "käänne" ;
lin ka'a'nnekohta_N = mkkN "käännekohta" ;
lin ka'a'nnella'_V = mkkV "käännellä" ;
lin ka'a'nnin_N = mkkN "käännin" ;
lin ka'a'nnynna'inen_N = mkkN "käännynnäinen" ;
lin ka'a'nnytta'a'_V = mkkV "käännyttää" ;
lin ka'a'nnytys_N = mkkN "käännytys" ;
lin ka'a'nna'hdella'_V = mkkV "käännähdellä" ;
lin ka'a'nna'hdys_N = mkkN "käännähdys" ;
lin ka'a'nna'hta'a'_V = mkkV "käännähtää" ;
lin ka'a'nna'tta'a'_V = mkkV "käännättää" ;
lin ka'a'nno's_N = mkkN "käännös" ;
lin ka'a'nteentekeva'sti_Adv = mkkAdv "käänteentekevästi" ;
lin ka'a'nteinen_A = mkkA "käänteinen" ;
lin ka'a'nteinen_A = mkkA "käänteinen" ;
lin ka'a'nteisesti_Adv = mkkAdv "käänteisesti" ;
lin ka'a'ntelehtia'_V = mkkV "kääntelehtiä" ;
lin ka'a'ntely_N = mkkN "kääntely" ;
lin ka'a'ntyilla'_V = mkkV "kääntyillä" ;
lin ka'a'ntymys_N = mkkN "kääntymys" ;
lin ka'a'ntya'_V = mkkV "kääntyä" ;
lin ka'a'nta'ja'_N = mkkN "kääntäjä" ;
lin ka'a'nta'a'_V = mkkV "kääntää" ;
lin ka'a'nto'_N = mkkN "kääntö" ;
lin ka'a'pio'_N = mkkN "kääpiö" ;
lin ka'a'pio'ida'_V = mkkV "kääpiöidä" ;
lin ka'a'pio'itya'_V = mkkV "kääpiöityä" ;
lin ka'a'pa'_N = mkkN "kääpä" ;
lin ka'a're_N = mkkN "kääre" ;
lin ka'a'riintya'_V = mkkV "kääriintyä" ;
lin ka'a'rinta'_N = mkkN "käärintä" ;
lin ka'a'riytya'_V = mkkV "kääriytyä" ;
lin ka'a'ria'_V = mkkV "kääriä" ;
lin ka'a'ria'inen_N = mkkN "kääriäinen" ;
lin ka'a'rme_N = mkkN "käärme" ;
lin ka'a'rmeissa'a'n_Adv = mkkAdv "käärmeissään" ;
lin ka'a'rmema'inen_N = mkkN "käärmemäinen" ;
lin ka'a'ryle_N = mkkN "kääryle" ;
lin ka'a'ra'ista'_V = mkkV "kääräistä" ;
lin ka'a'ro'_N = mkkN "käärö" ;
lin ka'a'ty_N = mkkN "kääty" ;
lin ka'a'va'ka's_N = mkkN "kääväkäs" ;
lin ko'hina'_N = mkkN "köhinä" ;
lin ko'hista'_V = mkkV "köhistä" ;
lin ko'hitta'a'_V = mkkV "köhittää" ;
lin ko'hia'_V = mkkV "köhiä" ;
lin ko'ha'_N = mkkN "köhä" ;
lin ko'kko'_N = mkkN "kökkö" ;
lin ko'ko'tta'a'_V = mkkV "kököttää" ;
lin ko'li_N = mkkN "köli" ;
lin ko'lillinen_N = mkkN "kölillinen" ;
lin ko'lli_1_N = mkkN "kölli" ;
lin ko'lli_2_N = mkkN "kölli" ;
lin ko'llikka'_N = mkkN "köllikkä" ;
lin ko'lla'hta'a'_V = mkkV "köllähtää" ;
lin ko'llo'tella'_V = mkkV "köllötellä" ;
lin ko'llo'ttely_N = mkkN "köllöttely" ;
lin ko'llo'tta'a'_V = mkkV "köllöttää" ;
lin ko'mma'hdys_N = mkkN "kömmähdys" ;
lin ko'mma'hta'a'_V = mkkV "kömmähtää" ;
lin ko'mpelyys_N = mkkN "kömpelyys" ;
lin ko'mpelo'_A = mkkA "kömpelö" ;
lin ko'mpelo'itya'_V = mkkV "kömpelöityä" ;
lin ko'mpelo'sti_Adv = mkkAdv "kömpelösti" ;
lin ko'mpia'_V = mkkV "kömpiä" ;
lin ko'nga's_N = mkkN "köngäs" ;
lin ko'niin_Adv = mkkAdv "köniin" ;
lin ko'nnila'inen_N = mkkN "könniläinen" ;
lin ko'ntti_N = mkkN "köntti" ;
lin ko'ntta'_N = mkkN "könttä" ;
lin ko'ntys_N = mkkN "köntys" ;
lin ko'ntysta'a'_V = mkkV "köntystää" ;
lin ko'nyta'_V = mkkV "könytä" ;
lin ko'no'tta'a'_V = mkkV "könöttää" ;
lin ko'pelo'sti_Adv = mkkAdv "köpelösti" ;
lin ko'pitella'_V = mkkV "köpitellä" ;
lin ko'pitta'a'_V = mkkV "köpittää" ;
lin ko'rila's_N = mkkN "köriläs" ;
lin ko'rttila'inen_N = mkkN "körttiläinen" ;
lin ko'rttila'isyys_N = mkkN "körttiläisyys" ;
lin ko'ro'tella'_V = mkkV "körötellä" ;
lin ko'ro'tta'a'_V = mkkV "köröttää" ;
lin ko'ssi_1_N = mkkN "kössi" ;
lin ko'ssi_2_N = mkkN "kössi" ;
lin ko'ydenveto_N = mkkN "köydenveto" ;
lin ko'yhdytta'a'_V = mkkV "köyhdyttää" ;
lin ko'yhentya'_V = mkkV "köyhentyä" ;
lin ko'yheta'_V = mkkV "köyhetä" ;
lin ko'yhtyneisyys_N = mkkN "köyhtyneisyys" ;
lin ko'yhtya'_V = mkkV "köyhtyä" ;
lin ko'yhyys_N = mkkN "köyhyys" ;
lin ko'yha'_A = mkkA "köyhä" ;
lin ko'yha'illa'_V = mkkV "köyhäillä" ;
lin ko'yha'ily_N = mkkN "köyhäily" ;
lin ko'yha'listo'_N = mkkN "köyhälistö" ;
lin ko'yha'sti_Adv = mkkAdv "köyhästi" ;
lin ko'ykistella'_V = mkkV "köykistellä" ;
lin ko'ykistya'_V = mkkV "köykistyä" ;
lin ko'ykista'a'_V = mkkV "köykistää" ;
lin ko'ykkyyn_Adv = mkkAdv "köykkyyn" ;
lin ko'ykyssa'_Adv = mkkAdv "köykyssä" ;
lin ko'ykysta'_Adv = mkkAdv "köykystä" ;
lin ko'yka'inen_A = mkkA "köykäinen" ;
lin ko'yka'isesti_Adv = mkkAdv "köykäisesti" ;
lin ko'yka'isyys_N = mkkN "köykäisyys" ;
lin ko'ynnehtia'_V = mkkV "köynnehtiä" ;
lin ko'ynnelia's_N = mkkN "köynneliäs" ;
lin ko'ynno's_N = mkkN "köynnös" ;
lin ko'ynno'sta'a'_V = mkkV "köynnöstää" ;
lin ko'yristella'_V = mkkV "köyristellä" ;
lin ko'yristya'_V = mkkV "köyristyä" ;
lin ko'yrista'a'_V = mkkV "köyristää" ;
lin ko'yry_N = mkkN "köyry" ;
lin ko'yryssa'_Adv = mkkAdv "köyryssä" ;
lin ko'yrysta'_Adv = mkkAdv "köyrystä" ;
lin ko'yryyn_Adv = mkkAdv "köyryyn" ;
lin ko'ysi_N = mkkN "köysi" ;
lin ko'ysisto'_N = mkkN "köysistö" ;
lin ko'ysitta'a'_V = mkkV "köysittää" ;
lin ko'yte_N = mkkN "köyte" ;
lin ko'ytta'a'_V = mkkV "köyttää" ;
lin ko'yto's_N = mkkN "köytös" ;
lin ko'o'_N = mkkN "köö" ;
lin ko'o'ri_N = mkkN "kööri" ;
lin laadinta_N = mkkN "laadinta" ;
lin laadukas_A = mkkA "laadukas" ;
lin laadukkaasti_Adv = mkkAdv "laadukkaasti" ;
lin laadukkuus_N = mkkN "laadukkuus" ;
lin laadullinen_A = mkkA "laadullinen" ;
lin laadullisesti_Adv = mkkAdv "laadullisesti" ;
lin laadullistaa_V = mkkV "laadullistaa" ;
lin laaduton_N = mkkN "laaduton" ;
lin laahaantua_V = mkkV "laahaantua" ;
lin laahata_V = mkkV "laahata" ;
lin laahaus_N = mkkN "laahaus" ;
lin laahautua_V = mkkV "laahautua" ;
lin laahia_V = mkkV "laahia" ;
lin laahus_N = mkkN "laahus" ;
lin laahustaa_V = mkkV "laahustaa" ;
lin laahustin_N = mkkN "laahustin" ;
lin laaja_A = mkkA "laaja" ;
lin laajalti_Adv = mkkAdv "laajalti" ;
lin laajaspektrinen_N = mkkN "laajaspektrinen" ;
lin laajasti_Adv = mkkAdv "laajasti" ;
lin laajenema_N = mkkN "laajenema" ;
lin laajenemiskerroin_N = mkkN "laajenemiskerroin" ;
lin laajennelma_N = mkkN "laajennelma" ;
lin laajennos_N = mkkN "laajennos" ;
lin laajennus_N = mkkN "laajennus" ;
lin laajentaa_V = mkkV "laajentaa" ;
lin laajentua_V = mkkV "laajentua" ;
lin laajentuma_N = mkkN "laajentuma" ;
lin laajeta_V = mkkV "laajeta" ;
lin laajuinen_N = mkkN "laajuinen" ;
lin laajuus_N = mkkN "laajuus" ;
lin laaka_N = mkkN "laaka" ;
lin laakea_N = mkkN "laakea" ;
lin laakeri_1_N = mkkN "laakeri" ;
lin laakeri_2_N = mkkN "laakeri" ;
lin laakeroida_1_V = mkkV "laakeroida" ;
lin laakeroida_2_V = mkkV "laakeroida" ;
lin laakerointi_N = mkkN "laakerointi" ;
lin laaki_N = mkkN "laaki" ;
lin laakio_N = mkkN "laakio" ;
lin laakso_N = mkkN "laakso" ;
lin laaksoinen_N = mkkN "laaksoinen" ;
lin laama_1_N = mkkN "laama" ;
lin laama_2_N = mkkN "laama" ;
lin laamanni_N = mkkN "laamanni" ;
lin laannuttaa_V = mkkV "laannuttaa" ;
lin laantua_V = mkkV "laantua" ;
lin laapis_N = mkkN "laapis" ;
lin laardi_N = mkkN "laardi" ;
lin laari_N = mkkN "laari" ;
lin laasta_V = mkkV "laasta" ;
lin laastari_N = mkkN "laastari" ;
lin laastaroida_V = mkkV "laastaroida" ;
lin laastarointi_N = mkkN "laastarointi" ;
lin laasti_N = mkkN "laasti" ;
lin laastita_V = mkkV "laastita" ;
lin laastitus_N = mkkN "laastitus" ;
lin laata_V = mkkV "laata" ;
lin laatia_V = mkkV "laatia" ;
lin laatija_N = mkkN "laatija" ;
lin laatikko_N = mkkN "laatikko" ;
lin laatikkoonkanto_N = mkkN "laatikkoonkanto" ;
lin laatikoida_V = mkkV "laatikoida" ;
lin laatikollinen_N = mkkN "laatikollinen" ;
lin laatikosto_N = mkkN "laatikosto" ;
lin laatoittaa_V = mkkV "laatoittaa" ;
lin laatoitus_N = mkkN "laatoitus" ;
lin laatta_N = mkkN "laatta" ;
lin laatu_N = mkkN "laatu" ;
lin laatuaika_N = mkkN "laatuaika" ;
lin laatuinen_N = mkkN "laatuinen" ;
lin laatuisa_N = mkkN "laatuisa" ;
lin laatuisuus_N = mkkN "laatuisuus" ;
lin laava_N = mkkN "laava" ;
lin laavu_N = mkkN "laavu" ;
lin labiili_A = mkkA "labiili" ;
lin labiilisti_Adv = mkkAdv "labiilisti" ;
lin labiilius_N = mkkN "labiilius" ;
lin laboraattori_N = mkkN "laboraattori" ;
lin laborantti_N = mkkN "laborantti" ;
lin laboratorio_N = mkkN "laboratorio" ;
lin laboroida_V = mkkV "laboroida" ;
lin laborointi_N = mkkN "laborointi" ;
lin labradori_N = mkkN "labradori" ;
lin labradoriitti_N = mkkN "labradoriitti" ;
lin labyrintti_N = mkkN "labyrintti" ;
lin ladata_1_V = mkkV "ladata" ;
lin ladata_2_V = mkkV "ladata" ;
lin ladella_V = mkkV "ladella" ;
lin ladelma_N = mkkN "ladelma" ;
lin ladonta_N = mkkN "ladonta" ;
lin lados_N = mkkN "lados" ;
lin lady_N = mkkN "lady" ;
lin ladylike_N = mkkN "ladylike" ;
lin lafka_N = mkkN "lafka" ;
lin laguuni_N = mkkN "laguuni" ;
lin lahdata_V = mkkV "lahdata" ;
lin lahdeke_N = mkkN "lahdeke" ;
lin lahdelma_N = mkkN "lahdelma" ;
lin lahja_N = mkkN "lahja" ;
lin lahjainen_N = mkkN "lahjainen" ;
lin lahjaisuus_N = mkkN "lahjaisuus" ;
lin lahjakas_A = mkkA "lahjakas" ;
lin lahjakkaasti_Adv = mkkAdv "lahjakkaasti" ;
lin lahjakkuus_N = mkkN "lahjakkuus" ;
lin lahjaton_N = mkkN "lahjaton" ;
lin lahjattomuus_N = mkkN "lahjattomuus" ;
lin lahje_N = mkkN "lahje" ;
lin lahjoa_V = mkkV "lahjoa" ;
lin lahjoittaa_V = mkkV "lahjoittaa" ;
lin lahjoittaja_N = mkkN "lahjoittaja" ;
lin lahjoitus_N = mkkN "lahjoitus" ;
lin lahjoma_N = mkkN "lahjoma" ;
lin lahjomaton_N = mkkN "lahjomaton" ;
lin lahjomattomasti_Adv = mkkAdv "lahjomattomasti" ;
lin lahjomattomuus_N = mkkN "lahjomattomuus" ;
lin lahjonta_N = mkkN "lahjonta" ;
lin lahjottavuus_N = mkkN "lahjottavuus" ;
lin lahjus_N = mkkN "lahjus" ;
lin lahkeinen_N = mkkN "lahkeinen" ;
lin lahko_N = mkkN "lahko" ;
lin lahkolaisuus_N = mkkN "lahkolaisuus" ;
lin lahna_N = mkkN "lahna" ;
lin laho_N = mkkN "laho" ;
lin lahokas_N = mkkN "lahokas" ;
lin lahokka_N = mkkN "lahokka" ;
lin lahota_V = mkkV "lahota" ;
lin lahottaa_V = mkkV "lahottaa" ;
lin lahottaja_N = mkkN "lahottaja" ;
lin lahouma_N = mkkN "lahouma" ;
lin lahous_N = mkkN "lahous" ;
lin lahoutua_V = mkkV "lahoutua" ;
lin lahtari_N = mkkN "lahtari" ;
lin lahti_1_N = mkkN "lahti" ;
lin lahti_2_N = mkkN "lahti" ;
lin laidallinen_N = mkkN "laidallinen" ;
lin laidemmaksi_Adv = mkkAdv "laidemmaksi" ;
lin laidemmalla_Adv = mkkAdv "laidemmalla" ;
lin laidemmalle_Adv = mkkAdv "laidemmalle" ;
lin laidemmalta_Adv = mkkAdv "laidemmalta" ;
lin laidemmas_Adv = mkkAdv "laidemmas" ;
lin laidempaa_Adv = mkkAdv "laidempaa" ;
lin laidempana_Adv = mkkAdv "laidempana" ;
lin laidempi_N = mkkN "laidempi" ;
lin laidoittaa_V = mkkV "laidoittaa" ;
lin laidoitus_N = mkkN "laidoitus" ;
lin laidun_N = mkkN "laidun" ;
lin laiduntaa_V = mkkV "laiduntaa" ;
lin laiha_N = mkkN "laiha" ;
lin laihduttaa_V = mkkV "laihduttaa" ;
lin laihduttaja_N = mkkN "laihduttaja" ;
lin laihdutus_N = mkkN "laihdutus" ;
lin laiheliini_N = mkkN "laiheliini" ;
lin laihentaa_V = mkkV "laihentaa" ;
lin laihentua_V = mkkV "laihentua" ;
lin laiho_N = mkkN "laiho" ;
lin laihtua_V = mkkV "laihtua" ;
lin laihuus_N = mkkN "laihuus" ;
lin laikka_N = mkkN "laikka" ;
lin laikku_N = mkkN "laikku" ;
lin laikkuinen_N = mkkN "laikkuinen" ;
lin laikkuisuus_N = mkkN "laikkuisuus" ;
lin laikkuri_N = mkkN "laikkuri" ;
lin laikuittain_Adv = mkkAdv "laikuittain" ;
lin laikukas_N = mkkN "laikukas" ;
lin laikullinen_N = mkkN "laikullinen" ;
lin laikuttaa_V = mkkV "laikuttaa" ;
lin laikutus_N = mkkN "laikutus" ;
lin lailla_Adv = mkkAdv "lailla" ;
lin laillinen_A = mkkA "laillinen" ;
lin laillisesti_Adv = mkkAdv "laillisesti" ;
lin laillistaa_V = mkkV "laillistaa" ;
lin laillistua_V = mkkV "laillistua" ;
lin laillistus_N = mkkN "laillistus" ;
lin laillistuttaa_V = mkkV "laillistuttaa" ;
lin laillisuus_N = mkkN "laillisuus" ;
lin laimea_N = mkkN "laimea" ;
lin laimenne_N = mkkN "laimenne" ;
lin laimennos_N = mkkN "laimennos" ;
lin laimennus_N = mkkN "laimennus" ;
lin laimentaa_V = mkkV "laimentaa" ;
lin laimentua_V = mkkV "laimentua" ;
lin laimeta_V = mkkV "laimeta" ;
lin laimeus_N = mkkN "laimeus" ;
lin laimi_N = mkkN "laimi" ;
lin laimin_Adv = mkkAdv "laimin" ;
lin laimistaa_V = mkkV "laimistaa" ;
lin laimistua_V = mkkV "laimistua" ;
lin lain_Adv = mkkAdv "lain" ;
lin laina_N = mkkN "laina" ;
lin laina_aika_N = mkkN "laina-aika" ;
lin lainaaja_N = mkkN "lainaaja" ;
lin lainaamo_N = mkkN "lainaamo" ;
lin lainailla_V = mkkV "lainailla" ;
lin lainasto_N = mkkN "lainasto" ;
lin lainata_V = mkkV "lainata" ;
lin lainaus_N = mkkN "lainaus" ;
lin lainausaika_N = mkkN "lainausaika" ;
lin lainautua_V = mkkV "lainautua" ;
lin laine_N = mkkN "laine" ;
lin lainehdinta_N = mkkN "lainehdinta" ;
lin lainehtia_V = mkkV "lainehtia" ;
lin laineikas_N = mkkN "laineikas" ;
lin laineittaa_V = mkkV "laineittaa" ;
lin lainen_N = mkkN "lainen" ;
lin lainhuudatus_N = mkkN "lainhuudatus" ;
lin lainkaan_Adv = mkkAdv "lainkaan" ;
lin lainkohta_N = mkkN "lainkohta" ;
lin lainoittaa_V = mkkV "lainoittaa" ;
lin lainoitteinen_N = mkkN "lainoitteinen" ;
lin lainoitus_N = mkkN "lainoitus" ;
lin lainsa'a'da'nno'llinen_N = mkkN "lainsäädännöllinen" ;
lin laipio_N = mkkN "laipio" ;
lin laipoittaa_V = mkkV "laipoittaa" ;
lin laippa_N = mkkN "laippa" ;
lin laisin_Adv = mkkAdv "laisin" ;
lin laisinkaan_Adv = mkkAdv "laisinkaan" ;
lin laiska_A = mkkA "laiska" ;
lin laiskajaakko_N = mkkN "laiskajaakko" ;
lin laiskanpulskea_N = mkkN "laiskanpulskea" ;
lin laiskasti_Adv = mkkAdv "laiskasti" ;
lin laiskiainen_N = mkkN "laiskiainen" ;
lin laiskiintua_V = mkkV "laiskiintua" ;
lin laiskimus_N = mkkN "laiskimus" ;
lin laiskistaa_V = mkkV "laiskistaa" ;
lin laiskistua_V = mkkV "laiskistua" ;
lin laiskotella_V = mkkV "laiskotella" ;
lin laiskottaa_V = mkkV "laiskottaa" ;
lin laiskottelu_N = mkkN "laiskottelu" ;
lin laiskuri_N = mkkN "laiskuri" ;
lin laiskuus_N = mkkN "laiskuus" ;
lin laistaa_V = mkkV "laistaa" ;
lin laisto_N = mkkN "laisto" ;
lin laita_N = mkkN "laita" ;
lin laitainen_N = mkkN "laitainen" ;
lin laitama_N = mkkN "laitama" ;
lin laitattaa_V = mkkV "laitattaa" ;
lin laite_N = mkkN "laite" ;
lin laitella_V = mkkV "laitella" ;
lin laitimmainen_N = mkkN "laitimmainen" ;
lin laiton_N = mkkN "laiton" ;
lin laitos_N = mkkN "laitos" ;
lin laitostaa_V = mkkV "laitostaa" ;
lin laitostua_V = mkkV "laitostua" ;
lin laittaa_V = mkkV "laittaa" ;
lin laittamattomasti_Adv = mkkAdv "laittamattomasti" ;
lin laittautua_V = mkkV "laittautua" ;
lin laitteisto_N = mkkN "laitteisto" ;
lin laitto_N = mkkN "laitto" ;
lin laittomasti_Adv = mkkAdv "laittomasti" ;
lin laittomuus_N = mkkN "laittomuus" ;
lin laituri_1_N = mkkN "laituri" ;
lin laituri_2_N = mkkN "laituri" ;
lin laiva_N = mkkN "laiva" ;
lin laivaaja_N = mkkN "laivaaja" ;
lin laivainen_N = mkkN "laivainen" ;
lin laivalastillinen_N = mkkN "laivalastillinen" ;
lin laivasto_N = mkkN "laivasto" ;
lin laivata_V = mkkV "laivata" ;
lin laivaus_N = mkkN "laivaus" ;
lin laivue_N = mkkN "laivue" ;
lin laivuri_N = mkkN "laivuri" ;
lin laji_N = mkkN "laji" ;
lin lajikas_N = mkkN "lajikas" ;
lin lajike_N = mkkN "lajike" ;
lin lajinen_N = mkkN "lajinen" ;
lin lajisto_N = mkkN "lajisto" ;
lin lajite_N = mkkN "lajite" ;
lin lajitella_V = mkkV "lajitella" ;
lin lajitelma_N = mkkN "lajitelma" ;
lin lajitin_N = mkkN "lajitin" ;
lin lajittaa_V = mkkV "lajittaa" ;
lin lajittamo_N = mkkN "lajittamo" ;
lin lajittelija_N = mkkN "lajittelija" ;
lin lajittelu_N = mkkN "lajittelu" ;
lin lajittua_V = mkkV "lajittua" ;
lin lajiutua_V = mkkV "lajiutua" ;
lin lakaisija_N = mkkN "lakaisija" ;
lin lakaista_V = mkkV "lakaista" ;
lin lakaisu_N = mkkN "lakaisu" ;
lin lakana_N = mkkN "lakana" ;
lin lakastua_V = mkkV "lakastua" ;
lin lakastuttaa_V = mkkV "lakastuttaa" ;
lin lakata_1_V = mkkV "lakata" ;
lin lakata_2_V = mkkV "lakata" ;
lin lakea_N = mkkN "lakea" ;
lin lakeeri_N = mkkN "lakeeri" ;
lin lakeija_N = mkkN "lakeija" ;
lin lakeinen_N = mkkN "lakeinen" ;
lin lakeus_N = mkkN "lakeus" ;
lin laki_1_N = mkkN "laki" ;
lin laki_2_N = mkkN "laki" ;
lin lakiasa'a'ta'va'_N = mkkN "lakiasäätävä" ;
lin lakinen_1_N = mkkN "lakinen" ;
lin lakinen_2_N = mkkN "lakinen" ;
lin lakittaa_V = mkkV "lakittaa" ;
lin lakka_1_N = mkkN "lakka" ;
lin lakka_2_N = mkkN "lakka" ;
lin lakka_3_N = mkkN "lakka" ;
lin lakkaamaton_1_N = mkkN "lakkaamaton" ;
lin lakkaamaton_2_N = mkkN "lakkaamaton" ;
lin lakkaamatta_Adv = mkkAdv "lakkaamatta" ;
lin lakkaus_N = mkkN "lakkaus" ;
lin lakkauttaa_1_V = mkkV "lakkauttaa" ;
lin lakkauttaa_2_V = mkkV "lakkauttaa" ;
lin lakkautus_N = mkkN "lakkautus" ;
lin lakki_N = mkkN "lakki" ;
--? lin lakkiaiset_NK = {s = d38 "lakkiaiset" ;
lin lakkinen_N = mkkN "lakkinen" ;
lin lakko_N = mkkN "lakko" ;
lin lakkoilla_V = mkkV "lakkoilla" ;
lin lakkoilu_N = mkkN "lakkoilu" ;
lin lakmus_N = mkkN "lakmus" ;
lin lako_N = mkkN "lako" ;
lin lakoinen_N = mkkN "lakoinen" ;
lin lakoisuus_N = mkkN "lakoisuus" ;
lin lakoninen_A = mkkA "lakoninen" ;
lin lakonisesti_Adv = mkkAdv "lakonisesti" ;
lin lakonisuus_N = mkkN "lakonisuus" ;
lin lakoontua_V = mkkV "lakoontua" ;
lin lakoutua_V = mkkV "lakoutua" ;
lin lakritsa_N = mkkN "lakritsa" ;
lin lakritsi_N = mkkN "lakritsi" ;
lin lakritsijuuri_N = mkkN "lakritsijuuri" ;
lin laksatiivi_N = mkkN "laksatiivi" ;
lin laktaasi_N = mkkN "laktaasi" ;
lin laktoosi_N = mkkN "laktoosi" ;
lin laktoosi_intoleranssi_N = mkkN "laktoosi-intoleranssi" ;
lin laktoosi_intolerantti_N = mkkN "laktoosi-intolerantti" ;
lin laktoositon_N = mkkN "laktoositon" ;
lin laku_N = mkkN "laku" ;
lin lallatella_V = mkkV "lallatella" ;
lin lallattaa_V = mkkV "lallattaa" ;
lin lallukka_N = mkkN "lallukka" ;
lin lama_1_N = mkkN "lama" ;
lin lama_2_N = mkkN "lama" ;
lin lamaan_Adv = mkkAdv "lamaan" ;
lin lamaannus_N = mkkN "lamaannus" ;
lin lamaannuttaa_V = mkkV "lamaannuttaa" ;
lin lamaantua_V = mkkV "lamaantua" ;
lin lamaantuneisuus_N = mkkN "lamaantuneisuus" ;
lin lamalaisuus_N = mkkN "lamalaisuus" ;
lin lamarckismi_N = mkkN "lamarckismi" ;
lin lamassa_Adv = mkkAdv "lamassa" ;
lin lamasta_Adv = mkkAdv "lamasta" ;
lin lamata_V = mkkV "lamata" ;
lin lamauttaa_V = mkkV "lamauttaa" ;
lin lamautua_V = mkkV "lamautua" ;
lin lambada_N = mkkN "lambada" ;
lin lamee_N = mkkN "lamee" ;
lin lamelli_N = mkkN "lamelli" ;
lin laminaatti_N = mkkN "laminaatti" ;
lin laminoida_V = mkkV "laminoida" ;
lin laminointi_N = mkkN "laminointi" ;
lin lammas_N = mkkN "lammas" ;
lin lammasmaisesti_Adv = mkkAdv "lammasmaisesti" ;
lin lammasmaisuus_N = mkkN "lammasmaisuus" ;
lin lammikko_N = mkkN "lammikko" ;
lin lamoava_N = mkkN "lamoava" ;
lin lampaantalja_N = mkkN "lampaantalja" ;
lin lampaanvilla_N = mkkN "lampaanvilla" ;
lin lampare_N = mkkN "lampare" ;
lin lampetti_N = mkkN "lampetti" ;
lin lampi_N = mkkN "lampi" ;
lin lampola_N = mkkN "lampola" ;
lin lamppu_N = mkkN "lamppu" ;
lin lampsia_V = mkkV "lampsia" ;
lin lampuoti_N = mkkN "lampuoti" ;
lin lampuri_N = mkkN "lampuri" ;
lin lana_N = mkkN "lana" ;
lin lanata_V = mkkV "lanata" ;
lin lanaus_N = mkkN "lanaus" ;
lin lande_N = mkkN "lande" ;
lin langata_V = mkkV "langata" ;
lin langaton_N = mkkN "langaton" ;
lin langeta_V = mkkV "langeta" ;
lin langettaa_V = mkkV "langettaa" ;
lin langoittaa_V = mkkV "langoittaa" ;
lin langoitus_N = mkkN "langoitus" ;
--? lin langokset_NK = {s = d39 "langokset" ;
lin langusti_N = mkkN "langusti" ;
lin lanka_N = mkkN "lanka" ;
lin lankainen_N = mkkN "lankainen" ;
lin lankata_V = mkkV "lankata" ;
lin lankaus_N = mkkN "lankaus" ;
lin lankeemus_N = mkkN "lankeemus" ;
lin lankkaus_N = mkkN "lankkaus" ;
lin lankki_N = mkkN "lankki" ;
lin lankku_N = mkkN "lankku" ;
lin lanko_N = mkkN "lanko" ;
lin lankonki_N = mkkN "lankonki" ;
lin lankous_N = mkkN "lankous" ;
lin lankuttaa_V = mkkV "lankuttaa" ;
lin lankutus_N = mkkN "lankutus" ;
lin lanne_N = mkkN "lanne" ;
lin lannistaa_V = mkkV "lannistaa" ;
lin lannistua_V = mkkV "lannistua" ;
lin lannoite_N = mkkN "lannoite" ;
lin lannoitin_N = mkkN "lannoitin" ;
lin lannoittaa_V = mkkV "lannoittaa" ;
lin lannoittua_V = mkkV "lannoittua" ;
lin lannoitus_N = mkkN "lannoitus" ;
lin lannos_N = mkkN "lannos" ;
lin lanoliini_N = mkkN "lanoliini" ;
lin lanseerata_V = mkkV "lanseerata" ;
lin lanseeraus_N = mkkN "lanseeraus" ;
lin lansetti_N = mkkN "lansetti" ;
lin lanssi_N = mkkN "lanssi" ;
lin lanta_N = mkkN "lanta" ;
lin lantaani_N = mkkN "lantaani" ;
lin lantainen_N = mkkN "lantainen" ;
lin lantaisuus_N = mkkN "lantaisuus" ;
lin lantala_N = mkkN "lantala" ;
lin lantata_V = mkkV "lantata" ;
lin lanteinen_N = mkkN "lanteinen" ;
lin lantinki_N = mkkN "lantinki" ;
lin lantio_N = mkkN "lantio" ;
lin lantioinen_N = mkkN "lantioinen" ;
lin lantrata_V = mkkV "lantrata" ;
lin lantrinki_N = mkkN "lantrinki" ;
--? lin lantsarit_NK = {s = d06 "lantsarit" ;
lin lantti_N = mkkN "lantti" ;
lin lantto_N = mkkN "lantto" ;
lin lanttu_N = mkkN "lanttu" ;
lin laossa_Adv = mkkAdv "laossa" ;
lin laota_V = mkkV "laota" ;
lin laottaa_V = mkkV "laottaa" ;
lin lapa_N = mkkN "lapa" ;
lin lapainen_N = mkkN "lapainen" ;
lin lapakko_N = mkkN "lapakko" ;
lin lapanen_N = mkkN "lapanen" ;
lin laparoskopia_N = mkkN "laparoskopia" ;
lin lape_N = mkkN "lape" ;
lin lapidaarinen_N = mkkN "lapidaarinen" ;
lin lapikas_N = mkkN "lapikas" ;
lin lapio_N = mkkN "lapio" ;
lin lapioida_V = mkkV "lapioida" ;
lin lapiointi_N = mkkN "lapiointi" ;
lin lappaa_V = mkkV "lappaa" ;
lin lappalainen_N = mkkN "lappalainen" ;
lin lappautua_V = mkkV "lappautua" ;
lin lappeellaan_Adv = mkkAdv "lappeellaan" ;
lin lappeelleen_Adv = mkkAdv "lappeelleen" ;
lin lappi_N = mkkN "lappi" ;
lin lappo_N = mkkN "lappo" ;
lin lappologi_N = mkkN "lappologi" ;
lin lappu_N = mkkN "lappu" ;
lin lappuliisa_N = mkkN "lappuliisa" ;
lin lappunen_N = mkkN "lappunen" ;
lin lapsekas_A = mkkA "lapsekas" ;
lin lapsekkaasti_Adv = mkkAdv "lapsekkaasti" ;
lin lapsekkuus_N = mkkN "lapsekkuus" ;
lin lapseksiottaminen_N = mkkN "lapseksiottaminen" ;
lin lapsellinen_A = mkkA "lapsellinen" ;
lin lapsellisesti_Adv = mkkAdv "lapsellisesti" ;
lin lapsellisuus_N = mkkN "lapsellisuus" ;
lin lapsenkina_N = mkkN "lapsenkina" ;
lin lapsenomaisesti_Adv = mkkAdv "lapsenomaisesti" ;
lin lapseton_N = mkkN "lapseton" ;
lin lapsettaa_V = mkkV "lapsettaa" ;
lin lapsettomuus_N = mkkN "lapsettomuus" ;
lin lapseus_N = mkkN "lapseus" ;
lin lapsi_N = mkkN "lapsi" ;
lin lapsinen_N = mkkN "lapsinen" ;
lin lapsivuodeaika_N = mkkN "lapsivuodeaika" ;
lin lapsonen_N = mkkN "lapsonen" ;
lin lapsukainen_N = mkkN "lapsukainen" ;
lin lapsus_N = mkkN "lapsus" ;
lin lapsuudenaika_N = mkkN "lapsuudenaika" ;
lin lapsuus_N = mkkN "lapsuus" ;
lin lapsuusaika_N = mkkN "lapsuusaika" ;
lin laputtaa_1_V = mkkV "laputtaa" ;
lin laputtaa_2_V = mkkV "laputtaa" ;
lin largo_N = mkkN "largo" ;
lin lari_1_N = mkkN "lari" ;
lin lari_2_N = mkkN "lari" ;
lin lasagne_N = mkkN "lasagne" ;
lin lasaretti_N = mkkN "lasaretti" ;
lin laseerata_V = mkkV "laseerata" ;
lin laseeraus_N = mkkN "laseeraus" ;
lin laseittain_Adv = mkkAdv "laseittain" ;
lin laser_N = mkkN "laser" ;
lin laseri_N = mkkN "laseri" ;
lin lasi_N = mkkN "lasi" ;
lin lasiainen_N = mkkN "lasiainen" ;
lin lasikko_N = mkkN "lasikko" ;
lin lasillinen_N = mkkN "lasillinen" ;
lin lasinen_N = mkkN "lasinen" ;
lin lasinhioja_N = mkkN "lasinhioja" ;
lin lasintyo'sta'ja'_N = mkkN "lasintyöstäjä" ;
lin lasisto_N = mkkN "lasisto" ;
lin lasite_N = mkkN "lasite" ;
lin lasittaa_V = mkkV "lasittaa" ;
lin lasittaja_N = mkkN "lasittaja" ;
lin lasittua_V = mkkV "lasittua" ;
lin lasitus_N = mkkN "lasitus" ;
lin laskea_V = mkkV "laskea" ;
lin laskelma_N = mkkN "laskelma" ;
lin laskelmoida_V = mkkV "laskelmoida" ;
lin laskelmointi_N = mkkN "laskelmointi" ;
lin laskennallinen_A = mkkA "laskennallinen" ;
lin laskennallisesti_Adv = mkkAdv "laskennallisesti" ;
lin laskenta_N = mkkN "laskenta" ;
lin laskento_N = mkkN "laskento" ;
lin laskeskella_V = mkkV "laskeskella" ;
lin lasketella_V = mkkV "lasketella" ;
lin laskettaa_V = mkkV "laskettaa" ;
lin laskettelija_N = mkkN "laskettelija" ;
lin laskettelu_N = mkkN "laskettelu" ;
lin laskeuma_N = mkkN "laskeuma" ;
lin laskeutua_V = mkkV "laskeutua" ;
lin laskeutuma_N = mkkN "laskeutuma" ;
lin laskiainen_N = mkkN "laskiainen" ;
lin laskija_N = mkkN "laskija" ;
lin laskimo_N = mkkN "laskimo" ;
lin laskin_N = mkkN "laskin" ;
lin lasko_N = mkkN "lasko" ;
lin laskoksinen_N = mkkN "laskoksinen" ;
lin laskos_N = mkkN "laskos" ;
lin laskostaa_V = mkkV "laskostaa" ;
lin laskostua_V = mkkV "laskostua" ;
lin laskostus_N = mkkN "laskostus" ;
lin lasku_N = mkkN "lasku" ;
lin laskuinen_N = mkkN "laskuinen" ;
lin laskukohta_N = mkkN "laskukohta" ;
lin laskuri_N = mkkN "laskuri" ;
lin laskuttaa_V = mkkV "laskuttaa" ;
lin laskutus_N = mkkN "laskutus" ;
lin lassi_N = mkkN "lassi" ;
lin lassie_N = mkkN "lassie" ;
lin lasso_N = mkkN "lasso" ;
lin lassota_V = mkkV "lassota" ;
lin lasta_N = mkkN "lasta" ;
lin lastaaja_N = mkkN "lastaaja" ;
lin lastain_N = mkkN "lastain" ;
lin lastata_V = mkkV "lastata" ;
lin lastaus_N = mkkN "lastaus" ;
lin lastauttaa_V = mkkV "lastauttaa" ;
lin lasti_N = mkkN "lasti" ;
lin lastoittaa_V = mkkV "lastoittaa" ;
lin lastoitus_N = mkkN "lastoitus" ;
lin lastu_N = mkkN "lastu" ;
lin lastuta_V = mkkV "lastuta" ;
lin lata_N = mkkN "lata" ;
lin lataamo_N = mkkN "lataamo" ;
lin latauma_N = mkkN "latauma" ;
lin lataus_N = mkkN "lataus" ;
lin latautua_V = mkkV "latautua" ;
lin latautuma_N = mkkN "latautuma" ;
lin latautuneisuus_N = mkkN "latautuneisuus" ;
lin lateksi_N = mkkN "lateksi" ;
lin latelu_N = mkkN "latelu" ;
lin latenssi_N = mkkN "latenssi" ;
lin latenssiaika_N = mkkN "latenssiaika" ;
lin latentti_N = mkkN "latentti" ;
lin lateraalinen_N = mkkN "lateraalinen" ;
lin lati_N = mkkN "lati" ;
lin latina_N = mkkN "latina" ;
lin latinaistaa_V = mkkV "latinaistaa" ;
lin latinalaistaa_V = mkkV "latinalaistaa" ;
lin latinantaa_V = mkkV "latinantaa" ;
lin latinismi_N = mkkN "latinismi" ;
lin latinki_N = mkkN "latinki" ;
lin latino_N = mkkN "latino" ;
lin latinoida_V = mkkV "latinoida" ;
lin latistaa_V = mkkV "latistaa" ;
lin latistua_V = mkkV "latistua" ;
lin latitudi_N = mkkN "latitudi" ;
lin latkia_V = mkkV "latkia" ;
lin lato_N = mkkN "lato" ;
lin latoa_V = mkkV "latoa" ;
lin latoja_N = mkkN "latoja" ;
lin latomo_N = mkkN "latomo" ;
lin latomus_N = mkkN "latomus" ;
lin latta_N = mkkN "latta" ;
lin lattana_N = mkkN "lattana" ;
lin lattari_N = mkkN "lattari" ;
lin lattea_A = mkkA "lattea" ;
lin latteasti_Adv = mkkAdv "latteasti" ;
lin latteus_N = mkkN "latteus" ;
lin lattia_N = mkkN "lattia" ;
lin lattianraja_N = mkkN "lattianraja" ;
lin latu_N = mkkN "latu" ;
lin laturi_N = mkkN "laturi" ;
lin latuska_N = mkkN "latuska" ;
lin latuskainen_N = mkkN "latuskainen" ;
lin latva_N = mkkN "latva" ;
lin latvainen_N = mkkN "latvainen" ;
lin latvia_N = mkkN "latvia" ;
lin latvimmainen_N = mkkN "latvimmainen" ;
lin latvoa_V = mkkV "latvoa" ;
lin latvonta_N = mkkN "latvonta" ;
lin latvuksinen_N = mkkN "latvuksinen" ;
lin latvus_N = mkkN "latvus" ;
lin latvusto_N = mkkN "latvusto" ;
lin lauantai_N = mkkN "lauantai" ;
lin lauantainen_N = mkkN "lauantainen" ;
lin lauantaisin_Adv = mkkAdv "lauantaisin" ;
lin laudatur_N = mkkN "laudatur" ;
lin laude_N = mkkN "laude" ;
lin laudoittaa_V = mkkV "laudoittaa" ;
lin laudoittaja_N = mkkN "laudoittaja" ;
lin laudoitus_N = mkkN "laudoitus" ;
lin laueta_V = mkkV "laueta" ;
lin lauha_1_N = mkkN "lauha" ;
lin lauha_2_N = mkkN "lauha" ;
lin lauhde_N = mkkN "lauhde" ;
lin lauhdutin_N = mkkN "lauhdutin" ;
lin lauhduttaa_V = mkkV "lauhduttaa" ;
lin lauhdutus_N = mkkN "lauhdutus" ;
lin lauhentaa_V = mkkV "lauhentaa" ;
lin lauheta_V = mkkV "lauheta" ;
lin lauhkea_A = mkkA "lauhkea" ;
lin lauhkeasti_Adv = mkkAdv "lauhkeasti" ;
lin lauhkeus_N = mkkN "lauhkeus" ;
lin lauhtua_V = mkkV "lauhtua" ;
lin laukaisija_N = mkkN "laukaisija" ;
lin laukaisin_N = mkkN "laukaisin" ;
lin laukaista_V = mkkV "laukaista" ;
lin laukaisu_N = mkkN "laukaisu" ;
lin laukata_V = mkkV "laukata" ;
lin laukaus_N = mkkN "laukaus" ;
lin laukka_1_N = mkkN "laukka" ;
lin laukka_2_N = mkkN "laukka" ;
lin laukki_N = mkkN "laukki" ;
lin laukkoa_V = mkkV "laukkoa" ;
lin laukku_N = mkkN "laukku" ;
lin laukoa_V = mkkV "laukoa" ;
lin laulaa_V = mkkV "laulaa" ;
lin laulaja_N = mkkN "laulaja" ;
lin laulajatar_N = mkkN "laulajatar" ;
lin laulajisto_N = mkkN "laulajisto" ;
lin laulattaa_V = mkkV "laulattaa" ;
lin laulava_A = mkkA "laulava" ;
lin laulavasti_Adv = mkkAdv "laulavasti" ;
lin laulella_V = mkkV "laulella" ;
lin laulelma_N = mkkN "laulelma" ;
lin lauleskella_V = mkkV "lauleskella" ;
lin laulu_N = mkkN "laulu" ;
lin laulullinen_N = mkkN "laulullinen" ;
lin lauma_N = mkkN "lauma" ;
lin laumoittain_Adv = mkkAdv "laumoittain" ;
lin laupeus_N = mkkN "laupeus" ;
lin laupiaasti_Adv = mkkAdv "laupiaasti" ;
lin laupias_A = mkkA "laupias" ;
lin lausahdus_N = mkkN "lausahdus" ;
lin lausahtaa_V = mkkV "lausahtaa" ;
lin lause_N = mkkN "lause" ;
lin lauseinen_N = mkkN "lauseinen" ;
lin lauseke_N = mkkN "lauseke" ;
lin lauselma_N = mkkN "lauselma" ;
lin lausua_V = mkkV "lausua" ;
lin lausuja_N = mkkN "lausuja" ;
lin lausuma_N = mkkN "lausuma" ;
lin lausunta_N = mkkN "lausunta" ;
lin lausunto_N = mkkN "lausunto" ;
lin lauta_N = mkkN "lauta" ;
lin lautailija_N = mkkN "lautailija" ;
lin lautailla_V = mkkV "lautailla" ;
lin lautailu_N = mkkN "lautailu" ;
lin lautainen_N = mkkN "lautainen" ;
lin lautanen_N = mkkN "lautanen" ;
lin lautasaura_N = mkkN "lautasaura" ;
lin lautasellinen_N = mkkN "lautasellinen" ;
lin lautasmainen_N = mkkN "lautasmainen" ;
lin lautata_V = mkkV "lautata" ;
--? lin lauteet_NK = {s = d48A "lauteet" ;
lin lautta_N = mkkN "lautta" ;
lin lauttaus_N = mkkN "lauttaus" ;
lin lautturi_N = mkkN "lautturi" ;
lin lautuma_N = mkkN "lautuma" ;
lin lava_N = mkkN "lava" ;
lin lavainen_N = mkkN "lavainen" ;
lin lavallinen_N = mkkN "lavallinen" ;
lin lavastaa_V = mkkV "lavastaa" ;
lin lavastaja_N = mkkN "lavastaja" ;
lin lavastamo_N = mkkN "lavastamo" ;
lin lavaste_N = mkkN "lavaste" ;
lin lavastus_N = mkkN "lavastus" ;
lin lavea_A = mkkA "lavea" ;
lin laveasanaisesti_Adv = mkkAdv "laveasanaisesti" ;
lin laveasti_Adv = mkkAdv "laveasti" ;
lin laveerata_V = mkkV "laveerata" ;
lin laveeraus_N = mkkN "laveeraus" ;
lin laventaa_V = mkkV "laventaa" ;
lin laventaja_N = mkkN "laventaja" ;
lin laventeli_N = mkkN "laventeli" ;
lin laventua_V = mkkV "laventua" ;
lin laveri_N = mkkN "laveri" ;
lin laverrella_V = mkkV "laverrella" ;
lin lavetti_N = mkkN "lavetti" ;
lin laviini_N = mkkN "laviini" ;
lin lavitsa_N = mkkN "lavitsa" ;
lin lavuaari_N = mkkN "lavuaari" ;
lin layout_N = mkkN "layout" ;
lin leasing_N = mkkN "leasing" ;
lin LED_N = mkkN "LED" ;
lin ledi_N = mkkN "ledi" ;
lin leegio_N = mkkN "leegio" ;
lin leffa_N = mkkN "leffa" ;
lin legaalinen_N = mkkN "legaalinen" ;
lin legaalistaa_V = mkkV "legaalistaa" ;
lin legaatti_N = mkkN "legaatti" ;
lin legalisoida_V = mkkV "legalisoida" ;
lin legato_N = mkkN "legato" ;
lin legenda_N = mkkN "legenda" ;
lin legendaarinen_N = mkkN "legendaarinen" ;
lin leggingsit_N = mkkN "leggingsit" ;
lin leghorn_N = mkkN "leghorn" ;
lin legioona_N = mkkN "legioona" ;
lin legitiimi_N = mkkN "legitiimi" ;
lin legitiimiys_N = mkkN "legitiimiys" ;
lin legitimoida_V = mkkV "legitimoida" ;
lin legitimointi_N = mkkN "legitimointi" ;
lin leguaani_N = mkkN "leguaani" ;
lin lehahdella_V = mkkV "lehahdella" ;
lin lehahdus_N = mkkN "lehahdus" ;
lin lehahtaa_V = mkkV "lehahtaa" ;
lin lehaus_N = mkkN "lehaus" ;
lin lehauttaa_V = mkkV "lehauttaa" ;
--? lin lehdekset_NK = {s = d39 "lehdekset" ;
lin lehdesta'a'_V = mkkV "lehdestää" ;
lin lehdisto'_N = mkkN "lehdistö" ;
lin lehdokki_N = mkkN "lehdokki" ;
lin lehdykka'_N = mkkN "lehdykkä" ;
lin lehika'inen_N = mkkN "lehikäinen" ;
lin lehmihaka_N = mkkN "lehmihaka" ;
lin lehmus_N = mkkN "lehmus" ;
lin lehma'_N = mkkN "lehmä" ;
lin lehteilla'_V = mkkV "lehteillä" ;
lin lehteri_N = mkkN "lehteri" ;
lin lehtevyys_N = mkkN "lehtevyys" ;
lin lehteva'_N = mkkN "lehtevä" ;
lin lehti_N = mkkN "lehti" ;
lin lehtinen_N = mkkN "lehtinen" ;
lin lehtinen_N = mkkN "lehtinen" ;
lin lehtia'_V = mkkV "lehtiä" ;
lin lehtia'inen_N = mkkN "lehtiäinen" ;
lin lehtio'_N = mkkN "lehtiö" ;
lin lehto_N = mkkN "lehto" ;
lin lehtoraatti_N = mkkN "lehtoraatti" ;
lin lehtori_N = mkkN "lehtori" ;
lin lehvisto'_N = mkkN "lehvistö" ;
lin lehva'_N = mkkN "lehvä" ;
lin lehva'inen_N = mkkN "lehväinen" ;
lin lehva'sto'_N = mkkN "lehvästö" ;
lin lei_N = mkkN "lei" ;
lin leidi_N = mkkN "leidi" ;
lin leija_N = mkkN "leija" ;
lin leijailla_V = mkkV "leijailla" ;
lin leijailu_N = mkkN "leijailu" ;
lin leijata_1_V = mkkV "leijata" ;
lin leijata_2_V = mkkV "leijata" ;
lin leijona_N = mkkN "leijona" ;
lin leijua_V = mkkV "leijua" ;
lin leijuma_N = mkkN "leijuma" ;
lin leijunta_N = mkkN "leijunta" ;
lin leijuttaa_V = mkkV "leijuttaa" ;
lin leikata_V = mkkV "leikata" ;
lin leike_N = mkkN "leike" ;
lin leikella'_V = mkkV "leikellä" ;
lin leikillinen_A = mkkA "leikillinen" ;
lin leikillisesti_Adv = mkkAdv "leikillisesti" ;
lin leikillisyys_N = mkkN "leikillisyys" ;
lin leikilla'a'n_Adv = mkkAdv "leikillään" ;
lin leikisti_Adv = mkkAdv "leikisti" ;
lin leikitella'_V = mkkV "leikitellä" ;
lin leikiten_Adv = mkkAdv "leikiten" ;
lin leikittely_N = mkkN "leikittely" ;
lin leikitta'a'_V = mkkV "leikittää" ;
lin leikkaaja_N = mkkN "leikkaaja" ;
lin leikkaamo_N = mkkN "leikkaamo" ;
lin leikkaantua_V = mkkV "leikkaantua" ;
lin leikkaavuus_N = mkkN "leikkaavuus" ;
lin leikkain_N = mkkN "leikkain" ;
lin leikkaus_N = mkkN "leikkaus" ;
lin leikkaushaava_N = mkkN "leikkaushaava" ;
lin leikkauttaa_V = mkkV "leikkauttaa" ;
lin leikkautua_V = mkkV "leikkautua" ;
lin leikkele_N = mkkN "leikkele" ;
lin leikki_N = mkkN "leikki" ;
lin leikkija'_N = mkkN "leikkijä" ;
lin leikkisyys_N = mkkN "leikkisyys" ;
lin leikkisa'_A = mkkA "leikkisä" ;
lin leikkisa'sti_Adv = mkkAdv "leikkisästi" ;
lin leikkia'_V = mkkV "leikkiä" ;
lin leikkuri_N = mkkN "leikkuri" ;
lin leikkuu_N = mkkN "leikkuu" ;
lin leikkuuttaa_V = mkkV "leikkuuttaa" ;
lin leili_N = mkkN "leili" ;
lin leima_N = mkkN "leima" ;
lin leimaa_antava_N = mkkN "leimaa-antava" ;
lin leimaaja_N = mkkN "leimaaja" ;
lin leimahdella_V = mkkV "leimahdella" ;
lin leimahdus_N = mkkN "leimahdus" ;
lin leimahtaa_V = mkkV "leimahtaa" ;
lin leimahtelu_N = mkkN "leimahtelu" ;
lin leimasin_N = mkkN "leimasin" ;
lin leimata_V = mkkV "leimata" ;
lin leimaus_1_N = mkkN "leimaus" ;
lin leimaus_2_N = mkkN "leimaus" ;
lin leimauttaa_1_V = mkkV "leimauttaa" ;
lin leimauttaa_2_V = mkkV "leimauttaa" ;
lin leimautua_V = mkkV "leimautua" ;
lin leimu_N = mkkN "leimu" ;
lin leimuta_V = mkkV "leimuta" ;
lin leini_N = mkkN "leini" ;
lin leinikki_N = mkkN "leinikki" ;
lin leipoa_V = mkkV "leipoa" ;
lin leipoja_N = mkkN "leipoja" ;
lin leipomus_N = mkkN "leipomus" ;
lin leipoutua_V = mkkV "leipoutua" ;
lin leipuri_N = mkkN "leipuri" ;
lin leipa'_N = mkkN "leipä" ;
lin leipa'a'ntya'_V = mkkV "leipääntyä" ;
lin leireilla'_V = mkkV "leireillä" ;
lin leiri_N = mkkN "leiri" ;
lin leirila'inen_N = mkkN "leiriläinen" ;
lin leirinta'_N = mkkN "leirintä" ;
lin leiritta'a'_V = mkkV "leirittää" ;
lin leiritys_N = mkkN "leiritys" ;
lin leiriytya'_V = mkkV "leiriytyä" ;
lin leiskahdus_N = mkkN "leiskahdus" ;
lin leiskahtaa_V = mkkV "leiskahtaa" ;
lin leiskaus_N = mkkN "leiskaus" ;
lin leiskauttaa_V = mkkV "leiskauttaa" ;
lin leiskua_V = mkkV "leiskua" ;
lin leiskunta_N = mkkN "leiskunta" ;
lin leiviska'_N = mkkN "leiviskä" ;
lin leivite_N = mkkN "leivite" ;
lin leivitta'a'_V = mkkV "leivittää" ;
lin leivitys_N = mkkN "leivitys" ;
lin leivo_N = mkkN "leivo" ;
lin leivonen_N = mkkN "leivonen" ;
lin leivonnainen_N = mkkN "leivonnainen" ;
lin leivonta_N = mkkN "leivonta" ;
lin leivos_N = mkkN "leivos" ;
lin leiva'nkuori_N = mkkN "leivänkuori" ;
lin leiva'to'n_N = mkkN "leivätön" ;
lin lejeerata_V = mkkV "lejeerata" ;
lin lejeerinki_N = mkkN "lejeerinki" ;
lin leka_N = mkkN "leka" ;
lin lekkeri_N = mkkN "lekkeri" ;
lin lekotella_V = mkkV "lekotella" ;
lin lekottaa_V = mkkV "lekottaa" ;
lin leksikaalinen_N = mkkN "leksikaalinen" ;
lin leksikko_N = mkkN "leksikko" ;
lin leksikografi_N = mkkN "leksikografi" ;
lin leksikografia_N = mkkN "leksikografia" ;
lin leksikologia_N = mkkN "leksikologia" ;
lin lelli_N = mkkN "lelli" ;
lin lellikki_N = mkkN "lellikki" ;
lin lellitella'_V = mkkV "lellitellä" ;
lin lellittely_N = mkkN "lellittely" ;
lin lellia'_V = mkkV "lelliä" ;
lin lellua_V = mkkV "lellua" ;
lin lelu_N = mkkN "lelu" ;
lin lemahdella_V = mkkV "lemahdella" ;
lin lemahdus_N = mkkN "lemahdus" ;
lin lemahtaa_V = mkkV "lemahtaa" ;
lin lemmekkyys_N = mkkN "lemmekkyys" ;
lin lemmekka'a'sti_Adv = mkkAdv "lemmekkäästi" ;
lin lemmeka's_A = mkkA "lemmekäs" ;
lin lemmikki_N = mkkN "lemmikki" ;
lin lemmiskella'_V = mkkV "lemmiskellä" ;
lin lemmiskely_N = mkkN "lemmiskely" ;
lin lemmitty_N = mkkN "lemmitty" ;
lin lempata_V = mkkV "lempata" ;
lin lempeys_N = mkkN "lempeys" ;
lin lempea'_A = mkkA "lempeä" ;
lin lempea'sti_Adv = mkkAdv "lempeästi" ;
lin lempi_N = mkkN "lempi" ;
lin lempia'_V = mkkV "lempiä" ;
lin lempo_N = mkkN "lempo" ;
lin lemppari_N = mkkN "lemppari" ;
--? lin lemput_NK = {s = d01A "lemput" ;
lin lemu_N = mkkN "lemu" ;
lin lemuta_V = mkkV "lemuta" ;
lin leninila'inen_N = mkkN "leniniläinen" ;
lin leninila'isyys_N = mkkN "leniniläisyys" ;
lin leninismi_N = mkkN "leninismi" ;
lin leninisti_N = mkkN "leninisti" ;
lin leninki_N = mkkN "leninki" ;
lin lenkata_V = mkkV "lenkata" ;
lin lenkkari_N = mkkN "lenkkari" ;
lin lenkkeilija'_N = mkkN "lenkkeilijä" ;
lin lenkkeilla'_V = mkkV "lenkkeillä" ;
lin lenkkeily_N = mkkN "lenkkeily" ;
lin lenkki_N = mkkN "lenkki" ;
lin lenko_N = mkkN "lenko" ;
lin lenkous_N = mkkN "lenkous" ;
lin lennella'_V = mkkV "lennellä" ;
lin lennin_N = mkkN "lennin" ;
lin lennokas_A = mkkA "lennokas" ;
lin lennokkaasti_Adv = mkkAdv "lennokkaasti" ;
lin lennokki_N = mkkN "lennokki" ;
lin lennokkuus_N = mkkN "lennokkuus" ;
lin lennosto_N = mkkN "lennosto" ;
lin lenna'hdella'_V = mkkV "lennähdellä" ;
lin lenna'hta'a'_V = mkkV "lennähtää" ;
lin lenna'tella'_V = mkkV "lennätellä" ;
lin lenna'tin_N = mkkN "lennätin" ;
lin lenna'tta'a'_V = mkkV "lennättää" ;
lin lenna'tys_N = mkkN "lennätys" ;
lin lensea'_N = mkkN "lenseä" ;
lin lentely_N = mkkN "lentely" ;
lin lentis_N = mkkN "lentis" ;
lin lento_1_N = mkkN "lento" ;
lin lento_2_N = mkkN "lento" ;
lin lentoaika_N = mkkN "lentoaika" ;
lin lentoinen_N = mkkN "lentoinen" ;
lin lentoonammunta_N = mkkN "lentoonammunta" ;
lin lentsu_N = mkkN "lentsu" ;
lin lentue_N = mkkN "lentue" ;
lin lenta'ja'_N = mkkN "lentäjä" ;
lin lenta'va'_N = mkkN "lentävä" ;
lin lenta'a'_V = mkkV "lentää" ;
lin leopardi_N = mkkN "leopardi" ;
lin lepakko_N = mkkN "lepakko" ;
lin lepattaa_V = mkkV "lepattaa" ;
lin lepatus_N = mkkN "lepatus" ;
lin leperrella'_V = mkkV "leperrellä" ;
lin leperrys_N = mkkN "leperrys" ;
lin lepertely_N = mkkN "lepertely" ;
lin leperta'a'_V = mkkV "lepertää" ;
lin lepikko_N = mkkN "lepikko" ;
lin lepikkoinen_N = mkkN "lepikkoinen" ;
lin lepikko'_N = mkkN "lepikkö" ;
lin lepinka'inen_N = mkkN "lepinkäinen" ;
lin lepisto'_N = mkkN "lepistö" ;
lin lepo_N = mkkN "lepo" ;
lin lepoaika_N = mkkN "lepoaika" ;
lin leppeys_N = mkkN "leppeys" ;
lin leppea'_A = mkkA "leppeä" ;
lin leppea'sti_Adv = mkkAdv "leppeästi" ;
lin leppoisa_A = mkkA "leppoisa" ;
lin leppoisasti_Adv = mkkAdv "leppoisasti" ;
lin leppoisuus_N = mkkN "leppoisuus" ;
lin leppyma'tto'myys_N = mkkN "leppymättömyys" ;
lin leppyma'tto'ma'sti_Adv = mkkAdv "leppymättömästi" ;
lin leppyma'to'n_N = mkkN "leppymätön" ;
lin leppya'_V = mkkV "leppyä" ;
lin leppa'_N = mkkN "leppä" ;
lin leppa'inen_N = mkkN "leppäinen" ;
lin leppa'pirkko_N = mkkN "leppäpirkko" ;
lin lepra_N = mkkN "lepra" ;
lin lepsu_A = mkkA "lepsu" ;
lin lepsuilla_V = mkkV "lepsuilla" ;
lin lepsuilu_N = mkkN "lepsuilu" ;
lin lepsusti_Adv = mkkAdv "lepsusti" ;
lin lepsuus_N = mkkN "lepsuus" ;
lin leptoni_N = mkkN "leptoni" ;
lin lepuuttaa_V = mkkV "lepuuttaa" ;
lin lepuuttaja_N = mkkN "lepuuttaja" ;
lin lepuutus_N = mkkN "lepuutus" ;
lin lepytella'_V = mkkV "lepytellä" ;
lin lepytta'a'_V = mkkV "lepyttää" ;
lin lepytys_N = mkkN "lepytys" ;
lin lepa'illa'_V = mkkV "lepäillä" ;
lin lepa'nkuori_N = mkkN "lepänkuori" ;
lin lerpahtaa_V = mkkV "lerpahtaa" ;
lin lerpalla_Adv = mkkAdv "lerpalla" ;
lin lerpallaan_Adv = mkkAdv "lerpallaan" ;
lin lerpalle_Adv = mkkAdv "lerpalle" ;
lin lerpalleen_Adv = mkkAdv "lerpalleen" ;
lin lerpattaa_V = mkkV "lerpattaa" ;
lin lerppu_N = mkkN "lerppu" ;
lin lerppua_V = mkkV "lerppua" ;
lin lesbismi_N = mkkN "lesbismi" ;
lin lesbo_N = mkkN "lesbo" ;
lin lesbolaisuus_N = mkkN "lesbolaisuus" ;
lin lesbous_N = mkkN "lesbous" ;
lin lese_N = mkkN "lese" ;
lin lesema'to'n_N = mkkN "lesemätön" ;
lin lesitiini_N = mkkN "lesitiini" ;
lin lesia'inen_N = mkkN "lesiäinen" ;
lin leskeys_N = mkkN "leskeys" ;
lin leski_N = mkkN "leski" ;
lin lespata_V = mkkV "lespata" ;
lin lespaus_N = mkkN "lespaus" ;
lin lestadiolainen_N = mkkN "lestadiolainen" ;
lin lestadiolaisuus_N = mkkN "lestadiolaisuus" ;
lin lesti_N = mkkN "lesti" ;
lin lesty_N = mkkN "lesty" ;
lin lesta'_V = mkkV "lestä" ;
lin letitta'a'_V = mkkV "letittää" ;
lin letka_N = mkkN "letka" ;
lin letkahtaa_V = mkkV "letkahtaa" ;
lin letkaus_N = mkkN "letkaus" ;
lin letkautella_V = mkkV "letkautella" ;
lin letkauttaa_V = mkkV "letkauttaa" ;
lin letkautus_N = mkkN "letkautus" ;
lin letkeys_N = mkkN "letkeys" ;
lin letkea'_A = mkkA "letkeä" ;
lin letkea'sti_Adv = mkkAdv "letkeästi" ;
lin letkis_N = mkkN "letkis" ;
lin letku_N = mkkN "letku" ;
lin letti_N = mkkN "letti" ;
lin letto_N = mkkN "letto" ;
lin lettu_N = mkkN "lettu" ;
lin letukka_N = mkkN "letukka" ;
lin leuanveto_N = mkkN "leuanveto" ;
lin leudontaa_V = mkkV "leudontaa" ;
lin leudontua_V = mkkV "leudontua" ;
lin leudosti_Adv = mkkAdv "leudosti" ;
lin leudota_V = mkkV "leudota" ;
lin leuhahtaa_V = mkkV "leuhahtaa" ;
lin leuhauttaa_V = mkkV "leuhauttaa" ;
lin leuhka_A = mkkA "leuhka" ;
lin leuhkasti_Adv = mkkAdv "leuhkasti" ;
lin leuhkia_V = mkkV "leuhkia" ;
lin leuhkuus_N = mkkN "leuhkuus" ;
lin leuhottaa_V = mkkV "leuhottaa" ;
lin leuka_N = mkkN "leuka" ;
lin leukailla_V = mkkV "leukailla" ;
lin leukailu_N = mkkN "leukailu" ;
lin leukainen_N = mkkN "leukainen" ;
lin leukava_A = mkkA "leukava" ;
lin leukavasti_Adv = mkkAdv "leukavasti" ;
lin leukavuus_N = mkkN "leukavuus" ;
lin leukemia_N = mkkN "leukemia" ;
lin leukoija_N = mkkN "leukoija" ;
lin leukosyytti_N = mkkN "leukosyytti" ;
lin leuku_N = mkkN "leuku" ;
lin leuto_N = mkkN "leuto" ;
lin leutous_N = mkkN "leutous" ;
lin leveilla'_V = mkkV "leveillä" ;
lin leveily_N = mkkN "leveily" ;
lin levennella'_V = mkkV "levennellä" ;
lin levennys_N = mkkN "levennys" ;
lin leventely_N = mkkN "leventely" ;
lin leventya'_V = mkkV "leventyä" ;
lin leventa'a'_V = mkkV "leventää" ;
lin leveta'_V = mkkV "levetä" ;
lin leveys_N = mkkN "leveys" ;
lin levea'_A = mkkA "leveä" ;
lin levea'lti_Adv = mkkAdv "leveälti" ;
lin levea'sti_Adv = mkkAdv "leveästi" ;
lin levike_N = mkkN "levike" ;
lin levikki_N = mkkN "levikki" ;
lin levikkinen_N = mkkN "levikkinen" ;
lin levinneisyys_N = mkkN "levinneisyys" ;
lin levinta'_N = mkkN "levintä" ;
lin levinta'inen_N = mkkN "levintäinen" ;
lin levitaatio_N = mkkN "levitaatio" ;
lin levite_N = mkkN "levite" ;
lin levitella'_V = mkkV "levitellä" ;
lin levitin_N = mkkN "levitin" ;
lin levitoida_V = mkkV "levitoida" ;
lin levittya'_V = mkkV "levittyä" ;
lin levitta'ytya'_V = mkkV "levittäytyä" ;
lin levitta'a'_V = mkkV "levittää" ;
lin levitys_N = mkkN "levitys" ;
lin levita'_V = mkkV "levitä" ;
lin levia'in_N = mkkN "leviäin" ;
lin levollinen_A = mkkA "levollinen" ;
lin levollisesti_Adv = mkkAdv "levollisesti" ;
lin levollisuus_N = mkkN "levollisuus" ;
lin levoton_N = mkkN "levoton" ;
lin levottomasti_Adv = mkkAdv "levottomasti" ;
lin levottomuus_N = mkkN "levottomuus" ;
lin levy_N = mkkN "levy" ;
lin levyinen_1_N = mkkN "levyinen" ;
lin levyinen_2_N = mkkN "levyinen" ;
lin levyke_N = mkkN "levyke" ;
lin levyri_N = mkkN "levyri" ;
lin levysto'_N = mkkN "levystö" ;
lin levyte_N = mkkN "levyte" ;
lin levytta'a'_V = mkkV "levyttää" ;
lin levytys_N = mkkN "levytys" ;
lin leva'_N = mkkN "levä" ;
lin leva'hdys_N = mkkN "levähdys" ;
lin leva'hta'a'_1_V = mkkV "levähtää" ;
lin leva'hta'a'_2_V = mkkV "levähtää" ;
lin leva'kko'_N = mkkN "leväkkö" ;
lin leva'lleen_Adv = mkkAdv "levälleen" ;
lin leva'lla'a'n_Adv = mkkAdv "levällään" ;
lin leva'pera'isesti_Adv = mkkAdv "leväperäisesti" ;
lin leva'ta'_V = mkkV "levätä" ;
lin leva'ytta'a'_V = mkkV "leväyttää" ;
lin leyhka'_N = mkkN "leyhkä" ;
lin leyhytella'_V = mkkV "leyhytellä" ;
lin leyhytta'a'_V = mkkV "leyhyttää" ;
lin leyhya'_V = mkkV "leyhyä" ;
lin leyha'hdella'_V = mkkV "leyhähdellä" ;
lin leyha'hdys_N = mkkN "leyhähdys" ;
lin leyha'hta'a'_V = mkkV "leyhähtää" ;
lin leyha'ytta'a'_V = mkkV "leyhäyttää" ;
lin liaani_N = mkkN "liaani" ;
lin liata_V = mkkV "liata" ;
lin liberaali_A = mkkA "liberaali" ;
lin liberaalinen_A = mkkA "liberaalinen" ;
lin liberaalisesti_Adv = mkkAdv "liberaalisesti" ;
lin liberaalistaa_V = mkkV "liberaalistaa" ;
lin liberaalisti_Adv = mkkAdv "liberaalisti" ;
lin liberaalistua_V = mkkV "liberaalistua" ;
lin liberaalisuus_N = mkkN "liberaalisuus" ;
lin liberaalius_N = mkkN "liberaalius" ;
lin liberalismi_N = mkkN "liberalismi" ;
lin liberalisoida_V = mkkV "liberalisoida" ;
lin liberalisoitua_V = mkkV "liberalisoitua" ;
lin liberalisti_N = mkkN "liberalisti" ;
lin liberalistinen_N = mkkN "liberalistinen" ;
lin libero_N = mkkN "libero" ;
lin libido_N = mkkN "libido" ;
lin libretto_N = mkkN "libretto" ;
lin libristi_N = mkkN "libristi" ;
lin lie_Adv = mkkAdv "lie" ;
lin lied_N = mkkN "lied" ;
lin liehahdus_N = mkkN "liehahdus" ;
lin liehahtaa_V = mkkV "liehahtaa" ;
lin liehakas_A = mkkA "liehakas" ;
lin liehakka_N = mkkN "liehakka" ;
lin liehakkaasti_Adv = mkkAdv "liehakkaasti" ;
lin liehakko_N = mkkN "liehakko" ;
lin liehakoida_V = mkkV "liehakoida" ;
lin liehakoija_N = mkkN "liehakoija" ;
lin liehakointi_N = mkkN "liehakointi" ;
lin liehauttaa_V = mkkV "liehauttaa" ;
lin liehitella'_V = mkkV "liehitellä" ;
lin liehittelija'_N = mkkN "liehittelijä" ;
lin liehittely_N = mkkN "liehittely" ;
lin liehtoa_V = mkkV "liehtoa" ;
lin liehua_V = mkkV "liehua" ;
lin liehuke_N = mkkN "liehuke" ;
lin liehutella_V = mkkV "liehutella" ;
lin liehuttaa_V = mkkV "liehuttaa" ;
lin lieju_N = mkkN "lieju" ;
lin liejuinen_N = mkkN "liejuinen" ;
lin liejuisuus_N = mkkN "liejuisuus" ;
lin liejukko_N = mkkN "liejukko" ;
lin liejuuntua_V = mkkV "liejuuntua" ;
lin lieka_N = mkkN "lieka" ;
lin liekehdinta'_N = mkkN "liekehdintä" ;
lin liekehtia'_V = mkkV "liekehtiä" ;
lin liekitta'a'_V = mkkV "liekittää" ;
lin liekki_N = mkkN "liekki" ;
lin lieko_N = mkkN "lieko" ;
lin liekutella_V = mkkV "liekutella" ;
lin liekuttaa_V = mkkV "liekuttaa" ;
lin liemi_N = mkkN "liemi" ;
lin lienee_Adv = mkkAdv "lienee" ;
lin liennytta'a'_V = mkkV "liennyttää" ;
lin liennytys_N = mkkN "liennytys" ;
lin lientya'_V = mkkV "lientyä" ;
lin lienta'a'_V = mkkV "lientää" ;
lin liepeille_Adv = mkkAdv "liepeille" ;
lin liepeilla'_Adv = mkkAdv "liepeillä" ;
lin liepeilta'_Adv = mkkAdv "liepeiltä" ;
lin liepeinen_N = mkkN "liepeinen" ;
lin liereys_N = mkkN "liereys" ;
lin lierea'_N = mkkN "liereä" ;
lin lieri_N = mkkN "lieri" ;
lin lierinen_N = mkkN "lierinen" ;
lin lierio'_N = mkkN "lieriö" ;
lin liero_N = mkkN "liero" ;
lin lieroilla_V = mkkV "lieroilla" ;
lin lieroilu_N = mkkN "lieroilu" ;
lin liesi_N = mkkN "liesi" ;
lin lieska_N = mkkN "lieska" ;
lin liesma_N = mkkN "liesma" ;
lin liestya'_V = mkkV "liestyä" ;
lin liesu_1_N = mkkN "liesu" ;
lin liesu_2_N = mkkN "liesu" ;
lin liesuta_V = mkkV "liesuta" ;
lin liete_N = mkkN "liete" ;
lin lietso_N = mkkN "lietso" ;
lin lietsoa_V = mkkV "lietsoa" ;
lin lietsoin_N = mkkN "lietsoin" ;
lin lietsoja_N = mkkN "lietsoja" ;
lin lietsu_N = mkkN "lietsu" ;
lin lietsuta_V = mkkV "lietsuta" ;
lin lietteinen_N = mkkN "lietteinen" ;
lin lietto_N = mkkN "lietto" ;
lin liettua_N = mkkN "liettua" ;
lin liettyma'_N = mkkN "liettymä" ;
lin liettya'_V = mkkV "liettyä" ;
lin lietta'a'_V = mkkV "liettää" ;
lin lieve_N = mkkN "lieve" ;
lin lievennys_N = mkkN "lievennys" ;
lin lieventya'_V = mkkV "lieventyä" ;
lin lieventa'a'_V = mkkV "lieventää" ;
lin lieveta'_V = mkkV "lievetä" ;
lin lievike_N = mkkN "lievike" ;
lin lievittya'_V = mkkV "lievittyä" ;
lin lievitta'a'_V = mkkV "lievittää" ;
lin lievitys_N = mkkN "lievitys" ;
lin lievyys_N = mkkN "lievyys" ;
lin lieva'_A = mkkA "lievä" ;
lin lieva'sti_Adv = mkkAdv "lievästi" ;
lin liftaaja_N = mkkN "liftaaja" ;
lin liftari_N = mkkN "liftari" ;
lin liftata_V = mkkV "liftata" ;
lin liftaus_N = mkkN "liftaus" ;
lin lifti_N = mkkN "lifti" ;
lin ligniini_N = mkkN "ligniini" ;
lin liha_N = mkkN "liha" ;
lin lihainen_N = mkkN "lihainen" ;
lin lihaisa_N = mkkN "lihaisa" ;
lin lihakas_N = mkkN "lihakas" ;
lin lihaksekas_N = mkkN "lihaksekas" ;
lin lihaksikas_N = mkkN "lihaksikas" ;
lin lihaksinen_N = mkkN "lihaksinen" ;
lin lihaksisto_N = mkkN "lihaksisto" ;
lin lihallinen_N = mkkN "lihallinen" ;
lin lihas_N = mkkN "lihas" ;
lin lihasvena'htyma'_N = mkkN "lihasvenähtymä" ;
lin lihava_N = mkkN "lihava" ;
lin lihavoida_V = mkkV "lihavoida" ;
lin lihavuus_N = mkkN "lihavuus" ;
lin lihoa_V = mkkV "lihoa" ;
lin lihota_V = mkkV "lihota" ;
lin lihottaa_V = mkkV "lihottaa" ;
lin lihotus_N = mkkN "lihotus" ;
lin liiaksi_Adv = mkkAdv "liiaksi" ;
lin liiallinen_N = mkkN "liiallinen" ;
lin liiallisuus_N = mkkN "liiallisuus" ;
lin liialti_Adv = mkkAdv "liialti" ;
lin liian_Adv = mkkAdv "liian" ;
lin liidella'_V = mkkV "liidellä" ;
lin liidin_N = mkkN "liidin" ;
lin liidokki_N = mkkN "liidokki" ;
lin liiduta_V = mkkV "liiduta" ;
lin liiemmin_Adv = mkkAdv "liiemmin" ;
lin liiemma'lti_Adv = mkkAdv "liiemmälti" ;
lin liieta'_V = mkkV "liietä" ;
lin liiga_N = mkkN "liiga" ;
lin liigautua_V = mkkV "liigautua" ;
lin liihotella_V = mkkV "liihotella" ;
lin liihottaa_V = mkkV "liihottaa" ;
lin liika_N = mkkN "liika" ;
lin liikaa_Adv = mkkAdv "liikaa" ;
lin liikahdella_V = mkkV "liikahdella" ;
lin liikahdus_N = mkkN "liikahdus" ;
lin liikahduttaa_V = mkkV "liikahduttaa" ;
lin liikahtaa_V = mkkV "liikahtaa" ;
lin liikakansoitus_N = mkkN "liikakansoitus" ;
lin liikarasittunut_N = mkkN "liikarasittunut" ;
lin liikata_V = mkkV "liikata" ;
lin liikauttaa_V = mkkV "liikauttaa" ;
lin liike_N = mkkN "liike" ;
lin liikeaika_N = mkkN "liikeaika" ;
lin liikehdinta'_N = mkkN "liikehdintä" ;
lin liikehtia'_V = mkkV "liikehtiä" ;
lin liikenne_N = mkkN "liikenne" ;
lin liikenno'ida'_V = mkkV "liikennöidä" ;
lin liikenno'ija'_N = mkkN "liikennöijä" ;
lin liikenno'inti_N = mkkN "liikennöinti" ;
lin liikenno'itsija'_N = mkkN "liikennöitsijä" ;
lin liikenteinen_N = mkkN "liikenteinen" ;
lin liikkeelle_Adv = mkkAdv "liikkeelle" ;
lin liikkeellepaneva_N = mkkN "liikkeellepaneva" ;
lin liikkeella'_Adv = mkkAdv "liikkeellä" ;
lin liikkeessa'_Adv = mkkAdv "liikkeessä" ;
lin liikkeinen_N = mkkN "liikkeinen" ;
lin liikkeisyys_N = mkkN "liikkeisyys" ;
lin liikkis_N = mkkN "liikkis" ;
lin liikkua_V = mkkV "liikkua" ;
lin liikkuja_N = mkkN "liikkuja" ;
lin liikkumaton_N = mkkN "liikkumaton" ;
lin liikkumattomuus_N = mkkN "liikkumattomuus" ;
lin liikkuva_A = mkkA "liikkuva" ;
lin liikkuvainen_N = mkkN "liikkuvainen" ;
lin liikkuvasti_Adv = mkkAdv "liikkuvasti" ;
lin liikkuvuus_N = mkkN "liikkuvuus" ;
lin liikunnallinen_N = mkkN "liikunnallinen" ;
lin liikunta_N = mkkN "liikunta" ;
lin liikuskella_V = mkkV "liikuskella" ;
lin liikuskelu_N = mkkN "liikuskelu" ;
lin liikutella_V = mkkV "liikutella" ;
lin liikuttaa_V = mkkV "liikuttaa" ;
lin liikuttava_A = mkkA "liikuttava" ;
lin liikuttavasti_Adv = mkkAdv "liikuttavasti" ;
lin liikuttavuus_N = mkkN "liikuttavuus" ;
lin liikuttelu_N = mkkN "liikuttelu" ;
lin liikuttua_V = mkkV "liikuttua" ;
lin liikutus_N = mkkN "liikutus" ;
lin liila_N = mkkN "liila" ;
lin liima_N = mkkN "liima" ;
lin liimaantua_V = mkkV "liimaantua" ;
lin liimata_V = mkkV "liimata" ;
lin liimaus_N = mkkN "liimaus" ;
lin liimautua_V = mkkV "liimautua" ;
lin liimoite_N = mkkN "liimoite" ;
lin liimoittaa_V = mkkV "liimoittaa" ;
lin liimoittua_V = mkkV "liimoittua" ;
lin liimoitus_N = mkkN "liimoitus" ;
lin liina_N = mkkN "liina" ;
lin liinakko_N = mkkN "liinakko" ;
lin liioin_Adv = mkkAdv "liioin" ;
lin liioitella_V = mkkV "liioitella" ;
lin liioittelu_N = mkkN "liioittelu" ;
lin liipaisin_N = mkkN "liipaisin" ;
lin liipaista_V = mkkV "liipaista" ;
lin liipaisu_N = mkkN "liipaisu" ;
lin liipata_V = mkkV "liipata" ;
lin liipotin_N = mkkN "liipotin" ;
lin liippa_N = mkkN "liippa" ;
lin liippari_N = mkkN "liippari" ;
lin liira_N = mkkN "liira" ;
lin liirata_V = mkkV "liirata" ;
lin liirto_N = mkkN "liirto" ;
lin liirta'a'_V = mkkV "liirtää" ;
lin liirumlaarum_N = mkkN "liirumlaarum" ;
lin liirumlaarumi_N = mkkN "liirumlaarumi" ;
lin liisata_V = mkkV "liisata" ;
lin liisaus_N = mkkN "liisaus" ;
lin liiskaksi_Adv = mkkAdv "liiskaksi" ;
lin liiskana_Adv = mkkAdv "liiskana" ;
lin liisteri_N = mkkN "liisteri" ;
lin liistero'ida'_V = mkkV "liisteröidä" ;
lin liistero'inti_N = mkkN "liisteröinti" ;
lin liistero'itya'_V = mkkV "liisteröityä" ;
lin liisukka_N = mkkN "liisukka" ;
lin liite_N = mkkN "liite" ;
lin liitely_N = mkkN "liitely" ;
lin liiteri_N = mkkN "liiteri" ;
lin liitin_N = mkkN "liitin" ;
lin liito_N = mkkN "liito" ;
lin liitokiekkoilu_N = mkkN "liitokiekkoilu" ;
lin liitonarkki_N = mkkN "liitonarkki" ;
lin liitos_N = mkkN "liitos" ;
lin liitoskohta_N = mkkN "liitoskohta" ;
lin liitostaa_V = mkkV "liitostaa" ;
lin liitto_N = mkkN "liitto" ;
lin liittolaisuus_N = mkkN "liittolaisuus" ;
lin liittouma_N = mkkN "liittouma" ;
lin liittoutua_V = mkkV "liittoutua" ;
lin liittoutuma_N = mkkN "liittoutuma" ;
lin liittoutumaton_N = mkkN "liittoutumaton" ;
lin liittoutuneet_N = mkkN "liittoutuneet" ;
lin liittyma'_N = mkkN "liittymä" ;
lin liittyma'kohta_N = mkkN "liittymäkohta" ;
lin liittya'_V = mkkV "liittyä" ;
lin liitta'a'_V = mkkV "liittää" ;
lin liitu_N = mkkN "liitu" ;
lin liitynta'_N = mkkN "liityntä" ;
lin liita'nna'inen_N = mkkN "liitännäinen" ;
lin liita'nta'_N = mkkN "liitäntä" ;
lin liita'a'_V = mkkV "liitää" ;
lin liivakko_N = mkkN "liivakko" ;
lin liivari_N = mkkN "liivari" ;
lin liivate_N = mkkN "liivate" ;
lin liivi_1_N = mkkN "liivi" ;
lin liivi_2_N = mkkN "liivi" ;
lin liivila'inen_N = mkkN "liiviläinen" ;
lin lika_N = mkkN "lika" ;
lin likaahylkiva'_N = mkkN "likaahylkivä" ;
lin likaaja_N = mkkN "likaaja" ;
lin likaantua_V = mkkV "likaantua" ;
lin likainen_N = mkkN "likainen" ;
lin likeinen_A = mkkA "likeinen" ;
lin likeisesti_Adv = mkkAdv "likeisesti" ;
lin likeisyys_N = mkkN "likeisyys" ;
lin likekka'in_Adv = mkkAdv "likekkäin" ;
lin likekka'inen_N = mkkN "likekkäinen" ;
lin likelle_Adv = mkkAdv "likelle" ;
lin likella'_Adv = mkkAdv "likellä" ;
lin likelta'_Adv = mkkAdv "likeltä" ;
lin likemmin_Adv = mkkAdv "likemmin" ;
lin likemma'ksi_Adv = mkkAdv "likemmäksi" ;
lin likemma's_Adv = mkkAdv "likemmäs" ;
lin likempi_N = mkkN "likempi" ;
lin likempa'na'_Adv = mkkAdv "likempänä" ;
lin likempa'a'_Adv = mkkAdv "likempää" ;
lin likennella'_V = mkkV "likennellä" ;
lin likentya'_V = mkkV "likentyä" ;
lin likenta'a'_V = mkkV "likentää" ;
lin liki_Adv = mkkAdv "liki" ;
lin likika'a'n_Adv = mkkAdv "likikään" ;
lin likimailla_Adv = mkkAdv "likimailla" ;
lin likimaille_Adv = mkkAdv "likimaille" ;
lin likimailta_Adv = mkkAdv "likimailta" ;
lin likimainkaan_Adv = mkkAdv "likimainkaan" ;
lin likimma'ksi_Adv = mkkAdv "likimmäksi" ;
lin likimma's_Adv = mkkAdv "likimmäs" ;
lin likimpa'na'_Adv = mkkAdv "likimpänä" ;
lin likimpa'a'_Adv = mkkAdv "likimpää" ;
lin likima'a'rin_Adv = mkkAdv "likimäärin" ;
lin likin_N = mkkN "likin" ;
lin likinna'_Adv = mkkAdv "likinnä" ;
lin likistella'_V = mkkV "likistellä" ;
lin likistys_N = mkkN "likistys" ;
lin likistya'_V = mkkV "likistyä" ;
lin likista'ytya'_V = mkkV "likistäytyä" ;
lin likista'a'_V = mkkV "likistää" ;
lin likka_N = mkkN "likka" ;
lin likoon_Adv = mkkAdv "likoon" ;
lin liksa_N = mkkN "liksa" ;
lin likusteri_N = mkkN "likusteri" ;
lin likvidi_N = mkkN "likvidi" ;
lin likviditeetti_N = mkkN "likviditeetti" ;
lin likvidoida_V = mkkV "likvidoida" ;
lin likvidointi_N = mkkN "likvidointi" ;
lin likvori_N = mkkN "likvori" ;
lin liko'o'ri_N = mkkN "likööri" ;
lin lila_N = mkkN "lila" ;
lin lilja_N = mkkN "lilja" ;
lin lilliputti_N = mkkN "lilliputti" ;
lin lillia'_V = mkkV "lilliä" ;
lin lillua_V = mkkV "lillua" ;
lin lillukka_N = mkkN "lillukka" ;
lin lima_N = mkkN "lima" ;
lin limaantua_V = mkkV "limaantua" ;
lin limainen_N = mkkN "limainen" ;
lin limakko_N = mkkN "limakko" ;
lin limaska_N = mkkN "limaska" ;
lin limata_V = mkkV "limata" ;
lin limautua_V = mkkV "limautua" ;
lin limbo_N = mkkN "limbo" ;
lin limboilla_V = mkkV "limboilla" ;
lin limboilu_N = mkkN "limboilu" ;
lin lime_N = mkkN "lime" ;
lin limetti_N = mkkN "limetti" ;
lin limiitti_N = mkkN "limiitti" ;
lin limikka'in_Adv = mkkAdv "limikkäin" ;
lin limisaumainen_N = mkkN "limisaumainen" ;
lin limitin_N = mkkN "limitin" ;
lin limittya'_V = mkkV "limittyä" ;
lin limitta'in_Adv = mkkAdv "limittäin" ;
lin limitta'inen_N = mkkN "limittäinen" ;
lin limitta'a'_V = mkkV "limittää" ;
lin limitys_N = mkkN "limitys" ;
lin limitysten_Adv = mkkAdv "limitysten" ;
lin limninen_N = mkkN "limninen" ;
lin limnologi_N = mkkN "limnologi" ;
lin limnologia_N = mkkN "limnologia" ;
lin limoittua_V = mkkV "limoittua" ;
lin limonaati_N = mkkN "limonaati" ;
lin limonadi_N = mkkN "limonadi" ;
lin limppari_N = mkkN "limppari" ;
lin limppu_N = mkkN "limppu" ;
lin limsa_N = mkkN "limsa" ;
lin limska_N = mkkN "limska" ;
lin limu_N = mkkN "limu" ;
lin limusiini_N = mkkN "limusiini" ;
lin lineaarinen_N = mkkN "lineaarinen" ;
lin lingota_V = mkkV "lingota" ;
lin lingvisti_N = mkkN "lingvisti" ;
lin lingvistiikka_N = mkkN "lingvistiikka" ;
lin lingvistinen_N = mkkN "lingvistinen" ;
lin linimentti_N = mkkN "linimentti" ;
lin linja_N = mkkN "linja" ;
lin linjainen_N = mkkN "linjainen" ;
lin linjakas_A = mkkA "linjakas" ;
lin linjakkaasti_Adv = mkkAdv "linjakkaasti" ;
lin linjakkuus_N = mkkN "linjakkuus" ;
lin linjamentti_N = mkkN "linjamentti" ;
lin linjanveto_N = mkkN "linjanveto" ;
lin linjata_V = mkkV "linjata" ;
lin linjaton_N = mkkN "linjaton" ;
lin linjaus_N = mkkN "linjaus" ;
lin linjoittaa_V = mkkV "linjoittaa" ;
lin linjuri_N = mkkN "linjuri" ;
lin linkata_V = mkkV "linkata" ;
lin linkitta'a'_V = mkkV "linkittää" ;
lin linkitys_N = mkkN "linkitys" ;
lin linkki_N = mkkN "linkki" ;
lin linkku_N = mkkN "linkku" ;
lin linko_N = mkkN "linko" ;
lin linkous_N = mkkN "linkous" ;
lin linkoutua_V = mkkV "linkoutua" ;
lin linkuttaa_V = mkkV "linkuttaa" ;
lin linna_N = mkkN "linna" ;
lin linnake_N = mkkN "linnake" ;
lin linni_N = mkkN "linni" ;
lin linnoite_N = mkkN "linnoite" ;
lin linnoittaa_V = mkkV "linnoittaa" ;
lin linnoittautua_V = mkkV "linnoittautua" ;
lin linnoittua_V = mkkV "linnoittua" ;
lin linnoitus_N = mkkN "linnoitus" ;
lin linnustaa_V = mkkV "linnustaa" ;
lin linnustaja_N = mkkN "linnustaja" ;
lin linnusto_N = mkkN "linnusto" ;
lin linnustus_N = mkkN "linnustus" ;
lin lino_N = mkkN "lino" ;
lin linoleumi_N = mkkN "linoleumi" ;
lin linoli_N = mkkN "linoli" ;
lin linssi_N = mkkN "linssi" ;
lin linssisto'_N = mkkN "linssistö" ;
lin lintallaan_Adv = mkkAdv "lintallaan" ;
lin lintalleen_Adv = mkkAdv "lintalleen" ;
lin lintassa_Adv = mkkAdv "lintassa" ;
lin lintsaaja_N = mkkN "lintsaaja" ;
lin lintsari_N = mkkN "lintsari" ;
lin lintsata_V = mkkV "lintsata" ;
lin lintsaus_N = mkkN "lintsaus" ;
lin linttaan_Adv = mkkAdv "linttaan" ;
lin lintu_N = mkkN "lintu" ;
lin lintunen_N = mkkN "lintunen" ;
lin lintuniisikangas_N = mkkN "lintuniisikangas" ;
lin liossa_Adv = mkkAdv "liossa" ;
lin liosta_Adv = mkkAdv "liosta" ;
lin liota_V = mkkV "liota" ;
lin liotella_V = mkkV "liotella" ;
lin liottaa_V = mkkV "liottaa" ;
lin liotus_N = mkkN "liotus" ;
lin lipaista_V = mkkV "lipaista" ;
lin lipaisu_N = mkkN "lipaisu" ;
lin lipallinen_N = mkkN "lipallinen" ;
lin lipare_N = mkkN "lipare" ;
lin lipas_N = mkkN "lipas" ;
lin lipasto_N = mkkN "lipasto" ;
lin lipeinen_N = mkkN "lipeinen" ;
lin liperi_1_N = mkkN "liperi" ;
lin liperi_2_N = mkkN "liperi" ;
--? lin liperit_NK = {s = d06 "liperit" ;
lin lipettiin_Adv = mkkAdv "lipettiin" ;
lin lipevyys_N = mkkN "lipevyys" ;
lin lipeva'_A = mkkA "lipevä" ;
lin lipeva'sti_Adv = mkkAdv "lipevästi" ;
lin lipea'_N = mkkN "lipeä" ;
lin lipea'inen_N = mkkN "lipeäinen" ;
lin lipidi_N = mkkN "lipidi" ;
lin lipilaari_N = mkkN "lipilaari" ;
lin lipitta'a'_V = mkkV "lipittää" ;
lin lipitys_N = mkkN "lipitys" ;
lin liplattaa_V = mkkV "liplattaa" ;
lin liplatus_N = mkkN "liplatus" ;
lin lipoa_V = mkkV "lipoa" ;
lin lipoidi_N = mkkN "lipoidi" ;
lin lipokas_N = mkkN "lipokas" ;
lin lipota_V = mkkV "lipota" ;
lin lippa_N = mkkN "lippa" ;
lin lippi_N = mkkN "lippi" ;
lin lippis_N = mkkN "lippis" ;
lin lippo_N = mkkN "lippo" ;
lin lippu_N = mkkN "lippu" ;
lin lippue_N = mkkN "lippue" ;
lin lippunen_N = mkkN "lippunen" ;
lin lipsahdella_V = mkkV "lipsahdella" ;
lin lipsahdus_N = mkkN "lipsahdus" ;
lin lipsahduttaa_V = mkkV "lipsahduttaa" ;
lin lipsahtaa_V = mkkV "lipsahtaa" ;
lin lipsahtelu_N = mkkN "lipsahtelu" ;
lin lipsaus_N = mkkN "lipsaus" ;
lin lipsauttaa_V = mkkV "lipsauttaa" ;
lin lipsua_V = mkkV "lipsua" ;
lin lipua_V = mkkV "lipua" ;
lin lipuke_N = mkkN "lipuke" ;
lin liputtaa_V = mkkV "liputtaa" ;
lin liputus_N = mkkN "liputus" ;
lin lirahdella_V = mkkV "lirahdella" ;
lin lirahdus_N = mkkN "lirahdus" ;
lin lirahtaa_V = mkkV "lirahtaa" ;
lin liraus_N = mkkN "liraus" ;
lin lirautella_V = mkkV "lirautella" ;
lin lirauttaa_V = mkkV "lirauttaa" ;
lin liri_N = mkkN "liri" ;
lin lirina'_N = mkkN "lirinä" ;
lin lirista'_V = mkkV "liristä" ;
lin liritta'a'_V = mkkV "lirittää" ;
lin liritys_N = mkkN "liritys" ;
lin liria'_V = mkkV "liriä" ;
lin lirkutella_V = mkkV "lirkutella" ;
lin lirkuttaa_V = mkkV "lirkuttaa" ;
lin lirkuttelu_N = mkkN "lirkuttelu" ;
lin lirkutus_N = mkkN "lirkutus" ;
lin liro_N = mkkN "liro" ;
lin lirputella_V = mkkV "lirputella" ;
lin lirputtaa_V = mkkV "lirputtaa" ;
lin liru_N = mkkN "liru" ;
lin lirua_V = mkkV "lirua" ;
lin lirunlaru_N = mkkN "lirunlaru" ;
lin liruttaa_V = mkkV "liruttaa" ;
lin lirutus_N = mkkN "lirutus" ;
lin lisensiaatti_N = mkkN "lisensiaatti" ;
lin lisensioida_V = mkkV "lisensioida" ;
lin lisensiointi_N = mkkN "lisensiointi" ;
lin lisensoida_V = mkkV "lisensoida" ;
lin lisensointi_N = mkkN "lisensointi" ;
lin lisenssi_N = mkkN "lisenssi" ;
lin lisko_1_N = mkkN "lisko" ;
lin lisko_2_N = mkkN "lisko" ;
lin lista_N = mkkN "lista" ;
lin listake_N = mkkN "listake" ;
lin listata_V = mkkV "listata" ;
lin listaus_N = mkkN "listaus" ;
lin listauttaa_V = mkkV "listauttaa" ;
lin listautua_V = mkkV "listautua" ;
lin listia'_V = mkkV "listiä" ;
lin listoittaa_V = mkkV "listoittaa" ;
lin listoitus_N = mkkN "listoitus" ;
lin lisuke_N = mkkN "lisuke" ;
lin lisa'_N = mkkN "lisä" ;
lin lisa'aika_N = mkkN "lisäaika" ;
lin lisa'illa'_V = mkkV "lisäillä" ;
lin lisa'juuri_N = mkkN "lisäjuuri" ;
lin lisa'ke_N = mkkN "lisäke" ;
lin lisa'ksi_Adv = mkkAdv "lisäksi" ;
lin lisa'lyo'ntisyys_N = mkkN "lisälyöntisyys" ;
lin lisa'ta'_V = mkkV "lisätä" ;
lin lisa'ys_N = mkkN "lisäys" ;
lin lisa'ytya'_V = mkkV "lisäytyä" ;
lin lisa'a'_Adv = mkkAdv "lisää" ;
lin lisa'a'ntyvyys_N = mkkN "lisääntyvyys" ;
lin lisa'a'ntya'_V = mkkV "lisääntyä" ;
lin litania_N = mkkN "litania" ;
lin liti_N = mkkN "liti" ;
lin litina'_N = mkkN "litinä" ;
lin litistyksiin_Adv = mkkAdv "litistyksiin" ;
lin litistyksissa'_Adv = mkkAdv "litistyksissä" ;
lin litistyma'_N = mkkN "litistymä" ;
lin litistys_N = mkkN "litistys" ;
lin litistya'_V = mkkV "litistyä" ;
lin litista'_V = mkkV "litistä" ;
lin litista'a'_V = mkkV "litistää" ;
lin litium_N = mkkN "litium" ;
lin litkia'_V = mkkV "litkiä" ;
lin litku_N = mkkN "litku" ;
lin lito_N = mkkN "lito" ;
lin litografia_N = mkkN "litografia" ;
lin litografinen_N = mkkN "litografinen" ;
lin litra_N = mkkN "litra" ;
lin litroittain_Adv = mkkAdv "litroittain" ;
lin litsa_N = mkkN "litsa" ;
lin litsahdella_V = mkkV "litsahdella" ;
lin litsahtaa_V = mkkV "litsahtaa" ;
lin litsi_1_N = mkkN "litsi" ;
lin litsi_2_N = mkkN "litsi" ;
lin littera_N = mkkN "littera" ;
lin litteroida_V = mkkV "litteroida" ;
lin litteys_N = mkkN "litteys" ;
lin littea'_N = mkkN "litteä" ;
lin litu_N = mkkN "litu" ;
lin litukka_N = mkkN "litukka" ;
lin liturgi_N = mkkN "liturgi" ;
lin liturgia_N = mkkN "liturgia" ;
lin liturginen_N = mkkN "liturginen" ;
lin lituskainen_N = mkkN "lituskainen" ;
lin liudennus_N = mkkN "liudennus" ;
lin liudentaa_V = mkkV "liudentaa" ;
lin liudentua_V = mkkV "liudentua" ;
lin liueta_V = mkkV "liueta" ;
lin liukas_A = mkkA "liukas" ;
lin liukastaa_V = mkkV "liukastaa" ;
lin liukaste_N = mkkN "liukaste" ;
lin liukastella_V = mkkV "liukastella" ;
lin liukastua_V = mkkV "liukastua" ;
lin liukastus_N = mkkN "liukastus" ;
lin liukastuttaa_V = mkkV "liukastuttaa" ;
lin liukenematon_N = mkkN "liukenematon" ;
lin liukenemattomuus_N = mkkN "liukenemattomuus" ;
lin liukenevuus_N = mkkN "liukenevuus" ;
lin liukkaasti_Adv = mkkAdv "liukkaasti" ;
lin liukkaus_N = mkkN "liukkaus" ;
lin liukoinen_N = mkkN "liukoinen" ;
lin liukoisuus_N = mkkN "liukoisuus" ;
lin liuku_N = mkkN "liuku" ;
lin liukua_V = mkkV "liukua" ;
lin liukuma_N = mkkN "liukuma" ;
lin liukuri_N = mkkN "liukuri" ;
lin liukuvasti_Adv = mkkAdv "liukuvasti" ;
lin liukuvuus_N = mkkN "liukuvuus" ;
lin liuos_N = mkkN "liuos" ;
lin liuota_V = mkkV "liuota" ;
lin liuote_N = mkkN "liuote" ;
lin liuotin_N = mkkN "liuotin" ;
lin liuottaa_V = mkkV "liuottaa" ;
lin liuotus_N = mkkN "liuotus" ;
lin liuska_N = mkkN "liuska" ;
lin liuskainen_N = mkkN "liuskainen" ;
lin liuske_N = mkkN "liuske" ;
lin liuskeinen_N = mkkN "liuskeinen" ;
lin liuskoittaa_V = mkkV "liuskoittaa" ;
lin liuskoittua_V = mkkV "liuskoittua" ;
lin liuta_N = mkkN "liuta" ;
lin liu_unta_N = mkkN "liu'unta" ;
lin liu_uttaa_V = mkkV "liu'uttaa" ;
lin livahtaa_V = mkkV "livahtaa" ;
lin livautella_V = mkkV "livautella" ;
lin livauttaa_V = mkkV "livauttaa" ;
lin live_1_N = mkkN "live" ;
lin live_2_Adv = mkkAdv "live" ;
lin liverrella'_V = mkkV "liverrellä" ;
lin liverrys_N = mkkN "liverrys" ;
lin livertely_N = mkkN "livertely" ;
lin liverta'a'_V = mkkV "livertää" ;
lin livetta'a'_V = mkkV "livettää" ;
lin liveta'_V = mkkV "livetä" ;
lin livista'a'_V = mkkV "livistää" ;
lin livohkaan_Adv = mkkAdv "livohkaan" ;
lin livree_N = mkkN "livree" ;
lin loafer_N = mkkN "loafer" ;
lin loata_V = mkkV "loata" ;
lin lobata_V = mkkV "lobata" ;
lin lobbaaja_N = mkkN "lobbaaja" ;
lin lobbailla_V = mkkV "lobbailla" ;
lin lobbari_N = mkkN "lobbari" ;
lin lobbaus_N = mkkN "lobbaus" ;
lin lobbismi_N = mkkN "lobbismi" ;
lin lobbisti_N = mkkN "lobbisti" ;
lin lobby_N = mkkN "lobby" ;
lin lobelia_N = mkkN "lobelia" ;
lin loden_N = mkkN "loden" ;
lin logaritmi_N = mkkN "logaritmi" ;
lin logaritminen_N = mkkN "logaritminen" ;
lin logiikka_N = mkkN "logiikka" ;
lin logistiikka_1_N = mkkN "logistiikka" ;
lin logistiikka_2_N = mkkN "logistiikka" ;
lin logistikko_N = mkkN "logistikko" ;
lin logo_N = mkkN "logo" ;
lin logonomi_N = mkkN "logonomi" ;
lin logopedi_N = mkkN "logopedi" ;
lin logopedia_N = mkkN "logopedia" ;
lin lohduke_N = mkkN "lohduke" ;
lin lohdullinen_N = mkkN "lohdullinen" ;
lin lohdutella_V = mkkV "lohdutella" ;
lin lohduton_N = mkkN "lohduton" ;
lin lohduttaa_V = mkkV "lohduttaa" ;
lin lohduttautua_V = mkkV "lohduttautua" ;
lin lohduttomasti_Adv = mkkAdv "lohduttomasti" ;
lin lohduttomuus_N = mkkN "lohduttomuus" ;
lin lohdutus_N = mkkN "lohdutus" ;
lin lohestaa_V = mkkV "lohestaa" ;
lin lohi_N = mkkN "lohi" ;
lin lohjeta_V = mkkV "lohjeta" ;
lin lohkaista_V = mkkV "lohkaista" ;
lin lohkaisu_N = mkkN "lohkaisu" ;
lin lohkare_N = mkkN "lohkare" ;
lin lohkareinen_N = mkkN "lohkareinen" ;
lin lohkeama_N = mkkN "lohkeama" ;
lin lohkeavuus_N = mkkN "lohkeavuus" ;
lin lohkeilla_V = mkkV "lohkeilla" ;
lin lohko_N = mkkN "lohko" ;
lin lohkoa_V = mkkV "lohkoa" ;
lin lohkoinen_N = mkkN "lohkoinen" ;
lin lohkoontua_V = mkkV "lohkoontua" ;
lin lohkoutua_V = mkkV "lohkoutua" ;
lin lohtu_N = mkkN "lohtu" ;
lin loihtia_V = mkkV "loihtia" ;
lin loikata_V = mkkV "loikata" ;
lin loikka_N = mkkN "loikka" ;
lin loikkari_N = mkkN "loikkari" ;
lin loikkaus_N = mkkN "loikkaus" ;
lin loikkia_V = mkkV "loikkia" ;
lin loikko_N = mkkN "loikko" ;
lin loikoa_V = mkkV "loikoa" ;
lin loikoilla_V = mkkV "loikoilla" ;
lin loikoilu_N = mkkN "loikoilu" ;
lin loilottaa_V = mkkV "loilottaa" ;
lin loilotus_N = mkkN "loilotus" ;
lin loimahtaa_V = mkkV "loimahtaa" ;
lin loimi_N = mkkN "loimi" ;
lin loiminen_N = mkkN "loiminen" ;
lin loimottaa_V = mkkV "loimottaa" ;
lin loimotus_N = mkkN "loimotus" ;
lin loimu_N = mkkN "loimu" ;
lin loimuta_V = mkkV "loimuta" ;
lin loimuttaa_V = mkkV "loimuttaa" ;
lin loinen_N = mkkN "loinen" ;
lin loisia_V = mkkV "loisia" ;
lin loiskahdella_V = mkkV "loiskahdella" ;
lin loiskahdus_N = mkkN "loiskahdus" ;
lin loiskahtaa_V = mkkV "loiskahtaa" ;
lin loiskaus_N = mkkN "loiskaus" ;
lin loiskauttaa_V = mkkV "loiskauttaa" ;
lin loiske_N = mkkN "loiske" ;
lin loiskia_V = mkkV "loiskia" ;
lin loiskina_N = mkkN "loiskina" ;
lin loiskinta_N = mkkN "loiskinta" ;
lin loiskua_V = mkkV "loiskua" ;
lin loiskuna_N = mkkN "loiskuna" ;
lin loiskunta_N = mkkN "loiskunta" ;
lin loiskuta_V = mkkV "loiskuta" ;
lin loiskutella_V = mkkV "loiskutella" ;
lin loiskuttaa_V = mkkV "loiskuttaa" ;
lin loistaa_V = mkkV "loistaa" ;
lin loistava_A = mkkA "loistava" ;
lin loistavasti_Adv = mkkAdv "loistavasti" ;
lin loistavuus_N = mkkN "loistavuus" ;
lin loiste_N = mkkN "loiste" ;
lin loisteliaasti_Adv = mkkAdv "loisteliaasti" ;
lin loisteliaisuus_N = mkkN "loisteliaisuus" ;
lin loistelias_A = mkkA "loistelias" ;
lin loisto_N = mkkN "loisto" ;
lin loistoaika_N = mkkN "loistoaika" ;
lin loistokas_N = mkkN "loistokas" ;
lin loitolla_Adv = mkkAdv "loitolla" ;
lin loitolle_Adv = mkkAdv "loitolle" ;
lin loitolta_Adv = mkkAdv "loitolta" ;
lin loitommaksi_Adv = mkkAdv "loitommaksi" ;
lin loitommas_Adv = mkkAdv "loitommas" ;
lin loitompaa_Adv = mkkAdv "loitompaa" ;
lin loitompana_Adv = mkkAdv "loitompana" ;
lin loitonnus_N = mkkN "loitonnus" ;
lin loitontaa_V = mkkV "loitontaa" ;
lin loitontua_V = mkkV "loitontua" ;
lin loitota_V = mkkV "loitota" ;
lin loitsia_V = mkkV "loitsia" ;
lin loitsu_N = mkkN "loitsu" ;
lin loiva_A = mkkA "loiva" ;
lin loivasti_Adv = mkkAdv "loivasti" ;
lin loivennus_N = mkkN "loivennus" ;
lin loiventaa_V = mkkV "loiventaa" ;
lin loiventua_V = mkkV "loiventua" ;
lin loiveta_V = mkkV "loiveta" ;
lin loivuus_N = mkkN "loivuus" ;
lin lojaali_A = mkkA "lojaali" ;
lin lojaalinen_A = mkkA "lojaalinen" ;
lin lojaalisesti_Adv = mkkAdv "lojaalisesti" ;
lin lojaalisti_Adv = mkkAdv "lojaalisti" ;
lin lojaalisuus_N = mkkN "lojaalisuus" ;
lin lojaalius_N = mkkN "lojaalius" ;
lin lojahdus_N = mkkN "lojahdus" ;
lin lojahtaa_V = mkkV "lojahtaa" ;
lin lojaliteetti_N = mkkN "lojaliteetti" ;
lin lojua_V = mkkV "lojua" ;
lin loka_N = mkkN "loka" ;
lin lokaalisesti_Adv = mkkAdv "lokaalisesti" ;
lin lokaalisuus_N = mkkN "lokaalisuus" ;
lin lokainen_N = mkkN "lokainen" ;
lin lokalisaatio_N = mkkN "lokalisaatio" ;
lin lokalisoida_V = mkkV "lokalisoida" ;
lin lokalisoitua_V = mkkV "lokalisoitua" ;
lin lokari_N = mkkN "lokari" ;
lin lokerikko_N = mkkN "lokerikko" ;
lin lokero_N = mkkN "lokero" ;
lin lokeroida_V = mkkV "lokeroida" ;
lin lokeroinen_N = mkkN "lokeroinen" ;
lin lokerointi_N = mkkN "lokerointi" ;
lin lokeroitua_V = mkkV "lokeroitua" ;
lin lokerosto_N = mkkN "lokerosto" ;
lin loki_N = mkkN "loki" ;
lin lokki_N = mkkN "lokki" ;
lin lokoisa_A = mkkA "lokoisa" ;
lin lokoisasti_Adv = mkkAdv "lokoisasti" ;
lin lokomotiivi_N = mkkN "lokomotiivi" ;
lin loksaa_V = mkkV "loksaa" ;
lin loksahdella_V = mkkV "loksahdella" ;
lin loksahdus_N = mkkN "loksahdus" ;
lin loksahtaa_V = mkkV "loksahtaa" ;
lin loksauttaa_V = mkkV "loksauttaa" ;
lin lokse_N = mkkN "lokse" ;
lin loksua_V = mkkV "loksua" ;
lin loksuttaa_V = mkkV "loksuttaa" ;
lin lokvatti_N = mkkN "lokvatti" ;
lin lolita_N = mkkN "lolita" ;
lin loma_N = mkkN "loma" ;
lin loma_aika_N = mkkN "loma-aika" ;
lin lomaan_Adv = mkkAdv "lomaan" ;
lin lomailija_N = mkkN "lomailija" ;
lin lomailla_V = mkkV "lomailla" ;
lin lomailu_N = mkkN "lomailu" ;
lin lomake_N = mkkN "lomake" ;
lin lomakkain_Adv = mkkAdv "lomakkain" ;
lin lomassa_Adv = mkkAdv "lomassa" ;
lin lomasta_Adv = mkkAdv "lomasta" ;
lin lomatusten_Adv = mkkAdv "lomatusten" ;
lin lomauttaa_V = mkkV "lomauttaa" ;
lin lomautus_N = mkkN "lomautus" ;
lin lomikkain_Adv = mkkAdv "lomikkain" ;
lin lomitse_Adv = mkkAdv "lomitse" ;
lin lomittaa_V = mkkV "lomittaa" ;
lin lomittain_Adv = mkkAdv "lomittain" ;
lin lomittainen_N = mkkN "lomittainen" ;
lin lomittaja_N = mkkN "lomittaja" ;
lin lomittua_V = mkkV "lomittua" ;
lin lomitus_N = mkkN "lomitus" ;
lin lomitusten_Adv = mkkAdv "lomitusten" ;
lin lommo_N = mkkN "lommo" ;
lin lommoilla_V = mkkV "lommoilla" ;
lin lommoinen_N = mkkN "lommoinen" ;
lin lommoontua_V = mkkV "lommoontua" ;
lin lommoutua_V = mkkV "lommoutua" ;
lin lompakko_N = mkkN "lompakko" ;
lin lompsa_N = mkkN "lompsa" ;
lin long_drink_N = mkkN "lonC" ;
lin longerrella_V = mkkV "longerrella" ;
lin longertaa_V = mkkV "longertaa" ;
lin longitudi_N = mkkN "longitudi" ;
lin lonka_N = mkkN "lonka" ;
lin lonkero_1_N = mkkN "lonkero" ;
lin lonkero_2_N = mkkN "lonkero" ;
lin lonkeroinen_N = mkkN "lonkeroinen" ;
lin lonkka_N = mkkN "lonkka" ;
lin lonksahtaa_V = mkkV "lonksahtaa" ;
lin lonksua_V = mkkV "lonksua" ;
lin lonksuttaa_V = mkkV "lonksuttaa" ;
lin lonksutus_N = mkkN "lonksutus" ;
lin lonkuttaa_V = mkkV "lonkuttaa" ;
lin lonkutus_N = mkkN "lonkutus" ;
lin looginen_A = mkkA "looginen" ;
lin loogisesti_Adv = mkkAdv "loogisesti" ;
lin loogisuus_N = mkkN "loogisuus" ;
lin look_N = mkkN "look" ;
lin loosi_N = mkkN "loosi" ;
lin loota_N = mkkN "loota" ;
lin lootus_N = mkkN "lootus" ;
lin lopahtaa_V = mkkV "lopahtaa" ;
--? lin loparit_NK = {s = d06 "loparit" ;
lin lopen_Adv = mkkAdv "lopen" ;
lin lopetella_V = mkkV "lopetella" ;
lin lopettaa_V = mkkV "lopettaa" ;
--? lin lopettajaiset_NK = {s = d38 "lopettajaiset" ;
lin lopetus_N = mkkN "lopetus" ;
lin loppiainen_N = mkkN "loppiainen" ;
lin loppiaisaika_N = mkkN "loppiaisaika" ;
lin loppu_N = mkkN "loppu" ;
lin loppua_V = mkkV "loppua" ;
lin loppuaika_N = mkkN "loppuaika" ;
lin loppuinen_N = mkkN "loppuinen" ;
lin loppukaneetti_N = mkkN "loppukaneetti" ;
lin loppumaton_N = mkkN "loppumaton" ;
lin loppumattomasti_Adv = mkkAdv "loppumattomasti" ;
lin loppuun_Adv = mkkAdv "loppuun" ;
lin lopuillaan_Adv = mkkAdv "lopuillaan" ;
lin lopuke_N = mkkN "lopuke" ;
lin lopuksi_Adv = mkkAdv "lopuksi" ;
lin lopulla_Adv = mkkAdv "lopulla" ;
lin lopullaan_Adv = mkkAdv "lopullaan" ;
lin lopullinen_A = mkkA "lopullinen" ;
lin lopullisesti_Adv = mkkAdv "lopullisesti" ;
lin lopullisuus_N = mkkN "lopullisuus" ;
lin lopulta_Adv = mkkAdv "lopulta" ;
lin lopussa_Adv = mkkAdv "lopussa" ;
lin loputon_N = mkkN "loputon" ;
lin loputtomasti_Adv = mkkAdv "loputtomasti" ;
lin loputtomiin_Adv = mkkAdv "loputtomiin" ;
lin loputtomuus_N = mkkN "loputtomuus" ;
lin lorahdus_N = mkkN "lorahdus" ;
lin lorahtaa_V = mkkV "lorahtaa" ;
lin loraus_N = mkkN "loraus" ;
lin lorauttaa_V = mkkV "lorauttaa" ;
lin lordi_N = mkkN "lordi" ;
lin lordoosi_N = mkkN "lordoosi" ;
lin lorina_N = mkkN "lorina" ;
lin lorista_V = mkkV "lorista" ;
lin lornjetti_N = mkkN "lornjetti" ;
lin lorottaa_V = mkkV "lorottaa" ;
lin loru_N = mkkN "loru" ;
lin loruilla_V = mkkV "loruilla" ;
lin lorvailla_V = mkkV "lorvailla" ;
lin lorvailu_N = mkkN "lorvailu" ;
lin lorvehtia_V = mkkV "lorvehtia" ;
lin lorvia_V = mkkV "lorvia" ;
lin loska_N = mkkN "loska" ;
lin loskaantua_V = mkkV "loskaantua" ;
lin loskainen_N = mkkN "loskainen" ;
lin losottaa_V = mkkV "losottaa" ;
lin lossata_1_V = mkkV "lossata" ;
lin lossata_2_V = mkkV "lossata" ;
lin lossi_N = mkkN "lossi" ;
lin lossiksi_Adv = mkkAdv "lossiksi" ;
lin lotina_N = mkkN "lotina" ;
lin lotion_N = mkkN "lotion" ;
lin lotista_V = mkkV "lotista" ;
lin lotja_N = mkkN "lotja" ;
lin lotkauttaa_V = mkkV "lotkauttaa" ;
lin lotota_V = mkkV "lotota" ;
lin lotrata_V = mkkV "lotrata" ;
lin lotta_1_N = mkkN "lotta" ;
lin lotta_2_N = mkkN "lotta" ;
lin lotto_N = mkkN "lotto" ;
lin lottoaja_N = mkkN "lottoaja" ;
lin louferi_N = mkkN "louferi" ;
lin louhe_N = mkkN "louhe" ;
lin louhia_V = mkkV "louhia" ;
lin louhikko_N = mkkN "louhikko" ;
lin louhikkoinen_N = mkkN "louhikkoinen" ;
lin louhimo_N = mkkN "louhimo" ;
lin louhinta_N = mkkN "louhinta" ;
lin louhos_N = mkkN "louhos" ;
lin loukata_V = mkkV "loukata" ;
lin loukkaamaton_N = mkkN "loukkaamaton" ;
lin loukkaantua_V = mkkV "loukkaantua" ;
lin loukkaus_N = mkkN "loukkaus" ;
lin loukkautua_V = mkkV "loukkautua" ;
lin loukko_N = mkkN "loukko" ;
lin loukku_N = mkkN "loukku" ;
lin loukuttaa_V = mkkV "loukuttaa" ;
lin lounainen_N = mkkN "lounainen" ;
lin lounas_N = mkkN "lounas" ;
lin lounasaika_N = mkkN "lounasaika" ;
lin lounastaa_V = mkkV "lounastaa" ;
lin louske_N = mkkN "louske" ;
lin louskua_V = mkkV "louskua" ;
lin louskutella_V = mkkV "louskutella" ;
lin louskuttaa_V = mkkV "louskuttaa" ;
lin lovellinen_N = mkkN "lovellinen" ;
lin loveta_V = mkkV "loveta" ;
lin loveus_N = mkkN "loveus" ;
lin lovi_N = mkkN "lovi" ;
lin lovinen_N = mkkN "lovinen" ;
lin lovittaa_V = mkkV "lovittaa" ;
lin lovitus_N = mkkN "lovitus" ;
lin lude_N = mkkN "lude" ;
lin lueksia_V = mkkV "lueksia" ;
lin luennoida_V = mkkV "luennoida" ;
lin luennoija_N = mkkN "luennoija" ;
lin luennoitsija_N = mkkN "luennoitsija" ;
lin luenta_N = mkkN "luenta" ;
lin luento_N = mkkN "luento" ;
lin lues_N = mkkN "lues" ;
lin lueskella_V = mkkV "lueskella" ;
lin luetella_V = mkkV "luetella" ;
lin luetelma_N = mkkN "luetelma" ;
lin luettaa_V = mkkV "luettaa" ;
lin luettava_N = mkkN "luettava" ;
lin luettavuus_N = mkkN "luettavuus" ;
lin luettelo_N = mkkN "luettelo" ;
lin luetteloida_V = mkkV "luetteloida" ;
lin luettelointi_N = mkkN "luettelointi" ;
lin luetuttaa_V = mkkV "luetuttaa" ;
lin luhistaa_V = mkkV "luhistaa" ;
lin luhistua_V = mkkV "luhistua" ;
lin luhistuma_N = mkkN "luhistuma" ;
lin luhta_N = mkkN "luhta" ;
lin luhtahuitti_N = mkkN "luhtahuitti" ;
lin luhti_N = mkkN "luhti" ;
lin luihu_A = mkkA "luihu" ;
lin luihusti_Adv = mkkAdv "luihusti" ;
lin luikahtaa_V = mkkV "luikahtaa" ;
lin luikata_V = mkkV "luikata" ;
lin luikauttaa_V = mkkV "luikauttaa" ;
lin luikero_N = mkkN "luikero" ;
lin luikerrella_V = mkkV "luikerrella" ;
lin luikertaa_V = mkkV "luikertaa" ;
lin luikka_N = mkkN "luikka" ;
lin luikkia_V = mkkV "luikkia" ;
lin luiku_N = mkkN "luiku" ;
lin luikuri_N = mkkN "luikuri" ;
lin luimistaa_V = mkkV "luimistaa" ;
lin luimistella_V = mkkV "luimistella" ;
lin luimussa_Adv = mkkAdv "luimussa" ;
lin luimuun_Adv = mkkAdv "luimuun" ;
lin luinen_N = mkkN "luinen" ;
lin luiru_N = mkkN "luiru" ;
lin luiseva_N = mkkN "luiseva" ;
lin luiska_N = mkkN "luiska" ;
lin luiskahdus_N = mkkN "luiskahdus" ;
lin luiskahtaa_V = mkkV "luiskahtaa" ;
lin luiskata_V = mkkV "luiskata" ;
lin luiskauttaa_V = mkkV "luiskauttaa" ;
lin luistaa_V = mkkV "luistaa" ;
lin luistattaa_V = mkkV "luistattaa" ;
lin luistava_N = mkkN "luistava" ;
lin luistelija_N = mkkN "luistelija" ;
lin luistella_V = mkkV "luistella" ;
lin luistelu_N = mkkN "luistelu" ;
lin luisti_N = mkkN "luisti" ;
lin luistin_N = mkkN "luistin" ;
lin luisto_N = mkkN "luisto" ;
lin luistoinen_N = mkkN "luistoinen" ;
lin luisu_N = mkkN "luisu" ;
lin luisua_V = mkkV "luisua" ;
lin luisuttaa_V = mkkV "luisuttaa" ;
lin luja_A = mkkA "luja" ;
lin lujaa_Adv = mkkAdv "lujaa" ;
lin lujaan_Adv = mkkAdv "lujaan" ;
lin lujaka'tisesti_Adv = mkkAdv "lujakätisesti" ;
lin lujalla_Adv = mkkAdv "lujalla" ;
lin lujalle_Adv = mkkAdv "lujalle" ;
lin lujassa_Adv = mkkAdv "lujassa" ;
lin lujasta_Adv = mkkAdv "lujasta" ;
lin lujasti_Adv = mkkAdv "lujasti" ;
lin lujentaa_V = mkkV "lujentaa" ;
lin lujentua_V = mkkV "lujentua" ;
lin lujeta_V = mkkV "lujeta" ;
lin lujike_N = mkkN "lujike" ;
lin lujilla_Adv = mkkAdv "lujilla" ;
lin lujille_Adv = mkkAdv "lujille" ;
lin lujite_N = mkkN "lujite" ;
lin lujittaa_V = mkkV "lujittaa" ;
lin lujittua_V = mkkV "lujittua" ;
lin lujuus_N = mkkN "lujuus" ;
lin lukaali_N = mkkN "lukaali" ;
lin lukaista_V = mkkV "lukaista" ;
lin lukea_V = mkkV "lukea" ;
lin lukema_N = mkkN "lukema" ;
lin lukematon_N = mkkN "lukematon" ;
lin lukeminen_N = mkkN "lukeminen" ;
lin lukemisto_N = mkkN "lukemisto" ;
lin lukeneisto_N = mkkN "lukeneisto" ;
lin lukeneisuus_N = mkkN "lukeneisuus" ;
lin lukeutua_V = mkkV "lukeutua" ;
lin lukien_Adv = mkkAdv "lukien" ;
lin lukija_N = mkkN "lukija" ;
lin lukio_N = mkkN "lukio" ;
lin lukita_V = mkkV "lukita" ;
lin lukitsin_N = mkkN "lukitsin" ;
lin lukittua_V = mkkV "lukittua" ;
lin lukitus_N = mkkN "lukitus" ;
lin lukkari_N = mkkN "lukkari" ;
lin lukkaroida_V = mkkV "lukkaroida" ;
lin lukki_N = mkkN "lukki" ;
lin lukkiinnuttaa_V = mkkV "lukkiinnuttaa" ;
lin lukkiintua_V = mkkV "lukkiintua" ;
lin lukkiuttaa_V = mkkV "lukkiuttaa" ;
lin lukkiutua_V = mkkV "lukkiutua" ;
lin lukkiutuma_N = mkkN "lukkiutuma" ;
lin lukkiutumaton_N = mkkN "lukkiutumaton" ;
lin lukko_N = mkkN "lukko" ;
lin lukkoon_Adv = mkkAdv "lukkoon" ;
lin lukkoutua_V = mkkV "lukkoutua" ;
lin lukollinen_N = mkkN "lukollinen" ;
lin lukossa_Adv = mkkAdv "lukossa" ;
lin lukosta_Adv = mkkAdv "lukosta" ;
lin luksaatio_N = mkkN "luksaatio" ;
lin luksi_N = mkkN "luksi" ;
lin luksus_N = mkkN "luksus" ;
lin luksuttaa_V = mkkV "luksuttaa" ;
lin luku_N = mkkN "luku" ;
lin lukuinen_N = mkkN "lukuinen" ;
lin lukuisa_A = mkkA "lukuisa" ;
lin lukuisasti_Adv = mkkAdv "lukuisasti" ;
--? lin lukuset_NK = {s = d38 "lukuset" ;
lin lukuun_ottamatta_Adv = mkkAdv "lukuuC" ;
lin lulla_N = mkkN "lulla" ;
lin lullukka_N = mkkN "lullukka" ;
lin lume_N = mkkN "lume" ;
lin lumen_N = mkkN "lumen" ;
lin lumeta_V = mkkV "lumeta" ;
lin lumettaa_V = mkkV "lumettaa" ;
lin lumettua_V = mkkV "lumettua" ;
lin lumetus_N = mkkN "lumetus" ;
lin lumeutua_V = mkkV "lumeutua" ;
lin lumi_N = mkkN "lumi" ;
lin lumikko_N = mkkN "lumikko" ;
lin luminanssi_N = mkkN "luminanssi" ;
lin luminen_N = mkkN "luminen" ;
lin luminesenssi_N = mkkN "luminesenssi" ;
lin lumittaa_V = mkkV "lumittaa" ;
lin lumme_N = mkkN "lumme" ;
lin lumo_N = mkkN "lumo" ;
lin lumoava_N = mkkN "lumoava" ;
lin lumoojatar_N = mkkN "lumoojatar" ;
lin lumota_V = mkkV "lumota" ;
lin lumous_N = mkkN "lumous" ;
lin lumoutua_V = mkkV "lumoutua" ;
lin lumpeikko_N = mkkN "lumpeikko" ;
lin lumpio_N = mkkN "lumpio" ;
lin lumppari_N = mkkN "lumppari" ;
lin lumppu_N = mkkN "lumppu" ;
lin lumpsahtaa_V = mkkV "lumpsahtaa" ;
lin lumpsauttaa_V = mkkV "lumpsauttaa" ;
lin lunastaa_V = mkkV "lunastaa" ;
lin lunastaja_N = mkkN "lunastaja" ;
lin lunastus_N = mkkN "lunastus" ;
lin lunki_A = mkkA "lunki" ;
lin lunkisti_Adv = mkkAdv "lunkisti" ;
--? lin lunnaat_NK = {s = d41 "lunnaat" ;
lin lunni_N = mkkN "lunni" ;
lin luntata_V = mkkV "luntata" ;
lin luntta_N = mkkN "luntta" ;
lin lunttaus_N = mkkN "lunttaus" ;
lin luntti_N = mkkN "luntti" ;
lin lunttu_1_N = mkkN "lunttu" ;
lin lunttu_2_N = mkkN "lunttu" ;
lin luo_Adv = mkkAdv "luo" ;
lin luoda_V = mkkV "luoda" ;
lin luodata_V = mkkV "luodata" ;
lin luode_1_N = mkkN "luode" ;
lin luode_2_N = mkkN "luode" ;
lin luodikko_N = mkkN "luodikko" ;
lin luoja_N = mkkN "luoja" ;
lin luokallinen_N = mkkN "luokallinen" ;
lin luokaton_N = mkkN "luokaton" ;
lin luokattomuus_N = mkkN "luokattomuus" ;
lin luokitella_V = mkkV "luokitella" ;
lin luokittaa_V = mkkV "luokittaa" ;
lin luokittelu_N = mkkN "luokittelu" ;
lin luokittua_V = mkkV "luokittua" ;
lin luokitus_N = mkkN "luokitus" ;
lin luokka_1_N = mkkN "luokka" ;
lin luokka_2_N = mkkN "luokka" ;
lin luokkainen_N = mkkN "luokkainen" ;
lin luokkaisuus_N = mkkN "luokkaisuus" ;
lin luokki_N = mkkN "luokki" ;
lin luoko_N = mkkN "luoko" ;
lin luokse_Adv = mkkAdv "luokse" ;
lin luola_N = mkkN "luola" ;
lin luolasto_N = mkkN "luolasto" ;
lin luoma_N = mkkN "luoma" ;
lin luomi_1_N = mkkN "luomi" ;
lin luomi_2_N = mkkN "luomi" ;
lin luomus_N = mkkN "luomus" ;
lin luona_Adv = mkkAdv "luona" ;
lin luonne_N = mkkN "luonne" ;
lin luonnehdinta_N = mkkN "luonnehdinta" ;
lin luonnehtia_V = mkkV "luonnehtia" ;
lin luonnikas_A = mkkA "luonnikas" ;
lin luonnikkaasti_Adv = mkkAdv "luonnikkaasti" ;
lin luonnikkuus_N = mkkN "luonnikkuus" ;
lin luonnistaa_V = mkkV "luonnistaa" ;
lin luonnistua_V = mkkV "luonnistua" ;
lin luonnollinen_A = mkkA "luonnollinen" ;
lin luonnollisesti_Adv = mkkAdv "luonnollisesti" ;
lin luonnollisuus_N = mkkN "luonnollisuus" ;
lin luonnonlaki_N = mkkN "luonnonlaki" ;
lin luonnontilainen_N = mkkN "luonnontilainen" ;
lin luonnos_N = mkkN "luonnos" ;
lin luonnostaan_Adv = mkkAdv "luonnostaan" ;
lin luonnostella_V = mkkV "luonnostella" ;
lin luonnostelu_N = mkkN "luonnostelu" ;
lin luonnoton_N = mkkN "luonnoton" ;
lin luonnottomasti_Adv = mkkAdv "luonnottomasti" ;
lin luonnottomuus_N = mkkN "luonnottomuus" ;
lin luonnuttaa_V = mkkV "luonnuttaa" ;
lin luontainen_A = mkkA "luontainen" ;
lin luontaisesti_Adv = mkkAdv "luontaisesti" ;
lin luonteenomaisesti_Adv = mkkAdv "luonteenomaisesti" ;
lin luonteenomaisuus_N = mkkN "luonteenomaisuus" ;
lin luonteeton_N = mkkN "luonteeton" ;
lin luonteettomuus_N = mkkN "luonteettomuus" ;
lin luonteikas_N = mkkN "luonteikas" ;
lin luonteinen_A = mkkA "luonteinen" ;
lin luonteisesti_Adv = mkkAdv "luonteisesti" ;
lin luonteisuus_N = mkkN "luonteisuus" ;
lin luonteva_A = mkkA "luonteva" ;
lin luontevasti_Adv = mkkAdv "luontevasti" ;
lin luontevuus_N = mkkN "luontevuus" ;
lin luonti_N = mkkN "luonti" ;
lin luonto_N = mkkN "luonto" ;
lin luontoinen_N = mkkN "luontoinen" ;
lin luontoisuus_N = mkkN "luontoisuus" ;
lin luontojaan_Adv = mkkAdv "luontojaan" ;
lin luontua_V = mkkV "luontua" ;
lin luopio_N = mkkN "luopio" ;
lin luopua_V = mkkV "luopua" ;
lin luopumus_N = mkkN "luopumus" ;
lin luostari_N = mkkN "luostari" ;
lin luota_Adv = mkkAdv "luota" ;
lin luotaantyo'nta'va'_A = mkkA "luotaantyöntävä" ;
lin luotaantyo'nta'va'sti_Adv = mkkAdv "luotaantyöntävästi" ;
lin luotella_V = mkkV "luotella" ;
lin luotettava_A = mkkA "luotettava" ;
lin luotettavasti_Adv = mkkAdv "luotettavasti" ;
lin luotettavuus_N = mkkN "luotettavuus" ;
lin luotettu_N = mkkN "luotettu" ;
lin luoti_N = mkkN "luoti" ;
lin luoto_N = mkkN "luoto" ;
lin luotollinen_N = mkkN "luotollinen" ;
lin luotottaa_V = mkkV "luotottaa" ;
lin luotottaja_N = mkkN "luotottaja" ;
lin luototus_N = mkkN "luototus" ;
lin luotsailla_V = mkkV "luotsailla" ;
lin luotsata_V = mkkV "luotsata" ;
lin luotsaus_N = mkkN "luotsaus" ;
lin luotsi_N = mkkN "luotsi" ;
lin luotta_N = mkkN "luotta" ;
lin luottaa_V = mkkV "luottaa" ;
lin luottamuksellinen_A = mkkA "luottamuksellinen" ;
lin luottamuksellisesti_Adv = mkkAdv "luottamuksellisesti" ;
lin luottamuksellisuus_N = mkkN "luottamuksellisuus" ;
lin luottamus_N = mkkN "luottamus" ;
lin luottavainen_A = mkkA "luottavainen" ;
lin luottavaisesti_Adv = mkkAdv "luottavaisesti" ;
lin luottelu_N = mkkN "luottelu" ;
lin luotti_N = mkkN "luotti" ;
lin luotto_N = mkkN "luotto" ;
lin luova_A = mkkA "luova" ;
lin luovasti_Adv = mkkAdv "luovasti" ;
lin luovi_N = mkkN "luovi" ;
lin luovia_V = mkkV "luovia" ;
lin luovuttaa_V = mkkV "luovuttaa" ;
lin luovuttaja_N = mkkN "luovuttaja" ;
lin luovuttamaton_N = mkkN "luovuttamaton" ;
lin luovutus_N = mkkN "luovutus" ;
lin luovuus_N = mkkN "luovuus" ;
lin lupa_N = mkkN "lupa" ;
lin lupaava_A = mkkA "lupaava" ;
lin lupaavasti_Adv = mkkAdv "lupaavasti" ;
lin lupailla_V = mkkV "lupailla" ;
lin lupaus_N = mkkN "lupaus" ;
lin lupautua_V = mkkV "lupautua" ;
lin lupiini_N = mkkN "lupiini" ;
lin luppi_N = mkkN "luppi" ;
lin luppo_N = mkkN "luppo" ;
lin luppoaika_N = mkkN "luppoaika" ;
lin lupsahdella_V = mkkV "lupsahdella" ;
lin lupsahtaa_V = mkkV "lupsahtaa" ;
lin lupsakas_A = mkkA "lupsakas" ;
lin lupsakasti_Adv = mkkAdv "lupsakasti" ;
lin lupsakka_N = mkkN "lupsakka" ;
lin lupsakkaasti_Adv = mkkAdv "lupsakkaasti" ;
lin lupsakkuus_N = mkkN "lupsakkuus" ;
lin lurahtaa_V = mkkV "lurahtaa" ;
lin luraus_N = mkkN "luraus" ;
lin lurauttaa_V = mkkV "lurauttaa" ;
lin luritella_V = mkkV "luritella" ;
lin lurittaa_V = mkkV "lurittaa" ;
lin luritus_N = mkkN "luritus" ;
lin lurjus_N = mkkN "lurjus" ;
lin lurjusmaisesti_Adv = mkkAdv "lurjusmaisesti" ;
lin lurjustella_V = mkkV "lurjustella" ;
lin lurpalla_Adv = mkkAdv "lurpalla" ;
lin lurpallaan_Adv = mkkAdv "lurpallaan" ;
lin lurpalle_Adv = mkkAdv "lurpalle" ;
lin lurpalleen_Adv = mkkAdv "lurpalleen" ;
lin lurpassa_Adv = mkkAdv "lurpassa" ;
lin lurppaan_Adv = mkkAdv "lurppaan" ;
lin luserni_N = mkkN "luserni" ;
lin lusia_V = mkkV "lusia" ;
lin lusikallinen_N = mkkN "lusikallinen" ;
lin lusikka_N = mkkN "lusikka" ;
lin lusikoida_V = mkkV "lusikoida" ;
lin lusmuilija_N = mkkN "lusmuilija" ;
lin luste_N = mkkN "luste" ;
lin lusto_N = mkkN "lusto" ;
lin luterilainen_N = mkkN "luterilainen" ;
lin luterilaisuus_N = mkkN "luterilaisuus" ;
lin luti_N = mkkN "luti" ;
lin lutikka_N = mkkN "lutikka" ;
lin lutka_N = mkkN "lutka" ;
lin lutkuttaa_V = mkkV "lutkuttaa" ;
lin lutkutus_N = mkkN "lutkutus" ;
lin lutukka_N = mkkN "lutukka" ;
lin lutunen_N = mkkN "lutunen" ;
lin lutviutua_V = mkkV "lutviutua" ;
lin luu_N = mkkN "luu" ;
lin luudas_N = mkkN "luudas" ;
lin luuhata_V = mkkV "luuhata" ;
lin luukku_N = mkkN "luukku" ;
lin luukkuunkanto_N = mkkN "luukkuunkanto" ;
lin luukuttaa_V = mkkV "luukuttaa" ;
lin luulla_V = mkkV "luulla" ;
lin luulo_N = mkkN "luulo" ;
lin luuloisuus_N = mkkN "luuloisuus" ;
lin luulotella_V = mkkV "luulotella" ;
lin luulottelu_N = mkkN "luulottelu" ;
lin luultava_A = mkkA "luultava" ;
lin luultavasti_Adv = mkkAdv "luultavasti" ;
lin luumen_N = mkkN "luumen" ;
lin luumu_N = mkkN "luumu" ;
lin luuppi_N = mkkN "luuppi" ;
lin luurata_V = mkkV "luurata" ;
lin luuri_N = mkkN "luuri" ;
lin luuseri_N = mkkN "luuseri" ;
lin luuska_N = mkkN "luuska" ;
lin luusto_N = mkkN "luusto" ;
lin luustoinen_N = mkkN "luustoinen" ;
lin luuta_N = mkkN "luuta" ;
lin luutia_V = mkkV "luutia" ;
lin luutnantti_N = mkkN "luutnantti" ;
lin luuton_N = mkkN "luuton" ;
lin luuttu_1_N = mkkN "luuttu" ;
lin luuttu_2_N = mkkN "luuttu" ;
lin luutua_V = mkkV "luutua" ;
lin luutuneisuus_N = mkkN "luutuneisuus" ;
lin luututa_V = mkkV "luututa" ;
lin luvallinen_A = mkkA "luvallinen" ;
lin luvallisesti_Adv = mkkAdv "luvallisesti" ;
lin luvallistaa_V = mkkV "luvallistaa" ;
lin luvallisuus_N = mkkN "luvallisuus" ;
lin luvanvaraistaa_V = mkkV "luvanvaraistaa" ;
lin luvata_V = mkkV "luvata" ;
lin luvaton_N = mkkN "luvaton" ;
lin luvattomasti_Adv = mkkAdv "luvattomasti" ;
lin luvattomuus_N = mkkN "luvattomuus" ;
lin luvuton_N = mkkN "luvuton" ;
lin luvuttomasti_Adv = mkkAdv "luvuttomasti" ;
lin lux_N = mkkN "lux" ;
lin lyhde_N = mkkN "lyhde" ;
lin lyhenema'_N = mkkN "lyhenemä" ;
lin lyhenne_N = mkkN "lyhenne" ;
lin lyhennella'_V = mkkV "lyhennellä" ;
lin lyhennelma'_N = mkkN "lyhennelmä" ;
lin lyhennys_N = mkkN "lyhennys" ;
lin lyhentyma'_N = mkkN "lyhentymä" ;
lin lyhentya'_V = mkkV "lyhentyä" ;
lin lyhenta'ma'to'n_N = mkkN "lyhentämätön" ;
lin lyhenta'a'_V = mkkV "lyhentää" ;
lin lyheta'_V = mkkV "lyhetä" ;
lin LYHKI_N = mkkN "LYHKI" ;
lin lyhka'inen_N = mkkN "lyhkäinen" ;
lin lyhty_N = mkkN "lyhty" ;
lin lyhyeen_Adv = mkkAdv "lyhyeen" ;
lin lyhyelle_Adv = mkkAdv "lyhyelle" ;
lin lyhyella'_Adv = mkkAdv "lyhyellä" ;
lin lyhyelti_Adv = mkkAdv "lyhyelti" ;
lin lyhyenla'nta'_N = mkkN "lyhyenläntä" ;
lin lyhyesti_Adv = mkkAdv "lyhyesti" ;
lin lyhyka'inen_A = mkkA "lyhykäinen" ;
lin lyhyka'isesti_Adv = mkkAdv "lyhykäisesti" ;
lin lyhyka'isyys_N = mkkN "lyhykäisyys" ;
lin lyhyt_N = mkkN "lyhyt" ;
lin lyhytja'nnitteisesti_Adv = mkkAdv "lyhytjännitteisesti" ;
lin lyhytja'nteisesti_Adv = mkkAdv "lyhytjänteisesti" ;
lin lyhytna'ko'isesti_Adv = mkkAdv "lyhytnäköisesti" ;
lin lyhytsanaisesti_Adv = mkkAdv "lyhytsanaisesti" ;
lin lyhyys_N = mkkN "lyhyys" ;
lin lyijy_N = mkkN "lyijy" ;
lin lyijyke_N = mkkN "lyijyke" ;
lin lyijytta'a'_V = mkkV "lyijyttää" ;
lin lyijyta'_V = mkkV "lyijytä" ;
lin lyijyto'n_N = mkkN "lyijytön" ;
lin lykkia'_V = mkkV "lykkiä" ;
lin lykky_N = mkkN "lykky" ;
lin lykka'ys_N = mkkN "lykkäys" ;
lin lykka'ytya'_V = mkkV "lykkäytyä" ;
lin lykka'a'ntya'_V = mkkV "lykkääntyä" ;
lin lyka'sta'a'_V = mkkV "lykästää" ;
lin lyka'ta'_V = mkkV "lykätä" ;
lin lyllerta'a'_V = mkkV "lyllertää" ;
lin lyllero'_N = mkkN "lyllerö" ;
lin lyllya'_V = mkkV "lyllyä" ;
lin lyly_N = mkkN "lyly" ;
lin lylynlykkija'_N = mkkN "lylynlykkijä" ;
lin lymfa_N = mkkN "lymfa" ;
lin lymfaattinen_N = mkkN "lymfaattinen" ;
lin lymfooma_N = mkkN "lymfooma" ;
lin lymfosyytti_N = mkkN "lymfosyytti" ;
lin lymyilla'_V = mkkV "lymyillä" ;
lin lymyta'_V = mkkV "lymytä" ;
lin lynkata_V = mkkV "lynkata" ;
lin lynkkaus_N = mkkN "lynkkaus" ;
lin lypsy_N = mkkN "lypsy" ;
lin lypsyinen_N = mkkN "lypsyinen" ;
lin lypsa'ja'_N = mkkN "lypsäjä" ;
lin lypsa'tta'a'_V = mkkV "lypsättää" ;
lin lypsa'tys_N = mkkN "lypsätys" ;
lin lypsa'a'_V = mkkV "lypsää" ;
lin lyriikka_N = mkkN "lyriikka" ;
lin lyseo_N = mkkN "lyseo" ;
lin lysoli_N = mkkN "lysoli" ;
lin lysteri_N = mkkN "lysteri" ;
lin lysti_N = mkkN "lysti" ;
lin lystikkyys_N = mkkN "lystikkyys" ;
lin lystikka'a'sti_Adv = mkkAdv "lystikkäästi" ;
lin lystika's_A = mkkA "lystikäs" ;
lin lysta'ta'_V = mkkV "lystätä" ;
lin lysyssa'_Adv = mkkAdv "lysyssä" ;
lin lysyyn_Adv = mkkAdv "lysyyn" ;
lin lysa'hta'a'_V = mkkV "lysähtää" ;
lin lytista'a'_V = mkkV "lytistää" ;
lin lyttyyn_Adv = mkkAdv "lyttyyn" ;
lin lytyssa'_Adv = mkkAdv "lytyssä" ;
lin lyydi_N = mkkN "lyydi" ;
lin lyydila'inen_N = mkkN "lyydiläinen" ;
lin lyyhistya'_V = mkkV "lyyhistyä" ;
lin lyyhista'a'_V = mkkV "lyyhistää" ;
lin lyykistya'_V = mkkV "lyykistyä" ;
lin lyykista'a'_V = mkkV "lyykistää" ;
lin lyyka'hta'a'_V = mkkV "lyykähtää" ;
lin lyyra_N = mkkN "lyyra" ;
lin lyyrikko_N = mkkN "lyyrikko" ;
lin lyyrinen_A = mkkA "lyyrinen" ;
lin lyyrisesti_Adv = mkkAdv "lyyrisesti" ;
lin lyyrisyys_N = mkkN "lyyrisyys" ;
lin lyo'da'_V = mkkV "lyödä" ;
lin lyo'ja'_N = mkkN "lyöjä" ;
lin lyo'ma'to'n_N = mkkN "lyömätön" ;
lin lyo'nti_N = mkkN "lyönti" ;
lin lyo'ntinen_N = mkkN "lyöntinen" ;
lin lyo'ttyma'_N = mkkN "lyöttymä" ;
lin lyo'ttya'_V = mkkV "lyöttyä" ;
lin lyo'tta'ytya'_V = mkkV "lyöttäytyä" ;
lin lyo'tta'a'_V = mkkV "lyöttää" ;
lin lyo'ta'tta'a'_V = mkkV "lyötättää" ;
lin la'hde_N = mkkN "lähde" ;
lin la'hdetta'a'_V = mkkV "lähdettää" ;
lin la'hdetys_N = mkkN "lähdetys" ;
lin la'heinen_A = mkkA "läheinen" ;
lin la'heisesti_Adv = mkkAdv "läheisesti" ;
lin la'heisyys_N = mkkN "läheisyys" ;
lin la'hekka'in_Adv = mkkAdv "lähekkäin" ;
lin la'hekka'inen_N = mkkN "lähekkäinen" ;
lin la'hekka'isyys_N = mkkN "lähekkäisyys" ;
lin la'helle_Adv = mkkAdv "lähelle" ;
lin la'hella'_Adv = mkkAdv "lähellä" ;
lin la'helta'_Adv = mkkAdv "läheltä" ;
lin la'hemmin_Adv = mkkAdv "lähemmin" ;
lin la'hemma'_Adv = mkkAdv "lähemmä" ;
lin la'hemma'ksi_Adv = mkkAdv "lähemmäksi" ;
lin la'hemma's_Adv = mkkAdv "lähemmäs" ;
lin la'hempi_N = mkkN "lähempi" ;
lin la'hempa'na'_Adv = mkkAdv "lähempänä" ;
lin la'hempa'a'_Adv = mkkAdv "lähempää" ;
lin la'hennella'_V = mkkV "lähennellä" ;
lin la'hentely_N = mkkN "lähentely" ;
lin la'hentya'_V = mkkV "lähentyä" ;
lin la'henta'ja'_N = mkkN "lähentäjä" ;
lin la'henta'a'_V = mkkV "lähentää" ;
lin la'hes_Adv = mkkAdv "lähes" ;
lin la'heska'a'n_Adv = mkkAdv "läheskään" ;
lin la'hestulkoon_Adv = mkkAdv "lähestulkoon" ;
lin la'hestulkoonkaan_Adv = mkkAdv "lähestulkoonkaan" ;
lin la'hestya'_V = mkkV "lähestyä" ;
lin la'hete_N = mkkN "lähete" ;
lin la'hetella'_V = mkkV "lähetellä" ;
lin la'hetin_N = mkkN "lähetin" ;
lin la'hetti_N = mkkN "lähetti" ;
lin la'hettila's_N = mkkN "lähettiläs" ;
lin la'hettyville_Adv = mkkAdv "lähettyville" ;
lin la'hettyvilla'_Adv = mkkAdv "lähettyvillä" ;
lin la'hettyvilta'_Adv = mkkAdv "lähettyviltä" ;
lin la'hetta'ja'_N = mkkN "lähettäjä" ;
lin la'hetta'mo'_N = mkkN "lähettämö" ;
lin la'hetta'a'_V = mkkV "lähettää" ;
lin la'hetys_N = mkkN "lähetys" ;
lin la'hetysaika_N = mkkN "lähetysaika" ;
lin la'hetysten_Adv = mkkAdv "lähetysten" ;
lin la'hetysto'_N = mkkN "lähetystö" ;
lin la'heta'_V = mkkV "lähetä" ;
lin la'hiaika_N = mkkN "lähiaika" ;
lin la'himailla_Adv = mkkAdv "lähimailla" ;
lin la'himaille_Adv = mkkAdv "lähimaille" ;
lin la'himailta_Adv = mkkAdv "lähimailta" ;
lin la'himain_Adv = mkkAdv "lähimain" ;
lin la'himainkaan_Adv = mkkAdv "lähimainkaan" ;
lin la'himmin_Adv = mkkAdv "lähimmin" ;
lin la'himma'inen_N = mkkN "lähimmäinen" ;
lin la'himma'ksi_Adv = mkkAdv "lähimmäksi" ;
lin la'himma's_Adv = mkkAdv "lähimmäs" ;
lin la'himpa'na'_Adv = mkkAdv "lähimpänä" ;
lin la'himpa'a'_Adv = mkkAdv "lähimpää" ;
lin la'hin_1_N = mkkN "lähin" ;
lin la'hin_2_Adv = mkkAdv "lähin" ;
lin la'hinna'_Adv = mkkAdv "lähinnä" ;
lin la'histo'_N = mkkN "lähistö" ;
lin la'hio'_N = mkkN "lähiö" ;
lin la'hio'asuminen_N = mkkN "lähiöasuminen" ;
lin la'htema'tto'ma'sti_Adv = mkkAdv "lähtemättömästi" ;
lin la'htema'to'n_N = mkkN "lähtemätön" ;
lin la'htea'_V = mkkV "lähteä" ;
lin la'htien_Adv = mkkAdv "lähtien" ;
lin la'htija'_N = mkkN "lähtijä" ;
--? lin la'htia'iset_NK = {s = d38 "lähtiäiset" ;
lin la'hto'_N = mkkN "lähtö" ;
lin la'hto'aika_N = mkkN "lähtöaika" ;
lin la'hto'inen_N = mkkN "lähtöinen" ;
lin la'hto'isin_Adv = mkkAdv "lähtöisin" ;
lin la'hto'kohta_N = mkkN "lähtökohta" ;
lin la'ike_N = mkkN "läike" ;
lin la'ikehtia'_V = mkkV "läikehtiä" ;
lin la'ikika's_N = mkkN "läikikäs" ;
lin la'ikkya'_V = mkkV "läikkyä" ;
lin la'ikka'_N = mkkN "läikkä" ;
lin la'ikka'inen_N = mkkN "läikkäinen" ;
lin la'ikynta'_N = mkkN "läikyntä" ;
lin la'ikytta'a'_V = mkkV "läikyttää" ;
lin la'ikytys_N = mkkN "läikytys" ;
lin la'ika'hdella'_V = mkkV "läikähdellä" ;
lin la'ika'hdys_N = mkkN "läikähdys" ;
lin la'ika'hta'a'_V = mkkV "läikähtää" ;
lin la'ika'ytta'a'_V = mkkV "läikäyttää" ;
lin la'imia'_V = mkkV "läimiä" ;
lin la'ima'hdella'_V = mkkV "läimähdellä" ;
lin la'ima'hdys_N = mkkN "läimähdys" ;
lin la'ima'hta'a'_V = mkkV "läimähtää" ;
lin la'ima'ista'_V = mkkV "läimäistä" ;
lin la'ima'isy_N = mkkN "läimäisy" ;
lin la'ima'ta'_V = mkkV "läimätä" ;
lin la'ima'ys_N = mkkN "läimäys" ;
lin la'ima'ytella'_V = mkkV "läimäytellä" ;
lin la'ima'ytta'a'_V = mkkV "läimäyttää" ;
lin la'iske_N = mkkN "läiske" ;
lin la'iskika's_N = mkkN "läiskikäs" ;
lin la'iskinta'_N = mkkN "läiskintä" ;
lin la'iskina'_N = mkkN "läiskinä" ;
lin la'iskia'_V = mkkV "läiskiä" ;
lin la'iskytella'_V = mkkV "läiskytellä" ;
lin la'iskytta'a'_V = mkkV "läiskyttää" ;
lin la'iskytys_N = mkkN "läiskytys" ;
lin la'iskya'_V = mkkV "läiskyä" ;
lin la'iska'_N = mkkN "läiskä" ;
lin la'iska'hdella'_V = mkkV "läiskähdellä" ;
lin la'iska'hdys_N = mkkN "läiskähdys" ;
lin la'iska'htely_N = mkkN "läiskähtely" ;
lin la'iska'hta'a'_V = mkkV "läiskähtää" ;
lin la'iska'inen_N = mkkN "läiskäinen" ;
lin la'iska'ista'_V = mkkV "läiskäistä" ;
lin la'iska'ys_N = mkkN "läiskäys" ;
lin la'iska'ytella'_V = mkkV "läiskäytellä" ;
lin la'iska'ytta'a'_V = mkkV "läiskäyttää" ;
lin la'jitta'in_Adv = mkkAdv "läjittäin" ;
lin la'jitta'a'_V = mkkV "läjittää" ;
lin la'jitys_N = mkkN "läjitys" ;
lin la'ja'_N = mkkN "läjä" ;
lin la'ja'hdella'_V = mkkV "läjähdellä" ;
lin la'ja'hdys_N = mkkN "läjähdys" ;
lin la'ja'hta'a'_V = mkkV "läjähtää" ;
lin la'ja'pa'issa'_Adv = mkkAdv "läjäpäissä" ;
lin la'ja'ta'_V = mkkV "läjätä" ;
lin la'ja'ys_1_N = mkkN "läjäys" ;
lin la'ja'ys_2_N = mkkN "läjäys" ;
lin la'ja'ytta'a'_V = mkkV "läjäyttää" ;
lin la'kki_N = mkkN "läkki" ;
--? lin la'ksia'iset_NK = {s = d38 "läksiäiset" ;
lin la'ksy_N = mkkN "läksy" ;
lin la'ksytta'a'_V = mkkV "läksyttää" ;
lin la'ksytys_N = mkkN "läksytys" ;
lin la'ka'hdyksiin_Adv = mkkAdv "läkähdyksiin" ;
lin la'ka'hdyksissa'_Adv = mkkAdv "läkähdyksissä" ;
lin la'ka'hdyksissa'a'n_Adv = mkkAdv "läkähdyksissään" ;
lin la'ka'hdytta'a'_V = mkkV "läkähdyttää" ;
lin la'ka'htya'_V = mkkV "läkähtyä" ;
lin la'lly_N = mkkN "lälly" ;
lin la'lla'ri_N = mkkN "lälläri" ;
lin la'mmeta'_V = mkkV "lämmetä" ;
lin la'mmike_N = mkkN "lämmike" ;
lin la'mmin_N = mkkN "lämmin" ;
lin la'mmitella'_V = mkkV "lämmitellä" ;
lin la'mmitin_N = mkkN "lämmitin" ;
lin la'mmitteinen_N = mkkN "lämmitteinen" ;
lin la'mmittely_N = mkkN "lämmittely" ;
lin la'mmitta'ja'_N = mkkN "lämmittäjä" ;
lin la'mmitta'a'_V = mkkV "lämmittää" ;
lin la'mmitys_N = mkkN "lämmitys" ;
lin la'mmita'_V = mkkV "lämmitä" ;
lin la'mpimikseen_Adv = mkkAdv "lämpimikseen" ;
lin la'mpimilta'a'n_Adv = mkkAdv "lämpimiltään" ;
lin la'mpimyys_N = mkkN "lämpimyys" ;
lin la'mpima'inen_N = mkkN "lämpimäinen" ;
lin la'mpima'lta'a'n_Adv = mkkAdv "lämpimältään" ;
lin la'mpima'sti_Adv = mkkAdv "lämpimästi" ;
lin la'mpio'_N = mkkN "lämpiö" ;
lin la'mpa're_N = mkkN "lämpäre" ;
lin la'mpo'_N = mkkN "lämpö" ;
lin la'mpo'inen_A = mkkA "lämpöinen" ;
lin la'mpo'isesti_Adv = mkkAdv "lämpöisesti" ;
lin la'mpo'laajeneminen_N = mkkN "lämpölaajeneminen" ;
lin la'mpo'laajenemiskerroin_N = mkkN "lämpölaajenemiskerroin" ;
lin la'mpo'tilakerroin_N = mkkN "lämpötilakerroin" ;
lin la'ma'ri_N = mkkN "lämäri" ;
lin la'ma'ta'_V = mkkV "lämätä" ;
--? lin la'nget_NK = {s = d07A "länget" ;
lin la'nkka'ri_N = mkkN "länkkäri" ;
lin la'nnemma'ksi_Adv = mkkAdv "lännemmäksi" ;
lin la'nnemma's_Adv = mkkAdv "lännemmäs" ;
lin la'nnempa'na'_Adv = mkkAdv "lännempänä" ;
lin la'nnempa'a'_Adv = mkkAdv "lännempää" ;
lin la'nnettya'_V = mkkV "lännettyä" ;
lin la'nsi_N = mkkN "länsi" ;
lin la'nsimaisesti_Adv = mkkAdv "länsimaisesti" ;
lin la'nsimaistua_V = mkkV "länsimaistua" ;
lin la'nsimaisuus_N = mkkN "länsimaisuus" ;
lin la'ntinen_N = mkkN "läntinen" ;
lin la'ntistya'_V = mkkV "läntistyä" ;
lin la'ntti_N = mkkN "läntti" ;
lin la'ntta'a'n_Adv = mkkAdv "länttään" ;
lin la'nta'lleen_Adv = mkkAdv "läntälleen" ;
lin la'nta'lla'a'n_Adv = mkkAdv "läntällään" ;
lin la'nta'ssa'_Adv = mkkAdv "läntässä" ;
lin la'nta'ta'_V = mkkV "läntätä" ;
lin la'peensa'_Adv = mkkAdv "läpeensä" ;
lin la'pi_1_Adv = mkkAdv "läpi" ;
lin la'pi_2_N = mkkN "läpi" ;
lin la'pikotainen_A = mkkA "läpikotainen" ;
lin la'pikotaisesti_Adv = mkkAdv "läpikotaisesti" ;
lin la'pikotaisin_Adv = mkkAdv "läpikotaisin" ;
lin la'pikuultamaton_N = mkkN "läpikuultamaton" ;
lin la'pikuultamattomuus_N = mkkN "läpikuultamattomuus" ;
lin la'pisa'velletty_N = mkkN "läpisävelletty" ;
lin la'pitunkema_N = mkkN "läpitunkema" ;
lin la'pitunkematon_N = mkkN "läpitunkematon" ;
lin la'pitunkeva_A = mkkA "läpitunkeva" ;
lin la'pitunkevasti_Adv = mkkAdv "läpitunkevasti" ;
lin la'pivientikohta_N = mkkN "läpivientikohta" ;
lin la'ppa'_1_N = mkkN "läppä" ;
lin la'ppa'_2_N = mkkN "läppä" ;
lin la'ppa'_3_N = mkkN "läppä" ;
lin la'pse_N = mkkN "läpse" ;
lin la'psia'_V = mkkV "läpsiä" ;
lin la'psytella'_V = mkkV "läpsytellä" ;
lin la'psytta'a'_V = mkkV "läpsyttää" ;
lin la'psytys_N = mkkN "läpsytys" ;
lin la'psya'_V = mkkV "läpsyä" ;
lin la'psa'hdella'_V = mkkV "läpsähdellä" ;
lin la'psa'hdys_N = mkkN "läpsähdys" ;
lin la'psa'hta'a'_V = mkkV "läpsähtää" ;
lin la'psa'ys_N = mkkN "läpsäys" ;
lin la'psa'ytta'a'_V = mkkV "läpsäyttää" ;
lin la'psa'ytys_N = mkkN "läpsäytys" ;
lin la'psa'a'_V = mkkV "läpsää" ;
lin la'pyska'_N = mkkN "läpyskä" ;
lin la'pytta'a'_V = mkkV "läpyttää" ;
lin la'pytys_N = mkkN "läpytys" ;
lin la'pa'isema'tto'myys_N = mkkN "läpäisemättömyys" ;
lin la'pa'isema'to'n_N = mkkN "läpäisemätön" ;
lin la'pa'isevyys_N = mkkN "läpäisevyys" ;
lin la'pa'ista'_V = mkkV "läpäistä" ;
lin la'pa'isy_N = mkkN "läpäisy" ;
lin la'pa'llinen_N = mkkN "läpällinen" ;
lin la'pa'tta'a'_V = mkkV "läpättää" ;
lin la'pa'tys_N = mkkN "läpätys" ;
lin la'pa'ytta'a'_V = mkkV "läpäyttää" ;
lin la'rvi_N = mkkN "lärvi" ;
lin la'si_N = mkkN "läsi" ;
lin la'sia'_V = mkkV "läsiä" ;
lin la'ski_N = mkkN "läski" ;
lin la'skimooses_N = mkkN "läskimooses" ;
lin la'skinen_N = mkkN "läskinen" ;
lin la'sna'_Adv = mkkAdv "läsnä" ;
lin la'ssy_N = mkkN "lässy" ;
lin la'ssytta'ja'_N = mkkN "lässyttäjä" ;
lin la'ssytta'a'_V = mkkV "lässyttää" ;
lin la'ssytys_N = mkkN "lässytys" ;
lin la'ssa'hta'a'_V = mkkV "lässähtää" ;
lin la'tina'_N = mkkN "lätinä" ;
lin la'tista'_V = mkkV "lätistä" ;
lin la'tkinta'_N = mkkN "lätkintä" ;
lin la'tkia'_V = mkkV "lätkiä" ;
lin la'tka'_N = mkkN "lätkä" ;
lin la'tka'ista'_V = mkkV "lätkäistä" ;
lin la'tka'ytta'a'_V = mkkV "lätkäyttää" ;
lin la'tra'ta'_V = mkkV "läträtä" ;
lin la'tsa'_N = mkkN "lätsä" ;
lin la'tsa'hdys_N = mkkN "lätsähdys" ;
lin la'tsa'hta'a'_V = mkkV "lätsähtää" ;
lin la'tti_1_N = mkkN "lätti" ;
lin la'tti_2_N = mkkN "lätti" ;
lin la'ttila'inen_N = mkkN "lättiläinen" ;
lin la'tty_N = mkkN "lätty" ;
lin la'tta'na'_N = mkkN "lättänä" ;
lin la'ta'kko'_N = mkkN "lätäkkö" ;
lin la'ta'kko'inen_N = mkkN "lätäkköinen" ;
lin la'vikko'_N = mkkN "lävikkö" ;
lin la'viste_N = mkkN "läviste" ;
lin la'vistin_N = mkkN "lävistin" ;
lin la'vistys_N = mkkN "lävistys" ;
lin la'vista'ja'_N = mkkN "lävistäjä" ;
lin la'vista'a'_V = mkkV "lävistää" ;
lin la'vitse_Adv = mkkAdv "lävitse" ;
lin la'va'hta'a'_V = mkkV "lävähtää" ;
lin la'va'ytta'a'_V = mkkV "läväyttää" ;
lin la'a'ha'tta'a'_V = mkkV "läähättää" ;
lin la'a'ha'tys_N = mkkN "läähätys" ;
lin la'a'ke_N = mkkN "lääke" ;
lin la'a'kinna'llinen_N = mkkN "lääkinnällinen" ;
lin la'a'kinta'_N = mkkN "lääkintä" ;
lin la'a'kitys_N = mkkN "lääkitys" ;
lin la'a'kita'_V = mkkV "lääkitä" ;
lin la'a'kkeellinen_N = mkkN "lääkkeellinen" ;
lin la'a'ka'ri_N = mkkN "lääkäri" ;
lin la'a'neitta'in_Adv = mkkAdv "lääneittäin" ;
lin la'a'ni_N = mkkN "lääni" ;
lin la'a'ninraja_N = mkkN "lääninraja" ;
lin la'a'nitta'a'_V = mkkV "läänittää" ;
lin la'a'nitys_N = mkkN "läänitys" ;
lin la'a'ppia'_V = mkkV "lääppiä" ;
lin la'a'pa'lleen_Adv = mkkAdv "lääpälleen" ;
lin la'a'pa'lla'a'n_Adv = mkkAdv "lääpällään" ;
lin la'a'te_N = mkkN "lääte" ;
lin la'a'va'_N = mkkN "läävä" ;
lin lo'ho'illa'_V = mkkV "löhöillä" ;
lin lo'ho'ily_N = mkkN "löhöily" ;
lin lo'ho'ta'_V = mkkV "löhötä" ;
lin lo'ka'po'ksy_N = mkkN "lökäpöksy" ;
lin lo'ko'tta'a'_V = mkkV "lököttää" ;
lin lo'llya'_V = mkkV "löllyä" ;
lin lo'llo'_N = mkkN "löllö" ;
lin lo'nkytella'_V = mkkV "lönkytellä" ;
lin lo'nkytta'a'_V = mkkV "lönkyttää" ;
lin lo'ntti_N = mkkN "löntti" ;
lin lo'ntystella'_V = mkkV "löntystellä" ;
lin lo'ntysta'a'_V = mkkV "löntystää" ;
lin lo'peryys_N = mkkN "löperyys" ;
lin lo'pero'_A = mkkA "löperö" ;
lin lo'pero'sti_Adv = mkkAdv "löperösti" ;
lin lo'pina'_N = mkkN "löpinä" ;
lin lo'pista'_V = mkkV "löpistä" ;
lin lo'po'_1_N = mkkN "löpö" ;
lin lo'po'_2_N = mkkN "löpö" ;
lin lo'rppo'_N = mkkN "lörppö" ;
lin lo'rpo'tella'_V = mkkV "lörpötellä" ;
lin lo'rpo'ttely_N = mkkN "lörpöttely" ;
lin lo'rpo'tta'a'_V = mkkV "lörpöttää" ;
lin lo'rpo'tys_N = mkkN "lörpötys" ;
lin lo'rtsy_N = mkkN "lörtsy" ;
lin lo'ssi_1_N = mkkN "lössi" ;
lin lo'ssi_2_N = mkkN "lössi" ;
lin lo'tko'_N = mkkN "lötkö" ;
lin lo'tko'tella'_V = mkkV "lötkötellä" ;
lin lo'tko'tta'a'_V = mkkV "lötköttää" ;
lin lo'ydo's_N = mkkN "löydös" ;
lin lo'yhdytta'a'_V = mkkV "löyhdyttää" ;
lin lo'yhennys_N = mkkN "löyhennys" ;
lin lo'yhentya'_V = mkkV "löyhentyä" ;
lin lo'yhenta'a'_V = mkkV "löyhentää" ;
lin lo'yheta'_V = mkkV "löyhetä" ;
lin lo'yhka'_N = mkkN "löyhkä" ;
lin lo'yhka'ta'_V = mkkV "löyhkätä" ;
lin lo'yhtya'_V = mkkV "löyhtyä" ;
lin lo'yhytella'_V = mkkV "löyhytellä" ;
lin lo'yhytta'a'_V = mkkV "löyhyttää" ;
lin lo'yhyys_N = mkkN "löyhyys" ;
lin lo'yha'_A = mkkA "löyhä" ;
lin lo'yha'hta'a'_V = mkkV "löyhähtää" ;
lin lo'yha'sti_Adv = mkkAdv "löyhästi" ;
lin lo'yly_N = mkkN "löyly" ;
lin lo'ylynlyo'ma'_N = mkkN "löylynlyömä" ;
lin lo'ylytta'a'_V = mkkV "löylyttää" ;
lin lo'ylytys_N = mkkN "löylytys" ;
lin lo'ysentya'_V = mkkV "löysentyä" ;
lin lo'ysenta'a'_V = mkkV "löysentää" ;
lin lo'ystytta'a'_V = mkkV "löystyttää" ;
lin lo'ystya'_V = mkkV "löystyä" ;
lin lo'ysyys_N = mkkN "löysyys" ;
lin lo'ysa'_A = mkkA "löysä" ;
lin lo'ysa'sti_Adv = mkkAdv "löysästi" ;
lin lo'ysa'ta'_V = mkkV "löysätä" ;
lin lo'ytyma'tto'miin_Adv = mkkAdv "löytymättömiin" ;
lin lo'ytyma'tto'missa'_Adv = mkkAdv "löytymättömissä" ;
lin lo'ytya'_V = mkkV "löytyä" ;
lin lo'yta'ja'_N = mkkN "löytäjä" ;
lin lo'yta'a'_V = mkkV "löytää" ;
lin lo'yto'_N = mkkN "löytö" ;
lin lo'o'peri_N = mkkN "lööperi" ;
lin lo'o'ppi_N = mkkN "lööppi" ;
lin ma_Adv = mkkAdv "ma" ;
lin maa_N = mkkN "maa" ;
lin maadoittaa_V = mkkV "maadoittaa" ;
lin maadoitus_N = mkkN "maadoitus" ;
lin maaduttaa_V = mkkV "maaduttaa" ;
lin maagi_N = mkkN "maagi" ;
lin maagikko_N = mkkN "maagikko" ;
lin maaginen_A = mkkA "maaginen" ;
lin maagisesti_Adv = mkkAdv "maagisesti" ;
lin maagisuus_N = mkkN "maagisuus" ;
--? lin maahanpaniaiset_NK = {s = d38 "maahanpaniaiset" ;
lin maahantunkeutuminen_N = mkkN "maahantunkeutuminen" ;
lin maaherratar_N = mkkN "maaherratar" ;
lin maahikas_N = mkkN "maahikas" ;
lin maahinen_N = mkkN "maahinen" ;
lin maahockey_N = mkkN "maahockey" ;
lin maailmallinen_N = mkkN "maailmallinen" ;
lin maailmallistua_V = mkkV "maailmallistua" ;
lin maailmallisuus_N = mkkN "maailmallisuus" ;
lin maailmanaika_N = mkkN "maailmanaika" ;
lin maailmanenna'tysaika_N = mkkN "maailmanennätysaika" ;
lin maailmanhistoriallisesti_Adv = mkkAdv "maailmanhistoriallisesti" ;
lin maailmankatsomuksellinen_N = mkkN "maailmankatsomuksellinen" ;
lin maailmankolkka_N = mkkN "maailmankolkka" ;
lin maailmanlaajuisesti_Adv = mkkAdv "maailmanlaajuisesti" ;
lin maalaamaton_N = mkkN "maalaamaton" ;
lin maalaamo_N = mkkN "maalaamo" ;
lin maalailla_V = mkkV "maalailla" ;
lin maalailu_N = mkkN "maalailu" ;
lin maalaisesti_Adv = mkkAdv "maalaisesti" ;
lin maalaisittain_Adv = mkkAdv "maalaisittain" ;
lin maalaismainen_A = mkkA "maalaismainen" ;
lin maalaismaisesti_Adv = mkkAdv "maalaismaisesti" ;
lin maalaismaisuus_N = mkkN "maalaismaisuus" ;
lin maalaistua_V = mkkV "maalaistua" ;
lin maalaisuus_N = mkkN "maalaisuus" ;
lin maalaisvoi_N = mkkN "maalaisvoi" ;
lin maalata_1_V = mkkV "maalata" ;
lin maalata_2_V = mkkV "maalata" ;
lin maalauksellinen_A = mkkA "maalauksellinen" ;
lin maalauksellisesti_Adv = mkkAdv "maalauksellisesti" ;
lin maalauksellisuus_N = mkkN "maalauksellisuus" ;
lin maalaus_1_N = mkkN "maalaus" ;
lin maalaus_2_N = mkkN "maalaus" ;
lin maalauttaa_V = mkkV "maalauttaa" ;
lin maali_1_N = mkkN "maali" ;
lin maali_2_N = mkkN "maali" ;
lin maalinen_1_N = mkkN "maalinen" ;
lin maalinen_2_N = mkkN "maalinen" ;
lin maaliskuinen_N = mkkN "maaliskuinen" ;
lin maaliton_1_N = mkkN "maaliton" ;
lin maaliton_2_N = mkkN "maaliton" ;
lin maallikko_N = mkkN "maallikko" ;
lin maallinen_N = mkkN "maallinen" ;
lin maallistua_V = mkkV "maallistua" ;
lin maallisuus_N = mkkN "maallisuus" ;
lin maammo_N = mkkN "maammo" ;
lin maamo_N = mkkN "maamo" ;
lin maanantai_N = mkkN "maanantai" ;
lin maanantainen_N = mkkN "maanantainen" ;
lin maanantaisin_Adv = mkkAdv "maanantaisin" ;
lin maanikko_N = mkkN "maanikko" ;
lin maaninen_N = mkkN "maaninen" ;
lin maanitella_V = mkkV "maanitella" ;
lin maanittelu_N = mkkN "maanittelu" ;
lin maankohoaminen_N = mkkN "maankohoaminen" ;
lin maankolkka_N = mkkN "maankolkka" ;
lin maankuori_N = mkkN "maankuori" ;
lin maanlaki_N = mkkN "maanlaki" ;
lin maannos_N = mkkN "maannos" ;
lin maannostua_V = mkkV "maannostua" ;
lin maannousema_N = mkkN "maannousema" ;
lin maanraja_N = mkkN "maanraja" ;
lin maantaa_V = mkkV "maantaa" ;
lin maapa'hkina'voi_N = mkkN "maapähkinävoi" ;
lin maar_Adv = mkkAdv "maar" ;
lin maarin_Adv = mkkAdv "maarin" ;
lin maaru_N = mkkN "maaru" ;
lin maasai_N = mkkN "maasai" ;
lin maastaveto_N = mkkN "maastaveto" ;
lin maasto_N = mkkN "maasto" ;
lin maastoinen_N = mkkN "maastoinen" ;
lin maastoitse_Adv = mkkAdv "maastoitse" ;
lin maastonkohta_N = mkkN "maastonkohta" ;
lin maastouttaa_V = mkkV "maastouttaa" ;
lin maastoutua_V = mkkV "maastoutua" ;
lin maasturi_N = mkkN "maasturi" ;
lin maata_V = mkkV "maata" ;
lin maate_Adv = mkkAdv "maate" ;
lin maatiaismainen_N = mkkN "maatiaismainen" ;
lin maaton_N = mkkN "maaton" ;
lin maattaa_V = mkkV "maattaa" ;
lin maatto_N = mkkN "maatto" ;
lin maatua_V = mkkV "maatua" ;
lin machiavellilainen_N = mkkN "machiavellilainen" ;
lin machiavellismi_N = mkkN "machiavellismi" ;
lin machiavellisti_N = mkkN "machiavellisti" ;
lin machiavellistinen_N = mkkN "machiavellistinen" ;
lin macho_N = mkkN "macho" ;
lin machoilla_V = mkkV "machoilla" ;
lin machoilu_N = mkkN "machoilu" ;
lin madallus_N = mkkN "madallus" ;
lin madaltaa_V = mkkV "madaltaa" ;
lin madaltua_V = mkkV "madaltua" ;
lin madame_N = mkkN "madame" ;
lin made_N = mkkN "made" ;
lin madeira_N = mkkN "madeira" ;
lin madella_V = mkkV "madella" ;
lin madonna_N = mkkN "madonna" ;
lin madonsyo'ma'_N = mkkN "madonsyömä" ;
lin madottaa_V = mkkV "madottaa" ;
lin madotus_N = mkkN "madotus" ;
lin madras_N = mkkN "madras" ;
lin madrigaali_N = mkkN "madrigaali" ;
lin maestoso_Adv = mkkAdv "maestoso" ;
lin maestro_N = mkkN "maestro" ;
lin mafia_N = mkkN "mafia" ;
lin mafioso_N = mkkN "mafioso" ;
lin magia_N = mkkN "magia" ;
lin magiikka_N = mkkN "magiikka" ;
lin magma_N = mkkN "magma" ;
lin magmaattinen_N = mkkN "magmaattinen" ;
lin magna_N = mkkN "magna" ;
lin magnaatti_N = mkkN "magnaatti" ;
lin magneetiton_N = mkkN "magneetiton" ;
lin magneetittomuus_N = mkkN "magneetittomuus" ;
lin magneetti_N = mkkN "magneetti" ;
lin magneettinen_A = mkkA "magneettinen" ;
lin magneettisesti_Adv = mkkAdv "magneettisesti" ;
lin magneettisuus_N = mkkN "magneettisuus" ;
lin magneetto_N = mkkN "magneetto" ;
lin magnesiitti_N = mkkN "magnesiitti" ;
lin magnesium_N = mkkN "magnesium" ;
lin magnetiitti_N = mkkN "magnetiitti" ;
lin magnetismi_N = mkkN "magnetismi" ;
lin magnetisoida_V = mkkV "magnetisoida" ;
lin magnetisointi_N = mkkN "magnetisointi" ;
lin magnetisoitua_V = mkkV "magnetisoitua" ;
lin magnetofoni_N = mkkN "magnetofoni" ;
lin magnetoida_V = mkkV "magnetoida" ;
lin magnetointi_N = mkkN "magnetointi" ;
lin magnetoitua_V = mkkV "magnetoitua" ;
lin magnetoitumaton_N = mkkN "magnetoitumaton" ;
lin magnolia_N = mkkN "magnolia" ;
lin maha_N = mkkN "maha" ;
lin mahahaava_N = mkkN "mahahaava" ;
lin mahainen_N = mkkN "mahainen" ;
lin mahakas_N = mkkN "mahakas" ;
lin mahatma_N = mkkN "mahatma" ;
lin mahdikas_A = mkkA "mahdikas" ;
lin mahdikkaasti_Adv = mkkAdv "mahdikkaasti" ;
lin mahdikkuus_N = mkkN "mahdikkuus" ;
lin mahdollinen_A = mkkA "mahdollinen" ;
lin mahdollisesti_Adv = mkkAdv "mahdollisesti" ;
lin mahdollistaa_V = mkkV "mahdollistaa" ;
lin mahdollistua_V = mkkV "mahdollistua" ;
lin mahdollisuus_N = mkkN "mahdollisuus" ;
lin mahdoton_N = mkkN "mahdoton" ;
lin mahdottomasti_Adv = mkkAdv "mahdottomasti" ;
lin mahdottomuus_N = mkkN "mahdottomuus" ;
lin mahduttaa_V = mkkV "mahduttaa" ;
lin mahis_N = mkkN "mahis" ;
lin mahjong_N = mkkN "mahjong" ;
lin mahla_N = mkkN "mahla" ;
lin mahlainen_N = mkkN "mahlainen" ;
lin maho_N = mkkN "maho" ;
lin mahonia_N = mkkN "mahonia" ;
lin mahonki_N = mkkN "mahonki" ;
lin mahonkinen_N = mkkN "mahonkinen" ;
lin mahorkka_N = mkkN "mahorkka" ;
lin mahous_N = mkkN "mahous" ;
lin mahtaa_V = mkkV "mahtaa" ;
lin mahtailevasti_Adv = mkkAdv "mahtailevasti" ;
lin mahtailija_N = mkkN "mahtailija" ;
lin mahtailla_V = mkkV "mahtailla" ;
lin mahtailu_N = mkkN "mahtailu" ;
lin mahtaja_N = mkkN "mahtaja" ;
lin mahtava_A = mkkA "mahtava" ;
lin mahtavasti_Adv = mkkAdv "mahtavasti" ;
lin mahtavuus_N = mkkN "mahtavuus" ;
lin mahti_N = mkkN "mahti" ;
lin mahtipontinen_A = mkkA "mahtipontinen" ;
lin mahtipontisesti_Adv = mkkAdv "mahtipontisesti" ;
lin mahtipontisuus_N = mkkN "mahtipontisuus" ;
lin mahtua_V = mkkV "mahtua" ;
lin maihari_N = mkkN "maihari" ;
lin maihin_Adv = mkkAdv "maihin" ;
lin maija_N = mkkN "maija" ;
lin maikka_N = mkkN "maikka" ;
lin maikki_N = mkkN "maikki" ;
lin maila_N = mkkN "maila" ;
lin mailanen_N = mkkN "mailanen" ;
lin maileri_N = mkkN "maileri" ;
lin maili_1_N = mkkN "maili" ;
lin maili_2_N = mkkN "maili" ;
lin main_Adv = mkkAdv "main" ;
lin mainari_N = mkkN "mainari" ;
lin maine_N = mkkN "maine" ;
lin mainehikas_N = mkkN "mainehikas" ;
lin maineikas_A = mkkA "maineikas" ;
lin maineikkaasti_Adv = mkkAdv "maineikkaasti" ;
lin maineikkuus_N = mkkN "maineikkuus" ;
lin maineinen_N = mkkN "maineinen" ;
lin mainen_N = mkkN "mainen" ;
lin maininki_N = mkkN "maininki" ;
lin maininta_N = mkkN "maininta" ;
lin mainio_N = mkkN "mainio" ;
lin mainita_V = mkkV "mainita" ;
lin mainitsematon_N = mkkN "mainitsematon" ;
lin mainittava_A = mkkA "mainittava" ;
lin mainittavasti_Adv = mkkAdv "mainittavasti" ;
lin mainitunlainen_N = mkkN "mainitunlainen" ;
lin mainonnallinen_A = mkkA "mainonnallinen" ;
lin mainonnallisesti_Adv = mkkAdv "mainonnallisesti" ;
lin mainonta_N = mkkN "mainonta" ;
lin mainos_N = mkkN "mainos" ;
lin mainosaika_N = mkkN "mainosaika" ;
lin mainostaa_V = mkkV "mainostaa" ;
lin mainostus_N = mkkN "mainostus" ;
lin mainstream_N = mkkN "mainstream" ;
lin mairea_A = mkkA "mairea" ;
lin maireasti_Adv = mkkAdv "maireasti" ;
lin maireus_N = mkkN "maireus" ;
lin mairitella_V = mkkV "mairitella" ;
lin mairittelevasti_Adv = mkkAdv "mairittelevasti" ;
lin mairittelu_N = mkkN "mairittelu" ;
lin maisema_N = mkkN "maisema" ;
lin maisemallinen_N = mkkN "maisemallinen" ;
lin maisemoida_V = mkkV "maisemoida" ;
lin maisemointi_N = mkkN "maisemointi" ;
lin maiskahdus_N = mkkN "maiskahdus" ;
lin maiskahtaa_V = mkkV "maiskahtaa" ;
lin maiskaus_N = mkkN "maiskaus" ;
lin maiskauttaa_V = mkkV "maiskauttaa" ;
lin maiskutella_V = mkkV "maiskutella" ;
lin maiskuttaa_V = mkkV "maiskuttaa" ;
lin maiskuttelu_N = mkkN "maiskuttelu" ;
lin maiskutus_N = mkkN "maiskutus" ;
lin maissa_Adv = mkkAdv "maissa" ;
lin maissi_N = mkkN "maissi" ;
lin maista_Adv = mkkAdv "maista" ;
lin maistaa_V = mkkV "maistaa" ;
lin maistaja_N = mkkN "maistaja" ;
--? lin maistajaiset_NK = {s = d38 "maistajaiset" ;
lin maistella_V = mkkV "maistella" ;
lin maisteri_N = mkkN "maisteri" ;
lin maisti_N = mkkN "maisti" ;
--? lin maistiaiset_NK = {s = d38 "maistiaiset" ;
lin maistraatti_N = mkkN "maistraatti" ;
lin maistua_V = mkkV "maistua" ;
lin maiti_N = mkkN "maiti" ;
lin maitiainen_N = mkkN "maitiainen" ;
lin maitikka_N = mkkN "maitikka" ;
lin maito_N = mkkN "maito" ;
lin maitoinen_N = mkkN "maitoinen" ;
lin maitse_Adv = mkkAdv "maitse" ;
lin maittaa_V = mkkV "maittaa" ;
lin maittain_Adv = mkkAdv "maittain" ;
lin maja_N = mkkN "maja" ;
lin majailla_V = mkkV "majailla" ;
lin majailu_N = mkkN "majailu" ;
lin majakka_N = mkkN "majakka" ;
lin majava_N = mkkN "majava" ;
lin majavanhausta_N = mkkN "majavanhausta" ;
lin majesteetillinen_N = mkkN "majesteetillinen" ;
lin majesteetti_N = mkkN "majesteetti" ;
lin majesteettinen_A = mkkA "majesteettinen" ;
lin majesteettisesti_Adv = mkkAdv "majesteettisesti" ;
lin majesteettisuus_N = mkkN "majesteettisuus" ;
lin majesteettius_N = mkkN "majesteettius" ;
lin majoittaa_V = mkkV "majoittaa" ;
lin majoittaja_N = mkkN "majoittaja" ;
lin majoittautua_V = mkkV "majoittautua" ;
lin majoittua_V = mkkV "majoittua" ;
lin majoitus_N = mkkN "majoitus" ;
lin majolika_N = mkkN "majolika" ;
lin majoneesi_N = mkkN "majoneesi" ;
lin majoriteetti_N = mkkN "majoriteetti" ;
lin majuri_N = mkkN "majuri" ;
lin makaaberi_N = mkkN "makaaberi" ;
lin makailla_V = mkkV "makailla" ;
lin makaki_N = mkkN "makaki" ;
lin makaroni_N = mkkN "makaroni" ;
lin makasiini_N = mkkN "makasiini" ;
lin makaus_N = mkkN "makaus" ;
lin makauttaa_V = mkkV "makauttaa" ;
lin makea_A = mkkA "makea" ;
lin makeahko_N = mkkN "makeahko" ;
lin makeasti_Adv = mkkAdv "makeasti" ;
lin makeilla_V = mkkV "makeilla" ;
lin makeilu_N = mkkN "makeilu" ;
lin makeinen_N = mkkN "makeinen" ;
lin make_up_N = mkkN "make-up" ;
lin makeus_N = mkkN "makeus" ;
lin makeute_N = mkkN "makeute" ;
lin makeuttaa_V = mkkV "makeuttaa" ;
lin makeutus_N = mkkN "makeutus" ;
lin makkara_N = mkkN "makkara" ;
lin makkarankuori_N = mkkN "makkarankuori" ;
lin makkari_N = mkkN "makkari" ;
lin makki_N = mkkN "makki" ;
lin makoilla_V = mkkV "makoilla" ;
lin makoilu_N = mkkN "makoilu" ;
lin makoinen_N = mkkN "makoinen" ;
lin makoisa_N = mkkN "makoisa" ;
lin makramee_N = mkkN "makramee" ;
lin makrilli_N = mkkN "makrilli" ;
lin makro_N = mkkN "makro" ;
lin makrobiootikko_N = mkkN "makrobiootikko" ;
lin makrobioottinen_N = mkkN "makrobioottinen" ;
lin makroskooppinen_N = mkkN "makroskooppinen" ;
lin maksa_N = mkkN "maksa" ;
lin maksaa_V = mkkV "maksaa" ;
lin maksaja_N = mkkN "maksaja" ;
lin maksamaton_N = mkkN "maksamaton" ;
lin maksattaa_V = mkkV "maksattaa" ;
lin maksatus_N = mkkN "maksatus" ;
lin maksella_V = mkkV "maksella" ;
lin maksi_N = mkkN "maksi" ;
lin maksiimi_N = mkkN "maksiimi" ;
lin maksimi_N = mkkN "maksimi" ;
lin maksimoida_V = mkkV "maksimoida" ;
lin maksimointi_N = mkkN "maksimointi" ;
lin maksoittua_V = mkkV "maksoittua" ;
lin maksoittuma_N = mkkN "maksoittuma" ;
lin maksu_N = mkkN "maksu" ;
lin maksuaika_N = mkkN "maksuaika" ;
lin maksullinen_N = mkkN "maksullinen" ;
lin maksullistaa_V = mkkV "maksullistaa" ;
lin maksuton_N = mkkN "maksuton" ;
lin maksuttomasti_Adv = mkkAdv "maksuttomasti" ;
lin maksuttomuus_N = mkkN "maksuttomuus" ;
lin maksuunpanna_V = mkkV "maksuunpanna" ;
lin maku_N = mkkN "maku" ;
lin makuinen_N = mkkN "makuinen" ;
lin makulatuuri_N = mkkN "makulatuuri" ;
lin makuloida_V = mkkV "makuloida" ;
lin makustella_V = mkkV "makustella" ;
lin makuu_N = mkkN "makuu" ;
lin makuuhaava_N = mkkN "makuuhaava" ;
lin makuulla_Adv = mkkAdv "makuulla" ;
lin makuulle_Adv = mkkAdv "makuulle" ;
lin makuulta_Adv = mkkAdv "makuulta" ;
lin makuus_N = mkkN "makuus" ;
lin makuuttaa_V = mkkV "makuuttaa" ;
lin malaga_N = mkkN "malaga" ;
lin malaiji_N = mkkN "malaiji" ;
lin malakiitti_N = mkkN "malakiitti" ;
lin malaria_N = mkkN "malaria" ;
lin maleksia_V = mkkV "maleksia" ;
lin maleksija_N = mkkN "maleksija" ;
lin mali_N = mkkN "mali" ;
lin maligni_N = mkkN "maligni" ;
lin malignisoitua_V = mkkV "malignisoitua" ;
lin malignistua_V = mkkV "malignistua" ;
lin maligniteetti_N = mkkN "maligniteetti" ;
lin malignoitua_V = mkkV "malignoitua" ;
lin malikka_N = mkkN "malikka" ;
lin malja_N = mkkN "malja" ;
lin maljakas_N = mkkN "maljakas" ;
lin maljakko_N = mkkN "maljakko" ;
lin malka_N = mkkN "malka" ;
lin mallas_N = mkkN "mallas" ;
lin mallastaa_V = mkkV "mallastaa" ;
lin mallastamo_N = mkkN "mallastamo" ;
lin mallastus_N = mkkN "mallastus" ;
lin mallata_V = mkkV "mallata" ;
lin malli_N = mkkN "malli" ;
lin mallikas_A = mkkA "mallikas" ;
lin mallikelpoisesti_Adv = mkkAdv "mallikelpoisesti" ;
lin mallikkaasti_Adv = mkkAdv "mallikkaasti" ;
lin mallikkuus_N = mkkN "mallikkuus" ;
lin malline_N = mkkN "malline" ;
lin mallinen_N = mkkN "mallinen" ;
lin mallinnus_N = mkkN "mallinnus" ;
lin mallintaa_V = mkkV "mallintaa" ;
lin mallisto_N = mkkN "mallisto" ;
lin mallisuojattu_N = mkkN "mallisuojattu" ;
lin mallittaa_V = mkkV "mallittaa" ;
lin malluainen_N = mkkN "malluainen" ;
lin malmi_N = mkkN "malmi" ;
lin malmikas_N = mkkN "malmikas" ;
lin malminen_N = mkkN "malminen" ;
lin malmio_N = mkkN "malmio" ;
--? lin maltaat_NK = {s = d41A "maltaat" ;
lin maltillinen_A = mkkA "maltillinen" ;
lin maltillisesti_Adv = mkkAdv "maltillisesti" ;
lin maltillistua_V = mkkV "maltillistua" ;
lin maltillisuus_N = mkkN "maltillisuus" ;
lin maltiton_N = mkkN "maltiton" ;
lin maltittomasti_Adv = mkkAdv "maltittomasti" ;
lin maltittomuus_N = mkkN "maltittomuus" ;
lin malto_N = mkkN "malto" ;
lin maltoinen_N = mkkN "maltoinen" ;
lin maltoosi_N = mkkN "maltoosi" ;
lin maltsa_N = mkkN "maltsa" ;
lin malttaa_V = mkkV "malttaa" ;
lin malttamaton_N = mkkN "malttamaton" ;
lin malttamattomasti_Adv = mkkAdv "malttamattomasti" ;
lin malttamattomuus_N = mkkN "malttamattomuus" ;
lin maltti_N = mkkN "maltti" ;
lin malva_N = mkkN "malva" ;
lin malvikki_N = mkkN "malvikki" ;
lin mamba_N = mkkN "mamba" ;
lin mambo_N = mkkN "mambo" ;
lin mamero_N = mkkN "mamero" ;
lin mamma_N = mkkN "mamma" ;
lin mammografia_N = mkkN "mammografia" ;
lin mammona_N = mkkN "mammona" ;
lin mammutti_N = mkkN "mammutti" ;
lin mamselli_N = mkkN "mamselli" ;
lin mana_1_N = mkkN "mana" ;
lin mana_2_N = mkkN "mana" ;
lin manaaja_N = mkkN "manaaja" ;
lin management_N = mkkN "management" ;
lin manageri_N = mkkN "manageri" ;
lin manailla_V = mkkV "manailla" ;
lin manailu_N = mkkN "manailu" ;
lin manala_N = mkkN "manala" ;
lin manata_V = mkkV "manata" ;
lin manaus_N = mkkN "manaus" ;
lin mandaatti_N = mkkN "mandaatti" ;
lin mandariini_1_N = mkkN "mandariini" ;
lin mandariini_2_N = mkkN "mandariini" ;
lin mandoliini_N = mkkN "mandoliini" ;
lin mandrilli_N = mkkN "mandrilli" ;
lin maneeri_N = mkkN "maneeri" ;
lin maneerimaisesti_Adv = mkkAdv "maneerimaisesti" ;
lin maneerimaisuus_N = mkkN "maneerimaisuus" ;
lin maneeristua_V = mkkV "maneeristua" ;
lin maneesi_N = mkkN "maneesi" ;
lin maneetti_N = mkkN "maneetti" ;
lin mangaani_N = mkkN "mangaani" ;
lin mango_N = mkkN "mango" ;
lin mangoldi_N = mkkN "mangoldi" ;
lin mangostani_N = mkkN "mangostani" ;
lin mangrove_N = mkkN "mangrove" ;
lin mangunta_N = mkkN "mangunta" ;
lin mani_N = mkkN "mani" ;
lin mania_N = mkkN "mania" ;
lin manifestaatio_N = mkkN "manifestaatio" ;
lin manifesti_N = mkkN "manifesti" ;
lin manifestinen_N = mkkN "manifestinen" ;
lin manifestoida_V = mkkV "manifestoida" ;
lin manifestoitua_V = mkkV "manifestoitua" ;
lin manikyristi_N = mkkN "manikyristi" ;
lin manikyyri_N = mkkN "manikyyri" ;
lin manila_N = mkkN "manila" ;
lin manilla_N = mkkN "manilla" ;
lin manipulaatio_N = mkkN "manipulaatio" ;
lin manipulaattori_N = mkkN "manipulaattori" ;
lin manipuloida_V = mkkV "manipuloida" ;
lin manipuloija_N = mkkN "manipuloija" ;
lin manipulointi_N = mkkN "manipulointi" ;
lin mankeli_N = mkkN "mankeli" ;
lin mankeloida_V = mkkV "mankeloida" ;
lin mankelointi_N = mkkN "mankelointi" ;
lin mankka_N = mkkN "mankka" ;
lin mankku_N = mkkN "mankku" ;
lin mankua_V = mkkV "mankua" ;
lin mankuja_N = mkkN "mankuja" ;
lin manna_N = mkkN "manna" ;
lin manne_N = mkkN "manne" ;
lin mannekiini_N = mkkN "mannekiini" ;
lin manner_N = mkkN "manner" ;
lin mannerliikunto_N = mkkN "mannerliikunto" ;
lin mannermaisesti_Adv = mkkAdv "mannermaisesti" ;
lin mannermaisuus_N = mkkN "mannermaisuus" ;
lin manometri_N = mkkN "manometri" ;
lin mansetti_N = mkkN "mansetti" ;
lin mansi_N = mkkN "mansi" ;
lin mansikka_N = mkkN "mansikka" ;
lin mansikka_aika_N = mkkN "mansikka-aika" ;
lin manteli_N = mkkN "manteli" ;
lin mantere_N = mkkN "mantere" ;
lin mantereinen_N = mkkN "mantereinen" ;
lin mantereisuus_N = mkkN "mantereisuus" ;
lin mantilja_N = mkkN "mantilja" ;
lin mantissa_N = mkkN "mantissa" ;
lin manto_N = mkkN "manto" ;
lin mantra_N = mkkN "mantra" ;
lin manttaali_N = mkkN "manttaali" ;
lin mantteli_N = mkkN "mantteli" ;
lin mantu_N = mkkN "mantu" ;
lin manu_N = mkkN "manu" ;
lin manuaali_N = mkkN "manuaali" ;
lin manuaalinen_A = mkkA "manuaalinen" ;
lin manuaalisesti_Adv = mkkAdv "manuaalisesti" ;
lin mano'veroida_V = mkkV "manöveroida" ;
lin mano'verointi_N = mkkN "manöverointi" ;
lin mano'vroida_V = mkkV "manövroida" ;
lin mano'o'veri_N = mkkN "manööveri" ;
lin maoismi_N = mkkN "maoismi" ;
lin maolainen_N = mkkN "maolainen" ;
lin maolaisuus_N = mkkN "maolaisuus" ;
lin mapillinen_N = mkkN "mapillinen" ;
lin mapittaa_V = mkkV "mapittaa" ;
lin mapitus_N = mkkN "mapitus" ;
lin mappi_N = mkkN "mappi" ;
lin mar_Adv = mkkAdv "mar" ;
lin marakas_N = mkkN "marakas" ;
lin marakatti_N = mkkN "marakatti" ;
lin maraton_N = mkkN "maraton" ;
lin maratoonari_N = mkkN "maratoonari" ;
lin marenki_N = mkkN "marenki" ;
lin margariini_N = mkkN "margariini" ;
lin marginaali_N = mkkN "marginaali" ;
lin marginaalinen_N = mkkN "marginaalinen" ;
lin marhaminta_N = mkkN "marhaminta" ;
lin mari_N = mkkN "mari" ;
lin marihuana_N = mkkN "marihuana" ;
lin marimba_N = mkkN "marimba" ;
lin marina_1_N = mkkN "marina" ;
lin marina_2_N = mkkN "marina" ;
lin marinadi_N = mkkN "marinadi" ;
lin marinoida_V = mkkV "marinoida" ;
lin marinointi_N = mkkN "marinointi" ;
lin marinoitua_V = mkkV "marinoitua" ;
lin marionetti_N = mkkN "marionetti" ;
lin marista_V = mkkV "marista" ;
lin marja_N = mkkN "marja" ;
lin marja_aika_N = mkkN "marja-aika" ;
lin marjainen_N = mkkN "marjainen" ;
lin marjaisa_N = mkkN "marjaisa" ;
lin marjastaa_V = mkkV "marjastaa" ;
lin marjastaja_N = mkkN "marjastaja" ;
lin marjastus_N = mkkN "marjastus" ;
lin marjoa_V = mkkV "marjoa" ;
lin marjonta_N = mkkN "marjonta" ;
lin market_N = mkkN "market" ;
lin marketti_N = mkkN "marketti" ;
lin markiisi_N = mkkN "markiisi" ;
lin markiisitar_N = mkkN "markiisitar" ;
lin markka_N = mkkN "markka" ;
lin markkanen_N = mkkN "markkanen" ;
lin markkeerata_V = mkkV "markkeerata" ;
lin markkeri_N = mkkN "markkeri" ;
lin markkina_N = mkkN "markkina" ;
--? lin markkinat_NK = {s = d12 "markkinat" ;
lin markkinoida_V = mkkV "markkinoida" ;
lin markkinoija_N = mkkN "markkinoija" ;
lin markkinointi_N = mkkN "markkinointi" ;
lin marksilainen_N = mkkN "marksilainen" ;
lin marksilais_leninila'inen_N = mkkN "marksilais-leniniläinen" ;
lin marksilaisuus_N = mkkN "marksilaisuus" ;
lin marksismi_N = mkkN "marksismi" ;
lin marksismi_leninismi_N = mkkN "marksismi-leninismi" ;
lin marksisti_N = mkkN "marksisti" ;
lin marmattaa_V = mkkV "marmattaa" ;
lin marmatus_N = mkkN "marmatus" ;
lin marmelaati_N = mkkN "marmelaati" ;
lin marmeladi_N = mkkN "marmeladi" ;
lin marmori_N = mkkN "marmori" ;
lin marmorinen_N = mkkN "marmorinen" ;
lin marmoroida_V = mkkV "marmoroida" ;
lin marmorointi_N = mkkN "marmorointi" ;
lin marmoroitua_V = mkkV "marmoroitua" ;
lin marras_N = mkkN "marras" ;
lin marraskesi_N = mkkN "marraskesi" ;
lin mars_Adv = mkkAdv "mars" ;
lin marsalkka_N = mkkN "marsalkka" ;
lin marsilainen_N = mkkN "marsilainen" ;
lin marsipaani_N = mkkN "marsipaani" ;
lin marski_1_N = mkkN "marski" ;
lin marski_2_N = mkkN "marski" ;
lin marssi_N = mkkN "marssi" ;
lin marssia_V = mkkV "marssia" ;
lin marssinta_N = mkkN "marssinta" ;
lin marssittaa_V = mkkV "marssittaa" ;
lin marsu_N = mkkN "marsu" ;
lin martini_N = mkkN "martini" ;
lin martio_N = mkkN "martio" ;
lin martioida_V = mkkV "martioida" ;
lin martiointi_N = mkkN "martiointi" ;
lin marto_N = mkkN "marto" ;
lin martous_N = mkkN "martous" ;
lin martta_N = mkkN "martta" ;
lin marttyyri_N = mkkN "marttyyri" ;
lin marttyyriaika_N = mkkN "marttyyriaika" ;
lin marttyyrius_N = mkkN "marttyyrius" ;
lin marttyyriys_N = mkkN "marttyyriys" ;
lin maruna_N = mkkN "maruna" ;
lin marxilainen_N = mkkN "marxilainen" ;
lin marxilais_leninila'inen_N = mkkN "marxilais-leniniläinen" ;
lin marxilaisuus_N = mkkN "marxilaisuus" ;
lin marxismi_N = mkkN "marxismi" ;
lin marxismi_leninismi_N = mkkN "marxismi-leninismi" ;
lin marxisti_N = mkkN "marxisti" ;
lin masariini_N = mkkN "masariini" ;
lin masennus_N = mkkN "masennus" ;
lin masentaa_V = mkkV "masentaa" ;
lin masentava_N = mkkN "masentava" ;
lin masentua_V = mkkV "masentua" ;
lin masentuneesti_Adv = mkkAdv "masentuneesti" ;
lin masentuneisuus_N = mkkN "masentuneisuus" ;
lin masentunut_A = mkkA "masentunut" ;
lin masi_N = mkkN "masi" ;
lin masiina_N = mkkN "masiina" ;
lin masinoida_V = mkkV "masinoida" ;
lin masinointi_N = mkkN "masinointi" ;
lin maskara_N = mkkN "maskara" ;
lin maskata_V = mkkV "maskata" ;
lin maskeeraaja_N = mkkN "maskeeraaja" ;
lin maskeerata_V = mkkV "maskeerata" ;
lin maski_N = mkkN "maski" ;
lin maskotti_N = mkkN "maskotti" ;
lin maskuliini_N = mkkN "maskuliini" ;
lin maskuliininen_N = mkkN "maskuliininen" ;
lin maskuliinisuus_N = mkkN "maskuliinisuus" ;
lin masmalo_N = mkkN "masmalo" ;
lin masokismi_N = mkkN "masokismi" ;
lin masokisti_N = mkkN "masokisti" ;
lin masokistinen_A = mkkA "masokistinen" ;
lin masokistisesti_Adv = mkkAdv "masokistisesti" ;
lin massa_N = mkkN "massa" ;
lin massainen_N = mkkN "massainen" ;
lin massata_V = mkkV "massata" ;
lin massaus_N = mkkN "massaus" ;
lin massi_N = mkkN "massi" ;
lin massiivi_N = mkkN "massiivi" ;
lin massiivinen_A = mkkA "massiivinen" ;
lin massiivisesti_Adv = mkkAdv "massiivisesti" ;
lin massiivisuus_N = mkkN "massiivisuus" ;
lin massoitella_V = mkkV "massoitella" ;
lin massoittain_Adv = mkkAdv "massoittain" ;
lin massoittelu_N = mkkN "massoittelu" ;
lin massu_N = mkkN "massu" ;
lin masto_N = mkkN "masto" ;
lin mastodontti_N = mkkN "mastodontti" ;
lin mastoinen_N = mkkN "mastoinen" ;
lin masturbaatio_N = mkkN "masturbaatio" ;
lin masturboida_V = mkkV "masturboida" ;
lin masturbointi_N = mkkN "masturbointi" ;
lin masu_N = mkkN "masu" ;
lin masurkka_N = mkkN "masurkka" ;
lin mataa_V = mkkV "mataa" ;
lin matadori_N = mkkN "matadori" ;
lin matala_N = mkkN "matala" ;
lin matalalla_Adv = mkkAdv "matalalla" ;
lin matalalle_Adv = mkkAdv "matalalle" ;
lin matalalta_Adv = mkkAdv "matalalta" ;
lin matalamielisesti_Adv = mkkAdv "matalamielisesti" ;
lin matalikko_N = mkkN "matalikko" ;
lin mataloittaa_V = mkkV "mataloittaa" ;
lin mataloitua_V = mkkV "mataloitua" ;
lin mataluus_N = mkkN "mataluus" ;
lin matami_N = mkkN "matami" ;
lin matara_N = mkkN "matara" ;
lin mateleva_A = mkkA "mateleva" ;
lin matelevasti_Adv = mkkAdv "matelevasti" ;
lin matelija_N = mkkN "matelija" ;
lin matelu_N = mkkN "matelu" ;
lin matemaatikko_N = mkkN "matemaatikko" ;
lin matemaattinen_N = mkkN "matemaattinen" ;
lin matemaattistaa_V = mkkV "matemaattistaa" ;
lin matemaattistua_V = mkkV "matemaattistua" ;
lin matematiikka_N = mkkN "matematiikka" ;
lin matematisoida_V = mkkV "matematisoida" ;
lin matematisoitua_V = mkkV "matematisoitua" ;
lin materia_N = mkkN "materia" ;
lin materiaali_N = mkkN "materiaali" ;
lin materiaalistaa_V = mkkV "materiaalistaa" ;
lin materiaalistua_V = mkkV "materiaalistua" ;
lin materialisaatio_N = mkkN "materialisaatio" ;
lin materialismi_N = mkkN "materialismi" ;
lin materialisoida_V = mkkV "materialisoida" ;
lin materialisoitua_V = mkkV "materialisoitua" ;
lin materialisti_N = mkkN "materialisti" ;
lin materialistinen_A = mkkA "materialistinen" ;
lin materialistisesti_Adv = mkkAdv "materialistisesti" ;
lin matikka_1_N = mkkN "matikka" ;
lin matikka_2_N = mkkN "matikka" ;
lin matinea_N = mkkN "matinea" ;
lin matka_N = mkkN "matka" ;
lin matka_aika_N = mkkN "matka-aika" ;
lin matkaaja_N = mkkN "matkaaja" ;
lin matkailija_N = mkkN "matkailija" ;
lin matkailla_V = mkkV "matkailla" ;
lin matkailu_N = mkkN "matkailu" ;
lin matkailullinen_A = mkkA "matkailullinen" ;
lin matkailullisesti_Adv = mkkAdv "matkailullisesti" ;
lin matkainen_N = mkkN "matkainen" ;
lin matkata_V = mkkV "matkata" ;
lin matkia_V = mkkV "matkia" ;
lin matkija_N = mkkN "matkija" ;
lin matkue_N = mkkN "matkue" ;
lin matkustaa_V = mkkV "matkustaa" ;
lin matkustaja_N = mkkN "matkustaja" ;
lin matkustamo_N = mkkN "matkustamo" ;
lin matkustella_V = mkkV "matkustella" ;
lin matkustelu_N = mkkN "matkustelu" ;
lin matkustus_N = mkkN "matkustus" ;
lin mato_N = mkkN "mato" ;
lin matoinen_N = mkkN "matoinen" ;
lin matonen_N = mkkN "matonen" ;
lin matriarkaalinen_N = mkkN "matriarkaalinen" ;
lin matriarkaatti_N = mkkN "matriarkaatti" ;
lin matriarkka_N = mkkN "matriarkka" ;
lin matriisi_N = mkkN "matriisi" ;
lin matrikkeli_N = mkkN "matrikkeli" ;
lin matronyymi_N = mkkN "matronyymi" ;
lin matroona_N = mkkN "matroona" ;
lin matruusi_N = mkkN "matruusi" ;
lin matsi_N = mkkN "matsi" ;
lin matsku_N = mkkN "matsku" ;
lin matta_N = mkkN "matta" ;
lin matti_1_N = mkkN "matti" ;
lin matti_2_N = mkkN "matti" ;
lin matto_N = mkkN "matto" ;
lin maturiteetti_N = mkkN "maturiteetti" ;
lin mau_Adv = mkkAdv "mau" ;
lin maukas_A = mkkA "maukas" ;
lin maukkaasti_Adv = mkkAdv "maukkaasti" ;
lin maukkaus_N = mkkN "maukkaus" ;
lin maukkuus_N = mkkN "maukkuus" ;
lin maukua_V = mkkV "maukua" ;
lin maukuna_N = mkkN "maukuna" ;
lin mauri_N = mkkN "mauri" ;
lin mauriainen_N = mkkN "mauriainen" ;
lin mausoleumi_N = mkkN "mausoleumi" ;
lin maustaa_V = mkkV "maustaa" ;
lin mauste_N = mkkN "mauste" ;
lin mausteikko_N = mkkN "mausteikko" ;
lin mausteinen_N = mkkN "mausteinen" ;
lin maustevoi_N = mkkN "maustevoi" ;
lin maustua_V = mkkV "maustua" ;
lin mauton_N = mkkN "mauton" ;
lin mauttomasti_Adv = mkkAdv "mauttomasti" ;
lin mauttomuus_N = mkkN "mauttomuus" ;
lin mau_unta_N = mkkN "mau'unta" ;
lin maya_N = mkkN "maya" ;
lin medaljonki_N = mkkN "medaljonki" ;
lin media_N = mkkN "media" ;
lin mediaani_N = mkkN "mediaani" ;
lin medisiina_N = mkkN "medisiina" ;
lin medisiinari_N = mkkN "medisiinari" ;
lin medisiininen_N = mkkN "medisiininen" ;
lin meditaatio_N = mkkN "meditaatio" ;
lin meditoida_V = mkkV "meditoida" ;
lin meditointi_N = mkkN "meditointi" ;
lin meduusa_N = mkkN "meduusa" ;
lin meedio_N = mkkN "meedio" ;
lin meetvursti_N = mkkN "meetvursti" ;
lin mefistomainen_N = mkkN "mefistomainen" ;
lin megafoni_N = mkkN "megafoni" ;
lin megalopoli_N = mkkN "megalopoli" ;
lin mehevyys_N = mkkN "mehevyys" ;
lin meheva'_A = mkkA "mehevä" ;
lin meheva'sti_Adv = mkkAdv "mehevästi" ;
lin mehevo'itta'a'_V = mkkV "mehevöittää" ;
lin mehevo'itya'_V = mkkV "mehevöityä" ;
lin mehila'inen_N = mkkN "mehiläinen" ;
lin mehila'isparvi_N = mkkN "mehiläisparvi" ;
lin mehu_N = mkkN "mehu" ;
lin mehuinen_N = mkkN "mehuinen" ;
lin mehuisa_N = mkkN "mehuisa" ;
lin mehukas_A = mkkA "mehukas" ;
lin mehukkaasti_Adv = mkkAdv "mehukkaasti" ;
lin mehukkuus_N = mkkN "mehukkuus" ;
lin mehustaa_V = mkkV "mehustaa" ;
lin mehuste_N = mkkN "mehuste" ;
lin mehustin_N = mkkN "mehustin" ;
lin mehustua_V = mkkV "mehustua" ;
lin mehustus_N = mkkN "mehustus" ;
lin meijeri_N = mkkN "meijeri" ;
lin meijeristi_N = mkkN "meijeristi" ;
lin meijerivoi_N = mkkN "meijerivoi" ;
lin meikata_V = mkkV "meikata" ;
lin meikkaaja_N = mkkN "meikkaaja" ;
lin meikkaus_N = mkkN "meikkaus" ;
lin meikki_N = mkkN "meikki" ;
lin meikku_N = mkkN "meikku" ;
lin meika'_N = mkkN "meikä" ;
lin meika'la'inen_N = mkkN "meikäläinen" ;
lin meika'la'isitta'in_Adv = mkkAdv "meikäläisittäin" ;
lin meinata_V = mkkV "meinata" ;
lin meininki_N = mkkN "meininki" ;
lin meioosi_N = mkkN "meioosi" ;
lin meirami_N = mkkN "meirami" ;
lin meislata_V = mkkV "meislata" ;
lin meisseli_N = mkkN "meisseli" ;
lin meisti_N = mkkN "meisti" ;
lin meista'a'_V = mkkV "meistää" ;
lin meitsi_N = mkkN "meitsi" ;
lin mekaanikko_N = mkkN "mekaanikko" ;
lin mekaaninen_A = mkkA "mekaaninen" ;
lin mekaanisesti_Adv = mkkAdv "mekaanisesti" ;
lin mekaanistaa_V = mkkV "mekaanistaa" ;
lin mekaanistua_V = mkkV "mekaanistua" ;
lin mekaanisuus_N = mkkN "mekaanisuus" ;
lin mekaniikka_N = mkkN "mekaniikka" ;
lin mekanismi_N = mkkN "mekanismi" ;
lin mekanisoida_V = mkkV "mekanisoida" ;
lin mekanisoitua_V = mkkV "mekanisoitua" ;
lin mekanistinen_N = mkkN "mekanistinen" ;
lin mekastaa_V = mkkV "mekastaa" ;
lin mekastus_N = mkkN "mekastus" ;
lin mekatroniikka_N = mkkN "mekatroniikka" ;
lin mekatroninen_N = mkkN "mekatroninen" ;
lin mekkala_N = mkkN "mekkala" ;
lin mekkaloida_V = mkkV "mekkaloida" ;
lin mekko_N = mkkN "mekko" ;
lin meklari_N = mkkN "meklari" ;
lin meksikolainen_N = mkkN "meksikolainen" ;
lin mela_N = mkkN "mela" ;
lin melamiini_N = mkkN "melamiini" ;
lin melankolia_N = mkkN "melankolia" ;
lin melankolikko_N = mkkN "melankolikko" ;
lin melankolinen_A = mkkA "melankolinen" ;
lin melankolisesti_Adv = mkkAdv "melankolisesti" ;
lin melankolisuus_N = mkkN "melankolisuus" ;
lin melanooma_N = mkkN "melanooma" ;
lin melassi_N = mkkN "melassi" ;
lin melatoniini_N = mkkN "melatoniini" ;
lin meleerata_V = mkkV "meleerata" ;
lin meleeraus_N = mkkN "meleeraus" ;
lin melkein_Adv = mkkAdv "melkein" ;
lin melko_Adv = mkkAdv "melko" ;
lin melkoinen_A = mkkA "melkoinen" ;
lin melkoisesti_Adv = mkkAdv "melkoisesti" ;
lin mellakka_N = mkkN "mellakka" ;
lin mellakoida_V = mkkV "mellakoida" ;
lin mellakoija_N = mkkN "mellakoija" ;
lin mellakointi_N = mkkN "mellakointi" ;
lin mellakoitsija_N = mkkN "mellakoitsija" ;
lin mellastaa_V = mkkV "mellastaa" ;
lin mellastus_N = mkkN "mellastus" ;
lin mellottaa_V = mkkV "mellottaa" ;
lin mellottua_V = mkkV "mellottua" ;
lin mellotus_N = mkkN "mellotus" ;
lin meloa_V = mkkV "meloa" ;
lin melodia_N = mkkN "melodia" ;
lin melodiikka_N = mkkN "melodiikka" ;
lin melodinen_A = mkkA "melodinen" ;
lin melodisesti_Adv = mkkAdv "melodisesti" ;
lin melodisuus_N = mkkN "melodisuus" ;
lin melodramaattisesti_Adv = mkkAdv "melodramaattisesti" ;
lin meloja_N = mkkN "meloja" ;
lin meloni_N = mkkN "meloni" ;
lin melonta_N = mkkN "melonta" ;
lin melskata_V = mkkV "melskata" ;
lin melske_N = mkkN "melske" ;
lin melskeinen_N = mkkN "melskeinen" ;
lin melto_N = mkkN "melto" ;
lin melu_N = mkkN "melu" ;
lin meluaja_N = mkkN "meluaja" ;
lin meluinen_N = mkkN "meluinen" ;
lin meluisa_A = mkkA "meluisa" ;
lin meluisasti_Adv = mkkAdv "meluisasti" ;
lin meluisuus_N = mkkN "meluisuus" ;
lin meluta_V = mkkV "meluta" ;
lin membraani_N = mkkN "membraani" ;
lin memorandumi_N = mkkN "memorandumi" ;
lin mendelismi_N = mkkN "mendelismi" ;
lin mendelistinen_N = mkkN "mendelistinen" ;
lin mendelo'ida'_V = mkkV "mendelöidä" ;
lin menehdyksiin_Adv = mkkAdv "menehdyksiin" ;
lin menehdyksissa'_Adv = mkkAdv "menehdyksissä" ;
lin menehdyksissa'a'n_Adv = mkkAdv "menehdyksissään" ;
lin menehtya'_V = mkkV "menehtyä" ;
lin meneilla'_Adv = mkkAdv "meneillä" ;
lin meneilla'a'n_Adv = mkkAdv "meneillään" ;
lin menekinedista'minen_N = mkkN "menekinedistäminen" ;
lin menekki_N = mkkN "menekki" ;
lin menekkinen_N = mkkN "menekkinen" ;
lin menestyksekkyys_N = mkkN "menestyksekkyys" ;
lin menestyksekka'a'sti_Adv = mkkAdv "menestyksekkäästi" ;
lin menestykseka's_A = mkkA "menestyksekäs" ;
lin menestyksellinen_A = mkkA "menestyksellinen" ;
lin menestyksellisesti_Adv = mkkAdv "menestyksellisesti" ;
lin menestyksellisyys_N = mkkN "menestyksellisyys" ;
lin menestykseto'n_N = mkkN "menestyksetön" ;
lin menestyma'to'n_N = mkkN "menestymätön" ;
lin menestys_N = mkkN "menestys" ;
lin menestya'_V = mkkV "menestyä" ;
lin menetella'_V = mkkV "menetellä" ;
lin menetelma'_N = mkkN "menetelmä" ;
lin menetelma'llinen_N = mkkN "menetelmällinen" ;
lin menettely_N = mkkN "menettely" ;
lin menetta'a'_V = mkkV "menettää" ;
lin menetys_N = mkkN "menetys" ;
lin meneva'_N = mkkN "menevä" ;
lin menija'_N = mkkN "menijä" ;
--? lin menkat_NK = {s = d09A "menkat" ;
--? lin menkut_NK = {s = d01A "menkut" ;
lin menneisyys_N = mkkN "menneisyys" ;
lin mennessa'_Adv = mkkAdv "mennessä" ;
lin menninka'inen_N = mkkN "menninkäinen" ;
lin mennyt_N = mkkN "mennyt" ;
lin menna'_V = mkkV "mennä" ;
lin meno_N = mkkN "meno" ;
lin menota_V = mkkV "menota" ;
--? lin mensikset_NK = {s = d39 "mensikset" ;
lin menstruaatio_N = mkkN "menstruaatio" ;
lin menstruoida_V = mkkV "menstruoida" ;
--? lin mensut_NK = {s = d01 "mensut" ;
lin mentaalinen_A = mkkA "mentaalinen" ;
lin mentaalisesti_Adv = mkkAdv "mentaalisesti" ;
lin mentalismi_N = mkkN "mentalismi" ;
lin mentaliteetti_N = mkkN "mentaliteetti" ;
lin mentoli_N = mkkN "mentoli" ;
lin mentori_N = mkkN "mentori" ;
lin mentorointi_N = mkkN "mentorointi" ;
lin menu_N = mkkN "menu" ;
lin menuetti_N = mkkN "menuetti" ;
lin menyy_N = mkkN "menyy" ;
lin merellinen_N = mkkN "merellinen" ;
lin merellisyys_N = mkkN "merellisyys" ;
lin merenlahti_N = mkkN "merenlahti" ;
lin meri_N = mkkN "meri" ;
lin meridiaani_N = mkkN "meridiaani" ;
lin meriitti_N = mkkN "meriitti" ;
lin merila'inen_N = mkkN "meriläinen" ;
lin merino_N = mkkN "merino" ;
lin meritoitua_V = mkkV "meritoitua" ;
lin meritokraatti_N = mkkN "meritokraatti" ;
lin meritokraattinen_N = mkkN "meritokraattinen" ;
lin meritokratia_N = mkkN "meritokratia" ;
lin meritse_Adv = mkkAdv "meritse" ;
lin merkantiilinen_N = mkkN "merkantiilinen" ;
lin merkantilismi_N = mkkN "merkantilismi" ;
lin merkantilisti_N = mkkN "merkantilisti" ;
lin merkantilistinen_N = mkkN "merkantilistinen" ;
lin merkantti_N = mkkN "merkantti" ;
lin merkaptaani_N = mkkN "merkaptaani" ;
lin merkata_V = mkkV "merkata" ;
lin merkeli_N = mkkN "merkeli" ;
lin merkillinen_A = mkkA "merkillinen" ;
lin merkillisesti_Adv = mkkAdv "merkillisesti" ;
lin merkillisyys_N = mkkN "merkillisyys" ;
lin merkinta'_N = mkkN "merkintä" ;
lin merkinta'inen_N = mkkN "merkintäinen" ;
lin merkinto'_N = mkkN "merkintö" ;
lin merkisto'_N = mkkN "merkistö" ;
lin merkitsevyys_N = mkkN "merkitsevyys" ;
lin merkitseva'_A = mkkA "merkitsevä" ;
lin merkitseva'sti_Adv = mkkAdv "merkitsevästi" ;
lin merkitsija'_N = mkkN "merkitsijä" ;
lin merkitta'vyys_N = mkkN "merkittävyys" ;
lin merkitta'va'_A = mkkA "merkittävä" ;
lin merkitta'va'sti_Adv = mkkAdv "merkittävästi" ;
lin merkitta'a'_V = mkkV "merkittää" ;
lin merkitykseka's_N = mkkN "merkityksekäs" ;
lin merkityksellinen_N = mkkN "merkityksellinen" ;
lin merkitykseto'n_N = mkkN "merkityksetön" ;
lin merkityksinen_N = mkkN "merkityksinen" ;
lin merkityksisyys_N = mkkN "merkityksisyys" ;
lin merkitys_N = mkkN "merkitys" ;
lin merkitytta'a'_V = mkkV "merkityttää" ;
lin merkita'_V = mkkV "merkitä" ;
lin merkito'n_N = mkkN "merkitön" ;
lin merkkaus_N = mkkN "merkkaus" ;
lin merkki_N = mkkN "merkki" ;
lin merkkinen_N = mkkN "merkkinen" ;
lin merkonomi_N = mkkN "merkonomi" ;
lin merseroida_V = mkkV "merseroida" ;
lin merserointi_N = mkkN "merserointi" ;
lin merta_N = mkkN "merta" ;
lin mesenaatti_N = mkkN "mesenaatti" ;
lin mesi_N = mkkN "mesi" ;
lin mesikka'_N = mkkN "mesikkä" ;
lin mesia'inen_N = mkkN "mesiäinen" ;
lin meskaliini_N = mkkN "meskaliini" ;
lin mesoa_V = mkkV "mesoa" ;
lin mesoni_N = mkkN "mesoni" ;
lin mesota_V = mkkV "mesota" ;
lin mesotsooinen_N = mkkN "mesotsooinen" ;
lin messi_N = mkkN "messi" ;
lin messiaaninen_N = mkkN "messiaaninen" ;
lin messianismi_N = mkkN "messianismi" ;
lin messias_N = mkkN "messias" ;
lin messingo'ida'_V = mkkV "messingöidä" ;
lin messingo'inti_N = mkkN "messingöinti" ;
lin messinki_N = mkkN "messinki" ;
lin messinkinen_N = mkkN "messinkinen" ;
lin messu_N = mkkN "messu" ;
lin messuta_V = mkkV "messuta" ;
lin mesta_N = mkkN "mesta" ;
lin mestaaja_N = mkkN "mestaaja" ;
lin mestari_N = mkkN "mestari" ;
lin mestarillinen_A = mkkA "mestarillinen" ;
lin mestarillisesti_Adv = mkkAdv "mestarillisesti" ;
lin mestarillisuus_N = mkkN "mestarillisuus" ;
lin mestarius_N = mkkN "mestarius" ;
lin mestaroida_V = mkkV "mestaroida" ;
lin mestaroija_N = mkkN "mestaroija" ;
lin mestarointi_N = mkkN "mestarointi" ;
lin mestaruus_N = mkkN "mestaruus" ;
lin mestata_V = mkkV "mestata" ;
lin mestaus_N = mkkN "mestaus" ;
lin mestauttaa_V = mkkV "mestauttaa" ;
lin mestitsi_N = mkkN "mestitsi" ;
lin mesu_N = mkkN "mesu" ;
lin metaani_N = mkkN "metaani" ;
lin metabolia_N = mkkN "metabolia" ;
lin metabolinen_N = mkkN "metabolinen" ;
lin metadoni_N = mkkN "metadoni" ;
lin metafora_N = mkkN "metafora" ;
lin metaforinen_A = mkkA "metaforinen" ;
lin metaforisesti_Adv = mkkAdv "metaforisesti" ;
lin metakka_N = mkkN "metakka" ;
lin metalli_N = mkkN "metalli" ;
lin metallinen_N = mkkN "metallinen" ;
lin metallisoida_V = mkkV "metallisoida" ;
lin metalloida_V = mkkV "metalloida" ;
lin metallointi_N = mkkN "metallointi" ;
lin metallurgi_N = mkkN "metallurgi" ;
lin metallurgia_N = mkkN "metallurgia" ;
lin metallurginen_N = mkkN "metallurginen" ;
lin metamorfoosi_N = mkkN "metamorfoosi" ;
lin metanoli_N = mkkN "metanoli" ;
lin metastaasi_N = mkkN "metastaasi" ;
lin metastaattinen_N = mkkN "metastaattinen" ;
lin metastasoida_V = mkkV "metastasoida" ;
lin metastasointi_N = mkkN "metastasointi" ;
lin meteli_N = mkkN "meteli" ;
lin metelo'ida'_V = mkkV "metelöidä" ;
lin metelo'ija'_N = mkkN "metelöijä" ;
lin metelo'inti_N = mkkN "metelöinti" ;
lin metelo'itsija'_N = mkkN "metelöitsijä" ;
lin meteori_N = mkkN "meteori" ;
lin meteoriitti_N = mkkN "meteoriitti" ;
lin meteoroidi_N = mkkN "meteoroidi" ;
lin meteorologi_N = mkkN "meteorologi" ;
lin meteorologia_N = mkkN "meteorologia" ;
lin meteorologinen_N = mkkN "meteorologinen" ;
lin metinen_N = mkkN "metinen" ;
lin metka_A = mkkA "metka" ;
lin metkasti_Adv = mkkAdv "metkasti" ;
lin metku_N = mkkN "metku" ;
lin metkuilla_V = mkkV "metkuilla" ;
lin metkuilu_N = mkkN "metkuilu" ;
lin metodi_N = mkkN "metodi" ;
lin metodiikka_N = mkkN "metodiikka" ;
lin metodinen_A = mkkA "metodinen" ;
lin metodisesti_Adv = mkkAdv "metodisesti" ;
lin metodismi_N = mkkN "metodismi" ;
lin metodisti_N = mkkN "metodisti" ;
lin metodistinen_N = mkkN "metodistinen" ;
lin metodologia_N = mkkN "metodologia" ;
lin metodologinen_N = mkkN "metodologinen" ;
lin metreitta'in_Adv = mkkAdv "metreittäin" ;
lin metri_N = mkkN "metri" ;
lin metri_N = mkkN "metri" ;
lin metriikka_N = mkkN "metriikka" ;
lin metrinen_N = mkkN "metrinen" ;
lin metro_N = mkkN "metro" ;
lin metrologia_N = mkkN "metrologia" ;
lin metrologinen_N = mkkN "metrologinen" ;
lin metronomi_N = mkkN "metronomi" ;
lin metropoliitta_N = mkkN "metropoliitta" ;
lin metsikko'_N = mkkN "metsikkö" ;
lin metsittya'_V = mkkV "metsittyä" ;
lin metsitta'a'_V = mkkV "metsittää" ;
lin metsitys_N = mkkN "metsitys" ;
lin metso_N = mkkN "metso" ;
lin metsuri_N = mkkN "metsuri" ;
lin metsa'_N = mkkN "metsä" ;
lin metsa'inen_N = mkkN "metsäinen" ;
lin metsa'kaartilaisuus_N = mkkN "metsäkaartilaisuus" ;
lin metsa'la'inen_N = mkkN "metsäläinen" ;
lin metsa'lo'_N = mkkN "metsälö" ;
lin metsa'narvioiminen_N = mkkN "metsänarvioiminen" ;
lin metsa'nhoidollisesti_Adv = mkkAdv "metsänhoidollisesti" ;
lin metsa'nleimaus_N = mkkN "metsänleimaus" ;
lin metsa'nraja_N = mkkN "metsänraja" ;
lin metsa'stella'_V = mkkV "metsästellä" ;
lin metsa'stys_N = mkkN "metsästys" ;
lin metsa'sta'ja'_N = mkkN "metsästäjä" ;
lin metsa'sta'a'_V = mkkV "metsästää" ;
lin mettinen_N = mkkN "mettinen" ;
lin metvursti_N = mkkN "metvursti" ;
lin meuhkata_V = mkkV "meuhkata" ;
lin mezzoforte_N = mkkN "mezzoforte" ;
lin mezzopiano_N = mkkN "mezzopiano" ;
lin mezzotinto_N = mkkN "mezzotinto" ;
lin mi_Adv = mkkAdv "mi" ;
lin miau_Adv = mkkAdv "miau" ;
lin midi_1_N = mkkN "midi" ;
lin midi_2_N = mkkN "midi" ;
lin miedonnos_N = mkkN "miedonnos" ;
lin miedonnus_N = mkkN "miedonnus" ;
lin miedontaa_V = mkkV "miedontaa" ;
lin miedontua_V = mkkV "miedontua" ;
lin miedosti_Adv = mkkAdv "miedosti" ;
lin miehekkyys_N = mkkN "miehekkyys" ;
lin miehekka'a'sti_Adv = mkkAdv "miehekkäästi" ;
lin mieheka's_A = mkkA "miehekäs" ;
lin miehela'ssa'_Adv = mkkAdv "miehelässä" ;
lin miehela'a'n_Adv = mkkAdv "miehelään" ;
lin miehennielija'_N = mkkN "miehennielijä" ;
lin miehevyys_N = mkkN "miehevyys" ;
lin mieheva'_A = mkkA "miehevä" ;
lin mieheva'sti_Adv = mkkAdv "miehevästi" ;
lin mieheys_N = mkkN "mieheys" ;
lin miehinen_N = mkkN "miehinen" ;
lin miehistya'_V = mkkV "miehistyä" ;
lin miehisto'_N = mkkN "miehistö" ;
lin miehisyys_N = mkkN "miehisyys" ;
lin miehittya'_V = mkkV "miehittyä" ;
lin miehitta'ja'_N = mkkN "miehittäjä" ;
lin miehitta'ma'to'n_N = mkkN "miehittämätön" ;
lin miehitta'a'_V = mkkV "miehittää" ;
lin miehitys_N = mkkN "miehitys" ;
lin miehusta_N = mkkN "miehusta" ;
lin miehuullinen_A = mkkA "miehuullinen" ;
lin miehuullisesti_Adv = mkkAdv "miehuullisesti" ;
lin miehuullisuus_N = mkkN "miehuullisuus" ;
lin miehuus_N = mkkN "miehuus" ;
lin miehyys_N = mkkN "miehyys" ;
lin miekannielija'_N = mkkN "miekannielijä" ;
lin miekka_N = mkkN "miekka" ;
lin miekkailija_N = mkkN "miekkailija" ;
lin miekkailla_V = mkkV "miekkailla" ;
lin miekkailu_N = mkkN "miekkailu" ;
lin miekkonen_N = mkkN "miekkonen" ;
lin mieleen_Adv = mkkAdv "mieleen" ;
lin mieleenjohtuma_N = mkkN "mieleenjohtuma" ;
lin mieleenpainuva_N = mkkN "mieleenpainuva" ;
lin mieleinen_N = mkkN "mieleinen" ;
lin mielekkyys_N = mkkN "mielekkyys" ;
lin mielekka'a'sti_Adv = mkkAdv "mielekkäästi" ;
lin mieleka's_A = mkkA "mielekäs" ;
lin mielella'a'n_Adv = mkkAdv "mielellään" ;
lin mielenkiinnoton_N = mkkN "mielenkiinnoton" ;
lin mielenkiinnottomasti_Adv = mkkAdv "mielenkiinnottomasti" ;
lin mielenkiinto_N = mkkN "mielenkiinto" ;
lin mielenkiintoinen_A = mkkA "mielenkiintoinen" ;
lin mielenkiintoisesti_Adv = mkkAdv "mielenkiintoisesti" ;
lin mielenkiintoisuus_N = mkkN "mielenkiintoisuus" ;
lin mielenosoituksellinen_A = mkkA "mielenosoituksellinen" ;
lin mielenosoituksellisesti_Adv = mkkAdv "mielenosoituksellisesti" ;
lin mielenterveydellisesti_Adv = mkkAdv "mielenterveydellisesti" ;
lin mielesta'_Adv = mkkAdv "mielestä" ;
lin mieletto'myys_N = mkkN "mielettömyys" ;
lin mieletto'ma'sti_Adv = mkkAdv "mielettömästi" ;
lin mieleto'n_N = mkkN "mieletön" ;
lin mieleva'_A = mkkA "mielevä" ;
lin mieleva'sti_Adv = mkkAdv "mielevästi" ;
lin mieli_N = mkkN "mieli" ;
lin mieliinpainuva_N = mkkN "mieliinpainuva" ;
lin mielikseen_Adv = mkkAdv "mielikseen" ;
lin mieliksi_Adv = mkkAdv "mieliksi" ;
lin mielikuvituksekas_A = mkkA "mielikuvituksekas" ;
lin mielikuvituksekkaasti_Adv = mkkAdv "mielikuvituksekkaasti" ;
lin mielikuvituksellinen_N = mkkN "mielikuvituksellinen" ;
lin mielikuvituksellisuus_N = mkkN "mielikuvituksellisuus" ;
lin mielinen_N = mkkN "mielinen" ;
lin mielin_kielin_Adv = mkkAdv "mieliC" ;
lin mielin_ma'a'rin_Adv = mkkAdv "mieliC" ;
lin mielipide_N = mkkN "mielipide" ;
lin mielipuolisesti_Adv = mkkAdv "mielipuolisesti" ;
lin mielipuolisuus_N = mkkN "mielipuolisuus" ;
lin mielisesti_Adv = mkkAdv "mielisesti" ;
lin mielissa'a'n_Adv = mkkAdv "mielissään" ;
lin mielistelija'_N = mkkN "mielistelijä" ;
lin mielistella'_V = mkkV "mielistellä" ;
lin mielistely_N = mkkN "mielistely" ;
lin mielistya'_V = mkkV "mielistyä" ;
lin mielisyys_N = mkkN "mielisyys" ;
lin mielitella'_V = mkkV "mielitellä" ;
lin mielivaltaisesti_Adv = mkkAdv "mielivaltaisesti" ;
lin mielia'_V = mkkV "mieliä" ;
lin mielle_N = mkkN "mielle" ;
lin miellytta'vyys_N = mkkN "miellyttävyys" ;
lin miellytta'va'_A = mkkA "miellyttävä" ;
lin miellytta'va'sti_Adv = mkkAdv "miellyttävästi" ;
lin miellytta'a'_V = mkkV "miellyttää" ;
lin mieltymys_N = mkkN "mieltymys" ;
lin mieltya'_V = mkkV "mieltyä" ;
lin mielta'a'_V = mkkV "mieltää" ;
lin mieluimmin_Adv = mkkAdv "mieluimmin" ;
lin mieluinen_A = mkkA "mieluinen" ;
lin mieluisa_A = mkkA "mieluisa" ;
lin mieluisasti_Adv = mkkAdv "mieluisasti" ;
lin mieluisesti_Adv = mkkAdv "mieluisesti" ;
lin mieluisuus_N = mkkN "mieluisuus" ;
lin mieluiten_Adv = mkkAdv "mieluiten" ;
lin mieluummin_Adv = mkkAdv "mieluummin" ;
lin mieluusti_Adv = mkkAdv "mieluusti" ;
lin miero_N = mkkN "miero" ;
lin mies_N = mkkN "mies" ;
lin mieskohtaisesti_Adv = mkkAdv "mieskohtaisesti" ;
lin mieslukuisesti_Adv = mkkAdv "mieslukuisesti" ;
lin miesmuistiin_Adv = mkkAdv "miesmuistiin" ;
lin miesma'inen_A = mkkA "miesmäinen" ;
lin miesma'isesti_Adv = mkkAdv "miesmäisesti" ;
lin miesma'isyys_N = mkkN "miesmäisyys" ;
lin miestennielija'_N = mkkN "miestennielijä" ;
lin miete_N = mkkN "miete" ;
lin mietelma'_N = mkkN "mietelmä" ;
lin mietinta'_N = mkkN "mietintä" ;
lin mietinta'aika_N = mkkN "mietintäaika" ;
lin mietinto'_N = mkkN "mietintö" ;
lin mietiskelija'_N = mkkN "mietiskelijä" ;
lin mietiskella'_V = mkkV "mietiskellä" ;
lin mietiskely_N = mkkN "mietiskely" ;
lin mietitytta'a'_V = mkkV "mietityttää" ;
lin mieto_N = mkkN "mieto" ;
lin mietous_N = mkkN "mietous" ;
lin mietteinen_N = mkkN "mietteinen" ;
lin miettelia'isyys_N = mkkN "mietteliäisyys" ;
lin miettelia's_A = mkkA "mietteliäs" ;
lin miettelia'a'sti_Adv = mkkAdv "mietteliäästi" ;
lin miettimisaika_N = mkkN "miettimisaika" ;
lin miettiva'inen_A = mkkA "miettiväinen" ;
lin miettiva'isesti_Adv = mkkAdv "miettiväisesti" ;
lin miettia'_V = mkkV "miettiä" ;
lin migmatiitti_N = mkkN "migmatiitti" ;
lin migraatio_N = mkkN "migraatio" ;
lin migreeni_N = mkkN "migreeni" ;
lin mihin_Adv = mkkAdv "mihin" ;
lin mihinkin_Adv = mkkAdv "mihinkin" ;
lin mihinka'_Adv = mkkAdv "mihinkä" ;
lin mihinka'a'n_Adv = mkkAdv "mihinkään" ;
lin miikka_N = mkkN "miikka" ;
lin miilu_N = mkkN "miilu" ;
lin miimikko_N = mkkN "miimikko" ;
lin miiminen_A = mkkA "miiminen" ;
lin miimisesti_Adv = mkkAdv "miimisesti" ;
lin miina_N = mkkN "miina" ;
lin miinaaja_N = mkkN "miinaaja" ;
lin miinata_V = mkkV "miinata" ;
lin miinoite_N = mkkN "miinoite" ;
lin miinoittaa_V = mkkV "miinoittaa" ;
lin miinoitus_N = mkkN "miinoitus" ;
lin miinus_N = mkkN "miinus" ;
lin miinustaa_V = mkkV "miinustaa" ;
lin miitinki_N = mkkN "miitinki" ;
lin mikkeli_N = mkkN "mikkeli" ;
lin mikki_N = mkkN "mikki" ;
lin mikko_N = mkkN "mikko" ;
lin mikro_N = mkkN "mikro" ;
lin mikrobi_N = mkkN "mikrobi" ;
lin mikrofoni_N = mkkN "mikrofoni" ;
lin mikroni_N = mkkN "mikroni" ;
lin mikroskooppi_N = mkkN "mikroskooppi" ;
lin mikroskooppinen_A = mkkA "mikroskooppinen" ;
lin mikroskooppisesti_Adv = mkkAdv "mikroskooppisesti" ;
lin mikroskopia_N = mkkN "mikroskopia" ;
lin mikroskopoida_V = mkkV "mikroskopoida" ;
lin mikroskopointi_N = mkkN "mikroskopointi" ;
lin mikrotomi_N = mkkN "mikrotomi" ;
lin miksaaja_N = mkkN "miksaaja" ;
lin miksata_V = mkkV "miksata" ;
lin miksaus_N = mkkN "miksaus" ;
lin mikseri_N = mkkN "mikseri" ;
lin miksi_Adv = mkkAdv "miksi" ;
lin mikstuura_N = mkkN "mikstuura" ;
lin mika'kin_Adv = mkkAdv "mikäkin" ;
lin mika'li_Adv = mkkAdv "mikäli" ;
lin miliisi_N = mkkN "miliisi" ;
lin militaarinen_N = mkkN "militaarinen" ;
lin militantti_N = mkkN "militantti" ;
lin militarismi_N = mkkN "militarismi" ;
lin militarisoida_V = mkkV "militarisoida" ;
lin militaristi_N = mkkN "militaristi" ;
lin militaristinen_N = mkkN "militaristinen" ;
lin milita'a'ri_N = mkkN "militääri" ;
lin milita'a'rinen_N = mkkN "militäärinen" ;
lin miljardi_N = mkkN "miljardi" ;
lin miljardo'o'ri_N = mkkN "miljardööri" ;
lin miljona'a'ri_N = mkkN "miljonääri" ;
lin miljoona_N = mkkN "miljoona" ;
lin miljoonainen_N = mkkN "miljoonainen" ;
lin miljoonas_N = mkkN "miljoonas" ;
lin miljoonikko_N = mkkN "miljoonikko" ;
lin miljoonittain_Adv = mkkAdv "miljoonittain" ;
lin miljo'o'_N = mkkN "miljöö" ;
lin milk_shake_N = mkkN "milC" ;
lin millainen_N = mkkN "millainen" ;
lin milli_N = mkkN "milli" ;
lin millinen_N = mkkN "millinen" ;
lin millivoltti_N = mkkN "millivoltti" ;
lin milloin_Adv = mkkAdv "milloin" ;
lin milloinka_Adv = mkkAdv "milloinka" ;
lin milloinkaan_Adv = mkkAdv "milloinkaan" ;
lin milloinkin_Adv = mkkAdv "milloinkin" ;
lin milla'nsa'ka'a'n_Adv = mkkAdv "millänsäkään" ;
lin milla'a'n_Adv = mkkAdv "millään" ;
lin milla'a'nka'a'n_Adv = mkkAdv "milläänkään" ;
lin miltei_Adv = mkkAdv "miltei" ;
lin mimiikka_N = mkkN "mimiikka" ;
lin mimmi_N = mkkN "mimmi" ;
lin mimmoinen_N = mkkN "mimmoinen" ;
lin mimoosa_N = mkkN "mimoosa" ;
lin minareetti_N = mkkN "minareetti" ;
lin minariini_N = mkkN "minariini" ;
lin mineraali_N = mkkN "mineraali" ;
lin mineraalinen_N = mkkN "mineraalinen" ;
lin mineraalistua_V = mkkV "mineraalistua" ;
lin mineralisoitua_V = mkkV "mineralisoitua" ;
lin mineralogi_N = mkkN "mineralogi" ;
lin mineralogia_N = mkkN "mineralogia" ;
lin mineraloginen_N = mkkN "mineraloginen" ;
lin minestrone_N = mkkN "minestrone" ;
lin mini_N = mkkN "mini" ;
lin miniatyristi_N = mkkN "miniatyristi" ;
lin miniatyyri_N = mkkN "miniatyyri" ;
lin miniatyyrikoko_N = mkkN "miniatyyrikoko" ;
lin minicross_N = mkkN "minicross" ;
lin minimalismi_N = mkkN "minimalismi" ;
lin minimalisti_N = mkkN "minimalisti" ;
lin minimalistinen_N = mkkN "minimalistinen" ;
lin minimi_N = mkkN "minimi" ;
lin minimiaika_N = mkkN "minimiaika" ;
lin minimikoko_N = mkkN "minimikoko" ;
lin minimoida_V = mkkV "minimoida" ;
lin minimointi_N = mkkN "minimointi" ;
lin ministeri_N = mkkN "ministeri" ;
lin ministeristo'_N = mkkN "ministeristö" ;
lin ministeriys_N = mkkN "ministeriys" ;
lin ministerio'_N = mkkN "ministeriö" ;
lin minia'_N = mkkN "miniä" ;
lin minkinlainen_N = mkkN "minkinlainen" ;
lin minkki_N = mkkN "minkki" ;
lin minka'lainen_N = mkkN "minkälainen" ;
lin minka'_takia_Adv = mkkAdv "minkC" ;
lin minka'_ta'hden_Adv = mkkAdv "minkC" ;
lin minka'_vuoksi_Adv = mkkAdv "minkC" ;
lin minka'a'nlainen_N = mkkN "minkäänlainen" ;
lin minne_Adv = mkkAdv "minne" ;
lin minnekin_Adv = mkkAdv "minnekin" ;
lin minneka'_Adv = mkkAdv "minnekä" ;
lin minneka'a'n_Adv = mkkAdv "minnekään" ;
lin minoriteetti_N = mkkN "minoriteetti" ;
lin minttu_N = mkkN "minttu" ;
lin minunlaiseni_N = mkkN "minunlaiseni" ;
lin minuus_N = mkkN "minuus" ;
lin minuuteittain_Adv = mkkAdv "minuuteittain" ;
lin minuutti_N = mkkN "minuutti" ;
lin minuuttinen_N = mkkN "minuuttinen" ;
lin mirha_N = mkkN "mirha" ;
lin mirhami_N = mkkN "mirhami" ;
lin mirri_N = mkkN "mirri" ;
lin misogynia_N = mkkN "misogynia" ;
lin misogyyni_N = mkkN "misogyyni" ;
lin misogyyninen_N = mkkN "misogyyninen" ;
lin mispeli_N = mkkN "mispeli" ;
lin miss_Adv = mkkAdv "miss" ;
lin missata_V = mkkV "missata" ;
lin misseys_N = mkkN "misseys" ;
lin missi_N = mkkN "missi" ;
lin missio_N = mkkN "missio" ;
lin missiys_N = mkkN "missiys" ;
lin misteli_N = mkkN "misteli" ;
lin mista'_Adv = mkkAdv "mistä" ;
lin mista'kin_Adv = mkkAdv "mistäkin" ;
lin mista'a'n_Adv = mkkAdv "mistään" ;
lin misu_N = mkkN "misu" ;
lin misa'a'ri_N = mkkN "misääri" ;
lin mitali_N = mkkN "mitali" ;
lin mitalisti_N = mkkN "mitalisti" ;
lin mitallinen_N = mkkN "mitallinen" ;
lin mitata_V = mkkV "mitata" ;
lin mitella_N = mkkN "mitella" ;
lin mitella'_V = mkkV "mitellä" ;
lin miten_Adv = mkkAdv "miten" ;
lin mitenkin_Adv = mkkAdv "mitenkin" ;
lin mitenka'_Adv = mkkAdv "mitenkä" ;
lin mitenka'a'n_Adv = mkkAdv "mitenkään" ;
lin miten_pa'in_Adv = mkkAdv "miteC" ;
lin mitoittaa_V = mkkV "mitoittaa" ;
lin mitoitus_N = mkkN "mitoitus" ;
lin mitoosi_N = mkkN "mitoosi" ;
lin mitoottinen_N = mkkN "mitoottinen" ;
lin mitra_N = mkkN "mitra" ;
lin mitta_N = mkkN "mitta" ;
lin mittaaja_N = mkkN "mittaaja" ;
lin mittaamaton_N = mkkN "mittaamaton" ;
lin mittaamattomasti_Adv = mkkAdv "mittaamattomasti" ;
lin mittaamattomuus_N = mkkN "mittaamattomuus" ;
lin mittailla_V = mkkV "mittailla" ;
lin mittailu_N = mkkN "mittailu" ;
lin mittain_N = mkkN "mittain" ;
lin mittainen_N = mkkN "mittainen" ;
lin mittakaavainen_N = mkkN "mittakaavainen" ;
lin mittari_N = mkkN "mittari" ;
lin mittaristo_N = mkkN "mittaristo" ;
lin mittaus_N = mkkN "mittaus" ;
lin mittauttaa_V = mkkV "mittauttaa" ;
lin mittava_N = mkkN "mittava" ;
lin mittavuus_N = mkkN "mittavuus" ;
lin mittely_N = mkkN "mittely" ;
lin mittelo'_N = mkkN "mittelö" ;
lin mita'_Adv = mkkAdv "mitä" ;
lin mita'tto'myys_N = mkkN "mitättömyys" ;
lin mita'to'ida'_V = mkkV "mitätöidä" ;
lin mita'to'inti_N = mkkN "mitätöinti" ;
lin mita'to'itya'_V = mkkV "mitätöityä" ;
lin mita'to'n_N = mkkN "mitätön" ;
lin mita'to'ntya'_V = mkkV "mitätöntyä" ;
lin mita'to'nta'a'_V = mkkV "mitätöntää" ;
lin moaree_N = mkkN "moaree" ;
lin mobata_V = mkkV "mobata" ;
lin mobbata_V = mkkV "mobbata" ;
lin mobbaus_N = mkkN "mobbaus" ;
lin mobile_N = mkkN "mobile" ;
lin mobilisaatio_N = mkkN "mobilisaatio" ;
lin mobilisoida_V = mkkV "mobilisoida" ;
lin mobilisointi_N = mkkN "mobilisointi" ;
lin mobiliteetti_N = mkkN "mobiliteetti" ;
lin modaali_N = mkkN "modaali" ;
lin modaalinen_N = mkkN "modaalinen" ;
lin modeemi_N = mkkN "modeemi" ;
lin moderato_N = mkkN "moderato" ;
lin moderni_A = mkkA "moderni" ;
lin modernismi_N = mkkN "modernismi" ;
lin modernisoida_V = mkkV "modernisoida" ;
lin modernisoitua_V = mkkV "modernisoitua" ;
lin modernistaa_V = mkkV "modernistaa" ;
lin modernisti_1_N = mkkN "modernisti" ;
lin modernisti_2_Adv = mkkAdv "modernisti" ;
lin modernistinen_N = mkkN "modernistinen" ;
lin modernistua_V = mkkV "modernistua" ;
lin modernius_N = mkkN "modernius" ;
lin modifikaatio_N = mkkN "modifikaatio" ;
lin modifioida_V = mkkV "modifioida" ;
lin modifiointi_N = mkkN "modifiointi" ;
lin modifioitua_V = mkkV "modifioitua" ;
lin modisti_N = mkkN "modisti" ;
lin modulaarinen_N = mkkN "modulaarinen" ;
lin modulaatio_N = mkkN "modulaatio" ;
lin modulaattori_N = mkkN "modulaattori" ;
lin moduloida_V = mkkV "moduloida" ;
lin modulointi_N = mkkN "modulointi" ;
lin moduloitua_V = mkkV "moduloitua" ;
lin modus_N = mkkN "modus" ;
lin moduuli_N = mkkN "moduuli" ;
lin moguli_N = mkkN "moguli" ;
lin mohair_N = mkkN "mohair" ;
lin mohikaani_N = mkkN "mohikaani" ;
lin moi_Adv = mkkAdv "moi" ;
lin moikaa_V = mkkV "moikaa" ;
lin moikata_V = mkkV "moikata" ;
lin moike_N = mkkN "moike" ;
lin moikua_V = mkkV "moikua" ;
lin moinen_N = mkkN "moinen" ;
lin moir__N = mkkN "moiré" ;
lin moisio_N = mkkN "moisio" ;
lin moiskahdus_N = mkkN "moiskahdus" ;
lin moiskahtaa_V = mkkV "moiskahtaa" ;
lin moiskaus_N = mkkN "moiskaus" ;
lin moiskauttaa_V = mkkV "moiskauttaa" ;
lin moite_N = mkkN "moite" ;
lin moiteaika_N = mkkN "moiteaika" ;
lin moitiskella_V = mkkV "moitiskella" ;
lin moitiskelu_N = mkkN "moitiskelu" ;
lin moitittava_A = mkkA "moitittava" ;
lin moitittavasti_Adv = mkkAdv "moitittavasti" ;
lin moitittavuus_N = mkkN "moitittavuus" ;
lin moitteeton_N = mkkN "moitteeton" ;
lin moitteettomasti_Adv = mkkAdv "moitteettomasti" ;
lin moitteettomuus_N = mkkN "moitteettomuus" ;
lin moittia_V = mkkV "moittia" ;
lin moittija_N = mkkN "moittija" ;
lin moittivasti_Adv = mkkAdv "moittivasti" ;
lin mojahdus_N = mkkN "mojahdus" ;
lin mojahtaa_V = mkkV "mojahtaa" ;
lin mojauttaa_V = mkkV "mojauttaa" ;
lin mojova_N = mkkN "mojova" ;
lin moka_N = mkkN "moka" ;
lin mokata_V = mkkV "mokata" ;
lin mokaus_N = mkkN "mokaus" ;
lin mokka_1_N = mkkN "mokka" ;
lin mokka_2_N = mkkN "mokka" ;
lin mokkainen_N = mkkN "mokkainen" ;
lin mokkasiini_N = mkkN "mokkasiini" ;
lin mokoma_N = mkkN "mokoma" ;
lin moksahdus_N = mkkN "moksahdus" ;
lin moksahtaa_V = mkkV "moksahtaa" ;
lin moksaus_N = mkkN "moksaus" ;
lin moksauttaa_V = mkkV "moksauttaa" ;
lin moksiskaan_Adv = mkkAdv "moksiskaan" ;
lin molaalisuus_N = mkkN "molaalisuus" ;
lin molaarinen_N = mkkN "molaarinen" ;
lin molaarisuus_N = mkkN "molaarisuus" ;
lin molari_N = mkkN "molari" ;
lin molekulaarinen_N = mkkN "molekulaarinen" ;
lin molekylaarinen_N = mkkN "molekylaarinen" ;
lin molekyyli_N = mkkN "molekyyli" ;
--? lin molemmat_NK = {s = d16A "molemmat" ;
lin molemminpuolisesti_Adv = mkkAdv "molemminpuolisesti" ;
lin molemminpuolisuus_N = mkkN "molemminpuolisuus" ;
lin mollata_V = mkkV "mollata" ;
lin mollaus_N = mkkN "mollaus" ;
lin molli_N = mkkN "molli" ;
lin mollottaa_V = mkkV "mollottaa" ;
lin molottaa_V = mkkV "molottaa" ;
lin molotus_N = mkkN "molotus" ;
lin molskahdella_V = mkkV "molskahdella" ;
lin molskahdus_N = mkkN "molskahdus" ;
lin molskahtaa_V = mkkV "molskahtaa" ;
lin molskaus_N = mkkN "molskaus" ;
lin molskauttaa_V = mkkV "molskauttaa" ;
lin molske_N = mkkN "molske" ;
lin molski_N = mkkN "molski" ;
lin molskia_V = mkkV "molskia" ;
lin molskina_N = mkkN "molskina" ;
lin molybdeeni_N = mkkN "molybdeeni" ;
lin momentaaninen_N = mkkN "momentaaninen" ;
lin momentti_N = mkkN "momentti" ;
lin monarkia_N = mkkN "monarkia" ;
lin monarkismi_N = mkkN "monarkismi" ;
lin monarkisti_N = mkkN "monarkisti" ;
lin monarkistinen_N = mkkN "monarkistinen" ;
lin monarkki_N = mkkN "monarkki" ;
lin monarkkinen_N = mkkN "monarkkinen" ;
lin monasti_Adv = mkkAdv "monasti" ;
lin monenlainen_N = mkkN "monenlainen" ;
lin monenmoinen_N = mkkN "monenmoinen" ;
lin monentaa_V = mkkV "monentaa" ;
lin mones_N = mkkN "mones" ;
lin monesti_Adv = mkkAdv "monesti" ;
lin monetaarinen_N = mkkN "monetaarinen" ;
lin monetarismi_N = mkkN "monetarismi" ;
lin monetaristi_N = mkkN "monetaristi" ;
lin monetaristinen_N = mkkN "monetaristinen" ;
lin moneus_N = mkkN "moneus" ;
lin mongerrus_N = mkkN "mongerrus" ;
lin mongertaa_V = mkkV "mongertaa" ;
lin mongoli_N = mkkN "mongoli" ;
lin mongolidi_N = mkkN "mongolidi" ;
lin mongolidinen_N = mkkN "mongolidinen" ;
lin mongolismi_N = mkkN "mongolismi" ;
lin mongoloidi_N = mkkN "mongoloidi" ;
lin moni_A = mkkA "moni" ;
lin moniaalla_Adv = mkkAdv "moniaalla" ;
lin moniaalle_Adv = mkkAdv "moniaalle" ;
lin moniaalta_Adv = mkkAdv "moniaalta" ;
lin monialaistua_V = mkkV "monialaistua" ;
lin monias_N = mkkN "monias" ;
lin moni_ilmeinen_N = mkkN "moni-ilmeinen" ;
lin monijumalaisuus_N = mkkN "monijumalaisuus" ;
lin monikansainen_N = mkkN "monikansainen" ;
lin monikko_N = mkkN "monikko" ;
lin monikollinen_N = mkkN "monikollinen" ;
lin monikollisuus_N = mkkN "monikollisuus" ;
lin monilukuisesti_Adv = mkkAdv "monilukuisesti" ;
lin monilukuisuus_N = mkkN "monilukuisuus" ;
lin monimielisesti_Adv = mkkAdv "monimielisesti" ;
lin monimuotoistua_V = mkkV "monimuotoistua" ;
lin monimutkaistaa_V = mkkV "monimutkaistaa" ;
lin monimutkaistua_V = mkkV "monimutkaistua" ;
lin moninaistaa_V = mkkV "moninaistaa" ;
lin moninaistua_V = mkkV "moninaistua" ;
lin moninkertaisesti_Adv = mkkAdv "moninkertaisesti" ;
lin monipersoonaisuus_N = mkkN "monipersoonaisuus" ;
lin monipuolisesti_Adv = mkkAdv "monipuolisesti" ;
lin monipuolistaa_V = mkkV "monipuolistaa" ;
lin monipuolistua_V = mkkV "monipuolistua" ;
lin monipuolisuus_N = mkkN "monipuolisuus" ;
lin monisanaisesti_Adv = mkkAdv "monisanaisesti" ;
lin monisatakertaisesti_Adv = mkkAdv "monisatakertaisesti" ;
lin monisikio'inen_N = mkkN "monisikiöinen" ;
lin monismi_N = mkkN "monismi" ;
lin monistaa_V = mkkV "monistaa" ;
lin monistamo_N = mkkN "monistamo" ;
lin moniste_N = mkkN "moniste" ;
lin monisti_N = mkkN "monisti" ;
lin monistinen_N = mkkN "monistinen" ;
lin monistua_V = mkkV "monistua" ;
lin monistus_N = mkkN "monistus" ;
lin monistuttaa_V = mkkV "monistuttaa" ;
lin monisa'rma'isyys_N = mkkN "monisärmäisyys" ;
lin monitasoisuus_N = mkkN "monitasoisuus" ;
lin monitieteisyys_N = mkkN "monitieteisyys" ;
lin monitoroida_V = mkkV "monitoroida" ;
lin monitorointi_N = mkkN "monitorointi" ;
lin monituhatkertaisesti_Adv = mkkAdv "monituhatkertaisesti" ;
lin monituinen_N = mkkN "monituinen" ;
lin monivaimoisuus_N = mkkN "monivaimoisuus" ;
lin monkua_V = mkkV "monkua" ;
lin mono_1_N = mkkN "mono" ;
lin mono_2_N = mkkN "mono" ;
lin monofonia_N = mkkN "monofonia" ;
lin monofoninen_N = mkkN "monofoninen" ;
lin monogaaminen_N = mkkN "monogaaminen" ;
lin monogamia_N = mkkN "monogamia" ;
lin monografia_N = mkkN "monografia" ;
lin monogrammi_N = mkkN "monogrammi" ;
lin monogynia_N = mkkN "monogynia" ;
lin monogyyninen_N = mkkN "monogyyninen" ;
lin monokkeli_N = mkkN "monokkeli" ;
lin monoliitti_N = mkkN "monoliitti" ;
lin monoliittinen_N = mkkN "monoliittinen" ;
lin monologi_N = mkkN "monologi" ;
lin monopolisoida_V = mkkV "monopolisoida" ;
lin monopolisoitua_V = mkkV "monopolisoitua" ;
lin monopolistinen_N = mkkN "monopolistinen" ;
lin monopoloida_V = mkkV "monopoloida" ;
lin monopoloitua_V = mkkV "monopoloitua" ;
lin monotonia_N = mkkN "monotonia" ;
lin monotoninen_A = mkkA "monotoninen" ;
lin monotonisesti_Adv = mkkAdv "monotonisesti" ;
lin monotonisuus_N = mkkN "monotonisuus" ;
lin monottaa_V = mkkV "monottaa" ;
lin monotypia_N = mkkN "monotypia" ;
lin monstrumi_N = mkkN "monstrumi" ;
lin monsuuni_N = mkkN "monsuuni" ;
lin monta_Adv = mkkAdv "monta" ;
lin montaa_Adv = mkkAdv "montaa" ;
lin montaasi_N = mkkN "montaasi" ;
lin montteerata_V = mkkV "montteerata" ;
lin monttu_N = mkkN "monttu" ;
lin montto'o'ri_N = mkkN "monttööri" ;
lin monumentaalinen_A = mkkA "monumentaalinen" ;
lin monumentaalisesti_Adv = mkkAdv "monumentaalisesti" ;
lin monumentaalisuus_N = mkkN "monumentaalisuus" ;
lin monumentti_N = mkkN "monumentti" ;
lin moodi_N = mkkN "moodi" ;
lin mooli_N = mkkN "mooli" ;
lin moolisuus_N = mkkN "moolisuus" ;
lin moottori_N = mkkN "moottori" ;
lin moottorillinen_N = mkkN "moottorillinen" ;
lin moottorinen_N = mkkN "moottorinen" ;
lin moottoroida_V = mkkV "moottoroida" ;
lin moottorointi_N = mkkN "moottorointi" ;
lin moottoroitua_V = mkkV "moottoroitua" ;
lin mopata_V = mkkV "mopata" ;
lin mopedi_N = mkkN "mopedi" ;
lin mopo_N = mkkN "mopo" ;
lin mopoilija_N = mkkN "mopoilija" ;
lin mopoilla_V = mkkV "mopoilla" ;
lin moppaus_N = mkkN "moppaus" ;
lin moppi_N = mkkN "moppi" ;
lin mopsi_N = mkkN "mopsi" ;
lin moraali_N = mkkN "moraali" ;
lin moraalinen_A = mkkA "moraalinen" ;
lin moraalisesti_Adv = mkkAdv "moraalisesti" ;
lin moraalisuus_N = mkkN "moraalisuus" ;
lin moraaliton_N = mkkN "moraaliton" ;
lin moraalittomasti_Adv = mkkAdv "moraalittomasti" ;
lin moraalittomuus_N = mkkN "moraalittomuus" ;
lin moralismi_N = mkkN "moralismi" ;
lin moralisoida_V = mkkV "moralisoida" ;
lin moralisointi_N = mkkN "moralisointi" ;
lin moralisti_N = mkkN "moralisti" ;
lin moralistinen_N = mkkN "moralistinen" ;
lin moraliteetti_N = mkkN "moraliteetti" ;
lin moratorio_N = mkkN "moratorio" ;
lin mordva_N = mkkN "mordva" ;
lin moreeni_N = mkkN "moreeni" ;
lin morfeemi_N = mkkN "morfeemi" ;
lin morfiini_N = mkkN "morfiini" ;
lin morfinismi_N = mkkN "morfinismi" ;
lin morfinisti_N = mkkN "morfinisti" ;
lin morfologia_N = mkkN "morfologia" ;
lin morfologinen_N = mkkN "morfologinen" ;
lin morjens_Adv = mkkAdv "morjens" ;
lin morjensta_Adv = mkkAdv "morjensta" ;
lin morjenstaa_V = mkkV "morjenstaa" ;
lin morjes_Adv = mkkAdv "morjes" ;
lin morjesta_Adv = mkkAdv "morjesta" ;
lin morjestaa_V = mkkV "morjestaa" ;
lin morkata_V = mkkV "morkata" ;
lin morkkaaja_N = mkkN "morkkaaja" ;
lin morkkaus_N = mkkN "morkkaus" ;
lin morkkis_N = mkkN "morkkis" ;
lin mormoni_N = mkkN "mormoni" ;
lin mormyska_N = mkkN "mormyska" ;
lin moro_1_N = mkkN "moro" ;
lin moro_2_Adv = mkkAdv "moro" ;
lin moron_Adv = mkkAdv "moron" ;
lin morsettaa_V = mkkV "morsettaa" ;
lin morsetus_N = mkkN "morsetus" ;
lin morsian_N = mkkN "morsian" ;
lin morsio_N = mkkN "morsio" ;
lin morsiuspari_N = mkkN "morsiuspari" ;
lin mortadella_N = mkkN "mortadella" ;
lin mortaliteetti_N = mkkN "mortaliteetti" ;
lin mortteli_N = mkkN "mortteli" ;
lin morula_N = mkkN "morula" ;
lin mosaiikki_N = mkkN "mosaiikki" ;
lin mosel_N = mkkN "mosel" ;
lin moska_N = mkkN "moska" ;
lin moskainen_N = mkkN "moskainen" ;
lin moskaisuus_N = mkkN "moskaisuus" ;
lin moskeija_N = mkkN "moskeija" ;
lin moskiitto_N = mkkN "moskiitto" ;
lin motata_V = mkkV "motata" ;
lin motelli_N = mkkN "motelli" ;
lin motetti_N = mkkN "motetti" ;
lin motiivi_N = mkkN "motiivi" ;
lin motittaa_V = mkkV "motittaa" ;
lin motivaatio_N = mkkN "motivaatio" ;
lin motivoida_V = mkkV "motivoida" ;
lin motivoimaton_N = mkkN "motivoimaton" ;
lin motivointi_N = mkkN "motivointi" ;
lin motivoitua_V = mkkV "motivoitua" ;
lin motkottaa_V = mkkV "motkottaa" ;
lin moto_N = mkkN "moto" ;
lin motocross_N = mkkN "motocross" ;
lin motoriikka_N = mkkN "motoriikka" ;
lin motorinen_N = mkkN "motorinen" ;
lin motorisoida_V = mkkV "motorisoida" ;
lin motorisoitua_V = mkkV "motorisoitua" ;
lin motskari_N = mkkN "motskari" ;
lin motti_1_N = mkkN "motti" ;
lin motti_2_N = mkkN "motti" ;
lin motto_N = mkkN "motto" ;
lin moukari_N = mkkN "moukari" ;
lin moukaroida_V = mkkV "moukaroida" ;
lin moukka_N = mkkN "moukka" ;
lin moukkamaisesti_Adv = mkkAdv "moukkamaisesti" ;
lin moukkamaisuus_N = mkkN "moukkamaisuus" ;
lin moukku_N = mkkN "moukku" ;
lin moukua_V = mkkV "moukua" ;
lin mouruta_V = mkkV "mouruta" ;
lin moussakas_N = mkkN "moussakas" ;
lin mousse_N = mkkN "mousse" ;
lin muassa_Adv = mkkAdv "muassa" ;
lin muffini_N = mkkN "muffini" ;
lin muhamettilainen_N = mkkN "muhamettilainen" ;
lin muhamettilaisuus_N = mkkN "muhamettilaisuus" ;
lin muhea_N = mkkN "muhea" ;
lin muhennos_N = mkkN "muhennos" ;
lin muhennus_N = mkkN "muhennus" ;
lin muhentaa_V = mkkV "muhentaa" ;
lin muhentua_V = mkkV "muhentua" ;
lin muheva_N = mkkN "muheva" ;
lin muhevuus_N = mkkN "muhevuus" ;
lin muhia_V = mkkV "muhia" ;
lin muhina_N = mkkN "muhina" ;
lin muhinoida_V = mkkV "muhinoida" ;
lin muhinointi_N = mkkN "muhinointi" ;
lin muhkea_A = mkkA "muhkea" ;
lin muhkeasti_Adv = mkkAdv "muhkeasti" ;
lin muhkeus_N = mkkN "muhkeus" ;
lin muhkura_N = mkkN "muhkura" ;
lin muhkurainen_N = mkkN "muhkurainen" ;
lin muhoilla_V = mkkV "muhoilla" ;
lin muhvi_N = mkkN "muhvi" ;
lin muija_N = mkkN "muija" ;
lin muikea_A = mkkA "muikea" ;
lin muikeasti_Adv = mkkAdv "muikeasti" ;
lin muikistaa_V = mkkV "muikistaa" ;
lin muikistella_V = mkkV "muikistella" ;
lin muikku_N = mkkN "muikku" ;
lin muiluttaa_V = mkkV "muiluttaa" ;
lin muiluttaja_N = mkkN "muiluttaja" ;
lin muilutus_N = mkkN "muilutus" ;
lin muinainen_N = mkkN "muinainen" ;
lin muinaisaika_N = mkkN "muinaisaika" ;
lin muinaisuus_N = mkkN "muinaisuus" ;
lin muinoin_Adv = mkkAdv "muinoin" ;
lin muinoinen_N = mkkN "muinoinen" ;
lin muiskauttaa_V = mkkV "muiskauttaa" ;
lin muisku_N = mkkN "muisku" ;
lin muistaa_V = mkkV "muistaa" ;
lin muistama_N = mkkN "muistama" ;
lin muistamaton_N = mkkN "muistamaton" ;
lin muistamattomuus_N = mkkN "muistamattomuus" ;
lin muistella_V = mkkV "muistella" ;
lin muistelma_N = mkkN "muistelma" ;
lin muistelo_N = mkkN "muistelo" ;
lin muistelu_N = mkkN "muistelu" ;
lin muistelus_N = mkkN "muistelus" ;
lin muistettava_N = mkkN "muistettava" ;
lin muisti_N = mkkN "muisti" ;
lin muistiinpanna_V = mkkV "muistiinpanna" ;
lin muistinen_N = mkkN "muistinen" ;
lin muistio_N = mkkN "muistio" ;
lin muistisuus_N = mkkN "muistisuus" ;
lin muistittomuus_N = mkkN "muistittomuus" ;
lin muisto_N = mkkN "muisto" ;
lin muistoinen_N = mkkN "muistoinen" ;
lin muistoisa_N = mkkN "muistoisa" ;
lin muistua_V = mkkV "muistua" ;
lin muistuma_N = mkkN "muistuma" ;
lin muistutella_V = mkkV "muistutella" ;
lin muistuttaa_V = mkkV "muistuttaa" ;
lin muistutus_N = mkkN "muistutus" ;
lin muka_Adv = mkkAdv "muka" ;
lin mukaa_Adv = mkkAdv "mukaa" ;
lin mukaan_Adv = mkkAdv "mukaan" ;
lin mukaan_luettuna_Adv = mkkAdv "mukaaC" ;
lin mukaan_lukien_Adv = mkkAdv "mukaaC" ;
lin mukaansatempaava_A = mkkA "mukaansatempaava" ;
lin mukaansatempaavasti_Adv = mkkAdv "mukaansatempaavasti" ;
lin mukaansatempaavuus_N = mkkN "mukaansatempaavuus" ;
lin mukaantua_V = mkkV "mukaantua" ;
lin mukaantuva_N = mkkN "mukaantuva" ;
lin mukaelma_N = mkkN "mukaelma" ;
lin mukailla_V = mkkV "mukailla" ;
lin mukailu_N = mkkN "mukailu" ;
lin mukainen_A = mkkA "mukainen" ;
lin mukaisesti_Adv = mkkAdv "mukaisesti" ;
lin mukaisuus_N = mkkN "mukaisuus" ;
lin mukamas_Adv = mkkAdv "mukamas" ;
lin mukana_Adv = mkkAdv "mukana" ;
lin mukauma_N = mkkN "mukauma" ;
lin mukauttaa_V = mkkV "mukauttaa" ;
lin mukautua_V = mkkV "mukautua" ;
lin mukautuma_N = mkkN "mukautuma" ;
lin mukautuva_N = mkkN "mukautuva" ;
lin mukautuvainen_N = mkkN "mukautuvainen" ;
lin mukautuvaisuus_N = mkkN "mukautuvaisuus" ;
lin mukautuvuus_N = mkkN "mukautuvuus" ;
lin mukava_A = mkkA "mukava" ;
lin mukavasti_Adv = mkkAdv "mukavasti" ;
lin mukavoittaa_V = mkkV "mukavoittaa" ;
lin mukavoitua_V = mkkV "mukavoitua" ;
lin mukavuus_N = mkkN "mukavuus" ;
lin muki_N = mkkN "muki" ;
lin mukiin_Adv = mkkAdv "mukiin" ;
lin mukiinmeneva'sti_Adv = mkkAdv "mukiinmenevästi" ;
lin mukillinen_N = mkkN "mukillinen" ;
lin mukiloida_V = mkkV "mukiloida" ;
lin mukilointi_N = mkkN "mukilointi" ;
lin mukina_N = mkkN "mukina" ;
lin mukista_V = mkkV "mukista" ;
lin mukkelis_makkelis_Adv = mkkAdv "mukkeliC" ;
lin muksahdus_N = mkkN "muksahdus" ;
lin muksahtaa_V = mkkV "muksahtaa" ;
lin muksaus_N = mkkN "muksaus" ;
lin muksauttaa_V = mkkV "muksauttaa" ;
lin muksia_V = mkkV "muksia" ;
lin muksu_N = mkkN "muksu" ;
lin mukula_N = mkkN "mukula" ;
lin mukulainen_N = mkkN "mukulainen" ;
lin mukulajuuri_N = mkkN "mukulajuuri" ;
lin mukuloida_V = mkkV "mukuloida" ;
lin mukura_N = mkkN "mukura" ;
lin mulahdus_N = mkkN "mulahdus" ;
lin mulahtaa_V = mkkV "mulahtaa" ;
lin mulatti_N = mkkN "mulatti" ;
lin muli_N = mkkN "muli" ;
lin muljahdella_V = mkkV "muljahdella" ;
lin muljahdus_N = mkkN "muljahdus" ;
lin muljahtaa_V = mkkV "muljahtaa" ;
lin muljaus_N = mkkN "muljaus" ;
lin muljautella_V = mkkV "muljautella" ;
lin muljauttaa_V = mkkV "muljauttaa" ;
lin mulkaista_V = mkkV "mulkaista" ;
lin mulkku_N = mkkN "mulkku" ;
lin mulkoilla_V = mkkV "mulkoilla" ;
lin mullas_N = mkkN "mullas" ;
lin mullata_V = mkkV "mullata" ;
lin mulli_N = mkkN "mulli" ;
lin mullikka_N = mkkN "mullikka" ;
lin mullin_mallin_Adv = mkkAdv "mulliC" ;
lin mullistaa_V = mkkV "mullistaa" ;
lin mullistava_A = mkkA "mullistava" ;
lin mullistavasti_Adv = mkkAdv "mullistavasti" ;
lin mullistavuus_N = mkkN "mullistavuus" ;
lin mullistua_V = mkkV "mullistua" ;
lin mullistus_N = mkkN "mullistus" ;
lin mullittaa_V = mkkV "mullittaa" ;
lin mullitus_N = mkkN "mullitus" ;
lin mullos_N = mkkN "mullos" ;
lin mulskahdus_N = mkkN "mulskahdus" ;
lin mulskahtaa_V = mkkV "mulskahtaa" ;
lin multa_N = mkkN "multa" ;
lin multaantua_V = mkkV "multaantua" ;
lin multainen_N = mkkN "multainen" ;
lin multaus_N = mkkN "multaus" ;
lin multautua_V = mkkV "multautua" ;
lin multava_N = mkkN "multava" ;
lin multavuus_N = mkkN "multavuus" ;
lin multilateraalinen_N = mkkN "multilateraalinen" ;
lin multippeli_N = mkkN "multippeli" ;
lin multivisio_N = mkkN "multivisio" ;
lin mumina_N = mkkN "mumina" ;
lin mumista_V = mkkV "mumista" ;
lin mummeli_N = mkkN "mummeli" ;
lin mummi_N = mkkN "mummi" ;
lin mummo_N = mkkN "mummo" ;
lin mummola_N = mkkN "mummola" ;
lin mummu_N = mkkN "mummu" ;
lin muna_N = mkkN "muna" ;
lin munainen_N = mkkN "munainen" ;
lin munakas_N = mkkN "munakas" ;
lin munankuori_N = mkkN "munankuori" ;
lin munaskuu_N = mkkN "munaskuu" ;
lin munata_V = mkkV "munata" ;
lin munaus_N = mkkN "munaus" ;
lin munavoi_N = mkkN "munavoi" ;
lin munia_V = mkkV "munia" ;
lin muninta_N = mkkN "muninta" ;
lin munittaa_V = mkkV "munittaa" ;
lin munitus_N = mkkN "munitus" ;
lin munkisto_N = mkkN "munkisto" ;
lin munkki_N = mkkN "munkki" ;
lin munkkius_N = mkkN "munkkius" ;
lin munuainen_N = mkkN "munuainen" ;
lin munuaiskera'nen_N = mkkN "munuaiskeränen" ;
lin munuaismainen_N = mkkN "munuaismainen" ;
lin muodikas_A = mkkA "muodikas" ;
lin muodikkaasti_Adv = mkkAdv "muodikkaasti" ;
lin muodikkuus_N = mkkN "muodikkuus" ;
lin muodistaa_V = mkkV "muodistaa" ;
lin muodokas_N = mkkN "muodokas" ;
lin muodollinen_A = mkkA "muodollinen" ;
lin muodollisesti_Adv = mkkAdv "muodollisesti" ;
lin muodollisuus_N = mkkN "muodollisuus" ;
lin muodonta_N = mkkN "muodonta" ;
lin muodontaa_V = mkkV "muodontaa" ;
lin muodostaa_V = mkkV "muodostaa" ;
lin muodostaja_N = mkkN "muodostaja" ;
lin muodoste_N = mkkN "muodoste" ;
lin muodosteilla_Adv = mkkAdv "muodosteilla" ;
lin muodostella_V = mkkV "muodostella" ;
lin muodostelma_N = mkkN "muodostelma" ;
lin muodostelu_N = mkkN "muodostelu" ;
lin muodostua_V = mkkV "muodostua" ;
lin muodostuma_N = mkkN "muodostuma" ;
lin muodostus_N = mkkN "muodostus" ;
lin muodota_V = mkkV "muodota" ;
lin muodoton_N = mkkN "muodoton" ;
lin muodottomuus_N = mkkN "muodottomuus" ;
lin muokata_V = mkkV "muokata" ;
lin muokattavuus_N = mkkN "muokattavuus" ;
lin muokkaaja_N = mkkN "muokkaaja" ;
lin muokkaantua_V = mkkV "muokkaantua" ;
lin muokkain_N = mkkN "muokkain" ;
lin muokkaus_N = mkkN "muokkaus" ;
lin muokkautua_V = mkkV "muokkautua" ;
lin muokkautuvuus_N = mkkN "muokkautuvuus" ;
lin muona_N = mkkN "muona" ;
lin muonittaa_V = mkkV "muonittaa" ;
lin muonittamo_N = mkkN "muonittamo" ;
lin muonitus_N = mkkN "muonitus" ;
lin muori_N = mkkN "muori" ;
lin muorinen_Adv = mkkAdv "muorinen" ;
lin muoti_N = mkkN "muoti" ;
lin muoto_N = mkkN "muoto" ;
lin muotoilija_N = mkkN "muotoilija" ;
lin muotoilla_V = mkkV "muotoilla" ;
lin muotoilu_N = mkkN "muotoilu" ;
lin muotoinen_N = mkkN "muotoinen" ;
lin muotoisuus_N = mkkN "muotoisuus" ;
lin muotoutua_V = mkkV "muotoutua" ;
lin muotoutuma_N = mkkN "muotoutuma" ;
lin muotti_N = mkkN "muotti" ;
lin muovaantua_V = mkkV "muovaantua" ;
lin muovailla_V = mkkV "muovailla" ;
lin muovailu_N = mkkN "muovailu" ;
lin muovata_V = mkkV "muovata" ;
lin muovauma_N = mkkN "muovauma" ;
lin muovaus_N = mkkN "muovaus" ;
lin muovautua_V = mkkV "muovautua" ;
lin muovautuma_N = mkkN "muovautuma" ;
lin muovautuva_N = mkkN "muovautuva" ;
lin muovautuvuus_N = mkkN "muovautuvuus" ;
lin muovi_N = mkkN "muovi" ;
lin muovinen_N = mkkN "muovinen" ;
lin muovittaa_V = mkkV "muovittaa" ;
lin muovitus_N = mkkN "muovitus" ;
lin mura_N = mkkN "mura" ;
lin murahdella_V = mkkV "murahdella" ;
lin murahdus_N = mkkN "murahdus" ;
lin murahtaa_V = mkkV "murahtaa" ;
lin murahtelu_N = mkkN "murahtelu" ;
lin muratti_N = mkkN "muratti" ;
lin murea_N = mkkN "murea" ;
lin mureena_N = mkkN "mureena" ;
lin murehduttaa_V = mkkV "murehduttaa" ;
lin murehtia_V = mkkV "murehtia" ;
lin mureke_N = mkkN "mureke" ;
lin muren_N = mkkN "muren" ;
lin murena_N = mkkN "murena" ;
lin murene_N = mkkN "murene" ;
lin murennus_N = mkkN "murennus" ;
lin murentaa_V = mkkV "murentaa" ;
lin murentua_V = mkkV "murentua" ;
lin mureta_V = mkkV "mureta" ;
lin mureus_N = mkkN "mureus" ;
lin mureuttaa_V = mkkV "mureuttaa" ;
lin mureutua_V = mkkV "mureutua" ;
lin murha_N = mkkN "murha" ;
lin murhaaja_N = mkkN "murhaaja" ;
lin murhaava_A = mkkA "murhaava" ;
lin murhaavasti_Adv = mkkAdv "murhaavasti" ;
lin murhata_V = mkkV "murhata" ;
lin murhauttaa_V = mkkV "murhauttaa" ;
lin murhe_N = mkkN "murhe" ;
lin murheellinen_A = mkkA "murheellinen" ;
lin murheellisesti_Adv = mkkAdv "murheellisesti" ;
lin murheellisuus_N = mkkN "murheellisuus" ;
lin murheenkryyni_N = mkkN "murheenkryyni" ;
lin murheinen_N = mkkN "murheinen" ;
lin murheissaan_Adv = mkkAdv "murheissaan" ;
lin murhemielelle_Adv = mkkAdv "murhemielelle" ;
lin murhemielella'_Adv = mkkAdv "murhemielellä" ;
lin murhemielin_Adv = mkkAdv "murhemielin" ;
lin murikka_N = mkkN "murikka" ;
lin murina_N = mkkN "murina" ;
lin murista_V = mkkV "murista" ;
lin murjaani_N = mkkN "murjaani" ;
lin murjaista_V = mkkV "murjaista" ;
lin murjoa_V = mkkV "murjoa" ;
lin murjottaa_V = mkkV "murjottaa" ;
lin murjottaja_N = mkkN "murjottaja" ;
lin murjotus_N = mkkN "murjotus" ;
lin murjoutua_V = mkkV "murjoutua" ;
lin murju_N = mkkN "murju" ;
lin murkina_N = mkkN "murkina" ;
lin murkinoida_V = mkkV "murkinoida" ;
lin murkinointi_N = mkkN "murkinointi" ;
lin murkku_1_N = mkkN "murkku" ;
lin murkku_2_N = mkkN "murkku" ;
lin murmeli_N = mkkN "murmeli" ;
lin muro_N = mkkN "muro" ;
lin murre_N = mkkN "murre" ;
lin murrokko_N = mkkN "murrokko" ;
lin murros_N = mkkN "murros" ;
lin murrosaika_N = mkkN "murrosaika" ;
lin murrostaa_V = mkkV "murrostaa" ;
lin murroste_N = mkkN "murroste" ;
lin murrostus_N = mkkN "murrostus" ;
lin murska_N = mkkN "murska" ;
lin murskaaja_N = mkkN "murskaaja" ;
lin murskaamo_N = mkkN "murskaamo" ;
lin murskaantua_V = mkkV "murskaantua" ;
lin murskaava_A = mkkA "murskaava" ;
lin murskaavasti_Adv = mkkAdv "murskaavasti" ;
lin murskain_N = mkkN "murskain" ;
lin murskaksi_Adv = mkkAdv "murskaksi" ;
lin murskana_Adv = mkkAdv "murskana" ;
lin murskata_V = mkkV "murskata" ;
lin murskaus_N = mkkN "murskaus" ;
lin murskautua_V = mkkV "murskautua" ;
lin murske_N = mkkN "murske" ;
lin mursu_N = mkkN "mursu" ;
lin murtaa_V = mkkV "murtaa" ;
lin murtaja_N = mkkN "murtaja" ;
lin murtautua_V = mkkV "murtautua" ;
lin murtautuja_N = mkkN "murtautuja" ;
lin murteellinen_A = mkkA "murteellinen" ;
lin murteellisesti_Adv = mkkAdv "murteellisesti" ;
lin murteellisuus_N = mkkN "murteellisuus" ;
lin murteinen_N = mkkN "murteinen" ;
lin murteisto_N = mkkN "murteisto" ;
lin murteittain_Adv = mkkAdv "murteittain" ;
lin murto_N = mkkN "murto" ;
lin murtokohta_N = mkkN "murtokohta" ;
lin murtsikka_N = mkkN "murtsikka" ;
lin murtua_V = mkkV "murtua" ;
lin murtuma_N = mkkN "murtuma" ;
lin murtumakohta_N = mkkN "murtumakohta" ;
lin murtumaton_N = mkkN "murtumaton" ;
lin murtumattomuus_N = mkkN "murtumattomuus" ;
lin murtuvuus_N = mkkN "murtuvuus" ;
lin muru_N = mkkN "muru" ;
lin muruinen_N = mkkN "muruinen" ;
lin murunen_N = mkkN "murunen" ;
lin murustaa_V = mkkV "murustaa" ;
lin murustua_V = mkkV "murustua" ;
lin musa_N = mkkN "musa" ;
lin musaka_N = mkkN "musaka" ;
lin museaalinen_N = mkkN "museaalinen" ;
lin museo_N = mkkN "museo" ;
lin museoida_V = mkkV "museoida" ;
lin museointi_N = mkkN "museointi" ;
lin museoitua_V = mkkV "museoitua" ;
lin musertaa_V = mkkV "musertaa" ;
lin musertava_N = mkkN "musertava" ;
lin musertua_V = mkkV "musertua" ;
lin musiikillinen_A = mkkA "musiikillinen" ;
lin musiikillisesti_Adv = mkkAdv "musiikillisesti" ;
lin musiikki_N = mkkN "musiikki" ;
lin musikaali_N = mkkN "musikaali" ;
lin musikaalinen_A = mkkA "musikaalinen" ;
lin musikaalisesti_Adv = mkkAdv "musikaalisesti" ;
lin musikaalisuus_N = mkkN "musikaalisuus" ;
lin musikantti_N = mkkN "musikantti" ;
lin musikka_N = mkkN "musikka" ;
lin musikologia_N = mkkN "musikologia" ;
lin musisoida_V = mkkV "musisoida" ;
lin musisointi_N = mkkN "musisointi" ;
lin muskatelli_N = mkkN "muskatelli" ;
lin muskatti_N = mkkN "muskatti" ;
lin muskeli_N = mkkN "muskeli" ;
lin musketti_N = mkkN "musketti" ;
lin musketo'o'ri_N = mkkN "musketööri" ;
lin muskotti_N = mkkN "muskotti" ;
lin musliini_N = mkkN "musliini" ;
lin muslimi_N = mkkN "muslimi" ;
lin mussu_N = mkkN "mussu" ;
lin mussuttaa_V = mkkV "mussuttaa" ;
lin must_Adv = mkkAdv "must" ;
lin musta_N = mkkN "musta" ;
lin mustajuuri_N = mkkN "mustajuuri" ;
lin mustamaalata_V = mkkV "mustamaalata" ;
lin mustangi_N = mkkN "mustangi" ;
lin mustasukkainen_A = mkkA "mustasukkainen" ;
lin mustasukkaisesti_Adv = mkkAdv "mustasukkaisesti" ;
lin mustasukkaisuus_N = mkkN "mustasukkaisuus" ;
lin mustata_V = mkkV "mustata" ;
lin muste_N = mkkN "muste" ;
lin mustelma_N = mkkN "mustelma" ;
lin mustenee_V = mkkV "mustenee" ;
lin mustentaa_V = mkkV "mustentaa" ;
lin musteta_V = mkkV "musteta" ;
lin mustikka_N = mkkN "mustikka" ;
lin mustikkainen_N = mkkN "mustikkainen" ;
lin mustua_V = mkkV "mustua" ;
lin mustuainen_N = mkkN "mustuainen" ;
lin mustuma_N = mkkN "mustuma" ;
lin mustuttaa_V = mkkV "mustuttaa" ;
lin mustuus_N = mkkN "mustuus" ;
lin mut_Adv = mkkAdv "mut" ;
lin muta_N = mkkN "muta" ;
lin mutaatio_N = mkkN "mutaatio" ;
lin mutageeninen_N = mkkN "mutageeninen" ;
lin mutageenisuus_N = mkkN "mutageenisuus" ;
lin mutainen_N = mkkN "mutainen" ;
lin mutantti_N = mkkN "mutantti" ;
lin mutatoitua_V = mkkV "mutatoitua" ;
lin mutina_N = mkkN "mutina" ;
lin mutista_V = mkkV "mutista" ;
lin mutka_N = mkkN "mutka" ;
lin mutkainen_N = mkkN "mutkainen" ;
lin mutkallinen_N = mkkN "mutkallinen" ;
lin mutkaton_N = mkkN "mutkaton" ;
lin mutkattomasti_Adv = mkkAdv "mutkattomasti" ;
lin mutkikas_A = mkkA "mutkikas" ;
lin mutkikkaasti_Adv = mkkAdv "mutkikkaasti" ;
lin mutkikkuus_N = mkkN "mutkikkuus" ;
lin mutkistaa_V = mkkV "mutkistaa" ;
lin mutkistua_V = mkkV "mutkistua" ;
lin mutkistuttaa_V = mkkV "mutkistuttaa" ;
lin mutkitella_V = mkkV "mutkitella" ;
lin mutristaa_V = mkkV "mutristaa" ;
lin mutristella_V = mkkV "mutristella" ;
lin mutruilla_V = mkkV "mutruilla" ;
lin mutrulla_Adv = mkkAdv "mutrulla" ;
lin mutrullaan_Adv = mkkAdv "mutrullaan" ;
lin mutrulle_Adv = mkkAdv "mutrulle" ;
lin mutrulleen_Adv = mkkAdv "mutrulleen" ;
lin mutrussa_Adv = mkkAdv "mutrussa" ;
lin mutruun_Adv = mkkAdv "mutruun" ;
lin mutsi_N = mkkN "mutsi" ;
lin mutta_Adv = mkkAdv "mutta" ;
lin mutteri_N = mkkN "mutteri" ;
lin mutu_1_N = mkkN "mutu" ;
lin mutu_2_N = mkkN "mutu" ;
lin mutustaa_V = mkkV "mutustaa" ;
lin mutustella_V = mkkV "mutustella" ;
lin mutustelu_N = mkkN "mutustelu" ;
lin muu_N = mkkN "muu" ;
lin muualla_Adv = mkkAdv "muualla" ;
lin muualle_Adv = mkkAdv "muualle" ;
lin muualta_Adv = mkkAdv "muualta" ;
lin muuanne_Adv = mkkAdv "muuanne" ;
lin muukalaisittain_Adv = mkkAdv "muukalaisittain" ;
lin muukalaispassi_N = mkkN "muukalaispassi" ;
lin muukalaistua_V = mkkV "muukalaistua" ;
lin muuli_N = mkkN "muuli" ;
lin muulloin_Adv = mkkAdv "muulloin" ;
lin muumio_N = mkkN "muumio" ;
lin muumioida_V = mkkV "muumioida" ;
lin muumioitua_V = mkkV "muumioitua" ;
lin muunlainen_N = mkkN "muunlainen" ;
lin muun_muassa_Adv = mkkAdv "muuC" ;
lin muunnella_V = mkkV "muunnella" ;
lin muunnelma_N = mkkN "muunnelma" ;
lin muunnin_N = mkkN "muunnin" ;
lin muunnos_N = mkkN "muunnos" ;
lin muuntaa_V = mkkV "muuntaa" ;
lin muuntaja_N = mkkN "muuntaja" ;
lin muuntamo_N = mkkN "muuntamo" ;
lin muuntautua_V = mkkV "muuntautua" ;
lin muuntelu_N = mkkN "muuntelu" ;
lin muunto_N = mkkN "muunto" ;
lin muuntokerroin_N = mkkN "muuntokerroin" ;
lin muuntua_V = mkkV "muuntua" ;
lin muurahainen_N = mkkN "muurahainen" ;
lin muurain_N = mkkN "muurain" ;
lin muurari_N = mkkN "muurari" ;
lin muurata_V = mkkV "muurata" ;
lin muuraus_N = mkkN "muuraus" ;
lin muurautua_V = mkkV "muurautua" ;
lin muuri_N = mkkN "muuri" ;
lin muurittaa_V = mkkV "muurittaa" ;
lin muusa_N = mkkN "muusa" ;
lin muusata_V = mkkV "muusata" ;
lin muusi_N = mkkN "muusi" ;
lin muusikko_N = mkkN "muusikko" ;
lin muusikkous_N = mkkN "muusikkous" ;
lin muutama_N = mkkN "muutama" ;
lin muutattaa_V = mkkV "muutattaa" ;
lin muutella_V = mkkV "muutella" ;
lin muuten_Adv = mkkAdv "muuten" ;
lin muutoin_Adv = mkkAdv "muutoin" ;
lin muutos_N = mkkN "muutos" ;
lin muuttaa_V = mkkV "muuttaa" ;
lin muuttaja_N = mkkN "muuttaja" ;
lin muutto_N = mkkN "muutto" ;
lin muuttoaika_N = mkkN "muuttoaika" ;
lin muuttua_V = mkkV "muuttua" ;
lin muuttuja_N = mkkN "muuttuja" ;
lin muuttuma_N = mkkN "muuttuma" ;
lin muuttumaton_N = mkkN "muuttumaton" ;
lin muuttumattomuus_N = mkkN "muuttumattomuus" ;
lin muuttuvainen_N = mkkN "muuttuvainen" ;
lin muuttuvaisuus_N = mkkN "muuttuvaisuus" ;
lin muuttuvuus_N = mkkN "muuttuvuus" ;
lin myhky_N = mkkN "myhky" ;
lin myhkyra'_N = mkkN "myhkyrä" ;
lin myha'hdella'_V = mkkV "myhähdellä" ;
lin myha'hdys_N = mkkN "myhähdys" ;
lin myha'hta'a'_V = mkkV "myhähtää" ;
lin myha'illa'_V = mkkV "myhäillä" ;
lin myha'ily_N = mkkN "myhäily" ;
lin mykero'_N = mkkN "mykerö" ;
lin mykistytta'a'_V = mkkV "mykistyttää" ;
lin mykistya'_V = mkkV "mykistyä" ;
lin mykista'a'_V = mkkV "mykistää" ;
lin mykio'_N = mkkN "mykiö" ;
lin mykkyra'_N = mkkN "mykkyrä" ;
lin mykkyys_N = mkkN "mykkyys" ;
lin mykka'_N = mkkN "mykkä" ;
lin mykologia_N = mkkN "mykologia" ;
lin mykorritsa_N = mkkN "mykorritsa" ;
lin myky_N = mkkN "myky" ;
lin myllerrys_N = mkkN "myllerrys" ;
lin myllerta'a'_V = mkkV "myllertää" ;
lin mylly_N = mkkN "mylly" ;
lin myllytta'a'_V = mkkV "myllyttää" ;
lin myllytys_N = mkkN "myllytys" ;
lin mylla'kka'_N = mkkN "mylläkkä" ;
lin mylla'ri_N = mkkN "mylläri" ;
lin mylla'ta'_V = mkkV "myllätä" ;
lin mylvinta'_N = mkkN "mylvintä" ;
lin mylvina'_N = mkkN "mylvinä" ;
lin mylvia'_V = mkkV "mylviä" ;
lin mylva'hdys_N = mkkN "mylvähdys" ;
lin mylva'hta'a'_V = mkkV "mylvähtää" ;
lin mynka'a'n_Adv = mkkAdv "mynkään" ;
lin myntti_N = mkkN "myntti" ;
lin myooma_N = mkkN "myooma" ;
lin myrha_N = mkkN "myrha" ;
lin myriadi_N = mkkN "myriadi" ;
lin myrkky_N = mkkN "myrkky" ;
lin myrkyllinen_A = mkkA "myrkyllinen" ;
lin myrkyllisesti_Adv = mkkAdv "myrkyllisesti" ;
lin myrkyllisyys_N = mkkN "myrkyllisyys" ;
lin myrkyttya'_V = mkkV "myrkyttyä" ;
lin myrkytta'a'_V = mkkV "myrkyttää" ;
lin myrkytys_N = mkkN "myrkytys" ;
lin myrkyto'n_N = mkkN "myrkytön" ;
lin myrsky_N = mkkN "myrsky" ;
lin myrskyinen_N = mkkN "myrskyinen" ;
lin myrskyisa'sti_Adv = mkkAdv "myrskyisästi" ;
lin myrskyta'_V = mkkV "myrskytä" ;
lin myrtsi_N = mkkN "myrtsi" ;
lin myrtti_N = mkkN "myrtti" ;
lin myrtya'_V = mkkV "myrtyä" ;
lin myra'kka'_N = mkkN "myräkkä" ;
lin myski_N = mkkN "myski" ;
lin mysli_N = mkkN "mysli" ;
lin myssy_N = mkkN "myssy" ;
lin mysteeri_N = mkkN "mysteeri" ;
lin mysteerio_N = mkkN "mysteerio" ;
lin mystifikaatio_N = mkkN "mystifikaatio" ;
lin mystifioida_V = mkkV "mystifioida" ;
lin mystifiointi_N = mkkN "mystifiointi" ;
lin mystiikka_N = mkkN "mystiikka" ;
lin mystikko_N = mkkN "mystikko" ;
lin mystinen_A = mkkA "mystinen" ;
lin mystisesti_Adv = mkkAdv "mystisesti" ;
lin mystisyys_N = mkkN "mystisyys" ;
lin mytologi_N = mkkN "mytologi" ;
lin mytologia_N = mkkN "mytologia" ;
lin mytologinen_N = mkkN "mytologinen" ;
lin mytty_N = mkkN "mytty" ;
lin myyda'_V = mkkV "myydä" ;
lin myyja'_N = mkkN "myyjä" ;
--? lin myyja'iset_NK = {s = d38 "myyjäiset" ;
lin myyja'ta'r_N = mkkN "myyjätär" ;
lin myyma'la'_N = mkkN "myymälä" ;
lin myynninedista'minen_N = mkkN "myynninedistäminen" ;
lin myynti_N = mkkN "myynti" ;
lin myyra'_N = mkkN "myyrä" ;
lin myytillinen_N = mkkN "myytillinen" ;
lin myytisto'_N = mkkN "myytistö" ;
lin myytti_N = mkkN "myytti" ;
lin myyttinen_N = mkkN "myyttinen" ;
lin myyttisyys_N = mkkN "myyttisyys" ;
lin myyty_N = mkkN "myyty" ;
lin myo'den_Adv = mkkAdv "myöden" ;
lin myo'da'_V = mkkV "myödä" ;
lin myo'da'ta'_V = mkkV "myödätä" ;
lin myo'hemmin_Adv = mkkAdv "myöhemmin" ;
lin myo'hemma'_Adv = mkkAdv "myöhemmä" ;
lin myo'hemma'ksi_Adv = mkkAdv "myöhemmäksi" ;
lin myo'hemma's_Adv = mkkAdv "myöhemmäs" ;
lin myo'hempa'a'n_Adv = mkkAdv "myöhempään" ;
lin myo'hentya'_V = mkkV "myöhentyä" ;
lin myo'henta'a'_V = mkkV "myöhentää" ;
lin myo'ha'_N = mkkN "myöhä" ;
lin myo'ha'inen_N = mkkN "myöhäinen" ;
lin myo'ha'iseen_Adv = mkkAdv "myöhäiseen" ;
lin myo'ha'isglasiaaliaika_N = mkkN "myöhäisglasiaaliaika" ;
lin myo'ha'isglasiaalinen_N = mkkN "myöhäisglasiaalinen" ;
lin myo'ha'isinta'a'n_Adv = mkkAdv "myöhäisintään" ;
lin myo'ha'iskeskiaika_N = mkkN "myöhäiskeskiaika" ;
lin myo'ha'lle_Adv = mkkAdv "myöhälle" ;
lin myo'ha'lla'_Adv = mkkAdv "myöhällä" ;
lin myo'ha'ssa'_Adv = mkkAdv "myöhässä" ;
lin myo'ha'stella'_V = mkkV "myöhästellä" ;
lin myo'ha'stymisaika_N = mkkN "myöhästymisaika" ;
lin myo'ha'stytta'a'_V = mkkV "myöhästyttää" ;
lin myo'ha'stya'_V = mkkV "myöhästyä" ;
lin myo'ha'a'n_Adv = mkkAdv "myöhään" ;
lin myo'nnella'_V = mkkV "myönnellä" ;
lin myo'nnytella'_V = mkkV "myönnytellä" ;
lin myo'nnytys_N = mkkN "myönnytys" ;
lin myo'nteinen_A = mkkA "myönteinen" ;
lin myo'nteisesti_Adv = mkkAdv "myönteisesti" ;
lin myo'nteisyys_N = mkkN "myönteisyys" ;
lin myo'ntymys_N = mkkN "myöntymys" ;
lin myo'ntyma'tto'myys_N = mkkN "myöntymättömyys" ;
lin myo'ntyma'to'n_N = mkkN "myöntymätön" ;
lin myo'ntyvyys_N = mkkN "myöntyvyys" ;
lin myo'ntyva'_A = mkkA "myöntyvä" ;
lin myo'ntyva'inen_N = mkkN "myöntyväinen" ;
lin myo'ntyva'sti_Adv = mkkAdv "myöntyvästi" ;
lin myo'ntya'_V = mkkV "myöntyä" ;
lin myo'nta'ja'_N = mkkN "myöntäjä" ;
lin myo'nta'va'_A = mkkA "myöntävä" ;
lin myo'nta'va'sti_Adv = mkkAdv "myöntävästi" ;
lin myo'nta'a'_V = mkkV "myöntää" ;
lin myo'nto'_N = mkkN "myöntö" ;
lin myo's_Adv = mkkAdv "myös" ;
lin myo'skin_Adv = mkkAdv "myöskin" ;
lin myo'ska'a'n_Adv = mkkAdv "myöskään" ;
lin myo'sta'a'_V = mkkV "myöstää" ;
lin myo'sto'_N = mkkN "myöstö" ;
lin myo'ten_Adv = mkkAdv "myöten" ;
lin myo'ta'_Adv = mkkAdv "myötä" ;
lin myo'ta'ilija'_N = mkkN "myötäilijä" ;
lin myo'ta'illa'_V = mkkV "myötäillä" ;
lin myo'ta'ily_N = mkkN "myötäily" ;
lin myo'ta'inen_A = mkkA "myötäinen" ;
lin myo'ta'isesti_Adv = mkkAdv "myötäisesti" ;
--? lin myo'ta'ja'iset_NK = {s = d38 "myötäjäiset" ;
lin myo'ta'karvaan_Adv = mkkAdv "myötäkarvaan" ;
lin myo'ta'le_N = mkkN "myötäle" ;
lin myo'ta'mielisesti_Adv = mkkAdv "myötämielisesti" ;
lin myo'ta'pa'iva'a'n_Adv = mkkAdv "myötäpäivään" ;
lin myo'ta'sukaan_Adv = mkkAdv "myötäsukaan" ;
lin myo'ta'tuntoisesti_Adv = mkkAdv "myötätuntoisesti" ;
lin myo'ta'a'nsa'_Adv = mkkAdv "myötäänsä" ;
lin ma'da'nnytta'a'_V = mkkV "mädännyttää" ;
lin ma'da'nna'inen_N = mkkN "mädännäinen" ;
lin ma'da'nna'isyys_N = mkkN "mädännäisyys" ;
lin ma'da'ntya'_V = mkkV "mädäntyä" ;
lin ma'da'tta'mo'_N = mkkN "mädättämö" ;
lin ma'da'tta'a'_V = mkkV "mädättää" ;
lin ma'da'tys_N = mkkN "mädätys" ;
lin ma'da'ta'_V = mkkV "mädätä" ;
lin ma'hka'_N = mkkN "mähkä" ;
lin ma'iha'_N = mkkN "mäihä" ;
lin ma'ike_N = mkkN "mäike" ;
lin ma'ikya'_V = mkkV "mäikyä" ;
lin ma'ika'a'_V = mkkV "mäikää" ;
lin ma'iske_N = mkkN "mäiske" ;
lin ma'iskia'_V = mkkV "mäiskiä" ;
lin ma'iskytta'a'_V = mkkV "mäiskyttää" ;
lin ma'iskytys_N = mkkN "mäiskytys" ;
lin ma'iskya'_V = mkkV "mäiskyä" ;
lin ma'iska'hdella'_V = mkkV "mäiskähdellä" ;
lin ma'iska'hdys_N = mkkN "mäiskähdys" ;
lin ma'iska'hta'a'_V = mkkV "mäiskähtää" ;
lin ma'iska'ys_N = mkkN "mäiskäys" ;
lin ma'iska'ytta'a'_V = mkkV "mäiskäyttää" ;
lin ma'iska'a'_V = mkkV "mäiskää" ;
lin ma'ja'hdella'_V = mkkV "mäjähdellä" ;
lin ma'ja'hdys_N = mkkN "mäjähdys" ;
lin ma'ja'hta'a'_V = mkkV "mäjähtää" ;
lin ma'ja'ys_N = mkkN "mäjäys" ;
lin ma'ja'ytta'a'_V = mkkV "mäjäyttää" ;
lin ma'ki_N = mkkN "mäki" ;
lin ma'kinen_N = mkkN "mäkinen" ;
lin ma'kisyys_N = mkkN "mäkisyys" ;
lin ma'ka'ra'_N = mkkN "mäkärä" ;
lin ma'ka'ra'inen_N = mkkN "mäkäräinen" ;
lin ma'ka'tta'a'_V = mkkV "mäkättää" ;
lin ma'ka'tys_N = mkkN "mäkätys" ;
lin ma'lli_1_N = mkkN "mälli" ;
lin ma'lli_2_N = mkkN "mälli" ;
lin ma'lla'ta'_V = mkkV "mällätä" ;
lin ma'lsa'_N = mkkN "mälsä" ;
lin ma'mmi_N = mkkN "mämmi" ;
lin ma'nnikko'_N = mkkN "männikkö" ;
lin ma'nnisto'_N = mkkN "männistö" ;
lin ma'ntti_1_N = mkkN "mäntti" ;
lin ma'ntti_2_N = mkkN "mäntti" ;
lin ma'nty_N = mkkN "mänty" ;
lin ma'ntyinen_N = mkkN "mäntyinen" ;
lin ma'nta'_N = mkkN "mäntä" ;
lin ma'rehtija'_N = mkkN "märehtijä" ;
lin ma'rehtia'_V = mkkV "märehtiä" ;
lin ma'rkile_N = mkkN "märkile" ;
lin ma'rkia'_V = mkkV "märkiä" ;
lin ma'rkyys_N = mkkN "märkyys" ;
lin ma'rka'_N = mkkN "märkä" ;
lin ma'rka'inen_N = mkkN "märkäinen" ;
lin ma'rssy_N = mkkN "märssy" ;
lin ma'sis_N = mkkN "mäsis" ;
lin ma'ski_N = mkkN "mäski" ;
lin ma'ska'ksi_Adv = mkkAdv "mäskäksi" ;
lin ma'ska'na'_Adv = mkkAdv "mäskänä" ;
lin ma'ska'ta'_V = mkkV "mäskätä" ;
lin ma'ska'ys_N = mkkN "mäskäys" ;
lin ma'ssytta'a'_V = mkkV "mässyttää" ;
lin ma'ssa'ilija'_N = mkkN "mässäilijä" ;
lin ma'ssa'illa'_V = mkkV "mässäillä" ;
lin ma'ssa'ily_N = mkkN "mässäily" ;
lin ma'ssa'ta'_V = mkkV "mässätä" ;
lin ma'ssa'ys_N = mkkN "mässäys" ;
lin ma'sa'_N = mkkN "mäsä" ;
lin ma'ti_N = mkkN "mäti" ;
lin ma'tkia'_V = mkkV "mätkiä" ;
lin ma'tky_N = mkkN "mätky" ;
lin ma'tka'hdella'_V = mkkV "mätkähdellä" ;
lin ma'tka'hdys_N = mkkN "mätkähdys" ;
lin ma'tka'hta'a'_V = mkkV "mätkähtää" ;
lin ma'tka'ista'_V = mkkV "mätkäistä" ;
lin ma'tka'ta'_V = mkkV "mätkätä" ;
lin ma'tka'ys_N = mkkN "mätkäys" ;
lin ma'tka'ytta'a'_V = mkkV "mätkäyttää" ;
lin ma'tka'ytys_N = mkkN "mätkäytys" ;
lin ma'tta'ikko'_N = mkkN "mättäikkö" ;
lin ma'tta'inen_N = mkkN "mättäinen" ;
lin ma'tta'a'_V = mkkV "mättää" ;
lin ma'ta'_N = mkkN "mätä" ;
lin ma'ta'inen_N = mkkN "mätäinen" ;
lin ma'ta's_N = mkkN "mätäs" ;
lin ma'ta'stys_N = mkkN "mätästys" ;
lin ma'ta'stya'_V = mkkV "mätästyä" ;
lin ma'ta'sta'va'_N = mkkN "mätästävä" ;
lin ma'ta'sta'a'_V = mkkV "mätästää" ;
lin ma'yra'_N = mkkN "mäyrä" ;
lin ma'ystin_N = mkkN "mäystin" ;
lin ma'a'inta'_N = mkkN "määintä" ;
lin ma'a'kina'_N = mkkN "määkinä" ;
lin ma'a'kia'_V = mkkV "määkiä" ;
lin ma'a'kya'_V = mkkV "määkyä" ;
lin ma'a're_N = mkkN "määre" ;
lin ma'a'rite_N = mkkN "määrite" ;
lin ma'a'ritella'_V = mkkV "määritellä" ;
lin ma'a'ritelma'_N = mkkN "määritelmä" ;
lin ma'a'rittelema'to'n_N = mkkN "määrittelemätön" ;
lin ma'a'rittely_N = mkkN "määrittely" ;
lin ma'a'ritta'a'_V = mkkV "määrittää" ;
lin ma'a'ritys_N = mkkN "määritys" ;
lin ma'a'rly_N = mkkN "määrly" ;
lin ma'a'ra'_N = mkkN "määrä" ;
lin ma'a'ra'aika_N = mkkN "määräaika" ;
lin ma'a'ra'ileva'_A = mkkA "määräilevä" ;
lin ma'a'ra'ileva'sti_Adv = mkkAdv "määräilevästi" ;
lin ma'a'ra'illa'_V = mkkV "määräillä" ;
lin ma'a'ra'ily_N = mkkN "määräily" ;
lin ma'a'ra'inen_A = mkkA "määräinen" ;
lin ma'a'ra'isesti_Adv = mkkAdv "määräisesti" ;
lin ma'a'ra'koko_N = mkkN "määräkoko" ;
lin ma'a'ra'llinen_A = mkkA "määrällinen" ;
lin ma'a'ra'llisesti_Adv = mkkAdv "määrällisesti" ;
lin ma'a'ra'tty_N = mkkN "määrätty" ;
lin ma'a'ra'tto'ma'sti_Adv = mkkAdv "määrättömästi" ;
lin ma'a'ra'ta'_V = mkkV "määrätä" ;
lin ma'a'ra'to'n_N = mkkN "määrätön" ;
lin ma'a'ra'ys_N = mkkN "määräys" ;
lin ma'a'ra'ytya'_V = mkkV "määräytyä" ;
lin ma'a'ra'a'ja'_N = mkkN "määrääjä" ;
lin ma'a'ra'a'ma'to'n_N = mkkN "määräämätön" ;
lin ma'a'ra'a'va'_A = mkkA "määräävä" ;
lin ma'a'ra'a'va'sti_Adv = mkkAdv "määräävästi" ;
lin mo'hka'le_N = mkkN "möhkäle" ;
lin mo'hlia'_V = mkkV "möhliä" ;
lin mo'hla'ta'_V = mkkV "möhlätä" ;
lin mo'hla'ys_N = mkkN "möhläys" ;
lin mo'kellys_N = mkkN "mökellys" ;
lin mo'kelta'a'_V = mkkV "mökeltää" ;
lin mo'kkeilla'_V = mkkV "mökkeillä" ;
lin mo'kkeily_N = mkkN "mökkeily" ;
lin mo'kki_N = mkkN "mökki" ;
lin mo'kkila'inen_N = mkkN "mökkiläinen" ;
lin mo'ka'_N = mkkN "mökä" ;
lin mo'ko'tta'ja'_N = mkkN "mököttäjä" ;
lin mo'ko'tta'a'_V = mkkV "mököttää" ;
lin mo'ko'tys_N = mkkN "mökötys" ;
lin mo'lina'_N = mkkN "mölinä" ;
lin mo'lista'_V = mkkV "mölistä" ;
lin mo'lli_N = mkkN "mölli" ;
lin mo'llo'tta'a'_V = mkkV "möllöttää" ;
lin mo'ly_N = mkkN "möly" ;
lin mo'lyta'_V = mkkV "mölytä" ;
lin mo'la'hdys_N = mkkN "mölähdys" ;
lin mo'la'hta'a'_V = mkkV "mölähtää" ;
lin mo'la'ytta'a'_V = mkkV "möläyttää" ;
lin mo'lo'tta'a'_V = mkkV "mölöttää" ;
lin mo'lo'tys_N = mkkN "mölötys" ;
lin mo'mmo'_N = mkkN "mömmö" ;
lin mo'nja'_N = mkkN "mönjä" ;
lin mo'nja'ta'_V = mkkV "mönjätä" ;
lin mo'nkija'_N = mkkN "mönkijä" ;
lin mo'nkia'_V = mkkV "mönkiä" ;
lin mo'nkia'inen_N = mkkN "mönkiäinen" ;
lin mo'nka'a'n_Adv = mkkAdv "mönkään" ;
lin mo'rea'_N = mkkN "möreä" ;
lin mo'rina'_N = mkkN "mörinä" ;
lin mo'rista'_V = mkkV "möristä" ;
lin mo'rkki_N = mkkN "mörkki" ;
lin mo'rko'_N = mkkN "mörkö" ;
lin mo'rsky_N = mkkN "mörsky" ;
lin mo'rska'_N = mkkN "mörskä" ;
lin mo'rssa'ri_N = mkkN "mörssäri" ;
lin mo'ra'hdys_N = mkkN "mörähdys" ;
lin mo'ra'hta'a'_V = mkkV "mörähtää" ;
lin mo'ra'kka'_N = mkkN "möräkkä" ;
lin mo'ro'ko'lli_N = mkkN "mörökölli" ;
lin mo'sso'_N = mkkN "mössö" ;
lin mo'tikka'_N = mkkN "mötikkä" ;
lin mo'tti_N = mkkN "mötti" ;
lin mo'yhennin_N = mkkN "möyhennin" ;
lin mo'yhennys_N = mkkN "möyhennys" ;
lin mo'yhenta'a'_V = mkkV "möyhentää" ;
lin mo'yhea'_N = mkkN "möyheä" ;
lin mo'yhia'_V = mkkV "möyhiä" ;
lin mo'yhy_N = mkkN "möyhy" ;
lin mo'ykky_N = mkkN "möykky" ;
lin mo'ykkyinen_N = mkkN "möykkyinen" ;
lin mo'ykka'_N = mkkN "möykkä" ;
lin mo'yka'ta'_V = mkkV "möykätä" ;
lin mo'yrinta'_N = mkkN "möyrintä" ;
lin mo'yrina'_N = mkkN "möyrinä" ;
lin mo'yria'_V = mkkV "möyriä" ;
lin mo'yryta'_V = mkkV "möyrytä" ;
lin mo'o'peli_N = mkkN "mööpeli" ;
lin naakka_N = mkkN "naakka" ;
lin naali_N = mkkN "naali" ;
lin naama_N = mkkN "naama" ;
lin naamainen_N = mkkN "naamainen" ;
lin naamari_N = mkkN "naamari" ;
--? lin naamiaiset_NK = {s = d38 "naamiaiset" ;
lin naamio_N = mkkN "naamio" ;
lin naamioida_V = mkkV "naamioida" ;
lin naamioija_N = mkkN "naamioija" ;
lin naamiointi_N = mkkN "naamiointi" ;
lin naamioitsija_N = mkkN "naamioitsija" ;
lin naamioitua_V = mkkV "naamioitua" ;
lin naapukka_N = mkkN "naapukka" ;
lin naapuri_N = mkkN "naapuri" ;
lin naapuristo_N = mkkN "naapuristo" ;
--? lin naapurukset_NK = {s = d39 "naapurukset" ;
lin naapurusto_N = mkkN "naapurusto" ;
lin naapuruus_N = mkkN "naapuruus" ;
lin naara_N = mkkN "naara" ;
lin naaras_N = mkkN "naaras" ;
lin naarata_V = mkkV "naarata" ;
lin naaraus_N = mkkN "naaraus" ;
lin naarmu_N = mkkN "naarmu" ;
lin naarmuinen_N = mkkN "naarmuinen" ;
lin naarmuttaa_V = mkkV "naarmuttaa" ;
lin naarmuttua_V = mkkV "naarmuttua" ;
lin naarmutus_N = mkkN "naarmutus" ;
lin naarmuuntua_V = mkkV "naarmuuntua" ;
lin naatti_N = mkkN "naatti" ;
lin naava_N = mkkN "naava" ;
lin naavainen_N = mkkN "naavainen" ;
lin naavoittua_V = mkkV "naavoittua" ;
lin nafta_N = mkkN "nafta" ;
lin naftaleeni_N = mkkN "naftaleeni" ;
lin naftaliini_N = mkkN "naftaliini" ;
lin nafti_A = mkkA "nafti" ;
lin naftisti_Adv = mkkAdv "naftisti" ;
lin nahas_N = mkkN "nahas" ;
lin nahikas_N = mkkN "nahikas" ;
lin nahina_N = mkkN "nahina" ;
lin nahinoida_V = mkkV "nahinoida" ;
lin nahinointi_N = mkkN "nahinointi" ;
lin nahista_V = mkkV "nahista" ;
lin nahistella_V = mkkV "nahistella" ;
lin nahistelu_N = mkkN "nahistelu" ;
lin nahistua_V = mkkV "nahistua" ;
lin nahjus_N = mkkN "nahjus" ;
lin nahjustella_V = mkkV "nahjustella" ;
lin nahka_N = mkkN "nahka" ;
lin nahkainen_N = mkkN "nahkainen" ;
lin nahkaisuus_N = mkkN "nahkaisuus" ;
lin nahkea_N = mkkN "nahkea" ;
lin nahkiainen_N = mkkN "nahkiainen" ;
lin nahkoa_V = mkkV "nahkoa" ;
lin nahkuri_N = mkkN "nahkuri" ;
lin nahoittaa_V = mkkV "nahoittaa" ;
lin nahoitus_N = mkkN "nahoitus" ;
lin naida_V = mkkV "naida" ;
lin naiivi_A = mkkA "naiivi" ;
lin naiivisti_Adv = mkkAdv "naiivisti" ;
lin naiivius_N = mkkN "naiivius" ;
lin naikkonen_N = mkkN "naikkonen" ;
lin nailon_N = mkkN "nailon" ;
lin nailoninen_N = mkkN "nailoninen" ;
lin naimaton_N = mkkN "naimaton" ;
lin naimattomuus_N = mkkN "naimattomuus" ;
lin naimisiin_Adv = mkkAdv "naimisiin" ;
lin naimisissa_Adv = mkkAdv "naimisissa" ;
lin nainen_N = mkkN "nainen" ;
lin nainti_N = mkkN "nainti" ;
lin nainut_N = mkkN "nainut" ;
lin naisellinen_A = mkkA "naisellinen" ;
lin naisellisesti_Adv = mkkAdv "naisellisesti" ;
lin naisellisuus_N = mkkN "naisellisuus" ;
lin naiseus_N = mkkN "naiseus" ;
lin naisisto_N = mkkN "naisisto" ;
lin naisistua_V = mkkV "naisistua" ;
lin naismainen_A = mkkA "naismainen" ;
lin naismaisesti_Adv = mkkAdv "naismaisesti" ;
lin naismaisuus_N = mkkN "naismaisuus" ;
lin naispari_N = mkkN "naispari" ;
lin naistennaurattaja_N = mkkN "naistennaurattaja" ;
lin naistenvihaaja_N = mkkN "naistenvihaaja" ;
lin naisuus_N = mkkN "naisuus" ;
lin naisvaltaistua_V = mkkV "naisvaltaistua" ;
lin naittaa_V = mkkV "naittaa" ;
lin naittaja_N = mkkN "naittaja" ;
lin naivismi_N = mkkN "naivismi" ;
lin naivisti_N = mkkN "naivisti" ;
lin naivistinen_N = mkkN "naivistinen" ;
lin nakata_V = mkkV "nakata" ;
lin nakella_V = mkkV "nakella" ;
lin nakerrella_V = mkkV "nakerrella" ;
lin nakerrus_N = mkkN "nakerrus" ;
lin nakertaa_V = mkkV "nakertaa" ;
lin nakkelu_N = mkkN "nakkelu" ;
lin nakki_1_N = mkkN "nakki" ;
lin nakki_2_N = mkkN "nakki" ;
lin nakki_3_N = mkkN "nakki" ;
lin nakki_4_N = mkkN "nakki" ;
lin naksaa_V = mkkV "naksaa" ;
lin naksahdella_V = mkkV "naksahdella" ;
lin naksahdus_N = mkkN "naksahdus" ;
lin naksahtaa_V = mkkV "naksahtaa" ;
lin naksaus_N = mkkN "naksaus" ;
lin naksautella_V = mkkV "naksautella" ;
lin naksauttaa_V = mkkV "naksauttaa" ;
lin naksautus_N = mkkN "naksautus" ;
lin naksu_N = mkkN "naksu" ;
lin naksua_V = mkkV "naksua" ;
lin naksutella_V = mkkV "naksutella" ;
lin naksuttaa_V = mkkV "naksuttaa" ;
lin naku_N = mkkN "naku" ;
lin nakutella_V = mkkV "nakutella" ;
lin nakuttaa_V = mkkV "nakuttaa" ;
lin nakutus_N = mkkN "nakutus" ;
lin naljailija_N = mkkN "naljailija" ;
lin naljailla_V = mkkV "naljailla" ;
lin naljailu_N = mkkN "naljailu" ;
lin nalkissa_Adv = mkkAdv "nalkissa" ;
lin nalkkiin_Adv = mkkAdv "nalkkiin" ;
lin nalkuttaa_V = mkkV "nalkuttaa" ;
lin nalkutus_N = mkkN "nalkutus" ;
lin nalle_N = mkkN "nalle" ;
lin nalli_1_N = mkkN "nalli" ;
lin nalli_2_N = mkkN "nalli" ;
lin nallikka_N = mkkN "nallikka" ;
lin nami_N = mkkN "nami" ;
lin namikka_N = mkkN "namikka" ;
lin namu_N = mkkN "namu" ;
lin namunen_N = mkkN "namunen" ;
lin nanna_N = mkkN "nanna" ;
lin napa_N = mkkN "napa" ;
lin napainen_N = mkkN "napainen" ;
lin napaisuus_N = mkkN "napaisuus" ;
lin napakasti_Adv = mkkAdv "napakasti" ;
lin napakka_N = mkkN "napakka" ;
lin napalm_N = mkkN "napalm" ;
lin napanteri_N = mkkN "napanteri" ;
lin napata_V = mkkV "napata" ;
lin napataatta_N = mkkN "napataatta" ;
lin napaus_N = mkkN "napaus" ;
lin napauttaa_V = mkkV "napauttaa" ;
lin napautus_N = mkkN "napautus" ;
lin napeerata_V = mkkV "napeerata" ;
lin napero_N = mkkN "napero" ;
lin napillinen_N = mkkN "napillinen" ;
lin napina_N = mkkN "napina" ;
lin napinla'pi_N = mkkN "napinläpi" ;
lin napisija_N = mkkN "napisija" ;
lin napista_V = mkkV "napista" ;
lin napittaa_V = mkkV "napittaa" ;
lin napitus_N = mkkN "napitus" ;
lin napostella_V = mkkV "napostella" ;
lin napostelu_N = mkkN "napostelu" ;
lin nappa_N = mkkN "nappa" ;
lin nappailla_V = mkkV "nappailla" ;
lin nappi_N = mkkN "nappi" ;
lin nappinen_N = mkkN "nappinen" ;
lin nappo_N = mkkN "nappo" ;
lin nappula_N = mkkN "nappula" ;
lin naprapaatti_N = mkkN "naprapaatti" ;
lin naprapatia_N = mkkN "naprapatia" ;
lin napsaa_V = mkkV "napsaa" ;
lin napsahdella_V = mkkV "napsahdella" ;
lin napsahdus_N = mkkN "napsahdus" ;
lin napsahtaa_V = mkkV "napsahtaa" ;
lin napsaus_N = mkkN "napsaus" ;
lin napsautella_V = mkkV "napsautella" ;
lin napsauttaa_V = mkkV "napsauttaa" ;
lin napsia_V = mkkV "napsia" ;
lin napsu_N = mkkN "napsu" ;
lin napsua_V = mkkV "napsua" ;
lin napsutella_V = mkkV "napsutella" ;
lin napsuttaa_V = mkkV "napsuttaa" ;
lin napukka_N = mkkN "napukka" ;
lin naputella_V = mkkV "naputella" ;
lin naputtaa_V = mkkV "naputtaa" ;
lin naputus_N = mkkN "naputus" ;
lin narahdella_V = mkkV "narahdella" ;
lin narahdus_N = mkkN "narahdus" ;
lin narahtaa_V = mkkV "narahtaa" ;
lin narauttaa_V = mkkV "narauttaa" ;
lin narikka_N = mkkN "narikka" ;
lin narina_N = mkkN "narina" ;
lin narista_V = mkkV "narista" ;
lin narisuttaa_V = mkkV "narisuttaa" ;
lin narkata_V = mkkV "narkata" ;
lin narkkari_N = mkkN "narkkari" ;
lin narkkaus_N = mkkN "narkkaus" ;
lin narkkis_N = mkkN "narkkis" ;
lin narkomaani_N = mkkN "narkomaani" ;
lin narkomania_N = mkkN "narkomania" ;
lin narkoosi_N = mkkN "narkoosi" ;
lin narkoottinen_N = mkkN "narkoottinen" ;
lin narrailla_V = mkkV "narrailla" ;
lin narrata_V = mkkV "narrata" ;
lin narraus_N = mkkN "narraus" ;
lin narri_N = mkkN "narri" ;
lin narrimaisesti_Adv = mkkAdv "narrimaisesti" ;
lin narrimaisuus_N = mkkN "narrimaisuus" ;
lin narrius_N = mkkN "narrius" ;
lin narsismi_N = mkkN "narsismi" ;
lin narsissi_N = mkkN "narsissi" ;
lin narsisti_N = mkkN "narsisti" ;
lin narsistinen_A = mkkA "narsistinen" ;
lin narsistisesti_Adv = mkkAdv "narsistisesti" ;
lin narsistisuus_N = mkkN "narsistisuus" ;
lin narskahdella_V = mkkV "narskahdella" ;
lin narskahdus_N = mkkN "narskahdus" ;
lin narskahtaa_V = mkkV "narskahtaa" ;
lin narskauttaa_V = mkkV "narskauttaa" ;
lin narske_N = mkkN "narske" ;
lin narsku_N = mkkN "narsku" ;
lin narskua_V = mkkV "narskua" ;
lin narskunta_N = mkkN "narskunta" ;
lin narskuttaa_V = mkkV "narskuttaa" ;
lin narskutus_N = mkkN "narskutus" ;
lin narttu_N = mkkN "narttu" ;
lin naru_N = mkkN "naru" ;
lin naruttaa_V = mkkV "naruttaa" ;
lin narutus_N = mkkN "narutus" ;
lin nasakka_N = mkkN "nasakka" ;
lin nasaretilainen_N = mkkN "nasaretilainen" ;
lin naseva_A = mkkA "naseva" ;
lin nasevasti_Adv = mkkAdv "nasevasti" ;
lin nasevoida_V = mkkV "nasevoida" ;
lin nasevoittaa_V = mkkV "nasevoittaa" ;
lin nasevoitua_V = mkkV "nasevoitua" ;
lin nasevuus_N = mkkN "nasevuus" ;
lin naskali_1_N = mkkN "naskali" ;
lin naskali_2_N = mkkN "naskali" ;
lin nassakka_N = mkkN "nassakka" ;
lin nasse_N = mkkN "nasse" ;
lin nassikka_N = mkkN "nassikka" ;
lin nassu_1_N = mkkN "nassu" ;
lin nassu_2_N = mkkN "nassu" ;
lin nasta_N = mkkN "nasta" ;
lin nastata_V = mkkV "nastata" ;
lin nastaus_N = mkkN "nastaus" ;
lin nastoittaa_V = mkkV "nastoittaa" ;
lin nastoitus_N = mkkN "nastoitus" ;
lin nasu_N = mkkN "nasu" ;
lin nata_N = mkkN "nata" ;
lin nataliteetti_N = mkkN "nataliteetti" ;
lin natina_N = mkkN "natina" ;
lin nationalismi_N = mkkN "nationalismi" ;
lin nationalisti_N = mkkN "nationalisti" ;
lin nationalistinen_N = mkkN "nationalistinen" ;
lin natista_V = mkkV "natista" ;
lin natisuttaa_V = mkkV "natisuttaa" ;
lin nato_N = mkkN "nato" ;
lin natrium_N = mkkN "natrium" ;
lin natriumkloridi_N = mkkN "natriumkloridi" ;
lin natsa_N = mkkN "natsa" ;
lin natsata_V = mkkV "natsata" ;
lin natsi_N = mkkN "natsi" ;
lin natsismi_N = mkkN "natsismi" ;
lin naturalismi_N = mkkN "naturalismi" ;
lin naturalisti_N = mkkN "naturalisti" ;
lin naturalistinen_N = mkkN "naturalistinen" ;
lin naturismi_N = mkkN "naturismi" ;
lin naturisti_N = mkkN "naturisti" ;
lin natustaa_V = mkkV "natustaa" ;
lin natustella_V = mkkV "natustella" ;
lin naudikas_N = mkkN "naudikas" ;
lin nauha_N = mkkN "nauha" ;
lin nauhoite_N = mkkN "nauhoite" ;
lin nauhoittaa_V = mkkV "nauhoittaa" ;
lin nauhoitus_N = mkkN "nauhoitus" ;
lin nauhuri_N = mkkN "nauhuri" ;
lin naukaista_V = mkkV "naukaista" ;
lin naukaisu_N = mkkN "naukaisu" ;
lin naukata_V = mkkV "naukata" ;
lin naukkailla_V = mkkV "naukkailla" ;
lin naukkailu_N = mkkN "naukkailu" ;
lin naukku_N = mkkN "naukku" ;
lin naukua_V = mkkV "naukua" ;
lin naula_N = mkkN "naula" ;
lin naulain_N = mkkN "naulain" ;
lin naulakko_N = mkkN "naulakko" ;
lin naulata_V = mkkV "naulata" ;
lin naulaus_N = mkkN "naulaus" ;
lin nauliintua_V = mkkV "nauliintua" ;
lin naulita_V = mkkV "naulita" ;
lin nauliutua_V = mkkV "nauliutua" ;
lin nauraa_V = mkkV "nauraa" ;
lin naurahdella_V = mkkV "naurahdella" ;
lin naurahdus_N = mkkN "naurahdus" ;
lin naurahtaa_V = mkkV "naurahtaa" ;
lin nauraja_N = mkkN "nauraja" ;
lin naurattaa_V = mkkV "naurattaa" ;
lin naurattaja_N = mkkN "naurattaja" ;
lin naureskella_V = mkkV "naureskella" ;
lin naureskelu_N = mkkN "naureskelu" ;
lin naurettava_A = mkkA "naurettava" ;
lin naurettavasti_Adv = mkkAdv "naurettavasti" ;
lin naurettavuus_N = mkkN "naurettavuus" ;
lin nauris_N = mkkN "nauris" ;
lin nauru_N = mkkN "nauru" ;
lin naurunalainen_N = mkkN "naurunalainen" ;
lin naurunalaistaa_V = mkkV "naurunalaistaa" ;
lin naurusuin_Adv = mkkAdv "naurusuin" ;
lin nauta_N = mkkN "nauta" ;
lin nautiikka_N = mkkN "nautiikka" ;
lin nautinnokas_N = mkkN "nautinnokas" ;
lin nautinnollinen_A = mkkA "nautinnollinen" ;
lin nautinnollisesti_Adv = mkkAdv "nautinnollisesti" ;
lin nautinnollisuus_N = mkkN "nautinnollisuus" ;
lin nautinta_N = mkkN "nautinta" ;
lin nautinta_aika_N = mkkN "nautinta-aika" ;
lin nautinto_N = mkkN "nautinto" ;
lin nautiskelija_N = mkkN "nautiskelija" ;
lin nautiskella_V = mkkV "nautiskella" ;
lin nautiskelu_N = mkkN "nautiskelu" ;
lin nautittava_A = mkkA "nautittava" ;
lin nautittavasti_Adv = mkkAdv "nautittavasti" ;
lin nautittavuus_N = mkkN "nautittavuus" ;
lin nauttia_V = mkkV "nauttia" ;
lin nauttija_N = mkkN "nauttija" ;
lin nau_unta_N = mkkN "nau'unta" ;
lin navaho_N = mkkN "navaho" ;
lin navajo_N = mkkN "navajo" ;
lin navakasti_Adv = mkkAdv "navakasti" ;
lin navakka_N = mkkN "navakka" ;
lin navakkuus_N = mkkN "navakkuus" ;
lin navakoitua_V = mkkV "navakoitua" ;
lin navallisuus_N = mkkN "navallisuus" ;
lin navetta_N = mkkN "navetta" ;
lin navigaatio_N = mkkN "navigaatio" ;
lin navigaattori_N = mkkN "navigaattori" ;
lin navigoida_V = mkkV "navigoida" ;
lin navigoija_N = mkkN "navigoija" ;
lin navigointi_N = mkkN "navigointi" ;
lin neekeri_N = mkkN "neekeri" ;
lin nega_N = mkkN "nega" ;
lin negaatio_N = mkkN "negaatio" ;
lin negatiivi_N = mkkN "negatiivi" ;
lin negatiivinen_A = mkkA "negatiivinen" ;
lin negatiivisesti_Adv = mkkAdv "negatiivisesti" ;
lin negatiivisuus_N = mkkN "negatiivisuus" ;
lin negridinen_N = mkkN "negridinen" ;
lin negrospirituaali_N = mkkN "negrospirituaali" ;
lin neiditella'_V = mkkV "neiditellä" ;
lin neilikka_N = mkkN "neilikka" ;
lin neiti_N = mkkN "neiti" ;
lin neito_N = mkkN "neito" ;
lin neitokainen_N = mkkN "neitokainen" ;
lin neitonen_N = mkkN "neitonen" ;
lin neitseellinen_A = mkkA "neitseellinen" ;
lin neitseellisesti_Adv = mkkAdv "neitseellisesti" ;
lin neitseellisyys_N = mkkN "neitseellisyys" ;
lin neitsyt_N = mkkN "neitsyt" ;
lin neitsyys_N = mkkN "neitsyys" ;
lin nekku_N = mkkN "nekku" ;
lin nekrologi_N = mkkN "nekrologi" ;
lin nekroosi_N = mkkN "nekroosi" ;
lin nekroottinen_N = mkkN "nekroottinen" ;
lin nekrotisoitua_V = mkkV "nekrotisoitua" ;
lin nekru_N = mkkN "nekru" ;
lin nektari_N = mkkN "nektari" ;
lin nektariini_N = mkkN "nektariini" ;
lin neli_1_N = mkkN "neli" ;
lin nelikanavainen_N = mkkN "nelikanavainen" ;
lin nelikko_N = mkkN "nelikko" ;
lin nelikko'_N = mkkN "nelikkö" ;
lin nelika'tisesti_Adv = mkkAdv "nelikätisesti" ;
lin nelilappeinen_N = mkkN "nelilappeinen" ;
lin nelilo'_N = mkkN "nelilö" ;
lin nelinkertaisesti_Adv = mkkAdv "nelinkertaisesti" ;
lin nelinkertaistaa_V = mkkV "nelinkertaistaa" ;
lin nelinkertaistua_V = mkkV "nelinkertaistua" ;
lin nelinkontin_Adv = mkkAdv "nelinkontin" ;
lin nelipyo'ra'veto_N = mkkN "nelipyöräveto" ;
lin nelisen_Adv = mkkAdv "nelisen" ;
lin nelisenkymmenta'_Adv = mkkAdv "nelisenkymmentä" ;
lin nelisin_Adv = mkkAdv "nelisin" ;
lin neliskanttinen_N = mkkN "neliskanttinen" ;
lin nelista'a'_V = mkkV "nelistää" ;
lin nelista'a'n_Adv = mkkAdv "nelistään" ;
lin nelitta'in_Adv = mkkAdv "nelittäin" ;
lin nelia'a'nisesti_Adv = mkkAdv "neliäänisesti" ;
lin nelio'_N = mkkN "neliö" ;
lin nelio'ida'_V = mkkV "neliöidä" ;
lin nelio'inti_N = mkkN "neliöinti" ;
lin nelio'itta'in_Adv = mkkAdv "neliöittäin" ;
lin nelio'juuri_N = mkkN "neliöjuuri" ;
lin nelja'_N = mkkN "neljä" ;
lin nelja'ka's_N = mkkN "neljäkäs" ;
lin nelja'nnes_N = mkkN "neljännes" ;
lin nelja's_N = mkkN "neljäs" ;
lin nelja'sti_Adv = mkkAdv "neljästi" ;
lin nelja'sta'a'n_Adv = mkkAdv "neljästään" ;
lin nelkku_N = mkkN "nelkku" ;
lin nelonen_N = mkkN "nelonen" ;
lin nelson_N = mkkN "nelson" ;
lin nenetsi_N = mkkN "nenetsi" ;
lin nenu_N = mkkN "nenu" ;
lin nena'_N = mkkN "nenä" ;
lin nena'inen_N = mkkN "nenäinen" ;
lin nena'kkyys_N = mkkN "nenäkkyys" ;
lin nena'kka'in_Adv = mkkAdv "nenäkkäin" ;
lin nena'kka'a'sti_Adv = mkkAdv "nenäkkäästi" ;
lin nena'ka's_A = mkkA "nenäkäs" ;
lin nena'njuuri_N = mkkN "nenänjuuri" ;
lin nena'tti_N = mkkN "nenätti" ;
lin nena'tysten_Adv = mkkAdv "nenätysten" ;
lin neodyymi_N = mkkN "neodyymi" ;
lin neoliittinen_N = mkkN "neoliittinen" ;
lin neologismi_N = mkkN "neologismi" ;
lin neon_N = mkkN "neon" ;
lin nepata_V = mkkV "nepata" ;
lin nepitta'a'_V = mkkV "nepittää" ;
lin nepotismi_N = mkkN "nepotismi" ;
lin neppari_N = mkkN "neppari" ;
lin neppaus_N = mkkN "neppaus" ;
lin neppi_N = mkkN "neppi" ;
lin nero_N = mkkN "nero" ;
lin nerokas_A = mkkA "nerokas" ;
lin nerokkaasti_Adv = mkkAdv "nerokkaasti" ;
lin nerokkuus_N = mkkN "nerokkuus" ;
lin neronleimaus_N = mkkN "neronleimaus" ;
lin nerous_N = mkkN "nerous" ;
lin nesessa'a'ri_N = mkkN "nesessääri" ;
lin neste_N = mkkN "neste" ;
lin nesteinen_N = mkkN "nesteinen" ;
lin nestema'inen_N = mkkN "nestemäinen" ;
lin nesteytin_N = mkkN "nesteytin" ;
lin nesteytta'a'_V = mkkV "nesteyttää" ;
lin nesteytys_N = mkkN "nesteytys" ;
lin nesteytya'_V = mkkV "nesteytyä" ;
lin nestor_N = mkkN "nestor" ;
lin netiketti_N = mkkN "netiketti" ;
lin netota_V = mkkV "netota" ;
lin netto_N = mkkN "netto" ;
lin nettoaika_N = mkkN "nettoaika" ;
lin neukku_N = mkkN "neukku" ;
lin neula_N = mkkN "neula" ;
lin neulanen_N = mkkN "neulanen" ;
lin neulasisto_N = mkkN "neulasisto" ;
lin neulasto_N = mkkN "neulasto" ;
lin neulata_V = mkkV "neulata" ;
lin neule_N = mkkN "neule" ;
lin neuleinen_N = mkkN "neuleinen" ;
lin neuloa_V = mkkV "neuloa" ;
lin neuloja_N = mkkN "neuloja" ;
lin neulomus_N = mkkN "neulomus" ;
lin neulonta_N = mkkN "neulonta" ;
lin neulos_N = mkkN "neulos" ;
lin neuluri_N = mkkN "neuluri" ;
lin neuralgia_N = mkkN "neuralgia" ;
lin neuralginen_N = mkkN "neuralginen" ;
lin neurasteenikko_N = mkkN "neurasteenikko" ;
lin neurasteeninen_N = mkkN "neurasteeninen" ;
lin neurastenia_N = mkkN "neurastenia" ;
lin neuriitti_N = mkkN "neuriitti" ;
lin neurologi_N = mkkN "neurologi" ;
lin neurologia_N = mkkN "neurologia" ;
lin neurologinen_N = mkkN "neurologinen" ;
lin neuroni_N = mkkN "neuroni" ;
lin neuroosi_N = mkkN "neuroosi" ;
lin neurootikko_N = mkkN "neurootikko" ;
lin neuroottinen_N = mkkN "neuroottinen" ;
lin neuroottistua_V = mkkV "neuroottistua" ;
lin neuroottisuus_N = mkkN "neuroottisuus" ;
lin neurotisoitua_V = mkkV "neurotisoitua" ;
lin neutraali_A = mkkA "neutraali" ;
lin neutraalistaa_V = mkkV "neutraalistaa" ;
lin neutraalisti_Adv = mkkAdv "neutraalisti" ;
lin neutraalistua_V = mkkV "neutraalistua" ;
lin neutraalisuus_N = mkkN "neutraalisuus" ;
lin neutraalius_N = mkkN "neutraalius" ;
lin neutralisaatio_N = mkkN "neutralisaatio" ;
lin neutralisoida_V = mkkV "neutralisoida" ;
lin neutralisoitua_V = mkkV "neutralisoitua" ;
lin neutraliteetti_N = mkkN "neutraliteetti" ;
lin neutraloida_V = mkkV "neutraloida" ;
lin neutralointi_N = mkkN "neutralointi" ;
lin neutraloitua_V = mkkV "neutraloitua" ;
lin neutri_N = mkkN "neutri" ;
lin neutriino_N = mkkN "neutriino" ;
lin neutroni_N = mkkN "neutroni" ;
lin neuvo_N = mkkN "neuvo" ;
lin neuvoa_V = mkkV "neuvoa" ;
lin neuvoa_antava_N = mkkN "neuvoa-antava" ;
lin neuvoinen_N = mkkN "neuvoinen" ;
lin neuvoja_N = mkkN "neuvoja" ;
lin neuvokas_A = mkkA "neuvokas" ;
lin neuvokkaasti_Adv = mkkAdv "neuvokkaasti" ;
lin neuvokki_N = mkkN "neuvokki" ;
lin neuvokkuus_N = mkkN "neuvokkuus" ;
lin neuvoksetar_N = mkkN "neuvoksetar" ;
lin neuvola_N = mkkN "neuvola" ;
lin neuvonta_N = mkkN "neuvonta" ;
lin neuvos_N = mkkN "neuvos" ;
lin neuvosto_N = mkkN "neuvosto" ;
lin neuvotella_V = mkkV "neuvotella" ;
lin neuvoton_N = mkkN "neuvoton" ;
lin neuvotteilla_Adv = mkkAdv "neuvotteilla" ;
lin neuvottelija_N = mkkN "neuvottelija" ;
lin neuvottelu_N = mkkN "neuvottelu" ;
lin neuvottomuus_N = mkkN "neuvottomuus" ;
lin neva_N = mkkN "neva" ;
lin nevoittua_V = mkkV "nevoittua" ;
lin newton_N = mkkN "newton" ;
lin nide_N = mkkN "nide" ;
lin nidoksinen_N = mkkN "nidoksinen" ;
lin nidoksittain_Adv = mkkAdv "nidoksittain" ;
lin nidonta_N = mkkN "nidonta" ;
lin nidos_N = mkkN "nidos" ;
lin niekka_N = mkkN "niekka" ;
lin nielaista_V = mkkV "nielaista" ;
lin nielaisu_N = mkkN "nielaisu" ;
lin nielaus_N = mkkN "nielaus" ;
lin nieleksia'_V = mkkV "nieleksiä" ;
lin nieleskella'_V = mkkV "nieleskellä" ;
lin niella'_V = mkkV "niellä" ;
lin nielu_N = mkkN "nielu" ;
lin nieluinen_N = mkkN "nieluinen" ;
lin niemeke_N = mkkN "niemeke" ;
lin niemi_N = mkkN "niemi" ;
lin nieria'_N = mkkN "nieriä" ;
lin nietos_N = mkkN "nietos" ;
lin nietostaa_V = mkkV "nietostaa" ;
lin nietostua_V = mkkV "nietostua" ;
lin nihilismi_N = mkkN "nihilismi" ;
lin nihilisti_N = mkkN "nihilisti" ;
lin nihilistinen_N = mkkN "nihilistinen" ;
lin nihkeys_N = mkkN "nihkeys" ;
lin nihkea'_A = mkkA "nihkeä" ;
lin nihkea'sti_Adv = mkkAdv "nihkeästi" ;
lin nihti_N = mkkN "nihti" ;
lin niiata_V = mkkV "niiata" ;
lin niiaus_N = mkkN "niiaus" ;
lin niin_Adv = mkkAdv "niin" ;
lin niini_N = mkkN "niini" ;
lin niin_ika'a'n_Adv = mkkAdv "niiC" ;
lin niininen_N = mkkN "niininen" ;
lin niinku_Adv = mkkAdv "niinku" ;
lin niin_kuin_Adv = mkkAdv "niiC" ;
lin niin_pa'in_Adv = mkkAdv "niiC" ;
lin niin_sanotusti_Adv = mkkAdv "niiC" ;
lin niisi_N = mkkN "niisi" ;
lin niisitta'a'_V = mkkV "niisittää" ;
lin niisitys_N = mkkN "niisitys" ;
lin niisia'_V = mkkV "niisiä" ;
lin niiskauttaa_V = mkkV "niiskauttaa" ;
lin niiskuttaa_V = mkkV "niiskuttaa" ;
lin niiskutus_N = mkkN "niiskutus" ;
lin niista'a'_V = mkkV "niistää" ;
lin niitata_V = mkkV "niitata" ;
lin niitinen_N = mkkN "niitinen" ;
lin niittaus_N = mkkN "niittaus" ;
lin niitti_N = mkkN "niitti" ;
lin niitto_N = mkkN "niitto" ;
lin niitty_N = mkkN "niitty" ;
lin niitta'a'_V = mkkV "niittää" ;
lin nikama_N = mkkN "nikama" ;
lin nikkari_N = mkkN "nikkari" ;
lin nikkaroida_V = mkkV "nikkaroida" ;
lin nikkeli_N = mkkN "nikkeli" ;
lin nikkelinen_N = mkkN "nikkelinen" ;
lin nikkelo'ida'_V = mkkV "nikkelöidä" ;
lin nikkelo'inti_N = mkkN "nikkelöinti" ;
lin niklata_V = mkkV "niklata" ;
lin nikotella_V = mkkV "nikotella" ;
lin nikotiini_N = mkkN "nikotiini" ;
lin nikotinisti_N = mkkN "nikotinisti" ;
lin nikottaa_V = mkkV "nikottaa" ;
lin nikottelu_N = mkkN "nikottelu" ;
lin nikotus_N = mkkN "nikotus" ;
lin nikotuttaa_V = mkkV "nikotuttaa" ;
lin niksaa_V = mkkV "niksaa" ;
lin niksahdella_V = mkkV "niksahdella" ;
lin niksahdus_N = mkkN "niksahdus" ;
lin niksahtaa_V = mkkV "niksahtaa" ;
lin niksaus_N = mkkN "niksaus" ;
lin niksauttaa_V = mkkV "niksauttaa" ;
lin niksauttaja_N = mkkN "niksauttaja" ;
lin niksi_N = mkkN "niksi" ;
lin niksua_V = mkkV "niksua" ;
lin nila_N = mkkN "nila" ;
lin nilelle_Adv = mkkAdv "nilelle" ;
lin nilella'_Adv = mkkAdv "nilellä" ;
lin niljaantua_V = mkkV "niljaantua" ;
lin niljainen_N = mkkN "niljainen" ;
lin niljakas_N = mkkN "niljakas" ;
lin niljakkuus_N = mkkN "niljakkuus" ;
lin nilkka_N = mkkN "nilkka" ;
lin nilkkain_N = mkkN "nilkkain" ;
lin nilkkainen_N = mkkN "nilkkainen" ;
lin nilkki_N = mkkN "nilkki" ;
lin nilkku_N = mkkN "nilkku" ;
lin nilkkuri_N = mkkN "nilkkuri" ;
lin nilkutella_V = mkkV "nilkutella" ;
lin nilkuttaa_V = mkkV "nilkuttaa" ;
lin nilkutus_N = mkkN "nilkutus" ;
lin nilvia'inen_N = mkkN "nilviäinen" ;
lin nimeke_N = mkkN "nimeke" ;
lin nimekkyys_N = mkkN "nimekkyys" ;
lin nimeka's_N = mkkN "nimekäs" ;
lin nimellinen_A = mkkA "nimellinen" ;
lin nimellisesti_Adv = mkkAdv "nimellisesti" ;
lin nimenomaan_Adv = mkkAdv "nimenomaan" ;
lin nimenomaisesti_Adv = mkkAdv "nimenomaisesti" ;
lin nimetto'myys_N = mkkN "nimettömyys" ;
lin nimeta'_V = mkkV "nimetä" ;
lin nimeto'n_N = mkkN "nimetön" ;
lin nimea'ma'to'n_N = mkkN "nimeämätön" ;
lin nimi_N = mkkN "nimi" ;
lin nimike_N = mkkN "nimike" ;
lin nimikkeisto'_N = mkkN "nimikkeistö" ;
lin nimikko_N = mkkN "nimikko" ;
lin nimikoida_V = mkkV "nimikoida" ;
lin nimikointi_N = mkkN "nimikointi" ;
lin niminen_N = mkkN "niminen" ;
lin nimisto'_N = mkkN "nimistö" ;
lin nimitella'_V = mkkV "nimitellä" ;
lin nimittely_N = mkkN "nimittely" ;
lin nimitta'in_Adv = mkkAdv "nimittäin" ;
lin nimitta'ja'_N = mkkN "nimittäjä" ;
lin nimitta'a'_V = mkkV "nimittää" ;
lin nimitys_N = mkkN "nimitys" ;
--? lin nimia'iset_NK = {s = d38 "nimiäiset" ;
lin nimio'_N = mkkN "nimiö" ;
lin nimio'ida'_V = mkkV "nimiöidä" ;
lin nimmari_N = mkkN "nimmari" ;
lin nimppari_N = mkkN "nimppari" ;
lin niobi_N = mkkN "niobi" ;
lin niobium_N = mkkN "niobium" ;
lin nipin_napin_Adv = mkkAdv "nipiC" ;
lin nipistella'_V = mkkV "nipistellä" ;
lin nipistely_N = mkkN "nipistely" ;
lin nipistin_N = mkkN "nipistin" ;
lin nipistys_N = mkkN "nipistys" ;
lin nipista'a'_V = mkkV "nipistää" ;
lin nipottaa_V = mkkV "nipottaa" ;
lin nipottaja_N = mkkN "nipottaja" ;
lin nipotus_N = mkkN "nipotus" ;
lin nippa_N = mkkN "nippa" ;
lin nippa_nappa_Adv = mkkAdv "nippC" ;
lin nippeli_N = mkkN "nippeli" ;
lin nippu_N = mkkN "nippu" ;
lin nipsahdus_N = mkkN "nipsahdus" ;
lin nipsahtaa_V = mkkV "nipsahtaa" ;
lin nipsaus_N = mkkN "nipsaus" ;
lin nipsauttaa_V = mkkV "nipsauttaa" ;
lin nipuittain_Adv = mkkAdv "nipuittain" ;
lin nipukka_N = mkkN "nipukka" ;
lin niputtaa_V = mkkV "niputtaa" ;
lin niputus_N = mkkN "niputus" ;
lin nirhaista_V = mkkV "nirhaista" ;
lin nirhama_N = mkkN "nirhama" ;
lin nirhata_V = mkkV "nirhata" ;
lin nirkko_N = mkkN "nirkko" ;
lin nirpalla_Adv = mkkAdv "nirpalla" ;
lin nirpallaan_Adv = mkkAdv "nirpallaan" ;
lin nirpassa_Adv = mkkAdv "nirpassa" ;
lin nirri_N = mkkN "nirri" ;
lin nirskahtaa_V = mkkV "nirskahtaa" ;
lin nirskua_V = mkkV "nirskua" ;
lin nirskunta_N = mkkN "nirskunta" ;
lin nirskutella_V = mkkV "nirskutella" ;
lin nirskuttaa_V = mkkV "nirskuttaa" ;
lin nirskuttelu_N = mkkN "nirskuttelu" ;
lin nirskutus_N = mkkN "nirskutus" ;
lin nirso_A = mkkA "nirso" ;
lin nirsoilla_V = mkkV "nirsoilla" ;
lin nirsosti_Adv = mkkAdv "nirsosti" ;
lin nirvana_N = mkkN "nirvana" ;
lin niska_N = mkkN "niska" ;
lin niskainen_N = mkkN "niskainen" ;
lin niskoitella_V = mkkV "niskoitella" ;
lin niskoittelija_N = mkkN "niskoittelija" ;
lin niskoittelu_N = mkkN "niskoittelu" ;
lin niskuri_N = mkkN "niskuri" ;
lin niskuroida_V = mkkV "niskuroida" ;
lin nisse_N = mkkN "nisse" ;
lin nisti_N = mkkN "nisti" ;
lin nisu_N = mkkN "nisu" ;
lin nisa'_N = mkkN "nisä" ;
lin nisa'ka's_N = mkkN "nisäkäs" ;
lin nitina'_N = mkkN "nitinä" ;
lin nitista'_V = mkkV "nitistä" ;
lin nitista'a'_V = mkkV "nitistää" ;
lin nitoa_V = mkkV "nitoa" ;
lin nitoja_N = mkkN "nitoja" ;
lin nitraatti_N = mkkN "nitraatti" ;
lin nitriitti_N = mkkN "nitriitti" ;
lin nitro_N = mkkN "nitro" ;
lin nituri_N = mkkN "nituri" ;
lin niuho_N = mkkN "niuho" ;
lin niuhottaa_V = mkkV "niuhottaa" ;
lin niuhottaja_N = mkkN "niuhottaja" ;
lin niuhotus_N = mkkN "niuhotus" ;
lin niukahdus_N = mkkN "niukahdus" ;
lin niukahtaa_V = mkkV "niukahtaa" ;
lin niukalti_Adv = mkkAdv "niukalti" ;
lin niukasti_Adv = mkkAdv "niukasti" ;
lin niukentaa_V = mkkV "niukentaa" ;
lin niukentua_V = mkkV "niukentua" ;
lin niuketa_V = mkkV "niuketa" ;
lin niukin_naukin_Adv = mkkAdv "niukiC" ;
lin niukka_N = mkkN "niukka" ;
lin niukkasanaisesti_Adv = mkkAdv "niukkasanaisesti" ;
lin niukkuus_N = mkkN "niukkuus" ;
lin niva_N = mkkN "niva" ;
lin nivaska_N = mkkN "nivaska" ;
lin nivel_N = mkkN "nivel" ;
lin nivelika's_N = mkkN "nivelikäs" ;
lin nivelinen_N = mkkN "nivelinen" ;
lin nivelisto'_N = mkkN "nivelistö" ;
lin nivelka'rsa'inen_N = mkkN "nivelkärsäinen" ;
lin niveltya'_V = mkkV "niveltyä" ;
lin nivelta'a'_V = mkkV "niveltää" ;
lin nivoa_V = mkkV "nivoa" ;
lin nivoutua_V = mkkV "nivoutua" ;
--? lin nivuset_NK = {s = d38 "nivuset" ;
lin no_Adv = mkkAdv "no" ;
lin nobelisti_N = mkkN "nobelisti" ;
lin noduuli_N = mkkN "noduuli" ;
lin noeta_V = mkkV "noeta" ;
lin noh_Adv = mkkAdv "noh" ;
lin noin_Adv = mkkAdv "noin" ;
lin noin_pa'in_Adv = mkkAdv "noiC" ;
lin noisetti_N = mkkN "noisetti" ;
lin noita_N = mkkN "noita" ;
lin noitua_V = mkkV "noitua" ;
lin noituus_N = mkkN "noituus" ;
lin noja_N = mkkN "noja" ;
lin nojaan_Adv = mkkAdv "nojaan" ;
lin nojailla_V = mkkV "nojailla" ;
lin nojalla_Adv = mkkAdv "nojalla" ;
lin nojallaan_Adv = mkkAdv "nojallaan" ;
lin nojalleen_Adv = mkkAdv "nojalleen" ;
lin nojassa_Adv = mkkAdv "nojassa" ;
lin nojata_V = mkkV "nojata" ;
lin nojautua_V = mkkV "nojautua" ;
lin nokakkain_Adv = mkkAdv "nokakkain" ;
lin nokallinen_N = mkkN "nokallinen" ;
lin nokare_N = mkkN "nokare" ;
lin nokatusten_Adv = mkkAdv "nokatusten" ;
lin nokeentua_V = mkkV "nokeentua" ;
lin nokeutua_V = mkkV "nokeutua" ;
lin noki_N = mkkN "noki" ;
lin nokikkain_Adv = mkkAdv "nokikkain" ;
lin nokinen_N = mkkN "nokinen" ;
lin nokittaa_V = mkkV "nokittaa" ;
lin nokittain_Adv = mkkAdv "nokittain" ;
lin nokitus_N = mkkN "nokitus" ;
lin nokitusten_Adv = mkkAdv "nokitusten" ;
lin nokka_N = mkkN "nokka" ;
lin nokkainen_N = mkkN "nokkainen" ;
lin nokkaista_V = mkkV "nokkaista" ;
lin nokkava_A = mkkA "nokkava" ;
lin nokkavasti_Adv = mkkAdv "nokkavasti" ;
lin nokkavuus_N = mkkN "nokkavuus" ;
lin nokkela_A = mkkA "nokkela" ;
lin nokkelasti_Adv = mkkAdv "nokkelasti" ;
lin nokkeluus_N = mkkN "nokkeluus" ;
lin nokkia_V = mkkV "nokkia" ;
lin nokkonen_N = mkkN "nokkonen" ;
--? lin nokoset_NK = {s = d38 "nokoset" ;
lin nolata_V = mkkV "nolata" ;
lin nolla_N = mkkN "nolla" ;
lin nollaantua_V = mkkV "nollaantua" ;
lin nollakohta_N = mkkN "nollakohta" ;
lin nollakoko_N = mkkN "nollakoko" ;
lin nollas_N = mkkN "nollas" ;
lin nollata_V = mkkV "nollata" ;
lin nollaus_N = mkkN "nollaus" ;
lin nollautua_V = mkkV "nollautua" ;
lin nolo_A = mkkA "nolo" ;
lin noloissaan_Adv = mkkAdv "noloissaan" ;
lin nolosti_Adv = mkkAdv "nolosti" ;
lin nolostua_V = mkkV "nolostua" ;
lin nolostuttaa_V = mkkV "nolostuttaa" ;
lin nolottaa_V = mkkV "nolottaa" ;
lin nolous_N = mkkN "nolous" ;
lin nomadi_N = mkkN "nomadi" ;
lin nomenklatuura_N = mkkN "nomenklatuura" ;
lin nomenklatuuri_N = mkkN "nomenklatuuri" ;
lin nominatiivi_N = mkkN "nominatiivi" ;
lin nomini_N = mkkN "nomini" ;
lin nonfiguratiivinen_N = mkkN "nonfiguratiivinen" ;
lin non_food_N = mkkN "non-food" ;
lin non_iron_N = mkkN "non-iron" ;
lin nonparelli_N = mkkN "nonparelli" ;
lin nonstop_N = mkkN "nonstop" ;
lin non_woven_N = mkkN "non-woven" ;
lin nootti_N = mkkN "nootti" ;
lin nopea_A = mkkA "nopea" ;
lin nopeasti_Adv = mkkAdv "nopeasti" ;
lin nopeuksinen_N = mkkN "nopeuksinen" ;
lin nopeus_N = mkkN "nopeus" ;
lin nopeuttaa_V = mkkV "nopeuttaa" ;
lin nopeutua_V = mkkV "nopeutua" ;
lin noppa_N = mkkN "noppa" ;
lin nopsa_A = mkkA "nopsa" ;
lin nopsaan_Adv = mkkAdv "nopsaan" ;
lin nopsasti_Adv = mkkAdv "nopsasti" ;
lin norahtaa_V = mkkV "norahtaa" ;
lin nordisti_N = mkkN "nordisti" ;
lin nordistiikka_N = mkkN "nordistiikka" ;
lin norja_1_N = mkkN "norja" ;
lin norja_2_N = mkkN "norja" ;
lin norjatar_N = mkkN "norjatar" ;
lin norjentaa_V = mkkV "norjentaa" ;
lin norjentua_V = mkkV "norjentua" ;
lin norjeta_V = mkkV "norjeta" ;
lin norjistaa_V = mkkV "norjistaa" ;
lin norjistua_V = mkkV "norjistua" ;
lin norkko_N = mkkN "norkko" ;
lin norkoilija_N = mkkN "norkoilija" ;
lin norkoilla_V = mkkV "norkoilla" ;
lin norkoilu_N = mkkN "norkoilu" ;
lin normaali_A = mkkA "normaali" ;
lin normaalikoko_N = mkkN "normaalikoko" ;
lin normaalistaa_V = mkkV "normaalistaa" ;
lin normaalisti_Adv = mkkAdv "normaalisti" ;
lin normaalistua_V = mkkV "normaalistua" ;
lin normaalisuus_N = mkkN "normaalisuus" ;
lin normaalius_N = mkkN "normaalius" ;
lin normalisoida_V = mkkV "normalisoida" ;
lin normalisointi_N = mkkN "normalisointi" ;
lin normalisoitua_V = mkkV "normalisoitua" ;
lin normanni_N = mkkN "normanni" ;
lin normatiivinen_N = mkkN "normatiivinen" ;
lin normatiivisuus_N = mkkN "normatiivisuus" ;
lin normi_N = mkkN "normi" ;
lin normisto_N = mkkN "normisto" ;
lin normittaa_V = mkkV "normittaa" ;
lin normitus_N = mkkN "normitus" ;
lin noro_N = mkkN "noro" ;
lin norppa_N = mkkN "norppa" ;
lin norri_N = mkkN "norri" ;
lin norssi_1_N = mkkN "norssi" ;
lin norssi_2_N = mkkN "norssi" ;
lin norsu_N = mkkN "norsu" ;
lin norua_V = mkkV "norua" ;
lin nostaa_V = mkkV "nostaa" ;
lin nostaja_N = mkkN "nostaja" ;
lin nostalgia_N = mkkN "nostalgia" ;
lin nostalginen_A = mkkA "nostalginen" ;
lin nostalgisesti_Adv = mkkAdv "nostalgisesti" ;
lin nostalgisuus_N = mkkN "nostalgisuus" ;
lin nostattaa_V = mkkV "nostattaa" ;
lin nostatus_N = mkkN "nostatus" ;
lin noste_N = mkkN "noste" ;
lin nostella_V = mkkV "nostella" ;
lin nostelu_N = mkkN "nostelu" ;
lin nostin_N = mkkN "nostin" ;
lin nosto_N = mkkN "nosto" ;
lin nosturi_N = mkkN "nosturi" ;
lin notaari_N = mkkN "notaari" ;
lin notariaatti_N = mkkN "notariaatti" ;
lin noteerata_V = mkkV "noteerata" ;
lin noteeraus_N = mkkN "noteeraus" ;
lin notkahdella_V = mkkV "notkahdella" ;
lin notkahdus_N = mkkN "notkahdus" ;
lin notkahtaa_V = mkkV "notkahtaa" ;
lin notkauttaa_V = mkkV "notkauttaa" ;
lin notkea_A = mkkA "notkea" ;
lin notkeasti_Adv = mkkAdv "notkeasti" ;
lin notkelma_N = mkkN "notkelma" ;
lin notkeus_N = mkkN "notkeus" ;
lin notkeuttaa_V = mkkV "notkeuttaa" ;
lin notkeutua_V = mkkV "notkeutua" ;
lin notkistaa_V = mkkV "notkistaa" ;
lin notkistua_V = mkkV "notkistua" ;
lin notko_N = mkkN "notko" ;
lin notkua_V = mkkV "notkua" ;
lin notkunta_N = mkkN "notkunta" ;
lin notkutella_V = mkkV "notkutella" ;
lin notkuttaa_V = mkkV "notkuttaa" ;
lin noudatella_V = mkkV "noudatella" ;
lin noudattaa_V = mkkV "noudattaa" ;
--? lin nougat_NK = {s = d22 "nougat" ;
lin noukkia_V = mkkV "noukkia" ;
lin nousija_N = mkkN "nousija" ;
lin nousta_V = mkkV "nousta" ;
lin nousu_N = mkkN "nousu" ;
lin nousuinen_N = mkkN "nousuinen" ;
lin nousukas_N = mkkN "nousukas" ;
lin nousukasmaisesti_Adv = mkkAdv "nousukasmaisesti" ;
lin nousukasmaisuus_N = mkkN "nousukasmaisuus" ;
lin noutaa_V = mkkV "noutaa" ;
lin noutaja_N = mkkN "noutaja" ;
lin nouto_N = mkkN "nouto" ;
lin nova_N = mkkN "nova" ;
lin novelli_N = mkkN "novelli" ;
lin novellisti_N = mkkN "novellisti" ;
lin novellistiikka_N = mkkN "novellistiikka" ;
lin novellistinen_N = mkkN "novellistinen" ;
lin noviisi_N = mkkN "noviisi" ;
lin nudismi_N = mkkN "nudismi" ;
lin nudisti_N = mkkN "nudisti" ;
lin nugaa_N = mkkN "nugaa" ;
lin nugetti_N = mkkN "nugetti" ;
lin nuha_N = mkkN "nuha" ;
lin nuhainen_N = mkkN "nuhainen" ;
lin nuhde_N = mkkN "nuhde" ;
lin nuhdella_V = mkkV "nuhdella" ;
lin nuhjaantua_V = mkkV "nuhjaantua" ;
lin nuhjata_V = mkkV "nuhjata" ;
lin nuhraantua_V = mkkV "nuhraantua" ;
lin nuhraantuneisuus_N = mkkN "nuhraantuneisuus" ;
lin nuhrata_V = mkkV "nuhrata" ;
lin nuhrautua_V = mkkV "nuhrautua" ;
lin nuhruinen_N = mkkN "nuhruinen" ;
lin nuhteeton_N = mkkN "nuhteeton" ;
lin nuhteettomasti_Adv = mkkAdv "nuhteettomasti" ;
lin nuhteettomuus_N = mkkN "nuhteettomuus" ;
lin nuhtelu_N = mkkN "nuhtelu" ;
lin nuija_N = mkkN "nuija" ;
lin nuijakas_N = mkkN "nuijakas" ;
lin nuijia_V = mkkV "nuijia" ;
lin nuiva_A = mkkA "nuiva" ;
lin nuivasti_Adv = mkkAdv "nuivasti" ;
lin nuivuus_N = mkkN "nuivuus" ;
lin nujakka_N = mkkN "nujakka" ;
lin nujakoida_V = mkkV "nujakoida" ;
lin nujakointi_N = mkkN "nujakointi" ;
lin nujerrus_N = mkkN "nujerrus" ;
lin nujertaa_V = mkkV "nujertaa" ;
lin nujertua_V = mkkV "nujertua" ;
lin nujuta_V = mkkV "nujuta" ;
lin nujuuttaa_V = mkkV "nujuuttaa" ;
lin nukahdella_V = mkkV "nukahdella" ;
lin nukahdus_N = mkkN "nukahdus" ;
lin nukahtaa_V = mkkV "nukahtaa" ;
lin nukallinen_N = mkkN "nukallinen" ;
lin nukata_V = mkkV "nukata" ;
lin nukittaa_V = mkkV "nukittaa" ;
lin nukitus_N = mkkN "nukitus" ;
lin nukka_N = mkkN "nukka" ;
lin nukkaantua_V = mkkV "nukkaantua" ;
lin nukkaantumaton_N = mkkN "nukkaantumaton" ;
lin nukkainen_N = mkkN "nukkainen" ;
lin nukkaus_N = mkkN "nukkaus" ;
lin nukkautua_V = mkkV "nukkautua" ;
lin nukkavieru_N = mkkN "nukkavieru" ;
lin nukke_N = mkkN "nukke" ;
lin nukki_N = mkkN "nukki" ;
lin nukkua_V = mkkV "nukkua" ;
lin nukkuja_N = mkkN "nukkuja" ;
lin nukkumaanmenoaika_N = mkkN "nukkumaanmenoaika" ;
lin nukkumatti_N = mkkN "nukkumatti" ;
lin nukleoni_N = mkkN "nukleoni" ;
lin nukuksiin_Adv = mkkAdv "nukuksiin" ;
lin nukuksissa_Adv = mkkAdv "nukuksissa" ;
lin nukula_N = mkkN "nukula" ;
lin nukute_N = mkkN "nukute" ;
lin nukuttaa_V = mkkV "nukuttaa" ;
lin nukutus_N = mkkN "nukutus" ;
lin nulikka_N = mkkN "nulikka" ;
lin nuljahdella_V = mkkV "nuljahdella" ;
lin nuljahtaa_V = mkkV "nuljahtaa" ;
lin nuljaska_N = mkkN "nuljaska" ;
lin nulju_N = mkkN "nulju" ;
lin nulkki_N = mkkN "nulkki" ;
lin numeerinen_N = mkkN "numeerinen" ;
lin numeeristaa_V = mkkV "numeeristaa" ;
lin numeraali_N = mkkN "numeraali" ;
lin numero_N = mkkN "numero" ;
lin numeroida_V = mkkV "numeroida" ;
lin numeroinen_N = mkkN "numeroinen" ;
lin numerointi_N = mkkN "numerointi" ;
lin numerollinen_A = mkkA "numerollinen" ;
lin numerollisesti_Adv = mkkAdv "numerollisesti" ;
lin numerologia_N = mkkN "numerologia" ;
lin numerus_N = mkkN "numerus" ;
lin numismaatikko_N = mkkN "numismaatikko" ;
lin numismaattinen_N = mkkN "numismaattinen" ;
lin numismatiikka_N = mkkN "numismatiikka" ;
lin nummi_N = mkkN "nummi" ;
lin nunna_N = mkkN "nunna" ;
lin nuohooja_N = mkkN "nuohooja" ;
lin nuohota_V = mkkV "nuohota" ;
lin nuohous_N = mkkN "nuohous" ;
lin nuokahdella_V = mkkV "nuokahdella" ;
lin nuokahtaa_V = mkkV "nuokahtaa" ;
lin nuokkua_V = mkkV "nuokkua" ;
lin nuokuksiin_Adv = mkkAdv "nuokuksiin" ;
lin nuokuksissa_Adv = mkkAdv "nuokuksissa" ;
lin nuolaista_V = mkkV "nuolaista" ;
lin nuolaisu_N = mkkN "nuolaisu" ;
lin nuoleksia_V = mkkV "nuoleksia" ;
lin nuoleskelija_N = mkkN "nuoleskelija" ;
lin nuoleskella_V = mkkV "nuoleskella" ;
lin nuoleskelu_N = mkkN "nuoleskelu" ;
lin nuoli_N = mkkN "nuoli" ;
lin nuoliainen_N = mkkN "nuoliainen" ;
lin nuolijuuri_N = mkkN "nuolijuuri" ;
lin nuolla_V = mkkV "nuolla" ;
lin nuolu_N = mkkN "nuolu" ;
lin nuora_N = mkkN "nuora" ;
lin nuorekas_A = mkkA "nuorekas" ;
lin nuorekkaasti_Adv = mkkAdv "nuorekkaasti" ;
lin nuorekkuus_N = mkkN "nuorekkuus" ;
lin nuoremmakseen_Adv = mkkAdv "nuoremmakseen" ;
lin nuoremmuuttaan_Adv = mkkAdv "nuoremmuuttaan" ;
lin nuorennus_N = mkkN "nuorennus" ;
lin nuorentaa_V = mkkV "nuorentaa" ;
lin nuorentua_V = mkkV "nuorentua" ;
lin nuoreta_V = mkkV "nuoreta" ;
lin nuori_N = mkkN "nuori" ;
lin nuorimmainen_N = mkkN "nuorimmainen" ;
lin nuoriso_N = mkkN "nuoriso" ;
lin nuorittaa_V = mkkV "nuorittaa" ;
lin nuoritus_N = mkkN "nuoritus" ;
lin nuorruttaa_V = mkkV "nuorruttaa" ;
lin nuorrutus_N = mkkN "nuorrutus" ;
lin nuortea_N = mkkN "nuortea" ;
lin nuortua_V = mkkV "nuortua" ;
lin nuorukainen_N = mkkN "nuorukainen" ;
lin nuoruudenaika_N = mkkN "nuoruudenaika" ;
lin nuoruus_N = mkkN "nuoruus" ;
lin nuoruusaika_N = mkkN "nuoruusaika" ;
lin nuoska_N = mkkN "nuoska" ;
lin nuoskainen_N = mkkN "nuoskainen" ;
lin nuotanveto_N = mkkN "nuotanveto" ;
lin nuotata_V = mkkV "nuotata" ;
lin nuotillinen_N = mkkN "nuotillinen" ;
lin nuotinnos_N = mkkN "nuotinnos" ;
lin nuotintaa_V = mkkV "nuotintaa" ;
lin nuotio_N = mkkN "nuotio" ;
lin nuotisto_N = mkkN "nuotisto" ;
lin nuotittaa_V = mkkV "nuotittaa" ;
lin nuotitus_N = mkkN "nuotitus" ;
lin nuotta_N = mkkN "nuotta" ;
lin nuottaus_N = mkkN "nuottaus" ;
lin nuotti_N = mkkN "nuotti" ;
lin nupi_N = mkkN "nupi" ;
lin nupo_N = mkkN "nupo" ;
lin nuppi_N = mkkN "nuppi" ;
lin nuppu_N = mkkN "nuppu" ;
lin nuppuinen_N = mkkN "nuppuinen" ;
lin nupu_N = mkkN "nupu" ;
lin nupukki_N = mkkN "nupukki" ;
lin nupula_N = mkkN "nupula" ;
lin nupura_N = mkkN "nupura" ;
lin nurea_N = mkkN "nurea" ;
lin nureissaan_Adv = mkkAdv "nureissaan" ;
lin nurin_Adv = mkkAdv "nurin" ;
lin nurina_N = mkkN "nurina" ;
lin nurinkurinen_A = mkkA "nurinkurinen" ;
lin nurinkurisesti_Adv = mkkAdv "nurinkurisesti" ;
lin nurin_pa'in_Adv = mkkAdv "nuriC" ;
lin nurista_V = mkkV "nurista" ;
lin nurja_A = mkkA "nurja" ;
lin nurjahdus_N = mkkN "nurjahdus" ;
lin nurjahtaa_V = mkkV "nurjahtaa" ;
lin nurjamielisesti_Adv = mkkAdv "nurjamielisesti" ;
lin nurjasti_Adv = mkkAdv "nurjasti" ;
lin nurjaton_N = mkkN "nurjaton" ;
lin nurkakkain_Adv = mkkAdv "nurkakkain" ;
lin nurkata_V = mkkV "nurkata" ;
lin nurkikkain_Adv = mkkAdv "nurkikkain" ;
lin nurkilla_Adv = mkkAdv "nurkilla" ;
lin nurkille_Adv = mkkAdv "nurkille" ;
lin nurkittain_Adv = mkkAdv "nurkittain" ;
lin nurkka_N = mkkN "nurkka" ;
lin nurkkaaja_N = mkkN "nurkkaaja" ;
lin nurkkainen_N = mkkN "nurkkainen" ;
lin nurkkakuntainen_N = mkkN "nurkkakuntainen" ;
lin nurkkakuntaisuus_N = mkkN "nurkkakuntaisuus" ;
lin nurkkaus_N = mkkN "nurkkaus" ;
lin nurkua_V = mkkV "nurkua" ;
lin nurmettaa_V = mkkV "nurmettaa" ;
lin nurmettua_V = mkkV "nurmettua" ;
lin nurmi_N = mkkN "nurmi" ;
lin nurmikka_N = mkkN "nurmikka" ;
lin nurmikko_N = mkkN "nurmikko" ;
lin nurmikkoinen_N = mkkN "nurmikkoinen" ;
lin nurminen_N = mkkN "nurminen" ;
lin nussia_V = mkkV "nussia" ;
lin nuti_N = mkkN "nuti" ;
lin nutistaa_V = mkkV "nutistaa" ;
lin nutria_N = mkkN "nutria" ;
lin nuttu_N = mkkN "nuttu" ;
lin nuttura_N = mkkN "nuttura" ;
lin nutukas_N = mkkN "nutukas" ;
lin nuudeli_N = mkkN "nuudeli" ;
lin nuuduksissa_Adv = mkkAdv "nuuduksissa" ;
lin nuuduttaa_V = mkkV "nuuduttaa" ;
lin nuuhkaista_V = mkkV "nuuhkaista" ;
lin nuuhkia_V = mkkV "nuuhkia" ;
lin nuuka_A = mkkA "nuuka" ;
lin nuukahdella_V = mkkV "nuukahdella" ;
lin nuukahtaa_V = mkkV "nuukahtaa" ;
lin nuukailla_V = mkkV "nuukailla" ;
lin nuukailu_N = mkkN "nuukailu" ;
lin nuukasti_Adv = mkkAdv "nuukasti" ;
lin nuukuus_N = mkkN "nuukuus" ;
lin nuuska_N = mkkN "nuuska" ;
lin nuuskaista_V = mkkV "nuuskaista" ;
lin nuuskata_V = mkkV "nuuskata" ;
lin nuuskia_V = mkkV "nuuskia" ;
lin nuuskija_N = mkkN "nuuskija" ;
lin nuutata_V = mkkV "nuutata" ;
lin nuuttaus_N = mkkN "nuuttaus" ;
lin nuutua_V = mkkV "nuutua" ;
lin nyansoida_V = mkkV "nyansoida" ;
lin nyansointi_N = mkkN "nyansointi" ;
lin nyanssi_N = mkkN "nyanssi" ;
lin nyherta'a'_V = mkkV "nyhertää" ;
lin nyhja'illa'_V = mkkV "nyhjäillä" ;
lin nyhja'ista'_V = mkkV "nyhjäistä" ;
lin nyhja'ta'_V = mkkV "nyhjätä" ;
lin nyhjo'tta'a'_V = mkkV "nyhjöttää" ;
lin nyhra'ta'_V = mkkV "nyhrätä" ;
lin nyhta'ista'_V = mkkV "nyhtäistä" ;
lin nyhta'isy_N = mkkN "nyhtäisy" ;
lin nyhta'a'_V = mkkV "nyhtää" ;
lin nyhvero'_N = mkkN "nyhverö" ;
lin nyinta'_N = mkkN "nyintä" ;
lin nykerta'a'_V = mkkV "nykertää" ;
lin nykero'_N = mkkN "nykerö" ;
lin nykia'_V = mkkV "nykiä" ;
lin nykyaika_N = mkkN "nykyaika" ;
lin nykyaikaisesti_Adv = mkkAdv "nykyaikaisesti" ;
lin nykyinen_N = mkkN "nykyinen" ;
lin nykyiselleen_Adv = mkkAdv "nykyiselleen" ;
lin nykyisella'a'n_Adv = mkkAdv "nykyisellään" ;
lin nykyisin_Adv = mkkAdv "nykyisin" ;
lin nykyisyys_N = mkkN "nykyisyys" ;
lin nykyja'a'n_Adv = mkkAdv "nykyjään" ;
lin nykytta'a'_V = mkkV "nykyttää" ;
lin nykytys_N = mkkN "nykytys" ;
lin nykya'_Adv = mkkAdv "nykyä" ;
lin nykya'a'n_Adv = mkkAdv "nykyään" ;
lin nyka'ista'_V = mkkV "nykäistä" ;
lin nyka'isy_N = mkkN "nykäisy" ;
lin nyka'yksitta'in_Adv = mkkAdv "nykäyksittäin" ;
lin nyka'yksitta'inen_N = mkkN "nykäyksittäinen" ;
lin nyka'ys_N = mkkN "nykäys" ;
lin nyljenta'_N = mkkN "nyljentä" ;
lin nylkea'_V = mkkV "nylkeä" ;
lin nylky_N = mkkN "nylky" ;
lin nylkyri_N = mkkN "nylkyri" ;
lin nylkytta'a'_V = mkkV "nylkyttää" ;
lin nylon_N = mkkN "nylon" ;
lin nymfetti_N = mkkN "nymfetti" ;
lin nymfi_N = mkkN "nymfi" ;
lin nymfomaani_N = mkkN "nymfomaani" ;
lin nymfomaaninen_N = mkkN "nymfomaaninen" ;
lin nymfomania_N = mkkN "nymfomania" ;
lin nynnero'_N = mkkN "nynnerö" ;
lin nynnia'_V = mkkV "nynniä" ;
lin nynny_N = mkkN "nynny" ;
lin nynnyilla'_V = mkkV "nynnyillä" ;
lin nynnyily_N = mkkN "nynnyily" ;
lin nypelo'ida'_V = mkkV "nypelöidä" ;
lin nypla'ta'_V = mkkV "nyplätä" ;
lin nypla'ys_N = mkkN "nypläys" ;
lin nyppia'_V = mkkV "nyppiä" ;
lin nyppy_N = mkkN "nyppy" ;
lin nyppyinen_N = mkkN "nyppyinen" ;
lin nyppyla'_N = mkkN "nyppylä" ;
lin nyppyyntya'_V = mkkV "nyppyyntyä" ;
lin nyppa'ista'_V = mkkV "nyppäistä" ;
lin nypykka'_N = mkkN "nypykkä" ;
lin nypyla'_N = mkkN "nypylä" ;
lin nypa'ta'_V = mkkV "nypätä" ;
lin nyreissa'a'n_Adv = mkkAdv "nyreissään" ;
lin nyreys_N = mkkN "nyreys" ;
lin nyrea'_A = mkkA "nyreä" ;
lin nyrea'sti_Adv = mkkAdv "nyreästi" ;
lin nyrhia'_V = mkkV "nyrhiä" ;
lin nyrja'hdys_N = mkkN "nyrjähdys" ;
lin nyrja'hdytta'a'_V = mkkV "nyrjähdyttää" ;
lin nyrja'hta'a'_V = mkkV "nyrjähtää" ;
lin nyrja'ytta'a'_V = mkkV "nyrjäyttää" ;
lin nyrkista'a'_V = mkkV "nyrkistää" ;
lin nyrkkeilija'_N = mkkN "nyrkkeilijä" ;
lin nyrkkeilla'_V = mkkV "nyrkkeillä" ;
lin nyrkkeily_N = mkkN "nyrkkeily" ;
lin nyrkki_N = mkkN "nyrkki" ;
lin nyrkkitappelija_N = mkkN "nyrkkitappelija" ;
lin nyrpeissa'a'n_Adv = mkkAdv "nyrpeissään" ;
lin nyrpeys_N = mkkN "nyrpeys" ;
lin nyrpea'_A = mkkA "nyrpeä" ;
lin nyrpea'sti_Adv = mkkAdv "nyrpeästi" ;
lin nyrpistella'_V = mkkV "nyrpistellä" ;
lin nyrpistya'_V = mkkV "nyrpistyä" ;
lin nyrpista'a'_V = mkkV "nyrpistää" ;
lin nyssykka'_N = mkkN "nyssykkä" ;
lin nyssa'kka'_N = mkkN "nyssäkkä" ;
lin nysterma'_N = mkkN "nystermä" ;
lin nysterma'inen_N = mkkN "nystermäinen" ;
lin nysty_N = mkkN "nysty" ;
lin nystyra'_N = mkkN "nystyrä" ;
lin nystyra'inen_N = mkkN "nystyräinen" ;
lin nysa'_N = mkkN "nysä" ;
lin nyt_Adv = mkkAdv "nyt" ;
lin nytkia'_V = mkkV "nytkiä" ;
lin nytkytta'a'_V = mkkV "nytkyttää" ;
lin nytkytys_N = mkkN "nytkytys" ;
lin nytkya'_V = mkkV "nytkyä" ;
lin nytka'hdella'_V = mkkV "nytkähdellä" ;
lin nytka'hdys_N = mkkN "nytkähdys" ;
lin nytka'hta'a'_V = mkkV "nytkähtää" ;
lin nytka'ys_N = mkkN "nytkäys" ;
lin nyttemmin_Adv = mkkAdv "nyttemmin" ;
lin nytten_Adv = mkkAdv "nytten" ;
lin nyyhke_N = mkkN "nyyhke" ;
lin nyyhkia'_V = mkkV "nyyhkiä" ;
lin nyyhky_N = mkkN "nyyhky" ;
lin nyyhkytta'a'_V = mkkV "nyyhkyttää" ;
lin nyyhkytys_N = mkkN "nyyhkytys" ;
lin nyyhka'ista'_V = mkkV "nyyhkäistä" ;
lin nyyhka'isy_N = mkkN "nyyhkäisy" ;
lin nyyhka'ys_N = mkkN "nyyhkäys" ;
lin nyyka'hta'a'_V = mkkV "nyykähtää" ;
lin nyysia'_V = mkkV "nyysiä" ;
lin nyytti_N = mkkN "nyytti" ;
--? lin nyytta'rit_NK = {s = d06 "nyyttärit" ;
lin nyo'kkia'_V = mkkV "nyökkiä" ;
lin nyo'kka'illa'_V = mkkV "nyökkäillä" ;
lin nyo'kka'ys_N = mkkN "nyökkäys" ;
lin nyo'kytella'_V = mkkV "nyökytellä" ;
lin nyo'kytta'a'_V = mkkV "nyökyttää" ;
lin nyo'ka'hdella'_V = mkkV "nyökähdellä" ;
lin nyo'ka'hdys_N = mkkN "nyökähdys" ;
lin nyo'ka'hta'a'_V = mkkV "nyökähtää" ;
lin nyo'ka'ta'_V = mkkV "nyökätä" ;
lin nyo'ka'ytta'a'_V = mkkV "nyökäyttää" ;
lin nyo'ri_N = mkkN "nyöri" ;
lin nyo'ritta'a'_V = mkkV "nyörittää" ;
lin nyo'ritys_N = mkkN "nyöritys" ;
lin na'emma'_Adv = mkkAdv "näemmä" ;
lin na'enna'inen_A = mkkA "näennäinen" ;
lin na'enna'isesti_Adv = mkkAdv "näennäisesti" ;
lin na'es_Adv = mkkAdv "näes" ;
lin na'et_Adv = mkkAdv "näet" ;
lin na'hden_Adv = mkkAdv "nähden" ;
lin na'hda'_V = mkkV "nähdä" ;
lin na'hda'kseen_Adv = mkkAdv "nähdäkseen" ;
lin na'hka'a's_Adv = mkkAdv "nähkääs" ;
lin na'hta'viin_Adv = mkkAdv "nähtäviin" ;
lin na'hta'ville_Adv = mkkAdv "nähtäville" ;
lin na'hta'villa'_Adv = mkkAdv "nähtävillä" ;
lin na'hta'vissa'_Adv = mkkAdv "nähtävissä" ;
lin na'hta'vyys_N = mkkN "nähtävyys" ;
lin na'hta'va'_A = mkkA "nähtävä" ;
lin na'hta'va'sti_Adv = mkkAdv "nähtävästi" ;
lin na'in_Adv = mkkAdv "näin" ;
lin na'ivettya'_V = mkkV "näivettyä" ;
lin na'ivetta'a'_V = mkkV "näivettää" ;
lin na'ivetys_N = mkkN "näivetys" ;
lin na'kemiin_Adv = mkkAdv "näkemiin" ;
lin na'kemyksellinen_N = mkkN "näkemyksellinen" ;
lin na'kemyksinen_N = mkkN "näkemyksinen" ;
lin na'kemys_N = mkkN "näkemys" ;
lin na'kema'_N = mkkN "näkemä" ;
lin na'kema'to'n_N = mkkN "näkemätön" ;
lin na'keva'_N = mkkN "näkevä" ;
lin na'kija'_N = mkkN "näkijä" ;
--? lin na'kimet_NK = {s = d33 "näkimet" ;
lin na'kinkuori_N = mkkN "näkinkuori" ;
lin na'kki_N = mkkN "näkki" ;
lin na'kka'ri_N = mkkN "näkkäri" ;
lin na'ky_N = mkkN "näky" ;
lin na'kyma'_N = mkkN "näkymä" ;
lin na'kyma'tto'miin_Adv = mkkAdv "näkymättömiin" ;
lin na'kyma'tto'missa'_Adv = mkkAdv "näkymättömissä" ;
lin na'kyma'tto'myys_N = mkkN "näkymättömyys" ;
lin na'kyma'tto'ma'sti_Adv = mkkAdv "näkymättömästi" ;
lin na'kyma'to'n_N = mkkN "näkymätön" ;
lin na'kyviin_Adv = mkkAdv "näkyviin" ;
lin na'kyville_Adv = mkkAdv "näkyville" ;
lin na'kyvilla'_Adv = mkkAdv "näkyvillä" ;
lin na'kyvilta'_Adv = mkkAdv "näkyviltä" ;
lin na'kyvissa'_Adv = mkkAdv "näkyvissä" ;
lin na'kyvista'_Adv = mkkAdv "näkyvistä" ;
lin na'kyvyys_N = mkkN "näkyvyys" ;
lin na'kyva'_A = mkkA "näkyvä" ;
lin na'kyva'sti_Adv = mkkAdv "näkyvästi" ;
lin na'kya'_V = mkkV "näkyä" ;
--? lin na'ka'ra'iset_NK = {s = d38 "näkäräiset" ;
lin na'ko'_N = mkkN "näkö" ;
lin na'ko'alaton_N = mkkN "näköalaton" ;
lin na'ko'alattomuus_N = mkkN "näköalattomuus" ;
lin na'ko'inen_N = mkkN "näköinen" ;
lin na'ko'ja'a'n_Adv = mkkAdv "näköjään" ;
lin na'ko'kohta_N = mkkN "näkökohta" ;
lin na'ko'sa'lle_Adv = mkkAdv "näkösälle" ;
lin na'ko'sa'lla'_Adv = mkkAdv "näkösällä" ;
lin na'ko'sa'lta'_Adv = mkkAdv "näkösältä" ;
lin na'lissa'a'n_Adv = mkkAdv "nälissään" ;
lin na'lkiinnytta'a'_V = mkkV "nälkiinnyttää" ;
lin na'lkiintya'_V = mkkV "nälkiintyä" ;
lin na'lka'_N = mkkN "nälkä" ;
lin na'lka'inen_N = mkkN "nälkäinen" ;
lin na'lvia'_V = mkkV "nälviä" ;
lin na'lva'ista'_V = mkkV "nälväistä" ;
lin na'lva'isy_N = mkkN "nälväisy" ;
lin na'la'tta'a'_V = mkkV "nälättää" ;
lin na'nni_N = mkkN "nänni" ;
lin na'pelo'ida'_V = mkkV "näpelöidä" ;
lin na'pelo'inti_N = mkkN "näpelöinti" ;
lin na'perrella'_V = mkkV "näperrellä" ;
lin na'perrys_N = mkkN "näperrys" ;
lin na'pertely_N = mkkN "näpertely" ;
lin na'perta'a'_V = mkkV "näpertää" ;
lin na'pistelija'_N = mkkN "näpistelijä" ;
lin na'pistella'_V = mkkV "näpistellä" ;
lin na'pistely_N = mkkN "näpistely" ;
lin na'pistys_N = mkkN "näpistys" ;
lin na'pista'a'_V = mkkV "näpistää" ;
lin na'pla'ta'_V = mkkV "näplätä" ;
lin na'ppi_N = mkkN "näppi" ;
lin na'ppy_N = mkkN "näppy" ;
lin na'ppyinen_N = mkkN "näppyinen" ;
lin na'ppyla'_N = mkkN "näppylä" ;
lin na'ppyla'inen_N = mkkN "näppyläinen" ;
lin na'ppa'ilija'_N = mkkN "näppäilijä" ;
lin na'ppa'illa'_V = mkkV "näppäillä" ;
lin na'ppa'ily_N = mkkN "näppäily" ;
lin na'ppa'imisto'_N = mkkN "näppäimistö" ;
lin na'ppa'in_N = mkkN "näppäin" ;
lin na'ppa'ryys_N = mkkN "näppäryys" ;
lin na'ppa'ra'_A = mkkA "näppärä" ;
lin na'ppa'ra'sti_Adv = mkkAdv "näppärästi" ;
lin na'ppa'ys_N = mkkN "näppäys" ;
lin na'pra'illa'_V = mkkV "näpräillä" ;
lin na'pra'ta'_V = mkkV "näprätä" ;
lin na'psytta'a'_V = mkkV "näpsyttää" ;
lin na'psa'_A = mkkA "näpsä" ;
lin na'psa'kka'_N = mkkN "näpsäkkä" ;
lin na'psa'ka'sti_Adv = mkkAdv "näpsäkästi" ;
lin na'psa'sti_Adv = mkkAdv "näpsästi" ;
lin na'psa'ys_N = mkkN "näpsäys" ;
lin na'psa'ytta'a'_V = mkkV "näpsäyttää" ;
lin na'psa'ytys_N = mkkN "näpsäytys" ;
lin na'py_N = mkkN "näpy" ;
lin na'pa'kka'_N = mkkN "näpäkkä" ;
lin na'pa'ka'sti_Adv = mkkAdv "näpäkästi" ;
lin na'pa'ta'_V = mkkV "näpätä" ;
lin na'pa'ys_N = mkkN "näpäys" ;
lin na'pa'ytella'_V = mkkV "näpäytellä" ;
lin na'pa'ytta'a'_V = mkkV "näpäyttää" ;
lin na'pa'ytys_N = mkkN "näpäytys" ;
lin na're_N = mkkN "näre" ;
lin na'reikko'_N = mkkN "näreikkö" ;
lin na'rhi_N = mkkN "närhi" ;
lin na'rka'stys_N = mkkN "närkästys" ;
lin na'rka'stytta'a'_V = mkkV "närkästyttää" ;
lin na'rka'stya'_V = mkkV "närkästyä" ;
lin na'rva'na'_N = mkkN "närvänä" ;
lin na'ra'_N = mkkN "närä" ;
lin na'ra'stys_N = mkkN "närästys" ;
lin na'ra'sta'a'_V = mkkV "närästää" ;
lin na'sia'_N = mkkN "näsiä" ;
lin na'tisti_Adv = mkkAdv "nätisti" ;
lin na'tkelma'_N = mkkN "nätkelmä" ;
lin na'tti_N = mkkN "nätti" ;
lin na'veri_N = mkkN "näveri" ;
lin na'verrin_N = mkkN "näverrin" ;
lin na'verta'a'_V = mkkV "nävertää" ;
lin na'ykkia'_V = mkkV "näykkiä" ;
lin na'ykka'ista'_V = mkkV "näykkäistä" ;
lin na'yka'ta'_V = mkkV "näykätä" ;
lin na'yte_N = mkkN "näyte" ;
lin na'ytella'_V = mkkV "näytellä" ;
lin na'ytelma'_N = mkkN "näytelmä" ;
lin na'ytelma'llinen_N = mkkN "näytelmällinen" ;
lin na'ytille_Adv = mkkAdv "näytille" ;
lin na'ytilla'_Adv = mkkAdv "näytillä" ;
lin na'ytin_N = mkkN "näytin" ;
lin na'ytteille_Adv = mkkAdv "näytteille" ;
lin na'ytteilla'_Adv = mkkAdv "näytteillä" ;
lin na'yttelija'_N = mkkN "näyttelijä" ;
lin na'yttelija'ta'r_N = mkkN "näyttelijätär" ;
lin na'yttely_N = mkkN "näyttely" ;
lin na'ytta'ma'_N = mkkN "näyttämä" ;
lin na'ytta'mo'_N = mkkN "näyttämö" ;
lin na'ytta'mo'llinen_N = mkkN "näyttämöllinen" ;
lin na'ytta'va'_N = mkkN "näyttävä" ;
lin na'ytta'ytya'_V = mkkV "näyttäytyä" ;
lin na'ytta'a'_V = mkkV "näyttää" ;
lin na'ytto'_N = mkkN "näyttö" ;
lin na'ytto'inen_N = mkkN "näyttöinen" ;
lin na'yta'nto'_N = mkkN "näytäntö" ;
lin na'yto'ksinen_N = mkkN "näytöksinen" ;
lin na'yto's_N = mkkN "näytös" ;
lin na'a'mma'_Adv = mkkAdv "näämmä" ;
lin na'a'nnyksiin_Adv = mkkAdv "näännyksiin" ;
lin na'a'nnyksissa'_Adv = mkkAdv "näännyksissä" ;
lin na'a'nnytta'a'_V = mkkV "näännyttää" ;
lin na'a'ntymys_N = mkkN "nääntymys" ;
lin na'a'ntya'_V = mkkV "nääntyä" ;
lin na'a's_Adv = mkkAdv "nääs" ;
lin na'a't_Adv = mkkAdv "näät" ;
lin na'a'tsen_Adv = mkkAdv "näätsen" ;
lin na'a'ta'_N = mkkN "näätä" ;
lin no'f_Adv = mkkAdv "nöf" ;
lin no'ko'tta'a'_V = mkkV "nököttää" ;
lin no'rtti_N = mkkN "nörtti" ;
lin no'sso'_N = mkkN "nössö" ;
lin no'yhta'_N = mkkN "nöyhtä" ;
lin no'yhta'inen_N = mkkN "nöyhtäinen" ;
lin no'yhta'ytya'_V = mkkV "nöyhtäytyä" ;
lin no'yhta'a'ntya'_V = mkkV "nöyhtääntyä" ;
lin no'yristella'_V = mkkV "nöyristellä" ;
lin no'yristely_N = mkkN "nöyristely" ;
lin no'yrrytta'a'_V = mkkV "nöyrryttää" ;
lin no'yrtymys_N = mkkN "nöyrtymys" ;
lin no'yrtya'_V = mkkV "nöyrtyä" ;
lin no'yryys_N = mkkN "nöyryys" ;
lin no'yryytta'a'_V = mkkV "nöyryyttää" ;
lin no'yryytys_N = mkkN "nöyryytys" ;
lin no'yra'_A = mkkA "nöyrä" ;
lin no'yra'sti_Adv = mkkAdv "nöyrästi" ;
lin oas_N = mkkN "oas" ;
lin obduktio_N = mkkN "obduktio" ;
lin obeliski_N = mkkN "obeliski" ;
lin objekti_N = mkkN "objekti" ;
lin objektiivi_N = mkkN "objektiivi" ;
lin objektiivinen_A = mkkA "objektiivinen" ;
lin objektiivisesti_Adv = mkkAdv "objektiivisesti" ;
lin objektiivisuus_N = mkkN "objektiivisuus" ;
lin obligaatio_N = mkkN "obligaatio" ;
lin obligatorinen_N = mkkN "obligatorinen" ;
lin oboe_N = mkkN "oboe" ;
lin oboisti_N = mkkN "oboisti" ;
lin observatorio_N = mkkN "observatorio" ;
lin observoida_V = mkkV "observoida" ;
lin observoija_N = mkkN "observoija" ;
lin observointi_N = mkkN "observointi" ;
lin obstruktio_N = mkkN "obstruktio" ;
lin odelma_N = mkkN "odelma" ;
lin odelmikko_N = mkkN "odelmikko" ;
lin odontologi_N = mkkN "odontologi" ;
lin odontologia_N = mkkN "odontologia" ;
lin odontologinen_N = mkkN "odontologinen" ;
lin odotella_V = mkkV "odotella" ;
lin odotetusti_Adv = mkkAdv "odotetusti" ;
lin odottaa_V = mkkV "odottaa" ;
lin odottamaton_N = mkkN "odottamaton" ;
lin odottamatta_Adv = mkkAdv "odottamatta" ;
lin odottamattomasti_Adv = mkkAdv "odottamattomasti" ;
lin odotus_N = mkkN "odotus" ;
lin odotusaika_N = mkkN "odotusaika" ;
lin odotuttaa_V = mkkV "odotuttaa" ;
lin odysseia_N = mkkN "odysseia" ;
lin offensiivi_N = mkkN "offensiivi" ;
lin offensiivinen_N = mkkN "offensiivinen" ;
lin offset_N = mkkN "offset" ;
lin oh_Adv = mkkAdv "oh" ;
lin ohari_N = mkkN "ohari" ;
lin ohdake_N = mkkN "ohdake" ;
lin ohdakkeinen_N = mkkN "ohdakkeinen" ;
lin oheen_Adv = mkkAdv "oheen" ;
lin oheinen_N = mkkN "oheinen" ;
lin oheistaa_V = mkkV "oheistaa" ;
lin ohella_Adv = mkkAdv "ohella" ;
lin ohenne_N = mkkN "ohenne" ;
lin ohennus_N = mkkN "ohennus" ;
lin ohentaa_V = mkkV "ohentaa" ;
lin ohenteinen_N = mkkN "ohenteinen" ;
lin ohentua_V = mkkV "ohentua" ;
lin ohentuma_N = mkkN "ohentuma" ;
lin ohessa_Adv = mkkAdv "ohessa" ;
lin ohesta_Adv = mkkAdv "ohesta" ;
lin oheta_V = mkkV "oheta" ;
lin ohhoh_Adv = mkkAdv "ohhoh" ;
lin ohhoijaa_Adv = mkkAdv "ohhoijaa" ;
lin ohi_Adv = mkkAdv "ohi" ;
lin ohikiita'va'_N = mkkN "ohikiitävä" ;
lin ohimeneva'sti_Adv = mkkAdv "ohimenevästi" ;
lin ohimennen_Adv = mkkAdv "ohimennen" ;
lin ohimo_N = mkkN "ohimo" ;
lin ohitella_V = mkkV "ohitella" ;
lin ohitse_Adv = mkkAdv "ohitse" ;
lin ohittaa_V = mkkV "ohittaa" ;
lin ohittelu_N = mkkN "ohittelu" ;
lin ohittua_V = mkkV "ohittua" ;
lin ohitus_N = mkkN "ohitus" ;
lin ohja_N = mkkN "ohja" ;
lin ohjaaja_N = mkkN "ohjaaja" ;
lin ohjaamo_N = mkkN "ohjaamo" ;
lin ohjailla_V = mkkV "ohjailla" ;
lin ohjailu_N = mkkN "ohjailu" ;
lin ohjain_N = mkkN "ohjain" ;
lin ohjanta_N = mkkN "ohjanta" ;
lin ohjas_N = mkkN "ohjas" ;
lin ohjastaa_V = mkkV "ohjastaa" ;
lin ohjastaja_N = mkkN "ohjastaja" ;
lin ohjastus_N = mkkN "ohjastus" ;
lin ohjata_V = mkkV "ohjata" ;
lin ohjattava_N = mkkN "ohjattava" ;
lin ohjattavuus_N = mkkN "ohjattavuus" ;
lin ohjauksinen_N = mkkN "ohjauksinen" ;
lin ohjaus_N = mkkN "ohjaus" ;
lin ohjautua_V = mkkV "ohjautua" ;
lin ohjautuvuus_N = mkkN "ohjautuvuus" ;
lin ohje_N = mkkN "ohje" ;
lin ohjeellinen_N = mkkN "ohjeellinen" ;
lin ohjeistaa_V = mkkV "ohjeistaa" ;
lin ohjeisto_N = mkkN "ohjeisto" ;
lin ohjeistus_N = mkkN "ohjeistus" ;
lin ohjelma_N = mkkN "ohjelma" ;
lin ohjelmainen_N = mkkN "ohjelmainen" ;
lin ohjelmallinen_A = mkkA "ohjelmallinen" ;
lin ohjelmallisesti_Adv = mkkAdv "ohjelmallisesti" ;
lin ohjelmallisuus_N = mkkN "ohjelmallisuus" ;
lin ohjelmisto_N = mkkN "ohjelmisto" ;
lin ohjelmoida_V = mkkV "ohjelmoida" ;
lin ohjelmoija_N = mkkN "ohjelmoija" ;
lin ohjelmointi_N = mkkN "ohjelmointi" ;
lin ohjus_N = mkkN "ohjus" ;
lin ohkainen_N = mkkN "ohkainen" ;
lin ohmi_N = mkkN "ohmi" ;
lin oho_Adv = mkkAdv "oho" ;
lin ohoh_Adv = mkkAdv "ohoh" ;
lin ohoi_Adv = mkkAdv "ohoi" ;
lin ohra_N = mkkN "ohra" ;
lin ohrainen_A = mkkA "ohrainen" ;
lin ohraisesti_Adv = mkkAdv "ohraisesti" ;
lin ohrana_N = mkkN "ohrana" ;
lin ohuelti_Adv = mkkAdv "ohuelti" ;
lin ohuesti_Adv = mkkAdv "ohuesti" ;
lin ohuinen_N = mkkN "ohuinen" ;
lin ohukainen_N = mkkN "ohukainen" ;
lin ohukas_N = mkkN "ohukas" ;
lin ohut_N = mkkN "ohut" ;
lin ohuus_N = mkkN "ohuus" ;
lin oi_Adv = mkkAdv "oi" ;
lin oidipaalinen_N = mkkN "oidipaalinen" ;
lin oieta_V = mkkV "oieta" ;
lin oijoi_Adv = mkkAdv "oijoi" ;
lin oikaista_V = mkkV "oikaista" ;
lin oikaisu_N = mkkN "oikaisu" ;
lin oikea_A = mkkA "oikea" ;
lin oikea_aikaisesti_Adv = mkkAdv "oikea-aikaisesti" ;
lin oikeaan_Adv = mkkAdv "oikeaan" ;
lin oikealla_Adv = mkkAdv "oikealla" ;
lin oikealle_Adv = mkkAdv "oikealle" ;
lin oikealta_Adv = mkkAdv "oikealta" ;
lin oikeamielisesti_Adv = mkkAdv "oikeamielisesti" ;
lin oikeammin_Adv = mkkAdv "oikeammin" ;
lin oikeanlainen_N = mkkN "oikeanlainen" ;
lin oikeaoppisesti_Adv = mkkAdv "oikeaoppisesti" ;
lin oikeassa_Adv = mkkAdv "oikeassa" ;
lin oikeastaan_Adv = mkkAdv "oikeastaan" ;
lin oikeasti_Adv = mkkAdv "oikeasti" ;
lin oikeellinen_N = mkkN "oikeellinen" ;
lin oikeellisuus_N = mkkN "oikeellisuus" ;
lin oikein_Adv = mkkAdv "oikein" ;
lin oikein_pa'in_Adv = mkkAdv "oikeiC" ;
lin oikeisto_N = mkkN "oikeisto" ;
lin oikeistolaistua_V = mkkV "oikeistolaistua" ;
lin oikeistolaisuus_N = mkkN "oikeistolaisuus" ;
lin oikeudellinen_A = mkkA "oikeudellinen" ;
lin oikeudellisesti_Adv = mkkAdv "oikeudellisesti" ;
lin oikeudeton_N = mkkN "oikeudeton" ;
lin oikeudettomasti_Adv = mkkAdv "oikeudettomasti" ;
lin oikeus_N = mkkN "oikeus" ;
lin oikeutettu_N = mkkN "oikeutettu" ;
lin oikeutetusti_Adv = mkkAdv "oikeutetusti" ;
lin oikeuttaa_V = mkkV "oikeuttaa" ;
lin oikeutus_N = mkkN "oikeutus" ;
lin oikku_N = mkkN "oikku" ;
lin oikkuilija_N = mkkN "oikkuilija" ;
lin oikkuilla_V = mkkV "oikkuilla" ;
lin oikkuilu_N = mkkN "oikkuilu" ;
lin oikoa_V = mkkV "oikoa" ;
lin oikoilla_V = mkkV "oikoilla" ;
lin oikoinen_N = mkkN "oikoinen" ;
lin oikoisenaan_Adv = mkkAdv "oikoisenaan" ;
lin oikopa'a'ta'_Adv = mkkAdv "oikopäätä" ;
lin oikukas_A = mkkA "oikukas" ;
lin oikukkaasti_Adv = mkkAdv "oikukkaasti" ;
lin oikukkuus_N = mkkN "oikukkuus" ;
lin oikullinen_A = mkkA "oikullinen" ;
lin oikullisesti_Adv = mkkAdv "oikullisesti" ;
lin oikullisuus_N = mkkN "oikullisuus" ;
lin oikutella_V = mkkV "oikutella" ;
lin oikuttelija_N = mkkN "oikuttelija" ;
lin oikuttelu_N = mkkN "oikuttelu" ;
lin oinas_N = mkkN "oinas" ;
lin oionta_N = mkkN "oionta" ;
lin oire_N = mkkN "oire" ;
lin oireellinen_N = mkkN "oireellinen" ;
lin oireeton_N = mkkN "oireeton" ;
lin oirehtia_V = mkkV "oirehtia" ;
lin oireilla_V = mkkV "oireilla" ;
lin oireilu_N = mkkN "oireilu" ;
lin oireinen_N = mkkN "oireinen" ;
lin oireisto_N = mkkN "oireisto" ;
lin oitis_Adv = mkkAdv "oitis" ;
lin oiva_N = mkkN "oiva" ;
lin oivallinen_A = mkkA "oivallinen" ;
lin oivallisesti_Adv = mkkAdv "oivallisesti" ;
lin oivallisuus_N = mkkN "oivallisuus" ;
lin oivallus_N = mkkN "oivallus" ;
lin oivaltaa_V = mkkV "oivaltaa" ;
lin oja_N = mkkN "oja" ;
lin oja_aura_N = mkkN "oja-aura" ;
lin ojasto_N = mkkN "ojasto" ;
lin ojennella_V = mkkV "ojennella" ;
lin ojennus_N = mkkN "ojennus" ;
lin ojentaa_V = mkkV "ojentaa" ;
lin ojentaja_N = mkkN "ojentaja" ;
lin ojentautua_V = mkkV "ojentautua" ;
lin ojentua_V = mkkV "ojentua" ;
lin ojikko_N = mkkN "ojikko" ;
lin ojittaa_V = mkkV "ojittaa" ;
lin ojitus_N = mkkN "ojitus" ;
lin ojolla_Adv = mkkAdv "ojolla" ;
lin ojollaan_Adv = mkkAdv "ojollaan" ;
lin ojolle_Adv = mkkAdv "ojolle" ;
lin ojolleen_Adv = mkkAdv "ojolleen" ;
lin ojoon_Adv = mkkAdv "ojoon" ;
lin ojossa_Adv = mkkAdv "ojossa" ;
lin ojuke_N = mkkN "ojuke" ;
lin OK_Adv = mkkAdv "OK" ;
lin oka_N = mkkN "oka" ;
lin okainen_N = mkkN "okainen" ;
lin okariina_N = mkkN "okariina" ;
lin okei_Adv = mkkAdv "okei" ;
lin okkultismi_N = mkkN "okkultismi" ;
lin okkultisti_N = mkkN "okkultisti" ;
lin okkulttinen_N = mkkN "okkulttinen" ;
lin okra_1_N = mkkN "okra" ;
lin okra_2_N = mkkN "okra" ;
lin oksa_N = mkkN "oksa" ;
lin oksainen_N = mkkN "oksainen" ;
lin oksaisuus_N = mkkN "oksaisuus" ;
lin oksakas_N = mkkN "oksakas" ;
lin oksastaa_V = mkkV "oksastaa" ;
lin oksasto_N = mkkN "oksasto" ;
lin oksennella_V = mkkV "oksennella" ;
lin oksennus_N = mkkN "oksennus" ;
lin oksennuttaa_V = mkkV "oksennuttaa" ;
lin oksentaa_V = mkkV "oksentaa" ;
lin oksentelu_N = mkkN "oksentelu" ;
lin oksete_N = mkkN "oksete" ;
lin oksettaa_V = mkkV "oksettaa" ;
lin oksetus_N = mkkN "oksetus" ;
lin oksia_V = mkkV "oksia" ;
lin oksidi_N = mkkN "oksidi" ;
lin oksidoida_V = mkkV "oksidoida" ;
lin oksidoitua_V = mkkV "oksidoitua" ;
lin oksinta_N = mkkN "oksinta" ;
lin oksisto_N = mkkN "oksisto" ;
lin oktaani_N = mkkN "oktaani" ;
lin oktaaninen_N = mkkN "oktaaninen" ;
lin oktaavi_N = mkkN "oktaavi" ;
lin oktaedri_N = mkkN "oktaedri" ;
lin oktetti_N = mkkN "oktetti" ;
lin oktetto_N = mkkN "oktetto" ;
lin okulaari_N = mkkN "okulaari" ;
lin olake_N = mkkN "olake" ;
lin olakkain_Adv = mkkAdv "olakkain" ;
lin olas_N = mkkN "olas" ;
lin oleanteri_N = mkkN "oleanteri" ;
lin oleellinen_N = mkkN "oleellinen" ;
lin oleilla_V = mkkV "oleilla" ;
lin oleilu_N = mkkN "oleilu" ;
lin oleksia_V = mkkV "oleksia" ;
lin olematon_N = mkkN "olematon" ;
lin olemattomuus_N = mkkN "olemattomuus" ;
lin olemus_N = mkkN "olemus" ;
lin olennainen_A = mkkA "olennainen" ;
lin olennaisesti_Adv = mkkAdv "olennaisesti" ;
lin olennaisuus_N = mkkN "olennaisuus" ;
lin olento_N = mkkN "olento" ;
lin oleskella_V = mkkV "oleskella" ;
lin oleskelu_N = mkkN "oleskelu" ;
lin oletettavasti_Adv = mkkAdv "oletettavasti" ;
lin olettaa_V = mkkV "olettaa" ;
lin olettamus_N = mkkN "olettamus" ;
lin oletus_N = mkkN "oletus" ;
lin oleva_N = mkkN "oleva" ;
lin olevainen_N = mkkN "olevainen" ;
lin olevaisuus_N = mkkN "olevaisuus" ;
lin olevinaan_Adv = mkkAdv "olevinaan" ;
lin oligarkia_N = mkkN "oligarkia" ;
lin oligarkkinen_N = mkkN "oligarkkinen" ;
lin oligopoli_N = mkkN "oligopoli" ;
lin oliivi_N = mkkN "oliivi" ;
lin olija_N = mkkN "olija" ;
lin olio_N = mkkN "olio" ;
lin olka_N = mkkN "olka" ;
lin olkaimellinen_N = mkkN "olkaimellinen" ;
lin olkaiminen_N = mkkN "olkaiminen" ;
lin olkain_N = mkkN "olkain" ;
lin olki_N = mkkN "olki" ;
lin olkinen_N = mkkN "olkinen" ;
lin olla_V = mkkV "olla" ;
lin ollenkaan_Adv = mkkAdv "ollenkaan" ;
lin olletikaan_Adv = mkkAdv "olletikaan" ;
lin olletikin_Adv = mkkAdv "olletikin" ;
lin olmi_N = mkkN "olmi" ;
lin olo_N = mkkN "olo" ;
lin oloaika_N = mkkN "oloaika" ;
lin oloinen_N = mkkN "oloinen" ;
--? lin oltavat_NK = {s = d10 "oltavat" ;
lin oltermanni_N = mkkN "oltermanni" ;
lin olut_N = mkkN "olut" ;
lin olvi_N = mkkN "olvi" ;
lin olympiadi_N = mkkN "olympiadi" ;
--? lin olympialaiset_NK = {s = d38 "olympialaiset" ;
lin olympolainen_N = mkkN "olympolainen" ;
lin oma_N = mkkN "oma" ;
lin oma_aloitteisesti_Adv = mkkAdv "oma-aloitteisesti" ;
lin oma_aloitteisuus_N = mkkN "oma-aloitteisuus" ;
lin omaehtoisesti_Adv = mkkAdv "omaehtoisesti" ;
lin omaharkintainen_N = mkkN "omaharkintainen" ;
lin omahyva'inen_A = mkkA "omahyväinen" ;
lin omahyva'isesti_Adv = mkkAdv "omahyväisesti" ;
lin omahyva'isyys_N = mkkN "omahyväisyys" ;
lin omainen_A = mkkA "omainen" ;
lin omainen_A = mkkA "omainen" ;
lin omaisesti_Adv = mkkAdv "omaisesti" ;
lin omaisuus_N = mkkN "omaisuus" ;
lin omaisuus_N = mkkN "omaisuus" ;
lin omakohtaisesti_Adv = mkkAdv "omakohtaisesti" ;
lin omaksua_V = mkkV "omaksua" ;
lin omaka'tisesti_Adv = mkkAdv "omakätisesti" ;
lin omalaatuisesti_Adv = mkkAdv "omalaatuisesti" ;
lin omaleimaisuus_N = mkkN "omaleimaisuus" ;
lin omanlainen_N = mkkN "omanlainen" ;
lin omapera'isesti_Adv = mkkAdv "omaperäisesti" ;
lin omapa'isesti_Adv = mkkAdv "omapäisesti" ;
lin omapa'isyys_N = mkkN "omapäisyys" ;
lin omata_V = mkkV "omata" ;
lin omatoimisesti_Adv = mkkAdv "omatoimisesti" ;
lin omatoimisuus_N = mkkN "omatoimisuus" ;
lin omavaloinen_N = mkkN "omavaloinen" ;
lin omavaltaisesti_Adv = mkkAdv "omavaltaisesti" ;
lin omavaraistaa_V = mkkV "omavaraistaa" ;
lin omavaraistua_V = mkkV "omavaraistua" ;
lin omavastuisesti_Adv = mkkAdv "omavastuisesti" ;
lin omavastuuaika_N = mkkN "omavastuuaika" ;
lin omeletti_N = mkkN "omeletti" ;
lin omena_N = mkkN "omena" ;
lin ometta_N = mkkN "ometta" ;
lin omia_V = mkkV "omia" ;
lin omiaan_Adv = mkkAdv "omiaan" ;
lin omiansa_Adv = mkkAdv "omiansa" ;
lin omillaan_Adv = mkkAdv "omillaan" ;
lin omilleen_Adv = mkkAdv "omilleen" ;
lin ominainen_A = mkkA "ominainen" ;
lin ominaisesti_Adv = mkkAdv "ominaisesti" ;
lin ominaisuus_N = mkkN "ominaisuus" ;
lin omintakeinen_A = mkkA "omintakeinen" ;
lin omintakeisesti_Adv = mkkAdv "omintakeisesti" ;
lin omintakeisuus_N = mkkN "omintakeisuus" ;
lin omistaa_V = mkkV "omistaa" ;
lin omistaja_N = mkkN "omistaja" ;
lin omistautua_V = mkkV "omistautua" ;
lin omiste_N = mkkN "omiste" ;
lin omisteinen_N = mkkN "omisteinen" ;
lin omistus_N = mkkN "omistus" ;
lin omistushaluisesti_Adv = mkkAdv "omistushaluisesti" ;
lin omistusliitteellinen_N = mkkN "omistusliitteellinen" ;
lin omistusliitteeto'n_N = mkkN "omistusliitteetön" ;
lin omistusliitteinen_N = mkkN "omistusliitteinen" ;
lin omituinen_A = mkkA "omituinen" ;
lin omituisesti_Adv = mkkAdv "omituisesti" ;
lin omituisuus_N = mkkN "omituisuus" ;
lin ommel_N = mkkN "ommel" ;
lin ommella_V = mkkV "ommella" ;
lin omnipotenssi_N = mkkN "omnipotenssi" ;
lin ompele_N = mkkN "ompele" ;
lin ompeleinen_N = mkkN "ompeleinen" ;
lin ompelija_N = mkkN "ompelija" ;
lin ompelimo_N = mkkN "ompelimo" ;
lin ompelu_N = mkkN "ompelu" ;
lin ompelus_N = mkkN "ompelus" ;
lin ompeluttaa_V = mkkV "ompeluttaa" ;
lin omppu_N = mkkN "omppu" ;
lin onania_N = mkkN "onania" ;
lin onanoida_V = mkkV "onanoida" ;
lin ongelma_N = mkkN "ongelma" ;
lin ongelmainen_N = mkkN "ongelmainen" ;
lin ongelmallinen_A = mkkA "ongelmallinen" ;
lin ongelmallisesti_Adv = mkkAdv "ongelmallisesti" ;
lin ongelmallisuus_N = mkkN "ongelmallisuus" ;
lin ongelmaton_N = mkkN "ongelmaton" ;
lin ongelmisto_N = mkkN "ongelmisto" ;
lin onginta_N = mkkN "onginta" ;
lin onkalo_N = mkkN "onkalo" ;
lin onki_N = mkkN "onki" ;
lin onkia_V = mkkV "onkia" ;
lin onkija_N = mkkN "onkija" ;
lin onkogeeninen_N = mkkN "onkogeeninen" ;
lin onkogeenisuus_N = mkkN "onkogeenisuus" ;
lin onkologia_N = mkkN "onkologia" ;
lin onnahdella_V = mkkV "onnahdella" ;
lin onnahdus_N = mkkN "onnahdus" ;
lin onnahtaa_V = mkkV "onnahtaa" ;
lin onnahtelu_N = mkkN "onnahtelu" ;
lin onnekas_A = mkkA "onnekas" ;
lin onnekkaasti_Adv = mkkAdv "onnekkaasti" ;
lin onnekkuus_N = mkkN "onnekkuus" ;
lin onneksi_Adv = mkkAdv "onneksi" ;
lin onnela_N = mkkN "onnela" ;
lin onnellinen_A = mkkA "onnellinen" ;
lin onnellisesti_Adv = mkkAdv "onnellisesti" ;
lin onnellistaa_V = mkkV "onnellistaa" ;
lin onnellistuttaa_V = mkkV "onnellistuttaa" ;
lin onnellisuus_N = mkkN "onnellisuus" ;
lin onnenaika_N = mkkN "onnenaika" ;
lin onnenkantamoinen_N = mkkN "onnenkantamoinen" ;
lin onnenpotkaus_N = mkkN "onnenpotkaus" ;
lin onnenpotku_N = mkkN "onnenpotku" ;
lin onnentoivottaja_N = mkkN "onnentoivottaja" ;
lin onnestaa_V = mkkV "onnestaa" ;
lin onnetar_N = mkkN "onnetar" ;
lin onneton_N = mkkN "onneton" ;
lin onnettomasti_Adv = mkkAdv "onnettomasti" ;
lin onnettomuus_N = mkkN "onnettomuus" ;
lin onni_N = mkkN "onni" ;
lin onnikka_N = mkkN "onnikka" ;
lin onninen_N = mkkN "onninen" ;
lin onnistaa_V = mkkV "onnistaa" ;
lin onnistua_V = mkkV "onnistua" ;
lin onnistuneesti_Adv = mkkAdv "onnistuneesti" ;
lin onnistuneisuus_N = mkkN "onnistuneisuus" ;
lin onnistunut_A = mkkA "onnistunut" ;
lin onnitella_V = mkkV "onnitella" ;
lin onnittelija_N = mkkN "onnittelija" ;
lin onnittelu_N = mkkN "onnittelu" ;
lin onomastiikka_N = mkkN "onomastiikka" ;
lin onomatopoeettinen_N = mkkN "onomatopoeettinen" ;
lin onomatopoieettinen_N = mkkN "onomatopoieettinen" ;
lin ontelo_N = mkkN "ontelo" ;
lin onteloida_V = mkkV "onteloida" ;
lin onteloinen_N = mkkN "onteloinen" ;
lin onteloitua_V = mkkV "onteloitua" ;
lin ontosti_Adv = mkkAdv "ontosti" ;
lin ontto_N = mkkN "ontto" ;
lin onttous_N = mkkN "onttous" ;
lin ontua_V = mkkV "ontua" ;
lin onyksi_N = mkkN "onyksi" ;
lin oodi_N = mkkN "oodi" ;
lin oomega_N = mkkN "oomega" ;
lin oopiumi_N = mkkN "oopiumi" ;
lin ooppera_N = mkkN "ooppera" ;
lin ootrata_V = mkkV "ootrata" ;
lin ootraus_N = mkkN "ootraus" ;
lin opaakki_N = mkkN "opaakki" ;
lin opaali_N = mkkN "opaali" ;
lin opalisoida_V = mkkV "opalisoida" ;
lin opas_N = mkkN "opas" ;
lin opastaa_V = mkkV "opastaa" ;
lin opastaja_N = mkkN "opastaja" ;
lin opaste_N = mkkN "opaste" ;
lin opastin_N = mkkN "opastin" ;
lin opastus_N = mkkN "opastus" ;
lin ope_N = mkkN "ope" ;
lin open_house_N = mkkN "opeC" ;
lin operaatio_N = mkkN "operaatio" ;
lin operaattori_N = mkkN "operaattori" ;
lin operatiivinen_A = mkkA "operatiivinen" ;
lin operatiivisesti_Adv = mkkAdv "operatiivisesti" ;
lin operationaalinen_N = mkkN "operationaalinen" ;
lin operato'o'ri_N = mkkN "operatööri" ;
lin operetti_N = mkkN "operetti" ;
lin operoida_V = mkkV "operoida" ;
lin operoija_N = mkkN "operoija" ;
lin operointi_N = mkkN "operointi" ;
lin opetella_V = mkkV "opetella" ;
lin opettaa_V = mkkV "opettaa" ;
lin opettaja_N = mkkN "opettaja" ;
lin opettajainen_N = mkkN "opettajainen" ;
lin opettajatar_N = mkkN "opettajatar" ;
lin opettajisto_N = mkkN "opettajisto" ;
lin opettava_A = mkkA "opettava" ;
lin opettavainen_A = mkkA "opettavainen" ;
lin opettavaisesti_Adv = mkkAdv "opettavaisesti" ;
lin opettavaisuus_N = mkkN "opettavaisuus" ;
lin opettavasti_Adv = mkkAdv "opettavasti" ;
lin opettavuus_N = mkkN "opettavuus" ;
lin opettelu_N = mkkN "opettelu" ;
lin opetuksellinen_N = mkkN "opetuksellinen" ;
lin opetus_N = mkkN "opetus" ;
lin opiaatti_N = mkkN "opiaatti" ;
lin opillinen_A = mkkA "opillinen" ;
lin opillisesti_Adv = mkkAdv "opillisesti" ;
--? lin opinnot_NK = {s = d01A "opinnot" ;
lin opiskelija_N = mkkN "opiskelija" ;
lin opiskella_V = mkkV "opiskella" ;
lin opiskelu_N = mkkN "opiskelu" ;
lin opiskeluaika_N = mkkN "opiskeluaika" ;
lin opisto_N = mkkN "opisto" ;
lin opo_N = mkkN "opo" ;
lin opossumi_N = mkkN "opossumi" ;
lin oppi_N = mkkN "oppi" ;
lin oppia_V = mkkV "oppia" ;
lin oppiaika_N = mkkN "oppiaika" ;
lin oppilas_N = mkkN "oppilas" ;
lin oppimaton_N = mkkN "oppimaton" ;
lin oppineesti_Adv = mkkAdv "oppineesti" ;
lin oppineisto_N = mkkN "oppineisto" ;
lin oppineisuus_N = mkkN "oppineisuus" ;
lin oppinen_N = mkkN "oppinen" ;
lin oppinut_A = mkkA "oppinut" ;
lin oppisopimusaika_N = mkkN "oppisopimusaika" ;
lin oppisuus_N = mkkN "oppisuus" ;
lin oppivainen_N = mkkN "oppivainen" ;
lin opponentti_N = mkkN "opponentti" ;
lin opponoida_V = mkkV "opponoida" ;
lin opponointi_N = mkkN "opponointi" ;
lin opportunismi_N = mkkN "opportunismi" ;
lin opportunisti_N = mkkN "opportunisti" ;
lin opportunistinen_N = mkkN "opportunistinen" ;
lin oppositio_N = mkkN "oppositio" ;
lin optiikka_N = mkkN "optiikka" ;
lin optikko_N = mkkN "optikko" ;
lin optimaalinen_N = mkkN "optimaalinen" ;
lin optimi_N = mkkN "optimi" ;
lin optimismi_N = mkkN "optimismi" ;
lin optimisti_N = mkkN "optimisti" ;
lin optimistinen_A = mkkA "optimistinen" ;
lin optimistisesti_Adv = mkkAdv "optimistisesti" ;
lin optimistisuus_N = mkkN "optimistisuus" ;
lin optimoida_V = mkkV "optimoida" ;
lin optimointi_N = mkkN "optimointi" ;
lin optinen_A = mkkA "optinen" ;
lin optio_N = mkkN "optio" ;
lin optisesti_Adv = mkkAdv "optisesti" ;
lin optometria_N = mkkN "optometria" ;
lin opuntia_N = mkkN "opuntia" ;
lin opus_N = mkkN "opus" ;
lin ora_N = mkkN "ora" ;
lin oraakkeli_N = mkkN "oraakkeli" ;
lin oraakkelimaisesti_Adv = mkkAdv "oraakkelimaisesti" ;
lin orakas_N = mkkN "orakas" ;
lin orangutangi_N = mkkN "orangutangi" ;
lin oranki_N = mkkN "oranki" ;
lin oranssi_N = mkkN "oranssi" ;
lin oranssinen_N = mkkN "oranssinen" ;
lin oras_N = mkkN "oras" ;
lin orastaa_V = mkkV "orastaa" ;
lin orastua_V = mkkV "orastua" ;
lin orastus_N = mkkN "orastus" ;
lin oratorio_N = mkkN "oratorio" ;
lin orava_N = mkkN "orava" ;
lin ordinaatta_N = mkkN "ordinaatta" ;
lin ordoviikki_N = mkkN "ordoviikki" ;
lin ordoviikkinen_N = mkkN "ordoviikkinen" ;
lin oregano_N = mkkN "oregano" ;
lin orgaani_N = mkkN "orgaani" ;
lin orgaaninen_A = mkkA "orgaaninen" ;
lin orgaanisesti_Adv = mkkAdv "orgaanisesti" ;
lin organdi_N = mkkN "organdi" ;
lin organisaatio_N = mkkN "organisaatio" ;
lin organisaattori_N = mkkN "organisaattori" ;
lin organisatorinen_N = mkkN "organisatorinen" ;
lin organismi_N = mkkN "organismi" ;
lin organisoida_V = mkkV "organisoida" ;
lin organisoija_N = mkkN "organisoija" ;
lin organisointi_N = mkkN "organisointi" ;
lin organisoitua_V = mkkV "organisoitua" ;
lin organogeeninen_N = mkkN "organogeeninen" ;
lin orgasmi_N = mkkN "orgasmi" ;
lin orgastinen_N = mkkN "orgastinen" ;
--? lin orgiat_NK = {s = d12 "orgiat" ;
lin orhi_N = mkkN "orhi" ;
lin ori_N = mkkN "ori" ;
lin oribletti_N = mkkN "oribletti" ;
lin orientaalinen_N = mkkN "orientaalinen" ;
lin orientaatio_N = mkkN "orientaatio" ;
lin orientalisti_N = mkkN "orientalisti" ;
lin orientalistiikka_N = mkkN "orientalistiikka" ;
lin orientoida_V = mkkV "orientoida" ;
lin orientointi_N = mkkN "orientointi" ;
lin orientoitua_V = mkkV "orientoitua" ;
lin orientti_N = mkkN "orientti" ;
lin originaali_N = mkkN "originaali" ;
lin originaalinen_N = mkkN "originaalinen" ;
lin originaalisuus_N = mkkN "originaalisuus" ;
lin originaliteetti_N = mkkN "originaliteetti" ;
lin originelli_N = mkkN "originelli" ;
lin origo_N = mkkN "origo" ;
lin orja_N = mkkN "orja" ;
lin orjailla_V = mkkV "orjailla" ;
lin orjailu_N = mkkN "orjailu" ;
lin orjallinen_A = mkkA "orjallinen" ;
lin orjallisesti_Adv = mkkAdv "orjallisesti" ;
lin orjamaisesti_Adv = mkkAdv "orjamaisesti" ;
lin orjanlaakeri_N = mkkN "orjanlaakeri" ;
lin orjuus_N = mkkN "orjuus" ;
lin orjuuttaa_V = mkkV "orjuuttaa" ;
lin orjuutus_N = mkkN "orjuutus" ;
lin orkesteri_N = mkkN "orkesteri" ;
lin orkestraatio_N = mkkN "orkestraatio" ;
lin orkestroida_V = mkkV "orkestroida" ;
lin orkestrointi_N = mkkN "orkestrointi" ;
lin orkidea_N = mkkN "orkidea" ;
lin orkku_N = mkkN "orkku" ;
lin ornamentaalinen_N = mkkN "ornamentaalinen" ;
lin ornamentiikka_N = mkkN "ornamentiikka" ;
lin ornamentti_N = mkkN "ornamentti" ;
lin ornitologi_N = mkkN "ornitologi" ;
lin ornitologia_N = mkkN "ornitologia" ;
lin ornitologinen_N = mkkN "ornitologinen" ;
lin orpana_N = mkkN "orpana" ;
lin orpo_N = mkkN "orpo" ;
lin orpous_N = mkkN "orpous" ;
lin orsi_N = mkkN "orsi" ;
lin ortodoksi_N = mkkN "ortodoksi" ;
lin ortodoksia_N = mkkN "ortodoksia" ;
lin ortodoksinen_N = mkkN "ortodoksinen" ;
lin ortodoksisuus_N = mkkN "ortodoksisuus" ;
lin ortografia_N = mkkN "ortografia" ;
lin ortopedi_N = mkkN "ortopedi" ;
lin ortopedia_N = mkkN "ortopedia" ;
lin ortopedinen_N = mkkN "ortopedinen" ;
lin orvaskesi_N = mkkN "orvaskesi" ;
lin orvokki_N = mkkN "orvokki" ;
lin osa_N = mkkN "osa" ;
lin osaaja_N = mkkN "osaaja" ;
lin osaaminen_N = mkkN "osaaminen" ;
lin osaaottavasti_Adv = mkkAdv "osaaottavasti" ;
lin osainen_N = mkkN "osainen" ;
lin osaisuus_N = mkkN "osaisuus" ;
lin osakas_N = mkkN "osakas" ;
lin osake_N = mkkN "osake" ;
lin osakesa'a'sta'minen_N = mkkN "osakesäästäminen" ;
lin osakkeisto_N = mkkN "osakkeisto" ;
lin osakkuus_N = mkkN "osakkuus" ;
lin osakseen_Adv = mkkAdv "osakseen" ;
lin osaksi_Adv = mkkAdv "osaksi" ;
lin osallinen_N = mkkN "osallinen" ;
lin osallistua_V = mkkV "osallistua" ;
lin osallistuja_N = mkkN "osallistuja" ;
lin osallisuus_N = mkkN "osallisuus" ;
lin osanen_N = mkkN "osanen" ;
lin osapuilleen_Adv = mkkAdv "osapuilleen" ;
lin osapa'iva'toimisesti_Adv = mkkAdv "osapäivätoimisesti" ;
lin osasto_N = mkkN "osasto" ;
lin osastoida_V = mkkV "osastoida" ;
lin osastoinen_N = mkkN "osastoinen" ;
lin osata_V = mkkV "osata" ;
lin osaton_N = mkkN "osaton" ;
lin osattomuus_N = mkkN "osattomuus" ;
lin oseanologia_N = mkkN "oseanologia" ;
lin oselotti_N = mkkN "oselotti" ;
lin osin_Adv = mkkAdv "osin" ;
lin osinko_N = mkkN "osinko" ;
lin osio_N = mkkN "osio" ;
lin ositella_V = mkkV "ositella" ;
lin ositettava_N = mkkN "ositettava" ;
lin osittaa_V = mkkV "osittaa" ;
lin osittain_Adv = mkkAdv "osittain" ;
lin osittainen_N = mkkN "osittainen" ;
lin osittelu_N = mkkN "osittelu" ;
lin ositus_N = mkkN "ositus" ;
lin oskillaatio_N = mkkN "oskillaatio" ;
lin oskillaattori_N = mkkN "oskillaattori" ;
lin oskilloskooppi_N = mkkN "oskilloskooppi" ;
lin osmium_N = mkkN "osmium" ;
lin osmoosi_N = mkkN "osmoosi" ;
lin osmoottinen_N = mkkN "osmoottinen" ;
lin osoite_N = mkkN "osoite" ;
lin osoitella_V = mkkV "osoitella" ;
lin osoitin_N = mkkN "osoitin" ;
lin osoittaa_V = mkkV "osoittaa" ;
lin osoittaja_N = mkkN "osoittaja" ;
lin osoittautua_V = mkkV "osoittautua" ;
lin osoitteisto_N = mkkN "osoitteisto" ;
lin osoittelu_N = mkkN "osoittelu" ;
lin osoitus_N = mkkN "osoitus" ;
lin ossi_N = mkkN "ossi" ;
lin osso_buco_N = mkkN "ossC" ;
lin ostaa_V = mkkV "ostaa" ;
lin ostaja_N = mkkN "ostaja" ;
lin ostari_N = mkkN "ostari" ;
lin ostattaa_V = mkkV "ostattaa" ;
lin ostella_V = mkkV "ostella" ;
lin ostelu_N = mkkN "ostelu" ;
lin osteomalasia_N = mkkN "osteomalasia" ;
lin osteopaatti_N = mkkN "osteopaatti" ;
lin osteopatia_N = mkkN "osteopatia" ;
lin osteoporoosi_N = mkkN "osteoporoosi" ;
lin osteri_N = mkkN "osteri" ;
lin ostjakki_N = mkkN "ostjakki" ;
lin osto_N = mkkN "osto" ;
lin ostos_N = mkkN "ostos" ;
lin osua_V = mkkV "osua" ;
lin osuma_N = mkkN "osuma" ;
lin osuttaa_V = mkkV "osuttaa" ;
lin osuus_N = mkkN "osuus" ;
lin osuva_A = mkkA "osuva" ;
lin osuvasti_Adv = mkkAdv "osuvasti" ;
lin osuvuus_N = mkkN "osuvuus" ;
lin osviitta_N = mkkN "osviitta" ;
lin ota_N = mkkN "ota" ;
lin otakilokki_N = mkkN "otakilokki" ;
lin otaksua_V = mkkV "otaksua" ;
lin otaksuma_N = mkkN "otaksuma" ;
lin otaksuttavasti_Adv = mkkAdv "otaksuttavasti" ;
lin otanta_N = mkkN "otanta" ;
lin otattaa_V = mkkV "otattaa" ;
lin ote_N = mkkN "ote" ;
lin otella_V = mkkV "otella" ;
lin otin_N = mkkN "otin" ;
lin otollinen_A = mkkA "otollinen" ;
lin otollisesti_Adv = mkkAdv "otollisesti" ;
lin otollisuus_N = mkkN "otollisuus" ;
lin otos_N = mkkN "otos" ;
lin otsa_N = mkkN "otsa" ;
lin otsainen_N = mkkN "otsainen" ;
lin otsake_N = mkkN "otsake" ;
lin otselotti_N = mkkN "otselotti" ;
lin otsikko_N = mkkN "otsikko" ;
lin otsikoida_V = mkkV "otsikoida" ;
lin otsikointi_N = mkkN "otsikointi" ;
lin otso_N = mkkN "otso" ;
lin otsoni_N = mkkN "otsoni" ;
lin otsonisoida_V = mkkV "otsonisoida" ;
lin otsonoida_V = mkkV "otsonoida" ;
lin otsonointi_N = mkkN "otsonointi" ;
lin ottaa_V = mkkV "ottaa" ;
lin ottaja_N = mkkN "ottaja" ;
lin ottamo_N = mkkN "ottamo" ;
lin ottava_N = mkkN "ottava" ;
lin otteinen_N = mkkN "otteinen" ;
lin ottelija_N = mkkN "ottelija" ;
lin ottelu_N = mkkN "ottelu" ;
lin otteluaika_N = mkkN "otteluaika" ;
lin otto_N = mkkN "otto" ;
lin ottomaani_N = mkkN "ottomaani" ;
lin otus_N = mkkN "otus" ;
lin oudokseltaan_Adv = mkkAdv "oudokseltaan" ;
lin oudoksua_V = mkkV "oudoksua" ;
lin oudoksunta_N = mkkN "oudoksunta" ;
lin oudoksuttaa_V = mkkV "oudoksuttaa" ;
lin oudostella_V = mkkV "oudostella" ;
lin oudosti_Adv = mkkAdv "oudosti" ;
lin oudostuttaa_V = mkkV "oudostuttaa" ;
lin ounastella_V = mkkV "ounastella" ;
lin out_Adv = mkkAdv "out" ;
lin outo_N = mkkN "outo" ;
lin outous_N = mkkN "outous" ;
lin output_N = mkkN "output" ;
lin outsider_N = mkkN "outsider" ;
lin ouzo_N = mkkN "ouzo" ;
lin ovaali_N = mkkN "ovaali" ;
lin ovaario_N = mkkN "ovaario" ;
lin ovariaalinen_N = mkkN "ovariaalinen" ;
lin ovela_A = mkkA "ovela" ;
lin ovelasti_Adv = mkkAdv "ovelasti" ;
lin oveluus_N = mkkN "oveluus" ;
lin ovenripa_N = mkkN "ovenripa" ;
lin ovi_N = mkkN "ovi" ;
lin ovinen_N = mkkN "ovinen" ;
lin ovipaarinen_N = mkkN "ovipaarinen" ;
lin ovulaatio_N = mkkN "ovulaatio" ;
lin paaduttaa_V = mkkV "paaduttaa" ;
lin paahde_N = mkkN "paahde" ;
lin paahdin_N = mkkN "paahdin" ;
lin paahtaa_V = mkkV "paahtaa" ;
lin paahteinen_N = mkkN "paahteinen" ;
lin paahtimo_N = mkkN "paahtimo" ;
lin paahto_N = mkkN "paahto" ;
lin paahtua_V = mkkV "paahtua" ;
lin paakari_N = mkkN "paakari" ;
lin paakku_N = mkkN "paakku" ;
lin paakkuinen_N = mkkN "paakkuinen" ;
lin paakkuuntua_V = mkkV "paakkuuntua" ;
lin paalain_N = mkkN "paalain" ;
lin paalata_V = mkkV "paalata" ;
lin paalaus_N = mkkN "paalaus" ;
lin paali_N = mkkN "paali" ;
lin paalittaa_V = mkkV "paalittaa" ;
lin paalitus_N = mkkN "paalitus" ;
lin paalu_N = mkkN "paalu" ;
lin paaluttaa_V = mkkV "paaluttaa" ;
lin paalutus_N = mkkN "paalutus" ;
lin paanne_N = mkkN "paanne" ;
lin paanu_N = mkkN "paanu" ;
lin paanuttaa_V = mkkV "paanuttaa" ;
lin paanutus_N = mkkN "paanutus" ;
lin paapattaa_V = mkkV "paapattaa" ;
lin paapatus_N = mkkN "paapatus" ;
lin paapero_N = mkkN "paapero" ;
lin paapoa_V = mkkV "paapoa" ;
lin paappa_N = mkkN "paappa" ;
lin paapuuri_N = mkkN "paapuuri" ;
lin paaria_N = mkkN "paaria" ;
lin paarit_N = mkkN "paarit" ;
lin paarma_N = mkkN "paarma" ;
lin paasata_V = mkkV "paasata" ;
lin paasi_N = mkkN "paasi" ;
lin paa_i_N = mkkN "paaši" ;
lin paasto_N = mkkN "paasto" ;
lin paastonaika_N = mkkN "paastonaika" ;
lin paastota_V = mkkV "paastota" ;
lin paatoksekas_N = mkkN "paatoksekas" ;
lin paatoksellinen_A = mkkA "paatoksellinen" ;
lin paatoksellisesti_Adv = mkkAdv "paatoksellisesti" ;
lin paatos_N = mkkN "paatos" ;
lin paatsama_N = mkkN "paatsama" ;
lin paatti_N = mkkN "paatti" ;
lin paatua_V = mkkV "paatua" ;
lin paatumus_N = mkkN "paatumus" ;
lin paatuneisuus_N = mkkN "paatuneisuus" ;
lin paatunut_N = mkkN "paatunut" ;
lin paavi_N = mkkN "paavi" ;
lin paavillinen_N = mkkN "paavillinen" ;
lin paavius_N = mkkN "paavius" ;
lin padallinen_N = mkkN "padallinen" ;
lin padota_V = mkkV "padota" ;
lin paella_N = mkkN "paella" ;
lin paeta_V = mkkV "paeta" ;
lin pagodi_N = mkkN "pagodi" ;
lin paha_A = mkkA "paha" ;
lin pahainen_N = mkkN "pahainen" ;
lin pahaksua_V = mkkV "pahaksua" ;
lin pahamaineisuus_N = mkkN "pahamaineisuus" ;
lin pahanen_N = mkkN "pahanen" ;
lin pahanilkisesti_Adv = mkkAdv "pahanilkisesti" ;
lin pahanilkisyys_N = mkkN "pahanilkisyys" ;
lin pahankurinen_A = mkkA "pahankurinen" ;
lin pahankurisesti_Adv = mkkAdv "pahankurisesti" ;
lin pahankurisuus_N = mkkN "pahankurisuus" ;
lin pahanlaatuistua_V = mkkV "pahanlaatuistua" ;
lin pahanlainen_A = mkkA "pahanlainen" ;
lin pahanlaisesti_Adv = mkkAdv "pahanlaisesti" ;
lin pahanpa'iva'isesti_Adv = mkkAdv "pahanpäiväisesti" ;
lin pahansuopaisuus_N = mkkN "pahansuopaisuus" ;
lin pahansuopuus_N = mkkN "pahansuopuus" ;
lin pahansuovasti_Adv = mkkAdv "pahansuovasti" ;
lin pahantuulisesti_Adv = mkkAdv "pahantuulisesti" ;
lin pahasti_Adv = mkkAdv "pahasti" ;
lin pahastua_V = mkkV "pahastua" ;
lin pahastuttaa_V = mkkV "pahastuttaa" ;
lin pahe_N = mkkN "pahe" ;
lin paheellinen_A = mkkA "paheellinen" ;
lin paheellisesti_Adv = mkkAdv "paheellisesti" ;
lin paheellisuus_N = mkkN "paheellisuus" ;
lin paheksua_V = mkkV "paheksua" ;
lin paheksunta_N = mkkN "paheksunta" ;
lin pahemmin_Adv = mkkAdv "pahemmin" ;
lin pahennus_N = mkkN "pahennus" ;
lin pahentaa_V = mkkV "pahentaa" ;
lin pahentua_V = mkkV "pahentua" ;
lin paheta_V = mkkV "paheta" ;
lin pahimmillaan_Adv = mkkAdv "pahimmillaan" ;
lin pahimmilleen_Adv = mkkAdv "pahimmilleen" ;
lin pahimmin_Adv = mkkAdv "pahimmin" ;
lin pahimmoiksi_Adv = mkkAdv "pahimmoiksi" ;
lin pahimmoillaan_Adv = mkkAdv "pahimmoillaan" ;
lin pahimmoilleen_Adv = mkkAdv "pahimmoilleen" ;
lin pahiten_Adv = mkkAdv "pahiten" ;
lin pahitteeksi_Adv = mkkAdv "pahitteeksi" ;
lin pahka_N = mkkN "pahka" ;
lin pahkaa_Adv = mkkAdv "pahkaa" ;
lin pahkainen_N = mkkN "pahkainen" ;
lin pahki_Adv = mkkAdv "pahki" ;
lin pahkura_N = mkkN "pahkura" ;
lin pahkurainen_N = mkkN "pahkurainen" ;
lin pahna_N = mkkN "pahna" ;
lin pahnue_N = mkkN "pahnue" ;
lin pahoillaan_Adv = mkkAdv "pahoillaan" ;
lin pahoilleen_Adv = mkkAdv "pahoilleen" ;
lin pahoin_Adv = mkkAdv "pahoin" ;
lin pahoinpitelija'_N = mkkN "pahoinpitelijä" ;
lin pahoinvoiva_N = mkkN "pahoinvoiva" ;
lin pahoitella_V = mkkV "pahoitella" ;
lin pahoittaa_V = mkkV "pahoittaa" ;
lin pahoittua_V = mkkV "pahoittua" ;
lin paholainen_N = mkkN "paholainen" ;
lin pahuksenmoinen_N = mkkN "pahuksenmoinen" ;
lin pahuksesti_Adv = mkkAdv "pahuksesti" ;
lin pahus_N = mkkN "pahus" ;
lin pahuus_N = mkkN "pahuus" ;
lin pahvi_N = mkkN "pahvi" ;
lin pahvinen_N = mkkN "pahvinen" ;
lin pai_1_N = mkkN "pai" ;
lin pai_2_Adv = mkkAdv "pai" ;
lin paidanpesija'_N = mkkN "paidanpesijä" ;
lin paidaton_N = mkkN "paidaton" ;
lin paijata_V = mkkV "paijata" ;
lin paijaus_N = mkkN "paijaus" ;
lin paikalla_Adv = mkkAdv "paikalla" ;
lin paikallaan_Adv = mkkAdv "paikallaan" ;
lin paikalle_Adv = mkkAdv "paikalle" ;
lin paikalleen_Adv = mkkAdv "paikalleen" ;
lin paikallinen_A = mkkA "paikallinen" ;
lin paikallisaika_N = mkkN "paikallisaika" ;
lin paikallisesti_Adv = mkkAdv "paikallisesti" ;
lin paikallistaa_V = mkkV "paikallistaa" ;
lin paikallistua_V = mkkV "paikallistua" ;
lin paikallisuus_N = mkkN "paikallisuus" ;
lin paikalta_Adv = mkkAdv "paikalta" ;
lin paikaltaan_Adv = mkkAdv "paikaltaan" ;
lin paikanna'ytta'ja'_N = mkkN "paikannäyttäjä" ;
lin paikantaa_V = mkkV "paikantaa" ;
lin paikantua_V = mkkV "paikantua" ;
lin paikata_V = mkkV "paikata" ;
lin paikka_N = mkkN "paikka" ;
lin paikkailla_V = mkkV "paikkailla" ;
lin paikkailu_N = mkkN "paikkailu" ;
lin paikkainen_N = mkkN "paikkainen" ;
lin paikkamaalata_V = mkkV "paikkamaalata" ;
lin paikka_paikoin_Adv = mkkAdv "paikkC" ;
lin paikkaus_N = mkkN "paikkaus" ;
lin paikkauttaa_V = mkkV "paikkauttaa" ;
lin paikkeilla_Adv = mkkAdv "paikkeilla" ;
lin paikkeille_Adv = mkkAdv "paikkeille" ;
lin paikkeilta_Adv = mkkAdv "paikkeilta" ;
lin paikko_N = mkkN "paikko" ;
lin paikkuu_N = mkkN "paikkuu" ;
lin paikkuuttaa_V = mkkV "paikkuuttaa" ;
lin paikoillaan_Adv = mkkAdv "paikoillaan" ;
lin paikoilleen_Adv = mkkAdv "paikoilleen" ;
lin paikoiltaan_Adv = mkkAdv "paikoiltaan" ;
lin paikoin_Adv = mkkAdv "paikoin" ;
lin paikoitellen_Adv = mkkAdv "paikoitellen" ;
lin paikoittaa_V = mkkV "paikoittaa" ;
lin paikoittain_Adv = mkkAdv "paikoittain" ;
lin paikoittainen_N = mkkN "paikoittainen" ;
lin paimen_N = mkkN "paimen" ;
lin paimennus_N = mkkN "paimennus" ;
lin paimentaa_V = mkkV "paimentaa" ;
lin paimentolainen_N = mkkN "paimentolainen" ;
lin paimentolaisuus_N = mkkN "paimentolaisuus" ;
lin painaa_V = mkkV "painaa" ;
lin painaja_N = mkkN "painaja" ;
lin painajainen_N = mkkN "painajainen" ;
lin painajaismainen_N = mkkN "painajaismainen" ;
lin painallus_N = mkkN "painallus" ;
lin painaltaa_V = mkkV "painaltaa" ;
lin painama_N = mkkN "painama" ;
lin painamaton_N = mkkN "painamaton" ;
lin painanne_N = mkkN "painanne" ;
lin painanta_N = mkkN "painanta" ;
lin painate_N = mkkN "painate" ;
lin painattaa_V = mkkV "painattaa" ;
lin painatus_N = mkkN "painatus" ;
lin painauma_N = mkkN "painauma" ;
lin painautua_V = mkkV "painautua" ;
lin painautuma_N = mkkN "painautuma" ;
lin painava_A = mkkA "painava" ;
lin painavasti_Adv = mkkAdv "painavasti" ;
lin painavuus_N = mkkN "painavuus" ;
lin paine_N = mkkN "paine" ;
lin paineellinen_N = mkkN "paineellinen" ;
lin paineinen_N = mkkN "paineinen" ;
lin paineistaa_V = mkkV "paineistaa" ;
lin paineistus_N = mkkN "paineistus" ;
lin painella_V = mkkV "painella" ;
lin painelu_N = mkkN "painelu" ;
lin paini_N = mkkN "paini" ;
lin painia_V = mkkV "painia" ;
lin painija_N = mkkN "painija" ;
lin painike_N = mkkN "painike" ;
lin painin_N = mkkN "painin" ;
lin painiskella_V = mkkV "painiskella" ;
lin painiskelu_N = mkkN "painiskelu" ;
lin paino_N = mkkN "paino" ;
lin painoaika_N = mkkN "painoaika" ;
lin painoinen_A = mkkA "painoinen" ;
lin painoisesti_Adv = mkkAdv "painoisesti" ;
lin painoisuus_N = mkkN "painoisuus" ;
lin painokas_A = mkkA "painokas" ;
lin painokerroin_N = mkkN "painokerroin" ;
lin painokkaasti_Adv = mkkAdv "painokkaasti" ;
lin painokkuus_N = mkkN "painokkuus" ;
lin painollinen_N = mkkN "painollinen" ;
lin painos_N = mkkN "painos" ;
lin painostaa_V = mkkV "painostaa" ;
lin painostus_N = mkkN "painostus" ;
lin painoton_N = mkkN "painoton" ;
lin painottaa_V = mkkV "painottaa" ;
lin painotteinen_A = mkkA "painotteinen" ;
lin painotteisesti_Adv = mkkAdv "painotteisesti" ;
lin painotteisuus_N = mkkN "painotteisuus" ;
lin painottomuus_N = mkkN "painottomuus" ;
lin painottua_V = mkkV "painottua" ;
lin painotus_N = mkkN "painotus" ;
lin painua_V = mkkV "painua" ;
lin painuksiin_Adv = mkkAdv "painuksiin" ;
lin painuksissa_Adv = mkkAdv "painuksissa" ;
lin painuksista_Adv = mkkAdv "painuksista" ;
lin painuma_N = mkkN "painuma" ;
lin paise_N = mkkN "paise" ;
lin paiskata_V = mkkV "paiskata" ;
lin paiskautua_V = mkkV "paiskautua" ;
lin paiskella_V = mkkV "paiskella" ;
lin paiskia_V = mkkV "paiskia" ;
lin paiskoa_V = mkkV "paiskoa" ;
lin paistaa_V = mkkV "paistaa" ;
lin paistatella_V = mkkV "paistatella" ;
lin paistattaa_V = mkkV "paistattaa" ;
lin paiste_N = mkkN "paiste" ;
lin paisteinen_N = mkkN "paisteinen" ;
lin paisti_N = mkkN "paisti" ;
lin paistikas_N = mkkN "paistikas" ;
lin paistike_N = mkkN "paistike" ;
lin paisto_N = mkkN "paisto" ;
lin paistoaika_N = mkkN "paistoaika" ;
lin paistos_N = mkkN "paistos" ;
lin paistua_V = mkkV "paistua" ;
lin paisua_V = mkkV "paisua" ;
lin paisuksiin_Adv = mkkAdv "paisuksiin" ;
lin paisuksissa_Adv = mkkAdv "paisuksissa" ;
lin paisutella_V = mkkV "paisutella" ;
lin paisuttaa_V = mkkV "paisuttaa" ;
lin paisuttelu_N = mkkN "paisuttelu" ;
lin paisutus_N = mkkN "paisutus" ;
lin paisuvainen_N = mkkN "paisuvainen" ;
lin paita_N = mkkN "paita" ;
lin paitahihasillaan_Adv = mkkAdv "paitahihasillaan" ;
lin paitahihasilleen_Adv = mkkAdv "paitahihasilleen" ;
lin paitainen_N = mkkN "paitainen" ;
lin paitasillaan_Adv = mkkAdv "paitasillaan" ;
lin paitasilleen_Adv = mkkAdv "paitasilleen" ;
lin paitis_N = mkkN "paitis" ;
lin paitsi_Adv = mkkAdv "paitsi" ;
lin paitsio_N = mkkN "paitsio" ;
lin paja_N = mkkN "paja" ;
lin pajatso_N = mkkN "pajatso" ;
lin pajattaa_V = mkkV "pajattaa" ;
lin pajatus_N = mkkN "pajatus" ;
lin paju_N = mkkN "paju" ;
lin pajukko_N = mkkN "pajukko" ;
lin pajukoitua_V = mkkV "pajukoitua" ;
lin pakaasi_N = mkkN "pakaasi" ;
lin pakahduksiin_Adv = mkkAdv "pakahduksiin" ;
lin pakahduksissa_Adv = mkkAdv "pakahduksissa" ;
lin pakahduksissaan_Adv = mkkAdv "pakahduksissaan" ;
lin pakahduttaa_V = mkkV "pakahduttaa" ;
lin pakahtua_V = mkkV "pakahtua" ;
lin pakana_A = mkkA "pakana" ;
lin pakanallinen_N = mkkN "pakanallinen" ;
lin pakanasti_Adv = mkkAdv "pakanasti" ;
lin pakanuudenaika_N = mkkN "pakanuudenaika" ;
lin pakanuus_N = mkkN "pakanuus" ;
lin pakara_N = mkkN "pakara" ;
lin pakari_N = mkkN "pakari" ;
lin pakastaa_V = mkkV "pakastaa" ;
lin pakastamo_N = mkkN "pakastamo" ;
lin pakaste_N = mkkN "pakaste" ;
lin pakastin_N = mkkN "pakastin" ;
lin pakastua_V = mkkV "pakastua" ;
lin pakastus_N = mkkN "pakastus" ;
lin pakata_1_V = mkkV "pakata" ;
lin pakata_2_V = mkkV "pakata" ;
lin pakeilla_Adv = mkkAdv "pakeilla" ;
lin pakeillaan_Adv = mkkAdv "pakeillaan" ;
lin pakeille_Adv = mkkAdv "pakeille" ;
lin pakeilleen_Adv = mkkAdv "pakeilleen" ;
lin pakeilta_Adv = mkkAdv "pakeilta" ;
lin pakeiltaan_Adv = mkkAdv "pakeiltaan" ;
lin pakenija_N = mkkN "pakenija" ;
lin pakerrus_N = mkkN "pakerrus" ;
lin pakertaa_V = mkkV "pakertaa" ;
lin pakertaja_N = mkkN "pakertaja" ;
lin paketillinen_N = mkkN "paketillinen" ;
lin paketoida_V = mkkV "paketoida" ;
lin paketoija_N = mkkN "paketoija" ;
lin paketointi_N = mkkN "paketointi" ;
lin paketti_N = mkkN "paketti" ;
lin pakina_N = mkkN "pakina" ;
lin pakinoida_V = mkkV "pakinoida" ;
lin pakinoija_N = mkkN "pakinoija" ;
lin pakinointi_N = mkkN "pakinointi" ;
lin pakinoitsija_N = mkkN "pakinoitsija" ;
lin pakista_V = mkkV "pakista" ;
lin pakka_1_N = mkkN "pakka" ;
lin pakka_2_N = mkkN "pakka" ;
lin pakkaaja_N = mkkN "pakkaaja" ;
lin pakkaamo_N = mkkN "pakkaamo" ;
lin pakkaantua_V = mkkV "pakkaantua" ;
lin pakkanen_N = mkkN "pakkanen" ;
lin pakkasrapautuminen_N = mkkN "pakkasrapautuminen" ;
lin pakkaus_N = mkkN "pakkaus" ;
lin pakkauttaa_V = mkkV "pakkauttaa" ;
lin pakkautua_V = mkkV "pakkautua" ;
lin pakkeli_N = mkkN "pakkeli" ;
lin pakki_1_N = mkkN "pakki" ;
lin pakki_2_N = mkkN "pakki" ;
lin pakko_N = mkkN "pakko" ;
lin pakkonaiminen_N = mkkN "pakkonaiminen" ;
lin pakkota'yta'nto'_N = mkkN "pakkotäytäntö" ;
lin paklata_V = mkkV "paklata" ;
lin paklaus_N = mkkN "paklaus" ;
lin pako_N = mkkN "pako" ;
lin pakoilla_V = mkkV "pakoilla" ;
lin pakoilu_N = mkkN "pakoilu" ;
lin pakoinen_N = mkkN "pakoinen" ;
lin pakokauhuinen_N = mkkN "pakokauhuinen" ;
lin pakolaisuus_N = mkkN "pakolaisuus" ;
lin pakollinen_N = mkkN "pakollinen" ;
lin pakollistaa_V = mkkV "pakollistaa" ;
lin pakollisuus_N = mkkN "pakollisuus" ;
lin pakoon_Adv = mkkAdv "pakoon" ;
lin pakosalla_Adv = mkkAdv "pakosalla" ;
lin pakosalle_Adv = mkkAdv "pakosalle" ;
lin pakostakin_Adv = mkkAdv "pakostakin" ;
lin pakote_N = mkkN "pakote" ;
lin pakoton_N = mkkN "pakoton" ;
lin pakottaa_V = mkkV "pakottaa" ;
lin pakottamaton_N = mkkN "pakottamaton" ;
lin pakottautua_V = mkkV "pakottautua" ;
lin pakottava_N = mkkN "pakottava" ;
lin pakottomasti_Adv = mkkAdv "pakottomasti" ;
lin pakottomuus_N = mkkN "pakottomuus" ;
lin pakotus_N = mkkN "pakotus" ;
lin paksu_A = mkkA "paksu" ;
lin paksuinen_N = mkkN "paksuinen" ;
lin paksukainen_N = mkkN "paksukainen" ;
lin paksulti_Adv = mkkAdv "paksulti" ;
lin paksunema_N = mkkN "paksunema" ;
lin paksunnos_N = mkkN "paksunnos" ;
lin paksuntaa_V = mkkV "paksuntaa" ;
lin paksuntua_V = mkkV "paksuntua" ;
lin paksuntuma_N = mkkN "paksuntuma" ;
lin paksusti_Adv = mkkAdv "paksusti" ;
lin paksuta_V = mkkV "paksuta" ;
lin paksuuntua_V = mkkV "paksuuntua" ;
lin paksuuntuma_N = mkkN "paksuuntuma" ;
lin paksuus_N = mkkN "paksuus" ;
lin pakti_N = mkkN "pakti" ;
lin pala_N = mkkN "pala" ;
lin palaa_V = mkkV "palaa" ;
lin palailla_V = mkkV "palailla" ;
lin palamaton_N = mkkN "palamaton" ;
lin palanen_N = mkkN "palanen" ;
lin palata_V = mkkV "palata" ;
lin palatsi_N = mkkN "palatsi" ;
lin palauma_N = mkkN "palauma" ;
lin palaute_N = mkkN "palaute" ;
lin palauttaa_V = mkkV "palauttaa" ;
lin palautua_V = mkkV "palautua" ;
lin palautuma_N = mkkN "palautuma" ;
lin palautus_N = mkkN "palautus" ;
lin palava_N = mkkN "palava" ;
lin palavissaan_Adv = mkkAdv "palavissaan" ;
lin palella_V = mkkV "palella" ;
lin palelluksissa_Adv = mkkAdv "palelluksissa" ;
lin palelluksissaan_Adv = mkkAdv "palelluksissaan" ;
lin palelluttaa_V = mkkV "palelluttaa" ;
lin paleltaa_V = mkkV "paleltaa" ;
lin paleltua_V = mkkV "paleltua" ;
lin paleltuma_N = mkkN "paleltuma" ;
lin paleontologia_N = mkkN "paleontologia" ;
lin paleontologinen_N = mkkN "paleontologinen" ;
lin paleotsooinen_N = mkkN "paleotsooinen" ;
lin paletti_N = mkkN "paletti" ;
lin palho_N = mkkN "palho" ;
lin palikka_N = mkkN "palikka" ;
lin palindromi_N = mkkN "palindromi" ;
lin palisanteri_N = mkkN "palisanteri" ;
lin paljaaltaan_Adv = mkkAdv "paljaaltaan" ;
lin paljakka_N = mkkN "paljakka" ;
lin paljas_N = mkkN "paljas" ;
lin paljasjaloin_Adv = mkkAdv "paljasjaloin" ;
lin paljastaa_V = mkkV "paljastaa" ;
lin paljastaja_N = mkkN "paljastaja" ;
--? lin paljastajaiset_NK = {s = d38 "paljastajaiset" ;
lin paljastin_N = mkkN "paljastin" ;
lin paljastua_V = mkkV "paljastua" ;
lin paljastus_N = mkkN "paljastus" ;
lin palje_N = mkkN "palje" ;
lin paljetti_N = mkkN "paljetti" ;
lin paljin_N = mkkN "paljin" ;
lin paljo_N = mkkN "paljo" ;
lin paljoksua_V = mkkV "paljoksua" ;
lin paljolta_Adv = mkkAdv "paljolta" ;
lin paljolti_Adv = mkkAdv "paljolti" ;
lin paljon_Adv = mkkAdv "paljon" ;
lin paljous_N = mkkN "paljous" ;
lin palju_N = mkkN "palju" ;
lin palkallinen_N = mkkN "palkallinen" ;
lin palkanansaitsija_N = mkkN "palkanansaitsija" ;
lin palkata_V = mkkV "palkata" ;
lin palkaton_N = mkkN "palkaton" ;
lin palkattomasti_Adv = mkkAdv "palkattomasti" ;
lin palkinto_N = mkkN "palkinto" ;
lin palkisto_N = mkkN "palkisto" ;
lin palkita_V = mkkV "palkita" ;
lin palkka_N = mkkN "palkka" ;
lin palkkainen_N = mkkN "palkkainen" ;
lin palkkaisuus_N = mkkN "palkkaisuus" ;
lin palkkaus_N = mkkN "palkkaus" ;
lin palkki_N = mkkN "palkki" ;
lin palkkio_N = mkkN "palkkio" ;
lin palko_N = mkkN "palko" ;
lin palkollinen_N = mkkN "palkollinen" ;
lin palladium_N = mkkN "palladium" ;
lin pallas_N = mkkN "pallas" ;
lin palle_1_N = mkkN "palle" ;
lin palle_2_N = mkkN "palle" ;
lin pallea_N = mkkN "pallea" ;
lin pallero_N = mkkN "pallero" ;
lin palleroinen_N = mkkN "palleroinen" ;
lin palli_1_N = mkkN "palli" ;
lin palli_2_N = mkkN "palli" ;
lin palliatiivinen_N = mkkN "palliatiivinen" ;
lin pallo_N = mkkN "pallo" ;
lin palloilija_N = mkkN "palloilija" ;
lin palloilla_V = mkkV "palloilla" ;
lin palloilu_N = mkkN "palloilu" ;
lin pallokas_N = mkkN "pallokas" ;
lin pallonen_N = mkkN "pallonen" ;
lin pallosilla_Adv = mkkAdv "pallosilla" ;
lin pallosille_Adv = mkkAdv "pallosille" ;
lin pallotella_V = mkkV "pallotella" ;
lin pallottaa_V = mkkV "pallottaa" ;
lin pallottelu_N = mkkN "pallottelu" ;
lin pallotus_N = mkkN "pallotus" ;
lin pallukka_N = mkkN "pallukka" ;
lin palmikko_N = mkkN "palmikko" ;
lin palmikkoinen_N = mkkN "palmikkoinen" ;
lin palmikoida_V = mkkV "palmikoida" ;
lin palmikointi_N = mkkN "palmikointi" ;
lin palmu_N = mkkN "palmu" ;
lin palo_N = mkkN "palo" ;
lin paloa_V = mkkV "paloa" ;
lin palohaava_N = mkkN "palohaava" ;
lin paloilmoitin_N = mkkN "paloilmoitin" ;
lin paloitella_V = mkkV "paloitella" ;
lin paloittain_Adv = mkkAdv "paloittain" ;
lin paloittelu_N = mkkN "paloittelu" ;
lin paloton_N = mkkN "paloton" ;
lin palpaatio_N = mkkN "palpaatio" ;
lin palpakko_N = mkkN "palpakko" ;
lin palpoida_V = mkkV "palpoida" ;
lin palpointi_N = mkkN "palpointi" ;
lin palsa_1_N = mkkN "palsa" ;
lin palsa_2_N = mkkN "palsa" ;
lin palsami_N = mkkN "palsami" ;
lin palsamoida_V = mkkV "palsamoida" ;
lin palsamointi_N = mkkN "palsamointi" ;
lin palsta_N = mkkN "palsta" ;
lin palstainen_N = mkkN "palstainen" ;
lin palsternakka_N = mkkN "palsternakka" ;
lin palstoittaa_V = mkkV "palstoittaa" ;
lin palstoittain_Adv = mkkAdv "palstoittain" ;
lin palstoitus_N = mkkN "palstoitus" ;
lin paltata_V = mkkV "paltata" ;
lin palte_N = mkkN "palte" ;
lin palttaa_V = mkkV "palttaa" ;
lin palttina_N = mkkN "palttina" ;
lin palttoo_N = mkkN "palttoo" ;
lin palttu_1_N = mkkN "palttu" ;
lin palttu_2_N = mkkN "palttu" ;
lin palturi_N = mkkN "palturi" ;
lin paluu_N = mkkN "paluu" ;
lin palvata_V = mkkV "palvata" ;
lin palvaus_N = mkkN "palvaus" ;
lin palvelija_N = mkkN "palvelija" ;
lin palvelijatar_N = mkkN "palvelijatar" ;
lin palvella_V = mkkV "palvella" ;
lin palvelu_N = mkkN "palvelu" ;
lin palveluasuminen_N = mkkN "palveluasuminen" ;
lin palvelus_N = mkkN "palvelus" ;
lin palvelusaika_N = mkkN "palvelusaika" ;
lin palvi_1_N = mkkN "palvi" ;
lin palvi_2_N = mkkN "palvi" ;
lin palvoa_V = mkkV "palvoa" ;
lin palvoja_N = mkkN "palvoja" ;
lin palvonta_N = mkkN "palvonta" ;
lin palvovasti_Adv = mkkAdv "palvovasti" ;
lin pamahdella_V = mkkV "pamahdella" ;
lin pamahdus_N = mkkN "pamahdus" ;
lin pamahtaa_V = mkkV "pamahtaa" ;
lin pamaus_N = mkkN "pamaus" ;
lin pamautella_V = mkkV "pamautella" ;
lin pamauttaa_V = mkkV "pamauttaa" ;
lin pamfletti_N = mkkN "pamfletti" ;
lin pamista_V = mkkV "pamista" ;
lin pampa_N = mkkN "pampa" ;
lin pampattaa_V = mkkV "pampattaa" ;
lin pamppailla_V = mkkV "pamppailla" ;
lin pamppu_1_N = mkkN "pamppu" ;
lin pamppu_2_N = mkkN "pamppu" ;
lin pampula_N = mkkN "pampula" ;
lin pamputtaa_V = mkkV "pamputtaa" ;
lin pamputus_N = mkkN "pamputus" ;
lin panama_N = mkkN "panama" ;
lin panamerikanismi_N = mkkN "panamerikanismi" ;
lin panarabismi_N = mkkN "panarabismi" ;
lin panda_N = mkkN "panda" ;
lin pandeeminen_N = mkkN "pandeeminen" ;
lin pandemia_N = mkkN "pandemia" ;
lin paneeli_N = mkkN "paneeli" ;
lin paneerata_V = mkkV "paneerata" ;
lin paneeraus_N = mkkN "paneeraus" ;
lin panelisti_N = mkkN "panelisti" ;
lin paneloida_V = mkkV "paneloida" ;
lin panelointi_N = mkkN "panelointi" ;
lin paneroida_V = mkkV "paneroida" ;
lin panerointi_N = mkkN "panerointi" ;
lin panetella_V = mkkV "panetella" ;
lin panettaa_V = mkkV "panettaa" ;
lin panettelija_N = mkkN "panettelija" ;
lin panettelu_N = mkkN "panettelu" ;
lin paneutua_V = mkkV "paneutua" ;
--? lin paniaiset_NK = {s = d38 "paniaiset" ;
lin paniikki_N = mkkN "paniikki" ;
lin panija_N = mkkN "panija" ;
lin panimo_N = mkkN "panimo" ;
lin panini_N = mkkN "panini" ;
lin pankki_N = mkkN "pankki" ;
lin pankkiaika_N = mkkN "pankkiaika" ;
lin pankkiiri_N = mkkN "pankkiiri" ;
lin pankkisa'a'sta'minen_N = mkkN "pankkisäästäminen" ;
lin pankko_N = mkkN "pankko" ;
lin panna_1_V = mkkV "panna" ;
lin panna_2_N = mkkN "panna" ;
lin pannahinen_N = mkkN "pannahinen" ;
lin pannari_N = mkkN "pannari" ;
lin pannu_N = mkkN "pannu" ;
lin pannullinen_N = mkkN "pannullinen" ;
lin pano_N = mkkN "pano" ;
lin panoraama_N = mkkN "panoraama" ;
lin panoroida_V = mkkV "panoroida" ;
lin panorointi_N = mkkN "panorointi" ;
lin panos_N = mkkN "panos" ;
lin panostaa_V = mkkV "panostaa" ;
lin panostaja_N = mkkN "panostaja" ;
lin panostus_N = mkkN "panostus" ;
lin panslavismi_N = mkkN "panslavismi" ;
lin panslavisti_N = mkkN "panslavisti" ;
lin panslavistinen_N = mkkN "panslavistinen" ;
lin panssari_N = mkkN "panssari" ;
lin panssaroida_V = mkkV "panssaroida" ;
lin panssarointi_N = mkkN "panssarointi" ;
lin panssaroitua_V = mkkV "panssaroitua" ;
lin panta_N = mkkN "panta" ;
lin pantata_V = mkkV "pantata" ;
lin panteismi_N = mkkN "panteismi" ;
lin panteisti_N = mkkN "panteisti" ;
lin panteistinen_N = mkkN "panteistinen" ;
lin pantomiimi_N = mkkN "pantomiimi" ;
lin pantomiimikko_N = mkkN "pantomiimikko" ;
lin panttaus_N = mkkN "panttaus" ;
lin pantteri_N = mkkN "pantteri" ;
lin pantti_N = mkkN "pantti" ;
lin paossa_Adv = mkkAdv "paossa" ;
lin papaija_N = mkkN "papaija" ;
lin papana_N = mkkN "papana" ;
lin paparazzi_N = mkkN "paparazzi" ;
lin papattaa_V = mkkV "papattaa" ;
lin papatti_N = mkkN "papatti" ;
lin papatus_N = mkkN "papatus" ;
lin paperi_N = mkkN "paperi" ;
lin paperikko_N = mkkN "paperikko" ;
lin paperikoko_N = mkkN "paperikoko" ;
lin paperinen_N = mkkN "paperinen" ;
lin paperiton_N = mkkN "paperiton" ;
lin paperoida_V = mkkV "paperoida" ;
lin paperointi_N = mkkN "paperointi" ;
lin paperossi_N = mkkN "paperossi" ;
lin papiksivihkiminen_N = mkkN "papiksivihkiminen" ;
lin papiljotti_N = mkkN "papiljotti" ;
lin papilla_N = mkkN "papilla" ;
lin papilli_N = mkkN "papilli" ;
lin papillinen_A = mkkA "papillinen" ;
lin papillisesti_Adv = mkkAdv "papillisesti" ;
lin papillisuus_N = mkkN "papillisuus" ;
lin papillooma_N = mkkN "papillooma" ;
lin papisto_N = mkkN "papisto" ;
lin papitar_N = mkkN "papitar" ;
lin paplari_N = mkkN "paplari" ;
lin pappa_N = mkkN "pappa" ;
lin papparainen_N = mkkN "papparainen" ;
lin pappenheimilainen_N = mkkN "pappenheimilainen" ;
lin pappeus_N = mkkN "pappeus" ;
lin pappi_N = mkkN "pappi" ;
lin pappila_N = mkkN "pappila" ;
lin paprika_N = mkkN "paprika" ;
lin papu_N = mkkN "papu" ;
lin papukaija_N = mkkN "papukaija" ;
lin papyrus_N = mkkN "papyrus" ;
lin par_N = mkkN "par" ;
lin para_N = mkkN "para" ;
lin paraabeli_N = mkkN "paraabeli" ;
lin paraati_N = mkkN "paraati" ;
lin parabellum_N = mkkN "parabellum" ;
lin parabolinen_N = mkkN "parabolinen" ;
lin paraboloidi_N = mkkN "paraboloidi" ;
lin paradigma_N = mkkN "paradigma" ;
lin paradoksaalinen_A = mkkA "paradoksaalinen" ;
lin paradoksaalisesti_Adv = mkkAdv "paradoksaalisesti" ;
lin paradoksaalisuus_N = mkkN "paradoksaalisuus" ;
lin paradoksi_N = mkkN "paradoksi" ;
lin paradoksinen_N = mkkN "paradoksinen" ;
lin paradoksisuus_N = mkkN "paradoksisuus" ;
lin parafinoida_V = mkkV "parafinoida" ;
lin parafinointi_N = mkkN "parafinointi" ;
lin parafoida_V = mkkV "parafoida" ;
lin parafointi_N = mkkN "parafointi" ;
lin paragrafi_N = mkkN "paragrafi" ;
lin parahdus_N = mkkN "parahdus" ;
lin parahiksi_Adv = mkkAdv "parahiksi" ;
lin parahin_N = mkkN "parahin" ;
lin parahtaa_V = mkkV "parahtaa" ;
lin parahultainen_N = mkkN "parahultainen" ;
lin paraikaa_Adv = mkkAdv "paraikaa" ;
lin paraiksi_Adv = mkkAdv "paraiksi" ;
lin paraillaan_Adv = mkkAdv "paraillaan" ;
lin paraiten_Adv = mkkAdv "paraiten" ;
lin parakki_N = mkkN "parakki" ;
lin parallaksi_N = mkkN "parallaksi" ;
lin paralleelinen_N = mkkN "paralleelinen" ;
lin paralleelisuus_N = mkkN "paralleelisuus" ;
lin paralleelius_N = mkkN "paralleelius" ;
lin parallelismi_N = mkkN "parallelismi" ;
--? lin paralympialaiset_NK = {s = d38 "paralympialaiset" ;
lin paranee_V = mkkV "paranee" ;
lin parannella_V = mkkV "parannella" ;
lin parannus_N = mkkN "parannus" ;
lin paranoia_N = mkkN "paranoia" ;
lin paranoidi_N = mkkN "paranoidi" ;
lin paranoidinen_N = mkkN "paranoidinen" ;
lin paranooikko_N = mkkN "paranooikko" ;
lin paranooinen_N = mkkN "paranooinen" ;
lin parantaa_V = mkkV "parantaa" ;
lin parantelu_N = mkkN "parantelu" ;
lin parantola_N = mkkN "parantola" ;
lin parantua_V = mkkV "parantua" ;
lin parantumaton_N = mkkN "parantumaton" ;
lin parantumattomasti_Adv = mkkAdv "parantumattomasti" ;
lin parantumattomuus_N = mkkN "parantumattomuus" ;
lin paras_N = mkkN "paras" ;
lin parasiitti_N = mkkN "parasiitti" ;
lin parastaikaa_Adv = mkkAdv "parastaikaa" ;
lin parata_1_V = mkkV "parata" ;
lin parata_2_Adv = mkkAdv "parata" ;
lin paratiisi_N = mkkN "paratiisi" ;
lin paratkoon_Adv = mkkAdv "paratkoon" ;
lin par_avion_Adv = mkkAdv "paC" ;
lin pareittain_Adv = mkkAdv "pareittain" ;
lin pareittainen_N = mkkN "pareittainen" ;
lin paremmin_Adv = mkkAdv "paremmin" ;
lin paremmuus_N = mkkN "paremmuus" ;
lin parempi_N = mkkN "parempi" ;
--? lin parfait_NK = {s = d22 "parfait" ;
lin parfee_N = mkkN "parfee" ;
lin parfymeria_N = mkkN "parfymeria" ;
lin parfymoida_V = mkkV "parfymoida" ;
lin parfymointi_N = mkkN "parfymointi" ;
lin parfyymi_N = mkkN "parfyymi" ;
lin parhaastaan_Adv = mkkAdv "parhaastaan" ;
lin parhaiksi_Adv = mkkAdv "parhaiksi" ;
lin parhaillaan_Adv = mkkAdv "parhaillaan" ;
lin parhaimmillaan_Adv = mkkAdv "parhaimmillaan" ;
lin parhaimmin_Adv = mkkAdv "parhaimmin" ;
lin parhaimmisto_N = mkkN "parhaimmisto" ;
lin parhain_N = mkkN "parhain" ;
lin parhaisto_N = mkkN "parhaisto" ;
lin parhaiten_Adv = mkkAdv "parhaiten" ;
lin pari_1_N = mkkN "pari" ;
lin pari_2_N = mkkN "pari" ;
lin pariin_Adv = mkkAdv "pariin" ;
lin pariisitar_N = mkkN "pariisitar" ;
lin parikki_N = mkkN "parikki" ;
lin parila_N = mkkN "parila" ;
lin parilehdykka'inen_N = mkkN "parilehdykkäinen" ;
lin parillinen_N = mkkN "parillinen" ;
lin pariloida_V = mkkV "pariloida" ;
lin parinen_N = mkkN "parinen" ;
lin parisen_Adv = mkkAdv "parisen" ;
lin parisenkymmenta'_Adv = mkkAdv "parisenkymmentä" ;
lin parisensataa_Adv = mkkAdv "parisensataa" ;
lin parissa_Adv = mkkAdv "parissa" ;
lin parista_Adv = mkkAdv "parista" ;
lin paristo_N = mkkN "paristo" ;
lin pariteetti_N = mkkN "pariteetti" ;
lin paritella_V = mkkV "paritella" ;
lin pariton_N = mkkN "pariton" ;
lin parittaa_V = mkkV "parittaa" ;
lin parittain_Adv = mkkAdv "parittain" ;
lin parittainen_N = mkkN "parittainen" ;
lin parittaja_N = mkkN "parittaja" ;
lin parittelu_N = mkkN "parittelu" ;
lin paritteluaika_N = mkkN "paritteluaika" ;
lin paritus_N = mkkN "paritus" ;
lin paritusten_Adv = mkkAdv "paritusten" ;
lin pariutua_V = mkkV "pariutua" ;
lin parjaaja_N = mkkN "parjaaja" ;
lin parjata_V = mkkV "parjata" ;
lin parjaus_N = mkkN "parjaus" ;
lin parka_1_N = mkkN "parka" ;
lin parka_2_N = mkkN "parka" ;
lin parkaista_V = mkkV "parkaista" ;
lin parkaisu_N = mkkN "parkaisu" ;
lin parketoida_V = mkkV "parketoida" ;
lin parketti_N = mkkN "parketti" ;
lin parkinsonismi_N = mkkN "parkinsonismi" ;
lin parkinta_N = mkkN "parkinta" ;
lin parkita_V = mkkV "parkita" ;
lin parkitsimo_N = mkkN "parkitsimo" ;
lin parkitus_N = mkkN "parkitus" ;
lin parkkeerata_V = mkkV "parkkeerata" ;
lin parkkeeraus_N = mkkN "parkkeeraus" ;
lin parkki_1_N = mkkN "parkki" ;
lin parkki_2_N = mkkN "parkki" ;
lin parkki_3_N = mkkN "parkki" ;
lin parkki_4_N = mkkN "parkki" ;
lin parkkiintua_V = mkkV "parkkiintua" ;
lin parkkiutua_V = mkkV "parkkiutua" ;
lin parku_N = mkkN "parku" ;
lin parkua_V = mkkV "parkua" ;
lin parkuna_N = mkkN "parkuna" ;
lin parlamentaarikko_N = mkkN "parlamentaarikko" ;
lin parlamentaarinen_A = mkkA "parlamentaarinen" ;
lin parlamentaarisesti_Adv = mkkAdv "parlamentaarisesti" ;
lin parlamentaarisuus_N = mkkN "parlamentaarisuus" ;
lin parlamentarismi_N = mkkN "parlamentarismi" ;
lin parlamentti_N = mkkN "parlamentti" ;
lin parmesaani_N = mkkN "parmesaani" ;
lin parnasso_N = mkkN "parnasso" ;
lin parodia_N = mkkN "parodia" ;
lin parodinen_A = mkkA "parodinen" ;
lin parodioida_V = mkkV "parodioida" ;
lin parodiointi_N = mkkN "parodiointi" ;
lin parodisesti_Adv = mkkAdv "parodisesti" ;
lin parodisuus_N = mkkN "parodisuus" ;
lin paroni_N = mkkN "paroni" ;
lin paronitar_N = mkkN "paronitar" ;
lin parras_N = mkkN "parras" ;
lin parraton_N = mkkN "parraton" ;
lin parroittua_V = mkkV "parroittua" ;
lin parru_N = mkkN "parru" ;
lin parsa_N = mkkN "parsa" ;
lin parsek_N = mkkN "parsek" ;
lin parsi_N = mkkN "parsi" ;
lin parsia_V = mkkV "parsia" ;
lin parsimus_N = mkkN "parsimus" ;
lin parsinta_N = mkkN "parsinta" ;
lin parta_N = mkkN "parta" ;
lin partaalla_Adv = mkkAdv "partaalla" ;
lin partaalle_Adv = mkkAdv "partaalle" ;
lin partainen_N = mkkN "partainen" ;
lin partasuinen_N = mkkN "partasuinen" ;
lin partavaahdoke_N = mkkN "partavaahdoke" ;
lin partenogeneesi_N = mkkN "partenogeneesi" ;
lin partenogeneettinen_N = mkkN "partenogeneettinen" ;
lin partia_N = mkkN "partia" ;
lin partikkeli_N = mkkN "partikkeli" ;
lin partio_N = mkkN "partio" ;
lin partioida_V = mkkV "partioida" ;
lin partiointi_N = mkkN "partiointi" ;
lin partisaani_N = mkkN "partisaani" ;
lin partisiippi_N = mkkN "partisiippi" ;
lin partitiivi_N = mkkN "partitiivi" ;
lin partituuri_N = mkkN "partituuri" ;
lin partneri_N = mkkN "partneri" ;
lin parturi_N = mkkN "parturi" ;
lin parturoida_V = mkkV "parturoida" ;
lin parturointi_N = mkkN "parturointi" ;
lin party_N = mkkN "party" ;
lin parveilla_V = mkkV "parveilla" ;
lin parveilu_N = mkkN "parveilu" ;
lin parveiluaika_N = mkkN "parveiluaika" ;
lin parveke_N = mkkN "parveke" ;
lin parvellinen_N = mkkN "parvellinen" ;
lin parveutua_V = mkkV "parveutua" ;
lin parvi_1_N = mkkN "parvi" ;
lin parvi_2_N = mkkN "parvi" ;
lin parvittain_Adv = mkkAdv "parvittain" ;
lin pas_Adv = mkkAdv "pas" ;
lin pasaati_N = mkkN "pasaati" ;
lin pascal_N = mkkN "pascal" ;
lin paseerailla_V = mkkV "paseerailla" ;
lin paseerata_V = mkkV "paseerata" ;
lin pasha_N = mkkN "pasha" ;
lin pasianssi_N = mkkN "pasianssi" ;
lin pasifismi_N = mkkN "pasifismi" ;
lin pasifisti_N = mkkN "pasifisti" ;
lin pasifistinen_A = mkkA "pasifistinen" ;
lin pasifistisesti_Adv = mkkAdv "pasifistisesti" ;
lin pasifistisuus_N = mkkN "pasifistisuus" ;
lin paska_N = mkkN "paska" ;
lin paskainen_N = mkkN "paskainen" ;
lin paskantaa_V = mkkV "paskantaa" ;
lin paskiainen_N = mkkN "paskiainen" ;
lin pasma_N = mkkN "pasma" ;
lin pasmata_V = mkkV "pasmata" ;
lin passata_1_V = mkkV "passata" ;
lin passata_2_V = mkkV "passata" ;
lin passauttaa_V = mkkV "passauttaa" ;
lin passeli_N = mkkN "passeli" ;
--? lin passepartout_NK = {s = d22 "passepartout" ;
lin passi_1_N = mkkN "passi" ;
lin passi_2_N = mkkN "passi" ;
lin passi_3_N = mkkN "passi" ;
lin passi_4_N = mkkN "passi" ;
--? lin passiivat_NK = {s = d12 "passiivat" ;
lin passiivi_N = mkkN "passiivi" ;
lin passiivinen_A = mkkA "passiivinen" ;
lin passiivisesti_Adv = mkkAdv "passiivisesti" ;
lin passiivistaa_V = mkkV "passiivistaa" ;
lin passiivistua_V = mkkV "passiivistua" ;
lin passiivisuus_N = mkkN "passiivisuus" ;
lin passio_N = mkkN "passio" ;
lin passittaa_V = mkkV "passittaa" ;
lin passitus_N = mkkN "passitus" ;
lin passivoida_V = mkkV "passivoida" ;
lin passivoitua_V = mkkV "passivoitua" ;
lin passus_N = mkkN "passus" ;
lin pasta_N = mkkN "pasta" ;
lin pasteerailla_V = mkkV "pasteerailla" ;
lin pasteerata_V = mkkV "pasteerata" ;
lin pasteija_N = mkkN "pasteija" ;
lin pastelli_N = mkkN "pastelli" ;
lin pastoraali_N = mkkN "pastoraali" ;
lin pastoraalinen_N = mkkN "pastoraalinen" ;
lin pasto'roida_V = mkkV "pastöroida" ;
lin pasto'rointi_N = mkkN "pastörointi" ;
lin pasunisti_N = mkkN "pasunisti" ;
lin pasuri_N = mkkN "pasuri" ;
lin pasuttaa_V = mkkV "pasuttaa" ;
lin pasutus_N = mkkN "pasutus" ;
lin pasuuna_N = mkkN "pasuuna" ;
lin pata_1_N = mkkN "pata" ;
lin pata_2_N = mkkN "pata" ;
lin pataani_N = mkkN "pataani" ;
lin pataljoona_N = mkkN "pataljoona" ;
lin pataluhaksi_Adv = mkkAdv "pataluhaksi" ;
lin patee_N = mkkN "patee" ;
lin pateetikko_N = mkkN "pateetikko" ;
lin pateettinen_A = mkkA "pateettinen" ;
lin pateettisesti_Adv = mkkAdv "pateettisesti" ;
lin pateettisuus_N = mkkN "pateettisuus" ;
lin patentoida_V = mkkV "patentoida" ;
lin patentointi_N = mkkN "patentointi" ;
lin patentti_N = mkkN "patentti" ;
lin patenttisuoja_N = mkkN "patenttisuoja" ;
lin patiini_N = mkkN "patiini" ;
lin patikoida_V = mkkV "patikoida" ;
lin patikointi_N = mkkN "patikointi" ;
lin patina_N = mkkN "patina" ;
lin patinoida_V = mkkV "patinoida" ;
lin patinointi_N = mkkN "patinointi" ;
lin patinoitua_V = mkkV "patinoitua" ;
lin patio_N = mkkN "patio" ;
lin patistaa_V = mkkV "patistaa" ;
lin patistella_V = mkkV "patistella" ;
lin patistus_N = mkkN "patistus" ;
lin patja_N = mkkN "patja" ;
lin pato_N = mkkN "pato" ;
lin patogeeninen_N = mkkN "patogeeninen" ;
lin patologi_N = mkkN "patologi" ;
lin patologia_N = mkkN "patologia" ;
lin patologinen_N = mkkN "patologinen" ;
lin patonki_N = mkkN "patonki" ;
lin patouma_N = mkkN "patouma" ;
lin patous_N = mkkN "patous" ;
lin patoutua_V = mkkV "patoutua" ;
lin patoutuma_N = mkkN "patoutuma" ;
lin patriarkaalinen_N = mkkN "patriarkaalinen" ;
lin patriarkaatti_N = mkkN "patriarkaatti" ;
lin patriarkallinen_N = mkkN "patriarkallinen" ;
lin patriarkka_N = mkkN "patriarkka" ;
lin patriisi_N = mkkN "patriisi" ;
lin patriootti_N = mkkN "patriootti" ;
lin patrioottinen_N = mkkN "patrioottinen" ;
lin patriotismi_N = mkkN "patriotismi" ;
lin patronyymi_N = mkkN "patronyymi" ;
lin patruuna_1_N = mkkN "patruuna" ;
lin patruuna_2_N = mkkN "patruuna" ;
lin patsas_N = mkkN "patsas" ;
lin patsastella_V = mkkV "patsastella" ;
lin patsastelu_N = mkkN "patsastelu" ;
lin patteri_N = mkkN "patteri" ;
lin patteristi_N = mkkN "patteristi" ;
lin patteristo_N = mkkN "patteristo" ;
lin patti_1_N = mkkN "patti" ;
lin patti_2_N = mkkN "patti" ;
lin patu_N = mkkN "patu" ;
lin patukka_N = mkkN "patukka" ;
lin pauhata_V = mkkV "pauhata" ;
lin pauhina_N = mkkN "pauhina" ;
lin pauhu_N = mkkN "pauhu" ;
lin paukahdella_V = mkkV "paukahdella" ;
lin paukahdus_N = mkkN "paukahdus" ;
lin paukahtaa_V = mkkV "paukahtaa" ;
lin paukama_N = mkkN "paukama" ;
lin paukaus_N = mkkN "paukaus" ;
lin paukautella_V = mkkV "paukautella" ;
lin paukauttaa_V = mkkV "paukauttaa" ;
lin pauke_N = mkkN "pauke" ;
lin paukkaa_V = mkkV "paukkaa" ;
lin paukkina_N = mkkN "paukkina" ;
lin paukku_N = mkkN "paukku" ;
lin paukkua_V = mkkV "paukkua" ;
lin paukutella_V = mkkV "paukutella" ;
lin paukuttaa_V = mkkV "paukuttaa" ;
lin paukuttelu_N = mkkN "paukuttelu" ;
lin paukutus_N = mkkN "paukutus" ;
lin paula_N = mkkN "paula" ;
lin pauloittaa_V = mkkV "pauloittaa" ;
lin pauloitus_N = mkkN "pauloitus" ;
lin pauna_N = mkkN "pauna" ;
lin paunikko_N = mkkN "paunikko" ;
lin paussi_N = mkkN "paussi" ;
lin paviaani_N = mkkN "paviaani" ;
lin paviljonki_N = mkkN "paviljonki" ;
lin pedaali_N = mkkN "pedaali" ;
lin pedagogi_N = mkkN "pedagogi" ;
lin pedagogia_N = mkkN "pedagogia" ;
lin pedagogiikka_N = mkkN "pedagogiikka" ;
lin pedagoginen_A = mkkA "pedagoginen" ;
lin pedagogisesti_Adv = mkkAdv "pedagogisesti" ;
lin pedantti_N = mkkN "pedantti" ;
lin pedanttinen_A = mkkA "pedanttinen" ;
lin pedanttisesti_Adv = mkkAdv "pedanttisesti" ;
lin pedanttisuus_N = mkkN "pedanttisuus" ;
lin pedata_V = mkkV "pedata" ;
lin pederasti_N = mkkN "pederasti" ;
lin pederastia_N = mkkN "pederastia" ;
lin pederastinen_N = mkkN "pederastinen" ;
lin pediatri_N = mkkN "pediatri" ;
lin pediatria_N = mkkN "pediatria" ;
lin pedikyristi_N = mkkN "pedikyristi" ;
lin pedikyyri_N = mkkN "pedikyyri" ;
lin pedofiili_N = mkkN "pedofiili" ;
lin pedofiilinen_N = mkkN "pedofiilinen" ;
lin pedofilia_N = mkkN "pedofilia" ;
lin pee_N = mkkN "pee" ;
lin peeaa_N = mkkN "peeaa" ;
lin peesata_V = mkkV "peesata" ;
lin peesi_N = mkkN "peesi" ;
lin peevelinmoinen_N = mkkN "peevelinmoinen" ;
lin peevelisti_Adv = mkkAdv "peevelisti" ;
lin peea'rra'_N = mkkN "peeärrä" ;
lin peffa_N = mkkN "peffa" ;
lin pegasos_N = mkkN "pegasos" ;
lin pegmatiitti_N = mkkN "pegmatiitti" ;
lin peherrys_N = mkkN "peherrys" ;
lin peherta'a'_V = mkkV "pehertää" ;
lin pehko_N = mkkN "pehko" ;
lin pehku_N = mkkN "pehku" ;
lin pehmeikko'_N = mkkN "pehmeikkö" ;
lin pehmennys_N = mkkN "pehmennys" ;
lin pehmentya'_V = mkkV "pehmentyä" ;
lin pehmenta'a'_V = mkkV "pehmentää" ;
lin pehmeta'_V = mkkV "pehmetä" ;
lin pehmeys_N = mkkN "pehmeys" ;
lin pehmea'_A = mkkA "pehmeä" ;
lin pehmea'sti_Adv = mkkAdv "pehmeästi" ;
lin pehmike_N = mkkN "pehmike" ;
lin pehmis_N = mkkN "pehmis" ;
lin pehmite_N = mkkN "pehmite" ;
lin pehmitin_N = mkkN "pehmitin" ;
lin pehmittya'_V = mkkV "pehmittyä" ;
lin pehmitta'a'_V = mkkV "pehmittää" ;
lin pehmitys_N = mkkN "pehmitys" ;
lin pehmita'_V = mkkV "pehmitä" ;
lin pehmo_N = mkkN "pehmo" ;
lin pehmoilija_N = mkkN "pehmoilija" ;
lin pehmoilla_V = mkkV "pehmoilla" ;
lin pehmoilu_N = mkkN "pehmoilu" ;
lin pehmoinen_N = mkkN "pehmoinen" ;
lin pehmustaa_V = mkkV "pehmustaa" ;
lin pehmuste_N = mkkN "pehmuste" ;
lin pehmustus_N = mkkN "pehmustus" ;
lin pehmyt_N = mkkN "pehmyt" ;
lin pehtori_N = mkkN "pehtori" ;
lin pehva_N = mkkN "pehva" ;
--? lin peijaiset_NK = {s = d38 "peijaiset" ;
lin peijakas_A = mkkA "peijakas" ;
lin peijakkaanmoinen_N = mkkN "peijakkaanmoinen" ;
lin peijakkaasti_Adv = mkkAdv "peijakkaasti" ;
lin peijooni_N = mkkN "peijooni" ;
lin peikko_N = mkkN "peikko" ;
lin peilailla_V = mkkV "peilailla" ;
lin peilata_1_V = mkkV "peilata" ;
lin peilata_2_V = mkkV "peilata" ;
lin peilaus_N = mkkN "peilaus" ;
lin peilautua_V = mkkV "peilautua" ;
lin peili_N = mkkN "peili" ;
lin peipata_V = mkkV "peipata" ;
lin peippaus_N = mkkN "peippaus" ;
lin peippi_N = mkkN "peippi" ;
lin peippo_N = mkkN "peippo" ;
lin peipponen_N = mkkN "peipponen" ;
lin peitata_V = mkkV "peitata" ;
lin peite_N = mkkN "peite" ;
lin peitellysti_Adv = mkkAdv "peitellysti" ;
lin peitella'_V = mkkV "peitellä" ;
lin peitetysti_Adv = mkkAdv "peitetysti" ;
lin peitossa_Adv = mkkAdv "peitossa" ;
lin peitosta_Adv = mkkAdv "peitosta" ;
lin peitota_V = mkkV "peitota" ;
lin peitsari_N = mkkN "peitsari" ;
lin peitsata_V = mkkV "peitsata" ;
lin peitsaus_N = mkkN "peitsaus" ;
lin peitsi_1_N = mkkN "peitsi" ;
lin peitsi_2_N = mkkN "peitsi" ;
lin peitta_N = mkkN "peitta" ;
lin peittaus_N = mkkN "peittaus" ;
lin peitteinen_N = mkkN "peitteinen" ;
lin peittelema'to'n_N = mkkN "peittelemätön" ;
lin peittely_N = mkkN "peittely" ;
lin peitto_N = mkkN "peitto" ;
lin peittoon_Adv = mkkAdv "peittoon" ;
lin peittya'_V = mkkV "peittyä" ;
lin peitta'a'_V = mkkV "peittää" ;
lin pejoratiivinen_N = mkkN "pejoratiivinen" ;
lin pekari_N = mkkN "pekari" ;
lin pekka_N = mkkN "pekka" ;
lin pekoni_N = mkkN "pekoni" ;
lin pelaaja_N = mkkN "pelaaja" ;
lin pelailla_V = mkkV "pelailla" ;
lin pelakuu_N = mkkN "pelakuu" ;
lin pelargoni_N = mkkN "pelargoni" ;
lin pelastaa_V = mkkV "pelastaa" ;
lin pelastaja_N = mkkN "pelastaja" ;
lin pelastautua_V = mkkV "pelastautua" ;
lin pelastua_V = mkkV "pelastua" ;
lin pelastus_N = mkkN "pelastus" ;
lin pelastusarmeijalainen_N = mkkN "pelastusarmeijalainen" ;
lin pelata_V = mkkV "pelata" ;
lin pelehtia'_V = mkkV "pelehtiä" ;
lin peleriini_N = mkkN "peleriini" ;
lin peli_N = mkkN "peli" ;
lin peliaika_N = mkkN "peliaika" ;
lin pelikaani_N = mkkN "pelikaani" ;
lin pelimanni_N = mkkN "pelimanni" ;
lin pelja'ta'_V = mkkV "peljätä" ;
lin pelkiste_N = mkkN "pelkiste" ;
lin pelkistin_N = mkkN "pelkistin" ;
lin pelkistys_N = mkkN "pelkistys" ;
lin pelkistya'_V = mkkV "pelkistyä" ;
lin pelkista'a'_V = mkkV "pelkistää" ;
lin pelkka_N = mkkN "pelkka" ;
lin pelkka'_N = mkkN "pelkkä" ;
lin pelko_N = mkkN "pelko" ;
lin pelkuri_N = mkkN "pelkuri" ;
lin pelkurimaisesti_Adv = mkkAdv "pelkurimaisesti" ;
lin pelkuruus_N = mkkN "pelkuruus" ;
lin pelka'sta'a'n_Adv = mkkAdv "pelkästään" ;
lin pelka'a'ja'_N = mkkN "pelkääjä" ;
lin pelka'a'ma'to'n_N = mkkN "pelkäämätön" ;
lin pelka'a'va'inen_N = mkkN "pelkääväinen" ;
lin pellava_N = mkkN "pellava" ;
lin pellavainen_N = mkkN "pellavainen" ;
lin pelle_N = mkkN "pelle" ;
lin pelleilla'_V = mkkV "pelleillä" ;
lin pelleily_N = mkkN "pelleily" ;
lin pelleriini_N = mkkN "pelleriini" ;
lin pelletoida_V = mkkV "pelletoida" ;
lin pelletointi_N = mkkN "pelletointi" ;
lin pelletti_N = mkkN "pelletti" ;
lin pellillinen_N = mkkN "pellillinen" ;
lin pellitta'a'_V = mkkV "pellittää" ;
lin pelmahdella_V = mkkV "pelmahdella" ;
lin pelmahtaa_V = mkkV "pelmahtaa" ;
lin pelmeni_N = mkkN "pelmeni" ;
lin pelmuta_V = mkkV "pelmuta" ;
lin pelmuttaa_V = mkkV "pelmuttaa" ;
lin pelokas_A = mkkA "pelokas" ;
lin pelokkaasti_Adv = mkkAdv "pelokkaasti" ;
lin pelokkuus_N = mkkN "pelokkuus" ;
lin pelote_N = mkkN "pelote" ;
lin pelotella_V = mkkV "pelotella" ;
lin pelotin_N = mkkN "pelotin" ;
lin peloton_N = mkkN "peloton" ;
lin pelottaa_V = mkkV "pelottaa" ;
lin pelottava_A = mkkA "pelottava" ;
lin pelottavasti_Adv = mkkAdv "pelottavasti" ;
lin pelottavuus_N = mkkN "pelottavuus" ;
lin pelottelu_N = mkkN "pelottelu" ;
lin pelottomasti_Adv = mkkAdv "pelottomasti" ;
lin pelottomuus_N = mkkN "pelottomuus" ;
lin pelotus_N = mkkN "pelotus" ;
lin pelti_N = mkkN "pelti" ;
lin peltinen_N = mkkN "peltinen" ;
lin pelto_N = mkkN "pelto" ;
lin peltoinen_N = mkkN "peltoinen" ;
lin peluri_N = mkkN "peluri" ;
lin peluu_N = mkkN "peluu" ;
lin peluuttaa_V = mkkV "peluuttaa" ;
lin pela'stys_N = mkkN "pelästys" ;
lin pela'stytta'a'_V = mkkV "pelästyttää" ;
lin pela'stya'_V = mkkV "pelästyä" ;
lin pela'tin_N = mkkN "pelätin" ;
lin pela'tti_N = mkkN "pelätti" ;
lin pela'ta'_V = mkkV "pelätä" ;
lin pemppu_N = mkkN "pemppu" ;
lin penaali_N = mkkN "penaali" ;
lin pendeli_N = mkkN "pendeli" ;
lin pendyyli_N = mkkN "pendyyli" ;
lin penetraatio_N = mkkN "penetraatio" ;
lin penetranssi_N = mkkN "penetranssi" ;
lin penetroida_V = mkkV "penetroida" ;
lin penger_N = mkkN "penger" ;
lin pengerma'_N = mkkN "pengermä" ;
lin pengerma'inen_N = mkkN "pengermäinen" ;
lin pengerrys_N = mkkN "pengerrys" ;
lin pengerta'a'_V = mkkV "pengertää" ;
lin pengonta_N = mkkN "pengonta" ;
lin peni_N = mkkN "peni" ;
lin penikka_N = mkkN "penikka" ;
lin penikkamaisesti_Adv = mkkAdv "penikkamaisesti" ;
lin penikkamaisuus_N = mkkN "penikkamaisuus" ;
lin penikoida_V = mkkV "penikoida" ;
lin penikointi_N = mkkN "penikointi" ;
lin penis_N = mkkN "penis" ;
lin penisilliini_N = mkkN "penisilliini" ;
lin penkere_N = mkkN "penkere" ;
lin penkereinen_N = mkkN "penkereinen" ;
--? lin penkinpainajaiset_NK = {s = d38 "penkinpainajaiset" ;
lin penkka_N = mkkN "penkka" ;
--? lin penkkarit_NK = {s = d06 "penkkarit" ;
lin penkki_N = mkkN "penkki" ;
lin penkoa_V = mkkV "penkoa" ;
lin pennalismi_N = mkkN "pennalismi" ;
lin penne_N = mkkN "penne" ;
lin penni_N = mkkN "penni" ;
lin penninen_N = mkkN "penninen" ;
lin pennito'n_N = mkkN "pennitön" ;
lin pennonen_N = mkkN "pennonen" ;
lin penny_N = mkkN "penny" ;
lin pensa_N = mkkN "pensa" ;
lin pensaikko_N = mkkN "pensaikko" ;
lin pensaikkoinen_N = mkkN "pensaikkoinen" ;
lin pensainen_N = mkkN "pensainen" ;
lin pensaisto_N = mkkN "pensaisto" ;
lin pensas_N = mkkN "pensas" ;
lin pensasmaisesti_Adv = mkkAdv "pensasmaisesti" ;
lin pensasmaisuus_N = mkkN "pensasmaisuus" ;
lin pensastaa_V = mkkV "pensastaa" ;
lin pensasto_N = mkkN "pensasto" ;
lin pensastua_V = mkkV "pensastua" ;
lin penseys_N = mkkN "penseys" ;
lin pensea'_A = mkkA "penseä" ;
lin pensea'sti_Adv = mkkAdv "penseästi" ;
lin pensionaatti_N = mkkN "pensionaatti" ;
lin penska_N = mkkN "penska" ;
lin penslata_V = mkkV "penslata" ;
lin penslaus_N = mkkN "penslaus" ;
lin pensoa_V = mkkV "pensoa" ;
lin pensoittua_V = mkkV "pensoittua" ;
lin pensseli_N = mkkN "pensseli" ;
lin pensselo'ida'_V = mkkV "pensselöidä" ;
lin pentaani_N = mkkN "pentaani" ;
lin pentaedri_N = mkkN "pentaedri" ;
lin pentagoni_N = mkkN "pentagoni" ;
lin pentagrammi_N = mkkN "pentagrammi" ;
lin pentametri_N = mkkN "pentametri" ;
lin pentele_A = mkkA "pentele" ;
lin penteleesti_Adv = mkkAdv "penteleesti" ;
lin pentteri_N = mkkN "pentteri" ;
lin pentu_N = mkkN "pentu" ;
lin pentue_N = mkkN "pentue" ;
lin pentumaisesti_Adv = mkkAdv "pentumaisesti" ;
lin pentumaisuus_N = mkkN "pentumaisuus" ;
lin pena'ta'_V = mkkV "penätä" ;
lin peoni_1_N = mkkN "peoni" ;
lin peoni_2_N = mkkN "peoni" ;
lin pepino_N = mkkN "pepino" ;
lin peppu_N = mkkN "peppu" ;
lin pepsiini_N = mkkN "pepsiini" ;
lin peptidi_N = mkkN "peptidi" ;
lin per_Adv = mkkAdv "per" ;
lin perata_V = mkkV "perata" ;
lin perehdytta'ja'_N = mkkN "perehdyttäjä" ;
lin perehdytta'a'_V = mkkV "perehdyttää" ;
lin perehtymys_N = mkkN "perehtymys" ;
lin perehtyneisyys_N = mkkN "perehtyneisyys" ;
lin perehtya'_V = mkkV "perehtyä" ;
lin peremma'_Adv = mkkAdv "peremmä" ;
lin peremma'ksi_Adv = mkkAdv "peremmäksi" ;
lin peremma'lle_Adv = mkkAdv "peremmälle" ;
lin peremma'lla'_Adv = mkkAdv "peremmällä" ;
lin peremma'lta'_Adv = mkkAdv "peremmältä" ;
lin peremma's_Adv = mkkAdv "peremmäs" ;
lin perempi_N = mkkN "perempi" ;
lin perempa'na'_Adv = mkkAdv "perempänä" ;
lin perempa'a'_Adv = mkkAdv "perempää" ;
lin perenna_N = mkkN "perenna" ;
lin perennoida_V = mkkV "perennoida" ;
lin perestroika_N = mkkN "perestroika" ;
lin perfekti_N = mkkN "perfekti" ;
lin perfektionismi_N = mkkN "perfektionismi" ;
lin perfektionisti_N = mkkN "perfektionisti" ;
lin perfektionistinen_N = mkkN "perfektionistinen" ;
lin perforaatio_N = mkkN "perforaatio" ;
lin performanssi_N = mkkN "performanssi" ;
lin perforoida_V = mkkV "perforoida" ;
lin perforointi_N = mkkN "perforointi" ;
lin pergamentti_N = mkkN "pergamentti" ;
lin pergamiini_N = mkkN "pergamiini" ;
lin pergola_N = mkkN "pergola" ;
lin perhananmoinen_N = mkkN "perhananmoinen" ;
lin perhanasti_Adv = mkkAdv "perhanasti" ;
lin perhe_N = mkkN "perhe" ;
lin perheellinen_N = mkkN "perheellinen" ;
lin perheeto'n_N = mkkN "perheetön" ;
lin perheinen_N = mkkN "perheinen" ;
lin perheitta'in_Adv = mkkAdv "perheittäin" ;
lin perho_N = mkkN "perho" ;
lin perhonen_N = mkkN "perhonen" ;
lin perhostaa_V = mkkV "perhostaa" ;
lin perhostella_V = mkkV "perhostella" ;
lin periaatteeton_N = mkkN "periaatteeton" ;
lin periaatteettomuus_N = mkkN "periaatteettomuus" ;
lin periaatteinen_N = mkkN "periaatteinen" ;
lin peridotiitti_N = mkkN "peridotiitti" ;
lin perifeerinen_N = mkkN "perifeerinen" ;
lin perifeerisyys_N = mkkN "perifeerisyys" ;
lin periferia_N = mkkN "periferia" ;
lin perija'_N = mkkN "perijä" ;
lin perija'ta'r_N = mkkN "perijätär" ;
lin periksi_Adv = mkkAdv "periksi" ;
lin perille_Adv = mkkAdv "perille" ;
lin perillinen_N = mkkN "perillinen" ;
lin perilla'_Adv = mkkAdv "perillä" ;
lin perimmilta'a'n_Adv = mkkAdv "perimmiltään" ;
lin perimma'inen_N = mkkN "perimmäinen" ;
lin perimma'lta'_Adv = mkkAdv "perimmältä" ;
lin perimma'lta'a'n_Adv = mkkAdv "perimmältään" ;
lin perimys_N = mkkN "perimys" ;
lin perima'_N = mkkN "perimä" ;
lin perin_1_Adv = mkkAdv "perin" ;
lin perin_2_Adv = mkkAdv "perin" ;
lin perinataaliaika_N = mkkN "perinataaliaika" ;
lin perinataalinen_N = mkkN "perinataalinen" ;
lin perinatologia_N = mkkN "perinatologia" ;
lin perin_juurin_Adv = mkkAdv "periC" ;
lin perinne_N = mkkN "perinne" ;
lin perinna'inen_A = mkkA "perinnäinen" ;
lin perinna'isesti_Adv = mkkAdv "perinnäisesti" ;
lin perinno'llinen_N = mkkN "perinnöllinen" ;
lin perinno'llisyys_N = mkkN "perinnöllisyys" ;
lin perinno'nja'tta'ja'_N = mkkN "perinnönjättäjä" ;
lin perinno'to'n_N = mkkN "perinnötön" ;
lin perinpohjaisesti_Adv = mkkAdv "perinpohjaisesti" ;
lin perin_pohjin_Adv = mkkAdv "periC" ;
lin perinteellinen_A = mkkA "perinteellinen" ;
lin perinteellisesti_Adv = mkkAdv "perinteellisesti" ;
lin perinteellisyys_N = mkkN "perinteellisyys" ;
lin perinteika's_N = mkkN "perinteikäs" ;
lin perinteisesti_Adv = mkkAdv "perinteisesti" ;
lin perinteisyys_N = mkkN "perinteisyys" ;
lin perinta'_N = mkkN "perintä" ;
lin perinto'_N = mkkN "perintö" ;
lin periodeittain_Adv = mkkAdv "periodeittain" ;
lin periodi_N = mkkN "periodi" ;
lin periodinen_A = mkkA "periodinen" ;
lin periodisesti_Adv = mkkAdv "periodisesti" ;
lin periodisuus_N = mkkN "periodisuus" ;
lin peripohjalaisuus_N = mkkN "peripohjalaisuus" ;
lin periskooppi_N = mkkN "periskooppi" ;
lin peristaltiikka_N = mkkN "peristaltiikka" ;
lin peristalttinen_N = mkkN "peristalttinen" ;
lin periytta'a'_V = mkkV "periyttää" ;
lin periytya'_V = mkkV "periytyä" ;
lin peria'_V = mkkV "periä" ;
lin perjantai_N = mkkN "perjantai" ;
lin perjantainen_N = mkkN "perjantainen" ;
lin perjantaisin_Adv = mkkAdv "perjantaisin" ;
lin perkaaja_N = mkkN "perkaaja" ;
lin perkaus_N = mkkN "perkaus" ;
--? lin perkeet_NK = {s = d48 "perkeet" ;
lin perkele_A = mkkA "perkele" ;
lin perkeleellinen_N = mkkN "perkeleellinen" ;
lin perkeleenmoinen_N = mkkN "perkeleenmoinen" ;
lin perkeleesti_Adv = mkkAdv "perkeleesti" ;
lin perkio'_N = mkkN "perkiö" ;
lin perkule_N = mkkN "perkule" ;
lin perkussio_N = mkkN "perkussio" ;
lin permanentata_V = mkkV "permanentata" ;
lin permanentti_N = mkkN "permanentti" ;
lin permeaabeli_N = mkkN "permeaabeli" ;
lin permeabiliteetti_N = mkkN "permeabiliteetti" ;
lin permila'inen_N = mkkN "permiläinen" ;
lin permis_N = mkkN "permis" ;
lin perna_N = mkkN "perna" ;
lin pernisioosi_N = mkkN "pernisioosi" ;
lin pernisioosinen_N = mkkN "pernisioosinen" ;
lin pernisio'o'si_N = mkkN "pernisiöösi" ;
lin peroksidaasi_N = mkkN "peroksidaasi" ;
lin persaukinen_N = mkkN "persaukinen" ;
--? lin persaukset_NK = {s = d39 "persaukset" ;
lin perse_N = mkkN "perse" ;
lin perseennuolija_N = mkkN "perseennuolija" ;
lin persia_N = mkkN "persia" ;
lin persikka_N = mkkN "persikka" ;
lin persilja_N = mkkN "persilja" ;
lin persiljavoi_N = mkkN "persiljavoi" ;
lin persimoni_N = mkkN "persimoni" ;
--? lin perskat_NK = {s = d09 "perskat" ;
lin persla'pi_N = mkkN "persläpi" ;
lin persnetto_N = mkkN "persnetto" ;
lin perso_N = mkkN "perso" ;
lin personifikaatio_N = mkkN "personifikaatio" ;
lin personifioida_V = mkkV "personifioida" ;
lin personifiointi_N = mkkN "personifiointi" ;
lin personoida_V = mkkV "personoida" ;
lin personointi_N = mkkN "personointi" ;
lin personoitua_V = mkkV "personoitua" ;
lin personoituma_N = mkkN "personoituma" ;
lin persoona_N = mkkN "persoona" ;
lin persoonainen_N = mkkN "persoonainen" ;
lin persoonallinen_A = mkkA "persoonallinen" ;
lin persoonallisesti_Adv = mkkAdv "persoonallisesti" ;
lin persoonallisuus_N = mkkN "persoonallisuus" ;
lin persoonaton_N = mkkN "persoonaton" ;
lin persoonattomasti_Adv = mkkAdv "persoonattomasti" ;
lin persoonattomuus_N = mkkN "persoonattomuus" ;
lin perspektiivi_N = mkkN "perspektiivi" ;
lin perspektiivinen_N = mkkN "perspektiivinen" ;
--? lin persukset_NK = {s = d39 "persukset" ;
--? lin persuukset_NK = {s = d39 "persuukset" ;
lin peru_N = mkkN "peru" ;
lin perua_V = mkkV "perua" ;
lin peruke_N = mkkN "peruke" ;
lin perukka_N = mkkN "perukka" ;
lin peruna_N = mkkN "peruna" ;
lin perunankuori_N = mkkN "perunankuori" ;
lin perus_N = mkkN "perus" ;
lin perusta_N = mkkN "perusta" ;
lin perustaa_V = mkkV "perustaa" ;
lin perustainen_N = mkkN "perustainen" ;
lin perustaja_N = mkkN "perustaja" ;
lin perustanta_N = mkkN "perustanta" ;
lin peruste_N = mkkN "peruste" ;
lin perusteellinen_A = mkkA "perusteellinen" ;
lin perusteellisesti_Adv = mkkAdv "perusteellisesti" ;
lin perusteellisuus_N = mkkN "perusteellisuus" ;
lin perusteeton_N = mkkN "perusteeton" ;
lin perusteettomasti_Adv = mkkAdv "perusteettomasti" ;
lin perusteettomuus_N = mkkN "perusteettomuus" ;
lin perusteilla_Adv = mkkAdv "perusteilla" ;
lin perustella_V = mkkV "perustella" ;
lin perustelu_N = mkkN "perustelu" ;
lin perustua_V = mkkV "perustua" ;
lin perustus_N = mkkN "perustus" ;
lin peruuntua_V = mkkV "peruuntua" ;
lin peruuttaa_V = mkkV "peruuttaa" ;
lin peruuttamaton_N = mkkN "peruuttamaton" ;
lin peruuttamattomasti_Adv = mkkAdv "peruuttamattomasti" ;
lin peruuttamattomuus_N = mkkN "peruuttamattomuus" ;
lin peruutua_V = mkkV "peruutua" ;
lin peruutus_N = mkkN "peruutus" ;
lin perversiteetti_N = mkkN "perversiteetti" ;
lin perverssi_N = mkkN "perverssi" ;
lin perverssiys_N = mkkN "perverssiys" ;
lin pervo_N = mkkN "pervo" ;
lin pera'_N = mkkN "perä" ;
lin pera'inen_N = mkkN "peräinen" ;
lin pera'isin_Adv = mkkAdv "peräisin" ;
lin pera'kanaa_Adv = mkkAdv "peräkanaa" ;
lin pera'kaneetti_N = mkkN "peräkaneetti" ;
lin pera'kka'in_Adv = mkkAdv "peräkkäin" ;
lin pera'kka'inen_A = mkkA "peräkkäinen" ;
lin pera'kka'isesti_Adv = mkkAdv "peräkkäisesti" ;
lin pera'kka'isyys_N = mkkN "peräkkäisyys" ;
lin pera'lle_Adv = mkkAdv "perälle" ;
lin pera'llinen_N = mkkN "perällinen" ;
lin pera'lla'_Adv = mkkAdv "perällä" ;
lin pera'lta'_Adv = mkkAdv "perältä" ;
lin pera'miehellinen_N = mkkN "perämiehellinen" ;
lin pera'mieheto'n_N = mkkN "perämiehetön" ;
lin pera'prutku_N = mkkN "peräprutku" ;
lin pera'pukama_N = mkkN "peräpukama" ;
lin pera'sin_N = mkkN "peräsin" ;
lin pera'ssa'_Adv = mkkAdv "perässä" ;
lin pera'sta'_Adv = mkkAdv "perästä" ;
lin pera'ti_Adv = mkkAdv "peräti" ;
lin pera'tta'in_Adv = mkkAdv "perättäin" ;
lin pera'tta'inen_A = mkkA "perättäinen" ;
lin pera'tta'isesti_Adv = mkkAdv "perättäisesti" ;
lin pera'tta'isyys_N = mkkN "perättäisyys" ;
lin pera'tto'myys_N = mkkN "perättömyys" ;
lin pera'tto'ma'sti_Adv = mkkAdv "perättömästi" ;
lin pera'tuuppari_N = mkkN "perätuuppari" ;
lin pera'tyksin_Adv = mkkAdv "perätyksin" ;
lin pera'tysten_Adv = mkkAdv "perätysten" ;
lin pera'ta'_V = mkkV "perätä" ;
lin pera'to'n_N = mkkN "perätön" ;
lin pera'ytta'a'_V = mkkV "peräyttää" ;
lin pera'ytya'_V = mkkV "peräytyä" ;
lin pera'a'n_Adv = mkkAdv "perään" ;
lin pera'a'nantamaton_N = mkkN "peräänantamaton" ;
lin pera'a'nantamattomasti_Adv = mkkAdv "peräänantamattomasti" ;
lin pera'a'nantamattomuus_N = mkkN "peräänantamattomuus" ;
lin pera'a'nantava_N = mkkN "peräänantava" ;
lin pera'a'ntya'_V = mkkV "perääntyä" ;
lin pesaista_V = mkkV "pesaista" ;
lin peseta_N = mkkN "peseta" ;
lin pesetta'a'_V = mkkV "pesettää" ;
lin peseytya'_V = mkkV "peseytyä" ;
lin pesiintya'_V = mkkV "pesiintyä" ;
lin pesija'_1_N = mkkN "pesijä" ;
lin pesija'_2_N = mkkN "pesijä" ;
lin pesima'aika_N = mkkN "pesimäaika" ;
lin pesin_N = mkkN "pesin" ;
lin pesinta'_N = mkkN "pesintä" ;
lin pesis_N = mkkN "pesis" ;
lin pesiytya'_V = mkkV "pesiytyä" ;
lin pesia'_V = mkkV "pesiä" ;
lin peski_N = mkkN "peski" ;
lin peso_N = mkkN "peso" ;
lin pessaari_N = mkkN "pessaari" ;
lin pessimismi_N = mkkN "pessimismi" ;
lin pessimisti_N = mkkN "pessimisti" ;
lin pessimistinen_A = mkkA "pessimistinen" ;
lin pessimistisesti_Adv = mkkAdv "pessimistisesti" ;
lin pessimistisyys_N = mkkN "pessimistisyys" ;
lin pestata_V = mkkV "pestata" ;
lin pestaus_N = mkkN "pestaus" ;
lin pestautua_V = mkkV "pestautua" ;
lin pesti_N = mkkN "pesti" ;
lin pestisidi_N = mkkN "pestisidi" ;
lin pesto_N = mkkN "pesto" ;
lin pestuu_N = mkkN "pestuu" ;
lin pesta'_V = mkkV "pestä" ;
lin pesu_N = mkkN "pesu" ;
lin pesue_N = mkkN "pesue" ;
lin pesula_N = mkkN "pesula" ;
lin pesuri_N = mkkN "pesuri" ;
lin pesye_N = mkkN "pesye" ;
lin pesa'_N = mkkN "pesä" ;
lin pesa'juuri_N = mkkN "pesäjuuri" ;
lin pesa'ke_N = mkkN "pesäke" ;
lin pesa'llinen_N = mkkN "pesällinen" ;
lin pesa'pallisti_N = mkkN "pesäpallisti" ;
lin petankisti_N = mkkN "petankisti" ;
lin petankki_N = mkkN "petankki" ;
lin petanque_N = mkkN "petanque" ;
lin petata_V = mkkV "petata" ;
lin petaus_N = mkkN "petaus" ;
lin peti_N = mkkN "peti" ;
lin petiitti_N = mkkN "petiitti" ;
lin petkel_N = mkkN "petkel" ;
lin petkele_N = mkkN "petkele" ;
lin petkuttaa_V = mkkV "petkuttaa" ;
lin petkuttaja_N = mkkN "petkuttaja" ;
lin petkutus_N = mkkN "petkutus" ;
lin peto_N = mkkN "peto" ;
lin petoksellinen_A = mkkA "petoksellinen" ;
lin petoksellisesti_Adv = mkkAdv "petoksellisesti" ;
lin petollinen_A = mkkA "petollinen" ;
lin petollisesti_Adv = mkkAdv "petollisesti" ;
lin petollisuus_N = mkkN "petollisuus" ;
lin petomaisesti_Adv = mkkAdv "petomaisesti" ;
lin petomaisuus_N = mkkN "petomaisuus" ;
lin petos_N = mkkN "petos" ;
lin petrata_V = mkkV "petrata" ;
lin petraus_N = mkkN "petraus" ;
lin petroli_N = mkkN "petroli" ;
lin petrologi_N = mkkN "petrologi" ;
lin petrologia_N = mkkN "petrologia" ;
lin petrologinen_N = mkkN "petrologinen" ;
lin petsata_V = mkkV "petsata" ;
lin petsaus_N = mkkN "petsaus" ;
lin petsi_N = mkkN "petsi" ;
lin petting_N = mkkN "petting" ;
lin pettu_N = mkkN "pettu" ;
lin petturi_N = mkkN "petturi" ;
lin petturuus_N = mkkN "petturuus" ;
lin pettymys_N = mkkN "pettymys" ;
lin pettya'_V = mkkV "pettyä" ;
lin petta'ja'_N = mkkN "pettäjä" ;
lin petta'ma'tto'ma'sti_Adv = mkkAdv "pettämättömästi" ;
lin petta'ma'to'n_N = mkkN "pettämätön" ;
lin petta'a'_V = mkkV "pettää" ;
lin petunia_N = mkkN "petunia" ;
lin peta'jikko'_N = mkkN "petäjikkö" ;
lin peta'jisto'_N = mkkN "petäjistö" ;
lin peta'ja'_N = mkkN "petäjä" ;
lin peta'ja'inen_N = mkkN "petäjäinen" ;
lin peta'ja'nkuori_N = mkkN "petäjänkuori" ;
lin peuhata_V = mkkV "peuhata" ;
lin peukalo_N = mkkN "peukalo" ;
lin peukaloida_V = mkkV "peukaloida" ;
lin peukaloinen_N = mkkN "peukaloinen" ;
lin peukalokyytila'inen_N = mkkN "peukalokyytiläinen" ;
lin peukku_N = mkkN "peukku" ;
lin peura_N = mkkN "peura" ;
lin peuranvasa_N = mkkN "peuranvasa" ;
lin pH_Adv = mkkAdv "pH" ;
lin phui_Adv = mkkAdv "phui" ;
lin phyi_Adv = mkkAdv "phyi" ;
lin piakkoin_Adv = mkkAdv "piakkoin" ;
lin pian_Adv = mkkAdv "pian" ;
lin pianissimo_N = mkkN "pianissimo" ;
lin pianisti_N = mkkN "pianisti" ;
lin pianistinen_N = mkkN "pianistinen" ;
lin piano_N = mkkN "piano" ;
lin piccolo_N = mkkN "piccolo" ;
lin pick_up_N = mkkN "pick-up" ;
lin picnic_N = mkkN "picnic" ;
lin pidella'_V = mkkV "pidellä" ;
lin pidennys_N = mkkN "pidennys" ;
lin pidentyma'_N = mkkN "pidentymä" ;
lin pidentya'_V = mkkV "pidentyä" ;
lin pidenta'a'_V = mkkV "pidentää" ;
lin pideta'_V = mkkV "pidetä" ;
lin pidike_N = mkkN "pidike" ;
lin pidin_N = mkkN "pidin" ;
--? lin pidot_NK = {s = d01A "pidot" ;
lin pida'ke_N = mkkN "pidäke" ;
lin pida'kkeetto'ma'sti_Adv = mkkAdv "pidäkkeettömästi" ;
lin pida'kkeeto'n_N = mkkN "pidäkkeetön" ;
lin pida'tella'_V = mkkV "pidätellä" ;
lin pida'tetty_N = mkkN "pidätetty" ;
lin pida'tin_N = mkkN "pidätin" ;
lin pida'ttynyt_N = mkkN "pidättynyt" ;
lin pida'ttyvyys_N = mkkN "pidättyvyys" ;
lin pida'ttyva'_A = mkkA "pidättyvä" ;
lin pida'ttyva'inen_A = mkkA "pidättyväinen" ;
lin pida'ttyva'isesti_Adv = mkkAdv "pidättyväisesti" ;
lin pida'ttyva'sti_Adv = mkkAdv "pidättyvästi" ;
lin pida'ttya'_V = mkkV "pidättyä" ;
lin pida'tta'ytya'_V = mkkV "pidättäytyä" ;
lin pida'tta'a'_V = mkkV "pidättää" ;
lin pida'tys_N = mkkN "pidätys" ;
lin pida'tytta'a'_V = mkkV "pidätyttää" ;
lin piehtaroida_V = mkkV "piehtaroida" ;
lin piehtarointi_N = mkkN "piehtarointi" ;
lin piekana_N = mkkN "piekana" ;
lin pieksu_N = mkkN "pieksu" ;
lin pieksa'nta'_N = mkkN "pieksäntä" ;
lin pieksa'a'_V = mkkV "pieksää" ;
lin pieles_N = mkkN "pieles" ;
lin pielestys_N = mkkN "pielestys" ;
lin pielesta'a'_V = mkkV "pielestää" ;
lin pieli_N = mkkN "pieli" ;
lin pielikki_N = mkkN "pielikki" ;
lin pielus_N = mkkN "pielus" ;
lin piena_N = mkkN "piena" ;
lin pieneksya'_V = mkkV "pieneksyä" ;
lin pienennys_N = mkkN "pienennys" ;
lin pienenno's_N = mkkN "pienennös" ;
lin pienentya'_V = mkkV "pienentyä" ;
lin pienenta'a'_V = mkkV "pienentää" ;
lin pieneta'_V = mkkV "pienetä" ;
lin pieni_N = mkkN "pieni" ;
lin pienia'_V = mkkV "pieniä" ;
lin piennar_N = mkkN "piennar" ;
lin pienoinen_N = mkkN "pienoinen" ;
lin pienoiskoko_N = mkkN "pienoiskoko" ;
lin pienoismaalaus_N = mkkN "pienoismaalaus" ;
lin pienoisralli_N = mkkN "pienoisralli" ;
lin pienokainen_N = mkkN "pienokainen" ;
lin pientare_N = mkkN "pientare" ;
lin pienuus_N = mkkN "pienuus" ;
lin pieraista_V = mkkV "pieraista" ;
lin piereksia'_V = mkkV "piereksiä" ;
lin piereskella'_V = mkkV "piereskellä" ;
lin pieretta'a'_V = mkkV "pierettää" ;
lin pierra'_V = mkkV "pierrä" ;
lin pieru_N = mkkN "pieru" ;
lin piesta'_V = mkkV "piestä" ;
lin pieteetti_N = mkkN "pieteetti" ;
lin pieteettinen_A = mkkA "pieteettinen" ;
lin pieteettisesti_Adv = mkkAdv "pieteettisesti" ;
lin pieti_N = mkkN "pieti" ;
lin pietismi_N = mkkN "pietismi" ;
lin pietisti_N = mkkN "pietisti" ;
lin pietistinen_N = mkkN "pietistinen" ;
lin pieta'_V = mkkV "pietä" ;
lin piffata_V = mkkV "piffata" ;
lin pigmentoitua_V = mkkV "pigmentoitua" ;
lin pigmentti_N = mkkN "pigmentti" ;
lin pigmenttinen_N = mkkN "pigmenttinen" ;
lin piha_N = mkkN "piha" ;
lin pihahdella_V = mkkV "pihahdella" ;
lin pihahdus_N = mkkN "pihahdus" ;
lin pihahtaa_V = mkkV "pihahtaa" ;
lin pihatto_N = mkkN "pihatto" ;
lin pihaus_N = mkkN "pihaus" ;
lin pihdata_V = mkkV "pihdata" ;
lin pihdit_N = mkkN "pihdit" ;
lin pihi_N = mkkN "pihi" ;
lin pihina'_N = mkkN "pihinä" ;
lin pihistella'_V = mkkV "pihistellä" ;
lin pihista'_V = mkkV "pihistä" ;
lin pihista'a'_V = mkkV "pihistää" ;
lin pihia'_V = mkkV "pihiä" ;
lin pihka_N = mkkN "pihka" ;
lin pihkaantua_V = mkkV "pihkaantua" ;
lin pihkainen_N = mkkN "pihkainen" ;
lin pihkoittua_V = mkkV "pihkoittua" ;
lin pihlaja_N = mkkN "pihlaja" ;
lin pihta_N = mkkN "pihta" ;
lin pihtaaja_N = mkkN "pihtaaja" ;
lin pihtari_N = mkkN "pihtari" ;
lin pihtima'inen_N = mkkN "pihtimäinen" ;
lin pihtipolvisuus_N = mkkN "pihtipolvisuus" ;
lin pihvi_N = mkkN "pihvi" ;
lin pii_1_N = mkkN "pii" ;
lin pii_2_N = mkkN "pii" ;
lin pii_3_N = mkkN "pii" ;
lin piidioksidi_N = mkkN "piidioksidi" ;
lin piihin_Adv = mkkAdv "piihin" ;
lin piika_N = mkkN "piika" ;
lin piikata_V = mkkV "piikata" ;
lin piikikkyys_N = mkkN "piikikkyys" ;
lin piikikka'a'sti_Adv = mkkAdv "piikikkäästi" ;
lin piikika's_A = mkkA "piikikäs" ;
lin piikitella'_V = mkkV "piikitellä" ;
lin piikittely_N = mkkN "piikittely" ;
lin piikitta'a'_V = mkkV "piikittää" ;
lin piikitys_N = mkkN "piikitys" ;
lin piikkari_N = mkkN "piikkari" ;
lin piikkaus_N = mkkN "piikkaus" ;
lin piikki_N = mkkN "piikki" ;
lin piikkinen_N = mkkN "piikkinen" ;
lin piikko_N = mkkN "piikko" ;
lin piikoa_V = mkkV "piikoa" ;
lin piileksija'_N = mkkN "piileksijä" ;
lin piileksia'_V = mkkV "piileksiä" ;
lin piileskelija'_N = mkkN "piileskelijä" ;
lin piileskella'_V = mkkV "piileskellä" ;
lin piilevyys_N = mkkN "piilevyys" ;
lin piilla'_V = mkkV "piillä" ;
lin piilo_N = mkkN "piilo" ;
lin piilokas_N = mkkN "piilokas" ;
lin piilokiveksisyys_N = mkkN "piilokiveksisyys" ;
lin piilosilla_Adv = mkkAdv "piilosilla" ;
lin piilotella_V = mkkV "piilotella" ;
lin piilottaa_V = mkkV "piilottaa" ;
lin piilottautua_V = mkkV "piilottautua" ;
lin piiloutua_V = mkkV "piiloutua" ;
lin piilovaikuttaminen_N = mkkN "piilovaikuttaminen" ;
lin piilu_N = mkkN "piilu" ;
lin piiluta_V = mkkV "piiluta" ;
lin piimitta'a'_V = mkkV "piimittää" ;
lin piimia'_V = mkkV "piimiä" ;
lin piima'_N = mkkN "piimä" ;
lin piima'inen_N = mkkN "piimäinen" ;
lin piina_N = mkkN "piina" ;
lin piinallinen_A = mkkA "piinallinen" ;
lin piinallisesti_Adv = mkkAdv "piinallisesti" ;
lin piinallisuus_N = mkkN "piinallisuus" ;
lin piinata_V = mkkV "piinata" ;
lin piintymys_N = mkkN "piintymys" ;
lin piintyma'_N = mkkN "piintymä" ;
lin piintya'_V = mkkV "piintyä" ;
lin piip_Adv = mkkAdv "piip" ;
lin piipahdus_N = mkkN "piipahdus" ;
lin piipahtaa_V = mkkV "piipahtaa" ;
lin piipata_1_V = mkkV "piipata" ;
lin piipata_2_V = mkkV "piipata" ;
lin piiperrys_N = mkkN "piiperrys" ;
lin piiperta'a'_V = mkkV "piipertää" ;
lin piipitta'a'_V = mkkV "piipittää" ;
lin piipitys_N = mkkN "piipitys" ;
lin piipottaa_V = mkkV "piipottaa" ;
lin piippaus_1_N = mkkN "piippaus" ;
lin piippaus_2_N = mkkN "piippaus" ;
lin piippo_N = mkkN "piippo" ;
lin piippu_N = mkkN "piippu" ;
lin piipullinen_N = mkkN "piipullinen" ;
lin piiputtaa_V = mkkV "piiputtaa" ;
lin piiranen_N = mkkN "piiranen" ;
lin piiras_N = mkkN "piiras" ;
lin piireitta'in_Adv = mkkAdv "piireittäin" ;
lin piiri_N = mkkN "piiri" ;
lin piiritta'ja'_N = mkkN "piirittäjä" ;
lin piiritta'a'_V = mkkV "piirittää" ;
lin piiritys_N = mkkN "piiritys" ;
lin piironki_N = mkkN "piironki" ;
lin piirre_N = mkkN "piirre" ;
lin piirrella'_V = mkkV "piirrellä" ;
lin piirrin_N = mkkN "piirrin" ;
lin piirros_N = mkkN "piirros" ;
lin piirra'tta'a'_V = mkkV "piirrättää" ;
lin piirteinen_N = mkkN "piirteinen" ;
lin piirtely_N = mkkN "piirtely" ;
lin piirto_N = mkkN "piirto" ;
lin piirturi_N = mkkN "piirturi" ;
lin piirtya'_V = mkkV "piirtyä" ;
lin piirta'ja'_N = mkkN "piirtäjä" ;
lin piirta'a'_V = mkkV "piirtää" ;
lin piiru_1_N = mkkN "piiru" ;
lin piiru_2_N = mkkN "piiru" ;
lin piirustaa_V = mkkV "piirustaa" ;
lin piirustella_V = mkkV "piirustella" ;
lin piirustuksellinen_N = mkkN "piirustuksellinen" ;
lin piirustus_N = mkkN "piirustus" ;
lin piisami_N = mkkN "piisami" ;
lin piisata_V = mkkV "piisata" ;
lin piisi_1_N = mkkN "piisi" ;
lin piisi_2_N = mkkN "piisi" ;
lin piiska_N = mkkN "piiska" ;
lin piiskata_V = mkkV "piiskata" ;
lin piiskaus_N = mkkN "piiskaus" ;
lin piisku_N = mkkN "piisku" ;
lin piiskuri_N = mkkN "piiskuri" ;
lin piiskuttaa_V = mkkV "piiskuttaa" ;
lin piisoni_N = mkkN "piisoni" ;
lin piispa_N = mkkN "piispa" ;
lin piispatar_N = mkkN "piispatar" ;
lin piispuus_N = mkkN "piispuus" ;
lin piissa'_Adv = mkkAdv "piissä" ;
lin piitata_V = mkkV "piitata" ;
lin piittaamaton_N = mkkN "piittaamaton" ;
lin piittaamattomasti_Adv = mkkAdv "piittaamattomasti" ;
lin piittaamattomuus_N = mkkN "piittaamattomuus" ;
lin pikaa_Adv = mkkAdv "pikaa" ;
lin pikainen_A = mkkA "pikainen" ;
lin pikaisesti_Adv = mkkAdv "pikaisesti" ;
lin pikaistua_V = mkkV "pikaistua" ;
lin pikaistuksissa_Adv = mkkAdv "pikaistuksissa" ;
lin pikaistuksissaan_Adv = mkkAdv "pikaistuksissaan" ;
lin pikantisti_Adv = mkkAdv "pikantisti" ;
lin pikantti_N = mkkN "pikantti" ;
lin pikanttius_N = mkkN "pikanttius" ;
lin pikapuoliin_Adv = mkkAdv "pikapuoliin" ;
lin pikapuolin_Adv = mkkAdv "pikapuolin" ;
lin pikari_N = mkkN "pikari" ;
lin pikarillinen_N = mkkN "pikarillinen" ;
lin pikee_N = mkkN "pikee" ;
lin pikeentya'_V = mkkV "pikeentyä" ;
lin pikemmin_Adv = mkkAdv "pikemmin" ;
lin pikeys_N = mkkN "pikeys" ;
lin pikeytya'_V = mkkV "pikeytyä" ;
lin piki_N = mkkN "piki" ;
lin pikiintya'_V = mkkV "pikiintyä" ;
lin pikimmilta'_Adv = mkkAdv "pikimmiltä" ;
lin pikimmilta'a'n_Adv = mkkAdv "pikimmiltään" ;
lin pikimmin_Adv = mkkAdv "pikimmin" ;
lin pikimmiten_Adv = mkkAdv "pikimmiten" ;
lin pikimma'lta'_Adv = mkkAdv "pikimmältä" ;
lin pikimma'lta'a'n_Adv = mkkAdv "pikimmältään" ;
lin pikinen_N = mkkN "pikinen" ;
lin pikkainen_N = mkkN "pikkainen" ;
lin pikkanen_N = mkkN "pikkanen" ;
lin pikkarainen_N = mkkN "pikkarainen" ;
lin pikkelssi_N = mkkN "pikkelssi" ;
lin pikkiriikkinen_N = mkkN "pikkiriikkinen" ;
lin pikkolo_N = mkkN "pikkolo" ;
lin pikku_Adv = mkkAdv "pikku" ;
lin pikkuinen_N = mkkN "pikkuinen" ;
lin pikkuisen_Adv = mkkAdv "pikkuisen" ;
lin pikkulilli_N = mkkN "pikkulilli" ;
lin pikkumaisesti_Adv = mkkAdv "pikkumaisesti" ;
lin pikkumaisuus_N = mkkN "pikkumaisuus" ;
lin pikkupurtava_N = mkkN "pikkupurtava" ;
lin pikkuriikkinen_N = mkkN "pikkuriikkinen" ;
lin pikkurilli_N = mkkN "pikkurilli" ;
lin pikkuruikkuinen_N = mkkN "pikkuruikkuinen" ;
lin pikkuruinen_N = mkkN "pikkuruinen" ;
lin pikkutakkisillaan_Adv = mkkAdv "pikkutakkisillaan" ;
lin pikkuvanhasti_Adv = mkkAdv "pikkuvanhasti" ;
lin piknikki_N = mkkN "piknikki" ;
lin pila_N = mkkN "pila" ;
lin pilaaja_N = mkkN "pilaaja" ;
lin pilaantua_V = mkkV "pilaantua" ;
lin pilahvi_N = mkkN "pilahvi" ;
lin pilailla_V = mkkV "pilailla" ;
lin pilailu_N = mkkN "pilailu" ;
lin pilalla_Adv = mkkAdv "pilalla" ;
lin pilalle_Adv = mkkAdv "pilalle" ;
lin pilallinen_N = mkkN "pilallinen" ;
lin pilari_N = mkkN "pilari" ;
lin pilaristo_N = mkkN "pilaristo" ;
lin pilasteri_N = mkkN "pilasteri" ;
lin pilata_V = mkkV "pilata" ;
lin piletti_N = mkkN "piletti" ;
lin pilipali_N = mkkN "pilipali" ;
lin pilkahdella_V = mkkV "pilkahdella" ;
lin pilkahdus_N = mkkN "pilkahdus" ;
lin pilkahtaa_V = mkkV "pilkahtaa" ;
lin pilkallaan_Adv = mkkAdv "pilkallaan" ;
lin pilkallinen_A = mkkA "pilkallinen" ;
lin pilkallisesti_Adv = mkkAdv "pilkallisesti" ;
lin pilkallisuus_N = mkkN "pilkallisuus" ;
lin pilkata_V = mkkV "pilkata" ;
lin pilke_1_N = mkkN "pilke" ;
lin pilke_2_N = mkkN "pilke" ;
lin pilkinta'_N = mkkN "pilkintä" ;
lin pilkistella'_V = mkkV "pilkistellä" ;
lin pilkistys_N = mkkN "pilkistys" ;
lin pilkista'a'_V = mkkV "pilkistää" ;
lin pilkka_1_N = mkkN "pilkka" ;
lin pilkka_2_N = mkkN "pilkka" ;
lin pilkkaaja_N = mkkN "pilkkaaja" ;
lin pilkki_N = mkkN "pilkki" ;
lin pilkkija'_N = mkkN "pilkkijä" ;
lin pilkkia'_V = mkkV "pilkkiä" ;
lin pilkkoa_V = mkkV "pilkkoa" ;
lin pilkkoisen_Adv = mkkAdv "pilkkoisen" ;
lin pilkkoja_N = mkkN "pilkkoja" ;
lin pilkkoutua_V = mkkV "pilkkoutua" ;
lin pilkku_N = mkkN "pilkku" ;
lin pilkkuinen_N = mkkN "pilkkuinen" ;
lin pilkkumi_N = mkkN "pilkkumi" ;
lin pilkoittaa_V = mkkV "pilkoittaa" ;
lin pilkoitus_N = mkkN "pilkoitus" ;
lin pilkottaa_V = mkkV "pilkottaa" ;
lin pilkukas_N = mkkN "pilkukas" ;
lin pilkullinen_N = mkkN "pilkullinen" ;
lin pilkuttaa_V = mkkV "pilkuttaa" ;
lin pilkutus_N = mkkN "pilkutus" ;
lin pillahtaa_V = mkkV "pillahtaa" ;
lin pillastua_V = mkkV "pillastua" ;
lin pilleri_N = mkkN "pilleri" ;
lin pillerinpyo'ritta'ja'_N = mkkN "pillerinpyörittäjä" ;
lin pilleristi_N = mkkN "pilleristi" ;
lin pilli_N = mkkN "pilli" ;
lin pillike_N = mkkN "pillike" ;
lin pillipiipari_N = mkkN "pillipiipari" ;
lin pillisto'_N = mkkN "pillistö" ;
lin pillitta'ja'_N = mkkN "pillittäjä" ;
lin pillitta'a'_V = mkkV "pillittää" ;
lin pillu_N = mkkN "pillu" ;
lin piloilla_Adv = mkkAdv "piloilla" ;
lin piloillaan_Adv = mkkAdv "piloillaan" ;
lin piloille_Adv = mkkAdv "piloille" ;
lin pilotti_N = mkkN "pilotti" ;
lin pilsneri_N = mkkN "pilsneri" ;
lin pilssi_N = mkkN "pilssi" ;
lin piltti_N = mkkN "piltti" ;
lin pilttuinen_N = mkkN "pilttuinen" ;
lin pilttuu_N = mkkN "pilttuu" ;
lin pilveilla'_V = mkkV "pilveillä" ;
lin pilveta'_V = mkkV "pilvetä" ;
lin pilveto'n_N = mkkN "pilvetön" ;
lin pilvi_N = mkkN "pilvi" ;
lin pilvinen_N = mkkN "pilvinen" ;
lin pilvistya'_V = mkkV "pilvistyä" ;
lin pilvisyys_N = mkkN "pilvisyys" ;
lin pimahtaa_V = mkkV "pimahtaa" ;
lin pimennys_N = mkkN "pimennys" ;
lin pimento_N = mkkN "pimento" ;
lin pimentya'_V = mkkV "pimentyä" ;
lin pimenta'a'_V = mkkV "pimentää" ;
lin pimeta'_V = mkkV "pimetä" ;
lin pimeys_N = mkkN "pimeys" ;
lin pimea'_A = mkkA "pimeä" ;
lin pimea'sti_Adv = mkkAdv "pimeästi" ;
lin pimitta'a'_V = mkkV "pimittää" ;
lin pimitys_N = mkkN "pimitys" ;
lin pimio'_N = mkkN "pimiö" ;
lin pimppi_N = mkkN "pimppi" ;
lin pimputtaa_V = mkkV "pimputtaa" ;
lin pimputus_N = mkkN "pimputus" ;
lin pimu_N = mkkN "pimu" ;
lin pinaatti_N = mkkN "pinaatti" ;
lin pineeni_N = mkkN "pineeni" ;
lin pingis_N = mkkN "pingis" ;
lin pingotin_N = mkkN "pingotin" ;
lin pingottaa_V = mkkV "pingottaa" ;
lin pingottaja_N = mkkN "pingottaja" ;
lin pingottua_V = mkkV "pingottua" ;
lin pingotus_N = mkkN "pingotus" ;
lin pingpong_N = mkkN "pingpong" ;
lin pingviini_N = mkkN "pingviini" ;
lin pinja_N = mkkN "pinja" ;
lin pinkaista_V = mkkV "pinkaista" ;
lin pinkka_N = mkkN "pinkka" ;
lin pinkki_N = mkkN "pinkki" ;
lin pinko_N = mkkN "pinko" ;
lin pinkoa_V = mkkV "pinkoa" ;
lin pinkoittain_Adv = mkkAdv "pinkoittain" ;
lin pinna_N = mkkN "pinna" ;
lin pinnaaja_N = mkkN "pinnaaja" ;
lin pinnakkain_Adv = mkkAdv "pinnakkain" ;
lin pinnakkainen_N = mkkN "pinnakkainen" ;
lin pinnallinen_A = mkkA "pinnallinen" ;
lin pinnallisesti_Adv = mkkAdv "pinnallisesti" ;
lin pinnallistaa_V = mkkV "pinnallistaa" ;
lin pinnallistua_V = mkkV "pinnallistua" ;
lin pinnallisuus_N = mkkN "pinnallisuus" ;
lin pinnari_N = mkkN "pinnari" ;
lin pinnata_V = mkkV "pinnata" ;
lin pinnaus_N = mkkN "pinnaus" ;
lin pinne_N = mkkN "pinne" ;
lin pinnemmaksi_Adv = mkkAdv "pinnemmaksi" ;
lin pinnemmalla_Adv = mkkAdv "pinnemmalla" ;
lin pinnemmalle_Adv = mkkAdv "pinnemmalle" ;
lin pinnemmalta_Adv = mkkAdv "pinnemmalta" ;
lin pinnemmassa_Adv = mkkAdv "pinnemmassa" ;
lin pinnemmasta_Adv = mkkAdv "pinnemmasta" ;
lin pinnempaa_Adv = mkkAdv "pinnempaa" ;
lin pinnempaan_Adv = mkkAdv "pinnempaan" ;
lin pinnempana_Adv = mkkAdv "pinnempana" ;
lin pinni_N = mkkN "pinni" ;
lin pinnistella'_V = mkkV "pinnistellä" ;
lin pinnistys_N = mkkN "pinnistys" ;
lin pinnistya'_V = mkkV "pinnistyä" ;
lin pinnista'a'_V = mkkV "pinnistää" ;
lin pinnia'_V = mkkV "pinniä" ;
lin pinnoite_N = mkkN "pinnoite" ;
lin pinnoittaa_V = mkkV "pinnoittaa" ;
lin pinnoitteinen_N = mkkN "pinnoitteinen" ;
lin pinnoitus_N = mkkN "pinnoitus" ;
lin pino_N = mkkN "pino" ;
lin pinota_V = mkkV "pinota" ;
lin pinseri_N = mkkN "pinseri" ;
lin pinsetit_N = mkkN "pinsetit" ;
lin pinssi_N = mkkN "pinssi" ;
lin pinta_N = mkkN "pinta" ;
lin pintahaava_N = mkkN "pintahaava" ;
lin pintainen_N = mkkN "pintainen" ;
lin pintaisuus_N = mkkN "pintaisuus" ;
lin pintapuolisesti_Adv = mkkAdv "pintapuolisesti" ;
lin pintapuolisuus_N = mkkN "pintapuolisuus" ;
lin pintautua_V = mkkV "pintautua" ;
lin pintava'reily_N = mkkN "pintaväreily" ;
lin pinteeseen_Adv = mkkAdv "pinteeseen" ;
lin pinteessa'_Adv = mkkAdv "pinteessä" ;
lin pinteesta'_Adv = mkkAdv "pinteestä" ;
lin pinttyma'_N = mkkN "pinttymä" ;
lin pinttya'_V = mkkV "pinttyä" ;
lin pinyin_N = mkkN "pinyin" ;
lin pioneeri_N = mkkN "pioneeri" ;
lin pioni_1_N = mkkN "pioni" ;
lin pioni_2_N = mkkN "pioni" ;
lin pipana_N = mkkN "pipana" ;
lin pipari_N = mkkN "pipari" ;
lin piparjuuri_N = mkkN "piparjuuri" ;
lin piperrys_N = mkkN "piperrys" ;
lin piperta'a'_V = mkkV "pipertää" ;
lin pipetoida_V = mkkV "pipetoida" ;
lin pipetti_N = mkkN "pipetti" ;
lin pipi_N = mkkN "pipi" ;
lin piplia_N = mkkN "piplia" ;
lin pipo_N = mkkN "pipo" ;
--? lin pippalot_NK = {s = d02 "pippalot" ;
lin pippeli_N = mkkN "pippeli" ;
lin pippuri_N = mkkN "pippuri" ;
lin pippurinen_N = mkkN "pippurinen" ;
lin pippuroida_V = mkkV "pippuroida" ;
lin piraatti_N = mkkN "piraatti" ;
lin pirahdella_V = mkkV "pirahdella" ;
lin pirahdus_N = mkkN "pirahdus" ;
lin pirahtaa_V = mkkV "pirahtaa" ;
lin piraija_N = mkkN "piraija" ;
lin piratismi_N = mkkN "piratismi" ;
lin piraus_N = mkkN "piraus" ;
lin pirauttaa_V = mkkV "pirauttaa" ;
lin pirina'_N = mkkN "pirinä" ;
lin piripinnassa_Adv = mkkAdv "piripinnassa" ;
lin piripintaan_Adv = mkkAdv "piripintaan" ;
lin piripintanaan_Adv = mkkAdv "piripintanaan" ;
lin piriste_N = mkkN "piriste" ;
lin piristys_N = mkkN "piristys" ;
lin piristya'_V = mkkV "piristyä" ;
lin pirista'_V = mkkV "piristä" ;
lin pirista'ytya'_V = mkkV "piristäytyä" ;
lin pirista'a'_V = mkkV "piristää" ;
lin pirkkalainen_N = mkkN "pirkkalainen" ;
lin pirpana_N = mkkN "pirpana" ;
lin pirskahdella_V = mkkV "pirskahdella" ;
lin pirskahdus_N = mkkN "pirskahdus" ;
lin pirskahtaa_V = mkkV "pirskahtaa" ;
lin pirskatti_N = mkkN "pirskatti" ;
lin pirskauttaa_V = mkkV "pirskauttaa" ;
lin pirske_N = mkkN "pirske" ;
lin pirskottaa_V = mkkV "pirskottaa" ;
lin pirskotus_N = mkkN "pirskotus" ;
lin pirskua_V = mkkV "pirskua" ;
lin pirssi_N = mkkN "pirssi" ;
lin pirsta_N = mkkN "pirsta" ;
lin pirstale_N = mkkN "pirstale" ;
lin pirstaloitua_V = mkkV "pirstaloitua" ;
lin pirstoa_V = mkkV "pirstoa" ;
lin pirstoutua_V = mkkV "pirstoutua" ;
lin pirta_N = mkkN "pirta" ;
lin pirtelo'_N = mkkN "pirtelö" ;
lin pirteys_N = mkkN "pirteys" ;
lin pirtea'_N = mkkN "pirteä" ;
lin pirtti_N = mkkN "pirtti" ;
lin pirtu_N = mkkN "pirtu" ;
lin piru_A = mkkA "piru" ;
lin piruetti_N = mkkN "piruetti" ;
lin piruilla_V = mkkV "piruilla" ;
lin piruilu_N = mkkN "piruilu" ;
lin pirullinen_A = mkkA "pirullinen" ;
lin pirullisesti_Adv = mkkAdv "pirullisesti" ;
lin pirullisuus_N = mkkN "pirullisuus" ;
lin pirunmoinen_N = mkkN "pirunmoinen" ;
lin pirusti_Adv = mkkAdv "pirusti" ;
lin piruuksissaan_Adv = mkkAdv "piruuksissaan" ;
lin piruuntua_V = mkkV "piruuntua" ;
lin piruuttaan_Adv = mkkAdv "piruuttaan" ;
lin pisama_N = mkkN "pisama" ;
lin pisamainen_N = mkkN "pisamainen" ;
lin pisara_N = mkkN "pisara" ;
lin pisaroida_V = mkkV "pisaroida" ;
lin pisarointi_N = mkkN "pisarointi" ;
lin pisi_N = mkkN "pisi" ;
lin pisia'_V = mkkV "pisiä" ;
lin piski_N = mkkN "piski" ;
lin piskuinen_N = mkkN "piskuinen" ;
lin pisoaari_N = mkkN "pisoaari" ;
lin pissa_N = mkkN "pissa" ;
lin pissata_V = mkkV "pissata" ;
lin pissattaa_V = mkkV "pissattaa" ;
lin pissi_N = mkkN "pissi" ;
lin pissitta'a'_V = mkkV "pissittää" ;
lin pissia'_V = mkkV "pissiä" ;
lin pistaasi_N = mkkN "pistaasi" ;
lin piste_N = mkkN "piste" ;
lin pisteellinen_N = mkkN "pisteellinen" ;
lin pisteitta'a'_V = mkkV "pisteittää" ;
lin pisteitys_N = mkkN "pisteitys" ;
lin pistelia'isyys_N = mkkN "pisteliäisyys" ;
lin pistelia's_A = mkkA "pisteliäs" ;
lin pistelia'a'sti_Adv = mkkAdv "pisteliäästi" ;
lin pistella'_V = mkkV "pistellä" ;
lin pistely_N = mkkN "pistely" ;
lin pistema'inen_N = mkkN "pistemäinen" ;
lin pisteytta'a'_V = mkkV "pisteyttää" ;
lin pistin_N = mkkN "pistin" ;
lin pistia'inen_N = mkkN "pistiäinen" ;
lin pisto_N = mkkN "pisto" ;
lin pistohaava_N = mkkN "pistohaava" ;
lin pistokas_N = mkkN "pistokas" ;
lin pistoke_N = mkkN "pistoke" ;
lin pistooli_N = mkkN "pistooli" ;
lin pistos_N = mkkN "pistos" ;
lin pistouvata_V = mkkV "pistouvata" ;
lin pista'ma'to'n_N = mkkN "pistämätön" ;
lin pista'va'_N = mkkN "pistävä" ;
lin pista'ytya'_V = mkkV "pistäytyä" ;
lin pista'a'_V = mkkV "pistää" ;
lin pisu_N = mkkN "pisu" ;
lin pitaali_N = mkkN "pitaali" ;
lin pitaalinen_N = mkkN "pitaalinen" ;
lin pitali_N = mkkN "pitali" ;
lin pitalinen_N = mkkN "pitalinen" ;
lin pitelema'to'n_N = mkkN "pitelemätön" ;
lin pitely_N = mkkN "pitely" ;
lin pitennys_N = mkkN "pitennys" ;
lin pitentyma'_N = mkkN "pitentymä" ;
lin pitentya'_V = mkkV "pitentyä" ;
lin pitenta'a'_V = mkkV "pitentää" ;
--? lin pitkikset_NK = {s = d39 "pitkikset" ;
lin pitkin_Adv = mkkAdv "pitkin" ;
lin pitkistya'_V = mkkV "pitkistyä" ;
lin pitkittya'_V = mkkV "pitkittyä" ;
lin pitkitta'in_Adv = mkkAdv "pitkittäin" ;
lin pitkitta'inen_N = mkkN "pitkittäinen" ;
lin pitkitta'israita_N = mkkN "pitkittäisraita" ;
lin pitkitta'a'_V = mkkV "pitkittää" ;
lin pitkitys_N = mkkN "pitkitys" ;
lin pitko_N = mkkN "pitko" ;
lin pitkulainen_N = mkkN "pitkulainen" ;
lin pitka'_A = mkkA "pitkä" ;
lin pitka'inen_N = mkkN "pitkäinen" ;
lin pitka'ja'nnitteisesti_Adv = mkkAdv "pitkäjännitteisesti" ;
lin pitka'ja'nteisesti_Adv = mkkAdv "pitkäjänteisesti" ;
lin pitka'kseen_Adv = mkkAdv "pitkäkseen" ;
lin pitka'lettinen_N = mkkN "pitkälettinen" ;
lin pitka'lle_Adv = mkkAdv "pitkälle" ;
lin pitka'lleen_Adv = mkkAdv "pitkälleen" ;
lin pitka'llinen_N = mkkN "pitkällinen" ;
lin pitka'lla'_Adv = mkkAdv "pitkällä" ;
lin pitka'lla'a'n_Adv = mkkAdv "pitkällään" ;
lin pitka'lti_Adv = mkkAdv "pitkälti" ;
lin pitka'mielisesti_Adv = mkkAdv "pitkämielisesti" ;
lin pitka'na'a'n_Adv = mkkAdv "pitkänään" ;
lin pitka'piima'isesti_Adv = mkkAdv "pitkäpiimäisesti" ;
lin pitka'ripainen_N = mkkN "pitkäripainen" ;
lin pitka'sti_Adv = mkkAdv "pitkästi" ;
lin pitka'stytta'va'_A = mkkA "pitkästyttävä" ;
lin pitka'stytta'va'sti_Adv = mkkAdv "pitkästyttävästi" ;
lin pitka'stytta'a'_V = mkkV "pitkästyttää" ;
lin pitka'stya'_V = mkkV "pitkästyä" ;
lin pitka'tukkaisuus_N = mkkN "pitkätukkaisuus" ;
lin pitka'veteinen_A = mkkA "pitkäveteinen" ;
lin pitka'veteisesti_Adv = mkkAdv "pitkäveteisesti" ;
lin pitka'veteisyys_N = mkkN "pitkäveteisyys" ;
lin pitka'a'n_Adv = mkkAdv "pitkään" ;
lin pito_N = mkkN "pito" ;
lin pitoinen_N = mkkN "pitoinen" ;
lin pitoisuus_N = mkkN "pitoisuus" ;
lin pitsa_N = mkkN "pitsa" ;
lin pitseria_N = mkkN "pitseria" ;
lin pitsi_N = mkkN "pitsi" ;
lin pittoreski_N = mkkN "pittoreski" ;
lin pituinen_N = mkkN "pituinen" ;
lin pituus_N = mkkN "pituus" ;
lin pita'en_Adv = mkkAdv "pitäen" ;
lin pita'ja'_N = mkkN "pitäjä" ;
lin pita'ja'la'inen_N = mkkN "pitäjäläinen" ;
lin pita'mys_N = mkkN "pitämys" ;
lin pita'ma'_N = mkkN "pitämä" ;
lin pita'ma'to'n_N = mkkN "pitämätön" ;
lin pita'vyys_N = mkkN "pitävyys" ;
lin pita'va'_N = mkkN "pitävä" ;
lin pita'ytya'_V = mkkV "pitäytyä" ;
lin pita'a'_V = mkkV "pitää" ;
lin piuha_N = mkkN "piuha" ;
lin piukasti_Adv = mkkAdv "piukasti" ;
lin piukea_N = mkkN "piukea" ;
lin piukka_N = mkkN "piukka" ;
lin piukkuus_N = mkkN "piukkuus" ;
lin piupaut_Adv = mkkAdv "piupaut" ;
lin pivo_N = mkkN "pivo" ;
lin pizza_N = mkkN "pizza" ;
lin pizzeria_N = mkkN "pizzeria" ;
lin pizzicato_N = mkkN "pizzicato" ;
lin plaanata_V = mkkV "plaanata" ;
lin plaani_N = mkkN "plaani" ;
lin plagiaatti_N = mkkN "plagiaatti" ;
lin plagioida_V = mkkV "plagioida" ;
lin plagioija_N = mkkN "plagioija" ;
lin plagiointi_N = mkkN "plagiointi" ;
lin plakaatti_N = mkkN "plakaatti" ;
lin plaketti_N = mkkN "plaketti" ;
lin plakkari_N = mkkN "plakkari" ;
lin plakki_N = mkkN "plakki" ;
lin planeetta_N = mkkN "planeetta" ;
lin planetaarinen_N = mkkN "planetaarinen" ;
lin planetaario_N = mkkN "planetaario" ;
lin planetoidi_N = mkkN "planetoidi" ;
lin plankata_V = mkkV "plankata" ;
lin plankkaus_N = mkkN "plankkaus" ;
lin plankki_N = mkkN "plankki" ;
lin plankton_N = mkkN "plankton" ;
lin planssi_N = mkkN "planssi" ;
lin plantaasi_N = mkkN "plantaasi" ;
lin planttu_N = mkkN "planttu" ;
lin plarata_V = mkkV "plarata" ;
lin plari_N = mkkN "plari" ;
lin plasebo_N = mkkN "plasebo" ;
lin plaseerata_V = mkkV "plaseerata" ;
lin plaseeraus_N = mkkN "plaseeraus" ;
lin plasma_N = mkkN "plasma" ;
lin plasmidi_N = mkkN "plasmidi" ;
lin plasmosyytti_N = mkkN "plasmosyytti" ;
lin plastidi_N = mkkN "plastidi" ;
lin plastiikka_N = mkkN "plastiikka" ;
lin plastinen_A = mkkA "plastinen" ;
lin plastisesti_Adv = mkkAdv "plastisesti" ;
lin plastisuus_N = mkkN "plastisuus" ;
lin plataani_N = mkkN "plataani" ;
lin platina_N = mkkN "platina" ;
lin platinoida_V = mkkV "platinoida" ;
lin platinointi_N = mkkN "platinointi" ;
lin platonilainen_N = mkkN "platonilainen" ;
lin platonilaisuus_N = mkkN "platonilaisuus" ;
lin platoninen_N = mkkN "platoninen" ;
lin platonismi_N = mkkN "platonismi" ;
lin platy_N = mkkN "platy" ;
lin playback_N = mkkN "playback" ;
lin playboy_N = mkkN "playboy" ;
lin playoff_N = mkkN "playoff" ;
lin plebeiji_N = mkkN "plebeiji" ;
lin pleenumi_N = mkkN "pleenumi" ;
lin plektra_N = mkkN "plektra" ;
lin pleonasmi_N = mkkN "pleonasmi" ;
lin pleonastinen_N = mkkN "pleonastinen" ;
lin pliisu_N = mkkN "pliisu" ;
lin plikka_N = mkkN "plikka" ;
lin pliseerata_V = mkkV "pliseerata" ;
lin pliseeraus_N = mkkN "pliseeraus" ;
lin plombi_N = mkkN "plombi" ;
lin plombittaa_V = mkkV "plombittaa" ;
lin plootu_N = mkkN "plootu" ;
lin plumpsahdus_N = mkkN "plumpsahdus" ;
lin plumpsahtaa_V = mkkV "plumpsahtaa" ;
lin pluraali_N = mkkN "pluraali" ;
lin pluralismi_N = mkkN "pluralismi" ;
lin pluralisti_N = mkkN "pluralisti" ;
lin pluralistinen_N = mkkN "pluralistinen" ;
lin plus_Adv = mkkAdv "plus" ;
lin pluskvamperfekti_N = mkkN "pluskvamperfekti" ;
lin plussa_N = mkkN "plussa" ;
lin plussata_V = mkkV "plussata" ;
lin plutonium_N = mkkN "plutonium" ;
lin plutoona_N = mkkN "plutoona" ;
lin plyymi_N = mkkN "plyymi" ;
lin plyysi_N = mkkN "plyysi" ;
lin pla'kki_N = mkkN "pläkki" ;
lin pla'si_N = mkkN "pläsi" ;
lin plo'rina'_N = mkkN "plörinä" ;
lin plo'ro'_N = mkkN "plörö" ;
lin pneumaattinen_A = mkkA "pneumaattinen" ;
lin pneumaattisesti_Adv = mkkAdv "pneumaattisesti" ;
lin pneumatiikka_N = mkkN "pneumatiikka" ;
lin pneumonia_N = mkkN "pneumonia" ;
lin podsoli_N = mkkN "podsoli" ;
lin poeettinen_N = mkkN "poeettinen" ;
lin poetiikka_N = mkkN "poetiikka" ;
lin pogromi_N = mkkN "pogromi" ;
lin pohatta_N = mkkN "pohatta" ;
lin pohdin_N = mkkN "pohdin" ;
lin pohdinta_N = mkkN "pohdinta" ;
lin pohdiskella_V = mkkV "pohdiskella" ;
lin pohdiskelu_N = mkkN "pohdiskelu" ;
lin pohja_N = mkkN "pohja" ;
lin pohja_aika_N = mkkN "pohja-aika" ;
lin pohjainen_A = mkkA "pohjainen" ;
lin pohjaisesti_Adv = mkkAdv "pohjaisesti" ;
lin pohjaisuus_N = mkkN "pohjaisuus" ;
lin pohjalaisittain_Adv = mkkAdv "pohjalaisittain" ;
lin pohjallinen_N = mkkN "pohjallinen" ;
lin pohjamaalata_V = mkkV "pohjamaalata" ;
lin pohjata_V = mkkV "pohjata" ;
lin pohjaton_N = mkkN "pohjaton" ;
lin pohjattomasti_Adv = mkkAdv "pohjattomasti" ;
lin pohjaus_N = mkkN "pohjaus" ;
lin pohjauttaa_V = mkkV "pohjauttaa" ;
lin pohjautua_V = mkkV "pohjautua" ;
lin pohje_N = mkkN "pohje" ;
lin pohjemmaksi_Adv = mkkAdv "pohjemmaksi" ;
lin pohjemmalla_Adv = mkkAdv "pohjemmalla" ;
lin pohjemmalle_Adv = mkkAdv "pohjemmalle" ;
lin pohjemmalta_Adv = mkkAdv "pohjemmalta" ;
lin pohjempaa_Adv = mkkAdv "pohjempaa" ;
lin pohjempana_Adv = mkkAdv "pohjempana" ;
lin pohjimmainen_N = mkkN "pohjimmainen" ;
lin pohjimmaksi_Adv = mkkAdv "pohjimmaksi" ;
lin pohjimmalla_Adv = mkkAdv "pohjimmalla" ;
lin pohjimmalle_Adv = mkkAdv "pohjimmalle" ;
lin pohjimmalta_Adv = mkkAdv "pohjimmalta" ;
lin pohjimmaltaan_Adv = mkkAdv "pohjimmaltaan" ;
lin pohjimmiltaan_Adv = mkkAdv "pohjimmiltaan" ;
lin pohjimpaa_Adv = mkkAdv "pohjimpaa" ;
lin pohjimpana_Adv = mkkAdv "pohjimpana" ;
lin pohjittaa_V = mkkV "pohjittaa" ;
lin pohjoinen_N = mkkN "pohjoinen" ;
lin pohjoisemmaksi_Adv = mkkAdv "pohjoisemmaksi" ;
lin pohjoisemmas_Adv = mkkAdv "pohjoisemmas" ;
lin pohjoisempaa_Adv = mkkAdv "pohjoisempaa" ;
lin pohjoisempana_Adv = mkkAdv "pohjoisempana" ;
lin pohjoisraja_N = mkkN "pohjoisraja" ;
lin pohjoisvaltalainen_N = mkkN "pohjoisvaltalainen" ;
lin pohjoisviitta_N = mkkN "pohjoisviitta" ;
lin pohjola_N = mkkN "pohjola" ;
lin pohjukka_N = mkkN "pohjukka" ;
lin pohjus_N = mkkN "pohjus" ;
lin pohjustaa_V = mkkV "pohjustaa" ;
lin pohjuste_N = mkkN "pohjuste" ;
lin pohjustus_N = mkkN "pohjustus" ;
lin pohkeinen_N = mkkN "pohkeinen" ;
lin pohtia_V = mkkV "pohtia" ;
lin poies_Adv = mkkAdv "poies" ;
lin poi_inta_N = mkkN "poi'inta" ;
lin poi_ittaa_V = mkkV "poi'ittaa" ;
lin poi_itus_N = mkkN "poi'itus" ;
lin poiju_N = mkkN "poiju" ;
lin poijuttaa_V = mkkV "poijuttaa" ;
lin poijutus_N = mkkN "poijutus" ;
lin poika_N = mkkN "poika" ;
lin poikamaisesti_Adv = mkkAdv "poikamaisesti" ;
lin poikamaisuus_N = mkkN "poikamaisuus" ;
lin poikanen_N = mkkN "poikanen" ;
lin poiketa_V = mkkV "poiketa" ;
lin poikia_V = mkkV "poikia" ;
lin poikittain_Adv = mkkAdv "poikittain" ;
lin poikittainen_N = mkkN "poikittainen" ;
lin poikittaisraita_N = mkkN "poikittaisraita" ;
lin poikkaista_V = mkkV "poikkaista" ;
lin poikkeama_N = mkkN "poikkeama" ;
lin poikkeava_A = mkkA "poikkeava" ;
lin poikkeavasti_Adv = mkkAdv "poikkeavasti" ;
lin poikkeavuus_N = mkkN "poikkeavuus" ;
lin poikkeuksellinen_A = mkkA "poikkeuksellinen" ;
lin poikkeuksellisesti_Adv = mkkAdv "poikkeuksellisesti" ;
lin poikkeuksellisuus_N = mkkN "poikkeuksellisuus" ;
lin poikkeuma_N = mkkN "poikkeuma" ;
lin poikkeus_N = mkkN "poikkeus" ;
lin poikkeuttaa_V = mkkV "poikkeuttaa" ;
lin poikki_Adv = mkkAdv "poikki" ;
lin poikkipuolin_Adv = mkkAdv "poikkipuolin" ;
lin poikkitelainen_N = mkkN "poikkitelainen" ;
lin poikkiteloin_Adv = mkkAdv "poikkiteloin" ;
lin poikue_N = mkkN "poikue" ;
lin poikuus_N = mkkN "poikuus" ;
lin poikuusaika_N = mkkN "poikuusaika" ;
lin poimia_V = mkkV "poimia" ;
lin poimielma_N = mkkN "poimielma" ;
lin poimija_N = mkkN "poimija" ;
lin poiminta_N = mkkN "poiminta" ;
lin poiminto_N = mkkN "poiminto" ;
lin poimiskella_V = mkkV "poimiskella" ;
lin poimu_N = mkkN "poimu" ;
lin poimuilla_V = mkkV "poimuilla" ;
lin poimuinen_N = mkkN "poimuinen" ;
lin poimukas_N = mkkN "poimukas" ;
lin poimullinen_N = mkkN "poimullinen" ;
lin poimuri_N = mkkN "poimuri" ;
lin poimuttaa_V = mkkV "poimuttaa" ;
lin poimuttua_V = mkkV "poimuttua" ;
lin poimutus_N = mkkN "poimutus" ;
lin poimuuntua_V = mkkV "poimuuntua" ;
lin pointillismi_N = mkkN "pointillismi" ;
lin pointillisti_N = mkkN "pointillisti" ;
lin pointillistinen_N = mkkN "pointillistinen" ;
lin pointsi_N = mkkN "pointsi" ;
lin pointteri_N = mkkN "pointteri" ;
lin pointti_N = mkkN "pointti" ;
lin pois_Adv = mkkAdv "pois" ;
lin poisnukkunut_N = mkkN "poisnukkunut" ;
lin poisoppiminen_N = mkkN "poisoppiminen" ;
lin poispilattu_N = mkkN "poispilattu" ;
lin poissa_Adv = mkkAdv "poissa" ;
lin poistaa_V = mkkV "poistaa" ;
lin poistattaa_V = mkkV "poistattaa" ;
lin poiste_N = mkkN "poiste" ;
lin poistin_N = mkkN "poistin" ;
lin poisto_N = mkkN "poisto" ;
lin poistua_V = mkkV "poistua" ;
lin poitsu_N = mkkN "poitsu" ;
lin poju_N = mkkN "poju" ;
lin poka_N = mkkN "poka" ;
lin pokaali_N = mkkN "pokaali" ;
lin pokata_1_V = mkkV "pokata" ;
lin pokata_2_V = mkkV "pokata" ;
lin pokeri_N = mkkN "pokeri" ;
lin pokka_N = mkkN "pokka" ;
lin pokkailla_V = mkkV "pokkailla" ;
lin pokkari_N = mkkN "pokkari" ;
lin pokkuroida_V = mkkV "pokkuroida" ;
lin pokkurointi_N = mkkN "pokkurointi" ;
lin poksahdus_N = mkkN "poksahdus" ;
lin poksahtaa_V = mkkV "poksahtaa" ;
lin poksauttaa_V = mkkV "poksauttaa" ;
lin poksi_N = mkkN "poksi" ;
lin pokstaavi_N = mkkN "pokstaavi" ;
lin pola_N = mkkN "pola" ;
lin polaarinen_N = mkkN "polaarinen" ;
lin polaarisuus_N = mkkN "polaarisuus" ;
lin polakka_N = mkkN "polakka" ;
lin polanne_N = mkkN "polanne" ;
lin polanteinen_N = mkkN "polanteinen" ;
lin polanteisuus_N = mkkN "polanteisuus" ;
lin polarisaatio_N = mkkN "polarisaatio" ;
lin polarisoida_V = mkkV "polarisoida" ;
lin polarisoitua_V = mkkV "polarisoitua" ;
lin polariteetti_N = mkkN "polariteetti" ;
lin polaroida_V = mkkV "polaroida" ;
lin polaroitua_V = mkkV "polaroitua" ;
lin poleemikko_N = mkkN "poleemikko" ;
lin poleeminen_A = mkkA "poleeminen" ;
lin poleemisesti_Adv = mkkAdv "poleemisesti" ;
lin poleemisuus_N = mkkN "poleemisuus" ;
lin polemiikki_N = mkkN "polemiikki" ;
lin polemikoida_V = mkkV "polemikoida" ;
lin polemikointi_N = mkkN "polemikointi" ;
lin polemisoida_V = mkkV "polemisoida" ;
lin polemisointi_N = mkkN "polemisointi" ;
lin poletti_N = mkkN "poletti" ;
lin poli_N = mkkN "poli" ;
lin poliitikko_N = mkkN "poliitikko" ;
lin poliittinen_A = mkkA "poliittinen" ;
lin poliittisesti_Adv = mkkAdv "poliittisesti" ;
lin poliittistaa_V = mkkV "poliittistaa" ;
lin poliittistua_V = mkkV "poliittistua" ;
lin poliittisuus_N = mkkN "poliittisuus" ;
lin polikliinisesti_Adv = mkkAdv "polikliinisesti" ;
lin polio_N = mkkN "polio" ;
lin politbyroo_N = mkkN "politbyroo" ;
lin politiikka_N = mkkN "politiikka" ;
lin politikoida_V = mkkV "politikoida" ;
lin politikointi_N = mkkN "politikointi" ;
lin politisoida_V = mkkV "politisoida" ;
lin politisointi_N = mkkN "politisointi" ;
lin politisoitua_V = mkkV "politisoitua" ;
lin politologi_N = mkkN "politologi" ;
lin politologia_N = mkkN "politologia" ;
lin poljennollinen_A = mkkA "poljennollinen" ;
lin poljennollisesti_Adv = mkkAdv "poljennollisesti" ;
lin poljenta_N = mkkN "poljenta" ;
lin poljento_N = mkkN "poljento" ;
lin poljin_N = mkkN "poljin" ;
lin polkaista_V = mkkV "polkaista" ;
lin polkaisu_N = mkkN "polkaisu" ;
lin polkea_V = mkkV "polkea" ;
lin polkeutua_V = mkkV "polkeutua" ;
lin polkka_N = mkkN "polkka" ;
lin polku_N = mkkN "polku" ;
lin polkusin_N = mkkN "polkusin" ;
lin polla_N = mkkN "polla" ;
lin pollari_1_N = mkkN "pollari" ;
lin pollari_2_N = mkkN "pollari" ;
lin polle_N = mkkN "polle" ;
lin pollea_N = mkkN "pollea" ;
lin polo_N = mkkN "polo" ;
lin poloinen_N = mkkN "poloinen" ;
lin poloneesi_N = mkkN "poloneesi" ;
lin polonium_N = mkkN "polonium" ;
lin polottaa_V = mkkV "polottaa" ;
lin polotus_N = mkkN "polotus" ;
lin polska_N = mkkN "polska" ;
lin polskahdus_N = mkkN "polskahdus" ;
lin polskahtaa_V = mkkV "polskahtaa" ;
lin polskaus_N = mkkN "polskaus" ;
lin polskauttaa_V = mkkV "polskauttaa" ;
lin polski_N = mkkN "polski" ;
lin polskia_V = mkkV "polskia" ;
lin polskuttaa_V = mkkV "polskuttaa" ;
lin polstari_N = mkkN "polstari" ;
lin polsteri_N = mkkN "polsteri" ;
lin poltattaa_V = mkkV "poltattaa" ;
lin polte_N = mkkN "polte" ;
lin poltella_V = mkkV "poltella" ;
lin polterabend_N = mkkN "polterabend" ;
lin poltergeist_N = mkkN "poltergeist" ;
lin poltin_N = mkkN "poltin" ;
lin polttaa_V = mkkV "polttaa" ;
lin polttaja_N = mkkN "polttaja" ;
lin polttama_N = mkkN "polttama" ;
--? lin polttarit_NK = {s = d06 "polttarit" ;
lin polttava_N = mkkN "polttava" ;
lin polttiainen_N = mkkN "polttiainen" ;
lin polttimo_N = mkkN "polttimo" ;
lin poltto_N = mkkN "poltto" ;
lin polttolakata_V = mkkV "polttolakata" ;
lin polttomaalata_V = mkkV "polttomaalata" ;
--? lin polvarit_NK = {s = d06 "polvarit" ;
lin polveilla_V = mkkV "polveilla" ;
lin polveke_N = mkkN "polveke" ;
lin polveutua_V = mkkV "polveutua" ;
lin polvi_N = mkkN "polvi" ;
lin polvillaan_Adv = mkkAdv "polvillaan" ;
lin polvilleen_Adv = mkkAdv "polvilleen" ;
lin polviltaan_Adv = mkkAdv "polviltaan" ;
lin polvinen_N = mkkN "polvinen" ;
lin polvistaa_V = mkkV "polvistaa" ;
lin polvistua_V = mkkV "polvistua" ;
lin polyamidi_N = mkkN "polyamidi" ;
lin polyesteri_N = mkkN "polyesteri" ;
lin polyeteeni_N = mkkN "polyeteeni" ;
lin polyfonia_N = mkkN "polyfonia" ;
lin polyfoninen_N = mkkN "polyfoninen" ;
lin polygaaminen_N = mkkN "polygaaminen" ;
lin polygamia_N = mkkN "polygamia" ;
lin polyglotti_N = mkkN "polyglotti" ;
lin polygoni_N = mkkN "polygoni" ;
lin polymeeri_N = mkkN "polymeeri" ;
lin polymeria_N = mkkN "polymeria" ;
lin polymerisaatio_N = mkkN "polymerisaatio" ;
lin polymerisoida_V = mkkV "polymerisoida" ;
lin polymerisoitua_V = mkkV "polymerisoitua" ;
lin polymeroida_V = mkkV "polymeroida" ;
lin polymeroitua_V = mkkV "polymeroitua" ;
lin polymorfia_N = mkkN "polymorfia" ;
lin polynomi_N = mkkN "polynomi" ;
lin polypropeeni_N = mkkN "polypropeeni" ;
lin polystyreeni_N = mkkN "polystyreeni" ;
lin polyteismi_N = mkkN "polyteismi" ;
lin polyteisti_N = mkkN "polyteisti" ;
lin polyteistinen_N = mkkN "polyteistinen" ;
lin polyuretaani_N = mkkN "polyuretaani" ;
lin polyyppi_N = mkkN "polyyppi" ;
lin pomada_N = mkkN "pomada" ;
lin pomelo_N = mkkN "pomelo" ;
lin pomeranssi_N = mkkN "pomeranssi" ;
lin pomeranssinkuori_N = mkkN "pomeranssinkuori" ;
lin pomiloida_V = mkkV "pomiloida" ;
lin pomilointi_N = mkkN "pomilointi" ;
lin pommi_1_N = mkkN "pommi" ;
lin pommi_2_N = mkkN "pommi" ;
lin pommitella_V = mkkV "pommitella" ;
lin pommittaa_V = mkkV "pommittaa" ;
lin pommittaja_N = mkkN "pommittaja" ;
lin pommitus_N = mkkN "pommitus" ;
lin pomo_N = mkkN "pomo" ;
lin pomoilla_V = mkkV "pomoilla" ;
lin pomoilu_N = mkkN "pomoilu" ;
lin pompahdella_V = mkkV "pompahdella" ;
lin pompahdus_N = mkkN "pompahdus" ;
lin pompahtaa_V = mkkV "pompahtaa" ;
lin pompata_V = mkkV "pompata" ;
lin pompottaa_V = mkkV "pompottaa" ;
lin pompotus_N = mkkN "pompotus" ;
lin pomppa_N = mkkN "pomppa" ;
lin pomppaus_N = mkkN "pomppaus" ;
lin pomppia_V = mkkV "pomppia" ;
lin pomppoilla_V = mkkV "pomppoilla" ;
lin pomppu_N = mkkN "pomppu" ;
lin pompula_N = mkkN "pompula" ;
lin pomsi_N = mkkN "pomsi" ;
lin poncho_N = mkkN "poncho" ;
lin pondi_N = mkkN "pondi" ;
lin poni_N = mkkN "poni" ;
lin ponkaista_V = mkkV "ponkaista" ;
lin ponkaisu_N = mkkN "ponkaisu" ;
lin ponnahdus_N = mkkN "ponnahdus" ;
lin ponnahduttaa_V = mkkV "ponnahduttaa" ;
lin ponnahtaa_V = mkkV "ponnahtaa" ;
lin ponnauttaa_V = mkkV "ponnauttaa" ;
lin ponnekas_A = mkkA "ponnekas" ;
lin ponnekkaasti_Adv = mkkAdv "ponnekkaasti" ;
lin ponnekkuus_N = mkkN "ponnekkuus" ;
lin ponneton_N = mkkN "ponneton" ;
lin ponnin_N = mkkN "ponnin" ;
lin ponnistaa_V = mkkV "ponnistaa" ;
lin ponnistautua_V = mkkV "ponnistautua" ;
lin ponnistella_V = mkkV "ponnistella" ;
lin ponnistelu_N = mkkN "ponnistelu" ;
lin ponnistus_N = mkkN "ponnistus" ;
lin ponsi_N = mkkN "ponsi" ;
lin ponssari_N = mkkN "ponssari" ;
lin pontata_V = mkkV "pontata" ;
lin ponteva_A = mkkA "ponteva" ;
lin pontevasti_Adv = mkkAdv "pontevasti" ;
lin pontevuus_N = mkkN "pontevuus" ;
lin pontikka_N = mkkN "pontikka" ;
lin ponttaus_N = mkkN "ponttaus" ;
lin pontti_N = mkkN "pontti" ;
lin ponttoni_N = mkkN "ponttoni" ;
lin pooli_1_N = mkkN "pooli" ;
lin pooli_2_N = mkkN "pooli" ;
lin poolo_N = mkkN "poolo" ;
lin pop_N = mkkN "pop" ;
lin popata_1_V = mkkV "popata" ;
lin popata_2_V = mkkV "popata" ;
lin popcorn_N = mkkN "popcorn" ;
lin popliini_N = mkkN "popliini" ;
lin poplore_N = mkkN "poplore" ;
lin poppa_N = mkkN "poppa" ;
lin poppana_N = mkkN "poppana" ;
lin poppoo_N = mkkN "poppoo" ;
lin popsia_V = mkkV "popsia" ;
lin populaari_N = mkkN "populaari" ;
lin populaaristaa_V = mkkV "populaaristaa" ;
lin populaarius_N = mkkN "populaarius" ;
lin populaatio_N = mkkN "populaatio" ;
lin popularisoida_V = mkkV "popularisoida" ;
lin populariteetti_N = mkkN "populariteetti" ;
lin populismi_N = mkkN "populismi" ;
lin populisti_N = mkkN "populisti" ;
lin populistinen_N = mkkN "populistinen" ;
lin popula'a'ri_N = mkkN "populääri" ;
lin pora_N = mkkN "pora" ;
lin poraaja_N = mkkN "poraaja" ;
lin porari_N = mkkN "porari" ;
lin porata_1_V = mkkV "porata" ;
lin porata_2_V = mkkV "porata" ;
lin poraus_N = mkkN "poraus" ;
lin porautua_V = mkkV "porautua" ;
lin pore_N = mkkN "pore" ;
lin poreilla_V = mkkV "poreilla" ;
lin poreilu_N = mkkN "poreilu" ;
lin poreinen_N = mkkN "poreinen" ;
lin poretin_N = mkkN "poretin" ;
lin porfiini_N = mkkN "porfiini" ;
lin porfyriini_N = mkkN "porfyriini" ;
lin porfyyri_N = mkkN "porfyyri" ;
lin porfyyrinen_N = mkkN "porfyyrinen" ;
lin porhaltaa_V = mkkV "porhaltaa" ;
lin porho_N = mkkN "porho" ;
lin porilainen_N = mkkN "porilainen" ;
lin porina_N = mkkN "porina" ;
lin porista_V = mkkV "porista" ;
lin porkka_N = mkkN "porkka" ;
lin porkkana_N = mkkN "porkkana" ;
lin pormestari_N = mkkN "pormestari" ;
lin pornahtava_N = mkkN "pornahtava" ;
lin porno_N = mkkN "porno" ;
lin pornografia_N = mkkN "pornografia" ;
lin pornografinen_N = mkkN "pornografinen" ;
lin poro_1_N = mkkN "poro" ;
lin poro_2_N = mkkN "poro" ;
lin poroinen_N = mkkN "poroinen" ;
lin porottaa_V = mkkV "porottaa" ;
lin porotus_N = mkkN "porotus" ;
lin porras_N = mkkN "porras" ;
lin porrastaa_V = mkkV "porrastaa" ;
lin porrasteisesti_Adv = mkkAdv "porrasteisesti" ;
lin porrasteisuus_N = mkkN "porrasteisuus" ;
lin porrastua_V = mkkV "porrastua" ;
lin porrastus_N = mkkN "porrastus" ;
lin porsas_N = mkkN "porsas" ;
lin porsasmaisesti_Adv = mkkAdv "porsasmaisesti" ;
lin porsastella_V = mkkV "porsastella" ;
lin porsastelu_N = mkkN "porsastelu" ;
lin porsia_V = mkkV "porsia" ;
lin porsittaa_V = mkkV "porsittaa" ;
lin porsitus_N = mkkN "porsitus" ;
lin porskutella_V = mkkV "porskutella" ;
lin porskuttaa_V = mkkV "porskuttaa" ;
lin porstua_N = mkkN "porstua" ;
lin portaali_N = mkkN "portaali" ;
lin portaaton_N = mkkN "portaaton" ;
lin portaattomasti_Adv = mkkAdv "portaattomasti" ;
lin portaikko_N = mkkN "portaikko" ;
lin portainen_N = mkkN "portainen" ;
lin portaittain_Adv = mkkAdv "portaittain" ;
lin portaittainen_N = mkkN "portaittainen" ;
lin portfolio_N = mkkN "portfolio" ;
lin portieeri_N = mkkN "portieeri" ;
--? lin port_salut_NK = {s = d22 "port salut" ;
lin portsari_N = mkkN "portsari" ;
lin portteri_N = mkkN "portteri" ;
lin portti_N = mkkN "portti" ;
lin portto_N = mkkN "portto" ;
lin porttola_N = mkkN "porttola" ;
lin portugali_N = mkkN "portugali" ;
lin portviini_N = mkkN "portviini" ;
lin poru_N = mkkN "poru" ;
lin porukka_N = mkkN "porukka" ;
lin porukoida_V = mkkV "porukoida" ;
lin porvari_N = mkkN "porvari" ;
lin porvarillinen_A = mkkA "porvarillinen" ;
lin porvarillisesti_Adv = mkkAdv "porvarillisesti" ;
lin porvarillistaa_V = mkkV "porvarillistaa" ;
lin porvarillistua_V = mkkV "porvarillistua" ;
lin porvarillisuus_N = mkkN "porvarillisuus" ;
lin porvarismi_N = mkkN "porvarismi" ;
lin porvaristo_N = mkkN "porvaristo" ;
lin posahdus_N = mkkN "posahdus" ;
lin posahtaa_V = mkkV "posahtaa" ;
lin posaus_N = mkkN "posaus" ;
lin posauttaa_V = mkkV "posauttaa" ;
lin pose_N = mkkN "pose" ;
lin poseerata_V = mkkV "poseerata" ;
lin poseeraus_N = mkkN "poseeraus" ;
lin posetiivari_N = mkkN "posetiivari" ;
lin posetiivi_N = mkkN "posetiivi" ;
lin positiivi_N = mkkN "positiivi" ;
lin positiivinen_A = mkkA "positiivinen" ;
lin positiivisesti_Adv = mkkAdv "positiivisesti" ;
lin positiivisuus_N = mkkN "positiivisuus" ;
lin positio_N = mkkN "positio" ;
lin positivismi_N = mkkN "positivismi" ;
lin positivisti_N = mkkN "positivisti" ;
lin positivistinen_N = mkkN "positivistinen" ;
lin positroni_N = mkkN "positroni" ;
lin poskeinen_N = mkkN "poskeinen" ;
lin posketon_N = mkkN "posketon" ;
lin poskettomasti_Adv = mkkAdv "poskettomasti" ;
lin poski_N = mkkN "poski" ;
lin poskinen_N = mkkN "poskinen" ;
lin posliini_N = mkkN "posliini" ;
lin posliininen_N = mkkN "posliininen" ;
lin posliininmaalaus_N = mkkN "posliininmaalaus" ;
lin posmittaa_V = mkkV "posmittaa" ;
lin posottaa_V = mkkV "posottaa" ;
lin possessiivinen_N = mkkN "possessiivinen" ;
lin possu_N = mkkN "possu" ;
lin poste_restante_N = mkkN "postC" ;
lin posteri_N = mkkN "posteri" ;
lin posti_1_N = mkkN "posti" ;
lin posti_2_N = mkkN "posti" ;
lin posti_3_N = mkkN "posti" ;
lin postiljooni_N = mkkN "postiljooni" ;
lin postilla_N = mkkN "postilla" ;
lin postimerkitta'a'_V = mkkV "postimerkittää" ;
lin postimerkkeilija'_N = mkkN "postimerkkeilijä" ;
lin postimerkkeilla'_V = mkkV "postimerkkeillä" ;
lin postimerkkeily_N = mkkN "postimerkkeily" ;
lin postinkanto_N = mkkN "postinkanto" ;
lin postite_N = mkkN "postite" ;
lin postitse_Adv = mkkAdv "postitse" ;
lin postittaa_V = mkkV "postittaa" ;
lin postitus_N = mkkN "postitus" ;
lin postpositio_N = mkkN "postpositio" ;
lin postulaatti_N = mkkN "postulaatti" ;
lin postuloida_V = mkkV "postuloida" ;
lin postuumi_N = mkkN "postuumi" ;
lin potaatti_N = mkkN "potaatti" ;
lin potaska_N = mkkN "potaska" ;
lin potea_V = mkkV "potea" ;
lin potensoida_V = mkkV "potensoida" ;
lin potensoitua_V = mkkV "potensoitua" ;
lin potenssi_N = mkkN "potenssi" ;
lin potentiaali_N = mkkN "potentiaali" ;
lin potentiaalinen_A = mkkA "potentiaalinen" ;
lin potentiaalisesti_Adv = mkkAdv "potentiaalisesti" ;
lin potentiometri_N = mkkN "potentiometri" ;
lin potentti_N = mkkN "potentti" ;
lin potero_N = mkkN "potero" ;
lin potilas_N = mkkN "potilas" ;
lin potka_N = mkkN "potka" ;
lin potkaista_V = mkkV "potkaista" ;
lin potkaisu_N = mkkN "potkaisu" ;
lin potkaus_N = mkkN "potkaus" ;
lin potkia_V = mkkV "potkia" ;
--? lin potkiaiset_NK = {s = d38 "potkiaiset" ;
lin potkija_N = mkkN "potkija" ;
lin potkiskella_V = mkkV "potkiskella" ;
lin potku_1_N = mkkN "potku" ;
lin potku_2_N = mkkN "potku" ;
lin potkuinen_N = mkkN "potkuinen" ;
lin potkuri_N = mkkN "potkuri" ;
lin potkurinen_N = mkkN "potkurinen" ;
lin potpuri_N = mkkN "potpuri" ;
lin potra_N = mkkN "potra" ;
lin potretti_N = mkkN "potretti" ;
lin potta_N = mkkN "potta" ;
lin potti_1_N = mkkN "potti" ;
lin potti_2_N = mkkN "potti" ;
lin pottu_1_N = mkkN "pottu" ;
lin pottu_2_N = mkkN "pottu" ;
lin pottuilla_V = mkkV "pottuilla" ;
lin pottuilu_N = mkkN "pottuilu" ;
lin pottumaisesti_Adv = mkkAdv "pottumaisesti" ;
lin pottuuntua_V = mkkV "pottuuntua" ;
lin potuttaa_V = mkkV "potuttaa" ;
lin poukahdella_V = mkkV "poukahdella" ;
lin poukahdus_N = mkkN "poukahdus" ;
lin poukahtaa_V = mkkV "poukahtaa" ;
lin poukahtelu_N = mkkN "poukahtelu" ;
lin poukama_N = mkkN "poukama" ;
lin poukata_V = mkkV "poukata" ;
lin poukauttaa_V = mkkV "poukauttaa" ;
lin poukkoilla_V = mkkV "poukkoilla" ;
lin poukkoilu_N = mkkN "poukkoilu" ;
lin pouta_N = mkkN "pouta" ;
lin poutainen_N = mkkN "poutainen" ;
lin poutia_V = mkkV "poutia" ;
lin povaaja_N = mkkN "povaaja" ;
lin povailla_V = mkkV "povailla" ;
lin povari_1_N = mkkN "povari" ;
lin povari_2_N = mkkN "povari" ;
lin povata_V = mkkV "povata" ;
lin povaus_N = mkkN "povaus" ;
lin povauttaa_V = mkkV "povauttaa" ;
lin poveton_N = mkkN "poveton" ;
lin povi_N = mkkN "povi" ;
lin povinen_N = mkkN "povinen" ;
lin PR_Adv = mkkAdv "PR" ;
lin praasniekka_N = mkkN "praasniekka" ;
lin pragmaatikko_N = mkkN "pragmaatikko" ;
lin pragmaattinen_A = mkkA "pragmaattinen" ;
lin pragmaattisesti_Adv = mkkAdv "pragmaattisesti" ;
lin pragmaattisuus_N = mkkN "pragmaattisuus" ;
lin pragmatiikka_N = mkkN "pragmatiikka" ;
lin pragmatismi_N = mkkN "pragmatismi" ;
lin pragmatisti_N = mkkN "pragmatisti" ;
lin prakata_V = mkkV "prakata" ;
lin praksis_N = mkkN "praksis" ;
lin praktiikka_N = mkkN "praktiikka" ;
lin praktikko_N = mkkN "praktikko" ;
lin praktikoida_V = mkkV "praktikoida" ;
lin praktikumi_N = mkkN "praktikumi" ;
lin praktinen_N = mkkN "praktinen" ;
lin praktisoida_V = mkkV "praktisoida" ;
lin praliini_N = mkkN "praliini" ;
lin pramea_A = mkkA "pramea" ;
lin prameasti_Adv = mkkAdv "prameasti" ;
lin prameilla_V = mkkV "prameilla" ;
lin prameilu_N = mkkN "prameilu" ;
lin prameus_N = mkkN "prameus" ;
lin predestinaatio_N = mkkN "predestinaatio" ;
lin predestinoida_V = mkkV "predestinoida" ;
lin predestinoitua_V = mkkV "predestinoitua" ;
lin predikaatti_N = mkkN "predikaatti" ;
lin predikatiivi_N = mkkN "predikatiivi" ;
lin preemio_N = mkkN "preemio" ;
lin preeria_N = mkkN "preeria" ;
lin preesens_N = mkkN "preesens" ;
lin prefekti_N = mkkN "prefekti" ;
lin preferenssi_N = mkkN "preferenssi" ;
lin prefiksi_N = mkkN "prefiksi" ;
lin prejudikaatti_N = mkkN "prejudikaatti" ;
lin prekambrinen_N = mkkN "prekambrinen" ;
lin prelaatti_N = mkkN "prelaatti" ;
lin prelimina'a'ri_N = mkkN "preliminääri" ;
lin preludi_N = mkkN "preludi" ;
lin premissi_N = mkkN "premissi" ;
lin prenataalinen_N = mkkN "prenataalinen" ;
lin prenikka_N = mkkN "prenikka" ;
lin preparaatti_N = mkkN "preparaatti" ;
lin preparaattori_N = mkkN "preparaattori" ;
lin preparoida_V = mkkV "preparoida" ;
lin prepata_V = mkkV "prepata" ;
lin prepositio_N = mkkN "prepositio" ;
lin preppaus_N = mkkN "preppaus" ;
lin presbyteeri_N = mkkN "presbyteeri" ;
lin presbyteerila'inen_N = mkkN "presbyteeriläinen" ;
lin presbyteerinen_N = mkkN "presbyteerinen" ;
lin presbyteriaani_N = mkkN "presbyteriaani" ;
lin presidentti_N = mkkN "presidentti" ;
lin presidenttiys_N = mkkN "presidenttiys" ;
lin presidiumi_N = mkkN "presidiumi" ;
lin presiis_Adv = mkkAdv "presiis" ;
lin presisoida_V = mkkV "presisoida" ;
lin presisointi_N = mkkN "presisointi" ;
lin pressa_N = mkkN "pressa" ;
lin pressi_N = mkkN "pressi" ;
lin pressu_N = mkkN "pressu" ;
lin prestiisi_N = mkkN "prestiisi" ;
lin presto_Adv = mkkAdv "presto" ;
lin preteriti_N = mkkN "preteriti" ;
lin preussi_N = mkkN "preussi" ;
lin preussilaisuus_N = mkkN "preussilaisuus" ;
lin prevalenssi_N = mkkN "prevalenssi" ;
lin preventiivinen_N = mkkN "preventiivinen" ;
lin preventio_N = mkkN "preventio" ;
lin priima_N = mkkN "priima" ;
lin priimas_N = mkkN "priimas" ;
lin priimi_N = mkkN "priimi" ;
lin priimus_N = mkkN "priimus" ;
lin prikaati_N = mkkN "prikaati" ;
lin priki_N = mkkN "priki" ;
lin prikka_N = mkkN "prikka" ;
lin prikku_N = mkkN "prikku" ;
lin prikulleen_Adv = mkkAdv "prikulleen" ;
lin prillit_N = mkkN "prillit" ;
lin primaari_A = mkkA "primaari" ;
lin primaarinen_A = mkkA "primaarinen" ;
lin primaarisesti_Adv = mkkAdv "primaarisesti" ;
lin primaaristi_Adv = mkkAdv "primaaristi" ;
lin primaarisuus_N = mkkN "primaarisuus" ;
lin primaarius_N = mkkN "primaarius" ;
lin primadonna_N = mkkN "primadonna" ;
lin prima_vista_N = mkkN "primC" ;
lin primitiivinen_A = mkkA "primitiivinen" ;
lin primitiivisesti_Adv = mkkAdv "primitiivisesti" ;
lin primitiivisyys_N = mkkN "primitiivisyys" ;
lin primitivismi_N = mkkN "primitivismi" ;
lin primitivisti_N = mkkN "primitivisti" ;
lin primus_motor_N = mkkN "primuC" ;
lin prima'a'ri_N = mkkN "primääri" ;
lin prima'a'rinen_N = mkkN "primäärinen" ;
lin prinkkala_N = mkkN "prinkkala" ;
lin prinsessa_N = mkkN "prinsessa" ;
lin prinsiippi_N = mkkN "prinsiippi" ;
lin prinssi_N = mkkN "prinssi" ;
lin printata_V = mkkV "printata" ;
lin printtaus_N = mkkN "printtaus" ;
lin printteri_N = mkkN "printteri" ;
lin printti_N = mkkN "printti" ;
lin priorisoida_V = mkkV "priorisoida" ;
lin priorisointi_N = mkkN "priorisointi" ;
lin prioriteetti_N = mkkN "prioriteetti" ;
lin prisma_N = mkkN "prisma" ;
lin privaatisti_Adv = mkkAdv "privaatisti" ;
lin privaatti_N = mkkN "privaatti" ;
lin privatisoida_V = mkkV "privatisoida" ;
lin privatisoitua_V = mkkV "privatisoitua" ;
lin privilegi_N = mkkN "privilegi" ;
lin privilegio_N = mkkN "privilegio" ;
lin pro_Adv = mkkAdv "pro" ;
lin probleema_N = mkkN "probleema" ;
lin probleemi_N = mkkN "probleemi" ;
lin problemaattinen_A = mkkA "problemaattinen" ;
lin problemaattisesti_Adv = mkkAdv "problemaattisesti" ;
lin problemaattisuus_N = mkkN "problemaattisuus" ;
lin problematiikka_N = mkkN "problematiikka" ;
lin problematisoida_V = mkkV "problematisoida" ;
lin problematisoitua_V = mkkV "problematisoitua" ;
lin produktiivinen_N = mkkN "produktiivinen" ;
lin produktiivistua_V = mkkV "produktiivistua" ;
lin produktiivisuus_N = mkkN "produktiivisuus" ;
lin produktio_N = mkkN "produktio" ;
lin produktiviteetti_N = mkkN "produktiviteetti" ;
lin produsoida_V = mkkV "produsoida" ;
lin produsointi_N = mkkN "produsointi" ;
lin profaani_N = mkkN "profaani" ;
lin profanoida_V = mkkV "profanoida" ;
lin profanoitua_V = mkkV "profanoitua" ;
lin profeetallinen_A = mkkA "profeetallinen" ;
lin profeetallisesti_Adv = mkkAdv "profeetallisesti" ;
lin profeetallisuus_N = mkkN "profeetallisuus" ;
lin profeetta_N = mkkN "profeetta" ;
lin professionaalinen_N = mkkN "professionaalinen" ;
lin professori_N = mkkN "professori" ;
lin professuuri_N = mkkN "professuuri" ;
lin profetia_N = mkkN "profetia" ;
lin profetoida_V = mkkV "profetoida" ;
lin proffa_N = mkkN "proffa" ;
lin profiili_N = mkkN "profiili" ;
lin profiloida_V = mkkV "profiloida" ;
lin profilointi_N = mkkN "profilointi" ;
lin profiloitua_V = mkkV "profiloitua" ;
lin profylaksi_N = mkkN "profylaksi" ;
lin profylaksia_N = mkkN "profylaksia" ;
lin profylaktinen_A = mkkA "profylaktinen" ;
lin profylaktisesti_Adv = mkkAdv "profylaktisesti" ;
lin profylaktisuus_N = mkkN "profylaktisuus" ;
lin progesteroni_N = mkkN "progesteroni" ;
lin progestiini_N = mkkN "progestiini" ;
lin prognoosi_N = mkkN "prognoosi" ;
lin prognostinen_N = mkkN "prognostinen" ;
lin progredioida_V = mkkV "progredioida" ;
lin progressiivinen_A = mkkA "progressiivinen" ;
lin progressiivisesti_Adv = mkkAdv "progressiivisesti" ;
lin progressiivisuus_N = mkkN "progressiivisuus" ;
lin progressio_N = mkkN "progressio" ;
lin projekti_N = mkkN "projekti" ;
lin projektiili_N = mkkN "projektiili" ;
lin projektiivinen_N = mkkN "projektiivinen" ;
lin projektio_N = mkkN "projektio" ;
lin projektori_N = mkkN "projektori" ;
lin projisioida_V = mkkV "projisioida" ;
lin projisiointi_N = mkkN "projisiointi" ;
lin projisoida_V = mkkV "projisoida" ;
lin projisointi_N = mkkN "projisointi" ;
lin prokuristi_N = mkkN "prokuristi" ;
lin prolaktiini_N = mkkN "prolaktiini" ;
lin prolatiivi_N = mkkN "prolatiivi" ;
lin proletaari_N = mkkN "proletaari" ;
lin proletaarinen_N = mkkN "proletaarinen" ;
lin proletaaristaa_V = mkkV "proletaaristaa" ;
lin proletaaristua_V = mkkV "proletaaristua" ;
lin proletariaatti_N = mkkN "proletariaatti" ;
lin proletarisoida_V = mkkV "proletarisoida" ;
lin proletarisoitua_V = mkkV "proletarisoitua" ;
lin prologi_N = mkkN "prologi" ;
lin promemoria_N = mkkN "promemoria" ;
lin promenadi_N = mkkN "promenadi" ;
lin promille_N = mkkN "promille" ;
lin promiskuiteetti_N = mkkN "promiskuiteetti" ;
lin promootio_N = mkkN "promootio" ;
lin promovendi_N = mkkN "promovendi" ;
lin promovoida_V = mkkV "promovoida" ;
lin pronominaali_N = mkkN "pronominaali" ;
lin pronominaalinen_N = mkkN "pronominaalinen" ;
lin pronssata_V = mkkV "pronssata" ;
lin pronssaus_N = mkkN "pronssaus" ;
lin pronssi_N = mkkN "pronssi" ;
lin pronssinen_N = mkkN "pronssinen" ;
lin pronssittaa_V = mkkV "pronssittaa" ;
lin pronssitus_N = mkkN "pronssitus" ;
lin proomu_N = mkkN "proomu" ;
lin proosallisesti_Adv = mkkAdv "proosallisesti" ;
lin propaani_N = mkkN "propaani" ;
lin propaganda_N = mkkN "propaganda" ;
lin propagandisti_N = mkkN "propagandisti" ;
lin propagandistinen_N = mkkN "propagandistinen" ;
lin propagoida_V = mkkV "propagoida" ;
lin propagoija_N = mkkN "propagoija" ;
lin propagointi_N = mkkN "propagointi" ;
lin propanoli_N = mkkN "propanoli" ;
lin propata_V = mkkV "propata" ;
lin propelli_N = mkkN "propelli" ;
lin proportionaalinen_N = mkkN "proportionaalinen" ;
lin proppu_N = mkkN "proppu" ;
lin propri_N = mkkN "propri" ;
lin propsi_N = mkkN "propsi" ;
lin prosaisti_N = mkkN "prosaisti" ;
lin proseduuri_N = mkkN "proseduuri" ;
lin prosentiton_N = mkkN "prosentiton" ;
lin prosenttisesti_Adv = mkkAdv "prosenttisesti" ;
lin prosentuaalinen_A = mkkA "prosentuaalinen" ;
lin prosentuaalisesti_Adv = mkkAdv "prosentuaalisesti" ;
lin prosessi_N = mkkN "prosessi" ;
lin prosessikirjoittaminen_N = mkkN "prosessikirjoittaminen" ;
lin prosessoida_V = mkkV "prosessoida" ;
lin prosessointi_N = mkkN "prosessointi" ;
lin prosessori_N = mkkN "prosessori" ;
lin prosit_Adv = mkkAdv "prosit" ;
lin prospekti_N = mkkN "prospekti" ;
lin prossa_N = mkkN "prossa" ;
lin prostaglandiini_N = mkkN "prostaglandiini" ;
lin prostata_N = mkkN "prostata" ;
lin prostituoida_V = mkkV "prostituoida" ;
lin prostituointi_N = mkkN "prostituointi" ;
lin prostituoitu_N = mkkN "prostituoitu" ;
lin prostituoitua_V = mkkV "prostituoitua" ;
lin prostituutio_N = mkkN "prostituutio" ;
lin protektionismi_N = mkkN "protektionismi" ;
lin protektionisti_N = mkkN "protektionisti" ;
lin protektionistinen_N = mkkN "protektionistinen" ;
lin protektoraatti_N = mkkN "protektoraatti" ;
lin protestantismi_N = mkkN "protestantismi" ;
lin protestantti_N = mkkN "protestantti" ;
lin protestanttinen_N = mkkN "protestanttinen" ;
lin protestanttisuus_N = mkkN "protestanttisuus" ;
lin protestoida_V = mkkV "protestoida" ;
lin protestointi_N = mkkN "protestointi" ;
lin protium_N = mkkN "protium" ;
lin proto_N = mkkN "proto" ;
lin protokolla_N = mkkN "protokolla" ;
lin protoni_N = mkkN "protoni" ;
lin proviisori_N = mkkN "proviisori" ;
lin provinsiaalinen_N = mkkN "provinsiaalinen" ;
lin provinsialismi_N = mkkN "provinsialismi" ;
lin provisorinen_N = mkkN "provisorinen" ;
lin provokaatio_N = mkkN "provokaatio" ;
lin provokaattori_N = mkkN "provokaattori" ;
lin provokatiivinen_A = mkkA "provokatiivinen" ;
lin provokatiivisesti_Adv = mkkAdv "provokatiivisesti" ;
lin provokatiivisuus_N = mkkN "provokatiivisuus" ;
lin provokatorinen_A = mkkA "provokatorinen" ;
lin provokatorisesti_Adv = mkkAdv "provokatorisesti" ;
lin provokatorisuus_N = mkkN "provokatorisuus" ;
lin provosoida_V = mkkV "provosoida" ;
lin provosointi_N = mkkN "provosointi" ;
lin provosoitua_V = mkkV "provosoitua" ;
lin prutkuttaa_V = mkkV "prutkuttaa" ;
lin prutkutus_N = mkkN "prutkutus" ;
lin pra'ntti_N = mkkN "präntti" ;
lin pra'ssi_N = mkkN "prässi" ;
lin pra'ssa'ta'_V = mkkV "prässätä" ;
lin pra'ssa'ys_N = mkkN "prässäys" ;
lin pra'ssa'ytta'a'_V = mkkV "prässäyttää" ;
lin pra'ssa'ytya'_V = mkkV "prässäytyä" ;
lin pra'ssa'a'mo'_N = mkkN "prässäämö" ;
lin pra'tka'_N = mkkN "prätkä" ;
lin pro'ysta'illa'_V = mkkV "pröystäillä" ;
lin pro'ysta'ily_N = mkkN "pröystäily" ;
lin psalmi_N = mkkN "psalmi" ;
lin psalttari_N = mkkN "psalttari" ;
lin pseudokruppi_N = mkkN "pseudokruppi" ;
lin pseudonyymi_N = mkkN "pseudonyymi" ;
lin psori_N = mkkN "psori" ;
lin psoriaatikko_N = mkkN "psoriaatikko" ;
lin psoriasis_N = mkkN "psoriasis" ;
lin psykedeelinen_N = mkkN "psykedeelinen" ;
lin psykiatri_N = mkkN "psykiatri" ;
lin psykiatria_N = mkkN "psykiatria" ;
lin psykiatrinen_N = mkkN "psykiatrinen" ;
lin psykofarmaka_N = mkkN "psykofarmaka" ;
lin psykogeeninen_N = mkkN "psykogeeninen" ;
lin psykokinesia_N = mkkN "psykokinesia" ;
lin psykologi_N = mkkN "psykologi" ;
lin psykologia_N = mkkN "psykologia" ;
lin psykologinen_A = mkkA "psykologinen" ;
lin psykologioida_V = mkkV "psykologioida" ;
lin psykologiointi_N = mkkN "psykologiointi" ;
lin psykologisesti_Adv = mkkAdv "psykologisesti" ;
lin psykologisoida_V = mkkV "psykologisoida" ;
lin psykometriikka_N = mkkN "psykometriikka" ;
lin psykometrinen_N = mkkN "psykometrinen" ;
lin psykoosi_N = mkkN "psykoosi" ;
lin psykoottinen_A = mkkA "psykoottinen" ;
lin psykoottisesti_Adv = mkkAdv "psykoottisesti" ;
lin psykoottisuus_N = mkkN "psykoottisuus" ;
lin psykopaatti_N = mkkN "psykopaatti" ;
lin psykopaattinen_N = mkkN "psykopaattinen" ;
lin psykopatia_N = mkkN "psykopatia" ;
lin psykopatologia_N = mkkN "psykopatologia" ;
lin psykosomaattinen_N = mkkN "psykosomaattinen" ;
lin psyykata_V = mkkV "psyykata" ;
lin psyyke_N = mkkN "psyyke" ;
lin psyykkaus_N = mkkN "psyykkaus" ;
lin psyykkinen_A = mkkA "psyykkinen" ;
lin psyykkisesti_Adv = mkkAdv "psyykkisesti" ;
lin ptolemaiolainen_N = mkkN "ptolemaiolainen" ;
lin ptruu_Adv = mkkAdv "ptruu" ;
lin pub_N = mkkN "pub" ;
lin puberteetti_N = mkkN "puberteetti" ;
lin pubi_N = mkkN "pubi" ;
lin publiikki_N = mkkN "publiikki" ;
lin publikaani_N = mkkN "publikaani" ;
lin publisiteetti_N = mkkN "publisiteetti" ;
lin pudas_N = mkkN "pudas" ;
lin pudistaa_V = mkkV "pudistaa" ;
lin pudistella_V = mkkV "pudistella" ;
lin pudistus_N = mkkN "pudistus" ;
lin pudokas_N = mkkN "pudokas" ;
lin pudota_V = mkkV "pudota" ;
lin pudotella_V = mkkV "pudotella" ;
lin pudottaa_V = mkkV "pudottaa" ;
lin pudottautua_V = mkkV "pudottautua" ;
lin pudotus_N = mkkN "pudotus" ;
lin pueskella_V = mkkV "pueskella" ;
lin puettaa_V = mkkV "puettaa" ;
lin puffata_V = mkkV "puffata" ;
lin puffi_N = mkkN "puffi" ;
lin pugilismi_N = mkkN "pugilismi" ;
lin pugilisti_N = mkkN "pugilisti" ;
lin puhahtaa_V = mkkV "puhahtaa" ;
lin puhallella_V = mkkV "puhallella" ;
lin puhallin_N = mkkN "puhallin" ;
lin puhallus_N = mkkN "puhallus" ;
lin puhalluttaa_V = mkkV "puhalluttaa" ;
lin puhallutus_N = mkkN "puhallutus" ;
lin puhaltaa_V = mkkV "puhaltaa" ;
lin puhaltaja_N = mkkN "puhaltaja" ;
lin puhdas_N = mkkN "puhdas" ;
lin puhdasrotuisuus_N = mkkN "puhdasrotuisuus" ;
lin puhde_N = mkkN "puhde" ;
lin puhdistaa_V = mkkV "puhdistaa" ;
lin puhdistaja_N = mkkN "puhdistaja" ;
lin puhdistamo_N = mkkN "puhdistamo" ;
lin puhdistautua_V = mkkV "puhdistautua" ;
lin puhdiste_N = mkkN "puhdiste" ;
lin puhdistin_N = mkkN "puhdistin" ;
lin puhdistua_V = mkkV "puhdistua" ;
lin puhdistuma_N = mkkN "puhdistuma" ;
lin puhdistus_N = mkkN "puhdistus" ;
lin puhdistuttaa_V = mkkV "puhdistuttaa" ;
lin puhe_N = mkkN "puhe" ;
lin puheilla_Adv = mkkAdv "puheilla" ;
lin puheille_Adv = mkkAdv "puheille" ;
lin puheilta_Adv = mkkAdv "puheilta" ;
lin puheinen_N = mkkN "puheinen" ;
lin puheisiin_Adv = mkkAdv "puheisiin" ;
lin puheissa_Adv = mkkAdv "puheissa" ;
lin puheliaisuus_N = mkkN "puheliaisuus" ;
lin puhelias_N = mkkN "puhelias" ;
lin puhelimitse_Adv = mkkAdv "puhelimitse" ;
lin puhelin_N = mkkN "puhelin" ;
lin puhella_V = mkkV "puhella" ;
lin puhelu_N = mkkN "puhelu" ;
lin puhina_N = mkkN "puhina" ;
lin puhista_V = mkkV "puhista" ;
lin puhjeta_V = mkkV "puhjeta" ;
lin puhkaa_V = mkkV "puhkaa" ;
lin puhkaista_V = mkkV "puhkaista" ;
lin puhkaisu_N = mkkN "puhkaisu" ;
lin puhkeama_N = mkkN "puhkeama" ;
lin puhkeilla_V = mkkV "puhkeilla" ;
lin puhki_Adv = mkkAdv "puhki" ;
lin puhkia_V = mkkV "puhkia" ;
lin puhkina_N = mkkN "puhkina" ;
lin puhkinta_N = mkkN "puhkinta" ;
lin puhkoa_V = mkkV "puhkoa" ;
lin puhkonta_N = mkkN "puhkonta" ;
lin puhkua_V = mkkV "puhkua" ;
lin puhkunta_N = mkkN "puhkunta" ;
lin puhtaasti_Adv = mkkAdv "puhtaasti" ;
lin puhtaus_N = mkkN "puhtaus" ;
lin puhti_N = mkkN "puhti" ;
lin puhtoinen_N = mkkN "puhtoinen" ;
lin puhua_V = mkkV "puhua" ;
lin puhuja_N = mkkN "puhuja" ;
lin puhumaton_N = mkkN "puhumaton" ;
lin puhumattomuus_N = mkkN "puhumattomuus" ;
lin puhunta_N = mkkN "puhunta" ;
lin puhuri_N = mkkN "puhuri" ;
lin puhutella_V = mkkV "puhutella" ;
lin puhuttaa_V = mkkV "puhuttaa" ;
lin puhuttelija_N = mkkN "puhuttelija" ;
lin puhuttelu_N = mkkN "puhuttelu" ;
lin puhuva_N = mkkN "puhuva" ;
lin puhveli_N = mkkN "puhveli" ;
lin puhvetti_N = mkkN "puhvetti" ;
lin puhvi_N = mkkN "puhvi" ;
lin puida_V = mkkV "puida" ;
lin puija_N = mkkN "puija" ;
lin puijata_V = mkkV "puijata" ;
lin puijaus_N = mkkN "puijaus" ;
lin puikahtaa_V = mkkV "puikahtaa" ;
lin puikea_N = mkkN "puikea" ;
lin puikkari_N = mkkN "puikkari" ;
lin puikkaroida_V = mkkV "puikkaroida" ;
lin puikkarointi_N = mkkN "puikkarointi" ;
lin puikkaus_N = mkkN "puikkaus" ;
lin puikkelehtia_V = mkkV "puikkelehtia" ;
lin puikkia_V = mkkV "puikkia" ;
lin puikko_N = mkkN "puikko" ;
lin puimala_N = mkkN "puimala" ;
lin puimuri_N = mkkN "puimuri" ;
lin puin_N = mkkN "puin" ;
lin puinen_N = mkkN "puinen" ;
lin puinti_N = mkkN "puinti" ;
lin puiseva_A = mkkA "puiseva" ;
lin puisevasti_Adv = mkkAdv "puisevasti" ;
lin puisevuus_N = mkkN "puisevuus" ;
lin puistaa_V = mkkV "puistaa" ;
lin puistattaa_V = mkkV "puistattaa" ;
lin puistatus_N = mkkN "puistatus" ;
lin puistikko_N = mkkN "puistikko" ;
lin puistikkoinen_N = mkkN "puistikkoinen" ;
lin puisto_N = mkkN "puisto" ;
lin puite_N = mkkN "puite" ;
lin puitteinen_N = mkkN "puitteinen" ;
lin pujahtaa_V = mkkV "pujahtaa" ;
lin pujo_N = mkkN "pujo" ;
lin pujoa_V = mkkV "pujoa" ;
lin pujoke_N = mkkN "pujoke" ;
lin pujonta_N = mkkN "pujonta" ;
lin pujos_N = mkkN "pujos" ;
lin pujotella_V = mkkV "pujotella" ;
lin pujottaa_V = mkkV "pujottaa" ;
lin pujottautua_V = mkkV "pujottautua" ;
lin pujottelija_N = mkkN "pujottelija" ;
lin pujottelu_N = mkkN "pujottelu" ;
lin pujottua_V = mkkV "pujottua" ;
lin pujotus_N = mkkN "pujotus" ;
lin pukahtaa_V = mkkV "pukahtaa" ;
lin pukari_N = mkkN "pukari" ;
lin pukata_V = mkkV "pukata" ;
lin pukea_V = mkkV "pukea" ;
--? lin pukeet_NK = {s = d48 "pukeet" ;
lin puketti_N = mkkN "puketti" ;
lin pukeutua_V = mkkV "pukeutua" ;
lin pukija_N = mkkN "pukija" ;
lin pukimo_N = mkkN "pukimo" ;
lin pukine_N = mkkN "pukine" ;
lin pukinjuuri_N = mkkN "pukinjuuri" ;
lin pukinkontti_N = mkkN "pukinkontti" ;
lin pukittaa_V = mkkV "pukittaa" ;
lin pukkailla_V = mkkV "pukkailla" ;
lin pukkari_N = mkkN "pukkari" ;
lin pukkaus_N = mkkN "pukkaus" ;
lin pukki_1_N = mkkN "pukki" ;
lin pukki_2_N = mkkN "pukki" ;
lin puksuttaa_V = mkkV "puksuttaa" ;
lin puksutus_N = mkkN "puksutus" ;
lin puku_N = mkkN "puku" ;
lin pukuinen_N = mkkN "pukuinen" ;
lin pula_N = mkkN "pula" ;
lin pula_aika_N = mkkN "pula-aika" ;
lin pulahdus_N = mkkN "pulahdus" ;
lin pulahtaa_V = mkkV "pulahtaa" ;
lin pulaus_N = mkkN "pulaus" ;
lin pulauttaa_V = mkkV "pulauttaa" ;
lin pulautus_N = mkkN "pulautus" ;
lin puleerata_V = mkkV "puleerata" ;
lin puleeraus_N = mkkN "puleeraus" ;
lin puli_1_N = mkkN "puli" ;
lin puli_2_N = mkkN "puli" ;
lin puli_3_N = mkkN "puli" ;
lin pulikka_N = mkkN "pulikka" ;
lin pulikoida_V = mkkV "pulikoida" ;
lin pulikointi_N = mkkN "pulikointi" ;
lin pulina_N = mkkN "pulina" ;
lin pulisonki_N = mkkN "pulisonki" ;
lin pulista_V = mkkV "pulista" ;
lin pulittaa_V = mkkV "pulittaa" ;
lin puliveivari_N = mkkN "puliveivari" ;
lin puliveivata_V = mkkV "puliveivata" ;
lin pulja_N = mkkN "pulja" ;
lin pulju_N = mkkN "pulju" ;
lin pulkka_1_N = mkkN "pulkka" ;
lin pulkka_2_N = mkkN "pulkka" ;
lin pulla_N = mkkN "pulla" ;
lin pullahtaa_V = mkkV "pullahtaa" ;
lin pullauttaa_V = mkkV "pullauttaa" ;
lin pullea_N = mkkN "pullea" ;
lin pulliainen_N = mkkN "pulliainen" ;
lin pullikoida_V = mkkV "pullikoida" ;
lin pullikointi_N = mkkN "pullikointi" ;
lin pullistaa_V = mkkV "pullistaa" ;
lin pullistella_V = mkkV "pullistella" ;
lin pullistelu_N = mkkN "pullistelu" ;
lin pullistua_V = mkkV "pullistua" ;
lin pullistuma_N = mkkN "pullistuma" ;
lin pullistus_N = mkkN "pullistus" ;
lin pullo_N = mkkN "pullo" ;
lin pulloittain_Adv = mkkAdv "pulloittain" ;
lin pullollaan_Adv = mkkAdv "pullollaan" ;
lin pullolleen_Adv = mkkAdv "pullolleen" ;
lin pullollinen_N = mkkN "pullollinen" ;
lin pullote_N = mkkN "pullote" ;
lin pullottaa_V = mkkV "pullottaa" ;
lin pullottamo_N = mkkN "pullottamo" ;
lin pullotus_N = mkkN "pullotus" ;
lin pullukka_N = mkkN "pullukka" ;
lin pulma_N = mkkN "pulma" ;
lin pulmallinen_N = mkkN "pulmallinen" ;
lin pulmallisuus_N = mkkN "pulmallisuus" ;
lin pulmu_N = mkkN "pulmu" ;
lin pulmunen_N = mkkN "pulmunen" ;
lin pulpahdella_V = mkkV "pulpahdella" ;
lin pulpahtaa_V = mkkV "pulpahtaa" ;
lin pulpetti_N = mkkN "pulpetti" ;
lin pulppuilla_V = mkkV "pulppuilla" ;
lin pulputa_V = mkkV "pulputa" ;
lin pulputtaa_V = mkkV "pulputtaa" ;
lin pulputus_N = mkkN "pulputus" ;
lin pulsaatio_N = mkkN "pulsaatio" ;
lin pulsaattori_N = mkkN "pulsaattori" ;
lin pulsari_N = mkkN "pulsari" ;
lin pulska_A = mkkA "pulska" ;
lin pulskasti_Adv = mkkAdv "pulskasti" ;
lin pulskistaa_V = mkkV "pulskistaa" ;
lin pulskistua_V = mkkV "pulskistua" ;
lin pulssi_N = mkkN "pulssi" ;
lin pultata_V = mkkV "pultata" ;
lin pulteri_N = mkkN "pulteri" ;
lin pultittaa_V = mkkV "pultittaa" ;
lin pultsari_N = mkkN "pultsari" ;
lin pulttaus_N = mkkN "pulttaus" ;
lin pultti_1_N = mkkN "pultti" ;
lin pultti_2_N = mkkN "pultti" ;
lin pulu_N = mkkN "pulu" ;
lin pulveri_N = mkkN "pulveri" ;
lin pulverisaattori_N = mkkN "pulverisaattori" ;
lin pulveroida_V = mkkV "pulveroida" ;
lin pulveroitua_V = mkkV "pulveroitua" ;
lin pumasiini_N = mkkN "pumasiini" ;
lin pumaska_N = mkkN "pumaska" ;
lin pummata_V = mkkV "pummata" ;
lin pummaus_N = mkkN "pummaus" ;
lin pummi_N = mkkN "pummi" ;
lin pumpata_V = mkkV "pumpata" ;
lin pumpernikkeli_N = mkkN "pumpernikkeli" ;
lin pumppaamo_N = mkkN "pumppaamo" ;
lin pumppaus_N = mkkN "pumppaus" ;
lin pumppu_N = mkkN "pumppu" ;
lin pumppuamo_N = mkkN "pumppuamo" ;
lin pumpuli_N = mkkN "pumpuli" ;
lin pumpulinen_N = mkkN "pumpulinen" ;
lin pumputa_V = mkkV "pumputa" ;
lin puna_N = mkkN "puna" ;
lin punahehkuinen_N = mkkN "punahehkuinen" ;
lin punahelttainen_N = mkkN "punahelttainen" ;
lin punainen_N = mkkN "punainen" ;
lin punaisuus_N = mkkN "punaisuus" ;
lin punajuuri_N = mkkN "punajuuri" ;
lin punakka_N = mkkN "punakka" ;
lin punakko_N = mkkN "punakko" ;
lin punakkuus_N = mkkN "punakkuus" ;
lin punakoitua_V = mkkV "punakoitua" ;
lin punastella_V = mkkV "punastella" ;
lin punastelu_N = mkkN "punastelu" ;
lin punastua_V = mkkV "punastua" ;
lin punastus_N = mkkN "punastus" ;
lin punastuttaa_V = mkkV "punastuttaa" ;
lin punata_V = mkkV "punata" ;
lin punatulkku_N = mkkN "punatulkku" ;
lin punaus_N = mkkN "punaus" ;
lin punavaloinen_N = mkkN "punavaloinen" ;
lin pune_N = mkkN "pune" ;
lin punehtia_V = mkkV "punehtia" ;
lin punehtua_V = mkkV "punehtua" ;
lin punehtuma_N = mkkN "punehtuma" ;
lin punerrus_N = mkkN "punerrus" ;
lin punerruttaa_V = mkkV "punerruttaa" ;
lin punertaa_V = mkkV "punertaa" ;
lin punertava_N = mkkN "punertava" ;
lin punertua_V = mkkV "punertua" ;
lin punerva_N = mkkN "punerva" ;
lin punikki_N = mkkN "punikki" ;
lin punk_N = mkkN "punk" ;
lin punka_N = mkkN "punka" ;
lin punkka_1_N = mkkN "punkka" ;
lin punkka_2_N = mkkN "punkka" ;
lin punkki_1_N = mkkN "punkki" ;
lin punkki_2_N = mkkN "punkki" ;
lin punkku_N = mkkN "punkku" ;
lin punkteerata_V = mkkV "punkteerata" ;
lin punktio_N = mkkN "punktio" ;
lin punktoida_V = mkkV "punktoida" ;
lin punnerrus_N = mkkN "punnerrus" ;
lin punnertaa_V = mkkV "punnertaa" ;
lin punninta_N = mkkN "punninta" ;
lin punnita_V = mkkV "punnita" ;
lin punnitus_N = mkkN "punnitus" ;
lin punnus_N = mkkN "punnus" ;
lin punoa_V = mkkV "punoa" ;
lin punoittaa_V = mkkV "punoittaa" ;
lin punoittua_V = mkkV "punoittua" ;
lin punoitus_N = mkkN "punoitus" ;
lin punoja_N = mkkN "punoja" ;
lin punonnainen_N = mkkN "punonnainen" ;
lin punonta_N = mkkN "punonta" ;
lin punontainen_N = mkkN "punontainen" ;
lin punos_N = mkkN "punos" ;
lin punoutua_V = mkkV "punoutua" ;
lin punssi_N = mkkN "punssi" ;
lin punta_N = mkkN "punta" ;
lin puntari_N = mkkN "puntari" ;
lin puntaroida_V = mkkV "puntaroida" ;
lin puntarointi_N = mkkN "puntarointi" ;
lin puntata_V = mkkV "puntata" ;
lin puntis_N = mkkN "puntis" ;
lin puntti_1_N = mkkN "puntti" ;
lin puntti_2_N = mkkN "puntti" ;
lin puntti_3_N = mkkN "puntti" ;
lin puola_1_N = mkkN "puola" ;
lin puola_2_N = mkkN "puola" ;
lin puola_3_N = mkkN "puola" ;
lin puolain_N = mkkN "puolain" ;
lin puolainen_N = mkkN "puolainen" ;
lin puolalaisuus_N = mkkN "puolalaisuus" ;
lin puolantaa_V = mkkV "puolantaa" ;
lin puolasto_N = mkkN "puolasto" ;
lin puolata_V = mkkV "puolata" ;
lin puolaus_N = mkkN "puolaus" ;
lin puoleen_Adv = mkkAdv "puoleen" ;
lin puoleinen_A = mkkA "puoleinen" ;
lin puoleisesti_Adv = mkkAdv "puoleisesti" ;
lin puoleksi_Adv = mkkAdv "puoleksi" ;
lin puolesta_Adv = mkkAdv "puolesta" ;
lin puoli_N = mkkN "puoli" ;
lin puoliaika_N = mkkN "puoliaika" ;
lin puolihorroksiin_Adv = mkkAdv "puolihorroksiin" ;
lin puolihorroksissa_Adv = mkkAdv "puolihorroksissa" ;
lin puolihorroksista_Adv = mkkAdv "puolihorroksista" ;
lin puoliintua_V = mkkV "puoliintua" ;
lin puoliintumisaika_N = mkkN "puoliintumisaika" ;
lin puolijuoksua_Adv = mkkAdv "puolijuoksua" ;
lin puolikas_N = mkkN "puolikas" ;
lin puoliksi_Adv = mkkAdv "puoliksi" ;
lin puolillaan_Adv = mkkAdv "puolillaan" ;
lin puolilleen_Adv = mkkAdv "puolilleen" ;
lin puolila'pa'iseva'_N = mkkN "puoliläpäisevä" ;
lin puolimmainen_N = mkkN "puolimmainen" ;
lin puolima'essa'_Adv = mkkAdv "puolimäessä" ;
lin puolima'esta'_Adv = mkkAdv "puolimäestä" ;
lin puolima'keen_Adv = mkkAdv "puolimäkeen" ;
lin puolinaisesti_Adv = mkkAdv "puolinaisesti" ;
lin puolinen_N = mkkN "puolinen" ;
lin puolipolveen_Adv = mkkAdv "puolipolveen" ;
lin puolipukeinen_N = mkkN "puolipukeinen" ;
lin puolipukeissa_Adv = mkkAdv "puolipukeissa" ;
lin puolipukeissaan_Adv = mkkAdv "puolipukeissaan" ;
lin puolireidessa'_Adv = mkkAdv "puolireidessä" ;
lin puolireiteen_Adv = mkkAdv "puolireiteen" ;
lin puoliselka'a'n_Adv = mkkAdv "puoliselkään" ;
lin puolisela'ssa'_Adv = mkkAdv "puoliselässä" ;
lin puolisela'sta'_Adv = mkkAdv "puoliselästä" ;
lin puolisen_Adv = mkkAdv "puolisen" ;
lin puolisenkymmenta'_Adv = mkkAdv "puolisenkymmentä" ;
lin puolisensataa_Adv = mkkAdv "puolisensataa" ;
lin puolisentoista_Adv = mkkAdv "puolisentoista" ;
lin puolisentoistasataa_Adv = mkkAdv "puolisentoistasataa" ;
lin puolisko_N = mkkN "puolisko" ;
lin puoliso_N = mkkN "puoliso" ;
lin puolisa'a'reen_Adv = mkkAdv "puolisääreen" ;
lin puolisa'a'ressa'_Adv = mkkAdv "puolisääressä" ;
lin puolisa'a'resta'_Adv = mkkAdv "puolisäärestä" ;
lin puolitalveen_Adv = mkkAdv "puolitalveen" ;
lin puolitalvessa_Adv = mkkAdv "puolitalvessa" ;
lin puolitalvesta_Adv = mkkAdv "puolitalvesta" ;
lin puolitangossa_Adv = mkkAdv "puolitangossa" ;
lin puolitankoon_Adv = mkkAdv "puolitankoon" ;
lin puolitiehen_Adv = mkkAdv "puolitiehen" ;
lin puolitiessa'_Adv = mkkAdv "puolitiessä" ;
lin puolitiesta'_Adv = mkkAdv "puolitiestä" ;
lin puolitonnari_N = mkkN "puolitonnari" ;
lin puolitse_Adv = mkkAdv "puolitse" ;
lin puolittaa_V = mkkV "puolittaa" ;
lin puolittain_Adv = mkkAdv "puolittain" ;
lin puolittainen_N = mkkN "puolittainen" ;
lin puolittua_V = mkkV "puolittua" ;
lin puolitus_N = mkkN "puolitus" ;
lin puoliuneen_Adv = mkkAdv "puoliuneen" ;
lin puoliunessa_Adv = mkkAdv "puoliunessa" ;
lin puoliutua_V = mkkV "puoliutua" ;
lin puolivahingossa_Adv = mkkAdv "puolivahingossa" ;
lin puolivaiheilla_Adv = mkkAdv "puolivaiheilla" ;
lin puolivaiheille_Adv = mkkAdv "puolivaiheille" ;
lin puolivillaisesti_Adv = mkkAdv "puolivillaisesti" ;
lin puolivillaisuus_N = mkkN "puolivillaisuus" ;
lin puolivoltti_N = mkkN "puolivoltti" ;
lin puoltaa_V = mkkV "puoltaa" ;
lin puoltaja_N = mkkN "puoltaja" ;
lin puolto_N = mkkN "puolto" ;
lin puolue_N = mkkN "puolue" ;
lin puolueellinen_A = mkkA "puolueellinen" ;
lin puolueellisesti_Adv = mkkAdv "puolueellisesti" ;
lin puolueellisuus_N = mkkN "puolueellisuus" ;
lin puolueeton_N = mkkN "puolueeton" ;
lin puolueettomasti_Adv = mkkAdv "puolueettomasti" ;
lin puolueettomuus_N = mkkN "puolueettomuus" ;
lin puolueinen_N = mkkN "puolueinen" ;
lin puolueittain_Adv = mkkAdv "puolueittain" ;
lin puolukka_N = mkkN "puolukka" ;
lin puolustaa_V = mkkV "puolustaa" ;
lin puolustaja_N = mkkN "puolustaja" ;
lin puolustamaton_N = mkkN "puolustamaton" ;
lin puolustautua_V = mkkV "puolustautua" ;
lin puolustella_V = mkkV "puolustella" ;
lin puolustelu_N = mkkN "puolustelu" ;
lin puolustuksellinen_A = mkkA "puolustuksellinen" ;
lin puolustuksellisesti_Adv = mkkAdv "puolustuksellisesti" ;
lin puolustuksellisuus_N = mkkN "puolustuksellisuus" ;
lin puolustus_N = mkkN "puolustus" ;
lin puomi_N = mkkN "puomi" ;
lin puomittaa_V = mkkV "puomittaa" ;
lin puomitus_N = mkkN "puomitus" ;
lin puoshaka_N = mkkN "puoshaka" ;
lin puoskari_N = mkkN "puoskari" ;
lin puoskaroida_V = mkkV "puoskaroida" ;
lin puoskaroija_N = mkkN "puoskaroija" ;
lin puoskarointi_N = mkkN "puoskarointi" ;
lin puosu_N = mkkN "puosu" ;
lin puoti_N = mkkN "puoti" ;
lin puotipuksu_N = mkkN "puotipuksu" ;
lin pupellus_N = mkkN "pupellus" ;
lin pupeltaa_V = mkkV "pupeltaa" ;
lin pupilli_N = mkkN "pupilli" ;
lin puppu_N = mkkN "puppu" ;
lin pupu_N = mkkN "pupu" ;
lin puputtaa_V = mkkV "puputtaa" ;
lin puraista_V = mkkV "puraista" ;
lin puraisu_N = mkkN "puraisu" ;
lin purasin_N = mkkN "purasin" ;
lin purattaa_V = mkkV "purattaa" ;
lin pureksia_V = mkkV "pureksia" ;
lin purema_N = mkkN "purema" ;
lin puremahaava_N = mkkN "puremahaava" ;
lin purenta_N = mkkN "purenta" ;
lin pureskelija_N = mkkN "pureskelija" ;
lin pureskella_V = mkkV "pureskella" ;
lin pureskelu_N = mkkN "pureskelu" ;
lin pureutua_V = mkkV "pureutua" ;
lin pureva_A = mkkA "pureva" ;
lin purevasti_Adv = mkkAdv "purevasti" ;
lin purevuus_N = mkkN "purevuus" ;
lin purija_N = mkkN "purija" ;
lin purilainen_N = mkkN "purilainen" ;
lin purilas_N = mkkN "purilas" ;
lin purismi_N = mkkN "purismi" ;
lin puristaa_V = mkkV "puristaa" ;
lin puristautua_V = mkkV "puristautua" ;
lin puriste_N = mkkN "puriste" ;
lin puristeinen_A = mkkA "puristeinen" ;
lin puristeisesti_Adv = mkkAdv "puristeisesti" ;
lin puristeisuus_N = mkkN "puristeisuus" ;
lin puristella_V = mkkV "puristella" ;
lin puristelu_N = mkkN "puristelu" ;
lin puristi_N = mkkN "puristi" ;
lin puristin_N = mkkN "puristin" ;
lin puristinen_A = mkkA "puristinen" ;
lin puristisesti_Adv = mkkAdv "puristisesti" ;
lin puristisuus_N = mkkN "puristisuus" ;
lin puristua_V = mkkV "puristua" ;
lin puristuma_N = mkkN "puristuma" ;
lin puristus_N = mkkN "puristus" ;
lin puristuvuus_N = mkkN "puristuvuus" ;
lin puritaani_N = mkkN "puritaani" ;
lin puritaaninen_A = mkkA "puritaaninen" ;
lin puritaanisesti_Adv = mkkAdv "puritaanisesti" ;
lin puritaanisuus_N = mkkN "puritaanisuus" ;
lin puritanismi_N = mkkN "puritanismi" ;
lin purje_N = mkkN "purje" ;
lin purjehdus_N = mkkN "purjehdus" ;
lin purjehtia_V = mkkV "purjehtia" ;
lin purjehtija_N = mkkN "purjehtija" ;
lin purjeinen_N = mkkN "purjeinen" ;
lin purjo_N = mkkN "purjo" ;
lin purkaa_V = mkkV "purkaa" ;
lin purkaantua_V = mkkV "purkaantua" ;
lin purkaja_N = mkkN "purkaja" ;
lin purkamo_N = mkkN "purkamo" ;
lin purkauma_N = mkkN "purkauma" ;
lin purkaus_N = mkkN "purkaus" ;
lin purkautua_V = mkkV "purkautua" ;
lin purkautuma_N = mkkN "purkautuma" ;
lin purkillinen_N = mkkN "purkillinen" ;
lin purkittaa_V = mkkV "purkittaa" ;
lin purkka_N = mkkN "purkka" ;
lin purkki_N = mkkN "purkki" ;
lin purku_N = mkkN "purku" ;
lin purnaaja_N = mkkN "purnaaja" ;
lin purnari_N = mkkN "purnari" ;
lin purnata_V = mkkV "purnata" ;
lin purnaus_N = mkkN "purnaus" ;
lin purnukka_N = mkkN "purnukka" ;
lin puro_N = mkkN "puro" ;
lin purppura_N = mkkN "purppura" ;
lin purppurainen_N = mkkN "purppurainen" ;
lin purppuri_N = mkkN "purppuri" ;
lin purppuroida_V = mkkV "purppuroida" ;
lin purpura_N = mkkN "purpura" ;
lin purpuri_N = mkkN "purpuri" ;
lin purra_V = mkkV "purra" ;
lin purse_N = mkkN "purse" ;
lin purseri_N = mkkN "purseri" ;
lin pursi_N = mkkN "pursi" ;
lin purskahdella_V = mkkV "purskahdella" ;
lin purskahdus_N = mkkN "purskahdus" ;
lin purskahtaa_V = mkkV "purskahtaa" ;
lin purskaus_N = mkkN "purskaus" ;
lin purskauttaa_V = mkkV "purskauttaa" ;
lin purskua_V = mkkV "purskua" ;
lin purskutella_V = mkkV "purskutella" ;
lin purskuttaa_V = mkkV "purskuttaa" ;
lin purskutus_N = mkkN "purskutus" ;
lin purso_N = mkkN "purso" ;
lin pursotin_N = mkkN "pursotin" ;
lin pursottaa_V = mkkV "pursottaa" ;
lin pursotus_N = mkkN "pursotus" ;
lin pursu_N = mkkN "pursu" ;
lin pursua_V = mkkV "pursua" ;
lin pursuilla_V = mkkV "pursuilla" ;
lin pursuta_V = mkkV "pursuta" ;
lin purtilo_N = mkkN "purtilo" ;
lin purtojuuri_N = mkkN "purtojuuri" ;
lin puru_N = mkkN "puru" ;
lin pus_Adv = mkkAdv "pus" ;
lin pusata_V = mkkV "pusata" ;
lin puseroinen_N = mkkN "puseroinen" ;
lin puseroisillaan_Adv = mkkAdv "puseroisillaan" ;
lin puseroisilleen_Adv = mkkAdv "puseroisilleen" ;
lin puserrin_N = mkkN "puserrin" ;
lin puserrus_N = mkkN "puserrus" ;
lin pusertaa_V = mkkV "pusertaa" ;
lin pusertautua_V = mkkV "pusertautua" ;
lin pusertua_V = mkkV "pusertua" ;
lin pusi_Adv = mkkAdv "pusi" ;
lin pusia_V = mkkV "pusia" ;
lin pusikko_N = mkkN "pusikko" ;
lin puska_N = mkkN "puska" ;
lin puskea_V = mkkV "puskea" ;
lin puskeutua_V = mkkV "puskeutua" ;
lin 