---- checked by AR till drive_V in the BNC order

concrete TopDictionaryFre of TopDictionary = CatFre ** open 
  ParadigmsFre,
  (P = ParadigmsFre),
  (S = SyntaxFre),
  (L = LexiconFre),
  (I = IrregFre),
  (E = ExtraFre),
  (E = ExtraFre),
  (Ph = PhonoFre),
  (M = MakeStructuralFre),
  MorphoFre, 
  Prelude in {

oper
  mkInterj : Str -> Interj = \s -> lin Interj (ss s) ;
  mkConj : Str -> Conj = \s -> lin Conj {s1 = [] ; s2 = s ; n = Pl} ;
  mkDet = overload {
    mkDet : Str -> Det = \s -> lin Det {s,sp = \\_,c => prepCase c ++ s ; n = Sg ; s2 = [] ; isNeg = False} ;
    mkDet : Str -> Str -> Number -> Det = \m,f,n -> lin Det {
      s,sp = \\g,c => prepCase c ++ case g of {Masc => m ; Fem => f} ; n = n ; s2 = [] ; isNeg = False
      } ;
    } ;

lin of_Prep = ParadigmsFre.genitive ;
lin and_Conj = S.and_Conj ;
lin in_Prep = mkPrep "dans" | mkPrep "en" | complDat ;
lin have_VV = mkVV (mkV I.devoir_V2) ;
lin have_V2 = S.have_V2 ;
lin have_V = mkV S.have_V2 ;
lin it_Pron = S.it_Pron | S.she_Pron | E.ce_Pron ;
lin to_Prep = S.to_Prep ;
lin for_Prep = S.for_Prep ;
lin i_Pron = S.i_Pron ;
lin iFem_Pron = E.i8fem_Pron ;
lin that_Subj = S.that_Subj ;
lin he_Pron = S.he_Pron ;
lin on_Prep = S.on_Prep ;
lin with_Prep = S.with_Prep ;
lin do_V2 = mkV2 (mkV I.faire_V2) ;
lin at_Prep = ParadigmsFre.dative | mkPrep "chez" ; ---- split
lin by_Prep = mkPrep "par" ;
lin but_Conj = mkConj "mais" ;
lin from_Prep = S.from_Prep ;
lin they_Pron = S.they_Pron ;
lin theyFem_Pron = E.they8fem_Pron ;
lin she_Pron = S.she_Pron ;
lin or_Conj = S.or_Conj ;
lin as_Subj = M.mkSubj "comme" ;
lin we_Pron = S.we_Pron ;
lin weFem_Pron = E.we8fem_Pron ;
lin say_VS = mkVS (mkV I.dire_V2) ;
lin say_V2 = I.dire_V2 ;
lin say_V = lin V I.dire_V2 ;
lin if_Subj = S.if_Subj ;
lin go_VV = mkVV I.aller_V ;
lin go_VA = mkVA (mkV I.devenir_V) ;
lin go_V = L.go_V ;
lin get_VV = mkVV (mkV "arriver") ;
lin get_V2V = mkV2V (mkV I.obtenir_V2) ;
lin make_V2V = mkV2V (mkV I.faire_V2) ;
lin make_V2A = mkV2V (mkV I.rendre_V2) ;
lin make_V2 = I.faire_V2 ;
lin make_V = mkV I.faire_V2 ;
lin as_Prep = mkPrep "comme" ;
lin out_Adv = mkAdv "dehors" ;
lin up_Adv = mkAdv "en haut" ;
lin see_VS = mkVS (mkV I.voir_V2) ;
lin see_VQ = mkVQ (mkV I.voir_V2) ;
lin see_V2V = mkV2V (mkV I.voir_V2) ;
lin see_V2 = L.see_V2 ;
lin see_V = mkV I.voir_V2 ;
lin know_VS = L.know_VS ;
lin know_VQ = L.know_VQ ;
lin know_V2 = L.know_V2 ;
lin know_V = mkV I.savoir_V2 ;
lin time_N = mkN "temps" masculine ;
lin time_2_N = mkN "fois" feminine ;
lin time_1_N = mkN "temps" masculine ;
lin take_V2 = I.prendre_V2 ;
lin so_Adv = mkAdv "ainsi" | mkAdv "tellement" | mkAdv "aussi" ;
lin year_N = mkN "an" | mkN "année" ; ---- split
lin into_Prep = mkPrep "dans" ;
lin then_Adv = mkAdv "ensuite" | mkAdv "alors" | mkAdv "puis" ;
lin think_VS = mkVS (mkV "penser") ;
lin think_V2 = mkV2 (mkV "penser") P.dative ;
lin think_V = L.think_V ;
lin come_V = L.come_V ;
lin than_Subj = M.mkSubj Ph.elisQue ;
lin more_Adv = mkAdv "plus" | mkAdv "davantage" ;
lin about_Prep = mkPrep "sur" ;
lin now_Adv = L.now_Adv ;
lin last_A = mkA "dernier" ;
lin last_1_A = prefixA (mkA "dernier") ;
lin last_2_A = mkA "dernier" ;
lin other_A = mkA "autre" ;
lin give_V3 = L.give_V3 ;
lin give_V2 = mkV2 "donner" ;
lin give_V = mkV "donner" ;
lin just_Adv = mkAdv "juste" ;
lin people_N = mkN "peuple" masculine | mkN "gens" ;
lin also_Adv = mkAdv "aussi" ;
lin well_Adv = mkAdv "bien" ;
lin only_Adv = mkAdv "seulement" ;
lin new_A = L.new_A ;
lin when_Subj = S.when_Subj | M.mkSubj ("lors" + Ph.elisQue) ;
lin way_N = mkN "manière" feminine | mkN "façon" feminine ;
lin way_2_N = mkN "manière" feminine | mkN "façon" feminine ;
lin way_1_N = mkN "route" ;
lin look_VA = mkVA (mkV "sembler") ;
lin look_V2 = mkV2 "regarder" ;
lin look_V = mkV "regarder" ;
lin like_Prep = mkPrep "comme" ;
lin use_VV = mkVV (mkV "pratiguer") ; ---- what does this mean?
lin use_V2 = mkV2 "utiliser" ;
lin use_V = mkV "utiliser" ;
lin because_Subj = S.because_Subj | M.mkSubj ("puis" + Ph.elisQue) ;
lin good_A = L.good_A;
lin find_VS = mkVS (mkV "trouver") ;
lin find_V2A = mkV2A (mkV "trouver") ;
lin find_V2 = L.find_V2 ;
lin find_V = mkV "trouver" ;
lin man_N = L.man_N ;
lin want_VV = S.want_VV ;
lin want_V2V = mkV2V (mkV I.vouloir_V2) ;
lin want_V2 = I.vouloir_V2 ;
lin want_V = mkV I.vouloir_V2 ;
lin day_N = L.day_N ;
lin between_Prep = S.between_Prep ;
lin even_Adv = mkAdv "même" ;
lin there_Adv = S.there_Adv | mkAdv "voilà" ; ---- voila
lin many_Det = S.many_Det ;
lin after_Prep = S.after_Prep ;
lin down_Adv = mkAdv "en bas" ;
lin yeah_Interj = mkInterj "oui" ; ----
lin so_Subj = M.mkSubjSubj "de façon que" ;
lin thing_N = mkN "chose" feminine ;
lin tell_VS = mkVS (mkV "raconter") ;
lin tell_V3 = mkV3 (mkV "raconter") P.accusative P.dative ;
lin tell_1_V3 = variants{} ; -- 
lin tell_2_V3 = variants{} ; -- 
lin tell_V2V = mkV2V (mkV I.dire_V2) P.dative P.genitive ;
lin tell_V2S = mkV2S (mkV "raconter") ;
lin tell_V2 = mkV2 "raconter" ;
lin tell_V = mkV "raconter" ;
lin through_Prep = S.through_Prep ;
lin back_Adv = mkAdv "en retour" ; ----
lin still_Adv = mkAdv "néanmoins" | mkAdv "encore" ;
lin child_N = L.child_N ;
lin here_Adv = mkAdv "ici" | mkAdv "voici" ; ---- voici
lin over_Prep = {s = "à travers" ; c = CPrep P_de ; isDir = False} ; --- split sense
lin too_Adv = mkAdv "aussi" ;
lin put_V2 = L.put_V2 ;
lin on_Adv = mkAdv "là-dessus" ; ----
lin no_Interj = mkInterj "non" ;
lin work_V2 = mkV2 (mkV "travailler") ;
lin work_V = mkV "travailler" ;
lin work_2_V = mkV "fonctionner" ;
lin work_1_V = mkV "travailler" ;
lin become_VA = L.become_VA ;
lin become_V2 = mkV2 (mkV I.devenir_V) ;
lin become_V = I.devenir_V ; ----
lin old_A = L.old_A ;
lin government_N = mkN "gouvernement" masculine ;
lin mean_VV = aVV (mkV "penser") ;
lin mean_VS = mkVS (mkV I.dire_V2) ; ---- veut dire
lin mean_V2V = mkV2V (mkV "signifier") ; ----
lin mean_V2 = mkV2 "signifier" ;
lin part_N = mkN "part" feminine | mkN "partie" feminine ;
lin leave_V2V = mkV2V (mkV "laisser") | mkV2V (mkV "quitter") ;
lin leave_V2 = L.leave_V2 ;
lin leave_V = I.partir_V | mkV "quitter" ;
lin life_N = mkN "vie" feminine ;
lin great_A = mkA "grand" | mkA "excellent" ;
lin case_N = mkN "cas" masculine | mkN "caisse" feminine | mkN "vitrine" feminine | mkN "écrin" masculine ; --- split
lin woman_N = L.woman_N ;
lin over_Adv = mkAdv "fini" ; --- split sense:
lin seem_VV = deVV (mkV "sembler") ;
lin seem_VS = mkVS (mkV "sembler") ;
lin seem_VA = mkVA (mkV "sembler") ;
lin work_N = mkN "travail" masculine ;
lin need_VV = deVV (mkV (mkV I.avoir_V2) "besoin") ;
lin need_VV = deVV (mkV (mkV I.avoir_V2) "besoin") ;
lin need_V2 = mkV2 (mkV (mkV I.avoir_V2) "besoin") ;
lin need_V = mkV "nécessiter" ;
lin feel_VS = mkVS I.sentir_V2 ;
lin feel_VA = mkVA (reflV (mkV I.sentir_V2)) ;
lin feel_V2 = mkV2 (mkV I.sentir_V2) ;
lin feel_V = (mkV I.sentir_V2) ;
lin system_N = mkN "système" masculine ;
lin each_Det = mkDet "chaque" ;
lin may_2_VV = S.can_VV ;
lin may_1_VV = S.can_VV ;
lin much_Adv = mkAdv "beaucoup" ;
lin ask_VQ = mkVQ (mkV "demander") ;
lin ask_V2V = mkV2V (mkV "demander") ;
lin ask_V2 = mkV2 "demander" ;
lin ask_V = mkV "demander" ;
lin group_N = mkN "groupe" masculine ;
lin number_N = L.number_N ;
lin number_3_N = L.number_N ;
lin number_2_N = L.number_N ;
lin number_1_N = L.number_N ;
lin yes_Interj = mkInterj "oui" ;
lin however_Adv = mkAdv "cependant" ;
lin another_Det = mkDet "autre" ;
lin again_Adv = mkAdv "encore" ;
lin world_N = mkN "monde" masculine ;
lin area_N = mkN "région" feminine ;
lin area_6_N = mkN "région" feminine | mkN "surface" ; ----
lin area_5_N = mkN "région" feminine | mkN "surface" ; ----
lin area_4_N = mkN "région" feminine | mkN "surface" ; ----
lin area_3_N = mkN "région" feminine | mkN "surface" ; ----
lin area_2_N = mkN "région" feminine | mkN "surface" ; ----
lin area_1_N = mkN "région" feminine | mkN "surface" ; ----
lin show_VS = mkVS (mkV "montrer") | mkVS (mkV "démontrer") ;
lin show_VQ = mkVQ (mkV "montrer") ;
lin show_V2 = mkV2 "montrer" ;
lin show_V = reflV (mkV "montrer") ;
lin course_N = mkN "cours" masculine | mkN "plat" masculine | mkN "trajectoire" feminine ; --- split senses
lin company_2_N = mkN "société" feminine ;
lin company_1_N = mkN "compagnie" feminine ;
lin under_Prep = S.under_Prep ;
lin problem_N = mkN "problème" masculine ;
lin against_Prep = mkPrep "contre" ;
lin never_Adv = mkAdv "jamais" ;
lin most_Adv = mkAdv "le plus" ;
lin service_N = mkN "service" masculine ;
lin try_VV = deVV (mkV "essayer") ;
lin try_V2 = mkV2 "essayer" ;
lin try_V = mkV "essayer" ;
lin call_V2 = mkV2 "appeler" ;
lin call_V = mkV "appeler" ;
lin hand_N = L.hand_N ;
lin party_N = mkN "parti" masculine ;
lin party_2_N = mkN "parti" masculine ;
lin party_1_N = mkN "fète" ;
lin high_A = mkA "haut" ;
lin about_Adv = mkAdv "environ" ;
lin something_NP = S.something_NP ;
lin school_N = L.school_N ;
lin in_Adv = mkAdv "dedans" ;
lin in_1_Adv = mkAdv "dedans" ;
lin in_2_Adv = mkAdv "dedans" ;
lin small_A = L.small_A ;
lin place_N = mkN "place" feminine | mkN "lieu" masculine ;
lin before_Prep = S.before_Prep ;
lin while_Subj = M.mkSubj ("pendant" ++ Ph.elisQue) ;
lin away_Adv = mkAdv "loin" ; ----
lin away_2_Adv = mkAdv "loin" ; ----
lin away_1_Adv = mkAdv "loin" ; ----
lin keep_VV = aVV (mkV "continuer") ;
lin keep_V2A = mkV2A (mkV "garder") | mkV2A (mkV "conserver") ;
lin keep_V2 = mkV2 "garder" ;
lin keep_V = mkV "rester" ; ----
lin point_N = mkN "point" ;
lin point_2_N = mkN "point" ;
lin point_1_N = mkN "point" ;
lin house_N = L.house_N ;
lin different_A = mkA "différent" ;
lin country_N = L.country_N ;
lin really_Adv = mkAdv "vraiment" ;
lin provide_V2 = mkV2 (mkV "fournir") | mkV2 (mkV I.pourvoir_V2) ;
lin provide_V = mkV "fournir" ; ----
lin week_N = mkN "semaine" feminine ;
lin hold_VS = mkVS (mkV I.tenir_V2) ;
lin hold_V2 = L.hold_V2 ;
lin hold_V = mkV I.tenir_V2 ;
lin large_A = mkA "grand" ;
lin member_N = mkN "membre" masculine ;
lin off_Adv = mkAdv "dehors" ; ----
lin always_Adv = mkAdv "toujours" ;
lin follow_VS = mkVS (mkV I.suivre_V2) ;
lin follow_V2 = I.suivre_V2 ;
lin follow_V = mkV I.suivre_V2 ;
lin without_Prep = S.without_Prep ;
lin turn_VA = mkVA (mkV I.devenir_V) ;
lin turn_V2 = mkV2 "tourner" ;
lin turn_V = L.turn_V ;
lin end_N = mkN "fin" feminine ;
lin end_2_N = mkN "bout" ;
lin end_1_N = mkN "fin" feminine ;
lin within_Prep = mkPrep "dans" ;
lin local_A = mkA "local" ;
lin where_Subj = M.mkSubj "où" ;
lin during_Prep = S.during_Prep ;
lin bring_V3 = mkV3 (mkV "apporter") ;
lin bring_V2 = mkV2 "apporter" ;
lin most_Det = mkDet ("la plupart" ++ Ph.elisDe) ("la plupart" ++ Ph.elisDe) plural ;
lin word_N = mkN "mot" masculine ;
lin begin_V2 = mkV2 (mkV "commencer") ;
lin begin_V = mkV "commencer" ;
lin although_Subj = S.although_Subj ;
lin example_N = mkN "exemple" masculine ;
lin next_Adv = mkAdv "ensuite" ;
lin family_N = mkN "famille" feminine ;
lin rather_Adv = mkAdv "plutôt" ;
lin fact_N = mkN "fait" masculine ;
lin like_VV = mkVV (mkV "aimer") ;
lin like_VS = subjVS (mkV "aimer") ;
lin like_V2 = L.like_V2 ;
lin social_A = mkA "social" ;
lin write_VS = mkVS (mkV I.écrire_V2) ;
lin write_V2 = L.write_V2 ;
lin write_V = mkV L.write_V2 ;
lin state_N = mkN "état" masculine ;
lin state_2_N = mkN "état" masculine ;
lin state_1_N = mkN "état" masculine ;
lin percent_N = mkN "pourcent" masculine ;
lin quite_Adv = S.quite_Adv ;
lin both_Det = mkDet "tous les deux" "toutes les deux" plural ;
lin start_V2 = mkV2 (mkV "commencer") | mkV2 (mkV "démarrer") ;
lin start_V = mkV "commencer" ;
lin run_V2 = mkV2 (mkV "opérer") ; ---- run a program
lin run_V = L.run_V ;
lin long_A = L.long_A ;
lin right_Adv = mkAdv "correctement" ;
lin right_2_Adv = mkAdv "à droite" ;
lin right_1_Adv = mkAdv "correctement" ;
lin set_V2 = mkV2 (mkV I.mettre_V2) ;
lin help_V2V = mkV2V (mkV "aider") P.accusative P.dative ;
lin help_V2 = mkV2 "aider" ;
lin help_V = mkV "aider" ;
lin every_Det = S.every_Det ;
lin home_N = mkN "maison" feminine ;
lin month_N = mkN "mois" masculine ;
lin side_N = mkN "côté" masculine | mkN "face" feminine ;
lin night_N = L.night_N | mkN "soirée" ; ---- split
lin important_A = L.important_A ;
lin eye_N = mkN "oeil" "yeux" masculine | mkN "œil" "yeux" masculine ;
lin head_N = L.head_N ;
lin information_N = mkN "information" | mkN "renseignement" masculine ;
lin question_N = L.question_N ;
lin business_N = mkN "entreprise" feminine | mkN "affaire" feminine ;
lin play_V2 = L.play_V2 ;
lin play_V = L.play_V ;
lin play_3_V2 = mkV2 (mkV "jouer") P.genitive ;
lin play_3_V = mkV "jouer" ;
lin play_2_V2 = mkV2 (mkV "jouer") P.dative ;
lin play_2_V = mkV "jouer" ;
lin play_1_V2 = mkV2 (mkV "jouer") P.dative ;
lin play_1_V = mkV "jouer" ;
lin power_N = mkN "puissance" feminine | mkN "pouvoir" masculine | mkN "électricité" feminine ; --- split
lin money_N = mkN "argent" ;
lin change_N = mkN "changement" masculine | mkN "correspondance" | mkN "monnaie" feminine ; --- split 3
lin move_V2 = I.émouvoir_V2 | mkV2 "déplacer" | mkV2 "déménager" | mkV2 "bouger" ; --- split move emotionally
lin move_V = reflV (mkV "bouger") | mkV "déménager" ;
lin move_2_V = mkV "déménager" ;
lin move_1_V = reflV (mkV I.mouvoir_V2) | reflV (mkV "bouger") ;
lin interest_N = mkN "intérêt" masculine ;
lin interest_4_N = mkN "intérêt" masculine ;
lin interest_2_N = mkN "intérêt" masculine ;
lin interest_1_N = mkN "intérêt" masculine ;
lin order_N = mkN "ordre" masculine | mkN "commande" feminine ; --- split
lin book_N = L.book_N ;
lin often_Adv = mkAdv "souvent" ;
lin development_N = mkN "développement" masculine ;
lin young_A = L.young_A ;
lin national_A = mkA "national" ;
lin pay_V3 = mkV3 (mkV "payer") ;
lin pay_V2V = mkV2V (mkV "payer") ; --- subcat
lin pay_V2 = mkV2 (mkV "payer") ;
lin pay_V = reflV (mkV "payer") ;
lin hear_VS = mkVS (mkV I.entendre_V2) ;
lin hear_V2V = mkV2V (mkV I.entendre_V2) ;
lin hear_V2 = L.hear_V2 ;
lin hear_V = mkV I.entendre_V2 ;
lin room_N = mkN "pièce" feminine | mkN "espace" feminine ;
lin room_1_N = mkN "chambre" | mkN "pièce" ;
lin room_2_N = mkN "place" | mkN "espace" ;
lin whether_Subj = M.mkSubj "si" ; ---- s'il
lin water_N = L.water_N ;
lin form_N = mkN "formulaire" masculine | mkN "forme" feminine ; --- split
lin car_N = L.car_N ;
lin other_N = mkN "autre" masculine ; ---- l'enfer c'est les autres :-)
lin yet_Adv = mkAdv "encore" ;
lin yet_2_Adv = mkAdv "pourtant" ;
lin yet_1_Adv = mkAdv "encore" ;
lin perhaps_Adv = mkAdv "peut-être" ;
lin meet_V2 = I.rejoindre_V2 | mkV2 (mkV "rencontrer") ;
lin meet_V = reflV (mkV I.voir_V2) ;
lin level_N = mkN "niveau" masculine ;
lin level_2_N = mkN "niveau" masculine | mkN "plan" ;
lin level_1_N = mkN "niveau" masculine ;
lin until_Subj = M.mkSubjSubj ("jusqu'à ce" ++ Ph.elisQue) ;
lin though_Subj = M.mkSubjSubj ("bien" + Ph.elisQue) | M.mkSubjSubj ("quoi" + Ph.elisQue) ;
lin policy_N = mkN "politique" feminine ;
lin include_V2 = mkV2 (mkV I.inclure_V2) ;
lin include_V = mkV I.inclure_V2 ;
lin believe_VS = subjVS (mkV I.croire_V2) ; ---- ind/subj
lin believe_V2 = I.croire_V2 ;
lin believe_V = mkV I.croire_V2 ;
lin council_N = mkN "conseil" masculine ;
lin already_Adv = L.already_Adv ;
lin possible_A = mkA "possible" ;
lin nothing_NP = S.nothing_NP ;
lin line_N = mkN "ligne" feminine | mkN "droite" feminine ; --- split
lin allow_V2V = mkV2V (mkV "laisser") | mkV2V (mkV I.permettre_V2) ;
lin allow_V2 = mkV2 (mkV "laisser") | I.permettre_V2 ;
lin need_N = mkN "besoin" masculine ;
lin effect_N = mkN "effet" ;
lin big_A = L.big_A ;
lin use_N = mkN "usage" masculine | mkN "utilité" feminine ; --- split
lin lead_V2V = mkV2V (mkV "diriger") | mkV2V (mkV "mener") | mkV2V (mkV "guider") ;
lin lead_V2 = mkV2 (mkV "diriger") | mkV2 (mkV "mener") ; --- split --- | lead a company
lin lead_V = mkV "diriger" ;
lin stand_V2 = mkV2 "supporter" ;
lin stand_V = L.stand_V | reflV (mkV "lever") ;
lin idea_N = mkN "idée" feminine ;
lin study_N = mkN "étude" feminine ;
lin lot_N = mkN "bande" feminine | mkN "groupe" masculine ;
lin live_V = L.live_V ; --- split
lin job_N = mkN "travail" masculine | mkN "tâche" feminine ; --- split
lin since_Subj = M.mkSubj ("depuis" ++ Ph.elisQue) ;
lin name_N = L.name_N ;
lin result_N = mkN "résultat" masculine ;
lin body_N = mkN "corps" masculine ;
lin happen_VV = aVV (mkV I.advenir_V) ; ---- sense
lin happen_V = mkV "arriver" ;
lin friend_N = L.friend_N ;
lin right_N = mkN "droit" masculine | mkN "droite" feminine ;
lin least_Adv = mkAdv "le moins" ;
lin right_A = mkA "droit" | mkA "correct" ;
lin right_2_A = mkA "droit" ;
lin right_1_A = mkA "correct" ;
lin almost_Adv = mkAdv "quasiment" | mkAdv "presque" ;
lin much_Det = S.much_Det ;
lin carry_V2 = mkV2 (mkV "porter") ;
lin carry_V = mkV "porter" ;
lin authority_N = mkN "autorité" feminine ;
lin authority_2_N = mkN "autorité" feminine ;
lin authority_1_N = mkN "autorité" feminine ;
lin long_Adv = mkAdv "longtemps" ;
lin early_A = mkA "ancien" ; ---- not really A in Fre
lin view_N = mkN "vue" feminine ;
lin view_2_N = mkN "vue" ;
lin view_1_N = mkN "vue" ;
lin public_A = mkA "public" "publique" ;
lin together_Adv = mkAdv "ensemble" ;
lin talk_V2 = mkV2 (mkV "parler") ;
lin talk_V = mkV "parler" ;
lin report_N = mkN "rapport" masculine ;
lin after_Subj = M.mkSubj ("après" ++ Ph.elisQue) ;
lin only_Predet = S.only_Predet ;
lin before_Subj = M.mkSubjSubj ("avant" ++ Ph.elisQue) ; ---- ne in the subord clause
lin bit_N = mkN "morceau" masculine | mkN "bit" masculine ; --- split
lin face_N = mkN "visage" masculine | mkN "face" feminine ;
lin sit_V2 = I.asseoir_V2 ;
lin sit_V = L.sit_V ;
lin market_N = mkN "marché" masculine ;
lin market_1_N = mkN "marché" masculine ;
lin market_2_N = mkN "marché" masculine ;
lin appear_VV = mkVV (mkV "sembler") ;
lin appear_VS = mkVS (mkV "sembler") ;
lin appear_VA = mkVA (mkV "sembler") ;
lin appear_V = I.paraître_V ;
lin continue_VV = aVV (mkV "continuer") ;
lin continue_V2 = mkV2 (mkV "continuer") ;
lin continue_V = mkV "continuer" ;
lin able_A = mkA "capable" ;
lin political_A = mkA "politique" ;
lin later_Adv = mkAdv "plus tard" ;
lin hour_N = mkN "heure" feminine ;
lin rate_N = mkN "taux" | mkN "proportion" feminine ;
lin law_N = mkN "droit" | mkN "loi" feminine ;
lin law_2_N = mkN "droit" ;
lin law_1_N = mkN "loi" feminine ;
lin door_N = L.door_N ;
lin court_N = mkN "cour" feminine ;
lin court_2_N = mkN "cour" feminine ;
lin court_1_N = mkN "cour" feminine ;
lin office_N = mkN "bureau" masculine | mkN "office" masculine ;
lin let_V2V = mkV2V (mkV "laisser") ;
lin war_N = L.war_N ;
lin produce_V2 = mkV2 (mkV I.produire_V2) ;
lin produce_V = mkV I.produire_V2 ;
lin reason_N = L.reason_N ;
lin less_Adv = mkAdv "moins" ;
lin minister_N = mkN "pasteur" | mkN "ministre" masculine ;
lin minister_2_N = mkN "pasteur" ;
lin minister_1_N = mkN "ministre" masculine ;
lin subject_N = mkN "sujet" masculine | mkN "matière" feminine ;
lin subject_2_N = mkN "sujet" ;
lin subject_1_N = mkN "sujet" ;
lin person_N = L.person_N ;
lin term_N = mkN "terme" masculine | mkN "trimestre" masculine | mkN "limite" feminine ; --- split
lin particular_A = mkA "particulier" ;
lin full_A = L.full_A ;
lin involve_VS = mkVS (mkV "impliquer") ;
lin involve_V2 = mkV2 (mkV "impliquer") ;
lin involve_V = mkV "impliquer" ;
lin sort_N = mkN "sorte" | mkN "type" masculine | mkN "triage" masculine | mkN "tri" masculine ;
lin require_VS = subjVS (mkV "demander") ;
lin require_V2V = mkV2V (mkV "exiger") | mkV2V (mkV "demander") ;
lin require_V2 = mkV2 "demander" ;
lin require_V = mkV "demander" ;
lin suggest_VS = subjVS (mkV "proposer") | subjVS (mkV "suggérer") ;
lin suggest_V2 = mkV2 (mkV "proposer") | mkV2 (mkV "suggérer") ;
lin suggest_V = (mkV "proposer") | (mkV "suggérer") ;
lin far_A = mkA "lointain" ;
lin towards_Prep = mkPrep "vers" ;
lin anything_NP = S.mkNP (mkPN "n'importe quoi") ;
lin period_N = mkN "période" feminine | mkN "point" masculine ;
lin period_3_N = mkN "menstruation" feminine ;
lin period_2_N = mkN "point" masculine ;
lin period_1_N = mkN "période" feminine ;
lin consider_VV = deVV (mkV "considérer") ;
lin consider_VS = mkVS (mkV "considérer") ;
lin consider_V3 = mkV3 (mkV "considérer") (mkPrep "comme") | mkV3 (mkV I.prendre_V2) (mkPrep "pour") ;
lin consider_V2V = mkV2V (mkV "considérer") ;
lin consider_V2A = mkV2A (mkV "considérer") ;
lin consider_V2 = mkV2 (mkV "considérer") | mkV2 (mkV "songer") ;
lin consider_V = mkV "considérer" ;
lin read_VS = mkVS L.read_V2 ;
lin read_V2 = L.read_V2 ;
lin read_V = mkV L.read_V2 ;
lin change_V2 = mkV2 (mkV "changer") ;
lin change_V = reflV (mkV "changer") ;
lin society_N = mkN "société" feminine ;
lin process_N = mkN "processus" ;
lin mother_N = mkN "mère" feminine ;
lin offer_VV = deVV I.offrir_V2 ;
lin offer_V2 = I.offrir_V2 ;
lin late_A = mkA "tardif" ; ---- not A in Fre
lin voice_N = mkN "voix" feminine ;
lin both_Adv = mkAdv "tous les deux" ; --- why Adv
lin once_Adv = mkAdv "une fois" ;
lin police_N = mkN "police" feminine | mkN "policier" masculine ; --- split -- | police institution -- | policeman
lin kind_N = mkN "espèce" | mkN "genre" masculine ;
lin lose_V2 = L.lose_V2 ;
lin lose_V = mkV L.lose_V2 ;
lin add_VS = mkVS (mkV "ajouter") ;
lin add_V2 = mkV2 (mkV "ajouter") ;
lin add_V = mkV "additionner" ;
lin probably_Adv = mkAdv "probablement" ;
lin expect_VV = mkVV (reflV (mkV I.attendre_V2)) ;
lin expect_VS = mkVS (reflV (mkV I.attendre_V2)) ;
lin expect_V2V = mkV2V (mkV I.attendre_V2) ;
lin expect_V2 = mkV2 (mkV I.attendre_V2) ;
lin expect_V = mkV I.attendre_V2 ;
lin ever_Adv = mkAdv "jamais" ; --- negative
lin available_A = mkA "disponible" ;
lin price_N = mkN "prix" masculine ;
lin little_A = mkA "petit" ;
lin action_N = mkN "action" feminine ;
lin issue_N = mkN "problème" masculine | mkN "controverse" ;
lin issue_2_N = mkN "numéro" ;
lin issue_1_N = mkN "problème" masculine | mkN "controverse" ;
lin far_Adv = L.far_Adv ;
lin remember_VS = mkVS (reflV (mkV "rappeler")) | mkVS (reflV I.souvenir_V) ;
lin remember_V2 = mkV2 (reflV I.souvenir_V) P.genitive ;
lin remember_V = mkVS (reflV (mkV "rappeler")) | mkVS (reflV I.souvenir_V) ;
lin position_N = mkN "position" feminine ;
lin low_A = mkA "bas" ;
lin cost_N = mkN "coût" masculine ;
lin little_Det = mkDet "peu" ;
lin matter_N = mkN "matière" feminine | mkN "affaire" feminine ;
lin matter_1_N = mkN "matière" feminine ;
lin matter_2_N = mkN "affaire" feminine ;
lin community_N = mkN "communauté" feminine ;
lin remain_VV = deVV (mkV "rester") ;
lin remain_VA = mkVA (mkV "rester") ;
lin remain_V2 = mkV2 (mkV "rester") ;
lin remain_V = mkV "demeurer" | mkV "rester" ;
lin figure_N = mkN "forme" feminine | mkN "personnage" masculine | mkN "figure" feminine ; ---
lin figure_2_N = mkN "chiffre" ;
lin figure_1_N = mkN "figure" ;
lin type_N = mkN "type" masculine | mkN "caractère" masculine ;
lin research_N = mkN "recherche" feminine ;
lin actually_Adv = mkAdv "couramment" ;
lin education_N = mkN "formation" | mkN "éducation" feminine ;
lin fall_V = etreV (mkV "tomber") ;
lin speak_V2 = L.speak_V2 ;
lin speak_V = mkV L.speak_V2 ;
lin few_N = mkN "peu" ; ---- bad cat ? comes from "a few" ? "un peu" is OK in that case
lin today_Adv = L.today_Adv ;
lin enough_Adv = mkAdv "assez" ;
lin open_V2 = L.open_V2 ;
lin open_V = mkV L.open_V2 ;
lin bad_A = L.bad_A ;
lin buy_V2 = L.buy_V2 ;
lin buy_V = mkV L.buy_V2 ;
lin programme_N = mkN "programme" masculine ;
lin minute_N = mkN "minute" feminine | mkN "procès-verbal" masculine ; --- split: five minutes -- | take minutes
lin moment_N = mkN "moment" masculine | mkN "instant" masculine ;
lin girl_N = L.girl_N ;
lin age_N = mkN "âge" masculine | mkN "époque" feminine ; --- split -- | age of five -- | stone age
lin centre_N = mkN "centre" masculine ;
lin stop_VV = mkVV L.stop_V ;
lin stop_V2 = mkV2 (mkV "arrêter") | mkV2 (mkV "cesser") | mkV2 (reflV (mkV "arrêter")) ;
lin stop_V = L.stop_V ;
lin control_N = mkN "contrôle" masculine ;
lin value_N = mkN "valeur" feminine ;
lin send_V2V = mkV2V (mkV I.envoyer_V2) P.accusative P.dative ;
lin send_V2 = I.envoyer_V2 ;
lin send_V = I.envoyer_V2 ;
lin health_N = mkN "santé" feminine ;
lin decide_VV = deVV (mkV "décider") ;
lin decide_VS = mkVS (mkV "décider") ;
lin decide_V2 = mkV2 (mkV "décider") ;
lin decide_V = mkV "décider" ;
lin main_A = mkA "principal" ;
lin win_V2 = L.win_V2 ;
lin win_V = mkV I.vaincre_V2 ;
lin understand_VS = mkVS (mkV L.understand_V2) ;
lin understand_V2 = L.understand_V2 ;
lin understand_V = mkV L.understand_V2 ;
lin decision_N = mkN "décision" feminine ;
lin develop_V2 = mkV2 (mkV "développer") ;
lin develop_V = reflV (mkV "développer") ;
lin class_N = mkN "classe" feminine | mkN "cours" masculine ; --- split -- | upper class -- | history class
lin industry_N = L.industry_N ;
lin receive_V2 = mkV2 (mkV I.recevoir_V2) ;
lin receive_V = mkV I.recevoir_V2 ;
lin back_N = L.back_N ;
lin several_Det = mkDet "plusieurs" "plusieurs" plural ;
lin return_V2 = mkV2 "retourner" | I.rendre_V2 ;
lin return_V = mkV I.revenir_V | mkV "retourner" | mkV "rentrer" ;
lin build_V2 = mkV2 (mkV I.construire_V2) ;
lin build_V = mkV "bâtir" | mkV I.construire_V2 ;
lin spend_V2 = mkV2 (mkV "dépenser") | mkV2 (mkV "passer") ; --- split -- | spend money -- | spend time
lin spend_V = mkV "dépenser" ;
lin force_N = mkN "force" feminine ;
lin condition_N = mkN "condition" ;
lin condition_1_N = mkN "condition" ;
lin condition_2_N = mkN "condition" ;
lin paper_N = L.paper_N ;
lin off_Prep = P.mkPrep ("à part") P.genitive ;
lin major_A = mkA "majeur" ;
lin describe_VS = mkVS (mkV I.décrire_V2) ;
lin describe_V2 = I.décrire_V2 ;
lin agree_VV = deVV (reflV (mkV "accorder")) ; --- ??
lin agree_VS = mkVS (reflV (mkV "accorder")) ; --- ??
lin agree_V = reflV (mkV "accorder") ; --- être d'accord ??
lin economic_A = mkA "économique" ;
lin increase_V2 = mkV2 (mkV "augmenter") ;
lin increase_V = reflV (mkV "augmenter") ;
lin upon_Prep = mkPrep "sur" ;
lin learn_VV = aVV (mkV L.learn_V2) ;
lin learn_VS = mkVS (mkV L.learn_V2) ;
lin learn_V2 = L.learn_V2 ;
lin learn_V = mkV L.learn_V2 ;
lin general_A = mkA "général" ;
lin century_N = mkN "siècle" masculine ;
lin therefore_Adv = mkAdv "donc" ;
lin father_N = mkN "père" masculine ;
lin section_N = mkN "section" ;
lin patient_N = mkN "patient" masculine ;
lin around_Adv = mkAdv "en ronde" ; ----
lin activity_N = mkN "activité" feminine ;
lin road_N = L.road_N ;
lin table_N = L.table_N ;
lin including_Prep = mkPrep "inclus" ; ---- postposition, agreement
lin church_N = L.church_N ;
lin reach_V2 = I.atteindre_V2 ;
lin reach_V = mkV I.atteindre_V2 ;
lin real_A = mkA "vrai" | mkA "réel" ;
lin lie_VS = mkVS (mkV "mentir") ;
lin lie_2_V = mkV "mentir" ;
lin lie_1_V = L.lie_V ;
lin mind_N = mkN "esprit" masculine ;
lin likely_A = mkA "vraisemblable" | mkA "probable" ;
lin among_Prep = mkPrep "parmi" ;
lin team_N = mkN "équipe" feminine ;
lin experience_N = mkN "expérience" feminine ;
lin death_N = mkN "mort" feminine ;
lin soon_Adv = mkAdv "bientôt" ;
lin act_N = mkN "acte" masculine ;
lin sense_N = mkN "sens" masculine ;
lin staff_N = mkN "personnel" masculine | mkN "portée" feminine | mkN "bâton" masculine ; -- tocheck
lin staff_2_N = mkN "bâton" masculine ;
lin staff_1_N = mkN "personnel" masculine ;
lin certain_A = mkA "certain" ; -- tocheck
lin certain_2_A = mkA "certain" ;
lin certain_1_A = mkA "certain" ;
lin studentMasc_N = L.student_N ;
lin half_Predet = M.mkPredet "un moitié" "un moitié" P.genitive True ;
lin half_Predet = M.mkPredet "un moitié" "un moitié" P.genitive True ;
lin around_Prep = mkPrep "environ" ; ---- split: autour de
lin language_N = L.language_N ;
lin walk_V2 = mkV2 (mkV "marcher") ; ---- faire marcher
lin walk_V = L.walk_V ;
lin die_V = L.die_V ;
lin special_A = mkA "spécial" ;
lin difficult_A = mkA "difficile" ;
lin international_A = mkA "international" ;
lin particularly_Adv = mkAdv "particulièrement" ;
lin department_N = mkN "département" masculine | mkN "ministère" masculine ; ---- split
lin management_N = mkN "administration" feminine ;
lin morning_N = mkN "matin" masculine ;
lin draw_V2 = variants{}; -- mkV2V (mkV "tirer") | mkV2V (mkV "dessiner") | mkV2V (mkV "attirer") | mkV2V (mkV "égaliser") | mkV2V (mkV "dégainer") ; -- tocheck
lin draw_1_V2 = mkV2 "dessiner" ;
lin draw_2_V2 = mkV2 "tirer" ;
lin draw_V = mkV "dessiner" ;
lin hope_VV = deVV (mkV "espérer") ;
lin hope_VS = L.hope_VS ;
lin hope_V = mkV (mkV "espérer") ;
lin across_Prep = mkPrep "à travers" P.genitive ; ----
lin plan_N = mkN "plan" masculine ;
lin product_N = mkN "produit" masculine ;
lin city_N = L.city_N ;
lin early_Adv = mkAdv "tôt" ;
lin committee_N = mkN "comité" masculine ;
lin ground_N = mkN "sol" masculine | mkN "base" feminine | mkN "fond" masculine | mkN "terre" feminine ; -- tocheck
lin ground_2_N = mkN "sol" masculine | mkN "terre" feminine ;
lin ground_1_N = mkN "base" feminine | mkN "fond" masculine ;
lin letter_N = variants{} ; -- 
lin letter_2_N = mkN "lettre" feminine ;
lin letter_1_N = mkN "lettre" feminine ;
lin create_V2 = mkV2 (mkV "créer") ;
lin create_V = mkV "créer" ;
lin evidence_N = mkN "preuve" feminine ; -- tocheck
lin evidence_2_N = mkN "évidence" | mkN "preuve" feminine ;
lin evidence_1_N = mkN "évidence" ;
lin foot_N = L.foot_N ;
lin clear_A = mkA "clair" | mkA "libre" | mkA "dégagé" ;
lin boy_N = L.boy_N ;
lin game_N = mkN "jeu" masculine | mkN "gibier" masculine ; -- tocheck
lin game_3_N = mkN "gibier" masculine ;
lin game_2_N = mkN "jeu" ;
lin game_1_N = mkN "jeu" ;
lin food_N = mkN "manger" | mkN "aliment" masculine | mkN "nourriture" feminine ;
lin role_N = mkN "rôle" masculine ;
lin role_2_N = mkN "rôle" masculine ;
lin role_1_N = mkN "rôle" masculine ;
lin practice_N = mkN "pratique" feminine ;
lin bank_N = L.bank_N ;
lin else_Adv = mkAdv "autrement" ;
lin support_N = mkN "soutien" masculine ;
lin sell_V2 = mkV2 (mkV I.vendre_V2) ;
lin sell_V = mkV I.vendre_V2 ;
lin event_N = mkN "événement" masculine ;
lin building_N = mkN "bâtiment" ;
lin range_N = mkN "portée" ;
lin behind_Prep = S.behind_Prep ;
lin sure_A = mkA "sûr" ;
lin report_VS = mkVS (mkV "rapporter") ;
lin report_V2 = mkV2 (mkV "rapporter") ;
lin report_V = mkV "rapporter" ;
lin pass_V = mkV "passer" ;
lin black_A = L.black_A ;
lin stage_N = mkN "scène" feminine | mkN "calèche" feminine | mkN "étape" feminine ; ---- split
lin meeting_N = mkN "réunion" feminine | mkN "rencontre" feminine ; ---- split
lin meeting_N = mkN "réunion" feminine | mkN "rencontre" feminine ; ---- split
lin sometimes_Adv = mkAdv "parfois" ;
lin thus_Adv = mkAdv "ainsi" ;
lin accept_VS = mkVS (mkV "accepter") ;
lin accept_V2 = mkV2 (mkV "accepter") | mkV2 (mkV I.accueillir_V2) ;
lin accept_V = mkV "accepter" ;
lin town_N = mkN "ville" feminine ;
lin art_N = L.art_N ;
lin further_Adv = mkAdv "plus loin" ;
lin club_N = mkN "club" masculine | mkN "club" | mkN "bâton" masculine | mkN "boîte" feminine | mkN "trèfle" masculine ; -- tocheck
lin club_2_N = mkN "bâton" masculine ;
lin club_1_N = mkN "club" masculine ;
lin cause_V2V = mkV2V (mkV "causer") ;
lin cause_V2 = mkV2 (mkV "causer") ;
lin arm_N = mkN "bras" masculine | mkN "arme" feminine ; -- tocheck
lin arm_1_N = mkN "bras" masculine ;
lin arm_2_N = mkN "arme" feminine ;
lin history_N = mkN "histoire" feminine ;
lin parent_N = mkN "parent" masculine ;
lin land_N = mkN "terre" feminine | mkN "pays" masculine ;
lin trade_N = mkN "commerce" masculine ;
lin watch_VS = mkVS (mkV "regarder") ;
lin watch_V2V = mkV2V (mkV "surveiller") | mkV2V (mkV "regarder") ; -- tocheck
lin watch_V2 = L.watch_V2 ;
lin watch_1_V2 = mkV2 (mkV "regarder") ;
lin watch_2_V2 = mkV2 (mkV "surveiller") ;
lin watch_V = mkV L.watch_V2 ;
lin white_A = L.white_A ;
lin situation_N = mkN "situation" feminine ;
lin ago_Adv = mkAdv "il y a" ; ---- should be postpos in Eng
lin teacherMasc_N = L.teacher_N | mkN "enseignant" ;
lin record_N = mkN "enregistrement" masculine | mkN "record" masculine | mkN "disque" masculine ; -- tocheck
lin record_3_N = mkN "record" masculine ;
lin record_2_N = mkN "disque" masculine ;
lin record_1_N = mkN "enregistrement" masculine ;
lin manager_N = mkN "chef" ;
lin relation_N = mkN "relation" feminine ;
lin common_A = mkA "commun" | mkA "ordinaire" ; -- tocheck
lin common_2_A = mkA "ordinaire" ;
lin common_1_A = mkA "commun" ;
lin strong_A = mkA "fort" ;
lin whole_A = mkA "entier" ; ---- up to this checked by AR
lin field_N = mkN "champ" masculine | mkN "corps" masculine | mkN "terrain" masculine ;
lin field_4_N = mkN "corps" masculine ;
lin field_3_N = mkN "terrain" masculine ; ----
lin field_2_N = mkN "terrain" masculine ;
lin field_1_N = mkN "champ" masculine ;
lin free_A = mkA "libre" | mkA "gratuit" ; ---- split: free world, free lunch
lin break_V2 = L.break_V2 ;
lin break_V = mkV L.break_V2 ;
lin yesterday_Adv = mkAdv "hier" ;
lin support_V2 = mkV2 (mkV I.soutenir_V2) ;
lin window_N = L.window_N ;
lin account_N = mkN "compte" masculine ;
lin explain_VS = mkVS (mkV "expliquer") ;
lin explain_V2 = mkV2 (mkV "expliquer") ;
lin stay_VA = mkVA (etreV (mkV "rester")) ;
lin stay_V = etreV (mkV "rester") ;
lin few_Det = S.few_Det ;
lin wait_VV = deVV (reflV (mkV "attendre")) ;
lin wait_V2 = L.wait_V2 ;
lin wait_V = mkV "attendre" ;
lin usually_Adv = mkAdv "habituellement" ;
lin difference_N = mkN "différence" feminine ;
lin material_N = mkN "matériel" masculine ;
lin air_N = mkN "air" masculine ;
lin wife_N = L.wife_N ;
lin cover_V2 = mkV2 (mkV I.couvrir_V2) ;
lin apply_VV = mkVV (mkV "appliquer") | mkVV (reflV (mkV I.inscrire_V2)) ;
lin apply_V2V = mkV2V (mkV "appliquer") ;
lin apply_V2 = mkV2 (mkV "appliquer") ;
lin apply_1_V2 = mkV2 (mkV "appliquer") ;
lin apply_2_V2 = mkV2 (mkV "appliquer") ; ----
lin apply_V = reflV (mkV "appliquer") ; ----
lin project_N = mkN "projet" masculine ;
lin raise_V2 = mkV2 (mkV "lever") ;
lin sale_N = mkN "vente" feminine ;
lin relationship_N = mkN "relation" feminine | mkN "rapport" masculine ;
lin indeed_Adv = mkAdv "effectivement" ;
lin light_N = mkN "lumière" feminine ;
lin claim_VS = mkVS (mkV "affirmer") ;
lin claim_V2 = mkV2 (mkV "revendiquer") ;
lin claim_V = mkV "revendiquer" ;
lin form_V2 = mkV2 (mkV "former") ;
lin form_V = reflV (mkV "former") ;
lin base_V2 = mkV2 (mkV "fonder") | mkV2 (mkV "baser") ;
lin base_V = mkV "fonder" ;
lin care_N = mkN "souci" masculine | mkN "soin" masculine ;
lin someone_NP = S.somebody_NP ;
lin everything_NP = S.everything_NP ;
lin certainly_Adv = mkAdv "certainement" ;
lin rule_N = L.rule_N ;
lin home_Adv = mkAdv "à la maison" ;
lin cut_V2 = L.cut_V2 ;
lin cut_V = mkV L.cut_V2 ;
lin grow_VA = mkVA (mkV I.croître_V) ;
lin grow_V2 = mkV2 (mkV "cultiver") ;
lin grow_V = I.croître_V | mkV "pousser" | mkV "grandir" ;
lin similar_A = mkA "pareil" | mkA "similaire" ;
lin story_N = mkN "histoire" feminine | mkN "étage" masculine ; ---- split
lin quality_N = mkN "qualité" feminine ;
lin tax_N = mkN "impôt" masculine ;
lin worker_N = mkN "ouvrier" masculine ;
lin nature_N = mkN "nature" feminine ;
lin structure_N = mkN "structure" feminine ;
lin data_N = mkN "donnée" feminine ;
lin necessary_A = mkA "nécessaire" ;
lin pound_N = mkN "livre" feminine ;
lin method_N = mkN "méthode" feminine ;
lin unit_N = mkN "unité" feminine ;
lin unit_6_N = mkN "unité" feminine ; ----
lin unit_5_N = mkN "unité" feminine ; ----
lin unit_4_N = mkN "unité" feminine ; ----
lin unit_3_N = mkN "unité" feminine ; ----
lin unit_2_N = mkN "unité" feminine ; ----
lin unit_1_N = mkN "unité" feminine ; ----
lin central_A = mkA "central" ;
lin bed_N = mkN "lit" masculine ;
lin union_N = mkN "union" feminine | mkN "réunion" feminine ;
lin movement_N = mkN "mouvement" masculine ;
lin board_N = mkN "tableau" masculine | mkN "planche" feminine ;
lin board_2_N = mkN "comité" feminine ; ----
lin board_1_N = mkN "tableau" masculine | mkN "planche" feminine ;
lin true_A = mkA "vrai" ;
lin well_Interj = mkInterj "bien" | mkInterj "tiens" ;
lin simply_Adv = mkAdv "simplement" ;
lin contain_V2 = mkV2 (mkV I.contenir_V2) ;
lin especially_Adv = mkAdv "spécialement" ;
lin open_A = mkA "ouvert" ;
lin short_A = L.short_A ;
lin personal_A = mkA "personnel" ;
lin detail_N = mkN "détail" masculine ;
lin model_N = mkN "modèle" masculine | mkN "mannequin" | mkN "maquette" masculine ; ---- split
lin bear_V2 = mkV2 (mkV "porter") | mkV2 (mkV "accoucher") | mkV2 (mkV "supporter") ; ---- split
lin bear_V = mkV "porter" ; ----
lin single_A = mkA "célibataire" ; -- tocheck
lin single_2_A = mkA "célibataire" ;
lin single_1_A = mkA "singulier" ;
lin join_V2 = mkV2 (mkV I.joindre_V2) | mkV2 (mkV I.rejoindre_V2) ;
lin join_V = reflV (mkV I.joindre_V2) ;
lin reduce_V2 = I.réduire_V2 ;
lin reduce_V = mkV "diminuer" | mkV I.réduire_V2 ;
lin establish_V2 = mkV2 (mkV "établir") ;
lin wall_N = mkN "mur" masculine | mkN "paroi" masculine ;
lin face_V2 = mkV2 (mkV "affronter") ;
lin face_V = mkV "affronter" ;
lin easy_A = mkA "facile" ;
lin private_A = mkA "privé" ;
lin computer_N = L.computer_N ;
lin hospital_N = mkN "hôpital" masculine ;
lin chapter_N = mkN "chapitre" masculine ;
lin scheme_N = mkN "schéma" masculine ;
lin theory_N = mkN "théorie" feminine ;
lin choose_VV = deVV (mkV "choisir") ;
lin choose_V2 = mkV2 (mkV "choisir") | mkV2 (mkV "sélectionner") | mkV2 (mkV I.élire_V2) ;
lin wish_VV = deVV (mkV "espérer") ;
lin wish_VS = mkVS (mkV "espérer") | mkVS (mkV "souhaiter") ;
lin wish_V2V = mkV2V (mkV "souhaiter") ;
lin wish_V2 = mkV2 (mkV "souhaiter") ;
lin wish_V = mkV "espérer" ;
lin property_N = mkN "propriété" feminine | mkN "possession" feminine ;
lin property_2_N = mkN "propriété" feminine | mkN "possession" feminine ;
lin property_1_N = mkN "propriété" feminine ;
lin achieve_V2 = mkV2 (mkV "accomplir") ;
lin financial_A = mkA "financier" ;
lin poor_A = mkA "pauvre" | mkA "pitoyable" ;
lin poor_3_A = mkA "pauvre" | mkA "inférieur" ; ----
lin poor_2_A = mkA "pauvre" | mkA "pitoyable" ;
lin poor_1_A = mkA "pauvre" ;
lin officer_N = mkN "officier" masculine | mkN "fonctionnaire" masculine ;
lin officer_3_N = mkN "officier" masculine | mkN "fonctionnaire" masculine ; ----
lin officer_2_N = mkN "fonctionnaire" masculine ;
lin officer_1_N = mkN "officier" masculine ;
lin up_Prep = mkPrep "en haut" ; ----
lin charge_N = mkN "inculpation" feminine | mkN "frais" | mkN "charge" feminine ;
lin charge_2_N = mkN "inculpation" feminine ;
lin charge_1_N = mkN "frais" | mkN "charge" feminine ;
lin director_N = mkN "directeur" masculine ;
lin drive_V2V = mkV2V (mkV I.rendre_V2) | mkV2V (mkV "pousser") | mkV2V (mkV I.conduire_V2) ;
lin drive_V2 = I.conduire_V2 ;
lin drive_V = I.conduire_V2 | mkV "piloter" ; ---- END edits AR
lin deal_V2 = mkV2 (mkV "distribuer") ; -- tocheck
lin deal_V = variants{}; -- mkV2 (mkV "distribuer") ; -- tocheck
lin place_V2 = mkV2 (mkV I.faire_V2) | mkV2 (reflV (mkV "placer")) | mkV2 (mkV I.mettre_V2) ; -- tocheck
lin approach_N = mkN "approche" feminine ; -- tocheck
lin chance_N = mkN "raccroc" masculine | mkN "chance" feminine ; -- tocheck
lin application_N = mkN "application" feminine | mkN "candidature" feminine ; -- tocheck
lin seek_VV = variants{}; -- L.seek_V2 ;
lin seek_V2 = L.seek_V2 ;
lin foreign_A = mkA "étranger" ; -- tocheck
lin foreign_2_A = variants{} ; -- 
lin foreign_1_A = variants{} ; -- 
lin along_Prep = variants{} ; -- 
lin top_N = mkN "toupie" feminine | mkN "couvercle" masculine | mkN "hune" feminine | mkN "dessus" masculine ; -- tocheck
lin amount_N = mkN "montant" masculine | mkN "quantité" feminine ; -- tocheck
lin son_N = mkN "fils" masculine ; -- tocheck
lin operation_N = mkN "opération" feminine ; -- tocheck
lin fail_VV = variants{}; -- mkV2V (mkV "négliger") | mkV2V (mkV "recaler") | mkV2V (mkV "échouer") ; -- tocheck
lin fail_V2 = variants{}; -- mkV2V (mkV "négliger") | mkV2V (mkV "recaler") | mkV2V (mkV "échouer") ; -- tocheck
lin fail_V = variants{}; -- mkV2V (mkV "négliger") | mkV2V (mkV "recaler") | mkV2V (mkV "échouer") ; -- tocheck
lin human_A = mkA "humain" ; -- tocheck
lin opportunity_N = mkN "opportunité" feminine | mkN "occasion" feminine ; -- tocheck
lin simple_A = mkA "simple" ; -- tocheck
lin leader_N = mkN "chef" masculine ; -- tocheck
lin look_N = mkN "regard" masculine | mkN "air" masculine ; -- tocheck
lin share_N = mkN "part" feminine | mkN "action" feminine ; -- tocheck
lin production_N = mkN "production" ; -- tocheck
lin recent_A = mkA "récent" ; -- tocheck
lin firm_N = variants{} ; -- 
lin picture_N = mkN "cinéma" masculine | mkN "photo" feminine | mkN "image" feminine ; -- tocheck
lin source_N = mkN "source" feminine | mkN "source" ; -- tocheck
lin security_N = mkN "titre" masculine | mkN "sécurité" feminine ; -- tocheck
lin serve_V2 = mkV2 (mkV "signifier") | mkV2 (mkV I.servir_V2) ; -- tocheck
lin serve_V = variants{}; -- mkV2 (mkV "signifier") | mkV2 (mkV I.servir_V2) ; -- tocheck
lin according_to_Prep = mkPrep "selon" ;
lin end_V2 = mkV2 (mkV "finir") ; -- tocheck
lin end_V = variants{}; -- mkV2 (mkV "finir") ; -- tocheck
lin contract_N = mkN "contrat" masculine ; -- tocheck
lin wide_A = L.wide_A ;
lin occur_V = mkV (reflV (mkV I.produire_V2)) | mkV (mkV "arriver") | mkV (reflV (mkV "retrouver")) ; -- tocheck
lin agreement_N = mkN "accord" masculine | mkN "contrat" masculine ; -- tocheck
lin better_Adv = mkAdv "mieux" ; -- tocheck
lin kill_V2 = L.kill_V2 ;
lin kill_V = variants{}; -- L.kill_V2 ;
lin act_V2 = mkV2 "agir" ; ---- subcat
lin act_V = mkV "agir" ;
lin site_N = mkN "site" masculine ; -- tocheck
lin either_Adv = variants{} ; -- 
lin labour_N = mkN "accouchement" masculine | mkN "ouvrage" masculine ; -- tocheck
lin plan_VV = variants{}; -- mkV2V (mkV "projeter") ; -- tocheck
lin plan_VS = variants{}; -- mkV2V (mkV "projeter") ; -- tocheck
lin plan_V2V = mkV2V (mkV "projeter") ; -- tocheck
lin plan_V2 = variants{}; -- mkV2V (mkV "projeter") ; -- tocheck
lin plan_V = variants{}; -- mkV2V (mkV "projeter") ; -- tocheck
lin various_A = mkA "divers" ; -- tocheck
lin since_Prep = mkPrep "depuis" | mkPrep "dès" ;
lin test_N = mkN "test" masculine | mkN "épreuve" feminine ; -- tocheck
lin eat_V2 = L.eat_V2 ;
lin eat_V = variants{}; -- L.eat_V2 ;
lin loss_N = mkN "perte" feminine | mkN "défaite" feminine ; -- tocheck
lin close_V2 = L.close_V2 ;
lin close_V = variants{}; -- L.close_V2 ;
lin represent_V2 = mkV2 (mkV "représenter") | mkV2 (mkV "jouer") ; -- tocheck
lin represent_V = variants{}; -- mkV2 (mkV "représenter") | mkV2 (mkV "jouer") ; -- tocheck
lin love_VV = variants{}; -- mkV2V (mkV "aimer") ; -- tocheck
lin love_V2 = L.love_V2 ;
lin colour_N = mkN "couleur" feminine ;
lin clearly_Adv = variants{} ; -- 
lin shop_N = L.shop_N ;
lin benefit_N = mkN "avantage" masculine | mkN "subvention" feminine ; -- tocheck
lin animal_N = L.animal_N ;
lin heart_N = mkN "coeur" | mkN "cœur" ;
lin election_N = mkN "élection" feminine ; -- tocheck
lin purpose_N = mkN "intention" feminine | mkN "but" masculine | mkN "sujet" masculine ; -- tocheck
lin standard_N = mkN "étendard" masculine | mkN "standard" masculine ; -- tocheck
lin due_A = mkA "dû" ; -- tocheck
lin secretary_N = mkN "secrétaire" ; -- tocheck
lin rise_V2 = mkV2 (reflV (mkV "lever")) | mkV2 (mkV "monter") ; -- tocheck
lin rise_V = variants{}; -- mkV2 (reflV (mkV "lever")) | mkV2 (mkV "monter") ; -- tocheck
lin date_N = variants{} ; -- 
lin date_7_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_1_N = variants{} ; -- 
lin hard_A = mkA "dur" | mkA "fort" | mkA "dure" | mkA "irréfutable" ; -- tocheck
lin hard_2_A = variants{} ; -- 
lin hard_1_A = variants{} ; -- 
lin music_N = L.music_N ;
lin hair_N = L.hair_N ;
lin prepare_VV = variants{}; -- mkV2V (mkV "préparer") | mkV2V (reflV (mkV "préparer")) ; -- tocheck
lin prepare_V2V = mkV2V (mkV "préparer") | mkV2V (reflV (mkV "préparer")) ; -- tocheck
lin prepare_V2 = variants{}; -- mkV2V (mkV "préparer") | mkV2V (reflV (mkV "préparer")) ; -- tocheck
lin prepare_V = variants{}; -- mkV2V (mkV "préparer") | mkV2V (reflV (mkV "préparer")) ; -- tocheck
lin factor_N = mkN "facteur" masculine ; -- tocheck
lin other_A = mkA "autre" ;
lin anyone_NP = S.mkNP (mkPN "n'importe qui") ;
lin pattern_N = mkN "patron" masculine | mkN "modèle" feminine ; -- tocheck
lin manage_VV = variants{}; -- mkV2 (mkV "gérer") | mkV2 (mkV I.parvenir_V) | mkV2 (mkV "manier") ; -- tocheck
lin manage_V2 = mkV2 (mkV "gérer") | mkV2 (mkV I.parvenir_V) | mkV2 (mkV "manier") ; -- tocheck
lin manage_V = variants{}; -- mkV2 (mkV "gérer") | mkV2 (mkV I.parvenir_V) | mkV2 (mkV "manier") ; -- tocheck
lin piece_N = mkN "pièce" feminine | mkN "morceau" masculine ; -- tocheck
lin discuss_VS = variants{}; -- mkV2 (mkV "discuter") ; -- tocheck
lin discuss_V2 = mkV2 (mkV "discuter") ; -- tocheck
lin prove_VS = variants{}; -- mkV2V (mkV "prouver") ; -- tocheck
lin prove_VA = variants{}; -- mkV2V (mkV "prouver") ; -- tocheck
lin prove_V2 = variants{}; -- mkV2V (mkV "prouver") ; -- tocheck
lin prove_V = variants{}; -- mkV2V (mkV "prouver") ; -- tocheck
lin front_N = mkN "avant" masculine | mkN "façade" feminine | mkN "front" masculine ; -- tocheck
lin evening_N = mkN "soir" masculine ; -- tocheck
lin royal_A = mkA "royal" ; -- tocheck
lin tree_N = L.tree_N ;
lin population_N = mkN "population" feminine ; -- tocheck
lin fine_A = mkA "bien" | mkA "beau" | mkA "fin" ; -- tocheck
lin plant_N = mkN "matériel" masculine | mkN "végétal" masculine | mkN "plante" feminine ; -- tocheck
lin pressure_N = mkN "pression" feminine ; -- tocheck
lin response_N = mkN "réponse" feminine ; -- tocheck
lin catch_V2 = mkV2 (mkV "attraper") ; -- tocheck
lin street_N = mkN "rue" feminine ; -- tocheck
lin pick_V2 = mkV2 (mkV "choisir") | mkV2 (mkV I.prendre_V2) | mkV2 (mkV I.cueillir_V2) ; -- tocheck
lin pick_V = variants{}; -- mkV2 (mkV "choisir") | mkV2 (mkV I.prendre_V2) | mkV2 (mkV I.cueillir_V2) ; -- tocheck
lin performance_N = mkN "performance" feminine | mkN "représentation" feminine | mkN "exécution" feminine ; -- tocheck
lin performance_2_N = variants{} ; -- 
lin performance_1_N = variants{} ; -- 
lin knowledge_N = mkN "connaissance" feminine | mkN "connaissances" ; -- tocheck
lin despite_Prep = variants{} ; -- 
lin design_N = mkN "design" masculine | mkN "conception" feminine | mkN "dessein" masculine | mkN "modèle" feminine ; -- tocheck
lin page_N = mkN "page" feminine ; -- tocheck
lin enjoy_VV = variants{}; -- mkV2 (mkV "jouir") ; -- tocheck
lin enjoy_V2 = mkV2 (mkV "jouir") ; -- tocheck
lin individual_N = mkN "individu" masculine ; -- tocheck
lin suppose_VS = variants{}; -- mkV2V (mkV "supposer") ; -- tocheck
lin suppose_V2 = variants{}; -- mkV2V (mkV "supposer") ; -- tocheck
lin rest_N = mkN "repos" masculine | mkN "reste" masculine | mkN "paix" feminine ; -- tocheck
lin instead_Adv = variants{} ; -- 
lin wear_V2 = mkV2 (mkV "user") | mkV2 (mkV "porter") ; -- tocheck
lin wear_V = variants{}; -- mkV2 (mkV "user") | mkV2 (mkV "porter") ; -- tocheck
lin basis_N = mkN "base" feminine ; -- tocheck
lin size_N = mkN "taille" feminine ; -- tocheck
lin environment_N = mkN "environnement" masculine ; -- tocheck
lin per_Prep = variants{} ; -- 
lin fire_N = variants{} ; -- 
lin fire_2_N = L.fire_N;
lin fire_1_N = L.fire_N ;
lin series_N = mkN "série" feminine | mkN "suite" feminine ; -- tocheck
lin success_N = mkN "succès" masculine ; -- tocheck
lin natural_A = mkA "normal" | mkA "naturel" ; -- tocheck
lin wrong_A = mkA "immoral" | mkA "impropre" | mkA "faux" ; -- tocheck
lin near_Prep = variants{} ; -- 
lin round_Adv = variants{} ; -- 
lin thought_N = mkN "pensée" feminine | mkN "idée" feminine ; -- tocheck
lin list_N = mkN "liste" feminine ; -- tocheck
lin argue_VS = variants{}; -- mkV2 (mkV "affirmer") | mkV2 (mkV "arguer") ; -- tocheck
lin argue_V2 = mkV2 (mkV "affirmer") | mkV2 (mkV "arguer") ; -- tocheck
lin argue_V = variants{}; -- mkV2 (mkV "affirmer") | mkV2 (mkV "arguer") ; -- tocheck
lin final_A = mkA "dernier" | mkA "final" ; -- tocheck
lin future_N = variants{} ; -- 
lin future_3_N = mkN "futur" ;
lin future_1_N = mkN "avenir" ;
lin introduce_V2 = mkV2 (mkV "présenter") | mkV2 (mkV I.introduire_V2) ; -- tocheck
lin analysis_N = mkN "analyse" feminine ; -- tocheck
lin enter_V2 = mkV2 (mkV "entrer") | mkV2 (mkV "taper") ; -- tocheck
lin enter_V = variants{}; -- mkV2 (mkV "entrer") | mkV2 (mkV "taper") ; -- tocheck
lin space_N = mkN "espace" masculine | mkN "espace" feminine ; -- tocheck
lin arrive_V = variants{}; -- mkV2 (mkV "arriver") | mkV2 (mkV "réussir") ; -- tocheck
lin ensure_VS = variants{}; -- mkV2 (reflV (mkV "assurer")) ; -- tocheck
lin ensure_V2 = mkV2 (reflV (mkV "assurer")) ; -- tocheck
lin ensure_V = variants{}; -- mkV2 (reflV (mkV "assurer")) ; -- tocheck
lin demand_N = mkN "demande" feminine | mkN "demande" | mkN "exige" ; -- tocheck
lin statement_N = mkN "instruction" feminine | mkN "relevé" masculine | mkN "déclaration" feminine ; -- tocheck
lin to_Adv = variants{}; -- S.to_Prep ;
lin attention_N = mkN "attention" | mkN "attention" feminine ; -- tocheck
lin love_N = L.love_N ;
lin principle_N = mkN "principe" masculine ; -- tocheck
lin pull_V2 = L.pull_V2 ;
lin pull_V = variants{}; -- L.pull_V2 ;
lin set_N = mkN "jeu" masculine | mkN "poste" masculine | mkN "set" masculine | mkN "ensemble" masculine | mkN "série" feminine ; -- tocheck
lin set_2_N = variants{} ; -- 
lin set_1_N = variants{} ; -- 
lin doctor_N = mkN "médecin" | mkN "docteur" ; ---- split
lin choice_N = mkN "choix" masculine ; -- tocheck
lin refer_V2 = mkV2 (mkV "référer") ; -- tocheck
lin refer_V = variants{}; -- mkV2 (mkV "référer") ; -- tocheck
lin feature_N = mkN "fonctionnalité" feminine | mkN "caractéristique" feminine | mkN "trait" ; -- tocheck
lin couple_N = mkN "quelques" | mkN "paire" feminine | mkN "couple" masculine ; -- tocheck
lin step_N = mkN "marche" feminine | mkN "pas" | mkN "pas" masculine ; -- tocheck
lin following_A = mkA "suivant" | mkA "favorable" ; -- tocheck
lin thank_V2 = mkV2 (mkV "remercier") ; -- tocheck
lin machine_N = mkN "machine" ; -- tocheck
lin income_N = mkN "revenu" masculine ; -- tocheck
lin training_N = mkN "entraînement" masculine ; -- tocheck
lin present_V2 = mkV2 (mkV "présenter") ;
lin association_N = mkN "association" | mkN "association" feminine ; -- tocheck
lin film_N = mkN "pellicule" feminine | mkN "film" masculine ; -- tocheck
lin film_2_N = variants{} ; -- 
lin film_1_N = variants{} ; -- 
lin region_N = mkN "région" feminine ; -- tocheck
lin effort_N = mkN "effort" ; -- tocheck
lin player_N = mkN "joueur" masculine | mkN "lecteur" masculine ; -- tocheck
lin everyone_NP = variants{} ; -- 
lin present_A = mkA "présent" ;
lin award_N = mkN "prix" masculine ; -- tocheck
lin village_N = L.village_N ;
lin control_V2 = mkV2 (mkV "contrôler") ; -- tocheck
lin organisation_N = variants{} ; -- 
lin whatever_Det = variants{} ; -- 
lin news_N = mkN "nouvelles" | mkN "téléjournal" ; -- tocheck
lin nice_A = mkA "beau" | mkA "bon" ; -- tocheck
lin difficulty_N = mkN "difficulté" feminine ; -- tocheck
lin modern_A = mkA "moderne" ; -- tocheck
lin cell_N = mkN "cellule" feminine | mkN "cellule" | mkN "portable" masculine | mkN "pile" feminine ; -- tocheck
lin close_A = mkA "proche" ; -- tocheck
lin current_A = mkA "courant" | mkA "actuel" ; -- tocheck
lin legal_A = mkA "légal" ; -- tocheck
lin energy_N = mkN "énergie" feminine ; -- tocheck
lin finally_Adv = mkAdv "enfin" | mkAdv "finalement" ;
lin degree_N = variants{} ; -- 
lin degree_3_N = mkN "degré" masculine ; -- tocheck
lin degree_2_N = mkN "diplôme" masculine ; -- tocheck
lin degree_1_N = mkN "degré" masculine ; -- tocheck
lin mile_N = mkN "mille" masculine ; -- tocheck
lin means_N = variants{} ; -- 
lin growth_N = mkN "croissance" feminine ; -- tocheck
lin treatment_N = mkN "traitement" masculine ; -- tocheck
lin sound_N = mkN "sonde" feminine | mkN "son" masculine ; -- tocheck
lin above_Prep = S.above_Prep ;
lin task_N = mkN "corvée" feminine | mkN "tâche" feminine | mkN "tâche" ; -- tocheck
lin provision_N = mkN "provision" feminine ; -- tocheck
lin affect_V2 = mkV2 (mkV "affecter") | mkV2 (mkV I.feindre_V2) ; -- tocheck
lin please_Adv = mkAdv "allez" ; -- tocheck
lin red_A = L.red_A ;
lin happy_A = mkA "satisfait" | mkA "heureux" ; -- tocheck
lin behaviour_N = mkN "comportement" masculine | mkN "comportement" ; -- tocheck
lin concerned_A = variants{} ; -- 
lin point_V2 = mkV2 (mkV "pointer") ; -- tocheck
lin point_V = variants{}; -- mkV2 (mkV "pointer") ; -- tocheck
lin function_N = mkN "fonction" feminine ; -- tocheck
lin identify_V2 = mkV2 (mkV "identifier") ; -- tocheck
lin identify_V = variants{}; -- mkV2 (mkV "identifier") ; -- tocheck
lin resource_N = mkN "ressource" feminine ; -- tocheck
lin defence_N = mkN "défense" feminine ; -- tocheck
lin garden_N = L.garden_N ;
lin floor_N = L.floor_N ;
lin technology_N = mkN "technologie" feminine ; -- tocheck
lin style_N = mkN "modèle" masculine ; -- tocheck
lin feeling_N = mkN "sentiment" masculine | mkN "sentiments" | mkN "épreuve" feminine | mkN "sensation" feminine ; -- tocheck
lin science_N = L.science_N ;
lin relate_V2 = mkV2 (mkV "concerner") ; -- tocheck
lin relate_V = variants{}; -- mkV2 (mkV "concerner") ; -- tocheck
lin doubt_N = mkN "doute" masculine ; -- tocheck
lin horse_N = L.horse_N ;
lin force_VS = variants{}; -- mkV2V (mkV "forcer") ; -- tocheck
lin force_V2V = mkV2V (mkV "forcer") ; -- tocheck
lin force_V2 = variants{}; -- mkV2V (mkV "forcer") ; -- tocheck
lin force_V = variants{}; -- mkV2V (mkV "forcer") ; -- tocheck
lin answer_N = mkN "réponse" feminine | mkN "solution" ; -- tocheck
lin compare_V = variants{}; -- mkV2 (mkV "comparer") ; -- tocheck
lin suffer_V2 = mkV2 (mkV I.souffrir_V2) | mkV2 (mkV "endurer") ; -- tocheck
lin suffer_V = variants{}; -- mkV2 (mkV I.souffrir_V2) | mkV2 (mkV "endurer") ; -- tocheck
lin individual_A = mkA "individuel" ; -- tocheck
lin forward_Adv = variants{} ; -- 
lin announce_VS = variants{}; -- mkV2 (mkV "annoncer") ; -- tocheck
lin announce_V2 = mkV2 (mkV "annoncer") ; -- tocheck
lin userMasc_N = mkN "utulisateur" ;
lin fund_N = mkN "fonds" masculine ; -- tocheck
lin character_2_N = mkN "caractère" masculine ; -- tocheck
lin character_1_N = mkN "personnage" masculine ; -- tocheck
lin risk_N = mkN "risque" masculine ; -- tocheck
lin normal_A = mkA "normal" ; -- tocheck
lin nor_Conj = mkConj "ni" ; -- tocheck
lin dog_N = L.dog_N ;
lin obtain_V2 = mkV2 (mkV I.obtenir_V2) | mkV2 (reflV (mkV "établir")) | mkV2 (mkV I.avoir_V2) | mkV2 (mkV "réussir") ; -- tocheck
lin obtain_V = variants{}; -- mkV2 (mkV I.obtenir_V2) | mkV2 (reflV (mkV "établir")) | mkV2 (mkV I.avoir_V2) | mkV2 (mkV "réussir") ; -- tocheck
lin quickly_Adv = variants{} ; -- 
lin army_N = mkN "armée" feminine ; -- tocheck
lin indicate_VS = variants{}; -- mkV2 (mkV "indiquer") ; -- tocheck
lin indicate_V2 = mkV2 (mkV "indiquer") ; -- tocheck
lin forget_VS = variants{}; -- L.forget_V2 ;
lin forget_V2 = L.forget_V2 ;
lin forget_V = variants{}; -- L.forget_V2 ;
lin station_N = mkN "chaîne" feminine | mkN "station" feminine | mkN "gare" feminine ; -- tocheck
lin glass_N = mkN "verre" masculine ; -- tocheck
lin cup_N = mkN "coupe" feminine | mkN "tasse" feminine | mkN "bonnet" masculine ; -- tocheck
lin previous_A = mkA "préalable" ; -- tocheck
lin husband_N = L.husband_N ;
lin recently_Adv = variants{} ; -- 
lin publish_V2 = mkV2 (mkV "publier") ; -- tocheck
lin publish_V = variants{}; -- mkV2 (mkV "publier") ; -- tocheck
lin serious_A = mkA "sérieux" ; -- tocheck
lin anyway_Adv = mkAdv "en tout cas" ;
lin visit_V2 = variants{}; -- mkV2V (mkV "visiter") ; -- tocheck
lin visit_V = variants{}; -- mkV2V (mkV "visiter") ; -- tocheck
lin capital_N = mkN "capital" masculine | mkN "majuscule" feminine | mkN "chapiteau" ; -- tocheck
lin capital_3_N = variants{} ; -- 
lin capital_2_N = variants{} ; -- 
lin capital_1_N = variants{} ; -- 
lin either_Det = mkDet "chaque" ; -- tocheck
lin note_N = mkN "note" | mkN "note" feminine ; -- tocheck
lin note_3_N = variants{} ; -- 
lin note_2_N = variants{} ; -- 
lin note_1_N = variants{} ; -- 
lin season_N = mkN "saison" | mkN "saison" feminine ; -- tocheck
lin argument_N = mkN "argument" masculine | mkN "argumentation" feminine | mkN "querelle" feminine ; -- tocheck
lin listen_V = mkV (mkV "écouter") ; -- tocheck
lin show_N = mkN "émission" feminine | mkN "démonstration" feminine | mkN "spectacle" masculine | mkN "exposition" feminine ; -- tocheck
lin responsibility_N = mkN "responsabilité" feminine ; -- tocheck
lin significant_A = mkA "significatif" ; -- tocheck
lin deal_N = mkN "contrat" masculine | mkN "part" | mkN "pli" masculine ; -- tocheck
lin prime_A = mkA "principal" | mkA "premier" ; -- tocheck
lin economy_N = mkN "économie" feminine ; -- tocheck
lin economy_2_N = variants{} ; -- 
lin economy_1_N = variants{} ; -- 
lin element_N = mkN "élément" masculine | mkN "membre" masculine ; -- tocheck
lin finish_V2 = mkV2 (mkV "finir") ; -- tocheck
lin finish_V = variants{}; -- mkV2 (mkV "finir") ; -- tocheck
lin duty_N = mkN "devoir" masculine | mkN "travail" masculine | mkN "taxe" feminine ; -- tocheck
lin fight_V2 = L.fight_V2 ;
lin fight_V = variants{}; -- L.fight_V2 ;
lin train_V2V = mkV2V (reflV (mkV "exercer")) | mkV2V (mkV "pointer") | mkV2V (reflV (mkV "entraîner")) | mkV2V (mkV "former") ; -- tocheck
lin train_V2 = variants{}; -- mkV2V (reflV (mkV "exercer")) | mkV2V (mkV "pointer") | mkV2V (reflV (mkV "entraîner")) | mkV2V (mkV "former") ; -- tocheck
lin train_V = variants{}; -- mkV2V (reflV (mkV "exercer")) | mkV2V (mkV "pointer") | mkV2V (reflV (mkV "entraîner")) | mkV2V (mkV "former") ; -- tocheck
lin maintain_VS = variants{}; -- mkV2 (mkV I.entretenir_V2) | mkV2 (mkV I.maintenir_V2) ; -- tocheck
lin maintain_V2 = mkV2 (mkV I.entretenir_V2) | mkV2 (mkV I.maintenir_V2) ; -- tocheck
lin maintain_V = variants{}; -- mkV2 (mkV I.entretenir_V2) | mkV2 (mkV I.maintenir_V2) ; -- tocheck
lin attempt_N = mkN "attentat" masculine | mkN "tentative" feminine ; -- tocheck
lin leg_N = L.leg_N ;
lin investment_N = mkN "investissement" ; -- tocheck
lin save_V2 = mkV2 (mkV "épargner") | mkV2 (mkV "économiser") | mkV2 (mkV "sauver") | mkV2 (mkV "sauvegarder") ; -- tocheck
lin save_V = variants{}; -- mkV2 (mkV "épargner") | mkV2 (mkV "économiser") | mkV2 (mkV "sauver") | mkV2 (mkV "sauvegarder") ; -- tocheck
lin throughout_Prep = variants{} ; -- 
lin design_V2 = variants{} ; -- 
lin design_V = variants{} ; -- 
lin suddenly_Adv = variants{} ; -- 
lin brother_N = mkN "frère" masculine | mkN "pair" masculine ; -- tocheck
lin improve_V2 = mkV2 (mkV "améliorer") ; -- tocheck
lin improve_V = variants{}; -- mkV2 (mkV "améliorer") ; -- tocheck
lin avoid_VV = variants{}; -- mkV2 (mkV "éviter") ; -- tocheck
lin avoid_V2 = mkV2 (mkV "éviter") ; -- tocheck
lin wonder_VQ = L.wonder_VQ ;
lin wonder_V = variants{}; -- mkV2 (reflV (mkV "demander")) ; -- tocheck
lin tend_VV = variants{} ; -- 
lin tend_V2 = variants{} ; -- 
lin title_N = mkN "titre" masculine | mkN "intitulé" masculine ; -- tocheck
lin hotel_N = mkN "hôtel" masculine ; -- tocheck
lin aspect_N = mkN "aspect" masculine ; -- tocheck
lin increase_N = mkN "augmentation" feminine ; -- tocheck
lin help_N = mkN "aide" feminine | mkN "secours" | mkN "auxiliaire" ;
lin industrial_A = mkA "industriel" ; -- tocheck
lin express_V2 = mkV2 (mkV "exprimer") ; -- tocheck
lin summer_N = mkN "été" masculine ; -- tocheck
lin determine_VV = variants{}; -- mkV2V (mkV "déterminer") ; -- tocheck
lin determine_VS = variants{}; -- mkV2V (mkV "déterminer") ; -- tocheck
lin determine_V2V = mkV2V (mkV "déterminer") ; -- tocheck
lin determine_V2 = variants{}; -- mkV2V (mkV "déterminer") ; -- tocheck
lin determine_V = variants{}; -- mkV2V (mkV "déterminer") ; -- tocheck
lin generally_Adv = variants{} ; -- 
lin daughter_N = mkN "fille" feminine ; -- tocheck
lin exist_V = mkV "exister" ;
lin share_V2 = mkV2 (mkV "partager") ; -- tocheck
lin share_V = variants{}; -- mkV2 (mkV "partager") ; -- tocheck
lin baby_N = L.baby_N ;
lin nearly_Adv = variants{} ; -- 
lin smile_V = variants{}; -- mkV2 (mkV I.sourire_V2) ; -- tocheck
lin sorry_A = mkA "désolé" ; -- tocheck
lin sea_N = L.sea_N ;
lin skill_N = mkN "habileté" feminine ; -- tocheck
lin claim_N = mkN "réclamation" feminine | mkN "affirmation" feminine ; -- tocheck
lin treat_V2 = mkV2 (mkV "négocier") | mkV2 (mkV "traiter") ; -- tocheck
lin treat_V = variants{}; -- mkV2 (mkV "négocier") | mkV2 (mkV "traiter") ; -- tocheck
lin remove_V2 = mkV2 (mkV "enlever") ; -- tocheck
lin remove_V = variants{}; -- mkV2 (mkV "enlever") ; -- tocheck
lin concern_N = mkN "importance" | mkN "inquiétude" | mkN "soin" ; -- tocheck
lin university_N = L.university_N ;
lin left_A = mkA "gauche" ; -- tocheck
lin dead_A = mkA "mort" ; -- tocheck
lin discussion_N = mkN "discussion" feminine ; -- tocheck
lin specific_A = mkA "spécifique" ; -- tocheck
lin customerMasc_N = mkN "client" ;
lin box_N = mkN "buis" masculine | mkN "boîte" feminine | mkN "case" feminine | mkN "coquille" feminine | mkN "encadré" masculine | mkN "téloche" feminine | mkN "guérite" feminine ; -- tocheck
lin outside_Prep = variants{} ; -- 
lin state_VS = variants{}; -- mkV2 (mkV "déclarer") ; -- tocheck
lin state_V2 = mkV2 (mkV "déclarer") ; -- tocheck
lin conference_N = mkN "conférence" feminine ; -- tocheck
lin whole_N = mkN "ensemble" masculine ; -- tocheck
lin total_A = mkA "total" | mkA "entier" ; -- tocheck
lin profit_N = mkN "profit" masculine ; -- tocheck
lin division_N = mkN "division" feminine ; -- tocheck
lin division_3_N = variants{} ; -- 
lin division_2_N = variants{} ; -- 
lin division_1_N = variants{} ; -- 
lin throw_V2 = L.throw_V2 ;
lin throw_V = variants{}; -- L.throw_V2 ;
lin procedure_N = mkN "fonction" feminine | mkN "procédé" masculine | mkN "procédure" feminine ; -- tocheck
lin fill_V2 = mkV2 (mkV "remplir") | mkV2 (mkV "combler") ; -- tocheck
lin fill_V = variants{}; -- mkV2 (mkV "remplir") | mkV2 (mkV "combler") ; -- tocheck
lin king_N = L.king_N ;
lin assume_VS = variants{}; -- mkV2 (mkV "adopter") | mkV2 (mkV "supposer") | mkV2 (mkV "assumer") ; -- tocheck
lin assume_V2 = mkV2 (mkV "adopter") | mkV2 (mkV "supposer") | mkV2 (mkV "assumer") ; -- tocheck
lin image_N = mkN "image" feminine ; -- tocheck
lin oil_N = L.oil_N ;
lin obviously_Adv = variants{} ; -- 
lin unless_Subj = variants{} ; -- 
lin appropriate_A = mkA "approprié" ; -- tocheck
lin circumstance_N = mkN "circonstance" feminine ; -- tocheck
lin military_A = mkA "militaire" ; -- tocheck
lin proposal_N = mkN "proposition" ; -- tocheck
lin mention_VS = variants{}; -- mkV2 (mkV "mentionner") ; -- tocheck
lin mention_V2 = mkV2 (mkV "mentionner") ; -- tocheck
lin mention_V = variants{}; -- mkV2 (mkV "mentionner") ; -- tocheck
lin client_N = mkN "client" masculine ; -- tocheck
lin sector_N = mkN "secteur" ; -- tocheck
lin direction_N = variants{} ; -- 
lin admit_VS = variants{}; -- mkV2 (mkV I.admettre_V2) ; -- tocheck
lin admit_V2 = mkV2 (mkV I.admettre_V2) ; -- tocheck
lin admit_V = variants{}; -- mkV2 (mkV I.admettre_V2) ; -- tocheck
lin though_Adv = mkAdv "néanmoins" ; -- tocheck
lin replace_V2 = mkV2 (mkV "remplacer") | mkV2 "remettre" ; ---- split
lin basic_A = mkA "basique" ; -- tocheck
lin hard_Adv = variants{} ; -- 
lin instance_N = variants{} ; -- 
lin sign_N = mkN "symbole" masculine | mkN "signe" masculine ; -- tocheck
lin original_A = mkA "original" ; -- tocheck
lin successful_A = variants{} ; -- 
lin okay_Adv = variants{} ; -- 
lin reflect_V2 = mkV2 (mkV "réfléchir") ; -- tocheck
lin reflect_V = variants{}; -- mkV2 (mkV "réfléchir") ; -- tocheck
lin aware_A = mkA "conscient" ; -- tocheck
lin measure_N = mkN "mesure" | mkN "mesure" feminine ; -- tocheck
lin attitude_N = mkN "posture" ; -- tocheck
lin disease_N = mkN "maladie" feminine ; -- tocheck
lin exactly_Adv = variants{} ; -- 
lin above_Adv = mkAdv "au-dessus" | mkAdv "pair" ; -- tocheck
lin commission_N = mkN "commission" feminine ; -- tocheck
lin intend_VV = variants{}; -- mkV2V (mkV I.prévoir_V2) | mkV2V (mkV "envisager") ; -- tocheck
lin beyond_Prep = variants{} ; -- 
lin seat_N = mkN "assise" feminine | mkN "siège" masculine | mkN "séant" masculine | mkN "siège" ; -- tocheck
lin presidentMasc_N = mkN "président" ;
lin encourage_V2V = mkV2V (mkV "encourager") ; -- tocheck
lin encourage_V2 = variants{}; -- mkV2V (mkV "encourager") ; -- tocheck
lin addition_N = mkN "addition" feminine ; -- tocheck
lin goal_N = mkN "but" masculine | mkN "objectif" masculine ; -- tocheck
lin round_Prep = variants{} ; -- 
lin miss_V2 = mkV2 (mkV "manquer") | mkV2 (mkV "rater") | mkV2 (mkV "languir") ; -- tocheck
lin miss_V = variants{}; -- mkV2 (mkV "manquer") | mkV2 (mkV "rater") | mkV2 (mkV "languir") ; -- tocheck
lin popular_A = mkA "populaire" ; -- tocheck
lin affair_N = mkN "aventure" feminine ; -- tocheck
lin technique_N = mkN "technique" feminine ; -- tocheck
lin respect_N = mkN "respect" masculine | mkN "tolérance" feminine ; -- tocheck
lin drop_V2 = mkV2 (mkV "tomber") ; -- tocheck
lin drop_V = variants{}; -- mkV2 (mkV "tomber") ; -- tocheck
lin professional_A = mkA "professionnel" ; -- tocheck
lin less_Det = variants{} ; -- 
lin once_Subj = variants{} ; -- 
lin item_N = mkN "truc" masculine | mkN "point" masculine ; -- tocheck
lin fly_V2 = mkV2 (mkV "voler") ; -- tocheck
lin fly_V = L.fly_V ;
lin reveal_VS = variants{}; -- mkV2 (mkV "révéler") ; -- tocheck
lin reveal_V2 = mkV2 (mkV "révéler") ; -- tocheck
lin version_N = mkN "version" feminine ; -- tocheck
lin maybe_Adv = mkAdv "peut-être" ; -- tocheck
lin ability_N = mkN "habileté" feminine | mkN "capacité" feminine ; -- tocheck
lin operate_V2 = mkV2 (mkV "opérer") ; -- tocheck
lin operate_V = variants{}; -- mkV2 (mkV "opérer") ; -- tocheck
lin good_N = mkN "bien" masculine | mkN "bon" masculine ; -- tocheck
lin campaign_N = mkN "campagne" feminine ; -- tocheck
lin heavy_A = L.heavy_A ;
lin advice_N = mkN "conseil" masculine ; -- tocheck
lin institution_N = mkN "institution" ; -- tocheck
lin discover_VS = variants{}; -- mkV2V (mkV I.découvrir_V2) ; -- tocheck
lin discover_V2 = variants{}; -- mkV2V (mkV I.découvrir_V2) ; -- tocheck
lin discover_V = variants{}; -- mkV2V (mkV I.découvrir_V2) ; -- tocheck
lin surface_N = mkN "surface" feminine ; -- tocheck
lin library_N = mkN "bibliothèque" feminine ; -- tocheck
lin pupil_N = mkN "élève" | mkN "pupille" feminine ; -- tocheck
lin record_V2 = mkV2 (mkV "enregistrer") ; -- tocheck
lin refuse_VV = variants{}; -- mkV2 (mkV "refuser") ; -- tocheck
lin refuse_V2 = mkV2 (mkV "refuser") ; -- tocheck
lin refuse_V = variants{}; -- mkV2 (mkV "refuser") ; -- tocheck
lin prevent_V2 = mkV2 (mkV "empêcher") ; -- tocheck
lin advantage_N = mkN "avantage" masculine ; -- tocheck
lin dark_A = mkA "obscur" | mkA "foncé" | mkA "sombre" ; -- tocheck
lin teach_V2V = mkV2V (mkV "guider") | mkV2V (mkV "enseigner") ; -- tocheck
lin teach_V2 = L.teach_V2 ;
lin teach_V = variants{}; -- L.teach_V2 ;
lin memory_N = mkN "mémoire" feminine | mkN "souvenir" masculine ; -- tocheck
lin culture_N = mkN "culture" feminine ; -- tocheck
lin blood_N = L.blood_N ;
lin cost_V2 = mkV2 (mkV "coûter") | I.valoir_V2 ; ---- sense valoir be worth
lin cost_V = mkV "coûter" ;
lin majority_N = mkN "majorité" | mkN "majorité" feminine ; -- tocheck
lin answer_V2 = mkV2 (mkV I.répondre_V2) ; -- tocheck
lin answer_V = variants{}; -- mkV2 (mkV I.répondre_V2) ; -- tocheck
lin variety_N = mkN "variété" feminine ; -- tocheck
lin variety_2_N = variants{} ; -- 
lin variety_1_N = variants{} ; -- 
lin press_N = mkN "pressoir" masculine | mkN "presse" feminine | mkN "imprimerie" ; -- tocheck
lin depend_V = mkV (mkV I.pendre_V2) | mkV (mkV I.dépendre_V2) ; -- tocheck
lin bill_N = mkN "tract" masculine | mkN "facture" feminine | mkN "bec" masculine | mkN "hallebarde" feminine | mkN "greffe" masculine | mkN "note" feminine | mkN "hallebardier" masculine ; -- tocheck
lin competition_N = mkN "concours" masculine | mkN "compétition" feminine ; -- tocheck
lin ready_A = mkA "prêt" ; -- tocheck
lin general_N = mkN "général" masculine ; -- tocheck
lin access_N = mkN "approche" | mkN "accès" masculine ; -- tocheck
lin hit_V2 = L.hit_V2 ;
lin hit_V = variants{}; -- L.hit_V2 ;
lin stone_N = L.stone_N ;
lin useful_A = mkA "utile" ; -- tocheck
lin extent_N = mkN "étendue" | mkN "mesure" feminine ; -- tocheck
lin employment_N = mkN "emploi" masculine | mkN "travail" masculine ; -- tocheck
lin regard_V2 = mkV2 "regarder" ;
lin regard_V = mkV "regarder" ;
lin apart_Adv = mkAdv "séparé" ; -- tocheck
lin present_N = mkN "cadeau" ;
lin appeal_N = mkN "appel" masculine | mkN "attrait" masculine ; -- tocheck
lin text_N = mkN "texte" masculine | mkN "texto" masculine ; -- tocheck
lin parliament_N = mkN "parlement" masculine ; -- tocheck
lin cause_N = mkN "cause" feminine ; -- tocheck
lin terms_N = variants{} ; -- 
lin bar_N = mkN "barre" feminine | mkN "bar" masculine | mkN "comptoir" masculine | mkN "mesure" feminine ; -- tocheck
lin bar_2_N = mkN "barre" ;
lin bar_1_N = mkN "bar" ;
lin attack_N = mkN "attaque" | mkN "attaque" feminine ; -- tocheck
lin effective_A = mkA "efficace" ; -- tocheck
lin mouth_N = L.mouth_N ;
lin down_Prep = variants{} ; -- 
lin result_V = mkV (mkV "résulter") ; -- tocheck
lin fish_N = L.fish_N ;
lin future_A = mkA "futur" ; -- tocheck
lin visit_N = mkN "consultation" feminine | mkN "visite" feminine ; -- tocheck
lin little_Adv = variants{} ; -- 
lin easily_Adv = variants{} ; -- 
lin attempt_VV = variants{}; -- mkV2 (mkV "tenter") ; -- tocheck
lin attempt_V2 = mkV2 (mkV "tenter") ; -- tocheck
lin enable_VS = variants{}; -- mkV2V (mkV "activer") | mkV2V (mkV I.permettre_V2) ; -- tocheck
lin enable_V2V = mkV2V (mkV "activer") | mkV2V (mkV I.permettre_V2) ; -- tocheck
lin enable_V2 = variants{}; -- mkV2V (mkV "activer") | mkV2V (mkV I.permettre_V2) ; -- tocheck
lin trouble_N = mkN "peine" feminine ; -- tocheck
lin traditional_A = mkA "traditionnel" ; -- tocheck
lin payment_N = mkN "paiement" masculine ; -- tocheck
lin best_Adv = variants{} ; -- 
lin post_N = mkN "message" masculine | mkN "courrier" | mkN "poteau" masculine ; -- tocheck
lin county_N = mkN "comté" | mkN "comté" masculine ; -- tocheck
lin lady_N = mkN "dame" feminine | mkN "madame" "mesdames" feminine ;
lin holiday_N = mkN "fête" feminine | mkN "vacances" | mkN "congé" masculine | mkN "vacance" feminine ; -- tocheck
lin realize_VS = variants{}; -- mkV2 (mkV "réaliser") ; -- tocheck
lin realize_V2 = mkV2 (mkV "réaliser") ; -- tocheck
lin importance_N = mkN "importance" feminine ; -- tocheck
lin chair_N = L.chair_N ;
lin facility_N = mkN "facilité" feminine | mkN "infrastructure" feminine ; -- tocheck
lin complete_V2 = mkV2 (mkV "accomplir") | mkV2 (mkV "compléter") ; -- tocheck
lin complete_V = variants{}; -- mkV2 (mkV "accomplir") | mkV2 (mkV "compléter") ; -- tocheck
lin article_N = mkN "article" masculine ; -- tocheck
lin object_N = mkN "objet" masculine ; -- tocheck
lin context_N = mkN "contexte" masculine ; -- tocheck
lin survey_N = mkN "enquête" feminine | mkN "reconnaissance" feminine | mkN "arpentage" masculine ; -- tocheck
lin notice_VS = variants{}; -- mkV2 (mkV "remarquer") | mkV2 (reflV (mkV I.apercevoir_V2)) ; -- tocheck
lin notice_V2 = mkV2 (mkV "remarquer") | mkV2 (reflV (mkV I.apercevoir_V2)) ; -- tocheck
lin complete_A = mkA "complète" | mkA "complet" ; -- tocheck
lin turn_N = mkN "tour" masculine ; -- tocheck
lin direct_A = mkA "direct" ; -- tocheck
lin immediately_Adv = variants{} ; -- 
lin collection_N = mkN "collection" | mkN "collection" feminine ; -- tocheck
lin reference_N = mkN "référence" feminine | mkN "recommandation" feminine ; -- tocheck
lin card_N = mkN "carte" feminine | mkN "carde" feminine ; -- tocheck
lin interesting_A = mkA "intéressant" ; -- tocheck
lin considerable_A = variants{} ; -- 
lin television_N = L.television_N ;
lin extend_V2 = mkV2 (mkV "prolonger") ; -- tocheck
lin extend_V = variants{}; -- mkV2 (mkV "prolonger") ; -- tocheck
lin communication_N = mkN "communication" feminine ; -- tocheck
lin agency_N = mkN "agence" feminine ; -- tocheck
lin physical_A = mkA "physiologique" | mkA "physique" ; -- tocheck
lin except_Conj = variants{} ; -- 
lin check_V2 = mkV2 (mkV "checker") | mkV2 (mkV "contrôler") | mkV2 (mkV "vérifier") | mkV2 (mkV "laisser") | mkV2 (mkV "enregistrer") | mkV2 (mkV "cocher") ; -- tocheck
lin check_V = variants{}; -- mkV2 (mkV "checker") | mkV2 (mkV "contrôler") | mkV2 (mkV "vérifier") | mkV2 (mkV "laisser") | mkV2 (mkV "enregistrer") | mkV2 (mkV "cocher") ; -- tocheck
lin sun_N = L.sun_N ;
lin species_N = mkN "espèce" feminine ; -- tocheck
lin possibility_N = mkN "possibilité" feminine ; -- tocheck
lin officialMasc_N = mkN "fonctionnaire" ;
lin chairman_N = variants{} ; -- 
lin speaker_N = mkN "baffle" | mkN "orateur" masculine | mkN "président" masculine | mkN "parleur" masculine ; -- tocheck
lin second_N = mkN "seconde" feminine ; -- tocheck
lin career_N = mkN "carrière" feminine ; -- tocheck
lin laugh_VS = variants{}; -- mkV2 (mkV I.rire_V2) ; -- tocheck
lin laugh_V2 = mkV2 (mkV I.rire_V2) ; -- tocheck
lin laugh_V = L.laugh_V ;
lin weight_N = mkN "poids" | mkN "masse" | mkN "poids" masculine ; -- tocheck
lin sound_VS = variants{}; -- mkV2 (mkV "exprimer") | mkV2 (mkV "sonder") | mkV2 (mkV "sonner") | mkV2 (mkV "prononcer") | mkV2 (mkV "tester") ; -- tocheck
lin sound_VA = variants{}; -- mkV2 (mkV "exprimer") | mkV2 (mkV "sonder") | mkV2 (mkV "sonner") | mkV2 (mkV "prononcer") | mkV2 (mkV "tester") ; -- tocheck
lin sound_V2 = mkV2 (mkV "exprimer") | mkV2 (mkV "sonder") | mkV2 (mkV "sonner") | mkV2 (mkV "prononcer") | mkV2 (mkV "tester") ; -- tocheck
lin sound_V = variants{}; -- mkV2 (mkV "exprimer") | mkV2 (mkV "sonder") | mkV2 (mkV "sonner") | mkV2 (mkV "prononcer") | mkV2 (mkV "tester") ; -- tocheck
lin responsible_A = mkA "responsable" ; -- tocheck
lin base_N = mkN "base" feminine | mkN "base" ; -- tocheck
lin document_N = mkN "document" masculine ; -- tocheck
lin solution_N = mkN "solution" feminine ; -- tocheck
lin return_N = mkN "retour" masculine ; -- tocheck
lin medical_A = mkA "médical" ; -- tocheck
lin hot_A = L.hot_A ;
lin recognize_VS = variants{} ; -- 
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin talk_N = mkN "conversation" feminine | mkN "conférence" feminine | mkN "discours" masculine ; -- tocheck
lin budget_N = mkN "budget" masculine ; -- tocheck
lin river_N = L.river_N ;
lin fit_V2 = mkV2 (mkV I.convenir_V2) | mkV2 (mkV "ajuster") ; -- tocheck
lin fit_V = variants{}; -- mkV2 (mkV I.convenir_V2) | mkV2 (mkV "ajuster") ; -- tocheck
lin organization_N = mkN "organisation" feminine ; -- tocheck
lin existing_A = variants{} ; -- 
lin start_N = mkN "départ" masculine ; -- tocheck
lin push_VS = variants{}; -- L.push_V2 ;
lin push_V2V = mkV2V (mkV "pousser") ; -- tocheck
lin push_V2 = L.push_V2 ;
lin push_V = variants{}; -- L.push_V2 ;
lin tomorrow_Adv = mkAdv "demain" ; -- tocheck
lin requirement_N = mkN "exigence" feminine | mkN "demande" ; -- tocheck
lin cold_A = L.cold_A ;
lin edge_N = mkN "bord" masculine | mkN "côté" masculine | mkN "arête" feminine | mkN "carre" feminine ; -- tocheck
lin opposition_N = mkN "opposition" feminine ; -- tocheck
lin opinion_N = mkN "avis" masculine ; -- tocheck
lin drug_N = mkN "drogue" feminine ; -- tocheck
lin quarter_N = mkN "quart" masculine | mkN "quartier" masculine | mkN "trimestre" masculine ; -- tocheck
lin option_N = mkN "choix" masculine ; -- tocheck
lin sign_V2 = variants{}; -- mkV2V (mkV "signer") ; -- tocheck
lin sign_V = variants{}; -- mkV2V (mkV "signer") ; -- tocheck
lin worth_Prep = variants{} ; -- 
lin call_N = mkN "appel" | mkN "chant" masculine | mkN "appel" masculine | mkN "visite" feminine ; -- tocheck
lin define_V2 = mkV2 (mkV "définir") | mkV2 (mkV "déterminer") ; -- tocheck
lin define_V = variants{}; -- mkV2 (mkV "définir") | mkV2 (mkV "déterminer") ; -- tocheck
lin stock_N = mkN "action" feminine | mkN "matthiole" feminine | mkN "pioche" feminine | mkN "stock" masculine | mkN "réserve" feminine ; -- tocheck
lin influence_N = mkN "influence" ; -- tocheck
lin occasion_N = mkN "occasion" feminine ; -- tocheck
lin eventually_Adv = variants{} ; -- 
lin software_N = mkN "logiciel" masculine ;
lin highly_Adv = variants{} ; -- 
lin exchange_N = mkN "échange" masculine | mkN "bourse" feminine ; -- tocheck
lin lack_N = mkN "manque" masculine ; -- tocheck
lin shake_V2 = mkV2 (mkV "secouer") | mkV2 (reflV (mkV "secouer")) ; -- tocheck
lin shake_V = variants{}; -- mkV2 (mkV "secouer") | mkV2 (reflV (mkV "secouer")) ; -- tocheck
lin study_V2 = mkV2 (mkV "étudier") ; -- tocheck
lin study_V = variants{}; -- mkV2 (mkV "étudier") ; -- tocheck
lin concept_N = mkN "concept" masculine ; -- tocheck
lin blue_A = L.blue_A ;
lin star_N = L.star_N ;
lin radio_N = L.radio_N ;
lin arrangement_N = mkN "arrangement" masculine ; -- tocheck
lin examine_V2 = mkV2 (mkV "examiner") ; -- tocheck
lin bird_N = L.bird_N ;
lin green_A = L.green_A ;
lin band_N = mkN "groupe" feminine ; -- tocheck
lin sex_N = mkN "sexe" masculine ; -- tocheck
lin finger_N = mkN "doigt" masculine ; -- tocheck
lin past_N = mkN "passé" masculine ; -- tocheck
lin independent_A = mkA "indépendant" ; -- tocheck
lin independent_2_A = variants{} ; -- 
lin independent_1_A = variants{} ; -- 
lin equipment_N = mkN "équipement" masculine ; -- tocheck
lin north_N = mkN "nord" masculine ; -- tocheck
lin mind_VS = variants{} ; -- 
lin mind_V2 = variants{} ; -- 
lin mind_V = variants{} ; -- 
lin move_N = mkN "coup" masculine | mkN "déménagement" masculine ; -- tocheck
lin message_N = mkN "message" masculine ; -- tocheck
lin fear_N = mkN "crainte" feminine | mkN "peur" feminine ; -- tocheck
lin afternoon_N = mkN "après-midi" ; -- tocheck
lin drink_V2 = L.drink_V2 ;
lin drink_V = variants{}; -- L.drink_V2 ;
lin fully_Adv = variants{} ; -- 
lin race_N = mkN "course" feminine | mkN "race" feminine ; -- tocheck
lin race_2_N = variants{} ; -- 
lin race_1_N = variants{} ; -- 
lin gain_V2 = mkV2 (mkV "gagner") ; -- tocheck
lin gain_V = variants{}; -- mkV2 (mkV "gagner") ; -- tocheck
lin strategy_N = mkN "stratégie" feminine ; -- tocheck
lin extra_A = variants{} ; -- 
lin scene_N = mkN "scène" feminine ; -- tocheck
lin slightly_Adv = variants{} ; -- 
lin kitchen_N = mkN "cuisine" feminine ; -- tocheck
lin speech_N = mkN "discours" masculine | mkN "parole" feminine ; -- tocheck
lin arise_V = mkV (mkV "surgir") ; -- tocheck
lin network_N = mkN "réseau" masculine | mkN "tissus" masculine ; -- tocheck
lin tea_N = mkN "thé" masculine | mkN "tisane" feminine | mkN "goûter" masculine ; -- tocheck
lin peace_N = L.peace_N ;
lin failure_N = mkN "échec" masculine | mkN "raté" masculine | mkN "panne" feminine ; -- tocheck
lin employee_N = mkN "employé" masculine ; -- tocheck
lin ahead_Adv = variants{} ; -- 
lin scale_N = mkN "échelle" feminine | mkN "écaille" feminine | mkN "balance" feminine | mkN "squame" feminine | mkN "barbure" feminine | mkN "échelle" ; -- tocheck
lin hardly_Adv = variants{} ; -- 
lin attend_V2 = mkV2 (mkV "assister") ; -- tocheck
lin attend_V = variants{}; -- mkV2 (mkV "assister") ; -- tocheck
lin shoulder_N = mkN "épaule" feminine ; -- tocheck
lin otherwise_Adv = mkAdv "autrement" | mkAdv "sinon" ; -- tocheck
lin railway_N = variants{} ; -- 
lin directly_Adv = variants{} ; -- 
lin supply_N = mkN "approvisionnement" ; -- tocheck
lin expression_N = mkN "expression" feminine ; -- tocheck
lin owner_N = mkN "propriétaire" masculine ; -- tocheck
lin associate_V2 = mkV2 (mkV "associer") ; -- tocheck
lin associate_V = variants{}; -- mkV2 (mkV "associer") ; -- tocheck
lin corner_N = mkN "coin" masculine ; -- tocheck
lin past_A = mkA "passé" | mkA "dernier" ; -- tocheck
lin match_N = mkN "allumette" feminine | mkN "match" masculine ; -- tocheck
lin match_3_N = variants{} ; -- 
lin match_2_N = variants{} ; -- 
lin match_1_N = variants{} ; -- 
lin sport_N = mkN "flirt" | mkN "sport" masculine ; -- tocheck
lin status_N = mkN "statut" masculine ; -- tocheck
lin beautiful_A = L.beautiful_A ;
lin offer_N = mkN "offre" feminine | mkN "offre" ; -- tocheck
lin marriage_N = mkN "mariage" masculine ; -- tocheck
lin hang_V2 = mkV2 (mkV I.pendre_V2) | mkV2 (mkV "rôder") | mkV2 (mkV "orner") | mkV2 (mkV "exposer") | mkV2 (mkV "peser") | mkV2 (mkV "baisser") | mkV2 (mkV "accrocher") ; -- tocheck
lin hang_V = variants{}; -- mkV2 (mkV I.pendre_V2) | mkV2 (mkV "rôder") | mkV2 (mkV "orner") | mkV2 (mkV "exposer") | mkV2 (mkV "peser") | mkV2 (mkV "baisser") | mkV2 (mkV "accrocher") ; -- tocheck
lin civil_A = mkA "civil" ; -- tocheck
lin perform_V2 = variants{} ; -- 
lin perform_V = variants{} ; -- 
lin sentence_N = mkN "phrase" feminine | mkN "peine" feminine | mkN "jugement" masculine ; -- tocheck
lin crime_N = mkN "crime" | mkN "crime" masculine ; -- tocheck
lin ball_N = mkN "balle" feminine | mkN "bal" masculine | mkN "boule" feminine | mkN "pelote" feminine | mkN "couille" ; -- tocheck
lin marry_V2 = mkV2 (mkV "marier") | mkV2 (reflV (mkV "marier")) ; -- tocheck
lin marry_V = variants{}; -- mkV2 (mkV "marier") | mkV2 (reflV (mkV "marier")) ; -- tocheck
lin wind_N = L.wind_N ;
lin truth_N = mkN "vérité" feminine | mkN "vérité" ; -- tocheck
lin protect_V2 = mkV2 (mkV "protéger") ; -- tocheck
lin protect_V = variants{}; -- mkV2 (mkV "protéger") ; -- tocheck
lin safety_N = mkN "sécurité" feminine | mkN "sûreté" feminine ; -- tocheck
lin partner_N = mkN "partenaire" masculine ; -- tocheck
lin completely_Adv = variants{} ; -- 
lin copy_N = mkN "copie" feminine ; -- tocheck
lin balance_N = mkN "balance" feminine | mkN "équilibre" masculine | mkN "solde" masculine ; -- tocheck
lin sister_N = L.sister_N ;
lin reader_N = mkN "lecteur" masculine ; -- tocheck
lin below_Adv = mkAdv "ci-dessous" ; -- tocheck
lin trial_N = mkN "procès" masculine | mkN "essai" masculine | mkN "épreuve" feminine ; -- tocheck
lin rock_N = L.rock_N ;
lin damage_N = mkN "dégât" masculine ; -- tocheck
lin adopt_V2 = mkV2 (mkV "adopter") ; -- tocheck
lin newspaper_N = L.newspaper_N ;
lin meaning_N = mkN "sens" masculine | mkN "signification" feminine ; -- tocheck
lin light_A = mkA "lumineux" | mkA "léger" | mkA "clair" ; -- tocheck
lin essential_A = mkA "essentiel" | mkA "indispensable" ; -- tocheck
lin obvious_A = mkA "évident" ; -- tocheck
lin nation_N = mkN "nation" feminine ; -- tocheck
lin confirm_VS = variants{}; -- mkV2 (mkV "confirmer") ; -- tocheck
lin confirm_V2 = mkV2 (mkV "confirmer") ; -- tocheck
lin south_N = mkN "sud" masculine ; -- tocheck
lin length_N = mkN "longueur" feminine ; -- tocheck
lin branch_N = mkN "branche" feminine | mkN "filiale" feminine ; -- tocheck
lin deep_A = mkA "profond" | mkA "foncé" | mkA "grave" | mkA "épais" ; -- tocheck
lin none_NP = variants{} ; -- 
lin planning_N = variants{} ; -- 
lin trust_N = mkN "confiance" feminine ; -- tocheck
lin working_A = variants{} ; -- 
lin pain_N = mkN "casse-pied" | mkN "douleur" feminine ; -- tocheck
lin studio_N = mkN "studio" masculine ; -- tocheck
lin positive_A = mkA "positif" ; -- tocheck
lin spirit_N = mkN "spiritueux" | mkN "esprit" masculine | mkN "élan" masculine ; -- tocheck
lin college_N = variants{} ; -- 
lin accident_N = mkN "accident" masculine ; -- tocheck
lin star_V2 = variants{} ; -- 
lin hope_N = mkN "espoir" masculine ; -- tocheck
lin mark_V3 = mkV3 (mkV "tacher") | mkV3 (mkV "corriger") | mkV3 (mkV "marquer") | mkV3 (mkV "noter") ; -- tocheck
lin mark_V2 = variants{}; -- mkV3 (mkV "tacher") | mkV3 (mkV "corriger") | mkV3 (mkV "marquer") | mkV3 (mkV "noter") ; -- tocheck
lin works_N = variants{} ; -- 
lin league_N = mkN "lieue" feminine | mkN "ligue" feminine ; -- tocheck
lin league_2_N = variants{} ; -- 
lin league_1_N = variants{} ; -- 
lin clear_V2 = variants{}; -- mkV2V (mkV "débarrasser") | mkV2V (reflV (mkV "éclaircir")) | mkV2V (mkV "clarifier") ; -- tocheck
lin clear_V = variants{}; -- mkV2V (mkV "débarrasser") | mkV2V (reflV (mkV "éclaircir")) | mkV2V (mkV "clarifier") ; -- tocheck
lin imagine_VS = variants{}; -- mkV2 (mkV "imaginer") ; -- tocheck
lin imagine_V2 = mkV2 (mkV "imaginer") ; -- tocheck
lin imagine_V = variants{}; -- mkV2 (mkV "imaginer") ; -- tocheck
lin through_Adv = variants{}; -- S.through_Prep ;
lin cash_N = mkN "espèces" ; -- tocheck
lin normally_Adv = variants{} ; -- 
lin play_N = mkN "jeu" masculine ; -- tocheck
lin strength_N = mkN "force" feminine ; -- tocheck
lin train_N = L.train_N ;
lin travel_V2 = mkV2 (mkV "voyager") | mkV2 (mkV I.transmettre_V2) ; -- tocheck
lin travel_V = L.travel_V ;
lin target_N = mkN "cible" feminine ; -- tocheck
lin very_A = variants{} ; -- 
lin pair_N = mkN "paire" feminine ; -- tocheck
lin male_A = mkA "mâle" ; -- tocheck
lin gas_N = mkN "gaz" masculine | mkN "essence" feminine ; -- tocheck
lin issue_V2 = variants{} ; -- 
lin issue_V = variants{} ; -- 
lin contribution_N = mkN "contribution" feminine ; -- tocheck
lin complex_A = mkA "complexe" ; -- tocheck
lin supply_V2 = mkV2 (mkV "fournir") ; -- tocheck
lin beat_V2 = mkV2 (mkV I.battre_V2) | mkV2 (mkV I.vaincre_V2) ; -- tocheck
lin beat_V = variants{}; -- mkV2 (mkV I.battre_V2) | mkV2 (mkV I.vaincre_V2) ; -- tocheck
lin artist_N = mkN "artiste" ; -- tocheck
lin agentMasc_N = mkN "agent" masculine ;
lin presence_N = mkN "présence" feminine ; -- tocheck
lin along_Adv = mkAdv "accompagné" ; -- tocheck
lin environmental_A = mkA "environnemental" ; -- tocheck
lin strike_V2 = mkV2 (mkV "biffer") | mkV2 (mkV "frapper") ; -- tocheck
lin strike_V = variants{}; -- mkV2 (mkV "biffer") | mkV2 (mkV "frapper") ; -- tocheck
lin contact_N = mkN "contact" masculine | mkN "lentille" feminine ; -- tocheck
lin protection_N = mkN "protection" feminine ; -- tocheck
lin beginning_N = mkN "début" masculine ; -- tocheck
lin demand_VS = variants{}; -- mkV2 (mkV "exiger") ; -- tocheck
lin demand_V2 = mkV2 (mkV "exiger") ; -- tocheck
lin media_N = mkN "médias" ; -- tocheck
lin relevant_A = mkA "pertinent" ; -- tocheck
lin employ_V2 = mkV2 (mkV "employer") ; -- tocheck
lin shoot_V2 = mkV2 (mkV "tirer") ; -- tocheck
lin shoot_V = variants{}; -- mkV2 (mkV "tirer") ; -- tocheck
lin executive_N = mkN "exécutif" masculine | mkN "cadre" ; -- tocheck
lin slowly_Adv = variants{} ; -- 
lin relatively_Adv = variants{} ; -- 
lin aid_N = mkN "aide" feminine ; -- tocheck
lin huge_A = mkA "énorme" ; -- tocheck
lin late_Adv = mkAdv "tard" | mkAdv "en retard" ; ---- split : late in the night ; sorry I'm late
lin speed_N = mkN "vitesse" feminine | mkN "speed" masculine ; -- tocheck
lin review_N = mkN "critique" feminine ; -- tocheck
lin test_V2 = mkV2 (mkV "tester") ; -- tocheck
lin order_VS = variants{}; -- mkV2V (mkV "commander") | mkV2V (mkV "ranger") ; -- tocheck
lin order_V2V = mkV2V (mkV "commander") | mkV2V (mkV "ranger") ; -- tocheck
lin order_V2 = variants{}; -- mkV2V (mkV "commander") | mkV2V (mkV "ranger") ; -- tocheck
lin order_V = variants{}; -- mkV2V (mkV "commander") | mkV2V (mkV "ranger") ; -- tocheck
lin route_N = mkN "route" feminine ; -- tocheck
lin consequence_N = mkN "conséquence" feminine ; -- tocheck
lin telephone_N = mkN "téléphone" masculine ; -- tocheck
lin release_V2 = mkV2 (mkV "lâcher") | mkV2 (mkV I.sortir_V) ; -- tocheck
lin proportion_N = mkN "proportion" feminine ; -- tocheck
lin primary_A = mkA "prioritaire" ; -- tocheck
lin consideration_N = mkN "considération" | mkN "considération" feminine ; -- tocheck
lin reform_N = mkN "réforme" feminine ; -- tocheck
lin driverMasc_N = mkN "chauffeur" ;
lin annual_A = mkA "annuel" ; -- tocheck
lin nuclear_A = mkA "nucléaire" ; -- tocheck
lin latter_A = mkA "celui-ci" ; -- tocheck
lin practical_A = variants{} ; -- 
lin commercial_A = variants{} ; -- 
lin rich_A = mkA "riche" ; -- tocheck
lin emerge_V = variants{}; -- mkV2V (mkV "émerger") ; -- tocheck
lin apparently_Adv = variants{} ; -- 
lin ring_V = variants{} ; -- 
lin ring_6_V2 = variants{} ; -- 
lin ring_4_V2 = mkV2 (mkV "sonner") ; -- tocheck
lin distance_N = mkN "distance" feminine ; -- tocheck
lin exercise_N = mkN "exercice" masculine ; -- tocheck
lin key_A = variants{} ; -- 
lin close_Adv = variants{} ; -- 
lin skin_N = L.skin_N ;
lin island_N = mkN "île" feminine ; -- tocheck
lin separate_A = mkA "séparé" ; -- tocheck
lin aim_VV = variants{}; -- mkV2 (mkV "cibler") | mkV2 (mkV "viser") ; -- tocheck
lin aim_V2 = mkV2 (mkV "cibler") | mkV2 (mkV "viser") ; -- tocheck
lin aim_V = variants{}; -- mkV2 (mkV "cibler") | mkV2 (mkV "viser") ; -- tocheck
lin danger_N = mkN "danger" masculine ; -- tocheck
lin credit_N = mkN "crédit" masculine | mkN "crédit" ; -- tocheck
lin usual_A = mkA "habituel/habituelle" ; -- tocheck
lin link_V2 = mkV2 (mkV "relier") ; -- tocheck
lin link_V = variants{}; -- mkV2 (mkV "relier") ; -- tocheck
lin candidateMasc_N = mkN "candidat" ;
lin track_N = mkN "sentier" masculine | mkN "chemin" masculine | mkN "voie" feminine | mkN "empreinte" feminine | mkN "piste" feminine | mkN "sillon" masculine | mkN "trace" feminine ; -- tocheck
lin safe_A = mkA "sauf" | mkA "sûr" ; -- tocheck
lin interested_A = mkA "intéressé" ; -- tocheck
lin assessment_N = mkN "évaluation" feminine | mkN "estimation" feminine ; -- tocheck
lin path_N = mkN "chemin" masculine | mkN "sentier" masculine ; -- tocheck
lin merely_Adv = variants{} ; -- 
lin plus_Prep = variants{} ; -- 
lin district_N = mkN "district" masculine ; -- tocheck
lin regular_A = mkA "régulier" ; -- tocheck
lin reaction_N = mkN "réaction" feminine ; -- tocheck
lin impact_N = mkN "impact" masculine ; -- tocheck
lin collect_V2 = mkV2 (mkV "rassembler") | mkV2 (mkV "collectionner") | mkV2 (mkV I.percevoir_V2) ; -- tocheck
lin collect_V = variants{}; -- mkV2 (mkV "rassembler") | mkV2 (mkV "collectionner") | mkV2 (mkV I.percevoir_V2) ; -- tocheck
lin debate_N = mkN "débat" masculine | mkN "discussion" feminine ; -- tocheck
lin lay_V2 = mkV2 (mkV "coucher") | mkV2 (mkV I.pondre_V2) ; -- tocheck
lin lay_V = variants{}; -- mkV2 (mkV "coucher") | mkV2 (mkV I.pondre_V2) ; -- tocheck
lin rise_N = mkN "montée" ; -- tocheck
lin belief_N = mkN "croyance" feminine | mkN "foi" feminine | mkN "conviction" feminine ; -- tocheck
lin conclusion_N = mkN "conclusion" feminine ; -- tocheck
lin shape_N = mkN "forme" feminine ; -- tocheck
lin vote_N = mkN "vote" masculine | mkN "voix" feminine ; -- tocheck
lin aim_N = mkN "cible" feminine | mkN "objectif" masculine ; -- tocheck
lin politics_N = mkN "politique" feminine ; -- tocheck
lin reply_VS = variants{}; -- mkV2 (mkV I.répondre_V2) ; -- tocheck
lin reply_V = variants{}; -- mkV2 (mkV I.répondre_V2) ; -- tocheck
lin press_V2V = mkV2V (mkV "appuyer") | mkV2V (mkV "presser") ; -- tocheck
lin press_V2 = variants{}; -- mkV2V (mkV "appuyer") | mkV2V (mkV "presser") ; -- tocheck
lin press_V = variants{}; -- mkV2V (mkV "appuyer") | mkV2V (mkV "presser") ; -- tocheck
lin approach_V2 = mkV2 (mkV "approcher") ; -- tocheck
lin approach_V = variants{}; -- mkV2 (mkV "approcher") ; -- tocheck
lin file_N = mkN "fichier" masculine | mkN "lime" feminine ; -- tocheck
lin western_A = mkA "occidental" ; -- tocheck
lin earth_N = L.earth_N ;
lin public_N = mkN "public" masculine ; -- tocheck
lin survive_V2 = mkV2 (mkV I.survivre_V2) ; -- tocheck
lin survive_V = variants{}; -- mkV2 (mkV I.survivre_V2) ; -- tocheck
lin estate_N = mkN "domaine" | mkN "proprieté" feminine ; -- tocheck
lin boat_N = L.boat_N ;
lin prison_N = mkN "prison" feminine ; -- tocheck
lin additional_A = mkA "additionnel" ; -- tocheck
lin settle_V2 = mkV2 (reflV (mkV "installer")) ; -- tocheck
lin settle_V = variants{}; -- mkV2 (reflV (mkV "installer")) ; -- tocheck
lin largely_Adv = variants{} ; -- 
lin wine_N = L.wine_N ;
lin observe_VS = variants{}; -- mkV2 (mkV "observer") | mkV2 (mkV "respecter") ; -- tocheck
lin observe_V2 = mkV2 (mkV "observer") | mkV2 (mkV "respecter") ; -- tocheck
lin limit_V2V = mkV2V (mkV "limiter") ; -- tocheck
lin limit_V2 = variants{}; -- mkV2V (mkV "limiter") ; -- tocheck
lin deny_V3 = mkV3 (mkV "nier") ; -- tocheck
lin deny_V2 = variants{}; -- mkV3 (mkV "nier") ; -- tocheck
lin for_PConj = lin PConj (ss "for") ;
lin straight_Adv = mkAdv "directement" ; -- tocheck
lin somebody_NP = S.somebody_NP ;
lin writer_N = mkN "écrivain" masculine ; -- tocheck
lin weekend_N = variants{} ; -- 
lin clothes_N = variants{} ; -- 
lin active_A = mkA "actif" ; -- tocheck
lin sight_N = mkN "mire" feminine | mkN "vue" feminine ; -- tocheck
lin video_N = mkN "vidéo" feminine ; -- tocheck
lin reality_N = mkN "réalité" ; -- tocheck
lin hall_N = mkN "foyer" masculine | mkN "hall" masculine | mkN "couloir" masculine | mkN "manoir" masculine | mkN "salle" feminine ; -- tocheck
lin nevertheless_Adv = mkAdv "néanmoins" ; -- tocheck
lin regional_A = mkA "régional" ; -- tocheck
lin vehicle_N = mkN "véhicule" masculine ; -- tocheck
lin worry_VS = variants{}; -- mkV2 (reflV (mkV "inquiéter")) | mkV2 (mkV "inquiéter") | mkV2 (mkV "harceler") ; -- tocheck
lin worry_V2 = mkV2 (reflV (mkV "inquiéter")) | mkV2 (mkV "inquiéter") | mkV2 (mkV "harceler") ; -- tocheck
lin worry_V = variants{}; -- mkV2 (reflV (mkV "inquiéter")) | mkV2 (mkV "inquiéter") | mkV2 (mkV "harceler") ; -- tocheck
lin powerful_A = mkA "puissant" ; -- tocheck
lin possibly_Adv = variants{} ; -- 
lin cross_V2 = mkV2 (mkV "contrecarrer") | mkV2 (mkV "traverser") | mkV2 (mkV "croiser") ; -- tocheck
lin cross_V = variants{}; -- mkV2 (mkV "contrecarrer") | mkV2 (mkV "traverser") | mkV2 (mkV "croiser") ; -- tocheck
lin colleague_N = mkN "confrère" ; -- tocheck
lin charge_V2 = mkV2 (mkV "charger") | mkV2 (mkV "accuser") | mkV2 (mkV "armer") ; -- tocheck
lin charge_V = variants{}; -- mkV2 (mkV "charger") | mkV2 (mkV "accuser") | mkV2 (mkV "armer") ; -- tocheck
lin lead_N = mkN "plomb" masculine | mkN "piste" feminine | mkN "tuyau" masculine | mkN "laisse" feminine | mkN "sonde" feminine | mkN "prospect" masculine | mkN "mine" feminine ; -- tocheck
lin farm_N = mkN "ferme" feminine ; -- tocheck
lin respond_VS = variants{}; -- mkV2 (mkV I.répondre_V2) ; -- tocheck
lin respond_V = variants{}; -- mkV2 (mkV I.répondre_V2) ; -- tocheck
lin employer_N = mkN "employeur" masculine ; -- tocheck
lin carefully_Adv = variants{} ; -- 
lin understanding_N = mkN "compréhension" feminine ; -- tocheck
lin connection_N = mkN "connexion" feminine | mkN "complicité" feminine | mkN "lien" masculine | mkN "correspondance" feminine ; -- tocheck
lin comment_N = mkN "commentaire" masculine ; -- tocheck
lin grant_V3 = mkV3 (mkV "accorder") ; -- tocheck
lin grant_V2 = variants{}; -- mkV3 (mkV "accorder") ; -- tocheck
lin concentrate_V2 = mkV2 (reflV (mkV "concentrer")) | mkV2 (mkV "concentrer") ; -- tocheck
lin concentrate_V = variants{}; -- mkV2 (reflV (mkV "concentrer")) | mkV2 (mkV "concentrer") ; -- tocheck
lin ignore_V2 = variants{} ; -- 
lin ignore_V = variants{} ; -- 
lin phone_N = mkN "téléphone" masculine ; -- tocheck
lin hole_N = mkN "creux" masculine | mkN "trou" masculine | mkN "faille" feminine ; -- tocheck
lin insurance_N = mkN "assurance" | mkN "assurance" feminine ; -- tocheck
lin content_N = mkN "contenu" masculine ; -- tocheck
lin confidence_N = mkN "confidence" feminine | mkN "assurance" | mkN "confiance" feminine ; -- tocheck
lin sample_N = mkN "échantillon" masculine ; -- tocheck
lin transport_N = mkN "transport" masculine | mkN "transport" ; -- tocheck
lin objective_N = mkN "objectif" masculine ; -- tocheck
lin alone_A = variants{} ; -- 
lin flower_N = L.flower_N ;
lin injury_N = mkN "blessure" feminine ; -- tocheck
lin lift_V2 = mkV2 (mkV "lever") ; -- tocheck
lin lift_V = variants{}; -- mkV2 (mkV "lever") ; -- tocheck
lin stick_V2 = mkV2 (mkV "coller") | mkV2 (mkV "coincer") | mkV2 (mkV "rester") | mkV2 (mkV "ficher") | mkV2 (mkV "planter") | mkV2 (mkV "bouturer") ; -- tocheck
lin stick_V = variants{}; -- mkV2 (mkV "coller") | mkV2 (mkV "coincer") | mkV2 (mkV "rester") | mkV2 (mkV "ficher") | mkV2 (mkV "planter") | mkV2 (mkV "bouturer") ; -- tocheck
lin front_A = variants{} ; -- 
lin mainly_Adv = variants{} ; -- 
lin battle_N = mkN "lutte" feminine ; -- tocheck
lin generation_N = mkN "création" | mkN "génération" | mkN "génération" feminine ; -- tocheck
lin currently_Adv = variants{} ; -- 
lin winter_N = mkN "hiver" masculine ; -- tocheck
lin inside_Prep = variants{} ; -- 
lin impossible_A = mkA "impossible" | mkA "insupportable" ; -- tocheck
lin somewhere_Adv = S.somewhere_Adv ;
lin arrange_V2 = mkV2 (mkV "arranger") ; -- tocheck
lin arrange_V = variants{}; -- mkV2 (mkV "arranger") ; -- tocheck
lin will_N = mkN "testament" masculine | mkN "volonté" feminine ; -- tocheck
lin sleep_V = L.sleep_V ;
lin progress_N = mkN "progrès" masculine ; -- tocheck
lin volume_N = mkN "volume" masculine ; -- tocheck
lin ship_N = L.ship_N ;
lin legislation_N = mkN "loi" feminine | mkN "législation" feminine ; -- tocheck
lin commitment_N = mkN "engagement" masculine ; -- tocheck
lin enough_Predet = variants{} ; -- 
lin conflict_N = mkN "conflit" masculine ; -- tocheck
lin bag_N = mkN "sac" masculine ; -- tocheck
lin fresh_A = mkA "nouveau" | mkA "frais" | mkA "doux" ; -- tocheck
lin entry_N = mkN "entrée" feminine | mkN "article" masculine | mkN "élément" masculine | mkN "coefficient" masculine ; -- tocheck
lin entry_2_N = variants{} ; -- 
lin entry_1_N = variants{} ; -- 
lin smile_N = mkN "sourire" masculine ; -- tocheck
lin fair_A = mkA "beau" | mkA "juste" ; -- tocheck
lin promise_VV = variants{}; -- mkV2 (mkV I.promettre_V2) ; -- tocheck
lin promise_VS = variants{}; -- mkV2 (mkV I.promettre_V2) ; -- tocheck
lin promise_V2 = mkV2 (mkV I.promettre_V2) ; -- tocheck
lin promise_V = variants{}; -- mkV2 (mkV I.promettre_V2) ; -- tocheck
lin introduction_N = mkN "introduction" feminine | mkN "présentation" feminine ; -- tocheck
lin senior_A = mkA "aîné" ; -- tocheck
lin manner_N = mkN "manière" feminine ; -- tocheck
lin background_N = mkN "milieu" masculine | mkN "fond" masculine | mkN "arrière-plan" masculine | mkN "antécédents" ; -- tocheck
lin key_N = mkN "touche" feminine | mkN "clef" feminine | mkN "légende" feminine | mkN "caye" feminine ; -- tocheck
lin key_2_N = variants{} ; -- 
lin key_1_N = variants{} ; -- 
lin touch_V2 = mkV2 (mkV "toucher") ; -- tocheck
lin touch_V = variants{}; -- mkV2 (mkV "toucher") ; -- tocheck
lin vary_V2 = mkV2 (mkV "varier") ; -- tocheck
lin vary_V = variants{}; -- mkV2 (mkV "varier") ; -- tocheck
lin sexual_A = mkA "sexuel" ; -- tocheck
lin ordinary_A = mkA "ordinaire" ; -- tocheck
lin cabinet_N = mkN "cabinet" masculine | mkN "armoire" feminine ; -- tocheck
lin painting_N = mkN "peinture" ; -- tocheck
lin entirely_Adv = variants{} ; -- 
lin engine_N = mkN "moteur" masculine | mkN "locomotive" feminine ; -- tocheck
lin previously_Adv = variants{} ; -- 
lin administration_N = variants{} ; -- 
lin tonight_Adv = variants{} ; -- 
lin adult_N = mkN "adulte" ; -- tocheck
lin prefer_VV = deVV (mkV "préférer") ;
lin prefer_V2 = mkV2 (mkV "préférer") ;
lin author_N = mkN "auteur" masculine ; -- tocheck
lin actual_A = mkA "réel" ; -- tocheck
lin song_N = L.song_N ;
lin investigation_N = mkN "investigation" feminine ; -- tocheck
lin debt_N = mkN "dette" feminine | mkN "dette" ; -- tocheck
lin visitor_N = mkN "invité" masculine | mkN "visiteur" masculine ; -- tocheck
lin forest_N = mkN "forêt" feminine ; -- tocheck
lin repeat_VS = variants{}; -- mkV2 (mkV "répéter") ; -- tocheck
lin repeat_V2 = mkV2 (mkV "répéter") ; -- tocheck
lin repeat_V = variants{}; -- mkV2 (mkV "répéter") ; -- tocheck
lin wood_N = L.wood_N ;
lin contrast_N = variants{} ; -- 
lin extremely_Adv = variants{} ; -- 
lin wage_N = mkN "salaire" masculine ; -- tocheck
lin domestic_A = mkA "domestique" | mkA "intérieur" ; -- tocheck
lin commit_V2 = variants{} ; -- 
lin threat_N = mkN "menace" feminine ; -- tocheck
lin bus_N = mkN "autobus" masculine ; -- tocheck
lin warm_A = L.warm_A ;
lin sir_N = mkN "monsieur" masculine | mkN "seigneur" masculine ; -- tocheck
lin regulation_N = mkN "règlement" masculine ; -- tocheck
lin drink_N = mkN "boire" | mkN "verre" masculine | mkN "boisson" feminine ; -- tocheck
lin relief_N = mkN "relief" masculine | mkN "soulagement" masculine | mkN "relève" feminine ; -- tocheck
lin internal_A = mkA "interne" ; -- tocheck
lin strange_A = mkA "inconnu" | mkA "étrange" ; -- tocheck
lin excellent_A = mkA "excellent" ; -- tocheck
lin run_N = mkN "galoper" | mkN "courir" ; -- tocheck
lin fairly_Adv = variants{} ; -- 
lin technical_A = variants{} ; -- 
lin tradition_N = mkN "tradition" feminine ; -- tocheck
lin measure_V2 = mkV2 (mkV "mesurer") ; -- tocheck
lin measure_V = variants{}; -- mkV2 (mkV "mesurer") ; -- tocheck
lin insist_VS = mkVS (mkV "insister") ;
lin insist_V2 = mkV2 (mkV "insister") ; -- tocheck
lin insist_V = mkV "insister" ;
lin farmer_N = mkN "agriculteur" masculine ; -- tocheck
lin until_Prep = mkPrep ("jusqu'à ce" ++ Ph.elisQue) ;
lin traffic_N = mkN "traite" feminine | mkN "circulation" feminine ; -- tocheck
lin dinner_N = mkN "dîner" masculine | mkN "déjeuner" masculine ; -- tocheck
lin consumer_N = mkN "consommateur" ; -- tocheck
lin meal_N = mkN "moûture" feminine | mkN "repas" masculine ; -- tocheck
lin warn_VS = variants{}; -- mkV2V (mkV "avertir") ; -- tocheck
lin warn_V2V = mkV2V (mkV "avertir") ; -- tocheck
lin warn_V2 = variants{}; -- mkV2V (mkV "avertir") ; -- tocheck
lin warn_V = variants{}; -- mkV2V (mkV "avertir") ; -- tocheck
lin living_A = mkA "vivant" ; -- tocheck
lin package_N = mkN "paquet" masculine ; -- tocheck
lin half_N = mkN "moitié" feminine | mkN "demi" masculine ; -- tocheck
lin increasingly_Adv = variants{} ; -- 
lin description_N = mkN "signalement" | mkN "description" feminine ; -- tocheck
lin soft_A = mkA "doux" | mkA "mou" ; -- tocheck
lin stuff_N = mkN "truc" | mkN "substance" ; -- tocheck
lin award_V3 = mkV3 (mkV "accorder") ; -- tocheck
lin award_V2 = variants{}; -- mkV3 (mkV "accorder") ; -- tocheck
lin existence_N = mkN "existence" feminine ; -- tocheck
lin improvement_N = mkN "amélioration" feminine ; -- tocheck
lin coffee_N = mkN "café" masculine | mkN "caféier" masculine ; -- tocheck
lin appearance_N = mkN "apparition" feminine | mkN "apparence" feminine | mkN "comparution" feminine ; -- tocheck
lin standard_A = variants{} ; -- 
lin attack_V2 = mkV2 (mkV "attaquer") ; -- tocheck
lin sheet_N = mkN "écoute" feminine | mkN "plaque" feminine | mkN "feuille" feminine ; -- tocheck
lin category_N = mkN "catégorie" feminine ; -- tocheck
lin distribution_N = mkN "distribution" feminine ; -- tocheck
lin equally_Adv = variants{} ; -- 
lin session_N = mkN "séance" feminine ; -- tocheck
lin cultural_A = mkA "culturel" ; -- tocheck
lin loan_N = mkN "emprunt" masculine | mkN "prêt" masculine ; -- tocheck
lin bind_V2 = mkV2 (mkV "lier") | mkV2 (mkV "relier") ; -- tocheck
lin bind_V = variants{}; -- mkV2 (mkV "lier") | mkV2 (mkV "relier") ; -- tocheck
lin museum_N = mkN "musée" masculine ; -- tocheck
lin conversation_N = mkN "conversation" feminine ; -- tocheck
lin threaten_VV = variants{}; -- mkV2 (mkV "menacer") ; -- tocheck
lin threaten_VS = variants{}; -- mkV2 (mkV "menacer") ; -- tocheck
lin threaten_V2 = mkV2 (mkV "menacer") ; -- tocheck
lin threaten_V = variants{}; -- mkV2 (mkV "menacer") ; -- tocheck
lin link_N = mkN "lien" masculine | mkN "maillon" | mkN "flambeau" masculine ; -- tocheck
lin launch_V2 = mkV2 (mkV "lancer") ; -- tocheck
lin launch_V = variants{}; -- mkV2 (mkV "lancer") ; -- tocheck
lin proper_A = mkA "propre" | mkA "convenable" | mkA "approprié" ; -- tocheck
lin victim_N = mkN "victime" feminine | mkN "victime" ; -- tocheck
lin audience_N = mkN "audience" | mkN "assistance" feminine | mkN "lectorat" ; -- tocheck
lin famous_A = mkA "célèbre" | mkA "fameux" ; -- tocheck
lin master_N = mkN "maître" masculine ;
lin master_2_N = mkN "maître" masculine ;
lin master_1_N = mkN "maître" masculine ;
lin lip_N = mkN "lèvre" feminine ; -- tocheck
lin religious_A = mkA "religieux" ; -- tocheck
lin joint_A = variants{} ; -- 
lin cry_V2 = mkV2 (mkV "crier") | mkV2 (mkV "pleurer") ; -- tocheck
lin cry_V = variants{}; -- mkV2 (mkV "crier") | mkV2 (mkV "pleurer") ; -- tocheck
lin potential_A = mkA "potentiel" ; -- tocheck
lin broad_A = L.broad_A ;
lin exhibition_N = mkN "exposition" feminine ; -- tocheck
lin experience_V2 = mkV2 (mkV "éprouver") ; -- tocheck
lin judge_N = mkN "juge" | mkN "arbitre" ; -- tocheck
lin formal_A = mkA "formel" ; -- tocheck
lin housing_N = mkN "logement" | mkN "logement" masculine ; -- tocheck
lin past_Prep = variants{} ; -- 
lin concern_V2 = mkV2 (mkV "concerner") | mkV2 (mkV "inquiéter") ; -- tocheck
lin freedom_N = mkN "liberté" feminine ; -- tocheck
lin gentleman_N = mkN "monsieur" "messieurs" masculine | mkN "gentilhomme" masculine ;
lin attract_V2 = mkV2 (mkV "attirer") ; -- tocheck
lin explanation_N = mkN "explication" feminine ; -- tocheck
lin appoint_V3 = mkV3 (mkV "fixer") | mkV3 (mkV "désigner") ; -- tocheck
lin appoint_V2V = variants{}; -- variants{}; -- mkV3 (mkV "fixer") | mkV3 (mkV "désigner") ; -- tocheck
lin appoint_V2 = variants{}; -- mkV3 (mkV "fixer") | mkV3 (mkV "désigner") ; -- tocheck
lin note_VS = variants{}; -- mkV2 (mkV "noter") ; -- tocheck
lin note_V2 = mkV2 (mkV "noter") ; -- tocheck
lin note_V = variants{}; -- mkV2 (mkV "noter") ; -- tocheck
lin chief_A = variants{} ; -- 
lin total_N = mkN "somme" feminine | mkN "total" masculine ; -- tocheck
lin lovely_A = mkA "adorable" ; -- tocheck
lin official_A = mkA "officiel" ; -- tocheck
lin date_V2 = mkV2 (mkV "vieillir") | mkV2 (mkV "dater") ; -- tocheck
lin date_V = variants{}; -- mkV2 (mkV "vieillir") | mkV2 (mkV "dater") ; -- tocheck
lin demonstrate_VS = variants{}; -- mkV2 (mkV "démontrer") ; -- tocheck
lin demonstrate_V2 = mkV2 (mkV "démontrer") ; -- tocheck
lin demonstrate_V = variants{}; -- mkV2 (mkV "démontrer") ; -- tocheck
lin construction_N = mkN "construction" feminine ; -- tocheck
lin middle_N = mkN "milieu" masculine | mkN "milieu" ; -- tocheck
lin yard_N = mkN "cour" feminine | mkN "verge" feminine | mkN "yard" masculine ; -- tocheck
lin unable_A = mkA "incapable" ; -- tocheck
lin acquire_V2 = mkV2 (mkV I.acquérir_V2) ; -- tocheck
lin surely_Adv = variants{} ; -- 
lin crisis_N = mkN "crise" feminine ; -- tocheck
lin propose_VV = variants{}; -- mkV2 (mkV "proposer") ; -- tocheck
lin propose_VS = variants{}; -- mkV2 (mkV "proposer") ; -- tocheck
lin propose_V2 = mkV2 (mkV "proposer") ; -- tocheck
lin propose_V = variants{}; -- mkV2 (mkV "proposer") ; -- tocheck
lin west_N = mkN "ouest" masculine ; -- tocheck
lin impose_V2 = mkV2 (mkV "imposer") | mkV2 (reflV (mkV "imposer")) ; -- tocheck
lin impose_V = variants{}; -- mkV2 (mkV "imposer") | mkV2 (reflV (mkV "imposer")) ; -- tocheck
lin market_V2 = mkV2 (mkV "commercialiser") ; -- tocheck
lin market_V = variants{}; -- mkV2 (mkV "commercialiser") ; -- tocheck
lin care_V = mkV (reflV (mkV "soucier")) | mkV (mkV "soigner") ; -- tocheck
lin god_N = mkN "dieu" masculine | mkN "idole" ; -- tocheck
lin favour_N = variants{} ; -- 
lin before_Adv = mkAdv "avant" ; -- tocheck
lin name_V3 = mkV3 (mkV "nommer") | mkV3 (mkV "préciser") | mkV3 (mkV "choisir") | mkV3 (mkV "identifier") ; -- tocheck
lin name_V2 = variants{}; -- mkV3 (mkV "nommer") | mkV3 (mkV "préciser") | mkV3 (mkV "choisir") | mkV3 (mkV "identifier") ; -- tocheck
lin equal_A = mkA "égal" ; -- tocheck
lin capacity_N = mkN "capacité" ; -- tocheck
lin flat_N = mkN "bémol" masculine ; -- tocheck
lin selection_N = mkN "sélection" | mkN "sélection" feminine ; -- tocheck
lin alone_Adv = variants{} ; -- 
lin football_N = mkN "football" masculine ; -- tocheck
lin victory_N = mkN "victoire" feminine ; -- tocheck
lin factory_N = L.factory_N ;
lin rural_A = mkA "rural" ; -- tocheck
lin twice_Adv = variants{} ; -- 
lin sing_V2 = mkV2 (mkV "chanter") ; -- tocheck
lin sing_V = L.sing_V ;
lin whereas_Subj = variants{} ; -- 
lin own_V2 = mkV2 (mkV "posséder") ; -- tocheck
lin head_V2 = mkV2 (mkV "commander") ; -- tocheck
lin head_V = variants{}; -- mkV2 (mkV "commander") ; -- tocheck
lin examination_N = mkN "examen" masculine ; -- tocheck
lin deliver_V2 = mkV2 (mkV "livrer") ; -- tocheck
lin deliver_V = variants{}; -- mkV2 (mkV "livrer") ; -- tocheck
lin nobody_NP = S.nobody_NP ;
lin substantial_A = mkA "substantiel" ; -- tocheck
lin invite_V2V = mkV2V (mkV "inviter") ; -- tocheck
lin invite_V2 = variants{}; -- mkV2V (mkV "inviter") ; -- tocheck
lin intention_N = mkN "intention" feminine ; -- tocheck
lin egg_N = L.egg_N ;
lin reasonable_A = mkA "correct" | mkA "satisfaisant" ; -- tocheck
lin onto_Prep = variants{} ; -- 
lin retain_V2 = variants{}; -- mkV2V (mkV I.retenir_V2) ; -- tocheck
lin aircraft_N = mkN "aéronef" masculine ; -- tocheck
lin decade_N = mkN "dizaine" | mkN "décennie" feminine ; -- tocheck
lin cheap_A = mkA "radin" | mkA "modique" ; -- tocheck
lin quiet_A = mkA "tranquille" | mkA "calme" | mkA "silencieux" ; -- tocheck
lin bright_A = mkA "brillant" | mkA "heureux" | mkA "intelligent" | mkA "vivide" ; -- tocheck
lin contribute_V2 = variants{}; -- mkV2V (mkV "contribuer") ; -- tocheck
lin contribute_V = variants{}; -- mkV2V (mkV "contribuer") ; -- tocheck
lin row_N = mkN "ligne" feminine ; -- tocheck
lin search_N = mkN "recherche" feminine ; -- tocheck
lin limit_N = mkN "limite" feminine ; -- tocheck
lin definition_N = mkN "définition" | mkN "définition" feminine ; -- tocheck
lin unemployment_N = mkN "chômage" masculine ; -- tocheck
lin spread_V2 = variants{}; -- mkV2V (mkV I.étendre_V2) | mkV2V (mkV "écarter") | mkV2V (mkV "disperser") | mkV2V (mkV "étaler") | mkV2V (mkV I.répandre_V2) ; -- tocheck
lin spread_V = variants{}; -- mkV2V (mkV I.étendre_V2) | mkV2V (mkV "écarter") | mkV2V (mkV "disperser") | mkV2V (mkV "étaler") | mkV2V (mkV I.répandre_V2) ; -- tocheck
lin mark_N = mkN "note" feminine | mkN "pièce" | mkN "marque" feminine | mkN "marc" masculine | mkN "score" masculine | mkN "mark" masculine | mkN "trace" feminine ; -- tocheck
lin flight_N = mkN "fuite" feminine | mkN "vol" masculine | mkN "volée" feminine ; -- tocheck
lin account_V2 = variants{} ; -- 
lin account_V = variants{} ; -- 
lin output_N = variants{} ; -- 
lin last_V = variants{}; -- mkV2 (mkV "durer") ; -- tocheck
lin tour_N = mkN "excursion" masculine | mkN "tournée" feminine ; -- tocheck
lin address_N = mkN "discours" masculine | mkN "adresse" feminine ; -- tocheck
lin immediate_A = mkA "proche" | mkA "immédiat" ; -- tocheck
lin reduction_N = mkN "réduction" feminine ; -- tocheck
lin interview_N = mkN "entretien" masculine | mkN "interview" feminine ; -- tocheck
lin assess_V2 = mkV2 (mkV "estimer") ; -- tocheck
lin promote_V2 = mkV2 (mkV I.promouvoir_V2) ; -- tocheck
lin promote_V = variants{}; -- mkV2 (mkV I.promouvoir_V2) ; -- tocheck
lin everybody_NP = S.everybody_NP ;
lin suitable_A = mkA "approprié" ; -- tocheck
lin growing_A = variants{} ; -- 
lin nod_V = variants{} ; -- 
lin reject_V2 = mkV2 (mkV "rejeter") ; -- tocheck
lin while_N = mkN "moment" masculine ; -- tocheck
lin high_Adv = variants{} ; -- 
lin dream_N = mkN "rêve" masculine ; -- tocheck
lin vote_VV = variants{}; -- mkV2 (mkV "voter") ; -- tocheck
lin vote_V3 = variants{}; -- mkV2 (mkV "voter") ; -- tocheck
lin vote_V2 = mkV2 (mkV "voter") ; -- tocheck
lin vote_V = variants{}; -- mkV2 (mkV "voter") ; -- tocheck
lin divide_V2 = mkV2 (mkV "diviser") | mkV2 (reflV (mkV "diviser")) | mkV2 (mkV "partager") ; -- tocheck
lin divide_V = variants{}; -- mkV2 (mkV "diviser") | mkV2 (reflV (mkV "diviser")) | mkV2 (mkV "partager") ; -- tocheck
lin declare_VS = variants{}; -- mkV2V (mkV "déclarer") ; -- tocheck
lin declare_V2 = variants{}; -- mkV2V (mkV "déclarer") ; -- tocheck
lin declare_V = variants{}; -- mkV2V (mkV "déclarer") ; -- tocheck
lin handle_V2 = mkV2 (mkV "tâter") | mkV2 (mkV "gérer") | mkV2 (mkV "manipuler") | mkV2 (mkV "traiter") | mkV2 (mkV "manier") ; -- tocheck
lin handle_V = variants{}; -- mkV2 (mkV "tâter") | mkV2 (mkV "gérer") | mkV2 (mkV "manipuler") | mkV2 (mkV "traiter") | mkV2 (mkV "manier") ; -- tocheck
lin detailed_A = variants{} ; -- 
lin challenge_N = mkN "défi" | mkN "défi" masculine ; -- tocheck
lin notice_N = variants{} ; -- 
lin rain_N = L.rain_N ;
lin destroy_V2 = mkV2 (mkV I.détruire_V2) | mkV2 (mkV "euthanasier") ; -- tocheck
lin mountain_N = L.mountain_N ;
lin concentration_N = variants{} ; -- 
lin limited_A = variants{} ; -- 
lin finance_N = mkN "finance" feminine | mkN "finances" ; -- tocheck
lin pension_N = mkN "pension" feminine ; -- tocheck
lin influence_V2 = mkV2 (mkV "influencer") ; -- tocheck
lin afraid_A = mkA "effrayé" ; -- tocheck
lin murder_N = mkN "meurtre" masculine ; -- tocheck
lin neck_N = L.neck_N ;
lin weapon_N = mkN "arme" feminine ; -- tocheck
lin hide_V2 = mkV2 (mkV "cacher") | mkV2 (reflV (mkV "cacher")) ; -- tocheck
lin hide_V = variants{}; -- mkV2 (mkV "cacher") | mkV2 (reflV (mkV "cacher")) ; -- tocheck
lin offence_N = variants{} ; -- 
lin absence_N = mkN "absence" feminine | mkN "absence" ; -- tocheck
lin error_N = mkN "erreur" feminine ; -- tocheck
lin representativeMasc_N = mkN "représentatif" ;
lin enterprise_N = mkN "entreprise" feminine | mkN "venture" feminine | mkN "initiative" feminine ; -- tocheck
lin criticism_N = mkN "critique" feminine ; -- tocheck
lin average_A = mkA "moyen" ; -- tocheck
lin quick_A = mkA "animé" | mkA "rapide" ; -- tocheck
lin sufficient_A = mkA "suffisant" | mkA "autosuffisant" ; -- tocheck
lin appointment_N = mkN "rendez-vous" | mkN "nomination" feminine ; -- tocheck
lin match_V2 = mkV2 (mkV "combiner") | mkV2 (mkV "concorder") ; -- tocheck
lin transfer_V = variants{}; -- mkV2 (mkV "transférer") ; -- tocheck
lin acid_N = mkN "acide" masculine | mkN "acide" ; -- tocheck
lin spring_N = mkN "ressort" masculine | mkN "printemps" masculine | mkN "garde" feminine | mkN "source" feminine ; -- tocheck
lin birth_N = mkN "naissance" feminine ; -- tocheck
lin ear_N = L.ear_N ;
lin recognize_VS = variants{} ; -- 
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin recommend_V2V = mkV2V (mkV "adviser") | mkV2V (mkV "recommander") ; -- tocheck
lin recommend_V2 = variants{}; -- mkV2V (mkV "adviser") | mkV2V (mkV "recommander") ; -- tocheck
lin module_N = mkN "module" ; -- tocheck
lin instruction_N = mkN "instruction" feminine ; -- tocheck
lin democratic_A = mkA "démocratique" ; -- tocheck
lin park_N = mkN "parc" masculine ; -- tocheck
lin weather_N = mkN "temps" masculine | mkN "intempéries" feminine ; -- tocheck
lin bottle_N = mkN "bouteille" feminine | mkN "biberon" masculine | mkN "culot" masculine ; -- tocheck
lin address_V2 = variants{} ; -- 
lin bedroom_N = mkN "chambre" feminine ; -- tocheck
lin kid_N = mkN "gamin" | mkN "chevreau" masculine | mkN "gamin" masculine ; -- tocheck
lin pleasure_N = mkN "désir" masculine | mkN "plaisir" masculine ; -- tocheck
lin realize_VS = variants{}; -- mkV2 (mkV "réaliser") ; -- tocheck
lin realize_V2 = mkV2 (mkV "réaliser") ; -- tocheck
lin assembly_N = variants{} ; -- 
lin expensive_A = mkA "cher" ; -- tocheck
lin select_VV = variants{}; -- mkV2V (mkV "choisir") ; -- tocheck
lin select_V2V = mkV2V (mkV "choisir") ; -- tocheck
lin select_V2 = variants{}; -- mkV2V (mkV "choisir") ; -- tocheck
lin select_V = variants{}; -- mkV2V (mkV "choisir") ; -- tocheck
lin teaching_N = mkN "enseignement" masculine | mkN "doctrine" feminine ; -- tocheck
lin desire_N = mkN "désir" masculine ; -- tocheck
lin whilst_Subj = variants{} ; -- 
lin contact_V2 = mkV2 (mkV "contacter") | mkV2 (mkV "toucher") ; -- tocheck
lin implication_N = mkN "implication" ; -- tocheck
lin combine_VV = variants{}; -- mkV2V (mkV "combiner") ; -- tocheck
lin combine_V2 = variants{}; -- mkV2V (mkV "combiner") ; -- tocheck
lin combine_V = variants{}; -- mkV2V (mkV "combiner") ; -- tocheck
lin temperature_N = mkN "température" ; -- tocheck
lin wave_N = mkN "vague" ; -- tocheck
lin magazine_N = mkN "magasin" masculine | mkN "arsenal" masculine | mkN "magazine" masculine ; -- tocheck
lin totally_Adv = variants{} ; -- 
lin mental_A = mkA "mental" ; -- tocheck
lin used_A = variants{} ; -- 
lin store_N = mkN "entrepôt" masculine | mkN "stock" masculine ; -- tocheck
lin scientific_A = mkA "scientifique" ; -- tocheck
lin frequently_Adv = variants{} ; -- 
lin thanks_N = mkN "merci" ;
lin beside_Prep = variants{} ; -- 
lin settlement_N = mkN "colonie" feminine | mkN "agglomération" feminine | mkN "arrangement" masculine | mkN "règlement" masculine ; -- tocheck
lin absolutely_Adv = mkAdv "absolument" ;
lin critical_A = mkA "critique" ; -- tocheck
lin critical_2_A = variants{} ; -- 
lin critical_1_A = variants{} ; -- 
lin recognition_N = mkN "reconnaissance" feminine ; -- tocheck
lin touch_N = mkN "toucher" masculine | mkN "toucher" ; -- tocheck
lin consist_V = variants{} ; -- 
lin below_Prep = variants{} ; -- 
lin silence_N = mkN "silence" masculine ; -- tocheck
lin expenditure_N = mkN "dépense" feminine ; -- tocheck
lin institute_N = mkN "institut" masculine ; -- tocheck
lin dress_V2 = mkV2 (mkV "panser") | mkV2 (reflV (mkV "habiller")) | mkV2 (mkV "habiller") ; -- tocheck
lin dress_V = variants{}; -- mkV2 (mkV "panser") | mkV2 (reflV (mkV "habiller")) | mkV2 (mkV "habiller") ; -- tocheck
lin dangerous_A = mkA "dangereux" ; -- tocheck
lin familiar_A = mkA "familier" ; -- tocheck
lin asset_N = mkN "actif" masculine ; -- tocheck
lin educational_A = mkA "éducatif" ; -- tocheck
lin sum_N = mkN "calcul" masculine | mkN "somme" feminine ; -- tocheck
lin publication_N = mkN "publication" feminine ; -- tocheck
lin partly_Adv = variants{} ; -- 
lin block_N = mkN "bloc" masculine | mkN "billot" masculine | mkN "rue" feminine | mkN "immeuble" masculine | mkN "tête" | mkN "blocage" masculine ; -- tocheck
lin seriously_Adv = variants{} ; -- 
lin youth_N = mkN "jeunesse" feminine | mkN "jeune" masculine | mkN "jeune" feminine ; -- tocheck
lin tape_N = mkN "bande" ; -- tocheck
lin elsewhere_Adv = mkAdv "ailleurs" ; -- tocheck
lin cover_N = mkN "couverture" feminine | mkN "couvercle" masculine | mkN "couvert" masculine ; -- tocheck
lin fee_N = mkN "honoraires" ; -- tocheck
lin program_N = mkN "programme" masculine | mkN "émission" feminine ; -- tocheck
lin treaty_N = mkN "traité" masculine ; -- tocheck
lin necessarily_Adv = variants{} ; -- 
lin unlikely_A = variants{} ; -- 
lin properly_Adv = variants{} ; -- 
lin guest_N = mkN "invité(e)" | mkN "invité(e)" masculine | mkN "client(e)" masculine ; -- tocheck
lin code_N = mkN "code" masculine ; -- tocheck
lin hill_N = L.hill_N ;
lin screen_N = mkN "paravent" masculine | mkN "écran" masculine ; -- tocheck
lin household_N = mkN "foyer" masculine ; -- tocheck
lin sequence_N = mkN "suite" feminine | mkN "séquence" feminine ; -- tocheck
lin correct_A = L.correct_A ;
lin female_A = mkA "femelle" ; -- tocheck
lin phase_N = variants{} ; -- 
lin crowd_N = mkN "monceau" masculine | mkN "foule" feminine ; -- tocheck
lin welcome_V2 = mkV2 (mkV I.accueillir_V2) ; -- tocheck
lin metal_N = mkN "métal" masculine ; -- tocheck
lin human_N = mkN "humain" masculine ; -- tocheck
lin widely_Adv = variants{} ; -- 
lin undertake_V2 = mkV2 (mkV I.entreprendre_V2) ; -- tocheck
lin cut_N = mkN "coupe" feminine | mkN "baissé" | mkN "coupure" feminine ; -- tocheck
lin sky_N = L.sky_N ;
lin brain_N = mkN "cerveau" masculine ; -- tocheck
lin expert_N = mkN "expert" masculine ; -- tocheck
lin experiment_N = mkN "expérience" feminine ; -- tocheck
lin tiny_A = mkA "minuscule" ; -- tocheck
lin perfect_A = mkA "parfait" ; -- tocheck
lin disappear_V = mkV (mkV I.disparaître_V2) ; -- tocheck
lin initiative_N = mkN "initiative" feminine ; -- tocheck
lin assumption_N = variants{} ; -- 
lin photograph_N = mkN "photographie" feminine ; -- tocheck
lin ministry_N = mkN "ministère" masculine ; -- tocheck
lin congress_N = mkN "congrès" masculine ; -- tocheck
lin transfer_N = mkN "transfert" masculine ; -- tocheck
lin reading_N = mkN "lecture" feminine ; -- tocheck
lin scientist_N = mkN "scientifique" ; -- tocheck
lin fast_Adv = mkAdv "vite" | mkAdv "rapidement" ;
lin fast_A = mkA "rapide" ;
lin closely_Adv = variants{} ; -- 
lin thin_A = L.thin_A ;
lin solicitorMasc_N = mkN "soliciteur" ; ----
lin secure_V2 = variants{} ; -- 
lin plate_N = mkN "plat" masculine | mkN "plaque" feminine | mkN "assiette" feminine | mkN "dentier" masculine | mkN "planche" feminine ; -- tocheck
lin pool_N = mkN "piscine" | mkN "piscine" feminine ; -- tocheck
lin gold_N = L.gold_N ;
lin emphasis_N = mkN "accent" masculine | mkN "graisse" feminine ; -- tocheck
lin recall_VS = variants{}; -- mkV2 (mkV "rappeler") | mkV2 (reflV (mkV I.souvenir_V)) ; -- tocheck
lin recall_V2 = mkV2 (mkV "rappeler") | mkV2 (reflV (mkV I.souvenir_V)) ; -- tocheck
lin shout_V2 = mkV2 (mkV "crier") ; -- tocheck
lin shout_V = variants{}; -- mkV2 (mkV "crier") ; -- tocheck
lin generate_V2 = mkV2 (mkV "générer") | mkV2 (mkV "engendrer") ; -- tocheck
lin location_N = mkN "lieu" masculine ; -- tocheck
lin display_VS = variants{}; -- mkV2 (mkV "afficher") | mkV2 (mkV "étaler") ; -- tocheck
lin display_V2 = mkV2 (mkV "afficher") | mkV2 (mkV "étaler") ; -- tocheck
lin heat_N = mkN "piquant" masculine | mkN "chaleur" feminine | mkN "chauffe" feminine | mkN "excitation" feminine | mkN "artillerie" feminine | mkN "flicaille" feminine ; -- tocheck
lin gun_N = mkN "fusil" masculine | mkN "canon" | mkN "pistolet" masculine ; -- tocheck
lin shut_V2 = mkV2 (mkV "fermer") ; -- tocheck
lin journey_N = mkN "voyage" masculine ; -- tocheck
lin imply_VS = variants{}; -- mkV2 (mkV "impliquer") | mkV2 (mkV "insinuer") ; -- tocheck
lin imply_V2 = mkV2 (mkV "impliquer") | mkV2 (mkV "insinuer") ; -- tocheck
lin imply_V = variants{}; -- mkV2 (mkV "impliquer") | mkV2 (mkV "insinuer") ; -- tocheck
lin violence_N = mkN "violence" feminine ; -- tocheck
lin dry_A = L.dry_A ;
lin historical_A = mkA "historique" ; -- tocheck
lin step_V2 = mkV2 (mkV "marcher") ; -- tocheck
lin step_V = variants{}; -- mkV2 (mkV "marcher") ; -- tocheck
lin curriculum_N = variants{} ; -- 
lin noise_N = mkN "bruit" masculine ; -- tocheck
lin lunch_N = mkN "déjeuner" masculine ; -- tocheck
lin fear_VS = L.fear_VS ;
lin fear_V2 = L.fear_V2 ;
lin fear_V = variants{}; -- L.fear_V2 ;
lin succeed_V2 = mkV2 (mkV "succéder") | mkV2 (mkV "réussir") ; -- tocheck
lin succeed_V = variants{}; -- mkV2 (mkV "succéder") | mkV2 (mkV "réussir") ; -- tocheck
lin fall_N = mkN "chute" feminine | mkN "déclin" masculine ; -- tocheck
lin fall_2_N = variants{} ; -- 
lin fall_1_N = variants{} ; -- 
lin bottom_N = mkN "fond" masculine | mkN "passif" | mkN "arrière-train" masculine ; -- tocheck
lin initial_A = mkA "initial" ; -- tocheck
lin theme_N = mkN "thème" masculine ; -- tocheck
lin characteristic_N = mkN "caractéristique" feminine ; -- tocheck
lin pretty_Adv = variants{} ; -- 
lin empty_A = L.empty_A ;
lin display_N = mkN "représentation" feminine ; -- tocheck
lin combination_N = mkN "combinaison" feminine ; -- tocheck
lin interpretation_N = mkN "interprétation" ; -- tocheck
lin rely_V2 = variants{} ; -- 
lin rely_V = variants{} ; -- 
lin escape_VS = variants{}; -- mkV2 (mkV "échapper") | mkV2 (mkV "éviter") ; -- tocheck
lin escape_V2 = mkV2 (mkV "échapper") | mkV2 (mkV "éviter") ; -- tocheck
lin escape_V = variants{}; -- mkV2 (mkV "échapper") | mkV2 (mkV "éviter") ; -- tocheck
lin score_V2 = mkV2 (mkV "gagner") ; -- tocheck
lin score_V = variants{}; -- mkV2 (mkV "gagner") ; -- tocheck
lin justice_N = mkN "justice" | mkN "justice" feminine ; -- tocheck
lin upper_A = mkA "supérieur" ; -- tocheck
lin tooth_N = L.tooth_N ;
lin organize_V2V = mkV2V (mkV "organiser") ; -- tocheck
lin organize_V2 = variants{}; -- mkV2V (mkV "organiser") ; -- tocheck
lin cat_N = L.cat_N ;
lin tool_N = mkN "outil" masculine | mkN "mouton" masculine ; -- tocheck
lin spot_N = mkN "tache" feminine | mkN "endroit" masculine | mkN "peu" masculine | mkN "bouton" masculine ; -- tocheck
lin bridge_N = mkN "pont" masculine | mkN "bridge" masculine | mkN "pont" | mkN "passerelle" feminine | mkN "chevalet" masculine ; -- tocheck
lin double_A = variants{} ; -- 
lin direct_V2 = variants{} ; -- 
lin direct_V = variants{} ; -- 
lin conclude_VS = variants{}; -- mkV2 (mkV I.conclure_V2) ; -- tocheck
lin conclude_V2 = mkV2 (mkV I.conclure_V2) ; -- tocheck
lin conclude_V = variants{}; -- mkV2 (mkV I.conclure_V2) ; -- tocheck
lin relative_A = mkA "relatif" ; -- tocheck
lin soldier_N = mkN "soldat" masculine | mkN "mouillette" feminine ; -- tocheck
lin climb_V2 = mkV2 (mkV "grimper") | mkV2 (mkV "escalader") ; -- tocheck
lin climb_V = variants{}; -- mkV2 (mkV "grimper") | mkV2 (mkV "escalader") ; -- tocheck
lin breath_N = mkN "haleine" feminine | mkN "souffle" masculine | mkN "respiration" feminine ; -- tocheck
lin afford_V2V = mkV2V (reflV (mkV I.permettre_V2)) | mkV2V (mkV I.offrir_V2) ; -- tocheck
lin afford_V2 = variants{}; -- mkV2V (reflV (mkV I.permettre_V2)) | mkV2V (mkV I.offrir_V2) ; -- tocheck
lin urban_A = mkA "urbain" ; -- tocheck
lin nurse_N = mkN "infirmière" feminine | mkN "nourrice" feminine ; -- tocheck
lin narrow_A = L.narrow_A ;
lin liberal_A = mkA "généreux" ; -- tocheck
lin coal_N = mkN "charbon" masculine | mkN "charbon" ; -- tocheck
lin priority_N = mkN "priorité" feminine ; -- tocheck
lin wild_A = mkA "sauvage" ; -- tocheck
lin revenue_N = mkN "revenu" masculine ; -- tocheck
lin membership_N = mkN "adhésion" feminine | mkN "appartenance" feminine ; -- tocheck
lin grant_N = variants{} ; -- 
lin approve_V2 = mkV2 (mkV "approuver") ; -- tocheck
lin approve_V = variants{}; -- mkV2 (mkV "approuver") ; -- tocheck
lin tall_A = mkA "haut" | mkA "grand" ; -- tocheck
lin apparent_A = mkA "manifeste" | mkA "apparent" ; -- tocheck
lin faith_N = mkN "foi" feminine ; -- tocheck
lin under_Adv = mkAdv "moins" | mkAdv "dessous" ; -- tocheck
lin fix_V2 = mkV2 (mkV "fixer") | mkV2 (mkV "réparer") ; -- tocheck
lin fix_V = variants{}; -- mkV2 (mkV "fixer") | mkV2 (mkV "réparer") ; -- tocheck
lin slow_A = mkA "lent" ; -- tocheck
lin troop_N = variants{} ; -- 
lin motion_N = mkN "mouvement" masculine | mkN "motion" feminine ; -- tocheck
lin leading_A = variants{} ; -- 
lin component_N = mkN "composant" masculine ; -- tocheck
lin bloody_A = mkA "sanglant" | mkA "foutu" ; -- tocheck
lin literature_N = mkN "littérature" feminine ; -- tocheck
lin conservative_A = mkA "conservateur" ; -- tocheck
lin variation_N = mkN "variation" feminine ; -- tocheck
lin remind_V2 = variants{} ; -- 
lin inform_V2 = mkV2 (mkV "dénoncer") | mkV2 (mkV "informer") ; -- tocheck
lin inform_V = variants{}; -- mkV2 (mkV "dénoncer") | mkV2 (mkV "informer") ; -- tocheck
lin alternative_N = mkN "alternative" feminine ; -- tocheck
lin neither_Adv = variants{} ; -- 
lin outside_Adv = mkAdv "hors" | mkAdv "dehors" ; -- tocheck
lin mass_N = mkN "masse" feminine | mkN "messe" feminine ; -- tocheck
lin busy_A = mkA "occupé" ; -- tocheck
lin chemical_N = variants{} ; -- 
lin careful_A = mkA "prudent" | mkA "soigneux" ; -- tocheck
lin investigate_V2 = mkV2 (mkV "enquêter") | mkV2 (mkV "étudier") ; -- tocheck
lin investigate_V = variants{}; -- mkV2 (mkV "enquêter") | mkV2 (mkV "étudier") ; -- tocheck
lin roll_V2 = mkV2 (mkV "rouler") ; -- tocheck
lin roll_V = variants{}; -- mkV2 (mkV "rouler") ; -- tocheck
lin instrument_N = mkN "instrument" masculine ; -- tocheck
lin guide_N = mkN "guide" | mkN "guide" masculine ; -- tocheck
lin criterion_N = mkN "critère" masculine ; -- tocheck
lin pocket_N = mkN "poche" feminine ; -- tocheck
lin suggestion_N = mkN "suggestion" feminine ; -- tocheck
lin aye_Interj = variants{} ; -- 
lin entitle_VS = variants{} ; -- 
lin entitle_V2V = variants{} ; -- 
lin tone_N = mkN "ton" masculine | mkN "ton" ; -- tocheck
lin attractive_A = mkA "attractif" | mkA "attrayant" ; -- tocheck
lin wing_N = L.wing_N ;
lin surprise_N = mkN "surprise" | mkN "surprise" feminine ; -- tocheck
lin male_N = mkN "mâle" masculine | mkN "homme" masculine ; -- tocheck
lin ring_N = mkN "anneau" masculine | mkN "piste" feminine | mkN "cercle" masculine | mkN "ring" masculine ; -- tocheck
lin pub_N = mkN "pub" masculine ; -- tocheck
lin fruit_N = L.fruit_N ;
lin passage_N = mkN "passage" masculine ; -- tocheck
lin illustrate_VS = variants{}; -- mkV2 (mkV "illustrer") ; -- tocheck
lin illustrate_V2 = mkV2 (mkV "illustrer") ; -- tocheck
lin illustrate_V = variants{}; -- mkV2 (mkV "illustrer") ; -- tocheck
lin pay_N = variants{} ; -- 
lin ride_V2 = mkV2 (mkV "rouler") ; -- tocheck
lin ride_V = variants{}; -- mkV2 (mkV "rouler") ; -- tocheck
lin foundation_N = mkN "fondation" feminine ; -- tocheck
lin restaurant_N = L.restaurant_N ;
lin vital_A = mkA "vital" ; -- tocheck
lin alternative_A = mkA "alternatif" ; -- tocheck
lin burn_V2 = mkV2 (mkV "brûler") | mkV2 (mkV "graver") ; -- tocheck
lin burn_V = L.burn_V ;
lin map_N = mkN "plan" masculine | mkN "carte" feminine ; -- tocheck
lin united_A = variants{} ; -- 
lin device_N = mkN "appareil" masculine | mkN "stratagème" masculine ; -- tocheck
lin jump_V2 = variants{}; -- mkV2V (mkV "sauter") | mkV2V (mkV "sursauter") ; -- tocheck
lin jump_V = L.jump_V ;
lin estimate_VS = variants{}; -- mkV2V (mkV "estimer") ; -- tocheck
lin estimate_V2V = mkV2V (mkV "estimer") ; -- tocheck
lin estimate_V2 = variants{}; -- mkV2V (mkV "estimer") ; -- tocheck
lin estimate_V = variants{}; -- mkV2V (mkV "estimer") ; -- tocheck
lin conduct_V2 = mkV2 (reflV (mkV "comporter")) ; -- tocheck
lin conduct_V = variants{}; -- mkV2 (reflV (mkV "comporter")) ; -- tocheck
lin derive_V2 = mkV2 (mkV "dériver") | mkV2 (mkV I.déduire_V2) ; -- tocheck
lin derive_V = variants{}; -- mkV2 (mkV "dériver") | mkV2 (mkV I.déduire_V2) ; -- tocheck
lin comment_VS = variants{}; -- mkV2 (mkV "commenter") ; -- tocheck
lin comment_V2 = mkV2 (mkV "commenter") ; -- tocheck
lin comment_V = variants{}; -- mkV2 (mkV "commenter") ; -- tocheck
lin east_N = mkN "est" masculine ; -- tocheck
lin advise_VS = variants{}; -- mkV2 (mkV "conseiller") ; -- tocheck
lin advise_V2 = mkV2 (mkV "conseiller") ; -- tocheck
lin advise_V = variants{}; -- mkV2 (mkV "conseiller") ; -- tocheck
lin advance_N = mkN "avance" feminine | mkN "avancée" feminine ; -- tocheck
lin motor_N = mkN "moteur" masculine ; -- tocheck
lin satisfy_V2 = mkV2 (mkV I.satisfaire_V2) ; -- tocheck
lin hell_N = mkN "enfer" masculine ; -- tocheck
lin winner_N = mkN "gagnant" masculine ; -- tocheck
lin effectively_Adv = variants{} ; -- 
lin mistake_N = mkN "faute" feminine ; -- tocheck
lin incident_N = mkN "incident" masculine ; -- tocheck
lin focus_V2 = mkV2 (mkV "focaliser") | mkV2 (reflV (mkV "concentrer")) | mkV2 (mkV "concentrer") ; -- tocheck
lin focus_V = variants{}; -- mkV2 (mkV "focaliser") | mkV2 (reflV (mkV "concentrer")) | mkV2 (mkV "concentrer") ; -- tocheck
lin exercise_VV = variants{}; -- mkV2 (mkV "exercer") ; -- tocheck
lin exercise_V2 = mkV2 (mkV "exercer") ; -- tocheck
lin exercise_V = variants{}; -- mkV2 (mkV "exercer") ; -- tocheck
lin representation_N = mkN "représentation" ; -- tocheck
lin release_N = mkN "version" feminine ; -- tocheck
lin leaf_N = L.leaf_N ;
lin border_N = mkN "bordure" | mkN "bord" masculine | mkN "frontière" feminine ; -- tocheck
lin wash_V2 = L.wash_V2 ;
lin wash_V = variants{}; -- L.wash_V2 ;
lin prospect_N = mkN "perspective" feminine ; -- tocheck
lin blow_V2 = mkV2 (mkV "souffler") | mkV2 (mkV "jouer") | mkV2 (mkV "exploser") | mkV2 (mkV "sucer") | mkV2 (reflV (mkV "casser")) | mkV2 (mkV "claquer") ; -- tocheck
lin blow_V = L.blow_V ;
lin trip_N = mkN "trip" masculine ; -- tocheck
lin observation_N = mkN "observation" feminine | mkN "remarque" feminine ; -- tocheck
lin gather_V2 = mkV2 (mkV "rassembler") | mkV2 (mkV I.déduire_V2) ; -- tocheck
lin gather_V = variants{}; -- mkV2 (mkV "rassembler") | mkV2 (mkV I.déduire_V2) ; -- tocheck
lin ancient_A = mkA "antique" | mkA "ancien" ; -- tocheck
lin brief_A = mkA "bref" ; -- tocheck
lin gate_N = mkN "grille" feminine | mkN "portail" masculine | mkN "porte" feminine ; -- tocheck
lin elderly_A = mkA "vieux" ; -- tocheck
lin persuade_V2V = mkV2V (mkV "persuader") ; -- tocheck
lin persuade_V2 = variants{}; -- mkV2V (mkV "persuader") ; -- tocheck
lin overall_A = variants{} ; -- 
lin rare_A = mkA "saignant" | mkA "rare" ; -- tocheck
lin index_N = mkN "index" masculine ; -- tocheck
lin hand_V2 = mkV2 (mkV "donner") ; -- tocheck
lin circle_N = mkN "disque" masculine | mkN "cercle" masculine ; -- tocheck
lin creation_N = mkN "création" feminine ; -- tocheck
lin drawing_N = mkN "pige" feminine | mkN "dessin" masculine ; -- tocheck
lin anybody_NP = S.mkNP (mkPN "n'importe qui") ;
lin flow_N = mkN "écoulement" masculine | mkN "flux" masculine ; -- tocheck
lin matter_V = mkV (mkV "importer") ; -- tocheck
lin external_A = mkA "externe" ; -- tocheck
lin capable_A = mkA "capable" ; -- tocheck
lin recover_V = variants{}; -- mkV2V (mkV "récupérer") | mkV2V (mkV "recouvrer") ; -- tocheck
lin shot_N = mkN "poids" masculine | mkN "tir" masculine | mkN "dose" feminine | mkN "coup" masculine | mkN "plomb" masculine | mkN "piqure" feminine ; -- tocheck
lin request_N = mkN "requête" feminine | mkN "demande" feminine ; -- tocheck
lin impression_N = mkN "impression" feminine ; -- tocheck
lin neighbour_N = mkN "voisin" masculine ; -- tocheck
lin theatre_N = variants{} ; -- 
lin beneath_Prep = variants{} ; -- 
lin hurt_V2 = mkV2 (mkV "blesser") ; -- tocheck
lin hurt_V = variants{}; -- mkV2 (mkV "blesser") ; -- tocheck
lin mechanism_N = mkN "mechanisme" masculine ; -- tocheck
lin potential_N = mkN "possibilités" ; -- tocheck
lin lean_V2 = mkV2 (reflV (mkV "pencher")) | mkV2 (reflV (mkV "presser")) ; -- tocheck
lin lean_V = variants{}; -- mkV2 (reflV (mkV "pencher")) | mkV2 (reflV (mkV "presser")) ; -- tocheck
lin defendant_N = mkN "inculpé" ; -- tocheck
lin atmosphere_N = mkN "atmosphère" masculine | mkN "ambiance" feminine ; -- tocheck
lin slip_V2 = mkV2 (mkV "glisser") ; -- tocheck
lin slip_V = variants{}; -- mkV2 (mkV "glisser") ; -- tocheck
lin chain_N = mkN "chaîne" feminine ; -- tocheck
lin accompany_V2 = mkV2 (mkV "accompagner") ; -- tocheck
lin wonderful_A = mkA "merveilleux" ; -- tocheck
lin earn_V2 = mkV2 (mkV "mériter") | mkV2 (mkV "gagner") ; -- tocheck
lin earn_V = variants{}; -- mkV2 (mkV "mériter") | mkV2 (mkV "gagner") ; -- tocheck
lin enemy_N = L.enemy_N ;
lin desk_N = mkN "bureau" masculine ; -- tocheck
lin engineering_N = mkN "ingénierie" feminine ; -- tocheck
lin panel_N = mkN "panneau" | mkN "panneau" masculine | mkN "case" feminine ; -- tocheck
lin distinction_N = mkN "distinction" ; -- tocheck
lin deputy_N = mkN "adjoint" masculine | mkN "député" masculine ; -- tocheck
lin discipline_N = mkN "discipline" | mkN "discipline" feminine ; -- tocheck
lin strike_N = mkN "strike" masculine | mkN "coup" masculine | mkN "grève" feminine ; -- tocheck
lin strike_2_N = variants{} ; -- 
lin strike_1_N = variants{} ; -- 
lin married_A = variants{} ; -- 
lin plenty_NP = variants{} ; -- 
lin establishment_N = mkN "establishment" masculine | mkN "établissement" masculine ; -- tocheck
lin fashion_N = mkN "mode" feminine | mkN "façon" feminine ; -- tocheck
lin roof_N = L.roof_N ;
lin milk_N = L.milk_N ;
lin entire_A = mkA "entier" ; -- tocheck
lin tear_N = mkN "larme" feminine ; -- tocheck
lin secondary_A = mkA "secondaire" ; -- tocheck
lin finding_N = variants{} ; -- 
lin welfare_N = mkN "bien-être" masculine ; -- tocheck
lin increased_A = variants{} ; -- 
lin attach_V2 = mkV2 (mkV "attacher") ; -- tocheck
lin attach_V = variants{}; -- mkV2 (mkV "attacher") ; -- tocheck
lin typical_A = variants{} ; -- 
lin typical_3_A = variants{} ; -- 
lin typical_2_A = variants{} ; -- 
lin typical_1_A = variants{} ; -- 
lin meanwhile_Adv = variants{} ; -- 
lin leadership_N = mkN "autorité" feminine ; -- tocheck
lin walk_N = mkN "but-sur-balles" masculine | mkN "allée" feminine | mkN "démarche" feminine | mkN "promenade" feminine ; -- tocheck
lin negotiation_N = mkN "négociation" feminine ; -- tocheck
lin clean_A = L.clean_A ;
lin religion_N = L.religion_N ;
lin count_V2 = L.count_V2 ;
lin count_V = variants{}; -- L.count_V2 ;
lin grey_A = variants{} ; -- 
lin hence_Adv = mkAdv "ainsi" | mkAdv "d'où" | mkAdv "d'ici" ; -- tocheck
lin alright_Adv = variants{} ; -- 
lin first_A = variants{} ; -- 
lin fuel_N = mkN "carburant" masculine ; -- tocheck
lin mine_N = mkN "mine" feminine ; -- tocheck
lin appeal_V2 = variants{} ; -- 
lin appeal_V = variants{} ; -- 
lin servantMasc_N = mkN "domestique" | mkN "serviteur" masculine ;
lin liability_N = mkN "responsabilité" feminine ; -- tocheck
lin constant_A = mkA "constant" ; -- tocheck
lin hate_VV = variants{}; -- mkV2V (mkV I.haïr_V2) ; -- tocheck
lin hate_V2 = L.hate_V2 ;
lin shoe_N = L.shoe_N ;
lin expense_N = mkN "dépense" feminine ; -- tocheck
lin vast_A = mkA "vaste" ; -- tocheck
lin soil_N = mkN "terre" feminine | mkN "souillure" masculine | mkN "sol" masculine ; -- tocheck
lin writing_N = mkN "écriture" feminine | mkN "oeuvre" feminine ; -- tocheck
lin nose_N = L.nose_N ;
lin origin_N = mkN "origine" feminine | mkN "source" feminine ; -- tocheck
lin lord_N = mkN "seigneur" masculine | mkN "châtelain" ; -- tocheck
lin rest_V2 = mkV2 (reflV (mkV "reposer")) | mkV2 (mkV "rester") | mkV2 (mkV "reposer") ; -- tocheck
lin drive_N = mkN "lecteur" masculine | mkN "pulsion" feminine ; -- tocheck
lin ticket_N = mkN "billet" | mkN "billet" masculine | mkN "contravention" feminine ; -- tocheck
lin editor_N = mkN "rédacteur" masculine | mkN "monteuse" masculine | mkN "éditeur" masculine | mkN "monteur" masculine ; -- tocheck
lin switch_V2 = mkV2 (mkV "changer") | mkV2 (mkV "commuter") | mkV2 (mkV "échanger") ; -- tocheck
lin switch_V = variants{}; -- mkV2 (mkV "changer") | mkV2 (mkV "commuter") | mkV2 (mkV "échanger") ; -- tocheck
lin provided_Subj = variants{} ; -- 
lin northern_A = mkA "septentrional" | mkA "bise" ; -- tocheck
lin significance_N = mkN "signification" feminine ; -- tocheck
lin channel_N = mkN "chaîne" feminine ; -- tocheck
lin convention_N = mkN "convention" ; -- tocheck
lin damage_V2 = mkV2 (mkV "endommager") ; -- tocheck
lin funny_A = mkA "drôle" | mkA "étrange" ; -- tocheck
lin bone_N = L.bone_N ;
lin severe_A = mkA "sévère" ; -- tocheck
lin search_V2 = mkV2 (mkV "chercher") ; -- tocheck
lin search_V = mkV "chercher" ; -- tocheck
lin iron_N = L.iron_N ;
lin vision_N = mkN "vision" feminine | mkN "aspiration" feminine ; -- tocheck
lin via_Prep = variants{} ; -- 
lin somewhat_Adv = mkAdv "assez" ; -- tocheck
lin inside_Adv = variants{} ; -- 
lin trend_N = mkN "tendance" feminine | mkN "penchant" feminine ; -- tocheck
lin revolution_N = mkN "révolution" feminine | mkN "tour" masculine ; -- tocheck
lin terrible_A = mkA "terrible" | mkA "épouvantable" ; -- tocheck
lin knee_N = L.knee_N ;
lin dress_N = mkN "tenue" feminine | mkN "robe" feminine ; -- tocheck
lin unfortunately_Adv = variants{} ; -- 
lin steal_V2 = mkV2 (mkV "voler") ; -- tocheck
lin steal_V = variants{}; -- mkV2 (mkV "voler") ; -- tocheck
lin criminal_A = mkA "criminel" ; -- tocheck
lin signal_N = mkN "signal" masculine ; -- tocheck
lin notion_N = mkN "notion" feminine ; -- tocheck
lin comparison_N = mkN "comparaison" feminine ; -- tocheck
lin academic_A = mkA "académique" ; -- tocheck
lin outcome_N = mkN "issue" feminine ; -- tocheck
lin lawyer_N = mkN "juriste" ; -- tocheck
lin strongly_Adv = variants{} ; -- 
lin surround_V2 = mkV2 (mkV "entourer") | mkV2 (mkV I.enceindre_V2) ; -- tocheck
lin explore_VS = variants{}; -- mkV2 (mkV "explorer") ; -- tocheck
lin explore_V2 = mkV2 (mkV "explorer") ; -- tocheck
lin achievement_N = mkN "succès" masculine | mkN "réalisation" feminine ; -- tocheck
lin odd_A = mkA "bizarre" | mkA "impair" ; -- tocheck
lin expectation_N = mkN "attente" ; -- tocheck
lin corporate_A = variants{} ; -- 
lin prisoner_N = mkN "prisonnier" masculine ; -- tocheck
lin question_V2 = mkV2 (mkV "questionner") ; -- tocheck
lin rapidly_Adv = variants{} ; -- 
lin deep_Adv = variants{} ; -- 
lin southern_A = mkA "sudiste" | mkA "méridional" ; -- tocheck
lin amongst_Prep = variants{} ; -- 
lin withdraw_V2 = mkV2 (mkV "retirer") | mkV2 (reflV (mkV "retirer")) | mkV2 (mkV "tirer") ; -- tocheck
lin withdraw_V = variants{}; -- mkV2 (mkV "retirer") | mkV2 (reflV (mkV "retirer")) | mkV2 (mkV "tirer") ; -- tocheck
lin afterwards_Adv = mkAdv "après" ; -- tocheck
lin paint_V2 = mkV2 (mkV I.peindre_V2) ; -- tocheck
lin paint_V = variants{}; -- mkV2 (mkV I.peindre_V2) ; -- tocheck
lin judge_VS = variants{}; -- mkV2V (mkV "juger") ; -- tocheck
lin judge_V2 = variants{}; -- mkV2V (mkV "juger") ; -- tocheck
lin judge_V = variants{}; -- mkV2V (mkV "juger") ; -- tocheck
lin citizenMasc_N = mkN "citoyen" ;
lin permanent_A = mkA "permanent" ; -- tocheck
lin weak_A = mkA "faible" ; -- tocheck
lin separate_V2 = mkV2 (mkV "séparer") | mkV2 (reflV (mkV "séparer")) ; -- tocheck
lin separate_V = variants{}; -- mkV2 (mkV "séparer") | mkV2 (reflV (mkV "séparer")) ; -- tocheck
lin plastic_N = L.plastic_N ;
lin connect_V2 = mkV2 (mkV "accoupler") ; -- tocheck
lin connect_V = variants{}; -- mkV2 (mkV "accoupler") ; -- tocheck
lin fundamental_A = mkA "fondamental" ; -- tocheck
lin plane_N = mkN "avion" masculine | mkN "rabot" masculine | mkN "platane" masculine | mkN "plan" masculine ; -- tocheck
lin height_N = mkN "hauteur" feminine | mkN "taille" feminine ; -- tocheck
lin opening_N = mkN "ouverture" feminine | mkN "trou" masculine ; -- tocheck
lin lesson_N = mkN "leçon" feminine ; -- tocheck
lin similarly_Adv = variants{} ; -- 
lin shock_N = mkN "choc" masculine ; -- tocheck
lin rail_N = mkN "rails" masculine | mkN "rail" masculine | mkN "râle" masculine ; -- tocheck
lin tenant_N = mkN "occupant" masculine | mkN "locataire" ; -- tocheck
lin owe_V2 = mkV2 (mkV I.devoir_V2) ; -- tocheck
lin owe_V = variants{}; -- mkV2 (mkV I.devoir_V2) ; -- tocheck
lin originally_Adv = variants{} ; -- 
lin middle_A = mkA "milieu" ; -- tocheck
lin somehow_Adv = variants{} ; -- 
lin minor_A = variants{} ; -- 
lin negative_A = mkA "négatif" ; -- tocheck
lin knock_V2 = mkV2 (mkV "frapper") ; -- tocheck
lin knock_V = variants{}; -- mkV2 (mkV "frapper") ; -- tocheck
lin root_N = L.root_N ;
lin pursue_V2 = mkV2 (mkV I.poursuivre_V2) ; -- tocheck
lin pursue_V = variants{}; -- mkV2 (mkV I.poursuivre_V2) ; -- tocheck
lin inner_A = mkA "intérieur" ; -- tocheck
lin crucial_A = mkA "crucial" ; -- tocheck
lin occupy_V2 = mkV2 (mkV "occuper") ; -- tocheck
lin occupy_V = variants{}; -- mkV2 (mkV "occuper") ; -- tocheck
lin that_AdA = lin AdA (ss "tellement") ;
lin independence_N = mkN "indépendance" feminine ; -- tocheck
lin column_N = mkN "colonne" feminine | mkN "colonne" ; -- tocheck
lin proceeding_N = variants{} ; -- 
lin female_N = mkN "femelle" feminine ; -- tocheck
lin beauty_N = mkN "beauté" feminine ; -- tocheck
lin perfectly_Adv = variants{} ; -- 
lin struggle_N = mkN "lutte" feminine ; -- tocheck
lin gap_N = mkN "brèche" feminine | mkN "col" masculine | mkN "trouée" feminine ; -- tocheck
lin house_V2 = mkV2 (mkV "héberger") | mkV2 (mkV "garer") ; -- tocheck
lin database_N = variants{} ; -- 
lin stretch_V2 = mkV2 (reflV (mkV I.étendre_V2)) | mkV2 (reflV (mkV "étirer")) | mkV2 (mkV I.étendre_V2) ; -- tocheck
lin stretch_V = variants{}; -- mkV2 (reflV (mkV I.étendre_V2)) | mkV2 (reflV (mkV "étirer")) | mkV2 (mkV I.étendre_V2) ; -- tocheck
lin stress_N = mkN "stress" masculine | mkN "accentuation" feminine | mkN "tension" feminine ; -- tocheck
lin passenger_N = mkN "passager" masculine ; -- tocheck
lin boundary_N = mkN "frontière" feminine ; -- tocheck
lin easy_Adv = variants{} ; -- 
lin view_V2 = mkV2 (mkV "regarder") ; -- tocheck
lin manufacturer_N = mkN "fabricant" masculine ; -- tocheck
lin sharp_A = L.sharp_A ;
lin formation_N = variants{} ; -- 
lin queen_N = L.queen_N ;
lin waste_N = mkN "dégradation" feminine | mkN "fèces" | mkN "ordures" | mkN "gaspillage" masculine ; -- tocheck
lin virtually_Adv = variants{} ; -- 
lin expand_V2 = variants{}; -- mkV2V (mkV "agrandir") | mkV2V (mkV "élaborer") ; -- tocheck
lin expand_V = variants{}; -- mkV2V (mkV "agrandir") | mkV2V (mkV "élaborer") ; -- tocheck
lin contemporary_A = mkA "contemporain" ; -- tocheck
lin politician_N = mkN "politicien" masculine ; -- tocheck
lin back_V = variants{}; -- mkV2 (mkV I.soutenir_V2) ; -- tocheck
lin territory_N = mkN "territoire" masculine ; -- tocheck
lin championship_N = mkN "championnat" masculine | mkN "champion" masculine ; -- tocheck
lin exception_N = mkN "exception" feminine ; -- tocheck
lin thick_A = L.thick_A ;
lin inquiry_N = mkN "enquête" feminine ; -- tocheck
lin topic_N = mkN "sujet" masculine ; -- tocheck
lin resident_N = mkN "résident" masculine ; -- tocheck
lin transaction_N = variants{} ; -- 
lin parish_N = mkN "commune" feminine | mkN "paroisse" feminine ; -- tocheck
lin supporter_N = mkN "partisan" masculine ; -- tocheck
lin massive_A = mkA "massif" ; -- tocheck
lin light_V2 = mkV2 (mkV "allumer") ; -- tocheck
lin light_V = variants{}; -- mkV2 (mkV "allumer") ; -- tocheck
lin unique_A = mkA "unique" ; -- tocheck
lin challenge_V2 = mkV2 (mkV "défier") ; -- tocheck
lin challenge_V = variants{}; -- mkV2 (mkV "défier") ; -- tocheck
lin inflation_N = mkN "inflation" feminine ; -- tocheck
lin assistance_N = mkN "assistance" feminine ; -- tocheck
lin list_V2V = mkV2V (mkV "lister") ; -- tocheck
lin list_V2 = variants{}; -- mkV2V (mkV "lister") ; -- tocheck
lin list_V = variants{}; -- mkV2V (mkV "lister") ; -- tocheck
lin identity_N = mkN "identité" feminine ; -- tocheck
lin suit_V2 = mkV2 (mkV I.convenir_V2) ; -- tocheck
lin suit_V = variants{}; -- mkV2 (mkV I.convenir_V2) ; -- tocheck
lin parliamentary_A = mkA "parlementaire" ; -- tocheck
lin unknown_A = mkA "inconnu" ; -- tocheck
lin preparation_N = mkN "préparation" feminine ; -- tocheck
lin elect_V3 = mkV3 (mkV I.élire_V2) | mkV3 (mkV "choisir") ; -- tocheck
lin elect_V2V = variants{}; -- variants{}; -- mkV3 (mkV I.élire_V2) | mkV3 (mkV "choisir") ; -- tocheck
lin elect_V2 = variants{}; -- mkV3 (mkV I.élire_V2) | mkV3 (mkV "choisir") ; -- tocheck
lin elect_V = variants{}; -- mkV3 (mkV I.élire_V2) | mkV3 (mkV "choisir") ; -- tocheck
lin badly_Adv = variants{} ; -- 
lin moreover_Adv = variants{} ; -- 
lin tie_V2 = L.tie_V2 ;
lin tie_V = variants{}; -- L.tie_V2 ;
lin cancer_N = mkN "cancer" masculine ; -- tocheck
lin champion_N = mkN "champion" masculine ; -- tocheck
lin exclude_V2 = mkV2 (mkV I.exclure_V2) ; -- tocheck
lin review_V2 = variants{} ; -- 
lin review_V = variants{} ; -- 
lin licence_N = variants{} ; -- 
lin breakfast_N = variants{} ; -- 
lin minority_N = mkN "minorité" feminine | mkN "minorité" ; -- tocheck
lin appreciate_V2 = mkV2 (mkV "reconnaissant") ; -- tocheck
lin appreciate_V = variants{}; -- mkV2 (mkV "reconnaissant") ; -- tocheck
lin fan_N = variants{} ; -- 
lin fan_3_N = mkN "éventail" masculine ; -- tocheck
lin fan_2_N = mkN "fan" ; -- tocheck
lin fan_1_N = mkN "ventilateur" masculine ; -- tocheck
lin chief_N = variants{} ; -- 
lin accommodation_N = mkN "hébergement" | mkN "accommodation" ; -- tocheck
lin subsequent_A = mkA "subséquent" ; -- tocheck
lin democracy_N = mkN "démocratie" feminine ; -- tocheck
lin brown_A = L.brown_A ;
lin taste_N = mkN "avant-goût" masculine | mkN "goût" masculine ; -- tocheck
lin crown_N = mkN "milieu" masculine | mkN "couronne" feminine | mkN "clef" feminine | mkN "lauriers" | mkN "fond" masculine | mkN "sommet" masculine | mkN "couronnement" masculine | mkN "cime" feminine ; -- tocheck
lin permit_V2V = mkV2V (mkV I.permettre_V2) ; -- tocheck
lin permit_V2 = variants{}; -- mkV2V (mkV I.permettre_V2) ; -- tocheck
lin permit_V = variants{}; -- mkV2V (mkV I.permettre_V2) ; -- tocheck
lin buyerMasc_N = mkN "acheteur" masculine ;
lin gift_N = mkN "don" masculine | mkN "présent" masculine ; -- tocheck
lin resolution_N = mkN "résolution" feminine ; -- tocheck
lin angry_A = mkA "fâché" ; -- tocheck
lin metre_N = mkN "mètre" masculine ; -- tocheck
lin wheel_N = mkN "volant" masculine | mkN "roue" | mkN "roue" feminine ; -- tocheck
lin clause_N = variants{} ; -- 
lin break_N = mkN "espace" masculine | mkN "pause" feminine ; -- tocheck
lin tank_N = mkN "réservoir" masculine | mkN "cuve" feminine | mkN "citerne" feminine ; -- tocheck
lin benefit_V2 = variants{} ; -- 
lin benefit_V = variants{} ; -- 
lin engage_V2 = mkV2 (mkV "engager") | mkV2 (mkV "embrayer") ; -- tocheck
lin engage_V = variants{}; -- mkV2 (mkV "engager") | mkV2 (mkV "embrayer") ; -- tocheck
lin alive_A = mkA "vivant" ; -- tocheck
lin complaint_N = mkN "plainte" feminine ; -- tocheck
lin inch_N = mkN "pouce" masculine | mkN "poil" masculine ; -- tocheck
lin firm_A = variants{} ; -- 
lin abandon_V2 = mkV2 (mkV "abandonner") ; -- tocheck
lin blame_V2 = mkV2 (mkV "reprocher") ; -- tocheck
lin blame_V = variants{}; -- mkV2 (mkV "reprocher") ; -- tocheck
lin clean_V2 = mkV2 (mkV "nettoyer") | mkV2 (mkV "ranger") ; -- tocheck
lin clean_V = variants{}; -- mkV2 (mkV "nettoyer") | mkV2 (mkV "ranger") ; -- tocheck
lin quote_V2 = mkV2 (mkV "citer") | mkV2 (mkV "coter") ; -- tocheck
lin quote_V = variants{}; -- mkV2 (mkV "citer") | mkV2 (mkV "coter") ; -- tocheck
lin quantity_N = mkN "quantité" feminine ; -- tocheck
lin rule_VS = variants{}; -- mkV2 (mkV "gouverner") ; -- tocheck
lin rule_V2 = mkV2 (mkV "gouverner") ; -- tocheck
lin rule_V = variants{}; -- mkV2 (mkV "gouverner") ; -- tocheck
lin guilty_A = mkA "coupable" ; -- tocheck
lin prior_A = variants{} ; -- 
lin round_A = L.round_A ;
lin eastern_A = mkA "oriental" ; -- tocheck
lin coat_N = L.coat_N ;
lin involvement_N = mkN "implication" feminine ; -- tocheck
lin tension_N = mkN "tension" ; -- tocheck
lin diet_N = mkN "régime" ; -- tocheck
lin enormous_A = mkA "énorme" ; -- tocheck
lin score_N = mkN "partition" feminine | mkN "vingtaine" feminine ; -- tocheck
lin rarely_Adv = variants{} ; -- 
lin prize_N = mkN "prix" masculine ; -- tocheck
lin remaining_A = variants{} ; -- 
lin significantly_Adv = variants{} ; -- 
lin glance_V2 = variants{} ; -- 
lin glance_V = variants{} ; -- 
lin dominate_V2 = variants{} ; -- 
lin dominate_V = variants{} ; -- 
lin trust_VS = variants{} ; -- 
lin trust_V2 = variants{} ; -- 
lin naturally_Adv = variants{} ; -- 
lin interpret_V2 = mkV2 (mkV "interpréter") | mkV2 (mkV I.traduire_V2) ; -- tocheck
lin interpret_V = variants{}; -- mkV2 (mkV "interpréter") | mkV2 (mkV I.traduire_V2) ; -- tocheck
lin land_V2 = mkV2 (mkV "poser") | mkV2 (reflV (mkV "poser")) ; -- tocheck
lin land_V = variants{}; -- mkV2 (mkV "poser") | mkV2 (reflV (mkV "poser")) ; -- tocheck
lin frame_N = mkN "trame" | mkN "manche" feminine | mkN "image" feminine | mkN "cadre" masculine | mkN "ossature" feminine ; -- tocheck
lin extension_N = mkN "extension" feminine ; -- tocheck
lin mix_V2 = mkV2 (mkV "mélanger") | mkV2 (mkV "mixer") ; -- tocheck
lin mix_V = variants{}; -- mkV2 (mkV "mélanger") | mkV2 (mkV "mixer") ; -- tocheck
lin spokesman_N = mkN "porte-parole" ; -- tocheck
lin friendly_A = mkA "amical" | mkA "allié" ; -- tocheck
lin acknowledge_VS = variants{}; -- mkV2 (mkV I.reconnaître_V2) | mkV2 (mkV "certifier") ; -- tocheck
lin acknowledge_V2 = mkV2 (mkV I.reconnaître_V2) | mkV2 (mkV "certifier") ; -- tocheck
lin register_V2 = mkV2 (mkV "recaler") | mkV2 (mkV I.inscrire_V2) | mkV2 (mkV "enregistrer") | mkV2 (mkV "imprimer") ; -- tocheck
lin register_V = variants{}; -- mkV2 (mkV "recaler") | mkV2 (mkV I.inscrire_V2) | mkV2 (mkV "enregistrer") | mkV2 (mkV "imprimer") ; -- tocheck
lin regime_N = variants{} ; -- 
lin regime_2_N = variants{} ; -- 
lin regime_1_N = variants{} ; -- 
lin fault_N = mkN "défaut" | mkN "faille" feminine | mkN "faute" feminine ; -- tocheck
lin dispute_N = mkN "dispute" masculine ; -- tocheck
lin grass_N = L.grass_N ;
lin quietly_Adv = variants{} ; -- 
lin decline_N = mkN "déclin" ; -- tocheck
lin dismiss_V2 = mkV2 (mkV "retirer") | mkV2 (mkV I.renvoyer_V2) | mkV2 (mkV "rejeter") ; -- tocheck
lin delivery_N = mkN "accouchement" | mkN "administration" | mkN "livraison" feminine ; -- tocheck
lin complain_VS = variants{}; -- mkV (mkV I.plaindre_V2) ; -- tocheck
lin complain_V = mkV (mkV I.plaindre_V2) ; -- tocheck
lin conservative_N = mkN "conservateur" ; -- tocheck
lin shift_V2 = variants{} ; -- 
lin shift_V = variants{} ; -- 
lin port_N = mkN "port" masculine ; -- tocheck
lin beach_N = mkN "plage" feminine ; -- tocheck
lin string_N = mkN "suite" feminine | mkN "corde" feminine | mkN "cordes" ; -- tocheck
lin depth_N = mkN "profondeur" feminine ; -- tocheck
lin unusual_A = mkA "inhabituel" ; -- tocheck
lin travel_N = mkN "voyage" masculine ; -- tocheck
lin pilot_N = mkN "pilote" masculine ; -- tocheck
lin obligation_N = mkN "obligation" feminine | mkN "engagement" masculine ; -- tocheck
lin gene_N = mkN "gène" masculine ; -- tocheck
lin yellow_A = L.yellow_A ;
lin republic_N = mkN "république" feminine ; -- tocheck
lin shadow_N = mkN "ombre" feminine ; -- tocheck
lin dear_A = mkA "cher" ; -- tocheck
lin analyse_V2 = variants{} ; -- 
lin anywhere_Adv = mkAdv "n'importe où" ;
lin average_N = mkN "moyenne" feminine ; -- tocheck
lin phrase_N = mkN "expression" feminine | mkN "syntagme" masculine | mkN "phrase" feminine ; -- tocheck
lin long_term_A = variants{} ; -- 
lin crew_N = mkN "équipe" masculine | mkN "équipage" masculine ; -- tocheck
lin lucky_A = mkA "fortuné" | mkA "chanceux" ; -- tocheck
lin restore_V2 = mkV2 (mkV "restaurer") ; -- tocheck
lin convince_V2V = mkV2V (mkV I.convaincre_V2) ; -- tocheck
lin convince_V2 = variants{}; -- mkV2V (mkV I.convaincre_V2) ; -- tocheck
lin coast_N = mkN "côte" feminine ; -- tocheck
lin engineer_N = mkN "ingénieur" | mkN "machiniste" masculine ; -- tocheck
lin heavily_Adv = variants{} ; -- 
lin extensive_A = mkA "étendu" ; -- tocheck
lin glad_A = mkA "content" ; -- tocheck
lin charity_N = mkN "charité" feminine ; -- tocheck
lin oppose_V2 = mkV2 (mkV "opposer") ; -- tocheck
lin oppose_V = variants{}; -- mkV2 (mkV "opposer") ; -- tocheck
lin defend_V2 = mkV2 (mkV I.défendre_V2) ; -- tocheck
lin alter_V2 = variants{} ; -- 
lin alter_V = variants{} ; -- 
lin warning_N = mkN "avertir" masculine | mkN "avertissement" masculine ; -- tocheck
lin arrest_V2 = mkV2 (mkV "arrêter") ; -- tocheck
lin framework_N = mkN "charpente" | mkN "structure" ; -- tocheck
lin approval_N = mkN "approbation" feminine | mkN "agrément" masculine ; -- tocheck
lin bother_VV = variants{}; -- mkV2V (mkV "embêter") | mkV2V (mkV "bâdrer") ; -- tocheck
lin bother_V2V = mkV2V (mkV "embêter") | mkV2V (mkV "bâdrer") ; -- tocheck
lin bother_V2 = variants{}; -- mkV2V (mkV "embêter") | mkV2V (mkV "bâdrer") ; -- tocheck
lin bother_V = variants{}; -- mkV2V (mkV "embêter") | mkV2V (mkV "bâdrer") ; -- tocheck
lin novel_N = mkN "roman" masculine ; -- tocheck
lin accuse_V2 = mkV2 (mkV "accuser") ; -- tocheck
lin surprised_A = variants{} ; -- 
lin currency_N = mkN "monnaie" feminine ; -- tocheck
lin restrict_V2 = mkV2 (mkV I.restreindre_V2) ; -- tocheck
lin restrict_V = variants{}; -- mkV2 (mkV I.restreindre_V2) ; -- tocheck
lin possess_V2 = mkV2 (mkV "posséder") ; -- tocheck
lin moral_A = mkA "moral" ; -- tocheck
lin protein_N = mkN "protéine" feminine ; -- tocheck
lin distinguish_V2 = mkV2 (mkV "distinguer") ; -- tocheck
lin distinguish_V = variants{}; -- mkV2 (mkV "distinguer") ; -- tocheck
lin gently_Adv = mkAdv "doucement" ;
lin reckon_VS = variants{}; -- mkV2 (mkV "estimer") ; -- tocheck
lin incorporate_V2 = mkV2 (mkV "incorporer") ; -- tocheck
lin proceed_V = variants{}; -- mkV2 (mkV "procéder") ; -- tocheck
lin assist_V2 = mkV2 (mkV "assister") ; -- tocheck
lin assist_V = variants{}; -- mkV2 (mkV "assister") ; -- tocheck
lin sure_Adv = variants{} ; -- 
lin stress_VS = variants{}; -- mkV2 (mkV "stresser") | mkV2 (mkV "souligner") | mkV2 (mkV "emphaser") ; -- tocheck
lin stress_V2 = mkV2 (mkV "stresser") | mkV2 (mkV "souligner") | mkV2 (mkV "emphaser") ; -- tocheck
lin justify_VV = variants{}; -- mkV2 (mkV "justifier") ; -- tocheck
lin justify_V2 = mkV2 (mkV "justifier") ; -- tocheck
lin behalf_N = variants{} ; -- 
lin councillor_N = variants{} ; -- 
lin setting_N = mkN "réglage" masculine ; -- tocheck
lin command_N = variants{} ; -- 
lin command_2_N = variants{} ; -- 
lin command_1_N = variants{} ; -- 
lin maintenance_N = mkN "entretien" masculine ; -- tocheck
lin stair_N = mkN "escalier" | mkN "marche" feminine ; -- tocheck
lin poem_N = mkN "poème" masculine ; -- tocheck
lin chest_N = mkN "coffre" masculine | mkN "poitrine" feminine ; -- tocheck
lin like_Adv = mkAdv "comme" ; -- tocheck
lin secret_N = mkN "secret" masculine ; -- tocheck
lin restriction_N = variants{} ; -- 
lin efficient_A = mkA "efficace" ; -- tocheck
lin suspect_VS = variants{}; -- mkV2 (mkV "soupçonner") ; -- tocheck
lin suspect_V2 = mkV2 (mkV "soupçonner") ; -- tocheck
lin hat_N = L.hat_N ;
lin tough_A = variants{} ; -- 
lin firmly_Adv = variants{} ; -- 
lin willing_A = mkA "volontaire" ; -- tocheck
lin healthy_A = mkA "sain" ; -- tocheck
lin focus_N = mkN "attention" feminine | mkN "épicentre" masculine | mkN "foyer" masculine ; -- tocheck
lin construct_V2 = mkV2 (mkV I.construire_V2) ; -- tocheck
lin occasionally_Adv = variants{} ; -- 
lin mode_N = mkN "mode" feminine ; -- tocheck
lin saving_N = variants{} ; -- 
lin comfortable_A = mkA "confortable" ; -- tocheck
lin camp_N = mkN "camp" masculine ; -- tocheck
lin trade_V2 = mkV2 (mkV "échanger") ; -- tocheck
lin trade_V = variants{}; -- mkV2 (mkV "échanger") ; -- tocheck
lin export_N = variants{} ; -- 
lin wake_V2 = mkV2 (mkV "réveiller") | mkV2 (reflV (mkV "réveiller")) ; -- tocheck
lin wake_V = variants{}; -- mkV2 (mkV "réveiller") | mkV2 (reflV (mkV "réveiller")) ; -- tocheck
lin partnership_N = variants{} ; -- 
lin daily_A = mkA "quotidien" ; -- tocheck
lin abroad_Adv = variants{} ; -- 
lin profession_N = mkN "profession" feminine ; -- tocheck
lin load_N = mkN "charge" feminine ; -- tocheck
lin countryside_N = mkN "campagne" feminine ; -- tocheck
lin boot_N = L.boot_N ;
lin mostly_Adv = mkAdv "surtout" ; -- tocheck
lin sudden_A = mkA "soudain" ; -- tocheck
lin implement_V2 = mkV2 (mkV "appliquer") ; -- tocheck
lin reputation_N = mkN "réputation" feminine ; -- tocheck
lin print_V2 = mkV2 (mkV "imprimer") ; -- tocheck
lin print_V = variants{}; -- mkV2 (mkV "imprimer") ; -- tocheck
lin calculate_VS = variants{}; -- mkV2 (mkV "calculer") ; -- tocheck
lin calculate_V2 = mkV2 (mkV "calculer") ; -- tocheck
lin calculate_V = variants{}; -- mkV2 (mkV "calculer") ; -- tocheck
lin keen_A = variants{} ; -- 
lin guess_VS = variants{}; -- mkV2 (mkV "deviner") | mkV2 (mkV I.déduire_V2) | mkV2 (mkV "supposer") ; -- tocheck
lin guess_V2 = mkV2 (mkV "deviner") | mkV2 (mkV I.déduire_V2) | mkV2 (mkV "supposer") ; -- tocheck
lin guess_V = variants{}; -- mkV2 (mkV "deviner") | mkV2 (mkV I.déduire_V2) | mkV2 (mkV "supposer") ; -- tocheck
lin recommendation_N = mkN "recommandation" feminine ; -- tocheck
lin autumn_N = mkN "automne" masculine ; -- tocheck
lin conventional_A = mkA "conventionnel" ; -- tocheck
lin cope_V = mkV (reflV (mkV "débrouiller")) ; -- tocheck
lin constitute_V2 = mkV2 (mkV "constituer") ; -- tocheck
lin poll_N = mkN "sondage" masculine ; -- tocheck
lin voluntary_A = mkA "volontaire" | mkA "bénévole" ; -- tocheck
lin valuable_A = mkA "précieux" ; -- tocheck
lin recovery_N = mkN "récupération" feminine | mkN "guérison" feminine ; -- tocheck
lin cast_V2 = mkV2 (mkV "jeter") | mkV2 (mkV "sonder") | mkV2 (mkV "couler") ; -- tocheck
lin cast_V = variants{}; -- mkV2 (mkV "jeter") | mkV2 (mkV "sonder") | mkV2 (mkV "couler") ; -- tocheck
lin premise_N = variants{} ; -- 
lin resolve_V2 = mkV2 (mkV I.résoudre_V2) | mkV2 (reflV (mkV I.résoudre_V2)) ; -- tocheck
lin resolve_V = variants{}; -- mkV2 (mkV I.résoudre_V2) | mkV2 (reflV (mkV I.résoudre_V2)) ; -- tocheck
lin regularly_Adv = variants{} ; -- 
lin solve_V2 = mkV2 (mkV I.résoudre_V2) ; -- tocheck
lin plaintiff_N = mkN "demandeur" ; -- tocheck
lin critic_N = mkN "critique" | mkN "critique" masculine ; -- tocheck
lin agriculture_N = mkN "agriculture" feminine ; -- tocheck
lin ice_N = L.ice_N ;
lin constitution_N = mkN "constitution" feminine ; -- tocheck
lin communist_N = mkN "communiste" ; -- tocheck
lin layer_N = mkN "pondeuse" feminine | mkN "couche" feminine | mkN "marcotte" feminine ; -- tocheck
lin recession_N = mkN "récession" feminine ; -- tocheck
lin slight_A = mkA "insignifiant" ; -- tocheck
lin dramatic_A = mkA "dramatique" | mkA "spectaculaire" ; -- tocheck
lin golden_A = mkA "doré" | mkA "d'or" ; -- tocheck
lin temporary_A = mkA "temporaire" ; -- tocheck
lin suit_N = mkN "enseigne" feminine | mkN "procès" masculine | mkN "suite" feminine | mkN "combinaison" feminine | mkN "costard" masculine | mkN "complet" masculine ; -- tocheck
lin shortly_Adv = variants{} ; -- 
lin initially_Adv = variants{} ; -- 
lin arrival_N = mkN "arrivée" feminine ; -- tocheck
lin protest_N = mkN "protestation" feminine | mkN "manifestation" feminine ; -- tocheck
lin resistance_N = mkN "résistance" | mkN "résistance" feminine ; -- tocheck
lin silent_A = mkA "silencieux" ; -- tocheck
lin presentation_N = mkN "exposé" masculine ; -- tocheck
lin soul_N = mkN "âme" feminine | mkN "soul" feminine ; -- tocheck
lin self_N = mkN "soi-même" masculine ; -- tocheck
lin judgment_N = mkN "jugement" | mkN "jugement" masculine ; -- tocheck
lin feed_V2 = mkV2 (mkV "nourrir") | mkV2 (mkV "manger") ; -- tocheck
lin feed_V = variants{}; -- mkV2 (mkV "nourrir") | mkV2 (mkV "manger") ; -- tocheck
lin muscle_N = mkN "muscle" masculine ; -- tocheck
lin shareholder_N = mkN "actionnaire" ; -- tocheck
lin opposite_A = mkA "opposé" ; -- tocheck
lin pollution_N = mkN "défilement" masculine | mkN "pollution" feminine ; -- tocheck
lin wealth_N = mkN "profusion" feminine | mkN "richesse" feminine ; -- tocheck
lin video_taped_A = variants{} ; -- 
lin kingdom_N = mkN "royaume" masculine | mkN "règne" masculine ; -- tocheck
lin bread_N = L.bread_N ;
lin perspective_N = mkN "perspective" feminine ; -- tocheck
lin camera_N = L.camera_N ;
lin prince_N = mkN "prince" masculine ; -- tocheck
lin illness_N = mkN "maladie" feminine ; -- tocheck
lin cake_N = mkN "gâteau" ; -- tocheck
lin meat_N = L.meat_N ;
lin submit_V2 = mkV2 (mkV "présenter") ; -- tocheck
lin submit_V = variants{}; -- mkV2 (mkV "présenter") ; -- tocheck
lin ideal_A = mkA "idéal" ; -- tocheck
lin relax_V2 = mkV2 (reflV (mkV I.détendre_V2)) | mkV2 (mkV "relâcher") ; -- tocheck
lin relax_V = variants{}; -- mkV2 (reflV (mkV I.détendre_V2)) | mkV2 (mkV "relâcher") ; -- tocheck
lin penalty_N = mkN "penalty" masculine | mkN "penalisation" feminine | mkN "peine" feminine ; -- tocheck
lin purchase_V2 = mkV2 (mkV "acheter") | mkV2 (mkV I.acquérir_V2) ; -- tocheck
lin tired_A = variants{} ; -- 
lin beer_N = L.beer_N ;
lin specify_VS = variants{}; -- mkV2 (mkV "spécifier") ; -- tocheck
lin specify_V2 = mkV2 (mkV "spécifier") ; -- tocheck
lin specify_V = variants{}; -- mkV2 (mkV "spécifier") ; -- tocheck
lin short_Adv = variants{} ; -- 
lin monitor_V2 = mkV2 (mkV "contrôler") ; -- tocheck
lin monitor_V = variants{}; -- mkV2 (mkV "contrôler") ; -- tocheck
lin electricity_N = mkN "électricité" feminine ; -- tocheck
lin specifically_Adv = variants{} ; -- 
lin bond_N = mkN "alliance" feminine | mkN "obligation" feminine | mkN "liaison" | mkN "lien" | mkN "appareil" masculine | mkN "lien" masculine ; -- tocheck
lin statutory_A = mkA "statutaire" ; -- tocheck
lin laboratory_N = mkN "laboratoire" masculine ; -- tocheck
lin federal_A = variants{} ; -- 
lin captain_N = mkN "capitaine" ; -- tocheck
lin deeply_Adv = variants{} ; -- 
lin pour_V2 = mkV2 (mkV "verser") | mkV2 (reflV (mkV "déverser")) ; -- tocheck
lin pour_V = variants{}; -- mkV2 (mkV "verser") | mkV2 (reflV (mkV "déverser")) ; -- tocheck
lin boss_N = L.boss_N ;
lin creature_N = mkN "créature" feminine ; -- tocheck
lin urge_VS = variants{}; -- mkV2V (mkV "insister") | mkV2V (mkV "pousser") | mkV2V (mkV "inciter") | mkV2V (mkV "provoquer") ; -- tocheck
lin urge_V2V = mkV2V (mkV "insister") | mkV2V (mkV "pousser") | mkV2V (mkV "inciter") | mkV2V (mkV "provoquer") ; -- tocheck
lin urge_V2 = variants{}; -- mkV2V (mkV "insister") | mkV2V (mkV "pousser") | mkV2V (mkV "inciter") | mkV2V (mkV "provoquer") ; -- tocheck
lin locate_V2 = mkV2 (reflV (mkV "poser")) | mkV2 (mkV "situer") ; -- tocheck
lin locate_V = variants{}; -- mkV2 (reflV (mkV "poser")) | mkV2 (mkV "situer") ; -- tocheck
lin being_N = mkN "créature" feminine | mkN "existence" ; -- tocheck
lin struggle_VV = variants{}; -- mkV (mkV "lutter") ; -- tocheck
lin struggle_V = mkV (mkV "lutter") ; -- tocheck
lin lifespan_N = variants{} ; -- 
lin flat_A = mkA "plan" | mkA "bémol" | mkA "bas" | mkA "ennuyeux" | mkA "plat" ; -- tocheck
lin valley_N = mkN "vallée" feminine ; -- tocheck
lin like_A = mkA "pareil" ; -- tocheck
lin guard_N = mkN "garde" | mkN "garde" feminine | mkN "gardien" masculine ; -- tocheck
lin emergency_N = mkN "urgences" | mkN "urgence" feminine ; -- tocheck
lin dark_N = mkN "obscurité" | mkN "noir" masculine ; -- tocheck
lin bomb_N = mkN "bombe" feminine ; -- tocheck
lin dollar_N = mkN "dollar" masculine ; -- tocheck
lin efficiency_N = mkN "rendement" ; -- tocheck
lin mood_N = mkN "humeur" feminine | mkN "mode" masculine ; -- tocheck
lin convert_V2 = mkV2 (mkV "convertir") ; -- tocheck
lin convert_V = variants{}; -- mkV2 (mkV "convertir") ; -- tocheck
lin possession_N = mkN "possession" feminine | mkN "bien" masculine ; -- tocheck
lin marketing_N = mkN "mercatique" feminine ; -- tocheck
lin please_VV = variants{}; -- mkV2V (mkV I.plaire_V2) ; -- tocheck
lin please_V2V = mkV2V (mkV I.plaire_V2) ; -- tocheck
lin please_V2 = mkV2 (mkV I.plaire_V2) P.dative ;
lin please_V = I.plaire_V2 ;
lin habit_N = mkN "habitude" feminine ; -- tocheck
lin subsequently_Adv = variants{} ; -- 
lin round_N = mkN "rond" masculine | mkN "ronde" feminine | mkN "tour" masculine | mkN "coup" masculine | mkN "éclat" masculine | mkN "round" masculine | mkN "tournée" feminine | mkN "canon" masculine | mkN "épreuve" feminine ; -- tocheck
lin purchase_N = mkN "achat" masculine ; -- tocheck
lin sort_V2 = mkV2 (mkV "trier") ; -- tocheck
lin sort_V = variants{}; -- mkV2 (mkV "trier") ; -- tocheck
lin outside_A = mkA "dehors" ; -- tocheck
lin gradually_Adv = variants{} ; -- 
lin expansion_N = mkN "expansion" feminine ; -- tocheck
lin competitive_A = variants{} ; -- 
lin cooperation_N = mkN "coopération" feminine ; -- tocheck
lin acceptable_A = mkA "acceptable" ; -- tocheck
lin angle_N = mkN "angle" masculine ; -- tocheck
lin cook_V2 = mkV2 (mkV I.cuire_V2) | mkV2 (mkV "cuisiner") ; -- tocheck
lin cook_V = variants{}; -- mkV2 (mkV I.cuire_V2) | mkV2 (mkV "cuisiner") ; -- tocheck
lin net_A = mkA "net" ; -- tocheck
lin sensitive_A = mkA "sensible" ; -- tocheck
lin ratio_N = mkN "rapport" | mkN "rapport" masculine ; -- tocheck
lin kiss_V2 = mkV2 (mkV "embrasser") | mkV2 (reflV (mkV "embrasser")) | mkV2 (mkV "effleurer") ; -- tocheck
lin amount_V = mkV (mkV I.correspondre_V2) | mkV (mkV "monter") ; -- tocheck
lin sleep_N = mkN "sommeil" masculine | mkN "chassie" feminine ; -- tocheck
lin finance_V2 = mkV2 (mkV "financer") ; -- tocheck
lin essentially_Adv = variants{} ; -- 
lin fund_V2 = mkV2 (mkV "financer") ; -- tocheck
lin preserve_V2 = mkV2 (mkV "préserver") ; -- tocheck
lin wedding_N = mkN "mariage" masculine ; -- tocheck
lin personality_N = mkN "personnalité" feminine ; -- tocheck
lin bishop_N = mkN "évêque" masculine | mkN "fou" masculine ; -- tocheck
lin dependent_A = mkA "dépendant" ; -- tocheck
lin landscape_N = mkN "paysage" ; -- tocheck
lin pure_A = mkA "pur" ; -- tocheck
lin mirror_N = mkN "copie" feminine | mkN "glace" feminine ; -- tocheck
lin lock_V2 = mkV2 (mkV "fermer") ; -- tocheck
lin lock_V = variants{}; -- mkV2 (mkV "fermer") ; -- tocheck
lin symptom_N = mkN "symptôme" masculine ; -- tocheck
lin promotion_N = mkN "promotion" feminine ; -- tocheck
lin global_A = mkA "global" | mkA "globulaire" ; -- tocheck
lin aside_Adv = variants{} ; -- 
lin tendency_N = mkN "tendance" feminine ; -- tocheck
lin conservation_N = mkN "défense" feminine | mkN "préservation" feminine ; -- tocheck
lin reply_N = mkN "réponse" feminine ; -- tocheck
lin estimate_N = mkN "estimation" feminine ; -- tocheck
lin qualification_N = mkN "qualification" feminine ; -- tocheck
lin pack_V2 = mkV2 (mkV "emballer") ; -- tocheck
lin pack_V = variants{}; -- mkV2 (mkV "emballer") ; -- tocheck
lin governor_N = mkN "gouverneur" masculine ; -- tocheck
lin expected_A = variants{} ; -- 
lin invest_V2 = mkV2 (mkV "investir") ; -- tocheck
lin invest_V = variants{}; -- mkV2 (mkV "investir") ; -- tocheck
lin cycle_N = mkN "tour" masculine | mkN "cycle" masculine ; -- tocheck
lin alright_A = variants{} ; -- 
lin philosophy_N = mkN "philosophie" feminine | mkN "philosophie" ; -- tocheck
lin gallery_N = mkN "balcon" masculine | mkN "galerie" feminine ; -- tocheck
lin sad_A = mkA "triste" ; -- tocheck
lin intervention_N = mkN "intervention" ; -- tocheck
lin emotional_A = mkA "émotionnel" ; -- tocheck
lin advertising_N = mkN "publicité" ; -- tocheck
lin regard_N = mkN "regard" ;
lin dance_V2 = mkV2 (mkV "danser") ; -- tocheck
lin dance_V = variants{}; -- mkV2 (mkV "danser") ; -- tocheck
lin cigarette_N = mkN "cigarette" feminine ; -- tocheck
lin predict_VS = variants{}; -- mkV2 (mkV I.prédire_V2) ; -- tocheck
lin predict_V2 = mkV2 (mkV I.prédire_V2) ; -- tocheck
lin adequate_A = mkA "adéquat" ; -- tocheck
lin variable_N = mkN "variable" feminine ; -- tocheck
lin net_N = mkN "réseau" masculine | mkN "filet" masculine | mkN "netto" masculine ; -- tocheck
lin retire_V2 = mkV2 (reflV (mkV "retirer")) ; -- tocheck
lin retire_V = variants{}; -- mkV2 (reflV (mkV "retirer")) ; -- tocheck
lin sugar_N = mkN "bise" feminine | mkN "sucre" masculine ; -- tocheck
lin pale_A = mkA "pâle" ; -- tocheck
lin frequency_N = mkN "fréquence" feminine ; -- tocheck
lin guy_N = mkN "hauban" masculine | mkN "gars" | mkN "mec" masculine ; -- tocheck
lin feature_V2 = variants{} ; -- 
lin furniture_N = mkN "mobilier" masculine ; -- tocheck
lin administrative_A = mkA "administratif" ; -- tocheck
lin wooden_A = variants{} ; -- 
lin input_N = mkN "entrée" feminine ; -- tocheck
lin phenomenon_N = mkN "phénomène" masculine ; -- tocheck
lin surprising_A = mkA "surprenant" ; -- tocheck
lin jacket_N = mkN "veste" feminine | mkN "couverture" feminine ; -- tocheck
lin actor_N = mkN "acteur" masculine | mkN "faiseur" masculine ; -- tocheck
lin actor_2_N = variants{} ; -- 
lin actor_1_N = variants{} ; -- 
lin kick_V2 = variants{} ; -- 
lin kick_V = variants{} ; -- 
lin producer_N = mkN "producteur" masculine ; -- tocheck
lin hearing_N = mkN "ouïe" feminine | mkN "audience" feminine ; -- tocheck
lin chip_N = mkN "micropuce" feminine | mkN "frite" | mkN "chips" feminine | mkN "brisure" feminine ; -- tocheck
lin equation_N = mkN "équation" feminine ; -- tocheck
lin certificate_N = mkN "document" ; -- tocheck
lin hello_Interj = mkInterj "allô" ; -- tocheck
lin remarkable_A = variants{} ; -- 
lin alliance_N = mkN "alliance" feminine ; -- tocheck
lin smoke_V2 = mkV2 (mkV I.descendre_V2) | mkV2 (mkV "fumer") ; -- tocheck
lin smoke_V = variants{}; -- mkV2 (mkV I.descendre_V2) | mkV2 (mkV "fumer") ; -- tocheck
lin awareness_N = mkN "conscience" feminine | mkN "connaissance" feminine ; -- tocheck
lin throat_N = mkN "goulot" | mkN "gorge" feminine ; -- tocheck
lin discovery_N = mkN "découverte" feminine ; -- tocheck
lin festival_N = mkN "festival" masculine ; -- tocheck
lin dance_N = mkN "danse" feminine ; -- tocheck
lin promise_N = mkN "voeu" masculine | mkN "promesse" feminine ; -- tocheck
lin rose_N = mkN "rosacée" feminine | mkN "rose" feminine | mkN "pomme" ; -- tocheck
lin principal_A = mkA "principal" ; -- tocheck
lin brilliant_A = mkA "brillant" ; -- tocheck
lin proposed_A = variants{} ; -- 
lin coach_N = mkN "coche" masculine | mkN "voiture" feminine | mkN "entraîneur" masculine ; -- tocheck
lin coach_3_N = variants{} ; -- 
lin coach_2_N = variants{} ; -- 
lin coach_1_N = variants{} ; -- 
lin absolute_A = mkA "absolu" ; -- tocheck
lin drama_N = mkN "drame" masculine ; -- tocheck
lin recording_N = mkN "enregistrement" masculine ; -- tocheck
lin precisely_Adv = variants{} ; -- 
lin bath_N = mkN "bain" masculine ; -- tocheck
lin celebrate_V2 = mkV2 (mkV "fêter") | mkV2 (mkV "célébrer") ; -- tocheck
lin substance_N = mkN "substance" feminine ; -- tocheck
lin swing_V2 = mkV2 (mkV "osciller") | mkV2 (mkV "swinguer") | mkV2 (reflV (mkV "balancer")) ; -- tocheck
lin swing_V = variants{}; -- mkV2 (mkV "osciller") | mkV2 (mkV "swinguer") | mkV2 (reflV (mkV "balancer")) ; -- tocheck
lin for_Adv = mkAdv "pour" ;
lin rapid_A = mkA "rapide" ; -- tocheck
lin rough_A = mkA "approximatif" | mkA "brut" | mkA "difficile" | mkA "rude" | mkA "rugueux" | mkA "brutal" ; -- tocheck
lin investor_N = mkN "investisseur" ; -- tocheck
lin fire_V2 = mkV2 (mkV "tirer") | mkV2 (mkV I.cuire_V2) | mkV2 (mkV "licencier") ; -- tocheck
lin fire_V = variants{}; -- mkV2 (mkV "tirer") | mkV2 (mkV I.cuire_V2) | mkV2 (mkV "licencier") ; -- tocheck
lin rank_N = mkN "rangée" feminine ; -- tocheck
lin compete_V = mkV (mkV "rivaliser") ; -- tocheck
lin sweet_A = mkA "génial" | mkA "sucré" | mkA "charmant" | mkA "doux" | mkA "sympathique" | mkA "frais" | mkA "suave" ; -- tocheck
lin decline_VV = variants{}; -- mkV2 (mkV "décliner") | mkV2 (mkV "accorder") | mkV2 (mkV "refuser") ; -- tocheck
lin decline_V2 = mkV2 (mkV "décliner") | mkV2 (mkV "accorder") | mkV2 (mkV "refuser") ; -- tocheck
lin decline_V = variants{}; -- mkV2 (mkV "décliner") | mkV2 (mkV "accorder") | mkV2 (mkV "refuser") ; -- tocheck
lin rent_N = mkN "loyer" masculine ; -- tocheck
lin dealer_N = mkN "dealer" ; -- tocheck
lin bend_V2 = mkV2 (mkV "courber") ; -- tocheck
lin bend_V = variants{}; -- mkV2 (mkV "courber") ; -- tocheck
lin solid_A = mkA "plein" | mkA "solide" | mkA "massif" ; -- tocheck
lin cloud_N = L.cloud_N ;
lin across_Adv = mkAdv "à travers" ; ----
lin level_A = mkA "plat" | mkA "niveau" ; -- tocheck
lin enquiry_N = mkN "enquête" feminine ; -- tocheck
lin fight_N = mkN "bataille" feminine | mkN "combativité" feminine | mkN "combat" masculine | mkN "lutte" feminine | mkN "bagarre" feminine ; -- tocheck
lin abuse_N = mkN "abus" masculine | mkN "viol" masculine ; -- tocheck
lin golf_N = mkN "golf" masculine ; -- tocheck
lin guitar_N = mkN "guitare" feminine ; -- tocheck
lin electronic_A = mkA "électronique" ; -- tocheck
lin cottage_N = mkN "cottage" masculine ; -- tocheck
lin scope_N = mkN "portée" | mkN "portée" feminine ; -- tocheck
lin pause_VS = variants{} ; -- 
lin pause_V2V = variants{} ; -- 
lin pause_V = variants{} ; -- 
lin mixture_N = mkN "mélange" masculine ; -- tocheck
lin emotion_N = mkN "émotion" feminine ; -- tocheck
lin comprehensive_A = mkA "complet" ; -- tocheck
lin shirt_N = L.shirt_N ;
lin allowance_N = variants{} ; -- 
lin retirement_N = mkN "retraite" feminine ; -- tocheck
lin breach_N = mkN "brouille" feminine | mkN "infraction" feminine | mkN "brèche" feminine ; -- tocheck
lin infection_N = mkN "infection" feminine ; -- tocheck
lin resist_VV = variants{}; -- mkV2 (mkV "résister") ; -- tocheck
lin resist_V2 = mkV2 (mkV "résister") ; -- tocheck
lin resist_V = variants{}; -- mkV2 (mkV "résister") ; -- tocheck
lin qualify_V2 = mkV2 (mkV "qualifier") | mkV2 (reflV (mkV "qualifier")) | mkV2 (mkV "caractériser") ; -- tocheck
lin qualify_V = variants{}; -- mkV2 (mkV "qualifier") | mkV2 (reflV (mkV "qualifier")) | mkV2 (mkV "caractériser") ; -- tocheck
lin paragraph_N = mkN "paragraphe" masculine ; -- tocheck
lin sick_A = mkA "malade" ; -- tocheck
lin near_A = L.near_A ;
lin researcherMasc_N = mkN "chercheur" ;
lin consent_N = mkN "consentement" masculine ; -- tocheck
lin written_A = variants{} ; -- 
lin literary_A = mkA "littéraire" ; -- tocheck
lin ill_A = mkA "mauvais" | mkA "écoeuré" | mkA "malade" ; -- tocheck
lin wet_A = L.wet_A ;
lin lake_N = L.lake_N ;
lin entrance_N = mkN "entrée" | mkN "entrée" feminine ; -- tocheck
lin peak_N = mkN "cime" feminine ; -- tocheck
lin successfully_Adv = variants{} ; -- 
lin sand_N = L.sand_N ;
lin breathe_V2 = mkV2 (mkV "respirer") ; -- tocheck
lin breathe_V = L.breathe_V ;
lin cold_N = mkN "rhume" masculine | mkN "froid" masculine ; -- tocheck
lin cheek_N = mkN "fesse" feminine | mkN "culot" masculine | mkN "joue" feminine ; -- tocheck
lin platform_N = mkN "scène" feminine | mkN "plateforme" feminine | mkN "quai" masculine ; -- tocheck
lin interaction_N = mkN "interaction" ; -- tocheck
lin watch_N = mkN "garde" | mkN "montre" feminine ; -- tocheck
lin borrow_VV = variants{}; -- mkV2 (mkV "emprunter") | mkV2 (mkV I.retenir_V2) ; -- tocheck
lin borrow_V2 = mkV2 (mkV "emprunter") | mkV2 (mkV I.retenir_V2) ; -- tocheck
lin borrow_V = variants{}; -- mkV2 (mkV "emprunter") | mkV2 (mkV I.retenir_V2) ; -- tocheck
lin birthday_N = mkN "anniversaire" masculine ; -- tocheck
lin knife_N = mkN "couteau" masculine ; -- tocheck
lin extreme_A = mkA "extrême" ; -- tocheck
lin core_N = mkN "centre" masculine | mkN "coeur" masculine | mkN "trognon" masculine ; -- tocheck
lin peasantMasc_N = mkN "paysan" masculine ;
lin armed_A = variants{} ; -- 
lin permission_N = mkN "permission" feminine ; -- tocheck
lin supreme_A = mkA "suprême" ; -- tocheck
lin overcome_V2 = mkV2 (mkV I.vaincre_V2) ; -- tocheck
lin overcome_V = variants{}; -- mkV2 (mkV I.vaincre_V2) ; -- tocheck
lin greatly_Adv = variants{} ; -- 
lin visual_A = mkA "visuel" ; -- tocheck
lin lad_N = mkN "palefrenier" masculine | mkN "garçon" masculine ; -- tocheck
lin genuine_A = mkA "authentique" ;
lin personnel_N = variants{} ; -- 
lin judgement_N = variants{} ; -- 
lin exciting_A = variants{} ; -- 
lin stream_N = mkN "flot" masculine | mkN "ruisseau" masculine ; -- tocheck
lin perception_N = mkN "perception" feminine ; -- tocheck
lin guarantee_VS = variants{}; -- mkV2 (mkV "garantir") ; -- tocheck
lin guarantee_V2 = mkV2 (mkV "garantir") ; -- tocheck
lin guarantee_V = variants{}; -- mkV2 (mkV "garantir") ; -- tocheck
lin disaster_N = mkN "désastre" masculine ; -- tocheck
lin darkness_N = mkN "obscurité" feminine | mkN "noirceur" | mkN "ténèbres" ; -- tocheck
lin bid_N = mkN "enchère" feminine ; -- tocheck
lin sake_N = mkN "saké" masculine ; -- tocheck
lin sake_2_N = variants{} ; -- 
lin sake_1_N = variants{} ; -- 
lin organize_V2V = mkV2V (mkV "organiser") ; -- tocheck
lin organize_V2 = variants{}; -- mkV2V (mkV "organiser") ; -- tocheck
lin tourist_N = mkN "touriste" masculine ; -- tocheck
lin policeman_N = L.policeman_N ;
lin castle_N = mkN "château" masculine ; -- tocheck
lin figure_VS = variants{}; -- mkV2V (mkV I.comprendre_V2) | mkV2V (mkV I.résoudre_V2) ; -- tocheck
lin figure_V = variants{}; -- mkV2V (mkV I.comprendre_V2) | mkV2V (mkV I.résoudre_V2) ; -- tocheck
lin race_VV = variants{}; -- mkV2V (reflV (mkV "élancer")) ; -- tocheck
lin race_V2V = mkV2V (reflV (mkV "élancer")) ; -- tocheck
lin race_V2 = variants{}; -- mkV2V (reflV (mkV "élancer")) ; -- tocheck
lin race_V = variants{}; -- mkV2V (reflV (mkV "élancer")) ; -- tocheck
lin demonstration_N = mkN "démonstration" feminine | mkN "manifestation" feminine ; -- tocheck
lin anger_N = mkN "colère" feminine ; -- tocheck
lin briefly_Adv = variants{} ; -- 
lin presumably_Adv = variants{} ; -- 
lin clock_N = mkN "horloge" feminine ; -- tocheck
lin hero_N = mkN "héros" masculine | mkN "protagoniste" masculine ; -- tocheck
lin expose_V2 = mkV2 (mkV "exposer") ; -- tocheck
lin expose_V = variants{}; -- mkV2 (mkV "exposer") ; -- tocheck
lin custom_N = mkN "connaissance" | mkN "coutume" feminine ; -- tocheck
lin maximum_A = mkA "maximum" ; -- tocheck
lin wish_N = mkN "souhait" ; -- tocheck
lin earning_N = variants{} ; -- 
lin priest_N = L.priest_N ;
lin resign_V2 = variants{}; -- mkV2V (mkV "résigner") | mkV2V (mkV "démissionner") ; -- tocheck
lin resign_V = variants{}; -- mkV2V (mkV "résigner") | mkV2V (mkV "démissionner") ; -- tocheck
lin store_V2 = mkV2 (mkV "stocker") | mkV2 (mkV "conserver") ; -- tocheck
lin widespread_A = mkA "répandu" ; -- tocheck
lin comprise_V2 = mkV2 (mkV I.comprendre_V2) | mkV2 (mkV I.contenir_V2) ; -- tocheck
lin chamber_N = mkN "chambre" feminine ; -- tocheck
lin acquisition_N = mkN "acquisition" feminine ; -- tocheck
lin involved_A = variants{} ; -- 
lin confident_A = mkA "assuré" ; -- tocheck
lin circuit_N = mkN "circuit" ; -- tocheck
lin radical_A = mkA "radical" | mkA "génial" ; -- tocheck
lin detect_V2 = mkV2 (mkV "déceler") ; -- tocheck
lin stupid_A = L.stupid_A ;
lin grand_A = variants{} ; -- 
lin consumption_N = mkN "consommation" | mkN "consommation" feminine ; -- tocheck
lin hold_N = mkN "soute" feminine ; -- tocheck
lin zone_N = mkN "zone" feminine ; -- tocheck
lin mean_A = mkA "méchant" | mkA "moyen" | mkA "inférieur" ; -- tocheck
lin altogether_Adv = mkAdv "complètement" ; -- tocheck
lin rush_VV = variants{}; -- mkV2V (reflV (mkV "dépêcher")) ; -- tocheck
lin rush_V2 = variants{}; -- mkV2V (reflV (mkV "dépêcher")) ; -- tocheck
lin rush_V = variants{}; -- mkV2V (reflV (mkV "dépêcher")) ; -- tocheck
lin numerous_A = mkA "nombreux" ; -- tocheck
lin sink_V2 = mkV2 (mkV "couler") | mkV2 (reflV (mkV "enfoncer")) ; -- tocheck
lin sink_V = variants{}; -- mkV2 (mkV "couler") | mkV2 (reflV (mkV "enfoncer")) ; -- tocheck
lin everywhere_Adv = S.everywhere_Adv ;
lin classical_A = mkA "classique" ; -- tocheck
lin respectively_Adv = variants{} ; -- 
lin distinct_A = mkA "distinct" | mkA "reconnaissable" ; -- tocheck
lin mad_A = mkA "fâché" | mkA "fou" ; -- tocheck
lin honour_N = mkN "honneur" masculine ; -- tocheck
lin statistics_N = mkN "statistiques" feminine ; -- tocheck
lin false_A = mkA "faux" ; -- tocheck
lin square_N = mkN "case" feminine | mkN "place" feminine | mkN "carré" masculine | mkN "carreau" masculine | mkN "équerre" feminine ; -- tocheck
lin differ_V = mkV (mkV "différer") ; -- tocheck
lin disk_N = mkN "disque" masculine ; -- tocheck
lin truly_Adv = variants{} ; -- 
lin survival_N = mkN "survie" ; -- tocheck
lin proud_A = mkA "fier" | mkA "orgueilleux" ; -- tocheck
lin tower_N = mkN "tour" feminine ; -- tocheck
lin deposit_N = mkN "dépôt" masculine | mkN "acompte" masculine | mkN "caution" feminine ; -- tocheck
lin pace_N = mkN "pas" masculine | mkN "rythme" masculine ; -- tocheck
lin compensation_N = mkN "compensation" feminine | mkN "dédommagement" masculine ; -- tocheck
lin adviserMasc_N = mkN "renseigneur" ; -- tocheck
lin consultant_N = mkN "consultant" masculine ; -- tocheck
lin drag_V2 = mkV2 (mkV "traîner") ; -- tocheck
lin drag_V = variants{}; -- mkV2 (mkV "traîner") ; -- tocheck
lin advanced_A = variants{} ; -- 
lin landlord_N = mkN "propriétaire" | mkN "patron" masculine ; -- tocheck
lin whenever_Adv = mkAdv "quand" ; -- tocheck
lin delay_N = mkN "délai" masculine ; -- tocheck
lin green_N = mkN "vert" masculine ; -- tocheck
lin car_V = variants{} ; -- 
lin holder_N = mkN "porteur" masculine ; -- tocheck
lin secret_A = mkA "secret" ; -- tocheck
lin edition_N = mkN "édition" feminine ; -- tocheck
lin occupation_N = mkN "occupation" feminine ; -- tocheck
lin agricultural_A = mkA "agricole" ; -- tocheck
lin intelligence_N = variants{} ; -- 
lin intelligence_2_N = mkN "renseignements" ; -- tocheck
lin intelligence_1_N = mkN "intelligence" feminine ; -- tocheck
lin empire_N = mkN "empire" | mkN "empire" masculine ; -- tocheck
lin definitely_Adv = variants{} ; -- 
lin negotiate_VV = variants{}; -- mkV2 (mkV "négocier") ; -- tocheck
lin negotiate_V2 = mkV2 (mkV "négocier") ; -- tocheck
lin negotiate_V = variants{}; -- mkV2 (mkV "négocier") ; -- tocheck
lin host_N = mkN "hôte" masculine | mkN "hostie" feminine | mkN "hôte" | mkN "armée" | mkN "organisateur" masculine ; -- tocheck
lin relative_N = mkN "parent" masculine ; -- tocheck
lin mass_A = variants{} ; -- 
lin helpful_A = mkA "utile" ; -- tocheck
lin fellow_N = mkN "mec" ; -- tocheck
lin sweep_V2 = mkV2 (mkV "balayer") ; -- tocheck
lin sweep_V = variants{}; -- mkV2 (mkV "balayer") ; -- tocheck
lin poet_N = mkN "poète" masculine ; -- tocheck
lin journalist_N = mkN "journaliste" ; -- tocheck
lin defeat_N = mkN "défaite" feminine ; -- tocheck
lin unlike_Prep = variants{} ; -- 
lin primarily_Adv = variants{} ; -- 
lin tight_A = mkA "serré" | mkA "tendu" ; -- tocheck
lin indication_N = mkN "indication" feminine ; -- tocheck
lin dry_V2 = mkV2 (mkV "sécher") ; -- tocheck
lin dry_V = variants{}; -- mkV2 (mkV "sécher") ; -- tocheck
lin cricket_N = mkN "cricket" masculine | mkN "grillon" masculine ; -- tocheck
lin whisper_V2 = mkV2 (mkV "chuchoter") ; -- tocheck
lin whisper_V = variants{}; -- mkV2 (mkV "chuchoter") ; -- tocheck
lin routine_N = mkN "routine" feminine ; -- tocheck
lin print_N = mkN "empreinte" feminine ; -- tocheck
lin anxiety_N = mkN "anxiété" feminine ; -- tocheck
lin witness_N = mkN "témoin" masculine | mkN "preuve" feminine | mkN "témoignage" masculine ; -- tocheck
lin concerning_Prep = variants{} ; -- 
lin mill_N = mkN "moulin" | mkN "manufacture" feminine | mkN "moulin" masculine ; -- tocheck
lin gentle_A = mkA "doux" | mkA "gentil" ; -- tocheck
lin curtain_N = mkN "rideau" masculine ; -- tocheck
lin mission_N = mkN "mission" feminine ; -- tocheck
lin supplier_N = mkN "fournisseur" masculine ; -- tocheck
lin basically_Adv = mkAdv "foncièrement" ; -- tocheck
lin assure_V2S = mkV2S (mkV "assurer") | mkV2S (mkV "rassurer") ; -- tocheck
lin assure_V2 = variants{}; -- mkV2S (mkV "assurer") | mkV2S (mkV "rassurer") ; -- tocheck
lin poverty_N = mkN "pauvreté" feminine ; -- tocheck
lin snow_N = L.snow_N ;
lin prayer_N = mkN "prière" feminine ; -- tocheck
lin pipe_N = mkN "cornemuse" feminine | mkN "conduit" masculine ; -- tocheck
lin deserve_VV = variants{}; -- mkV2 (mkV "mériter") ; -- tocheck
lin deserve_V2 = mkV2 (mkV "mériter") ; -- tocheck
lin deserve_V = variants{}; -- mkV2 (mkV "mériter") ; -- tocheck
lin shift_N = mkN "décalage" | mkN "roulement" masculine ; -- tocheck
lin split_V2 = L.split_V2 ;
lin split_V = variants{}; -- L.split_V2 ;
lin near_Adv = mkAdv "près" ; -- tocheck
lin consistent_A = mkA "conforme" | mkA "cohérent" | mkA "constant" ; -- tocheck
lin carpet_N = L.carpet_N ;
lin ownership_N = mkN "possession" ; -- tocheck
lin joke_N = mkN "plaisanterie" feminine | mkN "raté" masculine ; -- tocheck
lin fewer_Det = variants{} ; -- 
lin workshop_N = mkN "atelier" masculine ; -- tocheck
lin salt_N = L.salt_N ;
lin aged_Prep = variants{} ; -- 
lin symbol_N = mkN "symbole" masculine ; -- tocheck
lin slide_V2 = mkV2 (mkV "glisser") ; -- tocheck
lin slide_V = variants{}; -- mkV2 (mkV "glisser") ; -- tocheck
lin cross_N = mkN "croix" | mkN "croix" feminine ; -- tocheck
lin anxious_A = mkA "anxieux" | mkA "désireux" ; -- tocheck
lin tale_N = mkN "conte" masculine ; -- tocheck
lin preference_N = mkN "préférence" feminine ; -- tocheck
lin inevitably_Adv = variants{} ; -- 
lin mere_A = variants{} ; -- 
lin behave_V = mkV (reflV (mkV I.conduire_V2)) ; -- tocheck
lin gain_N = mkN "gain" masculine ; -- tocheck
lin nervous_A = mkA "nerveux" ; -- tocheck
lin guide_V2 = mkV2 (mkV "guider") ; -- tocheck
lin remark_N = mkN "remarque" feminine ; -- tocheck
lin pleased_A = variants{} ; -- 
lin province_N = mkN "province" feminine ; -- tocheck
lin steel_N = L.steel_N ;
lin practise_V2 = variants{} ; -- 
lin practise_V = variants{} ; -- 
lin flow_V = L.flow_V ;
lin holy_A = mkA "saint" ; -- tocheck
lin dose_N = mkN "dose" feminine ; -- tocheck
lin alcohol_N = mkN "alcool" masculine ; -- tocheck
lin guidance_N = mkN "conseils" masculine ; -- tocheck
lin constantly_Adv = variants{} ; -- 
lin climate_N = mkN "climat" masculine ; -- tocheck
lin enhance_V2 = mkV2 (mkV "améliorer") | mkV2 (mkV "augmenter") ; -- tocheck
lin reasonably_Adv = variants{} ; -- 
lin waste_V2 = mkV2 (mkV I.détruire_V2) | mkV2 (mkV "tuer") | mkV2 (mkV "gaspiller") | mkV2 (mkV "dépérir") ; -- tocheck
lin waste_V = variants{}; -- mkV2 (mkV I.détruire_V2) | mkV2 (mkV "tuer") | mkV2 (mkV "gaspiller") | mkV2 (mkV "dépérir") ; -- tocheck
lin smooth_A = L.smooth_A ;
lin dominant_A = variants{} ; -- 
lin conscious_A = mkA "conscient" ; -- tocheck
lin formula_N = mkN "formule" feminine ; -- tocheck
lin tail_N = L.tail_N ;
lin ha_Interj = variants{} ; -- 
lin electric_A = mkA "électrique" ; -- tocheck
lin sheep_N = L.sheep_N ;
lin medicine_N = mkN "médecine" feminine | mkN "médicament" masculine | mkN "traitement" masculine ; -- tocheck
lin strategic_A = mkA "stratégique" ; -- tocheck
lin disabled_A = variants{} ; -- 
lin smell_N = mkN "odorat" masculine | mkN "odeur" feminine ; -- tocheck
lin operator_N = mkN "opérateur" masculine | mkN "téléphoniste" ; -- tocheck
lin mount_V2 = mkV2 (mkV "chevaucher") ; -- tocheck
lin mount_V = variants{}; -- mkV2 (mkV "chevaucher") ; -- tocheck
lin advance_V2 = mkV2 (mkV "avancer") ; -- tocheck
lin advance_V = variants{}; -- mkV2 (mkV "avancer") ; -- tocheck
lin remote_A = mkA "éloigné" | mkA "distant" ; -- tocheck
lin measurement_N = mkN "mesure" feminine ; -- tocheck
lin favour_VS = variants{} ; -- 
lin favour_V2 = variants{} ; -- 
lin favour_V = variants{} ; -- 
lin neither_Det = variants{} ; -- 
lin architecture_N = mkN "architecture" feminine ; -- tocheck
lin worth_N = mkN "valeur" masculine ; -- tocheck
lin tie_N = mkN "égalité" feminine ; -- tocheck
lin barrier_N = mkN "barrière" | mkN "limite" ; -- tocheck
lin practitioner_N = mkN "praticien" masculine ; -- tocheck
lin outstanding_A = mkA "exceptionnel" | mkA "débiteur" | mkA "saillant" ; -- tocheck
lin enthusiasm_N = mkN "enthousiasme" masculine ; -- tocheck
lin theoretical_A = mkA "théorique" ; -- tocheck
lin implementation_N = variants{} ; -- 
lin worried_A = mkA "inquiet" "inquiète" ;
lin pitch_N = mkN "tangage" masculine | mkN "poix" feminine | mkN "pas" masculine | mkN "laïus" masculine | mkN "résine" feminine | mkN "lancer" masculine | mkN "inclinaison" feminine | mkN "terrain" masculine | mkN "ton" masculine ; -- tocheck
lin drop_N = mkN "chute" feminine | mkN "goutte" feminine ; -- tocheck
lin phone_V2 = mkV2 (mkV "téléphoner") ; -- tocheck
lin phone_V = variants{}; -- mkV2 (mkV "téléphoner") ; -- tocheck
lin shape_VV = variants{} ; -- 
lin shape_V2 = variants{} ; -- 
lin shape_V = variants{} ; -- 
lin clinical_A = variants{} ; -- 
lin lane_N = mkN "voie" feminine | mkN "chemin" masculine ; -- tocheck
lin apple_N = L.apple_N ;
lin catalogue_N = mkN "catalogue" masculine ; -- tocheck
lin tip_N = mkN "décharge" feminine | mkN "tuyau" masculine | mkN "pourboire" masculine | mkN "bout" masculine ; -- tocheck
lin publisher_N = mkN "éditeur" masculine ; -- tocheck
lin opponentMasc_N = mkN "adversaire" masculine ;
lin live_A = mkA "vivant" ; -- tocheck
lin burden_N = mkN "charge" feminine | mkN "fardeau" masculine ; -- tocheck
lin tackle_V2 = mkV2 (mkV "plaquer") | mkV2 (mkV "tacler") | mkV2 (mkV I.combattre_V2) ; -- tocheck
lin tackle_V = variants{}; -- mkV2 (mkV "plaquer") | mkV2 (mkV "tacler") | mkV2 (mkV I.combattre_V2) ; -- tocheck
lin historian_N = mkN "historien" masculine ; -- tocheck
lin bury_V2 = mkV2 (mkV "enterrer") ; -- tocheck
lin bury_V = variants{}; -- mkV2 (mkV "enterrer") ; -- tocheck
lin stomach_N = mkN "ventre" masculine | mkN "estomac" masculine ; -- tocheck
lin percentage_N = mkN "pourcentage" masculine ; -- tocheck
lin evaluation_N = mkN "évaluation" feminine ; -- tocheck
lin outline_V2 = mkV2 (mkV "entourer") ; -- tocheck
lin talent_N = mkN "talent" masculine ; -- tocheck
lin lend_V2 = mkV2 (mkV "prêter") ; -- tocheck
lin lend_V = variants{}; -- mkV2 (mkV "prêter") ; -- tocheck
lin silver_N = L.silver_N ;
lin pack_N = mkN "meute" feminine ; -- tocheck
lin fun_N = mkN "amusement" masculine ; -- tocheck
lin democrat_N = mkN "démocrate" ; -- tocheck
lin fortune_N = mkN "destin" | mkN "fortune" ; -- tocheck
lin storage_N = mkN "stockage" masculine ; -- tocheck
lin professional_N = mkN "professionnel" masculine ; -- tocheck
lin reserve_N = mkN "réserve" feminine | mkN "réservation" feminine | mkN "réserves" | mkN "réservation" ; -- tocheck
lin interval_N = mkN "intervalle" masculine ; -- tocheck
lin dimension_N = mkN "dimension" feminine ; -- tocheck
lin honest_A = mkA "honnête" ; -- tocheck
lin awful_A = mkA "terrible" ; -- tocheck
lin manufacture_V2 = mkV2 (mkV "fabriquer") | mkV2 (mkV "manufacturer") ; -- tocheck
lin confusion_N = variants{} ; -- 
lin pink_A = mkA "rose" ; -- tocheck
lin impressive_A = mkA "impressionnant" ; -- tocheck
lin satisfaction_N = mkN "satisfaction" feminine ; -- tocheck
lin visible_A = mkA "visible" ; -- tocheck
lin vessel_N = mkN "récipient" masculine | mkN "vaisseau" masculine ; -- tocheck
lin stand_N = mkN "socle" masculine | mkN "étal" ; -- tocheck
lin curve_N = mkN "courbe" feminine | mkN "courbes" ; -- tocheck
lin pot_N = mkN "herbe" feminine | mkN "pot" masculine ; -- tocheck
lin replacement_N = mkN "remplaçant" masculine ; -- tocheck
lin accurate_A = mkA "précis" ; -- tocheck
lin mortgage_N = mkN "hypothèque" feminine ; -- tocheck
lin salary_N = mkN "salaire" masculine ; -- tocheck
lin impress_V2 = mkV2 (mkV "impressionner") ; -- tocheck
lin impress_V = variants{}; -- mkV2 (mkV "impressionner") ; -- tocheck
lin constitutional_A = mkA "constitutionnel" ; -- tocheck
lin emphasize_VS = variants{}; -- mkV2 (mkV "souligner") ; -- tocheck
lin emphasize_V2 = mkV2 (mkV "souligner") ; -- tocheck
lin developing_A = variants{} ; -- 
lin proof_N = mkN "épreuve" feminine | mkN "preuve" feminine ; -- tocheck
lin furthermore_Adv = variants{} ; -- 
lin dish_N = mkN "plat" masculine | mkN "assiette" | mkN "canon" masculine | mkN "vaisselle" feminine | mkN "parabole" feminine ; -- tocheck
lin interview_V2 = variants{} ; -- 
lin considerably_Adv = variants{} ; -- 
lin distant_A = mkA "distant" ; -- tocheck
lin lower_V2 = mkV2 (mkV "baisser") | mkV2 (reflV (mkV "abaisser")) ; -- tocheck
lin lower_V = variants{}; -- mkV2 (mkV "baisser") | mkV2 (reflV (mkV "abaisser")) ; -- tocheck
lin favouriteMasc_N = mkN "favori" masculine ;
lin tear_V2 = mkV2 (reflV (mkV "déchirer")) | mkV2 (mkV "déchirer") | mkV2 (mkV "démolir") | mkV2 (mkV "larmoyer") ; -- tocheck
lin tear_V = variants{}; -- mkV2 (reflV (mkV "déchirer")) | mkV2 (mkV "déchirer") | mkV2 (mkV "démolir") | mkV2 (mkV "larmoyer") ; -- tocheck
lin fixed_A = variants{} ; -- 
lin by_Adv = variants{}; -- mkPrep "par" ;
lin luck_N = mkN "chance" feminine ; -- tocheck
lin count_N = mkN "compte" masculine | mkN "comte" masculine ; -- tocheck
lin precise_A = mkA "précis" ; -- tocheck
lin determination_N = variants{} ; -- 
lin bite_V2 = L.bite_V2 ;
lin bite_V = variants{}; -- L.bite_V2 ;
lin dear_Interj = variants{} ; -- 
lin consultation_N = mkN "consultation" feminine ; -- tocheck
lin range_V = variants{} ; -- 
lin residential_A = mkA "résidentiel" ; -- tocheck
lin conduct_N = mkN "comportement" masculine ; -- tocheck
lin capture_V2 = variants{} ; -- 
lin ultimately_Adv = variants{} ; -- 
lin cheque_N = mkN "chèque" masculine ; -- tocheck
lin economics_N = mkN "économie" feminine ; -- tocheck
lin sustain_V2 = mkV2 (mkV I.maintenir_V2) | mkV2 (mkV I.subvenir_V2) ; -- tocheck
lin secondly_Adv = variants{} ; -- 
lin silly_A = mkA "idiot" | mkA "bébête" | mkA "abruti" ; -- tocheck
lin merchant_N = mkN "marchand" masculine ; -- tocheck
lin lecture_N = mkN "conférence" feminine ; -- tocheck
lin musical_A = variants{} ; -- 
lin leisure_N = mkN "loisir" masculine ; -- tocheck
lin check_N = mkN "addition" feminine | mkN "vérification" feminine | mkN "croix" feminine | mkN "échec" masculine ; -- tocheck
lin cheese_N = L.cheese_N ;
lin lift_N = mkN "portance" masculine | mkN "ascenseur" masculine ; -- tocheck
lin participate_V2 = variants{} ; -- 
lin participate_V = variants{} ; -- 
lin fabric_N = mkN "structure" | mkN "tissu" masculine | mkN "tissu" ; -- tocheck
lin distribute_V2 = mkV2 (mkV "distribuer") | mkV2 (mkV "répartir") ; -- tocheck
lin lover_N = mkN "amoureux" masculine | mkN "amant" masculine ; -- tocheck
lin childhood_N = mkN "enfance" feminine ; -- tocheck
lin cool_A = mkA "cool" | mkA "chouette" | mkA "frais" | mkA "sympa" ; -- tocheck
lin ban_V2 = mkV2 (mkV I.interdire_V2) ; -- tocheck
lin supposed_A = variants{} ; -- 
lin mouse_N = mkN "souris" feminine ; -- tocheck
lin strain_N = mkN "hérédité" feminine | mkN "race" feminine ; -- tocheck
lin specialist_A = variants{} ; -- 
lin consult_V2 = variants{} ; -- 
lin consult_V = variants{} ; -- 
lin minimum_A = mkA "minimum" ; -- tocheck
lin approximately_Adv = variants{} ; -- 
lin participant_N = mkN "participant" masculine ; -- tocheck
lin monetary_A = mkA "monétaire" ; -- tocheck
lin confuse_V2 = mkV2 (mkV I.confondre_V2) ; -- tocheck
lin dare_VV = variants{}; -- mkV2 (mkV "oser") | mkV2 (mkV "affronter") | mkV2 (mkV "défier") ; -- tocheck
lin dare_V2 = mkV2 (mkV "oser") | mkV2 (mkV "affronter") | mkV2 (mkV "défier") ; -- tocheck
lin smoke_N = L.smoke_N ;
lin movie_N = mkN "cinéma" masculine ; -- tocheck
lin seed_N = L.seed_N ;
lin cease_V2 = variants{}; -- mkV2V (mkV "cesser") ; -- tocheck
lin cease_V = variants{}; -- mkV2V (mkV "cesser") ; -- tocheck
lin open_Adv = variants{} ; -- 
lin journal_N = mkN "revue" masculine ; -- tocheck
lin shopping_N = mkN "shopping" masculine ; -- tocheck
lin equivalent_N = mkN "équivalent" masculine ; -- tocheck
lin palace_N = mkN "palais" masculine ; -- tocheck
lin exceed_V2 = mkV2 (mkV "excéder") ; -- tocheck
lin isolated_A = variants{} ; -- 
lin poetry_N = mkN "poésie" feminine ; -- tocheck
lin perceive_VS = variants{}; -- mkV2V (mkV I.percevoir_V2) ; -- tocheck
lin perceive_V2V = mkV2V (mkV I.percevoir_V2) ; -- tocheck
lin perceive_V2 = variants{}; -- mkV2V (mkV I.percevoir_V2) ; -- tocheck
lin lack_V2 = mkV2 (mkV "manquer") ; -- tocheck
lin lack_V = variants{}; -- mkV2 (mkV "manquer") ; -- tocheck
lin strengthen_V2 = mkV2 (mkV "renforcer") ; -- tocheck
lin snap_V2 = mkV2 (mkV I.rompre_V2) ; -- tocheck
lin snap_V = variants{}; -- mkV2 (mkV I.rompre_V2) ; -- tocheck
lin readily_Adv = variants{} ; -- 
lin spite_N = mkN "dépit" masculine | mkN "dépit" ; -- tocheck
lin conviction_N = variants{} ; -- 
lin corridor_N = mkN "couloir" masculine | mkN "corridor" masculine ; -- tocheck
lin behind_Adv = variants{}; -- S.behind_Prep ;
lin ward_N = mkN "arrondissement" | mkN "cour" feminine | mkN "garde" feminine | mkN "salle" feminine | mkN "pupille" | mkN "quartier" masculine | mkN "garde" ; -- tocheck
lin profile_N = mkN "profil" masculine | mkN "contour" masculine | mkN "réputation" feminine ; -- tocheck
lin fat_A = mkA "gros" "grosse" | mkA "épais" "épaisse" ;
lin comfort_N = mkN "confort" | mkN "confort" masculine ; -- tocheck
lin bathroom_N = mkN "toilette" feminine ; -- tocheck
lin shell_N = mkN "coquillage" | mkN "douille" feminine | mkN "coquille" feminine | mkN "squelette" masculine | mkN "carapace" feminine | mkN "obus" masculine | mkN "cosse" feminine | mkN "coquille" ; -- tocheck
lin reward_N = mkN "récompense" feminine ; -- tocheck
lin deliberately_Adv = variants{} ; -- 
lin automatically_Adv = variants{} ; -- 
lin vegetable_N = mkN "légume" masculine | mkN "végétal" masculine ; -- tocheck
lin imagination_N = mkN "imagination" feminine ; -- tocheck
lin junior_A = mkA "junior" ; -- tocheck
lin unemployed_A = variants{} ; -- 
lin mystery_N = mkN "mystère" masculine ; -- tocheck
lin pose_V2 = mkV2 (mkV "poser") | mkV2 (mkV "représenter") | mkV2 (mkV I.mettre_V2) ; -- tocheck
lin pose_V = variants{}; -- mkV2 (mkV "poser") | mkV2 (mkV "représenter") | mkV2 (mkV I.mettre_V2) ; -- tocheck
lin violent_A = mkA "vif" | mkA "violent" ; -- tocheck
lin march_N = variants{} ; -- 
lin found_V2 = mkV2 (mkV "fonder") ; -- tocheck
lin dig_V2 = mkV2 (mkV "creuser") ; -- tocheck
lin dig_V = L.dig_V ;
lin dirty_A = L.dirty_A ;
lin straight_A = L.straight_A ;
lin psychological_A = variants{} ; -- 
lin grab_V2 = mkV2 (mkV "attraper") ; -- tocheck
lin grab_V = variants{}; -- mkV2 (mkV "attraper") ; -- tocheck
lin pleasant_A = mkA "agréable" ; -- tocheck
lin surgery_N = mkN "chirurgie" feminine ; -- tocheck
lin inevitable_A = mkA "inévitable" ; -- tocheck
lin transform_V2 = mkV2 (mkV "transformer") ; -- tocheck
lin bell_N = mkN "cloche" feminine ; -- tocheck
lin announcement_N = mkN "annonce" feminine ; -- tocheck
lin draft_N = mkN "gorgée" | mkN "conscription" feminine | mkN "brouillon" masculine | mkN "tirant" ; -- tocheck
lin unity_N = mkN "unité" feminine ; -- tocheck
lin airport_N = mkN "aéroport" masculine ; -- tocheck
lin upset_V2 = mkV2 (mkV "bouleverser") | mkV2 (mkV "énerver") | mkV2 (mkV "renverser") ; -- tocheck
lin upset_V = variants{}; -- mkV2 (mkV "bouleverser") | mkV2 (mkV "énerver") | mkV2 (mkV "renverser") ; -- tocheck
lin pretend_VS = variants{}; -- mkV2 (mkV I.prétendre_V2) | mkV2 (mkV I.feindre_V2) ; -- tocheck
lin pretend_V2 = mkV2 (mkV I.prétendre_V2) | mkV2 (mkV I.feindre_V2) ; -- tocheck
lin pretend_V = variants{}; -- mkV2 (mkV I.prétendre_V2) | mkV2 (mkV I.feindre_V2) ; -- tocheck
lin plant_V2 = mkV2 (mkV "planter") ; -- tocheck
lin till_Prep = variants{} ; -- 
lin known_A = variants{} ; -- 
lin admission_N = variants{} ; -- 
lin tissue_N = mkN "tissu" masculine ; -- tocheck
lin magistrate_N = mkN "magistrat" masculine ; -- tocheck
lin joy_N = mkN "joie" feminine ; -- tocheck
lin free_V2V = mkV2V (mkV "libérer") ; -- tocheck
lin free_V2 = variants{}; -- mkV2V (mkV "libérer") ; -- tocheck
lin pretty_A = mkA "joli" ; -- tocheck
lin operating_N = variants{} ; -- 
lin headquarters_N = variants{} ; -- 
lin grateful_A = mkA "reconnaissant" ; -- tocheck
lin classroom_N = variants{} ; -- 
lin turnover_N = mkN "chausson" masculine | mkN "renverser" ; -- tocheck
lin project_VS = variants{}; -- mkV2V (mkV "projeter") ; -- tocheck
lin project_V2V = mkV2V (mkV "projeter") ; -- tocheck
lin project_V2 = variants{}; -- mkV2V (mkV "projeter") ; -- tocheck
lin project_V = variants{}; -- mkV2V (mkV "projeter") ; -- tocheck
lin shrug_V2 = variants{} ; -- 
lin sensible_A = mkA "sensé" | mkA "sensible" ; -- tocheck
lin limitation_N = variants{} ; -- 
lin specialist_N = mkN "spécialiste" ; -- tocheck
lin newly_Adv = variants{} ; -- 
lin tongue_N = L.tongue_N ;
lin refugee_N = mkN "réfugié" masculine ; -- tocheck
lin delay_V2 = mkV2 (mkV "retarder") ; -- tocheck
lin delay_V = variants{}; -- mkV2 (mkV "retarder") ; -- tocheck
lin dream_V2 = mkV2 (mkV "rêver") | mkV2 (mkV "rêvasser") ; -- tocheck
lin dream_V = variants{}; -- mkV2 (mkV "rêver") | mkV2 (mkV "rêvasser") ; -- tocheck
lin composition_N = mkN "essai" masculine | mkN "composition" feminine ; -- tocheck
lin alongside_Prep = variants{} ; -- 
lin ceiling_N = L.ceiling_N ;
lin highlight_V2 = mkV2 (mkV "surligner") ; -- tocheck
lin stick_N = L.stick_N ;
lin favourite_A = variants{} ; -- 
lin tap_V2 = mkV2 (mkV "taper") | mkV2 (mkV "tirer") | mkV2 (mkV "tarauder") ; -- tocheck
lin tap_V = variants{}; -- mkV2 (mkV "taper") | mkV2 (mkV "tirer") | mkV2 (mkV "tarauder") ; -- tocheck
lin universe_N = mkN "univers" masculine | mkN "Univers" masculine ; -- tocheck
lin request_VS = variants{}; -- mkV2 (mkV "demander") ; -- tocheck
lin request_V2 = mkV2 (mkV "demander") ; -- tocheck
lin label_N = mkN "étiquette" feminine ; -- tocheck
lin confine_V2 = mkV2 (mkV "confiner") ; -- tocheck
lin scream_VS = variants{}; -- mkV2 (mkV "crier") ; -- tocheck
lin scream_V2 = mkV2 (mkV "crier") ; -- tocheck
lin scream_V = variants{}; -- mkV2 (mkV "crier") ; -- tocheck
lin rid_V2 = variants{} ; -- 
lin acceptance_N = mkN "acceptation" feminine ; -- tocheck
lin detective_N = mkN "détective" masculine | mkN "détective" ; -- tocheck
lin sail_V = variants{}; -- mkV2 (mkV "voler") ; -- tocheck
lin adjust_V2 = variants{}; -- mkV2V (mkV "ajuster") ; -- tocheck
lin adjust_V = variants{}; -- mkV2V (mkV "ajuster") ; -- tocheck
lin designer_N = mkN "designer" masculine ; -- tocheck
lin running_A = variants{} ; -- 
lin summit_N = mkN "sommet" masculine ; -- tocheck
lin participation_N = mkN "participation" feminine ; -- tocheck
lin weakness_N = mkN "faiblesse" feminine | mkN "faible" masculine ; -- tocheck
lin block_V2 = mkV2 (mkV "boucher") | mkV2 (mkV "contrer") | mkV2 (mkV "bloquer") ; -- tocheck
lin socalled_A = variants{} ; -- 
lin adapt_V2 = mkV2 (mkV "adapter") | mkV2 (reflV (mkV "adapter")) ; -- tocheck
lin adapt_V = variants{}; -- mkV2 (mkV "adapter") | mkV2 (reflV (mkV "adapter")) ; -- tocheck
lin absorb_V2 = mkV2 (mkV "absorber") ; -- tocheck
lin encounter_V2 = mkV2 (mkV "rencontrer") ; -- tocheck
lin defeat_V2 = mkV2 (mkV I.vaincre_V2) ; -- tocheck
lin excitement_N = mkN "excitation" feminine ; -- tocheck
lin brick_N = mkN "brique" ; -- tocheck
lin blind_A = mkA "aveugle" ; -- tocheck
lin wire_N = mkN "fil" masculine ; -- tocheck
lin crop_N = mkN "cravache" masculine | mkN "récolte" feminine | mkN "jabot" masculine ; -- tocheck
lin square_A = mkA "carré" ; -- tocheck
lin transition_N = variants{} ; -- 
lin thereby_Adv = mkAdv "ainsi" ; -- tocheck
lin protest_V2 = mkV2 (mkV "protester") ; -- tocheck
lin protest_V = variants{}; -- mkV2 (mkV "protester") ; -- tocheck
lin roll_N = mkN "rouleau" masculine | mkN "roulis" masculine | mkN "roue" feminine | mkN "roulement" masculine ; -- tocheck
lin stop_N = mkN "occlusive" feminine | mkN "arrêt" masculine | mkN "ammorti" masculine ; -- tocheck
lin assistant_N = mkN "assistant" masculine ; -- tocheck
lin deaf_A = mkA "sourd" ; -- tocheck
lin constituency_N = variants{} ; -- 
lin continuous_A = mkA "continu" ; -- tocheck
lin concert_N = mkN "concert" masculine ; -- tocheck
lin breast_N = L.breast_N ;
lin extraordinary_A = mkA "extraordinaire" ; -- tocheck
lin squad_N = variants{} ; -- 
lin wonder_N = mkN "merveille" feminine ; -- tocheck
lin cream_N = mkN "crème" feminine ; -- tocheck
lin tennis_N = mkN "tennis" masculine ; -- tocheck
lin personally_Adv = variants{} ; -- 
lin communicate_V2 = mkV2 (mkV "communiquer") ; -- tocheck
lin communicate_V = variants{}; -- mkV2 (mkV "communiquer") ; -- tocheck
lin pride_N = mkN "orgueil" masculine | mkN "fierté" feminine ; -- tocheck
lin bowl_N = mkN "bol" masculine ; -- tocheck
lin file_V2 = mkV2 (mkV "limer") ; -- tocheck
lin file_V = variants{}; -- mkV2 (mkV "limer") ; -- tocheck
lin expertise_N = mkN "expertise" feminine | mkN "compétence" feminine ; -- tocheck
lin govern_V2 = mkV2 (mkV "gouverner") ; -- tocheck
lin govern_V = variants{}; -- mkV2 (mkV "gouverner") ; -- tocheck
lin leather_N = L.leather_N ;
lin observer_N = mkN "observateur" masculine ; -- tocheck
lin margin_N = mkN "marge" feminine ; -- tocheck
lin uncertainty_N = variants{} ; -- 
lin reinforce_V2 = mkV2 (mkV "renforcer") ; -- tocheck
lin ideal_N = mkN "idéal" masculine ; -- tocheck
lin injure_V2 = mkV2 (mkV "blesser") ; -- tocheck
lin holding_N = mkN "possession" ; -- tocheck
lin universal_A = mkA "universel" ; -- tocheck
lin evident_A = mkA "évident" ; -- tocheck
lin dust_N = L.dust_N ;
lin overseas_A = mkA "outremer" ; -- tocheck
lin desperate_A = mkA "désespéré" ; -- tocheck
lin swim_V2 = mkV2 (mkV "nager") ; -- tocheck
lin swim_V = L.swim_V ;
lin occasional_A = mkA "occasionnel" ; -- tocheck
lin trouser_N = variants{} ; -- 
lin surprisingly_Adv = variants{} ; -- 
lin register_N = mkN "inscription" masculine | mkN "registre" masculine ; -- tocheck
lin album_N = mkN "album" masculine ; -- tocheck
lin guideline_N = mkN "directive" | mkN "directive" feminine ; -- tocheck
lin disturb_V2 = mkV2 (mkV "déranger") ; -- tocheck
lin amendment_N = mkN "amendement" masculine ; -- tocheck
lin architectMasc_N = mkN "architecte" masculine ;
lin objection_N = mkN "objection" feminine ; -- tocheck
lin chart_N = mkN "graphe" masculine ; -- tocheck
lin cattle_N = mkN "bovin" masculine | mkN "bétail" masculine | mkN "bétail" ; -- tocheck
lin doubt_VS = variants{}; -- mkV2 (mkV "douter") ; -- tocheck
lin doubt_V2 = mkV2 (mkV "douter") ; -- tocheck
lin react_V = variants{} ; -- 
lin consciousness_N = mkN "conscience" feminine ; -- tocheck
lin right_Interj = variants{} ; -- 
lin purely_Adv = variants{} ; -- 
lin tin_N = mkN "moule" masculine | mkN "étain" masculine ; -- tocheck
lin tube_N = mkN "tuyau" masculine ; -- tocheck
lin fulfil_V2 = mkV2 (mkV I.satisfaire_V2) ; -- tocheck
lin commonly_Adv = variants{} ; -- 
lin sufficiently_Adv = variants{} ; -- 
lin coin_N = mkN "jeton" masculine | mkN "monnaie" feminine ; -- tocheck
lin frighten_V2 = mkV2 (mkV "effrayer") ; -- tocheck
lin grammar_N = L.grammar_N ;
lin diary_N = variants{} ; -- 
lin flesh_N = mkN "chair" feminine | mkN "chair" | mkN "carnation" feminine | mkN "pulpe" | mkN "corps" | mkN "peau" ; -- tocheck
lin summary_N = mkN "résumé" masculine ; -- tocheck
lin infant_N = mkN "nourrisson" masculine ; -- tocheck
lin stir_V2 = mkV2 (mkV "agiter") | mkV2 (mkV "remuer") | mkV2 (mkV "bouger") ; -- tocheck
lin stir_V = variants{}; -- mkV2 (mkV "agiter") | mkV2 (mkV "remuer") | mkV2 (mkV "bouger") ; -- tocheck
lin storm_N = mkN "tempête" feminine | mkN "orage" masculine ; -- tocheck
lin mail_N = mkN "courrier" masculine | mkN "poste" feminine | mkN "poste" ; -- tocheck
lin rugby_N = mkN "rugby" masculine ; -- tocheck
lin virtue_N = mkN "vertu" feminine ; -- tocheck
lin specimen_N = mkN "exemple" masculine | mkN "spécimen" masculine ; -- tocheck
lin psychology_N = mkN "psychologie" feminine ; -- tocheck
lin paint_N = mkN "peinture" feminine ; -- tocheck
lin constraint_N = mkN "contrainte" feminine ; -- tocheck
lin trace_V2 = mkV2 (mkV "calquer") ; -- tocheck
lin trace_V = variants{}; -- mkV2 (mkV "calquer") ; -- tocheck
lin privilege_N = mkN "privilège" masculine ; -- tocheck
lin completion_N = mkN "achèvement" | mkN "exécution" feminine ; -- tocheck
lin progress_V2 = mkV2 (mkV "progresser") ; -- tocheck
lin progress_V = variants{}; -- mkV2 (mkV "progresser") ; -- tocheck
lin grade_N = mkN "mention" feminine | mkN "classe" feminine ; -- tocheck
lin exploit_V2 = mkV2 (mkV "exploiter") ; -- tocheck
lin import_N = variants{} ; -- 
lin potato_N = variants{} ; -- 
lin repair_N = mkN "réparation" feminine ; -- tocheck
lin passion_N = mkN "passion" feminine | mkN "Passion" feminine ; -- tocheck
lin seize_V2 = mkV2 (mkV "saisir") ; -- tocheck
lin seize_V = variants{}; -- mkV2 (mkV "saisir") ; -- tocheck
lin low_Adv = variants{} ; -- 
lin underlying_A = mkA "sous-jacent" ; -- tocheck
lin heaven_N = mkN "paradis" masculine | mkN "ciel" masculine ; -- tocheck
lin nerve_N = mkN "toupet" masculine | mkN "nervure" | mkN "nerf" masculine ; -- tocheck
lin park_V2 = mkV2 (mkV "garer") ; -- tocheck
lin park_V = variants{}; -- mkV2 (mkV "garer") ; -- tocheck
lin collapse_V2 = mkV2 (reflV (mkV "effondrer")) ; -- tocheck
lin collapse_V = variants{}; -- mkV2 (reflV (mkV "effondrer")) ; -- tocheck
lin win_N = mkN "gain" masculine ; -- tocheck
lin printer_N = mkN "imprimante" feminine | mkN "imprimeur" masculine ; -- tocheck
lin coalition_N = mkN "coalition" feminine ; -- tocheck
lin button_N = mkN "badge" masculine | mkN "bouton" masculine | mkN "clou" masculine ; -- tocheck
lin pray_V2 = mkV2 (mkV "prier") ; -- tocheck
lin pray_V = variants{}; -- mkV2 (mkV "prier") ; -- tocheck
lin ultimate_A = mkA "dernier" | mkA "ultime" ; -- tocheck
lin venture_N = variants{} ; -- 
lin timber_N = mkN "bois" masculine ; -- tocheck
lin companion_N = mkN "compagnon" masculine ; -- tocheck
lin horror_N = mkN "horreur" masculine | mkN "dégoût" ; -- tocheck
lin gesture_N = mkN "geste" masculine ; -- tocheck
lin moon_N = L.moon_N ;
lin remark_VS = variants{} ; -- 
lin remark_V = variants{} ; -- 
lin clever_A = L.clever_A ;
lin van_N = mkN "fourgon" masculine ; -- tocheck
lin consequently_Adv = variants{} ; -- 
lin raw_A = mkA "cru" | mkA "brut" ; -- tocheck
lin glance_N = variants{} ; -- 
lin broken_A = variants{} ; -- 
lin jury_N = mkN "jury" masculine ; -- tocheck
lin gaze_V = mkV (mkV "fixer") ; -- tocheck
lin burst_V2 = mkV2 (mkV "éclater") ; -- tocheck
lin burst_V = variants{}; -- mkV2 (mkV "éclater") ; -- tocheck
lin charter_N = mkN "charte" feminine ; -- tocheck
lin feministMasc_N = mkN "féministe" masculine ;
lin discourse_N = mkN "discours" masculine | mkN "conversation" feminine ; -- tocheck
lin reflection_N = mkN "réflexion" feminine | mkN "reflet" masculine ; -- tocheck
lin carbon_N = mkN "carbone" masculine | mkN "charbon" masculine ; -- tocheck
lin sophisticated_A = mkA "chic" ; -- tocheck
lin ban_N = mkN "interdiction" ; -- tocheck
lin taxation_N = mkN "taxation" feminine ; -- tocheck
lin prosecution_N = variants{} ; -- 
lin softly_Adv = mkAdv "doucement" ;
lin asleep_A = mkA "endormi" ; -- tocheck
lin aids_N = variants{} ; -- 
lin publicity_N = mkN "publicité" feminine ; -- tocheck
lin departure_N = mkN "déviation" | mkN "départ" masculine ; -- tocheck
lin welcome_A = mkA "bienvenu" ; -- tocheck
lin sharply_Adv = variants{} ; -- 
lin reception_N = mkN "réception" feminine | mkN "accueil" masculine ; -- tocheck
lin cousin_N = L.cousin_N ;
lin relieve_V2 = mkV2 (mkV "soulager") ; -- tocheck
lin linguistic_A = mkA "linguistique" ; -- tocheck
lin vat_N = mkN "cuve" feminine ; -- tocheck
lin forward_A = mkA "avant" | mkA "osé" ; -- tocheck
lin blue_N = mkN "bleu" masculine ; -- tocheck
lin multiple_A = mkA "multiple" ; -- tocheck
lin pass_N = mkN "laissez-passer" | mkN "passe" feminine ; -- tocheck
lin outer_A = mkA "extérieur" ; -- tocheck
lin vulnerable_A = mkA "vulnérable" ; -- tocheck
lin patient_A = mkA "patient" ; -- tocheck
lin evolution_N = mkN "évolution" feminine ; -- tocheck
lin allocate_V2 = mkV2 (mkV "allouer") ; -- tocheck
lin allocate_V = variants{}; -- mkV2 (mkV "allouer") ; -- tocheck
lin creative_A = variants{} ; -- 
lin potentially_Adv = variants{} ; -- 
lin just_A = mkA "juste" ; -- tocheck
lin out_Prep = variants{} ; -- 
lin judicial_A = mkA "judiciaire" ; -- tocheck
lin risk_VV = variants{} ; -- 
lin risk_V2 = variants{} ; -- 
lin ideology_N = mkN "idéologie" feminine ; -- tocheck
lin smell_VA = variants{}; -- L.smell_V ;
lin smell_V2 = mkV2 (mkV I.sentir_V2) ; -- tocheck
lin smell_V = L.smell_V ;
lin agenda_N = mkN "planning" masculine ; -- tocheck
lin transport_V2 = mkV2 (mkV "reporter") ; -- tocheck
lin illegal_A = mkA "illégal" ; -- tocheck
lin chicken_N = mkN "poulet" masculine ; -- tocheck
lin plain_A = mkA "simple" | mkA "nature" ; -- tocheck
lin innovation_N = mkN "innovation" feminine ; -- tocheck
lin opera_N = mkN "opéra" masculine ; -- tocheck
lin lock_N = mkN "verrou" masculine | mkN "mèche" feminine | mkN "serrure" feminine | mkN "écluse" feminine ; -- tocheck
lin grin_V = variants{} ; -- 
lin shelf_N = mkN "étagère" feminine | mkN "rayon" masculine ; -- tocheck
lin pole_N = mkN "pôle" | mkN "perche" feminine ; -- tocheck
lin punishment_N = mkN "punition" feminine ; -- tocheck
lin strict_A = mkA "strict" ; -- tocheck
lin wave_V2 = mkV2 (mkV "onduler") | mkV2 (mkV "saluer") ; -- tocheck
lin wave_V = variants{}; -- mkV2 (mkV "onduler") | mkV2 (mkV "saluer") ; -- tocheck
lin inside_N = mkN "intérieur" masculine ; -- tocheck
lin carriage_N = mkN "wagon" masculine | mkN "carrosse" ; -- tocheck
lin fit_A = variants{} ; -- 
lin conversion_N = variants{} ; -- 
lin hurry_V = variants{}; -- mkV2V (reflV (mkV "dépêcher")) ; -- tocheck
lin essay_N = mkN "essai" masculine ; -- tocheck
lin integration_N = mkN "intégration" feminine ; -- tocheck
lin resignation_N = mkN "démission" feminine | mkN "résignation" feminine ; -- tocheck
lin treasury_N = mkN "trésorerie" feminine ; -- tocheck
lin traveller_N = mkN "voyageur" masculine ; -- tocheck
lin chocolate_N = mkN "chocolat" masculine ; -- tocheck
lin assault_N = mkN "assaut" masculine ; -- tocheck
lin schedule_N = mkN "planning" masculine ; -- tocheck
lin undoubtedly_Adv = variants{} ; -- 
lin twin_N = mkN "jumeau" masculine ; -- tocheck
lin format_N = mkN "format" masculine ; -- tocheck
lin murder_V2 = variants{} ; -- 
lin sigh_VS = variants{}; -- mkV2 (mkV "soupirer") ; -- tocheck
lin sigh_V2 = mkV2 (mkV "soupirer") ; -- tocheck
lin sigh_V = variants{}; -- mkV2 (mkV "soupirer") ; -- tocheck
lin sellerMasc_N = mkN "vendeur" masculine ;
lin lease_N = variants{} ; -- 
lin bitter_A = mkA "amer" | mkA "dur" | mkA "haineux" ; -- tocheck
lin double_V2 = mkV2 (mkV "doubler") ; -- tocheck
lin double_V = variants{}; -- mkV2 (mkV "doubler") ; -- tocheck
lin ally_N = mkN "allié" masculine ; -- tocheck
lin stake_N = mkN "pieu" masculine | mkN "enjeu" masculine ; -- tocheck
lin processing_N = variants{} ; -- 
lin informal_A = mkA "informel" ; -- tocheck
lin flexible_A = mkA "flexible" | mkA "souple" ; -- tocheck
lin cap_N = L.cap_N ;
lin stable_A = mkA "stable" ; -- tocheck
lin till_Subj = variants{} ; -- 
lin sympathy_N = mkN "sympathie" feminine | mkN "compassion" feminine ; -- tocheck
lin tunnel_N = mkN "tunnel" masculine ; -- tocheck
lin pen_N = L.pen_N ;
lin instal_V = variants{} ; -- 
lin suspend_V2 = mkV2 (mkV I.suspendre_V2) ; -- tocheck
lin suspend_V = variants{}; -- mkV2 (mkV I.suspendre_V2) ; -- tocheck
lin blow_N = mkN "coup" masculine ; -- tocheck
lin wander_V = variants{}; -- mkV2 (mkV "errer") ; -- tocheck
lin notably_Adv = variants{} ; -- 
lin disappoint_V2 = mkV2 (mkV I.décevoir_V2) ; -- tocheck
lin wipe_V2 = L.wipe_V2 ;
lin wipe_V = variants{}; -- L.wipe_V2 ;
lin folk_N = mkN "peuple" ; -- tocheck
lin attraction_N = mkN "attraction" feminine | mkN "attirance" feminine ; -- tocheck
lin disc_N = mkN "disque" masculine ; -- tocheck
lin inspire_V2V = mkV2V (mkV "inspirer") ; -- tocheck
lin inspire_V2 = variants{}; -- mkV2V (mkV "inspirer") ; -- tocheck
lin machinery_N = mkN "mécanique" feminine ; -- tocheck
lin undergo_V2 = mkV2 (mkV "subir") ; -- tocheck
lin nowhere_Adv = mkAdv "nulle part" ;
lin inspector_N = mkN "inspecteur" ;
lin wise_A = mkA "sage" ; -- tocheck
lin balance_V2 = mkV2 (mkV "apurer") ; -- tocheck
lin balance_V = variants{}; -- mkV2 (mkV "apurer") ; -- tocheck
lin purchaser_N = variants{} ; -- 
lin resort_N = mkN "sortie" ; -- tocheck
lin pop_N = mkN "pop" feminine ; -- tocheck
lin organ_N = mkN "orgue" masculine | mkN "organe" masculine ; -- tocheck
lin ease_V2 = variants{} ; -- 
lin ease_V = variants{} ; -- 
lin friendship_N = mkN "amitié" | mkN "amitié" feminine ; -- tocheck
lin deficit_N = variants{} ; -- 
lin dear_N = variants{} ; -- 
lin convey_V2 = mkV2 (mkV "transporter") | mkV2 (mkV "véhiculer") ; -- tocheck
lin reserve_V2 = mkV2 (mkV "réserver") ; -- tocheck
lin reserve_V = variants{}; -- mkV2 (mkV "réserver") ; -- tocheck
lin planet_N = L.planet_N ;
lin frequent_A = mkA "fréquent" ; -- tocheck
lin loose_A = mkA "lâche" ; -- tocheck
lin intense_A = mkA "intense" ; -- tocheck
lin retail_A = variants{} ; -- 
lin wind_V = variants{}; -- mkV2 (mkV "souffler") | mkV2 (mkV "essouffler") | mkV2 (mkV "remonter") | mkV2 (mkV "contourner") | mkV2 (mkV "tourner") | mkV2 (reflV (mkV "essouffler")) ; -- tocheck
lin lost_A = variants{} ; -- 
lin grain_N = mkN "grain" masculine ; -- tocheck
lin particle_N = mkN "particule" feminine ; -- tocheck
lin destruction_N = mkN "destruction" feminine ; -- tocheck
lin witness_V2 = mkV2 (mkV "témoigner") ; -- tocheck
lin witness_V = variants{}; -- mkV2 (mkV "témoigner") ; -- tocheck
lin pit_N = mkN "fosse" feminine | mkN "noyau" masculine ; -- tocheck
lin registration_N = mkN "enregistrement" masculine ; -- tocheck
lin conception_N = mkN "conception" feminine ; -- tocheck
lin steady_A = mkA "régulier" | mkA "lisse" ; -- tocheck
lin rival_N = mkN "rival" masculine ; -- tocheck
lin steam_N = mkN "vapeur" feminine | mkN "vapeur" masculine ; -- tocheck
lin back_A = variants{} ; -- 
lin chancellor_N = mkN "chancelier" masculine ; -- tocheck
lin crash_V = variants{}; -- mkV2 (mkV "planter") | mkV2 (reflV (mkV "écraser")) | mkV2 (mkV "pieuter") ; -- tocheck
lin belt_N = mkN "ceinture" feminine | mkN "courroie" feminine | mkN "région" feminine ; -- tocheck
lin logic_N = mkN "logique" feminine ; -- tocheck
lin premium_N = variants{} ; -- 
lin confront_V2 = mkV2 (mkV "confronter") ; -- tocheck
lin precede_V2 = mkV2 (mkV "précéder") ; -- tocheck
lin experimental_A = variants{} ; -- 
lin alarm_N = mkN "alarme" feminine | mkN "réveille-matin" masculine ; -- tocheck
lin rational_A = mkA "rationnel" | mkA "raisonnable" ; -- tocheck
lin incentive_N = mkN "récompense" feminine | mkN "intérêt" masculine ; -- tocheck
lin roughly_Adv = variants{} ; -- 
lin bench_N = mkN "banc" masculine ; -- tocheck
lin wrap_V2 = mkV2 (mkV "envelopper") ; -- tocheck
lin wrap_V = variants{}; -- mkV2 (mkV "envelopper") ; -- tocheck
lin regarding_Prep = mkPrep "à propos" ;
lin inadequate_A = mkA "inadéquat" ; -- tocheck
lin ambition_N = mkN "ambition" feminine ; -- tocheck
lin since_Adv = mkAdv "depuis" ;
lin fate_N = mkN "destin" masculine ; -- tocheck
lin vendor_N = mkN "vendeur" ; -- tocheck
lin stranger_N = mkN "étranger" masculine | mkN "inconnu" masculine ; -- tocheck
lin spiritual_A = mkA "spirituel" ; -- tocheck
lin increasing_A = variants{} ; -- 
lin anticipate_VV = variants{}; -- mkV2 (mkV "anticiper") ; -- tocheck
lin anticipate_VS = variants{}; -- mkV2 (mkV "anticiper") ; -- tocheck
lin anticipate_V2 = mkV2 (mkV "anticiper") ; -- tocheck
lin anticipate_V = variants{}; -- mkV2 (mkV "anticiper") ; -- tocheck
lin logical_A = mkA "logique" ; -- tocheck
lin fibre_N = mkN "fibre" feminine ; -- tocheck
lin attribute_V2 = mkV2 (mkV "attribuer") ; -- tocheck
lin sense_VS = variants{}; -- mkV2 (mkV I.sentir_V2) ; -- tocheck
lin sense_V2 = mkV2 (mkV I.sentir_V2) ; -- tocheck
lin black_N = mkN "noir" | mkN "Noir" masculine ; -- tocheck
lin petrol_N = variants{} ; -- 
lin maker_N = mkN "fabricant" masculine ; -- tocheck
lin generous_A = mkA "généreux" ; -- tocheck
lin allocation_N = mkN "allocation" feminine ; -- tocheck
lin depression_N = mkN "dépression" feminine | mkN "dépression" ; -- tocheck
lin declaration_N = mkN "déclaration" feminine ; -- tocheck
lin spot_VS = variants{}; -- mkV2 (mkV "détacher") | mkV2 (mkV "détecter") | mkV2 (mkV "tacher") ; -- tocheck
lin spot_V2 = mkV2 (mkV "détacher") | mkV2 (mkV "détecter") | mkV2 (mkV "tacher") ; -- tocheck
lin spot_V = variants{}; -- mkV2 (mkV "détacher") | mkV2 (mkV "détecter") | mkV2 (mkV "tacher") ; -- tocheck
lin modest_A = mkA "modeste" ; -- tocheck
lin bottom_A = variants{} ; -- 
lin dividend_N = mkN "dividende" masculine ; -- tocheck
lin devote_V2 = mkV2 (mkV "consacrer") ; -- tocheck
lin condemn_V2 = mkV2 (mkV "condamner") ; -- tocheck
lin integrate_V2 = variants{} ; -- 
lin integrate_V = variants{} ; -- 
lin pile_N = mkN "pile" feminine | mkN "monceau" masculine | mkN "pieu" ; -- tocheck
lin identification_N = mkN "identification" feminine ; -- tocheck
lin acute_A = mkA "aigu" ; -- tocheck
lin barely_Adv = variants{} ; -- 
lin providing_Subj = variants{} ; -- 
lin directive_N = mkN "directive" feminine ; -- tocheck
lin bet_VS = variants{}; -- mkV2 (mkV "parier") ; -- tocheck
lin bet_V2 = mkV2 (mkV "parier") ; -- tocheck
lin bet_V = variants{}; -- mkV2 (mkV "parier") ; -- tocheck
lin modify_V2 = mkV2 (mkV "modifier") ; -- tocheck
lin bare_A = mkA "nu" ; -- tocheck
lin swear_VV = variants{}; -- mkV2V (mkV "jurer") ; -- tocheck
lin swear_V2 = variants{}; -- mkV2V (mkV "jurer") ; -- tocheck
lin swear_V = variants{}; -- mkV2V (mkV "jurer") ; -- tocheck
lin final_N = variants{} ; -- 
lin accordingly_Adv = variants{} ; -- 
lin valid_A = mkA "valide" ; -- tocheck
lin wherever_Adv = variants{} ; -- 
lin mortality_N = mkN "mortalité" feminine ; -- tocheck
lin medium_N = mkN "médium" masculine | mkN "moyen" | mkN "milieu" masculine | mkN "médium" ; -- tocheck
lin silk_N = mkN "soie" feminine ; -- tocheck
lin funeral_N = mkN "funérailles" ; -- tocheck
lin depending_A = variants{} ; -- 
lin cow_N = L.cow_N ;
lin correspond_V2 = variants{} ; -- 
lin correspond_V = variants{} ; -- 
lin cite_V2 = variants{} ; -- 
lin classic_A = mkA "classique" ; -- tocheck
lin inspection_N = mkN "inspection" feminine ; -- tocheck
lin calculation_N = variants{} ; -- 
lin rubbish_N = mkN "ordures" | mkN "absurdité" feminine ; -- tocheck
lin minimum_N = mkN "minimum" masculine ; -- tocheck
lin hypothesis_N = mkN "hypothèse" feminine ; -- tocheck
lin youngster_N = variants{} ; -- 
lin slope_N = mkN "pente" feminine ; -- tocheck
lin patch_N = mkN "patch" masculine ; -- tocheck
lin invitation_N = mkN "invitation" feminine ; -- tocheck
lin ethnic_A = mkA "ethnique" ; -- tocheck
lin federation_N = mkN "fédération" feminine ; -- tocheck
lin duke_N = mkN "duc" masculine ; -- tocheck
lin wholly_Adv = variants{} ; -- 
lin closure_N = mkN "fermeture" ; -- tocheck
lin dictionary_N = mkN "dictionnaire" masculine ; -- tocheck
lin withdrawal_N = mkN "retrait" masculine | mkN "sevrage" ; -- tocheck
lin automatic_A = mkA "automatique" ; -- tocheck
lin liable_A = mkA "responsable" ; -- tocheck
lin cry_N = mkN "pleur" masculine | mkN "cri" masculine ; -- tocheck
lin slow_V2 = mkV2 (mkV "ralentir") ; -- tocheck
lin slow_V = variants{}; -- mkV2 (mkV "ralentir") ; -- tocheck
lin borough_N = mkN "arrondissement" masculine ; -- tocheck
lin well_A = variants{} ; -- 
lin suspicion_N = mkN "suspicion" feminine | mkN "soupçon" ; -- tocheck
lin portrait_N = mkN "portrait" masculine ; -- tocheck
lin local_N = mkN "section" feminine ; -- tocheck
lin jew_N = variants{} ; -- 
lin fragment_N = mkN "fragment" masculine ; -- tocheck
lin revolutionary_A = mkA "révolutionnaire" ; -- tocheck
lin evaluate_V2 = mkV2 (mkV "évaluer") ; -- tocheck
lin evaluate_V = variants{}; -- mkV2 (mkV "évaluer") ; -- tocheck
lin competitor_N = mkN "compétiteur" masculine ; -- tocheck
lin sole_A = mkA "unique" | mkA "célibataire" ; -- tocheck
lin reliable_A = mkA "fiable" ; -- tocheck
lin weigh_V2 = mkV2 (mkV "peser") ; -- tocheck
lin weigh_V = variants{}; -- mkV2 (mkV "peser") ; -- tocheck
lin medieval_A = mkA "médiéval" ; -- tocheck
lin clinic_N = mkN "clinique" feminine ; -- tocheck
lin shine_V2 = mkV2 (mkV "briller") ; -- tocheck
lin shine_V = variants{}; -- mkV2 (mkV "briller") ; -- tocheck
lin knit_V2 = mkV2 (reflV (mkV "souder")) | mkV2 (mkV "tricoter") | mkV2 (mkV I.construire_V2) | mkV2 (mkV "souder") ; -- tocheck
lin knit_V = variants{}; -- mkV2 (reflV (mkV "souder")) | mkV2 (mkV "tricoter") | mkV2 (mkV I.construire_V2) | mkV2 (mkV "souder") ; -- tocheck
lin complexity_N = mkN "complexité" feminine ; -- tocheck
lin remedy_N = mkN "recours" masculine | mkN "remède" masculine ; -- tocheck
lin fence_N = mkN "clôture" feminine ; -- tocheck
lin bike_N = L.bike_N ;
lin freeze_V2 = mkV2 (reflV (mkV "figer")) | mkV2 (mkV "geler") | mkV2 (mkV "congeler") ; -- tocheck
lin freeze_V = L.freeze_V ;
lin eliminate_V2 = mkV2 (mkV "tuer") ; -- tocheck
lin interior_N = mkN "intérieur" masculine ; -- tocheck
lin intellectual_A = mkA "intellectuel" ; -- tocheck
lin established_A = variants{} ; -- 
lin voter_N = mkN "votant" ; -- tocheck
lin garage_N = mkN "garage" masculine | mkN "garage" ; -- tocheck
lin era_N = mkN "ère" feminine ; -- tocheck
lin pregnant_A = mkA "enceinte" ; -- tocheck
lin plot_N = mkN "lopin" masculine | mkN "diagramme" masculine | mkN "complot" masculine | mkN "intrigue" feminine ; -- tocheck
lin greet_V2 = mkV2 (mkV "saluer") ; -- tocheck
lin electrical_A = mkA "électrique" ; -- tocheck
lin lie_N = mkN "mensonge" masculine ; -- tocheck
lin disorder_N = mkN "trouble" masculine | mkN "désordre" masculine ; -- tocheck
lin formally_Adv = variants{} ; -- 
lin excuse_N = mkN "prétexte" masculine ; -- tocheck
lin socialist_A = mkA "socialiste" ; -- tocheck
lin cancel_V2 = mkV2 (mkV "annuler") | mkV2 (mkV "neutraliser") | mkV2 (mkV "éliminer") ; -- tocheck
lin cancel_V = variants{}; -- mkV2 (mkV "annuler") | mkV2 (mkV "neutraliser") | mkV2 (mkV "éliminer") ; -- tocheck
lin harm_N = mkN "mal" masculine ; -- tocheck
lin excess_N = mkN "excès" masculine | mkN "franchise" feminine ; -- tocheck
lin exact_A = mkA "exact" ; -- tocheck
lin oblige_V2V = mkV2V (mkV "imposer") ; -- tocheck
lin oblige_V2 = variants{}; -- mkV2V (mkV "imposer") ; -- tocheck
lin accountant_N = mkN "comptable" | mkN "expert-comptable" masculine ; -- tocheck
lin mutual_A = mkA "mutuel" ; -- tocheck
lin fat_N = L.fat_N ;
lin volunteerMasc_N = mkN "volontaire" masculine ;
lin laughter_N = mkN "rire" masculine ; -- tocheck
lin trick_N = mkN "truc" masculine | mkN "tour" masculine | mkN "pli" masculine ; -- tocheck
lin load_V2 = mkV2 (mkV "charger") ; -- tocheck
lin load_V = variants{}; -- mkV2 (mkV "charger") ; -- tocheck
lin disposal_N = variants{} ; -- 
lin taxi_N = mkN "taxi" masculine ; -- tocheck
lin murmur_V2 = mkV2 (mkV "murmurer") ; -- tocheck
lin murmur_V = variants{}; -- mkV2 (mkV "murmurer") ; -- tocheck
lin tonne_N = mkN "tonne" feminine ; -- tocheck
lin spell_V2 = mkV2 (mkV "épeler") ; -- tocheck
lin spell_V = variants{}; -- mkV2 (mkV "épeler") ; -- tocheck
lin clerk_N = mkN "greffier" masculine ; -- tocheck
lin curious_A = mkA "curieux" ; -- tocheck
lin satisfactory_A = mkA "satisfaisant" ; -- tocheck
lin identical_A = mkA "identique" | mkA "monozygote" ; -- tocheck
lin applicant_N = mkN "demandeur" masculine ; -- tocheck
lin removal_N = mkN "enlèvement" masculine | mkN "déménagement" masculine ; -- tocheck
lin processor_N = mkN "processeur" masculine ; -- tocheck
lin cotton_N = mkN "coton" | mkN "coton" masculine ; -- tocheck
lin reverse_V2 = mkV2 (mkV "retourner") ; -- tocheck
lin reverse_V = variants{}; -- mkV2 (mkV "retourner") ; -- tocheck
lin hesitate_VV = variants{}; -- mkV (mkV "hésiter") ; -- tocheck
lin hesitate_V = mkV (mkV "hésiter") ; -- tocheck
lin professor_N = mkN "professeur" masculine ; -- tocheck
lin admire_V2 = mkV2 (mkV "admirer") ; -- tocheck
lin namely_Adv = mkAdv "nommément" ; -- tocheck
lin electoral_A = mkA "électoral" ; -- tocheck
lin delight_N = mkN "plaisir" ; -- tocheck
lin urgent_A = mkA "urgent" ; -- tocheck
lin prompt_V2V = mkV2V (mkV "inciter") ; -- tocheck
lin prompt_V2 = variants{}; -- mkV2V (mkV "inciter") ; -- tocheck
lin mate_N = mkN "copain" masculine ; -- tocheck
lin mate_2_N = variants{} ; -- 
lin mate_1_N = variants{} ; -- 
lin exposure_N = mkN "exposition" feminine ; -- tocheck
lin server_N = mkN "serveur" masculine | mkN "serviteur" masculine | mkN "serveur" ; -- tocheck
lin distinctive_A = mkA "distinctif" ; -- tocheck
lin marginal_A = mkA "médiocre" | mkA "adjacent" | mkA "marginal" | mkA "pauvre" ; -- tocheck
lin structural_A = mkA "structurel" ; -- tocheck
lin rope_N = L.rope_N ;
lin miner_N = mkN "mineur" masculine ; -- tocheck
lin entertainment_N = mkN "divertissement" masculine ; -- tocheck
lin acre_N = mkN "acre" feminine ; -- tocheck
lin pig_N = mkN "flic" masculine | mkN "cochon" masculine | mkN "salaud" masculine ; -- tocheck
lin encouraging_A = variants{} ; -- 
lin guarantee_N = mkN "garantie" feminine | mkN "garant" ; -- tocheck
lin gear_N = mkN "engrenage" masculine | mkN "vitesse" feminine ; -- tocheck
lin anniversary_N = mkN "anniversaire" masculine ; -- tocheck
lin past_Adv = variants{} ; -- 
lin ceremony_N = mkN "cérémonie" feminine | mkN "cérémonie" ; -- tocheck
lin rub_V2 = L.rub_V2 ;
lin rub_V = variants{}; -- L.rub_V2 ;
lin monopoly_N = mkN "monopole" masculine ; -- tocheck
lin left_N = mkN "gauche" feminine ; -- tocheck
lin flee_V2 = mkV2 (reflV (mkV I.enfuir_V)) | mkV2 (mkV I.fuir_V2) ; -- tocheck
lin flee_V = variants{}; -- mkV2 (reflV (mkV I.enfuir_V)) | mkV2 (mkV I.fuir_V2) ; -- tocheck
lin yield_V2 = mkV2 (reflV (mkV I.rendre_V2)) | mkV2 (mkV "céder") | mkV2 (mkV "retourner") | mkV2 (mkV "rapporter") ; -- tocheck
lin discount_N = mkN "rabais" masculine ; -- tocheck
lin above_A = variants{} ; -- 
lin uncle_N = mkN "oncle" masculine ; -- tocheck
lin audit_N = mkN "audit" | mkN "inspection" feminine | mkN "audit" masculine ; -- tocheck
lin advertisement_N = mkN "publicité" feminine ; -- tocheck
lin explosion_N = mkN "explosion" feminine ; -- tocheck
lin contrary_A = variants{} ; -- 
lin tribunal_N = mkN "tribunal" masculine ; -- tocheck
lin swallow_V2 = mkV2 (mkV "avaler") ; -- tocheck
lin swallow_V = variants{}; -- mkV2 (mkV "avaler") ; -- tocheck
lin typically_Adv = variants{} ; -- 
lin fun_A = variants{} ; -- 
lin rat_N = mkN "rat" masculine ; -- tocheck
lin cloth_N = mkN "tenue" feminine | mkN "tissu" masculine ; -- tocheck
lin cable_N = mkN "câble" masculine ; -- tocheck
lin interrupt_V2 = mkV2 (mkV I.interrompre_V2) ; -- tocheck
lin interrupt_V = variants{}; -- mkV2 (mkV I.interrompre_V2) ; -- tocheck
lin crash_N = mkN "descente" feminine | mkN "plantage" masculine | mkN "krach" masculine ; -- tocheck
lin flame_N = mkN "polémique" feminine | mkN "flamme" feminine ; -- tocheck
lin controversy_N = mkN "controverse" feminine ; -- tocheck
lin rabbit_N = mkN "lapin" masculine ; -- tocheck
lin everyday_A = mkA "usuel" ; -- tocheck
lin allegation_N = mkN "assertion" ; -- tocheck
lin strip_N = mkN "bande" feminine ; -- tocheck
lin stability_N = mkN "stabilité" | mkN "stabilité" feminine ; -- tocheck
lin tide_N = mkN "marée" feminine | mkN "tendance" feminine ; -- tocheck
lin illustration_N = mkN "illustration" feminine ; -- tocheck
lin insect_N = mkN "insecte" masculine ; -- tocheck
lin correspondent_N = variants{} ; -- 
lin devise_V2 = variants{} ; -- 
lin determined_A = variants{} ; -- 
lin brush_V2 = mkV2 (mkV I.peindre_V2) | mkV2 (mkV "brosser") ; -- tocheck
lin brush_V = variants{}; -- mkV2 (mkV I.peindre_V2) | mkV2 (mkV "brosser") ; -- tocheck
lin adjustment_N = mkN "ajustement" masculine ; -- tocheck
lin controversial_A = mkA "controversé" ; -- tocheck
lin organic_A = mkA "organique" | mkA "bio" ; -- tocheck
lin escape_N = mkN "évasion" feminine ; -- tocheck
lin thoroughly_Adv = variants{} ; -- 
lin interface_N = mkN "interface" feminine ; -- tocheck
lin historic_A = mkA "historique" ; -- tocheck
lin collapse_N = mkN "effondrement" masculine ; -- tocheck
lin temple_N = mkN "tempe" feminine | mkN "temple" masculine ; -- tocheck
lin shade_N = mkN "esprit" masculine | mkN "ombre" feminine | mkN "store" masculine | mkN "nuance" feminine ; -- tocheck
lin craft_N = variants{} ; -- 
lin nursery_N = mkN "crèche" feminine | mkN "pépinière" masculine ; -- tocheck
lin piano_N = mkN "piano" masculine ; -- tocheck
lin desirable_A = mkA "souhaitable" ; -- tocheck
lin assurance_N = mkN "assurance" ; -- tocheck
lin jurisdiction_N = mkN "juridiction" feminine ; -- tocheck
lin advertise_V2 = mkV2 (mkV "annoncer") | mkV2 (mkV "afficher") ; -- tocheck
lin advertise_V = variants{}; -- mkV2 (mkV "annoncer") | mkV2 (mkV "afficher") ; -- tocheck
lin bay_N = mkN "laurier" masculine | mkN "baie" feminine | mkN "compartiment" masculine ; -- tocheck
lin specification_N = mkN "spécification" feminine ; -- tocheck
lin disability_N = mkN "infirmité" feminine | mkN "invalidité" feminine ; -- tocheck
lin presidential_A = mkA "présidentiel" ; -- tocheck
lin arrest_N = mkN "arrestation" feminine ; -- tocheck
lin unexpected_A = mkA "inattendu" ; -- tocheck
lin switch_N = mkN "commutateur" masculine | mkN "interrupteur" masculine | mkN "badine" feminine ; -- tocheck
lin penny_N = mkN "penny" masculine ; -- tocheck
lin respect_V2 = mkV2 (mkV "respecter") ; -- tocheck
lin celebration_N = mkN "célébration" feminine ; -- tocheck
lin gross_A = mkA "grossier" | mkA "dégoûtant" | mkA "brut" ; -- tocheck
lin aid_V2 = mkV2 (mkV "aider") ; -- tocheck
lin aid_V = variants{}; -- mkV2 (mkV "aider") ; -- tocheck
lin superb_A = mkA "superbe" ;
lin process_V2 = mkV2 (mkV "traiter}") ; -- tocheck
lin process_V = variants{}; -- mkV2 (mkV "traiter}") ; -- tocheck
lin innocent_A = mkA "innocent" ; -- tocheck
lin leap_V2 = mkV2 (mkV "sauter") ; -- tocheck
lin leap_V = variants{}; -- mkV2 (mkV "sauter") ; -- tocheck
lin colony_N = mkN "colonie" feminine ; -- tocheck
lin wound_N = mkN "blessure" feminine ; -- tocheck
lin hardware_N = mkN "matériel" masculine ; -- tocheck
lin satellite_N = mkN "satellite" masculine ; -- tocheck
lin float_V = L.float_V ;
lin bible_N = mkN "Bible" feminine ; -- tocheck
lin statistical_A = mkA "statistique" ; -- tocheck
lin marked_A = variants{} ; -- 
lin hire_V2V = mkV2V (mkV "louer") | mkV2V (mkV "embaucher") ; -- tocheck
lin hire_V2 = variants{}; -- mkV2V (mkV "louer") | mkV2V (mkV "embaucher") ; -- tocheck
lin cathedral_N = mkN "cathédrale" feminine ; -- tocheck
lin motive_N = mkN "motif" masculine ; -- tocheck
lin correct_VS = variants{}; -- mkV2 (mkV "corriger") ; -- tocheck
lin correct_V2 = mkV2 (mkV "corriger") ; -- tocheck
lin correct_V = variants{}; -- mkV2 (mkV "corriger") ; -- tocheck
lin gastric_A = mkA "gastrique" ; -- tocheck
lin raid_N = mkN "raid" masculine ; -- tocheck
lin comply_V2 = mkV2 (reflV (mkV "conformer")) ; -- tocheck
lin comply_V = variants{}; -- mkV2 (reflV (mkV "conformer")) ; -- tocheck
lin accommodate_V2 = mkV2 (mkV "accommoder") ; -- tocheck
lin accommodate_V = variants{}; -- mkV2 (mkV "accommoder") ; -- tocheck
lin mutter_V2 = mkV2 (mkV "grogner") | mkV2 (mkV "marmonner") | mkV2 (mkV "grommeler") ; -- tocheck
lin mutter_V = variants{}; -- mkV2 (mkV "grogner") | mkV2 (mkV "marmonner") | mkV2 (mkV "grommeler") ; -- tocheck
lin induce_V2 = variants{} ; -- 
lin trap_V2 = mkV2 (mkV "intercepter") | mkV2 (mkV "piéger") ; -- tocheck
lin trap_V = variants{}; -- mkV2 (mkV "intercepter") | mkV2 (mkV "piéger") ; -- tocheck
lin invasion_N = mkN "invasion" ; -- tocheck
lin humour_N = mkN "humour" masculine | mkN "humeur" masculine ; -- tocheck
lin bulk_N = mkN "masse" | mkN "vrac" masculine ; -- tocheck
lin traditionally_Adv = variants{} ; -- 
lin commission_V2V = mkV2V (mkV "commander") | mkV2V (mkV "charger") ; -- tocheck
lin commission_V2 = variants{}; -- mkV2V (mkV "commander") | mkV2V (mkV "charger") ; -- tocheck
lin upstairs_Adv = variants{} ; -- 
lin translate_V2 = mkV2 (mkV I.traduire_V2) ;
lin translate_V = variants{}; -- mkV2 (mkV I.traduire_V2) ;
lin rhythm_N = mkN "rythme" masculine ; -- tocheck
lin emission_N = variants{} ; -- 
lin collective_A = variants{} ; -- 
lin transformation_N = mkN "transformation" feminine ; -- tocheck
lin battery_N = mkN "pile" feminine | mkN "batterie" feminine ; -- tocheck
lin stimulus_N = mkN "stimulus" masculine ; -- tocheck
lin naked_A = mkA "nu" ; -- tocheck
lin white_N = mkN "blanc" masculine ; -- tocheck
lin menu_N = mkN "menu" masculine | mkN "carte" feminine ; -- tocheck
lin toilet_N = mkN "toilettes" feminine | mkN "toilettes" | mkN "toilette" feminine ; -- tocheck
lin butter_N = L.butter_N ;
lin surprise_V2V = mkV2V (mkV I.surprendre_V2) ; -- tocheck
lin surprise_V2 = variants{}; -- mkV2V (mkV I.surprendre_V2) ; -- tocheck
lin needle_N = mkN "aiguille" feminine ; -- tocheck
lin effectiveness_N = mkN "efficacité" ; -- tocheck
lin accordance_N = mkN "accordance" feminine ; -- tocheck
lin molecule_N = mkN "molécule" feminine ; -- tocheck
lin fiction_N = mkN "fiction" feminine ; -- tocheck
lin learning_N = mkN "apprentissage" ; -- tocheck
lin statute_N = mkN "statut" masculine ; -- tocheck
lin reluctant_A = mkA "réservé" ; -- tocheck
lin overlook_V2 = mkV2 (mkV "surveiller") | mkV2 (mkV "négliger") | mkV2 (mkV "surplomber") ; -- tocheck
lin junction_N = mkN "jonction" feminine ; -- tocheck
lin necessity_N = mkN "nécessité" | mkN "nécessité" feminine ; -- tocheck
lin nearby_A = mkA "proche" ; -- tocheck
lin experienced_A = mkA "expérimenté" ; -- tocheck
lin lorry_N = variants{} ; -- 
lin exclusive_A = mkA "exclusif" ; -- tocheck
lin graphics_N = mkN "graphiques" | mkN "graphisme" masculine ; -- tocheck
lin stimulate_V2 = mkV2 (mkV "stimuler") ; -- tocheck
lin warmth_N = mkN "chaleur" feminine ; -- tocheck
lin therapy_N = mkN "thérapie" ; -- tocheck
lin convenient_A = mkA "commode" ; -- tocheck
lin cinema_N = mkN "cinéma" masculine | mkN "film" masculine ; -- tocheck
lin domain_N = mkN "domaine" masculine | mkN "domaine" feminine ; -- tocheck
lin tournament_N = mkN "tournoi" masculine ; -- tocheck
lin doctrine_N = mkN "doctrine" feminine ; -- tocheck
lin sheer_A = mkA "pur" | mkA "vertical" | mkA "transparent" ; -- tocheck
lin proposition_N = mkN "proposition" feminine ; -- tocheck
lin grip_N = mkN "poignée" feminine ; -- tocheck
lin widow_N = mkN "veuve" feminine ; -- tocheck
lin discrimination_N = mkN "discrimination" feminine ; -- tocheck
lin bloody_Adv = variants{} ; -- 
lin ruling_A = variants{} ; -- 
lin fit_N = mkN "crise" feminine ; -- tocheck
lin nonetheless_Adv = variants{} ; -- 
lin myth_N = mkN "mythe" ; -- tocheck
lin episode_N = mkN "épisode" masculine ; -- tocheck
lin drift_V2 = mkV2 (mkV "dévier") | mkV2 (mkV "errer") | mkV2 (mkV "dériver") ; -- tocheck
lin drift_V = variants{}; -- mkV2 (mkV "dévier") | mkV2 (mkV "errer") | mkV2 (mkV "dériver") ; -- tocheck
lin assert_VS = variants{}; -- mkV2 (mkV I.asseoir_V2) ; -- tocheck
lin assert_V2 = mkV2 (mkV I.asseoir_V2) ; -- tocheck
lin assert_V = variants{}; -- mkV2 (mkV I.asseoir_V2) ; -- tocheck
lin terrace_N = mkN "terrasse" feminine | mkN "gradins" ; -- tocheck
lin uncertain_A = L.uncertain_A ;
lin twist_V2 = mkV2 (mkV "entortiller") ; -- tocheck
lin insight_N = mkN "fr" | mkN "visibilité" feminine ; -- tocheck
lin undermine_V2 = mkV2 (mkV "saper") ; -- tocheck
lin tragedy_N = mkN "tragédie" feminine ; -- tocheck
lin enforce_V2 = variants{} ; -- 
lin criticize_V2 = variants{} ; -- 
lin criticize_V = variants{} ; -- 
lin march_V2 = mkV2 (mkV "marcher") ; -- tocheck
lin march_V = variants{}; -- mkV2 (mkV "marcher") ; -- tocheck
lin leaflet_N = mkN "foliole" feminine | mkN "tract" ; -- tocheck
lin fellow_A = variants{} ; -- 
lin object_V2 = mkV2 (reflV (mkV "opposer")) ; -- tocheck
lin object_V = variants{}; -- mkV2 (reflV (mkV "opposer")) ; -- tocheck
lin pond_N = mkN "étang" masculine ; -- tocheck
lin adventure_N = mkN "aventure" feminine ; -- tocheck
lin diplomatic_A = mkA "diplomatique" ; -- tocheck
lin mixed_A = variants{} ; -- 
lin rebel_N = mkN "rebelle" masculine ; -- tocheck
lin equity_N = mkN "action" feminine | mkN "impartialité" feminine ; -- tocheck
lin literally_Adv = variants{} ; -- 
lin magnificent_A = mkA "magnifique" ; -- tocheck
lin loyalty_N = mkN "loyauté" feminine ; -- tocheck
lin tremendous_A = mkA "formidable" | mkA "énorme" ; -- tocheck
lin airline_N = variants{} ; -- 
lin shore_N = mkN "bord" masculine ; -- tocheck
lin restoration_N = mkN "restauration" feminine ; -- tocheck
lin physically_Adv = variants{} ; -- 
lin render_V2 = mkV2 (mkV I.rendre_V2) | mkV2 (mkV "interpréter") ; -- tocheck
lin institutional_A = variants{} ; -- 
lin emphasize_VS = variants{}; -- mkV2 (mkV "souligner") ; -- tocheck
lin emphasize_V2 = mkV2 (mkV "souligner") ; -- tocheck
lin mess_N = mkN "fouillis" masculine | mkN "messe" feminine ; -- tocheck
lin commander_N = mkN "commandant" masculine ; -- tocheck
lin straightforward_A = mkA "direct" ; -- tocheck
lin singer_N = mkN "chanteur" masculine ; -- tocheck
lin squeeze_V2 = L.squeeze_V2 ;
lin squeeze_V = variants{}; -- L.squeeze_V2 ;
lin full_time_A = variants{} ; -- 
lin breed_V2 = mkV2 (reflV (mkV I.reproduire_V2)) ; -- tocheck
lin breed_V = variants{}; -- mkV2 (reflV (mkV I.reproduire_V2)) ; -- tocheck
lin successor_N = mkN "successeur" masculine ; -- tocheck
lin triumph_N = mkN "triomphe" masculine ; -- tocheck
lin heading_N = variants{} ; -- 
lin mathematics_N = mkN "mathématiques" ; -- tocheck
lin laugh_N = mkN "rire" masculine ; -- tocheck
lin clue_N = mkN "indice" feminine | mkN "preuve" feminine ; -- tocheck
lin still_A = mkA "calme" ; -- tocheck
lin ease_N = mkN "facilité" feminine | mkN "repos" masculine ; -- tocheck
lin specially_Adv = variants{} ; -- 
lin biological_A = mkA "biologique" ; -- tocheck
lin forgive_V2 = mkV2 (mkV "pardonner") ; -- tocheck
lin forgive_V = variants{}; -- mkV2 (mkV "pardonner") ; -- tocheck
lin trustee_N = variants{} ; -- 
lin photo_N = mkN "photo" feminine ; -- tocheck
lin fraction_N = mkN "fraction" feminine ; -- tocheck
lin chase_V2 = mkV2 (mkV I.poursuivre_V2) ; -- tocheck
lin chase_V = variants{}; -- mkV2 (mkV I.poursuivre_V2) ; -- tocheck
lin whereby_Adv = variants{} ; -- 
lin mud_N = mkN "boue" feminine ; -- tocheck
lin pensioner_N = variants{} ; -- 
lin functional_A = mkA "fonctionnel" ; -- tocheck
lin copy_V2 = mkV2 (mkV "imiter") | mkV2 (mkV "copier") | mkV2 (mkV I.recevoir_V2) ; -- tocheck
lin copy_V = variants{}; -- mkV2 (mkV "imiter") | mkV2 (mkV "copier") | mkV2 (mkV I.recevoir_V2) ; -- tocheck
lin strictly_Adv = variants{} ; -- 
lin desperately_Adv = variants{} ; -- 
lin await_V2 = mkV2 (mkV I.attendre_V2) | mkV2 (mkV I.servir_V2) ; -- tocheck
lin coverage_N = mkN "couverture" feminine ; -- tocheck
lin wildlife_N = mkN "nature" feminine ; -- tocheck
lin indicator_N = mkN "indicateur" masculine | mkN "aiguille" feminine | mkN "clignotant" masculine ; -- tocheck
lin lightly_Adv = variants{} ; -- 
lin hierarchy_N = mkN "hiérarchie" feminine ; -- tocheck
lin evolve_V2 = mkV2 (mkV "élaborer") | mkV2 (mkV "évoluer") ; -- tocheck
lin evolve_V = variants{}; -- mkV2 (mkV "élaborer") | mkV2 (mkV "évoluer") ; -- tocheck
lin mechanical_A = mkA "mécanique" ; -- tocheck
lin expert_A = variants{} ; -- 
lin creditor_N = mkN "créancier" masculine ; -- tocheck
lin capitalist_N = mkN "capitaliste" ; -- tocheck
lin essence_N = mkN "essence" feminine ; -- tocheck
lin compose_V2 = mkV2 (mkV "composer") ; -- tocheck
lin compose_V = variants{}; -- mkV2 (mkV "composer") ; -- tocheck
lin mentally_Adv = variants{} ; -- 
lin gaze_N = variants{} ; -- 
lin seminar_N = mkN "séminaire" masculine ; -- tocheck
lin target_V2V = mkV2V (mkV "cibler") ; -- tocheck
lin target_V2 = variants{}; -- mkV2V (mkV "cibler") ; -- tocheck
lin label_V3 = mkV3 (mkV "étiqueter") ; -- tocheck
lin label_V2 = variants{}; -- mkV3 (mkV "étiqueter") ; -- tocheck
lin label_V = variants{}; -- mkV3 (mkV "étiqueter") ; -- tocheck
lin fig_N = mkN "figue" feminine | mkN "figuier" masculine ; -- tocheck
lin continent_N = mkN "continent" masculine ; -- tocheck
lin chap_N = mkN "bougre" masculine ; -- tocheck
lin flexibility_N = mkN "souplesse" feminine ; -- tocheck
lin verse_N = mkN "verset" masculine | mkN "couplet" masculine | mkN "vers" masculine ; -- tocheck
lin minute_A = mkA "minuscule" | mkA "minutieux" ; -- tocheck
lin whisky_N = variants{} ; -- 
lin equivalent_A = mkA "équivalent" ; -- tocheck
lin recruit_V2 = mkV2 (mkV "recruter") ; -- tocheck
lin recruit_V = variants{}; -- mkV2 (mkV "recruter") ; -- tocheck
lin echo_V2 = variants{} ; -- 
lin echo_V = variants{} ; -- 
lin unfair_A = mkA "injuste" ; -- tocheck
lin launch_N = mkN "lancement" masculine ; -- tocheck
lin cupboard_N = mkN "armoire" feminine ; -- tocheck
lin bush_N = mkN "buisson" masculine | mkN "touffe" feminine | mkN "maquis" masculine ; -- tocheck
lin shortage_N = mkN "défaut" masculine ; -- tocheck
lin prominent_A = mkA "proéminent" | mkA "protubérant" ; -- tocheck
lin merger_N = mkN "fusion" | mkN "fusion" feminine ; -- tocheck
lin command_V2 = mkV2 (mkV "commander") ; -- tocheck
lin command_V = variants{}; -- mkV2 (mkV "commander") ; -- tocheck
lin subtle_A = mkA "astucieux" | mkA "subtil" ; -- tocheck
lin capital_A = mkA "excellent" | mkA "capital" | mkA "majuscule" ; -- tocheck
lin gang_N = mkN "bande" feminine ; -- tocheck
lin fish_V2 = variants{} ; -- 
lin fish_V = variants{} ; -- 
lin unhappy_A = mkA "malheureux" | mkA "mécontent" ; -- tocheck
lin lifetime_N = mkN "éternité" feminine ; -- tocheck
lin elite_N = mkN "élite" feminine ; -- tocheck
lin refusal_N = mkN "refus" masculine ; -- tocheck
lin finish_N = mkN "fin" feminine | mkN "fini" masculine ; -- tocheck
lin aggressive_A = mkA "agressif" ; -- tocheck
lin superior_A = mkA "supérieur" ; -- tocheck
lin landing_N = mkN "palier" masculine | mkN "atterrissage" masculine ; -- tocheck
lin exchange_V2 = mkV2 (mkV "échanger") ; -- tocheck
lin debate_V2 = mkV2 (mkV I.débattre_V2) ; -- tocheck
lin debate_V = variants{}; -- mkV2 (mkV I.débattre_V2) ; -- tocheck
lin educate_V2 = mkV2 (mkV "éduquer") ; -- tocheck
lin separation_N = mkN "séparation" feminine ; -- tocheck
lin productivity_N = mkN "productivité" ; -- tocheck
lin initiate_V2 = variants{} ; -- 
lin probability_N = mkN "probabilité" ; -- tocheck
lin virus_N = mkN "virus" masculine ; -- tocheck
lin reporterMasc_N = mkN "reporter" masculine ;
lin fool_N = mkN "imbécile" masculine | mkN "fou" masculine ; -- tocheck
lin pop_V2 = variants{} ; -- 
lin capitalism_N = mkN "capitalisme" masculine ; -- tocheck
lin painful_A = mkA "pénible" | mkA "douloureux" | mkA "laborieux" ; -- tocheck
lin correctly_Adv = variants{} ; -- 
lin complex_N = mkN "complexe" masculine ; -- tocheck
lin rumour_N = variants{} ; -- 
lin imperial_A = mkA "impérial" | mkA "royal" ; -- tocheck
lin justification_N = mkN "justification" feminine ; -- tocheck
lin availability_N = mkN "disponibilité" feminine ; -- tocheck
lin spectacular_A = mkA "spectaculaire" ; -- tocheck
lin remain_N = variants{} ; -- 
lin ocean_N = mkN "océan" masculine ; -- tocheck
lin cliff_N = mkN "falaise" feminine ; -- tocheck
lin sociology_N = mkN "sociologie" feminine ; -- tocheck
lin sadly_Adv = variants{} ; -- 
lin missile_N = mkN "projectile" masculine | mkN "missile" masculine ; -- tocheck
lin situate_V2 = variants{} ; -- 
lin artificial_A = mkA "artificiel" ; -- tocheck
lin apartment_N = L.apartment_N ;
lin provoke_V2 = mkV2 (mkV "provoquer") ; -- tocheck
lin oral_A = mkA "oral" ; -- tocheck
lin maximum_N = mkN "maximum" masculine ; -- tocheck
lin angel_N = mkN "ange" masculine ; -- tocheck
lin spare_A = mkA "rechange" ; -- tocheck
lin shame_N = mkN "honte" feminine ; -- tocheck
lin intelligent_A = mkA "intelligent" ; -- tocheck
lin discretion_N = mkN "discrétion" feminine ; -- tocheck
lin businessman_N = variants{} ; -- 
lin explicit_A = variants{} ; -- 
lin book_V2 = mkV2 (mkV "réserver") ; -- tocheck
lin uniform_N = mkN "uniforme" masculine ; -- tocheck
lin push_N = variants{} ; -- 
lin counter_N = mkN "compteur" | mkN "compteur" masculine | mkN "guichet" masculine ; -- tocheck
lin subject_A = variants{} ; -- 
lin objective_A = mkA "objectif" ; -- tocheck
lin hungry_A = variants{} ; -- 
lin clothing_N = mkN "vêtements" ; -- tocheck
lin ride_N = mkN "bagnole" feminine ; -- tocheck
lin romantic_A = mkA "romantique" ; -- tocheck
lin attendance_N = mkN "présence" feminine ; -- tocheck
lin part_time_A = variants{} ; -- 
lin trace_N = mkN "trace" feminine ; -- tocheck
lin backing_N = variants{} ; -- 
lin sensation_N = mkN "sensation" feminine ; -- tocheck
lin carrier_N = variants{} ; -- 
lin interest_V2 = mkV2 (mkV "intéresser") ; -- tocheck
lin interest_V = variants{}; -- mkV2 (mkV "intéresser") ; -- tocheck
lin classification_N = mkN "classification" feminine ; -- tocheck
lin classic_N = mkN "classique" masculine ; -- tocheck
lin beg_V2 = mkV2 (mkV "mendier") | mkV2 (mkV "implorer") ; -- tocheck
lin beg_V = variants{}; -- mkV2 (mkV "mendier") | mkV2 (mkV "implorer") ; -- tocheck
lin appendix_N = mkN "annexe" feminine | mkN "appendice" masculine ; -- tocheck
lin doorway_N = variants{} ; -- 
lin density_N = mkN "densité" feminine ; -- tocheck
lin working_class_A = variants{} ; -- 
lin legislative_A = mkA "législatif" ; -- tocheck
lin hint_N = mkN "soupçon" masculine | mkN "indication" ; -- tocheckç
lin shower_N = mkN "averse" feminine | mkN "douche" feminine ; -- tocheck
lin current_N = mkN "courant" masculine ; -- tocheck
lin succession_N = mkN "succession" feminine ; -- tocheck
lin nasty_A = variants{} ; -- 
lin duration_N = mkN "durée" feminine ; -- tocheck
lin desert_N = variants{} ; -- 
lin receipt_N = mkN "recette" feminine | mkN "réception" feminine ; -- tocheck
lin native_A = mkA "natif" | mkA "maternel" ; -- tocheck
lin chapel_N = mkN "chapelle" feminine ; -- tocheck
lin amazing_A = mkA "étonnant" ; -- tocheck
lin hopefully_Adv = variants{} ; -- 
lin fleet_N = mkN "flotte" feminine ; -- tocheck
lin comparable_A = mkA "comparable" ; -- tocheck
lin oxygen_N = mkN "oxygène" masculine ; -- tocheck
lin installation_N = mkN "installation" feminine ; -- tocheck
lin developer_N = mkN "concepteur" masculine | mkN "révélateur" masculine | mkN "développateur" masculine | mkN "promoteur" masculine | mkN "promoteur" ; -- tocheck
lin disadvantage_N = variants{} ; -- 
lin recipe_N = mkN "recette" feminine ; -- tocheck
lin crystal_N = mkN "cristal" masculine ; -- tocheck
lin modification_N = mkN "modification" feminine ; -- tocheck
lin schedule_V2V = mkV2V (mkV "planifier") | mkV2V (mkV I.prévoir_V2) ; -- tocheck
lin schedule_V2 = variants{}; -- mkV2V (mkV "planifier") | mkV2V (mkV I.prévoir_V2) ; -- tocheck
lin schedule_V = variants{}; -- mkV2V (mkV "planifier") | mkV2V (mkV I.prévoir_V2) ; -- tocheck
lin midnight_N = mkN "minuit" feminine ; -- tocheck
lin successive_A = mkA "successif" ; -- tocheck
lin formerly_Adv = variants{} ; -- 
lin loud_A = mkA "fort" | mkA "bruyant" | mkA "voyant" ; -- tocheck
lin value_V2 = variants{} ; -- 
lin value_V = variants{} ; -- 
lin physics_N = mkN "physique" feminine ; -- tocheck
lin truck_N = mkN "camion" masculine ; -- tocheck
lin stroke_N = mkN "coup" masculine | mkN "trait" masculine | mkN "brasse" feminine | mkN "caresse" feminine ; -- tocheck
lin kiss_N = mkN "baiser" masculine ; -- tocheck
lin envelope_N = mkN "enveloppe" feminine ; -- tocheck
lin speculation_N = mkN "spéculation" feminine ; -- tocheck
lin canal_N = mkN "canal" masculine ; -- tocheck
lin unionist_N = variants{} ; -- 
lin directory_N = mkN "annuaire" | mkN "dossier" masculine ; -- tocheck
lin receiver_N = mkN "récepteur" masculine | mkN "receleur" masculine | mkN "écouteur" masculine ; -- tocheck
lin isolation_N = mkN "isolation" feminine | mkN "isolement" masculine ; -- tocheck
lin fade_V2 = mkV2 (reflV (mkV "affadir")) | mkV2 (reflV (mkV "évanouir")) ; -- tocheck
lin fade_V = variants{}; -- mkV2 (reflV (mkV "affadir")) | mkV2 (reflV (mkV "évanouir")) ; -- tocheck
lin chemistry_N = mkN "chimie" feminine ; -- tocheck
lin unnecessary_A = mkA "inutile" ; -- tocheck
lin hit_N = mkN "frappe" feminine | mkN "coup" masculine | mkN "hit" masculine | mkN "taffe" feminine | mkN "contrat" masculine ; -- tocheck
lin defenderMasc_N = mkN "défenseur" masculine ;
lin stance_N = mkN "position" feminine ; -- tocheck
lin sin_N = mkN "péché" masculine ; -- tocheck
lin realistic_A = mkA "réaliste" ; -- tocheck
lin socialist_N = mkN "socialiste" ; -- tocheck
lin subsidy_N = mkN "subvention" ; -- tocheck
lin content_A = mkA "content" ; -- tocheck
lin toy_N = mkN "jouet" masculine ; -- tocheck
lin darling_N = mkN "chéri" masculine ; -- tocheck
lin decent_A = mkA "intègre" | mkA "décent" | mkA "substantiel" ; -- tocheck
lin liberty_N = mkN "liberté" feminine ; -- tocheck
lin forever_Adv = variants{} ; -- 
lin skirt_N = mkN "jupe" feminine ; -- tocheck
lin coordinate_V2 = mkV2 (mkV "coordonner") ; -- tocheck
lin coordinate_V = variants{}; -- mkV2 (mkV "coordonner") ; -- tocheck
lin tactic_N = mkN "tactique" feminine ; -- tocheck
lin influential_A = mkA "influent" ; -- tocheck
lin import_V2 = mkV2 (mkV "importer") ; -- tocheck
lin accent_N = mkN "accent" masculine ; -- tocheck
lin compound_N = mkN "composé" | mkN "complexe" masculine ; -- tocheck
lin bastard_N = mkN "bâtard" masculine | mkN "enculé" masculine ; -- tocheck
lin ingredient_N = mkN "ingrédient" masculine ; -- tocheck
lin dull_A = L.dull_A ;
lin cater_V = variants{} ; -- 
lin scholar_N = mkN "savant" masculine ; -- tocheck
lin faint_A = mkA "faible" | mkA "craintif" ; -- tocheck
lin ghost_N = mkN "fantôme" masculine ; -- tocheck
lin sculpture_N = mkN "sculpture" feminine ; -- tocheck
lin ridiculous_A = mkA "ridicule" ; -- tocheck
lin diagnosis_N = mkN "diagnostic" masculine ; -- tocheck
lin delegate_N = mkN "délégué" masculine ; -- tocheck
lin neat_A = mkA "pur" | mkA "net" ; -- tocheck
lin kit_N = mkN "lapereau" masculine | mkN "nécessaire" masculine ; -- tocheck
lin lion_N = mkN "Lion" | mkN "lion" masculine ; -- tocheck
lin dialogue_N = mkN "dialogue" masculine ; -- tocheck
lin repair_V2 = mkV2 (mkV "réparer") ; -- tocheck
lin repair_V = variants{}; -- mkV2 (mkV "réparer") ; -- tocheck
lin tray_N = mkN "plateau" masculine ; -- tocheck
lin fantasy_N = mkN "fantasme" masculine | mkN "fantaisie" feminine ; -- tocheck
lin leave_N = mkN "congé" masculine | mkN "permission" feminine ; -- tocheck
lin export_V2 = mkV2 (mkV "exporter") ; -- tocheck
lin export_V = variants{}; -- mkV2 (mkV "exporter") ; -- tocheck
lin forth_Adv = variants{} ; -- 
lin lamp_N = L.lamp_N ;
lin allege_VS = variants{} ; -- 
lin allege_V2 = variants{} ; -- 
lin pavement_N = mkN "trottoir" masculine | mkN "revêtement" masculine ; -- tocheck
lin brand_N = mkN "marque" feminine | mkN "tison" | mkN "style" masculine ; -- tocheck
lin constable_N = mkN "connétable" ; -- tocheck
lin compromise_N = variants{} ; -- 
lin flag_N = mkN "option" feminine | mkN "drapeau" masculine | mkN "pavillon" masculine ; -- tocheck
lin filter_N = mkN "filtre" masculine ; -- tocheck
lin reign_N = mkN "règne" masculine ; -- tocheck
lin execute_V2 = mkV2 (mkV "exécuter") ; -- tocheck
lin pity_N = mkN "pitié" feminine | mkN "compassion" feminine | mkN "dommage" masculine ; -- tocheck
lin merit_N = mkN "mérite" masculine ; -- tocheck
lin diagram_N = mkN "diagramme" masculine | mkN "schema" masculine ; -- tocheck
lin wool_N = mkN "laine" feminine ; -- tocheck
lin organism_N = mkN "organisme" masculine ; -- tocheck
lin elegant_A = mkA "élégant" ; -- tocheck
lin red_N = mkN "rouge" masculine ; -- tocheck
lin undertaking_N = variants{} ; -- 
lin lesser_A = variants{} ; -- 
lin reach_N = variants{} ; -- 
lin marvellous_A = variants{} ; -- 
lin improved_A = variants{} ; -- 
lin locally_Adv = variants{} ; -- 
lin entity_N = mkN "entité" ; -- tocheck
lin rape_N = mkN "viol" masculine ; -- tocheck
lin secure_A = mkA "sûr" ; -- tocheck
lin descend_V2 = mkV2 (mkV I.descendre_V2) ; -- tocheck
lin descend_V = variants{}; -- mkV2 (mkV I.descendre_V2) ; -- tocheck
lin backwards_Adv = variants{} ; -- 
lin peer_V = variants{} ; -- 
lin excuse_V2 = mkV2 (mkV "excuser") ; -- tocheck
lin genetic_A = mkA "génétique" ; -- tocheck
lin fold_V2 = mkV2 (reflV (mkV "effondrer")) | mkV2 (mkV "plier") | mkV2 (reflV (mkV "replier")) | mkV2 (reflV (mkV "coucher")) ; -- tocheck
lin fold_V = variants{}; -- mkV2 (reflV (mkV "effondrer")) | mkV2 (mkV "plier") | mkV2 (reflV (mkV "replier")) | mkV2 (reflV (mkV "coucher")) ; -- tocheck
lin portfolio_N = variants{} ; -- 
lin consensus_N = mkN "consensus" masculine ; -- tocheck
lin thesis_N = mkN "thèse" feminine ; -- tocheck
lin shop_V = variants{} ; -- 
lin nest_N = mkN "repaire" masculine | mkN "nid" masculine | mkN "refuge" masculine ; -- tocheck
lin frown_V = mkV (mkV "râler") ; -- tocheck
lin builder_N = mkN "constructeur" masculine ; -- tocheck
lin administer_V2 = variants{} ; -- 
lin administer_V = variants{} ; -- 
lin tip_V2 = variants{} ; -- 
lin tip_V = variants{} ; -- 
lin lung_N = mkN "poumon" masculine ; -- tocheck
lin delegation_N = mkN "délégation" feminine ; -- tocheck
lin outside_N = mkN "extérieur" masculine ; -- tocheck
lin heating_N = mkN "chauffage" masculine ; -- tocheck
lin like_Subj = variants{} ; -- 
lin instinct_N = mkN "instinct" masculine ; -- tocheck
lin teenager_N = mkN "adolescent" masculine ; -- tocheck
lin lonely_A = mkA "seul" | mkA "désert" ; -- tocheck
lin residence_N = mkN "résidence" feminine ; -- tocheck
lin radiation_N = mkN "radiation" feminine ; -- tocheck
lin extract_V2 = mkV2 (mkV I.extraire_V2) ; -- tocheck
lin concession_N = mkN "concession" masculine ; -- tocheck
lin autonomy_N = mkN "autonomie" feminine ; -- tocheck
lin norm_N = mkN "norme" feminine ; -- tocheck
lin musicianMasc_N = mkN "musicien" masculine ;
lin graduate_N = mkN "licencié" masculine ; -- tocheck
lin glory_N = mkN "gloire" feminine ; -- tocheck
lin bear_N = mkN "ours" masculine | mkN "baissier" masculine ; -- tocheck
lin persist_V = mkV (mkV "persister") ; -- tocheck
lin rescue_V2 = mkV2 (mkV "délivrer") ; -- tocheck
lin equip_V2 = variants{} ; -- 
lin partial_A = mkA "partial" | mkA "partiel" ; -- tocheck
lin officially_Adv = variants{} ; -- 
lin capability_N = variants{} ; -- 
lin worry_N = mkN "souci" masculine ; -- tocheck
lin liberation_N = mkN "libération" feminine ; -- tocheck
lin hunt_V2 = L.hunt_V2 ;
lin hunt_V = variants{}; -- L.hunt_V2 ;
lin daily_Adv = mkAdv "quotidiennement" ; -- tocheck
lin heel_N = mkN "croûton" masculine | mkN "talon" masculine ; -- tocheck
lin contract_V2V = mkV2V (mkV "contracter") | mkV2V (reflV (mkV "rétracter")) ; -- tocheck
lin contract_V2 = variants{}; -- mkV2V (mkV "contracter") | mkV2V (reflV (mkV "rétracter")) ; -- tocheck
lin contract_V = variants{}; -- mkV2V (mkV "contracter") | mkV2V (reflV (mkV "rétracter")) ; -- tocheck
lin update_V2 = variants{} ; -- 
lin assign_V2V = mkV2V (mkV "assigner") | mkV2V (mkV "attribuer") | mkV2V (mkV "designer") ; -- tocheck
lin assign_V2 = variants{}; -- mkV2V (mkV "assigner") | mkV2V (mkV "attribuer") | mkV2V (mkV "designer") ; -- tocheck
lin spring_V2 = mkV2 (mkV "sauter") ; -- tocheck
lin spring_V = variants{}; -- mkV2 (mkV "sauter") ; -- tocheck
lin single_N = mkN "simple" masculine | mkN "célibataire" ; -- tocheck
lin commons_N = mkN "communs" ; -- tocheck
lin weekly_A = mkA "hebdomadaire" ; -- tocheck
lin stretch_N = mkN "étirement" ; -- tocheck
lin pregnancy_N = mkN "grossesse" feminine | mkN "gestation" feminine ; -- tocheck
lin happily_Adv = variants{} ; -- 
lin spectrum_N = mkN "spectre" masculine ; -- tocheck
lin interfere_V = mkV (mkV "interférer") ; -- tocheck
lin suicide_N = mkN "suicide" masculine | mkN "suicidé" masculine ; -- tocheck
lin panic_N = mkN "panique" feminine ; -- tocheck
lin invent_V2 = mkV2 (mkV "inventer") ; -- tocheck
lin invent_V = variants{}; -- mkV2 (mkV "inventer") ; -- tocheck
lin intensive_A = mkA "intensif" ; -- tocheck
lin damp_A = mkA "humide" ; -- tocheck
lin simultaneously_Adv = variants{} ; -- 
lin giant_N = mkN "géant" masculine | mkN "géant" ; -- tocheck
lin casual_A = mkA "occasionnel" ; -- tocheck
lin sphere_N = mkN "sphère" feminine ; -- tocheck
lin precious_A = mkA "précieux" ; -- tocheck
lin sword_N = mkN "épée" feminine ; -- tocheck
lin envisage_V2 = mkV2 (mkV "envisager") ; -- tocheck
lin bean_N = mkN "haricot" masculine ; -- tocheck
lin time_V2 = mkV2 (mkV "chronométrer") ; -- tocheck
lin crazy_A = mkA "fou" ; -- tocheck
lin changing_A = variants{} ; -- 
lin primary_N = variants{} ; -- 
lin concede_VS = variants{}; -- mkV2 (mkV "concéder") | mkV2 (mkV "céder") ; -- tocheck
lin concede_V2 = mkV2 (mkV "concéder") | mkV2 (mkV "céder") ; -- tocheck
lin concede_V = variants{}; -- mkV2 (mkV "concéder") | mkV2 (mkV "céder") ; -- tocheck
lin besides_Adv = mkAdv "sinon" ; -- tocheck
lin unite_V2 = mkV2 (mkV "unir") ; -- tocheck
lin unite_V = variants{}; -- mkV2 (mkV "unir") ; -- tocheck
lin severely_Adv = variants{} ; -- 
lin separately_Adv = variants{} ; -- 
lin instruct_V2 = variants{} ; -- 
lin insert_V2 = mkV2 (mkV "insérer") ; -- tocheck
lin go_N = mkN "approbation" feminine | mkN "essai" masculine | mkN "go" masculine | mkN "tour" masculine ; -- tocheck
lin exhibit_V2 = mkV2 (mkV "exposer") ; -- tocheck
lin brave_A = mkA "courageux" ; -- tocheck
lin tutor_N = variants{} ; -- 
lin tune_N = mkN "tube" | mkN "mélodie" feminine ; -- tocheck
lin debut_N = mkN "première" ; -- tocheck
lin debut_2_N = variants{} ; -- 
lin debut_1_N = variants{} ; -- 
lin continued_A = variants{} ; -- 
lin bid_V2 = variants{} ; -- 
lin bid_V = variants{} ; -- 
lin incidence_N = variants{} ; -- 
lin downstairs_Adv = mkAdv "au-dessous" ; -- tocheck
lin cafe_N = variants{} ; -- 
lin regret_VS = variants{}; -- mkV2 (mkV "regretter") ; -- tocheck
lin regret_V2 = mkV2 (mkV "regretter") ; -- tocheck
lin killer_N = mkN "tueur" masculine | mkN "meurtrier" masculine ; -- tocheck
lin delicate_A = mkA "délicat" ; -- tocheck
lin subsidiary_N = mkN "filiale" ; -- tocheck
lin gender_N = mkN "sexe" masculine | mkN "genre" masculine ; -- tocheck
lin entertain_V2 = mkV2 (mkV "divertir") | mkV2 (mkV I.recevoir_V2) ; -- tocheck
lin cling_V = mkV (mkV "accrocher") ; -- tocheck
lin vertical_A = mkA "vertical" ; -- tocheck
lin fetch_V2 = mkV2 (mkV "ramener") | mkV2 (mkV "rapporter") ; -- tocheck
lin strip_V2 = mkV2 (mkV "enlever") | mkV2 (reflV (mkV "déshabiller")) ; -- tocheck
lin strip_V = variants{}; -- mkV2 (mkV "enlever") | mkV2 (reflV (mkV "déshabiller")) ; -- tocheck
lin plead_VS = variants{}; -- mkV2 (mkV "plaider") ; -- tocheck
lin plead_V2 = mkV2 (mkV "plaider") ; -- tocheck
lin plead_V = variants{}; -- mkV2 (mkV "plaider") ; -- tocheck
lin duck_N = mkN "canard" masculine | mkN "cane" feminine ; -- tocheck
lin breed_N = mkN "race" feminine ; -- tocheck
lin assistant_A = variants{} ; -- 
lin pint_N = mkN "chopine" | mkN "demi" ; -- tocheck
lin abolish_V2 = mkV2 (mkV "abolir") | mkV2 (mkV I.détruire_V2) ; -- tocheck
lin translation_N = mkN "traduction" feminine ;
lin princess_N = mkN "princesse" feminine ; -- tocheck
lin line_V2 = mkV2 (mkV "croiser") ; -- tocheck
lin line_V = variants{}; -- mkV2 (mkV "croiser") ; -- tocheck
lin excessive_A = mkA "excessif" ; -- tocheck
lin digital_A = mkA "numérique" ; -- tocheck
lin steep_A = mkA "escarpé" ; -- tocheck
lin jet_N = mkN "jet" masculine | mkN "gicleur" masculine | mkN "jais" | mkN "gicleur" ; -- tocheck
lin hey_Interj = mkInterj "hé" | mkInterj "coucou" ; -- tocheck
lin grave_N = mkN "tombe" feminine ; -- tocheck
lin exceptional_A = mkA "exceptionnel" ; -- tocheck
lin boost_V2 = variants{} ; -- 
lin random_A = mkA "accidentel" | mkA "pseudo-aléatoire" | mkA "aléatoire" | mkA "moyen" ; -- tocheck
lin correlation_N = mkN "corrélation" feminine ; -- tocheck
lin outline_N = mkN "contour" masculine | mkN "synopsis" | mkN "aperçu" masculine | mkN "silhouette" feminine | mkN "ébauche" feminine | mkN "esquisse" feminine | mkN "résumé" masculine ; -- tocheck
lin intervene_V2V = mkV2V (mkV I.intervenir_V) ; -- tocheck
lin intervene_V = variants{}; -- mkV2V (mkV I.intervenir_V) ; -- tocheck
lin packet_N = mkN "paquet" ; -- tocheck
lin motivation_N = mkN "motivation" feminine ; -- tocheck
lin safely_Adv = variants{} ; -- 
lin harsh_A = mkA "dur" ; -- tocheck
lin spell_N = mkN "charme" masculine ; -- tocheck
lin spread_N = variants{} ; -- 
lin draw_N = mkN "tirage" | mkN "égalité" feminine ; -- tocheck
lin concrete_A = mkA "concret" ; -- tocheck
lin complicated_A = variants{} ; -- 
lin alleged_A = variants{} ; -- 
lin redundancy_N = mkN "redondance" feminine | mkN "redondance" ; -- tocheck
lin progressive_A = variants{} ; -- 
lin intensity_N = mkN "intensité" ; -- tocheck
lin crack_N = mkN "fissure" feminine | mkN "plaisanterie" feminine | mkN "craquement" masculine | mkN "crack" masculine ; -- tocheck
lin fly_N = mkN "mouche" feminine | mkN "braguette" feminine ; -- tocheck
lin fancy_V2 = variants{} ; -- 
lin alternatively_Adv = variants{} ; -- 
lin waiting_A = variants{} ; -- 
lin scandal_N = mkN "scandale" masculine ; -- tocheck
lin resemble_V2 = mkV2 (mkV "ressembler") P.dative ;
lin parameter_N = mkN "paramètre" masculine | mkN "paramètre" ; -- tocheck
lin fierce_A = mkA "féroce" ; -- tocheck
lin tropical_A = mkA "tropical" ; -- tocheck
lin colour_V2A = variants{}; -- mkV2 "colorer" ;
lin colour_V2 = mkV2 "colorer" ;
lin colour_V = mkV "colorer" ;
lin engagement_N = mkN "fiançailles" ; -- tocheck
lin contest_N = mkN "concours" masculine ; -- tocheck
lin edit_V2 = mkV2 (mkV "modifier") ; -- tocheck
lin courage_N = mkN "courage" masculine ; -- tocheck
lin hip_N = mkN "hanche" feminine | mkN "cynorrhodon" masculine ; -- tocheck
lin delighted_A = variants{} ; -- 
lin sponsor_V2 = variants{} ; -- 
lin carer_N = variants{} ; -- 
lin crack_V2 = mkV2 (mkV "craquer") ; -- tocheck
lin substantially_Adv = variants{} ; -- 
lin occupational_A = variants{} ; -- 
lin trainer_N = mkN "basket" feminine | mkN "entraîneur" masculine ; -- tocheck
lin remainder_N = mkN "restant" masculine ; -- tocheck
lin related_A = variants{} ; -- 
lin inherit_V2 = mkV2 (mkV "hériter") ; -- tocheck
lin inherit_V = variants{}; -- mkV2 (mkV "hériter") ; -- tocheck
lin resume_V2 = mkV2 (mkV "recommencer") ; -- tocheck
lin resume_V = variants{}; -- mkV2 (mkV "recommencer") ; -- tocheck
lin assignment_N = mkN "affectation" feminine ; -- tocheck
lin conceal_V2 = mkV2 (mkV "dissimuler") ; -- tocheck
lin disclose_VS = variants{}; -- mkV2 (mkV "révéler") ; -- tocheck
lin disclose_V2 = mkV2 (mkV "révéler") ; -- tocheck
lin disclose_V = variants{}; -- mkV2 (mkV "révéler") ; -- tocheck
lin exclusively_Adv = variants{} ; -- 
lin working_N = mkN "fonctionnement" masculine ; -- tocheck
lin mild_A = mkA "doux" ; -- tocheck
lin chronic_A = mkA "chronique" ; -- tocheck
lin splendid_A = mkA "fameux" | mkA "splendide" ; -- tocheck
lin function_V = mkV (mkV "fonctionner") ; -- tocheck
lin riderMasc_N = mkN "cavalier" masculine ;
lin clay_N = mkN "argile" masculine ; -- tocheck
lin firstly_Adv = variants{} ; -- 
lin conceive_V2 = mkV2 (mkV I.concevoir_V2) ; -- tocheck
lin conceive_V = variants{}; -- mkV2 (mkV I.concevoir_V2) ; -- tocheck
lin politically_Adv = variants{} ; -- 
lin terminal_N = mkN "gare" feminine | mkN "terminal" masculine ; -- tocheck
lin accuracy_N = mkN "exactitude" ; -- tocheck
lin coup_N = variants{} ; -- 
lin ambulance_N = mkN "ambulance" feminine ; -- tocheck
lin living_N = mkN "vie" feminine ; -- tocheck
lin offenderMasc_N = mkN "offendeur" ; -- tocheck
lin similarity_N = mkN "similarité" feminine ; -- tocheck
lin orchestra_N = mkN "orchestre" masculine ; -- tocheck
lin brush_N = mkN "brossage" masculine | mkN "brosse" feminine | mkN "accrochage" masculine ; -- tocheck
lin systematic_A = mkA "systématique" ; -- tocheck
lin striker_N = mkN "gréviste" ; -- tocheck
lin guard_V2 = mkV2 (mkV "garder") ; -- tocheck
lin guard_V = variants{}; -- mkV2 (mkV "garder") ; -- tocheck
lin casualty_N = mkN "victime" ; -- tocheck
lin steadily_Adv = variants{} ; -- 
lin painter_N = variants{} ; -- 
lin opt_VV = variants{}; -- mkV2V (mkV "opter") ; -- tocheck
lin opt_V = variants{}; -- mkV2V (mkV "opter") ; -- tocheck
lin handsome_A = mkA "beau" ; -- tocheck
lin banking_N = variants{} ; -- 
lin sensitivity_N = mkN "sensibilité" ; -- tocheck
lin navy_N = variants{} ; -- 
lin fascinating_A = mkA "fascinant" ; -- tocheck
lin disappointment_N = mkN "déception" feminine ; -- tocheck
lin auditor_N = mkN "auditeur" masculine ; -- tocheck
lin hostility_N = mkN "hostilité" feminine ; -- tocheck
lin spending_N = variants{} ; -- 
lin scarcely_Adv = variants{} ; -- 
lin compulsory_A = mkA "obligatoire" ; -- tocheck
lin photographer_N = mkN "photographe" ; -- tocheck
lin ok_Interj = variants{} ; -- 
lin neighbourhood_N = mkN "voisinage" masculine ; -- tocheck
lin ideological_A = mkA "idéologique" ; -- tocheck
lin wide_Adv = variants{} ; -- 
lin pardon_N = mkN "pardon" masculine | mkN "grâce" feminine ; -- tocheck
lin double_N = mkN "double" masculine ; -- tocheck
lin criticize_V2 = variants{} ; -- 
lin criticize_V = variants{} ; -- 
lin supervision_N = mkN "supervision" feminine ; -- tocheck
lin guilt_N = mkN "culpabilité" feminine ; -- tocheck
lin deck_N = mkN "pont" masculine ; -- tocheck
lin payable_A = variants{} ; -- 
lin execution_N = mkN "exécution" feminine ; -- tocheck
lin suite_N = mkN "suite" feminine ; -- tocheck
lin elected_A = variants{} ; -- 
lin solely_Adv = variants{} ; -- 
lin moral_N = mkN "morale" feminine | mkN "moralité" feminine ; -- tocheck
lin collector_N = mkN "collecteur" masculine | mkN "collectionneur" masculine | mkN "percepteur" masculine ; -- tocheck
lin questionnaire_N = mkN "questionnaire" masculine ; -- tocheck
lin flavour_N = mkN "saveur" feminine | mkN "style" masculine | mkN "goût" ; -- tocheck
lin couple_V2 = variants{} ; -- 
lin couple_V = variants{} ; -- 
lin faculty_N = mkN "faculté" feminine ; -- tocheck
lin tour_V2 = mkV2 (mkV "tourner") ; -- tocheck
lin tour_V = variants{}; -- mkV2 (mkV "tourner") ; -- tocheck
lin basket_N = mkN "panier" masculine ; -- tocheck
lin mention_N = variants{} ; -- 
lin kick_N = variants{} ; -- 
lin horizon_N = mkN "horizon" masculine ; -- tocheck
lin drain_V2 = mkV2 (mkV "drainer") | mkV2 (mkV "déshydrater") ; -- tocheck
lin drain_V = variants{}; -- mkV2 (mkV "drainer") | mkV2 (mkV "déshydrater") ; -- tocheck
lin happiness_N = mkN "bonheur" masculine ; -- tocheck
lin fighter_N = mkN "chasseur" ; -- tocheck
lin estimated_A = variants{} ; -- 
lin copper_N = mkN "cuivré" masculine | mkN "cuivre" masculine | mkN "flic" masculine ; -- tocheck
lin legend_N = mkN "légende" feminine | mkN "légende" ; -- tocheck
lin relevance_N = mkN "pertinence" feminine ; -- tocheck
lin decorate_V2 = mkV2 (mkV "décorer") ; -- tocheck
lin continental_A = mkA "continental" ; -- tocheck
lin ship_V2 = mkV2 (mkV "poster") ; -- tocheck
lin ship_V = variants{}; -- mkV2 (mkV "poster") ; -- tocheck
lin operational_A = variants{} ; -- 
lin incur_V2 = mkV2 (mkV "impliquer") ; -- tocheck
lin parallel_A = mkA "parallèle" ; -- tocheck
lin divorce_N = mkN "divorce" masculine ; -- tocheck
lin opposed_A = variants{} ; -- 
lin equilibrium_N = mkN "équilibre" masculine ; -- tocheck
lin trader_N = mkN "commerçant" masculine ; -- tocheck
lin ton_N = mkN "tas" masculine | mkN "tonne" feminine ; -- tocheck
lin can_N = mkN "arrosoir" masculine | mkN "bidon" masculine | mkN "WC" masculine ; -- tocheck
lin juice_N = mkN "jus" masculine ; -- tocheck
lin forum_N = mkN "forum" masculine ; -- tocheck
lin spin_V2 = mkV2 (mkV "filer") | mkV2 (mkV "tournoyer") ; -- tocheck
lin spin_V = variants{}; -- mkV2 (mkV "filer") | mkV2 (mkV "tournoyer") ; -- tocheck
lin research_V2 = mkV2 (mkV "examiner") ; -- tocheck
lin research_V = variants{}; -- mkV2 (mkV "examiner") ; -- tocheck
lin hostile_A = mkA "hostile" ; -- tocheck
lin consistently_Adv = variants{} ; -- 
lin technological_A = mkA "technologique" ; -- tocheck
lin nightmare_N = mkN "cauchemar" masculine ; -- tocheck
lin medal_N = mkN "médaille" feminine ; -- tocheck
lin diamond_N = mkN "carreau" masculine | mkN "diamant" masculine ; -- tocheck
lin speed_V2 = mkV2 (mkV "foncer") ; -- tocheck
lin speed_V = variants{}; -- mkV2 (mkV "foncer") ; -- tocheck
lin peaceful_A = mkA "paisible" | mkA "placide" ; -- tocheck
lin accounting_A = variants{} ; -- 
lin scatter_V2 = mkV2 (mkV "disperser") | mkV2 (reflV (mkV "disperser")) | mkV2 (mkV "éparpiller") ; -- tocheck
lin scatter_V = variants{}; -- mkV2 (mkV "disperser") | mkV2 (reflV (mkV "disperser")) | mkV2 (mkV "éparpiller") ; -- tocheck
lin monster_N = mkN "bête" feminine | mkN "monstre" masculine ; -- tocheck
lin horrible_A = mkA "horrible" ; -- tocheck
lin nonsense_N = mkN "non-sens" masculine | mkN "bêtise" | mkN "sottise" ; -- tocheck
lin chaos_N = mkN "chaos" masculine ; -- tocheck
lin accessible_A = mkA "accessible" ; -- tocheck
lin humanity_N = mkN "humanité" feminine ; -- tocheck
lin frustration_N = mkN "frustration" | mkN "frustration" feminine ; -- tocheck
lin chin_N = mkN "menton" masculine ; -- tocheck
lin bureau_N = mkN "agence" feminine | mkN "chiffonnier" masculine | mkN "secrétaire" masculine ; -- tocheck
lin advocate_VS = variants{}; -- mkV2 (mkV "plaider") | mkV2 (mkV "préconiser") ; -- tocheck
lin advocate_V2 = mkV2 (mkV "plaider") | mkV2 (mkV "préconiser") ; -- tocheck
lin polytechnic_N = mkN "polytechnique" ; -- tocheck
lin inhabitant_N = mkN "habitant" masculine ; -- tocheck
lin evil_A = mkA "mauvais" ; -- tocheck
lin slave_N = mkN "esclave" feminine | mkN "esclave" masculine ; -- tocheck
lin reservation_N = mkN "réservation" feminine | mkN "réserve" feminine ; -- tocheck
lin slam_V2 = mkV2 (mkV "claquer") ; -- tocheck
lin slam_V = variants{}; -- mkV2 (mkV "claquer") ; -- tocheck
lin handle_N = mkN "indicateur" masculine | mkN "paris" | mkN "poignée" feminine | mkN "indicatif" masculine | mkN "outil" masculine | mkN "anse" feminine ; -- tocheck
lin provincial_A = variants{} ; -- 
lin fishing_N = mkN "pêche" feminine ; -- tocheck
lin facilitate_V2 = mkV2 (mkV "faciliter") ; -- tocheck
lin yield_N = mkN "rendement" ; -- tocheck
lin elbow_N = mkN "coude" masculine ; -- tocheck
lin bye_Interj = mkInterj "salut" ; -- tocheck
lin warm_V2 = mkV2 (mkV "chauffer") ; -- tocheck
lin warm_V = variants{}; -- mkV2 (mkV "chauffer") ; -- tocheck
lin sleeve_N = mkN "chemise" | mkN "pochette" | mkN "manche" feminine ; -- tocheck
lin exploration_N = mkN "exploration" feminine ; -- tocheck
lin creep_V = mkV (mkV "ramper") ; -- tocheck
lin adjacent_A = mkA "adjacent" ; -- tocheck
lin theft_N = mkN "vol" masculine ; -- tocheck
lin round_V2 = variants{} ; -- 
lin round_V = variants{} ; -- 
lin grace_N = mkN "grâce" feminine | mkN "bénédicité" masculine ; -- tocheck
lin predecessor_N = mkN "précédent" masculine | mkN "prédécesseur" masculine ; -- tocheck
lin supermarket_N = mkN "supermarché" masculine ; -- tocheck
lin smart_A = mkA "habile" ; -- tocheck
lin sergeant_N = mkN "sergent" ; -- tocheck
lin regulate_V2 = mkV2 (mkV "régler") ; -- tocheck
lin clash_N = mkN "fracas" | mkN "échauffourée" feminine ; -- tocheck
lin assemble_V2 = mkV2 (reflV (mkV "rassembler")) | mkV2 (mkV "assembler") ; -- tocheck
lin assemble_V = variants{}; -- mkV2 (reflV (mkV "rassembler")) | mkV2 (mkV "assembler") ; -- tocheck
lin arrow_N = mkN "flèche" feminine ; -- tocheck
lin nowadays_Adv = mkAdv "actuellement" ; -- tocheck
lin giant_A = variants{} ; -- 
lin waiting_N = variants{} ; -- 
lin tap_N = mkN "dérivation" feminine | mkN "taraud" masculine | mkN "robinet" masculine | mkN "bouchon" masculine ; -- tocheck
lin shit_N = mkN "merde" feminine ; -- tocheck
lin sandwich_N = mkN "sandwich" masculine ; -- tocheck
lin vanish_V = mkV (mkV I.disparaître_V2) ; -- tocheck
lin commerce_N = mkN "rapports" | mkN "commerce" masculine ; -- tocheck
lin pursuit_N = mkN "poursuite" feminine ; -- tocheck
lin post_war_A = variants{} ; -- 
lin will_V2 = mkV2 (mkV "léguer") | mkV2 (mkV I.vouloir_V2) ; -- tocheck
lin will_V = variants{}; -- mkV2 (mkV "léguer") | mkV2 (mkV I.vouloir_V2) ; -- tocheck
lin waste_A = variants{} ; -- 
lin collar_N = mkN "collier" masculine | mkN "col" masculine ; -- tocheck
lin socialism_N = mkN "socialisme" masculine ; -- tocheck
lin skill_V = variants{} ; -- 
lin rice_N = mkN "riz" masculine ; -- tocheck
lin exclusion_N = mkN "exclusion" ; -- tocheck
lin upwards_Adv = variants{} ; -- 
lin transmission_N = mkN "transmission" feminine ; -- tocheck
lin instantly_Adv = variants{} ; -- 
lin forthcoming_A = mkA "prochain" | mkA "prévenant" ; -- tocheck
lin appointed_A = variants{} ; -- 
lin geographical_A = variants{} ; -- 
lin fist_N = mkN "poing" masculine ; -- tocheck
lin abstract_A = mkA "abstrait" ; -- tocheck
lin embrace_V2 = mkV2 (mkV I.étreindre_V2) ; -- tocheck
lin embrace_V = variants{}; -- mkV2 (mkV I.étreindre_V2) ; -- tocheck
lin dynamic_A = mkA "dynamique" ; -- tocheck
lin drawer_N = mkN "dessinateur" masculine | mkN "tiroir" masculine ; -- tocheck
lin dismissal_N = mkN "limogeage" masculine | mkN "non-lieu" masculine ; -- tocheck
lin magic_N = mkN "magie" feminine ; -- tocheck
lin endless_A = mkA "infini" ; -- tocheck
lin definite_A = variants{} ; -- 
lin broadly_Adv = variants{} ; -- 
lin affection_N = variants{} ; -- 
lin dawn_N = mkN "aube" feminine ; -- tocheck
lin principal_N = mkN "principal" masculine ; -- tocheck
lin bloke_N = mkN "gars" masculine ; -- tocheck
lin trap_N = mkN "siphon" masculine | mkN "trappe" feminine | mkN "gueule" feminine | mkN "piège" masculine ; -- tocheck
lin communist_A = mkA "communiste" ; -- tocheck
lin competence_N = mkN "compétence" | mkN "compétence" feminine ; -- tocheck
lin complicate_V2 = mkV2 (mkV "compliquer") ; -- tocheck
lin neutral_A = mkA "neutre" ; -- tocheck
lin fortunately_Adv = variants{} ; -- 
lin commonwealth_N = mkN "communauté" ; -- tocheck
lin breakdown_N = mkN "panne" | mkN "dégradation" feminine | mkN "collapse" masculine | mkN "détail" masculine ; -- tocheck
lin combined_A = variants{} ; -- 
lin candle_N = mkN "bougie" feminine ; -- tocheck
lin venue_N = mkN "lieu" masculine ; -- tocheck
lin supper_N = mkN "souper" ; -- tocheck
lin analyst_N = mkN "analyste" masculine ; -- tocheck
lin vague_A = mkA "vague" ; -- tocheck
lin publicly_Adv = variants{} ; -- 
lin marine_A = mkA "marin" ; -- tocheck
lin fair_Adv = variants{} ; -- 
lin pause_N = mkN "pause" feminine ; -- tocheck
lin notable_A = mkA "remarquable" ; -- tocheck
lin freely_Adv = variants{} ; -- 
lin counterpart_N = mkN "homologue" ; -- tocheck
lin lively_A = mkA "animé" ; -- tocheck
lin script_N = mkN "écriture" feminine | mkN "écrit" masculine | mkN "script" masculine ; -- tocheck
lin sue_V2V = variants{} ; -- 
lin sue_V2 = variants{} ; -- 
lin sue_V = variants{} ; -- 
lin legitimate_A = variants{} ; -- 
lin geography_N = mkN "géographie" feminine ; -- tocheck
lin reproduce_V2 = mkV2 (mkV I.reproduire_V2) ; -- tocheck
lin reproduce_V = variants{}; -- mkV2 (mkV I.reproduire_V2) ; -- tocheck
lin moving_A = variants{} ; -- 
lin lamb_N = mkN "agneau" masculine ; -- tocheck
lin gay_A = mkA "gai" | mkA "gay" ; -- tocheck
lin contemplate_VS = variants{}; -- mkV2 (mkV "envisager") ; -- tocheck
lin contemplate_V2 = mkV2 (mkV "envisager") ; -- tocheck
lin contemplate_V = variants{}; -- mkV2 (mkV "envisager") ; -- tocheck
lin terror_N = mkN "terreur" feminine ; -- tocheck
lin stable_N = mkN "écurie" | mkN "étable" feminine | mkN "étable" ; -- tocheck
lin founder_N = mkN "fondateur" masculine | mkN "fondeur" masculine ; -- tocheck
lin utility_N = mkN "utilité" feminine | mkN "utilitaire" masculine ; -- tocheck
lin signal_VS = variants{}; -- mkV2 (mkV "signaler") ; -- tocheck
lin signal_V2 = mkV2 (mkV "signaler") ; -- tocheck
lin shelter_N = mkN "abri" ; -- tocheck
lin poster_N = mkN "affiche" feminine | mkN "poster" masculine ; -- tocheck
lin hitherto_Adv = mkAdv "jusqu'ici" ; -- tocheck
lin mature_A = mkA "mûr" ; -- tocheck
lin cooking_N = mkN "cuisine" feminine ;
lin head_A = mkA "principal" ;
lin wealthy_A = mkA "riche" ; -- tocheck
lin fucking_A = mkA "foutu" ;
lin confess_VS = mkVS (mkV "avouer") ;
lin confess_V2 = mkV2 (mkV "avouer") ;
lin confess_V = mkV "avouer" ;
lin age_V = variants{}; -- mkV2 (mkV "vieillir") ; -- tocheck
lin miracle_N = mkN "miracle" masculine ; -- tocheck
lin magic_A = mkA "magique" ; -- tocheck
lin jaw_N = mkN "mâchoire" feminine ; -- tocheck
lin pan_N = mkN "poêle" feminine ; -- tocheck
lin coloured_A = mkA "coloré" ;
lin tent_N = mkN "tente" feminine ; -- tocheck
lin telephone_V2 = mkV2 (mkV "téléphoner") ; -- tocheck
lin telephone_V = variants{}; -- mkV2 (mkV "téléphoner") ; -- tocheck
lin reduced_A = variants{} ; -- 
lin tumour_N = variants{} ; -- 
lin super_A = mkA "super" ; -- tocheck
lin funding_N = variants{} ; -- 
lin dump_V2 = mkV2 (mkV "larguer") ; -- tocheck
lin dump_V = variants{}; -- mkV2 (mkV "larguer") ; -- tocheck
lin stitch_N = mkN "crampe" feminine | mkN "point" masculine ; -- tocheck
lin shared_A = variants{} ; -- 
lin ladder_N = mkN "échelle" feminine ; -- tocheck
lin keeper_N = mkN "conservateur" masculine | mkN "gardien" masculine | mkN "gâche" feminine | mkN "passant" masculine ; -- tocheck
lin endorse_V2 = mkV2 (mkV I.soutenir_V2) | mkV2 (mkV "endosser") ; -- tocheck
lin invariably_Adv = variants{} ; -- 
lin smash_V2 = mkV2 (mkV "écraser") | mkV2 (mkV "percuter") | mkV2 (mkV "fracasser") ; -- tocheck
lin smash_V = variants{}; -- mkV2 (mkV "écraser") | mkV2 (mkV "percuter") | mkV2 (mkV "fracasser") ; -- tocheck
lin shield_N = mkN "bouclier" masculine | mkN "écu" masculine ; -- tocheck
lin heat_V2 = mkV2 (mkV "exciter") | mkV2 (mkV "chauffer") ; -- tocheck
lin heat_V = variants{}; -- mkV2 (mkV "exciter") | mkV2 (mkV "chauffer") ; -- tocheck
lin surgeon_N = mkN "chirurgien" ; -- tocheck
lin centre_V2 = variants{} ; -- 
lin centre_V = variants{} ; -- 
lin orange_N = variants{} ; -- 
lin orange_2_N = variants{} ; -- 
lin orange_1_N = variants{} ; -- 
lin explode_V = variants{}; -- mkV2 (mkV "détoner") ; -- tocheck
lin comedy_N = mkN "comédie" feminine ; -- tocheck
lin classify_V2 = mkV2 (mkV "classifier") ; -- tocheck
lin artistic_A = mkA "artistique" ; -- tocheck
lin ruler_N = mkN "dirigeant" feminine | mkN "règle" feminine ; -- tocheck
lin biscuit_N = mkN "biscuit" ; -- tocheck
lin workstation_N = variants{} ; -- 
lin prey_N = mkN "proie" ; -- tocheck
lin manual_N = mkN "manuel" masculine ; -- tocheck
lin cure_N = variants{} ; -- 
lin cure_2_N = variants{} ; -- 
lin cure_1_N = variants{} ; -- 
lin overall_N = mkN "blouse" feminine ; -- tocheck
lin tighten_V2 = mkV2 (mkV "serrer") | mkV2 (reflV (mkV "resserrer")) ; -- tocheck
lin tighten_V = variants{}; -- mkV2 (mkV "serrer") | mkV2 (reflV (mkV "resserrer")) ; -- tocheck
lin tax_V2 = variants{} ; -- 
lin pope_N = mkN "pope" masculine | mkN "pape" masculine ; -- tocheck
lin manufacturing_A = variants{} ; -- 
lin adult_A = mkA "adulte" ; -- tocheck
lin rush_N = mkN "hâte" feminine | mkN "jonc" masculine ; -- tocheck
lin blanket_N = mkN "couverture" feminine ; -- tocheck
lin republican_N = variants{} ; -- 
lin referendum_N = mkN "référendum" masculine ; -- tocheck
lin palm_N = mkN "paume" feminine ; -- tocheck
lin nearby_Adv = variants{} ; -- 
lin mix_N = mkN "mélange" masculine ; -- tocheck
lin devil_N = mkN "diable" masculine | mkN "type" masculine | mkN "Diable" masculine ; -- tocheck
lin adoption_N = mkN "adoption" feminine ; -- tocheck
lin workforce_N = variants{} ; -- 
lin segment_N = mkN "segment" masculine ; -- tocheck
lin regardless_Adv = variants{} ; -- 
lin contractor_N = mkN "sous-traitant" masculine | mkN "entrepreneur" masculine | mkN "entrepreneur" ; -- tocheck
lin portion_N = mkN "part" feminine ; -- tocheck
lin differently_Adv = variants{} ; -- 
lin deposit_V2 = mkV2 (mkV "déposer") ; -- tocheck
lin cook_N = mkN "chef" ; -- tocheck
lin prediction_N = mkN "prédiction" feminine ; -- tocheck
lin oven_N = mkN "four" masculine ; -- tocheck
lin matrix_N = mkN "matrice" feminine ; -- tocheck
lin liver_N = L.liver_N ;
lin fraud_N = mkN "fraude" | mkN "imposteur" masculine ; -- tocheck
lin beam_N = mkN "age" masculine | mkN "madrier" masculine | mkN "lien" masculine | mkN "limon" masculine | mkN "poutre" feminine | mkN "faisceau" masculine ; -- tocheck
lin signature_N = mkN "signature" feminine ; -- tocheck
lin limb_N = mkN "limbe" masculine | mkN "membre" masculine ; -- tocheck
lin verdict_N = variants{} ; -- 
lin dramatically_Adv = variants{} ; -- 
lin container_N = mkN "récipient" masculine | mkN "conteneur" masculine ; -- tocheck
lin aunt_N = mkN "tante" feminine ; -- tocheck
lin dock_N = mkN "socle" masculine | mkN "darse" feminine ; -- tocheck
lin submission_N = mkN "soumission" feminine ; -- tocheck
lin arm_V2 = mkV2 (mkV "armer") ; -- tocheck
lin arm_V = variants{}; -- mkV2 (mkV "armer") ; -- tocheck
lin odd_N = variants{} ; -- 
lin certainty_N = mkN "certitude" feminine ; -- tocheck
lin boring_A = mkA "ennuyeux" ; -- tocheck
lin electron_N = mkN "électron" masculine ; -- tocheck
lin drum_N = mkN "tonneau" masculine | mkN "tambour" masculine ; -- tocheck
lin wisdom_N = mkN "sagesse" feminine ; -- tocheck
lin antibody_N = mkN "anticorps" masculine ; -- tocheck
lin unlike_A = variants{} ; -- 
lin terrorist_N = mkN "terroriste" ; -- tocheck
lin post_V2 = variants{} ; -- 
lin post_V = variants{} ; -- 
lin circulation_N = mkN "circulation" feminine ; -- tocheck
lin alteration_N = variants{} ; -- 
lin fluid_N = mkN "fluide" masculine ; -- tocheck
lin ambitious_A = mkA "ambitieux" ; -- tocheck
lin socially_Adv = variants{} ; -- 
lin riot_N = mkN "émeute" feminine ; -- tocheck
lin petition_N = mkN "pétition" ; -- tocheck
lin fox_N = mkN "roublard" masculine | mkN "renard" masculine ; -- tocheck
lin recruitment_N = mkN "recrutement" ; -- tocheck
lin well_known_A = variants{} ; -- 
lin top_V2 = variants{} ; -- 
lin service_V2 = mkV2 (mkV I.maintenir_V2) | mkV2 (mkV I.servir_V2) ; -- tocheck
lin flood_V2 = mkV2 (mkV "inonder") | mkV2 (mkV "submerger") ; -- tocheck
lin flood_V = variants{}; -- mkV2 (mkV "inonder") | mkV2 (mkV "submerger") ; -- tocheck
lin taste_V2 = mkV2 (mkV "goûter") ; -- tocheck
lin taste_V = variants{}; -- mkV2 (mkV "goûter") ; -- tocheck
lin memorial_N = mkN "mémorial" masculine ; -- tocheck
lin helicopter_N = mkN "hélicoptère" masculine ; -- tocheck
lin correspondence_N = mkN "correspondance" feminine ; -- tocheck
lin beef_N = mkN "boeuf" masculine ; -- tocheck
lin overall_Adv = variants{} ; -- 
lin lighting_N = variants{} ; -- 
lin harbour_N = L.harbour_N ;
lin empirical_A = variants{} ; -- 
lin shallow_A = mkA "superficiel" ; -- tocheck
lin seal_V2 = variants{}; -- mkV2A (mkV "sceller") ; -- tocheck
lin seal_V = variants{}; -- mkV2A (mkV "sceller") ; -- tocheck
lin decrease_V2 = mkV2 (mkV "diminuer") ; -- tocheck
lin decrease_V = variants{}; -- mkV2 (mkV "diminuer") ; -- tocheck
lin constituent_N = variants{} ; -- 
lin exam_N = variants{} ; -- 
lin toe_N = mkN "orteil" masculine ; -- tocheck
lin reward_V2 = mkV2 (mkV "récompenser") ; -- tocheck
lin thrust_V2 = mkV2 (mkV "propulser") ; -- tocheck
lin thrust_V = variants{}; -- mkV2 (mkV "propulser") ; -- tocheck
lin bureaucracy_N = mkN "bureaucratie" feminine ; -- tocheck
lin wrist_N = mkN "poignet" masculine ; -- tocheck
lin nut_N = mkN "fou" masculine | mkN "couille" feminine | mkN "écrou" masculine ; -- tocheck
lin plain_N = mkN "plaine" ; -- tocheck
lin magnetic_A = mkA "magnétique" ; -- tocheck
lin evil_N = mkN "mal" masculine ; -- tocheck
lin widen_V2 = mkV2 (reflV (mkV "élargir")) | mkV2 (mkV "élargir") ; -- tocheck
lin hazard_N = mkN "hasard" masculine | mkN "hasard" | mkN "danger" masculine ; -- tocheck
lin dispose_V2 = variants{} ; -- 
lin dispose_V = variants{} ; -- 
lin dealing_N = variants{} ; -- 
lin absent_A = mkA "absent" ; -- tocheck
lin reassure_V2S = mkV2S (mkV "tranquilliser") | mkV2S (mkV "réassurer") ; -- tocheck
lin reassure_V2 = variants{}; -- mkV2S (mkV "tranquilliser") | mkV2S (mkV "réassurer") ; -- tocheck
lin model_V2 = mkV2 (mkV "modeler") | mkV2 (mkV "modéliser") ; -- tocheck
lin model_V = variants{}; -- mkV2 (mkV "modeler") | mkV2 (mkV "modéliser") ; -- tocheck
lin inn_N = mkN "auberge" feminine | mkN "taverne" feminine ; -- tocheck
lin initial_N = mkN "lettrine" feminine | mkN "initiale" feminine ; -- tocheck
lin suspension_N = variants{} ; -- 
lin respondent_N = variants{} ; -- 
lin over_N = variants{} ; -- 
lin naval_A = mkA "naval" ; -- tocheck
lin monthly_A = mkA "mensuel" ; -- tocheck
lin log_N = mkN "bûche" feminine | mkN "tronc" masculine ; -- tocheck
lin advisory_A = variants{} ; -- 
lin fitness_N = mkN "fitness" masculine ; -- tocheck
lin blank_A = mkA "blanc" ; -- tocheck
lin indirect_A = variants{} ; -- 
lin tile_N = mkN "carreau" ; -- tocheck
lin rally_N = mkN "rallye" masculine ; -- tocheck
lin economist_N = mkN "économiste" masculine ; -- tocheck
lin vein_N = mkN "veine" feminine ; -- tocheck
lin strand_N = mkN "brin" masculine | mkN "grève" feminine ; -- tocheck
lin disturbance_N = variants{} ; -- 
lin stuff_V2 = mkV2 (mkV "péter") | mkV2 (mkV "fourrer") | mkV2 (mkV I.mettre_V2) ; -- tocheck
lin seldom_Adv = mkAdv "rarement" ; -- tocheck
lin coming_A = variants{} ; -- 
lin cab_N = variants{} ; -- 
lin grandfather_N = mkN "grand-père" masculine ; -- tocheck
lin flash_V = variants{}; -- mkV2 (mkV "clignoter") | mkV2 (reflV (mkV "exhiber")) ; -- tocheck
lin destination_N = mkN "destination" feminine ; -- tocheck
lin actively_Adv = variants{} ; -- 
lin regiment_N = mkN "régiment" masculine ; -- tocheck
lin closed_A = variants{} ; -- 
lin boom_N = mkN "boum" | mkN "mat" masculine | mkN "boom" masculine | mkN "bôme" feminine ; -- tocheck
lin handful_N = mkN "manipule" | mkN "poignée" feminine ; -- tocheck
lin remarkably_Adv = variants{} ; -- 
lin encouragement_N = mkN "encouragement" masculine ; -- tocheck
lin awkward_A = mkA "embarrassant" | mkA "maladroit" | mkA "inconvenant" ; -- tocheck
lin required_A = variants{} ; -- 
lin flood_N = mkN "inondation" feminine ; -- tocheck
lin defect_N = mkN "défaut" masculine ; -- tocheck
lin surplus_N = mkN "surplus" masculine | mkN "excédentaire" masculine ; -- tocheck
lin champagne_N = mkN "champagne" masculine ; -- tocheck
lin liquid_N = mkN "liquide" masculine ; -- tocheck
lin shed_V2 = mkV2 (mkV "séparer") | mkV2 (mkV "verser") ; -- tocheck
lin welcome_N = mkN "bienvenue" feminine | mkN "bienvenue" ; -- tocheck
lin rejection_N = mkN "refus" ; -- tocheck
lin discipline_V2 = variants{} ; -- 
lin halt_V2 = mkV2 (mkV "halter") ; -- tocheck
lin halt_V = variants{}; -- mkV2 (mkV "halter") ; -- tocheck
lin electronics_N = mkN "électronique" feminine ; -- tocheck
lin administratorMasc_N = mkN "administrateur" ;
lin sentence_V2 = mkV2 (mkV "punir") ; -- tocheck
lin sentence_V = variants{}; -- mkV2 (mkV "punir") ; -- tocheck
lin ill_Adv = mkAdv "mal" ; -- tocheck
lin contradiction_N = mkN "contradiction" feminine ; -- tocheck
lin nail_N = mkN "seize" | mkN "ongle" masculine | mkN "clou" masculine ; -- tocheck
lin senior_N = mkN "supérieur" masculine ; -- tocheck
lin lacking_A = variants{} ; -- 
lin colonial_A = mkA "colonial" ; -- tocheck
lin primitive_A = mkA "primitif" ; -- tocheck
lin whoever_NP = variants{} ; -- 
lin lap_N = mkN "côté" | mkN "genoux" ; -- tocheck
lin commodity_N = mkN "produit" masculine ; -- tocheck
lin planned_A = variants{} ; -- 
lin intellectual_N = mkN "intellectuel" ; -- tocheck
lin imprisonment_N = mkN "emprisonnement" masculine ; -- tocheck
lin coincide_V = mkV (mkV "coïncider") ; -- tocheck
lin sympathetic_A = mkA "sympathique" ; -- tocheck
lin atom_N = mkN "atome" masculine ; -- tocheck
lin tempt_V2V = mkV2V (mkV "attirer") | mkV2V (mkV "tenter") ; -- tocheck
lin tempt_V2 = variants{}; -- mkV2V (mkV "attirer") | mkV2V (mkV "tenter") ; -- tocheck
lin sanction_N = mkN "sanction" ; -- tocheck
lin praise_V2 = mkV2 (mkV "louer") ; -- tocheck
lin favourable_A = mkA "favorable" ; -- tocheck
lin dissolve_V2 = mkV2 (mkV I.dissoudre_V2) | mkV2 (reflV (mkV I.dissoudre_V2)) ; -- tocheck
lin dissolve_V = variants{}; -- mkV2 (mkV I.dissoudre_V2) | mkV2 (reflV (mkV I.dissoudre_V2)) ; -- tocheck
lin tightly_Adv = variants{} ; -- 
lin surrounding_N = variants{} ; -- 
lin soup_N = mkN "potage" masculine | mkN "pétrin" masculine ; -- tocheck
lin encounter_N = mkN "rencontre" | mkN "rencontre" feminine ; -- tocheck
lin abortion_N = mkN "avortement" masculine | mkN "avorton" masculine ; -- tocheck
lin grasp_V2 = mkV2 (mkV "saisir") | mkV2 (mkV I.comprendre_V2) ; -- tocheck
lin grasp_V = variants{}; -- mkV2 (mkV "saisir") | mkV2 (mkV I.comprendre_V2) ; -- tocheck
lin custody_N = variants{} ; -- 
lin composer_N = mkN "compositeur" masculine ; -- tocheck
lin charm_N = mkN "charme" | mkN "fétiche" | mkN "breloque" feminine ; -- tocheck
lin short_term_A = variants{} ; -- 
lin metropolitan_A = mkA "métropolitain" ; -- tocheck
lin waist_N = mkN "taille" feminine ; -- tocheck
lin equality_N = mkN "égalité" feminine ; -- tocheck
lin tribute_N = mkN "hommage" masculine | mkN "tribut" masculine ; -- tocheck
lin bearing_N = mkN "roulement" masculine | mkN "azimut" masculine ; -- tocheck
lin auction_N = mkN "enchères" ; -- tocheck
lin standing_N = variants{} ; -- 
lin manufacture_N = variants{} ; -- 
lin horn_N = L.horn_N ;
lin barn_N = mkN "grange" feminine ; -- tocheck
lin mayor_N = mkN "maire" masculine | mkN "maire" ; -- tocheck
lin emperor_N = mkN "empereur" masculine ; -- tocheck
lin rescue_N = mkN "sauvetage" masculine ; -- tocheck
lin integrated_A = variants{} ; -- 
lin conscience_N = mkN "conscience" feminine ; -- tocheck
lin commence_V2 = mkV2 (mkV "commencer") ; -- tocheck
lin commence_V = variants{}; -- mkV2 (mkV "commencer") ; -- tocheck
lin grandmother_N = mkN "grand-mère" feminine ; -- tocheck
lin discharge_V2 = variants{} ; -- 
lin discharge_V = variants{} ; -- 
lin profound_A = mkA "profond" ; -- tocheck
lin takeover_N = variants{} ; -- 
lin nationalist_N = mkN "nationaliste" ; -- tocheck
lin effect_V2 = mkV2 (mkV "effectuer") ; -- tocheck
lin dolphin_N = mkN "dauphin" masculine | mkN "duc-d'Albe" masculine ; -- tocheck
lin fortnight_N = variants{} ; -- 
lin elephant_N = mkN "éléphantesque" | mkN "éléphant" masculine ; -- tocheck
lin seal_N = mkN "sceau" masculine | mkN "joint" | mkN "phoque" masculine ; -- tocheck
lin spoil_V2 = mkV2 (mkV "gâter") ; -- tocheck
lin spoil_V = variants{}; -- mkV2 (mkV "gâter") ; -- tocheck
lin plea_N = mkN "supplication" feminine ; -- tocheck
lin forwards_Adv = variants{} ; -- 
lin breeze_N = mkN "gâteau" masculine | mkN "brise" feminine ; -- tocheck
lin prevention_N = mkN "prévention" feminine ; -- tocheck
lin mineral_N = mkN "minéral" masculine ; -- tocheck
lin runner_N = mkN "coureur" ; -- tocheck
lin pin_V2 = mkV2 (mkV "clouer") | mkV2 (mkV "épingler") ; -- tocheck
lin integrity_N = variants{} ; -- 
lin thereafter_Adv = variants{} ; -- 
lin quid_N = variants{} ; -- 
lin owl_N = mkN "hibou" masculine ; -- tocheck
lin rigid_A = mkA "rigide" ; -- tocheck
lin orange_A = mkA "orange" ; -- tocheck
lin draft_V2 = mkV2 (mkV "ébaucher") ; -- tocheck
lin reportedly_Adv = mkAdv "supposément" ; -- tocheck
lin hedge_N = mkN "haie" feminine ; -- tocheck
lin formulate_V2 = mkV2 (mkV "formuler") ; -- tocheck
lin associated_A = variants{} ; -- 
lin position_V2 = variants{} ; -- 
lin thief_N = mkN "voleur" masculine ; -- tocheck
lin tomato_N = mkN "tomate" feminine ; -- tocheck
lin exhaust_V2 = mkV2 (mkV "épuiser") ; -- tocheck
lin evidently_Adv = variants{} ; -- 
lin eagle_N = mkN "aigle" masculine ; -- tocheck
lin specified_A = variants{} ; -- 
lin resulting_A = variants{} ; -- 
lin blade_N = mkN "lame" feminine ; -- tocheck
lin peculiar_A = mkA "particulier" ; -- tocheck
lin killing_N = mkN "meurtre" masculine ; -- tocheck
lin desktop_N = mkN "bureau" masculine ; -- tocheck
lin bowel_N = variants{} ; -- 
lin long_V = variants{} ; -- 
lin ugly_A = L.ugly_A ;
lin expedition_N = mkN "expédition" feminine ; -- tocheck
lin saint_N = mkN "saint" masculine ; -- tocheck
lin variable_A = mkA "variable" ; -- tocheck
lin supplement_V2 = variants{} ; -- 
lin stamp_N = mkN "cachet" ; -- tocheck
lin slide_N = mkN "toboggan" masculine | mkN "glissement" | mkN "diapo" ; -- tocheck
lin faction_N = mkN "faction" feminine ; -- tocheck
lin enthusiastic_A = mkA "enthousiaste" ; -- tocheck
lin enquire_V2 = variants{} ; -- 
lin enquire_V = variants{} ; -- 
lin brass_N = mkN "laiton" masculine | mkN "cuivres" | mkN "galonnés" | mkN "douille" feminine ; -- tocheck
lin inequality_N = mkN "inéquation" feminine | mkN "inégalité" feminine ; -- tocheck
lin eager_A = variants{} ; -- 
lin bold_A = mkA "hardi" | mkA "gras" ; -- tocheck
lin neglect_V2 = mkV2 (mkV "négliger") ; -- tocheck
lin saying_N = mkN "dicton" masculine ; -- tocheck
lin ridge_N = mkN "crête" feminine | mkN "dorsale" feminine | mkN "faîte" masculine ; -- tocheck
lin earl_N = mkN "comte" ; -- tocheck
lin yacht_N = mkN "yacht" masculine ; -- tocheck
lin suck_V2 = L.suck_V2 ;
lin suck_V = variants{}; -- L.suck_V2 ;
lin missing_A = variants{} ; -- 
lin extended_A = variants{} ; -- 
lin valuation_N = variants{} ; -- 
lin delight_V2 = mkV2 (mkV "enchanter") ; -- tocheck
lin delight_V = variants{}; -- mkV2 (mkV "enchanter") ; -- tocheck
lin beat_N = variants{} ; -- 
lin worship_N = mkN "culte" masculine ; -- tocheck
lin fossil_N = mkN "fossile" masculine ; -- tocheck
lin diminish_V2 = mkV2 (mkV I.réduire_V2) | mkV2 (mkV "rétrécir") | mkV2 (mkV "diminuer") | mkV2 (mkV "amincir") ; -- tocheck
lin diminish_V = variants{}; -- mkV2 (mkV I.réduire_V2) | mkV2 (mkV "rétrécir") | mkV2 (mkV "diminuer") | mkV2 (mkV "amincir") ; -- tocheck
lin taxpayer_N = mkN "contribuable" ; -- tocheck
lin corruption_N = mkN "corruption" feminine ; -- tocheck
lin accurately_Adv = variants{} ; -- 
lin honour_V2 = variants{} ; -- 
lin depict_V2 = mkV2 (mkV "représenter") ; -- tocheck
lin pencil_N = mkN "crayon" masculine ; -- tocheck
lin drown_V2 = mkV2 (reflV (mkV "noyer")) | mkV2 (mkV "noyer") ; -- tocheck
lin drown_V = variants{}; -- mkV2 (reflV (mkV "noyer")) | mkV2 (mkV "noyer") ; -- tocheck
lin stem_N = mkN "racine" feminine | mkN "étrave" feminine | mkN "tige" feminine ; -- tocheck
lin lump_N = mkN "morceau" masculine | mkN "lot" masculine | mkN "masse" ; -- tocheck
lin applicable_A = variants{} ; -- 
lin rate_V2 = mkV2 (mkV "coter") ; -- tocheck
lin rate_V = variants{}; -- mkV2 (mkV "coter") ; -- tocheck
lin mobility_N = mkN "mobilité" feminine ; -- tocheck
lin immense_A = mkA "immense" ; -- tocheck
lin goodness_N = mkN "bonté" | mkN "bonté" feminine ; -- tocheck
lin price_V2V = variants{} ; -- 
lin price_V2 = variants{} ; -- 
lin price_V = variants{} ; -- 
lin preliminary_A = mkA "préliminaire" ; -- tocheck
lin graph_N = mkN "graphique" masculine | mkN "graphe" masculine ; -- tocheck
lin referee_N = mkN "arbitre" masculine ; -- tocheck
lin calm_A = variants{} ; -- 
lin onwards_Adv = variants{} ; -- 
lin omit_V2 = mkV2 (mkV I.omettre_V2) ; -- tocheck
lin genuinely_Adv = mkAdv "authentiquement" ;
lin excite_V2 = mkV2 (mkV "exciter") ; -- tocheck
lin dreadful_A = mkA "affreux" ; -- tocheck
lin cave_N = mkN "caverne" feminine | mkN "éboulement" masculine | mkN "antre" masculine | mkN "cave" feminine ; -- tocheck
lin revelation_N = mkN "révélation" feminine ; -- tocheck
lin grief_N = mkN "douleur" feminine ; -- tocheck
lin erect_V2 = variants{} ; -- 
lin tuck_V2 = variants{} ; -- 
lin tuck_V = variants{} ; -- 
lin meantime_N = variants{} ; -- 
lin barrel_N = mkN "tonneau" | mkN "canon" masculine | mkN "barillet" masculine | mkN "baril" masculine ; -- tocheck
lin lawn_N = mkN "gazon" masculine | mkN "clairière" ; -- tocheck
lin hut_N = mkN "hutte" feminine ; -- tocheck
lin swing_N = mkN "revirement" masculine | mkN "balançoire" feminine | mkN "balancement" masculine | mkN "swing" masculine | mkN "Swing" masculine ; -- tocheck
lin subject_V2 = variants{} ; -- 
lin ruin_V2 = mkV2 (mkV "ruiner") | mkV2 (mkV "abîmer") | mkV2 (mkV "gâcher") ; -- tocheck
lin slice_N = mkN "tranche" feminine ; -- tocheck
lin transmit_V2 = variants{} ; -- 
lin thigh_N = mkN "cuisse" feminine ; -- tocheck
lin practically_Adv = variants{} ; -- 
lin dedicate_V2 = mkV2 (mkV "consacrer") | mkV2 (mkV "dédier") | mkV2 (reflV (mkV "consacrer")) | mkV2 (mkV "inaugurer") ; -- tocheck
lin mistake_V2 = mkV2 (reflV (mkV "tromper")) | mkV2 (mkV I.méprendre_V2) ; -- tocheck
lin mistake_V = variants{}; -- mkV2 (reflV (mkV "tromper")) | mkV2 (mkV I.méprendre_V2) ; -- tocheck
lin corresponding_A = variants{} ; -- 
lin albeit_Subj = variants{} ; -- 
lin sound_A = mkA "complet" | mkA "sain" ; -- tocheck
lin nurse_V2 = mkV2 (mkV "allaiter") | mkV2 (mkV "soigner") ; -- tocheck
lin discharge_N = mkN "débit" masculine ; -- tocheck
lin comparative_A = mkA "comparatif" ; -- tocheck
lin cluster_N = mkN "groupe" ; -- tocheck
lin propose_VV = variants{}; -- mkV2 (mkV "proposer") ; -- tocheck
lin propose_VS = variants{}; -- mkV2 (mkV "proposer") ; -- tocheck
lin propose_V2 = mkV2 (mkV "proposer") ; -- tocheck
lin propose_V = variants{}; -- mkV2 (mkV "proposer") ; -- tocheck
lin obstacle_N = mkN "obstacle" ; -- tocheck
lin motorway_N = mkN "autoroute" feminine ; -- tocheck
lin heritage_N = mkN "héritage" masculine ; -- tocheck
lin counselling_N = variants{} ; -- 
lin breeding_N = variants{} ; -- 
lin characteristic_A = mkA "caractéristique" ; -- tocheck
lin bucket_N = mkN "panier" | mkN "seau" masculine | mkN "tacot" masculine ; -- tocheck
lin migration_N = mkN "free" ; -- tocheck
lin campaign_V = variants{} ; -- 
lin ritual_N = mkN "rituel" masculine ; -- tocheck
lin originate_V2 = variants{} ; -- 
lin originate_V = variants{} ; -- 
lin hunting_N = mkN "chasse" feminine ; -- tocheck
lin crude_A = mkA "cru" | mkA "vulgaire" ; -- tocheck
lin protocol_N = mkN "protocole" masculine ; -- tocheck
lin prejudice_N = mkN "préjugé" masculine | mkN "préjudice" masculine ; -- tocheck
lin inspiration_N = mkN "inspiration" feminine ; -- tocheck
lin dioxide_N = mkN "dioxyde" masculine ; -- tocheck
lin chemical_A = mkA "chimique" ; -- tocheck
lin uncomfortable_A = mkA "inconfortable" ; -- tocheck
lin worthy_A = mkA "honorable" | mkA "digne" ; -- tocheck
lin inspect_V2 = mkV2 "inspecter" ;
lin summon_V2 = mkV2 (mkV "convoquer") ; -- tocheck
lin parallel_N = mkN "parallèle" ; -- tocheck
lin outlet_N = mkN "issue" feminine | mkN "exutoire" masculine ; -- tocheck
lin okay_A = variants{} ; -- 
lin collaboration_N = mkN "collaboration" feminine ; -- tocheck
lin booking_N = mkN "réservation" feminine | mkN "réserve" feminine ; -- tocheck
lin salad_N = mkN "salade" feminine ; -- tocheck
lin productive_A = mkA "productif" ; -- tocheck
lin charming_A = variants{} ; -- 
lin polish_A = variants{} ; -- 
lin oak_N = mkN "chêne" masculine | mkN "chêne" ; -- tocheck
lin access_V2 = mkV2 (mkV "accéder") ; -- tocheck
lin tourism_N = mkN "tourisme" masculine ; -- tocheck
lin independently_Adv = variants{} ; -- 
lin cruel_A = mkA "cruel" ; -- tocheck
lin diversity_N = mkN "diversité" feminine ; -- tocheck
lin accused_A = variants{} ; -- 
lin supplement_N = variants{} ; -- 
lin fucking_Adv = variants{} ; -- 
lin forecast_N = mkN "prévision" feminine ; -- tocheck
lin amend_V2V = mkV2V (mkV "amender") ; -- tocheck
lin amend_V2 = variants{}; -- mkV2V (mkV "amender") ; -- tocheck
lin amend_V = variants{}; -- mkV2V (mkV "amender") ; -- tocheck
lin soap_N = mkN "savon" masculine ; -- tocheck
lin ruling_N = mkN "décision" ; -- tocheck
lin interference_N = variants{} ; -- 
lin executive_A = mkA "exécutif" ; -- tocheck
lin mining_N = variants{} ; -- 
lin minimal_A = variants{} ; -- 
lin clarify_V2 = variants{} ; -- 
lin clarify_V = variants{} ; -- 
lin strain_V2 = variants{} ; -- 
lin novel_A = mkA "nouveau" ; -- tocheck
lin try_N = mkN "tentative" feminine | mkN "essai" masculine | mkN "essai" ; -- tocheck
lin coastal_A = variants{} ; -- 
lin rising_A = variants{} ; -- 
lin quota_N = variants{} ; -- 
lin minus_Prep = variants{} ; -- 
lin kilometre_N = mkN "kilomètre" masculine ; -- tocheck
lin characterize_V2 = mkV2 (mkV "caractériser") ; -- tocheck
lin suspicious_A = mkA "suspect" | mkA "soupçonneux" ; -- tocheck
lin pet_N = mkN "chouchou" masculine ; -- tocheck
lin beneficial_A = mkA "bienfaisante" ; -- tocheck
lin fling_V2 = variants{} ; -- 
lin fling_V = variants{} ; -- 
lin deprive_V2 = variants{} ; -- 
lin covenant_N = variants{} ; -- 
lin bias_N = mkN "préjugé" ; -- tocheck
lin trophy_N = mkN "trophée" feminine ; -- tocheck
lin verb_N = mkN "verbe" masculine ; -- tocheck
lin honestly_Adv = variants{} ; -- 
lin extract_N = variants{} ; -- 
lin straw_N = mkN "paille" feminine ; -- tocheck
lin stem_V2 = mkV2 (mkV "arrêter") ; -- tocheck
lin stem_V = variants{}; -- mkV2 (mkV "arrêter") ; -- tocheck
lin eyebrow_N = mkN "sourcil" masculine ; -- tocheck
lin noble_A = mkA "noble" ; -- tocheck
lin mask_N = mkN "masque" masculine | mkN "masque" ; -- tocheck
lin lecturer_N = mkN "conférencier" masculine ; -- tocheck
lin girlfriend_N = mkN "amie" | mkN "copine" ;
lin forehead_N = mkN "front" masculine ; -- tocheck
lin timetable_N = mkN "horaire" ; -- tocheck
lin symbolic_A = mkA "symbolique" ; -- tocheck
lin farming_N = variants{} ; -- 
lin lid_N = mkN "couvercle" masculine ; -- tocheck
lin librarian_N = mkN "bibliothécaire" ; -- tocheck
lin injection_N = mkN "injection" feminine ; -- tocheck
lin sexuality_N = mkN "sexualité" feminine | mkN "sexe" masculine ; -- tocheck
lin irrelevant_A = mkA "non-pertinent" ; -- tocheck
lin bonus_N = mkN "boni" masculine ; -- tocheck
lin abuse_V2 = mkV2 (mkV "abuser") ; -- tocheck
lin thumb_N = mkN "pouce" masculine ; -- tocheck
lin survey_V2 = mkV2 (mkV "inspecter") ; -- tocheck
lin ankle_N = mkN "cheville" feminine ; -- tocheck
lin psychologist_N = mkN "psychologue" ; -- tocheck
lin occurrence_N = mkN "occurrence" feminine ; -- tocheck
lin profitable_A = mkA "profitable" ; -- tocheck
lin deliberate_A = mkA "concerté" | mkA "délibéré" ; -- tocheck
lin bow_V2 = mkV2 (reflV (mkV "incliner")) | mkV2 (mkV "fléchir") | mkV2 (mkV "courber") ; -- tocheck
lin bow_V = variants{}; -- mkV2 (reflV (mkV "incliner")) | mkV2 (mkV "fléchir") | mkV2 (mkV "courber") ; -- tocheck
lin tribe_N = mkN "tribu" feminine ; -- tocheck
lin rightly_Adv = variants{} ; -- 
lin representative_A = variants{} ; -- 
lin code_V2 = variants{} ; -- 
lin validity_N = mkN "validité" ; -- tocheck
lin marble_N = mkN "marbre" masculine | mkN "bille" feminine ; -- tocheck
lin bow_N = mkN "étrave" | mkN "arc" masculine | mkN "révérence" feminine | mkN "archet" masculine ; -- tocheck
lin plunge_V2 = mkV2 (mkV "plonger") ; -- tocheck
lin plunge_V = variants{}; -- mkV2 (mkV "plonger") ; -- tocheck
lin maturity_N = variants{} ; -- 
lin maturity_3_N = variants{} ; -- 
lin maturity_2_N = variants{} ; -- 
lin maturity_1_N = variants{} ; -- 
lin hidden_A = variants{} ; -- 
lin contrast_V2 = mkV2 (mkV "contraster") ; -- tocheck
lin contrast_V = variants{}; -- mkV2 (mkV "contraster") ; -- tocheck
lin tobacco_N = mkN "tabac" masculine ; -- tocheck
lin middle_class_A = variants{} ; -- 
lin grip_V2 = mkV2 (mkV "saisir") ; -- tocheck
lin clergy_N = mkN "clergé" masculine ; -- tocheck
lin trading_A = variants{} ; -- 
lin passive_A = mkA "passive" ; -- tocheck
lin decoration_N = mkN "décoration" feminine ; -- tocheck
lin racial_A = mkA "racial" ; -- tocheck
lin well_N = mkN "puits" masculine | mkN "source" ; -- tocheck
lin embarrassment_N = mkN "embarras" masculine ; -- tocheck
lin sauce_N = mkN "sauce" feminine ; -- tocheck
lin fatal_A = mkA "fatal" ; -- tocheck
lin banker_N = mkN "banquier" masculine ; -- tocheck
lin compensate_V2 = mkV2 (mkV "compinscate") ; -- tocheck
lin compensate_V = variants{}; -- mkV2 (mkV "compinscate") ; -- tocheck
lin make_up_N = variants{} ; -- 
lin popularity_N = mkN "popularité" feminine ; -- tocheck
lin interior_A = mkA "intérieur" ; -- tocheck
lin eligible_A = variants{} ; -- 
lin continuity_N = mkN "continuité" feminine ; -- tocheck
lin bunch_N = mkN "groupe" masculine | mkN "javelle" feminine | mkN "bande" feminine | mkN "poupée" feminine | mkN "poche" feminine | mkN "réserve" feminine ; -- tocheck
lin hook_N = mkN "hameçon" masculine | mkN "crochet" masculine ; -- tocheck
lin wicket_N = variants{} ; -- 
lin pronounce_V2 = mkV2 (mkV "déclarer") | mkV2 (mkV "déclamer") | mkV2 (mkV "prononcer") ; -- tocheck
lin pronounce_V = variants{}; -- mkV2 (mkV "déclarer") | mkV2 (mkV "déclamer") | mkV2 (mkV "prononcer") ; -- tocheck
lin ballet_N = mkN "ballet" masculine ; -- tocheck
lin heir_N = mkN "héritier" masculine ; -- tocheck
lin positively_Adv = variants{} ; -- 
lin insufficient_A = mkA "insuffisant" ; -- tocheck
lin substitute_V2 = variants{} ; -- 
lin substitute_V = variants{} ; -- 
lin mysterious_A = mkA "mystérieux" ; -- tocheck
lin dancer_N = mkN "danseur" masculine ; -- tocheck
lin trail_N = mkN "piste" feminine ; -- tocheck
lin caution_N = mkN "admonition" ; -- tocheck
lin donation_N = mkN "donation" feminine ; -- tocheck
lin added_A = variants{} ; -- 
lin weaken_V2 = mkV2 (reflV (mkV "affaiblir")) | mkV2 (mkV "affaiblir") ; -- tocheck
lin weaken_V = variants{}; -- mkV2 (reflV (mkV "affaiblir")) | mkV2 (mkV "affaiblir") ; -- tocheck
lin tyre_N = mkN "pneu" masculine ; -- tocheck
lin sufferer_N = variants{} ; -- 
lin managerial_A = mkA "managérial" ; -- tocheck
lin elaborate_A = variants{} ; -- 
lin restraint_N = mkN "frein" masculine ; -- tocheck
lin renew_V2 = mkV2 (mkV "renouveler") ; -- tocheck
lin gardenerMasc_N = mkN "jardinier" masculine ;
lin dilemma_N = mkN "dilemme" masculine ; -- tocheck
lin configuration_N = mkN "configuration" ; -- tocheck
lin rear_A = variants{} ; -- 
lin embark_V2 = variants{} ; -- 
lin embark_V = variants{} ; -- 
lin misery_N = mkN "misère" ; -- tocheck
lin importantly_Adv = variants{} ; -- 
lin continually_Adv = variants{} ; -- 
lin appreciation_N = variants{} ; -- 
lin radical_N = mkN "racine" feminine | mkN "radical" masculine | mkN "clé" masculine ; -- tocheck
lin diverse_A = mkA "divers" ; -- tocheck
lin revive_V2 = variants{} ; -- 
lin revive_V = variants{} ; -- 
lin trip_V = variants{}; -- mkV2 (mkV "trébucher") | mkV2 (mkV "triper") ; -- tocheck
lin lounge_N = mkN "salon" masculine ; -- tocheck
lin dwelling_N = mkN "domicile" masculine ; -- tocheck
lin parental_A = mkA "parental" ; -- tocheck
lin loyal_A = mkA "loyal" ; -- tocheck
lin privatisation_N = variants{} ; -- 
lin outsider_N = mkN "outsider" | mkN "exclu" masculine ; -- tocheck
lin forbid_V2 = mkV2 (mkV I.interdire_V2) ; -- tocheck
lin yep_Interj = variants{} ; -- 
lin prospective_A = mkA "prospectif" ; -- tocheck
lin manuscript_N = mkN "manuscrit" masculine ; -- tocheck
lin inherent_A = mkA "intrinsèque" ; -- tocheck
lin deem_V2V = variants{} ; -- 
lin deem_V2A = variants{} ; -- 
lin deem_V2 = variants{} ; -- 
lin telecommunication_N = variants{} ; -- 
lin intermediate_A = mkA "intermédiaire" ; -- tocheck
lin worthwhile_A = variants{} ; -- 
lin calendar_N = mkN "agenda" masculine | mkN "calendrier" | mkN "calendrier" masculine ; -- tocheck
lin basin_N = mkN "bassin" masculine | mkN "cuvette" feminine ; -- tocheck
lin utterly_Adv = variants{} ; -- 
lin rebuild_V2 = mkV2 (mkV I.reconstruire_V2) ; -- tocheck
lin pulse_N = mkN "pouls" masculine ; -- tocheck
lin suppress_V2 = mkV2 (mkV I.contenir_V2) ; -- tocheck
lin predator_N = mkN "prédateur" masculine ; -- tocheck
lin width_N = mkN "largeur" feminine ; -- tocheck
lin stiff_A = mkA "raide" | mkA "rigide" ; -- tocheck
lin spine_N = mkN "dos" masculine | mkN "épine" feminine ; -- tocheck
lin betray_V2 = mkV2 (mkV "trahir") ; -- tocheck
lin punish_V2 = mkV2 (mkV "punir") ; -- tocheck
lin stall_N = mkN "parterre" masculine | mkN "étal" masculine | mkN "décrochage" masculine | mkN "stalle" feminine ; -- tocheck
lin lifestyle_N = variants{} ; -- 
lin compile_V2 = mkV2 (mkV "compiler") ; -- tocheck
lin arouse_V2V = mkV2V (mkV "émoustiller") ; -- tocheck
lin arouse_V2 = variants{}; -- mkV2V (mkV "émoustiller") ; -- tocheck
lin partially_Adv = variants{} ; -- 
lin headline_N = mkN "titre" masculine ; -- tocheck
lin divine_A = mkA "divin" ; -- tocheck
lin unpleasant_A = mkA "déplaisant" ; -- tocheck
lin sacred_A = mkA "sacré" ; -- tocheck
lin useless_A = mkA "inutile" ; -- tocheck
lin cool_V2 = variants{} ; -- 
lin cool_V = variants{} ; -- 
lin tremble_V = mkV (mkV "trembler") ; -- tocheck
lin statue_N = mkN "statue" feminine ; -- tocheck
lin obey_V2 = mkV2 (mkV "obéir") ; -- tocheck
lin obey_V = variants{}; -- mkV2 (mkV "obéir") ; -- tocheck
lin drunk_A = mkA "ivre" ; -- tocheck
lin tender_A = mkA "tendre" ; -- tocheck
lin molecular_A = mkA "moléculaire" ; -- tocheck
lin circulate_V2 = mkV2 (mkV "circuler") ; -- tocheck
lin circulate_V = variants{}; -- mkV2 (mkV "circuler") ; -- tocheck
lin exploitation_N = mkN "exploitation" feminine ; -- tocheck
lin explicitly_Adv = variants{} ; -- 
lin utterance_N = mkN "énoncé" masculine ; -- tocheck
lin linear_A = mkA "linéaire" ; -- tocheck
lin chat_V = variants{}; -- mkV2 (mkV "discuter") | mkV2 (mkV "jaser") ; -- tocheck
lin revision_N = mkN "révision" feminine | mkN "modification" ; -- tocheck
lin distress_N = mkN "détresse" ; -- tocheck
lin spill_V2 = mkV2 (mkV "déverser") ; -- tocheck
lin spill_V = variants{}; -- mkV2 (mkV "déverser") ; -- tocheck
lin steward_N = mkN "intendant" masculine ; -- tocheck
lin knight_N = mkN "cavalier" masculine | mkN "chevalier" masculine ; -- tocheck
lin sum_V2 = mkV2 (mkV "additionner") ; -- tocheck
lin sum_V = variants{}; -- mkV2 (mkV "additionner") ; -- tocheck
lin semantic_A = mkA "sémantique" ; -- tocheck
lin selective_A = mkA "sélectif" ; -- tocheck
lin learner_N = variants{} ; -- 
lin dignity_N = mkN "dignité" feminine ; -- tocheck
lin senate_N = mkN "sénat" masculine ; -- tocheck
lin grid_N = mkN "grille" feminine | mkN "réseau" masculine ; -- tocheck
lin fiscal_A = variants{} ; -- 
lin activate_V2 = mkV2 (mkV "actionner") ; -- tocheck
lin rival_A = variants{} ; -- 
lin fortunate_A = variants{} ; -- 
lin jeans_N = variants{} ; -- 
lin select_A = variants{} ; -- 
lin fitting_N = mkN "essayage" masculine ; -- tocheck
lin commentator_N = mkN "commentateur" masculine ; -- tocheck
lin weep_V2 = mkV2 (mkV "pleurer") ; -- tocheck
lin weep_V = variants{}; -- mkV2 (mkV "pleurer") ; -- tocheck
lin handicap_N = mkN "handicap" masculine ; -- tocheck
lin crush_V2 = mkV2 (reflV (mkV "écraser")) | mkV2 (mkV "écraser") | mkV2 (mkV "concasser") ; -- tocheck
lin crush_V = variants{}; -- mkV2 (reflV (mkV "écraser")) | mkV2 (mkV "écraser") | mkV2 (mkV "concasser") ; -- tocheck
lin towel_N = mkN "serviette" feminine ; -- tocheck
lin stay_N = mkN "séjour" masculine ; -- tocheck
lin skilled_A = variants{} ; -- 
lin repeatedly_Adv = variants{} ; -- 
lin defensive_A = mkA "défensif" ; -- tocheck
lin calm_V2 = variants{} ; -- 
lin calm_V = variants{} ; -- 
lin temporarily_Adv = variants{} ; -- 
lin rain_V2 = mkV2 (mkV I.pleuvoir_V) ; -- tocheck
lin rain_V = variants{}; -- mkV2 (mkV I.pleuvoir_V) ; -- tocheck
lin pin_N = mkN "clouage" masculine | mkN "épingle" feminine | mkN "quille" feminine | mkN "pin's" masculine ; -- tocheck
lin villa_N = mkN "villa" feminine ; -- tocheck
lin rod_N = mkN "verge" | mkN "tige" feminine | mkN "bite" ; -- tocheck
lin frontier_N = mkN "frontière" feminine ; -- tocheck
lin enforcement_N = variants{} ; -- 
lin protective_A = mkA "protecteur" ; -- tocheck
lin philosophical_A = variants{} ; -- 
lin lordship_N = mkN "Monsieur" masculine | mkN "domaine" feminine ; -- tocheck
lin disagree_VS = variants{} ; -- 
lin disagree_V2 = variants{} ; -- 
lin disagree_V = variants{} ; -- 
lin boyfriend_N = mkN "chum" | mkN "ami" masculine ; -- tocheck
lin activistMasc_N = mkN "activiste" masculine ;
lin viewer_N = mkN "visionneur" masculine | mkN "spectateur" masculine | mkN "téléspectateur" masculine ; -- tocheck
lin slim_A = mkA "mince" ; -- tocheck
lin textile_N = mkN "textile" ; -- tocheck
lin mist_N = mkN "buée" feminine | mkN "brouillard" masculine ; -- tocheck
lin harmony_N = mkN "harmonie" feminine ; -- tocheck
lin deed_N = variants{} ; -- 
lin merge_V2 = mkV2 (mkV "fusionner") | mkV2 (mkV "amalgamer") ; -- tocheck
lin merge_V = variants{}; -- mkV2 (mkV "fusionner") | mkV2 (mkV "amalgamer") ; -- tocheck
lin invention_N = mkN "invention" feminine ; -- tocheck
lin commissioner_N = variants{} ; -- 
lin caravan_N = mkN "caravane" feminine ; -- tocheck
lin bolt_N = mkN "boulon" masculine | mkN "carreau" masculine | mkN "verrou" masculine ; -- tocheck
lin ending_N = mkN "terminaison" feminine | mkN "fin" feminine ; -- tocheck
lin publishing_N = variants{} ; -- 
lin gut_N = mkN "panse" | mkN "boyaux" | mkN "intestin" ; -- tocheck
lin stamp_V2 = mkV2 (mkV "timbrer") | mkV2 (mkV "tamponner") | mkV2 (mkV "estamper") ; -- tocheck
lin stamp_V = variants{}; -- mkV2 (mkV "timbrer") | mkV2 (mkV "tamponner") | mkV2 (mkV "estamper") ; -- tocheck
lin map_V2 = variants{} ; -- 
lin loud_Adv = variants{} ; -- 
lin stroke_V2 = mkV2 (mkV "caresser") ; -- tocheck
lin shock_V2 = mkV2 (mkV "choquer") ; -- tocheck
lin rug_N = mkN "tapis" ; -- tocheck
lin picture_V2 = variants{} ; -- 
lin slip_N = mkN "glissade" feminine | mkN "fiche" feminine ; -- tocheck
lin praise_N = mkN "louange" feminine ; -- tocheck
lin fine_N = mkN "amende" feminine ; -- tocheck
lin monument_N = mkN "monument" masculine ; -- tocheck
lin material_A = mkA "matériel" ; -- tocheck
lin garment_N = mkN "vêtement" masculine ; -- tocheck
lin toward_Prep = mkPrep "envers" ; ---- sense
lin realm_N = mkN "domaine" masculine | mkN "royaume" masculine ; -- tocheck
lin melt_V2 = variants{} ; -- 
lin melt_V = variants{} ; -- 
lin reproduction_N = mkN "reproduction" feminine ; -- tocheck
lin reactor_N = mkN "réactif" masculine | mkN "réacteur" ; -- tocheck
lin furious_A = mkA "furieux" ; -- tocheck
lin distinguished_A = variants{} ; -- 
lin characterize_V2 = mkV2 (mkV "caractériser") ; -- tocheck
lin alike_Adv = variants{} ; -- 
lin pump_N = mkN "pompe" feminine ; -- tocheck
lin probe_N = mkN "perche" feminine | mkN "sonde" feminine ; -- tocheck
lin feedback_N = mkN "évaluation" feminine | mkN "rétroaction" ; -- tocheck
lin aspiration_N = mkN "aspiration" ; -- tocheck
lin suspect_N = variants{} ; -- 
lin solar_A = mkA "solaire" ; -- tocheck
lin fare_N = mkN "tarif" masculine | mkN "passager" masculine | mkN "prix" masculine ; -- tocheck
lin carve_V2 = variants{} ; -- 
lin carve_V = variants{} ; -- 
lin qualified_A = variants{} ; -- 
lin membrane_N = mkN "membrane" feminine ; -- tocheck
lin dependence_N = mkN "dépendance" ; -- tocheck
lin convict_V2 = variants{} ; -- 
lin bacteria_N = mkN "bactéries" ; -- tocheck
lin trading_N = variants{} ; -- 
lin ambassador_N = mkN "ambassadeur" masculine ; -- tocheck
lin wound_V2 = mkV2 (mkV "blesser") ; -- tocheck
lin drug_V2 = mkV2 (mkV "droguer") ; -- tocheck
lin conjunction_N = mkN "conjonction" feminine ; -- tocheck
lin cabin_N = mkN "cabine" feminine | mkN "cabane" feminine ; -- tocheck
lin trail_V2 = mkV2 (mkV "traîner") | mkV2 (mkV "pister") ; -- tocheck
lin trail_V = variants{}; -- mkV2 (mkV "traîner") | mkV2 (mkV "pister") ; -- tocheck
lin shaft_N = mkN "hampe" feminine ; -- tocheck
lin treasure_N = mkN "trésor" masculine ; -- tocheck
lin inappropriate_A = mkA "inapproprié" ; -- tocheck
lin half_Adv = variants{} ; -- 
lin attribute_N = mkN "attribut" masculine | mkN "épithète" ; -- tocheck
lin liquid_A = mkA "liquide" ; -- tocheck
lin embassy_N = mkN "ambassade" feminine ; -- tocheck
lin terribly_Adv = variants{} ; -- 
lin exemption_N = mkN "exemption" feminine ; -- tocheck
lin array_N = mkN "tableau" masculine ; -- tocheck
lin tablet_N = variants{} ; -- 
lin sack_V2 = mkV2 (mkV "coucher") | mkV2 (mkV "virer") | mkV2 (mkV "saccager") ; -- tocheck
lin erosion_N = mkN "érosion" feminine ; -- tocheck
lin bull_N = mkN "mâle" masculine | mkN "taureau" masculine | mkN "bulle" feminine | mkN "bêtises" | mkN "sceau" masculine | mkN "vaches" ; -- tocheck
lin warehouse_N = mkN "entrepôt" masculine ; -- tocheck
lin unfortunate_A = mkA "malencontreux" | mkA "infortuné" ; -- tocheck
lin promoter_N = mkN "promoteur" ; -- tocheck
lin compel_VV = variants{}; -- mkV2V (mkV I.contraindre_V2) | mkV2V (mkV "obliger") ; -- tocheck
lin compel_V2V = mkV2V (mkV I.contraindre_V2) | mkV2V (mkV "obliger") ; -- tocheck
lin compel_V2 = variants{}; -- mkV2V (mkV I.contraindre_V2) | mkV2V (mkV "obliger") ; -- tocheck
lin motivate_V2V = mkV2V (mkV "motiver") ; -- tocheck
lin motivate_V2 = variants{}; -- mkV2V (mkV "motiver") ; -- tocheck
lin burning_A = variants{} ; -- 
lin vitamin_N = mkN "vitamine" feminine ; -- tocheck
lin sail_N = mkN "massif" masculine | mkN "voile" feminine | mkN "aile" feminine ; -- tocheck
lin lemon_N = mkN "chiotte" feminine | mkN "citron" masculine | mkN "citronnier" masculine ; -- tocheck
lin foreigner_N = mkN "étranger" masculine ; -- tocheck
lin powder_N = mkN "poudre" masculine | mkN "poudreuse" feminine ; -- tocheck
lin persistent_A = mkA "persistant" ; -- tocheck
lin bat_N = mkN "chauve-souris" feminine | mkN "batte" feminine ; -- tocheck
lin ancestor_N = mkN "ancêtre" ; -- tocheck
lin predominantly_Adv = variants{} ; -- 
lin mathematical_A = mkA "mathématique" ; -- tocheck
lin compliance_N = mkN "conformité" feminine | mkN "observance" feminine ; -- tocheck
lin arch_N = mkN "arche" feminine | mkN "arc" masculine ; -- tocheck
lin woodland_N = mkN "bois" masculine ; -- tocheck
lin serum_N = mkN "sérum" masculine ; -- tocheck
lin overnight_Adv = variants{} ; -- 
lin doubtful_A = mkA "douteux" ; -- tocheck
lin doing_N = variants{} ; -- 
lin coach_V2 = mkV2 (mkV "entraîner") ; -- tocheck
lin coach_V = variants{}; -- mkV2 (mkV "entraîner") ; -- tocheck
lin binding_A = variants{} ; -- 
lin surrounding_A = variants{} ; -- 
lin peer_N = mkN "pair" masculine ; -- tocheck
lin ozone_N = mkN "ozone" masculine ; -- tocheck
lin mid_A = mkA "mi-" ; -- tocheck
lin invisible_A = mkA "invisible" ; -- tocheck
lin depart_V = mkV (mkV I.partir_V) | mkV (mkV "dévier") | mkV (mkV I.mourir_V) | mkV (mkV "quitter") ; -- tocheck
lin brigade_N = variants{} ; -- 
lin manipulate_V2 = mkV2 (mkV "manipuler") ; -- tocheck
lin consume_V2 = mkV2 (mkV "consommer") | mkV2 (mkV "consumer") ; -- tocheck
lin consume_V = variants{}; -- mkV2 (mkV "consommer") | mkV2 (mkV "consumer") ; -- tocheck
lin temptation_N = mkN "tentation" feminine ; -- tocheck
lin intact_A = variants{} ; -- 
lin glove_N = L.glove_N ;
lin aggression_N = mkN "aggression" feminine ; -- tocheck
lin emergence_N = mkN "émergence" feminine ; -- tocheck
lin stag_V = variants{} ; -- 
lin coffin_N = mkN "cercueil" masculine ; -- tocheck
lin beautifully_Adv = variants{} ; -- 
lin clutch_V2 = mkV2 (mkV "agripper") ; -- tocheck
lin clutch_V = variants{}; -- mkV2 (mkV "agripper") ; -- tocheck
lin wit_N = variants{} ; -- 
lin underline_V2 = mkV2 (mkV "souligner") ; -- tocheck
lin trainee_N = mkN "stagiaire" ; -- tocheck
lin scrutiny_N = variants{} ; -- 
lin neatly_Adv = variants{} ; -- 
lin follower_N = mkN "poursuivant" masculine ; -- tocheck
lin sterling_A = variants{} ; -- 
lin tariff_N = variants{} ; -- 
lin bee_N = mkN "abeille" feminine ; -- tocheck
lin relaxation_N = mkN "relaxation" | mkN "relaxation" feminine ; -- tocheck
lin negligence_N = variants{} ; -- 
lin sunlight_N = variants{} ; -- 
lin penetrate_V2 = mkV2 (mkV "pénétrer") ; -- tocheck
lin penetrate_V = variants{}; -- mkV2 (mkV "pénétrer") ; -- tocheck
lin knot_N = mkN "noeud" masculine ; -- tocheck
lin temper_N = mkN "trempe" feminine | mkN "humeur" feminine | mkN "caractère" masculine ; -- tocheck
lin skull_N = mkN "crâne" masculine ; -- tocheck
lin openly_Adv = variants{} ; -- 
lin grind_V2 = mkV2 (mkV I.moudre_V2) ; -- tocheck
lin grind_V = variants{}; -- mkV2 (mkV I.moudre_V2) ; -- tocheck
lin whale_N = mkN "baleine" feminine ; -- tocheck
lin throne_N = mkN "trône" masculine ; -- tocheck
lin supervise_V2 = mkV2 (mkV "superviser") ; -- tocheck
lin supervise_V = variants{}; -- mkV2 (mkV "superviser") ; -- tocheck
lin sickness_N = mkN "maladie" feminine ; -- tocheck
lin package_V2 = mkV2 (mkV "empaqueter") ; -- tocheck
lin intake_N = variants{} ; -- 
lin within_Adv = variants{}; -- mkPrep "dans" ;
lin inland_A = variants{} ; -- 
lin beast_N = mkN "bête" feminine ; -- tocheck
lin rear_N = mkN "arrière" | mkN "arrière-garde" feminine | mkN "derrière" masculine ; -- tocheck
lin morality_N = mkN "moralité" feminine | mkN "moralité" ; -- tocheck
lin competent_A = variants{} ; -- 
lin sink_N = mkN "évier" masculine ; -- tocheck
lin uniform_A = mkA "uniforme" ; -- tocheck
lin reminder_N = mkN "rappel" masculine ; -- tocheck
lin permanently_Adv = variants{} ; -- 
lin optimistic_A = mkA "optimiste" ; -- tocheck
lin bargain_N = mkN "accord" masculine ; -- tocheck
lin seemingly_Adv = variants{} ; -- 
lin respective_A = mkA "respectif" ; -- tocheck
lin horizontal_A = mkA "horizontal" ; -- tocheck
lin decisive_A = mkA "décisif" | mkA "ferme" ; -- tocheck
lin bless_V2 = mkV2 (mkV "bénir") ; -- tocheck
lin bile_N = mkN "bile" feminine ; -- tocheck
lin spatial_A = mkA "spatial" ; -- tocheck
lin bullet_N = mkN "balle" feminine | mkN "puce" masculine ; -- tocheck
lin respectable_A = mkA "respectable" ; -- tocheck
lin overseas_Adv = mkAdv "outre-mer" ; -- tocheck
lin convincing_A = mkA "convaincant" ; -- tocheck
lin unacceptable_A = mkA "inacceptable" ; -- tocheck
lin confrontation_N = mkN "confrontation" feminine ; -- tocheck
lin swiftly_Adv = variants{} ; -- 
lin paid_A = variants{} ; -- 
lin joke_V = mkV (mkV "plaisanter") ; -- tocheck
lin instant_A = mkA "instantané" ; -- tocheck
lin illusion_N = mkN "illusion" feminine ; -- tocheck
lin cheer_V2 = mkV2 (mkV "applaudir") ; -- tocheck
lin cheer_V = variants{}; -- mkV2 (mkV "applaudir") ; -- tocheck
lin congregation_N = mkN "assemblée" feminine | mkN "congrégation" ; -- tocheck
lin worldwide_Adv = variants{} ; -- 
lin winning_A = variants{} ; -- 
lin wake_N = mkN "sillage" masculine ; -- tocheck
lin toss_V2 = mkV2 (mkV "mélanger") ; -- tocheck
lin toss_V = variants{}; -- mkV2 (mkV "mélanger") ; -- tocheck
lin medium_A = variants{} ; -- 
lin jewellery_N = mkN "joaillerie" feminine ; -- tocheck
lin fond_A = variants{} ; -- 
lin alarm_V2 = mkV2 (mkV "alarmer") ; -- tocheck
lin guerrilla_N = mkN "guérilla" feminine | mkN "guérillero" masculine ; -- tocheck
lin dive_V = mkV (mkV "nager") | mkV (mkV "chiquer") | mkV (mkV "plonger") ; -- tocheck
lin desire_V2 = mkV2 (mkV "désirer") ; -- tocheck
lin cooperation_N = mkN "coopération" feminine ; -- tocheck
lin thread_N = mkN "fil" masculine ; -- tocheck
lin prescribe_V2 = mkV2 (mkV I.prescrire_V2) | mkV2 (mkV "ordonner") ; -- tocheck
lin prescribe_V = variants{}; -- mkV2 (mkV I.prescrire_V2) | mkV2 (mkV "ordonner") ; -- tocheck
lin calcium_N = mkN "calcium" masculine ; -- tocheck
lin redundant_A = mkA "redondant" ; -- tocheck
lin marker_N = mkN "marqueur" masculine ; -- tocheck
lin chemistMasc_N = mkN "chimiste" masculine ;
lin mammal_N = mkN "mammifère" masculine ; -- tocheck
lin legacy_N = mkN "héritage" masculine ; -- tocheck
lin debtor_N = mkN "débiteur" masculine ; -- tocheck
lin testament_N = mkN "testament" masculine ; -- tocheck
lin tragic_A = mkA "tragique" ; -- tocheck
lin silver_A = mkA "argenté" ; -- tocheck
lin grin_N = variants{} ; -- 
lin spectacle_N = mkN "spectacle" masculine ; -- tocheck
lin inheritance_N = variants{} ; -- 
lin heal_V2 = mkV2 (mkV "guérir") ; -- tocheck
lin heal_V = variants{}; -- mkV2 (mkV "guérir") ; -- tocheck
lin sovereignty_N = mkN "souveraineté" feminine ; -- tocheck
lin enzyme_N = mkN "enzyme" ; -- tocheck
lin host_V2 = mkV2 (mkV "héberger") | mkV2 (mkV I.recevoir_V2) ; -- tocheck
lin neighbouring_A = variants{} ; -- 
lin corn_N = mkN "cor" masculine ; -- tocheck
lin layout_N = mkN "plan" | mkN "disposition" feminine ; -- tocheck
lin dictate_VS = variants{}; -- mkV2 (mkV "dicter") ; -- tocheck
lin dictate_V2 = mkV2 (mkV "dicter") ; -- tocheck
lin dictate_V = variants{}; -- mkV2 (mkV "dicter") ; -- tocheck
lin rip_V2 = mkV2 (mkV "ripper") ; -- tocheck
lin rip_V = variants{}; -- mkV2 (mkV "ripper") ; -- tocheck
lin regain_V2 = mkV2 (mkV I.reconquérir_V2) ; -- tocheck
lin probable_A = mkA "probable" ; -- tocheck
lin inclusion_N = mkN "inclusion" feminine ; -- tocheck
lin booklet_N = mkN "livret" masculine ; -- tocheck
lin bar_V2 = mkV2 (mkV "barrer") | mkV2 (mkV "bloquer") | mkV2 (mkV I.interdire_V2) ; -- tocheck
lin privately_Adv = variants{} ; -- 
lin laser_N = mkN "laser" masculine ; -- tocheck
lin fame_N = mkN "gloire" feminine ; -- tocheck
lin bronze_N = mkN "bronze" masculine | mkN "bronze" ; -- tocheck
lin mobile_A = mkA "mobile" ; -- tocheck
lin metaphor_N = mkN "métaphore" feminine ; -- tocheck
lin complication_N = mkN "complication" feminine ; -- tocheck
lin narrow_V2 = mkV2 (mkV I.réduire_V2) ; -- tocheck
lin narrow_V = variants{}; -- mkV2 (mkV I.réduire_V2) ; -- tocheck
lin old_fashioned_A = mkA "démodé" ; -- tocheck
lin chop_V2 = mkV2 (mkV "hacher") ; -- tocheck
lin chop_V = variants{}; -- mkV2 (mkV "hacher") ; -- tocheck
lin synthesis_N = mkN "synthèse" feminine ; -- tocheck
lin diameter_N = mkN "diamètre" masculine ; -- tocheck
lin bomb_V2 = mkV2 (mkV "bombarder") ; -- tocheck
lin bomb_V = variants{}; -- mkV2 (mkV "bombarder") ; -- tocheck
lin silently_Adv = variants{} ; -- 
lin shed_N = mkN "hangar" masculine ; -- tocheck
lin fusion_N = mkN "fusion" feminine ; -- tocheck
lin trigger_V2 = variants{} ; -- 
lin printing_N = variants{} ; -- 
lin onion_N = mkN "oignon" masculine ; -- tocheck
lin dislike_V2 = variants{} ; -- 
lin embody_V2 = mkV2 (mkV "représenter") | mkV2 (mkV "incarner") ; -- tocheck
lin curl_V = variants{} ; -- 
lin sunshine_N = mkN "soleil" masculine ; -- tocheck
lin sponsorship_N = variants{} ; -- 
lin rage_N = mkN "rage" feminine ; -- tocheck
lin loop_N = mkN "boucle" feminine ; -- tocheck
lin halt_N = variants{} ; -- 
lin cop_V2 = variants{} ; -- 
lin bang_V2 = mkV2 (mkV "cogner") | mkV2 (mkV "baiser") | mkV2 (mkV "claquer") ; -- tocheck
lin bang_V = variants{}; -- mkV2 (mkV "cogner") | mkV2 (mkV "baiser") | mkV2 (mkV "claquer") ; -- tocheck
lin toxic_A = mkA "toxique" ; -- tocheck
lin thinking_A = mkA "pensant" ;
lin orientation_N = mkN "orientation" feminine ; -- tocheck
lin likelihood_N = mkN "vraisemblance" feminine ; -- tocheck
lin wee_A = mkA "petit" ; -- tocheck
lin up_to_date_A = variants{} ; -- 
lin polite_A = mkA "poli" ; -- tocheck
lin apology_N = mkN "excuse" feminine | mkN "apologie" feminine ; -- tocheck
lin exile_N = mkN "exil" masculine ; -- tocheck
lin brow_N = mkN "front" | mkN "sourcil" ; -- tocheck
lin miserable_A = mkA "misérable" ; -- tocheck
lin outbreak_N = mkN "irruption" feminine | mkN "éruption" ; -- tocheck
lin comparatively_Adv = variants{} ; -- 
lin pump_V2 = mkV2 (mkV "pomper") ; -- tocheck
lin pump_V = variants{}; -- mkV2 (mkV "pomper") ; -- tocheck
lin fuck_V2 = mkV2 (mkV "baiser") | mkV2 (mkV "bousiller") | mkV2 (mkV "enculer") | mkV2 (mkV I.foutre_V2) ; -- tocheck
lin fuck_V = variants{}; -- mkV2 (mkV "baiser") | mkV2 (mkV "bousiller") | mkV2 (mkV "enculer") | mkV2 (mkV I.foutre_V2) ; -- tocheck
lin forecast_VS = variants{}; -- mkV2 (mkV I.prévoir_V2) ; -- tocheck
lin forecast_V2 = mkV2 (mkV I.prévoir_V2) ; -- tocheck
lin forecast_V = variants{}; -- mkV2 (mkV I.prévoir_V2) ; -- tocheck
lin timing_N = variants{} ; -- 
lin headmaster_N = variants{} ; -- 
lin terrify_V2 = variants{} ; -- 
lin sigh_N = mkN "soupir" masculine ; -- tocheck
lin premier_A = variants{} ; -- 
lin joint_N = mkN "articulation" feminine | mkN "joint" masculine | mkN "assemblage" masculine | mkN "taule" feminine | mkN "jointure" feminine ; -- tocheck
lin incredible_A = mkA "incroyable" ; -- tocheck
lin gravity_N = mkN "gravité" feminine ; -- tocheck
lin regulatory_A = variants{} ; -- 
lin cylinder_N = mkN "cylindre" masculine | mkN "bonbonne" feminine | mkN "barillet" masculine ; -- tocheck
lin curiosity_N = mkN "curiosité" | mkN "curiosité" feminine ; -- tocheck
lin resident_A = variants{} ; -- 
lin narrative_N = mkN "récit" masculine ; -- tocheck
lin cognitive_A = mkA "cognitif" ; -- tocheck
lin lengthy_A = mkA "long" ; -- tocheck
lin gothic_A = variants{} ; -- 
lin dip_V2 = mkV2 (mkV "tremper") ; -- tocheck
lin dip_V = variants{}; -- mkV2 (mkV "tremper") ; -- tocheck
lin adverse_A = mkA "adverse" | mkA "défavorable" ; -- tocheck
lin accountability_N = mkN "responsabilité" feminine ; -- tocheck
lin hydrogen_N = mkN "hydrogène" masculine ; -- tocheck
lin gravel_N = mkN "graviers" ; -- tocheck
lin willingness_N = variants{} ; -- 
lin inhibit_V2 = mkV2 (mkV "inhiber") ; -- tocheck
lin attain_V2 = mkV2 (mkV I.atteindre_V2) ; -- tocheck
lin attain_V = variants{}; -- mkV2 (mkV I.atteindre_V2) ; -- tocheck
lin specialize_V2 = variants{} ; -- 
lin specialize_V = variants{} ; -- 
lin steer_V2 = mkV2 (mkV "diriger") ; -- tocheck
lin steer_V = variants{}; -- mkV2 (mkV "diriger") ; -- tocheck
lin selected_A = variants{} ; -- 
lin like_N = mkN "préférence" feminine ; -- tocheck
lin confer_V = variants{} ; -- 
lin usage_N = mkN "coutume" feminine | mkN "usage" masculine ; -- tocheck
lin portray_V2 = mkV2 (mkV I.dépeindre_V2) ; -- tocheck
lin planner_N = variants{} ; -- 
lin manual_A = mkA "manuel" ; -- tocheck
lin boast_VS = variants{}; -- mkV2 (reflV (mkV "vanter")) ; -- tocheck
lin boast_V2 = mkV2 (reflV (mkV "vanter")) ; -- tocheck
lin boast_V = variants{}; -- mkV2 (reflV (mkV "vanter")) ; -- tocheck
lin unconscious_A = mkA "inconscient" ; -- tocheck
lin jail_N = variants{} ; -- 
lin fertility_N = mkN "fertilité" ; -- tocheck
lin documentation_N = mkN "documentation" feminine ; -- tocheck
lin wolf_N = mkN "loup" masculine ; -- tocheck
lin patent_N = mkN "brevet" masculine ; -- tocheck
lin exit_N = mkN "sortie" feminine ; -- tocheck
lin corps_N = mkN "corps" masculine ; -- tocheck
lin proclaim_VS = variants{} ; -- 
lin proclaim_V2 = variants{} ; -- 
lin multiply_V2 = mkV2 (reflV (mkV "multiplier")) | mkV2 (mkV "multiplier") ; -- tocheck
lin multiply_V = variants{}; -- mkV2 (reflV (mkV "multiplier")) | mkV2 (mkV "multiplier") ; -- tocheck
lin brochure_N = mkN "brochure" feminine ; -- tocheck
lin screen_V2 = variants{} ; -- 
lin screen_V = variants{} ; -- 
lin orthodox_A = mkA "orthodoxe" ; -- tocheck
lin locomotive_N = mkN "locomotive" feminine ; -- tocheck
lin considering_Prep = variants{} ; -- 
lin unaware_A = variants{} ; -- 
lin syndrome_N = mkN "syndrome" masculine ; -- tocheck
lin reform_V2 = variants{} ; -- 
lin reform_V = variants{} ; -- 
lin confirmation_N = mkN "confirmation" feminine ; -- tocheck
lin printed_A = variants{} ; -- 
lin curve_V2 = variants{} ; -- 
lin curve_V = variants{} ; -- 
lin costly_A = mkA "coûteux" ; -- tocheck
lin underground_A = mkA "souterrain" | mkA "underground" ; -- tocheck
lin territorial_A = mkA "territorial" ; -- tocheck
lin designate_VS = variants{} ; -- 
lin designate_V2V = variants{} ; -- 
lin designate_V2 = variants{} ; -- 
lin designate_V = variants{} ; -- 
lin comfort_V2 = mkV2 (mkV "consoler") ; -- tocheck
lin plot_V2 = mkV2 (mkV "conspirer") | mkV2 (mkV "tracer") ; -- tocheck
lin plot_V = variants{}; -- mkV2 (mkV "conspirer") | mkV2 (mkV "tracer") ; -- tocheck
lin misleading_A = variants{} ; -- 
lin weave_V2 = mkV2 (mkV "tisser") | mkV2 (reflV (mkV "faufiler")) ; -- tocheck
lin weave_V = variants{}; -- mkV2 (mkV "tisser") | mkV2 (reflV (mkV "faufiler")) ; -- tocheck
lin scratch_V2 = L.scratch_V2 ;
lin scratch_V = variants{}; -- L.scratch_V2 ;
lin echo_N = mkN "écho" masculine ; -- tocheck
lin ideally_Adv = variants{} ; -- 
lin endure_V2 = mkV2 (mkV "endurer") ; -- tocheck
lin endure_V = variants{}; -- mkV2 (mkV "endurer") ; -- tocheck
lin verbal_A = mkA "oral" | mkA "verbal" ; -- tocheck
lin stride_V = variants{} ; -- 
lin nursing_N = variants{} ; -- 
lin exert_V2 = mkV2 (mkV "exercer") ; -- tocheck
lin compatible_A = mkA "compatible" ; -- tocheck
lin causal_A = mkA "causal" ; -- tocheck
lin mosaic_N = mkN "mosaïque" feminine ; -- tocheck
lin manor_N = mkN "manoir" ; -- tocheck
lin implicit_A = mkA "inhérent" | mkA "implicite" | mkA "absolu" ; -- tocheck
lin following_Prep = variants{} ; -- 
lin fashionable_A = variants{} ; -- 
lin valve_N = mkN "clapet" masculine ; -- tocheck
lin proceed_N = variants{} ; -- 
lin sofa_N = mkN "canapé" masculine ; -- tocheck
lin snatch_V2 = variants{} ; -- 
lin snatch_V = variants{} ; -- 
lin jazz_N = mkN "jazz" masculine ; -- tocheck
lin patron_N = mkN "client" masculine | mkN "mécène" masculine ; -- tocheck
lin provider_N = mkN "fournisseur" masculine ; -- tocheck
lin interim_A = variants{} ; -- 
lin intent_N = variants{} ; -- 
lin chosen_A = variants{} ; -- 
lin applied_A = variants{} ; -- 
lin shiver_V = variants{}; -- mkV2 (mkV "trembler") ; -- tocheck
lin pie_N = mkN "tourte" feminine | mkN "tarte" feminine | mkN "gâteau" ; -- tocheck
lin fury_N = mkN "acharnement" masculine ; -- tocheck
lin abolition_N = mkN "abolition" feminine ; -- tocheck
lin soccer_N = mkN "football" ; -- tocheck
lin corpse_N = mkN "cadavre" masculine ; -- tocheck
lin accusation_N = mkN "accusation" feminine ; -- tocheck
lin kind_A = mkA "favorable" | mkA "gentil" ; -- tocheck
lin dead_Adv = variants{} ; -- 
lin nursing_A = variants{} ; -- 
lin contempt_N = mkN "mépris" masculine | mkN "outrage" masculine ; -- tocheck
lin prevail_V = variants{}; -- mkV2 (mkV "prédominer") | mkV2 (mkV "dominer") | mkV2 (mkV "persuader") ; -- tocheck
lin murderer_N = mkN "meurtrier" masculine ; -- tocheck
lin liberal_N = mkN "libéral" masculine | mkN "libéral" ; -- tocheck
lin gathering_N = mkN "rencontre" feminine | mkN "cahier" masculine | mkN "assemblée" ; -- tocheck
lin adequately_Adv = variants{} ; -- 
lin subjective_A = mkA "subjectif" ; -- tocheck
lin disagreement_N = mkN "désaccord" masculine ; -- tocheck
lin cleaner_N = mkN "nettoyant" masculine | mkN "nettoyeur" masculine | mkN "pressing" masculine ; -- tocheck
lin boil_V2 = mkV2 (mkV I.bouillir_V2) ; -- tocheck
lin boil_V = variants{}; -- mkV2 (mkV I.bouillir_V2) ; -- tocheck
lin static_A = mkA "statique" ; -- tocheck
lin scent_N = mkN "odeur" masculine ; -- tocheck
lin civilian_N = variants{} ; -- 
lin monk_N = mkN "moine" ; -- tocheck
lin abruptly_Adv = variants{} ; -- 
lin keyboard_N = mkN "clavier" masculine ; -- tocheck
lin hammer_N = mkN "marteau" masculine | mkN "chien" masculine ; -- tocheck
lin despair_N = mkN "désespoir" masculine ; -- tocheck
lin controller_N = mkN "contrôleur" | mkN "contrôleur" masculine ; -- tocheck
lin yell_V2 = mkV2 (mkV "crier") ; -- tocheck
lin yell_V = variants{}; -- mkV2 (mkV "crier") ; -- tocheck
lin entail_V2 = mkV2 (mkV "comporter") ; -- tocheck
lin cheerful_A = mkA "joyeux" ; -- tocheck
lin reconstruction_N = mkN "reconstitution" feminine ; -- tocheck
lin patience_N = mkN "patience" feminine ; -- tocheck
lin legally_Adv = variants{} ; -- 
lin habitat_N = mkN "habitat" masculine ; -- tocheck
lin queue_N = mkN "file" feminine | mkN "natte" feminine | mkN "queue" feminine | mkN "file" ; -- tocheck
lin spectatorMasc_N = mkN "spectateur" masculine ;
lin given_A = variants{} ; -- 
lin purple_A = mkA "violet" ; -- tocheck
lin outlook_N = mkN "perspective" | mkN "vue" feminine ; -- tocheck
lin genius_N = mkN "génie" masculine ; -- tocheck
lin dual_A = mkA "double" | mkA "duel" ; -- tocheck
lin canvas_N = mkN "toile" feminine ; -- tocheck
lin grave_A = variants{} ; -- 
lin pepper_N = mkN "poivrier" masculine | mkN "poivre" masculine ; -- tocheck
lin conform_V2 = mkV2 (reflV (mkV "aligner")) ; -- tocheck
lin conform_V = variants{}; -- mkV2 (reflV (mkV "aligner")) ; -- tocheck
lin cautious_A = mkA "prudent" ; -- tocheck
lin dot_N = mkN "point" masculine | mkN "point" ; -- tocheck
lin conspiracy_N = mkN "conspiration" feminine ; -- tocheck
lin butterfly_N = mkN "papillon" masculine ; -- tocheck
lin sponsor_N = variants{} ; -- 
lin sincerely_Adv = mkAdv "sincèrement" ;
lin rating_N = mkN "notation" feminine ; -- tocheck
lin weird_A = mkA "bizarre" ; -- tocheck
lin teenage_A = variants{} ; -- 
lin salmon_N = mkN "saumon" | mkN "saumon" masculine ; -- tocheck
lin recorder_N = mkN "enregistreur" masculine ; -- tocheck
lin postpone_V2 = mkV2 (mkV "ajourner") ; -- tocheck
lin maid_N = mkN "bonne" feminine | mkN "demoiselle" feminine ; -- tocheck
lin furnish_V2 = mkV2 (mkV "fournir") ; -- tocheck
lin ethical_A = variants{} ; -- 
lin bicycle_N = mkN "vélo" masculine ; -- tocheck
lin sick_N = variants{} ; -- 
lin sack_N = mkN "butin" masculine | mkN "paquet" masculine | mkN "sac" masculine ; -- tocheck
lin renaissance_N = variants{} ; -- 
lin luxury_N = mkN "luxe" masculine ; -- tocheck
lin gasp_V2 = mkV2 (mkV "haleter") ; -- tocheck
lin gasp_V = variants{}; -- mkV2 (mkV "haleter") ; -- tocheck
lin wardrobe_N = mkN "garde-robe" feminine ; -- tocheck
lin native_N = variants{} ; -- 
lin fringe_N = mkN "frange" feminine | mkN "radicaux" masculine | mkN "périphérie" feminine ; -- tocheck
lin adaptation_N = mkN "adaptation" feminine ; -- tocheck
lin quotation_N = mkN "devis" masculine | mkN "citation" feminine ; -- tocheck
lin hunger_N = mkN "faim" feminine | mkN "soif" feminine ; -- tocheck
lin enclose_V2 = variants{} ; -- 
lin disastrous_A = mkA "désastreux" ; -- tocheck
lin choir_N = mkN "choeur" masculine ; -- tocheck
lin overwhelming_A = variants{} ; -- 
lin glimpse_N = mkN "aperçu" masculine ; -- tocheck
lin divorce_V2 = mkV2 (mkV "divorcer") ; -- tocheck
lin circular_A = mkA "rond" ; -- tocheck
lin locality_N = mkN "quartier" masculine | mkN "région" ; -- tocheck
lin ferry_N = mkN "ferry" masculine ; -- tocheck
lin balcony_N = mkN "balcon" masculine ; -- tocheck
lin sailor_N = mkN "matelot" masculine ; -- tocheck
lin precision_N = mkN "précision" ; -- tocheck
lin desert_V2 = mkV2 (mkV "déserter") ; -- tocheck
lin desert_V = variants{}; -- mkV2 (mkV "déserter") ; -- tocheck
lin dancing_N = variants{} ; -- 
lin alert_V2 = variants{} ; -- 
lin surrender_V2 = mkV2 (mkV "capituler") ; -- tocheck
lin surrender_V = variants{}; -- mkV2 (mkV "capituler") ; -- tocheck
lin archive_N = mkN "archives" ; -- tocheck
lin jump_N = mkN "saut" masculine ; -- tocheck
lin philosopher_N = mkN "philosophe" ; -- tocheck
lin revival_N = variants{} ; -- 
lin presume_VS = variants{} ; -- 
lin presume_V2 = variants{} ; -- 
lin presume_V = variants{} ; -- 
lin node_N = mkN "noeud" masculine ; -- tocheck
lin fantastic_A = mkA "fantastique" ; -- tocheck
lin herb_N = mkN "herbe" feminine ; -- tocheck
lin assertion_N = variants{} ; -- 
lin thorough_A = mkA "exhaustif" | mkA "minutieux" ; -- tocheck
lin quit_V2 = mkV2 (mkV "quitter") | mkV2 (mkV "arrêter") ; -- tocheck
lin quit_V = variants{}; -- mkV2 (mkV "quitter") | mkV2 (mkV "arrêter") ; -- tocheck
lin grim_A = mkA "sinistre" ; -- tocheck
lin fair_N = mkN "foire" feminine | mkN "marché" masculine ; -- tocheck
lin broadcast_V2 = mkV2 (mkV "diffuser") ; -- tocheck
lin broadcast_V = variants{}; -- mkV2 (mkV "diffuser") ; -- tocheck
lin annoy_V2 = mkV2 (mkV "gêner") ; -- tocheck
lin divert_V = variants{}; -- mkV2 (mkV "dévier") | mkV2 (mkV "divertir") ; -- tocheck
lin accelerate_V2 = mkV2 (mkV "accélérer") ; -- tocheck
lin accelerate_V = variants{}; -- mkV2 (mkV "accélérer") ; -- tocheck
lin polymer_N = mkN "polymère" ; -- tocheck
lin sweat_N = mkN "troufion" masculine | mkN "sueur" feminine ; -- tocheck
lin survivor_N = mkN "survivant" masculine ; -- tocheck
lin subscription_N = mkN "abonnement" masculine ; -- tocheck
lin repayment_N = variants{} ; -- 
lin anonymous_A = mkA "anonyme" ; -- tocheck
lin summarize_V2 = mkV2 (mkV "récapituler") | mkV2 (mkV "résumer") ; -- tocheck
lin punch_N = mkN "punch" | mkN "poinçon" masculine | mkN "poinçonnage" masculine | mkN "poinçonneuse" feminine ; -- tocheck
lin lodge_V2 = mkV2 (mkV "demeurer") ; -- tocheck
lin lodge_V = variants{}; -- mkV2 (mkV "demeurer") ; -- tocheck
lin landowner_N = variants{} ; -- 
lin ignorance_N = mkN "ignorance" feminine ; -- tocheck
lin discourage_V2 = mkV2 (mkV "décourager") | mkV2 (mkV "dissuader") ; -- tocheck
lin bride_N = variants{} ; -- 
lin likewise_Adv = mkAdv "pareillement" ; -- tocheck
lin depressed_A = variants{} ; -- 
lin abbey_N = mkN "abbaye" feminine ; -- tocheck
lin quarry_N = mkN "proie" feminine | mkN "carrière" feminine ; -- tocheck
lin archbishop_N = mkN "archevêque" masculine ; -- tocheck
lin sock_N = L.sock_N ;
lin large_scale_A = variants{} ; -- 
lin glare_V2 = variants{} ; -- 
lin glare_V = variants{} ; -- 
lin descent_N = mkN "origine" feminine ; -- tocheck
lin stumble_V = mkV (mkV "butter") | mkV (mkV "trébucher") ; -- tocheck
lin mistress_N = mkN "maîtresse" feminine ;
lin empty_V2 = mkV2 (mkV "vider") ; -- tocheck
lin empty_V = variants{}; -- mkV2 (mkV "vider") ; -- tocheck
lin prosperity_N = mkN "prospérité" feminine ; -- tocheck
lin harm_V2 = variants{} ; -- 
lin formulation_N = variants{} ; -- 
lin atomic_A = mkA "atomique" ; -- tocheck
lin agreed_A = variants{} ; -- 
lin wicked_A = mkA "génial" | mkA "méchant" ; -- tocheck
lin threshold_N = mkN "seuil" masculine | mkN "seuil" ; -- tocheck
lin lobby_N = mkN "lobby" masculine | mkN "vestibule" masculine ; -- tocheck
lin repay_V2 = mkV2 (mkV "repayer") ; -- tocheck
lin repay_V = variants{}; -- mkV2 (mkV "repayer") ; -- tocheck
lin varying_A = variants{} ; -- 
lin track_V2 = variants{} ; -- 
lin track_V = variants{} ; -- 
lin crawl_V = mkV (mkV "ramper") ; -- tocheck
lin tolerate_V2 = mkV2 (mkV "tolérer") ; -- tocheck
lin salvation_N = mkN "salut" masculine ; -- tocheck
lin pudding_N = mkN "pudding" masculine | mkN "boudin" masculine ; -- tocheck
lin counter_VS = variants{} ; -- 
lin counter_V = variants{} ; -- 
lin propaganda_N = mkN "propagande" ; -- tocheck
lin cage_N = mkN "cage" feminine ; -- tocheck
lin broker_N = mkN "courtier" masculine ; -- tocheck
lin ashamed_A = mkA "honteux" ; -- tocheck
lin scan_V2 = mkV2 (mkV "scanner") | mkV2 (mkV "scander") ; -- tocheck
lin scan_V = variants{}; -- mkV2 (mkV "scanner") | mkV2 (mkV "scander") ; -- tocheck
lin document_V2 = mkV2 (mkV "documenter") ; -- tocheck
lin apparatus_N = mkN "appareil" masculine ; -- tocheck
lin theology_N = mkN "théologie" feminine ; -- tocheck
lin analogy_N = mkN "analogie" feminine ; -- tocheck
lin efficiently_Adv = variants{} ; -- 
lin bitterly_Adv = variants{} ; -- 
lin performer_N = mkN "artiste" ; -- tocheck
lin individually_Adv = variants{} ; -- 
lin amid_Prep = variants{} ; -- 
lin squadron_N = mkN "escadron" masculine ; -- tocheck
lin sentiment_N = mkN "sentiment" masculine ; -- tocheck
lin making_N = variants{} ; -- 
lin exotic_A = mkA "exotique" ; -- tocheck
lin dominance_N = mkN "dominance" feminine ; -- tocheck
lin coherent_A = mkA "cohérent" ; -- tocheck
lin placement_N = mkN "placement" masculine ; -- tocheck
lin flick_V2 = mkV2 (mkV "défiler") ; -- tocheck
lin colourful_A = mkA "coloré" ;
lin mercy_N = mkN "miséricorde" feminine ; -- tocheck
lin angrily_Adv = variants{} ; -- 
lin amuse_V2 = mkV2 (mkV "amuser") ; -- tocheck
lin mainstream_N = variants{} ; -- 
lin appraisal_N = mkN "estimation" feminine ; -- tocheck
lin annually_Adv = variants{} ; -- 
lin torch_N = mkN "torche" feminine ; -- tocheck
lin intimate_A = mkA "intime" ; -- tocheck
lin gold_A = variants{} ; -- 
lin arbitrary_A = mkA "arbitraire" | mkA "quelconque" ; -- tocheck
lin venture_VS = variants{}; -- mkV2 (reflV (mkV "aventurer")) ; -- tocheck
lin venture_V2 = mkV2 (reflV (mkV "aventurer")) ; -- tocheck
lin venture_V = variants{}; -- mkV2 (reflV (mkV "aventurer")) ; -- tocheck
lin preservation_N = mkN "préservation" feminine ; -- tocheck
lin shy_A = mkA "apeuré" | mkA "prudent" | mkA "embarrassé" | mkA "timide" ; -- tocheck
lin disclosure_N = mkN "révélation" feminine ; -- tocheck
lin lace_N = mkN "lacet" masculine | mkN "dentelle" feminine ; -- tocheck
lin inability_N = mkN "incapacité" feminine ; -- tocheck
lin motif_N = mkN "motif" masculine ; -- tocheck
lin listenerMasc_N = mkN "auditeur" masculine ;
lin hunt_N = mkN "chasse" feminine ; -- tocheck
lin delicious_A = mkA "délicieux" ; -- tocheck
lin term_VS = variants{} ; -- 
lin term_V2 = variants{} ; -- 
lin substitute_N = mkN "remplaçant" masculine ; -- tocheck
lin highway_N = variants{} ; -- 
lin haul_V2 = mkV2 (mkV "trainer") | mkV2 (mkV "haler") ; -- tocheck
lin haul_V = variants{}; -- mkV2 (mkV "trainer") | mkV2 (mkV "haler") ; -- tocheck
lin dragon_N = mkN "dragon" masculine | mkN "vouivre" ; -- tocheck
lin chair_V2 = mkV2 (mkV "présider") ; -- tocheck
lin accumulate_V2 = mkV2 (mkV "accumuler") ; -- tocheck
lin accumulate_V = variants{}; -- mkV2 (mkV "accumuler") ; -- tocheck
lin unchanged_A = variants{} ; -- 
lin sediment_N = mkN "sédiment" masculine ; -- tocheck
lin sample_V2 = mkV2 (mkV "échantillonner") ; -- tocheck
lin exclaim_V2 = mkV2 (mkV "exclamer") ; -- tocheck
lin fan_V2 = mkV2 (mkV "éventer") | mkV2 (mkV "disperser") ; -- tocheck
lin fan_V = variants{}; -- mkV2 (mkV "éventer") | mkV2 (mkV "disperser") ; -- tocheck
lin volunteer_V2 = variants{} ; -- 
lin volunteer_V = variants{} ; -- 
lin root_V2 = mkV2 (mkV "fourrer") ; -- tocheck
lin root_V = variants{}; -- mkV2 (mkV "fourrer") ; -- tocheck
lin parcel_N = mkN "parcelle" feminine | mkN "colis" masculine ; -- tocheck
lin psychiatric_A = mkA "psychiatrique" ; -- tocheck
lin delightful_A = mkA "délicieux" ; -- tocheck
lin confidential_A = mkA "confidentiel" ; -- tocheck
lin calorie_N = mkN "calorie" feminine ; -- tocheck
lin flash_N = variants{} ; -- 
lin crowd_V2 = variants{} ; -- 
lin crowd_V = variants{} ; -- 
lin aggregate_A = variants{} ; -- 
lin scholarship_N = mkN "érudition" feminine | mkN "bourse" feminine ; -- tocheck
lin monitor_N = mkN "écran" masculine | mkN "moniteur" masculine ; -- tocheck
lin disciplinary_A = variants{} ; -- 
lin rock_V2 = mkV2 (mkV "secouer") | mkV2 (mkV "remuer") | mkV2 (mkV "gérer") ; -- tocheck
lin rock_V = variants{}; -- mkV2 (mkV "secouer") | mkV2 (mkV "remuer") | mkV2 (mkV "gérer") ; -- tocheck
lin hatred_N = mkN "haine" feminine ; -- tocheck
lin pill_N = mkN "pilule" | mkN "pilule" feminine ; -- tocheck
lin noisy_A = mkA "bruyant" ; -- tocheck
lin feather_N = L.feather_N ;
lin lexical_A = variants{} ; -- 
lin staircase_N = mkN "escalier" masculine ; -- tocheck
lin autonomous_A = mkA "autonome" ; -- tocheck
lin viewpoint_N = variants{} ; -- 
lin projection_N = mkN "saillie" feminine | mkN "projection" feminine ; -- tocheck
lin offensive_A = mkA "offensant" | mkA "offensif" ; -- tocheck
lin controlled_A = variants{} ; -- 
lin flush_V2 = mkV2 (mkV "rougir") ; -- tocheck
lin flush_V = variants{}; -- mkV2 (mkV "rougir") ; -- tocheck
lin racism_N = mkN "racisme" masculine ; -- tocheck
lin flourish_V = variants{}; -- mkV2 (mkV "fleurir") ; -- tocheck
lin resentment_N = mkN "ressentiment" masculine ; -- tocheck
lin pillow_N = mkN "oreiller" masculine ; -- tocheck
lin courtesy_N = mkN "indulgence" feminine | mkN "courtoisie" feminine | mkN "politesse" feminine ; -- tocheck
lin photography_N = mkN "photographie" feminine ; -- tocheck
lin monkey_N = mkN "singe" masculine ; -- tocheck
lin glorious_A = mkA "glorieux" ; -- tocheck
lin evolutionary_A = variants{} ; -- 
lin gradual_A = variants{} ; -- 
lin bankruptcy_N = mkN "faillite" feminine ; -- tocheck
lin sacrifice_N = mkN "sacrifice" masculine ; -- tocheck
lin uphold_V2 = mkV2 (mkV I.soutenir_V2) ; -- tocheck
lin sketch_N = mkN "esquisse" feminine | mkN "ébauche" feminine | mkN "sketch" masculine ; -- tocheck
lin presidency_N = mkN "présidence" feminine ; -- tocheck
lin formidable_A = mkA "formidable" ; -- tocheck
lin differentiate_V2 = variants{} ; -- 
lin differentiate_V = variants{} ; -- 
lin continuing_A = variants{} ; -- 
lin cart_N = mkN "chariot" masculine ; -- tocheck
lin stadium_N = mkN "stade" masculine ; -- tocheck
lin dense_A = variants{} ; -- 
lin catch_N = mkN "hic" masculine ; -- tocheck
lin beyond_Adv = variants{} ; -- 
lin immigration_N = mkN "immigration" feminine ; -- tocheck
lin clarity_N = mkN "clarté" feminine ; -- tocheck
lin worm_N = L.worm_N ;
lin slot_N = mkN "emplacement" masculine | mkN "barre" feminine ; -- tocheck
lin rifle_N = mkN "fusil" masculine ; -- tocheck
lin screw_V2 = mkV2 (mkV "tricher") | mkV2 (mkV "visser") ; -- tocheck
lin screw_V = variants{}; -- mkV2 (mkV "tricher") | mkV2 (mkV "visser") ; -- tocheck
lin harvest_N = mkN "récolte" feminine ; -- tocheck
lin foster_V2 = mkV2 (mkV I.promouvoir_V2) | mkV2 (mkV "cultiver") | mkV2 (mkV "élever") ; -- tocheck
lin academic_N = mkN "universitaire" masculine ; -- tocheck
lin impulse_N = mkN "impulsion" ; -- tocheck
lin guardian_N = mkN "boss" masculine | mkN "gardien" masculine | mkN "tuteur" masculine ; -- tocheck
lin ambiguity_N = mkN "ambiguïté" feminine ; -- tocheck
lin triangle_N = mkN "triangle" masculine ; -- tocheck
lin terminate_V2 = mkV2 (mkV "terminer") ; -- tocheck
lin terminate_V = variants{}; -- mkV2 (mkV "terminer") ; -- tocheck
lin retreat_V = variants{} ; -- 
lin pony_N = mkN "poney" masculine ; -- tocheck
lin outdoor_A = variants{} ; -- 
lin deficiency_N = mkN "déficience" feminine ; -- tocheck
lin decree_N = mkN "décret" masculine ; -- tocheck
lin apologize_V = mkV (reflV (mkV "excuser")) ; -- tocheck
lin yarn_N = mkN "fil" masculine | mkN "corde" feminine ; -- tocheck
lin staff_V2 = variants{} ; -- 
lin renewal_N = mkN "renouvellement" masculine ; -- tocheck
lin rebellion_N = mkN "rébellion" feminine ; -- tocheck
lin incidentally_Adv = variants{} ; -- 
lin flour_N = mkN "farine" feminine ; -- tocheck
lin developed_A = variants{} ; -- 
lin chorus_N = mkN "choeur" masculine | mkN "refrain" masculine ; -- tocheck
lin ballot_N = variants{} ; -- 
lin appetite_N = mkN "appétit" masculine ; -- tocheck
lin stain_V2 = mkV2 (mkV "entacher") ; -- tocheck
lin stain_V = variants{}; -- mkV2 (mkV "entacher") ; -- tocheck
lin notebook_N = mkN "cahier" masculine ; -- tocheck
lin loudly_Adv = variants{} ; -- 
lin homeless_A = variants{} ; -- 
lin census_N = mkN "recensement" masculine ; -- tocheck
lin bizarre_A = mkA "bizarre" ; -- tocheck
lin striking_A = variants{} ; -- 
lin greenhouse_N = mkN "serre" feminine ; -- tocheck
lin part_V2 = mkV2 (reflV (mkV "séparer")) | mkV2 (mkV "séparer") ; -- tocheck
lin part_V = variants{}; -- mkV2 (reflV (mkV "séparer")) | mkV2 (mkV "séparer") ; -- tocheck
lin burial_N = mkN "enterrement" ; -- tocheck
lin embarrassed_A = variants{} ; -- 
lin ash_N = mkN "cendre" feminine | mkN "frêne" masculine ; -- tocheck
lin actress_N = mkN "actrice" feminine ; -- tocheck
lin cassette_N = mkN "cassette" feminine ; -- tocheck
lin privacy_N = mkN "intimité" feminine ; -- tocheck
lin fridge_N = L.fridge_N ;
lin feed_N = mkN "alimentation" feminine | mkN "flux" masculine ; -- tocheck
lin excess_A = variants{} ; -- 
lin calf_N = mkN "mollet" masculine | mkN "veau" masculine | mkN "éléphanteau" masculine ; -- tocheck
lin associate_N = variants{} ; -- 
lin ruin_N = mkN "ruine" feminine ; -- tocheck
lin jointly_Adv = variants{} ; -- 
lin drill_V2 = mkV2 (mkV "forer") | mkV2 (mkV "entraîner") | mkV2 (mkV "approfondir") | mkV2 (mkV "rabâcher") | mkV2 (reflV (mkV "entraîner")) ; -- tocheck
lin drill_V = variants{}; -- mkV2 (mkV "forer") | mkV2 (mkV "entraîner") | mkV2 (mkV "approfondir") | mkV2 (mkV "rabâcher") | mkV2 (reflV (mkV "entraîner")) ; -- tocheck
lin photograph_V2 = mkV2 (mkV "photographier") ; -- tocheck
lin devoted_A = variants{} ; -- 
lin indirectly_Adv = variants{} ; -- 
lin driving_A = variants{} ; -- 
lin memorandum_N = mkN "mémorandum" masculine ; -- tocheck
lin default_N = mkN "défaut" ; -- tocheck
lin costume_N = mkN "costume" masculine ; -- tocheck
lin variant_N = mkN "variante" feminine ; -- tocheck
lin shatter_V2 = mkV2 (mkV "fracasser") | mkV2 (mkV "éclater") ; -- tocheck
lin shatter_V = variants{}; -- mkV2 (mkV "fracasser") | mkV2 (mkV "éclater") ; -- tocheck
lin methodology_N = mkN "méthodologie" feminine ; -- tocheck
lin frame_V2 = variants{} ; -- 
lin frame_V = variants{} ; -- 
lin allegedly_Adv = variants{} ; -- 
lin swell_V2 = mkV2 (mkV "gonfler") ; -- tocheck
lin swell_V = L.swell_V ;
lin investigator_N = mkN "enquêteur" masculine ; -- tocheck
lin imaginative_A = mkA "imaginaire" | mkA "imaginatif" ; -- tocheck
lin bored_A = variants{} ; -- 
lin bin_N = mkN "boîte" feminine | mkN "poubelle" feminine ; -- tocheck
lin awake_A = mkA "éveillé" ; -- tocheck
lin recycle_V2 = mkV2 (mkV "recycler") ; -- tocheck
lin group_V2 = mkV2 (mkV "grouper") ; -- tocheck
lin group_V = variants{}; -- mkV2 (mkV "grouper") ; -- tocheck
lin enjoyment_N = variants{} ; -- 
lin contemporary_N = mkN "contemporain" masculine ; -- tocheck
lin texture_N = mkN "texture" feminine | mkN "texture" masculine ; -- tocheck
lin donor_N = mkN "donateur" ; -- tocheck
lin bacon_N = mkN "lardon" masculine ; -- tocheck
lin sunny_A = mkA "ensoleillé" ; -- tocheck
lin stool_N = mkN "tabouret" masculine | mkN "selle" feminine ; -- tocheck
lin prosecute_V2 = variants{} ; -- 
lin commentary_N = variants{} ; -- 
lin bass_N = mkN "perche" masculine | mkN "basse" feminine ; -- tocheck
lin sniff_V2 = mkV2 (mkV "renifler") ; -- tocheck
lin sniff_V = variants{}; -- mkV2 (mkV "renifler") ; -- tocheck
lin repetition_N = mkN "répétition" feminine ; -- tocheck
lin eventual_A = variants{} ; -- 
lin credit_V2 = variants{} ; -- 
lin suburb_N = mkN "banlieue" feminine ; -- tocheck
lin newcomer_N = variants{} ; -- 
lin romance_N = mkN "romance" feminine ; -- tocheck
lin film_V2 = mkV2 (mkV "filmer") ; -- tocheck
lin film_V = variants{}; -- mkV2 (mkV "filmer") ; -- tocheck
lin experiment_V2 = mkV2 (mkV "expérimenter") ; -- tocheck
lin experiment_V = variants{}; -- mkV2 (mkV "expérimenter") ; -- tocheck
lin daylight_N = mkN "jour" masculine ; -- tocheck
lin warrant_N = mkN "mandat" masculine ; -- tocheck
lin fur_N = mkN "fourrure" feminine | mkN "pelage" ; -- tocheck
lin parking_N = mkN "stationnement" masculine | mkN "parking" masculine ; -- tocheck
lin nuisance_N = mkN "embêtement" masculine ; -- tocheck
lin civilian_A = mkA "civil" ; -- tocheck
lin foolish_A = mkA "sot" | mkA "idiot" ; -- tocheck
lin bulb_N = mkN "bulbe" masculine ; -- tocheck
lin balloon_N = mkN "ballon" masculine | mkN "montgolfière" feminine ; -- tocheck
lin vivid_A = mkA "vivide" ; -- tocheck
lin surveyor_N = mkN "arpenteur" masculine ; -- tocheck
lin spontaneous_A = mkA "impulsif" | mkA "réflexe" | mkA "spontané" | mkA "naturel" | mkA "indigène" | mkA "imprévisible" | mkA "soudain" ; -- tocheck
lin biology_N = mkN "biologie" feminine ; -- tocheck
lin injunction_N = mkN "injonction" feminine ; -- tocheck
lin appalling_A = variants{} ; -- 
lin amusement_N = mkN "amusement" masculine ; -- tocheck
lin aesthetic_A = mkA "esthétique" ; -- tocheck
lin vegetation_N = mkN "végétation" feminine ; -- tocheck
lin stab_V2 = L.stab_V2 ;
lin stab_V = variants{}; -- L.stab_V2 ;
lin rude_A = mkA "impoli" ; -- tocheck
lin offset_V2 = mkV2 (mkV "compenser") ; -- tocheck
lin thinking_N = mkN "pensée" ;
lin mainframe_N = variants{} ; -- 
lin flock_N = mkN "vol" masculine | mkN "troupeau" masculine | mkN "congrégation" feminine ; -- tocheck
lin amateur_A = variants{} ; -- 
lin academy_N = mkN "académie" feminine ; -- tocheck
lin shilling_N = mkN "shilling" masculine ; -- tocheck
lin reluctance_N = mkN "réticence" feminine ; -- tocheck
lin velocity_N = mkN "vitesse" feminine ; -- tocheck
lin spare_V2 = variants{} ; -- 
lin spare_V = variants{} ; -- 
lin wartime_N = variants{} ; -- 
lin soak_V2 = mkV2 (mkV "tremper") | mkV2 (mkV "éponger") ; -- tocheck
lin soak_V = variants{}; -- mkV2 (mkV "tremper") | mkV2 (mkV "éponger") ; -- tocheck
lin rib_N = mkN "côte" feminine | mkN "côtelette" feminine ; -- tocheck
lin mighty_A = mkA "puissant" ; -- tocheck
lin shocked_A = variants{} ; -- 
lin vocational_A = variants{} ; -- 
lin spit_V2 = mkV2 (mkV "cracher") ; -- tocheck
lin spit_V = L.spit_V ;
lin gall_N = mkN "culot" masculine | mkN "bile" feminine ; -- tocheck
lin bowl_V2 = variants{} ; -- 
lin bowl_V = variants{} ; -- 
lin prescription_N = mkN "ordonnance" feminine ; -- tocheck
lin fever_N = mkN "fièvre" feminine ; -- tocheck
lin axis_N = mkN "axe" masculine ; -- tocheck
lin reservoir_N = mkN "réservoir" masculine ; -- tocheck
lin magnitude_N = mkN "magnitude" feminine | mkN "ampleur" feminine | mkN "grandeur" feminine ; -- tocheck
lin rape_V2 = mkV2 (mkV "violer") ; -- tocheck
lin cutting_N = mkN "découpage" ; -- tocheck
lin bracket_N = mkN "parenthèse" feminine | mkN "crochet" masculine ; -- tocheck
lin agony_N = mkN "agonie" feminine ; -- tocheck
lin strive_VV = variants{}; -- mkV (reflV (mkV "efforcer")) ; -- tocheck
lin strive_V = mkV (reflV (mkV "efforcer")) ; -- tocheck
lin strangely_Adv = variants{} ; -- 
lin pledge_VS = variants{}; -- mkV2V (mkV I.promettre_V2) ; -- tocheck
lin pledge_V2V = mkV2V (mkV I.promettre_V2) ; -- tocheck
lin pledge_V2 = variants{}; -- mkV2V (mkV I.promettre_V2) ; -- tocheck
lin recipient_N = mkN "receveur" masculine ; -- tocheck
lin moor_N = mkN "bruyère" feminine ; -- tocheck
lin invade_V2 = mkV2 (mkV "envahir") ; -- tocheck
lin dairy_N = mkN "laiterie" feminine | mkN "laiterie" | mkN "laitages" | mkN "crémerie" ; -- tocheck
lin chord_N = mkN "accord" | mkN "corde" feminine ; -- tocheck
lin shrink_V2 = mkV2 (mkV "diminuer") | mkV2 (reflV (mkV I.réduire_V2)) | mkV2 (mkV "rétrécir") ; -- tocheck
lin shrink_V = variants{}; -- mkV2 (mkV "diminuer") | mkV2 (reflV (mkV I.réduire_V2)) | mkV2 (mkV "rétrécir") ; -- tocheck
lin poison_N = mkN "poison" masculine ; -- tocheck
lin pillar_N = mkN "pilier" masculine ; -- tocheck
lin washing_N = mkN "linge" masculine | mkN "lavage" masculine ; -- tocheck
lin warrior_N = mkN "guerrier" masculine ; -- tocheck
lin supervisor_N = mkN "superviseur" masculine ; -- tocheck
lin outfit_N = mkN "maison" feminine | mkN "nécessaire" masculine | mkN "tenue" feminine ; -- tocheck
lin innovative_A = mkA "novateur" ; -- tocheck
lin dressing_N = variants{} ; -- 
lin dispute_V2 = variants{} ; -- 
lin dispute_V = variants{} ; -- 
lin jungle_N = mkN "jungle" feminine ; -- tocheck
lin brewery_N = mkN "brasserie" feminine ; -- tocheck
lin adjective_N = mkN "adjectif" masculine ; -- tocheck
lin straighten_V2 = variants{} ; -- 
lin straighten_V = variants{} ; -- 
lin restrain_V2 = mkV2 (mkV I.retenir_V2) | mkV2 (mkV "réprimer") | mkV2 (mkV I.restreindre_V2) ; -- tocheck
lin monarchy_N = mkN "monarchie" feminine ; -- tocheck
lin trunk_N = mkN "trompe" feminine | mkN "malle" | mkN "coffre" | mkN "tronc" ; -- tocheck
lin herd_N = mkN "troupeau" ; -- tocheck
lin deadline_N = variants{} ; -- 
lin tiger_N = mkN "tigre" masculine ; -- tocheck
lin supporting_A = variants{} ; -- 
lin moderate_A = mkA "modéré" ; -- tocheck
lin kneel_V = mkV (reflV (mkV "agenouiller")) ; -- tocheck
lin ego_N = mkN "moi" masculine ; -- tocheck
lin sexually_Adv = variants{} ; -- 
lin ministerial_A = variants{} ; -- 
lin bitch_N = mkN "chienne" | mkN "saleté" feminine | mkN "garce" feminine ; -- tocheck
lin wheat_N = mkN "blé" masculine ; -- tocheck
lin stagger_V = variants{}; -- mkV2 (mkV "quinconce") | mkV2 (mkV "chanceler") | mkV2 (mkV "tituber") ; -- tocheck
lin snake_N = L.snake_N ;
lin ribbon_N = mkN "ruban" masculine ; -- tocheck
lin mainland_N = mkN "continent" masculine ; -- tocheck
lin fisherman_N = mkN "pêcheur" masculine ; -- tocheck
lin economically_Adv = variants{} ; -- 
lin unwilling_A = variants{} ; -- 
lin nationalism_N = mkN "nationalisme" masculine ; -- tocheck
lin knitting_N = mkN "tricotage" masculine | mkN "tricot" masculine ; -- tocheck
lin irony_N = mkN "ironie" feminine ; -- tocheck
lin handling_N = mkN "manipulation" feminine ; -- tocheck
lin desired_A = variants{} ; -- 
lin bomber_N = mkN "bombardier" masculine | mkN "artilleur" masculine ; -- tocheck
lin voltage_N = mkN "tension" feminine ; -- tocheck
lin unusually_Adv = variants{} ; -- 
lin toast_N = mkN "toast" masculine ; -- tocheck
lin feel_N = variants{} ; -- 
lin suffering_N = mkN "souffrance" feminine ; -- tocheck
lin polish_V2 = mkV2 (mkV "polir") ; -- tocheck
lin polish_V = variants{}; -- mkV2 (mkV "polir") ; -- tocheck
lin technically_Adv = variants{} ; -- 
lin meaningful_A = variants{} ; -- 
lin aloud_Adv = variants{} ; -- 
lin waiter_N = mkN "serveur" masculine ; -- tocheck
lin tease_V2 = mkV2 (mkV "taquiner") ; -- tocheck
lin opposite_Adv = variants{} ; -- 
lin goat_N = mkN "chèvre" feminine ; -- tocheck
lin conceptual_A = mkA "conceptuel" ; -- tocheck
lin ant_N = mkN "fourmi" feminine ; -- tocheck
lin inflict_V2 = mkV2 (mkV "infliger") ; -- tocheck
lin bowler_N = variants{} ; -- 
lin roar_V2 = mkV2 (mkV "rugir") ; -- tocheck
lin roar_V = variants{}; -- mkV2 (mkV "rugir") ; -- tocheck
lin drain_N = mkN "drain" masculine | mkN "hémorragie" feminine ; -- tocheck
lin wrong_N = mkN "crime" masculine ; -- tocheck
lin galaxy_N = mkN "galaxie" feminine ; -- tocheck
lin aluminium_N = mkN "aluminium" masculine ; -- tocheck
lin receptor_N = variants{} ; -- 
lin preach_V2 = mkV2 (mkV "prêcher") ; -- tocheck
lin preach_V = variants{}; -- mkV2 (mkV "prêcher") ; -- tocheck
lin parade_N = mkN "défilé" masculine | mkN "parade" feminine ; -- tocheck
lin opposite_N = mkN "contraire" masculine | mkN "adversaire" ; -- tocheck
lin critique_N = mkN "critique" feminine ; -- tocheck
lin query_N = mkN "requête" feminine | mkN "question" feminine ; -- tocheck
lin outset_N = variants{} ; -- 
lin integral_A = mkA "intégral" ; -- tocheck
lin grammatical_A = mkA "grammatical" ; -- tocheck
lin testing_N = variants{} ; -- 
lin patrol_N = mkN "patrouille" | mkN "patrouille" feminine ; -- tocheck
lin pad_N = mkN "coussinet" masculine | mkN "bloc" | mkN "piaule" feminine | mkN "coussinet" | mkN "tampon" masculine | mkN "pieu" masculine ; -- tocheck
lin unreasonable_A = variants{} ; -- 
lin sausage_N = mkN "saucisson" masculine | mkN "saucisse" feminine ; -- tocheck
lin criminal_N = mkN "criminel" masculine ; -- tocheck
lin constructive_A = mkA "constructif" | mkA "implicite" ; -- tocheck
lin worldwide_A = mkA "mondial" ; -- tocheck
lin highlight_N = mkN "rehaut" masculine ; -- tocheck
lin doll_N = mkN "poupée" feminine ; -- tocheck
lin frightened_A = variants{} ; -- 
lin biography_N = mkN "biographie" feminine ; -- tocheck
lin vocabulary_N = mkN "vocabulaire" masculine | mkN "lexique" feminine ; -- tocheck
lin offend_V2 = mkV2 (mkV "offenser") ; -- tocheck
lin offend_V = variants{}; -- mkV2 (mkV "offenser") ; -- tocheck
lin accumulation_N = variants{} ; -- 
lin linen_N = mkN "toile" feminine ; -- tocheck
lin fairy_N = mkN "tapette" feminine | mkN "fée" feminine ; -- tocheck
lin disco_N = variants{} ; -- 
lin hint_VS = variants{} ; -- 
lin hint_V2 = variants{} ; -- 
lin hint_V = variants{} ; -- 
lin versus_Prep = variants{} ; -- 
lin ray_N = mkN "rayon" masculine | mkN "raie" feminine ; -- tocheck
lin pottery_N = mkN "poterie" feminine | mkN "poterie" ; -- tocheck
lin immune_A = variants{} ; -- 
lin retreat_N = mkN "retraite" feminine ; -- tocheck
lin master_V2 = mkV2 "maîtriser" ;
lin injured_A = variants{} ; -- 
lin holly_N = mkN "houx" masculine ; -- tocheck
lin battle_V2 = mkV2 (mkV "lutter") ; -- tocheck
lin battle_V = variants{}; -- mkV2 (mkV "lutter") ; -- tocheck
lin solidarity_N = mkN "solidarité" | mkN "solidarité" feminine ; -- tocheck
lin embarrassing_A = mkA "embarrassant" ; -- tocheck
lin cargo_N = mkN "cargaison" feminine ; -- tocheck
lin theorist_N = mkN "théoricien" masculine ; -- tocheck
lin reluctantly_Adv = variants{} ; -- 
lin preferred_A = variants{} ; -- 
lin dash_V = variants{}; -- mkV2 (reflV (mkV "précipiter")) ; -- tocheck
lin total_V2 = mkV2 (mkV "totaliser") ; -- tocheck
lin total_V = variants{}; -- mkV2 (mkV "totaliser") ; -- tocheck
lin reconcile_V2 = mkV2 (mkV "réconcilier") ; -- tocheck
lin drill_N = mkN "coutil" masculine | mkN "chignole" feminine | mkN "exercice" masculine | mkN "drill" masculine | mkN "foreuse" feminine ; -- tocheck
lin credibility_N = mkN "crédibilité" feminine ; -- tocheck
lin copyright_N = variants{} ; -- 
lin beard_N = mkN "barbe" feminine ; -- tocheck
lin bang_N = mkN "détonation" feminine ; -- tocheck
lin vigorous_A = variants{} ; -- 
lin vaguely_Adv = variants{} ; -- 
lin punch_V2 = mkV2 (mkV "poinçonner") ; -- tocheck
lin prevalence_N = mkN "prédominance" feminine ; -- tocheck
lin uneasy_A = variants{} ; -- 
lin boost_N = variants{} ; -- 
lin scrap_N = mkN "ferraille" feminine | mkN "restes" | mkN "bribe" feminine ; -- tocheck
lin ironically_Adv = variants{} ; -- 
lin fog_N = L.fog_N ;
lin faithful_A = mkA "fidèle" ; -- tocheck
lin bounce_V2 = mkV2 (mkV "rebondir") ; -- tocheck
lin bounce_V = variants{}; -- mkV2 (mkV "rebondir") ; -- tocheck
lin batch_N = mkN "fournée" feminine | mkN "lot" masculine ; -- tocheck
lin smooth_V2 = mkV2 (mkV "lisser") ; -- tocheck
lin smooth_V = variants{}; -- mkV2 (mkV "lisser") ; -- tocheck
lin sleeping_A = variants{} ; -- 
lin poorly_Adv = variants{} ; -- 
lin accord_V = variants{}; -- mkV2 (mkV "accorder") ; -- tocheck
lin vice_president_N = variants{} ; -- 
lin duly_Adv = variants{} ; -- 
lin blast_N = mkN "rafale" feminine | mkN "bourrasque" ; -- tocheck
lin square_V2 = variants{} ; -- 
lin square_V = variants{} ; -- 
lin prohibit_V2 = mkV2 (mkV I.interdire_V2) ; -- tocheck
lin prohibit_V = variants{}; -- mkV2 (mkV I.interdire_V2) ; -- tocheck
lin brake_N = mkN "frein" masculine ; -- tocheck
lin asylum_N = mkN "asile" masculine ; -- tocheck
lin obscure_V2 = mkV2 (mkV "obscurcir") ; -- tocheck
lin nun_N = mkN "nonne" feminine ; -- tocheck
lin heap_N = mkN "tas" masculine ; -- tocheck
lin smoothly_Adv = variants{} ; -- 
lin rhetoric_N = mkN "rhétorique" feminine ; -- tocheck
lin privileged_A = mkA "privilégié" ; -- tocheck
lin liaison_N = variants{} ; -- 
lin jockey_N = mkN "jockey" masculine ; -- tocheck
lin concrete_N = mkN "béton" masculine ; -- tocheck
lin allied_A = variants{} ; -- 
lin rob_V2 = mkV2 (mkV "voler") | mkV2 (mkV "cambrioler") ; -- tocheck
lin indulge_V2 = mkV2 (mkV "céder") | mkV2 (mkV "dorloter") ; -- tocheck
lin indulge_V = variants{}; -- mkV2 (mkV "céder") | mkV2 (mkV "dorloter") ; -- tocheck
lin except_Prep = S.except_Prep ;
lin distort_V2 = mkV2 (mkV "déformer") ; -- tocheck
lin whatsoever_Adv = variants{} ; -- 
lin viable_A = mkA "viable" ; -- tocheck
lin nucleus_N = mkN "noyau" masculine | mkN "noyau" ; -- tocheck
lin exaggerate_V2 = mkV2 (mkV "exagérer") ; -- tocheck
lin exaggerate_V = variants{}; -- mkV2 (mkV "exagérer") ; -- tocheck
lin compact_N = variants{} ; -- 
lin nationality_N = mkN "nationalité" feminine ; -- tocheck
lin direct_Adv = variants{} ; -- 
lin cast_N = mkN "plâtre" ; -- tocheck
lin altar_N = mkN "autel" ; -- tocheck
lin refuge_N = mkN "refuge" masculine ; -- tocheck
lin presently_Adv = variants{} ; -- 
lin mandatory_A = mkA "obligatoire" ; -- tocheck
lin authorize_V2V = mkV2V (mkV "autoriser") ; -- tocheck
lin authorize_V2 = variants{}; -- mkV2V (mkV "autoriser") ; -- tocheck
lin accomplish_V2 = mkV2 (mkV "accomplir") ; -- tocheck
lin startle_V2 = mkV2 (mkV I.surprendre_V2) | mkV2 (mkV "sursauter") ; -- tocheck
lin indigenous_A = mkA "inné" | mkA "indigène" ; -- tocheck
lin worse_Adv = variants{} ; -- 
lin retailer_N = mkN "revendeur" masculine ; -- tocheck
lin compound_V2 = mkV2 (mkV "composer") ; -- tocheck
lin compound_V = variants{}; -- mkV2 (mkV "composer") ; -- tocheck
lin admiration_N = mkN "admiration" feminine ; -- tocheck
lin absurd_A = mkA "absurde" ; -- tocheck
lin coincidence_N = mkN "coïncidence" feminine ; -- tocheck
lin principally_Adv = variants{} ; -- 
lin passport_N = mkN "passeport" masculine ; -- tocheck
lin depot_N = mkN "dépôt" ; -- tocheck
lin soften_V2 = variants{} ; -- 
lin soften_V = variants{} ; -- 
lin secretion_N = mkN "sécrétion" feminine ; -- tocheck
lin invoke_V2 = mkV2 (mkV "invoquer") ; -- tocheck
lin dirt_N = mkN "terre" feminine | mkN "salissure" feminine ; -- tocheck
lin scared_A = variants{} ; -- 
lin mug_N = mkN "couillon" masculine | mkN "mug" masculine | mkN "gueule" feminine ; -- tocheck
lin convenience_N = mkN "commodité" feminine ; -- tocheck
lin calm_N = variants{} ; -- 
lin optional_A = mkA "optionnel" ; -- tocheck
lin unsuccessful_A = mkA "infructueux" ; -- tocheck
lin consistency_N = mkN "consistance" feminine ; -- tocheck
lin umbrella_N = mkN "parapluie" masculine | mkN "ombrelle" feminine ; -- tocheck
lin solo_N = mkN "solo" masculine ; -- tocheck
lin hemisphere_N = mkN "hémisphère" feminine | mkN "hémisphère" masculine ; -- tocheck
lin extreme_N = mkN "extrême" masculine ; -- tocheck
lin brandy_N = mkN "cognac" masculine ; -- tocheck
lin belly_N = L.belly_N ;
lin attachment_N = variants{} ; -- 
lin wash_N = mkN "machine" feminine | mkN "lavage" masculine | mkN "oeud" ; -- tocheck
lin uncover_V2 = variants{} ; -- 
lin treat_N = variants{} ; -- 
lin repeated_A = variants{} ; -- 
lin pine_N = mkN "pin" masculine ; -- tocheck
lin offspring_N = mkN "descendance" | mkN "enfant" | mkN "progéniture" feminine | mkN "enfance" ; -- tocheck
lin communism_N = mkN "communisme" masculine | mkN "communisme" ; -- tocheck
lin nominate_V2 = variants{} ; -- 
lin soar_V2 = mkV2 (mkV "planer") | mkV2 (mkV "monter") ; -- tocheck
lin soar_V = variants{}; -- mkV2 (mkV "planer") | mkV2 (mkV "monter") ; -- tocheck
lin geological_A = variants{} ; -- 
lin frog_N = mkN "talon" masculine | mkN "grenouille" feminine ; -- tocheck
lin donate_V2 = mkV2 (mkV "donner") ; -- tocheck
lin donate_V = variants{}; -- mkV2 (mkV "donner") ; -- tocheck
lin cooperative_A = variants{} ; -- 
lin nicely_Adv = variants{} ; -- 
lin innocence_N = mkN "innocence" feminine ; -- tocheck
lin housewife_N = variants{} ; -- 
lin disguise_V2 = mkV2 (mkV "déguiser") ; -- tocheck
lin demolish_V2 = mkV2 (mkV "démolir") ; -- tocheck
lin counsel_N = mkN "conseil" ; -- tocheck
lin cord_N = mkN "corde" feminine ; -- tocheck
lin semi_final_N = variants{} ; -- 
lin reasoning_N = mkN "raisonnement" masculine ; -- tocheck
lin litre_N = mkN "litre" masculine ; -- tocheck
lin inclined_A = variants{} ; -- 
lin evoke_V2 = variants{} ; -- 
lin courtyard_N = mkN "cour" feminine ; -- tocheck
lin arena_N = mkN "arène" ; -- tocheck
lin simplicity_N = mkN "simplicité" ; -- tocheck
lin inhibition_N = mkN "inhibition" feminine ; -- tocheck
lin frozen_A = variants{} ; -- 
lin vacuum_N = mkN "vide" masculine ; -- tocheck
lin immigrant_N = mkN "immigrant" masculine ; -- tocheck
lin bet_N = mkN "pari" ; -- tocheck
lin revenge_N = mkN "vengeance" feminine ; -- tocheck
lin jail_V2 = variants{} ; -- 
lin helmet_N = mkN "casque" masculine ; -- tocheck
lin unclear_A = mkA "flou" ; -- tocheck
lin jerk_V2 = variants{} ; -- 
lin jerk_V = variants{} ; -- 
lin disruption_N = mkN "interruption" feminine ; -- tocheck
lin attainment_N = variants{} ; -- 
lin sip_V2 = mkV2 (mkV "siroter") ; -- tocheck
lin sip_V = variants{}; -- mkV2 (mkV "siroter") ; -- tocheck
lin program_V2V = mkV2V (mkV "programmer") ; -- tocheck
lin program_V2 = variants{}; -- mkV2V (mkV "programmer") ; -- tocheck
lin lunchtime_N = variants{} ; -- 
lin cult_N = mkN "culte" masculine | mkN "secte" feminine ; -- tocheck
lin chat_N = variants{} ; -- 
lin accord_N = mkN "entente" feminine ; -- tocheck
lin supposedly_Adv = variants{} ; -- 
lin offering_N = mkN "offre" feminine | mkN "offrande" feminine ; -- tocheck
lin broadcast_N = mkN "émission" feminine ; -- tocheck
lin secular_A = mkA "séculaire" | mkA "profane" | mkA "séculier" ; -- tocheck
lin overwhelm_V2 = mkV2 (mkV "accabler") ; -- tocheck
lin momentum_N = mkN "élan" ; -- tocheck
lin infinite_A = mkA "infini" ; -- tocheck
lin manipulation_N = variants{} ; -- 
lin inquest_N = variants{} ; -- 
lin decrease_N = variants{} ; -- 
lin cellar_N = mkN "cellier" masculine ; -- tocheck
lin counsellor_N = mkN "conseiller" masculine;
lin avenue_N = mkN "avenue" feminine ; -- tocheck
lin rubber_A = variants{} ; -- 
lin labourer_N = variants{} ; -- 
lin lab_N = variants{} ; -- 
lin damn_V2 = mkV2 (mkV "damner") ; -- tocheck
lin comfortably_Adv = variants{} ; -- 
lin tense_A = mkA "tendu" ; -- tocheck
lin socket_N = mkN "socket" feminine | mkN "orbite" | mkN "prise" ; -- tocheck
lin par_N = variants{} ; -- 
lin thrust_N = mkN "poussée" | mkN "estocade" feminine ; -- tocheck
lin scenario_N = mkN "scénario" masculine ; -- tocheck
lin frankly_Adv = variants{} ; -- 
lin slap_V2 = variants{} ; -- 
lin recreation_N = mkN "récréation" feminine ; -- tocheck
lin rank_V2 = mkV2 (mkV "coter") | mkV2 (mkV "ranger") | mkV2 (mkV "classer") ; -- tocheck
lin rank_V = variants{}; -- mkV2 (mkV "coter") | mkV2 (mkV "ranger") | mkV2 (mkV "classer") ; -- tocheck
lin spy_N = mkN "espion" masculine ; -- tocheck
lin filter_V2 = mkV2 (mkV "filtrer") ; -- tocheck
lin filter_V = variants{}; -- mkV2 (mkV "filtrer") ; -- tocheck
lin clearance_N = mkN "braderie" feminine ; -- tocheck
lin blessing_N = mkN "bénédiction" feminine | mkN "troupeau" masculine ; -- tocheck
lin embryo_N = mkN "embryon" masculine ; -- tocheck
lin varied_A = variants{} ; -- 
lin predictable_A = mkA "prédictible" ; -- tocheck
lin mutation_N = mkN "mutation" feminine ; -- tocheck
lin equal_V2 = variants{} ; -- 
lin can_1_VV = S.can_VV ;
lin can_2_VV = S.can8know_VV ;
lin can_V2 = mkV2 (mkV I.pouvoir_V) | mkV2 (mkV "jeter") | mkV2 (mkV "conserver") | mkV2 (reflV (mkV I.taire_V2)) ; -- tocheck
lin burst_N = variants{} ; -- 
lin retrieve_V2 = variants{} ; -- 
lin retrieve_V = variants{} ; -- 
lin elder_N = mkN "sureau" masculine ; -- tocheck
lin rehearsal_N = mkN "répétition" feminine ; -- tocheck
lin optical_A = mkA "optique" ; -- tocheck
lin hurry_N = mkN "précipitation" feminine ; -- tocheck
lin conflict_V = variants{} ; -- 
lin combat_V2 = mkV2 (mkV I.combattre_V2) ; -- tocheck
lin combat_V = variants{}; -- mkV2 (mkV I.combattre_V2) ; -- tocheck
lin absorption_N = mkN "absorption" feminine ; -- tocheck
lin ion_N = mkN "ion" masculine ; -- tocheck
lin wrong_Adv = variants{} ; -- 
lin heroin_N = mkN "héroïne" feminine ; -- tocheck
lin bake_V2 = variants{} ; -- 
lin bake_V = variants{} ; -- 
lin x_ray_N = variants{} ; -- 
lin vector_N = mkN "vecteur" masculine ; -- tocheck
lin stolen_A = variants{} ; -- 
lin sacrifice_V2 = mkV2 (mkV "sacrifier") ; -- tocheck
lin sacrifice_V = variants{}; -- mkV2 (mkV "sacrifier") ; -- tocheck
lin robbery_N = mkN "banditisme" masculine | mkN "brigandage" masculine ; -- tocheck
lin probe_V2 = variants{} ; -- 
lin probe_V = variants{} ; -- 
lin organizational_A = variants{} ; -- 
lin chalk_N = mkN "craie" feminine | mkN "magnésie" feminine ; -- tocheck
lin bourgeois_A = mkA "bourgeois" ; -- tocheck
lin villager_N = mkN "villageois" masculine ; -- tocheck
lin morale_N = mkN "enthousiasme" masculine ; -- tocheck
lin express_A = variants{} ; -- 
lin climb_N = variants{} ; -- 
lin notify_V2 = mkV2 (mkV "notifier") ; -- tocheck
lin jam_N = mkN "embouteillage" masculine | mkN "confiture" feminine | mkN "boeuf" masculine ; -- tocheck
lin bureaucratic_A = variants{} ; -- 
lin literacy_N = mkN "littératie" ; -- tocheck
lin frustrate_V2 = variants{} ; -- 
lin freight_N = mkN "cargo" masculine | mkN "fret" ; -- tocheck
lin clearing_N = mkN "clairière" ; -- tocheck
lin aviation_N = mkN "aviation" feminine ; -- tocheck
lin legislature_N = variants{} ; -- 
lin curiously_Adv = variants{} ; -- 
lin banana_N = mkN "banane" feminine | mkN "bananier" masculine ; -- tocheck
lin deploy_V2 = variants{} ; -- 
lin deploy_V = variants{} ; -- 
lin passionate_A = mkA "passionné" ; -- tocheck
lin monastery_N = mkN "monastère" ; -- tocheck
lin kettle_N = mkN "bouilloire" feminine ; -- tocheck
lin enjoyable_A = variants{} ; -- 
lin diagnose_V2 = mkV2 (mkV "diagnostiquer") ; -- tocheck
lin quantitative_A = variants{} ; -- 
lin distortion_N = mkN "corruption" feminine ; -- tocheck
lin monarch_N = mkN "monarque" masculine ; -- tocheck
lin kindly_Adv = variants{} ; -- 
lin glow_V = mkV (mkV "briller") ; -- tocheck
lin acquaintance_N = mkN "relation" feminine | mkN "fréquentation" feminine ; -- tocheck
lin unexpectedly_Adv = variants{} ; -- 
lin handy_A = mkA "pratique" | mkA "maniable" ; -- tocheck
lin deprivation_N = variants{} ; -- 
lin attacker_N = mkN "attaquant" ; -- tocheck
lin assault_V2 = mkV2 (mkV "attaquer") ; -- tocheck
lin screening_N = mkN "protection" feminine | mkN "projection" feminine ; -- tocheck
lin retired_A = variants{} ; -- 
lin quick_Adv = variants{} ; -- 
lin portable_A = mkA "portable" ; -- tocheck
lin hostage_N = mkN "otage" masculine ; -- tocheck
lin underneath_Prep = variants{} ; -- 
lin jealous_A = mkA "jaloux" ; -- tocheck
lin proportional_A = mkA "proportionnel" ; -- tocheck
lin gown_N = mkN "robe" feminine | mkN "toge" ; -- tocheck
lin chimney_N = mkN "cheminée" feminine ; -- tocheck
lin bleak_A = variants{} ; -- 
lin seasonal_A = mkA "saisonnier" ; -- tocheck
lin plasma_N = variants{} ; -- 
lin stunning_A = variants{} ; -- 
lin spray_N = mkN "embrun" masculine | mkN "rameau" masculine ; -- tocheck
lin referral_N = variants{} ; -- 
lin promptly_Adv = variants{} ; -- 
lin fluctuation_N = mkN "fluctuation" feminine ; -- tocheck
lin decorative_A = variants{} ; -- 
lin unrest_N = mkN "agitation" ; -- tocheck
lin resent_VS = variants{} ; -- 
lin resent_V2 = variants{} ; -- 
lin plaster_N = mkN "plâtre" masculine | mkN "onguent" masculine ; -- tocheck
lin chew_V2 = mkV2 (mkV "mâcher") ; -- tocheck
lin chew_V = variants{}; -- mkV2 (mkV "mâcher") ; -- tocheck
lin grouping_N = variants{} ; -- 
lin gospel_N = mkN "évangile" feminine ; -- tocheck
lin distributor_N = variants{} ; -- 
lin differentiation_N = mkN "différentiation" feminine | mkN "différenciation" ; -- tocheck
lin blonde_A = variants{} ; -- 
lin aquarium_N = mkN "aquarium" masculine ; -- tocheck
lin witch_N = mkN "sorcière" feminine ; -- tocheck
lin renewed_A = variants{} ; -- 
lin jar_N = mkN "pot" ; -- tocheck
lin approved_A = variants{} ; -- 
lin advocateMasc_N = mkN "avocat" masculine ;
lin worrying_A = variants{} ; -- 
lin minimize_V2 = mkV2 (mkV I.réduire_V2) | mkV2 (mkV "minimiser") ; -- tocheck
lin footstep_N = mkN "pas" masculine ; -- tocheck
lin delete_V2 = mkV2 (mkV "supprimer") ; -- tocheck
lin underneath_Adv = mkAdv "dessous" ; -- tocheck
lin lone_A = mkA "seul" | mkA "isolé" | mkA "unique" ; -- tocheck
lin level_V2 = mkV2 (mkV "niveler") ; -- tocheck
lin level_V = variants{}; -- mkV2 (mkV "niveler") ; -- tocheck
lin exceptionally_Adv = variants{} ; -- 
lin drift_N = mkN "dérive" feminine ; -- tocheck
lin spider_N = mkN "araignée" feminine ; -- tocheck
lin hectare_N = mkN "hectare" masculine ; -- tocheck
lin colonel_N = mkN "colonel" masculine ; -- tocheck
lin swimming_N = mkN "natation" feminine ; -- tocheck
lin realism_N = mkN "réalisme" masculine ; -- tocheck
lin insider_N = mkN "initié" masculine ; -- tocheck
lin hobby_N = mkN "passe-temps" masculine | mkN "hobereau" masculine ; -- tocheck
lin computing_N = variants{} ; -- 
lin infrastructure_N = mkN "infrastructure" feminine ; -- tocheck
lin cooperate_V = mkV (mkV "coopérer") ; -- tocheck
lin burn_N = mkN "brûlure" feminine ; -- tocheck
lin cereal_N = mkN "céréale" feminine ; -- tocheck
lin fold_N = mkN "pliage" | mkN "pli" | mkN "bercail" ; -- tocheck
lin compromise_V2 = mkV2 (mkV I.compromettre_V2) ; -- tocheck
lin compromise_V = variants{}; -- mkV2 (mkV I.compromettre_V2) ; -- tocheck
lin boxing_N = mkN "boxe" feminine ; -- tocheck
lin rear_V2 = mkV2 (mkV "élever") | mkV2 (mkV "ériger") ; -- tocheck
lin rear_V = variants{}; -- mkV2 (mkV "élever") | mkV2 (mkV "ériger") ; -- tocheck
lin lick_V2 = mkV2 (mkV I.défaire_V2) | mkV2 (mkV "lécher") ; -- tocheck
lin constrain_V2 = mkV2 (mkV I.astreindre_V2) ; -- tocheck
lin clerical_A = mkA "clérical" ; -- tocheck
lin hire_N = variants{} ; -- 
lin contend_VS = variants{} ; -- 
lin contend_V = variants{} ; -- 
lin amateurMasc_N = mkN "amateur" masculine ;
lin instrumental_A = mkA "instrumental" ; -- tocheck
lin terminal_A = variants{} ; -- 
lin electorate_N = mkN "électorat" masculine ; -- tocheck
lin congratulate_V2 = mkV2 (mkV "féliciter") ; -- tocheck
lin balanced_A = variants{} ; -- 
lin manufacturing_N = variants{} ; -- 
lin split_N = variants{} ; -- 
lin domination_N = mkN "domination" feminine ; -- tocheck
lin blink_V2 = mkV2 (mkV "ciller") | mkV2 (mkV "clignoter") ; -- tocheck
lin blink_V = variants{}; -- mkV2 (mkV "ciller") | mkV2 (mkV "clignoter") ; -- tocheck
lin bleed_VS = variants{}; -- mkV2 (mkV "saigner") ; -- tocheck
lin bleed_V2 = mkV2 (mkV "saigner") ; -- tocheck
lin bleed_V = variants{}; -- mkV2 (mkV "saigner") ; -- tocheck
lin unlawful_A = mkA "illégal" ; -- tocheck
lin precedent_N = mkN "précédent" | mkN "jurisprudence" ; -- tocheck
lin notorious_A = mkA "notoire" ; -- tocheck
lin indoor_A = mkA "intérieur" ; -- tocheck
lin upgrade_V2 = variants{} ; -- 
lin trench_N = mkN "tranchée" ; -- tocheck
lin therapist_N = mkN "thérapeute" ; -- tocheck
lin illuminate_V2 = mkV2 (mkV "illuminer") ; -- tocheck
lin bargain_V2 = variants{} ; -- 
lin bargain_V = variants{} ; -- 
lin warranty_N = mkN "garantie" feminine ; -- tocheck
lin scar_V2 = mkV2 (mkV "cicatriser") ; -- tocheck
lin scar_V = variants{}; -- mkV2 (mkV "cicatriser") ; -- tocheck
lin consortium_N = mkN "consortium" masculine ; -- tocheck
lin anger_V2 = variants{} ; -- 
lin insure_VS = variants{}; -- mkV2 (mkV "assurer") ; -- tocheck
lin insure_V2 = mkV2 (mkV "assurer") ; -- tocheck
lin insure_V = variants{}; -- mkV2 (mkV "assurer") ; -- tocheck
lin extensively_Adv = variants{} ; -- 
lin appropriately_Adv = variants{} ; -- 
lin spoon_N = mkN "cuiller" feminine ; -- tocheck
lin sideways_Adv = variants{} ; -- 
lin enhanced_A = variants{} ; -- 
lin disrupt_V2 = mkV2 (mkV "perturber") | mkV2 (mkV I.interrompre_V2) ; -- tocheck
lin disrupt_V = variants{}; -- mkV2 (mkV "perturber") | mkV2 (mkV I.interrompre_V2) ; -- tocheck
lin satisfied_A = variants{} ; -- 
lin precaution_N = mkN "précaution" feminine ; -- tocheck
lin kite_N = mkN "cerf-volant" masculine | mkN "milan" masculine ; -- tocheck
lin instant_N = mkN "instant" masculine ; -- tocheck
lin gig_N = mkN "concert" masculine ; -- tocheck
lin continuously_Adv = variants{} ; -- 
lin consolidate_V2 = mkV2 (mkV "consolider") ; -- tocheck
lin consolidate_V = variants{}; -- mkV2 (mkV "consolider") ; -- tocheck
lin fountain_N = mkN "fontaine" feminine ; -- tocheck
lin graduate_V2 = mkV2 (mkV "diplômer") ; -- tocheck
lin graduate_V = variants{}; -- mkV2 (mkV "diplômer") ; -- tocheck
lin gloom_N = mkN "morosité" feminine | mkN "obscurité" feminine ; -- tocheck
lin bite_N = mkN "morsure" feminine | mkN "bouchée" feminine | mkN "piqûre" feminine ; -- tocheck
lin structure_V2 = variants{} ; -- 
lin noun_N = mkN "nom" masculine ; -- tocheck
lin nomination_N = variants{} ; -- 
lin armchair_N = mkN "fauteuil" ; -- tocheck
lin virtual_A = mkA "virtuel" ; -- tocheck
lin unprecedented_A = variants{} ; -- 
lin tumble_V2 = mkV2 (mkV "dégringoler") ; -- tocheck
lin tumble_V = variants{}; -- mkV2 (mkV "dégringoler") ; -- tocheck
lin ski_N = mkN "ski" masculine ; -- tocheck
lin architectural_A = variants{} ; -- 
lin violation_N = mkN "infraction" feminine ; -- tocheck
lin rocket_N = mkN "roquette" feminine | mkN "fusée" feminine ; -- tocheck
lin inject_V2 = mkV2 (mkV "injecter") ; -- tocheck
lin departmental_A = mkA "départemental" ; -- tocheck
lin row_V2 = mkV2 (mkV "ramer") ; -- tocheck
lin row_V = variants{}; -- mkV2 (mkV "ramer") ; -- tocheck
lin luxury_A = variants{} ; -- 
lin fax_N = variants{} ; -- 
lin deer_N = mkN "cerf" masculine ; -- tocheck
lin climber_N = mkN "grimpeur" masculine ; -- tocheck
lin photographic_A = variants{} ; -- 
lin haunt_V2 = mkV2 (mkV "hanter") | mkV2 (mkV "habiter") | mkV2 (mkV "effrayer") | mkV2 (mkV I.poursuivre_V2) ; -- tocheck
lin fiercely_Adv = variants{} ; -- 
lin dining_N = variants{} ; -- 
lin sodium_N = mkN "sodium" masculine ; -- tocheck
lin gossip_N = mkN "commérage" | mkN "commère" feminine ; -- tocheck
lin bundle_N = variants{} ; -- 
lin bend_N = variants{} ; -- 
lin recruit_N = mkN "recrue" feminine ; -- tocheck
lin hen_N = mkN "poule" feminine ; -- tocheck
lin fragile_A = mkA "fragile" ; -- tocheck
lin deteriorate_V2 = mkV2 (mkV "détériorer") ; -- tocheck
lin deteriorate_V = variants{}; -- mkV2 (mkV "détériorer") ; -- tocheck
lin dependency_N = mkN "dépendance" feminine ; -- tocheck
lin swift_A = mkA "rapide" ; -- tocheck
lin scramble_V2 = variants{}; -- mkV2V (reflV (mkV "ruer")) | mkV2V (mkV "brouiller") ; -- tocheck
lin scramble_V = variants{}; -- mkV2V (reflV (mkV "ruer")) | mkV2V (mkV "brouiller") ; -- tocheck
lin overview_N = variants{} ; -- 
lin imprison_V2 = mkV2 (mkV "emprisonner") ; -- tocheck
lin trolley_N = mkN "charriot" masculine ; -- tocheck
lin rotation_N = mkN "tour" masculine | mkN "rotation" feminine ; -- tocheck
lin denial_N = mkN "négation" feminine | mkN "déni" masculine | mkN "refus" masculine ; -- tocheck
lin boiler_N = mkN "chaudière" feminine ; -- tocheck
lin amp_N = variants{} ; -- 
lin trivial_A = mkA "banal" | mkA "trivial" ; -- tocheck
lin shout_N = mkN "cri" masculine ; -- tocheck
lin overtake_V2 = mkV2 (mkV "dépasser") ; -- tocheck
lin make_N = mkN "marque" feminine ; -- tocheck
lin hunter_N = mkN "chasseur" masculine | mkN "chercheur" masculine ; -- tocheck
lin guess_N = mkN "conjecture" feminine ; -- tocheck
lin doubtless_Adv = variants{} ; -- 
lin syllable_N = mkN "syllabe" feminine ; -- tocheck
lin obscure_A = mkA "sibyllin" | mkA "obscur" ; -- tocheck
lin mould_N = variants{} ; -- 
lin limestone_N = mkN "calcaire" ; -- tocheck
lin leak_V2 = mkV2 (mkV I.fuir_V2) ; -- tocheck
lin leak_V = variants{}; -- mkV2 (mkV I.fuir_V2) ; -- tocheck
lin beneficiary_N = mkN "bénéficiaire" masculine ; -- tocheck
lin veteran_N = mkN "vétéran" masculine ; -- tocheck
lin surplus_A = variants{} ; -- 
lin manifestation_N = mkN "manifestation" feminine ; -- tocheck
lin vicar_N = mkN "vicaire" masculine ; -- tocheck
lin textbook_N = mkN "manuel" masculine ; -- tocheck
lin novelist_N = mkN "romancier" masculine ; -- tocheck
lin halfway_Adv = variants{} ; -- 
lin contractual_A = variants{} ; -- 
lin swap_V2 = mkV2 (mkV "échanger") ; -- tocheck
lin swap_V = variants{}; -- mkV2 (mkV "échanger") ; -- tocheck
lin guild_N = mkN "guilde" ; -- tocheck
lin ulcer_N = mkN "ulcère" masculine ; -- tocheck
lin slab_N = mkN "dalle" feminine | mkN "chape" feminine ; -- tocheck
lin detector_N = mkN "détecteur" masculine ; -- tocheck
lin detection_N = variants{} ; -- 
lin cough_V = variants{}; -- mkV2 (mkV "tousser") ; -- tocheck
lin whichever_Quant = variants{} ; -- 
lin spelling_N = mkN "orthographe" feminine ; -- tocheck
lin lender_N = mkN "prêteur" masculine ; -- tocheck
lin glow_N = variants{} ; -- 
lin raised_A = variants{} ; -- 
lin prolonged_A = variants{} ; -- 
lin voucher_N = mkN "coupon" | mkN "récépissé" masculine ; -- tocheck
lin t_shirt_N = variants{} ; -- 
lin linger_V = mkV (reflV (mkV "attarder")) ; -- tocheck
lin humble_A = mkA "humble" ; -- tocheck
lin honey_N = mkN "miel" masculine | mkN "chéri" masculine ; -- tocheck
lin scream_N = mkN "cri" masculine ; -- tocheck
lin postcard_N = variants{} ; -- 
lin managing_A = variants{} ; -- 
lin alien_A = mkA "étranger" ; -- tocheck
lin trouble_V2 = mkV2 (mkV "troubler") ; -- tocheck
lin reverse_N = mkN "contraire" ; -- tocheck
lin odour_N = mkN "odeur" feminine ; -- tocheck
lin fundamentally_Adv = variants{} ; -- 
lin discount_V2 = variants{} ; -- 
lin discount_V = variants{} ; -- 
lin blast_V2 = variants{} ; -- 
lin blast_V = variants{} ; -- 
lin syntactic_A = mkA "syntaxique" ; -- tocheck
lin scrape_V2 = mkV2 (mkV "gratter") ; -- tocheck
lin scrape_V = variants{}; -- mkV2 (mkV "gratter") ; -- tocheck
lin residue_N = variants{} ; -- 
lin procession_N = mkN "procession" feminine ; -- tocheck
lin pioneer_N = mkN "pionnier" masculine ; -- tocheck
lin intercourse_N = variants{} ; -- 
lin deter_V2 = mkV2 (mkV "empêcher") | mkV2 (mkV "dissuader") ; -- tocheck
lin deadly_A = mkA "mortel" ; -- tocheck
lin complement_V2 = mkV2 (mkV "compléter") | mkV2 (mkV "complémenter") ; -- tocheck
lin restrictive_A = mkA "restrictif" ; -- tocheck
lin nitrogen_N = mkN "azote" masculine ; -- tocheck
lin citizenship_N = mkN "citoyenneté" feminine ; -- tocheck
lin pedestrian_N = mkN "piéton" masculine ; -- tocheck
lin detention_N = mkN "détention" feminine ; -- tocheck
lin wagon_N = mkN "charrette" feminine ; -- tocheck
lin microphone_N = mkN "microphone" masculine ; -- tocheck
lin hastily_Adv = variants{} ; -- 
lin fixture_N = variants{} ; -- 
lin choke_V2 = mkV2 (mkV "étouffer") | mkV2 (mkV "suffoquer") ; -- tocheck
lin choke_V = variants{}; -- mkV2 (mkV "étouffer") | mkV2 (mkV "suffoquer") ; -- tocheck
lin wet_V2 = mkV2 (reflV (mkV "mouiller")) | mkV2 (mkV "mouiller") ; -- tocheck
lin weed_N = mkN "herbe" ; -- tocheck
lin programming_N = mkN "programmation" ; -- tocheck
lin power_V2 = variants{} ; -- 
lin nationally_Adv = variants{} ; -- 
lin dozen_N = mkN "dizaine" | mkN "douzaine" feminine ; -- tocheck
lin carrot_N = mkN "carotte" feminine ; -- tocheck
lin bulletin_N = mkN "bulletin" masculine ; -- tocheck
lin wording_N = mkN "formulation" feminine ; -- tocheck
lin vicious_A = variants{} ; -- 
lin urgency_N = mkN "urgence" feminine ; -- tocheck
lin spoken_A = variants{} ; -- 
lin skeleton_N = mkN "squelette" masculine ; -- tocheck
lin motorist_N = variants{} ; -- 
lin interactive_A = variants{} ; -- 
lin compute_V2 = mkV2 (mkV "computer") ; -- tocheck
lin compute_V = variants{}; -- mkV2 (mkV "computer") ; -- tocheck
lin whip_N = mkN "fouet" masculine ; -- tocheck
lin urgently_Adv = variants{} ; -- 
lin telly_N = mkN "télé" feminine ; -- tocheck
lin shrub_N = mkN "arbrisseau" masculine ; -- tocheck
lin porter_N = mkN "porteur" masculine | mkN "porter" masculine ; -- tocheck
lin ethics_N = mkN "éthique" feminine ; -- tocheck
lin banner_N = mkN "bannière" feminine | mkN "banderole" feminine | mkN "banière" feminine ; -- tocheck
lin velvet_N = mkN "velours" masculine ; -- tocheck
lin omission_N = mkN "omission" feminine ; -- tocheck
lin hook_V2 = mkV2 (mkV "accrocher") ; -- tocheck
lin hook_V = variants{}; -- mkV2 (mkV "accrocher") ; -- tocheck
lin gallon_N = mkN "gallon" ; -- tocheck
lin financially_Adv = variants{} ; -- 
lin superintendent_N = mkN "surintendant" masculine ; -- tocheck
lin plug_V2 = mkV2 (mkV "boucher") ; -- tocheck
lin plug_V = variants{}; -- mkV2 (mkV "boucher") ; -- tocheck
lin continuation_N = mkN "continuation" feminine ; -- tocheck
lin reliance_N = variants{} ; -- 
lin justified_A = variants{} ; -- 
lin fool_V2 = mkV2 (mkV "duper") ; -- tocheck
lin detain_V2 = mkV2 (mkV I.détenir_V2) ; -- tocheck
lin damaging_A = variants{} ; -- 
lin orbit_N = mkN "orbite" feminine ; -- tocheck
lin mains_N = variants{} ; -- 
lin discard_V2 = mkV2 (mkV "rejeter") ; -- tocheck
lin dine_V = variants{}; -- mkV2 (mkV "dîner") ; -- tocheck
lin compartment_N = mkN "compartiment" masculine ; -- tocheck
lin revised_A = variants{} ; -- 
lin privatization_N = mkN "privatisation" feminine ; -- tocheck
lin memorable_A = mkA "mémorable" ; -- tocheck
lin lately_Adv = variants{} ; -- 
lin distributed_A = variants{} ; -- 
lin disperse_V2 = variants{} ; -- 
lin disperse_V = variants{} ; -- 
lin blame_N = mkN "coupabilité" feminine ; -- tocheck
lin basement_N = mkN "sous-sol" masculine ; -- tocheck
lin slump_V2 = mkV2 (reflV (mkV "affaler")) ; -- tocheck
lin slump_V = variants{}; -- mkV2 (reflV (mkV "affaler")) ; -- tocheck
lin puzzle_V2 = variants{} ; -- 
lin monitoring_N = mkN "surveillance" feminine ; -- tocheck
lin talented_A = mkA "doué" ; -- tocheck
lin nominal_A = mkA "nominal" ; -- tocheck
lin mushroom_N = mkN "champignon" masculine ; -- tocheck
lin instructor_N = mkN "instructeur" masculine ; -- tocheck
lin fork_N = variants{} ; -- 
lin fork_4_N = variants{} ; -- 
lin fork_3_N = variants{} ; -- 
lin fork_1_N = mkN "fourche" feminine | mkN "fourchette" feminine | mkN "fork" masculine ; -- tocheck
lin board_V2 = mkV2 (mkV "aborder") ; -- tocheck
lin want_N = mkN "besoin" masculine | mkN "manque" masculine | mkN "pauvreté" feminine ; -- tocheck
lin disposition_N = mkN "disposition" feminine | mkN "tempérament" masculine ; -- tocheck
lin cemetery_N = variants{} ; -- 
lin attempted_A = variants{} ; -- 
lin nephew_N = mkN "neveu" masculine ; -- tocheck
lin magical_A = variants{} ; -- 
lin ivory_N = mkN "ivoire" masculine | mkN "ivoire" ; -- tocheck
lin hospitality_N = mkN "hospitalité" feminine ; -- tocheck
lin besides_Prep = variants{} ; -- 
lin astonishing_A = variants{} ; -- 
lin tract_N = mkN "appareil" masculine ; -- tocheck
lin proprietor_N = mkN "propriétaire" | mkN "propriétaire" masculine ; -- tocheck
lin license_V2 = variants{} ; -- 
lin differential_A = mkA "différentiel" ; -- tocheck
lin affinity_N = mkN "affinité" ; -- tocheck
lin talking_N = variants{} ; -- 
lin royalty_N = mkN "royalty" feminine | mkN "règne" masculine ; -- tocheck
lin neglect_N = mkN "négligence" feminine | mkN "négligence" ; -- tocheck
lin irrespective_A = variants{} ; -- 
lin whip_V2 = mkV2 (mkV I.défaire_V2) | mkV2 (mkV "fouetter") | mkV2 (mkV I.battre_V2) ; -- tocheck
lin whip_V = variants{}; -- mkV2 (mkV I.défaire_V2) | mkV2 (mkV "fouetter") | mkV2 (mkV I.battre_V2) ; -- tocheck
lin sticky_A = mkA "collant" ; -- tocheck
lin regret_N = mkN "regret" masculine ; -- tocheck
lin incapable_A = mkA "incapable" ; -- tocheck
lin franchise_N = variants{} ; -- 
lin dentist_N = mkN "dentiste" ; -- tocheck
lin contrary_N = variants{} ; -- 
lin profitability_N = variants{} ; -- 
lin enthusiast_N = mkN "enthousiaste" | mkN "passionné" ; -- tocheck
lin crop_V2 = mkV2 (mkV "découper") ; -- tocheck
lin crop_V = variants{}; -- mkV2 (mkV "découper") ; -- tocheck
lin utter_V2 = mkV2 (mkV "proférer") | mkV2 (mkV "prononcer") | mkV2 (mkV I.émettre_V2) ; -- tocheck
lin pile_V2 = variants{} ; -- 
lin pile_V = variants{} ; -- 
lin pier_N = mkN "jetée" feminine | mkN "pilier" masculine | mkN "pile" feminine ; -- tocheck
lin dome_N = mkN "dôme" ; -- tocheck
lin bubble_N = mkN "bulle" feminine | mkN "trou" masculine ; -- tocheck
lin treasurer_N = mkN "trésorier" masculine ; -- tocheck
lin stocking_N = mkN "bas" masculine ; -- tocheck
lin sanctuary_N = mkN "réserve" feminine | mkN "sanctuaire" masculine | mkN "refuge" masculine | mkN "asile" masculine ; -- tocheck
lin ascertain_V2 = mkV2 (mkV "constater") ; -- tocheck
lin arc_N = mkN "arc" masculine ; -- tocheck
lin quest_N = mkN "quête" feminine ; -- tocheck
lin mole_N = mkN "taupe" feminine | mkN "mole" masculine | mkN "môle" feminine | mkN "môle" masculine | mkN "mole" feminine ; -- tocheck
lin marathon_N = mkN "marathon" masculine ; -- tocheck
lin feast_N = mkN "fête" feminine ; -- tocheck
lin crouch_V = variants{}; -- mkV2 (reflV (mkV "tapir")) ; -- tocheck
lin storm_V2 = variants{} ; -- 
lin storm_V = variants{} ; -- 
lin hardship_N = mkN "difficultés" ; -- tocheck
lin entitlement_N = mkN "allocation" feminine | mkN "revendication" feminine ; -- tocheck
lin circular_N = mkN "circulaire" ; -- tocheck
lin walking_A = variants{} ; -- 
lin strap_N = mkN "bandoulière" feminine | mkN "sangle" feminine ; -- tocheck
lin sore_A = mkA "pénible" | mkA "douloureux" ; -- tocheck
lin complementary_A = mkA "complémentaire" ; -- tocheck
lin understandable_A = mkA "compréhensible" ; -- tocheck
lin noticeable_A = mkA "remarquable" ; -- tocheck
lin mankind_N = mkN "humanité" feminine ; -- tocheck
lin majesty_N = mkN "majesté" ; -- tocheck
lin pigeon_N = mkN "pigeon" masculine ; -- tocheck
lin goalkeeper_N = variants{} ; -- 
lin ambiguous_A = mkA "ambigu" ; -- tocheck
lin walker_N = mkN "marcheur" ; -- tocheck
lin virgin_N = mkN "vierge" feminine ; -- tocheck
lin prestige_N = mkN "prestige" masculine ; -- tocheck
lin preoccupation_N = variants{} ; -- 
lin upset_A = variants{} ; -- 
lin municipal_A = mkA "municipal" ; -- tocheck
lin groan_V2 = mkV2 (mkV "râler") ; -- tocheck
lin groan_V = variants{}; -- mkV2 (mkV "râler") ; -- tocheck
lin craftsman_N = mkN "artisan" masculine ; -- tocheck
lin anticipation_N = variants{} ; -- 
lin revise_V2 = mkV2 (mkV I.revoir_V2) ; -- tocheck
lin revise_V = variants{}; -- mkV2 (mkV I.revoir_V2) ; -- tocheck
lin knock_N = mkN "coup" masculine ; -- tocheck
lin infect_V2 = mkV2 (mkV "infecter") ; -- tocheck
lin infect_V = variants{}; -- mkV2 (mkV "infecter") ; -- tocheck
lin denounce_V2 = mkV2 (mkV "dénoncer") ; -- tocheck
lin confession_N = mkN "confession" feminine ; -- tocheck
lin turkey_N = mkN "dinde" feminine ; -- tocheck
lin toll_N = mkN "péage" masculine ; -- tocheck
lin pal_N = variants{} ; -- 
lin transcription_N = mkN "transcription" feminine ; -- tocheck
lin sulphur_N = variants{} ; -- 
lin provisional_A = mkA "provisoire" ; -- tocheck
lin hug_V2 = mkV2 (mkV I.étreindre_V2) ; -- tocheck
lin particular_N = variants{} ; -- 
lin intent_A = mkA "buté" ; -- tocheck
lin fascinate_V2 = mkV2 (mkV "fasciner") ; -- tocheck
lin conductor_N = mkN "conducteur" ; -- tocheck
lin feasible_A = mkA "faisable" ; -- tocheck
lin vacant_A = mkA "vide" | mkA "niais" ; -- tocheck
lin trait_N = mkN "trait" masculine ; -- tocheck
lin meadow_N = mkN "pré" masculine ; -- tocheck
lin creed_N = mkN "crédo" masculine ; -- tocheck
lin unfamiliar_A = mkA "inconnu" ; -- tocheck
lin optimism_N = mkN "optimisme" masculine ; -- tocheck
lin wary_A = mkA "circonspect" | mkA "méfiant" ; -- tocheck
lin twist_N = mkN "torsion" feminine | mkN "twist" masculine ; -- tocheck
lin sweet_N = mkN "friandise" feminine ; -- tocheck
lin substantive_A = mkA "direct" | mkA "substantif" ; -- tocheck
lin excavation_N = mkN "excavation" feminine ; -- tocheck
lin destiny_N = mkN "destinée" masculine ; -- tocheck
lin thick_Adv = mkAdv "épais" ; -- tocheck
lin pasture_N = mkN "pâture" feminine ; -- tocheck
lin archaeological_A = mkA "archéologique" ; -- tocheck
lin tick_V2 = mkV2 (mkV "cocher") ; -- tocheck
lin tick_V = variants{}; -- mkV2 (mkV "cocher") ; -- tocheck
lin profit_V2 = mkV2 (mkV "profiter") ; -- tocheck
lin profit_V = variants{}; -- mkV2 (mkV "profiter") ; -- tocheck
lin pat_V2 = mkV2 (mkV "tapoter") ; -- tocheck
lin pat_V = variants{}; -- mkV2 (mkV "tapoter") ; -- tocheck
lin papal_A = mkA "papal" ; -- tocheck
lin cultivate_V2 = mkV2 (mkV "cultiver") ; -- tocheck
lin awake_V = mkV (mkV "réveiller") | mkV (reflV (mkV "réveiller")) ; -- tocheck
lin trained_A = variants{} ; -- 
lin civic_A = mkA "civique" ; -- tocheck
lin voyage_N = mkN "voyage" masculine ; -- tocheck
lin siege_N = mkN "siège" ; -- tocheck
lin enormously_Adv = variants{} ; -- 
lin distract_V2 = mkV2 (mkV I.distraire_V2) ; -- tocheck
lin distract_V = variants{}; -- mkV2 (mkV I.distraire_V2) ; -- tocheck
lin stroll_V = mkV (mkV "flâner") ; -- tocheck
lin jewel_N = mkN "joyau" masculine ; -- tocheck
lin honourable_A = variants{} ; -- 
lin helpless_A = mkA "désemparé" ; -- tocheck
lin hay_N = mkN "foin" masculine ; -- tocheck
lin expel_V2 = mkV2 (mkV "déporter") | mkV2 (mkV "expulser") ; -- tocheck
lin eternal_A = mkA "éternel" ; -- tocheck
lin demonstrator_N = mkN "manifestant" masculine ; -- tocheck
lin correction_N = mkN "correction" feminine ; -- tocheck
lin civilization_N = variants{} ; -- 
lin ample_A = mkA "ample" ; -- tocheck
lin retention_N = mkN "rétention" ; -- tocheck
lin rehabilitation_N = mkN "réhabilitation" feminine ; -- tocheck
lin premature_A = mkA "prématuré" ; -- tocheck
lin encompass_V2 = mkV2 (mkV "encercler") | mkV2 (mkV "englober") | mkV2 (mkV "entourer") ; -- tocheck
lin distinctly_Adv = variants{} ; -- 
lin diplomat_N = mkN "diplomate" masculine ; -- tocheck
lin articulate_V2 = mkV2 (mkV "articuler") ; -- tocheck
lin articulate_V = variants{}; -- mkV2 (mkV "articuler") ; -- tocheck
lin restricted_A = variants{} ; -- 
lin prop_V2 = mkV2 (mkV "caler") ; -- tocheck
lin intensify_V2 = mkV2 (mkV "intensifier") ; -- tocheck
lin intensify_V = variants{}; -- mkV2 (mkV "intensifier") ; -- tocheck
lin deviation_N = mkN "déviation" feminine ; -- tocheck
lin contest_V2 = variants{} ; -- 
lin contest_V = variants{} ; -- 
lin workplace_N = variants{} ; -- 
lin lazy_A = mkA "paresseux" ; -- tocheck
lin kidney_N = mkN "rognon" masculine | mkN "rein" masculine ; -- tocheck
lin insistence_N = mkN "insistence" ;
lin whisper_N = mkN "chuchotement" masculine ; -- tocheck
lin multimedia_N = mkN "multimédia" masculine ; -- tocheck
lin forestry_N = mkN "sylviculture" feminine ; -- tocheck
lin excited_A = variants{} ; -- 
lin decay_N = mkN "déchéance" feminine | mkN "décrépitude" feminine ; -- tocheck
lin screw_N = mkN "visser" | mkN "vis" feminine | mkN "hélice" ; -- tocheck
lin rally_V2V = mkV2V (mkV "rallier") ; -- tocheck
lin rally_V2 = variants{}; -- mkV2V (mkV "rallier") ; -- tocheck
lin rally_V = variants{}; -- mkV2V (mkV "rallier") ; -- tocheck
lin pest_N = mkN "peste" ; -- tocheck
lin invaluable_A = variants{} ; -- 
lin homework_N = mkN "devoirs" ; -- tocheck
lin harmful_A = mkA "dangereux" ; -- tocheck
lin bump_V2 = variants{} ; -- 
lin bump_V = variants{} ; -- 
lin bodily_A = mkA "corporel" ; -- tocheck
lin grasp_N = variants{} ; -- 
lin finished_A = variants{} ; -- 
lin facade_N = variants{} ; -- 
lin cushion_N = mkN "coussin" masculine ; -- tocheck
lin conversely_Adv = variants{} ; -- 
lin urge_N = mkN "pulsion" feminine ; -- tocheck
lin tune_V2 = variants{} ; -- 
lin tune_V = variants{} ; -- 
lin solvent_N = mkN "solvant" masculine ; -- tocheck
lin slogan_N = mkN "slogan" masculine ; -- tocheck
lin petty_A = mkA "petit" ; -- tocheck
lin perceived_A = variants{} ; -- 
lin install_V2 = mkV2 (mkV "installer") ; -- tocheck
lin install_V = variants{}; -- mkV2 (mkV "installer") ; -- tocheck
lin fuss_N = variants{} ; -- 
lin rack_N = mkN "étagère" | mkN "carré" | mkN "chevalet" masculine ; -- tocheck
lin imminent_A = mkA "imminent" ; -- tocheck
lin short_N = variants{} ; -- 
lin revert_V = mkV (mkV "retourner") ; -- tocheck
lin ram_N = mkN "bélier" masculine ; -- tocheck
lin contraction_N = mkN "contraction" feminine ; -- tocheck
lin tread_V2 = mkV2 (mkV "fouler") | mkV2 (mkV "piétiner") ; -- tocheck
lin tread_V = variants{}; -- mkV2 (mkV "fouler") | mkV2 (mkV "piétiner") ; -- tocheck
lin supplementary_A = mkA "supplémentaire" ; -- tocheck
lin ham_N = mkN "jambon" masculine ; -- tocheck
lin defy_V2V = mkV2V (mkV "défier") ; -- tocheck
lin defy_V2 = variants{}; -- mkV2V (mkV "défier") ; -- tocheck
lin athlete_N = mkN "athlète" ; -- tocheck
lin sociological_A = mkA "sociologique" ; -- tocheck
lin physician_N = mkN "médecin" masculine ; -- tocheck
lin crossing_N = mkN "carrefour" | mkN "traversée" ; -- tocheck
lin bail_N = mkN "caution" feminine | mkN "écope" feminine ; -- tocheck
lin unwanted_A = variants{} ; -- 
lin tight_Adv = mkAdv "bien" ; -- tocheck
lin plausible_A = variants{} ; -- 
lin midfield_N = variants{} ; -- 
lin alert_A = mkA "alerte" ; -- tocheck
lin feminine_A = mkA "féminin" ; -- tocheck
lin drainage_N = variants{} ; -- 
lin cruelty_N = mkN "cruauté" feminine ; -- tocheck
lin abnormal_A = mkA "inhabituel" | mkA "anormal" ; -- tocheck
lin relate_N = variants{} ; -- 
lin poison_V2 = mkV2 (mkV "empoisonner") ; -- tocheck
lin symmetry_N = mkN "symétrie" feminine ; -- tocheck
lin stake_V2 = variants{} ; -- 
lin rotten_A = L.rotten_A ;
lin prone_A = mkA "enclin" | mkA "prédisposé" ; -- tocheck
lin marsh_N = mkN "marais" ; -- tocheck
lin litigation_N = mkN "litige" masculine ; -- tocheck
lin curl_N = mkN "boucle" feminine ; -- tocheck
lin urine_N = mkN "urine" feminine ; -- tocheck
lin latin_A = variants{} ; -- 
lin hover_V = mkV (mkV "planer") | mkV (mkV "hésiter") ; -- tocheck
lin greeting_N = mkN "salutation" feminine ; -- tocheck
lin chase_N = mkN "poursuite" feminine ; -- tocheck
lin spouseMasc_N = mkN "époux" masculine ;
lin produce_N = variants{} ; -- 
lin forge_V2 = mkV2 (mkV "falsifier") | mkV2 (mkV "forger") ; -- tocheck
lin forge_V = variants{}; -- mkV2 (mkV "falsifier") | mkV2 (mkV "forger") ; -- tocheck
lin salon_N = mkN "salon" masculine ; -- tocheck
lin handicapped_A = variants{} ; -- 
lin sway_V2 = variants{} ; -- 
lin sway_V = variants{} ; -- 
lin homosexual_A = mkA "homosexuel" ; -- tocheck
lin handicap_V2 = variants{} ; -- 
lin colon_N = mkN "côlon" masculine ; -- tocheck
lin upstairs_N = variants{} ; -- 
lin stimulation_N = mkN "stimulation" feminine ; -- tocheck
lin spray_V2 = mkV2 (mkV "pulvériser") ; -- tocheck
lin original_N = mkN "original" masculine ; -- tocheck
lin lay_A = mkA "laïque" ; -- tocheck
lin garlic_N = mkN "ail" masculine ; -- tocheck
lin suitcase_N = mkN "valise" feminine ; -- tocheck
lin skipper_N = variants{} ; -- 
lin moan_VS = variants{}; -- mkV2 (reflV (mkV I.plaindre_V2)) | mkV2 (mkV "gémir") ; -- tocheck
lin moan_V = variants{}; -- mkV2 (reflV (mkV I.plaindre_V2)) | mkV2 (mkV "gémir") ; -- tocheck
lin manpower_N = variants{} ; -- 
lin manifest_V2 = variants{} ; -- 
lin incredibly_Adv = variants{} ; -- 
lin historically_Adv = variants{} ; -- 
lin decision_making_N = variants{} ; -- 
lin wildly_Adv = variants{} ; -- 
lin reformer_N = variants{} ; -- 
lin quantum_N = mkN "quantum" masculine | mkN "quantité" feminine ; -- tocheck
lin considering_Subj = variants{} ; -- 
}
