  -- Modified by Daniel Vidal Hussey (DVH)
  -- Checked by Daniel Vidal Hussey until lin formal_A
  
  concrete TopDictionaryCat of TopDictionary = CatCat
    ** open ParadigmsCat, MorphoCat, IrregCat, (L=LexiconCat), (S=StructuralCat), Prelude, BeschCat in {

flags
  coding=utf8 ;

oper  mkInterj : Str -> Interj 
    = \s -> lin Interj (ss s) ;
oper  mkDet : Str -> Det = \s -> lin Det {s,sp 
    = \\_,c => prepCase c ++ s ; n = Sg ; s2 = [] ; isNeg = False} ;
oper mkSubj : Str -> Mood -> Subj = \s,md -> ss s ** {m = md ; lock_Subj = <>} ;
oper mkConj : Str -> Conj 
    = \s -> lin Conj {s1 = [] ; s2 = s ; n = Pl} ;

lin of_Prep = ParadigmsCat.genitive ; --mkPrep "de" ;
lin and_Conj = S.and_Conj ;
lin in_Prep = S.in_Prep ;
lin have_VV = deVV IrregCat.haver_V ; -- doesn't seem to lin correctly
lin have_V2 = S.have_V2 ;
lin have_V = mkV (tenir_108 "tenir") ;
lin it_Pron = S.it_Pron ;
lin to_Prep = S.to_Prep ;
lin for_Prep = S.for_Prep ;
lin i_Pron = S.i_Pron ;
lin that_Subj = S.that_Subj ;
lin he_Pron = S.he_Pron ;
lin on_Prep = S.on_Prep ;
lin with_Prep = S.with_Prep ;
lin do_V2 = mkV2 (mkV (fer_56 "fer")) ;
lin at_Prep = mkPrep "a" | mkPrep "en" ; --Depends on the definiteness of what follows it.
lin by_Prep = S.by8agent_Prep | S.by8means_Prep ;
lin but_Conj = {s1 = [] ; s2="però" ; n=Sg} ;
lin from_Prep = S.from_Prep ;
lin they_Pron = S.they_Pron ;
lin she_Pron = S.she_Pron ;
lin or_Conj = S.or_Conj ;
lin as_Subj = mkSubj "com" Indic | mkSubj "tal com" Indic ;
lin we_Pron = S.we_Pron ;
lin weFem_Pron = S.we_Pron ;
lin say_VS = L.say_VS ;
lin say_V2 = mkV2 IrregCat.dir_V ;
lin say_V = IrregCat.dir_V ;
lin if_Subj = S.if_Subj ;
lin go_VV = aVV (mkV (anar_4 "anar")) ;
lin go_VA = mkVA L.go_V ;
lin go_V = L.go_V ; 
lin get_VV = deVV IrregCat.haver_V ;
lin get_V2V = mkV2V (verbV (servir_101 "aconseguir")) ParadigmsCat.accusative ParadigmsCat.dative ; --subcat mkVS (verbV (servir_101 "aconseguir"))  
lin make_V2V = mkV2V (mkV (fer_56 "fer")) ParadigmsCat.accusative ParadigmsCat.accusative ;
lin make_V2A = mkV2A (mkV (fer_56 "fer")) ParadigmsCat.accusative ParadigmsCat.genitive ;
lin make_V2 = mkV2 (mkV (fer_56 "fer")) ;
lin make_V = mkV (fer_56 "fer") ; 
lin as_Prep = mkPrep "com" ;
lin out_Adv = mkAdv "fora" ;
lin up_Adv = mkAdv "amunt" ;
lin see_VS = mkVS (verbV (veure_118 "veure")) ;
lin see_VQ = mkVQ (verbV (veure_118 "veure")) ;
lin see_V2V = mkV2V (verbV (veure_118 "veure")) ParadigmsCat.accusative (mkPrep "per") ;
lin see_V2 = L.see_V2 ;
lin see_V = verbV (veure_118 "veure") ; --Discourse marker value:  "I see" -> "Sí", "Ho entenc"
lin know_VS = L.know_VS ;
lin know_VQ = L.know_VQ ;
lin know_V2 = L.know_V2 ;
lin know_V = L.saberV ;
lin time_N = mkN "temps" "temps" masculine ; --TODO differences?
lin time_2_N = mkN "temps" "temps" masculine ;
lin time_1_N = mkN "temps" "temps" masculine ;
lin take_V2 = mkV2 (mkV "agafar") ;
lin so_Adv = mkAdv "tan" ; 
lin year_N = L.year_N ;
lin into_Prep = mkPrep "cap a" ; 
lin then_Adv = mkAdv "llavors" ; 
lin think_VS = mkVS L.think_V ;
lin think_V2 = mkV2 L.think_V (mkPrep "en") ;
lin think_V = L.think_V ;
lin come_V = L.come_V ;
lin than_Subj = mkSubj "que" Indic ;
lin more_Adv = mkAdv "més" ; 
lin about_Prep = mkPrep "sobre" ; 
lin now_Adv = L.now_Adv ;
lin last_A = mkA "últim" ; --TODO meaning?
lin last_1_A =mkA "últim" ;
lin last_2_A =mkA "últim" ;
lin other_A = mkA "altre" ;
lin give_V3 = L.give_V3 ;
lin give_V2 = mkV2 (verbV (donar_43 "donar")) ;
lin give_V = verbV (donar_43 "donar") ; 
lin just_Adv = mkAdv "només" ; 
lin people_N = mkN "gent" "gent" feminine ; 
lin also_Adv = mkAdv "també" | mkAdv "a més a més" ; 
lin well_Adv = mkAdv "bé" ; 
lin only_Adv = mkAdv "només" | mkAdv "tan sols" ;
lin new_A = L.new_A ;
lin when_Subj = S.when_Subj ;
lin way_N = mkN "manera" feminine | mkN "mitjà" masculine ; --TODO meaning?
lin way_2_N = mkN "manera" feminine | mkN "mitjà" masculine ;
lin way_1_N = mkN "manera" feminine | mkN "mitjà" masculine ;
lin look_VA = mkVA (mkV "mirar") ; 
lin look_V2 = mkV2 (mkV "mirar") ; 
lin look_V = mkV "mirar" ;
lin like_Prep = mkPrep "com" ; 
lin use_VV = mkVV (mkV "soler") ; --"soler" verb defectiu. TODO BeschCat has a note saying it's wasn't found, so not implemented? 
lin use_V2 = mkV2 (mkV "utilitzar") ; --TODO "fer servir" how to get these compounds?
lin use_V = mkV "utilitzar" ;
lin because_Subj = S.because_Subj ;
lin good_A = L.good_A ;
lin find_VS = mkVS (mkV "trobar") ;
lin find_V2A = mkV2A (mkV "trobar") ParadigmsCat.accusative ParadigmsCat.accusative ;
lin find_V2 = L.find_V2 ;
lin find_V = mkV "trobar" ;
lin man_N = L.man_N ;
lin want_VV = S.want_VV ;
lin want_V2V = mkV2V (verbV (voler_120 "voler")) ParadigmsCat.accusative ParadigmsCat.accusative ; --subcat, only VV possible
lin want_V2 = mkV2 (verbV (voler_120 "voler")) ;
lin want_V = verbV (voler_120 "voler") ;
lin day_N = L.day_N ;
lin between_Prep = S.between_Prep ;
lin even_Adv = mkAdv "fins i tot" ;
lin there_Adv = S.there_Adv ;
lin many_Det = S.many_Det ;
lin after_Prep = S.after_Prep ;
lin down_Adv = mkAdv "avall" ;
lin yeah_Interj = mkInterj "sí" | mkInterj "i tant" ;
lin so_Subj = mkSubj "així que" Indic ;
lin thing_N = mkN "cosa" ; 
lin tell_VS = mkVS IrregCat.dir_V ;
lin tell_V3 = dirdirV3 IrregCat.dir_V ; --meaning difference?
lin tell_1_V3 = dirdirV3 IrregCat.dir_V ;
lin tell_2_V3 = dirdirV3 IrregCat.dir_V ;
lin tell_V2V = mkV2V IrregCat.dir_V ParadigmsCat.dative ParadigmsCat.accusative ;
lin tell_V2S = mkV2S IrregCat.dir_V ParadigmsCat.dative ;
lin tell_V2 = mkV2 IrregCat.dir_V ;
lin tell_V = IrregCat.dir_V ;
lin through_Prep = S.through_Prep ;
lin back_Adv = mkAdv "enrere" ;
lin still_Adv = mkAdv "encara" ;
lin child_N = L.child_N ;
lin here_Adv = mkAdv "aquí" ;
lin over_Prep = mkPrep "per sobre" | mkPrep "sobre" ;
lin too_Adv = mkAdv "també" ;
lin put_V2 = L.put_V2 ;
lin on_Adv = mkAdv "sobre" ;
lin no_Interj = mkInterj "no" ;
lin work_V2 = mkV2 (mkV "treballar") ;
lin work_V = mkV "treballar" ;
lin work_2_V = mkV "treballar" ;
lin work_1_V = mkV "treballar" ;
lin become_VA = L.become_VA ;
lin become_V2 = mkV2 (reflV (verbV (servir_101 "convertir"))) (mkPrep "en") ; 
lin become_V = reflV (mkV "tornar") ;
lin old_A = L.old_A ;
lin government_N = mkN "govern" masculine ; 
lin mean_VV = mkVV (mkV "pensar") ; -- "tenia la intenció de"
lin mean_VS = mkVS (verbV (voler_120 "voler")) ; --subcat  "vull dir que"
lin mean_V2V = mkV2V (verbV (voler_120 "voler")) ParadigmsCat.accusative ParadigmsCat.dative ; --subcat
lin mean_V2 = mkV2 (verbV (voler_120 "voler")) ; --subcat  "vull dir que"
lin part_N = mkN "part" feminine ; 
lin leave_V2V = mkV2V (mkV "deixar") ParadigmsCat.accusative ParadigmsCat.accusative ;  
lin leave_V2 = L.leave_V2 ;
lin leave_V = mkV "marxar" ; 
lin life_N = mkN "vida" feminine ;
lin great_A = mkA "genial" | mkA "increïble" ;
lin case_N = mkN "cas" masculine ;
lin woman_N = L.woman_N ;
lin over_Adv = mkAdv "un altre cop" ; -- should be "tornar a X" 
lin seem_VV = mkVV (mkV "semblar") ;
lin seem_VS = mkVS (mkV "semblar") ;
lin seem_VA = mkVA (mkV "semblar") ; 
lin work_N = mkN "feina" feminine ;
lin need_VV = deVV IrregCat.haver_V ;
lin need_V2 = mkV2 IrregCat.haver_V ;
lin need_V = IrregCat.haver_V ;
lin feel_VS = mkVS (verbV (sentir_100 "sentir")) ;
lin feel_VA = mkVA (verbV (sentir_100 "sentir")) ;
lin feel_V2 = mkV2 (verbV (sentir_100 "sentir")) ;
lin feel_V = verbV (sentir_100 "sentir") ; --subcat
lin system_N = mkN "sistema" masculine ;
lin each_Det = S.every_Det ;
lin may_2_VV = variants{} ; --should be Adv + V structure "potser cantaré"
lin may_1_VV = variants{} ; --idem
lin much_Adv = mkAdv "gaire" ;
lin ask_VQ = mkVQ (mkV "preguntar") ;
lin ask_V2V = mkV2V (mkV "demanar") ParadigmsCat.dative ParadigmsCat.genitive ;
lin ask_V2 = mkV2 (mkV "preguntar") ;
lin ask_V = mkV "preguntar" ;
lin group_N = mkN "grup" masculine ;
lin number_N = L.number_N ;
lin number_3_N = L.number_N ;
lin number_2_N = L.number_N ;
lin number_1_N = L.number_N ;
lin yes_Interj = mkInterj "sí" ;
lin however_Adv = mkAdv "tot i això" | mkAdv "això no obstant" ;
lin another_Det = variants{} ; -- altre TODO make the determiner
lin again_Adv = mkAdv "un altre cop" ; -- should be "tornar a X"
lin world_N = mkN "món" masculine ;
lin area_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_6_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_5_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_4_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_3_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_2_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_1_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin show_VS = mkVS (mkV "ensenyar") ;
lin show_VQ = mkVQ (mkV "ensenyar") ;
lin show_V2 = mkV2 (mkV "ensenyar") ;
lin show_V = mkV "ensenyar" ;
lin course_N = mkN "curs" masculine ; --split mkN "rumb"
lin company_2_N = mkN "companyia" masculine ; --split mkN "empresa" fem
lin company_1_N = mkN "companyia" masculine ; --split mkN "empresa" fem
lin under_Prep = S.under_Prep ;
lin problem_N = mkN "problema" masculine ;
lin against_Prep = mkPrep "en contra de" ; --split mkPrep "a" ("lean against the wall")
lin never_Adv = mkAdv "mai" ;
lin most_Adv = mkAdv "la majoria de" ;
lin service_N = mkN "servei" masculine ;
lin try_VV = deVV (mkV "intentar") ;
lin try_V2 = mkV2 (mkV "provar") ; --split "tastar"
lin try_V = mkV "intentar" ;--subcat, in catalan only V2 possible
lin call_V2 = mkV2 (mkV "trucar") ParadigmsCat.dative ;
lin call_V = mkV "trucar" ;
lin hand_N = L.hand_N ;
lin party_N = mkN "partit" masculine ; --split mkN "festa" mkN "expedició"
lin party_2_N = mkN "partit" masculine ; --split mkN "festa" mkN "expedició"
lin party_1_N = mkN "partit" masculine ; --split mkN "festa" mkN "expedició"
lin high_A = mkA "alt" ;
lin about_Adv = mkAdv "aproximadament" ;
lin something_NP = S.something_NP ;
lin school_N = L.school_N ;
lin in_Adv = mkAdv "dins" ;
lin in_1_Adv = mkAdv "dins" ;
lin in_2_Adv = mkAdv "dins" ;
lin small_A = L.small_A ;
lin place_N = mkN "lloc" masculine ;
lin before_Prep = S.before_Prep ;
lin while_Subj = mkSubj "while" Conjunct ;
lin away_Adv = mkAdv "fora" ; --in Catalan should be incorporated into the verb "marxar" vs "go away"
lin away_2_Adv = mkAdv "fora" ; --in Catalan should be incorporated into the verb "marxar" vs "go away"
lin away_1_Adv = mkAdv "fora" ; --in Catalan should be incorporated into the verb "marxar" vs "go away"
lin keep_VV = mkVV (mkV "continuar") ;
lin keep_V2A = mkV2A (mkV "mantenir") ParadigmsCat.accusative ParadigmsCat.genitive ;
lin keep_V2 = mkV2 (mkV "guardar") ;
lin keep_V = mkV "guardar" ;
lin point_N = mkN "punt" masculine ;
lin point_2_N = mkN "punt" masculine ;
lin point_1_N = mkN "punt" masculine ;
lin house_N = L.house_N ;
lin different_A = mkA "diferent" ;
lin country_N = L.country_N ;
lin really_Adv = mkAdv "de veritat" ;
lin provide_V2 = mkV2 (verbV (lluir_64 "proveir")) ;
lin provide_V = verbV (lluir_64 "proveir") ;
lin week_N = mkN "setmana" feminine ;
lin hold_VS = mkVS (verbV (obtenir_78 "sostenir")) ;
lin hold_V2 = L.hold_V2 ;
lin hold_V = mkV "aguantar" ;
lin large_A = mkA "gran" ;
lin member_N = mkN "membre" masculine ;
lin off_Adv = mkAdv "fora" ; --wrong, should be part of the verb "take off" -> "treure", "turn off" -> apagar, etc.
lin always_Adv = S.always_AdV ; 
lin follow_VS = mkVS (reflV (mkV (servir_101 "seguir"))) ;
lin follow_V2 = mkV2 (verbV (servir_101 "seguir")) ;
lin follow_V = verbV (servir_101 "seguir") ;
lin without_Prep = S.without_Prep ;
lin turn_VA = mkVA (reflV (mkV "tornar")) ;
lin turn_V2 = mkV2 (mkV "girar") ;
lin turn_V = L.turn_V ;
lin end_N = mkN "final" masculine ; --split "final" feminine, "fi" feminine, "fi" masculine (for mor info cf. DIEC)
lin end_2_N = mkN "final" masculine ; --split "final" feminine, "fi" feminine, "fi" masculine (for mor info cf. DIEC)
lin end_1_N = mkN "final" masculine ; --split "final" feminine, "fi" feminine, "fi" masculine (for mor info cf. DIEC)
lin within_Prep = mkPrep "a dins de" | mkPrep "a l'interior de" ;
lin local_A = mkA "local" ;
lin where_Subj = mkSubj "on" Indic ;
lin during_Prep = S.during_Prep ;
lin bring_V3 = mkV3 (mkV "portar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin bring_V2 = mkV2 (mkV "portar") ;
lin most_Det = mkDet "la majoria de" ;
lin word_N = mkN "paraula" feminine ;
lin begin_V2 = mkV2 (mkV "començar") ;
lin begin_V = mkV "començar" ;
lin although_Subj = S.although_Subj ;
lin example_N = mkN "exemple" masculine ;
lin next_Adv = mkAdv "a continuació" | mkAdv "després" ;
lin family_N = mkN "familia" feminine ;
lin rather_Adv = mkAdv "millor" ;
lin fact_N = mkN "fet" masculine ;
lin like_VV = mkVV (mkV "agradar") ;
lin like_VS = mkVS (mkV "agradar") ;
lin like_V2 = L.like_V2 ;
lin social_A = mkA "social" ;
lin write_VS = mkVS (verbV (escriure_50 "escriure")) ; 
lin write_V2 = L.write_V2 ;
lin write_V = verbV (escriure_50 "escriure") ;
lin state_N = mkN "estat" masculine ;
lin state_2_N = mkN "estat" masculine ;
lin state_1_N = mkN "estat" masculine ;
lin percent_N = mkN "percentatge" masculine ;
lin quite_Adv = S.quite_Adv ;
lin both_Det = variants{} ; --TODO "tots dos" both components have to agree
lin start_V2 = mkV2 (mkV "començar") ;
lin start_V = mkV "començar" ;
lin run_V2 = mkV2 (mkV "engegar") | mkV2 (verbV (atendre_8 "encendre")) ;
lin run_V = L.run_V ;
lin long_A = L.long_A ;
lin right_Adv = mkAdv "bé" ; --split mkAdv "a la dreta" 
lin right_2_Adv = mkAdv "bé" ; --split mkAdv "a la dreta" 
lin right_1_Adv = mkAdv "bé" ; --split mkAdv "a la dreta" 
lin set_V2 = mkV2 (verbV (servir_101 "definir")) ;
lin help_V2V = mkV2V (mkV "ajudar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin help_V2 = mkV2 (mkV "ajudar" ) ;
lin help_V = mkV "ajudar" ;
lin every_Det = S.every_Det ;
lin home_N = mkN "casa" feminine ;
lin month_N = mkN "mes" masculine ;
lin side_N = mkN "costat" masculine ;
lin night_N = L.night_N ;
lin important_A = L.important_A ;
lin eye_N = L.eye_N ;
lin head_N = L.head_N ;
lin information_N = mkN "informació" feminine ;
lin question_N = L.question_N ;
lin business_N = mkN "empresa" feminine ; --difficult to translate, usually translated in context
lin play_V2 = L.play_V2 ;
lin play_V = L.play_V ;
lin play_3_V2 = L.play_V2 ; 
lin play_3_V = L.play_V ;
lin play_2_V2 = L.play_V2 ;
lin play_2_V = L.play_V ;
lin play_1_V2 = L.play_V2 ;
lin play_1_V = L.play_V ;
lin power_N = mkN "poder" masculine ;
lin money_N = mkN "diners" "diners" masculine ;
lin change_N = mkN "canvi" masculine ;
lin move_V2 = mkV2 (verbV (moure_72 "moure")) ;
lin move_V = verbV (moure_72 "moure") ;
lin move_2_V = verbV (moure_72 "moure") ;
lin move_1_V = verbV (moure_72 "moure") ;
lin interest_N = mkN "interès" masculine ;
lin interest_4_N = mkN "interès" masculine ;
lin interest_2_N = mkN "interès" masculine ;
lin interest_1_N = mkN "interès" masculine ;
lin order_N = mkN "ordre" masculine ; --split mkN "comanda" fem (commercial order), mkN "ordre" feminine  (command, order someone to do something)
lin book_N = L.book_N ;
lin often_Adv = mkAdv "sovint" ;
lin development_N = mkN "desenvolupament" masculine ;
lin young_A = L.young_A ;
lin national_A = mkA "nacional" ;
lin pay_V3 = dirdirV3 (mkV "pagar") ;
lin pay_V2V = mkV2V (mkV "pagar") ParadigmsCat.accusative (mkPrep "per") ;
lin pay_V2 = mkV2 (mkV "pagar") ;
lin pay_V = mkV "pagar" ;
lin hear_VS = mkVS (verbV (sentir_100 "sentir")) ;
lin hear_V2V = mkV2V (verbV (sentir_100 "sentir")) ParadigmsCat.accusative ParadigmsCat.accusative ;
lin hear_V2 = mkV2 (verbV (sentir_100 "sentir")) ;
lin hear_V = verbV (sentir_100 "sentir") ;
lin room_N = mkN "habitació" feminine ;
lin room_1_N = mkN "habitació" feminine ;
lin room_2_N = mkN "habitació" feminine ;
lin whether_Subj = ss "si" ** {m = Indic} ; 
lin water_N = L.water_N ;
lin form_N = mkN "formulari" masculine ;
lin car_N = L.car_N ;
lin other_N = mkN "altre" ;
lin yet_Adv = mkAdv "encara" ;
lin yet_2_Adv = mkAdv "encara" ;
lin yet_1_Adv = mkAdv "encara" ;
lin perhaps_Adv = mkAdv "potser" ;
lin meet_V2 = mkV2 (verbV (conèixer_27 "conèixer")) ;
lin meet_V = verbV (conèixer_27 "conèixer") ;
lin level_N = mkN "nivell" masculine ;
lin level_2_N = mkN "nivell" masculine ;
lin level_1_N = mkN "nivell" masculine ;
lin until_Subj = mkSubj "fins que" Conjunct | mkSubj "fins que" Indic ; 
lin though_Subj = mkSubj "encara que" Conjunct | mkSubj "tot i que" Conjunct ;
lin policy_N = mkN "política" feminine ;
lin include_V2 = mkV2 (verbV (complaure_24 "incloure")) ;
lin include_V = verbV (complaure_24 "incloure") ;
lin believe_VS = mkVS (verbV (creure_34 "creure")) ;
lin believe_V2 = mkV2 (verbV (creure_34 "creure")) ;
lin believe_V = verbV (creure_34 "creure") ;
lin council_N = mkN "ajuntament" masculine ;
lin already_Adv = L.already_Adv ;
lin possible_A = mkA "possible" ;
lin nothing_NP = S.nothing_NP ;
lin line_N = mkN "línia" feminine ;
lin allow_V2V = mkV2V (verbV (admetre_2 "permetre")) ParadigmsCat.accusative ParadigmsCat.genitive ;
lin allow_V2 = mkV2 (verbV (admetre_2 "permetre")) ;
lin need_N = mkN "necessitat" masculine ;
lin effect_N =  mkN "efecte" masculine ;
lin big_A = L.big_A ;
lin use_N = mkN "utilitat" feminine ; --mkN "ús" masculine (utilitat: what it's used for, ús: how it's used)
lin lead_V2V = mkV2V (verbV (reduir_94 "conduir")) ParadigmsCat.accusative ParadigmsCat.dative ;
lin lead_V2 = mkV2 (verbV (reduir_94 "conduir")) ;
lin lead_V = verbV (reduir_94 "conduir") ;
lin stand_V2 = mkV2 (mkV "suportar") | mkV2 (mkV "aguantar") ;
lin stand_V = L.stand_V ;
lin idea_N = mkN "idea" feminine ;
lin study_N = mkN "estudi" masculine ;
lin lot_N = mkN "lot" masculine ;
lin live_V = L.live_V ;
lin job_N = mkN "feina" feminine ;
lin since_Subj = mkSubj "des que" Indic ;
lin name_N = L.name_N ;
lin result_N = mkN "resultat" masculine ;
lin body_N = mkN "cos" masculine ;
lin happen_VV = variants{} ; --TODO should be added as a phrase "per casualitat"
lin happen_V = mkV "passar" | verbV (córrer_30 "ocórrer") ;
lin friend_N = L.friend_N ;
lin right_N = mkN "dreta" feminine ; --split mkN "dret" masculine (direction vs. legal right)
lin least_Adv = mkAdv "menys" ;
lin right_A = mkA "correcte" ;
lin right_2_A = mkA "correcte" ;
lin right_1_A = mkA "correcte" ;
lin almost_Adv = mkAdv "quasi" | mkAdv "gairebé" ;
lin much_Det = S.much_Det ;
lin carry_V2 = mkV2 (mkV "portar") | mkV2 (verbV (dur_45 "dur")) ;
lin carry_V = mkV "portar" | verbV (dur_45 "dur") ;
lin authority_N = mkN "autoritat" feminine ;
lin authority_2_N = mkN "autoritat" feminine ;
lin authority_1_N = mkN "autoritat" feminine ;
lin long_Adv = variants{} ; --would turn into other structures, e.g. "we hadn't known them long" -> "no feia gaire temps que els coneixiem"
lin early_A = mkA "aviat" ;
lin view_N = mkN "vista" feminine ; -- mkN "paisatge"
lin view_2_N = mkN "vista" feminine ; -- mkN "paisatge"
lin view_1_N = mkN "vista" feminine ; -- mkN "paisatge"
lin public_A = mkA "públic" ;
lin together_Adv = mkAdv "junt" ;
lin talk_V2 = mkV2 (mkV "parlar") ParadigmsCat.genitive ;
lin talk_V =  mkV "parlar" ;
lin report_N = mkN "informe" masculine ; --split mkN "reportatge" (general vs. journalistic report)
lin after_Subj = mkSubj "després que" Indic ;
lin only_Predet = S.only_Predet ;
lin before_Subj = mkSubj "abans que" Conjunct ;
lin bit_N = mkN "mica" feminine ;
lin face_N = mkN "cara" feminine ;
lin sit_V2 = mkV2 (verbV (seure_102 "seure")) ; 
lin sit_V = L.sit_V ;
lin market_N = mkN "mercat" masculine ;
lin market_1_N = mkN "mercat" masculine ;
lin market_2_N = mkN "mercat" masculine ;
lin appear_VV = mkVV (mkV "semblar") ; --subcat mkVS
lin appear_VS = mkVS (mkV "semblar") ;
lin appear_VA = mkVA (mkV "semblar") ;
lin appear_V = mkV "semblar" ;
lin continue_VV = mkVV (mkV "continuar") ; --subcat: continuar + gerund
lin continue_V2 = mkV2 (mkV "continuar") ;
lin continue_V = mkV "continuar" ;
lin able_A = mkA "capaç" ;
lin political_A = mkA "polític" ;
lin later_Adv = mkAdv "més tard" ;
lin hour_N = mkN "hora" feminine ;
lin rate_N = mkN "tipus" masculine ;
lin law_N = mkN "llei" feminine ; --split mkN "dret" masculine (specific law vs. field)
lin law_2_N = mkN "llei" feminine ; --split mkN "dret" masculine (specific law vs. field)
lin law_1_N = mkN "llei" feminine ; --split mkN "dret" masculine (specific law vs. field)
lin door_N = L.door_N ;
lin court_N = mkN "jutjat" masculine ;
lin court_2_N = mkN "jutjat" masculine ;
lin court_1_N = mkN "jutjat" masculine ;
lin office_N = mkN "oficina" feminine ;
lin let_V2V = mkV2V (mkV "deixar") ParadigmsCat.accusative ParadigmsCat.accusative ;
lin war_N = L.war_N ;
lin produce_V2 = mkV2 (verbV (reduir_94 "produir")) ;
lin produce_V = verbV (reduir_94 "produir") ;
lin reason_N = L.reason_N ;
lin less_Adv = mkAdv "menys" ;
lin minister_N = mkN "ministre" ;
lin minister_2_N = mkN "ministre" ;
lin minister_1_N = mkN "ministre" ;
lin subject_N = mkN "subjecte" masculine ; --split mkN "tema" masculine (grammatical vs. conversation topic) 
lin subject_2_N = mkN "subjecte" masculine ; --split mkN "tema" masculine (grammatical vs. conversation topic) 
lin subject_1_N = mkN "subjecte" masculine ; --split mkN "tema" masculine (grammatical vs. conversation topic) 
lin person_N = L.person_N ;
lin term_N = mkN "terme" masculine ;
lin particular_A = mkA "particular" | mkA "concret" ;
lin full_A = L.full_A ;
lin involve_VS = mkVS (mkV "implicar") ;
lin involve_V2 = mkV2 (mkV "implicar") ;
lin involve_V = mkV "implicar" ;
lin sort_N = mkN "tipus" masculine ; --split mkN "classificació"
lin require_VS = variants{} ; --TODO mkVS caldre (note in BeschCat)
lin require_V2V = variants{} ; --TODO mVS caldre (note in BeschCat)
lin require_V2 = variants{} ; --TODO mVS caldre (note in BeschCat)
lin require_V = variants{} ; --TODO mVS caldre (note in BeschCat)
lin suggest_VS = mkVS (verbV (servir_101 "suggerir")) ;
lin suggest_V2 = mkV2 (verbV (servir_101 "suggerir")) ;
lin suggest_V = verbV (servir_101 "suggerir") ;
lin far_A =  mkA "lluny" ;
lin towards_Prep = mkPrep "cap a" ;
lin anything_NP = variants {} ; --TODO qualsevol cosa
lin period_N = mkN "període" masculine ; --split mkN "regla" feminine 
lin period_3_N = mkN "període" masculine ; --split mkN "regla" feminine 
lin period_2_N = mkN "període" masculine ; --split mkN "regla" feminine 
lin period_1_N = mkN "període" masculine ; --split mkN "regla" feminine 
lin consider_VV = deVV (mkV "considerar") | deVV (mkV "pensar") ; 
lin consider_VS = mkVS (mkV "considerava") ;
lin consider_V3 = mkV3 (mkV "considerar") ParadigmsCat.accusative (mkPrep "com") ;
lin consider_V2V = mkV2V (mkV "considerar") ParadigmsCat.accusative (mkPrep "com") ;
lin consider_V2A = mkV2A (mkV "considerar") ParadigmsCat.accusative (mkPrep "com") ;
lin consider_V2 = mkV2 (mkV "considerar") ;
lin consider_V = mkV "considerar" ;
lin read_VS = mkVS (verbV (servir_101 "llegir")) ;
lin read_V2 = L.read_V2 ;
lin read_V = verbV (servir_101 "llegir") ;
lin change_V2 = mkV2 (mkV "canviar") ;
lin change_V = mkV "canviar" ;
lin society_N = mkN "societat" feminine ;
lin process_N = mkN "procés" masculine ;
lin mother_N = mkN "mare" feminine ;
lin offer_VV = aVV (verbV (servir_101 "oferir")) ;
lin offer_V2 = mkV2 (verbV (servir_101 "oferir")) ;
lin late_A = mkA "tard" ;
lin voice_N = mkN "veu" feminine ;
lin both_Adv = mkAdv "tots dos" ; --TODO needs agreement
lin once_Adv = mkAdv "un cop" | mkAdv "una vegada" ;
lin police_N = mkN "policia" feminine ;
lin kind_N = mkN "tipus" feminine | mkN "mena" feminine ;
lin lose_V2 = L.lose_V2 ;
lin lose_V = verbV (perdre_83 "perdre") ;
lin add_VS = mkVS (mkV "afegir") ;
lin add_V2 = mkV2 (mkV "afegir") ;
lin add_V = mkV "afegir" ;
lin probably_Adv = mkAdv "probablement" ;
lin expect_VV = mkVV (mkV "esperar") ;
lin expect_VS = mkVS (mkV "esperar") ;
lin expect_V2V = mkV2V (mkV "esperar") ParadigmsCat.accusative ParadigmsCat.genitive ;
lin expect_V2 = mkV2 (mkV "esperar") ;
lin expect_V = mkV "esperar" ;
lin ever_Adv = mkAdv "mai" ;
lin available_A = mkA "disponible" ;
lin price_N = mkN "preu" masculine ;
lin little_A = mkA "petit" ;
lin action_N = mkN "acció" masculine ;
lin issue_N = mkN "tema" masculine ; --split mkN "problema"
lin issue_2_N = mkN "tema" masculine ; --split mkN "problema"
lin issue_1_N = mkN "tema" masculine ; --split mkN "problema"
lin far_Adv = L.far_Adv ;
lin remember_VS = mkVS (mkV "recordar") ;
lin remember_V2 = mkV2 (mkV "recordar") ;
lin remember_V = mkV "recordar" ;
lin position_N = mkN "posició" masculine ; --split mkN "lloc de treball" masculine
lin low_A = mkA "baix" ;
lin cost_N = mkN "cost" masculine ;
lin little_Det = variants{} ; --TODO sense?
lin matter_N = mkN "assumpte" masculine ; --split "matèria" topic vs. physical matter
lin matter_1_N = mkN "assumpte" masculine ; --split "matèria" topic vs. physical matter
lin matter_2_N = mkN "assumpte" masculine ; --split "matèria" topic vs. physical matter
lin community_N = mkN "comunitat" feminine ;
lin remain_VV = mkVV (mkV "continuar") ; --subcat continuava + GERUNDI | quedar-se + GERUNDI
lin remain_VA = mkVA (mkV "estar") | mkVA (mkV "quedar") ;
lin remain_V2 = variants{} ; --TODO subcat sense?
lin remain_V = verbV (romandre_97 "romandre") ;
lin figure_N = mkN "figura" feminine ; --split mkN "gràfic" masculine
lin figure_2_N = mkN "figura" feminine ; --split mkN "gràfic" masculine
lin figure_1_N = mkN "figura" feminine ; --split mkN "gràfic" masculine
lin type_N = mkN "tipus" masculine ;
lin research_N = mkN "recerca" feminine ;
lin actually_Adv = mkAdv "de fet" ;
lin education_N = mkN "educació" masculine ;
lin fall_V = verbV (caure_18 "caure") ;
lin speak_V2 = L.speak_V2 ;
lin speak_V = mkV "parlar" ;
lin few_N = variants{} ; --TODO "uns quants NOUN" strange structure few as a noun?
lin today_Adv = L.today_Adv ;
lin enough_Adv = mkAdv "prou" ;
lin open_V2 = L.open_V2 ;
lin open_V = verbV (obrir_77 "obrir") ;
lin bad_A = L.bad_A ;
lin buy_V2 = L.buy_V2 ;
lin buy_V = mkV "compar" ;
lin programme_N = mkN "programa" feminine ;
lin minute_N = mkN "minut" masculine ;
lin moment_N = mkN "moment" masculine ;
lin girl_N = L.girl_N ;
lin age_N = mkN "edat" feminine ;
lin centre_N = mkN "centre" masculine ;
lin stop_VV = deVV (mkV "parar") ;
lin stop_V2 = mkV2 (mkV "parar") ;
lin stop_V = L.stop_V ;
lin control_N = mkN "control" masculine ;
lin value_N = mkN "valor" masculine ;
lin send_V2V = mkV2V (mkV "eviar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin send_V2 = mkV2 (mkV "enviar") ;
lin send_V = mkV "enviar" ;
lin health_N = mkN "salut" feminine ;
lin decide_VV = deVV (verbV (servir_101 "decidir")) ;
lin decide_VS = mkVS (verbV (servir_101 "decidir")) ;
lin decide_V2 = mkV2 (verbV (servir_101 "decidir")) ;
lin decide_V = verbV (servir_101 "decidir") ;
lin main_A = mkA "principal" ;
lin win_V2 = L.win_V2 ;
lin win_V = mkV "guanyar" ;
lin understand_VS = mkVS (verbV (atendre_8 "entendre")) ;
lin understand_V2 = mkV2 (verbV (atendre_8 "entendre")) ;
lin understand_V = verbV (atendre_8 "entendre") ;
lin decision_N = mkN "decisió" feminine ;
lin develop_V2 = mkV2 (mkV "desenvolupar") ;
lin develop_V = mkV "desenvolupar" ;
lin class_N = mkN "aula" feminine ; --split "classe" feminine educational vs. generic type
lin industry_N = L.industry_N ;
lin receive_V2 = mkV2 (verbV (rebre_92 "rebre")) ;
lin receive_V = verbV (rebre_92 "rebre") ;
lin back_N = L.back_N ;
lin several_Det = mkDet "diversos" ;
lin return_V2 = mkV2 (mkV "tornar") ;
lin return_V = mkV "tornar" ;
lin build_V2 = mkV2 (verbV (servir_101 "construir")) ;
lin build_V = verbV (servir_101 "construir") ;
lin spend_V2 = mkV2 (mkV "gastar") ; --split
lin spend_V = mkV "gastar" ; --split mkV "passar"  money vs. time
lin force_N = mkN "força" feminine ;
lin condition_N = mkN "condició" feminine ;
lin condition_1_N = mkN "condició" feminine ;
lin condition_2_N = mkN "condició" feminine ;
lin paper_N = L.paper_N ;
lin off_Prep = mkPrep "fora" ;
lin major_A = mkA "important" ;
lin describe_VS = mkVS (verbV (escriure_50 "descriure")) ;
lin describe_V2 = mkV2 (verbV (escriure_50 "descriure")) ;
lin agree_VV = mkVV (mkV "acordar") ;
lin agree_VS = mkVS (mkV "acordar") ;
lin agree_V = variants{} ; --TODO posar-se d'acord : how to get this structure?
lin economic_A = mkA "econòmic" ;
lin increase_V2 = mkV2 (mkV "augmentar") | mkV2 (mkV "incrementar") ;
lin increase_V = mkV "augmentar" | mkV "incrementar" ;
lin upon_Prep = mkPrep "a sobre de" ; --split "tan bon punt"
lin learn_VV = aVV (verbV (aprendre_6 "aprendre")) ;
lin learn_VS = mkVS (verbV (aprendre_6 "aprendre")) ;
lin learn_V2 = L.learn_V2 ;
lin learn_V = verbV (aprendre_6 "aprendre") ;
lin general_A = mkA "general" ;
lin century_N = mkN "segle" masculine ;
lin therefore_Adv = mkAdv "per tant" ;
lin father_N = mkN "pare" masculine ;
lin section_N = mkN "part" masculine | mkN "secció" feminine ;
lin patient_N = mkN "pacient" ;
lin around_Adv = mkAdv "al voltant de" ;
lin activity_N = mkN "activitat" feminine ;
lin road_N = L.road_N ;
lin table_N = L.table_N ;
lin including_Prep = variants{} ; --TODO mkA "inclòs"
lin church_N = L.church_N ;
lin reach_V2 = mkV2 (mkV "arribo") ParadigmsCat.dative ;
lin reach_V = mkV "arribar" ;
lin real_A = mkA "real" ;
lin lie_VS = mkVS (verbV (mentir_66 "mentir")) ;
lin lie_2_V = reflV (mkV "estirar") ;
lin lie_1_V = mkV (mentir_66 "mentir") ;
lin mind_N = mkN "ment" feminine ;
lin likely_A = mkA "probable" ;
lin among_Prep = mkPrep "entre" ;
lin team_N = mkN "equip" masculine ;
lin experience_N = mkN "experiència" feminine ;
lin death_N = mkN "mort" feminine ;
lin soon_Adv = mkAdv "aviat" ;
lin act_N = mkN "acte" masculine ;
lin sense_N = mkN "sensació" feminine ;
lin staff_N = mkN "personal" masculine ;
lin staff_2_N = mkN "personal" masculine ;
lin staff_1_N = mkN "personal" masculine ;
lin certain_A = mkA "convençut" ; --split "segur"  I'm convinced vs. it's a certain thing
lin certain_2_A = mkA "convençut" ; --split "segur"  I'm convinced vs. it's a certain thing
lin certain_1_A = mkA "convençut" ; --split "segur"  I'm convinced vs. it's a certain thing
lin half_Predet = {s = \\a,c => prepCase c ++ "mig" ; c = Nom ; a = PNoAg} ;
lin half_Predet = {s = \\a,c => prepCase c ++ "mig" ; c = Nom ; a = PNoAg} ;
lin around_Prep = mkPrep "al voltant de" ;
lin language_N = L.language_N ;
lin walk_V2 = mkV2 (mkV "caminar") ;
lin walk_V = L.walk_V ;
lin die_V = L.die_V ;
lin special_A = mkA "especial" ;
lin difficult_A = mkA "difícil" ;
lin international_A = mkA "internacional" ;
lin particularly_Adv = mkAdv "concretament" ; --split "especialment"  specifically vs especially
lin department_N = mkN "departament" masculine ;
lin management_N = mkN "gestió" masculine ;
lin morning_N = mkN "matí" masculine ;
lin draw_V2 = mkV2 (mkV "dibuixar") ; --split "treure" (draw from something)
lin draw_1_V2 = mkV2 (mkV "dibuixar") ; --split "treure" (draw from something)
lin draw_2_V2 = mkV2 (mkV "dibuixar") ; --split "treure" (draw from something)
lin draw_V = mkV "dibuixar" ;
lin hope_VV = mkVV (mkV "esperar") ;
lin hope_VS = L.hope_VS ;
lin hope_V = mkV "esperar" ;
lin across_Prep = mkPrep "a través de" ;
lin plan_N = mkN "pla" masculine ;
lin product_N = mkN "producte" masculine ;
lin city_N = L.city_N ;
lin early_Adv = mkAdv "aviat" ;
lin committee_N = mkN "comitè" masculine ;
lin ground_N = mkN "terra" masculine ; --split "terra" feminine : the floor vs. dug up earth
lin ground_2_N = mkN "terra" masculine ; --split "terra" feminine : the floor vs. dug up earth
lin ground_1_N = mkN "terra" masculine ; --split "terra" feminine : the floor vs. dug up earth
lin letter_N = mkN "carta" feminine ; --split "lletra" (alphabet)
lin letter_2_N = mkN "carta" feminine ; --split "lletra" (alphabet)
lin letter_1_N = mkN "carta" feminine ; --split "lletra" (alphabet)
lin create_V2 = mkV2 (mkV "crear") ;
lin create_V = mkV "crear" ;
lin evidence_N = mkN "prova" feminine ;
lin evidence_2_N = mkN "prova" feminine ;
lin evidence_1_N = mkN "prova" feminine ;
lin foot_N = L.foot_N ;
lin clear_A = mkA "transparent" ; --split "obvi" | "clar"  
lin boy_N = L.boy_N ;
lin game_N = mkN "joc" masculine ;
lin game_3_N = mkN "joc" masculine ;
lin game_2_N = mkN "joc" masculine ;
lin game_1_N = mkN "joc" masculine ;
lin food_N = mkN "menjar" masculine ;
lin role_N = mkN "paper" masculine ;
lin role_2_N = mkN "paper" masculine ;
lin role_1_N = mkN "paper" masculine ;
lin practice_N = mkN "pràctica" feminine ;
lin bank_N = L.bank_N ;
lin else_Adv = mkAdv "més" ;
lin support_N = mkN "suport" masculine ;
lin sell_V2 = mkV2 (verbV (vendre_116 "vendre")) ;
lin sell_V = verbV (vendre_116 "vendre") ;
lin event_N = mkN "acte" masculine ;
lin building_N = mkN "edifici" masculine ;
lin range_N = mkN "interval" masculine ;
lin behind_Prep = S.behind_Prep ;
lin sure_A = mkA "segur" ;
lin report_VS = mkVS (mkV "informar") ;
lin report_V2 = mkV2 (mkV "informar") ParadigmsCat.genitive ;
lin report_V = mkV "informar" ;
lin pass_V = mkV "passar" ; --split "aprovar" (pass an exam)
lin black_A = L.black_A ;
lin stage_N = mkN "escenari" masculine ; --split "estadi" (theater vs. conceptual stage)
lin meeting_N = mkN "reunió" feminine ; --split "trobada" (business vs. generic)
lin sometimes_Adv = mkAdv "a vegades" ;
lin thus_Adv = mkAdv "per tant" ; --split "així" | "així doncs"
lin accept_VS = mkVS (mkV "acceptar") ;
lin accept_V2 = mkV2 (mkV "acceptar") ;
lin accept_V = mkV "acceptar" ;
lin town_N = mkN "poble" masculine ;
lin art_N = L.art_N ;
lin further_Adv = mkAdv "més lluny" | mkAdv "més enllà" ;
lin club_N = mkN "club" masculine ;
lin club_2_N = mkN "club" masculine ;
lin club_1_N = mkN "club" masculine ;
lin cause_V2V = mkV2V (mkV "causar") ParadigmsCat.accusative ParadigmsCat.genitive ;
lin cause_V2 = mkV2 (mkV "causar") ;
lin arm_N = mkN "braç" masculine ;
lin arm_1_N =mkN "braç" masculine ;
lin arm_2_N =mkN "braç" masculine ;
lin history_N = mkN "història" feminine ;
lin parent_N = mkN "pare" masculine ;
lin land_N = mkN "terra" feminine ;
lin trade_N = mkN "comerç" masculine ;
lin watch_VS = mkVS (mkV "procurar") ;
lin watch_V2V = mkV2V (mkV "mirar") ParadigmsCat.accusative ParadigmsCat.accusative ; --subcat
lin watch_V2 = L.watch_V2 ;
lin watch_1_V2 = L.watch_V2 ;
lin watch_2_V2 = L.watch_V2 ;
lin watch_V = mkV "mirar" | mkV "vigilar" ;
lin white_A = L.white_A ;
lin situation_N = mkN "situació" feminine ;
lin ago_Adv = variants{} ; --TODO structure "fa X anys, mesos, etc."
lin record_N = mkN "registre" masculine ;
lin record_3_N = mkN "registre" masculine ;
lin record_2_N = mkN "registre" masculine ;
lin record_1_N = mkN "registre" masculine ;
lin manager_N = mkN "encarregat" masculine ;
lin relation_N = mkN "relació" feminine ;
lin common_A = mkA "comú" | mkA "habitual" ;
lin common_2_A = mkA "comú" | mkA "habitual" ;
lin common_1_A = mkA "comú" | mkA "habitual" ;
lin strong_A = mkA "fort" ;
lin whole_A = mkA "sencer" ;
lin field_N = mkN "camp" masculine ;
lin field_4_N = mkN "camp" masculine ;
lin field_3_N = mkN "camp" masculine ;
lin field_2_N = mkN "camp" masculine ;
lin field_1_N = mkN "camp" masculine ;
lin free_A = mkA "lliure" ;
lin break_V2 = L.break_V2 ;
lin break_V = mkV "trencar" ;
lin yesterday_Adv = mkAdv "ahir" ;
lin support_V2 = mkV2 (mkV "aguantar") ;
lin window_N = L.window_N ;
lin account_N = mkN "compte" masculine ;
lin explain_VS = mkVS (mkV "explicar") ;
lin explain_V2 = mkV2 (mkV "explicar") ;
lin stay_VA = mkVA (reflV (mkV "quedar")) ;
lin stay_V = reflV (mkV "quedar") ;
lin few_Det = S.few_Det ;
lin wait_VV = mkVV (mkV "esperar") ;
lin wait_V2 = L.wait_V2 ;
lin wait_V = mkV "esperar" ;
lin usually_Adv = mkAdv "normalment" ;
lin difference_N = mkN "diferència" feminine ;
lin material_N = mkN "material" masculine ;
lin air_N = mkN "aire" masculine ;
lin wife_N = L.wife_N ;
lin cover_V2 = mkV2 (mkV "tapar") ;
lin apply_VV = deVV (mkV "demanar") ;
lin apply_V2V = mkV2V (mkV "aplicar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin apply_V2 = mkV2 (mkV "aplicar") ; -- "apuntar-se a" "demanar" "sol·licitar" (ask for in various contexts)
lin apply_1_V2 = mkV2 (mkV "aplicar") ; -- "apuntar-se a" "demanar" "sol·licitar" (ask for in various contexts)
lin apply_2_V2 = mkV2 (mkV "aplicar") ; -- "apuntar-se a" "demanar" "sol·licitar" (ask for in various contexts)
lin apply_V = mkV "aplicar" ;
lin project_N = mkN "projecte" masculine ;
lin raise_V2 = mkV2 (mkV "augmentar") ;
lin sale_N = mkN "venta" feminine ;
lin relationship_N = mkN "relació" feminine ;
lin indeed_Adv = mkAdv "certament" ;
lin light_N = mkN "llum" feminine ; --split "llum" masculine (light vs lamp)
lin claim_VS = mkVS (mkV "afirmar") ;
lin claim_V2 = mkV2 (mkV "afirmar") ;
lin claim_V = mkV "afirmar" ;
lin form_V2 = mkV2 (mkV "formar") ;
lin form_V = mkV "formar" ;
lin base_V2 = mkV2 (mkV "basar") | mkV2 (mkV "fonamentar") ;
lin base_V = mkV "basar" | mkV "fonamentar" ;
lin care_N = mkN "cura" feminine | mkN "atenció" feminine ;
lin someone_NP = variants{} ; --TODO "algú"
lin everything_NP = S.everything_NP ;
lin certainly_Adv = mkAdv "certament" ; --subcat, would work better as "i tant que" + S
lin rule_N = L.rule_N ;
lin home_Adv = mkAdv "a casa" ; --not ideal, could be back to a country, land, etc.
lin cut_V2 = L.cut_V2 ;
lin cut_V = mkV "tallar" ;
lin grow_VA = mkVA (reflV (mkV "tornar")) ;
lin grow_V2 = mkV2 (mkV "plantar") ; --split "fer créixer"  plants vs. anything else
lin grow_V = mkV "créixer" ;
lin similar_A = mkA "semblant" ;
lin story_N = mkN "història" feminine | mkN "conte" masculine ;
lin quality_N = mkN "qualitat" feminine ;
lin tax_N = mkN "impost" masculine ;
lin worker_N = mkN "treballador" | mkN "empleat" ;
lin nature_N = mkN "natura" feminine ;
lin structure_N = mkN "estructura" feminine ;
lin data_N = mkN "dades" feminine ;
lin necessary_A = mkA "necessari" ;
lin pound_N = mkN "lliura" feminine ;
lin method_N = mkN "mètode" masculine ;
lin unit_N = mkN "unitat" feminine ;
lin unit_6_N = mkN "unitat" feminine ;
lin unit_5_N = mkN "unitat" feminine ;
lin unit_4_N = mkN "unitat" feminine ;
lin unit_3_N = mkN "unitat" feminine ;
lin unit_2_N = mkN "unitat" feminine ;
lin unit_1_N = mkN "unitat" feminine ;
lin central_A = mkA "central" | mkA "cèntric" ;
lin bed_N = mkN "llit" masculine ;
lin union_N = mkN "unió" feminine ;
lin movement_N = mkN "moviment" masculine ;
lin board_N = mkN "tauló" masculine ; --split "junta directiva" 
lin board_2_N = mkN "tauló" masculine ; --split "junta directiva" 
lin board_1_N = mkN "tauló" masculine ; --split "junta directiva" 
lin true_A = mkA "vertader" | mkA "cert" ;
lin well_Interj = mkInterj "bé" ;
lin simply_Adv = mkAdv "senzillament" ;
lin contain_V2 = mkV2 (mkV (tenir_108 "contenir")) ;
lin especially_Adv = mkAdv "especialment" | mkAdv "sobretot" ;
lin open_A = mkA "obert" ;
lin short_A = L.short_A ;
lin personal_A = mkA "personal" ;
lin detail_N = mkN "detall" masculine ;
lin model_N = mkN "model" ;
lin bear_V2 = mkV2 (mkV "suportar") | mkV2 (mkV "agunatar") ;
lin bear_V = mkV "aguantar" | mkV "suportar" ;
lin single_A = mkA "únic" ; --split "solter" (only one vs not dating anyone)
lin single_2_A =  mkA "únic" ; --split "solter" (only one vs not dating anyone)
lin single_1_A =  mkA "únic" ; --split "solter" (only one vs not dating anyone)
lin join_V2 = mkV2 (mkV "ajuntar") ;
lin join_V = mkV "ajuntar" ;
lin reduce_V2 = mkV2 (mkV (reduir_94 "reduir")) ;
lin reduce_V = mkV (reduir_94 "reduir") ;
lin establish_V2 = mkV2 (mkV (establir_53 "establir")) ;
lin wall_N = mkN "paret" masculine ;
lin face_V2 = mkV2 (reflV (mkV "enfrontar")) ParadigmsCat.dative ;
lin face_V = reflV (mkV "enfrontar") ; --subcat not possible, requires an object
lin easy_A = mkA "fàcil" ;
lin private_A = mkA "privat" ;
lin computer_N = L.computer_N ;
lin hospital_N = mkN "hospital" masculine ;
lin chapter_N = mkN "capítol" masculine ;
lin scheme_N = mkN "pla" masculine ;
lin theory_N = mkN "teoria" feminine ;
lin choose_VV = deVV (mkV "triar") ;
lin choose_V2 = mkV2 (mkV "triar") ;
lin wish_VV = mkVV (mkV (voler_120 "voler")) ;
lin wish_VS = mkVS (mkV "desitjar") ;
lin wish_V2V = mkV2V (mkV "desitjar") ParadigmsCat.accusative ParadigmsCat.genitive ; --subcat should render as VS
lin wish_V2 = mkV2 (mkV "desitjar") ;
lin wish_V = mkV "desitjar" ;
lin property_N = mkN "propietat" masculine ; --split "casa"
lin property_2_N = mkN "propietat" masculine ; --split "casa"
lin property_1_N = mkN "propietat" masculine ; --split "casa"
lin achieve_V2 = mkV2 (mkV (servir_101 "aconseguir")) ;
lin financial_A = mkA "financer" ;
lin poor_A = mkA "pobre" ;
lin poor_3_A = mkA "pobre" ;
lin poor_2_A = mkA "pobre" ;
lin poor_1_A = mkA "pobre" ;
lin officer_N = mkN "oficial" ; --split "director" (in a company) "agent de policia" (police)
lin officer_3_N = mkN "oficial" ; --split "director" (in a company) "agent de policia" (police)
lin officer_2_N = mkN "oficial" ; --split "director" (in a company) "agent de policia" (police)
lin officer_1_N = mkN "oficial" ; --split "director" (in a company) "agent de policia" (police)
lin up_Prep = mkPrep "amunt" ;
lin charge_N = mkN "cost" masculine | mkN "preu" masculine ; --split "càrrega" fem (police or military, electric charge...)
lin charge_2_N = mkN "cost" masculine | mkN "preu" masculine ; --split "càrrega" fem (police or military, electric charge...)
lin charge_1_N = mkN "cost" masculine | mkN "preu" masculine ; --split "càrrega" fem (police or military, electric charge...)
lin director_N = mkN "cost" masculine | mkN "preu" masculine ; --split "càrrega" fem (police or military, electric charge...)
lin drive_V2V = mkV2V (mkV "portar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin drive_V2 = mkV2 (mkV (reduir_94 "conduir")) ;
lin drive_V = mkV (reduir_94 "conduir") ;
lin deal_V2 = mkV2 (mkV "repartir") ; --split "encarregar-se de" (deal with a somthing)
lin deal_V = mkV "repartir" ;-- split "vendre" (drugs)
lin place_V2 = mkV2 (mkV "col·locar") ;
lin approach_N = mkN "enfocament" masculine | mkN "plantejament" masculine ;
lin chance_N = mkN "oportunitat" feminine ; --split "oportunitat" (opportunity) "atzar" (chance hhad it...) 
lin application_N = mkN "aplicació" masculine ;--split "sol·licitud" (form)
lin seek_VV = mkVV (mkV "buscar") ;
lin seek_V2 = L.seek_V2 ;
lin foreign_A = mkA "estranger" ;
lin foreign_2_A = mkA "estranger" ;
lin foreign_1_A = mkA "estranger" ;
lin along_Prep = mkPrep "al llarg de" ;
lin top_N = mkN "capdamunt" masculine ;--split (mountain)  mkN "cim" masculine ;
lin amount_N = mkN "quantitat" feminine ;
lin son_N = mkN "fill" ;
lin operation_N = mkN "operació" feminine ;
lin fail_VV = mkVV (mkV (servir_101 "aconseguir")) ; --subcat requires "no va aconseguir ..."
lin fail_V2 = mkV2 (mkV (aprendre_6 "suspendre")) ;
lin fail_V = mkV "fracassar" ;
lin human_A = mkA "humà" ;
lin opportunity_N = mkN "oportunitat" feminine | mkN "ocasió" masculine ;
lin simple_A = mkA "senzill" ;
lin leader_N = mkN "líder" | mkN "cap" ;
lin look_N = mkN "mirada" feminine ; --split "aparença" (eye look vs. general look)
lin share_N = mkN "acció" feminine ; --split "part" (stock share vs. a part of something)
lin production_N = mkN "producció" feminine ;
lin recent_A = mkA "recent" ;
lin firm_N = mkN "empresa" feminine ;
lin picture_N = mkN "dibuix" masculine ;
lin source_N = mkN "font" feminine | mkN "origen" masculine ;
lin security_N = mkN "seguretat" feminine ;
lin serve_V2 = mkV2 (mkV (servir_101 "servir")) ;
lin serve_V = mkV (servir_101 "servir") ;
lin according_to_Prep = mkPrep "segons" ;
lin end_V2 = mkV2 (mkV "acabar") ;
lin end_V = mkV "acabar" ;
lin contract_N = mkN "contracte" masculine ;
lin wide_A = L.wide_A ;
lin occur_V = mkV "passar" ;
lin agreement_N = mkN "acord" masculine ;
lin better_Adv = mkAdv "millor" ;
lin kill_V2 = L.kill_V2 ;
lin kill_V = mkV "matar" ;
lin act_V2 = mkV2 (mkV "actuar") ;
lin act_V = mkV "actuar" ;
lin site_N = mkN "lloc" masculine ;
lin either_Adv = mkAdv "tampoc" ;
lin labour_N = mkN "treball" masculine ; --split "part" masc (work vs child-birth)
lin plan_VV = mkVV (mkV "planejar") ;
lin plan_VS = mkVS (mkV "planejar") ;
lin plan_V2V = mkV2V (mkV "planificar") ParadigmsCat.accusative ParadigmsCat.dative ; --subcat should be a VS
lin plan_V2 = mkV2 (mkV "planejar") ;
lin plan_V = mkV "planejar" ;
lin various_A = mkA "diversos" ;
lin since_Prep = mkPrep "des de" ;
lin test_N = mkN "prova" feminine ; --"examen"
lin eat_V2 = L.eat_V2 ;
lin eat_V = mkV "menjar" ;
lin loss_N = mkN "pèrdua" feminine ;
lin close_V2 = L.close_V2 ;
lin close_V = mkV "tancar" ;
lin represent_V2 = mkV2 (mkV "representar") ;
lin represent_V = mkV "representar" ;
lin love_VV = mkVV (reflV (mkV "encantar")) ;
lin love_V2 = L.love_V2 ;
lin colour_N = mkN "color" masculine ;
lin clearly_Adv = mkAdv "clarament" ;
lin shop_N = L.shop_N ;
lin benefit_N = mkN "benefici" masculine ;
lin animal_N = L.animal_N ;
lin heart_N = L.heart_N ;
lin election_N = mkN "tria" feminine | mkN "elecció" feminine ; --split "eleccions" (choose vs. political elections)
lin purpose_N = mkN "finalitat" feminine ;
lin standard_N = mkN "estàndard" masculine ;
lin due_A = mkA "esperat" ; --sense cannot be conveyed by a single word
lin secretary_N = mkN "secretari" ;
lin rise_V2 = mkV2 (mkV "augmentar") ;
lin rise_V = mkV "augmentar" ;
lin date_N = mkN "data" ; --split "cita" (calendar date vs. romantic date)
lin date_7_N = mkN "data" ; --split "cita" (calendar date vs. romantic date)
lin date_3_N = mkN "data" ; --split "cita" (calendar date vs. romantic date)
lin date_3_N = mkN "data" ; --split "cita" (calendar date vs. romantic date)
lin date_1_N = mkN "data" ; --split "cita" (calendar date vs. romantic date)
lin hard_A = mkA "difícil" ; --split "dur" (difficult vs. mineral hardness)
lin hard_2_A = mkA "difícil" ; --split "dur" (difficult vs. mineral hardness)
lin hard_1_A = mkA "difícil" ; --split "dur" (difficult vs. mineral hardness)
lin music_N = L.music_N ;
lin hair_N = L.hair_N ;
lin prepare_VV = variants{} ; --TODO "estar disposat a"
lin prepare_V2V = mkV2V (mkV "preparar") ParadigmsCat.accusative (mkPrep "per") ;
lin prepare_V2 = mkV2 (mkV "preparar") ;
lin prepare_V = mkV "preparar" ;
lin factor_N = mkN "factor" masculine ;
lin anyone_NP = variants{} ; --TODO "qualsevol persona"
lin pattern_N = mkN "patró" masculine ;
lin manage_VV = mkVV (mkV (servir_101 "aconseguir")) ;
lin manage_V2 = mkV2 (mkV "gestionar") ;
lin manage_V = mkV "gestionar" ;
lin piece_N = mkN "tros" masculine ;
lin discuss_VS = mkVS (mkV (perdre_83 "debatre")) ;
lin discuss_V2 = mkV2 (mkV (perdre_83 "debatre")) ;
lin prove_VS = mkVS (mkV "demostrar") ;
lin prove_VA = mkVA (mkV "demostrar") ; --subcat "it proved hard" in English? "it proved to be"
lin prove_V2 = mkV2 (mkV "demostrar") ;
lin prove_V = mkV "demostrar" ;
lin front_N = mkN "davant" masculine ;
lin evening_N = mkN "vespre" masculine ;
lin royal_A = mkA "reial" ;
lin tree_N = L.tree_N ;
lin population_N = mkN "població" feminine ;
lin fine_A = mkA "fi" ; --split "bé" "bo"  (thin vs. good)
lin plant_N = mkN "planta" feminine ;
lin pressure_N = mkN "pressió" feminine ;
lin response_N = mkN "resposta" feminine ;
lin catch_V2 = mkV2 (mkV "agafar") ;
lin street_N = mkN "carrer" masculine ;
lin pick_V2 = mkV2 (mkV "triar") ; --split "collir" (choose vs fruit picking)
lin pick_V = mkV "triar" ;
lin performance_N = mkN "actuació" masculine ; --split "rendiment" (theatre vs. physical performance) 
lin performance_2_N = mkN "actuació" masculine ; --split "rendiment" (theatre vs. physical performance) 
lin performance_1_N = mkN "actuació" masculine ; --split "rendiment" (theatre vs. physical performance) 
lin knowledge_N = mkN "coneixement" masculine ;
lin despite_Prep = mkPrep "tot i" ;
lin design_N = mkN "disseny" masculine ;
lin page_N = mkN "pàrgina" feminine ;
lin enjoy_VV = mkVV (mkV (servir_101 "gaudir")) ;
lin enjoy_V2 = mkV2 (mkV (servir_101 "gaudir")) ParadigmsCat.genitive ;
lin individual_N = mkN "individu" masculine ;
lin suppose_VS = mkVS (mkV "suposar") ;
lin suppose_V2 = mkV2 (mkV "suposar") ;
lin rest_N = mkN "resta" feminine ;
lin instead_Adv = mkAdv "en el seu lloc" ;
lin wear_V2 = mkV2 (mkV (dur_45 "dur")) ;
lin wear_V = mkV (dur_45 "dur") ;
lin basis_N = mkN "base" feminine ;
lin size_N = mkN "mida" feminine ;
lin environment_N = mkN "entorn" masculine ;
lin per_Prep = mkPrep "per" ;
lin fire_N = L.fire_N ;
lin fire_2_N = L.fire_N ;
lin fire_1_N = L.fire_N ;
lin series_N = L.fire_N ;
lin success_N = mkN "èxit" masculine ;
lin natural_A = mkA "natural" ;
lin wrong_A = mkA "incorrecte" ;
lin near_Prep = mkPrep "a prop de" ;
lin round_Adv = mkPrep "al voltant de" ;
lin thought_N = mkN "pensament" masculine ;
lin list_N = mkN "llista" feminine ;
lin argue_VS = mkVS (mkV (servir_101 "discutir")) ;
lin argue_V2 = mkV2 (mkV (servir_101 "discutir")) ;
lin argue_V = mkV (servir_101 "discutir") ;
lin final_A = mkA "final" ;
lin future_N = mkN "futur" masculine ;
lin future_3_N = mkN "futur" masculine ;
lin future_1_N = mkN "futur" masculine ;
lin introduce_V2 = mkV2 (mkV "presentar") ;
lin analysis_N = mkN "anàlisi" feminine ;
lin enter_V2 = mkV2 (mkV "entrar") ParadigmsCat.dative ;
lin enter_V = mkV "entrar" ;
lin space_N = mkN "espai" masculine ;
lin arrive_V = mkV "arribar" ;
lin ensure_VS = mkVS (mkV "assegurar") ;
lin ensure_V2 = mkV2 (mkV "assegurar") ;
lin ensure_V = mkV "assegurar" ;
lin demand_N = mkN "petició" masculine ;
lin statement_N = mkN "declaració" feminine ;
lin to_Adv = variants{}; --TODO "pull the door to" -> "ajustar la porta", can't find any more senses
lin attention_N = mkN "atenció" feminine ;
lin love_N = L.love_N ;
lin principle_N = mkN "principi" masculine ;
lin pull_V2 = L.pull_V2 ;
lin pull_V = mkV "estirar" ;
lin set_N = mkN "col·lecció" masculine ; --split "joc" (collection vs sports set)
lin set_2_N = mkN "col·lecció" masculine ; --split "joc" (collection vs sports set)
lin set_1_N = mkN "col·lecció" masculine ; --split "joc" (collection vs sports set)
lin doctor_N = L.doctor_N ;
lin choice_N = mkN "elecció" masculine ;
lin refer_V2 = mkV2 (mkV (admetre_2 "remetre")) ParadigmsCat.dative ;
lin refer_V = mkV (admetre_2 "remtre") ;
lin feature_N = mkN "característica" feminine ;
lin couple_N = mkN "parella" feminine ;
lin step_N = mkN "esglaó" masculine ; --split "pas" masculine
lin following_A = mkA "següent" ;
lin thank_V2 = mkV2 (mkV (servir_101 "agrair")) ;
lin machine_N = mkN "màquina" masculine ;
lin income_N = mkN "ingressos" masculine ;
lin training_N = mkN "entrenament" masculine ; --split "formació" (sports vs. work training)
lin present_V2 = mkV2 (mkV "presentar") ;
lin association_N = mkN "associació" masculine ;
lin film_N = mkN "pel·lícula" feminine ;
lin film_2_N = mkN "pel·lícula" feminine ;
lin film_1_N = mkN "pel·lícula" feminine ;
lin region_N = mkN "regió" feminine ;
lin effort_N = mkN "esforç" masculine ;
lin player_N = mkN "jugador" ;
lin everyone_NP = S.everybody_NP ;
lin present_A = mkA "present" ;
lin award_N = mkN "premi" masculine ;
lin village_N = L.village_N ;
lin control_V2 = mkV2 (mkV "controlar") ;
lin organisation_N = mkN "organització" feminine ;
lin whatever_Det = mkDet "qualsevol" ;
lin news_N = mkN "notícies" feminine ;
lin nice_A = mkA "bonic" ;
lin difficulty_N = mkN "dificultat" feminine ;
lin modern_A = mkA "modern" ;
lin cell_N = mkN "cèl·lula" feminine ;
lin close_A = mkA "proper" ;
lin current_A = mkA "actual" ;
lin legal_A = mkA "legal" ;
lin energy_N = mkN "energia" feminine ;
lin finally_Adv = mkAdv "finalment" ;
lin degree_N = mkN "grau" masculine ;
lin degree_3_N = mkN "grau" masculine ;
lin degree_2_N = mkN "grau" masculine ;
lin degree_1_N = mkN "grau" masculine ;
lin mile_N = mkN "milla" feminine ;
lin means_N = mkN "mitjà" masculine ;
lin growth_N = mkN "creixement" masculine ;
lin treatment_N = mkN "tractament" masculine ;
lin sound_N = mkN "so" masculine ;
lin above_Prep = S.above_Prep ;
lin task_N = mkN "tasca" feminine ;
lin provision_N = mkN "provisió" feminine ;
lin affect_V2 = mkV2 (mkV "afectar") ;
lin please_Adv = mkAdv "siusplau" ;
lin red_A = L.red_A ;
lin happy_A = mkA "feliç" | mkA "content" ;
lin behaviour_N = mkN "comportament" masculine ;
lin concerned_A = mkA "preocupat" ;
lin point_V2 = mkV2 (mkV "assenyalar") ;
lin point_V = mkV "assenyalar" ;
lin function_N = mkN "funció" masculine ;
lin identify_V2 = mkV2 (mkV "identificar") ;
lin identify_V = mkV "identificar" ;
lin resource_N = mkN "recurs" masculine ;
lin defence_N = mkN "defensa" feminine ;
lin garden_N = L.garden_N ;
lin floor_N = L.floor_N ;
lin technology_N = mkN "tecnologia" feminine ;
lin style_N = mkN "estil" masculine ;
lin feeling_N = mkN "sentiment" masculine ;
lin science_N = L.science_N ;
lin relate_V2 = mkV2 (reflV (mkV "relacionar")) (mkPrep "amb") ;
lin relate_V = mkV "relacionar" ; --subcat? Should be "relate to" in English?
lin doubt_N = mkN "dubte" masculine ;
lin horse_N = L.horse_N ;
lin force_VS = mkVS (mkV "forçar") ; --subcat
lin force_V2V = mkV2V (mkV "obligar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin force_V2 = mkV2 (mkV "forçar") ;
lin force_V = mkV "forçar" ;
lin answer_N = mkN "resposta" feminine ;
lin compare_V = mkV "comparar" ;
lin suffer_V2 = mkV2 (mkV (sofrir_103 "sofrir")) ;
lin suffer_V = mkV (sofrir_103 "sofrir") ;
lin individual_A = mkA "individual" ;
lin forward_Adv = mkAdv "endavant" ;
lin announce_VS = mkVS (mkV "anunciar") ;
lin announce_V2 = mkV2 (mkV "anunciar") ;
lin fund_N = mkN "fons" masculine ; --split (deposit) vs. "recursos" / "finançament" (company, monetary funds)
lin character_2_N = mkN "personatge" masculine ; --split "personalitat" (character in a book vs. personality)
lin character_1_N = mkN "personatge" masculine ; --split "personalitat" (character in a book vs. personality)
lin risk_N = mkN "risc" masculine ;
lin normal_A = mkA "normal" ;
lin nor_Conj = mkConj "ni" ;
lin dog_N = L.dog_N ;
lin obtain_V2 = mkV2 (mkV (tenir_108 "obtenir")) ;
lin obtain_V = mkV (tenir_108 "obtenir") ;
lin quickly_Adv = mkAdv "ràpidament" ;
lin army_N = mkN "exèrcit" masculine ;
lin indicate_VS = mkVS (mkV "indicar") ;
lin indicate_V2 = mkV2 (mkV "indicar") ;
lin forget_VS = mkVS (mkV "oblidar") ;
lin forget_V2 = L.forget_V2 ;
lin forget_V = mkV "oblidar" ;
lin station_N = mkN "estació" masculine ;
lin glass_N = mkN "vidre" masculine ;
lin cup_N = mkN "got" masculine ;
lin previous_A = mkA "anterior" ;
lin husband_N = L.husband_N ;
lin recently_Adv = mkAdv "recenment" ;
lin publish_V2 = mkV2 (mkV "publicar") ;
lin publish_V = mkV "publicar" ;
lin serious_A = mkA "seriós" ;
lin anyway_Adv = mkAdv "de totes maneres" ;
lin visit_V2 = mkV2 (mkV "visitar") ;
lin visit_V = mkV "visitar" ;
lin capital_N = mkN "capital" feminine ; --split (city) vs. "capital" masc. (amount of money)
lin capital_3_N = mkN "capital" feminine ; --split (city) vs. "capital" masc. (amount of money)
lin capital_2_N = mkN "capital" feminine ; --split (city) vs. "capital" masc. (amount of money)
lin capital_1_N = mkN "capital" feminine ; --split (city) vs. "capital" masc. (amount of money)
lin either_Det = mkDet "o" | mkDet "o bé" ;
lin note_N = mkN "nota" feminine ; --split (small reminder), "bitllet" masc (bank note), "apunts" (longer class notes)
lin note_3_N = mkN "nota" feminine ; --split (small reminder), "bitllet" masc (bank note), "apunts" (longer class notes)
lin note_2_N = mkN "nota" feminine ; --split (small reminder), "bitllet" masc (bank note), "apunts" (longer class notes)
lin note_1_N = mkN "nota" feminine ; --split (small reminder), "bitllet" masc (bank note), "apunts" (longer class notes)
lin season_N = mkN "nota" feminine ; --split (small reminder), "bitllet" masc (bank note), "apunts" (longer class notes)
lin argument_N = mkN "discussió" feminine ;
lin listen_V = mkV "escoltar" ;
lin show_N = mkN "espectacle" masculine ;
lin responsibility_N = mkN "responsabilitat" feminine ;
lin significant_A = mkA "signifinicant" ;
lin deal_N = mkN "pacte" masculine ; --split (reach a deal) vs. "oferta" masc. (a good deal on a product) 
lin prime_A = mkA "principal" ;
lin economy_N = mkN "economia" feminine ;
lin economy_2_N = mkN "economia" feminine ;
lin economy_1_N = mkN "economia" feminine ;
lin element_N = mkN "element" masculine ;
lin finish_V2 = mkV2 (mkV "acabar") ;
lin finish_V = mkV "acabar" ;
lin duty_N = mkN "deure" masculine ;
lin fight_V2 = L.fight_V2 ;
lin fight_V = mkV "lluitar" ;
lin train_V2V = mkV2V (mkV "entrenar") ParadigmsCat.accusative (mkPrep "per") ;
lin train_V2 = mkV2 (mkV "entrenar") ;
lin train_V = mkV "entrenar" ;
lin maintain_VS = mkVS (mkV (tenir_108 "sostenir")) ;
lin maintain_V2 = mkV2 (mkV "mantenir") ;
lin maintain_V = mkV "mantenir" ;
lin attempt_N = mkN "intent" masculine ;
lin leg_N = L.leg_N ;
lin investment_N = mkN "inversió" feminine ;
lin save_V2 = mkV2 (mkV "save") ; --split ídem as underneath
lin save_V = mkV "salvar" ; --split "estalviar" (general vs. save money)
lin throughout_Prep = mkPrep "durant" ; --difficult to convey, requires adding "tot"
lin design_V2 = mkV2 (mkV "dissenyar") ;
lin design_V = mkV "dissenyar" ;
lin suddenly_Adv = mkAdv "de sobte" ;
lin brother_N = mkN "germà" masculine ;
lin improve_V2 = mkV2 (mkV "millorar") ;
lin improve_V = mkV "millorar" ;
lin avoid_VV = mkVV (mkV "evitar") ;
lin avoid_V2 = mkV2 (mkV "evitar") ;
lin wonder_VQ = L.wonder_VQ ;
lin wonder_V = reflV (mkV "preguntar") ;
lin tend_VV = aVV (mkV "acostumar") ;
lin tend_V2 = mkV2 (mkV "cuidar") ;
lin title_N = mkN "títol" masculine ;
lin hotel_N = mkN "hotel" masculine ;
lin aspect_N = mkN "aspecte" masculine ;
lin increase_N = mkN "augment" masculine ;
lin help_N = mkN "ajuda" ;
lin industrial_A = mkA "industrial" ;
lin express_V2 = mkV2 (mkV "expressar") ;
lin summer_N = mkN "estiu" masculine ;
lin determine_VV = variants{} ; --TODO "estar decidit a"
lin determine_VS = mkVS (mkV "determinar") ;
lin determine_V2V = mkV2V (mkV "determinar") ParadigmsCat.accusative (mkPrep "per") ;
lin determine_V2 = mkV2 (mkV "determinar") ;
lin determine_V = mkV "determinar" ;
lin generally_Adv = mkAdv "normalment" ;
lin daughter_N = mkN "filla" feminine ;
lin exist_V = mkV (servir_101 "existir") ;
lin share_V2 = mkV2 (mkV (servir_101 "compartir")) ;
lin share_V = mkV (servir_101 "compartir") ;
lin baby_N = L.baby_N ;
lin nearly_Adv = mkAdv "quasi" ;
lin smile_V = mkV (escriure_50 "somriure") ;
lin sorry_A = mkA "patètic" ;
lin sea_N = L.sea_N ;
lin skill_N = mkN "habilitat" feminine ;
lin claim_N = mkN "reivindicació" masculine ; --split (denounce something that should be made right) "declaració" (simple statement)
lin treat_V2 = mkV2 (mkV "tractar") ;
lin treat_V = mkV "tractar" ;
lin remove_V2 = mkV2 (mkV "eliminar") | mkV2 (mkV "retirar") ;
lin remove_V = mkV "eliminar" | mkV "retirar" ;
lin concern_N = mkN "preocupació" masculine ;
lin university_N = L.university_N ;
lin left_A = mkA "erquerra" ;
lin dead_A = mkA "mort" ;
lin discussion_N = mkN "debat" masculine ;
lin specific_A = mkA "específic" ;
lin box_N = mkN "caixa" ; --"capsa" (strong vs. flimsy box)
lin outside_Prep = mkPrep "fora" ;
lin state_VS = mkVS (mkV "declarar") ;
lin state_V2 = mkV2 (mkV "declarar") ;
lin conference_N = mkN "conferència" feminine ;
lin whole_N = mkN "tot" ;
lin total_A = mkA "total" ;
lin profit_N = mkN "benefici" masculine ;
lin division_N = mkN "divisió" masculine ;
lin division_3_N = mkN "divisió" masculine ;
lin division_2_N = mkN "divisió" masculine ;
lin division_1_N = mkN "divisió" masculine ;
lin throw_V2 = L.throw_V2 ;
lin throw_V = mkV "llençar" ;
lin procedure_N = mkN "procediment" masculine ;
lin fill_V2 = mkV2 (mkV "emplenar") ;
lin fill_V = mkV "emplenar" ;
lin king_N = L.king_N ;
lin assume_VS = mkVS (mkV (servir_101 "assumir")) ;
lin assume_V2 = mkV2 (mkV (servir_101 "assumir")) ;
lin image_N = mkN "imatge" feminine ;
lin oil_N = L.oil_N ;
lin obviously_Adv = mkAdv "clarament" ;
lin unless_Subj = mkSubj "si no és que" Indic ;
lin appropriate_A = mkA "adequat" ;
lin circumstance_N = mkN "circumstància" feminine ;
lin military_A = mkA "militar" ;
lin proposal_N = mkN "proposta" feminine ;
lin mention_VS = mkVS (mkV "mencionar") ;
lin mention_V2 = mkV2 (mkV "mencionar") ;
lin mention_V = mkV "mencionar" ;
lin client_N = mkN "client" ;
lin sector_N = mkN "sector" masculine ;
lin direction_N = mkN "direcció" masculine ;
lin admit_VS = mkVS (mkV (admetre_2 "admetre")) ;
lin admit_V2 = mkV2 (mkV (admetre_2 "admetre")) ;
lin admit_V = mkV (admetre_2 "admetre") ;
lin though_Adv = mkAdv "tot i que" ;
lin replace_V2 = mkV2 (mkV (servir_101 "substituir")) ;
lin basic_A = mkA "bàsic" ;
lin hard_Adv = mkAdv "durament" ;
lin instance_N = mkN "cas" masculine ;
lin sign_N = mkN "senyal" masculine ;
lin original_A = mkA "original" ;
lin successful_A = mkA "exitós" ;
lin okay_Adv = mkAdv "d'acord" | mkAdv "entesos" ;
lin reflect_V2 = mkV2 (mkV (servir_101 "reflectir")) ;
lin reflect_V = mkV "pensar" | mkV "reflexionar" ;
lin aware_A = mkA "conscient" ;
lin measure_N = mkN "mesura" feminine ;
lin attitude_N = mkN "actitud" feminine ;
lin disease_N = mkN "malaltia" feminine ;
lin exactly_Adv = mkAdv "exactament" ;
lin above_Adv = mkAdv "per sobre" ;
lin commission_N = mkN "comissió" feminine ;
lin intend_VV = mkVV (mkV "pensar") ;
lin beyond_Prep = mkPrep "més enllà de" ;
lin seat_N = mkN "seient" masculine ;
lin encourage_V2V = mkV2V (mkV "animar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin encourage_V2 = mkV2 (mkV "impular") ;
lin addition_N = mkN "suma" feminine ;
lin goal_N = mkN "gol" masculine ; --split "objectiu" masc (football vs. objective)
lin round_Prep = mkPrep "al voltant de" ;
lin miss_V2 = mkV2 (mkV "fallar") ; --split "enyorar"/"trobar a flatar" (hit and miss vs. miss sosomeone)
lin miss_V = mkV "fallar" ;
lin popular_A = mkA "popular" ;
lin affair_N = mkN "assumpte" masculine | mkN "afer" masculine ; --split "aventura" fem (topic vs. romantic affiar)
lin technique_N = mkN "tècnica" feminine ;
lin respect_N = mkN "respecte" masculine ;
lin drop_V2 = variants{} ; --TODO "deixar caure"
lin drop_V = mkV (caure_18 "caure") ;
lin professional_A = mkA "professional" ;
lin less_Det = mkDet "menys" ;
lin once_Subj = mkSubj "un cop" Conjunct ;
lin item_N = mkN "article" masculine ;
lin fly_V2 = mkV2 (mkV "volar") ;
lin fly_V = L.fly_V ;
lin reveal_VS = mkVS (mkV "revelar") ;
lin reveal_V2 = mkV2 (mkV "revelar") ;
lin version_N = mkN "versió" feminine ;
lin maybe_Adv = mkAdv "potser" ;
lin ability_N = mkN "habilitat" feminine ; --split "capacitat" fem (skill vs. iherent ability to do something)
lin operate_V2 = mkV2 (mkV "operar") ;
lin operate_V = mkV "operar" ;
lin good_N = mkN "bé" masculine ;
lin campaign_N = mkN "campanya" feminine ;
lin heavy_A = L.heavy_A ;
lin advice_N = mkN "consell" masculine ;
lin institution_N = mkN "instituació" feminine ;
lin discover_VS = mkVS (mkV (servir_101 "descobrir")) ;
lin discover_V2 = mkV2 (mkV (servir_101 "descobrir")) ;
lin discover_V = mkV (servir_101 "descobrir") ;
lin surface_N = mkN "superfície" feminine ;
lin library_N = mkN "biblioteca" feminine ;
lin pupil_N = mkN "alumne" ;
lin record_V2 = mkV2 (mkV "grabar") ;
lin refuse_VV = aVV (reflV (mkV "negar")) ;
lin refuse_V2 = mkV2 (mkV "rebutjar") ;
lin refuse_V = reflV (mkV "negar") ;
lin prevent_V2 = mkV2 (mkV (prevenir_88 "prevenir")) ;
lin advantage_N = mkN "avantatge" masculine ;
lin dark_A = mkA "fosc" ;
lin teach_V2V = mkV2V (mkV "ensenyar") ParadigmsCat.dative ParadigmsCat.dative ;
lin teach_V2 = L.teach_V2 ;
lin teach_V = mkV "ensenyar" ;
lin memory_N = mkN "memòria" feminine ;
lin culture_N = mkN "cultura" feminine ;
lin blood_N = L.blood_N ;
lin cost_V2 = mkV2 (mkV "costar") ;
lin cost_V = mkV "costar" ;
lin majority_N = mkN "majoria" feminine ;
lin answer_V2 = mkV2 (mkV "contestar") ;
lin answer_V = mkV "contestar" ;
lin variety_N = mkN "varietat" feminine ;
lin variety_2_N = mkN "varietat" feminine ;
lin variety_1_N = mkN "varietat" feminine ;
lin press_N = mkN "premsa" feminine ;
lin depend_V = mkV (dependre_36 "dependre") ;
lin bill_N = mkN "bitllet" masculine ; --split "llei" (bank bill vs. law)
lin competition_N = mkN "concurs" masculine ; --split "competència" (game vs. economic competition)
lin ready_A = mkA "llest" ;
lin general_N = mkN "general" ;
lin access_N = mkN "accés" masculine ;
lin hit_V2 = L.hit_V2 ;
lin hit_V = mkV (trencar_112 "picar") ;
lin stone_N = L.stone_N ;
lin useful_A = mkA "útil" ;
lin extent_N = mkN "extensió" feminine ;
lin employment_N = mkN "ocupació" feminine ;
lin regard_V2 = mkV2 (mkV "considerar") ;
lin regard_V = mkV "considerar" ;
lin apart_Adv = mkAdv "separats" ;
lin present_N = mkN "regal" masculine ;
lin appeal_N = mkN "atracció" feminine ;
lin text_N = mkN "text" masculine ;
lin parliament_N = mkN "parlament" masculine ;
lin cause_N = mkN "causa" feminine ;
lin terms_N = mkN "terme" masculine ;
lin bar_N = mkN "bar" masculine ;
lin bar_2_N = mkN "bar" masculine ;
lin bar_1_N = mkN "barrot" masculine ;
lin attack_N = mkN "atac" masculine ;
lin effective_A = mkA "efectiu" ;
lin mouth_N = L.mouth_N ;
lin down_Prep = mkPrep "avall" ;
lin result_V = mkV "resultar" ;
lin fish_N = L.fish_N ;
lin future_A = mkA "futur" ;
lin visit_N =  mkN "visita" ;
lin little_Adv = mkAdv "poc" ;
lin easily_Adv = mkAdv "fàcilment" ;
lin attempt_VV = mkVV (mkV "intentar") ;
lin attempt_V2 = mkV2 (mkV "intentar") ;
lin enable_VS = mkVS (mkV (admetre_2 "permetre")) ;
lin enable_V2V = mkV2V (mkV (admetre_2 "permetre")) ParadigmsCat.accusative ParadigmsCat.accusative ;
lin enable_V2 = mkV2 (mkV "habilitar") ;
lin trouble_N = mkN "problema" masculine ;
lin traditional_A = mkA "tradicional" ;
lin payment_N = mkN "pagament" masculine ;
lin best_Adv = mkAdv "millor" ;
lin post_N = mkN "correu" masculine ;
lin county_N = mkN "municipi" masculine ;
lin lady_N = mkN "dona" feminine ;
lin holiday_N = mkN "vacances" feminine ;
lin realize_VS = mkVS (reflV (mkV "adonar")) ;
lin realize_V2 = mkV2 (reflV (mkV "adonar")) ParadigmsCat.genitive ;
lin importance_N = mkN "importància" feminine ;
lin chair_N = L.chair_N ;
lin facility_N = mkN "facilitat" feminine ;
lin complete_V2 = mkV2 (mkV "completar") ;
lin complete_V = mkV "completar" ;
lin article_N = mkN "article" masculine ;
lin object_N = mkN "objecte" masculine ;
lin context_N = mkN "context" masculine ;
lin survey_N = mkN "enquest" feminine ;
lin notice_VS = mkVS (reflV (mkV "adonar")) ;
lin notice_V2 = mkV2 (reflV (mkV "adonar")) ParadigmsCat.genitive ;
lin complete_A = mkA "complet" ;
lin turn_N = mkN "gir" masculine ; --split "torn" (turn a car vs turn in a game)
lin direct_A = mkA "directe" ;
lin immediately_Adv = mkAdv "immediatament" ;
lin collection_N = mkN "col·lecció" feminine ;
lin reference_N = mkN "referència" feminine ;
lin card_N = mkN "targeta" feminine ;
lin interesting_A = mkA "interessant" ;
lin considerable_A = mkA "considerable" ;
lin television_N = L.television_N ;
lin extend_V2 = mkV2 (reflV (mkV (atendre_8 "estendre"))) ;
lin extend_V = reflV (mkV (atendre_8 "estendre")) ;
lin communication_N = mkN "comunicació" feminine ;
lin agency_N = mkN "agència" feminine ;
lin physical_A = mkA "físic" ;
lin except_Conj = mkConj "excepte" ;
lin check_V2 = mkV2 (mkV "comprovar") ;
lin check_V = mkV "comprovar" ;
lin sun_N = L.sun_N ;
lin species_N = mkN "espècie" feminine ;
lin possibility_N = mkN "possibilitat" feminine ;
lin chairman_N = mkN "president" ;
lin speaker_N = mkN "orador" | mkN "ponent" ;
lin second_N = mkN "segon" masculine ;
lin career_N = mkN "carrera" feminine ;
lin laugh_VS = mkVS L.laugh_V ; --subcat
lin laugh_V2 = mkV2 L.laugh_V ParadigmsCat.genitive ;
lin laugh_V = L.laugh_V ;
lin weight_N = mkN "pes" masculine ;
lin sound_VS = mkVS (mkV "sonar") ; --subcat in English?
lin sound_VA = mkVA (mkV "sonar") ;
lin sound_V2 = mkV2 (mkV "sonar") ;
lin sound_V = mkV "sonar" ;
lin responsible_A = mkA "responsable" ;
lin base_N = mkN "base" feminine ;
lin document_N = mkN "document" masculine ;
lin solution_N = mkN "sol·lució" feminine ;
lin return_N = mkN "retorn" masculine ;
lin medical_A = mkA "mèdic" ;
lin hot_A = L.hot_A ;
lin recognize_VS = mkVS (mkV (admetre_2 "admetre")) ;
lin recognize_4_V2 = mkV2 (mkV (admetre_2 "admetre")) ;
lin recognize_1_V2 = mkV2 (mkV (conèixer_27 "reconèixer")) ;
lin talk_N = mkN "parla" feminine ;
lin budget_N = mkN "pressupost" masculine ;
lin river_N = L.river_N ;
lin fit_V2 = mkV2 (mkV (cabre_13 "cabre")) ;
lin fit_V = mkV (cabre_13 "cabre") ;
lin organization_N = mkN "organizació" feminine ;
lin existing_A = mkA "existent" ;
lin start_N = mkN "començament" masculine ;
lin push_VS = mkVS (mkV (atènyer_59 "empènyer")) ; --subcat
lin push_V2V = mkV2V (mkV (atènyer_59 "empènyer")) ParadigmsCat.accusative ParadigmsCat.dative ;
lin push_V2 = L.push_V2 ;
lin push_V = mkV (atènyer_59 "empènyer") ;
lin tomorrow_Adv = mkAdv "demà" ;
lin requirement_N = mkN "requisit" masculine ;
lin cold_A = L.cold_A ;
lin edge_N = mkN "vora" feminine ;
lin opposition_N = mkN "oposició" feminine ;
lin opinion_N = mkN "opinió" feminine ;
lin drug_N = mkN "droga" feminine ;
lin quarter_N = mkN "quart" masculine ; --split "barri" masc (1/4 vs neighbourhood)
lin option_N = mkN "opció" masculine ;
lin sign_V2 = mkV2 (mkV "signar") ;
lin sign_V = mkV "signar" ;
lin worth_Prep = variants{} ; --sense? would be "valdre" V2
lin call_N = mkN "crida" feminine ;
lin define_V2 = mkV2 (mkV (servir_101 "definir")) ;
lin define_V = mkV (servir_101 "definir") ;
lin stock_N = mkN "acció" masculine ; --split "existències" fem (economic stock vs. warehouse stock)
lin influence_N = mkN "influència" feminine ;
lin occasion_N = mkN "ocasió" feminine ;
lin eventually_Adv = mkAdv "finalment" ;
lin software_N = mkN "programari" masculine ;
lin highly_Adv = mkAdv "altament" ;
lin exchange_N = mkN "intercanvi" masculine ;
lin lack_N = mkN "falta" feminine ;
lin shake_V2 = mkV2 (mkV "sacsejar") ;
lin shake_V = mkV "sacsejar" ;
lin study_V2 = mkV2 (mkV "estudiar") ;
lin study_V = mkV "estudiar" ;
lin concept_N = mkN "concepte" masculine ;
lin blue_A = L.blue_A ;
lin star_N = L.star_N ;
lin radio_N = L.radio_N ;
lin arrangement_N = mkN "acord" masculine ; --split "configuració" fem (agreement vs. placement, order, etc)
lin examine_V2 = mkV2 (mkV "examinar") ;
lin bird_N = L.bird_N ;
lin green_A = L.green_A ;
lin band_N = mkN "grup" masculine ;
lin sex_N = mkN "sexe" masculine ;
lin finger_N = mkN "dit" masculine ;
lin past_N = mkN "passat" masculine ;
lin independent_A = mkA "independent" ;
lin independent_2_A = mkA "independent" ;
lin independent_1_A = mkA "independent" ;
lin equipment_N = mkN "equipament" masculine ;
lin north_N = mkN "nord" masculine ;
lin mind_VS = mkVS (reflV (mkV "importar")) ;
lin mind_V2 = mkV2 (reflV (mkV "importar")) ; --split  "anar amb compte amb"
lin mind_V = variants{} ; --TODO sense?
lin move_N = mkN "jugada" feminine ;
lin message_N = mkN "missatge" masculine ;
lin fear_N = mkN "por" feminine ;
lin afternoon_N = mkN "tarda" feminine ;
lin drink_V2 = L.drink_V2 ;
lin drink_V = mkV (beure_11 "beure") ;
lin fully_Adv = mkAdv "completament" ;
lin race_N = mkN "cursa" feminine ;
lin race_2_N = mkN "cursa" feminine ;
lin race_1_N = mkN "raça" feminine ;
lin gain_V2 = mkV2 (mkV (obtenir_78 "obtenir_78")) ;
lin gain_V = mkV (obtenir_78 "obtenir") ;
lin strategy_N = mkN "estratègia" feminine ;
lin extra_A = mkA "extra" ;
lin scene_N = mkN "escena" feminine ; --split "escenari" masc (film scene vs. stage)
lin slightly_Adv = mkAdv "lleugerament" ;
lin kitchen_N = mkN "cuina" feminine ;
lin speech_N = mkN "discurs" masculine ;
lin arise_V = mkV (servir_101 "sorgir") ;
lin network_N = mkN "xarxa" feminine ;
lin tea_N = mkN "te" masculine ;
lin peace_N = L.peace_N ;
lin failure_N = mkN "fracàs" masculine ;
lin employee_N = mkN "empleat" masculine ;
lin ahead_Adv = mkAdv "per davant" ;
lin scale_N = mkN "escala" feminine ;
lin hardly_Adv = mkAdv "gairebé" ;
lin attend_V2 = mkV2 (mkV (servir_101 "assistir")) ;
lin attend_V = mkV (servir_101 "assistir") ;
lin shoulder_N = mkN "espatlla" feminine ;
lin otherwise_Adv = mkAdv "si no" ;
lin railway_N = mkN "ferrocarril" masculine ;
lin directly_Adv = mkAdv "directament" ;
lin supply_N = mkN "oferta" feminine ;
lin expression_N = mkN "expressió" feminine ;
lin owner_N = mkN "propietari" ;
lin associate_V2 = mkV2 (mkV "associar") ;
lin associate_V = mkV "associar" ;
lin corner_N = mkN "racó" masculine ;
lin past_A = mkA "passat" ;
lin match_N = mkN "coincidència" feminine ;
lin match_3_N = mkN "coincidència" feminine ;
lin match_2_N = mkN "misto" masculine ;
lin match_1_N = mkN "partit" masculine ;
lin sport_N = mkN "esport" masculine ;
lin status_N = mkN "estat" masculine ;
lin beautiful_A = L.beautiful_A ;
lin offer_N = mkN "oferta" feminine ;
lin marriage_N = mkN "casament" masculine ;
lin hang_V2 = mkV2 (mkV "penjar") ;
lin hang_V = mkV "penjar" ;
lin civil_A = mkA "civil" ;
lin perform_V2 = mkV2 (mkV "representar") ; -- split "realitzar" "fer" (acting vs. do)
lin perform_V = mkV "representar" ; --split same as above
lin sentence_N = mkN "oració" feminine ;
lin crime_N = mkN "crim" masculine ;
lin ball_N = mkN "pilota" feminine ;
lin marry_V2 = mkV2 (reflV (mkV "casar")) (mkPrep "amb") ;
lin marry_V = reflV (mkV "casar") ;
lin wind_N = L.wind_N ;
lin truth_N = mkN "veritat" feminine ;
lin protect_V2 = mkV2 (mkV (servir_101 "protegir")) ;
lin protect_V = mkV (servir_101 "protegir") ;
lin safety_N = mkN "seguretat" feminine ;
lin partner_N = mkN "parella" feminine ; --split "soci" (romantic vs. business)
lin completely_Adv = mkAdv "completament" ;
lin copy_N = mkN "còpia" feminine ;
lin balance_N = mkN "equilibri" masculine ;
lin sister_N = L.sister_N ;
lin reader_N = mkN "lector" ;
lin below_Adv = mkAdv "sota" ;
lin trial_N = mkN "assaig" masculine ; --split "judici" masc (test vs. court)
lin rock_N = L.rock_N ;
lin damage_N = mkN "desperfecte" masculine ;
lin adopt_V2 = mkV2 (mkV "adoptar") ;
lin newspaper_N = L.newspaper_N ;
lin meaning_N = mkN "sentit" masculine ;
lin light_A = mkA "lluminós" ;
lin essential_A = mkA "essencial" ;
lin obvious_A = mkA "obvi" ;
lin nation_N = mkN "nació" feminine ;
lin confirm_VS = mkVS (mkV "confirmar") ;
lin confirm_V2 = mkV2 (mkV "confirmar") ;
lin south_N = mkN "sud" masculine ;
lin length_N = mkN "llargada" feminine ;
lin branch_N = mkN "branca" feminine ;
lin deep_A = mkA "profund" ;
lin none_NP = variants{} ; --TODO "cap"
lin planning_N = mkN "planificació" feminine ;
lin trust_N = mkN "confiança" feminine ;
lin working_A = mkA "treballador" ;
lin pain_N = mkN "dolor" masculine ;
lin studio_N = mkN "estudi" masculine ;
lin positive_A = mkA "positiu" ;
lin spirit_N = mkN "esperit" masculine ;
lin college_N = mkN "universitat" masculine ;
lin accident_N = mkN "accident" masculine ;
lin star_V2 = mkV2 (mkV "protagonitzar") ;
lin hope_N = mkN "esperança" feminine ;
lin mark_V3 = mkV3 (mkV "marcar") ParadigmsCat.accusative (mkPrep "amb") ;
lin mark_V2 = mkV2 (mkV "marcar") ;
lin works_N = mkN "feina" feminine ;
lin league_N = mkN "lliga" feminine ;
lin league_2_N = mkN "lliga" feminine ;
lin league_1_N = mkN "lliga" feminine ;
lin clear_V2 = mkV2 (mkV "buidar") ;
lin clear_V = mkV "buidar" ; --cannot be translated as a single word, requires more context
lin imagine_VS = mkVS (mkV "imaginar") ;
lin imagine_V2 = mkV2 (mkV "imaginar") ;
lin imagine_V = mkV "imaginar" ;
lin through_Adv = mkAdv "a través de" ;
lin cash_N = mkN "efectiu" masculine ;
lin normally_Adv = mkAdv "normalment" ;
lin play_N = compN (mkN "obra") "de teatre" ;
lin strength_N = mkN "força" feminine ;
lin train_N = L.train_N ;
lin travel_V2 = mkV2 (mkV "viatjar") ;
lin travel_V = L.travel_V ;
lin target_N = mkN "objectiu" masculine ;
lin very_A = mkA "molt" ;
lin pair_N = mkN "parell" masculine ;
lin male_A = mkA "mascle" ;
lin gas_N = mkN "gas" masculine ;
lin issue_V2 = mkV2 (mkV (servir_101 "expedir")) ;
lin issue_V = mkV (servir_101 "expedir") ;
lin contribution_N = mkN "contribució" feminine ;
lin complex_A = mkA "complex" ;
lin supply_V2 = mkV2 (mkV (lluir_64 "proveir")) ;
lin beat_V2 = mkV2 (mkV "derrotar") ; --split
lin beat_V = mkV "derrotar" ; --split "pegar" (win vs. hit)
lin artist_N = mkN "artista" ;
lin presence_N = mkN "presència" feminine ;
lin along_Adv = mkAdv "al llarg de" ;
lin environmental_A = mkA "mediambiental" ;
lin strike_V2 = mkV2 (mkV "pegar") ;
lin strike_V = mkV "pegar" ;
lin contact_N = mkN "contacte" masculine ;
lin protection_N = mkN "protecció" masculine ;
lin beginning_N = mkN "inici" masculine ;
lin demand_VS = mkVS (mkV (servir_101 "exigir")) ;
lin demand_V2 = mkV2 (mkV (servir_101 "exigir")) ;
lin media_N = compN (mkN "mitjà") "de comunicació" ;
lin relevant_A = mkA "rellevant" ;
lin employ_V2 = mkV2 (mkV "contractar") ;
lin shoot_V2 = mkV2 (mkV "disparar") ;
lin shoot_V = mkV "disparar" ;
lin executive_N = mkN "executiu" ;
lin slowly_Adv = mkAdv "a poc a poc" ;
lin relatively_Adv = mkAdv "relativament" ;
lin aid_N = mkN "ajuda" feminine ;
lin huge_A = mkA "immens" ;
lin late_Adv = mkAdv "tard" ;
lin speed_N = mkN "velocitat" feminine ;
lin review_N = mkN "ressenya" feminine ;
lin test_V2 = mkV2 (mkV "provar") ;
lin order_VS = mkVS (mkV "ordenar") ;
lin order_V2V = mkV2V (mkV "ordenar") ParadigmsCat.accusative ParadigmsCat.dative ; --subcat "va ordenar a algú que fes X"
lin order_V2 = mkV2 (mkV "ordenar") ;
lin order_V = mkV "ordenar" ;
lin route_N = mkN "ruta" feminine ;
lin consequence_N = mkN "conseqüència" ;
lin telephone_N = mkN "telèfon" masculine ;
lin release_V2 = mkV2 (mkV "alliberar") ;
lin proportion_N = mkN "proporció" feminine ;
lin primary_A = mkA "primari" ;
lin consideration_N = mkN "consideració" feminine ;
lin reform_N = mkN "reforma" feminine ;
lin annual_A = mkA "anual" ;
lin nuclear_A = mkA "nuclear" ;
lin latter_A = mkA "segon" | mkA "últim" ; --"the latter" -> els segons, els últims
lin practical_A = mkA "pràctic" ;
lin commercial_A = mkA "comercial" ;
lin rich_A = mkA "ric" ;
lin emerge_V = mkV (servir_101 "sorgir") ;
lin apparently_Adv = mkAdv "es veu que" ;--TODO right functions?
lin ring_V = mkV "trucar" ;
lin ring_6_V2 = variants{} ; -- no verb for this, "col·locar una anella"
lin ring_4_V2 = mkV2 (mkV "trucar") ParadigmsCat.dative ;
lin distance_N = mkN "distància" feminine ;
lin exercise_N = mkN "exercici" masculine ;
lin key_A = mkA "clau" ;
lin close_Adv = mkAdv "a prop" ;
lin skin_N = L.skin_N ;
lin island_N = mkN "illa" feminine ;
lin separate_A = mkA "separat" ;
lin aim_VV = mkVV (mkV (atendre_8 "pretendre")) ;
lin aim_V2 = mkV2 (mkV "apuntar") ;
lin aim_V = mkV "apuntar" ;
lin danger_N = mkN "perill" masculine ;
lin credit_N = mkN "crèdit" masculine ;
lin usual_A = mkA "normal" ;
lin link_V2 = mkV2 (mkV "enllaçar") ;
lin link_V = mkV "enllaçar" ;
lin track_N = mkN "via" feminine ; --split "petjada" (train vs. foot)
lin safe_A = mkA "segur" ;
lin interested_A = mkA "interessat" ;
lin assessment_N = mkN "avaluació" feminine ;
lin path_N = mkN "camí" masculine ;
lin merely_Adv = mkAdv "merament" ;
lin plus_Prep = mkPrep "més" ;
lin district_N = mkN "districte" masculine ;
lin regular_A = mkA "regular" ;
lin reaction_N = mkN "reacció" feminine ;
lin impact_N = mkN "impacte" masculine ;
lin collect_V2 = mkV2 (mkV "col·leccionar") ;
lin collect_V = mkV "col·leccionar" ;
lin debate_N = mkN "debat" ;
lin lay_V2 = mkV2 (mkV "estirar") ;
lin lay_V = mkV "estirar" ;
lin rise_N = mkN "augment" ;
lin belief_N = mkN "creença" feminine ;
lin conclusion_N = mkN "conclusció" feminine ;
lin shape_N = mkN "forma" feminine ;
lin vote_N = mkN "vot" masculine ;
lin aim_N = mkN "objectiu" ;
lin politics_N = mkN "política" feminine ;
lin reply_VS = mkVS (mkV "contestar") ;
lin reply_V = mkV "contestar" ;
lin press_V2V = variants{} ; --TODO "donar presses perquè fes X" 
lin press_V2 = mkV2 (mkV "apretar") ;
lin press_V = mkV "apretar" ;
lin approach_V2 = mkV2 (mkV "acostar") ;
lin approach_V = mkV "acostar" ;
lin file_N = mkN "arxiu" masculine ;
lin western_A = mkA "occidental" ;
lin earth_N = L.earth_N ;
lin public_N = mkN "públic" masculine ;
lin survive_V2 = mkV2 (mkV (viure_119 "sobreviure")) ;
lin survive_V = mkV (viure_119 "sobreviure") ;
lin estate_N = mkN "patrimoni" masculine ;
lin boat_N = L.boat_N ;
lin prison_N = mkN "presó" feminine ;
lin additional_A = mkA "addicional" ;
lin settle_V2 = mkV2 (mkV (absoldre_1 "resoldre")) ;
lin settle_V = mkV (absoldre_1 "resoldre") ; --split "calmar-se" (settle a dispute vs. settle down)
lin largely_Adv = mkAdv "principalment" ;
lin wine_N = L.wine_N ;
lin observe_VS = mkVS (mkV "observar") ;
lin observe_V2 = mkV2 (mkV "observar") ;
lin limit_V2V = mkV2V (mkV "limitar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin limit_V2 = mkV2 (mkV "limitar") ;
lin deny_V3 = dirdirV3 (mkV "negar") ;
lin deny_V2 = mkV2 (mkV "negar") ;
lin for_PConj = ss "per a" ;
lin straight_Adv = mkAdv "directe" ;
lin somebody_NP = S.somebody_NP ;
lin writer_N = mkN "escriptor" ;
lin weekend_N = compN (mkN "cap") "de setmana" ;
lin clothes_N = mkN "roba" feminine ;
lin active_A = mkA "actiu" ;
lin sight_N = mkN "vista" feminine ;
lin video_N = mkN "vídeo" masculine ;
lin reality_N = mkN "realitat" feminine ;
lin hall_N = mkN "vestíbul" masculine ;
lin nevertheless_Adv = mkAdv "tot i això" ;
lin regional_A = mkA "regional" ;
lin vehicle_N = mkN "vehicle" ; 
lin worry_VS = variants{} ; --structure has to be inverted "he worried that X" "X preocupava a ell"
lin worry_V2 = mkV2 (reflV (mkV "preocupar")) ParadigmsCat.genitive ;
lin worry_V = reflV (mkV "preocupar") ;
lin powerful_A = mkA "poderós" ;
lin possibly_Adv = mkAdv "possiblement" ;
lin cross_V2 = mkV2 (mkV "creuar") ;
lin cross_V = mkV "creuar" ;
lin colleague_N = mkN "company" ;
lin charge_V2 = mkV2 (mkV "carregar") ;
lin charge_V = mkV "carregar" ;
lin lead_N = mkN "plom" masculine ;
lin farm_N = mkN "granja" feminine ;
lin respond_VS = mkVS (mkV "contestar") ;
lin respond_V = mkV "contestar" ;
lin employer_N = mkN "cap" ;
lin carefully_Adv = mkAdv "amb compte" ;
lin understanding_N = mkN "entesa" feminine ;
lin connection_N = mkN "connexió" feminine ;
lin comment_N = mkN "comentari" masculine ;
lin grant_V3 = dirdirV3 (mkV (servir_101 "concedir")) ;
lin grant_V2 = mkV2 (mkV (servir_101 "concedir")) ;
lin concentrate_V2 = mkV2 (mkV "concentrar") ;
lin concentrate_V = mkV "concentrar" ;
lin ignore_V2 = mkV2 (mkV "ignorar") ;
lin ignore_V = mkV "ignorar" ;
lin phone_N = mkN "telèfon" masculine ;
lin hole_N = mkN "forat" masculine ;
lin insurance_N = mkN "assegurança" ;
lin content_N = mkN "contingut" masculine ;
lin confidence_N = mkN "confiança" feminine ;
lin sample_N = mkN "mostra" feminine ;
lin transport_N = mkN "transport" masculine ;
lin objective_N = mkN "objectiu" masculine ;
lin alone_A = mkA "sol" ;
lin flower_N = L.flower_N ;
lin injury_N = mkN "lesió" feminine ;
lin lift_V2 = mkV2 (mkV "aixecar") ;
lin lift_V = mkV "aixecar" ;
lin stick_V2 = mkV2 (mkV "enganxar") ;
lin stick_V = mkV "enganxar" ;
lin front_A = mkA "devanter" ;
lin mainly_Adv = mkAdv "principalment" ;
lin battle_N = mkN "batalla" feminine ;
lin generation_N = mkN "generació" feminine ;
lin currently_Adv = mkAdv "actualment" ;
lin winter_N = mkN "hivern" masculine ;
lin inside_Prep = mkPrep "dins" ;
lin impossible_A = mkA "impossible" ;
lin somewhere_Adv = S.somewhere_Adv ;
lin arrange_V2 = mkV2 (mkV "organitzar") ;
lin arrange_V = mkV "organitzar" ;
lin will_N = mkN "voluntat" feminine ; --split "testament" (the will to do vs. last will and testament)
lin sleep_V = L.sleep_V ;
lin progress_N = mkN "progrés" masculine ;
lin volume_N = mkN "volum" masculine ;
lin ship_N = L.ship_N ;
lin legislation_N = mkN "legislació" feminine ;
lin commitment_N = mkN "compromís" masculine ;
lin enough_Predet = variants{} ; --TODO "suficients"
lin conflict_N = mkN "conflicte" masculine ;
lin bag_N = mkN "bossa" feminine ;
lin fresh_A = mkA "fresc" ;
lin entry_N = mkN "entrada" feminine ;
lin entry_2_N = mkN "entrada" feminine ;
lin entry_1_N = mkN "entrada" feminine ;
lin smile_N = mkN "somriure" masculine ;
lin fair_A = mkA "just" ;
lin promise_VV = mkVV (mkV (admetre_2 "prometre")) ;
lin promise_VS = mkVS (mkV (admetre_2 "prometre")) ;
lin promise_V2 = mkV2 (mkV (admetre_2 "prometre")) ;
lin promise_V = mkV (admetre_2 "prometre") ;
lin introduction_N = mkN "introducció" feminine ;
lin senior_A = mkA "superior" ;
lin manner_N = mkN "comportament" masculine ;
lin background_N = mkN "fons" masculine ;
lin key_N = mkN "clau" feminine ;
lin key_2_N = mkN "clau" feminine ;
lin key_1_N = mkN "clau" feminine ;
lin touch_V2 = mkV2 (mkV "tocar") ;
lin touch_V = mkV "tocar" ;
lin vary_V2 = mkV2 (mkV "variar") ;
lin vary_V = mkV "variar" ;
lin sexual_A = mkA "sexual" ;
lin ordinary_A = mkA "comú" ;
lin cabinet_N = mkN "armari" masculine ;
lin painting_N = mkN "quadre" masculine ;
lin entirely_Adv = mkAdv "completament" ;
lin engine_N = mkN "motor" masculine ;
lin previously_Adv = mkAdv "prèviament" ;
lin administration_N = mkN "administració" ;
lin tonight_Adv = mkAdv "aquesta nit" ;
lin adult_N = mkN "adult" masculine ;
lin prefer_VV = mkVV (mkV (servir_101 "preferir")) ;
lin prefer_V2 = mkV2 (mkV (servir_101 "preferir")) ;
lin author_N = mkN "autor" ;
lin actual_A = mkA "actual" ;
lin song_N = L.song_N ;
lin investigation_N = mkN "investigació" feminine ;
lin debt_N = mkN "deute" masculine ;
lin visitor_N = mkN "visitant" ;
lin forest_N = mkN "bosc" masculine ;
lin repeat_VS = mkVS (mkV (servir_101 "repetir")) ;
lin repeat_V2 = mkV2 (mkV (servir_101 "repetir")) ;
lin repeat_V = mkV (servir_101 "repetir") ;
lin wood_N = L.wood_N ;
lin contrast_N = mkN "contrast" masculine ;
lin extremely_Adv = mkAdv "extremadament" ;
lin wage_N = mkN "sou" masculine ;
lin domestic_A = mkA "domèstic" ;
lin commit_V2 = mkV2 (mkV (admetre_2 "cometre")) ;
lin threat_N = mkN "amenaça" feminine ;
lin bus_N = mkN "autobús" masculine ;
lin warm_A = L.warm_A ;
lin sir_N = mkN "senyor" masculine ;
lin regulation_N = mkN "regulació" masculine ;
lin drink_N = mkN "beguda" feminine ;
lin relief_N = mkN "alleujament" masculine ;
lin internal_A = mkA "intern" ;
lin strange_A = mkA "estrany" ;
lin excellent_A = mkA "excel·lent" ;
lin run_N = mkN "cursa" feminine ;
lin fairly_Adv = mkAdv "justament" ;
lin technical_A = mkA "tècnic" ;
lin tradition_N = mkN "tradició" feminine ;
lin measure_V2 = mkV2 (mkV "mesurar") ;
lin measure_V = mkV "mesurar" ;
lin insist_VS = mkVS (mkV (servir_101 "insistir")) ;
lin insist_V2 = mkV2 (mkV (servir_101 "insistir")) (mkPrep "en") ;
lin insist_V = mkV (servir_101 "insistir") ;
lin farmer_N = mkN "pagès" ;
lin until_Prep = mkPrep "fins a" ;
lin traffic_N = mkN "trànsit" masculine ;
lin dinner_N = mkN "sopar" masculine ;
lin consumer_N = mkN "consumidor" ;
lin meal_N = mkN "àpat" masculine ;
lin warn_VS = mkVS (mkV "avisar") ;
lin warn_V2V = mkV2V (mkV "avisar") ParadigmsCat.accusative ParadigmsCat.genitive ;
lin warn_V2 = mkV2 (mkV "avisar") ;
lin warn_V = mkV "avisar" ;
lin living_A = mkA "vivent" ;
lin package_N = mkN "paquet" masculine ;
lin half_N = mkN "mig" masculine ;
lin increasingly_Adv = mkAdv "cada cop més" ;
lin description_N = mkN "descripció" feminine ;
lin soft_A = mkA "tou" ;
lin stuff_N = mkN "coses" ; --TODO always plural
lin award_V3 = dirdirV3 (mkV "atorgar") ;
lin award_V2 = mkV2 (mkV "atorgar") ;
lin existence_N = mkN "existència" feminine ;
lin improvement_N = mkN "millora" feminine ;
lin coffee_N = mkN "cafè" masculine ;
lin appearance_N = mkN "aspecte" masculine ;
lin standard_A = mkA "estàndard" ;
lin attack_V2 = mkV2 (mkV "atacar") ;
lin sheet_N = mkN "llençol" masculine ; --split "full" (bed sheets vs. paper sheets)
lin category_N = mkN "categoria" feminine ;
lin distribution_N = mkN "distribució" feminine ;
lin equally_Adv = mkAdv "igualment" ;
lin session_N = mkN "sessió" feminine ;
lin cultural_A = mkA "cultural" ;
lin loan_N = mkN "préstec" masculine ;
lin bind_V2 = mkV2 (mkV (servir_101 "unir")) ;
lin bind_V = mkV (servir_101 "unir") ;
lin museum_N = mkN "museu" masculine ;
lin conversation_N = mkN "conversa" feminine ;
lin threaten_VV = deVV (mkV "amenaçar") ;
lin threaten_VS = mkVS (mkV "amenaçar") ;
lin threaten_V2 = mkV2 (mkV "amenaçar") ;
lin threaten_V = mkV "amenaçar" ;
lin link_N = mkN "enllaç" masculine ;
lin launch_V2 = mkV2 (mkV "llançar") ;
lin launch_V = mkV "llançar" ;
lin proper_A = mkA "adequat" ;
lin victim_N = mkN "víctima" feminine ;
lin audience_N = mkN "públic" masculine ;
lin famous_A = mkA "famós" ;
lin master_N = mkN "mestre" ;
lin master_2_N = mkN "director" ;
lin master_1_N = mkN "amo" ;
lin lip_N = mkN "llavi" masculine ;
lin religious_A = mkA "religiós" ;
lin joint_A = mkA "conjunt" ;
lin cry_V2 = mkV2 (mkV "cridar") ;
lin cry_V = mkV "plorar" ;
lin potential_A = mkA "potencial" ;
lin broad_A = L.broad_A ;
lin exhibition_N = mkN "exposició" feminine ;
lin experience_V2 = mkV2 (mkV "experimentar") ;
lin judge_N = mkN "jutge" ;
lin formal_A = mkA "formal" ; --DVH 31/08/2014
lin housing_N = variants{} ; --
lin past_Prep = variants{} ; --
lin concern_V2 = variants{} ; --
lin freedom_N = variants{} ; --
lin gentleman_N = variants{} ; --
lin attract_V2 = variants{} ; --
lin explanation_N = variants{} ; --
lin appoint_V3 = variants{} ; --
lin appoint_V2V = variants{} ; --
lin appoint_V2 = variants{} ; --
lin note_VS = variants{} ; --
lin note_V2 = variants{} ; --
lin note_V = variants{} ; --
lin chief_A = variants{} ; --
lin total_N = variants{} ; --
lin lovely_A = variants{} ; --
lin official_A = variants{} ; --
lin date_V2 = variants{} ; --
lin date_V = variants{} ; --
lin demonstrate_VS = variants{} ; --
lin demonstrate_V2 = variants{} ; --
lin demonstrate_V = variants{} ; --
lin construction_N = variants{} ; --
lin middle_N = variants{} ; --
lin yard_N = variants{} ; --
lin unable_A = variants{} ; --
lin acquire_V2 = variants{} ; --
lin surely_Adv = variants{} ; --
lin crisis_N = variants{} ; --
lin propose_VV = variants{} ; --
lin propose_VS = variants{} ; --
lin propose_V2 = variants{} ; --
lin propose_V = variants{} ; --
lin west_N = variants{} ; --
lin impose_V2 = variants{} ; --
lin impose_V = variants{} ; --
lin market_V2 = variants{} ; --
lin market_V = variants{} ; --
lin care_V = variants{} ; --
lin god_N = variants{} ; --
lin favour_N = variants{} ; --
lin before_Adv = variants{}; -- S.before_Prep ;
lin name_V3 = variants{} ; --
lin name_V2 = variants{} ; --
lin equal_A = variants{} ; --
lin capacity_N = variants{} ; --
lin flat_N = variants{} ; --
lin selection_N = variants{} ; --
lin alone_Adv = variants{} ; --
lin football_N = variants{} ; --
lin victory_N = variants{} ; --
lin factory_N = L.factory_N ;
lin rural_A = variants{} ; --
lin twice_Adv = variants{} ; --
lin sing_V2 = variants{}; -- L.sing_V ;
lin sing_V = L.sing_V ;
lin whereas_Subj = variants{} ; --
lin own_V2 = variants{} ; --
lin head_V2 = variants{} ; --
lin head_V = variants{} ; --
lin examination_N = variants{} ; --
lin deliver_V2 = variants{} ; --
lin deliver_V = variants{} ; --
lin nobody_NP = S.nobody_NP ;
lin substantial_A = variants{} ; --
lin invite_V2V = variants{} ; --
lin invite_V2 = variants{} ; --
lin intention_N = variants{} ; --
lin egg_N = L.egg_N ;
lin reasonable_A = variants{} ; --
lin onto_Prep = variants{} ; --
lin retain_V2 = variants{} ; --
lin aircraft_N = variants{} ; --
lin decade_N = variants{} ; --
lin cheap_A = variants{} ; --
lin quiet_A = variants{} ; --
lin bright_A = variants{} ; --
lin contribute_V2 = variants{} ; --
lin contribute_V = variants{} ; --
lin row_N = variants{} ; --
lin search_N = variants{} ; --
lin limit_N = variants{} ; --
lin definition_N = variants{} ; --
lin unemployment_N = variants{} ; --
lin spread_V2 = variants{} ; --
lin spread_V = variants{} ; --
lin mark_N = variants{} ; --
lin flight_N = variants{} ; --
lin account_V2 = variants{} ; --
lin account_V = variants{} ; --
lin output_N = variants{} ; --
lin last_V = variants{} ; --
lin tour_N = variants{} ; --
lin address_N = variants{} ; --
lin immediate_A = variants{} ; --
lin reduction_N = variants{} ; --
lin interview_N = variants{} ; --
lin assess_V2 = variants{} ; --
lin promote_V2 = variants{} ; --
lin promote_V = variants{} ; --
lin everybody_NP = S.everybody_NP ;
lin suitable_A = variants{} ; --
lin growing_A = variants{} ; --
lin nod_V = variants{} ; --
lin reject_V2 = variants{} ; --
lin while_N = variants{} ; --
lin high_Adv = variants{} ; --
lin dream_N = variants{} ; --
lin vote_VV = variants{} ; --
lin vote_V3 = variants{} ; --
lin vote_V2 = variants{} ; --
lin vote_V = variants{} ; --
lin divide_V2 = variants{} ; --
lin divide_V = variants{} ; --
lin declare_VS = variants{} ; --
lin declare_V2 = variants{} ; --
lin declare_V = variants{} ; --
lin handle_V2 = variants{} ; --
lin handle_V = variants{} ; --
lin detailed_A = variants{} ; --
lin challenge_N = variants{} ; --
lin notice_N = variants{} ; --
lin rain_N = L.rain_N ;
lin destroy_V2 = variants{} ; --
lin mountain_N = L.mountain_N ;
lin concentration_N = variants{} ; --
lin limited_A = variants{} ; --
lin finance_N = variants{} ; --
lin pension_N = variants{} ; --
lin influence_V2 = variants{} ; --
lin afraid_A = variants{} ; --
lin murder_N = variants{} ; --
lin neck_N = L.neck_N ;
lin weapon_N = variants{} ; --
lin hide_V2 = variants{} ; --
lin hide_V = variants{} ; --
lin offence_N = variants{} ; --
lin absence_N = variants{} ; --
lin error_N = variants{} ; --
lin enterprise_N = variants{} ; --
lin criticism_N = variants{} ; --
lin average_A = variants{} ; --
lin quick_A = variants{} ; --
lin sufficient_A = variants{} ; --
lin appointment_N = variants{} ; --
lin match_V2 = variants{} ; --
lin transfer_V = variants{} ; --
lin acid_N = variants{} ; --
lin spring_N = variants{} ; --
lin birth_N = variants{} ; --
lin ear_N = L.ear_N ;
lin recommend_V2V = variants{} ; --
lin recommend_V2 = variants{} ; --
lin module_N = variants{} ; --
lin instruction_N = variants{} ; --
lin democratic_A = variants{} ; --
lin park_N = variants{} ; --
lin weather_N = variants{} ; --
lin bottle_N = variants{} ; --
lin address_V2 = variants{} ; --
lin bedroom_N = variants{} ; --
lin kid_N = variants{} ; --
lin pleasure_N = variants{} ; --
lin assembly_N = variants{} ; --
lin expensive_A = variants{} ; --
lin select_VV = variants{} ; --
lin select_V2V = variants{} ; --
lin select_V2 = variants{} ; --
lin select_V = variants{} ; --
lin teaching_N = variants{} ; --
lin desire_N = variants{} ; --
lin whilst_Subj = variants{} ; --
lin contact_V2 = variants{} ; --
lin implication_N = variants{} ; --
lin combine_VV = variants{} ; --
lin combine_V2 = variants{} ; --
lin combine_V = variants{} ; --
lin temperature_N = variants{} ; --
lin wave_N = variants{} ; --
lin magazine_N = variants{} ; --
lin totally_Adv = variants{} ; --
lin mental_A = variants{} ; --
lin used_A = variants{} ; --
lin store_N = variants{} ; --
lin scientific_A = variants{} ; --
lin frequently_Adv = variants{} ; --
lin thanks_N = variants{} ; --
lin beside_Prep = variants{} ; --
lin settlement_N = variants{} ; --
lin absolutely_Adv = variants{} ; --
lin critical_A = variants{} ; --
lin critical_2_A = variants{} ; --
lin critical_1_A = variants{} ; --
lin recognition_N = variants{} ; --
lin touch_N = variants{} ; --
lin consist_V = variants{} ; --
lin below_Prep = variants{} ; --
lin silence_N = variants{} ; --
lin expenditure_N = variants{} ; --
lin institute_N = variants{} ; --
lin dress_V2 = variants{} ; --
lin dress_V = variants{} ; --
lin dangerous_A = variants{} ; --
lin familiar_A = variants{} ; --
lin asset_N = variants{} ; --
lin educational_A = variants{} ; --
lin sum_N = variants{} ; --
lin publication_N = variants{} ; --
lin partly_Adv = variants{} ; --
lin block_N = variants{} ; --
lin seriously_Adv = variants{} ; --
lin youth_N = variants{} ; --
lin tape_N = variants{} ; --
lin elsewhere_Adv = variants{} ; --
lin cover_N = variants{} ; --
lin fee_N = variants{} ; --
lin program_N = variants{} ; --
lin treaty_N = variants{} ; --
lin necessarily_Adv = variants{} ; --
lin unlikely_A = variants{} ; --
lin properly_Adv = variants{} ; --
lin guest_N = variants{} ; --
lin code_N = variants{} ; --
lin hill_N = L.hill_N ;
lin screen_N = variants{} ; --
lin household_N = variants{} ; --
lin sequence_N = variants{} ; --
lin correct_A = L.correct_A ;
lin female_A = variants{} ; --
lin phase_N = variants{} ; --
lin crowd_N = variants{} ; --
lin welcome_V2 = variants{} ; --
lin metal_N = variants{} ; --
lin human_N = variants{} ; --
lin widely_Adv = variants{} ; --
lin undertake_V2 = variants{} ; --
lin cut_N = variants{} ; --
lin sky_N = L.sky_N ;
lin brain_N = variants{} ; --
lin expert_N = variants{} ; --
lin experiment_N = variants{} ; --
lin tiny_A = variants{} ; --
lin perfect_A = variants{} ; --
lin disappear_V = variants{} ; --
lin initiative_N = variants{} ; --
lin assumption_N = variants{} ; --
lin photograph_N = variants{} ; --
lin ministry_N = variants{} ; --
lin congress_N = variants{} ; --
lin transfer_N = variants{} ; --
lin reading_N = variants{} ; --
lin scientist_N = variants{} ; --
lin fast_Adv = variants{} ; --
lin fast_A = variants{} ; --
lin closely_Adv = variants{} ; --
lin thin_A = L.thin_A ;
lin secure_V2 = variants{} ; --
lin plate_N = variants{} ; --
lin pool_N = variants{} ; --
lin gold_N = L.gold_N ;
lin emphasis_N = variants{} ; --
lin recall_VS = variants{} ; --
lin recall_V2 = variants{} ; --
lin shout_V2 = variants{} ; --
lin shout_V = variants{} ; --
lin generate_V2 = variants{} ; --
lin location_N = variants{} ; --
lin display_VS = variants{} ; --
lin display_V2 = variants{} ; --
lin heat_N = variants{} ; --
lin gun_N = variants{} ; --
lin shut_V2 = variants{} ; --
lin journey_N = variants{} ; --
lin imply_VS = variants{} ; --
lin imply_V2 = variants{} ; --
lin imply_V = variants{} ; --
lin violence_N = variants{} ; --
lin dry_A = L.dry_A ;
lin historical_A = variants{} ; --
lin step_V2 = variants{} ; --
lin step_V = variants{} ; --
lin curriculum_N = variants{} ; --
lin noise_N = variants{} ; --
lin lunch_N = variants{} ; --
lin fear_VS = L.fear_VS ;
lin fear_V2 = L.fear_V2 ;
lin fear_V = variants{}; -- L.fear_V2 ;
lin succeed_V2 = variants{} ; --
lin succeed_V = variants{} ; --
lin fall_N = variants{} ; --
lin fall_2_N = variants{} ; --
lin fall_1_N = variants{} ; --
lin bottom_N = variants{} ; --
lin initial_A = variants{} ; --
lin theme_N = variants{} ; --
lin characteristic_N = variants{} ; --
lin pretty_Adv = variants{} ; --
lin empty_A = L.empty_A ;
lin display_N = variants{} ; --
lin combination_N = variants{} ; --
lin interpretation_N = variants{} ; --
lin rely_V2 = variants{} ; --
lin rely_V = variants{} ; --
lin escape_VS = variants{} ; --
lin escape_V2 = variants{} ; --
lin escape_V = variants{} ; --
lin score_V2 = variants{} ; --
lin score_V = variants{} ; --
lin justice_N = variants{} ; --
lin upper_A = variants{} ; --
lin tooth_N = L.tooth_N ;
lin organize_V2V = variants{} ; --
lin organize_V2 = variants{} ; --
lin cat_N = L.cat_N ;
lin tool_N = variants{} ; --
lin spot_N = variants{} ; --
lin bridge_N = variants{} ; --
lin double_A = variants{} ; --
lin direct_V2 = variants{} ; --
lin direct_V = variants{} ; --
lin conclude_VS = variants{} ; --
lin conclude_V2 = variants{} ; --
lin conclude_V = variants{} ; --
lin relative_A = variants{} ; --
lin soldier_N = variants{} ; --
lin climb_V2 = variants{} ; --
lin climb_V = variants{} ; --
lin breath_N = variants{} ; --
lin afford_V2V = variants{} ; --
lin afford_V2 = variants{} ; --
lin urban_A = variants{} ; --
lin nurse_N = variants{} ; --
lin narrow_A = L.narrow_A ;
lin liberal_A = variants{} ; --
lin coal_N = variants{} ; --
lin priority_N = variants{} ; --
lin wild_A = variants{} ; --
lin revenue_N = variants{} ; --
lin membership_N = variants{} ; --
lin grant_N = variants{} ; --
lin approve_V2 = variants{} ; --
lin approve_V = variants{} ; --
lin tall_A = variants{} ; --
lin apparent_A = variants{} ; --
lin faith_N = variants{} ; --
lin under_Adv = variants{}; -- S.under_Prep ;
lin fix_V2 = variants{} ; --
lin fix_V = variants{} ; --
lin slow_A = variants{} ; --
lin troop_N = variants{} ; --
lin motion_N = variants{} ; --
lin leading_A = variants{} ; --
lin component_N = variants{} ; --
lin bloody_A = variants{} ; --
lin literature_N = variants{} ; --
lin conservative_A = variants{} ; --
lin variation_N = variants{} ; --
lin remind_V2 = variants{} ; --
lin inform_V2 = variants{} ; --
lin inform_V = variants{} ; --
lin alternative_N = variants{} ; --
lin neither_Adv = variants{} ; --
lin outside_Adv = variants{} ; --
lin mass_N = variants{} ; --
lin busy_A = variants{} ; --
lin chemical_N = variants{} ; --
lin careful_A = variants{} ; --
lin investigate_V2 = variants{} ; --
lin investigate_V = variants{} ; --
lin roll_V2 = variants{} ; --
lin roll_V = variants{} ; --
lin instrument_N = variants{} ; --
lin guide_N = variants{} ; --
lin criterion_N = variants{} ; --
lin pocket_N = variants{} ; --
lin suggestion_N = variants{} ; --
lin aye_Interj = variants{} ; --
lin entitle_VS = variants{} ; --
lin entitle_V2V = variants{} ; --
lin tone_N = variants{} ; --
lin attractive_A = variants{} ; --
lin wing_N = L.wing_N ;
lin surprise_N = variants{} ; --
lin male_N = variants{} ; --
lin ring_N = variants{} ; --
lin pub_N = variants{} ; --
lin fruit_N = L.fruit_N ;
lin passage_N = variants{} ; --
lin illustrate_VS = variants{} ; --
lin illustrate_V2 = variants{} ; --
lin illustrate_V = variants{} ; --
lin pay_N = variants{} ; --
lin ride_V2 = variants{} ; --
lin ride_V = variants{} ; --
lin foundation_N = variants{} ; --
lin restaurant_N = L.restaurant_N ;
lin vital_A = variants{} ; --
lin alternative_A = variants{} ; --
lin burn_V2 = variants{}; -- L.burn_V ;
lin burn_V = L.burn_V ;
lin map_N = variants{} ; --
lin united_A = variants{} ; --
lin device_N = variants{} ; --
lin jump_V2 = variants{}; -- L.jump_V ;
lin jump_V = L.jump_V ;
lin estimate_VS = variants{} ; --
lin estimate_V2V = variants{} ; --
lin estimate_V2 = variants{} ; --
lin estimate_V = variants{} ; --
lin conduct_V2 = variants{} ; --
lin conduct_V = variants{} ; --
lin derive_V2 = variants{} ; --
lin derive_V = variants{} ; --
lin comment_VS = variants{} ; --
lin comment_V2 = variants{} ; --
lin comment_V = variants{} ; --
lin east_N = variants{} ; --
lin advise_VS = variants{} ; --
lin advise_V2 = variants{} ; --
lin advise_V = variants{} ; --
lin advance_N = variants{} ; --
lin motor_N = variants{} ; --
lin satisfy_V2 = variants{} ; --
lin hell_N = variants{} ; --
lin winner_N = variants{} ; --
lin effectively_Adv = variants{} ; --
lin mistake_N = variants{} ; --
lin incident_N = variants{} ; --
lin focus_V2 = variants{} ; --
lin focus_V = variants{} ; --
lin exercise_VV = variants{} ; --
lin exercise_V2 = variants{} ; --
lin exercise_V = variants{} ; --
lin representation_N = variants{} ; --
lin release_N = variants{} ; --
lin leaf_N = L.leaf_N ;
lin border_N = variants{} ; --
lin wash_V2 = L.wash_V2 ;
lin wash_V = variants{}; -- L.wash_V2 ;
lin prospect_N = variants{} ; --
lin blow_V2 = variants{}; -- L.blow_V ;
lin blow_V = L.blow_V ;
lin trip_N = variants{} ; --
lin observation_N = variants{} ; --
lin gather_V2 = variants{} ; --
lin gather_V = variants{} ; --
lin ancient_A = variants{} ; --
lin brief_A = variants{} ; --
lin gate_N = variants{} ; --
lin elderly_A = variants{} ; --
lin persuade_V2V = variants{} ; --
lin persuade_V2 = variants{} ; --
lin overall_A = variants{} ; --
lin rare_A = variants{} ; --
lin index_N = variants{} ; --
lin hand_V2 = variants{} ; --
lin circle_N = variants{} ; --
lin creation_N = variants{} ; --
lin drawing_N = variants{} ; --
lin anybody_NP = variants{} ; --
lin flow_N = variants{} ; --
lin matter_V = variants{} ; --
lin external_A = variants{} ; --
lin capable_A = variants{} ; --
lin recover_V = variants{} ; --
lin shot_N = variants{} ; --
lin request_N = variants{} ; --
lin impression_N = variants{} ; --
lin neighbour_N = variants{} ; --
lin theatre_N = variants{} ; --
lin beneath_Prep = variants{} ; --
lin hurt_V2 = variants{} ; --
lin hurt_V = variants{} ; --
lin mechanism_N = variants{} ; --
lin potential_N = variants{} ; --
lin lean_V2 = variants{} ; --
lin lean_V = variants{} ; --
lin defendant_N = variants{} ; --
lin atmosphere_N = variants{} ; --
lin slip_V2 = variants{} ; --
lin slip_V = variants{} ; --
lin chain_N = variants{} ; --
lin accompany_V2 = variants{} ; --
lin wonderful_A = variants{} ; --
lin earn_V2 = variants{} ; --
lin earn_V = variants{} ; --
lin enemy_N = L.enemy_N ;
lin desk_N = variants{} ; --
lin engineering_N = variants{} ; --
lin panel_N = variants{} ; --
lin distinction_N = variants{} ; --
lin deputy_N = variants{} ; --
lin discipline_N = variants{} ; --
lin strike_N = variants{} ; --
lin strike_2_N = variants{} ; --
lin strike_1_N = variants{} ; --
lin married_A = variants{} ; --
lin plenty_NP = variants{} ; --
lin establishment_N = variants{} ; --
lin fashion_N = variants{} ; --
lin roof_N = L.roof_N ;
lin milk_N = L.milk_N ;
lin entire_A = variants{} ; --
lin tear_N = variants{} ; --
lin secondary_A = variants{} ; --
lin finding_N = variants{} ; --
lin welfare_N = variants{} ; --
lin increased_A = variants{} ; --
lin attach_V2 = variants{} ; --
lin attach_V = variants{} ; --
lin typical_A = variants{} ; --
lin typical_3_A = variants{} ; --
lin typical_2_A = variants{} ; --
lin typical_1_A = variants{} ; --
lin meanwhile_Adv = variants{} ; --
lin leadership_N = variants{} ; --
lin walk_N = variants{} ; --
lin negotiation_N = variants{} ; --
lin clean_A = L.clean_A ;
lin religion_N = L.religion_N ;
lin count_V2 = L.count_V2 ;
lin count_V = variants{}; -- L.count_V2 ;
lin grey_A = variants{} ; --
lin hence_Adv = variants{} ; --
lin alright_Adv = variants{} ; --
lin first_A = variants{} ; --
lin fuel_N = variants{} ; --
lin mine_N = variants{} ; --
lin appeal_V = variants{} ; --
lin liability_N = variants{} ; --
lin constant_A = variants{} ; --
lin hate_VV = variants{}; -- L.hate_V2 ;
lin hate_V2 = L.hate_V2 ;
lin shoe_N = L.shoe_N ;
lin expense_N = variants{} ; --
lin vast_A = variants{} ; --
lin soil_N = variants{} ; --
lin writing_N = variants{} ; --
lin nose_N = L.nose_N ;
lin origin_N = variants{} ; --
lin lord_N = variants{} ; --
lin rest_V2 = variants{} ; --
lin drive_N = variants{} ; --
lin ticket_N = variants{} ; --
lin editor_N = variants{} ; --
lin switch_V2 = variants{} ; --
lin switch_V = variants{} ; --
lin provided_Subj = variants{} ; --
lin northern_A = variants{} ; --
lin significance_N = variants{} ; --
lin channel_N = variants{} ; --
lin convention_N = variants{} ; --
lin damage_V2 = variants{} ; --
lin funny_A = variants{} ; --
lin bone_N = L.bone_N ;
lin severe_A = variants{} ; --
lin search_V2 = variants{} ; --
lin search_V = variants{} ; --
lin iron_N = L.iron_N ;
lin vision_N = variants{} ; --
lin via_Prep = variants{} ; --
lin somewhat_Adv = variants{} ; --
lin inside_Adv = variants{} ; --
lin trend_N = variants{} ; --
lin revolution_N = variants{} ; --
lin terrible_A = variants{} ; --
lin knee_N = L.knee_N ;
lin dress_N = variants{} ; --
lin unfortunately_Adv = variants{} ; --
lin steal_V2 = variants{} ; --
lin steal_V = variants{} ; --
lin criminal_A = variants{} ; --
lin signal_N = variants{} ; --
lin notion_N = variants{} ; --
lin comparison_N = variants{} ; --
lin academic_A = variants{} ; --
lin outcome_N = variants{} ; --
lin lawyer_N = variants{} ; --
lin strongly_Adv = variants{} ; --
lin surround_V2 = variants{} ; --
lin explore_VS = variants{} ; --
lin explore_V2 = variants{} ; --
lin achievement_N = variants{} ; --
lin odd_A = variants{} ; --
lin expectation_N = variants{} ; --
lin corporate_A = variants{} ; --
lin prisoner_N = variants{} ; --
lin question_V2 = variants{} ; --
lin rapidly_Adv = variants{} ; --
lin deep_Adv = variants{} ; --
lin southern_A = variants{} ; --
lin amongst_Prep = variants{} ; --
lin withdraw_V2 = variants{} ; --
lin withdraw_V = variants{} ; --
lin afterwards_Adv = variants{} ; --
lin paint_V2 = variants{}; -- L.paint_V2A ; -- comment=CHECKED
lin paint_V = variants{}; -- L.paint_V2A ; -- comment=CHECKED
lin judge_VS = variants{} ; --
lin judge_V2 = variants{} ; --
lin judge_V = variants{} ; --
lin permanent_A = variants{} ; --
lin weak_A = variants{} ; --
lin separate_V2 = variants{} ; --
lin separate_V = variants{} ; --
lin plastic_N = L.plastic_N ;
lin connect_V2 = variants{} ; --
lin connect_V = variants{} ; --
lin fundamental_A = variants{} ; --
lin plane_N = variants{} ; --
lin height_N = variants{} ; --
lin opening_N = variants{} ; --
lin lesson_N = variants{} ; --
lin similarly_Adv = variants{} ; --
lin shock_N = variants{} ; --
lin rail_N = variants{} ; --
lin tenant_N = variants{} ; --
lin owe_V2 = variants{} ; --
lin owe_V = variants{} ; --
lin originally_Adv = variants{} ; --
lin middle_A = variants{} ; --
lin somehow_Adv = variants{} ; --
lin minor_A = variants{} ; --
lin negative_A = variants{} ; --
lin knock_V2 = variants{} ; --
lin knock_V = variants{} ; --
lin root_N = L.root_N ;
lin pursue_V2 = variants{} ; --
lin pursue_V = variants{} ; --
lin inner_A = variants{} ; --
lin crucial_A = variants{} ; --
lin occupy_V2 = variants{} ; --
lin occupy_V = variants{} ; --
lin that_AdA = variants{} ; --
lin independence_N = variants{} ; --
lin column_N = variants{} ; --
lin proceeding_N = variants{} ; --
lin female_N = variants{} ; --
lin beauty_N = variants{} ; --
lin perfectly_Adv = variants{} ; --
lin struggle_N = variants{} ; --
lin gap_N = variants{} ; --
lin house_V2 = variants{} ; --
lin database_N = variants{} ; --
lin stretch_V2 = variants{} ; --
lin stretch_V = variants{} ; --
lin stress_N = variants{} ; --
lin passenger_N = variants{} ; --
lin boundary_N = variants{} ; --
lin easy_Adv = variants{} ; --
lin view_V2 = variants{} ; --
lin manufacturer_N = variants{} ; --
lin sharp_A = L.sharp_A ;
lin formation_N = variants{} ; --
lin queen_N = L.queen_N ;
lin waste_N = variants{} ; --
lin virtually_Adv = variants{} ; --
lin expand_V2 = variants{} ; --
lin expand_V = variants{} ; --
lin contemporary_A = variants{} ; --
lin politician_N = variants{} ; --
lin back_V = variants{} ; --
lin territory_N = variants{} ; --
lin championship_N = variants{} ; --
lin exception_N = variants{} ; --
lin thick_A = L.thick_A ;
lin inquiry_N = variants{} ; --
lin topic_N = variants{} ; --
lin resident_N = variants{} ; --
lin transaction_N = variants{} ; --
lin parish_N = variants{} ; --
lin supporter_N = variants{} ; --
lin massive_A = variants{} ; --
lin light_V2 = variants{} ; --
lin light_V = variants{} ; --
lin unique_A = variants{} ; --
lin challenge_V2 = variants{} ; --
lin challenge_V = variants{} ; --
lin inflation_N = variants{} ; --
lin assistance_N = variants{} ; --
lin list_V2V = variants{} ; --
lin list_V2 = variants{} ; --
lin list_V = variants{} ; --
lin identity_N = variants{} ; --
lin suit_V2 = variants{} ; --
lin suit_V = variants{} ; --
lin parliamentary_A = variants{} ; --
lin unknown_A = variants{} ; --
lin preparation_N = variants{} ; --
lin elect_V3 = variants{} ; --
lin elect_V2V = variants{} ; --
lin elect_V2 = variants{} ; --
lin elect_V = variants{} ; --
lin badly_Adv = variants{} ; --
lin moreover_Adv = variants{} ; --
lin tie_V2 = L.tie_V2 ;
lin tie_V = variants{}; -- L.tie_V2 ;
lin cancer_N = variants{} ; --
lin champion_N = variants{} ; --
lin exclude_V2 = variants{} ; --
lin review_V2 = variants{} ; --
lin review_V = variants{} ; --
lin licence_N = variants{} ; --
lin breakfast_N = variants{} ; --
lin minority_N = variants{} ; --
lin appreciate_V2 = variants{} ; --
lin appreciate_V = variants{} ; --
lin fan_N = variants{} ; --
lin fan_3_N = variants{} ; --
lin fan_2_N = variants{} ; --
lin fan_1_N = variants{} ; --
lin chief_N = variants{} ; --
lin accommodation_N = variants{} ; --
lin subsequent_A = variants{} ; --
lin democracy_N = variants{} ; --
lin brown_A = L.brown_A ;
lin taste_N = variants{} ; --
lin crown_N = variants{} ; --
lin permit_V2V = variants{} ; --
lin permit_V2 = variants{} ; --
lin permit_V = variants{} ; --
lin gift_N = variants{} ; --
lin resolution_N = variants{} ; --
lin angry_A = variants{} ; --
lin metre_N = variants{} ; --
lin wheel_N = variants{} ; --
lin clause_N = variants{} ; --
lin break_N = variants{} ; --
lin tank_N = variants{} ; --
lin benefit_V2 = variants{} ; --
lin benefit_V = variants{} ; --
lin engage_V2 = variants{} ; --
lin engage_V = variants{} ; --
lin alive_A = variants{} ; --
lin complaint_N = variants{} ; --
lin inch_N = variants{} ; --
lin firm_A = variants{} ; --
lin abandon_V2 = variants{} ; --
lin blame_V2 = variants{} ; --
lin blame_V = variants{} ; --
lin clean_V2 = variants{} ; --
lin clean_V = variants{} ; --
lin quote_V2 = variants{} ; --
lin quote_V = variants{} ; --
lin quantity_N = variants{} ; --
lin rule_VS = variants{} ; --
lin rule_V2 = variants{} ; --
lin rule_V = variants{} ; --
lin guilty_A = variants{} ; --
lin prior_A = variants{} ; --
lin round_A = L.round_A ;
lin eastern_A = variants{} ; --
lin coat_N = L.coat_N ;
lin involvement_N = variants{} ; --
lin tension_N = variants{} ; --
lin diet_N = variants{} ; --
lin enormous_A = variants{} ; --
lin score_N = variants{} ; --
lin rarely_Adv = variants{} ; --
lin prize_N = variants{} ; --
lin remaining_A = variants{} ; --
lin significantly_Adv = variants{} ; --
lin glance_V2 = variants{} ; --
lin glance_V = variants{} ; --
lin dominate_V2 = variants{} ; --
lin dominate_V = variants{} ; --
lin trust_VS = variants{} ; --
lin trust_V2 = variants{} ; --
lin naturally_Adv = variants{} ; --
lin interpret_V2 = variants{} ; --
lin interpret_V = variants{} ; --
lin land_V2 = variants{} ; --
lin land_V = variants{} ; --
lin frame_N = variants{} ; --
lin extension_N = variants{} ; --
lin mix_V2 = variants{} ; --
lin mix_V = variants{} ; --
lin spokesman_N = variants{} ; --
lin friendly_A = variants{} ; --
lin acknowledge_VS = variants{} ; --
lin acknowledge_V2 = variants{} ; --
lin register_V2 = variants{} ; --
lin register_V = variants{} ; --
lin regime_N = variants{} ; --
lin regime_2_N = variants{} ; --
lin regime_1_N = variants{} ; --
lin fault_N = variants{} ; --
lin dispute_N = variants{} ; --
lin grass_N = L.grass_N ;
lin quietly_Adv = variants{} ; --
lin decline_N = variants{} ; --
lin dismiss_V2 = variants{} ; --
lin delivery_N = variants{} ; --
lin complain_VS = variants{} ; --
lin complain_V = variants{} ; --
lin conservative_N = variants{} ; --
lin shift_V2 = variants{} ; --
lin shift_V = variants{} ; --
lin port_N = variants{} ; --
lin beach_N = variants{} ; --
lin string_N = variants{} ; --
lin depth_N = variants{} ; --
lin unusual_A = variants{} ; --
lin travel_N = variants{} ; --
lin pilot_N = variants{} ; --
lin obligation_N = variants{} ; --
lin gene_N = variants{} ; --
lin yellow_A = L.yellow_A ;
lin republic_N = variants{} ; --
lin shadow_N = variants{} ; --
lin dear_A = variants{} ; --
lin analyse_V2 = variants{} ; --
lin anywhere_Adv = variants{} ; --
lin average_N = variants{} ; --
lin phrase_N = variants{} ; --
lin long_term_A = variants{} ; --
lin crew_N = variants{} ; --
lin lucky_A = variants{} ; --
lin restore_V2 = variants{} ; --
lin convince_V2V = variants{} ; --
lin convince_V2 = variants{} ; --
lin coast_N = variants{} ; --
lin engineer_N = variants{} ; --
lin heavily_Adv = variants{} ; --
lin extensive_A = variants{} ; --
lin glad_A = variants{} ; --
lin charity_N = variants{} ; --
lin oppose_V2 = variants{} ; --
lin oppose_V = variants{} ; --
lin defend_V2 = variants{} ; --
lin alter_V2 = variants{} ; --
lin alter_V = variants{} ; --
lin warning_N = variants{} ; --
lin arrest_V2 = variants{} ; --
lin framework_N = variants{} ; --
lin approval_N = variants{} ; --
lin bother_VV = variants{} ; --
lin bother_V2V = variants{} ; --
lin bother_V2 = variants{} ; --
lin bother_V = variants{} ; --
lin novel_N = variants{} ; --
lin accuse_V2 = variants{} ; --
lin surprised_A = variants{} ; --
lin currency_N = variants{} ; --
lin restrict_V2 = variants{} ; --
lin restrict_V = variants{} ; --
lin possess_V2 = variants{} ; --
lin moral_A = variants{} ; --
lin protein_N = variants{} ; --
lin distinguish_V2 = variants{} ; --
lin distinguish_V = variants{} ; --
lin gently_Adv = variants{} ; --
lin reckon_VS = variants{} ; --
lin incorporate_V2 = variants{} ; --
lin proceed_V = variants{} ; --
lin assist_V2 = variants{} ; --
lin assist_V = variants{} ; --
lin sure_Adv = variants{} ; --
lin stress_VS = variants{} ; --
lin stress_V2 = variants{} ; --
lin justify_VV = variants{} ; --
lin justify_V2 = variants{} ; --
lin behalf_N = variants{} ; --
lin councillor_N = variants{} ; --
lin setting_N = variants{} ; --
lin command_N = variants{} ; --
lin command_2_N = variants{} ; --
lin command_1_N = variants{} ; --
lin maintenance_N = variants{} ; --
lin stair_N = variants{} ; --
lin poem_N = variants{} ; --
lin chest_N = variants{} ; --
lin like_Adv = variants{} ; --
lin secret_N = variants{} ; --
lin restriction_N = variants{} ; --
lin efficient_A = variants{} ; --
lin suspect_VS = variants{} ; --
lin suspect_V2 = variants{} ; --
lin hat_N = L.hat_N ;
lin tough_A = variants{} ; --
lin firmly_Adv = variants{} ; --
lin willing_A = variants{} ; --
lin healthy_A = variants{} ; --
lin focus_N = variants{} ; --
lin construct_V2 = variants{} ; --
lin occasionally_Adv = variants{} ; --
lin mode_N = variants{} ; --
lin saving_N = variants{} ; --
lin comfortable_A = variants{} ; --
lin camp_N = variants{} ; --
lin trade_V2 = variants{} ; --
lin trade_V = variants{} ; --
lin export_N = variants{} ; --
lin wake_V2 = variants{} ; --
lin wake_V = variants{} ; --
lin partnership_N = variants{} ; --
lin daily_A = variants{} ; --
lin abroad_Adv = variants{} ; --
lin profession_N = variants{} ; --
lin load_N = variants{} ; --
lin countryside_N = variants{} ; --
lin boot_N = L.boot_N ;
lin mostly_Adv = variants{} ; --
lin sudden_A = variants{} ; --
lin implement_V2 = variants{} ; --
lin reputation_N = variants{} ; --
lin print_V2 = variants{} ; --
lin print_V = variants{} ; --
lin calculate_VS = variants{} ; --
lin calculate_V2 = variants{} ; --
lin calculate_V = variants{} ; --
lin keen_A = variants{} ; --
lin guess_VS = variants{} ; --
lin guess_V2 = variants{} ; --
lin guess_V = variants{} ; --
lin recommendation_N = variants{} ; --
lin autumn_N = variants{} ; --
lin conventional_A = variants{} ; --
lin cope_V = variants{} ; --
lin constitute_V2 = variants{} ; --
lin poll_N = variants{} ; --
lin voluntary_A = variants{} ; --
lin valuable_A = variants{} ; --
lin recovery_N = variants{} ; --
lin cast_V2 = variants{} ; --
lin cast_V = variants{} ; --
lin premise_N = variants{} ; --
lin resolve_V2 = variants{} ; --
lin resolve_V = variants{} ; --
lin regularly_Adv = variants{} ; --
lin solve_V2 = variants{} ; --
lin plaintiff_N = variants{} ; --
lin critic_N = variants{} ; --
lin agriculture_N = variants{} ; --
lin ice_N = L.ice_N ;
lin constitution_N = variants{} ; --
lin communist_N = variants{} ; --
lin layer_N = variants{} ; --
lin recession_N = variants{} ; --
lin slight_A = variants{} ; --
lin dramatic_A = variants{} ; --
lin golden_A = variants{} ; --
lin temporary_A = variants{} ; --
lin suit_N = variants{} ; --
lin shortly_Adv = variants{} ; --
lin initially_Adv = variants{} ; --
lin arrival_N = variants{} ; --
lin protest_N = variants{} ; --
lin resistance_N = variants{} ; --
lin silent_A = variants{} ; --
lin presentation_N = variants{} ; --
lin soul_N = variants{} ; --
lin self_N = variants{} ; --
lin judgment_N = variants{} ; --
lin feed_V2 = variants{} ; --
lin feed_V = variants{} ; --
lin muscle_N = variants{} ; --
lin shareholder_N = variants{} ; --
lin opposite_A = variants{} ; --
lin pollution_N = variants{} ; --
lin wealth_N = variants{} ; --
lin video_taped_A = variants{} ; --
lin kingdom_N = variants{} ; --
lin bread_N = L.bread_N ;
lin perspective_N = variants{} ; --
lin camera_N = L.camera_N ;
lin prince_N = variants{} ; --
lin illness_N = variants{} ; --
lin cake_N = variants{} ; --
lin meat_N = L.meat_N ;
lin submit_V2 = variants{} ; --
lin submit_V = variants{} ; --
lin ideal_A = variants{} ; --
lin relax_V2 = variants{} ; --
lin relax_V = variants{} ; --
lin penalty_N = variants{} ; --
lin purchase_V2 = variants{} ; --
lin tired_A = variants{} ; --
lin beer_N = L.beer_N ;
lin specify_VS = variants{} ; --
lin specify_V2 = variants{} ; --
lin specify_V = variants{} ; --
lin short_Adv = variants{} ; --
lin monitor_V2 = variants{} ; --
lin monitor_V = variants{} ; --
lin electricity_N = variants{} ; --
lin specifically_Adv = variants{} ; --
lin bond_N = variants{} ; --
lin statutory_A = variants{} ; --
lin laboratory_N = variants{} ; --
lin federal_A = variants{} ; --
lin captain_N = variants{} ; --
lin deeply_Adv = variants{} ; --
lin pour_V2 = variants{} ; --
lin pour_V = variants{} ; --
lin boss_N = L.boss_N ;
lin creature_N = variants{} ; --
lin urge_VS = variants{} ; --
lin urge_V2V = variants{} ; --
lin urge_V2 = variants{} ; --
lin locate_V2 = variants{} ; --
lin locate_V = variants{} ; --
lin being_N = variants{} ; --
lin struggle_VV = variants{} ; --
lin struggle_V = variants{} ; --
lin lifespan_N = variants{} ; --
lin flat_A = variants{} ; --
lin valley_N = variants{} ; --
lin like_A = variants{} ; --
lin guard_N = variants{} ; --
lin emergency_N = variants{} ; --
lin dark_N = variants{} ; --
lin bomb_N = variants{} ; --
lin dollar_N = variants{} ; --
lin efficiency_N = variants{} ; --
lin mood_N = variants{} ; --
lin convert_V2 = variants{} ; --
lin convert_V = variants{} ; --
lin possession_N = variants{} ; --
lin marketing_N = variants{} ; --
lin please_VV = variants{} ; --
lin please_V2V = variants{} ; --
lin please_V2 = variants{} ; --
lin please_V = variants{} ; --
lin habit_N = variants{} ; --
lin subsequently_Adv = variants{} ; --
lin round_N = variants{} ; --
lin purchase_N = variants{} ; --
lin sort_V2 = variants{} ; --
lin sort_V = variants{} ; --
lin outside_A = variants{} ; --
lin gradually_Adv = variants{} ; --
lin expansion_N = variants{} ; --
lin competitive_A = variants{} ; --
lin cooperation_N = variants{} ; --
lin acceptable_A = variants{} ; --
lin angle_N = variants{} ; --
lin cook_V2 = variants{} ; --
lin cook_V = variants{} ; --
lin net_A = variants{} ; --
lin sensitive_A = variants{} ; --
lin ratio_N = variants{} ; --
lin kiss_V2 = variants{} ; --
lin amount_V = variants{} ; --
lin sleep_N = variants{} ; --
lin finance_V2 = variants{} ; --
lin essentially_Adv = variants{} ; --
lin fund_V2 = variants{} ; --
lin preserve_V2 = variants{} ; --
lin wedding_N = variants{} ; --
lin personality_N = variants{} ; --
lin bishop_N = variants{} ; --
lin dependent_A = variants{} ; --
lin landscape_N = variants{} ; --
lin pure_A = variants{} ; --
lin mirror_N = variants{} ; --
lin lock_V2 = variants{} ; --
lin lock_V = variants{} ; --
lin symptom_N = variants{} ; --
lin promotion_N = variants{} ; --
lin global_A = variants{} ; --
lin aside_Adv = variants{} ; --
lin tendency_N = variants{} ; --
lin conservation_N = variants{} ; --
lin reply_N = variants{} ; --
lin estimate_N = variants{} ; --
lin qualification_N = variants{} ; --
lin pack_V2 = variants{} ; --
lin pack_V = variants{} ; --
lin governor_N = variants{} ; --
lin expected_A = variants{} ; --
lin invest_V2 = variants{} ; --
lin invest_V = variants{} ; --
lin cycle_N = variants{} ; --
lin alright_A = variants{} ; --
lin philosophy_N = variants{} ; --
lin gallery_N = variants{} ; --
lin sad_A = variants{} ; --
lin intervention_N = variants{} ; --
lin emotional_A = variants{} ; --
lin advertising_N = variants{} ; --
lin regard_N = variants{} ; --
lin dance_V2 = variants{} ; --
lin dance_V = variants{} ; --
lin cigarette_N = variants{} ; --
lin predict_VS = variants{} ; --
lin predict_V2 = variants{} ; --
lin adequate_A = variants{} ; --
lin variable_N = variants{} ; --
lin net_N = variants{} ; --
lin retire_V2 = variants{} ; --
lin retire_V = variants{} ; --
lin sugar_N = variants{} ; --
lin pale_A = variants{} ; --
lin frequency_N = variants{} ; --
lin guy_N = variants{} ; --
lin feature_V2 = variants{} ; --
lin furniture_N = variants{} ; --
lin administrative_A = variants{} ; --
lin wooden_A = variants{} ; --
lin input_N = variants{} ; --
lin phenomenon_N = variants{} ; --
lin surprising_A = variants{} ; --
lin jacket_N = variants{} ; --
lin actor_N = variants{} ; --
lin actor_2_N = variants{} ; --
lin actor_1_N = variants{} ; --
lin kick_V2 = variants{} ; --
lin kick_V = variants{} ; --
lin producer_N = variants{} ; --
lin hearing_N = variants{} ; --
lin chip_N = variants{} ; --
lin equation_N = variants{} ; --
lin certificate_N = variants{} ; --
lin hello_Interj = variants{} ; --
lin remarkable_A = variants{} ; --
lin alliance_N = variants{} ; --
lin smoke_V2 = variants{} ; --
lin smoke_V = variants{} ; --
lin awareness_N = variants{} ; --
lin throat_N = variants{} ; --
lin discovery_N = variants{} ; --
lin festival_N = variants{} ; --
lin dance_N = variants{} ; --
lin promise_N = variants{} ; --
lin rose_N = variants{} ; --
lin principal_A = variants{} ; --
lin brilliant_A = variants{} ; --
lin proposed_A = variants{} ; --
lin coach_N = variants{} ; --
lin coach_3_N = variants{} ; --
lin coach_2_N = variants{} ; --
lin coach_1_N = variants{} ; --
lin absolute_A = variants{} ; --
lin drama_N = variants{} ; --
lin recording_N = variants{} ; --
lin precisely_Adv = variants{} ; --
lin bath_N = variants{} ; --
lin celebrate_V2 = variants{} ; --
lin substance_N = variants{} ; --
lin swing_V2 = variants{} ; --
lin swing_V = variants{} ; --
lin for_Adv = variants{}; -- S.for_Prep ;
lin rapid_A = variants{} ; --
lin rough_A = variants{} ; --
lin investor_N = variants{} ; --
lin fire_V2 = variants{} ; --
lin fire_V = variants{} ; --
lin rank_N = variants{} ; --
lin compete_V = variants{} ; --
lin sweet_A = variants{} ; --
lin decline_VV = variants{} ; --
lin decline_V2 = variants{} ; --
lin decline_V = variants{} ; --
lin rent_N = variants{} ; --
lin dealer_N = variants{} ; --
lin bend_V2 = variants{} ; --
lin bend_V = variants{} ; --
lin solid_A = variants{} ; --
lin cloud_N = L.cloud_N ;
lin across_Adv = variants{} ; --
lin level_A = variants{} ; --
lin enquiry_N = variants{} ; --
lin fight_N = variants{} ; --
lin abuse_N = variants{} ; --
lin golf_N = variants{} ; --
lin guitar_N = variants{} ; --
lin electronic_A = variants{} ; --
lin cottage_N = variants{} ; --
lin scope_N = variants{} ; --
lin pause_VS = variants{} ; --
lin pause_V2V = variants{} ; --
lin pause_V = variants{} ; --
lin mixture_N = variants{} ; --
lin emotion_N = variants{} ; --
lin comprehensive_A = variants{} ; --
lin shirt_N = L.shirt_N ;
lin allowance_N = variants{} ; --
lin retirement_N = variants{} ; --
lin breach_N = variants{} ; --
lin infection_N = variants{} ; --
lin resist_VV = variants{} ; --
lin resist_V2 = variants{} ; --
lin resist_V = variants{} ; --
lin qualify_V2 = variants{} ; --
lin qualify_V = variants{} ; --
lin paragraph_N = variants{} ; --
lin sick_A = variants{} ; --
lin near_A = L.near_A ;
lin consent_N = variants{} ; --
lin written_A = variants{} ; --
lin literary_A = variants{} ; --
lin ill_A = variants{} ; --
lin wet_A = L.wet_A ;
lin lake_N = L.lake_N ;
lin entrance_N = variants{} ; --
lin peak_N = variants{} ; --
lin successfully_Adv = variants{} ; --
lin sand_N = L.sand_N ;
lin breathe_V2 = variants{}; -- L.breathe_V ;
lin breathe_V = L.breathe_V ;
lin cold_N = variants{} ; --
lin cheek_N = variants{} ; --
lin platform_N = variants{} ; --
lin interaction_N = variants{} ; --
lin watch_N = variants{} ; --
lin borrow_VV = variants{} ; --
lin borrow_V2 = variants{} ; --
lin borrow_V = variants{} ; --
lin birthday_N = variants{} ; --
lin knife_N = variants{} ; --
lin extreme_A = variants{} ; --
lin core_N = variants{} ; --
lin armed_A = variants{} ; --
lin permission_N = variants{} ; --
lin supreme_A = variants{} ; --
lin overcome_V2 = variants{} ; --
lin overcome_V = variants{} ; --
lin greatly_Adv = variants{} ; --
lin visual_A = variants{} ; --
lin lad_N = variants{} ; --
lin genuine_A = variants{} ; --
lin personnel_N = variants{} ; --
lin judgement_N = variants{} ; --
lin exciting_A = variants{} ; --
lin stream_N = variants{} ; --
lin perception_N = variants{} ; --
lin guarantee_VS = variants{} ; --
lin guarantee_V2 = variants{} ; --
lin guarantee_V = variants{} ; --
lin disaster_N = variants{} ; --
lin darkness_N = variants{} ; --
lin bid_N = variants{} ; --
lin sake_N = variants{} ; --
lin sake_2_N = variants{} ; --
lin sake_1_N = variants{} ; --
lin organize_V2V = variants{} ; --
lin organize_V2 = variants{} ; --
lin tourist_N = variants{} ; --
lin policeman_N = L.policeman_N ;
lin castle_N = variants{} ; --
lin figure_VS = variants{} ; --
lin figure_V = variants{} ; --
lin race_VV = variants{} ; --
lin race_V2V = variants{} ; --
lin race_V2 = variants{} ; --
lin race_V = variants{} ; --
lin demonstration_N = variants{} ; --
lin anger_N = variants{} ; --
lin briefly_Adv = variants{} ; --
lin presumably_Adv = variants{} ; --
lin clock_N = variants{} ; --
lin hero_N = variants{} ; --
lin expose_V2 = variants{} ; --
lin expose_V = variants{} ; --
lin custom_N = variants{} ; --
lin maximum_A = variants{} ; --
lin wish_N = variants{} ; --
lin earning_N = variants{} ; --
lin priest_N = L.priest_N ;
lin resign_V2 = variants{} ; --
lin resign_V = variants{} ; --
lin store_V2 = variants{} ; --
lin widespread_A = variants{} ; --
lin comprise_V2 = variants{} ; --
lin chamber_N = variants{} ; --
lin acquisition_N = variants{} ; --
lin involved_A = variants{} ; --
lin confident_A = variants{} ; --
lin circuit_N = variants{} ; --
lin radical_A = variants{} ; --
lin detect_V2 = variants{} ; --
lin stupid_A = L.stupid_A ;
lin grand_A = variants{} ; --
lin consumption_N = variants{} ; --
lin hold_N = variants{} ; --
lin zone_N = variants{} ; --
lin mean_A = variants{} ; --
lin altogether_Adv = variants{} ; --
lin rush_VV = variants{} ; --
lin rush_V2 = variants{} ; --
lin rush_V = variants{} ; --
lin numerous_A = variants{} ; --
lin sink_V2 = variants{} ; --
lin sink_V = variants{} ; --
lin everywhere_Adv = S.everywhere_Adv ;
lin classical_A = variants{} ; --
lin respectively_Adv = variants{} ; --
lin distinct_A = variants{} ; --
lin mad_A = variants{} ; --
lin honour_N = variants{} ; --
lin statistics_N = variants{} ; --
lin false_A = variants{} ; --
lin square_N = variants{} ; --
lin differ_V = variants{} ; --
lin disk_N = variants{} ; --
lin truly_Adv = variants{} ; --
lin survival_N = variants{} ; --
lin proud_A = variants{} ; --
lin tower_N = variants{} ; --
lin deposit_N = variants{} ; --
lin pace_N = variants{} ; --
lin compensation_N = variants{} ; --
lin consultant_N = variants{} ; --
lin drag_V2 = variants{} ; --
lin drag_V = variants{} ; --
lin advanced_A = variants{} ; --
lin landlord_N = variants{} ; --
lin whenever_Adv = variants{} ; --
lin delay_N = variants{} ; --
lin green_N = variants{} ; --
lin car_V = variants{} ; --
lin holder_N = variants{} ; --
lin secret_A = variants{} ; --
lin edition_N = variants{} ; --
lin occupation_N = variants{} ; --
lin agricultural_A = variants{} ; --
lin intelligence_N = variants{} ; --
lin intelligence_2_N = variants{} ; --
lin intelligence_1_N = variants{} ; --
lin empire_N = variants{} ; --
lin definitely_Adv = variants{} ; --
lin negotiate_VV = variants{} ; --
lin negotiate_V2 = variants{} ; --
lin negotiate_V = variants{} ; --
lin host_N = variants{} ; --
lin relative_N = variants{} ; --
lin mass_A = variants{} ; --
lin helpful_A = variants{} ; --
lin fellow_N = variants{} ; --
lin sweep_V2 = variants{} ; --
lin sweep_V = variants{} ; --
lin poet_N = variants{} ; --
lin journalist_N = variants{} ; --
lin defeat_N = variants{} ; --
lin unlike_Prep = variants{} ; --
lin primarily_Adv = variants{} ; --
lin tight_A = variants{} ; --
lin indication_N = variants{} ; --
lin dry_V2 = variants{} ; --
lin dry_V = variants{} ; --
lin cricket_N = variants{} ; --
lin whisper_V2 = variants{} ; --
lin whisper_V = variants{} ; --
lin routine_N = variants{} ; --
lin print_N = variants{} ; --
lin anxiety_N = variants{} ; --
lin witness_N = variants{} ; --
lin concerning_Prep = variants{} ; --
lin mill_N = variants{} ; --
lin gentle_A = variants{} ; --
lin curtain_N = variants{} ; --
lin mission_N = variants{} ; --
lin supplier_N = variants{} ; --
lin basically_Adv = variants{} ; --
lin assure_V2S = variants{} ; --
lin assure_V2 = variants{} ; --
lin poverty_N = variants{} ; --
lin snow_N = L.snow_N ;
lin prayer_N = variants{} ; --
lin pipe_N = variants{} ; --
lin deserve_VV = variants{} ; --
lin deserve_V2 = variants{} ; --
lin deserve_V = variants{} ; --
lin shift_N = variants{} ; --
lin split_V2 = L.split_V2 ;
lin split_V = variants{}; -- L.split_V2 ;
lin near_Adv = variants{} ; --
lin consistent_A = variants{} ; --
lin carpet_N = L.carpet_N ;
lin ownership_N = variants{} ; --
lin joke_N = variants{} ; --
lin fewer_Det = variants{} ; --
lin workshop_N = variants{} ; --
lin salt_N = L.salt_N ;
lin aged_Prep = variants{} ; --
lin symbol_N = variants{} ; --
lin slide_V2 = variants{} ; --
lin slide_V = variants{} ; --
lin cross_N = variants{} ; --
lin anxious_A = variants{} ; --
lin tale_N = variants{} ; --
lin preference_N = variants{} ; --
lin inevitably_Adv = variants{} ; --
lin mere_A = variants{} ; --
lin behave_V = variants{} ; --
lin gain_N = variants{} ; --
lin nervous_A = variants{} ; --
lin guide_V2 = variants{} ; --
lin remark_N = variants{} ; --
lin pleased_A = variants{} ; --
lin province_N = variants{} ; --
lin steel_N = L.steel_N ;
lin practise_V2 = variants{} ; --
lin practise_V = variants{} ; --
lin flow_V = L.flow_V ;
lin holy_A = variants{} ; --
lin dose_N = variants{} ; --
lin alcohol_N = variants{} ; --
lin guidance_N = variants{} ; --
lin constantly_Adv = variants{} ; --
lin climate_N = variants{} ; --
lin enhance_V2 = variants{} ; --
lin reasonably_Adv = variants{} ; --
lin waste_V2 = variants{} ; --
lin waste_V = variants{} ; --
lin smooth_A = L.smooth_A ;
lin dominant_A = variants{} ; --
lin conscious_A = variants{} ; --
lin formula_N = variants{} ; --
lin tail_N = L.tail_N ;
lin ha_Interj = variants{} ; --
lin electric_A = variants{} ; --
lin sheep_N = L.sheep_N ;
lin medicine_N = variants{} ; --
lin strategic_A = variants{} ; --
lin disabled_A = variants{} ; --
lin smell_N = variants{} ; --
lin operator_N = variants{} ; --
lin mount_V2 = variants{} ; --
lin mount_V = variants{} ; --
lin advance_V2 = variants{} ; --
lin advance_V = variants{} ; --
lin remote_A = variants{} ; --
lin measurement_N = variants{} ; --
lin favour_VS = variants{} ; --
lin favour_V2 = variants{} ; --
lin favour_V = variants{} ; --
lin neither_Det = variants{} ; --
lin architecture_N = variants{} ; --
lin worth_N = variants{} ; --
lin tie_N = variants{} ; --
lin barrier_N = variants{} ; --
lin practitioner_N = variants{} ; --
lin outstanding_A = variants{} ; --
lin enthusiasm_N = variants{} ; --
lin theoretical_A = variants{} ; --
lin implementation_N = variants{} ; --
lin worried_A = variants{} ; --
lin pitch_N = variants{} ; --
lin drop_N = variants{} ; --
lin phone_V2 = variants{} ; --
lin phone_V = variants{} ; --
lin shape_VV = variants{} ; --
lin shape_V2 = variants{} ; --
lin shape_V = variants{} ; --
lin clinical_A = variants{} ; --
lin lane_N = variants{} ; --
lin apple_N = L.apple_N ;
lin catalogue_N = variants{} ; --
lin tip_N = variants{} ; --
lin publisher_N = variants{} ; --
lin live_A = variants{} ; --
lin burden_N = variants{} ; --
lin tackle_V2 = variants{} ; --
lin tackle_V = variants{} ; --
lin historian_N = variants{} ; --
lin bury_V2 = variants{} ; --
lin bury_V = variants{} ; --
lin stomach_N = variants{} ; --
lin percentage_N = variants{} ; --
lin evaluation_N = variants{} ; --
lin outline_V2 = variants{} ; --
lin talent_N = variants{} ; --
lin lend_V2 = variants{} ; --
lin lend_V = variants{} ; --
lin silver_N = L.silver_N ;
lin pack_N = variants{} ; --
lin fun_N = variants{} ; --
lin democrat_N = variants{} ; --
lin fortune_N = variants{} ; --
lin storage_N = variants{} ; --
lin professional_N = variants{} ; --
lin reserve_N = variants{} ; --
lin interval_N = variants{} ; --
lin dimension_N = variants{} ; --
lin honest_A = variants{} ; --
lin awful_A = variants{} ; --
lin manufacture_V2 = variants{} ; --
lin confusion_N = variants{} ; --
lin pink_A = variants{} ; --
lin impressive_A = variants{} ; --
lin satisfaction_N = variants{} ; --
lin visible_A = variants{} ; --
lin vessel_N = variants{} ; --
lin stand_N = variants{} ; --
lin curve_N = variants{} ; --
lin pot_N = variants{} ; --
lin replacement_N = variants{} ; --
lin accurate_A = variants{} ; --
lin mortgage_N = variants{} ; --
lin salary_N = variants{} ; --
lin impress_V2 = variants{} ; --
lin impress_V = variants{} ; --
lin constitutional_A = variants{} ; --
lin emphasize_VS = variants{} ; --
lin emphasize_V2 = variants{} ; --
lin developing_A = variants{} ; --
lin proof_N = variants{} ; --
lin furthermore_Adv = variants{} ; --
lin dish_N = variants{} ; --
lin interview_V2 = variants{} ; --
lin considerably_Adv = variants{} ; --
lin distant_A = variants{} ; --
lin lower_V2 = variants{} ; --
lin lower_V = variants{} ; --
lin tear_V2 = variants{} ; --
lin tear_V = variants{} ; --
lin fixed_A = variants{} ; --
lin by_Adv = variants{} ; --
lin luck_N = variants{} ; --
lin count_N = variants{} ; --
lin precise_A = variants{} ; --
lin determination_N = variants{} ; --
lin bite_V2 = L.bite_V2 ;
lin bite_V = variants{}; -- L.bite_V2 ;
lin dear_Interj = variants{} ; --
lin consultation_N = variants{} ; --
lin range_V = variants{} ; --
lin residential_A = variants{} ; --
lin conduct_N = variants{} ; --
lin capture_V2 = variants{} ; --
lin ultimately_Adv = variants{} ; --
lin cheque_N = variants{} ; --
lin economics_N = variants{} ; --
lin sustain_V2 = variants{} ; --
lin secondly_Adv = variants{} ; --
lin silly_A = variants{} ; --
lin merchant_N = variants{} ; --
lin lecture_N = variants{} ; --
lin musical_A = variants{} ; --
lin leisure_N = variants{} ; --
lin check_N = variants{} ; --
lin cheese_N = L.cheese_N ;
lin lift_N = variants{} ; --
lin participate_V2 = variants{} ; --
lin participate_V = variants{} ; --
lin fabric_N = variants{} ; --
lin distribute_V2 = variants{} ; --
lin lover_N = variants{} ; --
lin childhood_N = variants{} ; --
lin cool_A = variants{} ; --
lin ban_V2 = variants{} ; --
lin supposed_A = variants{} ; --
lin mouse_N = variants{} ; --
lin strain_N = variants{} ; --
lin specialist_A = variants{} ; --
lin consult_V2 = variants{} ; --
lin consult_V = variants{} ; --
lin minimum_A = variants{} ; --
lin approximately_Adv = variants{} ; --
lin participant_N = variants{} ; --
lin monetary_A = variants{} ; --
lin confuse_V2 = variants{} ; --
lin dare_VV = variants{} ; --
lin dare_V2 = variants{} ; --
lin smoke_N = L.smoke_N ;
lin movie_N = variants{} ; --
lin seed_N = L.seed_N ;
lin cease_V2 = variants{} ; --
lin cease_V = variants{} ; --
lin open_Adv = variants{} ; --
lin journal_N = variants{} ; --
lin shopping_N = variants{} ; --
lin equivalent_N = variants{} ; --
lin palace_N = variants{} ; --
lin exceed_V2 = variants{} ; --
lin isolated_A = variants{} ; --
lin poetry_N = variants{} ; --
lin perceive_VS = variants{} ; --
lin perceive_V2V = variants{} ; --
lin perceive_V2 = variants{} ; --
lin lack_V2 = variants{} ; --
lin lack_V = variants{} ; --
lin strengthen_V2 = variants{} ; --
lin snap_V2 = variants{} ; --
lin snap_V = variants{} ; --
lin readily_Adv = variants{} ; --
lin spite_N = variants{} ; --
lin conviction_N = variants{} ; --
lin corridor_N = variants{} ; --
lin behind_Adv = variants{}; -- S.behind_Prep ;
lin ward_N = variants{} ; --
lin profile_N = variants{} ; --
lin fat_A = variants{} ; --
lin comfort_N = variants{} ; --
lin bathroom_N = variants{} ; --
lin shell_N = variants{} ; --
lin reward_N = variants{} ; --
lin deliberately_Adv = variants{} ; --
lin automatically_Adv = variants{} ; --
lin vegetable_N = variants{} ; --
lin imagination_N = variants{} ; --
lin junior_A = variants{} ; --
lin unemployed_A = variants{} ; --
lin mystery_N = variants{} ; --
lin pose_V2 = variants{} ; --
lin pose_V = variants{} ; --
lin violent_A = variants{} ; --
lin march_N = variants{} ; --
lin found_V2 = variants{} ; --
lin dig_V2 = variants{}; -- L.dig_V ;
lin dig_V = L.dig_V ;
lin dirty_A = L.dirty_A ;
lin straight_A = L.straight_A ;
lin psychological_A = variants{} ; --
lin grab_V2 = variants{} ; --
lin grab_V = variants{} ; --
lin pleasant_A = variants{} ; --
lin surgery_N = variants{} ; --
lin inevitable_A = variants{} ; --
lin transform_V2 = variants{} ; --
lin bell_N = variants{} ; --
lin announcement_N = variants{} ; --
lin draft_N = variants{} ; --
lin unity_N = variants{} ; --
lin airport_N = variants{} ; --
lin upset_V2 = variants{} ; --
lin upset_V = variants{} ; --
lin pretend_VS = variants{} ; --
lin pretend_V2 = variants{} ; --
lin pretend_V = variants{} ; --
lin plant_V2 = variants{} ; --
lin till_Prep = variants{} ; --
lin known_A = variants{} ; --
lin admission_N = variants{} ; --
lin tissue_N = variants{} ; --
lin magistrate_N = variants{} ; --
lin joy_N = variants{} ; --
lin free_V2V = variants{} ; --
lin free_V2 = variants{} ; --
lin pretty_A = variants{} ; --
lin operating_N = variants{} ; --
lin headquarters_N = variants{} ; --
lin grateful_A = variants{} ; --
lin classroom_N = variants{} ; --
lin turnover_N = variants{} ; --
lin project_VS = variants{} ; --
lin project_V2V = variants{} ; --
lin project_V2 = variants{} ; --
lin project_V = variants{} ; --
lin shrug_V2 = variants{} ; --
lin sensible_A = variants{} ; --
lin limitation_N = variants{} ; --
lin specialist_N = variants{} ; --
lin newly_Adv = variants{} ; --
lin tongue_N = L.tongue_N ;
lin refugee_N = variants{} ; --
lin delay_V2 = variants{} ; --
lin delay_V = variants{} ; --
lin dream_V2 = variants{} ; --
lin dream_V = variants{} ; --
lin composition_N = variants{} ; --
lin alongside_Prep = variants{} ; --
lin ceiling_N = L.ceiling_N ;
lin highlight_V2 = variants{} ; --
lin stick_N = L.stick_N ;
lin favourite_A = variants{} ; --
lin tap_V2 = variants{} ; --
lin tap_V = variants{} ; --
lin universe_N = variants{} ; --
lin request_VS = variants{} ; --
lin request_V2 = variants{} ; --
lin label_N = variants{} ; --
lin confine_V2 = variants{} ; --
lin scream_VS = variants{} ; --
lin scream_V2 = variants{} ; --
lin scream_V = variants{} ; --
lin rid_V2 = variants{} ; --
lin acceptance_N = variants{} ; --
lin detective_N = variants{} ; --
lin sail_V = variants{} ; --
lin adjust_V2 = variants{} ; --
lin adjust_V = variants{} ; --
lin designer_N = variants{} ; --
lin running_A = variants{} ; --
lin summit_N = variants{} ; --
lin participation_N = variants{} ; --
lin weakness_N = variants{} ; --
lin block_V2 = variants{} ; --
lin socalled_A = variants{} ; --
lin adapt_V2 = variants{} ; --
lin adapt_V = variants{} ; --
lin absorb_V2 = variants{} ; --
lin encounter_V2 = variants{} ; --
lin defeat_V2 = variants{} ; --
lin excitement_N = variants{} ; --
lin brick_N = variants{} ; --
lin blind_A = variants{} ; --
lin wire_N = variants{} ; --
lin crop_N = variants{} ; --
lin square_A = variants{} ; --
lin transition_N = variants{} ; --
lin thereby_Adv = variants{} ; --
lin protest_V2 = variants{} ; --
lin protest_V = variants{} ; --
lin roll_N = variants{} ; --
lin stop_N = variants{} ; --
lin assistant_N = variants{} ; --
lin deaf_A = variants{} ; --
lin constituency_N = variants{} ; --
lin continuous_A = variants{} ; --
lin concert_N = variants{} ; --
lin breast_N = L.breast_N ;
lin extraordinary_A = variants{} ; --
lin squad_N = variants{} ; --
lin wonder_N = variants{} ; --
lin cream_N = variants{} ; --
lin tennis_N = variants{} ; --
lin personally_Adv = variants{} ; --
lin communicate_V2 = variants{} ; --
lin communicate_V = variants{} ; --
lin pride_N = variants{} ; --
lin bowl_N = variants{} ; --
lin file_V2 = variants{} ; --
lin file_V = variants{} ; --
lin expertise_N = variants{} ; --
lin govern_V2 = variants{} ; --
lin govern_V = variants{} ; --
lin leather_N = L.leather_N ;
lin observer_N = variants{} ; --
lin margin_N = variants{} ; --
lin uncertainty_N = variants{} ; --
lin reinforce_V2 = variants{} ; --
lin ideal_N = variants{} ; --
lin injure_V2 = variants{} ; --
lin holding_N = variants{} ; --
lin universal_A = variants{} ; --
lin evident_A = variants{} ; --
lin dust_N = L.dust_N ;
lin overseas_A = variants{} ; --
lin desperate_A = variants{} ; --
lin swim_V2 = variants{}; -- L.swim_V ;
lin swim_V = L.swim_V ;
lin occasional_A = variants{} ; --
lin trouser_N = variants{} ; --
lin surprisingly_Adv = variants{} ; --
lin register_N = variants{} ; --
lin album_N = variants{} ; --
lin guideline_N = variants{} ; --
lin disturb_V2 = variants{} ; --
lin amendment_N = variants{} ; --
lin objection_N = variants{} ; --
lin chart_N = variants{} ; --
lin cattle_N = variants{} ; --
lin doubt_VS = variants{} ; --
lin doubt_V2 = variants{} ; --
lin react_V = variants{} ; --
lin consciousness_N = variants{} ; --
lin right_Interj = variants{} ; --
lin purely_Adv = variants{} ; --
lin tin_N = variants{} ; --
lin tube_N = variants{} ; --
lin fulfil_V2 = variants{} ; --
lin commonly_Adv = variants{} ; --
lin sufficiently_Adv = variants{} ; --
lin coin_N = variants{} ; --
lin frighten_V2 = variants{} ; --
lin grammar_N = L.grammar_N ;
lin diary_N = variants{} ; --
lin flesh_N = variants{} ; --
lin summary_N = variants{} ; --
lin infant_N = variants{} ; --
lin stir_V2 = variants{} ; --
lin stir_V = variants{} ; --
lin storm_N = variants{} ; --
lin mail_N = variants{} ; --
lin rugby_N = variants{} ; --
lin virtue_N = variants{} ; --
lin specimen_N = variants{} ; --
lin psychology_N = variants{} ; --
lin paint_N = variants{} ; --
lin constraint_N = variants{} ; --
lin trace_V2 = variants{} ; --
lin trace_V = variants{} ; --
lin privilege_N = variants{} ; --
lin completion_N = variants{} ; --
lin progress_V2 = variants{} ; --
lin progress_V = variants{} ; --
lin grade_N = variants{} ; --
lin exploit_V2 = variants{} ; --
lin import_N = variants{} ; --
lin potato_N = variants{} ; --
lin repair_N = variants{} ; --
lin passion_N = variants{} ; --
lin seize_V2 = variants{} ; --
lin seize_V = variants{} ; --
lin low_Adv = variants{} ; --
lin underlying_A = variants{} ; --
lin heaven_N = variants{} ; --
lin nerve_N = variants{} ; --
lin park_V2 = variants{} ; --
lin park_V = variants{} ; --
lin collapse_V2 = variants{} ; --
lin collapse_V = variants{} ; --
lin win_N = variants{} ; --
lin printer_N = variants{} ; --
lin coalition_N = variants{} ; --
lin button_N = variants{} ; --
lin pray_V2 = variants{} ; --
lin pray_V = variants{} ; --
lin ultimate_A = variants{} ; --
lin venture_N = variants{} ; --
lin timber_N = variants{} ; --
lin companion_N = variants{} ; --
lin horror_N = variants{} ; --
lin gesture_N = variants{} ; --
lin moon_N = L.moon_N ;
lin remark_VS = variants{} ; --
lin remark_V = variants{} ; --
lin clever_A = L.clever_A ;
lin van_N = variants{} ; --
lin consequently_Adv = variants{} ; --
lin raw_A = variants{} ; --
lin glance_N = variants{} ; --
lin broken_A = variants{} ; --
lin jury_N = variants{} ; --
lin gaze_V = variants{} ; --
lin burst_V2 = variants{} ; --
lin burst_V = variants{} ; --
lin charter_N = variants{} ; --
lin discourse_N = variants{} ; --
lin reflection_N = variants{} ; --
lin carbon_N = variants{} ; --
lin sophisticated_A = variants{} ; --
lin ban_N = variants{} ; --
lin taxation_N = variants{} ; --
lin prosecution_N = variants{} ; --
lin softly_Adv = variants{} ; --
lin asleep_A = variants{} ; --
lin aids_N = variants{} ; --
lin publicity_N = variants{} ; --
lin departure_N = variants{} ; --
lin welcome_A = variants{} ; --
lin sharply_Adv = variants{} ; --
lin reception_N = variants{} ; --
lin cousin_N = L.cousin_N ;
lin relieve_V2 = variants{} ; --
lin linguistic_A = variants{} ; --
lin vat_N = variants{} ; --
lin forward_A = variants{} ; --
lin blue_N = variants{} ; --
lin multiple_A = variants{} ; --
lin pass_N = variants{} ; --
lin outer_A = variants{} ; --
lin vulnerable_A = variants{} ; --
lin patient_A = variants{} ; --
lin evolution_N = variants{} ; --
lin allocate_V2 = variants{} ; --
lin allocate_V = variants{} ; --
lin creative_A = variants{} ; --
lin potentially_Adv = variants{} ; --
lin just_A = variants{} ; --
lin out_Prep = variants{} ; --
lin judicial_A = variants{} ; --
lin risk_VV = variants{} ; --
lin risk_V2 = variants{} ; --
lin ideology_N = variants{} ; --
lin smell_VA = variants{}; -- L.smell_V ;
lin smell_V2 = variants{}; -- L.smell_V ;
lin smell_V = L.smell_V ;
lin agenda_N = variants{} ; --
lin transport_V2 = variants{} ; --
lin illegal_A = variants{} ; --
lin chicken_N = variants{} ; --
lin plain_A = variants{} ; --
lin innovation_N = variants{} ; --
lin opera_N = variants{} ; --
lin lock_N = variants{} ; --
lin grin_V = variants{} ; --
lin shelf_N = variants{} ; --
lin pole_N = variants{} ; --
lin punishment_N = variants{} ; --
lin strict_A = variants{} ; --
lin wave_V2 = variants{} ; --
lin wave_V = variants{} ; --
lin inside_N = variants{} ; --
lin carriage_N = variants{} ; --
lin fit_A = variants{} ; --
lin conversion_N = variants{} ; --
lin hurry_V = variants{} ; --
lin essay_N = variants{} ; --
lin integration_N = variants{} ; --
lin resignation_N = variants{} ; --
lin treasury_N = variants{} ; --
lin traveller_N = variants{} ; --
lin chocolate_N = variants{} ; --
lin assault_N = variants{} ; --
lin schedule_N = variants{} ; --
lin undoubtedly_Adv = variants{} ; --
lin twin_N = variants{} ; --
lin format_N = variants{} ; --
lin murder_V2 = variants{} ; --
lin sigh_VS = variants{} ; --
lin sigh_V2 = variants{} ; --
lin sigh_V = variants{} ; --
lin lease_N = variants{} ; --
lin bitter_A = variants{} ; --
lin double_V2 = variants{} ; --
lin double_V = variants{} ; --
lin ally_N = variants{} ; --
lin stake_N = variants{} ; --
lin processing_N = variants{} ; --
lin informal_A = variants{} ; --
lin flexible_A = variants{} ; --
lin cap_N = L.cap_N ;
lin stable_A = variants{} ; --
lin till_Subj = variants{} ; --
lin sympathy_N = variants{} ; --
lin tunnel_N = variants{} ; --
lin pen_N = L.pen_N ;
lin instal_V = variants{} ; --
lin suspend_V2 = variants{} ; --
lin suspend_V = variants{} ; --
lin blow_N = variants{} ; --
lin wander_V = variants{} ; --
lin notably_Adv = variants{} ; --
lin disappoint_V2 = variants{} ; --
lin wipe_V2 = L.wipe_V2 ;
lin wipe_V = variants{}; -- L.wipe_V2 ;
lin folk_N = variants{} ; --
lin attraction_N = variants{} ; --
lin disc_N = variants{} ; --
lin inspire_V2V = variants{} ; --
lin inspire_V2 = variants{} ; --
lin machinery_N = variants{} ; --
lin undergo_V2 = variants{} ; --
lin nowhere_Adv = variants{} ; --
lin inspector_N = variants{} ; --
lin wise_A = variants{} ; --
lin balance_V2 = variants{} ; --
lin balance_V = variants{} ; --
lin purchaser_N = variants{} ; --
lin resort_N = variants{} ; --
lin pop_N = variants{} ; --
lin organ_N = variants{} ; --
lin ease_V2 = variants{} ; --
lin ease_V = variants{} ; --
lin friendship_N = variants{} ; --
lin deficit_N = variants{} ; --
lin dear_N = variants{} ; --
lin convey_V2 = variants{} ; --
lin reserve_V2 = variants{} ; --
lin reserve_V = variants{} ; --
lin planet_N = L.planet_N ;
lin frequent_A = variants{} ; --
lin loose_A = variants{} ; --
lin intense_A = variants{} ; --
lin retail_A = variants{} ; --
lin wind_V = variants{} ; --
lin lost_A = variants{} ; --
lin grain_N = variants{} ; --
lin particle_N = variants{} ; --
lin destruction_N = variants{} ; --
lin witness_V2 = variants{} ; --
lin witness_V = variants{} ; --
lin pit_N = variants{} ; --
lin registration_N = variants{} ; --
lin conception_N = variants{} ; --
lin steady_A = variants{} ; --
lin rival_N = variants{} ; --
lin steam_N = variants{} ; --
lin back_A = variants{} ; --
lin chancellor_N = variants{} ; --
lin crash_V = variants{} ; --
lin belt_N = variants{} ; --
lin logic_N = variants{} ; --
lin premium_N = variants{} ; --
lin confront_V2 = variants{} ; --
lin precede_V2 = variants{} ; --
lin experimental_A = variants{} ; --
lin alarm_N = variants{} ; --
lin rational_A = variants{} ; --
lin incentive_N = variants{} ; --
lin roughly_Adv = variants{} ; --
lin bench_N = variants{} ; --
lin wrap_V2 = variants{} ; --
lin wrap_V = variants{} ; --
lin regarding_Prep = variants{} ; --
lin inadequate_A = variants{} ; --
lin ambition_N = variants{} ; --
lin since_Adv = variants{} ; --
lin fate_N = variants{} ; --
lin vendor_N = variants{} ; --
lin stranger_N = variants{} ; --
lin spiritual_A = variants{} ; --
lin increasing_A = variants{} ; --
lin anticipate_VV = variants{} ; --
lin anticipate_VS = variants{} ; --
lin anticipate_V2 = variants{} ; --
lin anticipate_V = variants{} ; --
lin logical_A = variants{} ; --
lin fibre_N = variants{} ; --
lin attribute_V2 = variants{} ; --
lin sense_VS = variants{} ; --
lin sense_V2 = variants{} ; --
lin black_N = variants{} ; --
lin petrol_N = variants{} ; --
lin maker_N = variants{} ; --
lin generous_A = variants{} ; --
lin allocation_N = variants{} ; --
lin depression_N = variants{} ; --
lin declaration_N = variants{} ; --
lin spot_VS = variants{} ; --
lin spot_V2 = variants{} ; --
lin spot_V = variants{} ; --
lin modest_A = variants{} ; --
lin bottom_A = variants{} ; --
lin dividend_N = variants{} ; --
lin devote_V2 = variants{} ; --
lin condemn_V2 = variants{} ; --
lin integrate_V2 = variants{} ; --
lin integrate_V = variants{} ; --
lin pile_N = variants{} ; --
lin identification_N = variants{} ; --
lin acute_A = variants{} ; --
lin barely_Adv = variants{} ; --
lin providing_Subj = variants{} ; --
lin directive_N = variants{} ; --
lin bet_VS = variants{} ; --
lin bet_V2 = variants{} ; --
lin bet_V = variants{} ; --
lin modify_V2 = variants{} ; --
lin bare_A = variants{} ; --
lin swear_VV = variants{} ; --
lin swear_V2 = variants{} ; --
lin swear_V = variants{} ; --
lin final_N = variants{} ; --
lin accordingly_Adv = variants{} ; --
lin valid_A = variants{} ; --
lin wherever_Adv = variants{} ; --
lin mortality_N = variants{} ; --
lin medium_N = variants{} ; --
lin silk_N = variants{} ; --
lin funeral_N = variants{} ; --
lin depending_A = variants{} ; --
lin cow_N = L.cow_N ;
lin correspond_V2 = variants{} ; --
lin correspond_V = variants{} ; --
lin cite_V2 = variants{} ; --
lin classic_A = variants{} ; --
lin inspection_N = variants{} ; --
lin calculation_N = variants{} ; --
lin rubbish_N = variants{} ; --
lin minimum_N = variants{} ; --
lin hypothesis_N = variants{} ; --
lin youngster_N = variants{} ; --
lin slope_N = variants{} ; --
lin patch_N = variants{} ; --
lin invitation_N = variants{} ; --
lin ethnic_A = variants{} ; --
lin federation_N = variants{} ; --
lin duke_N = variants{} ; --
lin wholly_Adv = variants{} ; --
lin closure_N = variants{} ; --
lin dictionary_N = variants{} ; --
lin withdrawal_N = variants{} ; --
lin automatic_A = variants{} ; --
lin liable_A = variants{} ; --
lin cry_N = variants{} ; --
lin slow_V2 = variants{} ; --
lin slow_V = variants{} ; --
lin borough_N = variants{} ; --
lin well_A = variants{} ; --
lin suspicion_N = variants{} ; --
lin portrait_N = variants{} ; --
lin local_N = variants{} ; --
lin jew_N = variants{} ; --
lin fragment_N = variants{} ; --
lin revolutionary_A = variants{} ; --
lin evaluate_V2 = variants{} ; --
lin evaluate_V = variants{} ; --
lin competitor_N = variants{} ; --
lin sole_A = variants{} ; --
lin reliable_A = variants{} ; --
lin weigh_V2 = variants{} ; --
lin weigh_V = variants{} ; --
lin medieval_A = variants{} ; --
lin clinic_N = variants{} ; --
lin shine_V2 = variants{} ; --
lin shine_V = variants{} ; --
lin knit_V2 = variants{} ; --
lin knit_V = variants{} ; --
lin complexity_N = variants{} ; --
lin remedy_N = variants{} ; --
lin fence_N = variants{} ; --
lin bike_N = L.bike_N ;
lin freeze_V2 = variants{}; -- L.freeze_V ;
lin freeze_V = L.freeze_V ;
lin eliminate_V2 = variants{} ; --
lin interior_N = variants{} ; --
lin intellectual_A = variants{} ; --
lin established_A = variants{} ; --
lin voter_N = variants{} ; --
lin garage_N = variants{} ; --
lin era_N = variants{} ; --
lin pregnant_A = variants{} ; --
lin plot_N = variants{} ; --
lin greet_V2 = variants{} ; --
lin electrical_A = variants{} ; --
lin lie_N = variants{} ; --
lin disorder_N = variants{} ; --
lin formally_Adv = variants{} ; --
lin excuse_N = variants{} ; --
lin socialist_A = variants{} ; --
lin cancel_V2 = variants{} ; --
lin cancel_V = variants{} ; --
lin harm_N = variants{} ; --
lin excess_N = variants{} ; --
lin exact_A = variants{} ; --
lin oblige_V2V = variants{} ; --
lin oblige_V2 = variants{} ; --
lin accountant_N = variants{} ; --
lin mutual_A = variants{} ; --
lin fat_N = L.fat_N ;
lin laughter_N = variants{} ; --
lin trick_N = variants{} ; --
lin load_V2 = variants{} ; --
lin load_V = variants{} ; --
lin disposal_N = variants{} ; --
lin taxi_N = variants{} ; --
lin murmur_V2 = variants{} ; --
lin murmur_V = variants{} ; --
lin tonne_N = variants{} ; --
lin spell_V2 = variants{} ; --
lin spell_V = variants{} ; --
lin clerk_N = variants{} ; --
lin curious_A = variants{} ; --
lin satisfactory_A = variants{} ; --
lin identical_A = variants{} ; --
lin applicant_N = variants{} ; --
lin removal_N = variants{} ; --
lin processor_N = variants{} ; --
lin cotton_N = variants{} ; --
lin reverse_V2 = variants{} ; --
lin reverse_V = variants{} ; --
lin hesitate_VV = variants{} ; --
lin hesitate_V = variants{} ; --
lin professor_N = variants{} ; --
lin admire_V2 = variants{} ; --
lin namely_Adv = variants{} ; --
lin electoral_A = variants{} ; --
lin delight_N = variants{} ; --
lin urgent_A = variants{} ; --
lin prompt_V2V = variants{} ; --
lin prompt_V2 = variants{} ; --
lin mate_N = variants{} ; --
lin mate_2_N = variants{} ; --
lin mate_1_N = variants{} ; --
lin exposure_N = variants{} ; --
lin server_N = variants{} ; --
lin distinctive_A = variants{} ; --
lin marginal_A = variants{} ; --
lin structural_A = variants{} ; --
lin rope_N = L.rope_N ;
lin miner_N = variants{} ; --
lin entertainment_N = variants{} ; --
lin acre_N = variants{} ; --
lin pig_N = variants{} ; --
lin encouraging_A = variants{} ; --
lin guarantee_N = variants{} ; --
lin gear_N = variants{} ; --
lin anniversary_N = variants{} ; --
lin past_Adv = variants{} ; --
lin ceremony_N = variants{} ; --
lin rub_V2 = L.rub_V2 ;
lin rub_V = variants{}; -- L.rub_V2 ;
lin monopoly_N = variants{} ; --
lin left_N = variants{} ; --
lin flee_V2 = variants{} ; --
lin flee_V = variants{} ; --
lin yield_V2 = variants{} ; --
lin discount_N = variants{} ; --
lin above_A = variants{} ; --
lin uncle_N = variants{} ; --
lin audit_N = variants{} ; --
lin advertisement_N = variants{} ; --
lin explosion_N = variants{} ; --
lin contrary_A = variants{} ; --
lin tribunal_N = variants{} ; --
lin swallow_V2 = variants{} ; --
lin swallow_V = variants{} ; --
lin typically_Adv = variants{} ; --
lin fun_A = variants{} ; --
lin rat_N = variants{} ; --
lin cloth_N = variants{} ; --
lin cable_N = variants{} ; --
lin interrupt_V2 = variants{} ; --
lin interrupt_V = variants{} ; --
lin crash_N = variants{} ; --
lin flame_N = variants{} ; --
lin controversy_N = variants{} ; --
lin rabbit_N = variants{} ; --
lin everyday_A = variants{} ; --
lin allegation_N = variants{} ; --
lin strip_N = variants{} ; --
lin stability_N = variants{} ; --
lin tide_N = variants{} ; --
lin illustration_N = variants{} ; --
lin insect_N = variants{} ; --
lin correspondent_N = variants{} ; --
lin devise_V2 = variants{} ; --
lin determined_A = variants{} ; --
lin brush_V2 = variants{} ; --
lin brush_V = variants{} ; --
lin adjustment_N = variants{} ; --
lin controversial_A = variants{} ; --
lin organic_A = variants{} ; --
lin escape_N = variants{} ; --
lin thoroughly_Adv = variants{} ; --
lin interface_N = variants{} ; --
lin historic_A = variants{} ; --
lin collapse_N = variants{} ; --
lin temple_N = variants{} ; --
lin shade_N = variants{} ; --
lin craft_N = variants{} ; --
lin nursery_N = variants{} ; --
lin piano_N = variants{} ; --
lin desirable_A = variants{} ; --
lin assurance_N = variants{} ; --
lin jurisdiction_N = variants{} ; --
lin advertise_V2 = variants{} ; --
lin advertise_V = variants{} ; --
lin bay_N = variants{} ; --
lin specification_N = variants{} ; --
lin disability_N = variants{} ; --
lin presidential_A = variants{} ; --
lin arrest_N = variants{} ; --
lin unexpected_A = variants{} ; --
lin switch_N = variants{} ; --
lin penny_N = variants{} ; --
lin respect_V2 = variants{} ; --
lin celebration_N = variants{} ; --
lin gross_A = variants{} ; --
lin aid_V2 = variants{} ; --
lin aid_V = variants{} ; --
lin superb_A = variants{} ; --
lin process_V2 = variants{} ; --
lin process_V = variants{} ; --
lin innocent_A = variants{} ; --
lin leap_V2 = variants{} ; --
lin leap_V = variants{} ; --
lin colony_N = variants{} ; --
lin wound_N = variants{} ; --
lin hardware_N = variants{} ; --
lin satellite_N = variants{} ; --
lin float_V = L.float_V ;
lin bible_N = variants{} ; --
lin statistical_A = variants{} ; --
lin marked_A = variants{} ; --
lin hire_V2V = variants{} ; --
lin hire_V2 = variants{} ; --
lin cathedral_N = variants{} ; --
lin motive_N = variants{} ; --
lin correct_VS = variants{} ; --
lin correct_V2 = variants{} ; --
lin correct_V = variants{} ; --
lin gastric_A = variants{} ; --
lin raid_N = variants{} ; --
lin comply_V2 = variants{} ; --
lin comply_V = variants{} ; --
lin accommodate_V2 = variants{} ; --
lin accommodate_V = variants{} ; --
lin mutter_V2 = variants{} ; --
lin mutter_V = variants{} ; --
lin induce_V2 = variants{} ; --
lin trap_V2 = variants{} ; --
lin trap_V = variants{} ; --
lin invasion_N = variants{} ; --
lin humour_N = variants{} ; --
lin bulk_N = variants{} ; --
lin traditionally_Adv = variants{} ; --
lin commission_V2V = variants{} ; --
lin commission_V2 = variants{} ; --
lin upstairs_Adv = variants{} ; --
lin translate_V2 = variants{} ; --
lin translate_V = variants{} ; --
lin rhythm_N = variants{} ; --
lin emission_N = variants{} ; --
lin collective_A = variants{} ; --
lin transformation_N = variants{} ; --
lin battery_N = variants{} ; --
lin stimulus_N = variants{} ; --
lin naked_A = variants{} ; --
lin white_N = variants{} ; --
lin menu_N = variants{} ; --
lin toilet_N = variants{} ; --
lin butter_N = L.butter_N ;
lin surprise_V2V = variants{} ; --
lin surprise_V2 = variants{} ; --
lin needle_N = variants{} ; --
lin effectiveness_N = variants{} ; --
lin accordance_N = variants{} ; --
lin molecule_N = variants{} ; --
lin fiction_N = variants{} ; --
lin learning_N = variants{} ; --
lin statute_N = variants{} ; --
lin reluctant_A = variants{} ; --
lin overlook_V2 = variants{} ; --
lin junction_N = variants{} ; --
lin necessity_N = variants{} ; --
lin nearby_A = variants{} ; --
lin experienced_A = variants{} ; --
lin lorry_N = variants{} ; --
lin exclusive_A = variants{} ; --
lin graphics_N = variants{} ; --
lin stimulate_V2 = variants{} ; --
lin warmth_N = variants{} ; --
lin therapy_N = variants{} ; --
lin convenient_A = variants{} ; --
lin cinema_N = variants{} ; --
lin domain_N = variants{} ; --
lin tournament_N = variants{} ; --
lin doctrine_N = variants{} ; --
lin sheer_A = variants{} ; --
lin proposition_N = variants{} ; --
lin grip_N = variants{} ; --
lin widow_N = variants{} ; --
lin discrimination_N = variants{} ; --
lin bloody_Adv = variants{} ; --
lin ruling_A = variants{} ; --
lin fit_N = variants{} ; --
lin nonetheless_Adv = variants{} ; --
lin myth_N = variants{} ; --
lin episode_N = variants{} ; --
lin drift_V2 = variants{} ; --
lin drift_V = variants{} ; --
lin assert_VS = variants{} ; --
lin assert_V2 = variants{} ; --
lin assert_V = variants{} ; --
lin terrace_N = variants{} ; --
lin uncertain_A = variants{} ; --
lin twist_V2 = variants{} ; --
lin insight_N = variants{} ; --
lin undermine_V2 = variants{} ; --
lin tragedy_N = variants{} ; --
lin enforce_V2 = variants{} ; --
lin criticize_V2 = variants{} ; --
lin criticize_V = variants{} ; --
lin march_V2 = variants{} ; --
lin march_V = variants{} ; --
lin leaflet_N = variants{} ; --
lin fellow_A = variants{} ; --
lin object_V2 = variants{} ; --
lin object_V = variants{} ; --
lin pond_N = variants{} ; --
lin adventure_N = variants{} ; --
lin diplomatic_A = variants{} ; --
lin mixed_A = variants{} ; --
lin rebel_N = variants{} ; --
lin equity_N = variants{} ; --
lin literally_Adv = variants{} ; --
lin magnificent_A = variants{} ; --
lin loyalty_N = variants{} ; --
lin tremendous_A = variants{} ; --
lin airline_N = variants{} ; --
lin shore_N = variants{} ; --
lin restoration_N = variants{} ; --
lin physically_Adv = variants{} ; --
lin render_V2 = variants{} ; --
lin institutional_A = variants{} ; --
lin emphasize_VS = variants{} ; --
lin emphasize_V2 = variants{} ; --
lin mess_N = variants{} ; --
lin commander_N = variants{} ; --
lin straightforward_A = variants{} ; --
lin singer_N = variants{} ; --
lin squeeze_V2 = L.squeeze_V2 ;
lin squeeze_V = variants{}; -- L.squeeze_V2 ;
lin full_time_A = variants{} ; --
lin breed_V2 = variants{} ; --
lin breed_V = variants{} ; --
lin successor_N = variants{} ; --
lin triumph_N = variants{} ; --
lin heading_N = variants{} ; --
lin mathematics_N = variants{} ; --
lin laugh_N = variants{} ; --
lin clue_N = variants{} ; --
lin still_A = variants{} ; --
lin ease_N = variants{} ; --
lin specially_Adv = variants{} ; --
lin biological_A = variants{} ; --
lin forgive_V2 = variants{} ; --
lin forgive_V = variants{} ; --
lin trustee_N = variants{} ; --
lin photo_N = variants{} ; --
lin fraction_N = variants{} ; --
lin chase_V2 = variants{} ; --
lin chase_V = variants{} ; --
lin whereby_Adv = variants{} ; --
lin mud_N = variants{} ; --
lin pensioner_N = variants{} ; --
lin functional_A = variants{} ; --
lin copy_V2 = variants{} ; --
lin copy_V = variants{} ; --
lin strictly_Adv = variants{} ; --
lin desperately_Adv = variants{} ; --
lin await_V2 = variants{} ; --
lin coverage_N = variants{} ; --
lin wildlife_N = variants{} ; --
lin indicator_N = variants{} ; --
lin lightly_Adv = variants{} ; --
lin hierarchy_N = variants{} ; --
lin evolve_V2 = variants{} ; --
lin evolve_V = variants{} ; --
lin mechanical_A = variants{} ; --
lin expert_A = variants{} ; --
lin creditor_N = variants{} ; --
lin capitalist_N = variants{} ; --
lin essence_N = variants{} ; --
lin compose_V2 = variants{} ; --
lin compose_V = variants{} ; --
lin mentally_Adv = variants{} ; --
lin gaze_N = variants{} ; --
lin seminar_N = variants{} ; --
lin target_V2V = variants{} ; --
lin target_V2 = variants{} ; --
lin label_V3 = variants{} ; --
lin label_V2 = variants{} ; --
lin label_V = variants{} ; --
lin fig_N = variants{} ; --
lin continent_N = variants{} ; --
lin chap_N = variants{} ; --
lin flexibility_N = variants{} ; --
lin verse_N = variants{} ; --
lin minute_A = variants{} ; --
lin whisky_N = variants{} ; --
lin equivalent_A = variants{} ; --
lin recruit_V2 = variants{} ; --
lin recruit_V = variants{} ; --
lin echo_V2 = variants{} ; --
lin echo_V = variants{} ; --
lin unfair_A = variants{} ; --
lin launch_N = variants{} ; --
lin cupboard_N = variants{} ; --
lin bush_N = variants{} ; --
lin shortage_N = variants{} ; --
lin prominent_A = variants{} ; --
lin merger_N = variants{} ; --
lin command_V2 = variants{} ; --
lin command_V = variants{} ; --
lin subtle_A = variants{} ; --
lin capital_A = variants{} ; --
lin gang_N = variants{} ; --
lin fish_V2 = variants{} ; --
lin fish_V = variants{} ; --
lin unhappy_A = variants{} ; --
lin lifetime_N = variants{} ; --
lin elite_N = variants{} ; --
lin refusal_N = variants{} ; --
lin finish_N = variants{} ; --
lin aggressive_A = variants{} ; --
lin superior_A = variants{} ; --
lin landing_N = variants{} ; --
lin exchange_V2 = variants{} ; --
lin debate_V2 = variants{} ; --
lin debate_V = variants{} ; --
lin educate_V2 = variants{} ; --
lin separation_N = variants{} ; --
lin productivity_N = variants{} ; --
lin initiate_V2 = variants{} ; --
lin probability_N = variants{} ; --
lin virus_N = variants{} ; --
lin fool_N = variants{} ; --
lin pop_V2 = variants{} ; --
lin capitalism_N = variants{} ; --
lin painful_A = variants{} ; --
lin correctly_Adv = variants{} ; --
lin complex_N = variants{} ; --
lin rumour_N = variants{} ; --
lin imperial_A = variants{} ; --
lin justification_N = variants{} ; --
lin availability_N = variants{} ; --
lin spectacular_A = variants{} ; --
lin remain_N = variants{} ; --
lin ocean_N = variants{} ; --
lin cliff_N = variants{} ; --
lin sociology_N = variants{} ; --
lin sadly_Adv = variants{} ; --
lin missile_N = variants{} ; --
lin situate_V2 = variants{} ; --
lin artificial_A = variants{} ; --
lin apartment_N = L.apartment_N ;
lin provoke_V2 = variants{} ; --
lin oral_A = variants{} ; --
lin maximum_N = variants{} ; --
lin angel_N = variants{} ; --
lin spare_A = variants{} ; --
lin shame_N = variants{} ; --
lin intelligent_A = variants{} ; --
lin discretion_N = variants{} ; --
lin businessman_N = variants{} ; --
lin explicit_A = variants{} ; --
lin book_V2 = variants{} ; --
lin uniform_N = variants{} ; --
lin push_N = variants{} ; --
lin counter_N = variants{} ; --
lin subject_A = variants{} ; --
lin objective_A = variants{} ; --
lin hungry_A = variants{} ; --
lin clothing_N = variants{} ; --
lin ride_N = variants{} ; --
lin romantic_A = variants{} ; --
lin attendance_N = variants{} ; --
lin part_time_A = variants{} ; --
lin trace_N = variants{} ; --
lin backing_N = variants{} ; --
lin sensation_N = variants{} ; --
lin carrier_N = variants{} ; --
lin interest_V2 = variants{} ; --
lin interest_V = variants{} ; --
lin classification_N = variants{} ; --
lin classic_N = variants{} ; --
lin beg_V2 = variants{}; -- L.beg_V2V ; -- comment=CHECKED
lin beg_V = variants{}; -- L.beg_V2V ; -- comment=CHECKED
lin appendix_N = variants{} ; --
lin doorway_N = variants{} ; --
lin density_N = variants{} ; --
lin working_class_A = variants{} ; --
lin legislative_A = variants{} ; --
lin hint_N = variants{} ; --
lin shower_N = variants{} ; --
lin current_N = variants{} ; --
lin succession_N = variants{} ; --
lin nasty_A = variants{} ; --
lin duration_N = variants{} ; --
lin desert_N = variants{} ; --
lin receipt_N = variants{} ; --
lin native_A = variants{} ; --
lin chapel_N = variants{} ; --
lin amazing_A = variants{} ; --
lin hopefully_Adv = variants{} ; --
lin fleet_N = variants{} ; --
lin comparable_A = variants{} ; --
lin oxygen_N = variants{} ; --
lin installation_N = variants{} ; --
lin developer_N = variants{} ; --
lin disadvantage_N = variants{} ; --
lin recipe_N = variants{} ; --
lin crystal_N = variants{} ; --
lin modification_N = variants{} ; --
lin schedule_V2V = variants{} ; --
lin schedule_V2 = variants{} ; --
lin schedule_V = variants{} ; --
lin midnight_N = variants{} ; --
lin successive_A = variants{} ; --
lin formerly_Adv = variants{} ; --
lin loud_A = variants{} ; --
lin value_V2 = variants{} ; --
lin value_V = variants{} ; --
lin physics_N = variants{} ; --
lin truck_N = variants{} ; --
lin stroke_N = variants{} ; --
lin kiss_N = variants{} ; --
lin envelope_N = variants{} ; --
lin speculation_N = variants{} ; --
lin canal_N = variants{} ; --
lin unionist_N = variants{} ; --
lin directory_N = variants{} ; --
lin receiver_N = variants{} ; --
lin isolation_N = variants{} ; --
lin fade_V2 = variants{} ; --
lin fade_V = variants{} ; --
lin chemistry_N = variants{} ; --
lin unnecessary_A = variants{} ; --
lin hit_N = variants{} ; --
lin stance_N = variants{} ; --
lin sin_N = variants{} ; --
lin realistic_A = variants{} ; --
lin socialist_N = variants{} ; --
lin subsidy_N = variants{} ; --
lin content_A = variants{} ; --
lin toy_N = variants{} ; --
lin darling_N = variants{} ; --
lin decent_A = variants{} ; --
lin liberty_N = variants{} ; --
lin forever_Adv = variants{} ; --
lin skirt_N = variants{} ; --
lin coordinate_V2 = variants{} ; --
lin coordinate_V = variants{} ; --
lin tactic_N = variants{} ; --
lin influential_A = variants{} ; --
lin import_V2 = variants{} ; --
lin accent_N = variants{} ; --
lin compound_N = variants{} ; --
lin bastard_N = variants{} ; --
lin ingredient_N = variants{} ; --
lin dull_A = L.dull_A ;
lin cater_V = variants{} ; --
lin scholar_N = variants{} ; --
lin faint_A = variants{} ; --
lin ghost_N = variants{} ; --
lin sculpture_N = variants{} ; --
lin ridiculous_A = variants{} ; --
lin diagnosis_N = variants{} ; --
lin delegate_N = variants{} ; --
lin neat_A = variants{} ; --
lin kit_N = variants{} ; --
lin lion_N = variants{} ; --
lin dialogue_N = variants{} ; --
lin repair_V2 = variants{} ; --
lin repair_V = variants{} ; --
lin tray_N = variants{} ; --
lin fantasy_N = variants{} ; --
lin leave_N = variants{} ; --
lin export_V2 = variants{} ; --
lin export_V = variants{} ; --
lin forth_Adv = variants{} ; --
lin lamp_N = L.lamp_N ;
lin allege_VS = variants{} ; --
lin allege_V2 = variants{} ; --
lin pavement_N = variants{} ; --
lin brand_N = variants{} ; --
lin constable_N = variants{} ; --
lin compromise_N = variants{} ; --
lin flag_N = variants{} ; --
lin filter_N = variants{} ; --
lin reign_N = variants{} ; --
lin execute_V2 = variants{} ; --
lin pity_N = variants{} ; --
lin merit_N = variants{} ; --
lin diagram_N = variants{} ; --
lin wool_N = variants{} ; --
lin organism_N = variants{} ; --
lin elegant_A = variants{} ; --
lin red_N = variants{} ; --
lin undertaking_N = variants{} ; --
lin lesser_A = variants{} ; --
lin reach_N = variants{} ; --
lin marvellous_A = variants{} ; --
lin improved_A = variants{} ; --
lin locally_Adv = variants{} ; --
lin entity_N = variants{} ; --
lin rape_N = variants{} ; --
lin secure_A = variants{} ; --
lin descend_V2 = variants{} ; --
lin descend_V = variants{} ; --
lin backwards_Adv = variants{} ; --
lin peer_V = variants{} ; --
lin excuse_V2 = variants{} ; --
lin genetic_A = variants{} ; --
lin fold_V2 = variants{} ; --
lin fold_V = variants{} ; --
lin portfolio_N = variants{} ; --
lin consensus_N = variants{} ; --
lin thesis_N = variants{} ; --
lin shop_V = variants{} ; --
lin nest_N = variants{} ; --
lin frown_V = variants{} ; --
lin builder_N = variants{} ; --
lin administer_V2 = variants{} ; --
lin administer_V = variants{} ; --
lin tip_V2 = variants{} ; --
lin tip_V = variants{} ; --
lin lung_N = variants{} ; --
lin delegation_N = variants{} ; --
lin outside_N = variants{} ; --
lin heating_N = variants{} ; --
lin like_Subj = variants{} ; --
lin instinct_N = variants{} ; --
lin teenager_N = variants{} ; --
lin lonely_A = variants{} ; --
lin residence_N = variants{} ; --
lin radiation_N = variants{} ; --
lin extract_V2 = variants{} ; --
lin concession_N = variants{} ; --
lin autonomy_N = variants{} ; --
lin norm_N = variants{} ; --
lin graduate_N = variants{} ; --
lin glory_N = variants{} ; --
lin bear_N = variants{} ; --
lin persist_V = variants{} ; --
lin rescue_V2 = variants{} ; --
lin equip_V2 = variants{} ; --
lin partial_A = variants{} ; --
lin officially_Adv = variants{} ; --
lin capability_N = variants{} ; --
lin worry_N = variants{} ; --
lin liberation_N = variants{} ; --
lin hunt_V2 = L.hunt_V2 ;
lin hunt_V = variants{}; -- L.hunt_V2 ;
lin daily_Adv = variants{} ; --
lin heel_N = variants{} ; --
lin contract_V2V = variants{} ; --
lin contract_V2 = variants{} ; --
lin contract_V = variants{} ; --
lin update_V2 = variants{} ; --
lin assign_V2V = variants{} ; --
lin assign_V2 = variants{} ; --
lin spring_V2 = variants{} ; --
lin spring_V = variants{} ; --
lin single_N = variants{} ; --
lin commons_N = variants{} ; --
lin weekly_A = variants{} ; --
lin stretch_N = variants{} ; --
lin pregnancy_N = variants{} ; --
lin happily_Adv = variants{} ; --
lin spectrum_N = variants{} ; --
lin interfere_V = variants{} ; --
lin suicide_N = variants{} ; --
lin panic_N = variants{} ; --
lin invent_V2 = variants{} ; --
lin invent_V = variants{} ; --
lin intensive_A = variants{} ; --
lin damp_A = variants{} ; --
lin simultaneously_Adv = variants{} ; --
lin giant_N = variants{} ; --
lin casual_A = variants{} ; --
lin sphere_N = variants{} ; --
lin precious_A = variants{} ; --
lin sword_N = variants{} ; --
lin envisage_V2 = variants{} ; --
lin bean_N = variants{} ; --
lin time_V2 = variants{} ; --
lin crazy_A = variants{} ; --
lin changing_A = variants{} ; --
lin primary_N = variants{} ; --
lin concede_VS = variants{} ; --
lin concede_V2 = variants{} ; --
lin concede_V = variants{} ; --
lin besides_Adv = variants{} ; --
lin unite_V2 = variants{} ; --
lin unite_V = variants{} ; --
lin severely_Adv = variants{} ; --
lin separately_Adv = variants{} ; --
lin instruct_V2 = variants{} ; --
lin insert_V2 = variants{} ; --
lin go_N = variants{} ; --
lin exhibit_V2 = variants{} ; --
lin brave_A = variants{} ; --
lin tutor_N = variants{} ; --
lin tune_N = variants{} ; --
lin debut_N = variants{} ; --
lin debut_2_N = variants{} ; --
lin debut_1_N = variants{} ; --
lin continued_A = variants{} ; --
lin bid_V2 = variants{} ; --
lin bid_V = variants{} ; --
lin incidence_N = variants{} ; --
lin downstairs_Adv = variants{} ; --
lin cafe_N = variants{} ; --
lin regret_VS = variants{} ; --
lin regret_V2 = variants{} ; --
lin killer_N = variants{} ; --
lin delicate_A = variants{} ; --
lin subsidiary_N = variants{} ; --
lin gender_N = variants{} ; --
lin entertain_V2 = variants{} ; --
lin cling_V = variants{} ; --
lin vertical_A = variants{} ; --
lin fetch_V2 = variants{} ; --
lin strip_V2 = variants{} ; --
lin strip_V = variants{} ; --
lin plead_VS = variants{} ; --
lin plead_V2 = variants{} ; --
lin plead_V = variants{} ; --
lin duck_N = variants{} ; --
lin breed_N = variants{} ; --
lin assistant_A = variants{} ; --
lin pint_N = variants{} ; --
lin abolish_V2 = variants{} ; --
lin translation_N = variants{} ; --
lin princess_N = variants{} ; --
lin line_V2 = variants{} ; --
lin line_V = variants{} ; --
lin excessive_A = variants{} ; --
lin digital_A = variants{} ; --
lin steep_A = variants{} ; --
lin jet_N = variants{} ; --
lin hey_Interj = variants{} ; --
lin grave_N = variants{} ; --
lin exceptional_A = variants{} ; --
lin boost_V2 = variants{} ; --
lin random_A = variants{} ; --
lin correlation_N = variants{} ; --
lin outline_N = variants{} ; --
lin intervene_V2V = variants{} ; --
lin intervene_V = variants{} ; --
lin packet_N = variants{} ; --
lin motivation_N = variants{} ; --
lin safely_Adv = variants{} ; --
lin harsh_A = variants{} ; --
lin spell_N = variants{} ; --
lin spread_N = variants{} ; --
lin draw_N = variants{} ; --
lin concrete_A = variants{} ; --
lin complicated_A = variants{} ; --
lin alleged_A = variants{} ; --
lin redundancy_N = variants{} ; --
lin progressive_A = variants{} ; --
lin intensity_N = variants{} ; --
lin crack_N = variants{} ; --
lin fly_N = variants{} ; --
lin fancy_V2 = variants{} ; --
lin alternatively_Adv = variants{} ; --
lin waiting_A = variants{} ; --
lin scandal_N = variants{} ; --
lin resemble_V2 = variants{} ; --
lin parameter_N = variants{} ; --
lin fierce_A = variants{} ; --
lin tropical_A = variants{} ; --
lin colour_V2A = variants{} ; --
lin colour_V2 = variants{} ; --
lin colour_V = variants{} ; --
lin engagement_N = variants{} ; --
lin contest_N = variants{} ; --
lin edit_V2 = variants{} ; --
lin courage_N = variants{} ; --
lin hip_N = variants{} ; --
lin delighted_A = variants{} ; --
lin sponsor_V2 = variants{} ; --
lin carer_N = variants{} ; --
lin crack_V2 = variants{} ; --
lin substantially_Adv = variants{} ; --
lin occupational_A = variants{} ; --
lin trainer_N = variants{} ; --
lin remainder_N = variants{} ; --
lin related_A = variants{} ; --
lin inherit_V2 = variants{} ; --
lin inherit_V = variants{} ; --
lin resume_V2 = variants{} ; --
lin resume_V = variants{} ; --
lin assignment_N = variants{} ; --
lin conceal_V2 = variants{} ; --
lin disclose_VS = variants{} ; --
lin disclose_V2 = variants{} ; --
lin disclose_V = variants{} ; --
lin exclusively_Adv = variants{} ; --
lin working_N = variants{} ; --
lin mild_A = variants{} ; --
lin chronic_A = variants{} ; --
lin splendid_A = variants{} ; --
lin function_V = variants{} ; --
lin clay_N = variants{} ; --
lin firstly_Adv = variants{} ; --
lin conceive_V2 = variants{} ; --
lin conceive_V = variants{} ; --
lin politically_Adv = variants{} ; --
lin terminal_N = variants{} ; --
lin accuracy_N = variants{} ; --
lin coup_N = variants{} ; --
lin ambulance_N = variants{} ; --
lin living_N = variants{} ; --
lin similarity_N = variants{} ; --
lin orchestra_N = variants{} ; --
lin brush_N = variants{} ; --
lin systematic_A = variants{} ; --
lin striker_N = variants{} ; --
lin guard_V2 = variants{} ; --
lin guard_V = variants{} ; --
lin casualty_N = variants{} ; --
lin steadily_Adv = variants{} ; --
lin painter_N = variants{} ; --
lin opt_VV = variants{} ; --
lin opt_V = variants{} ; --
lin handsome_A = variants{} ; --
lin banking_N = variants{} ; --
lin sensitivity_N = variants{} ; --
lin navy_N = variants{} ; --
lin fascinating_A = variants{} ; --
lin disappointment_N = variants{} ; --
lin auditor_N = variants{} ; --
lin hostility_N = variants{} ; --
lin spending_N = variants{} ; --
lin scarcely_Adv = variants{} ; --
lin compulsory_A = variants{} ; --
lin photographer_N = variants{} ; --
lin ok_Interj = variants{} ; --
lin neighbourhood_N = variants{} ; --
lin ideological_A = variants{} ; --
lin wide_Adv = variants{} ; --
lin pardon_N = variants{} ; --
lin double_N = variants{} ; --
lin criticize_V2 = variants{} ; --
lin criticize_V = variants{} ; --
lin supervision_N = variants{} ; --
lin guilt_N = variants{} ; --
lin deck_N = variants{} ; --
lin payable_A = variants{} ; --
lin execution_N = variants{} ; --
lin suite_N = variants{} ; --
lin elected_A = variants{} ; --
lin solely_Adv = variants{} ; --
lin moral_N = variants{} ; --
lin collector_N = variants{} ; --
lin questionnaire_N = variants{} ; --
lin flavour_N = variants{} ; --
lin couple_V2 = variants{} ; --
lin couple_V = variants{} ; --
lin faculty_N = variants{} ; --
lin tour_V2 = variants{} ; --
lin tour_V = variants{} ; --
lin basket_N = variants{} ; --
lin mention_N = variants{} ; --
lin kick_N = variants{} ; --
lin horizon_N = variants{} ; --
lin drain_V2 = variants{} ; --
lin drain_V = variants{} ; --
lin happiness_N = variants{} ; --
lin fighter_N = variants{} ; --
lin estimated_A = variants{} ; --
lin copper_N = variants{} ; --
lin legend_N = variants{} ; --
lin relevance_N = variants{} ; --
lin decorate_V2 = variants{} ; --
lin continental_A = variants{} ; --
lin ship_V2 = variants{} ; --
lin ship_V = variants{} ; --
lin operational_A = variants{} ; --
lin incur_V2 = variants{} ; --
lin parallel_A = variants{} ; --
lin divorce_N = variants{} ; --
lin opposed_A = variants{} ; --
lin equilibrium_N = variants{} ; --
lin trader_N = variants{} ; --
lin ton_N = variants{} ; --
lin can_N = variants{} ; --
lin juice_N = variants{} ; --
lin forum_N = variants{} ; --
lin spin_V2 = variants{} ; --
lin spin_V = variants{} ; --
lin research_V2 = variants{} ; --
lin research_V = variants{} ; --
lin hostile_A = variants{} ; --
lin consistently_Adv = variants{} ; --
lin technological_A = variants{} ; --
lin nightmare_N = variants{} ; --
lin medal_N = variants{} ; --
lin diamond_N = variants{} ; --
lin speed_V2 = variants{} ; --
lin speed_V = variants{} ; --
lin peaceful_A = variants{} ; --
lin accounting_A = variants{} ; --
lin scatter_V2 = variants{} ; --
lin scatter_V = variants{} ; --
lin monster_N = variants{} ; --
lin horrible_A = variants{} ; --
lin nonsense_N = variants{} ; --
lin chaos_N = variants{} ; --
lin accessible_A = variants{} ; --
lin humanity_N = variants{} ; --
lin frustration_N = variants{} ; --
lin chin_N = variants{} ; --
lin bureau_N = variants{} ; --
lin advocate_VS = variants{} ; --
lin advocate_V2 = variants{} ; --
lin polytechnic_N = variants{} ; --
lin inhabitant_N = variants{} ; --
lin evil_A = variants{} ; --
lin slave_N = variants{} ; --
lin reservation_N = variants{} ; --
lin slam_V2 = variants{} ; --
lin slam_V = variants{} ; --
lin handle_N = variants{} ; --
lin provincial_A = variants{} ; --
lin fishing_N = variants{} ; --
lin facilitate_V2 = variants{} ; --
lin yield_N = variants{} ; --
lin elbow_N = variants{} ; --
lin bye_Interj = variants{} ; --
lin warm_V2 = variants{} ; --
lin warm_V = variants{} ; --
lin sleeve_N = variants{} ; --
lin exploration_N = variants{} ; --
lin creep_V = variants{} ; --
lin adjacent_A = variants{} ; --
lin theft_N = variants{} ; --
lin round_V2 = variants{} ; --
lin round_V = variants{} ; --
lin grace_N = variants{} ; --
lin predecessor_N = variants{} ; --
lin supermarket_N = variants{} ; --
lin smart_A = variants{} ; --
lin sergeant_N = variants{} ; --
lin regulate_V2 = variants{} ; --
lin clash_N = variants{} ; --
lin assemble_V2 = variants{} ; --
lin assemble_V = variants{} ; --
lin arrow_N = variants{} ; --
lin nowadays_Adv = variants{} ; --
lin giant_A = variants{} ; --
lin waiting_N = variants{} ; --
lin tap_N = variants{} ; --
lin shit_N = variants{} ; --
lin sandwich_N = variants{} ; --
lin vanish_V = variants{} ; --
lin commerce_N = variants{} ; --
lin pursuit_N = variants{} ; --
lin post_war_A = variants{} ; --
lin will_V2 = variants{} ; --
lin will_V = variants{} ; --
lin waste_A = variants{} ; --
lin collar_N = variants{} ; --
lin socialism_N = variants{} ; --
lin skill_V = variants{} ; --
lin rice_N = variants{} ; --
lin exclusion_N = variants{} ; --
lin upwards_Adv = variants{} ; --
lin transmission_N = variants{} ; --
lin instantly_Adv = variants{} ; --
lin forthcoming_A = variants{} ; --
lin appointed_A = variants{} ; --
lin geographical_A = variants{} ; --
lin fist_N = variants{} ; --
lin abstract_A = variants{} ; --
lin embrace_V2 = variants{} ; --
lin embrace_V = variants{} ; --
lin dynamic_A = variants{} ; --
lin drawer_N = variants{} ; --
lin dismissal_N = variants{} ; --
lin magic_N = variants{} ; --
lin endless_A = variants{} ; --
lin definite_A = variants{} ; --
lin broadly_Adv = variants{} ; --
lin affection_N = variants{} ; --
lin dawn_N = variants{} ; --
lin principal_N = variants{} ; --
lin bloke_N = variants{} ; --
lin trap_N = variants{} ; --
lin communist_A = variants{} ; --
lin competence_N = variants{} ; --
lin complicate_V2 = variants{} ; --
lin neutral_A = variants{} ; --
lin fortunately_Adv = variants{} ; --
lin commonwealth_N = variants{} ; --
lin breakdown_N = variants{} ; --
lin combined_A = variants{} ; --
lin candle_N = variants{} ; --
lin venue_N = variants{} ; --
lin supper_N = variants{} ; --
lin analyst_N = variants{} ; --
lin vague_A = variants{} ; --
lin publicly_Adv = variants{} ; --
lin marine_A = variants{} ; --
lin fair_Adv = variants{} ; --
lin pause_N = variants{} ; --
lin notable_A = variants{} ; --
lin freely_Adv = variants{} ; --
lin counterpart_N = variants{} ; --
lin lively_A = variants{} ; --
lin script_N = variants{} ; --
lin sue_V2V = variants{} ; --
lin sue_V2 = variants{} ; --
lin sue_V = variants{} ; --
lin legitimate_A = variants{} ; --
lin geography_N = variants{} ; --
lin reproduce_V2 = variants{} ; --
lin reproduce_V = variants{} ; --
lin moving_A = variants{} ; --
lin lamb_N = variants{} ; --
lin gay_A = variants{} ; --
lin contemplate_VS = variants{} ; --
lin contemplate_V2 = variants{} ; --
lin contemplate_V = variants{} ; --
lin terror_N = variants{} ; --
lin stable_N = variants{} ; --
lin founder_N = variants{} ; --
lin utility_N = variants{} ; --
lin signal_VS = variants{} ; --
lin signal_V2 = variants{} ; --
lin shelter_N = variants{} ; --
lin poster_N = variants{} ; --
lin hitherto_Adv = variants{} ; --
lin mature_A = variants{} ; --
lin cooking_N = variants{} ; --
lin head_A = variants{} ; --
lin wealthy_A = variants{} ; --
lin fucking_A = variants{} ; --
lin confess_VS = variants{} ; --
lin confess_V2 = variants{} ; --
lin confess_V = variants{} ; --
lin age_V = variants{} ; --
lin miracle_N = variants{} ; --
lin magic_A = variants{} ; --
lin jaw_N = variants{} ; --
lin pan_N = variants{} ; --
lin coloured_A = variants{} ; --
lin tent_N = variants{} ; --
lin telephone_V2 = variants{} ; --
lin telephone_V = variants{} ; --
lin reduced_A = variants{} ; --
lin tumour_N = variants{} ; --
lin super_A = variants{} ; --
lin funding_N = variants{} ; --
lin dump_V2 = variants{} ; --
lin dump_V = variants{} ; --
lin stitch_N = variants{} ; --
lin shared_A = variants{} ; --
lin ladder_N = variants{} ; --
lin keeper_N = variants{} ; --
lin endorse_V2 = variants{} ; --
lin invariably_Adv = variants{} ; --
lin smash_V2 = variants{} ; --
lin smash_V = variants{} ; --
lin shield_N = variants{} ; --
lin heat_V2 = variants{} ; --
lin heat_V = variants{} ; --
lin surgeon_N = variants{} ; --
lin centre_V2 = variants{} ; --
lin centre_V = variants{} ; --
lin orange_N = variants{} ; --
lin orange_2_N = variants{} ; --
lin orange_1_N = variants{} ; --
lin explode_V = variants{} ; --
lin comedy_N = variants{} ; --
lin classify_V2 = variants{} ; --
lin artistic_A = variants{} ; --
lin ruler_N = variants{} ; --
lin biscuit_N = variants{} ; --
lin workstation_N = variants{} ; --
lin prey_N = variants{} ; --
lin manual_N = variants{} ; --
lin cure_N = variants{} ; --
lin cure_2_N = variants{} ; --
lin cure_1_N = variants{} ; --
lin overall_N = variants{} ; --
lin tighten_V2 = variants{} ; --
lin tighten_V = variants{} ; --
lin tax_V2 = variants{} ; --
lin pope_N = variants{} ; --
lin manufacturing_A = variants{} ; --
lin adult_A = variants{} ; --
lin rush_N = variants{} ; --
lin blanket_N = variants{} ; --
lin republican_N = variants{} ; --
lin referendum_N = variants{} ; --
lin palm_N = variants{} ; --
lin nearby_Adv = variants{} ; --
lin mix_N = variants{} ; --
lin devil_N = variants{} ; --
lin adoption_N = variants{} ; --
lin workforce_N = variants{} ; --
lin segment_N = variants{} ; --
lin regardless_Adv = variants{} ; --
lin contractor_N = variants{} ; --
lin portion_N = variants{} ; --
lin differently_Adv = variants{} ; --
lin deposit_V2 = variants{} ; --
lin cook_N = variants{} ; --
lin prediction_N = variants{} ; --
lin oven_N = variants{} ; --
lin matrix_N = variants{} ; --
lin liver_N = L.liver_N ;
lin fraud_N = variants{} ; --
lin beam_N = variants{} ; --
lin signature_N = variants{} ; --
lin limb_N = variants{} ; --
lin verdict_N = variants{} ; --
lin dramatically_Adv = variants{} ; --
lin container_N = variants{} ; --
lin aunt_N = variants{} ; --
lin dock_N = variants{} ; --
lin submission_N = variants{} ; --
lin arm_V2 = variants{} ; --
lin arm_V = variants{} ; --
lin odd_N = variants{} ; --
lin certainty_N = variants{} ; --
lin boring_A = variants{} ; --
lin electron_N = variants{} ; --
lin drum_N = variants{} ; --
lin wisdom_N = variants{} ; --
lin antibody_N = variants{} ; --
lin unlike_A = variants{} ; --
lin terrorist_N = variants{} ; --
lin post_V2 = variants{} ; --
lin post_V = variants{} ; --
lin circulation_N = variants{} ; --
lin alteration_N = variants{} ; --
lin fluid_N = variants{} ; --
lin ambitious_A = variants{} ; --
lin socially_Adv = variants{} ; --
lin riot_N = variants{} ; --
lin petition_N = variants{} ; --
lin fox_N = variants{} ; --
lin recruitment_N = variants{} ; --
lin well_known_A = variants{} ; --
lin top_V2 = variants{} ; --
lin service_V2 = variants{} ; --
lin flood_V2 = variants{} ; --
lin flood_V = variants{} ; --
lin taste_V2 = variants{} ; --
lin taste_V = variants{} ; --
lin memorial_N = variants{} ; --
lin helicopter_N = variants{} ; --
lin correspondence_N = variants{} ; --
lin beef_N = variants{} ; --
lin overall_Adv = variants{} ; --
lin lighting_N = variants{} ; --
lin harbour_N = L.harbour_N ;
lin empirical_A = variants{} ; --
lin shallow_A = variants{} ; --
lin seal_V2 = variants{} ; --
lin seal_V = variants{} ; --
lin decrease_V2 = variants{} ; --
lin decrease_V = variants{} ; --
lin constituent_N = variants{} ; --
lin exam_N = variants{} ; --
lin toe_N = variants{} ; --
lin reward_V2 = variants{} ; --
lin thrust_V2 = variants{} ; --
lin thrust_V = variants{} ; --
lin bureaucracy_N = variants{} ; --
lin wrist_N = variants{} ; --
lin nut_N = variants{} ; --
lin plain_N = variants{} ; --
lin magnetic_A = variants{} ; --
lin evil_N = variants{} ; --
lin widen_V2 = variants{} ; --
lin hazard_N = variants{} ; --
lin dispose_V2 = variants{} ; --
lin dispose_V = variants{} ; --
lin dealing_N = variants{} ; --
lin absent_A = variants{} ; --
lin reassure_V2S = variants{} ; --
lin reassure_V2 = variants{} ; --
lin model_V2 = variants{} ; --
lin model_V = variants{} ; --
lin inn_N = variants{} ; --
lin initial_N = variants{} ; --
lin suspension_N = variants{} ; --
lin respondent_N = variants{} ; --
lin over_N = variants{} ; --
lin naval_A = variants{} ; --
lin monthly_A = variants{} ; --
lin log_N = variants{} ; --
lin advisory_A = variants{} ; --
lin fitness_N = variants{} ; --
lin blank_A = variants{} ; --
lin indirect_A = variants{} ; --
lin tile_N = variants{} ; --
lin rally_N = variants{} ; --
lin economist_N = variants{} ; --
lin vein_N = variants{} ; --
lin strand_N = variants{} ; --
lin disturbance_N = variants{} ; --
lin stuff_V2 = variants{} ; --
lin seldom_Adv = variants{} ; --
lin coming_A = variants{} ; --
lin cab_N = variants{} ; --
lin grandfather_N = variants{} ; --
lin flash_V = variants{} ; --
lin destination_N = variants{} ; --
lin actively_Adv = variants{} ; --
lin regiment_N = variants{} ; --
lin closed_A = variants{} ; --
lin boom_N = variants{} ; --
lin handful_N = variants{} ; --
lin remarkably_Adv = variants{} ; --
lin encouragement_N = variants{} ; --
lin awkward_A = variants{} ; --
lin required_A = variants{} ; --
lin flood_N = variants{} ; --
lin defect_N = variants{} ; --
lin surplus_N = variants{} ; --
lin champagne_N = variants{} ; --
lin liquid_N = variants{} ; --
lin shed_V2 = variants{} ; --
lin welcome_N = variants{} ; --
lin rejection_N = variants{} ; --
lin discipline_V2 = variants{} ; --
lin halt_V2 = variants{} ; --
lin halt_V = variants{} ; --
lin electronics_N = variants{} ; --
lin sentence_V2 = variants{} ; --
lin sentence_V = variants{} ; --
lin ill_Adv = variants{} ; --
lin contradiction_N = variants{} ; --
lin nail_N = variants{} ; --
lin senior_N = variants{} ; --
lin lacking_A = variants{} ; --
lin colonial_A = variants{} ; --
lin primitive_A = variants{} ; --
lin whoever_NP = variants{} ; --
lin lap_N = variants{} ; --
lin commodity_N = variants{} ; --
lin planned_A = variants{} ; --
lin intellectual_N = variants{} ; --
lin imprisonment_N = variants{} ; --
lin coincide_V = variants{} ; --
lin sympathetic_A = variants{} ; --
lin atom_N = variants{} ; --
lin tempt_V2V = variants{} ; --
lin tempt_V2 = variants{} ; --
lin sanction_N = variants{} ; --
lin praise_V2 = variants{} ; --
lin favourable_A = variants{} ; --
lin dissolve_V2 = variants{} ; --
lin dissolve_V = variants{} ; --
lin tightly_Adv = variants{} ; --
lin surrounding_N = variants{} ; --
lin soup_N = variants{} ; --
lin encounter_N = variants{} ; --
lin abortion_N = variants{} ; --
lin grasp_V2 = variants{} ; --
lin grasp_V = variants{} ; --
lin custody_N = variants{} ; --
lin composer_N = variants{} ; --
lin charm_N = variants{} ; --
lin short_term_A = variants{} ; --
lin metropolitan_A = variants{} ; --
lin waist_N = variants{} ; --
lin equality_N = variants{} ; --
lin tribute_N = variants{} ; --
lin bearing_N = variants{} ; --
lin auction_N = variants{} ; --
lin standing_N = variants{} ; --
lin manufacture_N = variants{} ; --
lin horn_N = L.horn_N ;
lin barn_N = variants{} ; --
lin mayor_N = variants{} ; --
lin emperor_N = variants{} ; --
lin rescue_N = variants{} ; --
lin integrated_A = variants{} ; --
lin conscience_N = variants{} ; --
lin commence_V2 = variants{} ; --
lin commence_V = variants{} ; --
lin grandmother_N = variants{} ; --
lin discharge_V2 = variants{} ; --
lin discharge_V = variants{} ; --
lin profound_A = variants{} ; --
lin takeover_N = variants{} ; --
lin nationalist_N = variants{} ; --
lin effect_V2 = variants{} ; --
lin dolphin_N = variants{} ; --
lin fortnight_N = variants{} ; --
lin elephant_N = variants{} ; --
lin seal_N = variants{} ; --
lin spoil_V2 = variants{} ; --
lin spoil_V = variants{} ; --
lin plea_N = variants{} ; --
lin forwards_Adv = variants{} ; --
lin breeze_N = variants{} ; --
lin prevention_N = variants{} ; --
lin mineral_N = variants{} ; --
lin runner_N = variants{} ; --
lin pin_V2 = variants{} ; --
lin integrity_N = variants{} ; --
lin thereafter_Adv = variants{} ; --
lin quid_N = variants{} ; --
lin owl_N = variants{} ; --
lin rigid_A = variants{} ; --
lin orange_A = variants{} ; --
lin draft_V2 = variants{} ; --
lin reportedly_Adv = variants{} ; --
lin hedge_N = variants{} ; --
lin formulate_V2 = variants{} ; --
lin associated_A = variants{} ; --
lin position_V2 = variants{} ; --
lin thief_N = variants{} ; --
lin tomato_N = variants{} ; --
lin exhaust_V2 = variants{} ; --
lin evidently_Adv = variants{} ; --
lin eagle_N = variants{} ; --
lin specified_A = variants{} ; --
lin resulting_A = variants{} ; --
lin blade_N = variants{} ; --
lin peculiar_A = variants{} ; --
lin killing_N = variants{} ; --
lin desktop_N = variants{} ; --
lin bowel_N = variants{} ; --
lin long_V = variants{} ; --
lin ugly_A = L.ugly_A ;
lin expedition_N = variants{} ; --
lin saint_N = variants{} ; --
lin variable_A = variants{} ; --
lin supplement_V2 = variants{} ; --
lin stamp_N = variants{} ; --
lin slide_N = variants{} ; --
lin faction_N = variants{} ; --
lin enthusiastic_A = variants{} ; --
lin enquire_V2 = variants{} ; --
lin enquire_V = variants{} ; --
lin brass_N = variants{} ; --
lin inequality_N = variants{} ; --
lin eager_A = variants{} ; --
lin bold_A = variants{} ; --
lin neglect_V2 = variants{} ; --
lin saying_N = variants{} ; --
lin ridge_N = variants{} ; --
lin earl_N = variants{} ; --
lin yacht_N = variants{} ; --
lin suck_V2 = L.suck_V2 ;
lin suck_V = variants{}; -- L.suck_V2 ;
lin missing_A = variants{} ; --
lin extended_A = variants{} ; --
lin valuation_N = variants{} ; --
lin delight_V2 = variants{} ; --
lin delight_V = variants{} ; --
lin beat_N = variants{} ; --
lin worship_N = variants{} ; --
lin fossil_N = variants{} ; --
lin diminish_V2 = variants{} ; --
lin diminish_V = variants{} ; --
lin taxpayer_N = variants{} ; --
lin corruption_N = variants{} ; --
lin accurately_Adv = variants{} ; --
lin honour_V2 = variants{} ; --
lin depict_V2 = variants{} ; --
lin pencil_N = variants{} ; --
lin drown_V2 = variants{} ; --
lin drown_V = variants{} ; --
lin stem_N = variants{} ; --
lin lump_N = variants{} ; --
lin applicable_A = variants{} ; --
lin rate_V2 = variants{} ; --
lin rate_V = variants{} ; --
lin mobility_N = variants{} ; --
lin immense_A = variants{} ; --
lin goodness_N = variants{} ; --
lin price_V2V = variants{} ; --
lin price_V2 = variants{} ; --
lin price_V = variants{} ; --
lin preliminary_A = variants{} ; --
lin graph_N = variants{} ; --
lin referee_N = variants{} ; --
lin calm_A = variants{} ; --
lin onwards_Adv = variants{} ; --
lin omit_V2 = variants{} ; --
lin genuinely_Adv = variants{} ; --
lin excite_V2 = variants{} ; --
lin dreadful_A = variants{} ; --
lin cave_N = variants{} ; --
lin revelation_N = variants{} ; --
lin grief_N = variants{} ; --
lin erect_V2 = variants{} ; --
lin tuck_V2 = variants{} ; --
lin tuck_V = variants{} ; --
lin meantime_N = variants{} ; --
lin barrel_N = variants{} ; --
lin lawn_N = variants{} ; --
lin hut_N = variants{} ; --
lin swing_N = variants{} ; --
lin subject_V2 = variants{} ; --
lin ruin_V2 = variants{} ; --
lin slice_N = variants{} ; --
lin transmit_V2 = variants{} ; --
lin thigh_N = variants{} ; --
lin practically_Adv = variants{} ; --
lin dedicate_V2 = variants{} ; --
lin mistake_V2 = variants{} ; --
lin mistake_V = variants{} ; --
lin corresponding_A = variants{} ; --
lin albeit_Subj = variants{} ; --
lin sound_A = variants{} ; --
lin nurse_V2 = variants{} ; --
lin discharge_N = variants{} ; --
lin comparative_A = variants{} ; --
lin cluster_N = variants{} ; --
lin propose_VV = variants{} ; --
lin propose_VS = variants{} ; --
lin propose_V2 = variants{} ; --
lin propose_V = variants{} ; --
lin obstacle_N = variants{} ; --
lin motorway_N = variants{} ; --
lin heritage_N = variants{} ; --
lin counselling_N = variants{} ; --
lin breeding_N = variants{} ; --
lin characteristic_A = variants{} ; --
lin bucket_N = variants{} ; --
lin migration_N = variants{} ; --
lin campaign_V = variants{} ; --
lin ritual_N = variants{} ; --
lin originate_V2 = variants{} ; --
lin originate_V = variants{} ; --
lin hunting_N = variants{} ; --
lin crude_A = variants{} ; --
lin protocol_N = variants{} ; --
lin prejudice_N = variants{} ; --
lin inspiration_N = variants{} ; --
lin dioxide_N = variants{} ; --
lin chemical_A = variants{} ; --
lin uncomfortable_A = variants{} ; --
lin worthy_A = variants{} ; --
lin inspect_V2 = variants{} ; --
lin summon_V2 = variants{} ; --
lin parallel_N = variants{} ; --
lin outlet_N = variants{} ; --
lin okay_A = variants{} ; --
lin collaboration_N = variants{} ; --
lin booking_N = variants{} ; --
lin salad_N = variants{} ; --
lin productive_A = variants{} ; --
lin charming_A = variants{} ; --
lin polish_A = variants{} ; --
lin oak_N = variants{} ; --
lin access_V2 = variants{} ; --
lin tourism_N = variants{} ; --
lin independently_Adv = variants{} ; --
lin cruel_A = variants{} ; --
lin diversity_N = variants{} ; --
lin accused_A = variants{} ; --
lin supplement_N = variants{} ; --
lin fucking_Adv = variants{} ; --
lin forecast_N = variants{} ; --
lin amend_V2V = variants{} ; --
lin amend_V2 = variants{} ; --
lin amend_V = variants{} ; --
lin soap_N = variants{} ; --
lin ruling_N = variants{} ; --
lin interference_N = variants{} ; --
lin executive_A = variants{} ; --
lin mining_N = variants{} ; --
lin minimal_A = variants{} ; --
lin clarify_V2 = variants{} ; --
lin clarify_V = variants{} ; --
lin strain_V2 = variants{} ; --
lin novel_A = variants{} ; --
lin try_N = variants{} ; --
lin coastal_A = variants{} ; --
lin rising_A = variants{} ; --
lin quota_N = variants{} ; --
lin minus_Prep = variants{} ; --
lin kilometre_N = variants{} ; --
lin characterize_V2 = variants{} ; --
lin suspicious_A = variants{} ; --
lin pet_N = variants{} ; --
lin beneficial_A = variants{} ; --
lin fling_V2 = variants{} ; --
lin fling_V = variants{} ; --
lin deprive_V2 = variants{} ; --
lin covenant_N = variants{} ; --
lin bias_N = variants{} ; --
lin trophy_N = variants{} ; --
lin verb_N = variants{} ; --
lin honestly_Adv = variants{} ; --
lin extract_N = variants{} ; --
lin straw_N = variants{} ; --
lin stem_V2 = variants{} ; --
lin stem_V = variants{} ; --
lin eyebrow_N = variants{} ; --
lin noble_A = variants{} ; --
lin mask_N = variants{} ; --
lin lecturer_N = variants{} ; --
lin girlfriend_N = variants{} ; --
lin forehead_N = variants{} ; --
lin timetable_N = variants{} ; --
lin symbolic_A = variants{} ; --
lin farming_N = variants{} ; --
lin lid_N = variants{} ; --
lin librarian_N = variants{} ; --
lin injection_N = variants{} ; --
lin sexuality_N = variants{} ; --
lin irrelevant_A = variants{} ; --
lin bonus_N = variants{} ; --
lin abuse_V2 = variants{} ; --
lin thumb_N = variants{} ; --
lin survey_V2 = variants{} ; --
lin ankle_N = variants{} ; --
lin psychologist_N = variants{} ; --
lin occurrence_N = variants{} ; --
lin profitable_A = variants{} ; --
lin deliberate_A = variants{} ; --
lin bow_V2 = variants{} ; --
lin bow_V = variants{} ; --
lin tribe_N = variants{} ; --
lin rightly_Adv = variants{} ; --
lin representative_A = variants{} ; --
lin code_V2 = variants{} ; --
lin validity_N = variants{} ; --
lin marble_N = variants{} ; --
lin bow_N = variants{} ; --
lin plunge_V2 = variants{} ; --
lin plunge_V = variants{} ; --
lin maturity_N = variants{} ; --
lin maturity_3_N = variants{} ; --
lin maturity_2_N = variants{} ; --
lin maturity_1_N = variants{} ; --
lin hidden_A = variants{} ; --
lin contrast_V2 = variants{} ; --
lin contrast_V = variants{} ; --
lin tobacco_N = variants{} ; --
lin middle_class_A = variants{} ; --
lin grip_V2 = variants{} ; --
lin clergy_N = variants{} ; --
lin trading_A = variants{} ; --
lin passive_A = variants{} ; --
lin decoration_N = variants{} ; --
lin racial_A = variants{} ; --
lin well_N = variants{} ; --
lin embarrassment_N = variants{} ; --
lin sauce_N = variants{} ; --
lin fatal_A = variants{} ; --
lin banker_N = variants{} ; --
lin compensate_V2 = variants{} ; --
lin compensate_V = variants{} ; --
lin make_up_N = variants{} ; --
lin popularity_N = variants{} ; --
lin interior_A = variants{} ; --
lin eligible_A = variants{} ; --
lin continuity_N = variants{} ; --
lin bunch_N = variants{} ; --
lin hook_N = variants{} ; --
lin wicket_N = variants{} ; --
lin pronounce_V2 = variants{} ; --
lin pronounce_V = variants{} ; --
lin ballet_N = variants{} ; --
lin heir_N = variants{} ; --
lin positively_Adv = variants{} ; --
lin insufficient_A = variants{} ; --
lin substitute_V2 = variants{} ; --
lin substitute_V = variants{} ; --
lin mysterious_A = variants{} ; --
lin dancer_N = variants{} ; --
lin trail_N = variants{} ; --
lin caution_N = variants{} ; --
lin donation_N = variants{} ; --
lin added_A = variants{} ; --
lin weaken_V2 = variants{} ; --
lin weaken_V = variants{} ; --
lin tyre_N = variants{} ; --
lin sufferer_N = variants{} ; --
lin managerial_A = variants{} ; --
lin elaborate_A = variants{} ; --
lin restraint_N = variants{} ; --
lin renew_V2 = variants{} ; --
lin dilemma_N = variants{} ; --
lin configuration_N = variants{} ; --
lin rear_A = variants{} ; --
lin embark_V2 = variants{} ; --
lin embark_V = variants{} ; --
lin misery_N = variants{} ; --
lin importantly_Adv = variants{} ; --
lin continually_Adv = variants{} ; --
lin appreciation_N = variants{} ; --
lin radical_N = variants{} ; --
lin diverse_A = variants{} ; --
lin revive_V2 = variants{} ; --
lin revive_V = variants{} ; --
lin trip_V = variants{} ; --
lin lounge_N = variants{} ; --
lin dwelling_N = variants{} ; --
lin parental_A = variants{} ; --
lin loyal_A = variants{} ; --
lin privatisation_N = variants{} ; --
lin outsider_N = variants{} ; --
lin forbid_V2 = variants{} ; --
lin yep_Interj = variants{} ; --
lin prospective_A = variants{} ; --
lin manuscript_N = variants{} ; --
lin inherent_A = variants{} ; --
lin deem_V2V = variants{} ; --
lin deem_V2A = variants{} ; --
lin deem_V2 = variants{} ; --
lin telecommunication_N = variants{} ; --
lin intermediate_A = variants{} ; --
lin worthwhile_A = variants{} ; --
lin calendar_N = variants{} ; --
lin basin_N = variants{} ; --
lin utterly_Adv = variants{} ; --
lin rebuild_V2 = variants{} ; --
lin pulse_N = variants{} ; --
lin suppress_V2 = variants{} ; --
lin predator_N = variants{} ; --
lin width_N = variants{} ; --
lin stiff_A = variants{} ; --
lin spine_N = variants{} ; --
lin betray_V2 = variants{} ; --
lin punish_V2 = variants{} ; --
lin stall_N = variants{} ; --
lin lifestyle_N = variants{} ; --
lin compile_V2 = variants{} ; --
lin arouse_V2V = variants{} ; --
lin arouse_V2 = variants{} ; --
lin partially_Adv = variants{} ; --
lin headline_N = variants{} ; --
lin divine_A = variants{} ; --
lin unpleasant_A = variants{} ; --
lin sacred_A = variants{} ; --
lin useless_A = variants{} ; --
lin cool_V2 = variants{} ; --
lin cool_V = variants{} ; --
lin tremble_V = variants{} ; --
lin statue_N = variants{} ; --
lin obey_V2 = variants{} ; --
lin obey_V = variants{} ; --
lin drunk_A = variants{} ; --
lin tender_A = variants{} ; --
lin molecular_A = variants{} ; --
lin circulate_V2 = variants{} ; --
lin circulate_V = variants{} ; --
lin exploitation_N = variants{} ; --
lin explicitly_Adv = variants{} ; --
lin utterance_N = variants{} ; --
lin linear_A = variants{} ; --
lin chat_V = variants{} ; --
lin revision_N = variants{} ; --
lin distress_N = variants{} ; --
lin spill_V2 = variants{} ; --
lin spill_V = variants{} ; --
lin steward_N = variants{} ; --
lin knight_N = variants{} ; --
lin sum_V2 = variants{} ; --
lin sum_V = variants{} ; --
lin semantic_A = variants{} ; --
lin selective_A = variants{} ; --
lin learner_N = variants{} ; --
lin dignity_N = variants{} ; --
lin senate_N = variants{} ; --
lin grid_N = variants{} ; --
lin fiscal_A = variants{} ; --
lin activate_V2 = variants{} ; --
lin rival_A = variants{} ; --
lin fortunate_A = variants{} ; --
lin jeans_N = variants{} ; --
lin select_A = variants{} ; --
lin fitting_N = variants{} ; --
lin commentator_N = variants{} ; --
lin weep_V2 = variants{} ; --
lin weep_V = variants{} ; --
lin handicap_N = variants{} ; --
lin crush_V2 = variants{} ; --
lin crush_V = variants{} ; --
lin towel_N = variants{} ; --
lin stay_N = variants{} ; --
lin skilled_A = variants{} ; --
lin repeatedly_Adv = variants{} ; --
lin defensive_A = variants{} ; --
lin calm_V2 = variants{} ; --
lin calm_V = variants{} ; --
lin temporarily_Adv = variants{} ; --
lin rain_V2 = variants{} ; --
lin rain_V = variants{} ; --
lin pin_N = variants{} ; --
lin villa_N = variants{} ; --
lin rod_N = variants{} ; --
lin frontier_N = variants{} ; --
lin enforcement_N = variants{} ; --
lin protective_A = variants{} ; --
lin philosophical_A = variants{} ; --
lin lordship_N = variants{} ; --
lin disagree_VS = variants{} ; --
lin disagree_V2 = variants{} ; --
lin disagree_V = variants{} ; --
lin boyfriend_N = variants{} ; --
lin viewer_N = variants{} ; --
lin slim_A = variants{} ; --
lin textile_N = variants{} ; --
lin mist_N = variants{} ; --
lin harmony_N = variants{} ; --
lin deed_N = variants{} ; --
lin merge_V2 = variants{} ; --
lin merge_V = variants{} ; --
lin invention_N = variants{} ; --
lin commissioner_N = variants{} ; --
lin caravan_N = variants{} ; --
lin bolt_N = variants{} ; --
lin ending_N = variants{} ; --
lin publishing_N = variants{} ; --
lin gut_N = variants{} ; --
lin stamp_V2 = variants{} ; --
lin stamp_V = variants{} ; --
lin map_V2 = variants{} ; --
lin loud_Adv = variants{} ; --
lin stroke_V2 = variants{} ; --
lin shock_V2 = variants{} ; --
lin rug_N = variants{} ; --
lin picture_V2 = variants{} ; --
lin slip_N = variants{} ; --
lin praise_N = variants{} ; --
lin fine_N = variants{} ; --
lin monument_N = variants{} ; --
lin material_A = variants{} ; --
lin garment_N = variants{} ; --
lin toward_Prep = variants{} ; --
lin realm_N = variants{} ; --
lin melt_V2 = variants{} ; --
lin melt_V = variants{} ; --
lin reproduction_N = variants{} ; --
lin reactor_N = variants{} ; --
lin furious_A = variants{} ; --
lin distinguished_A = variants{} ; --
lin characterize_V2 = variants{} ; --
lin alike_Adv = variants{} ; --
lin pump_N = variants{} ; --
lin probe_N = variants{} ; --
lin feedback_N = variants{} ; --
lin aspiration_N = variants{} ; --
lin suspect_N = variants{} ; --
lin solar_A = variants{} ; --
lin fare_N = variants{} ; --
lin carve_V2 = variants{} ; --
lin carve_V = variants{} ; --
lin qualified_A = variants{} ; --
lin membrane_N = variants{} ; --
lin dependence_N = variants{} ; --
lin convict_V2 = variants{} ; --
lin bacteria_N = variants{} ; --
lin trading_N = variants{} ; --
lin ambassador_N = variants{} ; --
lin wound_V2 = variants{} ; --
lin drug_V2 = variants{} ; --
lin conjunction_N = variants{} ; --
lin cabin_N = variants{} ; --
lin trail_V2 = variants{} ; --
lin trail_V = variants{} ; --
lin shaft_N = variants{} ; --
lin treasure_N = variants{} ; --
lin inappropriate_A = variants{} ; --
lin half_Adv = variants{} ; --
lin attribute_N = variants{} ; --
lin liquid_A = variants{} ; --
lin embassy_N = variants{} ; --
lin terribly_Adv = variants{} ; --
lin exemption_N = variants{} ; --
lin array_N = variants{} ; --
lin tablet_N = variants{} ; --
lin sack_V2 = variants{} ; --
lin erosion_N = variants{} ; --
lin bull_N = variants{} ; --
lin warehouse_N = variants{} ; --
lin unfortunate_A = variants{} ; --
lin promoter_N = variants{} ; --
lin compel_VV = variants{} ; --
lin compel_V2V = variants{} ; --
lin compel_V2 = variants{} ; --
lin motivate_V2V = variants{} ; --
lin motivate_V2 = variants{} ; --
lin burning_A = variants{} ; --
lin vitamin_N = variants{} ; --
lin sail_N = variants{} ; --
lin lemon_N = variants{} ; --
lin foreigner_N = variants{} ; --
lin powder_N = variants{} ; --
lin persistent_A = variants{} ; --
lin bat_N = variants{} ; --
lin ancestor_N = variants{} ; --
lin predominantly_Adv = variants{} ; --
lin mathematical_A = variants{} ; --
lin compliance_N = variants{} ; --
lin arch_N = variants{} ; --
lin woodland_N = variants{} ; --
lin serum_N = variants{} ; --
lin overnight_Adv = variants{} ; --
lin doubtful_A = variants{} ; --
lin doing_N = variants{} ; --
lin coach_V2 = variants{} ; --
lin coach_V = variants{} ; --
lin binding_A = variants{} ; --
lin surrounding_A = variants{} ; --
lin peer_N = variants{} ; --
lin ozone_N = variants{} ; --
lin mid_A = variants{} ; --
lin invisible_A = variants{} ; --
lin depart_V = variants{} ; --
lin brigade_N = variants{} ; --
lin manipulate_V2 = variants{} ; --
lin consume_V2 = variants{} ; --
lin consume_V = variants{} ; --
lin temptation_N = variants{} ; --
lin intact_A = variants{} ; --
lin glove_N = L.glove_N ;
lin aggression_N = variants{} ; --
lin emergence_N = variants{} ; --
lin stag_V = variants{} ; --
lin coffin_N = variants{} ; --
lin beautifully_Adv = variants{} ; --
lin clutch_V2 = variants{} ; --
lin clutch_V = variants{} ; --
lin wit_N = variants{} ; --
lin underline_V2 = variants{} ; --
lin trainee_N = variants{} ; --
lin scrutiny_N = variants{} ; --
lin neatly_Adv = variants{} ; --
lin follower_N = variants{} ; --
lin sterling_A = variants{} ; --
lin tariff_N = variants{} ; --
lin bee_N = variants{} ; --
lin relaxation_N = variants{} ; --
lin negligence_N = variants{} ; --
lin sunlight_N = variants{} ; --
lin penetrate_V2 = variants{} ; --
lin penetrate_V = variants{} ; --
lin knot_N = variants{} ; --
lin temper_N = variants{} ; --
lin skull_N = variants{} ; --
lin openly_Adv = variants{} ; --
lin grind_V2 = variants{} ; --
lin grind_V = variants{} ; --
lin whale_N = variants{} ; --
lin throne_N = variants{} ; --
lin supervise_V2 = variants{} ; --
lin supervise_V = variants{} ; --
lin sickness_N = variants{} ; --
lin package_V2 = variants{} ; --
lin intake_N = variants{} ; --
lin within_Adv = variants{} ; --
lin inland_A = variants{} ; --
lin beast_N = variants{} ; --
lin rear_N = variants{} ; --
lin morality_N = variants{} ; --
lin competent_A = variants{} ; --
lin sink_N = variants{} ; --
lin uniform_A = variants{} ; --
lin reminder_N = variants{} ; --
lin permanently_Adv = variants{} ; --
lin optimistic_A = variants{} ; --
lin bargain_N = variants{} ; --
lin seemingly_Adv = variants{} ; --
lin respective_A = variants{} ; --
lin horizontal_A = variants{} ; --
lin decisive_A = variants{} ; --
lin bless_V2 = variants{} ; --
lin bile_N = variants{} ; --
lin spatial_A = variants{} ; --
lin bullet_N = variants{} ; --
lin respectable_A = variants{} ; --
lin overseas_Adv = variants{} ; --
lin convincing_A = variants{} ; --
lin unacceptable_A = variants{} ; --
lin confrontation_N = variants{} ; --
lin swiftly_Adv = variants{} ; --
lin paid_A = variants{} ; --
lin joke_V = variants{} ; --
lin instant_A = variants{} ; --
lin illusion_N = variants{} ; --
lin cheer_V2 = variants{} ; --
lin cheer_V = variants{} ; --
lin congregation_N = variants{} ; --
lin worldwide_Adv = variants{} ; --
lin winning_A = variants{} ; --
lin wake_N = variants{} ; --
lin toss_V2 = variants{} ; --
lin toss_V = variants{} ; --
lin medium_A = variants{} ; --
lin jewellery_N = variants{} ; --
lin fond_A = variants{} ; --
lin alarm_V2 = variants{} ; --
lin guerrilla_N = variants{} ; --
lin dive_V = variants{} ; --
lin desire_V2 = variants{} ; --
lin cooperation_N = variants{} ; --
lin thread_N = variants{} ; --
lin prescribe_V2 = variants{} ; --
lin prescribe_V = variants{} ; --
lin calcium_N = variants{} ; --
lin redundant_A = variants{} ; --
lin marker_N = variants{} ; --
lin mammal_N = variants{} ; --
lin legacy_N = variants{} ; --
lin debtor_N = variants{} ; --
lin testament_N = variants{} ; --
lin tragic_A = variants{} ; --
lin silver_A = variants{} ; --
lin grin_N = variants{} ; --
lin spectacle_N = variants{} ; --
lin inheritance_N = variants{} ; --
lin heal_V2 = variants{} ; --
lin heal_V = variants{} ; --
lin sovereignty_N = variants{} ; --
lin enzyme_N = variants{} ; --
lin host_V2 = variants{} ; --
lin neighbouring_A = variants{} ; --
lin corn_N = variants{} ; --
lin layout_N = variants{} ; --
lin dictate_VS = variants{} ; --
lin dictate_V2 = variants{} ; --
lin dictate_V = variants{} ; --
lin rip_V2 = variants{} ; --
lin rip_V = variants{} ; --
lin regain_V2 = variants{} ; --
lin probable_A = variants{} ; --
lin inclusion_N = variants{} ; --
lin booklet_N = variants{} ; --
lin bar_V2 = variants{} ; --
lin privately_Adv = variants{} ; --
lin laser_N = variants{} ; --
lin fame_N = variants{} ; --
lin bronze_N = variants{} ; --
lin mobile_A = variants{} ; --
lin metaphor_N = variants{} ; --
lin complication_N = variants{} ; --
lin narrow_V2 = variants{} ; --
lin narrow_V = variants{} ; --
lin old_fashioned_A = variants{} ; --
lin chop_V2 = variants{} ; --
lin chop_V = variants{} ; --
lin synthesis_N = variants{} ; --
lin diameter_N = variants{} ; --
lin bomb_V2 = variants{} ; --
lin bomb_V = variants{} ; --
lin silently_Adv = variants{} ; --
lin shed_N = variants{} ; --
lin fusion_N = variants{} ; --
lin trigger_V2 = variants{} ; --
lin printing_N = variants{} ; --
lin onion_N = variants{} ; --
lin dislike_V2 = variants{} ; --
lin embody_V2 = variants{} ; --
lin curl_V = variants{} ; --
lin sunshine_N = variants{} ; --
lin sponsorship_N = variants{} ; --
lin rage_N = variants{} ; --
lin loop_N = variants{} ; --
lin halt_N = variants{} ; --
lin cop_V2 = variants{} ; --
lin bang_V2 = variants{} ; --
lin bang_V = variants{} ; --
lin toxic_A = variants{} ; --
lin thinking_A = variants{} ; --
lin orientation_N = variants{} ; --
lin likelihood_N = variants{} ; --
lin wee_A = variants{} ; --
lin up_to_date_A = variants{} ; --
lin polite_A = variants{} ; --
lin apology_N = variants{} ; --
lin exile_N = variants{} ; --
lin brow_N = variants{} ; --
lin miserable_A = variants{} ; --
lin outbreak_N = variants{} ; --
lin comparatively_Adv = variants{} ; --
lin pump_V2 = variants{} ; --
lin pump_V = variants{} ; --
lin fuck_V2 = variants{} ; --
lin fuck_V = variants{} ; --
lin forecast_VS = variants{} ; --
lin forecast_V2 = variants{} ; --
lin forecast_V = variants{} ; --
lin timing_N = variants{} ; --
lin headmaster_N = variants{} ; --
lin terrify_V2 = variants{} ; --
lin sigh_N = variants{} ; --
lin premier_A = variants{} ; --
lin joint_N = variants{} ; --
lin incredible_A = variants{} ; --
lin gravity_N = variants{} ; --
lin regulatory_A = variants{} ; --
lin cylinder_N = variants{} ; --
lin curiosity_N = variants{} ; --
lin resident_A = variants{} ; --
lin narrative_N = variants{} ; --
lin cognitive_A = variants{} ; --
lin lengthy_A = variants{} ; --
lin gothic_A = variants{} ; --
lin dip_V2 = variants{} ; --
lin dip_V = variants{} ; --
lin adverse_A = variants{} ; --
lin accountability_N = variants{} ; --
lin hydrogen_N = variants{} ; --
lin gravel_N = variants{} ; --
lin willingness_N = variants{} ; --
lin inhibit_V2 = variants{} ; --
lin attain_V2 = variants{} ; --
lin attain_V = variants{} ; --
lin specialize_V2 = variants{} ; --
lin specialize_V = variants{} ; --
lin steer_V2 = variants{} ; --
lin steer_V = variants{} ; --
lin selected_A = variants{} ; --
lin like_N = variants{} ; --
lin confer_V = variants{} ; --
lin usage_N = variants{} ; --
lin portray_V2 = variants{} ; --
lin planner_N = variants{} ; --
lin manual_A = variants{} ; --
lin boast_VS = variants{} ; --
lin boast_V2 = variants{} ; --
lin boast_V = variants{} ; --
lin unconscious_A = variants{} ; --
lin jail_N = variants{} ; --
lin fertility_N = variants{} ; --
lin documentation_N = variants{} ; --
lin wolf_N = variants{} ; --
lin patent_N = variants{} ; --
lin exit_N = variants{} ; --
lin corps_N = variants{} ; --
lin proclaim_VS = variants{} ; --
lin proclaim_V2 = variants{} ; --
lin multiply_V2 = variants{} ; --
lin multiply_V = variants{} ; --
lin brochure_N = variants{} ; --
lin screen_V2 = variants{} ; --
lin screen_V = variants{} ; --
lin orthodox_A = variants{} ; --
lin locomotive_N = variants{} ; --
lin considering_Prep = variants{} ; --
lin unaware_A = variants{} ; --
lin syndrome_N = variants{} ; --
lin reform_V2 = variants{} ; --
lin reform_V = variants{} ; --
lin confirmation_N = variants{} ; --
lin printed_A = variants{} ; --
lin curve_V2 = variants{} ; --
lin curve_V = variants{} ; --
lin costly_A = variants{} ; --
lin underground_A = variants{} ; --
lin territorial_A = variants{} ; --
lin designate_VS = variants{} ; --
lin designate_V2V = variants{} ; --
lin designate_V2 = variants{} ; --
lin designate_V = variants{} ; --
lin comfort_V2 = variants{} ; --
lin plot_V2 = variants{} ; --
lin plot_V = variants{} ; --
lin misleading_A = variants{} ; --
lin weave_V2 = variants{} ; --
lin weave_V = variants{} ; --
lin scratch_V2 = L.scratch_V2 ;
lin scratch_V = variants{}; -- L.scratch_V2 ;
lin echo_N = variants{} ; --
lin ideally_Adv = variants{} ; --
lin endure_V2 = variants{} ; --
lin endure_V = variants{} ; --
lin verbal_A = variants{} ; --
lin stride_V = variants{} ; --
lin nursing_N = variants{} ; --
lin exert_V2 = variants{} ; --
lin compatible_A = variants{} ; --
lin causal_A = variants{} ; --
lin mosaic_N = variants{} ; --
lin manor_N = variants{} ; --
lin implicit_A = variants{} ; --
lin following_Prep = variants{} ; --
lin fashionable_A = variants{} ; --
lin valve_N = variants{} ; --
lin proceed_N = variants{} ; --
lin sofa_N = variants{} ; --
lin snatch_V2 = variants{} ; --
lin snatch_V = variants{} ; --
lin jazz_N = variants{} ; --
lin patron_N = variants{} ; --
lin provider_N = variants{} ; --
lin interim_A = variants{} ; --
lin intent_N = variants{} ; --
lin chosen_A = variants{} ; --
lin applied_A = variants{} ; --
lin shiver_V = variants{} ; --
lin pie_N = variants{} ; --
lin fury_N = variants{} ; --
lin abolition_N = variants{} ; --
lin soccer_N = variants{} ; --
lin corpse_N = variants{} ; --
lin accusation_N = variants{} ; --
lin kind_A = variants{} ; --
lin dead_Adv = variants{} ; --
lin nursing_A = variants{} ; --
lin contempt_N = variants{} ; --
lin prevail_V = variants{} ; --
lin murderer_N = variants{} ; --
lin liberal_N = variants{} ; --
lin gathering_N = variants{} ; --
lin adequately_Adv = variants{} ; --
lin subjective_A = variants{} ; --
lin disagreement_N = variants{} ; --
lin cleaner_N = variants{} ; --
lin boil_V2 = variants{} ; --
lin boil_V = variants{} ; --
lin static_A = variants{} ; --
lin scent_N = variants{} ; --
lin civilian_N = variants{} ; --
lin monk_N = variants{} ; --
lin abruptly_Adv = variants{} ; --
lin keyboard_N = variants{} ; --
lin hammer_N = variants{} ; --
lin despair_N = variants{} ; --
lin controller_N = variants{} ; --
lin yell_V2 = variants{} ; --
lin yell_V = variants{} ; --
lin entail_V2 = variants{} ; --
lin cheerful_A = variants{} ; --
lin reconstruction_N = variants{} ; --
lin patience_N = variants{} ; --
lin legally_Adv = variants{} ; --
lin habitat_N = variants{} ; --
lin queue_N = variants{} ; --
lin given_A = variants{} ; --
lin purple_A = variants{} ; --
lin outlook_N = variants{} ; --
lin genius_N = variants{} ; --
lin dual_A = variants{} ; --
lin canvas_N = variants{} ; --
lin grave_A = variants{} ; --
lin pepper_N = variants{} ; --
lin conform_V2 = variants{} ; --
lin conform_V = variants{} ; --
lin cautious_A = variants{} ; --
lin dot_N = variants{} ; --
lin conspiracy_N = variants{} ; --
lin butterfly_N = variants{} ; --
lin sponsor_N = variants{} ; --
lin sincerely_Adv = variants{} ; --
lin rating_N = variants{} ; --
lin weird_A = variants{} ; --
lin teenage_A = variants{} ; --
lin salmon_N = variants{} ; --
lin recorder_N = variants{} ; --
lin postpone_V2 = variants{} ; --
lin maid_N = variants{} ; --
lin furnish_V2 = variants{} ; --
lin ethical_A = variants{} ; --
lin bicycle_N = variants{} ; --
lin sick_N = variants{} ; --
lin sack_N = variants{} ; --
lin renaissance_N = variants{} ; --
lin luxury_N = variants{} ; --
lin gasp_V2 = variants{} ; --
lin gasp_V = variants{} ; --
lin wardrobe_N = variants{} ; --
lin native_N = variants{} ; --
lin fringe_N = variants{} ; --
lin adaptation_N = variants{} ; --
lin quotation_N = variants{} ; --
lin hunger_N = variants{} ; --
lin enclose_V2 = variants{} ; --
lin disastrous_A = variants{} ; --
lin choir_N = variants{} ; --
lin overwhelming_A = variants{} ; --
lin glimpse_N = variants{} ; --
lin divorce_V2 = variants{} ; --
lin circular_A = variants{} ; --
lin locality_N = variants{} ; --
lin ferry_N = variants{} ; --
lin balcony_N = variants{} ; --
lin sailor_N = variants{} ; --
lin precision_N = variants{} ; --
lin desert_V2 = variants{} ; --
lin desert_V = variants{} ; --
lin dancing_N = variants{} ; --
lin alert_V2 = variants{} ; --
lin surrender_V2 = variants{} ; --
lin surrender_V = variants{} ; --
lin archive_N = variants{} ; --
lin jump_N = variants{} ; --
lin philosopher_N = variants{} ; --
lin revival_N = variants{} ; --
lin presume_VS = variants{} ; --
lin presume_V2 = variants{} ; --
lin presume_V = variants{} ; --
lin node_N = variants{} ; --
lin fantastic_A = variants{} ; --
lin herb_N = variants{} ; --
lin assertion_N = variants{} ; --
lin thorough_A = variants{} ; --
lin quit_V2 = variants{} ; --
lin quit_V = variants{} ; --
lin grim_A = variants{} ; --
lin fair_N = variants{} ; --
lin broadcast_V2 = variants{} ; --
lin broadcast_V = variants{} ; --
lin annoy_V2 = variants{} ; --
lin divert_V = variants{} ; --
lin accelerate_V2 = variants{} ; --
lin accelerate_V = variants{} ; --
lin polymer_N = variants{} ; --
lin sweat_N = variants{} ; --
lin survivor_N = variants{} ; --
lin subscription_N = variants{} ; --
lin repayment_N = variants{} ; --
lin anonymous_A = variants{} ; --
lin summarize_V2 = variants{} ; --
lin punch_N = variants{} ; --
lin lodge_V2 = variants{} ; --
lin lodge_V = variants{} ; --
lin landowner_N = variants{} ; --
lin ignorance_N = variants{} ; --
lin discourage_V2 = variants{} ; --
lin bride_N = variants{} ; --
lin likewise_Adv = variants{} ; --
lin depressed_A = variants{} ; --
lin abbey_N = variants{} ; --
lin quarry_N = variants{} ; --
lin archbishop_N = variants{} ; --
lin sock_N = L.sock_N ;
lin large_scale_A = variants{} ; --
lin glare_V2 = variants{} ; --
lin glare_V = variants{} ; --
lin descent_N = variants{} ; --
lin stumble_V = variants{} ; --
lin mistress_N = variants{} ; --
lin empty_V2 = variants{} ; --
lin empty_V = variants{} ; --
lin prosperity_N = variants{} ; --
lin harm_V2 = variants{} ; --
lin formulation_N = variants{} ; --
lin atomic_A = variants{} ; --
lin agreed_A = variants{} ; --
lin wicked_A = variants{} ; --
lin threshold_N = variants{} ; --
lin lobby_N = variants{} ; --
lin repay_V2 = variants{} ; --
lin repay_V = variants{} ; --
lin varying_A = variants{} ; --
lin track_V2 = variants{} ; --
lin track_V = variants{} ; --
lin crawl_V = variants{} ; --
lin tolerate_V2 = variants{} ; --
lin salvation_N = variants{} ; --
lin pudding_N = variants{} ; --
lin counter_VS = variants{} ; --
lin counter_V = variants{} ; --
lin propaganda_N = variants{} ; --
lin cage_N = variants{} ; --
lin broker_N = variants{} ; --
lin ashamed_A = variants{} ; --
lin scan_V2 = variants{} ; --
lin scan_V = variants{} ; --
lin document_V2 = variants{} ; --
lin apparatus_N = variants{} ; --
lin theology_N = variants{} ; --
lin analogy_N = variants{} ; --
lin efficiently_Adv = variants{} ; --
lin bitterly_Adv = variants{} ; --
lin performer_N = variants{} ; --
lin individually_Adv = variants{} ; --
lin amid_Prep = variants{} ; --
lin squadron_N = variants{} ; --
lin sentiment_N = variants{} ; --
lin making_N = variants{} ; --
lin exotic_A = variants{} ; --
lin dominance_N = variants{} ; --
lin coherent_A = variants{} ; --
lin placement_N = variants{} ; --
lin flick_V2 = variants{} ; --
lin colourful_A = variants{} ; --
lin mercy_N = variants{} ; --
lin angrily_Adv = variants{} ; --
lin amuse_V2 = variants{} ; --
lin mainstream_N = variants{} ; --
lin appraisal_N = variants{} ; --
lin annually_Adv = variants{} ; --
lin torch_N = variants{} ; --
lin intimate_A = variants{} ; --
lin gold_A = variants{} ; --
lin arbitrary_A = variants{} ; --
lin venture_VS = variants{} ; --
lin venture_V2 = variants{} ; --
lin venture_V = variants{} ; --
lin preservation_N = variants{} ; --
lin shy_A = variants{} ; --
lin disclosure_N = variants{} ; --
lin lace_N = variants{} ; --
lin inability_N = variants{} ; --
lin motif_N = variants{} ; --
lin hunt_N = variants{} ; --
lin delicious_A = variants{} ; --
lin term_VS = variants{} ; --
lin term_V2 = variants{} ; --
lin substitute_N = variants{} ; --
lin highway_N = variants{} ; --
lin haul_V2 = variants{} ; --
lin haul_V = variants{} ; --
lin dragon_N = variants{} ; --
lin chair_V2 = variants{} ; --
lin accumulate_V2 = variants{} ; --
lin accumulate_V = variants{} ; --
lin unchanged_A = variants{} ; --
lin sediment_N = variants{} ; --
lin sample_V2 = variants{} ; --
lin exclaim_V2 = variants{} ; --
lin fan_V2 = variants{} ; --
lin fan_V = variants{} ; --
lin volunteer_V2 = variants{} ; --
lin volunteer_V = variants{} ; --
lin root_V2 = variants{} ; --
lin root_V = variants{} ; --
lin parcel_N = variants{} ; --
lin psychiatric_A = variants{} ; --
lin delightful_A = variants{} ; --
lin confidential_A = variants{} ; --
lin calorie_N = variants{} ; --
lin flash_N = variants{} ; --
lin crowd_V2 = variants{} ; --
lin crowd_V = variants{} ; --
lin aggregate_A = variants{} ; --
lin scholarship_N = variants{} ; --
lin monitor_N = variants{} ; --
lin disciplinary_A = variants{} ; --
lin rock_V2 = variants{} ; --
lin rock_V = variants{} ; --
lin hatred_N = variants{} ; --
lin pill_N = variants{} ; --
lin noisy_A = variants{} ; --
lin feather_N = L.feather_N ;
lin lexical_A = variants{} ; --
lin staircase_N = variants{} ; --
lin autonomous_A = variants{} ; --
lin viewpoint_N = variants{} ; --
lin projection_N = variants{} ; --
lin offensive_A = variants{} ; --
lin controlled_A = variants{} ; --
lin flush_V2 = variants{} ; --
lin flush_V = variants{} ; --
lin racism_N = variants{} ; --
lin flourish_V = variants{} ; --
lin resentment_N = variants{} ; --
lin pillow_N = variants{} ; --
lin courtesy_N = variants{} ; --
lin photography_N = variants{} ; --
lin monkey_N = variants{} ; --
lin glorious_A = variants{} ; --
lin evolutionary_A = variants{} ; --
lin gradual_A = variants{} ; --
lin bankruptcy_N = variants{} ; --
lin sacrifice_N = variants{} ; --
lin uphold_V2 = variants{} ; --
lin sketch_N = variants{} ; --
lin presidency_N = variants{} ; --
lin formidable_A = variants{} ; --
lin differentiate_V2 = variants{} ; --
lin differentiate_V = variants{} ; --
lin continuing_A = variants{} ; --
lin cart_N = variants{} ; --
lin stadium_N = variants{} ; --
lin dense_A = variants{} ; --
lin catch_N = variants{} ; --
lin beyond_Adv = variants{} ; --
lin immigration_N = variants{} ; --
lin clarity_N = variants{} ; --
lin worm_N = L.worm_N ;
lin slot_N = variants{} ; --
lin rifle_N = variants{} ; --
lin screw_V2 = variants{} ; --
lin screw_V = variants{} ; --
lin harvest_N = variants{} ; --
lin foster_V2 = variants{} ; --
lin academic_N = variants{} ; --
lin impulse_N = variants{} ; --
lin guardian_N = variants{} ; --
lin ambiguity_N = variants{} ; --
lin triangle_N = variants{} ; --
lin terminate_V2 = variants{} ; --
lin terminate_V = variants{} ; --
lin retreat_V = variants{} ; --
lin pony_N = variants{} ; --
lin outdoor_A = variants{} ; --
lin deficiency_N = variants{} ; --
lin decree_N = variants{} ; --
lin apologize_V = variants{} ; --
lin yarn_N = variants{} ; --
lin staff_V2 = variants{} ; --
lin renewal_N = variants{} ; --
lin rebellion_N = variants{} ; --
lin incidentally_Adv = variants{} ; --
lin flour_N = variants{} ; --
lin developed_A = variants{} ; --
lin chorus_N = variants{} ; --
lin ballot_N = variants{} ; --
lin appetite_N = variants{} ; --
lin stain_V2 = variants{} ; --
lin stain_V = variants{} ; --
lin notebook_N = variants{} ; --
lin loudly_Adv = variants{} ; --
lin homeless_A = variants{} ; --
lin census_N = variants{} ; --
lin bizarre_A = variants{} ; --
lin striking_A = variants{} ; --
lin greenhouse_N = variants{} ; --
lin part_V2 = variants{} ; --
lin part_V = variants{} ; --
lin burial_N = variants{} ; --
lin embarrassed_A = variants{} ; --
lin ash_N = variants{} ; --
lin actress_N = variants{} ; --
lin cassette_N = variants{} ; --
lin privacy_N = variants{} ; --
lin fridge_N = L.fridge_N ;
lin feed_N = variants{} ; --
lin excess_A = variants{} ; --
lin calf_N = variants{} ; --
lin associate_N = variants{} ; --
lin ruin_N = variants{} ; --
lin jointly_Adv = variants{} ; --
lin drill_V2 = variants{} ; --
lin drill_V = variants{} ; --
lin photograph_V2 = variants{} ; --
lin devoted_A = variants{} ; --
lin indirectly_Adv = variants{} ; --
lin driving_A = variants{} ; --
lin memorandum_N = variants{} ; --
lin default_N = variants{} ; --
lin costume_N = variants{} ; --
lin variant_N = variants{} ; --
lin shatter_V2 = variants{} ; --
lin shatter_V = variants{} ; --
lin methodology_N = variants{} ; --
lin frame_V2 = variants{} ; --
lin frame_V = variants{} ; --
lin allegedly_Adv = variants{} ; --
lin swell_V2 = variants{}; -- L.swell_V ;
lin swell_V = L.swell_V ;
lin investigator_N = variants{} ; --
lin imaginative_A = variants{} ; --
lin bored_A = variants{} ; --
lin bin_N = variants{} ; --
lin awake_A = variants{} ; --
lin recycle_V2 = variants{} ; --
lin group_V2 = variants{} ; --
lin group_V = variants{} ; --
lin enjoyment_N = variants{} ; --
lin contemporary_N = variants{} ; --
lin texture_N = variants{} ; --
lin donor_N = variants{} ; --
lin bacon_N = variants{} ; --
lin sunny_A = variants{} ; --
lin stool_N = variants{} ; --
lin prosecute_V2 = variants{} ; --
lin commentary_N = variants{} ; --
lin bass_N = variants{} ; --
lin sniff_V2 = variants{} ; --
lin sniff_V = variants{} ; --
lin repetition_N = variants{} ; --
lin eventual_A = variants{} ; --
lin credit_V2 = variants{} ; --
lin suburb_N = variants{} ; --
lin newcomer_N = variants{} ; --
lin romance_N = variants{} ; --
lin film_V2 = variants{} ; --
lin film_V = variants{} ; --
lin experiment_V2 = variants{} ; --
lin experiment_V = variants{} ; --
lin daylight_N = variants{} ; --
lin warrant_N = variants{} ; --
lin fur_N = variants{} ; --
lin parking_N = variants{} ; --
lin nuisance_N = variants{} ; --
lin civilian_A = variants{} ; --
lin foolish_A = variants{} ; --
lin bulb_N = variants{} ; --
lin balloon_N = variants{} ; --
lin vivid_A = variants{} ; --
lin surveyor_N = variants{} ; --
lin spontaneous_A = variants{} ; --
lin biology_N = variants{} ; --
lin injunction_N = variants{} ; --
lin appalling_A = variants{} ; --
lin amusement_N = variants{} ; --
lin aesthetic_A = variants{} ; --
lin vegetation_N = variants{} ; --
lin stab_V2 = L.stab_V2 ;
lin stab_V = variants{}; -- L.stab_V2 ;
lin rude_A = variants{} ; --
lin offset_V2 = variants{} ; --
lin thinking_N = variants{} ; --
lin mainframe_N = variants{} ; --
lin flock_N = variants{} ; --
lin amateur_A = variants{} ; --
lin academy_N = variants{} ; --
lin shilling_N = variants{} ; --
lin reluctance_N = variants{} ; --
lin velocity_N = variants{} ; --
lin spare_V2 = variants{} ; --
lin spare_V = variants{} ; --
lin wartime_N = variants{} ; --
lin soak_V2 = variants{} ; --
lin soak_V = variants{} ; --
lin rib_N = variants{} ; --
lin mighty_A = variants{} ; --
lin shocked_A = variants{} ; --
lin vocational_A = variants{} ; --
lin spit_V2 = variants{}; -- L.spit_V ;
lin spit_V = L.spit_V ;
lin gall_N = variants{} ; --
lin bowl_V2 = variants{} ; --
lin bowl_V = variants{} ; --
lin prescription_N = variants{} ; --
lin fever_N = variants{} ; --
lin axis_N = variants{} ; --
lin reservoir_N = variants{} ; --
lin magnitude_N = variants{} ; --
lin rape_V2 = variants{} ; --
lin cutting_N = variants{} ; --
lin bracket_N = variants{} ; --
lin agony_N = variants{} ; --
lin strive_VV = variants{} ; --
lin strive_V = variants{} ; --
lin strangely_Adv = variants{} ; --
lin pledge_VS = variants{} ; --
lin pledge_V2V = variants{} ; --
lin pledge_V2 = variants{} ; --
lin recipient_N = variants{} ; --
lin moor_N = variants{} ; --
lin invade_V2 = variants{} ; --
lin dairy_N = variants{} ; --
lin chord_N = variants{} ; --
lin shrink_V2 = variants{} ; --
lin shrink_V = variants{} ; --
lin poison_N = variants{} ; --
lin pillar_N = variants{} ; --
lin washing_N = variants{} ; --
lin warrior_N = variants{} ; --
lin supervisor_N = variants{} ; --
lin outfit_N = variants{} ; --
lin innovative_A = variants{} ; --
lin dressing_N = variants{} ; --
lin dispute_V2 = variants{} ; --
lin dispute_V = variants{} ; --
lin jungle_N = variants{} ; --
lin brewery_N = variants{} ; --
lin adjective_N = variants{} ; --
lin straighten_V2 = variants{} ; --
lin straighten_V = variants{} ; --
lin restrain_V2 = variants{} ; --
lin monarchy_N = variants{} ; --
lin trunk_N = variants{} ; --
lin herd_N = variants{} ; --
lin deadline_N = variants{} ; --
lin tiger_N = variants{} ; --
lin supporting_A = variants{} ; --
lin moderate_A = variants{} ; --
lin kneel_V = variants{} ; --
lin ego_N = variants{} ; --
lin sexually_Adv = variants{} ; --
lin ministerial_A = variants{} ; --
lin bitch_N = variants{} ; --
lin wheat_N = variants{} ; --
lin stagger_V = variants{} ; --
lin snake_N = L.snake_N ;
lin ribbon_N = variants{} ; --
lin mainland_N = variants{} ; --
lin fisherman_N = variants{} ; --
lin economically_Adv = variants{} ; --
lin unwilling_A = variants{} ; --
lin nationalism_N = variants{} ; --
lin knitting_N = variants{} ; --
lin irony_N = variants{} ; --
lin handling_N = variants{} ; --
lin desired_A = variants{} ; --
lin bomber_N = variants{} ; --
lin voltage_N = variants{} ; --
lin unusually_Adv = variants{} ; --
lin toast_N = variants{} ; --
lin feel_N = variants{} ; --
lin suffering_N = variants{} ; --
lin polish_V2 = variants{} ; --
lin polish_V = variants{} ; --
lin technically_Adv = variants{} ; --
lin meaningful_A = variants{} ; --
lin aloud_Adv = variants{} ; --
lin waiter_N = variants{} ; --
lin tease_V2 = variants{} ; --
lin opposite_Adv = variants{} ; --
lin goat_N = variants{} ; --
lin conceptual_A = variants{} ; --
lin ant_N = variants{} ; --
lin inflict_V2 = variants{} ; --
lin bowler_N = variants{} ; --
lin roar_V2 = variants{} ; --
lin roar_V = variants{} ; --
lin drain_N = variants{} ; --
lin wrong_N = variants{} ; --
lin galaxy_N = variants{} ; --
lin aluminium_N = variants{} ; --
lin receptor_N = variants{} ; --
lin preach_V2 = variants{} ; --
lin preach_V = variants{} ; --
lin parade_N = variants{} ; --
lin opposite_N = variants{} ; --
lin critique_N = variants{} ; --
lin query_N = variants{} ; --
lin outset_N = variants{} ; --
lin integral_A = variants{} ; --
lin grammatical_A = variants{} ; --
lin testing_N = variants{} ; --
lin patrol_N = variants{} ; --
lin pad_N = variants{} ; --
lin unreasonable_A = variants{} ; --
lin sausage_N = variants{} ; --
lin criminal_N = variants{} ; --
lin constructive_A = variants{} ; --
lin worldwide_A = variants{} ; --
lin highlight_N = variants{} ; --
lin doll_N = variants{} ; --
lin frightened_A = variants{} ; --
lin biography_N = variants{} ; --
lin vocabulary_N = variants{} ; --
lin offend_V2 = variants{} ; --
lin offend_V = variants{} ; --
lin accumulation_N = variants{} ; --
lin linen_N = variants{} ; --
lin fairy_N = variants{} ; --
lin disco_N = variants{} ; --
lin hint_VS = variants{} ; --
lin hint_V2 = variants{} ; --
lin hint_V = variants{} ; --
lin versus_Prep = variants{} ; --
lin ray_N = variants{} ; --
lin pottery_N = variants{} ; --
lin immune_A = variants{} ; --
lin retreat_N = variants{} ; --
lin master_V2 = variants{} ; --
lin injured_A = variants{} ; --
lin holly_N = variants{} ; --
lin battle_V2 = variants{} ; --
lin battle_V = variants{} ; --
lin solidarity_N = variants{} ; --
lin embarrassing_A = variants{} ; --
lin cargo_N = variants{} ; --
lin theorist_N = variants{} ; --
lin reluctantly_Adv = variants{} ; --
lin preferred_A = variants{} ; --
lin dash_V = variants{} ; --
lin total_V2 = variants{} ; --
lin total_V = variants{} ; --
lin reconcile_V2 = variants{} ; --
lin drill_N = variants{} ; --
lin credibility_N = variants{} ; --
lin copyright_N = variants{} ; --
lin beard_N = variants{} ; --
lin bang_N = variants{} ; --
lin vigorous_A = variants{} ; --
lin vaguely_Adv = variants{} ; --
lin punch_V2 = variants{} ; --
lin prevalence_N = variants{} ; --
lin uneasy_A = variants{} ; --
lin boost_N = variants{} ; --
lin scrap_N = variants{} ; --
lin ironically_Adv = variants{} ; --
lin fog_N = L.fog_N ;
lin faithful_A = variants{} ; --
lin bounce_V2 = variants{} ; --
lin bounce_V = variants{} ; --
lin batch_N = variants{} ; --
lin smooth_V2 = variants{} ; --
lin smooth_V = variants{} ; --
lin sleeping_A = variants{} ; --
lin poorly_Adv = variants{} ; --
lin accord_V = variants{} ; --
lin vice_president_N = variants{} ; --
lin duly_Adv = variants{} ; --
lin blast_N = variants{} ; --
lin square_V2 = variants{} ; --
lin square_V = variants{} ; --
lin prohibit_V2 = variants{} ; --
lin prohibit_V = variants{} ; --
lin brake_N = variants{} ; --
lin asylum_N = variants{} ; --
lin obscure_V2 = variants{} ; --
lin nun_N = variants{} ; --
lin heap_N = variants{} ; --
lin smoothly_Adv = variants{} ; --
lin rhetoric_N = variants{} ; --
lin privileged_A = variants{} ; --
lin liaison_N = variants{} ; --
lin jockey_N = variants{} ; --
lin concrete_N = variants{} ; --
lin allied_A = variants{} ; --
lin rob_V2 = variants{} ; --
lin indulge_V2 = variants{} ; --
lin indulge_V = variants{} ; --
lin except_Prep = S.except_Prep ;
lin distort_V2 = variants{} ; --
lin whatsoever_Adv = variants{} ; --
lin viable_A = variants{} ; --
lin nucleus_N = variants{} ; --
lin exaggerate_V2 = variants{} ; --
lin exaggerate_V = variants{} ; --
lin compact_N = variants{} ; --
lin nationality_N = variants{} ; --
lin direct_Adv = variants{} ; --
lin cast_N = variants{} ; --
lin altar_N = variants{} ; --
lin refuge_N = variants{} ; --
lin presently_Adv = variants{} ; --
lin mandatory_A = variants{} ; --
lin authorize_V2V = variants{} ; --
lin authorize_V2 = variants{} ; --
lin accomplish_V2 = variants{} ; --
lin startle_V2 = variants{} ; --
lin indigenous_A = variants{} ; --
lin worse_Adv = variants{} ; --
lin retailer_N = variants{} ; --
lin compound_V2 = variants{} ; --
lin compound_V = variants{} ; --
lin admiration_N = variants{} ; --
lin absurd_A = variants{} ; --
lin coincidence_N = variants{} ; --
lin principally_Adv = variants{} ; --
lin passport_N = variants{} ; --
lin depot_N = variants{} ; --
lin soften_V2 = variants{} ; --
lin soften_V = variants{} ; --
lin secretion_N = variants{} ; --
lin invoke_V2 = variants{} ; --
lin dirt_N = variants{} ; --
lin scared_A = variants{} ; --
lin mug_N = variants{} ; --
lin convenience_N = variants{} ; --
lin calm_N = variants{} ; --
lin optional_A = variants{} ; --
lin unsuccessful_A = variants{} ; --
lin consistency_N = variants{} ; --
lin umbrella_N = variants{} ; --
lin solo_N = variants{} ; --
lin hemisphere_N = variants{} ; --
lin extreme_N = variants{} ; --
lin brandy_N = variants{} ; --
lin belly_N = L.belly_N ;
lin attachment_N = variants{} ; --
lin wash_N = variants{} ; --
lin uncover_V2 = variants{} ; --
lin treat_N = variants{} ; --
lin repeated_A = variants{} ; --
lin pine_N = variants{} ; --
lin offspring_N = variants{} ; --
lin communism_N = variants{} ; --
lin nominate_V2 = variants{} ; --
lin soar_V2 = variants{} ; --
lin soar_V = variants{} ; --
lin geological_A = variants{} ; --
lin frog_N = variants{} ; --
lin donate_V2 = variants{} ; --
lin donate_V = variants{} ; --
lin cooperative_A = variants{} ; --
lin nicely_Adv = variants{} ; --
lin innocence_N = variants{} ; --
lin housewife_N = variants{} ; --
lin disguise_V2 = variants{} ; --
lin demolish_V2 = variants{} ; --
lin counsel_N = variants{} ; --
lin cord_N = variants{} ; --
lin semi_final_N = variants{} ; --
lin reasoning_N = variants{} ; --
lin litre_N = variants{} ; --
lin inclined_A = variants{} ; --
lin evoke_V2 = variants{} ; --
lin courtyard_N = variants{} ; --
lin arena_N = variants{} ; --
lin simplicity_N = variants{} ; --
lin inhibition_N = variants{} ; --
lin frozen_A = variants{} ; --
lin vacuum_N = variants{} ; --
lin immigrant_N = variants{} ; --
lin bet_N = variants{} ; --
lin revenge_N = variants{} ; --
lin jail_V2 = variants{} ; --
lin helmet_N = variants{} ; --
lin unclear_A = variants{} ; --
lin jerk_V2 = variants{} ; --
lin jerk_V = variants{} ; --
lin disruption_N = variants{} ; --
lin attainment_N = variants{} ; --
lin sip_V2 = variants{} ; --
lin sip_V = variants{} ; --
lin program_V2V = variants{} ; --
lin program_V2 = variants{} ; --
lin lunchtime_N = variants{} ; --
lin cult_N = variants{} ; --
lin chat_N = variants{} ; --
lin accord_N = variants{} ; --
lin supposedly_Adv = variants{} ; --
lin offering_N = variants{} ; --
lin broadcast_N = variants{} ; --
lin secular_A = variants{} ; --
lin overwhelm_V2 = variants{} ; --
lin momentum_N = variants{} ; --
lin infinite_A = variants{} ; --
lin manipulation_N = variants{} ; --
lin inquest_N = variants{} ; --
lin decrease_N = variants{} ; --
lin cellar_N = variants{} ; --
lin counsellor_N = variants{} ; --
lin avenue_N = variants{} ; --
lin rubber_A = variants{} ; --
lin labourer_N = variants{} ; --
lin lab_N = variants{} ; --
lin damn_V2 = variants{} ; --
lin comfortably_Adv = variants{} ; --
lin tense_A = variants{} ; --
lin socket_N = variants{} ; --
lin par_N = variants{} ; --
lin thrust_N = variants{} ; --
lin scenario_N = variants{} ; --
lin frankly_Adv = variants{} ; --
lin slap_V2 = variants{} ; --
lin recreation_N = variants{} ; --
lin rank_V2 = variants{} ; --
lin rank_V = variants{} ; --
lin spy_N = variants{} ; --
lin filter_V2 = variants{} ; --
lin filter_V = variants{} ; --
lin clearance_N = variants{} ; --
lin blessing_N = variants{} ; --
lin embryo_N = variants{} ; --
lin varied_A = variants{} ; --
lin predictable_A = variants{} ; --
lin mutation_N = variants{} ; --
lin equal_V2 = variants{} ; --
lin can_1_VV = S.can_VV ;
lin can_2_VV = S.can8know_VV ;
lin can_V2 = variants{} ; --
lin burst_N = variants{} ; --
lin retrieve_V2 = variants{} ; --
lin retrieve_V = variants{} ; --
lin elder_N = variants{} ; --
lin rehearsal_N = variants{} ; --
lin optical_A = variants{} ; --
lin hurry_N = variants{} ; --
lin conflict_V = variants{} ; --
lin combat_V2 = variants{} ; --
lin combat_V = variants{} ; --
lin absorption_N = variants{} ; --
lin ion_N = variants{} ; --
lin wrong_Adv = variants{} ; --
lin heroin_N = variants{} ; --
lin bake_V2 = variants{} ; --
lin bake_V = variants{} ; --
lin x_ray_N = variants{} ; --
lin vector_N = variants{} ; --
lin stolen_A = variants{} ; --
lin sacrifice_V2 = variants{} ; --
lin sacrifice_V = variants{} ; --
lin robbery_N = variants{} ; --
lin probe_V2 = variants{} ; --
lin probe_V = variants{} ; --
lin organizational_A = variants{} ; --
lin chalk_N = variants{} ; --
lin bourgeois_A = variants{} ; --
lin villager_N = variants{} ; --
lin morale_N = variants{} ; --
lin express_A = variants{} ; --
lin climb_N = variants{} ; --
lin notify_V2 = variants{} ; --
lin jam_N = variants{} ; --
lin bureaucratic_A = variants{} ; --
lin literacy_N = variants{} ; --
lin frustrate_V2 = variants{} ; --
lin freight_N = variants{} ; --
lin clearing_N = variants{} ; --
lin aviation_N = variants{} ; --
lin legislature_N = variants{} ; --
lin curiously_Adv = variants{} ; --
lin banana_N = variants{} ; --
lin deploy_V2 = variants{} ; --
lin deploy_V = variants{} ; --
lin passionate_A = variants{} ; --
lin monastery_N = variants{} ; --
lin kettle_N = variants{} ; --
lin enjoyable_A = variants{} ; --
lin diagnose_V2 = variants{} ; --
lin quantitative_A = variants{} ; --
lin distortion_N = variants{} ; --
lin monarch_N = variants{} ; --
lin kindly_Adv = variants{} ; --
lin glow_V = variants{} ; --
lin acquaintance_N = variants{} ; --
lin unexpectedly_Adv = variants{} ; --
lin handy_A = variants{} ; --
lin deprivation_N = variants{} ; --
lin attacker_N = variants{} ; --
lin assault_V2 = variants{} ; --
lin screening_N = variants{} ; --
lin retired_A = variants{} ; --
lin quick_Adv = variants{} ; --
lin portable_A = variants{} ; --
lin hostage_N = variants{} ; --
lin underneath_Prep = variants{} ; --
lin jealous_A = variants{} ; --
lin proportional_A = variants{} ; --
lin gown_N = variants{} ; --
lin chimney_N = variants{} ; --
lin bleak_A = variants{} ; --
lin seasonal_A = variants{} ; --
lin plasma_N = variants{} ; --
lin stunning_A = variants{} ; --
lin spray_N = variants{} ; --
lin referral_N = variants{} ; --
lin promptly_Adv = variants{} ; --
lin fluctuation_N = variants{} ; --
lin decorative_A = variants{} ; --
lin unrest_N = variants{} ; --
lin resent_VS = variants{} ; --
lin resent_V2 = variants{} ; --
lin plaster_N = variants{} ; --
lin chew_V2 = variants{} ; --
lin chew_V = variants{} ; --
lin grouping_N = variants{} ; --
lin gospel_N = variants{} ; --
lin distributor_N = variants{} ; --
lin differentiation_N = variants{} ; --
lin blonde_A = variants{} ; --
lin aquarium_N = variants{} ; --
lin witch_N = variants{} ; --
lin renewed_A = variants{} ; --
lin jar_N = variants{} ; --
lin approved_A = variants{} ; --
lin worrying_A = variants{} ; --
lin minimize_V2 = variants{} ; --
lin footstep_N = variants{} ; --
lin delete_V2 = variants{} ; --
lin underneath_Adv = variants{} ; --
lin lone_A = variants{} ; --
lin level_V2 = variants{} ; --
lin level_V = variants{} ; --
lin exceptionally_Adv = variants{} ; --
lin drift_N = variants{} ; --
lin spider_N = variants{} ; --
lin hectare_N = variants{} ; --
lin colonel_N = variants{} ; --
lin swimming_N = variants{} ; --
lin realism_N = variants{} ; --
lin insider_N = variants{} ; --
lin hobby_N = variants{} ; --
lin computing_N = variants{} ; --
lin infrastructure_N = variants{} ; --
lin cooperate_V = variants{} ; --
lin burn_N = variants{} ; --
lin cereal_N = variants{} ; --
lin fold_N = variants{} ; --
lin compromise_V2 = variants{} ; --
lin compromise_V = variants{} ; --
lin boxing_N = variants{} ; --
lin rear_V2 = variants{} ; --
lin rear_V = variants{} ; --
lin lick_V2 = variants{} ; --
lin constrain_V2 = variants{} ; --
lin clerical_A = variants{} ; --
lin hire_N = variants{} ; --
lin contend_VS = variants{} ; --
lin contend_V = variants{} ; --
lin instrumental_A = variants{} ; --
lin terminal_A = variants{} ; --
lin electorate_N = variants{} ; --
lin congratulate_V2 = variants{} ; --
lin balanced_A = variants{} ; --
lin manufacturing_N = variants{} ; --
lin split_N = variants{} ; --
lin domination_N = variants{} ; --
lin blink_V2 = variants{} ; --
lin blink_V = variants{} ; --
lin bleed_VS = variants{} ; --
lin bleed_V2 = variants{} ; --
lin bleed_V = variants{} ; --
lin unlawful_A = variants{} ; --
lin precedent_N = variants{} ; --
lin notorious_A = variants{} ; --
lin indoor_A = variants{} ; --
lin upgrade_V2 = variants{} ; --
lin trench_N = variants{} ; --
lin therapist_N = variants{} ; --
lin illuminate_V2 = variants{} ; --
lin bargain_V2 = variants{} ; --
lin bargain_V = variants{} ; --
lin warranty_N = variants{} ; --
lin scar_V2 = variants{} ; --
lin scar_V = variants{} ; --
lin consortium_N = variants{} ; --
lin anger_V2 = variants{} ; --
lin insure_VS = variants{} ; --
lin insure_V2 = variants{} ; --
lin insure_V = variants{} ; --
lin extensively_Adv = variants{} ; --
lin appropriately_Adv = variants{} ; --
lin spoon_N = variants{} ; --
lin sideways_Adv = variants{} ; --
lin enhanced_A = variants{} ; --
lin disrupt_V2 = variants{} ; --
lin disrupt_V = variants{} ; --
lin satisfied_A = variants{} ; --
lin precaution_N = variants{} ; --
lin kite_N = variants{} ; --
lin instant_N = variants{} ; --
lin gig_N = variants{} ; --
lin continuously_Adv = variants{} ; --
lin consolidate_V2 = variants{} ; --
lin consolidate_V = variants{} ; --
lin fountain_N = variants{} ; --
lin graduate_V2 = variants{} ; --
lin graduate_V = variants{} ; --
lin gloom_N = variants{} ; --
lin bite_N = variants{} ; --
lin structure_V2 = variants{} ; --
lin noun_N = variants{} ; --
lin nomination_N = variants{} ; --
lin armchair_N = variants{} ; --
lin virtual_A = variants{} ; --
lin unprecedented_A = variants{} ; --
lin tumble_V2 = variants{} ; --
lin tumble_V = variants{} ; --
lin ski_N = variants{} ; --
lin architectural_A = variants{} ; --
lin violation_N = variants{} ; --
lin rocket_N = variants{} ; --
lin inject_V2 = variants{} ; --
lin departmental_A = variants{} ; --
lin row_V2 = variants{} ; --
lin row_V = variants{} ; --
lin luxury_A = variants{} ; --
lin fax_N = variants{} ; --
lin deer_N = variants{} ; --
lin climber_N = variants{} ; --
lin photographic_A = variants{} ; --
lin haunt_V2 = variants{} ; --
lin fiercely_Adv = variants{} ; --
lin dining_N = variants{} ; --
lin sodium_N = variants{} ; --
lin gossip_N = variants{} ; --
lin bundle_N = variants{} ; --
lin bend_N = variants{} ; --
lin recruit_N = variants{} ; --
lin hen_N = variants{} ; --
lin fragile_A = variants{} ; --
lin deteriorate_V2 = variants{} ; --
lin deteriorate_V = variants{} ; --
lin dependency_N = variants{} ; --
lin swift_A = variants{} ; --
lin scramble_V2 = variants{} ; --
lin scramble_V = variants{} ; --
lin overview_N = variants{} ; --
lin imprison_V2 = variants{} ; --
lin trolley_N = variants{} ; --
lin rotation_N = variants{} ; --
lin denial_N = variants{} ; --
lin boiler_N = variants{} ; --
lin amp_N = variants{} ; --
lin trivial_A = variants{} ; --
lin shout_N = variants{} ; --
lin overtake_V2 = variants{} ; --
lin make_N = variants{} ; --
lin hunter_N = variants{} ; --
lin guess_N = variants{} ; --
lin doubtless_Adv = variants{} ; --
lin syllable_N = variants{} ; --
lin obscure_A = variants{} ; --
lin mould_N = variants{} ; --
lin limestone_N = variants{} ; --
lin leak_V2 = variants{} ; --
lin leak_V = variants{} ; --
lin beneficiary_N = variants{} ; --
lin veteran_N = variants{} ; --
lin surplus_A = variants{} ; --
lin manifestation_N = variants{} ; --
lin vicar_N = variants{} ; --
lin textbook_N = variants{} ; --
lin novelist_N = variants{} ; --
lin halfway_Adv = variants{} ; --
lin contractual_A = variants{} ; --
lin swap_V2 = variants{} ; --
lin swap_V = variants{} ; --
lin guild_N = variants{} ; --
lin ulcer_N = variants{} ; --
lin slab_N = variants{} ; --
lin detector_N = variants{} ; --
lin detection_N = variants{} ; --
lin cough_V = variants{} ; --
lin whichever_Quant = variants{} ; --
lin spelling_N = variants{} ; --
lin lender_N = variants{} ; --
lin glow_N = variants{} ; --
lin raised_A = variants{} ; --
lin prolonged_A = variants{} ; --
lin voucher_N = variants{} ; --
lin t_shirt_N = variants{} ; --
lin linger_V = variants{} ; --
lin humble_A = variants{} ; --
lin honey_N = variants{} ; --
lin scream_N = variants{} ; --
lin postcard_N = variants{} ; --
lin managing_A = variants{} ; --
lin alien_A = variants{} ; --
lin trouble_V2 = variants{} ; --
lin reverse_N = variants{} ; --
lin odour_N = variants{} ; --
lin fundamentally_Adv = variants{} ; --
lin discount_V2 = variants{} ; --
lin discount_V = variants{} ; --
lin blast_V2 = variants{} ; --
lin blast_V = variants{} ; --
lin syntactic_A = variants{} ; --
lin scrape_V2 = variants{} ; --
lin scrape_V = variants{} ; --
lin residue_N = variants{} ; --
lin procession_N = variants{} ; --
lin pioneer_N = variants{} ; --
lin intercourse_N = variants{} ; --
lin deter_V2 = variants{} ; --
lin deadly_A = variants{} ; --
lin complement_V2 = variants{} ; --
lin restrictive_A = variants{} ; --
lin nitrogen_N = variants{} ; --
lin citizenship_N = variants{} ; --
lin pedestrian_N = variants{} ; --
lin detention_N = variants{} ; --
lin wagon_N = variants{} ; --
lin microphone_N = variants{} ; --
lin hastily_Adv = variants{} ; --
lin fixture_N = variants{} ; --
lin choke_V2 = variants{} ; --
lin choke_V = variants{} ; --
lin wet_V2 = variants{} ; --
lin weed_N = variants{} ; --
lin programming_N = variants{} ; --
lin power_V2 = variants{} ; --
lin nationally_Adv = variants{} ; --
lin dozen_N = variants{} ; --
lin carrot_N = variants{} ; --
lin bulletin_N = variants{} ; --
lin wording_N = variants{} ; --
lin vicious_A = variants{} ; --
lin urgency_N = variants{} ; --
lin spoken_A = variants{} ; --
lin skeleton_N = variants{} ; --
lin motorist_N = variants{} ; --
lin interactive_A = variants{} ; --
lin compute_V2 = variants{} ; --
lin compute_V = variants{} ; --
lin whip_N = variants{} ; --
lin urgently_Adv = variants{} ; --
lin telly_N = variants{} ; --
lin shrub_N = variants{} ; --
lin porter_N = variants{} ; --
lin ethics_N = variants{} ; --
lin banner_N = variants{} ; --
lin velvet_N = variants{} ; --
lin omission_N = variants{} ; --
lin hook_V2 = variants{} ; --
lin hook_V = variants{} ; --
lin gallon_N = variants{} ; --
lin financially_Adv = variants{} ; --
lin superintendent_N = variants{} ; --
lin plug_V2 = variants{} ; --
lin plug_V = variants{} ; --
lin continuation_N = variants{} ; --
lin reliance_N = variants{} ; --
lin justified_A = variants{} ; --
lin fool_V2 = variants{} ; --
lin detain_V2 = variants{} ; --
lin damaging_A = variants{} ; --
lin orbit_N = variants{} ; --
lin mains_N = variants{} ; --
lin discard_V2 = variants{} ; --
lin dine_V = variants{} ; --
lin compartment_N = variants{} ; --
lin revised_A = variants{} ; --
lin privatization_N = variants{} ; --
lin memorable_A = variants{} ; --
lin lately_Adv = variants{} ; --
lin distributed_A = variants{} ; --
lin disperse_V2 = variants{} ; --
lin disperse_V = variants{} ; --
lin blame_N = variants{} ; --
lin basement_N = variants{} ; --
lin slump_V2 = variants{} ; --
lin slump_V = variants{} ; --
lin puzzle_V2 = variants{} ; --
lin monitoring_N = variants{} ; --
lin talented_A = variants{} ; --
lin nominal_A = variants{} ; --
lin mushroom_N = variants{} ; --
lin instructor_N = variants{} ; --
lin fork_N = variants{} ; --
lin fork_4_N = variants{} ; --
lin fork_3_N = variants{} ; --
lin fork_1_N = variants{} ; --
lin board_V2 = variants{} ; --
lin want_N = variants{} ; --
lin disposition_N = variants{} ; --
lin cemetery_N = variants{} ; --
lin attempted_A = variants{} ; --
lin nephew_N = variants{} ; --
lin magical_A = variants{} ; --
lin ivory_N = variants{} ; --
lin hospitality_N = variants{} ; --
lin besides_Prep = variants{} ; --
lin astonishing_A = variants{} ; --
lin tract_N = variants{} ; --
lin proprietor_N = variants{} ; --
lin license_V2 = variants{} ; --
lin differential_A = variants{} ; --
lin affinity_N = variants{} ; --
lin talking_N = variants{} ; --
lin royalty_N = variants{} ; --
lin neglect_N = variants{} ; --
lin irrespective_A = variants{} ; --
lin whip_V2 = variants{} ; --
lin whip_V = variants{} ; --
lin sticky_A = variants{} ; --
lin regret_N = variants{} ; --
lin incapable_A = variants{} ; --
lin franchise_N = variants{} ; --
lin dentist_N = variants{} ; --
lin contrary_N = variants{} ; --
lin profitability_N = variants{} ; --
lin enthusiast_N = variants{} ; --
lin crop_V2 = variants{} ; --
lin crop_V = variants{} ; --
lin utter_V2 = variants{} ; --
lin pile_V2 = variants{} ; --
lin pile_V = variants{} ; --
lin pier_N = variants{} ; --
lin dome_N = variants{} ; --
lin bubble_N = variants{} ; --
lin treasurer_N = variants{} ; --
lin stocking_N = variants{} ; --
lin sanctuary_N = variants{} ; --
lin ascertain_V2 = variants{} ; --
lin arc_N = variants{} ; --
lin quest_N = variants{} ; --
lin mole_N = variants{} ; --
lin marathon_N = variants{} ; --
lin feast_N = variants{} ; --
lin crouch_V = variants{} ; --
lin storm_V2 = variants{} ; --
lin storm_V = variants{} ; --
lin hardship_N = variants{} ; --
lin entitlement_N = variants{} ; --
lin circular_N = variants{} ; --
lin walking_A = variants{} ; --
lin strap_N = variants{} ; --
lin sore_A = variants{} ; --
lin complementary_A = variants{} ; --
lin understandable_A = variants{} ; --
lin noticeable_A = variants{} ; --
lin mankind_N = variants{} ; --
lin majesty_N = variants{} ; --
lin pigeon_N = variants{} ; --
lin goalkeeper_N = variants{} ; --
lin ambiguous_A = variants{} ; --
lin walker_N = variants{} ; --
lin virgin_N = variants{} ; --
lin prestige_N = variants{} ; --
lin preoccupation_N = variants{} ; --
lin upset_A = variants{} ; --
lin municipal_A = variants{} ; --
lin groan_V2 = variants{} ; --
lin groan_V = variants{} ; --
lin craftsman_N = variants{} ; --
lin anticipation_N = variants{} ; --
lin revise_V2 = variants{} ; --
lin revise_V = variants{} ; --
lin knock_N = variants{} ; --
lin infect_V2 = variants{} ; --
lin infect_V = variants{} ; --
lin denounce_V2 = variants{} ; --
lin confession_N = variants{} ; --
lin turkey_N = variants{} ; --
lin toll_N = variants{} ; --
lin pal_N = variants{} ; --
lin transcription_N = variants{} ; --
lin sulphur_N = variants{} ; --
lin provisional_A = variants{} ; --
lin hug_V2 = variants{} ; --
lin particular_N = variants{} ; --
lin intent_A = variants{} ; --
lin fascinate_V2 = variants{} ; --
lin conductor_N = variants{} ; --
lin feasible_A = variants{} ; --
lin vacant_A = variants{} ; --
lin trait_N = variants{} ; --
lin meadow_N = variants{} ; --
lin creed_N = variants{} ; --
lin unfamiliar_A = variants{} ; --
lin optimism_N = variants{} ; --
lin wary_A = variants{} ; --
lin twist_N = variants{} ; --
lin sweet_N = variants{} ; --
lin substantive_A = variants{} ; --
lin excavation_N = variants{} ; --
lin destiny_N = variants{} ; --
lin thick_Adv = variants{} ; --
lin pasture_N = variants{} ; --
lin archaeological_A = variants{} ; --
lin tick_V2 = variants{} ; --
lin tick_V = variants{} ; --
lin profit_V2 = variants{} ; --
lin profit_V = variants{} ; --
lin pat_V2 = variants{} ; --
lin pat_V = variants{} ; --
lin papal_A = variants{} ; --
lin cultivate_V2 = variants{} ; --
lin awake_V = variants{} ; --
lin trained_A = variants{} ; --
lin civic_A = variants{} ; --
lin voyage_N = variants{} ; --
lin siege_N = variants{} ; --
lin enormously_Adv = variants{} ; --
lin distract_V2 = variants{} ; --
lin distract_V = variants{} ; --
lin stroll_V = variants{} ; --
lin jewel_N = variants{} ; --
lin honourable_A = variants{} ; --
lin helpless_A = variants{} ; --
lin hay_N = variants{} ; --
lin expel_V2 = variants{} ; --
lin eternal_A = variants{} ; --
lin demonstrator_N = variants{} ; --
lin correction_N = variants{} ; --
lin civilization_N = variants{} ; --
lin ample_A = variants{} ; --
lin retention_N = variants{} ; --
lin rehabilitation_N = variants{} ; --
lin premature_A = variants{} ; --
lin encompass_V2 = variants{} ; --
lin distinctly_Adv = variants{} ; --
lin diplomat_N = variants{} ; --
lin articulate_V2 = variants{} ; --
lin articulate_V = variants{} ; --
lin restricted_A = variants{} ; --
lin prop_V2 = variants{} ; --
lin intensify_V2 = variants{} ; --
lin intensify_V = variants{} ; --
lin deviation_N = variants{} ; --
lin contest_V2 = variants{} ; --
lin contest_V = variants{} ; --
lin workplace_N = variants{} ; --
lin lazy_A = variants{} ; --
lin kidney_N = variants{} ; --
lin insistence_N = variants{} ; --
lin whisper_N = variants{} ; --
lin multimedia_N = variants{} ; --
lin forestry_N = variants{} ; --
lin excited_A = variants{} ; --
lin decay_N = variants{} ; --
lin screw_N = variants{} ; --
lin rally_V2V = variants{} ; --
lin rally_V2 = variants{} ; --
lin rally_V = variants{} ; --
lin pest_N = variants{} ; --
lin invaluable_A = variants{} ; --
lin homework_N = variants{} ; --
lin harmful_A = variants{} ; --
lin bump_V2 = variants{} ; --
lin bump_V = variants{} ; --
lin bodily_A = variants{} ; --
lin grasp_N = variants{} ; --
lin finished_A = variants{} ; --
lin facade_N = variants{} ; --
lin cushion_N = variants{} ; --
lin conversely_Adv = variants{} ; --
lin urge_N = variants{} ; --
lin tune_V2 = variants{} ; --
lin tune_V = variants{} ; --
lin solvent_N = variants{} ; --
lin slogan_N = variants{} ; --
lin petty_A = variants{} ; --
lin perceived_A = variants{} ; --
lin install_V2 = variants{} ; --
lin install_V = variants{} ; --
lin fuss_N = variants{} ; --
lin rack_N = variants{} ; --
lin imminent_A = variants{} ; --
lin short_N = variants{} ; --
lin revert_V = variants{} ; --
lin ram_N = variants{} ; --
lin contraction_N = variants{} ; --
lin tread_V2 = variants{} ; --
lin tread_V = variants{} ; --
lin supplementary_A = variants{} ; --
lin ham_N = variants{} ; --
lin defy_V2V = variants{} ; --
lin defy_V2 = variants{} ; --
lin athlete_N = variants{} ; --
lin sociological_A = variants{} ; --
lin physician_N = variants{} ; --
lin crossing_N = variants{} ; --
lin bail_N = variants{} ; --
lin unwanted_A = variants{} ; --
lin tight_Adv = variants{} ; --
lin plausible_A = variants{} ; --
lin midfield_N = variants{} ; --
lin alert_A = variants{} ; --
lin feminine_A = variants{} ; --
lin drainage_N = variants{} ; --
lin cruelty_N = variants{} ; --
lin abnormal_A = variants{} ; --
lin relate_N = variants{} ; --
lin poison_V2 = variants{} ; --
lin symmetry_N = variants{} ; --
lin stake_V2 = variants{} ; --
lin rotten_A = L.rotten_A ;
lin prone_A = variants{} ; --
lin marsh_N = variants{} ; --
lin litigation_N = variants{} ; --
lin curl_N = variants{} ; --
lin urine_N = variants{} ; --
lin latin_A = variants{} ; --
lin hover_V = variants{} ; --
lin greeting_N = variants{} ; --
lin chase_N = variants{} ; --
lin produce_N = variants{} ; --
lin forge_V2 = variants{} ; --
lin forge_V = variants{} ; --
lin salon_N = variants{} ; --
lin handicapped_A = variants{} ; --
lin sway_V2 = variants{} ; --
lin sway_V = variants{} ; --
lin homosexual_A = variants{} ; --
lin handicap_V2 = variants{} ; --
lin colon_N = variants{} ; --
lin upstairs_N = variants{} ; --
lin stimulation_N = variants{} ; --
lin spray_V2 = variants{} ; --
lin original_N = variants{} ; --
lin lay_A = variants{} ; --
lin garlic_N = variants{} ; --
lin suitcase_N = variants{} ; --
lin skipper_N = variants{} ; --
lin moan_VS = variants{} ; --
lin moan_V = variants{} ; --
lin manpower_N = variants{} ; --
lin manifest_V2 = variants{} ; --
lin incredibly_Adv = variants{} ; --
lin historically_Adv = variants{} ; --
lin decision_making_N = variants{} ; --
lin wildly_Adv = variants{} ; --
lin reformer_N = variants{} ; --
lin quantum_N = variants{} ; --
lin considering_Subj = variants{} ; --
}
