concrete DictionaryIta of Dictionary = CatIta
** open ParadigmsIta, (P = ParadigmsIta), 
        IrregIta, (I=IrregIta), MorphoIta, (L=LexiconIta), (S=SyntaxIta), (E=ExtraIta), (R = ResIta), Prelude in {

oper mkInterj : Str -> Interj
= \s -> lin Interj (ss s) ;
oper mkDet = overload {
  mkDet : Str -> Det = \s -> lin Det {s,sp = \\_,c => prepCase c ++ s ; n = Sg ; s2 = [] ; isNeg = False} ;
  mkDet : Str -> Str -> Number -> Det = 
     \s,t,n -> lin Det {s,sp = \\g,c => prepCase c ++ genForms s t ! g ; n = n ; s2 = [] ; isNeg = False} ;
     } ;
oper mkConj : Str -> Conj
  = \s -> lin Conj {s1 = [] ; s2 = s ; n = Pl} ;
oper mkSubj : Str -> Subj
  = \s -> lin Subj {s = [] ; m = Indic} ; ----
oper subSubj : Str -> Subj
  = \s -> lin Subj {s = [] ; m = Conjunct} ; ----
oper optProDrop : Pron -> Pron = \p -> p | E.ProDrop p ;

oper mkvVS : Str -> VS = \s -> mkVS (mkV s) ;
oper mkvVV : Str -> VV = \s -> mkVV (mkV s) ;

oper adjAdv : A -> Adv = \a -> S.mkAdv a ;

oper prepV2 : V -> Prep -> V2 = \v,p -> mkV2 v p ;
oper advV : V -> Adv -> V = \v,a -> mkV v a.s ;

lin a_priori_Adv = mkAdv "a_priori" | mkAdv "aprioristicamente" | mkAdv "precedentemente" | mkAdv "priori" ; -- UWN
lin aachen_PN = mkPN "Aquisgrana" ; -- status=guess src=geonames
lin aardvark_N = mkN "oritteropo" ; -- status=guess
lin aardwolf_N = mkN "protele" ; -- status=guess
lin ab_initio_Adv = mkAdv "da_prima" | mkAdv "dapprima" | mkAdv "inizialmente" | mkAdv "originariamente" | mkAdv "priori" ; -- UWN
lin abaca_N = mkN "abaca" ; -- status=guess
lin aback_Adv = mkAdv "all'indietro" ; -- status=guess
lin abacus_N = mkN "abaco" | mkN "pallottoliere" masculine ; -- status=guess status=guess
lin abalone_N = mkN "abalone" ; -- status=guess
lin abandon_N = mkN "abbandono" ; -- status=guess
lin abandon_V2 = mkV2 (mkV "bandire") ; -- status=guess, src=wikt
lin abandonment_N = mkN "abbandono" ; -- status=guess
lin abashment_N = mkN "modestia" ; -- UWN
lin abasia_N = mkN "abasia" ; -- status=guess
lin abatement_N = mkN "riduzione" feminine ; -- status=guess
lin abattis_N = mkN "abbattuta" ; -- UWN
lin abattoir_N = mkN "mattatoio" ; -- status=guess
lin abbess_N = mkN "badessa" ; -- status=guess
lin abbey_N = mkN "abbazia" ; -- status=guess
lin abbot_N = mkN "abate" masculine ; -- status=guess
lin abbreviate_V2 = mkV2 (mkV "abbreviare") ; -- status=guess, src=wikt
lin abbreviation_N = mkN "riassunto" ; -- status=guess
lin abdicate_V = mkV "abdicare" ; -- status=guess, src=wikt
lin abdicate_V2 = mkV2 (mkV "abdicare") ; -- status=guess, src=wikt
lin abdication_N = mkN "abdicazione" feminine ; -- status=guess
lin abdomen_N = mkN "addome" masculine ; -- status=guess
lin abdominal_A = mkA "addominale" ; -- status=guess
lin abdominocentesis_N = mkN "paracentesi" ; -- UWN
lin abducent_A = mkA "abducente" ; -- UWN
lin abduct_V2 = mkV2 (abdurre_V) ; -- status=guess, src=wikt
lin abduction_N = mkN "rapimento" | mkN "sequestro" ; -- status=guess status=guess
lin abelia_N = mkN "abelia" ; -- UWN
lin abelmosk_N = mkN "abelmosco" ; -- status=guess
lin abercarn_PN = mkPN "Abercarn" ; -- status=guess src=geonames
lin aberdare_PN = mkPN "Aberdare" ; -- status=guess src=geonames
lin aberdeen_PN = mkPN "Aberdeen" ; -- status=guess src=geonames
lin abergavenny_PN = mkPN "Abergavenny" ; -- status=guess src=geonames
lin abergele_PN = mkPN "Abergele" ; -- status=guess src=geonames
lin aberrant_A = mkA "aberrante" ; -- status=guess
lin aberration_N = mkN "aberrazione" feminine ; -- status=guess
lin abertillery_PN = mkPN "Abertillery" ; -- status=guess src=geonames
lin aberystwyth_PN = mkPN "Aberystwyth" ; -- status=guess src=geonames
lin abet_V = mkV "favoreggiare" | mkV "incoraggiare" | mkV "istigare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin abet_V2 = mkV2 (mkV "favoreggiare") | mkV2 (mkV "incoraggiare") | mkV2 (mkV "istigare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin abhor_V2 = mkV2 (mkV "aborrire") | mkV2 (mkV "abominare") ; -- status=guess, src=wikt status=guess, src=wikt
lin abhorrent_A = mkA "contrario" | mkA "incompatibile" | mkA "contro" ; -- status=guess status=guess status=guess
lin abide_V = mkV (mkV "conformarsi") "a" ; -- status=guess, src=wikt
lin abide_V2 = mkV2 (mkV (mkV "conformarsi") "a") ; -- status=guess, src=wikt
lin ability_N = mkN "capacità" feminine ; -- status=guess
lin abingdon_PN = mkPN "Abingdon" ; -- status=guess src=geonames
lin abiogenesis_N = mkN "abiogenesi" | mkN "autogenesi" ; -- UWN
lin abiogenetic_A = mkA "abiogenetico" ; -- UWN
lin abiogenist_N = mkN "abiogenista" ; -- UWN
lin abject_A = mkA "abbietto" ; -- status=guess
lin abjection_N = mkN "abbiezione" | mkN "abiezione" | mkN "degradazione" | mkN "fango" ; -- UWN
lin abjuration_N = mkN "ritrattazione" ; -- UWN
lin abjure_V2 = mkV2 (mkV "abiurare") ; -- status=guess, src=wikt
lin ablactation_N = mkN "divezzamento" | mkN "slattamento" | mkN "svezzamento" ; -- UWN
lin ablation_N = mkN "ablazione" | mkN "asportazione" | mkN "escissione" ; -- UWN
lin ablative_A = mkA "ablativo" ; -- status=guess
lin ablative_N = mkN "ablativo" ; -- status=guess
lin ablaze_A = mkA "in fiamme" | mkA "fiammeggiante" ; -- status=guess status=guess
lin able_A = mkA "capace" ; -- status=guess
lin ablution_N = mkN "abluzione" feminine ; -- status=guess
lin abnegation_N = mkN "abnegazione" feminine ; -- status=guess
lin abnormal_A = mkA "anormale" | mkA "anomalo" ; -- status=guess status=guess
lin abnormality_N = mkN "anomalia" ; -- status=guess
lin aboard_Adv = mkAdv "a bordo" ; -- status=guess
lin abode_N = mkN "abitazione" | mkN "casa" | mkN "dimora" | mkN "magione" ; -- UWN
lin abolish_V2 = mkV2 (mkV "abolire") ; -- status=guess, src=wikt
lin abolition_N = mkN "abolizione" feminine ; -- status=guess
lin abolitionism_N = mkN "abolizionismo" | mkN "antischiavismo" ; -- UWN
lin abolitionist_N = mkN "abolizionista" | mkN "antischiavista" ; -- UWN
lin abomasum_N = mkN "abomaso" ; -- UWN
lin abominable_A = mkA "abominabile" ; -- status=guess
lin abominate_V2 = mkV2 (mkV "abominare") ; -- status=guess, src=wikt
lin aboriginal_A = mkA "aborigeno" ; -- status=guess
lin aborigine_N = mkN "aborigeno" ; -- status=guess
lin abort_V = interrompere_V | mkV "fermare" ; -- status=guess, src=wikt status=guess, src=wikt
lin abort_V2 = mkV2 (interrompere_V) | mkV2 (mkV "fermare") ; -- status=guess, src=wikt status=guess, src=wikt
lin aborticide_N = mkN "feticidio" ; -- UWN
lin abortifacient_N = mkN "abortivo" ; -- UWN
lin abortion_N = mkN "aborto" ; -- status=guess
lin abortionistFem_N = variants {} ; ---- sense to be split
lin abortionistMasc_N = variants {} ; ---- sense to be split
lin abortus_N = mkN "aborto" ; -- UWN
lin abound_V = mkV "abbondare" | mkV (essere_V) "abbondante" ; -- status=guess, src=wikt status=guess, src=wikt
lin about_Adv = mkAdv "intorno" ;
lin about_Prep = ParadigmsIta.genitive ;
lin above_A = mkA "suddetto" | mkA "succitato" ; -- status=guess status=guess
lin above_Adv = mkAdv "sopra" ;
lin above_Prep = S.above_Prep ;
lin abracadabra_N = mkN "abracadabra" ; -- UWN
lin abranchiate_A = mkA "abranchiato" ; -- UWN
lin abrasion_N = mkN "abrasione" feminine ; -- status=guess
lin abreast_Adv = mkAdv "con i tempi" ;
lin abridge_V2 = mkV2 (mkV "privare") | mkV2 (mkV "limitare") ; -- status=guess, src=wikt status=guess, src=wikt
lin abridgement_N = mkN "compendio" | mkN "edizione_ridotta" | mkN "riduzione" | mkN "ompendio" ; -- UWN
lin abridger_N = mkN "abbreviatore" | mkN "compendiatore" | mkN "epitomatore" ; -- UWN
lin abroad_Adv = mkAdv "all'estero" ; -- status=guess
lin abrogation_N = mkN "abrogazione" | mkN "annullamento" | mkN "cancellazione" | mkN "cassazione" ; -- UWN
lin abrupt_A = mkA "brusco" | mkA "brusca" ; -- status=guess status=guess
lin abruptness_N = mkN "asciuttezza" | mkN "bruschezza" | mkN "secchezza" ; -- UWN
lin abscess_N = mkN "ascesso" ; -- status=guess
lin abscissa_N = mkN "ascissa" ; -- status=guess
lin abscission_N = mkN "recisione" ; -- UWN
lin absence_N = mkN "assenza" ; -- status=guess
lin absent_A = mkA "assente" ; -- status=guess
lin absentee_N = mkN "assente" ; -- status=guess
lin absenteeism_N = mkN "assenteismo" ; -- UWN
lin absinthe_N = mkN "assenzio" ; -- status=guess
lin absolute_A = mkA "assoluto" ; -- status=guess
lin absolute_N = mkN "alcol assoluto" ; -- status=guess
lin absoluteness_N = mkN "assolutezza" ; -- status=guess
lin absolution_N = mkN "assoluzione" ; -- UWN
lin absolutism_N = mkN "assolutismo" | mkN "autoritarismo" ; -- UWN
lin absolutist_A = mkA "assolutistico" | mkA "autoritario" ; -- UWN
lin absolve_V2 = mkV2 (assolvere_V) ; -- status=guess, src=wikt
lin absorb_V2 = mkV2 (mkV "assorbire") ; -- status=guess, src=wikt
lin absorbable_A = mkA "assorbibile" ; -- status=guess
lin absorbency_N = mkN "capacità di assorbimento" ; -- status=guess
lin absorbent_A = mkA "assorbente" ; -- status=guess
lin absorbent_N = mkN "assorbente" ; -- UWN
lin absorption_N = mkN "assorbimento" ; -- status=guess
lin abstain_V = mkV "astenersi" ; -- status=guess, src=wikt
lin abstemious_A = mkA "astemio" ; -- status=guess
lin abstention_N = mkN "astensione" ; -- status=guess
lin abstinence_N = mkN "astinenza" ; -- status=guess
lin abstinent_A = mkA "astinente" ; -- UWN
lin abstract_A = mkA "astratto" | mkA "teorico" ; -- status=guess status=guess
lin abstract_N = mkN "estratto" | mkN "sunto" | mkN "compendio" | mkN "riassunto" ; -- status=guess status=guess status=guess status=guess
lin abstract_V2 = mkV2 (riassumere_V) ; -- status=guess, src=wikt
lin abstraction_N = mkN "astrazione" feminine ; -- status=guess
lin abstractionism_N = mkN "astrattismo" ; -- UWN
lin abstractionist_N = mkN "astrattista" ; -- UWN
lin abstractness_N = mkN "astrattezza" ; -- UWN
lin abstruse_A = mkA "astruso" ; -- status=guess
lin abstruseness_N = mkN "astruseria" ; -- status=guess
lin absurd_A = mkA "assurdo" ; -- status=guess
lin abulia_N = mkN "abulia" ; -- status=guess
lin abundance_N = mkN "abbondanza" ; -- status=guess
lin abundant_A = mkA "abbondante" ; -- status=guess
lin abuse_N = mkN "abuso" ; -- status=guess
lin abuse_V2 = mkV2 (mkV "abusare") ; -- status=guess, src=wikt
lin abutment_N = mkN "rinfianco" ; -- status=guess
lin abysm_N = mkN "abisso" | mkN "baratro" | mkN "precipizio" ; -- UWN
lin abyss_N = mkN "abisso" ; -- status=guess
lin acacia_N = mkN "acacia" ; -- status=guess
lin academic_A = mkA "accademico" ; -- status=guess
lin academic_N = variants {} ; --
lin academicianFem_N = mkN "accademico" | mkN "docente_universitario" | mkN "universitario" ; -- UWN
lin academicianMasc_N = mkN "accademico" | mkN "docente_universitario" | mkN "universitario" ; -- UWN
lin academy_N = mkN "accademia" masculine ; -- status=guess
lin acanthus_N = mkN "acanto" ; -- status=guess
lin acariasis_N = mkN "acariasi" | mkN "acariosi" ; -- UWN
lin acaricide_N = mkN "acaricida" ; -- UWN
lin acarophobia_N = mkN "acarofobia" ; -- status=guess
lin acarus_N = mkN "acaro" ; -- UWN
lin accelerate_V = mkV "accelerare" ; -- status=guess, src=wikt
lin accelerate_V2 = mkV2 (mkV "accelerare") ; -- status=guess, src=wikt
lin acceleration_N = mkN "accelerazione" feminine ; -- status=guess
lin accelerator_N = mkN "acceleratore" masculine ; -- status=guess
lin accelerometer_N = mkN "accelerometro" ; -- UWN
lin accent_N = mkN "accento" ; -- status=guess
lin accentuate_V2 = mkV2 (mkV "accentuare") ; -- status=guess, src=wikt
lin accentuation_N = mkN "enfatizzazione" ; -- UWN
lin accept_V = mkV "accettare" | ammettere_V ; -- status=guess, src=wikt status=guess, src=wikt
lin accept_V2 = mkV2 (mkV "accettare") | mkV2 (ammettere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin accept_VS = mkVS (mkV "accettare") | mkVS (ammettere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin acceptability_N = mkN "ammissibilità" | mkN "tollerabilità" ; -- UWN
lin acceptable_A = mkA "accettabile" ; -- status=guess
lin acceptance_N = mkN "accettazione" feminine ; -- status=guess
lin acceptor_N = mkN "accettante" ; -- UWN
lin access_N = mkN "accesso" feminine ; -- status=guess
lin access_V2 = variants {} ; --
lin accessary_N = mkN "compare" | mkN "complice" | mkN "correo" | mkN "corresponsabile" ; -- UWN
lin accessibility_N = mkN "accessibilità" feminine ; -- status=guess
lin accessible_A = mkA "accessibile" ; -- status=guess
lin accession_N = mkN "ascesa" | mkN "assunzione" ; -- UWN
lin accessory_N = mkN "accessorio" ; -- status=guess
lin accident_N = mkN "incidente" ; -- status=guess
lin accidental_A = mkA "accidentale" ; -- status=guess
lin accidental_N = mkN "accidentale" ; -- status=guess
lin acclaim_N = mkN "acclamazione" ; -- UWN
lin acclaim_V2 = mkV2 (mkV "acclamare") | mkV2 (mkV "applaudire") ; -- status=guess, src=wikt status=guess, src=wikt
lin acclamation_N = mkN "acclamazione" feminine ; -- status=guess
lin acclimation_N = mkN "acclimamento" | mkN "acclimatamento" | mkN "acclimatazione" | mkN "acclimazione" | mkN "ambientamento" ; -- UWN
lin acclimatization_N = mkN "acclimatazione" feminine ; -- status=guess
lin acclimatize_V = mkV "acclimatare" ; -- status=guess, src=wikt
lin acclimatize_V2 = mkV2 (mkV "acclimatare") ; -- status=guess, src=wikt
lin acclivity_N = mkN "salita" ; -- UWN
lin accolade_N = mkN "ordinazione" feminine ; -- status=guess
lin accommodate_V = variants {} ; --
lin accommodate_V2 = variants {} ; --
lin accommodation_N = mkN "sistemazione" feminine | mkN "alloggio" ; -- status=guess status=guess
lin accommodative_A = mkA "accomodante" | mkA "accomodativo" | mkA "cile" | mkA "compiacente" ; -- UWN
lin accompaniment_N = mkN "accompagnamento" ; -- status=guess
lin accompanist_N = mkN "accompagnatore" ; -- UWN
lin accompany_V2 = mkV2 (mkV "accompagnare") ; -- status=guess, src=wikt
lin accomplice_N = mkN "accomplice" | mkN "correo" ; -- status=guess status=guess
lin accomplish_V2 = mkV2 (compiere_V) | mkV2 (mkV "realizzare") ; -- status=guess, src=wikt status=guess, src=wikt
lin accomplishment_N = mkN "realizzazione" feminine ; -- status=guess
lin accord_N = mkN "accordo" ; -- status=guess
lin accord_V = variants {} ; --
lin accordance_N = variants {} ; --
lin according_to_Prep = variants {} ; --
lin accordingly_Adv = mkAdv "di conseguenza" | mkAdv "in conformità a" | mkAdv "conformemente" ; -- status=guess status=guess status=guess
lin accordion_N = mkN "fisarmonica" ; -- status=guess
lin accordionist_N = mkN "fisarmonicista" masculine ; -- status=guess
lin accost_V2 = mkV2 (mkV (mkV "indirizzarsi") "a") ; -- status=guess, src=wikt
lin account_N = mkN "contabilità" feminine ; -- status=guess
lin account_V = mkV "reputare" | mkV "considerare" | ritenere_V ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin account_V2 = mkV2 (mkV "reputare") | mkV2 (mkV "considerare") | mkV2 (ritenere_V) ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin account_for_V2 = prepV2 OP_account_V OP_for_Prep ; -- guess-p-verb
lin accountability_N = mkN "responsabilità" feminine ; -- status=guess
lin accountable_A = mkA "responsabile" ; -- status=guess
lin accountancy_N = mkN "contabilità" feminine ; -- status=guess
lin accountant_N = mkN "contabile" | mkN "ragioniere" masculine ; -- status=guess status=guess
lin accounting_A = variants {} ; --
lin accra_PN = mkPN "Accra" ; -- status=guess src=geonames
lin accredit_V2 = mkV2 (mkV "accreditare") ; -- status=guess, src=wikt
lin accreditation_N = mkN "accreditamento" ; -- status=guess
lin accretion_N = mkN "accrescimento" ; -- status=guess
lin accrington_PN = mkPN "Accrington" ; -- status=guess src=geonames
lin accrue_V = mkV "accrescersi" ; -- status=guess, src=wikt
lin accrue_V2 = mkV2 (mkV "accrescersi") ; -- status=guess, src=wikt
lin acculturation_N = mkN "acculturazione" ; -- UWN
lin accumulate_V = mkV "accumularsi" ; -- status=guess, src=wikt
lin accumulate_V2 = mkV2 (mkV "accumularsi") ; -- status=guess, src=wikt
lin accumulation_N = mkN "accumulazione" feminine ; -- status=guess
lin accumulator_N = mkN "accumulatore" masculine ; -- status=guess
lin accuracy_N = mkN "esattezza" | mkN "precisione" feminine | mkN "accuratezza" ; -- status=guess status=guess status=guess
lin accurate_A = mkA "accurato" | mkA "esatto" ; -- UWN
lin accusation_N = mkN "accusa" ; -- status=guess
lin accusative_A = mkA "accusativo" ; -- status=guess
lin accusative_N = mkN "accusativo" ; -- status=guess
lin accuse_V2 = mkV2 (mkV "accusare") ; -- status=guess, src=wikt
lin accused_A = variants {} ; --
lin accuserFem_N = mkN "accusatore" ; -- UWN
lin accuserMasc_N = mkN "accusatore" ; -- UWN
lin ace_N = mkN "asso" ; -- status=guess
lin acentric_A = mkA "acentrico" ; -- status=guess
lin acephalia_N = mkN "acefalia" ; -- UWN
lin acerb_A = mkA "acerbo" ; -- status=guess
lin acerbity_N = mkN "amarezza" ; -- status=guess
lin acetabulum_N = mkN "acetabolo" | mkN "acetabulo" | mkN "cotile" ; -- UWN
lin acetaldehyde_N = mkN "acetaldeide" feminine ; -- status=guess
lin acetamide_N = mkN "acetammide" feminine ; -- status=guess
lin acetaminophen_N = mkN "paracetamolo" ; -- status=guess
lin acetate_N = mkN "acetato" ; -- status=guess
lin acetic_A = mkA "acetico" ; -- status=guess
lin acetone_N = mkN "acetone" masculine ; -- status=guess
lin acetophenetidin_N = mkN "fenacetina" ; -- UWN
lin acetose_A = mkA "acetoso" ; -- UWN
lin acetum_N = mkN "aceto" ; -- UWN
lin acetyl_N = mkN "acetile" masculine ; -- status=guess
lin acetylcholine_N = mkN "acetilcolina" ; -- status=guess
lin acetylene_N = mkN "acetilene" ; -- status=guess
lin ache_N = mkN "dolore" masculine ; -- status=guess
lin achene_N = mkN "achenio" ; -- status=guess
lin achievability_N = mkN "realizzabilità" ; -- UWN
lin achieve_V2 = mkV2 (mkV "realizzare") ; -- status=guess, src=wikt
lin achievement_N = mkN "realizzazione" feminine ; -- status=guess
lin achlamydeous_A = mkA "aclamidato" | mkA "aclamide" ; -- UWN
lin achlorhydria_N = mkN "acloridria" ; -- status=guess
lin achromatic_A = mkA "acromatico" ; -- status=guess
lin acid_A = mkA "acido" ; -- status=guess
lin acid_N = mkN "acido" | mkN "acido lisergico" ; -- status=guess status=guess
lin acidic_A = mkA "acido" ; -- status=guess
lin acidification_N = mkN "acidificazione" feminine ; -- status=guess
lin acidify_V = mkV "acidificare" ; -- status=guess, src=wikt
lin acidify_V2 = mkV2 (mkV "acidificare") ; -- status=guess, src=wikt
lin acidimetry_N = mkN "acidimetria" ; -- UWN
lin acidosis_N = mkN "acidosi" ; -- status=guess
lin acknowledge_V2 = mkV2 (riconoscere_V) | mkV2 (ammettere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin acknowledge_VS = mkVS (riconoscere_V) | mkVS (ammettere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin acknowledgement_N = mkN "riconoscimento" ; -- status=guess
lin acne_N = mkN "acne" feminine ; -- status=guess
lin acolyte_N = mkN "accolito" ; -- UWN
lin aconite_N = mkN "aconito" ; -- status=guess
lin acorn_N = mkN "ghianda" ; -- status=guess
lin acoustic_A = mkA "acustico" ; -- status=guess
lin acoustics_N = mkN "acustica" ; -- status=guess
lin acquaintance_N = mkN "conoscenza" masculine ; -- status=guess
lin acquaintanceship_N = mkN "conoscenza" ; -- UWN
lin acquiescence_N = mkN "acconsentimento" | mkN "acquiescenza" | mkN "adesione" | mkN "arrendevolezza" | mkN "assenso" | mkN "assentimento" | mkN "beneplacito" | mkN "benestare" | mkN "consenso" | mkN "permesso" ; -- UWN
lin acquire_V2 = mkV2 (mkV "acquisire") ; -- status=guess, src=wikt
lin acquirement_N = mkN "abilità" | mkN "arte" | mkN "bravura" | mkN "capacità" | mkN "mestiere" | mkN "valentia" ; -- UWN
lin acquirer_N = mkN "banca_d'affari" | mkN "banca_di_investimento" | mkN "merchant_bank" ; -- UWN
lin acquisition_N = mkN "acquisizione" feminine ; -- status=guess
lin acquittal_N = mkN "assoluzione" | mkN "proscioglimento" ; -- UWN
lin acre_N = mkN "acro" ; -- UWN
lin acrimony_N = mkN "acerbità" | mkN "acrimonia" | mkN "amarezza" ; -- UWN
lin acrobatFem_N = mkN "acrobata" | mkN "saltambanco" | mkN "saltimbanco" ; -- UWN
lin acrobatMasc_N = mkN "acrobata" | mkN "saltambanco" | mkN "saltimbanco" ; -- UWN
lin acrobatic_A = mkA "acrobatico" ; -- status=guess
lin acrobatics_N = mkN "acrobazia" | mkN "acrobazie aeree" ; -- UWN
lin acrocentric_A = mkA "acrocentrico" ; -- status=guess
lin acromegaly_N = mkN "acromegalia" ; -- status=guess
lin acronym_N = mkN "acronimo" ; -- status=guess
lin acropolis_N = mkN "acropoli" | mkN "cittadella" ; -- UWN
lin across_Adv = mkAdv "attraverso" | mkAdv "orizzontale" ; -- status=guess status=guess
lin across_Prep = variants {} ; --
lin acrostic_N = mkN "acrostico" ; -- status=guess
lin acrylamide_N = mkN "acrilammide" feminine ; -- status=guess
lin acrylic_N = mkN "acido acrilico" ; -- status=guess
lin act_N = mkN "atto" ; -- status=guess
lin act_V = I.fare_V | mkV "comportarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin act_V2 = mkV2 (I.fare_V) | mkV2 (mkV "comportarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin act_on_V2 = prepV2 OP_act_V OP_on_Prep ; -- guess-p-verb
lin act_out_V2 = prepV2 OP_act_V OP_out_Prep ; -- guess-p-verb
lin act_up_V = advV OP_act_V OP_up_Adv ; -- guess-p-verb
lin act_upon_V2 = prepV2 OP_act_V OP_upon_Prep ; -- guess-p-verb
lin actable_A = mkA "recitabile" ; -- UWN
lin actinia_N = mkN "actinia" | mkN "attinia" ; -- UWN
lin actinic_A = mkA "attinico" ; -- UWN
lin actinism_N = mkN "attinicità" ; -- UWN
lin actinium_N = mkN "attinio" ; -- status=guess
lin actinoid_N = mkN "attinoide" masculine ; -- status=guess
lin actinometer_N = mkN "attinometro" ; -- status=guess
lin actinometric_A = mkA "attinometrico" ; -- UWN
lin actinometry_N = mkN "attinometria" ; -- UWN
lin actinomorphic_A = mkA "actinomorfo" | mkA "attinomorfo" ; -- UWN
lin actinomyces_N = mkN "actinomiceti" | mkN "micobatteri" ; -- UWN
lin action_N = mkN "azione" feminine ; -- status=guess
lin activate_V2 = mkV2 (mkV "attivare") ; -- status=guess, src=wikt
lin active_A = mkA "attivo" ; -- status=guess
lin active_N = mkN "forma attiva" | mkN "attivo" ; -- status=guess status=guess
lin activeness_N = mkN "alacrità" | mkN "attività" | mkN "laboriosità" ; -- UWN
lin activism_N = mkN "attivismo" ; -- UWN
lin activistFem_N = mkN "attivista" | mkN "militante" ; -- UWN
lin activistMasc_N = variants {} ; --
lin activity_N = mkN "attività" feminine ; -- status=guess
lin actor_1_N = mkN "attore" | mkN "interprete" | mkN "istrione" ; -- UWN
lin actor_2_N = mkN "attore" | mkN "interprete" | mkN "istrione" ; -- UWN
lin actor_N = mkN "attore" | mkN "attrice" feminine ; -- status=guess status=guess
lin actress_N = mkN "attrice" feminine ; -- status=guess
lin actual_A = mkA "reale" | mkA "effettivo" ; -- status=guess status=guess
lin actuality_N = mkN "attualità" ; -- UWN
lin actually_Adv = adjAdv actual_A ; -- -- derived
lin actuarial_A = mkA "attuariale" ; -- UWN
lin actuary_N = mkN "attuario" ; -- status=guess
lin actuator_N = mkN "attuatore" masculine | mkN "ripetitore" masculine ; -- status=guess status=guess
lin acuate_A = mkA "acuto" | mkA "aguzzo" | mkA "appuntito" ; -- UWN
lin acuity_N = mkN "acume" | mkN "acutezza" | mkN "argutezza" | mkN "finezza" | mkN "perspicacia" | mkN "sagacia" ; -- UWN
lin aculeate_A = mkA "aculeato" ; -- UWN
lin aculeus_N = mkN "aculeo" | mkN "pungiglione" ; -- UWN
lin acupuncture_N = mkN "agopuntura" ; -- status=guess
lin acute_A = mkA "acuto" ; -- status=guess
lin acyclic_A = mkA "aciclico" ; -- status=guess
lin acyl_N = mkN "acile" masculine ; -- status=guess
lin ad_N = mkN "annuncio" | mkN "annunzio" | mkN "inserzione" | mkN "pubblicità" | mkN "reclame" ; -- UWN
lin ada_PN = mkPN "Ada" ; -- status=guess src=geonames
lin adamant_N = mkN "adamantino" ; -- status=guess
lin adapt_V = mkV "adattare" ; -- status=guess, src=wikt
lin adapt_V2 = mkV2 (mkV "adattare") ; -- status=guess, src=wikt
lin adaptability_N = mkN "adattabilità" feminine ; -- status=guess
lin adaptable_A = mkA "adattabile" ; -- status=guess
lin adaptation_N = variants {} ; --
lin adapter_N = mkN "adattatore" ; -- UWN
lin adaptor_N = mkN "adattatore" ; -- UWN
lin add_V = aggiungere_V ; -- status=guess, src=wikt
lin add_V2 = mkV2 (aggiungere_V) ; -- status=guess, src=wikt
lin add_V3 = L.add_V3 ; -- comment=CHECKED
lin add_VS = mkVS (aggiungere_V) ; -- status=guess, src=wikt
lin add_in_V = advV OP_add_V OP_in_Adv ; -- guess-p-verb
lin add_on_to_V2 = prepV2 OP_add_V OP_on_Prep ; -- guess-p-verb
lin add_up_V = advV OP_add_V OP_up_Adv ; -- guess-p-verb
lin add_up_V2 = prepV2 OP_add_V OP_up_Prep ; -- guess-p-verb
lin add_up_to_V2 = prepV2 (advV OP_add_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin added_A = variants {} ; --
lin addend_N = mkN "addendo" ; -- UWN
lin addendum_N = mkN "addenda" | mkN "appendice" | mkN "supplemento" ; -- UWN
lin addict_N = mkN "dipendente" ; -- status=guess
lin addiction_N = mkN "dipendenza" ; -- status=guess
lin addictive_A = mkA "dipendente" ; -- status=guess
lin addis_ababa_PN = mkPN "Addis Abeba" ; -- status=guess src=geonames
lin addition_N = mkN "addizione" feminine ; -- status=guess
lin additional_A = mkA "addizionale" ; -- status=guess
lin additionally_Adv = adjAdv additional_A ; -- derived -- derived
lin additive_N = mkN "additivo" ; -- status=guess
lin address_N = mkN "discorso" ; -- status=guess
lin address_V2 = mkV2 (mkV "rivolgersi") ; -- status=guess, src=wikt
lin addressee_N = mkN "destinatario" ; -- UWN
lin adducent_A = mkA "adduttore" ; -- UWN
lin adduction_N = mkN "adduzione" ; -- UWN
lin adductor_N = mkN "adduttore" ; -- UWN
lin adelaide_PN = mkPN "Adelaide" ; -- status=guess src=geonames
lin adenine_N = mkN "adenina" ; -- status=guess
lin adenitis_N = mkN "adenite" | mkN "poroadenite" ; -- UWN
lin adenocarcinoma_N = mkN "adenocarcinoma" ; -- UWN
lin adenoma_N = mkN "adenoma" masculine ; -- status=guess
lin adenopathy_N = mkN "adenopatia" ; -- UWN
lin adenosine_N = mkN "adenosina" ; -- status=guess
lin adeptness_N = mkN "abilità" | mkN "destrezza" ; -- UWN
lin adequate_A = mkA "adeguato" ; -- status=guess
lin adhere_V = mkV "aderire" ; -- status=guess, src=wikt
lin adherent_A = mkA "aderente" ; -- status=guess
lin adherent_N = mkN "aderente" masculine ; -- status=guess
lin adhesive_A = mkA "adesivo" ; -- UWN
lin adhesive_N = mkN "adesivo" | mkN "collante" ; -- UWN
lin adhesiveness_N = mkN "aderenza" | mkN "adesione" | mkN "adesività" ; -- UWN
lin adiabatic_A = mkA "adiabatico" ; -- status=guess
lin adiposity_N = mkN "adiposità" | mkN "grassezza" | mkN "pinguedine" ; -- UWN
lin adjacency_N = mkN "adiacenza" ; -- status=guess
lin adjacent_A = mkA "adiacente" ; -- status=guess
lin adjective_A = mkA "aggettivale" ; -- status=guess
lin adjective_N = mkN "aggettivo" ; -- status=guess
lin adjudicate_V = mkV "decidere" | mkV "risolvere" ; -- UWN
lin adjudicative_A = mkA "aggiudicativo" ; -- UWN
lin adjust_V = mkV "regolare" ; -- status=guess, src=wikt
lin adjust_V2 = mkV2 (mkV "regolare") ; -- status=guess, src=wikt
lin adjuster_N = mkN "liquidatore" ; -- UWN
lin adjustment_N = mkN "adattamento" | mkN "inserimento" ; -- status=guess status=guess
lin adjuvant_N = mkN "adiuvante" | mkN "coadiuvante" ; -- UWN
lin administer_V = mkV "amministrare" ; -- status=guess, src=wikt
lin administer_V2 = mkV2 (mkV "amministrare") ; -- status=guess, src=wikt
lin administration_N = mkN "amministrazione" feminine ; -- status=guess
lin administrative_A = mkA "amministrativo" ; -- status=guess
lin administratorFem_N = variants {} ; ---- sense to be split
lin administratorMasc_N = variants {} ; --
lin admiral_N = mkN "ammiraglio" ; -- status=guess
lin admiralty_N = mkN "ammiragliato" ; -- status=guess
lin admiration_N = mkN "ammirazione" feminine ; -- status=guess
lin admire_V2 = mkV2 (mkV "ammirare") ; -- status=guess, src=wikt
lin admirer_N = mkN "adoratore" | mkN "ammiratore" ; -- UWN
lin admissibility_N = mkN "accettabilità" | mkN "ammissibilità" ; -- UWN
lin admission_N = mkN "ammissione" feminine ; -- status=guess
lin admittance_N = mkN "ammettenza" ; -- status=guess
lin admixture_N = mkN "mescolanza" ; -- status=guess
lin admonition_N = mkN "ammonimento" | mkN "ammonizione" | mkN "avvertenza" | mkN "avvertimento" | mkN "avviso" | mkN "discorsetto" | mkN "monito" | mkN "preallarme" ; -- UWN
lin adobe_N = mkN "adobe" ; -- UWN
lin adolescence_N = mkN "adolescenza" ; -- status=guess
lin adolescent_N = mkN "adolescente" | mkN "giovanetto" | mkN "giovinetto" | mkN "pubere" | mkN "teen-ager" | mkN "teen_ager" | mkN "teenager" ; -- UWN
lin adopt_V2 = mkV2 (mkV "adottare") ; -- status=guess, src=wikt
lin adoptable_A = mkA "adottabile" ; -- UWN
lin adoptee_N = mkN "adottato" | mkN "adottata" | mkN "adottati" | mkN "adottate" feminine ; -- status=guess status=guess status=guess status=guess
lin adoption_N = mkN "adozione" feminine ; -- status=guess
lin adoptive_A = mkA "adottivo" ; -- status=guess
lin adorability_N = mkN "adorabilità" ; -- UWN
lin adorable_A = mkA "adorabile" ; -- status=guess
lin adoration_N = mkN "adorazione" feminine ; -- status=guess
lin adore_V2 = mkV2 (mkV "adorare") ; -- status=guess, src=wikt
lin adorer_N = mkN "adoratore" | mkN "ammiratore" ; -- UWN
lin adorn_V2 = mkV2 (mkV "adornare") | mkV2 (mkV "ornare") | mkV2 (mkV "fregiare") | mkV2 (mkV "abbellire") | mkV2 (mkV "contornare") | mkV2 (mkV "decorare") | mkV2 (mkV "imbellettare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin adrenergic_A = mkA "adrenergico" ; -- UWN
lin adrenocortical_A = mkA "corticosurrenale" ; -- UWN
lin adrenocorticotropic_A = mkA "adrenocorticotropo" ; -- status=guess
lin adrenosterone_N = mkN "adrenosterone" ; -- UWN
lin adrian_PN = mkPN "Adrian" ; -- status=guess src=geonames
lin adroit_A = mkA "destro" ; -- UWN
lin adroitness_N = mkN "abilità" | mkN "destrezza" ; -- UWN
lin adsorption_N = mkN "adsorbimento" ; -- UWN
lin adult_A = mkA "adulto" | mkA "adulta" ; -- status=guess status=guess
lin adult_N = mkN "adulto" | mkN "adulta" ; -- status=guess status=guess
lin adulterant_N = mkN "adulterante" ; -- UWN
lin adulterating_A = mkA "adulterante" | mkA "adulteratore" ; -- UWN
lin adulterer_N = mkN "adultero" | mkN "adultera" ; -- status=guess status=guess
lin adultery_N = mkN "adulterio" ; -- status=guess
lin advance_N = mkN "avanzo" ; -- status=guess
lin advance_V = mkV "avanzare" ; -- status=guess, src=wikt
lin advance_V2 = mkV2 (mkV "avanzare") ; -- status=guess, src=wikt
lin advanced_A = variants {} ; --
lin advancement_N = mkN "avanzamento" | mkN "progresso" | mkN "sviluppo" ; -- UWN
lin advantage_N = mkN "vantaggio" ; -- status=guess
lin advection_N = mkN "avvezione" feminine ; -- status=guess
lin advent_N = mkN "avvento" ; -- status=guess
lin adventistFem_N = variants {} ; ---- sense to be split
lin adventistMasc_N = variants {} ; ---- sense to be split
lin adventitious_A = mkA "aleatorio" ; -- status=guess
lin adventure_N = mkN "avventura" ; -- status=guess
lin adventurer_N = mkN "avventuriero" ; -- status=guess
lin adventuresome_A = mkA "avventuroso" ; -- UWN
lin adventurism_N = mkN "avventurismo" ; -- UWN
lin adventurous_A = mkA "avventuroso" ; -- UWN
lin adverb_N = mkN "avverbio" ; -- status=guess
lin adverbial_A = mkA "avverbiale" ; -- status=guess
lin adversary_N = mkN "avversario" | mkN "avversaria" ; -- status=guess status=guess
lin adverse_A = mkA "ostile" ; -- status=guess
lin adversity_N = mkN "avversità" feminine ; -- status=guess
lin advert_N = mkN "pubblicità" feminine ; -- status=guess
lin advert_V = mkV "accennare" | mkV "citare" | mkV "mentovare" | mkV "menzionare" | mkV "nominare" | mkV "ricordare" | mkV "riferirsi" ; -- UWN
lin advertise_V = mkV "pubblicizzare" ; -- status=guess, src=wikt
lin advertise_V2 = mkV2 (mkV "pubblicizzare") ; -- status=guess, src=wikt
lin advertisement_N = mkN "annuncio" | mkN "pubblicità" feminine ; -- status=guess status=guess
lin advertiser_N = mkN "pubblicitario" ; -- UWN
lin advertising_N = variants {} ; --
lin advice_N = mkN "avviso" ; -- status=guess
lin advisable_A = mkA "consigliabile" ; -- status=guess
lin advise_V = mkV "consigliare" | mkV "raccomandare" | mkV "consultarsi" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin advise_V2 = mkV2 (mkV "consigliare") | mkV2 (mkV "raccomandare") | mkV2 (mkV "consultarsi") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin advise_VS = mkVS (mkV "consigliare") | mkVS (mkV "raccomandare") | mkVS (mkV "consultarsi") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin adviserFem_N = mkN "consigliere" | mkN "consulente" ; -- UWN
lin adviserMasc_N = variants {} ; --
lin advisory_A = variants {} ; --
lin advocateFem_N = mkN "avvocato" | mkN "fautore" | mkN "parteggiante" | mkN "parteggiatore" | mkN "patrocinatore" | mkN "promotore" | mkN "propugnatore" | mkN "sostenitore" | mkN "sostentatore" | mkN "zelatore" ; -- UWN
lin advocateMasc_N = variants {} ; --
lin advocate_V2 = variants {} ; --
lin advocate_VS = variants {} ; --
lin adynamia_N = mkN "adinamia" ; -- UWN
lin aegis_N = mkN "égide" ; -- status=guess
lin aeon_N = mkN "eone" ; -- UWN
lin aeration_N = mkN "aerazione" | mkN "aereazione" ; -- UWN
lin aerial_A = mkA "etereo" ; -- status=guess
lin aerial_N = mkN "antenna" ; -- status=guess
lin aeriferous_A = mkA "aerifero" ; -- status=guess
lin aerobatics_N = mkN "acrobazia" | mkN "acrobazie_aeree" ; -- UWN
lin aerobe_N = mkN "aerobio" ; -- UWN
lin aerobic_A = mkA "aerobico" ; -- status=guess
lin aerobiosis_N = mkN "aerobiosi" feminine ; -- status=guess
lin aerodrome_N = mkN "aerodromo" | mkN "aerostazione" ;
lin aerodynamics_N = mkN "aerodinamica" ; -- status=guess
lin aerolite_N = mkN "aerolite" masculine ; -- status=guess
lin aerolitic_A = mkA "aerolitico" ; -- status=guess
lin aerology_N = mkN "aerologia" ; -- UWN
lin aeromechanics_N = mkN "aerodinamica" | mkN "aeromeccanica" ; -- UWN
lin aeronautical_A = mkA "aeronautico" ; -- status=guess
lin aeronautics_N = mkN "aeronautica" ; -- status=guess
lin aerophagia_N = mkN "aerofagia" ; -- UWN
lin aerophilately_N = mkN "aerofilatelia" ; -- UWN
lin aeroplane_N = mkN "aereo" | mkN "aeroplano" | mkN "apparecchio" | mkN "areoplano" ; -- UWN
lin aerosol_N = mkN "aerosol" masculine ; -- status=guess
lin aerospace_N = mkN "aerospazio" ; -- status=guess
lin aestheteFem_N = mkN "esteta" ; -- UWN
lin aestheteMasc_N = mkN "esteta" ; -- UWN
lin aesthetic_A = variants {} ; --
lin aesthetics_N = mkN "estetica" ; -- status=guess
lin aestival_A = mkA "estivo" | mkA "estiva" ; -- status=guess status=guess
lin aether_N = mkN "etere" ; -- UWN
lin aetiology_N = mkN "eziologia" ; -- status=guess
lin afar_Adv = mkAdv "da lontano" ; -- status=guess
lin affability_N = mkN "affabilità" | mkN "affidabilità" | mkN "amabilità" | mkN "bonarietà" | mkN "bonomia" | mkN "gentilezza" | mkN "lenità" | mkN "mitezza" | mkN "soavità" ; -- UWN
lin affair_N = mkN "affare" masculine ; -- status=guess
lin affect_V2 = mkV2 (mkV "fingere") ; -- status=guess, src=wikt
lin affectation_N = mkN "affettazione" | mkN "leziosaggine" | mkN "leziosità" | mkN "ricercatezza" | mkN "sciropposità" | mkN "svenia" | mkN "vezzosità" ; -- UWN
lin affected_A = variants {} ;
lin affectedness_N = mkN "affettazione" | mkN "leziosaggine" | mkN "leziosità" | mkN "ricercatezza" | mkN "sciropposità" | mkN "svenia" | mkN "vezzosità" ; -- UWN
lin affection_N = mkN "affetto" ; -- status=guess
lin affectionate_A = variants {} ;
lin afferent_A = mkA "afferente" ; -- UWN
lin affiliation_N = mkN "affigliazione" | mkN "affiliazione" ; -- UWN
lin affinity_N = variants {} ; --
lin affirmation_N = mkN "affermazione" feminine ; -- status=guess
lin affirmative_N = mkN "frase affermativa" ; -- status=guess
lin affix_N = mkN "confisso" ; -- status=guess
lin afflatus_N = mkN "afflato" ; -- UWN
lin afflict_V2 = mkV2 (mkV "affliggere") ; -- status=guess, src=wikt
lin affliction_N = mkN "afflizione" feminine ; -- status=guess
lin affluence_N = mkN "opulenza" | mkN "ricchezza" ; -- UWN
lin affluent_N = mkN "affluente" | mkN "confluente" | mkN "immissario" | mkN "influente" | mkN "tributario" ; -- UWN
lin afford_V2 = variants {} ; --
lin afford_V2V = variants {} ; --
lin afforestation_N = mkN "imboschimento" ; -- UWN
lin affray_N = mkN "alterco" | mkN "baruffa" | mkN "disputa" | mkN "lite" | mkN "litigio" ; -- UWN
lin affricate_N = mkN "affricata" ; -- status=guess
lin affront_N = mkN "affronto" ; -- status=guess
lin afghanFem_N = variants {} ; ---- sense to be split
lin afghanMasc_N = variants {} ; ---- sense to be split
lin afghanistan_PN = mkPN "Afghanistan" ; -- status=guess src=geonames
lin afghanistaniFem_N = variants {} ; ---- sense to be split
lin afghanistaniMasc_N = variants {} ; ---- sense to be split
lin aforesaid_A = mkA "succitato" | mkA "suddetto" ; -- status=guess status=guess
lin afraid_A = mkA "paura" ; -- status=guess
lin africanFem_N = variants {} ; ---- sense to be split
lin africanMasc_N = variants {} ; ---- sense to be split
lin afrikanerFem_N = variants {} ; ---- sense to be split
lin afrikanerMasc_N = variants {} ; ---- sense to be split
lin afro_americanFem_N = variants {} ; ---- sense to be split
lin afro_americanMasc_N = variants {} ; ---- sense to be split
lin after_Adv = mkAdv "poi" | mkAdv "dopo" ; -- status=guess status=guess
lin after_Prep = S.after_Prep ;
lin after_Subj = mkSubj "dopo" ;
lin afterlife_N = mkN "oltretomba" | mkN "aldilà" | mkN "altro mondo" ; -- status=guess status=guess status=guess
lin aftermath_N = mkN "conseguenze" feminine ; -- status=guess
lin afternoon_N = mkN "pomeriggio" ; -- status=guess
lin aftershock_N = mkN "scossa_di_assestamento" ; -- UWN
lin afterwards_Adv = mkAdv "dopo" ; -- status=guess
lin again_Adv = mkAdv "di nuovo" | mkAdv "ancora" ; -- status=guess status=guess
lin against_Prep = mkPrep "contro" ;
lin agalactia_N = mkN "agalassia" ; -- status=guess
lin agapanthus_N = mkN "agapanto" ; -- UWN
lin agape_N = mkN "agape" ; -- UWN
lin agar_N = mkN "agar-agar" ; -- UWN
lin agaric_N = mkN "agarico" ; -- UWN
lin agate_N = mkN "agata" ; -- status=guess
lin agave_N = mkN "agave" feminine ; -- status=guess
lin age_N = mkN "generazione" feminine ; -- status=guess
lin age_V = variants {} ; --
lin aged_Prep = variants {} ; --
lin ageing_N = mkN "invecchiamento" ; -- UWN
lin ageless_A = mkA "eterno" ; -- UWN
lin agency_N = mkN "agenzia" | mkN "ufficio" ; -- UWN
lin agenda_N = variants {} ; --
lin agentFem_N = variants {} ; ---- sense to be split
lin agentMasc_N = variants {} ; --
lin agent_provocateur_N = mkN "agente_provocatore" ; -- UWN
lin agglutinin_N = mkN "agglutinina" ; -- UWN
lin agglutinogen_N = mkN "agglutinogeno" ; -- status=guess
lin aggravation_N = mkN "aggravamento" | mkN "esasperazione" | mkN "inasprimento" ; -- UWN
lin aggregate_A = variants {} ; --
lin aggregate_N = mkN "aggregato" ; -- status=guess
lin aggregate_V = mkV "aggregare" ; -- status=guess, src=wikt
lin aggregate_V2 = mkV2 (mkV "aggregare") ; -- status=guess, src=wikt
lin aggression_N = mkN "aggressione" feminine ; -- status=guess
lin aggressive_A = mkA "aggressivo" ; -- status=guess
lin aggressiveness_N = mkN "aggressività" feminine ; -- status=guess
lin aggressorFem_N = mkN "istigatore" | mkN "sommovitore" ; -- UWN
lin aggressorMasc_N = mkN "istigatore" | mkN "sommovitore" ; -- UWN
lin aghast_A = mkA "terrorizzato" | mkA "spaventato" | mkA "sgomento" ; -- status=guess status=guess status=guess
lin agility_N = mkN "agilità" | mkN "elasticità" | mkN "scioltezza" | mkN "snellezza" ; -- UWN
lin aging_N = mkN "invecchiamento" ; -- UWN
lin agio_N = mkN "aggio" ; -- UWN
lin agitate_V = mkV "agitare" | scuotere_V | mkV "sbattere" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin agitate_V2 = mkV2 (mkV "agitare") | mkV2 (scuotere_V) | mkV2 (mkV "sbattere") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin agitator_N = mkN "agitatore" | mkN "alimentatore" | mkN "arruffapopoli" | mkN "arruffapopolo" | mkN "causatore" | mkN "eccitatore" | mkN "fomentatore" | mkN "perturbatore" | mkN "provocatore" | mkN "sobillatore" | mkN "sovversivo" ; -- UWN
lin aglet_N = mkN "cordellina" ; -- UWN
lin agnail_N = mkN "pipita" ; -- UWN
lin agnate_N = mkN "agnato" ; -- UWN
lin agnostic_A = mkA "agnostico" ; -- status=guess
lin agnosticism_N = mkN "agnosticismo" ; -- status=guess
lin ago_Adv = mkAdv "fa" ; -- status=guess
lin agon_N = mkN "agone" masculine ; -- status=guess
lin agony_N = mkN "dolore" masculine | mkN "angoscia" ; -- status=guess status=guess
lin agoraphobia_N = mkN "agorafobia" ; -- status=guess
lin agouti_N = mkN "aguti" ; -- status=guess
lin agra_PN = mkPN "Agra" ; -- status=guess src=geonames
lin agree_V = mkV "concordare" ; -- status=guess, src=wikt
lin agree_VS = mkVS (mkV "concordare") ; -- status=guess, src=wikt
lin agree_VV = mkVV (mkV "concordare") ; -- status=guess, src=wikt
lin agree_on_V = advV OP_agree_V OP_on_Adv ; -- guess-p-verb
lin agree_with_V2 = prepV2 OP_agree_V OP_with_Prep ; -- guess-p-verb
lin agreeable_A = mkA "gradevole" ; -- status=guess
lin agreed_A = variants {} ; --
lin agreement_N = mkN "consenso" | mkN "accordo" ; -- status=guess status=guess
lin agribusiness_N = mkN "agricoltura" ; -- UWN
lin agricultural_A = mkA "agricolo" ; -- status=guess
lin agriculture_N = mkN "agricoltura" ; -- status=guess
lin agriculturist_N = mkN "agricoltore" masculine ; -- status=guess
lin agrimonia_N = mkN "agrimonia" ; -- UWN
lin agrology_N = mkN "agrologia" ; -- UWN
lin agronomic_A = mkA "agronomico" ; -- UWN
lin agronomist_N = mkN "agronomo" ; -- UWN
lin agronomy_N = mkN "agronomia" ; -- UWN
lin ague_N = mkN "accento_acuto" ; -- UWN
lin ahead_Adv = mkAdv "avanti" ; -- status=guess
lin ahmedabad_PN = mkPN "Ahmedabad" ; -- status=guess src=geonames
lin aid_N = mkN "aiutante" masculine ; -- status=guess
lin aid_V = mkV "aiutare" ; -- status=guess, src=wikt
lin aid_V2 = mkV2 (mkV "aiutare") ; -- status=guess, src=wikt
lin aids_N = variants {} ; --
lin aigret_N = mkN "aigrette" | mkN "asprì" | mkN "egretta" ; -- UWN
lin aigrette_N = mkN "aigrette" | mkN "asprì" | mkN "egretta" ; -- UWN
lin aikido_N = mkN "aikido" ; -- UWN
lin ailanthus_N = mkN "ailanto" ; -- UWN
lin aileron_N = mkN "alettone" | mkN "alerone" masculine ; -- status=guess status=guess
lin ailment_N = mkN "disturbo" | mkN "indisposizione" feminine | mkN "affezione" feminine | mkN "male" masculine | mkN "malattia" | mkN "acciacco" ; -- status=guess status=guess status=guess status=guess status=guess status=guess
lin aim_N = mkN "fine" | mkN "mira" ; -- UWN
lin aim_V = mkV "puntare" ; -- status=guess, src=wikt
lin aim_V2 = mkV2 (mkV "puntare") ; -- status=guess, src=wikt
lin aim_VV = mkVV (mkV "puntare") ; -- status=guess, src=wikt
lin aim_at_V2 = prepV2 OP_aim_V OP_at_Prep ; -- guess-p-verb
lin air_N = mkN "aeroambulanza" ; -- status=guess
lin air_V = mkV "aerare" ; -- status=guess, src=wikt
lin air_V2 = mkV2 (mkV "aerare") ; -- status=guess, src=wikt
lin air_conditioned_A = mkA "climatizzato" ; -- UWN
lin airborne_A = mkA "trasportato dall'aria" | mkA "aviotrasportato" ; -- status=guess status=guess
lin airbrush_N = mkN "aerografo" ; -- UWN
lin airbus_N = mkN "aerobus" masculine ; -- status=guess
lin aircraft_N = mkN "aeromobile" feminine ; -- status=guess
lin aircrew_N = mkN "equipaggio" ; -- UWN
lin airdock_N = mkN "aerorimessa" | mkN "aviorimessa" | mkN "capannone" | mkN "hangar" ; -- UWN
lin airdrie_PN = mkPN "Airdrie" ; -- status=guess src=geonames
lin airfield_N = mkN "aerodromo" ; -- status=guess
lin airframe_N = mkN "cellula" ; -- UWN
lin airhead_N = mkN "svampita" ; -- status=guess
lin airiness_N = mkN "delicatezza" ; -- UWN
lin airing_N = mkN "aerazione" | mkN "aereazione" | mkN "areazione" ; -- UWN
lin airlift_N = mkN "ponte_aereo" ; -- UWN
lin airline_N = mkN "aerolinea" | mkN "aviolinea" | mkN "compagnia_aerea" | mkN "linea_aerea" ; -- UWN
lin airliner_N = mkN "aeromobile" ; -- UWN
lin airlock_N = mkN "camera_d'equilibrio" ; -- UWN
lin airman_N = mkN "aviere" masculine ; -- status=guess
lin airplane_N = L.airplane_N ; -- comment=CHECKED
lin airport_N = mkN "aeroporto" ;
lin airs_N = mkN "atteggiamento" ; -- UWN
lin airship_N = mkN "aeronave" | mkN "dirigibile" ; -- UWN
lin air_sickness_N = mkN "mal d'aria" ; -- UWN
lin airspace_N = mkN "aerospazio" | mkN "spazio_aereo" ; -- UWN
lin airtight_A = mkA "ermetico" ; -- status=guess
lin airway_N = mkN "aerolinea" | mkN "aviolinea" | mkN "compagnia_aerea" | mkN "linea_aerea" ; -- UWN
lin airworthiness_N = mkN "idoneità_al_volo" ; -- UWN
lin aisle_N = mkN "passaggio" | mkN "passaggio obbligato" ; -- status=guess status=guess
lin aitch_N = mkN "acca" ; -- status=guess
lin akin_A = mkA "consanguineo" ; -- status=guess
lin akinesis_N = mkN "acinesia" ; -- UWN
lin akron_PN = mkPN "Akron" ; -- status=guess src=geonames
lin al_PN = mkPN "al" ; -- status=guess
lin alabaster_A = mkA "alabastrino" ; -- UWN
lin alabaster_N = mkN "alabastro" ; -- status=guess
lin alacrity_N = mkN "alacrità" | mkN "solerzia" ; -- status=guess status=guess
lin alanine_N = mkN "alanina" ; -- status=guess
lin alarm_N = mkN "sveglia" ; -- status=guess
lin alarm_V2 = variants {} ; --
lin alarming_A = mkA "allarmante" | mkA "impressionante" | mkA "inquietante" | mkA "minaccioso" | mkA "preoccupante" | mkA "sconcertante" ; -- UWN
lin alarmism_N = mkN "allarmismo" ; -- UWN
lin alarmist_N = mkN "allarmista" ; -- UWN
lin alas_Interj = mkInterj "ahimè" | mkInterj "purtroppo" ; -- status=guess status=guess
lin alb_N = mkN "camice" masculine ; -- status=guess
lin albacore_N = mkN "Alalunga" | mkN "alalonga" ; -- status=guess status=guess
lin albania_PN = mkPN "Albania" ; -- status=guess src=geonames
lin albatross_N = mkN "albatro" | mkN "albatros" masculine ; -- status=guess status=guess
lin albedo_N = mkN "albedo" feminine ; -- status=guess
lin albeit_Subj = variants {} ; --
lin albert_PN = mkPN "Albert" ; -- status=guess src=geonames
lin albinism_N = mkN "albinismo" ; -- status=guess
lin albino_N = mkN "albino" ; -- status=guess
lin albite_N = mkN "albite" ; -- UWN
lin album_N = variants {} ; --
lin albumen_N = mkN "albume" masculine | mkN "chiara d'uovo" ; -- status=guess status=guess
lin albumin_N = mkN "albumina" ; -- status=guess
lin albuminous_A = mkA "albuminoso" ; -- UWN
lin albuminuria_N = mkN "albuminuria" | mkN "proteinuria" ; -- UWN
lin alchemic_A = mkA "alchimistico" ; -- UWN
lin alchemist_N = mkN "alchimista" masculine ; -- status=guess
lin alchemistic_A = mkA "alchimistico" ; -- UWN
lin alchemy_N = mkN "alchimia" ; -- status=guess
lin alcohol_N = mkN "alcol" masculine ; -- status=guess
lin alcoholic_A = mkA "alcolico" ; -- status=guess
lin alcoholic_N = mkN "alcoldipendente" | mkN "alcolista" ; -- status=guess status=guess
lin alcoholism_N = mkN "alcolismo" ; -- status=guess
lin alcove_N = mkN "alcova" ; -- status=guess
lin aldehyde_N = mkN "aldeide" feminine ; -- status=guess
lin alder_N = mkN "ontano" ; -- status=guess
lin aldershot_PN = mkPN "Aldershot" ; -- status=guess src=geonames
lin aldol_N = mkN "aldolo" ; -- status=guess
lin aldosterone_N = mkN "aldosterone" ; -- status=guess
lin ale_N = mkN "birra inglese" ; -- status=guess
lin alembic_N = mkN "alambicco" ; -- status=guess
lin aleppo_PN = mkPN "Aleppo" ; -- status=guess src=geonames
lin alert_A = mkA "allerta" ; -- status=guess
lin alert_N = mkN "allarme" masculine ; -- status=guess
lin alert_V2 = variants {} ; --
lin alertness_N = mkN "vigilanza" ; -- status=guess
lin alessandria_PN = mkPN "Alessandria" ; -- status=guess src=geonames
lin aleurone_N = mkN "aleurone" ; -- UWN
lin aleuronic_A = mkA "aleuronico" ; -- status=guess
lin alexander_PN = mkPN "Alexander" ; -- status=guess src=geonames
lin alexandra_PN = mkPN "Alexandra" ; -- status=guess src=geonames
lin alexandria_PN = mkPN "Alessandria dEgitto" ; -- status=guess src=geonames
lin alexia_N = mkN "alessia" ; -- UWN
lin alf_PN = mkPN "Alf" ; -- status=guess src=geonames
lin alfalfa_N = mkN "erba medica" ; -- status=guess
lin alfred_PN = mkPN "Alfred" ; -- status=guess src=geonames
lin alfresco_Adv = mkAdv "all'aria_aperta" | mkAdv "fuori" ; -- UWN
lin alfreton_PN = mkPN "Alfreton" ; -- status=guess src=geonames
lin alga_N = mkN "alga" ; -- status=guess
lin algebra_N = mkN "algebra" ; -- status=guess
lin algebraic_A = mkA "algebrico" ; -- UWN
lin algebraical_A = mkA "algebrico" ; -- UWN
lin algebraist_N = mkN "algebrista" ; -- UWN
lin algeria_PN = mkPN "Algeria" ; -- status=guess src=geonames
lin algid_A = mkA "algido" ; -- status=guess
lin algometer_N = mkN "algesimetro" | mkN "algometro" ; -- UWN
lin algometry_N = mkN "algesimetria" | mkN "algometria" ; -- UWN
lin algorithm_N = mkN "algoritmo" ; -- status=guess
lin algorithmic_A = mkA "algoritmico" ; -- UWN
lin alias_N = mkN "pseudonimo" ; -- status=guess
lin alibi_N = mkN "alibi" masculine ; -- status=guess
lin alicante_PN = mkPN "Alicante" ; -- status=guess src=geonames
lin alice_PN = mkPN "Alice" ; -- status=guess src=geonames
lin alienFem_N = variants {} ; ---- sense to be split
lin alienMasc_N = variants {} ; ---- sense to be split
lin alien_A = variants {} ; --
lin alienable_A = mkA "alienabile" | mkA "cedibile" ; -- UWN
lin alienation_N = mkN "alienazione" feminine ; -- status=guess
lin alienist_N = mkN "alienista" | mkN "freniatra" | mkN "neuropsichiatra" | mkN "psichiatra" ; -- UWN
lin alike_A = mkA "simile" ; -- status=guess
lin alike_Adv = variants {} ; --
lin alimony_N = mkN "alimenti" ; -- status=guess
lin aliphatic_A = mkA "alifatico" ; -- status=guess
lin aliquot_A = mkA "aliquota" ; -- status=guess
lin aliquot_N = mkN "aliquota" ; -- status=guess
lin alive_A = mkA "vivo e vegeto" ; -- status=guess
lin alizarin_N = mkN "alizarina" ; -- UWN
lin alkalimetry_N = mkN "alcalimetria" ; -- status=guess
lin alkalinity_N = mkN "alcalinità" | mkN "basicità" ; -- UWN
lin alkaloid_N = mkN "alcaloide" ; -- UWN
lin alkalosis_N = mkN "alcalosi" ; -- UWN
lin alkene_N = mkN "alchene" masculine ; -- status=guess
lin alkyl_N = mkN "alchile" masculine ; -- status=guess
lin alkylic_A = mkA "alchilico" ; -- UWN
lin all_A = mkA "tutto fumo e niente arrosto" ; -- status=guess
lin all_Predet = S.all_Predet ; -- comment=CHECKED
lin allan_PN = mkPN "Allan" ; -- status=guess src=geonames
lin allantois_N = mkN "allantoide" ; -- UWN
lin allegation_N = variants {} ; --
lin allege_V2 = variants {} ; --
lin allege_VS = variants {} ; --
lin alleged_A = variants {} ; --
lin allegiance_N = mkN "fedeltà" feminine | mkN "lealtà" feminine ; -- status=guess status=guess
lin allegory_N = mkN "allegoria" ; -- status=guess
lin allele_N = mkN "allele" masculine ; -- status=guess
lin allelic_A = mkA "allelico" | mkA "allelomorfo" ; -- UWN
lin allen_PN = mkPN "Allen" ; -- status=guess src=geonames
lin allergen_N = mkN "allergene" masculine ; -- status=guess
lin allergist_N = mkN "allergologo" ; -- UWN
lin allergology_N = mkN "allergologia" ; -- UWN
lin allergy_N = mkN "allergia" ; -- UWN
lin alley_N = mkN "vicolo" ; -- status=guess
lin alleyway_N = mkN "budello" | mkN "carruggio" | mkN "carrugio" | mkN "corridoio" | mkN "vicolo" | mkN "viuzza" ; -- UWN
lin alliance_N = variants {} ; --
lin allied_A = variants {} ; --
lin alligator_N = mkN "alligatore" masculine ; -- status=guess
lin alliteration_N = mkN "allitterazione" feminine ; -- status=guess
lin alliterative_A = mkA "allitterativo" ; -- status=guess
lin alloa_PN = mkPN "Alloa" ; -- status=guess src=geonames
lin allocable_A = mkA "assegnabile" ; -- UWN
lin allocate_V = mkV "stanziare" ; -- status=guess, src=wikt
lin allocate_V2 = mkV2 (mkV "stanziare") ; -- status=guess, src=wikt
lin allocation_N = variants {} ; --
lin allochthonous_A = mkA "alloctono" ; -- UWN
lin allogamy_N = mkN "allogamia" ; -- UWN
lin allomorphic_A = mkA "allomorfico" ; -- UWN
lin allopathy_N = mkN "allopatia" ; -- UWN
lin allophone_N = mkN "allofono" ; -- UWN
lin allotment_N = mkN "assegnazione" | mkN "distribuzione" ; -- UWN
lin allotrope_N = mkN "allotropo" ; -- status=guess
lin allotropic_A = mkA "allotropico" ; -- status=guess
lin allotropy_N = mkN "allotropia" ; -- UWN
lin allow_V2 = mkV2 (permettere_V) ; -- status=guess, src=wikt
lin allow_V2V = mkV2V (permettere_V) ; -- status=guess, src=wikt
lin allow_for_V2 = prepV2 (lin V OP_allow_V2) OP_for_Prep ; -- guess-p-verb
lin allow_of_V2 = prepV2 (lin V OP_allow_V2) OP_of_Prep ; -- guess-p-verb
lin allowance_N = variants {} ; --
lin alloy_N = mkN "lega" ; -- status=guess
lin allure_N = mkN "ammaliamento" | mkN "fascino" | mkN "incanto" | mkN "attrazione" feminine ; -- status=guess status=guess status=guess status=guess
lin allusion_N = mkN "allusione" feminine ; -- status=guess
lin allusive_A = mkA "allusivo" ; -- status=guess
lin alluvial_A = mkA "alluvionale" ; -- status=guess
lin alluvion_N = mkN "alluvione" | mkN "detrito_alluvionale" | mkN "materiale_alluvionale" ; -- UWN
lin ally_N = mkN "alleato" | mkN "collegato" ; -- UWN
lin almanac_N = mkN "almanacco" ; -- status=guess
lin almandite_N = mkN "almandino" ; -- UWN
lin almeria_PN = mkPN "Almeria" ; -- status=guess src=geonames
lin almighty_A = mkA "onnipotente" ; -- status=guess
lin almond_N = mkN "latte di mandorla" ; -- status=guess
lin almost_AdA = S.almost_AdA ; -- comment=CHECKED
lin almost_AdN = S.almost_AdN ; -- comment=CHECKED
lin almost_Adv = mkAdv "quasi" ; -- status=guess
lin alms_N = mkN "elemosina" ; -- status=guess
lin alnwick_PN = mkPN "Alnwick" ; -- status=guess src=geonames
lin aloe_N = mkN "aloe" feminine ; -- status=guess
lin aloft_Adv = mkAdv "sopra" ; -- status=guess
lin aloha_N = mkN "camicia hawaiana" ; -- status=guess
lin alone_A = mkA "da solo" | mkA "solo" ; -- status=guess status=guess
lin aloneness_N = mkN "solitudine" ; -- UWN
lin along_Adv = variants {} ; --
lin along_Prep = variants {} ; --
lin alongside_Adv = mkAdv "accanto" ; -- status=guess
lin alongside_Prep = variants {} ; --
lin aloof_A = mkA "distaccato" ; -- status=guess
lin aloof_Adv = mkAdv "con distacco" ; -- status=guess
lin alopecia_N = mkN "alopecia" | mkN "psilosi" ; -- UWN
lin aloud_Adv = mkAdv "a voce alta" | mkAdv "ad alta voce" ; -- status=guess status=guess
lin alp_N = mkN "alpe" ; -- UWN
lin alpaca_N = mkN "alpaca" masculine ; -- status=guess
lin alpenstock_N = mkN "alpenstock" ; -- UWN
lin alpha_N = mkN "alfa" masculine ; -- status=guess
lin alphabet_N = mkN "alfabeto" ; -- status=guess
lin alphabetic_A = mkA "alfabetico" ; -- status=guess
lin alphabetical_A = mkA "alfabetico" ; -- status=guess
lin alphanumeric_A = mkA "alfanumerico" ; -- status=guess
lin alpine_A = mkA "alpestre" | mkA "alpino" ; -- status=guess status=guess
lin alpinist_N = mkN "alpinista" ; -- UWN
lin already_AdV = mkAdV "già" | mkAdV "oramai" ; -- UWN
lin already_Adv = L.already_Adv ;
lin alright_A = variants {} ; --
lin alright_Adv = variants {} ; --
lin alsatianFem_N = variants {} ; ---- sense to be split
lin alsatianMasc_N = variants {} ; ---- sense to be split
lin also_AdV = mkAdV "anche" | mkAdV "per_di_più" | mkAdV "pure" ; -- UWN
lin also_Adv = mkAdv "anche" ;
lin altar_N = mkN "altare" masculine ; -- status=guess
lin altar_piece_N = mkN "dossale" ; -- UWN
lin alter_V = mkV "cambiare" ; -- status=guess, src=wikt
lin alter_V2 = mkV2 (mkV "cambiare") ; -- status=guess, src=wikt
lin alterability_N = mkN "alterabilità" ; -- UWN
lin alteration_N = mkN "alterazione" | mkN "cambiamento" | mkN "miglioria" | mkN "modifica" | mkN "permutamento" ; -- UWN
lin alternate_A = variants {} ;
lin alternation_N = mkN "altalena" | mkN "alternanza" | mkN "alternazione" | mkN "avvicendamento" | mkN "avvicendamento" | mkN "intercambiabilità" | mkN "rotazione" ; -- UWN
lin alternative_A = mkA "alternativo" ; -- status=guess
lin alternative_N = mkN "alternativa" ; -- status=guess
lin althea_N = mkN "altea" | mkN "malvarosa" | mkN "malvone" ; -- UWN
lin although_Subj = S.although_Subj ;
lin altimeter_N = mkN "altimetro" ; -- status=guess
lin altitude_N = mkN "altezza" ; -- status=guess
lin alto_N = mkN "contralto" ; -- status=guess
lin altocumulus_N = mkN "alto_cumulo" | mkN "altocumulo" ; -- UWN
lin altogether_Adv = mkAdv "nel complesso" ; -- status=guess
lin alton_PN = mkPN "Alton" ; -- status=guess src=geonames
lin altostratus_N = mkN "alto_strato" | mkN "altostrato" ; -- UWN
lin altrincham_PN = mkPN "Altrincham" ; -- status=guess src=geonames
lin altruism_N = mkN "altruismo" ; -- status=guess
lin altruist_N = mkN "altruista" | mkN "filantropo" | mkN "umanitario" ; -- UWN
lin altruistic_A = mkA "altruista" | mkA "altruistico" ; -- status=guess status=guess
lin alum_N = mkN "allume" masculine ; -- status=guess
lin alumina_N = mkN "allumina" ; -- UWN
lin aluminate_N = mkN "alluminato" ; -- status=guess
lin aluminiferous_A = mkA "alluminifero" ; -- status=guess
lin aluminium_N = mkN "alluminio" ; -- status=guess
lin aluminous_A = mkA "alluminoso" ; -- status=guess
lin alumnus_N = mkN "diplomato" ; -- UWN
lin alvechurch_PN = mkPN "Alvechurch" ; -- status=guess src=geonames
lin alveolar_A = mkA "alveolare" ; -- status=guess
lin alveolar_N = mkN "dentale" ; -- UWN
lin alveolus_N = mkN "alveolo" ; -- UWN
lin always_AdV = S.always_AdV ; -- comment=CHECKED
lin always_Adv = mkAdv "sempre" ;
lin amah_N = mkN "cameriera" | mkN "domestica" | mkN "donna" | mkN "donna_di_servizio" | mkN "fantesca" ; -- UWN
lin amalgamate_V = mkV "amalgamare" | mkV "amalgamarsi" | mkV "mescolare" | mkV "mescolarsi" | mkV "miscelare" | mkV "mischiare" | mkV "mischiarsi" ; -- UWN
lin amalgamation_N = mkN "fusione" ; -- UWN
lin amanuensis_N = mkN "amanuense" masculine ; -- status=guess
lin amaranth_N = mkN "amaranto" ; -- status=guess
lin amaretto_N = mkN "amaretto" ; -- status=guess
lin amaryllis_N = mkN "amarillide" feminine ; -- status=guess
lin amateurFem_N = mkN "amateur" | mkN "amatore" | mkN "appassionato" | mkN "cultore" | mkN "dilettante" ; -- UWN
lin amateurMasc_N = variants {} ; --
lin amateur_A = variants {} ; --
lin amateurishness_N = mkN "dilettantismo" | mkN "faciloneria" | mkN "pressapochismo" | mkN "pressappochismo" | mkN "superficialità" ; -- UWN
lin amateurism_N = mkN "dilettantismo" ; -- UWN
lin amazing_A = mkA "meraviglioso" | mkA "sorprendente" | mkA "sbalorditivo" ; -- status=guess status=guess status=guess
lin ambassador_N = mkN "ambasciatore" masculine ; -- status=guess
lin ambassadress_N = mkN "ambasciatrice" feminine ; -- status=guess
lin amber_A = mkA "ambrato" ; -- status=guess
lin amber_N = mkN "ambra" ; -- status=guess
lin ambergris_N = mkN "ambra grigia" ; -- status=guess
lin amberjack_N = mkN "Seriola" ; -- status=guess
lin ambidexterity_N = mkN "ambidestrismo" ; -- UWN
lin ambidextrous_A = mkA "ambidestro" ; -- status=guess
lin ambient_A = mkA "ambientale" ; -- status=guess
lin ambiguity_N = mkN "ambiguità" | mkN "bivalenza" | mkN "equivocità" | mkN "loschezza" | mkN "tortuosità" ; -- UWN
lin ambiguous_A = mkA "ambiguo" ; -- status=guess
lin ambition_N = mkN "ambizione" feminine ; -- status=guess
lin ambitious_A = mkA "ambizioso" ; -- status=guess
lin ambivalence_N = mkN "ambivalenza" ; -- UWN
lin ambivalent_A = mkA "ambivalente" ; -- status=guess
lin amble_N = mkN "passeggiare" | mkN "deambulare" ; -- status=guess status=guess
lin ambrosia_N = mkN "ambrosia" ; -- status=guess
lin ambulacral_A = mkA "ambulacrale" ; -- UWN
lin ambulacrum_N = mkN "ambulacro" ; -- UWN
lin ambulance_N = mkN "ambulanza" ; -- status=guess
lin ambulatory_N = mkN "deambulatorio" | mkN "ambulacro" ; -- status=guess status=guess
lin ambuscade_N = mkN "agguato" | mkN "appostamento" | mkN "imboscata" ; -- UWN
lin ambush_N = mkN "imboscata" ; -- status=guess
lin amebiasis_N = mkN "amebiasi" ; -- UWN
lin ameboid_A = mkA "ameboide" ; -- UWN
lin ameer_N = mkN "emiro" ; -- UWN
lin amelia_N = mkN "amelia" ; -- UWN
lin ameliorate_V = mkV "migliorare" ; -- status=guess, src=wikt
lin ameliorate_V2 = mkV2 (mkV "migliorare") ; -- status=guess, src=wikt
lin amelioration_N = mkN "miglioramento" ; -- UWN
lin amend_V = mkV "emendare" ; -- status=guess, src=wikt
lin amend_V2 = mkV2 (mkV "emendare") ; -- status=guess, src=wikt
lin amend_V2V = mkV2V (mkV "emendare") ; -- status=guess, src=wikt
lin amendment_N = variants {} ; --
lin amenity_N = mkN "amenità" feminine ; -- status=guess
lin amenorrhea_N = mkN "amenorrea" ; -- UWN
lin americanFem_N = variants {} ; ---- sense to be split
lin americanMasc_N = variants {} ; ---- sense to be split
lin americium_N = mkN "americio" ; -- status=guess
lin amesbury_PN = mkPN "Amesbury" ; -- status=guess src=geonames
lin amethyst_N = mkN "ametista" ; -- status=guess
lin ametropia_N = mkN "ametropia" ; -- UWN
lin amiability_N = mkN "affabilità" | mkN "affidabilità" | mkN "amabilità" | mkN "bonarietà" | mkN "bonomia" | mkN "gentilezza" | mkN "lenità" | mkN "mitezza" | mkN "soavità" ; -- UWN
lin amiable_A = mkA "amabile" | mkA "affabile" ; -- status=guess status=guess
lin amid_Prep = variants {} ; --
lin amide_N = mkN "ammide" feminine ; -- status=guess
lin amiens_PN = mkPN "Amiens" ; -- status=guess src=geonames
lin amine_N = mkN "ammina" ; -- status=guess
lin amino_N = mkN "amminoacido" ; -- status=guess
lin amir_N = mkN "emiro" ; -- UWN
lin amity_N = mkN "cordialità" ; -- UWN
lin ammanford_PN = mkPN "Ammanford" ; -- status=guess src=geonames
lin ammeter_N = mkN "amperometro" ; -- status=guess
lin ammonia_N = mkN "ammoniaca" ; -- status=guess
lin ammoniac_A = mkA "ammoniacale" ; -- UWN
lin ammonium_N = mkN "ammonio" ; -- status=guess
lin ammunition_N = mkN "munizioni" ; -- status=guess
lin amnesia_N = mkN "amnesia" ; -- UWN
lin amnesic_A = mkA "amnesico" ; -- UWN
lin amnestic_A = mkA "amnesico" ; -- UWN
lin amnesty_N = mkN "amnistia" ; -- status=guess
lin amniocentesis_N = mkN "amniocentesi" ; -- UWN
lin amnion_N = mkN "amnio" ; -- status=guess
lin amniotic_A = mkA "amniotico" ; -- status=guess
lin amoeba_N = mkN "amoeba" | mkN "ameba" ; -- UWN
lin amoebic_A = mkA "amebico" ; -- status=guess
lin among_Prep = variants {} ; --
lin amongst_Prep = variants {} ; --
lin amoralism_N = mkN "amoralismo" ; -- UWN
lin amorous_A = mkA "amoroso" | mkA "amorosa" ; -- status=guess status=guess
lin amorousness_N = mkN "impulso_sessuale" ; -- UWN
lin amorphous_A = mkA "amorfo" ; -- status=guess
lin amount_N = mkN "quantità" feminine ; -- status=guess
lin amount_V = mkV "ammontare" ; -- status=guess, src=wikt
lin amour_N = mkN "amorazzo" | mkN "intimità" | mkN "love_story" | mkN "relazione" ; -- UWN
lin amp_N = variants {} ; --
lin amperage_N = mkN "amperaggio" ; -- UWN
lin ampere_N = mkN "ampere" masculine ; -- status=guess
lin ampersand_N = mkN "e commerciale" | mkN "ampersand" ; -- status=guess status=guess
lin amphetamine_N = mkN "anfetamina" ; -- status=guess
lin amphibian_N = mkN "anfibio" ; -- status=guess
lin amphibiotic_A = mkA "anfibiotico" ; -- status=guess
lin amphibious_A = mkA "anfibio" | mkA "anfibia" ; -- status=guess status=guess
lin amphibology_N = mkN "anfibologia" ; -- UWN
lin amphibrach_N = mkN "anfibraco" ; -- UWN
lin amphipod_N = mkN "anfipodo" | mkN "pulce_di_mare" ; -- UWN
lin amphitheatre_N = mkN "anfiteatro" ; -- status=guess
lin amphora_N = mkN "anfora" ; -- UWN
lin amphoric_A = mkA "anforico" ; -- UWN
lin amphoteric_A = mkA "anfotero" ; -- status=guess
lin amphotericin_N = mkN "amfotericina" ; -- status=guess
lin ample_A = mkA "abbondante" ; -- status=guess
lin amplification_N = mkN "amplificazione" ; -- UWN
lin amplifier_N = mkN "amplificatore" masculine ; -- status=guess
lin amplify_V2 = mkV2 (mkV "amplificare") ; -- status=guess, src=wikt
lin amplitude_N = mkN "modulazione di ampiezza" ; -- status=guess
lin ampoule_N = mkN "boccetta" | mkN "fiala" ; -- UWN
lin ampulla_N = mkN "ampolla" | mkN "ampollina" ; -- UWN
lin amputation_N = mkN "amputazione" feminine ; -- status=guess
lin amsterdam_PN = mkPN "Amsterdam" ; -- status=guess src=geonames
lin amulet_N = mkN "amuleto" | mkN "filacterio" | mkN "filatterio" | mkN "scacciaguai" | mkN "talismano" ; -- UWN
lin amuse_V2 = variants {} ; --
lin amusement_N = mkN "intrattenimento" | mkN "festeggiamento" ; -- status=guess status=guess
lin amusing_A = mkA "divertente" | mkA "esilarante" | mkA "ilare" ; -- status=guess status=guess status=guess
lin amygdala_N = mkN "amigdala" ; -- UWN
lin amyl_N = mkN "amile" masculine ; -- status=guess
lin amylase_N = mkN "amilasi" ; -- status=guess
lin anabatic_A = mkA "anabatico" ; -- UWN
lin anabiosis_N = mkN "anabiosi" feminine ; -- status=guess
lin anabolism_N = mkN "anabolismo" ; -- status=guess
lin anachronistic_A = mkA "anacronistico" ; -- status=guess
lin anachronistically_Adv = mkAdv "anacronisticamente" ; -- status=guess
lin anacoluthia_N = mkN "anacoluto" ; -- status=guess
lin anaconda_N = mkN "anaconda" ; -- status=guess
lin anadromous_A = mkA "anadromo" ; -- status=guess
lin anaerobe_N = mkN "anaerobio" | mkN "anerobio" ; -- UWN
lin anaesthesia_N = mkN "anestesia" ; -- UWN
lin anaesthetic_N = mkN "anestetico" ; -- UWN
lin anaesthetist_N = mkN "anestesiologo" | mkN "anestesista" ; -- UWN
lin anaglyphic_A = mkA "anagliptico" | mkA "anaglittico" ; -- UWN
lin anagoge_N = mkN "anagogia" ; -- UWN
lin anagogic_A = mkA "anagogico" ; -- UWN
lin anagram_N = mkN "anagramma" masculine ; -- status=guess
lin anagrammatic_A = mkA "anagrammatico" ; -- UWN
lin anal_A = mkA "anale" ; -- status=guess
lin analgesia_N = mkN "analgesia" ; -- status=guess
lin analgesic_A = mkA "analgesico" ; -- status=guess
lin analgesic_N = mkN "analgesico" ; -- status=guess
lin analogical_A = mkA "analogico" ; -- status=guess
lin analogue_A = mkA "analogico" ; -- UWN
lin analogy_N = mkN "analogia" ; -- status=guess
lin analyze_V2 = variants {} ; --
lin analysis_N = mkN "analisi" feminine ; -- status=guess
lin analyst_N = mkN "analista" ; -- status=guess
lin analytic_A = mkA "analitico" ; -- status=guess
lin analyzer_N = mkN "analizzatore" ; -- UWN
lin anapaest_N = mkN "anapesto" ; -- UWN
lin anapest_N = mkN "anapesto" ; -- UWN
lin anaphora_N = mkN "anafora" ; -- status=guess
lin anaphylactic_A = mkA "anafilattico" ; -- UWN
lin anaphylaxis_N = mkN "anafilassi" ; -- UWN
lin anaplasmosis_N = mkN "anaplasmosi" ; -- UWN
lin anapsid_N = mkN "anapsido" ; -- status=guess
lin anarchism_N = mkN "anarchismo" ; -- status=guess
lin anarchistFem_N = mkN "anarchico" | mkN "nichilista" | mkN "nihilista" ; -- UWN
lin anarchistMasc_N = mkN "anarchico" | mkN "nichilista" | mkN "nihilista" ; -- UWN
lin anarchistic_A = mkA "anarchico" ; -- UWN
lin anarchy_N = mkN "anarchia" ; -- status=guess
lin anasarca_N = mkN "anasarca" | mkN "idropisia" ; -- UWN
lin anastomosis_N = mkN "anastomosi" feminine ; -- status=guess
lin anastylosis_N = mkN "anastylosi" feminine ; -- status=guess
lin anathema_N = mkN "anatema" | mkN "scomunica" ; -- UWN
lin anatomical_A = mkA "anatomico" ; -- status=guess
lin anatomist_N = mkN "anatomico" | mkN "anatomista" | mkN "notomista" ; -- UWN
lin anatomy_N = mkN "anatomia" ; -- status=guess
lin ancestor_N = mkN "ascendente" | mkN "antenato" ; -- status=guess status=guess
lin ancestral_A = mkA "ancestrale" ; -- status=guess
lin ancestress_N = mkN "ava" ; -- UWN
lin anchor_N = mkN "ancora" ; -- status=guess
lin anchor_V = mkV "ancorare" ; -- status=guess, src=wikt
lin anchor_V2 = mkV2 (mkV "ancorare") ; -- status=guess, src=wikt
lin anchorite_N = mkN "anacoreta" | mkN "contemplativo" | mkN "eremita" | mkN "romito" ; -- UWN
lin anchorman_N = mkN "anchorman" masculine ; -- status=guess
lin anchovy_N = mkN "alice" | mkN "acciuga" ; -- status=guess status=guess
lin ancient_A = mkA "antico" ; -- status=guess
lin ancientness_N = mkN "antichità" | mkN "arcaicità" | mkN "vetustà" ; -- UWN
lin ancillary_A = mkA "subordinato" | mkA "secondario" | mkA "ausiliare" ; -- status=guess status=guess status=guess
lin ancona_PN = mkPN "Ancona" ; -- status=guess src=geonames
lin and_Conj = S.and_Conj ;
lin andiron_N = mkN "alare" ; -- UWN
lin andorra_PN = mkPN "Andorra" ; -- status=guess src=geonames
lin andover_PN = mkPN "Andover" ; -- status=guess src=geonames
lin androgen_N = mkN "androgeno" ; -- UWN
lin androgenic_A = mkA "androgenico" ; -- status=guess
lin androgynous_A = mkA "androgino" ; -- status=guess
lin androgyny_N = mkN "androginia" | mkN "bisessualità" | mkN "ermafrodismo" | mkN "ermafroditismo" | mkN "monoicismo" ; -- UWN
lin android_N = mkN "androide" masculine ; -- status=guess
lin androphobia_N = mkN "androfobia" ; -- UWN
lin androsterone_N = mkN "androsterone" masculine ; -- status=guess
lin anecdote_N = mkN "aneddoto" ; -- status=guess
lin anecdotist_N = mkN "aneddotista" ; -- UWN
lin anechoic_A = mkA "anecoico" ; -- status=guess
lin anemographic_A = mkA "anemografico" ; -- UWN
lin anemography_N = mkN "anemografia" ; -- UWN
lin anemometer_N = mkN "anemometro" ; -- status=guess
lin anemometry_N = mkN "anemometria" ; -- status=guess
lin anemone_N = mkN "anemone" masculine ; -- status=guess
lin anemophilous_A = mkA "anemofilo" ; -- UWN
lin aneroid_A = mkA "aneroide" ; -- UWN
lin anesthesia_N = mkN "anestesia" ; -- UWN
lin anesthesiologist_N = mkN "anestesiologo" | mkN "anestesista" ; -- UWN
lin anesthetic_N = mkN "anestetico" ; -- UWN
lin anesthetist_N = mkN "anestesiologo" | mkN "anestesista" ; -- UWN
lin anestrus_N = mkN "anestro" ; -- status=guess
lin aneurysm_N = mkN "aneurisma" masculine ; -- status=guess
lin aneurysmal_A = mkA "aneurismatico" ; -- UWN
lin anew_Adv = mkAdv "di nuovo" ; -- status=guess
lin angel_N = mkN "angelo" ; -- status=guess
lin angelic_A = mkA "angelico" ; -- status=guess
lin angelica_N = mkN "angelica" ; -- status=guess
lin anger_N = mkN "ira" | mkN "rabbia" | mkN "collera" ; -- status=guess status=guess status=guess
lin anger_V2 = variants {} ; --
lin angers_PN = mkPN "Angers" ; -- status=guess src=geonames
lin angina_N = mkN "angina_pectoris" | mkN "stenocardia" ; -- UWN
lin angiogram_N = mkN "angiogramma" masculine ; -- status=guess
lin angiography_N = mkN "angiografia" ; -- UWN
lin angiologist_N = mkN "angiologo" ; -- UWN
lin angiology_N = mkN "angiologia" ; -- status=guess
lin angioma_N = mkN "angioma" ; -- UWN
lin angiopathy_N = mkN "angiopatia" ; -- status=guess
lin angiosperm_N = mkN "angiosperma" ; -- status=guess
lin angiotensin_N = mkN "angiotensina" ; -- status=guess
lin angle_N = mkN "angolo" ; -- status=guess
lin angling_N = mkN "pesca con la lenza" ; -- status=guess
lin anglophilFem_N = mkN "anglofilo" ; -- UWN
lin anglophilMasc_N = mkN "anglofilo" ; -- UWN
lin anglophileFem_N = mkN "anglofilo" ; -- UWN
lin anglophileMasc_N = mkN "anglofilo" ; -- UWN
lin anglophobe_N = mkN "anglofobo" ; -- UWN
lin angola_PN = mkPN "Angola" ; -- status=guess src=geonames
lin angostura_N = mkN "angostura" | mkN "angustura" ; -- UWN
lin angry_A = mkA "arrabbiato" ; -- status=guess
lin angst_N = mkN "paturnie" feminine ; -- status=guess
lin anguilla_PN = mkPN "Anguilla" ; -- status=guess src=geonames
lin anguish_N = mkN "angoscia" | mkN "agonia" | mkN "calvario" | mkN "croce" feminine | mkN "ambascia" ; -- status=guess status=guess status=guess status=guess status=guess
lin anguished_A = mkA "angosciato" ; -- UWN
lin angularity_N = mkN "angolarità" | mkN "angolosità" | mkN "spigolosità" feminine ; -- status=guess status=guess status=guess
lin angus_PN = mkPN "Angus" ; -- status=guess src=geonames
lin anhydride_N = mkN "anidride" ; -- UWN
lin anhydrous_A = mkA "anidro" ; -- status=guess
lin aniline_N = mkN "anilina" ; -- status=guess
lin animadversion_N = mkN "animavversione" ; -- status=guess
lin animal_N = L.animal_N ;
lin animality_N = mkN "animalità" ; -- UWN
lin animalization_N = mkN "abbrutimento" | mkN "imbrutimento" ; -- UWN
lin animatedly_A = variants {} ;
lin animatedly_Adv = mkAdv "animatamente" | adjAdv animatedly_A ; -- status=guess -- derived
lin anime_N = mkN "anime" ; -- status=guess
lin animism_N = mkN "animismo" ; -- UWN
lin animist_A = mkA "animistico" ; -- UWN
lin animosity_N = mkN "animosità" ; -- UWN
lin animus_N = mkN "animosità" ; -- UWN
lin anion_N = mkN "anione" masculine ; -- status=guess
lin anionic_A = mkA "anionico" ; -- status=guess
lin anise_N = mkN "anice" masculine | mkN "anace" masculine ; -- status=guess status=guess
lin aniseed_N = mkN "anice" masculine ; -- status=guess
lin anisette_N = mkN "anace" | mkN "anice" | mkN "anisetta" | mkN "mistrà" ; -- UWN
lin anisotropic_A = mkA "anisotropo" ; -- UWN
lin anisotropy_N = mkN "anisotropia" ; -- status=guess
lin ankara_PN = mkPN "Ankara" ; -- status=guess src=geonames
lin ankle_N = mkN "caviglia" ; -- status=guess
lin anklebone_N = mkN "astragalo" ; -- UWN
lin anklet_N = mkN "cavigliera" ; -- status=guess
lin ankylosis_N = mkN "anchilosi" ; -- UWN
lin ankylotic_A = mkA "anchilosante" ; -- UWN
lin anna_N = mkN "anna" | mkN "anna_pakistana" ; -- UWN
lin annalist_N = mkN "annalista" ; -- UWN
lin annalistic_A = mkA "annalistico" ; -- UWN
lin annan_PN = mkPN "Annan" ; -- status=guess src=geonames
lin annelid_N = mkN "anellide" masculine ; -- status=guess
lin annex_N = mkN "annesso" | mkN "braccio" ; -- UWN
lin annexation_N = mkN "annessione" feminine ; -- status=guess
lin annexe_N = mkN "annesso" | mkN "braccio" ; -- UWN
lin annihilation_N = mkN "annientamento" | mkN "annichilazione" feminine | mkN "annichilimento" ; -- status=guess status=guess status=guess
lin anniversary_N = mkN "anniversario" ; -- status=guess
lin annotate_V2 = mkV2 (mkV "annotare") | mkV2 (mkV "commentare") ; -- status=guess, src=wikt status=guess, src=wikt
lin annotation_N = mkN "annotazione" | mkN "notazione" ; -- UWN
lin announce_V2 = variants {} ; --
lin announce_VS = variants {} ; --
lin announcement_N = mkN "annuncio" ; -- status=guess
lin annoy_V2 = mkV2 (mkV "infastidirsi") | mkV2 (mkV "infastidire") | mkV2 (mkV "importunare") | mkV2 (mkV "disturbare") | mkV2 (mkV "irritare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin annoyance_N = mkN "seccatura" | mkN "scocciatura" | mkN "fastidio" ; -- status=guess status=guess status=guess
lin annoying_A = mkA "fastidioso" | mkA "irritante" | mkA "seccante" ; -- UWN
lin annual_A = mkA "annuale" ; -- status=guess
lin annual_N = mkN "annuario" ; -- UWN
lin annuity_N = mkN "annualità" ; -- status=guess
lin annul_V2 = mkV2 (mkV "annullare") ; -- status=guess, src=wikt
lin annulet_N = mkN "anellino" ; -- UWN
lin annulment_N = mkN "abrogazione" | mkN "annullamento" | mkN "cancellazione" | mkN "cassazione" ; -- UWN
lin annulus_N = mkN "anello" ; -- status=guess
lin annunciation_N = mkN "annunciazione" feminine ; -- status=guess
lin anode_N = mkN "anodo" ; -- status=guess
lin anoint_V2 = mkV2 (mkV "ungere") ; -- status=guess, src=wikt
lin anomaly_N = mkN "anomalia" ; -- status=guess
lin anonymity_N = mkN "anonimato" | mkN "anonimia" | mkN "anonimo" ; -- UWN
lin anonymous_A = mkA "anonimo" ; -- status=guess
lin anorak_N = mkN "giacca a vento" ; -- status=guess
lin anorectal_A = mkA "anorettale" ; -- UWN
lin anorexia_N = mkN "anoressia" ; -- status=guess
lin anosmia_N = mkN "anosmia" ; -- status=guess
lin anosmic_A = mkA "anosmico" ; -- status=guess
lin another_Det = mkDet "un altro" "un'altra" singular ;
lin anoxia_N = mkN "anossia" | mkN "ipossia" ; -- UWN
lin anshan_PN = mkPN "Anshan" ; -- status=guess src=geonames
lin answer_N = mkN "risposta" ; -- status=guess
lin answer_V = mkV "ribattere" ; -- status=guess, src=wikt
lin answer_V2 = mkV2 (mkV "ribattere") ; -- status=guess, src=wikt
lin answer_V2S = L.answer_V2S ; -- comment=CHECKED
lin answer_back_V2 = mkV2 (advV OP_answer_V OP_back_Adv ) ; -- guess-p-verb
lin answer_for_V2 = prepV2 OP_answer_V OP_for_Prep ; -- guess-p-verb
lin ant_N = mkN "formica" ; -- status=guess
lin antacid_N = mkN "antiacido" ; -- status=guess
lin ant_eater_N = mkN "formichiere" masculine ; -- status=guess
lin antebellum_A = mkA "anteguerra" ; -- status=guess
lin antecedence_N = mkN "antecedenza" | mkN "anteriorità" | mkN "precedenza" | mkN "priorità" ; -- UWN
lin antecedent_A = mkA "antecedente" ; -- status=guess
lin antecedent_N = mkN "antenato" | mkN "progenitore" masculine ; -- status=guess status=guess
lin antechamber_N = mkN "anticamera" ; -- status=guess
lin antediluvian_A = mkA "antidiluviano" | mkA "antediluviano" ; -- status=guess status=guess
lin antefix_N = mkN "antefissa" ; -- UWN
lin antelope_N = mkN "antilope" ; -- UWN
lin antenatal_A = mkA "prenatale" ; -- UWN
lin antenna_N = mkN "antenna" ; -- status=guess
lin anterior_A = mkA "anteriore" ; -- status=guess
lin anteroom_N = mkN "androne" | mkN "anticamera" | mkN "atrio" | mkN "entrata" | mkN "foyer" | mkN "hall" | mkN "ingresso" | mkN "ridotto" | mkN "vestibolo" ; -- UWN
lin anthem_N = mkN "inno" ; -- status=guess
lin anther_N = mkN "antera" ; -- UWN
lin ant_hill_N = mkN "formicaio" ; -- status=guess
lin anthologist_N = mkN "antologista" ; -- UWN
lin anthology_N = mkN "antologia" | mkN "crestomazia" | mkN "fiore" | mkN "florilegio" | mkN "poliantea" | mkN "silloge" | mkN "spicilegio" ; -- UWN
lin anthony_PN = mkPN "Anthony" ; -- status=guess src=geonames
lin anthracite_N = mkN "antracite" ; -- UWN
lin anthracitic_A = mkA "antracitico" ; -- UWN
lin anthracosis_N = mkN "antracosi" ; -- UWN
lin anthrax_N = mkN "antrace" ; -- status=guess
lin anthropic_A = mkA "antropico" ; -- UWN
lin anthropocentric_A = mkA "antropocentrico" ; -- status=guess
lin anthropogenesis_N = mkN "antropogenesi" feminine ; -- status=guess
lin anthropological_A = mkA "antropologico" ; -- UWN
lin anthropologistFem_N = mkN "antropologo" ; -- UWN
lin anthropologistMasc_N = mkN "antropologo" ; -- UWN
lin anthropology_N = mkN "antropologia" ; -- status=guess
lin anthropometric_A = mkA "antropometrico" | mkA "somatometrico" ; -- UWN
lin anthropometry_N = mkN "antropometria" | mkN "somatometria" ; -- UWN
lin anthropomorphism_N = mkN "antropomorfismo" ; -- status=guess
lin anthropophagous_A = mkA "antropofago" ; -- status=guess
lin anthropophagy_N = mkN "antropofagia" | mkN "cannibalismo" ; -- status=guess status=guess
lin anthurium_N = mkN "anturio" ; -- UWN
lin anti_A = mkA "antisemita" | mkA "antisemitico" ; -- status=guess status=guess
lin anti_N = mkN "antiamericanismo" ; -- status=guess
lin anti_aircraft_A = mkA "antiaereo" ; -- UWN
lin anti_aircraft_N = mkN "arma_antiaerea" ; -- UWN
lin antibacterial_A = mkA "antibatterico" ; -- status=guess
lin antibacterial_N = mkN "antibatterico" ; -- status=guess
lin antibiotic_A = mkA "antibiotico" ; -- status=guess
lin antibiotic_N = mkN "antibiotico" ; -- status=guess
lin antibody_N = mkN "anticorpo" ; -- status=guess
lin anticipate_V = mkV "anticipare" ; -- status=guess, src=wikt
lin anticipate_V2 = mkV2 (mkV "anticipare") ; -- status=guess, src=wikt
lin anticipate_VS = mkVS (mkV "anticipare") ; -- status=guess, src=wikt
lin anticipate_VV = mkVV (mkV "anticipare") ; -- status=guess, src=wikt
lin anticipation_N = mkN "anticipazione" feminine ; -- status=guess
lin anticlockwise_Adv = mkAdv "in senso antiorario" ; -- status=guess
lin anticoagulant_N = mkN "anticoagulante" ; -- UWN
lin anticyclone_N = mkN "anticiclone" ; -- status=guess
lin antidepressant_N = mkN "antidepressivo" ; -- status=guess
lin antidote_N = mkN "antidoto" ; -- status=guess
lin antidromic_A = mkA "antidromico" ; -- status=guess
lin antiferromagnetic_A = mkA "antiferromagnetico" ; -- status=guess
lin antiferromagnetism_N = mkN "antiferromagnetismo" ; -- status=guess
lin antifreeze_N = mkN "anticongelante" | mkN "antigelo" ; -- UWN
lin antifungal_N = mkN "anticrittogamico" | mkN "antiparassitario" | mkN "fungicida" ; -- UWN
lin antigen_N = mkN "antigene" ; -- status=guess
lin antigua_PN = mkPN "Antigua" ; -- status=guess src=geonames
lin anti_hero_N = mkN "antieroe" masculine ; -- status=guess
lin antihistamine_N = mkN "antistaminico" ; -- UWN
lin antimacassar_N = mkN "coprischienale" ; -- UWN
lin antimagnetic_A = mkA "antimagnetico" ; -- UWN
lin antimonial_A = mkA "antimoniale" ; -- UWN
lin antimony_N = mkN "antimonio" ; -- status=guess
lin antineutrino_N = mkN "antineutrino" ; -- UWN
lin antineutron_N = mkN "antineutrone" masculine ; -- status=guess
lin antinomian_A = mkA "antinomistico" ; -- UWN
lin antinomian_N = mkN "antinomista" ; -- UWN
lin antioxidant_N = mkN "antiossidante" masculine ; -- status=guess
lin antiparticle_N = mkN "antiparticella" ; -- status=guess
lin antipasto_N = mkN "antipasto" ; -- status=guess
lin antiphlogistic_A = mkA "antiflogistico" ; -- status=guess
lin antiphon_N = mkN "antifona" ; -- UWN
lin antiphonary_N = mkN "antifonale" | mkN "antifonario" ; -- UWN
lin antiphony_N = mkN "antifonia" ; -- status=guess
lin antiphrasis_N = mkN "antifrasi" ; -- UWN
lin antiproton_N = mkN "antiprotone" masculine ; -- status=guess
lin antipyretic_A = mkA "antifebbrile" | mkA "antipiretico" | mkA "febbrifugo" ; -- UWN
lin antipyretic_N = mkN "antipiretico" | mkN "febbrifugo" ; -- UWN
lin antiquark_N = mkN "antiquark" masculine ; -- status=guess
lin antique_A = mkA "antico" ; -- status=guess
lin antique_N = mkN "oggetto_antico" | mkN "pezzo_d'antiquariato" ; -- UWN
lin antiquity_N = mkN "antichità" feminine ; -- status=guess
lin antiseptic_N = mkN "antisettico" ; -- UWN
lin antisocial_A = mkA "asociale" ; -- status=guess
lin antispasmodic_N = mkN "antispastico" ; -- UWN
lin antistrophe_N = mkN "antistrofa" | mkN "antistrofe" ; -- UWN
lin antitoxin_N = mkN "antitossina" ; -- UWN
lin antitrade_N = mkN "antialiseo" | mkN "contraliseo" | mkN "controaliseo" ; -- UWN
lin antiviral_A = mkA "antivirale" ; -- status=guess
lin antler_N = mkN "corno" | mkN "corna" | mkN "corno ramificato" | mkN "palco" ; -- status=guess status=guess status=guess status=guess
lin antony_PN = mkPN "Antony" ; -- status=guess src=geonames
lin antonym_N = mkN "antonimo" ; -- status=guess
lin antrim_PN = mkPN "Antrim" ; -- status=guess src=geonames
lin antrum_N = mkN "antro" ; -- UWN
lin antwerp_PN = mkPN "Antwerp" ; -- status=guess src=geonames
lin anuretic_A = mkA "anurico" ; -- UWN
lin anus_N = mkN "ano" ; -- status=guess
lin anvil_N = mkN "incudine" feminine ; -- status=guess
lin anxiety_N = mkN "ansia" | mkN "ansietà" feminine ; -- status=guess status=guess
lin anxiolytic_A = mkA "ansiolitico" | mkA "neurolettico" | mkA "neuroplegico" | mkA "tranquillante" ; -- UWN
lin anxious_A = mkA "preoccupante" ; -- status=guess
lin any_Adv = mkAdv "affatto" ; -- status=guess
lin anybody_NP = variants {} ; --
lin anyone_NP = variants {} ; --
lin anything_NP = variants {} ; --
lin anyway_Adv = mkAdv "comunque" | mkAdv "in ogni modo" ; -- status=guess status=guess
lin anywhere_Adv = mkAdv "dovunque" ; -- status=guess
lin aorist_N = mkN "aoristo" ; -- UWN
lin aorta_N = mkN "aorta" ; -- status=guess
lin aortal_A = mkA "aortico" ; -- status=guess
lin apace_Adv = mkAdv "celermente" | mkAdv "lestamente" | mkAdv "lesto" | mkAdv "presto" | mkAdv "prontamente" | mkAdv "rapidamente" | mkAdv "ratto" | mkAdv "sollecitamente" | mkAdv "speditamente" | mkAdv "spedito" | mkAdv "sveltamente" | mkAdv "veloce" | mkAdv "velocemente" ; -- UWN
lin apart_Adv = variants {} ; --
lin apartheid_N = mkN "apartheid" masculine ; -- status=guess
lin apartment_N = L.apartment_N ;
lin apathetic_A = mkA "apatico" ; -- status=guess
lin apathy_N = mkN "abulia" | mkN "apatia" | mkN "disamore" | mkN "indifferenza" | mkN "letargo" ; -- UWN
lin apatite_N = mkN "apatite" ; -- status=guess
lin ape_N = mkN "scimmia" ; -- status=guess
lin ape_V2 = mkV2 (mkV "scimmiottare") ; -- status=guess, src=wikt
lin apeldoorn_PN = mkPN "Apeldoorn" ; -- status=guess src=geonames
lin aperitif_N = mkN "aperitivo" ; -- UWN
lin apetalous_A = mkA "apetalo" ; -- UWN
lin apex_N = mkN "apice" masculine ; -- status=guess
lin aphaeresis_N = mkN "aferesi" ; -- UWN
lin aphasia_N = mkN "afasia" | mkN "afemia" ; -- status=guess status=guess
lin aphelion_N = mkN "afelio" ; -- status=guess
lin aphesis_N = mkN "aferesi" ; -- status=guess
lin aphid_N = mkN "afide" ;
lin aphonia_N = mkN "afonia" ; -- status=guess
lin aphorism_N = mkN "aforisma" ; -- status=guess
lin aphorist_N = mkN "aforista" masculine ; -- status=guess
lin aphotic_A = mkA "afotico" ; -- status=guess
lin aphrodisiac_A = mkA "afrodisiaco" | mkA "amatorio" | mkA "erotico" ; -- UWN
lin aphrodisiac_N = mkN "afrodisiaco" | mkN "eccitante" ; -- UWN
lin apiarian_A = mkA "apistico" ; -- UWN
lin apiarist_N = mkN "apicoltore" | mkN "apicultore" ; -- UWN
lin apiary_N = mkN "apiario" ; -- status=guess
lin apiece_Adv = mkAdv "ciascuno" | mkAdv "ciascuna" ; -- status=guess status=guess
lin apivorous_A = mkA "apivoro" ; -- status=guess
lin aplasia_N = mkN "agenesia" | mkN "aplasia" ; -- UWN
lin aplomb_N = mkN "aplomb" | mkN "freddezza" ; -- UWN
lin apnea_N = mkN "apnea" ; -- status=guess
lin apneic_A = mkA "apnoico" ; -- UWN
lin apocalypse_N = mkN "apocalisse" ; -- status=guess
lin apocarpous_A = mkA "apocarpico" ; -- status=guess
lin apocope_N = mkN "apocope" ; -- status=guess
lin apocryphal_A = mkA "apocrifo" ; -- status=guess
lin apogee_N = mkN "apogeo" ; -- UWN
lin apologetics_N = mkN "apologetica" ; -- UWN
lin apologist_N = mkN "apologista" ; -- UWN
lin apologize_V = variants {} ; --
lin apology_N = mkN "apologia" ; -- status=guess
lin apophthegm_N = mkN "aforisma" | mkN "aforismo" | mkN "apoftegma" | mkN "gnome" | mkN "motto" ; -- UWN
lin apophysis_N = mkN "apofisi" feminine ; -- status=guess
lin apoplectic_A = mkA "apoplettico" ; -- UWN
lin aposiopesis_N = mkN "aposiopesi" | mkN "reticenza" ; -- status=guess status=guess
lin apostasy_N = mkN "apostasia" ; -- status=guess
lin apostate_N = mkN "apostata" masculine ; -- status=guess
lin apostle_N = mkN "apostolo" ; -- status=guess
lin apostleship_N = mkN "apostolato" ; -- UWN
lin apostolic_A = mkA "apostolico" ; -- status=guess
lin apostrophe_N = mkN "apostrofo" ; -- status=guess
lin apostrophize_V2 = mkV2 (mkV "apostrofare") ; -- status=guess, src=wikt
lin apothegm_N = mkN "aforisma" | mkN "aforismo" | mkN "apoftegma" | mkN "gnome" | mkN "motto" ; -- UWN
lin apotheosis_N = mkN "apoteosi" | mkN "deificazione" | mkN "divinizzazione" ; -- UWN
lin appalling_A = mkA "terribile" ; -- status=guess
lin appanage_N = mkN "appannaggio" ; -- UWN
lin apparatchik_N = mkN "apparatcik" | mkN "apparatčik" masculine ; -- status=guess status=guess
lin apparatus_N = mkN "apparecchio" ; -- status=guess
lin apparel_N = mkN "abbigliamento" ; -- status=guess
lin appareled_A = mkA "vestito" ; -- UWN
lin apparent_A = mkA "evidente" ; -- status=guess
lin apparition_N = mkN "apparizione" feminine ; -- status=guess
lin appeal_N = mkN "colletta" | mkN "raccolta" ; -- UWN
lin appeal_V = variants {} ; --
lin appeal_V2 = variants {} ; --
lin appealable_A = mkA "appellabile" ; -- status=guess
lin appealing_A = variants {} ;
lin appear_V = mkV "apparire" ; -- status=guess, src=wikt
lin appear_VA = mkVA (mkV "apparire") ; -- status=guess, src=wikt
lin appear_VS = mkVS (mkV "apparire") ; -- status=guess, src=wikt
lin appear_VV = mkVV (mkV "apparire") ; -- status=guess, src=wikt
lin appearance_N = mkN "apparizione" feminine | mkN "visione" feminine ; -- status=guess status=guess
lin appease_V2 = mkV2 (mkV "placare") | mkV2 (mkV "pacificare") | mkV2 (mkV "calmare") | mkV2 (mkV "pacificare") | mkV2 (mkV "calmare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin appeasement_N = mkN "abbonacciamento" | mkN "acquietamento" | mkN "rasserenamento" ; -- UWN
lin appellant_A = mkA "appellante" ; -- UWN
lin appellant_N = mkN "appellante" ; -- UWN
lin appellate_A = mkA "appellante" ; -- UWN
lin appellation_N = mkN "appellativo" | mkN "denominazione" | mkN "soprannome" ; -- UWN
lin appendage_N = mkN "membro" | mkN "estremità" feminine | mkN "protuberanza" ; -- status=guess status=guess status=guess
lin appendectomy_N = mkN "appendicectomia" ; -- status=guess
lin appendicitis_N = mkN "appendicite" ; -- status=guess
lin appendix_N = mkN "appendice" feminine ; -- status=guess
lin appetite_N = mkN "appetito" ; -- status=guess
lin appetitive_A = mkA "appetitivo" ; -- UWN
lin appetizer_N = mkN "aperitivo" | mkN "stuzzichino" | mkN "antipasto" ; -- status=guess status=guess status=guess
lin appetizing_A = mkA "appetibile" | mkA "appetitoso" | mkA "stuzzicante" ; -- UWN
lin applaud_V = mkV "applaudire" ; -- status=guess, src=wikt
lin applaud_V2 = mkV2 (mkV "applaudire") ; -- status=guess, src=wikt
lin applause_N = mkN "applauso" ; -- status=guess
lin apple_N = L.apple_N ;
lin applesauce_N = mkN "baggianata" | mkN "boiata" | mkN "ciarpame" | mkN "citrullaggine" | mkN "cretineria" | mkN "fesseria" | mkN "imbecillaggine" | mkN "immondizia" | mkN "pattume" | mkN "sciocchezza" | mkN "spazzatura" ; -- UWN
lin applicability_N = mkN "applicabilità" | mkN "pertinenza" ; -- UWN
lin applicable_A = variants {} ; --
lin applicant_N = mkN "aspirante" | mkN "candidato" | mkN "instante" | mkN "istante" | mkN "postulante" | mkN "richiedente" | mkN "richieditore" ; -- UWN
lin application_1_N = mkN "applicazione" ; -- UWN
lin application_2_N = mkN "applicazione" ; -- UWN
lin application_3_N = mkN "applicazione" ; -- UWN
lin applicative_A = mkA "applicativo" ; -- status=guess
lin applicator_N = mkN "applicatore" ; -- UWN
lin applied_A = variants {} ; --
lin apply_1_V2 = variants {} ; --
lin apply_2_V2 = variants {} ; --
lin apply_V = mkV "applicare" ; -- status=guess, src=wikt
lin apply_V2 = mkV2 (mkV "applicare") ; -- status=guess, src=wikt
lin apply_V2V = mkV2V (mkV "applicare") ; -- status=guess, src=wikt
lin apply_VV = mkVV (mkV "applicare") ; -- status=guess, src=wikt
lin apply_for_V2 = prepV2 OP_apply_V OP_for_Prep ; -- guess-p-verb
lin appoint_V2 = variants {} ; --
lin appoint_V2V = variants {} ; --
lin appoint_V3 = variants {} ; --
lin appointed_A = variants {} ; --
lin appointive_A = mkA "titolare" ; -- UWN
lin appointment_N = mkN "appuntamento" ; -- status=guess
lin apportionment_N = mkN "assegnazione" | mkN "distribuzione" ; -- UWN
lin appositional_A = mkA "appositivo" ; -- UWN
lin appraisal_N = variants {} ; --
lin appreciate_V = mkV "capire" | mkV (mkV "rendersi") "conto" ; -- status=guess, src=wikt status=guess, src=wikt
lin appreciate_V2 = mkV2 (mkV "capire") | mkV2 (mkV (mkV "rendersi") "conto") ; -- status=guess, src=wikt status=guess, src=wikt
lin appreciation_N = mkN "buon_gusto" | mkN "buongusto" | mkN "finezza" ; -- UWN
lin apprehensible_A = mkA "comprensibile" ; -- UWN
lin apprentice_N = mkN "apprendista" masculine ; -- status=guess
lin apprenticeship_N = mkN "tirocinio" ; -- status=guess
lin approach_N = mkN "approccio" ; -- UWN
lin approach_V = mkV (mkV "accostarsi") "a" | mkV (mkV "avvicinarsi") "a" ; -- status=guess, src=wikt status=guess, src=wikt
lin approach_V2 = mkV2 (mkV (mkV "accostarsi") "a") | mkV2 (mkV (mkV "avvicinarsi") "a") ; -- status=guess, src=wikt status=guess, src=wikt
lin approachable_A = mkA "abbordabile" | mkA "accessibile" | mkA "accostabile" | mkA "avvicinabile" | mkA "trattabile" ; -- UWN
lin appropriate_A = mkA "apposito" ; -- status=guess
lin appropriation_N = mkN "appropriazione" ; -- UWN
lin approval_N = mkN "approvazione" feminine ; -- status=guess
lin approve_V = mkV "approvare" ; -- status=guess, src=wikt
lin approve_V2 = mkV2 (mkV "approvare") ; -- status=guess, src=wikt
lin approved_A = variants {} ; --
lin approximation_N = mkN "approssimazione" feminine ; -- status=guess
lin apricot_N = mkN "albicocca" ; -- status=guess
lin apron_N = mkN "grembiule" masculine ; -- status=guess
lin apropos_Adv = mkAdv "incidentalmente" ; -- UWN
lin apse_N = mkN "abside" feminine ; -- status=guess
lin apsidal_A = mkA "absidale" ; -- UWN
lin aptitude_N = mkN "attitudine" | mkN "facilità" | mkN "predisposizione" ; -- UWN
lin aquamarine_N = mkN "acqua_marina" | mkN "acquamarina" | mkN "azzurro_pavone" ; -- UWN
lin aquaplane_N = mkN "acquaplano" ; -- UWN
lin aquarium_N = mkN "acquario" ; -- status=guess
lin aquatic_A = mkA "acquatico" | mkA "acquatica" ; -- status=guess status=guess
lin aqueduct_N = mkN "acquedotto" ; -- status=guess
lin aquiferous_A = mkA "acquifero" ; -- status=guess
lin aquiline_A = mkA "aquilino" ; -- status=guess
lin arabesque_N = mkN "arabesco" ; -- status=guess
lin arabianFem_N = variants {} ; ---- sense to be split
lin arabianMasc_N = variants {} ; ---- sense to be split
lin arability_N = mkN "coltivabilità" ; -- UWN
lin arachnid_N = mkN "aracnide" ; -- status=guess
lin arachnophobia_N = mkN "aracnofobia" ; -- status=guess
lin aralia_N = mkN "aralia" ; -- UWN
lin araucaria_N = mkN "araucaria" ; -- UWN
lin arbiter_N = mkN "arbitratore" | mkN "arbitro" | mkN "probiviro" | mkN "proboviro" ; -- UWN
lin arbitrage_N = mkN "arbitraggio" ; -- UWN
lin arbitral_A = mkA "arbitrale" ; -- UWN
lin arbitrament_N = mkN "arbitraggio" | mkN "arbitrato" | mkN "lodo" ; -- UWN
lin arbitrary_A = mkA "arbitrario" | mkA "arbitraria" ; -- status=guess status=guess
lin arbitrator_N = mkN "arbitratore" | mkN "arbitro" | mkN "probiviro" | mkN "proboviro" ; -- UWN
lin arbor_N = mkN "chiosco" | mkN "pergola" ; -- UWN
lin arboretum_N = mkN "arboreto" ; -- UWN
lin arboriculture_N = mkN "arboricoltura" ; -- UWN
lin arborvitae_N = mkN "tuia" ; -- UWN
lin arbour_N = mkN "chiosco" | mkN "pergola" ; -- UWN
lin arbroath_PN = mkPN "Arbroath" ; -- status=guess src=geonames
lin arc_N = mkN "arco" ; -- status=guess
lin arcade_N = mkN "portico" | mkN "porticato" | mkN "sottoportico" ; -- status=guess status=guess status=guess
lin arcadian_A = mkA "arcadico" | mkA "bucolico" ; -- UWN
lin arcane_A = mkA "arcano" ; -- status=guess
lin arch_N = variants {} ; --
lin arch_V = mkV "arcuare" | mkV "curvare" | mkV "inarcare" | mkV "incurvare" ; -- UWN
lin archaeological_A = mkA "archeologico" ;
lin archaeologist_N = mkN "archeologo" ;
lin archaeology_N = mkN "archeologia" ;
lin archaic_A = mkA "arcaico" ; -- status=guess
lin archaism_N = mkN "arcaismo" ; -- UWN
lin archaistic_A = mkA "arcaistico" ; -- UWN
lin archangel_N = mkN "arcangelo" ; -- status=guess
lin archbishop_N = mkN "arcivescovo" ; -- status=guess
lin archbishopric_N = mkN "arcivescovado" | mkN "arcivescovato" ; -- UWN
lin archdeacon_N = mkN "arcidiacono" ; -- status=guess
lin archdeaconry_N = mkN "arcidiaconato" ; -- status=guess
lin archdiocese_N = mkN "archidiocesi" | mkN "arcidiocesi" ; -- UWN
lin archducal_A = mkA "arciducale" ; -- UWN
lin archduchess_N = mkN "arciduchessa" ; -- status=guess
lin archduchy_N = mkN "arciducato" ; -- UWN
lin archduke_N = mkN "arciduca" ; -- status=guess
lin archegonium_N = mkN "archegonio" ; -- UWN
lin archery_N = mkN "tiro con l'arco" ; -- status=guess
lin archetype_N = mkN "archetipo" ; -- status=guess
lin archiepiscopal_A = mkA "archiepiscopale" | mkA "arcivescovile" ; -- status=guess status=guess
lin archil_N = mkN "oricello" ; -- UWN
lin archimandrite_N = mkN "archimandrita" masculine ; -- status=guess
lin archipallium_N = mkN "paleocorteccia" | mkN "paleocortex" ; -- UWN
lin archipelago_N = mkN "arcipelago" ; -- status=guess
lin architectFem_N = mkN "architetto" ; -- UWN
lin architectMasc_N = variants {} ; --
lin architectural_A = mkA "architettonico" ; -- UWN
lin architecture_N = mkN "architettura" ; -- status=guess
lin architrave_N = mkN "architrave" feminine ; -- status=guess
lin archive_N = mkN "archivio" ; -- status=guess
lin archives_N = mkN "archivio" ; -- UWN
lin archivist_N = mkN "archivista" ; -- UWN
lin archpriest_N = mkN "arciprete" | mkN "prelato" | mkN "presule" ; -- UWN
lin archway_N = mkN "arcata" ; -- UWN
lin arctic_N = mkN "lepre artica" ; -- status=guess
lin ardrossan_PN = mkPN "Ardrossan" ; -- status=guess src=geonames
lin arduous_A = mkA "arduo" | mkA "ardua" ; -- status=guess status=guess
lin arduousness_N = mkN "arduità" | mkN "asprezza" ; -- UWN
lin are_N = mkN "ara" ; -- status=guess
lin area_1_N = mkN "regione" ;
lin area_2_N = mkN "area" ;
lin area_3_N = mkN "area" ;
lin area_4_N = mkN "area" ;
lin area_5_N = mkN "area" ;
lin area_6_N = mkN "areale" ;
lin area_N = mkN "area" ; --
lin areal_A = mkA "areale" ; -- status=guess
lin areca_N = mkN "areca" ; -- UWN
lin arena_N = mkN "arena" ; -- status=guess
lin arenaceous_A = mkA "sabbioso" ; -- UWN
lin areola_N = mkN "areola" ; -- UWN
lin argent_A = mkA "argento" ; -- status=guess
lin argent_N = mkN "argento" ; -- status=guess
lin argentina_PN = mkPN "Argentina" ; -- status=guess src=geonames
lin argentine_N = mkN "argentina" ; -- status=guess
lin argentine_PN = mkPN "Argentine" ; -- status=guess src=geonames
lin argentite_N = mkN "argentite" ; -- UWN
lin argillaceous_A = mkA "argilloso" ; -- UWN
lin arginine_N = mkN "arginina" ; -- status=guess
lin argon_N = mkN "argon" | mkN "argo" ; -- status=guess status=guess
lin argot_N = mkN "argot" | mkN "frasario" | mkN "fraseologia" | mkN "gergo" | mkN "linguaggio" | mkN "slang" ; -- UWN
lin arguable_A = mkA "disputàbile" | mkA "opinabile" ; -- status=guess status=guess
lin argue_V = discutere_V | mkV "dibattere" ; -- status=guess, src=wikt status=guess, src=wikt
lin argue_V2 = mkV2 (discutere_V) | mkV2 (mkV "dibattere") ; -- status=guess, src=wikt status=guess, src=wikt
lin argue_VS = mkVS (discutere_V) | mkVS (mkV "dibattere") ; -- status=guess, src=wikt status=guess, src=wikt
lin argue_down_V2 = prepV2 OP_argue_V OP_down_Prep ; -- guess-p-verb
lin argue_out_V2 = prepV2 OP_argue_V OP_out_Prep ; -- guess-p-verb
lin argument_N = mkN "argomento" ; -- status=guess
lin argumentation_N = mkN "argomentazione" | mkN "linea" | mkN "tesi" ; -- UWN
lin aria_N = mkN "aria" ; -- status=guess
lin arid_A = mkA "arido" ; -- status=guess
lin aright_Adv = mkAdv "correttamente" | mkAdv "corretto" | mkAdv "propriamente" ; -- UWN
lin aril_N = mkN "arillo" ; -- UWN
lin arioso_N = mkN "arioso" ; -- UWN
lin arise_V = mkV "sorgere" ; -- status=guess, src=wikt
lin aristocrat_N = mkN "aristocratico" | mkN "nobile" | mkN "patrizio" ; -- UWN
lin arithmetic_N = mkN "aritmetica" ; -- status=guess
lin arithmetical_A = mkA "aritmetico" ; -- status=guess
lin arithmetician_N = mkN "aritmetico" ; -- UWN
lin arizona_PN = mkPN "Arizona" ; -- status=guess src=geonames
lin ark_N = mkN "arca" ; -- status=guess
lin arm_1_N = variants {} ; --
lin arm_2_N = mkN "arma" ; -- UWN
lin arm_N = mkN "ramo" ; -- status=guess
lin arm_V = mkV "armare" ; -- status=guess, src=wikt
lin arm_V2 = mkV2 (mkV "armare") ; -- status=guess, src=wikt
lin armadale_PN = mkPN "Armadale" ; -- status=guess src=geonames
lin armadillo_N = mkN "armadillo" ; -- status=guess
lin armagh_PN = mkPN "Armagh" ; -- status=guess src=geonames
lin armature_N = mkN "indotto" ; -- UWN
lin armchair_N = mkN "poltrona" ; -- status=guess
lin armed_A = variants {} ; --
lin arm_hole_N = mkN "giro manica" ; -- UWN
lin armillary_A = mkA "armillare" ; -- UWN
lin armistice_N = mkN "armistizio" ; -- status=guess
lin armlet_N = mkN "bracciale" ; -- UWN
lin armour_N = mkN "armatura" ; -- status=guess
lin armourer_N = mkN "armaiolo" ; -- UWN
lin armoury_N = mkN "armeria" ; -- status=guess
lin armpit_N = mkN "ascella" ; -- status=guess
lin armrest_N = mkN "bracciolo" ; -- UWN
lin army_N = mkN "esercito" ; -- status=guess
lin arnhem_PN = mkPN "Arnhem" ; -- status=guess src=geonames
lin arnica_N = mkN "arnica" ; -- status=guess
lin arnold_PN = mkPN "Arnold" ; -- status=guess src=geonames
lin around_Adv = mkAdv "all'_incirca" | mkAdv "approssimativamente" | mkAdv "attorno" | mkAdv "circa" | mkAdv "circumcirca" | mkAdv "grosso_modo" | mkAdv "grossomodo" | mkAdv "più_o_meno" | mkAdv "press'a_poco" | mkAdv "pressapoco" | mkAdv "pressappoco" | mkAdv "su_per_giù" | mkAdv "suppergiù" ; -- UWN
lin around_Prep = variants {} ; --
lin arouse_V2 = mkV2 (mkV "risvegliare") | mkV2 (mkV "svegliare") ; -- status=guess, src=wikt status=guess, src=wikt
lin arouse_V2V = mkV2V (mkV "risvegliare") | mkV2V (mkV "svegliare") ; -- status=guess, src=wikt status=guess, src=wikt
lin arpeggio_N = mkN "arpeggio" ; -- status=guess
lin arquebus_N = mkN "archibugio" ; -- UWN
lin arrange_V = disporre_V ; -- status=guess, src=wikt
lin arrange_V2 = mkV2 (disporre_V) ; -- status=guess, src=wikt
lin arrangement_N = mkN "arrangiamento" | mkN "sistemazione" feminine ; -- status=guess status=guess
lin arranger_N = mkN "arrangiatore" ; -- UWN
lin arras_N = mkN "arazzo" | mkN "gobelin" ; -- UWN
lin array_N = variants {} ; --
lin arrest_N = variants {} ; --
lin arrest_V2 = mkV2 (mkV "arrestare") ; -- status=guess, src=wikt
lin arrival_N = mkN "arrivo" feminine ; -- status=guess
lin arrive_V = mkV "arrivare" ; -- status=guess, src=wikt
lin arrogance_N = mkN "arroganza" ; -- status=guess
lin arrogant_A = mkA "arrogante" ; -- status=guess
lin arrow_N = mkN "freccia" ; -- status=guess
lin arrowroot_N = mkN "maranta arundinacea" ; -- status=guess
lin arsehole_N = mkN "stronzo" | mkN "coglione" masculine ; -- status=guess status=guess
lin arsenate_N = mkN "arseniato" ; -- status=guess
lin arsenic_N = mkN "arsenico" ; -- status=guess
lin arsenical_A = mkA "arsenicale" ; -- UWN
lin arsenious_A = mkA "arsenioso" ; -- UWN
lin arsenopyrite_N = mkN "arsenopirite" ; -- UWN
lin arsine_N = mkN "arsina" ; -- status=guess
lin arson_N = mkN "incendio doloso" ; -- status=guess
lin arsonist_N = mkN "piromane" | mkN "incendiario" ; -- status=guess status=guess
lin art_N = L.art_N ;
lin artemisia_N = mkN "artemisia" ; -- UWN
lin arterial_A = mkA "arteriale" ; -- status=guess
lin arteriole_N = mkN "arteriola" ; -- UWN
lin arteriosclerosis_N = mkN "arteriosclerosi" feminine ; -- status=guess
lin arteriosclerotic_A = mkA "arteriosclerotico" ; -- status=guess
lin arteritis_N = mkN "arterite" ; -- UWN
lin artery_N = mkN "arteria" ; -- status=guess
lin artful_A = mkA "artificioso" ; -- status=guess
lin arthralgia_N = mkN "artralgia" ; -- status=guess
lin arthritis_N = mkN "artrite" ; -- UWN
lin arthropod_N = mkN "artropodo" ; -- status=guess
lin arthur_PN = mkPN "Arthur" ; -- status=guess src=geonames
lin artichoke_N = mkN "carciofo" ; -- status=guess
lin article_N = mkN "articolo" ; -- status=guess
lin articular_A = mkA "articolare" ; -- UWN
lin articulate_A = mkA "chiaro" ; -- status=guess
lin articulate_V = variants {} ; --
lin articulate_V2 = variants {} ; --
lin articulation_N = mkN "articolazione" feminine ; -- status=guess
lin articulatory_A = mkA "articolatorio" ; -- status=guess
lin artifact_N = mkN "artefatto" ; -- status=guess
lin artificer_N = mkN "armaiolo" | mkN "armiere" ; -- UWN
lin artificial_A = mkA "artificioso" | mkA "falso" ; -- status=guess status=guess
lin artificiality_N = mkN "artificialità" ; -- UWN
lin artillery_N = mkN "artiglieria" ; -- status=guess
lin artilleryman_N = mkN "artigliere" | mkN "cannoniere" ; -- UWN
lin artisan_N = mkN "artigiano" ; -- status=guess
lin artist_N = mkN "artista" masculine ; -- status=guess
lin artiste_N = mkN "artista" ; -- UWN
lin artistic_A = mkA "artistico" ; -- status=guess
lin artistry_N = mkN "artisticità" feminine ; -- status=guess
lin artwork_N = mkN "materiale_illustrativo" ; -- UWN
lin aryanFem_N = variants {} ; ---- sense to be split
lin aryanMasc_N = variants {} ; ---- sense to be split
lin as_CAdv = S.as_CAdv ; -- comment=CHECKED
lin as_Prep = mkPrep "come" ;
lin as_Subj = mkSubj "quando" ;
lin asbestos_N = mkN "amianto" | mkN "asbesto" ; -- UWN
lin ascariasis_N = mkN "ascaridiasi" | mkN "ascaridiosi" ; -- UWN
lin ascend_V = salire_V ; -- status=guess, src=wikt
lin ascend_V2 = mkV2 (salire_V) ; -- status=guess, src=wikt
lin ascendancy_N = mkN "influsso" ; -- status=guess
lin ascendant_N = mkN "antenato" | mkN "ascendente" | mkN "avo" | mkN "avolo" | mkN "bisarcavolo" | mkN "bisavo" | mkN "bisavolo" | mkN "bisnonno" | mkN "progenitore" | mkN "trisavo" | mkN "trisavolo" ; -- UWN
lin ascendency_N = mkN "ascendente" | mkN "controllo" | mkN "predominio" ; -- UWN
lin ascendent_N = mkN "antenato" | mkN "ascendente" | mkN "avo" | mkN "avolo" | mkN "bisarcavolo" | mkN "bisavo" | mkN "bisavolo" | mkN "bisnonno" | mkN "progenitore" | mkN "trisavo" | mkN "trisavolo" ; -- UWN
lin ascension_N = mkN "ascensione" feminine ; -- status=guess
lin ascertain_V2 = mkV2 (mkV "accertare") ; -- status=guess, src=wikt
lin ascetic_N = mkN "asceta" ; -- UWN
lin ascidian_N = mkN "ascidiaceo" ; -- UWN
lin ascocarp_N = mkN "ascocarpo" ; -- UWN
lin ascot_PN = mkPN "Ascot" ; -- status=guess src=geonames
lin ascribe_V2 = mkV2 (mkV "attribuire") ; -- status=guess, src=wikt
lin asdic_N = mkN "ecogoniometro" | mkN "ecometro" | mkN "ecoscandaglio" | mkN "sonar" ; -- UWN
lin asexual_A = mkA "asessuale" | mkA "asessuato" ; -- status=guess status=guess
lin asexuality_N = mkN "asessualità" feminine ; -- status=guess
lin ash_N = mkN "cenere" feminine ; -- status=guess
lin ashamed_A = variants {} ; --
lin ashbourne_PN = mkPN "Ashbourne" ; -- status=guess src=geonames
lin ashby_PN = mkPN "Ashby" ; -- status=guess src=geonames
lin ashby_de_la_zouch_PN = mkPN "Ashby de la Zouch" ; -- status=guess src=geonames
lin ashes_N = L.ashes_N ; -- comment=CHECKED
lin ashford_PN = mkPN "Ashford" ; -- status=guess src=geonames
lin ashington_PN = mkPN "Ashington" ; -- status=guess src=geonames
lin ashlar_N = mkN "pietra_concia" ; -- UWN
lin ashtray_N = mkN "portacenere" | mkN "posacenere" ; -- status=guess status=guess
lin aside_Adv = variants {} ; --
lin asinine_A = mkA "asinino" ; -- status=guess
lin ask_V = chiedere_V | mkV "domandare" ; -- status=guess, src=wikt status=guess, src=wikt
lin ask_V2 = mkV2 (chiedere_V) | mkV2 (mkV "domandare") ; -- status=guess, src=wikt status=guess, src=wikt
lin ask_V2Q = L.ask_V2Q ; -- comment=CHECKED
lin ask_V2V = mkV2V (chiedere_V) | mkV2V (mkV "domandare") ; -- status=guess, src=wikt status=guess, src=wikt
lin ask_VQ = mkVQ (chiedere_V) | mkVQ (mkV "domandare") ; -- status=guess, src=wikt status=guess, src=wikt
lin ask_about_V2 = prepV2 OP_ask_V OP_about_Prep ; -- guess-p-verb
lin ask_after_V2 = prepV2 OP_ask_V OP_after_Prep ; -- guess-p-verb
lin ask_around_V = advV OP_ask_V OP_around_Adv ; -- guess-p-verb
lin ask_around_V2 = prepV2 OP_ask_V OP_around_Prep ; -- guess-p-verb
lin ask_for_V2 = prepV2 OP_ask_V OP_for_Prep ; -- guess-p-verb
lin ask_for_V3 = variants {} ; -- guess-p-verb
lin ask_in_V2 = prepV2 OP_ask_V OP_in_Prep ; -- guess-p-verb
lin ask_out_V2 = prepV2 OP_ask_V OP_out_Prep ; -- guess-p-verb
lin ask_over_V2 = prepV2 OP_ask_V OP_over_Prep ; -- guess-p-verb
lin ask_round_V2 = prepV2 OP_ask_V OP_round_Prep ; -- guess-p-verb
lin askance_Adv = mkAdv "storto" ; -- status=guess
lin askern_PN = mkPN "Askern" ; -- status=guess src=geonames
lin askew_Adv = mkAdv "di_traverso" ; -- UWN
lin asleep_A = mkA "addormentato" ; -- status=guess
lin asocial_A = mkA "asociale" ; -- status=guess
lin asparagine_N = mkN "asparagina" ; -- UWN
lin asparagus_N = mkN "asparago" ; -- status=guess
lin aspartame_N = mkN "aspartame" ; -- status=guess
lin aspect_N = mkN "aspetto" ; -- status=guess
lin aspen_N = mkN "pioppo" ; -- status=guess
lin asper_N = mkN "asper" | mkN "asper_turco" ; -- UWN
lin asperity_N = mkN "asperità" ; -- status=guess
lin aspersion_N = mkN "aspersione" ; -- UWN
lin asphalt_N = mkN "asfalto" ; -- status=guess
lin asphodel_N = mkN "asfodelo" ; -- status=guess
lin asphyxia_N = mkN "asfissia" ; -- UWN
lin aspic_N = mkN "aspic" ; -- UWN
lin aspirant_N = mkN "aspirante" ; -- UWN
lin aspirate_N = mkN "aspirata" ; -- UWN
lin aspirate_V2 = mkV2 (mkV "pompare") | mkV2 (mkV "aspirare") ; -- status=guess, src=wikt status=guess, src=wikt
lin aspiration_N = mkN "aspirazione" | mkN "inalazione" | mkN "inspirazione" ; -- UWN
lin aspirator_N = mkN "aspiratore" masculine ; -- status=guess
lin aspirin_N = mkN "aspirina" ; -- status=guess
lin ass_N = mkN "asino" | mkN "ciuco" | mkN "somaro" ; -- status=guess status=guess status=guess
lin assail_V2 = mkV2 (assalire_V) ; -- status=guess, src=wikt
lin assailant_N = mkN "aggressore" | mkN "assalitore" | mkN "assaltatore" | mkN "attaccante" | mkN "offensore" | mkN "pestatore" ; -- UWN
lin assassin_N = mkN "assassino" ; -- status=guess
lin assassinate_V2 = mkV2 (mkV "assassinare") ; -- status=guess, src=wikt
lin assassination_N = mkN "assassinio" ; -- status=guess
lin assault_N = mkN "assalto" | mkN "attacco" | mkN "aggressione" feminine ; -- status=guess status=guess status=guess
lin assault_V2 = mkV2 (mkV "attaccare") | mkV2 (mkV "aggredire") | mkV2 (assalire_V) | mkV2 (mkV "molestare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin assay_N = mkN "analisi" feminine | mkN "saggiatura" | mkN "saggio" ; -- status=guess status=guess status=guess
lin assegai_N = mkN "zagaglia" ; -- status=guess
lin assemble_V = mkV "riunire" | mkV "riunirsi" | mkV "adunare" | mkV "adunarsi" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin assemble_V2 = mkV2 (mkV "riunire") | mkV2 (mkV "riunirsi") | mkV2 (mkV "adunare") | mkV2 (mkV "adunarsi") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin assembler_N = mkN "assemblatore" ; -- UWN
lin assembly_N = variants {} ; --
lin assent_N = mkN "assenso" ; -- status=guess
lin assent_V = assentire_V ; -- status=guess, src=wikt
lin assert_V = mkV "asserire" ; -- status=guess, src=wikt
lin assert_V2 = mkV2 (mkV "asserire") ; -- status=guess, src=wikt
lin assert_VS = mkVS (mkV "asserire") ; -- status=guess, src=wikt
lin assertion_N = mkN "asserzione" feminine ; -- status=guess
lin assertive_A = mkA "assertivo" ; -- status=guess
lin assertiveness_N = mkN "assertività" ; -- UWN
lin assess_V2 = mkV2 (mkV "valutare") | mkV2 (mkV "stimare") | mkV2 (mkV "estimare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin assessment_N = mkN "valutazione" feminine ; -- status=guess
lin asset_N = variants {} ; --
lin assets_N = mkN "asse" masculine ; -- status=guess
lin asseverate_V2 = mkV2 (mkV "asseverare") ; -- status=guess, src=wikt
lin asseveration_N = mkN "affermazione" | mkN "asserzione" | mkN "asseverazione" | mkN "dichiarazione" ; -- UWN
lin asshole_N = mkN "ano" ; -- status=guess
lin assiduity_N = mkN "assiduità" | mkN "diligenza" ; -- UWN
lin assiduous_A = mkA "assiduo" ; -- status=guess
lin assign_V2 = mkV2 (mkV "assegnare") ; -- status=guess, src=wikt
lin assign_V2V = mkV2V (mkV "assegnare") ; -- status=guess, src=wikt
lin assignable_A = mkA "amovibile" | mkA "trasferibile" ; -- UWN
lin assignation_N = mkN "assegnazione" | mkN "distribuzione" ; -- UWN
lin assignee_N = mkN "assegnatario" ; -- UWN
lin assignment_N = mkN "assegnazione" | mkN "designazione" | mkN "nomina" | mkN "nominazione" ; -- UWN
lin assimilate_V = mkV "assimilare" ; -- status=guess, src=wikt
lin assimilate_V2 = mkV2 (mkV "assimilare") ; -- status=guess, src=wikt
lin assist_V = assistere_V | mkV "aiutare" ; -- status=guess, src=wikt status=guess, src=wikt
lin assist_V2 = mkV2 (assistere_V) | mkV2 (mkV "aiutare") ; -- status=guess, src=wikt status=guess, src=wikt
lin assistance_N = mkN "assistenza" ; -- status=guess
lin assistantFem_N = mkN "assistente" masculine ; -- status=guess ---- sense to be split
lin assistantMasc_N = mkN "assistente" masculine ; -- status=guess ---- sense to be split
lin assistant_A = variants {} ; --
lin assistant_N = mkN "assistente" masculine ; -- status=guess
lin associability_N = mkN "associabilità" ; -- UWN
lin associate_N = variants {} ; --
lin associate_V = variants {} ; --
lin associate_V2 = variants {} ; --
lin associated_A = variants {} ; --
lin association_N = mkN "associazione" feminine ; -- status=guess
lin associationism_N = mkN "associazionismo" ; -- status=guess
lin associative_A = mkA "associativo" ; -- status=guess
lin assonance_N = mkN "assonanza" ; -- UWN
lin assortment_N = mkN "categorizzazione" | mkN "classificazione" ; -- UWN
lin assume_V2 = mkV2 (presupporre_V) | mkV2 (ritenere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin assume_VS = mkVS (presupporre_V) | mkVS (ritenere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin assumption_N = mkN "assunzione" feminine ; -- status=guess
lin assurance_N = mkN "baldanza" | mkN "fiducia_in_se_stesso" | mkN "sicurezza" | mkN "sicurezza_di_sé" ; -- UWN
lin assure_V2 = variants {} ; --
lin assure_V2S = variants {} ; --
lin assuredness_N = mkN "aplomb" | mkN "freddezza" ; -- UWN
lin astatine_N = mkN "astato" ; -- status=guess
lin aster_N = mkN "astro" ; -- status=guess
lin asterisk_N = mkN "asterisco" ; -- status=guess
lin asterism_N = mkN "asterismo" ; -- status=guess
lin astern_Adv = mkAdv "a_poppa" ; -- UWN
lin asteroid_N = mkN "asteroide" | mkN "pianetino" | mkN "planetoide" masculine ; -- status=guess status=guess status=guess
lin asteroidal_A = mkA "asteroidale" ; -- status=guess
lin asthenosphere_N = mkN "astenosfera" ; -- status=guess
lin asthma_N = mkN "asma" ; -- status=guess
lin asthmatic_A = mkA "asmatico" ; -- status=guess
lin asthmatic_N = mkN "asmatico" ; -- status=guess
lin astigmatism_N = mkN "astigmatismo" ; -- status=guess
lin astonish_V2 = mkV2 (sorprendere_V) | mkV2 (mkV "stupire") ; -- status=guess, src=wikt status=guess, src=wikt
lin astonishing_A = mkA "sbalorditivo" ; -- UWN
lin astonishment_N = mkN "stupore" | mkN "meraviglia" | mkN "sorpresa" | mkN "sbigottimento" ; -- status=guess status=guess status=guess status=guess
lin astounding_A = mkA "impressionante" ; -- status=guess
lin astral_A = mkA "astrale" ; -- status=guess
lin astride_Adv = mkAdv "a cavalcioni" ; -- status=guess
lin astringency_N = mkN "astringenza" ; -- UWN
lin astringent_A = mkA "astringente" ; -- UWN
lin astringent_N = mkN "astringente" ; -- UWN
lin astrodynamics_N = mkN "astrodinamica" ; -- status=guess
lin astrolabe_N = mkN "astrolabio" ;
lin astrolatry_N = mkN "astrolatria" ; -- UWN
lin astrologer_N = mkN "astrologo" ; -- UWN
lin astrological_A = mkA "astrologico" ; -- status=guess
lin astrology_N = mkN "astrologia" ; -- UWN
lin astrometry_N = mkN "astrometria" ; -- status=guess
lin astronaut_N = mkN "astronauta" | mkN "cosmonauta" ; -- UWN
lin astronautic_A = mkA "astronautico" | mkA "cosmonautico" ; -- UWN
lin astronautics_N = mkN "aereonautica" | mkN "aeronautica" | mkN "astronautica" | mkN "aviazione" | mkN "cosmonautica" ; -- UWN
lin astronomer_N = mkN "astronomo" ; -- status=guess
lin astronomic_A = mkA "astronomico" ; -- UWN
lin astronomical_A = mkA "astronomico" ; -- UWN
lin astronomy_N = mkN "astronomia" ; -- status=guess
lin astrophysical_A = mkA "astrofisico" ; -- status=guess
lin astrophysics_N = mkN "astrofisica" ; -- status=guess
lin astute_A = mkA "avveduto" | mkA "avveduta" ; -- status=guess status=guess
lin astuteness_N = mkN "astuzia" ; -- status=guess
lin asunder_Adv = mkAdv "in pezzi" ; -- status=guess
lin asylum_N = mkN "asilo" ; -- status=guess
lin asymmetric_A = mkA "asimmetrico" ; -- UWN
lin asymmetrical_A = mkA "asimetrico" ; -- status=guess
lin asymmetry_N = mkN "asimmetria" | mkN "asimmetricità" ; -- UWN
lin asymptomatic_A = mkA "asintomatico" ; -- status=guess
lin asymptote_N = mkN "asintoto" ; -- UWN
lin asymptotic_A = mkA "asintotico" ; -- status=guess
lin asynchronism_N = mkN "asincronismo" ; -- UWN
lin asynchronous_A = mkA "asincrono" ; -- status=guess
lin asynclitism_N = mkN "asinclitismo" ; -- UWN
lin asystole_N = mkN "arresto_cardiaco" ; -- UWN
lin at_N = mkN "chiocciola" ; -- status=guess
lin at_Prep = ParadigmsIta.dative ;
lin at_least_AdN = S.at_least_AdN ; -- comment=CHECKED
lin at_most_AdN = S.at_most_AdN ; -- comment=CHECKED
lin ataraxia_N = mkN "atarassia" ; -- UWN
lin atavism_N = mkN "atavismo" | mkN "reversione" | mkN "riversione" ; -- UWN
lin atavistic_A = mkA "atavico" ; -- status=guess
lin ataxia_N = mkN "atassia" ; -- UWN
lin ataxic_A = mkA "atassico" ; -- UWN
lin atelier_N = mkN "atelier" ; -- UWN
lin atheism_N = mkN "ateismo" ; -- status=guess
lin atheist_A = mkA "ateistico" | mkA "ateo" | mkA "miscredente" ; -- UWN
lin atheist_N = mkN "ateo" ; -- status=guess
lin atheistic_A = mkA "ateo" | mkA "ateistico" ; -- status=guess status=guess
lin athenianFem_N = variants {} ; ---- sense to be split
lin athenianMasc_N = variants {} ; ---- sense to be split
lin athens_1_PN = mkPN "Atene" ; -- status=guess src=geonames
lin athens_2_PN = mkPN "Atene" ; -- status=guess src=geonames
lin atherstone_PN = mkPN "Atherstone" ; -- status=guess src=geonames
lin athlete_N = mkN "atleta" masculine ; -- status=guess
lin athletic_A = mkA "atletico" ; -- status=guess
lin athletics_N = mkN "atletica" ; -- status=guess
lin athlone_PN = mkPN "Athlone" ; -- status=guess src=geonames
lin athwart_Adv = mkAdv "di traverso" ; -- status=guess
lin atlanta_PN = mkPN "Atlanta" ; -- status=guess src=geonames
lin atlantic_PN = mkPN "Atlantic" ; -- status=guess src=geonames
lin atlas_N = mkN "atlante" masculine ; -- status=guess
lin atmosphere_N = mkN "aria" | mkN "aria" | mkN "atmosfera" | mkN "atteggiamento" ; -- UWN
lin atmospheric_A = mkA "atmosferico" ; -- status=guess
lin atmospherics_N = mkN "disturbo" ; -- UWN
lin atoll_N = mkN "atollo" ; -- status=guess
lin atom_N = mkN "atomo" ; -- status=guess
lin atomic_A = mkA "atomico" ; -- status=guess
lin atomistic_A = mkA "atomistico" ; -- UWN
lin atomization_N = mkN "nebulizzazione" ; -- UWN
lin atomizer_N = mkN "atomizzatore" masculine ; -- status=guess
lin atonal_A = mkA "atonale" ; -- status=guess
lin atonality_N = mkN "atonalità" | mkN "dodecafonia" ; -- UWN
lin atonement_N = mkN "espiazione" feminine | mkN "riparazione" feminine | mkN "redenzione" feminine ; -- status=guess status=guess status=guess
lin atonicity_N = mkN "atonia" ; -- UWN
lin atrial_A = mkA "atriale" ; -- status=guess
lin atrium_N = mkN "atrio" ; -- UWN
lin atrocious_A = mkA "atroce" ; -- status=guess
lin atrocity_N = mkN "atrocità" masculine ; -- status=guess
lin atrophic_A = mkA "atrofico" ; -- UWN
lin atrophy_N = mkN "atrofia" ; -- status=guess
lin atropine_N = mkN "atropina" ; -- status=guess
lin attach_V = mkV "legare" ; -- status=guess, src=wikt
lin attach_V2 = mkV2 (mkV "legare") ; -- status=guess, src=wikt
lin attachment_N = mkN "allegato" ; -- status=guess
lin attack_N = mkN "attacco" ; -- status=guess
lin attack_V2 = variants {} ; --
lin attacker_N = mkN "aggressore" | mkN "assalitore" | mkN "assaltatore" | mkN "attaccante" | mkN "offensore" | mkN "pestatore" ; -- UWN
lin attain_V = raggiungere_V | ottenere_V | attenere_V ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin attain_V2 = mkV2 (raggiungere_V) | mkV2 (ottenere_V) | mkV2 (attenere_V) ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin attainment_N = variants {} ; --
lin attempt_1_N = mkN "attentato" ; -- status=guess ---- sense to be split
lin attempt_2_N = mkN "attentato" ; -- status=guess ---- sense to be split
lin attempt_N = mkN "attentato" ; -- status=guess
lin attempt_V2 = mkV2 (mkV "tentare") | mkV2 (mkV "cercare") | mkV2 (mkV "provare") | mkV2 (mkV "attentare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin attempt_VV = mkVV (mkV "tentare") | mkVV (mkV "cercare") | mkVV (mkV "provare") | mkVV (mkV "attentare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin attempted_A = variants {} ; --
lin attend_V = mkV "partecipare" ; -- status=guess, src=wikt
lin attend_V2 = mkV2 (mkV "partecipare") ; -- status=guess, src=wikt
lin attendance_N = variants {} ; --
lin attention_N = mkN "attenzione" feminine ; -- status=guess
lin attenuation_N = mkN "attenuazione" feminine ; -- status=guess
lin attestation_N = mkN "attestazione" feminine ; -- status=guess
lin attic_N = mkN "soffitta" ; -- status=guess
lin attire_N = mkN "palco" ; -- status=guess
lin attire_V2 = mkV2 (mkV "indossare") | mkV2 (mkV "portare") ; -- status=guess, src=wikt status=guess, src=wikt
lin attitude_N = mkN "atteggiamento" ; -- status=guess
lin attorney_N = mkN "avvocato" ; -- status=guess
lin attract_V2 = variants {} ; --
lin attraction_N = mkN "attrazione" feminine ; -- status=guess
lin attractive_A = mkA "attraente" ; -- status=guess
lin attribute_N = variants {} ; --
lin attribute_V2 = variants {} ; --
lin aubergine_N = mkN "melanzana" ; -- UWN
lin auckland_PN = mkPN "Auckland" ; -- status=guess src=geonames
lin auction_N = mkN "asta" | mkN "incanto" ; -- status=guess status=guess
lin auction_V2 = mkV2 (mkV "vendere") ; -- status=guess, src=wikt
lin auctioneer_N = mkN "battitore" masculine | mkN "banditore" masculine ; -- status=guess status=guess
lin audibility_N = mkN "udibilità" ; -- UWN
lin audible_A = mkA "udibile" ; -- UWN
lin audience_N = mkN "udienza" ; -- status=guess
lin audio_N = mkN "audiofrequenza" ; -- status=guess
lin audiocassette_N = mkN "audiocassetta" ; -- UWN
lin audiogram_N = mkN "audiogramma" masculine ; -- status=guess
lin audiology_N = mkN "audiologia" ; -- status=guess
lin audiometer_N = mkN "audiometro" ; -- status=guess
lin audiometric_A = mkA "audiometrico" ; -- UWN
lin audiometry_N = mkN "audiometria" ; -- status=guess
lin audiovisual_A = mkA "audiovisivo" ; -- status=guess
lin audit_N = variants {} ; --
lin audition_N = mkN "audizione" ; -- UWN
lin auditor_N = mkN "revisore_dei_conti" ; -- UWN
lin auditorium_N = mkN "sala" ; -- status=guess
lin auditory_A = mkA "uditivo" ; -- status=guess
lin audley_PN = mkPN "Audley" ; -- status=guess src=geonames
lin auger_N = mkN "succhiello" | mkN "menarola" ; -- status=guess status=guess
lin augment_V = mkV "aumentarsi" | mkV "accrescersi" ; -- status=guess, src=wikt status=guess, src=wikt
lin augment_V2 = mkV2 (mkV "aumentarsi") | mkV2 (mkV "accrescersi") ; -- status=guess, src=wikt status=guess, src=wikt
lin augsburg_PN = mkPN "Augusta" ; -- status=guess src=geonames
lin augur_N = mkN "augure" masculine ; -- status=guess
lin augur_V = mkV "augurare" ; -- status=guess, src=wikt
lin augur_V2 = mkV2 (mkV "augurare") ; -- status=guess, src=wikt
lin augury_N = mkN "augurio" ; -- status=guess
lin auk_N = mkN "alca" ; -- UWN
lin aunt_N = mkN "zia" ; -- status=guess
lin auntie_N = mkN "zietta" | mkN "ziettina" | mkN "ziuccia" ; -- status=guess status=guess status=guess
lin aunty_N = mkN "zia" | mkN "zietta" ; -- UWN
lin aura_N = mkN "aura" ; -- status=guess
lin aural_A = mkA "auricolare" ; -- status=guess
lin aureate_A = mkA "dorato" ; -- UWN
lin aureole_N = mkN "aureola" | mkN "nimbo" ; -- UWN
lin auricle_N = mkN "orecchietta" | mkN "padiglione" | mkN "auricola" ; -- status=guess status=guess status=guess
lin auriferous_A = mkA "aurifero" ; -- status=guess
lin aurochs_N = mkN "uro" ; -- status=guess
lin auscultation_N = mkN "auscultazione" ; -- UWN
lin auspice_N = mkN "auspicio" ; -- UWN
lin auspices_N = mkN "auspicio" | mkN "egida" ; -- UWN
lin austenitic_A = mkA "austenitico" ; -- status=guess
lin austere_A = mkA "austero" ; -- status=guess
lin austral_A = mkA "australe" ; -- status=guess
lin austral_N = mkN "australe" ; -- status=guess
lin australia_PN = mkPN "Australia" ; -- status=guess src=geonames
lin australianFem_N = variants {} ; ---- sense to be split
lin australianMasc_N = variants {} ; ---- sense to be split
lin austria_PN = mkPN "Austria" ; -- status=guess src=geonames
lin austrianFem_N = variants {} ; ---- sense to be split
lin austrianMasc_N = variants {} ; ---- sense to be split
lin autarchy_N = mkN "autarchia" ; -- status=guess
lin autarkic_A = mkA "autarchico" ; -- status=guess
lin autarky_N = mkN "autarchia" ; -- status=guess
lin auteur_N = mkN "cineasta" masculine ; -- status=guess
lin authentic_A = mkA "autentico" ; -- status=guess
lin authenticity_N = mkN "autenticità" feminine ; -- status=guess
lin author_N = mkN "autore" | mkN "autrice" feminine ; -- status=guess status=guess
lin authoress_N = mkN "autrice" | mkN "scrittrice" ; -- UWN
lin authoritarian_A = mkA "despotico" | mkA "dispotico" | mkA "tirannico" | mkA "tiranno" ; -- UWN
lin authoritarian_N = mkN "dittatore" ; -- UWN
lin authoritative_A = mkA "autoritario" ; -- status=guess
lin authority_1_N = mkN "autorità" ;
lin authority_2_N = mkN "autorità" ;
lin authority_N = mkN "autorità" feminine ; -- status=guess
lin authorization_N = mkN "autorizzazione" feminine ; -- status=guess
lin authorize_V2 = variants {} ; --
lin authorize_V2V = variants {} ; --
lin autism_N = mkN "autismo" ; -- status=guess
lin autistic_A = mkA "autistico" ; -- status=guess
lin auto_N = mkN "automobilismo" ; -- status=guess
lin autobiographer_N = mkN "autobiografo" ; -- UWN
lin autobiographical_A = mkA "autobiografico" ; -- status=guess
lin autobiography_N = mkN "autobiografia" ; -- status=guess
lin autocatalytic_A = mkA "autocatalitico" ; -- status=guess
lin autochthonous_A = mkA "autoctono" ; -- status=guess
lin autoclave_N = mkN "autoclave" ; -- UWN
lin autocrat_N = mkN "autocrate" | mkN "despota" | mkN "dittatore" | mkN "ras" | mkN "tiranno" ; -- UWN
lin autocratic_A = mkA "despotico" | mkA "dispotico" | mkA "tirannico" | mkA "tiranno" ; -- UWN
lin autodidact_N = mkN "autodidatto" | mkN "autodidatta" ; -- status=guess status=guess
lin autoerotic_A = mkA "autoerotico" ; -- status=guess
lin autoeroticism_N = mkN "autoerotismo" ; -- UWN
lin autofluorescence_N = mkN "autofluorescenza" ; -- UWN
lin autogamy_N = mkN "autogamia" ; -- status=guess
lin autogenous_A = mkA "autogeno" ; -- status=guess
lin autogiro_N = mkN "autogiro" ; -- UWN
lin autograft_N = mkN "autotrapianto" ; -- UWN
lin autograph_N = mkN "manoscritto" ; -- status=guess
lin autograph_V2 = mkV2 (mkV "autografare") ; -- status=guess, src=wikt
lin autographic_A = mkA "autografico" ; -- UWN
lin autogyro_N = mkN "autogiro" ; -- UWN
lin autoimmune_A = mkA "autoimmune" ; -- status=guess
lin autoimmunity_N = mkN "autoimmunità" feminine ; -- status=guess
lin autolysis_N = mkN "autolisi" ; -- UWN
lin autolytic_A = mkA "autolitico" ; -- UWN
lin automatic_A = mkA "automatico" ; -- status=guess
lin automation_N = mkN "automaticizzazione" | mkN "automatizzazione" | mkN "automazione" | mkN "meccanizzazione" | mkN "robotizzazione" ; -- UWN
lin automatism_N = mkN "automatismo" ; -- status=guess
lin automaton_N = mkN "automa" masculine ; -- status=guess
lin automobile_N = mkN "automobile" feminine | mkN "auto" feminine | mkN "macchina" | mkN "vettura" ; -- status=guess status=guess status=guess status=guess
lin autonomic_A = mkA "autonomo" ; -- UWN
lin autonomous_A = mkA "autonomo" | mkA "autonoma" ; -- status=guess status=guess
lin autonomy_N = mkN "autonomia" ; -- status=guess
lin autosome_N = mkN "autosoma" masculine ; -- status=guess
lin autostrada_N = mkN "autostrada" ; -- UWN
lin autotelic_A = mkA "autotelico" ; -- status=guess
lin autotomy_N = mkN "autotomia" ; -- UWN
lin autotrophic_A = mkA "autrofico" ; -- status=guess
lin autotypic_A = mkA "autotipico" ; -- UWN
lin autumn_N = mkN "autunno" ; -- status=guess
lin autumnal_A = mkA "autunnale" ; -- status=guess
lin auxiliary_A = mkA "ausiliare" | mkA "ausiliario" ; -- status=guess status=guess
lin auxiliary_N = mkN "ausiliare" ; -- status=guess
lin availability_N = mkN "disponibilità" feminine | mkN "reperibilità" feminine ; -- status=guess status=guess
lin available_A = mkA "disponibile" ; -- status=guess
lin avalanche_N = mkN "valanga" ; -- status=guess
lin avarice_N = mkN "avarizia" | mkN "cupidigia" ; -- status=guess status=guess
lin avaricious_A = mkA "avaro" ; -- status=guess
lin avascular_A = mkA "avascolare" ; -- status=guess
lin avatar_N = mkN "avatar" | mkN "emblema" | mkN "simbolo" ; -- status=guess status=guess status=guess
lin aveley_PN = mkPN "Aveley" ; -- status=guess src=geonames
lin avenger_N = mkN "ultore" | mkN "vendicatore" ; -- UWN
lin avenue_N = mkN "viale" | mkN "corso" ; -- status=guess status=guess
lin average_A = mkA "medio" | mkA "media" ; -- status=guess status=guess
lin average_N = mkN "media" ; -- status=guess
lin aversion_N = mkN "avversione" feminine ; -- status=guess
lin aviary_N = mkN "voliera" ; -- status=guess
lin aviation_N = mkN "aviazione" feminine ; -- status=guess
lin aviatorFem_N = variants {} ; ---- sense to be split
lin aviatorMasc_N = variants {} ; ---- sense to be split
lin avid_A = mkA "bramoso" ; -- status=guess
lin avidity_N = mkN "avidità" feminine ; -- status=guess
lin avifauna_N = mkN "avifauna" ; -- UWN
lin avignon_PN = mkPN "Avignone" ; -- status=guess src=geonames
lin avionics_N = mkN "avionica" ; -- UWN
lin avitaminosis_N = mkN "avitaminosi" | mkN "disvitaminosi" | mkN "ipovitaminosi" ; -- UWN
lin avo_N = mkN "avo" | mkN "avo_di_Macao" ; -- UWN
lin avocado_N = mkN "avocado" ; -- status=guess
lin avocation_N = mkN "hobby" ; -- UWN
lin avocet_N = mkN "avocetta" ; -- UWN
lin avoid_V2 = mkV2 (mkV "evitare") ; -- status=guess, src=wikt
lin avoid_VV = mkVV (mkV "evitare") ; -- status=guess, src=wikt
lin avoidable_A = mkA "evitabile" ; -- status=guess
lin avon_PN = mkPN "Avon" ; -- status=guess src=geonames
lin avowedly_Adv = mkAdv "dichiaratamente" ; -- status=guess
lin avulsion_N = mkN "avulsione" ; -- UWN
lin await_V2 = mkV2 (mkV "aspettare") | mkV2 (mkV "attendere") ; -- status=guess, src=wikt status=guess, src=wikt
lin awake_A = mkA "veglia" ;
lin awake_V = mkV "svegliare" ; -- status=guess, src=wikt
lin awakening_N = mkN "rinnovamento" | mkN "risveglio" ; -- status=guess status=guess
lin award_N = mkN "sentenza" ; -- status=guess
lin award_V2 = mkV2 (mkV "sentenziare") ; -- status=guess, src=wikt
lin award_V3 = mkV3 (mkV "sentenziare") ; -- status=guess, src=wikt
lin aware_A = mkA "all'erta" ; -- status=guess
lin awareness_N = mkN "coscienza" ; -- status=guess
lin away_1_Adv = mkAdv "lontano" ;
lin away_2_Adv = mkAdv "lontano" ;
lin away_Adv = mkAdv "lontano" ;
lin awe_N = mkN "timore" masculine ; -- status=guess
lin aweary_A = mkA "stanco" ; -- UWN
lin awesome_A = mkA "impressionante" ; -- status=guess
lin awful_A = variants {} ; --
lin awhile_Adv = mkAdv "per un po'" ; -- status=guess
lin awkward_A = mkA "maldestro" | mkA "impacciato" | mkA "goffo" ; -- status=guess status=guess status=guess
lin awl_N = mkN "punteruolo" ; -- status=guess
lin awn_N = mkN "arista" | mkN "resta" ; -- UWN
lin awning_N = mkN "tenda" ; -- UWN
lin ax_N = mkN "ascia" | mkN "mannaia" | mkN "scure" ; -- UWN
lin axe_N = mkN "ascia" ; -- status=guess
lin axil_N = mkN "ascella" ; -- UWN
lin axiological_A = mkA "assiologico" ; -- status=guess
lin axiology_N = mkN "assiologia" ; -- status=guess
lin axiom_N = mkN "assioma" masculine ; -- status=guess
lin axis_N = mkN "asse" masculine ; -- status=guess
lin axle_N = mkN "asse" masculine ; -- status=guess
lin axon_N = mkN "assone" masculine ; -- status=guess
lin ayatollah_N = mkN "ayatollah" masculine ; -- status=guess
lin aye_Interj = variants {} ; --
lin aylesbury_PN = mkPN "Aylesbury" ; -- status=guess src=geonames
lin aylesford_PN = mkPN "Aylesford" ; -- status=guess src=geonames
lin ayr_PN = mkPN "Ayr" ; -- status=guess src=geonames
lin azalea_N = mkN "azalea" ; -- status=guess
lin azide_N = mkN "azoturo" ; -- status=guess
lin azimuth_N = mkN "azimut" ; -- status=guess
lin azimuthal_A = mkA "azimutale" ; -- status=guess
lin azoic_A = mkA "azoico" ; -- status=guess
lin azotic_A = mkA "nitrico" | mkA "nitroso" ; -- UWN
lin azure_A = mkA "azzurro" ; -- status=guess
lin azure_N = mkN "azzurro" ; -- status=guess
lin azurite_N = mkN "azzurrite" feminine ; -- status=guess
lin baa_N = mkN "belato" ; -- status=guess
lin baa_V = mkV "belare" ; -- status=guess, src=wikt
lin baba_N = mkN "babà" ; -- UWN
lin babble_N = mkN "ciancia" ; -- status=guess
lin babble_V = mkV "cicalare" ; -- status=guess, src=wikt
lin babble_V2 = mkV2 (mkV "cicalare") ; -- status=guess, src=wikt
lin babel_N = mkN "babele" | mkN "babilonia" ; -- UWN
lin babirusa_N = mkN "babirussa" masculine ; -- status=guess
lin baboon_N = mkN "babbuino" ; -- status=guess
lin baby_N = L.baby_N ;
lin babysit_V = mkV (I.fare_V) "da babysitter" ; -- status=guess, src=wikt
lin babysitter_N = mkN "baby-sitter" ; -- status=guess
lin baccalaureate_N = mkN "baccalaureato" | mkN "baccellierato" ; -- UWN
lin baccarat_N = mkN "baccarà" ; -- status=guess
lin baccy_N = mkN "tabacco" ; -- UWN
lin bachelor_N = mkN "baccelliere" ; -- status=guess
lin back_A = variants {} ; --
lin back_Adv = mkAdv "indietro" | mkAdv "a posto" ; -- status=guess status=guess
lin back_N = L.back_N ;
lin back_V = mkV (I.fare_V) "retromarcia" | mkV (I.fare_V) "marcia indietro" | retrocedere_V | mkV "indietreggiare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin back_away_V = advV OP_back_V OP_away_Adv ; -- guess-p-verb
lin back_down_V = mkV "retrocedere" ; -- UWN
lin back_into_V3 = variants {} ; -- guess-p-verb
lin back_off_V = mkV "retrocedere" ; -- UWN
lin back_out_V = advV OP_back_V OP_out_Adv ; -- guess-p-verb
lin back_out_of_V2 = prepV2 (advV OP_back_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin back_out_of_V3 = variants {} ; -- guess-p-verb
lin back_up_V = advV OP_back_V OP_up_Adv ; -- guess-p-verb
lin back_up_1_V2 = prepV2 OP_back_V OP_up_Prep ; -- guess-p-verb
lin back_up_2_V2 = prepV2 OP_back_V OP_up_Prep ; -- guess-p-verb
lin backache_N = mkN "mal di schiena" ; -- status=guess
lin backbiter_N = mkN "boccaccia" | mkN "calunniatore" | mkN "diffamatore" | mkN "libellista" ; -- UWN
lin backbone_N = mkN "spina dorsale" ; -- status=guess
lin backcloth_N = mkN "fondale" | mkN "scenario" | mkN "sfondo" ; -- UWN
lin backdrop_N = mkN "scenario" ; -- status=guess
lin backerFem_N = mkN "sovvenzionatore" ; -- UWN
lin backerMasc_N = mkN "sovvenzionatore" ; -- UWN
lin backfire_N = mkN "boomerang" ; -- UWN
lin backfire_V = mkV (avere_V) "effetto contrario" ; -- status=guess, src=wikt
lin backgammon_N = mkN "backgammon" | mkN "tric trac" | mkN "tavola reale" ; -- status=guess status=guess status=guess
lin background_N = mkN "sfondo" ; -- status=guess
lin backhand_N = mkN "rovescio" ; -- UWN
lin backing_N = mkN "appoggio" | mkN "fiancheggiamento" | mkN "patrocinio" | mkN "patronato" ; -- UWN
lin backpack_N = mkN "zaino" ; -- status=guess
lin backside_N = mkN "sedere" masculine ;
lin backslide_V = mkV "decadere" | mkV "degenerare" ; -- UWN
lin backstay_N = mkN "controtirante" masculine ; -- status=guess
lin backstroke_N = mkN "dorso" ; -- UWN
lin backtalk_N = mkN "impertinenza" | mkN "insolenza" ; -- UWN
lin back_up_N = mkN "backup" | mkN "copia di sicurezza" ; -- status=guess status=guess
lin backwards_A = mkA "indietro" ; -- status=guess
lin backwards_Adv = mkAdv "indietro" ; -- UWN
lin backwash_N = mkN "scia" ; -- UWN
lin backwater_N = mkN "acqua di invaso" ; -- status=guess
lin backworth_PN = mkPN "Backworth" ; -- status=guess src=geonames
lin backyard_N = mkN "cortile_posteriore" ; -- UWN
lin bacon_N = mkN "pancetta" ; -- status=guess
lin bacteria_N = mkN "batteri" masculine ; -- status=guess
lin bacterial_A = mkA "bacillare" | mkA "batterico" ; -- UWN
lin bacteriological_A = mkA "batteriologico" ; -- UWN
lin bacteriologist_N = mkN "batteriologo" ; -- UWN
lin bacteriology_N = mkN "batteriologia" ; -- UWN
lin bacteriophage_N = mkN "batteriofago" ; -- UWN
lin bacterium_N = mkN "batterio" ; -- status=guess
lin bacup_PN = mkPN "Bacup" ; -- status=guess src=geonames
lin bad_A = L.bad_A ;
lin bad_N = mkN "iella" | mkN "jella" | mkN "sfiga" | mkN "sfortuna" | mkN "malasorte" ; -- status=guess status=guess status=guess status=guess status=guess
lin badajoz_PN = mkPN "Badajoz" ; -- status=guess src=geonames
lin badalona_PN = mkPN "Badalona" ; -- status=guess src=geonames
lin badge_N = mkN "cartellino" ; -- status=guess
lin badger_N = mkN "tasso" ; -- status=guess
lin badminton_N = mkN "badminton" masculine ; -- status=guess
lin badness_N = mkN "cattiveria" ; -- UWN
lin baffle_N = mkN "deflettore" ; -- UWN
lin baffle_V2 = mkV2 (mkV "sconcertare") ; -- status=guess, src=wikt
lin bag_N = mkN "sacco" | mkN "busta" ; -- status=guess status=guess
lin bagatelle_N = mkN "baggianata" | mkN "inezia" | mkN "minuzia" | mkN "pagliuzza" | mkN "banalità" | mkN "nonnulla" | mkN "pinzillacchera" | mkN "bazzeccola" | mkN "quisquilia" | mkN "sciocchezza" | mkN "cosina" ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin baggage_N = mkN "bagagli" ; -- status=guess
lin baggy_A = mkA "abbondante" | mkA "comodo" ; -- UWN
lin baghdad_PN = mkPN "Baghdad" ; -- status=guess src=geonames
lin bagpipe_N = mkN "cennamella" | mkN "cornamusa" | mkN "piva" | mkN "zampogna" ; -- UWN
lin bahamas_PN = mkPN "Bahamas" ; -- status=guess src=geonames
lin bahrain_PN = mkPN "Bahrain" ; -- status=guess src=geonames
lin baht_N = mkN "baht" | mkN "baht_thailandese" | mkN "tical" | mkN "tical_thailandese" ; -- UWN
lin bail_N = mkN "cauzione" feminine ; -- status=guess
lin bail_V = mkV "sgottare" ; -- status=guess, src=wikt
lin bail_V2 = mkV2 (mkV "sgottare") ; -- status=guess, src=wikt
lin bail_out_V = mkV "sgottare" ; -- UWN
lin bailiff_N = mkN "amministratore" masculine | mkN "supervisore" masculine ; -- status=guess status=guess
lin bailiwick_N = mkN "bailiato" ; -- status=guess
lin bait_N = mkN "esca" ; -- status=guess
lin baiza_N = mkN "baiza" | mkN "baiza_dell'Oman" ; -- UWN
lin bake_V = mkV "cuocersi" | mkV "infornare" ; -- status=guess, src=wikt status=guess, src=wikt
lin bake_V2 = mkV2 (mkV "cuocersi") | mkV2 (mkV "infornare") ; -- status=guess, src=wikt status=guess, src=wikt
lin baker_N = mkN "panettiere" | mkN "panettiera" | mkN "fornaio" | mkN "fornaia" ; -- status=guess status=guess status=guess status=guess
lin bakery_N = mkN "panetteria" | mkN "forno" feminine | mkN "panificio" ; -- status=guess status=guess status=guess
lin baklava_N = mkN "baklava" ; -- status=guess
lin baku_PN = mkPN "Baku" ; -- status=guess src=geonames
lin balaclava_N = mkN "passamontagna" ; -- status=guess
lin balalaika_N = mkN "balalaika" ; -- status=guess
lin balance_N = mkN "equilibrio" ; -- status=guess
lin balance_V = mkV "conguagliare" ; -- status=guess, src=wikt
lin balance_V2 = mkV2 (mkV "conguagliare") ; -- status=guess, src=wikt
lin balanced_A = variants {} ; --
lin balanitis_N = mkN "balanite" feminine ; -- status=guess
lin balcony_N = mkN "balcone" masculine ; -- status=guess
lin bald_A = mkA "calvo" | mkA "pelato" ; -- status=guess status=guess
lin baldachin_N = mkN "baldacchino" ; -- UWN
lin baldness_N = mkN "calvezza" | mkN "calvizie" | mkN "pelata" ; -- UWN
lin baldock_PN = mkPN "Baldock" ; -- status=guess src=geonames
lin bale_N = mkN "balla" ; -- status=guess
lin balk_V = mkV "ostacolare" ; -- status=guess, src=wikt
lin balk_V2 = mkV2 (mkV "ostacolare") ; -- status=guess, src=wikt
lin ball_N = mkN "palla" masculine ; -- status=guess
lin ball_V = mkV "scopare" | mkV "trombare" ; -- status=guess, src=wikt status=guess, src=wikt
lin ball_V2 = mkV2 (mkV "scopare") | mkV2 (mkV "trombare") ; -- status=guess, src=wikt status=guess, src=wikt
lin ballade_N = mkN "ballata" ; -- UWN
lin ballast_N = mkN "regolatore" masculine ; -- status=guess
lin ballerina_N = mkN "ballerina" ; -- status=guess
lin ballet_N = mkN "balletto" ; -- status=guess
lin ballistic_A = mkA "balistico" ; -- UWN
lin ballistics_N = mkN "balistica" ; -- status=guess
lin ballock_N = mkN "coglione" | mkN "corbello" | mkN "didimo" | mkN "palla" | mkN "testicolo" ; -- UWN
lin balloon_N = mkN "palloncino" ; -- status=guess
lin balloonist_N = mkN "aerostiere" ; -- UWN
lin ballot_N = mkN "scheda elettorale" ; -- status=guess
lin ballpark_N = mkN "stadio_di_baseball" ; -- UWN
lin ballpoint_N = mkN "penna a sfera" ; -- status=guess
lin ballroom_N = mkN "sala da ballo" | mkN "balera" ; -- status=guess status=guess
lin ballup_N = mkN "casino" ; -- UWN
lin bally_A = variants {} ;
lin bally_Adv = adjAdv bally_A ; -- derived
lin ballyhoo_N = mkN "battage" ; -- UWN
lin balm_N = mkN "balsamo" | mkN "unguento" ; -- UWN
lin baloney_N = mkN "sciocchezze" ; -- UWN
lin baltimore_PN = mkPN "Baltimora" ; -- status=guess src=geonames
lin baluster_N = mkN "balaustra" ; -- status=guess
lin balustrade_N = mkN "balaustra" | mkN "balaustrata" | mkN "ringhiera" ; -- status=guess status=guess status=guess
lin bamboo_N = mkN "averla formichiera del bambú" ; -- status=guess
lin ban_N = mkN "proibizione" feminine | mkN "divieto" ; -- status=guess status=guess
lin ban_V2 = mkV2 (espellere_V) | mkV2 (mkV "vietare") | mkV2 (mkV "censurare") | mkV2 (mkV "bandire") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin banal_A = mkA "banale" ; -- status=guess
lin banality_N = mkN "banalità" | mkN "cliché" | mkN "luogo_comune" ; -- UWN
lin banana_N = mkN "bananiera" ; -- status=guess
lin banbury_PN = mkPN "Banbury" ; -- status=guess src=geonames
lin band_N = mkN "cerotto" ; -- status=guess
lin bandage_N = mkN "fasciatura" ; -- status=guess
lin bandicoot_N = mkN "peramele" masculine ; -- status=guess
lin banditry_N = mkN "saccheggio" ; -- UWN
lin bandmaster_N = mkN "capobanda" ; -- UWN
lin bandoleer_N = mkN "bandoliera" ; -- status=guess
lin bandolier_N = mkN "armacollo" | mkN "balteo" | mkN "bandoliera" ; -- UWN
lin bandsman_N = mkN "bandista" | mkN "musicante" ; -- UWN
lin bandung_PN = mkPN "Bandung" ; -- status=guess src=geonames
lin bandwidth_N = mkN "larghezza di banda" ; -- status=guess
lin bane_N = mkN "rovina" | mkN "flagello" | mkN "piaga" ; -- status=guess status=guess status=guess
lin bang_N = mkN "esplosione" feminine ; -- status=guess
lin bang_V = variants {} ; --
lin bang_V2 = variants {} ; --
lin bangalore_PN = mkPN "Bangalore" ; -- status=guess src=geonames
lin banger_N = mkN "bagnarola" | mkN "carretta" ; -- status=guess status=guess
lin bangkok_PN = mkPN "Bangkok" ; -- status=guess src=geonames
lin bangladesh_PN = mkPN "Bangladesh" ; -- status=guess src=geonames
lin bangor_PN = mkPN "Bangor" ; -- status=guess src=geonames
lin banish_V2 = mkV2 (mkV "bandire") | mkV2 (mkV "esiliare") ; -- status=guess, src=wikt status=guess, src=wikt
lin banishment_N = mkN "proscrizione" ; -- UWN
lin banister_N = mkN "ringhiera" ; -- status=guess
lin banjo_N = mkN "bangio" | mkN "banjo" ; -- status=guess status=guess
lin bank_1_N = L.bank_N ;
lin bank_2_N = L.bank_N ;
lin bank_V = mkV "depositare" ; -- status=guess, src=wikt
lin bank_V2 = mkV2 (mkV "depositare") ; -- status=guess, src=wikt
lin bank_book_N = mkN "libretto" | mkN "libretto_a_risparmio" | mkN "libretto_di_risparmio" ; -- UWN
lin banker_N = variants {} ; --
lin banking_N = variants {} ; --
lin banknote_N = mkN "banconota" ; -- status=guess
lin bankrupt_A = mkA "fallito" ; -- status=guess
lin bankruptcy_N = mkN "bancarotta" ; -- status=guess
lin banner_A = mkA "eccezionale" | mkA "da urlo" ; -- status=guess status=guess
lin banner_N = mkN "vessillo" ; -- status=guess
lin bannister_N = mkN "appoggiatoio" | mkN "balaustra" | mkN "balaustrata" | mkN "balaustrato" | mkN "bracciolo" | mkN "corrimano" | mkN "mancorrente" | mkN "passamano" | mkN "ringhiera" ; -- UWN
lin bannockburn_PN = mkPN "Bannockburn" ; -- status=guess src=geonames
lin banns_N = mkN "pubblicazioni" feminine ; -- status=guess
lin banquet_N = mkN "pranzo festivo" | mkN "banchetto" ; -- status=guess status=guess
lin banquet_V = mkV "bagordare" | mkV "banchettare" | mkV "bisbocciare" | mkV "convitare" | mkV "convivare" | mkV "crapulare" | mkV "gozzovigliare" ; -- UWN
lin bantam_N = mkN "gallo_bantam" ; -- UWN
lin banteng_N = mkN "banteng" ; -- status=guess
lin bantry_PN = mkPN "Bantry" ; -- status=guess src=geonames
lin baobab_N = mkN "baobab" masculine ; -- status=guess
lin baptism_N = mkN "battesimo" ; -- status=guess
lin baptismal_A = mkA "battesimale" ; -- UWN
lin baptize_V2 = mkV2 (mkV "battezzare") ; -- status=guess, src=wikt
lin bar_1_N = mkN "bar" ;
lin bar_2_N = variants {} ; --
lin bar_N = mkN "Ordine Forense" ; -- status=guess
lin bar_V2 = mkV2 (mkV "vietare") ; -- status=guess, src=wikt
lin barb_N = mkN "beccata" | mkN "botta" | mkN "freccia" | mkN "frecciata" | mkN "stoccata" ; -- UWN
lin barbados_PN = mkPN "Barbados" ; -- status=guess src=geonames
lin barbara_PN = mkPN "Barbara" ; -- status=guess src=geonames
lin barbarian_N = mkN "barbaro" ; -- status=guess
lin barbarism_N = mkN "barbarie" | mkN "brutalità" | mkN "inciviltà" ; -- UWN
lin barbarity_N = mkN "barbarie" | mkN "brutalità" | mkN "inciviltà" ; -- UWN
lin barbarization_N = mkN "imbarbarimento" ; -- UWN
lin barbarize_V2 = mkV2 (mkV "barbarizzare") ; -- status=guess, src=wikt
lin barbecue_N = mkN "salsa barbecue" ; -- status=guess
lin barbed_A = mkA "spinoso" ; -- UWN
lin barbel_N = mkN "barbio" ; -- status=guess
lin barber_N = mkN "barbiere" masculine ; -- status=guess
lin barbette_N = mkN "barbetta" ; -- UWN
lin barbican_N = mkN "barbacane" masculine ; -- status=guess
lin barbital_N = mkN "veronal" ; -- UWN
lin barbitone_N = mkN "veronal" ; -- UWN
lin barbiturate_N = mkN "barbiturato" ; -- status=guess
lin barcelona_PN = mkPN "Barcellona" ; -- status=guess src=geonames
lin bardic_A = mkA "bardito" ; -- UWN
lin bare_A = mkA "nudo" | mkA "nuda" ; -- status=guess status=guess
lin bareback_Adv = mkAdv "a bisdosso" | mkAdv "a pelo" ; -- status=guess status=guess
lin barefoot_A = mkA "scalzo" ; -- status=guess
lin barefoot_Adv = mkAdv "scalzo" ; -- status=guess
lin barely_Adv = adjAdv bare_A ; -- -- derived
lin bargain_N = variants {} ; --
lin bargain_V = mkV "contrattare" | mkV "mercanteggiare" ; -- UWN
lin bargain_V2 = variants {} ; --
lin barge_N = mkN "chiatta" ; -- status=guess
lin barge_in_V = mkV "intromettersi" ; -- UWN
lin bargoed_PN = mkPN "Bargoed" ; -- status=guess src=geonames
lin bari_PN = mkPN "Bari" ; -- status=guess src=geonames
lin baritone_N = mkN "baritono" ; -- status=guess
lin barium_N = mkN "bario" ; -- status=guess
lin bark_N = L.bark_N ; -- comment=CHECKED
lin bark_V = mkV "abbaiare" ; -- status=guess, src=wikt
lin bark_V2 = mkV2 (mkV "abbaiare") ; -- status=guess, src=wikt
lin barking_PN = mkPN "Barking" ; -- status=guess src=geonames
lin barley_N = mkN "orzo" ; -- status=guess
lin barman_N = mkN "barista" | mkN "barman" | mkN "mescitore" ; -- UWN
lin barn_N = mkN "granaio" ; -- status=guess
lin barnet_PN = mkPN "Barnet" ; -- status=guess src=geonames
lin barnoldswick_PN = mkPN "Barnoldswick" ; -- status=guess src=geonames
lin barnsley_PN = mkPN "Barnsley" ; -- status=guess src=geonames
lin barnstaple_PN = mkPN "Barnstaple" ; -- status=guess src=geonames
lin barograph_N = mkN "barografo" ; -- UWN
lin barographic_A = mkA "barografico" ; -- UWN
lin barometer_N = mkN "barometro" ; -- status=guess
lin barometric_A = mkA "barometrico" ; -- status=guess
lin baron_N = mkN "barone" masculine ; -- status=guess
lin baronage_N = mkN "nobiltà" ; -- UWN
lin baroness_N = mkN "baronessa" ; -- status=guess
lin barony_N = mkN "baronia" ; -- status=guess
lin baroque_N = mkN "scaramazza" ; -- status=guess
lin barrack_N = mkN "caserma" | mkN "guarnigione" feminine ; -- status=guess status=guess
lin barracuda_N = mkN "barracuda" ; -- UWN
lin barranquilla_PN = mkPN "Barranquilla" ; -- status=guess src=geonames
lin barrel_N = mkN "barile" masculine | mkN "botte" feminine ; -- status=guess status=guess
lin barren_A = mkA "sterile" | mkA "infruttifero" ; -- status=guess status=guess
lin barren_N = mkN "deserto" ; -- UWN
lin barrette_N = mkN "fermacapelli" ; -- UWN
lin barrhead_PN = mkPN "Barrhead" ; -- status=guess src=geonames
lin barricade_N = mkN "barricata" ; -- status=guess
lin barrier_N = mkN "limite" masculine ; -- status=guess
lin barroom_N = mkN "bar" ; -- UWN
lin barry_PN = mkPN "Barry" ; -- status=guess src=geonames
lin bart_PN = mkPN "Bart" ; -- status=guess src=geonames
lin bartender_N = mkN "barista" | mkN "barman" | mkN "mescitore" ; -- UWN
lin barter_N = mkN "baratto" ; -- status=guess
lin barter_V = mkV "barattare" ; -- status=guess, src=wikt
lin barter_V2 = mkV2 (mkV "barattare") ; -- status=guess, src=wikt
lin barye_N = mkN "microbar" ; -- UWN
lin baryon_N = mkN "barione" masculine ; -- status=guess
lin basalt_N = mkN "basalto" ; -- status=guess
lin base_N = mkN "base" feminine ; -- status=guess
lin base_V = mkV "basare" | mkV "fondare" ; -- UWN
lin base_V2 = variants {} ; --
lin baseball_N = mkN "baseball" masculine ; -- status=guess
lin baseboard_N = mkN "basamento" | mkN "battiscopa" | mkN "salvamuro" | mkN "zoccolo" ; -- UWN
lin basel_PN = mkPN "Basilea" ; -- status=guess src=geonames
lin basement_N = mkN "scantinato" ; -- status=guess
lin baseness_N = mkN "abbiettezza" | mkN "abiettezza" | mkN "spregevolezza" ; -- UWN
lin basenji_N = mkN "basenji" | mkN "cane_del_Congo" ; -- UWN
lin bash_N = mkN "botta" | mkN "colpo" | mkN "urto" ; -- UWN
lin bashful_A = mkA "vergognoso" | mkA "timido" | mkA "modesto" ; -- status=guess status=guess status=guess
lin basic_A = mkA "basico" ; -- status=guess
lin basically_Adv = mkAdv "praticamente" | mkAdv "in pratica" | mkAdv "basicamente" ; -- status=guess status=guess status=guess
lin basics_N = mkN "caposaldo" | mkN "fondamento" ; -- UWN
lin basidium_N = mkN "basidio" ; -- UWN
lin basil_N = mkN "basilico" ; -- status=guess
lin basildon_PN = mkPN "Basildon" ; -- status=guess src=geonames
lin basilica_N = mkN "basilica" ; -- status=guess
lin basilisk_N = mkN "basilisco" ; -- status=guess
lin basin_N = mkN "bacino" ; -- status=guess
lin basingstoke_PN = mkPN "Basingstoke" ; -- status=guess src=geonames
lin basis_N = mkN "base" feminine ; -- status=guess
lin basket_N = mkN "canestro" ; -- status=guess
lin basketball_N = mkN "pallacanestro" feminine ; -- status=guess
lin basketweaver_N = mkN "canestraio" | mkN "cestaio" | mkN "panieraio" ; -- UWN
lin basophilic_A = mkA "basofilo" ; -- status=guess
lin bass_A = mkA "basso" ; -- status=guess
lin bass_N = mkN "clarinetto basso" ; -- status=guess
lin basset_N = mkN "corno di bassetto" ; -- status=guess
lin bassoon_N = mkN "fagotto" ; -- status=guess
lin bassoonist_N = mkN "fagottista" ; -- status=guess
lin bastard_N = mkN "bastardo" | mkN "figlio di puttana" ; -- status=guess status=guess
lin bastardy_N = mkN "bastardaggine" | mkN "illegittimità" ; -- UWN
lin baste_N = mkN "imbastitura" ; -- UWN
lin bat_N = mkN "pipistrello" ; -- status=guess
lin batch_N = mkN "infornata" ; -- status=guess
lin bath_N = mkN "bagno" feminine ; -- status=guess
lin bath_PN = mkPN "Bath" ; -- status=guess src=geonames
lin bathe_V = mkV "bagnarsi" ; -- UWN
lin bathgate_PN = mkPN "Bathgate" ; -- status=guess src=geonames
lin bathing_N = mkN "abluzione" ; -- UWN
lin batholith_N = mkN "batolite" ; -- UWN
lin bathrobe_N = mkN "accappatoio" ; -- status=guess
lin bathroom_N = mkN "toiletta" ; -- status=guess
lin bathtub_N = mkN "bagno" feminine | mkN "vasca da bagno" ; -- status=guess status=guess
lin bathymetric_A = mkA "batimetrico" ; -- status=guess
lin bathymetry_N = mkN "batimetria" | mkN "batometria" ; -- status=guess status=guess
lin bathyscaphe_N = mkN "batiscafo" ; -- status=guess
lin bathysphere_N = mkN "batisfera" ; -- status=guess
lin batik_N = mkN "batic" | mkN "batik" ; -- UWN
lin batiste_N = mkN "batista" | mkN "battista" ; -- UWN
lin batley_PN = mkPN "Batley" ; -- status=guess src=geonames
lin batman_N = mkN "attendente" masculine ; -- status=guess
lin baton_N = mkN "testimone" masculine ; -- status=guess
lin battalion_N = mkN "battaglione" ; -- UWN
lin batter_N = mkN "impasto" | mkN "pastella" ; -- status=guess status=guess
lin batter_V = mkV "battere" ; -- status=guess, src=wikt
lin batter_V2 = mkV2 (mkV "battere") ; -- status=guess, src=wikt
lin battering_N = mkN "ariete" masculine ; -- status=guess
lin battery_1_N = mkN "pila" ; -- status=guess
lin battery_2_N = mkN "pila" ; -- status=guess
lin battle_N = mkN "battaglia" masculine ; -- status=guess
lin battle_V = mkV "combattere" | mkV "tenzonare" ; -- UWN
lin battle_V2 = variants {} ; --
lin battlefield_N = mkN "campo di battaglia" ; -- status=guess
lin battlefront_N = mkN "fronte" | mkN "prima_linea" ; -- UWN
lin battleground_N = mkN "campo_di_battaglia" ; -- UWN
lin battlement_N = mkN "merlatura" ; -- UWN
lin battleship_N = mkN "corazzata" | mkN "nave corazzata" ; -- status=guess status=guess
lin battue_N = mkN "ecatombe" ; -- UWN
lin baud_N = mkN "baud" ; -- UWN
lin baulk_N = mkN "puntone" ; -- UWN
lin baulk_V = mkV "impuntarsi" ; -- UWN
lin bauxite_N = mkN "bauxite" feminine ; -- status=guess
lin bay_N = mkN "baia" | mkN "golfo" ; -- status=guess status=guess
lin bay_V = mkV "latrare" ; -- UWN
lin bayonet_N = mkN "baionetta" ; -- status=guess
lin bazaar_N = mkN "bazar" | mkN "mercato" ; -- status=guess status=guess
lin beach_N = mkN "spiaggia" ; -- status=guess
lin beach_V2 = mkV2 (mkV "spiaggiare") ; -- status=guess, src=wikt
lin beacon_N = mkN "baluardo" ; -- status=guess
lin beaconsfield_PN = mkPN "Beaconsfield" ; -- status=guess src=geonames
lin bead_N = mkN "grano" | mkN "perlina" ; -- status=guess status=guess
lin beadle_N = mkN "chierico" | mkN "sagrestano" ; -- status=guess status=guess
lin beady_A = mkA "ingemmato" | mkA "ingioiellato" ; -- UWN
lin beagle_N = mkN "beagle" ; -- UWN
lin beak_N = mkN "becco" ; -- status=guess
lin beaker_N = mkN "bicchiere" masculine | mkN "becher" masculine ; -- status=guess status=guess
lin beam_N = mkN "braccio" ; -- status=guess
lin bean_N = mkN "fagiolo" ; -- status=guess
lin beano_N = mkN "bingo" | mkN "tombola" ; -- UWN
lin bear_N = mkN "cucciolo di orso" | mkN "orsetto" ; -- status=guess status=guess
lin bear_V = mkV "portare" ; -- status=guess, src=wikt
lin bear_V2 = mkV2 (mkV "portare") ; -- status=guess, src=wikt
lin bear_down_on_V2 = prepV2 (advV OP_bear_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin bear_on_V2 = prepV2 OP_bear_V OP_on_Prep ; -- guess-p-verb
lin bear_out_V2 = prepV2 OP_bear_V OP_out_Prep ; -- guess-p-verb
lin bear_up_V = advV OP_bear_V OP_up_Adv ; -- guess-p-verb
lin bear_up_under_V2 = prepV2 (advV OP_bear_V OP_up_Adv ) OP_under_Prep ; -- guess-p-verb
lin bear_with_V2 = prepV2 OP_bear_V OP_with_Prep ; -- guess-p-verb
lin beard_N = mkN "barba" ; -- status=guess
lin bearer_N = mkN "portatore" masculine ; -- status=guess
lin bearing_N = mkN "cuscinetto" ; -- status=guess
lin bearsden_PN = mkPN "Bearsden" ; -- status=guess src=geonames
lin bearskin_N = mkN "colbac" | mkN "colbacco" ; -- UWN
lin beast_N = mkN "bestia" ; -- status=guess
lin beastly_A = variants {} ;
lin beastly_Adv = adjAdv beastly_A ; -- derived -- derived
lin beat_N = mkN "ritmo" ; -- status=guess
lin beat_V = mkV (mkV "menare") "il can per l'aia" ; -- status=guess, src=wikt
lin beat_V2 = mkV2 (mkV (mkV "menare") "il can per l'aia") ; -- status=guess, src=wikt
lin beat_back_V = mkV "allontanare" | mkV "respingere" | mkV "scacciare" ; -- UWN
lin beat_down_V = advV OP_beat_V OP_down_Adv ; -- guess-p-verb
lin beat_down_V2 = prepV2 OP_beat_V OP_down_Prep ; -- guess-p-verb
lin beat_out_V2 = prepV2 OP_beat_V OP_out_Prep ; -- guess-p-verb
lin beat_up_V2 = prepV2 OP_beat_V OP_up_Prep ; -- guess-p-verb
lin beaten_A = mkA "sbattuto" ; -- UWN
lin beater_N = mkN "frullatore" masculine | mkN "battitore" masculine ; -- status=guess status=guess
lin beatify_V2 = mkV2 (mkV "beatificare") ; -- status=guess, src=wikt
lin beating_N = mkN "bastonata" ; -- status=guess
lin beatitude_N = mkN "beatitudine" feminine ; -- status=guess
lin beatnik_N = mkN "beat" | mkN "capellone" ; -- UWN
lin beatrice_PN = mkPN "Beatrice" ; -- status=guess src=geonames
lin beau_N = mkN "amoroso" | mkN "damo" | mkN "fidanzato" | mkN "innamorato" | mkN "ragazzo" ; -- UWN
lin beaumaris_PN = mkPN "Beaumaris" ; -- status=guess src=geonames
lin beautician_N = mkN "cosmetista" | mkN "estetista" ; -- UWN
lin beautiful_A = L.beautiful_A ;
lin beautify_V2 = mkV2 (mkV "abbellire") ; -- status=guess, src=wikt
lin beauty_N = mkN "bellezza" ; -- status=guess
lin beaver_N = mkN "castoro" ; -- status=guess
lin bebington_PN = mkPN "Bebington" ; -- status=guess src=geonames
lin because_Subj = S.because_Subj ;
lin beccles_PN = mkPN "Beccles" ; -- status=guess src=geonames
lin become_V = mkV "diventare" ; -- status=guess, src=wikt
lin become_V2 = mkV2 (mkV "diventare") ; -- status=guess, src=wikt
lin become_VA = L.become_VA ;
lin bed_N = mkN "letto" feminine | mkN "giaciglio" ; -- status=guess status=guess
lin bed_V2 = mkV2 (mkV (andare_V) "a dormire") ; -- status=guess, src=wikt
lin bedbug_N = mkN "cimice" feminine ; -- status=guess
lin beddau_PN = mkPN "Beddau" ; -- status=guess src=geonames
lin bedford_PN = mkPN "Bedford" ; -- status=guess src=geonames
lin bedlington_PN = mkPN "Bedlington" ; -- status=guess src=geonames
lin bedpan_N = mkN "padella" ; -- UWN
lin bedridden_A = mkA "degente" | mkA "allettato" ; -- status=guess status=guess
lin bedrock_N = mkN "caposaldo" | mkN "fondamento" ; -- UWN
lin bedroom_N = mkN "camera da letto" | mkN "camera" ; -- status=guess status=guess
lin bedside_N = mkN "capezzale" ; -- UWN
lin bedsore_N = mkN "piaga_da_decubito" ; -- UWN
lin bedwas_PN = mkPN "Bedwas" ; -- status=guess src=geonames
lin bee_N = mkN "ape" feminine ; -- status=guess
lin beech_N = mkN "faggio" ; -- status=guess
lin beechnut_N = mkN "faggiola" | mkN "faggina" ; -- status=guess status=guess
lin beef_1_N = mkN "manzo" ; -- status=guess
lin beef_2_N = mkN "manzo" ; -- status=guess
lin beefsteak_N = mkN "bistecca" ; -- status=guess
lin beefy_A = mkA "carnoso" ; -- status=guess
lin beehive_N = mkN "alveare" | mkN "arnia" ; -- status=guess status=guess
lin beekeeper_N = mkN "apicoltore" | mkN "apicultore" | mkN "apicultrice" feminine ; -- status=guess status=guess status=guess
lin beekeeping_N = mkN "apicoltura" ; -- status=guess
lin beer_N = L.beer_N ;
lin beeswax_N = mkN "cera d'api" ; -- status=guess
lin beet_N = mkN "bietola" | mkN "bieta" ; -- status=guess status=guess
lin beetle_N = mkN "coleottero" | mkN "scarabeo" ; -- status=guess status=guess
lin beetroot_N = mkN "barbabietola" ; -- status=guess
lin befall_V = mkV "accadere" | mkV "andare" | mkV "incogliere" ; -- UWN
lin before_Adv = mkAdv "prima" ; -- status=guess
lin before_Prep = S.before_Prep ;
lin before_Subj = subSubj "primo che" ;
lin beforehand_Adv = mkAdv "preventivamente" | mkAdv "prima" ; -- UWN
lin beg_V = mkV "mendicare" | mkV "elemosinare" ; -- status=guess, src=wikt status=guess, src=wikt
lin beg_V2 = mkV2 (mkV "mendicare") | mkV2 (mkV "elemosinare") ; -- status=guess, src=wikt status=guess, src=wikt
lin beg_V2V = L.beg_V2V ; -- comment=CHECKED
lin beget_V2 = mkV2 (mkV "generare") ; -- status=guess, src=wikt
lin begetter_N = mkN "padre" ; -- UWN
lin beggar_N = mkN "accattapane" | mkN "accattatozzi" | mkN "accattone" | mkN "mendicante" | mkN "mendico" | mkN "paltone" | mkN "paltoniere" | mkN "pezzente" | mkN "questuante" ; -- UWN
lin beggarwoman_N = mkN "accattona" ; -- UWN
lin begin_V = mkV "cominciare" ;
lin begin_V2 = mkV2 (mkV "cominciare") | mkV2 (mkV "iniziare") ;
lin beginning_N = mkN "inizio" ; -- status=guess
lin begonia_N = mkN "begonia" ; -- status=guess
lin beguile_V2 = mkV2 (mkV "incantare") | mkV2 (mkV "distogliere") | mkV2 (sedurre_V) ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin beguilement_N = mkN "distrazione" | mkN "diversivo" ; -- UWN
lin behalf_N = variants {} ; --
lin behave_V = mkV "comportarsi" ; -- status=guess, src=wikt
lin behavior_N = mkN "comportamento" ; -- status=guess
lin behavioral_A = mkA "comportamentale" ; -- UWN
lin behavioristic_A = mkA "behaviouristico" ; -- UWN
lin behaviour_N = mkN "comportamento" | mkN "condotta" ; -- status=guess status=guess
lin behaviourism_N = mkN "comportamentismo" ; -- status=guess
lin behaviourist_N = mkN "behaviorista" | mkN "comportamentista" ; -- UWN
lin behead_V2 = mkV2 (mkV "decapitare") ; -- status=guess, src=wikt
lin behest_N = mkN "comando" feminine | mkN "ordine" masculine ; -- status=guess status=guess
lin behind_Adv = variants {} ; -- S.behind_Prep ;
lin behind_Prep = S.behind_Prep ;
lin behold_V2 = mkV2 (mkV "guardare") ; -- status=guess, src=wikt
lin beige_A = mkA "bigio" ; -- status=guess
lin beige_N = mkN "beige" ; -- status=guess
lin being_N = mkN "essere" | mkN "creatura" ; -- status=guess status=guess
lin beirut_PN = mkPN "Beirut" ; -- status=guess src=geonames
lin beith_PN = mkPN "Beith" ; -- status=guess src=geonames
lin belated_A = mkA "tardivo" ; -- status=guess
lin belch_N = mkN "rutto" ; -- status=guess
lin belch_V = mkV "ruttare" ; -- status=guess, src=wikt
lin belch_V2 = mkV2 (mkV "ruttare") ; -- status=guess, src=wikt
lin belfast_PN = mkPN "Belfast" ; -- status=guess src=geonames
lin belfry_N = mkN "campanile" masculine ; -- status=guess
lin belgian_A = mkA "belga" ;
lin belgium_PN = mkPN "Belgio" ;
lin belgrade_PN = mkPN "Belgrado" ; -- status=guess src=geonames
lin belie_V2 = mkV2 (mkV "smentire") ; -- status=guess, src=wikt
lin belief_N = mkN "fiducia" ; -- status=guess
lin believable_A = mkA "attendibile" | mkA "credibile" | mkA "fededegno" | mkA "veridico" ; -- UWN
lin believe_V = mkV "credere" ; -- status=guess, src=wikt
lin believe_V2 = mkV2 (mkV "credere") ; -- status=guess, src=wikt
lin believe_VS = mkVS (mkV "credere") ; -- status=guess, src=wikt
lin believer_N = mkN "credente" masculine ; -- status=guess
lin belike_Adv = mkAdv "facilmente" | mkAdv "probabilmente" ; -- UWN
lin belittle_V2 = mkV2 (mkV "sminuire") ; -- status=guess, src=wikt
lin bell_N = mkN "sonagliera" ; -- status=guess
lin bella_PN = mkPN "Bella" ; -- status=guess src=geonames
lin belladonna_N = mkN "belladonna" ; -- UWN
lin bellboy_N = mkN "boy" masculine ; -- status=guess
lin belle_N = mkN "bella" | mkN "bellezza" ; -- UWN
lin belle_PN = mkPN "Belle" ; -- status=guess src=geonames
lin bellhop_N = mkN "boy" | mkN "fattorino" ; -- UWN
lin belligerence_N = mkN "belligeranza" ; -- status=guess
lin belligerent_A = mkA "bellicoso" ; -- status=guess
lin belligerent_N = mkN "belligerante" masculine ; -- status=guess
lin bellow_V = mkV "muggire" | mkV "ruggire" ; -- status=guess, src=wikt status=guess, src=wikt
lin bellow_V2 = mkV2 (mkV "muggire") | mkV2 (mkV "ruggire") ; -- status=guess, src=wikt status=guess, src=wikt
lin bellows_N = mkN "soffietto" ; -- status=guess
lin bellshill_PN = mkPN "Bellshill" ; -- status=guess src=geonames
lin belly_N = L.belly_N ;
lin bellyache_N = mkN "mal di pancia" ; -- status=guess
lin belo_horizonte_PN = mkPN "Belo Horizonte" ; -- status=guess src=geonames
lin belonging_N = mkN "appartenenza" ; -- UWN
lin beloved_A = mkA "amato" | mkA "caro" ; -- UWN
lin below_Adv = mkAdv "sotto zero" ; -- status=guess
lin below_Prep = variants {} ; --
lin belper_PN = mkPN "Belper" ; -- status=guess src=geonames
lin belt_N = mkN "cintura" ; -- status=guess
lin belt_V2 = mkV2 (mkV "allacciare") ; -- status=guess, src=wikt
lin beltway_N = mkN "circonvallazione" | mkN "tangenziale" ; -- UWN
lin belvedere_N = mkN "belvedere" ; -- UWN
lin bemused_A = mkA "confuso" ; -- UWN
lin bench_N = mkN "banco" | mkN "panca" ; -- status=guess status=guess
lin benchmark_N = mkN "riferimento" ; -- status=guess
lin bend_N = mkN "ansa" | mkN "curva" ; -- UWN
lin bend_V = mkV "piegarsi" | mkV "curvarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin bend_V2 = mkV2 (mkV "piegarsi") | mkV2 (mkV "curvarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin bend_down_V = advV OP_bend_V OP_down_Adv ; -- guess-p-verb
lin bend_over_V = advV OP_bend_V OP_over_Adv ; -- guess-p-verb
lin bend_over_backwards_V = variants {} ; -- guess-p-verb
lin bendability_N = mkN "flessibilità" | mkN "malleabilità" ; -- UWN
lin bender_N = mkN "frocio" ; -- status=guess
lin beneath_Adv = mkAdv "sotto" ; -- status=guess
lin beneath_Prep = variants {} ; --
lin benedictine_N = mkN "benedettino" ; -- UWN
lin benediction_N = mkN "benedizione" feminine ; -- status=guess
lin benefice_N = mkN "beneficio_ecclesiastico" ; -- UWN
lin beneficence_N = mkN "beneficenza" ; -- status=guess
lin beneficial_A = mkA "benefico" ; -- status=guess
lin beneficiary_A = mkA "beneficiario" ; -- UWN
lin beneficiary_N = variants {} ; --
lin benefit_N = mkN "beneficio" ; -- status=guess
lin benefit_V = mkV "beneficiare" ; -- UWN
lin benefit_V2 = variants {} ; --
lin benignity_N = mkN "amorevolezza" | mkN "attenzione" | mkN "atto_di_cortesia" | mkN "carità" | mkN "cortesia" | mkN "favore" | mkN "gentilezza" | mkN "premura" ; -- UWN
lin benin_PN = mkPN "Benin" ; -- status=guess src=geonames
lin benjamin_PN = mkPN "Benjamin" ; -- status=guess src=geonames
lin bent_N = mkN "attitudine" | mkN "facilità" | mkN "vocazione" ; -- UWN
lin benthic_A = mkA "bentonico" ; -- status=guess
lin bentonite_N = mkN "bentonite" feminine ; -- status=guess
lin benzene_N = mkN "benzene" | mkN "benzolo" ; -- status=guess status=guess
lin benzine_N = mkN "benzina" ; -- status=guess
lin benzoate_N = mkN "benzoato" ; -- status=guess
lin benzoic_A = mkA "benzoico" ; -- status=guess
lin benzol_N = mkN "benzolo" ; -- status=guess
lin benzylic_A = mkA "benzilico" ; -- status=guess
lin bequeath_V2 = mkV2 (mkV "donare") | mkV2 (mkV "offrire") ; -- status=guess, src=wikt status=guess, src=wikt
lin bequest_N = mkN "eredità" feminine ; -- status=guess
lin berating_N = mkN "rimprovero" ; -- UWN
lin bereave_V2 = mkV2 (mkV "privare") ; -- status=guess, src=wikt
lin bereavement_N = mkN "cordoglio" | mkN "lutto" | mkN "perdita" ; -- UWN
lin beret_N = mkN "basco" ; -- status=guess
lin berg_N = mkN "iceberg" ; -- UWN
lin bergamo_PN = mkPN "Bergamo" ; -- status=guess src=geonames
lin bergamot_N = mkN "bergamotto" | mkN "bergamotta" ; -- status=guess status=guess
lin bergen_PN = mkPN "Bergen" ; -- status=guess src=geonames
lin berkelium_N = mkN "berkelio" ; -- status=guess
lin berkhamsted_PN = mkPN "Berkhamsted" ; -- status=guess src=geonames
lin berlin_PN = mkPN "Berlino" ; -- status=guess src=geonames
lin bermuda_PN = mkPN "Bermuda" ; -- status=guess src=geonames
lin bern_PN = mkPN "Berna" ; -- status=guess src=geonames
lin bernie_PN = mkPN "Bernie" ; -- status=guess src=geonames
lin berry_N = mkN "bacca" | mkN "coccola" ; -- status=guess status=guess
lin berserk_A = mkA "furioso" | mkA "folle" | mkA "frenetico" ; -- status=guess status=guess status=guess
lin berth_N = mkN "cuccetta" ; -- status=guess
lin berth_V = mkV "attraccare" ; -- status=guess, src=wikt
lin berth_V2 = mkV2 (mkV "attraccare") ; -- status=guess, src=wikt
lin beryl_N = mkN "berillo" ; -- status=guess
lin beryllium_N = mkN "berillio" ; -- status=guess
lin beseech_V2 = mkV2 (mkV "supplicare") | mkV2 (mkV "implorare") ; -- status=guess, src=wikt status=guess, src=wikt
lin beseeching_A = mkA "implorante" | mkA "supplicante" | mkA "supplice" | mkA "supplichevole" ; -- UWN
lin beset_V2 = mkV2 (mkV "assediare") | mkV2 (mkV "assaltare") ; -- status=guess, src=wikt status=guess, src=wikt
lin beside_Prep = variants {} ; --
lin besides_Adv = mkAdv "inoltre" ; -- status=guess
lin besides_Prep = variants {} ; --
lin besiege_V2 = mkV2 (mkV "assediare") ; -- status=guess, src=wikt
lin besieger_N = mkN "assediante" | mkN "assediatore" ; -- UWN
lin besmirch_V2 = mkV2 (mkV "sporcare") | mkV2 (mkV "insudiciare") | mkV2 (mkV "lordare") | mkV2 (mkV "insozzare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin besom_N = mkN "scopa di saggina" ; -- status=guess
lin best_Adv = variants {} ; --
lin best_N = mkN "testimone" masculine | mkN "testimone di nozze" ; -- status=guess status=guess
lin best_V2 = mkV2 (mkV "superare") | mkV2 (mkV "dominare") | mkV2 (vincere_V) ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bestow_V2 = mkV2 (mkV "donare") | mkV2 (mkV "elargire") | mkV2 (mkV "conferire") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bet_N = mkN "scommessa" ; -- status=guess
lin bet_V = scommettere_V ; -- status=guess, src=wikt
lin bet_V2 = mkV2 (scommettere_V) ; -- status=guess, src=wikt
lin bet_VS = mkVS (scommettere_V) ; -- status=guess, src=wikt
lin beta_N = mkN "beta" ; -- status=guess
lin betray_V2 = mkV2 (mkV "consegnare") ; -- status=guess, src=wikt
lin betrayer_N = mkN "traditore" masculine | mkN "sicofante" masculine ; -- status=guess status=guess
lin betroth_V2 = mkV2 (mkV "fidanzare") ; -- status=guess, src=wikt
lin betrothedFem_N = variants {} ; ---- sense to be split
lin betrothedMasc_N = variants {} ; ---- sense to be split
lin better_A = mkA "migliore" ; -- status=guess
lin better_Adv = mkAdv "meglio" ; -- status=guess
lin bettor_N = mkN "scommettitore" ; -- UWN
lin between_Prep = S.between_Prep ;
lin bevatron_N = mkN "bevatrone" ; -- UWN
lin bevel_N = mkN "bisello" ; -- status=guess
lin beverage_N = mkN "bevanda" ; -- status=guess
lin beverley_PN = mkPN "Beverley" ; -- status=guess src=geonames
lin bevy_N = mkN "stormo" | mkN "volata" | mkN "passo" ; -- status=guess status=guess status=guess
lin bewdley_PN = mkPN "Bewdley" ; -- status=guess src=geonames
lin bewilder_V2 = mkV2 (confondere_V) ; -- status=guess, src=wikt
lin bewilderment_N = mkN "sfasamento" | mkN "smarrimento" ; -- UWN
lin bexley_PN = mkPN "Bexley" ; -- status=guess src=geonames
lin beyond_Adv = variants {} ; --
lin beyond_Prep = variants {} ; --
lin bezant_N = mkN "bisante" ; -- UWN
lin bezel_N = mkN "incastonatura" ; -- status=guess
lin bhutan_PN = mkPN "Bhutan" ; -- status=guess src=geonames
lin biannually_Adv = mkAdv "semestralmente" ; -- UWN
lin bias_N = mkN "polarizzazione" feminine ; -- status=guess
lin bib_N = mkN "bavaglino" | mkN "bavaglio" ; -- status=guess status=guess
lin bible_N = variants {} ; --
lin bibliographer_N = mkN "bibliografo" ; -- UWN
lin bibliographic_A = mkA "bibliografico" ; -- status=guess
lin bibliography_N = mkN "bibliografia" ; -- status=guess
lin bibliomania_N = mkN "bibliomania" ; -- UWN
lin bibliophile_N = mkN "bibliofilo" ; -- UWN
lin bicameral_A = mkA "bicamerale" ; -- status=guess
lin bicarbonate_N = mkN "bicarbonato" ; -- status=guess
lin bicentennial_A = mkA "bicentenario" ; -- UWN
lin biceps_N = mkN "bicipite" masculine ; -- status=guess
lin bicester_PN = mkPN "Bicester" ; -- status=guess src=geonames
lin bichromate_N = mkN "bicromato" ; -- UWN
lin bicorn_N = mkN "bicorno" ; -- status=guess
lin bicycle_N = mkN "bicicletta" | mkN "bici" ; -- status=guess status=guess
lin bicycle_V = mkV "pedalare" ; -- UWN
lin bid_N = mkN "offerta" ; -- status=guess
lin bid_V = mkV (I.fare_V) "un'offerta per un'asta" ; -- status=guess, src=wikt
lin bid_V2 = mkV2 (mkV (I.fare_V) "un'offerta per un'asta") ; -- status=guess, src=wikt
lin bidding_N = mkN "dichiarazione" | mkN "licitazione" ; -- UWN
lin biddulph_PN = mkPN "Biddulph" ; -- status=guess src=geonames
lin bideford_PN = mkPN "Bideford" ; -- status=guess src=geonames
lin bidet_N = mkN "bidè" | mkN "bidet" masculine ; -- status=guess status=guess
lin bidirectional_A = mkA "bidezionale" ; -- status=guess
lin bielefeld_PN = mkPN "Bielefeld" ; -- status=guess src=geonames
lin biennial_A = mkA "biennale" ; -- UWN
lin bier_N = mkN "barella" ; -- status=guess
lin biff_N = mkN "cazzotto" | mkN "pugno" ; -- UWN
lin big_A = L.big_A ;
lin bigamist_N = mkN "bigamo" ; -- status=guess
lin biggleswade_PN = mkPN "Biggleswade" ; -- status=guess src=geonames
lin bigot_N = mkN "esclusivista" | mkN "intollerante" | mkN "pietista" | mkN "pinzochero" ; -- UWN
lin bigotry_N = mkN "bacchettonaggine" | mkN "bacchettoneria" | mkN "beghinaggio" | mkN "bigotteria" | mkN "bigottismo" | mkN "santocchieria" ; -- UWN
lin bigwig_N = mkN "capoccione" ; -- UWN
lin bike_N = L.bike_N ;
lin bike_V = mkV "pedalare" ; -- UWN
lin bikini_N = mkN "bikini" masculine ; -- status=guess
lin bilabial_A = mkA "bilabiale" ; -- status=guess
lin bilabiate_A = mkA "bilabiato" ; -- status=guess
lin bilateral_A = mkA "bilaterale" | mkA "bilatero" ; -- UWN
lin bilateralism_N = mkN "bilateralità" ; -- UWN
lin bilaterality_N = mkN "bilateralità" ; -- UWN
lin bilbao_PN = mkPN "Bilbao" ; -- status=guess src=geonames
lin bilberry_N = mkN "mirtillo" ; -- status=guess
lin bile_N = mkN "acido biliare" ; -- status=guess
lin bilge_N = mkN "sentina" ; -- status=guess
lin biliary_A = mkA "biliare" ; -- status=guess
lin bilinear_A = mkA "bilineare" ; -- status=guess
lin bilingual_A = mkA "bilingue" ; -- status=guess
lin bilious_A = mkA "bilioso" ; -- status=guess
lin biliousness_N = mkN "caratteraccio" | mkN "intrattabilità" | mkN "irritabilità" | mkN "ispidezza" | mkN "misantropia" | mkN "orsaggine" | mkN "riserbatezza" | mkN "riservatezza" | mkN "ruvidezza" | mkN "scontrosità" ; -- UWN
lin bilirubin_N = mkN "bilirubina" ; -- UWN
lin bill_N = mkN "poster" | mkN "cartello pubblicitario" ; -- status=guess status=guess
lin billboard_N = mkN "cartellone" masculine ; -- status=guess
lin billericay_PN = mkPN "Billericay" ; -- status=guess src=geonames
lin billfold_N = mkN "portafogli" | mkN "portafoglio" ; -- UWN
lin billhook_N = mkN "roncola" | mkN "falcetto" ; -- status=guess status=guess
lin billiards_N = mkN "biliardi" masculine ; -- status=guess
lin billington_PN = mkPN "Billington" ; -- status=guess src=geonames
lin billion_N = mkN "miliardo" ; -- status=guess
lin billow_N = mkN "cavallone" | mkN "maroso" | mkN "ondata" ; -- UWN
lin billy_N = mkN "caprone" | mkN "becco" | mkN "capro" | mkN "irco" ; -- status=guess status=guess status=guess status=guess
lin bilocation_N = mkN "bilocazione" feminine ; -- status=guess
lin bimestrial_A = mkA "bimestrale" ; -- UWN
lin bimetal_N = mkN "bimetallo" ; -- UWN
lin bimetallic_A = mkA "bimetallico" ; -- UWN
lin bimetallism_N = mkN "bimetallismo" ; -- UWN
lin bimetallistic_A = mkA "bimetallico" ; -- UWN
lin bimonthly_Adv = mkAdv "tutti i due mesi" ; -- status=guess
lin bin_N = mkN "bidone" masculine ; -- status=guess
lin binary_A = mkA "binario" ; -- status=guess
lin binary_N = mkN "relazione binaria" ; -- status=guess
lin bind_V = mkV "legare" ; -- status=guess, src=wikt
lin bind_V2 = mkV2 (mkV "legare") ; -- status=guess, src=wikt
lin binding_A = variants {} ; --
lin binding_N = mkN "rilegatura" ; -- status=guess
lin bindweed_N = mkN "vilucchio" | mkN "convolvolo" ; -- status=guess status=guess
lin binge_N = mkN "bisboccia" ; -- status=guess
lin bingley_PN = mkPN "Bingley" ; -- status=guess src=geonames
lin bingo_N = mkN "bingo" ; -- status=guess
lin binnacle_N = mkN "abitacolo" | mkN "chiesuola" ; -- UWN
lin binocular_A = mkA "binoculare" ; -- status=guess
lin binoculars_N = mkN "binocolo" ; -- status=guess
lin binomial_A = mkA "binomiale" ; -- status=guess
lin binomial_N = mkN "binomio" ; -- status=guess
lin binucleate_A = mkA "binucleare" ; -- UWN
lin biocatalyst_N = mkN "biocatalizzatore" ; -- UWN
lin biochemical_A = mkA "biochimico" ; -- status=guess
lin biochemist_N = mkN "biochimico" | mkN "biochimica" ; -- status=guess status=guess
lin biochemistry_N = mkN "biochimica" ; -- status=guess
lin bioclimatic_A = mkA "bioclimatico" ; -- UWN
lin bioclimatology_N = mkN "bioclimatologia" ; -- status=guess
lin biodiversity_N = mkN "biodiversità" feminine ; -- status=guess
lin bioelectricity_N = mkN "bioelettricità" feminine ; -- status=guess
lin biogenic_A = mkA "biogeno" | mkA "biogenico" ; -- status=guess status=guess
lin biogeography_N = mkN "biogeografia" ; -- status=guess
lin biographer_N = mkN "biografo" ; -- status=guess
lin biographic_A = mkA "biografico" ; -- UWN
lin biographical_A = mkA "biografico" ; -- status=guess
lin biography_N = mkN "biografia" ; -- status=guess
lin biological_A = mkA "consanguineo" | mkA "consanguinea" ; -- status=guess status=guess
lin biologist_N = mkN "biologo" ; -- UWN
lin biology_N = mkN "biologia" ; -- status=guess
lin bioluminescence_N = mkN "bioluminescenza" ; -- status=guess
lin biomass_N = mkN "biomassa" ; -- status=guess
lin biome_N = mkN "bioma" masculine ; -- status=guess
lin bionics_N = mkN "bionica" ; -- UWN
lin biophysicist_N = mkN "biofisico" ; -- UWN
lin biophysics_N = mkN "biofisica" ; -- UWN
lin biopsy_N = mkN "biopsia" ; -- status=guess
lin biosphere_N = mkN "biosfera" ; -- status=guess
lin biosynthesis_N = mkN "biosintesi" ; -- UWN
lin biotechnology_N = mkN "biotecnologia" ; -- status=guess
lin biotic_A = mkA "biotico" ; -- status=guess
lin biotin_N = mkN "biotina" ; -- status=guess
lin biotite_N = mkN "biotite" feminine ; -- status=guess
lin biotype_N = mkN "biotipo" ; -- UWN
lin biped_N = mkN "bipede" ; -- UWN
lin bipedal_A = mkA "bipede" ; -- UWN
lin bipinnate_A = mkA "bipennato" ; -- status=guess
lin bipolar_A = mkA "bipolare" ; -- status=guess
lin biprism_N = mkN "biprisma" ; -- UWN
lin biquadratic_A = mkA "biquadratico" ; -- UWN
lin birch_N = mkN "betulla" ; -- status=guess
lin bird_N = L.bird_N ;
lin birdie_N = mkN "uccellino" ; -- status=guess
lin birdlime_N = mkN "pania" | mkN "vischio" ; -- UWN
lin birefringent_A = mkA "birifrangente" ; -- UWN
lin biretta_N = mkN "berretta" ; -- UWN
lin birkenhead_PN = mkPN "Birkenhead" ; -- status=guess src=geonames
lin birr_N = mkN "brusio" | mkN "frullo" ; -- UWN
lin birth_N = mkN "nascita" masculine ; -- status=guess
lin birthday_N = mkN "compleanno" ; -- status=guess
lin birthmark_N = mkN "voglia" ; -- status=guess
lin birthplace_N = mkN "culla" | mkN "luogo_di_nascita" ; -- UWN
lin birthrate_N = mkN "natalità" ; -- UWN
lin birthright_N = mkN "diritto di nascita" ; -- status=guess
lin birthwort_N = mkN "vellutino" ; -- status=guess
lin birtley_PN = mkPN "Birtley" ; -- status=guess src=geonames
lin biscuit_N = mkN "biscotto" | mkN "biscottino" ; -- status=guess status=guess
lin bisexual_A = mkA "bisessuale" | mkA "ermafrodita" ; -- status=guess status=guess
lin bisexual_N = mkN "bisessuale" masculine | mkN "bisex" masculine ; -- status=guess status=guess
lin bisexuality_N = mkN "bisessualità" feminine | mkN "ermafrodismo" ; -- status=guess status=guess
lin bishop_N = mkN "alfiere" masculine ; -- status=guess
lin bishopbriggs_PN = mkPN "Bishopbriggs" ; -- status=guess src=geonames
lin bishopric_N = mkN "diocesi" | mkN "vescovado" | mkN "vescovato" ; -- UWN
lin bismuth_N = mkN "bismuto" ; -- status=guess
lin bison_N = mkN "bisonte" ; -- UWN
lin bister_N = mkN "bistro" ; -- UWN
lin bistro_N = mkN "trattoria" ; -- status=guess
lin bit_N = mkN "morso" | mkN "freno" ; -- status=guess status=guess
lin bitch_N = mkN "stronza" | mkN "troia" ; -- status=guess status=guess
lin bite_N = mkN "morso" ; -- status=guess
lin bite_V = mkV (I.fare_V) "il passo più lungo della gamba" ; -- status=guess, src=wikt
lin bite_V2 = L.bite_V2 ;
lin bitter_A = mkA "aspro" | mkA "aspra" ; -- status=guess status=guess
lin bittern_N = mkN "tarabuso" ; -- status=guess
lin bitterness_N = mkN "amaro" ; -- status=guess
lin bitters_N = mkN "bitter" masculine ; -- status=guess
lin bitter_sweet_A = mkA "agrodolce" ; -- status=guess
lin bitumen_N = mkN "bitume" ; -- UWN
lin bituminous_A = mkA "bituminoso" ; -- UWN
lin bivalve_A = mkA "bivalve" ; -- UWN
lin bivouac_N = mkN "bivacco" ; -- status=guess
lin bivouac_V = mkV "attendarsi" | mkV "bivaccare" | mkV "campeggiare" ; -- UWN
lin bizarre_A = mkA "bizzarro" | mkA "bizzarra" ; -- status=guess status=guess
lin bizonal_A = mkA "bizonale" ; -- UWN
lin blabber_V = mkV "spiattellare" | mkV "cianciare" | mkV "spettegolare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin blabber_V2 = mkV2 (mkV "spiattellare") | mkV2 (mkV "cianciare") | mkV2 (mkV "spettegolare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin blabbermouth_N = mkN "spifferone" | mkN "spione" ; -- UWN
lin black_A = L.black_A ;
lin black_N = mkN "nero" | mkN "nera" ; -- status=guess status=guess
lin black_out_V = mkV "svenire" | mkV "tramortire" ; -- UWN
lin blackberry_N = mkN "mora" ; -- status=guess
lin blackbird_N = mkN "merlo" ; -- status=guess
lin blackboard_N = mkN "lavagna" ; -- status=guess
lin blackburn_PN = mkPN "Blackburn" ; -- status=guess src=geonames
lin blackcap_N = mkN "capinera" ; -- status=guess
lin blackcurrant_N = mkN "ribes nero" ; -- status=guess
lin blacken_V = mkV "annerire" ; -- status=guess, src=wikt
lin blacken_V2 = mkV2 (mkV "annerire") ; -- status=guess, src=wikt
lin blackhead_N = mkN "comedone" masculine ; -- status=guess
lin blacking_N = mkN "cera_da_scarpe" | mkN "cera_per_scarpe" | mkN "crema_da_scarpe" | mkN "lucido_da_scarpe" | mkN "lucido_per_scarpe" ; -- UWN
lin blackish_A = mkA "nerastro" ; -- status=guess
lin blackjack_N = mkN "ventuno" ; -- UWN
lin blackleg_N = mkN "crumiro" ; -- UWN
lin blacklist_N = mkN "lista_nera" ; -- UWN
lin blackmail_N = mkN "ricatto" ; -- status=guess
lin blackmail_V2 = mkV2 (mkV "ricattare") ; -- status=guess, src=wikt
lin blackmailer_N = mkN "ricattatore" | mkN "taglieggiatore" ; -- UWN
lin blackness_N = mkN "nero" ; -- UWN
lin blackout_N = mkN "amnesia" ; -- UWN
lin blackpool_PN = mkPN "Blackpool" ; -- status=guess src=geonames
lin blacksmith_N = mkN "maniscalco" ; -- status=guess
lin blackthorn_N = mkN "prugnolo" ; -- status=guess
lin blackwood_PN = mkPN "Blackwood" ; -- status=guess src=geonames
lin bladder_N = mkN "alchechengi" ; -- status=guess
lin blade_N = mkN "filo" ; -- status=guess
lin blaenavon_PN = mkPN "Blaenavon" ; -- status=guess src=geonames
lin blah_N = mkN "bla" | mkN "bla bla" | mkN "bla bla bla" ; -- status=guess status=guess status=guess
lin blairgowrie_PN = mkPN "Blairgowrie" ; -- status=guess src=geonames
lin blame_N = mkN "colpa" masculine ; -- status=guess
lin blame_V = mkV "incolpare" | mkV "biasimare" ; -- status=guess, src=wikt status=guess, src=wikt
lin blame_V2 = mkV2 (mkV "incolpare") | mkV2 (mkV "biasimare") ; -- status=guess, src=wikt status=guess, src=wikt
lin bland_A = mkA "blando" ; -- status=guess
lin blank_A = variants {} ; --
lin blank_N = mkN "cartuccia_a_salve" ; -- UWN
lin blanket_N = mkN "coperta" ; -- status=guess
lin blantyre_PN = mkPN "Blantyre" ; -- status=guess src=geonames
lin blare_N = mkN "cancan" | mkN "chiasso" | mkN "clangore" | mkN "fracasso" | mkN "frastuono" | mkN "rombazzo" | mkN "strepito" ; -- UWN
lin blare_V = mkV "squillare" | mkV "trillare" ; -- UWN
lin blaspheme_V = mkV "bestemmiare" ; -- status=guess, src=wikt
lin blaspheme_V2 = mkV2 (mkV "bestemmiare") ; -- status=guess, src=wikt
lin blasphemer_N = mkN "bestemmiatore" ; -- status=guess
lin blasphemy_N = mkN "blasfemia" | mkN "bestemmia" ; -- status=guess status=guess
lin blast_N = mkN "esplosione" feminine | mkN "scoppio" ; -- status=guess status=guess
lin blast_V = esplodere_V ;
lin blast_V2 = mkV2 (esplodere_V) ; ----
lin blastoderm_N = mkN "blastoderma" masculine ; -- status=guess
lin blatant_A = mkA "assordante" | mkA "fragoroso" | mkA "chiassoso" | mkA "gigantesco" | mkA "macroscopico" ; -- status=guess status=guess status=guess status=guess status=guess
lin blather_V = mkV "blaterare" | mkV "cianciare" | mkV "ciarlare" | mkV "sfringuellare" | mkV "taccolare" ; -- UWN
lin blaze_N = mkN "fiamma" | mkN "fiammata" | mkN "vampa" ; -- status=guess status=guess status=guess
lin blaze_V = mkV "brillare" | mkV "fiammeggiare" | mkV "sfolgorare" | mkV "sfolgoreggiare" ; -- UWN
lin blazer_N = mkN "blazer" | mkN "giacca_sportiva" ; -- UWN
lin blazon_N = mkN "blason" | mkN "blasonatura" | mkN "blasone" masculine ; -- status=guess status=guess status=guess
lin blazon_V2 = mkV2 (mkV "blasonare") | mkV2 (mkV "divisare") ; -- status=guess, src=wikt status=guess, src=wikt
lin blazonry_N = mkN "arma" | mkN "blasone" | mkN "stemma" ; -- UWN
lin bleach_N = mkN "varechina" | mkN "candeggina" | mkN "decolorante" masculine ; -- status=guess status=guess status=guess
lin bleach_V = mkV "imbiancare" | mkV "candeggiare" | mkV "decolorare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bleach_V2 = mkV2 (mkV "imbiancare") | mkV2 (mkV "candeggiare") | mkV2 (mkV "decolorare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bleachers_N = mkN "gradinata" ; -- UWN
lin bleak_A = mkA "desolato" ; -- status=guess
lin bleakness_N = mkN "cupezza" | mkN "desolazione" | mkN "squallidezza" | mkN "tristezza" ; -- UWN
lin bleat_N = mkN "belato" ; -- status=guess
lin bleat_V = mkV "belare" ; -- status=guess, src=wikt
lin bleat_V2 = mkV2 (mkV "belare") ; -- status=guess, src=wikt
lin bleed_V = mkV "sanguinare" ; -- status=guess, src=wikt
lin bleed_V2 = mkV2 (mkV "sanguinare") ; -- status=guess, src=wikt
lin bleed_VS = mkVS (mkV "sanguinare") ; -- status=guess, src=wikt
lin bleep_N = mkN "censore di segnale" ; -- status=guess
lin blemish_N = mkN "macchia" ; -- status=guess
lin blend_N = mkN "miscela" | mkN "combinazione" feminine | mkN "mix" masculine ; -- status=guess status=guess status=guess
lin blend_V = mkV "fondersi" | mkV "mescolarsi" ; -- UWN
lin blender_N = mkN "frullatore" masculine ; -- status=guess
lin blepharitis_N = mkN "blefarite" feminine ; -- status=guess
lin bless_V2 = mkV2 (benedire_V) ; -- status=guess, src=wikt
lin blessedness_N = mkN "beatitudine" ; -- UWN
lin blessing_N = mkN "benedizione" feminine ; -- status=guess
lin bletchley_PN = mkPN "Bletchley" ; -- status=guess src=geonames
lin blether_N = mkN "chiacchiera" | mkN "chicacchiera" | mkN "ciancia" | mkN "cicalata" | mkN "fanfaluca" ; -- UWN
lin blidworth_PN = mkPN "Blidworth" ; -- status=guess src=geonames
lin blimp_N = mkN "dirigibile floscio" ; -- status=guess
lin blind_A = mkA "cieco" ; -- status=guess
lin blind_N = mkN "tenda" ; -- status=guess
lin blind_V2 = mkV2 (mkV "accecare") ; -- status=guess, src=wikt
lin blindness_N = mkN "cecità" feminine ; -- status=guess
lin blindworm_N = mkN "cecilia" ; -- UWN
lin bling_N = mkN "bling bling" | mkN "bling bling" ; -- status=guess status=guess
lin blink_N = mkN "battito di ciglia" ; -- status=guess
lin blink_V = mkV (mkV "sbattere") "le ciglia" ; -- status=guess, src=wikt
lin blink_V2 = mkV2 (mkV (mkV "sbattere") "le ciglia") ; -- status=guess, src=wikt
lin blinker_N = mkN "paraocchi" masculine ; -- status=guess
lin bliss_N = mkN "beatitudine" feminine ; -- status=guess
lin blister_N = mkN "bolla" ; -- status=guess
lin blithe_A = mkA "indifferente" ; -- status=guess
lin blitz_N = mkN "blitz" ; -- UWN
lin blizzard_N = mkN "montagna" masculine | mkN "marea" ; -- status=guess status=guess
lin bloc_N = mkN "blocco" ; -- status=guess
lin block_N = mkN "ceppo" ; -- status=guess
lin block_V2 = mkV2 (mkV "stoppare") ; -- status=guess, src=wikt
lin block_in_V2 = prepV2 (lin V OP_block_V2) OP_in_Prep ; -- guess-p-verb
lin block_off_V2 = prepV2 (lin V OP_block_V2) OP_off_Prep ; -- guess-p-verb
lin block_out_V2 = prepV2 (lin V OP_block_V2) OP_out_Prep ; -- guess-p-verb
lin block_up_V2 = prepV2 (lin V OP_block_V2) OP_up_Prep ; -- guess-p-verb
lin blockade_N = mkN "blocco" ; -- status=guess
lin blockhouse_N = mkN "fortino" ; -- UWN
lin blocking_N = mkN "bloccaggio" | mkN "occlusione" | mkN "ostruzione" | mkN "otturamento" | mkN "otturazione" ; -- UWN
lin bloke_N = variants {} ; --
lin blond_A = mkA "biondo" ; -- UWN
lin blonde_A = mkA "biondo" ; -- UWN
lin blood_N = L.blood_N ;
lin blood_bath_N = mkN "bagno di sangue" ; -- status=guess
lin bloodhound_N = mkN "segugio" ; -- status=guess
lin blood_letting_N = mkN "salasso" ; -- status=guess
lin bloodlust_N = mkN "sete di sangue" ; -- status=guess
lin bloodmobile_N = mkN "autoemoteca" ; -- UWN
lin bloodshed_N = mkN "ecatombe" | mkN "carneficina" ; -- status=guess status=guess
lin bloodstain_N = mkN "macchia_di_sangue" ; -- UWN
lin bloodstone_N = mkN "eliotropio" ; -- UWN
lin bloodstream_N = mkN "flusso sanguigno" ; -- status=guess
lin bloodsucker_N = mkN "mignatta" | mkN "sanguisuga" ; -- UWN
lin bloodthirsty_A = mkA "sanguinario" ; -- status=guess
lin bloody_A = mkA "cruento" | mkA "sanguinoso" ; -- status=guess status=guess
lin bloody_Adv = variants {} ; --
lin bloom_N = mkN "efflorescenza" ; -- UWN
lin bloom_V = mkV "fiorire" | mkV "sbocciare" ; -- UWN
lin blooming_N = mkN "colorito_roseo" | mkN "fioritura" ; -- UWN
lin blossom_N = mkN "bocciuolo" ; -- status=guess
lin blossom_V = mkV "sbocciare" | mkV "svilupparsi" | mkV "svolgersi" ; -- UWN
lin blot_N = mkN "macchia" ; -- status=guess
lin blot_V2 = mkV2 (mkV "macchiare") ; -- status=guess, src=wikt
lin blot_out_V = mkV "coprire" | mkV "mascherare" ; -- UWN
lin blotch_N = mkN "chiazza" | mkN "macchia" ; -- UWN
lin blouse_N = mkN "camicia" ; -- status=guess
lin blow_N = mkN "botta" | mkN "colpo" ; -- status=guess status=guess
lin blow_V = L.blow_V ;
lin blow_V2 = mkV2 (mkV "soffiare") ; -- status=guess, src=wikt
lin blow_away_V = advV OP_blow_V OP_away_Adv ; -- guess-p-verb
lin blow_away_V2 = mkV2 (advV OP_blow_V OP_away_Adv ) ; -- guess-p-verb
lin blow_down_V2 = prepV2 OP_blow_V OP_down_Prep ; -- guess-p-verb
lin blow_dry_V2 = variants {} ; -- guess-p-verb
lin blow_in_V = advV OP_blow_V OP_in_Adv ; -- guess-p-verb
lin blow_off_V = advV OP_blow_V OP_off_Adv ; -- guess-p-verb
lin blow_off_V2 = prepV2 OP_blow_V OP_off_Prep ; -- guess-p-verb
lin blow_out_V2 = prepV2 OP_blow_V OP_out_Prep ; -- guess-p-verb
lin blow_over_V = advV OP_blow_V OP_over_Adv ; -- guess-p-verb
lin blow_up_V = mkV "ingigantire" | mkV "ingrandire" ; -- UWN
lin blow_up_V2 = prepV2 OP_blow_V OP_up_Prep ; -- guess-p-verb
lin blowfish_N = mkN "pesce palla" ; -- status=guess
lin blowgun_N = mkN "cerbottana" ; -- UWN
lin blowhole_N = mkN "sfiatatoio" ; -- status=guess
lin blowlamp_N = mkN "cannello" ; -- UWN
lin blowtorch_N = mkN "cannello" ; -- UWN
lin blubber_N = mkN "pannicolo" ; -- status=guess
lin bludgeon_N = mkN "mazza" ; -- status=guess
lin blue_A = L.blue_A ;
lin blue_N = mkN "blu" | mkN "azzurro" ; -- status=guess status=guess
lin blueberry_N = mkN "mirtillo" ; -- status=guess
lin blue_jacket_N = mkN "marinaio" ; -- UWN
lin blueprint_N = mkN "progetto" ; -- status=guess
lin blues_N = mkN "malinconia" | mkN "paturnie" feminine ; -- status=guess status=guess
lin bluestocking_N = mkN "intellettuale" ; -- UWN
lin bluethroat_N = mkN "pettazzurro" ; -- status=guess
lin bluetongue_N = mkN "lingua blu" ; -- status=guess
lin bluffer_N = mkN "bluffatore" ; -- UWN
lin bluish_A = mkA "azzurro" | mkA "blu" ; -- UWN
lin blunder_N = mkN "abbaglio" | mkN "abbarbagliamento" | mkN "biscanto" | mkN "cantonata" | mkN "cerpellone" | mkN "dirizzone" | mkN "figuraccia" | mkN "goffaggine" | mkN "granchio" | mkN "miraggio" | mkN "scerpellone" | mkN "sfarfallone" | mkN "sfondone" | mkN "strafalcione" | mkN "svarione" | mkN "svista" | mkN "travisamento" ; -- UWN
lin blunderer_N = mkN "ciabattone" | mkN "cialtrone" | mkN "disordinato" | mkN "guastamestieri" | mkN "guazzabuglione" | mkN "impiastratore" | mkN "incapace" | mkN "pasticcione" | mkN "scalzacane" | mkN "scalzacani" | mkN "schiappa" ; -- UWN
lin blunt_A = mkA "ottuso" ; -- status=guess
lin blurb_N = mkN "quarta di copertina" ; -- status=guess
lin blush_N = mkN "fard" masculine ; -- status=guess
lin blush_V = mkV "arrossire" ; -- status=guess, src=wikt
lin blyth_PN = mkPN "Blyth" ; -- status=guess src=geonames
lin bo'sun_N = mkN "nostromo" ; -- UWN
lin boa_N = mkN "boa" masculine ; -- status=guess
lin boar_N = mkN "verro" ; -- status=guess
lin board_1_N = variants {} ; --
lin board_2_N = mkN "censura" | mkN "collegio" | mkN "comitato" | mkN "commissione" | mkN "consiglio" ; -- UWN
lin board_N = mkN "vitto e alloggio" ; -- status=guess
lin board_V2 = variants {} ; --
lin boarder_N = mkN "collegiale" | mkN "convittore" | mkN "interno" ; -- UWN
lin boarding_N = mkN "pensione" feminine ; -- status=guess
lin boardwalk_N = mkN "passerella" ; -- UWN
lin boast_N = mkN "vanteria" ; -- status=guess
lin boast_V = mkV "vantarsi" ; -- status=guess, src=wikt
lin boast_V2 = mkV2 (mkV "vantarsi") ; -- status=guess, src=wikt
lin boast_VS = mkVS (mkV "vantarsi") ; -- status=guess, src=wikt
lin boaster_N = mkN "ammazzasette" | mkN "arcifanfano" | mkN "ballista" | mkN "bauscia" | mkN "begolardo" | mkN "borioso" | mkN "bravaccio" | mkN "bravazzo" | mkN "cacciaballe" | mkN "contaballe" | mkN "fanfarone" | mkN "gonfianuvoli" | mkN "gradasso" | mkN "mangiafuoco" | mkN "matamoro" | mkN "millantatore" | mkN "ostentatore" | mkN "parabolano" | mkN "parabolone" | mkN "rodomonte" | mkN "sacripante" | mkN "sbruffone" | mkN "smargiasso" | mkN "spaccamontagne" | mkN "spaccamonti" | mkN "spaccone" | mkN "spavaldo" | mkN "vanaglorioso" ; -- UWN
lin boastfulness_N = mkN "boria" | mkN "millanteria" | mkN "spacconaggine" | mkN "superbia" | mkN "vanagloria" | mkN "vanità" ; -- UWN
lin boat_N = L.boat_N ;
lin boatload_N = mkN "barca" | mkN "bastimento" ; -- UWN
lin boatman_N = mkN "barcaiolo" | mkN "battelliere" masculine ; -- status=guess status=guess
lin boatswain_N = mkN "nostromo" ; -- status=guess
lin bobbin_N = mkN "bobina" ; -- status=guess
lin bobby_N = mkN "poliziotto" | mkN "piedipiatti" masculine ; -- status=guess status=guess
lin bobcat_N = mkN "lince rossa" ; -- status=guess
lin bobsled_N = mkN "bob" ; -- UWN
lin bobsleigh_N = mkN "bob" ; -- UWN
lin bocce_N = mkN "bocce" feminine ; -- status=guess
lin bochum_PN = mkPN "Bochum" ; -- status=guess src=geonames
lin bodacious_A = mkA "sfacciato" | mkA "sfrontato" ; -- UWN
lin bodice_N = mkN "corpetto" ; -- status=guess
lin bodily_A = mkA "corporale" ; -- status=guess
lin bodily_Adv = mkAdv "corporalmente" | adjAdv bodily_A ; -- status=guess -- derived
lin bodkin_N = mkN "infilacapi" | mkN "infilacappi" | mkN "infilaguaine" | mkN "infilanastri" ; -- UWN
lin bodmin_PN = mkPN "Bodmin" ; -- status=guess src=geonames
lin body_N = mkN "corpo" feminine ; -- status=guess
lin bodybuilder_N = mkN "culturista" masculine ; -- status=guess
lin bodybuilding_N = mkN "culturismo" | mkN "bodybuilding" ; -- status=guess status=guess
lin bodyguard_N = mkN "guardia del corpo" ; -- status=guess
lin bodywork_N = mkN "carrozzeria" ; -- status=guess
lin boffin_N = mkN "scienziato" ; -- status=guess
lin bog_N = mkN "cesso" ; -- status=guess
lin bogeyman_N = mkN "babau" | mkN "baubau" | mkN "uomo_nero" ; -- UWN
lin boggy_A = mkA "fangoso" ; -- UWN
lin bogie_N = mkN "carrello motore di locomotiva" ; -- status=guess
lin bogota_PN = mkPN "Bogota" ; -- status=guess src=geonames
lin bogus_A = mkA "falsificato" | mkA "truccato" ; -- status=guess status=guess
lin bohemian_N = mkN "bohemien" | mkN "bohémien" ; -- UWN
lin bohrium_N = mkN "bohrio" ; -- status=guess
lin boil_N = mkN "punto_di_ebollizione" ; -- UWN
lin boil_V = mkV "bollire" ; -- status=guess, src=wikt
lin boil_V2 = mkV2 (mkV "bollire") ; -- status=guess, src=wikt
lin boiler_N = mkN "caldaia" masculine ; -- status=guess
lin boilersuit_N = mkN "blusa" | mkN "camice" | mkN "grembiale" | mkN "grembiule" ; -- UWN
lin boisterous_A = mkA "esuberante" | mkA "chiassoso" ; -- status=guess status=guess
lin bold_1_A = mkA "sfrontato" | mkA "ardito" | mkA "audace" | mkA "coraggioso" ; -- status=guess status=guess status=guess status=guess
lin bold_2_A = mkA "sfrontato" | mkA "ardito" | mkA "audace" | mkA "coraggioso" ; -- status=guess status=guess status=guess status=guess
lin boldface_N = mkN "grassetto" | mkN "neretto" ; -- UWN
lin bolide_N = mkN "bolide" | mkN "meteorite" ; -- UWN
lin bolivia_PN = mkPN "Bolivia" ; -- status=guess src=geonames
lin boliviano_N = mkN "boliviano" ; -- UWN
lin boll_N = mkN "capsula" ; -- status=guess
lin bollard_N = mkN "bitta" ; -- status=guess
lin bollington_PN = mkPN "Bollington" ; -- status=guess src=geonames
lin bologna_PN = mkPN "Bologna" ; -- status=guess src=geonames
lin bolometer_N = mkN "bolometro" ; -- status=guess
lin boloney_N = mkN "sciocchezze" ; -- UWN
lin bolsover_PN = mkPN "Bolsover" ; -- status=guess src=geonames
lin bolster_N = mkN "capezzale" masculine ; -- status=guess
lin bolster_V = mkV "sostenere" ; -- UWN
lin bolt_Adv = mkAdv "rigidamente" ; -- UWN
lin bolt_N = mkN "gratile" ; -- status=guess
lin bolt_V = mkV "serrare" ; -- status=guess, src=wikt
lin bolt_V2 = mkV2 (mkV "serrare") ; -- status=guess, src=wikt
lin bolton_PN = mkPN "Bolton" ; -- status=guess src=geonames
lin bolus_N = mkN "bolo" ; -- status=guess
lin bolzano_PN = mkPN "Bolzano" ; -- status=guess src=geonames
lin bomb_N = mkN "bomba" ; -- status=guess
lin bomb_V = mkV "bombardare" ; -- status=guess, src=wikt
lin bomb_V2 = mkV2 (mkV "bombardare") ; -- status=guess, src=wikt
lin bombard_V2 = mkV2 (mkV "bombardare") ; -- status=guess, src=wikt
lin bombardier_N = mkN "bombardiere" ; -- UWN
lin bombardment_N = mkN "bombardamento" ; -- status=guess
lin bombardon_N = mkN "bombarda" ; -- UWN
lin bombastic_A = mkA "pomposo" ; -- status=guess
lin bomber_N = mkN "bombardiere" ; -- UWN
lin bombshell_N = mkN "bomba" | mkN "granata" ; -- status=guess status=guess
lin bombycid_N = mkN "bombice" ; -- UWN
lin bond_N = variants {} ; --
lin bond_V2 = mkV2 (mkV "legare") ; -- status=guess, src=wikt
lin bond_holder_N = mkN "obbligazionista" ; -- UWN
lin bone_N = L.bone_N ;
lin bone_V2 = mkV2 (mkV "fottere") | mkV2 (mkV "scopare") ; -- status=guess, src=wikt status=guess, src=wikt
lin boner_N = mkN "erezione" feminine ; -- status=guess
lin bonfire_N = mkN "falò" masculine ; -- status=guess
lin bongo_N = mkN "bongo" | mkN "bongos" ; -- UWN
lin bonhomie_N = mkN "affabilità" | mkN "affidabilità" | mkN "amabilità" | mkN "bonarietà" | mkN "bonomia" | mkN "gentilezza" | mkN "lenità" | mkN "mitezza" | mkN "soavità" ; -- UWN
lin bonn_PN = mkPN "Bonn" ; -- status=guess src=geonames
lin bonnet_N = mkN "cofano" ; -- status=guess
lin bonnybridge_PN = mkPN "Bonnybridge" ; -- status=guess src=geonames
lin bonnyrigg_PN = mkPN "Bonnyrigg" ; -- status=guess src=geonames
lin bonsai_N = mkN "bonsai" masculine ; -- status=guess
lin bonus_N = variants {} ; --
lin bony_A = mkA "ossuto" ; -- status=guess
lin bonyness_N = mkN "consunzione" | mkN "deperimento" | mkN "dimagrimento" | mkN "macilenza" | mkN "magrezza" | mkN "secchezza" ; -- UWN
lin boo_V = mkV "fischiare" ; -- UWN
lin boob_N = mkN "mammella" | mkN "seno" | mkN "tetta" ; -- UWN
lin booby_N = mkN "trabocchetto" ; -- status=guess
lin boodle_N = mkN "bottino" | mkN "refurtiva" ; -- status=guess status=guess
lin booger_N = mkN "caccola" ; -- status=guess
lin book_N = L.book_N ;
lin book_V2 = mkV2 (mkV "ammonire") ; -- status=guess, src=wikt
lin bookbinder_N = mkN "legatore" | mkN "legatrice" feminine ; -- status=guess status=guess
lin bookbinding_N = mkN "legatoria" | mkN "legatura" ; -- UWN
lin bookcase_N = mkN "libreria" ; -- status=guess
lin bookie_N = mkN "allibratore" | mkN "bookmaker" ; -- UWN
lin booking_N = mkN "prenotazione" feminine ; -- status=guess
lin book_keeper_N = mkN "contabile" | mkN "saldacontista" ; -- UWN
lin booklet_N = mkN "libretto" | mkN "libello" ; -- status=guess status=guess
lin bookmaker_N = mkN "bookmaker" masculine ; -- status=guess
lin bookmark_N = mkN "segnalibro" ; -- status=guess
lin bookmarker_N = mkN "segnacarte" | mkN "segnalibro" ; -- UWN
lin bookmobile_N = mkN "autolibro" ; -- UWN
lin bookseller_N = mkN "libraio" | mkN "libraia" ; -- status=guess status=guess
lin bookshelf_N = mkN "libreria" ; -- status=guess
lin bookshop_N = mkN "libreria" ; -- status=guess
lin bookstall_N = mkN "libraio" | mkN "libreria" ; -- UWN
lin bookworm_N = mkN "bibliofago" ; -- status=guess
lin boom_N = mkN "boma" masculine ; -- status=guess
lin boomerang_N = mkN "boomerang" | mkN "bumerang" ; -- status=guess status=guess
lin boor_N = mkN "boero" ; -- status=guess
lin boorish_A = mkA "zotico" ; -- status=guess
lin boorishness_N = mkN "maialata" ; -- status=guess
lin boost_N = mkN "incoraggiamento" ; -- UWN
lin boost_V2 = variants {} ; --
lin booster_N = mkN "richiamo" ; -- UWN
lin boot_N = L.boot_N ;
lin bootblack_N = mkN "lustrascarpe" ; -- UWN
lin bootee_N = mkN "babbuccia" ; -- UWN
lin booth_N = mkN "bancarella" | mkN "stand" | mkN "bugigattolo" ; -- status=guess status=guess status=guess
lin bootjack_N = mkN "cavastivali" | mkN "tirastivali" ; -- UWN
lin bootle_PN = mkPN "Bootle" ; -- status=guess src=geonames
lin bootleg_N = mkN "gambale" ; -- UWN
lin bootstrap_N = mkN "linguetta" ; -- status=guess
lin booty_N = mkN "bottino" | mkN "bottini" masculine ; -- status=guess status=guess
lin boozer_N = mkN "ubriacone" | mkN "beone" masculine ; -- status=guess status=guess
lin borage_N = mkN "borragine" | mkN "borraggine" feminine ; -- status=guess status=guess
lin borate_N = mkN "borato" ; -- status=guess
lin borax_N = mkN "borace" masculine ; -- status=guess
lin bordeaux_PN = mkPN "Bordeaux" ; -- status=guess src=geonames
lin border_N = mkN "orlo" ; -- status=guess
lin borderline_N = mkN "confine" | mkN "delimitazione" | mkN "frontiera" | mkN "linea_di_demarcazione" ; -- UWN
lin bordon_PN = mkPN "Bordon" ; -- status=guess src=geonames
lin bore_V = mkV "annoiare" | mkV "tediare" ; -- status=guess, src=wikt status=guess, src=wikt
lin bore_V2 = mkV2 (mkV "annoiare") | mkV2 (mkV "tediare") ; -- status=guess, src=wikt status=guess, src=wikt
lin bored_A = variants {} ; --
lin boredom_N = mkN "noia" | mkN "tedio" ; -- status=guess status=guess
lin boric_A = mkA "borico" ; -- status=guess
lin boring_A = mkA "noioso" | mkA "noiosa" ; -- status=guess status=guess
lin boring_N = mkN "perforazione" | mkN "sondaggio" | mkN "trapanatura" ; -- UWN
lin boron_N = mkN "boro" ; -- status=guess
lin borosilicate_N = mkN "borosilicato" ; -- UWN
lin borough_N = variants {} ; --
lin borrow_V = mkV (prendere_V) "in prestito" ; -- status=guess, src=wikt
lin borrow_V2 = mkV2 (mkV (prendere_V) "in prestito") ; -- status=guess, src=wikt
lin borrow_VV = mkVV (mkV (prendere_V) "in prestito") ; -- status=guess, src=wikt
lin borzoi_N = mkN "barzoi" masculine ; -- status=guess
lin bosh_N = mkN "sciocchezze" ; -- UWN
lin bosky_A = mkA "boscoso" | mkA "cespuglioso" ;
lin bosom_N = mkN "seno" ; -- status=guess
lin boson_N = mkN "bosone" masculine ; -- status=guess
lin boss_N = L.boss_N ;
lin boss_V2 = mkV2 (mkV "comandare") ; -- status=guess, src=wikt
lin boston_PN = mkPN "Boston" ; -- status=guess src=geonames
lin botanic_A = mkA "botanico" ; -- UWN
lin botanical_A = mkA "botanico" ; -- status=guess
lin botanical_N = mkN "orto botanico" | mkN "giardino botanico" ; -- status=guess status=guess
lin botanist_N = mkN "botanico" ; -- UWN
lin botany_N = mkN "botanica" ; -- status=guess
lin botcher_N = mkN "ciabattone" | mkN "cialtrone" | mkN "disordinato" | mkN "guastamestieri" | mkN "guazzabuglione" | mkN "impiastratore" | mkN "incapace" | mkN "pasticcione" | mkN "scalzacane" | mkN "scalzacani" | mkN "schiappa" ; -- UWN
lin both7and_DConj = S.both7and_DConj ; -- comment=CHECKED
lin both_Adv = variants {} ; --
lin both_Det = mkDet "entrambi" "entrambi" plural ;
lin bother_N = mkN "confusione" feminine | mkN "trambusto" | mkN "agitazione" feminine ; -- status=guess status=guess status=guess
lin bother_V = mkV "disturbarsi" | mkV (mkV "prendersi") "la briga" | mkV "preoccuparsi" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bother_V2 = mkV2 (mkV "disturbarsi") | mkV2 (mkV (mkV "prendersi") "la briga") | mkV2 (mkV "preoccuparsi") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bother_V2V = mkV2V (mkV "disturbarsi") | mkV2V (mkV (mkV "prendersi") "la briga") | mkV2V (mkV "preoccuparsi") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bother_VV = mkVV (mkV "disturbarsi") | mkVV (mkV (mkV "prendersi") "la briga") | mkVV (mkV "preoccuparsi") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bothersome_A = mkA "fastidioso" | mkA "irritante" | mkA "seccante" ; -- UWN
lin botswana_PN = mkPN "Botswana" ; -- status=guess src=geonames
lin bottle_N = mkN "bottiglia" ; -- status=guess
lin bottle_V2 = mkV2 (mkV "imbottigliare") ; -- status=guess, src=wikt
lin bottom_A = variants {} ; --
lin bottom_N = mkN "sedere" masculine ; -- status=guess
lin bottrop_PN = mkPN "Bottrop" ; -- status=guess src=geonames
lin botulism_N = mkN "botulismo" ; -- status=guess
lin bougainvillea_N = mkN "buganvillea" ; -- status=guess
lin bough_N = mkN "frasca" | mkN "ramo" ; -- UWN
lin boulder_N = mkN "macigno" ; -- status=guess
lin boulevard_N = mkN "boulevard" | mkN "corso" | mkN "viale" ; -- UWN
lin bounce_N = mkN "rimbalzo" ; -- status=guess
lin bounce_V = mkV "rimbalzare" ; -- status=guess, src=wikt
lin bounce_V2 = mkV2 (mkV "rimbalzare") ; -- status=guess, src=wikt
lin bouncer_N = mkN "buttafuori" masculine ; -- status=guess
lin bound_N = mkN "frontiera" | mkN "confine" masculine ; -- status=guess status=guess
lin bound_V = mkV "balzare" ; -- status=guess, src=wikt
lin bound_V2 = mkV2 (mkV "balzare") ; -- status=guess, src=wikt
lin bound_V2V = mkV2V (mkV "balzare") ; -- status=guess, src=wikt
lin boundary_N = mkN "confine" masculine | mkN "limite" masculine ; -- status=guess status=guess
lin boundless_A = mkA "illimitato" | mkA "sconfinato" ; -- status=guess status=guess
lin bounty_N = mkN "cacciatore di taglie" ; -- status=guess
lin bouquet_N = mkN "mazzo" ; -- status=guess
lin bourbon_N = mkN "bourbon" ; -- UWN
lin bourgeois_A = variants {} ; --
lin bourgeoisie_N = mkN "borghesia" ; -- status=guess
lin bourne_PN = mkPN "Bourne" ; -- status=guess src=geonames
lin bournemouth_PN = mkPN "Bournemouth" ; -- status=guess src=geonames
lin boutique_N = mkN "boutique" ; -- UWN
lin bovine_N = mkN "encefalopatia spongiforme bovina" ; -- status=guess
lin bow_N = mkN "arco" ; -- status=guess
lin bow_V = mkV "curvarsi" | mkV "piegarsi" | mkV "incurvarsi" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bow_V2 = mkV2 (mkV "curvarsi") | mkV2 (mkV "piegarsi") | mkV2 (mkV "incurvarsi") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bowel_N = mkN "budella" | mkN "viscere" feminine | mkN "intestino" ; -- status=guess status=guess status=guess
lin bower_N = mkN "chiosco" | mkN "pergola" ; -- UWN
lin bowing_N = mkN "salamelecco" ; -- status=guess
lin bowl_N = mkN "boccia" ; -- status=guess
lin bowl_V = variants {} ; --
lin bowl_V2 = variants {} ; --
lin bowleg_N = mkN "gambestorte" ; -- status=guess
lin bowler_N = mkN "bombetta" ; -- status=guess
lin bowline_N = mkN "bolina" ; -- status=guess
lin bowls_N = mkN "boccia" ; -- status=guess
lin bowman_N = mkN "prodiere" masculine ; -- status=guess
lin bowsprit_N = mkN "bompresso" ; -- status=guess
lin box_N = mkN "bosso" ; -- status=guess
lin box_V = mkV "boxare" ; -- status=guess, src=wikt
lin box_V2 = mkV2 (mkV "boxare") ; -- status=guess, src=wikt
lin boxer_N = mkN "pugile" | mkN "boxeur" masculine ; -- status=guess status=guess
lin boxing_N = mkN "boxe" | mkN "pugilato" ; -- status=guess status=guess
lin boxwood_N = mkN "bosso" ; -- UWN
lin boy_N = L.boy_N ;
lin boycott_N = mkN "boicottaggio" ; -- UWN
lin boyfriend_N = mkN "ragazzo" | mkN "fidanzato" ; -- status=guess status=guess
lin boyhood_N = mkN "fanciullezza" ; -- UWN
lin bra_N = mkN "reggiseno" | mkN "reggipetto" ; -- status=guess status=guess
lin brace_N = mkN "graffa" ; -- status=guess
lin bracelet_N = mkN "braccialetto" ; -- status=guess
lin bracer_N = mkN "cicchetto" | mkN "corroborante" ; -- UWN
lin brachial_A = mkA "brachiale" ; -- UWN
lin brachiation_N = mkN "brachiazione" feminine ; -- status=guess
lin brachycephalic_A = mkA "brachicefalico" ; -- UWN
lin bracken_N = mkN "felce" feminine ; -- status=guess
lin bracket_N = mkN "parentesi" feminine ; -- status=guess
lin brackish_A = mkA "salmastra" ; -- status=guess
lin bracknell_PN = mkPN "Bracknell" ; -- status=guess src=geonames
lin bracteal_A = mkA "bratteale" ; -- UWN
lin bracteate_A = mkA "bratteato" ; -- UWN
lin bradford_PN = mkPN "Bradford" ; -- status=guess src=geonames
lin bradycardia_N = mkN "bradicardia" ; -- status=guess
lin brag_N = mkN "fanfaronata" | mkN "gigionata" | mkN "millantamento" | mkN "millanteria" | mkN "smargiassata" ; -- UWN
lin brag_V = mkV "vantarsi" ; -- status=guess, src=wikt
lin braggadocio_N = mkN "bravacciata" | mkN "bravazzata" | mkN "gradassata" | mkN "guasconata" | mkN "pallonata" | mkN "rodomontata" | mkN "sbraciata" | mkN "sbruffonata" | mkN "sbruffoneria" | mkN "spacconata" | mkN "spacconeria" | mkN "spampanata" | mkN "trombonata" ; -- UWN
lin braggart_N = mkN "fanfarone" | mkN "ballista" ; -- status=guess status=guess
lin bragger_N = mkN "ammazzasette" | mkN "arcifanfano" | mkN "ballista" | mkN "bauscia" | mkN "begolardo" | mkN "borioso" | mkN "bravaccio" | mkN "bravazzo" | mkN "cacciaballe" | mkN "contaballe" | mkN "fanfarone" | mkN "gonfianuvoli" | mkN "gradasso" | mkN "mangiafuoco" | mkN "matamoro" | mkN "millantatore" | mkN "ostentatore" | mkN "parabolano" | mkN "parabolone" | mkN "rodomonte" | mkN "sacripante" | mkN "sbruffone" | mkN "smargiasso" | mkN "spaccamontagne" | mkN "spaccamonti" | mkN "spaccone" | mkN "spavaldo" | mkN "vanaglorioso" ; -- UWN
lin bragging_N = mkN "fanfaronata" | mkN "gigionata" | mkN "millantamento" | mkN "millanteria" | mkN "smargiassata" ; -- UWN
lin braid_N = mkN "treccia" ; -- status=guess
lin braid_V2 = mkV2 (mkV "intrecciare") ; -- status=guess, src=wikt
lin brain_N = mkN "cervello" | mkN "cervella" ;
lin brainchild_N = mkN "frutto ingegno" ; -- status=guess
lin brainstorm_N = mkN "lampo_di_genio" ; -- UWN
lin braintree_PN = mkPN "Braintree" ; -- status=guess src=geonames
lin brainwashing_N = mkN "lavaggio_del_cervello" ; -- UWN
lin brainwave_N = mkN "lampo_di_genio" ; -- UWN
lin brainy_A = mkA "brillante" ; -- UWN
lin brake_N = mkN "freno" ; -- status=guess
lin brake_V = mkV "frenare" ; -- status=guess, src=wikt
lin brake_V2 = mkV2 (mkV "frenare") ; -- status=guess, src=wikt
lin brakeman_N = mkN "frenatore" ; -- UWN
lin bran_N = mkN "crusca" | mkN "semola" ; -- status=guess status=guess
lin branch_N = mkN "branca" ; -- status=guess
lin branch_V = mkV "biforcarsi" | mkV "diramarsi" | mkV "ramificarsi" ; -- UWN
lin branched_A = mkA "ramificato" ; -- status=guess
lin branchial_A = mkA "branchiale" ; -- status=guess
lin branchiate_A = mkA "branchifero" ; -- UWN
lin branching_N = mkN "diramazione" | mkN "ramificazione" ; -- UWN
lin branchy_A = mkA "ramificato" | mkA "ramoluto" | mkA "ramoruto" | mkA "ramoso" | mkA "ramuto" ; -- UWN
lin brand_N = mkN "marca" ; -- UWN
lin brandy_N = mkN "acquavite" | mkN "brandy" ; -- UWN
lin brass_N = mkN "ottone" masculine ; -- status=guess
lin brassiere_N = variants {} ;
lin brat_N = mkN "monello" ; -- status=guess
lin bratislava_PN = mkPN "Bratislava" ; -- status=guess src=geonames
lin braunschweig_PN = mkPN "Braunschweig" ; -- status=guess src=geonames
lin braunton_PN = mkPN "Braunton" ; -- status=guess src=geonames
lin bravado_N = mkN "bravata" | mkN "spacconeria" ; -- UWN
lin brave_A = mkA "coraggioso" | mkA "ardito" | mkA "baldo" | mkA "audace" | mkA "valoroso" ; -- status=guess status=guess status=guess status=guess status=guess
lin bravery_N = mkN "animo" | mkN "ardimento" | mkN "ardire" | mkN "arditezza" | mkN "bravura" | mkN "coraggio" | mkN "eroismo" | mkN "forza" | mkN "intrepidezza" | mkN "prodezza" | mkN "valore" ; -- UWN
lin bravo_N = mkN "Bologna" ; -- status=guess
lin brawl_N = mkN "lotta" | mkN "combattimento" | mkN "rissa" | mkN "battaglia" masculine | mkN "baruffa" | mkN "zuffa" ; -- status=guess status=guess status=guess status=guess status=guess status=guess
lin brawl_V = mkV "lottare" | mkV "combattere" ; -- status=guess, src=wikt status=guess, src=wikt
lin bray_N = mkN "raglio" ; -- status=guess
lin bray_V2 = mkV2 (mkV "ragliare") ; -- status=guess, src=wikt
lin brazen_A = mkA "faccia di bronzo" ; -- status=guess
lin brazier_N = mkN "ottonario" | mkN "calderaio" ; -- status=guess status=guess
lin brazil_PN = mkPN "Brasile" ; -- status=guess src=geonames
lin breach_N = mkN "breccia" ; -- status=guess
lin bread_N = L.bread_N ;
lin breadboard_N = mkN "tagliere" ; -- UWN
lin breadcrumb_N = mkN "briciola" ; -- status=guess
lin breadstick_N = mkN "grissino" ; -- status=guess
lin breadth_N = mkN "comprensività" ; -- UWN
lin breadthways_Adv = mkAdv "in_larghezza" ; -- UWN
lin breadthwise_Adv = mkAdv "in_larghezza" ; -- UWN
lin break_N = mkN "pausa" ; -- status=guess
lin break_V = mkV (mkV "infrangere") "la legge" ; -- status=guess, src=wikt
lin break_V2 = L.break_V2 ;
lin break_apart_V = advV OP_break_V OP_apart_Adv ; -- guess-p-verb
lin break_away_V = advV OP_break_V OP_away_Adv ; -- guess-p-verb
lin break_down_V = advV OP_break_V OP_down_Adv ; -- guess-p-verb
lin break_down_V2 = prepV2 OP_break_V OP_down_Prep ; -- guess-p-verb
lin break_in_V = advV OP_break_V OP_in_Adv ; -- guess-p-verb
lin break_in_V2 = prepV2 OP_break_V OP_in_Prep ; -- guess-p-verb
lin break_in_on_V2 = prepV2 (advV OP_break_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin break_into_V2 = prepV2 OP_break_V OP_into_Prep ; -- guess-p-verb
lin break_off_V2 = prepV2 OP_break_V OP_off_Prep ; -- guess-p-verb
lin break_out_V = mkV "coprirsi" ; -- UWN
lin break_out_V2 = prepV2 OP_break_V OP_out_Prep ; -- guess-p-verb
lin break_out_in_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin break_out_of_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin break_through_V2 = prepV2 OP_break_V OP_through_Prep ; -- guess-p-verb
lin break_up_V = advV OP_break_V OP_up_Adv ; -- guess-p-verb
lin break_up_V2 = prepV2 OP_break_V OP_up_Prep ; -- guess-p-verb
lin breakage_N = mkN "frantumazione" | mkN "rompimento" | mkN "rottura" ; -- UWN
lin breakaway_N = mkN "fuga" ; -- status=guess
lin breakdown_N = mkN "avaria" ; -- status=guess
lin breaker_N = mkN "frangente" ; -- UWN
lin breakfast_N = mkN "colazione" feminine | mkN "prima colazione" feminine ; -- status=guess status=guess
lin breakthrough_N = mkN "breccia" ; -- status=guess
lin breakwater_N = mkN "frangiflutti" masculine ; -- status=guess
lin bream_N = mkN "abramide" | mkN "abramide commune" ; -- status=guess status=guess
lin breast_N = L.breast_N ;
lin breastfeed_V = mkV "allattare" | mkV (mkV "allattare") "al seno" ; -- status=guess, src=wikt status=guess, src=wikt
lin breastfeed_V2 = mkV2 (mkV "allattare") | mkV2 (mkV (mkV "allattare") "al seno") ; -- status=guess, src=wikt status=guess, src=wikt
lin breastwork_N = mkN "parapetto" | mkN "spalletta" ; -- UWN
lin breath_N = mkN "respiro" ; -- status=guess
lin breathalyser_N = mkN "alcolimetro" | mkN "alcoltest" | mkN "alcoolimetro" | mkN "alcooltest" | mkN "etilometro" ; -- UWN
lin breathalyzer_N = mkN "alcolimetro" | mkN "alcoltest" | mkN "alcoolimetro" | mkN "alcooltest" | mkN "etilometro" ; -- UWN
lin breathe_V = L.breathe_V ;
lin breathe_V2 = mkV2 (mkV "respirare") ; -- status=guess, src=wikt
lin breathing_N = mkN "respirazione" | mkN "respiro" ; -- UWN
lin breathtaking_A = mkA "mozzafiato" ; -- status=guess
lin breccia_N = mkN "breccia" ; -- UWN
lin breda_PN = mkPN ("Breda" | "Breda di Piave") ; -- status=guess src=geonames
lin breech_N = mkN "culatta" ; -- UWN
lin breech_block_N = mkN "otturatore" ; -- UWN
lin breechcloth_N = mkN "perizoma" ; -- UWN
lin breeches_N = mkN "brache" feminine ; -- status=guess
lin breed_N = variants {} ; --
lin breed_V = mkV "allevare" ; -- status=guess, src=wikt
lin breed_V2 = mkV2 (mkV "allevare") ; -- status=guess, src=wikt
lin breeder_N = mkN "allevatore" ; -- UWN
lin breeding_N = mkN "procreazione" ; -- UWN
lin breeze_N = mkN "brezza" ; -- status=guess
lin bregma_N = mkN "bregma" ; -- UWN
lin bremen_PN = mkPN "Brema" ; -- status=guess src=geonames
lin bremerhaven_PN = mkPN "Bremerhaven" ; -- status=guess src=geonames
lin brent_PN = mkPN "Brent" ; -- status=guess src=geonames
lin brentwood_PN = mkPN "Brentwood" ; -- status=guess src=geonames
lin brescia_PN = mkPN "Brescia" ; -- status=guess src=geonames
lin brest_PN = mkPN ("Brest" | "Brėst") ; -- status=guess src=geonames
lin brethren_N = mkN "confratelli" ; -- status=guess
lin breve_N = mkN "breve" ; -- UWN
lin breviary_N = mkN "breviario" ; -- status=guess
lin brevity_N = mkN "brevità" ; -- UWN
lin brewer_N = mkN "birraio" ; -- UWN
lin brewery_N = mkN "birrificio" ; -- status=guess
lin briar_N = mkN "pipa_in_radica" ; -- UWN
lin briarwood_N = mkN "radica" ; -- UWN
lin bribe_N = mkN "tangente" feminine ; -- status=guess
lin bribe_V = mkV (mkV "offrire") "una tangente" ; -- status=guess, src=wikt
lin bribe_V2 = mkV2 (mkV (mkV "offrire") "una tangente") ; -- status=guess, src=wikt
lin briber_N = mkN "corruttore" | mkN "corruttrice" feminine ; -- status=guess status=guess
lin bribery_N = mkN "corruzione" ; -- UWN
lin brick_N = mkN "mattone" ; -- status=guess
lin bricklayer_N = mkN "muratore" masculine ; -- status=guess
lin brickyard_N = mkN "mattonaia" ; -- status=guess
lin bridal_N = mkN "addio al nubilato" ; -- status=guess
lin bride_N = mkN "fidanzata" | mkN "sposa" ; -- status=guess status=guess
lin bridegroom_N = mkN "sposo" ; -- status=guess
lin bridesmaid_N = mkN "damigella d'onore" ; -- status=guess
lin bridge_N = mkN "setto nasale" ; -- status=guess
lin bridgehead_N = mkN "testa di ponte" ; -- status=guess
lin bridgend_PN = mkPN "Bridgend" ; -- status=guess src=geonames
lin bridgnorth_PN = mkPN "Bridgnorth" ; -- status=guess src=geonames
lin bridgwater_PN = mkPN "Bridgwater" ; -- status=guess src=geonames
lin bridle_N = mkN "briglia" ; -- status=guess
lin bridlington_PN = mkPN "Bridlington" ; -- status=guess src=geonames
lin bridport_PN = mkPN "Bridport" ; -- status=guess src=geonames
lin brief_A = mkA "breve" ; -- status=guess
lin briefcase_N = mkN "valigetta" ; -- status=guess
lin briefness_N = mkN "brevità" ; -- UWN
lin brig_N = mkN "brigantino" ; -- status=guess
lin brig_PN = mkPN "Briga-Glis" ; -- status=guess src=geonames
lin brigade_N = mkN "brigata" ; -- UWN
lin brigadier_N = mkN "generale_di_brigata" ; -- UWN
lin brigand_N = mkN "bandito" | mkN "brigante" | mkN "malandrino" | mkN "masnadiere" masculine ; -- status=guess status=guess status=guess status=guess
lin brigantine_N = mkN "brigantino" ; -- status=guess
lin brighouse_PN = mkPN "Brighouse" ; -- status=guess src=geonames
lin bright_A = mkA "allegro" | mkA "felice" ; -- status=guess status=guess
lin brighten_V = mkV "schiarire" ; -- UWN
lin brightlingsea_PN = mkPN "Brightlingsea" ; -- status=guess src=geonames
lin brighton_PN = mkPN "Brighton" ; -- status=guess src=geonames
lin brilliance_N = mkN "fastosità" | mkN "grandezza" | mkN "grandiosità" | mkN "magnificenza" | mkN "sfarzo" | mkN "sfarzosità" | mkN "sontuosità" | mkN "splendidezza" | mkN "splendore" | mkN "suntuosità" ; -- UWN
lin brilliant_A = mkA "brillante" ; -- status=guess
lin brilliantine_N = mkN "brillantina" ; -- UWN
lin brim_N = mkN "orlo" ; -- status=guess
lin brim_V = mkV "traboccare" | mkV (essere_V) "colmo" | mkV (essere_V) "pieno zeppo" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin brimstone_N = mkN "zolfo" ; -- status=guess
lin brine_N = mkN "salamoia" ; -- status=guess
lin bring_V2 = mkV2 (mkV "portare") ;
lin bring_V3 = mkV3 (mkV "portare") ;
lin bring_about_V2 = prepV2 (lin V OP_bring_V2) OP_about_Prep ; -- guess-p-verb
lin bring_along_V2 = prepV2 (lin V OP_bring_V2) OP_along_Prep ; -- guess-p-verb
lin bring_around_V2 = prepV2 (lin V OP_bring_V2) OP_around_Prep ; -- guess-p-verb
lin bring_away_V2 = mkV2 (advV (lin V OP_bring_V2) OP_away_Adv ) ; -- guess-p-verb
lin bring_back_V2 = mkV2 (advV (lin V OP_bring_V2) OP_back_Adv ) ; -- guess-p-verb
lin bring_down_V2 = prepV2 (lin V OP_bring_V2) OP_down_Prep ; -- guess-p-verb
lin bring_forth_V = mkV "generare" ; -- UWN
lin bring_forth_V2 = mkV2 (advV (lin V OP_bring_V2) OP_forth_Adv ) ; -- guess-p-verb
lin bring_forward_V2 = mkV2 (advV (lin V OP_bring_V2) OP_forward_Adv ) ; -- guess-p-verb
lin bring_in_V2 = prepV2 (lin V OP_bring_V2) OP_in_Prep ; -- guess-p-verb
lin bring_off_V2 = prepV2 (lin V OP_bring_V2) OP_off_Prep ; -- guess-p-verb
lin bring_on_V2 = prepV2 (lin V OP_bring_V2) OP_on_Prep ; -- guess-p-verb
lin bring_out_V2 = prepV2 (lin V OP_bring_V2) OP_out_Prep ; -- guess-p-verb
lin bring_out_in_V3 = variants {} ; -- guess-p-verb
lin bring_over_V2 = prepV2 (lin V OP_bring_V2) OP_over_Prep ; -- guess-p-verb
lin bring_round_V2 = prepV2 (lin V OP_bring_V2) OP_round_Prep ; -- guess-p-verb
lin bring_to_V2 = prepV2 (lin V OP_bring_V2) OP_to_Prep ; -- guess-p-verb
lin bring_up_V2 = prepV2 (lin V OP_bring_V2) OP_up_Prep ; -- guess-p-verb
lin brininess_N = mkN "salinità" ; -- UWN
lin brink_N = mkN "orlo" ; -- status=guess
lin brioche_N = mkN "brioche" | mkN "brioscia" ; -- status=guess status=guess
lin briquet_N = mkN "formella" ; -- UWN
lin briquette_N = mkN "formella" ; -- UWN
lin brisbane_PN = mkPN "Brisbane" ; -- status=guess src=geonames
lin brisk_A = mkA "vivace" ; -- status=guess
lin brisket_N = mkN "punta_di_petto" ; -- UWN
lin bristle_N = mkN "pelo ispido" | mkN "barba corta ispida" ; -- status=guess status=guess
lin bristletail_N = mkN "acciughina" ; -- status=guess
lin bristly_A = mkA "spinoso" ; -- UWN
lin bristol_PN = mkPN "Bristol" ; -- status=guess src=geonames
lin brittle_A = mkA "fragile" ; -- status=guess
lin brittle_N = mkN "caramella_mou" | mkN "toffee" ; -- UWN
lin brittleness_N = mkN "fragilità" ; -- UWN
lin brixham_PN = mkPN "Brixham" ; -- status=guess src=geonames
lin brno_PN = mkPN "Brno" ; -- status=guess src=geonames
lin broad_A = L.broad_A ;
lin broad_N = mkN "fava" | mkN "baccello" ; -- status=guess status=guess
lin broadcast_N = mkN "trasmissione" ; -- status=guess
lin broadcast_V = trasmettere_V ; -- status=guess, src=wikt
lin broadcast_V2 = mkV2 (trasmettere_V) ; -- status=guess, src=wikt
lin broaden_V = mkV "allargarsi" ; -- UWN
lin broadsword_N = mkN "spadone" masculine ; -- status=guess
lin broadtail_N = mkN "caracul" | mkN "karakul" ; -- UWN
lin broadwise_Adv = mkAdv "in_larghezza" ; -- UWN
lin brocade_N = mkN "broccato" ; -- UWN
lin broccoli_N = mkN "broccolo" ; -- status=guess
lin brochure_N = variants {} ; --
lin broil_N = mkN "grigliata" ; -- UWN
lin broiler_N = mkN "bistecchiera" | mkN "griglia" ; -- UWN
lin broke_A = variants {} ; ---- mkA "al verde" ; "al verde" ;
lin broken_A = variants {} ; --
lin broker_N = mkN "acquisitore" | mkN "agente" | mkN "corrispondente" | mkN "corrispondente_commerciale" | mkN "cozzone" | mkN "intermediario" | mkN "operatore" | mkN "prosseneta" | mkN "rappresentante" | mkN "sensale" ; -- UWN
lin brolly_N = mkN "ombrello" ; -- UWN
lin bromic_A = mkA "bromico" ; -- UWN
lin bromide_N = mkN "bromuro" ; -- status=guess
lin bromine_N = mkN "bromo" ; -- status=guess
lin bromley_PN = mkPN "Distretto di Bromley" ; -- status=guess src=geonames
lin bromsgrove_PN = mkPN "Bromsgrove" ; -- status=guess src=geonames
lin bronchial_A = mkA "bronchiale" ; -- UWN
lin bronchitis_N = mkN "bronchite" feminine ; -- status=guess
lin bronchospasm_N = mkN "broncospasmo" ; -- status=guess
lin bronchus_N = mkN "bronco" ; -- status=guess
lin bronze_A = mkA "bronzeo" ; -- status=guess
lin bronze_N = mkN "bronzo" ; -- status=guess
lin bronze_V = mkV "abbronzarsi" ; -- UWN
lin brooch_N = mkN "spilla" ; -- status=guess
lin brood_N = mkN "covata" ; -- status=guess
lin brood_V = mkV "covare" ; -- status=guess, src=wikt
lin brooding_N = mkN "pensosità" ; -- UWN
lin brook_N = mkN "ruscello" | mkN "rio" | mkN "corso d'acqua" ; -- status=guess status=guess status=guess
lin broom_N = mkN "ginestra" ; -- status=guess
lin broomstick_N = mkN "manico_di_scopa" ; -- UWN
lin broth_N = mkN "brodo" ; -- status=guess
lin brothel_N = mkN "bordello" | mkN "casino" | mkN "casa d'appuntamenti" | mkN "postribolo" | mkN "lupanare" | mkN "casa chiusa" | mkN "casa di tolleranza" ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin brother_N = mkN "cognato" ; -- status=guess
lin brother_N2 = L.brother_N2 ; -- comment=CHECKED
lin brotherhood_N = mkN "fratellanza" ; -- status=guess
lin brotherly_A = mkA "fraterno" ; -- UWN
lin brotherly_Adv = adjAdv brotherly_A ; -- derived -- derived
lin broughton_PN = mkPN "Broughton" ; -- status=guess src=geonames
lin brow_N = mkN "fronte" feminine ; -- status=guess
lin brown_A = L.brown_A ;
lin brown_N = mkN "marrone" | mkN "castano" feminine ; -- status=guess status=guess
lin brown_V = mkV "rosolare" ; -- status=guess, src=wikt
lin brown_V2 = mkV2 (mkV "rosolare") ; -- status=guess, src=wikt
lin brownish_A = mkA "brunastro" | mkA "brunastra" ; -- status=guess status=guess
lin broxburn_PN = mkPN "Broxburn" ; -- status=guess src=geonames
lin bruce_PN = mkPN "Bruce" ; -- status=guess src=geonames
lin brucellosis_N = mkN "brucellosi" feminine ; -- status=guess
lin brucine_N = mkN "brucina" ; -- status=guess
lin bruges_PN = mkPN "Bruges" ; -- status=guess src=geonames
lin bruise_N = mkN "ammaccatura" ; -- status=guess
lin brunch_N = mkN "brunch" masculine ; -- status=guess
lin brunei_PN = mkPN "Brunei" ; -- status=guess src=geonames
lin brunetteFem_N = variants {} ; ---- sense to be split
lin brunetteMasc_N = variants {} ; ---- sense to be split
lin brunswick_PN = mkPN "Brunswick" ; -- status=guess src=geonames
lin brush_N = mkN "spazzola" | mkN "pennello" ; -- status=guess status=guess
lin brush_V = mkV "spennellare" ; -- status=guess, src=wikt
lin brush_V2 = mkV2 (mkV "spennellare") ; -- status=guess, src=wikt
lin brusque_A = mkA "brusco" | mkA "brusca" ; -- status=guess status=guess
lin brusqueness_N = mkN "asciuttezza" | mkN "bruschezza" | mkN "secchezza" ; -- UWN
lin brussels_PN = mkPN "Città di Bruxelles" ; -- status=guess src=geonames
lin brutal_A = variants {} ;
lin brutality_N = mkN "barbarie" | mkN "brutalità" | mkN "inciviltà" ; -- UWN
lin brutalization_N = mkN "abbrutimento" | mkN "imbrutimento" ; -- UWN
lin brute_N = mkN "bruto" ; -- status=guess
lin brutish_A = mkA "bestiale" ; -- status=guess
lin bryan_PN = mkPN "Bryan" ; -- status=guess src=geonames
lin bryony_N = mkN "brionia" ; -- status=guess
lin bubble_N = mkN "bagnoschiuma" ; -- status=guess
lin bubble_V = mkV "ruttare" ; -- UWN
lin bubbliness_N = mkN "effervescenza" ; -- UWN
lin bubbly_N = mkN "champagne" ; -- UWN
lin buccaneer_N = mkN "bucaniere" masculine ; -- status=guess
lin buck_N = mkN "damerino" | mkN "moscardino" ; -- status=guess status=guess
lin buck_V = mkV "sgroppare" ; -- status=guess, src=wikt
lin buck_V2 = mkV2 (mkV "sgroppare") ; -- status=guess, src=wikt
lin bucket_N = mkN "secchio" ; -- status=guess
lin buckeye_N = mkN "ippocastano" ; -- status=guess
lin buckhaven_PN = mkPN "Buckhaven" ; -- status=guess src=geonames
lin buckie_PN = mkPN "Buckie" ; -- status=guess src=geonames
lin buckingham_PN = mkPN "Buckingham" ; -- status=guess src=geonames
lin buckle_N = mkN "fibbia" ; -- status=guess
lin buckle_V = mkV "allacciare" ; -- status=guess, src=wikt
lin buckle_V2 = mkV2 (mkV "allacciare") ; -- status=guess, src=wikt
lin buckle_down_V = mkV "sfacchinare" | mkV "sfaticare" | mkV "sgobbare" ; -- UWN
lin buckler_N = mkN "scudo" ; -- UWN
lin buckley_PN = mkPN "Buckley" ; -- status=guess src=geonames
lin buckram_N = mkN "tela_rigida" ; -- UWN
lin buckskin_N = mkN "buckskin" ; -- UWN
lin buckwheat_N = mkN "grano saraceno" ; -- status=guess
lin bucolic_A = mkA "pastorale" ; -- UWN
lin bud_N = mkN "germoglio" | mkN "boccio" | mkN "virgulto" | mkN "pollone" masculine | mkN "getto" ; -- status=guess status=guess status=guess status=guess status=guess
lin bud_V = mkV "germogliare" ; -- status=guess, src=wikt
lin budapest_PN = mkPN "Budapest" ; -- status=guess src=geonames
lin buddhistFem_N = variants {} ; ---- sense to be split
lin buddhistMasc_N = variants {} ; ---- sense to be split
lin budding_N = mkN "gemmazione" ; -- UWN
lin buddy_N = mkN "amico" ; -- status=guess
lin budget_N = mkN "budget" masculine ; -- status=guess
lin buffalo_N = mkN "bison" masculine ; -- status=guess
lin buffalo_PN = mkPN "Buffalo" ; -- status=guess src=geonames
lin buffer_N = mkN "soluzione tampone" ; -- status=guess
lin buffet_N = mkN "buffet" | mkN "credenza" ; -- UWN
lin bufflehead_N = mkN "quattrocchi minore" ; -- status=guess
lin buffoonery_N = mkN "buffonaggine" | mkN "buffonata" | mkN "pagliacciata" ; -- UWN
lin bug_N = mkN "bacarozzo" ; -- status=guess
lin bug_V2 = mkV2 (mkV "infastidire") | mkV2 (mkV "scocciare") ; -- status=guess, src=wikt status=guess, src=wikt
lin bugger_N = mkN "gay" | mkN "sodomita" ; -- UWN
lin bugger_V = mkV "inculare" ; -- status=guess, src=wikt
lin bugger_V2 = mkV2 (mkV "inculare") ; -- status=guess, src=wikt
lin buggery_N = mkN "sodomia" ; -- UWN
lin bugler_N = mkN "tromba" | mkN "trombettiere" ; -- UWN
lin bugleweed_N = mkN "bugola" | mkN "bugula" ; -- UWN
lin build_V = mkV "costruire" | mkV "edificare" ; -- status=guess, src=wikt status=guess, src=wikt
lin build_V2 = mkV2 (mkV "costruire") | mkV2 (mkV "edificare") ; -- status=guess, src=wikt status=guess, src=wikt
lin build_up_V2 = prepV2 OP_build_V OP_up_Prep ; -- guess-p-verb
lin builder_N = mkN "costruttore" masculine ; -- status=guess
lin building_N = mkN "costruzione" feminine | mkN "edificazione" feminine ; -- status=guess status=guess
lin bulb_N = mkN "bulbo" ; -- status=guess
lin bulbil_N = mkN "bulbillo" ; -- status=guess
lin bulgaria_PN = mkPN "Bulgaria" ;
lin bulgarianFem_N = variants {} ;
lin bulgarianMasc_N = variants {} ;
lin bulgarian_A = mkA "bulgaro" ;
lin bulge_N = mkN "sporgenza" | mkN "protuberanza" | mkN "rigonfiamento" ; -- status=guess status=guess status=guess
lin bulimia_N = mkN "bulimia" ; -- status=guess
lin bulk_N = mkN "mole" ; -- UWN
lin bulkhead_N = mkN "paratia" ; -- UWN
lin bulkington_PN = mkPN "Bulkington" ; -- status=guess src=geonames
lin bulky_A = mkA "voluminoso" | mkA "massiccio" ; -- status=guess status=guess
lin bull_N = mkN "maschio" ; -- status=guess
lin bulldozer_N = mkN "bulldozer" | mkN "apripista" masculine ; -- status=guess status=guess
lin bullet_N = mkN "proiettile" masculine ; -- status=guess
lin bulletin_N = mkN "bacheca" ; -- status=guess
lin bulletproof_A = mkA "antiproiettile" ; -- status=guess
lin bullfight_N = mkN "corrida" | mkN "tauromachia" ; -- UWN
lin bullfighter_N = mkN "espada" | mkN "matador" | mkN "toreador" | mkN "torero" ; -- UWN
lin bullfighting_N = mkN "toromachia" | mkN "corrida" ; -- status=guess status=guess
lin bullion_N = mkN "lingotto" ; -- status=guess
lin bullock_N = mkN "giovenco" ; -- status=guess
lin bullring_N = mkN "arena" ; -- UWN
lin bullshit_N = mkN "cazzata" | mkN "stronzata" | mkN "coglionata" ; -- status=guess status=guess status=guess
lin bullshit_V = mkV "cazzeggiare" ; -- status=guess, src=wikt
lin bull_terrier_N = mkN "bull_terrier" ; -- UWN
lin bully_N = mkN "bullo" | mkN "spaccone" | mkN "smargiasso" | mkN "prepotente" | mkN "arrogante" masculine ; -- status=guess status=guess status=guess status=guess status=guess
lin bullying_N = mkN "bullismo" ; -- status=guess
lin bulrush_N = mkN "giunco di palude" ; -- status=guess
lin bulwark_N = mkN "impavesata" ; -- status=guess
lin bum_A = mkA "scadente" ; -- status=guess
lin bum_N = mkN "ano" ; -- status=guess
lin bum_V = mkV "oziare" | mkV (I.fare_V) "il vagando" ; -- status=guess, src=wikt status=guess, src=wikt
lin bum_V2 = mkV2 (mkV "oziare") | mkV2 (mkV (I.fare_V) "il vagando") ; -- status=guess, src=wikt status=guess, src=wikt
lin bumblebee_N = mkN "bombo" ; -- status=guess
lin bump_N = mkN "colpetto" | mkN "botta" ; -- status=guess status=guess
lin bump_V = variants {} ; --
lin bump_V2 = variants {} ; --
lin bumper_N = mkN "paraurti" ; -- UWN
lin bumpkin_N = mkN "buzzurro" ; -- status=guess
lin bun_N = mkN "crocchia" ; -- status=guess
lin bunch_N = mkN "mucchio" | mkN "mucchio" ; -- status=guess status=guess
lin bunch_V = mkV "ammucchiare" ; -- status=guess, src=wikt
lin bunch_V2 = mkV2 (mkV "ammucchiare") ; -- status=guess, src=wikt
lin bundle_N = mkN "insieme" masculine ; -- status=guess
lin bundle_up_V = mkV "imbacuccare" | mkV "infagottare" ; -- UWN
lin bung_N = mkN "zaffo" | mkN "zipolo" ; -- UWN
lin bungler_N = mkN "ciabattone" | mkN "cialtrone" | mkN "disordinato" | mkN "guastamestieri" | mkN "guazzabuglione" | mkN "impiastratore" | mkN "incapace" | mkN "pasticcione" | mkN "scalzacane" | mkN "scalzacani" | mkN "schiappa" ; -- UWN
lin bunion_N = mkN "borsite_dell'alluce" ; -- UWN
lin bunk_N = mkN "letto a castello" ; -- status=guess
lin bunker_N = mkN "bunker" masculine ; -- status=guess
lin bunny_N = mkN "coniglietta" ; -- status=guess
lin bunting_N = mkN "zigolo" ; -- UWN
lin buoy_N = mkN "grippia" ; -- status=guess
lin bur_N = mkN "fresa" ; -- UWN
lin burble_V = mkV "borbugliare" ; -- status=guess, src=wikt
lin burble_VS = mkVS (mkV "borbugliare") ; -- status=guess, src=wikt
lin burbot_N = mkN "bottatrice" feminine ; -- status=guess
lin burden_N = mkN "preoccupazione" feminine | mkN "fardello" ; -- status=guess status=guess
lin burden_V2 = mkV2 (mkV "gravare") | mkV2 (mkV "appioppare") | mkV2 (mkV "rifilare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin burdensome_A = mkA "gravoso" ; -- status=guess
lin burdensomeness_N = mkN "faticosità" | mkN "gravosità" | mkN "onerosità" | mkN "pesantezza" ; -- UWN
lin burdock_N = mkN "bardana" ; -- status=guess
lin bureau_N = mkN "cassettone" masculine | mkN "comò" ; -- status=guess status=guess
lin bureaucracy_N = variants {} ; --
lin bureaucrat_N = mkN "burocrate" ; -- UWN
lin bureaucratic_A = mkA "burocratico" ; -- UWN
lin burette_N = mkN "buretta" ; -- status=guess
lin burgeon_V = mkV "divenire" | mkV "svilupparsi" | mkV "trasformarsi" ; -- UWN
lin burgher_N = mkN "cittadino" ; -- status=guess
lin burglar_N = mkN "scassinatore" | mkN "scassinatrice" feminine ; -- status=guess status=guess
lin burgle_V = mkV "svaligiare" ; -- UWN
lin burgomaster_N = mkN "borgomastro" ; -- UWN
lin burgos_PN = mkPN "Burgos" ; -- status=guess src=geonames
lin burgundy_N = mkN "bordeaux" ; -- UWN
lin burial_N = mkN "sepoltura" | mkN "inumazione" feminine ; -- status=guess status=guess
lin burin_N = mkN "bulino" ; -- status=guess
lin burlesque_A = mkA "burlesco" ; -- status=guess
lin burlesque_N = mkN "caricatura" ; -- status=guess
lin burley_PN = mkPN "Burley" ; -- status=guess src=geonames
lin burn_N = mkN "bruciatura" | mkN "ustione" feminine ; -- status=guess status=guess
lin burn_V = L.burn_V ;
lin burn_V2 = mkV2 (mkV "bruciare") | mkV2 (ardere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin burn_down_V = advV OP_burn_V OP_down_Adv ; -- guess-p-verb
lin burn_down_V2 = prepV2 OP_burn_V OP_down_Prep ; -- guess-p-verb
lin burn_off_V2 = prepV2 OP_burn_V OP_off_Prep ; -- guess-p-verb
lin burn_out_V = advV OP_burn_V OP_out_Adv ; -- guess-p-verb
lin burn_up_V = advV OP_burn_V OP_up_Adv ; -- guess-p-verb
lin burn_up_V2 = prepV2 OP_burn_V OP_up_Prep ; -- guess-p-verb
lin burning_A = variants {} ; --
lin burnish_V = mkV "forbire" ; -- UWN
lin burnley_PN = mkPN "Burnley" ; -- status=guess src=geonames
lin burnous_N = mkN "burnus" ; -- UWN
lin burnouse_N = mkN "burnus" ; -- UWN
lin burntisland_PN = mkPN "Burntisland" ; -- status=guess src=geonames
lin burntwood_PN = mkPN "Burntwood" ; -- status=guess src=geonames
lin burp_N = mkN "rutto" ; -- status=guess
lin burp_V = mkV "ruttare" ; -- status=guess, src=wikt
lin burp_V2 = mkV2 (mkV "ruttare") ; -- status=guess, src=wikt
lin burr_N = mkN "sbavatura" | mkN "bava" ; -- status=guess status=guess
lin burrow_N = mkN "tana" ; -- status=guess
lin burrow_V = mkV (mkV "scavare") "una tana" ; -- status=guess, src=wikt
lin burrow_V2 = mkV2 (mkV (mkV "scavare") "una tana") ; -- status=guess, src=wikt
lin bursar_N = mkN "economo" ; -- UWN
lin bursitis_N = mkN "borsite" | mkN "bursite" ; -- UWN
lin burst_N = mkN "scoppio" | mkN "esplosione" feminine ; -- status=guess status=guess
lin burst_V = mkV "scoppiare" | esplodere_V ; -- status=guess, src=wikt status=guess, src=wikt
lin burst_V2 = mkV2 (mkV "scoppiare") | mkV2 (esplodere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin burst_into_V2 = prepV2 OP_burst_V OP_into_Prep ; -- guess-p-verb
lin burundi_PN = mkPN "Burundi" ; -- status=guess src=geonames
lin bury_PN = mkPN "Bury" ; -- status=guess src=geonames
lin bury_V = mkV "sotterrare" | mkV "nascondere" | mkV "sprofondare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin bury_V2 = mkV2 (mkV "sotterrare") | mkV2 (mkV "nascondere") | mkV2 (mkV "sprofondare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin burying_N = mkN "interramento" | mkN "inumazione" | mkN "sotterramento" ; -- UWN
lin bus_N = mkN "bus" masculine ; -- status=guess
lin busbar_N = mkN "canale" | mkN "sbarra_collettrice" ; -- UWN
lin busby_N = mkN "colbac" | mkN "colbacco" ; -- UWN
lin bush_N = mkN "arbusto" | mkN "cespuglio" ; -- status=guess status=guess
lin bushing_N = mkN "bronzina" ; -- UWN
lin business_N = mkN "azienda" ; -- status=guess
lin businessman_N = mkN "uomo d'affari" ; -- status=guess
lin businessperson_N = mkN "borghese" ; -- UWN
lin businesswoman_N = mkN "donna d'affari" ; -- status=guess
lin busker_N = mkN "artista di strada" ; -- status=guess
lin bust_N = mkN "busto" ; -- status=guess
lin bust_V = mkV "scoppiare" ;
lin bust_V2 = mkV2 (mkV I.fare_V "scoppiare") ;
lin busy_A = mkA "occupato" ; -- status=guess
lin busybody_N = mkN "intrigante" masculine | mkN "ficcanaso" ; -- status=guess status=guess
lin but_Adv = mkAdv "appena" | mkAdv "giusto" | mkAdv "proprio" | mkAdv "semplicemente" | mkAdv "solamente" | mkAdv "solo" | mkAdv "soltanto" ; -- UWN
lin but_Conj = mkConj "ma" ;
lin but_PConj = S.but_PConj ; -- comment=CHECKED
lin butane_N = mkN "butano" ; -- status=guess
lin butcher_N = mkN "macellaio" ; -- status=guess
lin butcher_V2 = mkV2 (mkV "rovinare") ; -- status=guess, src=wikt
lin butler_N = mkN "maggiordomo" ; -- status=guess
lin butt_N = mkN "cornata" | mkN "culo" feminine | mkN "sedere" masculine ;
lin butt_V = mkV "cozzare" ; -- status=guess, src=wikt
lin butt_V2 = mkV2 (mkV "cozzare") ; -- status=guess, src=wikt
lin butt_in_V = mkV "intromettersi" ; -- UWN
lin butter_N = L.butter_N ;
lin butter_V2 = mkV2 (mkV "imburrare") ; -- status=guess, src=wikt
lin buttercup_N = mkN "ranuncolo" ; -- status=guess
lin butterfingers_N = mkN "mani_di_ricotta" ; -- UWN
lin butterfly_N = mkN "farfalla" ; -- status=guess
lin buttermilk_N = mkN "latticello" ; -- status=guess
lin butternut_N = mkN "zucca torta" | mkN "zucca pepona" ; -- status=guess status=guess
lin butterwort_N = mkN "pinguicola" ; -- UWN
lin buttock_N = mkN "gluteo" | mkN "natica" | mkN "deretano" ;
lin button_N = mkN "pulsante" masculine ; -- status=guess
lin buttonhole_N = mkN "occhiello" | mkN "asola" ; -- status=guess status=guess
lin buttress_N = mkN "supporto" | mkN "corroborazione" feminine | mkN "sperone" masculine ; -- status=guess status=guess status=guess
lin buttress_V2 = mkV2 (mkV "appoggiare") | mkV2 (sostenere_V) | mkV2 (mkV "rafforzare") | mkV2 (mkV "corroborare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin butyl_N = mkN "butile" masculine ; -- status=guess
lin butylene_N = mkN "butilene" ; -- UWN
lin butyric_A = mkA "butirrico" ; -- UWN
lin buxom_A = mkA "formosa" | mkA "prosperosa" ; -- status=guess status=guess
lin buxomness_N = mkN "formosità" ; -- UWN
lin buxton_PN = mkPN "Buxton" ; -- status=guess src=geonames
lin buy_N = mkN "affare" | mkN "offerta_eccezionale" ; -- UWN
lin buy_V = mkV "comprare" ; -- status=guess, src=wikt
lin buy_V2 = L.buy_V2 ;
lin buy_back_V2 = mkV2 (advV OP_buy_V OP_back_Adv ) ; -- guess-p-verb
lin buy_in_V2 = prepV2 OP_buy_V OP_in_Prep ; -- guess-p-verb
lin buy_into_V2 = prepV2 OP_buy_V OP_into_Prep ; -- guess-p-verb
lin buy_off_V2 = prepV2 OP_buy_V OP_off_Prep ; -- guess-p-verb
lin buy_out_V2 = prepV2 OP_buy_V OP_out_Prep ; -- guess-p-verb
lin buy_up_V2 = prepV2 OP_buy_V OP_up_Prep ; -- guess-p-verb
lin buyerFem_N = mkN "acquirente" | mkN "compratore" | mkN "oblatore" | mkN "offerente" ; -- UWN
lin buyerMasc_N = variants {} ; --
lin buying_N = mkN "acquisto" ; -- UWN
lin buzz_N = mkN "brusio" ; -- status=guess
lin buzzard_N = mkN "poiana" ; -- status=guess
lin by8agent_Prep = S.by8agent_Prep ; -- comment=CHECKED
lin by8means_Prep = S.by8means_Prep ; -- comment=CHECKED
lin by_Adv = mkAdv "a proposito" ; -- status=guess
lin by_Prep = mkPrep "per" ;
lin bye_Interj = mkInterj "ciao" ;
lin bypass_N = mkN "circonvallazione" | mkN "tangenziale" ; -- UWN
lin bypath_N = mkN "strada_secondaria" ; -- UWN
lin byplay_N = mkN "controscena" ; -- status=guess
lin byproduct_N = mkN "derivato" | mkN "sottoprodotto" ; -- UWN
lin byroad_N = mkN "strada_secondaria" ; -- UWN
lin byssus_N = mkN "bisso" ; -- UWN
lin bystander_N = mkN "astante" ; -- UWN
lin byte_N = mkN "byte" masculine ; -- status=guess
lin byway_N = mkN "strada_secondaria" ; -- UWN
lin cab_N = mkN "cabina" ; -- status=guess
lin cabal_N = mkN "complotto" | mkN "congiura" | mkN "intrigo" | mkN "trama" ; -- UWN
lin cabana_N = mkN "cabina" | mkN "casotto" ; -- UWN
lin cabaret_N = mkN "cabaret" masculine ; -- status=guess
lin cabbage_N = mkN "cavolo" ; -- status=guess
lin cabby_N = mkN "tassista" | mkN "taxista" ; -- UWN
lin cabin_N = mkN "cabina" ; -- status=guess
lin cabinet_N = mkN "consiglio" ; -- status=guess
lin cabinet_maker_N = mkN "ebanista" masculine ; -- status=guess
lin cabinetmaking_N = mkN "falegnameria" ; -- UWN
lin cable_N = mkN "cavo" ; -- status=guess
lin cable_V = mkV "cablare" ; -- status=guess, src=wikt
lin cable_V2 = mkV2 (mkV "cablare") ; -- status=guess, src=wikt
lin cablegram_N = mkN "cablo" | mkN "cablogramma" ; -- UWN
lin cabman_N = mkN "tassista" | mkN "taxista" ; -- UWN
lin cabochon_N = mkN "cabochon" ; -- UWN
lin cabotage_N = mkN "cabotaggio" ; -- UWN
lin cacao_N = mkN "cacao" ; -- status=guess
lin cache_N = mkN "memoria cache" ; -- status=guess
lin cachexia_N = mkN "cachessia" ; -- UWN
lin cackle_N = mkN "verso" ; -- status=guess
lin cacophonous_A = mkA "cacofonico" | mkA "disarmonico" | mkA "stonato" ; -- UWN
lin cacophony_N = mkN "cacofonia" ; -- status=guess
lin cactus_N = mkN "cactus" masculine ; -- status=guess
lin cadaster_N = mkN "catasto" ; -- UWN
lin cadastral_A = mkA "catastale" ; -- UWN
lin cadaver_N = mkN "cadavere" masculine ; -- status=guess
lin cadaverine_N = mkN "cadaverina" ; -- UWN
lin caddie_N = mkN "portamazze" ; -- UWN
lin cadenza_N = mkN "cadenza" ; -- status=guess
lin cadet_N = mkN "cadetto" ; -- status=guess
lin cadger_N = mkN "mangiapane" | mkN "mangiaufo" | mkN "parasita" | mkN "parassita" | mkN "sbafatore" | mkN "scroccatore" | mkN "scroccone" ; -- UWN
lin cadiz_PN = mkPN "Cadice" ; -- status=guess src=geonames
lin cadmium_N = mkN "cadmio" ; -- status=guess
lin cadre_N = mkN "quadro" ; -- UWN
lin caduceus_N = mkN "caduceo" | mkN "vincastro" ; -- UWN
lin caecilian_N = mkN "cecilia" ; -- UWN
lin caen_PN = mkPN "Caen" ; -- status=guess src=geonames
lin caerleon_PN = mkPN "Caerleon" ; -- status=guess src=geonames
lin caernarfon_PN = mkPN "Caernarfon" ; -- status=guess src=geonames
lin caerphilly_PN = mkPN "Caerphilly" ; -- status=guess src=geonames
lin cafe_N = variants {} ; --
lin cafeteria_N = mkN "mensa" ;
lin caffeine_N = mkN "caffeina" ; -- status=guess
lin cage_N = mkN "gabbia" ; -- status=guess
lin cagliari_PN = mkPN "Casteddu" ; -- status=guess src=geonames
lin cagoule_N = mkN "K-way" ; -- UWN
lin caiman_N = mkN "caimano" ; -- UWN
lin cairn_N = mkN "ometto" ; -- status=guess
lin cairngorm_N = mkN "quarzo_affumicato" ; -- UWN
lin cairo_PN = mkPN "Il Cairo" ; -- status=guess src=geonames
lin cajolery_N = mkN "blandizie" | mkN "lusinghe" | mkN "moina" | mkN "moine" ; -- UWN
lin cake_N = mkN "torta" | mkN "pasticcino" | mkN "dolce" masculine ; --- split
lin calabash_N = mkN "calabassa" ; -- status=guess
lin calamity_N = mkN "calamità" feminine ; -- status=guess
lin calcareous_A = mkA "calcareo" | mkA "calcarea" ; -- status=guess status=guess
lin calceolaria_N = mkN "calceolaria" ; -- UWN
lin calceolate_A = mkA "calceolato" ; -- UWN
lin calcic_A = mkA "calcico" ; -- UWN
lin calciferous_A = mkA "calcifero" ; -- UWN
lin calcification_N = mkN "calcificazione" feminine ; -- status=guess
lin calcify_V = mkV "calcificarsi" ; -- status=guess, src=wikt
lin calcify_V2 = mkV2 (mkV "calcificarsi") ; -- status=guess, src=wikt
lin calcination_N = mkN "calcinazione" feminine ; -- status=guess
lin calcine_V = mkV "calcinare" ; -- status=guess, src=wikt
lin calcine_V2 = mkV2 (mkV "calcinare") ; -- status=guess, src=wikt
lin calcite_N = mkN "calcite" feminine ; -- status=guess
lin calcitonin_N = mkN "calcitonina" ; -- status=guess
lin calcium_N = mkN "calcio" ; -- status=guess
lin calculable_A = mkA "calcolabile" ; -- UWN
lin calculate_V = mkV "calcolare" ; -- status=guess, src=wikt
lin calculate_V2 = mkV2 (mkV "calcolare") ; -- status=guess, src=wikt
lin calculate_VS = mkVS (mkV "calcolare") ; -- status=guess, src=wikt
lin calculation_N = mkN "conto" ; -- status=guess
lin calculator_N = mkN "calcolatore" | mkN "calcolatrice" feminine ; -- status=guess status=guess
lin calculous_A = mkA "calcoloso" ; -- UWN
lin calculus_N = mkN "tartaro" | mkN "tartaro dentario" ; -- status=guess status=guess
lin calcutta_PN = mkPN "Calcutta" ; -- status=guess src=geonames
lin caldera_N = mkN "caldera" ; -- status=guess
lin caldicot_PN = mkPN "Caldicot" ; -- status=guess src=geonames
lin calendar_N = mkN "calendario" ; -- status=guess
lin calender_N = mkN "calandra" | mkN "cilindro" ; -- UWN
lin calendula_N = mkN "calendola" | mkN "calendula" | mkN "calta" ; -- UWN
lin calf_N = mkN "polpaccio" ; -- status=guess
lin cali_PN = mkPN "Cali" ; -- status=guess src=geonames
lin calibrate_V2 = mkV2 (mkV "calibrare") ; -- status=guess, src=wikt
lin calibration_N = mkN "calibrazione" feminine ; -- status=guess
lin calico_N = mkN "calicò" masculine ; -- status=guess
lin calif_N = mkN "califfo" ; -- UWN
lin california_PN = mkPN "California" ; -- status=guess src=geonames
lin californium_N = mkN "californio" ; -- status=guess
lin caliper_N = mkN "calibro" ; -- UWN
lin caliph_N = mkN "califfo" ; -- status=guess
lin caliphate_N = mkN "califfato" ; -- status=guess
lin calisthenics_N = mkN "callistenia" ; -- status=guess
lin call_N = mkN "richiamo" | mkN "chiamata" | mkN "convocazione" feminine ; -- status=guess status=guess status=guess
lin call_V = mkV "chiamare" ;
lin call_V2 = mkV2 (mkV "chiamare") ;
lin call_after_V2 = prepV2 OP_call_V OP_after_Prep ; -- guess-p-verb
lin call_around_V = advV OP_call_V OP_around_Adv ; -- guess-p-verb
lin call_back_V2 = mkV2 (advV OP_call_V OP_back_Adv ) ; -- guess-p-verb
lin call_for_V2V = variants {} ; -- guess-p-verb
lin call_forth_V2 = mkV2 (advV OP_call_V OP_forth_Adv ) ; -- guess-p-verb
lin call_in_V = advV OP_call_V OP_in_Adv ; -- guess-p-verb
lin call_in_V2 = prepV2 OP_call_V OP_in_Prep ; -- guess-p-verb
lin call_off_V2 = prepV2 OP_call_V OP_off_Prep ; -- guess-p-verb
lin call_on_V = advV OP_call_V OP_on_Adv ; -- guess-p-verb
lin call_on_V2 = prepV2 OP_call_V OP_on_Prep ; -- guess-p-verb
lin call_out_V2 = prepV2 OP_call_V OP_out_Prep ; -- guess-p-verb
lin call_over_V = advV OP_call_V OP_over_Adv ; -- guess-p-verb
lin call_round_V = advV OP_call_V OP_round_Adv ; -- guess-p-verb
lin call_up_V2 = prepV2 OP_call_V OP_up_Prep ; -- guess-p-verb
lin calligrapher_N = mkN "calligrafo" ; -- status=guess
lin calligraphic_A = mkA "calligrafico" ; -- status=guess
lin calligraphy_N = mkN "calligrafia" ; -- status=guess
lin calling_N = mkN "vocazione" feminine | mkN "chiamata" ; -- status=guess status=guess
lin callosity_N = mkN "durezza" | mkN "insensibilità" ; -- UWN
lin callous_A = mkA "cinico" | mkA "insensibile" ; -- status=guess status=guess
lin callousness_N = mkN "durezza" | mkN "insensibilità" ; -- UWN
lin callow_A = mkA "calvo" | mkA "calvi" ; -- status=guess status=guess
lin callus_N = mkN "callo" ; -- status=guess
lin calm_A = variants {} ; --
lin calm_N = mkN "la quiete prima della tempesta" ; -- status=guess
lin calm_V = variants {} ; --
lin calm_V2 = variants {} ; --
lin calmness_N = mkN "calma" | mkN "compostezza" | mkN "flemma" | mkN "placidità" ; -- UWN
lin calne_PN = mkPN "Calne" ; -- status=guess src=geonames
lin calomel_N = mkN "calomelano" ; -- status=guess
lin calorie_N = mkN "caloria" ; -- status=guess
lin calorimeter_N = mkN "calorimetro" ; -- status=guess
lin calorimetric_A = mkA "calorimetrico" ; -- status=guess
lin calorimetry_N = mkN "calorimetria" ; -- status=guess
lin calque_N = mkN "calco" ; -- status=guess
lin caltrop_N = mkN "tribulo comune" ; -- status=guess
lin calumet_N = mkN "calumet" ; -- UWN
lin calumniate_V2 = mkV2 (mkV "calunniare") ; -- status=guess, src=wikt
lin calvaria_N = mkN "volta_cranica" ; -- UWN
lin calvary_N = mkN "Calvario" | mkN "calvario" ; -- UWN
lin calverton_PN = mkPN "Calverton" ; -- status=guess src=geonames
lin calving_N = mkN "parto" ; -- UWN
lin calyceal_A = mkA "calicino" ; -- UWN
lin calyptra_N = mkN "caliptra" | mkN "calittra" ; -- UWN
lin calyx_N = mkN "calice" masculine ; -- status=guess
lin cam_N = mkN "camma" ; -- status=guess
lin camail_N = mkN "ventaglia" ; -- UWN
lin cambodia_PN = mkPN "Cambogia" ; -- status=guess src=geonames
lin cambric_N = mkN "batista" | mkN "battista" ; -- UWN
lin cambridge_PN = mkPN "Cambridge" ; -- status=guess src=geonames
lin camden_PN = mkPN "Camden" ; -- status=guess src=geonames
lin camel_N = mkN "cammello" ; -- status=guess
lin camellia_N = mkN "camelia" ; -- status=guess
lin cameo_N = mkN "cammeo" ; -- status=guess
lin camera_N = L.camera_N ;
lin cameraman_N = mkN "operatore" masculine | mkN "addetto" ; -- status=guess status=guess
lin cameroon_PN = mkPN "Camerun" ; -- status=guess src=geonames
lin camlet_N = mkN "cammellotto" ; -- status=guess
lin camomile_N = mkN "camomilla" ; -- status=guess
lin camouflage_N = mkN "camuffamento" ; -- status=guess
lin camp_N = mkN "campo" | mkN "accampamento" ; -- status=guess status=guess
lin camp_out_V = mkV "attendarsi" | mkV "bivaccare" | mkV "campeggiare" ; -- UWN
lin campaign_N = mkN "campagna" ; -- status=guess
lin campaign_V = variants {} ; --
lin campaigner_N = mkN "candidato" ; -- UWN
lin campanile_N = mkN "torre_campanaria" ; -- UWN
lin campanula_N = mkN "campanella" | mkN "campanula" ; -- UWN
lin campanulate_A = mkA "campaniforme" ; -- UWN
lin campbeltown_PN = mkPN "Campbeltown" ; -- status=guess src=geonames
lin camper_N = mkN "autocaravan" | mkN "camper" | mkN "motocaravan" | mkN "motorcaravan" ; -- UWN
lin camphor_N = mkN "canfora" ; -- status=guess
lin camphorated_A = mkA "canforato" ; -- status=guess
lin camphoric_A = mkA "canforico" ; -- UWN
lin camping_N = mkN "accampamento" | mkN "campeccio" | mkN "campeggio" ; -- UWN
lin campion_N = mkN "licnide" | mkN "silene" | mkN "strigolo" ; -- UWN
lin camshaft_N = mkN "albero_a_camme" ; -- UWN
lin can8know_VV = S.can8know_VV ; -- comment=CHECKED
lin can_1_VV = S.can_VV ;
lin can_2_VV = S.can8know_VV ;
lin can_N = mkN "annaffiatoio" ; -- status=guess
lin can_V2 = mkV2 (potere_V) ; -- status=guess, src=wikt
lin canada_PN = mkPN "Canada" ; -- status=guess src=geonames
lin canal_N = mkN "canale" masculine ; -- status=guess
lin canalization_N = mkN "canalizzazione" ; -- UWN
lin canary_A = mkA "canarino" ; -- status=guess
lin canary_N = mkN "canario" | mkN "canarino" | mkN "canarino" ; -- status=guess status=guess status=guess
lin canasta_N = mkN "canasta" ; -- UWN
lin canberra_PN = mkPN "Canberra" ; -- status=guess src=geonames
lin cancan_N = mkN "cancan" ; -- UWN
lin cancel_V = mkV "depennare" | mkV "cancellare" | mkV "eliminare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin cancel_V2 = mkV2 (mkV "depennare") | mkV2 (mkV "cancellare") | mkV2 (mkV "eliminare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin cancellation_N = mkN "cancellazione" feminine ; -- status=guess
lin cancer_N = mkN "cancro" ; -- status=guess
lin cancerous_A = mkA "canceroso" ; -- status=guess
lin candelabrum_N = mkN "candelabro" ; -- status=guess
lin candid_A = mkA "candido" ; -- status=guess
lin candidacy_N = mkN "candidatura" ; -- status=guess
lin candidateFem_N = mkN "candidato" ; -- UWN
lin candidateMasc_N = variants {} ; --
lin candidiasis_N = mkN "candidosi" feminine ; -- status=guess
lin candle_N = mkN "candela" ; -- status=guess
lin candlemaker_N = mkN "candelaio" ; -- UWN
lin candle_power_N = mkN "intensità in candele" ; -- status=guess
lin candlestick_N = mkN "candelabro" ; -- status=guess
lin candor_N = mkN "franchezza" ; -- UWN
lin candour_N = mkN "franchezza" ; -- UWN
lin candy_N = mkN "caramella" masculine ; -- status=guess
lin candy_V = mkV "confettare" | mkV "smaltare" ; -- UWN
lin cane_N = mkN "bastone" masculine ; -- status=guess
lin cane_V2 = mkV2 (mkV "battere") ; -- status=guess, src=wikt
lin canebrake_N = mkN "canneto" ; -- UWN
lin canine_A = mkA "canino" ; -- status=guess
lin canine_N = mkN "canino" ; -- status=guess
lin canister_N = mkN "barattolo" ; -- UWN
lin cannabis_N = mkN "canapa" ; -- status=guess
lin cannelloni_N = mkN "cannelloni" ; -- UWN
lin cannes_PN = mkPN "Cannes" ; -- status=guess src=geonames
lin cannibal_N = mkN "cannibale" masculine | mkN "antropofago" ; -- status=guess status=guess
lin cannibalism_N = mkN "cannibalismo" ; -- status=guess
lin cannibalistic_A = mkA "cannibalesco" | mkA "cannibalistico" ; -- status=guess status=guess
lin cannock_PN = mkPN "Cannock" ; -- status=guess src=geonames
lin cannon_1_N = mkN "cannone" masculine ; -- status=guess
lin cannon_2_N = mkN "cannone" masculine ; -- status=guess
lin cannonade_N = mkN "cannoneggiamento" ; -- status=guess
lin cannonball_N = mkN "palla_di_cannone" ; -- UWN
lin cannula_N = mkN "cannula" ; -- UWN
lin canoe_N = mkN "canoa" ; -- status=guess
lin canoe_V2 = mkV2 (mkV (andare_V) "in canoa") ; -- status=guess, src=wikt
lin canoeist_N = mkN "canoista" masculine ; -- status=guess
lin canon_N = mkN "canone" masculine ; -- status=guess
lin canonist_N = mkN "canonista" masculine ; -- status=guess
lin canonize_V2 = mkV2 (mkV "santificare") | mkV2 (mkV "canonizzare") ; -- status=guess, src=wikt status=guess, src=wikt
lin canopy_N = mkN "baldacchino" ; -- status=guess
lin cantaloupe_N = mkN "cantalupo" | mkN "zatta" ; -- status=guess
lin cantankerous_A = mkA "stizzoso" ; -- status=guess
lin cantata_N = mkN "cantata" | mkN "oratorio" ; -- UWN
lin canteen_N = mkN "mensa" ; -- status=guess
lin canterbury_PN = mkPN "Canterbury" ; -- status=guess src=geonames
lin canticle_N = mkN "cantico" ; -- UWN
lin cantilever_N = mkN "trave_a_sbalzo" ; -- UWN
lin canto_N = mkN "canto" ; -- UWN
lin canton_N = mkN "cantone" masculine ; -- status=guess
lin canton_PN = mkPN "Canton" ; -- status=guess src=geonames
lin cantonal_A = mkA "cantonale" ; -- UWN
lin cantonment_N = mkN "accampamento" | mkN "accantonamento" | mkN "acquartieramento" | mkN "attendamento" | mkN "baraccamento" | mkN "campeggiamento" | mkN "campo" ; -- UWN
lin canvas_N = mkN "tela" ; -- status=guess
lin canvasser_N = mkN "scrutatore" | mkN "scrutinatore" ; -- UWN
lin canyon_N = mkN "gola" ; -- status=guess
lin cap_1_N = L.cap_N ;
lin cap_2_N = L.cap_N ;
lin capability_N = variants {} ; --
lin capable_of_A2 = mkA2 (mkA "capace") (mkPrep "con") ; -- status=guess
lin capacious_A = mkA "capace" ; -- status=guess
lin capacitance_N = mkN "capacità" feminine ; -- status=guess
lin capacitor_N = mkN "condensatore" | mkN "condensatore_elettrico" ; -- UWN
lin capacity_N = variants {} ; --
lin caparison_N = mkN "bardatura" | mkN "groppiera" | mkN "gualdrappa" ; -- UWN
lin cape_N = mkN "cappa" | mkN "mantellina" ; -- status=guess status=guess
lin caper_N = mkN "sobbalzo" | mkN "saltellamento" ; -- status=guess status=guess
lin caper_V = mkV "saltellare" ; -- status=guess, src=wikt
lin capercaillie_N = mkN "urogallo" | mkN "gallo cedrone" ; -- status=guess status=guess
lin capillarity_N = mkN "capillarità" feminine ; -- status=guess
lin capillary_N = mkN "capillare" masculine | mkN "vaso capillare" ; -- status=guess status=guess
lin capital_1_N = variants {} ; --
lin capital_2_N = variants {} ; --
lin capital_3_N = variants {} ; --
lin capital_A = mkA "ottimo" | mkA "magnifico" | mkA "eccellente" | mkA "splendido" ; -- status=guess status=guess status=guess status=guess
lin capital_N = mkN "capitale" ;
lin capitalism_N = mkN "capitalismo" ; -- status=guess
lin capitalist_N = variants {} ; --
lin capitation_N = mkN "capitazione" ; -- UWN
lin capitular_A = mkA "capitolare" ; -- UWN
lin capitulation_N = mkN "caduta" | mkN "capitolazione" | mkN "resa" ; -- UWN
lin capon_N = mkN "cappone" masculine ; -- status=guess
lin capote_N = mkN "schiavina" ; -- UWN
lin cappuccino_N = mkN "cappuccino" ; -- status=guess
lin capriccio_N = mkN "capriccio" ; -- status=guess
lin caprice_N = mkN "capriccio" | mkN "estro" | mkN "fantasia" | mkN "ghiribizzo" | mkN "grillo" | mkN "ruzzo" | mkN "schiribizzo" | mkN "sfizio" | mkN "sghiribizzo" | mkN "ticchio" ; -- UWN
lin capsicum_N = mkN "capsico" ; -- status=guess
lin capsid_N = mkN "capside" ; -- UWN
lin capsize_V = mkV "capovolgersi" | mkV "ribaltarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin capsize_V2 = mkV2 (mkV "capovolgersi") | mkV2 (mkV "ribaltarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin capstan_N = mkN "cabestano" ; -- status=guess
lin captain_N = mkN "capitano di vascello" ; -- status=guess
lin captainship_N = mkN "capitanato" ; -- UWN
lin caption_N = mkN "intestazione" feminine ; -- status=guess
lin captivate_V2 = mkV2 (mkV "catturare") ;
lin captivation_N = mkN "ammaliamento" | mkN "attrattiva" | mkN "attrazione" | mkN "incanto" ; -- UWN
lin captiveFem_N = mkN "prigioniero" ; -- status=guess ---- sense to be split
lin captiveMasc_N = mkN "prigioniero" ; -- status=guess ---- sense to be split
lin captive_A = mkA "catturato" | mkA "intrappolato" ; -- status=guess status=guess
lin captive_N = mkN "prigioniero" ; -- status=guess
lin captivity_N = mkN "cattività" feminine ; -- status=guess
lin capture_V2 = variants {} ; --
lin capuchin_N = mkN "cappa" | mkN "kappa" ; -- UWN
lin caput_N = mkN "capo" | mkN "testa" ; -- UWN
lin car_N = L.car_N ;
lin car_V = variants {} ; --
lin caracal_N = mkN "caracal" | mkN "lince persiana" ; -- status=guess status=guess
lin caracas_PN = mkPN "Caracas" ; -- status=guess src=geonames
lin carafe_N = mkN "boccia" | mkN "caraffa" | mkN "guastada" ; -- UWN
lin caramel_N = mkN "caramello" ; -- status=guess
lin carat_N = mkN "carato" ; -- status=guess
lin caravan_N = variants {} ; --
lin caravanserai_N = mkN "caravanserraglio" ; -- status=guess
lin caraway_N = mkN "carvi" | mkN "cumino dei prati" | mkN "cumino" ; -- status=guess status=guess status=guess
lin carbide_N = mkN "carburo" ; -- status=guess
lin carbine_N = mkN "carabina" ; -- status=guess
lin carbohydrate_N = mkN "carboidrato" ; -- status=guess
lin carbon_N = mkN "carbonio" ; -- status=guess
lin carbonaceous_A = mkA "carbonico" ; -- UWN
lin carbonate_N = mkN "carbonato" ; -- status=guess
lin carbonated_A = mkA "gassato" | mkA "effervescente" ; -- status=guess status=guess
lin carbonation_N = mkN "gassatura" ; -- UWN
lin carbonic_A = mkA "carbonico" | mkA "carbonica" ; -- status=guess status=guess
lin carboniferous_A = mkA "carbonico" ; -- UWN
lin carbonization_N = mkN "carbonizzazione" feminine ; -- status=guess
lin carbonize_V2 = mkV2 (mkV "carbonizzare") ; -- status=guess, src=wikt
lin carbonyl_N = mkN "ossicloruro di carbonio" ; -- status=guess
lin carborundum_N = mkN "carborundo" | mkN "carborundum" ; -- UWN
lin carboxyl_N = mkN "carbossile" masculine ; -- status=guess
lin carboy_N = mkN "damigiana" ; -- UWN
lin carbuncle_N = mkN "carbonchio" ; -- UWN
lin carcinogenic_A = mkA "cancerogeno" | mkA "oncogeno" ; -- UWN
lin carcinoid_N = mkN "carcinoide" masculine ; -- status=guess
lin carcinoma_N = mkN "carcinoma" ; -- UWN
lin carcinomatous_A = mkA "carcinomatoso" ; -- UWN
lin card_1_N = mkN "scheda" | mkN "carta" ; -- status=guess status=guess
lin card_2_N = mkN "scheda" | mkN "carta" ; -- status=guess status=guess
lin card_V2 = mkV2 (mkV "schedare") ; -- status=guess, src=wikt
lin cardamom_N = mkN "cardamomo" ; -- status=guess
lin cardboard_N = mkN "cartone" masculine ; -- status=guess
lin cardcase_N = mkN "portabiglietti" ; -- UWN
lin cardenden_PN = mkPN "Cardenden" ; -- status=guess src=geonames
lin cardia_N = mkN "cardias" masculine ; -- status=guess
lin cardiac_A = mkA "cardiale" ; -- status=guess
lin cardiff_PN = mkPN "Cardiff" ; -- status=guess src=geonames
lin cardigan_N = mkN "cardigan" ; -- status=guess
lin cardigan_PN = mkPN "Cardigan" ; -- status=guess src=geonames
lin cardinal_A = mkA "cardinale" ; -- status=guess
lin cardinal_N = mkN "cardinale" masculine ; -- status=guess
lin cardinality_N = mkN "cardinalità" | mkN "numerosità" feminine | mkN "potenza" ; -- status=guess status=guess status=guess
lin cardinalship_N = mkN "cardinalato" ; -- UWN
lin cardiograph_N = mkN "cardiografo" ; -- status=guess
lin cardioid_N = mkN "cardioide" feminine ; -- status=guess
lin cardiologistFem_N = variants {} ; ---- sense to be split
lin cardiologistMasc_N = mkN "cardiologo" ; -- UWN
lin cardiology_N = mkN "cardiologia" ; -- status=guess
lin cardiopulmonary_A = mkA "cardiopolmonare" ; -- status=guess
lin cardiospasm_N = mkN "cardiospasmo" ; -- UWN
lin cardiovascular_A = mkA "cardiovascolare" ; -- status=guess
lin carditis_N = mkN "cardite" feminine ; -- status=guess
lin cardoon_N = mkN "cardone" feminine ; -- status=guess
lin cardsharp_N = mkN "baro" ; -- UWN
lin care_N = mkN "cura" | mkN "attenzione" feminine ; -- status=guess status=guess
lin care_V = mkV "curare" ; -- status=guess, src=wikt
lin care_for_V2 = prepV2 OP_care_V OP_for_Prep ; -- guess-p-verb
lin career_N = mkN "carriera" ; -- status=guess
lin careerism_N = mkN "carrierismo" ; -- UWN
lin careerist_N = mkN "carrierista" ; -- UWN
lin carefree_A = mkA "libero da preoccupazioni" | mkA "spensierato" ; -- status=guess status=guess
lin careful_A = mkA "prudente" | mkA "cauto" ; -- status=guess status=guess
lin carelessness_N = mkN "negligenza" ; -- status=guess
lin carer_N = variants {} ; --
lin caress_N = mkN "carezza" | mkN "vezzo" ; -- UWN
lin caress_V2 = mkV2 (mkV "accarezzare") ; -- status=guess, src=wikt
lin caressing_N = mkN "sbaciucchiamento" | mkN "vezzeggiamento" ; -- UWN
lin cargo_N = mkN "carico" | mkN "merce" | mkN "spedizione" ; -- UWN
lin caribou_N = mkN "caribù" masculine ; -- status=guess
lin caricature_N = mkN "caricatura" ; -- UWN
lin caricaturist_N = mkN "caricaturista" | mkN "macchiettista" ; -- UWN
lin caries_N = mkN "carie" ; -- UWN
lin carina_N = mkN "carena" ; -- UWN
lin carlisle_PN = mkPN "Carlisle" ; -- status=guess src=geonames
lin carlow_PN = mkPN "Carlow" ; -- status=guess src=geonames
lin carluke_PN = mkPN "Carluke" ; -- status=guess src=geonames
lin carmarthen_PN = mkPN "Carmarthen" ; -- status=guess src=geonames
lin carmine_N = mkN "carminio" ; -- status=guess
lin carnage_N = mkN "carneficina" ; -- status=guess
lin carnation_N = mkN "garofano" ; -- status=guess
lin carnauba_N = mkN "cera di carnauba" ; -- status=guess
lin carnelian_N = mkN "cornalina" ; -- status=guess
lin carnforth_PN = mkPN "Carnforth" ; -- status=guess src=geonames
lin carnival_N = mkN "carnevale" masculine ; -- status=guess
lin carnivore_N = mkN "carnivoro" ; -- status=guess
lin carnoustie_PN = mkPN "Carnoustie" ; -- status=guess src=geonames
lin carol_N = mkN "carola" ; -- UWN
lin carolina_PN = mkPN "Carolina" ; -- status=guess src=geonames
lin carom_N = mkN "carambola" ; -- UWN
lin carotene_N = mkN "carotene" masculine ; -- status=guess
lin carotenoid_N = mkN "carotenoide" masculine ; -- status=guess
lin carouse_V2 = mkV2 (mkV "ubriacarsi") ; -- status=guess, src=wikt
lin carousel_N = mkN "giostra" ; -- UWN
lin carp_N = mkN "carpa" ; -- status=guess
lin carpal_A = mkA "carpale" ; -- UWN
lin carpal_N = mkN "tunnel carpale" ; -- status=guess
lin carpel_N = mkN "carpello" ; -- status=guess
lin carpellary_A = mkA "carpellare" ; -- UWN
lin carpenter_N = mkN "carpentiere" | mkN "falegname" masculine ; -- status=guess status=guess
lin carpentry_N = mkN "carpenteria" ; -- status=guess
lin carpet_N = L.carpet_N ;
lin carpet_V2 = mkV2 (mkV "coprire") ; -- status=guess, src=wikt
lin carrack_N = mkN "caracca" ; -- UWN
lin carrageenin_N = mkN "carragenina" ; -- UWN
lin carriage_N = mkN "vagone" | mkN "carrozza" ; -- status=guess status=guess
lin carriageway_N = mkN "carreggiata" ; -- status=guess
lin carrier_N = mkN "sacco di plastica" ; -- status=guess
lin carrion_N = mkN "carogna" ; -- status=guess
lin carrot_N = mkN "carota" ; -- status=guess
lin carry_V = mkV "portare" ; -- status=guess, src=wikt
lin carry_V2 = mkV2 (mkV "portare") ; -- status=guess, src=wikt
lin carry_forward_V2 = mkV2 (advV OP_carry_V OP_forward_Adv ) ; -- guess-p-verb
lin carry_off_V2 = prepV2 OP_carry_V OP_off_Prep ; -- guess-p-verb
lin carry_on_V = advV OP_carry_V OP_on_Adv ; -- guess-p-verb
lin carry_on_V2 = prepV2 OP_carry_V OP_on_Prep ; -- guess-p-verb
lin carry_on_about_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_about_Prep ; -- guess-p-verb
lin carry_on_with_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin carry_out_V = advV OP_carry_V OP_out_Adv ; -- guess-p-verb
lin carry_out_V2 = prepV2 OP_carry_V OP_out_Prep ; -- guess-p-verb
lin carry_over_V2 = prepV2 OP_carry_V OP_over_Prep ; -- guess-p-verb
lin carry_through_V2 = prepV2 OP_carry_V OP_through_Prep ; -- guess-p-verb
lin carsickness_N = mkN "mal d'auto" ; -- status=guess
lin cart_N = variants {} ; --
lin cartage_N = mkN "carreggio" ; -- UWN
lin cartagena_PN = mkPN ("Cartagena" | "Cartagena de Indias") ; -- status=guess src=geonames
lin cartel_N = mkN "cartello" | mkN "trust" ; -- UWN
lin carter_N = mkN "barocciaio" | mkN "barrocciaio" | mkN "birocciaio" | mkN "carrettaio" | mkN "carrettiere" ; -- UWN
lin cartilage_N = mkN "cartilagine" feminine ; -- status=guess
lin cartload_N = mkN "barocciata" | mkN "baroccio" | mkN "barrocciata" | mkN "barroccio" | mkN "carrata" | mkN "carrettata" | mkN "carro" ; -- UWN
lin cartographer_N = mkN "cartografo" ; -- status=guess
lin cartographic_A = mkA "cartografico" ; -- status=guess
lin cartography_N = mkN "cartografia" ; -- status=guess
lin cartoon_N = mkN "cartone_animato" ; -- UWN
lin cartoonistFem_N = mkN "cartonista" | mkN "cartoonist" | mkN "fumettista" | mkN "pupazzettista" | mkN "vignettista" ; -- UWN
lin cartoonistMasc_N = mkN "cartonista" | mkN "cartoonist" | mkN "fumettista" | mkN "pupazzettista" | mkN "vignettista" ; -- UWN
lin cartridge_N = mkN "cartuccia" ; -- status=guess
lin cartwright_N = mkN "carpentiere" | mkN "carradore" | mkN "carraio" | mkN "carratore" | mkN "carrettaio" ; -- UWN
lin carve_V = mkV "affettare" | mkV "incidere" | mkV "intagliare" | mkV "lavorare" | mkV "scolpire" | mkV "tagliare" | mkV "tranciare" | mkV "trinciare" ; -- UWN
lin carve_V2 = variants {} ; --
lin caryatid_N = mkN "cariatide" feminine ; -- status=guess
lin casablanca_PN = mkPN "Casablanca" ; -- status=guess src=geonames
lin case_N = mkN "cassetta" masculine ; -- status=guess
lin casein_N = mkN "caseina" ; -- status=guess
lin casement_N = mkN "battente" | mkN "anta" | mkN "persiana" ; -- status=guess status=guess status=guess
lin cash_N = mkN "cassa" ; -- status=guess
lin cash_V = mkV "cambiare" ; -- UWN
lin cashable_A = mkA "redimibile" ; -- UWN
lin cashew_N = mkN "anacardio" ; -- status=guess
lin cashier_N = mkN "cassiere" masculine ; -- status=guess
lin cashmere_N = mkN "cachemire" | mkN "cascemir" ; -- UWN
lin casing_N = mkN "infisso" ; -- UWN
lin casino_N = mkN "casinò" masculine ; -- status=guess
lin cask_N = mkN "botte" feminine ; -- status=guess
lin casket_N = mkN "scrigno" | mkN "cofanetto" ; -- status=guess status=guess
lin cassette_N = mkN "cassetta pignoni" | mkN "pacco pignoni" ; -- status=guess status=guess
lin cassock_N = mkN "sottana" ; -- status=guess
lin cassowary_N = mkN "casoario" | mkN "casuario" ; -- UWN
lin cast_N = mkN "cast" masculine ; -- status=guess
lin cast_about_for_V2 = prepV2 (advV OP_cast_V OP_about_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_around_V = advV OP_cast_V OP_around_Adv ; -- guess-p-verb
lin cast_around_for_V2 = prepV2 (advV OP_cast_V OP_around_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_aside_V2 = mkV2 (advV OP_cast_V OP_aside_Adv ) ; -- guess-p-verb
lin cast_off_V = advV OP_cast_V OP_off_Adv ; -- guess-p-verb
lin cast_off_V2 = prepV2 OP_cast_V OP_off_Prep ; -- guess-p-verb
lin cast_out_V2 = prepV2 OP_cast_V OP_out_Prep ; -- guess-p-verb
lin cast_round_for_V2 = prepV2 (advV OP_cast_V OP_round_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_up_V2 = prepV2 OP_cast_V OP_up_Prep ; -- guess-p-verb
lin castaway_N = mkN "naufrago" ; -- status=guess
lin caste_N = mkN "casta" ; -- status=guess
lin caster_N = mkN "rotella" ; -- UWN
lin casting_N = mkN "casting" ; -- UWN
lin castle_N = mkN "castello" ; -- status=guess
lin castle_V = mkV "arroccare" ; -- UWN
lin castleford_PN = mkPN "Castleford" ; -- status=guess src=geonames
lin castor_oil_N = mkN "olio_di_ricino" ; -- UWN
lin castrate_V2 = mkV2 (mkV "castrare") ; -- status=guess, src=wikt
lin castration_N = mkN "castrazione" feminine ; -- status=guess
lin casual_A = variants {} ; --
lin casualness_N = mkN "disinvoltura" | mkN "naturalezza" ; -- UWN
lin casualty_N = mkN "ferito" ; -- status=guess
lin casuist_N = mkN "sofista" ; -- UWN
lin casuistry_N = mkN "casistica" ; -- status=guess
lin casus_belli_N = mkN "casus_belli" ; -- UWN
lin cat_N = L.cat_N ;
lin catabolism_N = mkN "catabolismo" | mkN "disassimilazione" ; -- UWN
lin catachresis_N = mkN "catacresi" ; -- UWN
lin cataclysm_N = mkN "calamità" | mkN "carneficina" | mkN "cataclisma" | mkN "catastrofe" | mkN "disastro" | mkN "dramma" | mkN "massacro" | mkN "sciagura" | mkN "tragedia" ; -- UWN
lin cataclysmic_A = mkA "cataclismo" ; -- status=guess
lin catacomb_N = mkN "catacomba" ; -- status=guess
lin catafalque_N = mkN "catafalco" ; -- status=guess
lin catalanFem_N = variants {} ;
lin catalanMasc_N = variants {} ;
lin catalan_A = mkA "catalano" ;
lin catalectic_A = mkA "catalettico" ; -- UWN
lin catalepsy_N = mkN "catalessi" | mkN "catalessia" ; -- UWN
lin cataleptic_A = mkA "catalettico" ; -- UWN
lin cataloger_N = mkN "cardex" | mkN "catalogatore" | mkN "ordinatore" ; -- UWN
lin catalogue_N = mkN "catalogo" | mkN "cataloghi" masculine ; -- status=guess status=guess
lin catalogue_V2 = mkV2 (mkV (mettere_V) "in catalogo") ; -- status=guess, src=wikt
lin catalysis_N = mkN "catalisi" feminine ; -- status=guess
lin catalyst_N = mkN "catalizzatore" masculine ; -- status=guess
lin catamaran_N = mkN "catamarano" ; -- status=guess
lin catania_PN = mkPN "Catania" ; -- status=guess src=geonames
lin catapult_N = mkN "catapulta" ; -- status=guess
lin cataract_N = mkN "cataratta" ; -- status=guess
lin catarrh_N = mkN "catarro" ; -- status=guess
lin catarrhal_A = mkA "catarrale" | mkA "catarroso" ; -- UWN
lin catastrophe_N = mkN "catastrofe" feminine ; -- status=guess
lin catastrophic_A = mkA "catastrofico" | mkA "rovinoso" ; -- UWN
lin catatonia_N = mkN "catatonia" ; -- status=guess
lin catatonic_A = mkA "catatonico" ; -- status=guess
lin catcall_N = mkN "fischiata" | mkN "fischio" ; -- UWN
lin catch_N = mkN "fermaglio" | mkN "fermaglio di sicurezza" ; -- status=guess status=guess
lin catch_V2 = mkV2 (mkV "agguantare") ; -- status=guess, src=wikt
lin catch_at_V2 = prepV2 (lin V OP_catch_V2) OP_at_Prep ; -- guess-p-verb
lin catch_on_V = mkV "affermarsi" | mkV "attecchire" ; -- UWN
lin catch_out_V2 = prepV2 (lin V OP_catch_V2) OP_out_Prep ; -- guess-p-verb
lin catch_up_V = advV (lin V OP_catch_V2) OP_up_Adv ; -- guess-p-verb
lin catch_up_V2 = prepV2 (lin V OP_catch_V2) OP_up_Prep ; -- guess-p-verb
lin catch_up_in_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_in_Prep ; -- guess-p-verb
lin catch_up_on_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin catch_up_with_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin catcher_N = mkN "collettore" masculine ; -- status=guess
lin catchment_N = mkN "bacino" | mkN "invaso" ; -- status=guess status=guess
lin catchy_A = mkA "accattivante" | mkA "orecchiabile" ; -- status=guess status=guess
lin catechesis_N = mkN "catechesi" | mkN "dottrina" ; -- UWN
lin catechism_N = mkN "catechismo" ; -- status=guess
lin catechist_N = mkN "catechista" ; -- UWN
lin catechistic_A = mkA "catechistico" ; -- UWN
lin catecholamine_N = mkN "catecolamina" ; -- status=guess
lin categoric_A = mkA "categorico" ; -- UWN
lin categorical_A = mkA "categorico" ; -- UWN
lin categorization_N = mkN "categorizzazione" feminine ; -- status=guess
lin categorize_V2 = mkV2 (mkV "categorizzare") ; -- status=guess, src=wikt
lin category_N = mkN "categoria" ; -- status=guess
lin catenary_N = mkN "catenaria" ; -- status=guess
lin cater_V = variants {} ; --
lin caterpillar_N = mkN "bruco" ; -- status=guess
lin caterwaul_V = mkV "miagolare" ; -- status=guess, src=wikt
lin catfish_N = mkN "pesce gatto" ; -- status=guess
lin catgut_N = mkN "budello" ; -- UWN
lin cathedral_N = mkN "cattedrale" | mkN "duomo" ; -- status=guess status=guess
lin catheter_N = mkN "catetere" masculine ; -- status=guess
lin cathode_N = mkN "catodo" ; -- status=guess
lin cathodic_A = mkA "catodico" ; -- status=guess
lin catholicFem_N = variants {} ; ---- sense to be split
lin catholicMasc_N = variants {} ; ---- sense to be split
lin catholicity_N = mkN "cattolicità" feminine ; -- status=guess
lin cation_N = mkN "catione" masculine ; -- status=guess
lin catkin_N = mkN "gattino" | mkN "amento" ; -- status=guess status=guess
lin catoptric_A = mkA "catoptrico" | mkA "catottrico" ; -- UWN
lin catoptrics_N = mkN "catoptrica" | mkN "catottrica" ; -- UWN
lin catsup_N = mkN "ketchup" ; -- UWN
lin cattle_N = mkN "bestiame" masculine ; -- status=guess
lin cattleman_N = mkN "offerta dei bestiami" ; -- status=guess
lin catty_A = mkA "malizioso" ; -- status=guess
lin catwalk_N = mkN "passerella" ; -- status=guess
lin caucasianFem_N = variants {} ; ---- sense to be split
lin caucasianMasc_N = variants {} ; ---- sense to be split
lin caudal_A = mkA "caudale" ; -- status=guess
lin cauldron_N = mkN "calderone" masculine ; -- status=guess
lin cauliflower_N = mkN "cavolfiore" masculine ; -- status=guess
lin causal_A = mkA "causale" ; -- UWN
lin causality_N = mkN "causalità" feminine ; -- status=guess
lin cause_N = mkN "causa" ; -- status=guess
lin cause_V2 = mkV2 (mkV "provocare") ; -- status=guess, src=wikt
lin cause_V2V = mkV2V (mkV "provocare") ; -- status=guess, src=wikt
lin causeway_N = mkN "sopraelevata" ; -- UWN
lin caustic_A = mkA "caustico" ; -- status=guess
lin caustic_N = mkN "caustica" ; -- status=guess
lin cautery_N = mkN "cauterizzazione" ; -- UWN
lin caution_N = mkN "cautela" ; -- status=guess
lin caution_V = mkV "ammonire" ; -- UWN
lin caution_VS = mkvVS "ammonire" ; -- UWN
lin cautious_A = mkA "cauto" | mkA "ritenuto" | mkA "oculato" ; -- status=guess status=guess status=guess
lin cavalryman_N = mkN "cavaliere" masculine ; -- status=guess
lin cavan_PN = mkPN "Cavan" ; -- status=guess src=geonames
lin cave_N = mkN "caverna" | mkN "grotta" ; -- status=guess status=guess
lin cave_in_V = mkV "cadere" | mkV "cedere" | mkV "crollare" | mkV "franare" | mkV "rompersi" | mkV "sfondarsi" | mkV "sprofondare" ; -- UWN
lin caveat_N = mkN "avviso" ; -- status=guess
lin caveman_N = mkN "cavernicolo" ; -- status=guess
lin caviar_N = mkN "caviale" masculine ; -- status=guess
lin cavity_N = mkN "cavità" feminine ; -- status=guess
lin cavy_N = mkN "cavia" ; -- UWN
lin caw_N = mkN "gracchio" ; -- status=guess
lin caw_V = mkV "gracchiare" ; -- status=guess, src=wikt
lin caw_V2 = mkV2 (mkV "gracchiare") ; -- status=guess, src=wikt
lin cayman_N = mkN "caimano" ; -- UWN
lin cc_N = mkN "cc" | mkN "centimetro_cubo" | mkN "mL" | mkN "millilitro" | mkN "ml" ; -- UWN
lin ceaseless_A = mkA "incessante" ; -- status=guess
lin cecal_A = mkA "cecale" | mkA "ciecale" ; -- UWN
lin cecilia_PN = mkPN "Cecilia" ; -- status=guess src=geonames
lin cecum_N = mkN "ceco" | mkN "cieco" | mkN "intestino_cieco" ; -- UWN
lin cedar_N = mkN "cedro" ; -- status=guess
lin cedi_N = mkN "cedi" | mkN "cedi_ghaniano" ; -- UWN
lin cedilla_N = mkN "cediglia" ; -- status=guess
lin cefotaxime_N = mkN "cefotaxima" ; -- status=guess
lin ceiling_N = L.ceiling_N ;
lin celebrant_N = mkN "celebrante" | mkN "officiante" | mkN "ufficiante" ; -- UWN
lin celebrate_V2 = mkV2 (mkV "celebrare") ; -- status=guess, src=wikt
lin celebrated_A = mkA "celebrato" ; -- status=guess
lin celebration_N = mkN "celebrazione" feminine | mkN "ricorrenza" ; -- status=guess status=guess
lin celebratory_A = mkA "celebrativo" ; -- UWN
lin celeriac_N = mkN "sedano rapa" ; -- status=guess
lin celerity_N = mkN "celerità" | mkN "fulmineità" | mkN "prestezza" | mkN "rapidezza" | mkN "rapidità" | mkN "rattezza" | mkN "speditezza" | mkN "subitaneità" | mkN "subitezza" ; -- UWN
lin celery_N = mkN "sedano" ; -- status=guess
lin celesta_N = mkN "celesta" | mkN "celeste" ; -- UWN
lin celestial_A = mkA "celeste" ; -- status=guess
lin celiac_A = mkA "celiaco" ; -- UWN
lin celibate_A = mkA "celibe" ; -- status=guess
lin cell_N = mkN "cellula" ; -- status=guess
lin cellar_N = variants {} ; --
lin cellistFem_N = mkN "violoncellista" ; -- UWN
lin cellistMasc_N = mkN "violoncellista" ; -- UWN
lin cello_N = mkN "violoncello" ; -- status=guess
lin cellophane_N = mkN "cellofan" | mkN "cellophane" ; -- UWN
lin cellular_A = mkA "cellulare" ; -- status=guess
lin cellulite_N = mkN "cellulite" ; -- status=guess
lin cellulitis_N = mkN "cellulite" ; -- UWN
lin celluloid_N = mkN "celluloide" feminine ; -- status=guess
lin cellulose_N = mkN "cellulosa" ; -- status=guess
lin celom_N = mkN "celoma" ; -- UWN
lin cement_N = mkN "cemento" ; -- status=guess
lin cement_V2 = mkV2 (mkV "cementare") ; -- status=guess, src=wikt
lin cementite_N = mkN "cementite" ; -- UWN
lin cementum_N = mkN "cemento" ; -- UWN
lin cemetery_N = variants {} ; --
lin cenobite_N = mkN "cenobita" masculine ; -- status=guess
lin cenobitic_A = mkA "cenobitico" ; -- UWN
lin cenotaph_N = mkN "cenotafio" ; -- status=guess
lin censer_N = mkN "turibolo" | mkN "incensiere" ; -- status=guess status=guess
lin censor_N = mkN "censore" masculine ; -- status=guess
lin censor_V2 = mkV2 (mkV "censurare") ; -- status=guess, src=wikt
lin censorial_A = mkA "censoriale" ; -- status=guess
lin census_N = mkN "censo" | mkN "censimento" ; -- status=guess status=guess
lin cent_N = mkN "centesimo" ; -- status=guess
lin centenarian_N = mkN "centenario" ; -- UWN
lin centenary_A = mkA "centenario" | mkA "centennale" | mkA "centenne" ; -- UWN
lin centenary_N = mkN "centenario" ; -- UWN
lin centennial_A = mkA "centenario" | mkA "centennale" | mkA "centenne" ; -- UWN
lin centennial_N = mkN "centenario" ; -- UWN
lin centerboard_N = mkN "deriva" ; -- UWN
lin centering_N = mkN "centina" ; -- status=guess
lin centesimal_A = mkA "centesimale" ; -- status=guess
lin centesimo_N = mkN "centesimo" ; -- UWN
lin centiliter_N = mkN "centilitro" | mkN "cl" ; -- UWN
lin centime_N = mkN "centesimo" | mkN "quattrino" ; -- UWN
lin centimetre_N = mkN "centimetro" ; -- status=guess
lin centipede_N = mkN "centopiedi" masculine ; -- status=guess
lin central_A = mkA "centrale" ; -- status=guess
lin central_N = mkN "sistema nervoso centrale" ; -- status=guess
lin centralist_A = mkA "centralistico" ; -- status=guess
lin centrality_N = mkN "centralità" ; -- UWN
lin centralize_V = mkV "accentrare" | mkV "centralizzare" ; -- UWN
lin centre_N = mkN "centro" ;
lin centre_V = variants {} ; --
lin centre_V2 = variants {} ; --
lin centrifugation_N = mkN "centrifugazione" feminine ; -- status=guess
lin centriole_N = mkN "centriolo" ; -- status=guess
lin centrism_N = mkN "moderatismo" ; -- UWN
lin centrist_N = mkN "centrista" | mkN "moderato" ; -- UWN
lin centrosome_N = mkN "centrosoma" ; -- UWN
lin centurion_N = mkN "centurione" masculine ; -- status=guess
lin century_N = mkN "centuria" ; -- status=guess
lin cephalic_A = mkA "cefalico" ; -- status=guess
lin ceramic_A = mkA "ceramico" ; -- status=guess
lin ceramic_N = mkN "ceramica" ; -- status=guess
lin ceratosaur_N = mkN "ceratosauro" ; -- status=guess
lin cereal_A = mkA "cereale" ; -- UWN
lin cereal_N = variants {} ; --
lin cerebellum_N = mkN "cervelletto" ; -- status=guess
lin cerebral_A = mkA "cerebrale" ; -- status=guess
lin cerebration_N = mkN "pensiero" ; -- UWN
lin cerebrospinal_A = mkA "cerebrospinale" ; -- status=guess
lin cerebrovascular_A = mkA "cerebrovascolare" ; -- status=guess
lin ceremonial_N = mkN "cerimoniale" masculine ; -- status=guess
lin ceremoniousness_N = mkN "cerimoniosità" ; -- UWN
lin ceremony_N = mkN "cerimonia" ; -- status=guess
lin ceric_A = mkA "cerico" ; -- status=guess
lin cerise_A = mkA "ciliegia" ; -- status=guess
lin cerise_N = mkN "ciliegia" ; -- status=guess
lin cerium_N = mkN "cerio" ; -- status=guess
lin certain_1_A = variants {} ; --
lin certain_2_A = mkA "alcuni" | mkA "certo" | mkA "determinato" ; -- UWN
lin certain_A = mkA "certo" ; -- status=guess
lin certainty_N = mkN "certezza" | mkN "sicurezza" ; -- UWN
lin certifiable_A = mkA "attestabile" | mkA "certificabile" | mkA "constatabile" ; -- status=guess status=guess status=guess
lin certificate_N = mkN "attestato" | mkN "attestazione" | mkN "certificato" ; -- UWN
lin certify_V = mkV "dimostrare" | mkV "mostrare" ; -- UWN
lin certitude_N = mkN "certezza" ; -- UWN
lin cerulean_A = mkA "ceruleo" ; -- status=guess
lin cerumen_N = mkN "cerume" ; -- UWN
lin ceruminous_A = mkA "ceruminoso" ; -- UWN
lin cerussite_N = mkN "cerussite" feminine ; -- status=guess
lin cervical_A = mkA "cervicale" ; -- status=guess
lin cervix_N = mkN "cervice" | mkN "collo dell'utero" ; -- status=guess status=guess
lin cessation_N = mkN "cessazione" ; -- UWN
lin cession_N = mkN "cessione" ; -- UWN
lin cesspit_N = mkN "bottino" | mkN "cloaca" | mkN "pozzo_nero" ; -- UWN
lin cesspool_N = mkN "bottino" | mkN "cloaca" | mkN "pozzo_nero" ; -- UWN
lin cetacean_N = mkN "cetaceo" ; -- status=guess
lin chad_PN = mkPN "Ciad" ; -- status=guess src=geonames
lin chafe_N = mkN "esasperazione" | mkN "irritazione" ; -- UWN
lin chagrin_N = mkN "dispiacere" | mkN "delusione" feminine | mkN "mortificazione" feminine ; -- status=guess status=guess status=guess
lin chagrin_V2 = mkV2 (mkV "deludere") | mkV2 (mkV "mortificare") ; -- status=guess, src=wikt status=guess, src=wikt
lin chain_N = mkN "cotta di maglia" ; -- status=guess
lin chain_V2 = mkV2 (mkV "concatenare") ; -- status=guess, src=wikt
lin chair_N = L.chair_N ;
lin chair_V2 = variants {} ; --
lin chair_lift_N = mkN "seggiovia" ; -- UWN
lin chairman_N = mkN "presidente" masculine ; -- status=guess
lin chairmanship_N = mkN "presidenza" ; -- status=guess
lin chaise_N = mkN "chaise longue" ; -- status=guess
lin chalcedony_N = mkN "calcedonio" feminine ; -- status=guess
lin chalcocite_N = mkN "calcocite" ; -- UWN
lin chalcopyrite_N = mkN "calcopirite" ; -- UWN
lin chalet_N = mkN "chalet" masculine ; -- status=guess
lin chalfont_PN = mkPN "Chalfont" ; -- status=guess src=geonames
lin chalice_N = mkN "calice" masculine ; -- status=guess
lin chalk_N = mkN "gessetto" ; -- status=guess
lin chalkpit_N = mkN "cava_di_gesso" | mkN "gessaia" ; -- UWN
lin challenge_N = mkN "sfida" ; -- status=guess
lin challenge_V = variants {} ; --
lin challenge_V2 = variants {} ; --
lin challenger_N = mkN "agonista" | mkN "antagonista" | mkN "competitore" | mkN "emulo" | mkN "rivale" ; -- UWN
lin chamber_N = mkN "camera" | mkN "camera da letto" ; -- status=guess status=guess
lin chamberlain_N = mkN "ciambellano" ; -- status=guess
lin chambermaid_N = mkN "cameriera" ; -- status=guess
lin chamberpot_N = mkN "orinale" | mkN "pitale" | mkN "urinale" | mkN "vaso_da_notte" ; -- UWN
lin chameleon_N = mkN "camaleonte" masculine ; -- status=guess
lin chamois_N = mkN "camoscio" ; -- status=guess
lin champ_N = mkN "campione" | mkN "campionessa" ; -- UWN
lin champagne_N = variants {} ; --
lin champion_N = mkN "campione" masculine | mkN "campionessa" ; -- status=guess status=guess
lin championship_N = mkN "campionato" ; -- status=guess
lin chance_N = mkN "possibilità" feminine | mkN "opportunità" feminine | mkN "chance" feminine ; -- status=guess status=guess status=guess
lin chancel_N = mkN "abside" ; -- UWN
lin chancellery_N = mkN "cancellierato" ; -- UWN
lin chancellor_N = mkN "cancelliere" ; -- status=guess
lin chancellorship_N = mkN "cancellierato" ; -- status=guess
lin chandelier_N = mkN "candelabro" ; -- status=guess
lin changchun_PN = mkPN "Changchun" ; -- status=guess src=geonames
lin change_N = mkN "cambio" ; -- status=guess
lin change_V = mkV "cambiare" ; -- status=guess, src=wikt
lin change_V2 = mkV2 (mkV "cambiare") ; -- status=guess, src=wikt
lin change_over_V2 = prepV2 OP_change_V OP_over_Prep ; -- guess-p-verb
lin changeable_A = mkA "mutevole" ; -- status=guess
lin changeableness_N = mkN "mutevolezza" | mkN "mutabilità" | mkN "instabilità" feminine ; -- status=guess status=guess status=guess
lin changeful_A = mkA "variabile" ; -- UWN
lin changelessness_N = mkN "definitività" | mkN "immutabilità" | mkN "impermutabilità" | mkN "inalterabilità" | mkN "inderogabilità" ; -- UWN
lin changeover_N = mkN "conversione" | mkN "transizione" ; -- UWN
lin changer_N = mkN "cambiadischi" ; -- UWN
lin changing_A = variants {} ; --
lin changsha_PN = mkPN "Changsha" ; -- status=guess src=geonames
lin channel_N = mkN "canale" masculine ; -- status=guess
lin channel_V2 = mkV2 (mkV "imitare") ; -- status=guess, src=wikt
lin channelization_N = mkN "canalizzazione" ; -- UWN
lin chant_N = mkN "canto" ; -- UWN
lin chant_V = mkV "salmodiare" ; -- status=guess, src=wikt
lin chant_V2 = mkV2 (mkV "salmodiare") ; -- status=guess, src=wikt
lin chanter_N = mkN "canna della melodia" ; -- status=guess
lin chaos_N = mkN "caos" masculine ; -- status=guess
lin chaotic_A = mkA "caotico" ; -- status=guess
lin chap_N = mkN "tipo" | mkN "tizio" ; -- status=guess status=guess
lin chap_V = mkV "screpolarsi" ; -- UWN
lin chapel_N = mkN "cappella" | mkN "chiesetta" ; -- status=guess status=guess
lin chaplain_N = mkN "cappellano" ; -- status=guess
lin chaplaincy_N = mkN "cappellanato" ; -- UWN
lin chapter_N = mkN "capitolo" ; -- status=guess
lin charabanc_N = variants {} ;
lin character_1_N = mkN "carattere" ; -- UWN
lin character_2_N = variants {} ; --
lin characteristic_A = mkA "caratteristica" ; -- status=guess
lin characteristic_N = mkN "caratteristica" masculine ; -- status=guess
lin characterization_N = mkN "caratterizzazione" feminine ; -- status=guess
lin characterize_V2 = variants {} ; --
lin charades_N = mkN "sciarada" ; -- UWN
lin charcoal_A = mkA "antracite" ; -- status=guess
lin charcoal_N = mkN "carbone" feminine | mkN "carbonella" ; -- status=guess status=guess
lin chard_N = mkN "bietola" | mkN "bieta" ; -- status=guess status=guess
lin chard_PN = mkPN "Chard" ; -- status=guess src=geonames
lin charge_1_N = mkN "carica" ; -- UWN
lin charge_2_N = mkN "accusa" | mkN "addebito" ; -- UWN
lin charge_N = mkN "accusa" | mkN "imputazione" feminine ; -- status=guess status=guess
lin charge_V = mkV "caricare" ; -- status=guess, src=wikt
lin charge_V2 = mkV2 (mkV "caricare") ; -- status=guess, src=wikt
lin charge_off_V = advV OP_charge_V OP_off_Adv ; -- guess-p-verb
lin charge_up_V2 = prepV2 OP_charge_V OP_up_Prep ; -- guess-p-verb
lin charge_with_V3 = variants {} ; -- guess-p-verb
lin charger_N = mkN "caricabatterie" masculine ; -- status=guess
lin chariot_N = mkN "cocchio" | mkN "carrozza" ; -- status=guess status=guess
lin charisma_N = mkN "carisma" ; -- UWN
lin charity_N = mkN "carità" feminine ; -- status=guess
lin charlatan_N = mkN "ciarlatano" ; -- status=guess
lin charlatanism_N = mkN "ciarlataneria" | mkN "ciarlatanismo" | mkN "millanteria" ; -- UWN
lin charlotte_N = mkN "charlotte" ; -- UWN
lin charlotte_PN = mkPN "Charlotte" ; -- status=guess src=geonames
lin charm_N = mkN "incanto" | mkN "fascino" | mkN "attrattiva" ; -- status=guess status=guess status=guess
lin charmer_N = mkN "allettatore" | mkN "ammaliatore" | mkN "incantatore" | mkN "maliardo" ; -- UWN
lin charming_A = variants {} ; --
lin charnel_house_N = mkN "carnaio" | mkN "ossario" ; -- UWN
lin chart_N = mkN "carta" | mkN "carta nautica" | mkN "carta geografica" ; -- status=guess status=guess status=guess
lin charter_N = mkN "carta" ; -- status=guess
lin charwoman_N = mkN "donna_a_ore" | mkN "donna_delle_pulizie" ; -- UWN
lin chase_N = mkN "caccia" masculine | mkN "cacciare" ; -- status=guess status=guess
lin chase_V = mkV "inseguire" | mkV "cacciare" ; -- status=guess, src=wikt status=guess, src=wikt
lin chase_V2 = mkV2 (mkV "inseguire") | mkV2 (mkV "cacciare") ; -- status=guess, src=wikt status=guess, src=wikt
lin chaser_N = mkN "inseguitore" | mkN "cacciatore" masculine ; -- status=guess status=guess
lin chassis_N = mkN "châssis" masculine ; -- status=guess
lin chaste_A = mkA "casto" | mkA "casta" ; -- status=guess status=guess
lin chastity_N = mkN "castità" feminine ; -- status=guess
lin chasuble_N = mkN "casula" | mkN "pianeta" ; -- UWN
lin chat_N = mkN "chiacchiera" ; -- status=guess
lin chat_V = variants {} ; --
lin chatham_PN = mkPN "Chatham" ; -- status=guess src=geonames
lin chatter_N = mkN "chiacchiericcio" | mkN "chiacchierio" | mkN "cicalamento" | mkN "cicaleccio" | mkN "cicalio" | mkN "favellio" | mkN "parlottio" ; -- UWN
lin chatterbox_N = mkN "chiacchierone" masculine ; -- status=guess
lin chauvinism_N = mkN "sciovinismo" ; -- status=guess
lin chaw_N = mkN "cicca" ; -- UWN
lin cheadle_PN = mkPN "Cheadle" ; -- status=guess src=geonames
lin cheap_A = mkA "economico" ; -- status=guess
lin cheapness_N = mkN "dozzinalità" ; -- UWN
lin cheapskate_N = mkN "tirchio" | mkN "avaro" | mkN "avaro" ; -- status=guess status=guess status=guess
lin cheat_N = mkN "bigliettino" ; -- status=guess
lin cheat_V = mkV "fregare" ; -- status=guess, src=wikt
lin cheat_V2 = mkV2 (mkV "fregare") ; -- status=guess, src=wikt
lin check_N = mkN "conto" ; -- status=guess
lin check_V = mkV "controllare" ; -- status=guess, src=wikt
lin check_V2 = mkV2 (mkV "controllare") ; -- status=guess, src=wikt
lin check_back_V = advV OP_check_V OP_back_Adv ; -- guess-p-verb
lin check_by_V2 = prepV2 OP_check_V OP_by_Prep ; -- guess-p-verb
lin check_for_V2 = prepV2 OP_check_V OP_for_Prep ; -- guess-p-verb
lin check_in_V = advV OP_check_V OP_in_Adv ; -- guess-p-verb
lin check_in_V2 = prepV2 OP_check_V OP_in_Prep ; -- guess-p-verb
lin check_into_V2 = prepV2 OP_check_V OP_into_Prep ; -- guess-p-verb
lin check_off_V2 = prepV2 OP_check_V OP_off_Prep ; -- guess-p-verb
lin check_on_V2 = prepV2 OP_check_V OP_on_Prep ; -- guess-p-verb
lin check_out_V = advV OP_check_V OP_out_Adv ; -- guess-p-verb
lin check_out_V2 = prepV2 OP_check_V OP_out_Prep ; -- guess-p-verb
lin check_out_of_V2 = prepV2 (advV OP_check_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin check_over_V2 = prepV2 OP_check_V OP_over_Prep ; -- guess-p-verb
lin check_through_V2 = prepV2 OP_check_V OP_through_Prep ; -- guess-p-verb
lin check_up_on_V2 = prepV2 (advV OP_check_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin check_with_V2 = prepV2 OP_check_V OP_with_Prep ; -- guess-p-verb
lin checkbook_N = mkN "libretto_degli_assegni" | mkN "libretto_di_assegni" ; -- UWN
lin checkerboard_N = mkN "damiera" | mkN "damiere" | mkN "scacchiera" ; -- UWN
lin checkmate_N = mkN "scacco matto" ; -- status=guess
lin checkout_N = mkN "controllo" | mkN "verifica" ; -- UWN
lin checkroom_N = mkN "bagagliaio" | mkN "deposito" | mkN "deposito_bagagli" ; -- UWN
lin checkup_N = mkN "controllo" | mkN "visita_medica" ; -- UWN
lin cheek_N = mkN "chiappa" ; -- status=guess
lin cheekbone_N = mkN "zigoma" | mkN "zigomo" ; -- UWN
lin cheekpiece_N = mkN "guardia" ; -- UWN
lin cheeky_A = mkA "impertinente" | mkA "sfacciato" | mkA "sfrontato" | mkA "impudente" ; -- status=guess status=guess status=guess status=guess
lin cheer_V = variants {} ; --
lin cheer_V2 = variants {} ; --
lin cheer_up_V = mkV "consolarsi" | mkV "rallegrarsi" | mkV "rasserenarsi" | mkV "rincuorarsi" ; -- UWN
lin cheerful_A = mkA "allegro" ; -- status=guess
lin cheers_Interj = mkInterj "cincin" ;
lin cheery_A = mkA "vivace" ; -- UWN
lin cheese_N = L.cheese_N ;
lin cheeseburger_N = mkN "cheeseburger" masculine ; -- status=guess
lin cheesecake_N = mkN "cheesecake" | mkN "torta al formaggio" ; -- status=guess status=guess
lin cheetah_N = mkN "ghepardo" ; -- status=guess
lin chef_N = mkN "capocuoco" ; -- status=guess
lin chela_N = mkN "chela" | mkN "tenaglie" ; -- UWN
lin chelation_N = mkN "chelazione" feminine ; -- status=guess
lin chelicera_N = mkN "chelicero" ; -- status=guess
lin chelmsford_PN = mkPN "Chelmsford" ; -- status=guess src=geonames
lin chelsea_PN = mkPN "Chelsea" ; -- status=guess src=geonames
lin cheltenham_PN = mkPN "Cheltenham" ; -- status=guess src=geonames
lin chelyabinsk_PN = mkPN "Čeljabinsk" ; -- status=guess src=geonames
lin chemical_A = variants {} ; --
lin chemical_N = mkN "composto chimico" ; -- status=guess
lin chemiluminescence_N = mkN "chemiluminescenza" ; -- UWN
lin chemistFem_N = variants {} ; ---- sense to be split
lin chemistMasc_N = variants {} ; --
lin chemistry_N = mkN "chimica" ; -- status=guess
lin chemosynthesis_N = mkN "chemiosintesi" ; -- UWN
lin chemotaxis_N = mkN "chemiotassi" | mkN "chemiotattismo" ; -- UWN
lin chemotherapeutic_A = mkA "chemioterapico" ; -- UWN
lin chemotherapy_N = mkN "chemioterapia" ; -- UWN
lin chenille_N = mkN "ciniglia" ; -- UWN
lin chepstow_PN = mkPN "Chepstow" ; -- status=guess src=geonames
lin cheque_N = mkN "assegno" ; -- status=guess
lin chequebook_N = mkN "libretto_degli_assegni" | mkN "libretto_di_assegni" ; -- UWN
lin cheroot_N = mkN "sigaro_spuntato" ; -- UWN
lin cherry_N = mkN "cerasella" ; -- status=guess
lin chert_N = mkN "ftanite" feminine ; -- status=guess
lin cherub_N = mkN "cherubino" ; -- status=guess
lin chervil_N = mkN "cerfoglio" ; -- status=guess
lin chesham_PN = mkPN "Chesham" ; -- status=guess src=geonames
lin cheshire_PN = mkPN "Cheshire" ; -- status=guess src=geonames
lin chess_N = mkN "scacchi" masculine ; -- status=guess
lin chessboard_N = mkN "scacchiera" ; -- status=guess
lin chessman_N = mkN "scacco" ; -- UWN
lin chest_N = mkN "cassettone" masculine | mkN "comò" ; -- status=guess status=guess
lin chester_PN = mkPN "Chester" ; -- status=guess src=geonames
lin chesterfield_PN = mkPN "Chesterfield" ; -- status=guess src=geonames
lin chestnut_A = mkA "castano" ;
lin chestnut_N = mkN "averla formichiera lineata" ; -- status=guess
lin chetrum_N = mkN "chetrum" | mkN "chetrum_butanese" ; -- UWN
lin chew_N = mkN "masticazione" ; -- UWN
lin chew_V = mkV "masticare" ; -- status=guess, src=wikt
lin chew_V2 = mkV2 (mkV "masticare") ; -- status=guess, src=wikt
lin chiaroscuro_N = mkN "chiaroscuro" ; -- status=guess
lin chiasma_N = mkN "chiasma" ; -- UWN
lin chiasmus_N = mkN "chiasma" | mkN "chiasmo" ; -- UWN
lin chic_N = mkN "attillatura" | mkN "eleganza" | mkN "raffinatezza" | mkN "ricercatezza" ; -- UWN
lin chicago_PN = mkPN "Chicago" ; -- status=guess src=geonames
lin chichester_PN = mkPN "Chichester" ; -- status=guess src=geonames
lin chichi_N = mkN "attillatura" | mkN "eleganza" | mkN "raffinatezza" | mkN "ricercatezza" ; -- UWN
lin chick_N = mkN "pulcino" ; -- status=guess
lin chicken_N = mkN "pollo" | mkN "gallo" | mkN "gallina" ;
lin chickenfeed_N = mkN "moneta" ; -- UWN
lin chickenpox_N = mkN "varicella" ; -- status=guess
lin chickpea_N = mkN "cece" masculine ; -- status=guess
lin chickweed_N = mkN "centocchio" ; -- status=guess
lin chicory_N = mkN "cicoria" ; -- status=guess
lin chiding_N = mkN "partaccia" | mkN "rabbuffo" | mkN "rimprovero" | mkN "strillata" | mkN "urlata" ; -- UWN
lin chief_A = variants {} ; --
lin chief_N = mkN "amministratore delegato" ; -- status=guess
lin chieftainFem_N = variants {} ; ---- sense to be split
lin chieftainMasc_N = variants {} ; ---- sense to be split
lin chiffonier_N = mkN "canterale" | mkN "canterano" | mkN "comò" | mkN "sciffoniera" ; -- UWN
lin chignon_N = mkN "crocchia" ; -- status=guess
lin chilblain_N = mkN "gelone" ; -- UWN
lin child_N = L.child_N ;
lin childhood_N = mkN "infanzia" ; -- status=guess
lin childish_A = mkA "infantile" ; -- status=guess
lin childishness_N = mkN "infantilismo" | mkN "infantilità" | mkN "puerilità" ; -- UWN
lin chile_PN = mkPN "Cile" ; -- status=guess src=geonames
lin chileanFem_N = variants {} ; ---- sense to be split
lin chileanMasc_N = variants {} ; ---- sense to be split
lin chili_N = mkN "peperoncino" ; -- status=guess
lin chill_N = mkN "frescura" | mkN "fresco" | mkN "freddezza" | mkN "raffreddamento" | mkN "gelo" ; -- status=guess status=guess status=guess status=guess status=guess
lin chill_V = mkV "raffreddarsi" ; -- status=guess, src=wikt
lin chill_V2 = mkV2 (mkV "raffreddarsi") ; -- status=guess, src=wikt
lin chill_out_V = mkV "acquietarsi" | mkV "ammansirsi" | mkV "calmarsi" | mkV "pacarsi" | mkV "placarsi" | mkV "rabbonirsi" | mkV "tranquillizzarsi" ; -- UWN
lin chilliness_N = mkN "freddezza" | mkN "frigidità" ; -- UWN
lin chime_N = mkN "soneria" | mkN "suoneria" ; -- UWN
lin chime_in_V = mkV "intromettersi" ; -- UWN
lin chimera_N = mkN "chimera" ; -- status=guess
lin chimeric_A = mkA "chimerico" ; -- UWN
lin chimerical_A = mkA "chimerico" ; -- status=guess
lin chimney_N = mkN "fumaiolo" ; -- status=guess
lin chimneypot_N = mkN "fumaiolo" ; -- UWN
lin chimneystack_N = mkN "ciminiera" | mkN "comignolo" ; -- UWN
lin chimney_sweep_N = mkN "spazzacamino" ; -- UWN
lin chimneysweeper_N = mkN "spazzacamino" ; -- UWN
lin chimpanzee_N = mkN "scimpanzé" masculine ; -- status=guess
lin chin_N = mkN "mento" ; -- status=guess
lin china_N = mkN "porcellana" ; -- status=guess
lin china_PN = mkPN "Cina" ; -- status=guess src=geonames
lin chinchilla_N = mkN "cincillà" masculine ; -- status=guess
lin chineseFem_N = mkN "cinese" feminine ;
lin chineseMasc_N = mkN "cinese" ;
lin chinese_A = mkA "cinese" ;
lin chinoiserie_N = mkN "cineseria" ; -- status=guess
lin chintz_N = mkN "chintz" ; -- UWN
lin chip_N = mkN "chip" ; -- status=guess
lin chipboard_N = mkN "truciolare" | mkN "truciolato" ; -- UWN
lin chipmunk_N = mkN "tamia" ; -- UWN
lin chippenham_PN = mkPN "Chippenham" ; -- status=guess src=geonames
lin chipper_A = mkA "disinvolto" ; -- UWN
lin chiropodist_N = mkN "callista" | mkN "pedicure" ; -- UWN
lin chiropractic_N = mkN "chiroprassi" | mkN "chiropratica" | mkN "chiroterapia" ; -- UWN
lin chiropractor_N = mkN "chiropratico" ; -- status=guess
lin chirp_N = mkN "cinguettio" | mkN "trillo" ; -- status=guess status=guess
lin chisel_N = mkN "scalpello" | mkN "cesello" ; -- status=guess status=guess
lin chisel_V2 = mkV2 (mkV "cesellare") ; -- status=guess, src=wikt
lin chiseller_N = mkN "abbindolatore" | mkN "aggiratore" | mkN "arcadore" | mkN "arcatore" | mkN "baro" | mkN "bidonista" | mkN "blackleg" | mkN "cagliostro" | mkN "camorrista" | mkN "frodatore" | mkN "gabbacompagno" | mkN "gabbacristiani" | mkN "gabbamondo" | mkN "gabbatore" | mkN "giuntatore" | mkN "imbroglione" | mkN "impostore" | mkN "lestofante" | mkN "magliaro" | mkN "mistificatore" | mkN "pataccaro" | mkN "pelagatti" | mkN "pellaccia" | mkN "raggiratore" | mkN "truccone" | mkN "truffaldino" | mkN "truffatore" | mkN "turlupinatore" ; -- UWN
lin chit_N = mkN "conto" ; -- UWN
lin chitin_N = mkN "chitina" ; -- status=guess
lin chiton_N = mkN "chitone" masculine ; -- status=guess
lin chitterlings_N = mkN "frattaglie" feminine ; -- status=guess
lin chivalry_N = mkN "cavalleria" | mkN "galanteria" ; -- UWN
lin chive_N = mkN "erba cipollina" | mkN "cipolletta" ; -- status=guess status=guess
lin chives_N = mkN "erba_cipollina" ; -- UWN
lin chlamydia_N = mkN "chlamydia" ; -- status=guess
lin chlamys_N = mkN "clamide" feminine ; -- status=guess
lin chloramine_N = mkN "clorammina" ; -- status=guess
lin chlorate_N = mkN "clorato" ; -- status=guess
lin chloride_N = mkN "cloruro" ; -- status=guess
lin chlorinate_V2 = mkV2 (mkV "clorurare") ; -- status=guess, src=wikt
lin chlorination_N = mkN "clorazione" feminine ; -- status=guess
lin chlorine_N = mkN "cloro" ; -- status=guess
lin chlorite_N = mkN "clorite" feminine ; -- status=guess
lin chlorofluorocarbon_N = mkN "clorofluorocarburo" ; -- status=guess
lin chloroform_N = mkN "cloroformio" ; -- status=guess
lin chlorophyll_N = mkN "clorofilla" ; -- status=guess
lin chloroplast_N = mkN "cloroplasto" ; -- status=guess
lin chlorosis_N = mkN "clorosi" feminine ; -- status=guess
lin chock_N = mkN "calzatoia" | mkN "calzolo" | mkN "calzuolo" | mkN "cuneo" | mkN "tacco" ; -- UWN
lin chocolate_N = mkN "cioccolato" | mkN "cioccolata" ; -- status=guess status=guess
lin choice_A = mkA "di prima scelta" ; -- status=guess
lin choice_N = mkN "ottimo" | mkN "ottima" ; -- status=guess status=guess
lin choir_N = mkN "coro" ; -- status=guess
lin choirboy_N = mkN "corista" ; -- UWN
lin choirmaster_N = mkN "maestro_del_coro" ; -- UWN
lin choke_V = mkV "soffocare" ; -- status=guess, src=wikt
lin choke_V2 = mkV2 (mkV "soffocare") ; -- status=guess, src=wikt
lin choking_N = mkN "strangolamento" | mkN "strozzamento" ; -- UWN
lin cholecystectomy_N = mkN "colecistectomia" ; -- UWN
lin cholecystokinin_N = mkN "colecistochinina" ; -- status=guess
lin cholera_N = mkN "colera" ; -- status=guess
lin cholesterol_N = mkN "colesterolo" ; -- status=guess
lin choline_N = mkN "colina" ; -- status=guess
lin cholinergic_A = mkA "colinergico" ; -- UWN
lin chondrite_N = mkN "condrite" ; -- UWN
lin chondritic_A = mkA "granelloso" | mkA "granulare" | mkA "granuloso" ; -- UWN
lin chondroma_N = mkN "condroma" masculine ; -- status=guess
lin choose_V2 = mkV2 (mkV "decidere") ; -- status=guess, src=wikt
lin choose_VV = mkVV (mkV "decidere") ; -- status=guess, src=wikt
lin choose_up_V = advV (lin V OP_choose_V2) OP_up_Adv ; -- guess-p-verb
lin choose_up_V2 = prepV2 (lin V OP_choose_V2) OP_up_Prep ; -- guess-p-verb
lin chop_N = mkN "colpo" | mkN "colpo d'ascia" ; -- status=guess status=guess
lin chop_V = mkV "tagliare" ; -- status=guess, src=wikt
lin chop_V2 = mkV2 (mkV "tagliare") ; -- status=guess, src=wikt
lin chop_off_V = mkV "mozzare" | mkV "recidere" | mkV "resecare" | mkV "risecare" | mkV "smozzare" | mkV "tagliare" | mkV "troncare" ; -- UWN
lin chopine_N = mkN "zeppa" ; -- UWN
lin choppy_A = mkA "increspato" ; -- status=guess
lin chopstick_N = mkN "bacchette" feminine ; -- status=guess
lin choral_A = mkA "corale" ; -- status=guess
lin chorale_N = mkN "corale" feminine ; -- status=guess
lin chord_N = mkN "accordo" ; -- status=guess
lin chordate_N = mkN "cordato" ; -- UWN
lin chorditis_N = mkN "cordite" ; -- UWN
lin chordophone_N = mkN "cordofono" ; -- status=guess
lin chore_N = mkN "corvè" feminine ; -- status=guess
lin chorea_N = mkN "corea" ; -- status=guess
lin choreographer_N = mkN "coreografo" ; -- UWN
lin choreographic_A = mkA "coreografico" ; -- UWN
lin choreography_N = mkN "coreografia" ; -- status=guess
lin chorionic_A = mkA "corionico" ; -- status=guess
lin chorioretinitis_N = mkN "corioretinite" feminine ; -- status=guess
lin chorister_N = mkN "corista" masculine | mkN "cantore" masculine ; -- status=guess status=guess
lin chorley_PN = mkPN "Chorley" ; -- status=guess src=geonames
lin chortle_N = mkN "chortle" ; -- status=guess
lin chortle_V = mkV "ridacchiare" ; -- UWN
lin chorus_N = mkN "coro" ; -- status=guess
lin chosen_A = variants {} ; --
lin chough_N = mkN "gracchio" ; -- UWN
lin chow_N = mkN "foraggio" ; -- status=guess
lin chrism_N = mkN "crisma" ; -- status=guess
lin christchurch_PN = mkPN "Christchurch" ; -- status=guess src=geonames
lin christening_N = mkN "battesimo" ; -- UWN
lin christmas_PN = mkPN "Christmas" ; -- status=guess src=geonames
lin christopher_PN = mkPN "Christopher" ; -- status=guess src=geonames
lin chromatin_N = mkN "cromatina" ; -- status=guess
lin chromatinic_A = mkA "cromatinico" ; -- status=guess
lin chromatogram_N = mkN "cromatogramma" masculine ; -- status=guess
lin chromatographic_A = mkA "cromatografico" ; -- UWN
lin chromatography_N = mkN "cromatografia" ; -- status=guess
lin chromite_N = mkN "cromite" feminine ; -- status=guess
lin chromium_N = mkN "cromo" ; -- status=guess
lin chromolithography_N = mkN "cromolitografia" | mkN "litocromia" ; -- UWN
lin chromophore_N = mkN "cromoforo" ; -- status=guess
lin chromosomal_A = mkA "cromosomico" ; -- status=guess
lin chromosome_N = mkN "cromosoma" masculine ; -- status=guess
lin chromosphere_N = mkN "cromosfera" ; -- status=guess
lin chronic_A = mkA "cronico" ; -- status=guess
lin chronicle_N = mkN "cronaca" ; -- status=guess
lin chronicler_N = mkN "cronista" masculine ; -- status=guess
lin chronograph_N = mkN "cronografo" ; -- UWN
lin chronological_A = mkA "cronologico" ; -- status=guess
lin chronology_N = mkN "cronologia" ; -- status=guess
lin chronometer_N = mkN "cronometro" ; -- status=guess
lin chrysalis_N = mkN "crisalide" ; -- status=guess
lin chrysanthemum_N = mkN "crisantemo" ; -- status=guess
lin chrysotile_N = mkN "crisotilo" ; -- UWN
lin chubbiness_N = mkN "paffutezza" ; -- UWN
lin chuckle_V = mkV "ridacchiare" ; -- UWN
lin chuckle_VS = mkvVS "ridacchiare" ; -- UWN
lin chum_N = mkN "vicino di stanza" ; -- status=guess
lin chump_N = mkN "fesso" | mkN "allocco" ; -- status=guess status=guess
lin chunk_N = mkN "pezzo" | mkN "tocco" ; -- status=guess status=guess
lin chunky_A = mkA "grumoso" ; -- UWN
lin church_N = L.church_N ;
lin churchgoer_N = mkN "devoto" | mkN "praticante" ; -- UWN
lin churchman_N = mkN "chierico" | mkN "ecclesiastico" ; -- UWN
lin churl_N = mkN "neurastenico" | mkN "nevrastenico" ; -- UWN
lin churlish_A = mkA "villano" ; -- status=guess
lin churn_N = mkN "zangola" ; -- status=guess
lin churn_V = mkV "frullare" | mkV "sbattere" | mkV "ribollire" | mkV "spumeggiare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin churn_V2 = mkV2 (mkV "frullare") | mkV2 (mkV "sbattere") | mkV2 (mkV "ribollire") | mkV2 (mkV "spumeggiare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin chute_N = mkN "scivolo" ; -- UWN
lin chutney_N = mkN "chutney" feminine ; -- status=guess
lin chyle_N = mkN "chilo" ; -- status=guess
lin chyliferous_A = mkA "chilifero" ; -- UWN
lin chyme_N = mkN "chimo" ; -- UWN
lin cicada_N = mkN "cicala" ; -- status=guess
lin cicatrice_N = mkN "cicatrice" | mkN "sfregio" ; -- UWN
lin cicatrix_N = mkN "cicatrice" | mkN "sfregio" ; -- UWN
lin cicerone_N = mkN "cicerone" | mkN "guida" | mkN "guida_turistica" ; -- UWN
lin cider_N = mkN "sidro" ; -- status=guess
lin cigar_N = mkN "sigaro" ; -- status=guess
lin cigarette_N = mkN "sigaretta" ; -- status=guess
lin cigarillo_N = mkN "sigaretto" ; -- UWN
lin cilium_N = mkN "ciglio" ; -- UWN
lin cinchona_N = mkN "china" ; -- UWN
lin cincinnati_PN = mkPN "Cincinnati" ; -- status=guess src=geonames
lin cinder_N = mkN "cenere" feminine ; -- status=guess
lin cinderford_PN = mkPN "Cinderford" ; -- status=guess src=geonames
lin cinema_N = mkN "cinema" masculine ;
lin cinematography_N = mkN "cinematografia" | mkN "filmologia" ; -- status=guess status=guess
lin cinerary_A = mkA "cinerario" ; -- status=guess
lin cinnabar_N = mkN "cinabro" ; -- status=guess
lin cinnamon_N = mkN "cannella" ; -- status=guess
lin cipher_N = mkN "cifra" ; -- status=guess
lin cipher_V = mkV "calcolare" | mkV "computare" | mkV "conteggiare" ; -- UWN
lin circadian_A = mkA "circadiano" ; -- status=guess
lin circle_N = mkN "curva" ; -- status=guess
lin circle_V = mkV "cerchiare" ; -- status=guess, src=wikt
lin circle_V2 = mkV2 (mkV "cerchiare") ; -- status=guess, src=wikt
lin circuit_N = variants {} ; --
lin circuitry_N = mkN "circuiteria" ; -- UWN
lin circular_A = mkA "circolare" | mkA "rotondo" | mkA "tondo" ; -- UWN
lin circular_N = mkN "sega circolare" ; -- status=guess
lin circulate_V = variants {} ; --
lin circulate_V2 = variants {} ; --
lin circulation_N = variants {} ; --
lin circulatory_A = mkA "circolatorio" ; -- status=guess
lin circumcise_V2 = mkV2 (mkV "circoncidere") ; -- status=guess, src=wikt
lin circumcision_N = mkN "circoncisione" feminine ; -- status=guess
lin circumduction_N = mkN "circonduzione" feminine ; -- status=guess
lin circumference_N = mkN "circonferenza" ; -- status=guess
lin circumflex_N = mkN "circunflesso" ; -- status=guess
lin circumlocution_N = mkN "giro di parole" | mkN "perifrasi" feminine ; -- status=guess status=guess
lin circumnavigate_V2 = mkV2 (mkV "circumnavigare") ; -- status=guess, src=wikt
lin circumnavigation_N = mkN "circumnavigazione" feminine ; -- status=guess
lin circumscription_N = mkN "circoscrizione" feminine ; -- status=guess
lin circumspect_A = mkA "cauto" | mkA "prudente" ; -- status=guess status=guess
lin circumstance_N = mkN "circonlocuzione" feminine ; -- status=guess
lin circumvent_V2 = mkV2 (mkV "eludere") | mkV2 (mkV "circonvenire") ; -- status=guess, src=wikt status=guess, src=wikt
lin circumvention_N = mkN "circonvenzione" ; -- UWN
lin circus_N = mkN "circo" ; -- status=guess
lin cirencester_PN = mkPN "Cirencester" ; -- status=guess src=geonames
lin cirrhosis_N = mkN "cirrosi" feminine ; -- status=guess
lin cirrocumulus_N = mkN "cirrocumulo" ; -- status=guess
lin cirrostratus_N = mkN "cirrostrato" ; -- UWN
lin cirrus_N = mkN "cirro" ; -- status=guess
lin cisalpine_A = mkA "cisalpino" ; -- status=guess
lin cistern_N = mkN "cisterna" ; -- status=guess
lin cisterna_N = mkN "cisterna" ; -- UWN
lin citadel_N = mkN "cittadella" ; -- status=guess
lin cite_V2 = variants {} ; --
lin citizenFem_N = mkN "cittadino" ; -- UWN
lin citizenMasc_N = variants {} ; --
lin citizenry_N = mkN "cittadinanza" ; -- status=guess
lin citizenship_N = mkN "cittadinanza" ; -- status=guess
lin citrate_N = mkN "citrato" ; -- status=guess
lin citric_A = mkA "citrico" ; -- status=guess
lin citron_N = mkN "cedro" | mkN "lumia" ; -- status=guess status=guess
lin citrulline_N = mkN "citrullina" ; -- status=guess
lin citrus_N = mkN "agrume" masculine ; -- status=guess
lin city_N = L.city_N ;
lin civic_A = mkA "civico" ; -- status=guess
lin civil_A = mkA "civile" ; -- status=guess
lin civilian_A = mkA "civile" ; -- status=guess
lin civilian_N = mkN "civile" masculine ; -- status=guess
lin civility_N = mkN "civiltà" feminine ; -- status=guess
lin civilization_N = mkN "civilizzazione" feminine ; -- status=guess
lin claim_N = mkN "reclamo di proprietà" ; -- status=guess
lin claim_V = mkV "reclamare" | mkV "rivendicare" ; -- status=guess, src=wikt status=guess, src=wikt
lin claim_V2 = mkV2 (mkV "reclamare") | mkV2 (mkV "rivendicare") ; -- status=guess, src=wikt status=guess, src=wikt
lin claim_VS = mkVS (mkV "reclamare") | mkVS (mkV "rivendicare") ; -- status=guess, src=wikt status=guess, src=wikt
lin clairvoyance_N = mkN "chiaroveggenza" ; -- status=guess
lin clairvoyant_A = mkA "chiaroveggente" ; -- status=guess
lin clairvoyant_N = mkN "chiaroveggente" masculine ; -- status=guess
lin clam_N = mkN "vongola" | mkN "tellina" | mkN "arsella" ; -- status=guess status=guess status=guess
lin clamber_V = mkV "arrampicarsi" ; -- status=guess, src=wikt
lin clamor_N = mkN "clamore" | mkN "clamori" ; -- status=guess status=guess
lin clamour_N = mkN "baccano" | mkN "buggerio" | mkN "buscherio" | mkN "busso" | mkN "chiasso" | mkN "clamore" | mkN "patassio" | mkN "strepito" | mkN "vocio" ; -- UWN
lin clamp_N = mkN "brida" ; -- status=guess
lin clan_N = mkN "clan" masculine ; -- status=guess
lin clandestine_A = mkA "clandestino" ; -- status=guess
lin clang_N = mkN "clangore" ; -- UWN
lin clangour_N = mkN "clangore" ; -- UWN
lin clank_N = mkN "clangore" ; -- UWN
lin clannish_A = mkA "selettivo" | mkA "snob" ; -- UWN
lin clap_V = mkV "applaudire" ; -- status=guess, src=wikt
lin clap_V2 = mkV2 (mkV "applaudire") ; -- status=guess, src=wikt
lin clapper_N = mkN "battaglio" | mkN "batacchio" ; -- status=guess status=guess
lin clapperboard_N = mkN "ciac" masculine ; -- status=guess
lin claptrap_N = mkN "sproloquio" ; -- status=guess
lin claque_N = mkN "claque" feminine ; -- status=guess
lin clare_PN = mkPN "Clare" ; -- status=guess src=geonames
lin clarification_N = mkN "chiarimento" ; -- status=guess
lin clarify_V = variants {} ; --
lin clarify_V2 = variants {} ; --
lin clarinet_N = mkN "clarino" | mkN "clarinetto" ; -- status=guess status=guess
lin clarinetistFem_N = mkN "clarinettista" | mkN "clarinista" ; -- UWN
lin clarinetistMasc_N = mkN "clarinettista" | mkN "clarinista" ; -- UWN
lin clarity_N = mkN "chiarezza" ; -- status=guess
lin clarkston_PN = mkPN "Clarkston" ; -- status=guess src=geonames
lin clash_N = mkN "scontro" | mkN "schermaglia" | mkN "baruffa" | mkN "zuffa" ; -- status=guess status=guess status=guess status=guess
lin clash_V = mkV "cozzare" | mkV "scontrarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin clash_V2 = mkV2 (mkV "cozzare") | mkV2 (mkV "scontrarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin clasp_N = mkN "fibbia" | mkN "gancio" | mkN "fermaglio" ; -- status=guess status=guess status=guess
lin clasp_V = stringere_V | mkV "serrare" | mkV "agguantare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin clasp_V2 = mkV2 (stringere_V) | mkV2 (mkV "serrare") | mkV2 (mkV "agguantare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin class_N = mkN "classe" feminine ; -- status=guess
lin classic_A = mkA "classico" ; -- status=guess
lin classic_N = mkN "classico" ; -- status=guess
lin classical_A = mkA "classico" ; -- status=guess
lin classicism_N = mkN "classicismo" ; -- UWN
lin classicist_N = mkN "classicista" ; -- UWN
lin classicistic_A = mkA "classicistico" ; -- status=guess
lin classification_N = mkN "classificazione" feminine ; -- status=guess
lin classify_V2 = variants {} ; --
lin classmate_N = mkN "compagno di classe" | mkN "compagna di classe" ; -- status=guess status=guess
lin classroom_N = mkN "classe" feminine | mkN "aula" ; -- status=guess status=guess
lin clatter_V = mkV "sferragliare" ; -- UWN
lin claude_PN = mkPN "Claude" ; -- status=guess src=geonames
lin clause_N = mkN "frase" | mkN "proposizione" ; -- UWN
lin claustrophobia_N = mkN "claustrofobia" ; -- status=guess
lin claustrophobic_A = mkA "claustrofobo" ; -- status=guess
lin clavichord_N = mkN "clavicordo" ; -- status=guess
lin clavicle_N = mkN "clavicola" ; -- status=guess
lin claw_N = mkN "artiglio" ; -- status=guess
lin claw_V2 = mkV2 (mkV "raspare") | mkV2 (mkV "graffiare") | mkV2 (mkV "artigliare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin clawhammer_N = mkN "martello_a_granchio" ; -- UWN
lin clay_N = mkN "argilla" | mkN "creta" ; -- status=guess status=guess
lin clayey_A = mkA "argilloso" ; -- UWN
lin clean_A = L.clean_A ;
lin clean_V = mkV "pulire" ; -- status=guess, src=wikt
lin clean_V2 = mkV2 (mkV "pulire") ; -- status=guess, src=wikt
lin clean_out_V = advV OP_clean_V OP_out_Adv ; -- guess-p-verb
lin clean_out_V2 = prepV2 OP_clean_V OP_out_Prep ; -- guess-p-verb
lin clean_up_V = advV OP_clean_V OP_up_Adv ; -- guess-p-verb
lin clean_up_V2 = prepV2 OP_clean_V OP_up_Prep ; -- guess-p-verb
lin cleaner_N = variants {} ; --
lin cleaners_N = mkN "lavasecco" | mkN "tintoria" ; -- UWN
lin cleaning_N = mkN "pulitura" | mkN "pulizia" ; -- UWN
lin cleanness_N = mkN "mondezza" | mkN "monnezza" ; -- UWN
lin clean_up_N = mkN "pulitura" | mkN "pulizia" ; -- UWN
lin clear_A = mkA "chiaro" ; -- status=guess
lin clear_V = mkV "chiarire" ; -- status=guess, src=wikt
lin clear_V2 = mkV2 (mkV "chiarire") ; -- status=guess, src=wikt
lin clear_away_V = advV OP_clear_V OP_away_Adv ; -- guess-p-verb
lin clear_away_V2 = mkV2 (advV OP_clear_V OP_away_Adv ) ; -- guess-p-verb
lin clear_off_V = advV OP_clear_V OP_off_Adv ; -- guess-p-verb
lin clear_out_V = advV OP_clear_V OP_out_Adv ; -- guess-p-verb
lin clear_out_V2 = prepV2 OP_clear_V OP_out_Prep ; -- guess-p-verb
lin clear_up_V = mkV "schiarirsi" ; -- UWN
lin clear_up_V2 = prepV2 OP_clear_V OP_up_Prep ; -- guess-p-verb
lin clearance_N = variants {} ; --
lin clearing_N = mkN "radura" ; -- status=guess
lin cleavage_N = mkN "sfaldatura" ; -- status=guess
lin cleaver_N = mkN "coltella" | mkN "mannaia" ; -- UWN
lin cleethorpes_PN = mkPN "Cleethorpes" ; -- status=guess src=geonames
lin clef_N = mkN "chiave" feminine ; -- status=guess
lin cleft_N = mkN "fessura" ; -- status=guess
lin clematis_N = mkN "clematide" feminine ; -- status=guess
lin clemency_N = mkN "clemenza" ; -- status=guess
lin clementine_N = mkN "mandarancio" | mkN "clementina" | mkN "clementino" ; -- status=guess status=guess status=guess
lin clerestory_N = mkN "cleristorio" ; -- status=guess
lin clergy_N = mkN "clero" ; -- status=guess
lin clergyman_N = mkN "chierico" ; -- status=guess
lin cleric_N = mkN "chierico" | mkN "ecclesiastico" ; -- UWN
lin clerical_A = variants {} ; --
lin clericalism_N = mkN "clericalismo" ; -- status=guess
lin clerk_N = mkN "impiegato" ; -- status=guess
lin clevedon_PN = mkPN "Clevedon" ; -- status=guess src=geonames
lin cleveland_PN = mkPN "Cleveland" ; -- status=guess src=geonames
lin clever_A = L.clever_A ;
lin cleverness_N = mkN "creatività" | mkN "genialità" | mkN "ingegno" | mkN "ingegnosità" | mkN "valentia" ; -- UWN
lin clew_N = mkN "bugna" ; -- status=guess
lin click_N = mkN "clicca" ; -- status=guess
lin click_V = mkV "cliccare" ; -- status=guess, src=wikt
lin client_N = mkN "cliente" masculine ; -- status=guess
lin clientage_N = mkN "clientela" ; -- UWN
lin cliff_N = mkN "rupe" | mkN "scogliera" ; -- status=guess status=guess
lin clifford_PN = mkPN "Clifford" ; -- status=guess src=geonames
lin climacteric_N = mkN "menopausa" ; -- UWN
lin climate_N = mkN "cambiamento climatico" | mkN "mutamento climatico" ; -- status=guess status=guess
lin climatic_A = mkA "climatico" ; -- UWN
lin climatologist_N = mkN "climatologa" | mkN "climatologo" ; -- status=guess status=guess
lin climatology_N = mkN "climatologia" ; -- status=guess
lin climax_N = mkN "orgasmo" ; -- status=guess
lin climb_N = mkN "arrampicata" | mkN "ascesa" | mkN "salita" | mkN "scalata" ; -- UWN
lin climb_V = mkV "arrampicare" | mkV "scalare" ; -- status=guess, src=wikt status=guess, src=wikt
lin climb_V2 = mkV2 (mkV "arrampicare") | mkV2 (mkV "scalare") ; -- status=guess, src=wikt status=guess, src=wikt
lin climb_down_V = mkV "posarsi" ; -- UWN
lin climber_N = mkN "arrampicatore" | mkN "scalatore" ; -- status=guess status=guess
lin clime_N = mkN "cielo" | mkN "clima" ; -- UWN
lin clinch_N = mkN "clinch" ; -- UWN
lin cling_V = mkV "aggrapparsi" | mkV "abbarbicarsi" | mkV "appiccicarsi" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin clinic_N = mkN "clinica" ; -- status=guess
lin clinical_A = mkA "clinico" ; -- status=guess
lin clinician_N = mkN "clinico" ; -- status=guess
lin clinker_N = mkN "clinker" ; -- UWN
lin clinometer_N = mkN "clinometro" ; -- status=guess
lin clip_N = mkN "scapellotto" ; -- UWN
lin clipboard_N = mkN "appunti" masculine ; -- status=guess
lin clipper_N = mkN "macchinetta" | mkN "tagliaunghie" | mkN "tronchesina" ; -- UWN
lin clipping_N = mkN "ritaglio" ; -- UWN
lin clique_N = mkN "cricca" ; -- status=guess
lin cliquish_A = mkA "selettivo" | mkA "snob" ; -- UWN
lin clitheroe_PN = mkPN "Clitheroe" ; -- status=guess src=geonames
lin clitoral_A = mkA "clitorico" ; -- status=guess
lin clitoris_N = mkN "clitoride" masculine ; -- status=guess
lin clive_PN = mkPN "Clive" ; -- status=guess src=geonames
lin cloaca_N = mkN "cloaca" | mkN "fogna" ; -- status=guess status=guess
lin cloak_N = mkN "tabarro" ; -- status=guess
lin cloak_V2 = mkV2 (mkV "ammantare") ; -- status=guess, src=wikt
lin cloakmaker_N = mkN "pellicciaio" ; -- UWN
lin cloakroom_N = mkN "guardaroba" masculine ; -- status=guess
lin cloche_N = mkN "cloche" ; -- status=guess
lin clock_N = mkN "orologio" ; -- status=guess
lin clock_V = mkV "cronometrare" ; -- status=guess, src=wikt
lin clock_V2 = mkV2 (mkV "cronometrare") ; -- status=guess, src=wikt
lin clocksmith_N = mkN "orologiaio" ; -- UWN
lin clockwise_A = mkA "destrorso" ; -- UWN
lin clockwise_Adv = mkAdv "senso orario" ; -- status=guess
lin clockwork_N = mkN "meccanismo a molla" | mkN "orologeria" ; -- status=guess status=guess
lin clog_N = mkN "zoccolo" ; -- status=guess
lin clog_V = mkV "intasare" ; -- status=guess, src=wikt
lin clog_V2 = mkV2 (mkV "intasare") ; -- status=guess, src=wikt
lin cloisonne_N = mkN "cloisonné" ; -- status=guess
lin cloister_N = mkN "chiostro" ; -- status=guess
lin clone_N = mkN "clone" masculine ; -- status=guess
lin clone_V2 = mkV2 (mkV "clonare") ; -- status=guess, src=wikt
lin clonic_A = mkA "clonico" ; -- UWN
lin cloning_N = mkN "clonazione" feminine | mkN "clonaggio" ; -- status=guess status=guess
lin clonus_N = mkN "clono" ; -- UWN
lin close_A = mkA "vicino" | mkA "vicina" ; -- status=guess status=guess
lin close_Adv = variants {} ; --
lin close_N = mkN "fine" feminine ; -- status=guess
lin close_V = chiudere_V ; -- status=guess, src=wikt
lin close_V2 = L.close_V2 ;
lin close_down_V = advV OP_close_V OP_down_Adv ; -- guess-p-verb
lin close_down_V2 = prepV2 OP_close_V OP_down_Prep ; -- guess-p-verb
lin close_in_V = advV OP_close_V OP_in_Adv ; -- guess-p-verb
lin close_in_on_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin close_in_upon_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_upon_Prep ; -- guess-p-verb
lin close_off_V2 = prepV2 OP_close_V OP_off_Prep ; -- guess-p-verb
lin close_on_V2 = prepV2 OP_close_V OP_on_Prep ; -- guess-p-verb
lin close_out_V2 = prepV2 OP_close_V OP_out_Prep ; -- guess-p-verb
lin close_up_V = advV OP_close_V OP_up_Adv ; -- guess-p-verb
lin close_up_V2 = prepV2 OP_close_V OP_up_Prep ; -- guess-p-verb
lin closed_A = variants {} ; --
lin closure_N = variants {} ; --
lin clot_N = mkN "coagulo" | mkN "trombo" ; -- status=guess status=guess
lin cloth_N = mkN "abbigliamento" | mkN "tonaca" | mkN "abito" | mkN "vestiario" | mkN "tenuta" ; -- status=guess status=guess status=guess status=guess status=guess
lin clothes_N = variants {} ; --
lin clotheshorse_N = mkN "stendibiancheria" masculine ; -- status=guess
lin clothesline_N = mkN "linea di vestiti" ; -- status=guess
lin clothes_pin_N = mkN "molletta" ; -- UWN
lin clothing_N = mkN "abbigliamento" ; -- status=guess
lin cloud_N = L.cloud_N ;
lin cloud_V = mkV "rannuvolarsi" ; -- status=guess, src=wikt
lin cloud_V2 = mkV2 (mkV "rannuvolarsi") ; -- status=guess, src=wikt
lin cloudberry_N = mkN "camemoro" ; -- status=guess
lin cloudburst_N = mkN "nubifragio" | mkN "scroscio" | mkN "rovescio" ; -- status=guess status=guess status=guess
lin clouding_N = mkN "annuvolamento" ; -- UWN
lin cloudy_A = mkA "annuvolato" | mkA "nuvolo" | mkA "nuvoloso" ; -- UWN
lin clout_N = mkN "cazzotto" | mkN "pugno" ; -- UWN
lin clove_N = mkN "spicchio" ; -- status=guess
lin clove_hitch_N = mkN "parlato" ; -- UWN
lin clover_N = mkN "trifoglio" ; -- status=guess
lin clown_N = mkN "pagliaccio" ; -- status=guess
lin clowne_PN = mkPN "Clowne" ; -- status=guess src=geonames
lin club_1_N = mkN "circolo" | mkN "club" | mkN "società" ; -- UWN
lin club_2_N = mkN "bastone_da_golf" | mkN "mazza" | mkN "mazza_da_golf" ; -- UWN
lin club_N = mkN "club" | mkN "circolo" ; -- status=guess status=guess
lin clubfoot_N = mkN "piedecavo" | mkN "talismo" ; -- UWN
lin clubhouse_N = mkN "circolo" | mkN "club" ; -- UWN
lin clue_N = mkN "indizio" | mkN "pista" masculine ; -- status=guess status=guess
lin clumsiness_N = mkN "goffaggine" | mkN "inettitudine" | mkN "sgraziataggine" feminine ; -- status=guess status=guess status=guess
lin clumsy_A = mkA "goffo" | mkA "impacciato" | mkA "maldestro" ; -- status=guess status=guess status=guess
lin cluster_N = variants {} ; --
lin clutch_N = mkN "frizione" feminine ; -- status=guess
lin clutch_V = variants {} ; --
lin clutch_V2 = variants {} ; --
lin clutter_N = mkN "accozzaglia" | mkN "affastellamento" | mkN "coacervo" | mkN "congerie" | mkN "emporio" | mkN "fricandò" | mkN "guazzabuglio" | mkN "mucchio" | mkN "pipinara" | mkN "pottiniccio" ; -- UWN
lin clydach_PN = mkPN "Clydach" ; -- status=guess src=geonames
lin clydebank_PN = mkPN "Clydebank" ; -- status=guess src=geonames
lin clypeus_N = mkN "clipeo" ; -- UWN
lin co_N = mkN "concognato" ; -- status=guess
lin coach_1_N = variants {} ; --
lin coach_2_N = variants {} ; --
lin coach_3_N = variants {} ; --
lin coach_N = mkN "corriera" ; -- status=guess
lin coach_V = mkV "allenare" | mkV "addestrare" ; -- status=guess, src=wikt status=guess, src=wikt
lin coach_V2 = mkV2 (mkV "allenare") | mkV2 (mkV "addestrare") ; -- status=guess, src=wikt status=guess, src=wikt
lin coachman_N = mkN "cocchiere" masculine ; -- status=guess
lin coagulable_A = mkA "coagulabile" ; -- status=guess
lin coagulate_V = mkV "coagulare" | mkV "cagliare" ; -- status=guess, src=wikt status=guess, src=wikt
lin coagulate_V2 = mkV2 (mkV "coagulare") | mkV2 (mkV "cagliare") ; -- status=guess, src=wikt status=guess, src=wikt
lin coagulation_N = mkN "accagliatura" | mkN "coagulamento" | mkN "coagulazione" ; -- UWN
lin coal_N = mkN "carbone" feminine ; -- status=guess
lin coalescence_N = mkN "coalescenza" ; -- status=guess
lin coalfield_N = mkN "bacino_carbonifero" ; -- UWN
lin coalition_N = mkN "blocco" ; -- status=guess
lin coalman_N = mkN "carbonaio" ; -- UWN
lin coalville_PN = mkPN "Coalville" ; -- status=guess src=geonames
lin coarse_A = mkA "rozzo" | mkA "grezzo" | mkA "greggio" ; -- status=guess status=guess status=guess
lin coarseness_N = mkN "asineria" | mkN "banalità" | mkN "grossaggine" | mkN "grossolanità" | mkN "pecoreccio" | mkN "rozzezza" | mkN "rudezza" | mkN "rusticaggine" | mkN "rustichezza" | mkN "sguaiataggine" | mkN "trivialità" | mkN "volgarità" ; -- UWN
lin coast_N = mkN "costa" | mkN "costiera" | mkN "litorale" ; -- status=guess status=guess status=guess
lin coastal_A = variants {} ; --
lin coaster_N = mkN "nave costiera" ; -- status=guess
lin coastguard_N = mkN "guardacoste" | mkN "guardia_costiera" | mkN "guardiacoste" ; -- UWN
lin coastline_N = mkN "costa" | mkN "litorale" | mkN "littorale" | mkN "marina" ; -- UWN
lin coat_N = L.coat_N ;
lin coat_V2 = mkV2 (mkV "rivestire") ; -- status=guess, src=wikt
lin coatbridge_PN = mkPN "Coatbridge" ; -- status=guess src=geonames
lin coating_N = mkN "applicazione" ; -- UWN
lin coauthorFem_N = mkN "coautore" ; -- UWN
lin coauthorMasc_N = mkN "coautore" ; -- UWN
lin coax_V = costringere_V | mkV "incanalare" ; -- status=guess, src=wikt status=guess, src=wikt
lin coax_V2 = mkV2 (costringere_V) | mkV2 (mkV "incanalare") ; -- status=guess, src=wikt status=guess, src=wikt
lin cobalt_N = mkN "cobalto" ; -- status=guess
lin cobbler_N = mkN "ciabattino" | mkN "ciabattina" ; -- status=guess status=guess
lin cobblestone_N = mkN "pavé" | mkN "ciottolo" ; -- status=guess status=guess
lin cobham_PN = mkPN "Cobham" ; -- status=guess src=geonames
lin cob_nut_N = mkN "nocciola" ; -- UWN
lin cobra_N = mkN "cobra" masculine ; -- status=guess
lin coca_N = mkN "coca" ; -- status=guess
lin cocaine_N = mkN "cocaina" ; -- status=guess
lin coccidiosis_N = mkN "coccidiosi" ; -- UWN
lin coccus_N = mkN "cocco" ; -- UWN
lin coccygeal_A = mkA "coccigeo" ; -- status=guess
lin coccyx_N = mkN "coccige" ; -- status=guess
lin cochineal_N = mkN "cocciniglia" ; -- status=guess
lin cochlea_N = mkN "chiocciola" | mkN "coclea" ; -- UWN
lin cochlear_A = mkA "cocleare" ; -- UWN
lin cock_N = mkN "maschio" | mkN "uccello" ; -- status=guess status=guess
lin cock_V2 = mkV2 (mkV "armare") ; -- status=guess, src=wikt
lin cockade_N = mkN "coccarda" ; -- status=guess
lin cockatoo_N = mkN "cacatoa" | mkN "cacatua" ; -- UWN
lin cockatrice_N = mkN "coccatrice" feminine ; -- status=guess
lin cockchafer_N = mkN "maggiolino" | mkN "melolonta" masculine ; -- status=guess status=guess
lin cocker_N = mkN "cocker" ; -- status=guess
lin cockerel_N = mkN "galletto" | mkN "pollastra" | mkN "pollastro" ; -- status=guess status=guess status=guess
lin cockermouth_PN = mkPN "Cockermouth" ; -- status=guess src=geonames
lin cockle_N = mkN "loglio" ; -- status=guess
lin cockpit_N = mkN "abitacolo" ; -- status=guess
lin cockroach_N = mkN "blatta" | mkN "scarafaggio" ; -- status=guess status=guess
lin cockscomb_N = mkN "cresta" ; -- UWN
lin cocktail_N = mkN "cocktail" ; -- UWN
lin cockup_N = mkN "casino" ; -- UWN
lin cocoa_N = mkN "cacao" ; -- status=guess
lin coconut_N = mkN "noce di cocco" ; -- status=guess
lin cocoon_N = mkN "bozzolo" ; -- status=guess
lin cod_N = mkN "merluzzo" ; -- status=guess
lin cod_liver_oil_N = mkN "olio_di_fegato_di_merluzzo" ; -- UWN
lin coda_N = mkN "finale" ; -- UWN
lin code_N = mkN "codice" masculine ; -- status=guess
lin code_V2 = variants {} ; --
lin codefendant_N = mkN "litisconsorte" | mkN "coimputato" ; -- status=guess status=guess
lin codeine_N = mkN "codeina" ; -- status=guess
lin codex_N = mkN "codice" masculine ; -- status=guess
lin codicil_N = mkN "codicillo" ; -- UWN
lin codification_N = mkN "codifica" | mkN "codificazione" ; -- UWN
lin codon_N = mkN "codone" masculine ; -- status=guess
lin codsall_PN = mkPN "Codsall" ; -- status=guess src=geonames
lin coeducation_N = mkN "coeducazione" feminine ; -- status=guess
lin coefficient_N = mkN "coefficiente" masculine ; -- status=guess
lin coelacanth_N = mkN "celacanto" ; -- status=guess
lin coeliac_A = mkA "celiaco" ; -- UWN
lin coelostat_N = mkN "celostata" | mkN "celostato" | mkN "siderostato" ; -- UWN
lin coenzyme_N = mkN "coenzima" ; -- status=guess
lin coerce_V2 = mkV2 (costringere_V) ; -- status=guess, src=wikt
lin coercion_N = mkN "coercizione" feminine ; -- status=guess
lin coercive_A = mkA "coercitivo" ; -- status=guess
lin coeval_N = mkN "contemporaneo" ; -- UWN
lin co_exist_V = mkV "coesistere" ; -- UWN
lin coexistent_A = mkA "coesistente" ; -- status=guess
lin coffee_N = mkN "caffè" ;
lin coffeepot_N = mkN "caffettiera" | mkN "cuccuma" ; -- UWN
lin coffer_N = mkN "cassettone" masculine ; -- status=guess
lin coffin_N = mkN "bara" | mkN "cassa da morto" ; -- status=guess status=guess
lin cog_N = mkN "rotellina" ; -- status=guess
lin cogent_A = mkA "intelligibile" | mkA "logico" ; -- status=guess status=guess
lin cognac_N = mkN "cognac" ; -- status=guess
lin cognate_A = mkA "affine" ; -- status=guess
lin cognition_N = mkN "conoscenza" masculine ; -- status=guess
lin cognitive_A = mkA "cognitivo" ; -- status=guess
lin cognizant_A = mkA "consapevole" ; -- UWN
lin cognomen_N = mkN "cognome" masculine ; -- status=guess
lin cohabitation_N = mkN "concubinato" ; -- status=guess
lin coherence_N = mkN "coerenza" | mkN "coesione" | mkN "congruenza" ; -- UWN
lin coherency_N = mkN "coerenza" | mkN "coesione" | mkN "congruenza" ; -- UWN
lin coherent_A = mkA "coerente" ; -- status=guess
lin cohesiveness_N = mkN "gommosità" ; -- UWN
lin cohort_N = mkN "coorte" ; -- status=guess
lin coiffure_N = mkN "acconciatura" | mkN "pettinatura" | mkN "taglio" ; -- UWN
lin coil_N = mkN "bobina" ; -- status=guess
lin coimbatore_PN = mkPN "Coimbatore" ; -- status=guess src=geonames
lin coin_N = mkN "moneta" ; -- status=guess
lin coin_V2 = mkV2 (mkV "coniare") ; -- status=guess, src=wikt
lin coinage_N = mkN "coniazione" | mkN "onomaturgia" ; -- UWN
lin coincide_V = mkV "coincidere" ; -- status=guess, src=wikt
lin coincidence_N = mkN "coincidenza" ; -- status=guess
lin coincidental_A = variants {} ;
lin coinsurance_N = mkN "franchigia" ; -- status=guess
lin coital_A = mkA "copulatore" ; -- UWN
lin coitus_N = mkN "coito" ; -- status=guess
lin coke_N = mkN "coke" masculine ; -- status=guess
lin col_N = mkN "forcella" ; -- status=guess
lin colander_N = mkN "colino" ; -- status=guess
lin colchester_PN = mkPN "Colchester" ; -- status=guess src=geonames
lin colchicine_N = mkN "colchicina" ; -- status=guess
lin cold_A = L.cold_A ;
lin cold_N = mkN "fusione fredda" ; -- status=guess
lin coldness_N = mkN "freddezza" ; -- status=guess
lin colic_N = mkN "colica" ; -- status=guess
lin colitis_N = mkN "colite" feminine ; -- status=guess
lin collaborate_V = mkV "collaborare" ; -- status=guess, src=wikt
lin collaboration_N = mkN "collaborazione" feminine ; -- status=guess
lin collaborationist_N = mkN "collaborazionista" ; -- UWN
lin collaborator_N = mkN "collaboratore" | mkN "collaboratrice" feminine ; -- status=guess status=guess
lin collage_N = mkN "collage" ; -- UWN
lin collagen_N = mkN "collagene" | mkN "collageno" ; -- UWN
lin collapse_N = mkN "collasso" | mkN "crollo" | mkN "tracollo" ; -- status=guess status=guess status=guess
lin collar_N = mkN "collo" | mkN "anello" | mkN "fascetta" ; -- status=guess status=guess status=guess
lin collar_V2 = mkV2 (mkV "beccare") ; -- status=guess, src=wikt
lin collarbone_N = mkN "clavicola" ; -- UWN
lin collards_N = mkN "cavolo_nero" ; -- UWN
lin colleague_N = mkN "collega" masculine ; -- status=guess
lin collect_V = raccogliere_V ; -- status=guess, src=wikt
lin collect_V2 = mkV2 (raccogliere_V) ; -- status=guess, src=wikt
lin collectible_A = mkA "pagabile" ; -- UWN
lin collection_N = mkN "raccolta" ; -- status=guess
lin collective_A = mkA "collegiale" | mkA "collettivo" ; -- UWN
lin collective_N = mkN "contratto collettivo di lavoro" ; -- status=guess
lin collectivism_N = mkN "collettivismo" ; -- status=guess
lin collectivist_N = mkN "rosso" | mkN "sinistroide" | mkN "sinistrorso" ; -- UWN
lin collector_N = mkN "collezionista" masculine ; -- status=guess
lin college_N = variants {} ; --
lin collide_V = mkV "cozzare" ; -- status=guess, src=wikt
lin collie_N = mkN "collie" | mkN "pastore_scozzese" ; -- UWN
lin colliery_N = mkN "miniera di carbone" ; -- status=guess
lin colloid_N = mkN "colloide" | mkN "colóide" masculine ; -- status=guess status=guess
lin colloidal_A = mkA "colloidale" ; -- status=guess
lin colloquial_A = variants {} ;
lin colloquy_N = mkN "colloquio" | mkN "conversazione" feminine ; -- status=guess status=guess
lin collotype_N = mkN "collotipia" ; -- UWN
lin colne_PN = mkPN "Colne" ; -- status=guess src=geonames
lin cologne_N = mkN "acqua di Colonia" ; -- status=guess
lin cologne_PN = mkPN "Cologne" ; -- status=guess src=geonames
lin colombia_PN = mkPN "Colombia" ; -- status=guess src=geonames
lin colombo_PN = mkPN "Colombo" ; -- status=guess src=geonames
lin colon_N = mkN "due punti" ; -- status=guess
lin colonel_N = mkN "colonnello" ; -- status=guess
lin colonial_A = mkA "coloniale" ; -- UWN
lin colonialism_N = mkN "colonialismo" ; -- status=guess
lin colonialist_N = mkN "colonialista" ; -- UWN
lin colonist_N = mkN "colonisto" | mkN "colonista" ; -- status=guess status=guess
lin colonizer_N = mkN "colonizzatore" ; -- UWN
lin colonnade_N = mkN "colonnato" ; -- status=guess
lin colonoscopy_N = mkN "coloscopia" ; -- status=guess
lin colony_N = mkN "colonia" ; -- status=guess
lin colophony_N = mkN "colofonia" | mkN "pece_greca" ; -- UWN
lin colorado_PN = mkPN "Colorado" ; -- status=guess src=geonames
lin colorectal_A = mkA "colorettale" ; -- status=guess
lin colorimeter_N = mkN "colorimetro" ; -- status=guess
lin colorimetric_A = mkA "colorimetrico" ; -- status=guess
lin colorlessness_N = mkN "acromatismo" ; -- UWN
lin colossus_N = mkN "colosso" ; -- status=guess
lin colostrum_N = mkN "colostro" ; -- status=guess
lin colour_A = mkA "daltonico" ; -- status=guess
lin colour_N = mkN "televisore a colori" ; -- status=guess
lin colour_V = mkV "sbiadirsi" | mkV "schiarire" | mkV "scolorare" | mkV "scolorire" | mkV "scolorirsi" | mkV "stingere" | mkV "stingersi" ; -- UWN
lin colour_V2 = variants {} ; --
lin colour_V2A = variants {} ; --
lin coloured_A = variants {} ; --
lin colourful_A = variants {} ; --
lin colt_N = mkN "puledro" ; -- status=guess
lin colter_N = mkN "coltello" | mkN "coltro" ; -- status=guess status=guess
lin columbarium_N = mkN "colombario" ; -- status=guess
lin columbia_PN = mkPN "Columbia" ; -- status=guess src=geonames
lin columbine_N = mkN "colombina" | mkN "aquilegia" ; -- status=guess status=guess
lin columbium_N = mkN "columbio" ; -- status=guess
lin columbus_PN = mkPN "Columbus" ; -- status=guess src=geonames
lin column_N = mkN "colonna" ; -- status=guess
lin columnistFem_N = mkN "colonnista" | mkN "columnist" | mkN "cronista" | mkN "editorialista" | mkN "fondista" | mkN "opinionista" ; -- UWN
lin columnistMasc_N = mkN "colonnista" | mkN "columnist" | mkN "cronista" | mkN "editorialista" | mkN "fondista" | mkN "opinionista" ; -- UWN
lin coma_N = mkN "coma" ; -- status=guess
lin comatose_A = mkA "comatoso" ; -- UWN
lin comb_N = mkN "cresta" ; -- status=guess
lin comb_V = mkV "pettinare" ; -- status=guess, src=wikt
lin comb_V2 = mkV2 (mkV "pettinare") ; -- status=guess, src=wikt
lin combat_N = mkN "battaglia" masculine ; -- status=guess
lin combat_V = mkV "combattere" | mkV "tenzonare" ; -- UWN
lin combat_V2 = variants {} ; --
lin combatant_N = mkN "combattente" | mkN "lottatore" ; -- UWN
lin combativeness_N = mkN "bellicosità" ; -- UWN
lin combination_N = variants {} ; --
lin combine_N = mkN "mietitrebbiatrice" ; -- status=guess
lin combine_V = mkV "combinare" ; -- status=guess, src=wikt
lin combine_V2 = mkV2 (mkV "combinare") ; -- status=guess, src=wikt
lin combine_VV = mkVV (mkV "combinare") ; -- status=guess, src=wikt
lin combined_A = variants {} ; --
lin combining_N = mkN "abbinamento" ; -- UWN
lin combustible_A = mkA "carburante" | mkA "combustibile" ; -- UWN
lin combustion_N = mkN "combustione" feminine ; -- status=guess
lin come_V = L.come_V ;
lin come_about_V = advV OP_come_V OP_about_Adv ; -- guess-p-verb
lin come_across_V = advV OP_come_V OP_across_Adv ; -- guess-p-verb
lin come_across_V2 = prepV2 OP_come_V OP_across_Prep ; -- guess-p-verb
lin come_along_V = advV OP_come_V OP_along_Adv ; -- guess-p-verb
lin come_along_with_V2 = prepV2 (advV OP_come_V OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_apart_V = mkV "smembrarsi" | mkV "spezzarsi" ; -- UWN
lin come_around_V = mkV "ricorrere" ; -- UWN
lin come_around_to_V2 = prepV2 (advV OP_come_V OP_around_Adv ) OP_to_Prep ; -- guess-p-verb
lin come_away_V = mkV "staccarsi" ; -- UWN
lin come_back_V = advV OP_come_V OP_back_Adv ; -- guess-p-verb
lin come_before_V2 = prepV2 OP_come_V OP_before_Prep ; -- guess-p-verb
lin come_by_V = advV OP_come_V OP_by_Adv ; -- guess-p-verb
lin come_by_V2 = prepV2 OP_come_V OP_by_Prep ; -- guess-p-verb
lin come_down_V = advV OP_come_V OP_down_Adv ; -- guess-p-verb
lin come_down_on_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin come_down_upon_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_upon_Prep ; -- guess-p-verb
lin come_down_with_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forth_V = advV OP_come_V OP_forth_Adv ; -- guess-p-verb
lin come_forth_with_V2 = prepV2 (advV OP_come_V OP_forth_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forward_V = advV OP_come_V OP_forward_Adv ; -- guess-p-verb
lin come_from_V2 = prepV2 OP_come_V OP_from_Prep ; -- guess-p-verb
lin come_in_V = advV OP_come_V OP_in_Adv ; -- guess-p-verb
lin come_in_V2 = prepV2 OP_come_V OP_in_Prep ; -- guess-p-verb
lin come_in_for_V2 = prepV2 (advV OP_come_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin come_into_V2 = prepV2 OP_come_V OP_into_Prep ; -- guess-p-verb
lin come_into_use_V = variants {} ; -- guess-p-verb
lin come_off_V = advV OP_come_V OP_off_Adv ; -- guess-p-verb
lin come_off_V2 = prepV2 OP_come_V OP_off_Prep ; -- guess-p-verb
lin come_off_it_V = variants {} ; -- guess-p-verb
lin come_on_V = advV OP_come_V OP_on_Adv ; -- guess-p-verb
lin come_out_V = mkV "uscire" | mkV "venire" ; -- UWN
lin come_out_in_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin come_out_of_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin come_out_with_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_over_V = advV OP_come_V OP_over_Adv ; -- guess-p-verb
lin come_over_V2 = prepV2 OP_come_V OP_over_Prep ; -- guess-p-verb
lin come_round_V = advV OP_come_V OP_round_Adv ; -- guess-p-verb
lin come_through_V = advV OP_come_V OP_through_Adv ; -- guess-p-verb
lin come_through_with_V2 = prepV2 (advV OP_come_V OP_through_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_to_V = advV OP_come_V OP_to_Adv ; -- guess-p-verb
lin come_to_V2 = prepV2 OP_come_V OP_to_Prep ; -- guess-p-verb
lin come_up_V = mkV "nascere" ; -- UWN
lin come_up_against_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_against_Prep ; -- guess-p-verb
lin come_up_to_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin come_up_with_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_upon_V2 = prepV2 OP_come_V OP_upon_Prep ; -- guess-p-verb
lin come_with_V2 = prepV2 OP_come_V OP_with_Prep ; -- guess-p-verb
lin comedy_N = mkN "commedia" ; -- status=guess
lin comeliness_N = mkN "bellezza" ; -- UWN
lin comet_N = mkN "cometa" ; -- status=guess
lin comfort_N = mkN "benessere" masculine ; -- status=guess
lin comfort_V2 = variants {} ; --
lin comfortable_A = mkA "comodo" ; -- status=guess
lin comforter_N = mkN "consolatore" | mkN "consolatrice" feminine ; -- status=guess status=guess
lin comfrey_N = mkN "consolida" ; -- status=guess
lin comfy_A = mkA "comodo" ; -- status=guess
lin comic_A = mkA "comico" ; -- status=guess
lin comic_N = mkN "fumetto" | mkN "striscia" ; -- status=guess status=guess
lin coming_A = variants {} ; --
lin coming_N = mkN "avvento" ; -- UWN
lin comma_N = mkN "virgola" masculine ; -- status=guess
lin command_1_N = variants {} ; --
lin command_2_N = variants {} ; --
lin command_N = variants {} ; --
lin command_V = variants {} ; --
lin command_V2 = variants {} ; --
lin commandant_N = mkN "comandante" masculine ; -- status=guess
lin commander_N = variants {} ; --
lin commandment_N = mkN "comandamento" ; -- status=guess
lin commemorative_A = mkA "apologetico" | mkA "celebrativo" | mkA "commemorativo" | mkA "elogiativo" | mkA "encomiastico" | mkA "esaltatorio" | mkA "laudatorio" | mkA "lodativo" | mkA "memorativo" | mkA "ricordativo" ; -- UWN
lin commence_V = mkV "cominciare" ; -- status=guess, src=wikt
lin commence_V2 = mkV2 (mkV "cominciare") ; -- status=guess, src=wikt
lin commendation_N = mkN "elogio" | mkN "encomio" ; -- status=guess status=guess
lin comment_N = mkN "commento" ; -- status=guess
lin comment_V = variants {} ; --
lin comment_V2 = variants {} ; --
lin comment_VS = variants {} ; --
lin commentary_N = variants {} ; --
lin commentator_N = variants {} ; --
lin commerce_N = variants {} ; --
lin commercial_A = variants {} ; --
lin commercial_N = mkN "chiocciola" ; -- status=guess
lin commercialization_N = mkN "commercializzazione" feminine ; -- status=guess
lin commiseration_N = mkN "commiserazione" | mkN "condoglianza" | mkN "condoglianze" ; -- UWN
lin commissar_N = mkN "commissario" | mkN "commissario_del_popolo" ; -- UWN
lin commissariat_N = mkN "cibaria" | mkN "fornitura" | mkN "magazzino" | mkN "provviste" | mkN "rifornimenti" | mkN "rifornimento" | mkN "spaccio" | mkN "vettovaglie" ; -- UWN
lin commission_N = mkN "commissione" | mkN "percentuale" | mkN "provvigione" ; -- UWN
lin commission_V2 = variants {} ; --
lin commission_V2V = variants {} ; --
lin commissioner_N = mkN "commissario" ; -- UWN
lin commit_V2 = mkV2 (mkV "affidare") ; -- status=guess, src=wikt
lin commitment_N = mkN "impegno" | mkN "dedizione" feminine ; -- status=guess status=guess
lin committee_N = mkN "comitato" ; -- status=guess
lin commode_1_N = mkN "canterale" | mkN "canterano" | mkN "comò" | mkN "sciffoniera" ; -- UWN
lin commode_2_N = mkN "canterale" | mkN "canterano" | mkN "comò" | mkN "sciffoniera" ; -- UWN
lin commodity_N = mkN "bene" | mkN "genere" | mkN "mercanzia" | mkN "merci" | mkN "roba" ; -- UWN
lin commodore_N = mkN "commodoro" ; -- status=guess
lin common_1_A = variants {} ; --
lin common_2_A = variants {} ; --
lin common_A = mkA "comune" ; -- status=guess
lin common_N = mkN "ontano comune" ; -- status=guess
lin commonplace_N = mkN "luogo comune" ; -- status=guess
lin commons_N = variants {} ; --
lin commonwealth_N = mkN "nazione" | mkN "paese" | mkN "stato" ; -- UWN
lin commotion_N = mkN "agitazione" feminine | mkN "scandalo" ; -- status=guess status=guess
lin commune_N = mkN "comune" ; -- UWN
lin communicant_N = mkN "comunicando" ; -- UWN
lin communicate_V = mkV "comunicare" ; -- UWN
lin communicate_V2 = variants {} ; --
lin communication_N = mkN "comunicazione" feminine ; -- status=guess
lin communicativeness_N = mkN "comunicativa" ; -- UWN
lin communism_N = mkN "comunismo" ; -- status=guess
lin communist_A = mkA "comunista" ; -- status=guess
lin communist_N = mkN "comunista and" ; -- status=guess
lin community_N = mkN "comunanza" ; -- status=guess
lin communization_N = mkN "nazionalizzazione" | mkN "statalizzazione" | mkN "statizzazione" ; -- UWN
lin commutable_A = mkA "cambiabile" | mkA "commutabile" | mkA "permutabile" | mkA "scambiabile" ; -- UWN
lin commutation_N = mkN "cambio" | mkN "sostituzione" ; -- UWN
lin commutator_N = mkN "commutatore" ; -- UWN
lin commute_V = mkV "commutare" ; -- status=guess, src=wikt
lin commute_V2 = mkV2 (mkV "commutare") ; -- status=guess, src=wikt
lin commuter_N = mkN "pendolare" masculine ; -- status=guess
lin compact_A = mkA "compatto" ; -- status=guess
lin compact_N = mkN "portacipria" ; -- UWN
lin companion_N = variants {} ; --
lin company_1_N = mkN "compagnia" ;
lin company_2_N = mkN "compagnia" ;
lin comparability_N = mkN "comparabilità" | mkN "confronto" ; -- UWN
lin comparable_A = mkA "comparabile" ; -- status=guess
lin comparative_A = mkA "comparativo" ; -- status=guess
lin comparative_N = mkN "comparativo" ; -- status=guess
lin compare_N = mkN "comparabilità" | mkN "confronto" ; -- UWN
lin compare_V = mkV "paragonare" ; -- status=guess, src=wikt
lin comparison_N = mkN "comparazione" feminine ; -- status=guess
lin compartment_N = variants {} ; --
lin compartmentalization_N = mkN "categorizzazione" | mkN "classificazione" ; -- UWN
lin compass_N = mkN "bussola" ; -- status=guess
lin compassion_N = mkN "compassione" feminine ; -- status=guess
lin compassionate_A = mkA "compassionevole" ; -- status=guess
lin compatibility_N = mkN "compatibilità" feminine ; -- status=guess
lin compatible_A = mkA "compatibile" ; -- status=guess
lin compatriotFem_N = mkN "compaesano" | mkN "compatriota" | mkN "compatriotta" | mkN "connazionale" | mkN "conterraneo" ; -- UWN
lin compatriotMasc_N = mkN "compatriota" masculine ; -- status=guess
lin compeer_N = mkN "eguale" | mkN "pari" | mkN "uguale" ; -- UWN
lin compel_V2 = variants {} ; --
lin compel_V2V = variants {} ; --
lin compel_VV = variants {} ; --
lin compensate_V = variants {} ; --
lin compensate_V2 = variants {} ; --
lin compensation_N = variants {} ; --
lin compete_V = mkV "competere" | mkV "gareggiare" ; -- status=guess, src=wikt status=guess, src=wikt
lin competence_N = variants {} ; --
lin competent_A = variants {} ; --
lin competition_N = mkN "competizione" feminine | mkN "concorrenza" ; -- status=guess status=guess
lin competitive_A = mkA "competitivo" | mkA "concorrenziale" ; -- UWN
lin competitor_N = mkN "concorrente" ; -- status=guess
lin compilation_N = mkN "compilazione" feminine ; -- status=guess
lin compile_V2 = mkV2 (mkV "compilare") ; -- status=guess, src=wikt
lin complacence_N = mkN "autocompiacimento" | mkN "narcisismo" ; -- UWN
lin complacency_N = mkN "autocompiacimento" ; -- status=guess
lin complain_V = mkV "lamentarsi" | mkV "lagnarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin complain_VS = mkVS (mkV "lamentarsi") | mkVS (mkV "lagnarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin complainant_N = mkN "attore" | mkN "citante" | mkN "querelante" ; -- UWN
lin complaint_N = mkN "disturbo" ; -- status=guess
lin complaisance_N = mkN "accondiscendenza" | mkN "arrendevolezza" | mkN "condiscendenza" | mkN "correntezza" | mkN "obbedienza" | mkN "remissività" ; -- UWN
lin complement_N = mkN "complemento" ; -- UWN
lin complement_V2 = variants {} ; --
lin complementarity_N = mkN "complementarità" feminine ; -- status=guess
lin complementary_A = variants {} ; --
lin complete_A = mkA "completo" | mkA "completa" ; -- status=guess status=guess
lin complete_V = mkV "completare" | compiere_V ; -- status=guess, src=wikt status=guess, src=wikt
lin complete_V2 = mkV2 (mkV "completare") | mkV2 (compiere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin completeness_N = mkN "completezza" ; -- status=guess
lin completion_N = mkN "completamento" ; -- status=guess
lin complex_A = mkA "complesso" | mkA "molteplice" ; -- UWN
lin complex_N = mkN "numero complesso" ; -- status=guess
lin complexity_N = mkN "complessità" feminine ; -- status=guess
lin compliance_N = mkN "arrendevolezza" ; -- status=guess
lin complicate_V2 = mkV2 (mkV "complicare") ; -- status=guess, src=wikt
lin complicated_A = variants {} ; --
lin complication_N = mkN "complicazione" ; -- UWN
lin complicity_N = mkN "complicità" ; -- UWN
lin compliment_N = mkN "complimento" ; -- status=guess
lin compliment_V2 = mkV2 (mkV "complimentarsi") ; -- status=guess, src=wikt
lin complin_N = mkN "compieta" ; -- UWN
lin compline_N = mkN "compieta" ; -- status=guess
lin comply_V = mkV "attuare" ; -- status=guess, src=wikt
lin comply_V2 = mkV2 (mkV "attuare") ; -- status=guess, src=wikt
lin component_N = mkN "componente" masculine ; -- status=guess
lin comport_V = mkV "comportarsi" ; -- status=guess, src=wikt
lin comport_V2 = mkV2 (mkV "comportarsi") ; -- status=guess, src=wikt
lin compose_V = comporre_V ; -- status=guess, src=wikt
lin compose_V2 = mkV2 (comporre_V) ; -- status=guess, src=wikt
lin composer_N = mkN "compositore" masculine ; -- status=guess
lin composite_N = mkN "compendio" ; -- UWN
lin composition_N = mkN "composizione" feminine ; -- status=guess
lin compositor_N = mkN "compositore" | mkN "tipografo" ; -- UWN
lin compost_N = mkN "concime" | mkN "ingrasso" ; -- UWN
lin compost_V2 = mkV2 (mkV "compostare") ; -- status=guess, src=wikt
lin composure_N = mkN "contegno" | mkN "compostezza" | mkN "ritegno" | mkN "autocontrollo" | mkN "disponibilità" feminine ; -- status=guess status=guess status=guess status=guess status=guess
lin compote_N = mkN "composta" ; -- status=guess
lin compound_A = mkA "composto" | mkA "costituito" ; -- status=guess status=guess
lin compound_N = mkN "composto" | mkN "miscuglio" | mkN "amalgama" masculine ; -- status=guess status=guess status=guess
lin compound_V = aggiungere_V ; -- status=guess, src=wikt
lin compound_V2 = mkV2 (aggiungere_V) ; -- status=guess, src=wikt
lin comprehend_V2 = mkV2 (comprendere_V) ; -- status=guess, src=wikt
lin comprehensibility_N = mkN "intellegibilità" | mkN "intelligibilità" ; -- UWN
lin comprehensible_A = mkA "comprensibile" ; -- status=guess
lin comprehensive_A = variants {} ; --
lin comprehensiveness_N = mkN "comprensività" ; -- UWN
lin compress_N = mkN "compressa" | mkN "impacco" ; -- UWN
lin compress_V2 = mkV2 (comprimere_V) ; -- status=guess, src=wikt
lin compressibility_N = mkN "comprimibilità" feminine ; -- status=guess
lin compression_N = mkN "compressione" feminine ; -- status=guess
lin compressor_N = mkN "compressore" masculine ; -- status=guess
lin comprise_V2 = mkV2 (consistere_V) ; -- status=guess, src=wikt
lin compromise_N = variants {} ; --
lin compromise_V = variants {} ; --
lin compromise_V2 = variants {} ; --
lin comptroller_N = mkN "controllore" masculine ; -- status=guess
lin compulsiveness_N = mkN "compulsività" feminine ; -- status=guess
lin compulsory_A = mkA "obbligatorio" ; -- status=guess
lin computation_N = mkN "calcolo" ; -- status=guess
lin computational_A = mkA "computazionale" ; -- status=guess
lin compute_V = mkV "computare" | mkV "elaborare" ; -- status=guess, src=wikt status=guess, src=wikt
lin compute_V2 = mkV2 (mkV "computare") | mkV2 (mkV "elaborare") ; -- status=guess, src=wikt status=guess, src=wikt
lin computer_N = L.computer_N ;
lin computing_N = variants {} ; --
lin comrade_N = mkN "compagno" ; -- status=guess
lin comradely_A = variants {} ;
lin comradely_Adv = adjAdv comradely_A ; -- derived
lin con_N = mkN "carcerato" ; -- status=guess
lin concave_A = mkA "concavo" ; -- status=guess
lin conceal_V2 = mkV2 (mkV "nascondere") | mkV2 (mkV "celare") ; -- status=guess, src=wikt status=guess, src=wikt
lin concealment_N = mkN "ammantatura" | mkN "dissimulazione" | mkN "nascondimento" | mkN "occultamento" | mkN "ricoperta" | mkN "ricopertura" | mkN "ricoprimento" | mkN "sottrazione" ; -- UWN
lin concede_V = mkV "concedere" ; -- UWN
lin concede_V2 = variants {} ; --
lin concede_VS = mkvVS "confessare" ; -- UWN
lin conceit_N = mkN "concetto" ; -- status=guess
lin conceited_A = mkA "gonfio" ; -- UWN
lin conceivable_A = mkA "concepibile" | mkA "ideabile" | mkA "immaginabile" | mkA "pensabile" ; -- status=guess status=guess status=guess status=guess
lin conceive_V = mkV "concepire" ; -- status=guess, src=wikt
lin conceive_V2 = mkV2 (mkV "concepire") ; -- status=guess, src=wikt
lin concentrate_N = mkN "concentrato" ; -- status=guess
lin concentrate_V = mkV "concentrarsi" ; -- status=guess, src=wikt
lin concentrate_V2 = mkV2 (mkV "concentrarsi") ; -- status=guess, src=wikt
lin concentration_N = mkN "concentrazione" feminine ; -- status=guess
lin concentric_A = mkA "concentrico" ; -- status=guess
lin concentricity_N = mkN "concentricità" ; -- UWN
lin concept_N = mkN "concetto" ; -- status=guess
lin conception_N = mkN "concetto" ; -- status=guess
lin conceptual_A = variants {} ; --
lin conceptualism_N = mkN "concettualismo" ; -- UWN
lin conceptualization_N = mkN "enunciazione" | mkN "formulazione" ; -- UWN
lin concern_N = mkN "impresa" ; -- status=guess
lin concern_V2 = mkV2 (mkV "interessare") | mkV2 (mkV "concernere") ; -- status=guess, src=wikt status=guess, src=wikt
lin concerned_A = variants {} ; --
lin concerning_Prep = variants {} ; --
lin concert_N = mkN "concerto" ; -- status=guess
lin concert_V2 = mkV2 (mkV "concertare") | mkV2 (mkV "collaborare") ; -- status=guess, src=wikt status=guess, src=wikt
lin concertina_N = mkN "fisarmonica" ; -- status=guess
lin concerto_N = mkN "concerto" ; -- status=guess
lin concession_N = mkN "concessione" ; -- UWN
lin concessionaire_N = mkN "concessionario" ; -- UWN
lin concessive_A = mkA "concessivo" ; -- status=guess
lin concierge_N = mkN "guardaporta" | mkN "portiere" | mkN "portinaio" ; -- UWN
lin conciliator_N = mkN "conciliatore" | mkN "pacere" | mkN "paciale" | mkN "paciaro" | mkN "paciere" | mkN "pacificatore" | mkN "riconciliatore" ; -- UWN
lin conciliatory_A = mkA "conciliante" | mkA "conciliativo" | mkA "conciliatore" | mkA "mediatore" | mkA "pacificativo" | mkA "pacificatore" | mkA "pacioso" ; -- UWN
lin concise_A = mkA "conciso" ; -- status=guess
lin conciseness_N = mkN "brevità" | mkN "compendiosità" | mkN "concisione" | mkN "scabrezza" | mkN "sentenziosità" | mkN "sinteticità" ; -- UWN
lin conclave_N = mkN "conclave" masculine ; -- status=guess
lin conclude_V = mkV "concludere" ; -- UWN
lin conclude_V2 = variants {} ; --
lin conclude_VS = mkvVS "concludere" ; -- UWN
lin conclusion_N = mkN "conclusione" feminine ; -- status=guess
lin conclusive_A = mkA "conclusivo" | mkA "decisivo" ; -- status=guess status=guess
lin concoction_N = mkN "manipolazione" ; -- UWN
lin concomitant_A = mkA "concomitante" ; -- status=guess
lin concordant_A = mkA "concordante – Syn.: concorde" ; -- status=guess
lin concordat_N = mkN "concordato" ; -- UWN
lin concourse_N = mkN "concorso" | mkN "affluenza" | mkN "moltitudine" | mkN "turba" ; -- status=guess status=guess status=guess status=guess
lin concrete_A = mkA "in di cemento" ; -- status=guess
lin concrete_N = mkN "calcestruzzo" | mkN "cemento" ;
lin concrete_V = mkV (mkV "coprire") "di calcestruzzo" | mkV "cementificare" ; -- status=guess, src=wikt status=guess, src=wikt
lin concrete_V2 = mkV2 (mkV (mkV "coprire") "di calcestruzzo") | mkV2 (mkV "cementificare") ; -- status=guess, src=wikt status=guess, src=wikt
lin concreteness_N = mkN "concretezza" ; -- status=guess
lin concretion_N = mkN "concrezione" feminine ; -- status=guess
lin concretism_N = mkN "concretismo" ; -- status=guess
lin concubinage_N = mkN "concubinaggio" | mkN "concubinario" ; -- status=guess status=guess
lin concubine_N = mkN "concubina" ; -- UWN
lin concupiscence_N = mkN "concupiscenza" ; -- UWN
lin concurrent_A = variants {} ;
lin condemn_V2 = variants {} ; --
lin condemnable_A = mkA "condannabile" | mkA "denunciabile" | mkA "dannabile" ; -- status=guess status=guess status=guess
lin condensate_N = mkN "condensa" ; -- UWN
lin condensation_N = mkN "condensazione" feminine ; -- status=guess
lin condense_V = mkV "condensarsi" ; -- status=guess, src=wikt
lin condense_V2 = mkV2 (mkV "condensarsi") ; -- status=guess, src=wikt
lin condiment_N = mkN "condimento" ; -- status=guess
lin condition_1_N = variants {} ; --
lin condition_2_N = variants {} ; --
lin condition_N = mkN "condizioni" feminine ; -- status=guess
lin condition_V2 = mkV2 (mkV "condizionare") ; -- status=guess, src=wikt
lin conditioning_N = mkN "riscaldamento" ; -- status=guess
lin conditions_N = mkN "tempo" ; -- UWN
lin condolence_N = mkN "condoglianze" ; -- status=guess
lin condom_N = mkN "preservativo" | mkN "profilattico" | mkN "condom" masculine ; -- status=guess status=guess status=guess
lin condominium_N = mkN "condominio" ; -- status=guess
lin condor_N = mkN "condor" masculine ; -- status=guess
lin conduct_N = mkN "comportamento" | mkN "condotta" ; -- status=guess status=guess
lin conduct_V = mkV "comportarsi" ; -- status=guess, src=wikt
lin conduct_V2 = mkV2 (mkV "comportarsi") ; -- status=guess, src=wikt
lin conduction_N = mkN "conducibilità" | mkN "conduttività" | mkN "conduzione" ; -- UWN
lin conductive_A = mkA "conduttivo" ; -- status=guess
lin conductivity_N = mkN "conducibilità" | mkN "conduttività" | mkN "conduzione" ; -- UWN
lin conductor_N = mkN "direttore d'orchestra" ; -- status=guess
lin conduit_N = mkN "condotto" ; -- status=guess
lin cone_N = mkN "cono" ; -- status=guess
lin coney_N = mkN "coniglio" ; -- UWN
lin confab_V = mkV "conferire" ; -- UWN
lin confabulate_V = mkV "conferire" ; -- UWN
lin confection_N = mkN "manipolazione" ; -- UWN
lin confectioner_N = mkN "crema dit pasticceria" ; -- status=guess
lin confectionery_N = mkN "dolciumi" masculine ; -- status=guess
lin confederacy_N = mkN "confederazione" feminine ; -- status=guess
lin confederation_N = mkN "confederazione" feminine ; -- status=guess
lin confer_V = mkV "conferire" ; -- status=guess, src=wikt
lin conference_N = variants {} ; --
lin confess_V = variants {} ; --
lin confess_V2 = variants {} ; --
lin confess_VS = variants {} ; --
lin confession_N = mkN "confessione" feminine ; -- status=guess
lin confessional_N = mkN "confessionale" | mkN "confessionario" ; -- UWN
lin confessor_N = mkN "confessore" ; -- UWN
lin confidantFem_N = mkN "confidente" ; -- UWN
lin confidantMasc_N = mkN "confidente" ; -- UWN
lin confidence_N = mkN "confidenziale" | mkN "riservato" ; -- status=guess status=guess
lin confident_A = mkA "fiducioso" | mkA "sicuro" ; -- status=guess status=guess
lin confidential_A = mkA "confidenziale" ; -- status=guess
lin configuration_N = mkN "configurazione" feminine ; -- status=guess
lin confine_V2 = variants {} ; --
lin confinement_N = mkN "detenzione" ; -- UWN
lin confirm_V2 = mkV2 (mkV "confermare") | mkV2 (mkV "cresimare") ; -- status=guess, src=wikt status=guess, src=wikt
lin confirm_VS = mkVS (mkV "confermare") | mkVS (mkV "cresimare") ; -- status=guess, src=wikt status=guess, src=wikt
lin confirmation_N = mkN "conferma" ; -- status=guess
lin confiscate_V2 = mkV2 (mkV "confiscare") ; -- status=guess, src=wikt
lin confiscation_N = mkN "confisca" ; -- status=guess
lin conflagration_N = mkN "conflagrazione" feminine ; -- status=guess
lin conflict_N = mkN "conflitto" ; -- status=guess
lin conflict_V = mkV "violare" ; -- UWN
lin conform_V = variants {} ; --
lin conform_V2 = variants {} ; --
lin conformable_A = mkA "conforme" ; -- status=guess
lin conformation_N = mkN "conformazione" feminine ; -- status=guess
lin conformist_A = mkA "conformistico" ; -- UWN
lin conformist_N = mkN "ben_pensante" | mkN "benpensante" | mkN "conformista" ; -- UWN
lin conformity_N = mkN "borghesismo" | mkN "conformismo" | mkN "convenzionalismo" | mkN "filisteismo" | mkN "ottemperanza" | mkN "perbenismo" ; -- UWN
lin confront_V2 = variants {} ; --
lin confrontation_N = mkN "scontro" ; -- status=guess
lin confuse_V2 = variants {} ; --
lin confused_A = variants {} ;
lin confusing_A = mkA "che confonde" | mkA "poco chiaro" ; -- status=guess status=guess
lin confusion_N = variants {} ; --
lin confutation_N = mkN "confutazione" | mkN "oppugnazione" | mkN "refutazione" ; -- UWN
lin conga_N = mkN "conga" ; -- UWN
lin congeal_V = mkV "congelare" ; -- status=guess, src=wikt
lin congeal_V2 = mkV2 (mkV "congelare") ; -- status=guess, src=wikt
lin congener_N = mkN "congenere" masculine ; -- status=guess
lin congeneric_A = mkA "congenere" ; -- status=guess
lin congeniality_N = mkN "congenialità" feminine ; -- status=guess
lin congenialness_N = mkN "congenialità" ; -- UWN
lin congenital_A = mkA "congenito" ; -- status=guess
lin conger_N = mkN "grongo" ; -- status=guess
lin congestion_N = mkN "congestione" feminine ; -- status=guess
lin congestive_A = mkA "congestivo" | mkA "congestizio" ; -- UWN
lin congleton_PN = mkPN "Congleton" ; -- status=guess src=geonames
lin conglomeration_N = mkN "conglomerato" | mkN "conglomerazione" feminine ; -- status=guess status=guess
lin congratulate_V2 = variants {} ; --
lin congratulation_N = mkN "congratulazione" feminine ; -- status=guess
lin congratulatory_A = mkA "congratulatorio" ; -- UWN
lin congregation_N = mkN "congregazione" feminine ; -- status=guess
lin congress_N = variants {} ; --
lin congressman_N = mkN "membro del congresso" ; -- status=guess
lin congresswoman_N = mkN "membro_del_Congresso" ; -- UWN
lin conic_A = mkA "conico" ; -- UWN
lin conical_A = mkA "conico" ; -- status=guess
lin conifer_N = mkN "conifera" ; -- status=guess
lin conjectural_A = mkA "congetturale" ; -- status=guess
lin conjecture_N = mkN "congettura" ; -- status=guess
lin conjoin_V = mkV "collegare" ; -- UWN
lin conjugal_A = mkA "coniugale" ; -- UWN
lin conjugate_V = mkV "coniugare" ; -- status=guess, src=wikt
lin conjugate_V2 = mkV2 (mkV "coniugare") ; -- status=guess, src=wikt
lin conjugation_N = mkN "coniugazione" feminine ; -- status=guess
lin conjunction_N = mkN "congiunzione" feminine ; -- status=guess
lin conjunctiva_N = mkN "congiuntiva" ; -- UWN
lin conjunctive_N = mkN "copula" ; -- UWN
lin conjunctivitis_N = mkN "congiuntivite" feminine ; -- status=guess
lin conjure_V = mkV "complottare" | mkV "cospirare" ; -- UWN
lin conjurer_N = mkN "illusionista" masculine | mkN "prestigiatore" masculine ; -- status=guess status=guess
lin conjuror_N = mkN "mago" ; -- UWN
lin conk_V = mkV "basire" | mkV "svenire" | mkV "tramortire" ; -- UWN
lin connate_A = mkA "connato" ; -- status=guess
lin connect_V = variants {} ; --
lin connect_V2 = variants {} ; --
lin connection_N = mkN "connessione" feminine ; -- status=guess
lin connective_N = mkN "tessuto connettivo" ; -- status=guess
lin connivance_N = mkN "connivenza" ; -- UWN
lin connoisseur_N = mkN "intenditore" | mkN "conoscitore" | mkN "esperto" | mkN "connaisseur" masculine ; -- status=guess status=guess status=guess status=guess
lin connotation_N = mkN "connotazione" feminine ; -- status=guess
lin connotative_A = mkA "connotativo" ; -- status=guess
lin connote_V2 = mkV2 (mkV "connotare") ; -- status=guess, src=wikt
lin connubial_A = mkA "coniugale" ; -- UWN
lin conquer_V2 = mkV2 (mkV "conquistare") | mkV2 (sconfiggere_V) | mkV2 (vincere_V) ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin conqueror_N = mkN "conquistatore" ; -- UWN
lin conquest_N = mkN "conquista" ; -- status=guess
lin conquistador_N = mkN "conquistador" ; -- UWN
lin consanguinity_N = mkN "consanguinità" ; -- status=guess
lin conscience_N = mkN "coscienza" ; -- status=guess
lin conscientious_A = mkA "coscienzioso" | mkA "acribia" ; -- status=guess status=guess
lin conscientiousness_N = mkN "coscienziosità" feminine ; -- status=guess
lin conscious_A = mkA "cosciente" ; -- status=guess
lin consciousness_N = mkN "conoscenza" masculine | mkN "coscienza" ; -- status=guess status=guess
lin conscript_N = mkN "coscritto" | mkN "soldato di leva" ; -- status=guess status=guess
lin conscript_V2 = mkV2 (mkV "arruolare") ; -- status=guess, src=wikt
lin conscription_N = mkN "arrolamento" | mkN "arruolamento" | mkN "coscrizione" | mkN "leva" | mkN "naia" | mkN "servizio_di_leva" ; -- UWN
lin consecration_N = mkN "benedizione" | mkN "consacrazione" ; -- UWN
lin consecutive_Adv = mkAdv "consecutivamente" ; -- UWN
lin consensual_A = mkA "consensuale" ; -- status=guess
lin consensus_N = mkN "consenso" ; -- status=guess
lin consent_N = mkN "consenso" ; -- status=guess
lin consent_V = consentire_V ; -- status=guess, src=wikt
lin consent_V2V = mkV2V (consentire_V) ; -- status=guess, src=wikt
lin consequence_N = variants {} ; --
lin consequent_A = variants {} ;
lin conservation_N = variants {} ; --
lin conservatism_N = mkN "conservatorismo" | mkN "oscurantismo" ; -- UWN
lin conservative_1_N = variants {} ; --
lin conservative_2_N = variants {} ; --
lin conservative_A = variants {} ; --
lin conservatoire_N = mkN "conservatorio" ; -- status=guess
lin conservatory_N = mkN "conservatorio" ; -- status=guess
lin conserve_N = mkN "confettura" | mkN "conserva_di_frutta" | mkN "marmellata" ; -- UWN
lin conserve_V2 = mkV2 (mkV "conservare") ; -- status=guess, src=wikt
lin consett_PN = mkPN "Consett" ; -- status=guess src=geonames
lin consider_V = mkV "considerare" ;
lin consider_V2 = mkV2 "considerare" ;
lin consider_V2A = variants {} ; --
lin consider_V2V = variants {} ; --
lin consider_V3 = variants {} ; --
lin consider_VS = mkvVS "considerare" | mkvVS "reputare" | mkvVS "ritenere" | mkvVS "vedere" | mkvVS "volere" ; -- UWN
lin consider_VV = mkVV (mkV "considerare") ;
lin considerable_A = variants {} ; --
lin considerate_A = mkA "premuroso" | mkA "riguardoso" ; -- UWN
lin considerateness_N = mkN "delicatezza" ; -- UWN
lin consideration_N = variants {} ; --
lin considering_Prep = variants {} ; --
lin considering_Subj = variants {} ; --
lin consignment_N = mkN "consegna" | mkN "partita" | mkN "rimessa" ; -- UWN
lin consist_V = consistere_V ; -- status=guess, src=wikt
lin consistence_N = mkN "coerenza" | mkN "consistenza" ; -- UWN
lin consistency_N = mkN "coerenza" | mkN "consistenza" ; -- UWN
lin consistent_A = mkA "coerente" | mkA "congruo" | mkA "lineare" ; -- UWN
lin consistory_N = mkN "concistorio" | mkN "concistoro" ; -- UWN
lin consolable_A = mkA "consolabile" ; -- UWN
lin consolidate_V = variants {} ; --
lin consolidate_V2 = variants {} ; --
lin consolidation_N = mkN "accorpamento" | mkN "integrazione" ; -- UWN
lin consonance_N = mkN "consonanza" ; -- status=guess
lin consonant_A = mkA "consonante" ; -- status=guess
lin consonant_N = mkN "consonante" feminine ; -- status=guess
lin consort_N = mkN "cantoria" ; -- UWN
lin consortium_N = variants {} ; --
lin conspicuous_A = mkA "evidente" | mkA "manifesto" | mkA "ovvio" | mkA "pacifico" | mkA "palmare" | mkA "patente" | mkA "visibile" ; -- UWN
lin conspiracy_N = mkN "cospirazione" feminine ; -- status=guess
lin conspirator_N = mkN "congiurato" | mkN "congiurata" | mkN "cospiratore" | mkN "cospiratrice" | mkN "complottardo" ; -- status=guess status=guess status=guess status=guess status=guess
lin conspiratorial_A = mkA "cospirativo" | mkA "cospiratorio" ; -- status=guess status=guess
lin conspire_V = mkV "complottare" | mkV "cospirare" ; -- UWN
lin constable_N = mkN "appuntato" | mkN "agente" masculine ; -- status=guess status=guess
lin constabulary_N = mkN "polizia" | mkN "questura" ; -- UWN
lin constancy_N = mkN "costanza" | mkN "fermezza" | mkN "fissità" | mkN "immutabilità" | mkN "invariabilità" | mkN "stazionarietà" ; -- UWN
lin constant_A = mkA "costante" ; -- status=guess
lin constant_N = mkN "costante" feminine ; -- status=guess
lin constantan_N = mkN "costantana" ; -- status=guess
lin constellation_N = mkN "costellazione" feminine ; -- status=guess
lin consternation_N = mkN "costernazione" feminine ; -- status=guess
lin constipation_N = mkN "stipsi" | mkN "stitichezza" ; -- status=guess status=guess
lin constituency_N = mkN "collegio_elettorale" ; -- UWN
lin constituent_A = mkA "costituente" ; -- status=guess
lin constituent_N = mkN "elemento" ; -- status=guess
lin constitute_V2 = variants {} ; --
lin constitution_N = mkN "costituzione" feminine ; -- status=guess
lin constitutional_A = variants {} ; --
lin constitutionalism_N = mkN "costituzionalismo" ; -- UWN
lin constrain_V2 = mkV2 (costringere_V) ; -- status=guess, src=wikt
lin constraint_N = mkN "vincolo" ; -- status=guess
lin construct_V2 = mkV2 (mkV "costruire") ; -- status=guess, src=wikt
lin construction_N = variants {} ; --
lin constructive_A = variants {} ; --
lin constructivism_N = mkN "costruttivismo" ; -- status=guess
lin constructor_N = mkN "costruttore" masculine ; -- status=guess
lin construe_V = mkV "decifrare" | mkV "intendere" | mkV "interpretare" ; -- UWN
lin consubstantial_A = mkA "consustanziale" | mkA "consostanziale" ; -- status=guess status=guess
lin consubstantiation_N = mkN "consustanziazione" feminine ; -- status=guess
lin consul_N = mkN "console" ; -- UWN
lin consular_A = mkA "consolare" ; -- UWN
lin consulate_N = mkN "consolato" ; -- status=guess
lin consulship_N = mkN "consolato" ; -- UWN
lin consult_V = mkV "consultare" | mkV "interpellare" | mkV "sentire" ; -- UWN
lin consult_V2 = variants {} ; --
lin consultancy_N = mkN "consulenza" ; -- status=guess
lin consultant_N = mkN "consigliere" | mkN "consulente" ; -- UWN
lin consultation_N = mkN "consultazione" ; -- UWN
lin consume_V = mkV "consumare" ; -- status=guess, src=wikt
lin consume_V2 = mkV2 (mkV "consumare") ; -- status=guess, src=wikt
lin consumer_N = mkN "consumatore" | mkN "consumatrice" feminine ; -- status=guess status=guess
lin consummate_A = mkA "consumato" | mkA "completo" ; -- status=guess status=guess
lin consummate_V2 = mkV2 (mkV "complere") | mkV2 (mkV "completare") ; -- status=guess, src=wikt status=guess, src=wikt
lin consumption_N = variants {} ; --
lin consumptive_N = mkN "tisico" ; -- UWN
lin contact_N = mkN "contatto" ; -- status=guess
lin contact_V2 = mkV2 (mkV "contattare") ; -- status=guess, src=wikt
lin contagion_N = mkN "contagio" ; -- status=guess
lin contagious_A = mkA "contagioso" | mkA "infettivo" ; -- status=guess status=guess
lin contain_V2 = mkV2 (contenere_V) ; -- status=guess, src=wikt
lin container_N = mkN "contenitore" masculine | mkN "recipiente" masculine ; -- status=guess status=guess
lin contaminant_N = mkN "inquinante" | mkN "sostanza_contaminante" ; -- UWN
lin contaminate_V2 = mkV2 (mkV "contaminare") ; -- status=guess, src=wikt
lin contamination_N = mkN "contaminazione" feminine ; -- status=guess
lin contaminative_A = mkA "contaminante" ; -- status=guess
lin contemn_V2 = mkV2 (mkV "disprezzare") | mkV2 (mkV "disdegnare") ; -- status=guess, src=wikt status=guess, src=wikt
lin contemplate_V = variants {} ; --
lin contemplate_V2 = variants {} ; --
lin contemplate_VS = variants {} ; --
lin contemporary_A = mkA "contemporaneo" ; -- status=guess
lin contemporary_N = mkN "contemporaneo" ; -- UWN
lin contempt_N = mkN "disprezzo" ; -- status=guess
lin contend_V = variants {} ; --
lin contend_VS = variants {} ; --
lin contender_N = mkN "agonista" | mkN "antagonista" | mkN "competitore" | mkN "emulo" | mkN "rivale" ; -- UWN
lin content_A = mkA "contento" ; -- status=guess
lin content_N = mkN "contenuto" ; -- status=guess
lin content_V2 = mkV2 (soddisfare_V) ; -- status=guess, src=wikt
lin contention_N = mkN "contesa" | mkN "controversia" | mkN "discussione" | mkN "disputa" | mkN "litigio" | mkN "polemica" | mkN "rissa" ; -- UWN
lin contentious_A = mkA "bellicoso" | mkA "aggressivo" | mkA "provocatore" ; -- status=guess status=guess status=guess
lin contentment_N = mkN "contentezza" ; -- UWN
lin contents_N = mkN "indice" ; -- UWN
lin contest_N = mkN "concorso" ; -- status=guess
lin contest_V = variants {} ; --
lin contest_V2 = variants {} ; --
lin contestable_A = mkA "contrastabile" | mkA "oppugnabile" ; -- status=guess status=guess
lin contestant_N = mkN "concorrente" | mkN "contendente" ; -- UWN
lin context_N = mkN "contesto" ; -- status=guess
lin contextual_A = mkA "contestuale" ; -- UWN
lin contiguity_N = mkN "contiguità" feminine ; -- status=guess
lin contiguous_A = mkA "contiguo" ; -- status=guess
lin continence_N = mkN "moderazione" feminine | mkN "astinenza" | mkN "continenza" ; -- status=guess status=guess status=guess
lin continent_N = mkN "continente" masculine ; -- status=guess
lin continental_A = mkA "continentale" ; -- status=guess
lin contingency_N = mkN "contingenza" ; -- status=guess
lin contingent_N = mkN "contingente" ; -- UWN
lin continual_A = mkA "continuo" ; -- UWN
lin continuance_N = mkN "continuamento" | mkN "continuazione" | mkN "prosecuzione" | mkN "proseguimento" | mkN "prosieguo" ; -- UWN
lin continuation_N = mkN "continuazione" feminine ; -- status=guess
lin continue_V = mkV "continuare" ; -- status=guess, src=wikt
lin continue_V2 = mkV2 (mkV "continuare") ; -- status=guess, src=wikt
lin continue_VV = mkVV (mkV "continuare") ; -- status=guess, src=wikt
lin continue_on_V = advV OP_continue_V OP_on_Adv ; -- guess-p-verb
lin continued_A = variants {} ; --
lin continuing_A = variants {} ; --
lin continuity_N = mkN "continuità" feminine ; -- status=guess
lin continuous_A = mkA "continuo" ; -- status=guess
lin continuum_N = mkN "continuo" ; -- status=guess
lin conto_N = mkN "conto" | mkN "conto_portoghese" ; -- UWN
lin contortion_N = mkN "contorsione" ; -- UWN
lin contortionist_N = mkN "contorsionista" masculine ; -- status=guess
lin contour_N = mkN "contorno" ; -- status=guess
lin contraband_N = mkN "contrabbando" ; -- status=guess
lin contrabass_N = mkN "contrabasso" | mkN "contrabbasso" ; -- UWN
lin contrabassoon_N = mkN "controfagotto" ; -- status=guess
lin contraception_N = mkN "contraccezione" feminine ; -- status=guess
lin contraceptive_N = mkN "anticoncezionale" | mkN "antifecondativo" | mkN "contraccettivo" | mkN "contracettivo" ; -- UWN
lin contract_N = mkN "contratto" ; -- status=guess
lin contract_V = contrarre_V ; -- status=guess, src=wikt
lin contract_V2 = mkV2 (contrarre_V) ; -- status=guess, src=wikt
lin contract_V2V = mkV2V (contrarre_V) ; -- status=guess, src=wikt
lin contractible_A = mkA "contrattile" | mkA "contraibile" ; -- status=guess status=guess
lin contraction_N = variants {} ; --
lin contractor_N = variants {} ; --
lin contractual_A = mkA "contrattuale" | mkA "negoziale" ; -- UWN
lin contracture_N = mkN "contrattura" ; -- status=guess
lin contradict_V2 = mkV2 (mkV "contradire") ; -- status=guess, src=wikt
lin contradiction_N = mkN "contraddizione" feminine ; -- status=guess
lin contradictoriness_N = mkN "contraddittorietà" ; -- UWN
lin contraindication_N = mkN "controindicazione" feminine ; -- status=guess
lin contralto_N = mkN "contralto" ; -- status=guess
lin contraption_N = mkN "aggeggio" | mkN "congegno" | mkN "coso" | mkN "diavoleria" ; -- status=guess status=guess status=guess status=guess
lin contrariwise_Adv = mkAdv "anzi" ; -- UWN
lin contrary_A = mkA "contrario" | mkA "opposto" ; -- status=guess status=guess
lin contrary_N = variants {} ; --
lin contrast_N = variants {} ; --
lin contrast_V = variants {} ; --
lin contrast_V2 = variants {} ; --
lin contravention_N = mkN "bega" | mkN "contesa" | mkN "contestazione" | mkN "contrasto" ; -- UWN
lin contribute_V = mkV "contribuire" ; -- status=guess, src=wikt
lin contribute_V2 = mkV2 (mkV "contribuire") ; -- status=guess, src=wikt
lin contribution_N = mkN "aiuto" | mkN "collaborazione" | mkN "concorso" | mkN "contributo" | mkN "contribuzione" | mkN "parte" ; -- UWN
lin contrition_N = mkN "attrizione" | mkN "pentimento" ; -- UWN
lin contrive_V = mkV "combinare" | mkV "programmare" | mkV "intrigare" | mkV "complottare" | mkV "architettare" | mkV "escogitare" | mkV "inventare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin contrive_V2 = mkV2 (mkV "combinare") | mkV2 (mkV "programmare") | mkV2 (mkV "intrigare") | mkV2 (mkV "complottare") | mkV2 (mkV "architettare") | mkV2 (mkV "escogitare") | mkV2 (mkV "inventare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin control_N = variants {} ; --
lin control_V2 = mkV2 (mkV "controllare") | mkV2 (mkV "influenzare") ; -- status=guess, src=wikt status=guess, src=wikt
lin controllable_A = mkA "dominabile" | mkA "frenabile" | mkA "raffrenabile" ; -- status=guess status=guess status=guess
lin controlled_A = variants {} ; --
lin controller_N = mkN "revisore" masculine ; -- status=guess
lin controversial_A = mkA "controverso" | mkA "discusso" | mkA "polemico" ; -- UWN
lin controversy_N = mkN "controversia" ; -- status=guess
lin contumelious_A = mkA "sprezzante" ; -- status=guess
lin contumely_N = mkN "contumelia" ; -- status=guess
lin contusion_N = mkN "contusione" feminine ; -- status=guess
lin conundrum_N = mkN "rompicapo" ; -- status=guess
lin conurbation_N = mkN "conurbazione" feminine ; -- status=guess
lin convalescent_N = mkN "convalescente" ; -- UWN
lin convection_N = mkN "convezione" feminine ; -- status=guess
lin convector_N = mkN "convettore" ; -- UWN
lin convene_V = mkV "convocare" ; -- UWN
lin convenience_N = variants {} ; --
lin convenient_A = mkA "conveniente" | mkA "comodo" ; -- status=guess status=guess
lin convention_N = mkN "convenzione" feminine ; -- status=guess
lin conventional_A = mkA "convenzionale" ; -- status=guess
lin convergence_N = mkN "convergenza" ; -- status=guess
lin convergent_A = mkA "convergente" ; -- UWN
lin conversation_N = mkN "conversazione" feminine | mkN "dialogo" | mkN "discorso" ; -- status=guess status=guess status=guess
lin converse_A = variants {} ;
lin converse_V = mkV "conversare" ; -- status=guess, src=wikt
lin conversion_N = mkN "conversione" feminine ; -- status=guess
lin convert_N = mkN "convertito" | mkN "neofita" | mkN "neofito" | mkN "proselito" ; -- UWN
lin convert_V = mkV "convertire" ; -- status=guess, src=wikt
lin convert_V2 = mkV2 (mkV "convertire") ; -- status=guess, src=wikt
lin convertibility_N = mkN "convertibilità" | mkN "reversibilità" | mkN "riversibilità" ; -- UWN
lin convertible_N = mkN "marco convertibile" ; -- status=guess
lin convex_A = mkA "convesso" ; -- status=guess
lin convey_V2 = mkV2 (mkV "trasportare") ; -- status=guess, src=wikt
lin conveyance_N = mkN "trasporto" ; -- UWN
lin conveyer_N = mkN "nastro_trasportatore" | mkN "trasportatore" ; -- UWN
lin conveyor_N = mkN "nastro_trasportatore" | mkN "trasportatore" ; -- UWN
lin convict_N = mkN "condannato" | mkN "carcerato" ; -- status=guess status=guess
lin convict_V2 = mkV2 (mkV "condannare") ; -- status=guess, src=wikt
lin conviction_N = mkN "convinzione" feminine ; -- status=guess
lin convince_V2 = mkV2 (convincere_V) ; -- status=guess, src=wikt
lin convince_V2V = mkV2V (convincere_V) ; -- status=guess, src=wikt
lin convincing_A = mkA "convincente" | mkA "persuasibile" | mkA "probante" | mkA "probativo" ; -- UWN
lin convolvulus_N = mkN "convolvolo" ; -- status=guess
lin convoy_N = mkN "convoglio" ; -- status=guess
lin conwy_PN = mkPN "Conwy" ; -- status=guess src=geonames
lin cony_N = mkN "coniglio" ; -- UWN
lin cook_N = mkN "cuoco" | mkN "cuoca" ; -- status=guess status=guess
lin cook_V = cuocere_V ; -- status=guess, src=wikt
lin cook_V2 = mkV2 (cuocere_V) ; -- status=guess, src=wikt
lin cookbook_N = mkN "ricettario" ; -- status=guess
lin cooker_N = mkN "cucina" ; -- UWN
lin cookery_N = mkN "cucina" ; -- status=guess
lin cookham_PN = mkPN "Cookham" ; -- status=guess src=geonames
lin cookie_N = mkN "biscotto" ; -- status=guess
lin cooking_N = mkN "cottura" | mkN "cuocere" ; -- UWN
lin cooky_N = mkN "biscotto" | mkN "biscuit" ; -- UWN
lin cool_A = mkA "termico" | mkA "fresco" | mkA "leggero" ; -- status=guess status=guess status=guess
lin cool_V = variants {} ; --
lin cool_V2 = variants {} ; --
lin coolant_N = mkN "refrigerante" | mkN "refrigeratore" ; -- UWN
lin coolness_N = mkN "freddezza" | mkN "frigidità" ; -- UWN
lin coop_N = mkN "stia" ; -- status=guess
lin cooper_N = mkN "bottaio" ; -- status=guess
lin cooperate_V = mkV "cooperare" ; -- status=guess, src=wikt
lin cooperation_N = mkN "cooperazione" feminine ; -- status=guess
lin cooperative_A = mkA "cooperativo" ; -- status=guess
lin cooperative_N = mkN "cooperativa" ; -- status=guess
lin coordinate_N = mkN "coordinata" ; -- status=guess
lin coordinate_V = mkV "coordinare" ; -- status=guess, src=wikt
lin coordinate_V2 = mkV2 (mkV "coordinare") ; -- status=guess, src=wikt
lin coordination_N = mkN "coordinazione" feminine ; -- status=guess
lin coordinator_N = mkN "coordinatore" ; -- UWN
lin coot_N = mkN "folaga" ; -- status=guess
lin cop_N = mkN "piedipiatti" masculine ; -- status=guess
lin cop_V2 = variants {} ; --
lin copaiba_N = mkN "copaive" feminine ; -- status=guess
lin cope_V = variants {} ; --
lin copeck_N = mkN "copeck" | mkN "copeco" | mkN "copeco_russo" | mkN "kopeck" | mkN "kopek" ; -- UWN
lin copenhagen_PN = mkPN "Copenaghen" ; -- status=guess src=geonames
lin copilot_N = mkN "copilota" ; -- status=guess
lin coping_N = mkN "capezzata" ; -- status=guess
lin copious_A = mkA "copioso" ; -- status=guess
lin coplanar_A = mkA "complanare" ; -- status=guess
lin copper_N = mkN "rame" masculine ; -- status=guess
lin coppersmith_N = mkN "fabbro di rame" ; -- status=guess
lin coppice_N = mkN "bosco ceduo" ; -- status=guess
lin coppull_PN = mkPN "Coppull" ; -- status=guess src=geonames
lin copra_N = mkN "copra" ; -- status=guess
lin copse_N = mkN "bosco ceduo" | mkN "macchia" | mkN "fratta" | mkN "boschetto" ; -- status=guess status=guess status=guess status=guess
lin copula_N = mkN "copula" ; -- status=guess
lin copulate_V = mkV "accoppiarsi" ; -- UWN
lin copulative_N = mkN "copula" ; -- UWN
lin copy_N = mkN "copia" | mkN "replica" ; -- status=guess status=guess
lin copy_V = mkV "copiaincollare" ; -- status=guess, src=wikt
lin copy_V2 = mkV2 (mkV "copiaincollare") ; -- status=guess, src=wikt
lin copycat_N = mkN "copione" | mkN "epigono" | mkN "imitatore" ; -- UWN
lin copying_N = mkN "copiatura" ; -- UWN
lin copyist_N = mkN "amanuense" | mkN "scritturale" | mkN "scrivano" ; -- UWN
lin copyright_N = variants {} ; --
lin copywriter_N = mkN "redattore" masculine ; -- status=guess
lin coral_A = mkA "corallino" | mkA "corallina" ; -- status=guess status=guess
lin coral_N = mkN "corallo" ; -- status=guess
lin corbel_N = mkN "capriata" | mkN "cinto_erniario" | mkN "incavallatura" ; -- UWN
lin corby_PN = mkPN "Corby" ; -- status=guess src=geonames
lin cord_N = variants {} ; --
lin cordial_N = mkN "affabile" | mkN "amichevole" | mkN "cordiale" | mkN "liquore" ; -- UWN
lin cordiality_N = mkN "cordialità" ; -- UWN
lin cordierite_N = mkN "cordierite" feminine ; -- status=guess
lin cordite_N = mkN "cordite" ; -- UWN
lin cordon_N = mkN "cordone" ; -- UWN
lin cordovan_N = mkN "cordovano" ; -- UWN
lin corduroy_N = mkN "fustagno" | mkN "velluto_a_coste" ; -- UWN
lin core_N = mkN "caparra" ; -- status=guess
lin corgi_N = mkN "corgi" masculine ; -- status=guess
lin coriaceous_A = mkA "coriaceo" ; -- status=guess
lin coriander_N = mkN "coriandolo" ; -- status=guess
lin cork_N = mkN "s. m. sughero" ; -- status=guess
lin cork_PN = mkPN "Cork" ; -- status=guess src=geonames
lin corkscrew_N = mkN "cavatappi" masculine ; -- status=guess
lin corm_N = mkN "cormo" ; -- status=guess
lin cormorant_N = mkN "cormorano" ; -- status=guess
lin corn_N = mkN "callo" | mkN "durone" masculine ; -- status=guess status=guess
lin corncob_N = mkN "pannocchia" ; -- status=guess
lin cornea_N = mkN "cornea" ; -- status=guess
lin corneal_A = mkA "corneale" ; -- UWN
lin cornelian_N = mkN "cornalina" | mkN "corniola" ; -- UWN
lin corner_N = mkN "angolo" ; -- status=guess
lin cornet_N = mkN "cono di cialda" ; -- status=guess
lin cornflour_N = mkN "maizena" ; -- UWN
lin cornflower_N = mkN "fiordaliso" ; -- status=guess
lin cornice_N = mkN "cornice" feminine | mkN "cornicione" masculine ; -- status=guess status=guess
lin cornstarch_N = mkN "maizena" ; -- UWN
lin cornucopia_N = mkN "abbondanza" | mkN "profusione" | mkN "prosperità" | mkN "ricchezza" ; -- UWN
lin cornwall_PN = mkPN "Cornwall" ; -- status=guess src=geonames
lin corny_A = mkA "sdolcinato" ; -- status=guess
lin corolla_N = mkN "corolla" ; -- status=guess
lin corollary_N = mkN "corollario" ; -- status=guess
lin corona_N = mkN "corona" ; -- status=guess
lin coronary_A = mkA "coronario" ; -- UWN
lin coronary_N = mkN "arteria coronaria" ; -- status=guess
lin coroneted_A = mkA "titolato" ; -- UWN
lin corporal_A = mkA "corporale" ; -- status=guess
lin corporal_N = mkN "caporale" masculine ; -- status=guess
lin corporate_A = variants {} ; --
lin corporation_N = mkN "società" feminine | mkN "corporazione" feminine ; -- status=guess status=guess
lin corps_N = variants {} ; --
lin corps_de_ballet_N = mkN "balletto" | mkN "corpo_di_ballo" ; -- UWN
lin corps_diplomatique_N = mkN "corpo_diplomatico" ; -- UWN
lin corpse_N = variants {} ; --
lin corpulence_N = mkN "corpulenza" ; -- UWN
lin corpus_N = mkN "corpus" masculine ; -- status=guess
lin corpuscle_N = mkN "corpuzzo" | mkN "corpuscolo" ; -- status=guess status=guess
lin corpuscular_A = mkA "corpuscolare" ; -- status=guess
lin corral_V2 = mkV2 (mkV "riunire") ; -- status=guess, src=wikt
lin correct_A = L.correct_A ;
lin correct_V = mkV "correggere" ; -- status=guess, src=wikt
lin correct_V2 = mkV2 (mkV "correggere") ; -- status=guess, src=wikt
lin correct_VS = mkVS (mkV "correggere") ; -- status=guess, src=wikt
lin correction_1_N = mkN "correzione" feminine ; -- status=guess
lin correction_2_N = mkN "correzione" feminine ; -- status=guess
lin correctitude_N = mkN "convenienza" ; -- UWN
lin correctness_N = mkN "aggiustatezza" | mkN "correttezza" | mkN "esattezza" ; -- UWN
lin correlation_N = mkN "correlazione" feminine ; -- status=guess
lin correspond_V = variants {} ; --
lin correspond_V2 = variants {} ; --
lin correspondence_N = mkN "corrispondenza" ; -- status=guess
lin correspondent_N = mkN "gazzettiere" | mkN "giornalista" | mkN "pubblicista" | mkN "redattore" ; -- UWN
lin corresponding_A = variants {} ; --
lin corridor_N = mkN "corridoio aereo" ; -- status=guess
lin corrie_N = mkN "circo" ; -- status=guess
lin corrigenda_N = mkN "errata_corrige" ; -- UWN
lin corrigendum_N = mkN "refuso" ; -- status=guess
lin corrigible_A = mkA "correggibile" ; -- UWN
lin corroboration_N = mkN "avvaloramento" | mkN "corroborazione" ; -- UWN
lin corrosion_N = mkN "corrosione" feminine ; -- status=guess
lin corrosive_A = mkA "caustico" | mkA "corrosivo" ; -- UWN
lin corrosive_N = mkN "corrosivo" ; -- UWN
lin corrupt_A = mkA "corrotto" ; -- status=guess
lin corrupt_V = corrompere_V ; -- status=guess, src=wikt
lin corrupt_V2 = mkV2 (corrompere_V) ; -- status=guess, src=wikt
lin corruptibility_N = mkN "corruttibilità" ; -- UWN
lin corruptible_A = mkA "corruttibile" | mkA "corrompibile" ; -- status=guess status=guess
lin corruption_N = mkN "corruzione" feminine ; -- status=guess
lin corsage_N = mkN "bouquet" ; -- UWN
lin corsair_N = mkN "corsale" | mkN "corsaro" | mkN "pirata" ; -- UWN
lin corset_N = mkN "corsetto" ; -- status=guess
lin corsham_PN = mkPN "Corsham" ; -- status=guess src=geonames
lin cortege_1_N = variants {} ; ---- sense to be split
lin cortege_2_N = variants {} ; ---- sense to be split
lin cortical_A = mkA "corticale" ; -- UWN
lin corticosteroid_N = mkN "corticosteroide" masculine ; -- status=guess
lin corticosterone_N = mkN "corticosterone" ; -- UWN
lin cortisone_N = mkN "cortisone" masculine ; -- status=guess
lin corundom_N = mkN "corindone" ; -- UWN
lin corundum_N = mkN "corindone" masculine ; -- status=guess
lin corunna_PN = mkPN "Corunna" ; -- status=guess src=geonames
lin corvette_N = mkN "corvetta" ; -- status=guess
lin corymb_N = mkN "corimbo" ; -- UWN
lin cosecant_N = mkN "cosecante" ; -- UWN
lin cosenza_PN = mkPN "Cosenza" ; -- status=guess src=geonames
lin cosignatory_A = mkA "cofirmatario" ; -- status=guess
lin cosignatory_N = mkN "cofirmatario" ; -- status=guess
lin cosine_N = mkN "coseno" ; -- status=guess
lin cosmetic_N = mkN "belletto" | mkN "cosmetico" ; -- UWN
lin cosmetician_N = mkN "cosmetista" | mkN "estetista" ; -- UWN
lin cosmetologist_N = mkN "visagista" ; -- UWN
lin cosmic_A = mkA "cosmico" ; -- status=guess
lin cosmogony_N = mkN "cosmogonia" ; -- status=guess
lin cosmology_N = mkN "cosmologia" ; -- status=guess
lin cosmonaut_N = mkN "cosmonauta" ; -- status=guess
lin cosmopolitan_A = mkA "cosmopolita" ; -- status=guess
lin cosmopolitan_N = mkN "apolide" | mkN "cosmopolita" ; -- UWN
lin cosmos_N = mkN "cosmo" ; -- status=guess
lin cosmotron_N = mkN "cosmotrone" masculine ; -- status=guess
lin cost_N = mkN "costo" | mkN "spesa" ; -- status=guess status=guess
lin cost_V = mkV "costare" ; -- status=guess, src=wikt
lin cost_V2 = mkV2 (mkV "costare") ; -- status=guess, src=wikt
lin cost_up_V2 = prepV2 OP_cost_V OP_up_Prep ; -- guess-p-verb
lin costa_N = mkN "costola" ; -- UWN
lin costal_A = mkA "costale" ; -- UWN
lin costly_A = variants {} ; --
lin costume_N = variants {} ; --
lin costumier_N = mkN "costumista" | mkN "figurinista" ; -- UWN
lin cosy_A = mkA "accogliente" ; -- status=guess
lin cosy_N = mkN "copriteiera" ; -- UWN
lin cot_N = mkN "greppia" | mkN "presepe" masculine ; -- status=guess status=guess
lin cotangent_N = mkN "cotangente" ; -- UWN
lin coterie_N = mkN "cenacolo" | mkN "chiesuola" | mkN "combriccola" | mkN "consorteria" | mkN "conventicola" | mkN "cricca" ; -- UWN
lin cottage_N = mkN "casolare" masculine | mkN "rustico" ; -- status=guess status=guess
lin cotton_N = mkN "cotone" masculine ; -- status=guess
lin cotyledon_N = mkN "cotiledone" | mkN "embriofillo" ; -- UWN
lin couch_N = mkN "canapè" masculine | mkN "divano" | mkN "sofà" masculine ; -- status=guess status=guess status=guess
lin couch_V = reflV (mkV "sdraiare") ; -- status=guess, src=wikt
lin couch_V2 = mkV2 (mkV "sdraiare") ; -- status=guess, src=wikt
lin couchette_N = mkN "cuccetta" ; -- UWN
lin cough_N = mkN "tosse" masculine ; -- status=guess
lin cough_V = mkV "tossire" ; -- status=guess, src=wikt
lin coulisse_N = mkN "coulisse" ; -- UWN
lin coulomb_N = mkN "coulomb" ; -- status=guess
lin council_N = mkN "consiglio" ; -- status=guess
lin councillor_N = mkN "assessore" | mkN "consigliere" | mkN "consultore" ; -- UWN
lin councillorship_N = mkN "assessorato" ; -- UWN
lin counsel_N = mkN "direzione" ; -- UWN
lin counselling_N = variants {} ; --
lin counsellor_N = mkN "avvocato" ; -- UWN
lin count_1_N = mkN "conte" masculine ; -- status=guess
lin count_2_N = mkN "conte" masculine ; -- status=guess
lin count_V = mkV "contare" ; -- status=guess, src=wikt
lin count_V2 = L.count_V2 ;
lin count_against_V2 = prepV2 OP_count_V OP_against_Prep ; -- guess-p-verb
lin count_among_V2 = prepV2 OP_count_V OP_among_Prep ; -- guess-p-verb
lin count_down_V2 = prepV2 OP_count_V OP_down_Prep ; -- guess-p-verb
lin count_for_V2 = prepV2 OP_count_V OP_for_Prep ; -- guess-p-verb
lin count_in_V2 = prepV2 OP_count_V OP_in_Prep ; -- guess-p-verb
lin count_off_V2 = prepV2 OP_count_V OP_off_Prep ; -- guess-p-verb
lin count_on_V2 = prepV2 OP_count_V OP_on_Prep ; -- guess-p-verb
lin count_out_V2 = prepV2 OP_count_V OP_out_Prep ; -- guess-p-verb
lin count_towards_V2 = prepV2 OP_count_V OP_towards_Prep ; -- guess-p-verb
lin count_up_V2 = prepV2 OP_count_V OP_up_Prep ; -- guess-p-verb
lin count_upon_V2 = prepV2 OP_count_V OP_upon_Prep ; -- guess-p-verb
lin countable_A = mkA "enumerabile" ; -- status=guess
lin countdown_N = mkN "conto alla rovescia" ; -- status=guess
lin countenance_N = mkN "sembianza" | mkN "apparenza" | mkN "espressione" feminine ; -- status=guess status=guess status=guess
lin counter_Adv = mkAdv "contro" ; -- status=guess
lin counter_N = mkN "contrattacco" ; -- status=guess
lin counter_V = contraddire_V ; -- status=guess, src=wikt
lin counter_VS = mkVS (contraddire_V) ; -- status=guess, src=wikt
lin counterbore_N = mkN "accecatoio" | mkN "accecatore" | mkN "acciecatore" | mkN "allargatore" ; -- UWN
lin counterclaim_N = mkN "controreclamo" | mkN "controrichiesta" ; -- status=guess status=guess
lin counterclockwise_Adv = mkAdv "in_senso_antiorario" ; -- UWN
lin counterculture_N = mkN "controcultura" ; -- UWN
lin countercurrent_N = mkN "corrente contraria" ; -- status=guess
lin counterespionage_N = mkN "controspionaggio" ; -- status=guess
lin counterfactual_A = mkA "controfattuale" ; -- status=guess
lin counterfeit_A = mkA "contraffatto" | mkA "falso" ;
lin counterfeit_N = mkN "contraffazione" feminine | mkN "falso" | mkN "imitazione" feminine ; -- status=guess status=guess status=guess
lin counterfeit_V2 = mkV2 (contraffare_V) | mkV2 (mkV "falsificare") ; -- status=guess, src=wikt status=guess, src=wikt
lin counterfeiter_N = mkN "contraffattore" | mkN "falsario" ; -- status=guess status=guess
lin counterfoil_N = mkN "matrice" feminine ; -- status=guess
lin counterintelligence_N = mkN "controspionaggio" ; -- status=guess
lin countermand_N = mkN "contrordine" masculine ; -- status=guess
lin countermarch_N = mkN "contromarcia" ; -- status=guess
lin countermeasure_N = mkN "controazione" ; -- UWN
lin countermine_N = mkN "contromina" ; -- UWN
lin counteroffensive_N = mkN "contro-offensiva" | mkN "controffensiva" ; -- UWN
lin counterpane_N = mkN "copriletto" ; -- status=guess
lin counterpart_N = variants {} ; --
lin counterpoint_N = mkN "contrappunto" ; -- status=guess
lin counterpoise_N = mkN "contrappeso" ; -- UWN
lin counterproposal_N = mkN "controproposta" ; -- UWN
lin counter_revolution_N = mkN "controrivoluzione" ; -- UWN
lin counter_revolutionist_N = mkN "controrivoluzionario" ; -- UWN
lin countersign_N = mkN "controfirma" ; -- UWN
lin countersign_V2 = mkV2 (mkV "controfirmare") ; -- status=guess, src=wikt
lin countersignature_N = mkN "controfirma" ; -- UWN
lin countersink_N = mkN "accecatoio" | mkN "accecatore" | mkN "acciecatore" | mkN "allargatore" ; -- UWN
lin countertenor_N = mkN "controtenore" ; -- status=guess
lin countervail_V = mkV "equilibrare" | mkV "neutralizzare" ; -- UWN
lin counterweight_N = mkN "contrappeso" ; -- UWN
lin countess_N = mkN "contessa" ; -- status=guess
lin countless_A = mkA "innumerevole" | mkA "incalcolabile" | mkA "innumerabile" ; -- status=guess status=guess status=guess
lin country_N = L.country_N ;
lin countryman_N = mkN "compatriota" | mkN "compatriotta" | mkN "connazionale" ; -- UWN
lin countryside_N = mkN "campagna" ; -- status=guess
lin county_N = mkN "contea" ; -- status=guess
lin coup_N = mkN "colpo di stato" ; -- status=guess
lin coup_d'etat_N = mkN "colpo_di_colpo" | mkN "golpe" | mkN "putsch" ; -- UWN
lin coup_de_grace_N = mkN "colpo_di_grazia" ; -- UWN
lin couple_N = mkN "paio" ; -- status=guess
lin couple_V = mkV "agganciare" ; -- status=guess, src=wikt
lin couple_V2 = mkV2 (mkV "agganciare") ; -- status=guess, src=wikt
lin coupling_N = mkN "accoppiamento" | mkN "copula" ; -- UWN
lin coupon_N = mkN "coupon" ;
lin courage_N = mkN "coraggio" ; -- status=guess
lin courageous_A = mkA "coraggioso" ; -- status=guess
lin courier_N = mkN "corriere" masculine ; -- status=guess
lin course_N = mkN "corso" | mkN "rotta" ;
lin course_V = scorrere_V ; -- status=guess, src=wikt
lin course_V2 = mkV2 (scorrere_V) ; -- status=guess, src=wikt
lin court_1_N = mkN "corte" ; -- UWN
lin court_2_N = variants {} ; --
lin court_N = mkN "cortile" masculine ; -- status=guess
lin courteous_A = mkA "cortese" ; -- status=guess
lin courtesan_N = mkN "prostituta" ; -- status=guess
lin courtesy_N = mkN "cortesia" ; -- status=guess
lin courthouse_N = mkN "palazzo di giustizia" ; -- status=guess
lin courtliness_N = mkN "cortigianeria" ; -- status=guess
lin courtroom_N = mkN "aula" | mkN "tribunale" ; -- UWN
lin courtyard_N = mkN "cortile" masculine | mkN "corte" feminine ; -- status=guess status=guess
lin cousin_N = L.cousin_N ;
lin couture_N = mkN "couture" ; -- UWN
lin couturier_N = mkN "couturier" | mkN "disegnatore_di_moda" | mkN "modellista" | mkN "stilista" ; -- UWN
lin covalent_A = mkA "covalente" ; -- status=guess
lin covariance_N = mkN "covarianza" ; -- status=guess
lin cove_N = mkN "calanca" ; -- status=guess
lin covenant_N = mkN "patto" | mkN "accordo solenne" | mkN "contratto" ; -- status=guess status=guess status=guess
lin coventry_PN = mkPN "Coventry" ; -- status=guess src=geonames
lin cover_N = mkN "pane e coperta" | mkN "coperto" ; -- status=guess status=guess
lin cover_V2 = mkV2 (mkV "coprire") ; -- status=guess, src=wikt
lin cover_for_V2 = prepV2 (lin V OP_cover_V2) OP_for_Prep ; -- guess-p-verb
lin cover_up_V2 = prepV2 (lin V OP_cover_V2) OP_up_Prep ; -- guess-p-verb
lin coverage_N = variants {} ; --
lin coverall_N = mkN "tuta" ; -- status=guess
lin covert_N = mkN "copertura" | mkN "schermo" ; -- UWN
lin covet_V2 = mkV2 (mkV "concupire") | mkV2 (mkV "bramare") ; -- status=guess, src=wikt status=guess, src=wikt
lin covetousness_N = mkN "avarizia" | mkN "bramosia" | mkN "bramosità" | mkN "cupidigia" | mkN "cupidità" | mkN "libidine" ; -- UWN
lin covey_N = mkN "tizio" | mkN "tipo" ; -- status=guess status=guess
lin cow_N = L.cow_N ;
lin coward_N = mkN "codardo" | mkN "pusillanime" | mkN "vigliacco" | mkN "vile" | mkN "coniglio" ; -- status=guess status=guess status=guess status=guess status=guess
lin cowardice_N = mkN "codardia" | mkN "viltà" feminine | mkN "pusillanimità" | mkN "vigliaccheria" ; -- status=guess status=guess status=guess status=guess
lin cowardly_A = mkA "codardo" | mkA "pusillanime" | mkA "vigliacco" | mkA "vile" ; -- status=guess status=guess status=guess status=guess
lin cowbarn_N = mkN "stalla" | mkN "vaccheria" ; -- UWN
lin cowbell_N = mkN "campanaccio" ; -- status=guess
lin cowboy_N = mkN "mandriano" | mkN "vaccaio" | mkN "vaccaro" ; -- status=guess status=guess status=guess
lin cowcatcher_N = mkN "cacciapietre" ; -- UWN
lin cowdenbeath_PN = mkPN "Cowdenbeath" ; -- status=guess src=geonames
lin cower_V = mkV "strisciare" ; -- UWN
lin cowes_PN = mkPN "Cowes" ; -- status=guess src=geonames
lin cowgirl_N = mkN "mandriana" ; -- status=guess
lin cowhand_N = mkN "boaro" | mkN "bovaro" | mkN "cappellone" | mkN "vaccaio" | mkN "vaccaro" ; -- UWN
lin cowherd_N = mkN "vaccaio" | mkN "vaccaia" | mkN "boaro" | mkN "boara" | mkN "bovaro" | mkN "bovara" ; -- status=guess status=guess status=guess status=guess status=guess status=guess
lin cowhouse_N = mkN "stalla" | mkN "vaccheria" ; -- UWN
lin cowl_N = mkN "cappuccio" ; -- status=guess
lin cowling_N = mkN "cappa" | mkN "cofano" | mkN "kappa" ; -- UWN
lin cowman_N = mkN "boaro" | mkN "bovaro" | mkN "cappellone" | mkN "vaccaio" | mkN "vaccaro" ; -- UWN
lin coworker_N = mkN "collega" masculine ; -- status=guess
lin cowpox_N = mkN "vaiolo_bovino" ; -- UWN
lin cowshed_N = mkN "stalla" | mkN "vaccheria" ; -- UWN
lin cowskin_N = mkN "vacchetta" ; -- UWN
lin cox_N = mkN "timoniere" ; -- UWN
lin coxcomb_N = mkN "cresta" ; -- UWN
lin coxswain_N = mkN "timoniere" ; -- UWN
lin coy_A = mkA "schivo" ; -- status=guess
lin coyote_N = mkN "coyote" | mkN "coiote" masculine ; -- status=guess status=guess
lin coypu_N = mkN "nutria" ; -- status=guess
lin cozy_A = mkA "accogliente" ; -- status=guess
lin crab_N = mkN "granchio" ; -- status=guess
lin crabgrass_N = mkN "sanguinella" ; -- UWN
lin crack_N = mkN "stecca" ; -- status=guess
lin crack_V2 = mkV2 (mkV "stonare") ; -- status=guess, src=wikt
lin crack_down_N = mkN "giro di vite" | mkN "misura restrittiva" | mkN "repressione" feminine ; -- status=guess status=guess status=guess
lin cracking_N = mkN "rottura" ; -- UWN
lin crackle_N = mkN "maiolica_cavillata" ; -- UWN
lin crackle_V = mkV "crepitare" ; -- status=guess, src=wikt
lin crackleware_N = mkN "maiolica_cavillata" ; -- UWN
lin cradle_N = mkN "crosta lattea" ; -- status=guess
lin cradle_V2 = mkV2 (mkV "cullare") ; -- status=guess, src=wikt
lin craft_N = variants {} ; --
lin craftsman_N = mkN "artéfice" ; -- status=guess
lin craftsmanship_N = mkN "abilità" | mkN "arte" | mkN "bravura" | mkN "maestria" | mkN "perizia" ; -- UWN
lin crafty_A = mkA "furbo" ; -- status=guess
lin crag_N = mkN "balza" | mkN "balzo" | mkN "rupe" ; -- UWN
lin cragsman_N = mkN "rocciatore" ; -- UWN
lin cramlington_PN = mkPN "Cramlington" ; -- status=guess src=geonames
lin cramp_N = mkN "graffa" | mkN "grappa" ; -- UWN
lin crampon_N = mkN "rampone" ; -- UWN
lin cranberry_N = mkN "ossicocco" | mkN "mirtillo palustre" ; -- status=guess status=guess
lin crane_N = mkN "gru" feminine ; -- status=guess
lin crane_V = mkV "allungare" ; -- status=guess, src=wikt
lin crane_V2 = mkV2 (mkV "allungare") ; -- status=guess, src=wikt
lin cranial_A = mkA "cranico" ; -- status=guess
lin craniology_N = mkN "craniologia" ; -- status=guess
lin craniometer_N = mkN "cefalometro" | mkN "craniometro" ; -- UWN
lin craniotomy_N = mkN "craniotomia" ; -- UWN
lin cranium_N = mkN "cranio" ; -- status=guess
lin crankshaft_N = mkN "albero_a_gomiti" ; -- UWN
lin crap_N = mkN "schifezza" | mkN "escrementi" | mkN "merda" | mkN "cacca" ; -- status=guess status=guess status=guess status=guess
lin crape_N = mkN "crespo" ; -- UWN
lin crash_N = mkN "blocco" ; -- status=guess
lin crash_V = mkV "imbucarsi" ; -- status=guess, src=wikt
lin crash_dive_V = variants {} ; -- guess-p-verb
lin crash_land_V = variants {} ; -- guess-p-verb
lin crash_land_V2 = variants {} ; -- guess-p-verb
lin crash_out_V = advV OP_crash_V OP_out_Adv ; -- guess-p-verb
lin crass_A = mkA "grossolano" ; -- status=guess
lin crate_N = mkN "cesto" ; -- status=guess
lin crater_N = mkN "cratere" masculine ; -- status=guess
lin crave_V = mkV "desiderare" ; -- status=guess, src=wikt
lin crave_V2 = mkV2 (mkV "desiderare") ; -- status=guess, src=wikt
lin craving_N = mkN "brama" ; -- status=guess
lin craw_N = mkN "gozzo" ; -- UWN
lin crawfish_N = mkN "aragosta" ; -- UWN
lin crawl_N = mkN "crawl" ; -- status=guess
lin crawl_V = mkV "strisciare" ; -- status=guess, src=wikt
lin crawley_PN = mkPN "Crawley" ; -- status=guess src=geonames
lin crayfish_N = mkN "aragosta" | mkN "gambero" | mkN "gambero di fiume" ; -- status=guess status=guess status=guess
lin crayon_N = mkN "pastello" ; -- status=guess
lin crazy_A = mkA "pazzo" ; -- status=guess
lin creak_N = mkN "cric" masculine ; -- status=guess
lin cream_N = mkN "crema" masculine ; -- status=guess
lin creamery_N = mkN "burrificio" | mkN "caseificio" | mkN "caseificio" | mkN "casone" | mkN "latteria" ; -- UWN
lin creaminess_N = mkN "cremosità" ; -- UWN
lin creamy_A = mkA "cremoso" | mkA "cremosa" ; -- status=guess status=guess
lin crease_V = mkV "raggrinzare" | mkV "raggrinzire" | mkV "sgualcirsi" | mkV "spiegazzarsi" | mkV "stazzonare" | mkV "stropicciarsi" ; -- UWN
lin create_V = mkV "creare" ; -- status=guess, src=wikt
lin create_V2 = mkV2 (mkV "creare") ; -- status=guess, src=wikt
lin creatine_N = mkN "creatinchinasi" ; -- status=guess
lin creation_N = mkN "creazione" feminine ; -- status=guess
lin creative_A = mkA "creativo" ; -- status=guess
lin creativeness_N = mkN "creatività" ; -- UWN
lin creativity_N = mkN "creatività" ; -- UWN
lin creator_N = mkN "creatore" masculine ; -- status=guess
lin creature_N = mkN "creatura" ; -- status=guess
lin credence_N = mkN "credenza" ; -- UWN
lin credenza_N = mkN "credenza" ; -- UWN
lin credibility_N = mkN "attendibilità" | mkN "credibilità" ; -- UWN
lin credit_N = mkN "credito" ; -- status=guess
lin credit_V2 = variants {} ; --
lin creditor_N = mkN "creditore" masculine ; -- status=guess
lin credulity_N = mkN "credulità" | mkN "dabbenaggine" ; -- UWN
lin credulousness_N = mkN "credulità" | mkN "dabbenaggine" | mkN "minchioneria" ; -- UWN
lin creed_N = mkN "credo" ; -- status=guess
lin creek_N = mkN "ruscello" ; -- status=guess
lin creep_N = mkN "scollamento" ; -- status=guess
lin creep_V = variants {} ; --
lin creeper_N = mkN "girello" ; -- status=guess
lin cremate_V2 = mkV2 (mkV "cremare") ; -- status=guess, src=wikt
lin cremation_N = mkN "cremazione" feminine ; -- status=guess
lin crenate_A = mkA "crenato" ; -- status=guess
lin creole_N = mkN "creolo" ; -- status=guess
lin creosol_N = mkN "creosolo" ; -- status=guess
lin crepe_1_N = variants {} ; ---- sense to be split
lin crepe_2_N = variants {} ; ---- sense to be split
lin crepitate_V = mkV "crepitare" | mkV "scoppiettare" | mkV "sfrigolare" ; -- UWN
lin crepuscular_A = mkA "crepuscolare" | mkA "crepuscolare" ; -- status=guess status=guess
lin cres_PN = mkPN "Cherso" ; -- status=guess src=geonames
lin crescendo_N = mkN "crescendo" ; -- status=guess
lin crescent_N = mkN "cornetto" ; -- status=guess
lin cress_N = mkN "crescione" masculine ; -- status=guess
lin crest_N = mkN "cresta" ; -- status=guess
lin creswell_PN = mkPN "Creswell" ; -- status=guess src=geonames
lin cretinism_N = mkN "cretinismo" ; -- UWN
lin cretinous_A = mkA "cretino" | mkA "cretina" ; -- status=guess status=guess
lin cretonne_N = mkN "cretonne" ; -- UWN
lin crevasse_N = mkN "crepaccio" ; -- status=guess
lin crew_N = mkN "folla" | mkN "gente" feminine ; -- status=guess status=guess
lin crewe_PN = mkPN "Crewe" ; -- status=guess src=geonames
lin crib_N = mkN "greppia" | mkN "mangiatoia" ; -- status=guess status=guess
lin crick_N = mkN "torcicollo" ;
lin cricket_N = mkN "fair play" ; -- status=guess
lin crieff_PN = mkPN "Crieff" ; -- status=guess src=geonames
lin crime_N = mkN "crimine" | mkN "delitto" ; -- status=guess status=guess
lin criminal_A = mkA "criminale" | mkA "delittuoso" ; -- status=guess status=guess
lin criminal_N = mkN "criminale" ; -- status=guess
lin criminalism_N = mkN "criminalità" | mkN "criminosità" | mkN "delinquenza" ; -- UWN
lin criminological_A = mkA "criminologico" ; -- status=guess
lin criminologist_N = mkN "criminologo" | mkN "criminologa" ; -- status=guess status=guess
lin criminology_N = mkN "criminologia" ; -- status=guess
lin crimson_A = mkA "cremisi" ; -- status=guess
lin crimson_N = mkN "cremisi" ; -- status=guess
lin crimson_V = mkV "arrossire" | mkV "avvampare" | mkV "imporporarsi" | mkV "vergognare" ; -- UWN
lin cringle_N = mkN "occhiello" ; -- UWN
lin crinkle_N = mkN "acciaccatura" | mkN "grinza" | mkN "ruga" | mkN "solco" ; -- UWN
lin crinkle_V = mkV "raggrinzare" | mkV "raggrinzire" | mkV "sgualcirsi" | mkV "spiegazzarsi" | mkV "stazzonare" | mkV "stropicciarsi" ; -- UWN
lin crisis_N = mkN "crisi" feminine ; -- status=guess
lin crisp_V = mkV "abbrustolire" | mkV "tostare" ; -- UWN
lin crisscross_Adv = mkAdv "incrociarsi" | mkAdv "intersecarsi" ; -- status=guess status=guess
lin crisscross_N = mkN "croce" | mkN "croce_di_S'Andrea" ; -- UWN
lin criterion_N = mkN "criterio" ; -- status=guess
lin critic_N = mkN "critico" ; -- UWN
lin critical_1_A = variants {} ; --
lin critical_2_A = variants {} ; --
lin critical_A = variants {} ; --
lin criticality_N = mkN "criticità" ; -- UWN
lin criticism_N = mkN "critica" ; -- status=guess
lin criticize_V = variants {} ; --
lin criticize_V2 = variants {} ; --
lin critique_N = variants {} ; --
lin croak_N = mkN "gracidamento" | mkN "gracidio" ; -- UWN
lin croak_V = mkV "crepare" ; -- status=guess, src=wikt
lin croak_V2 = mkV2 (mkV "crepare") ; -- status=guess, src=wikt
lin crochet_N = mkN "uncinetto" ; -- status=guess
lin crock_N = mkN "catorcio" | mkN "rottame" masculine ; -- status=guess status=guess
lin crockery_N = mkN "coccio" ; -- status=guess
lin crocodile_N = mkN "coccodrillo" ; -- status=guess
lin crocus_N = mkN "croco" ; -- status=guess
lin croft_N = mkN "podere" masculine | mkN "campicello" | mkN "campetto" ; -- status=guess status=guess status=guess
lin cromer_PN = mkPN "Cromer" ; -- status=guess src=geonames
lin cromlech_N = mkN "dolmen" ; -- UWN
lin crone_N = mkN "befana" masculine ; -- status=guess
lin cronyism_N = mkN "nepotismo" ; -- status=guess
lin crook_PN = mkPN "Crook" ; -- status=guess src=geonames
lin croon_V = mkV "cantarellare" | mkV "canterellare" | mkV "canticchiare" ; -- UWN
lin crooner_N = mkN "cantante_melodico" ; -- UWN
lin crop_N = mkN "cerchio nel grano" ; -- status=guess
lin crop_V = variants {} ; --
lin crop_V2 = variants {} ; --
lin cropper_N = mkN "mezzadro" ; -- UWN
lin croquet_N = mkN "mazza da croquet" ; -- status=guess
lin croquette_N = mkN "crocchetta" ; -- status=guess
lin crosby_PN = mkPN "Crosby" ; -- status=guess src=geonames
lin crosier_N = mkN "pastorale" ; -- UWN
lin cross_A = mkA "irritato" | mkA "arrabbiato" ; -- status=guess status=guess
lin cross_N = mkN "incrocio" ; -- status=guess
lin cross_V = mkV "intralciare" | mkV "ostacolare" ; -- status=guess, src=wikt status=guess, src=wikt
lin cross_V2 = mkV2 (mkV "intralciare") | mkV2 (mkV "ostacolare") ; -- status=guess, src=wikt status=guess, src=wikt
lin cross_examine_V2 = variants {} ; -- guess-p-verb
lin cross_fertilize_V2 = variants {} ; -- guess-p-verb
lin cross_index_V2 = variants {} ; -- guess-p-verb
lin cross_off_V2 = prepV2 OP_cross_V OP_off_Prep ; -- guess-p-verb
lin cross_out_V2 = prepV2 OP_cross_V OP_out_Prep ; -- guess-p-verb
lin cross_question_V2 = variants {} ; -- guess-p-verb
lin cross_up_V2 = prepV2 OP_cross_V OP_up_Prep ; -- guess-p-verb
lin crossbeam_N = mkN "traversa" ; -- UWN
lin crossbill_N = mkN "crociere" ; -- status=guess
lin crossbow_N = mkN "balestra" ; -- status=guess
lin crossbreed_N = mkN "ibrido" | mkN "incrocio" ; -- UWN
lin crosseyed_A = mkA "strabico" ; -- status=guess
lin crosshead_N = mkN "testacroce" | mkN "testa a croce" ; -- status=guess status=guess
lin crossing_N = variants {} ; --
lin crossjack_N = mkN "mezzana" ; -- UWN
lin crosspatch_N = mkN "neurastenico" | mkN "nevrastenico" ; -- UWN
lin crossroad_N = mkN "attraversamento" | mkN "bivio" | mkN "crocevia" | mkN "crocicchio" | mkN "incrocio" ; -- UWN
lin crosswind_N = mkN "vento_di_traverso" ; -- UWN
lin crosswise_Adv = mkAdv "trasversalmente" ; -- UWN
lin crossword_N = mkN "cruciverba" | mkN "parole crociate" ; -- status=guess status=guess
lin crotch_N = mkN "cavallo" feminine ; -- status=guess
lin crotchet_N = mkN "semiminima" ; -- status=guess
lin crouch_V = mkV "accovacciarsi" ; -- status=guess, src=wikt
lin croup_N = mkN "groppa" ; -- UWN
lin crouton_N = mkN "crostino" ; -- status=guess
lin crow_N = mkN "cornacchia" | mkN "corvo" ; -- status=guess status=guess
lin crowbar_N = mkN "piede di porco" ; -- status=guess
lin crowborough_PN = mkPN "Crowborough" ; -- status=guess src=geonames
lin crowd_N = mkN "folla" | mkN "turba" ; -- status=guess status=guess
lin crowd_V = mkV "affollarsi" | mkV "ammassarsi" | mkV "ammucchiarsi" | mkV "gremire" | mkV "raccogliersi" ; -- UWN
lin crowd_V2 = variants {} ; --
lin crowding_N = mkN "affollamento" | mkN "assiepamento" ; -- UWN
lin crown_N = mkN "corona" ; -- status=guess
lin crown_V2 = mkV2 (mkV "incoronare") ; -- status=guess, src=wikt
lin crowthorne_PN = mkPN "Crowthorne" ; -- status=guess src=geonames
lin croydon_PN = mkPN "Croydon" ; -- status=guess src=geonames
lin crozier_N = mkN "pastorale" ; -- UWN
lin crucial_A = mkA "cruciforme" ; -- status=guess
lin crucible_N = mkN "crogiolo" ; -- status=guess
lin crucifer_N = mkN "crucifera" ; -- status=guess
lin crucifix_N = mkN "crocifisso" | mkN "crucifisso" | mkN "crocefisso" | mkN "croce" feminine ; -- status=guess status=guess status=guess status=guess
lin crucifixion_N = mkN "crocifissione" feminine ; -- status=guess
lin cruciform_A = mkA "crociato" | mkA "cruciforme" ; -- status=guess status=guess
lin crucify_V2 = mkV2 (crocifiggere_V) | mkV2 (mkV "crocefiggere") ; -- status=guess, src=wikt status=guess, src=wikt
lin crude_A = mkA "greggio" | mkA "grezzo" ; -- status=guess status=guess
lin cruel_A = mkA "crudele" ; -- status=guess
lin cruelty_N = mkN "crudeltà" feminine ; -- status=guess
lin cruet_N = mkN "ampolla" ; -- status=guess
lin cruise_N = mkN "crociera" ; -- status=guess
lin cruiser_N = mkN "incrociatore" feminine ; -- status=guess
lin crumb_N = mkN "impasto" ; -- status=guess
lin crumble_V = mkV "sgretolarsi" | mkV "crollare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin crumble_V2 = mkV2 (mkV "sgretolarsi") | mkV2 (mkV "crollare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin crumbliness_N = mkN "friabilità" ; -- UWN
lin crumple_V = mkV "raggrinzare" | mkV "raggrinzire" | mkV "sgualcirsi" | mkV "spiegazzarsi" | mkV "stazzonare" | mkV "stropicciarsi" ; -- UWN
lin crunch_V = mkV "masticare" ; -- status=guess, src=wikt
lin crunch_V2 = mkV2 (mkV "masticare") ; -- status=guess, src=wikt
lin crural_A = mkA "crurale" ; -- UWN
lin crusade_N = mkN "crociata" ; -- status=guess
lin crusader_N = mkN "crociato" ; -- status=guess
lin crush_N = mkN "cotta" ; -- status=guess
lin crush_V = mkV (mkV "prendersi") "una cotta" ; -- status=guess, src=wikt
lin crush_V2 = mkV2 (mkV (mkV "prendersi") "una cotta") ; -- status=guess, src=wikt
lin crusher_N = mkN "frantoio" | mkN "frantumatore" | mkN "granitrice" | mkN "granulatore" | mkN "pistrino" ; -- UWN
lin crust_N = mkN "crosta" ; -- status=guess
lin crustacean_N = mkN "crostaceo" ; -- status=guess
lin crusty_A = mkA "burbero" ; -- UWN
lin crutch_N = mkN "stampella" | mkN "gruccia" ; -- status=guess status=guess
lin crux_N = mkN "punto cruciale" ; -- status=guess
lin cry_N = mkN "urlo" ; -- status=guess
lin cry_V = mkV "gridare" | mkV "urlare" | mkV "gridare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin cry_V2 = mkV2 (mkV "gridare") | mkV2 (mkV "urlare") | mkV2 (mkV "gridare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin cry_off_V2 = prepV2 OP_cry_V OP_off_Prep ; -- guess-p-verb
lin cry_out_V = advV OP_cry_V OP_out_Adv ; -- guess-p-verb
lin crybaby_N = mkN "borbottone" | mkN "brontolone" | mkN "frignone" | mkN "gnaulone" | mkN "mormoratore" | mkN "piagnone" | mkN "piagnucolone" ; -- UWN
lin crying_N = mkN "lacrimazione" | mkN "lagrimazione" | mkN "pianto" ; -- UWN
lin cryoanesthesia_N = mkN "crioanestesia" ; -- UWN
lin cryogenic_A = mkA "criogenico" | mkA "criogeno" ; -- UWN
lin cryolite_N = mkN "criolite" feminine ; -- status=guess
lin cryoscope_N = mkN "crioscopio" ; -- status=guess
lin cryosurgery_N = mkN "criochirurgia" ; -- UWN
lin crypt_N = mkN "cripta" ; -- status=guess
lin cryptogamic_A = mkA "crittogamico" ; -- UWN
lin cryptogram_N = mkN "crittogramma" ; -- UWN
lin cryptography_N = mkN "crittografia" ; -- status=guess
lin crystal_N = mkN "cristallo" ; -- status=guess
lin crystalline_A = mkA "cristallino" ; -- status=guess
lin crystallization_N = mkN "cristallizzazione" feminine ; -- status=guess
lin crystallography_N = mkN "cristallografia" ; -- UWN
lin cub_N = mkN "cucciolo" | mkN "for terms specific to any particular animal" | mkN "see bear cub" | mkN "fox cub" | mkN "etc" ; -- status=guess status=guess status=guess status=guess status=guess
lin cuba_PN = mkPN "Cuba" ; -- status=guess src=geonames
lin cubby_N = mkN "casella" ; -- UWN
lin cubbyhole_N = mkN "casella" ; -- UWN
lin cube_N = mkN "cubo" ; -- status=guess
lin cube_V2 = mkV2 (mkV (mkV "elevare") "al cubo") ;
lin cubic_A = mkA "cubo" ; -- status=guess
lin cubism_N = mkN "cubismo" ; -- status=guess
lin cubist_A = mkA "cubista" ; -- UWN
lin cubist_N = mkN "cubista" ; -- UWN
lin cubit_N = mkN "cubito" ; -- UWN
lin cubitus_N = mkN "cubito" ; -- UWN
lin cuboid_N = mkN "parallelepipedo_rettangolo" ; -- UWN
lin cuckold_N = mkN "cornuto" | mkN "becco" ; -- status=guess status=guess
lin cuckold_V2 = mkV2 (mkV (I.fare_V) "le corna") ; -- status=guess, src=wikt
lin cuckoo_N = mkN "orologio a cucù" ; -- status=guess
lin cucumber_N = mkN "cetriolo" ; -- status=guess
lin cucurbit_N = mkN "cucurbita" ; -- UWN
lin cud_N = mkN "bolo" ; -- status=guess
lin cuddle_N = mkN "coccola" ; -- status=guess
lin cuddle_V = mkV "cullare" ; -- status=guess, src=wikt
lin cuddle_V2 = mkV2 (mkV "cullare") ; -- status=guess, src=wikt
lin cudgel_N = mkN "mazza" ; -- UWN
lin cudworth_PN = mkPN "Cudworth" ; -- status=guess src=geonames
lin cue_N = mkN "segnale" masculine ; -- status=guess
lin cuff_N = mkN "polsino" | mkN "polso" ; -- UWN
lin cuffley_PN = mkPN "Cuffley" ; -- status=guess src=geonames
lin cuirass_N = mkN "corazza" ; -- UWN
lin cuisine_N = mkN "cucina" | mkN "culinaria" ; -- status=guess status=guess
lin cuisse_N = mkN "cosciale" ; -- UWN
lin culcheth_PN = mkPN "Culcheth" ; -- status=guess src=geonames
lin cull_V2 = mkV2 (cogliere_V) ; -- status=guess, src=wikt
lin culm_N = mkN "culmo" ; -- UWN
lin culminate_V = mkV "culminare" ; -- status=guess, src=wikt
lin culminate_V2 = mkV2 (mkV "culminare") ; -- status=guess, src=wikt
lin culmination_N = mkN "compimento" | mkN "compimento" | mkN "completamento" | mkN "coronamento" | mkN "ultimazione" ; -- UWN
lin culotte_N = mkN "gonna_pantalone" ; -- UWN
lin culprit_N = mkN "colpevole" | mkN "reo" ; -- status=guess status=guess
lin cult_N = mkN "culto" ; -- status=guess
lin cultivable_A = mkA "coltivabile" ; -- status=guess
lin cultivate_V2 = mkV2 (mkV "coltivare") ; -- status=guess, src=wikt
lin cultivation_N = mkN "coltura" ; -- status=guess
lin cultural_A = mkA "culturale" ; -- status=guess
lin culture_N = mkN "cultura" ; -- status=guess
lin cumberland_PN = mkPN "Cumberland" ; -- status=guess src=geonames
lin cumbernauld_PN = mkPN "Cumbernauld" ; -- status=guess src=geonames
lin cumbersome_A = mkA "ingombrante" ; -- status=guess
lin cumin_N = mkN "cumino" ; -- status=guess
lin cummerbund_N = mkN "fascia di seta" | mkN "fascia di smoking" ; -- status=guess status=guess
lin cumnock_PN = mkPN "Cumnock" ; -- status=guess src=geonames
lin cumulative_A = mkA "cumulato" | mkA "cumulata" ; -- status=guess status=guess
lin cumulonimbus_N = mkN "cumulo-nembo" | mkN "cumulonembo" ; -- UWN
lin cumulus_N = mkN "cumulo" ; -- status=guess
lin cuneiform_A = mkA "cuneiforme" ; -- UWN
lin cuneiform_N = mkN "cuneiforme" ; -- UWN
lin cunnilingus_N = mkN "cunnilinguo" | mkN "cunnilingus" masculine ; -- status=guess status=guess
lin cunning_A = mkA "ingegnoso" ; -- status=guess
lin cunning_N = mkN "furberia" | mkN "furbizia" ; -- status=guess status=guess
lin cunt_N = mkN "fregna" | mkN "figa" | mkN "fica" ;
lin cup_N = mkN "coppiere" masculine ; -- status=guess
lin cupar_PN = mkPN "Cupar" ; -- status=guess src=geonames
lin cup_bearer_N = mkN "coppiere" | mkN "pincerna" ; -- UWN
lin cupboard_N = mkN "armadio" | mkN "credenza" ; -- status=guess status=guess
lin cupful_N = mkN "tazza" ; -- UWN
lin cupidity_N = mkN "cupidigia" | mkN "cupidità" feminine ; -- status=guess status=guess
lin cupola_N = mkN "cupola" ; -- status=guess
lin cuppa_N = mkN "tazza_di_tè" ; -- UWN
lin cupric_A = mkA "rameico" ; -- status=guess
lin cuprite_N = mkN "cuprite" ; -- status=guess
lin cupro_nickel_N = mkN "cupronichel" masculine ; -- status=guess
lin cupule_N = mkN "mallo" ; -- status=guess
lin cur_N = mkN "bastardo" ; -- UWN
lin curability_N = mkN "curabilità" | mkN "guaribilità" | mkN "sanabilità" ; -- UWN
lin curable_A = mkA "curabile" ; -- status=guess
lin curate_N = mkN "curato" | mkN "ministro" | mkN "rettore" ; -- UWN
lin curative_A = mkA "curativo" ; -- status=guess
lin curb_N = mkN "freno" ; -- UWN
lin curbstone_N = mkN "paracarro" ; -- UWN
lin curd_N = mkN "coagulo" ; -- status=guess
lin curdle_V = mkV "coagularsi" ; -- UWN
lin curdling_N = mkN "accagliatura" | mkN "coagulamento" | mkN "coagulazione" ; -- UWN
lin cure_N = variants {} ; --
lin cure_V = mkV "curare" ; -- status=guess, src=wikt
lin cure_V2 = mkV2 (mkV "curare") ; -- status=guess, src=wikt
lin curettage_N = mkN "curettage" masculine ; -- status=guess
lin curfew_N = mkN "coprifuoco" ; -- status=guess
lin curio_N = mkN "curiosità" | mkN "rarità" ; -- UWN
lin curiosity_N = mkN "curiosità" ; -- status=guess
lin curious_A = mkA "curioso" ; -- status=guess
lin curiousness_N = mkN "singolarità" ; -- UWN
lin curitiba_PN = mkPN "Curitiba" ; -- status=guess src=geonames
lin curium_N = mkN "curio" ; -- status=guess
lin curl_N = mkN "ricciolo" | mkN "rotore" masculine ; -- status=guess status=guess
lin curl_V = variants {} ; --
lin curl_up_V = mkV "accartocciarsi" | mkV "raggomitolarsi" | mkV "rannicchiarsi" ; -- UWN
lin curler_N = mkN "arricciacapelli" | mkN "bigodino" | mkN "bigodì" | mkN "diavoletto" | mkN "papillote" ; -- UWN
lin curlew_N = mkN "chiurlo" ; -- UWN
lin curling_N = mkN "curling" ; -- UWN
lin curly_A = mkA "riccio" | mkA "ricciuto" ; -- UWN
lin curmudgeon_N = mkN "burbero" | mkN "musone" masculine ; -- status=guess status=guess
lin currant_N = mkN "ribes" ; -- status=guess
lin currency_N = mkN "valuta" ; -- status=guess
lin current_A = mkA "corrente" | mkA "attuale" ; -- status=guess status=guess
lin current_1_N = mkN "corrente" feminine ; -- status=guess
lin current_2_N = mkN "corrente" feminine ; -- status=guess
lin currentness_N = mkN "attualità" ; -- UWN
lin curricular_A = mkA "curricolare" ; -- UWN
lin curriculum_N = mkN "curriculum vitae" ; -- status=guess
lin currie_PN = mkPN "Currie" ; -- status=guess src=geonames
lin curry_N = mkN "curry" masculine ; -- status=guess
lin currycomb_N = mkN "brusca" | mkN "striglia" ; -- UWN
lin curse_N = mkN "maledizione" feminine | mkN "maleficio" ; -- status=guess status=guess
lin curse_V = maledire_V ; -- status=guess, src=wikt
lin curse_V2 = mkV2 (maledire_V) ; -- status=guess, src=wikt
lin cursive_A = mkA "corsivo" ; -- status=guess
lin cursor_N = mkN "cursore" masculine ; -- status=guess
lin cursorial_A = mkA "corridore" ; -- UWN
lin curst_A = mkA "maledetto" ; -- UWN
lin curt_A = mkA "sbrigativo" ; -- status=guess
lin curtailment_N = mkN "decurtazione" ; -- UWN
lin curtain_N = mkN "tenda" | mkN "tappezzeria" | mkN "drappo" | mkN "drappeggio" | mkN "tendina" ; -- status=guess status=guess status=guess status=guess status=guess
lin curtness_N = mkN "asciuttezza" | mkN "bruschezza" | mkN "secchezza" ; -- UWN
lin curtsey_N = mkN "riverenza" ; -- status=guess
lin curtsey_V = mkV (I.fare_V) "la riverenza" ; -- status=guess, src=wikt
lin curtsy_N = mkN "reverenza" | mkN "riverenza" ; -- UWN
lin curvaceousness_N = mkN "voluttuosità" ; -- UWN
lin curve_N = mkN "curva" ; -- status=guess
lin curve_V = mkV "curvare" ; -- status=guess, src=wikt
lin curve_V2 = mkV2 (mkV "curvare") ; -- status=guess, src=wikt
lin curvet_N = mkN "falcata" ; -- UWN
lin cuscus_N = mkN "cusco" ; -- status=guess
lin cushion_N = mkN "sponda" ; -- status=guess
lin cuspidor_N = mkN "padellina" | mkN "sputacchiera" ; -- UWN
lin cuss_N = mkN "bestemmia" | mkN "eresia" | mkN "giaculatoria" | mkN "imprecazione" | mkN "maledizione" | mkN "moccolo" | mkN "parolaccia" | mkN "sozzeria" ; -- UWN
lin custard_N = mkN "crema" ; -- UWN
lin custody_N = mkN "mani" ; -- UWN
lin custom_N = mkN "dogana" ; -- status=guess
lin customary_A = mkA "consueto" ; -- UWN
lin customerFem_N = variants {} ; ---- sense to be split
lin customerMasc_N = mkN "avventore" | mkN "cliente" | mkN "committente" ; -- UWN
lin customize_V2 = mkV2 (mkV "customizzare") ; -- status=guess, src=wikt
lin customs_N = mkN "dogana" ; -- status=guess
lin cut_N = mkN "taglio" ; -- status=guess
lin cut_V = mkV "alzare" ; -- status=guess, src=wikt
lin cut_V2 = L.cut_V2 ;
lin cut_across_V2 = prepV2 OP_cut_V OP_across_Prep ; -- guess-p-verb
lin cut_back_V2 = mkV2 (advV OP_cut_V OP_back_Adv ) ; -- guess-p-verb
lin cut_back_on_V2 = prepV2 (advV OP_cut_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_down_V = advV OP_cut_V OP_down_Adv ; -- guess-p-verb
lin cut_down_V2 = prepV2 OP_cut_V OP_down_Prep ; -- guess-p-verb
lin cut_down_on_V2 = prepV2 (advV OP_cut_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_in_V = advV OP_cut_V OP_in_Adv ; -- guess-p-verb
lin cut_in_V2 = prepV2 OP_cut_V OP_in_Prep ; -- guess-p-verb
lin cut_in_on_V2 = prepV2 (advV OP_cut_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_it_out_V2 = variants {} ; -- guess-p-verb
lin cut_off_V = mkV "smettere" ; -- UWN
lin cut_off_V2 = prepV2 OP_cut_V OP_off_Prep ; -- guess-p-verb
lin cut_out_V = advV OP_cut_V OP_out_Adv ; -- guess-p-verb
lin cut_out_V2 = prepV2 OP_cut_V OP_out_Prep ; -- guess-p-verb
lin cut_out_on_V2 = prepV2 (advV OP_cut_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_up_V = advV OP_cut_V OP_up_Adv ; -- guess-p-verb
lin cut_up_V2 = prepV2 OP_cut_V OP_up_Prep ; -- guess-p-verb
lin cutaneous_A = mkA "cutaneo" ; -- status=guess
lin cutaway_N = mkN "ritaglio" ; -- status=guess
lin cutch_N = mkN "catecù" ; -- UWN
lin cute_A = mkA "carino" ; -- status=guess
lin cuteness_N = mkN "grazia" | mkN "leggiadria" ; -- UWN
lin cutin_N = mkN "cutina" ; -- status=guess
lin cutlery_N = mkN "coltelleria" | mkN "posate" ; -- status=guess status=guess
lin cutlet_N = mkN "costoletta" ; -- status=guess
lin cutpurse_N = mkN "borsaiolo" | mkN "borseggiatore" | mkN "scippatore" | mkN "tagliaborse" ; -- UWN
lin cutter_N = mkN "tagliatrice" ; -- UWN
lin cutting_N = mkN "talea" ; -- status=guess
lin cuttingly_Adv = mkAdv "mordacemente" ; -- UWN
lin cuttlefish_N = mkN "seppia" ; -- status=guess
lin cutworm_N = mkN "agrotide" ; -- UWN
lin cwmbran_PN = mkPN "Cwmbran" ; -- status=guess src=geonames
lin cyanide_N = mkN "cianuro" ; -- status=guess
lin cyanogen_N = mkN "cianogeno" ; -- UWN
lin cyanosis_N = mkN "cianosi" ; -- UWN
lin cybernetic_A = mkA "cibernetico" ; -- UWN
lin cybernetics_N = mkN "cibernetica" ; -- status=guess
lin cyborg_N = mkN "cyborg" ; -- status=guess
lin cyclamen_N = mkN "ciclamino" ; -- status=guess
lin cycle_N = mkN "ciclo" ; -- status=guess
lin cyclic_A = mkA "ciclico" ; -- status=guess
lin cyclicity_N = mkN "ciclicità" ; -- UWN
lin cycling_N = mkN "ciclismo" ; -- status=guess
lin cyclist_N = mkN "ciclista" masculine ; -- status=guess
lin cyclohexanol_N = mkN "cicloesanolo" ; -- status=guess
lin cycloid_N = mkN "cicloide" feminine ; -- status=guess
lin cyclone_N = mkN "ciclone" ; -- status=guess
lin cyclonic_A = mkA "ciclonico" ; -- status=guess
lin cyclopaedia_N = mkN "enciclopedia" ; -- UWN
lin cyclopia_N = mkN "ciclopia" | mkN "ciclopismo" ; -- UWN
lin cyclopropane_N = mkN "ciclopropano" ; -- status=guess
lin cyclops_N = mkN "ciclope" masculine ; -- status=guess
lin cyclothymia_N = mkN "ciclotimia" ; -- UWN
lin cyclotron_N = mkN "ciclotrone" masculine ; -- status=guess
lin cyder_N = mkN "sidro" ; -- UWN
lin cygnet_N = mkN "cigno giovane" ; -- status=guess
lin cylinder_N = mkN "cilindro" ; -- status=guess
lin cylindrical_A = mkA "cilindrico" ; -- status=guess
lin cyma_N = mkN "cimasa" | mkN "gola" ; -- UWN
lin cymbal_N = mkN "cembalo" ; -- status=guess
lin cynic_N = mkN "cinico" ; -- status=guess
lin cynical_A = mkA "cinico" ; -- status=guess
lin cynicism_N = mkN "cinismo" ; -- UWN
lin cynodont_N = mkN "cinodonto" ; -- status=guess
lin cynosure_N = mkN "tramontana" | mkN "guida" ; -- status=guess status=guess
lin cypher_V = mkV "calcolare" | mkV "computare" | mkV "conteggiare" ; -- UWN
lin cypress_N = mkN "cipresso" ; -- status=guess
lin cyprinid_N = mkN "ciprinide" ; -- UWN
lin cyprus_PN = mkPN "Cipro" ; -- status=guess src=geonames
lin cyril_PN = mkPN "Cyril" ; -- status=guess src=geonames
lin cyst_N = mkN "ciste or cisti" ; -- status=guess
lin cystic_A = mkA "cistico" ; -- status=guess
lin cystitis_N = mkN "cistite" feminine ; -- status=guess
lin cytochrome_N = mkN "citocromo" ; -- status=guess
lin cytogenetic_A = mkA "citogenetico" ; -- UWN
lin cytokine_N = mkN "citochina" ; -- status=guess
lin cytological_A = mkA "citologico" ; -- UWN
lin cytology_N = mkN "citologia" ; -- status=guess
lin cytopenia_N = mkN "citopenia" ; -- status=guess
lin cytoplasm_N = mkN "citoplasma" masculine ; -- status=guess
lin cytoplasmic_A = mkA "citoplasmatico" ; -- status=guess
lin cytosine_N = mkN "citosina" ; -- status=guess
lin cytoskeleton_N = mkN "citoscheletro" ; -- status=guess
lin cytostome_N = mkN "citostoma" ; -- UWN
lin cytotoxic_A = mkA "citotossico" ; -- UWN
lin czarina_N = mkN "zarina" ; -- UWN
lin czarist_A = mkA "zarista" ; -- UWN
lin dabble_V = mkV "sguazzare" ; -- status=guess, src=wikt
lin dabble_V2 = mkV2 (mkV "sguazzare") ; -- status=guess, src=wikt
lin dabchick_N = mkN "tuffetto" ; -- status=guess
lin dacha_N = mkN "dacia" ; -- status=guess
lin dachshund_N = mkN "bassotto tedesco" ; -- status=guess
lin dacite_N = mkN "dacite" feminine ; -- status=guess
lin dactyl_N = mkN "dattilo" ; -- status=guess
lin dactylic_A = mkA "dattilico" ; -- UWN
lin dad_N = mkN "papà" masculine | mkN "babbo" | mkN "pà" masculine ; -- status=guess status=guess status=guess
lin dada_N = mkN "dadaismo" ; -- UWN
lin daddy_N = mkN "papà" masculine | mkN "babbo" ; -- status=guess status=guess
lin daffodil_N = mkN "narciso" ; -- status=guess
lin dagger_N = mkN "daga" | mkN "pugnale" | mkN "stiletto" | mkN "misericordia" ; -- status=guess status=guess status=guess status=guess
lin dahlia_N = mkN "dalia" ; -- status=guess
lin daily_A = mkA "quotidiano" | mkA "giornaliero" ; -- status=guess status=guess
lin daily_Adv = mkAdv "quotidianamente" | mkAdv "giornalmente" | mkAdv "ogni giorno" | mkAdv "tutti i giorni" ; -- status=guess status=guess status=guess status=guess
lin daily_N = mkN "quotidiano" ; -- status=guess
lin dainty_N = mkN "bocconcino" | mkN "boccone" | mkN "ghiottoneria" | mkN "golosità" | mkN "leccornia" | mkN "mangiarino" | mkN "manicaretto" | mkN "manna" | mkN "squisitezza" ; -- UWN
lin dairy_N = mkN "alimentari" masculine ; -- status=guess
lin dairyman_N = mkN "caciaio" | mkN "casaro" ; -- UWN
lin dais_N = mkN "pergamo" | mkN "podio" | mkN "predella" | mkN "pulpito" ; -- UWN
lin daisy_N = mkN "pratolina" | mkN "margheritina" ; -- status=guess status=guess
lin dakar_PN = mkPN "Dakar" ; -- status=guess src=geonames
lin dalasi_N = mkN "dalasi" | mkN "dalasi_gambiano" ; -- UWN
lin dale_N = mkN "convalle" ; -- UWN
lin dalkeith_PN = mkPN "Dalkeith" ; -- status=guess src=geonames
lin dallas_PN = mkPN "Dallas" ; -- status=guess src=geonames
lin dallier_N = mkN "acchiappamosche" | mkN "bighellone" | mkN "chiappamosche" | mkN "dondolone" | mkN "fannullone" | mkN "flâneur" | mkN "fuggifatica" | mkN "fuggifatiche" | mkN "gingillino" | mkN "gingillone" | mkN "girandolone" | mkN "girellone" | mkN "scansafatica" ; -- UWN
lin dally_V = mkV "trastullarsi" ; -- status=guess, src=wikt
lin dalmatian_N = mkN "dalmata" ; -- UWN
lin dalry_PN = mkPN "Dalry" ; -- status=guess src=geonames
lin dalton_PN = mkPN "Dalton" ; -- status=guess src=geonames
lin dam_N = mkN "argine" masculine | mkN "diga" ; -- status=guess status=guess
lin dam_V2 = mkV2 (mkV "imbrigliare") ; -- status=guess, src=wikt
lin damage_N = mkN "danno" ; -- status=guess
lin damage_V2 = mkV2 (mkV "danneggiare") | mkV2 (mkV "rovinare") | mkV2 (mkV "macchiare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin damages_N = mkN "compensazione" | mkN "indennità" | mkN "indennizzo" | mkN "rifusione" | mkN "risarcimento" ; -- UWN
lin damaging_A = variants {} ; --
lin damascus_PN = mkPN "Damasco" ; -- status=guess src=geonames
lin damask_N = mkN "damasco" ; -- status=guess
lin dammit_Interj = mkInterj "merda" | mkInterj "cazzo" | mkInterj "dannazione" | mkInterj "cavolo" | mkInterj "cribbio" ; -- status=guess status=guess status=guess status=guess status=guess
lin damn_Interj = mkInterj "maledizione" ;
lin damn_N = mkN "maledire" ; ----
lin damn_V2 = mkV2 (mkV "dannare") ; -- status=guess, src=wikt
lin damnation_N = mkN "dannazione" feminine ; -- status=guess
lin damp_A = mkA "umidità" | mkA "umido" ; -- status=guess status=guess
lin damp_N = mkN "grisù" ; -- status=guess
lin damp_V = mkV "smorzare" | mkV "soffocare" | mkV "rallentare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin damp_V2 = mkV2 (mkV "smorzare") | mkV2 (mkV "soffocare") | mkV2 (mkV "rallentare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin dampen_V = mkV "bagnare" | mkV "inumidire" | mkV "umettare" ; -- UWN
lin dampish_A = mkA "umido" ; -- UWN
lin dampness_N = mkN "umidità" | mkN "umido" ; -- UWN
lin damsel_N = mkN "damigella" | mkN "donzella" ; -- UWN
lin dance_N = mkN "ballo" | mkN "danza" ; -- status=guess status=guess
lin dance_V = mkV "ballare" | mkV "danzare" ; -- status=guess, src=wikt status=guess, src=wikt
lin dance_V2 = mkV2 (mkV "ballare") | mkV2 (mkV "danzare") ; -- status=guess, src=wikt status=guess, src=wikt
lin dancer_N = mkN "ballerino" | mkN "ballerina" | mkN "danzatore" | mkN "danzatrice" feminine ; -- status=guess status=guess status=guess status=guess
lin dancing_N = mkN "ballo" | mkN "danza" ; -- UWN
lin dandelion_N = mkN "soffione" | mkN "dente di leone" ; -- status=guess status=guess
lin dander_N = mkN "forfora" ; -- status=guess
lin dandruff_N = mkN "forfora" ; -- status=guess
lin dandy_N = mkN "iolla" ; -- UWN
lin danish_A = mkA "danese" ;
lin danger_N = mkN "pericolo" ; -- status=guess
lin dangerous_A = mkA "pericoloso" | mkA "pericolosa" ; -- status=guess status=guess
lin dangle_V = mkV "penzolare" ; -- status=guess, src=wikt
lin dangle_V2 = mkV2 (mkV "penzolare") ; -- status=guess, src=wikt
lin danishFem_N = variants {} ; ---- sense to be split
lin danishMasc_N = variants {} ; ---- sense to be split
lin daphne_PN = mkPN "Daphne" ; -- status=guess src=geonames
lin darby_PN = mkPN "Darby" ; -- status=guess src=geonames
lin dare_N = mkN "ardire" | mkN "sfida" ; -- UWN
lin dare_V2 = mkV2 (mkV "osare") ; -- status=guess, src=wikt
lin dare_VV = mkVV (mkV "osare") ; -- status=guess, src=wikt
lin daredevil_A = mkA "scavezzacollo" ; -- status=guess
lin darfield_PN = mkPN "Darfield" ; -- status=guess src=geonames
lin daringly_Adv = mkAdv "ardimentosamente" ; -- UWN
lin dark_A = mkA "scuro" | mkA "oscuro" | mkA "fosco" | mkA "tetro" ; -- status=guess status=guess status=guess status=guess
lin dark_N = mkN "oscurità" feminine | mkN "tenebra" ; -- status=guess status=guess
lin darkness_N = mkN "oscurità" feminine ; -- status=guess
lin darkroom_N = mkN "camera oscura" ; -- status=guess
lin darling_N = mkN "tesoro" | mkN "amore" masculine ; -- status=guess status=guess
lin darlington_PN = mkPN "Darlington" ; -- status=guess src=geonames
lin darmstadt_PN = mkPN "Darmstadt" ; -- status=guess src=geonames
lin darmstadtium_N = mkN "darmstadtio" ; -- status=guess
lin darn_N = mkN "accomodatura" | mkN "rammendo" ; -- UWN
lin darn_V = mkV "raccenciare" | mkV "rammendare" | mkV "rappezzare" | mkV "rattoppare" | mkV "ricucire" | mkV "rimendare" ; -- UWN
lin darning_N = mkN "rammendatura" | mkN "rammendo" | mkN "rappezzatura" | mkN "ripezzatura" ; -- UWN
lin dartford_PN = mkPN "Dartford" ; -- status=guess src=geonames
lin dartmouth_PN = mkPN "Dartmouth" ; -- status=guess src=geonames
lin darts_N = mkN "freccette" ; -- UWN
lin darwen_PN = mkPN "Darwen" ; -- status=guess src=geonames
lin dash_V = variants {} ; --
lin dashboard_N = mkN "cruscotto" ; -- status=guess
lin data_N = mkN "dato" ; -- status=guess
lin database_N = mkN "database" | mkN "base di dati" ; -- status=guess status=guess
lin datable_A = mkA "databile" ; -- UWN
lin date_1_N = variants {} ; --
lin date_3_N = variants {} ; --
lin date_7_N = mkN "dattero" ; -- UWN
lin date_N = variants {} ; --
lin date_V = mkV "datare" ; -- status=guess, src=wikt
lin date_V2 = mkV2 (mkV "datare") ; -- status=guess, src=wikt
lin dative_N = mkN "caso dativo" ; -- status=guess
lin datum_N = mkN "dato" ; -- UWN
lin daub_N = mkN "crosta" ; -- status=guess
lin dauber_N = mkN "imbianchino" | mkN "imbrattatele" ; -- UWN
lin daughter_N = mkN "figlia" ; -- status=guess
lin dauntless_A = mkA "audace" ; -- UWN
lin dauntlessness_N = mkN "intrepidezza" ; -- UWN
lin dauphin_N = mkN "delfino" ; -- UWN
lin daventry_PN = mkPN "Daventry" ; -- status=guess src=geonames
lin david_PN = mkPN "David" ; -- status=guess src=geonames
lin davit_N = mkN "gru" feminine ; -- status=guess
lin dawdle_V = mkV "bighellonare" ; -- status=guess, src=wikt
lin dawdle_V2 = mkV2 (mkV "bighellonare") ; -- status=guess, src=wikt
lin dawlish_PN = mkPN "Dawlish" ; -- status=guess src=geonames
lin dawn_N = mkN "albori" masculine | mkN "schiudersi" masculine ; -- status=guess status=guess
lin dawn_V = mkV "spuntare" ; -- status=guess, src=wikt
lin day_N = L.day_N ;
lin dayboy_N = mkN "alunno_esterno" ; -- UWN
lin daybreak_N = mkN "alba" | mkN "albeggiamento" | mkN "albeggiare" | mkN "albore" | mkN "albori" | mkN "aurora" | mkN "biancore" ; -- UWN
lin daydream_N = mkN "sogno ad occhi aperti" | mkN "fantasticheria" ; -- status=guess status=guess
lin daydream_V = mkV "fantasticare" | mkV (mkV "sognare") "ad occhi aperti" ; -- status=guess, src=wikt status=guess, src=wikt
lin daylight_N = mkN "ora legale" ; -- status=guess
lin days_N = mkN "giorni" masculine ; -- status=guess
lin dayspring_N = mkN "alba" | mkN "albeggiamento" | mkN "albeggiare" | mkN "albore" | mkN "albori" | mkN "aurora" | mkN "biancore" ; -- UWN
lin daytime_N = mkN "dì" | mkN "giornata" | mkN "giorno" ; -- UWN
lin dayton_PN = mkPN "Dayton" ; -- status=guess src=geonames
lin dazzle_N = mkN "barbaglio" ; -- UWN
lin dazzle_V2 = mkV2 (mkV "abbagliare") ; -- status=guess, src=wikt
lin de_jure_Adv = mkAdv "legalmente" ; -- UWN
lin deacon_N = mkN "diacono" ; -- status=guess
lin deaconess_N = mkN "diaconessa" ; -- status=guess
lin deactivate_V2 = mkV2 (mkV "disattivare") ; -- status=guess, src=wikt
lin dead_A = mkA "morto" ; -- status=guess
lin dead_Adv = variants {} ; --
lin dead_N = mkN "bonaccia" ; -- status=guess
lin deaden_V2 = mkV2 (mkV "intontire") | mkV2 (mkV "smorzare") | mkV2 (mkV "attenuare") | mkV2 (mkV "sminuire") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin deadline_N = mkN "scadenza" ; -- status=guess
lin deadlock_N = mkN "impasse" | mkN "punto_morto" ; -- UWN
lin deadly_A = variants {} ; --
lin deadpan_A = mkA "impassibile" ; -- status=guess
lin deaf_A = mkA "sordo" ; -- status=guess
lin deaf_N = mkN "i sordi" | mkN "i non udenti" ; -- status=guess status=guess
lin deal_N = mkN "contratto" ; -- status=guess
lin deal_PN = mkPN "Deal" ; -- status=guess src=geonames
lin deal_V = mkV "commerciare" | mkV "trattare" ; -- UWN
lin deal_V2 = variants {} ; --
lin dealer_N = mkN "piazzista" ; -- status=guess
lin dealing_N = mkN "operazione" | mkN "transazione" ; -- UWN
lin dean_N = mkN "decano" ; -- status=guess
lin dear_A = mkA "caro" | mkA "costoso" ; -- status=guess status=guess
lin dear_Interj = variants {} ; --
lin dear_N = variants {} ; --
lin dearth_N = mkN "carestia" ; -- status=guess
lin death_N = mkN "la morte" | mkN "l'arcano senza nome" ; -- status=guess status=guess
lin deathbed_N = mkN "letto di morte" ; -- status=guess
lin deathblow_N = mkN "colpo_di_grazia" ; -- UWN
lin deathly_A = variants {} ;
lin deathly_Adv = adjAdv deathly_A ; -- derived
lin death_rate_N = mkN "mortalità" | mkN "tasso_di_mortalità" ; -- UWN
lin deathtrap_N = mkN "trappola_mortale" ; -- UWN
lin deb_N = mkN "deb" | mkN "debuttante" ; -- UWN
lin debarkation_N = mkN "sbarco" ; -- UWN
lin debase_V2 = mkV2 (mkV "avvilire") ; -- status=guess, src=wikt
lin debasement_N = mkN "abbrutimento" | mkN "degradazione" ; -- UWN
lin debatable_A = mkA "discutibile" | mkA "opinabile" ; -- status=guess status=guess
lin debate_N = mkN "dibattito" | mkN "dibattimento" ; -- status=guess status=guess
lin debate_V = mkV "dibattere" ; -- status=guess, src=wikt
lin debate_V2 = mkV2 (mkV "dibattere") ; -- status=guess, src=wikt
lin debaucheeFem_N = variants {} ; ---- sense to be split
lin debaucheeMasc_N = variants {} ; ---- sense to be split
lin debilitating_A = mkA "debilitante" | mkA "estenuante" | mkA "faticoso" | mkA "gravoso" | mkA "immane" | mkA "logorante" | mkA "massacrante" | mkA "pesante" | mkA "sfibrante" | mkA "snervante" | mkA "spossante" | mkA "stressante" ; -- UWN
lin debility_N = mkN "debilitazione" | mkN "fragilità" | mkN "gracilità" | mkN "infermità" | mkN "mollezza" | mkN "tenuità" ; -- UWN
lin debit_N = mkN "carta di debito" ; -- status=guess
lin debonair_A = mkA "disinvolto" ; -- UWN
lin debris_N = mkN "maceria" ; -- status=guess
lin debt_N = mkN "debito" ; -- status=guess
lin debtor_N = mkN "debitore" | mkN "debitrice" feminine ; -- status=guess status=guess
lin debugger_N = mkN "debugger" masculine ; -- status=guess
lin debut_1_N = variants {} ; --
lin debut_2_N = variants {} ; --
lin debut_N = mkN "debutto" ; -- status=guess
lin debutante_N = variants {} ;
lin decade_N = mkN "decennio" | mkN "decade" feminine ; -- status=guess status=guess
lin decadence_N = mkN "decadenza" ; -- status=guess
lin decadent_A = mkA "decadente" ; -- status=guess
lin decadent_N = mkN "decadentista" masculine ; -- status=guess
lin decagon_N = mkN "decagono" ; -- status=guess
lin decahedron_N = mkN "decaedro" ; -- status=guess
lin decal_N = mkN "decalcabile" masculine ; -- status=guess
lin decalcomania_N = mkN "calcomania" | mkN "decalcomania" ; -- UWN
lin decameter_N = mkN "decametro" ; -- UWN
lin decampment_N = mkN "decampamento" ; -- UWN
lin decant_V2 = mkV2 (mkV "travasare") ; -- status=guess, src=wikt
lin decanter_N = mkN "boccia" | mkN "caraffa" | mkN "guastada" ; -- UWN
lin decapitate_V2 = mkV2 (mkV "decapitare") ; -- status=guess, src=wikt
lin decapitation_N = mkN "decapitazione" feminine ; -- status=guess
lin decathlon_N = mkN "decathlon" | mkN "decatlon" ; -- UWN
lin decay_N = mkN "decomponimento" | mkN "decomposizione" | mkN "disfacimento" | mkN "dissolvimento" | mkN "marcimento" ; -- UWN
lin decay_V = mkV "imputridire" ; -- status=guess, src=wikt
lin decease_N = mkN "decesso" | mkN "morte" ; -- UWN
lin decease_V = morire_V ; -- status=guess, src=wikt
lin deceit_N = mkN "inganno" | mkN "frode" feminine ; -- status=guess status=guess
lin deceitful_A = mkA "bugiardo" ; -- status=guess
lin deceitfulness_N = mkN "astuzia" | mkN "furberia" ; -- UWN
lin deceive_V2 = mkV2 (mkV "ingannare") ; -- status=guess, src=wikt
lin deceiver_N = mkN "imbroglione" | mkN "trappolone" | mkN "truffaldino" | mkN "turlupinatore" ; -- UWN
lin deceivingly_Adv = mkAdv "illusoriamente" ; -- UWN
lin decent_A = mkA "presentabile" ; -- status=guess
lin deception_N = mkN "mistificazione" feminine | mkN "inganno" ; -- status=guess status=guess
lin deceptive_A = mkA "ingannevole" ; -- status=guess
lin deceptiveness_N = mkN "illusorietà" feminine ; -- status=guess
lin decibel_N = mkN "decibel" masculine ; -- status=guess
lin decide_V = variants {} ; --
lin decide_V2 = variants {} ; --
lin decide_VS = variants {} ; --
lin decide_VV = variants {} ; --
lin decide_on_V2 = prepV2 OP_decide_V OP_on_Prep ; -- guess-p-verb
lin decide_upon_V2 = prepV2 OP_decide_V OP_upon_Prep ; -- guess-p-verb
lin decided_A = variants {} ;
lin deciduous_A = mkA "deciduo" ; -- status=guess
lin decigram_N = mkN "decigrammo" ; -- status=guess
lin deciliter_N = mkN "decilitro" | mkN "dl" ; -- UWN
lin decimal_N = mkN "decimale" ; -- status=guess
lin decimate_V2 = mkV2 (mkV "decimare") ; -- status=guess, src=wikt
lin decimeter_N = mkN "decimetro" | mkN "dm" ; -- UWN
lin decipherable_A = mkA "decifrabile" ; -- status=guess
lin decipherer_N = mkN "decifratore" masculine ; -- status=guess
lin decision_N = mkN "decisione" feminine ; -- status=guess
lin decision_making_N = variants {} ; --
lin decisive_A = mkA "decisivo" ; -- status=guess
lin decisiveness_N = mkN "inappellabilità" | mkN "irrevocabilità" ; -- UWN
lin deck_N = mkN "sdraio" | mkN "sedia a sdraio" ; -- status=guess status=guess
lin deckle_N = mkN "cascio" ; -- UWN
lin declamatory_A = mkA "ampolloso" | mkA "gonfio" ; -- UWN
lin declaration_N = mkN "dichiarazione" feminine ; -- status=guess
lin declarative_A = mkA "dichiarativo" ; -- UWN
lin declare_V = mkV "dichiarare" ; -- status=guess, src=wikt
lin declare_V2 = mkV2 (mkV "dichiarare") ; -- status=guess, src=wikt
lin declare_VS = mkVS (mkV "dichiarare") ; -- status=guess, src=wikt
lin declension_N = mkN "declinazione" feminine ; -- status=guess
lin declination_N = mkN "declinazione" feminine ; -- status=guess
lin decline_N = mkN "declino" ; -- status=guess
lin decline_V = mkV "declinare" ; -- status=guess, src=wikt
lin decline_V2 = mkV2 (mkV "declinare") ; -- status=guess, src=wikt
lin decline_VV = mkVV (mkV "declinare") ; -- status=guess, src=wikt
lin declivity_N = mkN "declivio" ; -- status=guess
lin decoction_N = mkN "decotto" ; -- status=guess
lin decoding_N = mkN "deciframento" | mkN "decifrazione" | mkN "decodifica" | mkN "decodificazione" | mkN "decriptazione" | mkN "decrittazione" ; -- UWN
lin decolonization_N = mkN "decolonizzazione" ; -- UWN
lin decompose_V = decomporre_V ; -- status=guess, src=wikt
lin decompose_V2 = mkV2 decomporre_V ; -- status=guess, src=wikt
lin decomposition_N = mkN "decomposizione" feminine ; -- status=guess
lin decompression_N = mkN "decompressione" ; -- UWN
lin decongestant_N = mkN "decongestionante" masculine ; -- status=guess
lin decontamination_N = mkN "decontaminazione" feminine ; -- status=guess
lin decorate_V2 = variants {} ; --
lin decoration_N = mkN "decorazione" feminine ; -- status=guess
lin decorative_A = mkA "decorativo" ; -- status=guess
lin decorator_N = mkN "decoratore" | mkN "decoratrice" | mkN "paratore" | mkN "paratrice" feminine ; -- status=guess status=guess status=guess status=guess
lin decorum_N = mkN "decoro" ; -- status=guess
lin decoy_N = mkN "zimbello" ; -- status=guess
lin decrease_N = mkN "diminuzione di" | mkN "calo di" | mkN "ribasso di" | mkN "riduzione di" ; -- status=guess status=guess status=guess status=guess
lin decrease_V = mkV "diminuire" | mkV "calare" ; -- status=guess, src=wikt status=guess, src=wikt
lin decrease_V2 = mkV2 (mkV "diminuire") | mkV2 (mkV "calare") ; -- status=guess, src=wikt status=guess, src=wikt
lin decree_N = mkN "decreto" ; -- status=guess
lin decrepit_A = mkA "decrepito" ; -- status=guess
lin decrepitude_N = mkN "decrepitezza" ; -- UWN
lin decrescendo_N = mkN "decrescendo" | mkN "diminuendo" ; -- UWN
lin dedicate_V2 = variants {} ; --
lin dedifferentiation_N = mkN "dedifferenziazione" feminine ; -- status=guess
lin deduce_V2 = mkV2 (dedurre_V) ; -- status=guess, src=wikt
lin deduct_V2 = mkV2 (mkV "defalcare") ; -- status=guess, src=wikt
lin deductible_A = mkA "detraibile" ; -- status=guess
lin deduction_N = mkN "deduzione" feminine ; -- status=guess
lin deductive_A = mkA "deduttivo" ; -- status=guess
lin deed_N = mkN "fatto" feminine | mkN "gesto" | mkN "gesta" ; -- status=guess status=guess status=guess
lin deem_V2 = mkV2 (mkV "considerare") | mkV2 (mkV "valutare") | mkV2 (mkV "credere") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin deem_V2A = mkV2A (mkV "considerare") | mkV2A (mkV "valutare") | mkV2A (mkV "credere") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin deem_V2V = mkV2V (mkV "considerare") | mkV2V (mkV "valutare") | mkV2V (mkV "credere") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin deep_A = mkA "profondo" ; -- status=guess
lin deep_Adv = variants {} ; --
lin deep_N = mkN "imbutitura" ; -- status=guess
lin deepen_V = mkV "approfondire" ; -- status=guess, src=wikt
lin deepen_V2 = mkV2 (mkV "approfondire") ; -- status=guess, src=wikt
lin deepening_N = mkN "approfondimento" ; -- UWN
lin deer_N = mkN "cervo" | mkN "alce" | mkN "renna" | mkN "daino" | mkN "capriolo" ; -- status=guess status=guess status=guess status=guess status=guess
lin defacement_N = mkN "deturpamento" | mkN "deturpazione" ; -- UWN
lin defalcation_N = mkN "appropriazione_indebita" ; -- UWN
lin defamation_N = mkN "diffamazione" feminine ; -- status=guess
lin defamer_N = mkN "boccaccia" | mkN "calunniatore" | mkN "diffamatore" | mkN "libellista" ; -- UWN
lin default_N = mkN "predefinito" ; -- status=guess
lin defeat_N = mkN "sconfitta" | mkN "disfatta" | mkN "fallimento" | mkN "insuccesso" ; -- status=guess status=guess status=guess status=guess
lin defeat_V2 = mkV2 (sconfiggere_V) | mkV2 (mkV "battere") ; -- status=guess, src=wikt status=guess, src=wikt
lin defeatism_N = mkN "disfattismo" ; -- status=guess
lin defeatist_N = mkN "disfattista" masculine ; -- status=guess
lin defecate_V = mkV "defecare" ; -- status=guess, src=wikt
lin defecation_N = mkN "defecazione" feminine ; -- status=guess
lin defect_N = mkN "difetto" ; -- status=guess
lin defect_V = mkV "defezionare" ; -- status=guess, src=wikt
lin defective_A = mkA "difettoso" ; -- status=guess
lin defectiveness_N = mkN "difettosità" ; -- UWN
lin defector_N = mkN "disertore" ; -- UWN
lin defence_N = mkN "difesa" ; -- status=guess
lin defend_V2 = mkV2 (mkV "difendere") ; -- status=guess, src=wikt
lin defendable_A = mkA "difendibile" | mkA "sostenibile" | mkA "tenibile" ; -- status=guess status=guess status=guess
lin defendant_N = mkN "accusato" | mkN "convenuto" | mkN "giudicabile" | mkN "imputato" | mkN "incriminato" | mkN "prevenuto" | mkN "querelato" ; -- UWN
lin defenderFem_N = variants {} ; ---- sense to be split
lin defenderMasc_N = variants {} ; --
lin defenestration_N = mkN "defenestrazione" feminine ; -- status=guess
lin defensible_A = mkA "difendibile" | mkA "sostenibile" | mkA "tenibile" ; -- status=guess status=guess status=guess
lin defensive_A = variants {} ; --
lin defensive_N = mkN "difensiva" ; -- UWN
lin deference_N = mkN "deferenza" ; -- status=guess
lin deferential_A = mkA "deferente" | mkA "deferenziale" | mkA "ossequente" ; -- status=guess status=guess status=guess
lin deferment_N = mkN "dilazione" feminine | mkN "posponimento" | mkN "deferimento" ; -- status=guess status=guess status=guess
lin deferral_N = mkN "aggiornamento" | mkN "differimento" | mkN "dilazione" | mkN "posticipazione" | mkN "procrastinamento" | mkN "procrastinazione" | mkN "prolungamento" | mkN "proroga" | mkN "rinvio" | mkN "slittamento" | mkN "sospensione" | mkN "sospensiva" ; -- UWN
lin deficiency_N = mkN "deficienza" ; -- status=guess
lin deficit_N = variants {} ; --
lin defile_N = mkN "canalone" | mkN "gola" ; -- UWN
lin define_V = mkV "definire" | descrivere_V ; -- status=guess, src=wikt status=guess, src=wikt
lin define_V2 = mkV2 (mkV "definire") | mkV2 (descrivere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin definite_A = mkA "definito" ; -- status=guess
lin definition_N = mkN "definizione" feminine | mkN "il definire" ; -- status=guess status=guess
lin definitive_A = mkA "definitivo" ; -- status=guess
lin deflagration_N = mkN "deflagrazione" feminine ; -- status=guess
lin deflate_V2 = mkV2 (mkV "deflazionare") ; -- status=guess, src=wikt
lin deflation_N = mkN "deflazione" feminine ; -- status=guess
lin deflationary_A = mkA "deflativo" | mkA "deflatorio" | mkA "deflazionistico" ; -- UWN
lin deflector_N = mkN "deflettore" masculine ; -- status=guess
lin defloration_N = mkN "deflorazione" feminine ; -- status=guess
lin deflower_V2 = mkV2 (mkV "deflorare") | mkV2 (mkV "sverginare") ; -- status=guess, src=wikt status=guess, src=wikt
lin defoliant_N = mkN "defogliante" | mkN "defoliante" ; -- UWN
lin defoliation_N = mkN "defogliazione" | mkN "defoliazione" ; -- UWN
lin deforestation_N = mkN "deforestazione" feminine ; -- status=guess
lin deform_V2 = mkV2 (mkV "deformare") ; -- status=guess, src=wikt
lin deformation_N = mkN "deformazione" feminine ; -- status=guess
lin deformity_N = mkN "deformità" feminine ; -- status=guess
lin defrayal_N = mkN "liquidazione" | mkN "pagamento" ; -- UWN
lin defrayment_N = mkN "liquidazione" | mkN "pagamento" ; -- UWN
lin defroster_N = mkN "sbrinatore" ; -- UWN
lin deft_A = mkA "abile" ; -- status=guess
lin deftness_N = mkN "abilità" | mkN "destrezza" ; -- UWN
lin defuse_V2 = mkV2 (mkV "disinnescare") ; -- status=guess, src=wikt
lin defy_V2 = mkV2 (mkV "sfidare") ; -- status=guess, src=wikt
lin defy_V2V = mkV2V (mkV "sfidare") ; -- status=guess, src=wikt
lin degage_A = mkA "distaccato" ; -- UWN
lin degeneracy_N = mkN "cancrena" | mkN "corruttela" | mkN "depravamento" | mkN "depravazione" | mkN "deviazione" | mkN "fradiciume" | mkN "gangrena" | mkN "pervertimento" | mkN "putrido" ; -- UWN
lin degenerate_V = mkV "degenerare" ; -- status=guess, src=wikt
lin degeneration_N = mkN "degenerazione" feminine ; -- status=guess
lin degradation_N = mkN "abbrutimento" | mkN "degradazione" ; -- UWN
lin degrade_V2 = mkV2 (mkV "degradare") ; -- status=guess, src=wikt
lin degree_1_N = variants {} ; --
lin degree_2_N = variants {} ; --
lin degree_3_N = variants {} ; --
lin degree_N = variants {} ; --
lin dehiscent_A = mkA "deiscente" ; -- status=guess
lin dehydration_N = mkN "disidratazione" feminine ; -- status=guess
lin deification_N = mkN "apoteosi" | mkN "deificazione" | mkN "divinizzazione" ; -- UWN
lin deign_V = mkV "scendere" ; -- UWN
lin deism_N = mkN "deismo" ; -- status=guess
lin deist_A = mkA "deistico" ; -- UWN
lin deist_N = mkN "deista" | mkN "libero_pensatore" ; -- UWN
lin deity_N = mkN "divinità" feminine ; -- status=guess
lin dejection_N = mkN "deiezione" feminine ; -- status=guess
lin dekagram_N = mkN "decagramma" ; -- UWN
lin dekaliter_N = mkN "decalitro" | mkN "decilitro" | mkN "dl" ; -- UWN
lin delaware_PN = mkPN "Delaware" ; -- status=guess src=geonames
lin delay_N = variants {} ; --
lin delay_V = variants {} ; --
lin delay_V2 = variants {} ; --
lin delegate_N = mkN "addetto" | mkN "delegato" | mkN "deputato" | mkN "incaricato" | mkN "inviato" | mkN "mandatario" ; -- UWN
lin delegate_V2 = mkV2 (mkV "delegare") ; -- status=guess, src=wikt
lin delegating_N = mkN "delegazione" | mkN "rappresentanza" ; -- UWN
lin delegation_N = mkN "delegazione" | mkN "rappresentanza" ; -- UWN
lin delete_V2 = mkV2 (mkV "cancellare") | mkV2 (mkV "eliminare") ; -- status=guess, src=wikt status=guess, src=wikt
lin deleterious_A = mkA "deleterio" ; -- status=guess
lin deletion_N = mkN "cancellatura" | mkN "cancellazione" feminine ; -- status=guess status=guess
lin delhi_PN = mkPN "Delhi" ; -- status=guess src=geonames
lin deliberate_A = variants {} ; --
lin deliberation_N = mkN "ponderatezza" | mkN "riflessività" ; -- UWN
lin delicacy_N = mkN "delicatezza" ; -- UWN
lin delicate_A = mkA "delicato" ; -- status=guess
lin delicatessen_N = mkN "grillroom" | mkN "pizzicagnolo" | mkN "rosticceria" | mkN "salumeria" ; -- UWN
lin delicious_A = mkA "squisito" | mkA "delizioso" ; -- status=guess status=guess
lin delight_N = mkN "delizia" ; -- status=guess
lin delight_V = mkV "deliziare" ; -- status=guess, src=wikt
lin delight_V2 = mkV2 (mkV "deliziare") ; -- status=guess, src=wikt
lin delighted_A = variants {} ; --
lin delightful_A = variants {} ; --
lin delimit_V2 = mkV2 (mkV "delimitare") | mkV2 (mkV "demarcare") | mkV2 (mkV "fissare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin delimitation_N = mkN "delimitazione" feminine ; -- status=guess
lin delineate_V2 = mkV2 (mkV "delineare") ; -- status=guess, src=wikt
lin delineation_N = mkN "delineazione" feminine | mkN "delineamento" ; -- status=guess status=guess
lin delinquency_N = mkN "delinquenza_minorile" ; -- UWN
lin delinquent_N = mkN "delinquente" masculine ; -- status=guess
lin delirious_A = mkA "delirante" ; -- status=guess
lin delirium_N = mkN "delirio" ; -- status=guess
lin deliver_V = variants {} ; --
lin deliver_V2 = variants {} ; --
lin deliverance_N = mkN "liberazione" feminine ; -- status=guess
lin deliverer_N = mkN "ceditore" ; -- UWN
lin delivery_N = mkN "consegna" ; -- status=guess
lin delphinium_N = mkN "speronella" | mkN "delfinio" ; -- status=guess status=guess
lin delta_N = mkN "delta" masculine ; -- status=guess
lin delude_V2 = mkV2 (mkV "illudere") | mkV2 (mkV "ingannare") ; -- status=guess, src=wikt status=guess, src=wikt
lin deluge_N = mkN "diluvio" ; -- status=guess
lin deluge_V2 = mkV2 (mkV "inondare") | mkV2 (mkV "allagare") ; -- status=guess, src=wikt status=guess, src=wikt
lin delusion_N = mkN "delusione" feminine ; -- status=guess
lin demagnetization_N = mkN "demagnetizzazione" feminine ; -- status=guess
lin demagnetize_V2 = mkV2 (mkV "demagnetizzare") ; -- status=guess, src=wikt
lin demagogic_A = mkA "demagogico" ; -- status=guess
lin demagogue_N = mkN "demagogo" ; -- status=guess
lin demagoguery_N = mkN "demagogia" ; -- UWN
lin demagogy_N = mkN "demagogia" ; -- UWN
lin demand_N = mkN "domanda" | mkN "richiesta" ; -- UWN
lin demand_V2 = mkV2 (mkV "esigere") | mkV2 (mkV "pretendere") ; -- status=guess, src=wikt status=guess, src=wikt
lin demand_VS = mkVS (mkV "esigere") | mkVS (mkV "pretendere") ; -- status=guess, src=wikt status=guess, src=wikt
lin demanding_A = mkA "esigente" | mkA "impegnativo" | mkA "meticoloso" | mkA "minuzioso" | mkA "pedante" | mkA "pignolo" | mkA "severo" | mkA "sofistico" ; -- UWN
lin demarcate_V2 = mkV2 (mkV "demarcare") ; -- status=guess, src=wikt
lin demarcation_N = mkN "demarcazione" feminine ; -- status=guess
lin demean_V2 = mkV2 (mkV "svilire") ; -- status=guess, src=wikt
lin demeanor_N = mkN "comportamento" | mkN "atteggiamento" ; -- status=guess status=guess
lin demeanour_N = mkN "aria" | mkN "comportamento" | mkN "condotta" ; -- UWN
lin dementia_N = mkN "demenza" ; -- UWN
lin demerit_N = mkN "demerito" ; -- status=guess
lin demigod_N = mkN "semidio" ; -- status=guess
lin demijohn_N = mkN "damigiana" ; -- status=guess
lin demilitarize_V2 = mkV2 (mkV "smilitarizzare") ; -- status=guess, src=wikt
lin demist_V2 = mkV2 (mkV "disappannare") ; -- status=guess, src=wikt
lin demiurge_N = mkN "demiurgo" ; -- status=guess
lin demo_N = mkN "demo" feminine ; -- status=guess
lin demobilization_N = mkN "smilitarizzazione" | mkN "smobilitazione" ; -- UWN
lin democracy_N = mkN "democrazia" ; -- status=guess
lin democrat_N = mkN "democratico" | mkN "democratica" ; -- status=guess status=guess
lin democratic_A = mkA "democratico" ; -- status=guess
lin democratization_N = mkN "democratizzazione" ; -- UWN
lin demographer_N = mkN "demografo" ; -- UWN
lin demographic_A = mkA "demografico" ; -- status=guess
lin demography_N = mkN "demografia" ; -- status=guess
lin demolish_V2 = mkV2 (mkV "demolire") ; -- status=guess, src=wikt
lin demolition_N = mkN "demolizione" feminine ; -- status=guess
lin demon_N = mkN "demone" | mkN "demonio" ; -- status=guess status=guess
lin demoniac_N = mkN "indemoniato" | mkN "invasato" | mkN "ossesso" | mkN "spiritato" ; -- UWN
lin demoniacal_A = mkA "demoniaco" ; -- status=guess
lin demonic_A = mkA "demonico" ; -- status=guess
lin demonization_N = mkN "demonizzazione" feminine ; -- status=guess
lin demonstrability_N = mkN "dimostrabilità" feminine ; -- status=guess
lin demonstrate_V = mkV "sfilare" ; -- UWN
lin demonstrate_V2 = variants {} ; --
lin demonstrate_VS = mkvVS "dimostrare" | mkvVS "mostrare" ; -- UWN
lin demonstration_N = mkN "dimostrazione" feminine ; -- status=guess
lin demonstrator_N = mkN "dimostrante" | mkN "manifestante" ; -- UWN
lin demotion_N = mkN "degradazione" | mkN "destituzione" | mkN "esautorazione" | mkN "retrocessione" ; -- UWN
lin demulcent_N = mkN "emolliente" ; -- UWN
lin demur_N = mkN "eccezione" ; -- UWN
lin demurrage_N = mkN "controstallia" ; -- UWN
lin demurrer_N = mkN "difesa" ; -- UWN
lin den_N = mkN "covo" | mkN "tana" ; -- status=guess status=guess
lin denain_PN = mkPN "Denain" ; -- status=guess src=geonames
lin denationalization_N = mkN "denazionalizzazione" | mkN "dismissione" | mkN "privatizzazione" | mkN "snazionalizzazione" ; -- UWN
lin denationalize_V2 = mkV2 (mkV "denazionalizzare") | mkV2 (mkV "privatizzare") ; -- status=guess, src=wikt status=guess, src=wikt
lin denaturant_N = mkN "denaturante" masculine ; -- status=guess
lin denbigh_PN = mkPN "Denbigh" ; -- status=guess src=geonames
lin dengue_N = mkN "dengue" ; -- status=guess
lin deniable_A = mkA "negabile" ; -- UWN
lin denial_N = mkN "negazione" feminine ; -- status=guess
lin denier_N = mkN "negatore" ; -- UWN
lin denigrate_V2 = mkV2 (mkV "denigrare") | mkV2 (mkV "criticare") | mkV2 (mkV "sparlare") | mkV2 (mkV (mkV "parlare") "male") | mkV2 (mkV "diffamare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin denim_N = mkN "denim" ; -- UWN
lin denizen_N = mkN "abitante" | mkN "abitatore" | mkN "anima" | mkN "popolatore" | mkN "residente" ; -- UWN
lin denmark_PN = mkPN "Danimarca" ; -- status=guess src=geonames
lin dennis_PN = mkPN "Dennis" ; -- status=guess src=geonames
lin denny_PN = mkPN "Denny" ; -- status=guess src=geonames
lin denomination_N = mkN "appellativo" | mkN "denominazione" | mkN "soprannome" ; -- UWN
lin denominator_N = mkN "denominatore" ; -- UWN
lin denotative_A = mkA "denotativo" ; -- status=guess
lin denote_V2 = mkV2 (mkV "indicare") ; -- status=guess, src=wikt
lin denounce_V2 = variants {} ; --
lin dense_A = mkA "pastoso" ; -- status=guess
lin densimeter_N = mkN "aerometro" | mkN "densimetro" ; -- UWN
lin densitometer_N = mkN "densimetro" ; -- status=guess
lin density_N = mkN "densità" feminine ; -- status=guess
lin dent_N = mkN "ammaccatura" ; -- status=guess
lin dent_V = mkV "ammaccare" ; -- UWN
lin dentifrice_N = mkN "dentifricio" ; -- UWN
lin dentist_N = mkN "dentista" ; -- status=guess
lin dentistry_N = mkN "odontoiatria" ; -- status=guess
lin dentition_N = mkN "dentizione" feminine ; -- status=guess
lin denture_N = mkN "dentiera" ; -- status=guess
lin denudation_N = mkN "denudamento" | mkN "denudazione" | mkN "scartocciatura" | mkN "spogliatura" | mkN "svestimento" ; -- UWN
lin denunciation_N = mkN "denuncia" | mkN "denunzia" ; -- UWN
lin denver_PN = mkPN "Denver" ; -- status=guess src=geonames
lin deny_V2 = mkV2 (mkV "negare") | mkV2 (mkV "smentire") ; -- status=guess, src=wikt status=guess, src=wikt
lin deny_V3 = mkV3 (mkV "negare") | mkV3 (mkV "smentire") ; -- status=guess, src=wikt status=guess, src=wikt
lin deodorant_N = mkN "deodorante" masculine ; -- status=guess
lin deodorize_V2 = mkV2 (mkV "deodorare") ; -- status=guess, src=wikt
lin deoxyadenosine_N = mkN "deossiadenosina" ; -- status=guess
lin deoxyguanosine_N = mkN "deossiguanosina" ; -- status=guess
lin deoxyribose_N = mkN "deossiribosio" ; -- status=guess
lin depart_V = mkV (mkV "deviare") "da" ; -- status=guess, src=wikt
lin department_N = mkN "grande magazzino" | mkN "emporio" ; -- status=guess status=guess
lin departmental_A = mkA "ministeriale" | mkA "dipartimentale" | mkA "ripartimentale" ; -- status=guess status=guess status=guess
lin departure_N = mkN "dipartenza" masculine ; -- status=guess
lin depend_V = mkV "pendere" ; -- status=guess, src=wikt
lin dependability_N = mkN "affidabilità" | mkN "attendibilità" | mkN "lealtà" | mkN "serietà" | mkN "sincerità" ; -- UWN
lin dependant_N = mkN "persona_a_carico" ; -- UWN
lin dependence_N = mkN "dipendenza" ; -- status=guess
lin dependency_N = variants {} ; --
lin dependent_A = variants {} ; --
lin dependent_N = mkN "variabile dipendente" ; -- status=guess
lin depending_A = variants {} ; --
lin depicting_N = mkN "raffigurazione" ; -- UWN
lin depiction_N = mkN "dipinto" | mkN "descrizione" feminine ; -- status=guess status=guess
lin depilatory_A = mkA "depilatore" | mkA "depilatorio" ; -- status=guess status=guess
lin depilatory_N = mkN "depilatore" ; -- status=guess
lin deplorable_A = mkA "deplorabile" | mkA "deplorevole" ; -- status=guess status=guess
lin deploy_V = mkV "dispiegare" | mkV "collocare" ; -- status=guess, src=wikt status=guess, src=wikt
lin deploy_V2 = mkV2 (mkV "dispiegare") | mkV2 (mkV "collocare") ; -- status=guess, src=wikt status=guess, src=wikt
lin deponent_N = mkN "deponente" masculine ; -- status=guess
lin depopulation_N = mkN "spopolamento" ; -- UWN
lin deportation_N = mkN "deportazione" feminine ; -- status=guess
lin deportee_N = mkN "deportato" ; -- status=guess
lin deportment_N = mkN "aria" | mkN "comportamento" | mkN "condotta" ; -- UWN
lin depose_V = deporre_V ; -- status=guess, src=wikt
lin depose_V2 = mkV2 (deporre_V) ; -- status=guess, src=wikt
lin deposit_N = mkN "caparra" ; -- status=guess
lin deposit_V2 = variants {} ; --
lin deposition_N = mkN "brinamento" ; -- status=guess
lin depositor_N = mkN "depositante" masculine ; -- status=guess
lin depository_N = mkN "deposito" ; -- UWN
lin depot_N = mkN "deposito" ; -- status=guess
lin depravity_N = mkN "depravazione" | mkN "perversione" | mkN "turpitudine" | mkN "viziosità" ; -- UWN
lin deprecate_V2 = mkV2 (mkV "deprecare") ; -- status=guess, src=wikt
lin depreciate_V = mkV "svalutarsi" ; -- UWN
lin depressed_A = variants {} ; --
lin depression_N = mkN "depressione" feminine ; -- status=guess
lin depressive_A = mkA "depressivo" ; -- status=guess
lin depressor_N = mkN "depressore" masculine ; -- status=guess
lin deprivation_N = mkN "privazione" feminine ; -- status=guess
lin deprive_V2 = variants {} ; --
lin depth_N = mkN "profondità" feminine ; -- status=guess
lin deputation_N = mkN "delegazione" | mkN "rappresentanza" ; -- UWN
lin deputy_N = mkN "deputato" ; -- status=guess
lin derail_V2 = mkV2 (mkV "deragliare") ; -- status=guess, src=wikt
lin derailment_N = mkN "deragliamento" ; -- status=guess
lin derangement_N = mkN "sconvolgimento" ; -- UWN
lin derby_N = mkN "competizione" feminine | mkN "gara" | mkN "partita" ; -- status=guess status=guess status=guess
lin derby_PN = mkPN "Derby" ; -- status=guess src=geonames
lin deregulation_N = mkN "deregolamentazione" | mkN "deregulation" ; -- UWN
lin derelict_A = mkA "abbandonato" ; -- status=guess
lin derelict_N = mkN "oggetto abbandonato" | mkN "rifiuto" ; -- status=guess status=guess
lin deride_V2 = mkV2 (deridere_V) ; -- status=guess, src=wikt
lin derision_N = mkN "derisione" feminine ; -- status=guess
lin derisive_A = mkA "beffardo" | mkA "canzonatorio" | mkA "derisorio" ; -- UWN
lin derivative_A = mkA "derivato" ; -- UWN
lin derivative_N = mkN "derivato" | mkN "derivata" ; -- status=guess status=guess
lin derive_V = variants {} ; --
lin derive_V2 = variants {} ; --
lin dermatitis_N = mkN "dermatite" feminine ; -- status=guess
lin dermatologic_A = mkA "dermatologico" ; -- UWN
lin dermatologistFem_N = variants {} ; ---- sense to be split
lin dermatologistMasc_N = mkN "dermatologo" ; -- UWN
lin dermatology_N = mkN "dermatologia" ; -- status=guess
lin dermis_N = mkN "derma" masculine ; -- status=guess
lin derogatory_A = mkA "derogatorio" | mkA "dispregiativo" | mkA "peggiorativo" ; -- status=guess status=guess status=guess
lin dervish_N = mkN "derviscio" ; -- status=guess
lin desalinate_V2 = mkV2 (mkV "desalinizzare") ; -- status=guess, src=wikt
lin desalinize_V2 = mkV2 (mkV "dissalare") | mkV2 (mkV "desalinizzare") ; -- status=guess, src=wikt status=guess, src=wikt
lin desalt_V2 = mkV2 (mkV "dissalare") ; -- status=guess, src=wikt
lin descend_V = scendere_V ; -- status=guess, src=wikt
lin descend_V2 = mkV2 (scendere_V) ; -- status=guess, src=wikt
lin descendant_N = mkN "discendente" masculine ; -- status=guess
lin descent_N = mkN "ascendenza" ; -- status=guess
lin describable_A = mkA "descrivibile" | mkA "enarrabile" ; -- status=guess status=guess
lin describe_V2 = mkV2 (descrivere_V) ; -- status=guess, src=wikt
lin describe_VS = mkVS (descrivere_V) ; -- status=guess, src=wikt
lin description_N = mkN "descrizione" feminine ; -- status=guess
lin descriptive_A = mkA "descrittivo" ; -- status=guess
lin desegregate_V2 = mkV2 (mkV "desegretare") ; -- status=guess, src=wikt
lin desegregation_N = mkN "integrazione" ; -- UWN
lin desert_A = mkA "deserto" ; -- status=guess
lin desert_N = mkN "isola deserta" ; -- status=guess
lin desert_V = variants {} ; --
lin desert_V2 = variants {} ; --
lin deserter_N = mkN "disertore" ; -- UWN
lin deserve_V = mkV "meritare" | mkV "meritarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin deserve_V2 = mkV2 (mkV "meritare") | mkV2 (mkV "meritarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin deserve_VV = mkVV (mkV "meritare") | mkVV (mkV "meritarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin deservedly_Adv = mkAdv "meritatamente" | mkAdv "sacrosantamente" ; -- UWN
lin deservingness_N = mkN "benemerenza" ; -- UWN
lin desideratum_N = mkN "desiderato" ; -- status=guess
lin design_N = mkN "design" masculine ; -- status=guess
lin design_V = mkV "progettare" ; -- status=guess, src=wikt
lin design_V2 = mkV2 (mkV "progettare") ; -- status=guess, src=wikt
lin designate_V = variants {} ; --
lin designate_V2 = variants {} ; --
lin designate_V2V = variants {} ; --
lin designate_VS = variants {} ; --
lin designation_N = mkN "appellativo" | mkN "denominazione" | mkN "soprannome" ; -- UWN
lin designer_N = variants {} ; --
lin designing_N = mkN "design" | mkN "progettazione" ; -- UWN
lin desirability_N = mkN "sex_appeal" ; -- UWN
lin desirable_A = mkA "desiderabile" ; -- status=guess
lin desire_N = mkN "desiderio" ; -- status=guess
lin desire_V2 = mkV2 (mkV "desiderare") | mkV2 (volere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin desired_A = variants {} ; --
lin desirous_A = mkA "invogliato" ; -- UWN
lin desk_N = mkN "scrivania" ; -- status=guess
lin desktop_N = mkN "desktop" ; -- UWN
lin desolate_A = mkA "desolato" | mkA "deserto" ; -- status=guess status=guess
lin despair_N = mkN "disperazione" feminine ; -- status=guess
lin despatch_N = mkN "spedizione" ; -- UWN
lin desperate_A = mkA "disperato" ; -- status=guess
lin despicable_A = mkA "spregevole" ; -- status=guess
lin despise_V2 = mkV2 (mkV "disprezzare") ; -- status=guess, src=wikt
lin despite_Prep = variants {} ; --
lin despondency_N = mkN "abbacchiamento" | mkN "abbattimento" | mkN "magone" | mkN "scoramento" ; -- UWN
lin despondent_A = mkA "abbattuto" | mkA "scoraggiato" ; -- status=guess status=guess
lin despot_N = mkN "despota" masculine ; -- status=guess
lin despotism_N = mkN "despotismo" | mkN "dispotismo" | mkN "dittatura" | mkN "tirannia" | mkN "tirannide" ; -- UWN
lin dessau_PN = mkPN "Dessau" ; -- status=guess src=geonames
lin dessert_N = mkN "dolce" masculine | mkN "dessert" masculine ; -- status=guess status=guess
lin destabilization_N = mkN "destabilizzazione" feminine ; -- status=guess
lin destination_N = mkN "destinazione" feminine ; -- status=guess
lin destiny_N = mkN "destino" | mkN "fato" | mkN "fortuna" ; -- status=guess status=guess status=guess
lin destroy_V2 = mkV2 (distruggere_V) ; -- status=guess, src=wikt
lin destroyer_N = mkN "cacciatorpediniere" masculine ; -- status=guess
lin destruction_N = mkN "distruzione" feminine ; -- status=guess
lin destructive_A = mkA "distruttivo" ; -- status=guess
lin destructiveness_N = mkN "distruttività" feminine ; -- status=guess
lin desuetude_N = mkN "dissuetudine" | mkN "disuso" ; -- UWN
lin detachable_A = mkA "distaccabile" | mkA "estraibile" | mkA "rimovibile" | mkA "separabile" | mkA "staccabile" ; -- status=guess status=guess status=guess status=guess status=guess
lin detachment_N = mkN "distacco" ; -- status=guess
lin detail_N = mkN "minuzia" ; -- status=guess
lin detail_V2 = mkV2 (mkV "dettagliare") ; -- status=guess, src=wikt
lin detailed_A = mkA "dettagliato" ; -- UWN
lin detain_V2 = mkV2 (detenere_V) | mkV2 (trattenere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin detect_V2 = variants {} ; --
lin detection_N = variants {} ; --
lin detective_N = mkN "detective" | mkN "investigatore" ; -- UWN
lin detector_N = variants {} ; --
lin detention_N = variants {} ; --
lin deter_V2 = mkV2 (mkV "scoraggiare") ; -- status=guess, src=wikt
lin detergent_A = mkA "detergente" ; -- status=guess
lin detergent_N = mkN "detergente" ; -- status=guess
lin deteriorate_V = mkV "deteriorarsi" ; -- status=guess, src=wikt
lin deteriorate_V2 = mkV2 (mkV "deteriorarsi") ; -- status=guess, src=wikt
lin deterioration_N = mkN "deterioramento" ; -- status=guess
lin determinant_N = mkN "determinante" masculine ; -- status=guess
lin determination_N = mkN "decisione" | mkN "determinazione" | mkN "finalità" | mkN "fine" | mkN "grinta" | mkN "mordente" ; -- UWN
lin determine_V = variants {} ; --
lin determine_V2 = variants {} ; --
lin determine_V2V = variants {} ; --
lin determine_VS = mkvVS "decidere" | mkvVS "decidersi" | mkvVS "risolvere" ; -- UWN
lin determine_VV = mkvVV "decidere" | mkvVV "decidersi" | mkvVV "risolvere" ; -- UWN
lin determined_A = variants {} ; --
lin determinism_N = mkN "determinismo" | mkN "necessitismo" ; -- UWN
lin deterrent_N = mkN "deterrente" | mkN "impaccio" | mkN "impedimento" | mkN "impiccio" | mkN "ostacolo" | mkN "remora" ; -- UWN
lin detest_V2 = mkV2 (mkV "detestare") ; -- status=guess, src=wikt
lin dethronement_N = mkN "detronizzazione" | mkN "spodestamento" ; -- UWN
lin detonator_N = mkN "detonatore" masculine ; -- status=guess
lin detour_N = mkN "deviazione" ; -- UWN
lin detractor_N = mkN "denigratore" | mkN "detrattore" ; -- UWN
lin detriment_N = mkN "detrimento" ; -- status=guess
lin detrimental_A = mkA "dannoso" ; -- status=guess
lin detritus_N = mkN "detrito" ; -- UWN
lin detroit_PN = mkPN "Detroit" ; -- status=guess src=geonames
lin deuterium_N = mkN "deuterio" ; -- status=guess
lin devaluation_N = mkN "devalutazione" | mkN "svalutazione" ; -- UWN
lin develop_V = mkV "sviluppare" ; -- status=guess, src=wikt
lin develop_V2 = mkV2 (mkV "sviluppare") ; -- status=guess, src=wikt
lin developed_A = variants {} ; --
lin developer_N = mkN "sviluppatore" masculine ; -- status=guess
lin developing_A = variants {} ; --
lin development_N = mkN "sviluppo" | mkN "potenziamento" ; -- status=guess status=guess
lin deviant_A = mkA "anormale" | mkA "deviante" ; -- status=guess status=guess
lin deviant_N = mkN "pervertito" | mkN "anormale" masculine ; -- status=guess status=guess
lin deviate_V = mkV "deviare" | mkV "dirottare" ; -- UWN
lin deviation_N = variants {} ; --
lin deviationist_N = mkN "deviazionista" ; -- UWN
lin device_N = mkN "emblema" | mkN "coccarda" | mkN "motto" | mkN "inscrizione" feminine ; -- status=guess status=guess status=guess status=guess
lin devil_N = mkN "diavolo" ; -- status=guess
lin devilish_A = mkA "diabolico" ; -- status=guess
lin devise_V2 = mkV2 (mkV "architettare") | mkV2 (mkV "congegnare") | mkV2 (mkV "escogitare") | mkV2 (mkV "inventare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin devising_N = mkN "lavorazione" | mkN "realizzazione" ; -- UWN
lin devitalization_N = mkN "devitalizzazione" | mkN "museificazione" ; -- UWN
lin devizes_PN = mkPN "Devizes" ; -- status=guess src=geonames
lin devoid_A = mkA "privo" | mkA "senza" ; -- status=guess status=guess
lin devolution_N = mkN "devoluzione" feminine ; -- status=guess
lin devon_PN = mkPN "Devon" ; -- status=guess src=geonames
lin devote_V2 = variants {} ; --
lin devoted_A = variants {} ; --
lin devotion_N = mkN "devozione" | mkN "divozione" ; -- UWN
lin devour_V2 = mkV2 (mkV "divorare") ; -- status=guess, src=wikt
lin devoutness_N = mkN "devozione" | mkN "divozione" | mkN "religiosità" ; -- UWN
lin dew_N = mkN "rugiada" ; -- status=guess
lin dewlap_N = mkN "pappagorgia" ; -- status=guess
lin dewsbury_PN = mkPN "Dewsbury" ; -- status=guess src=geonames
lin dexterity_N = mkN "abilità_manuale" | mkN "destrezza" | mkN "manualità" ; -- UWN
lin dexterous_A = mkA "agile" | mkA "aggraziato" ; -- status=guess status=guess
lin dextrose_N = mkN "destrosio" ; -- status=guess
lin diabetes_N = mkN "diabete" masculine ; -- status=guess
lin diabetic_A = mkA "diabetico" ; -- status=guess
lin diabetic_N = mkN "diabetico" ; -- status=guess
lin diabolic_A = mkA "diabolico" ; -- status=guess
lin diacritic_N = mkN "segno_diacritico" ; -- UWN
lin diacritical_A = mkA "diacritico" ; -- status=guess
lin diadem_N = mkN "diadema" masculine ; -- status=guess
lin diaeresis_N = mkN "dieresi" feminine ; -- status=guess
lin diagnose_V2 = mkV2 (mkV "diagnosticare") ; -- status=guess, src=wikt
lin diagnosis_N = mkN "diagnosi" feminine ; -- status=guess
lin diagnostician_N = mkN "diagnosta" | mkN "diagnostico" | mkN "patologo" ; -- UWN
lin diagonal_A = mkA "diagonale" ; -- status=guess
lin diagonal_N = mkN "diagonale" ; -- status=guess
lin diagram_N = mkN "diagramma" masculine ; -- status=guess
lin dial_N = mkN "comparatore" ; -- status=guess
lin dialect_N = mkN "dialetto" ; -- status=guess
lin dialectal_A = mkA "dialettale" ; -- status=guess
lin dialectic_A = mkA "dialettico" ; -- UWN
lin dialectic_N = mkN "dialettica" ; -- UWN
lin dialectical_A = mkA "dialettico" ; -- UWN
lin dialectics_N = mkN "dialettica" ; -- status=guess
lin dialogue_N = mkN "dialogo" ; -- status=guess
lin dialysis_N = mkN "dialisi" feminine ; -- status=guess
lin dialyzer_N = mkN "dializzatore" ; -- status=guess
lin diamagnetic_A = mkA "diamagnetico" ; -- status=guess
lin diamagnetism_N = mkN "diamagnetismo" ; -- status=guess
lin diameter_N = mkN "diametro" ; -- status=guess
lin diametral_A = mkA "diametrale" ; -- UWN
lin diametric_A = mkA "diametrale" ; -- UWN
lin diamine_N = mkN "diammina" ; -- status=guess
lin diamond_N = mkN "diamante" masculine ; -- status=guess
lin diaper_N = mkN "pannolino" ; -- status=guess
lin diaphanous_A = mkA "diafano" ; -- status=guess
lin diaphragm_N = mkN "diaframma" masculine ; -- status=guess
lin diapsid_N = mkN "diapside" ; -- UWN
lin diarchy_N = mkN "diarchia" | mkN "duopolio" ; -- UWN
lin diarrhea_N = mkN "diarrea" ; -- status=guess
lin diarrhoea_N = mkN "cacaiola" | mkN "cacarella" | mkN "cacherella" | mkN "diarrea" | mkN "sciolta" | mkN "squacquera" ; -- UWN
lin diary_N = mkN "diario" ; -- status=guess
lin diastole_N = mkN "diastole" ; -- status=guess
lin diastrophism_N = mkN "diastrofismo" ; -- status=guess
lin diathermy_N = mkN "diatermocoagulazione" feminine ; -- status=guess
lin diathesis_N = mkN "diatesi" ; -- UWN
lin diatomic_A = mkA "biatomico" | mkA "diatomico" ; -- UWN
lin diatonic_A = mkA "diatonico" ; -- status=guess
lin diatribe_N = mkN "diatriba" ; -- status=guess
lin dibber_N = mkN "cavicchio" | mkN "foraterra" | mkN "piantatoio" ; -- UWN
lin dibble_N = mkN "cavicchio" | mkN "foraterra" | mkN "piantatoio" ; -- UWN
lin dice_N = mkN "biscia tassellata" ; -- status=guess
lin dice_V = mkV (I.fare_V) "a dadini" | mkV (mkV "tagliare") "a dadini" ; -- status=guess, src=wikt status=guess, src=wikt
lin dice_V2 = mkV2 (mkV (I.fare_V) "a dadini") | mkV2 (mkV (mkV "tagliare") "a dadini") ; -- status=guess, src=wikt status=guess, src=wikt
lin dichloride_N = mkN "bicloruro" ; -- UWN
lin dichotomy_N = mkN "dicotomia" ; -- status=guess
lin dick_N = mkN "cazzo" | mkN "pisello" ;
lin dickey_N = mkN "pettino" ; -- UWN
lin dickeybird_N = mkN "uccellino" ; -- UWN
lin dicky_N = mkN "pettino" ; -- UWN
lin dickybird_N = mkN "uccellino" ; -- UWN
lin dicot_N = mkN "dicotiledone" ; -- UWN
lin dicotyledonous_A = mkA "dicotile" | mkA "dicotiledone" ; -- UWN
lin dictate_N = mkN "dettame" ; -- UWN
lin dictate_V = mkV "dettare" ; -- UWN
lin dictate_V2 = variants {} ; --
lin dictate_VS = mkvVS "dettare" ; -- UWN
lin dictation_N = mkN "dettato" ; -- status=guess
lin dictator_N = mkN "dittatore" masculine ; -- status=guess
lin dictatorship_N = mkN "dittatura" ; -- status=guess
lin diction_N = mkN "dizione" feminine ; -- status=guess
lin dictionary_N = mkN "dizionario" ; -- status=guess
lin didactic_A = mkA "didattico" ; -- status=guess
lin didcot_PN = mkPN "Didcot" ; -- status=guess src=geonames
lin die_N = mkN "plinto" ; -- status=guess
lin die_V = L.die_V ;
lin die_away_V = advV OP_die_V OP_away_Adv ; -- guess-p-verb
lin die_back_V = advV OP_die_V OP_back_Adv ; -- guess-p-verb
lin die_down_V = advV OP_die_V OP_down_Adv ; -- guess-p-verb
lin die_for_V2 = prepV2 OP_die_V OP_for_Prep ; -- guess-p-verb
lin die_off_V = mkV "estinguersi" | mkV "morire" | mkV "spegnersi" ; -- UWN
lin die_out_V = mkV "estinguersi" | mkV "morire" | mkV "spegnersi" ; -- UWN
lin dieresis_N = mkN "dieresi" ; -- UWN
lin diesel_N = mkN "diesel" | mkN "gasolio" ; -- status=guess status=guess
lin diet_N = mkN "dieta" ; -- status=guess
lin dietetics_N = mkN "dietetica" | mkN "dietologia" | mkN "sitologia" ; -- UWN
lin dietician_N = mkN "alimentarista" | mkN "dietista" | mkN "dietologo" | mkN "nutrizionista" | mkN "sitologo" ; -- UWN
lin dietitian_N = mkN "alimentarista" | mkN "dietista" | mkN "dietologo" | mkN "nutrizionista" | mkN "sitologo" ; -- UWN
lin differ_V = variants {} ; --
lin difference_N = mkN "differenza" ; -- status=guess
lin different_A = mkA "diverso" | mkA "differente" ;
lin differentiable_A = mkA "differenziabile" ; -- UWN
lin differential_A = variants {} ; --
lin differential_N = mkN "equazione differenziale" ; -- status=guess
lin differentiate_V = variants {} ; --
lin differentiate_V2 = variants {} ; --
lin differentiation_N = mkN "differenziazione" feminine ; -- status=guess
lin difficult_A = mkA "difficile" ; -- status=guess
lin difficulty_N = mkN "difficoltà" feminine ; -- status=guess
lin diffract_V2 = mkV2 (mkV "diffrangersi") ; -- status=guess, src=wikt
lin diffraction_N = mkN "diffrazione" feminine ; -- status=guess
lin diffuse_V = mkV "comunicare" | mkV "diffondere" | mkV "diffondersi" | mkV "diramare" | mkV "divulgare" | mkV "propagare" | mkV "trasmettere" ; -- UWN
lin diffuser_N = mkN "diffusore" ; -- UWN
lin dig_N = mkN "scavi" ; -- status=guess
lin dig_V = L.dig_V ;
lin dig_V2 = mkV2 (mkV "scavare") ; -- status=guess, src=wikt
lin dig_in_V = advV OP_dig_V OP_in_Adv ; -- guess-p-verb
lin dig_into_V2 = prepV2 OP_dig_V OP_into_Prep ; -- guess-p-verb
lin dig_out_V2 = prepV2 OP_dig_V OP_out_Prep ; -- guess-p-verb
lin dig_up_V2 = prepV2 OP_dig_V OP_up_Prep ; -- guess-p-verb
lin digest_V = mkV "digerire" ; -- status=guess, src=wikt
lin digest_V2 = mkV2 (mkV "digerire") ; -- status=guess, src=wikt
lin digestibility_N = mkN "digeribilità" ; -- UWN
lin digestible_A = mkA "assimilabile" | mkA "digeribile" ; -- status=guess status=guess
lin digestion_N = mkN "assimilazione" feminine ; -- status=guess
lin digestive_N = mkN "apparato digerente" ; -- status=guess
lin digger_N = mkN "escavatore" | mkN "escavatrice" | mkN "pala_meccanica" | mkN "scavatrice" | mkN "terrazziere" ; -- UWN
lin digging_N = mkN "escavazione" | mkN "scavatura" | mkN "scavo" | mkN "sterro" ; -- UWN
lin digit_N = mkN "digito" | mkN "dito" ; -- UWN
lin digital_A = mkA "digitale" ; -- status=guess
lin digitalis_N = mkN "digitale" feminine ; -- status=guess
lin digitization_N = mkN "digitalizzazione" feminine ; -- status=guess
lin dignity_N = mkN "dignità" feminine ; -- status=guess
lin digraph_N = mkN "digrafo" ; -- status=guess
lin digression_N = mkN "digressione" | mkN "disgressione" | mkN "escursione" ; -- UWN
lin digressive_A = mkA "digressivo" ; -- status=guess
lin dijon_PN = mkPN "Digione" ; -- status=guess src=geonames
lin dike_N = mkN "fosso" ; -- status=guess
lin dilapidated_A = mkA "pericolante" | mkA "degradato" | mkA "cadente" ; -- status=guess status=guess status=guess
lin dilapidation_N = mkN "dilapidazione" feminine ; -- status=guess
lin dilation_N = mkN "dilatazione" ; -- UWN
lin dildo_N = mkN "dildo" | mkN "vibratore" masculine ; -- status=guess status=guess
lin dilemma_N = mkN "dilemma" masculine ; -- status=guess
lin dilettante_N = mkN "dilettante" masculine ; -- status=guess
lin diligent_A = mkA "diligente" ; -- status=guess
lin dill_N = mkN "aneto" ; -- status=guess
lin dilute_A = mkA "diluire" ; -- status=guess
lin dilution_N = mkN "annacquamento" | mkN "diluizione" | mkN "diluzione" | mkN "stemperamento" ; -- UWN
lin diluvian_A = mkA "diluviale" ; -- status=guess
lin dim_A = mkA "indistinto" | mkA "indistinta" ; -- status=guess status=guess
lin dim_V = mkV "affievolirsi" ; -- status=guess, src=wikt
lin dim_V2 = mkV2 (mkV "affievolirsi") ; -- status=guess, src=wikt
lin dimension_N = mkN "dimensione" feminine ; -- status=guess
lin dimensional_A = mkA "-dimensionale" ; -- status=guess
lin dimer_N = mkN "dimero" ; -- status=guess
lin diminish_V = mkV "diminuire" | ridurre_V ; -- status=guess, src=wikt status=guess, src=wikt
lin diminish_V2 = mkV2 (mkV "diminuire") | mkV2 (ridurre_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin diminuendo_N = mkN "decrescendo" | mkN "diminuendo" ; -- UWN
lin diminutive_A = mkA "diminutivo" ; -- status=guess
lin diminutive_N = mkN "diminutivo" ; -- status=guess
lin dimmer_N = mkN "reostato" ; -- UWN
lin dimple_N = mkN "fossetta" ; -- status=guess
lin dimple_V = mkV (mkV "formare") "bozze su" ; -- status=guess, src=wikt
lin dimple_V2 = mkV2 (mkV (mkV "formare") "bozze su") ; -- status=guess, src=wikt
lin dimwit_N = mkN "cretino" | mkN "fessacchiotto" | mkN "mamalucco" | mkN "mammalucco" | mkN "minchione" | mkN "pinco" | mkN "scioccone" ; -- UWN
lin din_N = mkN "baccano" | mkN "schiamazzo" ; -- status=guess status=guess
lin dine_V = mkV "cenare" ; -- status=guess, src=wikt
lin diner_N = mkN "vagone ristorante" ; -- status=guess
lin dinghy_N = mkN "battello pneumatico" ; -- status=guess
lin dingle_PN = mkPN "Dingle" ; -- status=guess src=geonames
lin dingo_N = mkN "dingo" ; -- status=guess
lin dining_N = mkN "vagone ristorante" | mkN "carrozza ristorante" ; -- status=guess status=guess
lin dining_room_N = mkN "sala_da_pranzo" ; -- UWN
lin dinner_N = mkN "cena" ; -- status=guess
lin dinnington_PN = mkPN "Dinnington" ; -- status=guess src=geonames
lin dinosaur_N = mkN "dinosauro" ; -- status=guess
lin diocesan_A = mkA "diocesano" ; -- UWN
lin diocese_N = mkN "diocesi" feminine ; -- status=guess
lin diol_N = mkN "diolo" | mkN "glicol" | mkN "glicole" ; -- UWN
lin diopter_N = mkN "diottria" ; -- status=guess
lin diorite_N = mkN "diorite" feminine ; -- status=guess
lin dioxide_N = mkN "diossido" | mkN "biossido" ; -- status=guess status=guess
lin dioxin_N = mkN "diossina" ; -- UWN
lin dip_N = mkN "avvallamento" ; -- status=guess
lin dip_V = variants {} ; --
lin dip_V2 = variants {} ; --
lin diphtheria_N = mkN "difterite" ; -- UWN
lin diphthong_N = mkN "dittongo" ; -- status=guess
lin diploid_A = mkA "diploide" ; -- status=guess
lin diploma_N = mkN "diploma" ; -- status=guess
lin diplomacy_N = mkN "diplomazia" ; -- status=guess
lin diplomat_N = mkN "diplomatico" ; -- status=guess
lin diplomatic_A = mkA "diplomatico" ; -- status=guess
lin diplomatist_N = mkN "diplomatico" ; -- UWN
lin dipolar_A = mkA "dipolare" ; -- status=guess
lin dipole_N = mkN "dipolo" ; -- status=guess
lin dipper_N = mkN "merlo acquaiolo" ; -- status=guess
lin dipsomania_N = mkN "dipsomania" ; -- UWN
lin dipsomaniac_N = mkN "dipsomane" masculine ; -- status=guess
lin dipstick_N = mkN "asticella" ; -- status=guess
lin diptych_N = mkN "dittico" ; -- UWN
lin dire_A = mkA "terribile" ; -- status=guess
lin direct_A = variants {} ; --
lin direct_Adv = mkAdv "difilato" | mkAdv "direttamente" | mkAdv "diritto" | mkAdv "dritto" ; -- UWN
lin direct_V = variants {} ; --
lin direct_V2 = variants {} ; --
lin direction_N = variants {} ; --
lin directive_N = variants {} ; --
lin directness_N = mkN "franchezza" ; -- UWN
lin director_N = variants {} ; --
lin directorate_N = mkN "c.d.a." | mkN "cda" | mkN "consiglio_di_amministrazione" | mkN "consiglio_di_direzione" | mkN "consiglio_direttivo" | mkN "direttorio" ; -- UWN
lin directorship_N = mkN "direzione" feminine ; -- status=guess
lin directory_N = mkN "elenco telefonico" ; -- status=guess
lin dirge_N = mkN "lamento" | mkN "lamento_funebre" | mkN "nenia" | mkN "requiem" ; -- UWN
lin dirigible_N = mkN "aeronave" ; -- status=guess
lin dirt_A = mkA "regalato" ; -- status=guess
lin dirt_N = mkN "terra" masculine ; -- status=guess
lin dirty_A = L.dirty_A ;
lin dirty_V = mkV "sporcare" | mkV "sporcarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin dirty_V2 = mkV2 (mkV "sporcare") | mkV2 (mkV "sporcarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin disability_N = variants {} ; --
lin disable_V2 = mkV2 (mkV "disattivare") ; -- status=guess, src=wikt
lin disabled_A = variants {} ; --
lin disaccharide_N = mkN "disaccaride" masculine ; -- status=guess
lin disadvantage_N = mkN "disfavore" | mkN "sfavore" | mkN "svantaggio" ; -- UWN
lin disadvantageous_A = mkA "sconveniente" | mkA "svantaggioso" ; -- UWN
lin disagree_V = mkV "discordare" ; -- status=guess, src=wikt
lin disagree_V2 = mkV2 (mkV "discordare") ; -- status=guess, src=wikt
lin disagree_VS = mkVS (mkV "discordare") ; -- status=guess, src=wikt
lin disagreeable_A = mkA "antipatico" | mkA "sgradevole" ; -- status=guess status=guess
lin disagreement_N = mkN "disaccordo" ; -- status=guess
lin disambiguation_N = mkN "disambiguazione" feminine ; -- status=guess
lin disappear_V = mkV "sparire" ; -- status=guess, src=wikt
lin disappoint_V2 = variants {} ; --
lin disappointing_A = mkA "deludente" ; -- status=guess
lin disappointment_N = mkN "disinganno" ; -- UWN
lin disapprobation_N = mkN "condanna" ; -- UWN
lin disapproval_N = mkN "disapprovazione" feminine ; -- status=guess
lin disapprove_V = mkV "disapprovare" ; -- status=guess, src=wikt
lin disapprove_V2 = mkV2 (mkV "disapprovare") ; -- status=guess, src=wikt
lin disarm_V = mkV "disarmare" ; -- status=guess, src=wikt
lin disarm_V2 = mkV2 (mkV "disarmare") ; -- status=guess, src=wikt
lin disarmament_N = mkN "disarmo" ; -- status=guess
lin disarrangement_N = mkN "disorganizzazione" ; -- UWN
lin disaster_N = mkN "disastro" ; -- status=guess
lin disastrous_A = mkA "disastroso" ; -- status=guess
lin disavowal_N = mkN "disconoscimento" | mkN "ripudio" | mkN "sconfessione" | mkN "sconoscimento" ; -- UWN
lin disband_V = mkV "sciogliersi" ; -- UWN
lin disbelief_N = mkN "incredulità" | mkN "miscredenza" | mkN "scetticismo" ; -- UWN
lin disbeliever_N = mkN "ateo" | mkN "incredulo" | mkN "miscredente" | mkN "non_credente" | mkN "scettico" ; -- UWN
lin disbursement_N = mkN "esborso" | mkN "sborso" | mkN "spesa" ; -- UWN
lin disc_N = mkN "disco" ; -- status=guess
lin discard_V2 = variants {} ; --
lin discern_V2 = mkV2 (mkV "percepire") ; -- status=guess, src=wikt
lin discernment_N = mkN "cervello" | mkN "discrezione" ; -- UWN
lin discharge_N = variants {} ; --
lin discharge_V = variants {} ; --
lin discharge_V2 = variants {} ; --
lin disciple_N = mkN "adepto" | mkN "aderente" | mkN "affiliato" | mkN "discepolo" | mkN "scolaro" | mkN "seguace" | mkN "sostenitore" ; -- UWN
lin discipleship_N = mkN "discepolato" ; -- status=guess
lin disciplinarian_N = mkN "moralista" ; -- UWN
lin disciplinary_A = variants {} ; --
lin discipline_N = mkN "disciplina" ;
lin discipline_V2 = variants {} ; --
lin disclaimer_N = mkN "disconoscimento" | mkN "ripudio" | mkN "sconfessione" | mkN "sconoscimento" ; -- UWN
lin disclosure_N = mkN "palesamento" | mkN "rivelazione" ; -- UWN
lin disco_1_N = mkN "disco" ;
lin disco_2_N = mkN "discoteca" ;
lin discography_N = mkN "discografia" ; -- status=guess
lin discoloration_N = mkN "decolorazione" ; -- UWN
lin discolour_V = mkV "sbiadirsi" | mkV "schiarire" | mkV "scolorare" | mkV "scolorire" | mkV "scolorirsi" | mkV "stingere" | mkV "stingersi" ; -- UWN
lin discolouration_N = mkN "decolorazione" ; -- UWN
lin discomfort_N = mkN "disagio" ; -- status=guess
lin disconsolate_A = mkA "inconsolabile" | mkA "sconsolato" ; -- UWN
lin discontent_N = mkN "mal_umore" | mkN "malcontento" | mkN "malumore" ; -- UWN
lin discontentment_N = mkN "mal_umore" | mkN "malcontento" | mkN "malumore" ; -- UWN
lin discontinuance_N = mkN "discontinuità" | mkN "interruzione" ; -- UWN
lin discontinue_V = mkV "finire" | mkV "interrompere" | mkV "sospendere" ; -- UWN
lin discontinuity_N = mkN "discontinuità" ; -- UWN
lin discord_N = mkN "dissonanza" ; -- status=guess
lin discotheque_N = mkN "discoteca" ; -- status=guess
lin discount_N = mkN "sconto" ; -- status=guess
lin discount_V = variants {} ; --
lin discount_V2 = variants {} ; --
lin discourage_V2 = mkV2 (mkV "scoraggiare") ; -- status=guess, src=wikt
lin discouraging_A = mkA "avvilente" | mkA "demoralizzante" | mkA "deprimente" | mkA "desolante" | mkA "sconfortante" | mkA "sconsolante" | mkA "scoraggiante" ; -- UWN
lin discourse_N = mkN "discorso" ; -- status=guess
lin discover_V = mkV "scoprire" | mkV "discoprire" ; -- status=guess, src=wikt status=guess, src=wikt
lin discover_V2 = mkV2 (mkV "scoprire") | mkV2 (mkV "discoprire") ; -- status=guess, src=wikt status=guess, src=wikt
lin discover_VS = mkVS (mkV "scoprire") | mkVS (mkV "discoprire") ; -- status=guess, src=wikt status=guess, src=wikt
lin discovererFem_N = mkN "scopritore" | mkN "scopritore" ; -- UWN
lin discovererMasc_N = mkN "scopritore" | mkN "scopritore" ; -- UWN
lin discovery_N = mkN "scoperta" ; -- status=guess
lin discredit_N = mkN "discredito" | mkN "scredito" | mkN "squalifica" ; -- UWN
lin discrepancy_N = mkN "attrito" | mkN "disaccordo" | mkN "discrepanza" | mkN "dissonanza" | mkN "divergenza" ; -- UWN
lin discrete_A = mkA "distinto" | mkA "separato" ; -- status=guess status=guess
lin discretion_N = variants {} ; --
lin discrimination_N = mkN "discriminazione" ; -- UWN
lin discriminatory_A = mkA "discriminatorio" ; -- status=guess
lin discus_N = mkN "discobolo" ; -- status=guess
lin discuss_V2 = mkV2 (mkV "dibattere") ; -- status=guess, src=wikt
lin discuss_VS = mkVS (mkV "dibattere") ; -- status=guess, src=wikt
lin discussion_N = mkN "discussione" feminine ; -- status=guess
lin disdain_N = mkN "sdegno" | mkN "disdegno" | mkN "disprezzo" ; -- status=guess status=guess status=guess
lin disdain_V2 = mkV2 (mkV "sdegnare") | mkV2 (mkV "sprezzare") | mkV2 (mkV "spregiare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin disdainful_A = mkA "sprezzante" | mkA "disdegnoso" ; -- status=guess status=guess
lin disease_N = mkN "malattia" ; -- status=guess
lin disembark_V = mkV "sbarcare" ; -- status=guess, src=wikt
lin disembark_V2 = mkV2 (mkV "sbarcare") ; -- status=guess, src=wikt
lin disembarkation_N = mkN "sbarco" ; -- UWN
lin disembowel_V2 = mkV2 (mkV "secernere") ;
lin disenchantment_N = mkN "disillusione" | mkN "disincanto" | mkN "disinganno" ; -- UWN
lin disengage_V = mkV "disinnestarsi" ; -- UWN
lin disequilibrium_N = mkN "squilibrio" ; -- status=guess
lin disesteem_N = mkN "disistima" ; -- UWN
lin disfigurement_N = mkN "deturpamento" | mkN "deturpazione" ; -- UWN
lin disgrace_N = mkN "vergogna" ; -- status=guess
lin disgrace_V2 = mkV2 (mkV "disonorare") ; -- status=guess, src=wikt
lin disguise_V2 = variants {} ; --
lin disgust_N = mkN "disgusto" ; -- status=guess
lin disgust_V2 = mkV2 (mkV "disgustare") ; -- status=guess, src=wikt
lin disgusting_A = mkA "disgustoso" | mkA "nauseante" | mkA "stomachevole" | mkA "rivoltante" ; -- status=guess status=guess status=guess status=guess
lin dish_N = mkN "piatto" ; -- status=guess
lin disharmony_N = mkN "disarmonia" ; -- UWN
lin dishcloth_N = mkN "canavaccio" | mkN "canovaccio" | mkN "strofinaccio" ; -- UWN
lin dishonest_A = mkA "disonesto" ; -- status=guess
lin dishonour_N = mkN "disonore" masculine ; -- status=guess
lin dishonourable_A = mkA "disonorante" ; -- UWN
lin dishrag_N = mkN "canavaccio" | mkN "canovaccio" | mkN "strofinaccio" ; -- UWN
lin dishtowel_N = mkN "canavaccio" | mkN "canovaccio" | mkN "strofinaccio" ; -- UWN
lin dishwasher_N = mkN "lavastoviglie" feminine ; -- status=guess
lin dishwater_N = mkN "broda" ; -- status=guess
lin disillusion_N = mkN "disillusione" | mkN "disincanto" | mkN "disinganno" ; -- UWN
lin disillusionment_N = mkN "disillusione" | mkN "disincanto" | mkN "disinganno" ; -- UWN
lin disinclination_N = mkN "riluttanza" | mkN "tentennare" | mkN "tentennio" ; -- UWN
lin disinfection_N = mkN "disinfezione" feminine ; -- status=guess
lin disinfestation_N = mkN "disinfestazione" | mkN "disinfestione" ; -- UWN
lin disinflation_N = mkN "disinflazione" ; -- UWN
lin disintegrate_V = mkV "desintegrare" ; -- status=guess, src=wikt
lin disintegrate_V2 = mkV2 (mkV "desintegrare") ; -- status=guess, src=wikt
lin disintegration_N = mkN "annientamento" ; -- UWN
lin disinter_V2 = mkV2 (mkV "dissotterrare") ; -- status=guess, src=wikt
lin disinterestedness_N = mkN "disinteresse" ; -- UWN
lin disinterment_N = mkN "disseppellimento" | mkN "dissotterramento" | mkN "esumazione" | mkN "riesumazione" ; -- UWN
lin disinvestment_N = mkN "disinvestimento" ; -- UWN
lin disjointedly_Adv = mkAdv "sconnessamente" ; -- UWN
lin disjointedness_N = mkN "incoerenza" | mkN "sconnessione" ; -- UWN
lin disjunctive_A = mkA "disgiuntivo" ; -- UWN
lin disk_N = mkN "disco" ; -- status=guess
lin diskette_N = mkN "dischetto" | mkN "floppy disk" ; -- status=guess status=guess
lin dislike_N = mkN "antipatia" | mkN "avversione" feminine ; -- status=guess status=guess
lin dislodgement_N = mkN "sloggiamento" ; -- UWN
lin dislodgment_N = mkN "sloggiamento" ; -- UWN
lin disloyal_A = mkA "sleale" ; -- status=guess
lin disloyalty_N = mkN "bassezza" | mkN "dislealtà" | mkN "mala_fede" | mkN "malafede" | mkN "slealtà" ; -- UWN
lin dismantle_V2 = mkV2 (mkV "smontare") ; -- status=guess, src=wikt
lin dismantlement_N = mkN "smantellamento" | mkN "smontaggio" | mkN "smontatura" ; -- UWN
lin dismantling_N = mkN "smantellamento" | mkN "smontaggio" | mkN "smontatura" ; -- UWN
lin dismay_N = mkN "sbigottimento" | mkN "costernazione" feminine | mkN "smarrimento" ; -- status=guess status=guess status=guess
lin dismay_V = mkV "abbattere" | mkV "abbattersi" | mkV "mortificare" | mkV "mortificarsi" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin dismay_V2 = mkV2 (mkV "abbattere") | mkV2 (mkV "abbattersi") | mkV2 (mkV "mortificare") | mkV2 (mkV "mortificarsi") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin dismemberment_N = mkN "smembramento" ; -- UWN
lin dismiss_V2 = mkV2 (mkV "licenziare") | mkV2 (mkV "congedare") | mkV2 (mkV (mkV "mandare") "via") | mkV2 (dimettere_V) ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin dismissal_N = mkN "congedo" | mkN "licenziamento" ; -- UWN
lin dismount_V = mkV "smontarsi" ; -- status=guess, src=wikt
lin dismount_V2 = mkV2 (mkV "smontarsi") ; -- status=guess, src=wikt
lin disobedience_N = mkN "disobbedienza" | mkN "disubbidienza" ; -- UWN
lin disobedient_A = mkA "disubbidiente" ; -- status=guess
lin disobey_V2 = mkV2 (mkV "disubbidire") ; -- status=guess, src=wikt
lin disorder_N = mkN "disordine" ; -- status=guess
lin disorderly_A = mkA "disordinato" ; -- status=guess
lin disownment_N = mkN "ripudio" ; -- UWN
lin dispatch_N = mkN "spedizione" ; -- UWN
lin dispatcher_N = mkN "dispatcher" masculine ; -- status=guess
lin dispensable_A = mkA "superfluo" ; -- UWN
lin dispensation_N = mkN "deroga" ; -- status=guess
lin dispenser_N = mkN "distributore" masculine ; -- status=guess
lin dispersal_N = mkN "dispersione" | mkN "spandimento" | mkN "spanditura" | mkN "spargimento" | mkN "sparpagliamento" | mkN "sparpaglio" ; -- UWN
lin disperse_V = mkV "disseminarere" ; -- status=guess, src=wikt
lin disperse_V2 = mkV2 (mkV "disseminarere") ; -- status=guess, src=wikt
lin dispersion_N = mkN "dispersione" | mkN "spandimento" | mkN "spanditura" | mkN "spargimento" | mkN "sparpagliamento" | mkN "sparpaglio" ; -- UWN
lin display_N = mkN "schermo" | mkN "video" ; -- status=guess status=guess
lin display_V2 = variants {} ; --
lin display_VS = variants {} ; --
lin displeasure_N = mkN "dispiacere" | mkN "scontentezza" ; -- UWN
lin disposable_A = mkA "monouso" | mkA "usa e getta" ; -- status=guess status=guess
lin disposal_N = mkN "eliminazione" ; -- UWN
lin dispose_V = variants {} ; --
lin dispose_V2 = variants {} ; --
lin disposition_N = mkN "eliminazione" ; -- UWN
lin dispossession_N = mkN "escomio" | mkN "sfratto" ; -- UWN
lin disproportion_N = mkN "sproporzione" ; -- UWN
lin disproportionate_A = mkA "sproporzionato" ; -- UWN
lin disprove_VS = mkvVS "confutare" | mkvVS "smentire" ; -- UWN
lin disputation_N = mkN "contesa" | mkN "controversia" | mkN "discussione" | mkN "disputa" | mkN "litigio" | mkN "polemica" | mkN "rissa" ; -- UWN
lin dispute_N = mkN "disputa" | mkN "lite" | mkN "bega" ; -- status=guess status=guess status=guess
lin dispute_V = variants {} ; --
lin dispute_V2 = variants {} ; --
lin disquietude_N = mkN "inquietudine" feminine | mkN "preoccupazione" feminine ; -- status=guess status=guess
lin disquisition_N = mkN "disquisizione" ; -- UWN
lin disrepair_N = mkN "cattivo_stato" | mkN "sfacelo" ; -- UWN
lin disrepute_N = mkN "discredito" | mkN "scredito" | mkN "squalifica" ; -- UWN
lin disrobe_V = mkV "spogliare" | mkV "svestire" ; -- status=guess, src=wikt status=guess, src=wikt
lin disrobe_V2 = mkV2 (mkV "spogliare") | mkV2 (mkV "svestire") ; -- status=guess, src=wikt status=guess, src=wikt
lin disrupt_V = interrompere_V | mkV "impedire" ; -- status=guess, src=wikt status=guess, src=wikt
lin disrupt_V2 = mkV2 (interrompere_V) | mkV2 (mkV "impedire") ; -- status=guess, src=wikt status=guess, src=wikt
lin disruption_N = mkN "scompiglio" | mkN "sconvolgimento" ; -- status=guess status=guess
lin dissatisfaction_N = mkN "insoddisfazione" | mkN "mal_umore" | mkN "malcontento" | mkN "malumore" | mkN "scontento" ; -- UWN
lin dissect_V2 = mkV2 (mkV "dissecare") ; -- status=guess, src=wikt
lin dissection_N = mkN "dissezione" feminine ; -- status=guess
lin dissemble_V = mkV "fignere" | mkV "fingere" ; -- UWN
lin dissembler_N = mkN "chietino" | mkN "dissimulatore" | mkN "fariseo" | mkN "finto" | mkN "ipocrita" | mkN "simulatore" | mkN "tartufo" ; -- UWN
lin disseminate_V = mkV "comunicare" | mkV "diffondere" | mkV "diffondersi" | mkV "diramare" | mkV "divulgare" | mkV "propagare" | mkV "trasmettere" ; -- UWN
lin dissension_N = mkN "guerra" | mkN "scontro" ; -- UWN
lin dissent_N = mkN "protesta" ; -- UWN
lin dissent_V = mkV "divergere" ; -- UWN
lin dissenter_N = mkN "dissenziente" | mkN "dissidente" | mkN "obbiettore" | mkN "obiettore" ; -- UWN
lin dissertation_N = mkN "dissertazione" feminine ; -- status=guess
lin dissidence_N = mkN "dissenso" | mkN "dissidenza" ; -- UWN
lin dissident_N = mkN "dissidente" masculine ; -- status=guess
lin dissimilarity_N = mkN "difformità" | mkN "discordanza" | mkN "disformità" | mkN "sconcordanza" ; -- UWN
lin dissimilation_N = mkN "catabolismo" | mkN "disassimilazione" ; -- UWN
lin dissimilitude_N = mkN "dissimiglianza" | mkN "dissomiglianza" ; -- UWN
lin dissimulation_N = mkN "dissimulazione" feminine ; -- status=guess
lin dissociation_N = mkN "dissociazione" feminine ; -- status=guess
lin dissoluteness_N = mkN "dissolutezza" | mkN "sfrenatezza" | mkN "smoderatezza" | mkN "sregolatezza" ; -- UWN
lin dissolve_N = mkN "dissolvenza" ; -- status=guess
lin dissolve_V = variants {} ; --
lin dissolve_V2 = variants {} ; --
lin dissonance_N = mkN "dissonanza" ; -- UWN
lin dissuade_V2 = mkV2 (dissuadere_V) ; -- status=guess, src=wikt
lin dissuasive_A = mkA "dissuasivo" ; -- status=guess
lin dissyllable_N = mkN "bisillabo" ; -- UWN
lin distaff_N = mkN "conocchia" | mkN "rocca" ; -- UWN
lin distance_N = mkN "distanza" ; -- status=guess
lin distance_N3 = L.distance_N3 ; -- comment=CHECKED
lin distant_A = variants {} ; --
lin distaste_N = mkN "antipatia" | mkN "avversione" | mkN "contrarietà" | mkN "disgusto" | mkN "fobia" | mkN "idiosincrasia" | mkN "renitenza" | mkN "repugnanza" | mkN "ripugnanza" ; -- UWN
lin distemper_N = mkN "cimurro" ; -- status=guess
lin distillate_N = mkN "distillato" ; -- UWN
lin distillation_N = mkN "distillamento" | mkN "distillazione" | mkN "stillazione" ; -- UWN
lin distiller_N = mkN "distillatore" ; -- UWN
lin distillery_N = mkN "distilleria" ; -- status=guess
lin distinct_A = mkA "distinto" | mkA "distinta" | mkA "diverso" | mkA "diversa" ; -- status=guess status=guess status=guess status=guess
lin distinction_N = mkN "distinzione" ;
lin distinctive_A = variants {} ; --
lin distinctness_N = mkN "acutezza" | mkN "nettezza" | mkN "nitidezza" ; -- UWN
lin distinguish_V = variants {} ; --
lin distinguish_V2 = variants {} ; --
lin distinguishable_A = mkA "distinguibile" ; -- status=guess
lin distinguished_A = variants {} ; --
lin distort_V2 = mkV2 (mkV "deformare") ; -- status=guess, src=wikt
lin distortion_N = variants {} ; --
lin distract_V = distrarre_V ; -- status=guess, src=wikt
lin distract_V2 = mkV2 (distrarre_V) ; -- status=guess, src=wikt
lin distraction_N = mkN "distrazione" feminine ; -- status=guess
lin distraint_N = mkN "pignoramento" ; -- status=guess
lin distraught_A = mkA "distrutto" | mkA "colpito" ; -- status=guess status=guess
lin distress_N = variants {} ; --
lin distressing_A = mkA "desolante" | mkA "penoso" | mkA "doloroso" ; -- status=guess status=guess status=guess
lin distribute_V2 = mkV2 (mkV "distribuire") ; -- status=guess, src=wikt
lin distributed_A = variants {} ; --
lin distribution_N = mkN "distribuzione" feminine ; -- status=guess
lin distributional_A = mkA "distribuzionale" ; -- UWN
lin distributive_A = mkA "distributivo" ; -- UWN
lin distributor_N = variants {} ; --
lin district_N = mkN "distretto" ; -- status=guess
lin distrust_N = mkN "diffidenza" | mkN "diffidenza" ; -- status=guess status=guess
lin distrustful_A = mkA "malfidato" ; -- UWN
lin distrustfulness_N = mkN "diffidenza" | mkN "sfiducia" ; -- UWN
lin disturb_V2 = variants {} ; --
lin disturbance_N = variants {} ; --
lin disturbing_A = variants {} ;
lin disunion_N = mkN "dissensione" | mkN "disunione" | mkN "disunitezza" ; -- UWN
lin disunite_V = mkV "disgiungere" | mkV "disunire" | mkV "dividere" | mkV "separare" ; -- UWN
lin disunity_N = mkN "disunione" ; -- UWN
lin disuse_N = mkN "disuso" ; -- status=guess
lin disyllabic_A = mkA "bisillabo" | mkA "disillabico" ; -- status=guess status=guess
lin disyllable_N = mkN "bisillabo" | mkN "disillabo" ; -- status=guess status=guess
lin ditch_N = mkN "fossato" | mkN "trincea" | mkN "canale" masculine | mkN "canalone" masculine | mkN "canale di scarico" ; -- status=guess status=guess status=guess status=guess status=guess
lin ditto_N = mkN "fac-simile" ; -- status=guess
lin diurnal_A = mkA "diurno" ; -- status=guess
lin divan_N = mkN "diwan" masculine ; -- status=guess
lin divarication_N = mkN "divaricamento" | mkN "divaricazione" ; -- UWN
lin dive_N = mkN "affondata" | mkN "picchiata" ; -- UWN
lin dive_V = mkV "tuffarsi" ; -- status=guess, src=wikt
lin diver_N = mkN "tuffatore" | mkN "palombaro" | mkN "sommozzatore" ; -- status=guess status=guess status=guess
lin diverse_A = mkA "diverso" ; -- status=guess
lin diverseness_N = mkN "diversità" | mkN "molteplicità" | mkN "pluralità" | mkN "poliedricità" | mkN "svariatezza" | mkN "varietà" ; -- UWN
lin diversification_N = mkN "diversificazione" feminine ; -- status=guess
lin diversion_N = mkN "svago" ; -- status=guess
lin diversionist_N = mkN "sabotatore" ; -- UWN
lin diversity_N = mkN "diversità" feminine ; -- status=guess
lin divert_V = mkV "deviare" | mkV "dirottare" | mkV "sviare" ; -- UWN
lin diverticulitis_N = mkN "diverticolite" feminine ; -- status=guess
lin diverticulum_N = mkN "diverticolo" ; -- status=guess
lin divertimento_N = mkN "divertimento" | mkN "serenata" ; -- UWN
lin divide_N = mkN "displuvio" | mkN "spartiacque" ; -- UWN
lin divide_up_V2 = prepV2 OP_divide_V OP_up_Prep ; -- guess-p-verb
lin dividend_N = mkN "dividendo" ; -- status=guess
lin divider_N = mkN "spartitraffico" ; -- status=guess
lin divination_N = mkN "divinazione" feminine ; -- status=guess
lin divine_A = mkA "divino" | mkA "divina" ; -- status=guess status=guess
lin divine_N = mkN "divino" | mkN "divina" ; -- status=guess status=guess
lin divine_V = mkV "indovinare" ; -- status=guess, src=wikt
lin divine_V2 = mkV2 (mkV "indovinare") ; -- status=guess, src=wikt
lin diviner_N = mkN "aruspice" | mkN "divinatore" ; -- UWN
lin diving_N = mkN "campana subacquea" ; -- status=guess
lin divinity_N = mkN "divinità" feminine | mkN "deità" feminine ; -- status=guess status=guess
lin division_1_N = variants {} ; --
lin division_2_N = variants {} ; --
lin division_3_N = variants {} ; --
lin division_N = mkN "divisione" feminine ; -- status=guess
lin divisor_N = mkN "divisore" ; -- status=guess
lin divorce_N = mkN "divorzio" ; -- status=guess
lin divorce_V2 = mkV2 (mkV "divorziare") ; -- status=guess, src=wikt
lin divorcee_N = mkN "divorziato" | mkN "divorziata" | mkN "divorziati m plural" | mkN "divorziate f plural" ; -- status=guess status=guess status=guess status=guess
lin divulge_V2 = mkV2 (mkV "divulgare") ; -- status=guess, src=wikt
lin divulgence_N = mkN "divulgazione" ; -- UWN
lin dizziness_N = mkN "capogiro" | mkN "giracapo" | mkN "giramento" | mkN "giramento_di_testa" | mkN "vertigine" ; -- UWN
lin dj_N = mkN "deejey" | mkN "disc-jockey" | mkN "disc_jockey" | mkN "dj" ; -- UWN
lin djibouti_PN = mkPN "Gibuti" ; -- status=guess src=geonames
lin dm_N = mkN "decimetro" | mkN "dm" ; -- UWN
lin do_N = mkN "buonista" masculine ; -- status=guess
lin do_V2 = mkV2 (fare_V) ;
lin dobra_N = mkN "dobra" ; -- status=guess
lin docile_A = mkA "docile" | mkA "mansueto" ; -- status=guess status=guess
lin docility_N = mkN "arrendevolezza" | mkN "docilità" | mkN "mansuetudine" ; -- UWN
lin dock_N = variants {} ; --
lin dockage_N = mkN "amarraggio" | mkN "ammarraggio" | mkN "attraccaggio" | mkN "attracco" | mkN "ormeggio" ; -- UWN
lin docker_N = mkN "portuale" feminine | mkN "scaricatore" | mkN "scaricatore di porto" ; -- status=guess status=guess status=guess
lin docking_N = mkN "amarraggio" | mkN "ammarraggio" | mkN "attraccaggio" | mkN "attracco" | mkN "ormeggio" ; -- UWN
lin dockyard_N = mkN "arsenale" | mkN "cantiere" | mkN "darsena" ; -- UWN
lin doctor_N = L.doctor_N ;
lin doctor_V2 = mkV2 (mkV "curare") | mkV2 (mkV "medicare") ; -- status=guess, src=wikt status=guess, src=wikt
lin doctoral_A = mkA "dottorale" ; -- UWN
lin doctorate_N = mkN "dottorato" ; -- UWN
lin doctrinal_A = mkA "dottrinale" ; -- UWN
lin doctrine_N = mkN "dottrina" ; -- status=guess
lin document_N = mkN "documento" | mkN "carta" ; -- status=guess status=guess
lin document_V2 = variants {} ; --
lin documentary_N = mkN "documentario" ; -- UWN
lin documentation_N = mkN "documentazione" feminine ; -- status=guess
lin dodecagon_N = mkN "dodecagono" ; -- status=guess
lin dodecahedron_N = mkN "dodecaedro" ; -- status=guess
lin dodge_V = mkV "aggirare" | mkV "eludere" | mkV "evitare" | mkV "scansare" | mkV "schivare" | mkV "sottrarsi" ; -- UWN
lin dodgy_A = mkA "anormale" ; -- status=guess
lin dodo_N = mkN "dodo" | mkN "dronte" masculine ; -- status=guess status=guess
lin doe_N = mkN "cerva" ; -- status=guess
lin dog_N = L.dog_N ;
lin doge_N = mkN "doge" masculine ; -- status=guess
lin doggedly_Adv = mkAdv "tenacemente" ; -- UWN
lin doggy_N = mkN "cagnolino" ; -- status=guess
lin doghouse_N = mkN "canile" | mkN "cuccia" ; -- UWN
lin dogmatic_A = mkA "dogmatico" ; -- status=guess
lin dogmatism_N = mkN "bacchettonaggine" | mkN "bacchettoneria" | mkN "beghinaggio" | mkN "bigotteria" | mkN "bigottismo" | mkN "santocchieria" ; -- UWN
lin dogwood_N = mkN "sanguinella" ; -- status=guess
lin doh_N = mkN "do" ; -- UWN
lin doing_N = variants {} ; --
lin doll_N = mkN "bambola" ; -- status=guess
lin dollar_N = mkN "dollar" ;
lin dolly_N = mkN "bambola" | mkN "bambolina" | mkN "bambolotto" | mkN "fantoccio" | mkN "pupattola" | mkN "pupazzo" ; -- UWN
lin dolmen_N = mkN "dolmen" ; -- UWN
lin dolomite_N = mkN "dolomite" ; -- UWN
lin dolor_N = mkN "dolore" masculine ; -- status=guess
lin dolour_N = mkN "dolore" masculine ; -- status=guess
lin dolphin_N = mkN "delfino" ; -- status=guess
lin dolt_N = mkN "allocco" | mkN "arteriosclerotico" | mkN "babbeo" | mkN "babbuino" | mkN "balordo" | mkN "broccolo" | mkN "citrullo" | mkN "ebete" | mkN "gnocco" | mkN "grullo" | mkN "rimbambito" | mkN "scioccone" | mkN "stupido" | mkN "svanitello" | mkN "svaporato" | mkN "tonto" ; -- UWN
lin domain_N = mkN "dominio" ; -- status=guess
lin dome_N = mkN "cupola" ;
lin domestic_A = mkA "domestico" | mkA "domestica" ; -- status=guess status=guess
lin domestic_N = mkN "violenza domestica" ; -- status=guess
lin domicile_N = mkN "domicilio" ; -- status=guess
lin domiciliary_A = mkA "domiciliare" ; -- UWN
lin dominance_N = mkN "ascendente" | mkN "controllo" | mkN "predominio" ; -- UWN
lin dominant_A = variants {} ; --
lin dominate_V = mkV "dominare" | mkV "predominare" | mkV "prevalere" | mkV "regnare" ; -- UWN
lin dominate_V2 = variants {} ; --
lin domination_N = mkN "dominazione" feminine ; -- status=guess
lin domineer_V = mkV "tiranneggiare" ; -- UWN
lin dominica_PN = mkPN "Dominica" ; -- status=guess src=geonames
lin domino_N = mkN "effetto domino" ; -- status=guess
lin don_N = mkN "don" masculine ; -- status=guess
lin don_PN = mkPN "Don" ; -- status=guess src=geonames
lin don_V2 = mkV2 (mettere_V) | mkV2 (mkV "indossare") | mkV2 (mkV "portare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin donate_V = mkV "donare" ; -- status=guess, src=wikt
lin donate_V2 = mkV2 (mkV "donare") ; -- status=guess, src=wikt
lin donation_N = mkN "donazione" feminine ; -- status=guess
lin doncaster_PN = mkPN "Doncaster" ; -- status=guess src=geonames
lin donegal_PN = mkPN "Donegal" ; -- status=guess src=geonames
lin donetsk_PN = mkPN "Donec'k" ; -- status=guess src=geonames
lin dong_N = mkN "dong" | mkN "dong_vietnamita" ; -- UWN
lin donkey_N = mkN "asino" | mkN "somaro" ; -- status=guess status=guess
lin donna_N = mkN "donna" ; -- UWN
lin donor_N = mkN "donatore" | mkN "offerente" ; -- status=guess status=guess
lin doodle_V = mkV "scarabocchiare" ; -- UWN
lin doom_N = mkN "sentenza" | mkN "morte" feminine ; -- status=guess status=guess
lin door_N = L.door_N ;
lin doorbell_N = mkN "campanello" ; -- status=guess
lin doorknob_N = mkN "pomello" ; -- status=guess
lin doorknocker_N = mkN "batacchio" | mkN "battacchio" | mkN "battaglio" | mkN "battente" | mkN "bussatoio" | mkN "campanella" | mkN "picchiotto" ; -- UWN
lin doorman_N = mkN "buttafuori" masculine ; -- status=guess
lin doormat_N = mkN "zerbino" ; -- status=guess
lin doorsill_N = mkN "limitare" | mkN "soglia" ; -- UWN
lin doorstep_N = mkN "limitare" | mkN "soglia" ; -- UWN
lin doorway_N = mkN "uscio" | mkN "via di accesso" ; -- status=guess status=guess
lin dopamine_N = mkN "dopamina" ; -- status=guess
lin doppelganger_N = mkN "gemello malvagio" ; -- status=guess
lin dora_PN = mkPN "Dora" ; -- status=guess src=geonames
lin dorchester_PN = mkPN "Dorchester" ; -- status=guess src=geonames
lin dordrecht_PN = mkPN "Dordrecht" ; -- status=guess src=geonames
lin dorking_PN = mkPN "Dorking" ; -- status=guess src=geonames
lin dormant_A = mkA "inattivo" | mkA "quiescente" ; -- UWN
lin dormer_N = mkN "abbaino" ; -- status=guess
lin dormitory_N = mkN "dormitorio" ; -- status=guess
lin dormouse_N = mkN "ghiro" | mkN "moscardino" ; -- status=guess status=guess
lin dortmund_PN = mkPN "Dortmund" ; -- status=guess src=geonames
lin dose_N = mkN "dose" feminine ; -- status=guess
lin dot_N = mkN "punto" ; -- status=guess
lin dotage_N = mkN "istupidimento" | mkN "rimbambimento" | mkN "rimbecillimento" ; -- UWN
lin douai_PN = mkPN "Douai" ; -- status=guess src=geonames
lin double_A = mkA "doppio" | mkA "doppia" ; -- status=guess status=guess
lin double_N = mkN "doppio" ; -- status=guess
lin double_V = mkV "raddoppiare" | mkV "raddoppiarsi" ; -- UWN
lin double_V2 = variants {} ; --
lin double_as_V2 = prepV2 OP_double_V OP_as_Prep ; -- guess-p-verb
lin double_back_V = advV OP_double_V OP_back_Adv ; -- guess-p-verb
lin double_check_V2 = variants {} ; -- guess-p-verb
lin double_cross_V2 = variants {} ; -- guess-p-verb
lin double_over_V = advV OP_double_V OP_over_Adv ; -- guess-p-verb
lin double_park_V = variants {} ; -- guess-p-verb
lin double_park_V2 = variants {} ; -- guess-p-verb
lin double_up_V = advV OP_double_V OP_up_Adv ; -- guess-p-verb
lin double_up_as_V2 = prepV2 (advV OP_double_V OP_up_Adv ) OP_as_Prep ; -- guess-p-verb
lin doublet_N = mkN "farsetto" ; -- status=guess
lin doubling_N = mkN "raddoppio" ; -- UWN
lin doubt_N = mkN "dubbio" ; -- status=guess
lin doubt_V2 = mkV2 (mkV "dubitare") ; -- status=guess, src=wikt
lin doubt_VS = mkVS (mkV "dubitare") ; -- status=guess, src=wikt
lin doubtful_A = variants {} ; --
lin doubtless_Adv = variants {} ; --
lin dough_N = mkN "pasta" | mkN "impasto" ; -- status=guess status=guess
lin doughnut_N = mkN "bombolone" masculine ; -- status=guess
lin douglas_PN = mkPN "Douglas" ; -- status=guess src=geonames
lin dove_N = mkN "colomba" | mkN "piccione" masculine ; -- status=guess status=guess
lin dover_PN = mkPN "Dover" ; -- status=guess src=geonames
lin dowdy_N = mkN "sciattona" ; -- UWN
lin dowel_N = mkN "tassello" | mkN "piolo" ; -- status=guess status=guess
lin down_A = mkA "giù" ; -- status=guess
lin down_Adv = mkAdv "giù" ;
lin down_N = mkN "piumino" ; -- status=guess
lin down_Prep = variants {} ; --
lin downheartedness_N = mkN "scoramento" ; -- UWN
lin downhill_N = mkN "discesa libera" ; -- status=guess
lin downpour_N = mkN "acquazzone" masculine ; -- status=guess
lin downrightness_N = mkN "franchezza" | mkN "schiettezza" ; -- UWN
lin downstairs_Adv = mkAdv "giù" ; -- status=guess
lin downtime_N = mkN "tempi_morti" ; -- UWN
lin downward_Adv = mkAdv "giù" | mkAdv "ingiù" ; -- UWN
lin downwards_Adv = mkAdv "giù" | mkAdv "ingiù" ; -- UWN
lin dowry_N = mkN "dote" feminine ; -- status=guess
lin dowser_N = mkN "rabdomante" ; -- status=guess
lin doxology_N = mkN "dossologia" ; -- status=guess
lin doyen_N = mkN "decano" ; -- status=guess
lin doze_V = mkV "sonnecchiare" | mkV "dormicchiare" ; -- status=guess, src=wikt status=guess, src=wikt
lin dozen_N = mkN "centinaia" | mkN "migliaia" ; -- status=guess status=guess
lin drachma_N = mkN "dracma" ; -- status=guess
lin draconian_A = mkA "draconiano" ; -- status=guess
lin draft_N = mkN "sorso" ; -- status=guess
lin draft_V2 = mkV2 (mkV "arruolare") ; -- status=guess, src=wikt
lin draftee_N = mkN "coscritto" | mkN "soldato di leva" ; -- status=guess status=guess
lin drafter_N = mkN "minutante" ; -- UWN
lin drag_V = mkV "trainare" ; -- status=guess, src=wikt
lin drag_V2 = mkV2 (mkV "trainare") ; -- status=guess, src=wikt
lin drag_down_V = advV OP_drag_V OP_down_Adv ; -- guess-p-verb
lin drag_in_V = advV OP_drag_V OP_in_Adv ; -- guess-p-verb
lin drag_on_V = advV OP_drag_V OP_on_Adv ; -- guess-p-verb
lin dragnet_N = mkN "cocchia" | mkN "draga" | mkN "palamite" | mkN "palamito" | mkN "palangaro" | mkN "rete_a_strascico" | mkN "tartana" ; -- UWN
lin dragon_N = mkN "drago" | mkN "dragone" | mkN "viverna" ; -- status=guess status=guess status=guess
lin dragonfly_N = mkN "libellula" ; -- status=guess
lin dragoon_N = mkN "dragone" ; -- status=guess
lin drain_N = mkN "scolo" ; -- status=guess
lin drainage_N = mkN "bacino idrografico" | mkN "bacino imbrifero" ; -- status=guess status=guess
lin drake_N = mkN "maschio dell'anatra" ; -- status=guess
lin drama_N = mkN "drammaticità" ; -- UWN
lin dramatic_A = variants {} ; --
lin dramaturgy_N = mkN "drammaturgia" | mkN "teatro" ; -- UWN
lin drape_V2 = mkV2 (mkV "drappeggiare") | mkV2 (mkV "tappezzare") ; -- status=guess, src=wikt status=guess, src=wikt
lin draper_N = mkN "drapperia" ; -- status=guess
lin drastic_A = mkA "drastico" ; -- status=guess
lin draught_N = mkN "tiro" | mkN "trazione" feminine ; -- status=guess status=guess
lin draughts_N = mkN "dama" ; -- status=guess
lin draughtsman_N = mkN "disegnatore" masculine ; -- status=guess
lin draw_1_V2 = variants {} ; --
lin draw_2_V2 = variants {} ; --
lin draw_N = mkN "riffa" ; -- status=guess
lin draw_V = trarre_V ; -- status=guess, src=wikt
lin draw_V2 = mkV2 (trarre_V) ; -- status=guess, src=wikt
lin draw_back_V2 = mkV2 (advV OP_draw_V OP_back_Adv ) ; -- guess-p-verb
lin draw_down_V2 = prepV2 OP_draw_V OP_down_Prep ; -- guess-p-verb
lin draw_even_V = advV OP_draw_V OP_even_Adv ; -- guess-p-verb
lin draw_in_V = advV OP_draw_V OP_in_Adv ; -- guess-p-verb
lin draw_into_V2 = prepV2 OP_draw_V OP_into_Prep ; -- guess-p-verb
lin draw_off_V = advV OP_draw_V OP_off_Adv ; -- guess-p-verb
lin draw_on_V = advV OP_draw_V OP_on_Adv ; -- guess-p-verb
lin draw_on_V2 = prepV2 OP_draw_V OP_on_Prep ; -- guess-p-verb
lin draw_out_V2 = prepV2 OP_draw_V OP_out_Prep ; -- guess-p-verb
lin draw_up_V = advV OP_draw_V OP_up_Adv ; -- guess-p-verb
lin draw_up_V2 = prepV2 OP_draw_V OP_up_Prep ; -- guess-p-verb
lin drawback_N = mkN "svantaggio" ; -- status=guess
lin drawbridge_N = mkN "ponte levatoio" ; -- status=guess
lin drawee_N = mkN "trassato" | mkN "trattario" ; -- UWN
lin drawer_N = mkN "disegnatore" masculine ; -- status=guess
lin drawing_N = mkN "disegno" ; -- status=guess
lin dray_N = mkN "carro" | mkN "carretta" ; -- status=guess status=guess
lin dreadful_A = variants {} ; --
lin dream_N = mkN "sogno" ; -- status=guess
lin dream_V = mkV "sognare" ; -- status=guess, src=wikt
lin dream_V2 = mkV2 (mkV "sognare") ; -- status=guess, src=wikt
lin dream_of_V2 = prepV2 OP_dream_V OP_of_Prep ; -- guess-p-verb
lin dream_up_V2 = prepV2 OP_dream_V OP_up_Prep ; -- guess-p-verb
lin dreamland_N = mkN "mondo_dei_sogni" | mkN "paese_dei_sogni" ; -- UWN
lin dreamworld_N = mkN "mondo_dei_sogni" | mkN "paese_dei_sogni" ; -- UWN
lin dreary_A = mkA "melanconico" | mkA "malinconico" ; -- status=guess status=guess
lin dredge_V = mkV "spolverare" ; -- status=guess, src=wikt
lin dredge_V2 = mkV2 (mkV "spolverare") ; -- status=guess, src=wikt
lin dregs_N = mkN "sedimento" ; -- status=guess
lin drench_V2 = mkV2 (mkV "bagnare") | mkV2 (mkV "infradiciare") ; -- status=guess, src=wikt status=guess, src=wikt
lin drenching_N = mkN "ammollamento" ; -- UWN
lin dresden_PN = mkPN "Dresda" ; -- status=guess src=geonames
lin dress_N = mkN "abbigliamento" ; -- status=guess
lin dress_V = mkV "vestire" ; -- status=guess, src=wikt
lin dress_V2 = mkV2 (mkV "vestire") ; -- status=guess, src=wikt
lin dress_down_V = advV OP_dress_V OP_down_Adv ; -- guess-p-verb
lin dress_down_V2 = prepV2 OP_dress_V OP_down_Prep ; -- guess-p-verb
lin dress_up_V = advV OP_dress_V OP_up_Adv ; -- guess-p-verb
lin dress_up_V2 = prepV2 OP_dress_V OP_up_Prep ; -- guess-p-verb
lin dresser_N = mkN "cassettone" masculine | mkN "comò" ; -- status=guess status=guess
lin dressing_N = mkN "vestaglia" ; -- status=guess
lin dressmaker_N = mkN "sarta" ; -- status=guess
lin dressmaking_N = mkN "confezione" ; -- UWN
lin dribble_N = mkN "bava" ; -- status=guess
lin dribble_V = mkV "sbrodolare" ; -- status=guess, src=wikt
lin dribble_V2 = mkV2 (mkV "sbrodolare") ; -- status=guess, src=wikt
lin driblet_N = mkN "goccia" | mkN "goccio" | mkN "gocciola" | mkN "gocciolo" | mkN "lacrima" | mkN "lagrima" ; -- UWN
lin driffield_PN = mkPN "Driffield" ; -- status=guess src=geonames
lin drift_N = variants {} ; --
lin drift_V = variants {} ; --
lin drift_V2 = variants {} ; --
lin drifter_N = mkN "vagabondo" | mkN "giramondo" ; -- status=guess status=guess
lin drill_N = mkN "esercitazione" feminine ; -- status=guess
lin drill_V = mkV "scavare" ; -- status=guess, src=wikt
lin drill_V2 = mkV2 (mkV "scavare") ; -- status=guess, src=wikt
lin drilling_N = mkN "perforazione" | mkN "sondaggio" | mkN "trapanatura" ; -- UWN
lin drink_N = mkN "bevuta" ; -- status=guess
lin drink_V = bere_V | mkV (bere_V) "alcolici" ; -- status=guess, src=wikt status=guess, src=wikt
lin drink_V2 = L.drink_V2 ;
lin drink_up_V2 = prepV2 OP_drink_V OP_up_Prep ; -- guess-p-verb
lin drinkable_A = mkA "potabile" ; -- status=guess
lin drinker_N = mkN "beone" | mkN "bevitore" | mkN "bevone" ; -- UWN
lin drinking_N = mkN "cannuccia" ; -- status=guess
lin drip_V = mkV "sgocciolare" | mkV "stillare" ; -- UWN
lin drippiness_N = mkN "leziosaggine" | mkN "romanticheria" | mkN "sdolcinatezza" | mkN "sentimentalismo" | mkN "smancerie" ; -- UWN
lin dripstone_N = mkN "gocciolatoio" ; -- status=guess
lin drive_N = variants {} ; --
lin drive_V = mkV "rendere" ; -- status=guess, src=wikt
lin drive_V2 = mkV2 (mkV "rendere") ; -- status=guess, src=wikt
lin drive_V2V = mkV2V (mkV "rendere") ; -- status=guess, src=wikt
lin drive_away_V2 = mkV2 (advV OP_drive_V OP_away_Adv ) ; -- guess-p-verb
lin drive_back_V2 = mkV2 (advV OP_drive_V OP_back_Adv ) ; -- guess-p-verb
lin drive_by_V = advV OP_drive_V OP_by_Adv ; -- guess-p-verb
lin drive_down_V = advV OP_drive_V OP_down_Adv ; -- guess-p-verb
lin drive_off_V = advV OP_drive_V OP_off_Adv ; -- guess-p-verb
lin drive_out_V2 = prepV2 OP_drive_V OP_out_Prep ; -- guess-p-verb
lin drive_up_V = advV OP_drive_V OP_up_Adv ; -- guess-p-verb
lin drive_up_V2 = prepV2 OP_drive_V OP_up_Prep ; -- guess-p-verb
lin drivel_V = mkV "sbavare" ; -- UWN
lin driverFem_N = variants {} ; ---- sense to be split
lin driverMasc_N = mkN "patente di guida" ; -- status=guess
lin driveshaft_N = mkN "semiasse" ; -- UWN
lin driving_A = variants {} ; --
lin driving_N = mkN "guida" ; -- UWN
lin drizzle_N = mkN "pioggerella" ; -- status=guess
lin drogheda_PN = mkPN "Drogheda" ; -- status=guess src=geonames
lin droitwich_PN = mkPN "Droitwich" ; -- status=guess src=geonames
lin dromedary_N = mkN "dromedario" ; -- status=guess
lin drone_N = mkN "gonzo" | mkN "zimbello" ; -- status=guess status=guess
lin dronfield_PN = mkPN "Dronfield" ; -- status=guess src=geonames
lin drool_N = mkN "bava" ; -- status=guess
lin drool_V = mkV "sbavare" ; -- status=guess, src=wikt
lin drop_N = mkN "caduta" ; -- status=guess
lin drop_V = mkV "scaricare" ; -- status=guess, src=wikt
lin drop_V2 = mkV2 (mkV "scaricare") ; -- status=guess, src=wikt
lin drop_around_V = advV OP_drop_V OP_around_Adv ; -- guess-p-verb
lin drop_around_V2 = prepV2 OP_drop_V OP_around_Prep ; -- guess-p-verb
lin drop_away_V = advV OP_drop_V OP_away_Adv ; -- guess-p-verb
lin drop_back_V = advV OP_drop_V OP_back_Adv ; -- guess-p-verb
lin drop_by_V = advV OP_drop_V OP_by_Adv ; -- guess-p-verb
lin drop_in_V = advV OP_drop_V OP_in_Adv ; -- guess-p-verb
lin drop_in_on_V2 = prepV2 (advV OP_drop_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin drop_off_V = advV OP_drop_V OP_off_Adv ; -- guess-p-verb
lin drop_off_V2 = prepV2 OP_drop_V OP_off_Prep ; -- guess-p-verb
lin drop_out_V = advV OP_drop_V OP_out_Adv ; -- guess-p-verb
lin drop_out_of_V2 = prepV2 (advV OP_drop_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin drop_over_V = advV OP_drop_V OP_over_Adv ; -- guess-p-verb
lin drop_round_V = advV OP_drop_V OP_round_Adv ; -- guess-p-verb
lin drop_round_V2 = prepV2 OP_drop_V OP_round_Prep ; -- guess-p-verb
lin drop_someone_in_it_V2 = variants {} ; -- guess-p-verb
lin drop_through_V = advV OP_drop_V OP_through_Adv ; -- guess-p-verb
lin droplet_N = mkN "gocciolina" ; -- status=guess
lin dropper_N = mkN "contagocce" ; -- UWN
lin droppings_N = mkN "escremento" | mkN "stallatico" | mkN "sterco" ; -- UWN
lin drought_N = mkN "siccità" feminine ; -- status=guess
lin drover_N = mkN "mandriano" | mkN "bovaro" ; -- status=guess status=guess
lin drown_V = mkV "affogare" | mkV "annegare" ; -- status=guess, src=wikt status=guess, src=wikt
lin drown_V2 = mkV2 (mkV "affogare") | mkV2 (mkV "annegare") ; -- status=guess, src=wikt status=guess, src=wikt
lin drowsiness_N = mkN "addormentamento" | mkN "assopimento" | mkN "sonno" | mkN "sonnolenza" | mkN "sopore" ; -- UWN
lin drowsy_A = mkA "soporifero" ; -- status=guess
lin drudge_V = mkV "sfaccendare" | mkV "sfacchinare" | mkV "sfaticare" ; -- UWN
lin drudgery_N = mkN "facchinata" ; -- UWN
lin drug_N = mkN "droga" | mkN "narcotico" ; -- status=guess status=guess
lin drug_V2 = mkV2 (mkV "drogare") ; -- status=guess, src=wikt
lin drugstore_N = mkN "farmacia" ; -- UWN
lin druid_N = mkN "druida" masculine ;
lin drum_N = mkN "bidone" masculine ; -- status=guess
lin drumlin_N = mkN "collina_morenica" ; -- UWN
lin drummer_N = mkN "batterista" | mkN "tamburino" | mkN "tamburo" ; -- UWN
lin drumstick_N = mkN "bacchetta" ; -- status=guess
lin drunk_A = mkA "ubriaco" | mkA "avvinazzato" | mkA "ebbro" | mkA "sborniato" ; -- status=guess status=guess status=guess status=guess
lin drunkard_N = mkN "ubriacone" | mkN "ubriacona" ; -- status=guess status=guess
lin drunken_A = mkA "ubriaco" | mkA "ebbro" ; -- status=guess status=guess
lin drunkenness_N = mkN "ubriachezza" ; -- status=guess
lin drupaceous_A = mkA "drupaceo" ; -- UWN
lin dry_A = L.dry_A ;
lin dry_N = mkN "lavaggio a secco" ; -- status=guess
lin dry_V = mkV "asciugarsi" ; -- status=guess, src=wikt
lin dry_V2 = mkV2 (mkV "asciugarsi") ; -- status=guess, src=wikt
lin dry_clean_V2 = mkV2 (advV OP_dry_V OP_clean_Adv ) ; -- guess-p-verb
lin dry_off_V2 = prepV2 OP_dry_V OP_off_Prep ; -- guess-p-verb
lin dry_out_V = mkV "asciugare" | mkV "disidratare" | mkV "essicare" | mkV "essiccare" | mkV "seccare" ; -- UWN
lin dry_out_V2 = prepV2 OP_dry_V OP_out_Prep ; -- guess-p-verb
lin dry_up_V = advV OP_dry_V OP_up_Adv ; -- guess-p-verb
lin dry_up_V2 = prepV2 OP_dry_V OP_up_Prep ; -- guess-p-verb
lin dryad_N = mkN "driade" feminine ; -- status=guess
lin drygoods_N = mkN "teleria" ; -- UWN
lin dual_A = variants {} ; --
lin dualism_N = mkN "dualismo" ; -- UWN
lin dualist_N = mkN "dualista" ; -- UWN
lin dub_V2 = mkV2 (mkV "doppiare") ; -- status=guess, src=wikt
lin dub_V3 = mkV3 (mkV "doppiare") ; -- status=guess, src=wikt
lin dubbing_N = mkN "doppiaggio" ; -- UWN
lin dubiety_N = mkN "dubbio" | mkN "dubbiosità" | mkN "forse" | mkN "incertezza" | mkN "problematicità" ; -- UWN
lin dubious_A = mkA "dubbio" | mkA "equivoco" | mkA "ambiguo" | mkA "losco" | mkA "bieco" | mkA "torvo" ; -- status=guess status=guess status=guess status=guess status=guess status=guess
lin dubiousness_N = mkN "dubbio" | mkN "incertezza" | mkN "interrogativo" ; -- UWN
lin dublin_PN = mkPN "Dublino" ; -- status=guess src=geonames
lin dubnium_N = mkN "dubnio" ; -- status=guess
lin ducal_A = mkA "ducale" ; -- UWN
lin ducat_N = mkN "ducato" ; -- status=guess
lin duce_N = mkN "duce" ; -- UWN
lin duchess_N = mkN "duchessa" ; -- status=guess
lin duchy_N = mkN "ducato" ; -- status=guess
lin duck_N = mkN "anatra" | mkN "papero" ; -- status=guess status=guess
lin duck_V = mkV "aggirare" | mkV "eludere" | mkV "evitare" | mkV "scansare" | mkV "schivare" | mkV "sottrarsi" ; -- UWN
lin ducking_N = mkN "immersione" ; -- UWN
lin duckling_N = mkN "anatroccolo" ; -- status=guess
lin duckweed_N = mkN "lemna" ; -- UWN
lin duct_N = mkN "condotto" ; -- status=guess
lin ductile_A = mkA "duttile" ; -- status=guess
lin ductility_N = mkN "duttilità" feminine ; -- status=guess
lin dude_N = mkN "tipo" ; -- status=guess
lin dudley_PN = mkPN "Dudley" ; -- status=guess src=geonames
lin due_A = variants {} ; --
lin duel_N = mkN "duello" | mkN "singolar tenzone" ; -- status=guess status=guess
lin duel_V = mkV "duellare" ; -- status=guess, src=wikt
lin dueler_N = mkN "duellante" ; -- UWN
lin duellist_N = mkN "duellante" ; -- UWN
lin duet_N = mkN "duetto" | mkN "duo" ; -- status=guess status=guess
lin duff_N = mkN "sedere" masculine | mkN "chiappe" feminine | mkN "deretano" ; -- status=guess status=guess status=guess
lin duffel_N = mkN "montgomery" ; -- status=guess
lin duffer_N = mkN "schiappa" ; -- UWN
lin dugong_N = mkN "dugongo" ; -- status=guess
lin dugout_N = mkN "bunker" ; -- UWN
lin duisburg_PN = mkPN "Duisburg" ; -- status=guess src=geonames
lin duke_N = mkN "duca" masculine ; -- status=guess
lin dukedom_N = mkN "ducato" ; -- UWN
lin dukinfield_PN = mkPN "Dukinfield" ; -- status=guess src=geonames
lin dulcimer_N = mkN "dulcimero" | mkN "salterio" ; -- status=guess status=guess
lin dull_A = L.dull_A ;
lin duly_Adv = variants {} ; --
lin dumb_A = mkA "stupido" ; -- status=guess
lin dumbarton_PN = mkPN "Dumbarton" ; -- status=guess src=geonames
lin dumbbell_N = mkN "manubrio" ; -- status=guess
lin dumbwaiter_N = mkN "calapranzi" | mkN "montavivande" ; -- UWN
lin dumfries_PN = mkPN "Dumfries" ; -- status=guess src=geonames
lin dummy_N = mkN "ciuccio" | mkN "ciucciotto" | mkN "succhiotto" ; -- status=guess status=guess status=guess
lin dump_N = mkN "discarica" ; -- status=guess
lin dump_V = mkV "riversare" | mkV (mkV "scaricare") "dati" ; -- status=guess, src=wikt status=guess, src=wikt
lin dump_V2 = mkV2 (mkV "riversare") | mkV2 (mkV (mkV "scaricare") "dati") ; -- status=guess, src=wikt status=guess, src=wikt
lin dumpling_N = mkN "gnocco" ; -- status=guess
lin dumps_N = mkN "paturne" | mkN "paturnie" ; -- UWN
lin dumpy_A = mkA "tarchiato" | mkA "tarchiata" ; -- status=guess status=guess
lin duncan_PN = mkPN "Duncan" ; -- status=guess src=geonames
lin dundalk_PN = mkPN "Dundalk" ; -- status=guess src=geonames
lin dundee_PN = mkPN "Dundee" ; -- status=guess src=geonames
lin dune_N = mkN "duna" ; -- status=guess
lin dunfermline_PN = mkPN "Dunfermline" ; -- status=guess src=geonames
lin dung_N = mkN "escremento" | mkN "feci" feminine | mkN "sterco" ; -- status=guess status=guess status=guess
lin dungeon_N = mkN "torrione" masculine ; -- status=guess
lin dunkirk_PN = mkPN "Dunkirk" ; -- status=guess src=geonames
lin dunoon_PN = mkPN "Dunoon" ; -- status=guess src=geonames
lin dunstable_PN = mkPN "Dunstable" ; -- status=guess src=geonames
lin duodenal_A = mkA "duodenale" ; -- status=guess
lin duodenum_N = mkN "duodeno" ; -- UWN
lin dupe_N = mkN "vittima" ; -- UWN
lin duplicate_V2 = mkV2 (mkV "duplicare") ; -- status=guess, src=wikt
lin duplication_N = mkN "duplicazione" ; -- UWN
lin duplicator_N = mkN "ciclostile" | mkN "ciclostilo" | mkN "copiatrice" | mkN "duplicatore" ; -- UWN
lin durable_A = mkA "durabile" ; -- status=guess
lin duration_N = mkN "durata" ; -- status=guess
lin durban_PN = mkPN "Durban" ; -- status=guess src=geonames
lin duress_N = mkN "costrizione" ; -- UWN
lin durham_PN = mkPN "Durham" ; -- status=guess src=geonames
lin durian_N = mkN "durian" masculine ; -- status=guess
lin during_Prep = S.during_Prep ;
lin durrington_PN = mkPN "Durrington" ; -- status=guess src=geonames
lin dursley_PN = mkPN "Dursley" ; -- status=guess src=geonames
lin dusk_N = mkN "crepuscolo" | mkN "tramonto" ; -- status=guess status=guess
lin dust_N = L.dust_N ;
lin dust_V2 = mkV2 (mkV "spolverare") ; -- status=guess, src=wikt
lin dustcloth_N = mkN "canavaccio" | mkN "canovaccio" | mkN "cencio" | mkN "straccio" ; -- UWN
lin dustman_N = mkN "netturbino" | mkN "spazzaturaio" ; -- UWN
lin dustpan_N = mkN "paletta" | mkN "paletta della spazzatura" ; -- status=guess status=guess
lin dusty_A = mkA "polveroso" | mkA "impolverato" ; -- status=guess status=guess
lin dutchFem_N = mkN "olandese" feminine ;
lin dutchMasc_N = mkN "olandese" ;
lin dutch_A = mkA "olandese" ;
lin duty_N = mkN "tassa" | mkN "dazio" ; -- status=guess status=guess
lin duvet_N = mkN "piumone" masculine ; -- status=guess
lin dwarf_N = mkN "nana" ; -- status=guess
lin dwarfishness_N = mkN "microsomia" | mkN "nanismo" ; -- UWN
lin dwarfism_N = mkN "nanismo" ; -- status=guess
lin dwell_V = mkV "abitare" | mkV "dimorare" ; -- status=guess, src=wikt status=guess, src=wikt
lin dweller_N = mkN "abitante" | mkN "abitatore" | mkN "anima" | mkN "popolatore" | mkN "residente" ; -- UWN
lin dwelling_N = mkN "abitazione" feminine | mkN "residenza" | mkN "dimora" ; -- status=guess status=guess status=guess
lin dwindle_V = mkV "restringersi" | mkV "diminuire" ; -- status=guess, src=wikt status=guess, src=wikt
lin dyadic_A = mkA "diadico" ; -- status=guess
lin dyarchy_N = mkN "diarchia" | mkN "duopolio" ; -- UWN
lin dye_N = mkN "tintura" ; -- status=guess
lin dye_V = mkV "tingere" ; -- status=guess, src=wikt
lin dye_V2 = mkV2 (mkV "tingere") ; -- status=guess, src=wikt
lin dyeing_N = mkN "tintura" ; -- UWN
lin dyer_N = mkN "tintore" ; -- UWN
lin dyestuff_N = mkN "colorante" | mkN "tinta" | mkN "tintura" ; -- UWN
lin dyke_N = mkN "lesbica" ; -- status=guess
lin dynamic_A = mkA "dinamico" | mkA "dinamica" ; -- status=guess status=guess
lin dynamics_N = mkN "dinamica" ; -- status=guess
lin dynamism_N = mkN "dinamicità" | mkN "dinamismo" ; -- UWN
lin dynamite_N = mkN "dinamite" ; -- UWN
lin dynamiter_N = mkN "dinamitardo" ; -- UWN
lin dynamo_N = mkN "dinamo" ; -- status=guess
lin dynamometer_N = mkN "dinamometro" ; -- status=guess
lin dynast_N = mkN "dinasta" | mkN "monarca" ; -- UWN
lin dynastic_A = mkA "dinastico" ; -- UWN
lin dynasty_N = mkN "dinastia" ; -- status=guess
lin dyne_N = mkN "dina" | mkN "dine" ; -- UWN
lin dysentery_N = mkN "dissenteria" ; -- status=guess
lin dysfunction_N = mkN "disfunzione" feminine ; -- status=guess
lin dysfunctional_A = mkA "disfunzionale" ; -- status=guess
lin dysgenic_A = mkA "disgenetico" ; -- UWN
lin dyskinesia_N = mkN "discinesia" ; -- UWN
lin dyslexia_N = mkN "dislessia" ; -- status=guess
lin dyslexic_A = mkA "dislessico" ; -- status=guess
lin dyspepsia_N = mkN "indigestione" ; -- UWN
lin dysphagia_N = mkN "disfagia" ; -- status=guess
lin dysphemism_N = mkN "disfemismo" ; -- status=guess
lin dysphoria_N = mkN "disforia" ; -- status=guess
lin dysphoric_A = mkA "addolorato" | mkA "afflitto" | mkA "affranto" | mkA "angustiato" | mkA "desolato" | mkA "disgraziato" | mkA "doglioso" | mkA "sofferto" | mkA "tormentato" ; -- UWN
lin dysplasia_N = mkN "displasia" ; -- UWN
lin dysplastic_A = mkA "displasico" | mkA "displastico" ; -- UWN
lin dyspnea_N = mkN "dispnea" ; -- status=guess
lin dysprosium_N = mkN "disprosio" ; -- status=guess
lin dystrophy_N = mkN "distrofia" ; -- status=guess
lin each_Det = mkDet "ogni" | mkDet "ognuno" | mkDet "ciascuno" ; -- status=guess status=guess status=guess
lin eager_A = mkA "avido" ; -- status=guess
lin eagle_N = mkN "moneta di dieci dollari" ; -- status=guess
lin eaglescliffe_PN = mkPN "Eaglescliffe" ; -- status=guess src=geonames
lin eaglet_N = mkN "aquilotto" ; -- UWN
lin ealing_PN = mkPN "Borgo londinese di Ealing" ; -- status=guess src=geonames
lin ear_N = L.ear_N ;
lin earache_N = mkN "otalgia" ; -- UWN
lin eardrop_N = mkN "ciondolo" | mkN "pendente" ; -- UWN
lin eardrum_N = mkN "timpano" ; -- status=guess
lin earflap_N = mkN "paraorecchie" ; -- UWN
lin earl_N = mkN "conte" masculine ; -- status=guess
lin earldom_N = mkN "contea" ; -- status=guess
lin early_A = mkA "precoce" ; -- status=guess
lin early_Adv = mkAdv "presto" ; -- status=guess
lin early_on_Adv = mkAdv "presto" ; -- UWN
lin earn_V = mkV "guadagnare" ; -- status=guess, src=wikt
lin earn_V2 = mkV2 (mkV "guadagnare") ; -- status=guess, src=wikt
lin earnest_A = mkA "voglioso" | mkA "desideroso" | mkA "fervente" | mkA "zelante" ; -- status=guess status=guess status=guess status=guess
lin earnest_N = mkN "pegno" ; -- status=guess
lin earning_N = variants {} ; --
lin earphone_N = mkN "cuffia" ; -- status=guess
lin earpiece_N = mkN "auricolare" ; -- UWN
lin earring_N = mkN "orecchino" ; -- status=guess
lin earth_N = L.earth_N ;
lin earth_V2 = mkV2 (mkV (mettere_V) "a terra") | mkV2 (mkV (mkV "collegare") "a terra") ; -- status=guess, src=wikt status=guess, src=wikt
lin earthenware_N = mkN "coccio" | mkN "terraglia" ; -- status=guess status=guess
lin earthly_A = mkA "mondano" | mkA "terreno" ; -- UWN
lin earthquake_N = mkN "terremoto" | mkN "sisma" masculine ; -- status=guess status=guess
lin earthstar_N = mkN "geastro" ; -- status=guess
lin earthwork_N = mkN "montarozzo" | mkN "terrapieno" ; -- status=guess status=guess
lin earthworm_N = mkN "lombrico" ; -- status=guess
lin earwax_N = mkN "cerume" masculine ; -- status=guess
lin earwig_N = mkN "Forficola" | mkN "Forficula" | mkN "forbicina" | mkN "forfecchia" | mkN "forficola" | mkN "forficula" ; -- UWN
lin ease_N = mkN "facilità" feminine ; -- status=guess
lin ease_V = variants {} ; --
lin ease_V2 = variants {} ; --
lin ease_off_V2 = prepV2 OP_ease_V OP_off_Prep ; -- guess-p-verb
lin ease_up_V = advV OP_ease_V OP_up_Adv ; -- guess-p-verb
lin easel_N = mkN "cavalletto" ; -- status=guess
lin easement_N = mkN "servitù" ; -- status=guess
lin easington_PN = mkPN "Easington" ; -- status=guess src=geonames
lin east_A = mkA "da est" ; -- status=guess
lin east_Adv = mkAdv "a est" | mkAdv "verso est" ; -- status=guess status=guess
lin east_N = mkN "est" masculine | mkN "oriente" | mkN "levante" masculine ; -- status=guess status=guess status=guess
lin eastbourne_PN = mkPN "Eastbourne" ; -- status=guess src=geonames
lin easter_N = mkN "levante" ; -- UWN
lin easterly_A = variants {} ;
lin easterly_Adv = adjAdv easterly_A ; -- derived
lin eastern_A = variants {} ; --
lin eastleigh_PN = mkPN "Eastleigh" ; -- status=guess src=geonames
lin easy_A = mkA "facile" ; -- status=guess
lin easy_A2V = L.easy_A2V ; -- comment=CHECKED
lin easy_Adv = mkAdv "facilmente" ; -- UWN
lin eat_V = mkV "mangiare" ; -- status=guess, src=wikt
lin eat_V2 = L.eat_V2 ;
lin eat_away_V = advV OP_eat_V OP_away_Adv ; -- guess-p-verb
lin eat_away_V2 = mkV2 (advV OP_eat_V OP_away_Adv ) ; -- guess-p-verb
lin eat_in_V = advV OP_eat_V OP_in_Adv ; -- guess-p-verb
lin eat_into_V2 = prepV2 OP_eat_V OP_into_Prep ; -- guess-p-verb
lin eat_out_V = advV OP_eat_V OP_out_Adv ; -- guess-p-verb
lin eat_up_V2 = prepV2 OP_eat_V OP_up_Prep ; -- guess-p-verb
lin eatable_A = mkA "commestibile" | mkA "edule" | mkA "edulo" | mkA "mangereccio" | mkA "mangiabile" ; -- UWN
lin eater_N = mkN "mangiatore" ; -- status=guess
lin eating_N = mkN "mangiare" ; -- status=guess
lin eau_de_cologne_N = mkN "acqua_di_colonia" | mkN "colonia" ; -- UWN
lin eaves_N = mkN "gronda" | mkN "grondaia" ; -- status=guess status=guess
lin eavesdrop_V = mkV "origliare" ; -- status=guess, src=wikt
lin ebb_N = mkN "riflusso" ; -- status=guess
lin ebb_away_V = mkV "decrescere" | mkV "riabbassarsi" | mkV "scendere" ; -- UWN
lin ebbtide_N = mkN "riflusso" ; -- UWN
lin ebonite_N = mkN "ebanite" feminine ; -- status=guess
lin ebony_N = mkN "ebano" ; -- status=guess
lin ebullient_A = mkA "esuberante" ; -- UWN
lin eccentric_A = mkA "eccentrico" ; -- status=guess
lin eccentric_N = mkN "eccentrico" ; -- status=guess
lin eccentricity_N = mkN "eccentricità" ; -- UWN
lin eccles_PN = mkPN "Eccles" ; -- status=guess src=geonames
lin ecclesiastic_N = mkN "chierico" | mkN "ecclesiastico" ; -- UWN
lin ecclesiastical_A = mkA "ecclesiastico" ; -- status=guess
lin ecclesiology_N = mkN "ecclesiologia" ; -- status=guess
lin echelon_N = mkN "scaglione" masculine ; -- status=guess
lin echidna_N = mkN "echidna" ; -- status=guess
lin echinococcosis_N = mkN "echinococcosi" ; -- UWN
lin echinococcus_N = mkN "echinococco" ; -- UWN
lin echo_N = mkN "eco" feminine ; -- status=guess
lin echo_V = mkV "ripetere" ; -- UWN
lin echo_V2 = variants {} ; --
lin echolalia_N = mkN "ecolalia" ; -- status=guess
lin eclampsia_N = mkN "eclampsia" ; -- UWN
lin eclectic_A = mkA "eclettico" | mkA "disparato" | mkA "heteroclitico" | mkA "eterogeneo" ; -- status=guess status=guess status=guess status=guess
lin eclectic_N = mkN "eclettico" ; -- status=guess
lin eclecticism_N = mkN "ecclettismo" | mkN "eclettismo" ; -- UWN
lin eclipse_N = mkN "eclisse" | mkN "eclissi" feminine ; -- status=guess status=guess
lin ecliptic_N = mkN "eclittica" ; -- status=guess
lin eclogue_N = mkN "egloga" ; -- status=guess
lin ecological_A = mkA "ecologico" ; -- status=guess
lin ecologist_N = mkN "ecologista" masculine | mkN "ecologo" ; -- status=guess status=guess
lin ecology_N = mkN "ecologia" ; -- status=guess
lin econometric_A = mkA "econometrico" ; -- UWN
lin econometrics_N = mkN "statistica economica" ; -- status=guess
lin economic_A = mkA "economico" | mkA "economo" ; -- status=guess status=guess
lin economical_A = variants {} ;
lin economics_N = mkN "economia" ; -- status=guess
lin economist_N = variants {} ; --
lin economize_V = mkV "risparmiare" ; -- UWN
lin economy_1_N = mkN "economia" | mkN "sistema_economico" ; -- UWN
lin economy_2_N = mkN "economia" | mkN "risparmio" ; -- UWN
lin economy_N = mkN "economia" ; -- status=guess
lin ecosystem_N = mkN "ecosistema" masculine ; -- status=guess
lin ecphonesis_N = mkN "esclamazione" ; -- UWN
lin ecstasy_N = mkN "ecstasy" masculine ; -- status=guess
lin ectoderm_N = mkN "ectoderma" ; -- UWN
lin ectoparasite_N = mkN "dermatozoo" ; -- status=guess
lin ectoplasm_N = mkN "ectoplasma" ; -- status=guess
lin ecuador_PN = mkPN "Ecuador" ; -- status=guess src=geonames
lin ecumenism_N = mkN "ecumenismo" ; -- status=guess
lin eczema_N = mkN "eczema" masculine ; -- status=guess
lin ed_PN = mkPN "Ed" ; -- status=guess src=geonames
lin edacious_A = mkA "vorace" ; -- UWN
lin eddy_N = mkN "vortice" | mkN "gorgo" | mkN "mulinello" ; -- status=guess status=guess status=guess
lin edelweiss_N = mkN "stella alpina" ; -- status=guess
lin edema_N = mkN "edema" masculine ; -- status=guess
lin eden_PN = mkPN "Eden" ; -- status=guess src=geonames
lin edenbridge_PN = mkPN "Edenbridge" ; -- status=guess src=geonames
lin edgar_PN = mkPN "Edgar" ; -- status=guess src=geonames
lin edge_N = mkN "vantaggio" ; -- status=guess
lin edging_N = mkN "bordura" ; -- UWN
lin edgy_A = mkA "nervoso" ; -- UWN
lin edibility_N = mkN "commestibilità" ; -- UWN
lin edible_A = mkA "commestibile" | mkA "edibile" | mkA "edule" ; -- status=guess status=guess status=guess
lin edible_N = mkN "ghiro" ; -- status=guess
lin edification_N = mkN "edificazione" ; -- UWN
lin edifice_N = mkN "costruzione" | mkN "edificio" | mkN "fabbricato" | mkN "palazzo" | mkN "stabile" ; -- UWN
lin edifying_A = mkA "edificante" | mkA "educativo" | mkA "esemplare" ; -- UWN
lin edinburgh_PN = mkPN "Edimburgo" ; -- status=guess src=geonames
lin edit_V2 = mkV2 (redigere_V) ; -- status=guess, src=wikt
lin editing_N = mkN "redazione" feminine ;
lin edition_N = mkN "edizione" feminine ; -- status=guess
lin editor_N = mkN "giuntatrice" feminine ; -- status=guess
lin editorial_A = mkA "editoriale" ; -- status=guess
lin editorial_N = mkN "articolo_di_fondo" | mkN "editoriale" | mkN "fondo" | mkN "rubrica" ; -- UWN
lin editorship_N = mkN "direzione" ; -- UWN
lin educate_V2 = mkV2 (mkV "istruire") | mkV2 (mkV "educare") ; -- status=guess, src=wikt status=guess, src=wikt
lin education_N = mkN "istruzione" feminine | mkN "educazione" feminine ; -- status=guess status=guess
lin educational_A = mkA "educativo" ; -- status=guess
lin educationalist_N = mkN "educatore" | mkN "educatrice" feminine ; -- status=guess status=guess
lin educationist_N = mkN "educatore" | mkN "pedagogista" ; -- UWN
lin eel_N = mkN "anguilla" masculine ; -- status=guess
lin eelworm_N = mkN "anguillula" ; -- UWN
lin eerie_A = mkA "misterioso" ; -- status=guess
lin effect_N = mkN "effetto" ; -- status=guess
lin effect_V2 = variants {} ; --
lin effective_A = mkA "efficace" ; -- UWN
lin effectiveness_N = mkN "efficacia" ; -- status=guess
lin effectual_A = mkA "efficace" | mkA "valido" ; -- UWN
lin effeminacy_N = mkN "effeminatezza" ; -- status=guess
lin effeminate_A = mkA "effemminato" ; -- status=guess
lin effendi_N = mkN "efendi" | mkN "effendi" masculine ; -- status=guess status=guess
lin efferent_A = mkA "efferente" ; -- UWN
lin effervesce_V = mkV "mussare" | mkV "schiumare" | mkV "schiumare" | mkV "spumare" | mkV "spumeggiare" | mkV "spumeggiare" ; -- UWN
lin effervescence_N = mkN "effervescenza" ; -- UWN
lin efficacy_N = mkN "efficacia" ; -- status=guess
lin efficiency_N = mkN "efficienza" ; -- status=guess
lin efficient_A = mkA "efficiente" ; -- status=guess
lin effigy_N = mkN "effige" | mkN "effigie" ; -- UWN
lin efflorescence_N = mkN "efflorescenza" ; -- status=guess
lin effluent_N = mkN "effluente" masculine ; -- status=guess
lin effluvium_N = mkN "effluvio" ; -- status=guess
lin efflux_N = mkN "efflusso" ; -- UWN
lin effort_N = mkN "sforzo" ; -- status=guess
lin effrontery_N = mkN "sfrontatezza" ; -- status=guess
lin effusion_N = mkN "effusione" feminine ; -- status=guess
lin effusiveness_N = mkN "espansività" ; -- UWN
lin eg_PN = mkPN "Eg" ; -- status=guess src=geonames
lin egalitarian_A = mkA "egualitario" ; -- status=guess
lin egalitarian_N = mkN "egualitario" ; -- status=guess
lin egalitarianism_N = mkN "egalitarismo" | mkN "egualitarismo" ; -- UWN
lin egg_N = L.egg_N ;
lin egg_cup_N = mkN "portauovo" ; -- status=guess
lin egghead_N = mkN "intellettuale" ; -- UWN
lin eggnog_N = mkN "vov" | mkN "zabaione" | mkN "zabaglione" masculine ; -- status=guess status=guess status=guess
lin eggplant_N = mkN "melanzana" ; -- status=guess
lin eggshell_N = mkN "coque" ; -- UWN
lin ego_N = variants {} ; --
lin egocentric_A = mkA "egocentrico" ; -- status=guess
lin egocentric_N = mkN "egoista" ; -- UWN
lin egoism_N = mkN "egoismo" ; -- UWN
lin egoist_N = mkN "egoista" ; -- UWN
lin egoistic_A = mkA "egoista" | mkA "egoistico" | mkA "narcisistico" | mkA "personalistico" ; -- UWN
lin egoistical_A = mkA "egoista" | mkA "egoistico" | mkA "narcisistico" | mkA "personalistico" ; -- UWN
lin egotistic_A = mkA "gonfio" ; -- UWN
lin egremont_PN = mkPN "Egremont" ; -- status=guess src=geonames
lin egret_N = mkN "garzetta" | mkN "airone guardabuoi" ; -- status=guess status=guess
lin egypt_PN = mkPN "Egitto" ; -- status=guess src=geonames
lin eider_N = mkN "edredone" ; -- UWN
lin eigenvalue_N = mkN "autovalore" masculine ; -- status=guess
lin eindhoven_PN = mkPN "Eindhoven" ; -- status=guess src=geonames
lin einsteinium_N = mkN "einstenio" ; -- status=guess
lin either7or_DConj = S.either7or_DConj ; -- comment=CHECKED
lin either_Adv = mkAdv "neanche" | mkAdv "nemmeno" | mkAdv "neppure" ; -- status=guess status=guess status=guess
lin either_Det = mkDet "ciascuno" ; -- status=guess
lin ejaculate_V2 = mkV2 (mkV "eiaculare") ; -- status=guess, src=wikt
lin ejaculation_N = mkN "eiaculazione" feminine ; -- status=guess
lin ejection_N = mkN "eiezione" feminine ; -- status=guess
lin ejector_N = mkN "eiettore" | mkN "espulsore" ; -- UWN
lin eke_V2 = mkV2 (mkV "integrare") ; -- status=guess, src=wikt
lin el_salvador_PN = mkPN "El Salvador" ; -- status=guess src=geonames
lin elaborate_A = mkA "elaborato" | mkA "elaborata" ; -- status=guess status=guess
lin elaboration_N = mkN "elaborazione" ; -- UWN
lin elapse_V = trascorrere_V ; -- status=guess, src=wikt
lin elastic_A = mkA "elastico" | mkA "elastica" ; -- status=guess status=guess
lin elastic_N = mkN "elastico" ; -- status=guess
lin elasticity_N = mkN "elasticità" feminine ; -- status=guess
lin elastin_N = mkN "elastina" ; -- status=guess
lin elastomer_N = mkN "elastomero" ; -- status=guess
lin elbow_N = mkN "gomito" ; -- status=guess
lin elbow_V2 = mkV2 (mkV "sgomitare") ; -- status=guess, src=wikt
lin elder_A = mkA "Vecchio" | mkA "maggiore" ; -- UWN
lin elder_1_N = mkN "sambuco" ; -- status=guess
lin elder_2_N = mkN "sambuco" ; -- status=guess
lin elderberry_N = mkN "sambuco" ; -- status=guess
lin elderly_A = variants {} ; --
lin elderslie_PN = mkPN "Elderslie" ; -- status=guess src=geonames
lin eldritch_A = mkA "strano" ; -- UWN
lin eleanor_PN = mkPN "Eleanor" ; -- status=guess src=geonames
lin elect_V = eleggere_V ; -- status=guess, src=wikt
lin elect_V2 = mkV2 (eleggere_V) ; -- status=guess, src=wikt
lin elect_V2V = mkV2V (eleggere_V) ; -- status=guess, src=wikt
lin elect_V3 = mkV3 (eleggere_V) ; -- status=guess, src=wikt
lin elected_A = variants {} ; --
lin election_N = mkN "elezione" feminine ; -- status=guess
lin electioneering_N = mkN "propaganda elettorale" ; -- status=guess
lin electoral_A = variants {} ; --
lin electorate_N = mkN "elettorato" ; -- status=guess
lin electric_A = mkA "elettrico" ; -- status=guess
lin electric_N = mkN "auto elettrica" ; -- status=guess
lin electrical_A = variants {} ; --
lin electrician_N = mkN "elettricista" masculine ; -- status=guess
lin electricity_N = mkN "elettricità" feminine ; -- status=guess
lin electrocardiograph_N = mkN "cardiografo" | mkN "elettrocardiografo" ; -- UWN
lin electrochemical_A = mkA "elettrochimico" ; -- status=guess
lin electrochemistry_N = mkN "elettrochimica" ; -- status=guess
lin electrocution_N = mkN "elettrocuzione" | mkN "elettroesecuzione" | mkN "fulminazione" ; -- UWN
lin electrode_N = mkN "elettrodo" ; -- UWN
lin electrodeposition_N = mkN "elettrodeposizione" feminine ; -- status=guess
lin electrodynamometer_N = mkN "elettrodinamometro" ; -- status=guess
lin electroencephalogram_N = mkN "elettroencefalogramma" ; -- status=guess
lin electroencephalograph_N = mkN "elettroencefalografo" ; -- UWN
lin electrolysis_N = mkN "elettrolisi" feminine ; -- status=guess
lin electrolyte_N = mkN "elettrolito" | mkN "elettrolita" masculine ; -- status=guess status=guess
lin electromagnet_N = mkN "elettromagnete" masculine ; -- status=guess
lin electromagnetic_A = mkA "elettromagnetico" ; -- status=guess
lin electromagnetism_N = mkN "elettromagnetismo" ; -- status=guess
lin electromechanical_A = mkA "elettromeccanico" ; -- UWN
lin electrometer_N = mkN "elettrometro" ; -- UWN
lin electromotive_A = mkA "elettromotrice" ; -- status=guess
lin electromyography_N = mkN "elettromiografia" ; -- status=guess
lin electron_N = mkN "elettrone" masculine ; -- status=guess
lin electronegativity_N = mkN "elettronegatività" feminine ; -- status=guess
lin electronic_A = mkA "elettronico" ; -- status=guess
lin electronics_N = mkN "elettronica" ; -- status=guess
lin electrophoresis_N = mkN "elettroforesi" feminine ; -- status=guess
lin electroscope_N = mkN "elettroscopio" ; -- status=guess
lin electrostatic_A = mkA "elettrostatico" ; -- status=guess
lin electrotherapy_N = mkN "galvanizzazione" ; -- UWN
lin elegance_N = mkN "eleganza" ; -- status=guess
lin elegant_A = mkA "elegante" ; -- status=guess
lin elegy_N = mkN "elegia" ; -- UWN
lin element_N = mkN "elemento" ; -- status=guess
lin elemental_A = mkA "elementare" | mkA "elementare" | mkA "primitivo" ; -- UWN
lin elementary_A = mkA "elementare" ; -- status=guess
lin elephant_N = mkN "elefante" masculine ; -- status=guess
lin elephantiasis_N = mkN "elefantiasi" feminine ; -- status=guess
lin elevate_V2 = mkV2 (mkV "aumentare") ; -- status=guess, src=wikt
lin elevator_N = mkN "ascensore" | mkN "lift" ; -- UWN
lin elf_N = mkN "elfo" ; -- status=guess
lin elgin_PN = mkPN "Elgin" ; -- status=guess src=geonames
lin eligibility_N = mkN "idoneità" ; -- status=guess
lin eligible_A = variants {} ; --
lin eliminate_V2 = variants {} ; --
lin elision_N = mkN "eccezione" ; -- UWN
lin elite_N = mkN "élite" feminine ; -- status=guess
lin elitism_N = mkN "elitismo" ; -- UWN
lin elitistFem_N = variants {} ; ---- sense to be split
lin elitistMasc_N = variants {} ; ---- sense to be split
lin elixir_N = mkN "elisir" masculine ; -- status=guess
lin elizabeth_PN = mkPN "Elizabeth" ; -- status=guess src=geonames
lin elland_PN = mkPN "Elland" ; -- status=guess src=geonames
lin ellesmere_PN = mkPN "Ellesmere" ; -- status=guess src=geonames
lin ellipse_N = mkN "ellisse" feminine ; -- status=guess
lin ellipsis_N = mkN "puntini puntini puntini" ; -- status=guess
lin ellipsoid_N = mkN "ellissoide" ; -- UWN
lin elm_N = mkN "olmo" ; -- status=guess
lin elocution_N = mkN "elocuzione" ; -- UWN
lin elocutionistFem_N = variants {} ; ---- sense to be split
lin elocutionistMasc_N = variants {} ; ---- sense to be split
lin elope_V = mkV "fuggire" | mkV "scappare" ; -- UWN
lin elopement_N = mkN "fuga_romantica" ; -- UWN
lin eloquence_N = mkN "eloquenza" | mkN "facondia" ; -- UWN
lin eloquent_A = mkA "loquace" | mkA "articolato" | mkA "verboso" | mkA "pedissequo" ; -- status=guess status=guess status=guess status=guess
lin else_Adv = mkAdv "altrimenti" ; -- status=guess
lin elsewhere_Adv = mkAdv "altrove" ; -- status=guess
lin elstree_PN = mkPN "Elstree" ; -- status=guess src=geonames
lin eluate_N = mkN "eluato" ; -- status=guess
lin elucidate_V2 = mkV2 (mkV "chiarire") ; -- status=guess, src=wikt
lin elucidation_N = mkN "chiarificazione" | mkN "chiarimento" | mkN "delucidazione" | mkN "dilucidazione" | mkN "precisazione" | mkN "puntualizzazione" | mkN "schiarimento" ; -- UWN
lin ely_PN = mkPN "Ely" ; -- status=guess src=geonames
lin em_N = mkN "emme" masculine ; -- status=guess
lin emaciate_V2 = mkV2 (mkV "emaciarsi") ; -- status=guess, src=wikt
lin emaciation_N = mkN "consunzione" | mkN "deperimento" | mkN "dimagrimento" | mkN "macilenza" | mkN "magrezza" | mkN "secchezza" ; -- UWN
lin emanate_V = mkV "emanare" ; -- status=guess, src=wikt
lin emanation_N = mkN "emanazione" feminine ; -- status=guess
lin emancipator_N = mkN "emancipatore" ; -- UWN
lin embalm_V2 = mkV2 (mkV "imbalsamare") ; -- status=guess, src=wikt
lin embalmer_N = mkN "imbalsamatore" ; -- UWN
lin embankment_N = mkN "argine" masculine ; -- status=guess
lin embargo_N = mkN "embargo" ; -- status=guess
lin embark_V = mkV "imbarcare" ; -- status=guess, src=wikt
lin embark_V2 = mkV2 (mkV "imbarcare") ; -- status=guess, src=wikt
lin embarkation_N = mkN "imbarco" ; -- UWN
lin embarrass_V2 = mkV2 (mkV "imbarazzare") ; -- status=guess, src=wikt
lin embarrassed_A = variants {} ; --
lin embarrassing_A = mkA "imbarazzante" ; -- status=guess
lin embarrassment_N = mkN "imbarazzo" ; -- status=guess
lin embassy_N = mkN "ambasciata" ; -- status=guess
lin embed_V2 = mkV2 (mkV "incastonare") | mkV2 (mkV "incastrare") | mkV2 (mkV "incorporare") | mkV2 (mkV "inserire") | mkV2 (mkV "aggregare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin embellish_V2 = mkV2 (mkV "imbellettare") | mkV2 (mkV "abbellire") ; -- status=guess, src=wikt status=guess, src=wikt
lin ember_N = mkN "brace" feminine ; -- status=guess
lin embezzlement_N = mkN "appropriazione indebita" | mkN "peculato" ; -- status=guess status=guess
lin embezzler_N = mkN "concussionario" | mkN "malversatore" | mkN "prevaricatore" ; -- UWN
lin embitterment_N = mkN "inasprimento" ; -- UWN
lin emblem_N = mkN "emblema" | mkN "raffigurazione" feminine | mkN "simbolo" ; -- status=guess status=guess status=guess
lin emblematic_A = mkA "emblematico" ; -- UWN
lin embodiment_N = mkN "incarnazione" feminine ; -- status=guess
lin embody_V2 = variants {} ; --
lin embolism_N = mkN "embolia" ; -- status=guess
lin embolus_N = mkN "embolo" ; -- UWN
lin embonpoint_N = mkN "floridezza" | mkN "floridità" | mkN "lussureggiamento" | mkN "paffutezza" | mkN "prosperosità" | mkN "rigogliosità" | mkN "rotondità" | mkN "vigoria" ; -- UWN
lin emboss_V2 = mkV2 (mkV "coniare") ; -- status=guess, src=wikt
lin embrace_V = mkV "abbracciare" | mkV "sposare" ; -- UWN
lin embrace_V2 = variants {} ; --
lin embrasure_N = mkN "cannoniera" ; -- UWN
lin embrocation_N = mkN "embrocazione" | mkN "linimento" ; -- UWN
lin embroider_V = mkV "ricamare" | mkV "abbellire" | mkV "indorare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin embroider_V2 = mkV2 (mkV "ricamare") | mkV2 (mkV "abbellire") | mkV2 (mkV "indorare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin embroiderer_N = mkN "ricamatrice" | mkN "ricamatore" masculine ; -- status=guess status=guess
lin embroidery_N = mkN "ricamo" ; -- status=guess
lin embryo_N = mkN "embrione" masculine ; -- status=guess
lin embryology_N = mkN "embriologia" ; -- UWN
lin emeer_N = mkN "emiro" ; -- UWN
lin emendation_N = mkN "emendamento" ; -- UWN
lin emerald_N = mkN "smeraldo" ; -- status=guess
lin emerge_V = variants {} ; --
lin emergence_N = mkN "emergenza" ; -- status=guess
lin emergency_N = mkN "emergenza" ; -- status=guess
lin emeritus_A = mkA "emerito" ; -- status=guess
lin emery_N = mkN "smeriglio" ; -- UWN
lin emetic_N = mkN "emetico" | mkN "vomitativo" ; -- UWN
lin emigrant_N = mkN "emigrante" masculine ; -- status=guess
lin emigrate_V = mkV "emigrare" ; -- status=guess, src=wikt
lin emigrate_V2V = mkV2V (mkV "emigrare") ; -- status=guess, src=wikt
lin emigration_N = mkN "emigrazione" ; -- UWN
lin eminence_N = mkN "tuberosità" ; -- UWN
lin eminent_A = mkA "svettante" ; -- UWN
lin emir_N = mkN "emiro" ; -- status=guess
lin emirate_N = mkN "emirato" ; -- status=guess
lin emissary_N = mkN "emissario" ; -- UWN
lin emission_N = variants {} ; --
lin emit_V2 = mkV2 (emettere_V) ; -- status=guess, src=wikt
lin emmer_N = mkN "farro" ; -- status=guess
lin emmetropia_N = mkN "emmetropia" ; -- status=guess
lin emolument_N = mkN "emolumento" ; -- status=guess
lin emotion_N = mkN "emozione" feminine ; -- status=guess
lin emotional_A = mkA "emozionante" | mkA "commovente" ; -- status=guess status=guess
lin empathize_V = mkV "comprendere" ; -- UWN
lin empathy_N = mkN "empatia" ; -- UWN
lin emperor_N = mkN "imperatore" masculine ; -- status=guess
lin emphasis_N = variants {} ; --
lin emphasize_V2 = mkV2 (mkV "enfatizzare") | mkV2 (mkV "sottolineare") | mkV2 (mkV "evidenziare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin emphasize_VS = mkVS (mkV "enfatizzare") | mkVS (mkV "sottolineare") | mkVS (mkV "evidenziare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin emphasizing_N = mkN "enfatizzazione" ; -- UWN
lin emphysematous_A = mkA "enfisematico" | mkA "enfisematoso" ; -- UWN
lin empire_N = mkN "impero" ; -- status=guess
lin empirical_A = variants {} ; --
lin empiricist_N = mkN "empirista" ; -- UWN
lin emplacement_N = mkN "collocazione" | mkN "disposizione" ; -- UWN
lin employ_N = mkN "collocamento" | mkN "lavoro" | mkN "occupazione" ; -- UWN
lin employ_V2 = mkV2 (mkV "impiegare") | mkV2 (mkV "ingaggiare") ; -- status=guess, src=wikt status=guess, src=wikt
lin employable_A = mkA "assumibile" ; -- status=guess
lin employee_N = mkN "dipendente" ; -- status=guess
lin employer_N = mkN "datore di lavoro" ; -- status=guess
lin employment_N = mkN "assunzione" feminine ; -- status=guess
lin emporium_N = mkN "emporio" | mkN "grande_magazzino" | mkN "magazzino" ; -- UWN
lin empower_V2 = mkV2 (mkV (dare_V) "potere") ; -- status=guess, src=wikt
lin empower_V2V = mkV2V (mkV (dare_V) "potere") ; -- status=guess, src=wikt
lin empress_N = mkN "imperatrice" feminine ; -- status=guess
lin emptiness_N = mkN "vanità" ; -- UWN
lin empty_A = L.empty_A ;
lin empty_N = mkN "insieme vuoto" ; -- status=guess
lin empty_V = mkV "vuotare" ; -- status=guess, src=wikt
lin empty_V2 = mkV2 (mkV "vuotare") ; -- status=guess, src=wikt
lin emptying_N = mkN "svotamento" | mkN "svuotamento" ; -- UWN
lin empyema_N = mkN "empiema" masculine ; -- status=guess
lin empyrean_N = mkN "firmamento" | mkN "volta_celeste" | mkN "volta_del_cielo" | mkN "volta_stellata" ; -- UWN
lin emsworth_PN = mkPN "Emsworth" ; -- status=guess src=geonames
lin emu_N = mkN "emù" masculine ; -- status=guess
lin emulation_N = mkN "emulazione" ; -- UWN
lin emulsifier_N = mkN "emulsionante" masculine ; -- status=guess
lin emulsify_V2 = mkV2 (mkV "emulsionare") ; -- status=guess, src=wikt
lin emulsion_N = mkN "emulsione" ; -- status=guess
lin en_N = mkN "enne" masculine ; -- status=guess
lin enable_V2 = variants {} ; --
lin enable_V2V = variants {} ; --
lin enable_VS = mkvVS "permettere" ; -- UWN
lin enallage_N = mkN "enallage" ; -- UWN
lin enamel_N = mkN "smalto" ; -- status=guess
lin enamel_V2 = mkV2 (mkV "smaltare") ; -- status=guess, src=wikt
lin enamelware_N = mkN "stoviglie_smaltate" ; -- UWN
lin encamp_V = mkV "attendarsi" | mkV "bivaccare" | mkV "campeggiare" ; -- UWN
lin encampment_N = mkN "accampamento" | mkN "campeccio" | mkN "campeggio" ; -- UWN
lin encephalitis_N = mkN "encefalite" feminine ; -- status=guess
lin encephalogram_N = mkN "encefalogramma" masculine ; -- status=guess
lin enchant_V2 = mkV2 (mkV "incantare") ; -- status=guess, src=wikt
lin enchanter_N = mkN "ammaliatore" | mkN "incantatore" | mkN "stregone" ; -- UWN
lin enchantment_N = mkN "affatturazione" | mkN "ammaliamento" | mkN "fascinazione" | mkN "incantesimo" | mkN "incanto" | mkN "magia" | mkN "malia" ; -- UWN
lin enchantress_N = mkN "fattucchiera" | mkN "maga" | mkN "strega" ; -- UWN
lin encircle_V2 = mkV2 (mkV "accerchiare") | mkV2 (mkV "circondare") ; -- status=guess, src=wikt status=guess, src=wikt
lin encirclement_N = mkN "accerchiamento" | mkN "blocco" | mkN "imbottigliamento" ; -- UWN
lin enclave_N = mkN "enclave" feminine ; -- status=guess
lin enclose_V2 = mkV2 (mkV "cintare") ; -- status=guess, src=wikt
lin enclosure_1_N = mkN "recinto" ; -- status=guess
lin enclosure_2_N = mkN "recinto" ; -- status=guess
lin enclosure_3_N = mkN "recinto" ; -- status=guess
lin encompass_V2 = mkV2 (mkV "circondare") ; -- status=guess, src=wikt
lin encore_N = mkN "bis" masculine ; -- status=guess
lin encounter_N = variants {} ; --
lin encounter_V2 = variants {} ; --
lin encourage_V2 = mkV2 (mkV "incoraggiare") ; -- status=guess, src=wikt
lin encourage_V2V = mkV2V (mkV "incoraggiare") ; -- status=guess, src=wikt
lin encouragement_N = mkN "incoraggiamento" ; -- status=guess
lin encouraging_A = variants {} ; --
lin encroach_V = mkV "invadere" ; -- status=guess, src=wikt
lin encroachment_N = mkN "impatto" ; -- UWN
lin encumber_V2 = mkV2 (mkV (mkV "caricare") "con ipoteca") | mkV2 (mkV (mkV "gravare") "di ipoteca") ; -- status=guess, src=wikt status=guess, src=wikt
lin encyclical_N = mkN "enciclica" ; -- status=guess
lin encyclopaedia_N = mkN "enciclopedia" ; -- UWN
lin encyclopedia_N = mkN "enciclopedia" ; -- status=guess
lin end_1_N = mkN "fine" feminine ;
lin end_2_N = mkN "capo" ; ----
lin end_N = mkN "fine" feminine ;
lin end_V = mkV "finire" ; -- status=guess, src=wikt
lin end_V2 = mkV2 (mkV "finire") ; -- status=guess, src=wikt
lin end_in_V2 = prepV2 OP_end_V OP_in_Prep ; -- guess-p-verb
lin end_tail_V2 = variants {} ; -- guess-p-verb
lin end_up_V2 = prepV2 OP_end_V OP_up_Prep ; -- guess-p-verb
lin end_up_with_V2 = prepV2 (advV OP_end_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin endanger_V2 = mkV2 (mkV "rischiare") | mkV2 (compromettere_V) | mkV2 (mkV (mettere_V) "in pericolo") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin endearingly_Adv = mkAdv "adorabilmente" ; -- UWN
lin endearment_N = mkN "vezzeggiativo" ; -- status=guess
lin endeavour_N = mkN "impresa" ; -- status=guess
lin endeavour_V = mkV "tentare" | mkV "sforzarsi" | mkV "adoperarsi" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin ending_N = mkN "fine" ; -- UWN
lin endive_N = mkN "indivia" | mkN "scarola" ; -- status=guess status=guess
lin endless_A = variants {} ; --
lin endocarditis_N = mkN "endocardite" feminine ; -- status=guess
lin endocardium_N = mkN "endocardio" ; -- status=guess
lin endocrine_A = mkA "endocrino" ; -- status=guess
lin endocrinologist_N = mkN "endocrinologo" | mkN "endocrinologa" ; -- status=guess status=guess
lin endocrinology_N = mkN "endocrinologia" ; -- status=guess
lin endoderm_N = mkN "endoderma" | mkN "entoderma" ; -- UWN
lin endogamy_N = mkN "endogamia" ; -- status=guess
lin endogenous_A = mkA "endogeno" ; -- status=guess
lin endometriosis_N = mkN "endometriosi" feminine ; -- status=guess
lin endometrium_N = mkN "endometrio" ; -- status=guess
lin endomorphic_A = mkA "endomorfo" ; -- UWN
lin endoparasite_N = mkN "endoparassita" | mkN "entozoo" ; -- UWN
lin endoplasm_N = mkN "endoplasma" ; -- UWN
lin endorphin_N = mkN "endorfina" ; -- status=guess
lin endorse_V2 = mkV2 (mkV "approvare") | mkV2 (mkV "appoggiare") ; -- status=guess, src=wikt status=guess, src=wikt
lin endorser_N = mkN "girante" ; -- UWN
lin endoskeleton_N = mkN "endoscheletro" ; -- status=guess
lin endosperm_N = mkN "albume" | mkN "endosperma" ; -- UWN
lin endospore_N = mkN "endospora" ; -- UWN
lin endothelial_A = mkA "endoteliale" ; -- UWN
lin endothelium_N = mkN "endotelio" ; -- status=guess
lin endothermic_A = mkA "endotermico" ; -- UWN
lin endotoxin_N = mkN "endotossina" ; -- status=guess
lin endow_V2 = mkV2 (mkV "dotare") ; -- status=guess, src=wikt
lin endure_V = mkV "durare" | mkV "restare" ; -- status=guess, src=wikt status=guess, src=wikt
lin endure_V2 = mkV2 (mkV "durare") | mkV2 (mkV "restare") ; -- status=guess, src=wikt status=guess, src=wikt
lin enduring_A = variants {} ;
lin enema_N = mkN "clistere" masculine ; -- status=guess
lin enemy_N = L.enemy_N ;
lin energetic_A = mkA "energico" ; -- status=guess
lin energid_N = mkN "protoplasto" ; -- UWN
lin energy_N = mkN "energia" | mkN "forza" ; -- status=guess status=guess
lin enfield_PN = mkPN "Enfield" ; -- status=guess src=geonames
lin enforce_V2 = variants {} ; --
lin enforceable_A = mkA "azionabile" | mkA "esecutorio" ; -- status=guess status=guess
lin enforcement_N = variants {} ; --
lin engage_V = variants {} ; --
lin engage_V2 = variants {} ; --
lin engagement_N = mkN "impegno" ; -- UWN
lin engender_V2 = mkV2 (mkV "generare") | mkV2 (mkV "originare") | mkV2 (mkV "concepire") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin engine_N = mkN "motore" masculine ; -- status=guess
lin engineer_N = mkN "macchinista" masculine ; -- status=guess
lin engineering_N = mkN "ingegneria" ; -- status=guess
lin england_PN = mkPN "England" ; -- status=guess src=geonames
lin englishFem_N = mkN "inglese" feminine ;
lin englishMasc_N = mkN "inglese" ;
lin english_A = mkA "inglese" ;
lin engraving_N = mkN "incisione" feminine ; -- status=guess
lin engross_V2 = mkV2 (mkV "incettare") ; -- status=guess, src=wikt
lin engulf_V2 = mkV2 (sopraffare_V) | mkV2 (travolgere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin enhance_V2 = mkV2 (accrescere_V) | mkV2 (mkV "intensificare") ; -- status=guess, src=wikt status=guess, src=wikt
lin enhanced_A = variants {} ; --
lin enigma_N = mkN "enigma" | mkN "indovinello" ; -- status=guess status=guess
lin enigmatic_A = mkA "enigmatico" ; -- status=guess
lin enjoy_V2 = mkV2 (mkV "divertirsi") ; -- status=guess, src=wikt
lin enjoy_VV = mkVV (mkV "divertirsi") ; -- status=guess, src=wikt
lin enjoyable_A = variants {} ; --
lin enjoyment_N = mkN "divertimento" ; -- UWN
lin enlarge_V = mkV "allargare" ; -- status=guess, src=wikt
lin enlarge_V2 = mkV2 (mkV "allargare") ; -- status=guess, src=wikt
lin enlarger_N = mkN "ingranditore" masculine ; -- status=guess
lin enlighten_V2 = mkV2 (mkV "illuminare") ; -- status=guess, src=wikt
lin enlightenment_N = mkN "illuminismo" ; -- status=guess
lin enlist_V = mkV "arruolarsi" ; -- UWN
lin enmity_N = mkN "inimicizia" | mkN "ostilità" ; -- UWN
lin ennoblement_N = mkN "nobilitazione" ; -- UWN
lin ennui_N = mkN "noia" ; -- status=guess
lin enoch_PN = mkPN "Enoch" ; -- status=guess src=geonames
lin enologist_N = mkN "enologo" | mkN "enologa" ; -- status=guess status=guess
lin enology_N = mkN "enologia" ; -- status=guess
lin enormity_N = mkN "empietà" ; -- UWN
lin enormous_A = variants {} ; --
lin enormousness_N = mkN "amplitudine" | mkN "enormità" | mkN "estensione" | mkN "grandezza" | mkN "immensità" | mkN "vastità" ; -- UWN
lin enough_Predet = variants {} ; --
lin enquire_V = variants {} ; --
lin enquire_V2 = variants {} ; --
lin enquiringly_Adv = mkAdv "interrogativamente" ; -- UWN
lin enquiry_N = mkN "domanda" | mkN "richiesta" ; -- status=guess status=guess
lin enrage_V2 = mkV2 (mkV "esasperare") | mkV2 (mkV "imbestialire") | mkV2 (mkV "irritare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin enrich_V2 = mkV2 (mkV "arricchire") ; -- status=guess, src=wikt
lin enrichment_N = mkN "arricchimento" ; -- status=guess
lin enrolment_N = mkN "iscrizione" feminine | mkN "arruolamento" ; -- status=guess status=guess
lin enschede_PN = mkPN "Enschede" ; -- status=guess src=geonames
lin ensemble_N = mkN "insieme" masculine ; -- status=guess
lin ensiform_A = mkA "ensiforme" ; -- status=guess
lin ensue_V = mkV "seguire" | mkV "conseguire" ; -- status=guess, src=wikt status=guess, src=wikt
lin ensure_V = mkV "garantire" ; -- status=guess, src=wikt
lin ensure_V2 = mkV2 (mkV "garantire") ; -- status=guess, src=wikt
lin ensure_VS = mkVS (mkV "garantire") ; -- status=guess, src=wikt
lin entablature_N = mkN "sopraornato" ; -- UWN
lin entail_V2 = mkV2 (mkV "comportare") | mkV2 (mkV "implicare") ; -- status=guess, src=wikt status=guess, src=wikt
lin entangle_V2 = mkV2 (mkV "ingarbugliare") | mkV2 (mkV "intrigare") | mkV2 (confondere_V) ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin entasis_N = mkN "entasi" feminine ; -- status=guess
lin enter_V = mkV "entrare" ; -- status=guess, src=wikt
lin enter_V2 = mkV2 (mkV "entrare") ; -- status=guess, src=wikt
lin enter_for_V2 = prepV2 OP_enter_V OP_for_Prep ; -- guess-p-verb
lin enter_into_V2 = prepV2 OP_enter_V OP_into_Prep ; -- guess-p-verb
lin enteric_A = mkA "intestinale" ; -- UWN
lin enteritis_N = mkN "enterite" ; -- status=guess
lin enteropathy_N = mkN "enteropatia" ; -- status=guess
lin enterprise_N = mkN "impresa" ; -- status=guess
lin enterprising_A = mkA "intraprendente" ; -- UWN
lin entertain_V2 = mkV2 (mkV "divertire") ; -- status=guess, src=wikt
lin entertainer_N = mkN "intrattenitore" ; -- status=guess
lin entertaining_A = mkA "arguto" | mkA "brillante" | mkA "brioso" | mkA "dilettevole" | mkA "divertente" | mkA "esilarante" | mkA "faceto" | mkA "ridanciano" | mkA "ridicolo" | mkA "sollazzevole" | mkA "spassoso" | mkA "spiritoso" ; -- UWN
lin entertainment_N = mkN "divertimento" | mkN "intrattenimento" ; -- status=guess status=guess
lin enthuse_V = mkV "entusiasmare" ; -- status=guess, src=wikt
lin enthusiasm_N = mkN "entusiasmo" | mkN "foga" ; -- status=guess status=guess
lin enthusiast_N = mkN "appassionato" | mkN "patito" ; -- UWN
lin enthusiastic_A = mkA "caloroso" | mkA "entusiasta" | mkA "entusiastico" | mkA "fervido" ; -- UWN
lin entice_V2 = mkV2 (attrarre_V) | mkV2 (mkV "tentare") | mkV2 (mkV "allettare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin entire_A = mkA "intero" | mkA "intera" ; -- status=guess status=guess
lin entirety_N = mkN "interezza" ; -- UWN
lin entitle_V2V = mkV2V (mkV "intitolare") ; -- status=guess, src=wikt
lin entitle_VS = mkVS (mkV "intitolare") ; -- status=guess, src=wikt
lin entitlement_N = mkN "titolarità" ; -- UWN
lin entity_N = variants {} ; --
lin entomological_A = mkA "entomologico" ; -- UWN
lin entomologist_N = mkN "entomologo" ; -- status=guess
lin entomology_N = mkN "entomologia" ; -- status=guess
lin entourage_N = mkN "cerchia" | mkN "entourage" | mkN "seguito" ; -- UWN
lin entrance_N = mkN "entrata" ; -- status=guess
lin entrance_V2 = mkV2 (mkV "incantare") ; -- status=guess, src=wikt
lin entreatingly_Adv = mkAdv "supplichevolmente" ; -- UWN
lin entrenchment_N = mkN "trinceramento" ; -- UWN
lin entrepot_N = mkN "deposito" | mkN "magazzino" | mkN "rimessa" ; -- UWN
lin entrepreneur_N = mkN "imprenditore" masculine ; -- status=guess
lin entry_1_N = variants {} ; --
lin entry_2_N = variants {} ; --
lin entry_N = mkN "entrata" | mkN "ingresso" ; -- status=guess status=guess
lin entwine_V2 = mkV2 (mkV "intrecciare") ; -- status=guess, src=wikt
lin enumeration_N = mkN "calcolo" | mkN "computo" | mkN "conta" | mkN "conteggio" | mkN "supputazione" ; -- UWN
lin enunciation_N = mkN "enunciazione" feminine ; -- status=guess
lin envelop_V2 = mkV2 (mkV "circondare") | mkV2 (mkV "avviluppare") ; -- status=guess, src=wikt status=guess, src=wikt
lin envelope_N = mkN "busta" ; -- status=guess
lin enviable_A = mkA "invidiabile" ; -- status=guess
lin envious_A = mkA "invidioso" ; -- status=guess
lin environment_N = mkN "ambiente" masculine ; -- status=guess
lin environmental_A = mkA "ambientale" ; -- status=guess
lin environmentalist_N = mkN "ambientalista" masculine ; -- status=guess
lin envisage_V2 = variants {} ; --
lin envoi_N = mkN "congedo" | mkN "invio" ; -- UWN
lin envoy_N = mkN "inviato" ; -- status=guess
lin envy_N = mkN "invidia" ; -- status=guess
lin envy_V2 = mkV2 (mkV "invidiare") ; -- status=guess, src=wikt
lin enzymatic_A = mkA "enzimatico" ; -- status=guess
lin enzyme_N = mkN "enzima" ; -- UWN
lin eon_N = mkN "eone" masculine ; -- status=guess
lin epanaphora_N = mkN "anafora" ; -- UWN
lin epaulet_N = mkN "spallina" ; -- UWN
lin epaulette_N = mkN "spallina" ; -- status=guess
lin epee_N = mkN "spada" masculine ; -- status=guess
lin epenthesis_N = mkN "epentesi" feminine ; -- status=guess
lin ephedrine_N = mkN "efedrina" ; -- UWN
lin ephemeral_A = mkA "effimero" | mkA "passeggero" | mkA "fuggevole" | mkA "transitorio" ; -- status=guess status=guess status=guess status=guess
lin ephemerality_N = mkN "caducità" | mkN "fugacità" | mkN "labilità" ; -- UWN
lin ephemeris_N = mkN "effemeride" feminine ; -- status=guess
lin epic_N = mkN "epico" ; -- status=guess
lin epicalyx_N = mkN "epicalice" masculine ; -- status=guess
lin epicarp_N = mkN "epicarpio" | mkN "epicarpo" | mkN "esocarpio" | mkN "esocarpo" ; -- UWN
lin epicentre_N = mkN "epicentro" ; -- status=guess
lin epicure_N = mkN "bongustaio" | mkN "buongustaio" | mkN "epicureo" ; -- UWN
lin epicurean_N = mkN "bongustaio" | mkN "buongustaio" | mkN "epicureo" ; -- UWN
lin epicureanism_N = mkN "epicureismo" ; -- UWN
lin epicycle_N = mkN "epiciclo" ; -- status=guess
lin epicyclic_A = mkA "epicicloidale" ; -- UWN
lin epicycloid_N = mkN "epicicloide" feminine ; -- status=guess
lin epidemic_A = mkA "epidemico" ; -- status=guess
lin epidemic_N = mkN "epidemia" | mkN "contagio" ; -- status=guess status=guess
lin epidemiologic_A = mkA "epidemiologico" ; -- status=guess
lin epidemiologist_N = mkN "epidemiologo" ; -- status=guess
lin epidemiology_N = mkN "epidemiologia" ; -- status=guess
lin epidermis_N = mkN "epidermide" feminine ; -- status=guess
lin epididymis_N = mkN "epididimo" ; -- status=guess
lin epiglottis_N = mkN "epiglottide" ; -- UWN
lin epigone_N = mkN "epigono" ; -- UWN
lin epigram_N = mkN "arguzia" | mkN "battuta_di_spirito" | mkN "motto_di_spirito" ; -- UWN
lin epigrammatic_A = mkA "epigrammatico" ; -- status=guess
lin epigraph_N = mkN "epigrafe" ; -- UWN
lin epigraphy_N = mkN "epigrafia" ; -- UWN
lin epilepsy_N = mkN "epilessia" ; -- status=guess
lin epilepticFem_N = mkN "epilettico" ; -- UWN
lin epilepticMasc_N = mkN "epilettico" ; -- UWN
lin epileptic_A = mkA "epilettico" ; -- UWN
lin epinephrine_N = mkN "epinefrina" ; -- status=guess
lin epiphenomenon_N = mkN "epifenomeno" ; -- UWN
lin epiphora_N = mkN "epifora" | mkN "epistrofe" ; -- UWN
lin episcopacy_N = mkN "episcopato" ; -- status=guess
lin episcopal_A = mkA "episcopale" | mkA "vescovile" ; -- status=guess status=guess
lin episode_N = mkN "episodio" ; -- status=guess
lin epistemology_N = mkN "epistemologia" ; -- status=guess
lin epistle_N = mkN "epistola" ; -- status=guess
lin epistolary_A = mkA "epistolare" ; -- status=guess
lin epitaph_N = mkN "epitaffio" ; -- status=guess
lin epitaxy_N = mkN "epitassia" ; -- status=guess
lin epithelial_A = mkA "epiteliale" ; -- UWN
lin epithelioma_N = mkN "epitelioma" ; -- UWN
lin epithelium_N = mkN "epitelio" | mkN "tessuto epiteliale" ; -- status=guess status=guess
lin epithet_N = mkN "epiteto" ; -- status=guess
lin epitome_N = mkN "epitome" ; -- status=guess
lin epoch_N = mkN "orario epocale" | mkN "epoca" ; -- status=guess status=guess
lin epochal_A = mkA "epocale" ; -- UWN
lin eponym_N = mkN "eponimo" ; -- status=guess
lin eponymous_A = mkA "eponimo" ; -- UWN
lin epping_PN = mkPN "Epping" ; -- status=guess src=geonames
lin epsilon_N = mkN "epsilon" masculine ; -- status=guess
lin epsom_PN = mkPN "Epsom" ; -- status=guess src=geonames
lin equal_A = mkA "uguale" ; -- status=guess
lin equal_N = mkN "eguale" | mkN "pari" | mkN "uguale" ; -- UWN
lin equal_V2 = mkV2 (mkV "eguagliare") ; -- status=guess, src=wikt
lin equalitarian_N = mkN "egalitario" | mkN "egualitario" ; -- UWN
lin equality_N = mkN "egualità" | mkN "ugualità" | mkN "uguaglianza" ; -- status=guess status=guess status=guess
lin equalize_V2 = mkV2 (mkV "uguagliare") ; -- status=guess, src=wikt
lin equanimity_N = mkN "calma" | mkN "compostezza" | mkN "flemma" | mkN "placidità" ; -- UWN
lin equation_N = mkN "equazione" feminine ; -- status=guess
lin equator_N = mkN "equatore" masculine ; -- status=guess
lin equatorial_A = mkA "equatoriale" ; -- status=guess
lin equatorial_N = mkN "equatoriale" masculine ; -- status=guess
lin equestrian_N = mkN "equestre" masculine ; -- status=guess
lin equiangular_A = mkA "equiangolo" ; -- status=guess
lin equilateral_A = mkA "equilatero" ; -- status=guess
lin equilateral_N = mkN "triangolo equilatero" ; -- status=guess
lin equilibrium_N = mkN "equilibrio" ; -- status=guess
lin equine_N = mkN "equino" ; -- UWN
lin equinox_N = mkN "equinozio" ; -- status=guess
lin equip_V2 = variants {} ; --
lin equipment_N = variants {} ; --
lin equipoise_N = mkN "equilibrio" ; -- UWN
lin equiprobable_A = mkA "equiprobabile" ; -- status=guess
lin equitable_A = mkA "equo" | mkA "giusto" ; -- UWN
lin equity_N = variants {} ; --
lin equivalence_N = mkN "relazione di equivalenza" ; -- status=guess
lin equivalent_A = variants {} ; --
lin equivalent_N = variants {} ; --
lin equivocal_A = mkA "equivoco" ; -- status=guess
lin era_N = mkN "era" | mkN "epoca" ; -- status=guess status=guess
lin eradication_N = mkN "estirpamento" | mkN "sradicamento" ; -- UWN
lin erase_V2 = mkV2 (mkV "cancellare") ; -- status=guess, src=wikt
lin erasure_N = mkN "cancellatura" | mkN "cassatura" | mkN "frego" | mkN "scancellatura" ; -- UWN
lin erbium_N = mkN "erbio" ; -- status=guess
lin erect_A = mkA "dritto" | mkA "eretto" ; -- status=guess status=guess
lin erect_V2 = variants {} ; --
lin erecting_N = mkN "erezione" ; -- UWN
lin erection_N = mkN "erezione" feminine ; -- status=guess
lin erectness_N = mkN "perpendicolarità" | mkN "verticalità" ; -- UWN
lin eremite_N = mkN "eremita" ; -- UWN
lin erfurt_PN = mkPN "Erfurt" ; -- status=guess src=geonames
lin erg_N = mkN "erg" ; -- UWN
lin ergonomic_A = mkA "ergonomico" ; -- UWN
lin ergonomics_N = mkN "ergonomia" | mkN "human_engineering" ; -- UWN
lin ergosterol_N = mkN "ergosterolo" ; -- status=guess
lin ergotism_N = mkN "ergotismo" ; -- UWN
lin erin_PN = mkPN "Erin" ; -- status=guess src=geonames
lin eritrea_PN = mkPN "Eritrea" ; -- status=guess src=geonames
lin erlangen_PN = mkPN "Erlangen" ; -- status=guess src=geonames
lin ermine_N = mkN "ermellino" ; -- status=guess
lin erode_V = mkV "erodere" | mkV "corrodere" | mkV "rodere" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin erode_V2 = mkV2 (mkV "erodere") | mkV2 (mkV "corrodere") | mkV2 (mkV "rodere") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin erosion_N = variants {} ; --
lin erosive_A = mkA "caustico" | mkA "corrosivo" ; -- UWN
lin erotic_A = mkA "erotico" ; -- status=guess
lin eroticism_N = mkN "erotismo" ; -- status=guess
lin err_V = mkV "errare" | mkV "sbagliare" ; -- status=guess, src=wikt status=guess, src=wikt
lin errand_N = mkN "incarico" ; -- status=guess
lin errant_A = mkA "errante" ; -- status=guess
lin erratum_N = mkN "refuso" ; -- UWN
lin erroneous_A = variants {} ;
lin erroneousness_N = mkN "errore" ; -- UWN
lin error_N = mkN "errore" masculine ; -- status=guess
lin erudite_A = mkA "erudito" ; -- status=guess
lin eruption_N = mkN "eruzione" feminine ; -- status=guess
lin erysipelas_N = mkN "eresipela" | mkN "erisipela" ; -- UWN
lin erythema_N = mkN "eritema" masculine ; -- status=guess
lin erythroblast_N = mkN "eritroblasto" ; -- status=guess
lin erythropoietin_N = mkN "eritropoietina" ; -- status=guess
lin escalation_N = mkN "escalation" ; -- UWN
lin escalator_N = mkN "scala mobile" ; -- status=guess
lin escape_N = mkN "velocità di fuga" ; -- status=guess
lin escape_V = mkV "evitare" ; -- status=guess, src=wikt
lin escape_V2 = mkV2 (mkV "evitare") ; -- status=guess, src=wikt
lin escape_VS = mkVS (mkV "evitare") ; -- status=guess, src=wikt
lin escapee_N = mkN "evaso" ; -- UWN
lin escargot_N = mkN "lumaca" ; -- UWN
lin eschar_N = mkN "escara" ; -- status=guess
lin eschatological_A = mkA "escatologico" ; -- status=guess
lin eschatology_N = mkN "escatologia" ; -- status=guess
lin eschew_V2 = mkV2 (mkV "schivare") ; -- status=guess, src=wikt
lin escort_N = mkN "scorta" ; -- status=guess
lin escritoire_N = mkN "secretaire" | mkN "secrétaire" ; -- UWN
lin escutcheon_N = mkN "scudo" | mkN "blasone" masculine | mkN "stemma" masculine ; -- status=guess status=guess status=guess
lin esophageal_A = mkA "esofageo" ; -- status=guess
lin esophagus_N = mkN "esofago" ; -- UWN
lin esoteric_A = mkA "esoterico" | mkA "esoterica" | mkA "esoterici" | mkA "esoteriche" ; -- status=guess status=guess status=guess status=guess
lin espadrille_N = mkN "espadrillas" | mkN "espadrilles" ; -- UWN
lin espalier_N = mkN "spalliera" ; -- UWN
lin especial_A = mkA "particolare" | mkA "speciale" ; -- UWN
lin espionage_N = mkN "spionaggio" ; -- status=guess
lin esplanade_N = mkN "lungomare" ; -- UWN
lin espousal_N = mkN "accettazione" | mkN "accoglimento" | mkN "adesione" | mkN "adozione" ; -- UWN
lin espresso_N = mkN "espresso" ; -- status=guess
lin esprit_de_corps_N = mkN "affiatamento" | mkN "sintonia" | mkN "spirito_di_collaborazione" | mkN "spirito_di_gruppo" | mkN "spirito_di_squadra" ; -- UWN
lin essay_N = mkN "tentativo" | mkN "prova" ; -- status=guess status=guess
lin essay_V = mkV "analizzare" | mkV "collaudare" | mkV "esperimentare" | mkV "provare" | mkV "sperimentare" | mkV "testare" ; -- UWN
lin essayist_N = mkN "saggista" ; -- UWN
lin essen_PN = mkPN "Essen" ; -- status=guess src=geonames
lin essence_N = mkN "essenza" masculine ; -- status=guess
lin essential_A = mkA "essenziale" | mkA "indispensabile" ; -- status=guess status=guess
lin essential_N = mkN "essenza" masculine ; -- status=guess
lin essentiality_N = mkN "essenzialità" feminine ; -- status=guess
lin essex_PN = mkPN "Essex" ; -- status=guess src=geonames
lin establish_V2 = mkV2 (mkV "stabilire") ; -- status=guess, src=wikt
lin established_A = variants {} ; --
lin establishment_N = mkN "costituzione" | mkN "formazione" ; -- UWN
lin estaminet_N = mkN "baretto" ; -- UWN
lin estate_N = mkN "proprietà" feminine | mkN "tenuta" | mkN "possedimento" ; -- status=guess status=guess status=guess
lin esteem_N = mkN "stima" ; -- status=guess
lin ester_N = mkN "estere" masculine ; -- status=guess
lin esther_PN = mkPN "Esther" ; -- status=guess src=geonames
lin esthete_N = mkN "esteta" ; -- UWN
lin esthetics_N = mkN "estetica" ; -- UWN
lin estimate_N = mkN "stima" ; -- status=guess
lin estimate_V = mkV "stimare" ; -- status=guess, src=wikt
lin estimate_V2 = mkV2 (mkV "stimare") ; -- status=guess, src=wikt
lin estimate_V2V = mkV2V (mkV "stimare") ; -- status=guess, src=wikt
lin estimate_VS = mkVS (mkV "stimare") ; -- status=guess, src=wikt
lin estimated_A = variants {} ; --
lin estimation_N = mkN "stima" ; -- status=guess
lin estradiol_N = mkN "estradiolo" ; -- status=guess
lin estrangement_N = mkN "alienazione" | mkN "disaffezione" | mkN "estraneazione" | mkN "estraniazione" ; -- UWN
lin estrogen_N = mkN "estrogeno" ; -- status=guess
lin estrus_N = mkN "calore" | mkN "foia" | mkN "fregola" ; -- UWN
lin estuary_N = mkN "estuario" ; -- status=guess
lin etcher_N = mkN "acquafortista" ; -- UWN
lin etching_N = mkN "incisione" | mkN "incisione_all'acquaforte" ; -- UWN
lin eternal_A = mkA "eterno" ; -- status=guess
lin eternity_N = mkN "eternità" feminine ; -- status=guess
lin ethane_N = mkN "etano" ; -- status=guess
lin ethereal_A = mkA "etereo" ; -- status=guess
lin ethical_A = variants {} ; --
lin ethics_N = mkN "etica" ; -- status=guess
lin ethiopia_PN = mkPN "Etiopia" ; -- status=guess src=geonames
lin ethnic_A = mkA "etnico" | mkA "etnica" ; -- status=guess status=guess
lin ethnic_N = mkN "pulizia etnica" ; -- status=guess
lin ethnicity_N = mkN "etnicità" feminine ; -- status=guess
lin ethnocentric_A = mkA "etnocentrico" ; -- UWN
lin ethnocentrism_N = mkN "etnocentrismo" ; -- status=guess
lin ethnographer_N = mkN "etnografo" ; -- UWN
lin ethnographic_A = mkA "etnografico" ; -- status=guess
lin ethnography_N = mkN "etnografia" ; -- status=guess
lin ethnological_A = mkA "etnologico" ; -- UWN
lin ethnologist_N = mkN "etnologo" ; -- UWN
lin ethnology_N = mkN "etnologia" ; -- UWN
lin ethologist_N = mkN "etologo" ; -- UWN
lin ethology_N = mkN "etologia" ; -- status=guess
lin ethos_N = mkN "ethos" | mkN "etos" ; -- UWN
lin ethyl_N = mkN "etile" ;
lin ethylene_N = mkN "etilene" masculine ; -- status=guess
lin etiolation_N = mkN "eziolamento" ; -- status=guess
lin etiological_A = mkA "etiologico" ; -- status=guess
lin etiquette_N = mkN "buone_maniere" | mkN "cerimoniale" | mkN "etichetta" | mkN "galateo" | mkN "rituale" ; -- UWN
lin etymological_A = mkA "etimologico" ; -- status=guess
lin etymologist_N = mkN "etimologista" masculine | mkN "etimologo" | mkN "etimologa" ; -- status=guess status=guess status=guess
lin etymology_N = mkN "etimologia" ; -- status=guess
lin etymon_N = mkN "etimo" ; -- status=guess
lin eucalyptus_N = mkN "eucalitto" ; -- status=guess
lin eudemonic_A = mkA "eudemonistico" ; -- UWN
lin eudiometer_N = mkN "eudiometro" ; -- status=guess
lin eugene_PN = mkPN "Eugene" ; -- status=guess src=geonames
lin eugenic_A = mkA "eugenetico" | mkA "eugenico" ; -- status=guess status=guess
lin eugenics_N = mkN "eugenetica" | mkN "eugenica" ; -- UWN
lin eukaryote_N = mkN "eucariota" masculine ; -- status=guess
lin eukaryotic_A = mkA "eucariotico" ; -- status=guess
lin eulogist_N = mkN "panegirista" ; -- UWN
lin eunice_PN = mkPN "Eunice" ; -- status=guess src=geonames
lin eunuch_N = mkN "eunuco" ; -- status=guess
lin euphemism_N = mkN "eufemismo" ; -- status=guess
lin euphemistic_A = mkA "eufemistico" ; -- status=guess
lin euphonic_A = mkA "eufonico" ; -- status=guess
lin euphony_N = mkN "eufonia" ; -- status=guess
lin euphorbium_N = mkN "euforbio" ; -- UWN
lin euphoria_N = mkN "euforia" ; -- status=guess
lin euphoric_A = mkA "euforico" ; -- status=guess
lin euphuism_N = mkN "eufuismo" ; -- status=guess
lin euro_N = mkN "euro" "euro" masculine ; -- status=guess
lin europium_N = mkN "europio" ; -- status=guess
lin eutectic_N = mkN "crioidrato" | mkN "eutettico" ; -- UWN
lin euthanasia_N = mkN "eutanasia" ; -- status=guess
lin eutrophication_N = mkN "eutrofizzazione" feminine ; -- status=guess
lin evacuate_V2 = mkV2 (mkV "evacuare") ; -- status=guess, src=wikt
lin evacuation_N = mkN "evacuamento" ; -- status=guess
lin evacuee_N = mkN "sfollato" ; -- UWN
lin evaluate_V = mkV "valutare" ; -- status=guess, src=wikt
lin evaluate_V2 = mkV2 (mkV "valutare") ; -- status=guess, src=wikt
lin evaluation_N = mkN "valutazione" feminine ; -- status=guess
lin evaluator_N = mkN "giudice" ; -- UWN
lin evangelist_N = mkN "evangelista" ; -- status=guess
lin evaporate_V = mkV "evaporare" ; -- status=guess, src=wikt
lin evaporate_V2 = mkV2 (mkV "evaporare") ; -- status=guess, src=wikt
lin evaporate_VS = mkVS (mkV "evaporare") ; -- status=guess, src=wikt
lin evaporation_N = mkN "vaporizzazione" feminine ; -- status=guess
lin evaporative_A = mkA "evaporativo" ; -- UWN
lin evasion_N = mkN "evasione" feminine ; -- status=guess
lin even_1_A = mkA "pari" ; -- status=guess
lin even_2_A = mkA "pari" ; -- status=guess
lin even_Adv = mkAdv "ancora" ;
lin even_N = mkN "sera" ; -- status=guess
lin even_V2 = mkV2 (mkV "spianare") ; -- status=guess, src=wikt
lin evening_N = mkN "sera" ; -- status=guess
lin evensong_N = mkN "vespro" ; -- UWN
lin event_N = mkN "evento" ; -- status=guess
lin eventide_N = mkN "sera" ; -- UWN
lin eventual_A = variants {} ; --
lin eventuality_N = mkN "evenienza" | mkN "eventualità" | mkN "imprevisto" | mkN "occorrenza" ; -- UWN
lin ever_AdV = mkAdV "mai" | mkAdV "sempre" ; -- UWN
lin ever_Adv = mkAdv "sempre" ; -- UWN
lin evergreen_A = mkA "sempreverde" ; -- UWN
lin evergreen_N = mkN "perpetuino" | mkN "sempreverde" | mkN "semprevivo" ; -- UWN
lin everlasting_N = mkN "elicriso" ; -- UWN
lin eversion_N = mkN "inversione" ; -- UWN
lin every_Det = S.every_Det ;
lin everybody_NP = S.everybody_NP ;
lin everyday_A = variants {} ; --
lin everyone_NP = variants {} ; --
lin everything_NP = S.everything_NP ;
lin everywhere_Adv = S.everywhere_Adv ;
lin evesham_PN = mkPN "Evesham" ; -- status=guess src=geonames
lin evict_V2 = mkV2 (espellere_V) | mkV2 (mkV "sfrattare") ; -- status=guess, src=wikt status=guess, src=wikt
lin eviction_N = mkN "espulsione" feminine ; -- status=guess
lin evidence_1_N = variants {} ; --
lin evidence_2_N = variants {} ; --
lin evidence_N = variants {} ; --
lin evident_A = mkA "evidente" ; -- status=guess
lin evidential_A = mkA "probatorio" ; -- status=guess
lin evil_A = mkA "malvagio" ; -- status=guess
lin evil_N = mkN "male" masculine ; -- status=guess
lin evince_V2 = mkV2 (mkV "dimostrare") | mkV2 (mkV "manifestare") ; -- status=guess, src=wikt status=guess, src=wikt
lin evitable_A = mkA "derogabile" | mkA "eludibile" | mkA "evitabile" ; -- UWN
lin evocation_N = mkN "evocazione" feminine ; -- status=guess
lin evocative_A = mkA "evocativo" ; -- status=guess
lin evoke_V2 = mkV2 (mkV "evocare") | mkV2 (mkV "rammemorare") | mkV2 (mkV "rammentare") | mkV2 (mkV "rammemorare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin evolution_N = mkN "evoluzione" feminine ; -- status=guess
lin evolutionary_A = mkA "evolutivo" ; -- UWN
lin evolutionistFem_N = variants {} ; ---- sense to be split
lin evolutionistMasc_N = variants {} ; ---- sense to be split
lin evolve_V = variants {} ; --
lin evolve_V2 = variants {} ; --
lin ewe_N = mkN "pecora" ; -- status=guess
lin ewell_PN = mkPN "Ewell" ; -- status=guess src=geonames
lin ewer_N = mkN "brocca" | mkN "caraffa" ; -- status=guess status=guess
lin exacerbate_V2 = mkV2 (mkV "esacerbare") ; -- status=guess, src=wikt
lin exacerbation_N = mkN "esacerbazione" feminine | mkN "esacerbamento" ; -- status=guess status=guess
lin exact_A = mkA "esatto" ; -- status=guess
lin exacta_N = mkN "abbinata" | mkN "accoppiata" ; -- UWN
lin exactitude_N = mkN "accuratezza" | mkN "determinatezza" | mkN "esattezza" | mkN "precisione" | mkN "rigore" ; -- UWN
lin exactness_N = mkN "accuratezza" | mkN "determinatezza" | mkN "esattezza" | mkN "precisione" | mkN "rigore" ; -- UWN
lin exaggerate_V = mkV "esagerare" ; -- status=guess, src=wikt
lin exaggerate_V2 = mkV2 (mkV "esagerare") ; -- status=guess, src=wikt
lin exaggeration_N = mkN "esagerazione" feminine ; -- status=guess
lin exalt_V2 = mkV2 (mkV "esaltare") ; -- status=guess, src=wikt
lin exaltation_N = mkN "apoteosi" | mkN "deificazione" | mkN "divinizzazione" ; -- UWN
lin exam_N = variants {} ; --
lin examination_N = mkN "esame" masculine ; -- status=guess
lin examine_V2 = variants {} ; --
lin examiner_N = mkN "esaminatore" masculine ; -- status=guess
lin example_N = mkN "esempio" ;
lin exasperation_N = mkN "esasperazione" ; -- UWN
lin excavation_N = mkN "estrazione" ; -- UWN
lin excavator_N = mkN "escavatore" | mkN "escavatrice" | mkN "pala_meccanica" | mkN "scavatrice" | mkN "terrazziere" ; -- UWN
lin exceed_V2 = mkV2 (mkV "eccedere") ; -- status=guess, src=wikt
lin exceeding_A = mkA "eccezionale" ; -- UWN
lin excel_V = mkV "superare" ; -- status=guess, src=wikt
lin excel_V2 = mkV2 (mkV "superare") ; -- status=guess, src=wikt
lin excellence_N = mkN "bontà" | mkN "eccellenza" ; -- UWN
lin excellent_A = mkA "eccellente" ; -- status=guess
lin excelsior_N = mkN "trucioli_di_legno" ; -- UWN
lin except_Conj = variants {} ; --
lin except_Prep = S.except_Prep ;
lin exception_N = mkN "eccezione" feminine ; -- status=guess
lin exceptional_A = mkA "eccezionale" ; -- status=guess
lin excess_A = variants {} ; --
lin excess_N = mkN "eccedenza" ; -- status=guess
lin excessive_A = mkA "eccessivo" ; -- status=guess
lin exchange_N = mkN "scambio" | mkN "cambio" ; -- status=guess status=guess
lin exchange_V2 = mkV2 (mkV "cambiare") | mkV2 (mkV "scambiare") ; -- status=guess, src=wikt status=guess, src=wikt
lin exchangeability_N = mkN "intercambiabilità" ; -- UWN
lin exchequer_N = mkN "finanze" | mkN "tesoro" ; -- UWN
lin excise_N = mkN "accisa" ; -- status=guess
lin exciseman_N = mkN "esattore" | mkN "esattore_delle_imposte" ; -- UWN
lin excitability_N = mkN "eccitabiltà" ; -- UWN
lin excitable_A = mkA "eccitabile" | mkA "emotivo" ; -- UWN
lin excitation_N = mkN "eccitazione" feminine ; -- status=guess
lin excite_V2 = mkV2 (mkV "provocare") | mkV2 (accendere_V) | mkV2 (mkV "stimolare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin excited_A = variants {} ; --
lin excitement_N = mkN "eccitamento" | mkN "orgasmo" ; -- status=guess status=guess
lin exciting_A = variants {} ; --
lin exclaim_V2 = variants {} ; --
lin exclamation_N = mkN "esclamazione" feminine ; -- status=guess
lin exclude_V2 = variants {} ; --
lin exclusion_N = mkN "esclusione" feminine ; -- status=guess
lin exclusive_A = variants {} ; --
lin exclusive_N = mkN "destra esclusiva" ; -- status=guess
lin excogitation_N = mkN "concezione" | mkN "ideazione" | mkN "invenzione" ; -- UWN
lin excommunicate_V2 = mkV2 (mkV "scomunicare") ; -- status=guess, src=wikt
lin excommunication_N = mkN "scomunica" ; -- status=guess
lin excoriate_V2 = mkV2 (mkV "escoriare") ; -- status=guess, src=wikt
lin excoriation_N = mkN "aspra_critica" ; -- UWN
lin excrement_N = mkN "escremento" ; -- status=guess
lin excrete_V2 = mkV2 (espellere_V) ; -- status=guess, src=wikt
lin excretion_N = mkN "escrezione" ; -- UWN
lin excruciating_A = mkA "atroce" | mkA "straziante" | mkA "lancinante" | mkA "struggente" | mkA "cruciale" ; -- status=guess status=guess status=guess status=guess status=guess
lin exculpation_N = mkN "difesa" | mkN "discolpa" | mkN "scusante" ; -- UWN
lin excursion_N = mkN "gita" | mkN "escursione" feminine ; -- status=guess status=guess
lin excursionist_N = mkN "gitante" ; -- UWN
lin excuse_N = mkN "scusa" | mkN "pretesto" ; -- status=guess status=guess
lin excuse_V2 = mkV2 (mkV "scusare") ; -- status=guess, src=wikt
lin excuse_me_Interj = mkInterj "scusa" ;
lin execute_V2 = variants {} ; --
lin execution_N = mkN "esecuzione" feminine ; -- status=guess
lin executioner_N = mkN "boia" | mkN "carnefice" masculine ; -- status=guess status=guess
lin executive_A = variants {} ; --
lin executive_N = variants {} ; --
lin executor_N = mkN "esecutore_testamentario" ; -- UWN
lin exegesis_N = mkN "esegesi" feminine ; -- status=guess
lin exegetic_A = mkA "ermeneutico" | mkA "esegetico" | mkA "interpretativo" ; -- UWN
lin exemplar_N = mkN "esempio" | mkN "modello" ; -- UWN
lin exemplary_A = mkA "esemplare" ; -- status=guess
lin exemplification_N = mkN "tipizzazione" ; -- UWN
lin exemption_N = variants {} ; --
lin exercise_N = mkN "cicletta" | mkN "cyclette" ; -- status=guess status=guess
lin exercise_V = mkV "esercitare" ; -- status=guess, src=wikt
lin exercise_V2 = mkV2 (mkV "esercitare") ; -- status=guess, src=wikt
lin exercise_VV = mkVV (mkV "esercitare") ; -- status=guess, src=wikt
lin exert_V2 = variants {} ; --
lin exeter_PN = mkPN "Exeter" ; -- status=guess src=geonames
lin exhaust_N = mkN "tubo di scappamento" | mkN "scarico" ; -- status=guess status=guess
lin exhaust_V2 = variants {} ; --
lin exhaustion_N = mkN "esaurimento" ; -- UWN
lin exhibit_N = mkN "esposizione" feminine ; -- status=guess
lin exhibit_V2 = mkV2 (mkV "dimostrare") ; -- status=guess, src=wikt
lin exhibition_N = mkN "esibizione" ; -- UWN
lin exhibitioner_N = mkN "espositore" ; -- UWN
lin exhibitor_N = mkN "espositore" ; -- UWN
lin exhilaration_N = mkN "effervescenza" ; -- UWN
lin exhumation_N = mkN "disseppellimento" | mkN "dissotterramento" | mkN "esumazione" | mkN "riesumazione" ; -- UWN
lin exigency_N = mkN "emergenza" ; -- UWN
lin exiguous_A = mkA "esiguo" ; -- status=guess
lin exile_N = mkN "esiliato" | mkN "esule" ; -- status=guess status=guess
lin exile_V2 = mkV2 (mkV "esiliare") ; -- status=guess, src=wikt
lin exist_V = esistere_V ; -- status=guess, src=wikt
lin existence_N = mkN "esistenza" ; -- status=guess
lin existent_A = mkA "esistente" ; -- status=guess
lin existentialism_N = mkN "esistenzialismo" ; -- status=guess
lin existentialist_A = mkA "esistenzialista" | mkA "esistenzialistico" ; -- UWN
lin existentialist_N = mkN "esistenzialista" ; -- UWN
lin existing_A = variants {} ; --
lin exit_N = mkN "uscita" ; -- status=guess
lin exit_V = uscire_V ; -- status=guess, src=wikt
lin exmouth_PN = mkPN "Exmouth" ; -- status=guess src=geonames
lin exocrine_A = mkA "esocrino" ; -- UWN
lin exodus_N = mkN "esodo" ; -- status=guess
lin exogamy_N = mkN "esogamia" ; -- UWN
lin exophthalmos_N = mkN "esoftalmo" ; -- status=guess
lin exorbitance_N = mkN "esorbitanza" ; -- UWN
lin exorbitant_A = mkA "esorbitante" ; -- status=guess
lin exorcism_N = mkN "esorcismo" ; -- status=guess
lin exorcist_N = mkN "esorcista" masculine ; -- status=guess
lin exoskeleton_N = mkN "esoscheletro" ; -- status=guess
lin exosphere_N = mkN "esosfera" ; -- UWN
lin exoteric_A = mkA "essoterico" | mkA "essoterica" | mkA "essoterici" | mkA "essoteriche" ; -- status=guess status=guess status=guess status=guess
lin exothermic_A = mkA "esotermico" ; -- UWN
lin exotic_A = mkA "esotico" ; -- status=guess
lin exoticism_N = mkN "esoticità" ; -- UWN
lin exotoxin_N = mkN "esotossina" ; -- status=guess
lin expand_V = mkV "crescere" | mkV "espandersi" | mkV "estendersi" | mkV "ingrossarsi" | mkV "svilupparsi" ; -- UWN
lin expand_V2 = variants {} ; --
lin expandable_A = mkA "dilatabile" | mkA "espandibile" ; -- status=guess status=guess
lin expanse_N = mkN "distesa" | mkN "estensione" ; -- UWN
lin expansion_N = mkN "espansione" feminine ; -- status=guess
lin expansionism_N = mkN "espansionismo" ; -- UWN
lin expansive_A = mkA "espansivo" ; -- UWN
lin expansiveness_N = mkN "espansività" ; -- UWN
lin expatriate_N = mkN "espatriato" ; -- status=guess
lin expatriate_V2 = mkV2 (mkV "espatriare") ; -- status=guess, src=wikt
lin expect_V = variants {} ; --
lin expect_V2 = variants {} ; --
lin expect_V2V = variants {} ; --
lin expect_VS = variants {} ; --
lin expect_VV = variants {} ; --
lin expectation_N = mkN "attesa" ; -- status=guess
lin expected_A = variants {} ; --
lin expectorate_V = mkV "espettorare" ; -- UWN
lin expedience_N = mkN "opportunismo" ; -- UWN
lin expedient_A = mkA "opportuno" ; -- status=guess
lin expedient_N = mkN "espediente" | mkN "escamotage" ; -- status=guess status=guess
lin expedition_N = mkN "spedizione" feminine ; -- status=guess
lin expel_V2 = mkV2 (espellere_V) ; -- status=guess, src=wikt
lin expend_V2 = mkV2 (mkV "spendere") ; -- status=guess, src=wikt
lin expenditure_N = mkN "spendere" masculine ; -- status=guess
lin expense_N = variants {} ; --
lin expensive_A = mkA "caro" | mkA "costoso" ; -- status=guess status=guess
lin experience_N = mkN "esperienza" ; -- status=guess
lin experience_V2 = mkV2 (mkV "esperire") ; -- status=guess, src=wikt
lin experienced_A = variants {} ; --
lin experiential_A = mkA "esperienziale" ; -- status=guess
lin experiment_N = mkN "esperimento" ; -- UWN
lin experiment_V = variants {} ; --
lin experiment_V2 = variants {} ; --
lin experimental_A = variants {} ; --
lin experimenterFem_N = mkN "esperimentatore" | mkN "sperimentatore" ; -- UWN
lin experimenterMasc_N = mkN "esperimentatore" | mkN "sperimentatore" ; -- UWN
lin expert_A = variants {} ; --
lin expert_N = variants {} ; --
lin expertise_N = variants {} ; --
lin expiate_V2 = mkV2 (mkV "espiare") ; -- status=guess, src=wikt
lin expiatory_A = mkA "espiatore" | mkA "espiatorio" | mkA "propiziatorio" | mkA "purificatore" ; -- UWN
lin expiratory_A = mkA "espiratorio" | mkA "espiratore" ; -- status=guess status=guess
lin expire_VS = mkvVS "espirare" ; -- UWN
lin expiry_N = mkN "decesso" | mkN "morte" ; -- UWN
lin explain_V2 = mkV2 (mkV "spiegare") ; -- status=guess, src=wikt
lin explain_VS = mkVS (mkV "spiegare") ; -- status=guess, src=wikt
lin explain_away_V = advV (lin V OP_explain_V2) OP_away_Adv ; -- guess-p-verb
lin explanation_N = mkN "spiegazione" feminine ; -- status=guess
lin expletive_N = mkN "bestemmia" | mkN "eresia" | mkN "giaculatoria" | mkN "imprecazione" | mkN "maledizione" | mkN "moccolo" | mkN "parolaccia" | mkN "sozzeria" ; -- UWN
lin explicable_A = mkA "illustrabile" | mkA "motivabile" | mkA "spiegabile" ; -- status=guess status=guess status=guess
lin explicit_A = variants {} ; --
lin explode_V = esplodere_V ; -- status=guess, src=wikt
lin exploit_V2 = mkV2 (mkV (mkV "sfruttare") "di") ; -- status=guess, src=wikt
lin exploitation_N = variants {} ; --
lin exploiter_N = mkN "piovra" | mkN "sfruttatore" | mkN "sgozzatore" | mkN "succhione" | mkN "succiasangue" | mkN "succione" ; -- UWN
lin exploration_N = mkN "esplorazione" feminine ; -- status=guess
lin exploratory_A = mkA "esplorativo" ; -- UWN
lin explore_V2 = mkV2 (mkV "esplorare") ; -- status=guess, src=wikt
lin explore_VS = mkVS (mkV "esplorare") ; -- status=guess, src=wikt
lin explorerFem_N = variants {} ; ---- sense to be split
lin explorerMasc_N = variants {} ; ---- sense to be split
lin explosion_N = mkN "esplosione" feminine ; -- status=guess
lin explosive_A = mkA "irascibile" | mkA "collerico" | mkA "iracondo" ; -- status=guess status=guess status=guess
lin explosive_N = mkN "esplosivo" ; -- status=guess
lin expo_N = mkN "esposizione" | mkN "fiera" | mkN "mostra" | mkN "rassegna" ; -- UWN
lin exponent_1_N = mkN "esponente" ; -- UWN
lin exponent_2_N = mkN "esponente" ; -- UWN
lin exponential_A = mkA "esponenziale" ; -- UWN
lin exponential_N = mkN "distribuzione esponenziale" ; -- status=guess
lin export_N = mkN "esportazione" feminine ; -- status=guess
lin export_V = mkV "esportare" ; -- status=guess, src=wikt
lin export_V2 = mkV2 (mkV "esportare") ; -- status=guess, src=wikt
lin exportable_A = mkA "esportabile" ; -- UWN
lin exporterFem_N = mkN "esportatore" ; -- UWN
lin exporterMasc_N = mkN "esportatore" ; -- UWN
lin exporting_N = mkN "esportazione" ; -- UWN
lin expose_V = esporre_V ; -- status=guess, src=wikt
lin expose_V2 = mkV2 (esporre_V) ; -- status=guess, src=wikt
lin exposition_N = mkN "esposizione" feminine | mkN "mostra" ; -- status=guess status=guess
lin exposure_N = mkN "espozione" feminine ; -- status=guess
lin express_A = variants {} ; --
lin express_N = mkN "espresso" ; -- status=guess
lin express_V2 = mkV2 (esprimere_V) ; -- status=guess, src=wikt
lin expressible_A = mkA "dicibile" | mkA "esprimibile" | mkA "narrabile" | mkA "nominabile" | mkA "proferibile" | mkA "pronunziabile" | mkA "riferibile" ; -- UWN
lin expression_N = mkN "espressione" feminine ; -- status=guess
lin expressionism_N = mkN "espressionismo" | mkN "espressionismo" ; -- UWN
lin expressionistFem_N = mkN "espressionista" ; -- UWN
lin expressionistMasc_N = mkN "espressionista" ; -- UWN
lin expressionist_A = mkA "espressionista" | mkA "espressionistico" ; -- UWN
lin expressive_A = mkA "espressivo" ; -- status=guess
lin expressiveness_N = mkN "espressione" | mkN "espressività" | mkN "forza_espressiva" ; -- UWN
lin expressway_N = mkN "superstrada" ; -- status=guess
lin expropriate_V2 = mkV2 (mkV "espropriare") ; -- status=guess, src=wikt
lin expulsion_N = mkN "espulsione" feminine ; -- status=guess
lin expunction_N = mkN "cancellatura" | mkN "cassatura" | mkN "frego" | mkN "scancellatura" ; -- UWN
lin expurgation_N = mkN "espurgazione" ; -- UWN
lin exquisite_A = mkA "squisito" | mkA "delizioso" ; -- status=guess status=guess
lin extemporization_N = mkN "improvvisazione" ; -- UWN
lin extemporize_V = mkV (mkV "parlare") "a braccio" ; -- status=guess, src=wikt
lin extemporize_V2 = mkV2 (mkV (mkV "parlare") "a braccio") ; -- status=guess, src=wikt
lin extend_V = mkV "coprire" ; -- UWN
lin extend_V2 = variants {} ; --
lin extended_A = variants {} ; --
lin extendible_A = mkA "estendibile" | mkA "prolungabile" ; -- status=guess status=guess
lin extension_N = mkN "annesso" | mkN "braccio" ; -- UWN
lin extensive_A = mkA "vasto" ; -- status=guess
lin extent_N = mkN "misura" ; -- status=guess
lin extenuation_N = mkN "addolcimento" | mkN "attenuazione" | mkN "mitigazione" ; -- UWN
lin exterior_A = mkA "esterno" ; -- UWN
lin exterior_N = mkN "esterno" | mkN "fuori" ; -- UWN
lin external_A = variants {} ; --
lin externalization_N = mkN "esteriorizzazione" ; -- UWN
lin exterritorial_A = mkA "extraterritoriale" ; -- UWN
lin extinction_N = mkN "estinzione" | mkN "spegnimento" ; -- UWN
lin extinguish_V2 = mkV2 (estinguere_V) ; -- status=guess, src=wikt
lin extinguishable_A = mkA "estinguibile" ; -- UWN
lin extinguisher_N = mkN "estintore" | mkN "schiumogeno" ; -- UWN
lin extortion_N = mkN "estorsione" feminine ; -- status=guess
lin extra_A = mkA "extra" ; -- status=guess
lin extra_Adv = mkAdv "eccezionalmente" | mkAdv "straordinariamente" ; -- status=guess status=guess
lin extra_N = mkN "tempi supplementari" ; -- status=guess
lin extracellular_A = mkA "extracellulare" ; -- status=guess
lin extract_N = variants {} ; --
lin extract_V2 = mkV2 (mkV "cavare") ; -- status=guess, src=wikt
lin extractor_N = mkN "estrattore" ; -- UWN
lin extrados_N = mkN "estradosso" ; -- UWN
lin extragalactic_A = mkA "estragalattico" | mkA "extragalattico" ; -- status=guess status=guess
lin extrajudicial_A = mkA "extragiudiziale" | mkA "extragiuridico" ; -- status=guess status=guess
lin extralinguistic_A = mkA "extralinguistico" ; -- UWN
lin extramarital_A = mkA "extraconiugale" ; -- status=guess
lin extraneous_A = mkA "esterno" ; -- UWN
lin extraneousness_N = mkN "estraneità" ; -- UWN
lin extraordinariness_N = mkN "straordinarietà" ; -- UWN
lin extraordinary_A = mkA "straordinario" | mkA "straordinaria" ; -- status=guess status=guess
lin extrapolate_V = mkV "estrapolare" ; -- status=guess, src=wikt
lin extrapolate_V2 = mkV2 (mkV "estrapolare") ; -- status=guess, src=wikt
lin extrapolation_N = mkN "estrapolazione" feminine ; -- status=guess
lin extrasensory_A = mkA "extrasensoriale" ; -- status=guess
lin extrasystolic_A = mkA "extrasistolico" ; -- status=guess
lin extraterrestrial_A = mkA "extraterrestre" ; -- status=guess
lin extraterritorial_A = mkA "extraterritoriale" ; -- UWN
lin extravagance_N = mkN "prodigalità" ; -- UWN
lin extravagant_A = mkA "stravagante" | mkA "estravagante" ; -- status=guess status=guess
lin extraversion_N = mkN "estroversione" ; -- UWN
lin extreme_A = mkA "profondo" | mkA "profonda" ; -- status=guess status=guess
lin extreme_N = mkN "estremo" ; -- status=guess
lin extremism_N = mkN "estremismo" | mkN "oltranzismo" ; -- UWN
lin extremist_A = mkA "radicale" ; -- UWN
lin extremist_N = mkN "estremista" | mkN "massimalista" | mkN "oltranzista" | mkN "ultrà" ; -- UWN
lin extremity_N = mkN "estremità" feminine ; -- status=guess
lin extremum_N = mkN "estremo" ; -- status=guess
lin extrinsic_A = mkA "estrinseco" ; -- status=guess
lin extroversion_N = mkN "estroversione" ; -- UWN
lin extrusion_N = mkN "estrusione" feminine ; -- status=guess
lin extrusive_A = mkA "estrusivo" ; -- status=guess
lin exudate_N = mkN "essudato" ; -- UWN
lin exudation_N = mkN "trasudazione" ; -- UWN
lin exude_V = mkV "trasudare" ; -- status=guess, src=wikt
lin exude_V2 = mkV2 (mkV "trasudare") ; -- status=guess, src=wikt
lin exult_V = mkV "esultare" ; -- status=guess, src=wikt
lin eye_N = L.eye_N ;
lin eyeball_N = mkN "bulbo oculare" ; -- status=guess
lin eyebath_N = mkN "occhiera" | mkN "occhino" ; -- UWN
lin eyebrow_N = mkN "sopracciglio" ; -- status=guess
lin eyeglass_N = mkN "caramella" | mkN "monocolo" ; -- UWN
lin eyelash_N = mkN "ciglio" ; -- status=guess
lin eyelet_N = mkN "occhiello" ; -- UWN
lin eyelid_N = mkN "palpebra" ; -- status=guess
lin eyepiece_N = mkN "oculare" ; -- UWN
lin eye_shadow_N = mkN "ombretto" ; -- UWN
lin eyesight_N = mkN "vedere" | mkN "vista" ; -- UWN
lin eyesore_N = mkN "pugno in un occhio" ; -- status=guess
lin eyespot_N = mkN "ocello" ; -- UWN
lin eyewitness_N = mkN "testimone oculare" ; -- status=guess
lin eyrir_N = mkN "aurar" | mkN "aurar_islandese" | mkN "eyrir" | mkN "eyrir_islandese" ; -- UWN
lin fa_N = mkN "fa" ; -- UWN
lin fable_N = mkN "fiaba" masculine ; -- status=guess
lin fabric_N = mkN "struttura" | mkN "tessuto" ; -- status=guess status=guess
lin fabricate_V2 = mkV2 (mkV "fabbricare") ; -- status=guess, src=wikt
lin fabulist_N = mkN "favolista" | mkN "novellante" | mkN "novellatore" | mkN "novelliere" | mkN "novellista" ; -- UWN
lin fabulous_A = mkA "favoloso" ; -- status=guess
lin facade_N = variants {} ; --
lin face_N = mkN "faccia" ; -- status=guess
lin face_V = mkV "fronteggiare" | mkV (porre_V) "mano" | mkV "sistemare" | mkV "confrontarsi" | risolvere_V ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin face_V2 = mkV2 (mkV "fronteggiare") | mkV2 (mkV (porre_V) "mano") | mkV2 (mkV "sistemare") | mkV2 (mkV "confrontarsi") | mkV2 (risolvere_V) ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin face_off_V2 = prepV2 OP_face_V OP_off_Prep ; -- guess-p-verb
lin face_up_to_V2 = prepV2 (advV OP_face_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin faceplate_N = mkN "bocchetta" ; -- UWN
lin facet_N = mkN "faccetta" ; -- status=guess
lin facia_N = mkN "fascia" ; -- UWN
lin facial_A = mkA "facciale" ; -- status=guess
lin facile_A = mkA "facondo" ; -- UWN
lin facilitate_V2 = variants {} ; --
lin facilitation_N = mkN "facilitazione" ; -- UWN
lin facility_N = mkN "facilità" feminine ; -- status=guess
lin facing_N = mkN "rivestimento" ; -- UWN
lin facsimile_N = mkN "fax" ; -- UWN
lin fact_N = mkN "fatto" ;
lin faction_N = variants {} ; --
lin factor_N = mkN "fattore" masculine ; -- status=guess
lin factorial_N = mkN "fattoriale" ; -- status=guess
lin factorization_N = mkN "fattorizzazione" ; -- UWN
lin factory_N = L.factory_N ;
lin factotum_N = mkN "factotum" ; -- UWN
lin factual_A = mkA "effettivo" | mkA "effettiva" ; -- status=guess status=guess
lin faculty_N = mkN "collegio" | mkN "collegio_dei_professori" | mkN "corpo" | mkN "corpo_insegnante" ; -- UWN
lin fade_V = variants {} ; --
lin fade_V2 = variants {} ; --
lin fadeout_N = mkN "dissolvenza_in_chiusura" ; -- UWN
lin faerie_N = mkN "paese_delle_fate" ; -- UWN
lin faery_N = mkN "paese_delle_fate" ; -- UWN
lin fag_N = mkN "cicca" ; -- status=guess
lin fag_V = mkV "affaticare" | mkV "ammazzare" | mkV "annoiare" | mkV "estenuare" | mkV "logorare" | mkV "prostrare" | mkV "sdirenare" | mkV "sfiancare" | mkV "sfinire" | mkV "spossare" | mkV "stancare" | mkV "stancarsi" | mkV "straccare" | mkV "strapazzare" | mkV "stremare" ; -- UWN
lin faggot_N = mkN "fascio" ; -- status=guess
lin fagot_N = mkN "fascina" | mkN "fastello" | mkN "frascone" | mkN "stipa" ; -- UWN
lin faience_N = mkN "faenza" ; -- status=guess
lin fail_V = mkV "bocciare" | mkV "fallire" ; -- status=guess, src=wikt status=guess, src=wikt
lin fail_V2 = mkV2 (mkV "bocciare") | mkV2 (mkV "fallire") ; -- status=guess, src=wikt status=guess, src=wikt
lin fail_VV = mkVV (mkV "bocciare") | mkVV (mkV "fallire") ; -- status=guess, src=wikt status=guess, src=wikt
lin faille_N = mkN "faille" ; -- UWN
lin failure_N = mkN "fallimento" | mkN "insuccesso" | mkN "avaria" ; -- status=guess status=guess status=guess
lin faineance_N = mkN "fannullaggine" | mkN "oziosaggine" ; -- UWN
lin faint_A = mkA "incerto" | mkA "indistinto" ; -- status=guess status=guess
lin faint_N = mkN "svenimento" ; -- status=guess
lin faint_V = svenire_V ; -- status=guess, src=wikt
lin fair_A = mkA "discreto" | mkA "discreta" ; -- status=guess status=guess
lin fair_Adv = variants {} ; --
lin fair_N = mkN "fiera" ; -- status=guess
lin fairlead_N = mkN "passacavo" ; -- status=guess
lin fairly_Adv = adjAdv fair_A ; -- -- derived
lin fairy_N = mkN "fata" ; -- status=guess
lin fairyland_N = mkN "paese_delle_fate" ; -- UWN
lin fairytale_N = mkN "favola" | mkN "fiaba" ; -- UWN
lin faith_N = mkN "fede" feminine ; -- status=guess
lin faithful_A = mkA "fedele" ; -- status=guess
lin faithlessness_N = mkN "sfarfallamento" ; -- UWN
lin fake_N = mkN "duglia" ; -- status=guess
lin fake_V2 = mkV2 (mkV "dugliare") ; -- status=guess, src=wikt
lin fakir_N = mkN "fachiro" ; -- UWN
lin falchion_N = mkN "falcione" masculine ; -- status=guess
lin falcon_N = mkN "falco" | mkN "falcone" masculine ; -- status=guess status=guess
lin falconer_N = mkN "falconiere" masculine ; -- status=guess
lin falconry_N = mkN "falconeria" ; -- status=guess
lin falkirk_PN = mkPN "Falkirk" ; -- status=guess src=geonames
lin fall_1_N = variants {} ; --
lin fall_2_N = variants {} ; --
lin fall_N = mkN "caduta" ; -- status=guess
lin fall_V = mkV (cadere_V) "a pezzi" ; -- status=guess, src=wikt
lin fall_about_V = advV OP_fall_V OP_about_Adv ; -- guess-p-verb
lin fall_apart_V = advV OP_fall_V OP_apart_Adv ; -- guess-p-verb
lin fall_back_V = advV OP_fall_V OP_back_Adv ; -- guess-p-verb
lin fall_back_on_V2 = prepV2 (advV OP_fall_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin fall_behind_V = advV OP_fall_V OP_behind_Adv ; -- guess-p-verb
lin fall_behind_in_V2 = prepV2 (advV OP_fall_V OP_behind_Adv ) OP_in_Prep ; -- guess-p-verb
lin fall_down_V = mkV "cadere" | mkV "cascare" ; -- UWN
lin fall_for_V2 = prepV2 OP_fall_V OP_for_Prep ; -- guess-p-verb
lin fall_in_V = mkV "cadere" | mkV "cedere" | mkV "crollare" | mkV "franare" | mkV "rompersi" | mkV "sfondarsi" | mkV "sprofondare" ; -- UWN
lin fall_into_V2 = prepV2 OP_fall_V OP_into_Prep ; -- guess-p-verb
lin fall_off_V = advV OP_fall_V OP_off_Adv ; -- guess-p-verb
lin fall_out_V = advV OP_fall_V OP_out_Adv ; -- guess-p-verb
lin fall_out_with_V2 = prepV2 (advV OP_fall_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin fall_over_V = advV OP_fall_V OP_over_Adv ; -- guess-p-verb
lin fall_through_V = mkV "naufragare" ; -- UWN
lin fall_under_V2 = prepV2 OP_fall_V OP_under_Prep ; -- guess-p-verb
lin fallaciousness_N = mkN "fallacia" | mkN "inattendibilità" | mkN "infondatezza" ; -- UWN
lin fallacy_N = mkN "fallacia" ; -- status=guess
lin fallibility_N = mkN "fallibilità" ; -- UWN
lin fallow_N = mkN "maggese" masculine ; -- status=guess
lin falls_N = mkN "cascata" | mkN "cataratta" | mkN "cateratta" ; -- UWN
lin falmouth_PN = mkPN "Falmouth" ; -- status=guess src=geonames
lin false_A = mkA "posticcio" | mkA "finto" ; -- status=guess status=guess
lin false_Adv = mkAdv "infidamente" | mkAdv "proditoriamente" ; -- UWN
lin falsehood_N = mkN "menzogna" ; -- status=guess
lin falseness_N = mkN "falsità" | mkN "fintaggine" | mkN "finteria" | mkN "insincerità" ; -- UWN
lin falsetto_N = mkN "falsetto" ; -- status=guess
lin falsifier_N = mkN "falsificatore" ; -- UWN
lin falter_V = mkV "inciampare" ; -- status=guess, src=wikt
lin falter_V2 = mkV2 (mkV "inciampare") ; -- status=guess, src=wikt
lin fame_N = mkN "fama" ; -- status=guess
lin familiar_A = mkA "familiare" ; -- status=guess
lin familiar_N = mkN "famiglio" ; -- status=guess
lin familiarity_N = mkN "confidenza" ; -- UWN
lin family_N = mkN "famiglia" ; -- status=guess
lin famine_N = mkN "carestia" ; -- status=guess
lin famous_A = mkA "famoso" | mkA "famosa" ; -- status=guess status=guess
lin fan_1_N = mkN "aficionado" | mkN "amante" | mkN "ammiratore" | mkN "fan" | mkN "habitué" | mkN "patito" ; -- UWN
lin fan_2_N = mkN "aficionado" | mkN "amante" | mkN "ammiratore" | mkN "fan" | mkN "habitué" | mkN "patito" ; -- UWN
lin fan_3_N = mkN "aficionado" | mkN "amante" | mkN "ammiratore" | mkN "fan" | mkN "habitué" | mkN "patito" ; -- UWN
lin fan_N = variants {} ; --
lin fan_V = variants {} ; --
lin fan_V2 = variants {} ; --
lin fanaticFem_N = mkN "esaltato" | mkN "fanatico" | mkN "fissato" | mkN "maniaco" ; -- UWN
lin fanaticMasc_N = mkN "esaltato" | mkN "fanatico" | mkN "fissato" | mkN "maniaco" ; -- UWN
lin fanatic_A = mkA "fanatico" | mkA "maniaco" | mkA "patito" | mkA "seguace" ; -- status=guess status=guess status=guess status=guess
lin fanatical_A = mkA "fanatico" ; -- status=guess
lin fancier_N = mkN "amatore" | mkN "appassionato" | mkN "entusiasta" | mkN "fanatico" | mkN "patito" ; -- UWN
lin fancy_N = mkN "estro" | mkN "fancy" ; -- UWN
lin fancy_V2 = variants {} ; --
lin fanfare_N = mkN "fanfara" ; -- UWN
lin fang_N = mkN "dente" masculine | mkN "dente canino" | mkN "dente di cane" | mkN "zanna" ; -- status=guess status=guess status=guess status=guess
lin fanjet_N = mkN "turboelica" ; -- UWN
lin fanlight_N = mkN "rosta" ; -- UWN
lin fantasia_N = mkN "fantasia" ; -- UWN
lin fantastic_A = mkA "fantastico" | mkA "fantastica" ; -- status=guess status=guess
lin fantastically_Adv = mkAdv "fantasticamente" ; -- status=guess
lin fantasy_N = mkN "fantasia" ; -- status=guess
lin far_A = mkA "lontano" ; -- status=guess
lin farandole_N = mkN "farandola" ; -- UWN
lin farce_N = mkN "farsa" ; -- UWN
lin fare_N = mkN "vitto" | mkN "cibo" ; -- status=guess status=guess
lin fare_V = mkV "mangiare" | mkV "cenare" ; -- status=guess, src=wikt status=guess, src=wikt
lin farewell_N = mkN "addio" ; -- status=guess
lin farm_N = mkN "fattoria" | mkN "podere" masculine ; -- status=guess status=guess
lin farmer_N = mkN "agricoltore" masculine | mkN "fattore" masculine ; -- status=guess status=guess
lin farmhouse_N = mkN "casale" | mkN "casa colonica" | mkN "casolare" masculine ; -- status=guess status=guess status=guess
lin farming_N = variants {} ; --
lin farmstead_N = mkN "cascina" ; -- status=guess
lin farmyard_N = mkN "aia" | mkN "cortile" ; -- UWN
lin farnham_PN = mkPN "Farnham" ; -- status=guess src=geonames
lin farnworth_PN = mkPN "Farnworth" ; -- status=guess src=geonames
lin faro_N = mkN "faraone" ; -- UWN
lin farrier_N = mkN "maniscalco" ; -- status=guess
lin farrow_V = mkV "figliare" ; -- status=guess, src=wikt
lin fart_N = mkN "scoreggia" | mkN "peto" ; -- status=guess status=guess
lin fart_V = mkV "scoreggiare" | mkV (I.fare_V) "un peto" ; -- status=guess, src=wikt status=guess, src=wikt
lin farthing_N = mkN "quattrino" ; -- UWN
lin farthingale_N = mkN "guardinfante" | mkN "verdugale" ; -- UWN
lin fasces_N = mkN "fascio fascio littorio" ; -- status=guess
lin fascia_N = mkN "cruscotto" ; -- UWN
lin fascinate_V2 = variants {} ; --
lin fascinating_A = variants {} ; --
lin fascism_N = mkN "fascismo" ; -- status=guess
lin fascist_A = mkA "fascista" ; -- status=guess
lin fascist_N = mkN "fascista" ; -- status=guess
lin fashion_N = mkN "moda" | mkN "voga" ; -- status=guess status=guess
lin fashionable_A = variants {} ; --
lin fast_A = mkA "avanti" ; -- status=guess
lin fast_N = mkN "fast food" | mkN "cibo servito rapidamente" ; -- status=guess status=guess
lin fast_V = mkV "digiunare" ; -- status=guess, src=wikt
lin fastball_N = mkN "fastball" | mkN "palla_veloce" ; -- UWN
lin fastidious_A = mkA "pignolo" | mkA "meticoloso" ; -- status=guess status=guess
lin fastidiousness_N = mkN "meticolosità" | mkN "minuziosità" ; -- UWN
lin fat_A = mkA "grasso" | mkA "obeso" ; -- status=guess status=guess
lin fat_N = L.fat_N ;
lin fat_V2 = mkV2 (mkV "ingrassare") ; -- status=guess, src=wikt
lin fatal_A = mkA "fatale" ; -- status=guess
lin fatalistFem_N = mkN "determinista" | mkN "fatalista" ; -- UWN
lin fatalistMasc_N = mkN "determinista" | mkN "fatalista" ; -- UWN
lin fatalistic_A = mkA "fatalistico" ; -- status=guess
lin fate_N = mkN "destino" | mkN "sorte" feminine | mkN "fato" ; -- status=guess status=guess status=guess
lin father_N = mkN "padre" | mkN "babbo" | mkN "papà" masculine ; -- status=guess status=guess status=guess
lin father_N2 = L.father_N2 ; -- comment=CHECKED
lin fatherhood_N = mkN "paternità" feminine ; -- status=guess
lin fatherland_N = mkN "patria" | mkN "paese" masculine | mkN "suolo natio" ; -- status=guess status=guess status=guess
lin fathom_N = mkN "braccio" ; -- status=guess
lin fathom_V2 = mkV2 (mkV "capire") | mkV2 (comprendere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin fatigue_N = mkN "usura" | mkN "fatica" | mkN "logorio" ; -- status=guess status=guess status=guess
lin fatso_N = mkN "ciccione" masculine ; -- status=guess
lin fatten_V = mkV "ingrassare" ; -- status=guess, src=wikt
lin fatten_V2 = mkV2 (mkV "ingrassare") ; -- status=guess, src=wikt
lin fatty_A = mkA "grasso" | mkA "lardoso" ; -- UWN
lin fatuous_A = mkA "fatuo" ; -- status=guess
lin fauces_N = mkN "fauci" ; -- UWN
lin faucet_N = mkN "cannella" | mkN "robinetto" | mkN "rubinetto" ; -- UWN
lin fauldhouse_PN = mkPN "Fauldhouse" ; -- status=guess src=geonames
lin fault_N = mkN "sbaglio" ; -- status=guess
lin faulty_A = mkA "difettoso" | mkA "imperfetto" | mkA "scorretto" ; -- status=guess status=guess status=guess
lin faun_N = mkN "fauno" ; -- UWN
lin fauna_N = mkN "fauna" ; -- status=guess
lin fauvism_N = mkN "fauvismo" ; -- status=guess
lin faux_pas_N = mkN "gaffe" | mkN "scorso" | mkN "topica" ; -- UWN
lin faversham_PN = mkPN "Faversham" ; -- status=guess src=geonames
lin favoritism_N = mkN "discriminazione" ; -- UWN
lin favour_N = variants {} ; --
lin favour_V = variants {} ; --
lin favour_V2 = variants {} ; --
lin favour_VS = variants {} ; --
lin favourable_A = mkA "favorevole" ; -- status=guess
lin favouriteFem_N = variants {} ; ---- sense to be split
lin favouriteMasc_N = variants {} ; --
lin favourite_A = variants {} ; --
lin favouritism_N = mkN "discriminazione" ; -- UWN
lin fawn_N = mkN "fulvo chiaro" | mkN "marrone chiaro" ; -- status=guess status=guess
lin fawn_V = mkV (mkV "dimostrare") "affetto" | mkV (I.fare_V) "le feste" ; -- status=guess, src=wikt status=guess, src=wikt
lin fax_N = variants {} ; --
lin fear_N = mkN "paura" ; -- status=guess
lin fear_V2 = L.fear_V2 ;
lin fear_VS = L.fear_VS ;
lin fearful_A = mkA "impaurito" | mkA "spaventato" | mkA "pavido" ; -- status=guess status=guess status=guess
lin feasibility_N = mkN "fattibilità" feminine | mkN "attuabilità" | mkN "eseguibilità" | mkN "futuribilità" | mkN "riuscibilità" | mkN "effettuabilità" feminine ; -- status=guess status=guess status=guess status=guess status=guess status=guess
lin feasible_A = mkA "fattibile" | mkA "realizzabile" ; -- status=guess status=guess
lin feast_N = mkN "festa" | mkN "banchetto" ; -- status=guess status=guess
lin feast_V = mkV "bagordare" | mkV "banchettare" | mkV "bisbocciare" | mkV "convitare" | mkV "convivare" | mkV "crapulare" | mkV "gozzovigliare" ; -- UWN
lin feat_N = mkN "impresa" | mkN "prodezza" ; -- status=guess status=guess
lin feather_N = L.feather_N ;
lin featherstone_PN = mkPN "Featherstone" ; -- status=guess src=geonames
lin feature_N = mkN "caratteristica" masculine ; -- status=guess
lin feature_V2 = variants {} ; --
lin febrile_A = mkA "convulso" | mkA "febbricitante" | mkA "febbricoso" | mkA "febbrile" ; -- UWN
lin fedelline_N = mkN "barbine_a_nido" | mkN "bassetti" | mkN "capelli_d'angelo" | mkN "capellini_d'angelo" | mkN "capellini_fini" | mkN "capelvenere" | mkN "cappellini" | mkN "fedelini" | mkN "fidelini" | mkN "sopracappellini" | mkN "tagliolini_a_nido" ; -- UWN
lin federal_A = variants {} ; --
lin federalism_N = mkN "federalismo" ; -- UWN
lin federalist_N = mkN "federalista" ; -- UWN
lin federation_N = mkN "federazione" feminine ; -- status=guess
lin fee_N = mkN "tassa" | mkN "tariffa" | mkN "quota" | mkN "onorario" | mkN "emolumento" ; -- status=guess status=guess status=guess status=guess status=guess
lin feeble_A = mkA "debole" ; -- status=guess
lin feeblemindedness_N = mkN "ebetismo" ; -- UWN
lin feed_N = variants {} ; --
lin feed_V = mkV "nutrirsi" | mkV "cibarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin feed_V2 = mkV2 (mkV "nutrirsi") | mkV2 (mkV "cibarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin feed_off_V2 = prepV2 OP_feed_V OP_off_Prep ; -- guess-p-verb
lin feed_on_V2 = prepV2 OP_feed_V OP_on_Prep ; -- guess-p-verb
lin feed_up_V2 = prepV2 OP_feed_V OP_up_Prep ; -- guess-p-verb
lin feedback_N = mkN "feedback" ; -- UWN
lin feeding_N = mkN "biberon" masculine ; -- status=guess
lin feel_N = variants {} ; --
lin feel_V = mkV (avere_V) "voglia di" ; -- status=guess, src=wikt
lin feel_V2 = mkV2 (mkV (avere_V) "voglia di") ; -- status=guess, src=wikt
lin feel_VA = mkVA (mkV (avere_V) "voglia di") ; -- status=guess, src=wikt
lin feel_VS = mkVS (mkV (avere_V) "voglia di") ; -- status=guess, src=wikt
lin feel_out_V = mkV "indagare" | mkV "scandagliare" ; -- UWN
lin feel_up_V2 = prepV2 OP_feel_V OP_up_Prep ; -- guess-p-verb
lin feel_up_to_V2 = prepV2 (advV OP_feel_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin feeler_N = mkN "spessimetro" ; -- status=guess
lin feeling_N = mkN "sentimento" | mkN "emozione" feminine ; -- status=guess status=guess
lin feign_V2 = mkV2 (mkV "fingere") ; -- status=guess, src=wikt
lin feijoa_N = mkN "feijoa" ; -- status=guess
lin feint_N = mkN "finta" ; -- status=guess
lin feisty_A = mkA "combattivo" ; -- status=guess
lin feldspar_N = mkN "feldspato" ; -- status=guess
lin felicitation_N = mkN "congratulazione" ; -- UWN
lin felicity_N = mkN "felicità" feminine ; -- status=guess
lin feline_A = mkA "felino" ; -- status=guess
lin feline_N = mkN "felino" ; -- UWN
lin felixstowe_PN = mkPN "Felixstowe" ; -- status=guess src=geonames
lin fellatio_N = mkN "fellatio" feminine ; -- status=guess
lin fellow_A = variants {} ; --
lin fellow_N = mkN "amoroso" | mkN "damo" | mkN "fidanzato" | mkN "innamorato" | mkN "ragazzo" ; -- UWN
lin fellowship_N = mkN "famiglia" ; -- UWN
lin felt_N = mkN "feltro" ; -- status=guess
lin felucca_N = mkN "feluca" ; -- UWN
lin female_A = mkA "femminile" ; -- status=guess
lin female_N = mkN "femmina" ; -- status=guess
lin feminine_A = mkA "femminile" ; -- status=guess
lin feminine_N = mkN "donna" ; -- status=guess
lin femininity_N = mkN "femminilità" feminine ; -- status=guess
lin feminism_N = mkN "femminismo" ; -- status=guess
lin feministFem_N = mkN "femminista" ; -- UWN
lin feministMasc_N = variants {} ; --
lin feminist_A = mkA "femminista" | mkA "femministico" ; -- UWN
lin femur_N = mkN "femore" masculine ; -- status=guess
lin fen_N = mkN "acquitrino" | mkN "maremma" | mkN "palude" | mkN "pantano" ; -- UWN
lin fence_N = mkN "recinto" | mkN "steccato" | mkN "palizzata" | mkN "cinta" | mkN "siepe" feminine | mkN "barriera" | mkN "riparo" ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin fencer_N = mkN "lama" | mkN "schermidore" | mkN "schermitore" | mkN "spadaccino" ; -- UWN
lin fencing_N = mkN "scherma" ; -- status=guess
lin fender_N = mkN "guardalato" | mkN "paglietto" | mkN "parabordo" ; -- UWN
lin fennel_N = mkN "finocchio" ; -- status=guess
lin fenugreek_N = mkN "trigonella" ; -- status=guess
lin feoff_N = mkN "feudo" ; -- UWN
lin fermata_N = mkN "fermata" ; -- status=guess
lin ferment_N = mkN "fermentazione_alcolica" | mkN "ribollimento" ; -- UWN
lin ferment_V = mkV "fermentare" ; -- status=guess, src=wikt
lin ferment_V2 = mkV2 (mkV "fermentare") ; -- status=guess, src=wikt
lin fermentation_N = mkN "fermentazione" feminine ; -- status=guess
lin fermion_N = mkN "fermione" masculine ; -- status=guess
lin fermium_N = mkN "fermio" ; -- status=guess
lin fern_N = mkN "felce" feminine ; -- status=guess
lin ferociousness_N = mkN "bestialità" | mkN "brutalità" | mkN "efferatezza" | mkN "ferocia" ; -- UWN
lin ferocity_N = mkN "ferocia" | mkN "ferocità" | mkN "furia" | mkN "impeto" | mkN "irruenza" ; -- UWN
lin ferrara_PN = mkPN "Ferrara" ; -- status=guess src=geonames
lin ferret_N = mkN "furetto" ; -- status=guess
lin ferric_A = mkA "ferrigno" | mkA "ferroso" ; -- UWN
lin ferris_wheel_N = mkN "ruota panoramica" "ruote panoramiche" feminine ;
lin ferrite_N = mkN "ferrite" ; -- UWN
lin ferritin_N = mkN "ferritina" ; -- UWN
lin ferroconcrete_N = mkN "cemento_armato" ; -- UWN
lin ferromagnetic_A = mkA "ferromagnetico" ; -- status=guess
lin ferromagnetism_N = mkN "ferromagnetismo" ; -- status=guess
lin ferrous_A = mkA "ferrigno" | mkA "ferroso" ; -- UWN
lin ferrule_N = mkN "ghiera" ; -- status=guess
lin ferry_N = mkN "traghetto" ; -- status=guess
lin ferryhill_PN = mkPN "Ferryhill" ; -- status=guess src=geonames
lin ferryman_N = mkN "barcaiolo" | mkN "traghettatore" ; -- UWN
lin fertile_A = mkA "fertile" ;
lin fertility_N = mkN "fertilità" ;
lin fertilization_N = mkN "fecondazione" feminine ; -- status=guess
lin fertilize_V2 = mkV2 (mkV "fertilizzare") ; -- status=guess, src=wikt
lin fertilizer_N = mkN "fertilizzante" ; -- status=guess
lin ferule_N = mkN "ferula" ; -- UWN
lin fervour_N = mkN "animazione" | mkN "concitazione" | mkN "eccitazione" | mkN "esaltazione" ; -- UWN
lin fesse_N = mkN "fascia" ; -- UWN
lin fester_V = mkV "infettarsi" ; -- status=guess, src=wikt
lin festival_N = mkN "mostra" | mkN "rassegna" | mkN "festival" ; -- status=guess status=guess status=guess
lin festivity_N = mkN "festività" | mkN "gala" ; -- UWN
lin festoon_N = mkN "festone" ; -- status=guess
lin festoon_V2 = mkV2 (mkV "inghirlandare") ; -- status=guess, src=wikt
lin fetal_A = mkA "fetale" ; -- UWN
lin fetch_V2 = mkV2 (valere_V) ; -- status=guess, src=wikt
lin fetish_N = mkN "feticcio" ; -- status=guess
lin fetishism_N = mkN "feticismo" ; -- status=guess
lin fetter_N = mkN "ostacoli" masculine ; -- status=guess
lin fetter_V2 = mkV2 (mkV "ostacolare") ; -- status=guess, src=wikt
lin fettuccine_N = mkN "fettuccine" ; -- UWN
lin fetus_N = mkN "feto" ; -- status=guess
lin feud_N = mkN "feudo" ; -- status=guess
lin feudalism_N = mkN "feudalesimo" | mkN "feudalismo" ; -- UWN
lin feudatory_N = mkN "feudatario" | mkN "vassallo" ; -- UWN
lin fever_N = mkN "febbre" feminine ; -- status=guess
lin feverish_A = mkA "convulso" | mkA "febbricitante" | mkA "febbricoso" | mkA "febbrile" ; -- UWN
lin few_Det = S.few_Det ;
lin few_N = variants {} ; --
lin fewer_A = mkA "meno" ; -- UWN
lin fewer_Det = variants {} ; --
lin fey_A = mkA "magico" ; -- status=guess
lin fez_N = mkN "fez" ; -- UWN
lin fiasco_N = mkN "fiasco" ; -- status=guess
lin fib_N = mkN "menzogna" | mkN "bugia" | mkN "baggianata" | mkN "bufala" | mkN "fola" | mkN "frottola" | mkN "fandonia" ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin fib_V = mkV "mentire" ; -- status=guess, src=wikt
lin fibber_N = mkN "bugiardello" | mkN "bugiardo" ; -- UWN
lin fiberboard_N = mkN "pannello_di_fibre" ; -- UWN
lin fiberglass_N = mkN "vetroresina" ; -- UWN
lin fibre_N = mkN "fibra" ; -- status=guess
lin fibreboard_N = mkN "pannello_di_fibre" ; -- UWN
lin fibreglass_N = mkN "vetroresina" ; -- UWN
lin fibrillation_N = mkN "fibrillazione" feminine ; -- status=guess
lin fibrin_N = mkN "fibrina" ; -- UWN
lin fibrinogen_N = mkN "fibrinogeno" ; -- UWN
lin fibrinous_A = mkA "fibrinoso" ; -- UWN
lin fibroma_N = mkN "fibroma" ; -- status=guess
lin fibrosis_N = mkN "fibrosi" ; -- UWN
lin fibrous_A = mkA "fibroso" ; -- status=guess
lin fibula_N = mkN "perone" ; -- status=guess
lin fichu_N = mkN "fisciù" ; -- UWN
lin fickle_A = mkA "volubile" ; -- status=guess
lin fickleness_N = mkN "sfarfallamento" ; -- UWN
lin fiction_N = mkN "narrativa" ; -- UWN
lin fictional_A = mkA "romanzesco" ; -- UWN
lin fiddle_N = mkN "trucco" | mkN "stratagemma" masculine | mkN "marchingegno" ; -- status=guess status=guess status=guess
lin fidelity_N = mkN "fedeltà" feminine ; -- status=guess
lin fidget_N = mkN "smania" ; -- UWN
lin fiduciary_A = mkA "fiduciario" ; -- UWN
lin fiduciary_N = mkN "mandatario" ; -- status=guess
lin fief_N = mkN "feudo" ; -- UWN
lin field_1_N = mkN "campagna" | mkN "campo" ; -- UWN
lin field_2_N = variants {} ; --
lin field_3_N = variants {} ; --
lin field_4_N = variants {} ; --
lin field_N = mkN "campo" ; -- status=guess
lin fieldfare_N = mkN "cesena" ; -- status=guess
lin fiend_N = mkN "demonio" ; -- status=guess
lin fiendish_A = mkA "diabolico" | mkA "demoniaco" ; -- status=guess status=guess
lin fierce_A = mkA "feroce" ; -- status=guess
lin fierceness_N = mkN "ferocia" | mkN "ferocità" | mkN "furia" | mkN "impeto" | mkN "irruenza" ; -- UWN
lin fiery_A = mkA "incandescente" | mkA "bruciante" ; -- status=guess status=guess
lin fife_N = mkN "piffero" ; -- status=guess
lin fife_PN = mkPN "Fife" ; -- status=guess src=geonames
lin fig_N = mkN "fico" ; -- status=guess
lin fight_N = mkN "battaglia" masculine | mkN "combattimento" ; -- status=guess status=guess
lin fight_V = mkV "lottare" | mkV "azzuffarsi" | mkV "battersi" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin fight_V2 = L.fight_V2 ;
lin fight_back_V = advV OP_fight_V OP_back_Adv ; -- guess-p-verb
lin fight_back_V2 = mkV2 (advV OP_fight_V OP_back_Adv ) ; -- guess-p-verb
lin fight_it_out_V2 = variants {} ; -- guess-p-verb
lin fight_off_V2 = prepV2 OP_fight_V OP_off_Prep ; -- guess-p-verb
lin fighter_N = mkN "caccia" masculine ; -- status=guess
lin figment_N = mkN "fantasma" | mkN "finzione" ; -- UWN
lin figurative_A = mkA "figurativo" ; -- status=guess
lin figure_1_N = variants {} ; --
lin figure_2_N = variants {} ; --
lin figure_N = mkN "figura" ; -- status=guess
lin figure_V = mkV "scoprire" | mkV (mkV "rendersi") "conto" ; -- status=guess, src=wikt status=guess, src=wikt
lin figure_VS = mkVS (mkV "scoprire") | mkVS (mkV (mkV "rendersi") "conto") ; -- status=guess, src=wikt status=guess, src=wikt
lin figure_on_V2 = prepV2 OP_figure_V OP_on_Prep ; -- guess-p-verb
lin figure_out_V2 = prepV2 OP_figure_V OP_out_Prep ; -- guess-p-verb
lin figure_up_V2 = prepV2 OP_figure_V OP_up_Prep ; -- guess-p-verb
lin figurehead_N = mkN "polena" ; -- status=guess
lin figurine_N = mkN "statuetta" ; -- status=guess
lin figwort_N = mkN "scrofularia" ; -- UWN
lin fiji_PN = mkPN "Figi" ; -- status=guess src=geonames
lin filament_N = mkN "filamento" ; -- status=guess
lin filaria_N = mkN "filaria" ; -- status=guess
lin filature_N = mkN "filanda" ; -- UWN
lin filbert_N = mkN "nocciola" ; -- UWN
lin file_N = mkN "archivio" ; -- status=guess
lin file_V = mkV "archiviare" ; -- status=guess, src=wikt
lin file_V2 = mkV2 (mkV "archiviare") ; -- status=guess, src=wikt
lin file_away_V2 = mkV2 (advV OP_file_V OP_away_Adv ) ; -- guess-p-verb
lin file_for_V2 = prepV2 OP_file_V OP_for_Prep ; -- guess-p-verb
lin filer_N = mkN "archivista" ; -- UWN
lin filigree_N = mkN "filigrana" ; -- status=guess
lin filing_N = mkN "limatura" | mkN "polvere" masculine ; -- status=guess status=guess
lin fill_V = mkV "imbottire" ; -- status=guess, src=wikt
lin fill_V2 = mkV2 (mkV "imbottire") ; -- status=guess, src=wikt
lin fill_in_V = advV OP_fill_V OP_in_Adv ; -- guess-p-verb
lin fill_in_V2 = prepV2 OP_fill_V OP_in_Prep ; -- guess-p-verb
lin fill_in_for_V2 = prepV2 (advV OP_fill_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin fill_in_on_V3 = variants {} ; -- guess-p-verb
lin fill_out_V = advV OP_fill_V OP_out_Adv ; -- guess-p-verb
lin fill_out_V2 = prepV2 OP_fill_V OP_out_Prep ; -- guess-p-verb
lin fill_up_V2 = prepV2 OP_fill_V OP_up_Prep ; -- guess-p-verb
lin fillet_V2 = mkV2 (mkV "disossare") ; -- status=guess, src=wikt
lin fillip_N = mkN "schiocco" | mkN "schioccare le dita" ; -- status=guess status=guess
lin filly_N = mkN "puledra" ; -- status=guess
lin film_1_N = variants {} ; --
lin film_2_N = variants {} ; --
lin film_N = mkN "film" | mkN "pellicola" ; -- status=guess status=guess
lin film_V = mkV (mkV "girare") "un film" | mkV "filmare" ; -- status=guess, src=wikt status=guess, src=wikt
lin film_V2 = mkV2 (mkV (mkV "girare") "un film") | mkV2 (mkV "filmare") ; -- status=guess, src=wikt status=guess, src=wikt
lin filming_N = mkN "riprese" feminine | mkN "videoripresa" ; -- status=guess status=guess
lin filter_N = mkN "filtro" ; -- status=guess
lin filter_V = mkV "filtrare" ; -- status=guess, src=wikt
lin filter_V2 = mkV2 (mkV "filtrare") ; -- status=guess, src=wikt
lin filth_N = mkN "sporco" | mkN "sporca" | mkN "sporchi" masculine | mkN "sporche" feminine ; -- status=guess status=guess status=guess status=guess
lin filthy_A = mkA "sudicio" | mkA "lercio" ; -- status=guess status=guess
lin filtrate_N = mkN "filtrato" ; -- status=guess
lin filtrate_V = mkV "colare" | mkV "filtrare" ; -- UWN
lin fin_N = mkN "impennaggio" ; -- status=guess
lin finagle_V2 = mkV2 (sottrarre_V) ; -- status=guess, src=wikt
lin final_A = mkA "ultimo" ; -- status=guess
lin final_N = mkN "finale" ; -- status=guess
lin finale_N = mkN "finale" ; -- status=guess
lin finalist_N = mkN "finalista" ; -- status=guess
lin finality_N = mkN "inappellabilità" | mkN "irrevocabilità" ; -- UWN
lin finalize_V2 = mkV2 (mkV "finire") ; -- status=guess, src=wikt
lin finally_Adv = adjAdv final_A | {-UWN-} mkAdv "in_fine" | mkAdv "infine" ; -- UWN -- -- derived
lin finance_N = variants {} ; --
lin finance_V2 = mkV2 (mkV "finanziare") ; -- status=guess, src=wikt
lin financial_A = mkA "finanziario" | mkA "fiscale" ; -- UWN
lin financier_N = mkN "finanziere" ; -- UWN
lin finch_N = mkN "fringuello" | mkN "canarino" | mkN "cardellino" ; -- status=guess status=guess status=guess
lin find_N = mkN "scoperta" | mkN "chicca" ; -- status=guess status=guess
lin find_V = mkV "trovare" ;
lin find_V2 = L.find_V2 ;
lin find_V2A = mkV2A (mkV "trovare") ;
lin find_VS = mkVS (mkV "trovare") ;
lin find_out_V = advV OP_find_V OP_out_Adv ; -- guess-p-verb
lin find_out_V2 = prepV2 OP_find_V OP_out_Prep ; -- guess-p-verb
lin finder_N = mkN "mirino" ; -- UWN
lin finding_N = mkN "riscontro" | mkN "risultato" ; -- status=guess status=guess
lin fine_A = mkA "bene" ; -- status=guess
lin fine_N = mkN "multa" ; -- status=guess
lin fine_V2 = mkV2 (mkV "multare") ; -- status=guess, src=wikt
lin finger_N = mkN "dito" feminine | mkN "dita" ; -- status=guess status=guess
lin fingerboard_N = mkN "tastiera" ; -- status=guess
lin fingering_N = mkN "manualità" | mkN "gestualità" feminine ; -- status=guess status=guess
lin fingermark_N = mkN "ditata" ; -- UWN
lin fingernail_N = L.fingernail_N ; -- comment=CHECKED
lin fingerprint_N = mkN "impronta digitale" ; -- status=guess
lin fingerstall_N = mkN "ditale" ; -- UWN
lin fingertip_N = mkN "punta del dito" ; -- status=guess
lin finish_N = mkN "fine" feminine ; -- status=guess
lin finish_V = mkV "rifinire" ; -- status=guess, src=wikt
lin finish_V2 = mkV2 (mkV "rifinire") ; -- status=guess, src=wikt
lin finish_off_V2 = prepV2 OP_finish_V OP_off_Prep ; -- guess-p-verb
lin finish_up_V = mkV "finire" | mkV "finire" ; -- UWN
lin finish_up_with_V2 = prepV2 (advV OP_finish_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin finish_with_V2 = prepV2 OP_finish_V OP_with_Prep ; -- guess-p-verb
lin finished_A = variants {} ; --
lin finite_A = mkA "finito" ; -- status=guess
lin finiteness_N = mkN "finitezza" ; -- UWN
lin finland_PN = mkPN "Finlandia" ;
lin finnishFem_N = mkN "finlandese" feminine ;
lin finnishMasc_N = mkN "finlandese" ;
lin finnish_A = mkA "finlandese" ;
lin fiord_N = mkN "fiordo" ; -- UWN
lin fir_N = mkN "abete" masculine ; -- status=guess
lin fire_1_N = variants {} ; --
lin fire_2_N = mkN "fuoco" | mkN "incendio" | mkN "rogo" ; -- UWN
lin fire_N = L.fire_N ;
lin fire_V = mkV "sparare" | mkV (I.fare_V) "fuoco" ; -- status=guess, src=wikt status=guess, src=wikt
lin fire_V2 = mkV2 (mkV "sparare") | mkV2 (mkV (I.fare_V) "fuoco") ; -- status=guess, src=wikt status=guess, src=wikt
lin fire_away_V = advV OP_fire_V OP_away_Adv ; -- guess-p-verb
lin fire_back_V = advV OP_fire_V OP_back_Adv ; -- guess-p-verb
lin fire_off_V2 = prepV2 OP_fire_V OP_off_Prep ; -- guess-p-verb
lin fire_up_V = advV OP_fire_V OP_up_Adv ; -- guess-p-verb
lin fire_up_V2 = prepV2 OP_fire_V OP_up_Prep ; -- guess-p-verb
lin firearm_N = mkN "arma da fuoco" ; -- status=guess
lin fireball_N = mkN "palla di fuoco" ; -- status=guess
lin firebomb_N = mkN "ordigno_incendiario" ; -- UWN
lin firebox_N = mkN "focolare" | mkN "fornello" ; -- UWN
lin firebrand_N = mkN "aizzatore" | mkN "fomentatore" | mkN "istigatore" | mkN "sobillatore" ; -- UWN
lin firebrick_N = mkN "mattone_refrattario" ; -- UWN
lin firecracker_N = mkN "petardo" ; -- status=guess
lin firedamp_N = mkN "grisou" masculine ; -- status=guess
lin firedog_N = mkN "alare" feminine ; -- status=guess
lin firefly_N = mkN "lucciola" ; -- status=guess
lin fireguard_N = mkN "caminiera" ; -- UWN
lin fireman_N = mkN "pompiere" ; -- status=guess
lin fireplace_N = mkN "camino" ; -- status=guess
lin fireside_N = mkN "focolare" ; -- UWN
lin firewood_N = mkN "legna" ;
lin firework_N = mkN "fuoco d'artificio" | mkN "fuoco artificiale" ; -- status=guess status=guess
lin firm_A = mkA "ferreo" ; -- status=guess
lin firm_N = variants {} ; --
lin firmament_N = mkN "firmamento" | mkN "volta_celeste" | mkN "volta_del_cielo" | mkN "volta_stellata" ; -- UWN
lin firmness_N = mkN "saldezza" ; -- UWN
lin first_Adv = variants {} ;
lin firstborn_A = mkA "primogenito" ; -- status=guess
lin firstborn_N = mkN "primogenito" ; -- status=guess
lin firstly_Adv = variants {} ; --
lin fiscal_A = mkA "fiscale" ; -- status=guess
lin fish_N = L.fish_N ;
lin fish_V = mkV "pescare" ; -- status=guess, src=wikt
lin fish_V2 = mkV2 (mkV "pescare") ; -- status=guess, src=wikt
lin fishbone_N = mkN "lisca" | mkN "resta" | mkN "spina" ; -- UWN
lin fisher_N = mkN "pescatore" masculine ; -- status=guess
lin fisherman_N = mkN "pescatore" masculine ; -- status=guess
lin fishery_N = mkN "peschiera" ; -- UWN
lin fish_hook_N = mkN "amo" ; -- status=guess
lin fishing_N = mkN "pesca" ; -- status=guess
lin fishmonger_N = mkN "magnaccia" | mkN "pappone" | mkN "ruffiano" | mkN "lenone" | mkN "protettore" ; -- status=guess status=guess status=guess status=guess status=guess
lin fishnet_N = mkN "rete_da_pesca" ; -- UWN
lin fishwife_N = mkN "pescaiolo" | mkN "pesciaiolo" | mkN "pescivendolo" ; -- UWN
lin fission_N = mkN "fissione" feminine ; -- status=guess
lin fissionable_A = mkA "fissile" ; -- UWN
lin fissure_N = mkN "scissura" ; -- UWN
lin fist_N = mkN "pugno" ; -- status=guess
lin fistula_N = mkN "fistola" ; -- UWN
lin fit_A = mkA "in forma" ; -- status=guess
lin fit_N = variants {} ; --
lin fit_V = mkV "arredare" ; -- status=guess, src=wikt
lin fit_V2 = mkV2 (mkV "arredare") ; -- status=guess, src=wikt
lin fit_in_V = mkV "accordare" | mkV "armonizzare" | mkV "entrare" ; -- UWN
lin fit_in_V2 = prepV2 OP_fit_V OP_in_Prep ; -- guess-p-verb
lin fit_in_with_V2 = prepV2 (advV OP_fit_V OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin fit_into_V2 = prepV2 OP_fit_V OP_into_Prep ; -- guess-p-verb
lin fit_out_V2 = prepV2 OP_fit_V OP_out_Prep ; -- guess-p-verb
lin fit_out_with_V2 = prepV2 (advV OP_fit_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin fit_up_V2 = prepV2 OP_fit_V OP_up_Prep ; -- guess-p-verb
lin fitfulness_N = mkN "irregolarità" ; -- UWN
lin fitness_N = variants {} ; --
lin fitting_N = variants {} ; --
lin fives_N = mkN "palla_muro" | mkN "pallamuro" ; -- UWN
lin fix_N = mkN "situazione" feminine | mkN "dilemma" masculine | mkN "guaio" feminine ; -- status=guess status=guess status=guess
lin fix_V = mkV "aggiustare" ; -- status=guess, src=wikt
lin fix_V2 = mkV2 (mkV "aggiustare") ; -- status=guess, src=wikt
lin fix_up_V2 = prepV2 OP_fix_V OP_up_Prep ; -- guess-p-verb
lin fixation_N = mkN "fissaggio" | mkN "fissazione" ; -- UWN
lin fixed_A = variants {} ; --
lin fixer_N = mkN "metadone" ; -- UWN
lin fixture_N = mkN "aggiustamento" | mkN "aggiustatura" | mkN "ammenda" | mkN "rassettatura" | mkN "riattamento" | mkN "riparazione" | mkN "riparazione" | mkN "ripristino" ; -- UWN
lin fizz_V = mkV "mussare" | mkV "schiumare" | mkV "schiumare" | mkV "spumare" | mkV "spumeggiare" | mkV "spumeggiare" ; -- UWN
lin fjord_N = mkN "fiordo" ; -- status=guess
lin flab_N = mkN "ciccia" ; -- status=guess
lin flabbergast_V2 = mkV2 (sorprendere_V) | mkV2 (mkV "stupire") | mkV2 (mkV "impressionare") | mkV2 (mkV "colpire") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin flabbiness_N = mkN "afflosciamento" | mkN "flaccidezza" | mkN "floscezza" | mkN "moscezza" ; -- UWN
lin flabby_A = mkA "flaccido" | mkA "moscio" ; -- status=guess status=guess
lin flaccid_A = mkA "moscio" | mkA "flaccido" ; -- status=guess status=guess
lin flaccidity_N = mkN "afflosciamento" | mkN "flaccidezza" | mkN "floscezza" | mkN "moscezza" ; -- UWN
lin flag_N = mkN "bandiera" ; -- status=guess
lin flag_V = mkV "flaggare" ; -- status=guess, src=wikt
lin flag_V2 = mkV2 (mkV "flaggare") ; -- status=guess, src=wikt
lin flagellation_N = mkN "curbasciata" | mkN "flagellamento" | mkN "flagellazione" | mkN "frustata" | mkN "fustigazione" | mkN "nerbata" | mkN "scudisciata" | mkN "sferzata" | mkN "staffilamento" | mkN "staffilata" ; -- UWN
lin flagellum_N = mkN "flagello" ; -- UWN
lin flageolet_N = mkN "zufolo" ; -- status=guess
lin flagon_N = mkN "caraffa" ; -- UWN
lin flagpole_N = mkN "pennone" ; -- status=guess
lin flagship_N = mkN "nave ammiraglia" | mkN "ammiraglia" | mkN "principale" feminine ; -- status=guess status=guess status=guess
lin flagstone_N = mkN "lastra" | mkN "tegola" ; -- status=guess status=guess
lin flail_N = mkN "correggiato" ; -- status=guess
lin flair_N = mkN "stile" ; -- UWN
lin flak_N = mkN "arma_antiaerea" ; -- UWN
lin flake_N = mkN "fiocco" ; -- status=guess
lin flamboyant_A = mkA "stravagante" ; -- status=guess
lin flame_N = mkN "flame" masculine ; -- status=guess
lin flame_V = mkV "fiammeggiare" | mkV "infiammare" ; -- status=guess, src=wikt status=guess, src=wikt
lin flamen_N = mkN "flamine" ; -- UWN
lin flamethrower_N = mkN "lanciafiamme" masculine ; -- status=guess
lin flamingo_N = mkN "fenicottero" ; -- status=guess
lin flammable_A = mkA "infiammabile" ; -- status=guess
lin flange_N = mkN "bordatura" | mkN "bordino" | mkN "flangia" | mkN "giunzione" ; -- UWN
lin flank_N = mkN "soccoscio" | mkN "noce" masculine | mkN "rosa" masculine ; -- status=guess status=guess status=guess
lin flank_V = mkV (mkV "aggirare") "il fianco" ; -- status=guess, src=wikt
lin flank_V2 = mkV2 (mkV (mkV "aggirare") "il fianco") ; -- status=guess, src=wikt
lin flannel_N = mkN "flanella" ; -- UWN
lin flannelette_N = mkN "flanella_di_cotone" ; -- UWN
lin flap_V = mkV "sventolare" | mkV "sbattere" | mkV "battere" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin flap_V2 = mkV2 (mkV "sventolare") | mkV2 (mkV "sbattere") | mkV2 (mkV "battere") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin flapper_N = mkN "maschietta" ; -- status=guess
lin flare_N = mkN "razzo" ; -- status=guess
lin flare_V = mkV "sfolgorare" | mkV "brillare" | mkV "scintillare" | mkV "sfolgorare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin flare_V2 = mkV2 (mkV "sfolgorare") | mkV2 (mkV "brillare") | mkV2 (mkV "scintillare") | mkV2 (mkV "sfolgorare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin flare_out_V = mkV "scampanare" ; -- UWN
lin flare_up_V = mkV "accendersi" | mkV "inalberarsi" | mkV "seccarsi" ; -- UWN
lin flash_N = mkN "baleno" | mkN "lampo" ; -- status=guess status=guess
lin flash_V = variants {} ; --
lin flashiness_N = mkN "pacchianeria" | mkN "vistosità" ; -- UWN
lin flashlight_N = mkN "torcia elettrica" ; -- status=guess
lin flask_N = mkN "fiaschetta" | mkN "boccetta" ; -- status=guess status=guess
lin flat_A = mkA "piano" ; -- status=guess
lin flat_N = variants {} ;
lin flatfish_N = mkN "rombo" ; -- status=guess
lin flatfoot_N = mkN "piede_piatto" ; -- UWN
lin flathead_N = mkN "zuccone" ; -- status=guess
lin flatlet_N = mkN "appartamentino" ; -- UWN
lin flatten_V = mkV "appiattirsi" ; -- status=guess, src=wikt
lin flatten_V2 = mkV2 (mkV "appiattirsi") ; -- status=guess, src=wikt
lin flattery_N = mkN "salamelecchi" ; -- status=guess
lin flatulence_N = mkN "turgidezza" | mkN "turgidità" ; -- UWN
lin flatulent_A = mkA "flatulente" ; -- status=guess
lin flaunt_V = mkV "ostentare" | mkV "esibire" | mkV (mettere_V) "in mostra" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin flaunt_V2 = mkV2 (mkV "ostentare") | mkV2 (mkV "esibire") | mkV2 (mkV (mettere_V) "in mostra") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin flautist_N = mkN "auleta" | mkN "aulete" | mkN "flautista" | mkN "flauto" ; -- UWN
lin flavorlessness_N = mkN "insipidezza" | mkN "insipidità" ; -- UWN
lin flavour_N = mkN "sapori" | mkN "fragranza" | mkN "aroma" masculine ; -- status=guess status=guess status=guess
lin flavour_V2 = mkV2 (mkV "condire") | mkV2 (mkV "aromatizzare") | mkV2 (mkV "profumare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin flaw_N = mkN "fessura" | mkN "cricca" | mkN "crepa" ; -- status=guess status=guess status=guess
lin flawless_A = mkA "perfetto" | mkA "levigato" ; -- status=guess status=guess
lin flax_N = mkN "lino" ; -- status=guess
lin flay_V2 = mkV2 (mkV "spellare") ; -- status=guess, src=wikt
lin flea_N = mkN "pulce" feminine ; -- status=guess
lin fleck_N = mkN "puntino" ; -- status=guess
lin fledgling_A = mkA "inesperto" | mkA "alle prime armi" ; -- status=guess status=guess
lin fledgling_N = mkN "novellino" | mkN "principiante" | mkN "pivello" ; -- status=guess status=guess status=guess
lin flee_V = mkV "fuggire" ; -- status=guess, src=wikt
lin flee_V2 = mkV2 (mkV "fuggire") ; -- status=guess, src=wikt
lin fleece_N = mkN "vello" ; -- status=guess
lin fleet_N = mkN "flotta" ; -- status=guess
lin fleet_PN = mkPN "Fleet" ; -- status=guess src=geonames
lin fleeting_A = mkA "fugace" | mkA "sfuggevole" | mkA "sfuggente" ; -- status=guess status=guess status=guess
lin fleetwood_PN = mkPN "Fleetwood" ; -- status=guess src=geonames
lin flesh_N = mkN "carne" feminine ; -- status=guess
lin fleshiness_N = mkN "carnosità" ; -- UWN
lin fleshy_A = mkA "carnoso" | mkA "polposo" ; -- UWN
lin flex_N = mkN "flessibilità" feminine ; -- status=guess
lin flex_V2 = mkV2 (mkV "piegare") | mkV2 (flettere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin flexibility_N = mkN "flessibilità" feminine ; -- status=guess
lin flexible_A = mkA "flessibile" ; -- status=guess
lin flick_N = mkN "film" | mkN "pellicola" ; -- UWN
lin flick_V2 = variants {} ; --
lin flicker_N = mkN "fremito" ; -- status=guess
lin flicker_V = mkV "guizzare" | mkV "tremolare" ; -- status=guess, src=wikt status=guess, src=wikt
lin flier_N = mkN "volantino" ; -- status=guess
lin flight_N = mkN "fuga" ; -- status=guess
lin flimsiness_N = mkN "inconsistenza" ; -- UWN
lin flinch_V = mkV "sussultare" ; -- status=guess, src=wikt
lin fling_V = mkV "gettare" | mkV "lanciare" | mkV "sbalestrare" | mkV "scagliare" | mkV "tirare" ; -- UWN
lin fling_V2 = variants {} ; --
lin flint_N = mkN "selce" ; -- status=guess
lin flint_PN = mkPN "Flint" ; -- status=guess src=geonames
lin flintlock_N = mkN "fucile_ad_acciarino" ; -- UWN
lin flintstone_N = mkN "selce" ; -- UWN
lin flip_N = mkN "giravolta" | mkN "capovolta" ; -- status=guess status=guess
lin flip_V = mkV "impazzire" | mkV (andare_V) "fuori di testa" ; -- status=guess, src=wikt status=guess, src=wikt
lin flip_V2 = mkV2 (mkV "impazzire") | mkV2 (mkV (andare_V) "fuori di testa") ; -- status=guess, src=wikt status=guess, src=wikt
lin flippant_A = mkA "impertinente" | mkA "disinvolto" ; -- status=guess status=guess
lin flipper_N = mkN "pinna" ; -- status=guess
lin flirtatious_A = mkA "civettuolo" ; -- status=guess
lin flit_V = mkV "svolazzare" ; -- status=guess, src=wikt
lin float_N = mkN "vescica_natatoria" ; -- UWN
lin float_V = L.float_V ;
lin floater_N = mkN "polizza_flottante" ; -- UWN
lin flocculation_N = mkN "flocculazione" ; -- UWN
lin flocculent_A = mkA "lanoso" ; -- UWN
lin flock_N = mkN "stormo" ; -- status=guess
lin flock_V = mkV "affollarsi" | mkV "accalcarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin flock_V2V = mkV2V (mkV "affollarsi") | mkV2V (mkV "accalcarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin flog_V2 = mkV2 (mkV "flagellare") | mkV2 (mkV "frustare") ; -- status=guess, src=wikt status=guess, src=wikt
lin flogging_N = mkN "curbasciata" | mkN "flagellamento" | mkN "flagellazione" | mkN "frustata" | mkN "fustigazione" | mkN "nerbata" | mkN "scudisciata" | mkN "sferzata" | mkN "staffilamento" | mkN "staffilata" ; -- UWN
lin flood_N = mkN "marea" | mkN "alluvione" masculine ; -- status=guess status=guess
lin flood_V = mkV "allagare" | mkV "inondare" ; -- status=guess, src=wikt status=guess, src=wikt
lin flood_V2 = mkV2 (mkV "allagare") | mkV2 (mkV "inondare") ; -- status=guess, src=wikt status=guess, src=wikt
lin floodgate_N = mkN "cataratta" | mkN "cataratta" | mkN "cateratta" | mkN "cateratta" | mkN "chiavica" | mkN "chiusa" | mkN "chiusa" | mkN "paratoia" ; -- UWN
lin floor_N = L.floor_N ;
lin floor_V2 = mkV2 (mkV "pavimentare") ; -- status=guess, src=wikt
lin flooring_N = mkN "impiantito" | mkN "pavimento" | mkN "piancito" | mkN "piantito" ; -- UWN
lin floor_walker_N = mkN "caporeparto" ; -- UWN
lin flop_Adv = mkAdv "proprio" ; -- UWN
lin flop_N = mkN "fiasco" | mkN "fallimento" | mkN "insuccesso" ; -- status=guess status=guess status=guess
lin flop_V = mkV (I.fare_V) "fiasco" | mkV (I.fare_V) "un buco nell'acqua" | mkV "fallire" | mkV (mkV "mancare") "il traguardo" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin flop_V2 = mkV2 (mkV (I.fare_V) "fiasco") | mkV2 (mkV (I.fare_V) "un buco nell'acqua") | mkV2 (mkV "fallire") | mkV2 (mkV (mkV "mancare") "il traguardo") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin floppy_A = mkA "floscio" | mkA "floscia" ; -- status=guess status=guess
lin flora_PN = mkPN "Flora" ; -- status=guess src=geonames
lin floral_A = mkA "floreale" ; -- status=guess
lin florence_1_PN = mkPN "Firenze" ; -- status=guess src=geonames
lin florence_2_PN = mkPN "Firenze" ; -- status=guess src=geonames
lin floret_N = mkN "fioretto" ; -- UWN
lin floriculture_N = mkN "floricoltura" | mkN "floricultura" ; -- UWN
lin florida_PN = mkPN "Florida" ; -- status=guess src=geonames
lin florilegium_N = mkN "collana" ; -- UWN
lin floss_N = mkN "filo interdentale" ; -- status=guess
lin flounder_N = mkN "sogliola" ; -- status=guess
lin flour_N = mkN "farina" ; -- status=guess
lin flourish_N = mkN "sventolio" | mkN "gesticolio" ; -- status=guess status=guess
lin flourish_V = mkV "fiorire" ; -- status=guess, src=wikt
lin floury_A = mkA "farinoso" ; -- status=guess
lin flow_N = mkN "flusso" ; -- status=guess
lin flow_V = L.flow_V ;
lin flower_N = L.flower_N ;
lin flower_V = mkV "fiorire" ; -- status=guess, src=wikt
lin flowerbed_N = mkN "aiuola" ; -- status=guess
lin flowerpot_N = mkN "vaso da fiori" ; -- status=guess
lin flu_N = mkN "influenza" ; -- status=guess
lin fluctuation_N = mkN "oscillazione" | mkN "variazione" ; -- UWN
lin flue_N = mkN "canna fumaria" | mkN "tubo di scarico" | mkN "condotta" | mkN "scarico" ; -- status=guess status=guess status=guess status=guess
lin fluent_A = mkA "fluente" ; -- status=guess
lin fluff_N = mkN "lanugine" | mkN "fuffa" ; -- status=guess status=guess
lin flugelhorn_N = mkN "flicorno" ; -- status=guess
lin fluid_A = mkA "liquido" ; -- status=guess
lin fluid_N = mkN "fluido" ; -- status=guess
lin flunk_V = mkV "segare" ; -- status=guess, src=wikt
lin flunk_V2 = mkV2 (mkV "segare") ; -- status=guess, src=wikt
lin fluorescence_N = mkN "fluorescenza" ; -- UWN
lin fluoridation_N = mkN "fluorizzazione" ; -- UWN
lin fluoride_N = mkN "fluoruro" ; -- status=guess
lin fluoridization_N = mkN "fluorizzazione" ; -- UWN
lin fluorine_N = mkN "fluoro" ; -- status=guess
lin fluorite_N = mkN "fluorite" feminine ; -- status=guess
lin fluosilicate_N = mkN "fluosilicato" ; -- status=guess
lin flurry_N = mkN "tormenta" ; -- status=guess
lin flurry_V2 = mkV2 (mkV "innervosire") ; -- status=guess, src=wikt
lin flush_V = mkV "arrossire" ; -- status=guess, src=wikt
lin flush_V2 = mkV2 (mkV "arrossire") ; -- status=guess, src=wikt
lin flute_N = mkN "flute" ; -- status=guess
lin fluting_N = mkN "scanalatura" ; -- UWN
lin flutist_N = mkN "auleta" | mkN "aulete" | mkN "flautista" | mkN "flauto" ; -- UWN
lin fluvial_A = mkA "fluviale" ; -- status=guess
lin flux_N = mkN "flussante" masculine ; -- status=guess
lin fluxmeter_N = mkN "flussometro" ; -- UWN
lin fly_N = mkN "mosca" ; -- status=guess
lin fly_V = L.fly_V ;
lin fly_V2 = mkV2 (mkV "imbufalire") ; -- status=guess, src=wikt
lin fly_about_V = advV OP_fly_V OP_about_Adv ; -- guess-p-verb
lin fly_around_V = advV OP_fly_V OP_around_Adv ; -- guess-p-verb
lin fly_at_V2 = prepV2 OP_fly_V OP_at_Prep ; -- guess-p-verb
lin fly_by_V = advV OP_fly_V OP_by_Adv ; -- guess-p-verb
lin fly_fish_V = variants {} ; -- guess-p-verb
lin fly_into_V2 = prepV2 OP_fly_V OP_into_Prep ; -- guess-p-verb
lin fly_out_V = advV OP_fly_V OP_out_Adv ; -- guess-p-verb
lin flyer_N = mkN "annuncio" | mkN "volantino" | mkN "opuscolo" ; -- status=guess status=guess status=guess
lin flyleaf_N = mkN "guardia" | mkN "risguardo" ; -- UWN
lin flyover_N = mkN "cavalcavia" | mkN "viadotto" ; -- status=guess status=guess
lin flypaper_N = mkN "carta_moschicida" ; -- UWN
lin flypast_N = mkN "parata_aerea" ; -- UWN
lin flywheel_N = mkN "volano" ; -- UWN
lin fo'c'sle_N = mkN "castello_di_prua" ; -- UWN
lin foal_N = mkN "puledro" ; -- status=guess
lin foam_N = mkN "schiuma" ; -- status=guess
lin foam_V = mkV "mussare" | mkV "schiumare" | mkV "schiumare" | mkV "spumare" | mkV "spumeggiare" | mkV "spumeggiare" ; -- UWN
lin focal_A = mkA "focale" ; -- status=guess
lin focalization_N = mkN "focalizzazione" ; -- UWN
lin focus_N = variants {} ; --
lin focus_V = mkV "concentrarsi" ; -- status=guess, src=wikt
lin focus_V2 = mkV2 (mkV "concentrarsi") ; -- status=guess, src=wikt
lin focus_on_V2 = prepV2 OP_focus_V OP_on_Prep ; -- guess-p-verb
lin fodder_N = mkN "foraggio" ; -- status=guess
lin foetal_A = mkA "fetale" ; -- UWN
lin foetus_N = mkN "feto" ; -- UWN
lin fog_N = L.fog_N ;
lin fog_V2 = mkV2 (mkV "annebbiarsi") ; -- status=guess, src=wikt
lin fogey_N = mkN "mummia" ; -- status=guess
lin foggia_PN = mkPN "Foggia" ; -- status=guess src=geonames
lin foglamp_N = mkN "antinebbia" | mkN "fendinebbia" ; -- UWN
lin foil_N = mkN "spalla" ; -- status=guess
lin foist_V2 = mkV2 (mkV "sbolognare") ; -- status=guess, src=wikt
lin fold_N = mkN "piegamento" | mkN "piegata" | mkN "piegatura" | mkN "ripiegatura" ; -- UWN
lin fold_V = mkV "piegare" ; -- status=guess, src=wikt
lin fold_V2 = mkV2 (mkV "piegare") ; -- status=guess, src=wikt
lin foldable_A = mkA "pieghevole" ; -- status=guess
lin folder_N = mkN "cartella" ; -- status=guess
lin folderol_N = mkN "baggianata" | mkN "boiata" | mkN "ciarpame" | mkN "citrullaggine" | mkN "cretineria" | mkN "fesseria" | mkN "imbecillaggine" | mkN "immondizia" | mkN "pattume" | mkN "sciocchezza" | mkN "spazzatura" ; -- UWN
lin foliage_N = mkN "fogliame" masculine ; -- status=guess
lin folk_N = mkN "gente" feminine | mkN "autoctono" | mkN "popolo" | mkN "abitante" masculine ; -- status=guess status=guess status=guess status=guess
lin folkestone_PN = mkPN "Folkestone" ; -- status=guess src=geonames
lin folklore_N = mkN "folclore" masculine ; -- status=guess
lin folks_N = mkN "gente" | mkN "popolo" ; -- UWN
lin folksong_N = mkN "canto_popolare" | mkN "canzone_folk" ; -- UWN
lin follicle_N = mkN "follicolo" ; -- status=guess
lin follicular_A = mkA "follicolare" ; -- UWN
lin follow_V = mkV "seguire" ;
lin follow_V2 = mkV2 (mkV "seguire") ;
lin follow_VS = mkVS (mkV "seguire") ;
lin follow_on_V = advV OP_follow_V OP_on_Adv ; -- guess-p-verb
lin follow_on_from_V2 = prepV2 (advV OP_follow_V OP_on_Adv ) OP_from_Prep ; -- guess-p-verb
lin follow_through_V = advV OP_follow_V OP_through_Adv ; -- guess-p-verb
lin follow_up_V2 = prepV2 OP_follow_V OP_up_Prep ; -- guess-p-verb
lin follower_N = variants {} ; --
lin following_A = variants {} ; --
lin following_Prep = variants {} ; --
lin folly_N = mkN "stravaganza" | mkN "unicum" | mkN "eccentricità" | mkN "edificio decorativo" ; -- status=guess status=guess status=guess status=guess
lin fomentation_N = mkN "aizzamento" | mkN "fomentazione" | mkN "istigazione" ; -- UWN
lin fond_A = mkA "innamorato" ; ----
lin fondant_N = mkN "fondant" | mkN "fondente" ; -- UWN
lin fondle_V2 = mkV2 (mkV "accarezzare") ; -- status=guess, src=wikt
lin fondue_N = mkN "fonduta" ; -- status=guess
lin font_N = mkN "battisterio" | mkN "battistero" | mkN "fonte_battesimale" ; -- UWN
lin fontanelle_N = mkN "fontanella" ; -- UWN
lin food_N = mkN "additivo alimentare" ; -- status=guess
lin fool_N = mkN "il matto" | mkN "il folle" ; -- status=guess status=guess
lin fool_V2 = mkV2 (mkV "ingannare") | mkV2 (mkV (mkV "farsi") "beffe di s.o.") | mkV2 (mkV (I.fare_V) "lo sciocco") | mkV2 (mkV "scherzare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin foolish_A = mkA "babbeo" ; -- status=guess
lin foolishness_N = mkN "sciocchezza" | mkN "stupidità" ; -- status=guess status=guess
lin foolscap_N = mkN "carta_protocollo" ; -- UWN
lin foot_N = L.foot_N ;
lin foot_V = mkV "pagare" ; -- status=guess, src=wikt
lin foot_V2 = mkV2 (mkV "pagare") ; -- status=guess, src=wikt
lin footage_N = mkN "materiale filmato" ; -- status=guess
lin football_N = mkN "calcio" ; -- status=guess
lin footballer_N = mkN "calciatore" | mkN "calciatrice" feminine ; -- status=guess status=guess
lin foot_bath_N = mkN "pediluvio" ; -- UWN
lin footbridge_N = mkN "passerella" | mkN "ponte pedonale" ; -- status=guess status=guess
lin footer_N = mkN "piè" masculine ; -- status=guess
lin footfall_N = mkN "passo" ; -- UWN
lin footing_N = mkN "appoggio" | mkN "gradino" ; -- UWN
lin footmark_N = mkN "orma" | mkN "passo" | mkN "pedata" | mkN "pesta" ; -- UWN
lin footpath_N = mkN "stradina" ; -- UWN
lin footprint_N = mkN "orma" ; -- status=guess
lin footslogger_N = mkN "fantaccino" | mkN "fante" ; -- UWN
lin footstep_N = mkN "pedata" ; -- status=guess
lin footwear_N = mkN "calzatura" ; -- status=guess
lin fop_N = mkN "bellimbusto" | mkN "cacazibetto" | mkN "cicisbeo" | mkN "damerino" | mkN "dandy" | mkN "elegantone" | mkN "gagà" | mkN "ganimede" | mkN "moscardino" | mkN "paino" | mkN "vagheggino" | mkN "zazzerino" | mkN "zerbinotto" ; -- UWN
lin for_Adv = variants {} ; -- S.for_Prep ;
lin for_PConj = variants {} ; --
lin for_Prep = S.for_Prep ;
lin forage_V = mkV "foraggiare" ; -- status=guess, src=wikt
lin foray_N = mkN "incursione" ; -- UWN
lin forbid_V2 = mkV2 (mkV "proibire") | mkV2 (mkV "vietare") ; -- status=guess, src=wikt status=guess, src=wikt
lin forbidding_A = mkA "sinistro" ; -- UWN
lin force_N = mkN "forza" ; -- status=guess
lin force_V = mkV "forzare" ; -- status=guess, src=wikt
lin force_V2 = mkV2 (mkV "forzare") ; -- status=guess, src=wikt
lin force_V2V = mkV2V (mkV "forzare") ; -- status=guess, src=wikt
lin force_VS = mkVS (mkV "forzare") ; -- status=guess, src=wikt
lin force_feed_V2 = variants {} ; -- guess-p-verb
lin force_land_V = variants {} ; -- guess-p-verb
lin force_land_V2 = variants {} ; -- guess-p-verb
lin force_out_V = advV OP_force_V OP_out_Adv ; -- guess-p-verb
lin forceless_A = mkA "fiacco" | mkA "molle" ; -- UWN
lin forceps_N = mkN "forcipe" masculine ; -- status=guess
lin forcible_A = variants {} ;
lin ford_N = mkN "guado" ; -- status=guess
lin ford_V2 = mkV2 (mkV "guadare") ; -- status=guess, src=wikt
lin fordable_A = mkA "guadabile" | mkA "guadoso" ; -- status=guess status=guess
lin fore_N = mkN "prora" | mkN "prua" ; -- UWN
lin forearm_N = mkN "avambraccio" ; -- status=guess
lin foreboding_N = mkN "malaugurio" ; -- status=guess
lin forecast_N = mkN "previsione" ; -- status=guess
lin forecast_V = prevedere_V ; -- status=guess, src=wikt
lin forecast_V2 = mkV2 (prevedere_V) ; -- status=guess, src=wikt
lin forecast_VS = mkVS (prevedere_V) ; -- status=guess, src=wikt
lin forecaster_N = mkN "preannunciatore" | mkN "preannunziatore" ; -- UWN
lin forecastle_N = mkN "castello_di_prua" ; -- UWN
lin forecourt_N = mkN "cortile" ; -- UWN
lin forefather_N = mkN "antenato" | mkN "padre" ; -- UWN
lin forefinger_N = mkN "indice" masculine ; -- status=guess
lin forefront_N = mkN "primo piano" ; -- status=guess
lin foregather_V = mkV "addensarsi" | mkV "adunarsi" | mkV "ammassarsi" | mkV "confluire" | mkV "congregare" | mkV "convenire" | mkV "raccogliere" | mkV "raccogliersi" | mkV "radunarsi" | mkV "riunirsi" ; -- UWN
lin forego_V = mkV "precedere" ; -- status=guess, src=wikt
lin forego_V2 = mkV2 (mkV "precedere") ; -- status=guess, src=wikt
lin foreground_N = mkN "primo piano" ; -- status=guess
lin forehand_N = mkN "diritto" ; -- UWN
lin forehead_N = mkN "fronte" feminine ; -- status=guess
lin foreign_1_A = variants {} ; --
lin foreign_2_A = variants {} ; --
lin foreign_A = mkA "straniero" | mkA "straniera" ; -- status=guess status=guess
lin foreigner_N = mkN "straniero" | mkN "straniera" ; -- status=guess status=guess
lin foreignness_N = mkN "singolarità" ; -- UWN
lin foreknow_V = prevedere_V ; -- status=guess, src=wikt
lin foreknow_V2 = mkV2 (prevedere_V) ; -- status=guess, src=wikt
lin foreknowledge_N = mkN "precognizione" | mkN "preconoscenza" ; -- UWN
lin foreman_N = mkN "caposquadra" ; -- status=guess
lin foremast_N = mkN "albero di trinchetto" ; -- status=guess
lin forename_N = mkN "nome" | mkN "nome_di_battesimo" ; -- UWN
lin forenoon_N = mkN "mattina" | mkN "mattinata" | mkN "mattino" ; -- UWN
lin forensic_A = mkA "medico-legale" ; -- status=guess
lin foreplay_N = mkN "preliminari" ; -- status=guess
lin foresail_N = mkN "trinchetto" ; -- status=guess
lin foresee_V2 = mkV2 (prevedere_V) ; -- status=guess, src=wikt
lin foreshore_N = mkN "bagnasciuga" masculine | mkN "battigia" ; -- status=guess status=guess
lin foresight_N = mkN "profezia" | mkN "divinazione" feminine ; -- status=guess status=guess
lin forest_N = mkN "foresta" ; -- status=guess
lin forestall_V2 = mkV2 (prevenire_V) ; -- status=guess, src=wikt
lin forester_N = mkN "arboricoltore" ; -- UWN
lin forestry_N = variants {} ; --
lin foretaste_N = mkN "pregustazione" feminine ; -- status=guess
lin foretell_V2 = mkV2 (predire_V) | mkV2 (prevedere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin forever_Adv = mkAdv "per sempre" ; -- status=guess
lin foreword_N = mkN "avvertimento" | mkN "introduzione" | mkN "isagoge" | mkN "prefazione" | mkN "proemio" | mkN "prolusione" ; -- UWN
lin forfar_PN = mkPN "Forfar" ; -- status=guess src=geonames
lin forfeit_N = mkN "sacrificio" ; -- UWN
lin forfeiture_N = mkN "sacrificio" ; -- UWN
lin forgather_V = mkV "addensarsi" | mkV "adunarsi" | mkV "ammassarsi" | mkV "confluire" | mkV "congregare" | mkV "convenire" | mkV "raccogliere" | mkV "raccogliersi" | mkV "radunarsi" | mkV "riunirsi" ; -- UWN
lin forge_V = variants {} ; --
lin forge_V2 = variants {} ; --
lin forger_N = mkN "falsario" ; -- status=guess
lin forgery_N = mkN "falsificazione" feminine ; -- status=guess
lin forget_V = mkV "dimenticare" ; -- status=guess, src=wikt
lin forget_V2 = L.forget_V2 ;
lin forget_VS = mkVS (mkV "dimenticare") ; -- status=guess, src=wikt
lin forgetful_A = mkA "smemorato" ; -- status=guess
lin forgettable_A = mkA "dimenticabile" ; -- status=guess
lin forging_N = mkN "forgiatura" | mkN "fucinatura" ; -- UWN
lin forgive_V = mkV "perdonare" ; -- status=guess, src=wikt
lin forgive_V2 = mkV2 (mkV "perdonare") ; -- status=guess, src=wikt
lin forint_N = mkN "fiorino" | mkN "forint" ; -- UWN
lin fork_1_N = mkN "diramazione" | mkN "ramificazione" ; -- UWN
lin fork_3_N = variants {} ; --
lin fork_4_N = variants {} ; --
lin fork_N = variants {} ; --
lin forklift_N = mkN "transpallet" masculine ; -- status=guess
lin form_N = mkN "formulario" ; --- split -- | geometric form -- | fill a form
lin form_V = mkV "formare" ; -- status=guess, src=wikt
lin form_V2 = mkV2 (mkV "formare") ; -- status=guess, src=wikt
lin formal_A = variants {} ; --
lin formaldehyde_N = mkN "formaldeide" ; -- status=guess
lin formalin_N = mkN "formalina" | mkN "formolo" ; -- UWN
lin formalistic_A = mkA "formalistico" | mkA "pedantesco" ; -- UWN
lin formalization_N = mkN "formalizzazione" ; -- UWN
lin formalwear_N = mkN "abito_da_sera" ; -- UWN
lin format_N = mkN "formato" ; -- UWN
lin formation_N = variants {} ; --
lin formby_PN = mkPN "Formby" ; -- status=guess src=geonames
lin former_A = mkA "precedente" | mkA "anteriore" ; -- status=guess status=guess
lin former_N = mkN "il_primo" ; -- UWN
lin formic_A = mkA "formico" ; -- status=guess
lin formidable_A = variants {} ; --
lin formosa_PN = mkPN "Formosa" ; -- status=guess src=geonames
lin formula_N = mkN "formula" ; -- status=guess
lin formulate_V2 = mkV2 (mkV "formulare") ; -- status=guess, src=wikt
lin formulation_N = mkN "enunciazione" | mkN "formulazione" ; -- UWN
lin fornicate_V = mkV "fornicare" ; -- UWN
lin forsake_V2 = mkV2 (mkV "abbandonare") ; -- status=guess, src=wikt
lin forsythia_N = mkN "forsythia" ; -- UWN
lin fortaleza_PN = mkPN "Fortaleza" ; -- status=guess src=geonames
lin forth_Adv = variants {} ; --
lin forthcoming_A = variants {} ; --
lin fortification_N = mkN "fortificazione" feminine ; -- status=guess
lin fortnight_N = variants {} ; --
lin fortnightly_A = mkA "bimensile" ; -- status=guess
lin fortnightly_Adv = mkAdv "bimensilmente" | adjAdv fortnightly_A ; -- status=guess -- derived
lin fortress_N = mkN "fortezza" | mkN "rocca" ; -- status=guess status=guess
lin fortuitousness_N = mkN "casualità" | mkN "incidentalità" | mkN "occasionalità" ; -- UWN
lin fortunate_A = variants {} ; --
lin fortunately_Adv = adjAdv fortunate_A ; -- -- derived
lin fortune_N = mkN "sorte" feminine | mkN "destino" | mkN "fortuna" ; -- status=guess status=guess status=guess
lin fortuneteller_N = mkN "lettore della mano" ; -- status=guess
lin forum_N = mkN "forum" masculine ; -- status=guess
lin forward_A = variants {} ; --
lin forward_Adv = mkAdv "avanti" ; -- status=guess
lin forward_N = mkN "avanti" masculine ; -- status=guess
lin forward_V2 = mkV2 (mkV "inoltrare") | mkV2 (trasmettere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin forwarding_N = mkN "spedizione" ; -- UWN
lin forwards_Adv = variants {} ; --
lin fosse_N = mkN "fossato" | mkN "fosso" ; -- UWN
lin fossil_N = mkN "fossile" masculine ; -- status=guess
lin fossiliferous_A = mkA "fossilifero" ; -- UWN
lin fossilize_V = mkV "fossilizzarsi" ; -- UWN
lin foster_V2 = variants {} ; --
lin fostering_N = mkN "allevamento" | mkN "educazione" ; -- UWN
lin foulard_N = mkN "foulard" ; -- UWN
lin found_V2 = mkV2 (mkV "fondare") ; -- status=guess, src=wikt
lin foundation_N = mkN "fondazione" feminine ; -- status=guess
lin founder_N = mkN "fondatore" | mkN "iniziatore" | mkN "padre" | mkN "padre_fondatore" ; -- UWN
lin foundering_N = mkN "affondamento" ; -- UWN
lin foundling_N = mkN "ruota dei trovatelli" ; -- status=guess
lin foundry_N = mkN "fonderia" ; -- status=guess
lin fount_N = mkN "fonte" feminine ; -- status=guess
lin fountain_N = mkN "fontana" ; -- status=guess
lin fowey_PN = mkPN "Fowey" ; -- status=guess src=geonames
lin fowl_N = mkN "pollame" masculine ; -- status=guess
lin fox_N = mkN "volpe" feminine ; -- status=guess
lin fox_V2 = mkV2 (mkV (mkV "lasciare") "perplesso") ; -- status=guess, src=wikt
lin foxglove_N = mkN "digitale" feminine ; -- status=guess
lin foyer_N = mkN "androne" | mkN "anticamera" | mkN "atrio" | mkN "entrata" | mkN "foyer" | mkN "hall" | mkN "ingresso" | mkN "ridotto" | mkN "vestibolo" ; -- UWN
lin fracas_N = mkN "fracasso" ; -- status=guess
lin fractal_N = mkN "frattale" masculine ; -- status=guess
lin fraction_N = mkN "frazione" feminine ; -- status=guess
lin fractional_A = mkA "frazionario" ; -- status=guess
lin fracture_N = mkN "rottura" ; -- UWN
lin fragile_A = mkA "fragile" ; -- status=guess
lin fragility_N = mkN "fragilità" feminine ; -- status=guess
lin fragment_N = mkN "frammento" ; -- status=guess
lin fragment_V = mkV "frammentare" ; -- status=guess, src=wikt
lin fragment_V2 = mkV2 (mkV "frammentare") ; -- status=guess, src=wikt
lin fragmental_A = mkA "frammentario" ; -- UWN
lin fragmentary_A = mkA "frammentario" ; -- UWN
lin fragmentation_N = mkN "spezzone" ; -- status=guess
lin fragrance_N = mkN "bouquet" | mkN "effluvio" ; -- UWN
lin frailty_N = mkN "debolezza" ; -- UWN
lin frame_N = mkN "contafotogrammi" ; -- status=guess
lin frame_V = mkV "incorniciare" ; -- status=guess, src=wikt
lin frame_V2 = mkV2 (mkV "incorniciare") ; -- status=guess, src=wikt
lin framework_N = mkN "infrastruttura" ; -- status=guess
lin franc_N = mkN "franco" ; -- status=guess
lin france_PN = mkPN "Francia" ; -- status=guess src=geonames
lin franchise_N = variants {} ; --
lin francis_PN = mkPN "Francis" ; -- status=guess src=geonames
lin francium_N = mkN "francio" ; -- status=guess
lin frangipani_N = mkN "frangipani" ; -- UWN
lin frank_A = variants {} ;
lin frank_N = mkN "hot_dog" ; -- UWN
lin frankfurter_N = mkN "hot_dog" ; -- UWN
lin frankincense_N = mkN "franchincenso" ; -- status=guess
lin frankly_Adv = adjAdv frank_A ; -- -- derived
lin frankness_N = mkN "franchezza" ; -- status=guess
lin frantic_A = mkA "frenetico" ; -- status=guess
lin fraserburgh_PN = mkPN "Fraserburgh" ; -- status=guess src=geonames
lin fraternal_A = mkA "fraterno" ; -- UWN
lin fraternity_N = mkN "fratellanza" ; -- status=guess
lin fraternization_N = mkN "fraternizzazione" ; -- UWN
lin fraternize_V = mkV "fraternizzare" ; -- UWN
lin fraud_N = mkN "frode" feminine | mkN "frodi" ; -- status=guess status=guess
lin fraudulence_N = mkN "baratteria" | mkN "frode" | mkN "imbroglio" | mkN "truffa" ; -- UWN
lin fraudulent_A = mkA "fraudolento" ; -- status=guess
lin fraught_A = mkA "gravido" | mkA "pieno" | mkA "carico" ; -- status=guess status=guess status=guess
lin fray_N = mkN "agone" masculine | mkN "baruffa" | mkN "mischia" ; -- status=guess status=guess status=guess
lin fray_V = mkV "fregare" | mkV "grattare" | mkV "sfregare" ; -- UWN
lin freak_V = mkV (andare_V) "di matto" ; -- status=guess, src=wikt
lin freak_V2 = mkV2 (mkV (andare_V) "di matto") ; -- status=guess, src=wikt
lin freckle_N = mkN "lentiggine" ; -- status=guess
lin freckleton_PN = mkPN "Freckleton" ; -- status=guess src=geonames
lin frederick_PN = mkPN "Frederick" ; -- status=guess src=geonames
lin frederiksberg_PN = mkPN "Frederiksberg" ; -- status=guess src=geonames
lin free_1_A = mkA "libero" ; -- status=guess
lin free_2_A = mkA "libero" ; -- status=guess
lin free_N = mkN "calcio di punizione" feminine ; -- status=guess
lin free_V2 = mkV2 (mkV "liberare") ; -- status=guess, src=wikt
lin free_V2V = mkV2V (mkV "liberare") ; -- status=guess, src=wikt
lin free_up_V2 = prepV2 (lin V OP_free_V2) OP_up_Prep ; -- guess-p-verb
lin freebie_N = mkN "omaggio" | mkN "campione" masculine ; -- status=guess status=guess
lin freebooter_N = mkN "predatore" | mkN "predone" | mkN "saccheggiatore" | mkN "spogliatore" ; -- UWN
lin freedom_N = mkN "libertà" feminine ; -- status=guess
lin freelance_N = mkN "mercenario" ; -- status=guess
lin freemasonry_N = mkN "intesa" | mkN "massoneria" ; -- UWN
lin freesia_N = mkN "fresia" ; -- status=guess
lin freeze_N = mkN "blocco" ; -- status=guess
lin freeze_V = L.freeze_V ;
lin freeze_V2 = mkV2 (mkV "congelare") ; -- status=guess, src=wikt
lin freezer_N = mkN "congelatore" masculine ; -- status=guess
lin freiburg_PN = mkPN "Friburgo in Brisgovia" ; -- status=guess src=geonames
lin freight_N = variants {} ; --
lin freighter_N = mkN "cargo" | mkN "mercantile" ; -- UWN
lin frenchFem_N = variants {} ;
lin frenchMasc_N = variants {} ;
lin french_A = mkA "francese" ;
lin frenetic_A = mkA "frenetico" ; -- status=guess
lin frenzy_N = mkN "frenesia" ; -- status=guess
lin frequency_N = mkN "modulazione di frequenza" ; -- status=guess
lin frequent_A = mkA "frequente" | mkA "assiduo" ; -- status=guess status=guess
lin frequent_V2 = mkV2 (mkV "frequentare") ; -- status=guess, src=wikt
lin fresco_N = mkN "affresco" ; -- status=guess
lin fresco_V2 = mkV2 (mkV "affrescare") ; -- status=guess, src=wikt
lin fresh_A = mkA "nuovo" | mkA "nuova" | mkA "recente" ; -- status=guess status=guess status=guess
lin freshen_V = mkV "rinfrescare" ; -- UWN
lin freshen_up_V = mkV "rinfrescarsi" ; -- UWN
lin fresher_N = mkN "matricola" ; -- UWN
lin freshman_N = mkN "matricola" ; -- status=guess
lin freshness_N = mkN "freschezza" ; -- status=guess
lin freshwater_PN = mkPN "Freshwater" ; -- status=guess src=geonames
lin fretsaw_N = mkN "sega_da_traforo" ; -- UWN
lin friability_N = mkN "friabilità" ; -- UWN
lin friable_A = mkA "friabile" ; -- status=guess
lin friar_N = mkN "frate" masculine ; -- status=guess
lin fricative_N = mkN "fricativa" | mkN "fricativo" ; -- UWN
lin friction_N = mkN "attrito" ; -- status=guess
lin fridge_N = L.fridge_N ;
lin friend_N = L.friend_N ;
lin friendliness_N = mkN "affabilità" | mkN "amichevolezza" | mkN "confidenzialità" | mkN "simpatia" ; -- UWN
lin friendly_A = mkA "amichevole" ; -- UWN
lin friendly_N = mkN "amichevole" masculine ; -- status=guess
lin friendship_N = mkN "amicizia" ; -- status=guess
lin frieze_N = mkN "rascia" ; -- status=guess
lin frigate_N = mkN "fregata" ; -- status=guess
lin fright_N = mkN "fifa" | mkN "paura" | mkN "spavento" | mkN "terrore" | mkN "timore" ; -- UWN
lin frighten_V2 = variants {} ; --
lin frighten_away_V2 = mkV2 (advV (lin V OP_frighten_V2) OP_away_Adv ) ; -- guess-p-verb
lin frighten_off_V2 = prepV2 (lin V OP_frighten_V2) OP_off_Prep ; -- guess-p-verb
lin frightened_A = variants {} ; --
lin frightening_A = mkA "spaventoso" ; -- status=guess
lin frightfulness_N = mkN "spaventevolezza" | mkN "spaventosità" ; -- UWN
lin frigidity_N = mkN "freddezza" | mkN "frigidità" ; -- UWN
lin frill_N = mkN "fronzolo" | mkN "ninnolo" ; -- status=guess status=guess
lin fringe_N = mkN "frangia" ; -- status=guess
lin fringy_A = mkA "marginale" ; -- UWN
lin frippery_N = mkN "baia" | mkN "frivolezza" | mkN "futilità" | mkN "risibilità" ; -- UWN
lin frisky_A = mkA "vispo" | mkA "vivace" | mkA "allegro" ; -- status=guess status=guess status=guess
lin frisson_N = mkN "brivido" ; -- status=guess
lin fritter_N = mkN "frittella" ; -- UWN
lin frivolity_N = mkN "frivolezza" ; -- status=guess
lin frivolous_A = mkA "frivolo" ; -- status=guess
lin frizzy_A = mkA "crespo" ; -- status=guess
lin frodsham_PN = mkPN "Frodsham" ; -- status=guess src=geonames
lin frog_N = mkN "rana" ; -- status=guess
lin frogman_N = mkN "sommozzatore" | mkN "sommozzatore" ; -- status=guess status=guess
lin frolic_N = mkN "gioco" ; -- UWN
lin frolic_V = mkV "sgambettare" ; -- status=guess, src=wikt
lin from_Prep = S.from_Prep ;
lin frome_PN = mkPN "Frome" ; -- status=guess src=geonames
lin frond_N = mkN "fronda" ; -- UWN
lin front_A = variants {} ; --
lin front_N = mkN "copertina" | mkN "copertine" ; -- status=guess status=guess
lin frontal_A = mkA "frontale" ; -- status=guess
lin frontal_N = mkN "facciata" | mkN "fronte" ; -- UWN
lin frontier_N = mkN "confine" masculine | mkN "frontiera" ; -- status=guess status=guess
lin frontispiece_N = mkN "frontespizio" ; -- status=guess
lin frontlet_N = mkN "frontale" ; -- UWN
lin frost_N = mkN "gelata" ; -- status=guess
lin frost_V = mkV "gelare" ; -- status=guess, src=wikt
lin frost_V2 = mkV2 (mkV "gelare") ; -- status=guess, src=wikt
lin frostbite_N = mkN "congelamento" ; -- UWN
lin frostiness_N = mkN "canizie" | mkN "canutezza" ; -- UWN
lin frosting_N = mkN "ghiaccia" | mkN "glassa" ; -- UWN
lin froth_N = mkN "schiuma" ; -- status=guess
lin frothiness_N = mkN "effervescenza" ; -- UWN
lin frown_N = mkN "accigliato" ; -- status=guess
lin frown_V = mkV "accigliarsi" | mkV "corrucciarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin frozen_A = variants {} ; --
lin fructify_V = mkV "fruttificare" ; -- status=guess, src=wikt
lin fructify_V2 = mkV2 (mkV "fruttificare") ; -- status=guess, src=wikt
lin fructose_N = mkN "fruttosio" ; -- status=guess
lin fructosuria_N = mkN "fruttosuria" ; -- status=guess
lin frugal_A = mkA "frugale" ; -- status=guess
lin frugality_N = mkN "frugalità" | mkN "parcità" | mkN "parsimonia" ; -- UWN
lin fruit_N = L.fruit_N ;
lin fruiterer_N = mkN "fruttivendolo" ; -- status=guess
lin fruitful_A = mkA "fecondo" ; -- UWN
lin fruitfulness_N = mkN "fruttuosità" | mkN "fecondità" | mkN "fertilità" ;
lin fruition_N = mkN "fruttificazione" feminine ; -- status=guess
lin frustrate_V2 = variants {} ; --
lin frustration_N = mkN "frustrazione" feminine ; -- status=guess
lin frustum_N = mkN "tronco" ; -- status=guess
lin fry_N = mkN "patata fritta" ; -- status=guess
lin fry_V = mkV "friggere" ; -- status=guess, src=wikt
lin fry_V2 = mkV2 (mkV "friggere") ; -- status=guess, src=wikt
lin frying_N = mkN "padella" | mkN "tegame" masculine ; -- status=guess status=guess
lin fuchsia_N = mkN "fucsia" ; -- status=guess
lin fuck_N = mkN "scopata" | mkN "trombata" ; -- status=guess status=guess
lin fuck_V = mkV "cazzeggiare" ; -- status=guess, src=wikt
lin fuck_V2 = mkV2 (mkV "cazzeggiare") ; -- status=guess, src=wikt
lin fucking_A = variants {} ; --
lin fucking_Adv = mkAdv "del cazzo" | mkAdv "cazzo di" ; -- status=guess status=guess
lin fuel_N = mkN "carburante" | mkN "combustibile" ; -- UWN
lin fug_N = mkN "aria_viziata" ; -- UWN
lin fugacity_N = mkN "fugacità" feminine ; -- status=guess
lin fugitive_A = mkA "latitante" ; -- status=guess
lin fugitive_N = mkN "latitante" masculine ; -- status=guess
lin fugue_N = mkN "fuga" ; -- status=guess
lin fulcrum_N = mkN "fulcro" ; -- status=guess
lin fulfil_V2 = variants {} ; --
lin fulfillment_N = mkN "adempimento" | mkN "assolvimento" ; -- UWN
lin fulfilment_N = mkN "adempimento" | mkN "assolvimento" ; -- UWN
lin full_A = L.full_A ;
lin full_time_A = variants {} ; --
lin fullness_N = mkN "pastosità" | mkN "pienezza" ; -- UWN
lin fully_Adv = adjAdv full_A ; -- -- derived
lin fulmar_N = mkN "fulmaro" ; -- status=guess
lin fulminate_N = mkN "fulminato" ; -- UWN
lin fumbler_N = mkN "ciabattone" | mkN "cialtrone" | mkN "disordinato" | mkN "guastamestieri" | mkN "guazzabuglione" | mkN "impiastratore" | mkN "incapace" | mkN "pasticcione" | mkN "scalzacane" | mkN "scalzacani" | mkN "schiappa" ; -- UWN
lin fume_N = mkN "fumo" ; -- UWN
lin fumitory_N = mkN "fumaria" ; -- status=guess
lin fun_A = variants {} ; --
lin fun_AV = L.fun_AV ; -- comment=CHECKED
lin fun_N = mkN "divertimento" ; -- status=guess
lin funambulistFem_N = variants {} ; ---- sense to be split
lin funambulistMasc_N = variants {} ; ---- sense to be split
lin function_N = mkN "funzione" feminine ; -- status=guess
lin function_V = mkV "funzionare" ; -- status=guess, src=wikt
lin functional_A = mkA "funzionale" ; -- status=guess
lin functionality_N = mkN "funzionalità" feminine ; -- status=guess
lin functionary_N = mkN "funzionario" | mkN "magistrato" | mkN "ufficiale" ; -- UWN
lin fund_N = mkN "fondo" ; -- status=guess
lin fund_V2 = mkV2 (mkV "finanziare") ; -- status=guess, src=wikt
lin fundamental_A = mkA "fondamentale" ; -- status=guess
lin fundamental_N = mkN "fondamentale" masculine ; -- status=guess
lin fundamentalism_N = mkN "fondamentalismo" ; -- status=guess
lin fundamentalist_A = mkA "fondamentalista" ; -- UWN
lin fundamentalist_N = mkN "fondamentalista" ; -- UWN
lin fundamentals_N = mkN "caposaldo" | mkN "fondamento" ; -- UWN
lin funding_N = variants {} ; --
lin funds_N = mkN "fondo" ; -- UWN
lin funeral_N = mkN "funerale" masculine ; -- status=guess
lin funerary_A = mkA "funebre" | mkA "funerario" ; -- status=guess status=guess
lin fungal_A = mkA "fungino" ; -- status=guess
lin fungicidal_A = mkA "anticrittogamico" | mkA "fungicida" ; -- UWN
lin fungicide_N = mkN "anticrittogamico" | mkN "antiparassitario" | mkN "fungicida" ; -- UWN
lin fungous_A = mkA "fungoso" ; -- UWN
lin fungus_N = mkN "fungo" ; -- status=guess
lin funicle_N = mkN "funicolo" ; -- UWN
lin funicular_N = mkN "funicolare" ; -- status=guess
lin funiculus_N = mkN "funicolo" ; -- status=guess
lin funk_N = mkN "funkulo" ; -- status=guess
lin funnel_N = mkN "imbuto" ; -- status=guess
lin funny_A = mkA "buffo" | mkA "buffa" | mkA "divertente" | mkA "esilarante" ; -- status=guess status=guess status=guess status=guess
lin fur_N = mkN "pelliccia" ; -- UWN
lin furbelow_N = mkN "balza" | mkN "falbalà" | mkN "falpalà" | mkN "frangiatura" | mkN "frappa" | mkN "volant" ; -- UWN
lin furcation_N = mkN "biforcazione" ; -- UWN
lin furious_A = mkA "furioso" | mkA "arrabbiato" ; -- status=guess status=guess
lin furlong_N = mkN "201" | mkN "168 metri" ; -- status=guess status=guess
lin furlough_N = mkN "licenza" ; -- UWN
lin furnish_V2 = mkV2 (mkV "fornire") ; -- status=guess, src=wikt
lin furniture_N = mkN "mobilio" ; -- status=guess
lin furore_N = mkN "furore" masculine ; -- status=guess
lin furrier_N = mkN "pellicceria" ; -- status=guess
lin furrow_N = mkN "ruga" ; -- status=guess
lin furrow_V = mkV "scanalare" ; -- UWN
lin furth_PN = mkPN "Furth" ; -- status=guess src=geonames
lin further_Adv = mkAdv "ulteriormente" ; -- status=guess
lin furthermore_Adv = mkAdv "inoltre" ; -- status=guess
lin fury_N = mkN "furia" ; -- status=guess
lin fuse_N = mkN "miccia" ; -- status=guess
lin fuselage_N = mkN "fusoliera" ; -- status=guess
lin fushun_PN = mkPN "Fushun" ; -- status=guess src=geonames
lin fusible_A = mkA "bassofondente" | mkA "fondibile" | mkA "fusibile" ; -- status=guess status=guess status=guess
lin fusillade_N = mkN "mitragliata" | mkN "raffica" | mkN "salva" | mkN "scarica" | mkN "sventagliata" ; -- UWN
lin fusion_N = mkN "fusione" feminine ; -- status=guess
lin fuss_N = mkN "rumore" masculine | mkN "baccano" | mkN "chiasso" ; -- status=guess status=guess status=guess
lin fuss_V = mkV "agitarsi" | mkV "affannarsi" | mkV "scalmanarsi" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin fuss_V2 = mkV2 (mkV "agitarsi") | mkV2 (mkV "affannarsi") | mkV2 (mkV "scalmanarsi") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin fussy_A = mkA "puntiglioso" | mkA "schizzinoso" | mkA "maniacale" ; -- status=guess status=guess status=guess
lin fustian_N = mkN "fustagno" ; -- UWN
lin futile_A = mkA "futile" ; -- status=guess
lin futility_N = mkN "futilità" feminine ; -- status=guess
lin future_1_N = mkN "a_venire" | mkN "avvenire" | mkN "domani" | mkN "futuro" ; -- UWN
lin future_3_N = variants {} ; --
lin future_A = mkA "futuro" ; -- status=guess
lin future_N = variants {} ; --
lin futurism_N = mkN "futurismo" ; -- status=guess
lin futuristFem_N = variants {} ; ---- sense to be split
lin futuristMasc_N = variants {} ; ---- sense to be split
lin futuristic_A = mkA "futuristico" ; -- status=guess
lin gabardine_N = mkN "blusa" | mkN "camiciotto" | mkN "spolverina" | mkN "spolverino" ; -- UWN
lin gabbro_N = mkN "eufotide" | mkN "gabbro" ; -- UWN
lin gaberdine_N = mkN "blusa" | mkN "camiciotto" | mkN "spolverina" | mkN "spolverino" ; -- UWN
lin gable_N = mkN "timpano" ; -- UWN
lin gabon_PN = mkPN "Gabon" ; -- status=guess src=geonames
lin gad_V = mkV "bighellonare" | mkV "gironzolare" ; -- UWN
lin gadabout_N = mkN "saltafossi" masculine ; -- status=guess
lin gadfly_N = mkN "assillo" ; -- UWN
lin gadget_N = mkN "aggeggio" ; -- status=guess
lin gadolinite_N = mkN "gadolinite" ; -- UWN
lin gadolinium_N = mkN "gadolinio" ; -- status=guess
lin gaffe_N = mkN "gaffe" | mkN "scorso" | mkN "topica" ; -- UWN
lin gaffsail_N = mkN "randa" ; -- UWN
lin gag_N = mkN "apribocca" | mkN "bavaglio" | mkN "mordacchia" ; -- UWN
lin gain_N = mkN "guadagno" | mkN "profitto" ; -- status=guess status=guess
lin gain_V = mkV "guadagnare" | mkV "acquisire" ; -- status=guess, src=wikt status=guess, src=wikt
lin gain_V2 = mkV2 (mkV "guadagnare") | mkV2 (mkV "acquisire") ; -- status=guess, src=wikt status=guess, src=wikt
lin gain_back_V = advV OP_gain_V OP_back_Adv ; -- guess-p-verb
lin gainsborough_PN = mkPN "Gainsborough" ; -- status=guess src=geonames
lin gaiter_N = mkN "ghette" feminine ; -- status=guess
lin galactic_A = mkA "galattico" ; -- status=guess
lin galactose_N = mkN "galattosio" ; -- status=guess
lin galactosemia_N = mkN "galattosemia" ; -- status=guess
lin galangal_N = mkN "galanga" ; -- status=guess
lin galantine_N = mkN "galantina" ; -- status=guess
lin galashiels_PN = mkPN "Galashiels" ; -- status=guess src=geonames
lin galaxy_N = mkN "galassia" ; -- status=guess
lin galbanum_N = mkN "galbano" ; -- status=guess
lin gale_N = mkN "folata" | mkN "ventata" | mkN "fortunale" | mkN "burrasca" | mkN "vento forte" | mkN "brezza" ; -- status=guess status=guess status=guess status=guess status=guess status=guess
lin galena_N = mkN "galena" ; -- UWN
lin gall_N = mkN "cistifellea" ; -- status=guess
lin gallant_A = mkA "valoroso" ; -- status=guess
lin gallant_N = mkN "damerino" ; -- status=guess
lin gallbladder_N = mkN "cistifellea" | mkN "colecisti" | mkN "vescichetta_biliare" ; -- UWN
lin galleon_N = mkN "galeone" ; -- status=guess
lin gallery_N = mkN "palchetto" | mkN "balconata" | mkN "galleria" | mkN "loggia" ; -- status=guess status=guess status=guess status=guess
lin galley_N = mkN "cambusa" ; -- status=guess
lin gallicism_N = mkN "gallicismo" ; -- status=guess
lin gallium_N = mkN "gallio" ; -- status=guess
lin gallivant_V = mkV "bighellonare" | mkV "gironzolare" ; -- UWN
lin gallon_N = mkN "gallone" ; -- UWN
lin gallows_N = mkN "forca" | mkN "patibolo" ; -- status=guess status=guess
lin gallstone_N = mkN "calcolo_biliare" ; -- UWN
lin gallup_PN = mkPN "Gallup" ; -- status=guess src=geonames
lin galosh_N = mkN "galoscia" ; -- status=guess
lin galvanic_A = mkA "galvanico" ; -- status=guess
lin galvanism_N = mkN "galvanizzazione" ; -- UWN
lin galvanization_N = mkN "galvanizzazione" feminine ; -- status=guess
lin galvanize_V2 = mkV2 (mkV "galvanizzare") ; -- status=guess, src=wikt
lin galvanize_VS = mkVS (mkV "galvanizzare") ; -- status=guess, src=wikt
lin galvanometer_N = mkN "galvanometro" ; -- status=guess
lin gambia_PN = mkPN "Gambia" ; -- status=guess src=geonames
lin gambit_N = mkN "gambetto" ; -- status=guess
lin gamble_V = mkV "giocare" ; -- UWN
lin gambling_N = mkN "gioco" | mkN "gioco_d'azzardo" ; -- UWN
lin gambol_N = mkN "gioco" ; -- UWN
lin game_1_N = variants {} ; --
lin game_2_N = variants {} ; --
lin game_3_N = mkN "caccia" | mkN "cacciagione" | mkN "selvaggina" | mkN "selvaggiume" | mkN "selvatico" ; -- UWN
lin game_N = mkN "carniere" ; -- status=guess
lin game_bag_N = mkN "carniere" ; -- UWN
lin gamekeeper_N = mkN "guardacaccia" | mkN "guardiacaccia" masculine ; -- status=guess status=guess
lin gamete_N = mkN "gamete" masculine ; -- status=guess
lin gametophyte_N = mkN "gametofito" | mkN "protallo" ; -- UWN
lin gamma_N = mkN "gamma" ; -- status=guess
lin gamopetalous_A = mkA "gamopetalo" ; -- status=guess
lin gamp_N = mkN "ombrello" ; -- UWN
lin gamut_N = mkN "gamma" ; -- status=guess
lin gang_N = mkN "ghenga" ; -- status=guess
lin ganger_N = mkN "caposquadra" ; -- UWN
lin ganglion_N = mkN "ganglio" ; -- UWN
lin gangrene_N = mkN "cancrena" ; -- status=guess
lin gangrene_V = mkV "mortificare" ; -- UWN
lin gangster_N = mkN "gangster" masculine ; -- status=guess
lin gangway_N = mkN "largo" ; -- status=guess
lin gannet_N = mkN "sula" ; -- status=guess
lin gantry_N = mkN "incastellatura" ; -- status=guess
lin gap_N = variants {} ; --
lin gape_V = mkV "spalancare" ; -- status=guess, src=wikt
lin garage_N = mkN "garage" masculine ; -- status=guess
lin garb_N = mkN "abito" | mkN "toilette" | mkN "vestire" ; -- UWN
lin garbage_N = mkN "immondizia" | mkN "spazzatura" | mkN "rifiuti" masculine ; -- status=guess status=guess status=guess
lin garboard_N = mkN "torello" ; -- UWN
lin garden_N = L.garden_N ;
lin gardenerFem_N = variants {} ; ---- sense to be split
lin gardenerMasc_N = variants {} ; --
lin gardenia_N = mkN "gardenia" ; -- status=guess
lin gardening_N = mkN "giardinaggio" ; -- status=guess
lin garforth_PN = mkPN "Garforth" ; -- status=guess src=geonames
lin garganey_N = mkN "marzaiola" ; -- status=guess
lin gargle_N = mkN "gargarismo" ; -- UWN
lin gargoyle_N = mkN "gargouille" | mkN "gargolla" ; -- status=guess status=guess
lin garish_A = mkA "pacchiano" ; -- status=guess
lin garlic_N = mkN "aglio" ; -- status=guess
lin garlicky_A = mkA "agliaceo" ; -- status=guess
lin garment_N = mkN "vestito" ; -- status=guess
lin garnet_N = mkN "granato" ; -- status=guess
lin garnish_V2 = mkV2 (mkV "guarnire") | mkV2 (mkV "decorare") | mkV2 (mkV "adornare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin garotte_N = mkN "garrota" | mkN "garrotta" ; -- UWN
lin garrison_N = mkN "guarnigione" feminine | mkN "caserma" ; -- status=guess status=guess
lin garrote_N = mkN "garrota" | mkN "garrotta" ; -- UWN
lin garrotte_N = mkN "garrota" | mkN "garrotta" ; -- UWN
lin garrulity_N = mkN "chiacchiera" | mkN "garrulità" | mkN "loquacità" | mkN "parlantina" | mkN "scilinguagnolo" ; -- UWN
lin garter_N = mkN "giarrettiera" | mkN "giarrettella" ; -- status=guess status=guess
lin gary_PN = mkPN "Gary" ; -- status=guess src=geonames
lin gas_N = mkN "camera a gas" ; -- status=guess
lin gaseous_A = mkA "gasoso" | mkA "gassoso" ; -- UWN
lin gasification_N = mkN "gasificazione" | mkN "gassificazione" ; -- UWN
lin gasify_V = mkV "gassificare" ; -- status=guess, src=wikt
lin gasify_V2 = mkV2 (mkV "gassificare") ; -- status=guess, src=wikt
lin gasket_N = mkN "guarnizione" feminine ; -- status=guess
lin gaslight_N = mkN "illuminazione_a_gas" ; -- UWN
lin gasman_N = mkN "gassista" ; -- UWN
lin gas_mask_N = mkN "maschera antigas" ; -- UWN
lin gasoline_N = mkN "benzina" ; -- status=guess
lin gasp_N = mkN "tirata di sigaretta" ; -- status=guess
lin gasp_V = mkV "rantolare" | mkV "ansimare" | mkV "boccheggiare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin gasp_V2 = mkV2 (mkV "rantolare") | mkV2 (mkV "ansimare") | mkV2 (mkV "boccheggiare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin gassy_A = mkA "gassoso" | mkA "gassosa" ; -- status=guess status=guess
lin gastrectomy_N = mkN "gastrectomia" ; -- status=guess
lin gastric_A = mkA "gastrico" ; -- status=guess
lin gastritis_N = mkN "gastrite" feminine ; -- status=guess
lin gastroenteritis_N = mkN "gastroenterite" feminine ; -- status=guess
lin gastroenterologistFem_N = variants {} ; ---- sense to be split
lin gastroenterologistMasc_N = variants {} ; ---- sense to be split
lin gastrointestinal_A = mkA "gastrointestinale" ; -- status=guess
lin gastronomic_A = mkA "gastronomico" ; -- status=guess
lin gastronomy_N = mkN "gastronomia" ; -- status=guess
lin gastrula_N = mkN "gastrula" ; -- UWN
lin gastrulation_N = mkN "gastrulazione" feminine ; -- status=guess
lin gate_N = mkN "cancello" ; -- status=guess
lin gateau_N = mkN "torta" ; -- status=guess
lin gatecrasher_N = mkN "intruso" ; -- UWN
lin gatehouse_N = mkN "portineria" ; -- UWN
lin gatekeeper_N = mkN "portiere" ; -- UWN
lin gateshead_PN = mkPN "Gateshead" ; -- status=guess src=geonames
lin gather_N = mkN "raccolta" ; -- UWN
lin gather_V = mkV "raccogliersi" ; -- status=guess, src=wikt
lin gather_V2 = mkV2 (mkV "raccogliersi") ; -- status=guess, src=wikt
lin gatherer_N = mkN "coglitore" masculine ; -- status=guess
lin gathering_N = mkN "quaderno" ; -- status=guess
lin gaucherie_N = mkN "gaffe" | mkN "scorso" | mkN "topica" ; -- UWN
lin gaudy_A = mkA "chiassoso" | mkA "vistoso" | mkA "sgargiante" ; -- status=guess status=guess status=guess
lin gauge_N = mkN "scartamento" ; -- status=guess
lin gaunt_A = mkA "smagrito" ; -- status=guess
lin gauntlet_N = mkN "guanto di armatura" ; -- status=guess
lin gauntness_N = mkN "consunzione" | mkN "deperimento" | mkN "dimagrimento" | mkN "macilenza" | mkN "magrezza" | mkN "secchezza" ; -- UWN
lin gauze_N = mkN "garza" ; -- status=guess
lin gavel_N = mkN "martelletto" ; -- UWN
lin gay_A = mkA "effemminato" ; -- status=guess
lin gay_N = mkN "gay" ;
lin gayness_N = mkN "omoerotismo" | mkN "omofilia" | mkN "omosessualità" ; -- UWN
lin gaze_N = mkN "occhiata" ; -- status=guess
lin gaze_V = mkV "guardare" | mkV (mkV "puntare") "gli occhi" | mkV (volgere_V) "lo sguardo" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin gazebo_N = mkN "gazebo" ; -- status=guess
lin gazelle_N = mkN "gazzella" ; -- status=guess
lin gazette_N = mkN "gazzetta" | mkN "gazzettino" ; -- UWN
lin gear_N = mkN "marcia" ; -- status=guess
lin gear_V = mkV "ingranare" ; -- status=guess, src=wikt
lin gear_V2 = mkV2 (mkV "ingranare") ; -- status=guess, src=wikt
lin gearbox_N = mkN "scatola del cambio" ; -- status=guess
lin gearing_N = mkN "cambio" ; -- UWN
lin gecko_N = mkN "geco" ; -- status=guess
lin geek_N = mkN "geek" | mkN "hacker" | mkN "smanettone" ; -- status=guess status=guess status=guess
lin gelatine_N = mkN "gelatina" ; -- UWN
lin gelatinous_A = mkA "gelatinoso" ; -- status=guess
lin gelatinousness_N = mkN "glutinosità" ; -- UWN
lin gelligaer_PN = mkPN "Gelligaer" ; -- status=guess src=geonames
lin gelsenkirchen_PN = mkPN "Gelsenkirchen" ; -- status=guess src=geonames
lin gem_N = mkN "gemma" | mkN "perla" | mkN "chicca" ; -- status=guess status=guess status=guess
lin gemination_N = mkN "duplicazione" ; -- UWN
lin gemini_PN = mkPN "Gemini" ; -- status=guess src=geonames
lin gemmed_A = mkA "ingemmato" | mkA "ingioiellato" ; -- UWN
lin gendarme_N = mkN "agente di polizia" | mkN "poliziotto" | mkN "carabiniere" masculine | mkN "gendarme" masculine ; -- status=guess status=guess status=guess status=guess
lin gendarmerie_N = mkN "carabinieri" | mkN "gendarmeria" ; -- status=guess status=guess
lin gender_1_N = mkN "genere" masculine ; -- status=guess
lin gender_2_N = mkN "genere" masculine ; -- status=guess
lin gene_N = mkN "gene" masculine ; -- status=guess
lin genealogic_A = mkA "genealogico" ; -- UWN
lin genealogical_A = mkA "genealogico" ; -- status=guess
lin genealogist_N = mkN "genealogista" masculine ; -- status=guess
lin genealogy_N = mkN "genealogia" ; -- status=guess
lin general_A = mkA "generale" ; -- status=guess
lin general_N = mkN "classifica generale" ; -- status=guess
lin generalissimo_N = mkN "generalissimo" ; -- status=guess
lin generality_N = mkN "generalità" feminine ; -- status=guess
lin generalize_V = mkV "generalizzare" ; -- status=guess, src=wikt
lin generalize_V2 = mkV2 (mkV "generalizzare") ; -- status=guess, src=wikt
lin generally_Adv = adjAdv general_A ; -- -- derived
lin generalship_N = mkN "generalato" ; -- UWN
lin generate_V2 = mkV2 (mkV "generare") ; -- status=guess, src=wikt
lin generation_N = mkN "generazione" feminine ; -- status=guess
lin generative_A = mkA "generativo" | mkA "generatore" | mkA "produttore" | mkA "provocatore" | mkA "suscitatore" ; -- UWN
lin generosity_N = mkN "atto di generosità" | mkN "atto generoso" ; -- status=guess status=guess
lin generous_A = mkA "abbondante" ; -- status=guess
lin genet_N = mkN "genet" masculine ; -- status=guess
lin genetic_A = mkA "genetico" ; -- status=guess
lin geneticist_N = mkN "genetista" masculine ; -- status=guess
lin genetics_N = mkN "genetica" ; -- status=guess
lin geneva_PN = mkPN "Geneva" ; -- status=guess src=geonames
lin geniality_N = mkN "affabilità" | mkN "affidabilità" | mkN "amabilità" | mkN "bonarietà" | mkN "bonomia" | mkN "gentilezza" | mkN "lenità" | mkN "mitezza" | mkN "soavità" ; -- UWN
lin genic_A = mkA "genetico" | mkA "genico" ; -- UWN
lin genital_A = mkA "genitale" | mkA "venereo" ; -- UWN
lin genitalia_N = mkN "genitali" masculine ; -- status=guess
lin genitive_A = mkA "genitivo" | mkA "possessivo" ; -- UWN
lin genitive_N = mkN "caso genitivo" ; -- status=guess
lin genius_N = variants {} ; --
lin genoa_PN = mkPN "Genova" ; -- status=guess src=geonames
lin genocide_N = mkN "genocidio" ; -- status=guess
lin genome_N = mkN "genoma" masculine ; -- status=guess
lin genotype_N = mkN "genotipo" ; -- status=guess
lin genotypical_A = mkA "genotipico" ; -- UWN
lin genre_N = mkN "genere" masculine ; -- status=guess
lin gentian_N = mkN "genziana" ; -- status=guess
lin gentility_N = mkN "aristocrazia" | mkN "distinzione" | mkN "eleganza" | mkN "finezza" | mkN "garbo" | mkN "raffinatezza" ; -- UWN
lin gentle_A = mkA "gentile" ; -- status=guess
lin gentleman_N = mkN "gentiluomo" ; -- status=guess
lin gentleness_N = mkN "delicatezza" | mkN "mansuetudine" feminine | mkN "dolcezza" | mkN "garbo" ; -- status=guess status=guess status=guess status=guess
lin gentry_N = mkN "aristocrazia" | mkN "nobiltà" ; -- UWN
lin genuflect_V = mkV "genuflettersi" ; -- status=guess, src=wikt
lin genuflection_N = mkN "genuflessione" feminine ; -- status=guess
lin genuflexion_N = mkN "genuflessione" | mkN "inginocchiamento" | mkN "inginocchiata" ; -- UWN
lin genuine_A = mkA "genuino" ; -- status=guess
lin genus_N = mkN "genere" masculine ; -- status=guess
lin geocentric_A = mkA "geocentrico" ; -- status=guess
lin geode_N = mkN "geode" masculine ; -- status=guess
lin geodesic_N = mkN "geodetica" ; -- UWN
lin geodesy_N = mkN "geodesia" ; -- UWN
lin geodetic_A = mkA "geodetico" ; -- UWN
lin geographer_N = mkN "geografo" ; -- status=guess
lin geographic_A = mkA "geografico" ; -- status=guess
lin geographical_A = variants {} ; --
lin geography_N = mkN "geografia" ; -- status=guess
lin geological_A = mkA "geologico" ; -- UWN
lin geologistFem_N = mkN "geofisico" | mkN "geologo" ; -- UWN
lin geologistMasc_N = mkN "geofisico" | mkN "geologo" ; -- UWN
lin geology_N = mkN "geologia" ; -- status=guess
lin geometer_N = mkN "geometra" masculine ; -- status=guess
lin geometric_A = mkA "geometrico" ; -- status=guess
lin geometry_N = mkN "geometria" ; -- status=guess
lin geophysical_A = mkA "geofisico" ; -- status=guess
lin geophysics_N = mkN "geofisica" ; -- status=guess
lin geopolitical_A = mkA "geopolitico" ; -- UWN
lin geopolitics_N = mkN "geopolitica" ; -- status=guess
lin george_PN = mkPN "George" ; -- status=guess src=geonames
lin georgia_PN = mkPN "Georgia" ; -- status=guess src=geonames
lin geostationary_A = mkA "geostazionario" ; -- status=guess
lin geothermal_A = mkA "geotermico" | mkA "geotermale" ; -- status=guess status=guess
lin geotropism_N = mkN "geotropismo" ; -- UWN
lin gerald_PN = mkPN "Gerald" ; -- status=guess src=geonames
lin geranium_N = mkN "geranio" ; -- status=guess
lin gerbil_N = mkN "gerbillo" | mkN "ratto della sabbia" ; -- status=guess status=guess
lin geriatrician_N = mkN "geriatra" | mkN "gerontoiatra" | mkN "gerontologo" ; -- UWN
lin geriatrics_N = mkN "geriatria" ; -- status=guess
lin germ_N = mkN "germoplasma" ; -- status=guess
lin germanFem_N = mkN "tedesca" ;
lin germanMasc_N = mkN "tedesco" ;
lin german_A = mkA "tedesco" ;
lin germander_N = mkN "camedrio" ; -- status=guess
lin germanium_N = mkN "germanio" ; -- status=guess
lin germany_PN = mkPN "Germania" ; -- status=guess src=geonames
lin germinate_V = mkV "germogliare" | mkV "gettare" ; -- UWN
lin gerontologist_N = mkN "geriatra" | mkN "gerontoiatra" | mkN "gerontologo" ; -- UWN
lin gerontology_N = mkN "gerontologia" ; -- status=guess
lin gerund_N = mkN "gerundio" ; -- status=guess
lin gesso_N = mkN "gesso" ; -- status=guess
lin gesticulate_V = mkV "gesticolare" | mkV "sbracciare" | mkV "smanacciare" | mkV "smanazzare" ; -- UWN
lin gesticulation_N = mkN "gesticolio" ; -- status=guess
lin gesture_N = mkN "gesto" ; -- status=guess
lin gesture_V = mkV "gesticolare" | mkV "sbracciare" | mkV "smanacciare" | mkV "smanazzare" ; -- UWN
lin get_V2 = mkV2 (mkV "ricevere") ;
lin get_V2V = mkV2V (mkV "ricevere") ;
lin get_VV = mkVV (mkV "ricevere") ;
lin get_about_V = advV (lin V OP_get_V2) OP_about_Adv ; -- guess-p-verb
lin get_above_V2 = prepV2 (lin V OP_get_V2) OP_above_Prep ; -- guess-p-verb
lin get_across_V = advV (lin V OP_get_V2) OP_across_Adv ; -- guess-p-verb
lin get_across_V2 = prepV2 (lin V OP_get_V2) OP_across_Prep ; -- guess-p-verb
lin get_across_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_across_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_after_V2 = prepV2 (lin V OP_get_V2) OP_after_Prep ; -- guess-p-verb
lin get_ahead_V = advV (lin V OP_get_V2) OP_ahead_Adv ; -- guess-p-verb
lin get_ahead_of_V2 = prepV2 (advV (lin V OP_get_V2) OP_ahead_Adv ) OP_of_Prep ; -- guess-p-verb
lin get_along_V = advV (lin V OP_get_V2) OP_along_Adv ; -- guess-p-verb
lin get_along_in_V2 = prepV2 (advV (lin V OP_get_V2) OP_along_Adv ) OP_in_Prep ; -- guess-p-verb
lin get_along_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_around_V = advV (lin V OP_get_V2) OP_around_Adv ; -- guess-p-verb
lin get_around_V2 = prepV2 (lin V OP_get_V2) OP_around_Prep ; -- guess-p-verb
lin get_around_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_around_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_at_V2 = prepV2 (lin V OP_get_V2) OP_at_Prep ; -- guess-p-verb
lin get_away_V = advV (lin V OP_get_V2) OP_away_Adv ; -- guess-p-verb
lin get_away_from_V2 = prepV2 (advV (lin V OP_get_V2) OP_away_Adv ) OP_from_Prep ; -- guess-p-verb
lin get_away_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_away_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_back_V = advV (lin V OP_get_V2) OP_back_Adv ; -- guess-p-verb
lin get_back_V2 = mkV2 (advV (lin V OP_get_V2) OP_back_Adv ) ; -- guess-p-verb
lin get_back_at_V2 = prepV2 (advV (lin V OP_get_V2) OP_back_Adv ) OP_at_Prep ; -- guess-p-verb
lin get_back_into_V2 = prepV2 (advV (lin V OP_get_V2) OP_back_Adv ) OP_into_Prep ; -- guess-p-verb
lin get_back_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_back_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_back_together_V = variants {} ; -- guess-p-verb
lin get_behind_V2 = prepV2 (lin V OP_get_V2) OP_behind_Prep ; -- guess-p-verb
lin get_behind_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_behind_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_by_V = mkV "districarsi" ; -- UWN
lin get_by_V2 = prepV2 (lin V OP_get_V2) OP_by_Prep ; -- guess-p-verb
lin get_by_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_by_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_by_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_by_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_down_V = advV (lin V OP_get_V2) OP_down_Adv ; -- guess-p-verb
lin get_down_V2 = prepV2 (lin V OP_get_V2) OP_down_Prep ; -- guess-p-verb
lin get_down_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_down_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_down_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_even_V = advV (lin V OP_get_V2) OP_even_Adv ; -- guess-p-verb
lin get_in_V = advV (lin V OP_get_V2) OP_in_Adv ; -- guess-p-verb
lin get_in_V2 = prepV2 (lin V OP_get_V2) OP_in_Prep ; -- guess-p-verb
lin get_in_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_in_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_into_V2 = prepV2 (lin V OP_get_V2) OP_into_Prep ; -- guess-p-verb
lin get_it_V = variants {} ; -- guess-p-verb
lin get_it_off_V = variants {} ; -- guess-p-verb
lin get_it_off_with_V2 = variants {} ; -- guess-p-verb
lin get_it_on_V = variants {} ; -- guess-p-verb
lin get_it_on_with_V2 = variants {} ; -- guess-p-verb
lin get_it_together_V = variants {} ; -- guess-p-verb
lin get_it_up_V = variants {} ; -- guess-p-verb
lin get_off_V = advV (lin V OP_get_V2) OP_off_Adv ; -- guess-p-verb
lin get_off_V2 = prepV2 (lin V OP_get_V2) OP_off_Prep ; -- guess-p-verb
lin get_off_it_V2 = variants {} ; -- guess-p-verb
lin get_off_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_off_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_off_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_off_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_on_1_V2 = variants {} ; -- guess-p-verb
lin get_on_2_V2 = variants {} ; -- guess-p-verb
lin get_on_V = advV (lin V OP_get_V2) OP_on_Adv ; -- guess-p-verb
lin get_on_at_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_at_Prep ; -- guess-p-verb
lin get_on_for_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_for_Prep ; -- guess-p-verb
lin get_on_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_on_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_onto_V2 = prepV2 (lin V OP_get_V2) OP_onto_Prep ; -- guess-p-verb
lin get_out_V = advV (lin V OP_get_V2) OP_out_Adv ; -- guess-p-verb
lin get_out_V2 = prepV2 (lin V OP_get_V2) OP_out_Prep ; -- guess-p-verb
lin get_out_of_V2 = prepV2 (advV (lin V OP_get_V2) OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin get_over_V = advV (lin V OP_get_V2) OP_over_Adv ; -- guess-p-verb
lin get_over_V2 = prepV2 (lin V OP_get_V2) OP_over_Prep ; -- guess-p-verb
lin get_over_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_over_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_round_V = advV (lin V OP_get_V2) OP_round_Adv ; -- guess-p-verb
lin get_round_V2 = prepV2 (lin V OP_get_V2) OP_round_Prep ; -- guess-p-verb
lin get_round_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_round_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_through_V = advV (lin V OP_get_V2) OP_through_Adv ; -- guess-p-verb
lin get_through_V2 = prepV2 (lin V OP_get_V2) OP_through_Prep ; -- guess-p-verb
lin get_through_V3 = variants {} ; -- guess-p-verb
lin get_through_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_through_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_to_V2 = prepV2 (lin V OP_get_V2) OP_to_Prep ; -- guess-p-verb
lin get_together_V = advV (lin V OP_get_V2) OP_together_Adv ; -- guess-p-verb
lin get_up_V = advV (lin V OP_get_V2) OP_up_Adv ; -- guess-p-verb
lin get_up_V2 = prepV2 (lin V OP_get_V2) OP_up_Prep ; -- guess-p-verb
lin get_up_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin geyser_N = mkN "geyser" masculine ; -- status=guess
lin ghana_PN = mkPN "Ghana" ; -- status=guess src=geonames
lin gherkin_N = mkN "cetriolino" ; -- status=guess
lin ghetto_N = mkN "ghetto" ; -- status=guess
lin ghost_N = mkN "fantasma" masculine | mkN "spettro" | mkN "spirito" | mkN "larva" | mkN "apparizione" feminine | mkN "ombra" | mkN "anima" | mkN "simulacro" | mkN "fantasima" | mkN "lemure" masculine ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin ghostly_A = mkA "spettrale" | mkA "fantasmatico" | mkA "spiritico" ; -- status=guess status=guess status=guess
lin ghoul_N = mkN "gula" | mkN "ghoul" ; -- status=guess status=guess
lin giant_A = variants {} ; --
lin giant_N = mkN "gigante" feminine ; -- status=guess
lin giantess_N = mkN "gigantessa" ; -- status=guess
lin giantism_N = mkN "gigantismo" ; -- UWN
lin giardia_N = mkN "lamblia" ; -- UWN
lin gibberish_N = mkN "farfuglio" | mkN "borbottio" ; -- status=guess status=guess
lin gibbon_N = mkN "gibbone" masculine ; -- status=guess
lin giblet_N = mkN "frattaglie" | mkN "rigaglie" ; -- UWN
lin gibraltar_PN = mkPN "Gibilterra" ; -- status=guess src=geonames
lin giffnock_PN = mkPN "Giffnock" ; -- status=guess src=geonames
lin gift_N = mkN "dono" | mkN "talento" ; -- status=guess status=guess
lin gift_V2 = mkV2 (mkV "regalare") ; -- status=guess, src=wikt
lin gig_N = mkN "arpione" masculine ; -- status=guess
lin gigantic_A = mkA "gigantesco" ; -- status=guess
lin gigantism_N = mkN "gigantismo" ; -- status=guess
lin giggle_N = mkN "ridarella" | mkN "riderella" | mkN "risarella" ; -- UWN
lin giggle_V = mkV "ridacchiare" ; -- status=guess, src=wikt
lin gigolo_N = mkN "accompagnatore" | mkN "ballerino" ; -- status=guess status=guess
lin gilbert_PN = mkPN "Gilbert" ; -- status=guess src=geonames
lin gild_N = mkN "circolo" | mkN "club" | mkN "società" ; -- UWN
lin gild_V2 = mkV2 (mkV "indorare") ; -- status=guess, src=wikt
lin gilder_N = mkN "doratore" masculine ; -- status=guess
lin gilding_N = mkN "doratura" ; -- UWN
lin gill_N = mkN "branchia" ; -- status=guess
lin gill_PN = mkPN "Gill" ; -- status=guess src=geonames
lin gillingham_PN = mkPN "Gillingham" ; -- status=guess src=geonames
lin gilt_N = mkN "doratura" | mkN "indorato" ; -- status=guess status=guess
lin gimlet_N = mkN "succhiello" ; -- status=guess
lin gimmick_N = mkN "stratagemma" masculine ; -- status=guess
lin ginger_N = mkN "zenzero" ; -- status=guess
lin gingiva_N = mkN "gengiva" ; -- UWN
lin gingivitis_N = mkN "gengivite" feminine ; -- status=guess
lin gipsyFem_N = variants {} ; ---- sense to be split
lin gipsyMasc_N = variants {} ; ---- sense to be split
lin giraffe_N = mkN "giraffa" ; -- status=guess
lin gird_V = mkV (mkV "legare") "allaciare" ; -- status=guess, src=wikt
lin gird_V2 = mkV2 (mkV (mkV "legare") "allaciare") ; -- status=guess, src=wikt
lin girder_N = mkN "trave" | mkN "putrella" ; -- status=guess status=guess
lin girdle_N = mkN "busto" | mkN "corsetto" | mkN "guaina" | mkN "pancera" | mkN "panciera" ; -- UWN
lin girl_N = L.girl_N ;
lin girlfriend_N = mkN "amica" | mkN "amica del cuore" ; -- status=guess status=guess
lin girlhood_N = mkN "fanciullezza" ; -- UWN
lin giro_N = mkN "giroconto" ; -- status=guess
lin girth_N = mkN "circonferenza" ; -- status=guess
lin girvan_PN = mkPN "Girvan" ; -- status=guess src=geonames
lin give_N = mkN "freeshop" ; -- status=guess
lin give_V = dare_V ;
lin give_V2 = mkV2 (dare_V) ;
lin give_V3 = L.give_V3 ;
lin give_away_V = mkV "denunciare" | mkV "denunziare" | mkV "svelare" | mkV "tradire" ; -- UWN
lin give_away_V2 = mkV2 (advV OP_give_V OP_away_Adv ) ; -- guess-p-verb
lin give_back_V2 = mkV2 (advV OP_give_V OP_back_Adv ) ; -- guess-p-verb
lin give_in_V = advV OP_give_V OP_in_Adv ; -- guess-p-verb
lin give_in_V2 = prepV2 OP_give_V OP_in_Prep ; -- guess-p-verb
lin give_in_to_V2 = prepV2 (advV OP_give_V OP_in_Adv ) OP_to_Prep ; -- guess-p-verb
lin give_it_to_V2 = variants {} ; -- guess-p-verb
lin give_it_up_for_V2 = variants {} ; -- guess-p-verb
lin give_it_up_to_V2 = variants {} ; -- guess-p-verb
lin give_of_V2 = prepV2 OP_give_V OP_of_Prep ; -- guess-p-verb
lin give_off_V = advV OP_give_V OP_off_Adv ; -- guess-p-verb
lin give_off_V2 = prepV2 OP_give_V OP_off_Prep ; -- guess-p-verb
lin give_onto_V2 = prepV2 OP_give_V OP_onto_Prep ; -- guess-p-verb
lin give_out_V = advV OP_give_V OP_out_Adv ; -- guess-p-verb
lin give_out_V2 = prepV2 OP_give_V OP_out_Prep ; -- guess-p-verb
lin give_over_V = advV OP_give_V OP_over_Adv ; -- guess-p-verb
lin give_over_V2 = prepV2 OP_give_V OP_over_Prep ; -- guess-p-verb
lin give_over_to_V3 = variants {} ; -- guess-p-verb
lin give_up_V = advV OP_give_V OP_up_Adv ; -- guess-p-verb
lin give_up_V2 = prepV2 OP_give_V OP_up_Prep ; -- guess-p-verb
lin give_up_on_V2 = prepV2 (advV OP_give_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin give_up_to_V2 = prepV2 (advV OP_give_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin give_way_V = advV OP_give_V OP_way_Adv ; -- guess-p-verb
lin give_way_to_V2 = prepV2 (advV OP_give_V OP_way_Adv ) OP_to_Prep ; -- guess-p-verb
lin give_yourself_up_V = variants {} ; -- guess-p-verb
lin give_yourself_up_to_V2 = variants {} ; -- guess-p-verb
lin given_A = variants {} ; --
lin given_N = mkN "nome" masculine ; -- status=guess
lin gizzard_N = mkN "grecile" | mkN "gricile" | mkN "ventriglio" ; -- UWN
lin glacier_N = mkN "ghiacciaio" ; -- status=guess
lin glad_A = mkA "fiero" | mkA "soddisfatto" | mkA "lieto" ; -- status=guess status=guess status=guess
lin glade_N = mkN "radura" ; -- status=guess
lin gladiator_N = mkN "gladiatore" masculine ; -- status=guess
lin gladiolus_N = mkN "gladiolo" ; -- status=guess
lin gladness_N = mkN "gioia" ; -- UWN
lin glance_N = mkN "sguardo" | mkN "occhiata" | mkN "scorsa" ; -- status=guess status=guess status=guess
lin glance_V = mkV (dare_V) "un'occhiata" ; -- status=guess, src=wikt
lin glance_V2 = mkV2 (mkV (dare_V) "un'occhiata") ; -- status=guess, src=wikt
lin gland_N = mkN "ghiandola" ; -- status=guess
lin glanders_N = mkN "moccio" | mkN "morva" ; -- UWN
lin glandular_A = mkA "ghiandolare" ; -- status=guess
lin glans_N = mkN "glande" masculine ; -- status=guess
lin glare_N = mkN "frecciata" ; -- status=guess
lin glare_V = variants {} ; --
lin glare_V2 = variants {} ; --
lin glasgow_PN = mkPN "Glasgow" ; -- status=guess src=geonames
lin glasnost_N = mkN "glasnost" ; -- status=guess
lin glass_1_N = mkN "vetro" ; -- status=guess
lin glass_2_N = mkN "vetro" ; -- status=guess
lin glass_blower_N = mkN "vetraio" ; -- UWN
lin glassful_N = mkN "bicchierata" | mkN "bicchiere" ; -- UWN
lin glasshouse_N = mkN "serra" ; -- UWN
lin glassmaker_N = mkN "vetraio" ; -- UWN
lin glassware_N = mkN "vetreria" ; -- UWN
lin glassworks_N = mkN "cristalleria" | mkN "soffieria" | mkN "vetreria" ; -- UWN
lin glastonbury_PN = mkPN "Glastonbury" ; -- status=guess src=geonames
lin glaucoma_N = mkN "glaucoma" ; -- UWN
lin glaucous_A = mkA "glauco" ; -- status=guess
lin glaze_N = mkN "gelicidio" ; -- status=guess
lin glazier_N = mkN "vetraio" ; -- UWN
lin gleam_N = mkN "barlume" | mkN "chiarore" | mkN "spiraglio" ; -- UWN
lin glean_V = mkV "racimolare" | raccogliere_V | mkV "raccattare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin glean_V2 = mkV2 (mkV "racimolare") | mkV2 (raccogliere_V) | mkV2 (mkV "raccattare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin glee_N = mkN "gioia" ; -- status=guess
lin glenrothes_PN = mkPN "Glenrothes" ; -- status=guess src=geonames
lin glib_A = mkA "loquace" | mkA "fluente" ; -- status=guess status=guess
lin glide_N = mkN "veleggio" | mkN "volovelismo" ; -- UWN
lin glide_V = mkV "librarsi" ; -- status=guess, src=wikt
lin glider_N = mkN "aliante" ; -- status=guess
lin gliding_N = mkN "veleggio" | mkN "volovelismo" ; -- UWN
lin glimmer_N = mkN "barlume" ; -- status=guess
lin glimpse_N = mkN "guardata" | mkN "occhiata" | mkN "passata" | mkN "sguardo" | mkN "vista" ; -- UWN
lin glioblastoma_N = mkN "glioblastoma" masculine ; -- status=guess
lin glioma_N = mkN "glioma" masculine ; -- status=guess
lin glissando_N = mkN "glissando" | mkN "strisciando" ; -- UWN
lin glister_N = mkN "allucciolio" | mkN "brillio" | mkN "luccicamento" | mkN "luccichio" | mkN "lucciolio" | mkN "luminio" | mkN "scintillio" ; -- UWN
lin gloaming_N = mkN "imbrunire" ; -- status=guess
lin global_A = variants {} ; --
lin globe_N = mkN "globo" ; -- status=guess
lin globeflower_N = mkN "aconito_giallo" | mkN "lupaia" | mkN "luparia" ; -- UWN
lin globetrotter_N = mkN "giramondo" | mkN "globe-trotter" ; -- UWN
lin globule_N = mkN "globulo" ; -- UWN
lin globulin_N = mkN "globulina" ; -- status=guess
lin glockenspiel_N = mkN "campanelli mpl" ; -- status=guess
lin glomerulus_N = mkN "glomerulo" ; -- UWN
lin gloom_N = variants {} ; --
lin gloomy_A = mkA "cupo" ; -- status=guess
lin gloria_PN = mkPN "Gloria" ; -- status=guess src=geonames
lin glorification_N = mkN "glorificazione" | mkN "magnificazione" ; -- UWN
lin glorious_A = mkA "glorioso" ; -- status=guess
lin glory_N = mkN "gloria" ; -- status=guess
lin gloss_N = mkN "colore" | mkN "parvenza" ; -- UWN
lin glossary_N = mkN "glossario" ; -- status=guess
lin glossitis_N = mkN "glossite" ; -- UWN
lin glossop_PN = mkPN "Glossop" ; -- status=guess src=geonames
lin glossy_A = mkA "lucido" ; -- status=guess
lin glossy_N = mkN "averla formichiera splendente" ; -- status=guess
lin glottis_N = mkN "glottide" feminine ; -- status=guess
lin glottochronology_N = mkN "glottocronologia" ; -- UWN
lin gloucester_PN = mkPN "Gloucester" ; -- status=guess src=geonames
lin glove_N = L.glove_N ;
lin glow_N = mkN "calore" masculine | mkN "ardore" | mkN "splendore" masculine ; -- status=guess status=guess status=guess
lin glow_V = mkV "brillare" ; -- status=guess, src=wikt
lin glucose_N = mkN "glucosio" ; -- status=guess
lin glucoside_N = mkN "glucoside" masculine ; -- status=guess
lin glue_N = mkN "colla" ; -- status=guess
lin glue_V2 = mkV2 (mkV "incollare") ; -- status=guess, src=wikt
lin glume_N = mkN "gluma" ; -- status=guess
lin glumness_N = mkN "tetraggine" ; -- UWN
lin gluon_N = mkN "gluone" masculine ; -- status=guess
lin glusburn_PN = mkPN "Glusburn" ; -- status=guess src=geonames
lin glut_N = mkN "eccesso" | mkN "pletora" | mkN "scorpacciata" | mkN "sazietà" ; -- status=guess status=guess status=guess status=guess
lin glutamate_N = mkN "glutammato" ; -- UWN
lin glutamine_N = mkN "glutammina" ; -- status=guess
lin gluten_N = mkN "glutine" masculine ; -- status=guess
lin gluteus_N = mkN "gluteo" ; -- UWN
lin glutinous_A = mkA "glutinoso" ; -- status=guess
lin glutton_N = mkN "ghiottone" masculine | mkN "ingordo" | mkN "divoratore" ; -- status=guess status=guess status=guess
lin gluttonous_A = mkA "ghiottone" ; -- UWN
lin gluttony_N = mkN "gola" ; -- status=guess
lin glyceraldehyde_N = mkN "gliceraldeide" | mkN "aldeide glicerica" ; -- status=guess status=guess
lin glyceride_N = mkN "gliceride" ; -- UWN
lin glycerine_N = mkN "glicerina" ; -- status=guess
lin glycerol_N = mkN "glicerina" | mkN "glicerolo" | mkN "propantriolo" ; -- UWN
lin glycogen_N = mkN "glicogeno" ; -- status=guess
lin glycolysis_N = mkN "glicolisi" feminine ; -- status=guess
lin glycoprotein_N = mkN "glicoproteina" ; -- status=guess
lin glycoside_N = mkN "glicoside" | mkN "glucoside" ; -- UWN
lin glycosuria_N = mkN "glicosuria" ; -- status=guess
lin glyptics_N = mkN "gliptica" | mkN "glittica" ; -- UWN
lin gnarled_A = mkA "bitorzoluto" ; -- status=guess
lin gnaw_V = mkV "rodere" ; -- status=guess, src=wikt
lin gnaw_V2 = mkV2 (mkV "rodere") ; -- status=guess, src=wikt
lin gneiss_N = mkN "ortogneiss" ; -- status=guess
lin gnocchi_N = mkN "gnocchi" masculine ; -- status=guess
lin gnome_N = mkN "gnomo" ; -- status=guess
lin gnomic_A = mkA "gnomico" ; -- UWN
lin gnomon_N = mkN "gnomone" masculine ; -- status=guess
lin gnosis_N = mkN "gnosi" ; -- UWN
lin gnu_N = mkN "gnu" masculine ; -- status=guess
lin go_N = mkN "approvazione" feminine ; -- status=guess
lin go_V = L.go_V ;
lin go_VA = mkVA L.go_V ;
lin go_VV = mkVV L.go_V ;
lin go_about_V = advV OP_go_V OP_about_Adv ; -- guess-p-verb
lin go_about_V2 = prepV2 OP_go_V OP_about_Prep ; -- guess-p-verb
lin go_across_V = mkV "attraversare" | mkV "passare" | mkV "transitare" ; -- UWN
lin go_after_V2 = prepV2 OP_go_V OP_after_Prep ; -- guess-p-verb
lin go_against_V2 = prepV2 OP_go_V OP_against_Prep ; -- guess-p-verb
lin go_ahead_V = advV OP_go_V OP_ahead_Adv ; -- guess-p-verb
lin go_ahead_with_V2 = prepV2 (advV OP_go_V OP_ahead_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_along_V = mkV "decorrere" | mkV "passare" | mkV "scorrere" | mkV "trascorrere" ; -- UWN
lin go_along_with_V2 = prepV2 (advV OP_go_V OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_around_V = advV OP_go_V OP_around_Adv ; -- guess-p-verb
lin go_at_V2 = prepV2 OP_go_V OP_at_Prep ; -- guess-p-verb
lin go_away_V = advV OP_go_V OP_away_Adv ; -- guess-p-verb
lin go_back_V = advV OP_go_V OP_back_Adv ; -- guess-p-verb
lin go_back_V2 = mkV2 (advV OP_go_V OP_back_Adv ) ; -- guess-p-verb
lin go_back_on_V2 = prepV2 (advV OP_go_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin go_before_V = advV OP_go_V OP_before_Adv ; -- guess-p-verb
lin go_below_V = advV OP_go_V OP_below_Adv ; -- guess-p-verb
lin go_by_V = advV OP_go_V OP_by_Adv ; -- guess-p-verb
lin go_by_V2 = prepV2 OP_go_V OP_by_Prep ; -- guess-p-verb
lin go_down_V = advV OP_go_V OP_down_Adv ; -- guess-p-verb
lin go_down_on_V2 = prepV2 (advV OP_go_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin go_down_to_V2 = prepV2 (advV OP_go_V OP_down_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_down_with_V2 = prepV2 (advV OP_go_V OP_down_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_for_V = advV OP_go_V OP_for_Adv ; -- guess-p-verb
lin go_for_V2 = prepV2 OP_go_V OP_for_Prep ; -- guess-p-verb
lin go_for_it_V = variants {} ; -- guess-p-verb
lin go_forth_V = advV OP_go_V OP_forth_Adv ; -- guess-p-verb
lin go_forward_V = advV OP_go_V OP_forward_Adv ; -- guess-p-verb
lin go_in_V = mkV "entrare" ; -- UWN
lin go_in_for_V2 = prepV2 (advV OP_go_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin go_in_with_V2 = prepV2 (advV OP_go_V OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_into_V2 = prepV2 OP_go_V OP_into_Prep ; -- guess-p-verb
lin go_it_V = variants {} ; -- guess-p-verb
lin go_it_alone_V = variants {} ; -- guess-p-verb
lin go_off_V = advV OP_go_V OP_off_Adv ; -- guess-p-verb
lin go_off_V2 = prepV2 OP_go_V OP_off_Prep ; -- guess-p-verb
lin go_off_with_V2 = prepV2 (advV OP_go_V OP_off_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_on_V = advV OP_go_V OP_on_Adv ; -- guess-p-verb
lin go_on_V2 = prepV2 OP_go_V OP_on_Prep ; -- guess-p-verb
lin go_on_about_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_about_Prep ; -- guess-p-verb
lin go_on_at_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_at_Prep ; -- guess-p-verb
lin go_on_to_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_on_with_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_one_V = variants {} ; -- guess-p-verb
lin go_out_V = mkV "spegnersi" ; -- UWN
lin go_out_for_V2 = prepV2 (advV OP_go_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin go_out_to_V2 = prepV2 (advV OP_go_V OP_out_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_out_with_V2 = prepV2 (advV OP_go_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_over_V = advV OP_go_V OP_over_Adv ; -- guess-p-verb
lin go_over_V2 = prepV2 OP_go_V OP_over_Prep ; -- guess-p-verb
lin go_over_to_V2 = prepV2 (advV OP_go_V OP_over_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_past_V2 = prepV2 OP_go_V OP_past_Prep ; -- guess-p-verb
lin go_round_V = advV OP_go_V OP_round_Adv ; -- guess-p-verb
lin go_through_V = advV OP_go_V OP_through_Adv ; -- guess-p-verb
lin go_through_V2 = prepV2 OP_go_V OP_through_Prep ; -- guess-p-verb
lin go_through_with_V2 = prepV2 (advV OP_go_V OP_through_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_to_V2 = prepV2 OP_go_V OP_to_Prep ; -- guess-p-verb
lin go_together_V = advV OP_go_V OP_together_Adv ; -- guess-p-verb
lin go_towards_V2 = prepV2 OP_go_V OP_towards_Prep ; -- guess-p-verb
lin go_under_V = advV OP_go_V OP_under_Adv ; -- guess-p-verb
lin go_up_V = advV OP_go_V OP_up_Adv ; -- guess-p-verb
lin go_up_to_V2 = prepV2 (advV OP_go_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_with_V2 = prepV2 OP_go_V OP_with_Prep ; -- guess-p-verb
lin go_without_V2 = prepV2 OP_go_V OP_without_Prep ; -- guess-p-verb
lin goad_N = mkN "pungolo" ; -- UWN
lin goal_1_N = mkN "porta" | mkN "rete" feminine ; -- status=guess status=guess
lin goal_2_N = mkN "porta" | mkN "rete" feminine ; -- status=guess status=guess
lin goalkeeper_N = mkN "portiere" masculine ; -- status=guess
lin goalpost_N = mkN "montante" | mkN "palo" | mkN "palo_della_porta" ; -- UWN
lin goat_N = mkN "capra" ; -- status=guess
lin goatee_N = mkN "pizzo" ; -- status=guess
lin goatherd_N = mkN "capraio" ; -- status=guess
lin goatsucker_N = mkN "caprimulgo" | mkN "nottola" | mkN "nottolone" ; -- UWN
lin gob_N = mkN "marinaio" ; -- status=guess
lin gobbledygook_N = mkN "supercazzola" ; -- status=guess
lin gobbler_N = mkN "gallinaccio" ; -- UWN
lin goblet_N = mkN "coppa" ; -- status=guess
lin goblin_N = mkN "folletto" ; -- status=guess
lin god_N = mkN "dio" ; -- status=guess
lin godalming_PN = mkPN "Godalming" ; -- status=guess src=geonames
lin godchild_N = mkN "figlioccio" ; -- UWN
lin goddess_N = mkN "diva" | mkN "dea" ; -- status=guess status=guess
lin godfather_N = mkN "padrone" masculine ; -- status=guess
lin godfrey_PN = mkPN "Godfrey" ; -- status=guess src=geonames
lin godliness_N = mkN "religiosità" feminine | mkN "devozione" feminine | mkN "pietas" feminine ; -- status=guess status=guess status=guess
lin godmanchester_PN = mkPN "Godmanchester" ; -- status=guess src=geonames
lin godmother_N = mkN "comare" feminine | mkN "madrina" ; -- status=guess status=guess
lin godsend_N = mkN "colpo di fortuna" ; -- status=guess
lin godson_N = mkN "figlioccio" ; -- UWN
lin goggles_N = mkN "occhiali di protezione" feminine | mkN "occhiali protettivi" ; -- status=guess status=guess
lin going_N = mkN "dipartita" | mkN "partenza" ; -- UWN
lin goiter_N = mkN "gozzo" | mkN "struma" ; -- UWN
lin goitre_N = mkN "gozzo" | mkN "struma" ; -- UWN
lin gold_A = variants {} ; --
lin gold_N = L.gold_N ;
lin golden_A = mkA "d'oro" ; -- status=guess
lin goldenrod_N = mkN "verga d'oro" ; -- status=guess
lin goldfinch_N = mkN "cardellino" ; -- status=guess
lin goldfish_N = mkN "pesce rosso" ; -- status=guess
lin goldilocks_N = mkN "riccioli d'oro" ; -- status=guess
lin goldsmith_N = mkN "orafo" | mkN "orafa" | mkN "orefice" masculine ; -- status=guess status=guess status=guess
lin golem_N = mkN "automa" | mkN "robot" ; -- UWN
lin golf_N = mkN "golf" masculine ; -- status=guess
lin golf_club_N = mkN "bastone_da_golf" | mkN "mazza" | mkN "mazza_da_golf" ; -- UWN
lin golfer_N = mkN "golfista" ; -- UWN
lin goliath_N = mkN "colosso" | mkN "gigante" ; -- UWN
lin golosh_N = mkN "caloscia" | mkN "galoche" ; -- UWN
lin gonad_N = mkN "coglioni" masculine ; -- status=guess
lin gonadotropin_N = mkN "gonadostimolina" | mkN "gonadostimulina" | mkN "gonadotropina" ; -- UWN
lin gondola_N = mkN "gondola" ; -- status=guess
lin gondolier_N = mkN "gondoliere" masculine ; -- status=guess
lin gong_N = mkN "soneria" | mkN "suoneria" ; -- UWN
lin goniometer_N = mkN "goniometro" ; -- status=guess
lin gonococcus_N = mkN "gonococco" ; -- status=guess
lin gonorrhea_N = mkN "gonorrea" ; -- status=guess
lin gonorrhoea_N = mkN "blenorragia" | mkN "blenorrea" | mkN "gonorrea" ; -- UWN
lin goo_N = mkN "belletta" | mkN "fanghiglia" | mkN "limo" | mkN "melma" | mkN "mota" ; -- UWN
lin good_A = L.good_A ;
lin good_N = mkN "bene" masculine ; -- status=guess
lin good_afternoon_Interj = mkInterj "buongiorno" ;
lin good_evening_Interj = mkInterj "buona sera" ;
lin good_luck_Interj = mkInterj "buona fortuna" ;
lin good_morning_Interj = mkInterj "buongiorno" ;
lin good_night_Interj = mkInterj "buona notte" ;
lin goodbye_Interj = mkInterj "arrivederci" | mkInterj "arrivederla" | mkInterj "ciao" ;
lin goodness_N = mkN "bontà" feminine ; -- status=guess
lin goodwill_N = mkN "buona volontà" ; -- status=guess
lin goody_N = mkN "bocconcino" | mkN "boccone" | mkN "ghiottoneria" | mkN "golosità" | mkN "leccornia" | mkN "mangiarino" | mkN "manicaretto" | mkN "manna" | mkN "squisitezza" ; -- UWN
lin goofy_A = mkA "goffo" | mkA "stupido" | mkA "particolare" ; -- status=guess status=guess status=guess
lin goole_PN = mkPN "Goole" ; -- status=guess src=geonames
lin goose_N = mkN "oca" ; -- status=guess
lin gooseberry_N = mkN "uva spina" ; -- status=guess
lin goosefoot_N = mkN "chenopodio" ; -- UWN
lin gordon_PN = mkPN "Gordon" ; -- status=guess src=geonames
lin gore_N = mkN "gherone" masculine ; -- status=guess
lin gorge_N = mkN "gola" ; -- status=guess
lin gorge_V = mkV "abbuffarsi" | mkV "rimpinzarsi" ; -- UWN
lin gorgeous_A = mkA "magnifico" ; -- status=guess
lin gorget_N = mkN "goletta" | mkN "gorgiera" ; -- UWN
lin gorgon_N = mkN "Gorgone" feminine ; -- status=guess
lin gorgonzola_N = mkN "gorgonzola" ; -- UWN
lin gorilla_N = mkN "gorilla" masculine ; -- status=guess
lin gormandize_V = mkV "abbuffarsi" | mkV "rimpinzarsi" ; -- UWN
lin gorseinon_PN = mkPN "Gorseinon" ; -- status=guess src=geonames
lin goshawk_N = mkN "astore" masculine ; -- status=guess
lin gosling_N = mkN "ochetto" | mkN "ochetta" | mkN "papero" ;
lin gospel_N = mkN "vangelo" ; -- status=guess
lin gosport_PN = mkPN "Gosport" ; -- status=guess src=geonames
lin gossip_N = mkN "pettegolezzo" | mkN "chiacchera" | mkN "diceria" ; -- status=guess status=guess status=guess
lin gossip_V = mkV "spettegolare" ; -- status=guess, src=wikt
lin gossiping_N = mkN "pettegolezzi" | mkN "pettegolio" ; -- UWN
lin gothenburg_PN = mkPN "Gothenburg" ; -- status=guess src=geonames
lin gothic_A = variants {} ; --
lin gouger_N = mkN "abbindolatore" | mkN "aggiratore" | mkN "arcadore" | mkN "arcatore" | mkN "baro" | mkN "bidonista" | mkN "blackleg" | mkN "cagliostro" | mkN "camorrista" | mkN "frodatore" | mkN "gabbacompagno" | mkN "gabbacristiani" | mkN "gabbamondo" | mkN "gabbatore" | mkN "giuntatore" | mkN "imbroglione" | mkN "impostore" | mkN "lestofante" | mkN "magliaro" | mkN "mistificatore" | mkN "pataccaro" | mkN "pelagatti" | mkN "pellaccia" | mkN "raggiratore" | mkN "truccone" | mkN "truffaldino" | mkN "truffatore" | mkN "turlupinatore" ; -- UWN
lin goulash_N = mkN "gulasch" masculine ; -- status=guess
lin gourd_N = mkN "zucca" ; -- status=guess
lin gourde_N = mkN "gourde" | mkN "gourde_di_Haiti" ; -- UWN
lin gourmand_N = mkN "ghiottone" masculine | mkN "golosone" masculine ; -- status=guess status=guess
lin gourmet_N = mkN "buongustaio" ; -- status=guess
lin gourock_PN = mkPN "Gourock" ; -- status=guess src=geonames
lin gout_N = mkN "gotta" | mkN "podagra" ;
lin govern_V = variants {} ; --
lin govern_V2 = variants {} ; --
lin governance_N = mkN "amministrazione" | mkN "gestione" | mkN "governo" ; -- UWN
lin governess_N = mkN "governante" ; -- UWN
lin government_N = mkN "governamento" ;
lin governor_N = mkN "governatore" masculine ; -- status=guess
lin governorship_N = mkN "governatorato" ; -- UWN
lin gown_N = mkN "toga" ; -- status=guess
lin grab_N = mkN "afferrare" ; -- status=guess
lin grab_V = mkV "afferrare" ; -- status=guess, src=wikt
lin grab_V2 = mkV2 (mkV "afferrare") ; -- status=guess, src=wikt
lin grace_N = mkN "grazia" | mkN "eleganza" | mkN "garbo" | mkN "leggiadria" ; -- status=guess status=guess status=guess status=guess
lin graceful_A = mkA "elegante" | mkA "aggraziato" | mkA "leggiadro" | mkA "bello" ; -- status=guess status=guess status=guess status=guess
lin gracefulness_N = mkN "graziosità" | mkN "flessuosità" feminine ; -- status=guess status=guess
lin gracelessness_N = mkN "goffaggine" | mkN "sgraziataggine" ; -- UWN
lin graciousness_N = mkN "benignità" | mkN "compiacenza" | mkN "degnazione" ; -- UWN
lin gradation_N = mkN "graduazione" ; -- UWN
lin grade_N = variants {} ; --
lin gradient_N = mkN "gradiente" masculine ; -- status=guess
lin gradual_A = mkA "graduale" ; -- UWN
lin graduality_N = mkN "gradualità" ; -- UWN
lin gradualness_N = mkN "gradualità" feminine ; -- status=guess
lin graduate_N = mkN "diplomato" | mkN "diplomata" ; -- status=guess status=guess
lin graduate_V = mkV "laurearsi" ; -- status=guess, src=wikt
lin graduate_V2 = mkV2 (mkV "laurearsi") ; -- status=guess, src=wikt
lin graduation_N = mkN "graduazione" feminine ; -- status=guess
lin graffito_N = mkN "graffiti" | mkN "graffito" ; -- UWN
lin graft_N = mkN "innesto" ; -- status=guess
lin graft_V = mkV "innestare" ; -- status=guess, src=wikt
lin graft_V2 = mkV2 (mkV "innestare") ; -- status=guess, src=wikt
lin grain_N = mkN "grano" ; -- status=guess
lin gram_N = mkN "grammo" ; -- status=guess
lin grammar_N = L.grammar_N ;
lin grammarian_N = mkN "grammatico" ; -- status=guess
lin grammatical_A = variants {} ; --
lin gramme_N = mkN "g" | mkN "gramma" | mkN "grammo" ; -- UWN
lin gramophone_N = mkN "fonografo" | mkN "grammofono" ; -- UWN
lin granada_PN = mkPN ("Granada" | "Grenada") ; -- status=guess src=geonames
lin grand_A = variants {} ; --
lin grandad_N = mkN "avo" | mkN "nonnino" | mkN "nonno" ; -- UWN
lin grandaunt_N = mkN "prozia" ; -- status=guess
lin grandchild_N = mkN "nipote" feminine ; -- status=guess
lin granddad_N = mkN "avo" | mkN "nonnino" | mkN "nonno" ; -- UWN
lin granddaughter_N = mkN "nipote" feminine ; -- status=guess
lin grandeur_N = mkN "fastosità" | mkN "grandezza" | mkN "grandiosità" | mkN "magnificenza" | mkN "sfarzo" | mkN "sfarzosità" | mkN "sontuosità" | mkN "splendidezza" | mkN "splendore" | mkN "suntuosità" ; -- UWN
lin grandfather_N = mkN "nonno" ; -- status=guess
lin grandiloquence_N = mkN "grandiloquenza" | mkN "magniloquenza" | mkN "retorica" ; -- UWN
lin grandiose_A = mkA "grandioso" ; -- status=guess
lin grandiosity_N = mkN "grandiloquenza" | mkN "magniloquenza" | mkN "retorica" ; -- UWN
lin grandma_N = mkN "nonna" ; -- status=guess
lin grandmother_N = mkN "nonna" ; -- status=guess
lin grandnephew_N = mkN "pronipote" ; -- status=guess
lin grandpa_N = mkN "nonno" ; -- status=guess
lin grandparent_N = mkN "nonno" | mkN "nonna" ; -- status=guess status=guess
lin grandson_N = mkN "nipote" feminine ; -- status=guess
lin grandstand_N = mkN "tribuna" ; -- UWN
lin granduncle_N = mkN "prozio" ; -- status=guess
lin grangemouth_PN = mkPN "Grangemouth" ; -- status=guess src=geonames
lin granite_N = mkN "granito" ; -- UWN
lin granitic_A = mkA "granitico" ; -- status=guess
lin grant_N = variants {} ; --
lin grant_V2 = variants {} ; --
lin grant_V3 = variants {} ; --
lin grantham_PN = mkPN "Grantham" ; -- status=guess src=geonames
lin grantor_N = mkN "concedente" | mkN "conceditore" | mkN "concessore" ; -- UWN
lin granule_N = mkN "granulo" ; -- UWN
lin granuloma_N = mkN "granuloma" ; -- status=guess
lin granulomatous_A = mkA "granulomatoso" ; -- UWN
lin grape_N = mkN "uva" ; -- status=guess
lin grapefruit_N = mkN "pompelmo" ; -- status=guess
lin grapeshot_N = mkN "mitraglia" ; -- UWN
lin grapevine_N = mkN "tam-tam" masculine ; -- status=guess
lin graph_N = mkN "grafo" ; -- status=guess
lin graphics_N = mkN "scheda video" ; -- status=guess
lin graphite_N = mkN "grafite" feminine ; -- status=guess
lin graphologist_N = mkN "grafologo" ; -- UWN
lin grapnel_N = mkN "grappino" ; -- UWN
lin grappa_N = mkN "grappa" ; -- status=guess
lin grasp_N = mkN "presa" | mkN "stretta" ; -- status=guess status=guess
lin grasp_V = mkV "afferrare" ; -- status=guess, src=wikt
lin grasp_V2 = mkV2 (mkV "afferrare") ; -- status=guess, src=wikt
lin grasping_N = mkN "prensione" | mkN "presa" ; -- UWN
lin grass_N = L.grass_N ;
lin grass_V = mkV "denunciare" | mkV "denunziare" | mkV "svelare" | mkV "tradire" ; -- UWN
lin grasshopper_N = mkN "cavalletta" ; -- status=guess
lin grassland_N = mkN "prateria" ; -- status=guess
lin grassy_A = mkA "erboso" ; -- status=guess
lin grate_N = mkN "grata" ; -- status=guess
lin grate_V = mkV "grattuggiare" ; -- status=guess, src=wikt
lin grate_V2 = mkV2 (mkV "grattuggiare") ; -- status=guess, src=wikt
lin grateful_A = mkA "grato" ; -- status=guess
lin gratefulness_N = mkN "gratitudine" feminine ; -- status=guess
lin grater_N = mkN "grattugia" ; -- status=guess
lin grating_N = mkN "reticolo_di_diffrazione" ; -- UWN
lin gratingly_Adv = mkAdv "aspramente" | mkAdv "rigorosamente" ; -- UWN
lin gratis_A = mkA "gratis" ; -- status=guess
lin gratis_Adv = mkAdv "gratuitamente" ; -- UWN
lin gratitude_N = mkN "gratitudine" feminine ; -- status=guess
lin gratuity_N = mkN "mancia" | mkN "regalia" ; -- UWN
lin grave_A = mkA "grave" | mkA "serio" ; -- UWN
lin grave_N = mkN "fossa" ; -- status=guess
lin gravedigger_N = mkN "becchino" ; -- status=guess
lin gravel_N = mkN "ghiaia" ; -- status=guess
lin graveness_N = mkN "gravità" feminine ; -- status=guess
lin graver_N = mkN "bulino" ; -- status=guess
lin graverobber_N = mkN "sciacallo" ; -- UWN
lin gravesend_PN = mkPN "Gravesend" ; -- status=guess src=geonames
lin gravestone_N = mkN "lapide" | mkN "pietra_tombale" ; -- UWN
lin graveyard_N = mkN "cimitero" | mkN "camposanto" ; -- status=guess status=guess
lin gravitate_V = mkV "gravitare" ; -- status=guess, src=wikt
lin gravitation_N = mkN "gravitazione" feminine ; -- status=guess
lin gravitational_A = mkA "gravitazionale" ; -- status=guess
lin graviton_N = mkN "gravitone" masculine ; -- status=guess
lin gravity_N = mkN "gravità" feminine ; -- status=guess
lin gravy_N = mkN "sugo" | mkN "salsa" ; -- status=guess status=guess
lin graz_PN = mkPN "Graz" ; -- status=guess src=geonames
lin graze_N = mkN "sbucciatura" ; -- status=guess
lin graze_V = mkV "pascere" | mkV "pascolare" | mkV "brucare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin graze_V2 = mkV2 (mkV "pascere") | mkV2 (mkV "pascolare") | mkV2 (mkV "brucare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin grease_N = mkN "grasso" ; -- status=guess
lin greasepaint_N = mkN "cerone" masculine ; -- status=guess
lin greasiness_N = mkN "grassezza" | mkN "untuosità" | mkN "grassume" masculine ; -- status=guess status=guess status=guess
lin great_A = mkA "magno" | mkA "magna" ; -- status=guess status=guess
lin great_N = mkN "averla formichiera maggiore" ; -- status=guess
lin greatcoat_N = mkN "cappotto" ; -- status=guess
lin greatly_Adv = adjAdv great_A ; -- -- derived
lin greatness_N = mkN "amplitudine" | mkN "enormità" | mkN "estensione" | mkN "grandezza" | mkN "immensità" | mkN "vastità" ; -- UWN
lin greave_N = mkN "schiniere" ; -- UWN
lin grebe_N = mkN "tuffetto" | mkN "svasso" ; -- status=guess status=guess
lin greece_PN = mkPN "Grecia" ; -- status=guess src=geonames
lin greed_N = mkN "avidità" feminine | mkN "ingordigia" ; -- status=guess status=guess
lin greediness_N = mkN "avidità" | mkN "ingluvie" | mkN "insaziabilità" ; -- UWN
lin greedy_A = mkA "ingordo" | mkA "avido" ; -- status=guess status=guess
lin greekFem_N = variants {} ; ---- sense to be split
lin greekMasc_N = variants {} ; ---- sense to be split
lin green_A = L.green_A ;
lin green_N = mkN "fagiolino" ; -- status=guess
lin greenery_N = mkN "vegetazione" | mkN "verde" | mkN "verzura" ; -- UWN
lin greengage_N = mkN "susina_Regina_Claudia" ; -- UWN
lin greengrocer_N = mkN "verduraio" ; -- status=guess
lin greenhorn_N = mkN "pivello" ; -- status=guess
lin greenhouse_N = mkN "serra" ; -- status=guess
lin greenish_A = mkA "verdastro" ; -- status=guess
lin greenness_N = mkN "verde" ; -- UWN
lin greenock_PN = mkPN "Greenock" ; -- status=guess src=geonames
lin greens_N = mkN "verdura" | mkN "erbe" feminine | mkN "cime" feminine | mkN "erbaggi" masculine ; -- status=guess status=guess status=guess status=guess
lin greensward_N = mkN "piota" | mkN "tappeto_erboso" ; -- UWN
lin greenwich_PN = mkPN "Greenwich" ; -- status=guess src=geonames
lin greet_V2 = variants {} ; --
lin greeting_N = mkN "saluto" ; -- status=guess
lin gregarious_A = mkA "gregario" ; -- status=guess
lin gregory_PN = mkPN "Gregory" ; -- status=guess src=geonames
lin grenada_PN = mkPN "Grenada" ; -- status=guess src=geonames
lin grenade_N = mkN "granata" ; -- UWN
lin grey_A = mkA "grigio" | mkA "brizzolato" ; -- status=guess
lin grey_N = mkN "grigio" | mkN "airone cenerino" | mkN "ardea cinerea" ; -- status=guess status=guess
lin grey_V = mkV "ingrigire" ; -- status=guess, src=wikt
lin grey_V2 = mkV2 (mkV "ingrigire") ; -- status=guess, src=wikt
lin greyhound_N = mkN "levriere" | mkN "levriero" | mkN "veltro" ; -- UWN
lin greyish_A = mkA "grigio" ; -- UWN
lin greylag_N = mkN "oca selvatica" ; -- status=guess
lin grid_N = mkN "rete elettrica" ; -- status=guess
lin gridiron_N = mkN "inferriata" ; -- status=guess
lin grief_N = mkN "compianto" | mkN "desolazione" | mkN "dispiacenza" | mkN "dispiacere" | mkN "dispiacimento" | mkN "dolore" | mkN "malgrado" | mkN "rammaricamento" | mkN "scorno" | mkN "spiacenza" ; -- UWN
lin grieve_V = mkV "affliggersi" ; -- status=guess, src=wikt
lin grieve_V2 = mkV2 (mkV "affliggersi") ; -- status=guess, src=wikt
lin grievous_A = mkA "grave" | mkA "serio" ; -- UWN
lin griffin_N = mkN "grifone" masculine ;
lin griffon_N = mkN "avvoltoio" ; -- status=guess
lin grill_N = mkN "bistecchiera" | mkN "graticola" ; -- status=guess status=guess
lin grill_V = mkV "grigliare" ; -- status=guess, src=wikt
lin grill_V2 = mkV2 (mkV "grigliare") ; -- status=guess, src=wikt
lin grim_A = mkA "arcigno" | mkA "fosco" ; -- status=guess status=guess
lin grimace_N = mkN "smorfia" ; -- status=guess
lin grime_N = mkN "incrostazione" feminine | mkN "sporco ostinato" ; -- status=guess status=guess
lin grimethorpe_PN = mkPN "Grimethorpe" ; -- status=guess src=geonames
lin grimness_N = mkN "asprezza" ; -- UWN
lin grimoire_N = mkN "grimorio" ; -- status=guess
lin grimsby_PN = mkPN "Grimsby" ; -- status=guess src=geonames
lin grin_N = mkN "sorriso" ; -- status=guess
lin grin_V = variants {} ; --
lin grind_N = mkN "macinatura" | mkN "macinazione" | mkN "molitura" ; -- UWN
lin grind_V = mkV "macinare" ; -- status=guess, src=wikt
lin grind_V2 = mkV2 (mkV "macinare") ; -- status=guess, src=wikt
lin grinder_N = mkN "molatrice" ; -- UWN
lin grinding_N = mkN "sgretolio" ; -- UWN
lin grindstone_N = mkN "mola" ; -- status=guess
lin grip_N = mkN "presa" ; -- status=guess
lin grip_V2 = variants {} ; --
lin grippe_N = mkN "influenza" ; -- UWN
lin gristle_N = mkN "cartilagine" ; -- UWN
lin grit_N = mkN "grinta" ; -- status=guess
lin gritty_A = mkA "coraggioso" | mkA "spiritoso" ; -- status=guess status=guess
lin groan_N = mkN "gemito" ; -- status=guess
lin groan_V = mkV "gemere" ; -- status=guess, src=wikt
lin groan_V2 = mkV2 (mkV "gemere") ; -- status=guess, src=wikt
lin grocer_N = mkN "droghiere" masculine ; -- status=guess
lin grocery_N = mkN "drogheria" ; -- status=guess
lin grogginess_N = mkN "disorientamento" | mkN "stordimento" ; -- UWN
lin groin_N = mkN "inguine" masculine ; -- status=guess
lin groningen_PN = mkPN "Groninga" ; -- status=guess src=geonames
lin groom_N = mkN "sposo" ; -- status=guess
lin groom_V2 = mkV2 (mkV (mkV "curare") "la propria persona") | mkV2 (mkV (mkV "rendersi") "presentabile") | mkV2 (mkV (mkV "curare") "il proprio aspetto") | mkV2 (mkV "azzimare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin groove_N = mkN "routine" | mkN "tran-tran" masculine ; -- status=guess status=guess
lin grooving_N = mkN "rigatura" ; -- UWN
lin grope_V = mkV "palpare" ; -- status=guess, src=wikt
lin grope_V2 = mkV2 (mkV "palpare") ; -- status=guess, src=wikt
lin groschen_N = mkN "grossone" masculine ; -- status=guess
lin grosgrain_N = mkN "gros-grain" ; -- UWN
lin gross_A = mkA "grasso" ; -- status=guess
lin gross_N = mkN "prodotto interno lordo" ; -- status=guess
lin grossness_N = mkN "asineria" | mkN "banalità" | mkN "grossaggine" | mkN "grossolanità" | mkN "pecoreccio" | mkN "rozzezza" | mkN "rudezza" | mkN "rusticaggine" | mkN "rustichezza" | mkN "sguaiataggine" | mkN "trivialità" | mkN "volgarità" ; -- UWN
lin grosz_N = mkN "grosz" | mkN "grosz_polacco" ; -- UWN
lin grotesque_A = mkA "grottesco" ; -- status=guess
lin grotto_N = mkN "grotta" | mkN "caverna" | mkN "santuario" ; -- status=guess status=guess status=guess
lin grouch_N = mkN "neurastenico" | mkN "nevrastenico" ; -- UWN
lin ground_1_N = variants {} ; --
lin ground_2_N = mkN "cagione" | mkN "causa" | mkN "motivo" | mkN "ragione" ; -- UWN
lin ground_N = mkN "edera terrestre" ; -- status=guess
lin ground_V = mkV "basare" | mkV "fondare" ; -- UWN
lin groundhog_N = mkN "marmotta" ; -- status=guess
lin groundless_A = mkA "infondato" ; -- status=guess
lin groundnut_N = mkN "arachide" | mkN "nocciolina" | mkN "nocciolina_americana" ; -- UWN
lin grounds_N = mkN "cortile" | mkN "giardino" ; -- UWN
lin groundwork_N = mkN "fondamenti" masculine ; -- status=guess
lin group_N = mkN "gruppo" ; -- status=guess
lin group_V = mkV "raggruppare" ; -- status=guess, src=wikt
lin group_V2 = mkV2 (mkV "raggruppare") ; -- status=guess, src=wikt
lin grouper_N = mkN "cernia" ; -- status=guess
lin grouping_N = mkN "gruppo" | mkN "novero" ; -- UWN
lin grouse_N = mkN "urogallo" | mkN "gallo cedrone" | mkN "pernice" feminine ; -- status=guess status=guess status=guess
lin grouse_V = mkV "brontolare" | mkV "lamentarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin grouse_VS = mkVS (mkV "brontolare") | mkVS (mkV "lamentarsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin grout_N = mkN "pietrisco di cava" ; -- status=guess
lin grove_N = mkN "boschetto" | mkN "piantagione" feminine ; -- status=guess status=guess
lin grovel_V = mkV "abbassarsi" | mkV "umiliarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin groveller_N = mkN "leccaculo" | mkN "leccapiedi" | mkN "lecchino" | mkN "leccone" | mkN "reggicoda" | mkN "ruffiano" | mkN "struscione" ; -- UWN
lin grow_V = mkV "diventare" | mkV "apparire" ; -- status=guess, src=wikt status=guess, src=wikt
lin grow_V2 = mkV2 (mkV "diventare") | mkV2 (mkV "apparire") ; -- status=guess, src=wikt status=guess, src=wikt
lin grow_VA = mkVA (mkV "diventare") | mkVA (mkV "apparire") ; -- status=guess, src=wikt status=guess, src=wikt
lin grow_apart_V = advV OP_grow_V OP_apart_Adv ; -- guess-p-verb
lin grow_away_from_V2 = prepV2 (advV OP_grow_V OP_away_Adv ) OP_from_Prep ; -- guess-p-verb
lin grow_back_V = advV OP_grow_V OP_back_Adv ; -- guess-p-verb
lin grow_from_V2 = prepV2 OP_grow_V OP_from_Prep ; -- guess-p-verb
lin grow_into_V2 = prepV2 OP_grow_V OP_into_Prep ; -- guess-p-verb
lin grow_on_V2 = prepV2 OP_grow_V OP_on_Prep ; -- guess-p-verb
lin grow_out_V = advV OP_grow_V OP_out_Adv ; -- guess-p-verb
lin grow_out_of_V2 = prepV2 (advV OP_grow_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin grow_to_V = advV OP_grow_V OP_to_Adv ; -- guess-p-verb
lin grow_together_V = advV OP_grow_V OP_together_Adv ; -- guess-p-verb
lin grow_under_V = advV OP_grow_V OP_under_Adv ; -- guess-p-verb
lin grow_up_V = mkV "crescere" ; -- UWN
lin grow_up_on_V2 = prepV2 (advV OP_grow_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin grow_upon_V2 = prepV2 OP_grow_V OP_upon_Prep ; -- guess-p-verb
lin grower_N = mkN "agronomo" ; -- UWN
lin growing_A = variants {} ; --
lin growl_N = mkN "grugnito" ; -- status=guess
lin growl_V = mkV "ringhiare" ; -- status=guess, src=wikt
lin growl_V2 = mkV2 (mkV "ringhiare") ; -- status=guess, src=wikt
lin growth_N = mkN "crescita" ; -- status=guess
lin groyne_N = mkN "antemurale" | mkN "diga_frangiflutti" | mkN "frangiflutti" | mkN "frangimare" | mkN "frangionde" | mkN "gettata" | mkN "scogliera" ; -- UWN
lin grub_N = mkN "bruco" ; -- status=guess
lin grudge_N = mkN "rancore" | mkN "risentimento" ; -- status=guess status=guess
lin gruffness_N = mkN "asciuttezza" | mkN "bruschezza" | mkN "secchezza" ; -- UWN
lin grumble_N = mkN "boato" | mkN "borbogliamento" | mkN "brontolamento" | mkN "fragore" | mkN "mormorio" | mkN "rimbombo" | mkN "rombo" | mkN "rumoreggiamento" | mkN "rumorio" ; -- UWN
lin grumble_V = mkV "borbottare" | mkV "brontolare" | mkV "ronzare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin grumble_V2 = mkV2 (mkV "borbottare") | mkV2 (mkV "brontolare") | mkV2 (mkV "ronzare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin grumble_VS = mkVS (mkV "borbottare") | mkVS (mkV "brontolare") | mkVS (mkV "ronzare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin grumbler_N = mkN "borbottone" | mkN "brontolone" | mkN "frignone" | mkN "gnaulone" | mkN "mormoratore" | mkN "piagnone" | mkN "piagnucolone" ; -- UWN
lin grunt_N = mkN "grugnito" ; -- status=guess
lin grunt_V = mkV "grugnire" ; -- status=guess, src=wikt
lin grunt_V2 = mkV2 (mkV "grugnire") ; -- status=guess, src=wikt
lin gryphon_N = mkN "grifone" ; -- UWN
lin guadalajara_PN = mkPN "Guadalajara" ; -- status=guess src=geonames
lin guanaco_N = mkN "guanaco" ; -- status=guess
lin guanine_N = mkN "guanina" ; -- status=guess
lin guarantee_N = mkN "garante" ; -- status=guess
lin guarantee_V = mkV "garantire" ; -- status=guess, src=wikt
lin guarantee_V2 = mkV2 (mkV "garantire") ; -- status=guess, src=wikt
lin guarantee_VS = mkVS (mkV "garantire") ; -- status=guess, src=wikt
lin guarantor_N = mkN "avallante" | mkN "fideiussore" | mkN "garante" | mkN "mallevadore" | mkN "mallevatore" ; -- UWN
lin guard_N = mkN "protezione" feminine ; -- status=guess
lin guard_V = mkV "custodire" | mkV "proteggere" ; -- status=guess, src=wikt status=guess, src=wikt
lin guard_V2 = mkV2 (mkV "custodire") | mkV2 (mkV "proteggere") ; -- status=guess, src=wikt status=guess, src=wikt
lin guardian_N = mkN "angelo custode" ; -- status=guess
lin guardianship_N = mkN "tutela" | mkN "curatela" | mkN "tutoria" ; -- status=guess status=guess status=guess
lin guardrail_N = mkN "barriera di sicurezza" ;
lin guatemala_PN = mkPN "Guatemala" ; -- status=guess src=geonames
lin guava_N = mkN "guava" ; -- status=guess
lin guayaquil_PN = mkPN "Guayaquil" ; -- status=guess src=geonames
lin gudgeon_N = mkN "gobione" masculine ; -- status=guess
lin guenon_N = mkN "cercopiteco" ; -- status=guess
lin guerdon_N = mkN "guidardone" | mkN "guiderdone" ; -- UWN
lin guerrilla_N = variants {} ; --
lin guess_N = mkN "congettura" ; -- status=guess
lin guess_V = mkV "indovinare" ; -- status=guess, src=wikt
lin guess_V2 = mkV2 (mkV "indovinare") ; -- status=guess, src=wikt
lin guess_VS = mkVS (mkV "indovinare") ; -- status=guess, src=wikt
lin guesswork_N = mkN "supposizione" feminine ; -- status=guess
lin guest_N = mkN "ospite" masculine ; -- status=guess
lin guffaw_N = mkN "risata fragorosa" ; -- status=guess
lin guidance_N = variants {} ; --
lin guide_N = mkN "guida" ; -- status=guess
lin guide_V2 = variants {} ; --
lin guidebook_N = mkN "guida" ; -- UWN
lin guideline_N = mkN "linea guida" ; -- status=guess
lin guild_N = mkN "gilda" ; -- status=guess
lin guildford_PN = mkPN "Guildford" ; -- status=guess src=geonames
lin guile_N = mkN "astuzia" | mkN "inganno" | mkN "frode" feminine ; -- status=guess status=guess status=guess
lin guillemot_N = mkN "uria" ; -- status=guess
lin guillotine_N = mkN "ghigliottina" ; -- status=guess
lin guillotine_V2 = mkV2 (mkV "ghigliottinare") ; -- status=guess, src=wikt
lin guilt_N = mkN "senso di colpa" ; -- status=guess
lin guiltiness_N = mkN "colpa" | mkN "colpevolezza" | mkN "reità" ; -- UWN
lin guiltless_A = mkA "candido" | mkA "innocente" ; -- UWN
lin guilty_A = mkA "colpevole" ; -- status=guess
lin guinea_N = mkN "faraona" ; -- status=guess
lin guinea_PN = mkPN "Guinea" ; -- status=guess src=geonames
lin guisborough_PN = mkPN "Guisborough" ; -- status=guess src=geonames
lin guise_N = mkN "inganno" | mkN "manto" | mkN "maschera" | mkN "pretesto" ; -- UWN
lin guitar_N = mkN "chitarra" ; -- status=guess
lin guitarist_N = mkN "chitarrista" masculine ; -- status=guess
lin gulf_N = mkN "golfo" ; -- status=guess
lin gull_1_N = mkN "gabbiano" ; -- status=guess
lin gull_2_N = mkN "gabbiano" ; -- status=guess
lin gullet_N = mkN "esofago" ; -- status=guess
lin gullibility_N = mkN "credulità" | mkN "dabbenaggine" | mkN "minchioneria" ; -- UWN
lin gullible_A = mkA "credulone" ; -- status=guess
lin gully_N = mkN "calanco" ; -- status=guess
lin gulping_N = mkN "sorso" ; -- UWN
lin gum_N = mkN "gengiva" ; -- status=guess
lin gumma_N = mkN "gomma" ; -- UWN
lin gumption_N = mkN "spina_dorsale" ; -- UWN
lin gumshoe_N = mkN "caloscia" | mkN "galoche" ; -- UWN
lin gun_N = mkN "fucile" masculine ; -- status=guess
lin gunboat_N = mkN "cannoniera" ; -- status=guess
lin guncotton_N = mkN "fulmicotone" | mkN "nitrocellulosa" ; -- UWN
lin gunfight_N = mkN "scontro_a_fuoco" | mkN "sparatoria" ; -- UWN
lin gunfire_N = mkN "schioppettata" ; -- UWN
lin gunner_N = mkN "artigliere" | mkN "cannoniere" ; -- UWN
lin gunnery_N = mkN "artiglieria" ; -- UWN
lin gunplay_N = mkN "scontro_a_fuoco" | mkN "sparatoria" ; -- UWN
lin gunpowder_N = mkN "polvere da sparo" | mkN "polvere pirica" ; -- status=guess status=guess
lin gunshot_N = mkN "schioppettata" ; -- UWN
lin gunsmith_N = mkN "armaiolo" ; -- UWN
lin gunwale_N = mkN "falchetta" ; -- status=guess
lin gurgle_N = mkN "borboglio" | mkN "gorgoglio" ; -- UWN
lin gush_N = mkN "esplosione" | mkN "impeto" | mkN "rigurgito" | mkN "scatto" | mkN "scoppio" | mkN "sfogo" | mkN "trasporto" ; -- UWN
lin gust_N = mkN "folata" ; -- status=guess
lin gustation_N = mkN "gusto" | mkN "palato" ; -- UWN
lin gustatory_A = mkA "gustativo" | mkA "gustatorio" ; -- UWN
lin gusto_N = mkN "gusto" ; -- UWN
lin gut_N = mkN "epa" | mkN "pancia" masculine ; -- status=guess status=guess
lin guts_N = L.guts_N ; -- comment=CHECKED
lin gutter_N = mkN "grondaia" ; -- status=guess
lin guttersnipe_N = mkN "monello" | mkN "scugnizzo" ; -- UWN
lin guttural_A = mkA "gutturale" ; -- UWN
lin guttural_N = mkN "gutturale" ; -- UWN
lin guy_N = mkN "tipo" ; -- status=guess
lin guyana_PN = mkPN "Guyana" ; -- status=guess src=geonames
lin gym_N = mkN "palestra" ; -- status=guess
lin gymnasium_N = mkN "palestra" ; -- status=guess
lin gymnast_N = mkN "ginnasta" ; -- UWN
lin gymnastics_N = mkN "ginnastica" ; -- UWN
lin gymnosperm_N = mkN "gimnosperma" ; -- status=guess
lin gynaecological_A = mkA "ginecologico" ; -- UWN
lin gynaecologist_N = mkN "ginecologo" | mkN "ginecologa" ; -- status=guess status=guess
lin gynaecology_N = mkN "ginecologia" ; -- UWN
lin gynecological_A = mkA "ginecologico" ; -- status=guess
lin gynecologistFem_N = variants {} ; ---- sense to be split
lin gynecologistMasc_N = mkN "ginecologo" ; -- UWN
lin gynecology_N = mkN "ginecologia" ; -- status=guess
lin gynoecium_N = mkN "gineceo" ; -- status=guess
lin gynophore_N = mkN "ginoforo" ; -- status=guess
lin gypsum_N = mkN "gesso" ; -- status=guess
lin gypsy_N = mkN "zingaro" | mkN "zingara" ; -- status=guess status=guess
lin gyrate_V = mkV "girare" ; -- UWN
lin gyration_N = mkN "roteamento" | mkN "roteazione" ; -- UWN
lin gyrfalcon_N = mkN "girfalco" | mkN "girifalco" ; -- status=guess status=guess
lin gyro_N = mkN "giroscopio" ; -- UWN
lin gyroscope_N = mkN "giroscopio" ; -- status=guess
lin gyroscopic_A = mkA "giroscopico" ; -- UWN
lin gyrostabilizer_N = mkN "girostabilizzatore" ; -- UWN
lin gyrus_N = mkN "circonvoluzione" ; -- UWN
lin ha_Interj = variants {} ; --
lin haarlem_PN = mkPN "Haarlem" ; -- status=guess src=geonames
lin habit_N = mkN "abitudine" feminine ; -- status=guess
lin habitable_A = mkA "abitabile" ; -- status=guess
lin habitat_N = variants {} ; --
lin habitual_A = mkA "consueto" ; -- UWN
lin habitus_N = mkN "complessione" | mkN "conformazione" | mkN "corporatura" | mkN "fisico" | mkN "membratura" ; -- UWN
lin hack_N = mkN "brenna" | mkN "bucefalo" | mkN "ronzino" ; -- UWN
lin hackberry_N = mkN "bagolaro" ; -- status=guess
lin hackney_PN = mkPN "Hackney" ; -- status=guess src=geonames
lin hacksaw_N = mkN "seghetto per metalli" ; -- status=guess
lin hadal_A = mkA "hadal" ; -- status=guess
lin haddington_PN = mkPN "Haddington" ; -- status=guess src=geonames
lin haddock_N = mkN "eglefino" ; -- status=guess
lin hadron_N = mkN "adrone" masculine ; -- status=guess
lin haematite_N = mkN "ematite" ; -- UWN
lin haemophilia_N = mkN "emofilia" ; -- status=guess
lin haemophiliac_N = mkN "emofiliaco" | mkN "emofilico" ; -- UWN
lin haemophilic_A = mkA "emofiliaco" ; -- status=guess
lin haemorrhage_N = mkN "emorragia" ; -- status=guess
lin hafnium_N = mkN "afnio" ; -- status=guess
lin haft_N = mkN "impugnatura" ; -- UWN
lin hag_N = mkN "strega" | mkN "fattucchiera" ; -- status=guess status=guess
lin hagen_PN = mkPN "Hagen" ; -- status=guess src=geonames
lin haggle_V = mkV "contrattare" | mkV (mkV "tirare") "sul prezzo" | mkV "mercanteggiare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin hagiography_N = mkN "agiografía" ; -- status=guess
lin hagiology_N = mkN "agiologia" ; -- UWN
lin hagley_PN = mkPN "Hagley" ; -- status=guess src=geonames
lin hail_N = mkN "grandine" feminine ; -- status=guess
lin hail_V = venire_V | mkV (essere_V) "originario" ; -- status=guess, src=wikt status=guess, src=wikt
lin hail_V2 = mkV2 (venire_V) | mkV2 (mkV (essere_V) "originario") ; -- status=guess, src=wikt status=guess, src=wikt
lin hailsham_PN = mkPN "Fairlight" ; -- status=guess src=geonames
lin hailstone_N = mkN "chicco" | mkN "chicco_di_grandine" ; -- UWN
lin hailstorm_N = mkN "grandinata" ; -- UWN
lin haiphong_PN = mkPN "Haiphong" ; -- status=guess src=geonames
lin hair_N = L.hair_N ;
lin hairbrush_N = mkN "spazzola_per_capelli" ; -- UWN
lin haircloth_N = mkN "crine" | mkN "crino" ; -- UWN
lin haircut_N = mkN "taglio di capelli" | mkN "taglio" ; -- status=guess status=guess
lin hairdo_N = mkN "capigliatura" ; -- status=guess
lin hairdresser_N = mkN "acconciatore" | mkN "acconciatrice" | mkN "parrucchiere" | mkN "pettinatrice" ; -- UWN
lin hairiness_N = mkN "pelosità" | mkN "villosità" ; -- UWN
lin hairline_N = mkN "attaccatura_dei_capelli" ; -- UWN
lin hairnet_N = mkN "rete_per_capelli" | mkN "reticella" | mkN "retina" ; -- UWN
lin hairpiece_N = mkN "parrucca" ; -- status=guess
lin hairpin_N = mkN "forcella" | mkN "forcina" ; -- UWN
lin hairstyle_N = mkN "pettinatura" ; -- status=guess
lin hairstylist_N = mkN "acconciatore" | mkN "acconciatrice" | mkN "parrucchiere" | mkN "pettinatrice" ; -- UWN
lin hairy_A = mkA "peloso" | mkA "pelosa" ; -- status=guess status=guess
lin haiti_PN = mkPN "Haiti" ; -- status=guess src=geonames
lin hajj_N = mkN "hajj" masculine ; -- status=guess
lin hake_N = mkN "nasello" ; -- status=guess
lin halberd_N = mkN "alabarda" ; -- status=guess
lin halberdier_N = mkN "alabardiere" ; -- status=guess
lin halesowen_PN = mkPN "Halesowen" ; -- status=guess src=geonames
lin half_A = mkA "assonnato" | mkA "insonnolito" ; -- status=guess status=guess
lin half_Adv = mkAdv "tiepidamente" ; -- status=guess
lin half_N = mkN "fratello mezzo" ; -- status=guess
lin half_Predet = variants {} ; --
lin half_brother_N = mkN "fratellastro" ; -- UWN
lin half_sister_N = mkN "sorellastra" ; -- UWN
lin halftime_N = mkN "intervallo" ; -- UWN
lin halfway_Adv = mkAdv "a_metà_strada" ; -- UWN
lin halibut_N = mkN "ippoglosso" ; -- status=guess
lin halide_N = mkN "alogenuro" ; -- UWN
lin halifax_PN = mkPN "Halifax" ; -- status=guess src=geonames
lin halite_N = mkN "alite" | mkN "salgemma" masculine ; -- status=guess status=guess
lin halitosis_N = mkN "alitosi" ; -- status=guess
lin hall_N = mkN "corridoio" ; -- status=guess
lin halle_PN = mkPN "Halle" ; -- status=guess src=geonames
lin hallmark_N = mkN "cachet" | mkN "marchio" ; -- UWN
lin hallow_N = mkN "santo" | mkN "santa" ; -- status=guess status=guess
lin hallow_V2 = mkV2 (mkV "santificare") ; -- status=guess, src=wikt
lin hall_stand_N = mkN "attaccapanni" | mkN "portamantello" ; -- UWN
lin hallucination_N = mkN "allucinazione" feminine ; -- status=guess
lin hallucinogen_N = mkN "allucinogeno" ; -- UWN
lin halma_N = mkN "alma" ; -- UWN
lin halo_N = mkN "nimbo" | mkN "alone" masculine ; -- status=guess status=guess
lin halogen_N = mkN "alogeno" ; -- status=guess
lin halophyte_N = mkN "alofita" ; -- status=guess
lin halstead_PN = mkPN "Halstead" ; -- status=guess src=geonames
lin halt_N = variants {} ; --
lin halt_V = mkV "fermare" ; -- status=guess, src=wikt
lin halt_V2 = mkV2 (mkV "fermare") ; -- status=guess, src=wikt
lin halter_N = mkN "capestro" ; -- status=guess
lin halve_V2 = mkV2 (mkV "dimezzare") ; -- status=guess, src=wikt
lin halyard_N = mkN "drizza" ; -- status=guess
lin ham_N = mkN "radioamatore" masculine ; -- status=guess
lin hamadryad_N = mkN "amadriade" feminine ; -- status=guess
lin hamburg_PN = mkPN "Amburgo" ; -- status=guess src=geonames
lin hamburger_N = mkN "hamburger" masculine | mkN "svizzera" ; -- status=guess status=guess
lin hamilton_PN = mkPN "Hamilton" ; -- status=guess src=geonames
lin hamlet_N = mkN "casale" | mkN "borgata" ; -- status=guess status=guess
lin hammer_N = mkN "falce e martello" ; -- status=guess
lin hammer_V = mkV "martellare" ; -- status=guess, src=wikt
lin hammer_V2 = mkV2 (mkV "martellare") ; -- status=guess, src=wikt
lin hammerhead_N = mkN "pesce_martello" ; -- UWN
lin hammersmith_PN = mkPN "Hammersmith" ; -- status=guess src=geonames
lin hamming_N = mkN "gigionismo" ; -- UWN
lin hammock_N = mkN "amaca" ; -- status=guess
lin hampshire_PN = mkPN "Hampshire" ; -- status=guess src=geonames
lin hamster_N = mkN "criceto" ; -- status=guess
lin hand_N = L.hand_N ;
lin hand_V2 = mkV2 (dare_V) | mkV2 (mkV "passare") ; -- status=guess, src=wikt status=guess, src=wikt
lin hand_back_V2 = mkV2 (advV (lin V OP_hand_V2) OP_back_Adv ) ; -- guess-p-verb
lin hand_carry_V2 = variants {} ; -- guess-p-verb
lin hand_down_V2 = prepV2 (lin V OP_hand_V2) OP_down_Prep ; -- guess-p-verb
lin hand_in_V2 = prepV2 (lin V OP_hand_V2) OP_in_Prep ; -- guess-p-verb
lin hand_on_V2 = prepV2 (lin V OP_hand_V2) OP_on_Prep ; -- guess-p-verb
lin hand_out_V2 = prepV2 (lin V OP_hand_V2) OP_out_Prep ; -- guess-p-verb
lin hand_over_V2 = prepV2 (lin V OP_hand_V2) OP_over_Prep ; -- guess-p-verb
lin handbag_N = mkN "borsetta" ; -- status=guess
lin handbook_N = mkN "enchiridio" | mkN "prontuario" | mkN "vademecum" ; -- UWN
lin handful_N = mkN "manciata" | mkN "pugno" ; -- status=guess status=guess
lin handhold_N = mkN "appiglio" ; -- UWN
lin handicap_N = mkN "abbuono" | mkN "handicap" ; -- UWN
lin handicap_V2 = variants {} ; --
lin handicapped_A = variants {} ; --
lin handiness_N = mkN "comodità" | mkN "disponibilità" ; -- UWN
lin handiwork_N = mkN "artigianato" | mkN "lavoro_artigianale" ; -- UWN
lin handkerchief_N = mkN "fazzoletto" ; -- status=guess
lin handle_N = variants {} ; --
lin handle_V = variants {} ; --
lin handle_V2 = variants {} ; --
lin handlebar_N = mkN "manubrio" ; -- status=guess
lin handling_N = mkN "maneggio" | mkN "manipolazione" ; -- UWN
lin handmade_A = mkA "fatto a mano" ; -- status=guess
lin handmaid_N = mkN "ancella" ; -- UWN
lin hand_out_N = mkN "donazione" feminine | mkN "regalia" ; -- status=guess status=guess
lin handrail_N = mkN "appoggiatoio" | mkN "balaustra" | mkN "balaustrata" | mkN "balaustrato" | mkN "bracciolo" | mkN "corrimano" | mkN "mancorrente" | mkN "passamano" | mkN "ringhiera" ; -- UWN
lin hands_N = mkN "mani" ; -- UWN
lin handsaw_N = mkN "sega_a_mano" ; -- UWN
lin handshake_N = mkN "stretta di mano" ; -- status=guess
lin handshaking_N = mkN "stretta_di_mano" ; -- UWN
lin handsome_A = mkA "bello" ; -- status=guess
lin handsomeness_N = mkN "bellezza" | mkN "prestansa" | mkN "prestanza" ; -- UWN
lin handspike_N = mkN "leva" ; -- UWN
lin handstand_N = mkN "verticale" ; -- UWN
lin handwork_N = mkN "artigianato" | mkN "lavoro_artigianale" ; -- UWN
lin handwriting_N = mkN "calligrafia" ; -- status=guess
lin handy_A = mkA "utile" | mkA "pratico" ; -- status=guess status=guess
lin handyman_N = mkN "factotum" | mkN "tutto_fare" | mkN "tuttofare" ; -- UWN
lin hang_N = mkN "deltaplano" ; -- status=guess
lin hang_V = mkV "bloccarsi" ; -- status=guess, src=wikt
lin hang_V2 = mkV2 (mkV "bloccarsi") ; -- status=guess, src=wikt
lin hang_about_V = advV OP_hang_V OP_about_Adv ; -- guess-p-verb
lin hang_around_V = advV OP_hang_V OP_around_Adv ; -- guess-p-verb
lin hang_around_V2 = prepV2 OP_hang_V OP_around_Prep ; -- guess-p-verb
lin hang_back_V = advV OP_hang_V OP_back_Adv ; -- guess-p-verb
lin hang_back_from_V2 = prepV2 (advV OP_hang_V OP_back_Adv ) OP_from_Prep ; -- guess-p-verb
lin hang_in_there_V = variants {} ; -- guess-p-verb
lin hang_it_up_V = variants {} ; -- guess-p-verb
lin hang_on_V = mkV "insistere" | mkV "perdurare" | mkV "perseverare" | mkV "persistere" | mkV "recidivare" ; -- UWN
lin hang_onto_V2 = prepV2 OP_hang_V OP_onto_Prep ; -- guess-p-verb
lin hang_out_V = advV OP_hang_V OP_out_Adv ; -- guess-p-verb
lin hang_out_V2 = prepV2 OP_hang_V OP_out_Prep ; -- guess-p-verb
lin hang_out_for_V2 = prepV2 (advV OP_hang_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin hang_over_V2 = prepV2 OP_hang_V OP_over_Prep ; -- guess-p-verb
lin hang_together_V = advV OP_hang_V OP_together_Adv ; -- guess-p-verb
lin hang_up_V = advV OP_hang_V OP_up_Adv ; -- guess-p-verb
lin hang_up_V2 = prepV2 OP_hang_V OP_up_Prep ; -- guess-p-verb
lin hang_up_on_V2 = prepV2 (advV OP_hang_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin hang_with_V2 = prepV2 OP_hang_V OP_with_Prep ; -- guess-p-verb
lin hangar_N = mkN "hangar" ; -- status=guess
lin hanging_N = mkN "impiccagione" ; -- status=guess
lin hangman_N = mkN "boia" | mkN "carnefice" masculine ; -- status=guess status=guess
lin hangnail_N = mkN "pipita" ; -- status=guess
lin hangover_N = mkN "postumi della sbornia" | mkN "postumi dell'ubriachezza" ; -- status=guess status=guess
lin hankering_N = mkN "desiderio" | mkN "esigenza" ; -- status=guess status=guess
lin hanky_N = mkN "fazzoletto" | mkN "moccichino" ; -- UWN
lin hanoi_PN = mkPN "Hanoi" ; -- status=guess src=geonames
lin hanover_PN = mkPN "Hanover" ; -- status=guess src=geonames
lin hao_N = mkN "hao" | mkN "hao_vietnamita" ; -- UWN
lin haply_Adv = mkAdv "accidentalmente" | mkAdv "casualmente" | mkAdv "fortuitamente" | mkAdv "incidentalmente" | mkAdv "per_caso" ; -- UWN
lin happen_V = accadere_V | succedere_V ; -- status=guess, src=wikt status=guess, src=wikt
lin happen_VV = mkVV (accadere_V) | mkVV (succedere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin happening_N = mkN "accadimento" | mkN "accaduto" | mkN "avvenimento" | mkN "episodio" | mkN "fatto" | mkN "occorrimento" ; -- UWN
lin happiness_N = mkN "felicità" feminine | mkN "allegria" ; -- status=guess status=guess
lin happy_A = mkA "contento" ; -- status=guess
lin harakiri_N = mkN "karakiri" ; -- UWN
lin harangue_N = mkN "concione" | mkN "orazione" ; -- UWN
lin haranguer_N = mkN "arringatore" masculine ; -- status=guess
lin harass_V2 = mkV2 (mkV "molestare") | mkV2 (mkV "vessare") | mkV2 (mkV "tormentare") | mkV2 (mkV "infastidire") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin harassment_N = mkN "molestia" ; -- UWN
lin harbin_PN = mkPN "Harbin" ; -- status=guess src=geonames
lin harbinger_N = mkN "messaggero" | mkN "araldo" ;
lin harbour_N = L.harbour_N ;
lin harbour_V = mkV "albergare" | mkV "covare" | mkV "nutrire" | mkV "ritenere" ; -- UWN
lin hard_1_A = mkA "sodo" | mkA "sode" ; --
lin hard_2_A = mkA "sodo" | mkA "sode" | {-UWN-} mkA "arduo" | mkA "difficile" | mkA "difficoltoso" | mkA "duro" ; -- UWN --
lin hardboard_N = mkN "truciolare" | mkN "truciolato" ; -- UWN
lin hardening_N = mkN "indurimento" | mkN "tempra" ; -- UWN
lin hardly_Adv = adjAdv hard_2_A | {-UWN-} mkAdv "appena" | mkAdv "malapena" | mkAdv "quasi" ; -- UWN -- -- derived
lin hardness_N = mkN "durezza" ; -- status=guess
lin hardship_N = mkN "avversità" feminine | mkN "difficoltà" feminine ; -- status=guess status=guess
lin hardtack_N = mkN "galletta" ; -- UWN
lin hardware_N = mkN "hardware" masculine ; -- status=guess
lin hardy_A = mkA "audace" ; -- UWN
lin hare_N = mkN "lepre" feminine ; -- status=guess
lin harelip_N = mkN "labbro_leporino" ; -- UWN
lin harem_N = mkN "harem" ; -- status=guess
lin harlequin_N = mkN "arlecchino" ; -- status=guess
lin harlequinade_N = mkN "buffonaggine" | mkN "buffonata" | mkN "pagliacciata" ; -- UWN
lin harlot_N = mkN "meretrice" | mkN "puttana" masculine ; -- status=guess status=guess
lin harlow_PN = mkPN "Harlow" ; -- status=guess src=geonames
lin harm_N = mkN "male" masculine | mkN "danno" ; -- status=guess status=guess
lin harm_V2 = mkV2 (mkV "danneggiare") ; -- status=guess, src=wikt
lin harmful_A = mkA "dannoso" ; -- status=guess
lin harmless_A = mkA "innocuo" | mkA "inoffensivo" ; -- UWN
lin harmonic_A = mkA "armonico" ; -- status=guess
lin harmonic_N = mkN "analisi armonica" ; -- status=guess
lin harmonica_N = mkN "armonica" ; -- status=guess
lin harmony_N = mkN "armonia" ; -- status=guess
lin harness_N = mkN "braca" | mkN "imbragatura" | mkN "imbrago" | mkN "imbracatura" ; -- status=guess status=guess status=guess status=guess
lin harp_N = mkN "arpa" ; -- status=guess
lin harpenden_PN = mkPN "Harpenden" ; -- status=guess src=geonames
lin harper_N = mkN "arpeggiatore" | mkN "arpista" ; -- UWN
lin harpist_N = mkN "arpista" masculine ; -- status=guess
lin harpoon_N = mkN "arpione" masculine ; -- status=guess
lin harpoon_V2 = mkV2 (mkV "arpionare") ; -- status=guess, src=wikt
lin harpooner_N = mkN "fiocinatore" | mkN "fiociniere" | mkN "fiocinino" | mkN "ramponiere" ; -- UWN
lin harpsichord_N = mkN "clavicembalo" | mkN "cembalo" ; -- status=guess status=guess
lin harpsichordist_N = mkN "clavicembalista" masculine ; -- status=guess
lin harpy_N = mkN "aquila arpia" ; -- status=guess
lin harrier_N = mkN "albanella" ; -- UWN
lin harrogate_PN = mkPN "Harrogate" ; -- status=guess src=geonames
lin harrow_N = mkN "erpice" feminine ; -- status=guess
lin harrow_PN = mkPN "Harrow" ; -- status=guess src=geonames
lin harsh_A = mkA "grossolano" | mkA "ruvido" | mkA "rude" | mkA "aspro" | mkA "accidentato" | mkA "gibboso" | mkA "discordante" ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin harshness_N = mkN "asprezza" | mkN "crudezza" | mkN "durezza" | mkN "gravità" | mkN "rigidezza" | mkN "rigore" | mkN "severità" ; -- UWN
lin hart_N = mkN "cervo maschio" ; -- status=guess
lin hartebeest_N = mkN "alcelafo" ; -- UWN
lin hartlepool_PN = mkPN "Hartlepool" ; -- status=guess src=geonames
lin hartley_PN = mkPN "Hartley" ; -- status=guess src=geonames
lin harvest_N = mkN "festa del raccolto" ; -- status=guess
lin harvest_V2 = mkV2 (raccogliere_V) | mkV2 (mkV "mietere") ; -- status=guess, src=wikt status=guess, src=wikt
lin harvester_N = mkN "mietitrice" | mkN "fienatrice" ; -- status=guess status=guess
lin harvey_PN = mkPN "Harvey" ; -- status=guess src=geonames
lin harwich_PN = mkPN "Harwich" ; -- status=guess src=geonames
lin hash_N = mkN "cancelletto" ; -- status=guess
lin hash_out_V = mkV "dibattere" | mkV "discutere" | mkV "svolgere" | mkV "vagliare" ; -- UWN
lin hashish_N = mkN "hascisc" ; -- UWN
lin haslemere_PN = mkPN "Haslemere" ; -- status=guess src=geonames
lin haslingden_PN = mkPN "Haslingden" ; -- status=guess src=geonames
lin hasp_N = mkN "fermaglio" ; -- status=guess
lin hassium_N = mkN "hassio" ; -- status=guess
lin hasten_V = mkV "anticipare" ; -- status=guess, src=wikt
lin hasten_V2 = mkV2 (mkV "anticipare") ; -- status=guess, src=wikt
lin hastings_PN = mkPN "Hastings" ; -- status=guess src=geonames
lin hasty_A = mkA "affrettato" | mkA "affrettata" | mkA "frettoloso" | mkA "frettolosa" ; -- status=guess status=guess status=guess status=guess
lin hat_N = L.hat_N ;
lin hatband_N = mkN "nastro" ; -- status=guess
lin hatbox_N = mkN "cappelliera" ; -- status=guess
lin hatch_N = mkN "botola" ; -- status=guess
lin hatch_V = mkV "scoppiare" ; -- status=guess, src=wikt
lin hatch_V2 = mkV2 (mkV "scoppiare") ; -- status=guess, src=wikt
lin hatchback_N = mkN "portellone" masculine ; -- status=guess
lin hatchery_N = mkN "vivaio" ; -- UWN
lin hatchet_N = mkN "accetta" | mkN "ascia" | mkN "manaiuola" ; -- UWN
lin hatching_N = mkN "tratteggio" ; -- UWN
lin hatchway_N = mkN "boccaporto" ; -- status=guess
lin hate_N = mkN "odio" ; -- UWN
lin hate_V2 = L.hate_V2 ;
lin hate_VV = mkVV (mkV "odiare") ; -- status=guess, src=wikt
lin hate_on_V2 = prepV2 (lin V OP_hate_V2) OP_on_Prep ; -- guess-p-verb
lin hateful_A = mkA "odioso" ; -- UWN
lin hatefulness_N = mkN "odiosità" | mkN "esecrabilità" feminine ; -- status=guess status=guess
lin hatfield_PN = mkPN "Hatfield" ; -- status=guess src=geonames
lin hatmaker_N = mkN "cappellaio" | mkN "crestaia" | mkN "modista" ; -- UWN
lin hatpin_N = mkN "spillo" | mkN "spillone" ; -- UWN
lin hatred_N = mkN "odio" | mkN "risentimento" ; -- status=guess status=guess
lin hatter_N = mkN "cappellaio" | mkN "modista" ; -- status=guess status=guess
lin haughty_A = mkA "superbo" | mkA "orgoglioso" | mkA "altero" | mkA "altezzoso" | mkA "arrogante" ; -- status=guess status=guess status=guess status=guess status=guess
lin haul_N = mkN "pescata" | mkN "retata" ; -- UWN
lin haul_V = variants {} ; --
lin haul_V2 = variants {} ; --
lin hauler_N = mkN "autotrasportatore" ; -- UWN
lin haulier_N = mkN "autotrasportatore" ; -- UWN
lin haunch_N = mkN "coscia" ; -- status=guess
lin haunt_N = mkN "ritrovo" | mkN "fantasma" masculine ; -- status=guess status=guess
lin haunt_V2 = mkV2 (mkV "tormentare") ; -- status=guess, src=wikt
lin hautboy_N = mkN "oboe" ; -- UWN
lin havana_PN = mkPN "L'Avana" ; -- status=guess src=geonames
lin have_V = avere_V ;
lin have_V2 = S.have_V2 ;
lin have_VV = mkVV (avere_V) ;
lin have_against_V2 = prepV2 OP_have_V OP_against_Prep ; -- guess-p-verb
lin have_around_V2 = prepV2 OP_have_V OP_around_Prep ; -- guess-p-verb
lin have_down_as_V3 = variants {} ; -- guess-p-verb
lin have_in_V2 = prepV2 OP_have_V OP_in_Prep ; -- guess-p-verb
lin have_it_away_V = variants {} ; -- guess-p-verb
lin have_it_in_for_V2 = variants {} ; -- guess-p-verb
lin have_it_off_V = variants {} ; -- guess-p-verb
lin have_it_out_with_V2 = variants {} ; -- guess-p-verb
lin have_off_V2 = prepV2 OP_have_V OP_off_Prep ; -- guess-p-verb
lin have_on_V = advV OP_have_V OP_on_Adv ; -- guess-p-verb
lin have_on_V2 = prepV2 OP_have_V OP_on_Prep ; -- guess-p-verb
lin have_over_V2 = prepV2 OP_have_V OP_over_Prep ; -- guess-p-verb
lin have_round_V2 = prepV2 OP_have_V OP_round_Prep ; -- guess-p-verb
lin have_up_V2 = prepV2 OP_have_V OP_up_Prep ; -- guess-p-verb
lin haven_N = mkN "porto" ; -- status=guess
lin haverfordwest_PN = mkPN "Haverfordwest" ; -- status=guess src=geonames
lin haverhill_PN = mkPN "Haverhill" ; -- status=guess src=geonames
lin haversack_N = mkN "bisaccia" | mkN "saccapane" | mkN "tascapane" | mkN "zainetto" | mkN "zaino" ; -- UWN
lin havoc_N = mkN "rovina" | mkN "distruzione" feminine | mkN "strage" feminine ; -- status=guess status=guess status=guess
lin hawick_PN = mkPN "Hawick" ; -- status=guess src=geonames
lin hawk_N = mkN "falco" ; -- status=guess
lin hawk_V2 = mkV2 (mkV (mkV "raschiare") "la gola") ; -- status=guess, src=wikt
lin hawker_N = mkN "falconiere" ; -- UWN
lin hawse_N = mkN "cubia" ; -- UWN
lin hawser_N = mkN "canapo" | mkN "cima" ; -- status=guess status=guess
lin hawthorn_N = mkN "biancospino" ; -- status=guess
lin hay_N = mkN "fieno" ; -- status=guess
lin hayfield_N = mkN "prato" ; -- UWN
lin hayfork_N = mkN "forca" ; -- UWN
lin haying_N = mkN "fienagione" ; -- UWN
lin hayloft_N = mkN "fienile" ; -- UWN
lin haymaking_N = mkN "fienagione" ; -- UWN
lin haymow_N = mkN "fienile" ; -- UWN
lin hayrick_N = mkN "barca" | mkN "bica" | mkN "pagliaio" ; -- UWN
lin haystack_N = mkN "pagliaio" ; -- status=guess
lin hazard_N = variants {} ; --
lin haze_N = mkN "smog" | mkN "nebbia" ; -- status=guess status=guess
lin hazel_A = mkA "nocciola" ; -- status=guess
lin hazel_N = mkN "nocciola" ; -- status=guess
lin hazelnut_N = mkN "nocciola" ; -- status=guess
lin haziness_N = mkN "nebbiosità" ; -- UWN
lin he_Pron = optProDrop S.he_Pron ;
lin head_A = variants {} ; --
lin head_N = L.head_N ;
lin head_V = variants {} ; --
lin head_V2 = variants {} ; --
lin head_for_V2 = prepV2 OP_head_V OP_for_Prep ; -- guess-p-verb
lin head_off_V = advV OP_head_V OP_off_Adv ; -- guess-p-verb
lin head_off_V2 = prepV2 OP_head_V OP_off_Prep ; -- guess-p-verb
lin head_out_V = advV OP_head_V OP_out_Adv ; -- guess-p-verb
lin head_up_V2 = prepV2 OP_head_V OP_up_Prep ; -- guess-p-verb
lin headache_N = mkN "mal di testa" ; -- status=guess
lin headband_N = mkN "Cerchietto" ; -- status=guess
lin headboard_N = mkN "testiera del letto" ; -- status=guess
lin headdress_N = mkN "acconciatura" | mkN "copricapo" ; -- UWN
lin header_N = mkN "caduta di testa" | mkN "tuffo" ; -- status=guess status=guess
lin headgear_N = mkN "copricapo" ; -- status=guess
lin head_hunter_N = mkN "cacciare teste" ; -- status=guess
lin heading_N = variants {} ; --
lin headlamp_N = mkN "fanale" | mkN "faro" | mkN "proiettore" ; -- UWN
lin headland_N = mkN "promontorio" ; -- status=guess
lin headlight_N = mkN "fanale" masculine ; -- status=guess
lin headline_N = mkN "intestazione" | mkN "titolo" ; -- UWN
lin headliner_N = mkN "big" | mkN "divo" | mkN "star" | mkN "vedette" ; -- UWN
lin headman_N = mkN "capo_tribù" | mkN "capotribù" ; -- UWN
lin headmaster_N = mkN "preside" ; -- UWN
lin headmistress_N = mkN "direttrice" ; -- UWN
lin headquarters_N = mkN "comando" ; -- UWN
lin headrest_N = mkN "poggiatesta" masculine ; -- status=guess
lin headscarf_N = mkN "fazzoletto" | mkN "foulard" ; -- UWN
lin headstand_N = mkN "verticale" ; -- UWN
lin headstone_N = mkN "lapide" | mkN "pietra_tombale" ; -- UWN
lin headway_N = mkN "abbrivio" ; -- UWN
lin headwind_N = mkN "vento di prua" ; -- status=guess
lin headword_N = mkN "lemma" ; -- UWN
lin heal_V = mkV "guarire" | mkV "sanare" ; -- status=guess, src=wikt status=guess, src=wikt
lin heal_V2 = mkV2 (mkV "guarire") | mkV2 (mkV "sanare") ; -- status=guess, src=wikt status=guess, src=wikt
lin healer_N = mkN "guaritore" masculine ; -- status=guess
lin healing_N = mkN "cicatrizzazione" | mkN "saldamento" ; -- UWN
lin health_N = mkN "salute" | mkN "sanità" feminine ; -- status=guess status=guess
lin healthy_A = mkA "sano" ; -- status=guess
lin heanor_PN = mkPN "Heanor" ; -- status=guess src=geonames
lin heap_N = mkN "pila" | mkN "cumulo" ; -- status=guess status=guess
lin heaps_Adv = mkAdv "moltissimo" ; -- UWN
lin hear_V = sentire_V | udire_V ; -- status=guess, src=wikt status=guess, src=wikt
lin hear_V2 = L.hear_V2 ;
lin hear_V2V = mkV2V (sentire_V) | mkV2V (udire_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin hear_VS = mkVS (sentire_V) | mkVS (udire_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin hear_about_V2 = prepV2 OP_hear_V OP_about_Prep ; -- guess-p-verb
lin hear_from_V2 = prepV2 OP_hear_V OP_from_Prep ; -- guess-p-verb
lin hear_of_V2 = prepV2 OP_hear_V OP_of_Prep ; -- guess-p-verb
lin hear_of_V3 = variants {} ; -- guess-p-verb
lin hear_out_V2 = prepV2 OP_hear_V OP_out_Prep ; -- guess-p-verb
lin hearer_N = mkN "ascoltatore" | mkN "uditore" ; -- UWN
lin hearing_N = mkN "udienza" ; -- status=guess
lin hearsay_N = mkN "sentita persona" ; -- status=guess
lin hearse_N = mkN "carro_funebre" | mkN "carrozzone" ; -- UWN
lin heart_N = L.heart_N ;
lin heartache_N = mkN "crepacuore" | mkN "dolore" | mkN "struggicuore" | mkN "struggimento" ; -- UWN
lin heartbeat_N = mkN "battito cardiaco" | mkN "battito del cuore" | mkN "battito del polso" | mkN "pulsazione" feminine ; -- status=guess status=guess status=guess status=guess
lin heartbreak_N = mkN "crepacuore" masculine ; -- status=guess
lin heartburn_N = mkN "acidità" | mkN "bruciore_di_stomaco" | mkN "pirosi" ; -- UWN
lin heartfelt_A = mkA "sentite" | mkA "sincere" ; -- status=guess status=guess
lin hearth_N = mkN "focolare" masculine ; -- status=guess
lin heartiness_N = mkN "calorosità" ; -- UWN
lin hearts_N = mkN "cuori" masculine ; -- status=guess
lin heartwood_N = mkN "massello" ; -- UWN
lin hearty_A = mkA "di cuore" ; -- status=guess
lin heat_N = mkN "gusto piccante" | mkN "sapore piccante" ; -- status=guess status=guess
lin heat_V = mkV "scaldare" | mkV "eccitare" ; -- status=guess, src=wikt status=guess, src=wikt
lin heat_V2 = mkV2 (mkV "scaldare") | mkV2 (mkV "eccitare") ; -- status=guess, src=wikt status=guess, src=wikt
lin heater_N = mkN "riscaldatore" | mkN "radiatore" masculine ; -- status=guess status=guess
lin heath_N = mkN "baraggia" | mkN "barraggia" | mkN "brughiera" ; -- UWN
lin heathen_A = mkA "pagano" ; -- status=guess
lin heathen_N = mkN "pagano" ; -- status=guess
lin heather_N = mkN "erica" | mkN "brugo" ; -- status=guess status=guess
lin heating_N = mkN "riscaldamento" ; -- status=guess
lin heatstroke_N = mkN "colpo_di_calore" ; -- UWN
lin heatwave_N = mkN "ondata di caldo" ; -- status=guess
lin heave_N = mkN "sollevamento" ; -- status=guess
lin heaven_N = mkN "cielo" | mkN "paradiso" ; -- status=guess status=guess
lin heavenly_A = mkA "divino" ; -- status=guess
lin heaves_N = mkN "bolsaggine" ; -- UWN
lin heavily_Adv = adjAdv heavy_A ; -- -- derived
lin heaviness_N = mkN "faticosità" | mkN "gravosità" | mkN "onerosità" | mkN "pesantezza" ; -- UWN
lin heavy_A = L.heavy_A ;
lin heavy_N = mkN "cattivo" ; -- status=guess
lin heavyweight_N = mkN "colosso" | mkN "titano" ; -- UWN
lin hebdomadal_A = mkA "ebdomadario" | mkA "eddomadario" | mkA "settimanale" ; -- UWN
lin hebetude_N = mkN "ebetudine" | mkN "abbrutimento" ; -- status=guess status=guess
lin hecatomb_N = mkN "ecatombe" ; -- UWN
lin heckle_V2 = mkV2 (mkV (prendere_V) "in giro") ; -- status=guess, src=wikt
lin hectare_N = mkN "ettaro" | mkN "ha" ; -- UWN
lin hectogram_N = mkN "etto" | mkN "ettogrammo" | mkN "hg" ; -- UWN
lin hectoliter_N = mkN "ettolitro" | mkN "hl" ; -- UWN
lin hectometer_N = mkN "ettometro" ; -- UWN
lin hedge_N = mkN "siepe" feminine ; -- status=guess
lin hedgehog_N = mkN "riccio" | mkN "porcospino" ; -- status=guess status=guess
lin hedgerow_N = mkN "siepe" ; -- UWN
lin hedonism_N = mkN "edonismo" ; -- status=guess
lin hedonist_N = mkN "edonista" ; -- status=guess
lin heed_N = mkN "cura" ; -- UWN
lin heedless_A = mkA "sventato" | mkA "disavveduto" ; -- status=guess status=guess
lin heedlessness_N = mkN "incuranza" | mkN "sventatezza" | mkN "sventataggine" | mkN "sbadataggine" | mkN "disavvertenza" | mkN "disavvedutezza" ; -- status=guess status=guess status=guess status=guess status=guess status=guess
lin heel_N = mkN "cantuccio" ; -- status=guess
lin heel_V = mkV "ingavonarsi" ; -- status=guess, src=wikt
lin heel_V2 = mkV2 (mkV "ingavonarsi") ; -- status=guess, src=wikt
lin heft_N = mkN "peso" ; -- status=guess
lin hegemony_N = mkN "egemonia" ; -- UWN
lin hegira_N = mkN "esodo" ; -- UWN
lin heifer_N = mkN "giovenca" ; -- status=guess
lin height_N = mkN "altezza" ; -- status=guess
lin heinousness_N = mkN "atrocità" ; -- UWN
lin heir_N = mkN "erede" masculine ; -- status=guess
lin heiress_N = mkN "ereditiera" ; -- status=guess
lin hejira_N = mkN "esodo" ; -- UWN
lin helensburgh_PN = mkPN "Helensburgh" ; -- status=guess src=geonames
lin heliacal_A = mkA "eliaco" ; -- UWN
lin helicon_N = mkN "bombardone" | mkN "elicone" | mkN "flicorno_basso" ; -- UWN
lin helicopter_N = mkN "elicottero" ; -- status=guess
lin heliocentric_A = mkA "eliocentrico" ; -- status=guess
lin heliograph_N = mkN "eliografo" ; -- UWN
lin heliometer_N = mkN "eliometro" ; -- status=guess
lin heliosphere_N = mkN "eliosfera" ; -- UWN
lin heliotrope_N = mkN "eliotropio" ; -- UWN
lin heliport_N = mkN "eliporto" | mkN "eliscalo" ; -- UWN
lin helium_N = mkN "elio" ; -- status=guess
lin hell_N = mkN "inferno" ; -- status=guess
lin hellcat_N = mkN "arpia" | mkN "megera" | mkN "strega" ; -- UWN
lin hellebore_N = mkN "elleboro" ; -- status=guess
lin hellion_N = mkN "casinaro" | mkN "casinista" | mkN "piantagrane" | mkN "satanasso" ; -- UWN
lin hello_Interj = mkInterj "ciao" ;
lin helm_N = mkN "timone" masculine ; -- status=guess
lin helmet_N = mkN "casco" ; -- status=guess
lin helminth_N = mkN "elminto" ; -- UWN
lin helmsman_N = mkN "timoniere" | mkN "nocchiero" | mkN "nocchiere" masculine ; -- status=guess status=guess status=guess
lin helot_N = mkN "servo_della_gleba" ; -- UWN
lin help_N = mkN "aiuto" | mkN "ausilio" ; -- status=guess status=guess
lin help_V = mkV "aiutare" ; -- status=guess, src=wikt
lin help_V2 = mkV2 (mkV "aiutare") ; -- status=guess, src=wikt
lin help_V2V = mkV2V (mkV "aiutare") ; -- status=guess, src=wikt
lin help_out_V2 = prepV2 OP_help_V OP_out_Prep ; -- guess-p-verb
lin help_to_VV = variants {} ; -- guess-p-verb
lin helperFem_N = variants {} ; ---- sense to be split
lin helperMasc_N = variants {} ; ---- sense to be split
lin helpful_A = mkA "disponibile" ; -- status=guess
lin helpfulness_N = mkN "disponibilità" ; -- UWN
lin helping_N = mkN "porzione" | mkN "razione" ; -- UWN
lin helpless_A = variants {} ; --
lin helplessness_N = mkN "debolezza" ; -- UWN
lin helsinki_PN = mkPN "Helsinki" ; -- status=guess src=geonames
lin helston_PN = mkPN "Helston" ; -- status=guess src=geonames
lin helve_N = mkN "impugnatura" ; -- UWN
lin hem_N = mkN "orlo" ; -- status=guess
lin hemal_A = mkA "emale" ; -- UWN
lin hemangioma_N = mkN "emangioma" | mkN "emoangioma" ; -- UWN
lin hematite_N = mkN "ematite" ; -- UWN
lin hematocrit_N = mkN "ematocrito" ; -- status=guess
lin hematologic_A = mkA "ematologico" ; -- status=guess
lin hematologist_N = mkN "ematologo" ; -- UWN
lin hematology_N = mkN "ematologia" ; -- UWN
lin hematoma_N = mkN "ematoma" masculine ; -- status=guess
lin hematopoiesis_N = mkN "emopoiesi" feminine ; -- status=guess
lin heme_N = mkN "eme" masculine ; -- status=guess
lin hemic_A = mkA "ematico" ; -- UWN
lin hemimorphite_N = mkN "calamina" | mkN "emimorfite" ; -- UWN
lin hemiplegia_N = mkN "emiplegia" ; -- UWN
lin hemisphere_N = mkN "emisfero" ; -- status=guess
lin hemispheric_A = mkA "emisferico" | mkA "semisferico" ; -- UWN
lin hemlock_N = mkN "cicuta" ; -- status=guess
lin hemodialysis_N = mkN "emodialisi" ; -- UWN
lin hemoglobin_N = mkN "emoglobina" ; -- status=guess
lin hemolysis_N = mkN "emolisi" ; -- UWN
lin hemolytic_A = mkA "emolitico" ; -- UWN
lin hemophilia_N = mkN "emofilia" ; -- UWN
lin hemophiliac_N = mkN "emofiliaco" | mkN "emofilico" ; -- UWN
lin hemoptysis_N = mkN "emottisi" feminine ; -- status=guess
lin hemorrhage_V = mkV "sanguinare" ; -- UWN
lin hemorrhagic_A = mkA "emorragico" ; -- UWN
lin hemorrhoid_N = mkN "emorroidi" ; -- UWN
lin hemosiderin_N = mkN "emosiderina" ; -- status=guess
lin hemp_N = mkN "canapa" ; -- status=guess
lin hemsworth_PN = mkPN "Hemsworth" ; -- status=guess src=geonames
lin hen_N = mkN "gallina |" ; -- status=guess
lin hence_Adv = mkAdv "perciò" | mkAdv "dunque" | mkAdv "quindi" ; -- status=guess status=guess status=guess
lin henceforth_Adv = mkAdv "d’ora in poi" | mkAdv "d’ora in avanti" ; -- status=guess status=guess
lin henchman_N = mkN "complice" ; -- UWN
lin hencoop_N = mkN "capponaia" | mkN "pollaio" | mkN "stia" ; -- UWN
lin hendiadys_N = mkN "endiadi" ; -- status=guess
lin henhouse_N = mkN "capponaia" | mkN "pollaio" | mkN "stia" ; -- UWN
lin henna_N = mkN "henné" masculine ; -- status=guess
lin henry_PN = mkPN "Henry" ; -- status=guess src=geonames
lin heparin_N = mkN "eparina" ; -- status=guess
lin hepatic_A = mkA "epatico" ; -- status=guess
lin hepatitis_N = mkN "epatite" feminine ; -- status=guess
lin hepatotoxic_A = mkA "epatotossico" ; -- status=guess
lin heptagon_N = mkN "ettagono" | mkN "eptagono" ; -- status=guess status=guess
lin heptane_N = mkN "eptano" ; -- status=guess
lin herald_N = mkN "araldo" ; -- status=guess
lin herald_V2 = mkV2 (mkV "annunciare") ; -- status=guess, src=wikt
lin heraldry_N = mkN "araldica" ; -- status=guess
lin herb_N = mkN "erba medicinale" ; -- status=guess
lin herbaceous_A = mkA "erbaceo" ; -- status=guess
lin herbalist_N = mkN "erborista" masculine | mkN "fitoterapeuta" masculine ; -- status=guess status=guess
lin herbarium_N = mkN "erbario" ; -- status=guess
lin herbicide_N = mkN "diserbante" | mkN "erbicida" masculine ; -- status=guess status=guess
lin herbivore_N = mkN "erbivoro" ; -- status=guess
lin herd_N = mkN "mandria" | mkN "branco" ; -- status=guess status=guess
lin herd_V = mkV "imbrancare" ; -- status=guess, src=wikt
lin herd_V2 = mkV2 (mkV "imbrancare") ; -- status=guess, src=wikt
lin herder_N = mkN "guardiano" | mkN "guardiano di greggi" | mkN "pecoraio" | mkN "pastore" masculine | mkN "porcaro" | mkN "vaccaro" | mkN "buttero" | mkN "capraio" ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin herdsman_N = mkN "bovaro" ; -- status=guess
lin here7from_Adv = S.here7from_Adv ; -- comment=CHECKED
lin here7to_Adv = S.here7to_Adv ; -- comment=CHECKED
lin here_Adv = mkAdv "qui" | mkAdv "qua" ; -- status=guess status=guess
lin hereafter_N = mkN "a_venire" | mkN "avvenire" | mkN "domani" | mkN "futuro" ; -- UWN
lin hereby_Adv = mkAdv "per questo" | mkAdv "dunque" ; -- status=guess status=guess
lin hereditament_N = mkN "asse" ; -- UWN
lin hereditary_A = mkA "ereditario" ; -- status=guess
lin heredity_N = mkN "eredità" ; -- UWN
lin hereford_PN = mkPN "Hereford" ; -- status=guess src=geonames
lin heretic_N = mkN "eretico" | mkN "miscredente" ; -- UWN
lin heretical_A = mkA "eretico" ; -- status=guess
lin heretofore_Adv = mkAdv "prima d'ora" ; -- status=guess
lin herewith_Adv = mkAdv "con_la_presente" ; -- UWN
lin heritable_A = mkA "ereditabile" ; -- UWN
lin heritage_N = variants {} ; --
lin herm_N = mkN "erma" ; -- status=guess
lin hermaphrodite_N = mkN "androgino" | mkN "ermafrodita" | mkN "ermafrodito" ; -- UWN
lin hermaphroditism_N = mkN "androginia" | mkN "bisessualità" | mkN "ermafrodismo" | mkN "ermafroditismo" | mkN "monoicismo" ; -- UWN
lin hermeneutics_N = mkN "ermeneutico" ; -- status=guess
lin hermit_N = mkN "eremita" masculine | mkN "anacoreta" masculine ; -- status=guess status=guess
lin hermitage_N = mkN "eremitaggio" | mkN "eremo" | mkN "romitaggio" | mkN "romitorio" ; -- UWN
lin herne_PN = mkPN "Herne" ; -- status=guess src=geonames
lin hernia_N = mkN "ernia" ; -- status=guess
lin hero_N = mkN "eroe" masculine | mkN "eroina" | mkN "protagonista" masculine ; -- status=guess status=guess status=guess
lin heroin_N = mkN "eroina" ; -- status=guess
lin heroine_N = mkN "eroina" ; -- UWN
lin heroism_N = mkN "eroismo" ; -- status=guess
lin heron_N = mkN "airone" masculine ; -- status=guess
lin herpes_N = mkN "herpes zoster" | mkN "fuoco di Sant'Antonio" ; -- status=guess status=guess
lin herpetologist_N = mkN "erpetologo" ; -- status=guess
lin herpetology_N = mkN "erpetologia" ; -- status=guess
lin herring_N = mkN "aringa" ; -- status=guess
lin herringbone_N = mkN "spina di pesce" ; -- status=guess
lin hertford_PN = mkPN "Hertford" ; -- status=guess src=geonames
lin hertz_N = mkN "hertz" masculine ; -- status=guess
lin hesitancy_N = mkN "riluttanza" | mkN "tentennare" | mkN "tentennio" ; -- UWN
lin hesitate_V = variants {} ; --
lin hesitate_VV = variants {} ; --
lin hesitatingly_Adv = mkAdv "dubbiosamente" ; -- UWN
lin hesitation_N = mkN "esitazione" feminine ; -- status=guess
lin heterocyclic_A = mkA "eterociclico" ; -- status=guess
lin heterodox_A = mkA "eterodosso" ; -- status=guess
lin heterodoxy_N = mkN "eterodossia" ; -- status=guess
lin heterogeneity_N = mkN "disparatezza" | mkN "eterogeneità" | mkN "ibridismo" ; -- UWN
lin heterogeneous_A = mkA "eterogeneo" ; -- status=guess
lin heterosexual_A = mkA "eterosessuale" ; -- status=guess
lin heterosexual_N = mkN "eterosessuale" masculine ; -- status=guess
lin heterosexuality_N = mkN "eterosessualità" feminine ; -- status=guess
lin heterozygote_N = mkN "eterozigote" masculine ; -- status=guess
lin heuristic_A = mkA "euristico" ; -- status=guess
lin heuristic_N = mkN "euristica" ; -- status=guess
lin hexadecimal_A = mkA "esadecimale" ; -- UWN
lin hexagon_N = mkN "esagono" ; -- status=guess
lin hexagonal_A = mkA "esagonale" ; -- UWN
lin hexahedron_N = mkN "esaedro" ; -- UWN
lin hexameter_N = mkN "esametro" ; -- status=guess
lin hexane_N = mkN "esano" ; -- status=guess
lin hexangular_A = mkA "esagonale" ; -- UWN
lin hexham_PN = mkPN "Hexham" ; -- status=guess src=geonames
lin hexose_N = mkN "esoso" ; -- status=guess
lin hey_Interj = mkInterj "ehi" ; -- status=guess
lin heyday_N = mkN "rigoglio" ; -- UWN
lin heywood_PN = mkPN "Heywood" ; -- status=guess src=geonames
lin hi_Interj = mkInterj "ciao" ; -- status=guess
lin hiatus_N = mkN "iato" ; -- status=guess
lin hibernate_V = mkV "ibernare" ; -- status=guess, src=wikt
lin hibiscus_N = mkN "ibisco" ; -- status=guess
lin hiccough_N = mkN "singulto" | mkN "singulto" | mkN "stranguglione" | mkN "stranguglione" ; -- UWN
lin hiccough_V = mkV "singhiozzare" ; -- UWN
lin hiccup_N = mkN "singhiozzo" ; -- status=guess
lin hiccup_V = mkV "singhiozzare" ; -- status=guess, src=wikt
lin hick_N = mkN "buzzurro" ; -- status=guess
lin hickey_N = mkN "succhiotto" ; -- status=guess
lin hickory_N = mkN "noce americano" ; -- status=guess
lin hidden_A = variants {} ; --
lin hide_N = mkN "pelle" feminine ; -- status=guess
lin hide_V = mkV "nascondersi" ; -- status=guess, src=wikt
lin hide_V2 = mkV2 (mkV "nascondersi") ; -- status=guess, src=wikt
lin hide_away_V = advV OP_hide_V OP_away_Adv ; -- guess-p-verb
lin hide_away_V2 = mkV2 (advV OP_hide_V OP_away_Adv ) ; -- guess-p-verb
lin hide_out_V = advV OP_hide_V OP_out_Adv ; -- guess-p-verb
lin hideaway_N = mkN "eremo" ; -- UWN
lin hideousness_N = mkN "schifezza" ; -- status=guess
lin hide_out_N = mkN "nascondiglio" ; -- status=guess
lin hiding_N = mkN "ammantatura" | mkN "dissimulazione" | mkN "nascondimento" | mkN "occultamento" | mkN "ricoperta" | mkN "ricopertura" | mkN "ricoprimento" | mkN "sottrazione" ; -- UWN
lin hie_V = mkV "affrettarsi" ; -- status=guess, src=wikt
lin hierarch_N = mkN "arciprete" | mkN "prelato" | mkN "presule" ; -- UWN
lin hierarchic_A = mkA "gerarchico" ; -- UWN
lin hierarchical_A = mkA "gerarchico" ; -- status=guess
lin hierarchy_N = mkN "gerarchia" ; -- status=guess
lin high_A = mkA "alto" | mkA "elevato" ;
lin high_Adv = variants {} ; --
lin high_N = mkN "batti cinque" ; -- status=guess
lin highborn_A = mkA "titolato" ; -- UWN
lin highbrow_A = mkA "intellettuale" | mkA "intellettualoide" ; -- status=guess status=guess
lin highbrow_N = mkN "intellettuale" ; -- UWN
lin highchair_N = mkN "seggiolone" ; -- UWN
lin highland_N = mkN "altopiano" ; -- status=guess
lin highland_PN = mkPN "Highland" ; -- status=guess src=geonames
lin highlight_N = mkN "risalto" | mkN "evidenza" | mkN "sottolineato" ; -- status=guess status=guess status=guess
lin highlight_V2 = mkV2 (mkV (mettere_V) "in evidenza") | mkV2 (mkV "enfatizzare") ; -- status=guess, src=wikt status=guess, src=wikt
lin highlighter_N = mkN "evidenziatore" masculine ; -- status=guess
lin highly_Adv = adjAdv high_A ; -- -- derived
lin highway_N = mkN "strada maestra" ; -- status=guess
lin highwayman_N = mkN "grassatore" ; -- UWN
lin hijack_V2 = mkV2 (mkV "dirottare") ; -- status=guess, src=wikt
lin hike_N = mkN "camminata" | mkN "passeggiata" | mkN "escursione" feminine ; -- status=guess status=guess status=guess
lin hike_V = mkV (I.fare_V) "un'escursione" ; -- status=guess, src=wikt
lin hiker_N = mkN "escursionista" ; -- UWN
lin hilarity_N = mkN "ilarità" feminine ; -- status=guess
lin hill_N = L.hill_N ;
lin hill_billy_N = mkN "montanaro" | mkN "buzzurro" ; -- status=guess status=guess
lin hillock_N = mkN "clivo" | mkN "dosso" | mkN "poggio" ; -- UWN
lin hilly_A = mkA "collinoso" ; -- status=guess
lin hilt_N = mkN "impugnatura" | mkN "elsa" ; -- status=guess status=guess
lin hilum_N = mkN "ilo" ; -- UWN
lin hilus_N = mkN "ilo" ; -- UWN
lin hin_N = mkN "hin" masculine ; -- status=guess
lin hinckley_PN = mkPN "Hinckley" ; -- status=guess src=geonames
lin hind_N = mkN "cerva" ; -- status=guess
lin hinder_V2 = mkV2 (mkV "ostacolare") | mkV2 (mkV "ritardare") | mkV2 (mkV "intralciare") | mkV2 (mkV "impedire") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin hindsight_N = mkN "senno_di_poi" ; -- UWN
lin hinge_N = mkN "cerniera" ; -- status=guess
lin hinny_N = mkN "bardotto" ; -- status=guess
lin hint_N = mkN "accenno" | mkN "allusione" feminine | mkN "indizio" | mkN "aiuto" | mkN "dritta" | mkN "suggerimento" ; -- status=guess status=guess status=guess status=guess status=guess status=guess
lin hint_V = variants {} ; --
lin hint_V2 = variants {} ; --
lin hint_VS = variants {} ; --
lin hip_N = mkN "anca" ; -- status=guess
lin hip_flask_N = mkN "fiasca" | mkN "fiaschetta" ; -- UWN
lin hippie_N = mkN "capellone" | mkN "contestatore" | mkN "hippy" ; -- UWN
lin hippodrome_N = mkN "ippodromo" ; -- UWN
lin hippopotamus_N = mkN "ippopotamo" ; -- status=guess
lin hippy_N = mkN "capellone" | mkN "contestatore" | mkN "hippy" ; -- UWN
lin hircine_A = mkA "caprino" | mkA "ircino" ; -- UWN
lin hire_N = variants {} ; --
lin hire_V2 = mkV2 (mkV "impiegare") | mkV2 (mkV "ingaggiare") ; -- status=guess, src=wikt status=guess, src=wikt
lin hire_V2V = mkV2V (mkV "impiegare") | mkV2V (mkV "ingaggiare") ; -- status=guess, src=wikt status=guess, src=wikt
lin hirsute_A = mkA "irsuto" | mkA "peloso" | mkA "velloso" | mkA "villoso" ; -- UWN
lin hiss_N = mkN "sibilo" ; -- status=guess
lin hiss_V = mkV "sibilare" | mkV "fischiare" ; -- status=guess, src=wikt status=guess, src=wikt
lin hiss_V2 = mkV2 (mkV "sibilare") | mkV2 (mkV "fischiare") ; -- status=guess, src=wikt status=guess, src=wikt
lin hiss_VQ = mkVQ (mkV "sibilare") | mkVQ (mkV "fischiare") ; -- status=guess, src=wikt status=guess, src=wikt
lin histamine_N = mkN "istamina" | mkN "istammina" ; -- UWN
lin histogram_N = mkN "istogramma" ; -- UWN
lin histology_N = mkN "istologia" ; -- UWN
lin histone_N = mkN "istone" masculine ; -- status=guess
lin historian_N = mkN "storico" ; -- status=guess
lin historic_A = mkA "storico" | mkA "storica" ; -- status=guess status=guess
lin historical_A = mkA "storico" ; -- status=guess
lin historicize_V2 = mkV2 (mkV "storicizzare") ; -- status=guess, src=wikt
lin historiography_N = mkN "storiografia" ; -- status=guess
lin history_N = mkN "storia" ; -- status=guess
lin hit_N = mkN "colpo" ; -- status=guess
lin hit_V = mkV "colpire" | mkV "picchiare" | mkV "battere" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin hit_V2 = L.hit_V2 ;
lin hit_back_V2 = mkV2 (advV OP_hit_V OP_back_Adv ) ; -- guess-p-verb
lin hit_for_V3 = variants {} ; -- guess-p-verb
lin hit_it_off_V = variants {} ; -- guess-p-verb
lin hit_it_off_with_V2 = variants {} ; -- guess-p-verb
lin hit_on_V2 = prepV2 OP_hit_V OP_on_Prep ; -- guess-p-verb
lin hit_out_at_V2 = prepV2 (advV OP_hit_V OP_out_Adv ) OP_at_Prep ; -- guess-p-verb
lin hit_up_V = advV OP_hit_V OP_up_Adv ; -- guess-p-verb
lin hit_up_V2 = prepV2 OP_hit_V OP_up_Prep ; -- guess-p-verb
lin hit_up_on_V2 = prepV2 (advV OP_hit_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin hit_upon_V2 = prepV2 OP_hit_V OP_upon_Prep ; -- guess-p-verb
lin hit_with_V3 = variants {} ; -- guess-p-verb
lin hitch_N = mkN "inconveniente" ; -- status=guess
lin hitchhike_V = mkV (I.fare_V) "l'autostop" ; -- status=guess, src=wikt
lin hitchhiker_N = mkN "autostoppista" masculine ; -- status=guess
lin hitchin_PN = mkPN "Hitchin" ; -- status=guess src=geonames
lin hither_Adv = mkAdv "qui" | mkAdv "qua" ; -- status=guess status=guess
lin hitherto_Adv = mkAdv "fin qui" | mkAdv "fino a qui" | mkAdv "fino ad ora" | mkAdv "fino allora" | mkAdv "finora" ; -- status=guess status=guess status=guess status=guess status=guess
lin hoar_A = mkA "grigio" ; -- UWN
lin hoard_N = mkN "scorta" | mkN "gruzzolo" ; -- status=guess status=guess
lin hoard_V = mkV "accumulare" ; -- status=guess, src=wikt
lin hoard_V2 = mkV2 (mkV "accumulare") ; -- status=guess, src=wikt
lin hoarder_N = mkN "incettatore" | mkN "accaparratore" | mkN "accaparratrice" feminine ; -- status=guess status=guess status=guess
lin hoarding_N = mkN "cartellone" | mkN "manifesto" | mkN "reclame" | mkN "tabellone" | mkN "tabellone_pubblicitario" ; -- UWN
lin hoarfrost_N = mkN "brina" | mkN "calaverna" ; -- status=guess status=guess
lin hoarse_A = mkA "rauco" ; -- status=guess
lin hoax_N = mkN "frode" feminine ; -- status=guess
lin hoax_V2 = mkV2 (mkV "frodare") ; -- status=guess, src=wikt
lin hoaxer_N = mkN "burlone" ; -- UWN
lin hobbit_N = mkN "hobbit" masculine ; -- status=guess
lin hobby_N = mkN "falco" | mkN "falcone" masculine ; -- status=guess status=guess
lin hobbyhorse_N = mkN "cavallo_a_dondolo" ; -- UWN
lin hobnail_N = mkN "bulletta" | mkN "chiodo" ; -- UWN
lin hobo_N = mkN "senzatetto" ; -- status=guess
lin hock_N = mkN "garetto" | mkN "garretto" ; -- UWN
lin hockey_N = mkN "hockey" ; -- status=guess
lin hockley_PN = mkPN "Hockley" ; -- status=guess src=geonames
lin hod_N = mkN "sparviere" masculine ; -- status=guess
lin hoddesdon_PN = mkPN "Hoddesdon" ; -- status=guess src=geonames
lin hodgepodge_N = mkN "pot-pourri" ; -- status=guess
lin hoe_N = mkN "zappa" ; -- status=guess
lin hoe_V = mkV "zappare" ; -- status=guess, src=wikt
lin hoe_V2 = mkV2 (mkV "zappare") ; -- status=guess, src=wikt
lin hoist_V2 = mkV2 (mkV "elevare") | mkV2 (mkV "alzare") ; -- status=guess, src=wikt status=guess, src=wikt
lin hold_N = mkN "autoreggenti" feminine ; -- status=guess
lin hold_V = tenere_V ;
lin hold_V2 = L.hold_V2 ;
lin hold_VS = mkVS (tenere_V) ;
lin hold_against_V3 = variants {} ; -- guess-p-verb
lin hold_back_V = advV OP_hold_V OP_back_Adv ; -- guess-p-verb
lin hold_back_V2 = mkV2 (advV OP_hold_V OP_back_Adv ) ; -- guess-p-verb
lin hold_back_from_V2 = prepV2 (advV OP_hold_V OP_back_Adv ) OP_from_Prep ; -- guess-p-verb
lin hold_down_V2 = prepV2 OP_hold_V OP_down_Prep ; -- guess-p-verb
lin hold_forth_V = advV OP_hold_V OP_forth_Adv ; -- guess-p-verb
lin hold_off_V = advV OP_hold_V OP_off_Adv ; -- guess-p-verb
lin hold_off_V2 = prepV2 OP_hold_V OP_off_Prep ; -- guess-p-verb
lin hold_off_on_V2 = prepV2 (advV OP_hold_V OP_off_Adv ) OP_on_Prep ; -- guess-p-verb
lin hold_on_V = mkV "insistere" | mkV "perdurare" | mkV "perseverare" | mkV "persistere" | mkV "recidivare" ; -- UWN
lin hold_on_to_V2 = prepV2 (advV OP_hold_V OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin hold_onto_V = variants {} ; -- guess-p-verb
lin hold_onto_V2 = prepV2 OP_hold_V OP_onto_Prep ; -- guess-p-verb
lin hold_out_V = mkV "allungare" | mkV "protendere" | mkV "tendere" ; -- UWN
lin hold_out_V2 = prepV2 OP_hold_V OP_out_Prep ; -- guess-p-verb
lin hold_out_against_V2 = prepV2 (advV OP_hold_V OP_out_Adv ) OP_against_Prep ; -- guess-p-verb
lin hold_out_for_V2 = prepV2 (advV OP_hold_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin hold_out_on_V2 = prepV2 (advV OP_hold_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin hold_over_V2 = prepV2 OP_hold_V OP_over_Prep ; -- guess-p-verb
lin hold_together_V = advV OP_hold_V OP_together_Adv ; -- guess-p-verb
lin hold_up_V2 = prepV2 OP_hold_V OP_up_Prep ; -- guess-p-verb
lin hold_with_V2 = prepV2 OP_hold_V OP_with_Prep ; -- guess-p-verb
lin holder_N = variants {} ; --
lin holding_N = variants {} ; --
lin hole_N = mkN "perforatrice" ; -- status=guess
lin holiday_N = mkN "giorno festivo" ; -- status=guess
lin holiness_N = mkN "santità" feminine ; -- status=guess
lin holism_N = mkN "olismo" ; -- status=guess
lin holistic_A = mkA "olistico" ; -- status=guess
lin holland_PN = mkPN "Holland" ; -- status=guess src=geonames
lin holler_V = mkV "sbraitare" | mkV "urlare" ; -- status=guess, src=wikt status=guess, src=wikt
lin holler_V2 = mkV2 (mkV "sbraitare") | mkV2 (mkV "urlare") ; -- status=guess, src=wikt status=guess, src=wikt
lin hollow_A = mkA "incavo" ; -- status=guess
lin hollow_N = mkN "cavità" feminine ; -- status=guess
lin hollowness_N = mkN "cavernosità" ; -- status=guess
lin holly_N = mkN "agrifoglio" ; -- status=guess
lin hollyhock_N = mkN "malvarosa" | mkN "malvone" masculine ; -- status=guess status=guess
lin hollywood_PN = mkPN "Hollywood" ; -- status=guess src=geonames
lin holmfirth_PN = mkPN "Holmfirth" ; -- status=guess src=geonames
lin holmium_N = mkN "olmio" ; -- status=guess
lin hologram_N = mkN "ologramma" ; -- UWN
lin holograph_N = mkN "ologramma" ; -- UWN
lin holography_N = mkN "olografia" ; -- status=guess
lin holophytic_A = mkA "olofitico" ; -- UWN
lin holy_A = mkA "sacro" ; -- status=guess
lin holy_N = mkN "santino" | mkN "immaginetta" ; -- status=guess status=guess
lin holyhead_PN = mkPN "Holyhead" ; -- status=guess src=geonames
lin homage_N = mkN "omaggio" ; -- UWN
lin home_Adv = mkAdv "a casa" ; -- status=guess
lin home_N = mkN "home theater" | mkN "home theatre" | mkN "home cinema" ; -- status=guess status=guess status=guess
lin homecoming_N = mkN "ritorno" ; -- UWN
lin home_grown_A = mkA "locale" ; -- UWN
lin homeland_N = mkN "patria" | mkN "suolo natio" | mkN "paese" masculine ; -- status=guess status=guess status=guess
lin homeless_A = variants {} ; --
lin home_made_A = mkA "fatto in casa" ; -- status=guess
lin homeopath_N = mkN "omeopata" masculine ; -- status=guess
lin homeopathic_A = mkA "omeopatico" ; -- UWN
lin homeopathy_N = mkN "omeopatia" ; -- status=guess
lin homeostasis_N = mkN "omeostasi" feminine ; -- status=guess
lin homesickness_N = mkN "nostalgia" ; -- status=guess
lin homestead_N = mkN "luogo natio" | mkN "casolare" masculine ; -- status=guess status=guess
lin hometown_N = mkN "città di origine" ; -- status=guess
lin homework_N = mkN "compito" ; -- status=guess
lin homicide_N = mkN "omicida" ;
lin homily_N = mkN "omelia" | mkN "omilia" ; -- UWN
lin hominid_N = mkN "ominide" ; -- UWN
lin homo_N = mkN "essere_umano" | mkN "uomo" ; -- UWN
lin homocercal_A = mkA "omocerco" ; -- status=guess
lin homocyclic_A = mkA "omociclico" ; -- status=guess
lin homoeopath_N = mkN "omeopata" | mkN "omeopatico" ; -- UWN
lin homoeopathy_N = mkN "omeopatia" ; -- UWN
lin homogeneity_N = mkN "omogeneità" feminine ; -- status=guess
lin homogeneous_A = mkA "omogeneo" ; -- status=guess
lin homograph_N = mkN "omografo" ; -- UWN
lin homology_N = mkN "omologia" ; -- UWN
lin homomorphism_N = mkN "omomorfismo" ; -- status=guess
lin homonym_N = mkN "omonimo" ; -- UWN
lin homonymy_N = mkN "omonimia" ; -- status=guess
lin homophobia_N = mkN "omofobia" ; -- status=guess
lin homophone_N = mkN "omofono" ; -- status=guess
lin homophonous_A = mkA "omofono" ; -- UWN
lin homosexual_A = mkA "omosessuale" ; -- status=guess
lin homosexual_N = mkN "omosessuale" masculine ; -- status=guess
lin homosexuality_N = mkN "omosessualità" feminine ; -- status=guess
lin homozygote_N = mkN "omozigote" masculine ; -- status=guess
lin honduras_PN = mkPN "Honduras" ; -- status=guess src=geonames
lin hone_V2 = mkV2 (mkV "affinare") ; -- status=guess, src=wikt
lin honest_A = mkA "onesto" | mkA "onesta" ; -- status=guess status=guess
lin honesty_N = mkN "onestà" | mkN "lealtà" feminine | mkN "correttezza" ; -- status=guess status=guess status=guess
lin honey_N = mkN "tasso del miele" ; -- status=guess
lin honeymoon_N = mkN "luna di miele" ; -- status=guess
lin honeysuckle_N = mkN "caprifoglio" ; -- status=guess
lin hong_kong_PN = mkPN "Hong Kong" ; -- status=guess src=geonames
lin honiton_PN = mkPN "Honiton" ; -- status=guess src=geonames
lin honk_V = mkV "ributtare" | mkV "rigettare" | mkV "rimettere" | mkV "vomitare" ; -- UWN
lin honkytonk_N = mkN "bettola" ; -- UWN
lin honorarium_N = mkN "ricompensa" ; -- UWN
lin honour_N = mkN "onore" masculine ; -- status=guess
lin honour_V2 = mkV2 (mkV "onorare") ; -- status=guess, src=wikt
lin honourable_A = variants {} ; --
lin hoo_PN = mkPN "Hoo" ; -- status=guess src=geonames
lin hood_N = mkN "cappa" ; -- status=guess
lin hood_V2 = mkV2 (mkV "incappucciare") | mkV2 (mkV "nascondere") ; -- status=guess, src=wikt status=guess, src=wikt
lin hoof_N = mkN "zampa" ; -- status=guess
lin hoofer_N = mkN "ballerino" | mkN "ballerina" ; -- status=guess status=guess
lin hook_N = mkN "amo" ; -- status=guess
lin hook_V = mkV "agganciare" ; -- status=guess, src=wikt
lin hook_V2 = mkV2 (mkV "agganciare") ; -- status=guess, src=wikt
lin hookah_N = mkN "narghilè" masculine ; -- status=guess
lin hooker_N = mkN "puttana" masculine ; -- status=guess
lin hooligan_N = mkN "teppista" masculine | mkN "vandalo" ; -- status=guess status=guess
lin hooliganism_N = mkN "teppismo" | mkN "vandalismo" ; -- UWN
lin hoop_N = mkN "canestro" ; -- UWN
lin hoopoe_N = mkN "upupa" ; -- status=guess
lin hoopskirt_N = mkN "crinolina" | mkN "faldiglia" ; -- UWN
lin hooter_N = mkN "clacson" masculine ; -- status=guess
lin hop_N = mkN "saltello" ; -- status=guess
lin hope_N = mkN "speranza" ; -- status=guess
lin hope_PN = mkPN "Hope" ; -- status=guess src=geonames
lin hope_V = mkV "sperare" ; -- status=guess, src=wikt
lin hope_VS = L.hope_VS ;
lin hope_VV = mkVV (mkV "sperare") ; -- status=guess, src=wikt
lin hopeful_A = variants {} ;
lin hopeless_A = mkA "disperato" ; -- UWN
lin hopper_N = mkN "tramoggia" ; -- status=guess
lin hopscotch_N = mkN "campana" ; -- UWN
lin horace_PN = mkPN "Horace" ; -- status=guess src=geonames
lin horde_N = mkN "caterva" | mkN "esercito" | mkN "falange" | mkN "legione" | mkN "orda" ; -- UWN
lin horehound_N = mkN "marrubio" | mkN "marrobio" ; -- status=guess status=guess
lin horizon_N = mkN "orizzonte" ; -- status=guess
lin horizontal_A = mkA "orizzontale" ; -- status=guess
lin horizontality_N = mkN "orizzontalità" ; -- UWN
lin horley_PN = mkPN "Horley" ; -- status=guess src=geonames
lin hormonal_A = mkA "ormonale" | mkA "ormonico" ; -- UWN
lin hormone_N = mkN "ormone" masculine ; -- status=guess
lin horn_N = L.horn_N ;
lin hornbeam_N = mkN "carpino" ; -- status=guess
lin hornbill_N = mkN "bucero" ; -- status=guess
lin hornblende_N = mkN "orneblenda" ; -- UWN
lin horned_A = mkA "cornuto" ; -- status=guess
lin hornet_N = mkN "calabrone" masculine ; -- status=guess
lin hornsea_PN = mkPN "Hornsea" ; -- status=guess src=geonames
lin horny_A = mkA "corneo" ; -- status=guess
lin horology_N = mkN "orologia" ; -- status=guess
lin horoscope_N = mkN "oroscopo" ; -- status=guess
lin horoscopy_N = mkN "oroscopia" ; -- status=guess
lin horrible_A = mkA "orribile" | mkA "terribile" ; -- status=guess status=guess
lin horror_N = mkN "ignominia" | mkN "obbrobrio" | mkN "orrore" ; -- UWN
lin horse_N = L.horse_N ;
lin horsebox_N = mkN "box" masculine ; -- status=guess
lin horsecar_N = mkN "omnibus" ; -- UWN
lin horsefly_N = mkN "tafano" ; -- status=guess
lin horsehair_N = mkN "crine" masculine ; -- status=guess
lin horsemanship_N = mkN "equitazione" ; -- UWN
lin horsepower_N = mkN "cavallo vapore" ; -- status=guess
lin horseradish_N = mkN "rafano" | mkN "barbaforte" | mkN "cren" | mkN "rusticano" ; -- status=guess status=guess status=guess status=guess
lin horseshoe_N = mkN "ferro di cavallo" ; -- status=guess
lin horsetail_N = mkN "coda di cavallo" ; -- status=guess
lin horsewoman_N = mkN "amazzone" feminine ; -- status=guess
lin horsham_PN = mkPN "Horsham" ; -- status=guess src=geonames
lin horsley_PN = mkPN "Horsley" ; -- status=guess src=geonames
lin horticultural_A = mkA "orticolo" ; -- UWN
lin horticulture_N = mkN "orticoltura" ; -- status=guess
lin horticulturist_N = mkN "orticoltore" | mkN "orticultore" ; -- UWN
lin horwich_PN = mkPN "Horwich" ; -- status=guess src=geonames
lin hosanna_N = mkN "osanna" ; -- UWN
lin hose_N = mkN "manichetta" ; -- status=guess
lin hosepipe_N = mkN "budello" | mkN "manichetta" ; -- UWN
lin hosier_N = mkN "calzettaio" ; -- UWN
lin hospice_N = mkN "ospizio" | mkN "casa di cura" ; -- status=guess status=guess
lin hospital_N = mkN "ospedale" masculine ;
lin hospitality_N = mkN "ospitalità" feminine ; -- status=guess
lin host_N = mkN "host" masculine ; -- status=guess
lin host_V2 = mkV2 (mkV "ospitare") ; -- status=guess, src=wikt
lin hostage_N = mkN "ostaggio" ; -- status=guess
lin hostel_N = mkN "ostello" ; -- status=guess
lin hostelry_N = mkN "locanda" ; -- UWN
lin hostile_A = variants {} ; --
lin hostilities_N = mkN "belligeranza" ; -- UWN
lin hostility_N = mkN "ostilità" feminine ; -- status=guess
lin hot_A = L.hot_A ;
lin hotbed_N = mkN "letto_caldo" ; -- UWN
lin hotchpotch_N = mkN "spezzatino" ; -- UWN
lin hotdog_N = mkN "hot_dog" ; -- UWN
lin hotel_N = mkN "albergo" | mkN "hotel" masculine ; -- status=guess status=guess
lin hotelier_N = mkN "albergatore" ; -- UWN
lin hothouse_N = mkN "serra" ; -- UWN
lin hotplate_N = mkN "fornello" | mkN "piastra" ; -- status=guess status=guess
lin houghton_PN = mkPN "Houghton" ; -- status=guess src=geonames
lin hound_N = mkN "bracco" ; -- status=guess
lin hounslow_PN = mkPN "Hounslow" ; -- status=guess src=geonames
lin hour_N = mkN "ora" ; -- status=guess
lin hourglass_N = mkN "clessidra" ; -- status=guess
lin hourly_A = mkA "orario" ; -- UWN
lin hourly_Adv = adjAdv hourly_A ; -- derived
lin house_N = L.house_N ;
lin house_V2 = mkV2 (mkV "alloggiare") ; -- status=guess, src=wikt
lin houseboat_N = mkN "casa_galleggiante" | mkN "house_boat" ; -- UWN
lin housebreaking_N = mkN "scasso" ; -- UWN
lin household_N = mkN "elettrodomestico" ; -- status=guess
lin housekeeper_N = mkN "governante" ; -- status=guess
lin housemaid_N = mkN "cameriera" | mkN "domestica" | mkN "donna" | mkN "donna_di_servizio" | mkN "fantesca" ; -- UWN
lin houseplant_N = mkN "pianta da appartamento" ; -- status=guess
lin housewife_N = mkN "massaia" | mkN "donna di casa" | mkN "padrona di casa" | mkN "casalinga" ; -- status=guess status=guess status=guess status=guess
lin housing_N = mkN "immobili" masculine ; -- status=guess
lin houston_PN = mkPN "Houston" ; -- status=guess src=geonames
lin hove_PN = mkPN "Hove" ; -- status=guess src=geonames
lin hovel_N = mkN "riparo" | mkN "ricovero" | mkN "tettoia" ; -- status=guess status=guess status=guess
lin hover_V = mkV "librarsi" | mkV "volteggiare" ; -- status=guess, src=wikt status=guess, src=wikt
lin hovercraft_N = mkN "aeroscivolante" masculine ; -- status=guess
lin how8many_IDet = S.how8many_IDet ; -- comment=CHECKED
lin how8much_IAdv = S.how8much_IAdv ; -- comment=CHECKED
lin how_IAdv = S.how_IAdv ; -- comment=CHECKED
lin howard_PN = mkPN "Howard" ; -- status=guess src=geonames
lin however_Adv = mkAdv "però" | mkAdv "nonostante" ; -- status=guess status=guess
lin howitzer_N = mkN "obice" feminine ; -- status=guess
lin howl_N = mkN "ululato" ; -- status=guess
lin howl_V = mkV "ululare" ; -- status=guess, src=wikt
lin howl_V2 = mkV2 (mkV "ululare") ; -- status=guess, src=wikt
lin howler_N = mkN "urlatore" masculine ; -- status=guess
lin hoyden_N = mkN "maschiaccio" ; -- UWN
lin hoylake_PN = mkPN "Hoylake" ; -- status=guess src=geonames
lin hub_N = mkN "incrocio" ; -- status=guess
lin hubbub_N = mkN "brusio" ; -- status=guess
lin hubcap_N = mkN "coprimozzo" ; -- UWN
lin hubris_N = mkN "insolenza" | mkN "arroganza" ; -- status=guess status=guess
lin hucknall_PN = mkPN "Hucknall" ; -- status=guess src=geonames
lin huddersfield_PN = mkPN "Huddersfield" ; -- status=guess src=geonames
lin hue_N = mkN "colorito" ; -- status=guess
lin huffish_A = mkA "imbronciato" ; -- UWN
lin hug_N = mkN "abbraccio" ; -- status=guess
lin hug_V2 = mkV2 (mkV "abbracciare") ; -- status=guess, src=wikt
lin huge_A = mkA "enorme" ; -- status=guess
lin hugely_Adv = adjAdv huge_A ; -- derived -- derived
lin hulk_N = mkN "carcassa" ; -- UWN
lin hull_N = mkN "scafo" ; -- UWN
lin hum_N = mkN "ronzio" ; -- status=guess
lin hum_V = mkV "canticchiare" | mkV "canterellare" ; -- status=guess, src=wikt status=guess, src=wikt
lin hum_V2 = mkV2 (mkV "canticchiare") | mkV2 (mkV "canterellare") ; -- status=guess, src=wikt status=guess, src=wikt
lin human_A = mkA "umano" ; -- status=guess
lin human_N = mkN "umano" ;
lin humanism_N = mkN "umanesimo" ; -- status=guess
lin humanitarian_N = mkN "umanista" ; -- UWN
lin humanitarianism_N = mkN "umanitarismo" ; -- UWN
lin humanity_N = mkN "umanità" feminine ; -- status=guess
lin humanization_N = mkN "umanizzazione" ; -- UWN
lin humankind_N = mkN "genere_umano" | mkN "mondo" | mkN "terra" | mkN "umanità" | mkN "uomo" ; -- UWN
lin humberston_PN = mkPN "Humberston" ; -- status=guess src=geonames
lin humble_A = mkA "umile" | mkA "modesto" | mkA "terra terra" ; -- status=guess status=guess status=guess
lin humble_V2 = mkV2 (mkV "sminuire") ; -- status=guess, src=wikt
lin humbug_N = mkN "imbroglio" ; -- status=guess
lin humerus_N = mkN "omero" ; -- status=guess
lin humidity_N = mkN "umidità" ; -- UWN
lin humiliate_V2 = mkV2 (mkV "umiliare") ; -- status=guess, src=wikt
lin humility_N = mkN "umiltà" feminine ; -- status=guess
lin hummer_N = mkN "fastball" | mkN "palla_veloce" ; -- UWN
lin hummingbird_N = mkN "colibri" masculine ; -- status=guess
lin hummock_N = mkN "clivo" | mkN "dosso" | mkN "poggio" ; -- UWN
lin humongous_A = mkA "gigantesco" | mkA "enorme" | mkA "disumano" | mkA "mastodontico" ; -- status=guess status=guess status=guess status=guess
lin humoral_A = mkA "umorale" ; -- UWN
lin humorist_N = mkN "umorista" masculine ; -- status=guess
lin humorous_A = mkA "umoristico" | mkA "divertente" | mkA "esilarante" ; -- status=guess status=guess status=guess
lin humour_N = mkN "umore" masculine ; -- status=guess
lin humour_V2 = mkV2 (mkV "accontentare") | mkV2 (mkV "assecondare") ; -- status=guess, src=wikt status=guess, src=wikt
lin humourist_N = mkN "umorista" ; -- UWN
lin hump_N = mkN "paturnie" feminine ; -- status=guess
lin humpback_N = mkN "megattera" ; -- status=guess
lin hunch_N = mkN "intuizione" feminine | mkN "presentimento" ; -- status=guess status=guess
lin hunchback_N = mkN "gobbo" ; -- UWN
lin hungary_PN = mkPN "Ungheria" ; -- status=guess src=geonames
lin hunger_N = mkN "fame" feminine ; -- status=guess
lin hunger_V = mkV (avere_V) "fame" ; -- status=guess, src=wikt
lin hungry_A = mkA "affamato" ; -- status=guess
lin hunk_N = mkN "pezzo" | mkN "tozzo" ; -- status=guess status=guess
lin hunt_N = mkN "caccia" masculine | mkN "spedizione di caccia" ; -- status=guess status=guess
lin hunt_V = mkV "cacciare" ; -- status=guess, src=wikt
lin hunt_V2 = L.hunt_V2 ;
lin hunter_N = mkN "cane da caccia" ; -- status=guess
lin hunting_N = mkN "caccia" masculine ; -- status=guess
lin huntingdon_PN = mkPN "Huntingdon" ; -- status=guess src=geonames
lin huntress_N = mkN "cacciatrice" feminine ; -- status=guess
lin huntsman_N = mkN "cacciatore" ; -- UWN
lin hurdle_N = mkN "ostacolo" ; -- status=guess
lin hurdler_N = mkN "ostacolista" ; -- UWN
lin hurdy_gurdy_N = mkN "organetto" ; -- UWN
lin hurl_V2 = mkV2 (mkV "lanciare") | mkV2 (mkV "tirare") ; -- status=guess, src=wikt status=guess, src=wikt
lin hurling_N = mkN "hurling" ; -- UWN
lin hurrah_N = mkN "urrà" | mkN "evviva" masculine ; -- status=guess status=guess
lin hurricane_N = mkN "uragano" ; -- status=guess
lin hurried_A = mkA "affrettato" | mkA "frettoloso" | mkA "precipitoso" ; -- UWN
lin hurry_N = mkN "precipitazione" feminine ; -- status=guess
lin hurry_V = mkV "affrettarsi" | mkV "precipitarsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin hurstpierpoint_PN = mkPN "Hurstpierpoint" ; -- status=guess src=geonames
lin hurt_N = mkN "detrimento" | mkN "intaccamento" | mkN "lesione" | mkN "nocimento" | mkN "nocumento" | mkN "pregiudizio" ; -- UWN
lin hurt_V = dolere_V | mkV (I.fare_V) "male" ; -- status=guess, src=wikt status=guess, src=wikt
lin hurt_V2 = mkV2 (dolere_V) | mkV2 (mkV (I.fare_V) "male") ; -- status=guess, src=wikt status=guess, src=wikt
lin hurtle_V = mkV "gettare" | mkV "lanciare" | mkV "sbalestrare" | mkV "scagliare" | mkV "scaraventare" | mkV "tirare" ; -- UWN
lin husband_N = L.husband_N ;
lin husband_V2 = mkV2 (mkV "dosare") ; -- status=guess, src=wikt
lin husbandry_N = mkN "agricoltura" ; -- status=guess
lin hush_N = mkN "pace" | mkN "quiete" | mkN "silenzio" ; -- UWN
lin hush_V = mkV (mettere_V) "a tacere" ; -- status=guess, src=wikt
lin hush_V2 = mkV2 (mkV (mettere_V) "a tacere") ; -- status=guess, src=wikt
lin husk_N = mkN "riccio" | mkN "buccia" | mkN "scorza" ; -- status=guess status=guess status=guess
lin husky_A = mkA "corpulento" | mkA "robusto" ; -- status=guess status=guess
lin hussar_N = mkN "ussaro" ; -- status=guess
lin hustler_N = mkN "armeggione" | mkN "faccendiere" | mkN "intrallazzatore" | mkN "intrigante" | mkN "maneggione" | mkN "mestatore" | mkN "traffichino" | mkN "trafficone" ; -- UWN
lin hut_N = mkN "capanna" ; -- status=guess
lin hyacinth_N = mkN "giacinto" ; -- status=guess
lin hyaena_N = mkN "iena" ; -- UWN
lin hybrid_A = mkA "ibrido" ; -- status=guess
lin hybrid_N = mkN "ibrido" ; -- status=guess
lin hybridization_N = mkN "ibridizzazione" feminine ; -- status=guess
lin hybridize_V = mkV "ibridare" | mkV "incrociare" ; -- UWN
lin hydathode_N = mkN "idatodo" ; -- status=guess
lin hyde_PN = mkPN "Hyde" ; -- status=guess src=geonames
lin hyderabad_PN = mkPN "Hyderabad" ; -- status=guess src=geonames
lin hydra_N = mkN "idra" ; -- UWN
lin hydrangea_N = mkN "ortensia" ; -- status=guess
lin hydrant_N = mkN "idrante" ; -- UWN
lin hydrate_N = mkN "idrato" ; -- status=guess
lin hydrate_V = mkV "idratare" ; -- status=guess, src=wikt
lin hydrate_V2 = mkV2 (mkV "idratare") ; -- status=guess, src=wikt
lin hydration_N = mkN "idratazione" ; -- UWN
lin hydraulics_N = mkN "idraulica" ; -- status=guess
lin hydrazine_N = mkN "idrazina" ; -- UWN
lin hydride_N = mkN "idruro" ; -- status=guess
lin hydrocarbon_N = mkN "idrocarburo" ; -- UWN
lin hydrocephalic_A = mkA "idrocefalico" ; -- UWN
lin hydrocephalus_N = mkN "idrocefalo" ; -- UWN
lin hydrochloric_A = mkA "cloridrico" ; -- status=guess
lin hydrochloride_N = mkN "cloridrato" ; -- status=guess
lin hydrodynamic_A = mkA "idrodinamico" ; -- UWN
lin hydrodynamics_N = mkN "idrodinamica" ; -- UWN
lin hydroelectric_A = mkA "idroelettrico" ; -- UWN
lin hydrofoil_N = mkN "aliscafo" ; -- status=guess
lin hydrogen_N = mkN "idrogeno" ; -- status=guess
lin hydrogenation_N = mkN "idrogenazione" feminine ; -- status=guess
lin hydrographic_A = mkA "idrografico" ; -- UWN
lin hydrography_N = mkN "idrografia" ; -- UWN
lin hydrokinetic_A = mkA "idrocinetico" ; -- UWN
lin hydrologist_N = mkN "idrogista" | mkN "idrogisto" | mkN "idrologa" | mkN "idrologo" ; -- status=guess status=guess status=guess status=guess
lin hydrology_N = mkN "idrologia" ; -- UWN
lin hydrolysate_N = mkN "idrolizzato" ; -- status=guess
lin hydrolysis_N = mkN "idrolisi" feminine ; -- status=guess
lin hydromel_N = mkN "idromele" ; -- UWN
lin hydrometer_N = mkN "areometro" | mkN "gravimetro" ; -- UWN
lin hydrometric_A = mkA "idrometrico" ; -- status=guess
lin hydrometry_N = mkN "idrometria" ; -- status=guess
lin hydropathy_N = mkN "idroterapia" ; -- UWN
lin hydrophilic_A = mkA "idrofilo" ; -- UWN
lin hydrophobia_N = mkN "idrofobia" | mkN "rabbia" ; -- UWN
lin hydrophobic_A = mkA "idrofobo" ; -- status=guess
lin hydroplane_N = mkN "aliscafo" | mkN "idroplano" ; -- UWN
lin hydroponics_N = mkN "acquicoltura" | mkN "enidrocoltura" | mkN "idrocoltura" | mkN "idrocultura" | mkN "idroponica" ; -- UWN
lin hydrosphere_N = mkN "idrosfera" ; -- status=guess
lin hydrostatic_A = mkA "idrostatico" ; -- status=guess
lin hydrostatics_N = mkN "idrostatica" ; -- UWN
lin hydrothorax_N = mkN "idrotorace" masculine ; -- status=guess
lin hydroxide_N = mkN "idrossido" ; -- status=guess
lin hydroxyl_N = mkN "ossidrile" | mkN "idrossile" masculine ; -- status=guess status=guess
lin hyena_N = mkN "iena" ; -- status=guess
lin hygiene_N = mkN "igiene" feminine ; -- status=guess
lin hygienist_N = mkN "igienista" ; -- status=guess
lin hygrometer_N = mkN "igrometro" ; -- status=guess
lin hygroscope_N = mkN "igroscopio" ; -- status=guess
lin hygroscopic_A = mkA "igroscopico" ; -- status=guess
lin hymen_N = mkN "imene" masculine ; -- status=guess
lin hymenal_A = mkA "imeneale" ; -- UWN
lin hymeneal_A = mkA "imeneo" ; -- status=guess
lin hymenium_N = mkN "imenio" ; -- status=guess
lin hymnal_N = mkN "innario" | mkN "innografia" | mkN "libro_dei_canti" ; -- UWN
lin hyoid_N = mkN "ioide" ; -- UWN
lin hypallage_N = mkN "ipallage" ; -- status=guess
lin hyperactivity_N = mkN "iperattività" feminine ; -- status=guess
lin hyperacusis_N = mkN "iperacusia" ; -- status=guess
lin hyperbaton_N = mkN "iperbato" ; -- UWN
lin hyperbola_N = mkN "iperbole" feminine ; -- status=guess
lin hyperbole_N = mkN "iperbole" feminine ; -- status=guess
lin hyperbolic_A = mkA "iperbolico" ; -- status=guess
lin hypercatalectic_A = mkA "ipercatalettico" | mkA "ipercataletto" ; -- UWN
lin hypercellularity_N = mkN "ipercellularità" feminine ; -- status=guess
lin hyperemia_N = mkN "iperemia" ; -- UWN
lin hyperglycemia_N = mkN "iperglicemia" ; -- UWN
lin hypermarket_N = mkN "ipermercato" ; -- UWN
lin hypernatremia_N = mkN "ipernatriemia" ; -- status=guess
lin hypernym_N = mkN "iperonimo" ; -- status=guess
lin hyperon_N = mkN "iperone" masculine ; -- status=guess
lin hyperope_N = mkN "ipermetrope" ; -- UWN
lin hyperopia_N = mkN "ipermetropia" | mkN "presbiopia" | mkN "presbitismo" ; -- UWN
lin hyperpituitarism_N = mkN "iperpituitarismo" ; -- status=guess
lin hyperplasia_N = mkN "iperplasia" ; -- status=guess
lin hyperpyrexia_N = mkN "iperpiressia" ; -- UWN
lin hypersensitivity_N = mkN "ipersensibilità" feminine ; -- status=guess
lin hypersomnia_N = mkN "ipersonnia" ; -- status=guess
lin hypersplenism_N = mkN "ipersplenismo" ; -- status=guess
lin hypertext_N = mkN "ipertesto" ; -- status=guess
lin hyperthermia_N = mkN "ipertermia" | mkN "piressia" ; -- UWN
lin hyperthyroidism_N = mkN "ipertiroidismo" | mkN "tiroidismo" ; -- UWN
lin hypertrophy_N = mkN "ipertrofia" ; -- status=guess
lin hyperventilation_N = mkN "iperpnea" | mkN "iperventilazione" ; -- UWN
lin hypervitaminosis_N = mkN "ipervitaminosi" ; -- UWN
lin hypervolemia_N = mkN "ipervolemia" ; -- status=guess
lin hypha_N = mkN "ifa" ; -- status=guess
lin hyphen_N = mkN "trattino" ; -- status=guess
lin hyphenation_N = mkN "sillabazione" feminine ; -- status=guess
lin hypnosis_N = mkN "ipnosi" feminine ; -- status=guess
lin hypnotherapy_N = mkN "ipnositerapia" ; -- status=guess
lin hypnotism_N = mkN "ipnotismo" ; -- status=guess
lin hypnotist_N = mkN "ipnotizzatore" | mkN "magnetizzatore" ; -- UWN
lin hypnotize_V2 = mkV2 (mkV "ipnotizzare") ; -- status=guess, src=wikt
lin hypo_N = mkN "siringa_ipodermica" ; -- UWN
lin hypocapnia_N = mkN "ipocapnia" ; -- status=guess
lin hypochlorite_N = mkN "ipoclorito" ; -- status=guess
lin hypochondria_N = mkN "ipocondria" ; -- status=guess
lin hypochondriac_N = mkN "ipocondriaco" ; -- UWN
lin hypocrisy_N = mkN "ipocrisia" ; -- status=guess
lin hypocrite_N = mkN "ipocrita" masculine ; -- status=guess
lin hypocritical_A = mkA "ipocrita" ; -- status=guess
lin hypocycloid_N = mkN "ipocicloide" feminine ; -- status=guess
lin hypodermic_A = mkA "ipodermico" ; -- UWN
lin hypodermic_N = mkN "siringa_ipodermica" ; -- UWN
lin hypodermis_N = mkN "ipoderma" ; -- UWN
lin hyponatremia_N = mkN "iponatriemia" | mkN "iposodiemia" ; -- status=guess status=guess
lin hyponym_N = mkN "iponimo" ; -- status=guess
lin hypophyseal_A = mkA "ipofisario" ; -- UWN
lin hypoproteinemia_N = mkN "ipoproteinemia" ; -- status=guess
lin hypospadias_N = mkN "ipospadia" ; -- status=guess
lin hypotension_N = mkN "ipotensione" ; -- status=guess
lin hypotensive_A = mkA "ipoteso" ; -- UWN
lin hypotenuse_N = mkN "ipotenusa" ; -- status=guess
lin hypothalamus_N = mkN "ipotalamo" ; -- status=guess
lin hypothecate_V2 = mkV2 (mkV "ipotecare") ; -- status=guess, src=wikt
lin hypothesis_N = mkN "ipotesi" feminine ; -- status=guess
lin hypothetical_A = mkA "ipotetico" ; -- status=guess
lin hypothyroidism_N = mkN "ipotiroidismo" ; -- status=guess
lin hypovolemic_A = mkA "ipovolemico" ; -- status=guess
lin hypsometer_N = mkN "ipsometro" ; -- status=guess
lin hypsometry_N = mkN "ipsometria" ; -- status=guess
lin hyssop_N = mkN "issopo" ; -- status=guess
lin hysterectomy_N = mkN "isterectomia" ; -- status=guess
lin hysteresis_N = mkN "isterisi" feminine ; -- status=guess
lin hysteria_N = mkN "isteria" ; -- status=guess
lin hysterical_A = mkA "isterico" ; -- status=guess
lin hysterics_N = mkN "isterismo" ; -- UWN
lin hythe_PN = mkPN "Hythe" ; -- status=guess src=geonames
lin iFem_Pron = optProDrop E.i8fem_Pron ;
lin i_Pron = optProDrop S.i_Pron ;
lin iamb_N = mkN "giambo" ; -- status=guess
lin iambic_A = mkA "giambico" ; -- status=guess
lin iambus_N = mkN "giambo" ; -- UWN
lin ibadan_PN = mkPN "Ibadan" ; -- status=guess src=geonames
lin ibex_N = mkN "stambecco" ; -- status=guess
lin ibis_N = mkN "ibis" ; -- UWN
lin ibuprofen_N = mkN "ibuprofene" masculine ; -- status=guess
lin ice_N = L.ice_N ;
lin ice_V = mkV "ghiacciare" ; -- status=guess, src=wikt
lin ice_V2 = mkV2 (mkV "ghiacciare") ; -- status=guess, src=wikt
lin iceberg_N = mkN "iceberg" masculine ; -- status=guess
lin icebox_N = mkN "ghiacciaia" ; -- status=guess
lin icebreaker_N = mkN "rompighiaccio" ; -- status=guess
lin iceland_PN = mkPN "Islanda" ; -- status=guess src=geonames
lin icepick_N = mkN "punteruolo da ghiaccio" ; -- status=guess
lin ichorous_A = mkA "icoroso" ; -- UWN
lin ichthyologist_N = mkN "ittiologo" ; -- UWN
lin ichthyology_N = mkN "ittiologia" ; -- status=guess
lin ichthyosaur_N = mkN "ittiosauro" ; -- status=guess
lin ichthyosaurus_N = mkN "ictiosauro" | mkN "ittiosauro" ; -- UWN
lin icicle_N = mkN "ghiacciolo" ; -- status=guess
lin icky_A = mkA "sdolcinato" | mkA "svenevole" ; -- status=guess status=guess
lin icon_N = mkN "icona" ; -- status=guess
lin iconoclasm_N = mkN "iconoclastia" ; -- status=guess
lin iconoclast_N = mkN "iconoclasta" masculine ; -- status=guess
lin iconography_N = mkN "iconografia" ; -- status=guess
lin iconolatry_N = mkN "iconolatria" ; -- UWN
lin iconoscope_N = mkN "iconoscopio" ; -- UWN
lin icosahedral_A = mkA "icosaedrico" ; -- UWN
lin icosahedron_N = mkN "icosaedro" ; -- UWN
lin idea_N = mkN "impressione" feminine ; -- status=guess
lin ideal_A = mkA "ideale" ; -- status=guess
lin ideal_N = mkN "ideale" masculine ; -- status=guess
lin idealism_N = mkN "idealismo" ; -- status=guess
lin idealist_N = mkN "idealista" masculine ; -- status=guess
lin idealistic_A = mkA "idealistico" ; -- status=guess
lin idealization_N = mkN "idealizzazione" ; -- UWN
lin ideally_Adv = adjAdv ideal_A ; -- -- derived
lin ideation_N = mkN "ideazione" feminine ; -- status=guess
lin identical_A = mkA "identico" ; -- status=guess
lin identifiable_A = mkA "identificabile" ; -- UWN
lin identification_N = mkN "identificazione" feminine ; -- status=guess
lin identifier_N = mkN "identificatore" masculine ; -- status=guess
lin identify_V = variants {} ; --
lin identify_V2 = variants {} ; --
lin identikit_N = mkN "identikit" masculine ; -- status=guess
lin identity_N = mkN "identità" feminine ; -- status=guess
lin ideogram_N = mkN "ideogramma" masculine ; -- status=guess
lin ideograph_N = mkN "ideogramma" ; -- UWN
lin ideographic_A = mkA "ideografico" ; -- UWN
lin ideological_A = mkA "ideologico" ; -- status=guess
lin ideologist_N = mkN "ideologo" ; -- UWN
lin ideology_N = mkN "ideologia" ; -- status=guess
lin ides_N = mkN "idi" ; -- UWN
lin idiocy_N = mkN "frenastenia" | mkN "idiotismo" | mkN "idiozia" | mkN "oligofrenia" ; -- UWN
lin idiolect_N = mkN "idioletto" ; -- status=guess
lin idiom_N = mkN "idiotismo" | mkN "idiomatismo" ; -- status=guess status=guess
lin idiomatic_A = mkA "idiomatico" ; -- status=guess
lin idiopathic_A = mkA "idiopatico" ; -- status=guess
lin idiosyncrasy_N = mkN "idiosincrasia" ; -- status=guess
lin idiot_N = mkN "idiota" masculine ; -- status=guess
lin idle_A = mkA "pigro" | mkA "indolente" | mkA "ozioso" | mkA "infingardo" ; -- status=guess status=guess status=guess status=guess
lin idle_V = mkV "oziare" ; -- status=guess, src=wikt
lin idle_V2 = mkV2 (mkV "oziare") ; -- status=guess, src=wikt
lin idleness_N = mkN "ozio" ; -- status=guess
lin idler_N = mkN "acchiappamosche" | mkN "bighellone" | mkN "ciondolone" | mkN "fannullone" | mkN "infingardo" | mkN "michelaccio" | mkN "ozioso" | mkN "pelandrone" | mkN "perdigiorno" | mkN "perditempo" | mkN "poltrone" | mkN "poltroniere" | mkN "poltroniero" | mkN "scansafatiche" | mkN "scioperato" | mkN "sfaccendato" | mkN "sfaticato" | mkN "vagabondo" | mkN "vitellone" ; -- UWN
lin idol_N = mkN "idolo" ; -- UWN
lin idolater_N = mkN "idolatra" masculine ; -- status=guess
lin idolatrous_A = mkA "idolatra" ; -- UWN
lin idolatry_N = mkN "feticismo" | mkN "idolatria" ; -- UWN
lin idolizer_N = mkN "idolatra" ; -- UWN
lin idyll_N = mkN "bucolica" | mkN "ecloga" | mkN "egloga" | mkN "idillio" ; -- UWN
lin if_Subj = S.if_Subj ;
lin if_then_Conj = S.if_then_Conj ; -- comment=CHECKED
lin igloo_N = mkN "iglù" masculine ; -- status=guess
lin igneous_A = mkA "igneo" ; -- status=guess
lin ignite_V = mkV "incendiare" ; -- status=guess, src=wikt
lin ignite_V2 = mkV2 (mkV "incendiare") ; -- status=guess, src=wikt
lin ignition_N = mkN "ignizione" feminine | mkN "accensione" feminine ; -- status=guess status=guess
lin ignominious_A = mkA "ignominioso" ; -- status=guess
lin ignominy_N = mkN "disdoro" | mkN "disonore" | mkN "ignominia" | mkN "infamia" | mkN "obbrobrio" | mkN "onta" | mkN "vergogna" ; -- UWN
lin ignoramus_N = mkN "ignorante" | mkN "illetterato" | mkN "incolto" ; -- UWN
lin ignorance_N = mkN "ignoranza" ; -- status=guess
lin ignorant_A = mkA "ignorante" ; -- status=guess
lin ignore_V = mkV "ignorare" ; -- status=guess, src=wikt
lin ignore_V2 = mkV2 (mkV "ignorare") ; -- status=guess, src=wikt
lin iguana_N = mkN "iguana" ; -- status=guess
lin ikon_N = mkN "icona" ; -- UWN
lin ileum_N = mkN "ileo" ; -- UWN
lin ilfracombe_PN = mkPN "Ilfracombe" ; -- status=guess src=geonames
lin iliac_A = mkA "iliaco" ; -- UWN
lin ilium_N = mkN "ileo" | mkN "ilio" ; -- UWN
lin ilkeston_PN = mkPN "Ilkeston" ; -- status=guess src=geonames
lin ilkley_PN = mkPN "Ilkley" ; -- status=guess src=geonames
lin ill_1_A = mkA "malato" ;
lin ill_2_A = mkA "malato" ;
lin ill_AdV = variants {} ; --
lin ill_N = mkN "acciacco" | mkN "affezione" | mkN "disturbo" | mkN "magagna" | mkN "malanno" | mkN "malattia" ; -- UWN
lin ill_advised_A = mkA "malconsigliato" ; -- UWN
lin illative_A = mkA "illativo" ; -- UWN
lin illegal_A = mkA "antigiuridico" | mkA "fuorilegge" | mkA "illegale" ; -- UWN
lin illegality_N = mkN "illegalismo" | mkN "illegalità" ; -- UWN
lin illegible_A = mkA "illeggibile" ; -- status=guess
lin illegitimacy_N = mkN "illegittimità" feminine ; -- status=guess
lin illegitimate_A = mkA "illegale" ; -- status=guess
lin illiberality_N = mkN "illiberalità" ; -- UWN
lin illiteracy_N = mkN "analfabetismo" ; -- status=guess
lin illiterate_A = mkA "illetterato" ; -- status=guess
lin illiterate_N = mkN "analfabeta" | mkN "illetterato" ; -- UWN
lin illness_N = mkN "malattia" ; -- status=guess
lin illogicality_N = mkN "illogicità" ; -- UWN
lin illogicalness_N = mkN "illogicità" ; -- UWN
lin illuminate_V2 = mkV2 (mkV "illuminare") | mkV2 (mkV "chiarire") ; -- status=guess, src=wikt status=guess, src=wikt
lin illumination_N = mkN "illuminazione" feminine ; -- status=guess
lin illusion_N = mkN "illusione" feminine ; -- status=guess
lin illusionist_N = mkN "illusionista" | mkN "mago" | mkN "prestigiatore" ; -- UWN
lin illusory_A = mkA "illusorio" ; -- status=guess
lin illustrate_V = mkV "illustrare" ; -- status=guess, src=wikt
lin illustrate_V2 = mkV2 (mkV "illustrare") ; -- status=guess, src=wikt
lin illustrate_VS = mkVS (mkV "illustrare") ; -- status=guess, src=wikt
lin illustration_N = mkN "illustrare" ; -- status=guess
lin illustrator_N = mkN "illustratore" ; -- UWN
lin illustrious_A = mkA "famoso" ; -- status=guess
lin ilmenite_N = mkN "ilmenite" feminine ; -- status=guess
lin image_N = mkN "immagine" feminine ; -- status=guess
lin imagery_N = mkN "immaginario" | mkN "immaginazione" ; -- UWN
lin imaginable_A = mkA "immaginabile" ; -- status=guess
lin imaginary_A = mkA "immaginario" ; -- status=guess
lin imagination_N = mkN "immaginativa" | mkN "immaginazione" ; -- UWN
lin imaginative_A = variants {} ; --
lin imagine_V = mkV "concepire" | mkV "immaginare" | mkV "pensare" ; -- UWN
lin imagine_V2 = variants {} ; --
lin imagine_VS = mkvVS "concepire" | mkvVS "immaginare" | mkvVS "pensare" ; -- UWN
lin imaging_N = mkN "tomografia" ; -- UWN
lin imam_N = mkN "imam" | mkN "iman" ; -- UWN
lin imbalance_N = mkN "scompenso" ; -- status=guess
lin imbecile_N = mkN "tarato" ; -- status=guess
lin imbecility_N = mkN "imbecillità" feminine ; -- status=guess
lin imbibition_N = mkN "bere" | mkN "bevuta" ; -- UWN
lin imbrication_N = mkN "accavallamento" | mkN "embricatura" ; -- UWN
lin imbue_V2 = mkV2 (mkV "impregnare") | mkV2 (mkV "permeare") ; -- status=guess, src=wikt status=guess, src=wikt
lin imide_N = mkN "immide" feminine ; -- status=guess
lin imitate_V2 = mkV2 (mkV "imitare") ; -- status=guess, src=wikt
lin imitation_N = mkN "imitazione" feminine ; -- status=guess
lin imitator_N = mkN "copione" | mkN "epigono" | mkN "imitatore" ; -- UWN
lin immaculate_A = mkA "immacolato" ; -- status=guess
lin immanence_N = mkN "immanenza" ; -- UWN
lin immanent_A = mkA "soggettivo" ; -- UWN
lin immaterial_A = mkA "immateriale" ; -- status=guess
lin immateriality_N = mkN "immaterialità" | mkN "incorporeità" feminine ; -- status=guess status=guess
lin immature_A = mkA "immaturo" | mkA "infantile" ; -- status=guess status=guess
lin immaturity_N = mkN "acerbità" | mkN "immaturità" ; -- UWN
lin immeasurable_A = mkA "incommensurabile" | mkA "smisurato" ; -- UWN
lin immediate_A = mkA "prossimo" | mkA "stretto" | mkA "diretto" ; -- status=guess status=guess status=guess
lin immense_A = mkA "immenso" ; -- status=guess
lin immensity_N = mkN "immensità" | mkN "oceano" | mkN "immanità" feminine ; -- status=guess status=guess status=guess
lin immersion_N = mkN "immersione" ; -- UWN
lin immigrant_N = mkN "immigrante" masculine ; -- status=guess
lin immigrate_V = mkV "immigrare" ; -- status=guess, src=wikt
lin immigration_N = mkN "immigrazione" feminine ; -- status=guess
lin imminence_N = mkN "imminenza" ; -- UWN
lin imminent_A = variants {} ; --
lin immingham_PN = mkPN "Immingham" ; -- status=guess src=geonames
lin immiscible_A = mkA "immiscibile" ; -- status=guess
lin immobile_A = mkA "immobile" ; -- status=guess
lin immobility_N = mkN "immobilità" feminine ; -- status=guess
lin immobilization_N = mkN "immobilizzazione" ; -- UWN
lin immoderate_A = mkA "soperchievole" | mkA "soverchievole" | mkA "soverchio" ; -- UWN
lin immoderation_N = mkN "eccesso" | mkN "immoderatezza" | mkN "smoderatezza" ; -- UWN
lin immolate_V2 = mkV2 (mkV "immolare") | mkV2 (mkV "sacrificare") ; -- status=guess, src=wikt status=guess, src=wikt
lin immolation_N = mkN "immolazione" ; -- UWN
lin immoral_A = mkA "immorale" ; -- status=guess
lin immorality_N = mkN "immoralità" | mkN "iniquità" | mkN "male" | mkN "malvagità" | mkN "scelleratezza" ; -- UWN
lin immortal_A = mkA "immortale" ; -- status=guess
lin immortal_N = mkN "immortale" ; -- status=guess
lin immortality_N = mkN "immortalità" feminine ; -- status=guess
lin immune_A = variants {} ; --
lin immune_N = mkN "risposta immunitaria" ; -- status=guess
lin immunity_N = mkN "immunità" ; -- status=guess
lin immunization_N = mkN "immunizzazione" ; -- UWN
lin immunofluorescence_N = mkN "immunofluorescenza" ; -- UWN
lin immunoglobulin_N = mkN "immunoglobulina" ; -- status=guess
lin immunological_A = mkA "immunologico" ; -- UWN
lin immunologist_N = mkN "immunologo" ; -- status=guess
lin immunology_N = mkN "immunologia" ; -- status=guess
lin immunopathology_N = mkN "immunopatologia" ; -- UWN
lin immunosuppression_N = mkN "immunosoppressione" ; -- UWN
lin immunosuppressive_A = mkA "immunosoppressivo" ; -- UWN
lin immutability_N = mkN "immutabilità" | mkN "inalterabilità" ; -- UWN
lin immutable_A = mkA "immutabile" ; -- UWN
lin impact_N = mkN "impatto" ; -- status=guess
lin impairment_N = mkN "indebolimento" ; -- status=guess
lin impala_N = mkN "impala" masculine ; -- status=guess
lin impalement_N = mkN "impalamento" | mkN "impalatura" ; -- UWN
lin impalpable_A = mkA "impalpabile" ; -- status=guess
lin impart_V2 = mkV2 (mkV "impartire") ; -- status=guess, src=wikt
lin impartial_A = mkA "equanime" | mkA "imparziale" | mkA "neutrale" | mkA "spassionato" ; -- UWN
lin impartiality_N = mkN "equanimità" | mkN "equità" | mkN "imparzialità" | mkN "obbiettività" | mkN "obiettività" | mkN "spassionatezza" ; -- UWN
lin impassable_A = mkA "impraticabile" ; -- UWN
lin impasse_N = mkN "angiporto" | mkN "cul_de_sac" | mkN "culdisacco" | mkN "vicolo_cieco" ; -- UWN
lin impassioned_A = mkA "appassionato" | mkA "ardente" | mkA "focoso" ; -- UWN
lin impassiveness_N = mkN "indifferenza" ; -- UWN
lin impassivity_N = mkN "indifferenza" ; -- UWN
lin impatient_A = mkA "impaziente" | mkA "insofferente" ; -- UWN
lin impeachability_N = mkN "imputabilità" ; -- UWN
lin impedimenta_N = mkN "bagaglio" | mkN "salmerie" ; -- UWN
lin impenetrable_A = mkA "impenetrabile" ; -- UWN
lin impenitence_N = mkN "impenitenza" ; -- UWN
lin impenitent_A = mkA "impenitente" ; -- UWN
lin imperative_A = mkA "imperativo" | mkA "necessario" | mkA "necessaria" ; -- status=guess status=guess status=guess
lin imperative_N = mkN "imperativo" | mkN "necessario" ; -- status=guess status=guess
lin imperceptibility_N = mkN "impercettibilità" ; -- UWN
lin imperceptible_A = mkA "impercettibile" ; -- UWN
lin imperfect_N = mkN "imperfetto" ; -- status=guess
lin imperfective_N = mkN "imperfetto" ; -- status=guess
lin imperial_A = variants {} ; --
lin imperialism_N = mkN "imperialismo" ; -- status=guess
lin imperialist_N = mkN "imperialista" ; -- UWN
lin imperialistic_A = mkA "imperialista" | mkA "imperialistico" ; -- UWN
lin imperiousness_N = mkN "imperiosità" feminine ; -- status=guess
lin impermeability_N = mkN "impermeabilità" feminine ; -- status=guess
lin impermeable_A = mkA "impermeabile" ; -- UWN
lin imperturbability_N = mkN "flemma" | mkN "freddezza" | mkN "impassibilità" | mkN "imperturbabilità" | mkN "seraficità" ; -- UWN
lin impervious_A = mkA "impermeabile" ; -- status=guess
lin impetigo_N = mkN "empetiggine" | mkN "impetiggine" | mkN "impetigine" ; -- UWN
lin impetuosity_N = mkN "impetuosità" | mkN "irruenza" ; -- UWN
lin impetuous_A = mkA "irruente" ; -- status=guess
lin impetuousness_N = mkN "impetuosità" | mkN "irruenza" ; -- UWN
lin impetus_N = mkN "impulso" | mkN "spinta" ; -- UWN
lin impiety_N = mkN "empietà" ; -- UWN
lin impious_A = mkA "empio" ; -- UWN
lin implacable_A = mkA "implacabile" ; -- UWN
lin implement_N = mkN "attrezzo" | mkN "utensile" masculine | mkN "arnese" masculine ; -- status=guess status=guess status=guess
lin implement_V2 = mkV2 (mkV (mettere_V) "in pratica") | mkV2 (mkV "attuare") | mkV2 (mkV "implementare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin implementation_N = mkN "implementazione" feminine | mkN "attuazione" feminine ; -- status=guess status=guess
lin implicate_V2 = mkV2 (mkV "implicare") ; -- status=guess, src=wikt
lin implication_N = mkN "implicazione" ; -- UWN
lin implicit_A = mkA "implicito" ; -- status=guess
lin imploringly_Adv = mkAdv "supplichevolmente" ; -- UWN
lin implosion_N = mkN "implosione" feminine ; -- status=guess
lin imply_V = mkV "implicare" ; -- status=guess, src=wikt
lin imply_V2 = mkV2 (mkV "implicare") ; -- status=guess, src=wikt
lin imply_VS = mkVS (mkV "implicare") ; -- status=guess, src=wikt
lin impolite_A = mkA "scortese" | mkA "maleducato" | mkA "rude" ; -- status=guess status=guess status=guess
lin impoliteness_N = mkN "inciviltà" | mkN "inurbanità" | mkN "mal_garbo" | mkN "mala_grazia" | mkN "malacreanza" | mkN "malagrazia" | mkN "malcreanza" | mkN "maleducazione" | mkN "malgarbo" | mkN "scortesia" | mkN "sgarbatezza" | mkN "sgarberia" | mkN "zoticaggine" ; -- UWN
lin impolitic_A = mkA "impolitico" ; -- UWN
lin imponderable_A = mkA "imponderabile" ; -- UWN
lin imponderable_N = mkN "imponderabile" | mkN "imprevedibile" ; -- UWN
lin import_N = mkN "import" | mkN "importazione" | mkN "importazioni" ; -- UWN
lin import_V2 = mkV2 (mkV "importare") ; -- status=guess, src=wikt
lin importance_N = mkN "importanza" ; -- status=guess
lin important_A = L.important_A ;
lin importerFem_N = mkN "importatore" ; -- UWN
lin importerMasc_N = mkN "importatore" ; -- UWN
lin importing_N = mkN "importazione" ; -- UWN
lin impose_V = variants {} ; --
lin impose_V2 = variants {} ; --
lin impossible_A = mkA "impossibile" ; -- status=guess
lin impossible_N = mkN "impossibile" masculine ; -- status=guess
lin imposter_N = mkN "commediante" | mkN "impostore" ; -- UWN
lin impostor_N = mkN "impostore" masculine ; -- status=guess
lin impotence_N = mkN "impotenza" ; -- UWN
lin impotent_A = mkA "impotente" ; -- status=guess
lin impound_V2 = mkV2 (mkV "requisire") | mkV2 (mkV "sequestrare") ; -- status=guess, src=wikt status=guess, src=wikt
lin impoverish_V2 = mkV2 (mkV "immiserirsi") ; -- status=guess, src=wikt
lin impoverishment_N = mkN "depauperamento" | mkN "immiserimento" | mkN "impoverimento" ; -- UWN
lin impracticability_N = mkN "impraticabilità" | mkN "irraggiungibilità" | mkN "irrealizzabilità" ; -- UWN
lin impracticableness_N = mkN "impraticabilità" | mkN "irraggiungibilità" | mkN "irrealizzabilità" ; -- UWN
lin imprecation_N = mkN "imprecazione" feminine ; -- status=guess
lin imprecise_A = mkA "impreciso" ; -- status=guess
lin impreciseness_N = mkN "imprecisione" ; -- UWN
lin imprecision_N = mkN "imprecisione" ; -- UWN
lin impregnability_N = mkN "inattaccabilità" | mkN "invulnerabilità" ; -- UWN
lin impregnation_N = mkN "fecondazione" | mkN "impregnazione" ; -- UWN
lin impresario_N = mkN "impresario" ; -- status=guess
lin impress_V = mkV "impressionare" ; -- status=guess, src=wikt
lin impress_V2 = mkV2 (mkV "impressionare") ; -- status=guess, src=wikt
lin impression_N = variants {} ; --
lin impressionable_A = mkA "impressionabile" ; -- UWN
lin impressionist_A = mkA "impressionista" | mkA "impressionistico" ; -- UWN
lin impressionist_N = mkN "impressionista" ; -- UWN
lin impressive_A = mkA "impressionante" ; -- status=guess
lin imprimatur_N = mkN "sanzione" ; -- UWN
lin imprison_V2 = mkV2 (mkV "imprigionare") | mkV2 (mkV "incarcerare") ; -- status=guess, src=wikt status=guess, src=wikt
lin imprisonment_N = variants {} ; --
lin improbability_N = mkN "improbabilità" ; -- UWN
lin improbable_A = mkA "improbabile" ; -- status=guess
lin impromptu_A = mkA "improvvisato" | mkA "improvvisata" ; -- status=guess status=guess
lin impropriety_N = mkN "confidenza" ; -- UWN
lin improve_V = mkV "migliorare" | mkV (stare_V) "meglio" ; -- status=guess, src=wikt status=guess, src=wikt
lin improve_V2 = mkV2 (mkV "migliorare") | mkV2 (mkV (stare_V) "meglio") ; -- status=guess, src=wikt status=guess, src=wikt
lin improved_A = variants {} ; --
lin improvement_N = mkN "miglioramento" ; -- status=guess
lin improvidence_N = mkN "imprevidenza" | mkN "improvvidenza" ; -- UWN
lin improvident_A = mkA "avventato" | mkA "disavveduto" | mkA "imprevidente" ; -- UWN
lin improvisation_N = mkN "improvvisazione" feminine ; -- status=guess
lin improvise_V = mkV "improvvisare" | mkV (mkV "parlare") "a braccio" ; -- status=guess, src=wikt status=guess, src=wikt
lin improvise_V2 = mkV2 (mkV "improvvisare") | mkV2 (mkV (mkV "parlare") "a braccio") ; -- status=guess, src=wikt status=guess, src=wikt
lin imprudence_N = mkN "imprudenza" ; -- UWN
lin imprudent_A = mkA "imprudente" | mkA "incauto" ; -- UWN
lin impudence_N = mkN "impudenza" | mkN "sfrontatezza" ; -- status=guess status=guess
lin impugnable_A = mkA "impugnabile" ; -- status=guess
lin impulse_N = mkN "impulso" ; -- status=guess
lin impulsion_N = mkN "impulso" | mkN "spinta" ; -- UWN
lin impulsive_A = mkA "impulsivo" ; -- status=guess
lin impulsiveness_N = mkN "impulsività" feminine ; -- status=guess
lin impunity_N = mkN "impunità" ; -- UWN
lin impure_A = mkA "impuro" ; -- status=guess
lin impurity_N = mkN "impurità" feminine ; -- status=guess
lin impute_V2 = mkV2 (mkV "imputare") ; -- status=guess, src=wikt
lin in8front_Prep = S.in8front_Prep ; -- comment=CHECKED
lin in_1_Adv = mkAdv "dentro" ;
lin in_2_Adv = mkAdv "dentro" ;
lin in_A = mkA "in carica" ; -- status=guess
lin in_Adv = mkAdv "dentro" ;
lin in_N = mkN "posta in arrivo" ; -- status=guess
lin in_Prep = S.in_Prep ;
lin inability_N = variants {} ; --
lin inaccessible_A = mkA "inaccessibile" ; -- status=guess
lin inaccuracy_N = mkN "inesattezza" ; -- status=guess
lin inaction_N = mkN "inattività" | mkN "inazione" | mkN "inazione" | mkN "inerzia" | mkN "inoperosità" | mkN "ozio" ; -- UWN
lin inactiveness_N = mkN "inerzia" ; -- UWN
lin inadequate_A = mkA "inadeguato" ; -- status=guess
lin inadmissibility_N = mkN "inammissibilità" ; -- status=guess
lin inadmissible_A = mkA "inammissibile" ; -- status=guess
lin inadvertence_N = mkN "svagatezza" ; -- UWN
lin inadvertent_A = variants {} ;
lin inalienable_A = mkA "inalienabile" ; -- status=guess
lin inanimate_A = mkA "inanimato" ; -- UWN
lin inanition_N = mkN "inanizione" ; -- UWN
lin inanity_N = mkN "insulsaggine" ; -- UWN
lin inapplicability_N = mkN "inapplicabilità" ; -- status=guess
lin inappropriate_A = variants {} ; --
lin inappropriateness_N = mkN "inadeguatezza" ; -- UWN
lin inarticulate_A = mkA "inarticolato" ; -- UWN
lin inattention_N = mkN "disattenzione" | mkN "distrazione" ; -- UWN
lin inattentive_A = mkA "disattento" | mkA "distratto" | mkA "inattento" | mkA "irrazionale" | mkA "sbadato" | mkA "stordito" | mkA "svagato" | mkA "sventato" ; -- UWN
lin inaugurate_V2 = mkV2 (mkV "inaugurare") ; -- status=guess, src=wikt
lin inauguration_N = mkN "inaugurazione" feminine ; -- status=guess
lin inauspicious_A = mkA "nefasto" ; -- UWN
lin inboard_A = mkA "entrobordo" ; -- UWN
lin incalculable_A = mkA "impagabile" | mkA "inapprezzabile" | mkA "incalcolabile" | mkA "incommensurabile" | mkA "inestimabile" ; -- UWN
lin incandescent_A = mkA "incandescente" ; -- status=guess
lin incapable_A = variants {} ; --
lin incarcerate_V2 = mkV2 (mkV "imprigionare") ; -- status=guess, src=wikt
lin incarceration_N = mkN "carcerazione" | mkN "carcere" | mkN "cattività" | mkN "detenzione" | mkN "incarcerazione" | mkN "prigionia" | mkN "reclusione" ; -- UWN
lin incautious_A = mkA "malavveduto" ; -- UWN
lin incendiarism_N = mkN "incendio_doloso" ; -- UWN
lin incendiary_A = mkA "incendiario" ; -- status=guess
lin incendiary_N = mkN "ordigno_incendiario" ; -- UWN
lin incense_N = mkN "incenso" | mkN "olibano" ; -- status=guess status=guess
lin incentive_N = variants {} ; --
lin inception_N = mkN "inizio" | mkN "principio" | mkN "debutto" ; -- status=guess status=guess status=guess
lin incertitude_N = mkN "dubbio" | mkN "dubbiosità" | mkN "forse" | mkN "incertezza" | mkN "problematicità" ; -- UWN
lin incest_N = mkN "incesto" ; -- status=guess
lin incestuous_A = mkA "incestuoso" | mkA "incestuale" ; -- status=guess status=guess
lin inch_N = mkN "pollice" masculine ; -- status=guess
lin inch_V = mkV (mkV "muoversi") "poco a poco" ; -- status=guess, src=wikt
lin inch_V2 = mkV2 (mkV (mkV "muoversi") "poco a poco") ; -- status=guess, src=wikt
lin incidence_N = variants {} ; --
lin incident_A = mkA "incidentale" ; -- UWN
lin incident_N = variants {} ; --
lin incidental_A = mkA "incidentale" ; -- UWN
lin incidental_N = mkN "musica incidentale" ; -- status=guess
lin incinerator_N = mkN "inceneritore" ; -- UWN
lin incision_N = mkN "incisione" feminine ; -- status=guess
lin incisiveness_N = mkN "incisività" | mkN "nervosità" ; -- UWN
lin incisor_N = mkN "incisivo" ; -- status=guess
lin incitation_N = mkN "eccitamento" | mkN "fomento" | mkN "istigazione" ; -- UWN
lin incivility_N = mkN "inciviltà" ; -- UWN
lin inclemency_N = mkN "asprezza" | mkN "crudezza" | mkN "durezza" | mkN "gravità" | mkN "rigidezza" | mkN "rigore" | mkN "severità" ; -- UWN
lin inclination_N = mkN "inclinazione" feminine ; -- status=guess
lin incline_N = mkN "rampa" ; -- UWN
lin inclined_A = variants {} ; --
lin include_V = mkV "includere" | mkV "inserire" | aggiungere_V | comprendere_V ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin include_V2 = mkV2 (mkV "includere") | mkV2 (mkV "inserire") | mkV2 (aggiungere_V) | mkV2 (comprendere_V) ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin including_Prep = variants {} ; --
lin inclusion_N = mkN "inclusione" feminine ; -- status=guess
lin inclusive_A = mkA "complessivo" | mkA "compreso" | mkA "cumulativo" | mkA "globale" | mkA "incluso" ; -- UWN
lin incoherence_N = mkN "incoerenza" ; -- UWN
lin incombustible_A = mkA "incombustibile" ; -- UWN
lin income_N = mkN "introiti" ;
lin incommutability_N = mkN "incommutabilità" ; -- UWN
lin incomparable_A = mkA "eccezionale" | mkA "imbattibile" | mkA "imparagonabile" | mkA "impareggiabile" | mkA "inarrivabile" | mkA "incomparabile" | mkA "ineguagliabile" | mkA "inimitabile" | mkA "inuguagliabile" | mkA "unico" ; -- UWN
lin incompatibility_N = mkN "incompatibilità" feminine ; -- status=guess
lin incompatible_A = mkA "incompatibile" ; -- status=guess
lin incompetent_N = mkN "cane" | mkN "incapace" | mkN "incompetente" | mkN "inetto" ; -- UWN
lin incomplete_A = mkA "incompleto" ; -- status=guess
lin incompleteness_N = mkN "incompiutezza" | mkN "incompletezza" | mkN "lacunosità" ; -- UWN
lin incomprehensibility_N = mkN "astrusaggine" | mkN "enigmaticità" | mkN "inaccessibilità" | mkN "incomprensibilità" | mkN "inesplicabilità" ; -- UWN
lin incomprehensible_A = mkA "incomprensibile" ; -- status=guess
lin incomprehension_N = mkN "incomprensione" ; -- UWN
lin incompressibility_N = mkN "incoercibilità" | mkN "incompressibilità" | mkN "incomprimibilità" ; -- UWN
lin incompressible_A = mkA "incomprimibile" ; -- status=guess
lin inconceivability_N = mkN "inconcepibilità" ; -- UWN
lin inconceivable_A = mkA "inconcepibile" ; -- status=guess
lin inconclusiveness_N = mkN "inconcludenza" ; -- UWN
lin inconsequence_N = mkN "illogicità" ; -- UWN
lin inconsistency_N = mkN "incongruenza" ; -- UWN
lin inconsolable_A = mkA "inconsolabile" | mkA "sconsolato" ; -- UWN
lin inconstancy_N = mkN "incostanza" | mkN "instabilità" | mkN "leggerezza" | mkN "mobilità" | mkN "mutevolezza" | mkN "volubilità" ; -- UWN
lin inconstant_A = mkA "incostante" | mkA "discontinuo" | mkA "volubile" ; -- status=guess status=guess status=guess
lin incontinence_N = mkN "dissolutezza" | mkN "sfrenatezza" | mkN "smoderatezza" | mkN "sregolatezza" ; -- UWN
lin incontrovertibility_N = mkN "incontrovertibilità" | mkN "inoppugnabilità" ; -- UWN
lin inconvenience_N = mkN "disagio" ; -- status=guess
lin inconvenient_A = mkA "sconveniente" ; -- status=guess
lin inconvertibility_N = mkN "inconvertibilità" ; -- UWN
lin inconvertible_A = mkA "inconvertibile" ; -- UWN
lin incoordination_N = mkN "incoordinazione" | mkN "matassia" ; -- UWN
lin incorporate_A = mkA "unificato" ; -- UWN
lin incorporate_V2 = mkV2 (mkV "incorporare") ; -- status=guess, src=wikt
lin incorporeal_A = mkA "immateriale" | mkA "incorporeo" ; -- UWN
lin incorrect_A = mkA "non corretto" ; -- status=guess
lin incorrigible_A = mkA "incorreggibile" ; -- UWN
lin incorruptibility_N = mkN "incorruttibilità" feminine ; -- status=guess
lin increase_N = mkN "accrescimento" | mkN "aumento" | mkN "incremento" ; -- UWN
lin increase_V = mkV "aumentare" ; -- status=guess, src=wikt
lin increase_V2 = mkV2 (mkV "aumentare") ; -- status=guess, src=wikt
lin increased_A = variants {} ; --
lin increasing_A = variants {} ; --
lin increasingly_Adv = variants {} ; --
lin incredibility_N = mkN "eccezionalità" | mkN "favolosità" | mkN "incredibilità" ; -- UWN
lin incredible_A = mkA "incredibile" ; -- status=guess
lin incredulity_N = mkN "incredulità" | mkN "miscredenza" | mkN "scetticismo" ; -- UWN
lin incrimination_N = mkN "accusa" | mkN "addebito" | mkN "imputazione" ; -- UWN
lin incubator_N = mkN "incubatrice" feminine ; -- status=guess
lin incubus_N = mkN "incubo" ; -- status=guess
lin inculcate_V2 = mkV2 (mkV "inculcare") ; -- status=guess, src=wikt
lin inculcation_N = mkN "instillazione" | mkN "istillazione" ; -- UWN
lin incumbent_A = mkA "titolare" | mkA "in carica" ; -- status=guess status=guess
lin incumbent_N = mkN "in carica" | mkN "titolare" masculine ; -- status=guess status=guess
lin incur_V2 = variants {} ; --
lin incurability_N = mkN "incurabilità" | mkN "insanabilità" feminine ; -- status=guess status=guess
lin incurable_N = mkN "incurabile" ; -- UWN
lin incus_N = mkN "incudine" ; -- UWN
lin indebtedness_N = mkN "debito di riconoscenza" ; -- status=guess
lin indecisive_A = mkA "indeciso" ; -- status=guess
lin indecorous_A = mkA "disdicevole" | mkA "indecoroso" | mkA "inopportuno" | mkA "sconvenevole" ; -- UWN
lin indecorum_N = mkN "confidenza" ; -- UWN
lin indeed_AdV = mkAdV "effettivamente" ; -- UWN
lin indeed_Adv = mkAdv "infatti" ; -- status=guess
lin indefatigability_N = mkN "infaticabilità" | mkN "instancabilità" ; -- UWN
lin indefatigable_A = mkA "infaticabile" ; -- status=guess
lin indefeasible_A = mkA "imprescrittibile" ; -- UWN
lin indefinite_A = mkA "indefinito" ; -- status=guess
lin indefiniteness_N = mkN "genericismo" | mkN "genericità" | mkN "impersonalità" | mkN "indefinitezza" | mkN "indeterminatezza" | mkN "sbrigatività" | mkN "sommarietà" ; -- UWN
lin indehiscent_A = mkA "indeiscente" ; -- UWN
lin indelible_A = mkA "indelebile" ; -- status=guess
lin indemnity_N = mkN "indennità" ; -- status=guess status=guess status=guess
lin indent_N = mkN "capoverso" | mkN "rientranza" ; -- UWN
lin indentation_N = mkN "indentazione" feminine ; -- status=guess
lin indenture_N = mkN "capoverso" | mkN "rientranza" ; -- UWN
lin independence_N = mkN "indipendenza" ; -- status=guess
lin independent_1_A = variants {} ; --
lin independent_2_A = variants {} ; --
lin independent_A = mkA "indipendente" ; -- status=guess
lin independent_N = mkN "variabile indipendente" ; -- status=guess
lin indestructibility_N = mkN "indistruttibilità" ; -- UWN
lin indestructible_A = mkA "indistruttibile" ; -- UWN
lin indeterminacy_N = mkN "indeterminazione" feminine | mkN "indeterminatezza" ; -- status=guess status=guess
lin indeterminate_A = mkA "indeterminato" ; -- status=guess
lin index_N = mkN "indice" masculine ; -- status=guess
lin index_V2 = mkV2 (mkV "indicizzare") ; -- status=guess, src=wikt
lin indexation_N = mkN "indicizzazione" ; -- UWN
lin india_PN = mkPN "India" ; -- status=guess src=geonames
lin indianFem_1_N = variants {} ; ---- sense to be split
lin indianFem_2_N = variants {} ; ---- sense to be split
lin indianMasc_1_N = variants {} ; ---- sense to be split
lin indianMasc_2_N = variants {} ; ---- sense to be split
lin indiana_PN = mkPN "Indiana" ; -- status=guess src=geonames
lin indianapolis_PN = mkPN "Indianapolis" ; -- status=guess src=geonames
lin indicate_V2 = variants {} ; --
lin indicate_VS = variants {} ; --
lin indication_N = variants {} ; --
lin indicative_A = mkA "indicativo" ; -- status=guess
lin indicator_N = mkN "freccia" ; -- status=guess
lin indict_V = mkV "incriminare" ; -- UWN
lin indiction_N = mkN "indizione" ; -- UWN
lin indifference_N = mkN "abulia" | mkN "apatia" | mkN "disamore" | mkN "indifferenza" | mkN "letargo" ; -- UWN
lin indigence_N = mkN "bisogno" | mkN "indigenza" | mkN "miseria" ; -- UWN
lin indigenous_A = mkA "indigeno" ; -- status=guess
lin indigenousness_N = mkN "autoctonia" ; -- UWN
lin indigestibility_N = mkN "indigeribilità" ; -- UWN
lin indigestible_A = mkA "indigesto" ; -- UWN
lin indigestion_N = mkN "indigestione" feminine ; -- status=guess
lin indignant_A = mkA "indignato" ; -- status=guess
lin indigo_A = mkA "indaco" ; -- status=guess
lin indigo_N = mkN "indaco" ; -- status=guess
lin indirect_A = variants {} ; --
lin indiscipline_N = mkN "indisciplina" | mkN "indisciplinatezza" ; -- UWN
lin indiscreet_A = mkA "indiscreto" ; -- status=guess
lin indiscriminate_A = mkA "indiscriminato" ; -- status=guess
lin indispensability_N = mkN "indispensabilità" ; -- UWN
lin indispensable_A = mkA "indispensabile" ; -- status=guess
lin indisposition_N = mkN "riluttanza" | mkN "tentennare" | mkN "tentennio" ; -- UWN
lin indisputability_N = mkN "inconfutabilità" | mkN "incontestabilità" | mkN "incontrovertibilità" | mkN "insindacabilità" | mkN "irrefutabilità" ; -- UWN
lin indissoluble_A = mkA "insolubile" ; -- UWN
lin indistinct_A = mkA "indeciso" | mkA "indistinto" ; -- UWN
lin indistinctness_N = mkN "nebbiosità" ; -- UWN
lin indistinguishable_A = mkA "indiscernibile" | mkA "indistinguibile" ; -- UWN
lin indium_N = mkN "indio" ; -- status=guess
lin individual_A = variants {} ; --
lin individual_N = mkN "individuo" ; -- status=guess
lin individualist_N = mkN "individualista" ; -- UWN
lin individualization_N = mkN "individuazione" ; -- UWN
lin indivisible_A = mkA "indivisibile" ; -- UWN
lin indoctrination_N = mkN "addottrinamento" | mkN "indottrinamento" ; -- UWN
lin indolence_N = mkN "accidia" | mkN "pigrizia" | mkN "poltronaggine" | mkN "poltroneria" | mkN "scioperataggine" | mkN "svogliatezza" ; -- UWN
lin indomitability_N = mkN "imbattibilità" | mkN "invincibilità" ; -- UWN
lin indonesia_PN = mkPN "Indonesia" ; -- status=guess src=geonames
lin indoor_A = mkA "al chiuso" ; -- status=guess
lin indoors_Adv = mkAdv "dentro" ; -- UWN
lin indore_PN = mkPN "Indore" ; -- status=guess src=geonames
lin indrawn_A = mkA "introverso" ; -- UWN
lin induce_V2 = variants {} ; --
lin inductee_N = mkN "coscritto" ; -- UWN
lin induction_N = mkN "induzione" feminine | mkN "autoinduzione" feminine ; -- status=guess status=guess
lin indulge_V = variants {} ; --
lin indulge_V2 = variants {} ; --
lin indulgence_N = mkN "vizio" ; -- status=guess
lin indusium_N = mkN "indusio" ; -- UWN
lin industrial_A = variants {} ; --
lin industrialism_N = mkN "industrialismo" ; -- UWN
lin industrialist_N = mkN "industriale" ; -- UWN
lin industrialization_N = mkN "industrializzazione" ; -- UWN
lin industrialize_V2 = mkV2 (mkV "industrializzare") ; -- status=guess, src=wikt
lin industrious_A = mkA "industrioso" | mkA "laborioso" ; -- status=guess status=guess
lin industry_N = L.industry_N ;
lin indweller_N = mkN "abitante" | mkN "abitatore" | mkN "anima" | mkN "popolatore" | mkN "residente" ; -- UWN
lin inebriation_N = mkN "ciucca" | mkN "ebbrezza" | mkN "ebrezza" | mkN "inebriamento" | mkN "sbornia" | mkN "ubbriacatura" | mkN "ubbriachezza" | mkN "ubriacatura" | mkN "ubriachezza" ; -- UWN
lin inebriety_N = mkN "ciucca" | mkN "ebbrezza" | mkN "ebrezza" | mkN "inebriamento" | mkN "sbornia" | mkN "ubbriacatura" | mkN "ubbriachezza" | mkN "ubriacatura" | mkN "ubriachezza" ; -- UWN
lin inedible_A = mkA "incommestibile" ; -- status=guess
lin ineffective_A = mkA "ineffettivo" ; -- status=guess
lin inefficacy_N = mkN "inefficacia" ; -- UWN
lin inelastic_A = mkA "anelastico" ; -- status=guess
lin inelasticity_N = mkN "anelasticità" ; -- UWN
lin inelegance_N = mkN "ineleganza" ; -- UWN
lin inelegant_A = mkA "goffo" | mkA "inelegante" | mkA "rozzo" ; -- UWN
lin ineligibility_N = mkN "ineleggibilità" | mkN "ineligibilità" ; -- UWN
lin ineluctable_A = mkA "ineluttabile" ; -- status=guess
lin inequality_N = mkN "disequazione disuguaglianza" ; -- status=guess
lin inequitable_A = mkA "ingiusto" ; -- status=guess
lin inequity_N = mkN "ingiustizia" | mkN "iniquità" ; -- UWN
lin inertia_N = mkN "inerzia" ; -- status=guess
lin inertial_A = mkA "inerziale" ; -- UWN
lin inertness_N = mkN "inerzia" ; -- status=guess
lin inevitability_N = mkN "fatalità" | mkN "ineludibilità" | mkN "ineluttabilità" | mkN "inevitabilità" ; -- UWN
lin inevitable_A = mkA "inevitabile" ; -- status=guess
lin inevitable_N = mkN "inevitabile" ; -- UWN
lin inexact_A = mkA "inesatto" ; -- UWN
lin inexactitude_N = mkN "inesattezza" ; -- UWN
lin inexactness_N = mkN "inesattezza" ; -- UWN
lin inexhaustible_A = mkA "inesauribile" ; -- status=guess
lin inexorable_A = mkA "inesorabile" ; -- status=guess
lin inexpensive_A = mkA "economico" ; -- status=guess
lin inexpensiveness_N = mkN "economicità" ; -- UWN
lin inexperience_N = mkN "imperizia" | mkN "impreparazione" | mkN "inesperienza" | mkN "sprovvedutezza" ; -- UWN
lin inexperienced_A = mkA "inesperto" | mkA "maldestro" | mkA "novellino" | mkA "sprovveduto" ; -- UWN
lin inexplicable_A = mkA "inspiegabile" | mkA "incomprensibile" | mkA "inesplicabile" ; -- status=guess status=guess status=guess
lin inexpressible_A = mkA "indefinibile" | mkA "indescrivibile" | mkA "indicibile" | mkA "ineffabile" | mkA "inenarrabile" | mkA "inesprimibile" ; -- UWN
lin inextinguishable_A = mkA "inestinguibile" ; -- status=guess
lin inextricable_A = mkA "inestricabile" ; -- status=guess
lin infallibility_N = mkN "infallibilità" ; -- UWN
lin infallible_A = mkA "infallibile" ; -- status=guess
lin infamy_N = mkN "infamia" ; -- status=guess
lin infant_N = mkN "minorenne" masculine | mkN "minore" masculine ; -- status=guess status=guess
lin infanticide_N = mkN "infanticidio" ; -- UWN
lin infantile_A = mkA "infantile" | mkA "puerile" ; -- status=guess status=guess
lin infantilism_N = mkN "infantilismo" ; -- UWN
lin infantry_N = mkN "fante" masculine ; -- status=guess
lin infantryman_N = mkN "fantaccino" | mkN "fante" ; -- UWN
lin infarct_N = mkN "infarto" ; -- status=guess
lin infatuation_N = mkN "infatuazione" feminine ; -- status=guess
lin infeasibility_N = mkN "ineffettuabilità" | mkN "irrealizzabilità" ; -- UWN
lin infect_V = variants {} ; --
lin infect_V2 = variants {} ; --
lin infection_N = mkN "infezione" feminine ; -- status=guess
lin infective_A = mkA "infettivo" ; -- status=guess
lin infer_V2 = mkV2 (mkV "inferire") ; -- status=guess, src=wikt
lin inference_N = mkN "inferenza" ; -- status=guess
lin inferential_A = mkA "illativo" ; -- UWN
lin inferior_N = mkN "inferiore" feminine ; -- status=guess
lin inferiority_N = mkN "inferiorità" feminine ; -- status=guess
lin inferno_N = mkN "inferno" ; -- status=guess
lin infertile_A = mkA "infertile" | mkA "sterile" ; -- status=guess status=guess
lin infertility_N = mkN "infertilità" | mkN "sterilità" feminine ; -- status=guess status=guess
lin infestation_N = mkN "infestazione" feminine ; -- status=guess
lin infidel_N = mkN "infedele" masculine ; -- status=guess
lin infidelity_N = mkN "infedeltà" ; -- UWN
lin infield_N = mkN "diamante" ; -- UWN
lin infiltration_N = mkN "infiltrazione" feminine ; -- status=guess
lin infinite_A = variants {} ; --
lin infiniteness_N = mkN "incalcolabilità" | mkN "infinitezza" | mkN "infinità" | mkN "innumerabilità" | mkN "sconfinatezza" ; -- UWN
lin infinitival_A = mkA "infinitivale" ; -- UWN
lin infinitive_N = mkN "infinito" ; -- status=guess
lin infinitude_N = mkN "incalcolabilità" | mkN "infinitezza" | mkN "infinità" | mkN "innumerabilità" | mkN "sconfinatezza" ; -- UWN
lin infinity_N = mkN "infinito" | mkN "infinità" ; -- status=guess status=guess
lin infirmary_N = mkN "nosocomio" | mkN "ospedale" ; -- UWN
lin infirmity_N = mkN "debilitazione" | mkN "fragilità" | mkN "gracilità" | mkN "infermità" | mkN "mollezza" | mkN "tenuità" ; -- UWN
lin inflame_V = mkV "incendiare" ; -- status=guess, src=wikt
lin inflame_V2 = mkV2 (mkV "incendiare") ; -- status=guess, src=wikt
lin inflammable_A = mkA "infiammabile" ; -- status=guess
lin inflammation_N = mkN "accensione" ; -- UWN
lin inflate_V = mkV "enfiare" ; -- status=guess, src=wikt
lin inflate_V2 = mkV2 (mkV "enfiare") ; -- status=guess, src=wikt
lin inflation_N = mkN "inflazione" feminine ; -- status=guess
lin inflationary_A = mkA "inflazionistico" ; -- UWN
lin inflect_V2 = mkV2 (mkV "coniugare") | mkV2 (flettere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin inflection_N = mkN "desinenza" ; -- status=guess
lin inflexibility_N = mkN "inflessibilità" feminine ; -- status=guess
lin inflexible_A = mkA "inflessibile" ; -- status=guess
lin inflexion_N = mkN "desinenza" ; -- UWN
lin inflict_V2 = mkV2 (mkV "infliggere") ; -- status=guess, src=wikt
lin infliction_N = mkN "imposizione" feminine | mkN "irrogazione" feminine | mkN "inflizione" feminine ; -- status=guess status=guess status=guess
lin inflorescence_N = mkN "infiorescenza" ; -- status=guess
lin inflow_N = mkN "afflusso" ; -- UWN
lin influence_N = mkN "influenza" ; -- status=guess
lin influence_V2 = mkV2 (mkV "influire") ; -- status=guess, src=wikt
lin influential_A = mkA "autorevole" ; -- status=guess
lin influenza_N = mkN "influenza" | mkN "febbre" feminine ; -- status=guess status=guess
lin influx_N = mkN "afflusso" ; -- UWN
lin info_N = mkN "informazione" ; -- UWN
lin inform_V = variants {} ; --
lin inform_V2 = variants {} ; --
lin informal_A = variants {} ; --
lin informality_N = mkN "informalità" feminine ; -- status=guess
lin informant_N = mkN "delatore" masculine | mkN "informatore" | mkN "spia" ; -- status=guess status=guess status=guess
lin information_N = mkN "informazione" feminine ; -- status=guess
lin infrastructure_N = mkN "infrastruttura" ; -- status=guess
lin infrequency_N = mkN "rarità" | mkN "singolarità" ; -- UWN
lin infrequent_A = mkA "infrequente" | mkA "rado" ; -- UWN
lin infringe_V = mkV "infrangere" ; -- status=guess, src=wikt
lin infringe_V2 = mkV2 (mkV "infrangere") ; -- status=guess, src=wikt
lin infringement_N = mkN "infrazione" feminine ; -- status=guess
lin infructescence_N = mkN "infruttescenza" ; -- status=guess
lin ingatestone_PN = mkPN "Ingatestone" ; -- status=guess src=geonames
lin ingathering_N = mkN "colletta" | mkN "raccolta" ; -- UWN
lin ingenuity_N = mkN "ingegnosità" feminine ; -- status=guess
lin ingenuous_A = mkA "candido" | mkA "ingenuo" ; -- UWN
lin ingest_V2 = mkV2 (mkV "ingerire") ; -- status=guess, src=wikt
lin ingot_N = mkN "lingotto" ; -- status=guess
lin ingrained_A = mkA "incallito" | mkA "inveterato" ; -- status=guess status=guess
lin ingrate_N = mkN "ingrato" ; -- UWN
lin ingratitude_N = mkN "disconoscenza" | mkN "ingratitudine" | mkN "sconoscenza" ; -- UWN
lin ingredient_N = mkN "ingrediente" masculine ; -- status=guess
lin ingress_N = mkN "entrata" | mkN "ingresso" ; -- UWN
lin inhabitable_A = mkA "abitabile" ; -- status=guess
lin inhabitant_N = mkN "abitante" masculine ; -- status=guess
lin inhalant_A = mkA "inalante" ; -- UWN
lin inhalation_N = mkN "aspirazione" | mkN "inalazione" | mkN "inspirazione" ; -- UWN
lin inhale_V = mkV "ispirare" ; -- status=guess, src=wikt
lin inhale_V2 = mkV2 (mkV "ispirare") ; -- status=guess, src=wikt
lin inhaler_N = mkN "inalatore" ; -- UWN
lin inherent_A = variants {} ; --
lin inherit_V = mkV "ereditare" ; -- status=guess, src=wikt
lin inherit_V2 = mkV2 (mkV "ereditare") ; -- status=guess, src=wikt
lin inheritable_A = mkA "ereditabile" ; -- UWN
lin inheritance_N = mkN "ereditarietà" feminine ; -- status=guess
lin inheritorFem_N = variants {} ; ---- sense to be split
lin inheritorMasc_N = mkN "erede" ; -- UWN
lin inhibit_V2 = variants {} ; --
lin inhibition_N = variants {} ; --
lin inhibitor_N = mkN "inibitore" ; -- UWN
lin inhomogeneity_N = mkN "disomogeneità" feminine ; -- status=guess
lin inhumane_A = mkA "inumano" ; -- status=guess
lin inhumaneness_N = mkN "disumanità" | mkN "inumanità" ; -- UWN
lin initial_A = mkA "iniziale" ; -- status=guess
lin initial_N = mkN "iniziale" ; -- UWN
lin initiate_N = mkN "novizio" ; -- status=guess
lin initiate_V2 = mkV2 (mkV "iniziare") | mkV2 (mkV "cominciare") | mkV2 (mkV "presentare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin initiation_N = mkN "inizio" ; -- status=guess
lin initiative_N = mkN "iniziativa" ; -- status=guess
lin inject_V2 = variants {} ; --
lin injection_N = mkN "iniezione" feminine ; -- status=guess
lin injunction_N = mkN "ingiunzione" ; -- UWN
lin injure_V2 = mkV2 (mkV "ferire") ; -- status=guess, src=wikt
lin injured_A = variants {} ; --
lin injurious_A = mkA "ingiurioso" ; -- status=guess
lin injury_N = mkN "ferita" | mkN "danno" | mkN "lesione" feminine ; -- status=guess status=guess status=guess
lin injustice_N = mkN "ingiustizia" ; -- status=guess
lin ink_N = mkN "inchiostro" ; -- status=guess
lin ink_V2 = mkV2 (mkV "inchiostrare") ; -- status=guess, src=wikt
lin inkwell_N = mkN "calamaio" ; -- status=guess
lin inland_A = mkA "interno" ; -- UWN
lin inlay_N = mkN "intarsio" ; -- UWN
lin inlet_N = mkN "insenatura" | mkN "estuario" ; -- status=guess status=guess
lin inmate_N = mkN "carcerato" | mkN "galeotto" ; -- UWN
lin inn_N = mkN "osteria" | mkN "locanda" ; -- status=guess status=guess
lin innate_A = mkA "innato" ; -- status=guess
lin inner_A = mkA "interno" ; -- status=guess
lin inning_N = mkN "inning" ; -- UWN
lin innings_N = mkN "turno_di_battuta" ; -- UWN
lin innocence_N = mkN "innocenza" ; -- status=guess
lin innocent_A = mkA "innocente" ; -- status=guess
lin innocuous_A = mkA "innocuo" ; -- status=guess
lin innovate_V = mkV "instaurare" | mkV "istaurare" | mkV "trapiantare" ; -- UWN
lin innovation_N = mkN "innovazione" feminine ; -- status=guess
lin innovative_A = mkA "innovativo" ; -- status=guess
lin innsbruck_PN = mkPN "Innsbruck" ; -- status=guess src=geonames
lin innuendo_N = mkN "insinuazione" feminine ; -- status=guess
lin inoffensive_A = mkA "inoffensivo" ; -- status=guess
lin inoperative_A = mkA "inoperante" ; -- UWN
lin inopportune_A = mkA "importuno" ; -- UWN
lin inorganic_A = mkA "inorganico" ; -- status=guess
lin in_patient_N = mkN "degente" | mkN "ricoverato" ; -- UWN
lin input_N = variants {} ; --
lin inquest_N = variants {} ; --
lin inquiringly_Adv = mkAdv "interrogativamente" ; -- UWN
lin inquiry_N = variants {} ; --
lin inquisition_N = mkN "inquisizione" ; -- UWN
lin inquisitiveness_N = mkN "curiosità" ; -- UWN
lin insalubrious_A = mkA "insalubre" ; -- status=guess
lin insalubrity_N = mkN "insalubrità" ; -- UWN
lin insane_A = mkA "folle" | mkA "pazzo" ; -- status=guess status=guess
lin insanity_N = mkN "follia" ; -- status=guess
lin insatiable_A = mkA "inappagabile" | mkA "incontentabile" | mkA "insaziabile" ; -- UWN
lin insatiate_A = mkA "inappagabile" | mkA "incontentabile" | mkA "insaziabile" ; -- UWN
lin inscription_N = mkN "inscrizione" feminine | mkN "motto" ; -- status=guess status=guess
lin inscrutability_N = mkN "impenetrabilità" | mkN "imperscrutabilità" | mkN "inscrutabilità" ; -- UWN
lin inscrutable_A = mkA "impenetrabile" | mkA "incomprensibile" | mkA "insondabile" ; -- status=guess status=guess status=guess
lin insect_N = mkN "insetto" ; -- status=guess
lin insecticide_N = mkN "insetticida" ; -- status=guess
lin insectifuge_N = mkN "insettifugo" ; -- UWN
lin insectivore_N = mkN "insettivoro" ; -- status=guess
lin insecurity_N = mkN "insicurezza" ; -- UWN
lin insensibility_N = mkN "durezza" | mkN "insensibilità" ; -- UWN
lin insensitivity_N = mkN "insensibilità" ; -- UWN
lin inseparable_A = mkA "inseparabile" ; -- status=guess
lin insert_V2 = mkV2 (mkV "inserire") ; -- status=guess, src=wikt
lin insertion_N = mkN "inserimento" | mkN "inserzione" | mkN "introduzione" ; -- UWN
lin inshore_Adv = mkAdv "sotto_costa" ; -- UWN
lin inside_A = mkA "dentro" ; -- status=guess
lin inside_Adv = mkAdv "a fondo" ; -- status=guess
lin inside_N = mkN "dentro" | mkN "di_dentro" | mkN "didentro" | mkN "interno" ; -- UWN
lin inside_Prep = variants {} ; --
lin insider_N = variants {} ; --
lin insight_N = mkN "introspezione" feminine | mkN "acume" | mkN "intuito" | mkN "discernimento" ; -- status=guess status=guess status=guess status=guess
lin insignificance_N = mkN "insignificanza" | mkN "irrilevanza" | mkN "residualità" | mkN "trascurabilità" ; -- UWN
lin insignificant_A = mkA "insignificante" ; -- status=guess
lin insincere_A = mkA "insincero" ; -- UWN
lin insincerity_N = mkN "falsità" | mkN "fintaggine" | mkN "finteria" | mkN "insincerità" ; -- UWN
lin insinuate_V2 = mkV2 (mkV "insinuare") ; -- status=guess, src=wikt
lin insinuation_N = mkN "insinuazione" feminine ; -- status=guess
lin insist_V = variants {} ; --
lin insist_V2 = variants {} ; --
lin insist_VS = mkvVS "affermare" | mkvVS "asserire" | mkvVS "sostenere" ; -- UWN
lin insistence_N = variants {} ; --
lin insole_N = mkN "soletta" ; -- UWN
lin insolent_A = mkA "insolente" ; -- status=guess
lin insolubility_N = mkN "insolubilità" ; -- UWN
lin insoluble_A = mkA "inspiegabile" ; -- status=guess
lin insolvency_N = mkN "insolvenza" | mkN "insolvibilità" ; -- UWN
lin insolvent_A = mkA "insolvente" | mkA "insolvibile" ; -- UWN
lin insolvent_N = mkN "bancarottiere" | mkN "fallito" ; -- UWN
lin insomnia_N = mkN "insonnia" ; -- status=guess
lin inspect_V2 = mkV2 (mkV "ispezionare") ; -- status=guess, src=wikt
lin inspection_N = mkN "ispezione" feminine ; -- status=guess
lin inspector_N = mkN "verificatore" ; -- UWN
lin inspectorship_N = mkN "ispettorato" ; -- UWN
lin inspiration_N = mkN "inspirazione" feminine ; -- status=guess
lin inspiratory_A = mkA "inspiratorio" | mkA "inspiratore" ; -- status=guess status=guess
lin inspire_V2 = mkV2 (mkV "ispirare") ; -- status=guess, src=wikt
lin inspire_V2V = mkV2V (mkV "ispirare") ; -- status=guess, src=wikt
lin inspiring_A = mkA "ispiratore" ; -- UWN
lin inspissation_N = mkN "addensamento" | mkN "inspessimento" | mkN "ispessimento" ; -- UWN
lin instability_N = mkN "instabilità" feminine ; -- status=guess
lin instal_V = variants {} ; --
lin install_V = mkV "installare" ; -- status=guess, src=wikt
lin install_V2 = mkV2 (mkV "installare") ; -- status=guess, src=wikt
lin installation_N = mkN "installazione" feminine ; -- status=guess
lin installment_N = mkN "impianto" | mkN "installazione" | mkN "istallazione" ; -- UWN
lin instalment_N = mkN "impianto" | mkN "installazione" | mkN "istallazione" ; -- UWN
lin instance_N = variants {} ; --
lin instant_A = mkA "immediato" ; -- status=guess
lin instant_N = mkN "istante" masculine | mkN "attimo" ; -- status=guess status=guess
lin instantaneous_A = mkA "istantaneo" ; -- status=guess
lin instead_Adv = mkAdv "in luogo di" | mkAdv "invece" ; -- status=guess status=guess
lin instigation_N = mkN "istigazione" feminine ; -- status=guess
lin instigator_N = mkN "iniziatore" ; -- UWN
lin instillation_N = mkN "instillazione" | mkN "istillazione" ; -- UWN
lin instinct_N = mkN "istinto" ; -- status=guess
lin institute_N = mkN "istituto" ; -- status=guess
lin institution_N = variants {} ; --
lin institutional_A = variants {} ; --
lin instruct_V2 = variants {} ; --
lin instruction_N = variants {} ; --
lin instructive_A = mkA "istruttivo" ; -- UWN
lin instructor_N = variants {} ; --
lin instrument_N = mkN "strumento" ; -- status=guess
lin instrumental_A = mkA "strumentale" ; -- UWN
lin instrumentalist_N = mkN "strumentista" masculine ; -- status=guess
lin instrumentality_N = mkN "attrezzatura" | mkN "strumentazione" ; -- UWN
lin instrumentation_N = mkN "strumentazione" feminine ; -- status=guess
lin insubstantial_A = mkA "fantastico" | mkA "fiabesco" | mkA "illusorio" | mkA "immaginario" | mkA "inventato" | mkA "irreale" | mkA "splendido" ; -- UWN
lin insufficient_A = mkA "insufficiente" ; -- status=guess
lin insufflation_N = mkN "insufflazione" feminine ; -- status=guess
lin insularism_N = mkN "insularità" | mkN "isolamento" ; -- UWN
lin insularity_N = mkN "insularità" | mkN "isolamento" ; -- UWN
lin insulator_N = mkN "isolante" ; -- status=guess
lin insulin_N = mkN "insulina" ; -- status=guess
lin insult_N = mkN "insulto" | mkN "offesa" | mkN "oltraggio" | mkN "affronto" | mkN "ingiuria" ; -- status=guess status=guess status=guess status=guess status=guess
lin insult_V2 = mkV2 (mkV "offendere") | mkV2 (mkV "insultare") ; -- status=guess, src=wikt status=guess, src=wikt
lin insulting_A = mkA "adontoso" | mkA "oltraggiatore" | mkA "ingiurioso" | mkA "oltraggioso" | mkA "offensivo" ; -- status=guess status=guess status=guess status=guess status=guess
lin insurance_N = mkN "compagnia di assicurazioni" ; -- status=guess
lin insure_V = variants {} ; --
lin insure_V2 = variants {} ; --
lin insure_VS = variants {} ; --
lin insurgent_N = mkN "insorto" ; -- status=guess
lin insurrection_N = mkN "insurrezione" feminine ; -- status=guess
lin insurrectional_A = mkA "insurrezionale" | mkA "sedizioso" | mkA "sovversivo" ; -- UWN
lin intact_A = mkA "intero" ; -- UWN
lin intaglio_N = mkN "intaglio" ; -- UWN
lin intake_N = mkN "aspirazione" | mkN "inalazione" | mkN "inspirazione" ; -- UWN
lin intangibility_N = mkN "impalpabilità" | mkN "intangibilità" ; -- UWN
lin integer_N = mkN "intero" ; -- status=guess
lin integral_A = variants {} ; --
lin integral_N = mkN "integrale" masculine ; -- status=guess
lin integrate_V = mkV "incorporare" ; -- UWN
lin integrate_V2 = variants {} ; --
lin integrated_A = variants {} ; --
lin integration_N = mkN "integrazione" feminine ; -- status=guess
lin integrity_N = mkN "integrità" feminine ; -- status=guess
lin integument_N = mkN "integumento" | mkN "tegumento" ; -- UWN
lin intellectual_A = variants {} ; --
lin intellectual_N = mkN "intellettuale" | mkN "mente" ; -- UWN
lin intelligence_1_N = mkN "comprendonio" | mkN "intelligenza" | mkN "raziocinio" ; -- UWN
lin intelligence_2_N = mkN "comprendonio" | mkN "intelligenza" | mkN "raziocinio" ; -- UWN
lin intelligence_N = variants {} ; --
lin intelligent_A = mkA "intelligente" ; -- status=guess
lin intelligentsia_N = mkN "intellighenzia" ; -- status=guess
lin intelligibility_N = mkN "intellegibilità" | mkN "intelligibilità" ; -- UWN
lin intelligible_A = mkA "intelligibile" ; -- status=guess
lin intend_VV = variants {} ; --
lin intense_A = mkA "intenso" ; -- status=guess
lin intensifier_N = mkN "rafforzativo" ; -- UWN
lin intensify_V = variants {} ; --
lin intensify_V2 = variants {} ; --
lin intension_N = mkN "connotazione" ; -- UWN
lin intensity_N = mkN "intensità" feminine ; -- status=guess
lin intensive_A = variants {} ; --
lin intent_A = variants {} ; --
lin intent_N = mkN "animo" | mkN "disegno" | mkN "finalità" | mkN "fine" | mkN "intendimento" | mkN "intento" | mkN "intenzione" | mkN "meta" | mkN "mira" | mkN "pensamento" | mkN "proposito" | mkN "scopo" ; -- UWN
lin intention_N = mkN "intenzione" feminine ; -- status=guess
lin intentional_A = variants {} ;
lin intentionality_N = mkN "intenzionalità" ; -- UWN
lin interact_V = mkV "interagire" ; -- status=guess, src=wikt
lin interaction_N = mkN "interazione" feminine ; -- status=guess
lin interactive_A = mkA "interattivo" ; -- UWN
lin interbreed_V = mkV "ibridare" | mkV "incrociare" ; -- UWN
lin intercellular_A = mkA "intercellulare" ; -- UWN
lin intercept_N = mkN "intercettazione" feminine ; -- status=guess
lin interception_N = mkN "intercetto" ; -- status=guess
lin interceptor_N = mkN "intercettatore" | mkN "intercettore" ; -- UWN
lin intercession_N = mkN "intervento" ; -- UWN
lin interchangeable_A = variants {} ;
lin intercom_N = mkN "citofono" ; -- status=guess
lin intercommunicate_V = mkV "comunicare" ; -- UWN
lin interconnectedness_N = mkN "interconnessione" ; -- UWN
lin intercontinental_A = mkA "intercontinentale" ; -- status=guess
lin intercostal_A = mkA "intercostale" ; -- UWN
lin intercourse_N = mkN "rapporto sessuale" ; -- status=guess
lin interdependence_N = mkN "interdipendendenza" | mkN "interdipendenza" ; -- UWN
lin interdependent_A = mkA "interdipendente" ; -- UWN
lin interest_1_N = mkN "interesse" ;
lin interest_2_N = mkN "interesse" ;
lin interest_N = mkN "interesse" ;
lin interest_V = variants {} ; --
lin interest_V2 = variants {} ; --
lin interested_A = mkA "interessato" | mkA "interessata" ; -- status=guess status=guess
lin interesting_A = mkA "interessante" ; -- status=guess
lin interface_N = mkN "interfacciamento" | mkN "interfaccia" ; -- status=guess status=guess
lin interfere_V = mkV "impedire" ; -- status=guess, src=wikt
lin interference_N = variants {} ; --
lin interferometer_N = mkN "interferometro" ; -- UWN
lin interferon_N = mkN "interferone" masculine ; -- status=guess
lin intergalactic_A = mkA "intergalattico" ; -- status=guess
lin interim_A = variants {} ; --
lin interim_N = mkN "intervallo" ; -- status=guess
lin interior_A = variants {} ; --
lin interior_N = variants {} ; --
lin interjection_N = mkN "interiezione" feminine ; -- status=guess
lin interlinear_A = mkA "interlineare" ; -- UWN
lin interlock_V = mkV "ingranare" ; -- UWN
lin interlocutor_N = mkN "interlocutore" masculine ; -- status=guess
lin interlocutory_A = mkA "interlocutorio" ; -- UWN
lin interlude_N = mkN "interludio" ; -- status=guess
lin intermarriage_N = mkN "endogamia" ; -- UWN
lin intermediate_A = mkA "intermedio" ; -- UWN
lin intermediate_N = mkN "falangina" | mkN "falange intermedia" | mkN "falange media" ; -- status=guess status=guess status=guess
lin intermezzo_N = mkN "intermezzo" ; -- status=guess
lin intermingle_V = mkV "mescolare" | mkV "miscelare" | mkV "mischiare" | mkV "mischiarsi" | mkV "unire" ; -- UWN
lin intermittence_N = mkN "intermittenza" ; -- UWN
lin intermix_V = mkV "mescolare" | mkV "miscelare" | mkV "mischiare" | mkV "mischiarsi" | mkV "unire" ; -- UWN
lin intermolecular_A = mkA "intermolecolare" ; -- status=guess
lin intern_N = mkN "stagista" ; -- status=guess
lin intern_V2 = mkV2 (mkV "internare") ; -- status=guess, src=wikt
lin internal_A = variants {} ; --
lin internalization_N = mkN "interiorizzazione" ; -- UWN
lin international_A = mkA "internazionale" ; -- status=guess
lin internationality_N = mkN "internazionalità" ; -- UWN
lin internationalization_N = mkN "internazionalizzazione" feminine ; -- status=guess
lin internee_N = mkN "confinato" | mkN "internato" ; -- UWN
lin internet_N = mkN "cyberspazio" | mkN "internet" ; -- UWN
lin internist_N = mkN "internista" masculine ; -- status=guess
lin internship_N = mkN "stage" masculine ; -- status=guess
lin internuncio_N = mkN "internunzio" ; -- UWN
lin interphone_N = mkN "citofono" ; -- UWN
lin interplanetary_A = mkA "interplanetario" ; -- UWN
lin interplay_N = mkN "interazione" ; -- UWN
lin interpolation_N = mkN "interpolazione" feminine ; -- status=guess
lin interposition_N = mkN "frapposizione" | mkN "interposizione" ; -- UWN
lin interpret_V = mkV "interpretare" ; -- status=guess, src=wikt
lin interpret_V2 = mkV2 (mkV "interpretare") ; -- status=guess, src=wikt
lin interpretation_N = variants {} ; --
lin interpreter_N = mkN "interprete" masculine ; -- status=guess
lin interregnum_N = mkN "interregno" ; -- UWN
lin interrelation_N = mkN "correlazione" | mkN "interrelazione" ; -- UWN
lin interrelationship_N = mkN "correlazione" | mkN "interrelazione" ; -- UWN
lin interrogation_N = mkN "interrogazione" feminine ; -- status=guess
lin interrogative_A = mkA "interrogatorio" ; -- UWN
lin interrogative_N = mkN "pronome interrogativo" ; -- status=guess
lin interrogatory_A = mkA "interrogatorio" ; -- UWN
lin interrupt_V = interrompere_V ; -- status=guess, src=wikt
lin interrupt_V2 = mkV2 (interrompere_V) ; -- status=guess, src=wikt
lin intersect_V = mkV "attraversare" | mkV "incrociare" | mkV "incrociarsi" | mkV "intersecarsi" ; -- UWN
lin intersection_N = mkN "intersezione" feminine ; -- status=guess
lin interstellar_A = mkA "intersiderale" | mkA "interstellare" ; -- UWN
lin interstice_N = mkN "interstizio" ; -- UWN
lin interval_N = mkN "intervallo" ; -- status=guess
lin intervene_V = intervenire_V | mkV "interferire" ; -- status=guess, src=wikt status=guess, src=wikt
lin intervene_V2V = mkV2V (intervenire_V) | mkV2V (mkV "interferire") ; -- status=guess, src=wikt status=guess, src=wikt
lin intervention_N = mkN "intervento" ; -- status=guess
lin interview_N = mkN "colloquio" ; -- status=guess
lin interview_V2 = variants {} ; --
lin interviewee_N = mkN "intervistato" | mkN "intervistata" ; -- status=guess status=guess
lin interviewer_N = mkN "intervistatore" ; -- UWN
lin intestinal_A = mkA "intestinale" ; -- UWN
lin intestine_N = mkN "intestino" ; -- status=guess
lin inti_N = mkN "inti" | mkN "inti_peruviano" ; -- UWN
lin intima_N = mkN "intima" ; -- UWN
lin intimacy_N = mkN "intimità" feminine ; -- status=guess
lin intimate_A = variants {} ; --
lin intimate_N = mkN "confidente" ; -- UWN
lin into_Prep = mkPrep "dentro" ;
lin intolerance_N = mkN "intolleranza" ; -- status=guess
lin intonation_N = mkN "intonazione" feminine ; -- status=guess
lin intoxicate_V2 = mkV2 (mkV "inebriare") ; -- status=guess, src=wikt
lin intracellular_A = mkA "endocellulare" | mkA "intracellulare" ; -- UWN
lin intracranial_A = mkA "intracranico" ; -- UWN
lin intractability_N = mkN "indocilità" | mkN "riottosità" ; -- UWN
lin intractable_A = mkA "intrattabile" ; -- UWN
lin intradermal_A = mkA "intradermico" ; -- UWN
lin intrados_N = mkN "imbotte" | mkN "intradosso" | mkN "sottarco" ; -- UWN
lin intramolecular_A = mkA "intramolecolare" ; -- status=guess
lin intramuscular_A = mkA "intramuscolare" ; -- status=guess
lin intransigence_N = mkN "intransigenza" ; -- UWN
lin intransigency_N = mkN "intransigenza" ; -- UWN
lin intransitive_A = mkA "intransitivo" ; -- status=guess
lin intra_uterine_A = mkA "intrauterino" ; -- status=guess
lin intravenous_A = mkA "intravenoso" ; -- status=guess
lin intrepid_A = mkA "audace" ; -- UWN
lin intrepidity_N = mkN "intrepidezza" ; -- UWN
lin intricacy_N = mkN "elaboratezza" ; -- UWN
lin intricate_A = mkA "intricato" ; -- status=guess
lin intrinsic_A = mkA "intrinseco" ; -- status=guess
lin intro_N = mkN "intro" ; -- status=guess
lin introduce_V2 = variants {} ; --
lin introduction_N = mkN "introduzione" feminine ; -- status=guess
lin introspection_N = mkN "introspezione" ; -- UWN
lin introversion_N = mkN "introversione" ; -- UWN
lin intruder_N = mkN "intruso" ; -- status=guess
lin intrusion_N = mkN "intrusione" feminine ; -- status=guess
lin intrusiveness_N = mkN "invadenza" ; -- UWN
lin intuition_N = mkN "intuito" ; -- status=guess
lin intuitionism_N = mkN "intuitivismo" | mkN "intuizionismo" ; -- UWN
lin intuitive_A = mkA "intuitivo" ; -- status=guess
lin inula_N = mkN "inula" ; -- UWN
lin inulin_N = mkN "inulina" ; -- UWN
lin inundate_V2 = mkV2 (mkV "inondare") ; -- status=guess, src=wikt
lin inundation_N = mkN "inondazione" feminine | mkN "allagamento" | mkN "alluvione" masculine ; -- status=guess status=guess status=guess
lin inure_V2 = mkV2 (assuefare_V) | mkV2 (mkV "abituare") | mkV2 (mkV "acclimare") | mkV2 (mkV "acclimatare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin invade_V2 = mkV2 (mkV "invadere") ; -- status=guess, src=wikt
lin invader_N = mkN "invaditore" | mkN "invasore" ; -- UWN
lin invalid_N = mkN "infermo" | mkN "invalido" | mkN "mutilato" ; -- UWN
lin invalidation_N = mkN "annullamento" | mkN "invalidamento" | mkN "invalidazione" | mkN "risoluzione" ; -- UWN
lin invalidity_N = mkN "invalidità" ; -- UWN
lin invaluable_A = mkA "inestimabile" ; -- UWN
lin invaluableness_N = mkN "preziosità" ; -- UWN
lin invariability_N = mkN "invarianza" ; -- UWN
lin invariable_A = mkA "invariabile" ; -- UWN
lin invasion_N = mkN "invasione" | mkN "calata" ; -- status=guess status=guess
lin invasive_A = mkA "invasivo" ; -- status=guess
lin invective_N = mkN "filippica" ; -- UWN
lin inveigle_V2 = mkV2 (mkV "adescare") | mkV2 (mkV "allettare") ; -- status=guess, src=wikt status=guess, src=wikt
lin invent_V = mkV "inventare" ; -- status=guess, src=wikt
lin invent_V2 = mkV2 (mkV "inventare") ; -- status=guess, src=wikt
lin invention_N = mkN "inventione" | mkN "invenzione" feminine ; -- status=guess status=guess
lin inventive_A = mkA "inventivo" ; -- status=guess
lin inventiveness_N = mkN "fantasia" | mkN "inventiva" ; -- UWN
lin inventor_N = mkN "inventore" ; -- UWN
lin inventory_N = mkN "inventario" ; -- status=guess
lin inverkeithing_PN = mkPN "Inverkeithing" ; -- status=guess src=geonames
lin inverness_PN = mkPN "Inverness" ; -- status=guess src=geonames
lin inverse_N = mkN "funzione inversa" ; -- status=guess
lin invertebrate_A = mkA "invertebrato" ; -- status=guess
lin invertebrate_N = mkN "invertebrato" ; -- status=guess
lin inverter_N = mkN "invertitore" ; -- UWN
lin inverurie_PN = mkPN "Inverurie" ; -- status=guess src=geonames
lin invest_V = mkV "investire" ; -- status=guess, src=wikt
lin invest_V2 = mkV2 (mkV "investire") ; -- status=guess, src=wikt
lin investigate_V = mkV "investigare" ; -- status=guess, src=wikt
lin investigate_V2 = mkV2 (mkV "investigare") ; -- status=guess, src=wikt
lin investigation_N = mkN "investigazione" feminine ; -- status=guess
lin investigator_N = mkN "detective" | mkN "investigatore" ; -- UWN
lin investing_N = mkN "investimento" ; -- UWN
lin investiture_N = mkN "investitura" ; -- status=guess
lin investment_N = mkN "investimento" ; -- status=guess
lin investor_N = mkN "investitore" masculine ; -- status=guess
lin invigilation_N = mkN "assistenza" ; -- UWN
lin invincibility_N = mkN "imbattibilità" | mkN "invincibilità" ; -- UWN
lin invincible_A = mkA "invincibile" ; -- status=guess
lin invisibility_N = mkN "invisibilità" ; -- UWN
lin invisible_A = mkA "invisibile" ; -- status=guess
lin invitation_N = mkN "invitazione" feminine | mkN "invito" ; -- status=guess status=guess
lin invite_N = mkN "invito" ; -- status=guess
lin invite_V2 = mkV2 (mkV "invitare") ; -- status=guess, src=wikt
lin invite_V2V = mkV2V (mkV "invitare") ; -- status=guess, src=wikt
lin invite_in_V = advV (lin V OP_invite_V2) OP_in_Adv ; -- guess-p-verb
lin invocation_N = mkN "invocazione" ; -- UWN
lin invoice_N = mkN "fattura" ; -- status=guess
lin invoke_V2 = variants {} ; --
lin involucre_N = mkN "involucro" ; -- status=guess
lin involution_N = mkN "involuzione" feminine ; -- status=guess
lin involve_V = variants {} ; --
lin involve_V2 = variants {} ; --
lin involve_VS = variants {} ; --
lin involved_A = variants {} ; --
lin involvement_N = mkN "coinvolgimento" | mkN "impegno" | mkN "intervento" | mkN "partecipazione" ; -- UWN
lin invulnerable_A = mkA "invulnerabile" ; -- UWN
lin iodide_N = mkN "ioduro" ; -- status=guess
lin iodinated_A = mkA "iodato" ; -- UWN
lin iodine_N = mkN "iodio" ; -- status=guess
lin iodoform_N = mkN "iodoformio" ; -- status=guess
lin ion_N = mkN "ione" masculine ; -- status=guess
lin ionic_A = mkA "ionico" ; -- status=guess
lin ionization_N = mkN "ionizzazione" ; -- UWN
lin ionize_V = mkV "ionizzare" ; -- status=guess, src=wikt
lin ionize_V2 = mkV2 (mkV "ionizzare") ; -- status=guess, src=wikt
lin ionosphere_N = mkN "ionosfera" ; -- status=guess
lin iota_N = mkN "iota" ; -- status=guess
lin iowa_PN = mkPN "Iowa" ; -- status=guess src=geonames
lin ipecac_N = mkN "ipecacuana" ; -- UWN
lin ipswich_PN = mkPN "Ipswich" ; -- status=guess src=geonames
lin iran_PN = mkPN "Iran" ; -- status=guess src=geonames
lin iranianFem_N = variants {} ; ---- sense to be split
lin iranianMasc_N = variants {} ; ---- sense to be split
lin iraq_PN = mkPN "Iraq" ; -- status=guess src=geonames
lin irascibility_N = mkN "stizza" ; -- UWN
lin irascible_A = mkA "irascibile" ; -- status=guess
lin ire_N = mkN "ira" ; -- status=guess
lin ireland_PN = mkPN "Irlanda" ; -- status=guess src=geonames
lin irenic_A = mkA "irenico" ; -- status=guess
lin iridescence_N = mkN "opalescenza" ; -- UWN
lin iridescent_A = mkA "iridescente" ; -- status=guess
lin iridium_N = mkN "iridio" ; -- status=guess
lin iris_N = mkN "muscolo dilatatore dell'iride" ; -- status=guess
lin irishFem_N = variants {} ; ---- sense to be split
lin irishMasc_N = variants {} ; ---- sense to be split
lin irk_V2 = mkV2 (mkV "infastidiare") ; -- status=guess, src=wikt
lin iron_N = L.iron_N ;
lin iron_V = mkV "stirare" ; -- status=guess, src=wikt
lin iron_V2 = mkV2 (mkV "stirare") ; -- status=guess, src=wikt
lin iron_out_V = mkV "appianare" | mkV "sanare" ; -- UWN
lin ironclad_N = mkN "corazzata" ; -- status=guess
lin ironic_A = mkA "ironico" ; -- status=guess
lin ironical_A = variants {} ;
lin ironing_N = mkN "lo stirare" | mkN "stiro" ; -- status=guess status=guess
lin ironmonger_N = mkN "ferramenta" ; -- UWN
lin ironware_N = mkN "ferrame" | mkN "ferramenta" ; -- UWN
lin ironwork_N = mkN "ferrame" masculine ; -- status=guess
lin ironworks_N = mkN "ferriera" ; -- status=guess
lin irony_N = mkN "ironia" ; -- status=guess
lin irradiation_N = mkN "X-terapia" | mkN "gammaterapia" | mkN "radioterapia" | mkN "radiumterapia" | mkN "roentgenterapia" | mkN "röntgenterapia" ; -- UWN
lin irrational_A = mkA "irrazionale" ; -- status=guess
lin irreconcilable_A = mkA "irreconciliabile" ; -- status=guess
lin irredentism_N = mkN "irredentismo" ; -- status=guess
lin irredentist_N = mkN "irredentista" ; -- UWN
lin irrefutable_A = mkA "irrefutabile" ; -- status=guess
lin irrelevant_A = mkA "irrilevante" ; -- status=guess
lin irreligious_A = mkA "irreligioso" ; -- UWN
lin irreligiousness_N = mkN "irreligione" | mkN "irreligiosità" ; -- UWN
lin irremediable_A = mkA "irrimediabile" ; -- status=guess
lin irreplaceable_A = mkA "insostituibile" ; -- status=guess
lin irrepressible_A = mkA "insopprimibile" ; -- status=guess
lin irresistible_A = mkA "irresistibile" ; -- status=guess
lin irresolute_A = mkA "dubbioso" | mkA "esitante" | mkA "incerto" | mkA "insicuro" | mkA "irresoluto" | mkA "irrisoluto" | mkA "peritoso" | mkA "tentennante" | mkA "titubante" ; -- UWN
lin irresoluteness_N = mkN "irresolutezza" | mkN "irresoluzione" | mkN "irrisolutezza" | mkN "irrisoluzione" ; -- UWN
lin irrespective_A = variants {} ; --
lin irresponsibility_N = mkN "incoscienza" | mkN "irresponsabilità" ; -- UWN
lin irresponsible_A = mkA "irresponsabile" ; -- UWN
lin irreversibility_N = mkN "irreversibilità" ; -- UWN
lin irreversible_A = mkA "inarrestabile" | mkA "irreversibile" ; -- UWN
lin irrevocable_A = mkA "inappellabile" | mkA "irrevocabile" ; -- UWN
lin irrigation_N = mkN "irrigazione" feminine ; -- status=guess
lin irritate_V2 = mkV2 (mkV "irritare") ; -- status=guess, src=wikt
lin irritating_A = mkA "fastidioso" | mkA "irritante" | mkA "seccante" ; -- UWN
lin irritation_N = mkN "angheria" | mkN "dispetto" | mkN "disturbo" | mkN "irritazione" | mkN "molestia" ; -- UWN
lin irruption_N = mkN "irruzione" ; -- UWN
lin irthlingborough_PN = mkPN "Irthlingborough" ; -- status=guess src=geonames
lin irvine_PN = mkPN "Irvine" ; -- status=guess src=geonames
lin isabel_PN = mkPN "Isabel" ; -- status=guess src=geonames
lin ischium_N = mkN "ischio" ; -- UWN
lin isinglass_N = mkN "mica" ; -- UWN
lin island_N = mkN "isola" ; -- status=guess
lin islet_N = mkN "isolotto" | mkN "isoletta" ; -- status=guess status=guess
lin islington_PN = mkPN "Islington" ; -- status=guess src=geonames
lin isobar_N = mkN "isobara" ; -- status=guess
lin isogon_N = mkN "isogona" ; -- status=guess
lin isolate_V2 = mkV2 (mkV "isolare") ; -- status=guess, src=wikt
lin isolated_A = variants {} ; --
lin isolation_N = mkN "isolamento" ; -- status=guess
lin isolationism_N = mkN "isolazionismo" ; -- status=guess
lin isolationist_A = mkA "isolazionistico" | mkA "isolazionista" ; -- status=guess status=guess
lin isolationist_N = mkN "isolazionista or" ; -- status=guess
lin isomer_N = mkN "isomero" ; -- status=guess
lin isomerase_N = mkN "isomerasi" feminine ; -- status=guess
lin isomeric_A = mkA "isomerico" ; -- status=guess
lin isomerism_N = mkN "isomeria" ; -- status=guess
lin isomerization_N = mkN "isomerizzazione" feminine ; -- status=guess
lin isometric_A = mkA "isometrico" ; -- status=guess
lin isometry_N = mkN "isometria" ; -- status=guess
lin isomorphism_N = mkN "isomorfismo" ; -- status=guess
lin isomorphous_A = mkA "isomorfico" | mkA "isomorfo" ; -- UWN
lin isopod_N = mkN "isopode" masculine ; -- status=guess
lin isosceles_A = mkA "isoscele" | mkA "equicrure" ; -- status=guess status=guess
lin isotherm_N = mkN "isoterma" ; -- status=guess
lin isothermic_A = mkA "isotermico" ; -- status=guess
lin isotonic_A = mkA "isotonico" ; -- status=guess
lin isotope_N = mkN "isotopo" ; -- status=guess
lin isotopic_A = mkA "isotopico" | mkA "isotopo" ; -- UWN
lin isotropic_A = mkA "isotropo" ; -- UWN
lin isotropy_N = mkN "isotropia" ; -- status=guess
lin israel_PN = mkPN "Israele" ; -- status=guess src=geonames
lin issue_1_N = mkN "problema" | mkN "questione" ; -- UWN
lin issue_2_N = mkN "fascicolo" | mkN "numero" ; -- UWN
lin issue_N = mkN "emissione" feminine | mkN "fuoriuscita" ; -- status=guess status=guess
lin issue_V = mkV "fuoriuscire" | mkV "fuoruscire" | mkV "sfogare" ; -- UWN
lin issue_V2 = variants {} ; --
lin issue_forth_V = advV OP_issue_V OP_forth_Adv ; -- guess-p-verb
lin issuer_N = mkN "emittente" ; -- UWN
lin isthmus_N = mkN "istmo" | mkN "braccio di terra" ; -- status=guess status=guess
lin it_Pron = S.it_Pron ;
lin italianFem_N = mkN "italiana" ;
lin italianMasc_N = mkN "italiano" ;
lin italian_A = mkA "italiano" ;
lin italic_A = mkA "corsivo" | mkA "corsiva" ; -- status=guess status=guess
lin italy_PN = mkPN "il Bel Paese" ; -- status=guess src=geonames
lin itch_N = mkN "prurito" ; -- status=guess
lin itch_V = mkV "prudere" ; -- status=guess, src=wikt
lin item_Adv = mkAdv "item" ; -- UWN
lin item_N = mkN "articolo" | mkN "elemento" ; -- status=guess status=guess
lin iteration_N = mkN "iterazione" feminine ; -- status=guess
lin iterative_A = mkA "iterativo" ; -- status=guess
lin itinerant_A = mkA "itinerante" ; -- status=guess
lin iver_PN = mkPN "Iver" ; -- status=guess src=geonames
lin ivory_N = mkN "avorio" ; -- status=guess
lin ivy_N = mkN "edera" ; -- status=guess
lin jabalpur_PN = mkPN "Jabalpur" ; -- status=guess src=geonames
lin jabot_N = mkN "jabot" ; -- UWN
lin jacamar_N = mkN "galbula" ; -- UWN
lin jack_N = mkN "cric" masculine ; -- status=guess
lin jack_V2 = variants {} ;
lin jackal_N = mkN "sciacallo" ; -- status=guess
lin jackanapes_N = mkN "sfrontatello" ; -- UWN
lin jackass_N = mkN "asino" ; -- status=guess
lin jackdaw_N = mkN "taccola" ; -- status=guess
lin jacket_N = mkN "giacca" ; -- status=guess
lin jackfruit_N = mkN "frutto_dell'albero_del_pane" ; -- UWN
lin jacksonville_PN = mkPN "Jacksonville" ; -- status=guess src=geonames
lin jade_N = mkN "giada" ; -- status=guess
lin jaeger_N = mkN "stercorario" ; -- UWN
lin jaguar_N = mkN "giaguaro" ; -- status=guess
lin jail_N = variants {} ; --
lin jail_V2 = variants {} ; --
lin jailer_N = mkN "carceriere" | mkN "custode" masculine | mkN "guardiano" | mkN "secondino" | mkN "sorvegliante" masculine | mkN "guardia carceraria" | mkN "aguzzino" ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin jaipur_PN = mkPN "Jaipur" ; -- status=guess src=geonames
lin jakarta_PN = mkPN "Giacarta" ; -- status=guess src=geonames
lin jalousie_N = mkN "gelosia" | mkN "imposta" | mkN "persiana" ; -- UWN
lin jam_N = mkN "ingorgo" ; -- status=guess
lin jamaica_PN = mkPN "Giamaica" ; -- status=guess src=geonames
lin jamb_N = mkN "stipite" ; -- UWN
lin jamboree_N = mkN "baldoria" ;
lin jamjar_N = mkN "barattolo della marmellata" ; -- status=guess
lin janissary_N = mkN "giannizzero" ; -- status=guess
lin japan_PN = mkPN "Giappone" ; -- status=guess src=geonames
lin japaneseFem_N = variants {} ; ---- sense to be split
lin japaneseMasc_N = variants {} ; ---- sense to be split
lin jar_N = mkN "teglia" | mkN "vaso" | mkN "giara" ; -- status=guess status=guess status=guess
lin jarful_N = mkN "barattolo" ; -- UWN
lin jargon_N = mkN "gergo" ; -- status=guess
lin jargoon_N = mkN "giargone" ; -- UWN
lin jarrow_PN = mkPN "Jarrow" ; -- status=guess src=geonames
lin jasmine_N = mkN "gelsomino" ; -- status=guess
lin jasper_N = mkN "diaspro" ; -- status=guess
lin jaundice_N = mkN "itterizia" | mkN "ittero" ; -- status=guess status=guess
lin jaunt_N = mkN "escursione" | mkN "gita" | mkN "scorribanda" | mkN "uscita" | mkN "viaggetto" ; -- UWN
lin jaunty_A = mkA "disinvolto" ; -- UWN
lin java_PN = mkPN "Java" ; -- status=guess src=geonames
lin javelin_N = mkN "giavellotto" ; -- status=guess
lin jaw_N = mkN "mandibola" ; -- status=guess
lin jay_N = mkN "ghiandaia" ; -- status=guess
lin jazz_N = mkN "jazz" masculine ; -- status=guess
lin jealous_A = mkA "geloso" | mkA "gelosa" ; -- status=guess status=guess
lin jealousy_N = mkN "gelosia" ; -- status=guess
lin jean_N = mkN "denim" ; -- UWN
lin jeans_N = variants {} ; --
lin jedburgh_PN = mkPN "Jedburgh" ; -- status=guess src=geonames
lin jeep_N = mkN "campagnola" | mkN "fuoristrada" | mkN "jeep" ; -- UWN
lin jeer_N = mkN "scherno" ; -- status=guess
lin jejunum_N = mkN "digiuno" ; -- status=guess
lin jelly_N = mkN "jelly belly" ; -- status=guess
lin jellyfish_N = mkN "medusa" ; -- status=guess
lin jeopardize_V2 = mkV2 (mkV (mettere_V) "a rischio") ; -- status=guess, src=wikt
lin jeopardy_N = mkN "pericolo" ; -- status=guess
lin jerk_N = mkN "strattone" masculine | mkN "strappo" ; -- status=guess status=guess
lin jerk_V = mkV (mkV "farsi") "una sega" ; -- status=guess, src=wikt
lin jerk_V2 = mkV2 (mkV (mkV "farsi") "una sega") ; -- status=guess, src=wikt
lin jerkin_N = mkN "farsetto" ; -- UWN
lin jerkiness_N = mkN "irregolarità" ; -- UWN
lin jerky_A = mkA "accidentato" ; -- status=guess
lin jerome_PN = mkPN "Jerome" ; -- status=guess src=geonames
lin jersey_N = mkN "maglia" ; -- status=guess
lin jersey_PN = mkPN "Jersey" ; -- status=guess src=geonames
lin jest_N = mkN "scherzo" | mkN "barzelletta" | mkN "battuta" ; -- status=guess status=guess status=guess
lin jester_N = mkN "giullare" | mkN "buffone" masculine ; -- status=guess status=guess
lin jet_N = mkN "aerogetto" | mkN "aviogetto" | mkN "getto" | mkN "jet" | mkN "reattore" ; -- UWN
lin jetty_N = mkN "cornicione" masculine | mkN "pensilina" ; -- status=guess status=guess
lin jew_N = variants {} ; --
lin jewel_N = mkN "gemma" ; -- status=guess
lin jeweller_N = mkN "oreficeria" ; -- status=guess
lin jewellery_N = mkN "gioielleria" | mkN "silver and gemstone)" | mkN "bigiotteria" ; -- status=guess status=guess status=guess
lin jewelry_N = mkN "oreficeria" ; -- UWN
lin jiao_N = mkN "yuan" | mkN "yuan_cinese" | mkN "yuan_renminb" ; -- UWN
lin jib_N = mkN "fiocco" | mkN "flocco" | mkN "mezzavela" | mkN "polaccone" ; -- UWN
lin jiffy_N = mkN "attimo" | mkN "baleno" ; -- status=guess status=guess
lin jigsaw_N = mkN "puzzle" ; -- status=guess
lin jihad_N = mkN "jihad" feminine ; -- status=guess
lin jinn_N = mkN "jinn" masculine ; -- status=guess
lin jitney_N = mkN "autobus" | mkN "autocorriera" | mkN "autopullman" | mkN "autopulman" | mkN "corriera" | mkN "pullman" | mkN "torpedone" ; -- UWN
lin jittery_A = mkA "nervoso" ; -- status=guess
lin joanna_PN = mkPN "Joanna" ; -- status=guess src=geonames
lin job_N = mkN "descrizione di posizione" feminine ; -- status=guess
lin job_PN = mkPN "Job" ; -- status=guess src=geonames
lin jobber_N = mkN "blocchista" | mkN "grossista" | mkN "intermediario" | mkN "jobber" ; -- UWN
lin jockey_N = mkN "fantino" | mkN "jockey" ; -- UWN
lin jocoseness_N = mkN "giocosità" | mkN "spassosità" ; -- UWN
lin jocosity_N = mkN "giocosità" | mkN "spassosità" ; -- UWN
lin jocularity_N = mkN "baia" | mkN "beffa" | mkN "burla" | mkN "burletta" | mkN "canzonatura" | mkN "celia" | mkN "scherzo" ; -- UWN
lin jocund_A = mkA "allegro" ; -- UWN
lin jogging_N = mkN "jogging" masculine ; -- status=guess
lin johannesburg_PN = mkPN "Johannesburg" ; -- status=guess src=geonames
lin john_PN = L.john_PN ; -- comment=CHECKED
lin johnstone_PN = mkPN "Johnstone" ; -- status=guess src=geonames
lin join_V = mkV "aderire" | mkV (mkV "entrare") "a far parte" ; -- status=guess, src=wikt status=guess, src=wikt
lin join_V2 = mkV2 (mkV "aderire") | mkV2 (mkV (mkV "entrare") "a far parte") ; -- status=guess, src=wikt status=guess, src=wikt
lin join_up_V = advV OP_join_V OP_up_Adv ; -- guess-p-verb
lin joiner_N = mkN "falegname" masculine ; -- status=guess
lin joinery_N = mkN "falegnameria" ; -- UWN
lin joining_N = mkN "congiungimento" | mkN "unione" ; -- UWN
lin joint_A = variants {} ; --
lin joint_N = mkN "conto congiunto" ; -- status=guess
lin jointure_N = mkN "unificazione" | mkN "unione" ; -- UWN
lin joke_N = mkN "barzelletta" | mkN "battuta scherzo" ; -- status=guess status=guess
lin joke_V = mkV "scherzare" ; -- status=guess, src=wikt
lin joker_N = mkN "buffone" masculine ; -- status=guess
lin jolly_A = mkA "allegro" ; -- UWN
lin jonquil_N = mkN "giunchiglia" ; -- status=guess
lin jordan_PN = mkPN "Giordania" ; -- status=guess src=geonames
lin joseph_PN = mkPN "Joseph" ; -- status=guess src=geonames
lin joshua_PN = mkPN "Joshua" ; -- status=guess src=geonames
lin jostle_V = mkV "spingere" | mkV (mkV "farsi") "largo" ; -- status=guess, src=wikt status=guess, src=wikt
lin jostle_V2 = mkV2 (mkV "spingere") | mkV2 (mkV (mkV "farsi") "largo") ; -- status=guess, src=wikt status=guess, src=wikt
lin jotter_N = mkN "carnet" | mkN "taccuino" ; -- UWN
lin joule_N = mkN "joule" masculine ; -- status=guess
lin journal_N = mkN "perno d'albero" ; -- status=guess
lin journalism_N = mkN "giornalismo" ; -- status=guess
lin journalist_N = mkN "giornalista" masculine ; -- status=guess
lin journalistic_A = mkA "giornalistico" ; -- UWN
lin journey_N = mkN "viaggio" ; -- status=guess
lin journey_V = mkV "viaggiare" ; -- status=guess, src=wikt
lin joust_V = mkV "giostrare" ; -- UWN
lin jovial_A = mkA "allegro" ; -- UWN
lin jowl_N = mkN "guancia" | mkN "mascella" ; -- status=guess status=guess
lin joy_N = mkN "gioia" ; -- status=guess
lin joy_V = mkV "allietare" | mkV "rallegrare" ; -- UWN
lin joyous_A = mkA "gioioso" ; -- UWN
lin joy_stick_N = mkN "barra di comando" ; -- status=guess
lin jubilee_N = mkN "giubileo" ; -- status=guess
lin judder_V = mkV "scrollare" ; -- status=guess, src=wikt
lin judge_N = mkN "giudice" ; -- status=guess
lin judge_V = mkV "giudicare" ; -- status=guess, src=wikt
lin judge_V2 = mkV2 (mkV "giudicare") ; -- status=guess, src=wikt
lin judge_VS = mkVS (mkV "giudicare") ; -- status=guess, src=wikt
lin judgement_N = mkN "il giorno del giudizio universale" ; -- status=guess
lin judgment_N = mkN "giuizio" ; -- status=guess
lin judicature_N = mkN "tribunale" feminine ; -- status=guess
lin judicial_A = mkA "giudiziale" | mkA "giudiziario" ; -- status=guess status=guess
lin judiciary_N = mkN "magistratura" ; -- UWN
lin judiciousness_N = mkN "acume" | mkN "perspicacia" | mkN "sagacia" ; -- UWN
lin judo_N = mkN "jujitsu" | mkN "giudò" | mkN "judo" ; -- status=guess status=guess status=guess
lin jug_N = mkN "bricco" | mkN "brocca" | mkN "bottiglione" | mkN "bidone" masculine ; -- status=guess status=guess status=guess status=guess
lin jug_V2 = mkV2 (mkV "arrestare") ; -- status=guess, src=wikt
lin jugful_N = mkN "boccale" | mkN "brocca" ; -- UWN
lin juggle_V = mkV "giocolare" ; -- status=guess, src=wikt
lin juggle_V2 = mkV2 (mkV "giocolare") ; -- status=guess, src=wikt
lin jugglerMasc_N = mkN "giocoliere" masculine ; -- status=guess
lin jugglerFem_N = mkN "giocoliere" masculine ; -- status=guess
lin jugular_A = mkA "giugulare" | mkA "iugulare" ; -- UWN
lin juice_1_N = mkN "succo" | mkN "spremuta" ; -- status=guess status=guess
lin juice_2_N = mkN "succo" | mkN "spremuta" ; -- status=guess status=guess
lin juiciness_N = mkN "gustosità" | mkN "succosità" | mkN "succulenza" | mkN "sugosità" ; -- UWN
lin juicy_A = mkA "sugoso" | mkA "sugosa" ; -- status=guess status=guess
lin juju_N = mkN "feticcio" ; -- UWN
lin jujube_N = mkN "giuggiola" ; -- status=guess
lin jujutsu_N = mkN "jujitsu" ; -- UWN
lin jukebox_N = mkN "juke-box" masculine ; -- status=guess
lin julian_PN = mkPN "Julian" ; -- status=guess src=geonames
lin jump_N = mkN "salto" ; -- status=guess
lin jump_V = L.jump_V ;
lin jump_V2 = mkV2 (mkV "saltare") ; -- status=guess, src=wikt
lin jump_at_V2 = prepV2 OP_jump_V OP_at_Prep ; -- guess-p-verb
lin jump_in_V = advV OP_jump_V OP_in_Adv ; -- guess-p-verb
lin jump_on_V2 = prepV2 OP_jump_V OP_on_Prep ; -- guess-p-verb
lin jump_to_V2 = prepV2 OP_jump_V OP_to_Prep ; -- guess-p-verb
lin jumper_N = mkN "jumper" masculine ; -- status=guess
lin jun_PN = mkPN "Jun" ; -- status=guess src=geonames
lin junction_N = variants {} ; --
lin juncture_N = mkN "occasione" ; -- UWN
lin jungle_N = mkN "giungla" ; -- status=guess
lin junior_A = variants {} ; --
lin juniper_N = mkN "ginepro" ; -- status=guess
lin junk_N = mkN "titolo spazzatura" ; -- status=guess
lin junk_V2 = mkV2 (mkV "rottamare") ; -- status=guess, src=wikt
lin junket_N = mkN "gita" | mkN "passeggiata" ; -- status=guess status=guess
lin junket_V = mkV "bagordare" | mkV "banchettare" | mkV "bisbocciare" | mkV "convitare" | mkV "convivare" | mkV "crapulare" | mkV "gozzovigliare" ; -- UWN
lin junta_N = mkN "giunta" ; -- status=guess
lin jupiter_PN = mkPN "Jupiter" ; -- status=guess src=geonames
lin jurisdiction_N = mkN "giurisdizione" feminine ; -- status=guess
lin jurisdictional_A = mkA "giurisdizionale" ; -- status=guess
lin jurisprudential_A = mkA "giurisprudenziale" ; -- status=guess
lin juror_N = mkN "giurato" ; -- status=guess
lin jury_N = mkN "giuria" ; -- status=guess
lin just_A = variants {} ; --
lin just_AdV = mkAdV "appena" | mkAdV "giusto" | mkAdV "proprio" | mkAdV "semplicemente" | mkAdV "solamente" | mkAdV "solo" | mkAdV "soltanto" ; -- UWN
lin just_Adv = mkAdv "or ora" ; -- status=guess
lin justice_N = mkN "giustizia" ; -- status=guess
lin justification_N = mkN "giustificazione" feminine | mkN "ragione" feminine | mkN "spiegazione" feminine | mkN "scusa" ; -- status=guess status=guess status=guess status=guess
lin justified_A = variants {} ; --
lin justify_V2 = mkV2 (mkV "giustificare") ; -- status=guess, src=wikt
lin justify_VV = mkVV (mkV "giustificare") ; -- status=guess, src=wikt
lin justin_PN = mkPN "Justin" ; -- status=guess src=geonames
lin jut_V = sporgere_V ; -- status=guess, src=wikt
lin jute_N = mkN "iuta" | mkN "juta" ; -- UWN
lin juvenile_A = mkA "minorile" ; -- UWN
lin kabob_N = mkN "spiedino" ; -- UWN
lin kaki_N = mkN "cachi" masculine ; -- status=guess
lin kale_N = mkN "cavolo" ; -- status=guess
lin kaleidoscope_N = mkN "caleidoscopio" ; -- status=guess
lin kalemia_N = mkN "kaliemia" ; -- status=guess
lin kamikaze_N = mkN "kamikaze" ; -- UWN
lin kangaroo_N = mkN "canguro" ; -- status=guess
lin kaohsiung_PN = mkPN "Kaohsiung" ; -- status=guess src=geonames
lin kaolin_N = mkN "caolino" ; -- status=guess
lin kaolinite_N = mkN "caolinite" feminine ; -- status=guess
lin kaon_N = mkN "kaone" masculine ; -- status=guess
lin kapok_N = mkN "capoc" masculine ; -- status=guess
lin karachi_PN = mkPN "Karachi" ; -- status=guess src=geonames
lin karat_N = mkN "carato" ; -- UWN
lin karate_N = mkN "karatè" ; -- UWN
lin karlsruhe_PN = mkPN "Karlsruhe" ; -- status=guess src=geonames
lin karma_N = mkN "karma" ; -- UWN
lin karyotype_N = mkN "cariotipo" ; -- status=guess
lin kassel_PN = mkPN "Kassel" ; -- status=guess src=geonames
lin katherine_PN = mkPN "Katherine" ; -- status=guess src=geonames
lin katowice_PN = mkPN "Katowice" ; -- status=guess src=geonames
lin kazan_PN = mkPN "Kazan'" ; -- status=guess src=geonames
lin kea_N = mkN "kea" masculine ; -- status=guess
lin kebab_N = mkN "spiedino" ; -- UWN
lin keel_N = mkN "carena" | mkN "chiglia" ; -- status=guess status=guess
lin keelson_N = mkN "falsachiglia" ; -- status=guess
lin keen_A = mkA "acuto" | mkA "penetrante" | mkA "sottile" ; -- UWN
lin keen_V = mkV "deplorare" | mkV "deprecare" | mkV "lamentare" | mkV "piangere" ; -- UWN
lin keep_N = mkN "torrione" masculine ; -- status=guess
lin keep_V = tenere_V ;
lin keep_V2 = mkV2 tenere_V ;
lin keep_V2A = mkV2A tenere_V ;
lin keep_VV = mkVV tenere_V ;
lin keep_around_V2 = prepV2 OP_keep_V OP_around_Prep ; -- guess-p-verb
lin keep_at_V2 = prepV2 OP_keep_V OP_at_Prep ; -- guess-p-verb
lin keep_away_V2 = mkV2 (advV OP_keep_V OP_away_Adv ) ; -- guess-p-verb
lin keep_back_V = mkV "trattenere" ; -- UWN
lin keep_back_V2 = mkV2 (advV OP_keep_V OP_back_Adv ) ; -- guess-p-verb
lin keep_down_V2 = prepV2 OP_keep_V OP_down_Prep ; -- guess-p-verb
lin keep_from_V2 = prepV2 OP_keep_V OP_from_Prep ; -- guess-p-verb
lin keep_in_V2 = prepV2 OP_keep_V OP_in_Prep ; -- guess-p-verb
lin keep_ing_V2V = variants {} ; -- guess-p-verb
lin keep_off_V2 = prepV2 OP_keep_V OP_off_Prep ; -- guess-p-verb
lin keep_on_V = advV OP_keep_V OP_on_Adv ; -- guess-p-verb
lin keep_on_V2 = prepV2 OP_keep_V OP_on_Prep ; -- guess-p-verb
lin keep_out_V = advV OP_keep_V OP_out_Adv ; -- guess-p-verb
lin keep_out_V2 = prepV2 OP_keep_V OP_out_Prep ; -- guess-p-verb
lin keep_over_V2 = prepV2 OP_keep_V OP_over_Prep ; -- guess-p-verb
lin keep_to_V2 = prepV2 OP_keep_V OP_to_Prep ; -- guess-p-verb
lin keep_to_V2V = variants {} ; -- guess-p-verb
lin keep_up_V = advV OP_keep_V OP_up_Adv ; -- guess-p-verb
lin keep_up_V2 = prepV2 OP_keep_V OP_up_Prep ; -- guess-p-verb
lin keep_up_at_V2 = prepV2 (advV OP_keep_V OP_up_Adv ) OP_at_Prep ; -- guess-p-verb
lin keep_up_with_V2 = prepV2 (advV OP_keep_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin keeper_N = mkN "portiere" masculine ; -- status=guess
lin keeping_N = mkN "mantenimento" ; -- UWN
lin keepsake_N = mkN "ricordo" | mkN "memoria" | mkN "memento" ; -- status=guess status=guess status=guess
lin keg_N = mkN "fusto" | mkN "barile" masculine ; -- status=guess status=guess
lin keighley_PN = mkPN "Keighley" ; -- status=guess src=geonames
lin keith_PN = mkPN "Keith" ; -- status=guess src=geonames
lin kelp_N = mkN "fuco" ; -- UWN
lin kelso_PN = mkPN "Kelso" ; -- status=guess src=geonames
lin kelty_PN = mkPN "Kelty" ; -- status=guess src=geonames
lin kemsing_PN = mkPN "Kemsing" ; -- status=guess src=geonames
lin kendal_PN = mkPN "Kendal" ; -- status=guess src=geonames
lin kenilworth_PN = mkPN "Kenilworth" ; -- status=guess src=geonames
lin kennel_N = mkN "canile" | mkN "cuccia" ; -- status=guess status=guess
lin kensington_PN = mkPN "Kensington" ; -- status=guess src=geonames
lin kent_PN = mkPN "Kent" ; -- status=guess src=geonames
lin kenya_PN = mkPN "Kenya" ; -- status=guess src=geonames
lin kepi_N = mkN "kepi" | mkN "chepì" | mkN "cheppì" masculine ; -- status=guess status=guess status=guess
lin keratin_N = mkN "cheratina" ; -- status=guess
lin keratoplasty_N = mkN "cheratoplastica" ; -- UWN
lin kerb_N = mkN "orlo del marciapiede" ; -- status=guess
lin kerbstone_N = mkN "paracarro" ; -- UWN
lin kernel_N = mkN "gheriglio" ; -- status=guess
lin kerosene_N = mkN "cherosene" masculine ; -- status=guess
lin kerygma_N = mkN "kerygma" ; -- UWN
lin kestrel_N = mkN "gheppio" ; -- status=guess
lin ketchup_N = mkN "ketchup" ; -- UWN
lin ketone_N = mkN "chetone" masculine ; -- status=guess
lin kettering_PN = mkPN "Kettering" ; -- status=guess src=geonames
lin kettle_N = mkN "bollitore" masculine ; -- status=guess
lin kettledrum_N = mkN "timpano" ; -- UWN
lin key_1_N = variants {} ; --
lin key_2_N = mkN "tonalità" ; -- UWN
lin key_3_N = mkN "tasto" ; -- status=guess ---- sense to be split
lin key_A = mkA "chiave" ; -- status=guess
lin key_N = mkN "tasto" ; -- status=guess
lin keyboard_N = mkN "tastiera" ; -- status=guess
lin keyhole_N = mkN "buco_della_serratura" | mkN "serratura" | mkN "toppa" ; -- UWN
lin keynsham_PN = mkPN "Keynsham" ; -- status=guess src=geonames
lin keystone_N = mkN "chiave di volta" ; -- status=guess
lin keyword_N = mkN "parola chiave" ; -- status=guess
lin kg_N = mkN "chilo" | mkN "chilogrammo" | mkN "kg" | mkN "kilogrammo" ; -- UWN
lin khaki_A = mkA "cachi" ; -- status=guess
lin khaki_N = mkN "cachi" masculine ; -- status=guess
lin khan_N = mkN "caravanserraglio" ; -- UWN
lin khartoum_PN = mkPN "Khartum" ; -- status=guess src=geonames
lin khoum_N = mkN "khoum" | mkN "khoum_mauritano" ; -- UWN
lin kibbutz_N = mkN "kibbutz" ; -- UWN
lin kick_N = mkN "calcio" | mkN "piedata" | mkN "colpo di piede" ; -- status=guess status=guess status=guess
lin kick_V = mkV "calciare" ; -- status=guess, src=wikt
lin kick_V2 = mkV2 (mkV "calciare") ; -- status=guess, src=wikt
lin kick_about_V2 = prepV2 OP_kick_V OP_about_Prep ; -- guess-p-verb
lin kick_around_V2 = prepV2 OP_kick_V OP_around_Prep ; -- guess-p-verb
lin kick_around_with_V2 = prepV2 (advV OP_kick_V OP_around_Adv ) OP_with_Prep ; -- guess-p-verb
lin kick_back_V = mkV "rinculare" ; -- UWN
lin kick_back_V2 = mkV2 (advV OP_kick_V OP_back_Adv ) ; -- guess-p-verb
lin kick_down_V2 = prepV2 OP_kick_V OP_down_Prep ; -- guess-p-verb
lin kick_in_V = advV OP_kick_V OP_in_Adv ; -- guess-p-verb
lin kick_in_V2 = prepV2 OP_kick_V OP_in_Prep ; -- guess-p-verb
lin kick_off_V = advV OP_kick_V OP_off_Adv ; -- guess-p-verb
lin kick_off_V2 = prepV2 OP_kick_V OP_off_Prep ; -- guess-p-verb
lin kick_out_V2 = prepV2 OP_kick_V OP_out_Prep ; -- guess-p-verb
lin kick_through_V = advV OP_kick_V OP_through_Adv ; -- guess-p-verb
lin kick_up_V = advV OP_kick_V OP_up_Adv ; -- guess-p-verb
lin kickback_N = mkN "contraccolpo" | mkN "sconto" | mkN "abbuono" | mkN "tangente" feminine | mkN "bustarella" | mkN "mazzetta" | mkN "pizzo" ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin kicker_N = mkN "calciatore" ; -- UWN
lin kickoff_N = mkN "calcio_d'inizio" ; -- UWN
lin kid_N = mkN "pelle di capretto" ; -- status=guess
lin kidderminster_PN = mkPN "Kidderminster" ; -- status=guess src=geonames
lin kidlington_PN = mkPN "Kidlington" ; -- status=guess src=geonames
lin kidnap_V2 = mkV2 (mkV "rapire") ; -- status=guess, src=wikt
lin kidnapper_N = mkN "rapitore" ; -- status=guess
lin kidnapping_N = mkN "sequestro" ; -- status=guess
lin kidney_N = mkN "rene" masculine ; -- status=guess
lin kidsgrove_PN = mkPN "Kidsgrove" ; -- status=guess src=geonames
lin kiev_PN = mkPN "Kiev" ; -- status=guess src=geonames
lin kilbirnie_PN = mkPN "Kilbirnie" ; -- status=guess src=geonames
lin kildare_PN = mkPN "Kildare" ; -- status=guess src=geonames
lin kilkenny_PN = mkPN "Kilkenny" ; -- status=guess src=geonames
lin kill_N = mkN "uccisione" feminine ; -- status=guess
lin kill_V = mkV "uccidere" | mkV "ammazzare" ; -- status=guess, src=wikt status=guess, src=wikt
lin kill_V2 = L.kill_V2 ;
lin kill_off_V2 = prepV2 OP_kill_V OP_off_Prep ; -- guess-p-verb
lin killarney_PN = mkPN "Killarney" ; -- status=guess src=geonames
lin killer_N = mkN "assassino" ; -- status=guess
lin killing_N = mkN "ammazzamento" | mkN "assassinio" | mkN "mattanza" | mkN "omicidio" | mkN "sterminio" | mkN "uccisione" ; -- UWN
lin killjoy_N = mkN "guastafeste" ; -- UWN
lin kilmarnock_PN = mkPN "Kilmarnock" ; -- status=guess src=geonames
lin kiln_N = mkN "fornace" feminine ; -- status=guess
lin kilo_N = mkN "chilo" ; -- status=guess
lin kilobyte_N = mkN "kilobyte" masculine ; -- status=guess
lin kilocycle_N = mkN "chilociclo" | mkN "chilohertz" | mkN "kilociclo" ; -- UWN
lin kilogram_N = mkN "chilogrammo" | mkN "chilo" ; -- status=guess status=guess
lin kilohertz_N = mkN "chilociclo" | mkN "chilohertz" | mkN "kilociclo" ; -- UWN
lin kilolitre_N = mkN "chilolitro" | mkN "kilolitro" ; -- UWN
lin kilometre_N = mkN "chilometro" ; -- status=guess
lin kilovolt_N = mkN "chilovolt" | mkN "kilovolt" ; -- UWN
lin kilowatt_N = mkN "chilowatt" masculine ; -- status=guess
lin kilsyth_PN = mkPN "Kilsyth" ; -- status=guess src=geonames
lin kilt_N = mkN "kilt" ; -- UWN
lin kilwinning_PN = mkPN "Kilwinning" ; -- status=guess src=geonames
lin kimberley_PN = mkPN "Kimberley" ; -- status=guess src=geonames
lin kimono_N = mkN "chimono" ; -- status=guess
lin kin_N = mkN "clan" | mkN "genia" ; -- UWN
lin kind_A = mkA "gentile" | mkA "carino" ; -- status=guess status=guess
lin kind_N = mkN "genere" masculine | mkN "tipo" ; -- status=guess status=guess
lin kinda_Adv = mkAdv "alquanto" | mkAdv "piuttosto" ; -- UWN
lin kindle_V = mkV "eccitare" | mkV "infuocare" | mkV "suscitare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin kindle_V2 = mkV2 (mkV "eccitare") | mkV2 (mkV "infuocare") | mkV2 (mkV "suscitare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin kindliness_N = mkN "disponibilità" ; -- UWN
lin kindling_N = mkN "esca" | mkN "accelerante" masculine ; -- status=guess status=guess
lin kindly_A = variants {} ;
lin kindness_N = mkN "bontà" feminine | mkN "gentilezza" | mkN "cortesia" | mkN "garbo" ; -- status=guess status=guess status=guess status=guess
lin kindred_N = mkN "clan" | mkN "genia" ; -- UWN
lin kinematics_N = mkN "cinematica" ; -- UWN
lin kinescope_N = mkN "cinescopio" ; -- UWN
lin kinesthetic_A = mkA "cinestetico" ; -- UWN
lin kinetic_A = mkA "cinetico" ; -- status=guess
lin kinetics_N = mkN "cinetica" ; -- status=guess
lin king_N = L.king_N ;
lin kingcup_N = mkN "botton_d'oro" | mkN "ranuncolo" ; -- UWN
lin kingdom_N = mkN "regno" ; -- status=guess
lin kingfisher_N = mkN "martin pescatore" ; -- status=guess
lin kingsbury_PN = mkPN "Kingsbury" ; -- status=guess src=geonames
lin kingship_N = mkN "regno" ; -- UWN
lin kingsteignton_PN = mkPN "Kingsteignton" ; -- status=guess src=geonames
lin kingston_PN = mkPN "Kingston" ; -- status=guess src=geonames
lin kinshasa_PN = mkPN "Kinshasa" ; -- status=guess src=geonames
lin kinship_N = mkN "parentela" ; -- status=guess
lin kinsman_N = mkN "parente" masculine ; -- status=guess
lin kiosk_N = mkN "chiosco" ; -- status=guess
lin kip_1_N = mkN "riposo" ; -- status=guess
lin kip_2_N = mkN "riposo" ; -- status=guess
lin kirkby_PN = mkPN "Kirkby" ; -- status=guess src=geonames
lin kirkcaldy_PN = mkPN "Kirkcaldy" ; -- status=guess src=geonames
lin kirkham_PN = mkPN "Kirkham" ; -- status=guess src=geonames
lin kirkintilloch_PN = mkPN "Kirkintilloch" ; -- status=guess src=geonames
lin kirkwall_PN = mkPN "Kirkwall" ; -- status=guess src=geonames
lin kiss_N = mkN "bacio" ; -- status=guess
lin kiss_V2 = mkV2 (mkV "baciarsi") ; -- status=guess, src=wikt
lin kiss_off_V = advV (lin V OP_kiss_V2) OP_off_Adv ; -- guess-p-verb
lin kiss_off_V2 = prepV2 (lin V OP_kiss_V2) OP_off_Prep ; -- guess-p-verb
lin kiss_up_to_V2 = prepV2 (advV (lin V OP_kiss_V2) OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin kisser_N = mkN "aspetto" | mkN "fisionomia" | mkN "fisonomia" | mkN "grugno" | mkN "muso" | mkN "sembiante" ; -- UWN
lin kit_N = mkN "corredo" ; -- status=guess
lin kitchen_N = mkN "cucina" ; -- status=guess
lin kitchenette_N = mkN "angolo cottura" | mkN "cucinotto" | mkN "cucinino" ; -- status=guess status=guess status=guess
lin kite_N = mkN "nibbio" ; -- status=guess
lin kitsch_N = mkN "kitsch" masculine ; -- status=guess
lin kitten_N = mkN "gattino" | mkN "gattina" | mkN "micetto" | mkN "micetta" ; -- status=guess status=guess status=guess status=guess
lin kittiwake_N = mkN "gabbiano_tridattilo" ; -- UWN
lin kitty_N = mkN "gattino" ; -- status=guess
lin kiwi_N = mkN "kiwi" masculine ; -- status=guess
lin kleptomania_N = mkN "cleptomania" ; -- UWN
lin kleptomaniac_N = mkN "cleptomane" ; -- status=guess
lin km_N = mkN "chilometro" | mkN "kilometro" ; -- UWN
lin knack_N = mkN "pallino" ; -- status=guess
lin knacker_N = mkN "squartatore" masculine ; -- status=guess
lin knackered_A = mkA "spacciato" | mkA "fritto" ; -- status=guess status=guess
lin knapsack_N = mkN "bisaccia" | mkN "saccapane" | mkN "tascapane" | mkN "zainetto" | mkN "zaino" ; -- UWN
lin knaresborough_PN = mkPN "Knaresborough" ; -- status=guess src=geonames
lin knave_N = mkN "fante" masculine ; -- status=guess
lin knavery_N = mkN "disonestà" ; -- UWN
lin knee_N = L.knee_N ;
lin kneecap_N = mkN "rotula" | mkN "patella" ; -- status=guess status=guess
lin kneel_V = mkV "inginocchiarsi" ; -- status=guess, src=wikt
lin knell_N = mkN "rintocco" ; -- status=guess
lin knick_knack_N = mkN "bagatella" | mkN "bazzecola" | mkN "bric-a-brac" | mkN "bric-ý-brac" | mkN "carabattola" | mkN "cianfrusaglia" | mkN "cianfruscaglia" | mkN "robetta" ; -- UWN
lin knife_N = mkN "lama" masculine ; -- status=guess
lin knife_V2 = mkV2 (mkV "accoltellare") ; -- status=guess, src=wikt
lin knight_N = mkN "cavallo" feminine ; -- status=guess
lin knit_V = mkV "saldarsi" | mkV "compattare" ; -- status=guess, src=wikt status=guess, src=wikt
lin knit_V2 = mkV2 (mkV "saldarsi") | mkV2 (mkV "compattare") ; -- status=guess, src=wikt status=guess, src=wikt
lin knitter_N = mkN "magliaia" ; -- UWN
lin knitting_N = mkN "ferro da maglia" | mkN "ferro da calza" ; -- status=guess status=guess
lin knob_N = mkN "maniglia" ; -- status=guess
lin knock_N = mkN "autocombustione" feminine ; -- status=guess
lin knock_V = mkV "trincare" ; -- status=guess, src=wikt
lin knock_V2 = mkV2 (mkV "trincare") ; -- status=guess, src=wikt
lin knock_about_V2 = prepV2 OP_knock_V OP_about_Prep ; -- guess-p-verb
lin knock_around_V2 = prepV2 OP_knock_V OP_around_Prep ; -- guess-p-verb
lin knock_back_V2 = mkV2 (advV OP_knock_V OP_back_Adv ) ; -- guess-p-verb
lin knock_down_V2 = prepV2 OP_knock_V OP_down_Prep ; -- guess-p-verb
lin knock_it_off_V2 = variants {} ; -- guess-p-verb
lin knock_off_V = mkV "staccare" ; -- UWN
lin knock_off_V2 = prepV2 OP_knock_V OP_off_Prep ; -- guess-p-verb
lin knock_out_V = advV OP_knock_V OP_out_Adv ; -- guess-p-verb
lin knock_out_V2 = prepV2 OP_knock_V OP_out_Prep ; -- guess-p-verb
lin knock_over_V = advV OP_knock_V OP_over_Adv ; -- guess-p-verb
lin knock_together_V2 = mkV2 (advV OP_knock_V OP_together_Adv ) ; -- guess-p-verb
lin knock_up_V = advV OP_knock_V OP_up_Adv ; -- guess-p-verb
lin knock_up_V2 = prepV2 OP_knock_V OP_up_Prep ; -- guess-p-verb
lin knocker_N = mkN "batacchio" | mkN "battacchio" | mkN "battaglio" | mkN "battente" | mkN "bussatoio" | mkN "campanella" | mkN "picchiotto" ; -- UWN
lin knoll_N = mkN "clivo" | mkN "dosso" | mkN "poggio" ; -- UWN
lin knot_N = mkN "nodo" ; -- status=guess
lin knot_V = mkV "annodare" ; -- status=guess, src=wikt
lin knot_V2 = mkV2 (mkV "annodare") ; -- status=guess, src=wikt
lin knotgrass_N = mkN "centinodia" ; -- status=guess
lin knottingley_PN = mkPN "Knottingley" ; -- status=guess src=geonames
lin knotty_A = mkA "nodoso" ; -- status=guess
lin know_N = mkN "conoscenza" masculine ; -- status=guess
lin know_V = conoscere_V ; -- status=guess, src=wikt
lin know_V2 = L.know_V2 ;
lin know_VQ = L.know_VQ ;
lin know_VS = L.know_VS ;
lin knowable_A = mkA "conoscibile" ; -- status=guess
lin knowledge_N = mkN "conoscenza" masculine ; -- status=guess
lin known_A = variants {} ; --
lin knuckle_N = mkN "nocca" ; -- status=guess
lin knuckle_down_V = mkV "sfacchinare" | mkV "sfaticare" | mkV "sgobbare" ; -- UWN
lin knutsford_PN = mkPN "Knutsford" ; -- status=guess src=geonames
lin koala_N = mkN "koala" masculine ; -- status=guess
lin koan_N = mkN "aporia" ; -- status=guess
lin kobe_PN = mkPN "Kōbe" ; -- status=guess src=geonames
lin koblenz_PN = mkPN "Coblenza" ; -- status=guess src=geonames
lin kobo_N = mkN "kobo" | mkN "kobo_nigeriano" ; -- UWN
lin kohl_N = mkN "kajal" ; -- UWN
lin kohlrabi_N = mkN "cavolo rapa" ; -- status=guess
lin kolkhoz_N = mkN "kolchoz" masculine ; -- status=guess
lin kopeck_N = mkN "copeck" | mkN "copeco" | mkN "copeco_russo" | mkN "kopeck" | mkN "kopek" ; -- UWN
lin kopek_N = mkN "copeco" ; -- status=guess
lin kosher_A = mkA "kasher" ; -- status=guess
lin koumiss_N = mkN "kumis" masculine ; -- status=guess
lin krasnoyarsk_PN = mkPN "Krasnoyarsk" ; -- status=guess src=geonames
lin krefeld_PN = mkPN "Krefeld" ; -- status=guess src=geonames
lin krypton_N = mkN "cripto" | mkN "kripto" | mkN "krypto" ; -- status=guess status=guess status=guess
lin krona_N = mkN "corona" ;
lin krone_N = mkN "corona" ;
lin kroon_N = mkN "corona" ;
lin kudu_N = mkN "cudù" masculine ; -- status=guess
lin kumquat_N = mkN "kumquat" | mkN "mandarino cinese" ; -- status=guess status=guess
lin kunming_PN = mkPN "Kunming" ; -- status=guess src=geonames
lin kuwait_PN = mkPN "Kuwait" ; -- status=guess src=geonames
lin kuybyshev_PN = mkPN "Kujbyšev" ; -- status=guess src=geonames
lin kyanite_N = mkN "cianite" ; -- status=guess
lin kyoto_PN = mkPN "Kyoto" ; -- status=guess src=geonames
lin la_N = mkN "la" ; -- UWN
lin lab_N = mkN "gabinetto" | mkN "laboratorio" ; -- UWN
lin lab_PN = mkPN "Lab" ; -- status=guess src=geonames
lin label_N = mkN "etichetta" ; -- status=guess
lin label_V = mkV "etichettare" ; -- status=guess, src=wikt
lin label_V2 = mkV2 (mkV "etichettare") ; -- status=guess, src=wikt
lin label_V3 = mkV3 (mkV "etichettare") ; -- status=guess, src=wikt
lin laboratory_N = mkN "laboratorio" ; -- status=guess
lin laborer_N = mkN "manovale" ; -- UWN
lin laborious_A = mkA "laborioso" ; -- status=guess
lin laboriousness_N = mkN "laboriosità" ; -- UWN
lin labour_N = mkN "manodopera" ; -- status=guess
lin labour_V = mkV "lavorare" ; -- status=guess, src=wikt
lin labour_V2 = mkV2 (mkV "lavorare") ; -- status=guess, src=wikt
lin labourer_N = mkN "manovale" ; -- UWN
lin labrador_PN = mkPN "Labrador" ; -- status=guess src=geonames
lin laburnum_N = mkN "maggiociondolo" ; -- status=guess
lin labyrinth_N = mkN "labirinto" ; -- status=guess
lin labyrinthine_A = mkA "labirintico" ; -- status=guess
lin labyrinthitis_N = mkN "labirintite" ; -- UWN
lin lac_N = mkN "lacca" ; -- status=guess
lin lace_N = mkN "laccio" | mkN "stringa" ; -- status=guess status=guess
lin lace_V = mkV "combinare" | mkV "abbinare" ; -- status=guess, src=wikt status=guess, src=wikt
lin lace_V2 = mkV2 (mkV "combinare") | mkV2 (mkV "abbinare") ; -- status=guess, src=wikt status=guess, src=wikt
lin laceration_N = mkN "lacerazione" feminine ; -- status=guess
lin lachrymal_A = mkA "lacrimale" ; -- status=guess
lin lacing_N = mkN "bastonatura" | mkN "batosta" | mkN "battuta" | mkN "legnata" | mkN "pestata" | mkN "picchiata" ; -- UWN
lin lack_N = mkN "mancanza" ; -- status=guess
lin lack_V = mkV "mancare" ; -- status=guess, src=wikt
lin lack_V2 = mkV2 (mkV "mancare") ; -- status=guess, src=wikt
lin lackadaisical_A = mkA "languido" | mkA "apatico" | mkA "stufato" ; -- status=guess status=guess status=guess
lin lackey_N = mkN "leccaculo" | mkN "lacchè" masculine ; -- status=guess status=guess
lin lacking_A = variants {} ; --
lin lackluster_A = mkA "pallido" | mkA "spento" ; -- status=guess status=guess
lin laconic_A = mkA "laconico" ; -- status=guess
lin laconicism_N = mkN "laconicità" | mkN "laconismo" ; -- UWN
lin laconism_N = mkN "laconicità" | mkN "laconismo" ; -- UWN
lin lacquerware_N = mkN "lacca" ; -- UWN
lin lacrimal_A = mkA "lacrimale" | mkA "lagrimale" ; -- UWN
lin lacrimation_N = mkN "lacrimazione" | mkN "lagrimazione" ; -- UWN
lin lacrosse_N = mkN "lacrosse" masculine ; -- status=guess
lin lactic_A = mkA "lattico" ; -- UWN
lin lactobacillus_N = mkN "lattobacillo" ; -- UWN
lin lactose_N = mkN "lattosio" ; -- status=guess
lin lacuna_N = mkN "cassettone" ; -- UWN
lin lad_N = mkN "figliolo" | mkN "figliuolo" ; -- UWN
lin ladder_N = mkN "scala" ; -- status=guess
lin ladder_V = mkV "sfilarsi" | mkV "smagliarsi" ; -- UWN
lin laddie_N = mkN "figliolo" | mkN "figliuolo" ; -- UWN
lin lading_N = mkN "carico" | mkN "merce" | mkN "spedizione" ; -- UWN
lin ladle_N = mkN "mestolo" ; -- status=guess
lin lady_N = mkN "signora" | mkN "dama" ; -- status=guess status=guess
lin ladybird_N = mkN "coccinella" ; -- status=guess
lin ladyfinger_N = mkN "savoiardo" ; -- status=guess
lin ladylove_N = mkN "dulcinea" ; -- UWN
lin ladyship_N = mkN "La Signora" ; -- status=guess
lin lagomorph_N = mkN "lagomorfo" ; -- status=guess
lin lagoon_N = mkN "laguna" ; -- status=guess
lin lagos_PN = mkPN "Lagos" ; -- status=guess src=geonames
lin lahar_N = mkN "lahar" masculine ; -- status=guess
lin lahore_PN = mkPN "Lahore" ; -- status=guess src=geonames
lin laic_A = mkA "laico" ; -- UWN
lin lair_N = mkN "covo" ; -- status=guess
lin lake_N = L.lake_N ;
lin lakenheath_PN = mkPN "Lakenheath" ; -- status=guess src=geonames
lin lakeside_N = mkN "lungolago" ; -- UWN
lin lallation_N = mkN "balbettamento" | mkN "balbettio" ; -- UWN
lin lamb_N = mkN "agnello" ; -- status=guess
lin lambda_N = mkN "lambda" ; -- status=guess
lin lambeth_PN = mkPN "Lambeth" ; -- status=guess src=geonames
lin lambskin_N = mkN "carta_pecora" | mkN "cartapecora" | mkN "pergamena" ; -- UWN
lin lame_A = mkA "zoppo" ; -- status=guess
lin lamella_N = mkN "lamella" ; -- status=guess
lin lament_N = mkN "lamento" ; -- status=guess
lin lament_V = mkV "lamentarsi" ; -- status=guess, src=wikt
lin lament_V2 = mkV2 (mkV "lamentarsi") ; -- status=guess, src=wikt
lin lament_VS = mkVS (mkV "lamentarsi") ; -- status=guess, src=wikt
lin lamentable_A = mkA "lamentabile" ; -- status=guess
lin lamentation_N = mkN "lamento" ; -- status=guess
lin laminate_N = mkN "laminato" ; -- UWN
lin laminitis_N = mkN "podoflemmatite" ; -- UWN
lin lamp_N = L.lamp_N ;
lin lamplight_N = mkN "lume" ; -- UWN
lin lamplighter_N = mkN "lampionaio" ; -- status=guess
lin lampoon_N = mkN "parodia" ; -- UWN
lin lamppost_N = mkN "lampione" ; -- UWN
lin lamprey_N = mkN "lampreda" ; -- status=guess
lin lampshade_N = mkN "abat-jour" | mkN "paralume" ; -- UWN
lin lanark_PN = mkPN "Lanark" ; -- status=guess src=geonames
lin lancaster_PN = mkPN "Lancaster" ; -- status=guess src=geonames
lin lance_N = mkN "lancia spezzata" ; -- status=guess
lin lancer_N = mkN "lanciere" masculine ; -- status=guess
lin lancet_N = mkN "lancetta" ; -- status=guess
lin lancing_PN = mkPN "Lancing" ; -- status=guess src=geonames
lin land_N = mkN "terra" masculine ; -- status=guess
lin land_V = variants {} ; --
lin land_V2 = variants {} ; --
lin land_in_V2 = prepV2 OP_land_V OP_in_Prep ; -- guess-p-verb
lin land_up_in_V2 = prepV2 (advV OP_land_V OP_up_Adv ) OP_in_Prep ; -- guess-p-verb
lin land_with_V3 = variants {} ; -- guess-p-verb
lin landau_N = mkN "landò" ; -- UWN
lin landfill_N = mkN "discarica" ; -- status=guess
lin landgrave_N = mkN "langravio" ; -- status=guess
lin landholder_N = mkN "agrario" | mkN "possidente" | mkN "proprietario_terriero" ; -- UWN
lin landing_N = mkN "imbarcadero" ; -- status=guess
lin landlord_N = mkN "affittacamere" | mkN "fittacamere" | mkN "locatore" | mkN "locatrice" | mkN "padrona_di_casa" | mkN "padrone_di_casa" | mkN "proprietaria" | mkN "proprietario" ; -- UWN
lin landlubber_N = mkN "marinaio d'acqua dolce" ; -- status=guess
lin landowner_N = mkN "agrario" | mkN "possidente" | mkN "proprietario_terriero" ; -- UWN
lin landrover_N = mkN "campagnola" | mkN "fuoristrada" | mkN "jeep" ; -- UWN
lin landscape_N = mkN "orizzontale" ; -- status=guess
lin landscapist_N = mkN "architetto_del_paesaggio" ; -- UWN
lin landslide_N = mkN "frana" | mkN "smottamento" | mkN "slavina" ; -- status=guess status=guess status=guess
lin lane_N = mkN "corsia" ; -- status=guess
lin language_N = L.language_N ;
lin languid_A = mkA "languido" ; -- status=guess
lin languish_V = mkV "stagnare" | mkV (mkV "segnare") "il passo" ; -- status=guess, src=wikt status=guess, src=wikt
lin languor_N = mkN "languore" ; -- status=guess
lin lanky_A = mkA "allampanato" ; -- status=guess
lin lanolin_N = mkN "lanolina" ; -- status=guess
lin lantern_N = mkN "lanterna" ; -- status=guess
lin lanthanum_N = mkN "lantanio" ; -- status=guess
lin laos_PN = mkPN "Laos" ; -- status=guess src=geonames
lin lap_N = mkN "grembo" ; -- status=guess
lin laparoscope_N = mkN "laparoscopio" ; -- status=guess
lin laparoscopy_N = mkN "celioscopia" | mkN "laparoscopia" ; -- UWN
lin lap_dog_N = mkN "cagnolino" ; -- UWN
lin lapel_N = mkN "risvolto" ; -- status=guess
lin lapidary_A = mkA "lapidario" ; -- UWN
lin lapis_lazuli_N = mkN "lapislazoli" | mkN "lapislazzuli" ; -- UWN
lin laptop_N = mkN "portàtile" masculine ; -- status=guess
lin lapwing_N = mkN "fifa" | mkN "pavoncella" ; -- UWN
lin larboard_N = mkN "babordo" ; -- status=guess
lin larceny_N = mkN "furto" | mkN "ladreria" | mkN "ladrocinio" | mkN "ladroneccio" | mkN "latrocinio" | mkN "mangeria" | mkN "pappata" | mkN "ruba" | mkN "rubamento" | mkN "ruberia" ; -- UWN
lin larch_N = mkN "larice" masculine ; -- status=guess
lin lard_N = mkN "strutto" ; -- status=guess
lin large_A = mkA "largo" ;
lin large_N = mkN "intestino crasso" ; -- status=guess
lin large_scale_A = variants {} ; --
lin largeness_N = mkN "pretensiosità" | mkN "pretenziosità" ; -- UWN
lin largess_N = mkN "generosità" | mkN "magnanimità" | mkN "magnificenza" | mkN "munificenza" ; -- UWN
lin largesse_N = mkN "generosità" | mkN "magnanimità" | mkN "magnificenza" | mkN "munificenza" ; -- UWN
lin largo_N = mkN "largo" ; -- UWN
lin largs_PN = mkPN "Largs" ; -- status=guess src=geonames
lin lariat_N = mkN "lazo" ; -- UWN
lin lark_N = mkN "allòdola" | mkN "lòdola" | mkN "allodola" ; -- status=guess status=guess status=guess
lin larkhall_PN = mkPN "Larkhall" ; -- status=guess src=geonames
lin larn_V = mkV "apprendere" | mkV "imparare" ; -- UWN
lin larne_PN = mkPN "Larne" ; -- status=guess src=geonames
lin larva_N = mkN "larva" ; -- UWN
lin laryngeal_A = mkA "laringico" ; -- status=guess
lin laryngitis_N = mkN "laringite" feminine ; -- status=guess
lin laryngopharynx_N = mkN "laringofaringe" masculine ; -- status=guess
lin laryngoscope_N = mkN "laringoscopio" ; -- UWN
lin larynx_N = mkN "laringe" feminine ; -- status=guess
lin lasagna_N = mkN "lasagna" ; -- status=guess
lin lascivious_A = mkA "lascivo" ; -- status=guess
lin lasciviousness_N = mkN "carnalità" ; -- UWN
lin laser_N = mkN "laser" feminine ; -- status=guess
lin lash_V = mkV "rimproverare" ; -- status=guess, src=wikt
lin lash_V2 = mkV2 (mkV "rimproverare") ; -- status=guess, src=wikt
lin lash_out_V = mkV "aggredire" | mkV "assalire" ; -- UWN
lin lashing_N = mkN "curbasciata" | mkN "flagellamento" | mkN "flagellazione" | mkN "frustata" | mkN "fustigazione" | mkN "nerbata" | mkN "scudisciata" | mkN "sferzata" | mkN "staffilamento" | mkN "staffilata" ; -- UWN
lin lasso_N = mkN "lazo" ; -- UWN
lin last_1_A = mkA "ultimo" ;
lin last_2_A = mkA "scorso" ;
lin last_A = mkA "ultimo" ;
lin last_N = mkN "notte scorsa" ; -- status=guess
lin last_V = mkV "durare" ; -- status=guess, src=wikt
lin lasting_A = mkA "permanente" | mkA "duraturo" | mkA "durevole" ; -- status=guess status=guess status=guess
lin latch_N = mkN "chiavistello" ; -- status=guess
lin late_A = mkA "compianto" ; -- status=guess
lin late_Adv = mkAdv "tardi" ; -- status=guess
lin latecomer_N = mkN "ritardatario" ; -- UWN
lin lately_Adv = adjAdv late_A ; -- -- derived
lin latency_N = mkN "latenza" ; -- status=guess
lin lateness_N = mkN "ritardo" ; -- UWN
lin latent_A = mkA "latente" ; -- status=guess
lin later_Adv = mkAdv "più tardi" ; -- status=guess
lin laterality_N = mkN "prevalenza" ; -- UWN
lin lateralization_N = mkN "lateralizzazione" feminine ; -- status=guess
lin laterite_N = mkN "laterite" ; -- UWN
lin latex_N = mkN "latice" | mkN "lattice" masculine ; -- status=guess status=guess
lin lathe_N = mkN "tornio" ; -- status=guess
lin lather_N = mkN "schiuma di sapone" ; -- status=guess
lin lather_V = mkV "insaponare" ; -- status=guess, src=wikt
lin lather_V2 = mkV2 (mkV "insaponare") ; -- status=guess, src=wikt
lin latin_A = variants {} ; --
lin latitude_N = mkN "latitudine" feminine ; -- status=guess
lin latitudinal_A = mkA "latitudinale" | mkA "latitudinario" ; -- UWN
lin latrine_N = mkN "latrina" | mkN "cesso alla turca" ; -- status=guess status=guess
lin latter_A = mkA "secondo" | mkA "ultimo" ; -- UWN
lin lattice_N = mkN "grata" | mkN "graticcio" ; -- status=guess status=guess
lin laud_V2 = mkV2 (mkV "lodare") | mkV2 (mkV "glorificare") ; -- status=guess, src=wikt status=guess, src=wikt
lin laudanum_N = mkN "laudano" ; -- status=guess
lin laudator_N = mkN "elogiatore" | mkN "esaltatore" | mkN "lodatore" | mkN "magnificatore" ; -- UWN
lin laugh_N = mkN "riso" | mkN "risata" ; -- status=guess status=guess
lin laugh_V = L.laugh_V ;
lin laugh_V2 = mkV2 (ridere_V) ; -- status=guess, src=wikt
lin laugh_VS = mkVS (ridere_V) ; -- status=guess, src=wikt
lin laugh_at_V2 = prepV2 OP_laugh_V OP_at_Prep ; -- guess-p-verb
lin laugh_off_V2 = prepV2 OP_laugh_V OP_off_Prep ; -- guess-p-verb
lin laughable_A = mkA "ridicolo" ; -- status=guess
lin laughter_N = mkN "risata" ; -- status=guess
lin launch_N = mkN "getto" | mkN "lancio" | mkN "tiro" ; -- UWN
lin launch_V = mkV "lanciare" ; -- status=guess, src=wikt
lin launch_V2 = mkV2 (mkV "lanciare") ; -- status=guess, src=wikt
lin launching_N = mkN "getto" | mkN "lancio" | mkN "tiro" ; -- UWN
lin launder_V = mkV "riciclare" ; -- UWN
lin laundress_N = mkN "lavandaia" ; -- UWN
lin laundry_N = mkN "bucato" ; -- status=guess
lin laundrywoman_N = mkN "lavandaia" ; -- UWN
lin laura_PN = mkPN "Laura" ; -- status=guess src=geonames
lin laureateFem_N = variants {} ; ---- sense to be split
lin laureateMasc_N = variants {} ; ---- sense to be split
lin laurel_N = mkN "alloro" ; -- status=guess
lin lausanne_PN = mkPN "Losanna" ; -- status=guess src=geonames
lin lava_N = mkN "lava" ; -- status=guess
lin lavage_N = mkN "lavanda" ; -- UWN
lin lavender_N = mkN "lavanda" ; -- status=guess
lin lavish_A = mkA "eccessivo" | mkA "smodato" | mkA "sovrabbondante" ; -- status=guess status=guess status=guess
lin lavish_V2 = mkV2 (mkV "prodigare") | mkV2 (profondere_V) | mkV2 (mkV (mkV "spendere") "profusamente") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin lavishness_N = mkN "prodigalità" ; -- UWN
lin law_1_N = mkN "legge" feminine ;
lin law_2_N = mkN "diritto" ;
lin law_N = mkN "diritto" ; -- status=guess
lin lawbreaker_N = mkN "trasgressore" ; -- UWN
lin lawfulness_N = mkN "giuridicità" | mkN "legalità" | mkN "liceità" ; -- UWN
lin lawgiver_N = mkN "legislatore" ; -- UWN
lin lawmaker_N = mkN "legislatore" ; -- UWN
lin lawmaking_N = mkN "legislazione" ; -- UWN
lin lawn_N = mkN "prato" ; -- status=guess
lin lawrence_PN = mkPN "Lawrence" ; -- status=guess src=geonames
lin lawrencium_N = mkN "laurenzio" ; -- status=guess
lin lawsuit_N = mkN "causa di tribunale" ; -- status=guess
lin lawyer_N = mkN "avvocato" | mkN "legale" feminine ; -- status=guess status=guess
lin lax_A = mkA "trascurato" | mkA "negligente" ; -- status=guess status=guess
lin laxative_A = mkA "lassativo" | mkA "lubricante" ; -- UWN
lin laxity_N = mkN "lassismo" | mkN "permissivismo" | mkN "rilassatezza" ; -- UWN
lin laxness_N = mkN "lassismo" | mkN "permissivismo" | mkN "rilassatezza" ; -- UWN
lin lay_A = mkA "laico" | mkA "laica" ; -- status=guess status=guess
lin lay_N = mkN "stallia" ; -- status=guess
lin lay_away_V2 = mkV2 (advV OP_lay_V OP_away_Adv ) ; -- guess-p-verb
lin lay_down_V = advV OP_lay_V OP_down_Adv ; -- guess-p-verb
lin lay_down_V2 = prepV2 OP_lay_V OP_down_Prep ; -- guess-p-verb
lin lay_in_on_V2 = prepV2 (advV OP_lay_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin lay_into_V2 = prepV2 OP_lay_V OP_into_Prep ; -- guess-p-verb
lin lay_off_V2 = prepV2 OP_lay_V OP_off_Prep ; -- guess-p-verb
lin lay_on_V2 = prepV2 OP_lay_V OP_on_Prep ; -- guess-p-verb
lin lay_out_V2 = prepV2 OP_lay_V OP_out_Prep ; -- guess-p-verb
lin layabout_N = mkN "sfaccendato" | mkN "perdigiorno" ; -- status=guess status=guess
lin layer_N = mkN "ovaiola" ; -- status=guess
lin layette_N = mkN "corredino" ; -- UWN
lin layman_N = mkN "laico" | mkN "profano" ; -- status=guess status=guess
lin lay_out_N = variants {} ; --
lin layover_N = mkN "sosta" ; -- UWN
lin lazar_N = mkN "lazzaro" | mkN "lazzero" | mkN "lebbroso" ; -- UWN
lin lazaret_N = mkN "lazzaretto" | mkN "lazzeretto" ; -- UWN
lin lazarette_N = mkN "lazzaretto" | mkN "lazzeretto" ; -- UWN
lin laziness_N = mkN "pigrizia" ; -- status=guess
lin lazy_A = mkA "pigro" ; -- status=guess
lin lazybones_N = mkN "poltrone" | mkN "pigrone" | mkN "scaldaseggiole" masculine ; -- status=guess status=guess status=guess
lin lb_N = mkN "libbra" | mkN "libra" ; -- UWN
lin lea_N = mkN "pascolo" ; -- UWN
lin leach_N = mkN "lisciviazione" ; -- UWN
lin lead_N = mkN "guida" ; -- status=guess
lin lead_V = mkV (essere_V) "di mano" ; -- status=guess, src=wikt
lin lead_V2 = mkV2 (mkV (essere_V) "di mano") ; -- status=guess, src=wikt
lin lead_V2V = mkV2V (mkV (essere_V) "di mano") ; -- status=guess, src=wikt
lin lead_on_V2 = prepV2 OP_lead_V OP_on_Prep ; -- guess-p-verb
lin lead_to_V2 = prepV2 OP_lead_V OP_to_Prep ; -- guess-p-verb
lin lead_up_V = advV OP_lead_V OP_up_Adv ; -- guess-p-verb
lin leaded_A = mkA "interlineato" ; -- UWN
lin leaden_A = mkA "plumbeo" ; -- status=guess
lin leader_N = mkN "capo" | mkN "duce" masculine ; -- status=guess status=guess
lin leadership_N = mkN "comando" ; -- UWN
lin leading_A = variants {} ; --
lin leading_N = mkN "comando" ; -- UWN
lin leaf_N = L.leaf_N ;
lin leaf_V = mkV "sfogliare" ; -- status=guess, src=wikt
lin leaflet_N = mkN "fogliolina" ; -- status=guess
lin leafy_A = mkA "foglioso" | mkA "fogliosa" | mkA "fronzuto" | mkA "fronzuto" ; -- status=guess status=guess status=guess status=guess
lin league_1_N = mkN "campionato" | mkN "federazione" | mkN "lega" ; -- UWN
lin league_2_N = mkN "campionato" | mkN "federazione" | mkN "lega" ; -- UWN
lin league_N = variants {} ; --
lin leak_N = mkN "fessura" ; -- status=guess
lin leak_V = perdere_V ; -- status=guess, src=wikt
lin leak_V2 = mkV2 (perdere_V) ; -- status=guess, src=wikt
lin leakage_N = mkN "perdita" ; -- status=guess
lin lean_A = mkA "magro" | mkA "asciutto" ; -- status=guess status=guess
lin lean_N = mkN "inclinazione" ; -- UWN
lin lean_V = mkV "sporgersi" ; -- status=guess, src=wikt
lin lean_V2 = mkV2 (mkV "sporgersi") ; -- status=guess, src=wikt
lin lean_on_V2 = prepV2 OP_lean_V OP_on_Prep ; -- guess-p-verb
lin leanness_N = mkN "asciuttezza" | mkN "esilità" | mkN "magrezza" ; -- UWN
lin leap_N = mkN "salto" ; -- status=guess
lin leap_V = mkV "saltare" ; -- status=guess, src=wikt
lin leap_V2 = mkV2 (mkV "saltare") ; -- status=guess, src=wikt
lin learn_V = mkV "imparare" | apprendere_V ; -- status=guess, src=wikt status=guess, src=wikt
lin learn_V2 = L.learn_V2 ;
lin learn_VS = mkVS (mkV "imparare") | mkVS (apprendere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin learn_VV = mkVV (mkV "imparare") | mkVV (apprendere_V) ; -- status=guess, src=wikt status=guess, src=wikt
lin learner_N = variants {} ; --
lin learning_N = mkN "disturbi specifici di apprendimento" ; -- status=guess
lin lease_N = mkN "affitto" | mkN "conduzione" | mkN "contratto_di_affitto" | mkN "leasing" | mkN "locazione" ; -- UWN
lin leaseholder_N = mkN "affittuario" | mkN "pigionante" ; -- UWN
lin leash_N = mkN "guinzaglio" ; -- status=guess
lin least_Adv = mkAdv "meno" ; -- status=guess
lin least_N = mkN "minimo comune multiplo" ; -- status=guess
lin leather_N = L.leather_N ;
lin leatherhead_PN = mkPN "Leatherhead" ; -- status=guess src=geonames
lin leave_N = mkN "partenza" ; -- status=guess
lin leave_V = mkV "lasciare" | mkV "dimenticare" ; -- status=guess, src=wikt status=guess, src=wikt
lin leave_V2 = L.leave_V2 ;
lin leave_V2V = mkV2V (mkV "lasciare") | mkV2V (mkV "dimenticare") ; -- status=guess, src=wikt status=guess, src=wikt
lin leave_behind_V = mkV "lasciare" ; -- UWN
lin leave_off_V = advV OP_leave_V OP_off_Adv ; -- guess-p-verb
lin leave_on_V2 = prepV2 OP_leave_V OP_on_Prep ; -- guess-p-verb
lin leave_open_V = advV OP_leave_V OP_open_Adv ; -- guess-p-verb
lin leave_out_V2 = prepV2 OP_leave_V OP_out_Prep ; -- guess-p-verb
lin leave_over_V = advV OP_leave_V OP_over_Adv ; -- guess-p-verb
lin leaven_N = mkN "lievito" ; -- status=guess
lin lebaneseFem_N = variants {} ; ---- sense to be split
lin lebaneseMasc_N = variants {} ; ---- sense to be split
lin lebanon_PN = mkPN "Libano" ; -- status=guess src=geonames
lin lecher_N = mkN "mandrillo" ; -- status=guess
lin lecithin_N = mkN "lecitina" ; -- status=guess
lin lectern_N = mkN "leggio" ; -- status=guess
lin lector_N = mkN "lettore" ; -- UWN
lin lecture_N = mkN "conferenza" ; -- status=guess
lin lecturer_N = mkN "conferenziere" masculine ; -- status=guess
lin ledge_N = mkN "strato" ; -- status=guess
lin ledger_N = mkN "taglio addizionale" ; -- status=guess
lin lee_N = mkN "poggia" | mkN "sottovento" ; -- UWN
lin leech_N = mkN "balumina" ; -- status=guess
lin leeds_PN = mkPN "Leeds" ; -- status=guess src=geonames
lin leek_N = mkN "porro" ; -- status=guess
lin leek_PN = mkPN "Leek" ; -- status=guess src=geonames
lin leer_V = mkV "sbirciare" ; -- status=guess, src=wikt
lin lees_N = mkN "feccia" | mkN "fondaccio" ; -- UWN
lin leeward_A = mkA "sottovento" ; -- status=guess
lin leeward_Adv = mkAdv "sottovento" ; -- status=guess
lin leeward_N = mkN "poggia" | mkN "sottovento" ; -- UWN
lin leeway_N = mkN "margine di azione" feminine ; -- status=guess
lin left_A = mkA "sinistro" ; -- status=guess
lin left_N = mkN "sinistra" ; -- status=guess
lin left_Ord = L.left_Ord ; -- comment=CHECKED
lin leftist_N = mkN "rosso" | mkN "sinistroide" | mkN "sinistrorso" ; -- UWN
lin leftover_N = mkN "avanzi" masculine ;
lin leg_N = L.leg_N ;
lin legacy_N = mkN "eredità" feminine ; -- status=guess
lin legal_A = mkA "legale" ; -- status=guess
lin legalism_N = mkN "legalismo" ; -- UWN
lin legalization_N = mkN "legalizzazione" feminine ; -- status=guess
lin legato_Adv = mkAdv "legato" ; -- status=guess
lin legend_N = mkN "legenda" ; -- status=guess
lin legible_A = mkA "leggibile" ; -- status=guess
lin legion_N = mkN "legione" feminine ; -- status=guess
lin legionary_N = mkN "legionario" ; -- status=guess
lin legionnaire_N = mkN "legionario" ; -- status=guess
lin legislate_V = mkV "legiferare" ; -- status=guess, src=wikt
lin legislate_V2 = mkV2 (mkV "legiferare") ; -- status=guess, src=wikt
lin legislation_N = mkN "leggi" feminine ; -- status=guess
lin legislative_A = mkA "legislativo" ; -- status=guess
lin legislator_N = mkN "legislatore" masculine ; -- status=guess
lin legislature_N = variants {} ; --
lin legitimate_A = mkA "legittimo" ; -- UWN
lin legitimize_V2 = mkV2 (mkV "legittimare") ; -- status=guess, src=wikt
lin legitimize_V2V = mkV2V (mkV "legittimare") ; -- status=guess, src=wikt
lin leicester_PN = mkPN "Leicester" ; -- status=guess src=geonames
lin leiden_PN = mkPN "Leida" ; -- status=guess src=geonames
lin leigh_PN = mkPN "Leigh" ; -- status=guess src=geonames
lin leipzig_PN = mkPN "Lipsia" ; -- status=guess src=geonames
lin leishmaniasis_N = mkN "leishmaniosi" ; -- UWN
lin leisure_N = mkN "svago" ; -- status=guess
lin leisurely_A = variants {} ;
lin leisurely_Adv = adjAdv leisurely_A ; -- derived -- derived
lin leitmotiv_N = mkN "leitmotiv" ; -- UWN
lin lek_N = mkN "lek" | mkN "lek_albanese" ; -- UWN
lin lemma_N = mkN "lemma" ; -- status=guess
lin lemon_N = mkN "citronella" | mkN "melissa vera" | mkN "melissa" | mkN "cedronella" | mkN "erba limona" ; -- status=guess status=guess status=guess status=guess status=guess
lin lemonade_N = mkN "limonata" ; -- status=guess
lin lemongrass_N = mkN "citronella" ; -- status=guess
lin lempira_N = mkN "lempira" | mkN "lempira_dell'Honduras" ; -- UWN
lin lemur_N = mkN "lemure" masculine ; -- status=guess
lin lend_V = mkV "prestare" ; -- status=guess, src=wikt
lin lend_V2 = mkV2 (mkV "prestare") ; -- status=guess, src=wikt
lin lender_N = mkN "mutuante" ; -- UWN
lin lending_N = mkN "prestito" ; -- UWN
lin length_N = mkN "lunghezza" ; -- status=guess
lin lengthen_V = mkV "allungare" ; -- status=guess, src=wikt
lin lengthen_V2 = mkV2 (mkV "allungare") ; -- status=guess, src=wikt
lin lengthways_Adv = mkAdv "longitudinalmente" ; -- UWN
lin lengthwise_Adv = mkAdv "longitudinalmente" ; -- UWN
lin lengthy_A = mkA "lungo" ; -- UWN
lin lenient_A = mkA "permissivo" ; -- status=guess
lin lenitive_N = mkN "calmante" | mkN "lenitivo" | mkN "sedativo" ; -- UWN
lin lenity_N = mkN "benignità" | mkN "clemenza" | mkN "indulgenza" ; -- UWN
lin lens_N = mkN "lenticchia" ; -- status=guess
lin lens_PN = mkPN "Lens" ; -- status=guess src=geonames
lin lent_PN = mkPN "Lent" ; -- status=guess src=geonames
lin lentil_N = mkN "lenticchia" ; -- status=guess
lin leominster_PN = mkPN "Leominster" ; -- status=guess src=geonames
lin leon_PN = mkPN "Leon" ; -- status=guess src=geonames
lin leonard_PN = mkPN "Leonard" ; -- status=guess src=geonames
lin leone_N = mkN "leone" ; -- UWN
lin leonine_A = mkA "leonino" ; -- status=guess
lin leopard_N = mkN "leopardo" ; -- status=guess
lin leotard_N = mkN "body" masculine ; -- status=guess
lin lepiota_N = mkN "bubbola" | mkN "lepiota" ; -- UWN
lin leprosy_N = mkN "lebbra" ; -- status=guess
lin leprous_A = mkA "lebbroso" ; -- status=guess
lin lepton_1_N = mkN "leptone" masculine ; -- status=guess
lin lepton_2_N = mkN "leptone" masculine ; -- status=guess
lin lerwick_PN = mkPN "Lerwick" ; -- status=guess src=geonames
lin les_PN = mkPN "Les" ; -- status=guess src=geonames
lin lesbian_A = mkA "lesbico" | mkA "lesbica" ; -- status=guess status=guess
lin lesbian_N = mkN "lesbica" ; -- status=guess
lin lesbianism_N = mkN "lesbismo" | mkN "saffismo" | mkN "tribadismo" ; -- UWN
lin lese_majesty_N = mkN "alto_tradimento" ; -- UWN
lin lesion_N = mkN "lesione" feminine ; -- status=guess
lin leslie_PN = mkPN "Leslie" ; -- status=guess src=geonames
lin lesotho_PN = mkPN "Lesotho" ; -- status=guess src=geonames
lin less_A = mkA "meno" ; -- status=guess
lin less_Adv = mkAdv "meno" ; -- status=guess
lin less_CAdv = S.less_CAdv ; -- comment=CHECKED
lin less_Det = variants {} ; --
lin lessee_N = mkN "affittuario" | mkN "pigionante" ; -- UWN
lin lesser_A = mkA "minore" ; -- UWN
lin lesson_N = mkN "lezione" feminine ; -- status=guess
lin lessor_N = mkN "locatore" ; -- UWN
lin let_V2V = mkV2V (mkV "lasciare") ;
lin let_on_V = mkV "anticipare" | mkV "diffondere" | mkV "diserrare" | mkV "disserrare" | mkV "divulgare" | mkV "manifestare" | mkV "palesare" | mkV "rivelare" | mkV "svelare" ; -- UWN
lin letchworth_PN = mkPN "Letchworth Garden City" ; -- status=guess src=geonames
lin lethal_A = mkA "letale" ; -- status=guess
lin lethargic_A = mkA "letargico" ; -- status=guess
lin lethargy_N = mkN "abulia" | mkN "fannulloneria" | mkN "ignavia" | mkN "oziosità" | mkN "pigrezza" | mkN "pigrizia" ; -- UWN
lin letter_1_N = mkN "lettera" | mkN "missiva" | mkN "scritto" ; -- UWN
lin letter_2_N = mkN "carattere" | mkN "carattere_alfabetico" | mkN "lettera" ; -- UWN
lin letter_N = variants {} ; --
lin lettered_A = mkA "illuminato" ; -- UWN
lin letterhead_N = mkN "intestazione" ; -- UWN
lin lettering_N = mkN "iscrizione" | mkN "leggenda" | mkN "scritta" ; -- UWN
lin lettuce_N = mkN "lattuga" ; -- status=guess
lin let_up_N = mkN "bonaccia" | mkN "pausa" | mkN "sosta" | mkN "tregua" ; -- UWN
lin leu_N = mkN "leu" ;
lin leukaemia_N = mkN "leucemia" ; -- UWN
lin leukocyte_N = mkN "leucocita" masculine ; -- status=guess
lin leukoderma_N = mkN "leucodermia" ; -- UWN
lin leukorrhea_N = mkN "leucorrea" ; -- status=guess
lin lev_N = mkN "lev" "lev" masculine ;
lin levant_PN = mkPN "Levant" ; -- status=guess src=geonames
lin levator_N = mkN "elevatore del labbro superiore e dell'ala del naso" | mkN "muscolo elevatore del labbro superiore e dell'ala del naso" ; -- status=guess status=guess
lin level_1_N = mkN "livello" ;
lin level_2_N = mkN "livello" ;
lin level_A = mkA "livellato" ; -- status=guess
lin level_N = mkN "livello" ; -- status=guess
lin level_V = mkV "livellare" ; -- status=guess, src=wikt
lin level_V2 = mkV2 (mkV "livellare") ; -- status=guess, src=wikt
lin leveler_N = mkN "livellatore" ; -- UWN
lin leveller_N = mkN "livellatore" ; -- UWN
lin leven_PN = mkPN "Leven" ; -- status=guess src=geonames
lin lever_N = mkN "leva" ; -- status=guess
lin leverage_N = mkN "influenza" ; -- status=guess
lin leveret_N = mkN "leprotto" ; -- status=guess
lin leverkusen_PN = mkPN "Leverkusen" ; -- status=guess src=geonames
lin leviathan_N = mkN "leviatano" ; -- status=guess
lin levitate_V = mkV "levitare" ; -- status=guess, src=wikt
lin levitate_V2 = mkV2 (mkV "levitare") ; -- status=guess, src=wikt
lin levitation_N = mkN "levitazione" feminine ; -- status=guess
lin levy_N = mkN "leva" ; -- UWN
lin lewd_A = mkA "lascivo" ; -- status=guess
lin lewdness_N = mkN "indecenza" | mkN "laidezza" | mkN "lubricità" | mkN "oscenità" | mkN "salacità" | mkN "sconcezza" ; -- UWN
lin lewes_PN = mkPN "Lewes" ; -- status=guess src=geonames
lin lexeme_N = mkN "lessema" masculine ; -- status=guess
lin lexical_A = mkA "lessicale" ; -- status=guess
lin lexicographerFem_N = mkN "dizionarista" | mkN "lessicografo" | mkN "vocabolarista" | mkN "vocabolista" | mkN "vocabulista" ; -- UWN
lin lexicographerMasc_N = mkN "dizionarista" | mkN "lessicografo" | mkN "vocabolarista" | mkN "vocabolista" | mkN "vocabulista" ; -- UWN
lin lexicographic_A = mkA "lessicografico" ; -- UWN
lin lexicography_N = mkN "lessicografia" ; -- status=guess
lin lexicology_N = mkN "lessicologia" ; -- UWN
lin lexicon_N = mkN "lessico" ; -- status=guess
lin lexis_N = mkN "lessico" ; -- UWN
lin ley_N = mkN "pascolo" ; -- UWN
lin leyland_PN = mkPN "Leyland" ; -- status=guess src=geonames
lin liability_N = mkN "responsabilità" feminine ; -- status=guess
lin liable_A = variants {} ; --
lin liaison_N = mkN "collegamento" ; -- UWN
lin liana_N = mkN "liana" ; -- UWN
lin liar_N = mkN "bugiardo" | mkN "mentitore" masculine ; -- status=guess status=guess
lin lib_PN = mkPN "Lib" ; -- status=guess src=geonames
lin libation_N = mkN "libagione" | mkN "libazione" ; -- UWN
lin libel_N = mkN "diffamazione" feminine ; -- status=guess
lin liberal_A = variants {} ; --
lin liberal_N = mkN "liberale" ; -- UWN
lin liberalism_N = mkN "liberalismo" ; -- status=guess
lin liberalization_N = mkN "liberalizzazione" ; -- UWN
lin liberation_N = mkN "liberazione" feminine ; -- status=guess
lin liberator_N = mkN "affrancatore" | mkN "liberatore" | mkN "riscattatore" ; -- UWN
lin liberia_PN = mkPN "Liberia" ; -- status=guess src=geonames
lin libertine_N = mkN "debosciato" | mkN "dissoluto" | mkN "libertino" | mkN "scapestrato" | mkN "scostumato" ; -- UWN
lin liberty_N = mkN "libertà" feminine ; -- status=guess
lin libidinous_A = mkA "libidinoso" ; -- status=guess
lin libido_N = mkN "libido" ; -- UWN
lin librarian_N = mkN "bibliotecario" ; -- status=guess
lin library_N = mkN "biblioteca" ; -- status=guess
lin librettist_N = mkN "librettista" ; -- UWN
lin libretto_N = mkN "libretto" ; -- UWN
lin libya_PN = mkPN "Libia" ; -- status=guess src=geonames
lin licence_N = variants {} ; --
lin license_V2 = variants {} ; --
lin licentious_A = mkA "licenzioso" ; -- status=guess
lin licentiousness_N = mkN "licenziosità" ; -- status=guess
lin lichen_N = mkN "lichene" masculine ; -- status=guess
lin lichfield_PN = mkPN "Lichfield" ; -- status=guess src=geonames
lin lick_N = mkN "cazzotto" | mkN "pugno" ; -- UWN
lin lick_V2 = mkV2 (mkV "leccare") ; -- status=guess, src=wikt
lin licking_N = mkN "bastonatura" | mkN "batosta" | mkN "battuta" | mkN "legnata" | mkN "pestata" | mkN "picchiata" ; -- UWN
lin lid_N = mkN "coperchio" ; -- status=guess
lin lie_1_V = L.lie_V ;
lin lie_2_V = mkV "mentire" ;
lin lie_N = mkN "bugia" | mkN "menzogna" | mkN "frottola" | mkN "baggianata" | mkN "fola" | mkN "balla" | mkN "fandonia" ; -- status=guess status=guess status=guess status=guess status=guess status=guess status=guess
lin lie_V = L.lie_V ;
lin lie_VS = mkVS (mkV (essere_V) "sdraiato") | mkVS (mkV (essere_V) "disteso") | mkVS (mkV "giacere") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin lie_around_V = advV OP_lie_V OP_around_Adv ; -- guess-p-verb
lin lie_back_V = advV OP_lie_V OP_back_Adv ; -- guess-p-verb
lin lie_down_V = advV OP_lie_V OP_down_Adv ; -- guess-p-verb
lin lie_down_on_V2 = prepV2 (advV OP_lie_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin lie_with_V2 = prepV2 OP_lie_V OP_with_Prep ; -- guess-p-verb
lin liechtenstein_PN = mkPN "Principato del Liechtenstein" ; -- status=guess src=geonames
lin liegeman_N = mkN "feudatario" | mkN "vassallo" ; -- UWN
lin lien_N = mkN "milza" | mkN "splene" ; -- UWN
lin lieu_N = mkN "carica" | mkN "incarico" | mkN "luogo" | mkN "titolo" ; -- UWN
lin lieutenancy_N = mkN "luogotenenza" ; -- status=guess
lin lieutenant_N = mkN "tenente" | mkN "luogotenente" ; -- status=guess status=guess
lin life_N = mkN "vita" feminine ;
lin lifeblood_N = mkN "linfa_vitale" ; -- UWN
lin lifeboat_N = mkN "scialuppa di salvataggio" ; -- status=guess
lin lifeguard_N = mkN "bagnaiolo" | mkN "bagnante" | mkN "bagnino" ; -- UWN
lin lifeline_N = mkN "sagola_di_salvataggio" ; -- UWN
lin lifer_N = mkN "ergastolano" ; -- UWN
lin life_span_N = variants {} ; --
lin lifestyle_N = variants {} ; --
lin lifetime_N = mkN "vita" ; -- UWN
lin lift_N = mkN "ascensore" masculine ; -- status=guess
lin lift_V = mkV "alzare" | mkV "levare" ; -- status=guess, src=wikt status=guess, src=wikt
lin lift_V2 = mkV2 (mkV "alzare") | mkV2 (mkV "levare") ; -- status=guess, src=wikt status=guess, src=wikt
lin lift_off_V = advV OP_lift_V OP_off_Adv ; -- guess-p-verb
lin ligament_N = mkN "legamento" ; -- status=guess
lin ligand_N = mkN "ligando" | mkN "legante" masculine ; -- status=guess status=guess
lin ligation_N = mkN "allacciatura" | mkN "legatura" ; -- UWN
lin ligature_N = mkN "legatura" ; -- status=guess
lin light_1_A = mkA "leggero" | mkA "leggera" ; -- status=guess status=guess
lin light_2_A = mkA "leggero" | mkA "leggera" ; -- status=guess status=guess
lin light_N = mkN "lampadina" ; -- status=guess
lin light_V = mkV "illuminare" ; -- status=guess, src=wikt
lin light_V2 = mkV2 (mkV "illuminare") ; -- status=guess, src=wikt
lin light_out_V = advV OP_light_V OP_out_Adv ; -- guess-p-verb
lin light_up_V = mkV "illuminare" | mkV "irradiare" | mkV "rischiarare" ; -- UWN
lin light_up_V2 = prepV2 OP_light_V OP_up_Prep ; -- guess-p-verb
lin lighten_V = mkV "alleggerire" ; -- status=guess, src=wikt
lin lighten_V2 = mkV2 (mkV "alleggerire") ; -- status=guess, src=wikt
lin lightening_N = mkN "scoloramento" | mkN "scolorimento" ; -- UWN
lin lighter_N = mkN "accendino" ; -- status=guess
lin lighthouse_N = mkN "faro" ; -- status=guess
lin lighting_N = mkN "accensione" ; -- UWN
lin lightning_N = mkN "fulmine" | mkN "folgore" | mkN "saetta" | mkN "lampo" ; -- status=guess status=guess status=guess status=guess
lin lightship_N = mkN "battello_faro" ; -- UWN
lin lignin_N = mkN "lignina" ; -- UWN
lin lignite_N = mkN "lignite" ; -- status=guess
lin like_A = mkA "simile" ; -- status=guess
lin like_Adv = variants {} ; --
lin like_N = mkN "preferenza" ; -- status=guess
lin like_Prep = mkPrep "come" ;
lin like_Subj = variants {} ; --
lin like_V2 = L.like_V2 ;
lin like_VS = mkVS (piacere_V) ;
lin like_VV = mkVV (piacere_V) ;
lin likelihood_N = mkN "verosimiglianza" | mkN "verisimiglianza" ; -- status=guess status=guess
lin likely_A = mkA "promettente" ; -- status=guess
lin likewise_Adv = mkAdv "ugualmente" | mkAdv "similarmente" ; -- status=guess status=guess
lin liking_N = mkN "gradimento" ; -- UWN
lin likuta_N = mkN "likuta" | mkN "likuta_dello_Zaire" ; -- UWN
lin lilac_N = mkN "lilla" ; -- status=guess
lin lilian_PN = mkPN "Lilian" ; -- status=guess src=geonames
lin lille_PN = mkPN "Lilla" ; -- status=guess src=geonames
lin lily_N = mkN "giglio" ; -- status=guess
lin lima_PN = mkPN "Lima" ; -- status=guess src=geonames
lin limb_N = mkN "lembo bordo margine" ; -- status=guess
lin limber_up_V = mkV "scaldarsi" ; -- UWN
lin lime_1_N = mkN "limetta" ; -- status=guess
lin lime_2_N = mkN "limetta" ; -- status=guess
lin limekiln_N = mkN "calcara" ; -- status=guess
lin limelight_N = mkN "lucci della rabata" | mkN "luci della ribalta" ; -- status=guess status=guess
lin limerick_PN = mkPN "Limerick" ; -- status=guess src=geonames
lin limestone_N = mkN "calcare" masculine ; -- status=guess
lin limewater_N = mkN "acqua_di_calce" ; -- UWN
lin limit_N = mkN "limite" masculine ; -- status=guess
lin limit_V2 = variants {} ; --
lin limit_V2V = variants {} ; --
lin limitation_N = variants {} ; --
lin limited_A = variants {} ; --
lin limnology_N = mkN "limnologia" ; -- UWN
lin limoges_PN = mkPN "Limoges" ; -- status=guess src=geonames
lin limonite_N = mkN "limonite" ; -- UWN
lin limousine_N = mkN "limousine" ; -- UWN
lin limp_A = mkA "avvizzito" | mkA "vizzo" ; -- UWN
lin limp_V = mkV "zoppicare" ; -- status=guess, src=wikt
lin limpid_A = mkA "limpido" ; -- status=guess
lin limpness_N = mkN "afflosciamento" | mkN "flaccidezza" | mkN "floscezza" | mkN "moscezza" ; -- UWN
lin linchpin_N = mkN "acciarino" ; -- UWN
lin lincoln_PN = mkPN "Lincoln" ; -- status=guess src=geonames
lin lincolnshire_PN = mkPN "Lincolnshire" ; -- status=guess src=geonames
lin linda_PN = mkPN "Linda" ; -- status=guess src=geonames
lin linden_N = mkN "tiglio" ; -- status=guess
lin line_N = mkN "partizione" feminine ; -- status=guess
lin line_V = mkV "allineare" ; -- status=guess, src=wikt
lin line_V2 = mkV2 (mkV "allineare") ; -- status=guess, src=wikt
lin line_up_V = mkV "allineare" | mkV "ordinare" ; -- UWN
lin lineage_N = mkN "discendenza" | mkN "lignaggio" | mkN "stirpe" feminine ; -- status=guess status=guess status=guess
lin lineament_N = mkN "carattere_somatico" | mkN "connotato" | mkN "fattezza" | mkN "lineamento" | mkN "sembianza" | mkN "tratto" ; -- UWN
lin linear_A = mkA "lineare" ; -- status=guess
lin linen_N = mkN "lino" ; -- status=guess
lin linesman_N = mkN "guardalinee" masculine ; -- status=guess
lin ling_N = mkN "brugo" ; -- status=guess
lin linger_V = variants {} ; --
lin lingerer_N = mkN "bighellone" | mkN "perdigiorno" ; -- UWN
lin lingerie_N = mkN "biancheria" | mkN "lingerie" feminine ; -- status=guess status=guess
lin lingo_N = mkN "argot" | mkN "frasario" | mkN "fraseologia" | mkN "gergo" | mkN "linguaggio" | mkN "slang" ; -- UWN
lin lingua_franca_N = mkN "coinè" | mkN "koinè" | mkN "lingua_franca" ; -- UWN
lin linguist_N = mkN "linguista" masculine ; -- status=guess
lin linguistic_A = mkA "linguistico" ; -- status=guess
lin linguistics_N = mkN "linguistica" ; -- status=guess
lin liniment_N = mkN "embrocazione" | mkN "linimento" ; -- UWN
lin link_N = mkN "connessione" feminine ; -- status=guess
lin link_V = mkV "collegare" | mkV "connettere" | mkV "linkare" ;
lin link_V2 = mkV2 (mkV "collegare") | mkV2 (mkV "connettere") | mkV2 (mkV "linkare") ;
lin link_up_V2 = prepV2 OP_link_V OP_up_Prep ; -- guess-p-verb
lin link_up_with_V2 = prepV2 (advV OP_link_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin linlithgow_PN = mkPN "Linlithgow" ; -- status=guess src=geonames
lin lino_N = mkN "linoleum" ; -- UWN
lin linoleum_N = mkN "linoleum" ; -- UWN
lin linseed_N = mkN "linosa" | mkN "linseme" ; -- UWN
lin lintel_N = mkN "architrave" ; -- UWN
lin linwood_PN = mkPN "Linwood" ; -- status=guess src=geonames
lin linz_PN = mkPN "Linz" ; -- status=guess src=geonames
lin lion_N = mkN "leone" feminine ; -- status=guess
lin lioness_N = mkN "leonessa" ; -- status=guess
lin lionet_N = mkN "leoncino" ; -- UWN
lin lip_N = mkN "labbro" ; -- status=guess
lin lipase_N = mkN "lipasi" ; -- UWN
lin lipid_N = mkN "grasso" | mkN "lipide" | mkN "lipoide" ; -- UWN
lin lipoprotein_N = mkN "lipoproteina lipasi" ; -- status=guess
lin liposuction_N = mkN "liposuzione" feminine ; -- status=guess
lin lipstick_N = mkN "rossetto" ; -- status=guess
lin liquefaction_N = mkN "liquefazione" feminine ; -- status=guess
lin liquefiable_A = mkA "liquefacibile" | mkA "liquefattibile" ; -- status=guess status=guess
lin liqueur_N = mkN "liquore" masculine ; -- status=guess
lin liquid_A = mkA "liquido" | mkA "liquida" ; -- status=guess status=guess
lin liquid_N = mkN "liquida" ; -- status=guess
lin liquidation_N = mkN "soppressione" ; -- UWN
lin liquidator_N = mkN "curatore_fallimentare" | mkN "liquidatore" ; -- UWN
lin liquidity_N = mkN "liquidità" feminine ; -- status=guess
lin liquidizer_N = mkN "frullatore" | mkN "mixer" ; -- UWN
lin liquor_N = mkN "liquore" masculine ; -- status=guess
lin liquorice_N = mkN "liquirizia" ; -- status=guess
lin lira_N = mkN "lira" ; -- status=guess
lin lisa_PN = mkPN "Lisa" ; -- status=guess src=geonames
lin lisbon_PN = mkPN "Lisbona" ; -- status=guess src=geonames
lin liskeard_PN = mkPN "Liskeard" ; -- status=guess src=geonames
lin lisle_N = mkN "filo_di_Scozia" ; -- UWN
lin lissomeness_N = mkN "duttilità" | mkN "flessuosità" | mkN "pieghevolezza" ; -- UWN
lin list_N = mkN "lista" ; -- status=guess
lin list_V = variants {} ; --
lin list_V2 = variants {} ; --
lin list_V2V = variants {} ; --
lin listen_V = mkV (dare_V) "ascolto" ; -- status=guess, src=wikt
lin listen_V2 = L.listen_V2 ; -- comment=CHECKED
lin listen_in_V = advV OP_listen_V OP_in_Adv ; -- guess-p-verb
lin listen_out_for_V2 = prepV2 (advV OP_listen_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin listen_up_V = advV OP_listen_V OP_up_Adv ; -- guess-p-verb
lin listenerFem_N = mkN "ascoltatore" | mkN "uditore" ; -- UWN
lin listenerMasc_N = variants {} ; --
lin listening_N = mkN "ascoltazione" | mkN "ascolto" ; -- UWN
lin listing_N = mkN "elencazione" ; -- UWN
lin listlessness_N = mkN "intorpidimento" | mkN "torpidezza" ; -- UWN
lin litany_N = mkN "litania" ; -- UWN
lin literacy_N = mkN "alfabetismo" | mkN "alfabetizzazione" feminine ; -- status=guess status=guess
lin literal_A = mkA "letterale" ; -- status=guess
lin literal_N = mkN "refuso" ; -- UWN
lin literary_A = mkA "letterario" ; -- status=guess
lin literate_N = mkN "alfabeta" ; -- UWN
lin literature_N = mkN "letteratura" ; -- status=guess
lin lithiasis_N = mkN "calcolosi" | mkN "litiasi" ; -- UWN
lin lithic_A = mkA "litioso" ; -- status=guess
lin lithium_N = mkN "litio" ; -- status=guess
lin lithographer_N = mkN "litografo" ; -- UWN
lin lithographic_A = mkA "litografico" ; -- status=guess
lin lithophyte_N = mkN "litofita" ; -- UWN
lin lithosphere_N = mkN "litosfera" ; -- status=guess
lin lithotomy_N = mkN "litotomia" ; -- UWN
lin litigant_N = mkN "contendente" | mkN "litigante" ; -- UWN
lin litigation_N = variants {} ; --
lin litigious_A = mkA "litigioso" ; -- status=guess
lin litmus_N = mkN "tornasole" masculine ; -- status=guess
lin litotes_N = mkN "litote" feminine ; -- status=guess
lin litre_N = mkN "litro" ; -- status=guess
lin litter_N = mkN "lettiera" ; -- status=guess
lin little_A = mkA "piccolo" ; -- status=guess
lin little_Det = variants {} ; --
lin little_N = mkN "bambino" ; -- status=guess
lin littlehampton_PN = mkPN "Littlehampton" ; -- status=guess src=geonames
lin littleness_N = mkN "meschinità" ; -- UWN
lin liturgical_A = mkA "liturgico" ; -- status=guess
lin liturgist_N = mkN "liturgista" | mkN "rubricista" ; -- UWN
lin liturgy_N = mkN "liturgia" ; -- UWN
lin live_A = mkA "vivo" ; -- status=guess
lin live_Adv = mkAdv "dal vivo" | mkAdv "live" ; -- status=guess status=guess
lin live_V = L.live_V ;
lin live_by_V2 = prepV2 OP_live_V OP_by_Prep ; -- guess-p-verb
lin live_down_V2 = prepV2 OP_live_V OP_down_Prep ; -- guess-p-verb
lin live_for_V2 = prepV2 OP_live_V OP_for_Prep ; -- guess-p-verb
lin live_in_V = advV OP_live_V OP_in_Adv ; -- guess-p-verb
lin live_it_up_V2 = variants {} ; -- guess-p-verb
lin live_off_V2 = prepV2 OP_live_V OP_off_Prep ; -- guess-p-verb
lin live_on_V = mkV "campare" | mkV "reggere" | mkV "resistere" | mkV "sopravvivere" | mkV "vivere" ; -- UWN
lin live_on_V2 = prepV2 OP_live_V OP_on_Prep ; -- guess-p-verb
lin live_out_V = advV OP_live_V OP_out_Adv ; -- guess-p-verb
lin live_out_V2 = prepV2 OP_live_V OP_out_Prep ; -- guess-p-verb
lin live_through_V2 = prepV2 OP_live_V OP_through_Prep ; -- guess-p-verb
lin live_together_V = advV OP_live_V OP_together_Adv ; -- guess-p-verb
lin live_up_V = advV OP_live_V OP_up_Adv ; -- guess-p-verb
lin live_up_to_V2 = prepV2 (advV OP_live_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin live_with_V2 = prepV2 OP_live_V OP_with_Prep ; -- guess-p-verb
lin livelihood_N = mkN "mantenimento" | mkN "pane" | mkN "sostentamento" ; -- UWN
lin lively_A = mkA "vivace" | mkA "brioso" | mkA "briosa" ; -- status=guess status=guess status=guess
lin liven_V = mkV "animare" | mkV "animare" | mkV "animarsi" | mkV "movimentare" | mkV "vivacizzare" | mkV "vivacizzarsi" ; -- UWN
lin liver_N = L.liver_N ;
lin liverish_A = mkA "fegatoso" ; -- status=guess
lin liverpool_PN = mkPN "Liverpool" ; -- status=guess src=geonames
lin liverwort_N = mkN "epatiche" ; -- status=guess
lin livery_N = mkN "livrea" ; -- status=guess
lin livestock_N = mkN "bestiame" masculine ; -- status=guess
lin lividity_N = mkN "lividezza" | mkN "pallore" ; -- UWN
lin lividness_N = mkN "lividezza" | mkN "pallore" ; -- UWN
lin living_A = variants {} ; --
lin living_N = mkN "soggiorno" | mkN "salotto" ; -- status=guess status=guess
lin living_room_N = mkN "sala" | mkN "salotto" | mkN "soggiorno" ; -- UWN
lin livingston_PN = mkPN "Livingston" ; -- status=guess src=geonames
lin livorno_PN = mkPN "Livorno" ; -- status=guess src=geonames
lin lizard_N = mkN "lucertola" ; -- status=guess
lin ljubljana_PN = mkPN "Lubiana" ; -- status=guess src=geonames
lin llama_N = mkN "lama" masculine ; -- status=guess
lin llandudno_PN = mkPN "Llandudno" ; -- status=guess src=geonames
lin llanelli_PN = mkPN "Llanelli" ; -- status=guess src=geonames
lin llangollen_PN = mkPN "Llangollen" ; -- status=guess src=geonames
lin llantrisant_PN = mkPN "Llantrisant" ; -- status=guess src=geonames
lin load_N = mkN "un sacco m singular" ; -- status=guess
lin load_V = variants {} ; --
lin load_V2 = variants {} ; --
lin loading_N = mkN "caricamento" | mkN "carico" ; -- UWN
lin loaf_N = mkN "pagnotta" | mkN "pan carrè" | mkN "pane in cassetta" ; -- status=guess status=guess status=guess
lin loaf_V = mkV "oziare" ; -- status=guess, src=wikt
lin loaf_V2 = mkV2 (mkV "oziare") ; -- status=guess, src=wikt
lin loan_N = mkN "prestito" | mkN "mutuo" ; -- status=guess status=guess
lin loan_V2 = mkV2 (mkV "prestare") ; -- status=guess, src=wikt
lin loanhead_PN = mkPN "Loanhead" ; -- status=guess src=geonames
lin loanword_N = mkN "calco" ; -- status=guess
lin loathe_V2 = mkV2 (mkV "detestare") | mkV2 (mkV "odiare") | mkV2 (mkV "aborrire") | mkV2 (mkV "abominare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin lob_N = mkN "pallonetto" ; -- status=guess
lin lob_V = mkV (mkV "tirare") "un pallonetto" ; -- status=guess, src=wikt
lin lob_V2 = mkV2 (mkV (mkV "tirare") "un pallonetto") ; -- status=guess, src=wikt
lin lobar_A = mkA "lobare" ; -- UWN
lin lobby_N = mkN "atrio" ; -- status=guess
lin lobbyist_N = mkN "lobbista" | mkN "lobbysta" ; -- UWN
lin lobe_N = mkN "lobo" ; -- status=guess
lin lobectomy_N = mkN "lobectomia" ; -- UWN
lin lobelia_N = mkN "lobelia" ; -- UWN
lin lobotomy_N = mkN "lobotomia" ; -- UWN
lin lobster_N = mkN "astice" | mkN "aragosta" ; -- status=guess status=guess
lin lobule_N = mkN "lobulo" ; -- UWN
lin local_A = mkA "locale" ;
lin local_N = mkN "locale" ; -- status=guess
lin locality_N = variants {} ; --
lin localization_N = mkN "localizzazione" feminine ; -- status=guess
lin localize_V2 = mkV2 (mkV "localizzare") ; -- status=guess, src=wikt
lin locate_V = mkV "insediarsi" | mkV "stabilirsi" | mkV "stanziarsi" ; -- UWN
lin locate_V2 = variants {} ; --
lin location_N = mkN "posizione" feminine ; -- status=guess
lin lochgelly_PN = mkPN "Lochgelly" ; -- status=guess src=geonames
lin lock_N = mkN "otturatore" masculine ; -- status=guess
lin lock_V = mkV "bloccarsi" | mkV "incepparsi" ; -- status=guess, src=wikt status=guess, src=wikt
lin lock_V2 = mkV2 (mkV "bloccarsi") | mkV2 (mkV "incepparsi") ; -- status=guess, src=wikt status=guess, src=wikt
lin lock_away_V2 = mkV2 (advV OP_lock_V OP_away_Adv ) ; -- guess-p-verb
lin lock_down_V2 = prepV2 OP_lock_V OP_down_Prep ; -- guess-p-verb
lin lock_in_V2 = prepV2 OP_lock_V OP_in_Prep ; -- guess-p-verb
lin lock_onto_V2 = prepV2 OP_lock_V OP_onto_Prep ; -- guess-p-verb
lin lock_out_V2 = prepV2 OP_lock_V OP_out_Prep ; -- guess-p-verb
lin lock_up_V2 = prepV2 OP_lock_V OP_up_Prep ; -- guess-p-verb
lin lock_yourself_away_V = variants {} ; -- guess-p-verb
lin locker_N = mkN "armadietto" ; -- status=guess
lin locket_N = mkN "medaglione" ; -- status=guess
lin locking_N = mkN "bloccaggio" | mkN "fermo" ; -- UWN
lin locknut_N = mkN "controdado" ; -- UWN
lin lockout_N = mkN "serrata" ; -- status=guess
lin locksmith_N = mkN "chiavaio" | mkN "fabbro_ferraio" | mkN "magnano" ; -- UWN
lin lockup_N = mkN "bloccaggio" | mkN "fermo" ; -- UWN
lin locomotion_N = mkN "locomozione" feminine ; -- status=guess
lin locomotive_N = mkN "locomotiva" | mkN "macchina" | mkN "motrice" ; -- UWN
lin locum_N = mkN "interino" ; -- UWN
lin locum_tenens_N = mkN "interino" ; -- UWN
lin locust_N = mkN "locusta" ; -- status=guess
lin locution_N = mkN "detto" | mkN "espressione" ; -- UWN
lin lode_N = mkN "filone" masculine ; -- status=guess
lin lodge_N = mkN "loggia" ; -- status=guess
lin lodge_V = mkV "alloggiare" ; -- status=guess, src=wikt
lin lodge_V2 = mkV2 (mkV "alloggiare") ; -- status=guess, src=wikt
lin lodger_N = mkN "affittuario" | mkN "inquilino" | mkN "locatario" | mkN "pensionante" ; -- UWN
lin loess_N = mkN "loess" masculine ; -- status=guess
lin loftus_PN = mkPN "Loftus" ; -- status=guess src=geonames
lin lofty_A = mkA "maestoso" ; -- status=guess
lin log_N = mkN "tronchetto" ; -- status=guess
lin log_V2 = mkV2 (mkV "registrarsi") ; -- status=guess, src=wikt
lin logarithm_N = mkN "logaritmo" ; -- status=guess
lin logarithmic_A = mkA "logaritmico" ; -- status=guess
lin logbook_N = mkN "giornale di bordo" ; -- status=guess
lin loggia_N = mkN "loggia" | mkN "portico" ; -- status=guess status=guess
lin logic_N = mkN "logica" ; -- status=guess
lin logical_A = mkA "logico" ; -- status=guess
lin logician_N = mkN "logico" ; -- UWN
lin logicism_N = mkN "logicismo" ; -- UWN
lin logistic_A = mkA "logistico" ; -- status=guess
lin logistics_N = mkN "logistica" ; -- status=guess
lin logo_N = mkN "logotipo" | mkN "logo" ; -- status=guess status=guess
lin logogram_N = mkN "logogramma" masculine ; -- status=guess
lin logorrhea_N = mkN "logorrea" ; -- status=guess
lin logwood_N = mkN "campeccio" | mkN "campeggio" ; -- UWN
lin loin_N = mkN "lombata" ; -- status=guess
lin loincloth_N = mkN "perizoma" ; -- UWN
lin loiter_V = mkV "attardarsi" | mkV "aggirarsi" | mkV "gironzolare" | mkV "vagabondare" | mkV "oziare" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin loiter_V2 = mkV2 (mkV "attardarsi") | mkV2 (mkV "aggirarsi") | mkV2 (mkV "gironzolare") | mkV2 (mkV "vagabondare") | mkV2 (mkV "oziare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin loiterer_N = mkN "bighellone" | mkN "perdigiorno" ; -- UWN
lin loll_V = mkV "ciondolare" | mkV "indugiare" | mkV "meriggiare" | mkV "oziare" ; -- UWN
lin lollipop_N = mkN "lecca-lecca" masculine ; -- status=guess
lin lolly_N = mkN "ghiacciolo" ; -- UWN
lin loment_N = mkN "lomento" ; -- UWN
lin london_PN = mkPN "Londra" ; -- status=guess src=geonames
lin londonderry_PN = mkPN "Londonderry" ; -- status=guess src=geonames
lin lone_A = mkA "solo" ; -- status=guess
lin loneliness_N = mkN "solitudine" feminine ; -- status=guess
lin lonely_A = mkA "solo" | mkA "solitario" | mkA "malinconico" ; -- status=guess status=guess status=guess
lin loner_N = mkN "eremita" masculine ; -- status=guess
lin lonesome_A = mkA "solo" ; -- UWN
lin long_A = L.long_A ;
lin long_N = mkN "braccio della legge" ; -- status=guess
lin long_V = mkV "bramare" ; -- status=guess, src=wikt
lin long_term_A = variants {} ; --
lin longevity_N = mkN "longevità" ; -- status=guess
lin longhand_N = mkN "corsivo" ; -- UWN
lin longing_N = mkN "brama" ; -- status=guess
lin longingly_Adv = mkAdv "bramosamente" | mkAdv "desiderosamente" | mkAdv "vogliosamente" ; -- UWN
lin longitude_N = mkN "longitudine" feminine ; -- status=guess
lin longitudinal_A = mkA "longitudinale" ; -- UWN
lin longridge_PN = mkPN "Longridge" ; -- status=guess src=geonames
lin longshoreman_N = mkN "camallo" | mkN "scaricatore di porto" ; -- status=guess status=guess
lin longton_PN = mkPN "Longton" ; -- status=guess src=geonames
lin longways_Adv = mkAdv "longitudinalmente" ; -- UWN
lin longwise_Adv = mkAdv "longitudinalmente" ; -- UWN
lin loo_N = mkN "cesso" ; -- status=guess
lin look_N = mkN "occhiata" ; -- status=guess
lin look_V = mkV "guardare" | mkV "osservare" ;
lin look_V2 = mkV2 (mkV "guardare") ;
lin look_VA = mkVA (mkV "sembrare") ;
lin look_after_V2 = prepV2 OP_look_V OP_after_Prep ; -- guess-p-verb
lin look_ahead_to_V2 = prepV2 (advV OP_look_V OP_ahead_Adv ) OP_to_Prep ; -- guess-p-verb
lin look_around_V = advV OP_look_V OP_around_Adv ; -- guess-p-verb
lin look_around_at_V2 = prepV2 (advV OP_look_V OP_around_Adv ) OP_at_Prep ; -- guess-p-verb
lin look_at_V2 = prepV2 OP_look_V OP_at_Prep ; -- guess-p-verb
lin look_back_V = mkV "scorrere" ; -- UWN
lin look_back_on_V2 = prepV2 (advV OP_look_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin look_down_V = advV OP_look_V OP_down_Adv ; -- guess-p-verb
lin look_down_on_V2 = prepV2 (advV OP_look_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin look_for_V2 = prepV2 OP_look_V OP_for_Prep ; -- guess-p-verb
lin look_forward_V = advV OP_look_V OP_forward_Adv ; -- guess-p-verb
lin look_forward_to_V2 = prepV2 (advV OP_look_V OP_forward_Adv ) OP_to_Prep ; -- guess-p-verb
lin look_in_V2 = prepV2 OP_look_V OP_in_Prep ; -- guess-p-verb
lin look_in_on_V2 = prepV2 (advV OP_look_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin look_into_V2 = prepV2 OP_look_V OP_into_Prep ; -- guess-p-verb
lin look_on_V = mkV "considerare" | mkV "pensare" ; -- UWN
lin look_on_as_V3 = variants {} ; -- guess-p-verb
lin look_out_V = advV OP_look_V OP_out_Adv ; -- guess-p-verb
lin look_out_for_V2 = prepV2 (advV OP_look_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin look_over_V2 = prepV2 OP_look_V OP_over_Prep ; -- guess-p-verb
lin look_round_V2 = prepV2 OP_look_V OP_round_Prep ; -- guess-p-verb
lin look_through_V2 = prepV2 OP_look_V OP_through_Prep ; -- guess-p-verb
lin look_to_V2 = prepV2 OP_look_V OP_to_Prep ; -- guess-p-verb
lin look_toward_V2 = prepV2 OP_look_V OP_toward_Prep ; -- guess-p-verb
lin look_up_V = mkV "consultare" ; -- UWN
lin look_up_V2 = prepV2 OP_look_V OP_up_Prep ; -- guess-p-verb
lin look_up_to_V2 = prepV2 (advV OP_look_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin look_upon_as_V3 = variants {} ; -- guess-p-verb
lin looking_N = mkN "occhiata" | mkN "sguardo" ; -- UWN
lin loom_N = mkN "telaio" ; -- status=guess
lin loom_V = mkV "incombere" ; -- status=guess, src=wikt
lin loon_N = mkN "matto" | mkN "scemo" | mkN "stolto" | mkN "fannullone" ; -- status=guess status=guess status=guess status=guess
lin loop_1_N = mkN "cerchio della morte" | mkN "giro della morte" ; -- status=guess status=guess
lin loop_2_N = mkN "cerchio della morte" | mkN "giro della morte" ; -- status=guess status=guess
lin loophole_N = mkN "scappatoia" | mkN "cavillo" ; -- status=guess status=guess
lin loose_A = mkA "sciolto" ; -- status=guess
lin loose_Adv = mkAdv "gratis" | mkAdv "gratuitamente" ; -- UWN
lin loose_V2 = mkV2 (disfare_V) ; -- status=guess, src=wikt
lin loosen_V = mkV "allentare" ; -- status=guess, src=wikt
lin loosen_V2 = mkV2 (mkV "allentare") ; -- status=guess, src=wikt
lin loosen_up_V = mkV "rilassare" ; -- UWN
lin looseness_N = mkN "dissolutezza" | mkN "scostumatezza" ; -- UWN
lin loosestrife_N = mkN "lisimachia" ; -- UWN
lin loot_N = mkN "bottino" | mkN "maltolto" ; -- status=guess status=guess
lin loot_V = mkV "saccheggiare" ; -- status=guess, src=wikt
lin loot_V2 = mkV2 (mkV "saccheggiare") ; -- status=guess, src=wikt
lin looter_N = mkN "predatore" | mkN "predone" | mkN "saccheggiatore" | mkN "spogliatore" ; -- UWN
lin looting_N = mkN "razzia" ; -- UWN
lin lope_V = mkV (mkV "procedere") "a lunghi salti" ; -- status=guess, src=wikt
lin loquacious_A = mkA "loquace" ; -- status=guess
lin loquaciousness_N = mkN "chiacchiera" | mkN "garrulità" | mkN "loquacità" | mkN "parlantina" | mkN "scilinguagnolo" ; -- UWN
lin loquacity_N = mkN "loquacità" feminine ; -- status=guess
lin loquat_N = mkN "nespola" ; -- status=guess
lin lord_N = mkN "signore" masculine ; -- status=guess
lin lord_V2 = mkV2 (mkV "dominare") | mkV2 (mkV "governare") ; -- status=guess, src=wikt status=guess, src=wikt
lin lordship_N = mkN "dominio" ; -- status=guess
lin lorica_N = mkN "lorica" ; -- UWN
lin lorikeet_N = mkN "lorichetto" | mkN "tricoglosso" ; -- UWN
lin lorry_N = mkN "truck" ; -- UWN
lin los_angeles_PN = mkPN "Los Angeles" ; -- status=guess src=geonames
lin lose_V = perdere_V ; -- status=guess, src=wikt
lin lose_V2 = L.lose_V2 ;
lin lose_out_V = advV OP_lose_V OP_out_Adv ; -- guess-p-verb
lin lose_out_on_V2 = prepV2 (advV OP_lose_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin lose_out_to_V2 = prepV2 (advV OP_lose_V OP_out_Adv ) OP_to_Prep ; -- guess-p-verb
lin lose_up_V = advV OP_lose_V OP_up_Adv ; -- guess-p-verb
lin loss_N = variants {} ; --
lin lossiemouth_PN = mkPN "Lossiemouth" ; -- status=guess src=geonames
lin lost_A = variants {} ; --
lin lot_1_N = mkN "destino" ; -- status=guess
lin lot_2_N = mkN "destino" ; -- status=guess
lin lot_3_N = mkN "destino" ; -- status=guess
lin loti_N = mkN "loti" | mkN "loti_del_Lesotho" ; -- UWN
lin lottery_N = mkN "lotteria" ; -- status=guess
lin lotto_N = mkN "bingo" | mkN "tombola" ; -- UWN
lin lotus_N = mkN "loto" ; -- status=guess
lin loud_A = mkA "rumoroso" ; -- status=guess
lin loud_Adv = variants {} ; --
lin loudmouth_N = mkN "lingwacciuto" ; -- status=guess
lin loudness_N = mkN "pacchianeria" | mkN "vistosità" ; -- UWN
lin loudspeaker_N = mkN "altoparlante" masculine ; -- status=guess
lin loughborough_PN = mkPN "Loughborough" ; -- status=guess src=geonames
lin louisiana_PN = mkPN "Louisiana" ; -- status=guess src=geonames
lin louisville_PN = mkPN "Louisville" ; -- status=guess src=geonames
lin lounge_N = mkN "sala_d'aspetto" | mkN "sala_d'attesa" ; -- UWN
lin louse_N = L.louse_N ; -- comment=CHECKED
lin lousy_A = mkA "pidocchioso" ; -- status=guess
lin lout_N = mkN "goffo" | mkN "maldestro" | mkN "bifolco" | mkN "zotico" ; -- status=guess status=guess status=guess status=guess
lin louth_PN = mkPN "Louth" ; -- status=guess src=geonames
lin louver_N = mkN "feritoia" ; -- status=guess
lin lovage_N = mkN "levistico" | mkN "sedano di montagna" ; -- status=guess status=guess
lin love_N = L.love_N ;
lin love_V2 = L.love_V2 ;
lin lovebird_N = mkN "inseparabile" masculine ; -- status=guess
lin loveliness_N = mkN "amenità" feminine ; -- status=guess
lin lovely_A = variants {} ; --
lin lover_N = mkN "amante" masculine ; -- status=guess
lin loving_A = mkA "affabile" | mkA "affettuoso" | mkA "amorevole" | mkA "amoroso" | mkA "benevolo" | mkA "bonario" | mkA "compito" | mkA "comunicativo" | mkA "cordiale" | mkA "dimestichevole" | mkA "estroverso" | mkA "materno" | mkA "mite" | mkA "paterno" | mkA "tenero" ; -- UWN
lin lovingness_N = mkN "affettuosità" ; -- UWN
lin low_A = mkA "basso" ; -- status=guess
lin low_Adv = mkAdv "basso" ; -- UWN
lin lowbrow_N = mkN "borghesuccio" | mkN "filisteo" ; -- UWN
lin lower_V = mkV "abbassare" ; -- status=guess, src=wikt
lin lower_V2 = mkV2 (mkV "abbassare") ; -- status=guess, src=wikt
lin lowestoft_PN = mkPN "Lowestoft" ; -- status=guess src=geonames
lin lowland_N = mkN "bassa" | mkN "bassopiano" ; -- UWN
lin lox_N = mkN "salmone affumicato" ; -- status=guess
lin loyal_A = mkA "leale" ; -- status=guess
lin loyalist_N = mkN "lealista" masculine ; -- status=guess
lin loyalty_N = mkN "lealtà" feminine ; -- status=guess
lin lozenge_N = mkN "pastiglia" ; -- status=guess
lin lubber_N = mkN "goffo" | mkN "maldestro" | mkN "zoticone" | mkN "villano" | mkN "marinaio inesperto" | mkN "marinaio d'acqua dolce" ; -- status=guess status=guess status=guess status=guess status=guess status=guess
lin lubeck_PN = mkPN "Lubeck" ; -- status=guess src=geonames
lin lubricant_N = mkN "lubrificante" masculine ; -- status=guess
lin lubricate_V2 = mkV2 (mkV "lubrificare") ; -- status=guess, src=wikt
lin lubrication_N = mkN "ingrassaggio" | mkN "lubrificazione" | mkN "oliatura" | mkN "ungitura" ; -- UWN
lin lucid_A = mkA "lucido" ; -- status=guess
lin lucidity_N = mkN "chiarezza" | mkN "limpidezza" | mkN "lucidità" | mkN "nettezza" | mkN "nitidezza" | mkN "nitore" | mkN "perspicuità" ; -- UWN
lin lucifer_N = mkN "fiammifero" | mkN "zolfanello" ; -- UWN
lin luck_N = mkN "fortuna" | mkN "sorte" feminine ; -- status=guess status=guess
lin luckily_Adv = adjAdv lucky_A ; -- derived
lin lucknow_PN = mkPN "Lucknow" ; -- status=guess src=geonames
lin lucky_A = mkA "fortunato" | mkA "fortunata" ; -- status=guess status=guess
lin lucubration_N = mkN "elucubrazioni" ; -- UWN
lin ludicrous_A = mkA "ridicolo" ; -- status=guess
lin ludlow_PN = mkPN "Ludlow" ; -- status=guess src=geonames
lin luff_N = mkN "inferitura" ; -- status=guess
lin luff_V = mkV "fileggiare" ; -- UWN
lin lug_N = mkN "arenicola" ; -- UWN
lin luggage_N = mkN "bagaglio" ; -- status=guess
lin lugsail_N = mkN "aurica" | mkN "vela aurica" ; -- status=guess status=guess
lin lugubrious_A = mkA "lugubre" ; -- status=guess
lin lugworm_N = mkN "arenicola" ; -- UWN
lin lukewarm_A = mkA "tiepido" | mkA "tiepida" ; -- status=guess status=guess
lin lukewarmness_N = mkN "tiepidezza" ; -- UWN
lin lull_V = mkV (I.fare_V) "la ninna nanna" | mkV (I.fare_V) "addormentare" | mkV (indurre_V) "al sonno" ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin lull_V2 = mkV2 (mkV (I.fare_V) "la ninna nanna") | mkV2 (mkV (I.fare_V) "addormentare") | mkV2 (mkV (indurre_V) "al sonno") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin lullaby_N = mkN "ninna nanna" ; -- status=guess
lin lumbago_N = mkN "lombaggine" feminine ; -- status=guess
lin lumbar_A = mkA "lombare" ; -- status=guess
lin lumber_N = mkN "legname" masculine ; -- status=guess
lin lumberjack_N = mkN "boscaiolo" ; -- status=guess
lin lumberman_N = mkN "boscaiolo" | mkN "taglialegna" ; -- UWN
lin lumber_mill_N = mkN "segheria" ; -- UWN
lin luminary_N = mkN "autorità" | mkN "luminare" | mkN "notabile" | mkN "notabilità" ; -- UWN
lin luminescence_N = mkN "luminescenza" ; -- status=guess
lin luminescent_A = mkA "luminescente" ; -- status=guess
lin luminosity_N = mkN "luminosità" feminine ; -- status=guess
lin luminous_A = mkA "luminoso" ; -- status=guess
lin lump_N = mkN "cucchiaino" | mkN "zolla" | mkN "zolletta" | mkN "forfait" masculine ; -- status=guess status=guess status=guess status=guess
lin lumpsucker_N = mkN "cicloterro" ; -- status=guess
lin lunacy_N = mkN "pazzia" ; -- status=guess
lin lunar_A = mkA "lunare" ; -- status=guess
lin lunatic_N = mkN "demente" masculine ; -- status=guess
lin lunch_N = mkN "pranzo" | mkN "seconda colazione" feminine ; -- status=guess status=guess
lin lunch_V = mkV "pranzare" ; -- status=guess, src=wikt
lin lunch_V2 = mkV2 (mkV "pranzare") ; -- status=guess, src=wikt
lin luncheon_N = mkN "colazione" | mkN "desinare" | mkN "pranzo" | mkN "seconda_colazione" ; -- UWN
lin lunchtime_N = variants {} ; --
lin lunette_N = mkN "lunetta" ; -- UWN
lin lung_N = mkN "polmone" masculine ; -- status=guess
lin lunge_V = mkV "gettarsi" | mkV "sbalzare" ; -- UWN
lin lunger_N = mkN "tisico" ; -- UWN
lin lunisolar_A = mkA "lunisolare" ; -- UWN
lin lupin_N = mkN "lupino" ; -- UWN
lin lupine_N = mkN "lupino" ; -- status=guess
lin lupus_N = mkN "lupus" masculine ; -- status=guess
lin lurch_N = mkN "barcollio" | mkN "sbilanciamento" ; -- status=guess status=guess
lin lurch_V = mkV "barcollare" ; -- status=guess, src=wikt
lin lure_N = mkN "esca" ; -- status=guess
lin lure_V2 = mkV2 (sedurre_V) | mkV2 (mkV "incantare") | mkV2 (mkV "ammaliare") | mkV2 (mkV "tentare") | mkV2 (mkV "adescare") ; -- status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt status=guess, src=wikt
lin lust_N = mkN "lussuria" ; -- status=guess
lin luster_N = mkN "lustro" ; -- status=guess
lin lustrum_N = mkN "quinquennio" ; -- status=guess
lin lutanist_N = mkN "liutista" ; -- UWN
lin lute_N = mkN "liuto" ; -- status=guess
lin luteal_A = mkA "luteale" | mkA "luteo" ; -- status=guess status=guess
lin lutenist_N = mkN "liutista" ; -- UWN
lin lutetium_N = mkN "lutezio" ; -- status=guess
lin luthier_N = mkN "liutaio" ; -- status=guess
lin lutist_N = mkN "liutista" masculine ; -- status=guess
lin luton_PN = mkPN "Luton" ; -- status=guess src=geonames
lin lux_N = mkN "lux" ; -- status=guess
lin luxation_N = mkN "lussatura" | mkN "lussazione" ; -- UWN
lin luxembourg_PN = mkPN "Lussemburgo" ; -- status=guess src=geonames
lin luxuriance_N = mkN "rigoglio" ; -- UWN
lin luxurious_A = mkA "lussuoso" ; -- status=guess
lin luxury_A = variants {} ; --
lin luxury_N = mkN "lusso" feminine ; -- status=guess
lin lwei_N = mkN "lwei" | mkN "lwei_dell'Angola" ; -- UWN
lin lycanthropy_N = mkN "licantropia" ; -- UWN
lin lychee_N = mkN "litchi" ; -- UWN
lin lychnis_N = mkN "licnide" ; -- UWN
lin lydney_PN = mkPN "Lydney" ; -- status=guess src=geonames
lin lye_N = mkN "liscivia" | mkN "cenerata" ; -- status=guess status=guess
lin lymington_PN = mkPN "Lymington" ; -- status=guess src=geonames
lin lymm_PN = mkPN "Lymm" ; -- status=guess src=geonames
lin lymph_N = mkN "lympha" ; -- status=guess
lin lymphatic_A = mkA "linfatico" ; -- UWN
lin lymphocyte_N = mkN "linfocita" masculine ; -- status=guess
lin lymphoid_A = mkA "linfoide" ; -- UWN
lin lymphoma_N = mkN "linfoma" masculine ; -- status=guess
lin lynching_N = mkN "linciaggio" ; -- status=guess
lin lynchpin_N = mkN "acciarino" ; -- UWN
lin lynn_PN = mkPN "Lynn" ; -- status=guess src=geonames
lin lynx_N = mkN "lince" feminine ; -- status=guess
lin lyons_PN = mkPN "Lyons" ; -- status=guess src=geonames
lin lyre_N = mkN "lira" ; -- status=guess
lin lyre_bird_N = mkN "lira" | mkN "uccello_lira" ; -- UWN
lin lyric_N = mkN "canto" | mkN "lira" | mkN "lirica" ; -- UWN
lin lyricality_N = mkN "musicalità" ; -- UWN
lin lyricist_N = mkN "paroliere" ; -- UWN
lin lysine_N = mkN "lisina" ; -- status=guess
lin lysis_N = mkN "lisi" ; -- UWN
lin lysosome_N = mkN "lisosoma" masculine ; -- status=guess
lin ma_N = mkN "mamma" ; -- status=guess
lin maastricht_PN = mkPN "Maastricht" ; -- status=guess src=geonames
lin macaque_N = mkN "macacco" | mkN "macaco" ; -- UWN
lin macaroni_N = mkN "maccheroni" masculine ; -- status=guess
lin macaronic_A = mkA "macaronico" | mkA "maccheronico" ; -- UWN
lin macaroon_N = mkN "amaretto" ; -- status=guess
lin macaw_N = mkN "Ara" | mkN "ara" ; -- UWN
lin macclesfield_PN = mkPN "Macclesfield" ; -- status=guess src=geonames
lin mace_N = mkN "macis" masculine ; -- status=guess
lin mace_bearer_N = mkN "mazziere" ; -- UWN
lin macerate_V = mkV "macerare" ; -- status=guess, src=wikt
lin macerate_V2 = mkV2 (mkV "macerare") ; -- status=guess, src=wikt
lin maceration_N = mkN "maceramento" ; -- status=guess
lin mach_PN = mkPN "Mach" ; -- status=guess src=geonames
lin machete_N = mkN "machete" masculine ; -- status=guess
lin machine_N = mkN "macchina" ; -- status=guess
lin machinery_N = mkN "macchinario" ; -- status=guess
lin machismo_N = mkN "machismo" ; -- status=guess
lin machmeter_N = mkN "machmetro" ; -- UWN
lin macho_N = mkN "macho" ; -- status=guess
lin mackerel_N = mkN "sgombro" ; -- status=guess
lin macrame_N = mkN "macramè" ; -- UWN
lin macro_N = mkN "macro" | mkN "macroistruzione" ; -- UWN
lin macrobiotic_A = mkA "macrobiotico" ; -- status=guess
lin macrobiotics_N = mkN "macrobiotica" ; -- status=guess
lin macrocephalic_A = mkA "macrocefalo" ; -- status=guess
lin macrocephaly_N = mkN "macrocefalia" ; -- status=guess
lin macrocytosis_N = mkN "macrocitosi" ; -- status=guess
lin macroeconomic_A = mkA "macroeconomico" ; -- status=guess
lin macroeconomics_N = mkN "macroeconomia" ; -- status=guess
lin macroglossia_N = mkN "macroglossia" ; -- status=guess
lin macromolecular_A = mkA "macromolecolare" ; -- status=guess
lin macromolecule_N = mkN "macromolecola" ; -- status=guess
lin macron_N = mkN "macron" masculine ; -- status=guess
lin macrophage_N = mkN "macrofago" ; -- status=guess
lin macroscopic_A = mkA "macroscopico" ; -- status=guess
lin macula_N = mkN "macula" ; -- status=guess
lin mad_A = mkA "pazzo" | mkA "folle" | mkA "matto" | mkA "insano" ; -- status=guess status=guess status=guess status=guess
lin madagascar_PN = mkPN "Madagascar" ; -- status=guess src=geonames
lin madam_N = mkN "padrona di casa" ; -- status=guess
lin madder_N = mkN "rosso di robbia" ; -- status=guess
lin madman_N = mkN "matto" | mkN "pazzo" ; -- status=guess status=guess
lin madness_N = mkN "follia" | mkN "pazzia" | mkN "insanità" ; -- status=guess status=guess status=guess
lin madras_N = mkN "madras" ; -- UWN
lin madras_PN = mkPN "Madras" ; -- status=guess src=geonames
lin madrid_PN = mkPN "Madrid" ; -- status=guess src=geonames
lin madrigal_N = mkN "madrigale" masculine ; -- status=guess
lin madrigalist_N = mkN "madrigalista" ; -- UWN
lin madurai_PN = mkPN "Madurai" ; -- status=guess src=geonames
lin madwoman_N = mkN "matta" | mkN "pazza" ; -- status=guess status=guess
lin maenad_N = mkN "baccante" | mkN "menade" | mkN "tiade" ; -- UWN
lin maesteg_PN = mkPN "Maesteg" ; -- status=guess src=geonames
lin maestro_N = mkN "maestro" ; -- UWN
lin mafia_N = mkN "mafia" ; -- status=guess
lin magazine_N = mkN "caricatore" masculine ; -- status=guess
lin magdeburg_PN = mkPN "Magdeburgo" ; -- status=guess src=geonames
lin magenta_A = mkA "magenta" ; -- status=guess
lin magenta_N = mkN "magenta" ; -- status=guess
lin maggot_N = mkN "baco" | mkN "verme" ma