--# -path=.:../common:../abstract:../prelude

-- work by Aarne Ranta, Andreas Priesnitz, and Henning Thielemann.
-- a few corrections by Hans Leiß, and using the better IrregGer 

concrete LexiconGer of Lexicon = CatGer ** 
  open Prelude, ParadigmsGer, (Mo = MorphoGer), (Irreg = IrregGer) in {

flags 
    coding=utf8 ;
  optimize=all_subs ;

lin
  add_V3 = dirV3 (prefixV "hinzu" (regV "fügen")) zu_Prep ;
  airplane_N = mkN "Flugzeug" "Flugzeuge" neuter ;
  already_Adv = mkAdv "schon" ;
  answer_V2S = mkV2S (regV "antworten") datPrep ;
  apartment_N = mkN "Wohnung" ;
  apple_N = reg2N "Apfel" "Äpfel" masculine  ;
  art_N = reg2N "Kunst" "Künste" feminine ;
  ask_V2Q = mkV2Q (regV "fragen") accPrep ;
  baby_N = reg2N "Baby" "Babies" neuter ; ----
  bad_A = regA "schlecht" ;
  bank_N = reg2N "Bank" "Banken" feminine ;
  beautiful_A = regA "schön" ;
  become_VA = mkVA Irreg.werden_V ;
  beer_N = reg2N "Bier" "Biere" neuter ;
  beg_V2V = mkV2V (mk6V "bitten" "bittet" "bitte" "bat" "bäte" "gebeten") accPrep ;
  big_A = mk3A "groß" "größer" "größte" ;
  bike_N = reg2N "Fahrrad" "Fahrräder" neuter ;
  bird_N = reg2N "Vogel" "Vögel" masculine ;
  black_A = mk3A "schwarz" "schwärzer" "schwärzeste" ; 
  blue_A = regA "blau";
  boat_N = reg2N "Boot" "Boote" neuter ;
  book_N = reg2N "Buch" "Bücher" neuter ;
  boot_N = reg2N "Stiefel" "Stiefel" masculine ;
  boss_N = reg2N "Chef" "Chefs" masculine ; ----
  boy_N = reg2N "Junge" "Jungen" masculine ;
  bread_N = reg2N "Brot" "Brote" neuter ;
  break_V2 = dirV2 (fixprefixV "zer" Irreg.schlagen_V) ;
  broad_A = regA "breit" ;
  brother_N2 = mkN2 (reg2N "Bruder" "Brüder" masculine)  von_Prep ;
  brown_A = regA "braun" ;
  butter_N = reg2N "Butter" "Butter" feminine ; ---- infl
  buy_V2 = dirV2 (regV "kaufen") ;
  camera_N = reg2N "Kamera" "Kameras" feminine ;
  cap_N = mkN "Mütze" ;
  car_N = mkN "Auto" "Autos" neuter | mkN "Wagen" "Wagen" masculine ;
  carpet_N = mkN "Teppich" ;
  cat_N = mkN "Katze" ;
  ceiling_N = reg2N "Dach" "Dächer" neuter ;
  chair_N = reg2N "Stuhl" "Stühle" masculine ;
  cheese_N = mkN "Käse" "Käse" masculine ;
  child_N = reg2N "Kind" "Kinder" neuter ;
  church_N = mkN "Kirche" ;
  city_N = reg2N "Stadt" "Städte" feminine ;
  clean_A = regA "rein" ;
  clever_A = mk3A "klug" "klüger" "klügste" ;
  close_V2 = dirV2 Irreg.schließen_V ;
  coat_N = mkN "Jacke" | mkN "Mantel" "Mantel" masculine;
  cold_A = regA "kalt" ;
  come_V = seinV (mk6V "kommen" "kommt" "komm" "kam" "käme" "gekommen") ;
  computer_N = reg2N "Rechner" "Rechner" masculine ;
  country_N = reg2N "Land" "Länder" neuter ;
  cousin_N = reg2N "Vetter" "Vetter" masculine ; --- Kusine
  cow_N = reg2N "Kuh" "Kühe" feminine ;
  die_V = seinV Irreg.sterben_V | seinV (prefixV "um" Irreg.kommen_V);
  distance_N3 = mkN3 (mkN "Entfernung") von_Prep zu_Prep ;
  dirty_A = regA "schmutzig" ;
  do_V2 = dirV2 Irreg.tun_V ;
  doctor_N = reg2N "Arzt" "Ärzte" masculine ;
  dog_N = mkN "Hund" ;
  door_N = reg2N "Tür" "Türen" feminine ;
  drink_V2 = dirV2 Irreg.trinken_V ;
  easy_A2V = mkA2V (regA "leicht") (mkPrep "für" accusative) ;
  eat_V2 = dirV2 Irreg.essen_V ;
  empty_A = mk3A "leer" "leerer" "leereste" ; ---- infl still wrong in Posit
  enemy_N = mkN "Feind" ; 
  factory_N = mkN "Fabrik" "Fabriken" feminine ;
  father_N2 = mkN2 (reg2N "Vater" "Väter" masculine) von_Prep ;
  fear_VS = mkVS (regV "fürchten") ;
  find_V2 = dirV2 Irreg.finden_V ;
  fish_N = mkN "Fisch" ;
  floor_N = reg2N "Fußboden" "Fußböden" masculine ;
  forget_V2 = dirV2 Irreg.vergessen_V ; 
  fridge_N = reg2N "Kühlschrank" "Kühlschränke" masculine ;
  friend_N = mkN "Freund" ;
  fruit_N = reg2N "Frucht" "Früchte" feminine ;
  fun_AV = mkAV (regA "toll") ;
  garden_N = reg2N "Garten" "Gärten" masculine ;
  girl_N = reg2N "Mädchen" "Mädchen" neuter ;
  glove_N = mkN "Handschuh" ;
  gold_N = reg2N "Gold" "Golde" neuter ; ---- infl
  good_A = mk3A "gut" "besser" "beste" ;
  go_V = seinV Irreg.gehen_V ;
  green_A = regA "grün" ;
  harbour_N = reg2N "Hafen" "Häfen" masculine ;
  hate_V2 = dirV2 (regV "hassen") ;
  hat_N = reg2N "Hut" "Hüte" masculine ;
  hear_V2 = dirV2 (regV "hören") ;
  hill_N = mkN "Hügel" ;
  hope_VS = mkVS (regV "hoffen") ;
  horse_N = reg2N "Pferd" "Pferde" neuter ;
  hot_A = regA "heiß" ;
  house_N = reg2N "Haus" "Häuser" neuter ;
  important_A = regA "wichtig" ;
  industry_N = mkN "Industrie" ;
  iron_N = reg2N "Eisen" "Eisen" neuter ;
  jump_V = seinV Irreg.springen_V ;
  king_N = mkN "König" ;
  know_V2 = dirV2 Irreg.kennen_V ; 
  know_VQ = mkVQ Irreg.wissen_V ;
  know_VS = mkVS Irreg.wissen_V ;
  lake_N = reg2N "See" "Seen" masculine ; --- infl
  lamp_N = mkN "Lampe";
  learn_V2 = dirV2 (regV "lernen") ;
  leather_N = reg2N "Leder" "Leder" neuter ;
  leave_V2 = dirV2 (fixprefixV "ver" Irreg.lassen_V) ;
  like_V2 = dirV2 Irreg.mögen_V ;
  listen_V2 = prepV2 (prefixV "zu" (regV "hören")) datPrep ; ---- dat
  live_V = regV "leben" ;
  long_A = mk3A "lang" "länger" "längste" ;
  lose_V2 = dirV2 Irreg.verlieren_V ;
  love_N = mkN "Liebe" ;
  love_V2 = dirV2 (regV "lieben") ;
  man_N = reg2N "Mann" "Männer" masculine ;
  married_A2 = mkA2 (regA "verheiratet") (mkPrep "mit" dative) ;
  meat_N = reg2N "Fleisch" "Fleische" neuter ; ---- infl
  milk_N = reg2N "Milch" "Milche" feminine ; ---- infl
  moon_N = mkN "Mond" ;
  mother_N2 = mkN2 (reg2N "Mutter" "Mütter" feminine) von_Prep ;
  mountain_N = mkN "Berg" ;
  music_N = reg2N "Musik" "Musiken" feminine ;
  narrow_A = regA "schmal" ;
  new_A = regA "neu" ;
  newspaper_N = mkN "Zeitung" ;
  now_Adv = mkAdv "jetzt" ;
  number_N = reg2N "Zahl" "Zahlen" feminine ;
  oil_N = reg2N "Öl" "Öle" neuter ;
  old_A = mk3A "alt" "älter" "älteste" ;
  open_V2 = dirV2 (regV "öffnen") ;
  paint_V2A = mkV2A (regV "malen") accPrep ;
  paper_N = reg2N "Papier" "Papiere" neuter ;
  paris_PN = mkPN "Paris" neuter ;
  peace_N = mk6N "Friede" "Frieden" "Frieden" "Friedens" "Frieden" "Frieden" masculine ;
  pen_N = mkN "Bleistift" ; ----
  planet_N = reg2N "Planet" "Planeten" masculine ;
  plastic_N = reg2N "Plastik" "Plastiken" feminine ; ----
  play_V2 = dirV2 (regV "spielen") ;
  policeman_N = reg2N "Polizist" "Polizisten" masculine ;
  priest_N = mkN "Priester" ;
  probable_AS = mkAS (regA "wahrscheinlich") ;
  put_V2 = dirV2 (regV "setzen") ;
  queen_N = reg2N "Königin" "Königinnen" feminine ;
  radio_N = reg2N "Radio" "Radios" neuter ; ----
  rain_V0 = mkV0 (regV "regnen") ;
  read_V2 = dirV2 Irreg.lesen_V ;
  red_A = regA "rot" ;
  religion_N = mkN "Religion" ;
  restaurant_N = reg2N "Restaurant" "Restaurants" neuter ;
  river_N = reg2N "Fluß" "Flüsse" masculine ;
  rock_N = mkN "Stein" ;
  roof_N = reg2N "Dach" "Dächer" neuter ;
  rubber_N = reg2N "Gummi" "Gummis" neuter ;
  run_V = seinV Irreg.laufen_V ;
  say_VS = mkVS (regV "sagen") ;
  school_N = mkN "Schule";
  science_N = reg2N "Wissenschaft" "Wissenschaften" feminine ;
  sea_N = reg2N "Meer" "Meere" neuter ;
  seek_V2 = dirV2 (regV "suchen") ;
  see_V2 = dirV2 Irreg.sehen_V ;
  sell_V3 = accdatV3 (no_geV (regV "verkaufen")) ;
  send_V3 = accdatV3 (regV "schicken") ;
  sheep_N = reg2N "Schaf" "Schafe" neuter ;
  ship_N = reg2N "Schiff" "Schiffe" neuter ;
  shirt_N = reg2N "Hemd" "Hemden" neuter ; ---- infl
  shoe_N = mkN "Schuh" ;
  shop_N = reg2N "Laden" "Läden" masculine ;
  short_A =  mk3A "kurz" "kürzer" "kürzeste" ;
  silver_N = reg2N "Silber" "Silber" neuter ; ---- infl
  sister_N = reg2N "Schwester" "Schwestern" feminine ;
  sleep_V = Irreg.schlafen_V ;
  small_A = regA "klein" ;
  snake_N = mkN "Schlange" ;
  sock_N = reg2N "Strumpf" "Strümpfe" masculine ;
  song_N = reg2N "Lied" "Lieder" neuter ;
  speak_V2 = dirV2 Irreg.sprechen_V ;
  star_N = mkN "Sterne" ;
  steel_N = mkN "Stahl" ;
  stone_N = mkN "Stein" ;
  stop_V = seinV Irreg.halten_V ;
  stove_N = mkN "Herd" ;
  student_N = reg2N "Student" "Studenten" masculine ;
  stupid_A = mk3A "dumm" "dümmer" "dümmste" ; ----
  sun_N = mkN "Sonne" ;
  switch8off_V2 = dirV2 (prefixV "aus" (regV "schalten")) ;
  switch8on_V2 = dirV2 (prefixV "ein" (regV "schalten")) ;
  table_N = mkN "Tisch"  ;
  talk_V3 = mkV3 (regV "reden") datPrep von_Prep ;
  teacher_N = reg2N "Lehrer" "Lehrer" masculine ;
  teach_V2 = dirV2 (no_geV (regV "unterrichten")) ;
  television_N = reg2N "Fernsehen" "Fernsehen" neuter;
  thick_A = regA "dick" ;
  thin_A = regA "dünn" ;
  train_N = reg2N "Zug" "Züge" masculine  ;
  travel_V = seinV (regV "reisen") ; 
  tree_N = reg2N "Baum" "Bäume" masculine ;
  ----  trousers_N = mkN "trousers" ; ---- pl t !
  ugly_A = regA "häßlich" ;
  understand_V2 = 
    dirV2 (irregV "verstehen" "versteht" "verstand" "verstände" "verstanden") ;
  university_N = reg2N "Universität" "Universitäten" feminine  ;
  village_N = reg2N "Dorf" "Dörfer" neuter ;
  wait_V2 = prepV2 (regV "warten") (mkPrep "auf" accusative) ;
  walk_V = seinV Irreg.gehen_V ;
  warm_A = mk3A "warm" "wärmer" "wärmste" ;
  war_N = mkN "Krieg" ;
--  watch_V2 = prepV2 (regV "schauen") (mkPrep "an" accusative) ; -- an die Wand schauen
  watch_V2 = dirV2 (prefixV "an" (regV "schauen")) ;              -- die Wand anschauen
  water_N = reg2N "Wasser" "Wasser" neuter ;
  white_A = regA "weiß" ;
  window_N = reg2N "Fenster" "Fenster" neuter ;
  wine_N = mkN "Wein" ;
  win_V2 = dirV2 Irreg.gewinnen_V ;
  woman_N = reg2N "Frau" "Frauen" feminine ;
  wonder_VQ = mkVQ (reflV (regV "wundern") accusative) ;
  wood_N = reg2N "Holz" "Hölzer" neuter ;
  write_V2 = dirV2 Irreg.schreiben_V ;
  yellow_A = regA "gelb" ;
  young_A = mk3A "jung" "jünger" "jüngste" ;
  left_Ord = Mo.mkOrd (regA "link") ;
  right_Ord = Mo.mkOrd (regA "recht") ;
  far_Adv = mkAdv "weit" ;
  correct_A = regA "richtig" ;
  dry_A = regA "trocken" ;
  dull_A = regA "stumpf" ;
  full_A = regA "voll" ;
  heavy_A = mkA "schwer" "schwere" "schwerer" "schwerste" ;
  near_A = mk3A "nahe" "näher" "nächste" ;
  rotten_A = regA "verdorben" ;
  round_A = regA "rund" ;
  sharp_A = mk3A "scharf" "schärfer" "schärfste" ;
  smooth_A = regA "glatt" ;
  straight_A = regA "gerade" ;
  wet_A = regA "naß" ;
  wide_A = regA "breit" ;
  animal_N = reg2N "Tier" "Tiere" neuter ;
  ashes_N = mkN "Asche" ;
  back_N = reg2N "Rücken" "Rücken" masculine ;
  bark_N = mkN "Rinde" ;
  belly_N = reg2N "Bauch" "Bäuche" masculine ;
  blood_N = mkN "Blut" "Blute" neuter ;
  bone_N = reg2N "Knochen" "Knochen" masculine ;
  breast_N = reg2N "Brust" "Brüste" feminine ;
  cloud_N = mkN "Wolke" ;
  day_N = mkN "Tag" ;
  dust_N = reg2N "Staub" "Stäube" masculine ;
  ear_N = mkN "Ohr" "Ohren" neuter ;
  earth_N = mkN "Erde" ;
  egg_N = mkN "Ei" "Eier" neuter ;
  eye_N = mkN "Auge" "Augen" neuter;
  fat_N = mkN "Fett" "Fetter" neuter ;
  feather_N = mkN "Feder" "Federn" feminine ;
  fingernail_N = reg2N "Fingernagel" "Fingernägel" masculine ;
  fire_N = mkN "Feuer" "Feuer" neuter ;
  flower_N = mkN "Blume" ;
  fog_N = mkN "Nebel" "Nebel" masculine ;
  foot_N = reg2N "Fuß" "Füße" masculine ;
  forest_N = reg2N "Wald" "Wälder" masculine ;
  grass_N = mkN "Gras" "Gräser" neuter ;
  guts_N = mkN "Eingeweide" ;
  hair_N = mkN "Haar" "Haare" neuter ;
  hand_N = mkN "Hand" "Hände" feminine ;
  head_N = mkN "Kopf" "Köpfe" masculine ;
  heart_N = mkN "Herz" "Herzen" neuter ;
  horn_N = mkN "Horn" "Hörner" neuter ;
  husband_N = mkN "Ehemann" "Ehemänner" masculine ;
  ice_N = mkN "Eis" "Eise" neuter ;
  knee_N = mkN "Knie" "Kniee" neuter ;
  leaf_N = reg2N "Blatt" "Blätter" neuter ;
  leg_N = mkN "Bein" "Beine" neuter ;
  liver_N = mkN "Leber" "Lebern" feminine ;
  louse_N = reg2N "Laus" "Läuse" feminine ;
  mouth_N = mkN "Mund" "Münder" masculine ;
  name_N = mkN "Name" "Namen" "Namen" "Namens" "Namen" "Namen" masculine ;
  neck_N = mkN "Nacken" "Nacken" masculine ;
  night_N = reg2N "Nacht" "Nächte" feminine ;
  nose_N = mkN "Nase" ;
  person_N = mkN "Person" "Personen" feminine ;
  rain_N = mkN "Regen" ;
  road_N = mkN "Straße" ;
  root_N = mkN "Wurzel" "Wurzeln" feminine ;
  rope_N = mkN "Seil" "Seile" neuter ;
  salt_N = mkN "Salz" "Salze" neuter ;
  sand_N = mkN "Sand" ;
  seed_N = mkN "Same" ;
  skin_N = mkN "Haut" "Häute" feminine ;
  sky_N = mkN "Himmel" ;  ---- pl
  smoke_N = mkN "Rauch" ;
  snow_N = mkN "Schnee" "Schneen" masculine ; ---- pl
  stick_N = mkN "Stock" "Stöcke" masculine ;
  tail_N = mkN "Schwanz" "Schwänze" masculine ;
  tongue_N = mkN "Zunge" ;
  tooth_N = mkN "Zahn" "Zähne" masculine ;
  wife_N = mkN "Ehefrau" "Ehefrauen" feminine ;
  wind_N = mkN "Wind" ;
  wing_N = reg2N "Flügel" "Flügel" masculine ;
  worm_N = mkN "Wurm" "Würmer" masculine ;
  year_N = mkN "Jahr" "Jahre" neuter ;
  blow_V = Irreg.blasen_V ; 
  breathe_V = regV "atmen" ;
  burn_V = Irreg.brennen_V ; 
  dig_V = Irreg.graben_V ;
  fall_V = seinV (Irreg.fallen_V) ; 
  float_V = seinV (Irreg.treiben_V) ; 
  flow_V = seinV (Irreg.fließen_V) ; 
  fly_V = seinV (Irreg.fliegen_V) ; 
  freeze_V = Irreg.frieren_V ; 
  give_V3 = accdatV3 Irreg.geben_V ;
  laugh_V = regV "lachen" ;
  lie_V = Irreg.lügen_V ; 
  play_V = regV "spielen" ;
  sew_V = regV "nähen" ;
  sing_V = Irreg.singen_V ; 
  sit_V = Irreg.sitzen_V ;
  smell_V = Irreg.riechen_V ; 
  spit_V = regV "spucken" ;
  stand_V = Irreg.stehen_V ; 
  swell_V = prefixV "an" (regV "schwellen") ;
  swim_V = seinV (Irreg.schwimmen_V) ; 
  think_V = Irreg.denken_V | prefixV "nach" Irreg.denken_V; 
  turn_V = regV "drehen" ;
  vomit_V = regV "kotzen" ;
  bite_V2 = dirV2 Irreg.beißen_V ;
  count_V2 = dirV2 (regV "zählen") ;
  cut_V2 = dirV2 Irreg.schneiden_V ;
  fear_V2 = dirV2 (regV "fürchten") ;
  fight_V2 = dirV2 (no_geV (regV "bekämpfen")) ; 
  hit_V2 = dirV2 Irreg.schlagen_V ;
  hold_V2 = dirV2 Irreg.halten_V ;
  hunt_V2 = dirV2 (regV "jagen") ;
  kill_V2 = dirV2 (regV "töten") ;
  pull_V2 = dirV2 Irreg.ziehen_V ;
  push_V2 = dirV2 Irreg.schieben_V ; -- schob, schöbe 
  rub_V2 = dirV2 Irreg.reiben_V ;
  scratch_V2 = dirV2 (regV "kratzen") ;
  split_V2 = dirV2 (prefixV "auf" (regV "teilen")) ;
  squeeze_V2 = dirV2 (regV "pressen") ;
  stab_V2 = dirV2 Irreg.stechen_V ;
  suck_V2 = dirV2 (regV "saugen") ;
  throw_V2 = dirV2 Irreg.werfen_V ;
  tie_V2 = dirV2 Irreg.binden_V ;
  wash_V2 = dirV2 Irreg.waschen_V ;
  wipe_V2 = dirV2 (regV "wischen") ;

  grammar_N = reg2N "Grammatik" "Grammatiken" feminine ;
  language_N = mkN "Sprache" ;
  rule_N = reg2N "Regel" "Regeln" feminine ;

    john_PN = mkPN "Johann" masculine ;
    question_N = mkN "Frage" ;
    ready_A = regA "fertig" ;
    reason_N = reg2N "Grund" "Gründe" masculine ;
    today_Adv = mkAdv "heute" ;
    uncertain_A = regA "unsicher" ;


} ;
