/*  **************************************************************************
 * 
 * --- File: gexpr.c
 * 
 * --- Purpose: expression parser and evaluator.
 * 
 * --- Copyright (C) Guido Gonzato, guido@ibogeo.df.unibo.it
 * 
 * --- Last updated: 7 January 2000
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * ************************************************************************ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
 
#include "gexpr.h"

jmp_buf jump;
BOOL token_read = FALSE;
BOOL program_over = FALSE;
WHERE input_source;
char *expression_source;

void program_help (void);

/* ----- */

int main(int argc, char *argv[])
{
  
  double f;
  TOKEN tok;
  BOOL show_prompt = TRUE;
  int c;
  static struct option long_options[] =
    {
      {"help", 0, 0, 'h'},
      {"base", 1, 0, 'b'},
      {"no_prompt", 0, 0, 'n'},
      {0, 0, 0, 0}
    };
  
  output_base = 10;	/* default */
  
  /* check switches */
  
  while ((c = getopt_long (argc, argv, "hb:n", long_options, 
			   NULL)) != -1)
    switch (c)
      {
	
	case 0:
	case 'h':
	program_help ();
	break;
	  
	case 'b':
	output_base = atoi(optarg);
	if (output_base < 2 || output_base > 16) /* error */
	  {
	    output_base = 10;
	    fprintf (stderr, "output base must be >=2 and <= 16\n");
	  }
	break;

	case 'n':
	show_prompt = FALSE;
	break;
	
	default:
	program_help ();	
	
      } 			/* switch */

  argc = argc - optind + 1;
  
  if (argc == 2) {
    expression_source = argv[1];
    input_source = ARGV_1;
  }
  else
    input_source = STDIN;
  
  do {
    
    setjmp(jump); /* jump here in case of error */
    
    if ((input_source == STDIN) && (show_prompt == TRUE))
      printf("%s> ", PROGNAME);
    tok = read_token();
    if (tok.type != T_END) {
      token_read = TRUE;
      if (tok.type != T_EOL) { /* the user just pressed return */
	if (tok.type == T_COMMAND) {
	  token_read = FALSE;
	  handle_command(tok.string);
	}
	else {
	  f = expression();
	  output(f);
	}
      }
      token_read = TRUE;
      tok = read_token();
    } /* if (tok.type != T_END) */
    
  } while (tok.type != T_END && program_over == FALSE);
  
  return (0);
  
} /* main() */

/* ----- */

void program_help (void)
{

  fprintf (stderr, "%s %s %s\n", PROGNAME, VERSION, DATE);
  fprintf (stderr, "usage: %s [-hbn] ['expression']\n", PROGNAME);
  fprintf (stderr, "-h --help\t\tgive this help\n");
  fprintf (stderr, "-b --base n\t\toutput in base n (2 <=n <= 16)\n");
  fprintf (stderr, "-n --no_prompt\t\tdon't show the prompt\n");
  fprintf (stderr, "'expression' may be omitted for interactive use.\n");
  exit (0);

} /* --- program_help () --- */

/* --- End of file gexpr.c --- */
