
module tests_module
    use geodesic_module, wp => geodesic_wp

  implicit none

  private

  integer :: j
  real(wp),public :: tstdat(20, 12)

  data (tstdat(1,j), j = 1,12) / &
      35.60777_wp,-139.44815_wp,111.098748429560326_wp, &
      -11.17491_wp,-69.95921_wp,129.289270889708762_wp, &
      8935244.5604818305_wp,80.50729714281974_wp,6273170.2055303837_wp, &
      0.16606318447386067_wp,0.16479116945612937_wp, &
      12841384694976.432_wp /
  data (tstdat(2,j), j = 1,12) / &
      55.52454_wp,106.05087_wp,22.020059880982801_wp, &
      77.03196_wp,197.18234_wp,109.112041110671519_wp, &
      4105086.1713924406_wp,36.892740690445894_wp, &
      3828869.3344387607_wp, &
      0.80076349608092607_wp,0.80101006984201008_wp, &
      61674961290615.615_wp /
  data (tstdat(3,j), j = 1,12) / &
      -21.97856_wp,142.59065_wp,-32.44456876433189_wp, &
      41.84138_wp,98.56635_wp,-41.84359951440466_wp, &
      8394328.894657671_wp,75.62930491011522_wp,6161154.5773110616_wp, &
      0.24816339233950381_wp,0.24930251203627892_wp, &
      -6637997720646.717_wp /
  data (tstdat(4,j), j = 1,12) / &
      -66.99028_wp,112.2363_wp,173.73491240878403_wp, &
      -12.70631_wp,285.90344_wp,2.512956620913668_wp, &
      11150344.2312080241_wp,100.278634181155759_wp, &
      6289939.5670446687_wp, &
      -0.17199490274700385_wp,-0.17722569526345708_wp, &
      -121287239862139.744_wp /
  data (tstdat(5,j), j = 1,12) / &
      -17.42761_wp,173.34268_wp,-159.033557661192928_wp, &
      -15.84784_wp,5.93557_wp,-20.787484651536988_wp, &
      16076603.1631180673_wp,144.640108810286253_wp, &
      3732902.1583877189_wp, &
      -0.81273638700070476_wp,-0.81299800519154474_wp, &
      97825992354058.708_wp /
  data (tstdat(6,j), j = 1,12) / &
      32.84994_wp,48.28919_wp,150.492927788121982_wp, &
      -56.28556_wp,202.29132_wp,48.113449399816759_wp, &
      16727068.9438164461_wp,150.565799985466607_wp, &
      3147838.1910180939_wp, &
      -0.87334918086923126_wp,-0.86505036767110637_wp, &
      -72445258525585.010_wp /
  data (tstdat(7,j), j = 1,12) / &
      6.96833_wp,52.74123_wp,92.581585386317712_wp, &
      -7.39675_wp,206.17291_wp,90.721692165923907_wp, &
      17102477.2496958388_wp,154.147366239113561_wp, &
      2772035.6169917581_wp, &
      -0.89991282520302447_wp,-0.89986892177110739_wp, &
      -1311796973197.995_wp /
  data (tstdat(8,j), j = 1,12) / &
      -50.56724_wp,-16.30485_wp,-105.439679907590164_wp, &
      -33.56571_wp,-94.97412_wp,-47.348547835650331_wp, &
      6455670.5118668696_wp,58.083719495371259_wp, &
      5409150.7979815838_wp, &
      0.53053508035997263_wp,0.52988722644436602_wp, &
      41071447902810.047_wp /
  data (tstdat(9,j), j = 1,12) / &
      -58.93002_wp,-8.90775_wp,140.965397902500679_wp, &
      -8.91104_wp,133.13503_wp,19.255429433416599_wp, &
      11756066.0219864627_wp,105.755691241406877_wp, &
      6151101.2270708536_wp, &
      -0.26548622269867183_wp,-0.27068483874510741_wp, &
      -86143460552774.735_wp /
  data (tstdat(10,j), j = 1,12) / &
      -68.82867_wp,-74.28391_wp,93.774347763114881_wp, &
      -50.63005_wp,-8.36685_wp,34.65564085411343_wp, &
      3956936.926063544_wp,35.572254987389284_wp,3708890.9544062657_wp, &
      0.81443963736383502_wp,0.81420859815358342_wp, &
      -41845309450093.787_wp /
  data (tstdat(11,j), j = 1,12) / &
      -10.62672_wp,-32.0898_wp,-86.426713286747751_wp, &
      5.883_wp,-134.31681_wp,-80.473780971034875_wp, &
      11470869.3864563009_wp,103.387395634504061_wp, &
      6184411.6622659713_wp, &
      -0.23138683500430237_wp,-0.23155097622286792_wp, &
      4198803992123.548_wp /
  data (tstdat(12,j), j = 1,12) / &
      -21.76221_wp,166.90563_wp,29.319421206936428_wp, &
      48.72884_wp,213.97627_wp,43.508671946410168_wp, &
      9098627.3986554915_wp,81.963476716121964_wp, &
      6299240.9166992283_wp, &
      0.13965943368590333_wp,0.14152969707656796_wp, &
      10024709850277.476_wp /
  data (tstdat(13,j), j = 1,12) / &
      -19.79938_wp,-174.47484_wp,71.167275780171533_wp, &
      -11.99349_wp,-154.35109_wp,65.589099775199228_wp, &
      2319004.8601169389_wp,20.896611684802389_wp, &
      2267960.8703918325_wp, &
      0.93427001867125849_wp,0.93424887135032789_wp, &
      -3935477535005.785_wp /
  data (tstdat(14,j), j = 1,12) / &
      -11.95887_wp,-116.94513_wp,92.712619830452549_wp, &
      4.57352_wp,7.16501_wp,78.64960934409585_wp, &
      13834722.5801401374_wp,124.688684161089762_wp, &
      5228093.177931598_wp, &
      -0.56879356755666463_wp,-0.56918731952397221_wp, &
      -9919582785894.853_wp /
  data (tstdat(15,j), j = 1,12) / &
      -87.85331_wp,85.66836_wp,-65.120313040242748_wp, &
      66.48646_wp,16.09921_wp,-4.888658719272296_wp, &
      17286615.3147144645_wp,155.58592449699137_wp, &
      2635887.4729110181_wp, &
      -0.90697975771398578_wp,-0.91095608883042767_wp, &
      42667211366919.534_wp /
  data (tstdat(16,j), j = 1,12) / &
      1.74708_wp,128.32011_wp,-101.584843631173858_wp, &
      -11.16617_wp,11.87109_wp,-86.325793296437476_wp, &
      12942901.1241347408_wp,116.650512484301857_wp, &
      5682744.8413270572_wp, &
      -0.44857868222697644_wp,-0.44824490340007729_wp, &
      10763055294345.653_wp /
  data (tstdat(17,j), j = 1,12) / &
      -25.72959_wp,-144.90758_wp,-153.647468693117198_wp, &
      -57.70581_wp,-269.17879_wp,-48.343983158876487_wp, &
      9413446.7452453107_wp,84.664533838404295_wp, &
      6356176.6898881281_wp, &
      0.09492245755254703_wp,0.09737058264766572_wp, &
      74515122850712.444_wp /
  data (tstdat(18,j), j = 1,12) / &
      -41.22777_wp,122.32875_wp,14.285113402275739_wp, &
      -7.57291_wp,130.37946_wp,10.805303085187369_wp, &
      3812686.035106021_wp,34.34330804743883_wp,3588703.8812128856_wp, &
      0.82605222593217889_wp,0.82572158200920196_wp, &
      -2456961531057.857_wp /
  data (tstdat(19,j), j = 1,12) / &
      11.01307_wp,138.25278_wp,79.43682622782374_wp, &
      6.62726_wp,247.05981_wp,103.708090215522657_wp, &
      11911190.819018408_wp,107.341669954114577_wp, &
      6070904.722786735_wp, &
      -0.29767608923657404_wp,-0.29785143390252321_wp, &
      17121631423099.696_wp /
  data (tstdat(20,j), j = 1,12) / &
      -29.47124_wp,95.14681_wp,-163.779130441688382_wp, &
      -27.46601_wp,-69.15955_wp,-15.909335945554969_wp, &
      13487015.8381145492_wp,121.294026715742277_wp, &
      5481428.9945736388_wp, &
      -0.51527225545373252_wp,-0.51556587964721788_wp, &
      104679964020340.318_wp /

    public :: assert, chknan

  contains

    integer function assert(x, y, d)
    real(wp),intent(in) :: x, y, d

    if (abs(x - y) <= d) then
        assert = 0
    else
        assert = 1
        write(*,'(1x,a,g14.7,a, g14.7,a,g10.3)') &
                'assert fails: ', x, ' != ', y, ' +/- ', d
    end if

    end function assert

    integer function chknan(x)
    real(wp),intent(in) :: x

    if (x /= x) then
        chknan = 0
    else
        chknan = 1
    end if

    end function chknan

  end module tests_module