/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.shell;

import com.gemstone.gemfire.management.internal.cli.CommandRequest;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import com.gemstone.gemfire.management.internal.web.domain.Link;
import com.gemstone.gemfire.management.internal.web.http.ClientHttpRequest;
import com.gemstone.gemfire.management.internal.web.http.HttpMethod;
import com.gemstone.gemfire.management.internal.web.shell.AbstractHttpOperationInvoker;
import java.net.URI;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.util.UriComponentsBuilder;

public class SimpleHttpOperationInvoker
extends AbstractHttpOperationInvoker {
    protected static final String CMD_QUERY_PARAMETER = "cmd";
    protected static final String LINK_RELATION = "simple";
    protected static final String REST_API_MANAGEMENT_COMMANDS_URI = "/management/commands";

    SimpleHttpOperationInvoker() {
        super("http://localhost:8080/gemfire/v1");
    }

    public SimpleHttpOperationInvoker(Gfsh gfsh) {
        this(gfsh, "http://localhost:8080/gemfire/v1");
    }

    public SimpleHttpOperationInvoker(Gfsh gfsh, String baseUrl) {
        super(gfsh, baseUrl);
    }

    protected ClientHttpRequest createHttpRequest(CommandRequest command) {
        return this.createHttpRequest(this.createLink(command));
    }

    protected Link createLink(CommandRequest command) {
        return this.createLink(LINK_RELATION, this.getHttpRequestUrl(command), HttpMethod.POST);
    }

    protected URI getHttpRequestUrl(CommandRequest command) {
        return UriComponentsBuilder.fromHttpUrl((String)this.getBaseUrl()).path(REST_API_MANAGEMENT_COMMANDS_URI).queryParam(CMD_QUERY_PARAMETER, new Object[]{command.getInput()}).build().encode().toUri();
    }

    public String processCommand(CommandRequest command) {
        SimpleHttpOperationInvoker.assertState(this.isConnected(), "Gfsh must be connected to the GemFire Manager in order to process commands remotely!", new Object[0]);
        try {
            ResponseEntity<String> response = this.send(this.createHttpRequest(command), String.class);
            return (String)response.getBody();
        }
        catch (ResourceAccessException e) {
            return this.handleResourceAccessException(e);
        }
    }
}

