/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.controllers;

import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import com.gemstone.gemfire.management.internal.web.controllers.AbstractCommandsController;
import java.util.concurrent.Callable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="miscellaneousController")
@RequestMapping(value={"/v1"})
public class MiscellaneousCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/logs"})
    public Callable<ResponseEntity<String>> exportLogs(@RequestParam(value="dir") String directory, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="log-level", required=false) String logLevel, @RequestParam(value="only-log-level", defaultValue="false") Boolean onlyLogLevel, @RequestParam(value="merge-log", defaultValue="false") Boolean mergeLog, @RequestParam(value="start-time", required=false) String startTime, @RequestParam(value="end-time", required=false) String endTime) {
        final CommandStringBuilder command = new CommandStringBuilder("export logs");
        command.addOption("dir", MiscellaneousCommandsController.decode(directory));
        if (MiscellaneousCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        if (MiscellaneousCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (MiscellaneousCommandsController.hasValue(logLevel)) {
            command.addOption("log-level", logLevel);
        }
        command.addOption("only-log-level", String.valueOf(Boolean.TRUE.equals(onlyLogLevel)));
        command.addOption("merge-log", String.valueOf(Boolean.TRUE.equals(mergeLog)));
        if (MiscellaneousCommandsController.hasValue(startTime)) {
            command.addOption("start-time", startTime);
        }
        if (MiscellaneousCommandsController.hasValue(endTime)) {
            command.addOption("end-time", endTime);
        }
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                return new ResponseEntity((Object)MiscellaneousCommandsController.this.processCommand(command.toString()), HttpStatus.OK);
            }
        };
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/stacktraces"})
    @ResponseBody
    public String exportStackTraces(@RequestParam(value="file") String file, @RequestParam(value="group", required=false) String groupName, @RequestParam(value="member", required=false) String memberNameId) {
        CommandStringBuilder command = new CommandStringBuilder("export stack-traces");
        command.addOption("file", MiscellaneousCommandsController.decode(file));
        if (MiscellaneousCommandsController.hasValue(groupName)) {
            command.addOption("group", groupName);
        }
        if (MiscellaneousCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gc"})
    @ResponseBody
    public String gc(@RequestParam(value="group", required=false) String[] groups) {
        CommandStringBuilder command = new CommandStringBuilder("gc");
        if (MiscellaneousCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/members/{member}/gc"})
    @ResponseBody
    public String gc(@PathVariable(value="member") String memberNameId) {
        CommandStringBuilder command = new CommandStringBuilder("gc");
        command.addOption("member", MiscellaneousCommandsController.decode(memberNameId));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/netstat"})
    @ResponseBody
    public String netstat(@RequestParam(value="member", required=false) String[] members, @RequestParam(value="group", required=false) String group, @RequestParam(value="file", required=false) String file, @RequestParam(value="with-lsof", defaultValue="false") Boolean withLsof) {
        CommandStringBuilder command = new CommandStringBuilder("netstat");
        this.addCommandOption(null, command, "member", members);
        this.addCommandOption(null, command, "group", group);
        this.addCommandOption(null, command, "file", file);
        this.addCommandOption(null, command, "with-lsof", withLsof);
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/deadlocks"})
    @ResponseBody
    public String showDeadLock(@RequestParam(value="file") String dependenciesFile) {
        CommandStringBuilder command = new CommandStringBuilder("show dead-locks");
        command.addOption("file", MiscellaneousCommandsController.decode(dependenciesFile));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/members/{member}/log"})
    @ResponseBody
    public String showLog(@PathVariable(value="member") String memberNameId, @RequestParam(value="lines", defaultValue="0") Integer lines) {
        CommandStringBuilder command = new CommandStringBuilder("show log");
        command.addOption("member", MiscellaneousCommandsController.decode(memberNameId));
        command.addOption("lines", String.valueOf(lines));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/metrics"})
    @ResponseBody
    public String showMetrics(@RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="region", required=false) String regionNamePath, @RequestParam(value="file", required=false) String file, @RequestParam(value="port", required=false) String cacheServerPort, @RequestParam(value="categories", required=false) String[] categories) {
        CommandStringBuilder command = new CommandStringBuilder("show metrics");
        if (MiscellaneousCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (MiscellaneousCommandsController.hasValue(regionNamePath)) {
            command.addOption("region", regionNamePath);
        }
        if (MiscellaneousCommandsController.hasValue(file)) {
            command.addOption("file", file);
        }
        if (MiscellaneousCommandsController.hasValue(cacheServerPort)) {
            command.addOption("port", cacheServerPort);
        }
        if (MiscellaneousCommandsController.hasValue(categories)) {
            command.addOption("categories", StringUtils.concat((Object[])categories, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/shutdown"})
    @ResponseBody
    public String shutdown(@RequestParam(value="time-out", defaultValue="-1") Integer timeout) {
        CommandStringBuilder command = new CommandStringBuilder("shutdown");
        command.addOption("time-out", String.valueOf(timeout));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/groups/{groups}/loglevel"})
    @ResponseBody
    public String changeLogLevelForGroups(@PathVariable(value="groups") String groups, @RequestParam(value="loglevel", required=true) String logLevel) {
        return this.internalChangeLogLevel(groups, null, logLevel);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/members/{members}/loglevel"})
    @ResponseBody
    public String changeLogLevelForMembers(@PathVariable(value="members") String members, @RequestParam(value="loglevel", required=true) String logLevel) {
        return this.internalChangeLogLevel(null, members, logLevel);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/members/{members}/groups/{groups}/loglevel"})
    @ResponseBody
    public String changeLogLevelForMembersAndGroups(@PathVariable(value="members") String members, @PathVariable(value="groups") String groups, @RequestParam(value="loglevel") String logLevel) {
        return this.internalChangeLogLevel(groups, members, logLevel);
    }

    private String internalChangeLogLevel(String groups, String members, String logLevel) {
        CommandStringBuilder command = new CommandStringBuilder("change loglevel");
        command.addOption("loglevel", MiscellaneousCommandsController.decode(logLevel));
        if (MiscellaneousCommandsController.hasValue(groups)) {
            command.addOption("groups", MiscellaneousCommandsController.decode(groups));
        }
        if (MiscellaneousCommandsController.hasValue(members)) {
            command.addOption("members", MiscellaneousCommandsController.decode(members));
        }
        return this.processCommand(command.toString());
    }
}

