/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.controllers;

import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import com.gemstone.gemfire.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="indexController")
@RequestMapping(value={"/v1"})
public class IndexCommandsController
extends AbstractCommandsController {
    private static final String DEFAULT_INDEX_TYPE = "range";

    @RequestMapping(method={RequestMethod.GET}, value={"/indexes"})
    @ResponseBody
    public String listIndex(@RequestParam(value="with-stats", defaultValue="false") Boolean withStats) {
        CommandStringBuilder command = new CommandStringBuilder("list indexes");
        command.addOption("with-stats", String.valueOf(Boolean.TRUE.equals(withStats)));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/indexes"})
    @ResponseBody
    public String createIndex(@RequestParam(value="name") String name, @RequestParam(value="expression") String expression, @RequestParam(value="region") String regionNamePath, @RequestParam(value="group", required=false) String groupName, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="type", defaultValue="range") String type) {
        CommandStringBuilder command = new CommandStringBuilder("create index");
        command.addOption("name", name);
        command.addOption("expression", expression);
        command.addOption("region", regionNamePath);
        command.addOption("type", type);
        if (IndexCommandsController.hasValue(groupName)) {
            command.addOption("group", groupName);
        }
        if (IndexCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/indexes"}, params={"op=create-defined"})
    @ResponseBody
    public String createDefinedIndexes(@RequestParam(value="group", required=false) String groupName, @RequestParam(value="member", required=false) String memberNameId) {
        CommandStringBuilder command = new CommandStringBuilder("create defined indexes");
        if (IndexCommandsController.hasValue(groupName)) {
            command.addOption("group", groupName);
        }
        if (IndexCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/indexes"}, params={"op=clear-defined"})
    @ResponseBody
    public String clearDefinedIndexes() {
        return this.processCommand("clear defined indexes");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/indexes"}, params={"op=define"})
    @ResponseBody
    public String defineIndex(@RequestParam(value="name") String name, @RequestParam(value="expression") String expression, @RequestParam(value="region") String regionNamePath, @RequestParam(value="type", defaultValue="range") String type) {
        CommandStringBuilder command = new CommandStringBuilder("define index");
        command.addOption("name", name);
        command.addOption("expression", expression);
        command.addOption("region", regionNamePath);
        command.addOption("type", type);
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/indexes"})
    @ResponseBody
    public String destroyIndexes(@RequestParam(value="group", required=false) String groupName, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="region", required=false) String regionNamePath) {
        return this.internalDestroyIndex(null, groupName, memberNameId, regionNamePath);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/indexes/{name}"})
    @ResponseBody
    public String destroyIndex(@PathVariable(value="name") String indexName, @RequestParam(value="group", required=false) String groupName, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="region", required=false) String regionNamePath) {
        return this.internalDestroyIndex(IndexCommandsController.decode(indexName), groupName, memberNameId, regionNamePath);
    }

    protected String internalDestroyIndex(String indexName, String groupName, String memberNameId, String regionNamePath) {
        CommandStringBuilder command = new CommandStringBuilder("destroy index");
        if (IndexCommandsController.hasValue(indexName)) {
            command.addOption("name", indexName);
        }
        if (IndexCommandsController.hasValue(groupName)) {
            command.addOption("group", groupName);
        }
        if (IndexCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (IndexCommandsController.hasValue(regionNamePath)) {
            command.addOption("region", regionNamePath);
        }
        return this.processCommand(command.toString());
    }
}

