/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.controllers;

import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import com.gemstone.gemfire.management.internal.web.controllers.AbstractCommandsController;
import java.util.concurrent.Callable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="diskStoreController")
@RequestMapping(value={"/v1"})
public class DiskStoreCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/diskstores"})
    @ResponseBody
    public String listDiskStores() {
        return this.processCommand("list disk-stores");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/diskstores"}, params={"op=backup"})
    public Callable<ResponseEntity<String>> backupDiskStore(@RequestParam(value="dir") String dir, @RequestParam(value="baseline-dir", required=false) String baselineDir) {
        final CommandStringBuilder command = new CommandStringBuilder("backup disk-store");
        command.addOption("dir", DiskStoreCommandsController.decode(dir));
        if (DiskStoreCommandsController.hasValue(baselineDir)) {
            command.addOption("baseline-dir", DiskStoreCommandsController.decode(baselineDir));
        }
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                return new ResponseEntity((Object)DiskStoreCommandsController.this.processCommand(command.toString()), HttpStatus.OK);
            }
        };
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/diskstores/{name}"}, params={"op=compact"})
    public Callable<ResponseEntity<String>> compactDiskStore(@PathVariable(value="name") String diskStoreNameId, @RequestParam(value="group", required=false) String[] groups) {
        final CommandStringBuilder command = new CommandStringBuilder("compact disk-store");
        command.addOption("name", DiskStoreCommandsController.decode(diskStoreNameId));
        if (DiskStoreCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                return new ResponseEntity((Object)DiskStoreCommandsController.this.processCommand(command.toString()), HttpStatus.OK);
            }
        };
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/diskstores"})
    @ResponseBody
    public String createDiskStore(@RequestParam(value="name") String diskStoreNameId, @RequestParam(value="dir") String[] directoryAndSizes, @RequestParam(value="allow-force-compaction", defaultValue="false") Boolean allowForceCompaction, @RequestParam(value="auto-compact", defaultValue="true") Boolean autoCompact, @RequestParam(value="compaction-threshold", defaultValue="50") Integer compactionThreshold, @RequestParam(value="max-oplog-size", defaultValue="1024") Integer maxOplogSize, @RequestParam(value="queue-size", defaultValue="0") Integer queueSize, @RequestParam(value="time-interval", defaultValue="1000") Long timeInterval, @RequestParam(value="write-buffer-size", defaultValue="32768") Integer writeBufferSize, @RequestParam(value="disk-usage-warning-percentage", defaultValue="90") Float diskUsageWarningPercentage, @RequestParam(value="disk-usage-critical-percentage", defaultValue="99") Integer diskUsageCriticalPercentage, @RequestParam(value="group", required=false) String[] groups) {
        CommandStringBuilder command = new CommandStringBuilder("create disk-store");
        command.addOption("name", diskStoreNameId);
        command.addOption("dir", StringUtils.concat((Object[])directoryAndSizes, (String)","));
        command.addOption("allow-force-compaction", String.valueOf(Boolean.TRUE.equals(allowForceCompaction)));
        command.addOption("auto-compact", String.valueOf(Boolean.TRUE.equals(autoCompact)));
        command.addOption("compaction-threshold", String.valueOf(compactionThreshold));
        command.addOption("max-oplog-size", String.valueOf(maxOplogSize));
        command.addOption("queue-size", String.valueOf(queueSize));
        command.addOption("time-interval", String.valueOf(timeInterval));
        command.addOption("write-buffer-size", String.valueOf(writeBufferSize));
        command.addOption("disk-usage-warning-percentage", String.valueOf(diskUsageWarningPercentage));
        command.addOption("disk-usage-critical-percentage", String.valueOf(diskUsageCriticalPercentage));
        if (DiskStoreCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/diskstores/{name}"})
    @ResponseBody
    public String describeDiskStore(@PathVariable(value="name") String diskStoreNameId, @RequestParam(value="member") String memberNameId) {
        CommandStringBuilder command = new CommandStringBuilder("describe disk-store");
        command.addOption("member", memberNameId);
        command.addOption("name", DiskStoreCommandsController.decode(diskStoreNameId));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/diskstores/{name}"})
    @ResponseBody
    public String destroyDiskStore(@PathVariable(value="name") String diskStoreNameId, @RequestParam(value="group", required=false) String[] groups) {
        CommandStringBuilder command = new CommandStringBuilder("destroy disk-store");
        command.addOption("name", DiskStoreCommandsController.decode(diskStoreNameId));
        if (DiskStoreCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/diskstores/{id}"}, params={"op=revoke"})
    @ResponseBody
    public String revokeMissingDiskStore(@PathVariable(value="id") String diskStoreId) {
        CommandStringBuilder command = new CommandStringBuilder("revoke missing-disk-store");
        command.addOption("id", DiskStoreCommandsController.decode(diskStoreId));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/diskstores/missing"})
    @ResponseBody
    public String showMissingDiskStores() {
        return this.processCommand("show missing-disk-stores");
    }
}

