/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.controllers;

import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import com.gemstone.gemfire.management.internal.web.controllers.AbstractMultiPartCommandsController;
import com.gemstone.gemfire.management.internal.web.util.ConvertUtils;
import java.io.IOException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller(value="deployController")
@RequestMapping(value={"/v1"})
public class DeployCommandsController
extends AbstractMultiPartCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/deployed"})
    @ResponseBody
    public String listDeployed(@RequestParam(value="group", required=false) String[] groups) {
        CommandStringBuilder command = new CommandStringBuilder("list deployed");
        if (DeployCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/deployed"})
    @ResponseBody
    public String deploy(@RequestParam(value="resources") MultipartFile[] jarFileResources, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="jar", required=false) String jarFileName, @RequestParam(value="dir", required=false) String directory) throws IOException {
        CommandStringBuilder command = new CommandStringBuilder("deploy");
        if (DeployCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        if (DeployCommandsController.hasValue(jarFileName)) {
            command.addOption("jar", jarFileName);
        }
        if (DeployCommandsController.hasValue(directory)) {
            command.addOption("dir", directory);
        }
        return this.processCommand(command.toString(), ConvertUtils.convert(jarFileResources));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/deployed"})
    @ResponseBody
    public String undeploy(@RequestParam(value="group", required=false) String[] groups, @RequestParam(value="jar", required=false) String[] jarFileNames) {
        CommandStringBuilder command = new CommandStringBuilder("undeploy");
        if (DeployCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        if (DeployCommandsController.hasValue(jarFileNames)) {
            command.addOption("jar", StringUtils.concat((Object[])jarFileNames, (String)","));
        }
        return this.processCommand(command.toString());
    }
}

