/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.controllers;

import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import com.gemstone.gemfire.management.internal.web.controllers.support.EnvironmentVariablesHandlerInterceptor;
import com.gemstone.gemfire.management.internal.web.controllers.support.MemberMXBeanAdapter;
import com.gemstone.gemfire.management.internal.web.util.UriUtils;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public abstract class AbstractCommandsController {
    private static final Logger logger = LogService.getLogger();
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static final String REST_API_VERSION = "/v1";
    private MemberMXBean managingMemberMXBeanProxy;

    protected static void assertArgument(boolean validArg, String message, Object ... args) {
        if (!validArg) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    protected static void assertNotNull(Object obj, String message, Object ... args) {
        if (obj == null) {
            throw new NullPointerException(String.format(message, args));
        }
    }

    protected static void assertState(boolean validState, String message, Object ... args) {
        if (!validState) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    protected static String decode(String encodedValue) {
        return UriUtils.decode(encodedValue);
    }

    protected static String decode(String encodedValue, String encoding) {
        return UriUtils.decode(encodedValue, encoding);
    }

    protected static String defaultIfNoValue(String value, String defaultValue) {
        return AbstractCommandsController.hasValue(value) ? value : defaultValue;
    }

    protected static String encode(String value) {
        return UriUtils.encode(value);
    }

    protected static String encode(String value, String encoding) {
        return UriUtils.encode(value, encoding);
    }

    protected static boolean hasValue(Object value) {
        return value instanceof String[] ? AbstractCommandsController.hasValue((String[])value) : (value instanceof String ? AbstractCommandsController.hasValue((String)value) : value != null);
    }

    protected static boolean hasValue(String value) {
        return !StringUtils.isBlank((String)value);
    }

    protected static boolean hasValue(String[] array) {
        if (array != null && array.length > 0) {
            for (String element : array) {
                if (!AbstractCommandsController.hasValue(element)) continue;
                return true;
            }
        }
        return false;
    }

    protected static String printStackTrace(Throwable t) {
        StringWriter stackTraceWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stackTraceWriter));
        return stackTraceWriter.toString();
    }

    protected URI toUri(String path, String scheme) {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path(REST_API_VERSION).path(path).scheme(scheme).build().toUri();
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<String> handleException(Exception cause) {
        String stackTrace = AbstractCommandsController.printStackTrace(cause);
        logger.fatal(stackTrace);
        return new ResponseEntity((Object)stackTrace, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(String[].class, (PropertyEditor)new StringArrayPropertyEditor(",", false));
    }

    protected void logRequest(WebRequest request) {
        if (request != null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            Iterator it = request.getHeaderNames();
            while (it.hasNext()) {
                String headerName = (String)it.next();
                headers.put(headerName, ArrayUtils.toString((Object[])request.getHeaderValues(headerName)));
            }
            HashMap<String, String> parameters = new HashMap<String, String>(request.getParameterMap().size());
            Iterator it2 = request.getParameterNames();
            while (it2.hasNext()) {
                String parameterName = (String)it2.next();
                parameters.put(parameterName, ArrayUtils.toString((Object[])request.getParameterValues(parameterName)));
            }
            logger.info("HTTP-request: description ({}), context ({}), headers ({}), parameters ({})", new Object[]{request.getDescription(false), request.getContextPath(), headers, parameters});
        }
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    protected MemberMXBean getMemberMXBean(String memberNameId) {
        try {
            MBeanServer connection = this.getMBeanServer();
            String objectNamePattern = "GemFire:".concat("type=Member,*");
            ObjectName objectName = ObjectName.getInstance(objectNamePattern);
            QueryExp query = Query.or(Query.eq(Query.attr("Name"), Query.value(memberNameId)), Query.eq(Query.attr("Id"), Query.value(memberNameId)));
            Set<ObjectName> objectNames = connection.queryNames(objectName, query);
            AbstractCommandsController.assertState(this.isMemberMXBeanFound(objectNames), "No MemberMXBean with ObjectName (%1$s) based on Query (%2$s) was found in the Platform MBeanServer for member (%3$s)!", objectName, query, memberNameId);
            return JMX.newMXBeanProxy(connection, objectNames.iterator().next(), MemberMXBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isMemberMXBeanFound(Collection<ObjectName> objectNames) {
        return objectNames != null && !objectNames.isEmpty();
    }

    protected synchronized MemberMXBean getManagingMemberMXBean() {
        if (this.managingMemberMXBeanProxy == null) {
            MBeanServer platformMBeanServer = this.getMBeanServer();
            DistributedSystemMXBean distributedSystemMXBean = JMX.newMXBeanProxy(platformMBeanServer, MBeanJMXAdapter.getDistributedSystemName(), DistributedSystemMXBean.class);
            this.managingMemberMXBeanProxy = this.createMemberMXBeanForManagerUsingProxy(platformMBeanServer, distributedSystemMXBean.getMemberObjectName());
        }
        return this.managingMemberMXBeanProxy;
    }

    private MemberMXBean createMemberMXBeanForManagerUsingAdapter(MBeanServer server, ObjectName managingMemberObjectName) {
        return new MemberMXBeanProxy(server, managingMemberObjectName);
    }

    private MemberMXBean createMemberMXBeanForManagerUsingProxy(MBeanServer server, ObjectName managingMemberObjectName) {
        return JMX.newMXBeanProxy(server, managingMemberObjectName, MemberMXBean.class);
    }

    protected Map<String, String> getEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.putAll(EnvironmentVariablesHandlerInterceptor.getEnvironment());
        environment.put("APP_NAME", "gfsh");
        return environment;
    }

    protected void addCommandOption(WebRequest request, CommandStringBuilder command, String optionName, Object optionValue) {
        AbstractCommandsController.assertNotNull(command, "The command to append options to cannot be null!", new Object[0]);
        AbstractCommandsController.assertNotNull(optionName, "The name of the option to add to the command cannot be null!", new Object[0]);
        if (AbstractCommandsController.hasValue(optionValue)) {
            String optionValueString = optionValue instanceof String[] ? StringUtils.concat((Object[])((String[])optionValue), (String)",") : String.valueOf(optionValue);
            command.addOption(optionName, optionValueString);
        } else if (request != null && request.getParameterMap().containsKey(optionName)) {
            command.addOption(optionName);
        }
    }

    protected String processCommand(String command) {
        return this.processCommand(command, this.getEnvironment(), null);
    }

    protected String processCommand(String command, byte[][] fileData) {
        return this.processCommand(command, this.getEnvironment(), fileData);
    }

    protected String processCommand(String command, Map<String, String> environment) {
        return this.processCommand(command, environment, null);
    }

    protected String processCommand(String command, Map<String, String> environment, byte[][] fileData) {
        logger.info(LogMarker.CONFIG, "Processing Command ({}) with Environment ({}) having File Data ({})...", new Object[]{command, environment, fileData != null});
        return this.getManagingMemberMXBean().processCommand(command, environment, ArrayUtils.toByteArray((byte[][])fileData));
    }

    private static class MemberMXBeanProxy
    extends MemberMXBeanAdapter {
        private final MBeanServer server;
        private final ObjectName objectName;

        public MemberMXBeanProxy(MBeanServer server, ObjectName objectName) {
            AbstractCommandsController.assertNotNull(server, "The connection or reference to the Platform MBeanServer cannot be null!", new Object[0]);
            AbstractCommandsController.assertNotNull(objectName, "The JMX ObjectName for the GemFire Manager MemberMXBean cannot be null!", new Object[0]);
            this.server = server;
            this.objectName = objectName;
        }

        protected MBeanServer getMBeanServer() {
            return this.server;
        }

        protected ObjectName getObjectName() {
            return this.objectName;
        }

        @Override
        public String processCommand(String commandString, Map<String, String> env) {
            try {
                return String.valueOf(this.getMBeanServer().invoke(this.getObjectName(), "processCommand", new Object[]{commandString, env}, new String[]{String.class.getName(), Map.class.getName()}));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("An error occurred while executing processCommand with command String (%1$s) on the MemberMXBean (%2$s) of the GemFire Manager using environment (%3$s)!", commandString, this.getObjectName(), env), e);
            }
        }
    }
}

