/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.tcp.ByteBufferInputStream;
import com.gemstone.gemfire.pdx.PdxFieldAlreadyExistsException;
import com.gemstone.gemfire.pdx.PdxUnreadFields;
import com.gemstone.gemfire.pdx.internal.PdxField;
import com.gemstone.gemfire.pdx.internal.PdxReaderImpl;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.PdxWriterImpl;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import com.gemstone.gemfire.pdx.internal.UnreadPdxType;

public class PdxUnreadData
implements PdxUnreadFields {
    private UnreadPdxType unreadType;
    private byte[][] unreadData;

    public PdxUnreadData() {
    }

    public PdxUnreadData(UnreadPdxType unreadType, PdxReaderImpl reader) {
        this.initialize(unreadType, reader);
    }

    public void initialize(UnreadPdxType unreadType, PdxReaderImpl reader) {
        this.unreadType = unreadType;
        int[] indexes = unreadType.getUnreadFieldIndexes();
        this.unreadData = new byte[indexes.length][];
        int i = 0;
        for (int idx : indexes) {
            ByteBufferInputStream.ByteSource field = reader.getRaw(idx);
            this.unreadData[i] = new byte[field.capacity()];
            field.position(0);
            field.get(this.unreadData[i]);
            ++i;
        }
    }

    public UnreadPdxType getUnreadType() {
        return this.unreadType;
    }

    public PdxType getSerializedType() {
        return this.getUnreadType().getSerializedType();
    }

    public void setSerializedType(PdxType t) {
        this.getUnreadType().setSerializedType(t);
    }

    public void sendTo(PdxWriterImpl writer) {
        if (this.isEmpty()) {
            return;
        }
        int[] indexes = this.unreadType.getUnreadFieldIndexes();
        for (int i = 0; i < this.unreadData.length; ++i) {
            int idx = indexes[i];
            byte[] data = this.unreadData[i];
            PdxField ft = this.unreadType.getPdxFieldByIndex(idx);
            try {
                writer.writeRawField(ft, data);
                continue;
            }
            catch (PdxFieldAlreadyExistsException ex) {
                throw new PdxFieldAlreadyExistsException("Check the toData and fromData for " + this.unreadType.getClassName() + " to see if the field \"" + ft.getFieldName() + "\" is spelled differently.");
            }
        }
    }

    public static void copy(Object o, Object copy) {
        GemFireCacheImpl gfc = GemFireCacheImpl.getInstance();
        if (gfc == null) {
            return;
        }
        TypeRegistry tr = gfc.getPdxRegistry();
        PdxUnreadData ud = tr.getUnreadData(o);
        if (ud != null && !ud.isEmpty()) {
            tr.putUnreadData(copy, ud);
        }
    }

    public boolean isEmpty() {
        return this.unreadData == null;
    }
}

