/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.internal.offheap.StoredObject;
import com.gemstone.gemfire.internal.tcp.ByteBufferInputStream;
import com.gemstone.gemfire.internal.tcp.ImmutableByteBufferInputStream;
import com.gemstone.gemfire.pdx.PdxSerializationException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;

public class PdxInputStream
extends ImmutableByteBufferInputStream {
    public PdxInputStream(ByteBufferInputStream existing, int length) {
        super(existing, length);
    }

    public PdxInputStream(byte[] bytes) {
        super(bytes);
    }

    public PdxInputStream(ByteBuffer bb) {
        super(bb);
    }

    public PdxInputStream(PdxInputStream copy) {
        super(copy);
    }

    public PdxInputStream() {
    }

    public PdxInputStream(StoredObject blob) {
        super(blob);
    }

    public String readString(int positionForField) {
        this.position(positionForField);
        return this.readString();
    }

    public Object readObject(int positionForField) {
        this.position(positionForField);
        return this.readObject();
    }

    public char[] readCharArray(int positionForField) {
        this.position(positionForField);
        return this.readCharArray();
    }

    public boolean[] readBooleanArray(int positionForField) {
        this.position(positionForField);
        return this.readBooleanArray();
    }

    public byte[] readByteArray(int positionForField) {
        this.position(positionForField);
        return this.readByteArray();
    }

    public short[] readShortArray(int positionForField) {
        this.position(positionForField);
        return this.readShortArray();
    }

    public int[] readIntArray(int positionForField) {
        this.position(positionForField);
        return this.readIntArray();
    }

    public long[] readLongArray(int positionForField) {
        this.position(positionForField);
        return this.readLongArray();
    }

    public float[] readFloatArray(int positionForField) {
        this.position(positionForField);
        return this.readFloatArray();
    }

    public double[] readDoubleArray(int positionForField) {
        this.position(positionForField);
        return this.readDoubleArray();
    }

    public String[] readStringArray(int positionForField) {
        this.position(positionForField);
        return this.readStringArray();
    }

    public Object[] readObjectArray(int positionForField) {
        this.position(positionForField);
        return this.readObjectArray();
    }

    public byte[][] readArrayOfByteArrays(int positionForField) {
        this.position(positionForField);
        return this.readArrayOfByteArrays();
    }

    public Date readDate(int offset) {
        long time = this.readLong(offset);
        return this.convertLongToDate(time);
    }

    @Override
    public boolean readBoolean(int pos) {
        try {
            return super.readBoolean(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX boolean field", e);
        }
    }

    @Override
    public byte readByte(int pos) {
        try {
            return super.readByte(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX byte field", e);
        }
    }

    @Override
    public char readChar(int pos) {
        try {
            return super.readChar(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX char field", e);
        }
    }

    @Override
    public double readDouble(int pos) {
        try {
            return super.readDouble(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX double field", e);
        }
    }

    @Override
    public float readFloat(int pos) {
        try {
            return super.readFloat(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX float field", e);
        }
    }

    @Override
    public int readInt(int pos) {
        try {
            return super.readInt(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX int field", e);
        }
    }

    @Override
    public long readLong(int pos) {
        try {
            return super.readLong(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX long field", e);
        }
    }

    @Override
    public short readShort(int pos) {
        try {
            return super.readShort(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX short field", e);
        }
    }

    @Override
    public void position(int absPos) {
        try {
            super.position(absPos);
        }
        catch (IllegalArgumentException e) {
            throw new PdxSerializationException("Internal error; failed to set position to " + absPos, e);
        }
    }

    public String readString() {
        try {
            return DataSerializer.readString(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public Object readObject() {
        try {
            return DataSerializer.readObject(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
        catch (ClassNotFoundException e) {
            throw new PdxSerializationException("Class not found deserializing a PDX field", e);
        }
    }

    public char[] readCharArray() {
        try {
            return DataSerializer.readCharArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public boolean[] readBooleanArray() {
        try {
            return DataSerializer.readBooleanArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public byte[] readByteArray() {
        try {
            return DataSerializer.readByteArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public short[] readShortArray() {
        try {
            return DataSerializer.readShortArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public int[] readIntArray() {
        try {
            return DataSerializer.readIntArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public long[] readLongArray() {
        try {
            return DataSerializer.readLongArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public float[] readFloatArray() {
        try {
            return DataSerializer.readFloatArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public double[] readDoubleArray() {
        try {
            return DataSerializer.readDoubleArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public String[] readStringArray() {
        try {
            return DataSerializer.readStringArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
    }

    public Object[] readObjectArray() {
        try {
            return DataSerializer.readObjectArray(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
        catch (ClassNotFoundException e) {
            throw new PdxSerializationException("Class not found while deserializing a PDX field", e);
        }
    }

    public byte[][] readArrayOfByteArrays() {
        try {
            return DataSerializer.readArrayOfByteArrays(this);
        }
        catch (IOException e) {
            throw new PdxSerializationException("Exception deserializing a PDX field", e);
        }
        catch (ClassNotFoundException ex) {
            throw new InternalGemFireException("ClassNotFoundException should never be thrown but it was", ex);
        }
    }

    public Date readDate() {
        long time = this.readLong();
        return this.convertLongToDate(time);
    }

    @Override
    public boolean readBoolean() {
        try {
            return super.readBoolean();
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX boolean field", e);
        }
    }

    @Override
    public byte readByte() {
        try {
            return super.readByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX byte field", e);
        }
    }

    @Override
    public char readChar() {
        try {
            return super.readChar();
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX char field", e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return super.readDouble();
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX double field", e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return super.readFloat();
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX float field", e);
        }
    }

    @Override
    public int readInt() {
        try {
            return super.readInt();
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX int field", e);
        }
    }

    @Override
    public long readLong() {
        try {
            return super.readLong();
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX long field", e);
        }
    }

    @Override
    public short readShort() {
        try {
            return super.readShort();
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdxSerializationException("Failed reading a PDX short field", e);
        }
    }

    @Override
    public ByteBufferInputStream.ByteSource slice(int startOffset, int endOffset) {
        try {
            return super.slice(startOffset, endOffset);
        }
        catch (IllegalArgumentException e) {
            throw new PdxSerializationException("Internal error; failed to slice start=" + startOffset + " end=" + endOffset, e);
        }
    }

    private Date convertLongToDate(long v) {
        Date result = null;
        if (v != -1L) {
            result = new Date(v);
        }
        return result;
    }
}

