/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.pdx.internal.ClientTypeRegistration;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.PeerTypeRegistration;
import com.gemstone.gemfire.pdx.internal.TypeRegistration;
import java.util.Map;

public class LonerTypeRegistration
implements TypeRegistration {
    private volatile TypeRegistration delegate = null;
    private final GemFireCacheImpl cache;

    public LonerTypeRegistration(GemFireCacheImpl cache) {
        this.cache = cache;
    }

    @Override
    public int defineType(PdxType newType) {
        this.initializeRegistry();
        return this.delegate.defineType(newType);
    }

    @Override
    public PdxType getType(int typeId) {
        this.initializeRegistry();
        return this.delegate.getType(typeId);
    }

    @Override
    public void addRemoteType(int typeId, PdxType type) {
        this.initializeRegistry();
        this.delegate.addRemoteType(typeId, type);
    }

    @Override
    public int getLastAllocatedTypeId() {
        this.initializeRegistry();
        return this.delegate.getLastAllocatedTypeId();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void gatewaySenderStarted(GatewaySender gatewaySender) {
        this.initializeRegistry(false);
        this.delegate.gatewaySenderStarted(gatewaySender);
    }

    @Override
    public void creatingPersistentRegion() {
        if (this.delegate != null) {
            this.delegate.creatingPersistentRegion();
        }
    }

    @Override
    public void creatingPool() {
        this.initializeRegistry(true);
        this.delegate.creatingPool();
    }

    private synchronized void initializeRegistry() {
        this.initializeRegistry(this.cache.hasPool());
    }

    private synchronized void initializeRegistry(boolean client) {
        if (this.delegate != null) {
            return;
        }
        TypeRegistration delegateTmp = client ? new ClientTypeRegistration(this.cache) : new PeerTypeRegistration(this.cache);
        delegateTmp.initialize();
        this.delegate = delegateTmp;
    }

    public static boolean isIndeterminateLoner(GemFireCacheImpl cache) {
        boolean isLoner = cache.getDistributedSystem().isLoner();
        boolean pdxConfigured = cache.getPdxPersistent();
        return isLoner && !pdxConfigured;
    }

    @Override
    public int getEnumId(Enum<?> v) {
        this.initializeRegistry();
        return this.delegate.getEnumId(v);
    }

    @Override
    public void addRemoteEnum(int enumId, EnumInfo newInfo) {
        this.initializeRegistry();
        this.delegate.addRemoteEnum(enumId, newInfo);
    }

    @Override
    public int defineEnum(EnumInfo newInfo) {
        this.initializeRegistry();
        return this.delegate.defineEnum(newInfo);
    }

    @Override
    public EnumInfo getEnumById(int enumId) {
        this.initializeRegistry();
        return this.delegate.getEnumById(enumId);
    }

    @Override
    public Map<Integer, PdxType> types() {
        this.initializeRegistry();
        return this.delegate.types();
    }

    @Override
    public Map<Integer, EnumInfo> enums() {
        this.initializeRegistry();
        return this.delegate.enums();
    }

    @Override
    public PdxType getPdxTypeForField(String fieldName, String className) {
        return this.delegate.getPdxTypeForField(fieldName, className);
    }

    @Override
    public void testClearRegistry() {
    }

    @Override
    public boolean isClient() {
        return this.delegate.isClient();
    }

    @Override
    public void addImportedType(int typeId, PdxType importedType) {
        this.initializeRegistry();
        this.delegate.addImportedType(typeId, importedType);
    }

    @Override
    public void addImportedEnum(int enumId, EnumInfo importedInfo) {
        this.initializeRegistry();
        this.delegate.addImportedEnum(enumId, importedInfo);
    }

    @Override
    public int getLocalSize() {
        return this.delegate.getLocalSize();
    }
}

