/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.pdx.PdxInitializationException;
import com.gemstone.gemfire.pdx.internal.PeerTypeRegistration;
import com.gemstone.gemfire.pdx.internal.TypeRegistration;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class CheckTypeRegistryState
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private int processorId;

    public CheckTypeRegistryState() {
    }

    protected CheckTypeRegistryState(int processorId) {
        this.processorId = processorId;
    }

    public static void send(DM dm) {
        Set recipients = dm.getOtherDistributionManagerIds();
        ReplyProcessor21 replyProcessor = new ReplyProcessor21(dm, (Collection)recipients);
        CheckTypeRegistryState msg = new CheckTypeRegistryState(replyProcessor.getProcessorId());
        msg.setRecipients(recipients);
        dm.putOutgoing(msg);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (e.getCause() instanceof PdxInitializationException) {
                throw new PdxInitializationException("Bad PDX configuration on member " + e.getSender() + ": " + e.getCause().getMessage(), e.getCause());
            }
            throw new InternalGemFireError("Unexpected exception", e);
        }
        catch (InterruptedException e) {
            throw new InternalGemFireError("Unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        ReplyException e = null;
        try {
            TypeRegistration registry;
            TypeRegistry pdxRegistry;
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && !cache.isClosed() && (pdxRegistry = cache.getPdxRegistry()) != null && (registry = pdxRegistry.getTypeRegistration()) instanceof PeerTypeRegistration) {
                PeerTypeRegistration peerRegistry = (PeerTypeRegistration)registry;
                peerRegistry.verifyConfiguration();
            }
        }
        catch (Exception ex) {
            e = new ReplyException(ex);
        }
        finally {
            ReplyMessage rm = new ReplyMessage();
            rm.setException(e);
            rm.setProcessorId(this.processorId);
            rm.setRecipient(this.getSender());
            dm.putOutgoing(rm);
        }
    }

    @Override
    public int getDSFID() {
        return 2128;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
    }
}

