/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.security;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.security.AccessControl;
import com.gemstone.gemfire.management.internal.security.CLIOperationContext;
import com.gemstone.gemfire.management.internal.security.JMXOperationContext;
import com.gemstone.gemfire.management.internal.security.MBeanServerWrapper;
import com.gemstone.gemfire.management.internal.security.ResourceOperationContext;
import com.gemstone.gemfire.security.Authenticator;
import java.lang.management.ManagementFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;
import org.apache.logging.log4j.Logger;

public class ManagementInterceptor
implements JMXAuthenticator {
    public static final String USER_NAME = "security-username";
    public static final String PASSWORD = "security-password";
    public static final String OBJECT_NAME_ACCESSCONTROL = "GemFire:service=AccessControl,type=Distributed";
    private MBeanServerWrapper mBeanServerForwarder;
    private Logger logger;
    private static Class accessControlKlass = null;
    private static Class authenticatorClass = null;

    public ManagementInterceptor(Logger logger) {
        this.logger = logger;
        this.mBeanServerForwarder = new MBeanServerWrapper(this);
        this.registerAccessContorlMbean();
        LogService.getLogger().info("Starting management interceptor");
    }

    private void registerAccessContorlMbean() {
        block6: {
            try {
                AccessControl acc = new AccessControl(this);
                ObjectName name = new ObjectName(OBJECT_NAME_ACCESSCONTROL);
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                Set<ObjectName> names = platformMBeanServer.queryNames(name, null);
                if (!names.isEmpty()) break block6;
                try {
                    platformMBeanServer.registerMBean(acc, name);
                    this.logger.info("Registered AccessContorlMBean on " + name);
                }
                catch (InstanceAlreadyExistsException e) {
                    throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
                }
                catch (MBeanRegistrationException e) {
                    throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
                }
                catch (NotCompliantMBeanException e) {
                    throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
                }
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Subject authenticate(Object credentials) {
        String username = null;
        String password = null;
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                username = "empty";
                password = "emptypwd";
            }
            username = "empty";
            password = "emptypwd";
        } else {
            String[] aCredentials = (String[])credentials;
            username = aCredentials[0];
            password = aCredentials[1];
        }
        Properties pr = new Properties();
        pr.put(USER_NAME, username);
        pr.put(PASSWORD, password);
        this.getAuthenticator(pr).authenticate(pr, null);
        return new Subject(true, Collections.singleton(new JMXPrincipal(username)), Collections.EMPTY_SET, Collections.EMPTY_SET);
    }

    public void authorize(ObjectName name, String methodName, Object[] params) {
        try {
            ObjectName accessControlMBean = new ObjectName(OBJECT_NAME_ACCESSCONTROL);
            if (name.equals(accessControlMBean)) {
                this.logger.info("Granting access to accessContorlMXBean.. name=" + name);
                return;
            }
        }
        catch (MalformedObjectNameException accessControlMBean) {
            // empty catch block
        }
        String domain = name.getDomain();
        if (!"GemFire".equals(domain)) {
            return;
        }
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return;
        }
        if (methodName.equals("createMBean") || methodName.equals("unregisterMBean")) {
            throw new SecurityException("Access denied");
        }
        Set<JMXPrincipal> principals = subject.getPrincipals(JMXPrincipal.class);
        Set<Object> pubCredentials = subject.getPublicCredentials();
        if (principals == null || principals.isEmpty()) {
            throw new SecurityException("Access denied");
        }
        Principal principal = principals.iterator().next();
        LogService.getLogger().info("Name=" + name + " methodName=" + methodName + " principal=" + principal.getName());
        if ("getAttribute".equals(methodName) || "getAttributes".equals(methodName)) {
            return;
        }
        ResourceOperationContext resourceContext = this.buildContext(name, methodName, params);
        boolean authorized = this.getAccessControl(principal).authorizeOperation(null, resourceContext);
        LogService.getLogger().info("Name=" + name + " methodName=" + methodName + " result=" + authorized + " principal=" + principal.getName());
        if (!authorized) {
            throw new SecurityException("Access denied");
        }
    }

    public MBeanServerForwarder getMBeanServerForwarder() {
        return this.mBeanServerForwarder;
    }

    public com.gemstone.gemfire.security.AccessControl getAccessControl(Principal principal) {
        if (accessControlKlass == null) {
            String authorizeKlass = System.getProperty("resource-auth-accessor");
            try {
                accessControlKlass = Class.forName(authorizeKlass);
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)e);
                throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
            }
        }
        try {
            com.gemstone.gemfire.security.AccessControl accessControl = (com.gemstone.gemfire.security.AccessControl)accessControlKlass.newInstance();
            accessControl.init(principal, null, null);
            LogService.getLogger().info("Returning resource accessControl");
            return accessControl;
        }
        catch (InstantiationException e) {
            this.logger.error((Object)e);
            throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)e);
            throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
        }
    }

    private Authenticator getAuthenticator(Properties pr) {
        if (authenticatorClass == null) {
            String authenticatorKlass = System.getProperty("resource-authenticator");
            try {
                authenticatorClass = Class.forName(authenticatorKlass);
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)e);
                throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
            }
        }
        try {
            Authenticator authenticator = (Authenticator)authenticatorClass.newInstance();
            authenticator.init(pr, null, null);
            LogService.getLogger().info("Returning resource authenticator " + authenticator);
            return authenticator;
        }
        catch (InstantiationException e) {
            this.logger.error((Object)e);
            throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)e);
            throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
        }
    }

    private ResourceOperationContext buildContext(ObjectName name, String methodName, Object[] params) {
        String service;
        if (params != null) {
            LogService.getLogger().info("Params length=" + params.length);
            for (int i = 0; i < params.length; ++i) {
                LogService.getLogger().info("Params[" + i + "] is " + this.arrayString(params[i]));
            }
        }
        if ((service = name.getKeyProperty("service")) == null && "processCommand".equals(methodName)) {
            Object[] array = (Object[])params[0];
            String command = (String)array[0];
            CLIOperationContext context = new CLIOperationContext(command);
            LogService.getLogger().info("Returning CLIContext for " + methodName);
            return context;
        }
        JMXOperationContext context = new JMXOperationContext(name, methodName);
        LogService.getLogger().info("Returning JMXOperationContext for " + methodName);
        return context;
    }

    private String arrayString(Object object) {
        StringBuilder sb = new StringBuilder();
        if (object instanceof Object[]) {
            Object[] array;
            for (Object a : array = (Object[])object) {
                sb.append(a).append(" ");
            }
        }
        return sb.toString();
    }
}

