/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.ManagementService;
import java.util.LinkedList;

public class RegionPath {
    private final String regionPath;
    private String regionName;
    private String regionParentPath;

    public RegionPath(String pathName) {
        this.regionPath = pathName;
        String[] regions = pathName.split("/");
        LinkedList<String> regionsNames = new LinkedList<String>();
        for (String region : regions) {
            if (region.isEmpty()) continue;
            regionsNames.add(region);
        }
        this.regionName = (String)regionsNames.removeLast();
        StringBuilder parentPathBuilder = new StringBuilder();
        while (!regionsNames.isEmpty()) {
            parentPathBuilder.append("/").append((String)regionsNames.removeFirst());
        }
        this.regionParentPath = parentPathBuilder.length() != 0 ? parentPathBuilder.toString() : null;
    }

    public String getName() {
        return this.regionName;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public String getParent() {
        return this.regionParentPath;
    }

    public RegionPath getParentRegionPath() {
        if (this.regionParentPath == null) {
            return null;
        }
        return new RegionPath(this.getParent());
    }

    public boolean isRootRegion() {
        return this.regionParentPath == null;
    }

    public boolean existsInCache(Cache cache) {
        return cache != null && cache.getRegion(this.regionPath) != null;
    }

    public boolean existsInCluster(Cache cache) {
        boolean existsInCluster = false;
        if (cache != null) {
            ManagementService managementService = ManagementService.getExistingManagementService(cache);
            if (managementService.isManager()) {
                existsInCluster = managementService != null && managementService.getDistributedRegionMXBean(this.regionPath) != null;
            } else {
                throw new ManagementException("Not a cache from Manager member.");
            }
        }
        return existsInCluster;
    }

    public String toString() {
        return "RegionPath [regionPath=" + this.regionPath + "]";
    }

    public static void main(String[] args) {
        RegionPath rp = new RegionPath("/region1/region11/region111/region1112");
        System.out.println("name :: " + rp.getName());
        System.out.println("regionpath :: " + rp.getRegionPath());
        System.out.println("parent :: " + rp.getParent());
        System.out.println("parent region path :: " + rp.getParentRegionPath());
        System.out.println("---------------------------------------------------");
        rp = new RegionPath("/region1");
        System.out.println("name :: " + rp.getName());
        System.out.println("regionpath :: " + rp.getRegionPath());
        System.out.println("parent :: " + rp.getParent());
        System.out.println("parent region path :: " + rp.getParentRegionPath());
    }
}

