/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.util;

import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.GfshParser;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.regex.Pattern;

public class DiskStoreUpgrader {
    public static String STACKTRACE_START = "--------------------------";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String errorString = null;
        String stackTraceString = null;
        String diskStoreName = null;
        String diskDirsStr = null;
        String[] diskDirs = null;
        String maxOpLogSize = null;
        long maxOplogSize = -1L;
        if (args.length < 3) {
            throw new IllegalArgumentException("Requires 3 arguments : <diskStoreName> <diskDirs> <maxOpLogSize>");
        }
        Properties prop = new Properties();
        try {
            prop.load(new StringReader(args[0] + GfshParser.LINE_SEPARATOR + args[1] + GfshParser.LINE_SEPARATOR + args[2]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Requires 3 arguments : <diskStoreName> <diskDirs> <maxOpLogSize>");
        }
        try {
            diskStoreName = prop.getProperty("name");
            diskDirsStr = prop.getProperty("disk-dirs");
            diskDirs = diskDirsStr.split(",");
            maxOpLogSize = prop.getProperty("max-oplog-size");
            maxOplogSize = Long.valueOf(maxOpLogSize);
            DiskStoreUpgrader.upgrade(diskStoreName, diskDirs, maxOplogSize);
        }
        catch (GemFireIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalStateException) {
                String message = cause.getMessage();
                errorString = DiskStoreUpgrader.stringMatches(LocalizedStrings.DiskInitFile_THE_INIT_FILE_0_DOES_NOT_EXIST.toLocalizedString("(.*)"), message) ? CliStrings.format("Cannot locate disk store \"{0}\" in directory : \"{1}\"", diskStoreName, CliUtil.arrayToString(diskDirs)) : message;
            } else if (cause instanceof DiskAccessException) {
                boolean isKnownCause = false;
                Throwable nestedCause = cause.getCause();
                if (nestedCause instanceof IOException) {
                    String message = nestedCause.getMessage();
                    if (DiskStoreUpgrader.stringMatches(LocalizedStrings.Oplog_THE_FILE_0_IS_BEING_USED_BY_ANOTHER_PROCESS.toLocalizedString("(.*)"), message)) {
                        errorString = "The disk is currently being used by another process";
                        isKnownCause = true;
                    }
                }
                if (!isKnownCause) {
                    errorString = CliStrings.format("Can not access disk store \"{0}\" from  \"{1}\". Check gfsh logs for error.", diskStoreName, CliUtil.arrayToString(diskDirs));
                }
            } else {
                errorString = e.getMessage();
            }
            stackTraceString = CliUtil.stackTraceAsString(e);
        }
        catch (IllegalArgumentException e) {
            errorString = e.getMessage();
            stackTraceString = CliUtil.stackTraceAsString(e);
        }
        finally {
            if (errorString != null) {
                System.err.println(errorString);
            }
            if (stackTraceString != null) {
                System.err.println(STACKTRACE_START);
                System.err.println(stackTraceString);
            }
        }
    }

    private static void upgrade(String diskStoreName, String[] diskDirs, long maxOplogSize) {
        File[] dirs = null;
        if (diskDirs != null) {
            dirs = new File[diskDirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
        }
        try {
            DiskStoreImpl.offlineCompact(diskStoreName, dirs, true, maxOplogSize);
        }
        catch (Exception ex) {
            String fieldsMessage = maxOplogSize != -1L ? "max-oplog-size=" + maxOplogSize + "," : "";
            fieldsMessage = fieldsMessage + CliUtil.arrayToString(dirs);
            throw new GemFireIOException(CliStrings.format("Error occured while upgrading disk store={0} {1}. Reason: {2}", diskStoreName, fieldsMessage, ex.getMessage()), ex);
        }
    }

    private static boolean stringMatches(String str1, String str2) {
        return Pattern.matches(str1, str2);
    }
}

