/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.shell.jline;

import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.PreprocessorUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.history.MemoryHistory;

public class GfshHistory
extends MemoryHistory {
    private static final Pattern passwordRe = Pattern.compile("(--[^=\\s]*password[^=\\s]*\\s*=\\s*)([^\\s]*)");
    private boolean autoFlush = true;

    public void addToHistory(String buffer) {
        if (this.isAutoFlush()) {
            super.add((CharSequence)GfshHistory.toHistoryLoggable(buffer));
        }
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public static String toHistoryLoggable(String buffer) {
        String trimmed = PreprocessorUtils.trim(buffer, false).getString();
        Matcher matcher = passwordRe.matcher(trimmed);
        String sanitized = matcher.replaceAll("$1*****");
        return sanitized;
    }
}

