/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.shell.jline;

import com.gemstone.gemfire.management.internal.cli.shell.jline.ANSIBuffer;

public class ANSIHandler {
    private static ANSIHandler instance;
    private boolean isAnsiEnabled;

    public ANSIHandler(boolean isAnsiEnabled) {
        this.isAnsiEnabled = isAnsiEnabled;
    }

    public static ANSIHandler getInstance(boolean isAnsiSupported) {
        if (instance == null) {
            instance = new ANSIHandler(isAnsiSupported);
        }
        return instance;
    }

    public boolean isAnsiEnabled() {
        return this.isAnsiEnabled;
    }

    public String decorateString(String input, ANSIStyle ... styles) {
        String decoratedInput = input;
        if (this.isAnsiEnabled()) {
            ANSIBuffer ansiBuffer = ANSIBuffer.getANSIBuffer();
            block13: for (ANSIStyle ansiStyle : styles) {
                switch (ansiStyle) {
                    case RED: {
                        ansiBuffer.red(input);
                        continue block13;
                    }
                    case BLUE: {
                        ansiBuffer.blue(input);
                        continue block13;
                    }
                    case GREEN: {
                        ansiBuffer.green(input);
                        continue block13;
                    }
                    case BLACK: {
                        ansiBuffer.black(input);
                        continue block13;
                    }
                    case YELLOW: {
                        ansiBuffer.yellow(input);
                        continue block13;
                    }
                    case MAGENTA: {
                        ansiBuffer.magenta(input);
                        continue block13;
                    }
                    case CYAN: {
                        ansiBuffer.cyan(input);
                        continue block13;
                    }
                    case BOLD: {
                        ansiBuffer.bold(input);
                        continue block13;
                    }
                    case UNDERSCORE: {
                        ansiBuffer.underscore(input);
                        continue block13;
                    }
                    case BLINK: {
                        ansiBuffer.blink(input);
                        continue block13;
                    }
                    case REVERSE: {
                        ansiBuffer.reverse(input);
                        continue block13;
                    }
                }
            }
            decoratedInput = ansiBuffer.toString();
        }
        return decoratedInput;
    }

    public static enum ANSIStyle {
        RED,
        BLUE,
        GREEN,
        BLACK,
        YELLOW,
        MAGENTA,
        CYAN,
        BOLD,
        UNDERSCORE,
        BLINK,
        REVERSE;

    }
}

