/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.shell;

import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.CommandRequest;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.shell.JMXConnectionException;
import com.gemstone.gemfire.management.internal.cli.shell.JMXConnectionListener;
import com.gemstone.gemfire.management.internal.cli.shell.JMXInvocationException;
import com.gemstone.gemfire.management.internal.cli.shell.OperationInvoker;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class JmxOperationInvoker
implements OperationInvoker {
    public static final String JMX_URL_FORMAT = "service:jmx:rmi://{0}/jndi/rmi://{0}:{1}/jmxrmi";
    private JMXConnector connector;
    private JMXServiceURL url;
    private MBeanServerConnection mbsc;
    private String endpoints;
    private String managerHost;
    private int managerPort;
    private DistributedSystemMXBean distributedSystemMXBeanProxy;
    private MemberMXBean memberMXBeanProxy;
    private ObjectName managerMemberObjectName;
    final AtomicBoolean isConnected = new AtomicBoolean(false);
    final AtomicBoolean isSelfDisconnect = new AtomicBoolean(false);
    private int clusterId = -1;

    public JmxOperationInvoker(String host, int port, String userName, String password, Map<String, String> sslConfigProps) throws Exception {
        TreeSet<String> propsToClear = new TreeSet<String>();
        try {
            this.managerHost = host;
            this.managerPort = port;
            this.endpoints = host + "[" + port + "]";
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("jmx.remote.x.client.connection.check.period", 1000L);
            if (userName != null && userName.length() > 0) {
                env.put("jmx.remote.credentials", new String[]{userName, password});
            }
            Set<Map.Entry<String, String>> entrySet = sslConfigProps.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!key.startsWith("javax.") && !key.startsWith("cluster-ssl") && !key.startsWith("jmx-manager-ssl") || ((key = this.checkforSystemPropertyPrefix(entry.getKey())).equals("javax.rmi.ssl.client.enabledCipherSuites") || key.equals("javax.rmi.ssl.client.enabledProtocols")) && "any".equals(value)) continue;
                System.setProperty(key, value);
                propsToClear.add(key);
            }
            if (!(sslConfigProps.isEmpty() || System.getProperty("javax.net.ssl.keyStore") == null && System.getProperty("javax.net.ssl.trustStore") == null)) {
                env.put("com.sun.jndi.rmi.factory.socket", new SslRMIClientSocketFactory());
            }
            this.url = new JMXServiceURL(MessageFormat.format(JMX_URL_FORMAT, JmxOperationInvoker.checkAndConvertToCompatibleIPv6Syntax(host), String.valueOf(port)));
            this.connector = JMXConnectorFactory.connect(this.url, env);
            this.mbsc = this.connector.getMBeanServerConnection();
            this.connector.addConnectionNotificationListener(new JMXConnectionListener(this), null, null);
            this.connector.connect();
            this.distributedSystemMXBeanProxy = JMX.newMXBeanProxy(this.mbsc, MBeanJMXAdapter.getDistributedSystemName(), DistributedSystemMXBean.class);
            if (this.distributedSystemMXBeanProxy == null || !JMX.isMXBeanInterface(DistributedSystemMXBean.class)) {
                LogWrapper.getInstance().info("DistributedSystemMXBean is not present on member with endpoints : " + this.endpoints);
                this.connector.close();
                throw new JMXConnectionException(2);
            }
            this.managerMemberObjectName = this.distributedSystemMXBeanProxy.getMemberObjectName();
            if (this.managerMemberObjectName == null || !JMX.isMXBeanInterface(MemberMXBean.class)) {
                LogWrapper.getInstance().info("MemberMXBean with ObjectName " + this.managerMemberObjectName + " is not present on member with endpoints : " + this.endpoints);
                this.connector.close();
                throw new JMXConnectionException(2);
            }
            this.memberMXBeanProxy = JMX.newMXBeanProxy(this.mbsc, this.managerMemberObjectName, MemberMXBean.class);
            this.isConnected.set(true);
            this.clusterId = this.distributedSystemMXBeanProxy.getDistributedSystemId();
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            for (String propToClear : propsToClear) {
                System.clearProperty(propToClear);
            }
        }
    }

    private String checkforSystemPropertyPrefix(String key) {
        String returnKey = key;
        if (key.startsWith("javax.")) {
            returnKey = key;
        }
        if (key.startsWith("cluster-ssl") || key.startsWith("jmx-manager-ssl")) {
            if (key.endsWith("keystore")) {
                returnKey = "javax.net.ssl.keyStore";
            } else if (key.endsWith("keystore-password")) {
                returnKey = "javax.net.ssl.keyStorePassword";
            } else if (key.endsWith("ciphers")) {
                returnKey = "javax.rmi.ssl.client.enabledCipherSuites";
            } else if (key.endsWith("truststore-password")) {
                returnKey = "javax.net.ssl.trustStorePassword";
            } else if (key.endsWith("truststore")) {
                returnKey = "javax.net.ssl.trustStore";
            } else if (key.endsWith("protocols")) {
                returnKey = "javax.rmi.ssl.client.enabledProtocols";
            }
        }
        return returnKey;
    }

    @Override
    public Object getAttribute(String resourceName, String attributeName) throws JMXInvocationException {
        try {
            return this.mbsc.getAttribute(ObjectName.getInstance(resourceName), attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new JMXInvocationException(attributeName + " not found for " + resourceName, e);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXInvocationException(resourceName + " is not registered in the MBean server.", e);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXInvocationException(resourceName + " is not a valid resource name.", e);
        }
        catch (MBeanException e) {
            throw new JMXInvocationException("Exception while fetching " + attributeName + " for " + resourceName, e);
        }
        catch (ReflectionException e) {
            throw new JMXInvocationException("Couldn't find " + attributeName + " for " + resourceName, e);
        }
        catch (NullPointerException e) {
            throw new JMXInvocationException("Given resourceName is null.", e);
        }
        catch (IOException e) {
            throw new JMXInvocationException(resourceName + " is not a valid resource name.", e);
        }
    }

    @Override
    public Object invoke(String resourceName, String operationName, Object[] params, String[] signature) throws JMXInvocationException {
        try {
            return this.invoke(ObjectName.getInstance(resourceName), operationName, params, signature);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXInvocationException(resourceName + " is not a valid resource name.", e);
        }
        catch (NullPointerException e) {
            throw new JMXInvocationException("Given resourceName is null.", e);
        }
    }

    protected Object invoke(ObjectName resource, String operationName, Object[] params, String[] signature) throws JMXInvocationException {
        try {
            return this.mbsc.invoke(resource, operationName, params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXInvocationException(resource + " is not registered in the MBean server.", e);
        }
        catch (MBeanException e) {
            throw new JMXInvocationException("Exception while invoking " + operationName + " on " + resource, e);
        }
        catch (ReflectionException e) {
            throw new JMXInvocationException("Couldn't find " + operationName + " on " + resource + " with arguments " + Arrays.toString(signature), e);
        }
        catch (IOException e) {
            throw new JMXInvocationException("Couldn't communicate with remote server at " + this.toString(), e);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExpression) {
        try {
            return this.getMBeanServerConnection().queryNames(objectName, queryExpression);
        }
        catch (IOException e) {
            throw new JMXInvocationException(String.format("Failed to communicate with the remote MBean server at (%1$s)!", this.toString()), e);
        }
    }

    @Override
    public Object processCommand(CommandRequest commandRequest) throws JMXInvocationException {
        if (commandRequest.hasFileData()) {
            return this.memberMXBeanProxy.processCommand(commandRequest.getInput(), commandRequest.getEnvironment(), ArrayUtils.toByteArray(commandRequest.getFileData()));
        }
        return this.memberMXBeanProxy.processCommand(commandRequest.getInput(), commandRequest.getEnvironment());
    }

    @Override
    public void stop() {
        try {
            this.isSelfDisconnect.set(true);
            this.connector.close();
            this.isConnected.set(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected.get();
    }

    @Override
    public DistributedSystemMXBean getDistributedSystemMXBean() {
        if (this.distributedSystemMXBeanProxy == null) {
            throw new IllegalStateException("The DistributedSystemMXBean proxy was not initialized properly!");
        }
        return this.distributedSystemMXBeanProxy;
    }

    public JMXServiceURL getJmxServiceUrl() {
        return this.url;
    }

    public String getManagerHost() {
        return this.managerHost;
    }

    public int getManagerPort() {
        return this.managerPort;
    }

    @Override
    public <T> T getMBeanProxy(ObjectName objectName, Class<T> mbeanInterface) {
        if (DistributedSystemMXBean.class.equals(mbeanInterface) && "GemFire:service=System,type=Distributed".equals(objectName.toString())) {
            return mbeanInterface.cast(this.getDistributedSystemMXBean());
        }
        if (JMX.isMXBeanInterface(mbeanInterface)) {
            return JMX.newMXBeanProxy(this.getMBeanServerConnection(), objectName, mbeanInterface);
        }
        return JMX.newMBeanProxy(this.getMBeanServerConnection(), objectName, mbeanInterface);
    }

    public MBeanServerConnection getMBeanServerConnection() {
        if (this.mbsc == null) {
            throw new IllegalStateException("Gfsh is not connected to the GemFire Manager.");
        }
        return this.mbsc;
    }

    @Override
    public boolean isReady() {
        try {
            return this.mbsc.isRegistered(this.managerMemberObjectName);
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        return this.endpoints;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    void resetClusterId() {
        this.clusterId = -1;
    }

    public static String checkAndConvertToCompatibleIPv6Syntax(String hostAddress) {
        if (hostAddress.indexOf(":") != -1) {
            LogWrapper logger = LogWrapper.getInstance();
            if (logger.fineEnabled()) {
                logger.fine("IPv6 host address detected, using IPv6 syntax for host in JMX connection URL");
            }
            hostAddress = "[" + hostAddress + "]";
            if (logger.fineEnabled()) {
                logger.fine("Compatible host address is : " + hostAddress);
            }
        }
        return hostAddress;
    }
}

