/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.remote;

import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliAroundInterceptor;
import com.gemstone.gemfire.management.internal.cli.GfshParseResult;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.remote.CommandExecutionContext;
import com.gemstone.gemfire.management.internal.cli.result.FileResult;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import java.lang.reflect.Method;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class RemoteExecutionStrategy {
    private LogWrapper logWrapper = LogWrapper.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ParseResult parseResult) throws RuntimeException {
        Result result = null;
        Assert.notNull((Object)parseResult, (String)"Parse result required");
        if (!GfshParseResult.class.isInstance(parseResult)) {
            throw new IllegalArgumentException("Command Configuration/Definition error.");
        }
        GfshParseResult gfshParseResult = (GfshParseResult)parseResult;
        Method method = gfshParseResult.getMethod();
        if (this.isShellOnly(method)) throw new IllegalArgumentException("Only Remote command can be executed through " + ManagementService.class.getSimpleName() + ".processCommand() or ManagementMBean's processCommand " + "operation. Please refer documentation for the list of " + "commands.");
        Boolean fromShell = CommandExecutionContext.isShellRequest();
        boolean sentFromShell = fromShell != null && fromShell != false;
        String interceptorClass = this.getInterceptor(gfshParseResult.getMethod());
        CliAroundInterceptor interceptor = null;
        if (!sentFromShell && !"__NULL__".equals(interceptorClass)) {
            try {
                interceptor = (CliAroundInterceptor)ClassPathLoader.getLatest().forName(interceptorClass).newInstance();
            }
            catch (InstantiationException e) {
                this.logWrapper.info(e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.logWrapper.info(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                this.logWrapper.info(e.getMessage());
            }
            if (interceptor == null) return ResultBuilder.createBadConfigurationErrorResult("Interceptor Configuration Error");
            Result preExecResult = interceptor.preExecution(gfshParseResult);
            if (Result.Status.ERROR.equals((Object)preExecResult.getStatus())) {
                return preExecResult;
            }
            if (preExecResult instanceof FileResult) {
                FileResult fileResult = (FileResult)preExecResult;
                byte[][] fileData = fileResult.toBytes();
                CommandExecutionContext.setBytesFromShell(fileData);
            }
        }
        this.logWrapper.info("Executing " + gfshParseResult.getUserInput());
        GemFireCacheImpl gfc = GemFireCacheImpl.getInstance();
        if (gfc.getDistributionManager().isSharedConfigurationServiceEnabledForDS() && (this.writesToSharedConfiguration(method) || this.readsFromSharedConfiguration(method))) {
            DistributedLockService dls = SharedConfiguration.getSharedConfigLockService(InternalDistributedSystem.getAnyInstance());
            if (!dls.lock("__CLUSTER_CONFIG_LOCK", 10000L, -1L)) return ResultBuilder.createGemFireErrorResult("Unable to execute the command due to ongoing configuration change/member startup.");
            try {
                result = (Result)ReflectionUtils.invokeMethod((Method)gfshParseResult.getMethod(), (Object)gfshParseResult.getInstance(), (Object[])gfshParseResult.getArguments());
            }
            finally {
                dls.unlock("__CLUSTER_CONFIG_LOCK");
            }
        } else {
            result = (Result)ReflectionUtils.invokeMethod((Method)gfshParseResult.getMethod(), (Object)gfshParseResult.getInstance(), (Object[])gfshParseResult.getArguments());
        }
        if (result != null && Result.Status.ERROR.equals((Object)result.getStatus())) {
            this.logWrapper.info("Error occurred while executing \"" + gfshParseResult.getUserInput() + "\".");
        }
        if (interceptor == null) return result;
        Result postExecResult = interceptor.postExecution(gfshParseResult, result);
        if (postExecResult != null) {
            if (Result.Status.ERROR.equals((Object)postExecResult.getStatus())) {
                this.logWrapper.warning(postExecResult.toString(), null);
            } else if (this.logWrapper.fineEnabled()) {
                this.logWrapper.fine(String.valueOf(postExecResult));
            }
            result = postExecResult;
        }
        CommandExecutionContext.setBytesFromShell(null);
        return result;
    }

    private boolean writesToSharedConfiguration(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null && cliMetadata.writesToSharedConfiguration();
    }

    private boolean readsFromSharedConfiguration(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null && cliMetadata.readsSharedConfiguration();
    }

    private boolean isShellOnly(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null && cliMetadata.shellOnly();
    }

    private String getInterceptor(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null ? cliMetadata.interceptor() : "__NULL__";
    }

    public void terminate() {
    }
}

