/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.remote;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.management.cli.CommandService;
import com.gemstone.gemfire.management.cli.CommandServiceException;
import com.gemstone.gemfire.management.cli.CommandStatement;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.remote.CommandProcessor;
import java.io.IOException;
import java.util.Map;

public class MemberCommandService
extends CommandService {
    private final Object modLock = new Object();
    private Cache cache;
    private CommandProcessor commandProcessor;

    public MemberCommandService(Cache cache) throws CommandServiceException {
        this.cache = cache;
        try {
            this.commandProcessor = new CommandProcessor(cache.getDistributedSystem().getProperties());
        }
        catch (ClassNotFoundException e) {
            throw new CommandServiceException("Could not load commands.", e);
        }
        catch (IOException e) {
            throw new CommandServiceException("Could not load commands.", e);
        }
        catch (IllegalStateException e) {
            throw new CommandServiceException(e.getMessage(), e);
        }
    }

    @Override
    public Result processCommand(String commandString) {
        return this.processCommand(commandString, EMPTY_ENV);
    }

    @Override
    public Result processCommand(String commandString, Map<String, String> env) {
        return this.createCommandStatement(commandString, env).process();
    }

    @Override
    public CommandStatement createCommandStatement(String commandString) {
        return this.createCommandStatement(commandString, EMPTY_ENV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandStatement createCommandStatement(String commandString, Map<String, String> env) {
        if (!this.isUsable()) {
            throw new IllegalStateException("Cache instance is not available.");
        }
        Object object = this.modLock;
        synchronized (object) {
            return this.commandProcessor.createCommandStatement(commandString, env);
        }
    }

    @Override
    public boolean isUsable() {
        return this.cache != null && !this.cache.isClosed();
    }
}

