/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.parser.preprocessor;

import com.gemstone.gemfire.internal.lang.SystemUtils;
import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.EnclosingCharacters;
import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.Stack;
import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.TrimmedInput;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PreprocessorUtils {
    public static TrimmedInput simpleTrim(String input) {
        if (input != null) {
            if (!PreprocessorUtils.containsOnlyWhiteSpaces(input)) {
                input = StringUtils.stripEnd((String)input, null);
            }
            String output = input.trim();
            return new TrimmedInput(output, input.length() - output.length());
        }
        return null;
    }

    public static TrimmedInput trim(String input) {
        return PreprocessorUtils.trim(input, true);
    }

    public static TrimmedInput trim(String input, boolean retainLineSeparator) {
        if (input != null) {
            String inputCopy = input;
            StringBuffer output = new StringBuffer();
            inputCopy = StringUtils.stripEnd((String)inputCopy, null);
            while (Pattern.matches("^(.*)(\\s-+)$", inputCopy)) {
                inputCopy = StringUtils.removeEnd((String)inputCopy, (String)"-");
                inputCopy = StringUtils.stripEnd((String)inputCopy, null);
            }
            int noOfSpacesRemoved = 0;
            int length = inputCopy.length();
            inputCopy = inputCopy.trim();
            noOfSpacesRemoved += length - inputCopy.length();
            StringBuffer buffer = new StringBuffer();
            boolean startWhiteSpace = false;
            for (int i = 0; i < inputCopy.length(); ++i) {
                char ch = inputCopy.charAt(i);
                buffer.append(ch);
                if (PreprocessorUtils.isWhitespace(ch)) {
                    if (PreprocessorUtils.isSyntaxValid(buffer.toString()).booleanValue()) {
                        if (startWhiteSpace) {
                            ++noOfSpacesRemoved;
                        } else {
                            startWhiteSpace = true;
                            if (ch == '\n') {
                                if (retainLineSeparator) {
                                    output.append("\n");
                                }
                            } else {
                                output.append(" ");
                            }
                        }
                        buffer.delete(0, buffer.length());
                        continue;
                    }
                    output.append(ch);
                    continue;
                }
                startWhiteSpace = false;
                output.append(ch);
            }
            return new TrimmedInput(output.toString(), noOfSpacesRemoved);
        }
        return null;
    }

    public static String removeWhiteSpaces(String input) {
        if (input != null) {
            input = PreprocessorUtils.trim(input).getString();
            StringBuffer output = new StringBuffer();
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (PreprocessorUtils.isWhitespace(ch)) continue;
                output.append(ch);
            }
            return output.toString();
        }
        return null;
    }

    public static Boolean isSyntaxValid(String input) {
        if (input != null) {
            Stack<Character> stack = new Stack<Character>();
            if (input.length() > 0) {
                for (int i = 0; i < input.length(); ++i) {
                    Character popped;
                    char ch = input.charAt(i);
                    if ('\\' == ch) {
                        ++i;
                        continue;
                    }
                    if (!PreprocessorUtils.isValueEnclosingChar(ch)) continue;
                    if (EnclosingCharacters.DOUBLE_QUOTATION.charValue() == ch) {
                        popped = (Character)stack.pop();
                        if (popped == EnclosingCharacters.DOUBLE_QUOTATION) continue;
                        if (popped != null) {
                            stack.push(popped);
                        }
                        stack.push(Character.valueOf(ch));
                        continue;
                    }
                    if (EnclosingCharacters.SINGLE_QUOTATION.charValue() == ch) {
                        popped = (Character)stack.pop();
                        if (popped == EnclosingCharacters.SINGLE_QUOTATION) continue;
                        if (popped != null) {
                            stack.push(popped);
                        }
                        stack.push(Character.valueOf(ch));
                        continue;
                    }
                    if (PreprocessorUtils.isOpeningBracket(ch)) {
                        stack.push(Character.valueOf(ch));
                        continue;
                    }
                    popped = (Character)stack.pop();
                    if (PreprocessorUtils.matches(popped, ch)) continue;
                    return false;
                }
            }
            if (stack.isEmpty().booleanValue()) {
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean matches(Character popped, char ch) {
        if (popped != null) {
            return PreprocessorUtils.isOpeningBracket(popped.charValue()) && (EnclosingCharacters.OPENING_SQUARE_BRACKET == popped ? EnclosingCharacters.CLOSING_SQUARE_BRACKET.charValue() == ch : (EnclosingCharacters.OPENING_CIRCULAR_BRACKET == popped ? EnclosingCharacters.CLOSING_CIRCULAR_BRACKET.charValue() == ch : EnclosingCharacters.OPENING_CURLY_BRACE == popped && EnclosingCharacters.CLOSING_CURLY_BRACE.charValue() == ch));
        }
        return false;
    }

    private static boolean isClosingBracket(char ch) {
        return EnclosingCharacters.CLOSING_SQUARE_BRACKET.charValue() == ch || EnclosingCharacters.CLOSING_CIRCULAR_BRACKET.charValue() == ch || EnclosingCharacters.CLOSING_CURLY_BRACE.charValue() == ch;
    }

    private static boolean isOpeningBracket(char ch) {
        return EnclosingCharacters.OPENING_SQUARE_BRACKET.charValue() == ch || EnclosingCharacters.OPENING_CIRCULAR_BRACKET.charValue() == ch || EnclosingCharacters.OPENING_CURLY_BRACE.charValue() == ch;
    }

    private static boolean isValueEnclosingChar(char ch) {
        return EnclosingCharacters.OPENING_SQUARE_BRACKET.charValue() == ch || EnclosingCharacters.CLOSING_SQUARE_BRACKET.charValue() == ch || EnclosingCharacters.OPENING_CIRCULAR_BRACKET.charValue() == ch || EnclosingCharacters.CLOSING_CIRCULAR_BRACKET.charValue() == ch || EnclosingCharacters.OPENING_CURLY_BRACE.charValue() == ch || EnclosingCharacters.CLOSING_CURLY_BRACE.charValue() == ch || EnclosingCharacters.DOUBLE_QUOTATION.charValue() == ch || EnclosingCharacters.SINGLE_QUOTATION.charValue() == ch;
    }

    public static boolean containsOnlyWhiteSpaces(String input) {
        if (input != null) {
            for (int i = 0; i < input.length(); ++i) {
                if (PreprocessorUtils.isWhitespace(input.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r' && SystemUtils.isWindows();
    }
}

