/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.parser;

import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.PreprocessorUtils;
import java.util.ArrayList;
import java.util.Arrays;

public class ParserUtils {
    public static String[] split(String input, String splitAround) {
        if (input != null && splitAround != null) {
            ArrayList<String> parts = new ArrayList<String>();
            StringBuffer part = new StringBuffer();
            block0: for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (splitAround.startsWith("" + ch) && PreprocessorUtils.isSyntaxValid(part.toString()).booleanValue()) {
                    StringBuffer temp = new StringBuffer("");
                    for (int j = 0; j < splitAround.length() && i + j < input.length(); ++j) {
                        temp.append(input.charAt(i + j));
                        if (!temp.toString().equals(splitAround)) continue;
                        parts.add(part.toString().trim());
                        part.delete(0, part.length());
                        i = i + j + 1;
                        if (i >= input.length()) break block0;
                        ch = input.charAt(i);
                        break;
                    }
                }
                part.append(ch);
            }
            if (part.length() > 0 && !PreprocessorUtils.containsOnlyWhiteSpaces(part.toString()) && !part.toString().equals(splitAround)) {
                parts.add(part.toString().trim());
            }
            String[] split = new String[parts.size()];
            for (int i = 0; i < split.length; ++i) {
                split[i] = (String)parts.get(i);
            }
            return split;
        }
        return null;
    }

    public static String[] splitValues(String value, String valueSeparator) {
        if (value != null && valueSeparator != null) {
            String[] split = ParserUtils.split(value, valueSeparator);
            if (value.endsWith(valueSeparator) && PreprocessorUtils.isSyntaxValid(split[split.length - 1]).booleanValue()) {
                String[] extendedSplit = new String[split.length + 1];
                for (int i = 0; i < split.length; ++i) {
                    extendedSplit[i] = split[i];
                }
                extendedSplit[split.length] = "";
                return extendedSplit;
            }
            for (int i = 0; i < split.length; ++i) {
                if ((!split[i].endsWith("\"") || !split[i].endsWith("\"")) && (!split[i].startsWith("'") || !split[i].endsWith("'"))) continue;
                split[i] = split[i].substring(1, split[i].length() - 1);
            }
            return split;
        }
        return null;
    }

    public static boolean contains(String value, String subString) {
        if (value != null && subString != null) {
            StringBuffer part = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (subString.startsWith("" + ch)) {
                    StringBuffer subPart = new StringBuffer(ch);
                    if (PreprocessorUtils.isSyntaxValid(part.toString()).booleanValue()) {
                        for (int j = 0; j < subString.length() && i + j < value.length(); ++j) {
                            subPart.append("" + value.charAt(i + j));
                            if (!subPart.toString().equals(subString)) continue;
                            return true;
                        }
                    }
                }
                part.append(ch);
            }
        }
        return false;
    }

    public static int lastIndexOf(String value, String subString) {
        int index = -1;
        if (value != null && subString != null) {
            StringBuffer part = new StringBuffer();
            block0: for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (subString.startsWith("" + ch)) {
                    StringBuffer subPart = new StringBuffer(ch);
                    if (PreprocessorUtils.isSyntaxValid(part.toString()).booleanValue()) {
                        for (int j = 0; j < subString.length() && i + j < value.length(); ++j) {
                            subPart.append(value.charAt(i + j));
                            if (!subPart.toString().equals(subString)) continue;
                            index = i;
                            part.delete(0, part.length());
                            if ((i += j + 1) >= value.length()) break block0;
                            ch = value.charAt(i);
                        }
                    }
                }
                part.append(ch);
            }
        }
        return index;
    }

    public static String getPadding(int numOfSpaces) {
        char[] arr = new char[numOfSpaces];
        Arrays.fill(arr, ' ');
        return new String(arr);
    }

    public static String trimBeginning(String stringToTrim) {
        if (stringToTrim.startsWith(" ")) {
            int i;
            for (i = 0; i < stringToTrim.length() && stringToTrim.charAt(i) == ' '; ++i) {
            }
            stringToTrim = stringToTrim.substring(i);
        }
        return stringToTrim;
    }
}

