/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;

public class LoadSharedConfigurationFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        InternalLocator locator = InternalLocator.getLocator();
        String memberName = locator.getDistributedSystem().getName();
        try {
            if (locator.isSharedConfigurationRunning()) {
                SharedConfiguration sc = locator.getSharedConfiguration();
                sc.loadSharedConfigurationFromDisk();
                CliFunctionResult cliFunctionResult = new CliFunctionResult(memberName, true, "Cluster configuration successfully imported");
                context.getResultSender().lastResult(cliFunctionResult);
            } else {
                CliFunctionResult cliFunctionResult = new CliFunctionResult(memberName, false, "Cluster configuration service is enabled but has not started yet.");
                context.getResultSender().lastResult(cliFunctionResult);
            }
        }
        catch (Exception e) {
            context.getResultSender().lastResult(new CliFunctionResult(memberName, e, CliUtil.stackTraceAsString(e)));
        }
    }

    @Override
    public String getId() {
        return LoadSharedConfigurationFunction.class.getName();
    }
}

