/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.configuration.utils.ZipUtils;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ExportSharedConfigurationFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        InternalLocator locator = InternalLocator.getLocator();
        String memberName = locator.getDistributedSystem().getName();
        if (locator.isSharedConfigurationRunning()) {
            SharedConfiguration sc = locator.getSharedConfiguration();
            Date date = new Date();
            new SimpleDateFormat("yyyyMMddhhmm").format(new Timestamp(date.getTime()));
            String zipFileName = CliStrings.format("cluster-config-{0}.zip", (Object)new Timestamp(date.getTime()).toString());
            String targetFilePath = FilenameUtils.concat((String)sc.getSharedConfigurationDirPath(), (String)zipFileName);
            try {
                ZipUtils.zip(sc.getSharedConfigurationDirPath(), targetFilePath);
                File zippedSharedConfig = new File(targetFilePath);
                byte[] zippedConfigData = FileUtils.readFileToByteArray((File)zippedSharedConfig);
                FileUtils.forceDelete((File)zippedSharedConfig);
                CliFunctionResult result = new CliFunctionResult(locator.getDistributedSystem().getName(), zippedConfigData, (Serializable[])new String[]{zipFileName});
                context.getResultSender().lastResult(result);
            }
            catch (Exception e) {
                context.getResultSender().lastResult(new CliFunctionResult(memberName, e, e.getMessage()));
            }
        } else {
            CliFunctionResult result = new CliFunctionResult(memberName, false, "Cluster configuration service is enabled but has not started yet.");
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ExportSharedConfigurationFunction.class.getName();
    }
}

