/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreConfigHolder;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalCache;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.util.HDFSStoreNotFoundException;
import org.apache.logging.log4j.Logger;

public class DescribeHDFSStoreFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    public static DescribeHDFSStoreFunction INSTANCE = new DescribeHDFSStoreFunction();
    private static final String ID = DescribeHDFSStoreFunction.class.getName();

    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    protected DistributedMember getDistributedMemberId(Cache cache) {
        return ((InternalCache)cache).getMyId();
    }

    @Override
    public void execute(FunctionContext context) {
        try {
            Cache cache = this.getCache();
            DistributedMember member = this.getDistributedMemberId(cache);
            if (cache instanceof GemFireCacheImpl) {
                GemFireCacheImpl cacheImpl = (GemFireCacheImpl)cache;
                String hdfsStoreName = (String)context.getArguments();
                String memberName = member.getName();
                HDFSStoreImpl hdfsStore = cacheImpl.findHDFSStore(hdfsStoreName);
                if (hdfsStore != null) {
                    HDFSStoreConfigHolder configHolder = new HDFSStoreConfigHolder(hdfsStore);
                    context.getResultSender().lastResult(configHolder);
                } else {
                    context.getResultSender().sendException(new HDFSStoreNotFoundException(String.format("A hdfs store with name (%1$s) was not found on member (%2$s).", hdfsStoreName, memberName)));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while executing 'describe hdfs-store': {}!", new Object[]{e.getMessage(), e});
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return ID;
    }
}

