/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.domain.IndexInfo;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;

public class CreateIndexFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        IndexInfo indexInfo = (IndexInfo)context.getArguments();
        String memberId = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            QueryService queryService = cache.getQueryService();
            String indexName = indexInfo.getIndexName();
            String indexedExpression = indexInfo.getIndexedExpression();
            String fromClause = indexInfo.getRegionPath();
            String[] regionPathTokens = fromClause.trim().split(" ");
            String regionPath = regionPathTokens[0];
            switch (indexInfo.getIndexType()) {
                case 1: {
                    queryService.createIndex(indexName, indexedExpression, fromClause);
                    break;
                }
                case 2: {
                    queryService.createKeyIndex(indexName, indexedExpression, fromClause);
                    break;
                }
                case 3: {
                    queryService.createHashIndex(indexName, indexedExpression, fromClause);
                    break;
                }
                default: {
                    queryService.createIndex(indexName, indexedExpression, fromClause);
                }
            }
            XmlEntity xmlEntity = new XmlEntity("region", "name", cache.getRegion(regionPath).getName());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
        }
        catch (IndexExistsException e) {
            String message = CliStrings.format("Index \"{0}\" already exists.  Create failed due to duplicate definition.", (Object)indexInfo.getIndexName());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, message));
        }
        catch (IndexNameConflictException e) {
            String message = CliStrings.format("Index \"{0}\" already exists.  Create failed due to duplicate name.", (Object)indexInfo.getIndexName());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, message));
        }
        catch (RegionNotFoundException e) {
            String message = CliStrings.format("Region not found : \"{0}\"", (Object)indexInfo.getRegionPath());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, message));
        }
        catch (IndexInvalidException e) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, e.getMessage()));
        }
        catch (Exception e) {
            String exceptionMessage = CliStrings.format("Exception : {0} , Message : {1}", e.getClass().getName(), e.getMessage());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, e.getMessage()));
        }
    }

    @Override
    public String getId() {
        return CreateIndexFunction.class.getName();
    }
}

