/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.DiskStoreAttributes;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class CreateDiskStoreFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Object[] args = (Object[])context.getArguments();
            String diskStoreName = (String)args[0];
            DiskStoreAttributes diskStoreAttrs = (DiskStoreAttributes)args[1];
            GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
            InternalDistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory(diskStoreAttrs);
            diskStoreFactory.create(diskStoreName);
            XmlEntity xmlEntity = new XmlEntity("disk-store", "name", diskStoreName);
            context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity, "Success"));
        }
        catch (CacheClosedException cce) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, null));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not create disk store: {}", new Object[]{th.getMessage(), th});
            context.getResultSender().lastResult(new CliFunctionResult(memberId, th, null));
        }
    }

    @Override
    public String getId() {
        return CreateDiskStoreFunction.class.getName();
    }
}

