/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.MultiIndexCreationException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.domain.IndexInfo;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateDefinedIndexesFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = null;
        List<Index> indexes = null;
        Cache cache = null;
        try {
            cache = CacheFactory.getAnyInstance();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            QueryService queryService = cache.getQueryService();
            Set indexDefinitions = (Set)context.getArguments();
            for (IndexInfo indexDefinition : indexDefinitions) {
                String indexName = indexDefinition.getIndexName();
                String indexedExpression = indexDefinition.getIndexedExpression();
                String regionPath = indexDefinition.getRegionPath();
                if (indexDefinition.getIndexType() == 2) {
                    queryService.defineKeyIndex(indexName, indexedExpression, regionPath);
                    continue;
                }
                if (indexDefinition.getIndexType() == 3) {
                    queryService.defineHashIndex(indexName, indexedExpression, regionPath);
                    continue;
                }
                queryService.defineIndex(indexName, indexedExpression, regionPath);
            }
            indexes = queryService.createDefinedIndexes();
            context.getResultSender().lastResult(new CliFunctionResult(memberId));
        }
        catch (MultiIndexCreationException e) {
            StringBuffer sb = new StringBuffer();
            sb.append("Index creation failed for indexes: ").append("\n");
            for (Map.Entry<String, Exception> failedIndex : e.getExceptionsMap().entrySet()) {
                sb.append(failedIndex.getKey()).append(" : ").append(failedIndex.getValue().getMessage()).append("\n");
            }
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, sb.toString()));
        }
        catch (Exception e) {
            String exceptionMessage = CliStrings.format("Exception : {0} , Message : {1}", e.getClass().getName(), e.getMessage());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, exceptionMessage));
        }
    }

    public void createCommandObject(IndexInfo info) {
        Cache cache = CacheFactory.getAnyInstance();
        QueryService queryService = cache.getQueryService();
    }

    @Override
    public String getId() {
        return CreateDefinedIndexesFunction.class.getName();
    }
}

