/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.domain.MemberResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;

public class CloseDurableCqFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext context) {
        Cache cache = CliUtil.getCacheIfExists();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        CacheClientNotifier cacheClientNotifier = CacheClientNotifier.getInstance();
        String[] args = (String[])context.getArguments();
        String durableClientId = args[0];
        String cqName = args[1];
        MemberResult memberResult = new MemberResult(memberNameOrId);
        try {
            if (cacheClientNotifier != null) {
                CacheClientProxy cacheClientProxy = cacheClientNotifier.getClientProxy(durableClientId);
                if (cacheClientProxy != null) {
                    if (cacheClientNotifier.closeClientCq(durableClientId, cqName)) {
                        memberResult.setSuccessMessage(CliStrings.format("Closed the durable cq : \"{0}\" for the durable client : \"{1}\".", cqName, durableClientId));
                    } else {
                        memberResult.setErrorMessage(CliStrings.format("Unable to close the durable cq : \"{0}\" for the durable client : \"{1}\".", cqName, durableClientId));
                    }
                } else {
                    memberResult.setErrorMessage(CliStrings.format("No client found with client-id : {0}", (Object)durableClientId));
                }
            } else {
                memberResult.setErrorMessage("No client found on this server");
            }
        }
        catch (Exception e) {
            memberResult.setExceptionMessage(e.getMessage());
        }
        finally {
            context.getResultSender().lastResult(memberResult);
        }
    }

    @Override
    public String getId() {
        return CloseDurableCqFunction.class.getName();
    }
}

