/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import java.util.Map;
import java.util.Set;

public class AlterRuntimeConfigFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Object arg = context.getArguments();
            Object trueCache = null;
            GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
            DistributionConfig config = cache.getSystem().getConfig();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            Map runtimeAttributes = (Map)arg;
            Set entries = runtimeAttributes.entrySet();
            for (Map.Entry entry : entries) {
                String attributeName = (String)entry.getKey();
                String attributeValue = (String)entry.getValue();
                if (attributeName.equals("copy-on-read")) {
                    cache.setCopyOnRead(Boolean.parseBoolean(attributeValue));
                    continue;
                }
                if (attributeName.equals("lock-lease")) {
                    cache.setLockLease(Integer.parseInt(attributeValue));
                    continue;
                }
                if (attributeName.equals("lock-timeout")) {
                    int lockTimeout = Integer.parseInt(attributeValue);
                    cache.setLockTimeout(lockTimeout);
                    continue;
                }
                if (attributeName.equals("search-timeout")) {
                    cache.setSearchTimeout(Integer.parseInt(attributeValue));
                    continue;
                }
                if (attributeName.equals("message-sync-interval")) {
                    cache.setMessageSyncInterval(Integer.parseInt(attributeValue));
                    continue;
                }
                config.setAttribute(attributeName, attributeValue, ConfigSource.runtime());
            }
            CliFunctionResult cliFuncResult = new CliFunctionResult(memberId, true, null);
            context.getResultSender().lastResult(cliFuncResult);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (Exception e) {
            CliFunctionResult cliFuncResult = new CliFunctionResult(memberId, e, CliUtil.stackTraceAsString(e));
            context.getResultSender().lastResult(cliFuncResult);
        }
    }

    @Override
    public String getId() {
        return AlterRuntimeConfigFunction.class.getName();
    }
}

