/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.domain;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.management.internal.cli.domain.RegionDescriptionPerMember;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RegionDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private boolean isPartition;
    private boolean isPersistent;
    private boolean isReplicate;
    private boolean haslocalDataStorage;
    private boolean isLocal = false;
    private boolean isReplicatedProxy = false;
    private boolean isAccessor = false;
    private Map<String, String> cndRegionAttributes;
    private Map<String, String> cndPartitionAttributes;
    private Map<String, String> cndEvictionAttributes;
    private Map<String, RegionDescriptionPerMember> regionDescPerMemberMap = null;
    private Scope scope;
    private DataPolicy dataPolicy;

    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean add(RegionDescriptionPerMember regionDescPerMember) {
        boolean isAdded = false;
        if (this.regionDescPerMemberMap == null) {
            this.regionDescPerMemberMap = new HashMap<String, RegionDescriptionPerMember>();
            this.regionDescPerMemberMap.put(regionDescPerMember.getHostingMember(), regionDescPerMember);
            this.scope = regionDescPerMember.getScope();
            this.dataPolicy = regionDescPerMember.getDataPolicy();
            this.name = regionDescPerMember.getName();
            this.isPartition = this.dataPolicy.withPartitioning();
            this.isPersistent = this.dataPolicy.withPersistence();
            this.isReplicate = this.dataPolicy.withReplication();
            this.haslocalDataStorage = this.dataPolicy.withStorage();
            this.isLocal = this.scope.isLocal();
            this.isAccessor = regionDescPerMember.isAccessor();
            this.cndRegionAttributes = new HashMap<String, String>();
            this.cndRegionAttributes.putAll(regionDescPerMember.getNonDefaultRegionAttributes());
            this.cndPartitionAttributes = new HashMap<String, String>();
            this.cndPartitionAttributes.putAll(regionDescPerMember.getNonDefaultPartitionAttributes());
            this.cndEvictionAttributes = new HashMap<String, String>();
            this.cndEvictionAttributes.putAll(regionDescPerMember.getNonDefaultEvictionAttributes());
            if (this.dataPolicy.equals(DataPolicy.EMPTY) && this.scope.equals(Scope.DISTRIBUTED_ACK)) {
                this.isReplicatedProxy = true;
            }
            isAdded = true;
        } else if (this.scope.equals(regionDescPerMember.getScope()) && this.name.equals(regionDescPerMember.getName()) && this.dataPolicy.equals(regionDescPerMember.getDataPolicy()) && this.isAccessor == regionDescPerMember.isAccessor()) {
            this.regionDescPerMemberMap.put(regionDescPerMember.getHostingMember(), regionDescPerMember);
            this.findCommon(this.cndRegionAttributes, regionDescPerMember.getNonDefaultRegionAttributes());
            this.findCommon(this.cndEvictionAttributes, regionDescPerMember.getNonDefaultEvictionAttributes());
            this.findCommon(this.cndPartitionAttributes, regionDescPerMember.getNonDefaultPartitionAttributes());
            isAdded = true;
        }
        return isAdded;
    }

    private void findCommon(Map<String, String> commonNdMap, Map<String, String> incomingNdMap) {
        Set<String> commonNdKeySet = commonNdMap.keySet();
        Set<String> incomingNdKeySet = incomingNdMap.keySet();
        commonNdKeySet.retainAll(incomingNdKeySet);
        for (String attribute : new HashSet<String>(commonNdKeySet)) {
            String commonNdValue = commonNdMap.get(attribute);
            String incomingNdValue = incomingNdMap.get(attribute);
            if (commonNdValue != null) {
                if (commonNdValue.equals(incomingNdValue)) continue;
                commonNdMap.remove(attribute);
                continue;
            }
            if (incomingNdValue == null) continue;
            commonNdMap.remove(attribute);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegionDescription) {
            RegionDescription regionDesc = (RegionDescription)obj;
            return this.getName().equals(regionDesc.getName()) && this.scope.equals(regionDesc.getScope()) && this.dataPolicy.equals(regionDesc.getDataPolicy());
        }
        return true;
    }

    public int hashCode() {
        return 42;
    }

    public Set<String> getHostingMembers() {
        return this.regionDescPerMemberMap.keySet();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isPartition() {
        return this.isPartition;
    }

    public boolean isReplicate() {
        return this.isReplicate;
    }

    public boolean hasLocalStorage() {
        return this.haslocalDataStorage;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isReplicatedProxy() {
        return this.isReplicatedProxy;
    }

    public boolean isAccessor() {
        return this.isAccessor;
    }

    public Map<String, String> getCndRegionAttributes() {
        return this.cndRegionAttributes;
    }

    public Map<String, String> getCndEvictionAttributes() {
        return this.cndEvictionAttributes;
    }

    public Map<String, String> getCndPartitionAttributes() {
        return this.cndPartitionAttributes;
    }

    public Map<String, RegionDescriptionPerMember> getRegionDescriptionPerMemberMap() {
        return this.regionDescPerMemberMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }
}

