/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.domain;

import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.management.internal.cli.domain.FixedPartitionAttributesInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PartitionAttributesInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int totalNumBuckets = 0;
    private int localMaxMemory = 0;
    private int redundantCopies = 0;
    private String colocatedWith = "";
    private long recoveryDelay = 0L;
    private long startupRecoveryDelay = 0L;
    private String partitionResolverName = "";
    private List<FixedPartitionAttributesInfo> fpaInfoList;
    private Map<String, String> nonDefaultAttributes;

    public PartitionAttributesInfo(PartitionAttributes<?, ?> partitionAttributes) {
        List<FixedPartitionAttributes> fpaList;
        this.totalNumBuckets = partitionAttributes.getTotalNumBuckets();
        this.localMaxMemory = partitionAttributes.getLocalMaxMemory();
        this.redundantCopies = partitionAttributes.getRedundantCopies();
        this.colocatedWith = partitionAttributes.getColocatedWith();
        this.recoveryDelay = partitionAttributes.getRecoveryDelay();
        this.startupRecoveryDelay = partitionAttributes.getStartupRecoveryDelay();
        PartitionResolver<?, ?> partitionResolver = partitionAttributes.getPartitionResolver();
        if (partitionResolver != null) {
            this.partitionResolverName = partitionResolver.getName();
        }
        if ((fpaList = partitionAttributes.getFixedPartitionAttributes()) != null) {
            Iterator<FixedPartitionAttributes> iters = fpaList.iterator();
            this.fpaInfoList = new ArrayList<FixedPartitionAttributesInfo>();
            while (iters.hasNext()) {
                FixedPartitionAttributes fpa = iters.next();
                FixedPartitionAttributesInfo fpaInfo = new FixedPartitionAttributesInfo(fpa);
                this.fpaInfoList.add(fpaInfo);
            }
        }
        this.nonDefaultAttributes = new HashMap<String, String>();
        if (this.totalNumBuckets != 113) {
            this.nonDefaultAttributes.put("total-num-buckets", Integer.toString(this.totalNumBuckets));
        }
        if (this.localMaxMemory != ((PartitionAttributesImpl)partitionAttributes).getLocalMaxMemoryDefault()) {
            this.nonDefaultAttributes.put("local-max-memory", Integer.toString(this.localMaxMemory));
        }
        if (this.redundantCopies != 0) {
            this.nonDefaultAttributes.put("redundant-copies", Integer.toString(this.redundantCopies));
        }
        if (this.colocatedWith != null && !this.colocatedWith.equals("")) {
            this.nonDefaultAttributes.put("colocated with", this.colocatedWith);
        }
        if (this.recoveryDelay != -1L) {
            this.nonDefaultAttributes.put("recovery-delay", Long.toString(this.recoveryDelay));
        }
        if (this.startupRecoveryDelay != 0L) {
            this.nonDefaultAttributes.put("startup-recovery-delay", Long.toString(this.startupRecoveryDelay));
        }
        if (this.partitionResolverName != null && !this.partitionResolverName.equals("")) {
            this.nonDefaultAttributes.put("partition-resolver", this.partitionResolverName);
        }
    }

    public int getTotalNumBuckets() {
        return this.totalNumBuckets;
    }

    public int getLocalMaxMemory() {
        return this.localMaxMemory;
    }

    public int getRedundantCopies() {
        return this.redundantCopies;
    }

    public String getColocatedWith() {
        return this.colocatedWith;
    }

    public long getRecoveryDelay() {
        return this.recoveryDelay;
    }

    public long getStartupRecoveryDelay() {
        return this.startupRecoveryDelay;
    }

    public String getPartitionResolverName() {
        return this.partitionResolverName;
    }

    public List<FixedPartitionAttributesInfo> getFixedPartitionAttributesInfo() {
        return this.fpaInfoList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PartitionAttributesInfo) {
            PartitionAttributesInfo paInfo = (PartitionAttributesInfo)obj;
            return this.getColocatedWith() == paInfo.getColocatedWith() && this.getLocalMaxMemory() == paInfo.getLocalMaxMemory() && this.getPartitionResolverName() == paInfo.getPartitionResolverName() && this.getRecoveryDelay() == paInfo.getRecoveryDelay() && this.getRedundantCopies() == paInfo.getRedundantCopies() && this.getStartupRecoveryDelay() == paInfo.getStartupRecoveryDelay() && this.getTotalNumBuckets() == paInfo.getTotalNumBuckets() && this.getFixedPartitionAttributesInfo().equals(paInfo.getFixedPartitionAttributesInfo());
        }
        return false;
    }

    public int hashCode() {
        return 42;
    }

    public Map<String, String> getNonDefaultAttributes() {
        return this.nonDefaultAttributes;
    }
}

