/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.domain;

import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.management.internal.cli.util.RegionAttributesDefault;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EvictionAttributesInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String evictionAction = "";
    private String evictionAlgorithm = "";
    private int evictionMaxValue = 0;
    private Map<String, String> nonDefaultAttributes;

    public EvictionAttributesInfo(EvictionAttributes ea) {
        EvictionAlgorithm evictionAlgo;
        EvictionAction evictAction = ea.getAction();
        if (evictAction != null) {
            this.evictionAction = evictAction.toString();
        }
        if ((evictionAlgo = ea.getAlgorithm()) != null) {
            this.evictionAlgorithm = evictionAlgo.toString();
        }
        if (!EvictionAlgorithm.LRU_HEAP.equals(evictionAlgo)) {
            this.evictionMaxValue = ea.getMaximum();
        }
    }

    public String getEvictionAction() {
        return this.evictionAction;
    }

    public String getEvictionAlgorithm() {
        return this.evictionAlgorithm;
    }

    public int getEvictionMaxValue() {
        return this.evictionMaxValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EvictionAttributesInfo) {
            EvictionAttributesInfo their = (EvictionAttributesInfo)obj;
            return this.evictionAction.equals(their.getEvictionAction()) && this.evictionAlgorithm.equals(their.getEvictionAlgorithm()) && this.evictionMaxValue == their.getEvictionMaxValue();
        }
        return false;
    }

    public int hashCode() {
        return 42;
    }

    public Map<String, String> getNonDefaultAttributes() {
        if (this.nonDefaultAttributes == null) {
            this.nonDefaultAttributes = new HashMap<String, String>();
        }
        if ((long)this.evictionMaxValue != 0L) {
            this.nonDefaultAttributes.put("eviction-maximum-value", Long.toString(this.evictionMaxValue));
        }
        if (this.evictionAction != null && !this.evictionAction.equals(RegionAttributesDefault.EVICTION_ACTION)) {
            this.nonDefaultAttributes.put("eviction-action", this.evictionAction);
        }
        if (this.evictionAlgorithm != null && !this.evictionAlgorithm.equals(RegionAttributesDefault.EVICTION_ALGORITHM)) {
            this.nonDefaultAttributes.put("eviction-algorithm", this.evictionAlgorithm);
        }
        return this.nonDefaultAttributes;
    }
}

