/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.converters;

import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class MemberIdNameConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && "converter.hint.member.idOrName".equals(optionContext);
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if (String.class.equals(targetType) && "converter.hint.member.idOrName".equals(optionContext)) {
            Set<String> memberIdAndNames = this.getMemberIdAndNames();
            for (String string : memberIdAndNames) {
                completions.add(new Completion(string));
            }
        }
        return !completions.isEmpty();
    }

    private Set<String> getMemberIdAndNames() {
        TreeSet<String> nonLocatorMembers = new TreeSet<String>();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady()) {
            nonLocatorMembers.addAll(Arrays.asList(gfsh.getOperationInvoker().getDistributedSystemMXBean().listMembers()));
            String[] locatorMembers = gfsh.getOperationInvoker().getDistributedSystemMXBean().listLocatorMembers(true);
            if (locatorMembers != null && locatorMembers.length != 0) {
                nonLocatorMembers.removeAll(Arrays.asList(locatorMembers));
            }
        }
        return nonLocatorMembers;
    }
}

