/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.converters;

import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class HelpConverter
implements Converter<String> {
    public String convertFromText(String existingData, Class<?> dataType, String optionContext) {
        if (optionContext.equals("help:disable-string-converter")) {
            return existingData.replaceAll("\"", "").replaceAll("'", "");
        }
        return null;
    }

    public boolean getAllPossibleValues(List<Completion> completionCandidates, Class<?> dataType, String existingData, String optionContext, MethodTarget arg4) {
        List<String> commandNames = Gfsh.getCurrentInstance().obtainHelpCommandNames(existingData);
        for (String string : commandNames) {
            completionCandidates.add(new Completion(string));
        }
        return completionCandidates.size() > 0;
    }

    public boolean supports(Class<?> arg0, String optionContext) {
        return String.class.isAssignableFrom(arg0) && optionContext.equals("help:disable-string-converter");
    }
}

