/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.converters;

import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class DiskStoreNameConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && "converter.hint.cluster.diskstore".equals(optionContext);
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if (String.class.equals(targetType) && "converter.hint.cluster.diskstore".equals(optionContext)) {
            Set<String> diskStoreNames = this.getDiskStoreNames();
            for (String diskStoreName : diskStoreNames) {
                if (existingData != null) {
                    if (!diskStoreName.startsWith(existingData)) continue;
                    completions.add(new Completion(diskStoreName));
                    continue;
                }
                completions.add(new Completion(diskStoreName));
            }
        }
        return !completions.isEmpty();
    }

    private Set<String> getDiskStoreNames() {
        Map<String, String[]> diskStoreInfo;
        TreeSet<String> diskStoreNames = new TreeSet<String>();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady() && (diskStoreInfo = gfsh.getOperationInvoker().getDistributedSystemMXBean().listMemberDiskstore()) != null) {
            Set<Map.Entry<String, String[]>> entries = diskStoreInfo.entrySet();
            for (Map.Entry<String, String[]> entry : entries) {
                String[] value = entry.getValue();
                if (value == null) continue;
                diskStoreNames.addAll(Arrays.asList(value));
            }
        }
        return diskStoreNames;
    }
}

