/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands.dto;

import com.gemstone.gemfire.management.internal.cli.json.GfJsonObject;
import com.gemstone.gemfire.management.internal.cli.result.CliJsonSerializable;
import com.gemstone.gemfire.management.internal.cli.util.JsonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RegionMemberDetails
implements CliJsonSerializable {
    private static Map<String, String> nameToDisplayName = new HashMap<String, String>();
    private String id;
    private long primaryEntryCount;
    private long backupEntryCount;
    private String memory;
    private int numOfCopies;
    private int numOfBuckets;
    private String[] fieldsToSkipOnUI;

    public RegionMemberDetails() {
    }

    public RegionMemberDetails(String id, long primaryEntryCount, long backupEntryCount, String memory, int numOfCopies, int numOfBuckets) {
        this.id = id;
        this.primaryEntryCount = primaryEntryCount;
        this.backupEntryCount = backupEntryCount;
        this.memory = memory;
        this.numOfCopies = numOfCopies;
        this.numOfBuckets = numOfBuckets;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getPrimaryEntryCount() {
        return this.primaryEntryCount;
    }

    public void setPrimaryEntryCount(long primaryEntryCount) {
        this.primaryEntryCount = primaryEntryCount;
    }

    public long getBackupEntryCount() {
        return this.backupEntryCount;
    }

    public void setBackupEntryCount(long backupEntryCount) {
        this.backupEntryCount = backupEntryCount;
    }

    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public int getNumOfCopies() {
        return this.numOfCopies;
    }

    public void setNumOfCopies(int numOfCopies) {
        this.numOfCopies = numOfCopies;
    }

    public int getNumOfBuckets() {
        return this.numOfBuckets;
    }

    public void setNumOfBuckets(int numOfBuckets) {
        this.numOfBuckets = numOfBuckets;
    }

    @Override
    public int getJSId() {
        return 13;
    }

    @Override
    public Map<String, String> getFieldNameToDisplayName() {
        return nameToDisplayName;
    }

    @Override
    public String[] getFieldsToSkipOnUI() {
        return this.fieldsToSkipOnUI;
    }

    @Override
    public void setFieldsToSkipOnUI(String ... fieldsToSkipOnUI) {
        this.fieldsToSkipOnUI = fieldsToSkipOnUI;
    }

    @Override
    public void fromJson(GfJsonObject objectStateAsjson) {
        this.id = JsonUtil.getString(objectStateAsjson, "id");
        this.primaryEntryCount = JsonUtil.getLong(objectStateAsjson, "primaryEntryCount");
        this.backupEntryCount = JsonUtil.getLong(objectStateAsjson, "backupEntryCount");
        this.memory = JsonUtil.getString(objectStateAsjson, "memory");
        this.numOfCopies = JsonUtil.getInt(objectStateAsjson, "numOfCopies");
        this.numOfBuckets = JsonUtil.getInt(objectStateAsjson, "numOfBuckets");
        this.fieldsToSkipOnUI = JsonUtil.getStringArray(objectStateAsjson, "fieldsToSkipOnUI");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.backupEntryCount ^ this.backupEntryCount >>> 32);
        result = 31 * result + Arrays.hashCode(this.fieldsToSkipOnUI);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.memory == null ? 0 : this.memory.hashCode());
        result = 31 * result + this.numOfBuckets;
        result = 31 * result + this.numOfCopies;
        result = 31 * result + (int)(this.primaryEntryCount ^ this.primaryEntryCount >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionMemberDetails other = (RegionMemberDetails)obj;
        if (this.backupEntryCount != other.backupEntryCount) {
            return false;
        }
        if (!Arrays.equals(this.fieldsToSkipOnUI, other.fieldsToSkipOnUI)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.memory == null ? other.memory != null : !this.memory.equals(other.memory)) {
            return false;
        }
        if (this.numOfBuckets != other.numOfBuckets) {
            return false;
        }
        if (this.numOfCopies != other.numOfCopies) {
            return false;
        }
        return this.primaryEntryCount == other.primaryEntryCount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegionMemberDetails [id=");
        builder.append(this.id);
        builder.append(", primaryEntryCount=");
        builder.append(this.primaryEntryCount);
        builder.append(", backupEntryCount=");
        builder.append(this.backupEntryCount);
        builder.append(", memory=");
        builder.append(this.memory);
        builder.append(", numOfCopies=");
        builder.append(this.numOfCopies);
        builder.append(", numOfBuckets=");
        builder.append(this.numOfBuckets);
        builder.append("]");
        return builder.toString();
    }

    static {
        nameToDisplayName.put("id", "Member Id");
        nameToDisplayName.put("primaryEntryCount", "PrimaryEntryCount");
        nameToDisplayName.put("backupEntryCount", "BbackupEntryCount");
        nameToDisplayName.put("memory", "Memory");
        nameToDisplayName.put("numOfCopies", "NumOfCopies");
        nameToDisplayName.put("numOfBuckets", "NumOfBuckets");
    }
}

