/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.internal.cache.CacheConfig;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.commands.AbstractCommandsSupport;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.InfoResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.configuration.SharedConfigurationWriter;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import com.gemstone.gemfire.pdx.ReflectionBasedAutoSerializer;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class PDXCommands
extends AbstractCommandsSupport {
    @CliCommand(value={"configure pdx"}, help="Configures GemFire's Portable Data eXchange for all the cache(s) in the cluster. This command would not take effect on the running members in the system.\n This command persists the pdx configuration in the locator with cluster configuration service. \n This command should be issued before starting any data members.")
    @CliMetaData(relatedTopic={"Region"}, writesToSharedConfiguration=true)
    public Result configurePDX(@CliOption(key={"read-serialized"}, unspecifiedDefaultValue="__NULL__", help="Set to true to have PDX deserialization produce a PdxInstance instead of an instance of the domain class") Boolean readSerialized, @CliOption(key={"ignore-unread-fields"}, unspecifiedDefaultValue="__NULL__", help="Control whether pdx ignores fields that were unread during deserialization. The default is to preserve unread fields be including their data during serialization. But if you configure the cache to ignore unread fields then their data will be lost during serialization.You should only set this attribute to true if you know this member will only be reading cache data. In this use case you do not need to pay the cost of preserving the unread fields since you will never be reserializing pdx data.") Boolean ignoreUnreadFields, @CliOption(key={"disk-store"}, unspecifiedDefaultValue="__NULL__", specifiedDefaultValue="", help="Named disk store where the PDX type data will be stored") String diskStore, @CliMetaData(valueSeparator=",") @CliOption(key={"auto-serializable-classes"}, unspecifiedDefaultValue="__NULL__", specifiedDefaultValue="__NULL__", help="the patterns which are matched against domain class names to determine whether they should be serialized, serialization done by the auto-serializer will throw an exception if the object of these classes are not portable to non-java languages") String[] patterns, @CliMetaData(valueSeparator=",") @CliOption(key={"portable-auto-serializable-classes"}, unspecifiedDefaultValue="__NULL__", specifiedDefaultValue="__NULL__", help="the patterns which are matched against domain class names to determine whether they should be serialized") String[] portablePatterns) {
        Result result = null;
        try {
            InfoResultData ird = ResultBuilder.createInfoResultData();
            CacheCreation cache = new CacheCreation(true);
            if (portablePatterns != null && portablePatterns.length > 0 && patterns != null && patterns.length > 0) {
                return ResultBuilder.createUserErrorResult("The autoserializer cannot support both portable and non-portable classes at the same time.");
            }
            if (CliUtil.getAllNormalMembers(CliUtil.getCacheIfExists()).isEmpty()) {
                ird.addLine("The command would only take effect on new data members joining the distributed system. It won't affect the existing data members");
            }
            if (diskStore != null) {
                cache.setPdxPersistent(true);
                ird.addLine("persistent = " + cache.getPdxPersistent());
                if (!diskStore.equals("")) {
                    cache.setPdxDiskStore(diskStore);
                    ird.addLine("disk-store = " + cache.getPdxDiskStore());
                } else {
                    ird.addLine("disk-store = DEFAULT");
                }
            } else {
                cache.setPdxPersistent(CacheConfig.DEFAULT_PDX_PERSISTENT);
                ird.addLine("persistent = " + cache.getPdxPersistent());
            }
            if (readSerialized != null) {
                cache.setPdxReadSerialized(readSerialized);
            } else {
                cache.setPdxReadSerialized(CacheConfig.DEFAULT_PDX_READ_SERIALIZED);
            }
            ird.addLine("read-serialized = " + cache.getPdxReadSerialized());
            if (ignoreUnreadFields != null) {
                cache.setPdxIgnoreUnreadFields(ignoreUnreadFields);
            } else {
                cache.setPdxIgnoreUnreadFields(CacheConfig.DEFAULT_PDX_IGNORE_UNREAD_FIELDS);
            }
            ird.addLine("ignore-unread-fields = " + cache.getPdxIgnoreUnreadFields());
            if (portablePatterns != null) {
                ReflectionBasedAutoSerializer autoSerializer = new ReflectionBasedAutoSerializer(portablePatterns);
                cache.setPdxSerializer(autoSerializer);
                ird.addLine("PDX Serializer " + cache.getPdxSerializer().getClass().getName());
                ird.addLine("Portable classes " + Arrays.toString(portablePatterns));
            }
            if (patterns != null) {
                ReflectionBasedAutoSerializer nonPortableAutoSerializer = new ReflectionBasedAutoSerializer(true, patterns);
                cache.setPdxSerializer(nonPortableAutoSerializer);
                ird.addLine("PDX Serializer : " + cache.getPdxSerializer().getClass().getName());
                ird.addLine("Non portable classes :" + Arrays.toString(patterns));
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            CacheXmlGenerator.generate(cache, printWriter, true, false, false);
            printWriter.close();
            String xmlDefinition = stringWriter.toString();
            XmlEntity xmlEntity = XmlEntity.builder().withType("pdx").withConfig(xmlDefinition).build();
            SharedConfigurationWriter scWriter = new SharedConfigurationWriter();
            boolean commandPersisted = scWriter.addXmlEntity(xmlEntity, null);
            result = ResultBuilder.buildResult(ird);
            result.setCommandPersisted(commandPersisted);
        }
        catch (Exception e) {
            return ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }

    @CliAvailabilityIndicator(value={"configure pdx"})
    public boolean isRegionCommandAvailable() {
        if (!CliUtil.isGfshVM()) {
            return true;
        }
        return this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
    }

    @CliCommand(value={"pdx rename"}, help="Renames PDX types in an offline disk store. \n Any pdx types that are renamed will be listed in the output. \n If no renames are done or the disk-store is online then this command will fail.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result pdxRename(@CliOption(key={"old"}, mandatory=true, help="If a PDX type's fully qualified class name has a word that matches this text then it will be renamed. Words are delimited by '.' and '$'.") String oldClassName, @CliOption(key={"new"}, mandatory=true, help="The text to replace the word that matched old") String newClassName, @CliOption(key={"disk-store"}, mandatory=true, help="Name of the disk store to operate on") String diskStore, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories which contain the disk store files") @CliMetaData(valueSeparator=",") String[] diskDirs) {
        try {
            File[] dirs = new File[diskDirs.length];
            for (int i = 0; i < diskDirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
            Collection<Object> results = DiskStoreImpl.pdxRename(diskStore, dirs, oldClassName, newClassName);
            if (results.isEmpty()) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("No Pdx types found to rename.", new Object[0]));
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(outputStream);
            for (Object p : results) {
                if (p instanceof PdxType) {
                    ((PdxType)p).toStream(printStream, false);
                    continue;
                }
                ((EnumInfo)p).toStream(printStream);
            }
            String resultString = CliStrings.format("Successfully renamed pdx types:\n{0}", (Object)outputStream.toString());
            return ResultBuilder.createInfoResult(resultString.toString());
        }
        catch (Exception e) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Error renaming pdx types : {0}", (Object)e.getMessage()));
        }
    }

    @CliAvailabilityIndicator(value={"pdx rename"})
    public boolean pdxRenameCommandsAvailable() {
        return true;
    }
}

