/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli;

import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.management.internal.cli.GfshParseResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CommandRequest {
    protected static final String OPTION_SPECIFIER = "--";
    private final byte[][] fileData;
    private final GfshParseResult parseResult;
    private final Map<String, String> customParameters = new HashMap<String, String>();
    private final Map<String, String> env;
    private String customInput;

    public CommandRequest(Map<String, String> env) {
        this.env = env;
        this.fileData = null;
        this.parseResult = null;
    }

    public CommandRequest(Map<String, String> env, byte[][] fileData) {
        this.env = env;
        this.fileData = fileData;
        this.parseResult = null;
    }

    public CommandRequest(GfshParseResult parseResult, Map<String, String> env) {
        this(parseResult, env, null);
    }

    public CommandRequest(GfshParseResult parseResult, Map<String, String> env, byte[][] fileData) {
        assert (parseResult != null) : "The Gfsh ParseResult cannot be null!";
        assert (env != null) : "The reference to the Gfsh CLI environment cannot be null!";
        this.env = env;
        this.fileData = fileData;
        this.parseResult = parseResult;
    }

    public String getName() {
        if (this.getUserInput() != null) {
            String[] userInputTokenized = this.getUserInput().split("\\s");
            StringBuilder buffer = new StringBuilder();
            for (String token : userInputTokenized) {
                if (token.startsWith(OPTION_SPECIFIER)) continue;
                buffer.append(token).append(" ");
            }
            return buffer.toString().trim();
        }
        return "unknown";
    }

    public String getCustomInput() {
        return this.customInput;
    }

    public void setCustomInput(String input) {
        this.customInput = input;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.env);
    }

    public byte[][] getFileData() {
        return this.fileData;
    }

    public boolean hasFileData() {
        return this.getFileData() != null;
    }

    public String getInput() {
        return StringUtils.defaultIfBlank(this.getCustomInput(), this.getUserInput());
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>(this.getUserParameters());
        parameters.putAll(this.getCustomParameters());
        return Collections.unmodifiableMap(parameters);
    }

    protected GfshParseResult getParseResult() {
        return this.parseResult;
    }

    public String getUserInput() {
        return this.getParseResult().getUserInput();
    }

    public Map<String, String> getUserParameters() {
        return this.getParseResult().getParamValueStrings();
    }
}

