/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans;

import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionStats;
import com.gemstone.gemfire.management.FixedPartitionAttributesData;
import com.gemstone.gemfire.management.PartitionAttributesData;
import com.gemstone.gemfire.management.internal.beans.HDFSRegionBridge;
import com.gemstone.gemfire.management.internal.beans.RegionMBeanBridge;
import com.gemstone.gemfire.management.internal.beans.RegionMBeanCompositeDataFactory;
import com.gemstone.gemfire.management.internal.beans.stats.MBeanStatsMonitor;
import com.gemstone.gemfire.management.internal.beans.stats.StatType;
import com.gemstone.gemfire.management.internal.beans.stats.StatsAverageLatency;
import com.gemstone.gemfire.management.internal.beans.stats.StatsLatency;
import com.gemstone.gemfire.management.internal.beans.stats.StatsRate;
import java.util.Set;

public class PartitionedRegionBridge<K, V>
extends RegionMBeanBridge<K, V> {
    private PartitionedRegionStats prStats;
    private PartitionedRegion parRegion;
    private PartitionAttributesData partitionAttributesData;
    private FixedPartitionAttributesData[] fixedPartitionAttributesTable;
    private int configuredRedundancy = -1;
    private MBeanStatsMonitor parRegionMonitor;
    private StatsRate putAllRate;
    private StatsRate putRequestRate;
    private StatsRate getRequestRate;
    private StatsRate createsRate;
    private StatsRate destroysRate;
    private StatsRate putLocalRate;
    private StatsRate putRemoteRate;
    private StatsLatency putRemoteLatency;
    private StatsRate averageWritesRate;
    private StatsRate averageReadsRate;
    private StatsAverageLatency remotePutAvgLatency;
    public static final String PAR_REGION_MONITOR = "PartitionedRegionMonitor";

    public static <K, V> PartitionedRegionBridge<K, V> getInstance(Region<K, V> region) {
        if (region.getAttributes().getDataPolicy().withHDFS()) {
            HDFSRegionBridge<K, V> bridge = new HDFSRegionBridge<K, V>(region);
            return bridge;
        }
        return new PartitionedRegionBridge<K, V>(region);
    }

    protected PartitionedRegionBridge(Region<K, V> region) {
        super(region);
        this.parRegion = (PartitionedRegion)region;
        this.prStats = this.parRegion.getPrStats();
        PartitionAttributes partAttrs = this.parRegion.getPartitionAttributes();
        this.parRegionMonitor = new MBeanStatsMonitor(PAR_REGION_MONITOR);
        this.configurePartitionRegionMetrics();
        this.configuredRedundancy = partAttrs.getRedundantCopies();
        this.partitionAttributesData = RegionMBeanCompositeDataFactory.getPartitionAttributesData(partAttrs);
        if (partAttrs.getFixedPartitionAttributes() != null) {
            this.fixedPartitionAttributesTable = RegionMBeanCompositeDataFactory.getFixedPartitionAttributesData(partAttrs);
        }
        this.parRegionMonitor.addStatisticsToMonitor(this.prStats.getStats());
    }

    public PartitionedRegionBridge(PartitionedRegionStats prStats) {
        this.prStats = prStats;
        this.parRegionMonitor = new MBeanStatsMonitor(PAR_REGION_MONITOR);
        this.parRegionMonitor.addStatisticsToMonitor(prStats.getStats());
        this.configurePartitionRegionMetrics();
    }

    private Number getPrStatistic(String statName) {
        if (this.prStats != null) {
            return this.prStats.getStats().get(statName);
        }
        return 0;
    }

    @Override
    public void stopMonitor() {
        super.stopMonitor();
        this.parRegionMonitor.stopListener();
    }

    private void configurePartitionRegionMetrics() {
        this.putAllRate = new StatsRate("putAllsCompleted", StatType.INT_TYPE, this.parRegionMonitor);
        this.putRequestRate = new StatsRate("putsCompleted", StatType.INT_TYPE, this.parRegionMonitor);
        this.getRequestRate = new StatsRate("getsCompleted", StatType.INT_TYPE, this.parRegionMonitor);
        this.destroysRate = new StatsRate("destroysCompleted", StatType.INT_TYPE, this.parRegionMonitor);
        this.createsRate = new StatsRate("createsCompleted", StatType.INT_TYPE, this.parRegionMonitor);
        this.putRemoteRate = new StatsRate("putRemoteCompleted", StatType.INT_TYPE, this.parRegionMonitor);
        this.putLocalRate = new StatsRate("putLocalCompleted", StatType.INT_TYPE, this.parRegionMonitor);
        this.remotePutAvgLatency = new StatsAverageLatency("putRemoteCompleted", StatType.INT_TYPE, "putRemoteTime", this.parRegionMonitor);
        this.putRemoteLatency = new StatsLatency("putRemoteCompleted", StatType.INT_TYPE, "putRemoteTime", this.parRegionMonitor);
        String[] writesRates = new String[]{"putAllsCompleted", "putsCompleted", "createsCompleted"};
        this.averageWritesRate = new StatsRate(writesRates, StatType.INT_TYPE, this.parRegionMonitor);
        this.averageReadsRate = new StatsRate("getsCompleted", StatType.INT_TYPE, this.parRegionMonitor);
    }

    @Override
    public float getAverageReads() {
        return this.averageReadsRate.getRate();
    }

    @Override
    public float getAverageWrites() {
        return this.averageWritesRate.getRate();
    }

    @Override
    public float getCreatesRate() {
        return this.createsRate.getRate();
    }

    @Override
    public float getPutAllRate() {
        return this.putAllRate.getRate();
    }

    @Override
    public float getPutsRate() {
        return this.putRequestRate.getRate();
    }

    @Override
    public float getDestroyRate() {
        return this.destroysRate.getRate();
    }

    @Override
    public float getGetsRate() {
        return this.getRequestRate.getRate();
    }

    @Override
    public int getActualRedundancy() {
        return this.getPrStatistic("actualRedundantCopies").intValue();
    }

    @Override
    public int getAvgBucketSize() {
        return -1;
    }

    @Override
    public int getBucketCount() {
        return this.getPrStatistic("bucketCount").intValue();
    }

    @Override
    public int getConfiguredRedundancy() {
        return this.configuredRedundancy;
    }

    @Override
    public int getNumBucketsWithoutRedundancy() {
        return this.getPrStatistic("lowRedundancyBucketCount").intValue();
    }

    @Override
    public int getPrimaryBucketCount() {
        return this.getPrStatistic("primaryBucketCount").intValue();
    }

    @Override
    public int getTotalBucketSize() {
        return this.getPrStatistic("dataStoreEntryCount").intValue();
    }

    @Override
    public PartitionAttributesData listPartitionAttributes() {
        return this.partitionAttributesData;
    }

    @Override
    public FixedPartitionAttributesData[] listFixedPartitionAttributes() {
        return this.fixedPartitionAttributesTable;
    }

    @Override
    public long getEntrySize() {
        if (this.parRegion.isDataStore()) {
            return this.getPrStatistic("dataStoreBytesInUse").longValue();
        }
        return 0L;
    }

    @Override
    public long getHitCount() {
        return -1L;
    }

    @Override
    public float getHitRatio() {
        return -1.0f;
    }

    @Override
    public long getLastAccessedTime() {
        return -1L;
    }

    @Override
    public long getLastModifiedTime() {
        return -1L;
    }

    @Override
    public long getPutRemoteAvgLatency() {
        return this.remotePutAvgLatency.getAverageLatency();
    }

    @Override
    public long getPutRemoteLatency() {
        return this.putRemoteLatency.getLatency();
    }

    @Override
    public float getPutLocalRate() {
        return this.putLocalRate.getRate();
    }

    @Override
    public float getPutRemoteRate() {
        return this.putRemoteRate.getRate();
    }

    @Override
    public long getEntryCount() {
        if (this.parRegion.isDataStore()) {
            int numLocalEntries = 0;
            Set<BucketRegion> localPrimaryBucketRegions = this.parRegion.getDataStore().getAllLocalPrimaryBucketRegions();
            if (localPrimaryBucketRegions != null && localPrimaryBucketRegions.size() > 0) {
                for (BucketRegion br : localPrimaryBucketRegions) {
                    numLocalEntries += br.getRegionMap().sizeInVM() - br.getTombstoneCount();
                }
            }
            return numLocalEntries;
        }
        return 0L;
    }

    @Override
    public int getLocalMaxMemory() {
        return this.partitionAttributesData.getLocalMaxMemory();
    }

    @Override
    public long getEstimatedSizeForHDFSRegion() {
        return -1L;
    }
}

