/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans;

import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.distributed.internal.ResourceEventsListener;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.internal.AlertDetails;
import com.gemstone.gemfire.management.internal.beans.ManagementAdapter;

public class ManagementListener
implements ResourceEventsListener {
    private ManagementAdapter adapter = new ManagementAdapter();
    private LogWriterI18n logger = InternalDistributedSystem.getLoggerI18n();

    private boolean shouldProceed(ResourceEvent event) {
        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
        if (system == null && !event.equals((Object)ResourceEvent.CACHE_REMOVE)) {
            return false;
        }
        GemFireCacheImpl currentCache = GemFireCacheImpl.getInstance();
        if (currentCache == null) {
            return false;
        }
        return !currentCache.isClosed();
    }

    @Override
    public void handleEvent(ResourceEvent event, Object resource) {
        if (!this.shouldProceed(event)) {
            return;
        }
        switch (event) {
            case CACHE_CREATE: {
                GemFireCacheImpl createdCache = (GemFireCacheImpl)resource;
                this.adapter.handleCacheCreation(createdCache);
                break;
            }
            case CACHE_REMOVE: {
                GemFireCacheImpl removedCache = (GemFireCacheImpl)resource;
                this.adapter.handleCacheRemoval(removedCache);
                break;
            }
            case REGION_CREATE: {
                Region createdRegion = (Region)resource;
                this.adapter.handleRegionCreation(createdRegion);
                break;
            }
            case REGION_REMOVE: {
                Region removedRegion = (Region)resource;
                this.adapter.handleRegionRemoval(removedRegion);
                break;
            }
            case DISKSTORE_CREATE: {
                DiskStore createdDisk = (DiskStore)resource;
                this.adapter.handleDiskCreation(createdDisk);
                break;
            }
            case DISKSTORE_REMOVE: {
                DiskStore removedDisk = (DiskStore)resource;
                this.adapter.handleDiskRemoval(removedDisk);
                break;
            }
            case GATEWAYRECEIVER_CREATE: {
                GatewayReceiver createdRecv = (GatewayReceiver)resource;
                this.adapter.handleGatewayReceiverCreate(createdRecv);
                break;
            }
            case GATEWAYRECEIVER_START: {
                GatewayReceiver startedRecv = (GatewayReceiver)resource;
                this.adapter.handleGatewayReceiverStart(startedRecv);
                break;
            }
            case GATEWAYRECEIVER_STOP: {
                GatewayReceiver stoppededRecv = (GatewayReceiver)resource;
                this.adapter.handleGatewayReceiverStop(stoppededRecv);
                break;
            }
            case GATEWAYSENDER_CREATE: {
                GatewaySender sender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderCreation(sender);
                break;
            }
            case GATEWAYSENDER_START: {
                GatewaySender startedSender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderStart(startedSender);
                break;
            }
            case GATEWAYSENDER_STOP: {
                GatewaySender stoppedSender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderStop(stoppedSender);
                break;
            }
            case GATEWAYSENDER_PAUSE: {
                GatewaySender pausedSender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderPaused(pausedSender);
                break;
            }
            case GATEWAYSENDER_RESUME: {
                GatewaySender resumedSender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderResumed(resumedSender);
                break;
            }
            case LOCKSERVICE_CREATE: {
                DLockService createdLockService = (DLockService)resource;
                this.adapter.handleLockServiceCreation(createdLockService);
                break;
            }
            case LOCKSERVICE_REMOVE: {
                DLockService removedLockService = (DLockService)resource;
                this.adapter.handleLockServiceRemoval(removedLockService);
                break;
            }
            case MANAGER_CREATE: {
                this.adapter.handleManagerCreation();
                break;
            }
            case MANAGER_START: {
                this.adapter.handleManagerStart();
                break;
            }
            case MANAGER_STOP: {
                this.adapter.handleManagerStop();
                break;
            }
            case ASYNCEVENTQUEUE_CREATE: {
                AsyncEventQueue queue = (AsyncEventQueue)resource;
                this.adapter.handleAsyncEventQueueCreation(queue);
                break;
            }
            case SYSTEM_ALERT: {
                AlertDetails details = (AlertDetails)resource;
                this.adapter.handleSystemNotification(details);
                break;
            }
            case CACHE_SERVER_START: {
                CacheServer startedServer = (CacheServer)resource;
                this.adapter.handleCacheServerStart(startedServer);
                break;
            }
            case CACHE_SERVER_STOP: {
                CacheServer stoppedServer = (CacheServer)resource;
                this.adapter.handleCacheServerStop(stoppedServer);
                break;
            }
            case LOCATOR_START: {
                Locator loc = (Locator)resource;
                this.adapter.handleLocatorStart(loc);
                break;
            }
        }
    }
}

